/* upload.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from upload.vala, do not modify */

/*
 * Seahorse
 *
 * Copyright (C) 2005 Stefan Walter
 * Copyright (C) 2011 Collabora Ltd.
 * Copyright (C) 2016 Niels De Graef
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see
 * <http://www.gnu.org/licenses/>.
 */

#include "seahorse-ssh.h"
#include <glib.h>
#include <gtk/gtk.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include "seahorse-common.h"
#include <glib/gi18n-lib.h>
#include "libseahorse/seahorse-progress.h"

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	SEAHORSE_SSH_UPLOAD_0_PROPERTY,
	SEAHORSE_SSH_UPLOAD_NUM_PROPERTIES
};
static GParamSpec* seahorse_ssh_upload_properties[SEAHORSE_SSH_UPLOAD_NUM_PROPERTIES];
typedef struct _Block9Data Block9Data;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _SeahorseSshUploadPrivate {
	GList* keys;
	GtkEntry* user_entry;
	GtkEntry* host_entry;
	GtkButton* setup_button;
};

struct _Block9Data {
	int _ref_count_;
	SeahorseSshUpload* self;
	SeahorseSshUploadOperation* op;
};

static gint SeahorseSshUpload_private_offset;
static gpointer seahorse_ssh_upload_parent_class = NULL;

static void seahorse_ssh_upload_on_upload_input_changed (SeahorseSshUpload* self);
static void seahorse_ssh_upload_upload_keys (SeahorseSshUpload* self);
static Block9Data* block9_data_ref (Block9Data* _data9_);
static void block9_data_unref (void * _userdata_);
static void __lambda15_ (Block9Data* _data9_,
                  GObject* obj,
                  GAsyncResult* res);
static void ___lambda15__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
static void _seahorse_ssh_upload_on_upload_input_changed_gtk_editable_changed (GtkEditable* _sender,
                                                                        gpointer self);
static void seahorse_ssh_upload_finalize (GObject * obj);
static GType seahorse_ssh_upload_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
seahorse_ssh_upload_get_instance_private (SeahorseSshUpload* self)
{
	return G_STRUCT_MEMBER_P (self, SeahorseSshUpload_private_offset);
}

SeahorseSshUpload*
seahorse_ssh_upload_construct (GType object_type,
                               GList* keys,
                               GtkWindow* parent)
{
	SeahorseSshUpload * self = NULL;
	GtkEntry* _tmp0_;
	const gchar* _tmp1_;
	GtkEntry* _tmp2_;
	self = (SeahorseSshUpload*) g_object_new (object_type, "use-header-bar", 1, NULL);
	gtk_window_set_transient_for ((GtkWindow*) self, parent);
	self->priv->keys = keys;
	_tmp0_ = self->priv->user_entry;
	_tmp1_ = g_get_user_name ();
	gtk_entry_set_text (_tmp0_, _tmp1_);
	_tmp2_ = self->priv->host_entry;
	gtk_widget_grab_focus ((GtkWidget*) _tmp2_);
	seahorse_ssh_upload_on_upload_input_changed (self);
	return self;
}

SeahorseSshUpload*
seahorse_ssh_upload_new (GList* keys,
                         GtkWindow* parent)
{
	return seahorse_ssh_upload_construct (SEAHORSE_SSH_TYPE_UPLOAD, keys, parent);
}

static Block9Data*
block9_data_ref (Block9Data* _data9_)
{
	g_atomic_int_inc (&_data9_->_ref_count_);
	return _data9_;
}

static void
block9_data_unref (void * _userdata_)
{
	Block9Data* _data9_;
	_data9_ = (Block9Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data9_->_ref_count_)) {
		SeahorseSshUpload* self;
		self = _data9_->self;
		_g_object_unref0 (_data9_->op);
		_g_object_unref0 (self);
		g_slice_free (Block9Data, _data9_);
	}
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

static void
__lambda15_ (Block9Data* _data9_,
             GObject* obj,
             GAsyncResult* res)
{
	SeahorseSshUpload* self;
	GError* _inner_error0_ = NULL;
	self = _data9_->self;
	g_return_if_fail (res != NULL);
	{
		SeahorseSshUploadOperation* _tmp0_;
		_tmp0_ = _data9_->op;
		seahorse_ssh_upload_operation_upload_finish (_tmp0_, res, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp1_;
		const gchar* _tmp2_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp1_ = e;
		_tmp2_ = _tmp1_->message;
		seahorse_util_show_error ((GtkWidget*) self, _ ("Couldn’t configure Secure Shell keys on remote computer."), _tmp2_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
___lambda15__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	__lambda15_ (self, source_object, res);
	block9_data_unref (self);
}

static void
seahorse_ssh_upload_upload_keys (SeahorseSshUpload* self)
{
	Block9Data* _data9_;
	gchar* user = NULL;
	GtkEntry* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* host_port = NULL;
	GtkEntry* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp9_ = FALSE;
	const gchar* _tmp10_;
	gchar** host_port_split = NULL;
	const gchar* _tmp13_;
	gchar** _tmp14_;
	gchar** _tmp15_;
	gint host_port_split_length1;
	gint _host_port_split_size_;
	gchar* host = NULL;
	gchar** _tmp16_;
	gint _tmp16__length1;
	const gchar* _tmp17_;
	gchar* _tmp18_;
	const gchar* _tmp19_ = NULL;
	gchar** _tmp20_;
	gint _tmp20__length1;
	gchar* port = NULL;
	gchar* _tmp23_;
	GCancellable* cancellable = NULL;
	GCancellable* _tmp24_;
	SeahorseSshUploadOperation* _tmp25_;
	SeahorseSshUploadOperation* _tmp26_;
	GList* _tmp27_;
	const gchar* _tmp28_;
	const gchar* _tmp29_;
	const gchar* _tmp30_;
	GCancellable* _tmp31_;
	GCancellable* _tmp32_;
	g_return_if_fail (self != NULL);
	_data9_ = g_slice_new0 (Block9Data);
	_data9_->_ref_count_ = 1;
	_data9_->self = g_object_ref (self);
	_tmp0_ = self->priv->user_entry;
	_tmp1_ = gtk_entry_get_text (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = string_strip (_tmp2_);
	user = _tmp3_;
	_tmp4_ = self->priv->host_entry;
	_tmp5_ = gtk_entry_get_text (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = string_strip (_tmp6_);
	host_port = _tmp7_;
	_tmp10_ = user;
	if (!g_utf8_validate (_tmp10_, (gssize) -1, NULL)) {
		_tmp9_ = TRUE;
	} else {
		const gchar* _tmp11_;
		_tmp11_ = host_port;
		_tmp9_ = g_strcmp0 (_tmp11_, "") == 0;
	}
	if (_tmp9_) {
		_tmp8_ = TRUE;
	} else {
		const gchar* _tmp12_;
		_tmp12_ = host_port;
		_tmp8_ = !g_utf8_validate (_tmp12_, (gssize) -1, NULL);
	}
	if (_tmp8_) {
		_g_free0 (host_port);
		_g_free0 (user);
		block9_data_unref (_data9_);
		_data9_ = NULL;
		return;
	}
	_tmp13_ = host_port;
	_tmp15_ = _tmp14_ = g_strsplit (_tmp13_, ":", 2);
	host_port_split = _tmp15_;
	host_port_split_length1 = _vala_array_length (_tmp14_);
	_host_port_split_size_ = host_port_split_length1;
	_tmp16_ = host_port_split;
	_tmp16__length1 = host_port_split_length1;
	_tmp17_ = _tmp16_[0];
	_tmp18_ = g_strdup (_tmp17_);
	host = _tmp18_;
	_tmp20_ = host_port_split;
	_tmp20__length1 = host_port_split_length1;
	if (_tmp20__length1 == 2) {
		gchar** _tmp21_;
		gint _tmp21__length1;
		const gchar* _tmp22_;
		_tmp21_ = host_port_split;
		_tmp21__length1 = host_port_split_length1;
		_tmp22_ = _tmp21_[1];
		_tmp19_ = _tmp22_;
	} else {
		_tmp19_ = NULL;
	}
	_tmp23_ = g_strdup (_tmp19_);
	port = _tmp23_;
	_tmp24_ = g_cancellable_new ();
	cancellable = _tmp24_;
	_tmp25_ = seahorse_ssh_upload_operation_new ();
	_data9_->op = _tmp25_;
	_tmp26_ = _data9_->op;
	_tmp27_ = self->priv->keys;
	_tmp28_ = user;
	_tmp29_ = host;
	_tmp30_ = port;
	_tmp31_ = cancellable;
	seahorse_ssh_upload_operation_upload_async (_tmp26_, _tmp27_, _tmp28_, _tmp29_, _tmp30_, _tmp31_, ___lambda15__gasync_ready_callback, block9_data_ref (_data9_));
	_tmp32_ = cancellable;
	seahorse_progress_show (_tmp32_, _ ("Configuring Secure Shell Keys…"), FALSE);
	_g_object_unref0 (cancellable);
	_g_free0 (port);
	_g_free0 (host);
	host_port_split = (_vala_array_free (host_port_split, host_port_split_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (host_port);
	_g_free0 (user);
	block9_data_unref (_data9_);
	_data9_ = NULL;
}

static gint
string_index_of_char (const gchar* self,
                      gunichar c,
                      gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = g_utf8_strchr (((gchar*) self) + start_index, (gssize) -1, c);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static void
seahorse_ssh_upload_on_upload_input_changed (SeahorseSshUpload* self)
{
	gchar* user = NULL;
	GtkEntry* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* host = NULL;
	GtkEntry* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	gboolean _tmp8_ = FALSE;
	const gchar* _tmp9_;
	gint port_pos = 0;
	const gchar* _tmp11_;
	gboolean _tmp14_ = FALSE;
	const gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gboolean _tmp18_;
	GtkButton* _tmp22_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->user_entry;
	_tmp1_ = gtk_entry_get_text (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strdup (_tmp2_);
	user = _tmp3_;
	_tmp4_ = self->priv->host_entry;
	_tmp5_ = gtk_entry_get_text (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_strdup (_tmp6_);
	host = _tmp7_;
	_tmp9_ = user;
	if (!g_utf8_validate (_tmp9_, (gssize) -1, NULL)) {
		_tmp8_ = TRUE;
	} else {
		const gchar* _tmp10_;
		_tmp10_ = host;
		_tmp8_ = !g_utf8_validate (_tmp10_, (gssize) -1, NULL);
	}
	if (_tmp8_) {
		_g_free0 (host);
		_g_free0 (user);
		return;
	}
	_tmp11_ = host;
	port_pos = string_index_of_char (_tmp11_, (gunichar) ':', 0);
	if (port_pos > 0) {
		const gchar* _tmp12_;
		gchar* _tmp13_;
		_tmp12_ = host;
		_tmp13_ = string_substring (_tmp12_, (glong) 0, (glong) port_pos);
		_g_free0 (host);
		host = _tmp13_;
	}
	_tmp15_ = host;
	_tmp16_ = string_strip (_tmp15_);
	_tmp17_ = _tmp16_;
	_tmp18_ = g_strcmp0 (_tmp17_, "") != 0;
	_g_free0 (_tmp17_);
	if (_tmp18_) {
		const gchar* _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
		_tmp19_ = user;
		_tmp20_ = string_strip (_tmp19_);
		_tmp21_ = _tmp20_;
		_tmp14_ = g_strcmp0 (_tmp21_, "") != 0;
		_g_free0 (_tmp21_);
	} else {
		_tmp14_ = FALSE;
	}
	_tmp22_ = self->priv->setup_button;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp22_, _tmp14_);
	_g_free0 (host);
	_g_free0 (user);
}

static void
_seahorse_ssh_upload_on_upload_input_changed_gtk_editable_changed (GtkEditable* _sender,
                                                                   gpointer self)
{
	seahorse_ssh_upload_on_upload_input_changed ((SeahorseSshUpload*) self);
}

/**
     * Prompt a dialog to upload keys.
     *
     * @param keys The set of SSH keys that should be uploaded
     */
void
seahorse_ssh_upload_prompt (GList* keys,
                            GtkWindow* parent)
{
	SeahorseSshUpload* upload_dialog = NULL;
	SeahorseSshUpload* _tmp0_;
	SeahorseSshUpload* _tmp4_;
	if (keys == NULL) {
		return;
	}
	_tmp0_ = seahorse_ssh_upload_new (keys, parent);
	g_object_ref_sink (_tmp0_);
	upload_dialog = _tmp0_;
	{
		gboolean _tmp1_ = FALSE;
		_tmp1_ = TRUE;
		while (TRUE) {
			SeahorseSshUpload* _tmp2_;
			if (!_tmp1_) {
			}
			_tmp1_ = FALSE;
			_tmp2_ = upload_dialog;
			switch (gtk_dialog_run ((GtkDialog*) _tmp2_)) {
				case GTK_RESPONSE_HELP:
				{
					continue;
				}
				case GTK_RESPONSE_ACCEPT:
				{
					SeahorseSshUpload* _tmp3_;
					_tmp3_ = upload_dialog;
					seahorse_ssh_upload_upload_keys (_tmp3_);
					break;
				}
				default:
				{
					break;
				}
			}
			break;
		}
	}
	_tmp4_ = upload_dialog;
	gtk_widget_destroy ((GtkWidget*) _tmp4_);
	_g_object_unref0 (upload_dialog);
}

static void
seahorse_ssh_upload_class_init (SeahorseSshUploadClass * klass,
                                gpointer klass_data)
{
	seahorse_ssh_upload_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SeahorseSshUpload_private_offset);
	G_OBJECT_CLASS (klass)->finalize = seahorse_ssh_upload_finalize;
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/Seahorse/seahorse-ssh-upload.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "user_entry", FALSE, SeahorseSshUpload_private_offset + G_STRUCT_OFFSET (SeahorseSshUploadPrivate, user_entry));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "host_entry", FALSE, SeahorseSshUpload_private_offset + G_STRUCT_OFFSET (SeahorseSshUploadPrivate, host_entry));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "setup_button", FALSE, SeahorseSshUpload_private_offset + G_STRUCT_OFFSET (SeahorseSshUploadPrivate, setup_button));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_upload_input_changed", G_CALLBACK(_seahorse_ssh_upload_on_upload_input_changed_gtk_editable_changed));
}

static void
seahorse_ssh_upload_instance_init (SeahorseSshUpload * self,
                                   gpointer klass)
{
	self->priv = seahorse_ssh_upload_get_instance_private (self);
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
seahorse_ssh_upload_finalize (GObject * obj)
{
	SeahorseSshUpload * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SEAHORSE_SSH_TYPE_UPLOAD, SeahorseSshUpload);
	G_OBJECT_CLASS (seahorse_ssh_upload_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
seahorse_ssh_upload_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SeahorseSshUploadClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) seahorse_ssh_upload_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SeahorseSshUpload), 0, (GInstanceInitFunc) seahorse_ssh_upload_instance_init, NULL };
	GType seahorse_ssh_upload_type_id;
	seahorse_ssh_upload_type_id = g_type_register_static (gtk_dialog_get_type (), "SeahorseSshUpload", &g_define_type_info, 0);
	SeahorseSshUpload_private_offset = g_type_add_instance_private (seahorse_ssh_upload_type_id, sizeof (SeahorseSshUploadPrivate));
	return seahorse_ssh_upload_type_id;
}

GType
seahorse_ssh_upload_get_type (void)
{
	static volatile gsize seahorse_ssh_upload_type_id__once = 0;
	if (g_once_init_enter (&seahorse_ssh_upload_type_id__once)) {
		GType seahorse_ssh_upload_type_id;
		seahorse_ssh_upload_type_id = seahorse_ssh_upload_get_type_once ();
		g_once_init_leave (&seahorse_ssh_upload_type_id__once, seahorse_ssh_upload_type_id);
	}
	return seahorse_ssh_upload_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

