// A Bison parser, made by GNU Bison 3.8.2.

// Skeleton implementation for Bison LALR(1) parsers in C++

// Copyright (C) 2002-2015, 2018-2021 Free Software Foundation, Inc.

// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <https://www.gnu.org/licenses/>.

// As a special exception, you may create a larger work that contains
// part or all of the Bison parser skeleton and distribute that work
// under terms of your choice, so long as that work isn't itself a
// parser generator using the skeleton or a modified version thereof
// as a parser skeleton.  Alternatively, if you modify or redistribute
// the parser skeleton itself, you may (at your option) remove this
// special exception, which will cause the skeleton and the resulting
// Bison output files to be licensed under the GNU General Public
// License without this special exception.

// This special exception was added by the Free Software Foundation in
// version 2.2 of Bison.

// DO NOT RELY ON FEATURES THAT ARE NOT DOCUMENTED in the manual,
// especially those whose name start with YY_ or yy_.  They are
// private implementation details that can be changed or removed.





#include "parser.hpp"


// Unqualified %code blocks.
#line 37 "asm/parser.y"

	#include <algorithm>
	#include <ctype.h>
	#include <inttypes.h>
	#include <optional>
	#include <stdio.h>
	#include <stdlib.h>
	#include <string.h>
	#include <string_view>

	#include "extern/utf8decoder.hpp"
	#include "helpers.hpp"

	#include "asm/actions.hpp"
	#include "asm/charmap.hpp"
	#include "asm/fixpoint.hpp"
	#include "asm/fstack.hpp"
	#include "asm/main.hpp"
	#include "asm/opt.hpp"
	#include "asm/output.hpp"
	#include "asm/section.hpp"
	#include "asm/symbol.hpp"
	#include "asm/warning.hpp"

	using namespace std::literals;

	yy::parser::symbol_type yylex(); // Provided by lexer.cpp

	template <typename N, typename S>
	static auto handleSymbolByType(std::string const &symName, N numCallback, S strCallback) {
		if (Symbol *sym = sym_FindScopedSymbol(symName); sym && sym->type == SYM_EQUS) {
			return strCallback(*sym->getEqus());
		} else {
			Expression expr;
			expr.makeSymbol(symName);
			return numCallback(expr);
		}
	}

	// The CPU encodes instructions in a logical way, so most instructions actually follow patterns.
	// These enums thus help with bit twiddling to compute opcodes.
	enum { REG_B, REG_C, REG_D, REG_E, REG_H, REG_L, REG_HL_IND, REG_A };

	enum { REG_BC_IND, REG_DE_IND, REG_HL_INDINC, REG_HL_INDDEC };

	// REG_AF == REG_SP since LD/INC/ADD/DEC allow SP, while PUSH/POP allow AF
	enum { REG_BC, REG_DE, REG_HL, REG_SP, REG_AF = REG_SP };
	// Names are not needed for AF or SP
	static char const *reg_tt_names[] = { "BC", "DE", "HL" };
	static char const *reg_tt_high_names[] = { "B", "D", "H" };
	static char const *reg_tt_low_names[] = { "C", "E", "L" };

	// CC_NZ == CC_Z ^ 1, and CC_NC == CC_C ^ 1, so `!` can toggle them
	enum { CC_NZ, CC_Z, CC_NC, CC_C };

#line 102 "/build/rgbds/src/rgbds/src/asm/parser.cpp"


#ifndef YY_
# if defined YYENABLE_NLS && YYENABLE_NLS
#  if ENABLE_NLS
#   include <libintl.h> // FIXME: INFRINGES ON USER NAME SPACE.
#   define YY_(msgid) dgettext ("bison-runtime", msgid)
#  endif
# endif
# ifndef YY_
#  define YY_(msgid) msgid
# endif
#endif


// Whether we are compiled with exception support.
#ifndef YY_EXCEPTIONS
# if defined __GNUC__ && !defined __EXCEPTIONS
#  define YY_EXCEPTIONS 0
# else
#  define YY_EXCEPTIONS 1
# endif
#endif



// Enable debugging if requested.
#if YYDEBUG

// A pseudo ostream that takes yydebug_ into account.
# define YYCDEBUG if (yydebug_) (*yycdebug_)

# define YY_SYMBOL_PRINT(Title, Symbol)         \
  do {                                          \
    if (yydebug_)                               \
    {                                           \
      *yycdebug_ << Title << ' ';               \
      yy_print_ (*yycdebug_, Symbol);           \
      *yycdebug_ << '\n';                       \
    }                                           \
  } while (false)

# define YY_REDUCE_PRINT(Rule)          \
  do {                                  \
    if (yydebug_)                       \
      yy_reduce_print_ (Rule);          \
  } while (false)

# define YY_STACK_PRINT()               \
  do {                                  \
    if (yydebug_)                       \
      yy_stack_print_ ();                \
  } while (false)

#else // !YYDEBUG

# define YYCDEBUG if (false) std::cerr
# define YY_SYMBOL_PRINT(Title, Symbol)  YY_USE (Symbol)
# define YY_REDUCE_PRINT(Rule)           static_cast<void> (0)
# define YY_STACK_PRINT()                static_cast<void> (0)

#endif // !YYDEBUG

#define yyerrok         (yyerrstatus_ = 0)
#define yyclearin       (yyla.clear ())

#define YYACCEPT        goto yyacceptlab
#define YYABORT         goto yyabortlab
#define YYERROR         goto yyerrorlab
#define YYRECOVERING()  (!!yyerrstatus_)

namespace yy {
#line 175 "/build/rgbds/src/rgbds/src/asm/parser.cpp"

  /// Build a parser object.
  parser::parser ()
#if YYDEBUG
    : yydebug_ (false),
      yycdebug_ (&std::cerr),
#else
    :
#endif
      yy_lac_established_ (false)
  {}

  parser::~parser ()
  {}

  parser::syntax_error::~syntax_error () YY_NOEXCEPT YY_NOTHROW
  {}

  /*---------.
  | symbol.  |
  `---------*/



  // by_state.
  parser::by_state::by_state () YY_NOEXCEPT
    : state (empty_state)
  {}

  parser::by_state::by_state (const by_state& that) YY_NOEXCEPT
    : state (that.state)
  {}

  void
  parser::by_state::clear () YY_NOEXCEPT
  {
    state = empty_state;
  }

  void
  parser::by_state::move (by_state& that)
  {
    state = that.state;
    that.clear ();
  }

  parser::by_state::by_state (state_type s) YY_NOEXCEPT
    : state (s)
  {}

  parser::symbol_kind_type
  parser::by_state::kind () const YY_NOEXCEPT
  {
    if (state == empty_state)
      return symbol_kind::S_YYEMPTY;
    else
      return YY_CAST (symbol_kind_type, yystos_[+state]);
  }

  parser::stack_symbol_type::stack_symbol_type ()
  {}

  parser::stack_symbol_type::stack_symbol_type (YY_RVREF (stack_symbol_type) that)
    : super_type (YY_MOVE (that.state))
  {
    switch (that.kind ())
    {
      case symbol_kind::S_align_spec: // align_spec
        value.YY_MOVE_OR_COPY< AlignmentSpec > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_assert_type: // assert_type
        value.YY_MOVE_OR_COPY< AssertionType > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_capture_rept: // capture_rept
      case symbol_kind::S_capture_macro: // capture_macro
        value.YY_MOVE_OR_COPY< Capture > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_reloc_3bit: // reloc_3bit
      case symbol_kind::S_reloc_8bit: // reloc_8bit
      case symbol_kind::S_reloc_16bit: // reloc_16bit
      case symbol_kind::S_relocexpr: // relocexpr
      case symbol_kind::S_relocexpr_no_str: // relocexpr_no_str
      case symbol_kind::S_op_mem_ind: // op_mem_ind
      case symbol_kind::S_op_a_n: // op_a_n
      case symbol_kind::S_op_sp_offset: // op_sp_offset
        value.YY_MOVE_OR_COPY< Expression > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_for_args: // for_args
        value.YY_MOVE_OR_COPY< ForArgs > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_compound_eq: // compound_eq
        value.YY_MOVE_OR_COPY< RPNCommand > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_sect_mod: // sect_mod
        value.YY_MOVE_OR_COPY< SectionModifier > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_sect_attrs: // sect_attrs
        value.YY_MOVE_OR_COPY< SectionSpec > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_sect_type: // sect_type
        value.YY_MOVE_OR_COPY< SectionType > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_strfmt_args: // strfmt_args
      case symbol_kind::S_strfmt_va_args: // strfmt_va_args
        value.YY_MOVE_OR_COPY< StrFmtArgList > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_NUMBER: // "number"
      case symbol_kind::S_shift_const: // shift_const
      case symbol_kind::S_rs_uconst: // rs_uconst
      case symbol_kind::S_uconst: // uconst
      case symbol_kind::S_iconst: // iconst
      case symbol_kind::S_precision_arg: // precision_arg
      case symbol_kind::S_sect_org: // sect_org
      case symbol_kind::S_op_a_r: // op_a_r
      case symbol_kind::S_ccode_expr: // ccode_expr
      case symbol_kind::S_ccode: // ccode
      case symbol_kind::S_reg_r: // reg_r
      case symbol_kind::S_reg_r_no_a: // reg_r_no_a
      case symbol_kind::S_reg_a: // reg_a
      case symbol_kind::S_reg_tt: // reg_tt
      case symbol_kind::S_reg_ss: // reg_ss
      case symbol_kind::S_reg_tt_no_af: // reg_tt_no_af
      case symbol_kind::S_reg_bc_or_de: // reg_bc_or_de
      case symbol_kind::S_reg_rr: // reg_rr
        value.YY_MOVE_OR_COPY< int32_t > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_macro_args: // macro_args
        value.YY_MOVE_OR_COPY< std::shared_ptr<MacroArgs> > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_STRING: // "string"
      case symbol_kind::S_CHARACTER: // "character"
      case symbol_kind::S_SYMBOL: // "symbol"
      case symbol_kind::S_LABEL: // "label"
      case symbol_kind::S_LOCAL: // "local label"
      case symbol_kind::S_ANON: // "anonymous label"
      case symbol_kind::S_def_id: // def_id
      case symbol_kind::S_redef_id: // redef_id
      case symbol_kind::S_scoped_sym_no_anon: // scoped_sym_no_anon
      case symbol_kind::S_scoped_sym: // scoped_sym
      case symbol_kind::S_def_numeric: // def_numeric
      case symbol_kind::S_def_equ: // def_equ
      case symbol_kind::S_redef_equ: // redef_equ
      case symbol_kind::S_def_set: // def_set
      case symbol_kind::S_def_rb: // def_rb
      case symbol_kind::S_def_rw: // def_rw
      case symbol_kind::S_def_rl: // def_rl
      case symbol_kind::S_def_equs: // def_equs
      case symbol_kind::S_redef_equs: // redef_equs
      case symbol_kind::S_fragment_literal: // fragment_literal
      case symbol_kind::S_fragment_literal_name: // fragment_literal_name
      case symbol_kind::S_string_literal: // string_literal
      case symbol_kind::S_string: // string
      case symbol_kind::S_strcat_args: // strcat_args
        value.YY_MOVE_OR_COPY< std::string > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_ds_args: // ds_args
        value.YY_MOVE_OR_COPY< std::vector<Expression> > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_charmap_args: // charmap_args
        value.YY_MOVE_OR_COPY< std::vector<int32_t> > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_purge_args: // purge_args
        value.YY_MOVE_OR_COPY< std::vector<std::string> > (YY_MOVE (that.value));
        break;

      default:
        break;
    }

#if 201103L <= YY_CPLUSPLUS
    // that is emptied.
    that.state = empty_state;
#endif
  }

  parser::stack_symbol_type::stack_symbol_type (state_type s, YY_MOVE_REF (symbol_type) that)
    : super_type (s)
  {
    switch (that.kind ())
    {
      case symbol_kind::S_align_spec: // align_spec
        value.move< AlignmentSpec > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_assert_type: // assert_type
        value.move< AssertionType > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_capture_rept: // capture_rept
      case symbol_kind::S_capture_macro: // capture_macro
        value.move< Capture > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_reloc_3bit: // reloc_3bit
      case symbol_kind::S_reloc_8bit: // reloc_8bit
      case symbol_kind::S_reloc_16bit: // reloc_16bit
      case symbol_kind::S_relocexpr: // relocexpr
      case symbol_kind::S_relocexpr_no_str: // relocexpr_no_str
      case symbol_kind::S_op_mem_ind: // op_mem_ind
      case symbol_kind::S_op_a_n: // op_a_n
      case symbol_kind::S_op_sp_offset: // op_sp_offset
        value.move< Expression > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_for_args: // for_args
        value.move< ForArgs > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_compound_eq: // compound_eq
        value.move< RPNCommand > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_sect_mod: // sect_mod
        value.move< SectionModifier > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_sect_attrs: // sect_attrs
        value.move< SectionSpec > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_sect_type: // sect_type
        value.move< SectionType > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_strfmt_args: // strfmt_args
      case symbol_kind::S_strfmt_va_args: // strfmt_va_args
        value.move< StrFmtArgList > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_NUMBER: // "number"
      case symbol_kind::S_shift_const: // shift_const
      case symbol_kind::S_rs_uconst: // rs_uconst
      case symbol_kind::S_uconst: // uconst
      case symbol_kind::S_iconst: // iconst
      case symbol_kind::S_precision_arg: // precision_arg
      case symbol_kind::S_sect_org: // sect_org
      case symbol_kind::S_op_a_r: // op_a_r
      case symbol_kind::S_ccode_expr: // ccode_expr
      case symbol_kind::S_ccode: // ccode
      case symbol_kind::S_reg_r: // reg_r
      case symbol_kind::S_reg_r_no_a: // reg_r_no_a
      case symbol_kind::S_reg_a: // reg_a
      case symbol_kind::S_reg_tt: // reg_tt
      case symbol_kind::S_reg_ss: // reg_ss
      case symbol_kind::S_reg_tt_no_af: // reg_tt_no_af
      case symbol_kind::S_reg_bc_or_de: // reg_bc_or_de
      case symbol_kind::S_reg_rr: // reg_rr
        value.move< int32_t > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_macro_args: // macro_args
        value.move< std::shared_ptr<MacroArgs> > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_STRING: // "string"
      case symbol_kind::S_CHARACTER: // "character"
      case symbol_kind::S_SYMBOL: // "symbol"
      case symbol_kind::S_LABEL: // "label"
      case symbol_kind::S_LOCAL: // "local label"
      case symbol_kind::S_ANON: // "anonymous label"
      case symbol_kind::S_def_id: // def_id
      case symbol_kind::S_redef_id: // redef_id
      case symbol_kind::S_scoped_sym_no_anon: // scoped_sym_no_anon
      case symbol_kind::S_scoped_sym: // scoped_sym
      case symbol_kind::S_def_numeric: // def_numeric
      case symbol_kind::S_def_equ: // def_equ
      case symbol_kind::S_redef_equ: // redef_equ
      case symbol_kind::S_def_set: // def_set
      case symbol_kind::S_def_rb: // def_rb
      case symbol_kind::S_def_rw: // def_rw
      case symbol_kind::S_def_rl: // def_rl
      case symbol_kind::S_def_equs: // def_equs
      case symbol_kind::S_redef_equs: // redef_equs
      case symbol_kind::S_fragment_literal: // fragment_literal
      case symbol_kind::S_fragment_literal_name: // fragment_literal_name
      case symbol_kind::S_string_literal: // string_literal
      case symbol_kind::S_string: // string
      case symbol_kind::S_strcat_args: // strcat_args
        value.move< std::string > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_ds_args: // ds_args
        value.move< std::vector<Expression> > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_charmap_args: // charmap_args
        value.move< std::vector<int32_t> > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_purge_args: // purge_args
        value.move< std::vector<std::string> > (YY_MOVE (that.value));
        break;

      default:
        break;
    }

    // that is emptied.
    that.kind_ = symbol_kind::S_YYEMPTY;
  }

#if YY_CPLUSPLUS < 201103L
  parser::stack_symbol_type&
  parser::stack_symbol_type::operator= (const stack_symbol_type& that)
  {
    state = that.state;
    switch (that.kind ())
    {
      case symbol_kind::S_align_spec: // align_spec
        value.copy< AlignmentSpec > (that.value);
        break;

      case symbol_kind::S_assert_type: // assert_type
        value.copy< AssertionType > (that.value);
        break;

      case symbol_kind::S_capture_rept: // capture_rept
      case symbol_kind::S_capture_macro: // capture_macro
        value.copy< Capture > (that.value);
        break;

      case symbol_kind::S_reloc_3bit: // reloc_3bit
      case symbol_kind::S_reloc_8bit: // reloc_8bit
      case symbol_kind::S_reloc_16bit: // reloc_16bit
      case symbol_kind::S_relocexpr: // relocexpr
      case symbol_kind::S_relocexpr_no_str: // relocexpr_no_str
      case symbol_kind::S_op_mem_ind: // op_mem_ind
      case symbol_kind::S_op_a_n: // op_a_n
      case symbol_kind::S_op_sp_offset: // op_sp_offset
        value.copy< Expression > (that.value);
        break;

      case symbol_kind::S_for_args: // for_args
        value.copy< ForArgs > (that.value);
        break;

      case symbol_kind::S_compound_eq: // compound_eq
        value.copy< RPNCommand > (that.value);
        break;

      case symbol_kind::S_sect_mod: // sect_mod
        value.copy< SectionModifier > (that.value);
        break;

      case symbol_kind::S_sect_attrs: // sect_attrs
        value.copy< SectionSpec > (that.value);
        break;

      case symbol_kind::S_sect_type: // sect_type
        value.copy< SectionType > (that.value);
        break;

      case symbol_kind::S_strfmt_args: // strfmt_args
      case symbol_kind::S_strfmt_va_args: // strfmt_va_args
        value.copy< StrFmtArgList > (that.value);
        break;

      case symbol_kind::S_NUMBER: // "number"
      case symbol_kind::S_shift_const: // shift_const
      case symbol_kind::S_rs_uconst: // rs_uconst
      case symbol_kind::S_uconst: // uconst
      case symbol_kind::S_iconst: // iconst
      case symbol_kind::S_precision_arg: // precision_arg
      case symbol_kind::S_sect_org: // sect_org
      case symbol_kind::S_op_a_r: // op_a_r
      case symbol_kind::S_ccode_expr: // ccode_expr
      case symbol_kind::S_ccode: // ccode
      case symbol_kind::S_reg_r: // reg_r
      case symbol_kind::S_reg_r_no_a: // reg_r_no_a
      case symbol_kind::S_reg_a: // reg_a
      case symbol_kind::S_reg_tt: // reg_tt
      case symbol_kind::S_reg_ss: // reg_ss
      case symbol_kind::S_reg_tt_no_af: // reg_tt_no_af
      case symbol_kind::S_reg_bc_or_de: // reg_bc_or_de
      case symbol_kind::S_reg_rr: // reg_rr
        value.copy< int32_t > (that.value);
        break;

      case symbol_kind::S_macro_args: // macro_args
        value.copy< std::shared_ptr<MacroArgs> > (that.value);
        break;

      case symbol_kind::S_STRING: // "string"
      case symbol_kind::S_CHARACTER: // "character"
      case symbol_kind::S_SYMBOL: // "symbol"
      case symbol_kind::S_LABEL: // "label"
      case symbol_kind::S_LOCAL: // "local label"
      case symbol_kind::S_ANON: // "anonymous label"
      case symbol_kind::S_def_id: // def_id
      case symbol_kind::S_redef_id: // redef_id
      case symbol_kind::S_scoped_sym_no_anon: // scoped_sym_no_anon
      case symbol_kind::S_scoped_sym: // scoped_sym
      case symbol_kind::S_def_numeric: // def_numeric
      case symbol_kind::S_def_equ: // def_equ
      case symbol_kind::S_redef_equ: // redef_equ
      case symbol_kind::S_def_set: // def_set
      case symbol_kind::S_def_rb: // def_rb
      case symbol_kind::S_def_rw: // def_rw
      case symbol_kind::S_def_rl: // def_rl
      case symbol_kind::S_def_equs: // def_equs
      case symbol_kind::S_redef_equs: // redef_equs
      case symbol_kind::S_fragment_literal: // fragment_literal
      case symbol_kind::S_fragment_literal_name: // fragment_literal_name
      case symbol_kind::S_string_literal: // string_literal
      case symbol_kind::S_string: // string
      case symbol_kind::S_strcat_args: // strcat_args
        value.copy< std::string > (that.value);
        break;

      case symbol_kind::S_ds_args: // ds_args
        value.copy< std::vector<Expression> > (that.value);
        break;

      case symbol_kind::S_charmap_args: // charmap_args
        value.copy< std::vector<int32_t> > (that.value);
        break;

      case symbol_kind::S_purge_args: // purge_args
        value.copy< std::vector<std::string> > (that.value);
        break;

      default:
        break;
    }

    return *this;
  }

  parser::stack_symbol_type&
  parser::stack_symbol_type::operator= (stack_symbol_type& that)
  {
    state = that.state;
    switch (that.kind ())
    {
      case symbol_kind::S_align_spec: // align_spec
        value.move< AlignmentSpec > (that.value);
        break;

      case symbol_kind::S_assert_type: // assert_type
        value.move< AssertionType > (that.value);
        break;

      case symbol_kind::S_capture_rept: // capture_rept
      case symbol_kind::S_capture_macro: // capture_macro
        value.move< Capture > (that.value);
        break;

      case symbol_kind::S_reloc_3bit: // reloc_3bit
      case symbol_kind::S_reloc_8bit: // reloc_8bit
      case symbol_kind::S_reloc_16bit: // reloc_16bit
      case symbol_kind::S_relocexpr: // relocexpr
      case symbol_kind::S_relocexpr_no_str: // relocexpr_no_str
      case symbol_kind::S_op_mem_ind: // op_mem_ind
      case symbol_kind::S_op_a_n: // op_a_n
      case symbol_kind::S_op_sp_offset: // op_sp_offset
        value.move< Expression > (that.value);
        break;

      case symbol_kind::S_for_args: // for_args
        value.move< ForArgs > (that.value);
        break;

      case symbol_kind::S_compound_eq: // compound_eq
        value.move< RPNCommand > (that.value);
        break;

      case symbol_kind::S_sect_mod: // sect_mod
        value.move< SectionModifier > (that.value);
        break;

      case symbol_kind::S_sect_attrs: // sect_attrs
        value.move< SectionSpec > (that.value);
        break;

      case symbol_kind::S_sect_type: // sect_type
        value.move< SectionType > (that.value);
        break;

      case symbol_kind::S_strfmt_args: // strfmt_args
      case symbol_kind::S_strfmt_va_args: // strfmt_va_args
        value.move< StrFmtArgList > (that.value);
        break;

      case symbol_kind::S_NUMBER: // "number"
      case symbol_kind::S_shift_const: // shift_const
      case symbol_kind::S_rs_uconst: // rs_uconst
      case symbol_kind::S_uconst: // uconst
      case symbol_kind::S_iconst: // iconst
      case symbol_kind::S_precision_arg: // precision_arg
      case symbol_kind::S_sect_org: // sect_org
      case symbol_kind::S_op_a_r: // op_a_r
      case symbol_kind::S_ccode_expr: // ccode_expr
      case symbol_kind::S_ccode: // ccode
      case symbol_kind::S_reg_r: // reg_r
      case symbol_kind::S_reg_r_no_a: // reg_r_no_a
      case symbol_kind::S_reg_a: // reg_a
      case symbol_kind::S_reg_tt: // reg_tt
      case symbol_kind::S_reg_ss: // reg_ss
      case symbol_kind::S_reg_tt_no_af: // reg_tt_no_af
      case symbol_kind::S_reg_bc_or_de: // reg_bc_or_de
      case symbol_kind::S_reg_rr: // reg_rr
        value.move< int32_t > (that.value);
        break;

      case symbol_kind::S_macro_args: // macro_args
        value.move< std::shared_ptr<MacroArgs> > (that.value);
        break;

      case symbol_kind::S_STRING: // "string"
      case symbol_kind::S_CHARACTER: // "character"
      case symbol_kind::S_SYMBOL: // "symbol"
      case symbol_kind::S_LABEL: // "label"
      case symbol_kind::S_LOCAL: // "local label"
      case symbol_kind::S_ANON: // "anonymous label"
      case symbol_kind::S_def_id: // def_id
      case symbol_kind::S_redef_id: // redef_id
      case symbol_kind::S_scoped_sym_no_anon: // scoped_sym_no_anon
      case symbol_kind::S_scoped_sym: // scoped_sym
      case symbol_kind::S_def_numeric: // def_numeric
      case symbol_kind::S_def_equ: // def_equ
      case symbol_kind::S_redef_equ: // redef_equ
      case symbol_kind::S_def_set: // def_set
      case symbol_kind::S_def_rb: // def_rb
      case symbol_kind::S_def_rw: // def_rw
      case symbol_kind::S_def_rl: // def_rl
      case symbol_kind::S_def_equs: // def_equs
      case symbol_kind::S_redef_equs: // redef_equs
      case symbol_kind::S_fragment_literal: // fragment_literal
      case symbol_kind::S_fragment_literal_name: // fragment_literal_name
      case symbol_kind::S_string_literal: // string_literal
      case symbol_kind::S_string: // string
      case symbol_kind::S_strcat_args: // strcat_args
        value.move< std::string > (that.value);
        break;

      case symbol_kind::S_ds_args: // ds_args
        value.move< std::vector<Expression> > (that.value);
        break;

      case symbol_kind::S_charmap_args: // charmap_args
        value.move< std::vector<int32_t> > (that.value);
        break;

      case symbol_kind::S_purge_args: // purge_args
        value.move< std::vector<std::string> > (that.value);
        break;

      default:
        break;
    }

    // that is emptied.
    that.state = empty_state;
    return *this;
  }
#endif

  template <typename Base>
  void
  parser::yy_destroy_ (const char* yymsg, basic_symbol<Base>& yysym) const
  {
    if (yymsg)
      YY_SYMBOL_PRINT (yymsg, yysym);
  }

#if YYDEBUG
  template <typename Base>
  void
  parser::yy_print_ (std::ostream& yyo, const basic_symbol<Base>& yysym) const
  {
    std::ostream& yyoutput = yyo;
    YY_USE (yyoutput);
    if (yysym.empty ())
      yyo << "empty symbol";
    else
      {
        symbol_kind_type yykind = yysym.kind ();
        yyo << (yykind < YYNTOKENS ? "token" : "nterm")
            << ' ' << yysym.name () << " (";
        YY_USE (yykind);
        yyo << ')';
      }
  }
#endif

  void
  parser::yypush_ (const char* m, YY_MOVE_REF (stack_symbol_type) sym)
  {
    if (m)
      YY_SYMBOL_PRINT (m, sym);
    yystack_.push (YY_MOVE (sym));
  }

  void
  parser::yypush_ (const char* m, state_type s, YY_MOVE_REF (symbol_type) sym)
  {
#if 201103L <= YY_CPLUSPLUS
    yypush_ (m, stack_symbol_type (s, std::move (sym)));
#else
    stack_symbol_type ss (s, sym);
    yypush_ (m, ss);
#endif
  }

  void
  parser::yypop_ (int n) YY_NOEXCEPT
  {
    yystack_.pop (n);
  }

#if YYDEBUG
  std::ostream&
  parser::debug_stream () const
  {
    return *yycdebug_;
  }

  void
  parser::set_debug_stream (std::ostream& o)
  {
    yycdebug_ = &o;
  }


  parser::debug_level_type
  parser::debug_level () const
  {
    return yydebug_;
  }

  void
  parser::set_debug_level (debug_level_type l)
  {
    yydebug_ = l;
  }
#endif // YYDEBUG

  parser::state_type
  parser::yy_lr_goto_state_ (state_type yystate, int yysym)
  {
    int yyr = yypgoto_[yysym - YYNTOKENS] + yystate;
    if (0 <= yyr && yyr <= yylast_ && yycheck_[yyr] == yystate)
      return yytable_[yyr];
    else
      return yydefgoto_[yysym - YYNTOKENS];
  }

  bool
  parser::yy_pact_value_is_default_ (int yyvalue) YY_NOEXCEPT
  {
    return yyvalue == yypact_ninf_;
  }

  bool
  parser::yy_table_value_is_error_ (int yyvalue) YY_NOEXCEPT
  {
    return yyvalue == yytable_ninf_;
  }

  int
  parser::operator() ()
  {
    return parse ();
  }

  int
  parser::parse ()
  {
    int yyn;
    /// Length of the RHS of the rule being reduced.
    int yylen = 0;

    // Error handling.
    int yynerrs_ = 0;
    int yyerrstatus_ = 0;

    /// The lookahead symbol.
    symbol_type yyla;

    /// The return value of parse ().
    int yyresult;

    // Discard the LAC context in case there still is one left from a
    // previous invocation.
    yy_lac_discard_ ("init");

#if YY_EXCEPTIONS
    try
#endif // YY_EXCEPTIONS
      {
    YYCDEBUG << "Starting parse\n";


    /* Initialize the stack.  The initial state will be set in
       yynewstate, since the latter expects the semantical and the
       location values to have been already stored, initialize these
       stacks with a primary value.  */
    yystack_.clear ();
    yypush_ (YY_NULLPTR, 0, YY_MOVE (yyla));

  /*-----------------------------------------------.
  | yynewstate -- push a new symbol on the stack.  |
  `-----------------------------------------------*/
  yynewstate:
    YYCDEBUG << "Entering state " << int (yystack_[0].state) << '\n';
    YY_STACK_PRINT ();

    // Accept?
    if (yystack_[0].state == yyfinal_)
      YYACCEPT;

    goto yybackup;


  /*-----------.
  | yybackup.  |
  `-----------*/
  yybackup:
    // Try to take a decision without lookahead.
    yyn = yypact_[+yystack_[0].state];
    if (yy_pact_value_is_default_ (yyn))
      goto yydefault;

    // Read a lookahead token.
    if (yyla.empty ())
      {
        YYCDEBUG << "Reading a token\n";
#if YY_EXCEPTIONS
        try
#endif // YY_EXCEPTIONS
          {
            symbol_type yylookahead (yylex ());
            yyla.move (yylookahead);
          }
#if YY_EXCEPTIONS
        catch (const syntax_error& yyexc)
          {
            YYCDEBUG << "Caught exception: " << yyexc.what() << '\n';
            error (yyexc);
            goto yyerrlab1;
          }
#endif // YY_EXCEPTIONS
      }
    YY_SYMBOL_PRINT ("Next token is", yyla);

    if (yyla.kind () == symbol_kind::S_YYerror)
    {
      // The scanner already issued an error message, process directly
      // to error recovery.  But do not keep the error token as
      // lookahead, it is too special and may lead us to an endless
      // loop in error recovery. */
      yyla.kind_ = symbol_kind::S_YYUNDEF;
      goto yyerrlab1;
    }

    /* If the proper action on seeing token YYLA.TYPE is to reduce or
       to detect an error, take that action.  */
    yyn += yyla.kind ();
    if (yyn < 0 || yylast_ < yyn || yycheck_[yyn] != yyla.kind ())
      {
        if (!yy_lac_establish_ (yyla.kind ()))
          goto yyerrlab;
        goto yydefault;
      }

    // Reduce or error.
    yyn = yytable_[yyn];
    if (yyn <= 0)
      {
        if (yy_table_value_is_error_ (yyn))
          goto yyerrlab;
        if (!yy_lac_establish_ (yyla.kind ()))
          goto yyerrlab;

        yyn = -yyn;
        goto yyreduce;
      }

    // Count tokens shifted since error; after three, turn off error status.
    if (yyerrstatus_)
      --yyerrstatus_;

    // Shift the lookahead token.
    yypush_ ("Shifting", state_type (yyn), YY_MOVE (yyla));
    yy_lac_discard_ ("shift");
    goto yynewstate;


  /*-----------------------------------------------------------.
  | yydefault -- do the default action for the current state.  |
  `-----------------------------------------------------------*/
  yydefault:
    yyn = yydefact_[+yystack_[0].state];
    if (yyn == 0)
      goto yyerrlab;
    goto yyreduce;


  /*-----------------------------.
  | yyreduce -- do a reduction.  |
  `-----------------------------*/
  yyreduce:
    yylen = yyr2_[yyn];
    {
      stack_symbol_type yylhs;
      yylhs.state = yy_lr_goto_state_ (yystack_[yylen].state, yyr1_[yyn]);
      /* Variants are always initialized to an empty instance of the
         correct type. The default '$$ = $1' action is NOT applied
         when using variants.  */
      switch (yyr1_[yyn])
    {
      case symbol_kind::S_align_spec: // align_spec
        yylhs.value.emplace< AlignmentSpec > ();
        break;

      case symbol_kind::S_assert_type: // assert_type
        yylhs.value.emplace< AssertionType > ();
        break;

      case symbol_kind::S_capture_rept: // capture_rept
      case symbol_kind::S_capture_macro: // capture_macro
        yylhs.value.emplace< Capture > ();
        break;

      case symbol_kind::S_reloc_3bit: // reloc_3bit
      case symbol_kind::S_reloc_8bit: // reloc_8bit
      case symbol_kind::S_reloc_16bit: // reloc_16bit
      case symbol_kind::S_relocexpr: // relocexpr
      case symbol_kind::S_relocexpr_no_str: // relocexpr_no_str
      case symbol_kind::S_op_mem_ind: // op_mem_ind
      case symbol_kind::S_op_a_n: // op_a_n
      case symbol_kind::S_op_sp_offset: // op_sp_offset
        yylhs.value.emplace< Expression > ();
        break;

      case symbol_kind::S_for_args: // for_args
        yylhs.value.emplace< ForArgs > ();
        break;

      case symbol_kind::S_compound_eq: // compound_eq
        yylhs.value.emplace< RPNCommand > ();
        break;

      case symbol_kind::S_sect_mod: // sect_mod
        yylhs.value.emplace< SectionModifier > ();
        break;

      case symbol_kind::S_sect_attrs: // sect_attrs
        yylhs.value.emplace< SectionSpec > ();
        break;

      case symbol_kind::S_sect_type: // sect_type
        yylhs.value.emplace< SectionType > ();
        break;

      case symbol_kind::S_strfmt_args: // strfmt_args
      case symbol_kind::S_strfmt_va_args: // strfmt_va_args
        yylhs.value.emplace< StrFmtArgList > ();
        break;

      case symbol_kind::S_NUMBER: // "number"
      case symbol_kind::S_shift_const: // shift_const
      case symbol_kind::S_rs_uconst: // rs_uconst
      case symbol_kind::S_uconst: // uconst
      case symbol_kind::S_iconst: // iconst
      case symbol_kind::S_precision_arg: // precision_arg
      case symbol_kind::S_sect_org: // sect_org
      case symbol_kind::S_op_a_r: // op_a_r
      case symbol_kind::S_ccode_expr: // ccode_expr
      case symbol_kind::S_ccode: // ccode
      case symbol_kind::S_reg_r: // reg_r
      case symbol_kind::S_reg_r_no_a: // reg_r_no_a
      case symbol_kind::S_reg_a: // reg_a
      case symbol_kind::S_reg_tt: // reg_tt
      case symbol_kind::S_reg_ss: // reg_ss
      case symbol_kind::S_reg_tt_no_af: // reg_tt_no_af
      case symbol_kind::S_reg_bc_or_de: // reg_bc_or_de
      case symbol_kind::S_reg_rr: // reg_rr
        yylhs.value.emplace< int32_t > ();
        break;

      case symbol_kind::S_macro_args: // macro_args
        yylhs.value.emplace< std::shared_ptr<MacroArgs> > ();
        break;

      case symbol_kind::S_STRING: // "string"
      case symbol_kind::S_CHARACTER: // "character"
      case symbol_kind::S_SYMBOL: // "symbol"
      case symbol_kind::S_LABEL: // "label"
      case symbol_kind::S_LOCAL: // "local label"
      case symbol_kind::S_ANON: // "anonymous label"
      case symbol_kind::S_def_id: // def_id
      case symbol_kind::S_redef_id: // redef_id
      case symbol_kind::S_scoped_sym_no_anon: // scoped_sym_no_anon
      case symbol_kind::S_scoped_sym: // scoped_sym
      case symbol_kind::S_def_numeric: // def_numeric
      case symbol_kind::S_def_equ: // def_equ
      case symbol_kind::S_redef_equ: // redef_equ
      case symbol_kind::S_def_set: // def_set
      case symbol_kind::S_def_rb: // def_rb
      case symbol_kind::S_def_rw: // def_rw
      case symbol_kind::S_def_rl: // def_rl
      case symbol_kind::S_def_equs: // def_equs
      case symbol_kind::S_redef_equs: // redef_equs
      case symbol_kind::S_fragment_literal: // fragment_literal
      case symbol_kind::S_fragment_literal_name: // fragment_literal_name
      case symbol_kind::S_string_literal: // string_literal
      case symbol_kind::S_string: // string
      case symbol_kind::S_strcat_args: // strcat_args
        yylhs.value.emplace< std::string > ();
        break;

      case symbol_kind::S_ds_args: // ds_args
        yylhs.value.emplace< std::vector<Expression> > ();
        break;

      case symbol_kind::S_charmap_args: // charmap_args
        yylhs.value.emplace< std::vector<int32_t> > ();
        break;

      case symbol_kind::S_purge_args: // purge_args
        yylhs.value.emplace< std::vector<std::string> > ();
        break;

      default:
        break;
    }



      // Perform the reduction.
      YY_REDUCE_PRINT (yyn);
#if YY_EXCEPTIONS
      try
#endif // YY_EXCEPTIONS
        {
          switch (yyn)
            {
  case 5: // $@1: %empty
#line 419 "asm/parser.y"
                {
		lexer_SetMode(LEXER_NORMAL);
		lexer_ToggleStringExpansion(true);
	}
#line 1135 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 6: // lines: error $@1 endofline
#line 422 "asm/parser.y"
                    {
		yyerrok;
	}
#line 1143 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 8: // diff_mark: "+"
#line 429 "asm/parser.y"
                 {
		::error(
		    "syntax error, unexpected + at the beginning of the line (is it a leftover diff mark?)"
		);
	}
#line 1153 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 9: // diff_mark: "-"
#line 434 "asm/parser.y"
                 {
		::error(
		    "syntax error, unexpected - at the beginning of the line (is it a leftover diff mark?)"
		);
	}
#line 1163 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 23: // if: "IF" iconst "end of line"
#line 467 "asm/parser.y"
                              {
		lexer_IncIFDepth();

		if (yystack_[1].value.as < int32_t > ()) {
			lexer_RunIFBlock();
		} else {
			lexer_SetMode(LEXER_SKIP_TO_ELIF);
		}
	}
#line 1177 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 24: // elif: "ELIF" iconst "end of line"
#line 479 "asm/parser.y"
                                {
		if (lexer_GetIFDepth() == 0) {
			fatal("Found ELIF outside of an IF construct");
		}
		if (lexer_RanIFBlock()) {
			if (lexer_ReachedELSEBlock()) {
				fatal("Found ELIF after an ELSE block");
			}
			lexer_SetMode(LEXER_SKIP_TO_ENDC);
		} else if (yystack_[1].value.as < int32_t > ()) {
			lexer_RunIFBlock();
		} else {
			lexer_SetMode(LEXER_SKIP_TO_ELIF);
		}
	}
#line 1197 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 25: // else: "ELSE" "end of line"
#line 497 "asm/parser.y"
                         {
		if (lexer_GetIFDepth() == 0) {
			fatal("Found ELSE outside of an IF construct");
		}
		if (lexer_RanIFBlock()) {
			if (lexer_ReachedELSEBlock()) {
				fatal("Found ELSE after an ELSE block");
			}
			lexer_SetMode(LEXER_SKIP_TO_ENDC);
		} else {
			lexer_RunIFBlock();
			lexer_ReachELSEBlock();
		}
	}
#line 1216 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 30: // endc: "ENDC"
#line 523 "asm/parser.y"
                 {
		lexer_DecIFDepth();
	}
#line 1224 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 31: // $@2: %empty
#line 529 "asm/parser.y"
               {
		lexer_ToggleStringExpansion(false);
	}
#line 1232 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 32: // def_id: "DEF" $@2 "symbol"
#line 531 "asm/parser.y"
                 {
		lexer_ToggleStringExpansion(true);
		yylhs.value.as < std::string > () = std::move(yystack_[0].value.as < std::string > ());
	}
#line 1241 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 33: // $@3: %empty
#line 538 "asm/parser.y"
                  {
		lexer_ToggleStringExpansion(false);
	}
#line 1249 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 34: // redef_id: "REDEF" $@3 "symbol"
#line 540 "asm/parser.y"
                 {
		lexer_ToggleStringExpansion(true);
		yylhs.value.as < std::string > () = std::move(yystack_[0].value.as < std::string > ());
	}
#line 1258 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 35: // scoped_sym_no_anon: "symbol"
#line 546 "asm/parser.y"
                    { yylhs.value.as < std::string > () = yystack_[0].value.as < std::string > (); }
#line 1264 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 36: // scoped_sym_no_anon: "label"
#line 546 "asm/parser.y"
                             { yylhs.value.as < std::string > () = yystack_[0].value.as < std::string > (); }
#line 1270 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 37: // scoped_sym_no_anon: "local label"
#line 546 "asm/parser.y"
                                     { yylhs.value.as < std::string > () = yystack_[0].value.as < std::string > (); }
#line 1276 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 38: // scoped_sym: scoped_sym_no_anon
#line 548 "asm/parser.y"
            { yylhs.value.as < std::string > () = yystack_[0].value.as < std::string > (); }
#line 1282 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 39: // scoped_sym: "anonymous label"
#line 548 "asm/parser.y"
                                 { yylhs.value.as < std::string > () = yystack_[0].value.as < std::string > (); }
#line 1288 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 41: // label: "label" ":"
#line 552 "asm/parser.y"
                      {
		sym_AddLabel(yystack_[1].value.as < std::string > ());
	}
#line 1296 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 42: // label: "label" "::"
#line 555 "asm/parser.y"
                             {
		sym_AddLabel(yystack_[1].value.as < std::string > ());
		sym_Export(yystack_[1].value.as < std::string > ());
	}
#line 1305 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 43: // label: "local label"
#line 559 "asm/parser.y"
                {
		sym_AddLocalLabel(yystack_[0].value.as < std::string > ());
	}
#line 1313 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 44: // label: "local label" ":"
#line 562 "asm/parser.y"
                      {
		sym_AddLocalLabel(yystack_[1].value.as < std::string > ());
	}
#line 1321 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 45: // label: "local label" "::"
#line 565 "asm/parser.y"
                             {
		sym_AddLocalLabel(yystack_[1].value.as < std::string > ());
		sym_Export(yystack_[1].value.as < std::string > ());
	}
#line 1330 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 46: // label: ":"
#line 569 "asm/parser.y"
                {
		sym_AddAnonLabel();
	}
#line 1338 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 47: // $@4: %empty
#line 575 "asm/parser.y"
               {
		// Parsing 'macro_args' will restore the lexer's normal mode
		lexer_SetMode(LEXER_RAW);
	}
#line 1347 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 48: // macro: "symbol" $@4 macro_args
#line 578 "asm/parser.y"
                     {
		fstk_RunMacro(yystack_[2].value.as < std::string > (), yystack_[0].value.as < std::shared_ptr<MacroArgs> > ());
	}
#line 1355 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 49: // macro_args: %empty
#line 584 "asm/parser.y"
               {
		yylhs.value.as < std::shared_ptr<MacroArgs> > () = std::make_shared<MacroArgs>();
	}
#line 1363 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 50: // macro_args: macro_args "string"
#line 587 "asm/parser.y"
                            {
		yylhs.value.as < std::shared_ptr<MacroArgs> > () = std::move(yystack_[1].value.as < std::shared_ptr<MacroArgs> > ());
		yylhs.value.as < std::shared_ptr<MacroArgs> > ()->appendArg(std::make_shared<std::string>(yystack_[0].value.as < std::string > ()));
	}
#line 1372 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 90: // def_numeric: def_equ
#line 636 "asm/parser.y"
          { yylhs.value.as < std::string > () = yystack_[0].value.as < std::string > (); }
#line 1378 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 91: // def_numeric: redef_equ
#line 637 "asm/parser.y"
          { yylhs.value.as < std::string > () = yystack_[0].value.as < std::string > (); }
#line 1384 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 92: // def_numeric: def_set
#line 638 "asm/parser.y"
          { yylhs.value.as < std::string > () = yystack_[0].value.as < std::string > (); }
#line 1390 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 93: // def_numeric: def_rb
#line 639 "asm/parser.y"
          { yylhs.value.as < std::string > () = yystack_[0].value.as < std::string > (); }
#line 1396 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 94: // def_numeric: def_rw
#line 640 "asm/parser.y"
          { yylhs.value.as < std::string > () = yystack_[0].value.as < std::string > (); }
#line 1402 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 95: // def_numeric: def_rl
#line 641 "asm/parser.y"
          { yylhs.value.as < std::string > () = yystack_[0].value.as < std::string > (); }
#line 1408 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 98: // compound_eq: "+="
#line 647 "asm/parser.y"
                  {
		yylhs.value.as < RPNCommand > () = RPN_ADD;
	}
#line 1416 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 99: // compound_eq: "-="
#line 650 "asm/parser.y"
                    {
		yylhs.value.as < RPNCommand > () = RPN_SUB;
	}
#line 1424 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 100: // compound_eq: "*="
#line 653 "asm/parser.y"
                    {
		yylhs.value.as < RPNCommand > () = RPN_MUL;
	}
#line 1432 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 101: // compound_eq: "/="
#line 656 "asm/parser.y"
                    {
		yylhs.value.as < RPNCommand > () = RPN_DIV;
	}
#line 1440 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 102: // compound_eq: "%="
#line 659 "asm/parser.y"
                    {
		yylhs.value.as < RPNCommand > () = RPN_MOD;
	}
#line 1448 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 103: // compound_eq: "^="
#line 662 "asm/parser.y"
                    {
		yylhs.value.as < RPNCommand > () = RPN_XOR;
	}
#line 1456 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 104: // compound_eq: "|="
#line 665 "asm/parser.y"
                   {
		yylhs.value.as < RPNCommand > () = RPN_OR;
	}
#line 1464 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 105: // compound_eq: "&="
#line 668 "asm/parser.y"
                    {
		yylhs.value.as < RPNCommand > () = RPN_AND;
	}
#line 1472 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 106: // compound_eq: "<<="
#line 671 "asm/parser.y"
                    {
		yylhs.value.as < RPNCommand > () = RPN_SHL;
	}
#line 1480 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 107: // compound_eq: ">>="
#line 674 "asm/parser.y"
                    {
		yylhs.value.as < RPNCommand > () = RPN_SHR;
	}
#line 1488 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 108: // align: "ALIGN" align_spec
#line 680 "asm/parser.y"
                             {
		sect_AlignPC(yystack_[0].value.as < AlignmentSpec > ().alignment, yystack_[0].value.as < AlignmentSpec > ().alignOfs);
	}
#line 1496 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 109: // align_spec: uconst
#line 686 "asm/parser.y"
               {
		if (yystack_[0].value.as < int32_t > () > 16) {
			::error("Alignment must be between 0 and 16, not %u", yystack_[0].value.as < int32_t > ());
			yylhs.value.as < AlignmentSpec > ().alignment = yylhs.value.as < AlignmentSpec > ().alignOfs = 0;
		} else {
			yylhs.value.as < AlignmentSpec > ().alignment = yystack_[0].value.as < int32_t > ();
			yylhs.value.as < AlignmentSpec > ().alignOfs = 0;
		}
	}
#line 1510 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 110: // align_spec: uconst "," iconst
#line 695 "asm/parser.y"
                              {
		if (yystack_[2].value.as < int32_t > () > 16) {
			::error("Alignment must be between 0 and 16, not %u", yystack_[2].value.as < int32_t > ());
			yylhs.value.as < AlignmentSpec > ().alignment = yylhs.value.as < AlignmentSpec > ().alignOfs = 0;
		} else if (yystack_[0].value.as < int32_t > () <= -(1 << yystack_[2].value.as < int32_t > ()) || yystack_[0].value.as < int32_t > () >= 1 << yystack_[2].value.as < int32_t > ()) {
			::error(
			    "The absolute alignment offset (%" PRIu32 ") must be less than alignment size (%d)",
			    static_cast<uint32_t>(yystack_[0].value.as < int32_t > () < 0 ? -yystack_[0].value.as < int32_t > () : yystack_[0].value.as < int32_t > ()),
			    1 << yystack_[2].value.as < int32_t > ()
			);
			yylhs.value.as < AlignmentSpec > ().alignment = yylhs.value.as < AlignmentSpec > ().alignOfs = 0;
		} else {
			yylhs.value.as < AlignmentSpec > ().alignment = yystack_[2].value.as < int32_t > ();
			yylhs.value.as < AlignmentSpec > ().alignOfs = yystack_[0].value.as < int32_t > () < 0 ? (1 << yystack_[2].value.as < int32_t > ()) + yystack_[0].value.as < int32_t > () : yystack_[0].value.as < int32_t > ();
		}
	}
#line 1531 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 111: // $@5: %empty
#line 714 "asm/parser.y"
                {
		// Parsing 'opt_list' will restore the lexer's normal mode
		lexer_SetMode(LEXER_RAW);
	}
#line 1540 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 115: // opt_list_entry: "string"
#line 726 "asm/parser.y"
               {
		opt_Parse(yystack_[0].value.as < std::string > ().c_str());
	}
#line 1548 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 116: // popo: "POPO"
#line 732 "asm/parser.y"
                 {
		opt_Pop();
	}
#line 1556 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 117: // $@6: %empty
#line 738 "asm/parser.y"
                  {
		opt_Push();
		// Parsing 'pusho_opt_list' will restore the lexer's normal mode
		lexer_SetMode(LEXER_RAW);
	}
#line 1566 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 119: // pusho_opt_list: %empty
#line 746 "asm/parser.y"
               {
		lexer_SetMode(LEXER_NORMAL);
	}
#line 1574 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 121: // pops: "POPS"
#line 753 "asm/parser.y"
                 {
		sect_PopSection();
	}
#line 1582 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 122: // pushs: "PUSHS"
#line 759 "asm/parser.y"
                  {
		sect_PushSection();
	}
#line 1590 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 123: // endsection: "ENDSECTION"
#line 765 "asm/parser.y"
                       {
		sect_EndSection();
	}
#line 1598 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 124: // fail: "FAIL" string
#line 771 "asm/parser.y"
                        {
		fatal("%s", yystack_[0].value.as < std::string > ().c_str());
	}
#line 1606 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 125: // warn: "WARN" string
#line 777 "asm/parser.y"
                        {
		warning(WARNING_USER, "%s", yystack_[0].value.as < std::string > ().c_str());
	}
#line 1614 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 126: // assert_type: %empty
#line 783 "asm/parser.y"
               {
		yylhs.value.as < AssertionType > () = ASSERT_ERROR;
	}
#line 1622 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 127: // assert_type: "WARN" ","
#line 786 "asm/parser.y"
                         {
		yylhs.value.as < AssertionType > () = ASSERT_WARN;
	}
#line 1630 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 128: // assert_type: "FAIL" ","
#line 789 "asm/parser.y"
                         {
		yylhs.value.as < AssertionType > () = ASSERT_ERROR;
	}
#line 1638 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 129: // assert_type: "FATAL" ","
#line 792 "asm/parser.y"
                          {
		yylhs.value.as < AssertionType > () = ASSERT_FATAL;
	}
#line 1646 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 130: // assert: "ASSERT" assert_type relocexpr
#line 798 "asm/parser.y"
                                         {
		if (!yystack_[0].value.as < Expression > ().isKnown()) {
			out_CreateAssert(yystack_[1].value.as < AssertionType > (), yystack_[0].value.as < Expression > (), "", sect_GetOutputOffset());
		} else if (yystack_[0].value.as < Expression > ().value() == 0) {
			act_FailAssert(yystack_[1].value.as < AssertionType > ());
		}
	}
#line 1658 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 131: // assert: "ASSERT" assert_type relocexpr "," string
#line 805 "asm/parser.y"
                                                        {
		if (!yystack_[2].value.as < Expression > ().isKnown()) {
			out_CreateAssert(yystack_[3].value.as < AssertionType > (), yystack_[2].value.as < Expression > (), yystack_[0].value.as < std::string > (), sect_GetOutputOffset());
		} else if (yystack_[2].value.as < Expression > ().value() == 0) {
			act_FailAssertMsg(yystack_[3].value.as < AssertionType > (), yystack_[0].value.as < std::string > ());
		}
	}
#line 1670 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 132: // assert: "STATIC_ASSERT" assert_type iconst
#line 812 "asm/parser.y"
                                               {
		if (yystack_[0].value.as < int32_t > () == 0) {
			act_FailAssert(yystack_[1].value.as < AssertionType > ());
		}
	}
#line 1680 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 133: // assert: "STATIC_ASSERT" assert_type iconst "," string
#line 817 "asm/parser.y"
                                                            {
		if (yystack_[2].value.as < int32_t > () == 0) {
			act_FailAssertMsg(yystack_[3].value.as < AssertionType > (), yystack_[0].value.as < std::string > ());
		}
	}
#line 1690 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 134: // shift: "SHIFT" shift_const
#line 825 "asm/parser.y"
                              {
		if (MacroArgs *macroArgs = fstk_GetCurrentMacroArgs(); macroArgs) {
			macroArgs->shiftArgs(yystack_[0].value.as < int32_t > ());
		} else {
			::error("Cannot shift macro arguments outside of a macro");
		}
	}
#line 1702 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 135: // shift_const: %empty
#line 835 "asm/parser.y"
               {
		yylhs.value.as < int32_t > () = 1;
	}
#line 1710 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 136: // shift_const: iconst
#line 838 "asm/parser.y"
          { yylhs.value.as < int32_t > () = yystack_[0].value.as < int32_t > (); }
#line 1716 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 137: // load: "LOAD" sect_mod string "," sect_type sect_org sect_attrs
#line 842 "asm/parser.y"
                                                                     {
		sect_SetLoadSection(yystack_[4].value.as < std::string > (), yystack_[2].value.as < SectionType > (), yystack_[1].value.as < int32_t > (), yystack_[0].value.as < SectionSpec > (), yystack_[5].value.as < SectionModifier > ());
	}
#line 1724 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 138: // load: "ENDL"
#line 845 "asm/parser.y"
                   {
		sect_EndLoadSection(nullptr);
	}
#line 1732 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 139: // rept: "REPT" uconst "end of line" capture_rept endofline
#line 851 "asm/parser.y"
                                                       {
		if (yystack_[1].value.as < Capture > ().span.ptr) {
			fstk_RunRept(yystack_[3].value.as < int32_t > (), yystack_[1].value.as < Capture > ().lineNo, yystack_[1].value.as < Capture > ().span);
		}
	}
#line 1742 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 140: // $@7: %empty
#line 859 "asm/parser.y"
                {
		lexer_ToggleStringExpansion(false);
	}
#line 1750 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 141: // $@8: %empty
#line 861 "asm/parser.y"
                 {
		lexer_ToggleStringExpansion(true);
	}
#line 1758 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 142: // for: "FOR" $@7 "symbol" $@8 "," for_args "end of line" capture_rept endofline
#line 863 "asm/parser.y"
                                                        {
		if (yystack_[1].value.as < Capture > ().span.ptr) {
			fstk_RunFor(yystack_[6].value.as < std::string > (), yystack_[3].value.as < ForArgs > ().start, yystack_[3].value.as < ForArgs > ().stop, yystack_[3].value.as < ForArgs > ().step, yystack_[1].value.as < Capture > ().lineNo, yystack_[1].value.as < Capture > ().span);
		}
	}
#line 1768 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 143: // capture_rept: %empty
#line 871 "asm/parser.y"
               {
		yylhs.value.as < Capture > () = lexer_CaptureRept();
	}
#line 1776 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 144: // for_args: iconst
#line 877 "asm/parser.y"
               {
		yylhs.value.as < ForArgs > ().start = 0;
		yylhs.value.as < ForArgs > ().stop = yystack_[0].value.as < int32_t > ();
		yylhs.value.as < ForArgs > ().step = 1;
	}
#line 1786 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 145: // for_args: iconst "," iconst
#line 882 "asm/parser.y"
                              {
		yylhs.value.as < ForArgs > ().start = yystack_[2].value.as < int32_t > ();
		yylhs.value.as < ForArgs > ().stop = yystack_[0].value.as < int32_t > ();
		yylhs.value.as < ForArgs > ().step = 1;
	}
#line 1796 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 146: // for_args: iconst "," iconst "," iconst
#line 887 "asm/parser.y"
                                           {
		yylhs.value.as < ForArgs > ().start = yystack_[4].value.as < int32_t > ();
		yylhs.value.as < ForArgs > ().stop = yystack_[2].value.as < int32_t > ();
		yylhs.value.as < ForArgs > ().step = yystack_[0].value.as < int32_t > ();
	}
#line 1806 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 147: // break: label "BREAK" endofline
#line 895 "asm/parser.y"
                                  {
		if (fstk_Break()) {
			lexer_SetMode(LEXER_SKIP_TO_ENDR);
		}
	}
#line 1816 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 148: // $@9: %empty
#line 903 "asm/parser.y"
                  {
		lexer_ToggleStringExpansion(false);
	}
#line 1824 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 149: // $@10: %empty
#line 905 "asm/parser.y"
                 {
		lexer_ToggleStringExpansion(true);
	}
#line 1832 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 150: // def_macro: "MACRO" $@9 "symbol" $@10 "end of line" capture_macro endofline
#line 907 "asm/parser.y"
                                          {
		if (yystack_[1].value.as < Capture > ().span.ptr) {
			sym_AddMacro(yystack_[4].value.as < std::string > (), yystack_[1].value.as < Capture > ().lineNo, yystack_[1].value.as < Capture > ().span);
		}
	}
#line 1842 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 151: // capture_macro: %empty
#line 915 "asm/parser.y"
               {
		yylhs.value.as < Capture > () = lexer_CaptureMacro();
	}
#line 1850 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 152: // rsset: "RSSET" uconst
#line 921 "asm/parser.y"
                         {
		sym_SetRSValue(yystack_[0].value.as < int32_t > ());
	}
#line 1858 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 153: // rsreset: "RSRESET"
#line 927 "asm/parser.y"
                    {
		sym_SetRSValue(0);
	}
#line 1866 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 154: // rs_uconst: %empty
#line 933 "asm/parser.y"
               {
		yylhs.value.as < int32_t > () = 1;
	}
#line 1874 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 155: // rs_uconst: uconst
#line 936 "asm/parser.y"
          { yylhs.value.as < int32_t > () = yystack_[0].value.as < int32_t > (); }
#line 1880 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 156: // union: "UNION"
#line 940 "asm/parser.y"
                  {
		sect_StartUnion();
	}
#line 1888 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 157: // nextu: "NEXTU"
#line 946 "asm/parser.y"
                  {
		sect_NextUnionMember();
	}
#line 1896 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 158: // endu: "ENDU"
#line 952 "asm/parser.y"
                 {
		sect_EndUnion();
	}
#line 1904 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 159: // ds: "DS" uconst
#line 958 "asm/parser.y"
                      {
		sect_Skip(yystack_[0].value.as < int32_t > (), true);
	}
#line 1912 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 160: // ds: "DS" uconst "," ds_args trailing_comma
#line 961 "asm/parser.y"
                                                     {
		sect_RelBytes(yystack_[3].value.as < int32_t > (), yystack_[1].value.as < std::vector<Expression> > ());
	}
#line 1920 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 161: // ds: "DS" "ALIGN" "[" align_spec "]" trailing_comma
#line 964 "asm/parser.y"
                                                                   {
		uint32_t n = sect_GetAlignBytes(yystack_[2].value.as < AlignmentSpec > ().alignment, yystack_[2].value.as < AlignmentSpec > ().alignOfs);

		sect_Skip(n, true);
		sect_AlignPC(yystack_[2].value.as < AlignmentSpec > ().alignment, yystack_[2].value.as < AlignmentSpec > ().alignOfs);
	}
#line 1931 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 162: // ds: "DS" "ALIGN" "[" align_spec "]" "," ds_args trailing_comma
#line 970 "asm/parser.y"
                                                                                 {
		uint32_t n = sect_GetAlignBytes(yystack_[4].value.as < AlignmentSpec > ().alignment, yystack_[4].value.as < AlignmentSpec > ().alignOfs);

		sect_RelBytes(n, yystack_[1].value.as < std::vector<Expression> > ());
		sect_AlignPC(yystack_[4].value.as < AlignmentSpec > ().alignment, yystack_[4].value.as < AlignmentSpec > ().alignOfs);
	}
#line 1942 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 163: // ds_args: reloc_8bit
#line 979 "asm/parser.y"
                   {
		yylhs.value.as < std::vector<Expression> > ().push_back(std::move(yystack_[0].value.as < Expression > ()));
	}
#line 1950 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 164: // ds_args: ds_args "," reloc_8bit
#line 982 "asm/parser.y"
                                   {
		yylhs.value.as < std::vector<Expression> > () = std::move(yystack_[2].value.as < std::vector<Expression> > ());
		yylhs.value.as < std::vector<Expression> > ().push_back(std::move(yystack_[0].value.as < Expression > ()));
	}
#line 1959 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 165: // db: "DB"
#line 989 "asm/parser.y"
               {
		sect_Skip(1, false);
	}
#line 1967 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 167: // dw: "DW"
#line 996 "asm/parser.y"
               {
		sect_Skip(2, false);
	}
#line 1975 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 169: // dl: "DL"
#line 1003 "asm/parser.y"
               {
		sect_Skip(4, false);
	}
#line 1983 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 171: // def_equ: def_id "EQU" iconst
#line 1010 "asm/parser.y"
                              {
		yylhs.value.as < std::string > () = std::move(yystack_[2].value.as < std::string > ());
		sym_AddEqu(yylhs.value.as < std::string > (), yystack_[0].value.as < int32_t > ());
	}
#line 1992 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 172: // redef_equ: redef_id "EQU" iconst
#line 1017 "asm/parser.y"
                                {
		yylhs.value.as < std::string > () = std::move(yystack_[2].value.as < std::string > ());
		sym_RedefEqu(yylhs.value.as < std::string > (), yystack_[0].value.as < int32_t > ());
	}
#line 2001 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 173: // def_set: def_id "=" iconst
#line 1024 "asm/parser.y"
                                {
		yylhs.value.as < std::string > () = std::move(yystack_[2].value.as < std::string > ());
		sym_AddVar(yylhs.value.as < std::string > (), yystack_[0].value.as < int32_t > ());
	}
#line 2010 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 174: // def_set: redef_id "=" iconst
#line 1028 "asm/parser.y"
                                    {
		yylhs.value.as < std::string > () = std::move(yystack_[2].value.as < std::string > ());
		sym_AddVar(yylhs.value.as < std::string > (), yystack_[0].value.as < int32_t > ());
	}
#line 2019 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 175: // def_set: def_id compound_eq iconst
#line 1032 "asm/parser.y"
                                    {
		yylhs.value.as < std::string > () = std::move(yystack_[2].value.as < std::string > ());
		act_CompoundAssignment(yylhs.value.as < std::string > (), yystack_[1].value.as < RPNCommand > (), yystack_[0].value.as < int32_t > ());
	}
#line 2028 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 176: // def_set: redef_id compound_eq iconst
#line 1036 "asm/parser.y"
                                      {
		yylhs.value.as < std::string > () = std::move(yystack_[2].value.as < std::string > ());
		act_CompoundAssignment(yylhs.value.as < std::string > (), yystack_[1].value.as < RPNCommand > (), yystack_[0].value.as < int32_t > ());
	}
#line 2037 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 177: // def_rb: def_id "RB" rs_uconst
#line 1043 "asm/parser.y"
                                {
		yylhs.value.as < std::string > () = std::move(yystack_[2].value.as < std::string > ());
		uint32_t rs = sym_GetRSValue();
		sym_AddEqu(yylhs.value.as < std::string > (), rs);
		sym_SetRSValue(rs + yystack_[0].value.as < int32_t > ());
	}
#line 2048 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 178: // def_rw: def_id "RW" rs_uconst
#line 1052 "asm/parser.y"
                                {
		yylhs.value.as < std::string > () = std::move(yystack_[2].value.as < std::string > ());
		uint32_t rs = sym_GetRSValue();
		sym_AddEqu(yylhs.value.as < std::string > (), rs);
		sym_SetRSValue(rs + 2 * yystack_[0].value.as < int32_t > ());
	}
#line 2059 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 179: // def_rl: def_id "rl" rs_uconst
#line 1061 "asm/parser.y"
                                 {
		yylhs.value.as < std::string > () = std::move(yystack_[2].value.as < std::string > ());
		uint32_t rs = sym_GetRSValue();
		sym_AddEqu(yylhs.value.as < std::string > (), rs);
		sym_SetRSValue(rs + 4 * yystack_[0].value.as < int32_t > ());
	}
#line 2070 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 180: // def_equs: def_id "EQUS" string
#line 1070 "asm/parser.y"
                               {
		yylhs.value.as < std::string > () = std::move(yystack_[2].value.as < std::string > ());
		sym_AddString(yylhs.value.as < std::string > (), std::make_shared<std::string>(yystack_[0].value.as < std::string > ()));
	}
#line 2079 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 181: // redef_equs: redef_id "EQUS" string
#line 1077 "asm/parser.y"
                                 {
		yylhs.value.as < std::string > () = std::move(yystack_[2].value.as < std::string > ());
		sym_RedefString(yylhs.value.as < std::string > (), std::make_shared<std::string>(yystack_[0].value.as < std::string > ()));
	}
#line 2088 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 182: // $@11: %empty
#line 1084 "asm/parser.y"
                  {
		lexer_ToggleStringExpansion(false);
	}
#line 2096 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 183: // purge: "PURGE" $@11 purge_args trailing_comma
#line 1086 "asm/parser.y"
                                    {
		for (std::string &arg : yystack_[1].value.as < std::vector<std::string> > ()) {
			sym_Purge(arg);
		}
		lexer_ToggleStringExpansion(true);
	}
#line 2107 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 184: // purge_args: scoped_sym_no_anon
#line 1095 "asm/parser.y"
                           {
		yylhs.value.as < std::vector<std::string> > ().push_back(yystack_[0].value.as < std::string > ());
	}
#line 2115 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 185: // purge_args: purge_args "," scoped_sym_no_anon
#line 1098 "asm/parser.y"
                                              {
		yylhs.value.as < std::vector<std::string> > () = std::move(yystack_[2].value.as < std::vector<std::string> > ());
		yylhs.value.as < std::vector<std::string> > ().push_back(yystack_[0].value.as < std::string > ());
	}
#line 2124 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 189: // export_list_entry: scoped_sym_no_anon
#line 1112 "asm/parser.y"
                           {
		sym_Export(yystack_[0].value.as < std::string > ());
	}
#line 2132 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 190: // export_def: "EXPORT" def_numeric
#line 1118 "asm/parser.y"
                               {
		sym_Export(yystack_[0].value.as < std::string > ());
	}
#line 2140 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 191: // include: label "INCLUDE" string endofline
#line 1124 "asm/parser.y"
                                           {
		if (fstk_RunInclude(yystack_[1].value.as < std::string > ())) {
			YYACCEPT;
		}
	}
#line 2150 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 192: // incbin: "INCBIN" string
#line 1132 "asm/parser.y"
                          {
		if (sect_BinaryFile(yystack_[0].value.as < std::string > (), 0)) {
			YYACCEPT;
		}
	}
#line 2160 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 193: // incbin: "INCBIN" string "," uconst
#line 1137 "asm/parser.y"
                                         {
		if (sect_BinaryFile(yystack_[2].value.as < std::string > (), yystack_[0].value.as < int32_t > ())) {
			YYACCEPT;
		}
	}
#line 2170 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 194: // incbin: "INCBIN" string "," uconst "," uconst
#line 1142 "asm/parser.y"
                                                      {
		if (sect_BinaryFileSlice(yystack_[4].value.as < std::string > (), yystack_[2].value.as < int32_t > (), yystack_[0].value.as < int32_t > ())) {
			YYACCEPT;
		}
	}
#line 2180 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 195: // charmap: "CHARMAP" string "," charmap_args trailing_comma
#line 1150 "asm/parser.y"
                                                             {
		charmap_Add(yystack_[3].value.as < std::string > (), std::move(yystack_[1].value.as < std::vector<int32_t> > ()));
	}
#line 2188 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 196: // charmap_args: iconst
#line 1156 "asm/parser.y"
               {
		yylhs.value.as < std::vector<int32_t> > ().push_back(std::move(yystack_[0].value.as < int32_t > ()));
	}
#line 2196 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 197: // charmap_args: charmap_args "," iconst
#line 1159 "asm/parser.y"
                                    {
		yylhs.value.as < std::vector<int32_t> > () = std::move(yystack_[2].value.as < std::vector<int32_t> > ());
		yylhs.value.as < std::vector<int32_t> > ().push_back(std::move(yystack_[0].value.as < int32_t > ()));
	}
#line 2205 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 198: // newcharmap: "NEWCHARMAP" "symbol"
#line 1166 "asm/parser.y"
                              {
		charmap_New(yystack_[0].value.as < std::string > (), nullptr);
	}
#line 2213 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 199: // newcharmap: "NEWCHARMAP" "symbol" "," "symbol"
#line 1169 "asm/parser.y"
                                             {
		charmap_New(yystack_[2].value.as < std::string > (), &yystack_[0].value.as < std::string > ());
	}
#line 2221 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 200: // setcharmap: "SETCHARMAP" "symbol"
#line 1175 "asm/parser.y"
                              {
		charmap_Set(yystack_[0].value.as < std::string > ());
	}
#line 2229 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 201: // pushc: "PUSHC"
#line 1181 "asm/parser.y"
                  {
		charmap_Push();
	}
#line 2237 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 202: // pushc_setcharmap: "PUSHC" "symbol"
#line 1187 "asm/parser.y"
                         {
		charmap_Push();
		charmap_Set(yystack_[0].value.as < std::string > ());
	}
#line 2246 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 203: // popc: "POPC"
#line 1194 "asm/parser.y"
                 {
		charmap_Pop();
	}
#line 2254 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 205: // println: "PRINTLN"
#line 1202 "asm/parser.y"
                    {
		putchar('\n');
		fflush(stdout);
	}
#line 2263 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 206: // println: "PRINTLN" print_exprs trailing_comma
#line 1206 "asm/parser.y"
                                                 {
		putchar('\n');
		fflush(stdout);
	}
#line 2272 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 209: // print_expr: relocexpr_no_str
#line 1218 "asm/parser.y"
                         {
		printf("$%" PRIX32, yystack_[0].value.as < Expression > ().getConstVal());
	}
#line 2280 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 210: // print_expr: string_literal
#line 1221 "asm/parser.y"
                         {
		// Allow printing NUL characters
		fwrite(yystack_[0].value.as < std::string > ().data(), 1, yystack_[0].value.as < std::string > ().length(), stdout);
	}
#line 2289 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 211: // print_expr: scoped_sym
#line 1225 "asm/parser.y"
                     {
		handleSymbolByType(
		    yystack_[0].value.as < std::string > (),
		    [](Expression const &expr) { printf("$%" PRIX32, expr.getConstVal()); },
		    [](std::string const &str) { fwrite(str.data(), 1, str.length(), stdout); }
		);
	}
#line 2301 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 212: // reloc_3bit: relocexpr
#line 1235 "asm/parser.y"
                  {
		yylhs.value.as < Expression > () = std::move(yystack_[0].value.as < Expression > ());
		yylhs.value.as < Expression > ().checkNBit(3);
	}
#line 2310 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 215: // constlist_8bit_entry: relocexpr_no_str
#line 1247 "asm/parser.y"
                         {
		yystack_[0].value.as < Expression > ().checkNBit(8);
		sect_RelByte(yystack_[0].value.as < Expression > (), 0);
	}
#line 2319 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 216: // constlist_8bit_entry: string_literal
#line 1251 "asm/parser.y"
                         {
		std::vector<int32_t> output = charmap_Convert(yystack_[0].value.as < std::string > ());
		sect_ByteString(output);
	}
#line 2328 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 217: // constlist_8bit_entry: scoped_sym
#line 1255 "asm/parser.y"
                     {
		handleSymbolByType(
		    yystack_[0].value.as < std::string > (),
		    [](Expression const &expr) {
			    expr.checkNBit(8);
			    sect_RelByte(expr, 0);
		    },
		    [](std::string const &str) {
			    std::vector<int32_t> output = charmap_Convert(str);
			    sect_ByteString(output);
		    }
		);
	}
#line 2346 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 220: // constlist_16bit_entry: relocexpr_no_str
#line 1276 "asm/parser.y"
                         {
		yystack_[0].value.as < Expression > ().checkNBit(16);
		sect_RelWord(yystack_[0].value.as < Expression > (), 0);
	}
#line 2355 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 221: // constlist_16bit_entry: string_literal
#line 1280 "asm/parser.y"
                         {
		std::vector<int32_t> output = charmap_Convert(yystack_[0].value.as < std::string > ());
		sect_WordString(output);
	}
#line 2364 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 222: // constlist_16bit_entry: scoped_sym
#line 1284 "asm/parser.y"
                     {
		handleSymbolByType(
		    yystack_[0].value.as < std::string > (),
		    [](Expression const &expr) {
			    expr.checkNBit(16);
			    sect_RelWord(expr, 0);
		    },
		    [](std::string const &str) {
			    std::vector<int32_t> output = charmap_Convert(str);
			    sect_WordString(output);
		    }
		);
	}
#line 2382 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 223: // constlist_16bit_entry: fragment_literal
#line 1297 "asm/parser.y"
                           {
		Expression expr;
		expr.makeSymbol(yystack_[0].value.as < std::string > ());
		expr.checkNBit(16);
		sect_RelWord(expr, 0);
	}
#line 2393 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 226: // constlist_32bit_entry: relocexpr_no_str
#line 1311 "asm/parser.y"
                         {
		sect_RelLong(yystack_[0].value.as < Expression > (), 0);
	}
#line 2401 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 227: // constlist_32bit_entry: string_literal
#line 1314 "asm/parser.y"
                         {
		std::vector<int32_t> output = charmap_Convert(yystack_[0].value.as < std::string > ());
		sect_LongString(output);
	}
#line 2410 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 228: // constlist_32bit_entry: scoped_sym
#line 1318 "asm/parser.y"
                     {
		handleSymbolByType(
		    yystack_[0].value.as < std::string > (),
		    [](Expression const &expr) { sect_RelLong(expr, 0); },
		    [](std::string const &str) {
			    std::vector<int32_t> output = charmap_Convert(str);
			    sect_LongString(output);
		    }
		);
	}
#line 2425 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 229: // reloc_8bit: relocexpr
#line 1331 "asm/parser.y"
                  {
		yylhs.value.as < Expression > () = std::move(yystack_[0].value.as < Expression > ());
		yylhs.value.as < Expression > ().checkNBit(8);
	}
#line 2434 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 230: // reloc_16bit: relocexpr
#line 1338 "asm/parser.y"
                  {
		yylhs.value.as < Expression > () = std::move(yystack_[0].value.as < Expression > ());
		yylhs.value.as < Expression > ().checkNBit(16);
	}
#line 2443 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 231: // reloc_16bit: fragment_literal
#line 1342 "asm/parser.y"
                           {
		yylhs.value.as < Expression > ().makeSymbol(yystack_[0].value.as < std::string > ());
	}
#line 2451 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 232: // fragment_literal: "[[" fragment_literal_name asm_file "]]"
#line 1348 "asm/parser.y"
                                                       {
		sect_PopSection();
		yylhs.value.as < std::string > () = std::move(yystack_[2].value.as < std::string > ());
	}
#line 2460 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 233: // fragment_literal_name: %empty
#line 1355 "asm/parser.y"
               {
		yylhs.value.as < std::string > () = sect_PushSectionFragmentLiteral();
		sym_AddLabel(yylhs.value.as < std::string > ());
	}
#line 2469 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 234: // relocexpr: relocexpr_no_str
#line 1362 "asm/parser.y"
                         {
		yylhs.value.as < Expression > () = std::move(yystack_[0].value.as < Expression > ());
	}
#line 2477 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 235: // relocexpr: string_literal
#line 1365 "asm/parser.y"
                         {
		std::vector<int32_t> output = charmap_Convert(yystack_[0].value.as < std::string > ());
		yylhs.value.as < Expression > ().makeNumber(act_StringToNum(output));
	}
#line 2486 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 236: // relocexpr: scoped_sym
#line 1369 "asm/parser.y"
                     {
		yylhs.value.as < Expression > () = handleSymbolByType(
		    yystack_[0].value.as < std::string > (),
		    [](Expression const &expr) { return expr; },
		    [](std::string const &str) {
			    std::vector<int32_t> output = charmap_Convert(str);
			    Expression expr;
			    expr.makeNumber(act_StringToNum(output));
			    return expr;
		    }
		);
	}
#line 2503 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 237: // relocexpr_no_str: "number"
#line 1384 "asm/parser.y"
               {
		yylhs.value.as < Expression > ().makeNumber(yystack_[0].value.as < int32_t > ());
	}
#line 2511 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 238: // relocexpr_no_str: "character"
#line 1387 "asm/parser.y"
                    {
		std::vector<int32_t> output = charmap_Convert(yystack_[0].value.as < std::string > ());
		if (output.size() == 1) {
			yylhs.value.as < Expression > ().makeNumber(static_cast<uint32_t>(output[0]));
		} else {
			::error("Character literals must be a single charmap unit");
			yylhs.value.as < Expression > ().makeNumber(0);
		}
	}
#line 2525 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 239: // relocexpr_no_str: "!" relocexpr
#line 1396 "asm/parser.y"
                                          {
		yylhs.value.as < Expression > ().makeUnaryOp(RPN_LOGNOT, std::move(yystack_[0].value.as < Expression > ()));
	}
#line 2533 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 240: // relocexpr_no_str: relocexpr "||" relocexpr
#line 1399 "asm/parser.y"
                                         {
		yylhs.value.as < Expression > ().makeBinaryOp(RPN_LOGOR, std::move(yystack_[2].value.as < Expression > ()), yystack_[0].value.as < Expression > ());
	}
#line 2541 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 241: // relocexpr_no_str: relocexpr "&&" relocexpr
#line 1402 "asm/parser.y"
                                          {
		yylhs.value.as < Expression > ().makeBinaryOp(RPN_LOGAND, std::move(yystack_[2].value.as < Expression > ()), yystack_[0].value.as < Expression > ());
	}
#line 2549 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 242: // relocexpr_no_str: relocexpr "==" relocexpr
#line 1405 "asm/parser.y"
                                          {
		yylhs.value.as < Expression > ().makeBinaryOp(RPN_LOGEQ, std::move(yystack_[2].value.as < Expression > ()), yystack_[0].value.as < Expression > ());
	}
#line 2557 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 243: // relocexpr_no_str: relocexpr ">" relocexpr
#line 1408 "asm/parser.y"
                                         {
		yylhs.value.as < Expression > ().makeBinaryOp(RPN_LOGGT, std::move(yystack_[2].value.as < Expression > ()), yystack_[0].value.as < Expression > ());
	}
#line 2565 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 244: // relocexpr_no_str: relocexpr "<" relocexpr
#line 1411 "asm/parser.y"
                                         {
		yylhs.value.as < Expression > ().makeBinaryOp(RPN_LOGLT, std::move(yystack_[2].value.as < Expression > ()), yystack_[0].value.as < Expression > ());
	}
#line 2573 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 245: // relocexpr_no_str: relocexpr ">=" relocexpr
#line 1414 "asm/parser.y"
                                         {
		yylhs.value.as < Expression > ().makeBinaryOp(RPN_LOGGE, std::move(yystack_[2].value.as < Expression > ()), yystack_[0].value.as < Expression > ());
	}
#line 2581 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 246: // relocexpr_no_str: relocexpr "<=" relocexpr
#line 1417 "asm/parser.y"
                                         {
		yylhs.value.as < Expression > ().makeBinaryOp(RPN_LOGLE, std::move(yystack_[2].value.as < Expression > ()), yystack_[0].value.as < Expression > ());
	}
#line 2589 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 247: // relocexpr_no_str: relocexpr "!=" relocexpr
#line 1420 "asm/parser.y"
                                         {
		yylhs.value.as < Expression > ().makeBinaryOp(RPN_LOGNE, std::move(yystack_[2].value.as < Expression > ()), yystack_[0].value.as < Expression > ());
	}
#line 2597 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 248: // relocexpr_no_str: relocexpr "+" relocexpr
#line 1423 "asm/parser.y"
                                     {
		yylhs.value.as < Expression > ().makeBinaryOp(RPN_ADD, std::move(yystack_[2].value.as < Expression > ()), yystack_[0].value.as < Expression > ());
	}
#line 2605 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 249: // relocexpr_no_str: relocexpr "-" relocexpr
#line 1426 "asm/parser.y"
                                     {
		yylhs.value.as < Expression > ().makeBinaryOp(RPN_SUB, std::move(yystack_[2].value.as < Expression > ()), yystack_[0].value.as < Expression > ());
	}
#line 2613 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 250: // relocexpr_no_str: relocexpr "^" relocexpr
#line 1429 "asm/parser.y"
                                     {
		yylhs.value.as < Expression > ().makeBinaryOp(RPN_XOR, std::move(yystack_[2].value.as < Expression > ()), yystack_[0].value.as < Expression > ());
	}
#line 2621 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 251: // relocexpr_no_str: relocexpr "|" relocexpr
#line 1432 "asm/parser.y"
                                    {
		yylhs.value.as < Expression > ().makeBinaryOp(RPN_OR, std::move(yystack_[2].value.as < Expression > ()), yystack_[0].value.as < Expression > ());
	}
#line 2629 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 252: // relocexpr_no_str: relocexpr "&" relocexpr
#line 1435 "asm/parser.y"
                                     {
		yylhs.value.as < Expression > ().makeBinaryOp(RPN_AND, std::move(yystack_[2].value.as < Expression > ()), yystack_[0].value.as < Expression > ());
	}
#line 2637 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 253: // relocexpr_no_str: relocexpr "<<" relocexpr
#line 1438 "asm/parser.y"
                                     {
		yylhs.value.as < Expression > ().makeBinaryOp(RPN_SHL, std::move(yystack_[2].value.as < Expression > ()), yystack_[0].value.as < Expression > ());
	}
#line 2645 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 254: // relocexpr_no_str: relocexpr ">>" relocexpr
#line 1441 "asm/parser.y"
                                     {
		yylhs.value.as < Expression > ().makeBinaryOp(RPN_SHR, std::move(yystack_[2].value.as < Expression > ()), yystack_[0].value.as < Expression > ());
	}
#line 2653 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 255: // relocexpr_no_str: relocexpr ">>>" relocexpr
#line 1444 "asm/parser.y"
                                      {
		yylhs.value.as < Expression > ().makeBinaryOp(RPN_USHR, std::move(yystack_[2].value.as < Expression > ()), yystack_[0].value.as < Expression > ());
	}
#line 2661 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 256: // relocexpr_no_str: relocexpr "*" relocexpr
#line 1447 "asm/parser.y"
                                     {
		yylhs.value.as < Expression > ().makeBinaryOp(RPN_MUL, std::move(yystack_[2].value.as < Expression > ()), yystack_[0].value.as < Expression > ());
	}
#line 2669 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 257: // relocexpr_no_str: relocexpr "/" relocexpr
#line 1450 "asm/parser.y"
                                     {
		yylhs.value.as < Expression > ().makeBinaryOp(RPN_DIV, std::move(yystack_[2].value.as < Expression > ()), yystack_[0].value.as < Expression > ());
	}
#line 2677 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 258: // relocexpr_no_str: relocexpr "%" relocexpr
#line 1453 "asm/parser.y"
                                     {
		yylhs.value.as < Expression > ().makeBinaryOp(RPN_MOD, std::move(yystack_[2].value.as < Expression > ()), yystack_[0].value.as < Expression > ());
	}
#line 2685 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 259: // relocexpr_no_str: relocexpr "**" relocexpr
#line 1456 "asm/parser.y"
                                     {
		yylhs.value.as < Expression > ().makeBinaryOp(RPN_EXP, std::move(yystack_[2].value.as < Expression > ()), yystack_[0].value.as < Expression > ());
	}
#line 2693 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 260: // relocexpr_no_str: "+" relocexpr
#line 1459 "asm/parser.y"
                                     {
		yylhs.value.as < Expression > () = std::move(yystack_[0].value.as < Expression > ());
	}
#line 2701 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 261: // relocexpr_no_str: "-" relocexpr
#line 1462 "asm/parser.y"
                                     {
		yylhs.value.as < Expression > ().makeUnaryOp(RPN_NEG, std::move(yystack_[0].value.as < Expression > ()));
	}
#line 2709 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 262: // relocexpr_no_str: "~" relocexpr
#line 1465 "asm/parser.y"
                                     {
		yylhs.value.as < Expression > ().makeUnaryOp(RPN_NOT, std::move(yystack_[0].value.as < Expression > ()));
	}
#line 2717 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 263: // relocexpr_no_str: "HIGH" "(" relocexpr ")"
#line 1468 "asm/parser.y"
                                          {
		yylhs.value.as < Expression > ().makeUnaryOp(RPN_HIGH, std::move(yystack_[1].value.as < Expression > ()));
	}
#line 2725 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 264: // relocexpr_no_str: "LOW" "(" relocexpr ")"
#line 1471 "asm/parser.y"
                                         {
		yylhs.value.as < Expression > ().makeUnaryOp(RPN_LOW, std::move(yystack_[1].value.as < Expression > ()));
	}
#line 2733 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 265: // relocexpr_no_str: "BITWIDTH" "(" relocexpr ")"
#line 1474 "asm/parser.y"
                                              {
		yylhs.value.as < Expression > ().makeUnaryOp(RPN_BITWIDTH, std::move(yystack_[1].value.as < Expression > ()));
	}
#line 2741 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 266: // relocexpr_no_str: "TZCOUNT" "(" relocexpr ")"
#line 1477 "asm/parser.y"
                                             {
		yylhs.value.as < Expression > ().makeUnaryOp(RPN_TZCOUNT, std::move(yystack_[1].value.as < Expression > ()));
	}
#line 2749 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 267: // relocexpr_no_str: "ISCONST" "(" relocexpr ")"
#line 1480 "asm/parser.y"
                                             {
		yylhs.value.as < Expression > ().makeNumber(yystack_[1].value.as < Expression > ().isKnown());
	}
#line 2757 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 268: // relocexpr_no_str: "BANK" "(" scoped_sym ")"
#line 1483 "asm/parser.y"
                                           {
		// '@' is also a SYMBOL; it is handled here
		yylhs.value.as < Expression > ().makeBankSymbol(yystack_[1].value.as < std::string > ());
	}
#line 2766 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 269: // relocexpr_no_str: "BANK" "(" string_literal ")"
#line 1487 "asm/parser.y"
                                               {
		yylhs.value.as < Expression > ().makeBankSection(yystack_[1].value.as < std::string > ());
	}
#line 2774 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 270: // relocexpr_no_str: "SIZEOF" "(" string ")"
#line 1490 "asm/parser.y"
                                         {
		yylhs.value.as < Expression > ().makeSizeOfSection(yystack_[1].value.as < std::string > ());
	}
#line 2782 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 271: // relocexpr_no_str: "STARTOF" "(" string ")"
#line 1493 "asm/parser.y"
                                          {
		yylhs.value.as < Expression > ().makeStartOfSection(yystack_[1].value.as < std::string > ());
	}
#line 2790 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 272: // relocexpr_no_str: "SIZEOF" "(" sect_type ")"
#line 1496 "asm/parser.y"
                                            {
		yylhs.value.as < Expression > ().makeSizeOfSectionType(yystack_[1].value.as < SectionType > ());
	}
#line 2798 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 273: // relocexpr_no_str: "STARTOF" "(" sect_type ")"
#line 1499 "asm/parser.y"
                                             {
		yylhs.value.as < Expression > ().makeStartOfSectionType(yystack_[1].value.as < SectionType > ());
	}
#line 2806 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 274: // relocexpr_no_str: "SIZEOF" "(" MODE_R8 ")"
#line 1502 "asm/parser.y"
                                          {
		yylhs.value.as < Expression > ().makeNumber(1);
	}
#line 2814 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 275: // relocexpr_no_str: "SIZEOF" "(" MODE_R16 ")"
#line 1505 "asm/parser.y"
                                           {
		yylhs.value.as < Expression > ().makeNumber(2);
	}
#line 2822 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 276: // $@12: %empty
#line 1508 "asm/parser.y"
                 {
		lexer_ToggleStringExpansion(false);
	}
#line 2830 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 277: // relocexpr_no_str: "DEF" $@12 "(" scoped_sym ")"
#line 1510 "asm/parser.y"
                                   {
		yylhs.value.as < Expression > ().makeNumber(sym_FindScopedValidSymbol(yystack_[1].value.as < std::string > ()) != nullptr);
		lexer_ToggleStringExpansion(true);
	}
#line 2839 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 278: // relocexpr_no_str: "ROUND" "(" iconst precision_arg ")"
#line 1514 "asm/parser.y"
                                                      {
		yylhs.value.as < Expression > ().makeNumber(fix_Round(yystack_[2].value.as < int32_t > (), yystack_[1].value.as < int32_t > ()));
	}
#line 2847 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 279: // relocexpr_no_str: "CEIL" "(" iconst precision_arg ")"
#line 1517 "asm/parser.y"
                                                     {
		yylhs.value.as < Expression > ().makeNumber(fix_Ceil(yystack_[2].value.as < int32_t > (), yystack_[1].value.as < int32_t > ()));
	}
#line 2855 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 280: // relocexpr_no_str: "FLOOR" "(" iconst precision_arg ")"
#line 1520 "asm/parser.y"
                                                      {
		yylhs.value.as < Expression > ().makeNumber(fix_Floor(yystack_[2].value.as < int32_t > (), yystack_[1].value.as < int32_t > ()));
	}
#line 2863 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 281: // relocexpr_no_str: "FDIV" "(" iconst "," iconst precision_arg ")"
#line 1523 "asm/parser.y"
                                                                  {
		yylhs.value.as < Expression > ().makeNumber(fix_Div(yystack_[4].value.as < int32_t > (), yystack_[2].value.as < int32_t > (), yystack_[1].value.as < int32_t > ()));
	}
#line 2871 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 282: // relocexpr_no_str: "FMUL" "(" iconst "," iconst precision_arg ")"
#line 1526 "asm/parser.y"
                                                                  {
		yylhs.value.as < Expression > ().makeNumber(fix_Mul(yystack_[4].value.as < int32_t > (), yystack_[2].value.as < int32_t > (), yystack_[1].value.as < int32_t > ()));
	}
#line 2879 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 283: // relocexpr_no_str: "FMOD" "(" iconst "," iconst precision_arg ")"
#line 1529 "asm/parser.y"
                                                                  {
		yylhs.value.as < Expression > ().makeNumber(fix_Mod(yystack_[4].value.as < int32_t > (), yystack_[2].value.as < int32_t > (), yystack_[1].value.as < int32_t > ()));
	}
#line 2887 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 284: // relocexpr_no_str: "POW" "(" iconst "," iconst precision_arg ")"
#line 1532 "asm/parser.y"
                                                                 {
		yylhs.value.as < Expression > ().makeNumber(fix_Pow(yystack_[4].value.as < int32_t > (), yystack_[2].value.as < int32_t > (), yystack_[1].value.as < int32_t > ()));
	}
#line 2895 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 285: // relocexpr_no_str: "LOG" "(" iconst "," iconst precision_arg ")"
#line 1535 "asm/parser.y"
                                                                 {
		yylhs.value.as < Expression > ().makeNumber(fix_Log(yystack_[4].value.as < int32_t > (), yystack_[2].value.as < int32_t > (), yystack_[1].value.as < int32_t > ()));
	}
#line 2903 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 286: // relocexpr_no_str: "SIN" "(" iconst precision_arg ")"
#line 1538 "asm/parser.y"
                                                    {
		yylhs.value.as < Expression > ().makeNumber(fix_Sin(yystack_[2].value.as < int32_t > (), yystack_[1].value.as < int32_t > ()));
	}
#line 2911 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 287: // relocexpr_no_str: "COS" "(" iconst precision_arg ")"
#line 1541 "asm/parser.y"
                                                    {
		yylhs.value.as < Expression > ().makeNumber(fix_Cos(yystack_[2].value.as < int32_t > (), yystack_[1].value.as < int32_t > ()));
	}
#line 2919 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 288: // relocexpr_no_str: "TAN" "(" iconst precision_arg ")"
#line 1544 "asm/parser.y"
                                                    {
		yylhs.value.as < Expression > ().makeNumber(fix_Tan(yystack_[2].value.as < int32_t > (), yystack_[1].value.as < int32_t > ()));
	}
#line 2927 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 289: // relocexpr_no_str: "ASIN" "(" iconst precision_arg ")"
#line 1547 "asm/parser.y"
                                                     {
		yylhs.value.as < Expression > ().makeNumber(fix_ASin(yystack_[2].value.as < int32_t > (), yystack_[1].value.as < int32_t > ()));
	}
#line 2935 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 290: // relocexpr_no_str: "ACOS" "(" iconst precision_arg ")"
#line 1550 "asm/parser.y"
                                                     {
		yylhs.value.as < Expression > ().makeNumber(fix_ACos(yystack_[2].value.as < int32_t > (), yystack_[1].value.as < int32_t > ()));
	}
#line 2943 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 291: // relocexpr_no_str: "ATAN" "(" iconst precision_arg ")"
#line 1553 "asm/parser.y"
                                                     {
		yylhs.value.as < Expression > ().makeNumber(fix_ATan(yystack_[2].value.as < int32_t > (), yystack_[1].value.as < int32_t > ()));
	}
#line 2951 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 292: // relocexpr_no_str: "ATAN2" "(" iconst "," iconst precision_arg ")"
#line 1556 "asm/parser.y"
                                                                   {
		yylhs.value.as < Expression > ().makeNumber(fix_ATan2(yystack_[4].value.as < int32_t > (), yystack_[2].value.as < int32_t > (), yystack_[1].value.as < int32_t > ()));
	}
#line 2959 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 293: // relocexpr_no_str: "STRCMP" "(" string "," string ")"
#line 1559 "asm/parser.y"
                                                      {
		yylhs.value.as < Expression > ().makeNumber(yystack_[3].value.as < std::string > ().compare(yystack_[1].value.as < std::string > ()));
	}
#line 2967 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 294: // relocexpr_no_str: "STRFIND" "(" string "," string ")"
#line 1562 "asm/parser.y"
                                                       {
		size_t pos = yystack_[3].value.as < std::string > ().find(yystack_[1].value.as < std::string > ());
		yylhs.value.as < Expression > ().makeNumber(pos != std::string::npos ? pos : -1);
	}
#line 2976 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 295: // relocexpr_no_str: "STRRFIND" "(" string "," string ")"
#line 1566 "asm/parser.y"
                                                        {
		size_t pos = yystack_[3].value.as < std::string > ().rfind(yystack_[1].value.as < std::string > ());
		yylhs.value.as < Expression > ().makeNumber(pos != std::string::npos ? pos : -1);
	}
#line 2985 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 296: // relocexpr_no_str: "STRIN" "(" string "," string ")"
#line 1570 "asm/parser.y"
                                                     {
		size_t pos = yystack_[3].value.as < std::string > ().find(yystack_[1].value.as < std::string > ());
		yylhs.value.as < Expression > ().makeNumber(pos != std::string::npos ? pos + 1 : 0);
	}
#line 2994 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 297: // relocexpr_no_str: "STRRIN" "(" string "," string ")"
#line 1574 "asm/parser.y"
                                                      {
		size_t pos = yystack_[3].value.as < std::string > ().rfind(yystack_[1].value.as < std::string > ());
		yylhs.value.as < Expression > ().makeNumber(pos != std::string::npos ? pos + 1 : 0);
	}
#line 3003 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 298: // relocexpr_no_str: "STRLEN" "(" string ")"
#line 1578 "asm/parser.y"
                                         {
		yylhs.value.as < Expression > ().makeNumber(act_StringLen(yystack_[1].value.as < std::string > (), true));
	}
#line 3011 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 299: // relocexpr_no_str: "BYTELEN" "(" string ")"
#line 1581 "asm/parser.y"
                                          {
		yylhs.value.as < Expression > ().makeNumber(yystack_[1].value.as < std::string > ().length());
	}
#line 3019 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 300: // relocexpr_no_str: "CHARLEN" "(" string ")"
#line 1584 "asm/parser.y"
                                          {
		yylhs.value.as < Expression > ().makeNumber(act_CharLen(yystack_[1].value.as < std::string > ()));
	}
#line 3027 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 301: // relocexpr_no_str: "INCHARMAP" "(" string ")"
#line 1587 "asm/parser.y"
                                            {
		yylhs.value.as < Expression > ().makeNumber(charmap_HasChar(yystack_[1].value.as < std::string > ()));
	}
#line 3035 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 302: // relocexpr_no_str: "CHARCMP" "(" string "," string ")"
#line 1590 "asm/parser.y"
                                                       {
		yylhs.value.as < Expression > ().makeNumber(act_CharCmp(yystack_[3].value.as < std::string > (), yystack_[1].value.as < std::string > ()));
	}
#line 3043 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 303: // relocexpr_no_str: "CHARSIZE" "(" string ")"
#line 1593 "asm/parser.y"
                                           {
		size_t charSize = charmap_CharSize(yystack_[1].value.as < std::string > ());
		if (charSize == 0) {
			::error("CHARSIZE: No character mapping for \"%s\"", yystack_[1].value.as < std::string > ().c_str());
		}
		yylhs.value.as < Expression > ().makeNumber(charSize);
	}
#line 3055 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 304: // relocexpr_no_str: "CHARVAL" "(" string "," iconst ")"
#line 1600 "asm/parser.y"
                                                       {
		if (size_t len = charmap_CharSize(yystack_[3].value.as < std::string > ()); len != 0) {
			uint32_t idx = act_AdjustNegativeIndex(yystack_[1].value.as < int32_t > (), len, "CHARVAL");
			if (std::optional<int32_t> val = charmap_CharValue(yystack_[3].value.as < std::string > (), idx); val.has_value()) {
				yylhs.value.as < Expression > ().makeNumber(*val);
			} else {
				warning(
				    WARNING_BUILTIN_ARG,
				    "CHARVAL: Index %" PRIu32 " is past the end of the character mapping",
				    idx
				);
				yylhs.value.as < Expression > ().makeNumber(0);
			}
		} else {
			::error("CHARVAL: No character mapping for \"%s\"", yystack_[3].value.as < std::string > ().c_str());
			yylhs.value.as < Expression > ().makeNumber(0);
		}
	}
#line 3078 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 305: // relocexpr_no_str: "STRBYTE" "(" string "," iconst ")"
#line 1618 "asm/parser.y"
                                                       {
		size_t len = yystack_[3].value.as < std::string > ().length();
		uint32_t idx = act_AdjustNegativeIndex(yystack_[1].value.as < int32_t > (), len, "STRBYTE");
		if (idx < len) {
			yylhs.value.as < Expression > ().makeNumber(static_cast<uint8_t>(yystack_[3].value.as < std::string > ()[idx]));
		} else {
			warning(
			    WARNING_BUILTIN_ARG,
			    "STRBYTE: Index %" PRIu32 " is past the end of the string",
			    idx
			);
			yylhs.value.as < Expression > ().makeNumber(0);
		}
	}
#line 3097 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 306: // relocexpr_no_str: "(" relocexpr ")"
#line 1632 "asm/parser.y"
                                  {
		yylhs.value.as < Expression > () = std::move(yystack_[1].value.as < Expression > ());
	}
#line 3105 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 307: // uconst: iconst
#line 1638 "asm/parser.y"
               {
		yylhs.value.as < int32_t > () = yystack_[0].value.as < int32_t > ();
		if (yylhs.value.as < int32_t > () < 0) {
			fatal("Constant must not be negative: %d", yylhs.value.as < int32_t > ());
		}
	}
#line 3116 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 308: // iconst: relocexpr
#line 1647 "asm/parser.y"
                  {
		yylhs.value.as < int32_t > () = yystack_[0].value.as < Expression > ().getConstVal();
	}
#line 3124 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 309: // precision_arg: %empty
#line 1653 "asm/parser.y"
               {
		yylhs.value.as < int32_t > () = options.fixPrecision;
	}
#line 3132 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 310: // precision_arg: "," iconst
#line 1656 "asm/parser.y"
                       {
		yylhs.value.as < int32_t > () = yystack_[0].value.as < int32_t > ();
		if (yylhs.value.as < int32_t > () < 1 || yylhs.value.as < int32_t > () > 31) {
			::error("Fixed-point precision must be between 1 and 31, not %" PRId32, yylhs.value.as < int32_t > ());
			yylhs.value.as < int32_t > () = options.fixPrecision;
		}
	}
#line 3144 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 311: // string_literal: "string"
#line 1666 "asm/parser.y"
               {
		yylhs.value.as < std::string > () = std::move(yystack_[0].value.as < std::string > ());
	}
#line 3152 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 312: // string_literal: string "++" string
#line 1669 "asm/parser.y"
                               {
		yylhs.value.as < std::string > () = std::move(yystack_[2].value.as < std::string > ());
		yylhs.value.as < std::string > ().append(yystack_[0].value.as < std::string > ());
	}
#line 3161 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 313: // string_literal: "READFILE" "(" string ")"
#line 1673 "asm/parser.y"
                                           {
		if (std::optional<std::string> contents = act_ReadFile(yystack_[1].value.as < std::string > (), UINT32_MAX); contents) {
			yylhs.value.as < std::string > () = std::move(*contents);
		} else {
			YYACCEPT;
		}
	}
#line 3173 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 314: // string_literal: "READFILE" "(" string "," uconst ")"
#line 1680 "asm/parser.y"
                                                        {
		if (std::optional<std::string> contents = act_ReadFile(yystack_[3].value.as < std::string > (), yystack_[1].value.as < int32_t > ()); contents) {
			yylhs.value.as < std::string > () = std::move(*contents);
		} else {
			YYACCEPT;
		}
	}
#line 3185 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 315: // string_literal: "STRSLICE" "(" string "," iconst "," iconst ")"
#line 1687 "asm/parser.y"
                                                                     {
		size_t len = act_StringLen(yystack_[5].value.as < std::string > (), false);
		uint32_t start = act_AdjustNegativeIndex(yystack_[3].value.as < int32_t > (), len, "STRSLICE");
		uint32_t stop = act_AdjustNegativeIndex(yystack_[1].value.as < int32_t > (), len, "STRSLICE");
		yylhs.value.as < std::string > () = act_StringSlice(yystack_[5].value.as < std::string > (), start, stop);
	}
#line 3196 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 316: // string_literal: "STRSLICE" "(" string "," iconst ")"
#line 1693 "asm/parser.y"
                                                        {
		size_t len = act_StringLen(yystack_[3].value.as < std::string > (), false);
		uint32_t start = act_AdjustNegativeIndex(yystack_[1].value.as < int32_t > (), len, "STRSLICE");
		yylhs.value.as < std::string > () = act_StringSlice(yystack_[3].value.as < std::string > (), start, len);
	}
#line 3206 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 317: // string_literal: "STRSUB" "(" string "," iconst "," uconst ")"
#line 1698 "asm/parser.y"
                                                                   {
		size_t len = act_StringLen(yystack_[5].value.as < std::string > (), false);
		uint32_t pos = act_AdjustNegativePos(yystack_[3].value.as < int32_t > (), len, "STRSUB");
		yylhs.value.as < std::string > () = act_StringSub(yystack_[5].value.as < std::string > (), pos, yystack_[1].value.as < int32_t > ());
	}
#line 3216 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 318: // string_literal: "STRSUB" "(" string "," iconst ")"
#line 1703 "asm/parser.y"
                                                      {
		size_t len = act_StringLen(yystack_[3].value.as < std::string > (), false);
		uint32_t pos = act_AdjustNegativePos(yystack_[1].value.as < int32_t > (), len, "STRSUB");
		yylhs.value.as < std::string > () = act_StringSub(yystack_[3].value.as < std::string > (), pos, pos > len ? 0 : len + 1 - pos);
	}
#line 3226 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 319: // string_literal: "STRCHAR" "(" string "," iconst ")"
#line 1708 "asm/parser.y"
                                                       {
		size_t len = act_CharLen(yystack_[3].value.as < std::string > ());
		uint32_t idx = act_AdjustNegativeIndex(yystack_[1].value.as < int32_t > (), len, "STRCHAR");
		yylhs.value.as < std::string > () = act_StringChar(yystack_[3].value.as < std::string > (), idx);
	}
#line 3236 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 320: // string_literal: "CHARSUB" "(" string "," iconst ")"
#line 1713 "asm/parser.y"
                                                       {
		size_t len = act_CharLen(yystack_[3].value.as < std::string > ());
		uint32_t pos = act_AdjustNegativePos(yystack_[1].value.as < int32_t > (), len, "CHARSUB");
		yylhs.value.as < std::string > () = act_CharSub(yystack_[3].value.as < std::string > (), pos);
	}
#line 3246 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 321: // string_literal: "REVCHAR" "(" charmap_args ")"
#line 1718 "asm/parser.y"
                                                {
		bool unique;
		yylhs.value.as < std::string > () = charmap_Reverse(yystack_[1].value.as < std::vector<int32_t> > (), unique);
		if (!unique) {
			::error("REVCHAR: Multiple character mappings to values");
		} else if (yylhs.value.as < std::string > ().empty()) {
			::error("REVCHAR: No character mapping to values");
		}
	}
#line 3260 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 322: // string_literal: "STRCAT" "(" ")"
#line 1727 "asm/parser.y"
                                  {
		yylhs.value.as < std::string > ().clear();
	}
#line 3268 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 323: // string_literal: "STRCAT" "(" strcat_args ")"
#line 1730 "asm/parser.y"
                                              {
		yylhs.value.as < std::string > () = std::move(yystack_[1].value.as < std::string > ());
	}
#line 3276 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 324: // string_literal: "STRUPR" "(" string ")"
#line 1733 "asm/parser.y"
                                         {
		yylhs.value.as < std::string > () = std::move(yystack_[1].value.as < std::string > ());
		std::transform(RANGE(yylhs.value.as < std::string > ()), yylhs.value.as < std::string > ().begin(), [](char c) { return toupper(c); });
	}
#line 3285 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 325: // string_literal: "STRLWR" "(" string ")"
#line 1737 "asm/parser.y"
                                         {
		yylhs.value.as < std::string > () = std::move(yystack_[1].value.as < std::string > ());
		std::transform(RANGE(yylhs.value.as < std::string > ()), yylhs.value.as < std::string > ().begin(), [](char c) { return tolower(c); });
	}
#line 3294 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 326: // string_literal: "STRRPL" "(" string "," string "," string ")"
#line 1741 "asm/parser.y"
                                                                   {
		yylhs.value.as < std::string > () = act_StringReplace(yystack_[5].value.as < std::string > (), yystack_[3].value.as < std::string > (), yystack_[1].value.as < std::string > ());
	}
#line 3302 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 327: // string_literal: "STRFMT" "(" strfmt_args ")"
#line 1744 "asm/parser.y"
                                              {
		yylhs.value.as < std::string > () = act_StringFormat(yystack_[1].value.as < StrFmtArgList > ().format, yystack_[1].value.as < StrFmtArgList > ().args);
	}
#line 3310 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 328: // string_literal: "SECTION" "(" scoped_sym ")"
#line 1747 "asm/parser.y"
                                               {
		Symbol *sym = sym_FindScopedValidSymbol(yystack_[1].value.as < std::string > ());

		if (!sym) {
			if (sym_IsPurgedScoped(yystack_[1].value.as < std::string > ())) {
				fatal("Unknown symbol \"%s\"; it was purged", yystack_[1].value.as < std::string > ().c_str());
			} else {
				fatal("Unknown symbol \"%s\"", yystack_[1].value.as < std::string > ().c_str());
			}
		}
		Section const *section = sym->getSection();

		if (!section) {
			fatal("\"%s\" does not belong to any section", sym->name.c_str());
		}
		// Section names are capped by rgbasm's maximum string length,
		// so this currently can't overflow.
		yylhs.value.as < std::string > () = section->name;
	}
#line 3334 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 329: // string: string_literal
#line 1769 "asm/parser.y"
                       {
		yylhs.value.as < std::string > () = std::move(yystack_[0].value.as < std::string > ());
	}
#line 3342 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 330: // string: scoped_sym
#line 1772 "asm/parser.y"
                     {
		if (Symbol *sym = sym_FindScopedSymbol(yystack_[0].value.as < std::string > ()); sym && sym->type == SYM_EQUS) {
			yylhs.value.as < std::string > () = *sym->getEqus();
		} else {
			::error("'%s' is not a string symbol", yystack_[0].value.as < std::string > ().c_str());
		}
	}
#line 3354 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 331: // strcat_args: string
#line 1782 "asm/parser.y"
               {
		yylhs.value.as < std::string > () = std::move(yystack_[0].value.as < std::string > ());
	}
#line 3362 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 332: // strcat_args: strcat_args "," string
#line 1785 "asm/parser.y"
                                   {
		yylhs.value.as < std::string > () = std::move(yystack_[2].value.as < std::string > ());
		yylhs.value.as < std::string > ().append(yystack_[0].value.as < std::string > ());
	}
#line 3371 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 333: // strfmt_args: %empty
#line 1792 "asm/parser.y"
                 {}
#line 3377 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 334: // strfmt_args: string strfmt_va_args
#line 1793 "asm/parser.y"
                                {
		yylhs.value.as < StrFmtArgList > () = std::move(yystack_[0].value.as < StrFmtArgList > ());
		yylhs.value.as < StrFmtArgList > ().format = std::move(yystack_[1].value.as < std::string > ());
	}
#line 3386 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 335: // strfmt_va_args: %empty
#line 1800 "asm/parser.y"
                 {}
#line 3392 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 336: // strfmt_va_args: strfmt_va_args "," relocexpr_no_str
#line 1801 "asm/parser.y"
                                                {
		yylhs.value.as < StrFmtArgList > () = std::move(yystack_[2].value.as < StrFmtArgList > ());
		yylhs.value.as < StrFmtArgList > ().args.push_back(static_cast<uint32_t>(yystack_[0].value.as < Expression > ().getConstVal()));
	}
#line 3401 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 337: // strfmt_va_args: strfmt_va_args "," string_literal
#line 1805 "asm/parser.y"
                                              {
		yylhs.value.as < StrFmtArgList > () = std::move(yystack_[2].value.as < StrFmtArgList > ());
		yylhs.value.as < StrFmtArgList > ().args.push_back(std::move(yystack_[0].value.as < std::string > ()));
	}
#line 3410 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 338: // strfmt_va_args: strfmt_va_args "," scoped_sym
#line 1809 "asm/parser.y"
                                          {
		yylhs.value.as < StrFmtArgList > () = std::move(yystack_[2].value.as < StrFmtArgList > ());
		handleSymbolByType(
		    yystack_[0].value.as < std::string > (),
		    [&](Expression const &expr) {
			    yylhs.value.as < StrFmtArgList > ().args.push_back(static_cast<uint32_t>(expr.getConstVal()));
		    },
		    [&](std::string const &str) { yylhs.value.as < StrFmtArgList > ().args.push_back(str); }
		);
	}
#line 3425 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 339: // section: "SECTION" sect_mod string "," sect_type sect_org sect_attrs
#line 1822 "asm/parser.y"
                                                                        {
		sect_NewSection(yystack_[4].value.as < std::string > (), yystack_[2].value.as < SectionType > (), yystack_[1].value.as < int32_t > (), yystack_[0].value.as < SectionSpec > (), yystack_[5].value.as < SectionModifier > ());
	}
#line 3433 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 340: // pushs_section: "PUSHS" sect_mod string "," sect_type sect_org sect_attrs
#line 1828 "asm/parser.y"
                                                                      {
		sect_PushSection();
		sect_NewSection(yystack_[4].value.as < std::string > (), yystack_[2].value.as < SectionType > (), yystack_[1].value.as < int32_t > (), yystack_[0].value.as < SectionSpec > (), yystack_[5].value.as < SectionModifier > ());
	}
#line 3442 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 341: // sect_mod: %empty
#line 1835 "asm/parser.y"
               {
		yylhs.value.as < SectionModifier > () = SECTION_NORMAL;
	}
#line 3450 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 342: // sect_mod: "UNION"
#line 1838 "asm/parser.y"
                    {
		yylhs.value.as < SectionModifier > () = SECTION_UNION;
	}
#line 3458 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 343: // sect_mod: "FRAGMENT"
#line 1841 "asm/parser.y"
                       {
		yylhs.value.as < SectionModifier > () = SECTION_FRAGMENT;
	}
#line 3466 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 344: // sect_type: "WRAM0"
#line 1847 "asm/parser.y"
                   {
		yylhs.value.as < SectionType > () = SECTTYPE_WRAM0;
	}
#line 3474 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 345: // sect_type: "VRAM"
#line 1850 "asm/parser.y"
                    {
		yylhs.value.as < SectionType > () = SECTTYPE_VRAM;
	}
#line 3482 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 346: // sect_type: "ROMX"
#line 1853 "asm/parser.y"
                    {
		yylhs.value.as < SectionType > () = SECTTYPE_ROMX;
	}
#line 3490 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 347: // sect_type: "ROM0"
#line 1856 "asm/parser.y"
                    {
		yylhs.value.as < SectionType > () = SECTTYPE_ROM0;
	}
#line 3498 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 348: // sect_type: "HRAM"
#line 1859 "asm/parser.y"
                    {
		yylhs.value.as < SectionType > () = SECTTYPE_HRAM;
	}
#line 3506 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 349: // sect_type: "WRAMX"
#line 1862 "asm/parser.y"
                     {
		yylhs.value.as < SectionType > () = SECTTYPE_WRAMX;
	}
#line 3514 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 350: // sect_type: "SRAM"
#line 1865 "asm/parser.y"
                    {
		yylhs.value.as < SectionType > () = SECTTYPE_SRAM;
	}
#line 3522 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 351: // sect_type: "OAM"
#line 1868 "asm/parser.y"
                   {
		yylhs.value.as < SectionType > () = SECTTYPE_OAM;
	}
#line 3530 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 352: // sect_org: %empty
#line 1874 "asm/parser.y"
               {
		yylhs.value.as < int32_t > () = -1;
	}
#line 3538 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 353: // sect_org: "[" uconst "]"
#line 1877 "asm/parser.y"
                               {
		yylhs.value.as < int32_t > () = yystack_[1].value.as < int32_t > ();
		if (yylhs.value.as < int32_t > () < 0 || yylhs.value.as < int32_t > () > 0xFFFF) {
			::error("Address $%x is not 16-bit", yylhs.value.as < int32_t > ());
			yylhs.value.as < int32_t > () = -1;
		}
	}
#line 3550 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 354: // sect_attrs: %empty
#line 1887 "asm/parser.y"
               {
		yylhs.value.as < SectionSpec > ().alignment = 0;
		yylhs.value.as < SectionSpec > ().alignOfs = 0;
		yylhs.value.as < SectionSpec > ().bank = -1;
	}
#line 3560 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 355: // sect_attrs: sect_attrs "," "ALIGN" "[" align_spec "]"
#line 1892 "asm/parser.y"
                                                              {
		yylhs.value.as < SectionSpec > () = yystack_[5].value.as < SectionSpec > ();
		yylhs.value.as < SectionSpec > ().alignment = yystack_[1].value.as < AlignmentSpec > ().alignment;
		yylhs.value.as < SectionSpec > ().alignOfs = yystack_[1].value.as < AlignmentSpec > ().alignOfs;
	}
#line 3570 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 356: // sect_attrs: sect_attrs "," "BANK" "[" uconst "]"
#line 1897 "asm/parser.y"
                                                        {
		yylhs.value.as < SectionSpec > () = yystack_[5].value.as < SectionSpec > ();
		yylhs.value.as < SectionSpec > ().bank = yystack_[1].value.as < int32_t > (); // We cannot check the validity of this yet
	}
#line 3579 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 405: // sm83_adc: "adc" op_a_n
#line 1960 "asm/parser.y"
                        {
		sect_ConstByte(0xCE);
		sect_RelByte(yystack_[0].value.as < Expression > (), 1);
	}
#line 3588 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 406: // sm83_adc: "adc" op_a_r
#line 1964 "asm/parser.y"
                          {
		sect_ConstByte(0x88 | yystack_[0].value.as < int32_t > ());
	}
#line 3596 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 407: // sm83_add: "add" op_a_n
#line 1970 "asm/parser.y"
                        {
		sect_ConstByte(0xC6);
		sect_RelByte(yystack_[0].value.as < Expression > (), 1);
	}
#line 3605 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 408: // sm83_add: "add" op_a_r
#line 1974 "asm/parser.y"
                          {
		sect_ConstByte(0x80 | yystack_[0].value.as < int32_t > ());
	}
#line 3613 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 409: // sm83_add: "add" "hl" "," reg_ss
#line 1977 "asm/parser.y"
                                        {
		sect_ConstByte(0x09 | (yystack_[0].value.as < int32_t > () << 4));
	}
#line 3621 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 410: // sm83_add: "add" "sp" "," reloc_8bit
#line 1980 "asm/parser.y"
                                            {
		sect_ConstByte(0xE8);
		sect_RelByte(yystack_[0].value.as < Expression > (), 1);
	}
#line 3630 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 411: // sm83_and: "and" op_a_n
#line 1987 "asm/parser.y"
                        {
		sect_ConstByte(0xE6);
		sect_RelByte(yystack_[0].value.as < Expression > (), 1);
	}
#line 3639 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 412: // sm83_and: "and" op_a_r
#line 1991 "asm/parser.y"
                          {
		sect_ConstByte(0xA0 | yystack_[0].value.as < int32_t > ());
	}
#line 3647 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 413: // sm83_bit: "bit" reloc_3bit "," reg_r
#line 1997 "asm/parser.y"
                                        {
		uint8_t mask = static_cast<uint8_t>(0x40 | yystack_[0].value.as < int32_t > ());
		yystack_[2].value.as < Expression > ().makeCheckBitIndex(mask);
		sect_ConstByte(0xCB);
		if (!yystack_[2].value.as < Expression > ().isKnown()) {
			sect_RelByte(yystack_[2].value.as < Expression > (), 0);
		} else {
			sect_ConstByte(mask | (yystack_[2].value.as < Expression > ().value() << 3));
		}
	}
#line 3662 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 414: // sm83_call: "call" reloc_16bit
#line 2010 "asm/parser.y"
                              {
		sect_ConstByte(0xCD);
		sect_RelWord(yystack_[0].value.as < Expression > (), 1);
	}
#line 3671 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 415: // sm83_call: "call" ccode_expr "," reloc_16bit
#line 2014 "asm/parser.y"
                                                 {
		sect_ConstByte(0xC4 | (yystack_[2].value.as < int32_t > () << 3));
		sect_RelWord(yystack_[0].value.as < Expression > (), 1);
	}
#line 3680 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 416: // sm83_ccf: "ccf"
#line 2021 "asm/parser.y"
                 {
		sect_ConstByte(0x3F);
	}
#line 3688 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 417: // sm83_cp: "cp" op_a_n
#line 2027 "asm/parser.y"
                       {
		sect_ConstByte(0xFE);
		sect_RelByte(yystack_[0].value.as < Expression > (), 1);
	}
#line 3697 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 418: // sm83_cp: "cp" op_a_r
#line 2031 "asm/parser.y"
                         {
		sect_ConstByte(0xB8 | yystack_[0].value.as < int32_t > ());
	}
#line 3705 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 419: // sm83_cpl: "cpl"
#line 2037 "asm/parser.y"
                 {
		sect_ConstByte(0x2F);
	}
#line 3713 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 420: // sm83_cpl: "cpl" MODE_A
#line 2040 "asm/parser.y"
                          {
		sect_ConstByte(0x2F);
	}
#line 3721 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 421: // sm83_daa: "daa"
#line 2046 "asm/parser.y"
                 {
		sect_ConstByte(0x27);
	}
#line 3729 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 422: // sm83_dec: "dec" reg_r
#line 2052 "asm/parser.y"
                       {
		sect_ConstByte(0x05 | (yystack_[0].value.as < int32_t > () << 3));
	}
#line 3737 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 423: // sm83_dec: "dec" reg_ss
#line 2055 "asm/parser.y"
                          {
		sect_ConstByte(0x0B | (yystack_[0].value.as < int32_t > () << 4));
	}
#line 3745 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 424: // sm83_di: "di"
#line 2061 "asm/parser.y"
                {
		sect_ConstByte(0xF3);
	}
#line 3753 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 425: // sm83_ei: "ei"
#line 2067 "asm/parser.y"
                {
		sect_ConstByte(0xFB);
	}
#line 3761 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 426: // sm83_halt: "halt"
#line 2073 "asm/parser.y"
                  {
		sect_ConstByte(0x76);
	}
#line 3769 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 427: // sm83_inc: "inc" reg_r
#line 2079 "asm/parser.y"
                       {
		sect_ConstByte(0x04 | (yystack_[0].value.as < int32_t > () << 3));
	}
#line 3777 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 428: // sm83_inc: "inc" reg_ss
#line 2082 "asm/parser.y"
                          {
		sect_ConstByte(0x03 | (yystack_[0].value.as < int32_t > () << 4));
	}
#line 3785 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 429: // sm83_jp: "jp" reloc_16bit
#line 2088 "asm/parser.y"
                            {
		sect_ConstByte(0xC3);
		sect_RelWord(yystack_[0].value.as < Expression > (), 1);
	}
#line 3794 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 430: // sm83_jp: "jp" ccode_expr "," reloc_16bit
#line 2092 "asm/parser.y"
                                               {
		sect_ConstByte(0xC2 | (yystack_[2].value.as < int32_t > () << 3));
		sect_RelWord(yystack_[0].value.as < Expression > (), 1);
	}
#line 3803 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 431: // sm83_jp: "jp" "hl"
#line 2096 "asm/parser.y"
                          {
		sect_ConstByte(0xE9);
	}
#line 3811 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 432: // sm83_jr: "jr" reloc_16bit
#line 2102 "asm/parser.y"
                            {
		sect_ConstByte(0x18);
		sect_PCRelByte(yystack_[0].value.as < Expression > (), 1);
	}
#line 3820 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 433: // sm83_jr: "jr" ccode_expr "," reloc_16bit
#line 2106 "asm/parser.y"
                                               {
		sect_ConstByte(0x20 | (yystack_[2].value.as < int32_t > () << 3));
		sect_PCRelByte(yystack_[0].value.as < Expression > (), 1);
	}
#line 3829 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 434: // sm83_ldi: "ldi" "[" "hl" "]" "," MODE_A
#line 2113 "asm/parser.y"
                                                    {
		sect_ConstByte(0x02 | (2 << 4));
	}
#line 3837 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 435: // sm83_ldi: "ldi" MODE_A "," "[" "hl" "]"
#line 2116 "asm/parser.y"
                                                      {
		sect_ConstByte(0x0A | (2 << 4));
	}
#line 3845 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 436: // sm83_ldd: "ldd" "[" "hl" "]" "," MODE_A
#line 2122 "asm/parser.y"
                                                    {
		sect_ConstByte(0x02 | (3 << 4));
	}
#line 3853 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 437: // sm83_ldd: "ldd" MODE_A "," "[" "hl" "]"
#line 2125 "asm/parser.y"
                                                      {
		sect_ConstByte(0x0A | (3 << 4));
	}
#line 3861 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 438: // sm83_ldh: "ldh" MODE_A "," op_mem_ind
#line 2131 "asm/parser.y"
                                         {
		if (yystack_[0].value.as < Expression > ().makeCheckHRAM()) {
			warning(
			    WARNING_OBSOLETE,
			    "LDH is deprecated with values from $00 to $FF; use $FF00 to $FFFF"
			);
		}

		sect_ConstByte(0xF0);
		sect_RelByte(yystack_[0].value.as < Expression > (), 1);
	}
#line 3877 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 439: // sm83_ldh: "ldh" op_mem_ind "," MODE_A
#line 2142 "asm/parser.y"
                                           {
		if (yystack_[2].value.as < Expression > ().makeCheckHRAM()) {
			warning(
			    WARNING_OBSOLETE,
			    "LDH is deprecated with values from $00 to $FF; use $FF00 to $FFFF"
			);
		}

		sect_ConstByte(0xE0);
		sect_RelByte(yystack_[2].value.as < Expression > (), 1);
	}
#line 3893 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 440: // sm83_ldh: "ldh" MODE_A "," c_ind
#line 2153 "asm/parser.y"
                                      {
		sect_ConstByte(0xF2);
	}
#line 3901 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 441: // sm83_ldh: "ldh" MODE_A "," ff00_c_ind
#line 2156 "asm/parser.y"
                                           {
		sect_ConstByte(0xF2);
	}
#line 3909 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 442: // sm83_ldh: "ldh" c_ind "," MODE_A
#line 2159 "asm/parser.y"
                                      {
		sect_ConstByte(0xE2);
	}
#line 3917 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 443: // sm83_ldh: "ldh" ff00_c_ind "," MODE_A
#line 2162 "asm/parser.y"
                                           {
		sect_ConstByte(0xE2);
	}
#line 3925 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 445: // ff00_c_ind: "[" relocexpr "+" MODE_C "]"
#line 2170 "asm/parser.y"
                                              {
		// This has to use `relocexpr`, not `iconst`, to avoid a shift/reduce conflict
		if (yystack_[3].value.as < Expression > ().getConstVal() != 0xFF00) {
			::error("Base value must be equal to $FF00 for $FF00+C");
		}
	}
#line 3936 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 454: // sm83_ld_hl: "ld" "hl" "," "sp" op_sp_offset
#line 2190 "asm/parser.y"
                                                   {
		sect_ConstByte(0xF8);
		sect_RelByte(yystack_[0].value.as < Expression > (), 1);
	}
#line 3945 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 455: // sm83_ld_hl: "ld" "hl" "," reloc_16bit
#line 2194 "asm/parser.y"
                                            {
		sect_ConstByte(0x01 | (REG_HL << 4));
		sect_RelWord(yystack_[0].value.as < Expression > (), 1);
	}
#line 3954 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 456: // sm83_ld_hl: "ld" "hl" "," reg_tt_no_af
#line 2198 "asm/parser.y"
                                             {
		::error(
		    "LD HL, %s is not a valid instruction; use LD H, %s and LD L, %s",
		    reg_tt_names[yystack_[0].value.as < int32_t > ()],
		    reg_tt_high_names[yystack_[0].value.as < int32_t > ()],
		    reg_tt_low_names[yystack_[0].value.as < int32_t > ()]
		);
	}
#line 3967 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 457: // sm83_ld_sp: "ld" "sp" "," "hl"
#line 2209 "asm/parser.y"
                                      {
		sect_ConstByte(0xF9);
	}
#line 3975 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 458: // sm83_ld_sp: "ld" "sp" "," reg_bc_or_de
#line 2212 "asm/parser.y"
                                             {
		::error("LD SP, %s is not a valid instruction", reg_tt_names[yystack_[0].value.as < int32_t > ()]);
	}
#line 3983 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 459: // sm83_ld_sp: "ld" "sp" "," reloc_16bit
#line 2215 "asm/parser.y"
                                            {
		sect_ConstByte(0x01 | (REG_SP << 4));
		sect_RelWord(yystack_[0].value.as < Expression > (), 1);
	}
#line 3992 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 460: // sm83_ld_mem: "ld" op_mem_ind "," "sp"
#line 2222 "asm/parser.y"
                                         {
		sect_ConstByte(0x08);
		sect_RelWord(yystack_[2].value.as < Expression > (), 1);
	}
#line 4001 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 461: // sm83_ld_mem: "ld" op_mem_ind "," MODE_A
#line 2226 "asm/parser.y"
                                          {
		sect_ConstByte(0xEA);
		sect_RelWord(yystack_[2].value.as < Expression > (), 1);
	}
#line 4010 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 462: // sm83_ld_c_ind: "ld" ff00_c_ind "," MODE_A
#line 2233 "asm/parser.y"
                                        {
		sect_ConstByte(0xE2);
	}
#line 4018 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 463: // sm83_ld_c_ind: "ld" c_ind "," MODE_A
#line 2236 "asm/parser.y"
                                     {
		warning(WARNING_OBSOLETE, "LD [C], A is deprecated; use LDH [C], A");
		sect_ConstByte(0xE2);
	}
#line 4027 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 464: // sm83_ld_rr: "ld" reg_rr "," MODE_A
#line 2243 "asm/parser.y"
                                    {
		sect_ConstByte(0x02 | (yystack_[2].value.as < int32_t > () << 4));
	}
#line 4035 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 465: // sm83_ld_r_no_a: "ld" reg_r_no_a "," reloc_8bit
#line 2249 "asm/parser.y"
                                            {
		sect_ConstByte(0x06 | (yystack_[2].value.as < int32_t > () << 3));
		sect_RelByte(yystack_[0].value.as < Expression > (), 1);
	}
#line 4044 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 466: // sm83_ld_r_no_a: "ld" reg_r_no_a "," reg_r
#line 2253 "asm/parser.y"
                                         {
		if (yystack_[2].value.as < int32_t > () == REG_HL_IND && yystack_[0].value.as < int32_t > () == REG_HL_IND) {
			::error("LD [HL], [HL] is not a valid instruction");
		} else {
			sect_ConstByte(0x40 | (yystack_[2].value.as < int32_t > () << 3) | yystack_[0].value.as < int32_t > ());
		}
	}
#line 4056 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 467: // sm83_ld_a: "ld" reg_a "," reloc_8bit
#line 2263 "asm/parser.y"
                                       {
		sect_ConstByte(0x06 | (yystack_[2].value.as < int32_t > () << 3));
		sect_RelByte(yystack_[0].value.as < Expression > (), 1);
	}
#line 4065 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 468: // sm83_ld_a: "ld" reg_a "," reg_r
#line 2267 "asm/parser.y"
                                    {
		sect_ConstByte(0x40 | (yystack_[2].value.as < int32_t > () << 3) | yystack_[0].value.as < int32_t > ());
	}
#line 4073 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 469: // sm83_ld_a: "ld" reg_a "," ff00_c_ind
#line 2270 "asm/parser.y"
                                         {
		sect_ConstByte(0xF2);
	}
#line 4081 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 470: // sm83_ld_a: "ld" reg_a "," c_ind
#line 2273 "asm/parser.y"
                                    {
		warning(WARNING_OBSOLETE, "LD A, [C] is deprecated; use LDH A, [C]");
		sect_ConstByte(0xF2);
	}
#line 4090 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 471: // sm83_ld_a: "ld" reg_a "," reg_rr
#line 2277 "asm/parser.y"
                                     {
		sect_ConstByte(0x0A | (yystack_[0].value.as < int32_t > () << 4));
	}
#line 4098 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 472: // sm83_ld_a: "ld" reg_a "," op_mem_ind
#line 2280 "asm/parser.y"
                                         {
		sect_ConstByte(0xFA);
		sect_RelWord(yystack_[0].value.as < Expression > (), 1);
	}
#line 4107 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 473: // sm83_ld_ss: "ld" reg_bc_or_de "," reloc_16bit
#line 2287 "asm/parser.y"
                                               {
		sect_ConstByte(0x01 | (yystack_[2].value.as < int32_t > () << 4));
		sect_RelWord(yystack_[0].value.as < Expression > (), 1);
	}
#line 4116 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 474: // sm83_ld_ss: "ld" reg_bc_or_de "," reg_tt_no_af
#line 2291 "asm/parser.y"
                                                  {
		::error(
		    "LD %s, %s is not a valid instruction; use LD %s, %s and LD %s, %s",
		    reg_tt_names[yystack_[2].value.as < int32_t > ()],
		    reg_tt_names[yystack_[0].value.as < int32_t > ()],
		    reg_tt_high_names[yystack_[2].value.as < int32_t > ()],
		    reg_tt_high_names[yystack_[0].value.as < int32_t > ()],
		    reg_tt_low_names[yystack_[2].value.as < int32_t > ()],
		    reg_tt_low_names[yystack_[0].value.as < int32_t > ()]
		);
	}
#line 4132 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 475: // sm83_nop: "nop"
#line 2307 "asm/parser.y"
                 {
		sect_ConstByte(0x00);
	}
#line 4140 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 476: // sm83_or: "or" op_a_n
#line 2313 "asm/parser.y"
                       {
		sect_ConstByte(0xF6);
		sect_RelByte(yystack_[0].value.as < Expression > (), 1);
	}
#line 4149 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 477: // sm83_or: "or" op_a_r
#line 2317 "asm/parser.y"
                         {
		sect_ConstByte(0xB0 | yystack_[0].value.as < int32_t > ());
	}
#line 4157 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 478: // sm83_pop: "pop" reg_tt
#line 2323 "asm/parser.y"
                        {
		sect_ConstByte(0xC1 | (yystack_[0].value.as < int32_t > () << 4));
	}
#line 4165 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 479: // sm83_push: "push" reg_tt
#line 2329 "asm/parser.y"
                         {
		sect_ConstByte(0xC5 | (yystack_[0].value.as < int32_t > () << 4));
	}
#line 4173 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 480: // sm83_res: "res" reloc_3bit "," reg_r
#line 2335 "asm/parser.y"
                                        {
		uint8_t mask = static_cast<uint8_t>(0x80 | yystack_[0].value.as < int32_t > ());
		yystack_[2].value.as < Expression > ().makeCheckBitIndex(mask);
		sect_ConstByte(0xCB);
		if (!yystack_[2].value.as < Expression > ().isKnown()) {
			sect_RelByte(yystack_[2].value.as < Expression > (), 0);
		} else {
			sect_ConstByte(mask | (yystack_[2].value.as < Expression > ().value() << 3));
		}
	}
#line 4188 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 481: // sm83_ret: "ret"
#line 2348 "asm/parser.y"
                 {
		sect_ConstByte(0xC9);
	}
#line 4196 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 482: // sm83_ret: "ret" ccode_expr
#line 2351 "asm/parser.y"
                              {
		sect_ConstByte(0xC0 | (yystack_[0].value.as < int32_t > () << 3));
	}
#line 4204 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 483: // sm83_reti: "reti"
#line 2357 "asm/parser.y"
                  {
		sect_ConstByte(0xD9);
	}
#line 4212 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 484: // sm83_rl: "rl" reg_r
#line 2363 "asm/parser.y"
                      {
		sect_ConstByte(0xCB);
		sect_ConstByte(0x10 | yystack_[0].value.as < int32_t > ());
	}
#line 4221 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 485: // sm83_rla: "rla"
#line 2370 "asm/parser.y"
                 {
		sect_ConstByte(0x17);
	}
#line 4229 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 486: // sm83_rlc: "rlc" reg_r
#line 2376 "asm/parser.y"
                       {
		sect_ConstByte(0xCB);
		sect_ConstByte(0x00 | yystack_[0].value.as < int32_t > ());
	}
#line 4238 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 487: // sm83_rlca: "rlca"
#line 2383 "asm/parser.y"
                  {
		sect_ConstByte(0x07);
	}
#line 4246 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 488: // sm83_rr: "rr" reg_r
#line 2389 "asm/parser.y"
                      {
		sect_ConstByte(0xCB);
		sect_ConstByte(0x18 | yystack_[0].value.as < int32_t > ());
	}
#line 4255 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 489: // sm83_rra: "rra"
#line 2396 "asm/parser.y"
                 {
		sect_ConstByte(0x1F);
	}
#line 4263 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 490: // sm83_rrc: "rrc" reg_r
#line 2402 "asm/parser.y"
                       {
		sect_ConstByte(0xCB);
		sect_ConstByte(0x08 | yystack_[0].value.as < int32_t > ());
	}
#line 4272 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 491: // sm83_rrca: "rrca"
#line 2409 "asm/parser.y"
                  {
		sect_ConstByte(0x0F);
	}
#line 4280 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 492: // sm83_rst: "rst" reloc_8bit
#line 2415 "asm/parser.y"
                            {
		yystack_[0].value.as < Expression > ().makeCheckRST();
		if (!yystack_[0].value.as < Expression > ().isKnown()) {
			sect_RelByte(yystack_[0].value.as < Expression > (), 0);
		} else {
			sect_ConstByte(0xC7 | yystack_[0].value.as < Expression > ().value());
		}
	}
#line 4293 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 493: // sm83_sbc: "sbc" op_a_n
#line 2426 "asm/parser.y"
                        {
		sect_ConstByte(0xDE);
		sect_RelByte(yystack_[0].value.as < Expression > (), 1);
	}
#line 4302 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 494: // sm83_sbc: "sbc" op_a_r
#line 2430 "asm/parser.y"
                          {
		sect_ConstByte(0x98 | yystack_[0].value.as < int32_t > ());
	}
#line 4310 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 495: // sm83_scf: "scf"
#line 2436 "asm/parser.y"
                 {
		sect_ConstByte(0x37);
	}
#line 4318 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 496: // sm83_set: "set" reloc_3bit "," reg_r
#line 2442 "asm/parser.y"
                                        {
		uint8_t mask = static_cast<uint8_t>(0xC0 | yystack_[0].value.as < int32_t > ());
		yystack_[2].value.as < Expression > ().makeCheckBitIndex(mask);
		sect_ConstByte(0xCB);
		if (!yystack_[2].value.as < Expression > ().isKnown()) {
			sect_RelByte(yystack_[2].value.as < Expression > (), 0);
		} else {
			sect_ConstByte(mask | (yystack_[2].value.as < Expression > ().value() << 3));
		}
	}
#line 4333 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 497: // sm83_sla: "sla" reg_r
#line 2455 "asm/parser.y"
                       {
		sect_ConstByte(0xCB);
		sect_ConstByte(0x20 | yystack_[0].value.as < int32_t > ());
	}
#line 4342 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 498: // sm83_sra: "sra" reg_r
#line 2462 "asm/parser.y"
                       {
		sect_ConstByte(0xCB);
		sect_ConstByte(0x28 | yystack_[0].value.as < int32_t > ());
	}
#line 4351 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 499: // sm83_srl: "srl" reg_r
#line 2469 "asm/parser.y"
                       {
		sect_ConstByte(0xCB);
		sect_ConstByte(0x38 | yystack_[0].value.as < int32_t > ());
	}
#line 4360 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 500: // sm83_stop: "stop"
#line 2476 "asm/parser.y"
                  {
		sect_ConstByte(0x10);
		sect_ConstByte(0x00);
	}
#line 4369 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 501: // sm83_stop: "stop" reloc_8bit
#line 2480 "asm/parser.y"
                               {
		sect_ConstByte(0x10);
		sect_RelByte(yystack_[0].value.as < Expression > (), 1);
	}
#line 4378 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 502: // sm83_sub: "sub" op_a_n
#line 2487 "asm/parser.y"
                        {
		sect_ConstByte(0xD6);
		sect_RelByte(yystack_[0].value.as < Expression > (), 1);
	}
#line 4387 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 503: // sm83_sub: "sub" op_a_r
#line 2491 "asm/parser.y"
                          {
		sect_ConstByte(0x90 | yystack_[0].value.as < int32_t > ());
	}
#line 4395 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 504: // sm83_swap: "swap" reg_r
#line 2497 "asm/parser.y"
                        {
		sect_ConstByte(0xCB);
		sect_ConstByte(0x30 | yystack_[0].value.as < int32_t > ());
	}
#line 4404 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 505: // sm83_xor: "xor" op_a_n
#line 2504 "asm/parser.y"
                        {
		sect_ConstByte(0xEE);
		sect_RelByte(yystack_[0].value.as < Expression > (), 1);
	}
#line 4413 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 506: // sm83_xor: "xor" op_a_r
#line 2508 "asm/parser.y"
                          {
		sect_ConstByte(0xA8 | yystack_[0].value.as < int32_t > ());
	}
#line 4421 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 507: // op_mem_ind: "[" reloc_16bit "]"
#line 2516 "asm/parser.y"
                                  {
		yylhs.value.as < Expression > () = std::move(yystack_[1].value.as < Expression > ());
	}
#line 4429 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 508: // op_a_r: reg_r
#line 2522 "asm/parser.y"
          { yylhs.value.as < int32_t > () = yystack_[0].value.as < int32_t > (); }
#line 4435 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 509: // op_a_r: MODE_A "," reg_r
#line 2523 "asm/parser.y"
                             {
		yylhs.value.as < int32_t > () = yystack_[0].value.as < int32_t > ();
	}
#line 4443 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 510: // op_a_n: reloc_8bit
#line 2529 "asm/parser.y"
                   {
		yylhs.value.as < Expression > () = std::move(yystack_[0].value.as < Expression > ());
	}
#line 4451 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 511: // op_a_n: MODE_A "," reloc_8bit
#line 2532 "asm/parser.y"
                                  {
		yylhs.value.as < Expression > () = std::move(yystack_[0].value.as < Expression > ());
	}
#line 4459 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 512: // op_sp_offset: "+" relocexpr
#line 2538 "asm/parser.y"
                         {
		yylhs.value.as < Expression > () = std::move(yystack_[0].value.as < Expression > ());
		yylhs.value.as < Expression > ().checkNBit(8);
	}
#line 4468 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 513: // op_sp_offset: "-" relocexpr
#line 2542 "asm/parser.y"
                           {
		yylhs.value.as < Expression > ().makeUnaryOp(RPN_NEG, std::move(yystack_[0].value.as < Expression > ()));
		yylhs.value.as < Expression > ().checkNBit(8);
	}
#line 4477 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 514: // op_sp_offset: %empty
#line 2546 "asm/parser.y"
                 {
		::error("LD HL, SP is not a valid instruction; use LD HL, SP + 0");
	}
#line 4485 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 546: // ccode_expr: ccode
#line 2612 "asm/parser.y"
          { yylhs.value.as < int32_t > () = yystack_[0].value.as < int32_t > (); }
#line 4491 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 547: // ccode_expr: "!" ccode_expr
#line 2613 "asm/parser.y"
                                 {
		yylhs.value.as < int32_t > () = yystack_[0].value.as < int32_t > () ^ 1;
	}
#line 4499 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 548: // ccode: "nz"
#line 2619 "asm/parser.y"
              {
		yylhs.value.as < int32_t > () = CC_NZ;
	}
#line 4507 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 549: // ccode: "z"
#line 2622 "asm/parser.y"
               {
		yylhs.value.as < int32_t > () = CC_Z;
	}
#line 4515 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 550: // ccode: "nc"
#line 2625 "asm/parser.y"
                {
		yylhs.value.as < int32_t > () = CC_NC;
	}
#line 4523 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 551: // ccode: "c"
#line 2628 "asm/parser.y"
                  {
		yylhs.value.as < int32_t > () = CC_C;
	}
#line 4531 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 552: // reg_r: reg_r_no_a
#line 2633 "asm/parser.y"
       { yylhs.value.as < int32_t > () = yystack_[0].value.as < int32_t > (); }
#line 4537 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 553: // reg_r: reg_a
#line 2633 "asm/parser.y"
                    { yylhs.value.as < int32_t > () = yystack_[0].value.as < int32_t > (); }
#line 4543 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 554: // reg_r_no_a: MODE_B
#line 2636 "asm/parser.y"
               {
		yylhs.value.as < int32_t > () = REG_B;
	}
#line 4551 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 555: // reg_r_no_a: MODE_C
#line 2639 "asm/parser.y"
                 {
		yylhs.value.as < int32_t > () = REG_C;
	}
#line 4559 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 556: // reg_r_no_a: MODE_D
#line 2642 "asm/parser.y"
                 {
		yylhs.value.as < int32_t > () = REG_D;
	}
#line 4567 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 557: // reg_r_no_a: MODE_E
#line 2645 "asm/parser.y"
                 {
		yylhs.value.as < int32_t > () = REG_E;
	}
#line 4575 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 558: // reg_r_no_a: MODE_H
#line 2648 "asm/parser.y"
                 {
		yylhs.value.as < int32_t > () = REG_H;
	}
#line 4583 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 559: // reg_r_no_a: MODE_L
#line 2651 "asm/parser.y"
                 {
		yylhs.value.as < int32_t > () = REG_L;
	}
#line 4591 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 560: // reg_r_no_a: "[" "hl" "]"
#line 2654 "asm/parser.y"
                                {
		yylhs.value.as < int32_t > () = REG_HL_IND;
	}
#line 4599 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 561: // reg_a: MODE_A
#line 2660 "asm/parser.y"
               {
		yylhs.value.as < int32_t > () = REG_A;
	}
#line 4607 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 562: // reg_tt: reg_tt_no_af
#line 2666 "asm/parser.y"
        { yylhs.value.as < int32_t > () = yystack_[0].value.as < int32_t > (); }
#line 4613 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 563: // reg_tt: "af"
#line 2667 "asm/parser.y"
                  {
		yylhs.value.as < int32_t > () = REG_AF;
	}
#line 4621 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 564: // reg_ss: reg_tt_no_af
#line 2673 "asm/parser.y"
        { yylhs.value.as < int32_t > () = yystack_[0].value.as < int32_t > (); }
#line 4627 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 565: // reg_ss: "sp"
#line 2674 "asm/parser.y"
                  {
		yylhs.value.as < int32_t > () = REG_SP;
	}
#line 4635 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 566: // reg_tt_no_af: reg_bc_or_de
#line 2680 "asm/parser.y"
        { yylhs.value.as < int32_t > () = yystack_[0].value.as < int32_t > (); }
#line 4641 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 567: // reg_tt_no_af: "hl"
#line 2681 "asm/parser.y"
                  {
		yylhs.value.as < int32_t > () = REG_HL;
	}
#line 4649 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 568: // reg_bc_or_de: "bc"
#line 2687 "asm/parser.y"
                {
		yylhs.value.as < int32_t > () = REG_BC;
	}
#line 4657 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 569: // reg_bc_or_de: "de"
#line 2690 "asm/parser.y"
                  {
		yylhs.value.as < int32_t > () = REG_DE;
	}
#line 4665 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 570: // reg_rr: "[" "bc" "]"
#line 2696 "asm/parser.y"
                              {
		yylhs.value.as < int32_t > () = REG_BC_IND;
	}
#line 4673 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 571: // reg_rr: "[" "de" "]"
#line 2699 "asm/parser.y"
                                {
		yylhs.value.as < int32_t > () = REG_DE_IND;
	}
#line 4681 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 572: // reg_rr: hl_ind_inc
#line 2702 "asm/parser.y"
                     {
		yylhs.value.as < int32_t > () = REG_HL_INDINC;
	}
#line 4689 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;

  case 573: // reg_rr: hl_ind_dec
#line 2705 "asm/parser.y"
                     {
		yylhs.value.as < int32_t > () = REG_HL_INDDEC;
	}
#line 4697 "/build/rgbds/src/rgbds/src/asm/parser.cpp"
    break;


#line 4701 "/build/rgbds/src/rgbds/src/asm/parser.cpp"

            default:
              break;
            }
        }
#if YY_EXCEPTIONS
      catch (const syntax_error& yyexc)
        {
          YYCDEBUG << "Caught exception: " << yyexc.what() << '\n';
          error (yyexc);
          YYERROR;
        }
#endif // YY_EXCEPTIONS
      YY_SYMBOL_PRINT ("-> $$ =", yylhs);
      yypop_ (yylen);
      yylen = 0;

      // Shift the result of the reduction.
      yypush_ (YY_NULLPTR, YY_MOVE (yylhs));
    }
    goto yynewstate;


  /*--------------------------------------.
  | yyerrlab -- here on detecting error.  |
  `--------------------------------------*/
  yyerrlab:
    // If not already recovering from an error, report this error.
    if (!yyerrstatus_)
      {
        ++yynerrs_;
        context yyctx (*this, yyla);
        std::string msg = yysyntax_error_ (yyctx);
        error (YY_MOVE (msg));
      }


    if (yyerrstatus_ == 3)
      {
        /* If just tried and failed to reuse lookahead token after an
           error, discard it.  */

        // Return failure if at end of input.
        if (yyla.kind () == symbol_kind::S_YYEOF)
          YYABORT;
        else if (!yyla.empty ())
          {
            yy_destroy_ ("Error: discarding", yyla);
            yyla.clear ();
          }
      }

    // Else will try to reuse lookahead token after shifting the error token.
    goto yyerrlab1;


  /*---------------------------------------------------.
  | yyerrorlab -- error raised explicitly by YYERROR.  |
  `---------------------------------------------------*/
  yyerrorlab:
    /* Pacify compilers when the user code never invokes YYERROR and
       the label yyerrorlab therefore never appears in user code.  */
    if (false)
      YYERROR;

    /* Do not reclaim the symbols of the rule whose action triggered
       this YYERROR.  */
    yypop_ (yylen);
    yylen = 0;
    YY_STACK_PRINT ();
    goto yyerrlab1;


  /*-------------------------------------------------------------.
  | yyerrlab1 -- common code for both syntax error and YYERROR.  |
  `-------------------------------------------------------------*/
  yyerrlab1:
    yyerrstatus_ = 3;   // Each real token shifted decrements this.
    // Pop stack until we find a state that shifts the error token.
    for (;;)
      {
        yyn = yypact_[+yystack_[0].state];
        if (!yy_pact_value_is_default_ (yyn))
          {
            yyn += symbol_kind::S_YYerror;
            if (0 <= yyn && yyn <= yylast_
                && yycheck_[yyn] == symbol_kind::S_YYerror)
              {
                yyn = yytable_[yyn];
                if (0 < yyn)
                  break;
              }
          }

        // Pop the current state because it cannot handle the error token.
        if (yystack_.size () == 1)
          YYABORT;

        yy_destroy_ ("Error: popping", yystack_[0]);
        yypop_ ();
        YY_STACK_PRINT ();
      }
    {
      stack_symbol_type error_token;


      // Shift the error token.
      yy_lac_discard_ ("error recovery");
      error_token.state = state_type (yyn);
      yypush_ ("Shifting", YY_MOVE (error_token));
    }
    goto yynewstate;


  /*-------------------------------------.
  | yyacceptlab -- YYACCEPT comes here.  |
  `-------------------------------------*/
  yyacceptlab:
    yyresult = 0;
    goto yyreturn;


  /*-----------------------------------.
  | yyabortlab -- YYABORT comes here.  |
  `-----------------------------------*/
  yyabortlab:
    yyresult = 1;
    goto yyreturn;


  /*-----------------------------------------------------.
  | yyreturn -- parsing is finished, return the result.  |
  `-----------------------------------------------------*/
  yyreturn:
    if (!yyla.empty ())
      yy_destroy_ ("Cleanup: discarding lookahead", yyla);

    /* Do not reclaim the symbols of the rule whose action triggered
       this YYABORT or YYACCEPT.  */
    yypop_ (yylen);
    YY_STACK_PRINT ();
    while (1 < yystack_.size ())
      {
        yy_destroy_ ("Cleanup: popping", yystack_[0]);
        yypop_ ();
      }

    return yyresult;
  }
#if YY_EXCEPTIONS
    catch (...)
      {
        YYCDEBUG << "Exception caught: cleaning lookahead and stack\n";
        // Do not try to display the values of the reclaimed symbols,
        // as their printers might throw an exception.
        if (!yyla.empty ())
          yy_destroy_ (YY_NULLPTR, yyla);

        while (1 < yystack_.size ())
          {
            yy_destroy_ (YY_NULLPTR, yystack_[0]);
            yypop_ ();
          }
        throw;
      }
#endif // YY_EXCEPTIONS
  }

  void
  parser::error (const syntax_error& yyexc)
  {
    error (yyexc.what ());
  }

  const char *
  parser::symbol_name (symbol_kind_type yysymbol)
  {
    static const char *const yy_sname[] =
    {
    "end of file", "error", "invalid token", "end of line", "end of buffer",
  "end of fragment literal", ",", ":", "::", "[", "]", "[[", "]]", "(",
  ")", "+", "-", "*", "/", "%", "**", "++", "==", "!=", "<", ">", "<=",
  ">=", "&&", "||", "!", "&", "|", "^", "<<", ">>", ">>>", "~", "NEG", "=",
  "+=", "-=", "*=", "/=", "%=", "&=", "|=", "^=", "<<=", ">>=", "a", "b",
  "c", "d", "e", "h", "l", "af", "bc", "de", "hl", "sp", "hli/hl+",
  "hld/hl-", "z", "nz", "nc", "adc", "add", "and", "bit", "call", "ccf",
  "cp", "cpl", "daa", "dec", "di", "ei", "halt", "inc", "jp", "jr", "ldd",
  "ldh", "ldi", "ld", "nop", "or", "pop", "push", "res", "reti", "ret",
  "rla", "rlca", "rlc", "rl", "rra", "rrca", "rrc", "rr", "rst", "sbc",
  "scf", "set", "sla", "sra", "srl", "stop", "sub", "swap", "xor", "ALIGN",
  "ASSERT", "BREAK", "CHARMAP", "DB", "DL", "DS", "DW", "ELIF", "ELSE",
  "ENDC", "ENDL", "ENDM", "ENDR", "ENDSECTION", "ENDU", "EQU", "EQUS",
  "EXPORT", "FAIL", "FATAL", "FOR", "FRAGMENT", "IF", "INCBIN", "INCLUDE",
  "LOAD", "MACRO", "NEWCHARMAP", "NEXTU", "OPT", "POPC", "POPO", "POPS",
  "PRINTLN", "PRINT", "PURGE", "PUSHC", "PUSHO", "PUSHS", "RB", "REDEF",
  "REPT", "RSRESET", "RSSET", "RW", "SECTION", "SETCHARMAP", "SHIFT",
  "STATIC_ASSERT", "UNION", "WARN", "ACOS", "ASIN", "ATAN", "ATAN2",
  "BANK", "BITWIDTH", "BYTELEN", "CEIL", "CHARCMP", "CHARLEN", "CHARSIZE",
  "CHARSUB", "CHARVAL", "COS", "DEF", "FDIV", "FLOOR", "FMOD", "FMUL",
  "HIGH", "INCHARMAP", "ISCONST", "LOG", "LOW", "POW", "READFILE",
  "REVCHAR", "ROUND", "SIN", "SIZEOF", "STARTOF", "STRBYTE", "STRCAT",
  "STRCHAR", "STRCMP", "STRFIND", "STRFMT", "STRIN", "STRLEN", "STRLWR",
  "STRRFIND", "STRRIN", "STRRPL", "STRSLICE", "STRSUB", "STRUPR", "TAN",
  "TZCOUNT", "HRAM", "OAM", "ROM0", "ROMX", "SRAM", "VRAM", "WRAM0",
  "WRAMX", "number", "string", "character", "symbol", "label",
  "local label", "anonymous label", "$accept", "asm_file", "lines", "$@1",
  "diff_mark", "line", "endofline", "line_directive", "if", "elif", "else",
  "plain_directive", "endc", "def_id", "$@2", "redef_id", "$@3",
  "scoped_sym_no_anon", "scoped_sym", "label", "macro", "$@4",
  "macro_args", "directive", "def_numeric", "trailing_comma",
  "compound_eq", "align", "align_spec", "opt", "$@5", "opt_list",
  "opt_list_entry", "popo", "pusho", "$@6", "pusho_opt_list", "pops",
  "pushs", "endsection", "fail", "warn", "assert_type", "assert", "shift",
  "shift_const", "load", "rept", "for", "$@7", "$@8", "capture_rept",
  "for_args", "break", "def_macro", "$@9", "$@10", "capture_macro",
  "rsset", "rsreset", "rs_uconst", "union", "nextu", "endu", "ds",
  "ds_args", "db", "dw", "dl", "def_equ", "redef_equ", "def_set", "def_rb",
  "def_rw", "def_rl", "def_equs", "redef_equs", "purge", "$@11",
  "purge_args", "export", "export_list", "export_list_entry", "export_def",
  "include", "incbin", "charmap", "charmap_args", "newcharmap",
  "setcharmap", "pushc", "pushc_setcharmap", "popc", "print", "println",
  "print_exprs", "print_expr", "reloc_3bit", "constlist_8bit",
  "constlist_8bit_entry", "constlist_16bit", "constlist_16bit_entry",
  "constlist_32bit", "constlist_32bit_entry", "reloc_8bit", "reloc_16bit",
  "fragment_literal", "fragment_literal_name", "relocexpr",
  "relocexpr_no_str", "$@12", "uconst", "iconst", "precision_arg",
  "string_literal", "string", "strcat_args", "strfmt_args",
  "strfmt_va_args", "section", "pushs_section", "sect_mod", "sect_type",
  "sect_org", "sect_attrs", "cpu_commands", "cpu_command", "sm83_adc",
  "sm83_add", "sm83_and", "sm83_bit", "sm83_call", "sm83_ccf", "sm83_cp",
  "sm83_cpl", "sm83_daa", "sm83_dec", "sm83_di", "sm83_ei", "sm83_halt",
  "sm83_inc", "sm83_jp", "sm83_jr", "sm83_ldi", "sm83_ldd", "sm83_ldh",
  "c_ind", "ff00_c_ind", "sm83_ld", "sm83_ld_hl", "sm83_ld_sp",
  "sm83_ld_mem", "sm83_ld_c_ind", "sm83_ld_rr", "sm83_ld_r_no_a",
  "sm83_ld_a", "sm83_ld_ss", "sm83_nop", "sm83_or", "sm83_pop",
  "sm83_push", "sm83_res", "sm83_ret", "sm83_reti", "sm83_rl", "sm83_rla",
  "sm83_rlc", "sm83_rlca", "sm83_rr", "sm83_rra", "sm83_rrc", "sm83_rrca",
  "sm83_rst", "sm83_sbc", "sm83_scf", "sm83_set", "sm83_sla", "sm83_sra",
  "sm83_srl", "sm83_stop", "sm83_sub", "sm83_swap", "sm83_xor",
  "op_mem_ind", "op_a_r", "op_a_n", "op_sp_offset", "MODE_R8", "MODE_R16",
  "MODE_A", "MODE_B", "MODE_C", "MODE_D", "MODE_E", "MODE_H", "MODE_L",
  "ccode_expr", "ccode", "reg_r", "reg_r_no_a", "reg_a", "reg_tt",
  "reg_ss", "reg_tt_no_af", "reg_bc_or_de", "reg_rr", "hl_ind_inc",
  "hl_ind_dec", YY_NULLPTR
    };
    return yy_sname[yysymbol];
  }



  // parser::context.
  parser::context::context (const parser& yyparser, const symbol_type& yyla)
    : yyparser_ (yyparser)
    , yyla_ (yyla)
  {}

  int
  parser::context::expected_tokens (symbol_kind_type yyarg[], int yyargn) const
  {
    // Actual number of expected tokens
    int yycount = 0;

#if YYDEBUG
    // Execute LAC once. We don't care if it is successful, we
    // only do it for the sake of debugging output.
    if (!yyparser_.yy_lac_established_)
      yyparser_.yy_lac_check_ (yyla_.kind ());
#endif

    for (int yyx = 0; yyx < YYNTOKENS; ++yyx)
      {
        symbol_kind_type yysym = YY_CAST (symbol_kind_type, yyx);
        if (yysym != symbol_kind::S_YYerror
            && yysym != symbol_kind::S_YYUNDEF
            && yyparser_.yy_lac_check_ (yysym))
          {
            if (!yyarg)
              ++yycount;
            else if (yycount == yyargn)
              return 0;
            else
              yyarg[yycount++] = yysym;
          }
      }
    if (yyarg && yycount == 0 && 0 < yyargn)
      yyarg[0] = symbol_kind::S_YYEMPTY;
    return yycount;
  }




  bool
  parser::yy_lac_check_ (symbol_kind_type yytoken) const
  {
    // Logically, the yylac_stack's lifetime is confined to this function.
    // Clear it, to get rid of potential left-overs from previous call.
    yylac_stack_.clear ();
    // Reduce until we encounter a shift and thereby accept the token.
#if YYDEBUG
    YYCDEBUG << "LAC: checking lookahead " << symbol_name (yytoken) << ':';
#endif
    std::ptrdiff_t lac_top = 0;
    while (true)
      {
        state_type top_state = (yylac_stack_.empty ()
                                ? yystack_[lac_top].state
                                : yylac_stack_.back ());
        int yyrule = yypact_[+top_state];
        if (yy_pact_value_is_default_ (yyrule)
            || (yyrule += yytoken) < 0 || yylast_ < yyrule
            || yycheck_[yyrule] != yytoken)
          {
            // Use the default action.
            yyrule = yydefact_[+top_state];
            if (yyrule == 0)
              {
                YYCDEBUG << " Err\n";
                return false;
              }
          }
        else
          {
            // Use the action from yytable.
            yyrule = yytable_[yyrule];
            if (yy_table_value_is_error_ (yyrule))
              {
                YYCDEBUG << " Err\n";
                return false;
              }
            if (0 < yyrule)
              {
                YYCDEBUG << " S" << yyrule << '\n';
                return true;
              }
            yyrule = -yyrule;
          }
        // By now we know we have to simulate a reduce.
        YYCDEBUG << " R" << yyrule - 1;
        // Pop the corresponding number of values from the stack.
        {
          std::ptrdiff_t yylen = yyr2_[yyrule];
          // First pop from the LAC stack as many tokens as possible.
          std::ptrdiff_t lac_size = std::ptrdiff_t (yylac_stack_.size ());
          if (yylen < lac_size)
            {
              yylac_stack_.resize (std::size_t (lac_size - yylen));
              yylen = 0;
            }
          else if (lac_size)
            {
              yylac_stack_.clear ();
              yylen -= lac_size;
            }
          // Only afterwards look at the main stack.
          // We simulate popping elements by incrementing lac_top.
          lac_top += yylen;
        }
        // Keep top_state in sync with the updated stack.
        top_state = (yylac_stack_.empty ()
                     ? yystack_[lac_top].state
                     : yylac_stack_.back ());
        // Push the resulting state of the reduction.
        state_type state = yy_lr_goto_state_ (top_state, yyr1_[yyrule]);
        YYCDEBUG << " G" << int (state);
        yylac_stack_.push_back (state);
      }
  }

  // Establish the initial context if no initial context currently exists.
  bool
  parser::yy_lac_establish_ (symbol_kind_type yytoken)
  {
    /* Establish the initial context for the current lookahead if no initial
       context is currently established.

       We define a context as a snapshot of the parser stacks.  We define
       the initial context for a lookahead as the context in which the
       parser initially examines that lookahead in order to select a
       syntactic action.  Thus, if the lookahead eventually proves
       syntactically unacceptable (possibly in a later context reached via a
       series of reductions), the initial context can be used to determine
       the exact set of tokens that would be syntactically acceptable in the
       lookahead's place.  Moreover, it is the context after which any
       further semantic actions would be erroneous because they would be
       determined by a syntactically unacceptable token.

       yy_lac_establish_ should be invoked when a reduction is about to be
       performed in an inconsistent state (which, for the purposes of LAC,
       includes consistent states that don't know they're consistent because
       their default reductions have been disabled).

       For parse.lac=full, the implementation of yy_lac_establish_ is as
       follows.  If no initial context is currently established for the
       current lookahead, then check if that lookahead can eventually be
       shifted if syntactic actions continue from the current context.  */
    if (yy_lac_established_)
      return true;
    else
      {
#if YYDEBUG
        YYCDEBUG << "LAC: initial context established for "
                 << symbol_name (yytoken) << '\n';
#endif
        yy_lac_established_ = true;
        return yy_lac_check_ (yytoken);
      }
  }

  // Discard any previous initial lookahead context.
  void
  parser::yy_lac_discard_ (const char* event)
  {
   /* Discard any previous initial lookahead context because of Event,
      which may be a lookahead change or an invalidation of the currently
      established initial context for the current lookahead.

      The most common example of a lookahead change is a shift.  An example
      of both cases is syntax error recovery.  That is, a syntax error
      occurs when the lookahead is syntactically erroneous for the
      currently established initial context, so error recovery manipulates
      the parser stacks to try to find a new initial context in which the
      current lookahead is syntactically acceptable.  If it fails to find
      such a context, it discards the lookahead.  */
    if (yy_lac_established_)
      {
        YYCDEBUG << "LAC: initial context discarded due to "
                 << event << '\n';
        yy_lac_established_ = false;
      }
  }


  int
  parser::yy_syntax_error_arguments_ (const context& yyctx,
                                                 symbol_kind_type yyarg[], int yyargn) const
  {
    /* There are many possibilities here to consider:
       - If this state is a consistent state with a default action, then
         the only way this function was invoked is if the default action
         is an error action.  In that case, don't check for expected
         tokens because there are none.
       - The only way there can be no lookahead present (in yyla) is
         if this state is a consistent state with a default action.
         Thus, detecting the absence of a lookahead is sufficient to
         determine that there is no unexpected or expected token to
         report.  In that case, just report a simple "syntax error".
       - Don't assume there isn't a lookahead just because this state is
         a consistent state with a default action.  There might have
         been a previous inconsistent state, consistent state with a
         non-default action, or user semantic action that manipulated
         yyla.  (However, yyla is currently not documented for users.)
         In the first two cases, it might appear that the current syntax
         error should have been detected in the previous state when
         yy_lac_check was invoked.  However, at that time, there might
         have been a different syntax error that discarded a different
         initial context during error recovery, leaving behind the
         current lookahead.
    */

    if (!yyctx.lookahead ().empty ())
      {
        if (yyarg)
          yyarg[0] = yyctx.token ();
        int yyn = yyctx.expected_tokens (yyarg ? yyarg + 1 : yyarg, yyargn - 1);
        return yyn + 1;
      }
    return 0;
  }

  // Generate an error message.
  std::string
  parser::yysyntax_error_ (const context& yyctx) const
  {
    // Its maximum.
    enum { YYARGS_MAX = 5 };
    // Arguments of yyformat.
    symbol_kind_type yyarg[YYARGS_MAX];
    int yycount = yy_syntax_error_arguments_ (yyctx, yyarg, YYARGS_MAX);

    char const* yyformat = YY_NULLPTR;
    switch (yycount)
      {
#define YYCASE_(N, S)                         \
        case N:                               \
          yyformat = S;                       \
        break
      default: // Avoid compiler warnings.
        YYCASE_ (0, YY_("syntax error"));
        YYCASE_ (1, YY_("syntax error, unexpected %s"));
        YYCASE_ (2, YY_("syntax error, unexpected %s, expecting %s"));
        YYCASE_ (3, YY_("syntax error, unexpected %s, expecting %s or %s"));
        YYCASE_ (4, YY_("syntax error, unexpected %s, expecting %s or %s or %s"));
        YYCASE_ (5, YY_("syntax error, unexpected %s, expecting %s or %s or %s or %s"));
#undef YYCASE_
      }

    std::string yyres;
    // Argument number.
    std::ptrdiff_t yyi = 0;
    for (char const* yyp = yyformat; *yyp; ++yyp)
      if (yyp[0] == '%' && yyp[1] == 's' && yyi < yycount)
        {
          yyres += symbol_name (yyarg[yyi++]);
          ++yyp;
        }
      else
        yyres += *yyp;
    return yyres;
  }


  const short parser::yypact_ninf_ = -712;

  const short parser::yytable_ninf_ = -339;

  const short
  parser::yypact_[] =
  {
    1239,  -712,    36,   317,   354,  -712,  -712,  -712,    51,  -712,
    -712,  -712,  -712,  -712,  3843,    27,  -712,  3843,  -712,  3843,
     243,   417,  -712,  -712,  -712,  -712,  -712,   354,  4004,  -712,
    -712,  -712,  -712,  -712,  3843,  3843,  3843,  3843,  3843,    50,
      86,   107,   139,   148,   157,   171,   175,   179,   195,   200,
     225,   262,   315,   321,  -712,   323,   326,   342,   376,   382,
     416,   438,   442,   463,   475,   484,   497,   531,   537,   552,
     559,   576,   579,   588,   605,   607,   610,   614,   619,   620,
     628,   643,   646,   647,   652,   653,   659,   660,  -712,  -712,
    -712,  -712,  -712,  -712,  -712,  -712,    39,  2208,  -712,    54,
     190,   201,  -712,    32,   327,    82,   364,  -712,  -712,  -712,
    -712,  -712,  -712,  1886,  1817,  1886,  3843,  2430,  -712,  1886,
     -33,  -712,   212,  -712,  -712,  -712,   212,  2361,  2430,    23,
      30,    47,   351,  -712,  1886,   656,   656,  3843,  -712,    44,
    -712,  -712,   147,   147,  -712,  -712,   147,   147,  3843,  1886,
    -712,  3843,   147,   147,   147,  3843,  1886,   147,  1886,  3843,
     -15,   354,   294,  3843,  3843,  3541,   996,  -712,  -712,  -712,
    -712,  -110,   294,   294,   294,   -93,   283,  -712,  -712,  -712,
    -712,  -712,  3843,  3843,  -712,   337,  -712,    61,  -712,  -712,
    3843,   -93,   371,  3843,   -15,  -712,   294,  -712,  -712,  -712,
     399,   603,  -712,  -712,  -712,  -712,  -712,  -712,  -712,  -712,
    -712,  -712,  -712,  -712,  -712,  -712,  -712,  -712,  -712,  -712,
    -712,  -712,  -712,  -712,  -712,  -712,  -712,  -712,  -712,  -712,
    -712,  -712,  -712,  -712,  -712,  -712,  -712,  -712,  -712,  -712,
    -712,  -712,  -712,  -712,  -712,  -712,  -712,  -712,  -712,   551,
    -712,  -712,  -712,  -712,  -712,  -712,  -712,  -712,  -712,  -712,
    -712,  -712,  -712,  -712,  -712,  -712,  -712,  -712,  -712,  -712,
    -712,  -712,  -712,  -712,  -712,  -712,  -712,  -712,  -712,  -712,
    -712,  -712,  -712,  -712,  -712,  -712,  -712,  -712,  -712,  -712,
    -712,  -712,  -712,  -712,  -712,  -712,  -712,  -712,  -712,  -712,
    -712,  -712,  -712,  -712,  1408,   485,   485,   485,   485,   499,
    3843,  3843,  3843,  3843,   294,  3843,   294,  3843,   294,   294,
     294,   294,   294,  3843,   661,  3843,  3843,  3843,  3843,  3843,
     294,  3843,  3843,  3843,  3843,   294,  3843,  3843,  3843,  1420,
    1075,   294,    19,   294,   294,   294,   294,   294,   294,   294,
     294,   294,   294,   294,   294,   294,  3843,  3843,  3843,  3843,
    3843,  3843,  3843,  3843,  3843,  3843,  3843,  3843,  3843,  3843,
    3843,  3843,  3843,  3843,  3843,  3843,  3843,  3843,  -712,   294,
    -712,  -712,  -712,  -712,   518,  -712,  -712,  -712,  -712,  -712,
    -712,  -712,   663,   665,  -712,  2208,  -712,  -712,   658,  -712,
    -712,  -712,  -712,  -712,  -712,  -712,  -712,  -712,   673,   674,
    -712,  -712,  -712,  -712,   677,  2208,  -712,  3172,  -712,  -712,
    -712,  -712,  -712,  -712,  2208,   678,  -712,  -712,  -712,   675,
    -712,  -712,  -712,  -712,  -712,   682,   683,  -712,  -712,  -712,
    -712,  -712,  -712,  -712,  -712,  -712,   692,  -712,   696,   645,
     702,  2972,   703,   704,   722,   728,   685,   736,  2159,   737,
     740,   742,   744,   745,   755,   757,   764,   769,  -712,  -712,
    -712,  -712,  -712,  -712,  -712,  -712,   770,    44,  -712,  -712,
    -712,  -712,  -712,  -712,  -712,  -712,   771,  -712,  -712,  -712,
    -712,  -712,  -712,  -712,  -712,  -712,  -712,   773,   776,   777,
     779,  3843,  -712,  -712,  -712,    83,   231,   783,  -712,  2208,
     715,   387,   410,   784,  -712,   735,   468,   785,   786,   519,
     789,  -712,  -712,   754,   565,   790,   809,  -712,  -712,   799,
    -712,   201,   184,   160,  -712,  -712,   294,   801,   586,   570,
     804,  -712,   810,   634,   804,   173,  -712,   586,   294,   587,
    -712,   294,  -712,  -712,  -712,  3843,   201,   597,  -712,  3843,
    -712,  -712,  -712,  -712,  -712,  -712,  -712,  -712,  -712,  -712,
    3843,  3843,   294,  3843,  3843,  3843,  3843,  3843,   294,  3843,
    1611,  -712,   808,   819,   819,   819,   821,   812,   826,  1492,
      79,   819,   209,   126,   165,   219,   226,   819,   499,   835,
     819,   837,   839,  1531,   168,  1558,   840,  1929,   841,   123,
      48,  -712,   819,   819,   631,  -712,  -712,  -712,  -712,  -712,
    -712,  -712,  -712,  -712,  -712,  -712,  -712,  -712,   228,   845,
     846,   847,  -712,  -712,  -712,  -712,  -712,  -712,  -712,  -712,
    -712,   281,   854,   233,  -712,   201,    53,   290,   295,   301,
     201,   855,   331,   306,   405,   332,   335,   415,   462,   488,
     406,   819,  2133,   446,   446,   485,   485,   485,   485,   330,
     330,   330,   330,   330,   330,  1826,  1089,   651,   651,   651,
     800,   800,   800,  -712,   878,   883,   354,   879,  3241,  3441,
    1886,   805,  3843,   147,  1661,  -712,   996,   831,   820,   523,
     996,   996,   880,   885,   882,   886,  2482,   887,   -33,   -33,
     -33,   890,   896,   898,   899,   900,   293,   901,   903,  2632,
    2701,   -33,   -33,    34,  1886,  2090,  2903,   -33,   147,   147,
    3843,  -712,  -712,  -712,  1067,  3843,  3843,  -712,  3843,  -712,
    3843,  3843,   996,  -712,   173,  -712,  3843,  -712,   493,   684,
    -712,   586,  -712,  3843,  -712,  -712,  -712,   908,   586,  -712,
     494,  -712,   520,   909,  -712,   694,  -712,  -712,  -712,  -712,
     201,  -712,  -712,  -712,  -712,  -712,   201,  -712,  -712,  -712,
    3843,   904,   906,   926,  3843,  -712,  -712,  -712,  -712,   927,
     294,  -712,  -712,  3843,  3843,   928,   930,  3843,   931,  3843,
    3843,  -712,  -712,  -712,  3843,  -712,  3843,  3843,  -712,  3843,
    -712,   932,   933,   939,   940,   517,  -712,  -712,  -712,  -712,
    -712,  -712,  3843,   294,  -712,  3843,   294,   294,   945,  -712,
     294,  -712,  -712,   294,   294,   294,  3843,  3843,  -712,   938,
    -712,  3843,  -712,  -712,  -712,   941,   942,   943,   944,   946,
     948,   949,  -712,  -712,  -712,  -712,  -712,   947,  -712,  -712,
    -712,   958,   893,  3643,  -712,  3741,  -712,  -712,  -712,  -712,
    -712,  -712,  -712,   960,   907,  -712,  -712,   959,   962,  -712,
    -712,   515,  -712,  -712,  -712,  -712,  -712,  -712,  -712,  -712,
    -712,  -712,  -712,  -712,  -712,  -712,  -712,  -712,  -712,  -712,
    -712,  -712,  -712,  -712,  -712,   294,   967,  -712,  -712,   964,
     969,  -712,  -712,  -712,   970,   584,  -712,  -712,  -712,   173,
    -712,   584,   584,   294,  -712,  -712,  -712,  -712,  -712,   819,
    -712,   435,   954,   963,  -712,  -712,   819,  -712,   819,   819,
     819,   819,   965,  -712,  -712,  -712,  -712,  -712,  -712,   966,
     201,   968,   436,   472,  3843,   492,   522,   535,   532,    84,
     117,  -712,   975,   977,   354,  -712,  -712,  -712,  -712,  -712,
    -712,  -712,  -712,   -33,   971,   974,   -33,   976,  -712,  -712,
    3843,  3843,  -712,   201,  3843,  -712,   979,  3843,  -712,  3843,
     978,  -712,   978,   978,   201,   980,  -712,  -712,  -712,   981,
     982,   983,   986,   987,  -712,  -712,  -712,  -712,  -712,   162,
     144,   198,  -712,  -712,  -712,   294,  3843,  -712,  3843,  -712,
    -712,  3843,  -712,  -712,  -712,  -712,  -712,  -712,  2208,  2208,
    3843,  -712,  -712,  -712,  3843,  -712,  -712,  -712,  -712,  -712,
    -712,  -712,  -712,  -712,   546,   988,   990,   354,   984,   969,
     995,  1000,  1000,  1000,  -712,  -712,  -712,  -712,  3843,  -712,
    -712,   -82,  -712,  1001,  1004,  3843,  3843,  1006,  1007,  -712,
    -712
  };

  const short
  parser::yydefact_[] =
  {
       0,     5,     0,     7,     0,     1,     8,     9,    40,    12,
      13,    14,     6,    46,     0,     0,   140,     0,   148,     0,
       0,    43,     4,    11,    20,    21,    22,     0,    26,    16,
      17,    18,    15,    19,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   276,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   237,   311,
     238,    35,    36,    37,    39,    38,   236,   308,   234,     0,
     235,     0,    25,     0,     0,     0,     0,   307,    41,    42,
      44,    45,    10,     0,     0,     0,     0,     0,   416,     0,
     419,   421,     0,   424,   425,   426,     0,     0,     0,     0,
       0,     0,     0,   475,     0,     0,     0,     0,   483,   481,
     485,   487,     0,     0,   489,   491,     0,     0,     0,     0,
     495,     0,     0,     0,     0,   500,     0,     0,     0,     0,
     126,     0,     0,   165,   169,     0,   167,    30,   138,   123,
     158,     0,     0,     0,     0,   341,     0,   157,   111,   203,
     116,   121,   205,     0,   182,   201,   117,   341,    33,   153,
       0,   341,     0,   135,   126,   156,     0,    31,    47,    51,
       0,     0,    28,    29,    78,    89,    88,    86,    87,    82,
      83,    85,    75,    76,    77,    74,    73,    62,    61,    63,
      64,    65,    59,    56,    57,    58,    90,    91,    92,    93,
      94,    95,    79,    80,    81,    54,    55,    66,    67,    68,
      69,    70,    72,    71,    52,    53,    60,    84,    27,   357,
     359,   360,   361,   362,   363,   364,   365,   366,   367,   368,
     369,   370,   371,   372,   373,   374,   378,   376,   377,   375,
     450,   451,   446,   447,   448,   452,   453,   449,   379,   380,
     381,   382,   383,   384,   385,   386,   387,   388,   389,   390,
     391,   392,   393,   394,   395,   396,   397,   398,   399,   400,
     401,   402,   403,   404,     0,   260,   261,   239,   262,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   333,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    24,     0,
     141,    23,   149,   143,     0,   532,   534,   536,   538,   540,
     542,   544,     0,     0,   510,   229,   406,   405,   561,   554,
     555,   556,   557,   558,   559,   508,   552,   553,     0,     0,
     408,   407,   412,   411,     0,   212,   233,     0,   551,   549,
     548,   550,   414,   231,   230,     0,   546,   418,   417,     0,
     420,   568,   569,   567,   565,     0,     0,   561,   422,   423,
     564,   566,   427,   428,   431,   429,     0,   432,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   572,   573,
     477,   476,   563,   478,   562,   479,     0,     0,   482,   486,
     484,   490,   488,   492,   494,   493,     0,   497,   498,   499,
     501,   503,   502,   504,   506,   505,   108,   109,     0,     0,
       0,     0,   147,   330,   329,     0,   236,    96,   213,     0,
     234,   235,   236,    96,   224,   234,   235,     0,   159,   236,
      96,   218,   223,   234,   235,     0,     0,   189,   190,    96,
     187,   124,   192,     0,   343,   342,     0,   198,     0,   236,
      96,   207,   234,   235,    96,     0,   202,   119,     0,     0,
     152,     0,   200,   134,   136,     0,   125,     0,    49,     0,
      98,    99,   100,   101,   102,   105,   104,   103,   106,   107,
     154,     0,     0,   154,   154,     0,     0,     0,     0,     0,
       0,   306,     0,   309,   309,   309,     0,   330,   329,     0,
       0,   309,     0,     0,     0,     0,     0,   309,     0,     0,
     309,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   196,   309,   309,     0,   527,   528,   529,   530,   531,
     348,   351,   347,   346,   350,   345,   344,   349,     0,     0,
       0,     0,   515,   516,   517,   518,   519,   520,   521,   525,
     526,     0,     0,     0,   322,   331,     0,     0,     0,     0,
     335,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   309,     0,   248,   249,   256,   257,   258,   259,   242,
     247,   244,   243,   246,   245,   241,   240,   252,   251,   250,
     253,   254,   255,   312,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   547,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   230,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   128,   129,   127,   130,     0,    97,   166,    97,   170,
       0,     0,    97,   168,    97,   186,     0,   191,     0,     0,
     115,   112,   113,    97,   206,   204,   184,    96,   120,   118,
       0,    34,     0,   132,    32,    48,   173,   179,   155,   171,
     180,   177,   178,   175,   174,   172,   181,   176,   358,   328,
       0,     0,     0,     0,     0,   268,   269,   265,   299,     0,
       0,   300,   303,     0,     0,     0,     0,     0,     0,     0,
       0,   263,   301,   267,     0,   264,     0,     0,   313,     0,
     321,     0,     0,     0,     0,     0,   270,   272,   274,   275,
     271,   273,     0,     0,   323,     0,     0,     0,   334,   327,
       0,   298,   325,     0,     0,     0,     0,     0,   324,     0,
     266,     0,   151,   139,   560,     0,     0,     0,     0,     0,
       0,     0,   511,   509,   409,   410,   413,     0,   415,   430,
     433,     0,     0,     0,   507,     0,   444,   442,   443,   439,
     440,   441,   438,     0,     0,   570,   571,     0,     0,   574,
     576,   514,   455,   456,   457,   459,   458,   463,   462,   460,
     461,   465,   466,   467,   470,   469,   472,   468,   471,   473,
     474,   464,   480,   496,   110,     0,    96,   214,   225,     0,
      96,   163,   219,   188,   193,     0,   199,   114,   208,    97,
     183,     0,     0,     0,    50,   310,   290,   289,   291,   309,
     279,     0,     0,     0,   287,   277,   309,   280,   309,   309,
     309,   309,     0,   197,   278,   286,   522,   523,   524,     0,
     332,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   288,     0,   144,     0,   533,   535,   539,   543,   537,
     541,   545,   232,     0,     0,     0,     0,     0,   575,   577,
       0,     0,   454,   131,    97,   195,    96,    97,   160,     0,
     352,   185,   352,   352,   133,     0,   302,   320,   304,     0,
       0,     0,     0,     0,   314,   305,   319,   293,   294,   236,
     234,   235,   296,   295,   297,     0,     0,   316,     0,   318,
     143,     0,   150,   436,   437,   445,   434,   435,   512,   513,
      97,   161,   164,   194,     0,   354,   354,   354,   292,   281,
     283,   282,   285,   284,     0,     0,     0,     0,   145,    96,
       0,   137,   340,   339,   326,   315,   317,   142,     0,   162,
     353,     0,   146,     0,     0,     0,     0,     0,     0,   355,
     356
  };

  const short
  parser::yypgoto_[] =
  {
    -712,   299,  -712,  -712,  -712,  -712,   -25,  -712,  -712,  -712,
    -712,  -712,  -712,   817,  -712,   818,  -712,  -151,   -61,  -712,
    -712,  -712,  -712,  -712,   843,  -452,  -175,  -712,  -711,  -712,
    -712,   471,  -291,  -712,  -712,  -712,  -712,  -712,  -712,  -712,
    -712,  -712,   825,  -712,  -712,  -712,  -712,  -712,  -712,  -712,
    -712,     0,  -712,  -712,  -712,  -712,  -712,  -712,  -712,  -712,
      35,  -712,  -712,  -712,  -712,    -9,  -712,  -712,  -712,  -712,
    -712,  -712,  -712,  -712,  -712,  -712,  -712,  -712,  -712,  -712,
    -712,  -712,   280,  -712,  -712,  -712,  -712,   297,  -712,  -712,
    -712,  -712,  -712,  -712,  -712,   851,   282,   -18,  -712,   300,
    -712,   296,  -712,   302,  -145,   -90,  -155,  -712,    11,  -148,
    -712,   -19,   -13,  -506,   709,   582,  -712,  -712,  -712,  -712,
    -712,   -34,  -287,  -380,  -411,   457,  -712,  -712,  -712,  -712,
    -712,  -712,  -712,  -712,  -712,  -712,  -712,  -712,  -712,  -712,
    -712,  -712,  -712,  -712,  -712,  -712,  -127,  -126,  -712,  -712,
    -712,  -712,  -712,  -712,  -712,  -712,  -712,  -712,  -712,  -712,
    -712,  -712,  -712,  -712,  -712,  -712,  -712,  -712,  -712,  -712,
    -712,  -712,  -712,  -712,  -712,  -712,  -712,  -712,  -712,  -712,
    -712,  -712,  -712,  -111,   303,   548,  -712,  -712,  -712,  -106,
     707,  -317,   726,   727,   729,   730,    15,  -712,   -71,   910,
     911,   934,  -114,   -95,  -113,   346,   733,   738
  };

  const short
  parser::yydefgoto_[] =
  {
       0,     2,     3,     4,     8,    22,    12,    23,    24,    25,
      26,    27,   199,   200,   557,   201,   549,    95,    96,    28,
     202,   558,   765,   203,   204,   737,   575,   205,   496,   206,
     538,   751,   752,   207,   208,   547,   759,   209,   210,   211,
     212,   213,   501,   214,   215,   553,   216,    29,    30,   103,
     684,   686,   962,    31,    32,   105,   685,   964,   217,   218,
     767,   219,   220,   221,   222,   910,   223,   224,   225,   226,
     227,   228,   229,   230,   231,   232,   233,   234,   545,   757,
     235,   529,   530,   236,    33,   237,   238,   610,   239,   240,
     241,   242,   243,   244,   245,   540,   541,   414,   507,   508,
     520,   521,   513,   514,   394,   705,   423,   694,    97,    98,
     324,   497,   107,   781,   100,   101,   646,   651,   828,   246,
     247,   536,   629,  1035,  1051,   248,   249,   250,   251,   252,
     253,   254,   255,   256,   257,   258,   259,   260,   261,   262,
     263,   264,   265,   266,   267,   268,   452,   453,   269,   270,
     271,   272,   273,   274,   275,   276,   277,   278,   279,   280,
     281,   282,   283,   284,   285,   286,   287,   288,   289,   290,
     291,   292,   293,   294,   295,   296,   297,   298,   299,   300,
     301,   302,   303,   454,   396,   397,   982,   630,   631,   437,
     399,   400,   401,   402,   403,   404,   695,   426,   405,   406,
     407,   473,   439,   440,   441,   467,   468,   469
  };

  const short
  parser::yytable_[] =
  {
     106,    99,   112,   483,   104,   461,   462,   398,   398,   398,
     490,   522,   443,   398,   430,   510,   515,   385,   523,   466,
     527,   463,   634,   450,   455,   457,   579,   422,   398,   909,
     102,  1063,   449,   644,   542,   542,     5,   445,   447,   451,
     474,   474,   534,   398,   188,   304,   305,   306,   307,   308,
     398,   438,   398,   642,   809,   442,   456,   378,    13,   823,
    -330,   739,   810,   309,  -122,  -122,  -122,   824,   743,   197,
     535,   479,   480,   385,   477,   481,   482,   745,   782,   783,
     385,   487,   488,   489,   385,   789,   493,  1064,   754,   735,
    1016,   795,   755,   788,   798,   889,   418,   385,  1017,   310,
     379,   503,   506,   512,   379,   519,   811,   812,   419,   420,
     421,   503,   503,   503,    91,    92,    93,   498,   499,   476,
     311,   539,   539,  1018,   395,   395,   395,   415,   424,   807,
     395,  1019,   425,   486,   707,   503,   502,   808,   424,   424,
     791,   707,   446,   448,   379,   395,   518,   379,   415,   500,
    -336,   429,   312,   548,   478,   839,   384,   551,  -336,   395,
     395,   313,   415,     9,    10,    11,   395,   395,  -338,   395,
     314,   550,    14,    15,   509,   509,  -338,   509,    39,   792,
     554,   379,   802,  -330,   315,    16,   379,    17,   316,   379,
     746,    18,   317,   509,   509,    51,   534,   385,   386,   387,
     388,   389,   390,   391,  -337,   379,    19,   429,   318,    65,
      66,  -329,  -337,   319,   429,   790,    72,    73,   429,  -329,
      76,   384,   379,    79,   535,   793,    82,    83,    84,    85,
     379,   429,   794,   632,  -217,  -217,  -217,  -217,   320,   822,
     379,    89,   816,    91,    92,    93,    94,   379,   582,   379,
     108,   109,  -330,   587,   379,   503,   380,   503,   503,   503,
     503,   503,   385,   386,   387,   388,   389,   390,   391,   503,
     431,   432,   433,   434,   503,   321,    20,    21,   503,   503,
     503,   503,   503,   503,   503,   503,   503,   503,   503,   503,
     503,   503,   503,   503,   503,   820,   825,   583,   584,   585,
     586,   826,   379,   844,   591,   920,   382,   827,   877,   878,
     597,   379,   599,   600,   601,   602,   379,    -2,   503,   606,
     831,   608,   379,   611,   612,   613,   589,   379,   322,    -2,
     381,   435,     6,     7,   323,   436,   325,   830,   833,   326,
     603,   834,   605,   661,   607,   358,   359,   360,   361,   362,
     363,   579,   379,   379,  1067,   327,   379,     9,    10,    11,
     458,   372,   373,   374,   375,   376,   377,   383,   662,   663,
     664,   665,   666,   667,   668,   669,   670,   671,   672,   673,
     674,   675,   676,   677,   678,   679,   680,   681,   682,   328,
    -216,  -216,  -216,  -216,   756,   329,   435,    91,    92,    93,
     436,   385,   386,   387,   388,   389,   390,   391,  -329,   431,
     432,   459,   460,  -228,  -228,  -228,  -228,   410,   412,   832,
     838,   835,   427,   995,   110,   111,   379,   379,   307,   330,
     999,  -330,  1000,  1001,  1002,  1003,   379,   470,   559,   560,
     561,   562,   563,   564,   565,   566,   567,   568,   569,   996,
    1007,   331,   484,    39,   985,   332,   379,   379,   988,   491,
     917,   494,   706,   360,   361,   362,   363,   917,   836,   706,
      51,  -227,  -227,  -227,  -227,   503,   333,   372,   373,   374,
     375,   376,   377,   379,    65,    66,  1008,   503,   334,  -329,
     503,    72,    73,   379,   837,    76,   570,   335,    79,   915,
     921,    82,    83,    84,    85,   363,  1012,   537,   747,   379,
     336,   503,   734,   379,   379,   379,    89,   503,    91,    92,
      93,    94,  -222,  -222,  -222,  -222,   922,   948,   571,   572,
     980,   981,   877,   878,  1031,   435,  1013,   796,  1015,   436,
    -330,   379,   763,   379,   337,   852,   766,   855,   975,  1014,
     338,   768,   573,   379,   768,   768,   379,   574,   769,   580,
    1054,   546,   773,   774,   775,   339,   777,   379,  -221,  -221,
    -221,  -221,   340,  -211,  -211,  -211,  -211,   854,   687,   891,
     893,   849,   850,   851,   870,   871,  -329,   522,   510,   341,
     515,  -330,   342,   527,   523,   552,   911,  1059,   894,   895,
     872,   343,   867,   868,   869,   542,   858,   886,   771,   772,
     859,   860,  1036,  1037,   896,   887,   888,   890,   344,   853,
     345,   901,   856,   346,   883,  1052,  1053,   347,   990,   882,
     885,   900,   348,   349,   992,   993,   899,  -210,  -210,  -210,
    -210,   350,   576,   560,   561,   562,   563,   564,   565,   566,
     567,   568,   569,   892,   897,  -329,   351,   902,   903,   352,
     353,   843,   411,   413,   690,   354,   355,   428,   360,   361,
     362,   363,   356,   357,   598,   506,   688,   512,   689,   691,
     692,   519,   471,   693,   696,   375,   376,   377,   697,   813,
     814,   815,   539,   717,   718,   698,   699,   485,   700,   603,
     607,   395,   701,   395,   492,   702,   495,   424,   703,   708,
     709,   424,   424,   472,   431,   432,   433,   904,  -215,  -215,
    -215,  -215,   611,    91,    92,    93,    94,   914,   710,   503,
     424,   424,   577,   578,   711,   395,   395,   424,  -226,  -226,
    -226,  -226,   713,   719,   505,   712,   720,   509,   721,   509,
     722,   723,   395,   509,   531,   532,   533,  -220,  -220,  -220,
    -220,   724,   503,   725,   509,   503,   503,   925,   991,   503,
     726,   929,   503,   503,   503,   727,   728,   729,   556,   730,
     932,   933,   731,   732,   936,   733,   938,   939,   942,   736,
     738,   940,   741,   941,   740,   742,   943,   620,   621,   622,
     623,   624,   625,   626,   627,   744,  1010,   749,   750,   949,
     753,   761,   951,  -209,  -209,  -209,  -209,   360,   361,   362,
     363,   764,   779,   959,   960,   780,   785,   784,   963,   559,
     560,   561,   562,   563,   564,   565,   566,   567,   568,   569,
     786,   797,  1032,   799,   503,   800,   804,   806,   576,   560,
     561,   562,   563,   564,   565,   566,   567,   568,   569,   817,
     818,   819,   503,   431,   432,   433,   434,  1023,   821,   829,
    1026,   504,   511,   516,   607,   524,   663,   845,   846,   847,
     848,   504,   504,   504,   841,   911,   842,   570,   845,   844,
     861,   543,   543,  1009,   862,   863,   864,   866,   590,   451,
     592,   593,   594,   595,   596,   504,   873,   874,   916,   875,
     876,   879,   604,   880,   919,   923,   924,   609,   926,   571,
     927,   628,   641,   643,   645,   647,   648,   649,   650,   652,
     653,   654,   655,   656,   657,   658,   659,   660,   577,  1022,
     928,   930,   934,   573,   935,   937,   944,   945,   574,   946,
     947,   954,   961,   974,   503,   965,   966,   967,   968,   972,
     969,   683,   970,   971,   973,   509,   976,   977,   997,   978,
    1033,   943,   979,   984,   986,   987,   989,   998,  1020,  1004,
    1005,  1024,  1006,  1021,  1025,  1030,  1027,  1034,   525,   526,
    1058,  1028,  1029,   857,  1038,  1039,  1040,  1041,   395,  1046,
    1042,  1043,  1055,  1045,  1056,  1060,  1061,   416,  1048,    34,
    1065,    35,    36,  1066,   528,  1050,  1069,  1070,   758,   555,
    1047,  1049,  1057,   588,   913,   504,    37,   504,   504,   504,
     504,   504,   906,    38,   544,   918,   907,   778,   912,   504,
     908,   395,   464,   465,   504,  1062,   633,  1068,   504,   504,
     504,   504,   504,   504,   504,   504,   504,   504,   504,   504,
     504,   504,   504,   504,   504,   635,   636,     0,   637,   638,
     475,   898,   639,   905,     0,     0,     0,   640,     0,     0,
       0,     0,   358,   359,   360,   361,   362,   363,   504,   364,
     365,   366,   367,   368,   369,   370,   371,     0,   372,   373,
     374,   375,   376,   377,   358,   359,   360,   361,   362,   363,
       0,   364,   365,   366,   367,   368,   369,   370,   748,     0,
     372,   373,   374,   375,   376,   377,     0,     0,     0,     0,
     760,     0,     0,   762,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   770,    39,     0,     0,     0,     0,
     776,    40,    41,    42,    43,    44,    45,    46,    47,    48,
      49,    50,    51,    52,    53,    54,    55,    56,    57,    58,
      59,    60,    61,    62,    63,    64,    65,    66,    67,    68,
      69,    70,    71,    72,    73,    74,    75,    76,    77,    78,
      79,    80,    81,    82,    83,    84,    85,    86,    87,     0,
       0,     0,     0,     0,     0,     0,     0,    88,    89,    90,
      91,    92,    93,    94,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    39,     0,     0,     0,     0,    -3,
       1,     0,    -3,    -3,    -3,   504,    -3,     0,     0,     0,
       0,    51,     0,     0,    -3,    -3,     0,   504,     0,     0,
     504,     0,     0,     0,     0,    65,    66,     0,     0,     0,
       0,     0,    72,    73,     0,     0,    76,     0,     0,    79,
       0,   504,    82,    83,    84,    85,     0,   504,   620,   621,
     622,   623,   624,   625,   626,   627,     0,    89,     0,    91,
      92,    93,    94,     0,     0,     0,    -3,    -3,    -3,    -3,
      -3,    -3,    -3,    -3,    -3,    -3,    -3,    -3,    -3,    -3,
      -3,    -3,    -3,    -3,    -3,    -3,    -3,    -3,    -3,    -3,
      -3,    -3,    -3,    -3,    -3,    -3,    -3,    -3,    -3,    -3,
      -3,    -3,    -3,    -3,    -3,    -3,    -3,    -3,    -3,    -3,
      -3,    -3,    -3,    -3,    -3,    -3,    -3,    -3,    -3,    -3,
      -3,    -3,    -3,    -3,     0,     0,    -3,    -3,     0,     0,
      -3,    -3,   931,    -3,     0,    -3,    -3,    -3,    -3,    -3,
      -3,    -3,    -3,    -3,    -3,    -3,    -3,    -3,    -3,    -3,
      -3,    -3,     0,    -3,    -3,    -3,    -3,     0,    -3,    -3,
      -3,    -3,    -3,    -3,     0,   950,     0,     0,   952,   953,
       0,     0,   955,     0,     0,   956,   957,   958,    -3,     0,
       0,     0,   581,   358,   359,   360,   361,   362,   363,   614,
     364,   365,   366,   367,   368,   369,   370,   371,     0,   372,
     373,   374,   375,   376,   377,   511,     0,   516,     0,     0,
       0,   524,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   543,    -3,    -3,    -3,     0,     0,     0,     0,
     385,   386,   387,   388,   389,   390,   391,   615,   616,   617,
     618,   619,     0,     0,     0,     0,     0,   983,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   504,
       0,     0,     0,     0,     0,   994,   787,   358,   359,   360,
     361,   362,   363,     0,   364,   365,   366,   367,   368,   369,
     370,   371,     0,   372,   373,   374,   375,   376,   377,     0,
       0,     0,   504,     0,     0,   504,   504,     0,     0,   504,
       0,     0,   504,   504,   504,   801,   358,   359,   360,   361,
     362,   363,     0,   364,   365,   366,   367,   368,   369,   370,
     371,     0,   372,   373,   374,   375,   376,   377,     0,     0,
       0,     0,   803,   358,   359,   360,   361,   362,   363,    39,
     364,   365,   366,   367,   368,   369,   370,   371,     0,   372,
     373,   374,   375,   376,   377,     0,    51,  1044,     0,     0,
       0,     0,     0,     0,   435,     0,     0,     0,   436,     0,
      65,    66,     0,     0,   504,     0,     0,    72,    73,     0,
       0,    76,     0,     0,    79,     0,     0,    82,    83,    84,
      85,     0,   504,   620,   621,   622,   623,   624,   625,   626,
     627,     0,    89,     0,    91,    92,    93,    94,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     1,  1011,    -3,    -3,    -3,     0,    -3,     0,
       0,     0,     0,    -3,     0,     0,    -3,    -3,   113,   114,
     115,   116,   117,   118,   119,   120,   121,   122,   123,   124,
     125,   126,   127,   128,   129,   130,   131,   132,   133,   134,
     135,   136,   137,   138,   139,   140,   141,   142,   143,   144,
     145,   146,   147,   148,   149,   150,   151,   152,   153,   154,
     155,   156,   157,   158,   504,     0,     0,     0,    -3,    -3,
      -3,    -3,    -3,    -3,    -3,    -3,    -3,    -3,    -3,    -3,
      -3,    -3,    -3,    -3,    -3,    -3,    -3,    -3,    -3,    -3,
      -3,    -3,    -3,    -3,    -3,    -3,    -3,    -3,    -3,    -3,
      -3,    -3,    -3,    -3,    -3,    -3,    -3,    -3,    -3,    -3,
      -3,    -3,    -3,    -3,    -3,    -3,    -3,    -3,    -3,    -3,
      -3,    -3,    -3,    -3,    -3,    -3,     0,     0,    -3,    -3,
       0,     0,    -3,    -3,     0,    -3,     0,    -3,    -3,    -3,
      -3,    -3,    -3,    -3,    -3,    -3,    -3,    -3,    -3,    -3,
      -3,    -3,    -3,    -3,     0,    -3,    -3,    -3,    -3,     0,
      -3,    -3,    -3,    -3,    -3,    -3,   384,     0,     0,     0,
      34,     0,    35,    36,     0,     0,     0,     0,     0,     0,
      -3,   358,   359,   360,   361,   362,   363,    37,   364,   365,
     366,   367,   368,   369,    38,     0,     0,   372,   373,   374,
     375,   376,   377,     0,     0,     0,     0,   385,   386,   387,
     388,   389,   390,   391,     0,     0,     0,   408,   409,     0,
       0,     0,     0,     0,     0,    -3,    -3,    -3,     0,     0,
       0,     0,     0,     0,     0,   384,     0,     0,     0,    34,
       0,    35,    36,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    37,     0,     0,     0,
       0,     0,     0,    38,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   385,   386,   387,   388,
     389,   390,   391,   805,   358,   359,   360,   361,   362,   363,
       0,   364,   365,   366,   367,   368,   369,   370,   371,     0,
     372,   373,   374,   375,   376,   377,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    39,     0,     0,     0,
       0,     0,    40,    41,    42,    43,    44,    45,    46,    47,
      48,    49,    50,    51,    52,    53,    54,    55,    56,    57,
      58,   392,    60,    61,    62,   393,    64,    65,    66,    67,
      68,    69,    70,    71,    72,    73,    74,    75,    76,    77,
      78,    79,    80,    81,    82,    83,    84,    85,    86,    87,
       0,     0,     0,     0,     0,     0,     0,     0,    88,    89,
      90,    91,    92,    93,    94,    39,     0,     0,     0,     0,
       0,    40,    41,    42,    43,    44,    45,    46,    47,    48,
      49,    50,    51,    52,    53,    54,    55,    56,    57,    58,
     392,    60,    61,    62,   393,    64,    65,    66,    67,    68,
      69,    70,    71,    72,    73,    74,    75,    76,    77,    78,
      79,    80,    81,    82,    83,    84,    85,    86,    87,   458,
       0,     0,     0,    34,     0,    35,    36,    88,    89,    90,
      91,    92,    93,    94,     0,     0,     0,     0,     0,     0,
      37,     0,     0,     0,     0,     0,     0,    38,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     385,   386,   387,   388,   389,   390,   391,   840,   358,   359,
     360,   361,   362,   363,     0,   364,   365,   366,   367,   368,
     369,   370,   371,     0,   372,   373,   374,   375,   376,   377,
     416,     0,    34,     0,    35,    36,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    37,
       0,     0,     0,     0,     0,     0,    38,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   387,     0,     0,     0,     0,     0,   714,   715,   716,
       0,   717,   718,   358,   359,   360,   361,   362,   363,     0,
     364,   365,   366,   367,   368,   369,   370,   371,     0,   372,
     373,   374,   375,   376,   377,     0,     0,     0,     0,    39,
       0,     0,     0,     0,     0,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,   392,    60,    61,    62,   393,    64,
      65,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,     0,     0,     0,     0,     0,     0,     0,
       0,    88,    89,    90,    91,    92,    93,    94,    39,     0,
       0,     0,     0,     0,    40,    41,    42,    43,    44,    45,
      46,    47,    48,    49,    50,    51,    52,    53,    54,    55,
      56,    57,    58,    59,    60,    61,    62,   704,    64,    65,
      66,    67,    68,    69,    70,    71,    72,    73,    74,    75,
      76,    77,    78,    79,    80,    81,    82,    83,    84,    85,
      86,    87,   416,     0,    34,     0,    35,    36,     0,     0,
      88,    89,    90,    91,    92,    93,    94,     0,     0,     0,
       0,   417,     0,     0,     0,     0,     0,     0,    38,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   418,     0,     0,     0,     0,     0,     0,
       0,   444,     0,     0,     0,   419,   420,   421,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   416,     0,    34,     0,    35,    36,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     417,     0,     0,     0,     0,     0,     0,    38,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   418,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   419,   420,   421,   865,   359,   360,
     361,   362,   363,     0,   364,   365,   366,   367,   368,   369,
     370,   371,     0,   372,   373,   374,   375,   376,   377,     0,
      39,     0,     0,     0,     0,     0,    40,    41,    42,    43,
      44,    45,    46,    47,    48,    49,    50,    51,    52,    53,
      54,    55,    56,    57,    58,    59,    60,    61,    62,    63,
      64,    65,    66,    67,    68,    69,    70,    71,    72,    73,
      74,    75,    76,    77,    78,    79,    80,    81,    82,    83,
      84,    85,    86,    87,     0,     0,     0,     0,     0,     0,
       0,     0,    88,    89,    90,    91,    92,    93,    94,    39,
       0,     0,     0,     0,     0,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,   416,     0,    34,     0,    35,    36,     0,
       0,    88,    89,    90,    91,    92,    93,    94,     0,     0,
       0,     0,    37,     0,     0,     0,     0,     0,     0,    38,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     431,   432,   433,   881,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   416,     0,    34,     0,    35,    36,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    37,     0,     0,     0,     0,     0,     0,    38,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   431,
     432,   884,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    39,     0,     0,     0,     0,     0,    40,    41,    42,
      43,    44,    45,    46,    47,    48,    49,    50,    51,    52,
      53,    54,    55,    56,    57,    58,    59,    60,    61,    62,
      63,    64,    65,    66,    67,    68,    69,    70,    71,    72,
      73,    74,    75,    76,    77,    78,    79,    80,    81,    82,
      83,    84,    85,    86,    87,     0,     0,     0,     0,     0,
       0,     0,     0,    88,    89,    90,    91,    92,    93,    94,
      39,     0,     0,     0,     0,     0,    40,    41,    42,    43,
      44,    45,    46,    47,    48,    49,    50,    51,    52,    53,
      54,    55,    56,    57,    58,    59,    60,    61,    62,    63,
      64,    65,    66,    67,    68,    69,    70,    71,    72,    73,
      74,    75,    76,    77,    78,    79,    80,    81,    82,    83,
      84,    85,    86,    87,   416,     0,    34,     0,    35,    36,
       0,     0,    88,    89,    90,    91,    92,    93,    94,     0,
       0,     0,     0,    37,     0,     0,     0,     0,     0,     0,
      38,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   431,   432,   433,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   416,     0,    34,     0,    35,    36,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    37,     0,     0,     0,     0,     0,     0,    38,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   387,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    39,     0,     0,     0,     0,     0,    40,    41,
      42,    43,    44,    45,    46,    47,    48,    49,    50,    51,
      52,    53,    54,    55,    56,    57,    58,    59,    60,    61,
      62,    63,    64,    65,    66,    67,    68,    69,    70,    71,
      72,    73,    74,    75,    76,    77,    78,    79,    80,    81,
      82,    83,    84,    85,    86,    87,     0,     0,     0,     0,
       0,     0,     0,     0,    88,    89,    90,    91,    92,    93,
      94,    39,     0,     0,     0,     0,     0,    40,    41,    42,
      43,    44,    45,    46,    47,    48,    49,    50,    51,    52,
      53,    54,    55,    56,    57,    58,    59,    60,    61,    62,
     704,    64,    65,    66,    67,    68,    69,    70,    71,    72,
      73,    74,    75,    76,    77,    78,    79,    80,    81,    82,
      83,    84,    85,    86,    87,    34,     0,    35,    36,     0,
       0,     0,     0,    88,    89,    90,    91,    92,    93,    94,
       0,     0,   417,     0,     0,     0,     0,     0,     0,    38,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   418,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   419,   420,   421,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    34,     0,    35,    36,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    37,     0,     0,     0,     0,     0,     0,    38,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   845,   846,
     847,   848,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    39,     0,     0,     0,     0,     0,    40,    41,    42,
      43,    44,    45,    46,    47,    48,    49,    50,    51,    52,
      53,    54,    55,    56,    57,    58,    59,    60,    61,    62,
      63,    64,    65,    66,    67,    68,    69,    70,    71,    72,
      73,    74,    75,    76,    77,    78,    79,    80,    81,    82,
      83,    84,    85,    86,    87,     0,     0,     0,     0,     0,
       0,     0,     0,    88,    89,    90,    91,    92,    93,    94,
      39,     0,     0,     0,     0,     0,    40,    41,    42,    43,
      44,    45,    46,    47,    48,    49,    50,    51,    52,    53,
      54,    55,    56,    57,    58,    59,    60,    61,    62,    63,
      64,    65,    66,    67,    68,    69,    70,    71,    72,    73,
      74,    75,    76,    77,    78,    79,    80,    81,    82,    83,
      84,    85,    86,    87,    34,     0,    35,    36,     0,     0,
       0,     0,    88,    89,    90,    91,    92,    93,    94,     0,
       0,    37,     0,     0,     0,     0,     0,     0,    38,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   849,
     850,   851,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    34,     0,    35,    36,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    37,     0,     0,     0,     0,     0,     0,    38,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      39,     0,     0,     0,     0,     0,    40,    41,    42,    43,
      44,    45,    46,    47,    48,    49,    50,    51,    52,    53,
      54,    55,    56,    57,    58,    59,    60,    61,    62,    63,
      64,    65,    66,    67,    68,    69,    70,    71,    72,    73,
      74,    75,    76,    77,    78,    79,    80,    81,    82,    83,
      84,    85,    86,    87,   517,     0,    34,     0,    35,    36,
       0,     0,    88,    89,    90,    91,    92,    93,    94,     0,
       0,     0,     0,    37,     0,     0,     0,     0,     0,     0,
      38,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      39,   849,     0,     0,     0,     0,    40,    41,    42,    43,
      44,    45,    46,    47,    48,    49,    50,    51,    52,    53,
      54,    55,    56,    57,    58,    59,    60,    61,    62,    63,
      64,    65,    66,    67,    68,    69,    70,    71,    72,    73,
      74,    75,    76,    77,    78,    79,    80,    81,    82,    83,
      84,    85,    86,    87,    34,     0,    35,    36,     0,     0,
       0,     0,    88,    89,    90,    91,    92,    93,    94,     0,
       0,    37,     0,     0,     0,     0,     0,     0,    38,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   387,     0,     0,     0,     0,     0,     0,
       0,     0,    39,     0,     0,     0,     0,     0,    40,    41,
      42,    43,    44,    45,    46,    47,    48,    49,    50,    51,
      52,    53,    54,    55,    56,    57,    58,    59,    60,    61,
      62,    63,    64,    65,    66,    67,    68,    69,    70,    71,
      72,    73,    74,    75,    76,    77,    78,    79,    80,    81,
      82,    83,    84,    85,    86,    87,    34,     0,    35,    36,
       0,     0,     0,     0,    88,    89,    90,    91,    92,    93,
      94,     0,     0,    37,     0,     0,     0,     0,     0,     0,
      38,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      39,     0,     0,     0,     0,     0,    40,    41,    42,    43,
      44,    45,    46,    47,    48,    49,    50,    51,    52,    53,
      54,    55,    56,    57,    58,    59,    60,    61,    62,   704,
      64,    65,    66,    67,    68,    69,    70,    71,    72,    73,
      74,    75,    76,    77,    78,    79,    80,    81,    82,    83,
      84,    85,    86,    87,     0,     0,     0,     0,     0,     0,
       0,     0,    88,    89,    90,    91,    92,    93,    94,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    39,     0,     0,     0,     0,     0,    40,    41,
      42,    43,    44,    45,    46,    47,    48,    49,    50,    51,
      52,    53,    54,    55,    56,    57,    58,    59,    60,    61,
      62,    63,    64,    65,    66,    67,    68,    69,    70,    71,
      72,    73,    74,    75,    76,    77,    78,    79,    80,    81,
      82,    83,    84,    85,    86,    87,     0,     0,     0,     0,
       0,     0,     0,     0,    88,    89,    90,    91,    92,    93,
      94,   113,   114,   115,   116,   117,   118,   119,   120,   121,
     122,   123,   124,   125,   126,   127,   128,   129,   130,   131,
     132,   133,   134,   135,   136,   137,   138,   139,   140,   141,
     142,   143,   144,   145,   146,   147,   148,   149,   150,   151,
     152,   153,   154,   155,   156,   157,   158,   159,   160,   161,
     162,   163,   164,   165,   166,     0,     0,   167,   168,     0,
       0,   169,   170,     0,     0,   171,   172,     0,     0,     0,
       0,   173,   174,   175,     0,   176,   177,   178,   179,   180,
     181,   182,   183,   184,   185,   186,   187,     0,   188,     0,
     189,   190,     0,   191,   192,   193,   194,   195,   196,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   197,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   198
  };

  const short
  parser::yycheck_[] =
  {
      19,    14,    27,   148,    17,   132,   132,   113,   114,   115,
     155,   166,   126,   119,   120,   163,   164,    50,   166,   132,
     171,   132,   339,   129,   130,   131,   201,   117,   134,   740,
       3,   113,     9,    14,   182,   183,     0,   127,   128,     9,
     135,   136,   135,   149,   154,    34,    35,    36,    37,    38,
     156,   122,   158,   340,     6,   126,     9,     3,     7,     6,
      21,   513,    14,    13,     3,     4,     5,    14,   520,   179,
     163,   142,   143,    50,    30,   146,   147,   529,   584,   585,
      50,   152,   153,   154,    50,   591,   157,   169,   540,     6,
       6,   597,   544,    14,   600,    61,    52,    50,    14,    13,
      21,   162,   163,   164,    21,   166,   612,   613,    64,    65,
      66,   172,   173,   174,   224,   225,   226,   132,   133,   137,
      13,   182,   183,     6,   113,   114,   115,   116,   117,     6,
     119,    14,   117,   151,   451,   196,   161,    14,   127,   128,
      14,   458,   127,   128,    21,   134,   165,    21,   137,   164,
       6,   184,    13,   187,   139,   661,     9,   191,    14,   148,
     149,    13,   151,     3,     4,     5,   155,   156,     6,   158,
      13,   190,   121,   122,   163,   164,    14,   166,   159,    14,
     193,    21,    14,    21,    13,   134,    21,   136,    13,    21,
       6,   140,    13,   182,   183,   176,   135,    50,    51,    52,
      53,    54,    55,    56,     6,    21,   155,   184,    13,   190,
     191,    21,    14,    13,   184,     6,   197,   198,   184,    21,
     201,     9,    21,   204,   163,     6,   207,   208,   209,   210,
      21,   184,     6,   339,     3,     4,     5,     6,    13,     6,
      21,   222,    14,   224,   225,   226,   227,    21,   309,    21,
       7,     8,    21,   314,    21,   316,   224,   318,   319,   320,
     321,   322,    50,    51,    52,    53,    54,    55,    56,   330,
      58,    59,    60,    61,   335,    13,   225,   226,   339,   340,
     341,   342,   343,   344,   345,   346,   347,   348,   349,   350,
     351,   352,   353,   354,   355,    14,     6,   310,   311,   312,
     313,     6,    21,    10,   317,   757,   224,     6,    15,    16,
     323,    21,   325,   326,   327,   328,    21,     0,   379,   332,
      14,   334,    21,   336,   337,   338,   315,    21,    13,    12,
       3,   184,    15,    16,    13,   188,    13,     6,     6,    13,
     329,     6,   331,   356,   333,    15,    16,    17,    18,    19,
      20,   526,    21,    21,  1065,    13,    21,     3,     4,     5,
       9,    31,    32,    33,    34,    35,    36,     3,   357,   358,
     359,   360,   361,   362,   363,   364,   365,   366,   367,   368,
     369,   370,   371,   372,   373,   374,   375,   376,   377,    13,
       3,     4,     5,     6,   545,    13,   184,   224,   225,   226,
     188,    50,    51,    52,    53,    54,    55,    56,    21,    58,
      59,    60,    61,     3,     4,     5,     6,   114,   115,    14,
      14,     6,   119,   929,     7,     8,    21,    21,   417,    13,
     936,    21,   938,   939,   940,   941,    21,   134,    39,    40,
      41,    42,    43,    44,    45,    46,    47,    48,    49,    14,
      14,    13,   149,   159,   906,    13,    21,    21,   910,   156,
     751,   158,   451,    17,    18,    19,    20,   758,     6,   458,
     176,     3,     4,     5,     6,   536,    13,    31,    32,    33,
      34,    35,    36,    21,   190,   191,    14,   548,    13,    21,
     551,   197,   198,    21,     6,   201,    97,    13,   204,     6,
       6,   207,   208,   209,   210,    20,    14,   224,   533,    21,
      13,   572,   501,    21,    21,    21,   222,   578,   224,   225,
     226,   227,     3,     4,     5,     6,     6,    10,   129,   130,
      15,    16,    15,    16,   986,   184,    14,   598,     6,   188,
      21,    21,   555,    21,    13,   690,   559,   692,   865,    14,
      13,   570,   153,    21,   573,   574,    21,   158,   571,     8,
      14,   224,   575,   576,   577,    13,   579,    21,     3,     4,
       5,     6,    13,     3,     4,     5,     6,   691,    60,   724,
     725,    58,    59,    60,   711,   711,    21,   742,   736,    13,
     738,    21,    13,   744,   742,   224,   741,  1049,   725,   725,
     711,    13,   708,   709,   710,   753,   696,   720,   573,   574,
     700,   701,   992,   993,   725,   721,   722,   723,    13,   690,
      13,   727,   693,    13,   719,  1036,  1037,    13,   915,   719,
     720,   726,    13,    13,   921,   922,   726,     3,     4,     5,
       6,    13,    39,    40,    41,    42,    43,    44,    45,    46,
      47,    48,    49,   724,   725,    21,    13,   728,   729,    13,
      13,   686,   114,   115,     6,    13,    13,   119,    17,    18,
      19,    20,    13,    13,    13,   736,    13,   738,    13,     6,
       6,   742,   134,     6,     6,    34,    35,    36,    13,    58,
      59,    60,   753,    62,    63,    13,    13,   149,     6,   688,
     689,   690,     6,   692,   156,    60,   158,   696,     6,     6,
       6,   700,   701,    57,    58,    59,    60,   730,     3,     4,
       5,     6,   735,   224,   225,   226,   227,   746,     6,   790,
     719,   720,   129,   130,     6,   724,   725,   726,     3,     4,
       5,     6,     6,     6,   162,    60,     6,   736,     6,   738,
       6,     6,   741,   742,   172,   173,   174,     3,     4,     5,
       6,     6,   823,     6,   753,   826,   827,   780,   919,   830,
       6,   784,   833,   834,   835,     6,     6,     6,   196,     6,
     793,   794,     6,     6,   797,     6,   799,   800,   807,     6,
       6,   804,     6,   806,     9,     6,   809,   213,   214,   215,
     216,   217,   218,   219,   220,     6,   954,     6,   222,   822,
       6,   224,   825,     3,     4,     5,     6,    17,    18,    19,
      20,   224,    14,   836,   837,     6,    14,     6,   841,    39,
      40,    41,    42,    43,    44,    45,    46,    47,    48,    49,
      14,     6,   987,     6,   905,     6,     6,     6,    39,    40,
      41,    42,    43,    44,    45,    46,    47,    48,    49,    14,
      14,    14,   923,    58,    59,    60,    61,   973,    14,    14,
     976,   162,   163,   164,   863,   166,   865,    57,    58,    59,
      60,   172,   173,   174,     6,  1030,     3,    97,    57,    10,
      10,   182,   183,   954,     9,    13,    10,    10,   316,     9,
     318,   319,   320,   321,   322,   196,    10,     9,   224,    10,
      10,    10,   330,    10,     6,     6,   222,   335,    14,   129,
      14,   339,   340,   341,   342,   343,   344,   345,   346,   347,
     348,   349,   350,   351,   352,   353,   354,   355,   129,   964,
      14,    14,    14,   153,    14,    14,    14,    14,   158,    10,
      10,     6,    14,    60,  1015,    14,    14,    14,    14,    12,
      14,   379,    14,    14,     6,   954,     6,    60,    14,    10,
     989,   984,    10,     6,    10,     6,     6,    14,     3,    14,
      14,    10,    14,     6,    10,     6,    10,     9,   171,   171,
       6,   980,   981,   694,    14,    14,    14,    14,   987,  1018,
      14,    14,    14,  1016,    14,    10,     6,    11,  1021,    13,
       9,    15,    16,     9,   171,  1034,    10,    10,   547,   194,
    1020,  1030,  1047,   314,   744,   316,    30,   318,   319,   320,
     321,   322,   735,    37,   183,   753,   736,   580,   742,   330,
     738,  1030,   132,   132,   335,  1058,   339,  1066,   339,   340,
     341,   342,   343,   344,   345,   346,   347,   348,   349,   350,
     351,   352,   353,   354,   355,   339,   339,    -1,   339,   339,
     136,   725,   339,     6,    -1,    -1,    -1,   339,    -1,    -1,
      -1,    -1,    15,    16,    17,    18,    19,    20,   379,    22,
      23,    24,    25,    26,    27,    28,    29,    -1,    31,    32,
      33,    34,    35,    36,    15,    16,    17,    18,    19,    20,
      -1,    22,    23,    24,    25,    26,    27,    28,   536,    -1,
      31,    32,    33,    34,    35,    36,    -1,    -1,    -1,    -1,
     548,    -1,    -1,   551,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   572,   159,    -1,    -1,    -1,    -1,
     578,   165,   166,   167,   168,   169,   170,   171,   172,   173,
     174,   175,   176,   177,   178,   179,   180,   181,   182,   183,
     184,   185,   186,   187,   188,   189,   190,   191,   192,   193,
     194,   195,   196,   197,   198,   199,   200,   201,   202,   203,
     204,   205,   206,   207,   208,   209,   210,   211,   212,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   221,   222,   223,
     224,   225,   226,   227,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   159,    -1,    -1,    -1,    -1,     0,
       1,    -1,     3,     4,     5,   536,     7,    -1,    -1,    -1,
      -1,   176,    -1,    -1,    15,    16,    -1,   548,    -1,    -1,
     551,    -1,    -1,    -1,    -1,   190,   191,    -1,    -1,    -1,
      -1,    -1,   197,   198,    -1,    -1,   201,    -1,    -1,   204,
      -1,   572,   207,   208,   209,   210,    -1,   578,   213,   214,
     215,   216,   217,   218,   219,   220,    -1,   222,    -1,   224,
     225,   226,   227,    -1,    -1,    -1,    67,    68,    69,    70,
      71,    72,    73,    74,    75,    76,    77,    78,    79,    80,
      81,    82,    83,    84,    85,    86,    87,    88,    89,    90,
      91,    92,    93,    94,    95,    96,    97,    98,    99,   100,
     101,   102,   103,   104,   105,   106,   107,   108,   109,   110,
     111,   112,   113,   114,   115,   116,   117,   118,   119,   120,
     121,   122,   123,   124,    -1,    -1,   127,   128,    -1,    -1,
     131,   132,   790,   134,    -1,   136,   137,   138,   139,   140,
     141,   142,   143,   144,   145,   146,   147,   148,   149,   150,
     151,   152,    -1,   154,   155,   156,   157,    -1,   159,   160,
     161,   162,   163,   164,    -1,   823,    -1,    -1,   826,   827,
      -1,    -1,   830,    -1,    -1,   833,   834,   835,   179,    -1,
      -1,    -1,    14,    15,    16,    17,    18,    19,    20,     9,
      22,    23,    24,    25,    26,    27,    28,    29,    -1,    31,
      32,    33,    34,    35,    36,   736,    -1,   738,    -1,    -1,
      -1,   742,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   753,   224,   225,   226,    -1,    -1,    -1,    -1,
      50,    51,    52,    53,    54,    55,    56,    57,    58,    59,
      60,    61,    -1,    -1,    -1,    -1,    -1,   905,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   790,
      -1,    -1,    -1,    -1,    -1,   923,    14,    15,    16,    17,
      18,    19,    20,    -1,    22,    23,    24,    25,    26,    27,
      28,    29,    -1,    31,    32,    33,    34,    35,    36,    -1,
      -1,    -1,   823,    -1,    -1,   826,   827,    -1,    -1,   830,
      -1,    -1,   833,   834,   835,    14,    15,    16,    17,    18,
      19,    20,    -1,    22,    23,    24,    25,    26,    27,    28,
      29,    -1,    31,    32,    33,    34,    35,    36,    -1,    -1,
      -1,    -1,    14,    15,    16,    17,    18,    19,    20,   159,
      22,    23,    24,    25,    26,    27,    28,    29,    -1,    31,
      32,    33,    34,    35,    36,    -1,   176,  1015,    -1,    -1,
      -1,    -1,    -1,    -1,   184,    -1,    -1,    -1,   188,    -1,
     190,   191,    -1,    -1,   905,    -1,    -1,   197,   198,    -1,
      -1,   201,    -1,    -1,   204,    -1,    -1,   207,   208,   209,
     210,    -1,   923,   213,   214,   215,   216,   217,   218,   219,
     220,    -1,   222,    -1,   224,   225,   226,   227,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,     1,   954,     3,     4,     5,    -1,     7,    -1,
      -1,    -1,    -1,    12,    -1,    -1,    15,    16,    67,    68,
      69,    70,    71,    72,    73,    74,    75,    76,    77,    78,
      79,    80,    81,    82,    83,    84,    85,    86,    87,    88,
      89,    90,    91,    92,    93,    94,    95,    96,    97,    98,
      99,   100,   101,   102,   103,   104,   105,   106,   107,   108,
     109,   110,   111,   112,  1015,    -1,    -1,    -1,    67,    68,
      69,    70,    71,    72,    73,    74,    75,    76,    77,    78,
      79,    80,    81,    82,    83,    84,    85,    86,    87,    88,
      89,    90,    91,    92,    93,    94,    95,    96,    97,    98,
      99,   100,   101,   102,   103,   104,   105,   106,   107,   108,
     109,   110,   111,   112,   113,   114,   115,   116,   117,   118,
     119,   120,   121,   122,   123,   124,    -1,    -1,   127,   128,
      -1,    -1,   131,   132,    -1,   134,    -1,   136,   137,   138,
     139,   140,   141,   142,   143,   144,   145,   146,   147,   148,
     149,   150,   151,   152,    -1,   154,   155,   156,   157,    -1,
     159,   160,   161,   162,   163,   164,     9,    -1,    -1,    -1,
      13,    -1,    15,    16,    -1,    -1,    -1,    -1,    -1,    -1,
     179,    15,    16,    17,    18,    19,    20,    30,    22,    23,
      24,    25,    26,    27,    37,    -1,    -1,    31,    32,    33,
      34,    35,    36,    -1,    -1,    -1,    -1,    50,    51,    52,
      53,    54,    55,    56,    -1,    -1,    -1,    60,    61,    -1,
      -1,    -1,    -1,    -1,    -1,   224,   225,   226,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,     9,    -1,    -1,    -1,    13,
      -1,    15,    16,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    30,    -1,    -1,    -1,
      -1,    -1,    -1,    37,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    50,    51,    52,    53,
      54,    55,    56,    14,    15,    16,    17,    18,    19,    20,
      -1,    22,    23,    24,    25,    26,    27,    28,    29,    -1,
      31,    32,    33,    34,    35,    36,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   159,    -1,    -1,    -1,
      -1,    -1,   165,   166,   167,   168,   169,   170,   171,   172,
     173,   174,   175,   176,   177,   178,   179,   180,   181,   182,
     183,   184,   185,   186,   187,   188,   189,   190,   191,   192,
     193,   194,   195,   196,   197,   198,   199,   200,   201,   202,
     203,   204,   205,   206,   207,   208,   209,   210,   211,   212,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   221,   222,
     223,   224,   225,   226,   227,   159,    -1,    -1,    -1,    -1,
      -1,   165,   166,   167,   168,   169,   170,   171,   172,   173,
     174,   175,   176,   177,   178,   179,   180,   181,   182,   183,
     184,   185,   186,   187,   188,   189,   190,   191,   192,   193,
     194,   195,   196,   197,   198,   199,   200,   201,   202,   203,
     204,   205,   206,   207,   208,   209,   210,   211,   212,     9,
      -1,    -1,    -1,    13,    -1,    15,    16,   221,   222,   223,
     224,   225,   226,   227,    -1,    -1,    -1,    -1,    -1,    -1,
      30,    -1,    -1,    -1,    -1,    -1,    -1,    37,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      50,    51,    52,    53,    54,    55,    56,    14,    15,    16,
      17,    18,    19,    20,    -1,    22,    23,    24,    25,    26,
      27,    28,    29,    -1,    31,    32,    33,    34,    35,    36,
      11,    -1,    13,    -1,    15,    16,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    30,
      -1,    -1,    -1,    -1,    -1,    -1,    37,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    52,    -1,    -1,    -1,    -1,    -1,    58,    59,    60,
      -1,    62,    63,    15,    16,    17,    18,    19,    20,    -1,
      22,    23,    24,    25,    26,    27,    28,    29,    -1,    31,
      32,    33,    34,    35,    36,    -1,    -1,    -1,    -1,   159,
      -1,    -1,    -1,    -1,    -1,   165,   166,   167,   168,   169,
     170,   171,   172,   173,   174,   175,   176,   177,   178,   179,
     180,   181,   182,   183,   184,   185,   186,   187,   188,   189,
     190,   191,   192,   193,   194,   195,   196,   197,   198,   199,
     200,   201,   202,   203,   204,   205,   206,   207,   208,   209,
     210,   211,   212,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   221,   222,   223,   224,   225,   226,   227,   159,    -1,
      -1,    -1,    -1,    -1,   165,   166,   167,   168,   169,   170,
     171,   172,   173,   174,   175,   176,   177,   178,   179,   180,
     181,   182,   183,   184,   185,   186,   187,   188,   189,   190,
     191,   192,   193,   194,   195,   196,   197,   198,   199,   200,
     201,   202,   203,   204,   205,   206,   207,   208,   209,   210,
     211,   212,    11,    -1,    13,    -1,    15,    16,    -1,    -1,
     221,   222,   223,   224,   225,   226,   227,    -1,    -1,    -1,
      -1,    30,    -1,    -1,    -1,    -1,    -1,    -1,    37,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    52,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    60,    -1,    -1,    -1,    64,    65,    66,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    11,    -1,    13,    -1,    15,    16,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      30,    -1,    -1,    -1,    -1,    -1,    -1,    37,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    52,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    64,    65,    66,    15,    16,    17,
      18,    19,    20,    -1,    22,    23,    24,    25,    26,    27,
      28,    29,    -1,    31,    32,    33,    34,    35,    36,    -1,
     159,    -1,    -1,    -1,    -1,    -1,   165,   166,   167,   168,
     169,   170,   171,   172,   173,   174,   175,   176,   177,   178,
     179,   180,   181,   182,   183,   184,   185,   186,   187,   188,
     189,   190,   191,   192,   193,   194,   195,   196,   197,   198,
     199,   200,   201,   202,   203,   204,   205,   206,   207,   208,
     209,   210,   211,   212,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   221,   222,   223,   224,   225,   226,   227,   159,
      -1,    -1,    -1,    -1,    -1,   165,   166,   167,   168,   169,
     170,   171,   172,   173,   174,   175,   176,   177,   178,   179,
     180,   181,   182,   183,   184,   185,   186,   187,   188,   189,
     190,   191,   192,   193,   194,   195,   196,   197,   198,   199,
     200,   201,   202,   203,   204,   205,   206,   207,   208,   209,
     210,   211,   212,    11,    -1,    13,    -1,    15,    16,    -1,
      -1,   221,   222,   223,   224,   225,   226,   227,    -1,    -1,
      -1,    -1,    30,    -1,    -1,    -1,    -1,    -1,    -1,    37,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      58,    59,    60,    61,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    11,    -1,    13,    -1,    15,    16,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    30,    -1,    -1,    -1,    -1,    -1,    -1,    37,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    58,
      59,    60,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   159,    -1,    -1,    -1,    -1,    -1,   165,   166,   167,
     168,   169,   170,   171,   172,   173,   174,   175,   176,   177,
     178,   179,   180,   181,   182,   183,   184,   185,   186,   187,
     188,   189,   190,   191,   192,   193,   194,   195,   196,   197,
     198,   199,   200,   201,   202,   203,   204,   205,   206,   207,
     208,   209,   210,   211,   212,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   221,   222,   223,   224,   225,   226,   227,
     159,    -1,    -1,    -1,    -1,    -1,   165,   166,   167,   168,
     169,   170,   171,   172,   173,   174,   175,   176,   177,   178,
     179,   180,   181,   182,   183,   184,   185,   186,   187,   188,
     189,   190,   191,   192,   193,   194,   195,   196,   197,   198,
     199,   200,   201,   202,   203,   204,   205,   206,   207,   208,
     209,   210,   211,   212,    11,    -1,    13,    -1,    15,    16,
      -1,    -1,   221,   222,   223,   224,   225,   226,   227,    -1,
      -1,    -1,    -1,    30,    -1,    -1,    -1,    -1,    -1,    -1,
      37,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    58,    59,    60,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    11,    -1,    13,    -1,    15,    16,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    30,    -1,    -1,    -1,    -1,    -1,    -1,    37,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    52,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   159,    -1,    -1,    -1,    -1,    -1,   165,   166,
     167,   168,   169,   170,   171,   172,   173,   174,   175,   176,
     177,   178,   179,   180,   181,   182,   183,   184,   185,   186,
     187,   188,   189,   190,   191,   192,   193,   194,   195,   196,
     197,   198,   199,   200,   201,   202,   203,   204,   205,   206,
     207,   208,   209,   210,   211,   212,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   221,   222,   223,   224,   225,   226,
     227,   159,    -1,    -1,    -1,    -1,    -1,   165,   166,   167,
     168,   169,   170,   171,   172,   173,   174,   175,   176,   177,
     178,   179,   180,   181,   182,   183,   184,   185,   186,   187,
     188,   189,   190,   191,   192,   193,   194,   195,   196,   197,
     198,   199,   200,   201,   202,   203,   204,   205,   206,   207,
     208,   209,   210,   211,   212,    13,    -1,    15,    16,    -1,
      -1,    -1,    -1,   221,   222,   223,   224,   225,   226,   227,
      -1,    -1,    30,    -1,    -1,    -1,    -1,    -1,    -1,    37,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    52,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    64,    65,    66,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    13,    -1,    15,    16,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    30,    -1,    -1,    -1,    -1,    -1,    -1,    37,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    57,    58,
      59,    60,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   159,    -1,    -1,    -1,    -1,    -1,   165,   166,   167,
     168,   169,   170,   171,   172,   173,   174,   175,   176,   177,
     178,   179,   180,   181,   182,   183,   184,   185,   186,   187,
     188,   189,   190,   191,   192,   193,   194,   195,   196,   197,
     198,   199,   200,   201,   202,   203,   204,   205,   206,   207,
     208,   209,   210,   211,   212,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   221,   222,   223,   224,   225,   226,   227,
     159,    -1,    -1,    -1,    -1,    -1,   165,   166,   167,   168,
     169,   170,   171,   172,   173,   174,   175,   176,   177,   178,
     179,   180,   181,   182,   183,   184,   185,   186,   187,   188,
     189,   190,   191,   192,   193,   194,   195,   196,   197,   198,
     199,   200,   201,   202,   203,   204,   205,   206,   207,   208,
     209,   210,   211,   212,    13,    -1,    15,    16,    -1,    -1,
      -1,    -1,   221,   222,   223,   224,   225,   226,   227,    -1,
      -1,    30,    -1,    -1,    -1,    -1,    -1,    -1,    37,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    58,
      59,    60,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    13,    -1,    15,    16,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    30,    -1,    -1,    -1,    -1,    -1,    -1,    37,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     159,    -1,    -1,    -1,    -1,    -1,   165,   166,   167,   168,
     169,   170,   171,   172,   173,   174,   175,   176,   177,   178,
     179,   180,   181,   182,   183,   184,   185,   186,   187,   188,
     189,   190,   191,   192,   193,   194,   195,   196,   197,   198,
     199,   200,   201,   202,   203,   204,   205,   206,   207,   208,
     209,   210,   211,   212,   113,    -1,    13,    -1,    15,    16,
      -1,    -1,   221,   222,   223,   224,   225,   226,   227,    -1,
      -1,    -1,    -1,    30,    -1,    -1,    -1,    -1,    -1,    -1,
      37,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     159,    58,    -1,    -1,    -1,    -1,   165,   166,   167,   168,
     169,   170,   171,   172,   173,   174,   175,   176,   177,   178,
     179,   180,   181,   182,   183,   184,   185,   186,   187,   188,
     189,   190,   191,   192,   193,   194,   195,   196,   197,   198,
     199,   200,   201,   202,   203,   204,   205,   206,   207,   208,
     209,   210,   211,   212,    13,    -1,    15,    16,    -1,    -1,
      -1,    -1,   221,   222,   223,   224,   225,   226,   227,    -1,
      -1,    30,    -1,    -1,    -1,    -1,    -1,    -1,    37,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    52,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   159,    -1,    -1,    -1,    -1,    -1,   165,   166,
     167,   168,   169,   170,   171,   172,   173,   174,   175,   176,
     177,   178,   179,   180,   181,   182,   183,   184,   185,   186,
     187,   188,   189,   190,   191,   192,   193,   194,   195,   196,
     197,   198,   199,   200,   201,   202,   203,   204,   205,   206,
     207,   208,   209,   210,   211,   212,    13,    -1,    15,    16,
      -1,    -1,    -1,    -1,   221,   222,   223,   224,   225,   226,
     227,    -1,    -1,    30,    -1,    -1,    -1,    -1,    -1,    -1,
      37,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     159,    -1,    -1,    -1,    -1,    -1,   165,   166,   167,   168,
     169,   170,   171,   172,   173,   174,   175,   176,   177,   178,
     179,   180,   181,   182,   183,   184,   185,   186,   187,   188,
     189,   190,   191,   192,   193,   194,   195,   196,   197,   198,
     199,   200,   201,   202,   203,   204,   205,   206,   207,   208,
     209,   210,   211,   212,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   221,   222,   223,   224,   225,   226,   227,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   159,    -1,    -1,    -1,    -1,    -1,   165,   166,
     167,   168,   169,   170,   171,   172,   173,   174,   175,   176,
     177,   178,   179,   180,   181,   182,   183,   184,   185,   186,
     187,   188,   189,   190,   191,   192,   193,   194,   195,   196,
     197,   198,   199,   200,   201,   202,   203,   204,   205,   206,
     207,   208,   209,   210,   211,   212,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   221,   222,   223,   224,   225,   226,
     227,    67,    68,    69,    70,    71,    72,    73,    74,    75,
      76,    77,    78,    79,    80,    81,    82,    83,    84,    85,
      86,    87,    88,    89,    90,    91,    92,    93,    94,    95,
      96,    97,    98,    99,   100,   101,   102,   103,   104,   105,
     106,   107,   108,   109,   110,   111,   112,   113,   114,   115,
     116,   117,   118,   119,   120,    -1,    -1,   123,   124,    -1,
      -1,   127,   128,    -1,    -1,   131,   132,    -1,    -1,    -1,
      -1,   137,   138,   139,    -1,   141,   142,   143,   144,   145,
     146,   147,   148,   149,   150,   151,   152,    -1,   154,    -1,
     156,   157,    -1,   159,   160,   161,   162,   163,   164,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   179,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   224
  };

  const short
  parser::yystos_[] =
  {
       0,     1,   229,   230,   231,     0,    15,    16,   232,     3,
       4,     5,   234,     7,   121,   122,   134,   136,   140,   155,
     225,   226,   233,   235,   236,   237,   238,   239,   247,   275,
     276,   281,   282,   312,    13,    15,    16,    30,    37,   159,
     165,   166,   167,   168,   169,   170,   171,   172,   173,   174,
     175,   176,   177,   178,   179,   180,   181,   182,   183,   184,
     185,   186,   187,   188,   189,   190,   191,   192,   193,   194,
     195,   196,   197,   198,   199,   200,   201,   202,   203,   204,
     205,   206,   207,   208,   209,   210,   211,   212,   221,   222,
     223,   224,   225,   226,   227,   245,   246,   336,   337,   340,
     342,   343,     3,   277,   340,   283,   339,   340,     7,     8,
       7,     8,   234,    67,    68,    69,    70,    71,    72,    73,
      74,    75,    76,    77,    78,    79,    80,    81,    82,    83,
      84,    85,    86,    87,    88,    89,    90,    91,    92,    93,
      94,    95,    96,    97,    98,    99,   100,   101,   102,   103,
     104,   105,   106,   107,   108,   109,   110,   111,   112,   113,
     114,   115,   116,   117,   118,   119,   120,   123,   124,   127,
     128,   131,   132,   137,   138,   139,   141,   142,   143,   144,
     145,   146,   147,   148,   149,   150,   151,   152,   154,   156,
     157,   159,   160,   161,   162,   163,   164,   179,   224,   240,
     241,   243,   248,   251,   252,   255,   257,   261,   262,   265,
     266,   267,   268,   269,   271,   272,   274,   286,   287,   289,
     290,   291,   292,   294,   295,   296,   297,   298,   299,   300,
     301,   302,   303,   304,   305,   308,   311,   313,   314,   316,
     317,   318,   319,   320,   321,   322,   347,   348,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   376,
     377,   378,   379,   380,   381,   382,   383,   384,   385,   386,
     387,   388,   389,   390,   391,   392,   393,   394,   395,   396,
     397,   398,   399,   400,   401,   402,   403,   404,   405,   406,
     407,   408,   409,   410,   336,   336,   336,   336,   336,    13,
      13,    13,    13,    13,    13,    13,    13,    13,    13,    13,
      13,    13,    13,    13,   338,    13,    13,    13,    13,    13,
      13,    13,    13,    13,    13,    13,    13,    13,    13,    13,
      13,    13,    13,    13,    13,    13,    13,    13,    13,    13,
      13,    13,    13,    13,    13,    13,    13,    13,    15,    16,
      17,    18,    19,    20,    22,    23,    24,    25,    26,    27,
      28,    29,    31,    32,    33,    34,    35,    36,     3,    21,
     224,     3,   224,     3,     9,    50,    51,    52,    53,    54,
      55,    56,   184,   188,   332,   336,   412,   413,   417,   418,
     419,   420,   421,   422,   423,   426,   427,   428,    60,    61,
     412,   413,   412,   413,   325,   336,    11,    30,    52,    64,
      65,    66,   333,   334,   336,   424,   425,   412,   413,   184,
     417,    58,    59,    60,    61,   184,   188,   417,   426,   430,
     431,   432,   426,   430,    60,   333,   424,   333,   424,     9,
     417,     9,   374,   375,   411,   417,     9,   417,     9,    60,
      61,   374,   375,   411,   427,   428,   432,   433,   434,   435,
     412,   413,    57,   429,   431,   429,   325,    30,   424,   426,
     426,   426,   426,   332,   412,   413,   325,   426,   426,   426,
     332,   412,   413,   426,   412,   413,   256,   339,   132,   133,
     164,   270,   234,   246,   342,   343,   246,   326,   327,   336,
     337,   342,   246,   330,   331,   337,   342,   113,   339,   246,
     328,   329,   334,   337,   342,   241,   243,   245,   252,   309,
     310,   343,   343,   343,   135,   163,   349,   224,   258,   246,
     323,   324,   337,   342,   323,   306,   224,   263,   349,   244,
     339,   349,   224,   273,   340,   270,   343,   242,   249,    39,
      40,    41,    42,    43,    44,    45,    46,    47,    48,    49,
      97,   129,   130,   153,   158,   254,    39,   129,   130,   254,
       8,    14,   246,   340,   340,   340,   340,   246,   342,   336,
     343,   340,   343,   343,   343,   343,   343,   340,    13,   340,
     340,   340,   340,   336,   343,   336,   340,   336,   340,   343,
     315,   340,   340,   340,     9,    57,    58,    59,    60,    61,
     213,   214,   215,   216,   217,   218,   219,   220,   343,   350,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   434,
     435,   343,   350,   343,    14,   343,   344,   343,   343,   343,
     343,   345,   343,   343,   343,   343,   343,   343,   343,   343,
     343,   340,   336,   336,   336,   336,   336,   336,   336,   336,
     336,   336,   336,   336,   336,   336,   336,   336,   336,   336,
     336,   336,   336,   343,   278,   284,   279,    60,    13,    13,
       6,     6,     6,     6,   335,   424,     6,    13,    13,    13,
       6,     6,    60,     6,   188,   333,   336,   419,     6,     6,
       6,     6,    60,     6,    58,    59,    60,    62,    63,     6,
       6,     6,     6,     6,     6,     6,     6,     6,     6,     6,
       6,     6,     6,     6,   336,     6,     6,   253,     6,   253,
       9,     6,     6,   253,     6,   253,     6,   234,   343,     6,
     222,   259,   260,     6,   253,   253,   245,   307,   259,   264,
     343,   224,   343,   340,   224,   250,   340,   288,   339,   340,
     343,   288,   288,   340,   340,   340,   343,   340,   353,    14,
       6,   341,   341,   341,     6,    14,    14,    14,    14,   341,
       6,    14,    14,     6,     6,   341,   246,     6,   341,     6,
       6,    14,    14,    14,     6,    14,     6,     6,    14,     6,
      14,   341,   341,    58,    59,    60,    14,    14,    14,    14,
      14,    14,     6,     6,    14,     6,     6,     6,   346,    14,
       6,    14,    14,     6,     6,     6,     6,     6,    14,   341,
      14,     6,     3,   234,    10,    57,    58,    59,    60,    58,
      59,    60,   332,   426,   430,   332,   426,   229,   333,   333,
     333,    10,     9,    13,    10,    15,    10,   417,   417,   417,
     374,   375,   411,    10,     9,    10,    10,    15,    16,    10,
      10,    61,   333,   431,    60,   333,   432,   417,   417,    61,
     417,   332,   426,   332,   374,   375,   411,   426,   433,   333,
     431,   417,   426,   426,   340,     6,   315,   327,   331,   256,
     293,   332,   329,   310,   339,     6,   224,   260,   324,     6,
     253,     6,     6,     6,   222,   340,    14,    14,    14,   340,
      14,   343,   340,   340,    14,    14,   340,    14,   340,   340,
     340,   340,   339,   340,    14,    14,    10,    10,    10,   340,
     343,   340,   343,   343,     6,   343,   343,   343,   343,   340,
     340,    14,   280,   340,   285,    14,    14,    14,    14,    14,
      14,    14,    12,     6,    60,   419,     6,    60,    10,    10,
      15,    16,   414,   343,     6,   253,    10,     6,   253,     6,
     350,   245,   350,   350,   343,   341,    14,    14,    14,   341,
     341,   341,   341,   341,    14,    14,    14,    14,    14,   246,
     337,   342,    14,    14,    14,     6,     6,    14,     6,    14,
       3,     6,   234,   417,    10,    10,   417,    10,   336,   336,
       6,   253,   332,   339,     9,   351,   351,   351,    14,    14,
      14,    14,    14,    14,   343,   340,   339,   279,   340,   293,
     339,   352,   352,   352,    14,    14,    14,   234,     6,   253,
      10,     6,   340,   113,   169,     9,     9,   256,   339,    10,
      10
  };

  const short
  parser::yyr1_[] =
  {
       0,   228,   229,   230,   230,   231,   230,   232,   232,   232,
     233,   233,   234,   234,   234,   235,   235,   235,   235,   235,
     235,   235,   235,   236,   237,   238,   239,   239,   239,   239,
     240,   242,   241,   244,   243,   245,   245,   245,   246,   246,
     247,   247,   247,   247,   247,   247,   247,   249,   248,   250,
     250,   251,   251,   251,   251,   251,   251,   251,   251,   251,
     251,   251,   251,   251,   251,   251,   251,   251,   251,   251,
     251,   251,   251,   251,   251,   251,   251,   251,   251,   251,
     251,   251,   251,   251,   251,   251,   251,   251,   251,   251,
     252,   252,   252,   252,   252,   252,   253,   253,   254,   254,
     254,   254,   254,   254,   254,   254,   254,   254,   255,   256,
     256,   258,   257,   259,   259,   260,   261,   263,   262,   264,
     264,   265,   266,   267,   268,   269,   270,   270,   270,   270,
     271,   271,   271,   271,   272,   273,   273,   274,   274,   275,
     277,   278,   276,   279,   280,   280,   280,   281,   283,   284,
     282,   285,   286,   287,   288,   288,   289,   290,   291,   292,
     292,   292,   292,   293,   293,   294,   294,   295,   295,   296,
     296,   297,   298,   299,   299,   299,   299,   300,   301,   302,
     303,   304,   306,   305,   307,   307,   308,   309,   309,   310,
     311,   312,   313,   313,   313,   314,   315,   315,   316,   316,
     317,   318,   319,   320,   321,   322,   322,   323,   323,   324,
     324,   324,   325,   326,   326,   327,   327,   327,   328,   328,
     329,   329,   329,   329,   330,   330,   331,   331,   331,   332,
     333,   333,   334,   335,   336,   336,   336,   337,   337,   337,
     337,   337,   337,   337,   337,   337,   337,   337,   337,   337,
     337,   337,   337,   337,   337,   337,   337,   337,   337,   337,
     337,   337,   337,   337,   337,   337,   337,   337,   337,   337,
     337,   337,   337,   337,   337,   337,   338,   337,   337,   337,
     337,   337,   337,   337,   337,   337,   337,   337,   337,   337,
     337,   337,   337,   337,   337,   337,   337,   337,   337,   337,
     337,   337,   337,   337,   337,   337,   337,   339,   340,   341,
     341,   342,   342,   342,   342,   342,   342,   342,   342,   342,
     342,   342,   342,   342,   342,   342,   342,   342,   342,   343,
     343,   344,   344,   345,   345,   346,   346,   346,   346,   347,
     348,   349,   349,   349,   350,   350,   350,   350,   350,   350,
     350,   350,   351,   351,   352,   352,   352,   353,   353,   354,
     354,   354,   354,   354,   354,   354,   354,   354,   354,   354,
     354,   354,   354,   354,   354,   354,   354,   354,   354,   354,
     354,   354,   354,   354,   354,   354,   354,   354,   354,   354,
     354,   354,   354,   354,   354,   354,   354,   354,   354,   354,
     354,   354,   354,   354,   354,   355,   355,   356,   356,   356,
     356,   357,   357,   358,   359,   359,   360,   361,   361,   362,
     362,   363,   364,   364,   365,   366,   367,   368,   368,   369,
     369,   369,   370,   370,   371,   371,   372,   372,   373,   373,
     373,   373,   373,   373,   374,   375,   376,   376,   376,   376,
     376,   376,   376,   376,   377,   377,   377,   378,   378,   378,
     379,   379,   380,   380,   381,   382,   382,   383,   383,   383,
     383,   383,   383,   384,   384,   385,   386,   386,   387,   388,
     389,   390,   390,   391,   392,   393,   394,   395,   396,   397,
     398,   399,   400,   401,   401,   402,   403,   404,   405,   406,
     407,   407,   408,   408,   409,   410,   410,   411,   412,   412,
     413,   413,   414,   414,   414,   415,   415,   415,   415,   415,
     415,   415,   415,   415,   415,   415,   415,   416,   416,   416,
     416,   416,   417,   417,   418,   418,   419,   419,   420,   420,
     421,   421,   422,   422,   423,   423,   424,   424,   425,   425,
     425,   425,   426,   426,   427,   427,   427,   427,   427,   427,
     427,   428,   429,   429,   430,   430,   431,   431,   432,   432,
     433,   433,   433,   433,   434,   434,   435,   435
  };

  const signed char
  parser::yyr2_[] =
  {
       0,     2,     1,     0,     3,     0,     3,     0,     1,     1,
       2,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     3,     3,     2,     1,     2,     2,     2,
       1,     0,     3,     0,     3,     1,     1,     1,     1,     1,
       0,     2,     2,     1,     2,     2,     1,     0,     3,     0,
       2,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     0,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     2,     1,
       3,     0,     3,     1,     2,     1,     1,     0,     3,     0,
       1,     1,     1,     1,     2,     2,     0,     2,     2,     2,
       3,     5,     3,     5,     2,     0,     1,     7,     1,     5,
       0,     0,     9,     0,     1,     3,     5,     3,     0,     0,
       7,     0,     2,     1,     0,     1,     1,     1,     1,     2,
       5,     6,     8,     1,     3,     1,     3,     1,     3,     1,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     0,     4,     1,     3,     3,     1,     3,     1,
       2,     4,     2,     4,     6,     5,     1,     3,     2,     4,
       2,     1,     2,     1,     3,     1,     3,     1,     3,     1,
       1,     1,     1,     1,     3,     1,     1,     1,     1,     3,
       1,     1,     1,     1,     1,     3,     1,     1,     1,     1,
       1,     1,     4,     0,     1,     1,     1,     1,     1,     2,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       2,     2,     2,     4,     4,     4,     4,     4,     4,     4,
       4,     4,     4,     4,     4,     4,     0,     5,     5,     5,
       5,     7,     7,     7,     7,     7,     5,     5,     5,     5,
       5,     5,     7,     6,     6,     6,     6,     6,     4,     4,
       4,     4,     6,     4,     6,     6,     3,     1,     1,     0,
       2,     1,     3,     4,     6,     8,     6,     8,     6,     6,
       6,     4,     3,     4,     4,     4,     8,     4,     4,     1,
       1,     1,     3,     0,     2,     0,     3,     3,     3,     7,
       7,     0,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     0,     3,     0,     6,     6,     1,     3,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     2,     2,     2,     2,     4,
       4,     2,     2,     4,     2,     4,     1,     2,     2,     1,
       2,     1,     2,     2,     1,     1,     1,     2,     2,     2,
       4,     2,     2,     4,     6,     6,     6,     6,     4,     4,
       4,     4,     4,     4,     3,     5,     1,     1,     1,     1,
       1,     1,     1,     1,     5,     4,     4,     4,     4,     4,
       4,     4,     4,     4,     4,     4,     4,     4,     4,     4,
       4,     4,     4,     4,     4,     1,     2,     2,     2,     2,
       4,     1,     2,     1,     2,     1,     2,     1,     2,     1,
       2,     1,     2,     2,     2,     1,     4,     2,     2,     2,
       1,     2,     2,     2,     2,     2,     2,     3,     1,     3,
       1,     3,     2,     2,     0,     1,     1,     1,     1,     1,
       1,     1,     3,     3,     3,     1,     1,     1,     1,     1,
       1,     1,     1,     4,     1,     4,     1,     4,     1,     4,
       1,     4,     1,     4,     1,     4,     1,     2,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       3,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       3,     3,     1,     1,     3,     4,     3,     4
  };




#if YYDEBUG
  const short
  parser::yyrline_[] =
  {
       0,   413,   413,   416,   417,   419,   419,   428,   429,   434,
     444,   445,   448,   448,   448,   455,   456,   457,   458,   459,
     460,   462,   463,   467,   479,   497,   516,   517,   518,   519,
     523,   529,   529,   538,   538,   546,   546,   546,   548,   548,
     551,   552,   555,   559,   562,   565,   569,   575,   575,   584,
     587,   594,   595,   596,   597,   598,   599,   600,   601,   602,
     603,   604,   605,   606,   607,   608,   609,   610,   611,   612,
     613,   614,   615,   616,   617,   618,   619,   620,   621,   622,
     623,   624,   625,   626,   627,   628,   629,   630,   631,   632,
     636,   637,   638,   639,   640,   641,   644,   644,   647,   650,
     653,   656,   659,   662,   665,   668,   671,   674,   680,   686,
     695,   714,   714,   721,   722,   726,   732,   738,   738,   746,
     749,   753,   759,   765,   771,   777,   783,   786,   789,   792,
     798,   805,   812,   817,   825,   835,   838,   842,   845,   851,
     859,   861,   859,   871,   877,   882,   887,   895,   903,   905,
     903,   915,   921,   927,   933,   936,   940,   946,   952,   958,
     961,   964,   970,   979,   982,   989,   992,   996,   999,  1003,
    1006,  1010,  1017,  1024,  1028,  1032,  1036,  1043,  1052,  1061,
    1070,  1077,  1084,  1084,  1095,  1098,  1104,  1107,  1108,  1112,
    1118,  1124,  1132,  1137,  1142,  1150,  1156,  1159,  1166,  1169,
    1175,  1181,  1187,  1194,  1199,  1202,  1206,  1213,  1214,  1218,
    1221,  1225,  1235,  1242,  1243,  1247,  1251,  1255,  1271,  1272,
    1276,  1280,  1284,  1297,  1306,  1307,  1311,  1314,  1318,  1331,
    1338,  1342,  1348,  1355,  1362,  1365,  1369,  1384,  1387,  1396,
    1399,  1402,  1405,  1408,  1411,  1414,  1417,  1420,  1423,  1426,
    1429,  1432,  1435,  1438,  1441,  1444,  1447,  1450,  1453,  1456,
    1459,  1462,  1465,  1468,  1471,  1474,  1477,  1480,  1483,  1487,
    1490,  1493,  1496,  1499,  1502,  1505,  1508,  1508,  1514,  1517,
    1520,  1523,  1526,  1529,  1532,  1535,  1538,  1541,  1544,  1547,
    1550,  1553,  1556,  1559,  1562,  1566,  1570,  1574,  1578,  1581,
    1584,  1587,  1590,  1593,  1600,  1618,  1632,  1638,  1647,  1653,
    1656,  1666,  1669,  1673,  1680,  1687,  1693,  1698,  1703,  1708,
    1713,  1718,  1727,  1730,  1733,  1737,  1741,  1744,  1747,  1769,
    1772,  1782,  1785,  1792,  1793,  1800,  1801,  1805,  1809,  1822,
    1828,  1835,  1838,  1841,  1847,  1850,  1853,  1856,  1859,  1862,
    1865,  1868,  1874,  1877,  1887,  1892,  1897,  1906,  1907,  1911,
    1912,  1913,  1914,  1915,  1916,  1917,  1918,  1919,  1920,  1921,
    1922,  1923,  1924,  1925,  1926,  1927,  1928,  1929,  1930,  1931,
    1932,  1933,  1934,  1935,  1936,  1937,  1938,  1939,  1940,  1941,
    1942,  1943,  1944,  1945,  1946,  1947,  1948,  1949,  1950,  1951,
    1952,  1953,  1954,  1955,  1956,  1960,  1964,  1970,  1974,  1977,
    1980,  1987,  1991,  1997,  2010,  2014,  2021,  2027,  2031,  2037,
    2040,  2046,  2052,  2055,  2061,  2067,  2073,  2079,  2082,  2088,
    2092,  2096,  2102,  2106,  2113,  2116,  2122,  2125,  2131,  2142,
    2153,  2156,  2159,  2162,  2167,  2170,  2179,  2180,  2181,  2182,
    2183,  2184,  2185,  2186,  2190,  2194,  2198,  2209,  2212,  2215,
    2222,  2226,  2233,  2236,  2243,  2249,  2253,  2263,  2267,  2270,
    2273,  2277,  2280,  2287,  2291,  2307,  2313,  2317,  2323,  2329,
    2335,  2348,  2351,  2357,  2363,  2370,  2376,  2383,  2389,  2396,
    2402,  2409,  2415,  2426,  2430,  2436,  2442,  2455,  2462,  2469,
    2476,  2480,  2487,  2491,  2497,  2504,  2508,  2516,  2522,  2523,
    2529,  2532,  2538,  2542,  2546,  2554,  2555,  2556,  2557,  2558,
    2559,  2560,  2561,  2562,  2563,  2564,  2565,  2569,  2570,  2571,
    2572,  2573,  2577,  2578,  2582,  2583,  2587,  2588,  2592,  2593,
    2597,  2598,  2602,  2603,  2607,  2608,  2612,  2613,  2619,  2622,
    2625,  2628,  2633,  2633,  2636,  2639,  2642,  2645,  2648,  2651,
    2654,  2660,  2666,  2667,  2673,  2674,  2680,  2681,  2687,  2690,
    2696,  2699,  2702,  2705,  2711,  2712,  2716,  2717
  };

  void
  parser::yy_stack_print_ () const
  {
    *yycdebug_ << "Stack now";
    for (stack_type::const_iterator
           i = yystack_.begin (),
           i_end = yystack_.end ();
         i != i_end; ++i)
      *yycdebug_ << ' ' << int (i->state);
    *yycdebug_ << '\n';
  }

  void
  parser::yy_reduce_print_ (int yyrule) const
  {
    int yylno = yyrline_[yyrule];
    int yynrhs = yyr2_[yyrule];
    // Print the symbols being reduced, and their result.
    *yycdebug_ << "Reducing stack by rule " << yyrule - 1
               << " (line " << yylno << "):\n";
    // The symbols being reduced.
    for (int yyi = 0; yyi < yynrhs; yyi++)
      YY_SYMBOL_PRINT ("   $" << yyi + 1 << " =",
                       yystack_[(yynrhs) - (yyi + 1)]);
  }
#endif // YYDEBUG


} // yy
#line 6687 "/build/rgbds/src/rgbds/src/asm/parser.cpp"

#line 2720 "asm/parser.y"


/******************** Error handler ********************/

void yy::parser::error(std::string const &str) {
	::error("%s", str.c_str());
}
