// python wrapper for vtkOMETIFFChannelCalculator
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkOMETIFFChannelCalculator.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkOMETIFFChannelCalculator(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkOMETIFFChannelCalculator_ClassNew(); }


static PyObject *
PyvtkOMETIFFChannelCalculator_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkOMETIFFChannelCalculator::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkOMETIFFChannelCalculator_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkOMETIFFChannelCalculator *op = static_cast<vtkOMETIFFChannelCalculator *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkOMETIFFChannelCalculator::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkOMETIFFChannelCalculator_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkOMETIFFChannelCalculator *tempr = vtkOMETIFFChannelCalculator::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkOMETIFFChannelCalculator_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkOMETIFFChannelCalculator *op = static_cast<vtkOMETIFFChannelCalculator *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkOMETIFFChannelCalculator *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkOMETIFFChannelCalculator::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkOMETIFFChannelCalculator_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkOMETIFFChannelCalculator::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkOMETIFFChannelCalculator_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkOMETIFFChannelCalculator *op = static_cast<vtkOMETIFFChannelCalculator *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkOMETIFFChannelCalculator::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkOMETIFFChannelCalculator_GetChannelSelection(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetChannelSelection");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkOMETIFFChannelCalculator *op = static_cast<vtkOMETIFFChannelCalculator *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkDataArraySelection *tempr = (ap.IsBound() ?
      op->GetChannelSelection() :
      op->vtkOMETIFFChannelCalculator::GetChannelSelection());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkOMETIFFChannelCalculator_SetChannel1LUT(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetChannel1LUT");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkOMETIFFChannelCalculator *op = static_cast<vtkOMETIFFChannelCalculator *>(vp);

  vtkScalarsToColors *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkScalarsToColors"))
  {
    if (ap.IsBound())
    {
      op->SetChannel1LUT(temp0);
    }
    else
    {
      op->vtkOMETIFFChannelCalculator::SetChannel1LUT(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkOMETIFFChannelCalculator_SetChannel2LUT(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetChannel2LUT");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkOMETIFFChannelCalculator *op = static_cast<vtkOMETIFFChannelCalculator *>(vp);

  vtkScalarsToColors *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkScalarsToColors"))
  {
    if (ap.IsBound())
    {
      op->SetChannel2LUT(temp0);
    }
    else
    {
      op->vtkOMETIFFChannelCalculator::SetChannel2LUT(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkOMETIFFChannelCalculator_SetChannel3LUT(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetChannel3LUT");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkOMETIFFChannelCalculator *op = static_cast<vtkOMETIFFChannelCalculator *>(vp);

  vtkScalarsToColors *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkScalarsToColors"))
  {
    if (ap.IsBound())
    {
      op->SetChannel3LUT(temp0);
    }
    else
    {
      op->vtkOMETIFFChannelCalculator::SetChannel3LUT(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkOMETIFFChannelCalculator_SetChannel4LUT(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetChannel4LUT");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkOMETIFFChannelCalculator *op = static_cast<vtkOMETIFFChannelCalculator *>(vp);

  vtkScalarsToColors *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkScalarsToColors"))
  {
    if (ap.IsBound())
    {
      op->SetChannel4LUT(temp0);
    }
    else
    {
      op->vtkOMETIFFChannelCalculator::SetChannel4LUT(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkOMETIFFChannelCalculator_SetChannel5LUT(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetChannel5LUT");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkOMETIFFChannelCalculator *op = static_cast<vtkOMETIFFChannelCalculator *>(vp);

  vtkScalarsToColors *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkScalarsToColors"))
  {
    if (ap.IsBound())
    {
      op->SetChannel5LUT(temp0);
    }
    else
    {
      op->vtkOMETIFFChannelCalculator::SetChannel5LUT(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkOMETIFFChannelCalculator_SetChannel6LUT(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetChannel6LUT");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkOMETIFFChannelCalculator *op = static_cast<vtkOMETIFFChannelCalculator *>(vp);

  vtkScalarsToColors *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkScalarsToColors"))
  {
    if (ap.IsBound())
    {
      op->SetChannel6LUT(temp0);
    }
    else
    {
      op->vtkOMETIFFChannelCalculator::SetChannel6LUT(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkOMETIFFChannelCalculator_SetChannel7LUT(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetChannel7LUT");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkOMETIFFChannelCalculator *op = static_cast<vtkOMETIFFChannelCalculator *>(vp);

  vtkScalarsToColors *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkScalarsToColors"))
  {
    if (ap.IsBound())
    {
      op->SetChannel7LUT(temp0);
    }
    else
    {
      op->vtkOMETIFFChannelCalculator::SetChannel7LUT(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkOMETIFFChannelCalculator_SetChannel8LUT(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetChannel8LUT");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkOMETIFFChannelCalculator *op = static_cast<vtkOMETIFFChannelCalculator *>(vp);

  vtkScalarsToColors *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkScalarsToColors"))
  {
    if (ap.IsBound())
    {
      op->SetChannel8LUT(temp0);
    }
    else
    {
      op->vtkOMETIFFChannelCalculator::SetChannel8LUT(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkOMETIFFChannelCalculator_SetChannel9LUT(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetChannel9LUT");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkOMETIFFChannelCalculator *op = static_cast<vtkOMETIFFChannelCalculator *>(vp);

  vtkScalarsToColors *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkScalarsToColors"))
  {
    if (ap.IsBound())
    {
      op->SetChannel9LUT(temp0);
    }
    else
    {
      op->vtkOMETIFFChannelCalculator::SetChannel9LUT(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkOMETIFFChannelCalculator_SetChannel10LUT(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetChannel10LUT");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkOMETIFFChannelCalculator *op = static_cast<vtkOMETIFFChannelCalculator *>(vp);

  vtkScalarsToColors *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkScalarsToColors"))
  {
    if (ap.IsBound())
    {
      op->SetChannel10LUT(temp0);
    }
    else
    {
      op->vtkOMETIFFChannelCalculator::SetChannel10LUT(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkOMETIFFChannelCalculator_SetLUT(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetLUT");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkOMETIFFChannelCalculator *op = static_cast<vtkOMETIFFChannelCalculator *>(vp);

  const char *temp0 = nullptr;
  vtkScalarsToColors *temp1 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetVTKObject(temp1, "vtkScalarsToColors"))
  {
    if (ap.IsBound())
    {
      op->SetLUT(temp0, temp1);
    }
    else
    {
      op->vtkOMETIFFChannelCalculator::SetLUT(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkOMETIFFChannelCalculator_SetChannel1Weight(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetChannel1Weight");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkOMETIFFChannelCalculator *op = static_cast<vtkOMETIFFChannelCalculator *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetChannel1Weight(temp0);
    }
    else
    {
      op->vtkOMETIFFChannelCalculator::SetChannel1Weight(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkOMETIFFChannelCalculator_SetChannel2Weight(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetChannel2Weight");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkOMETIFFChannelCalculator *op = static_cast<vtkOMETIFFChannelCalculator *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetChannel2Weight(temp0);
    }
    else
    {
      op->vtkOMETIFFChannelCalculator::SetChannel2Weight(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkOMETIFFChannelCalculator_SetChannel3Weight(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetChannel3Weight");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkOMETIFFChannelCalculator *op = static_cast<vtkOMETIFFChannelCalculator *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetChannel3Weight(temp0);
    }
    else
    {
      op->vtkOMETIFFChannelCalculator::SetChannel3Weight(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkOMETIFFChannelCalculator_SetChannel4Weight(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetChannel4Weight");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkOMETIFFChannelCalculator *op = static_cast<vtkOMETIFFChannelCalculator *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetChannel4Weight(temp0);
    }
    else
    {
      op->vtkOMETIFFChannelCalculator::SetChannel4Weight(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkOMETIFFChannelCalculator_SetChannel5Weight(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetChannel5Weight");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkOMETIFFChannelCalculator *op = static_cast<vtkOMETIFFChannelCalculator *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetChannel5Weight(temp0);
    }
    else
    {
      op->vtkOMETIFFChannelCalculator::SetChannel5Weight(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkOMETIFFChannelCalculator_SetChannel6Weight(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetChannel6Weight");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkOMETIFFChannelCalculator *op = static_cast<vtkOMETIFFChannelCalculator *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetChannel6Weight(temp0);
    }
    else
    {
      op->vtkOMETIFFChannelCalculator::SetChannel6Weight(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkOMETIFFChannelCalculator_SetChannel7Weight(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetChannel7Weight");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkOMETIFFChannelCalculator *op = static_cast<vtkOMETIFFChannelCalculator *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetChannel7Weight(temp0);
    }
    else
    {
      op->vtkOMETIFFChannelCalculator::SetChannel7Weight(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkOMETIFFChannelCalculator_SetChannel8Weight(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetChannel8Weight");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkOMETIFFChannelCalculator *op = static_cast<vtkOMETIFFChannelCalculator *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetChannel8Weight(temp0);
    }
    else
    {
      op->vtkOMETIFFChannelCalculator::SetChannel8Weight(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkOMETIFFChannelCalculator_SetChannel9Weight(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetChannel9Weight");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkOMETIFFChannelCalculator *op = static_cast<vtkOMETIFFChannelCalculator *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetChannel9Weight(temp0);
    }
    else
    {
      op->vtkOMETIFFChannelCalculator::SetChannel9Weight(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkOMETIFFChannelCalculator_SetChannel10Weight(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetChannel10Weight");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkOMETIFFChannelCalculator *op = static_cast<vtkOMETIFFChannelCalculator *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetChannel10Weight(temp0);
    }
    else
    {
      op->vtkOMETIFFChannelCalculator::SetChannel10Weight(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkOMETIFFChannelCalculator_SetWeight(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetWeight");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkOMETIFFChannelCalculator *op = static_cast<vtkOMETIFFChannelCalculator *>(vp);

  const char *temp0 = nullptr;
  double temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->SetWeight(temp0, temp1);
    }
    else
    {
      op->vtkOMETIFFChannelCalculator::SetWeight(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkOMETIFFChannelCalculator_GetMTime(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetMTime");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkOMETIFFChannelCalculator *op = static_cast<vtkOMETIFFChannelCalculator *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    unsigned long tempr = (ap.IsBound() ?
      op->GetMTime() :
      op->vtkOMETIFFChannelCalculator::GetMTime());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyMethodDef PyvtkOMETIFFChannelCalculator_Methods[] = {
  {"IsTypeOf", PyvtkOMETIFFChannelCalculator_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkOMETIFFChannelCalculator_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkOMETIFFChannelCalculator_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkOMETIFFChannelCalculator\nC++: static vtkOMETIFFChannelCalculator *SafeDownCast(\n    vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkOMETIFFChannelCalculator_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkOMETIFFChannelCalculator\nC++: vtkOMETIFFChannelCalculator *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkOMETIFFChannelCalculator_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkOMETIFFChannelCalculator_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetChannelSelection", PyvtkOMETIFFChannelCalculator_GetChannelSelection, METH_VARARGS,
   "GetChannelSelection(self) -> vtkDataArraySelection\nC++: virtual vtkDataArraySelection *GetChannelSelection()\n\nChoose the channels to combine in this calculator.\n"},
  {"SetChannel1LUT", PyvtkOMETIFFChannelCalculator_SetChannel1LUT, METH_VARARGS,
   "SetChannel1LUT(self, stc:vtkScalarsToColors) -> None\nC++: void SetChannel1LUT(vtkScalarsToColors *stc)\n\nSet the transfer functions to use to map scalars to colors.\n"},
  {"SetChannel2LUT", PyvtkOMETIFFChannelCalculator_SetChannel2LUT, METH_VARARGS,
   "SetChannel2LUT(self, stc:vtkScalarsToColors) -> None\nC++: void SetChannel2LUT(vtkScalarsToColors *stc)\n\n"},
  {"SetChannel3LUT", PyvtkOMETIFFChannelCalculator_SetChannel3LUT, METH_VARARGS,
   "SetChannel3LUT(self, stc:vtkScalarsToColors) -> None\nC++: void SetChannel3LUT(vtkScalarsToColors *stc)\n\n"},
  {"SetChannel4LUT", PyvtkOMETIFFChannelCalculator_SetChannel4LUT, METH_VARARGS,
   "SetChannel4LUT(self, stc:vtkScalarsToColors) -> None\nC++: void SetChannel4LUT(vtkScalarsToColors *stc)\n\n"},
  {"SetChannel5LUT", PyvtkOMETIFFChannelCalculator_SetChannel5LUT, METH_VARARGS,
   "SetChannel5LUT(self, stc:vtkScalarsToColors) -> None\nC++: void SetChannel5LUT(vtkScalarsToColors *stc)\n\n"},
  {"SetChannel6LUT", PyvtkOMETIFFChannelCalculator_SetChannel6LUT, METH_VARARGS,
   "SetChannel6LUT(self, stc:vtkScalarsToColors) -> None\nC++: void SetChannel6LUT(vtkScalarsToColors *stc)\n\n"},
  {"SetChannel7LUT", PyvtkOMETIFFChannelCalculator_SetChannel7LUT, METH_VARARGS,
   "SetChannel7LUT(self, stc:vtkScalarsToColors) -> None\nC++: void SetChannel7LUT(vtkScalarsToColors *stc)\n\n"},
  {"SetChannel8LUT", PyvtkOMETIFFChannelCalculator_SetChannel8LUT, METH_VARARGS,
   "SetChannel8LUT(self, stc:vtkScalarsToColors) -> None\nC++: void SetChannel8LUT(vtkScalarsToColors *stc)\n\n"},
  {"SetChannel9LUT", PyvtkOMETIFFChannelCalculator_SetChannel9LUT, METH_VARARGS,
   "SetChannel9LUT(self, stc:vtkScalarsToColors) -> None\nC++: void SetChannel9LUT(vtkScalarsToColors *stc)\n\n"},
  {"SetChannel10LUT", PyvtkOMETIFFChannelCalculator_SetChannel10LUT, METH_VARARGS,
   "SetChannel10LUT(self, stc:vtkScalarsToColors) -> None\nC++: void SetChannel10LUT(vtkScalarsToColors *stc)\n\n"},
  {"SetLUT", PyvtkOMETIFFChannelCalculator_SetLUT, METH_VARARGS,
   "SetLUT(self, channelName:str, __b:vtkScalarsToColors) -> None\nC++: void SetLUT(const char *channelName, vtkScalarsToColors *)\n\n"},
  {"SetChannel1Weight", PyvtkOMETIFFChannelCalculator_SetChannel1Weight, METH_VARARGS,
   "SetChannel1Weight(self, wght:float) -> None\nC++: void SetChannel1Weight(double wght)\n\nSet weights for each of the channels.\n"},
  {"SetChannel2Weight", PyvtkOMETIFFChannelCalculator_SetChannel2Weight, METH_VARARGS,
   "SetChannel2Weight(self, wght:float) -> None\nC++: void SetChannel2Weight(double wght)\n\n"},
  {"SetChannel3Weight", PyvtkOMETIFFChannelCalculator_SetChannel3Weight, METH_VARARGS,
   "SetChannel3Weight(self, wght:float) -> None\nC++: void SetChannel3Weight(double wght)\n\n"},
  {"SetChannel4Weight", PyvtkOMETIFFChannelCalculator_SetChannel4Weight, METH_VARARGS,
   "SetChannel4Weight(self, wght:float) -> None\nC++: void SetChannel4Weight(double wght)\n\n"},
  {"SetChannel5Weight", PyvtkOMETIFFChannelCalculator_SetChannel5Weight, METH_VARARGS,
   "SetChannel5Weight(self, wght:float) -> None\nC++: void SetChannel5Weight(double wght)\n\n"},
  {"SetChannel6Weight", PyvtkOMETIFFChannelCalculator_SetChannel6Weight, METH_VARARGS,
   "SetChannel6Weight(self, wght:float) -> None\nC++: void SetChannel6Weight(double wght)\n\n"},
  {"SetChannel7Weight", PyvtkOMETIFFChannelCalculator_SetChannel7Weight, METH_VARARGS,
   "SetChannel7Weight(self, wght:float) -> None\nC++: void SetChannel7Weight(double wght)\n\n"},
  {"SetChannel8Weight", PyvtkOMETIFFChannelCalculator_SetChannel8Weight, METH_VARARGS,
   "SetChannel8Weight(self, wght:float) -> None\nC++: void SetChannel8Weight(double wght)\n\n"},
  {"SetChannel9Weight", PyvtkOMETIFFChannelCalculator_SetChannel9Weight, METH_VARARGS,
   "SetChannel9Weight(self, wght:float) -> None\nC++: void SetChannel9Weight(double wght)\n\n"},
  {"SetChannel10Weight", PyvtkOMETIFFChannelCalculator_SetChannel10Weight, METH_VARARGS,
   "SetChannel10Weight(self, wght:float) -> None\nC++: void SetChannel10Weight(double wght)\n\n"},
  {"SetWeight", PyvtkOMETIFFChannelCalculator_SetWeight, METH_VARARGS,
   "SetWeight(self, channelName:str, weight:float) -> None\nC++: void SetWeight(const char *channelName, double weight)\n\n"},
  {"GetMTime", PyvtkOMETIFFChannelCalculator_GetMTime, METH_VARARGS,
   "GetMTime(self) -> int\nC++: vtkMTimeType GetMTime() override;\n\nReturn this object's modified time.\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkOMETIFFChannelCalculator_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("channel1lut"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkOMETIFFChannelCalculator_SetChannel1LUT(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkOMETIFFChannelCalculator_SetChannel1LUT(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetChannel1LUT\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("channel2lut"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkOMETIFFChannelCalculator_SetChannel2LUT(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkOMETIFFChannelCalculator_SetChannel2LUT(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetChannel2LUT\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("channel3lut"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkOMETIFFChannelCalculator_SetChannel3LUT(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkOMETIFFChannelCalculator_SetChannel3LUT(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetChannel3LUT\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("channel4lut"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkOMETIFFChannelCalculator_SetChannel4LUT(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkOMETIFFChannelCalculator_SetChannel4LUT(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetChannel4LUT\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("channel5lut"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkOMETIFFChannelCalculator_SetChannel5LUT(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkOMETIFFChannelCalculator_SetChannel5LUT(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetChannel5LUT\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("channel6lut"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkOMETIFFChannelCalculator_SetChannel6LUT(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkOMETIFFChannelCalculator_SetChannel6LUT(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetChannel6LUT\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("channel7lut"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkOMETIFFChannelCalculator_SetChannel7LUT(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkOMETIFFChannelCalculator_SetChannel7LUT(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetChannel7LUT\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("channel8lut"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkOMETIFFChannelCalculator_SetChannel8LUT(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkOMETIFFChannelCalculator_SetChannel8LUT(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetChannel8LUT\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("channel9lut"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkOMETIFFChannelCalculator_SetChannel9LUT(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkOMETIFFChannelCalculator_SetChannel9LUT(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetChannel9LUT\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("channel10lut"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkOMETIFFChannelCalculator_SetChannel10LUT(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkOMETIFFChannelCalculator_SetChannel10LUT(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetChannel10LUT\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("channel1_weight"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkOMETIFFChannelCalculator_SetChannel1Weight(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkOMETIFFChannelCalculator_SetChannel1Weight(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetChannel1Weight\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("channel2_weight"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkOMETIFFChannelCalculator_SetChannel2Weight(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkOMETIFFChannelCalculator_SetChannel2Weight(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetChannel2Weight\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("channel3_weight"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkOMETIFFChannelCalculator_SetChannel3Weight(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkOMETIFFChannelCalculator_SetChannel3Weight(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetChannel3Weight\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("channel4_weight"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkOMETIFFChannelCalculator_SetChannel4Weight(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkOMETIFFChannelCalculator_SetChannel4Weight(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetChannel4Weight\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("channel5_weight"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkOMETIFFChannelCalculator_SetChannel5Weight(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkOMETIFFChannelCalculator_SetChannel5Weight(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetChannel5Weight\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("channel6_weight"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkOMETIFFChannelCalculator_SetChannel6Weight(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkOMETIFFChannelCalculator_SetChannel6Weight(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetChannel6Weight\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("channel7_weight"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkOMETIFFChannelCalculator_SetChannel7Weight(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkOMETIFFChannelCalculator_SetChannel7Weight(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetChannel7Weight\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("channel8_weight"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkOMETIFFChannelCalculator_SetChannel8Weight(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkOMETIFFChannelCalculator_SetChannel8Weight(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetChannel8Weight\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("channel9_weight"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkOMETIFFChannelCalculator_SetChannel9Weight(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkOMETIFFChannelCalculator_SetChannel9Weight(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetChannel9Weight\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("channel10_weight"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkOMETIFFChannelCalculator_SetChannel10Weight(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkOMETIFFChannelCalculator_SetChannel10Weight(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetChannel10Weight\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("channel_selection"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkOMETIFFChannelCalculator_GetChannelSelection(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetChannelSelection\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("m_time"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkOMETIFFChannelCalculator_GetMTime(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetMTime\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkOMETIFFChannelCalculator_Doc =
  "vtkOMETIFFChannelCalculator - filter to combine multiple channels\ninto colors\n\n"
  "Superclass: vtkPassInputTypeAlgorithm\n\n"
  "vtkOMETIFFChannelCalculator is designed to combine multiple channels,\n"
  "typically from an OME-TIFF file, to generate RGBA colors. Up to 10\n"
  "channels are supported. One must specify a `vtkScalarsToColors`\n"
  "object to use to map the channel scalars to colors for each enabled\n"
  "channel.\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkOMETIFFChannelCalculator_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkPVVTKExtensionsFiltersGeneral.vtkOMETIFFChannelCalculator", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkOMETIFFChannelCalculator_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkOMETIFFChannelCalculator_StaticNew()
{
  return vtkOMETIFFChannelCalculator::New();
}

PyObject *PyvtkOMETIFFChannelCalculator_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkOMETIFFChannelCalculator_Type, PyvtkOMETIFFChannelCalculator_Methods,
    "vtkOMETIFFChannelCalculator",
 &PyvtkOMETIFFChannelCalculator_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("vtkPassInputTypeAlgorithm");

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkOMETIFFChannelCalculator_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkOMETIFFChannelCalculator(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkOMETIFFChannelCalculator_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkOMETIFFChannelCalculator", o) != 0)
  {
    Py_DECREF(o);
  }

}

