/* TextRenderer.c generated by valac 0.56.18, the Vala compiler
 * generated from TextRenderer.vala, do not modify */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <glib.h>
#include <gdk/gdk.h>
#include "pantheon-files-core.h"
#include <pango/pango.h>
#include <cairo-gobject.h>
#include <stdlib.h>
#include <string.h>
#include <granite.h>
#include <float.h>
#include <math.h>

#define FILES_TEXT_RENDERER_MAX_LINES 5
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define FILES_TYPE_TEXT_RENDERER (files_text_renderer_get_type ())
#define FILES_TEXT_RENDERER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FILES_TYPE_TEXT_RENDERER, FilesTextRenderer))
#define FILES_TEXT_RENDERER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FILES_TYPE_TEXT_RENDERER, FilesTextRendererClass))
#define FILES_IS_TEXT_RENDERER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FILES_TYPE_TEXT_RENDERER))
#define FILES_IS_TEXT_RENDERER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FILES_TYPE_TEXT_RENDERER))
#define FILES_TEXT_RENDERER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FILES_TYPE_TEXT_RENDERER, FilesTextRendererClass))

typedef struct _FilesTextRenderer FilesTextRenderer;
typedef struct _FilesTextRendererClass FilesTextRendererClass;
typedef struct _FilesTextRendererPrivate FilesTextRendererPrivate;

#define FILES_TYPE_ABSTRACT_EDITABLE_LABEL (files_abstract_editable_label_get_type ())
#define FILES_ABSTRACT_EDITABLE_LABEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FILES_TYPE_ABSTRACT_EDITABLE_LABEL, FilesAbstractEditableLabel))
#define FILES_ABSTRACT_EDITABLE_LABEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FILES_TYPE_ABSTRACT_EDITABLE_LABEL, FilesAbstractEditableLabelClass))
#define FILES_IS_ABSTRACT_EDITABLE_LABEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FILES_TYPE_ABSTRACT_EDITABLE_LABEL))
#define FILES_IS_ABSTRACT_EDITABLE_LABEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FILES_TYPE_ABSTRACT_EDITABLE_LABEL))
#define FILES_ABSTRACT_EDITABLE_LABEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FILES_TYPE_ABSTRACT_EDITABLE_LABEL, FilesAbstractEditableLabelClass))

typedef struct _FilesAbstractEditableLabel FilesAbstractEditableLabel;
typedef struct _FilesAbstractEditableLabelClass FilesAbstractEditableLabelClass;
enum  {
	FILES_TEXT_RENDERER_0_PROPERTY,
	FILES_TEXT_RENDERER_DOUBLE_BORDER_RADIUS_PROPERTY,
	FILES_TEXT_RENDERER_ZOOM_LEVEL_PROPERTY,
	FILES_TEXT_RENDERER_FILE_PROPERTY,
	FILES_TEXT_RENDERER_ITEM_WIDTH_PROPERTY,
	FILES_TEXT_RENDERER_NUM_PROPERTIES
};
static GParamSpec* files_text_renderer_properties[FILES_TEXT_RENDERER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define FILES_TYPE_MULTI_LINE_EDITABLE_LABEL (files_multi_line_editable_label_get_type ())
#define FILES_MULTI_LINE_EDITABLE_LABEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FILES_TYPE_MULTI_LINE_EDITABLE_LABEL, FilesMultiLineEditableLabel))
#define FILES_MULTI_LINE_EDITABLE_LABEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FILES_TYPE_MULTI_LINE_EDITABLE_LABEL, FilesMultiLineEditableLabelClass))
#define FILES_IS_MULTI_LINE_EDITABLE_LABEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FILES_TYPE_MULTI_LINE_EDITABLE_LABEL))
#define FILES_IS_MULTI_LINE_EDITABLE_LABEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FILES_TYPE_MULTI_LINE_EDITABLE_LABEL))
#define FILES_MULTI_LINE_EDITABLE_LABEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FILES_TYPE_MULTI_LINE_EDITABLE_LABEL, FilesMultiLineEditableLabelClass))

typedef struct _FilesMultiLineEditableLabel FilesMultiLineEditableLabel;
typedef struct _FilesMultiLineEditableLabelClass FilesMultiLineEditableLabelClass;

#define FILES_TYPE_SINGLE_LINE_EDITABLE_LABEL (files_single_line_editable_label_get_type ())
#define FILES_SINGLE_LINE_EDITABLE_LABEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FILES_TYPE_SINGLE_LINE_EDITABLE_LABEL, FilesSingleLineEditableLabel))
#define FILES_SINGLE_LINE_EDITABLE_LABEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FILES_TYPE_SINGLE_LINE_EDITABLE_LABEL, FilesSingleLineEditableLabelClass))
#define FILES_IS_SINGLE_LINE_EDITABLE_LABEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FILES_TYPE_SINGLE_LINE_EDITABLE_LABEL))
#define FILES_IS_SINGLE_LINE_EDITABLE_LABEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FILES_TYPE_SINGLE_LINE_EDITABLE_LABEL))
#define FILES_SINGLE_LINE_EDITABLE_LABEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FILES_TYPE_SINGLE_LINE_EDITABLE_LABEL, FilesSingleLineEditableLabelClass))

typedef struct _FilesSingleLineEditableLabel FilesSingleLineEditableLabel;
typedef struct _FilesSingleLineEditableLabelClass FilesSingleLineEditableLabelClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define __vala_GdkRGBA_free0(var) ((var == NULL) ? NULL : (var = (_vala_GdkRGBA_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _pango_font_metrics_unref0(var) ((var == NULL) ? NULL : (var = (pango_font_metrics_unref (var), NULL)))
#define __vala_PangoLanguage_free0(var) ((var == NULL) ? NULL : (var = (_vala_PangoLanguage_free (var), NULL)))
#define _pango_attr_list_unref0(var) ((var == NULL) ? NULL : (var = (pango_attr_list_unref (var), NULL)))

struct _FilesTextRenderer {
	GtkCellRendererText parent_instance;
	FilesTextRendererPrivate * priv;
	gint text_width;
	gint text_height;
	gint text_y_offset;
	gint text_x_offset;
};

struct _FilesTextRendererClass {
	GtkCellRendererTextClass parent_class;
};

struct _FilesTextRendererPrivate {
	gint _border_radius;
	gint _double_border_radius;
	GtkCssProvider* text_css;
	GdkRGBA previous_background_rgba;
	GdkRGBA previous_contrasting_rgba;
	FilesZoomLevel _zoom_level;
	FilesFile* _file;
	gint _item_width;
	gboolean is_list_view;
	gint char_height;
	PangoLayout* layout;
	GtkWidget* widget;
	FilesAbstractEditableLabel* entry;
};

static gint FilesTextRenderer_private_offset;
static gpointer files_text_renderer_parent_class = NULL;

VALA_EXTERN GType files_text_renderer_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FilesTextRenderer, g_object_unref)
VALA_EXTERN GType files_abstract_editable_label_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FilesAbstractEditableLabel, g_object_unref)
VALA_EXTERN FilesTextRenderer* files_text_renderer_new (FilesViewMode viewmode);
VALA_EXTERN FilesTextRenderer* files_text_renderer_construct (GType object_type,
                                                  FilesViewMode viewmode);
VALA_EXTERN FilesMultiLineEditableLabel* files_multi_line_editable_label_new (void);
VALA_EXTERN FilesMultiLineEditableLabel* files_multi_line_editable_label_construct (GType object_type);
VALA_EXTERN GType files_multi_line_editable_label_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FilesMultiLineEditableLabel, g_object_unref)
VALA_EXTERN void files_abstract_editable_label_set_justify (FilesAbstractEditableLabel* self,
                                                GtkJustification jtype);
VALA_EXTERN FilesSingleLineEditableLabel* files_single_line_editable_label_new (void);
VALA_EXTERN FilesSingleLineEditableLabel* files_single_line_editable_label_construct (GType object_type);
VALA_EXTERN GType files_single_line_editable_label_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FilesSingleLineEditableLabel, g_object_unref)
VALA_EXTERN void files_abstract_editable_label_set_line_wrap (FilesAbstractEditableLabel* self,
                                                  gboolean wrap);
static void files_text_renderer_on_entry_editing_done (FilesTextRenderer* self);
static void _files_text_renderer_on_entry_editing_done_gtk_cell_editable_editing_done (GtkCellEditable* _sender,
                                                                                gpointer self);
static void files_text_renderer_real_get_preferred_height_for_width (GtkCellRenderer* base,
                                                              GtkWidget* widget,
                                                              gint width,
                                                              gint* minimum_size,
                                                              gint* natural_size);
static void files_text_renderer_set_widget (FilesTextRenderer* self,
                                     GtkWidget* _widget);
VALA_EXTERN void files_text_renderer_set_up_layout (FilesTextRenderer* self,
                                        const gchar* text,
                                        gint cell_width);
static gint files_text_renderer_get_border_radius (FilesTextRenderer* self);
static void files_text_renderer_real_render (GtkCellRenderer* base,
                                      cairo_t* cr,
                                      GtkWidget* widget,
                                      GdkRectangle* background_area,
                                      GdkRectangle* cell_area,
                                      GtkCellRendererState flags);
static void files_text_renderer_draw_focus (FilesTextRenderer* self,
                                     cairo_t* cr,
                                     GdkRectangle* cell_area,
                                     GtkCellRendererState flags,
                                     GtkStyleContext* style_context,
                                     GtkStateFlags state,
                                     gint* x_offset,
                                     gint* y_offset,
                                     gint* focus_rect_width,
                                     gint* focus_rect_height);
static void _vala_GdkRGBA_free (GdkRGBA* self);
VALA_EXTERN void files_text_renderer_set_file (FilesTextRenderer* self,
                                   FilesFile* value);
VALA_EXTERN gint files_text_renderer_get_double_border_radius (FilesTextRenderer* self);
static GtkCellEditable* files_text_renderer_real_start_editing (GtkCellRenderer* base,
                                                         GdkEvent* event,
                                                         GtkWidget* widget,
                                                         const gchar* path,
                                                         GdkRectangle* background_area,
                                                         GdkRectangle* cell_area,
                                                         GtkCellRendererState flags);
VALA_EXTERN void files_abstract_editable_label_set_text (FilesAbstractEditableLabel* self,
                                             const gchar* text);
VALA_EXTERN void files_abstract_editable_label_set_line_wrap_mode (FilesAbstractEditableLabel* self,
                                                       PangoWrapMode mode);
VALA_EXTERN void files_abstract_editable_label_set_size_request (FilesAbstractEditableLabel* self,
                                                     gint width,
                                                     gint height);
VALA_EXTERN void files_abstract_editable_label_set_position (FilesAbstractEditableLabel* self,
                                                 gint position);
VALA_EXTERN void files_text_renderer_end_editing (FilesTextRenderer* self,
                                      gboolean cancel);
VALA_EXTERN void files_abstract_editable_label_end_editing (FilesAbstractEditableLabel* self,
                                                gboolean cancelled);
static void files_text_renderer_disconnect_widget_signals (FilesTextRenderer* self);
static void files_text_renderer_connect_widget_signals (FilesTextRenderer* self);
static void _vala_PangoLanguage_free (PangoLanguage* self);
static void files_text_renderer_invalidate (FilesTextRenderer* self);
static void _files_text_renderer_invalidate_gtk_widget_destroy (GtkWidget* _sender,
                                                         gpointer self);
static void _files_text_renderer_invalidate_gtk_widget_style_updated (GtkWidget* _sender,
                                                               gpointer self);
VALA_EXTERN gboolean files_abstract_editable_label_get_editing_canceled (FilesAbstractEditableLabel* self);
VALA_EXTERN gchar* files_abstract_editable_label_get_text (FilesAbstractEditableLabel* self);
static void files_text_renderer_get_offsets (FilesTextRenderer* self,
                                      GdkRectangle* cell_area,
                                      gint width,
                                      gint height,
                                      gint* x_offset,
                                      gint* y_offset);
static void files_text_renderer_set_border_radius (FilesTextRenderer* self,
                                            gint value);
static void files_text_renderer_set_double_border_radius (FilesTextRenderer* self,
                                                   gint value);
VALA_EXTERN FilesZoomLevel files_text_renderer_get_zoom_level (FilesTextRenderer* self);
VALA_EXTERN void files_text_renderer_set_zoom_level (FilesTextRenderer* self,
                                         FilesZoomLevel value);
static gint files_text_renderer_get_item_width (FilesTextRenderer* self);
static FilesFile* files_text_renderer_get_file (FilesTextRenderer* self);
VALA_EXTERN void files_text_renderer_set_item_width (FilesTextRenderer* self,
                                         gint value);
static GObject * files_text_renderer_constructor (GType type,
                                           guint n_construct_properties,
                                           GObjectConstructParam * construct_properties);
static void files_text_renderer_finalize (GObject * obj);
static GType files_text_renderer_get_type_once (void);
static void _vala_files_text_renderer_get_property (GObject * object,
                                             guint property_id,
                                             GValue * value,
                                             GParamSpec * pspec);
static void _vala_files_text_renderer_set_property (GObject * object,
                                             guint property_id,
                                             const GValue * value,
                                             GParamSpec * pspec);

static inline gpointer
files_text_renderer_get_instance_private (FilesTextRenderer* self)
{
	return G_STRUCT_MEMBER_P (self, FilesTextRenderer_private_offset);
}

static void
_files_text_renderer_on_entry_editing_done_gtk_cell_editable_editing_done (GtkCellEditable* _sender,
                                                                           gpointer self)
{
	files_text_renderer_on_entry_editing_done ((FilesTextRenderer*) self);
}

FilesTextRenderer*
files_text_renderer_construct (GType object_type,
                               FilesViewMode viewmode)
{
	FilesTextRenderer * self = NULL;
	FilesAbstractEditableLabel* _tmp4_;
	FilesAbstractEditableLabel* _tmp5_;
	self = (FilesTextRenderer*) g_object_new (object_type, NULL);
	if (viewmode == FILES_VIEW_MODE_ICON) {
		FilesMultiLineEditableLabel* _tmp0_;
		FilesAbstractEditableLabel* _tmp1_;
		_tmp0_ = files_multi_line_editable_label_new ();
		g_object_ref_sink (_tmp0_);
		_g_object_unref0 (self->priv->entry);
		self->priv->entry = (FilesAbstractEditableLabel*) _tmp0_;
		_tmp1_ = self->priv->entry;
		files_abstract_editable_label_set_justify (_tmp1_, GTK_JUSTIFY_CENTER);
		self->priv->is_list_view = FALSE;
	} else {
		FilesSingleLineEditableLabel* _tmp2_;
		FilesAbstractEditableLabel* _tmp3_;
		_tmp2_ = files_single_line_editable_label_new ();
		g_object_ref_sink (_tmp2_);
		_g_object_unref0 (self->priv->entry);
		self->priv->entry = (FilesAbstractEditableLabel*) _tmp2_;
		_tmp3_ = self->priv->entry;
		files_abstract_editable_label_set_justify (_tmp3_, GTK_JUSTIFY_LEFT);
		self->priv->is_list_view = TRUE;
	}
	_tmp4_ = self->priv->entry;
	files_abstract_editable_label_set_line_wrap (_tmp4_, TRUE);
	_tmp5_ = self->priv->entry;
	g_signal_connect_object ((GtkCellEditable*) _tmp5_, "editing-done", (GCallback) _files_text_renderer_on_entry_editing_done_gtk_cell_editable_editing_done, self, 0);
	return self;
}

FilesTextRenderer*
files_text_renderer_new (FilesViewMode viewmode)
{
	return files_text_renderer_construct (FILES_TYPE_TEXT_RENDERER, viewmode);
}

static void
files_text_renderer_real_get_preferred_height_for_width (GtkCellRenderer* base,
                                                         GtkWidget* widget,
                                                         gint width,
                                                         gint* minimum_size,
                                                         gint* natural_size)
{
	FilesTextRenderer * self;
	gint _vala_minimum_size = 0;
	gint _vala_natural_size = 0;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gint _tmp3_;
	self = (FilesTextRenderer*) base;
	g_return_if_fail (widget != NULL);
	files_text_renderer_set_widget (self, widget);
	g_object_get ((GtkCellRendererText*) self, "text", &_tmp0_, NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_;
	files_text_renderer_set_up_layout (self, _tmp2_, width);
	_g_free0 (_tmp2_);
	_tmp3_ = self->priv->_border_radius;
	_vala_natural_size = self->text_height + (4 * _tmp3_);
	_vala_minimum_size = _vala_natural_size;
	if (minimum_size) {
		*minimum_size = _vala_minimum_size;
	}
	if (natural_size) {
		*natural_size = _vala_natural_size;
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_vala_GdkRGBA_free (GdkRGBA* self)
{
	g_boxed_free (gdk_rgba_get_type (), self);
}

static void
files_text_renderer_real_render (GtkCellRenderer* base,
                                 cairo_t* cr,
                                 GtkWidget* widget,
                                 GdkRectangle* background_area,
                                 GdkRectangle* cell_area,
                                 GtkCellRendererState flags)
{
	FilesTextRenderer * self;
	GtkStateFlags state = 0U;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GdkRectangle _tmp4_;
	GtkStyleContext* style_context = NULL;
	GtkContainer* _tmp5_;
	GtkStyleContext* _tmp6_;
	GtkStyleContext* _tmp7_;
	GtkStyleContext* _tmp8_;
	GtkStyleContext* _tmp9_;
	gint focus_rect_width = 0;
	gint focus_rect_height = 0;
	GdkRectangle _tmp10_;
	GtkStyleContext* _tmp11_;
	gint _tmp12_ = 0;
	gint _tmp13_ = 0;
	gint _tmp14_ = 0;
	gint _tmp15_ = 0;
	gboolean _tmp20_;
	gboolean _tmp21_;
	GtkStyleContext* _tmp60_;
	GdkRectangle _tmp61_;
	GdkRectangle _tmp62_;
	PangoLayout* _tmp63_;
	GtkStyleContext* _tmp64_;
	GtkStyleContext* _tmp65_;
	GtkCssProvider* _tmp66_;
	GError* _inner_error0_ = NULL;
	self = (FilesTextRenderer*) base;
	g_return_if_fail (cr != NULL);
	g_return_if_fail (widget != NULL);
	g_return_if_fail (background_area != NULL);
	g_return_if_fail (cell_area != NULL);
	files_text_renderer_set_widget (self, widget);
	state = gtk_widget_get_state_flags (widget);
	if ((flags & GTK_CELL_RENDERER_SELECTED) == GTK_CELL_RENDERER_SELECTED) {
		state |= GTK_STATE_FLAG_SELECTED;
	} else {
		if ((flags & GTK_CELL_RENDERER_PRELIT) == GTK_CELL_RENDERER_PRELIT) {
			state = GTK_STATE_FLAG_PRELIGHT;
		} else {
			GtkStateFlags _tmp0_ = 0U;
			if (gtk_widget_get_sensitive (widget)) {
				_tmp0_ = GTK_STATE_FLAG_NORMAL;
			} else {
				_tmp0_ = GTK_STATE_FLAG_INSENSITIVE;
			}
			state = _tmp0_;
		}
	}
	g_object_get ((GtkCellRendererText*) self, "text", &_tmp1_, NULL);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_;
	_tmp4_ = *cell_area;
	files_text_renderer_set_up_layout (self, _tmp3_, _tmp4_.width);
	_g_free0 (_tmp3_);
	_tmp5_ = gtk_widget_get_parent (widget);
	_tmp6_ = gtk_widget_get_style_context ((GtkWidget*) _tmp5_);
	_tmp7_ = _g_object_ref0 (_tmp6_);
	style_context = _tmp7_;
	_tmp8_ = style_context;
	gtk_style_context_save (_tmp8_);
	_tmp9_ = style_context;
	gtk_style_context_set_state (_tmp9_, state);
	_tmp10_ = *cell_area;
	_tmp11_ = style_context;
	files_text_renderer_draw_focus (self, cr, &_tmp10_, flags, _tmp11_, state, &_tmp12_, &_tmp13_, &_tmp14_, &_tmp15_);
	self->text_x_offset = _tmp12_;
	self->text_y_offset = _tmp13_;
	focus_rect_width = _tmp14_;
	focus_rect_height = _tmp15_;
	if (!self->priv->is_list_view) {
		gint _tmp16_;
		gint _tmp17_;
		g_object_get ((GtkCellRendererText*) self, "wrap-width", &_tmp16_, NULL);
		_tmp17_ = _tmp16_;
		self->text_x_offset = self->text_x_offset + ((focus_rect_width - _tmp17_) / 2);
		self->text_y_offset = self->text_y_offset + ((focus_rect_height - self->text_height) / 2);
	} else {
		GdkRectangle _tmp18_;
		gint _tmp19_;
		_tmp18_ = *cell_area;
		self->text_y_offset = (_tmp18_.height - self->priv->char_height) / 2;
		_tmp19_ = self->priv->_border_radius;
		self->text_x_offset = self->text_x_offset + _tmp19_;
	}
	g_object_get ((GtkCellRendererText*) self, "background-set", &_tmp20_, NULL);
	_tmp21_ = _tmp20_;
	if (_tmp21_) {
		GdkRGBA* _tmp22_;
		GdkRGBA* _tmp23_;
		GdkRGBA* _tmp24_;
		GdkRGBA _tmp25_;
		gboolean _tmp26_;
		GtkStyleContext* _tmp58_;
		GtkCssProvider* _tmp59_;
		g_object_get ((GtkCellRendererText*) self, "background-rgba", &_tmp22_, NULL);
		_tmp23_ = _tmp22_;
		_tmp24_ = _tmp23_;
		_tmp25_ = self->priv->previous_background_rgba;
		_tmp26_ = !gdk_rgba_equal (_tmp24_, &_tmp25_);
		__vala_GdkRGBA_free0 (_tmp24_);
		if (_tmp26_) {
			GdkRGBA* _tmp27_;
			GdkRGBA* _tmp28_;
			GdkRGBA* _tmp29_;
			GdkRGBA* _tmp30_;
			GdkRGBA* _tmp31_;
			GdkRGBA* _tmp32_;
			GdkRGBA* _tmp33_;
			GdkRGBA* _tmp34_;
			GdkRGBA* _tmp35_;
			GdkRGBA* _tmp36_;
			GdkRGBA* _tmp37_;
			GdkRGBA* _tmp38_;
			GdkRGBA contrasting_foreground_rgba = {0};
			GdkRGBA* _tmp39_;
			GdkRGBA* _tmp40_;
			GdkRGBA* _tmp41_;
			GdkRGBA _tmp42_;
			GdkRGBA _tmp43_ = {0};
			GdkRGBA _tmp44_;
			GdkRGBA _tmp45_;
			g_object_get ((GtkCellRendererText*) self, "background-rgba", &_tmp27_, NULL);
			_tmp28_ = _tmp27_;
			_tmp29_ = _tmp28_;
			self->priv->previous_background_rgba.red = (*_tmp29_).red;
			__vala_GdkRGBA_free0 (_tmp29_);
			g_object_get ((GtkCellRendererText*) self, "background-rgba", &_tmp30_, NULL);
			_tmp31_ = _tmp30_;
			_tmp32_ = _tmp31_;
			self->priv->previous_background_rgba.green = (*_tmp32_).green;
			__vala_GdkRGBA_free0 (_tmp32_);
			g_object_get ((GtkCellRendererText*) self, "background-rgba", &_tmp33_, NULL);
			_tmp34_ = _tmp33_;
			_tmp35_ = _tmp34_;
			self->priv->previous_background_rgba.blue = (*_tmp35_).blue;
			__vala_GdkRGBA_free0 (_tmp35_);
			g_object_get ((GtkCellRendererText*) self, "background-rgba", &_tmp36_, NULL);
			_tmp37_ = _tmp36_;
			_tmp38_ = _tmp37_;
			self->priv->previous_background_rgba.alpha = (*_tmp38_).alpha;
			__vala_GdkRGBA_free0 (_tmp38_);
			g_object_get ((GtkCellRendererText*) self, "background-rgba", &_tmp39_, NULL);
			_tmp40_ = _tmp39_;
			_tmp41_ = _tmp40_;
			_tmp42_ = *_tmp41_;
			granite_contrasting_foreground_color (&_tmp42_, &_tmp43_);
			_tmp44_ = _tmp43_;
			__vala_GdkRGBA_free0 (_tmp41_);
			contrasting_foreground_rgba = _tmp44_;
			_tmp45_ = self->priv->previous_contrasting_rgba;
			if (!gdk_rgba_equal (&contrasting_foreground_rgba, &_tmp45_)) {
				GdkRGBA _tmp46_;
				GdkRGBA _tmp47_;
				GdkRGBA _tmp48_;
				GdkRGBA _tmp49_;
				gchar* data = NULL;
				gchar* _tmp50_;
				gchar* _tmp51_;
				gchar* _tmp52_;
				gchar* _tmp53_;
				_tmp46_ = contrasting_foreground_rgba;
				self->priv->previous_contrasting_rgba.red = _tmp46_.red;
				_tmp47_ = contrasting_foreground_rgba;
				self->priv->previous_contrasting_rgba.green = _tmp47_.green;
				_tmp48_ = contrasting_foreground_rgba;
				self->priv->previous_contrasting_rgba.blue = _tmp48_.blue;
				_tmp49_ = contrasting_foreground_rgba;
				self->priv->previous_contrasting_rgba.alpha = _tmp49_.alpha;
				_tmp50_ = gdk_rgba_to_string (&contrasting_foreground_rgba);
				_tmp51_ = _tmp50_;
				_tmp52_ = g_strdup_printf ("* {color: %s;}", _tmp51_);
				_tmp53_ = _tmp52_;
				_g_free0 (_tmp51_);
				data = _tmp53_;
				{
					GtkCssProvider* _tmp54_;
					const gchar* _tmp55_;
					_tmp54_ = self->priv->text_css;
					_tmp55_ = data;
					gtk_css_provider_load_from_data (_tmp54_, _tmp55_, (gssize) -1, &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						goto __catch0_g_error;
					}
				}
				goto __finally0;
				__catch0_g_error:
				{
					GError* e = NULL;
					GError* _tmp56_;
					const gchar* _tmp57_;
					e = _inner_error0_;
					_inner_error0_ = NULL;
					_tmp56_ = e;
					_tmp57_ = _tmp56_->message;
					g_critical ("TextRenderer.vala:159: %s", _tmp57_);
					_g_error_free0 (e);
				}
				__finally0:
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_free0 (data);
					_g_object_unref0 (style_context);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return;
				}
				_g_free0 (data);
			}
		}
		_tmp58_ = style_context;
		_tmp59_ = self->priv->text_css;
		gtk_style_context_add_provider (_tmp58_, (GtkStyleProvider*) _tmp59_, (guint) GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
	}
	_tmp60_ = style_context;
	_tmp61_ = *cell_area;
	_tmp62_ = *cell_area;
	_tmp63_ = self->priv->layout;
	gtk_render_layout (_tmp60_, cr, (gdouble) (_tmp61_.x + self->text_x_offset), (gdouble) (_tmp62_.y + self->text_y_offset), _tmp63_);
	_tmp64_ = style_context;
	gtk_style_context_restore (_tmp64_);
	_tmp65_ = style_context;
	_tmp66_ = self->priv->text_css;
	gtk_style_context_remove_provider (_tmp65_, (GtkStyleProvider*) _tmp66_);
	files_text_renderer_set_file (self, NULL);
	_g_object_unref0 (style_context);
}

void
files_text_renderer_set_up_layout (FilesTextRenderer* self,
                                   const gchar* text,
                                   gint cell_width)
{
	PangoLayout* _tmp10_;
	PangoLayout* _tmp12_;
	gint width = 0;
	gint height = 0;
	PangoLayout* _tmp13_;
	gint _tmp14_ = 0;
	gint _tmp15_ = 0;
	g_return_if_fail (self != NULL);
	if (text == NULL) {
		text = " ";
	}
	if (self->priv->is_list_view) {
		PangoLayout* _tmp0_;
		gint _tmp1_;
		PangoLayout* _tmp2_;
		_tmp0_ = self->priv->layout;
		_tmp1_ = self->priv->_double_border_radius;
		pango_layout_set_width (_tmp0_, (cell_width - _tmp1_) * PANGO_SCALE);
		_tmp2_ = self->priv->layout;
		pango_layout_set_height (_tmp2_, -1);
	} else {
		PangoLayout* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		PangoLayout* _tmp6_;
		PangoWrapMode _tmp7_;
		PangoWrapMode _tmp8_;
		PangoLayout* _tmp9_;
		_tmp3_ = self->priv->layout;
		g_object_get ((GtkCellRendererText*) self, "wrap-width", &_tmp4_, NULL);
		_tmp5_ = _tmp4_;
		pango_layout_set_width (_tmp3_, _tmp5_ * PANGO_SCALE);
		_tmp6_ = self->priv->layout;
		g_object_get ((GtkCellRendererText*) self, "wrap-mode", &_tmp7_, NULL);
		_tmp8_ = _tmp7_;
		pango_layout_set_wrap (_tmp6_, _tmp8_);
		_tmp9_ = self->priv->layout;
		pango_layout_set_height (_tmp9_, -FILES_TEXT_RENDERER_MAX_LINES);
	}
	_tmp10_ = self->priv->layout;
	pango_layout_set_ellipsize (_tmp10_, PANGO_ELLIPSIZE_END);
	if (!self->priv->is_list_view) {
		PangoLayout* _tmp11_;
		_tmp11_ = self->priv->layout;
		pango_layout_set_alignment (_tmp11_, PANGO_ALIGN_CENTER);
	}
	_tmp12_ = self->priv->layout;
	pango_layout_set_text (_tmp12_, text, -1);
	_tmp13_ = self->priv->layout;
	pango_layout_get_pixel_size (_tmp13_, &_tmp14_, &_tmp15_);
	width = _tmp14_;
	height = _tmp15_;
	self->text_width = width;
	self->text_height = height;
}

static GtkCellEditable*
files_text_renderer_real_start_editing (GtkCellRenderer* base,
                                        GdkEvent* event,
                                        GtkWidget* widget,
                                        const gchar* path,
                                        GdkRectangle* background_area,
                                        GdkRectangle* cell_area,
                                        GtkCellRendererState flags)
{
	FilesTextRenderer * self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	gboolean _tmp2_;
	FilesAbstractEditableLabel* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	FilesAbstractEditableLabel* _tmp9_;
	PangoWrapMode _tmp10_;
	PangoWrapMode _tmp11_;
	FilesAbstractEditableLabel* _tmp12_;
	gint _tmp13_;
	gint _tmp14_;
	FilesAbstractEditableLabel* _tmp15_;
	FilesAbstractEditableLabel* _tmp16_;
	gchar* _tmp17_;
	FilesAbstractEditableLabel* _tmp18_;
	GdkRectangle _tmp19_;
	GdkRectangle _tmp20_;
	FilesAbstractEditableLabel* _tmp21_;
	GtkCellEditable* result;
	self = (FilesTextRenderer*) base;
	g_return_val_if_fail (widget != NULL, NULL);
	g_return_val_if_fail (path != NULL, NULL);
	g_return_val_if_fail (background_area != NULL, NULL);
	g_return_val_if_fail (cell_area != NULL, NULL);
	_tmp1_ = gtk_cell_renderer_get_visible ((GtkCellRenderer*) self);
	_tmp2_ = _tmp1_;
	if (!_tmp2_) {
		_tmp0_ = TRUE;
	} else {
		GtkCellRendererMode _tmp3_;
		GtkCellRendererMode _tmp4_;
		g_object_get ((GtkCellRenderer*) self, "mode", &_tmp3_, NULL);
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp4_ != GTK_CELL_RENDERER_MODE_EDITABLE;
	}
	if (_tmp0_) {
		result = NULL;
		return result;
	}
	_tmp5_ = self->priv->entry;
	g_object_get ((GtkCellRendererText*) self, "text", &_tmp6_, NULL);
	_tmp7_ = _tmp6_;
	_tmp8_ = _tmp7_;
	files_abstract_editable_label_set_text (_tmp5_, _tmp8_);
	_g_free0 (_tmp8_);
	_tmp9_ = self->priv->entry;
	g_object_get ((GtkCellRendererText*) self, "wrap-mode", &_tmp10_, NULL);
	_tmp11_ = _tmp10_;
	files_abstract_editable_label_set_line_wrap_mode (_tmp9_, _tmp11_);
	_tmp12_ = self->priv->entry;
	g_object_get ((GtkCellRendererText*) self, "wrap-width", &_tmp13_, NULL);
	_tmp14_ = _tmp13_;
	files_abstract_editable_label_set_size_request (_tmp12_, _tmp14_, -1);
	_tmp15_ = self->priv->entry;
	files_abstract_editable_label_set_position (_tmp15_, -1);
	_tmp16_ = self->priv->entry;
	_tmp17_ = g_strdup (path);
	g_object_set_data_full ((GObject*) _tmp16_, "marlin-text-renderer-path", _tmp17_, g_free);
	_tmp18_ = self->priv->entry;
	gtk_widget_show_all ((GtkWidget*) _tmp18_);
	_tmp19_ = *background_area;
	_tmp20_ = *cell_area;
	GTK_CELL_RENDERER_CLASS (files_text_renderer_parent_class)->start_editing ((GtkCellRenderer*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_cell_renderer_text_get_type (), GtkCellRendererText), event, widget, path, &_tmp19_, &_tmp20_, flags);
	_tmp21_ = self->priv->entry;
	result = (GtkCellEditable*) _tmp21_;
	return result;
}

void
files_text_renderer_end_editing (FilesTextRenderer* self,
                                 gboolean cancel)
{
	FilesAbstractEditableLabel* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->entry;
	files_abstract_editable_label_end_editing (_tmp0_, cancel);
}

static void
_vala_PangoLanguage_free (PangoLanguage* self)
{
	g_boxed_free (pango_language_get_type (), self);
}

static void
files_text_renderer_set_widget (FilesTextRenderer* self,
                                GtkWidget* _widget)
{
	PangoFontMetrics* metrics = NULL;
	PangoContext* context = NULL;
	GtkWidget* _tmp0_;
	GtkWidget* _tmp1_;
	GtkWidget* _tmp2_;
	GtkWidget* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->widget;
	if (_widget == _tmp0_) {
		_g_object_unref0 (context);
		_pango_font_metrics_unref0 (metrics);
		return;
	}
	_tmp1_ = self->priv->widget;
	if (_tmp1_ != NULL) {
		files_text_renderer_disconnect_widget_signals (self);
	}
	_tmp2_ = _g_object_ref0 (_widget);
	_g_object_unref0 (self->priv->widget);
	self->priv->widget = _tmp2_;
	_tmp3_ = self->priv->widget;
	if (_tmp3_ != NULL) {
		GtkWidget* _tmp4_;
		PangoContext* _tmp5_;
		PangoContext* _tmp6_;
		PangoContext* _tmp7_;
		PangoLayout* _tmp8_;
		PangoAttrList* attr = NULL;
		PangoAttrList* _tmp9_;
		PangoAttrList* _tmp10_;
		PangoAttribute* _tmp11_;
		PangoLayout* _tmp12_;
		PangoAttrList* _tmp13_;
		PangoLayout* _tmp14_;
		PangoLayout* _tmp15_;
		PangoContext* _tmp16_;
		PangoLayout* _tmp17_;
		PangoFontDescription* _tmp18_;
		PangoContext* _tmp19_;
		PangoLanguage* _tmp20_;
		PangoLanguage* _tmp21_;
		PangoFontMetrics* _tmp22_;
		PangoFontMetrics* _tmp23_;
		PangoFontMetrics* _tmp24_;
		files_text_renderer_connect_widget_signals (self);
		_tmp4_ = self->priv->widget;
		_tmp5_ = gtk_widget_get_pango_context (_tmp4_);
		_tmp6_ = _g_object_ref0 (_tmp5_);
		_g_object_unref0 (context);
		context = _tmp6_;
		_tmp7_ = context;
		_tmp8_ = pango_layout_new (_tmp7_);
		_g_object_unref0 (self->priv->layout);
		self->priv->layout = _tmp8_;
		_tmp9_ = pango_attr_list_new ();
		attr = _tmp9_;
		_tmp10_ = attr;
		_tmp11_ = pango_attr_insert_hyphens_new (FALSE);
		pango_attr_list_insert (_tmp10_, _tmp11_);
		_tmp12_ = self->priv->layout;
		_tmp13_ = attr;
		pango_layout_set_attributes (_tmp12_, _tmp13_);
		_tmp14_ = self->priv->layout;
		pango_layout_set_auto_dir (_tmp14_, FALSE);
		_tmp15_ = self->priv->layout;
		pango_layout_set_single_paragraph_mode (_tmp15_, TRUE);
		_tmp16_ = context;
		_tmp17_ = self->priv->layout;
		_tmp18_ = pango_layout_get_font_description (_tmp17_);
		_tmp19_ = context;
		_tmp20_ = pango_context_get_language (_tmp19_);
		_tmp21_ = _tmp20_;
		_tmp22_ = pango_context_get_metrics (_tmp16_, _tmp18_, _tmp21_);
		_pango_font_metrics_unref0 (metrics);
		metrics = _tmp22_;
		__vala_PangoLanguage_free0 (_tmp21_);
		_tmp23_ = metrics;
		_tmp24_ = metrics;
		self->priv->char_height = ((pango_font_metrics_get_ascent (_tmp23_) + pango_font_metrics_get_descent (_tmp24_)) + 512) >> 10;
		_pango_attr_list_unref0 (attr);
	} else {
		_g_object_unref0 (self->priv->layout);
		self->priv->layout = NULL;
		self->priv->char_height = 0;
	}
	_g_object_unref0 (context);
	_pango_font_metrics_unref0 (metrics);
}

static void
_files_text_renderer_invalidate_gtk_widget_destroy (GtkWidget* _sender,
                                                    gpointer self)
{
	files_text_renderer_invalidate ((FilesTextRenderer*) self);
}

static void
_files_text_renderer_invalidate_gtk_widget_style_updated (GtkWidget* _sender,
                                                          gpointer self)
{
	files_text_renderer_invalidate ((FilesTextRenderer*) self);
}

static void
files_text_renderer_connect_widget_signals (FilesTextRenderer* self)
{
	GtkWidget* _tmp0_;
	GtkWidget* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->widget;
	g_signal_connect_object (_tmp0_, "destroy", (GCallback) _files_text_renderer_invalidate_gtk_widget_destroy, self, 0);
	_tmp1_ = self->priv->widget;
	g_signal_connect_object (_tmp1_, "style-updated", (GCallback) _files_text_renderer_invalidate_gtk_widget_style_updated, self, 0);
}

static void
files_text_renderer_disconnect_widget_signals (FilesTextRenderer* self)
{
	GtkWidget* _tmp0_;
	guint _tmp1_;
	GtkWidget* _tmp2_;
	guint _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->widget;
	g_signal_parse_name ("destroy", gtk_widget_get_type (), &_tmp1_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp0_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _files_text_renderer_invalidate_gtk_widget_destroy, self);
	_tmp2_ = self->priv->widget;
	g_signal_parse_name ("style-updated", gtk_widget_get_type (), &_tmp3_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp2_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, 0, NULL, (GCallback) _files_text_renderer_invalidate_gtk_widget_style_updated, self);
}

static void
files_text_renderer_invalidate (FilesTextRenderer* self)
{
	g_return_if_fail (self != NULL);
	files_text_renderer_disconnect_widget_signals (self);
	files_text_renderer_set_widget (self, NULL);
	files_text_renderer_set_file (self, NULL);
}

static void
files_text_renderer_on_entry_editing_done (FilesTextRenderer* self)
{
	gboolean cancelled = FALSE;
	FilesAbstractEditableLabel* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	FilesAbstractEditableLabel* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->entry;
	_tmp1_ = files_abstract_editable_label_get_editing_canceled (_tmp0_);
	_tmp2_ = _tmp1_;
	cancelled = _tmp2_;
	gtk_cell_renderer_stop_editing ((GtkCellRenderer*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_cell_renderer_text_get_type (), GtkCellRendererText), cancelled);
	_tmp3_ = self->priv->entry;
	gtk_widget_hide ((GtkWidget*) _tmp3_);
	if (!cancelled) {
		gchar* text = NULL;
		FilesAbstractEditableLabel* _tmp4_;
		gchar* _tmp5_;
		gchar* path = NULL;
		FilesAbstractEditableLabel* _tmp6_;
		gconstpointer _tmp7_;
		gchar* _tmp8_;
		const gchar* _tmp9_;
		const gchar* _tmp10_;
		_tmp4_ = self->priv->entry;
		_tmp5_ = files_abstract_editable_label_get_text (_tmp4_);
		text = _tmp5_;
		_tmp6_ = self->priv->entry;
		_tmp7_ = g_object_get_data ((GObject*) _tmp6_, "marlin-text-renderer-path");
		_tmp8_ = g_strdup ((const gchar*) _tmp7_);
		path = _tmp8_;
		_tmp9_ = path;
		_tmp10_ = text;
		g_signal_emit_by_name ((GtkCellRendererText*) self, "edited", _tmp9_, _tmp10_);
		_g_free0 (path);
		_g_free0 (text);
	}
	files_text_renderer_set_file (self, NULL);
}

static void
files_text_renderer_draw_focus (FilesTextRenderer* self,
                                cairo_t* cr,
                                GdkRectangle* cell_area,
                                GtkCellRendererState flags,
                                GtkStyleContext* style_context,
                                GtkStateFlags state,
                                gint* x_offset,
                                gint* y_offset,
                                gint* focus_rect_width,
                                gint* focus_rect_height)
{
	gint _vala_x_offset = 0;
	gint _vala_y_offset = 0;
	gint _vala_focus_rect_width = 0;
	gint _vala_focus_rect_height = 0;
	gboolean selected = FALSE;
	gint _tmp0_;
	gint _tmp1_;
	GdkRectangle _tmp2_;
	GdkRectangle _tmp3_;
	GdkRectangle _tmp4_;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	gboolean _tmp7_ = FALSE;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cr != NULL);
	g_return_if_fail (cell_area != NULL);
	g_return_if_fail (style_context != NULL);
	selected = FALSE;
	_vala_focus_rect_width = 0;
	_vala_focus_rect_height = 0;
	_vala_x_offset = 0;
	_vala_y_offset = 0;
	selected = (flags & GTK_CELL_RENDERER_SELECTED) == GTK_CELL_RENDERER_SELECTED;
	_tmp0_ = self->priv->_border_radius;
	_vala_focus_rect_height = self->text_height + _tmp0_;
	_tmp1_ = self->priv->_double_border_radius;
	_vala_focus_rect_width = self->text_width + _tmp1_;
	_tmp2_ = *cell_area;
	_vala_focus_rect_width = MIN (_vala_focus_rect_width, _tmp2_.width - 2);
	_tmp3_ = *cell_area;
	_vala_focus_rect_height = MIN (_vala_focus_rect_height, _tmp3_.height - 2);
	_tmp4_ = *cell_area;
	files_text_renderer_get_offsets (self, &_tmp4_, _vala_focus_rect_width, _vala_focus_rect_height, &_tmp5_, &_tmp6_);
	_vala_x_offset = _tmp5_;
	_vala_y_offset = _tmp6_;
	if (selected) {
		_tmp7_ = TRUE;
	} else {
		gboolean _tmp8_;
		gboolean _tmp9_;
		g_object_get ((GtkCellRendererText*) self, "background-set", &_tmp8_, NULL);
		_tmp9_ = _tmp8_;
		_tmp7_ = _tmp9_;
	}
	if (_tmp7_) {
		gint x0 = 0;
		GdkRectangle _tmp10_;
		gint y0 = 0;
		GdkRectangle _tmp11_;
		GtkCssProvider* provider = NULL;
		GtkCssProvider* _tmp12_;
		gchar* data = NULL;
		gboolean _tmp13_ = FALSE;
		_tmp10_ = *cell_area;
		x0 = _tmp10_.x + _vala_x_offset;
		_tmp11_ = *cell_area;
		y0 = _tmp11_.y + _vala_y_offset;
		_tmp12_ = gtk_css_provider_new ();
		provider = _tmp12_;
		if (selected) {
			gboolean _tmp14_;
			gboolean _tmp15_;
			g_object_get ((GtkCellRendererText*) self, "background-set", &_tmp14_, NULL);
			_tmp15_ = _tmp14_;
			_tmp13_ = !_tmp15_;
		} else {
			_tmp13_ = FALSE;
		}
		if (_tmp13_) {
			gchar* _tmp16_;
			_tmp16_ = g_strdup ("* {border-radius: 5px;}");
			_g_free0 (data);
			data = _tmp16_;
		} else {
			GdkRGBA* _tmp17_;
			GdkRGBA* _tmp18_;
			GdkRGBA* _tmp19_;
			gchar* _tmp20_;
			gchar* _tmp21_;
			gchar* _tmp22_;
			g_object_get ((GtkCellRendererText*) self, "background-rgba", &_tmp17_, NULL);
			_tmp18_ = _tmp17_;
			_tmp19_ = _tmp18_;
			_tmp20_ = gdk_rgba_to_string (_tmp19_);
			_tmp21_ = _tmp20_;
			_tmp22_ = g_strdup_printf ("* {border-radius: 5px; background-color: %s;}", _tmp21_);
			_g_free0 (data);
			data = _tmp22_;
			_g_free0 (_tmp21_);
			__vala_GdkRGBA_free0 (_tmp19_);
		}
		{
			GtkCssProvider* _tmp23_;
			const gchar* _tmp24_;
			GtkCssProvider* _tmp25_;
			GtkCssProvider* _tmp26_;
			_tmp23_ = provider;
			_tmp24_ = data;
			gtk_css_provider_load_from_data (_tmp23_, _tmp24_, (gssize) -1, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp25_ = provider;
			gtk_style_context_add_provider (style_context, (GtkStyleProvider*) _tmp25_, (guint) GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
			gtk_render_background (style_context, cr, (gdouble) x0, (gdouble) y0, (gdouble) _vala_focus_rect_width, (gdouble) _vala_focus_rect_height);
			_tmp26_ = provider;
			gtk_style_context_remove_provider (style_context, (GtkStyleProvider*) _tmp26_);
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp27_;
			const gchar* _tmp28_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp27_ = e;
			_tmp28_ = _tmp27_->message;
			g_critical ("TextRenderer.vala:347: %s", _tmp28_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (data);
			_g_object_unref0 (provider);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_g_free0 (data);
		_g_object_unref0 (provider);
	}
	if (x_offset) {
		*x_offset = _vala_x_offset;
	}
	if (y_offset) {
		*y_offset = _vala_y_offset;
	}
	if (focus_rect_width) {
		*focus_rect_width = _vala_focus_rect_width;
	}
	if (focus_rect_height) {
		*focus_rect_height = _vala_focus_rect_height;
	}
}

static void
files_text_renderer_get_offsets (FilesTextRenderer* self,
                                 GdkRectangle* cell_area,
                                 gint width,
                                 gint height,
                                 gint* x_offset,
                                 gint* y_offset)
{
	gint _vala_x_offset = 0;
	gint _vala_y_offset = 0;
	GtkWidget* _tmp0_;
	gfloat _tmp9_;
	gfloat _tmp10_;
	GdkRectangle _tmp11_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cell_area != NULL);
	_tmp0_ = self->priv->widget;
	if (gtk_widget_get_direction (_tmp0_) == GTK_TEXT_DIR_RTL) {
		gfloat _tmp1_;
		gfloat _tmp2_;
		GdkRectangle _tmp3_;
		g_object_get ((GtkCellRenderer*) self, "xalign", &_tmp1_, NULL);
		_tmp2_ = _tmp1_;
		_tmp3_ = *cell_area;
		_vala_x_offset = (gint) ((1.0f - _tmp2_) * (_tmp3_.width - width));
		if (self->priv->is_list_view) {
			gint _tmp4_;
			_tmp4_ = self->priv->_border_radius;
			_vala_x_offset = _vala_x_offset - _tmp4_;
		}
	} else {
		gfloat _tmp5_;
		gfloat _tmp6_;
		GdkRectangle _tmp7_;
		g_object_get ((GtkCellRenderer*) self, "xalign", &_tmp5_, NULL);
		_tmp6_ = _tmp5_;
		_tmp7_ = *cell_area;
		_vala_x_offset = (gint) (_tmp6_ * (_tmp7_.width - width));
		if (self->priv->is_list_view) {
			gint _tmp8_;
			_tmp8_ = self->priv->_border_radius;
			_vala_x_offset = _vala_x_offset + _tmp8_;
		}
	}
	g_object_get ((GtkCellRenderer*) self, "yalign", &_tmp9_, NULL);
	_tmp10_ = _tmp9_;
	_tmp11_ = *cell_area;
	_vala_y_offset = (gint) (_tmp10_ * (_tmp11_.height - height));
	if (!self->priv->is_list_view) {
		gint _tmp12_;
		_tmp12_ = self->priv->_border_radius;
		_vala_y_offset = _vala_y_offset + _tmp12_;
	}
	if (x_offset) {
		*x_offset = _vala_x_offset;
	}
	if (y_offset) {
		*y_offset = _vala_y_offset;
	}
}

static gint
files_text_renderer_get_border_radius (FilesTextRenderer* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_border_radius;
	return result;
}

static void
files_text_renderer_set_border_radius (FilesTextRenderer* self,
                                       gint value)
{
	g_return_if_fail (self != NULL);
	self->priv->_border_radius = value;
}

gint
files_text_renderer_get_double_border_radius (FilesTextRenderer* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_double_border_radius;
	return result;
}

static void
files_text_renderer_set_double_border_radius (FilesTextRenderer* self,
                                              gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = files_text_renderer_get_double_border_radius (self);
	if (old_value != value) {
		self->priv->_double_border_radius = value;
		g_object_notify_by_pspec ((GObject *) self, files_text_renderer_properties[FILES_TEXT_RENDERER_DOUBLE_BORDER_RADIUS_PROPERTY]);
	}
}

FilesZoomLevel
files_text_renderer_get_zoom_level (FilesTextRenderer* self)
{
	FilesZoomLevel result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_zoom_level;
	return result;
}

void
files_text_renderer_set_zoom_level (FilesTextRenderer* self,
                                    FilesZoomLevel value)
{
	FilesIconSize icon_size = 0;
	gint _tmp0_;
	g_return_if_fail (self != NULL);
	icon_size = files_zoom_level_to_icon_size (value);
	files_text_renderer_set_border_radius (self, 5 + (icon_size / 40));
	_tmp0_ = self->priv->_border_radius;
	files_text_renderer_set_double_border_radius (self, 2 * _tmp0_);
	if (self->priv->is_list_view) {
		gtk_cell_renderer_set_fixed_size ((GtkCellRenderer*) self, -1, (gint) icon_size);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		_tmp1_ = files_text_renderer_get_item_width (self);
		_tmp2_ = _tmp1_;
		_tmp3_ = self->priv->_double_border_radius;
		g_object_set ((GtkCellRendererText*) self, "wrap-width", _tmp2_ - _tmp3_, NULL);
	}
	self->priv->_zoom_level = value;
	g_object_notify_by_pspec ((GObject *) self, files_text_renderer_properties[FILES_TEXT_RENDERER_ZOOM_LEVEL_PROPERTY]);
}

static FilesFile*
files_text_renderer_get_file (FilesTextRenderer* self)
{
	FilesFile* result;
	FilesFile* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_file;
	result = _tmp0_;
	return result;
}

void
files_text_renderer_set_file (FilesTextRenderer* self,
                              FilesFile* value)
{
	FilesFile* old_value;
	g_return_if_fail (self != NULL);
	old_value = files_text_renderer_get_file (self);
	if (old_value != value) {
		FilesFile* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_file);
		self->priv->_file = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, files_text_renderer_properties[FILES_TEXT_RENDERER_FILE_PROPERTY]);
	}
}

static gint
files_text_renderer_get_item_width (FilesTextRenderer* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_item_width;
	return result;
}

void
files_text_renderer_set_item_width (FilesTextRenderer* self,
                                    gint value)
{
	g_return_if_fail (self != NULL);
	self->priv->_item_width = value;
	g_object_notify_by_pspec ((GObject *) self, files_text_renderer_properties[FILES_TEXT_RENDERER_ITEM_WIDTH_PROPERTY]);
}

static GObject *
files_text_renderer_constructor (GType type,
                                 guint n_construct_properties,
                                 GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	FilesTextRenderer * self;
	GtkCssProvider* _tmp0_;
	GdkRGBA _tmp1_ = {0};
	GdkRGBA _tmp2_ = {0};
	parent_class = G_OBJECT_CLASS (files_text_renderer_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FILES_TYPE_TEXT_RENDERER, FilesTextRenderer);
	g_object_set ((GtkCellRenderer*) self, "mode", GTK_CELL_RENDERER_MODE_EDITABLE, NULL);
	_tmp0_ = gtk_css_provider_new ();
	_g_object_unref0 (self->priv->text_css);
	self->priv->text_css = _tmp0_;
	_tmp1_.red = (gdouble) 0;
	_tmp1_.green = (gdouble) 0;
	_tmp1_.blue = (gdouble) 0;
	_tmp1_.alpha = (gdouble) 0;
	self->priv->previous_background_rgba = _tmp1_;
	_tmp2_.red = (gdouble) 0;
	_tmp2_.green = (gdouble) 0;
	_tmp2_.blue = (gdouble) 0;
	_tmp2_.alpha = (gdouble) 0;
	self->priv->previous_contrasting_rgba = _tmp2_;
	return obj;
}

static void
files_text_renderer_class_init (FilesTextRendererClass * klass,
                                gpointer klass_data)
{
	files_text_renderer_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &FilesTextRenderer_private_offset);
	((GtkCellRendererClass *) klass)->get_preferred_height_for_width = (void (*) (GtkCellRenderer*, GtkWidget*, gint, gint*, gint*)) files_text_renderer_real_get_preferred_height_for_width;
	((GtkCellRendererClass *) klass)->render = (void (*) (GtkCellRenderer*, cairo_t*, GtkWidget*, GdkRectangle*, GdkRectangle*, GtkCellRendererState)) files_text_renderer_real_render;
	((GtkCellRendererClass *) klass)->start_editing = (GtkCellEditable* (*) (GtkCellRenderer*, GdkEvent*, GtkWidget*, const gchar*, GdkRectangle*, GdkRectangle*, GtkCellRendererState)) files_text_renderer_real_start_editing;
	G_OBJECT_CLASS (klass)->get_property = _vala_files_text_renderer_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_files_text_renderer_set_property;
	G_OBJECT_CLASS (klass)->constructor = files_text_renderer_constructor;
	G_OBJECT_CLASS (klass)->finalize = files_text_renderer_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), FILES_TEXT_RENDERER_DOUBLE_BORDER_RADIUS_PROPERTY, files_text_renderer_properties[FILES_TEXT_RENDERER_DOUBLE_BORDER_RADIUS_PROPERTY] = g_param_spec_int ("double-border-radius", "double-border-radius", "double-border-radius", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FILES_TEXT_RENDERER_ZOOM_LEVEL_PROPERTY, files_text_renderer_properties[FILES_TEXT_RENDERER_ZOOM_LEVEL_PROPERTY] = g_param_spec_enum ("zoom-level", "zoom-level", "zoom-level", FILES_TYPE_ZOOM_LEVEL, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FILES_TEXT_RENDERER_FILE_PROPERTY, files_text_renderer_properties[FILES_TEXT_RENDERER_FILE_PROPERTY] = g_param_spec_object ("file", "file", "file", FILES_TYPE_FILE, G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FILES_TEXT_RENDERER_ITEM_WIDTH_PROPERTY, files_text_renderer_properties[FILES_TEXT_RENDERER_ITEM_WIDTH_PROPERTY] = g_param_spec_int ("item-width", "item-width", "item-width", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE));
}

static void
files_text_renderer_instance_init (FilesTextRenderer * self,
                                   gpointer klass)
{
	self->priv = files_text_renderer_get_instance_private (self);
	self->priv->_item_width = -1;
}

static void
files_text_renderer_finalize (GObject * obj)
{
	FilesTextRenderer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FILES_TYPE_TEXT_RENDERER, FilesTextRenderer);
	_g_object_unref0 (self->priv->text_css);
	_g_object_unref0 (self->priv->_file);
	_g_object_unref0 (self->priv->layout);
	_g_object_unref0 (self->priv->widget);
	_g_object_unref0 (self->priv->entry);
	G_OBJECT_CLASS (files_text_renderer_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
files_text_renderer_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FilesTextRendererClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) files_text_renderer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FilesTextRenderer), 0, (GInstanceInitFunc) files_text_renderer_instance_init, NULL };
	GType files_text_renderer_type_id;
	files_text_renderer_type_id = g_type_register_static (gtk_cell_renderer_text_get_type (), "FilesTextRenderer", &g_define_type_info, 0);
	FilesTextRenderer_private_offset = g_type_add_instance_private (files_text_renderer_type_id, sizeof (FilesTextRendererPrivate));
	return files_text_renderer_type_id;
}

GType
files_text_renderer_get_type (void)
{
	static volatile gsize files_text_renderer_type_id__once = 0;
	if (g_once_init_enter (&files_text_renderer_type_id__once)) {
		GType files_text_renderer_type_id;
		files_text_renderer_type_id = files_text_renderer_get_type_once ();
		g_once_init_leave (&files_text_renderer_type_id__once, files_text_renderer_type_id);
	}
	return files_text_renderer_type_id__once;
}

static void
_vala_files_text_renderer_get_property (GObject * object,
                                        guint property_id,
                                        GValue * value,
                                        GParamSpec * pspec)
{
	FilesTextRenderer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FILES_TYPE_TEXT_RENDERER, FilesTextRenderer);
	switch (property_id) {
		case FILES_TEXT_RENDERER_DOUBLE_BORDER_RADIUS_PROPERTY:
		g_value_set_int (value, files_text_renderer_get_double_border_radius (self));
		break;
		case FILES_TEXT_RENDERER_ZOOM_LEVEL_PROPERTY:
		g_value_set_enum (value, files_text_renderer_get_zoom_level (self));
		break;
		case FILES_TEXT_RENDERER_FILE_PROPERTY:
		g_value_set_object (value, files_text_renderer_get_file (self));
		break;
		case FILES_TEXT_RENDERER_ITEM_WIDTH_PROPERTY:
		g_value_set_int (value, files_text_renderer_get_item_width (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_files_text_renderer_set_property (GObject * object,
                                        guint property_id,
                                        const GValue * value,
                                        GParamSpec * pspec)
{
	FilesTextRenderer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FILES_TYPE_TEXT_RENDERER, FilesTextRenderer);
	switch (property_id) {
		case FILES_TEXT_RENDERER_DOUBLE_BORDER_RADIUS_PROPERTY:
		files_text_renderer_set_double_border_radius (self, g_value_get_int (value));
		break;
		case FILES_TEXT_RENDERER_ZOOM_LEVEL_PROPERTY:
		files_text_renderer_set_zoom_level (self, g_value_get_enum (value));
		break;
		case FILES_TEXT_RENDERER_FILE_PROPERTY:
		files_text_renderer_set_file (self, g_value_get_object (value));
		break;
		case FILES_TEXT_RENDERER_ITEM_WIDTH_PROPERTY:
		files_text_renderer_set_item_width (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

