/* marlind-tagging.c generated by valac 0.56.18, the Vala compiler
 * generated from marlind-tagging.vala, do not modify */

/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 * Copyright (c) 2010 Jordi Puigdellívol <jordi@gloobus.net>
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License
 * version 3.0 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3.0 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see
 * <http://www.gnu.org/licenses/>.
 *
 * Authors: Jordi Puigdellívol <jordi@gloobus.net>
 *          ammonkey <am.monkeyd@gmail.com>
 *

 Marlin Tagging system

//Dependences
libsqlite3-dev

//To create de table
create table tags (uri TEXT, color INT, tags TEXT);

//To compile this sample
valac --pkg sqlite3 -o sqlitesample SqliteSample.vala
valac --pkg sqlite3 --pkg gio-2.0 -o sqlitesample marlin_tagging.vala && ./sqlitesample

*/
/* This is being replaced by storing color info in file metadata but will be kept for a while to provide
 * transparent transfer of data */

#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <sqlite3.h>
#include <stdio.h>
#include "pantheon-files-core.h"

#define MARLIN_TAGS_CMD "INSERT OR REPLACE INTO tags (uri, content_type, color, modified_time, " \
"dir) " "VALUES ('%s', '%s', %s, %s, '%s');\n"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_MARLIN_TAGS (marlin_tags_get_type ())
#define MARLIN_TAGS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MARLIN_TAGS, MarlinTags))
#define MARLIN_TAGS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MARLIN_TAGS, MarlinTagsClass))
#define IS_MARLIN_TAGS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MARLIN_TAGS))
#define IS_MARLIN_TAGS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MARLIN_TAGS))
#define MARLIN_TAGS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MARLIN_TAGS, MarlinTagsClass))

typedef struct _MarlinTags MarlinTags;
typedef struct _MarlinTagsClass MarlinTagsClass;
typedef struct _MarlinTagsPrivate MarlinTagsPrivate;
enum  {
	MARLIN_TAGS_0_PROPERTY,
	MARLIN_TAGS_NUM_PROPERTIES
};
static GParamSpec* marlin_tags_properties[MARLIN_TAGS_NUM_PROPERTIES];
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _sqlite3_close0(var) ((var == NULL) ? NULL : (var = (sqlite3_close (var), NULL)))
#define _sqlite3_finalize0(var) ((var == NULL) ? NULL : (var = (sqlite3_finalize (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_variant_iter_free0(var) ((var == NULL) ? NULL : (var = (g_variant_iter_free (var), NULL)))
typedef struct _MarlinTagsRecordUrisData MarlinTagsRecordUrisData;
#define _g_variant_type_free0(var) ((var == NULL) ? NULL : (var = (g_variant_type_free (var), NULL)))
#define _g_variant_builder_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_builder_unref (var), NULL)))
typedef struct _MarlinTagsGetUriInfosData MarlinTagsGetUriInfosData;
typedef struct _MarlinTagsDeleteEntryData MarlinTagsDeleteEntryData;
typedef struct _MarlinTagsRecordUrisReadyData MarlinTagsRecordUrisReadyData;
typedef struct _MarlinTagsGetUriInfosReadyData MarlinTagsGetUriInfosReadyData;
typedef struct _MarlinTagsDeleteEntryReadyData MarlinTagsDeleteEntryReadyData;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _MarlinTags {
	GObject parent_instance;
	MarlinTagsPrivate * priv;
};

struct _MarlinTagsClass {
	GObjectClass parent_class;
};

struct _MarlinTagsRecordUrisData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	MarlinTags* self;
	GVariant** locations;
	gint locations_length1;
	gboolean result;
	gchar* sql;
	gchar* _tmp0_;
	GVariant** location_variant_collection;
	gint location_variant_collection_length1;
	gint _location_variant_collection_size_;
	gint location_variant_it;
	GVariant* _tmp1_;
	GVariant* location_variant;
	GVariantIter* iter;
	GVariant* _tmp2_;
	GVariantIter* _tmp3_;
	gchar* raw_uri;
	GVariantIter* _tmp4_;
	GVariant* _tmp5_;
	GVariant* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* uri;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* directory;
	const gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* content_type;
	GVariantIter* _tmp17_;
	GVariant* _tmp18_;
	GVariant* _tmp19_;
	const gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	gchar* modified_time;
	GVariantIter* _tmp23_;
	GVariant* _tmp24_;
	GVariant* _tmp25_;
	const gchar* _tmp26_;
	gchar* _tmp27_;
	gchar* _tmp28_;
	gchar* color;
	GVariantIter* _tmp29_;
	GVariant* _tmp30_;
	GVariant* _tmp31_;
	const gchar* _tmp32_;
	gchar* _tmp33_;
	gchar* _tmp34_;
	const gchar* _tmp35_;
	const gchar* _tmp36_;
	const gchar* _tmp37_;
	const gchar* _tmp38_;
	const gchar* _tmp39_;
	const gchar* _tmp40_;
	gchar* _tmp41_;
	gchar* _tmp42_;
	gchar* _tmp43_;
	gint rc;
	sqlite3* _tmp44_;
	const gchar* _tmp45_;
	const gchar* _tmp46_;
	sqlite3* _tmp47_;
	const gchar* _tmp48_;
};

struct _MarlinTagsGetUriInfosData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	MarlinTags* self;
	gchar* raw_uri;
	GVariant* result;
	gchar* uri;
	gchar* _tmp0_;
	sqlite3_stmt* stmt;
	GVariantBuilder* vb;
	GVariantType* _tmp1_;
	GVariantType* _tmp2_;
	GVariantBuilder* _tmp3_;
	GVariantBuilder* _tmp4_;
	gint rc;
	sqlite3* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	sqlite3_stmt* _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	sqlite3_stmt* _tmp12_;
	GVariantBuilder* _tmp13_;
	GVariantType* _tmp14_;
	GVariantType* _tmp15_;
	GVariantBuilder* _tmp16_;
	sqlite3_stmt* _tmp17_;
	const gchar* _tmp18_;
	gchar* content_type;
	sqlite3_stmt* _tmp19_;
	const gchar* _tmp20_;
	gchar* _tmp21_;
	const gchar* _tmp22_;
	const gchar* _tmp23_;
	const gchar* _tmp24_;
	GVariantBuilder* _tmp25_;
	GVariantBuilder* _tmp26_;
	sqlite3_stmt* _tmp27_;
	const gchar* _tmp28_;
	sqlite3* _tmp29_;
	const gchar* _tmp30_;
	GVariantBuilder* _tmp31_;
	GVariantBuilder* _tmp32_;
	GVariant* _tmp33_;
};

struct _MarlinTagsDeleteEntryData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	MarlinTags* self;
	gchar* uri;
	gboolean result;
	gchar* c;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gint rc;
	sqlite3* _tmp4_;
	const gchar* _tmp5_;
	sqlite3* _tmp6_;
	const gchar* _tmp7_;
};

struct _MarlinTagsRecordUrisReadyData {
	GDBusMethodInvocation* _invocation_;
	GVariant** locations;
	gint locations_length1;
};

struct _MarlinTagsGetUriInfosReadyData {
	GDBusMethodInvocation* _invocation_;
	gchar* raw_uri;
};

struct _MarlinTagsDeleteEntryReadyData {
	GDBusMethodInvocation* _invocation_;
	gchar* uri;
};

static gpointer marlin_tags_parent_class = NULL;
VALA_EXTERN sqlite3* marlin_tags_db;
sqlite3* marlin_tags_db = NULL;

VALA_EXTERN GType marlin_tags_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MarlinTags, g_object_unref)
VALA_EXTERN guint marlin_tags_register_object (void* object,
                                   GDBusConnection* connection,
                                   const gchar* path,
                                   GError** error);
VALA_EXTERN MarlinTags* marlin_tags_new (void);
VALA_EXTERN MarlinTags* marlin_tags_construct (GType object_type);
VALA_EXTERN gboolean marlin_tags_open_marlin_db (MarlinTags* self,
                                     GError** error);
VALA_EXTERN void marlin_tags_fatal (const gchar* op,
                        gint res);
static gint marlin_tags_show_table_callback (gint n_columns,
                                      gchar** values,
                                      gint values_length1,
                                      gchar** column_names,
                                      gint column_names_length1);
static gboolean marlin_tags_open_db (MarlinTags* self,
                              const gchar* dbpath);
static void marlin_tags_upgrade_database (MarlinTags* self);
static void marlin_tags_record_uris_data_free (gpointer _data);
VALA_EXTERN void marlin_tags_record_uris (MarlinTags* self,
                              GVariant** locations,
                              gint locations_length1,
                              GAsyncReadyCallback _callback_,
                              gpointer _user_data_);
VALA_EXTERN gboolean marlin_tags_record_uris_finish (MarlinTags* self,
                                         GAsyncResult* _res_,
                                         GError** error);
static gboolean marlin_tags_record_uris_co (MarlinTagsRecordUrisData* _data_);
static gchar* marlin_tags_escape (MarlinTags* self,
                           const gchar* input);
static void marlin_tags_get_uri_infos_data_free (gpointer _data);
VALA_EXTERN void marlin_tags_get_uri_infos (MarlinTags* self,
                                const gchar* raw_uri,
                                GAsyncReadyCallback _callback_,
                                gpointer _user_data_);
VALA_EXTERN GVariant* marlin_tags_get_uri_infos_finish (MarlinTags* self,
                                            GAsyncResult* _res_,
                                            GError** error);
static gboolean marlin_tags_get_uri_infos_co (MarlinTagsGetUriInfosData* _data_);
static gboolean _marlin_tags_get_uri_infos_co_gsource_func (gpointer self);
static void marlin_tags_delete_entry_data_free (gpointer _data);
VALA_EXTERN void marlin_tags_delete_entry (MarlinTags* self,
                               const gchar* uri,
                               GAsyncReadyCallback _callback_,
                               gpointer _user_data_);
VALA_EXTERN gboolean marlin_tags_delete_entry_finish (MarlinTags* self,
                                          GAsyncResult* _res_,
                                          GError** error);
static gboolean marlin_tags_delete_entry_co (MarlinTagsDeleteEntryData* _data_);
static gboolean _marlin_tags_delete_entry_co_gsource_func (gpointer self);
VALA_EXTERN gboolean marlin_tags_show_table (MarlinTags* self,
                                 const gchar* table,
                                 GError** error);
static gint _marlin_tags_show_table_callback_sqlite3_callback (gpointer self,
                                                        gint n_columns,
                                                        gchar** values,
                                                        gchar** column_names);
VALA_EXTERN gboolean marlin_tags_clear_db (MarlinTags* self,
                               GError** error);
static gboolean marlin_tags_has_column (MarlinTags* self,
                                 const gchar* table_name,
                                 const gchar* column_name);
static gboolean marlin_tags_add_column (MarlinTags* self,
                                 const gchar* table_name,
                                 const gchar* column_name,
                                 const gchar* column_constraints);
static void marlin_tags_finalize (GObject * obj);
static GType marlin_tags_get_type_once (void);
static void _dbus_marlin_tags_open_marlin_db (MarlinTags* self,
                                       GVariant* _parameters_,
                                       GDBusMethodInvocation* invocation);
static void _dbus_marlin_tags_record_uris (MarlinTags* self,
                                    GVariant* _parameters_,
                                    GDBusMethodInvocation* invocation);
static void _dbus_marlin_tags_record_uris_ready (GObject * source_object,
                                          GAsyncResult * _res_,
                                          gpointer _user_data_);
static void _dbus_marlin_tags_get_uri_infos (MarlinTags* self,
                                      GVariant* _parameters_,
                                      GDBusMethodInvocation* invocation);
static void _dbus_marlin_tags_get_uri_infos_ready (GObject * source_object,
                                            GAsyncResult * _res_,
                                            gpointer _user_data_);
static void _dbus_marlin_tags_delete_entry (MarlinTags* self,
                                     GVariant* _parameters_,
                                     GDBusMethodInvocation* invocation);
static void _dbus_marlin_tags_delete_entry_ready (GObject * source_object,
                                           GAsyncResult * _res_,
                                           gpointer _user_data_);
static void _dbus_marlin_tags_show_table (MarlinTags* self,
                                   GVariant* _parameters_,
                                   GDBusMethodInvocation* invocation);
static void _dbus_marlin_tags_clear_db (MarlinTags* self,
                                 GVariant* _parameters_,
                                 GDBusMethodInvocation* invocation);
static void marlin_tags_dbus_interface_method_call (GDBusConnection* connection,
                                             const gchar* sender,
                                             const gchar* object_path,
                                             const gchar* interface_name,
                                             const gchar* method_name,
                                             GVariant* parameters,
                                             GDBusMethodInvocation* invocation,
                                             gpointer user_data);
static GVariant* marlin_tags_dbus_interface_get_property (GDBusConnection* connection,
                                                   const gchar* sender,
                                                   const gchar* object_path,
                                                   const gchar* interface_name,
                                                   const gchar* property_name,
                                                   GError** error,
                                                   gpointer user_data);
static gboolean marlin_tags_dbus_interface_set_property (GDBusConnection* connection,
                                                  const gchar* sender,
                                                  const gchar* object_path,
                                                  const gchar* interface_name,
                                                  const gchar* property_name,
                                                  GVariant* value,
                                                  GError** error,
                                                  gpointer user_data);
static void _marlin_tags_unregister_object (gpointer user_data);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static const GDBusArgInfo _marlin_tags_dbus_arg_info_open_marlin_db_result = {-1, "result", "b", NULL};
static const GDBusArgInfo * const _marlin_tags_dbus_arg_info_open_marlin_db_in[] = {NULL};
static const GDBusArgInfo * const _marlin_tags_dbus_arg_info_open_marlin_db_out[] = {&_marlin_tags_dbus_arg_info_open_marlin_db_result, NULL};
static const GDBusMethodInfo _marlin_tags_dbus_method_info_open_marlin_db = {-1, "OpenMarlinDb", (GDBusArgInfo **) (&_marlin_tags_dbus_arg_info_open_marlin_db_in), (GDBusArgInfo **) (&_marlin_tags_dbus_arg_info_open_marlin_db_out), NULL};
static const GDBusArgInfo _marlin_tags_dbus_arg_info_record_uris_locations = {-1, "locations", "av", NULL};
static const GDBusArgInfo _marlin_tags_dbus_arg_info_record_uris_result = {-1, "result", "b", NULL};
static const GDBusArgInfo * const _marlin_tags_dbus_arg_info_record_uris_in[] = {&_marlin_tags_dbus_arg_info_record_uris_locations, NULL};
static const GDBusArgInfo * const _marlin_tags_dbus_arg_info_record_uris_out[] = {&_marlin_tags_dbus_arg_info_record_uris_result, NULL};
static const GDBusMethodInfo _marlin_tags_dbus_method_info_record_uris = {-1, "RecordUris", (GDBusArgInfo **) (&_marlin_tags_dbus_arg_info_record_uris_in), (GDBusArgInfo **) (&_marlin_tags_dbus_arg_info_record_uris_out), NULL};
static const GDBusArgInfo _marlin_tags_dbus_arg_info_get_uri_infos_raw_uri = {-1, "raw_uri", "s", NULL};
static const GDBusArgInfo _marlin_tags_dbus_arg_info_get_uri_infos_result = {-1, "result", "v", NULL};
static const GDBusArgInfo * const _marlin_tags_dbus_arg_info_get_uri_infos_in[] = {&_marlin_tags_dbus_arg_info_get_uri_infos_raw_uri, NULL};
static const GDBusArgInfo * const _marlin_tags_dbus_arg_info_get_uri_infos_out[] = {&_marlin_tags_dbus_arg_info_get_uri_infos_result, NULL};
static const GDBusMethodInfo _marlin_tags_dbus_method_info_get_uri_infos = {-1, "GetUriInfos", (GDBusArgInfo **) (&_marlin_tags_dbus_arg_info_get_uri_infos_in), (GDBusArgInfo **) (&_marlin_tags_dbus_arg_info_get_uri_infos_out), NULL};
static const GDBusArgInfo _marlin_tags_dbus_arg_info_delete_entry_uri = {-1, "uri", "s", NULL};
static const GDBusArgInfo _marlin_tags_dbus_arg_info_delete_entry_result = {-1, "result", "b", NULL};
static const GDBusArgInfo * const _marlin_tags_dbus_arg_info_delete_entry_in[] = {&_marlin_tags_dbus_arg_info_delete_entry_uri, NULL};
static const GDBusArgInfo * const _marlin_tags_dbus_arg_info_delete_entry_out[] = {&_marlin_tags_dbus_arg_info_delete_entry_result, NULL};
static const GDBusMethodInfo _marlin_tags_dbus_method_info_delete_entry = {-1, "DeleteEntry", (GDBusArgInfo **) (&_marlin_tags_dbus_arg_info_delete_entry_in), (GDBusArgInfo **) (&_marlin_tags_dbus_arg_info_delete_entry_out), NULL};
static const GDBusArgInfo _marlin_tags_dbus_arg_info_show_table_table = {-1, "table", "s", NULL};
static const GDBusArgInfo _marlin_tags_dbus_arg_info_show_table_result = {-1, "result", "b", NULL};
static const GDBusArgInfo * const _marlin_tags_dbus_arg_info_show_table_in[] = {&_marlin_tags_dbus_arg_info_show_table_table, NULL};
static const GDBusArgInfo * const _marlin_tags_dbus_arg_info_show_table_out[] = {&_marlin_tags_dbus_arg_info_show_table_result, NULL};
static const GDBusMethodInfo _marlin_tags_dbus_method_info_show_table = {-1, "ShowTable", (GDBusArgInfo **) (&_marlin_tags_dbus_arg_info_show_table_in), (GDBusArgInfo **) (&_marlin_tags_dbus_arg_info_show_table_out), NULL};
static const GDBusArgInfo _marlin_tags_dbus_arg_info_clear_db_result = {-1, "result", "b", NULL};
static const GDBusArgInfo * const _marlin_tags_dbus_arg_info_clear_db_in[] = {NULL};
static const GDBusArgInfo * const _marlin_tags_dbus_arg_info_clear_db_out[] = {&_marlin_tags_dbus_arg_info_clear_db_result, NULL};
static const GDBusMethodInfo _marlin_tags_dbus_method_info_clear_db = {-1, "ClearDb", (GDBusArgInfo **) (&_marlin_tags_dbus_arg_info_clear_db_in), (GDBusArgInfo **) (&_marlin_tags_dbus_arg_info_clear_db_out), NULL};
static const GDBusMethodInfo * const _marlin_tags_dbus_method_info[] = {&_marlin_tags_dbus_method_info_open_marlin_db, &_marlin_tags_dbus_method_info_record_uris, &_marlin_tags_dbus_method_info_get_uri_infos, &_marlin_tags_dbus_method_info_delete_entry, &_marlin_tags_dbus_method_info_show_table, &_marlin_tags_dbus_method_info_clear_db, NULL};
static const GDBusSignalInfo * const _marlin_tags_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo * const _marlin_tags_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _marlin_tags_dbus_interface_info = {-1, "io.elementary.files.db", (GDBusMethodInfo **) (&_marlin_tags_dbus_method_info), (GDBusSignalInfo **) (&_marlin_tags_dbus_signal_info), (GDBusPropertyInfo **) (&_marlin_tags_dbus_property_info), NULL};
static const GDBusInterfaceVTable _marlin_tags_dbus_interface_vtable = {marlin_tags_dbus_interface_method_call, marlin_tags_dbus_interface_get_property, marlin_tags_dbus_interface_set_property};

MarlinTags*
marlin_tags_construct (GType object_type)
{
	MarlinTags * self = NULL;
	GError* _inner_error0_ = NULL;
	self = (MarlinTags*) g_object_new (object_type, NULL);
	{
		marlin_tags_open_marlin_db (self, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp0_;
		const gchar* _tmp1_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp0_ = e;
		_tmp1_ = _tmp0_->message;
		g_critical ("marlind-tagging.vala:48: Unable to open color tag database: %s", _tmp1_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	return self;
}

MarlinTags*
marlin_tags_new (void)
{
	return marlin_tags_construct (TYPE_MARLIN_TAGS);
}

void
marlin_tags_fatal (const gchar* op,
                   gint res)
{
	sqlite3* _tmp0_;
	const gchar* _tmp1_;
	g_return_if_fail (op != NULL);
	_tmp0_ = marlin_tags_db;
	_tmp1_ = sqlite3_errmsg (_tmp0_);
	g_error ("marlind-tagging.vala:53: %s: [%d] %s", op, res, _tmp1_);
}

static gint
marlin_tags_show_table_callback (gint n_columns,
                                 gchar** values,
                                 gint values_length1,
                                 gchar** column_names,
                                 gint column_names_length1)
{
	FILE* _tmp5_;
	gint result;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				FILE* _tmp2_;
				const gchar* _tmp3_;
				const gchar* _tmp4_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				if (!(i < n_columns)) {
					break;
				}
				_tmp2_ = stdout;
				_tmp3_ = column_names[i];
				_tmp4_ = values[i];
				fprintf (_tmp2_, "%s = %s\n", _tmp3_, _tmp4_);
			}
		}
	}
	_tmp5_ = stdout;
	fprintf (_tmp5_, "\n");
	result = 0;
	return result;
}

gboolean
marlin_tags_open_marlin_db (MarlinTags* self,
                            GError** error)
{
	GFile* home_dir = NULL;
	const gchar* _tmp0_;
	GFile* _tmp1_;
	GFile* data_dir = NULL;
	GFile* _tmp2_;
	GFile* _tmp3_;
	GFile* _tmp4_;
	GFile* _tmp5_;
	GFile* _tmp6_;
	gchar* marlin_db_path = NULL;
	GFile* _tmp18_;
	GFile* _tmp19_;
	GFile* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = g_get_home_dir ();
	_tmp1_ = g_file_new_for_path (_tmp0_);
	home_dir = _tmp1_;
	_tmp2_ = home_dir;
	_tmp3_ = g_file_get_child (_tmp2_, ".config");
	_tmp4_ = _tmp3_;
	_tmp5_ = g_file_get_child (_tmp4_, "marlin");
	_tmp6_ = _tmp5_;
	_g_object_unref0 (_tmp4_);
	data_dir = _tmp6_;
	{
		GFile* _tmp7_;
		_tmp7_ = data_dir;
		if (!g_file_query_exists (_tmp7_, NULL)) {
			GFile* _tmp8_;
			_tmp8_ = data_dir;
			g_file_make_directory_with_parents (_tmp8_, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GFile* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		GError* _tmp12_;
		const gchar* _tmp13_;
		GError* _tmp14_;
		GError* _tmp15_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp9_ = data_dir;
		_tmp10_ = g_file_get_path (_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp12_ = err;
		_tmp13_ = _tmp12_->message;
		_tmp14_ = g_error_new (G_IO_ERROR, G_IO_ERROR_FAILED, "Unable to create data directory %s: %s", _tmp11_, _tmp13_);
		_tmp15_ = _tmp14_;
		_g_free0 (_tmp11_);
		_inner_error0_ = _tmp15_;
		_g_error_free0 (err);
		goto __finally0;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if ((_inner_error0_->domain == G_DBUS_ERROR) || (_inner_error0_->domain == G_IO_ERROR)) {
			gboolean _tmp16_ = FALSE;
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (data_dir);
			_g_object_unref0 (home_dir);
			return _tmp16_;
		} else {
			gboolean _tmp17_ = FALSE;
			_g_object_unref0 (data_dir);
			_g_object_unref0 (home_dir);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp17_;
		}
	}
	_tmp18_ = data_dir;
	_tmp19_ = g_file_get_child (_tmp18_, "marlin.db");
	_tmp20_ = _tmp19_;
	_tmp21_ = g_file_get_path (_tmp20_);
	_tmp22_ = _tmp21_;
	_g_object_unref0 (_tmp20_);
	marlin_db_path = _tmp22_;
	g_message ("marlind-tagging.vala:80: Database path: %s \n", marlin_db_path);
	marlin_tags_open_db (self, marlin_db_path);
	result = TRUE;
	_g_free0 (marlin_db_path);
	_g_object_unref0 (data_dir);
	_g_object_unref0 (home_dir);
	return result;
}

static gint
_sqlite3_exec (sqlite3* self,
               const gchar* sql,
               sqlite3_callback callback,
               gpointer callback_target,
               gchar** errmsg)
{
	gchar* _vala_errmsg = NULL;
	const gchar* sqlite_errmsg = NULL;
	gint ec = 0;
	const gchar* _tmp0_ = NULL;
	gint _tmp1_;
	const gchar* _tmp4_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (sql != NULL, 0);
	_tmp1_ = sqlite3_exec (self, sql, callback, callback_target, (char**) (&_tmp0_));
	sqlite_errmsg = _tmp0_;
	ec = _tmp1_;
	if ((&_vala_errmsg) != NULL) {
		const gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp2_ = sqlite_errmsg;
		_tmp3_ = g_strdup (_tmp2_);
		_g_free0 (_vala_errmsg);
		_vala_errmsg = _tmp3_;
	} else {
		_g_free0 (_vala_errmsg);
		_vala_errmsg = NULL;
	}
	_tmp4_ = sqlite_errmsg;
	sqlite3_free ((void*) _tmp4_);
	result = ec;
	if (errmsg) {
		*errmsg = _vala_errmsg;
	} else {
		_g_free0 (_vala_errmsg);
	}
	return result;
}

static gboolean
marlin_tags_open_db (MarlinTags* self,
                     const gchar* dbpath)
{
	gint rc = 0;
	sqlite3* _tmp0_ = NULL;
	gint _tmp1_;
	sqlite3* _tmp4_;
	sqlite3_stmt* stmt = NULL;
	gint res = 0;
	sqlite3* _tmp7_;
	sqlite3_stmt* _tmp8_ = NULL;
	gint _tmp9_;
	sqlite3_stmt* _tmp10_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (dbpath != NULL, FALSE);
	_tmp1_ = sqlite3_open_v2 (dbpath, &_tmp0_, SQLITE_OPEN_READWRITE | SQLITE_OPEN_CREATE, NULL);
	_sqlite3_close0 (marlin_tags_db);
	marlin_tags_db = _tmp0_;
	rc = _tmp1_;
	if (rc != SQLITE_OK) {
		sqlite3* _tmp2_;
		const gchar* _tmp3_;
		_tmp2_ = marlin_tags_db;
		_tmp3_ = sqlite3_errmsg (_tmp2_);
		g_warning ("marlind-tagging.vala:90: Can't open database: %d, %s\n", rc, _tmp3_);
		result = FALSE;
		return result;
	}
	_tmp4_ = marlin_tags_db;
	rc = _sqlite3_exec (_tmp4_, "PRAGMA synchronous=OFF", NULL, NULL, NULL);
	if (rc != SQLITE_OK) {
		sqlite3* _tmp5_;
		const gchar* _tmp6_;
		_tmp5_ = marlin_tags_db;
		_tmp6_ = sqlite3_errmsg (_tmp5_);
		g_warning ("marlind-tagging.vala:98: Unable to disable synchronous mode %d, %s\n", rc, _tmp6_);
	}
	_tmp7_ = marlin_tags_db;
	_tmp9_ = sqlite3_prepare_v2 (_tmp7_, "CREATE TABLE IF NOT EXISTS tags (" "id INTEGER PRIMARY KEY, " "uri TEXT UNIQUE NOT NULL, " "color INTEGER DEFAULT 0, " "tags TEXT NULL, " "content_type TEXT, " "modified_time INTEGER DEFAULT 0, " "dir TEXT " ")", -1, &_tmp8_, NULL);
	_sqlite3_finalize0 (stmt);
	stmt = _tmp8_;
	res = _tmp9_;
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp10_ = stmt;
	res = sqlite3_step (_tmp10_);
	if (res != SQLITE_DONE) {
		marlin_tags_fatal ("create tags table", res);
	}
	marlin_tags_upgrade_database (self);
	result = TRUE;
	_sqlite3_finalize0 (stmt);
	return result;
}

static void
marlin_tags_record_uris_data_free (gpointer _data)
{
	MarlinTagsRecordUrisData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (MarlinTagsRecordUrisData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
marlin_tags_record_uris (MarlinTags* self,
                         GVariant** locations,
                         gint locations_length1,
                         GAsyncReadyCallback _callback_,
                         gpointer _user_data_)
{
	MarlinTagsRecordUrisData* _data_;
	MarlinTags* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (MarlinTagsRecordUrisData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, marlin_tags_record_uris_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_data_->locations = locations;
	_data_->locations_length1 = locations_length1;
	marlin_tags_record_uris_co (_data_);
}

gboolean
marlin_tags_record_uris_finish (MarlinTags* self,
                                GAsyncResult* _res_,
                                GError** error)
{
	gboolean result;
	MarlinTagsRecordUrisData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		gboolean _tmp0_ = FALSE;
		return _tmp0_;
	}
	result = _data_->result;
	return result;
}

static gpointer
_g_variant_ref0 (gpointer self)
{
	return self ? g_variant_ref (self) : NULL;
}

static gboolean
marlin_tags_record_uris_co (MarlinTagsRecordUrisData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = g_strdup ("");
	_data_->sql = _data_->_tmp0_;
	{
		_data_->location_variant_collection_length1 = 0;
		_data_->_location_variant_collection_size_ = 0;
		_data_->location_variant_collection = _data_->locations;
		_data_->location_variant_collection_length1 = _data_->locations_length1;
		for (_data_->location_variant_it = 0; _data_->location_variant_it < _data_->location_variant_collection_length1; _data_->location_variant_it = _data_->location_variant_it + 1) {
			_data_->_tmp1_ = _g_variant_ref0 (_data_->location_variant_collection[_data_->location_variant_it]);
			_data_->location_variant = _data_->_tmp1_;
			{
				_data_->_tmp2_ = _data_->location_variant;
				_data_->_tmp3_ = g_variant_iter_new (_data_->_tmp2_);
				_data_->iter = _data_->_tmp3_;
				_data_->_tmp4_ = _data_->iter;
				_data_->_tmp5_ = g_variant_iter_next_value (_data_->_tmp4_);
				_data_->_tmp6_ = _data_->_tmp5_;
				_data_->_tmp7_ = g_variant_get_string (_data_->_tmp6_, NULL);
				_data_->_tmp8_ = g_strdup (_data_->_tmp7_);
				_data_->_tmp9_ = _data_->_tmp8_;
				_g_variant_unref0 (_data_->_tmp6_);
				_data_->raw_uri = _data_->_tmp9_;
				_data_->_tmp10_ = _data_->raw_uri;
				_data_->_tmp11_ = marlin_tags_escape (_data_->self, _data_->_tmp10_);
				_data_->uri = _data_->_tmp11_;
				_data_->_tmp12_ = _data_->raw_uri;
				_data_->_tmp13_ = files_file_utils_get_parent_path_from_path (_data_->_tmp12_, TRUE);
				_data_->_tmp14_ = _data_->_tmp13_;
				_data_->_tmp15_ = marlin_tags_escape (_data_->self, _data_->_tmp14_);
				_data_->_tmp16_ = _data_->_tmp15_;
				_g_free0 (_data_->_tmp14_);
				_data_->directory = _data_->_tmp16_;
				_data_->_tmp17_ = _data_->iter;
				_data_->_tmp18_ = g_variant_iter_next_value (_data_->_tmp17_);
				_data_->_tmp19_ = _data_->_tmp18_;
				_data_->_tmp20_ = g_variant_get_string (_data_->_tmp19_, NULL);
				_data_->_tmp21_ = g_strdup (_data_->_tmp20_);
				_data_->_tmp22_ = _data_->_tmp21_;
				_g_variant_unref0 (_data_->_tmp19_);
				_data_->content_type = _data_->_tmp22_;
				_data_->_tmp23_ = _data_->iter;
				_data_->_tmp24_ = g_variant_iter_next_value (_data_->_tmp23_);
				_data_->_tmp25_ = _data_->_tmp24_;
				_data_->_tmp26_ = g_variant_get_string (_data_->_tmp25_, NULL);
				_data_->_tmp27_ = g_strdup (_data_->_tmp26_);
				_data_->_tmp28_ = _data_->_tmp27_;
				_g_variant_unref0 (_data_->_tmp25_);
				_data_->modified_time = _data_->_tmp28_;
				_data_->_tmp29_ = _data_->iter;
				_data_->_tmp30_ = g_variant_iter_next_value (_data_->_tmp29_);
				_data_->_tmp31_ = _data_->_tmp30_;
				_data_->_tmp32_ = g_variant_get_string (_data_->_tmp31_, NULL);
				_data_->_tmp33_ = g_strdup (_data_->_tmp32_);
				_data_->_tmp34_ = _data_->_tmp33_;
				_g_variant_unref0 (_data_->_tmp31_);
				_data_->color = _data_->_tmp34_;
				_data_->_tmp35_ = _data_->sql;
				_data_->_tmp36_ = _data_->uri;
				_data_->_tmp37_ = _data_->content_type;
				_data_->_tmp38_ = _data_->color;
				_data_->_tmp39_ = _data_->modified_time;
				_data_->_tmp40_ = _data_->directory;
				_data_->_tmp41_ = g_strdup_printf (MARLIN_TAGS_CMD, _data_->_tmp36_, _data_->_tmp37_, _data_->_tmp38_, _data_->_tmp39_, _data_->_tmp40_);
				_data_->_tmp42_ = _data_->_tmp41_;
				_data_->_tmp43_ = g_strconcat (_data_->_tmp35_, _data_->_tmp42_, NULL);
				_g_free0 (_data_->sql);
				_data_->sql = _data_->_tmp43_;
				_g_free0 (_data_->_tmp42_);
				_g_free0 (_data_->color);
				_g_free0 (_data_->modified_time);
				_g_free0 (_data_->content_type);
				_g_free0 (_data_->directory);
				_g_free0 (_data_->uri);
				_g_free0 (_data_->raw_uri);
				_g_variant_iter_free0 (_data_->iter);
				_g_variant_unref0 (_data_->location_variant);
			}
		}
	}
	_data_->_tmp44_ = marlin_tags_db;
	_data_->_tmp45_ = _data_->sql;
	_data_->rc = _sqlite3_exec (_data_->_tmp44_, _data_->_tmp45_, NULL, NULL, NULL);
	if (_data_->rc != SQLITE_OK) {
		_data_->_tmp46_ = _data_->sql;
		_data_->_tmp47_ = marlin_tags_db;
		_data_->_tmp48_ = sqlite3_errmsg (_data_->_tmp47_);
		g_warning ("marlind-tagging.vala:143: [record_uri: SQL error]  %d, %s, %s\n", _data_->rc, _data_->_tmp46_, _data_->_tmp48_);
		_data_->result = FALSE;
		_g_free0 (_data_->sql);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->result = TRUE;
	_g_free0 (_data_->sql);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static gchar*
marlin_tags_escape (MarlinTags* self,
                    const gchar* input)
{
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (input != NULL, NULL);
	_tmp0_ = files_file_utils_escape_uri (input, TRUE, FALSE);
	result = _tmp0_;
	return result;
}

static void
marlin_tags_get_uri_infos_data_free (gpointer _data)
{
	MarlinTagsGetUriInfosData* _data_;
	_data_ = _data;
	_g_free0 (_data_->raw_uri);
	_g_variant_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (MarlinTagsGetUriInfosData, _data_);
}

void
marlin_tags_get_uri_infos (MarlinTags* self,
                           const gchar* raw_uri,
                           GAsyncReadyCallback _callback_,
                           gpointer _user_data_)
{
	MarlinTagsGetUriInfosData* _data_;
	MarlinTags* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (raw_uri != NULL);
	_data_ = g_slice_new0 (MarlinTagsGetUriInfosData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, marlin_tags_get_uri_infos_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (raw_uri);
	_g_free0 (_data_->raw_uri);
	_data_->raw_uri = _tmp1_;
	marlin_tags_get_uri_infos_co (_data_);
}

GVariant*
marlin_tags_get_uri_infos_finish (MarlinTags* self,
                                  GAsyncResult* _res_,
                                  GError** error)
{
	GVariant* result;
	MarlinTagsGetUriInfosData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static gboolean
_marlin_tags_get_uri_infos_co_gsource_func (gpointer self)
{
	gboolean result;
	result = marlin_tags_get_uri_infos_co (self);
	return result;
}

static gboolean
marlin_tags_get_uri_infos_co (MarlinTagsGetUriInfosData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _marlin_tags_get_uri_infos_co_gsource_func, _data_, NULL);
	_data_->_state_ = 1;
	return FALSE;
	_state_1:
	;
	_data_->_tmp0_ = marlin_tags_escape (_data_->self, _data_->raw_uri);
	_data_->uri = _data_->_tmp0_;
	_data_->_tmp1_ = g_variant_type_new ("(as)");
	_data_->_tmp2_ = _data_->_tmp1_;
	_data_->_tmp3_ = g_variant_builder_new (_data_->_tmp2_);
	_data_->_tmp4_ = _data_->_tmp3_;
	_g_variant_type_free0 (_data_->_tmp2_);
	_data_->vb = _data_->_tmp4_;
	_data_->_tmp5_ = marlin_tags_db;
	_data_->_tmp6_ = _data_->uri;
	_data_->_tmp7_ = g_strdup_printf ("select modified_time, content_type, color from tags where uri='%s'", _data_->_tmp6_);
	_data_->_tmp8_ = _data_->_tmp7_;
	_data_->_tmp9_ = NULL;
	_data_->_tmp10_ = sqlite3_prepare_v2 (_data_->_tmp5_, _data_->_tmp8_, -1, &_data_->_tmp9_, NULL);
	_sqlite3_finalize0 (_data_->stmt);
	_data_->stmt = _data_->_tmp9_;
	_data_->_tmp11_ = _data_->_tmp10_;
	_g_free0 (_data_->_tmp8_);
	_data_->rc = _data_->_tmp11_;
	_vala_assert (_data_->rc == SQLITE_OK, "rc == Sqlite.OK");
	_data_->_tmp12_ = _data_->stmt;
	_data_->rc = sqlite3_step (_data_->_tmp12_);
	_data_->_tmp13_ = _data_->vb;
	_data_->_tmp14_ = g_variant_type_new ("as");
	_data_->_tmp15_ = _data_->_tmp14_;
	g_variant_builder_open (_data_->_tmp13_, _data_->_tmp15_);
	_g_variant_type_free0 (_data_->_tmp15_);
	switch (_data_->rc) {
		case SQLITE_DONE:
		{
			break;
		}
		case SQLITE_ROW:
		{
			_data_->_tmp16_ = _data_->vb;
			_data_->_tmp17_ = _data_->stmt;
			_data_->_tmp18_ = (const gchar*) sqlite3_column_text (_data_->_tmp17_, 0);
			g_variant_builder_add (_data_->_tmp16_, "s", _data_->_tmp18_, NULL);
			_data_->_tmp19_ = _data_->stmt;
			_data_->_tmp20_ = (const gchar*) sqlite3_column_text (_data_->_tmp19_, 1);
			_data_->_tmp21_ = g_strdup (_data_->_tmp20_);
			_data_->content_type = _data_->_tmp21_;
			_data_->_tmp23_ = _data_->content_type;
			if (_data_->_tmp23_ != NULL) {
				_data_->_tmp24_ = _data_->content_type;
				_data_->_tmp22_ = _data_->_tmp24_;
			} else {
				_data_->_tmp22_ = "";
			}
			_data_->_tmp25_ = _data_->vb;
			g_variant_builder_add (_data_->_tmp25_, "s", _data_->_tmp22_, NULL);
			_data_->_tmp26_ = _data_->vb;
			_data_->_tmp27_ = _data_->stmt;
			_data_->_tmp28_ = (const gchar*) sqlite3_column_text (_data_->_tmp27_, 2);
			g_variant_builder_add (_data_->_tmp26_, "s", _data_->_tmp28_, NULL);
			_g_free0 (_data_->content_type);
			break;
		}
		default:
		{
			_data_->_tmp29_ = marlin_tags_db;
			_data_->_tmp30_ = sqlite3_errmsg (_data_->_tmp29_);
			g_warning ("marlind-tagging.vala:177: [get_uri_infos]: Error: %d, %s\n", _data_->rc, _data_->_tmp30_);
			break;
		}
	}
	_data_->_tmp31_ = _data_->vb;
	g_variant_builder_close (_data_->_tmp31_);
	_data_->_tmp32_ = _data_->vb;
	_data_->_tmp33_ = g_variant_builder_end (_data_->_tmp32_);
	g_variant_ref_sink (_data_->_tmp33_);
	_data_->result = _data_->_tmp33_;
	_g_variant_builder_unref0 (_data_->vb);
	_sqlite3_finalize0 (_data_->stmt);
	_g_free0 (_data_->uri);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
marlin_tags_delete_entry_data_free (gpointer _data)
{
	MarlinTagsDeleteEntryData* _data_;
	_data_ = _data;
	_g_free0 (_data_->uri);
	_g_object_unref0 (_data_->self);
	g_slice_free (MarlinTagsDeleteEntryData, _data_);
}

void
marlin_tags_delete_entry (MarlinTags* self,
                          const gchar* uri,
                          GAsyncReadyCallback _callback_,
                          gpointer _user_data_)
{
	MarlinTagsDeleteEntryData* _data_;
	MarlinTags* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (uri != NULL);
	_data_ = g_slice_new0 (MarlinTagsDeleteEntryData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, marlin_tags_delete_entry_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (uri);
	_g_free0 (_data_->uri);
	_data_->uri = _tmp1_;
	marlin_tags_delete_entry_co (_data_);
}

gboolean
marlin_tags_delete_entry_finish (MarlinTags* self,
                                 GAsyncResult* _res_,
                                 GError** error)
{
	gboolean result;
	MarlinTagsDeleteEntryData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		gboolean _tmp0_ = FALSE;
		return _tmp0_;
	}
	result = _data_->result;
	return result;
}

static gboolean
_marlin_tags_delete_entry_co_gsource_func (gpointer self)
{
	gboolean result;
	result = marlin_tags_delete_entry_co (self);
	return result;
}

static gboolean
marlin_tags_delete_entry_co (MarlinTagsDeleteEntryData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _marlin_tags_delete_entry_co_gsource_func, _data_, NULL);
	_data_->_state_ = 1;
	return FALSE;
	_state_1:
	;
	_data_->_tmp0_ = g_strconcat ("delete from tags where uri='", _data_->uri, NULL);
	_data_->_tmp1_ = _data_->_tmp0_;
	_data_->_tmp2_ = g_strconcat (_data_->_tmp1_, "'", NULL);
	_data_->_tmp3_ = _data_->_tmp2_;
	_g_free0 (_data_->_tmp1_);
	_data_->c = _data_->_tmp3_;
	_data_->_tmp4_ = marlin_tags_db;
	_data_->_tmp5_ = _data_->c;
	_data_->rc = _sqlite3_exec (_data_->_tmp4_, _data_->_tmp5_, NULL, NULL, NULL);
	if (_data_->rc != SQLITE_OK) {
		_data_->_tmp6_ = marlin_tags_db;
		_data_->_tmp7_ = sqlite3_errmsg (_data_->_tmp6_);
		g_warning ("marlind-tagging.vala:192: [delete_entry: SQL error]  %d, %s\n", _data_->rc, _data_->_tmp7_);
		_data_->result = FALSE;
		_g_free0 (_data_->c);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->result = TRUE;
	_g_free0 (_data_->c);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

/************* Used for maintenance only *************/
static gint
_marlin_tags_show_table_callback_sqlite3_callback (gpointer self,
                                                   gint n_columns,
                                                   gchar** values,
                                                   gchar** column_names)
{
	gint result;
	result = marlin_tags_show_table_callback (n_columns, values, -1, column_names, -1);
	return result;
}

gboolean
marlin_tags_show_table (MarlinTags* self,
                        const gchar* table,
                        GError** error)
{
	FILE* _tmp0_;
	gchar* consult = NULL;
	gchar* _tmp1_;
	gint rc = 0;
	sqlite3* _tmp2_;
	const gchar* _tmp3_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (table != NULL, FALSE);
	_tmp0_ = stdout;
	fprintf (_tmp0_, "show_table\n");
	_tmp1_ = g_strconcat ("select * from ", table, NULL);
	consult = _tmp1_;
	_tmp2_ = marlin_tags_db;
	_tmp3_ = consult;
	rc = _sqlite3_exec (_tmp2_, _tmp3_, _marlin_tags_show_table_callback_sqlite3_callback, NULL, NULL);
	if (rc != SQLITE_OK) {
		sqlite3* _tmp4_;
		const gchar* _tmp5_;
		_tmp4_ = marlin_tags_db;
		_tmp5_ = sqlite3_errmsg (_tmp4_);
		g_warning ("marlind-tagging.vala:207: [show_table: SQL error]: %d, %s\n", rc, _tmp5_);
		result = FALSE;
		_g_free0 (consult);
		return result;
	}
	result = TRUE;
	_g_free0 (consult);
	return result;
}

gboolean
marlin_tags_clear_db (MarlinTags* self,
                      GError** error)
{
	gchar* c = NULL;
	gchar* _tmp0_;
	gint rc = 0;
	sqlite3* _tmp1_;
	const gchar* _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = g_strdup ("delete from tags");
	c = _tmp0_;
	_tmp1_ = marlin_tags_db;
	_tmp2_ = c;
	rc = _sqlite3_exec (_tmp1_, _tmp2_, NULL, NULL, NULL);
	if (rc != SQLITE_OK) {
		sqlite3* _tmp3_;
		const gchar* _tmp4_;
		_tmp3_ = marlin_tags_db;
		_tmp4_ = sqlite3_errmsg (_tmp3_);
		g_warning ("marlind-tagging.vala:219: [clear_db: SQL error]  %d, %s\n", rc, _tmp4_);
		result = FALSE;
		_g_free0 (c);
		return result;
	}
	result = TRUE;
	_g_free0 (c);
	return result;
}

static gboolean
marlin_tags_has_column (MarlinTags* self,
                        const gchar* table_name,
                        const gchar* column_name)
{
	sqlite3_stmt* stmt = NULL;
	gint res = 0;
	sqlite3* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	sqlite3_stmt* _tmp3_ = NULL;
	gint _tmp4_;
	gint _tmp5_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (table_name != NULL, FALSE);
	g_return_val_if_fail (column_name != NULL, FALSE);
	_tmp0_ = marlin_tags_db;
	_tmp1_ = g_strdup_printf ("PRAGMA table_info(%s)", table_name);
	_tmp2_ = _tmp1_;
	_tmp4_ = sqlite3_prepare_v2 (_tmp0_, _tmp2_, -1, &_tmp3_, NULL);
	_sqlite3_finalize0 (stmt);
	stmt = _tmp3_;
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp2_);
	res = _tmp5_;
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	while (TRUE) {
		sqlite3_stmt* _tmp6_;
		_tmp6_ = stmt;
		res = sqlite3_step (_tmp6_);
		if (res == SQLITE_DONE) {
			break;
		} else {
			if (res != SQLITE_ROW) {
				gchar* _tmp7_;
				gchar* _tmp8_;
				_tmp7_ = g_strdup_printf ("has_column %s", table_name);
				_tmp8_ = _tmp7_;
				g_critical (_tmp8_, res);
				_g_free0 (_tmp8_);
				break;
			} else {
				gchar* column = NULL;
				sqlite3_stmt* _tmp9_;
				const gchar* _tmp10_;
				gchar* _tmp11_;
				gboolean _tmp12_ = FALSE;
				const gchar* _tmp13_;
				_tmp9_ = stmt;
				_tmp10_ = (const gchar*) sqlite3_column_text (_tmp9_, 1);
				_tmp11_ = g_strdup (_tmp10_);
				column = _tmp11_;
				_tmp13_ = column;
				if (_tmp13_ != NULL) {
					const gchar* _tmp14_;
					_tmp14_ = column;
					_tmp12_ = g_strcmp0 (_tmp14_, column_name) == 0;
				} else {
					_tmp12_ = FALSE;
				}
				if (_tmp12_) {
					result = TRUE;
					_g_free0 (column);
					_sqlite3_finalize0 (stmt);
					return result;
				}
				_g_free0 (column);
			}
		}
	}
	result = FALSE;
	_sqlite3_finalize0 (stmt);
	return result;
}

static gboolean
marlin_tags_add_column (MarlinTags* self,
                        const gchar* table_name,
                        const gchar* column_name,
                        const gchar* column_constraints)
{
	sqlite3_stmt* stmt = NULL;
	gint res = 0;
	sqlite3* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	sqlite3_stmt* _tmp3_ = NULL;
	gint _tmp4_;
	gint _tmp5_;
	sqlite3_stmt* _tmp6_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (table_name != NULL, FALSE);
	g_return_val_if_fail (column_name != NULL, FALSE);
	g_return_val_if_fail (column_constraints != NULL, FALSE);
	_tmp0_ = marlin_tags_db;
	_tmp1_ = g_strdup_printf ("ALTER TABLE %s ADD COLUMN %s %s", table_name, column_name, column_constraints);
	_tmp2_ = _tmp1_;
	_tmp4_ = sqlite3_prepare_v2 (_tmp0_, _tmp2_, -1, &_tmp3_, NULL);
	_sqlite3_finalize0 (stmt);
	stmt = _tmp3_;
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp2_);
	res = _tmp5_;
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp6_ = stmt;
	res = sqlite3_step (_tmp6_);
	if (res != SQLITE_DONE) {
		sqlite3* _tmp7_;
		const gchar* _tmp8_;
		_tmp7_ = marlin_tags_db;
		_tmp8_ = sqlite3_errmsg (_tmp7_);
		g_critical ("marlind-tagging.vala:259: Unable to add column %s %s %s: (%d) %s", table_name, column_name, column_constraints, res, _tmp8_);
		result = FALSE;
		_sqlite3_finalize0 (stmt);
		return result;
	}
	result = TRUE;
	_sqlite3_finalize0 (stmt);
	return result;
}

static void
marlin_tags_upgrade_database (MarlinTags* self)
{
	g_return_if_fail (self != NULL);
	if (!marlin_tags_has_column (self, "tags", "content_type")) {
		g_message ("marlind-tagging.vala:270: upgrade_database: adding content_type column" \
" to tags");
		if (!marlin_tags_add_column (self, "tags", "content_type", "TEXT")) {
			g_warning ("marlind-tagging.vala:273: UPGRADE_ERROR");
		}
	}
	if (!marlin_tags_has_column (self, "tags", "modified_time")) {
		g_message ("marlind-tagging.vala:278: upgrade_database: adding modified_time colum" \
"n to tags");
		if (!marlin_tags_add_column (self, "tags", "modified_time", "INTEGER DEFAULT 0")) {
			g_warning ("marlind-tagging.vala:281: UPGRADE_ERROR");
		}
	}
	if (!marlin_tags_has_column (self, "tags", "dir")) {
		g_message ("marlind-tagging.vala:286: upgrade_database: adding dir column to tags");
		if (!marlin_tags_add_column (self, "tags", "dir", "TEXT")) {
			g_warning ("marlind-tagging.vala:289: UPGRADE_ERROR");
		}
	}
}

static void
marlin_tags_class_init (MarlinTagsClass * klass,
                        gpointer klass_data)
{
	marlin_tags_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = marlin_tags_finalize;
}

static void
marlin_tags_instance_init (MarlinTags * self,
                           gpointer klass)
{
}

static void
marlin_tags_finalize (GObject * obj)
{
	MarlinTags * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MARLIN_TAGS, MarlinTags);
	G_OBJECT_CLASS (marlin_tags_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
marlin_tags_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (MarlinTagsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) marlin_tags_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MarlinTags), 0, (GInstanceInitFunc) marlin_tags_instance_init, NULL };
	GType marlin_tags_type_id;
	marlin_tags_type_id = g_type_register_static (G_TYPE_OBJECT, "MarlinTags", &g_define_type_info, 0);
	g_type_set_qdata (marlin_tags_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) marlin_tags_register_object);
	return marlin_tags_type_id;
}

GType
marlin_tags_get_type (void)
{
	static volatile gsize marlin_tags_type_id__once = 0;
	if (g_once_init_enter (&marlin_tags_type_id__once)) {
		GType marlin_tags_type_id;
		marlin_tags_type_id = marlin_tags_get_type_once ();
		g_once_init_leave (&marlin_tags_type_id__once, marlin_tags_type_id);
	}
	return marlin_tags_type_id__once;
}

static void
_dbus_marlin_tags_open_marlin_db (MarlinTags* self,
                                  GVariant* _parameters_,
                                  GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gboolean result;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	result = marlin_tags_open_marlin_db (self, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_boolean (result));
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}

static void
_dbus_marlin_tags_record_uris (MarlinTags* self,
                               GVariant* _parameters_,
                               GDBusMethodInvocation* invocation)
{
	GVariantIter _arguments_iter;
	MarlinTagsRecordUrisReadyData* _ready_data;
	GVariant* _tmp15_;
	GVariant** _tmp16_;
	gint _tmp16__length;
	gint _tmp16__size;
	gint _tmp16__length1;
	GVariantIter _tmp17_;
	GVariant* _tmp18_;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_ready_data = g_slice_new0 (MarlinTagsRecordUrisReadyData);
	_ready_data->_invocation_ = invocation;
	_tmp15_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp16_ = g_new (GVariant*, 5);
	_tmp16__length = 0;
	_tmp16__size = 4;
	_tmp16__length1 = 0;
	g_variant_iter_init (&_tmp17_, _tmp15_);
	for (; (_tmp18_ = g_variant_iter_next_value (&_tmp17_)) != NULL; _tmp16__length1++) {
		if (_tmp16__size == _tmp16__length) {
			_tmp16__size = 2 * _tmp16__size;
			_tmp16_ = g_renew (GVariant*, _tmp16_, _tmp16__size + 1);
		}
		_tmp16_[_tmp16__length++] = g_variant_get_variant (_tmp18_);
		g_variant_unref (_tmp18_);
	}
	_ready_data->locations_length1 = _tmp16__length1;
	_tmp16_[_tmp16__length] = NULL;
	_ready_data->locations = _tmp16_;
	g_variant_unref (_tmp15_);
	marlin_tags_record_uris (self, _ready_data->locations, _ready_data->locations_length1, (GAsyncReadyCallback) _dbus_marlin_tags_record_uris_ready, _ready_data);
	_error:
	;
}

static void
_dbus_marlin_tags_record_uris_ready (GObject * source_object,
                                     GAsyncResult * _res_,
                                     gpointer _user_data_)
{
	MarlinTagsRecordUrisReadyData* _ready_data;
	GDBusMethodInvocation* invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gboolean result;
	_ready_data = _user_data_;
	invocation = _ready_data->_invocation_;
	result = marlin_tags_record_uris_finish ((MarlinTags*) source_object, _res_, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_boolean (result));
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_ready_data->locations = (_vala_array_free (_ready_data->locations, _ready_data->locations_length1, (GDestroyNotify) g_variant_unref), NULL);
	g_slice_free (MarlinTagsRecordUrisReadyData, _ready_data);
}

static void
_dbus_marlin_tags_get_uri_infos (MarlinTags* self,
                                 GVariant* _parameters_,
                                 GDBusMethodInvocation* invocation)
{
	GVariantIter _arguments_iter;
	MarlinTagsGetUriInfosReadyData* _ready_data;
	GVariant* _tmp19_;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_ready_data = g_slice_new0 (MarlinTagsGetUriInfosReadyData);
	_ready_data->_invocation_ = invocation;
	_tmp19_ = g_variant_iter_next_value (&_arguments_iter);
	_ready_data->raw_uri = g_variant_dup_string (_tmp19_, NULL);
	g_variant_unref (_tmp19_);
	marlin_tags_get_uri_infos (self, _ready_data->raw_uri, (GAsyncReadyCallback) _dbus_marlin_tags_get_uri_infos_ready, _ready_data);
	_error:
	;
}

static void
_dbus_marlin_tags_get_uri_infos_ready (GObject * source_object,
                                       GAsyncResult * _res_,
                                       gpointer _user_data_)
{
	MarlinTagsGetUriInfosReadyData* _ready_data;
	GDBusMethodInvocation* invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	GVariant* result;
	_ready_data = _user_data_;
	invocation = _ready_data->_invocation_;
	result = marlin_tags_get_uri_infos_finish ((MarlinTags*) source_object, _res_, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_variant (result));
	_g_variant_unref0 (result);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_g_free0 (_ready_data->raw_uri);
	g_slice_free (MarlinTagsGetUriInfosReadyData, _ready_data);
}

static void
_dbus_marlin_tags_delete_entry (MarlinTags* self,
                                GVariant* _parameters_,
                                GDBusMethodInvocation* invocation)
{
	GVariantIter _arguments_iter;
	MarlinTagsDeleteEntryReadyData* _ready_data;
	GVariant* _tmp20_;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_ready_data = g_slice_new0 (MarlinTagsDeleteEntryReadyData);
	_ready_data->_invocation_ = invocation;
	_tmp20_ = g_variant_iter_next_value (&_arguments_iter);
	_ready_data->uri = g_variant_dup_string (_tmp20_, NULL);
	g_variant_unref (_tmp20_);
	marlin_tags_delete_entry (self, _ready_data->uri, (GAsyncReadyCallback) _dbus_marlin_tags_delete_entry_ready, _ready_data);
	_error:
	;
}

static void
_dbus_marlin_tags_delete_entry_ready (GObject * source_object,
                                      GAsyncResult * _res_,
                                      gpointer _user_data_)
{
	MarlinTagsDeleteEntryReadyData* _ready_data;
	GDBusMethodInvocation* invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gboolean result;
	_ready_data = _user_data_;
	invocation = _ready_data->_invocation_;
	result = marlin_tags_delete_entry_finish ((MarlinTags*) source_object, _res_, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_boolean (result));
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_g_free0 (_ready_data->uri);
	g_slice_free (MarlinTagsDeleteEntryReadyData, _ready_data);
}

static void
_dbus_marlin_tags_show_table (MarlinTags* self,
                              GVariant* _parameters_,
                              GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gchar* table = NULL;
	GVariant* _tmp21_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gboolean result;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp21_ = g_variant_iter_next_value (&_arguments_iter);
	table = g_variant_dup_string (_tmp21_, NULL);
	g_variant_unref (_tmp21_);
	result = marlin_tags_show_table (self, table, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_boolean (result));
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_g_free0 (table);
	;
}

static void
_dbus_marlin_tags_clear_db (MarlinTags* self,
                            GVariant* _parameters_,
                            GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gboolean result;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	result = marlin_tags_clear_db (self, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_boolean (result));
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}

static void
marlin_tags_dbus_interface_method_call (GDBusConnection* connection,
                                        const gchar* sender,
                                        const gchar* object_path,
                                        const gchar* interface_name,
                                        const gchar* method_name,
                                        GVariant* parameters,
                                        GDBusMethodInvocation* invocation,
                                        gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "OpenMarlinDb") == 0) {
		_dbus_marlin_tags_open_marlin_db (object, parameters, invocation);
	} else if (strcmp (method_name, "RecordUris") == 0) {
		_dbus_marlin_tags_record_uris (object, parameters, invocation);
	} else if (strcmp (method_name, "GetUriInfos") == 0) {
		_dbus_marlin_tags_get_uri_infos (object, parameters, invocation);
	} else if (strcmp (method_name, "DeleteEntry") == 0) {
		_dbus_marlin_tags_delete_entry (object, parameters, invocation);
	} else if (strcmp (method_name, "ShowTable") == 0) {
		_dbus_marlin_tags_show_table (object, parameters, invocation);
	} else if (strcmp (method_name, "ClearDb") == 0) {
		_dbus_marlin_tags_clear_db (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}

static GVariant*
marlin_tags_dbus_interface_get_property (GDBusConnection* connection,
                                         const gchar* sender,
                                         const gchar* object_path,
                                         const gchar* interface_name,
                                         const gchar* property_name,
                                         GError** error,
                                         gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}

static gboolean
marlin_tags_dbus_interface_set_property (GDBusConnection* connection,
                                         const gchar* sender,
                                         const gchar* object_path,
                                         const gchar* interface_name,
                                         const gchar* property_name,
                                         GVariant* value,
                                         GError** error,
                                         gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}

guint
marlin_tags_register_object (gpointer object,
                             GDBusConnection* connection,
                             const gchar* path,
                             GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_marlin_tags_dbus_interface_info), &_marlin_tags_dbus_interface_vtable, data, _marlin_tags_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}

static void
_marlin_tags_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

