/* FormatBar.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from FormatBar.vala, do not modify */

/*-
 * Copyright 2017-2023 elementary, Inc. (https://elementary.io)
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by: Corentin Noël <corentin@elementary.io>
 */

#include "codecore.h"
#include <glib.h>
#include <gtk/gtk.h>
#include <granite.h>
#include <gtksourceview/gtksource.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <float.h>
#include <math.h>
#include <gio/gio.h>
#include <glib-object.h>
#include <stdio.h>
#include <pango/pango.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	CODE_FORMAT_BAR_0_PROPERTY,
	CODE_FORMAT_BAR_TAB_STYLE_SET_BY_EDITOR_CONFIG_PROPERTY,
	CODE_FORMAT_BAR_TAB_WIDTH_SET_BY_EDITOR_CONFIG_PROPERTY,
	CODE_FORMAT_BAR_LINE_MENUBUTTON_PROPERTY,
	CODE_FORMAT_BAR_EDITORCONFIG_INFOBAR_PROPERTY,
	CODE_FORMAT_BAR_TAB_BOX_PROPERTY,
	CODE_FORMAT_BAR_WIDTH_SPINBUTTON_PROPERTY,
	CODE_FORMAT_BAR_NUM_PROPERTIES
};
static GParamSpec* code_format_bar_properties[CODE_FORMAT_BAR_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
typedef struct _Block45Data Block45Data;
enum  {
	CODE_FORMAT_BAR_FORMAT_BUTTON_0_PROPERTY,
	CODE_FORMAT_BAR_FORMAT_BUTTON_TEXT_PROPERTY,
	CODE_FORMAT_BAR_FORMAT_BUTTON_ICON_PROPERTY,
	CODE_FORMAT_BAR_FORMAT_BUTTON_NUM_PROPERTIES
};
static GParamSpec* code_format_bar_format_button_properties[CODE_FORMAT_BAR_FORMAT_BUTTON_NUM_PROPERTIES];
enum  {
	CODE_FORMAT_BAR_LANG_ENTRY_0_PROPERTY,
	CODE_FORMAT_BAR_LANG_ENTRY_LANG_ID_PROPERTY,
	CODE_FORMAT_BAR_LANG_ENTRY_LANG_NAME_PROPERTY,
	CODE_FORMAT_BAR_LANG_ENTRY_GROUP_PROPERTY,
	CODE_FORMAT_BAR_LANG_ENTRY_ACTIVE_PROPERTY,
	CODE_FORMAT_BAR_LANG_ENTRY_SELECTED_PROPERTY,
	CODE_FORMAT_BAR_LANG_ENTRY_NUM_PROPERTIES
};
static GParamSpec* code_format_bar_lang_entry_properties[CODE_FORMAT_BAR_LANG_ENTRY_NUM_PROPERTIES];

struct _CodeFormatBarPrivate {
	gboolean _tab_style_set_by_editor_config;
	gboolean _tab_width_set_by_editor_config;
	CodeFormatBarFormatButton* _line_menubutton;
	GtkInfoBar* _editorconfig_infobar;
	GtkBox* _tab_box;
	GtkSpinButton* _width_spinbutton;
	CodeFormatBarFormatButton* lang_menubutton;
	CodeFormatBarFormatButton* tab_menubutton;
	GraniteSwitchModelButton* space_tab_modelbutton;
	GtkEntry* goto_entry;
	GtkListBox* lang_selection_listbox;
	GtkSearchEntry* lang_selection_filter;
	GtkSourceLanguageManager* manager;
	CodeFormatBarLangEntry* normal_entry;
	ScratchServicesDocument* doc;
};

struct _Block45Data {
	int _ref_count_;
	CodeFormatBar* self;
	gchar* lang_id;
};

struct _CodeFormatBarFormatButtonPrivate {
	GtkImage* img;
	GtkLabel* label_widget;
};

struct _CodeFormatBarLangEntryPrivate {
	gchar* _lang_id;
	gchar* _lang_name;
	GSList* _group;
	GtkRadioButton* lang_radio;
};

static gint CodeFormatBar_private_offset;
static gpointer code_format_bar_parent_class = NULL;
static gint CodeFormatBarFormatButton_private_offset;
static gpointer code_format_bar_format_button_parent_class = NULL;
static gint CodeFormatBarLangEntry_private_offset;
static gpointer code_format_bar_lang_entry_parent_class = NULL;

static void code_format_bar_create_language_popover (CodeFormatBar* self);
static gint __lambda52_ (CodeFormatBar* self,
                  GtkListBoxRow* row1,
                  GtkListBoxRow* row2);
static gint ___lambda52__gtk_list_box_sort_func (GtkListBoxRow* row1,
                                          GtkListBoxRow* row2,
                                          gpointer self);
static gboolean __lambda53_ (CodeFormatBar* self,
                      GtkListBoxRow* row);
static gboolean ___lambda53__gtk_list_box_filter_func (GtkListBoxRow* row,
                                                gpointer self);
static void __lambda54_ (CodeFormatBar* self);
static void ___lambda54__gtk_editable_changed (GtkEditable* _sender,
                                        gpointer self);
static void __lambda55_ (CodeFormatBar* self,
                  GtkListBoxRow* row);
static void code_format_bar_select_language (CodeFormatBar* self,
                                      CodeFormatBarLangEntry* lang,
                                      gboolean update_source_view);
static void ___lambda55__gtk_list_box_row_activated (GtkListBox* _sender,
                                              GtkListBoxRow* row,
                                              gpointer self);
static void code_format_bar_create_tabulation_popover (CodeFormatBar* self);
static void code_format_bar_format_tab_header_from_global_settings (CodeFormatBar* self);
static void _code_format_bar_format_tab_header_from_global_settings_g_settings_changed (GSettings* _sender,
                                                                                 const gchar* key,
                                                                                 gpointer self);
static void __lambda56_ (CodeFormatBar* self);
static void ___lambda56__gtk_spin_button_value_changed (GtkSpinButton* _sender,
                                                 gpointer self);
static void __lambda57_ (CodeFormatBar* self);
static void ___lambda57__gtk_button_clicked (GtkButton* _sender,
                                      gpointer self);
static void code_format_bar_format_line_header (CodeFormatBar* self);
static void code_format_bar_create_line_popover (CodeFormatBar* self);
static void __lambda58_ (CodeFormatBar* self);
static void ___lambda58__gtk_entry_activate (GtkEntry* _sender,
                                      gpointer self);
static void _code_format_bar_format_line_header_g_object_notify (GObject* _sender,
                                                          GParamSpec* pspec,
                                                          gpointer self);
static void code_format_bar_update_current_lang (CodeFormatBar* self);
static Block45Data* block45_data_ref (Block45Data* _data45_);
static void block45_data_unref (void * _userdata_);
static void ___lambda59_ (Block45Data* _data45_,
                   GtkWidget* child);
static void ____lambda59__gfunc (gconstpointer data,
                          gpointer self);
static void code_format_bar_set_line_menubutton (CodeFormatBar* self,
                                          CodeFormatBarFormatButton* value);
static GObject * code_format_bar_format_button_constructor (GType type,
                                                     guint n_construct_properties,
                                                     GObjectConstructParam * construct_properties);
static void code_format_bar_format_button_finalize (GObject * obj);
static GType code_format_bar_format_button_get_type_once (void);
static void _vala_code_format_bar_format_button_get_property (GObject * object,
                                                       guint property_id,
                                                       GValue * value,
                                                       GParamSpec * pspec);
static void _vala_code_format_bar_format_button_set_property (GObject * object,
                                                       guint property_id,
                                                       const GValue * value,
                                                       GParamSpec * pspec);
static void code_format_bar_lang_entry_radio_toggled (CodeFormatBarLangEntry* self);
static void _code_format_bar_lang_entry_radio_toggled_gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                                                          gpointer self);
static GObject * code_format_bar_lang_entry_constructor (GType type,
                                                  guint n_construct_properties,
                                                  GObjectConstructParam * construct_properties);
static void code_format_bar_lang_entry_finalize (GObject * obj);
static GType code_format_bar_lang_entry_get_type_once (void);
static void _vala_code_format_bar_lang_entry_get_property (GObject * object,
                                                    guint property_id,
                                                    GValue * value,
                                                    GParamSpec * pspec);
static void _vala_code_format_bar_lang_entry_set_property (GObject * object,
                                                    guint property_id,
                                                    const GValue * value,
                                                    GParamSpec * pspec);
static GObject * code_format_bar_constructor (GType type,
                                       guint n_construct_properties,
                                       GObjectConstructParam * construct_properties);
static void code_format_bar_finalize (GObject * obj);
static GType code_format_bar_get_type_once (void);
static void _vala_code_format_bar_get_property (GObject * object,
                                         guint property_id,
                                         GValue * value,
                                         GParamSpec * pspec);
static void _vala_code_format_bar_set_property (GObject * object,
                                         guint property_id,
                                         const GValue * value,
                                         GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static inline gpointer
code_format_bar_get_instance_private (CodeFormatBar* self)
{
	return G_STRUCT_MEMBER_P (self, CodeFormatBar_private_offset);
}

static gint
__lambda52_ (CodeFormatBar* self,
             GtkListBoxRow* row1,
             GtkListBoxRow* row2)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gint result;
	g_return_val_if_fail (row1 != NULL, 0);
	g_return_val_if_fail (row2 != NULL, 0);
	_tmp0_ = code_format_bar_lang_entry_get_lang_name (G_TYPE_CHECK_INSTANCE_CAST (row1, CODE_FORMAT_BAR_TYPE_LANG_ENTRY, CodeFormatBarLangEntry));
	_tmp1_ = _tmp0_;
	_tmp2_ = code_format_bar_lang_entry_get_lang_name (G_TYPE_CHECK_INSTANCE_CAST (row2, CODE_FORMAT_BAR_TYPE_LANG_ENTRY, CodeFormatBarLangEntry));
	_tmp3_ = _tmp2_;
	result = g_utf8_collate (_tmp1_, _tmp3_);
	return result;
}

static gint
___lambda52__gtk_list_box_sort_func (GtkListBoxRow* row1,
                                     GtkListBoxRow* row2,
                                     gpointer self)
{
	gint result;
	result = __lambda52_ ((CodeFormatBar*) self, row1, row2);
	return result;
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

static gboolean
__lambda53_ (CodeFormatBar* self,
             GtkListBoxRow* row)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GtkSearchEntry* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gboolean _tmp11_;
	gboolean result;
	g_return_val_if_fail (row != NULL, FALSE);
	_tmp0_ = code_format_bar_lang_entry_get_lang_name (G_TYPE_CHECK_INSTANCE_CAST (row, CODE_FORMAT_BAR_TYPE_LANG_ENTRY, CodeFormatBarLangEntry));
	_tmp1_ = _tmp0_;
	_tmp2_ = g_utf8_strdown (_tmp1_, (gssize) -1);
	_tmp3_ = _tmp2_;
	_tmp4_ = self->priv->lang_selection_filter;
	_tmp5_ = gtk_entry_get_text ((GtkEntry*) _tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_utf8_strdown (_tmp6_, (gssize) -1);
	_tmp8_ = _tmp7_;
	_tmp9_ = string_strip (_tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = string_contains (_tmp3_, _tmp10_);
	_g_free0 (_tmp10_);
	_g_free0 (_tmp8_);
	_g_free0 (_tmp3_);
	result = _tmp11_;
	return result;
}

static gboolean
___lambda53__gtk_list_box_filter_func (GtkListBoxRow* row,
                                       gpointer self)
{
	gboolean result;
	result = __lambda53_ ((CodeFormatBar*) self, row);
	return result;
}

static void
__lambda54_ (CodeFormatBar* self)
{
	GtkListBox* _tmp0_;
	_tmp0_ = self->priv->lang_selection_listbox;
	gtk_list_box_invalidate_filter (_tmp0_);
}

static void
___lambda54__gtk_editable_changed (GtkEditable* _sender,
                                   gpointer self)
{
	__lambda54_ ((CodeFormatBar*) self);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
__lambda55_ (CodeFormatBar* self,
             GtkListBoxRow* row)
{
	CodeFormatBarLangEntry* lang_entry = NULL;
	CodeFormatBarLangEntry* _tmp0_;
	g_return_if_fail (row != NULL);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (row, CODE_FORMAT_BAR_TYPE_LANG_ENTRY, CodeFormatBarLangEntry));
	lang_entry = _tmp0_;
	code_format_bar_select_language (self, lang_entry, TRUE);
	_g_object_unref0 (lang_entry);
}

static void
___lambda55__gtk_list_box_row_activated (GtkListBox* _sender,
                                         GtkListBoxRow* row,
                                         gpointer self)
{
	__lambda55_ ((CodeFormatBar*) self, row);
}

static void
code_format_bar_create_language_popover (CodeFormatBar* self)
{
	GtkListBox* _tmp0_;
	GtkListBox* _tmp1_;
	GtkListBox* _tmp2_;
	GtkListBox* _tmp3_;
	gchar* _tmp4_;
	GtkSearchEntry* _tmp5_ = NULL;
	GtkSearchEntry* _tmp6_;
	GtkScrolledWindow* lang_scrolled = NULL;
	GtkScrolledWindow* _tmp7_;
	GtkScrolledWindow* _tmp8_;
	GtkScrolledWindow* _tmp9_;
	GtkScrolledWindow* _tmp10_;
	GtkScrolledWindow* _tmp11_;
	GtkScrolledWindow* _tmp12_;
	GtkScrolledWindow* _tmp13_;
	GtkListBox* _tmp14_;
	gchar** ids = NULL;
	GtkSourceLanguageManager* _tmp15_;
	gchar** _tmp16_;
	gchar** _tmp17_;
	gint ids_length1;
	gint _ids_size_;
	GSList* group = NULL;
	gchar** _tmp18_;
	gint _tmp18__length1;
	GSList* _tmp32_;
	CodeFormatBarLangEntry* _tmp33_;
	GtkListBox* _tmp34_;
	CodeFormatBarLangEntry* _tmp35_;
	GtkBox* popover_content = NULL;
	GtkBox* _tmp36_;
	GtkSearchEntry* _tmp37_;
	GtkScrolledWindow* _tmp38_;
	GtkPopover* lang_popover = NULL;
	CodeFormatBarFormatButton* _tmp39_;
	GtkPopover* _tmp40_;
	CodeFormatBarFormatButton* _tmp41_;
	GtkListBox* _tmp42_;
	g_return_if_fail (self != NULL);
	_tmp0_ = (GtkListBox*) gtk_list_box_new ();
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->lang_selection_listbox);
	self->priv->lang_selection_listbox = _tmp0_;
	_tmp1_ = self->priv->lang_selection_listbox;
	gtk_list_box_set_selection_mode (_tmp1_, GTK_SELECTION_SINGLE);
	_tmp2_ = self->priv->lang_selection_listbox;
	gtk_list_box_set_sort_func (_tmp2_, ___lambda52__gtk_list_box_sort_func, g_object_ref (self), g_object_unref);
	_tmp3_ = self->priv->lang_selection_listbox;
	gtk_list_box_set_filter_func (_tmp3_, ___lambda53__gtk_list_box_filter_func, g_object_ref (self), g_object_unref);
	_tmp4_ = g_strdup (_ ("Filter languages"));
	_tmp5_ = (GtkSearchEntry*) gtk_search_entry_new ();
	g_object_set ((GtkWidget*) _tmp5_, "margin", 12, NULL);
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp5_, 6);
	gtk_entry_set_placeholder_text ((GtkEntry*) _tmp5_, _tmp4_);
	_g_free0 (_tmp4_);
	g_object_ref_sink (_tmp5_);
	_g_object_unref0 (self->priv->lang_selection_filter);
	self->priv->lang_selection_filter = _tmp5_;
	_tmp6_ = self->priv->lang_selection_filter;
	g_signal_connect_object ((GtkEditable*) _tmp6_, "changed", (GCallback) ___lambda54__gtk_editable_changed, self, 0);
	_tmp7_ = (GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL);
	g_object_ref_sink (_tmp7_);
	lang_scrolled = _tmp7_;
	_tmp8_ = lang_scrolled;
	g_object_set (_tmp8_, "hscrollbar-policy", GTK_POLICY_NEVER, NULL);
	_tmp9_ = lang_scrolled;
	g_object_set ((GtkWidget*) _tmp9_, "height-request", 350, NULL);
	_tmp10_ = lang_scrolled;
	g_object_set ((GtkWidget*) _tmp10_, "expand", TRUE, NULL);
	_tmp11_ = lang_scrolled;
	_tmp12_ = lang_scrolled;
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp12_, 3);
	gtk_widget_set_margin_top ((GtkWidget*) _tmp11_, 3);
	_tmp13_ = lang_scrolled;
	_tmp14_ = self->priv->lang_selection_listbox;
	gtk_container_add ((GtkContainer*) _tmp13_, (GtkWidget*) _tmp14_);
	_tmp15_ = self->priv->manager;
	_tmp17_ = _tmp16_ = gtk_source_language_manager_get_language_ids (_tmp15_);
	ids = _tmp17_;
	ids_length1 = _vala_array_length (_tmp16_);
	_ids_size_ = ids_length1;
	group = NULL;
	_tmp18_ = ids;
	_tmp18__length1 = ids_length1;
	{
		gchar** id_collection = NULL;
		gint id_collection_length1 = 0;
		gint _id_collection_size_ = 0;
		gint id_it = 0;
		id_collection = _tmp18_;
		id_collection_length1 = _tmp18__length1;
		for (id_it = 0; id_it < id_collection_length1; id_it = id_it + 1) {
			const gchar* id = NULL;
			id = id_collection[id_it];
			{
				GtkSourceLanguage* lang = NULL;
				GtkSourceLanguageManager* _tmp19_;
				const gchar* _tmp20_;
				GtkSourceLanguage* _tmp21_;
				CodeFormatBarLangEntry* entry = NULL;
				const gchar* _tmp22_;
				GtkSourceLanguage* _tmp23_;
				const gchar* _tmp24_;
				const gchar* _tmp25_;
				GSList* _tmp26_;
				CodeFormatBarLangEntry* _tmp27_;
				CodeFormatBarLangEntry* _tmp28_;
				GSList* _tmp29_;
				GtkListBox* _tmp30_;
				CodeFormatBarLangEntry* _tmp31_;
				_tmp19_ = self->priv->manager;
				_tmp20_ = id;
				_tmp21_ = gtk_source_language_manager_get_language (_tmp19_, _tmp20_);
				lang = _tmp21_;
				_tmp22_ = id;
				_tmp23_ = lang;
				_tmp24_ = gtk_source_language_get_name (_tmp23_);
				_tmp25_ = _tmp24_;
				_tmp26_ = group;
				_tmp27_ = code_format_bar_lang_entry_new (_tmp22_, _tmp25_, _tmp26_);
				g_object_ref_sink (_tmp27_);
				entry = _tmp27_;
				_tmp28_ = entry;
				_tmp29_ = code_format_bar_lang_entry_get_radio_group (_tmp28_);
				group = _tmp29_;
				_tmp30_ = self->priv->lang_selection_listbox;
				_tmp31_ = entry;
				gtk_container_add ((GtkContainer*) _tmp30_, (GtkWidget*) _tmp31_);
				_g_object_unref0 (entry);
			}
		}
	}
	_tmp32_ = group;
	_tmp33_ = code_format_bar_lang_entry_new (NULL, _ ("Plain Text"), _tmp32_);
	g_object_ref_sink (_tmp33_);
	_g_object_unref0 (self->priv->normal_entry);
	self->priv->normal_entry = _tmp33_;
	_tmp34_ = self->priv->lang_selection_listbox;
	_tmp35_ = self->priv->normal_entry;
	gtk_container_add ((GtkContainer*) _tmp34_, (GtkWidget*) _tmp35_);
	_tmp36_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	g_object_ref_sink (_tmp36_);
	popover_content = _tmp36_;
	_tmp37_ = self->priv->lang_selection_filter;
	gtk_container_add ((GtkContainer*) popover_content, (GtkWidget*) _tmp37_);
	_tmp38_ = lang_scrolled;
	gtk_container_add ((GtkContainer*) popover_content, (GtkWidget*) _tmp38_);
	gtk_widget_show_all ((GtkWidget*) popover_content);
	_tmp39_ = self->priv->lang_menubutton;
	_tmp40_ = (GtkPopover*) gtk_popover_new ((GtkWidget*) _tmp39_);
	g_object_ref_sink (_tmp40_);
	lang_popover = _tmp40_;
	gtk_popover_set_position (lang_popover, GTK_POS_BOTTOM);
	gtk_container_add ((GtkContainer*) lang_popover, (GtkWidget*) popover_content);
	_tmp41_ = self->priv->lang_menubutton;
	gtk_menu_button_set_popover ((GtkMenuButton*) _tmp41_, lang_popover);
	_tmp42_ = self->priv->lang_selection_listbox;
	g_signal_connect_object (_tmp42_, "row-activated", (GCallback) ___lambda55__gtk_list_box_row_activated, self, 0);
	_g_object_unref0 (lang_popover);
	_g_object_unref0 (popover_content);
	_g_object_unref0 (lang_scrolled);
}

static void
code_format_bar_select_language (CodeFormatBar* self,
                                 CodeFormatBarLangEntry* lang,
                                 gboolean update_source_view)
{
	GtkListBox* _tmp0_;
	CodeFormatBarFormatButton* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (lang != NULL);
	_tmp0_ = self->priv->lang_selection_listbox;
	gtk_list_box_select_row (_tmp0_, (GtkListBoxRow*) lang);
	_tmp1_ = self->priv->lang_menubutton;
	_tmp2_ = code_format_bar_lang_entry_get_lang_name (lang);
	_tmp3_ = _tmp2_;
	code_format_bar_format_button_set_text (_tmp1_, _tmp3_);
	if (update_source_view) {
		GtkSourceLanguage* _tmp4_ = NULL;
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		ScratchServicesDocument* _tmp11_;
		ScratchWidgetsSourceView* _tmp12_;
		ScratchWidgetsSourceView* _tmp13_;
		code_format_bar_lang_entry_set_active (lang, TRUE);
		_tmp5_ = code_format_bar_lang_entry_get_lang_id (lang);
		_tmp6_ = _tmp5_;
		if (_tmp6_ != NULL) {
			GtkSourceLanguageManager* _tmp7_;
			const gchar* _tmp8_;
			const gchar* _tmp9_;
			GtkSourceLanguage* _tmp10_;
			_tmp7_ = self->priv->manager;
			_tmp8_ = code_format_bar_lang_entry_get_lang_id (lang);
			_tmp9_ = _tmp8_;
			_tmp10_ = gtk_source_language_manager_get_language (_tmp7_, _tmp9_);
			_tmp4_ = _tmp10_;
		} else {
			_tmp4_ = NULL;
		}
		_tmp11_ = self->priv->doc;
		_tmp12_ = scratch_services_document_get_source_view (_tmp11_);
		_tmp13_ = _tmp12_;
		scratch_widgets_source_view_set_language (_tmp13_, _tmp4_);
	} else {
		code_format_bar_lang_entry_set_selected (lang, TRUE);
	}
}

static void
_code_format_bar_format_tab_header_from_global_settings_g_settings_changed (GSettings* _sender,
                                                                            const gchar* key,
                                                                            gpointer self)
{
	code_format_bar_format_tab_header_from_global_settings ((CodeFormatBar*) self);
}

static void
__lambda56_ (CodeFormatBar* self)
{
	gboolean _tmp0_;
	_tmp0_ = self->priv->_tab_width_set_by_editor_config;
	if (!_tmp0_) {
		GSettings* _tmp1_;
		GtkSpinButton* _tmp2_;
		gdouble _tmp3_;
		gdouble _tmp4_;
		_tmp1_ = scratch_settings;
		_tmp2_ = self->priv->_width_spinbutton;
		_tmp3_ = gtk_spin_button_get_value (_tmp2_);
		_tmp4_ = _tmp3_;
		g_settings_set_int (_tmp1_, "indent-width", (gint) _tmp4_);
	}
}

static void
___lambda56__gtk_spin_button_value_changed (GtkSpinButton* _sender,
                                            gpointer self)
{
	__lambda56_ ((CodeFormatBar*) self);
}

static void
__lambda57_ (CodeFormatBar* self)
{
	gboolean _tmp0_;
	_tmp0_ = self->priv->_tab_style_set_by_editor_config;
	if (!_tmp0_) {
		GSettings* _tmp1_;
		GraniteSwitchModelButton* _tmp2_;
		gboolean _tmp3_;
		gboolean _tmp4_;
		_tmp1_ = scratch_settings;
		_tmp2_ = self->priv->space_tab_modelbutton;
		_tmp3_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp2_);
		_tmp4_ = _tmp3_;
		g_settings_set_boolean (_tmp1_, "spaces-instead-of-tabs", _tmp4_);
	}
}

static void
___lambda57__gtk_button_clicked (GtkButton* _sender,
                                 gpointer self)
{
	__lambda57_ ((CodeFormatBar*) self);
}

static void
code_format_bar_create_tabulation_popover (CodeFormatBar* self)
{
	GtkInfoBar* _tmp0_ = NULL;
	GtkInfoBar* _tmp1_;
	GtkInfoBar* _tmp2_;
	GtkContainer* _tmp3_;
	GtkLabel* _tmp4_;
	GtkLabel* _tmp5_;
	GtkInfoBar* _tmp6_;
	GtkStyleContext* _tmp7_;
	GraniteSwitchModelButton* autoindent_modelbutton = NULL;
	GraniteSwitchModelButton* _tmp8_;
	GraniteSwitchModelButton* _tmp9_;
	GtkLabel* width_label = NULL;
	GtkLabel* _tmp10_ = NULL;
	GtkSpinButton* _tmp11_;
	GtkSpinButton* _tmp12_;
	GtkBox* _tmp13_ = NULL;
	GtkBox* _tmp14_;
	GtkBox* _tmp15_;
	GtkBox* _tmp16_;
	GtkSpinButton* _tmp17_;
	GtkBox* box = NULL;
	GtkBox* _tmp18_ = NULL;
	GtkInfoBar* _tmp19_;
	GraniteSwitchModelButton* _tmp20_;
	GtkBox* _tmp21_;
	GtkPopover* tab_popover = NULL;
	CodeFormatBarFormatButton* _tmp22_;
	GtkPopover* _tmp23_ = NULL;
	CodeFormatBarFormatButton* _tmp24_;
	GSettings* _tmp25_;
	GSettings* _tmp26_;
	GSettings* _tmp27_;
	GtkSpinButton* _tmp28_;
	GraniteSwitchModelButton* _tmp29_;
	g_return_if_fail (self != NULL);
	_tmp0_ = (GtkInfoBar*) gtk_info_bar_new ();
	gtk_widget_set_margin_top ((GtkWidget*) _tmp0_, 9);
	gtk_widget_set_margin_end ((GtkWidget*) _tmp0_, 9);
	gtk_widget_set_margin_start ((GtkWidget*) _tmp0_, 9);
	g_object_ref_sink (_tmp0_);
	_tmp1_ = _tmp0_;
	code_format_bar_set_editorconfig_infobar (self, _tmp1_);
	_g_object_unref0 (_tmp1_);
	_tmp2_ = self->priv->_editorconfig_infobar;
	_tmp3_ = gtk_info_bar_get_content_area (_tmp2_);
	_tmp4_ = (GtkLabel*) gtk_label_new (_ ("Some settings set by EditorConfig file"));
	g_object_ref_sink (_tmp4_);
	_tmp5_ = _tmp4_;
	gtk_container_add (_tmp3_, (GtkWidget*) _tmp5_);
	_g_object_unref0 (_tmp5_);
	_tmp6_ = self->priv->_editorconfig_infobar;
	_tmp7_ = gtk_widget_get_style_context ((GtkWidget*) _tmp6_);
	gtk_style_context_add_class (_tmp7_, GTK_STYLE_CLASS_FRAME);
	_tmp8_ = granite_switch_model_button_new (_ ("Automatic Indentation"));
	g_object_ref_sink (_tmp8_);
	autoindent_modelbutton = _tmp8_;
	_tmp9_ = granite_switch_model_button_new (_ ("Insert Spaces Instead Of Tabs"));
	g_object_ref_sink (_tmp9_);
	_g_object_unref0 (self->priv->space_tab_modelbutton);
	self->priv->space_tab_modelbutton = _tmp9_;
	_tmp10_ = (GtkLabel*) gtk_label_new (_ ("Tab width"));
	gtk_widget_set_halign ((GtkWidget*) _tmp10_, GTK_ALIGN_START);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp10_, TRUE);
	g_object_ref_sink (_tmp10_);
	width_label = _tmp10_;
	_tmp11_ = (GtkSpinButton*) gtk_spin_button_new_with_range ((gdouble) 2, (gdouble) 16, (gdouble) 1);
	g_object_ref_sink (_tmp11_);
	_tmp12_ = _tmp11_;
	code_format_bar_set_width_spinbutton (self, _tmp12_);
	_g_object_unref0 (_tmp12_);
	_tmp13_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 12);
	gtk_widget_set_margin_top ((GtkWidget*) _tmp13_, 6);
	gtk_widget_set_margin_end ((GtkWidget*) _tmp13_, 12);
	gtk_widget_set_margin_start ((GtkWidget*) _tmp13_, 12);
	g_object_ref_sink (_tmp13_);
	_tmp14_ = _tmp13_;
	code_format_bar_set_tab_box (self, _tmp14_);
	_g_object_unref0 (_tmp14_);
	_tmp15_ = self->priv->_tab_box;
	gtk_container_add ((GtkContainer*) _tmp15_, (GtkWidget*) width_label);
	_tmp16_ = self->priv->_tab_box;
	_tmp17_ = self->priv->_width_spinbutton;
	gtk_container_add ((GtkContainer*) _tmp16_, (GtkWidget*) _tmp17_);
	_tmp18_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp18_, 12);
	g_object_ref_sink (_tmp18_);
	box = _tmp18_;
	_tmp19_ = self->priv->_editorconfig_infobar;
	gtk_container_add ((GtkContainer*) box, (GtkWidget*) _tmp19_);
	gtk_container_add ((GtkContainer*) box, (GtkWidget*) autoindent_modelbutton);
	_tmp20_ = self->priv->space_tab_modelbutton;
	gtk_container_add ((GtkContainer*) box, (GtkWidget*) _tmp20_);
	_tmp21_ = self->priv->_tab_box;
	gtk_container_add ((GtkContainer*) box, (GtkWidget*) _tmp21_);
	gtk_widget_show_all ((GtkWidget*) box);
	_tmp22_ = self->priv->tab_menubutton;
	_tmp23_ = (GtkPopover*) gtk_popover_new ((GtkWidget*) _tmp22_);
	gtk_popover_set_position (_tmp23_, GTK_POS_BOTTOM);
	g_object_ref_sink (_tmp23_);
	tab_popover = _tmp23_;
	gtk_container_add ((GtkContainer*) tab_popover, (GtkWidget*) box);
	_tmp24_ = self->priv->tab_menubutton;
	gtk_menu_button_set_popover ((GtkMenuButton*) _tmp24_, tab_popover);
	_tmp25_ = scratch_settings;
	g_signal_connect_object (_tmp25_, "changed::indent-width", (GCallback) _code_format_bar_format_tab_header_from_global_settings_g_settings_changed, self, 0);
	_tmp26_ = scratch_settings;
	g_signal_connect_object (_tmp26_, "changed::spaces-instead-of-tabs", (GCallback) _code_format_bar_format_tab_header_from_global_settings_g_settings_changed, self, 0);
	_tmp27_ = scratch_settings;
	g_settings_bind (_tmp27_, "auto-indent", (GObject*) autoindent_modelbutton, "active", G_SETTINGS_BIND_DEFAULT);
	code_format_bar_format_tab_header_from_global_settings (self);
	_tmp28_ = self->priv->_width_spinbutton;
	g_signal_connect_object (_tmp28_, "value-changed", (GCallback) ___lambda56__gtk_spin_button_value_changed, self, 0);
	_tmp29_ = self->priv->space_tab_modelbutton;
	g_signal_connect_object ((GtkButton*) _tmp29_, "clicked", (GCallback) ___lambda57__gtk_button_clicked, self, 0);
	_g_object_unref0 (tab_popover);
	_g_object_unref0 (box);
	_g_object_unref0 (width_label);
	_g_object_unref0 (autoindent_modelbutton);
}

static void
code_format_bar_format_tab_header_from_global_settings (CodeFormatBar* self)
{
	gboolean _tmp0_;
	gboolean _tmp2_;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_;
	GtkInfoBar* _tmp7_;
	GraniteSwitchModelButton* _tmp8_;
	gboolean _tmp9_;
	GtkBox* _tmp10_;
	gboolean _tmp11_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_tab_style_set_by_editor_config;
	if (!_tmp0_) {
		GSettings* _tmp1_;
		_tmp1_ = scratch_settings;
		code_format_bar_set_insert_spaces_instead_of_tabs (self, g_settings_get_boolean (_tmp1_, "spaces-instead-of-tabs"));
	}
	_tmp2_ = self->priv->_tab_width_set_by_editor_config;
	if (!_tmp2_) {
		GSettings* _tmp3_;
		_tmp3_ = scratch_settings;
		code_format_bar_set_tab_width (self, g_settings_get_int (_tmp3_, "indent-width"));
	}
	_tmp5_ = self->priv->_tab_style_set_by_editor_config;
	if (_tmp5_) {
		_tmp4_ = TRUE;
	} else {
		gboolean _tmp6_;
		_tmp6_ = self->priv->_tab_width_set_by_editor_config;
		_tmp4_ = _tmp6_;
	}
	_tmp7_ = self->priv->_editorconfig_infobar;
	gtk_info_bar_set_revealed (_tmp7_, _tmp4_);
	_tmp8_ = self->priv->space_tab_modelbutton;
	_tmp9_ = self->priv->_tab_style_set_by_editor_config;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp8_, !_tmp9_);
	_tmp10_ = self->priv->_tab_box;
	_tmp11_ = self->priv->_tab_width_set_by_editor_config;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp10_, !_tmp11_);
}

static void
code_format_bar_format_line_header (CodeFormatBar* self)
{
	GtkTextBuffer* buffer = NULL;
	ScratchServicesDocument* _tmp0_;
	ScratchWidgetsSourceView* _tmp1_;
	ScratchWidgetsSourceView* _tmp2_;
	GtkTextBuffer* _tmp3_;
	GtkTextBuffer* _tmp4_;
	GtkTextBuffer* _tmp5_;
	gint position = 0;
	gint _tmp6_;
	gint _tmp7_;
	GtkTextIter iter = {0};
	GtkTextIter _tmp8_ = {0};
	gint line = 0;
	CodeFormatBarFormatButton* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	GtkEntry* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->doc;
	_tmp1_ = scratch_services_document_get_source_view (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = gtk_text_view_get_buffer ((GtkTextView*) _tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = _g_object_ref0 (_tmp4_);
	buffer = _tmp5_;
	g_object_get (buffer, "cursor-position", &_tmp6_, NULL);
	_tmp7_ = _tmp6_;
	position = _tmp7_;
	gtk_text_buffer_get_iter_at_offset (buffer, &_tmp8_, position);
	iter = _tmp8_;
	line = gtk_text_iter_get_line (&iter) + 1;
	_tmp9_ = self->priv->_line_menubutton;
	_tmp10_ = g_strdup_printf ("%d.%d", line, gtk_text_iter_get_line_offset (&iter) + 1);
	_tmp11_ = _tmp10_;
	code_format_bar_format_button_set_text (_tmp9_, _tmp11_);
	_g_free0 (_tmp11_);
	_tmp12_ = self->priv->goto_entry;
	_tmp13_ = g_strdup_printf ("%d.%d", line, gtk_text_iter_get_line_offset (&iter) + 1);
	_tmp14_ = _tmp13_;
	gtk_entry_set_text (_tmp12_, _tmp14_);
	_g_free0 (_tmp14_);
	_g_object_unref0 (buffer);
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static void
__lambda58_ (CodeFormatBar* self)
{
	gint line = 0;
	gint column = 0;
	GtkEntry* _tmp0_;
	GtkEntry* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	GtkEntry* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	gint _tmp9_ = 0;
	gint _tmp10_ = 0;
	ScratchServicesDocument* _tmp11_;
	ScratchWidgetsSourceView* _tmp12_;
	ScratchWidgetsSourceView* _tmp13_;
	ScratchServicesDocument* _tmp14_;
	ScratchWidgetsSourceView* _tmp15_;
	ScratchWidgetsSourceView* _tmp16_;
	_tmp0_ = self->priv->goto_entry;
	_tmp1_ = self->priv->goto_entry;
	_tmp2_ = gtk_entry_get_text (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = string_replace (_tmp3_, ":", ".");
	_tmp5_ = _tmp4_;
	gtk_entry_set_text (_tmp0_, _tmp5_);
	_g_free0 (_tmp5_);
	_tmp6_ = self->priv->goto_entry;
	_tmp7_ = gtk_entry_get_text (_tmp6_);
	_tmp8_ = _tmp7_;
	sscanf (_tmp8_, "%i.%i", &_tmp9_, &_tmp10_);
	line = _tmp9_;
	column = _tmp10_;
	_tmp11_ = self->priv->doc;
	_tmp12_ = scratch_services_document_get_source_view (_tmp11_);
	_tmp13_ = _tmp12_;
	scratch_widgets_source_view_go_to_line (_tmp13_, line, column - 1);
	_tmp14_ = self->priv->doc;
	_tmp15_ = scratch_services_document_get_source_view (_tmp14_);
	_tmp16_ = _tmp15_;
	gtk_widget_grab_focus ((GtkWidget*) _tmp16_);
}

static void
___lambda58__gtk_entry_activate (GtkEntry* _sender,
                                 gpointer self)
{
	__lambda58_ ((CodeFormatBar*) self);
}

static void
code_format_bar_create_line_popover (CodeFormatBar* self)
{
	GtkLabel* goto_label = NULL;
	GtkLabel* _tmp0_;
	GtkEntry* _tmp1_;
	GtkGrid* line_grid = NULL;
	GtkGrid* _tmp2_;
	GtkEntry* _tmp3_;
	GtkPopover* line_popover = NULL;
	CodeFormatBarFormatButton* _tmp4_;
	GtkPopover* _tmp5_;
	CodeFormatBarFormatButton* _tmp6_;
	GtkEntry* _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = (GtkLabel*) gtk_label_new (_ ("Go To Line:"));
	g_object_ref_sink (_tmp0_);
	goto_label = _tmp0_;
	gtk_label_set_xalign (goto_label, (gfloat) 1);
	_tmp1_ = (GtkEntry*) gtk_entry_new ();
	g_object_ref_sink (_tmp1_);
	_g_object_unref0 (self->priv->goto_entry);
	self->priv->goto_entry = _tmp1_;
	_tmp2_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp2_);
	line_grid = _tmp2_;
	g_object_set ((GtkWidget*) line_grid, "margin", 12, NULL);
	gtk_grid_set_column_spacing (line_grid, 12);
	gtk_grid_attach (line_grid, (GtkWidget*) goto_label, 0, 0, 1, 1);
	_tmp3_ = self->priv->goto_entry;
	gtk_grid_attach (line_grid, (GtkWidget*) _tmp3_, 1, 0, 1, 1);
	gtk_widget_show_all ((GtkWidget*) line_grid);
	_tmp4_ = self->priv->_line_menubutton;
	_tmp5_ = (GtkPopover*) gtk_popover_new ((GtkWidget*) _tmp4_);
	g_object_ref_sink (_tmp5_);
	line_popover = _tmp5_;
	gtk_popover_set_position (line_popover, GTK_POS_BOTTOM);
	gtk_container_add ((GtkContainer*) line_popover, (GtkWidget*) line_grid);
	_tmp6_ = self->priv->_line_menubutton;
	gtk_menu_button_set_popover ((GtkMenuButton*) _tmp6_, line_popover);
	_tmp7_ = self->priv->goto_entry;
	g_signal_connect_object (_tmp7_, "activate", (GCallback) ___lambda58__gtk_entry_activate, self, G_CONNECT_AFTER);
	_g_object_unref0 (line_popover);
	_g_object_unref0 (line_grid);
	_g_object_unref0 (goto_label);
}

static void
_code_format_bar_format_line_header_g_object_notify (GObject* _sender,
                                                     GParamSpec* pspec,
                                                     gpointer self)
{
	code_format_bar_format_line_header ((CodeFormatBar*) self);
}

void
code_format_bar_set_document (CodeFormatBar* self,
                              ScratchServicesDocument* doc)
{
	ScratchServicesDocument* _tmp0_;
	ScratchServicesDocument* _tmp8_;
	ScratchWidgetsSourceView* _tmp9_;
	ScratchWidgetsSourceView* _tmp10_;
	GtkTextBuffer* _tmp11_;
	GtkTextBuffer* _tmp12_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (doc != NULL);
	_tmp0_ = self->priv->doc;
	if (_tmp0_ != NULL) {
		ScratchServicesDocument* _tmp1_;
		ScratchWidgetsSourceView* _tmp2_;
		ScratchWidgetsSourceView* _tmp3_;
		GtkTextBuffer* _tmp4_;
		GtkTextBuffer* _tmp5_;
		guint _tmp6_;
		GQuark _tmp7_;
		_tmp1_ = self->priv->doc;
		_tmp2_ = scratch_services_document_get_source_view (_tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = gtk_text_view_get_buffer ((GtkTextView*) _tmp3_);
		_tmp5_ = _tmp4_;
		g_signal_parse_name ("notify::cursor-position", G_TYPE_OBJECT, &_tmp6_, &_tmp7_, TRUE);
		g_signal_handlers_disconnect_matched ((GObject*) _tmp5_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp6_, _tmp7_, NULL, (GCallback) _code_format_bar_format_line_header_g_object_notify, self);
	}
	self->priv->doc = doc;
	code_format_bar_update_current_lang (self);
	code_format_bar_format_tab_header_from_global_settings (self);
	code_format_bar_format_line_header (self);
	_tmp8_ = self->priv->doc;
	_tmp9_ = scratch_services_document_get_source_view (_tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = gtk_text_view_get_buffer ((GtkTextView*) _tmp10_);
	_tmp12_ = _tmp11_;
	g_signal_connect_object ((GObject*) _tmp12_, "notify::cursor-position", (GCallback) _code_format_bar_format_line_header_g_object_notify, self, 0);
}

void
code_format_bar_set_insert_spaces_instead_of_tabs (CodeFormatBar* self,
                                                   gboolean use_spaces)
{
	GraniteSwitchModelButton* _tmp0_;
	ScratchServicesDocument* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->space_tab_modelbutton;
	gtk_toggle_button_set_active ((GtkToggleButton*) _tmp0_, use_spaces);
	_tmp1_ = self->priv->doc;
	if (_tmp1_ != NULL) {
		ScratchServicesDocument* _tmp2_;
		ScratchWidgetsSourceView* _tmp3_;
		ScratchWidgetsSourceView* _tmp4_;
		_tmp2_ = self->priv->doc;
		_tmp3_ = scratch_services_document_get_source_view (_tmp2_);
		_tmp4_ = _tmp3_;
		gtk_source_view_set_insert_spaces_instead_of_tabs ((GtkSourceView*) _tmp4_, use_spaces);
	}
}

void
code_format_bar_set_tab_width (CodeFormatBar* self,
                               gint indent_width)
{
	GtkSpinButton* _tmp0_;
	GraniteSwitchModelButton* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	ScratchServicesDocument* _tmp10_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_width_spinbutton;
	gtk_spin_button_set_value (_tmp0_, (gdouble) indent_width);
	_tmp1_ = self->priv->space_tab_modelbutton;
	_tmp2_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_) {
		CodeFormatBarFormatButton* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp4_ = self->priv->tab_menubutton;
		_tmp5_ = g_strdup_printf (ngettext ("%d Space", "%d Spaces", (gulong) indent_width), indent_width);
		_tmp6_ = _tmp5_;
		code_format_bar_format_button_set_text (_tmp4_, _tmp6_);
		_g_free0 (_tmp6_);
	} else {
		CodeFormatBarFormatButton* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		_tmp7_ = self->priv->tab_menubutton;
		_tmp8_ = g_strdup_printf (ngettext ("%d Tab", "%d Tabs", (gulong) indent_width), indent_width);
		_tmp9_ = _tmp8_;
		code_format_bar_format_button_set_text (_tmp7_, _tmp9_);
		_g_free0 (_tmp9_);
	}
	_tmp10_ = self->priv->doc;
	if (_tmp10_ != NULL) {
		ScratchServicesDocument* _tmp11_;
		ScratchWidgetsSourceView* _tmp12_;
		ScratchWidgetsSourceView* _tmp13_;
		ScratchServicesDocument* _tmp14_;
		ScratchWidgetsSourceView* _tmp15_;
		ScratchWidgetsSourceView* _tmp16_;
		_tmp11_ = self->priv->doc;
		_tmp12_ = scratch_services_document_get_source_view (_tmp11_);
		_tmp13_ = _tmp12_;
		gtk_source_view_set_indent_width ((GtkSourceView*) _tmp13_, indent_width);
		_tmp14_ = self->priv->doc;
		_tmp15_ = scratch_services_document_get_source_view (_tmp14_);
		_tmp16_ = _tmp15_;
		gtk_source_view_set_tab_width ((GtkSourceView*) _tmp16_, (guint) indent_width);
	}
}

static Block45Data*
block45_data_ref (Block45Data* _data45_)
{
	g_atomic_int_inc (&_data45_->_ref_count_);
	return _data45_;
}

static void
block45_data_unref (void * _userdata_)
{
	Block45Data* _data45_;
	_data45_ = (Block45Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data45_->_ref_count_)) {
		CodeFormatBar* self;
		self = _data45_->self;
		_g_free0 (_data45_->lang_id);
		_g_object_unref0 (self);
		g_slice_free (Block45Data, _data45_);
	}
}

static void
___lambda59_ (Block45Data* _data45_,
              GtkWidget* child)
{
	CodeFormatBar* self;
	CodeFormatBarLangEntry* lang_entry = NULL;
	CodeFormatBarLangEntry* _tmp0_;
	CodeFormatBarLangEntry* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	self = _data45_->self;
	g_return_if_fail (child != NULL);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (child, CODE_FORMAT_BAR_TYPE_LANG_ENTRY, CodeFormatBarLangEntry));
	lang_entry = _tmp0_;
	_tmp1_ = lang_entry;
	_tmp2_ = code_format_bar_lang_entry_get_lang_id (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _data45_->lang_id;
	if (g_strcmp0 (_tmp3_, _tmp4_) == 0) {
		CodeFormatBarLangEntry* _tmp5_;
		_tmp5_ = lang_entry;
		code_format_bar_select_language (self, _tmp5_, FALSE);
	}
	_g_object_unref0 (lang_entry);
}

static void
____lambda59__gfunc (gconstpointer data,
                     gpointer self)
{
	___lambda59_ (self, (GtkWidget*) data);
}

static void
code_format_bar_update_current_lang (CodeFormatBar* self)
{
	GtkSourceLanguage* language = NULL;
	ScratchServicesDocument* _tmp0_;
	ScratchWidgetsSourceView* _tmp1_;
	ScratchWidgetsSourceView* _tmp2_;
	GtkSourceLanguage* _tmp3_;
	GtkSourceLanguage* _tmp4_;
	GtkSourceLanguage* _tmp5_;
	GtkSourceLanguage* _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->doc;
	_tmp1_ = scratch_services_document_get_source_view (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = scratch_widgets_source_view_get_language (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = _g_object_ref0 (_tmp4_);
	language = _tmp5_;
	_tmp6_ = language;
	if (_tmp6_ != NULL) {
		Block45Data* _data45_;
		GtkSourceLanguage* _tmp7_;
		const gchar* _tmp8_;
		const gchar* _tmp9_;
		gchar* _tmp10_;
		GtkListBox* _tmp11_;
		GList* _tmp12_;
		GList* _tmp13_;
		_data45_ = g_slice_new0 (Block45Data);
		_data45_->_ref_count_ = 1;
		_data45_->self = g_object_ref (self);
		_tmp7_ = language;
		_tmp8_ = gtk_source_language_get_id (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = g_strdup (_tmp9_);
		_data45_->lang_id = _tmp10_;
		_tmp11_ = self->priv->lang_selection_listbox;
		_tmp12_ = gtk_container_get_children ((GtkContainer*) _tmp11_);
		_tmp13_ = _tmp12_;
		g_list_foreach (_tmp13_, ____lambda59__gfunc, _data45_);
		(_tmp13_ == NULL) ? NULL : (_tmp13_ = (g_list_free (_tmp13_), NULL));
		block45_data_unref (_data45_);
		_data45_ = NULL;
	} else {
		CodeFormatBarLangEntry* _tmp14_;
		_tmp14_ = self->priv->normal_entry;
		code_format_bar_select_language (self, _tmp14_, FALSE);
	}
	_g_object_unref0 (language);
}

CodeFormatBar*
code_format_bar_construct (GType object_type)
{
	CodeFormatBar * self = NULL;
	self = (CodeFormatBar*) g_object_new (object_type, NULL);
	return self;
}

CodeFormatBar*
code_format_bar_new (void)
{
	return code_format_bar_construct (CODE_TYPE_FORMAT_BAR);
}

gboolean
code_format_bar_get_tab_style_set_by_editor_config (CodeFormatBar* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_tab_style_set_by_editor_config;
	return result;
}

void
code_format_bar_set_tab_style_set_by_editor_config (CodeFormatBar* self,
                                                    gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = code_format_bar_get_tab_style_set_by_editor_config (self);
	if (old_value != value) {
		self->priv->_tab_style_set_by_editor_config = value;
		g_object_notify_by_pspec ((GObject *) self, code_format_bar_properties[CODE_FORMAT_BAR_TAB_STYLE_SET_BY_EDITOR_CONFIG_PROPERTY]);
	}
}

gboolean
code_format_bar_get_tab_width_set_by_editor_config (CodeFormatBar* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_tab_width_set_by_editor_config;
	return result;
}

void
code_format_bar_set_tab_width_set_by_editor_config (CodeFormatBar* self,
                                                    gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = code_format_bar_get_tab_width_set_by_editor_config (self);
	if (old_value != value) {
		self->priv->_tab_width_set_by_editor_config = value;
		g_object_notify_by_pspec ((GObject *) self, code_format_bar_properties[CODE_FORMAT_BAR_TAB_WIDTH_SET_BY_EDITOR_CONFIG_PROPERTY]);
	}
}

CodeFormatBarFormatButton*
code_format_bar_get_line_menubutton (CodeFormatBar* self)
{
	CodeFormatBarFormatButton* result;
	CodeFormatBarFormatButton* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_line_menubutton;
	result = _tmp0_;
	return result;
}

static void
code_format_bar_set_line_menubutton (CodeFormatBar* self,
                                     CodeFormatBarFormatButton* value)
{
	CodeFormatBarFormatButton* old_value;
	g_return_if_fail (self != NULL);
	old_value = code_format_bar_get_line_menubutton (self);
	if (old_value != value) {
		CodeFormatBarFormatButton* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_line_menubutton);
		self->priv->_line_menubutton = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, code_format_bar_properties[CODE_FORMAT_BAR_LINE_MENUBUTTON_PROPERTY]);
	}
}

GtkInfoBar*
code_format_bar_get_editorconfig_infobar (CodeFormatBar* self)
{
	GtkInfoBar* result;
	GtkInfoBar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_editorconfig_infobar;
	result = _tmp0_;
	return result;
}

void
code_format_bar_set_editorconfig_infobar (CodeFormatBar* self,
                                          GtkInfoBar* value)
{
	GtkInfoBar* old_value;
	g_return_if_fail (self != NULL);
	old_value = code_format_bar_get_editorconfig_infobar (self);
	if (old_value != value) {
		GtkInfoBar* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_editorconfig_infobar);
		self->priv->_editorconfig_infobar = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, code_format_bar_properties[CODE_FORMAT_BAR_EDITORCONFIG_INFOBAR_PROPERTY]);
	}
}

GtkBox*
code_format_bar_get_tab_box (CodeFormatBar* self)
{
	GtkBox* result;
	GtkBox* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_tab_box;
	result = _tmp0_;
	return result;
}

void
code_format_bar_set_tab_box (CodeFormatBar* self,
                             GtkBox* value)
{
	GtkBox* old_value;
	g_return_if_fail (self != NULL);
	old_value = code_format_bar_get_tab_box (self);
	if (old_value != value) {
		GtkBox* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_tab_box);
		self->priv->_tab_box = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, code_format_bar_properties[CODE_FORMAT_BAR_TAB_BOX_PROPERTY]);
	}
}

GtkSpinButton*
code_format_bar_get_width_spinbutton (CodeFormatBar* self)
{
	GtkSpinButton* result;
	GtkSpinButton* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_width_spinbutton;
	result = _tmp0_;
	return result;
}

void
code_format_bar_set_width_spinbutton (CodeFormatBar* self,
                                      GtkSpinButton* value)
{
	GtkSpinButton* old_value;
	g_return_if_fail (self != NULL);
	old_value = code_format_bar_get_width_spinbutton (self);
	if (old_value != value) {
		GtkSpinButton* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_width_spinbutton);
		self->priv->_width_spinbutton = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, code_format_bar_properties[CODE_FORMAT_BAR_WIDTH_SPINBUTTON_PROPERTY]);
	}
}

static inline gpointer
code_format_bar_format_button_get_instance_private (CodeFormatBarFormatButton* self)
{
	return G_STRUCT_MEMBER_P (self, CodeFormatBarFormatButton_private_offset);
}

CodeFormatBarFormatButton*
code_format_bar_format_button_construct (GType object_type)
{
	CodeFormatBarFormatButton * self = NULL;
	self = (CodeFormatBarFormatButton*) g_object_new (object_type, NULL);
	return self;
}

CodeFormatBarFormatButton*
code_format_bar_format_button_new (void)
{
	return code_format_bar_format_button_construct (CODE_FORMAT_BAR_TYPE_FORMAT_BUTTON);
}

void
code_format_bar_format_button_set_text (CodeFormatBarFormatButton* self,
                                        const gchar* value)
{
	GtkLabel* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->label_widget;
	_tmp1_ = g_strdup_printf ("<span font-features='tnum'>%s</span>", value);
	_tmp2_ = _tmp1_;
	gtk_label_set_label (_tmp0_, _tmp2_);
	_g_free0 (_tmp2_);
	g_object_notify_by_pspec ((GObject *) self, code_format_bar_format_button_properties[CODE_FORMAT_BAR_FORMAT_BUTTON_TEXT_PROPERTY]);
}

GIcon*
code_format_bar_format_button_get_icon (CodeFormatBarFormatButton* self)
{
	GIcon* result;
	GtkImage* _tmp0_;
	GIcon* _tmp1_;
	GIcon* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->img;
	g_object_get (_tmp0_, "gicon", &_tmp1_, NULL);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

void
code_format_bar_format_button_set_icon (CodeFormatBarFormatButton* self,
                                        GIcon* value)
{
	GtkImage* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->img;
	g_object_set (_tmp0_, "gicon", value, NULL);
	g_object_notify_by_pspec ((GObject *) self, code_format_bar_format_button_properties[CODE_FORMAT_BAR_FORMAT_BUTTON_ICON_PROPERTY]);
}

static GObject *
code_format_bar_format_button_constructor (GType type,
                                           guint n_construct_properties,
                                           GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	CodeFormatBarFormatButton * self;
	GtkImage* _tmp0_ = NULL;
	GtkLabel* _tmp1_ = NULL;
	GtkBox* box = NULL;
	GtkBox* _tmp2_ = NULL;
	GtkBox* _tmp3_;
	GtkImage* _tmp4_;
	GtkBox* _tmp5_;
	GtkLabel* _tmp6_;
	GtkBox* _tmp7_;
	parent_class = G_OBJECT_CLASS (code_format_bar_format_button_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CODE_FORMAT_BAR_TYPE_FORMAT_BUTTON, CodeFormatBarFormatButton);
	_tmp0_ = (GtkImage*) gtk_image_new ();
	g_object_set (_tmp0_, "icon-size", (gint) GTK_ICON_SIZE_SMALL_TOOLBAR, NULL);
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->img);
	self->priv->img = _tmp0_;
	_tmp1_ = (GtkLabel*) gtk_label_new (NULL);
	gtk_label_set_ellipsize (_tmp1_, PANGO_ELLIPSIZE_END);
	gtk_label_set_use_markup (_tmp1_, TRUE);
	g_object_ref_sink (_tmp1_);
	_g_object_unref0 (self->priv->label_widget);
	self->priv->label_widget = _tmp1_;
	_tmp2_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	gtk_widget_set_halign ((GtkWidget*) _tmp2_, GTK_ALIGN_CENTER);
	g_object_ref_sink (_tmp2_);
	box = _tmp2_;
	_tmp3_ = box;
	_tmp4_ = self->priv->img;
	gtk_container_add ((GtkContainer*) _tmp3_, (GtkWidget*) _tmp4_);
	_tmp5_ = box;
	_tmp6_ = self->priv->label_widget;
	gtk_container_add ((GtkContainer*) _tmp5_, (GtkWidget*) _tmp6_);
	_tmp7_ = box;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp7_);
	_g_object_unref0 (box);
	return obj;
}

static void
code_format_bar_format_button_class_init (CodeFormatBarFormatButtonClass * klass,
                                          gpointer klass_data)
{
	code_format_bar_format_button_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &CodeFormatBarFormatButton_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_code_format_bar_format_button_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_code_format_bar_format_button_set_property;
	G_OBJECT_CLASS (klass)->constructor = code_format_bar_format_button_constructor;
	G_OBJECT_CLASS (klass)->finalize = code_format_bar_format_button_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CODE_FORMAT_BAR_FORMAT_BUTTON_TEXT_PROPERTY, code_format_bar_format_button_properties[CODE_FORMAT_BAR_FORMAT_BUTTON_TEXT_PROPERTY] = g_param_spec_string ("text", "text", "text", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CODE_FORMAT_BAR_FORMAT_BUTTON_ICON_PROPERTY, code_format_bar_format_button_properties[CODE_FORMAT_BAR_FORMAT_BUTTON_ICON_PROPERTY] = g_param_spec_object ("icon", "icon", "icon", g_icon_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
code_format_bar_format_button_instance_init (CodeFormatBarFormatButton * self,
                                             gpointer klass)
{
	self->priv = code_format_bar_format_button_get_instance_private (self);
}

static void
code_format_bar_format_button_finalize (GObject * obj)
{
	CodeFormatBarFormatButton * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CODE_FORMAT_BAR_TYPE_FORMAT_BUTTON, CodeFormatBarFormatButton);
	_g_object_unref0 (self->priv->img);
	_g_object_unref0 (self->priv->label_widget);
	G_OBJECT_CLASS (code_format_bar_format_button_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
code_format_bar_format_button_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (CodeFormatBarFormatButtonClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) code_format_bar_format_button_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CodeFormatBarFormatButton), 0, (GInstanceInitFunc) code_format_bar_format_button_instance_init, NULL };
	GType code_format_bar_format_button_type_id;
	code_format_bar_format_button_type_id = g_type_register_static (gtk_menu_button_get_type (), "CodeFormatBarFormatButton", &g_define_type_info, 0);
	CodeFormatBarFormatButton_private_offset = g_type_add_instance_private (code_format_bar_format_button_type_id, sizeof (CodeFormatBarFormatButtonPrivate));
	return code_format_bar_format_button_type_id;
}

GType
code_format_bar_format_button_get_type (void)
{
	static gsize code_format_bar_format_button_type_id__once = 0;
	if (g_once_init_enter (&code_format_bar_format_button_type_id__once)) {
		GType code_format_bar_format_button_type_id;
		code_format_bar_format_button_type_id = code_format_bar_format_button_get_type_once ();
		g_once_init_leave (&code_format_bar_format_button_type_id__once, code_format_bar_format_button_type_id);
	}
	return code_format_bar_format_button_type_id__once;
}

static void
_vala_code_format_bar_format_button_get_property (GObject * object,
                                                  guint property_id,
                                                  GValue * value,
                                                  GParamSpec * pspec)
{
	CodeFormatBarFormatButton * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CODE_FORMAT_BAR_TYPE_FORMAT_BUTTON, CodeFormatBarFormatButton);
	switch (property_id) {
		case CODE_FORMAT_BAR_FORMAT_BUTTON_ICON_PROPERTY:
		g_value_take_object (value, code_format_bar_format_button_get_icon (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_code_format_bar_format_button_set_property (GObject * object,
                                                  guint property_id,
                                                  const GValue * value,
                                                  GParamSpec * pspec)
{
	CodeFormatBarFormatButton * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CODE_FORMAT_BAR_TYPE_FORMAT_BUTTON, CodeFormatBarFormatButton);
	switch (property_id) {
		case CODE_FORMAT_BAR_FORMAT_BUTTON_TEXT_PROPERTY:
		code_format_bar_format_button_set_text (self, g_value_get_string (value));
		break;
		case CODE_FORMAT_BAR_FORMAT_BUTTON_ICON_PROPERTY:
		code_format_bar_format_button_set_icon (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
code_format_bar_lang_entry_get_instance_private (CodeFormatBarLangEntry* self)
{
	return G_STRUCT_MEMBER_P (self, CodeFormatBarLangEntry_private_offset);
}

CodeFormatBarLangEntry*
code_format_bar_lang_entry_construct (GType object_type,
                                      const gchar* lang_id,
                                      const gchar* lang_name,
                                      GSList* group)
{
	CodeFormatBarLangEntry * self = NULL;
	g_return_val_if_fail (lang_name != NULL, NULL);
	self = (CodeFormatBarLangEntry*) g_object_new (object_type, "group", group, "lang-id", lang_id, "lang-name", lang_name, NULL);
	return self;
}

CodeFormatBarLangEntry*
code_format_bar_lang_entry_new (const gchar* lang_id,
                                const gchar* lang_name,
                                GSList* group)
{
	return code_format_bar_lang_entry_construct (CODE_FORMAT_BAR_TYPE_LANG_ENTRY, lang_id, lang_name, group);
}

static void
code_format_bar_lang_entry_radio_toggled (CodeFormatBarLangEntry* self)
{
	GtkRadioButton* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->lang_radio;
	_tmp1_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		g_signal_emit_by_name ((GtkListBoxRow*) self, "activate");
	}
}

GSList*
code_format_bar_lang_entry_get_radio_group (CodeFormatBarLangEntry* self)
{
	GtkRadioButton* _tmp0_;
	GSList* _tmp1_;
	GSList* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->lang_radio;
	_tmp1_ = gtk_radio_button_get_group (_tmp0_);
	result = _tmp1_;
	return result;
}

const gchar*
code_format_bar_lang_entry_get_lang_id (CodeFormatBarLangEntry* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_lang_id;
	result = _tmp0_;
	return result;
}

static void
code_format_bar_lang_entry_set_lang_id (CodeFormatBarLangEntry* self,
                                        const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = code_format_bar_lang_entry_get_lang_id (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_lang_id);
		self->priv->_lang_id = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, code_format_bar_lang_entry_properties[CODE_FORMAT_BAR_LANG_ENTRY_LANG_ID_PROPERTY]);
	}
}

const gchar*
code_format_bar_lang_entry_get_lang_name (CodeFormatBarLangEntry* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_lang_name;
	result = _tmp0_;
	return result;
}

static void
code_format_bar_lang_entry_set_lang_name (CodeFormatBarLangEntry* self,
                                          const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = code_format_bar_lang_entry_get_lang_name (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_lang_name);
		self->priv->_lang_name = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, code_format_bar_lang_entry_properties[CODE_FORMAT_BAR_LANG_ENTRY_LANG_NAME_PROPERTY]);
	}
}

GSList*
code_format_bar_lang_entry_get_group (CodeFormatBarLangEntry* self)
{
	GSList* result;
	GSList* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_group;
	result = _tmp0_;
	return result;
}

static void
code_format_bar_lang_entry_set_group (CodeFormatBarLangEntry* self,
                                      GSList* value)
{
	GSList* old_value;
	g_return_if_fail (self != NULL);
	old_value = code_format_bar_lang_entry_get_group (self);
	if (old_value != value) {
		self->priv->_group = value;
		g_object_notify_by_pspec ((GObject *) self, code_format_bar_lang_entry_properties[CODE_FORMAT_BAR_LANG_ENTRY_GROUP_PROPERTY]);
	}
}

gboolean
code_format_bar_lang_entry_get_active (CodeFormatBarLangEntry* self)
{
	gboolean result;
	GtkRadioButton* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->lang_radio;
	_tmp1_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

void
code_format_bar_lang_entry_set_active (CodeFormatBarLangEntry* self,
                                       gboolean value)
{
	GtkRadioButton* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->lang_radio;
	gtk_toggle_button_set_active ((GtkToggleButton*) _tmp0_, value);
	g_object_notify_by_pspec ((GObject *) self, code_format_bar_lang_entry_properties[CODE_FORMAT_BAR_LANG_ENTRY_ACTIVE_PROPERTY]);
}

gboolean
code_format_bar_lang_entry_get_selected (CodeFormatBarLangEntry* self)
{
	gboolean result;
	GtkRadioButton* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->lang_radio;
	_tmp1_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

static void
_code_format_bar_lang_entry_radio_toggled_gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                                                     gpointer self)
{
	code_format_bar_lang_entry_radio_toggled ((CodeFormatBarLangEntry*) self);
}

void
code_format_bar_lang_entry_set_selected (CodeFormatBarLangEntry* self,
                                         gboolean value)
{
	GtkRadioButton* _tmp0_;
	guint _tmp1_;
	GtkRadioButton* _tmp2_;
	GtkRadioButton* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->lang_radio;
	g_signal_parse_name ("toggled", gtk_toggle_button_get_type (), &_tmp1_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((GtkToggleButton*) _tmp0_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _code_format_bar_lang_entry_radio_toggled_gtk_toggle_button_toggled, self);
	_tmp2_ = self->priv->lang_radio;
	gtk_toggle_button_set_active ((GtkToggleButton*) _tmp2_, value);
	_tmp3_ = self->priv->lang_radio;
	g_signal_connect_object ((GtkToggleButton*) _tmp3_, "toggled", (GCallback) _code_format_bar_lang_entry_radio_toggled_gtk_toggle_button_toggled, self, 0);
	g_object_notify_by_pspec ((GObject *) self, code_format_bar_lang_entry_properties[CODE_FORMAT_BAR_LANG_ENTRY_SELECTED_PROPERTY]);
}

static GObject *
code_format_bar_lang_entry_constructor (GType type,
                                        guint n_construct_properties,
                                        GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	CodeFormatBarLangEntry * self;
	GSList* _tmp0_;
	const gchar* _tmp1_;
	GtkRadioButton* _tmp2_;
	GtkRadioButton* _tmp3_;
	GtkRadioButton* _tmp4_;
	parent_class = G_OBJECT_CLASS (code_format_bar_lang_entry_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CODE_FORMAT_BAR_TYPE_LANG_ENTRY, CodeFormatBarLangEntry);
	_tmp0_ = self->priv->_group;
	_tmp1_ = self->priv->_lang_name;
	_tmp2_ = (GtkRadioButton*) gtk_radio_button_new_with_label (_tmp0_, _tmp1_);
	g_object_ref_sink (_tmp2_);
	_g_object_unref0 (self->priv->lang_radio);
	self->priv->lang_radio = _tmp2_;
	_tmp3_ = self->priv->lang_radio;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp3_);
	_tmp4_ = self->priv->lang_radio;
	g_signal_connect_object ((GtkToggleButton*) _tmp4_, "toggled", (GCallback) _code_format_bar_lang_entry_radio_toggled_gtk_toggle_button_toggled, self, 0);
	return obj;
}

static void
code_format_bar_lang_entry_base_init (CodeFormatBarLangEntryClass * klass)
{
	gtk_widget_class_set_css_name (GTK_WIDGET_CLASS (klass), GTK_STYLE_CLASS_MENUITEM);
}

static void
code_format_bar_lang_entry_class_init (CodeFormatBarLangEntryClass * klass,
                                       gpointer klass_data)
{
	code_format_bar_lang_entry_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &CodeFormatBarLangEntry_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_code_format_bar_lang_entry_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_code_format_bar_lang_entry_set_property;
	G_OBJECT_CLASS (klass)->constructor = code_format_bar_lang_entry_constructor;
	G_OBJECT_CLASS (klass)->finalize = code_format_bar_lang_entry_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CODE_FORMAT_BAR_LANG_ENTRY_LANG_ID_PROPERTY, code_format_bar_lang_entry_properties[CODE_FORMAT_BAR_LANG_ENTRY_LANG_ID_PROPERTY] = g_param_spec_string ("lang-id", "lang-id", "lang-id", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CODE_FORMAT_BAR_LANG_ENTRY_LANG_NAME_PROPERTY, code_format_bar_lang_entry_properties[CODE_FORMAT_BAR_LANG_ENTRY_LANG_NAME_PROPERTY] = g_param_spec_string ("lang-name", "lang-name", "lang-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CODE_FORMAT_BAR_LANG_ENTRY_GROUP_PROPERTY, code_format_bar_lang_entry_properties[CODE_FORMAT_BAR_LANG_ENTRY_GROUP_PROPERTY] = g_param_spec_pointer ("group", "group", "group", G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CODE_FORMAT_BAR_LANG_ENTRY_ACTIVE_PROPERTY, code_format_bar_lang_entry_properties[CODE_FORMAT_BAR_LANG_ENTRY_ACTIVE_PROPERTY] = g_param_spec_boolean ("active", "active", "active", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CODE_FORMAT_BAR_LANG_ENTRY_SELECTED_PROPERTY, code_format_bar_lang_entry_properties[CODE_FORMAT_BAR_LANG_ENTRY_SELECTED_PROPERTY] = g_param_spec_boolean ("selected", "selected", "selected", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
code_format_bar_lang_entry_instance_init (CodeFormatBarLangEntry * self,
                                          gpointer klass)
{
	self->priv = code_format_bar_lang_entry_get_instance_private (self);
}

static void
code_format_bar_lang_entry_finalize (GObject * obj)
{
	CodeFormatBarLangEntry * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CODE_FORMAT_BAR_TYPE_LANG_ENTRY, CodeFormatBarLangEntry);
	_g_free0 (self->priv->_lang_id);
	_g_free0 (self->priv->_lang_name);
	_g_object_unref0 (self->priv->lang_radio);
	G_OBJECT_CLASS (code_format_bar_lang_entry_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
code_format_bar_lang_entry_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (CodeFormatBarLangEntryClass), (GBaseInitFunc) code_format_bar_lang_entry_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) code_format_bar_lang_entry_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CodeFormatBarLangEntry), 0, (GInstanceInitFunc) code_format_bar_lang_entry_instance_init, NULL };
	GType code_format_bar_lang_entry_type_id;
	code_format_bar_lang_entry_type_id = g_type_register_static (gtk_list_box_row_get_type (), "CodeFormatBarLangEntry", &g_define_type_info, 0);
	CodeFormatBarLangEntry_private_offset = g_type_add_instance_private (code_format_bar_lang_entry_type_id, sizeof (CodeFormatBarLangEntryPrivate));
	return code_format_bar_lang_entry_type_id;
}

GType
code_format_bar_lang_entry_get_type (void)
{
	static gsize code_format_bar_lang_entry_type_id__once = 0;
	if (g_once_init_enter (&code_format_bar_lang_entry_type_id__once)) {
		GType code_format_bar_lang_entry_type_id;
		code_format_bar_lang_entry_type_id = code_format_bar_lang_entry_get_type_once ();
		g_once_init_leave (&code_format_bar_lang_entry_type_id__once, code_format_bar_lang_entry_type_id);
	}
	return code_format_bar_lang_entry_type_id__once;
}

static void
_vala_code_format_bar_lang_entry_get_property (GObject * object,
                                               guint property_id,
                                               GValue * value,
                                               GParamSpec * pspec)
{
	CodeFormatBarLangEntry * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CODE_FORMAT_BAR_TYPE_LANG_ENTRY, CodeFormatBarLangEntry);
	switch (property_id) {
		case CODE_FORMAT_BAR_LANG_ENTRY_LANG_ID_PROPERTY:
		g_value_set_string (value, code_format_bar_lang_entry_get_lang_id (self));
		break;
		case CODE_FORMAT_BAR_LANG_ENTRY_LANG_NAME_PROPERTY:
		g_value_set_string (value, code_format_bar_lang_entry_get_lang_name (self));
		break;
		case CODE_FORMAT_BAR_LANG_ENTRY_GROUP_PROPERTY:
		g_value_set_pointer (value, code_format_bar_lang_entry_get_group (self));
		break;
		case CODE_FORMAT_BAR_LANG_ENTRY_ACTIVE_PROPERTY:
		g_value_set_boolean (value, code_format_bar_lang_entry_get_active (self));
		break;
		case CODE_FORMAT_BAR_LANG_ENTRY_SELECTED_PROPERTY:
		g_value_set_boolean (value, code_format_bar_lang_entry_get_selected (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_code_format_bar_lang_entry_set_property (GObject * object,
                                               guint property_id,
                                               const GValue * value,
                                               GParamSpec * pspec)
{
	CodeFormatBarLangEntry * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CODE_FORMAT_BAR_TYPE_LANG_ENTRY, CodeFormatBarLangEntry);
	switch (property_id) {
		case CODE_FORMAT_BAR_LANG_ENTRY_LANG_ID_PROPERTY:
		code_format_bar_lang_entry_set_lang_id (self, g_value_get_string (value));
		break;
		case CODE_FORMAT_BAR_LANG_ENTRY_LANG_NAME_PROPERTY:
		code_format_bar_lang_entry_set_lang_name (self, g_value_get_string (value));
		break;
		case CODE_FORMAT_BAR_LANG_ENTRY_GROUP_PROPERTY:
		code_format_bar_lang_entry_set_group (self, g_value_get_pointer (value));
		break;
		case CODE_FORMAT_BAR_LANG_ENTRY_ACTIVE_PROPERTY:
		code_format_bar_lang_entry_set_active (self, g_value_get_boolean (value));
		break;
		case CODE_FORMAT_BAR_LANG_ENTRY_SELECTED_PROPERTY:
		code_format_bar_lang_entry_set_selected (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static GObject *
code_format_bar_constructor (GType type,
                             guint n_construct_properties,
                             GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	CodeFormatBar * self;
	GtkStyleContext* _tmp0_;
	GtkSourceLanguageManager* _tmp1_;
	GtkSourceLanguageManager* _tmp2_;
	GThemedIcon* _tmp3_;
	GThemedIcon* _tmp4_;
	CodeFormatBarFormatButton* _tmp5_ = NULL;
	GThemedIcon* _tmp6_;
	GThemedIcon* _tmp7_;
	gchar* _tmp8_;
	CodeFormatBarFormatButton* _tmp9_ = NULL;
	GThemedIcon* _tmp10_;
	GThemedIcon* _tmp11_;
	CodeFormatBarFormatButton* _tmp12_ = NULL;
	CodeFormatBarFormatButton* _tmp13_;
	CodeFormatBarFormatButton* _tmp14_;
	GApplication* _tmp15_;
	gchar** _tmp16_;
	gchar** _tmp17_;
	gchar** _tmp18_;
	gint _tmp18__length1;
	gchar* _tmp19_;
	gchar* _tmp20_;
	CodeFormatBarFormatButton* _tmp21_;
	CodeFormatBarFormatButton* _tmp22_;
	CodeFormatBarFormatButton* _tmp23_;
	parent_class = G_OBJECT_CLASS (code_format_bar_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CODE_TYPE_FORMAT_BAR, CodeFormatBar);
	_tmp0_ = gtk_widget_get_style_context ((GtkWidget*) self);
	gtk_style_context_add_class (_tmp0_, GTK_STYLE_CLASS_LINKED);
	_tmp1_ = gtk_source_language_manager_get_default ();
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (self->priv->manager);
	self->priv->manager = _tmp2_;
	_tmp3_ = (GThemedIcon*) g_themed_icon_new ("format-indent-more-symbolic");
	_tmp4_ = _tmp3_;
	_tmp5_ = code_format_bar_format_button_new ();
	code_format_bar_format_button_set_icon (_tmp5_, (GIcon*) _tmp4_);
	g_object_ref_sink (_tmp5_);
	_g_object_unref0 (self->priv->tab_menubutton);
	self->priv->tab_menubutton = _tmp5_;
	_g_object_unref0 (_tmp4_);
	_tmp6_ = (GThemedIcon*) g_themed_icon_new ("application-x-class-file-symbolic");
	_tmp7_ = _tmp6_;
	_tmp8_ = g_strdup (_ ("Syntax Highlighting"));
	_tmp9_ = code_format_bar_format_button_new ();
	code_format_bar_format_button_set_icon (_tmp9_, (GIcon*) _tmp7_);
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp9_, _tmp8_);
	_g_free0 (_tmp8_);
	g_object_ref_sink (_tmp9_);
	_g_object_unref0 (self->priv->lang_menubutton);
	self->priv->lang_menubutton = _tmp9_;
	_g_object_unref0 (_tmp7_);
	_tmp10_ = (GThemedIcon*) g_themed_icon_new ("view-continuous-symbolic");
	_tmp11_ = _tmp10_;
	_tmp12_ = code_format_bar_format_button_new ();
	code_format_bar_format_button_set_icon (_tmp12_, (GIcon*) _tmp11_);
	g_object_ref_sink (_tmp12_);
	_tmp13_ = _tmp12_;
	code_format_bar_set_line_menubutton (self, _tmp13_);
	_g_object_unref0 (_tmp13_);
	_g_object_unref0 (_tmp11_);
	_tmp14_ = self->priv->_line_menubutton;
	_tmp15_ = g_application_get_default ();
	_tmp17_ = _tmp16_ = gtk_application_get_accels_for_action ((GtkApplication*) G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, SCRATCH_TYPE_APPLICATION, ScratchApplication), SCRATCH_MAIN_WINDOW_ACTION_PREFIX SCRATCH_MAIN_WINDOW_ACTION_GO_TO);
	_tmp18_ = _tmp17_;
	_tmp18__length1 = _vala_array_length (_tmp16_);
	_tmp19_ = granite_markup_accel_tooltip (_tmp18_, (gint) _vala_array_length (_tmp16_), _ ("Line number"));
	_tmp20_ = _tmp19_;
	gtk_widget_set_tooltip_markup ((GtkWidget*) _tmp14_, _tmp20_);
	_g_free0 (_tmp20_);
	_tmp18_ = (_vala_array_free (_tmp18_, _tmp18__length1, (GDestroyNotify) g_free), NULL);
	gtk_box_set_homogeneous ((GtkBox*) self, TRUE);
	_tmp21_ = self->priv->tab_menubutton;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp21_);
	_tmp22_ = self->priv->lang_menubutton;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp22_);
	_tmp23_ = self->priv->_line_menubutton;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp23_);
	code_format_bar_create_tabulation_popover (self);
	code_format_bar_create_language_popover (self);
	code_format_bar_create_line_popover (self);
	return obj;
}

static void
code_format_bar_class_init (CodeFormatBarClass * klass,
                            gpointer klass_data)
{
	code_format_bar_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &CodeFormatBar_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_code_format_bar_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_code_format_bar_set_property;
	G_OBJECT_CLASS (klass)->constructor = code_format_bar_constructor;
	G_OBJECT_CLASS (klass)->finalize = code_format_bar_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CODE_FORMAT_BAR_TAB_STYLE_SET_BY_EDITOR_CONFIG_PROPERTY, code_format_bar_properties[CODE_FORMAT_BAR_TAB_STYLE_SET_BY_EDITOR_CONFIG_PROPERTY] = g_param_spec_boolean ("tab-style-set-by-editor-config", "tab-style-set-by-editor-config", "tab-style-set-by-editor-config", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CODE_FORMAT_BAR_TAB_WIDTH_SET_BY_EDITOR_CONFIG_PROPERTY, code_format_bar_properties[CODE_FORMAT_BAR_TAB_WIDTH_SET_BY_EDITOR_CONFIG_PROPERTY] = g_param_spec_boolean ("tab-width-set-by-editor-config", "tab-width-set-by-editor-config", "tab-width-set-by-editor-config", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CODE_FORMAT_BAR_LINE_MENUBUTTON_PROPERTY, code_format_bar_properties[CODE_FORMAT_BAR_LINE_MENUBUTTON_PROPERTY] = g_param_spec_object ("line-menubutton", "line-menubutton", "line-menubutton", CODE_FORMAT_BAR_TYPE_FORMAT_BUTTON, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CODE_FORMAT_BAR_EDITORCONFIG_INFOBAR_PROPERTY, code_format_bar_properties[CODE_FORMAT_BAR_EDITORCONFIG_INFOBAR_PROPERTY] = g_param_spec_object ("editorconfig-infobar", "editorconfig-infobar", "editorconfig-infobar", gtk_info_bar_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CODE_FORMAT_BAR_TAB_BOX_PROPERTY, code_format_bar_properties[CODE_FORMAT_BAR_TAB_BOX_PROPERTY] = g_param_spec_object ("tab-box", "tab-box", "tab-box", gtk_box_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CODE_FORMAT_BAR_WIDTH_SPINBUTTON_PROPERTY, code_format_bar_properties[CODE_FORMAT_BAR_WIDTH_SPINBUTTON_PROPERTY] = g_param_spec_object ("width-spinbutton", "width-spinbutton", "width-spinbutton", gtk_spin_button_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
}

static void
code_format_bar_instance_init (CodeFormatBar * self,
                               gpointer klass)
{
	self->priv = code_format_bar_get_instance_private (self);
	self->priv->_tab_style_set_by_editor_config = FALSE;
	self->priv->_tab_width_set_by_editor_config = FALSE;
	self->priv->doc = NULL;
}

static void
code_format_bar_finalize (GObject * obj)
{
	CodeFormatBar * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CODE_TYPE_FORMAT_BAR, CodeFormatBar);
	_g_object_unref0 (self->priv->_line_menubutton);
	_g_object_unref0 (self->priv->_editorconfig_infobar);
	_g_object_unref0 (self->priv->_tab_box);
	_g_object_unref0 (self->priv->_width_spinbutton);
	_g_object_unref0 (self->priv->lang_menubutton);
	_g_object_unref0 (self->priv->tab_menubutton);
	_g_object_unref0 (self->priv->space_tab_modelbutton);
	_g_object_unref0 (self->priv->goto_entry);
	_g_object_unref0 (self->priv->lang_selection_listbox);
	_g_object_unref0 (self->priv->lang_selection_filter);
	_g_object_unref0 (self->priv->manager);
	_g_object_unref0 (self->priv->normal_entry);
	G_OBJECT_CLASS (code_format_bar_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
code_format_bar_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (CodeFormatBarClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) code_format_bar_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CodeFormatBar), 0, (GInstanceInitFunc) code_format_bar_instance_init, NULL };
	GType code_format_bar_type_id;
	code_format_bar_type_id = g_type_register_static (gtk_box_get_type (), "CodeFormatBar", &g_define_type_info, 0);
	CodeFormatBar_private_offset = g_type_add_instance_private (code_format_bar_type_id, sizeof (CodeFormatBarPrivate));
	return code_format_bar_type_id;
}

GType
code_format_bar_get_type (void)
{
	static gsize code_format_bar_type_id__once = 0;
	if (g_once_init_enter (&code_format_bar_type_id__once)) {
		GType code_format_bar_type_id;
		code_format_bar_type_id = code_format_bar_get_type_once ();
		g_once_init_leave (&code_format_bar_type_id__once, code_format_bar_type_id);
	}
	return code_format_bar_type_id__once;
}

static void
_vala_code_format_bar_get_property (GObject * object,
                                    guint property_id,
                                    GValue * value,
                                    GParamSpec * pspec)
{
	CodeFormatBar * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CODE_TYPE_FORMAT_BAR, CodeFormatBar);
	switch (property_id) {
		case CODE_FORMAT_BAR_TAB_STYLE_SET_BY_EDITOR_CONFIG_PROPERTY:
		g_value_set_boolean (value, code_format_bar_get_tab_style_set_by_editor_config (self));
		break;
		case CODE_FORMAT_BAR_TAB_WIDTH_SET_BY_EDITOR_CONFIG_PROPERTY:
		g_value_set_boolean (value, code_format_bar_get_tab_width_set_by_editor_config (self));
		break;
		case CODE_FORMAT_BAR_LINE_MENUBUTTON_PROPERTY:
		g_value_set_object (value, code_format_bar_get_line_menubutton (self));
		break;
		case CODE_FORMAT_BAR_EDITORCONFIG_INFOBAR_PROPERTY:
		g_value_set_object (value, code_format_bar_get_editorconfig_infobar (self));
		break;
		case CODE_FORMAT_BAR_TAB_BOX_PROPERTY:
		g_value_set_object (value, code_format_bar_get_tab_box (self));
		break;
		case CODE_FORMAT_BAR_WIDTH_SPINBUTTON_PROPERTY:
		g_value_set_object (value, code_format_bar_get_width_spinbutton (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_code_format_bar_set_property (GObject * object,
                                    guint property_id,
                                    const GValue * value,
                                    GParamSpec * pspec)
{
	CodeFormatBar * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CODE_TYPE_FORMAT_BAR, CodeFormatBar);
	switch (property_id) {
		case CODE_FORMAT_BAR_TAB_STYLE_SET_BY_EDITOR_CONFIG_PROPERTY:
		code_format_bar_set_tab_style_set_by_editor_config (self, g_value_get_boolean (value));
		break;
		case CODE_FORMAT_BAR_TAB_WIDTH_SET_BY_EDITOR_CONFIG_PROPERTY:
		code_format_bar_set_tab_width_set_by_editor_config (self, g_value_get_boolean (value));
		break;
		case CODE_FORMAT_BAR_LINE_MENUBUTTON_PROPERTY:
		code_format_bar_set_line_menubutton (self, g_value_get_object (value));
		break;
		case CODE_FORMAT_BAR_EDITORCONFIG_INFOBAR_PROPERTY:
		code_format_bar_set_editorconfig_infobar (self, g_value_get_object (value));
		break;
		case CODE_FORMAT_BAR_TAB_BOX_PROPERTY:
		code_format_bar_set_tab_box (self, g_value_get_object (value));
		break;
		case CODE_FORMAT_BAR_WIDTH_SPINBUTTON_PROPERTY:
		code_format_bar_set_width_spinbutton (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

