﻿#ifndef LIBRETRO_CORE_OPTIONS_INTL_H__
#define LIBRETRO_CORE_OPTIONS_INTL_H__

#if defined(_MSC_VER) && (_MSC_VER >= 1500 && _MSC_VER < 1900)
/* https://support.microsoft.com/en-us/kb/980263 */
#pragma execution_character_set("utf-8")
#pragma warning(disable:4566)
#endif

#include <libretro.h>

/*
 ********************************
 * VERSION: 1.3
 ********************************
 *
 * - 1.3: Move translations to libretro_core_options_intl.h
 *        - libretro_core_options_intl.h includes BOM and utf-8
 *          fix for MSVC 2010-2013
 *        - Added HAVE_NO_LANGEXTRA flag to disable translations
 *          on platforms/compilers without BOM support
 * - 1.2: Use core options v1 interface when
 *        RETRO_ENVIRONMENT_GET_CORE_OPTIONS_VERSION is >= 1
 *        (previously required RETRO_ENVIRONMENT_GET_CORE_OPTIONS_VERSION == 1)
 * - 1.1: Support generation of core options v0 retro_core_option_value
 *        arrays containing options with a single value
 * - 1.0: First commit
*/

#ifdef __cplusplus
extern "C" {
#endif

/*
 ********************************
 * Core Option Definitions
 ********************************
*/
/* RETRO_LANGUAGE_AR */

#define CATEGORY_SYSTEM_LABEL_AR "نظام"
#define CATEGORY_SYSTEM_INFO_0_AR NULL
#define CATEGORY_VIDEO_LABEL_AR "الفيديو"
#define CATEGORY_VIDEO_INFO_0_AR NULL
#define CATEGORY_AUDIO_LABEL_AR "الصوت"
#define CATEGORY_AUDIO_INFO_0_AR NULL
#define CATEGORY_INPUT_LABEL_AR "أجهزة الادخال"
#define CATEGORY_INPUT_INFO_0_AR NULL
#define CATEGORY_HACKS_LABEL_AR NULL
#define CATEGORY_HACKS_INFO_0_AR NULL
#define CATEGORY_CHANNEL_VOLUME_LABEL_AR NULL
#define CATEGORY_CHANNEL_VOLUME_INFO_0_AR NULL
#define GENESIS_PLUS_GX_SYSTEM_HW_LABEL_AR NULL
#define GENESIS_PLUS_GX_SYSTEM_HW_INFO_0_AR NULL
#define OPTION_VAL_AUTO_AR "تلقائي"
#define OPTION_VAL_SG_1000_AR NULL
#define OPTION_VAL_SG_1000_II_AR NULL
#define OPTION_VAL_SG_1000_II_RAM_EXT_AR NULL
#define OPTION_VAL_MARK_III_AR NULL
#define OPTION_VAL_MASTER_SYSTEM_AR NULL
#define OPTION_VAL_MASTER_SYSTEM_II_AR NULL
#define OPTION_VAL_GAME_GEAR_AR NULL
#define OPTION_VAL_MEGA_DRIVE_GENESIS_AR NULL
#define GENESIS_PLUS_GX_REGION_DETECT_LABEL_AR NULL
#define GENESIS_PLUS_GX_REGION_DETECT_INFO_0_AR NULL
#define OPTION_VAL_NTSC_U_AR NULL
#define OPTION_VAL_PAL_AR NULL
#define OPTION_VAL_NTSC_J_AR NULL
#define GENESIS_PLUS_GX_VDP_MODE_LABEL_AR "فرض وضع VDP"
#define GENESIS_PLUS_GX_VDP_MODE_INFO_0_AR NULL
#define OPTION_VAL_60HZ_AR NULL
#define OPTION_VAL_50HZ_AR NULL
#define GENESIS_PLUS_GX_BIOS_LABEL_AR NULL
#define GENESIS_PLUS_GX_BIOS_INFO_0_AR NULL
#define GENESIS_PLUS_GX_SYSTEM_BRAM_LABEL_AR NULL
#define GENESIS_PLUS_GX_SYSTEM_BRAM_INFO_0_AR NULL
#define OPTION_VAL_PER_BIOS_AR NULL
#define OPTION_VAL_PER_GAME_AR NULL
#define GENESIS_PLUS_GX_CART_BRAM_LABEL_AR NULL
#define GENESIS_PLUS_GX_CART_BRAM_INFO_0_AR NULL
#define OPTION_VAL_PER_CART_AR NULL
#define GENESIS_PLUS_GX_CART_SIZE_LABEL_AR NULL
#define GENESIS_PLUS_GX_CART_SIZE_INFO_0_AR NULL
#define OPTION_VAL_128K_AR NULL
#define OPTION_VAL_256K_AR NULL
#define OPTION_VAL_512K_AR NULL
#define OPTION_VAL_1MEG_AR NULL
#define OPTION_VAL_2MEG_AR NULL
#define OPTION_VAL_4MEG_AR NULL
#define GENESIS_PLUS_GX_ADD_ON_LABEL_AR NULL
#define GENESIS_PLUS_GX_ADD_ON_INFO_0_AR NULL
#define OPTION_VAL_SEGA_MEGA_CD_AR NULL
#define OPTION_VAL_MEGASD_AR NULL
#define OPTION_VAL_NONE_AR "لاشيء"
#define GENESIS_PLUS_GX_LOCK_ON_LABEL_AR NULL
#define GENESIS_PLUS_GX_LOCK_ON_INFO_0_AR NULL
#define OPTION_VAL_GAME_GENIE_AR NULL
#define OPTION_VAL_ACTION_REPLAY_PRO_AR NULL
#define OPTION_VAL_SONIC_KNUCKLES_AR NULL
#define GENESIS_PLUS_GX_ASPECT_RATIO_LABEL_AR NULL
#define GENESIS_PLUS_GX_ASPECT_RATIO_INFO_0_AR NULL
#define OPTION_VAL_NTSC_PAR_AR NULL
#define OPTION_VAL_PAL_PAR_AR NULL
#define OPTION_VAL_4_3_AR NULL
#define OPTION_VAL_UNCORRECTED_AR NULL
#define GENESIS_PLUS_GX_OVERSCAN_LABEL_AR NULL
#define GENESIS_PLUS_GX_OVERSCAN_INFO_0_AR NULL
#define OPTION_VAL_TOP_BOTTOM_AR NULL
#define OPTION_VAL_LEFT_RIGHT_AR NULL
#define OPTION_VAL_FULL_AR NULL
#define GENESIS_PLUS_GX_LEFT_BORDER_LABEL_AR NULL
#define GENESIS_PLUS_GX_LEFT_BORDER_INFO_0_AR NULL
#define OPTION_VAL_LEFT_BORDER_AR NULL
#define OPTION_VAL_LEFT_RIGHT_BORDERS_AR NULL
#define GENESIS_PLUS_GX_GG_EXTRA_LABEL_AR NULL
#define GENESIS_PLUS_GX_GG_EXTRA_INFO_0_AR NULL
#define GENESIS_PLUS_GX_BLARGG_NTSC_FILTER_LABEL_AR NULL
#define GENESIS_PLUS_GX_BLARGG_NTSC_FILTER_INFO_0_AR NULL
#define OPTION_VAL_MONOCHROME_AR "أحادي اللون"
#define OPTION_VAL_COMPOSITE_AR NULL
#define OPTION_VAL_SVIDEO_AR NULL
#define OPTION_VAL_RGB_AR NULL
#define GENESIS_PLUS_GX_LCD_FILTER_LABEL_AR NULL
#define GENESIS_PLUS_GX_LCD_FILTER_INFO_0_AR NULL
#define GENESIS_PLUS_GX_RENDER_LABEL_AR NULL
#define GENESIS_PLUS_GX_RENDER_INFO_0_AR NULL
#define OPTION_VAL_SINGLE_FIELD_AR NULL
#define OPTION_VAL_DOUBLE_FIELD_AR NULL
#define GENESIS_PLUS_GX_FRAMESKIP_LABEL_AR NULL
#define GENESIS_PLUS_GX_FRAMESKIP_INFO_0_AR NULL
#define OPTION_VAL_MANUAL_AR "يدوي"
#define GENESIS_PLUS_GX_FRAMESKIP_THRESHOLD_LABEL_AR NULL
#define GENESIS_PLUS_GX_FRAMESKIP_THRESHOLD_INFO_0_AR "عندما يتم تعيين 'Frameskip' إلى 'يدوي'، يحدد عتبة شغل التخزين المؤقت الصوتي (النسبة المئوية) التي سيتم تخطي الأطر أدناه. فارتفاع القيم يقلل من خطر التشويش بالتسبب في انخفاض الأطر بصورة أكثر تواترا."
#define GENESIS_PLUS_GX_YM2413_LABEL_AR NULL
#define GENESIS_PLUS_GX_YM2413_INFO_0_AR NULL
#define GENESIS_PLUS_GX_YM2413_CORE_LABEL_AR NULL
#define GENESIS_PLUS_GX_YM2413_CORE_INFO_0_AR NULL
#define OPTION_VAL_MAME_AR NULL
#define OPTION_VAL_NUKED_AR NULL
#define GENESIS_PLUS_GX_YM2612_LABEL_AR NULL
#define GENESIS_PLUS_GX_YM2612_INFO_0_AR NULL
#define GENESIS_PLUS_GX_YM2612_INFO_1_AR NULL
#define OPTION_VAL_MAME_YM2612_AR NULL
#define OPTION_VAL_MAME_ASIC_YM3438_AR NULL
#define OPTION_VAL_MAME_ENHANCED_YM3438_AR NULL
#define OPTION_VAL_NUKED_YM2612_AR NULL
#define OPTION_VAL_NUKED_YM3438_AR NULL
#define GENESIS_PLUS_GX_SOUND_OUTPUT_LABEL_AR NULL
#define GENESIS_PLUS_GX_SOUND_OUTPUT_INFO_0_AR NULL
#define OPTION_VAL_STEREO_AR NULL
#define OPTION_VAL_MONO_AR NULL
#define GENESIS_PLUS_GX_AUDIO_FILTER_LABEL_AR "تصفية الصوت"
#define GENESIS_PLUS_GX_AUDIO_FILTER_INFO_0_AR NULL
#define OPTION_VAL_LOW_PASS_AR NULL
#define OPTION_VAL_EQ_AR NULL
#define GENESIS_PLUS_GX_LOWPASS_RANGE_LABEL_AR NULL
#define GENESIS_PLUS_GX_LOWPASS_RANGE_INFO_0_AR NULL
#define GENESIS_PLUS_GX_PSG_PREAMP_LABEL_AR NULL
#define GENESIS_PLUS_GX_PSG_PREAMP_INFO_0_AR NULL
#define GENESIS_PLUS_GX_FM_PREAMP_LABEL_AR NULL
#define GENESIS_PLUS_GX_FM_PREAMP_INFO_0_AR NULL
#define GENESIS_PLUS_GX_CDDA_VOLUME_LABEL_AR NULL
#define GENESIS_PLUS_GX_CDDA_VOLUME_INFO_0_AR NULL
#define GENESIS_PLUS_GX_PCM_VOLUME_LABEL_AR NULL
#define GENESIS_PLUS_GX_PCM_VOLUME_INFO_0_AR NULL
#define GENESIS_PLUS_GX_AUDIO_EQ_LOW_LABEL_AR NULL
#define GENESIS_PLUS_GX_AUDIO_EQ_LOW_INFO_0_AR NULL
#define GENESIS_PLUS_GX_AUDIO_EQ_MID_LABEL_AR NULL
#define GENESIS_PLUS_GX_AUDIO_EQ_MID_INFO_0_AR NULL
#define GENESIS_PLUS_GX_AUDIO_EQ_HIGH_LABEL_AR NULL
#define GENESIS_PLUS_GX_AUDIO_EQ_HIGH_INFO_0_AR NULL
#define GENESIS_PLUS_GX_GUN_INPUT_LABEL_AR NULL
#define GENESIS_PLUS_GX_GUN_INPUT_INFO_0_AR NULL
#define OPTION_VAL_LIGHTGUN_AR NULL
#define OPTION_VAL_TOUCHSCREEN_AR NULL
#define GENESIS_PLUS_GX_GUN_CURSOR_LABEL_AR NULL
#define GENESIS_PLUS_GX_GUN_CURSOR_INFO_0_AR NULL
#define GENESIS_PLUS_GX_INVERT_MOUSE_LABEL_AR NULL
#define GENESIS_PLUS_GX_INVERT_MOUSE_INFO_0_AR NULL
#define GENESIS_PLUS_GX_NO_SPRITE_LIMIT_LABEL_AR NULL
#define GENESIS_PLUS_GX_NO_SPRITE_LIMIT_INFO_0_AR NULL
#define GENESIS_PLUS_GX_ENHANCED_VSCROLL_LABEL_AR NULL
#define GENESIS_PLUS_GX_ENHANCED_VSCROLL_INFO_0_AR NULL
#define GENESIS_PLUS_GX_ENHANCED_VSCROLL_LIMIT_LABEL_AR NULL
#define GENESIS_PLUS_GX_ENHANCED_VSCROLL_LIMIT_INFO_0_AR NULL
#define GENESIS_PLUS_GX_OVERCLOCK_LABEL_AR NULL
#define GENESIS_PLUS_GX_OVERCLOCK_INFO_0_AR NULL
#define OPTION_VAL_100_AR NULL
#define OPTION_VAL_125_AR NULL
#define OPTION_VAL_150_AR NULL
#define OPTION_VAL_175_AR NULL
#define OPTION_VAL_200_AR NULL
#define OPTION_VAL_225_AR NULL
#define OPTION_VAL_250_AR NULL
#define OPTION_VAL_275_AR NULL
#define OPTION_VAL_300_AR NULL
#define OPTION_VAL_325_AR NULL
#define OPTION_VAL_350_AR NULL
#define OPTION_VAL_375_AR NULL
#define OPTION_VAL_400_AR NULL
#define OPTION_VAL_425_AR NULL
#define OPTION_VAL_450_AR NULL
#define OPTION_VAL_475_AR NULL
#define OPTION_VAL_500_AR NULL
#define GENESIS_PLUS_GX_FORCE_DTACK_LABEL_AR NULL
#define GENESIS_PLUS_GX_FORCE_DTACK_INFO_0_AR NULL
#define GENESIS_PLUS_GX_ADDR_ERROR_LABEL_AR NULL
#define GENESIS_PLUS_GX_ADDR_ERROR_INFO_0_AR NULL
#define GENESIS_PLUS_GX_CD_LATENCY_LABEL_AR NULL
#define GENESIS_PLUS_GX_CD_LATENCY_INFO_0_AR NULL
#define GENESIS_PLUS_GX_CD_PRECACHE_LABEL_AR NULL
#define GENESIS_PLUS_GX_CD_PRECACHE_INFO_0_AR NULL
#define GENESIS_PLUS_GX_SHOW_ADVANCED_AUDIO_SETTINGS_LABEL_AR NULL
#define GENESIS_PLUS_GX_SHOW_ADVANCED_AUDIO_SETTINGS_INFO_0_AR NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_0_VOLUME_LABEL_AR NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_0_VOLUME_INFO_0_AR NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_1_VOLUME_LABEL_AR NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_1_VOLUME_INFO_0_AR NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_2_VOLUME_LABEL_AR NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_2_VOLUME_INFO_0_AR NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_3_VOLUME_LABEL_AR NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_3_VOLUME_INFO_0_AR NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_0_VOLUME_LABEL_AR NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_0_VOLUME_INFO_0_AR NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_1_VOLUME_LABEL_AR NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_1_VOLUME_INFO_0_AR NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_2_VOLUME_LABEL_AR NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_2_VOLUME_INFO_0_AR NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_3_VOLUME_LABEL_AR NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_3_VOLUME_INFO_0_AR NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_4_VOLUME_LABEL_AR NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_4_VOLUME_INFO_0_AR NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_5_VOLUME_LABEL_AR NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_5_VOLUME_INFO_0_AR NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_0_VOLUME_LABEL_AR NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_0_VOLUME_INFO_0_AR NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_1_VOLUME_LABEL_AR NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_1_VOLUME_INFO_0_AR NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_2_VOLUME_LABEL_AR NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_2_VOLUME_INFO_0_AR NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_3_VOLUME_LABEL_AR NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_3_VOLUME_INFO_0_AR NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_4_VOLUME_LABEL_AR NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_4_VOLUME_INFO_0_AR NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_5_VOLUME_LABEL_AR NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_5_VOLUME_INFO_0_AR NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_6_VOLUME_LABEL_AR NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_6_VOLUME_INFO_0_AR NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_7_VOLUME_LABEL_AR NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_7_VOLUME_INFO_0_AR NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_8_VOLUME_LABEL_AR NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_8_VOLUME_INFO_0_AR NULL

struct retro_core_option_v2_category option_cats_ar[] = {
   {
      "system",
      CATEGORY_SYSTEM_LABEL_AR,
      CATEGORY_SYSTEM_INFO_0_AR
   },
   {
      "video",
      CATEGORY_VIDEO_LABEL_AR,
      CATEGORY_VIDEO_INFO_0_AR
   },
   {
      "audio",
      CATEGORY_AUDIO_LABEL_AR,
      CATEGORY_AUDIO_INFO_0_AR
   },
   {
      "input",
      CATEGORY_INPUT_LABEL_AR,
      CATEGORY_INPUT_INFO_0_AR
   },
   {
      "hacks",
      CATEGORY_HACKS_LABEL_AR,
      CATEGORY_HACKS_INFO_0_AR
   },
   {
      "channel_volume",
      CATEGORY_CHANNEL_VOLUME_LABEL_AR,
      CATEGORY_CHANNEL_VOLUME_INFO_0_AR
   },
   { NULL, NULL, NULL },
};
struct retro_core_option_v2_definition option_defs_ar[] = {
   {
      "genesis_plus_gx_system_hw",
      GENESIS_PLUS_GX_SYSTEM_HW_LABEL_AR,
      NULL,
      GENESIS_PLUS_GX_SYSTEM_HW_INFO_0_AR,
      NULL,
      "system",
      {
         { "auto",                 OPTION_VAL_AUTO_AR                 },
         { "sg-1000",              OPTION_VAL_SG_1000_AR              },
         { "sg-1000 II",           OPTION_VAL_SG_1000_II_AR           },
         { "sg-1000 II + ram ext.",OPTION_VAL_SG_1000_II_RAM_EXT_AR},
         { "mark-III",             OPTION_VAL_MARK_III_AR             },
         { "master system",        OPTION_VAL_MASTER_SYSTEM_AR        },
         { "master system II",     OPTION_VAL_MASTER_SYSTEM_II_AR     },
         { "game gear",            OPTION_VAL_GAME_GEAR_AR            },
         { "mega drive / genesis", OPTION_VAL_MEGA_DRIVE_GENESIS_AR   },
         { NULL, NULL },
      },
      "auto"
   },
   {
      "genesis_plus_gx_region_detect",
      GENESIS_PLUS_GX_REGION_DETECT_LABEL_AR,
      NULL,
      GENESIS_PLUS_GX_REGION_DETECT_INFO_0_AR,
      NULL,
      "system",
      {
         { "auto",    OPTION_VAL_AUTO_AR   },
         { "ntsc-u",  OPTION_VAL_NTSC_U_AR },
         { "pal",     OPTION_VAL_PAL_AR    },
         { "ntsc-j",  OPTION_VAL_NTSC_J_AR },
         { NULL, NULL },
      },
      "auto"
   },
   {
      "genesis_plus_gx_vdp_mode",
      GENESIS_PLUS_GX_VDP_MODE_LABEL_AR,
      NULL,
      GENESIS_PLUS_GX_VDP_MODE_INFO_0_AR,
      NULL,
      "system",
      {
         { "auto",  "Disabled" },
         { "60hz",  OPTION_VAL_60HZ_AR },
         { "50hz",  OPTION_VAL_50HZ_AR },
         { NULL, NULL },
      },
      "auto"
   },
   {
      "genesis_plus_gx_bios",
      GENESIS_PLUS_GX_BIOS_LABEL_AR,
      NULL,
      GENESIS_PLUS_GX_BIOS_INFO_0_AR,
      NULL,
      "system",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_system_bram",
      GENESIS_PLUS_GX_SYSTEM_BRAM_LABEL_AR,
      NULL,
      GENESIS_PLUS_GX_SYSTEM_BRAM_INFO_0_AR,
      NULL,
      "system",
      {
         { "per bios", OPTION_VAL_PER_BIOS_AR },
         { "per game", OPTION_VAL_PER_GAME_AR },
         { NULL, NULL },
      },
      "per bios"
   },
   {
      "genesis_plus_gx_cart_bram",
      GENESIS_PLUS_GX_CART_BRAM_LABEL_AR,
      NULL,
      GENESIS_PLUS_GX_CART_BRAM_INFO_0_AR,
      NULL,
      "system",
      {
         { "per cart", OPTION_VAL_PER_CART_AR },
         { "per game", OPTION_VAL_PER_GAME_AR },
         { NULL, NULL },
      },
      "per cart"
   },
   {
      "genesis_plus_gx_cart_size",
      GENESIS_PLUS_GX_CART_SIZE_LABEL_AR,
      NULL,
      GENESIS_PLUS_GX_CART_SIZE_INFO_0_AR,
      NULL,
      "system",
      {
         { "disabled", "Disabled" },
         { "128k",     OPTION_VAL_128K_AR  },
         { "256k",     OPTION_VAL_256K_AR  },
         { "512k",     OPTION_VAL_512K_AR  },
         { "1meg",     OPTION_VAL_1MEG_AR    },
         { "2meg",     OPTION_VAL_2MEG_AR    },
         { "4meg",     OPTION_VAL_4MEG_AR    },
         { NULL, NULL },
      },
      "4meg"
   },
   {
      "genesis_plus_gx_add_on",
      GENESIS_PLUS_GX_ADD_ON_LABEL_AR,
      NULL,
      GENESIS_PLUS_GX_ADD_ON_INFO_0_AR,
      NULL,
      "system",
      {
         { "auto",         OPTION_VAL_AUTO_AR },
         { "sega/mega cd", OPTION_VAL_SEGA_MEGA_CD_AR },
         { "megasd",       OPTION_VAL_MEGASD_AR },
         { "none",         OPTION_VAL_NONE_AR },
         { NULL, NULL },
      },
      "auto"
   },
   {
      "genesis_plus_gx_lock_on",
      GENESIS_PLUS_GX_LOCK_ON_LABEL_AR,
      NULL,
      GENESIS_PLUS_GX_LOCK_ON_INFO_0_AR,
      NULL,
      "system",
      {
         { "disabled",            NULL },
         { "game genie",          OPTION_VAL_GAME_GENIE_AR },
         { "action replay (pro)", OPTION_VAL_ACTION_REPLAY_PRO_AR },
         { "sonic & knuckles",    OPTION_VAL_SONIC_KNUCKLES_AR },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_aspect_ratio",
      GENESIS_PLUS_GX_ASPECT_RATIO_LABEL_AR,
      NULL,
      GENESIS_PLUS_GX_ASPECT_RATIO_INFO_0_AR,
      NULL,
      "video",
      {
         { "auto",     OPTION_VAL_AUTO_AR },
         { "NTSC PAR", OPTION_VAL_NTSC_PAR_AR },
         { "PAL PAR",  OPTION_VAL_PAL_PAR_AR },
         { "4:3",  OPTION_VAL_4_3_AR },
         { "Uncorrected",  OPTION_VAL_UNCORRECTED_AR },
      },
      "auto"
   },
   {
      "genesis_plus_gx_overscan",
      GENESIS_PLUS_GX_OVERSCAN_LABEL_AR,
      NULL,
      GENESIS_PLUS_GX_OVERSCAN_INFO_0_AR,
      NULL,
      "video",
      {
         { "disabled",   NULL },
         { "top/bottom", OPTION_VAL_TOP_BOTTOM_AR },
         { "left/right", OPTION_VAL_LEFT_RIGHT_AR },
         { "full",       OPTION_VAL_FULL_AR },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_left_border",
      GENESIS_PLUS_GX_LEFT_BORDER_LABEL_AR,
      NULL,
      GENESIS_PLUS_GX_LEFT_BORDER_INFO_0_AR,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "left border", OPTION_VAL_LEFT_BORDER_AR },
         { "left & right borders", OPTION_VAL_LEFT_RIGHT_BORDERS_AR },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_gg_extra",
      GENESIS_PLUS_GX_GG_EXTRA_LABEL_AR,
      NULL,
      GENESIS_PLUS_GX_GG_EXTRA_INFO_0_AR,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_blargg_ntsc_filter",
      GENESIS_PLUS_GX_BLARGG_NTSC_FILTER_LABEL_AR,
      NULL,
      GENESIS_PLUS_GX_BLARGG_NTSC_FILTER_INFO_0_AR,
      NULL,
      "video",
      {
         { "disabled",   NULL },
         { "monochrome", OPTION_VAL_MONOCHROME_AR },
         { "composite",  OPTION_VAL_COMPOSITE_AR },
         { "svideo",     OPTION_VAL_SVIDEO_AR },
         { "rgb",        OPTION_VAL_RGB_AR },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_lcd_filter",
      GENESIS_PLUS_GX_LCD_FILTER_LABEL_AR,
      NULL,
      GENESIS_PLUS_GX_LCD_FILTER_INFO_0_AR,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_render",
      GENESIS_PLUS_GX_RENDER_LABEL_AR,
      NULL,
      GENESIS_PLUS_GX_RENDER_INFO_0_AR,
      NULL,
      "video",
      {
         { "single field", OPTION_VAL_SINGLE_FIELD_AR },
         { "double field", OPTION_VAL_DOUBLE_FIELD_AR },
         { NULL, NULL },
      },
      "single field"
   },
   {
      "genesis_plus_gx_frameskip",
      GENESIS_PLUS_GX_FRAMESKIP_LABEL_AR,
      NULL,
      GENESIS_PLUS_GX_FRAMESKIP_INFO_0_AR,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "auto",     OPTION_VAL_AUTO_AR },
         { "manual",   OPTION_VAL_MANUAL_AR },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_frameskip_threshold",
      GENESIS_PLUS_GX_FRAMESKIP_THRESHOLD_LABEL_AR,
      NULL,
      GENESIS_PLUS_GX_FRAMESKIP_THRESHOLD_INFO_0_AR,
      NULL,
      "video",
      {
         { "15", NULL },
         { "18", NULL },
         { "21", NULL },
         { "24", NULL },
         { "27", NULL },
         { "30", NULL },
         { "33", NULL },
         { "36", NULL },
         { "39", NULL },
         { "42", NULL },
         { "45", NULL },
         { "48", NULL },
         { "51", NULL },
         { "54", NULL },
         { "57", NULL },
         { "60", NULL },
         { NULL, NULL },
      },
      "33"
   },
   {
      "genesis_plus_gx_ym2413",
      GENESIS_PLUS_GX_YM2413_LABEL_AR,
      NULL,
      GENESIS_PLUS_GX_YM2413_INFO_0_AR,
      NULL,
      "audio",
      {
         { "auto",     OPTION_VAL_AUTO_AR },
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "auto"
   },
#ifdef HAVE_OPLL_CORE
   {
      "genesis_plus_gx_ym2413_core",
      GENESIS_PLUS_GX_YM2413_CORE_LABEL_AR,
      NULL,
      GENESIS_PLUS_GX_YM2413_CORE_INFO_0_AR,
      NULL,
      "audio",
      {
         { "mame",  OPTION_VAL_MAME_AR },
         { "nuked", OPTION_VAL_NUKED_AR },
         { NULL, NULL },
      },
      "mame"
   },
#endif
   {
      "genesis_plus_gx_ym2612",
      GENESIS_PLUS_GX_YM2612_LABEL_AR,
      NULL,
#ifdef HAVE_YM3438_CORE
      GENESIS_PLUS_GX_YM2612_INFO_0_AR,
#else
      GENESIS_PLUS_GX_YM2612_INFO_1_AR,
#endif
      NULL,
      "audio",
      {
         { "mame (ym2612)",          OPTION_VAL_MAME_YM2612_AR },
         { "mame (asic ym3438)",     OPTION_VAL_MAME_ASIC_YM3438_AR },
         { "mame (enhanced ym3438)", OPTION_VAL_MAME_ENHANCED_YM3438_AR },
#ifdef HAVE_YM3438_CORE
         { "nuked (ym2612)",         OPTION_VAL_NUKED_YM2612_AR },
         { "nuked (ym3438)",         OPTION_VAL_NUKED_YM3438_AR },
#endif
         { NULL, NULL },
      },
      "mame (ym2612)"
   },
   {
      "genesis_plus_gx_sound_output",
      GENESIS_PLUS_GX_SOUND_OUTPUT_LABEL_AR,
      NULL,
      GENESIS_PLUS_GX_SOUND_OUTPUT_INFO_0_AR,
      NULL,
      "audio",
      {
         { "stereo", OPTION_VAL_STEREO_AR },
         { "mono",   OPTION_VAL_MONO_AR },
         { NULL, NULL },
      },
      "stereo"
   },
   {
      "genesis_plus_gx_audio_filter",
      GENESIS_PLUS_GX_AUDIO_FILTER_LABEL_AR,
      NULL,
      GENESIS_PLUS_GX_AUDIO_FILTER_INFO_0_AR,
      NULL,
      "audio",
      {
         { "disabled", NULL },
         { "low-pass", OPTION_VAL_LOW_PASS_AR },
#ifdef HAVE_EQ
         { "EQ",       OPTION_VAL_EQ_AR },
#endif
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_lowpass_range",
      GENESIS_PLUS_GX_LOWPASS_RANGE_LABEL_AR,
      NULL,
      GENESIS_PLUS_GX_LOWPASS_RANGE_INFO_0_AR,
      NULL,
      "audio",
      {
         { "5",  NULL },
         { "10", NULL },
         { "15", NULL },
         { "20", NULL },
         { "25", NULL },
         { "30", NULL },
         { "35", NULL },
         { "40", NULL },
         { "45", NULL },
         { "50", NULL },
         { "55", NULL },
         { "60", NULL },
         { "65", NULL },
         { "70", NULL },
         { "75", NULL },
         { "80", NULL },
         { "85", NULL },
         { "90", NULL },
         { "95", NULL },
         { NULL, NULL },
      },
      "60"
   },
   {
      "genesis_plus_gx_psg_preamp",
      GENESIS_PLUS_GX_PSG_PREAMP_LABEL_AR,
      NULL,
      GENESIS_PLUS_GX_PSG_PREAMP_INFO_0_AR,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { "105", NULL },
         { "110", NULL },
         { "115", NULL },
         { "120", NULL },
         { "125", NULL },
         { "130", NULL },
         { "135", NULL },
         { "140", NULL },
         { "145", NULL },
         { "150", NULL },
         { "155", NULL },
         { "160", NULL },
         { "165", NULL },
         { "170", NULL },
         { "175", NULL },
         { "180", NULL },
         { "185", NULL },
         { "190", NULL },
         { "195", NULL },
         { "200", NULL },
         { NULL, NULL },
      },
      "150"
   },
   {
      "genesis_plus_gx_fm_preamp",
      GENESIS_PLUS_GX_FM_PREAMP_LABEL_AR,
      NULL,
      GENESIS_PLUS_GX_FM_PREAMP_INFO_0_AR,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { "105", NULL },
         { "110", NULL },
         { "115", NULL },
         { "120", NULL },
         { "125", NULL },
         { "130", NULL },
         { "135", NULL },
         { "140", NULL },
         { "145", NULL },
         { "150", NULL },
         { "155", NULL },
         { "160", NULL },
         { "165", NULL },
         { "170", NULL },
         { "175", NULL },
         { "180", NULL },
         { "185", NULL },
         { "190", NULL },
         { "195", NULL },
         { "200", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_cdda_volume",
      GENESIS_PLUS_GX_CDDA_VOLUME_LABEL_AR,
      NULL,
      GENESIS_PLUS_GX_CDDA_VOLUME_INFO_0_AR,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_pcm_volume",
      GENESIS_PLUS_GX_PCM_VOLUME_LABEL_AR,
      NULL,
      GENESIS_PLUS_GX_PCM_VOLUME_INFO_0_AR,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
#ifdef HAVE_EQ
   {
      "genesis_plus_gx_audio_eq_low",
      GENESIS_PLUS_GX_AUDIO_EQ_LOW_LABEL_AR,
      NULL,
      GENESIS_PLUS_GX_AUDIO_EQ_LOW_INFO_0_AR,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_audio_eq_mid",
      GENESIS_PLUS_GX_AUDIO_EQ_MID_LABEL_AR,
      NULL,
      GENESIS_PLUS_GX_AUDIO_EQ_MID_INFO_0_AR,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_audio_eq_high",
      GENESIS_PLUS_GX_AUDIO_EQ_HIGH_LABEL_AR,
      NULL,
      GENESIS_PLUS_GX_AUDIO_EQ_HIGH_INFO_0_AR,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
#endif
   {
      "genesis_plus_gx_gun_input",
      GENESIS_PLUS_GX_GUN_INPUT_LABEL_AR,
      NULL,
      GENESIS_PLUS_GX_GUN_INPUT_INFO_0_AR,
      NULL,
      "input",
      {
         { "lightgun",    OPTION_VAL_LIGHTGUN_AR },
         { "touchscreen", OPTION_VAL_TOUCHSCREEN_AR },
         { NULL, NULL },
      },
      "lightgun"
   },
   {
      "genesis_plus_gx_gun_cursor",
      GENESIS_PLUS_GX_GUN_CURSOR_LABEL_AR,
      NULL,
      GENESIS_PLUS_GX_GUN_CURSOR_INFO_0_AR,
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_invert_mouse",
      GENESIS_PLUS_GX_INVERT_MOUSE_LABEL_AR,
      NULL,
      GENESIS_PLUS_GX_INVERT_MOUSE_INFO_0_AR,
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_no_sprite_limit",
      GENESIS_PLUS_GX_NO_SPRITE_LIMIT_LABEL_AR,
      NULL,
      GENESIS_PLUS_GX_NO_SPRITE_LIMIT_INFO_0_AR,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_enhanced_vscroll",
      GENESIS_PLUS_GX_ENHANCED_VSCROLL_LABEL_AR,
      NULL,
      GENESIS_PLUS_GX_ENHANCED_VSCROLL_INFO_0_AR,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_enhanced_vscroll_limit",
      GENESIS_PLUS_GX_ENHANCED_VSCROLL_LIMIT_LABEL_AR,
      NULL,
      GENESIS_PLUS_GX_ENHANCED_VSCROLL_LIMIT_INFO_0_AR,
      NULL,
      "hacks",
      {
         { "2", NULL },
         { "3",  NULL },
         { "4", NULL },
         { "5",  NULL },
         { "6", NULL },
         { "7",  NULL },
         { "8", NULL },
         { "9",  NULL },
         { "10", NULL },
         { "11",  NULL },
         { "12", NULL },
         { "13",  NULL },
         { "14", NULL },
         { "15",  NULL },
         { "16", NULL },
         { NULL, NULL },
      },
      "8"
   },
#ifdef HAVE_OVERCLOCK
   {
      "genesis_plus_gx_overclock",
      GENESIS_PLUS_GX_OVERCLOCK_LABEL_AR,
      NULL,
      GENESIS_PLUS_GX_OVERCLOCK_INFO_0_AR,
      NULL,
      "hacks",
      {
         { "100", OPTION_VAL_100_AR },
         { "125", OPTION_VAL_125_AR },
         { "150", OPTION_VAL_150_AR },
         { "175", OPTION_VAL_175_AR },
         { "200", OPTION_VAL_200_AR },
         { "225", OPTION_VAL_225_AR },
         { "250", OPTION_VAL_250_AR },
         { "275", OPTION_VAL_275_AR },
         { "300", OPTION_VAL_300_AR },
         { "325", OPTION_VAL_325_AR },
         { "350", OPTION_VAL_350_AR },
         { "375", OPTION_VAL_375_AR },
         { "400", OPTION_VAL_400_AR },
         { "425", OPTION_VAL_425_AR },
         { "450", OPTION_VAL_450_AR },
         { "475", OPTION_VAL_475_AR },
         { "500", OPTION_VAL_500_AR },
         { NULL, NULL },
      },
      "100%"
   },
#endif
   {
      "genesis_plus_gx_force_dtack",
      GENESIS_PLUS_GX_FORCE_DTACK_LABEL_AR,
      NULL,
      GENESIS_PLUS_GX_FORCE_DTACK_INFO_0_AR,
      NULL,
      "hacks",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL },
      },
      "enabled"
   },
   {
      "genesis_plus_gx_addr_error",
      GENESIS_PLUS_GX_ADDR_ERROR_LABEL_AR,
      NULL,
      GENESIS_PLUS_GX_ADDR_ERROR_INFO_0_AR,
      NULL,
      "hacks",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL },
      },
      "enabled"
   },
   {
      "genesis_plus_gx_cd_latency",
      GENESIS_PLUS_GX_CD_LATENCY_LABEL_AR,
      NULL,
      GENESIS_PLUS_GX_CD_LATENCY_INFO_0_AR,
      NULL,
      "hacks",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL },
      },
      "enabled"
   },
   {
      "genesis_plus_gx_cd_precache",
      GENESIS_PLUS_GX_CD_PRECACHE_LABEL_AR,
      NULL,
      GENESIS_PLUS_GX_CD_PRECACHE_INFO_0_AR,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
#ifdef USE_PER_SOUND_CHANNELS_CONFIG
   {
      "genesis_plus_gx_show_advanced_audio_settings",
      GENESIS_PLUS_GX_SHOW_ADVANCED_AUDIO_SETTINGS_LABEL_AR,
      NULL,
      GENESIS_PLUS_GX_SHOW_ADVANCED_AUDIO_SETTINGS_INFO_0_AR,
      NULL,
      "channel_volume",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL},
      },
      "disabled"
   },
   {
      "genesis_plus_gx_psg_channel_0_volume",
      GENESIS_PLUS_GX_PSG_CHANNEL_0_VOLUME_LABEL_AR,
      NULL,
      GENESIS_PLUS_GX_PSG_CHANNEL_0_VOLUME_INFO_0_AR,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_psg_channel_1_volume",
      GENESIS_PLUS_GX_PSG_CHANNEL_1_VOLUME_LABEL_AR,
      NULL,
      GENESIS_PLUS_GX_PSG_CHANNEL_1_VOLUME_INFO_0_AR,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_psg_channel_2_volume",
      GENESIS_PLUS_GX_PSG_CHANNEL_2_VOLUME_LABEL_AR,
      NULL,
      GENESIS_PLUS_GX_PSG_CHANNEL_2_VOLUME_INFO_0_AR,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_psg_channel_3_volume",
      GENESIS_PLUS_GX_PSG_CHANNEL_3_VOLUME_LABEL_AR,
      NULL,
      GENESIS_PLUS_GX_PSG_CHANNEL_3_VOLUME_INFO_0_AR,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_0_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_0_VOLUME_LABEL_AR,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_0_VOLUME_INFO_0_AR,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_1_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_1_VOLUME_LABEL_AR,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_1_VOLUME_INFO_0_AR,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_2_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_2_VOLUME_LABEL_AR,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_2_VOLUME_INFO_0_AR,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_3_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_3_VOLUME_LABEL_AR,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_3_VOLUME_INFO_0_AR,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_4_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_4_VOLUME_LABEL_AR,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_4_VOLUME_INFO_0_AR,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_5_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_5_VOLUME_LABEL_AR,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_5_VOLUME_INFO_0_AR,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_0_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_0_VOLUME_LABEL_AR,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_0_VOLUME_INFO_0_AR,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_1_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_1_VOLUME_LABEL_AR,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_1_VOLUME_INFO_0_AR,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_2_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_2_VOLUME_LABEL_AR,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_2_VOLUME_INFO_0_AR,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_3_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_3_VOLUME_LABEL_AR,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_3_VOLUME_INFO_0_AR,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_4_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_4_VOLUME_LABEL_AR,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_4_VOLUME_INFO_0_AR,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_5_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_5_VOLUME_LABEL_AR,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_5_VOLUME_INFO_0_AR,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_6_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_6_VOLUME_LABEL_AR,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_6_VOLUME_INFO_0_AR,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_7_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_7_VOLUME_LABEL_AR,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_7_VOLUME_INFO_0_AR,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_8_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_8_VOLUME_LABEL_AR,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_8_VOLUME_INFO_0_AR,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
#endif
   { NULL, NULL, NULL, NULL, NULL, NULL, {{0}}, NULL },
};
struct retro_core_options_v2 options_ar = {
   option_cats_ar,
   option_defs_ar
};

/* RETRO_LANGUAGE_AST */

#define CATEGORY_SYSTEM_LABEL_AST "Sistema"
#define CATEGORY_SYSTEM_INFO_0_AST NULL
#define CATEGORY_VIDEO_LABEL_AST "Videu"
#define CATEGORY_VIDEO_INFO_0_AST NULL
#define CATEGORY_AUDIO_LABEL_AST "Audiu"
#define CATEGORY_AUDIO_INFO_0_AST NULL
#define CATEGORY_INPUT_LABEL_AST "Entrada"
#define CATEGORY_INPUT_INFO_0_AST NULL
#define CATEGORY_HACKS_LABEL_AST "Hacks de la emulación"
#define CATEGORY_HACKS_INFO_0_AST NULL
#define CATEGORY_CHANNEL_VOLUME_LABEL_AST "Configuración avanzada del volume de les canales"
#define CATEGORY_CHANNEL_VOLUME_INFO_0_AST NULL
#define GENESIS_PLUS_GX_SYSTEM_HW_LABEL_AST "Hardware del sistema"
#define GENESIS_PLUS_GX_SYSTEM_HW_INFO_0_AST NULL
#define OPTION_VAL_AUTO_AST NULL
#define OPTION_VAL_SG_1000_AST NULL
#define OPTION_VAL_SG_1000_II_AST NULL
#define OPTION_VAL_SG_1000_II_RAM_EXT_AST NULL
#define OPTION_VAL_MARK_III_AST NULL
#define OPTION_VAL_MASTER_SYSTEM_AST NULL
#define OPTION_VAL_MASTER_SYSTEM_II_AST NULL
#define OPTION_VAL_GAME_GEAR_AST NULL
#define OPTION_VAL_MEGA_DRIVE_GENESIS_AST NULL
#define GENESIS_PLUS_GX_REGION_DETECT_LABEL_AST "Rexón del sistema"
#define GENESIS_PLUS_GX_REGION_DETECT_INFO_0_AST NULL
#define OPTION_VAL_NTSC_U_AST NULL
#define OPTION_VAL_PAL_AST NULL
#define OPTION_VAL_NTSC_J_AST NULL
#define GENESIS_PLUS_GX_VDP_MODE_LABEL_AST NULL
#define GENESIS_PLUS_GX_VDP_MODE_INFO_0_AST NULL
#define OPTION_VAL_60HZ_AST "NTSC (60 Hz)"
#define OPTION_VAL_50HZ_AST "PAL (50 Hz)"
#define GENESIS_PLUS_GX_BIOS_LABEL_AST NULL
#define GENESIS_PLUS_GX_BIOS_INFO_0_AST NULL
#define GENESIS_PLUS_GX_SYSTEM_BRAM_LABEL_AST NULL
#define GENESIS_PLUS_GX_SYSTEM_BRAM_INFO_0_AST NULL
#define OPTION_VAL_PER_BIOS_AST NULL
#define OPTION_VAL_PER_GAME_AST NULL
#define GENESIS_PLUS_GX_CART_BRAM_LABEL_AST NULL
#define GENESIS_PLUS_GX_CART_BRAM_INFO_0_AST NULL
#define OPTION_VAL_PER_CART_AST NULL
#define GENESIS_PLUS_GX_CART_SIZE_LABEL_AST NULL
#define GENESIS_PLUS_GX_CART_SIZE_INFO_0_AST NULL
#define OPTION_VAL_128K_AST NULL
#define OPTION_VAL_256K_AST NULL
#define OPTION_VAL_512K_AST NULL
#define OPTION_VAL_1MEG_AST NULL
#define OPTION_VAL_2MEG_AST NULL
#define OPTION_VAL_4MEG_AST NULL
#define GENESIS_PLUS_GX_ADD_ON_LABEL_AST NULL
#define GENESIS_PLUS_GX_ADD_ON_INFO_0_AST NULL
#define OPTION_VAL_SEGA_MEGA_CD_AST NULL
#define OPTION_VAL_MEGASD_AST NULL
#define OPTION_VAL_NONE_AST NULL
#define GENESIS_PLUS_GX_LOCK_ON_LABEL_AST "Lock-On de cartuchos"
#define GENESIS_PLUS_GX_LOCK_ON_INFO_0_AST "La teunoloxía Lock-On ye una función de Mega Drive que permitía a los xuegos conectase al puertu d'interconexón d'un cartuchu especial p'aumenta o alteriar el so conteníu. Esta opción especifica qué tipu de cartuchu Lock-On especial hai qu'emular. Los ficheros de BIOS correspondientes han tar nel direutoriu «system» de RetroArch."
#define OPTION_VAL_GAME_GENIE_AST NULL
#define OPTION_VAL_ACTION_REPLAY_PRO_AST NULL
#define OPTION_VAL_SONIC_KNUCKLES_AST NULL
#define GENESIS_PLUS_GX_ASPECT_RATIO_LABEL_AST "Proporción d'aspeutu fornida pol nucleu"
#define GENESIS_PLUS_GX_ASPECT_RATIO_INFO_0_AST NULL
#define OPTION_VAL_NTSC_PAR_AST NULL
#define OPTION_VAL_PAL_PAR_AST NULL
#define OPTION_VAL_4_3_AST NULL
#define OPTION_VAL_UNCORRECTED_AST NULL
#define GENESIS_PLUS_GX_OVERSCAN_LABEL_AST "Berbesos"
#define GENESIS_PLUS_GX_OVERSCAN_INFO_0_AST NULL
#define OPTION_VAL_TOP_BOTTOM_AST NULL
#define OPTION_VAL_LEFT_RIGHT_AST NULL
#define OPTION_VAL_FULL_AST NULL
#define GENESIS_PLUS_GX_LEFT_BORDER_LABEL_AST NULL
#define GENESIS_PLUS_GX_LEFT_BORDER_INFO_0_AST NULL
#define OPTION_VAL_LEFT_BORDER_AST NULL
#define OPTION_VAL_LEFT_RIGHT_BORDERS_AST NULL
#define GENESIS_PLUS_GX_GG_EXTRA_LABEL_AST NULL
#define GENESIS_PLUS_GX_GG_EXTRA_INFO_0_AST NULL
#define GENESIS_PLUS_GX_BLARGG_NTSC_FILTER_LABEL_AST NULL
#define GENESIS_PLUS_GX_BLARGG_NTSC_FILTER_INFO_0_AST NULL
#define OPTION_VAL_MONOCHROME_AST NULL
#define OPTION_VAL_COMPOSITE_AST NULL
#define OPTION_VAL_SVIDEO_AST NULL
#define OPTION_VAL_RGB_AST NULL
#define GENESIS_PLUS_GX_LCD_FILTER_LABEL_AST NULL
#define GENESIS_PLUS_GX_LCD_FILTER_INFO_0_AST NULL
#define GENESIS_PLUS_GX_RENDER_LABEL_AST NULL
#define GENESIS_PLUS_GX_RENDER_INFO_0_AST NULL
#define OPTION_VAL_SINGLE_FIELD_AST "Campu únicu"
#define OPTION_VAL_DOUBLE_FIELD_AST "Campu doble"
#define GENESIS_PLUS_GX_FRAMESKIP_LABEL_AST "Saltu de cuadros"
#define GENESIS_PLUS_GX_FRAMESKIP_INFO_0_AST NULL
#define OPTION_VAL_MANUAL_AST NULL
#define GENESIS_PLUS_GX_FRAMESKIP_THRESHOLD_LABEL_AST NULL
#define GENESIS_PLUS_GX_FRAMESKIP_THRESHOLD_INFO_0_AST NULL
#define GENESIS_PLUS_GX_YM2413_LABEL_AST NULL
#define GENESIS_PLUS_GX_YM2413_INFO_0_AST NULL
#define GENESIS_PLUS_GX_YM2413_CORE_LABEL_AST NULL
#define GENESIS_PLUS_GX_YM2413_CORE_INFO_0_AST NULL
#define OPTION_VAL_MAME_AST NULL
#define OPTION_VAL_NUKED_AST NULL
#define GENESIS_PLUS_GX_YM2612_LABEL_AST "FM de Mega Drive/Genesis"
#define GENESIS_PLUS_GX_YM2612_INFO_0_AST NULL
#define GENESIS_PLUS_GX_YM2612_INFO_1_AST NULL
#define OPTION_VAL_MAME_YM2612_AST NULL
#define OPTION_VAL_MAME_ASIC_YM3438_AST NULL
#define OPTION_VAL_MAME_ENHANCED_YM3438_AST NULL
#define OPTION_VAL_NUKED_YM2612_AST NULL
#define OPTION_VAL_NUKED_YM3438_AST NULL
#define GENESIS_PLUS_GX_SOUND_OUTPUT_LABEL_AST "Salida del soníu"
#define GENESIS_PLUS_GX_SOUND_OUTPUT_INFO_0_AST NULL
#define OPTION_VAL_STEREO_AST "Estéreu"
#define OPTION_VAL_MONO_AST "Monu"
#define GENESIS_PLUS_GX_AUDIO_FILTER_LABEL_AST NULL
#define GENESIS_PLUS_GX_AUDIO_FILTER_INFO_0_AST NULL
#define OPTION_VAL_LOW_PASS_AST NULL
#define OPTION_VAL_EQ_AST "Equalizador"
#define GENESIS_PLUS_GX_LOWPASS_RANGE_LABEL_AST NULL
#define GENESIS_PLUS_GX_LOWPASS_RANGE_INFO_0_AST NULL
#define GENESIS_PLUS_GX_PSG_PREAMP_LABEL_AST NULL
#define GENESIS_PLUS_GX_PSG_PREAMP_INFO_0_AST NULL
#define GENESIS_PLUS_GX_FM_PREAMP_LABEL_AST NULL
#define GENESIS_PLUS_GX_FM_PREAMP_INFO_0_AST NULL
#define GENESIS_PLUS_GX_CDDA_VOLUME_LABEL_AST NULL
#define GENESIS_PLUS_GX_CDDA_VOLUME_INFO_0_AST NULL
#define GENESIS_PLUS_GX_PCM_VOLUME_LABEL_AST NULL
#define GENESIS_PLUS_GX_PCM_VOLUME_INFO_0_AST NULL
#define GENESIS_PLUS_GX_AUDIO_EQ_LOW_LABEL_AST NULL
#define GENESIS_PLUS_GX_AUDIO_EQ_LOW_INFO_0_AST NULL
#define GENESIS_PLUS_GX_AUDIO_EQ_MID_LABEL_AST NULL
#define GENESIS_PLUS_GX_AUDIO_EQ_MID_INFO_0_AST NULL
#define GENESIS_PLUS_GX_AUDIO_EQ_HIGH_LABEL_AST NULL
#define GENESIS_PLUS_GX_AUDIO_EQ_HIGH_INFO_0_AST NULL
#define GENESIS_PLUS_GX_GUN_INPUT_LABEL_AST NULL
#define GENESIS_PLUS_GX_GUN_INPUT_INFO_0_AST NULL
#define OPTION_VAL_LIGHTGUN_AST NULL
#define OPTION_VAL_TOUCHSCREEN_AST "Pantalla táctil"
#define GENESIS_PLUS_GX_GUN_CURSOR_LABEL_AST NULL
#define GENESIS_PLUS_GX_GUN_CURSOR_INFO_0_AST NULL
#define GENESIS_PLUS_GX_INVERT_MOUSE_LABEL_AST NULL
#define GENESIS_PLUS_GX_INVERT_MOUSE_INFO_0_AST NULL
#define GENESIS_PLUS_GX_NO_SPRITE_LIMIT_LABEL_AST NULL
#define GENESIS_PLUS_GX_NO_SPRITE_LIMIT_INFO_0_AST NULL
#define GENESIS_PLUS_GX_ENHANCED_VSCROLL_LABEL_AST NULL
#define GENESIS_PLUS_GX_ENHANCED_VSCROLL_INFO_0_AST NULL
#define GENESIS_PLUS_GX_ENHANCED_VSCROLL_LIMIT_LABEL_AST NULL
#define GENESIS_PLUS_GX_ENHANCED_VSCROLL_LIMIT_INFO_0_AST NULL
#define GENESIS_PLUS_GX_OVERCLOCK_LABEL_AST "Velocidá de la CPU"
#define GENESIS_PLUS_GX_OVERCLOCK_INFO_0_AST NULL
#define OPTION_VAL_100_AST NULL
#define OPTION_VAL_125_AST NULL
#define OPTION_VAL_150_AST NULL
#define OPTION_VAL_175_AST NULL
#define OPTION_VAL_200_AST NULL
#define OPTION_VAL_225_AST NULL
#define OPTION_VAL_250_AST NULL
#define OPTION_VAL_275_AST NULL
#define OPTION_VAL_300_AST NULL
#define OPTION_VAL_325_AST NULL
#define OPTION_VAL_350_AST NULL
#define OPTION_VAL_375_AST NULL
#define OPTION_VAL_400_AST NULL
#define OPTION_VAL_425_AST NULL
#define OPTION_VAL_450_AST NULL
#define OPTION_VAL_475_AST NULL
#define OPTION_VAL_500_AST NULL
#define GENESIS_PLUS_GX_FORCE_DTACK_LABEL_AST "Bloqueos del sistema"
#define GENESIS_PLUS_GX_FORCE_DTACK_INFO_0_AST "Emula los bloqueos del sistema que se producen nel hardware real cuando s'accede a direiciones illegales. Esta opción namás habría desactivase cuando se xueguen ciertes demos ya programes homebrew que s'enconten nel comportamientu illegal pa funcionar correutamente."
#define GENESIS_PLUS_GX_ADDR_ERROR_LABEL_AST NULL
#define GENESIS_PLUS_GX_ADDR_ERROR_INFO_0_AST NULL
#define GENESIS_PLUS_GX_CD_LATENCY_LABEL_AST NULL
#define GENESIS_PLUS_GX_CD_LATENCY_INFO_0_AST NULL
#define GENESIS_PLUS_GX_CD_PRECACHE_LABEL_AST NULL
#define GENESIS_PLUS_GX_CD_PRECACHE_INFO_0_AST NULL
#define GENESIS_PLUS_GX_SHOW_ADVANCED_AUDIO_SETTINGS_LABEL_AST NULL
#define GENESIS_PLUS_GX_SHOW_ADVANCED_AUDIO_SETTINGS_INFO_0_AST NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_0_VOLUME_LABEL_AST NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_0_VOLUME_INFO_0_AST NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_1_VOLUME_LABEL_AST NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_1_VOLUME_INFO_0_AST NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_2_VOLUME_LABEL_AST NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_2_VOLUME_INFO_0_AST NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_3_VOLUME_LABEL_AST NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_3_VOLUME_INFO_0_AST NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_0_VOLUME_LABEL_AST NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_0_VOLUME_INFO_0_AST NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_1_VOLUME_LABEL_AST NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_1_VOLUME_INFO_0_AST NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_2_VOLUME_LABEL_AST NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_2_VOLUME_INFO_0_AST NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_3_VOLUME_LABEL_AST NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_3_VOLUME_INFO_0_AST NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_4_VOLUME_LABEL_AST NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_4_VOLUME_INFO_0_AST NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_5_VOLUME_LABEL_AST NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_5_VOLUME_INFO_0_AST NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_0_VOLUME_LABEL_AST NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_0_VOLUME_INFO_0_AST NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_1_VOLUME_LABEL_AST NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_1_VOLUME_INFO_0_AST NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_2_VOLUME_LABEL_AST NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_2_VOLUME_INFO_0_AST NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_3_VOLUME_LABEL_AST NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_3_VOLUME_INFO_0_AST NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_4_VOLUME_LABEL_AST NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_4_VOLUME_INFO_0_AST NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_5_VOLUME_LABEL_AST NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_5_VOLUME_INFO_0_AST NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_6_VOLUME_LABEL_AST NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_6_VOLUME_INFO_0_AST NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_7_VOLUME_LABEL_AST NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_7_VOLUME_INFO_0_AST NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_8_VOLUME_LABEL_AST NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_8_VOLUME_INFO_0_AST NULL

struct retro_core_option_v2_category option_cats_ast[] = {
   {
      "system",
      CATEGORY_SYSTEM_LABEL_AST,
      CATEGORY_SYSTEM_INFO_0_AST
   },
   {
      "video",
      CATEGORY_VIDEO_LABEL_AST,
      CATEGORY_VIDEO_INFO_0_AST
   },
   {
      "audio",
      CATEGORY_AUDIO_LABEL_AST,
      CATEGORY_AUDIO_INFO_0_AST
   },
   {
      "input",
      CATEGORY_INPUT_LABEL_AST,
      CATEGORY_INPUT_INFO_0_AST
   },
   {
      "hacks",
      CATEGORY_HACKS_LABEL_AST,
      CATEGORY_HACKS_INFO_0_AST
   },
   {
      "channel_volume",
      CATEGORY_CHANNEL_VOLUME_LABEL_AST,
      CATEGORY_CHANNEL_VOLUME_INFO_0_AST
   },
   { NULL, NULL, NULL },
};
struct retro_core_option_v2_definition option_defs_ast[] = {
   {
      "genesis_plus_gx_system_hw",
      GENESIS_PLUS_GX_SYSTEM_HW_LABEL_AST,
      NULL,
      GENESIS_PLUS_GX_SYSTEM_HW_INFO_0_AST,
      NULL,
      "system",
      {
         { "auto",                 OPTION_VAL_AUTO_AST                 },
         { "sg-1000",              OPTION_VAL_SG_1000_AST              },
         { "sg-1000 II",           OPTION_VAL_SG_1000_II_AST           },
         { "sg-1000 II + ram ext.",OPTION_VAL_SG_1000_II_RAM_EXT_AST},
         { "mark-III",             OPTION_VAL_MARK_III_AST             },
         { "master system",        OPTION_VAL_MASTER_SYSTEM_AST        },
         { "master system II",     OPTION_VAL_MASTER_SYSTEM_II_AST     },
         { "game gear",            OPTION_VAL_GAME_GEAR_AST            },
         { "mega drive / genesis", OPTION_VAL_MEGA_DRIVE_GENESIS_AST   },
         { NULL, NULL },
      },
      "auto"
   },
   {
      "genesis_plus_gx_region_detect",
      GENESIS_PLUS_GX_REGION_DETECT_LABEL_AST,
      NULL,
      GENESIS_PLUS_GX_REGION_DETECT_INFO_0_AST,
      NULL,
      "system",
      {
         { "auto",    OPTION_VAL_AUTO_AST   },
         { "ntsc-u",  OPTION_VAL_NTSC_U_AST },
         { "pal",     OPTION_VAL_PAL_AST    },
         { "ntsc-j",  OPTION_VAL_NTSC_J_AST },
         { NULL, NULL },
      },
      "auto"
   },
   {
      "genesis_plus_gx_vdp_mode",
      GENESIS_PLUS_GX_VDP_MODE_LABEL_AST,
      NULL,
      GENESIS_PLUS_GX_VDP_MODE_INFO_0_AST,
      NULL,
      "system",
      {
         { "auto",  "Disabled" },
         { "60hz",  OPTION_VAL_60HZ_AST },
         { "50hz",  OPTION_VAL_50HZ_AST },
         { NULL, NULL },
      },
      "auto"
   },
   {
      "genesis_plus_gx_bios",
      GENESIS_PLUS_GX_BIOS_LABEL_AST,
      NULL,
      GENESIS_PLUS_GX_BIOS_INFO_0_AST,
      NULL,
      "system",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_system_bram",
      GENESIS_PLUS_GX_SYSTEM_BRAM_LABEL_AST,
      NULL,
      GENESIS_PLUS_GX_SYSTEM_BRAM_INFO_0_AST,
      NULL,
      "system",
      {
         { "per bios", OPTION_VAL_PER_BIOS_AST },
         { "per game", OPTION_VAL_PER_GAME_AST },
         { NULL, NULL },
      },
      "per bios"
   },
   {
      "genesis_plus_gx_cart_bram",
      GENESIS_PLUS_GX_CART_BRAM_LABEL_AST,
      NULL,
      GENESIS_PLUS_GX_CART_BRAM_INFO_0_AST,
      NULL,
      "system",
      {
         { "per cart", OPTION_VAL_PER_CART_AST },
         { "per game", OPTION_VAL_PER_GAME_AST },
         { NULL, NULL },
      },
      "per cart"
   },
   {
      "genesis_plus_gx_cart_size",
      GENESIS_PLUS_GX_CART_SIZE_LABEL_AST,
      NULL,
      GENESIS_PLUS_GX_CART_SIZE_INFO_0_AST,
      NULL,
      "system",
      {
         { "disabled", "Disabled" },
         { "128k",     OPTION_VAL_128K_AST  },
         { "256k",     OPTION_VAL_256K_AST  },
         { "512k",     OPTION_VAL_512K_AST  },
         { "1meg",     OPTION_VAL_1MEG_AST    },
         { "2meg",     OPTION_VAL_2MEG_AST    },
         { "4meg",     OPTION_VAL_4MEG_AST    },
         { NULL, NULL },
      },
      "4meg"
   },
   {
      "genesis_plus_gx_add_on",
      GENESIS_PLUS_GX_ADD_ON_LABEL_AST,
      NULL,
      GENESIS_PLUS_GX_ADD_ON_INFO_0_AST,
      NULL,
      "system",
      {
         { "auto",         OPTION_VAL_AUTO_AST },
         { "sega/mega cd", OPTION_VAL_SEGA_MEGA_CD_AST },
         { "megasd",       OPTION_VAL_MEGASD_AST },
         { "none",         OPTION_VAL_NONE_AST },
         { NULL, NULL },
      },
      "auto"
   },
   {
      "genesis_plus_gx_lock_on",
      GENESIS_PLUS_GX_LOCK_ON_LABEL_AST,
      NULL,
      GENESIS_PLUS_GX_LOCK_ON_INFO_0_AST,
      NULL,
      "system",
      {
         { "disabled",            NULL },
         { "game genie",          OPTION_VAL_GAME_GENIE_AST },
         { "action replay (pro)", OPTION_VAL_ACTION_REPLAY_PRO_AST },
         { "sonic & knuckles",    OPTION_VAL_SONIC_KNUCKLES_AST },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_aspect_ratio",
      GENESIS_PLUS_GX_ASPECT_RATIO_LABEL_AST,
      NULL,
      GENESIS_PLUS_GX_ASPECT_RATIO_INFO_0_AST,
      NULL,
      "video",
      {
         { "auto",     OPTION_VAL_AUTO_AST },
         { "NTSC PAR", OPTION_VAL_NTSC_PAR_AST },
         { "PAL PAR",  OPTION_VAL_PAL_PAR_AST },
         { "4:3",  OPTION_VAL_4_3_AST },
         { "Uncorrected",  OPTION_VAL_UNCORRECTED_AST },
      },
      "auto"
   },
   {
      "genesis_plus_gx_overscan",
      GENESIS_PLUS_GX_OVERSCAN_LABEL_AST,
      NULL,
      GENESIS_PLUS_GX_OVERSCAN_INFO_0_AST,
      NULL,
      "video",
      {
         { "disabled",   NULL },
         { "top/bottom", OPTION_VAL_TOP_BOTTOM_AST },
         { "left/right", OPTION_VAL_LEFT_RIGHT_AST },
         { "full",       OPTION_VAL_FULL_AST },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_left_border",
      GENESIS_PLUS_GX_LEFT_BORDER_LABEL_AST,
      NULL,
      GENESIS_PLUS_GX_LEFT_BORDER_INFO_0_AST,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "left border", OPTION_VAL_LEFT_BORDER_AST },
         { "left & right borders", OPTION_VAL_LEFT_RIGHT_BORDERS_AST },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_gg_extra",
      GENESIS_PLUS_GX_GG_EXTRA_LABEL_AST,
      NULL,
      GENESIS_PLUS_GX_GG_EXTRA_INFO_0_AST,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_blargg_ntsc_filter",
      GENESIS_PLUS_GX_BLARGG_NTSC_FILTER_LABEL_AST,
      NULL,
      GENESIS_PLUS_GX_BLARGG_NTSC_FILTER_INFO_0_AST,
      NULL,
      "video",
      {
         { "disabled",   NULL },
         { "monochrome", OPTION_VAL_MONOCHROME_AST },
         { "composite",  OPTION_VAL_COMPOSITE_AST },
         { "svideo",     OPTION_VAL_SVIDEO_AST },
         { "rgb",        OPTION_VAL_RGB_AST },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_lcd_filter",
      GENESIS_PLUS_GX_LCD_FILTER_LABEL_AST,
      NULL,
      GENESIS_PLUS_GX_LCD_FILTER_INFO_0_AST,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_render",
      GENESIS_PLUS_GX_RENDER_LABEL_AST,
      NULL,
      GENESIS_PLUS_GX_RENDER_INFO_0_AST,
      NULL,
      "video",
      {
         { "single field", OPTION_VAL_SINGLE_FIELD_AST },
         { "double field", OPTION_VAL_DOUBLE_FIELD_AST },
         { NULL, NULL },
      },
      "single field"
   },
   {
      "genesis_plus_gx_frameskip",
      GENESIS_PLUS_GX_FRAMESKIP_LABEL_AST,
      NULL,
      GENESIS_PLUS_GX_FRAMESKIP_INFO_0_AST,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "auto",     OPTION_VAL_AUTO_AST },
         { "manual",   OPTION_VAL_MANUAL_AST },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_frameskip_threshold",
      GENESIS_PLUS_GX_FRAMESKIP_THRESHOLD_LABEL_AST,
      NULL,
      GENESIS_PLUS_GX_FRAMESKIP_THRESHOLD_INFO_0_AST,
      NULL,
      "video",
      {
         { "15", NULL },
         { "18", NULL },
         { "21", NULL },
         { "24", NULL },
         { "27", NULL },
         { "30", NULL },
         { "33", NULL },
         { "36", NULL },
         { "39", NULL },
         { "42", NULL },
         { "45", NULL },
         { "48", NULL },
         { "51", NULL },
         { "54", NULL },
         { "57", NULL },
         { "60", NULL },
         { NULL, NULL },
      },
      "33"
   },
   {
      "genesis_plus_gx_ym2413",
      GENESIS_PLUS_GX_YM2413_LABEL_AST,
      NULL,
      GENESIS_PLUS_GX_YM2413_INFO_0_AST,
      NULL,
      "audio",
      {
         { "auto",     OPTION_VAL_AUTO_AST },
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "auto"
   },
#ifdef HAVE_OPLL_CORE
   {
      "genesis_plus_gx_ym2413_core",
      GENESIS_PLUS_GX_YM2413_CORE_LABEL_AST,
      NULL,
      GENESIS_PLUS_GX_YM2413_CORE_INFO_0_AST,
      NULL,
      "audio",
      {
         { "mame",  OPTION_VAL_MAME_AST },
         { "nuked", OPTION_VAL_NUKED_AST },
         { NULL, NULL },
      },
      "mame"
   },
#endif
   {
      "genesis_plus_gx_ym2612",
      GENESIS_PLUS_GX_YM2612_LABEL_AST,
      NULL,
#ifdef HAVE_YM3438_CORE
      GENESIS_PLUS_GX_YM2612_INFO_0_AST,
#else
      GENESIS_PLUS_GX_YM2612_INFO_1_AST,
#endif
      NULL,
      "audio",
      {
         { "mame (ym2612)",          OPTION_VAL_MAME_YM2612_AST },
         { "mame (asic ym3438)",     OPTION_VAL_MAME_ASIC_YM3438_AST },
         { "mame (enhanced ym3438)", OPTION_VAL_MAME_ENHANCED_YM3438_AST },
#ifdef HAVE_YM3438_CORE
         { "nuked (ym2612)",         OPTION_VAL_NUKED_YM2612_AST },
         { "nuked (ym3438)",         OPTION_VAL_NUKED_YM3438_AST },
#endif
         { NULL, NULL },
      },
      "mame (ym2612)"
   },
   {
      "genesis_plus_gx_sound_output",
      GENESIS_PLUS_GX_SOUND_OUTPUT_LABEL_AST,
      NULL,
      GENESIS_PLUS_GX_SOUND_OUTPUT_INFO_0_AST,
      NULL,
      "audio",
      {
         { "stereo", OPTION_VAL_STEREO_AST },
         { "mono",   OPTION_VAL_MONO_AST },
         { NULL, NULL },
      },
      "stereo"
   },
   {
      "genesis_plus_gx_audio_filter",
      GENESIS_PLUS_GX_AUDIO_FILTER_LABEL_AST,
      NULL,
      GENESIS_PLUS_GX_AUDIO_FILTER_INFO_0_AST,
      NULL,
      "audio",
      {
         { "disabled", NULL },
         { "low-pass", OPTION_VAL_LOW_PASS_AST },
#ifdef HAVE_EQ
         { "EQ",       OPTION_VAL_EQ_AST },
#endif
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_lowpass_range",
      GENESIS_PLUS_GX_LOWPASS_RANGE_LABEL_AST,
      NULL,
      GENESIS_PLUS_GX_LOWPASS_RANGE_INFO_0_AST,
      NULL,
      "audio",
      {
         { "5",  NULL },
         { "10", NULL },
         { "15", NULL },
         { "20", NULL },
         { "25", NULL },
         { "30", NULL },
         { "35", NULL },
         { "40", NULL },
         { "45", NULL },
         { "50", NULL },
         { "55", NULL },
         { "60", NULL },
         { "65", NULL },
         { "70", NULL },
         { "75", NULL },
         { "80", NULL },
         { "85", NULL },
         { "90", NULL },
         { "95", NULL },
         { NULL, NULL },
      },
      "60"
   },
   {
      "genesis_plus_gx_psg_preamp",
      GENESIS_PLUS_GX_PSG_PREAMP_LABEL_AST,
      NULL,
      GENESIS_PLUS_GX_PSG_PREAMP_INFO_0_AST,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { "105", NULL },
         { "110", NULL },
         { "115", NULL },
         { "120", NULL },
         { "125", NULL },
         { "130", NULL },
         { "135", NULL },
         { "140", NULL },
         { "145", NULL },
         { "150", NULL },
         { "155", NULL },
         { "160", NULL },
         { "165", NULL },
         { "170", NULL },
         { "175", NULL },
         { "180", NULL },
         { "185", NULL },
         { "190", NULL },
         { "195", NULL },
         { "200", NULL },
         { NULL, NULL },
      },
      "150"
   },
   {
      "genesis_plus_gx_fm_preamp",
      GENESIS_PLUS_GX_FM_PREAMP_LABEL_AST,
      NULL,
      GENESIS_PLUS_GX_FM_PREAMP_INFO_0_AST,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { "105", NULL },
         { "110", NULL },
         { "115", NULL },
         { "120", NULL },
         { "125", NULL },
         { "130", NULL },
         { "135", NULL },
         { "140", NULL },
         { "145", NULL },
         { "150", NULL },
         { "155", NULL },
         { "160", NULL },
         { "165", NULL },
         { "170", NULL },
         { "175", NULL },
         { "180", NULL },
         { "185", NULL },
         { "190", NULL },
         { "195", NULL },
         { "200", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_cdda_volume",
      GENESIS_PLUS_GX_CDDA_VOLUME_LABEL_AST,
      NULL,
      GENESIS_PLUS_GX_CDDA_VOLUME_INFO_0_AST,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_pcm_volume",
      GENESIS_PLUS_GX_PCM_VOLUME_LABEL_AST,
      NULL,
      GENESIS_PLUS_GX_PCM_VOLUME_INFO_0_AST,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
#ifdef HAVE_EQ
   {
      "genesis_plus_gx_audio_eq_low",
      GENESIS_PLUS_GX_AUDIO_EQ_LOW_LABEL_AST,
      NULL,
      GENESIS_PLUS_GX_AUDIO_EQ_LOW_INFO_0_AST,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_audio_eq_mid",
      GENESIS_PLUS_GX_AUDIO_EQ_MID_LABEL_AST,
      NULL,
      GENESIS_PLUS_GX_AUDIO_EQ_MID_INFO_0_AST,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_audio_eq_high",
      GENESIS_PLUS_GX_AUDIO_EQ_HIGH_LABEL_AST,
      NULL,
      GENESIS_PLUS_GX_AUDIO_EQ_HIGH_INFO_0_AST,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
#endif
   {
      "genesis_plus_gx_gun_input",
      GENESIS_PLUS_GX_GUN_INPUT_LABEL_AST,
      NULL,
      GENESIS_PLUS_GX_GUN_INPUT_INFO_0_AST,
      NULL,
      "input",
      {
         { "lightgun",    OPTION_VAL_LIGHTGUN_AST },
         { "touchscreen", OPTION_VAL_TOUCHSCREEN_AST },
         { NULL, NULL },
      },
      "lightgun"
   },
   {
      "genesis_plus_gx_gun_cursor",
      GENESIS_PLUS_GX_GUN_CURSOR_LABEL_AST,
      NULL,
      GENESIS_PLUS_GX_GUN_CURSOR_INFO_0_AST,
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_invert_mouse",
      GENESIS_PLUS_GX_INVERT_MOUSE_LABEL_AST,
      NULL,
      GENESIS_PLUS_GX_INVERT_MOUSE_INFO_0_AST,
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_no_sprite_limit",
      GENESIS_PLUS_GX_NO_SPRITE_LIMIT_LABEL_AST,
      NULL,
      GENESIS_PLUS_GX_NO_SPRITE_LIMIT_INFO_0_AST,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_enhanced_vscroll",
      GENESIS_PLUS_GX_ENHANCED_VSCROLL_LABEL_AST,
      NULL,
      GENESIS_PLUS_GX_ENHANCED_VSCROLL_INFO_0_AST,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_enhanced_vscroll_limit",
      GENESIS_PLUS_GX_ENHANCED_VSCROLL_LIMIT_LABEL_AST,
      NULL,
      GENESIS_PLUS_GX_ENHANCED_VSCROLL_LIMIT_INFO_0_AST,
      NULL,
      "hacks",
      {
         { "2", NULL },
         { "3",  NULL },
         { "4", NULL },
         { "5",  NULL },
         { "6", NULL },
         { "7",  NULL },
         { "8", NULL },
         { "9",  NULL },
         { "10", NULL },
         { "11",  NULL },
         { "12", NULL },
         { "13",  NULL },
         { "14", NULL },
         { "15",  NULL },
         { "16", NULL },
         { NULL, NULL },
      },
      "8"
   },
#ifdef HAVE_OVERCLOCK
   {
      "genesis_plus_gx_overclock",
      GENESIS_PLUS_GX_OVERCLOCK_LABEL_AST,
      NULL,
      GENESIS_PLUS_GX_OVERCLOCK_INFO_0_AST,
      NULL,
      "hacks",
      {
         { "100", OPTION_VAL_100_AST },
         { "125", OPTION_VAL_125_AST },
         { "150", OPTION_VAL_150_AST },
         { "175", OPTION_VAL_175_AST },
         { "200", OPTION_VAL_200_AST },
         { "225", OPTION_VAL_225_AST },
         { "250", OPTION_VAL_250_AST },
         { "275", OPTION_VAL_275_AST },
         { "300", OPTION_VAL_300_AST },
         { "325", OPTION_VAL_325_AST },
         { "350", OPTION_VAL_350_AST },
         { "375", OPTION_VAL_375_AST },
         { "400", OPTION_VAL_400_AST },
         { "425", OPTION_VAL_425_AST },
         { "450", OPTION_VAL_450_AST },
         { "475", OPTION_VAL_475_AST },
         { "500", OPTION_VAL_500_AST },
         { NULL, NULL },
      },
      "100%"
   },
#endif
   {
      "genesis_plus_gx_force_dtack",
      GENESIS_PLUS_GX_FORCE_DTACK_LABEL_AST,
      NULL,
      GENESIS_PLUS_GX_FORCE_DTACK_INFO_0_AST,
      NULL,
      "hacks",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL },
      },
      "enabled"
   },
   {
      "genesis_plus_gx_addr_error",
      GENESIS_PLUS_GX_ADDR_ERROR_LABEL_AST,
      NULL,
      GENESIS_PLUS_GX_ADDR_ERROR_INFO_0_AST,
      NULL,
      "hacks",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL },
      },
      "enabled"
   },
   {
      "genesis_plus_gx_cd_latency",
      GENESIS_PLUS_GX_CD_LATENCY_LABEL_AST,
      NULL,
      GENESIS_PLUS_GX_CD_LATENCY_INFO_0_AST,
      NULL,
      "hacks",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL },
      },
      "enabled"
   },
   {
      "genesis_plus_gx_cd_precache",
      GENESIS_PLUS_GX_CD_PRECACHE_LABEL_AST,
      NULL,
      GENESIS_PLUS_GX_CD_PRECACHE_INFO_0_AST,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
#ifdef USE_PER_SOUND_CHANNELS_CONFIG
   {
      "genesis_plus_gx_show_advanced_audio_settings",
      GENESIS_PLUS_GX_SHOW_ADVANCED_AUDIO_SETTINGS_LABEL_AST,
      NULL,
      GENESIS_PLUS_GX_SHOW_ADVANCED_AUDIO_SETTINGS_INFO_0_AST,
      NULL,
      "channel_volume",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL},
      },
      "disabled"
   },
   {
      "genesis_plus_gx_psg_channel_0_volume",
      GENESIS_PLUS_GX_PSG_CHANNEL_0_VOLUME_LABEL_AST,
      NULL,
      GENESIS_PLUS_GX_PSG_CHANNEL_0_VOLUME_INFO_0_AST,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_psg_channel_1_volume",
      GENESIS_PLUS_GX_PSG_CHANNEL_1_VOLUME_LABEL_AST,
      NULL,
      GENESIS_PLUS_GX_PSG_CHANNEL_1_VOLUME_INFO_0_AST,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_psg_channel_2_volume",
      GENESIS_PLUS_GX_PSG_CHANNEL_2_VOLUME_LABEL_AST,
      NULL,
      GENESIS_PLUS_GX_PSG_CHANNEL_2_VOLUME_INFO_0_AST,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_psg_channel_3_volume",
      GENESIS_PLUS_GX_PSG_CHANNEL_3_VOLUME_LABEL_AST,
      NULL,
      GENESIS_PLUS_GX_PSG_CHANNEL_3_VOLUME_INFO_0_AST,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_0_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_0_VOLUME_LABEL_AST,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_0_VOLUME_INFO_0_AST,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_1_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_1_VOLUME_LABEL_AST,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_1_VOLUME_INFO_0_AST,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_2_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_2_VOLUME_LABEL_AST,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_2_VOLUME_INFO_0_AST,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_3_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_3_VOLUME_LABEL_AST,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_3_VOLUME_INFO_0_AST,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_4_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_4_VOLUME_LABEL_AST,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_4_VOLUME_INFO_0_AST,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_5_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_5_VOLUME_LABEL_AST,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_5_VOLUME_INFO_0_AST,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_0_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_0_VOLUME_LABEL_AST,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_0_VOLUME_INFO_0_AST,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_1_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_1_VOLUME_LABEL_AST,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_1_VOLUME_INFO_0_AST,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_2_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_2_VOLUME_LABEL_AST,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_2_VOLUME_INFO_0_AST,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_3_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_3_VOLUME_LABEL_AST,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_3_VOLUME_INFO_0_AST,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_4_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_4_VOLUME_LABEL_AST,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_4_VOLUME_INFO_0_AST,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_5_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_5_VOLUME_LABEL_AST,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_5_VOLUME_INFO_0_AST,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_6_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_6_VOLUME_LABEL_AST,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_6_VOLUME_INFO_0_AST,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_7_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_7_VOLUME_LABEL_AST,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_7_VOLUME_INFO_0_AST,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_8_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_8_VOLUME_LABEL_AST,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_8_VOLUME_INFO_0_AST,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
#endif
   { NULL, NULL, NULL, NULL, NULL, NULL, {{0}}, NULL },
};
struct retro_core_options_v2 options_ast = {
   option_cats_ast,
   option_defs_ast
};

/* RETRO_LANGUAGE_BE */

#define CATEGORY_SYSTEM_LABEL_BE "Сістэма"
#define CATEGORY_SYSTEM_INFO_0_BE "Настройка параметраў выбару сістэмы, рэгіёна, BIOS і захаванняў Sega CD/Mega-CD."
#define CATEGORY_VIDEO_LABEL_BE "Відэа"
#define CATEGORY_VIDEO_INFO_0_BE "Налады суадносін бакоў, кадравання, графічных фільтраў і пропуску кадраў."
#define CATEGORY_AUDIO_LABEL_BE "Аўдыя"
#define CATEGORY_AUDIO_INFO_0_BE "Змяніць налады аўдыяпрылады."
#define CATEGORY_INPUT_LABEL_BE "Увод"
#define CATEGORY_INPUT_INFO_0_BE "Налады ўводу для мышы і/або светлавога пісталета."
#define CATEGORY_HACKS_LABEL_BE "Хакі эмуляцыі"
#define CATEGORY_HACKS_INFO_0_BE "Налада разгону працэсара і параметраў дакладнасці эмуляцыі, якія ўплываюць на прадукцыйнасць і сумяшчальнасць."
#define CATEGORY_CHANNEL_VOLUME_LABEL_BE "Пашыраныя налады гучнасці каналаў"
#define CATEGORY_CHANNEL_VOLUME_INFO_0_BE "Індывідуальная настройка гучнасці аўдыёканалаў."
#define GENESIS_PLUS_GX_SYSTEM_HW_LABEL_BE "Мадэль сістэмы"
#define GENESIS_PLUS_GX_SYSTEM_HW_INFO_0_BE "Запуск кантэнту на эмуляванай кансолі вызначанай мадэлі. У рэжыме 'Аўтаматычна' будзе абрана сістэма якая найбольш пасуе для бягучай гульні."
#define OPTION_VAL_AUTO_BE "Аўта"
#define OPTION_VAL_SG_1000_BE NULL
#define OPTION_VAL_SG_1000_II_BE NULL
#define OPTION_VAL_SG_1000_II_RAM_EXT_BE "SG-1000 II + Пашырэнне АЗП."
#define OPTION_VAL_MARK_III_BE NULL
#define OPTION_VAL_MASTER_SYSTEM_BE NULL
#define OPTION_VAL_MASTER_SYSTEM_II_BE NULL
#define OPTION_VAL_GAME_GEAR_BE NULL
#define OPTION_VAL_MEGA_DRIVE_GENESIS_BE NULL
#define GENESIS_PLUS_GX_REGION_DETECT_LABEL_BE "Рэгіён сістэмы"
#define GENESIS_PLUS_GX_REGION_DETECT_INFO_0_BE "Выбар рэгіёна сістэмы. Акрамя Game Gear, для ўсіх кансоляў рэжым 'PAL' адпавядае 50 Гц, 'NTSC' - 60 Гц. Пры няправільнай усталёўцы рэгіёна гульні могуць ісці хутчэй ці павольней."
#define OPTION_VAL_NTSC_U_BE NULL
#define OPTION_VAL_PAL_BE NULL
#define OPTION_VAL_NTSC_J_BE NULL
#define GENESIS_PLUS_GX_VDP_MODE_LABEL_BE "Фарсіраваць рэжым VDP"
#define GENESIS_PLUS_GX_VDP_MODE_INFO_0_BE "Перавызначае рэжым VDP для прымусовай працы ў NTSC 60 Гц або PAL 50 Гц, незалежна ад рэгіёна сістэмы."
#define OPTION_VAL_60HZ_BE "NTSC (60 Гц)"
#define OPTION_VAL_50HZ_BE "PAL (50 Гц)"
#define GENESIS_PLUS_GX_BIOS_LABEL_BE "Загрузачная выява сістэмы"
#define GENESIS_PLUS_GX_BIOS_INFO_0_BE "Выкарыстоўваць афіцыйны BIOS/загрузнік эмуляванай кансолі пры наяўнасці файла ў сістэмным каталогу RetroArch. Адлюстроўвае стартавую анімацыю загрузкі кансолі перад запускам кантэнту."
#define GENESIS_PLUS_GX_SYSTEM_BRAM_LABEL_BE "Сістэмная рэзервовая памяць Sega CD (патрабуецца перазапуск)"
#define GENESIS_PLUS_GX_SYSTEM_BRAM_INFO_0_BE "Вызначае, выкарыстоўваць для гульняў Sega CD/Mega-CD аднаго рэгіёна адзіны файл захавання (значэнне 'Агульная па BIOS') або ствараць асобныя файлы захавання (значэнне 'Індывідуальна для гульні'). Улічвайце, што аб'ём унутранай памяці Sega CD/Mega-CD дастатковы толькі для некалькіх гульняў. Каб пазбегнуць недахопу месца, выкарыстоўвайце рэжым 'Для гульні'."
#define OPTION_VAL_PER_BIOS_BE "Агульная па BIOS"
#define OPTION_VAL_PER_GAME_BE "Індывідуальна для гульні"
#define GENESIS_PLUS_GX_CART_BRAM_LABEL_BE "Картрыдж рэзервовай памяці Sega CD (патрабуецца перазапуск)"
#define GENESIS_PLUS_GX_CART_BRAM_INFO_0_BE "Пры запуску кантэнту Sega CD/Mega-CD паказвае, ці варта выкарыстоўваць для ўсіх гульняў адзіны картрыдж рэзервовай памяці (значэнне 'Агульная для ўсіх гульняў') або ствараць асобныя файлы рэзервовай памяці (значэнне 'Індывідуальна для гульні')."
#define OPTION_VAL_PER_CART_BE "Агульная для ўсіх гульняў"
#define GENESIS_PLUS_GX_CART_SIZE_LABEL_BE "Памер картрыджа рэзервовай памяці Sega CD (патрабуецца перазапуск)"
#define GENESIS_PLUS_GX_CART_SIZE_INFO_0_BE "Усталёўвае памер картрыджа рэзервовай памяці для кантэнту Sega CD/Mega-CD. Карысна ў рэжыме рэзервовай памяці \"Індывідуальна для гульні\", каб пазбегнуць стварэння файлаў вялікага памеру."
#define OPTION_VAL_128K_BE "128кбіт"
#define OPTION_VAL_256K_BE "256кбіт"
#define OPTION_VAL_512K_BE "512кбіт"
#define OPTION_VAL_1MEG_BE "1Мбіт"
#define OPTION_VAL_2MEG_BE "2Мбіт"
#define OPTION_VAL_4MEG_BE "4Мбіт"
#define GENESIS_PLUS_GX_ADD_ON_LABEL_BE "Пашырэнне CD (рэжым MD) (патрабуецца перазапуск)"
#define GENESIS_PLUS_GX_ADD_ON_INFO_0_BE "Выбар пашырэння для гульняў Mega Drive / Genesis з падтрымкай прайгравання аўдыё CD."
#define OPTION_VAL_SEGA_MEGA_CD_BE NULL
#define OPTION_VAL_MEGASD_BE NULL
#define OPTION_VAL_NONE_BE "Няма"
#define GENESIS_PLUS_GX_LOCK_ON_LABEL_BE "Картрыдж Lock-On"
#define GENESIS_PLUS_GX_LOCK_ON_INFO_0_BE "Тэхналогія Lock-On – гэта пашырэнне Mega Drive/Genesis, якое дазваляла падлучаць старыя гульні праз спецыяльны картрыдж для атрымання пашыранага або змененага геймплэя. Дадзеная опцыя усталёўвае тып які эмулюецца картрыджа 'lock-on'. Які адпавядае файл Bios павінен прысутнічаць у сістэмным каталогу RetroArch."
#define OPTION_VAL_GAME_GENIE_BE NULL
#define OPTION_VAL_ACTION_REPLAY_PRO_BE NULL
#define OPTION_VAL_SONIC_KNUCKLES_BE NULL
#define GENESIS_PLUS_GX_ASPECT_RATIO_LABEL_BE "Забяспечаныя ядром суадносіны бакоў"
#define GENESIS_PLUS_GX_ASPECT_RATIO_INFO_0_BE "Выбар пераважных суадносін бакоў кантэнту. Ужываецца толькі пры выбары рэжыму суадносін бакоў 'Налада ядра' у наладах відэа RetroArch."
#define OPTION_VAL_NTSC_PAR_BE NULL
#define OPTION_VAL_PAL_PAR_BE NULL
#define OPTION_VAL_4_3_BE NULL
#define OPTION_VAL_UNCORRECTED_BE "Без карэкцыі"
#define GENESIS_PLUS_GX_OVERSCAN_LABEL_BE "Межы"
#define GENESIS_PLUS_GX_OVERSCAN_INFO_0_BE "Уключыце для адлюстравання вылетаў разгорткі зверху/знізу і/або злева/справа. У тэлевізарах стандартнай выразнасці гэтыя вобласці звычайна ўтоены рамкай па краі экрана."
#define OPTION_VAL_TOP_BOTTOM_BE "Зверху/знізу"
#define OPTION_VAL_LEFT_RIGHT_BE "Злеву/справа"
#define OPTION_VAL_FULL_BE "Цалкам"
#define GENESIS_PLUS_GX_LEFT_BORDER_LABEL_BE "Хаваць бакавыя межы Master System"
#define GENESIS_PLUS_GX_LEFT_BORDER_INFO_0_BE "Абрэзаць па 8 пікселяў з левага боку або з левага і правага бакоў экрана пры запуску гульняў Master System."
#define OPTION_VAL_LEFT_BORDER_BE "Толькі мяжа злева"
#define OPTION_VAL_LEFT_RIGHT_BORDERS_BE "Межы злева ды справа"
#define GENESIS_PLUS_GX_GG_EXTRA_LABEL_BE "Пашыраны экран Game Gear"
#define GENESIS_PLUS_GX_GG_EXTRA_INFO_0_BE "Прымусовы запуск гульняў Game Gear у рэжыме SMS у падвышаным раздзяленні 256×192. Можа пашыраць вобласць выявы, але часцей прыводзіць да з'яўлення артэфактаў вакол экрана."
#define GENESIS_PLUS_GX_BLARGG_NTSC_FILTER_LABEL_BE "NTSC-фільтры Blargg'а"
#define GENESIS_PLUS_GX_BLARGG_NTSC_FILTER_INFO_0_BE "Ужывае відэафільтр для імітацыі розных сігналаў NTSC ТБ."
#define OPTION_VAL_MONOCHROME_BE "Манахромны"
#define OPTION_VAL_COMPOSITE_BE "Кампазітны"
#define OPTION_VAL_SVIDEO_BE NULL
#define OPTION_VAL_RGB_BE NULL
#define GENESIS_PLUS_GX_LCD_FILTER_LABEL_BE "Ghosting-фільтр LCD"
#define GENESIS_PLUS_GX_LCD_FILTER_INFO_0_BE "Ужывае да выявы фільтр 'дваення' для імітацыі асаблівасцяў ВК-дысплеяў Game Gear і Genesis Nomad."
#define GENESIS_PLUS_GX_RENDER_LABEL_BE "Рэжым Interlaced Mode 2"
#define GENESIS_PLUS_GX_RENDER_INFO_0_BE "Interlaced Mode 2 дазваляе Mega Drive/Genesis выводзіць малюнак з падвоенай вышынёй (у высокім раздзяленні) 320×448 шляхам дамалёўкі ў кожным кадры дадатковых радкоў разгорткі (як у рэжыме мультыплэера ў 'Sonic The Hedgehog 2' і 'Combat Cars'). Рэжым 'Два палі' імітуе арыгінальную кансоль, выдаючы выразную карцінку з артэфактамі мігацення / празрадковасці. У рэжыме 'Адно поле' ужываецца фільтр дэінтэрлейсінгу, які стабілізуе малюнак, але дадае невялікае размыццё."
#define OPTION_VAL_SINGLE_FIELD_BE "Адзінкавае поле"
#define OPTION_VAL_DOUBLE_FIELD_BE "Двайное поле"
#define GENESIS_PLUS_GX_FRAMESKIP_LABEL_BE "Прапусканне кадраў"
#define GENESIS_PLUS_GX_FRAMESKIP_INFO_0_BE "Прапускаць кадры, каб пазбегнуць з'яўлення (трэска) пры спусташэнні аўдыёбуфера. Паляпшае прадукцыйнасць, але зніжае плаўнасць выявы. У рэжыме 'Аўта' пропуск кадраў рэгулюецца франтэндам. У рэжыме 'Уручную' выкарыстоўваецца значэнне опцыі 'Мяжа пропуску кадраў (%)'."
#define OPTION_VAL_MANUAL_BE "Уручную"
#define GENESIS_PLUS_GX_FRAMESKIP_THRESHOLD_LABEL_BE "Парог прапускання кадраў (%)"
#define GENESIS_PLUS_GX_FRAMESKIP_THRESHOLD_INFO_0_BE "Усталёўвае парог запаўнення аўдыёбуфера (у працэнтах), ніжэй за які будзе ўключацца пропуск кадраў, калі для параметра 'Пропуск кадраў' выбраны рэжым 'Уручную'. Вялікія значэнні змяншаюць верагоднасць з'яўлення трэска за рахунак больш частага пропуску кадраў."
#define GENESIS_PLUS_GX_YM2413_LABEL_BE NULL
#define GENESIS_PLUS_GX_YM2413_INFO_0_BE "Уключае эмуляцыю FM Sound Unit, які выкарыстоўваецца для паляпшэння гуку ў некаторых гульнях Sega Mark III/Master System."
#define GENESIS_PLUS_GX_YM2413_CORE_LABEL_BE "Ядро Master System FM (YM2413)"
#define GENESIS_PLUS_GX_YM2413_CORE_INFO_0_BE "Выбар спосабу эмуляцыі FM Sound Unit мадэляў Sega Mark III/Master System. Рэжым 'MAME' хуткі і выдае поўную хуткасць на большасці прылад. 'Nuked' забяспечвае патактавую дакладнасць, вельмі высокая якасць, але прад'яўляе падвышаныя патрабаванні да CPU."
#define OPTION_VAL_MAME_BE NULL
#define OPTION_VAL_NUKED_BE NULL
#define GENESIS_PLUS_GX_YM2612_LABEL_BE NULL
#define GENESIS_PLUS_GX_YM2612_INFO_0_BE "Выбар спосабу эмуляцыі FM-сінтэзатара (асноўнага генератара гуку) Mega Drive/Genesis. Рэжымы 'MAME' хуткія і працуюць без запаволенняў на большасці прылад. 'Nuked' забяспечваюць патактавую дакладнасць, вельмі высокая якасць, але прад'яўляюць падвышаныя патрабаванні да CPU. Чып YM2612 выкарыстоўваецца ў арыгінальнай Mega Drive/Genesis Model 1. YM3438 выкарыстоўваецца ў пазнейшых мадэлях Mega Drive/Genesis."
#define GENESIS_PLUS_GX_YM2612_INFO_1_BE "Выбар спосабу эмуляцыі FM-сінтэзатара (асноўнага генератара гуку) Mega Drive/Genesis. Чып YM2612 выкарыстоўваецца ў арыгінальнай Mega Drive/Genesis Model 1. YM3438 выкарыстоўваецца ў пазнейшых мадэлях Mega Drive/Genesis."
#define OPTION_VAL_MAME_YM2612_BE NULL
#define OPTION_VAL_MAME_ASIC_YM3438_BE NULL
#define OPTION_VAL_MAME_ENHANCED_YM3438_BE "MAME (удасканалены YM3438)"
#define OPTION_VAL_NUKED_YM2612_BE NULL
#define OPTION_VAL_NUKED_YM3438_BE NULL
#define GENESIS_PLUS_GX_SOUND_OUTPUT_LABEL_BE "Вывад гуку"
#define GENESIS_PLUS_GX_SOUND_OUTPUT_INFO_0_BE "Выбраць стэрэа або мона прайграванне гуку."
#define OPTION_VAL_STEREO_BE "Стэрэа"
#define OPTION_VAL_MONO_BE "Мона"
#define GENESIS_PLUS_GX_AUDIO_FILTER_LABEL_BE "Аўдыяфільтр"
#define GENESIS_PLUS_GX_AUDIO_FILTER_INFO_0_BE "Уключае фільтр ніжніх частот для лепшай імітацыі асаблівасцяў гучання Mega Drive/Genesis Model 1."
#define OPTION_VAL_LOW_PASS_BE "Нізкачастотны"
#define OPTION_VAL_EQ_BE "Эквалайзер"
#define GENESIS_PLUS_GX_LOWPASS_RANGE_LABEL_BE "Фільтр нізкіх частот %"
#define GENESIS_PLUS_GX_LOWPASS_RANGE_INFO_0_BE "Настройка частаты зрэзу для нізкачастотнага прапускнога фільтра. Вялікія значэнні ўзмацняюць эфект фільтра з-за ўплыву на шырэйшы спектр высокіх частот."
#define GENESIS_PLUS_GX_PSG_PREAMP_LABEL_BE "Узмацненне PSG"
#define GENESIS_PLUS_GX_PSG_PREAMP_INFO_0_BE "Ўстаноўка ўзроўню ўзмацнення для эмуляванага 4-канальнага праграмаванага генератара сігналаў SN76496 у SG-1000, Sega Mark III, Master System, Game Gear і Mega Drive / Genesis."
#define GENESIS_PLUS_GX_FM_PREAMP_LABEL_BE "Узмацненне FM"
#define GENESIS_PLUS_GX_FM_PREAMP_INFO_0_BE "Ўстаноўка ўзроўню ўзмацнення гуку эмуляванага FM-сінтэзатара Mega Drive/Genesis або FM Sound Unit у Sega Mark III/Master System."
#define GENESIS_PLUS_GX_CDDA_VOLUME_LABEL_BE "Гучнасць CD-DA"
#define GENESIS_PLUS_GX_CDDA_VOLUME_INFO_0_BE "Рэгулёўка ўзроўню гучнасці на выхадзе эмуляванага CD-аўдыё."
#define GENESIS_PLUS_GX_PCM_VOLUME_LABEL_BE "Гучнасць PCM"
#define GENESIS_PLUS_GX_PCM_VOLUME_INFO_0_BE "Рэгулёўка гучнасці гуку на выхадзе эмуляванага PCM генератара RF5C164 Sega CD/Mega-CD."
#define GENESIS_PLUS_GX_AUDIO_EQ_LOW_LABEL_BE "Настройка ніжніх частот"
#define GENESIS_PLUS_GX_AUDIO_EQ_LOW_INFO_0_BE "Рэгулёўка нізкачастотнага дыяпазону для ўбудаванага эквалайзера гуку."
#define GENESIS_PLUS_GX_AUDIO_EQ_MID_LABEL_BE "Настройка сярэдніх частот"
#define GENESIS_PLUS_GX_AUDIO_EQ_MID_INFO_0_BE "Рэгуляванне сярэднечастотнага дыяпазону для ўбудаванага эквалайзера гуку."
#define GENESIS_PLUS_GX_AUDIO_EQ_HIGH_LABEL_BE "Настройка верхніх частот"
#define GENESIS_PLUS_GX_AUDIO_EQ_HIGH_INFO_0_BE "Рэгулёўка верхнечастотнага дыяпазону для ўбудаванага эквалайзера гуку."
#define GENESIS_PLUS_GX_GUN_INPUT_LABEL_BE "Крыніца светлавога пісталета"
#define GENESIS_PLUS_GX_GUN_INPUT_INFO_0_BE "Выкарыстоўваць для светлавога пісталета мыш або ўвод з сэнсарнага экрана."
#define OPTION_VAL_LIGHTGUN_BE "Светлавы пісталет"
#define OPTION_VAL_TOUCHSCREEN_BE "Сэнсарны экран"
#define GENESIS_PLUS_GX_GUN_CURSOR_LABEL_BE "Паказваць прыцэл светлавога пісталета"
#define GENESIS_PLUS_GX_GUN_CURSOR_INFO_0_BE "Адлюстроўваць прыцэл светлавога пісталета для прылад уводу тыпу MD Menacer, MD Justifier і MS Light Phaser."
#define GENESIS_PLUS_GX_INVERT_MOUSE_LABEL_BE "Інверсія мышы па восі Y"
#define GENESIS_PLUS_GX_INVERT_MOUSE_INFO_0_BE "Інвертуе вось Y для прылады ўводу тыпу MD Mouse."
#define GENESIS_PLUS_GX_NO_SPRITE_LIMIT_LABEL_BE "Адключыць ліміт спрайтаў у лініі"
#define GENESIS_PLUS_GX_NO_SPRITE_LIMIT_INFO_0_BE "Прыбірае абмежаванне арыгінальнай кансолі па колькасці спрайтаў на лінію разгорткі. Памяншае мігаценне, але можа выклікаць збоі графікі, то бок у шэрагу гульняў дадзенае апаратнае абмежаванне выкарыстоўваецца для пэўных эфектаў."
#define GENESIS_PLUS_GX_ENHANCED_VSCROLL_LABEL_BE "Палепшаны вертыкальны скролінг тайлаў"
#define GENESIS_PLUS_GX_ENHANCED_VSCROLL_INFO_0_BE "Дазваляе вертыкальны скролінг кожнай асобнай ячэйкі, замест 16 пікселяў па 2 ячэйках, шляхам асераднення значэння vscroll суседняга вочка. Дадзены хак ужываецца толькі для шэрагу гульняў, якія выкарыстоўваюць рэжым вертыкальнага скроллінга па 2 вочках."
#define GENESIS_PLUS_GX_ENHANCED_VSCROLL_LIMIT_LABEL_BE "Палепшаны вертыкальны скролінг тайлаў"
#define GENESIS_PLUS_GX_ENHANCED_VSCROLL_LIMIT_INFO_0_BE "Толькі пры ўключаным \"Палепшаны вертыкальным скролінгу тайлаў\". Рэгулюе мяжу паляпшэння вертыкальнага скралінгу. Калі значэнне vscroll паміж суседнімі тайламі перавышае ўсталяванае абмежаванне, паляпшэнне адключаецца."
#define GENESIS_PLUS_GX_OVERCLOCK_LABEL_BE "Хуткасць ЦП"
#define GENESIS_PLUS_GX_OVERCLOCK_INFO_0_BE "Разгон эмуляванага працэсу. Можа паменшыць запаволенні, але таксама прыводзіць да збояў."
#define OPTION_VAL_100_BE "100 %"
#define OPTION_VAL_125_BE "125 %"
#define OPTION_VAL_150_BE "150 %"
#define OPTION_VAL_175_BE "175 %"
#define OPTION_VAL_200_BE "200 %"
#define OPTION_VAL_225_BE "225 %"
#define OPTION_VAL_250_BE "250 %"
#define OPTION_VAL_275_BE "275 %"
#define OPTION_VAL_300_BE "300 %"
#define OPTION_VAL_325_BE "325 %"
#define OPTION_VAL_350_BE "350 %"
#define OPTION_VAL_375_BE "375 %"
#define OPTION_VAL_400_BE "400 %"
#define OPTION_VAL_425_BE "425 %"
#define OPTION_VAL_450_BE "450 %"
#define OPTION_VAL_475_BE "475 %"
#define OPTION_VAL_500_BE "500 %"
#define GENESIS_PLUS_GX_FORCE_DTACK_LABEL_BE "Падвісанні сістэмы"
#define GENESIS_PLUS_GX_FORCE_DTACK_INFO_0_BE "Эмуляцыя падвісанняў сістэмы на арыгінальнай кансолі пры доступе да недапушчальнага адрасу. Варта выключаць толькі пры запуску некаторых дэма ці homebrew, якія выкарыстоўваюць няправільныя рэжымы для карэктнай працы."
#define GENESIS_PLUS_GX_ADDR_ERROR_LABEL_BE "Памылка адрасавання 68K"
#define GENESIS_PLUS_GX_ADDR_ERROR_INFO_0_BE "Пры спробе невыраўнаванага доступу да памяці цэнтральны працэсар Mega Drive/Genesis (Motorola 68000) генеруе перапыненне (збой) па памылцы адрасавання. Уключэнне опцыі 'Памылка адрасацыі 68K' імітуе дадзеныя паводзіны. Опцыю неабходна адключаць толькі для запуску хакаў, т. я. яны звычайна распрацоўваюцца на меней дакладных эмулятарах і могуць выкарыстоўваць памылкі доступу да памяці для карэктнай працы."
#define GENESIS_PLUS_GX_CD_LATENCY_LABEL_BE "Час доступу да CD"
#define GENESIS_PLUS_GX_CD_LATENCY_INFO_0_BE "Імітацыя затрымкі арыгінальнага абсталявання CD пры чытанні ці пошуку вызначанага месца загружанай кружэлкі. Патрабуецца для некаторых гульняў на CD, якія завісаюць пры занадта хуткім доступе да дадзеных, а таксама ўхіляе рассінхранізацыю CD-аўдыё. Рэкамендуецца адключаць з гульнямі MSU-MD, т. к. забяспечвае больш плыўны паўтор аўдыёдарожак."
#define GENESIS_PLUS_GX_CD_PRECACHE_LABEL_BE "Кэшаваць выяву CD"
#define GENESIS_PLUS_GX_CD_PRECACHE_INFO_0_BE "Пры запуску загружаць выяву CD у памяць. Падтрымліваюцца толькі CHD. Патрабуецца перазапуск."
#define GENESIS_PLUS_GX_SHOW_ADVANCED_AUDIO_SETTINGS_LABEL_BE "Паказваць дадатковыя налады гучнасці (пры паўторным выкліку меню)"
#define GENESIS_PLUS_GX_SHOW_ADVANCED_AUDIO_SETTINGS_INFO_0_BE "Уключае настройку нізкаўзроўневых параметраў гукавых каналаў. Для ўжывання змен патрабуецца перазайсці ў хуткае меню."
#define GENESIS_PLUS_GX_PSG_CHANNEL_0_VOLUME_LABEL_BE "Гучнасць PSG канала тону 0 у %"
#define GENESIS_PLUS_GX_PSG_CHANNEL_0_VOLUME_INFO_0_BE "Зменшыць гучнасць PSG канала тону 0."
#define GENESIS_PLUS_GX_PSG_CHANNEL_1_VOLUME_LABEL_BE "Гучнасць PSG канала тону 1 у %"
#define GENESIS_PLUS_GX_PSG_CHANNEL_1_VOLUME_INFO_0_BE "Зменшыць гучнасць PSG канала тону 1."
#define GENESIS_PLUS_GX_PSG_CHANNEL_2_VOLUME_LABEL_BE "Гучнасць PSG канала тону 2 у %"
#define GENESIS_PLUS_GX_PSG_CHANNEL_2_VOLUME_INFO_0_BE "Зменшыць гучнасць PSG канала тону 2."
#define GENESIS_PLUS_GX_PSG_CHANNEL_3_VOLUME_LABEL_BE "Гучнасць PSG канала шуму 3 у %"
#define GENESIS_PLUS_GX_PSG_CHANNEL_3_VOLUME_INFO_0_BE "Зменшыць гучнасць PSG канала шуму 3."
#define GENESIS_PLUS_GX_MD_CHANNEL_0_VOLUME_LABEL_BE "Гучнасць Mega Drive/Genesis FM канала 0 у %"
#define GENESIS_PLUS_GX_MD_CHANNEL_0_VOLUME_INFO_0_BE "Памяншэнне гучнасці Mega Drive/Genesis FM-канала 0. Працуе толькі з FM-эмуляцыяй MAME."
#define GENESIS_PLUS_GX_MD_CHANNEL_1_VOLUME_LABEL_BE "Гучнасць Mega Drive/Genesis FM канала 1 у %"
#define GENESIS_PLUS_GX_MD_CHANNEL_1_VOLUME_INFO_0_BE "Памяншэнне гучнасці Mega Drive/Genesis FM-канала 1. Працуе толькі з FM-эмуляцыяй MAME."
#define GENESIS_PLUS_GX_MD_CHANNEL_2_VOLUME_LABEL_BE "Гучнасць Mega Drive/Genesis FM канала 2 у %"
#define GENESIS_PLUS_GX_MD_CHANNEL_2_VOLUME_INFO_0_BE "Памяншэнне гучнасці Mega Drive/Genesis FM-канала 2. Працуе толькі з FM-эмуляцыяй MAME."
#define GENESIS_PLUS_GX_MD_CHANNEL_3_VOLUME_LABEL_BE "Гучнасць Mega Drive/Genesis FM канала 3 у %"
#define GENESIS_PLUS_GX_MD_CHANNEL_3_VOLUME_INFO_0_BE "Памяншэнне гучнасці Mega Drive/Genesis FM-канала 3. Працуе толькі з FM-эмуляцыяй MAME."
#define GENESIS_PLUS_GX_MD_CHANNEL_4_VOLUME_LABEL_BE "Гучнасць Mega Drive/Genesis FM канала 4 у %"
#define GENESIS_PLUS_GX_MD_CHANNEL_4_VOLUME_INFO_0_BE "Памяншэнне гучнасці Mega Drive/Genesis FM-канала 4. Працуе толькі з FM-эмуляцыяй MAME."
#define GENESIS_PLUS_GX_MD_CHANNEL_5_VOLUME_LABEL_BE "Гучнасць Mega Drive/Genesis FM канала 5 у %"
#define GENESIS_PLUS_GX_MD_CHANNEL_5_VOLUME_INFO_0_BE "Памяншэнне гучнасці Mega Drive/Genesis FM-канала 5. Працуе толькі з FM-эмуляцыяй MAME."
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_0_VOLUME_LABEL_BE "Гучнасць Master System FM (YM2413) канала 0 у %"
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_0_VOLUME_INFO_0_BE "Зменшыць гучнасць Master System FM канала 0."
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_1_VOLUME_LABEL_BE "Гучнасць Master System FM (YM2413) канала 1 у %"
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_1_VOLUME_INFO_0_BE "Зменшыць гучнасць Master System FM канала 1."
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_2_VOLUME_LABEL_BE "Гучнасць Master System FM (YM2413) канала 2 у %"
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_2_VOLUME_INFO_0_BE "Зменшыць гучнасць Master System FM канала 2."
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_3_VOLUME_LABEL_BE "Гучнасць Master System FM (YM2413) канала 3 у %"
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_3_VOLUME_INFO_0_BE "Зменшыць гучнасць Master System FM канала 3."
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_4_VOLUME_LABEL_BE "Гучнасць Master System FM (YM2413) канала 4 у %"
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_4_VOLUME_INFO_0_BE "Зменшыць гучнасць Master System FM канала 4."
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_5_VOLUME_LABEL_BE "Гучнасць Master System FM (YM2413) канала 5 у %"
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_5_VOLUME_INFO_0_BE "Зменшыць гучнасць Master System FM канала 5."
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_6_VOLUME_LABEL_BE "Гучнасць Master System FM (YM2413) канала 6 у %"
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_6_VOLUME_INFO_0_BE "Зменшыць гучнасць Master System FM канала 6."
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_7_VOLUME_LABEL_BE "Гучнасць Master System FM (YM2413) канала 7 у %"
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_7_VOLUME_INFO_0_BE "Зменшыць гучнасць Master System FM канала 7."
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_8_VOLUME_LABEL_BE "Гучнасць Master System FM (YM2413) канала 8 у %"
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_8_VOLUME_INFO_0_BE "Зменшыць гучнасць Master System FM канала 8."

struct retro_core_option_v2_category option_cats_be[] = {
   {
      "system",
      CATEGORY_SYSTEM_LABEL_BE,
      CATEGORY_SYSTEM_INFO_0_BE
   },
   {
      "video",
      CATEGORY_VIDEO_LABEL_BE,
      CATEGORY_VIDEO_INFO_0_BE
   },
   {
      "audio",
      CATEGORY_AUDIO_LABEL_BE,
      CATEGORY_AUDIO_INFO_0_BE
   },
   {
      "input",
      CATEGORY_INPUT_LABEL_BE,
      CATEGORY_INPUT_INFO_0_BE
   },
   {
      "hacks",
      CATEGORY_HACKS_LABEL_BE,
      CATEGORY_HACKS_INFO_0_BE
   },
   {
      "channel_volume",
      CATEGORY_CHANNEL_VOLUME_LABEL_BE,
      CATEGORY_CHANNEL_VOLUME_INFO_0_BE
   },
   { NULL, NULL, NULL },
};
struct retro_core_option_v2_definition option_defs_be[] = {
   {
      "genesis_plus_gx_system_hw",
      GENESIS_PLUS_GX_SYSTEM_HW_LABEL_BE,
      NULL,
      GENESIS_PLUS_GX_SYSTEM_HW_INFO_0_BE,
      NULL,
      "system",
      {
         { "auto",                 OPTION_VAL_AUTO_BE                 },
         { "sg-1000",              OPTION_VAL_SG_1000_BE              },
         { "sg-1000 II",           OPTION_VAL_SG_1000_II_BE           },
         { "sg-1000 II + ram ext.",OPTION_VAL_SG_1000_II_RAM_EXT_BE},
         { "mark-III",             OPTION_VAL_MARK_III_BE             },
         { "master system",        OPTION_VAL_MASTER_SYSTEM_BE        },
         { "master system II",     OPTION_VAL_MASTER_SYSTEM_II_BE     },
         { "game gear",            OPTION_VAL_GAME_GEAR_BE            },
         { "mega drive / genesis", OPTION_VAL_MEGA_DRIVE_GENESIS_BE   },
         { NULL, NULL },
      },
      "auto"
   },
   {
      "genesis_plus_gx_region_detect",
      GENESIS_PLUS_GX_REGION_DETECT_LABEL_BE,
      NULL,
      GENESIS_PLUS_GX_REGION_DETECT_INFO_0_BE,
      NULL,
      "system",
      {
         { "auto",    OPTION_VAL_AUTO_BE   },
         { "ntsc-u",  OPTION_VAL_NTSC_U_BE },
         { "pal",     OPTION_VAL_PAL_BE    },
         { "ntsc-j",  OPTION_VAL_NTSC_J_BE },
         { NULL, NULL },
      },
      "auto"
   },
   {
      "genesis_plus_gx_vdp_mode",
      GENESIS_PLUS_GX_VDP_MODE_LABEL_BE,
      NULL,
      GENESIS_PLUS_GX_VDP_MODE_INFO_0_BE,
      NULL,
      "system",
      {
         { "auto",  "Disabled" },
         { "60hz",  OPTION_VAL_60HZ_BE },
         { "50hz",  OPTION_VAL_50HZ_BE },
         { NULL, NULL },
      },
      "auto"
   },
   {
      "genesis_plus_gx_bios",
      GENESIS_PLUS_GX_BIOS_LABEL_BE,
      NULL,
      GENESIS_PLUS_GX_BIOS_INFO_0_BE,
      NULL,
      "system",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_system_bram",
      GENESIS_PLUS_GX_SYSTEM_BRAM_LABEL_BE,
      NULL,
      GENESIS_PLUS_GX_SYSTEM_BRAM_INFO_0_BE,
      NULL,
      "system",
      {
         { "per bios", OPTION_VAL_PER_BIOS_BE },
         { "per game", OPTION_VAL_PER_GAME_BE },
         { NULL, NULL },
      },
      "per bios"
   },
   {
      "genesis_plus_gx_cart_bram",
      GENESIS_PLUS_GX_CART_BRAM_LABEL_BE,
      NULL,
      GENESIS_PLUS_GX_CART_BRAM_INFO_0_BE,
      NULL,
      "system",
      {
         { "per cart", OPTION_VAL_PER_CART_BE },
         { "per game", OPTION_VAL_PER_GAME_BE },
         { NULL, NULL },
      },
      "per cart"
   },
   {
      "genesis_plus_gx_cart_size",
      GENESIS_PLUS_GX_CART_SIZE_LABEL_BE,
      NULL,
      GENESIS_PLUS_GX_CART_SIZE_INFO_0_BE,
      NULL,
      "system",
      {
         { "disabled", "Disabled" },
         { "128k",     OPTION_VAL_128K_BE  },
         { "256k",     OPTION_VAL_256K_BE  },
         { "512k",     OPTION_VAL_512K_BE  },
         { "1meg",     OPTION_VAL_1MEG_BE    },
         { "2meg",     OPTION_VAL_2MEG_BE    },
         { "4meg",     OPTION_VAL_4MEG_BE    },
         { NULL, NULL },
      },
      "4meg"
   },
   {
      "genesis_plus_gx_add_on",
      GENESIS_PLUS_GX_ADD_ON_LABEL_BE,
      NULL,
      GENESIS_PLUS_GX_ADD_ON_INFO_0_BE,
      NULL,
      "system",
      {
         { "auto",         OPTION_VAL_AUTO_BE },
         { "sega/mega cd", OPTION_VAL_SEGA_MEGA_CD_BE },
         { "megasd",       OPTION_VAL_MEGASD_BE },
         { "none",         OPTION_VAL_NONE_BE },
         { NULL, NULL },
      },
      "auto"
   },
   {
      "genesis_plus_gx_lock_on",
      GENESIS_PLUS_GX_LOCK_ON_LABEL_BE,
      NULL,
      GENESIS_PLUS_GX_LOCK_ON_INFO_0_BE,
      NULL,
      "system",
      {
         { "disabled",            NULL },
         { "game genie",          OPTION_VAL_GAME_GENIE_BE },
         { "action replay (pro)", OPTION_VAL_ACTION_REPLAY_PRO_BE },
         { "sonic & knuckles",    OPTION_VAL_SONIC_KNUCKLES_BE },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_aspect_ratio",
      GENESIS_PLUS_GX_ASPECT_RATIO_LABEL_BE,
      NULL,
      GENESIS_PLUS_GX_ASPECT_RATIO_INFO_0_BE,
      NULL,
      "video",
      {
         { "auto",     OPTION_VAL_AUTO_BE },
         { "NTSC PAR", OPTION_VAL_NTSC_PAR_BE },
         { "PAL PAR",  OPTION_VAL_PAL_PAR_BE },
         { "4:3",  OPTION_VAL_4_3_BE },
         { "Uncorrected",  OPTION_VAL_UNCORRECTED_BE },
      },
      "auto"
   },
   {
      "genesis_plus_gx_overscan",
      GENESIS_PLUS_GX_OVERSCAN_LABEL_BE,
      NULL,
      GENESIS_PLUS_GX_OVERSCAN_INFO_0_BE,
      NULL,
      "video",
      {
         { "disabled",   NULL },
         { "top/bottom", OPTION_VAL_TOP_BOTTOM_BE },
         { "left/right", OPTION_VAL_LEFT_RIGHT_BE },
         { "full",       OPTION_VAL_FULL_BE },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_left_border",
      GENESIS_PLUS_GX_LEFT_BORDER_LABEL_BE,
      NULL,
      GENESIS_PLUS_GX_LEFT_BORDER_INFO_0_BE,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "left border", OPTION_VAL_LEFT_BORDER_BE },
         { "left & right borders", OPTION_VAL_LEFT_RIGHT_BORDERS_BE },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_gg_extra",
      GENESIS_PLUS_GX_GG_EXTRA_LABEL_BE,
      NULL,
      GENESIS_PLUS_GX_GG_EXTRA_INFO_0_BE,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_blargg_ntsc_filter",
      GENESIS_PLUS_GX_BLARGG_NTSC_FILTER_LABEL_BE,
      NULL,
      GENESIS_PLUS_GX_BLARGG_NTSC_FILTER_INFO_0_BE,
      NULL,
      "video",
      {
         { "disabled",   NULL },
         { "monochrome", OPTION_VAL_MONOCHROME_BE },
         { "composite",  OPTION_VAL_COMPOSITE_BE },
         { "svideo",     OPTION_VAL_SVIDEO_BE },
         { "rgb",        OPTION_VAL_RGB_BE },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_lcd_filter",
      GENESIS_PLUS_GX_LCD_FILTER_LABEL_BE,
      NULL,
      GENESIS_PLUS_GX_LCD_FILTER_INFO_0_BE,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_render",
      GENESIS_PLUS_GX_RENDER_LABEL_BE,
      NULL,
      GENESIS_PLUS_GX_RENDER_INFO_0_BE,
      NULL,
      "video",
      {
         { "single field", OPTION_VAL_SINGLE_FIELD_BE },
         { "double field", OPTION_VAL_DOUBLE_FIELD_BE },
         { NULL, NULL },
      },
      "single field"
   },
   {
      "genesis_plus_gx_frameskip",
      GENESIS_PLUS_GX_FRAMESKIP_LABEL_BE,
      NULL,
      GENESIS_PLUS_GX_FRAMESKIP_INFO_0_BE,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "auto",     OPTION_VAL_AUTO_BE },
         { "manual",   OPTION_VAL_MANUAL_BE },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_frameskip_threshold",
      GENESIS_PLUS_GX_FRAMESKIP_THRESHOLD_LABEL_BE,
      NULL,
      GENESIS_PLUS_GX_FRAMESKIP_THRESHOLD_INFO_0_BE,
      NULL,
      "video",
      {
         { "15", NULL },
         { "18", NULL },
         { "21", NULL },
         { "24", NULL },
         { "27", NULL },
         { "30", NULL },
         { "33", NULL },
         { "36", NULL },
         { "39", NULL },
         { "42", NULL },
         { "45", NULL },
         { "48", NULL },
         { "51", NULL },
         { "54", NULL },
         { "57", NULL },
         { "60", NULL },
         { NULL, NULL },
      },
      "33"
   },
   {
      "genesis_plus_gx_ym2413",
      GENESIS_PLUS_GX_YM2413_LABEL_BE,
      NULL,
      GENESIS_PLUS_GX_YM2413_INFO_0_BE,
      NULL,
      "audio",
      {
         { "auto",     OPTION_VAL_AUTO_BE },
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "auto"
   },
#ifdef HAVE_OPLL_CORE
   {
      "genesis_plus_gx_ym2413_core",
      GENESIS_PLUS_GX_YM2413_CORE_LABEL_BE,
      NULL,
      GENESIS_PLUS_GX_YM2413_CORE_INFO_0_BE,
      NULL,
      "audio",
      {
         { "mame",  OPTION_VAL_MAME_BE },
         { "nuked", OPTION_VAL_NUKED_BE },
         { NULL, NULL },
      },
      "mame"
   },
#endif
   {
      "genesis_plus_gx_ym2612",
      GENESIS_PLUS_GX_YM2612_LABEL_BE,
      NULL,
#ifdef HAVE_YM3438_CORE
      GENESIS_PLUS_GX_YM2612_INFO_0_BE,
#else
      GENESIS_PLUS_GX_YM2612_INFO_1_BE,
#endif
      NULL,
      "audio",
      {
         { "mame (ym2612)",          OPTION_VAL_MAME_YM2612_BE },
         { "mame (asic ym3438)",     OPTION_VAL_MAME_ASIC_YM3438_BE },
         { "mame (enhanced ym3438)", OPTION_VAL_MAME_ENHANCED_YM3438_BE },
#ifdef HAVE_YM3438_CORE
         { "nuked (ym2612)",         OPTION_VAL_NUKED_YM2612_BE },
         { "nuked (ym3438)",         OPTION_VAL_NUKED_YM3438_BE },
#endif
         { NULL, NULL },
      },
      "mame (ym2612)"
   },
   {
      "genesis_plus_gx_sound_output",
      GENESIS_PLUS_GX_SOUND_OUTPUT_LABEL_BE,
      NULL,
      GENESIS_PLUS_GX_SOUND_OUTPUT_INFO_0_BE,
      NULL,
      "audio",
      {
         { "stereo", OPTION_VAL_STEREO_BE },
         { "mono",   OPTION_VAL_MONO_BE },
         { NULL, NULL },
      },
      "stereo"
   },
   {
      "genesis_plus_gx_audio_filter",
      GENESIS_PLUS_GX_AUDIO_FILTER_LABEL_BE,
      NULL,
      GENESIS_PLUS_GX_AUDIO_FILTER_INFO_0_BE,
      NULL,
      "audio",
      {
         { "disabled", NULL },
         { "low-pass", OPTION_VAL_LOW_PASS_BE },
#ifdef HAVE_EQ
         { "EQ",       OPTION_VAL_EQ_BE },
#endif
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_lowpass_range",
      GENESIS_PLUS_GX_LOWPASS_RANGE_LABEL_BE,
      NULL,
      GENESIS_PLUS_GX_LOWPASS_RANGE_INFO_0_BE,
      NULL,
      "audio",
      {
         { "5",  NULL },
         { "10", NULL },
         { "15", NULL },
         { "20", NULL },
         { "25", NULL },
         { "30", NULL },
         { "35", NULL },
         { "40", NULL },
         { "45", NULL },
         { "50", NULL },
         { "55", NULL },
         { "60", NULL },
         { "65", NULL },
         { "70", NULL },
         { "75", NULL },
         { "80", NULL },
         { "85", NULL },
         { "90", NULL },
         { "95", NULL },
         { NULL, NULL },
      },
      "60"
   },
   {
      "genesis_plus_gx_psg_preamp",
      GENESIS_PLUS_GX_PSG_PREAMP_LABEL_BE,
      NULL,
      GENESIS_PLUS_GX_PSG_PREAMP_INFO_0_BE,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { "105", NULL },
         { "110", NULL },
         { "115", NULL },
         { "120", NULL },
         { "125", NULL },
         { "130", NULL },
         { "135", NULL },
         { "140", NULL },
         { "145", NULL },
         { "150", NULL },
         { "155", NULL },
         { "160", NULL },
         { "165", NULL },
         { "170", NULL },
         { "175", NULL },
         { "180", NULL },
         { "185", NULL },
         { "190", NULL },
         { "195", NULL },
         { "200", NULL },
         { NULL, NULL },
      },
      "150"
   },
   {
      "genesis_plus_gx_fm_preamp",
      GENESIS_PLUS_GX_FM_PREAMP_LABEL_BE,
      NULL,
      GENESIS_PLUS_GX_FM_PREAMP_INFO_0_BE,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { "105", NULL },
         { "110", NULL },
         { "115", NULL },
         { "120", NULL },
         { "125", NULL },
         { "130", NULL },
         { "135", NULL },
         { "140", NULL },
         { "145", NULL },
         { "150", NULL },
         { "155", NULL },
         { "160", NULL },
         { "165", NULL },
         { "170", NULL },
         { "175", NULL },
         { "180", NULL },
         { "185", NULL },
         { "190", NULL },
         { "195", NULL },
         { "200", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_cdda_volume",
      GENESIS_PLUS_GX_CDDA_VOLUME_LABEL_BE,
      NULL,
      GENESIS_PLUS_GX_CDDA_VOLUME_INFO_0_BE,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_pcm_volume",
      GENESIS_PLUS_GX_PCM_VOLUME_LABEL_BE,
      NULL,
      GENESIS_PLUS_GX_PCM_VOLUME_INFO_0_BE,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
#ifdef HAVE_EQ
   {
      "genesis_plus_gx_audio_eq_low",
      GENESIS_PLUS_GX_AUDIO_EQ_LOW_LABEL_BE,
      NULL,
      GENESIS_PLUS_GX_AUDIO_EQ_LOW_INFO_0_BE,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_audio_eq_mid",
      GENESIS_PLUS_GX_AUDIO_EQ_MID_LABEL_BE,
      NULL,
      GENESIS_PLUS_GX_AUDIO_EQ_MID_INFO_0_BE,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_audio_eq_high",
      GENESIS_PLUS_GX_AUDIO_EQ_HIGH_LABEL_BE,
      NULL,
      GENESIS_PLUS_GX_AUDIO_EQ_HIGH_INFO_0_BE,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
#endif
   {
      "genesis_plus_gx_gun_input",
      GENESIS_PLUS_GX_GUN_INPUT_LABEL_BE,
      NULL,
      GENESIS_PLUS_GX_GUN_INPUT_INFO_0_BE,
      NULL,
      "input",
      {
         { "lightgun",    OPTION_VAL_LIGHTGUN_BE },
         { "touchscreen", OPTION_VAL_TOUCHSCREEN_BE },
         { NULL, NULL },
      },
      "lightgun"
   },
   {
      "genesis_plus_gx_gun_cursor",
      GENESIS_PLUS_GX_GUN_CURSOR_LABEL_BE,
      NULL,
      GENESIS_PLUS_GX_GUN_CURSOR_INFO_0_BE,
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_invert_mouse",
      GENESIS_PLUS_GX_INVERT_MOUSE_LABEL_BE,
      NULL,
      GENESIS_PLUS_GX_INVERT_MOUSE_INFO_0_BE,
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_no_sprite_limit",
      GENESIS_PLUS_GX_NO_SPRITE_LIMIT_LABEL_BE,
      NULL,
      GENESIS_PLUS_GX_NO_SPRITE_LIMIT_INFO_0_BE,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_enhanced_vscroll",
      GENESIS_PLUS_GX_ENHANCED_VSCROLL_LABEL_BE,
      NULL,
      GENESIS_PLUS_GX_ENHANCED_VSCROLL_INFO_0_BE,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_enhanced_vscroll_limit",
      GENESIS_PLUS_GX_ENHANCED_VSCROLL_LIMIT_LABEL_BE,
      NULL,
      GENESIS_PLUS_GX_ENHANCED_VSCROLL_LIMIT_INFO_0_BE,
      NULL,
      "hacks",
      {
         { "2", NULL },
         { "3",  NULL },
         { "4", NULL },
         { "5",  NULL },
         { "6", NULL },
         { "7",  NULL },
         { "8", NULL },
         { "9",  NULL },
         { "10", NULL },
         { "11",  NULL },
         { "12", NULL },
         { "13",  NULL },
         { "14", NULL },
         { "15",  NULL },
         { "16", NULL },
         { NULL, NULL },
      },
      "8"
   },
#ifdef HAVE_OVERCLOCK
   {
      "genesis_plus_gx_overclock",
      GENESIS_PLUS_GX_OVERCLOCK_LABEL_BE,
      NULL,
      GENESIS_PLUS_GX_OVERCLOCK_INFO_0_BE,
      NULL,
      "hacks",
      {
         { "100", OPTION_VAL_100_BE },
         { "125", OPTION_VAL_125_BE },
         { "150", OPTION_VAL_150_BE },
         { "175", OPTION_VAL_175_BE },
         { "200", OPTION_VAL_200_BE },
         { "225", OPTION_VAL_225_BE },
         { "250", OPTION_VAL_250_BE },
         { "275", OPTION_VAL_275_BE },
         { "300", OPTION_VAL_300_BE },
         { "325", OPTION_VAL_325_BE },
         { "350", OPTION_VAL_350_BE },
         { "375", OPTION_VAL_375_BE },
         { "400", OPTION_VAL_400_BE },
         { "425", OPTION_VAL_425_BE },
         { "450", OPTION_VAL_450_BE },
         { "475", OPTION_VAL_475_BE },
         { "500", OPTION_VAL_500_BE },
         { NULL, NULL },
      },
      "100%"
   },
#endif
   {
      "genesis_plus_gx_force_dtack",
      GENESIS_PLUS_GX_FORCE_DTACK_LABEL_BE,
      NULL,
      GENESIS_PLUS_GX_FORCE_DTACK_INFO_0_BE,
      NULL,
      "hacks",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL },
      },
      "enabled"
   },
   {
      "genesis_plus_gx_addr_error",
      GENESIS_PLUS_GX_ADDR_ERROR_LABEL_BE,
      NULL,
      GENESIS_PLUS_GX_ADDR_ERROR_INFO_0_BE,
      NULL,
      "hacks",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL },
      },
      "enabled"
   },
   {
      "genesis_plus_gx_cd_latency",
      GENESIS_PLUS_GX_CD_LATENCY_LABEL_BE,
      NULL,
      GENESIS_PLUS_GX_CD_LATENCY_INFO_0_BE,
      NULL,
      "hacks",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL },
      },
      "enabled"
   },
   {
      "genesis_plus_gx_cd_precache",
      GENESIS_PLUS_GX_CD_PRECACHE_LABEL_BE,
      NULL,
      GENESIS_PLUS_GX_CD_PRECACHE_INFO_0_BE,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
#ifdef USE_PER_SOUND_CHANNELS_CONFIG
   {
      "genesis_plus_gx_show_advanced_audio_settings",
      GENESIS_PLUS_GX_SHOW_ADVANCED_AUDIO_SETTINGS_LABEL_BE,
      NULL,
      GENESIS_PLUS_GX_SHOW_ADVANCED_AUDIO_SETTINGS_INFO_0_BE,
      NULL,
      "channel_volume",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL},
      },
      "disabled"
   },
   {
      "genesis_plus_gx_psg_channel_0_volume",
      GENESIS_PLUS_GX_PSG_CHANNEL_0_VOLUME_LABEL_BE,
      NULL,
      GENESIS_PLUS_GX_PSG_CHANNEL_0_VOLUME_INFO_0_BE,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_psg_channel_1_volume",
      GENESIS_PLUS_GX_PSG_CHANNEL_1_VOLUME_LABEL_BE,
      NULL,
      GENESIS_PLUS_GX_PSG_CHANNEL_1_VOLUME_INFO_0_BE,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_psg_channel_2_volume",
      GENESIS_PLUS_GX_PSG_CHANNEL_2_VOLUME_LABEL_BE,
      NULL,
      GENESIS_PLUS_GX_PSG_CHANNEL_2_VOLUME_INFO_0_BE,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_psg_channel_3_volume",
      GENESIS_PLUS_GX_PSG_CHANNEL_3_VOLUME_LABEL_BE,
      NULL,
      GENESIS_PLUS_GX_PSG_CHANNEL_3_VOLUME_INFO_0_BE,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_0_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_0_VOLUME_LABEL_BE,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_0_VOLUME_INFO_0_BE,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_1_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_1_VOLUME_LABEL_BE,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_1_VOLUME_INFO_0_BE,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_2_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_2_VOLUME_LABEL_BE,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_2_VOLUME_INFO_0_BE,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_3_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_3_VOLUME_LABEL_BE,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_3_VOLUME_INFO_0_BE,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_4_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_4_VOLUME_LABEL_BE,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_4_VOLUME_INFO_0_BE,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_5_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_5_VOLUME_LABEL_BE,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_5_VOLUME_INFO_0_BE,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_0_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_0_VOLUME_LABEL_BE,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_0_VOLUME_INFO_0_BE,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_1_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_1_VOLUME_LABEL_BE,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_1_VOLUME_INFO_0_BE,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_2_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_2_VOLUME_LABEL_BE,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_2_VOLUME_INFO_0_BE,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_3_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_3_VOLUME_LABEL_BE,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_3_VOLUME_INFO_0_BE,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_4_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_4_VOLUME_LABEL_BE,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_4_VOLUME_INFO_0_BE,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_5_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_5_VOLUME_LABEL_BE,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_5_VOLUME_INFO_0_BE,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_6_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_6_VOLUME_LABEL_BE,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_6_VOLUME_INFO_0_BE,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_7_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_7_VOLUME_LABEL_BE,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_7_VOLUME_INFO_0_BE,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_8_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_8_VOLUME_LABEL_BE,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_8_VOLUME_INFO_0_BE,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
#endif
   { NULL, NULL, NULL, NULL, NULL, NULL, {{0}}, NULL },
};
struct retro_core_options_v2 options_be = {
   option_cats_be,
   option_defs_be
};

/* RETRO_LANGUAGE_BG */

#define CATEGORY_SYSTEM_LABEL_BG NULL
#define CATEGORY_SYSTEM_INFO_0_BG NULL
#define CATEGORY_VIDEO_LABEL_BG "Видео"
#define CATEGORY_VIDEO_INFO_0_BG NULL
#define CATEGORY_AUDIO_LABEL_BG "Звук"
#define CATEGORY_AUDIO_INFO_0_BG NULL
#define CATEGORY_INPUT_LABEL_BG "Вход"
#define CATEGORY_INPUT_INFO_0_BG NULL
#define CATEGORY_HACKS_LABEL_BG NULL
#define CATEGORY_HACKS_INFO_0_BG NULL
#define CATEGORY_CHANNEL_VOLUME_LABEL_BG NULL
#define CATEGORY_CHANNEL_VOLUME_INFO_0_BG NULL
#define GENESIS_PLUS_GX_SYSTEM_HW_LABEL_BG NULL
#define GENESIS_PLUS_GX_SYSTEM_HW_INFO_0_BG NULL
#define OPTION_VAL_AUTO_BG NULL
#define OPTION_VAL_SG_1000_BG NULL
#define OPTION_VAL_SG_1000_II_BG NULL
#define OPTION_VAL_SG_1000_II_RAM_EXT_BG NULL
#define OPTION_VAL_MARK_III_BG NULL
#define OPTION_VAL_MASTER_SYSTEM_BG NULL
#define OPTION_VAL_MASTER_SYSTEM_II_BG NULL
#define OPTION_VAL_GAME_GEAR_BG NULL
#define OPTION_VAL_MEGA_DRIVE_GENESIS_BG NULL
#define GENESIS_PLUS_GX_REGION_DETECT_LABEL_BG NULL
#define GENESIS_PLUS_GX_REGION_DETECT_INFO_0_BG NULL
#define OPTION_VAL_NTSC_U_BG NULL
#define OPTION_VAL_PAL_BG NULL
#define OPTION_VAL_NTSC_J_BG NULL
#define GENESIS_PLUS_GX_VDP_MODE_LABEL_BG NULL
#define GENESIS_PLUS_GX_VDP_MODE_INFO_0_BG NULL
#define OPTION_VAL_60HZ_BG NULL
#define OPTION_VAL_50HZ_BG NULL
#define GENESIS_PLUS_GX_BIOS_LABEL_BG NULL
#define GENESIS_PLUS_GX_BIOS_INFO_0_BG NULL
#define GENESIS_PLUS_GX_SYSTEM_BRAM_LABEL_BG NULL
#define GENESIS_PLUS_GX_SYSTEM_BRAM_INFO_0_BG NULL
#define OPTION_VAL_PER_BIOS_BG NULL
#define OPTION_VAL_PER_GAME_BG NULL
#define GENESIS_PLUS_GX_CART_BRAM_LABEL_BG NULL
#define GENESIS_PLUS_GX_CART_BRAM_INFO_0_BG NULL
#define OPTION_VAL_PER_CART_BG NULL
#define GENESIS_PLUS_GX_CART_SIZE_LABEL_BG NULL
#define GENESIS_PLUS_GX_CART_SIZE_INFO_0_BG NULL
#define OPTION_VAL_128K_BG NULL
#define OPTION_VAL_256K_BG NULL
#define OPTION_VAL_512K_BG NULL
#define OPTION_VAL_1MEG_BG NULL
#define OPTION_VAL_2MEG_BG NULL
#define OPTION_VAL_4MEG_BG NULL
#define GENESIS_PLUS_GX_ADD_ON_LABEL_BG NULL
#define GENESIS_PLUS_GX_ADD_ON_INFO_0_BG NULL
#define OPTION_VAL_SEGA_MEGA_CD_BG NULL
#define OPTION_VAL_MEGASD_BG NULL
#define OPTION_VAL_NONE_BG NULL
#define GENESIS_PLUS_GX_LOCK_ON_LABEL_BG NULL
#define GENESIS_PLUS_GX_LOCK_ON_INFO_0_BG NULL
#define OPTION_VAL_GAME_GENIE_BG NULL
#define OPTION_VAL_ACTION_REPLAY_PRO_BG NULL
#define OPTION_VAL_SONIC_KNUCKLES_BG NULL
#define GENESIS_PLUS_GX_ASPECT_RATIO_LABEL_BG NULL
#define GENESIS_PLUS_GX_ASPECT_RATIO_INFO_0_BG NULL
#define OPTION_VAL_NTSC_PAR_BG NULL
#define OPTION_VAL_PAL_PAR_BG NULL
#define OPTION_VAL_4_3_BG NULL
#define OPTION_VAL_UNCORRECTED_BG NULL
#define GENESIS_PLUS_GX_OVERSCAN_LABEL_BG NULL
#define GENESIS_PLUS_GX_OVERSCAN_INFO_0_BG NULL
#define OPTION_VAL_TOP_BOTTOM_BG NULL
#define OPTION_VAL_LEFT_RIGHT_BG NULL
#define OPTION_VAL_FULL_BG NULL
#define GENESIS_PLUS_GX_LEFT_BORDER_LABEL_BG NULL
#define GENESIS_PLUS_GX_LEFT_BORDER_INFO_0_BG NULL
#define OPTION_VAL_LEFT_BORDER_BG NULL
#define OPTION_VAL_LEFT_RIGHT_BORDERS_BG NULL
#define GENESIS_PLUS_GX_GG_EXTRA_LABEL_BG NULL
#define GENESIS_PLUS_GX_GG_EXTRA_INFO_0_BG NULL
#define GENESIS_PLUS_GX_BLARGG_NTSC_FILTER_LABEL_BG NULL
#define GENESIS_PLUS_GX_BLARGG_NTSC_FILTER_INFO_0_BG NULL
#define OPTION_VAL_MONOCHROME_BG NULL
#define OPTION_VAL_COMPOSITE_BG NULL
#define OPTION_VAL_SVIDEO_BG NULL
#define OPTION_VAL_RGB_BG NULL
#define GENESIS_PLUS_GX_LCD_FILTER_LABEL_BG NULL
#define GENESIS_PLUS_GX_LCD_FILTER_INFO_0_BG NULL
#define GENESIS_PLUS_GX_RENDER_LABEL_BG NULL
#define GENESIS_PLUS_GX_RENDER_INFO_0_BG NULL
#define OPTION_VAL_SINGLE_FIELD_BG NULL
#define OPTION_VAL_DOUBLE_FIELD_BG NULL
#define GENESIS_PLUS_GX_FRAMESKIP_LABEL_BG NULL
#define GENESIS_PLUS_GX_FRAMESKIP_INFO_0_BG NULL
#define OPTION_VAL_MANUAL_BG NULL
#define GENESIS_PLUS_GX_FRAMESKIP_THRESHOLD_LABEL_BG NULL
#define GENESIS_PLUS_GX_FRAMESKIP_THRESHOLD_INFO_0_BG NULL
#define GENESIS_PLUS_GX_YM2413_LABEL_BG NULL
#define GENESIS_PLUS_GX_YM2413_INFO_0_BG NULL
#define GENESIS_PLUS_GX_YM2413_CORE_LABEL_BG NULL
#define GENESIS_PLUS_GX_YM2413_CORE_INFO_0_BG NULL
#define OPTION_VAL_MAME_BG NULL
#define OPTION_VAL_NUKED_BG NULL
#define GENESIS_PLUS_GX_YM2612_LABEL_BG NULL
#define GENESIS_PLUS_GX_YM2612_INFO_0_BG NULL
#define GENESIS_PLUS_GX_YM2612_INFO_1_BG NULL
#define OPTION_VAL_MAME_YM2612_BG NULL
#define OPTION_VAL_MAME_ASIC_YM3438_BG NULL
#define OPTION_VAL_MAME_ENHANCED_YM3438_BG NULL
#define OPTION_VAL_NUKED_YM2612_BG NULL
#define OPTION_VAL_NUKED_YM3438_BG NULL
#define GENESIS_PLUS_GX_SOUND_OUTPUT_LABEL_BG NULL
#define GENESIS_PLUS_GX_SOUND_OUTPUT_INFO_0_BG NULL
#define OPTION_VAL_STEREO_BG NULL
#define OPTION_VAL_MONO_BG NULL
#define GENESIS_PLUS_GX_AUDIO_FILTER_LABEL_BG NULL
#define GENESIS_PLUS_GX_AUDIO_FILTER_INFO_0_BG NULL
#define OPTION_VAL_LOW_PASS_BG NULL
#define OPTION_VAL_EQ_BG NULL
#define GENESIS_PLUS_GX_LOWPASS_RANGE_LABEL_BG NULL
#define GENESIS_PLUS_GX_LOWPASS_RANGE_INFO_0_BG NULL
#define GENESIS_PLUS_GX_PSG_PREAMP_LABEL_BG NULL
#define GENESIS_PLUS_GX_PSG_PREAMP_INFO_0_BG NULL
#define GENESIS_PLUS_GX_FM_PREAMP_LABEL_BG NULL
#define GENESIS_PLUS_GX_FM_PREAMP_INFO_0_BG NULL
#define GENESIS_PLUS_GX_CDDA_VOLUME_LABEL_BG NULL
#define GENESIS_PLUS_GX_CDDA_VOLUME_INFO_0_BG NULL
#define GENESIS_PLUS_GX_PCM_VOLUME_LABEL_BG NULL
#define GENESIS_PLUS_GX_PCM_VOLUME_INFO_0_BG NULL
#define GENESIS_PLUS_GX_AUDIO_EQ_LOW_LABEL_BG NULL
#define GENESIS_PLUS_GX_AUDIO_EQ_LOW_INFO_0_BG NULL
#define GENESIS_PLUS_GX_AUDIO_EQ_MID_LABEL_BG NULL
#define GENESIS_PLUS_GX_AUDIO_EQ_MID_INFO_0_BG NULL
#define GENESIS_PLUS_GX_AUDIO_EQ_HIGH_LABEL_BG NULL
#define GENESIS_PLUS_GX_AUDIO_EQ_HIGH_INFO_0_BG NULL
#define GENESIS_PLUS_GX_GUN_INPUT_LABEL_BG NULL
#define GENESIS_PLUS_GX_GUN_INPUT_INFO_0_BG NULL
#define OPTION_VAL_LIGHTGUN_BG NULL
#define OPTION_VAL_TOUCHSCREEN_BG NULL
#define GENESIS_PLUS_GX_GUN_CURSOR_LABEL_BG NULL
#define GENESIS_PLUS_GX_GUN_CURSOR_INFO_0_BG NULL
#define GENESIS_PLUS_GX_INVERT_MOUSE_LABEL_BG NULL
#define GENESIS_PLUS_GX_INVERT_MOUSE_INFO_0_BG NULL
#define GENESIS_PLUS_GX_NO_SPRITE_LIMIT_LABEL_BG NULL
#define GENESIS_PLUS_GX_NO_SPRITE_LIMIT_INFO_0_BG NULL
#define GENESIS_PLUS_GX_ENHANCED_VSCROLL_LABEL_BG NULL
#define GENESIS_PLUS_GX_ENHANCED_VSCROLL_INFO_0_BG NULL
#define GENESIS_PLUS_GX_ENHANCED_VSCROLL_LIMIT_LABEL_BG NULL
#define GENESIS_PLUS_GX_ENHANCED_VSCROLL_LIMIT_INFO_0_BG NULL
#define GENESIS_PLUS_GX_OVERCLOCK_LABEL_BG NULL
#define GENESIS_PLUS_GX_OVERCLOCK_INFO_0_BG NULL
#define OPTION_VAL_100_BG NULL
#define OPTION_VAL_125_BG NULL
#define OPTION_VAL_150_BG NULL
#define OPTION_VAL_175_BG NULL
#define OPTION_VAL_200_BG NULL
#define OPTION_VAL_225_BG NULL
#define OPTION_VAL_250_BG NULL
#define OPTION_VAL_275_BG NULL
#define OPTION_VAL_300_BG NULL
#define OPTION_VAL_325_BG NULL
#define OPTION_VAL_350_BG NULL
#define OPTION_VAL_375_BG NULL
#define OPTION_VAL_400_BG NULL
#define OPTION_VAL_425_BG NULL
#define OPTION_VAL_450_BG NULL
#define OPTION_VAL_475_BG NULL
#define OPTION_VAL_500_BG NULL
#define GENESIS_PLUS_GX_FORCE_DTACK_LABEL_BG NULL
#define GENESIS_PLUS_GX_FORCE_DTACK_INFO_0_BG NULL
#define GENESIS_PLUS_GX_ADDR_ERROR_LABEL_BG NULL
#define GENESIS_PLUS_GX_ADDR_ERROR_INFO_0_BG NULL
#define GENESIS_PLUS_GX_CD_LATENCY_LABEL_BG NULL
#define GENESIS_PLUS_GX_CD_LATENCY_INFO_0_BG NULL
#define GENESIS_PLUS_GX_CD_PRECACHE_LABEL_BG NULL
#define GENESIS_PLUS_GX_CD_PRECACHE_INFO_0_BG NULL
#define GENESIS_PLUS_GX_SHOW_ADVANCED_AUDIO_SETTINGS_LABEL_BG NULL
#define GENESIS_PLUS_GX_SHOW_ADVANCED_AUDIO_SETTINGS_INFO_0_BG NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_0_VOLUME_LABEL_BG NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_0_VOLUME_INFO_0_BG NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_1_VOLUME_LABEL_BG NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_1_VOLUME_INFO_0_BG NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_2_VOLUME_LABEL_BG NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_2_VOLUME_INFO_0_BG NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_3_VOLUME_LABEL_BG NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_3_VOLUME_INFO_0_BG NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_0_VOLUME_LABEL_BG NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_0_VOLUME_INFO_0_BG NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_1_VOLUME_LABEL_BG NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_1_VOLUME_INFO_0_BG NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_2_VOLUME_LABEL_BG NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_2_VOLUME_INFO_0_BG NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_3_VOLUME_LABEL_BG NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_3_VOLUME_INFO_0_BG NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_4_VOLUME_LABEL_BG NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_4_VOLUME_INFO_0_BG NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_5_VOLUME_LABEL_BG NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_5_VOLUME_INFO_0_BG NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_0_VOLUME_LABEL_BG NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_0_VOLUME_INFO_0_BG NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_1_VOLUME_LABEL_BG NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_1_VOLUME_INFO_0_BG NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_2_VOLUME_LABEL_BG NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_2_VOLUME_INFO_0_BG NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_3_VOLUME_LABEL_BG NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_3_VOLUME_INFO_0_BG NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_4_VOLUME_LABEL_BG NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_4_VOLUME_INFO_0_BG NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_5_VOLUME_LABEL_BG NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_5_VOLUME_INFO_0_BG NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_6_VOLUME_LABEL_BG NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_6_VOLUME_INFO_0_BG NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_7_VOLUME_LABEL_BG NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_7_VOLUME_INFO_0_BG NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_8_VOLUME_LABEL_BG NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_8_VOLUME_INFO_0_BG NULL

struct retro_core_option_v2_category option_cats_bg[] = {
   {
      "system",
      CATEGORY_SYSTEM_LABEL_BG,
      CATEGORY_SYSTEM_INFO_0_BG
   },
   {
      "video",
      CATEGORY_VIDEO_LABEL_BG,
      CATEGORY_VIDEO_INFO_0_BG
   },
   {
      "audio",
      CATEGORY_AUDIO_LABEL_BG,
      CATEGORY_AUDIO_INFO_0_BG
   },
   {
      "input",
      CATEGORY_INPUT_LABEL_BG,
      CATEGORY_INPUT_INFO_0_BG
   },
   {
      "hacks",
      CATEGORY_HACKS_LABEL_BG,
      CATEGORY_HACKS_INFO_0_BG
   },
   {
      "channel_volume",
      CATEGORY_CHANNEL_VOLUME_LABEL_BG,
      CATEGORY_CHANNEL_VOLUME_INFO_0_BG
   },
   { NULL, NULL, NULL },
};
struct retro_core_option_v2_definition option_defs_bg[] = {
   {
      "genesis_plus_gx_system_hw",
      GENESIS_PLUS_GX_SYSTEM_HW_LABEL_BG,
      NULL,
      GENESIS_PLUS_GX_SYSTEM_HW_INFO_0_BG,
      NULL,
      "system",
      {
         { "auto",                 OPTION_VAL_AUTO_BG                 },
         { "sg-1000",              OPTION_VAL_SG_1000_BG              },
         { "sg-1000 II",           OPTION_VAL_SG_1000_II_BG           },
         { "sg-1000 II + ram ext.",OPTION_VAL_SG_1000_II_RAM_EXT_BG},
         { "mark-III",             OPTION_VAL_MARK_III_BG             },
         { "master system",        OPTION_VAL_MASTER_SYSTEM_BG        },
         { "master system II",     OPTION_VAL_MASTER_SYSTEM_II_BG     },
         { "game gear",            OPTION_VAL_GAME_GEAR_BG            },
         { "mega drive / genesis", OPTION_VAL_MEGA_DRIVE_GENESIS_BG   },
         { NULL, NULL },
      },
      "auto"
   },
   {
      "genesis_plus_gx_region_detect",
      GENESIS_PLUS_GX_REGION_DETECT_LABEL_BG,
      NULL,
      GENESIS_PLUS_GX_REGION_DETECT_INFO_0_BG,
      NULL,
      "system",
      {
         { "auto",    OPTION_VAL_AUTO_BG   },
         { "ntsc-u",  OPTION_VAL_NTSC_U_BG },
         { "pal",     OPTION_VAL_PAL_BG    },
         { "ntsc-j",  OPTION_VAL_NTSC_J_BG },
         { NULL, NULL },
      },
      "auto"
   },
   {
      "genesis_plus_gx_vdp_mode",
      GENESIS_PLUS_GX_VDP_MODE_LABEL_BG,
      NULL,
      GENESIS_PLUS_GX_VDP_MODE_INFO_0_BG,
      NULL,
      "system",
      {
         { "auto",  "Disabled" },
         { "60hz",  OPTION_VAL_60HZ_BG },
         { "50hz",  OPTION_VAL_50HZ_BG },
         { NULL, NULL },
      },
      "auto"
   },
   {
      "genesis_plus_gx_bios",
      GENESIS_PLUS_GX_BIOS_LABEL_BG,
      NULL,
      GENESIS_PLUS_GX_BIOS_INFO_0_BG,
      NULL,
      "system",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_system_bram",
      GENESIS_PLUS_GX_SYSTEM_BRAM_LABEL_BG,
      NULL,
      GENESIS_PLUS_GX_SYSTEM_BRAM_INFO_0_BG,
      NULL,
      "system",
      {
         { "per bios", OPTION_VAL_PER_BIOS_BG },
         { "per game", OPTION_VAL_PER_GAME_BG },
         { NULL, NULL },
      },
      "per bios"
   },
   {
      "genesis_plus_gx_cart_bram",
      GENESIS_PLUS_GX_CART_BRAM_LABEL_BG,
      NULL,
      GENESIS_PLUS_GX_CART_BRAM_INFO_0_BG,
      NULL,
      "system",
      {
         { "per cart", OPTION_VAL_PER_CART_BG },
         { "per game", OPTION_VAL_PER_GAME_BG },
         { NULL, NULL },
      },
      "per cart"
   },
   {
      "genesis_plus_gx_cart_size",
      GENESIS_PLUS_GX_CART_SIZE_LABEL_BG,
      NULL,
      GENESIS_PLUS_GX_CART_SIZE_INFO_0_BG,
      NULL,
      "system",
      {
         { "disabled", "Disabled" },
         { "128k",     OPTION_VAL_128K_BG  },
         { "256k",     OPTION_VAL_256K_BG  },
         { "512k",     OPTION_VAL_512K_BG  },
         { "1meg",     OPTION_VAL_1MEG_BG    },
         { "2meg",     OPTION_VAL_2MEG_BG    },
         { "4meg",     OPTION_VAL_4MEG_BG    },
         { NULL, NULL },
      },
      "4meg"
   },
   {
      "genesis_plus_gx_add_on",
      GENESIS_PLUS_GX_ADD_ON_LABEL_BG,
      NULL,
      GENESIS_PLUS_GX_ADD_ON_INFO_0_BG,
      NULL,
      "system",
      {
         { "auto",         OPTION_VAL_AUTO_BG },
         { "sega/mega cd", OPTION_VAL_SEGA_MEGA_CD_BG },
         { "megasd",       OPTION_VAL_MEGASD_BG },
         { "none",         OPTION_VAL_NONE_BG },
         { NULL, NULL },
      },
      "auto"
   },
   {
      "genesis_plus_gx_lock_on",
      GENESIS_PLUS_GX_LOCK_ON_LABEL_BG,
      NULL,
      GENESIS_PLUS_GX_LOCK_ON_INFO_0_BG,
      NULL,
      "system",
      {
         { "disabled",            NULL },
         { "game genie",          OPTION_VAL_GAME_GENIE_BG },
         { "action replay (pro)", OPTION_VAL_ACTION_REPLAY_PRO_BG },
         { "sonic & knuckles",    OPTION_VAL_SONIC_KNUCKLES_BG },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_aspect_ratio",
      GENESIS_PLUS_GX_ASPECT_RATIO_LABEL_BG,
      NULL,
      GENESIS_PLUS_GX_ASPECT_RATIO_INFO_0_BG,
      NULL,
      "video",
      {
         { "auto",     OPTION_VAL_AUTO_BG },
         { "NTSC PAR", OPTION_VAL_NTSC_PAR_BG },
         { "PAL PAR",  OPTION_VAL_PAL_PAR_BG },
         { "4:3",  OPTION_VAL_4_3_BG },
         { "Uncorrected",  OPTION_VAL_UNCORRECTED_BG },
      },
      "auto"
   },
   {
      "genesis_plus_gx_overscan",
      GENESIS_PLUS_GX_OVERSCAN_LABEL_BG,
      NULL,
      GENESIS_PLUS_GX_OVERSCAN_INFO_0_BG,
      NULL,
      "video",
      {
         { "disabled",   NULL },
         { "top/bottom", OPTION_VAL_TOP_BOTTOM_BG },
         { "left/right", OPTION_VAL_LEFT_RIGHT_BG },
         { "full",       OPTION_VAL_FULL_BG },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_left_border",
      GENESIS_PLUS_GX_LEFT_BORDER_LABEL_BG,
      NULL,
      GENESIS_PLUS_GX_LEFT_BORDER_INFO_0_BG,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "left border", OPTION_VAL_LEFT_BORDER_BG },
         { "left & right borders", OPTION_VAL_LEFT_RIGHT_BORDERS_BG },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_gg_extra",
      GENESIS_PLUS_GX_GG_EXTRA_LABEL_BG,
      NULL,
      GENESIS_PLUS_GX_GG_EXTRA_INFO_0_BG,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_blargg_ntsc_filter",
      GENESIS_PLUS_GX_BLARGG_NTSC_FILTER_LABEL_BG,
      NULL,
      GENESIS_PLUS_GX_BLARGG_NTSC_FILTER_INFO_0_BG,
      NULL,
      "video",
      {
         { "disabled",   NULL },
         { "monochrome", OPTION_VAL_MONOCHROME_BG },
         { "composite",  OPTION_VAL_COMPOSITE_BG },
         { "svideo",     OPTION_VAL_SVIDEO_BG },
         { "rgb",        OPTION_VAL_RGB_BG },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_lcd_filter",
      GENESIS_PLUS_GX_LCD_FILTER_LABEL_BG,
      NULL,
      GENESIS_PLUS_GX_LCD_FILTER_INFO_0_BG,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_render",
      GENESIS_PLUS_GX_RENDER_LABEL_BG,
      NULL,
      GENESIS_PLUS_GX_RENDER_INFO_0_BG,
      NULL,
      "video",
      {
         { "single field", OPTION_VAL_SINGLE_FIELD_BG },
         { "double field", OPTION_VAL_DOUBLE_FIELD_BG },
         { NULL, NULL },
      },
      "single field"
   },
   {
      "genesis_plus_gx_frameskip",
      GENESIS_PLUS_GX_FRAMESKIP_LABEL_BG,
      NULL,
      GENESIS_PLUS_GX_FRAMESKIP_INFO_0_BG,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "auto",     OPTION_VAL_AUTO_BG },
         { "manual",   OPTION_VAL_MANUAL_BG },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_frameskip_threshold",
      GENESIS_PLUS_GX_FRAMESKIP_THRESHOLD_LABEL_BG,
      NULL,
      GENESIS_PLUS_GX_FRAMESKIP_THRESHOLD_INFO_0_BG,
      NULL,
      "video",
      {
         { "15", NULL },
         { "18", NULL },
         { "21", NULL },
         { "24", NULL },
         { "27", NULL },
         { "30", NULL },
         { "33", NULL },
         { "36", NULL },
         { "39", NULL },
         { "42", NULL },
         { "45", NULL },
         { "48", NULL },
         { "51", NULL },
         { "54", NULL },
         { "57", NULL },
         { "60", NULL },
         { NULL, NULL },
      },
      "33"
   },
   {
      "genesis_plus_gx_ym2413",
      GENESIS_PLUS_GX_YM2413_LABEL_BG,
      NULL,
      GENESIS_PLUS_GX_YM2413_INFO_0_BG,
      NULL,
      "audio",
      {
         { "auto",     OPTION_VAL_AUTO_BG },
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "auto"
   },
#ifdef HAVE_OPLL_CORE
   {
      "genesis_plus_gx_ym2413_core",
      GENESIS_PLUS_GX_YM2413_CORE_LABEL_BG,
      NULL,
      GENESIS_PLUS_GX_YM2413_CORE_INFO_0_BG,
      NULL,
      "audio",
      {
         { "mame",  OPTION_VAL_MAME_BG },
         { "nuked", OPTION_VAL_NUKED_BG },
         { NULL, NULL },
      },
      "mame"
   },
#endif
   {
      "genesis_plus_gx_ym2612",
      GENESIS_PLUS_GX_YM2612_LABEL_BG,
      NULL,
#ifdef HAVE_YM3438_CORE
      GENESIS_PLUS_GX_YM2612_INFO_0_BG,
#else
      GENESIS_PLUS_GX_YM2612_INFO_1_BG,
#endif
      NULL,
      "audio",
      {
         { "mame (ym2612)",          OPTION_VAL_MAME_YM2612_BG },
         { "mame (asic ym3438)",     OPTION_VAL_MAME_ASIC_YM3438_BG },
         { "mame (enhanced ym3438)", OPTION_VAL_MAME_ENHANCED_YM3438_BG },
#ifdef HAVE_YM3438_CORE
         { "nuked (ym2612)",         OPTION_VAL_NUKED_YM2612_BG },
         { "nuked (ym3438)",         OPTION_VAL_NUKED_YM3438_BG },
#endif
         { NULL, NULL },
      },
      "mame (ym2612)"
   },
   {
      "genesis_plus_gx_sound_output",
      GENESIS_PLUS_GX_SOUND_OUTPUT_LABEL_BG,
      NULL,
      GENESIS_PLUS_GX_SOUND_OUTPUT_INFO_0_BG,
      NULL,
      "audio",
      {
         { "stereo", OPTION_VAL_STEREO_BG },
         { "mono",   OPTION_VAL_MONO_BG },
         { NULL, NULL },
      },
      "stereo"
   },
   {
      "genesis_plus_gx_audio_filter",
      GENESIS_PLUS_GX_AUDIO_FILTER_LABEL_BG,
      NULL,
      GENESIS_PLUS_GX_AUDIO_FILTER_INFO_0_BG,
      NULL,
      "audio",
      {
         { "disabled", NULL },
         { "low-pass", OPTION_VAL_LOW_PASS_BG },
#ifdef HAVE_EQ
         { "EQ",       OPTION_VAL_EQ_BG },
#endif
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_lowpass_range",
      GENESIS_PLUS_GX_LOWPASS_RANGE_LABEL_BG,
      NULL,
      GENESIS_PLUS_GX_LOWPASS_RANGE_INFO_0_BG,
      NULL,
      "audio",
      {
         { "5",  NULL },
         { "10", NULL },
         { "15", NULL },
         { "20", NULL },
         { "25", NULL },
         { "30", NULL },
         { "35", NULL },
         { "40", NULL },
         { "45", NULL },
         { "50", NULL },
         { "55", NULL },
         { "60", NULL },
         { "65", NULL },
         { "70", NULL },
         { "75", NULL },
         { "80", NULL },
         { "85", NULL },
         { "90", NULL },
         { "95", NULL },
         { NULL, NULL },
      },
      "60"
   },
   {
      "genesis_plus_gx_psg_preamp",
      GENESIS_PLUS_GX_PSG_PREAMP_LABEL_BG,
      NULL,
      GENESIS_PLUS_GX_PSG_PREAMP_INFO_0_BG,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { "105", NULL },
         { "110", NULL },
         { "115", NULL },
         { "120", NULL },
         { "125", NULL },
         { "130", NULL },
         { "135", NULL },
         { "140", NULL },
         { "145", NULL },
         { "150", NULL },
         { "155", NULL },
         { "160", NULL },
         { "165", NULL },
         { "170", NULL },
         { "175", NULL },
         { "180", NULL },
         { "185", NULL },
         { "190", NULL },
         { "195", NULL },
         { "200", NULL },
         { NULL, NULL },
      },
      "150"
   },
   {
      "genesis_plus_gx_fm_preamp",
      GENESIS_PLUS_GX_FM_PREAMP_LABEL_BG,
      NULL,
      GENESIS_PLUS_GX_FM_PREAMP_INFO_0_BG,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { "105", NULL },
         { "110", NULL },
         { "115", NULL },
         { "120", NULL },
         { "125", NULL },
         { "130", NULL },
         { "135", NULL },
         { "140", NULL },
         { "145", NULL },
         { "150", NULL },
         { "155", NULL },
         { "160", NULL },
         { "165", NULL },
         { "170", NULL },
         { "175", NULL },
         { "180", NULL },
         { "185", NULL },
         { "190", NULL },
         { "195", NULL },
         { "200", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_cdda_volume",
      GENESIS_PLUS_GX_CDDA_VOLUME_LABEL_BG,
      NULL,
      GENESIS_PLUS_GX_CDDA_VOLUME_INFO_0_BG,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_pcm_volume",
      GENESIS_PLUS_GX_PCM_VOLUME_LABEL_BG,
      NULL,
      GENESIS_PLUS_GX_PCM_VOLUME_INFO_0_BG,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
#ifdef HAVE_EQ
   {
      "genesis_plus_gx_audio_eq_low",
      GENESIS_PLUS_GX_AUDIO_EQ_LOW_LABEL_BG,
      NULL,
      GENESIS_PLUS_GX_AUDIO_EQ_LOW_INFO_0_BG,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_audio_eq_mid",
      GENESIS_PLUS_GX_AUDIO_EQ_MID_LABEL_BG,
      NULL,
      GENESIS_PLUS_GX_AUDIO_EQ_MID_INFO_0_BG,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_audio_eq_high",
      GENESIS_PLUS_GX_AUDIO_EQ_HIGH_LABEL_BG,
      NULL,
      GENESIS_PLUS_GX_AUDIO_EQ_HIGH_INFO_0_BG,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
#endif
   {
      "genesis_plus_gx_gun_input",
      GENESIS_PLUS_GX_GUN_INPUT_LABEL_BG,
      NULL,
      GENESIS_PLUS_GX_GUN_INPUT_INFO_0_BG,
      NULL,
      "input",
      {
         { "lightgun",    OPTION_VAL_LIGHTGUN_BG },
         { "touchscreen", OPTION_VAL_TOUCHSCREEN_BG },
         { NULL, NULL },
      },
      "lightgun"
   },
   {
      "genesis_plus_gx_gun_cursor",
      GENESIS_PLUS_GX_GUN_CURSOR_LABEL_BG,
      NULL,
      GENESIS_PLUS_GX_GUN_CURSOR_INFO_0_BG,
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_invert_mouse",
      GENESIS_PLUS_GX_INVERT_MOUSE_LABEL_BG,
      NULL,
      GENESIS_PLUS_GX_INVERT_MOUSE_INFO_0_BG,
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_no_sprite_limit",
      GENESIS_PLUS_GX_NO_SPRITE_LIMIT_LABEL_BG,
      NULL,
      GENESIS_PLUS_GX_NO_SPRITE_LIMIT_INFO_0_BG,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_enhanced_vscroll",
      GENESIS_PLUS_GX_ENHANCED_VSCROLL_LABEL_BG,
      NULL,
      GENESIS_PLUS_GX_ENHANCED_VSCROLL_INFO_0_BG,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_enhanced_vscroll_limit",
      GENESIS_PLUS_GX_ENHANCED_VSCROLL_LIMIT_LABEL_BG,
      NULL,
      GENESIS_PLUS_GX_ENHANCED_VSCROLL_LIMIT_INFO_0_BG,
      NULL,
      "hacks",
      {
         { "2", NULL },
         { "3",  NULL },
         { "4", NULL },
         { "5",  NULL },
         { "6", NULL },
         { "7",  NULL },
         { "8", NULL },
         { "9",  NULL },
         { "10", NULL },
         { "11",  NULL },
         { "12", NULL },
         { "13",  NULL },
         { "14", NULL },
         { "15",  NULL },
         { "16", NULL },
         { NULL, NULL },
      },
      "8"
   },
#ifdef HAVE_OVERCLOCK
   {
      "genesis_plus_gx_overclock",
      GENESIS_PLUS_GX_OVERCLOCK_LABEL_BG,
      NULL,
      GENESIS_PLUS_GX_OVERCLOCK_INFO_0_BG,
      NULL,
      "hacks",
      {
         { "100", OPTION_VAL_100_BG },
         { "125", OPTION_VAL_125_BG },
         { "150", OPTION_VAL_150_BG },
         { "175", OPTION_VAL_175_BG },
         { "200", OPTION_VAL_200_BG },
         { "225", OPTION_VAL_225_BG },
         { "250", OPTION_VAL_250_BG },
         { "275", OPTION_VAL_275_BG },
         { "300", OPTION_VAL_300_BG },
         { "325", OPTION_VAL_325_BG },
         { "350", OPTION_VAL_350_BG },
         { "375", OPTION_VAL_375_BG },
         { "400", OPTION_VAL_400_BG },
         { "425", OPTION_VAL_425_BG },
         { "450", OPTION_VAL_450_BG },
         { "475", OPTION_VAL_475_BG },
         { "500", OPTION_VAL_500_BG },
         { NULL, NULL },
      },
      "100%"
   },
#endif
   {
      "genesis_plus_gx_force_dtack",
      GENESIS_PLUS_GX_FORCE_DTACK_LABEL_BG,
      NULL,
      GENESIS_PLUS_GX_FORCE_DTACK_INFO_0_BG,
      NULL,
      "hacks",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL },
      },
      "enabled"
   },
   {
      "genesis_plus_gx_addr_error",
      GENESIS_PLUS_GX_ADDR_ERROR_LABEL_BG,
      NULL,
      GENESIS_PLUS_GX_ADDR_ERROR_INFO_0_BG,
      NULL,
      "hacks",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL },
      },
      "enabled"
   },
   {
      "genesis_plus_gx_cd_latency",
      GENESIS_PLUS_GX_CD_LATENCY_LABEL_BG,
      NULL,
      GENESIS_PLUS_GX_CD_LATENCY_INFO_0_BG,
      NULL,
      "hacks",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL },
      },
      "enabled"
   },
   {
      "genesis_plus_gx_cd_precache",
      GENESIS_PLUS_GX_CD_PRECACHE_LABEL_BG,
      NULL,
      GENESIS_PLUS_GX_CD_PRECACHE_INFO_0_BG,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
#ifdef USE_PER_SOUND_CHANNELS_CONFIG
   {
      "genesis_plus_gx_show_advanced_audio_settings",
      GENESIS_PLUS_GX_SHOW_ADVANCED_AUDIO_SETTINGS_LABEL_BG,
      NULL,
      GENESIS_PLUS_GX_SHOW_ADVANCED_AUDIO_SETTINGS_INFO_0_BG,
      NULL,
      "channel_volume",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL},
      },
      "disabled"
   },
   {
      "genesis_plus_gx_psg_channel_0_volume",
      GENESIS_PLUS_GX_PSG_CHANNEL_0_VOLUME_LABEL_BG,
      NULL,
      GENESIS_PLUS_GX_PSG_CHANNEL_0_VOLUME_INFO_0_BG,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_psg_channel_1_volume",
      GENESIS_PLUS_GX_PSG_CHANNEL_1_VOLUME_LABEL_BG,
      NULL,
      GENESIS_PLUS_GX_PSG_CHANNEL_1_VOLUME_INFO_0_BG,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_psg_channel_2_volume",
      GENESIS_PLUS_GX_PSG_CHANNEL_2_VOLUME_LABEL_BG,
      NULL,
      GENESIS_PLUS_GX_PSG_CHANNEL_2_VOLUME_INFO_0_BG,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_psg_channel_3_volume",
      GENESIS_PLUS_GX_PSG_CHANNEL_3_VOLUME_LABEL_BG,
      NULL,
      GENESIS_PLUS_GX_PSG_CHANNEL_3_VOLUME_INFO_0_BG,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_0_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_0_VOLUME_LABEL_BG,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_0_VOLUME_INFO_0_BG,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_1_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_1_VOLUME_LABEL_BG,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_1_VOLUME_INFO_0_BG,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_2_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_2_VOLUME_LABEL_BG,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_2_VOLUME_INFO_0_BG,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_3_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_3_VOLUME_LABEL_BG,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_3_VOLUME_INFO_0_BG,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_4_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_4_VOLUME_LABEL_BG,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_4_VOLUME_INFO_0_BG,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_5_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_5_VOLUME_LABEL_BG,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_5_VOLUME_INFO_0_BG,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_0_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_0_VOLUME_LABEL_BG,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_0_VOLUME_INFO_0_BG,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_1_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_1_VOLUME_LABEL_BG,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_1_VOLUME_INFO_0_BG,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_2_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_2_VOLUME_LABEL_BG,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_2_VOLUME_INFO_0_BG,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_3_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_3_VOLUME_LABEL_BG,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_3_VOLUME_INFO_0_BG,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_4_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_4_VOLUME_LABEL_BG,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_4_VOLUME_INFO_0_BG,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_5_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_5_VOLUME_LABEL_BG,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_5_VOLUME_INFO_0_BG,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_6_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_6_VOLUME_LABEL_BG,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_6_VOLUME_INFO_0_BG,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_7_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_7_VOLUME_LABEL_BG,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_7_VOLUME_INFO_0_BG,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_8_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_8_VOLUME_LABEL_BG,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_8_VOLUME_INFO_0_BG,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
#endif
   { NULL, NULL, NULL, NULL, NULL, NULL, {{0}}, NULL },
};
struct retro_core_options_v2 options_bg = {
   option_cats_bg,
   option_defs_bg
};

/* RETRO_LANGUAGE_CA */

#define CATEGORY_SYSTEM_LABEL_CA "Sistema"
#define CATEGORY_SYSTEM_INFO_0_CA "Modifica les opcions del maquinari base, la regió, la bios i el fitxer de desat de Sega CD/Mega-CD."
#define CATEGORY_VIDEO_LABEL_CA "Vídeo"
#define CATEGORY_VIDEO_INFO_0_CA "Canvia la relació d'aspecte, retalls de la imatge, filtre de vídeo i l'omissió de fotogrames."
#define CATEGORY_AUDIO_LABEL_CA "Àudio"
#define CATEGORY_AUDIO_INFO_0_CA "Canviar les opcions del mesclador d'àudio."
#define CATEGORY_INPUT_LABEL_CA "Entrada"
#define CATEGORY_INPUT_INFO_0_CA "Canvia les opcions de la pistola de llum o de la senyal d'entrada del ratolí."
#define CATEGORY_HACKS_LABEL_CA "Correccions de l'emulació"
#define CATEGORY_HACKS_INFO_0_CA "Canvia les opcions de velocitat i precisió de l'emulador que afecten el rendiment a baix nivell i la compatibilitat."
#define CATEGORY_CHANNEL_VOLUME_LABEL_CA "Configuració avançada del volum dels canals"
#define CATEGORY_CHANNEL_VOLUME_INFO_0_CA "Canvia el volum dels canals de so del maquinari."
#define GENESIS_PLUS_GX_SYSTEM_HW_LABEL_CA "Maquinari del sistema"
#define GENESIS_PLUS_GX_SYSTEM_HW_INFO_0_CA "Executa contingut carregat fent servir un model específic de consola. L'opció 'Automàtica' seleccionarà l'emulador més apropiat pel joc."
#define OPTION_VAL_AUTO_CA "Automàtic"
#define OPTION_VAL_SG_1000_CA NULL
#define OPTION_VAL_SG_1000_II_CA NULL
#define OPTION_VAL_SG_1000_II_RAM_EXT_CA NULL
#define OPTION_VAL_MARK_III_CA NULL
#define OPTION_VAL_MASTER_SYSTEM_CA NULL
#define OPTION_VAL_MASTER_SYSTEM_II_CA NULL
#define OPTION_VAL_GAME_GEAR_CA NULL
#define OPTION_VAL_MEGA_DRIVE_GENESIS_CA NULL
#define GENESIS_PLUS_GX_REGION_DETECT_LABEL_CA "Regió del sistema"
#define GENESIS_PLUS_GX_REGION_DETECT_INFO_0_CA "Especifica la regió per la qual s'ha fabricat el sistema. A excepció de la Game Gear, PAL mostrarà imatges a 50 Hz, mentre que NTSC les mostrarà a 60 Hz. Si selecciones una regió incorrecta, els jocs poden mostrar-se més ràpid o més lent."
#define OPTION_VAL_NTSC_U_CA NULL
#define OPTION_VAL_PAL_CA NULL
#define OPTION_VAL_NTSC_J_CA NULL
#define GENESIS_PLUS_GX_VDP_MODE_LABEL_CA "Forçar mode VDP"
#define GENESIS_PLUS_GX_VDP_MODE_INFO_0_CA "Canvia al mode VDP per forçar a executar-lo en el mode NTSC a 60 Hz o en el mode PAL a 50 Hz sense tenir en compte la regió del sistema."
#define OPTION_VAL_60HZ_CA "NTSC (60 Hz)"
#define OPTION_VAL_50HZ_CA "PAL (50 Hz)"
#define GENESIS_PLUS_GX_BIOS_LABEL_CA "ROM d'arrencada del sistema"
#define GENESIS_PLUS_GX_BIOS_INFO_0_CA "Fes servir la BIOS oficial pel maquinari emulat si es troba en la carpeta de sistema de RetroArch. Es mostrarà la seqüència específica d'inici de la consola i després s'executarà el joc carregat."
#define GENESIS_PLUS_GX_SYSTEM_BRAM_LABEL_CA "BRAM del sistema CD (Es requereix reinici)"
#define GENESIS_PLUS_GX_SYSTEM_BRAM_INFO_0_CA "En executar contingut de Sega CD/Mega-CD, especifica si s'ha de compartir un sol fitxer de desat entre tots els jocs de la mateixa regió o si cal crear un fitxer individual per cada joc. Nota: la Mega-CD/Sega Cd té un espai d'emmagatzematge limitat, suficient per uns quants jocs. Es recomana escollir 'Un fitxer per cada joc' per a que no et quedis sense espai lliure."
#define OPTION_VAL_PER_BIOS_CA "Per BIOS"
#define OPTION_VAL_PER_GAME_CA "Per joc"
#define GENESIS_PLUS_GX_CART_BRAM_LABEL_CA "BRAM del sistema CD (Es requereix reinici)"
#define GENESIS_PLUS_GX_CART_BRAM_INFO_0_CA "En executar continguts per Mega-CD/Sega CD, s'especifica si s'ha de compartir un cartutx de memòria RAM pels estats desats de tots els jocs d'una mateixa regió o si cal crear un fitxer individual per cada joc."
#define OPTION_VAL_PER_CART_CA "Per cartutx"
#define GENESIS_PLUS_GX_CART_SIZE_LABEL_CA "Mida del BRAM del sistema CD (Es requereix reinici)"
#define GENESIS_PLUS_GX_CART_SIZE_INFO_0_CA "Estableix la mida del cartutx de memòria BRAM pels continguts de Sega CD/Mega-CD. Aquest ajustament és ideal per configurar les BRAM de memòria perquè hi hagi una per cada joc i evitar tenir diferents cartutxs amb una mida massa gran."
#define OPTION_VAL_128K_CA NULL
#define OPTION_VAL_256K_CA NULL
#define OPTION_VAL_512K_CA NULL
#define OPTION_VAL_1MEG_CA NULL
#define OPTION_VAL_2MEG_CA NULL
#define OPTION_VAL_4MEG_CA NULL
#define GENESIS_PLUS_GX_ADD_ON_LABEL_CA "Afegit de CD (Mode MD) (Es requereix reinici)"
#define GENESIS_PLUS_GX_ADD_ON_INFO_0_CA "Especifica el mòdul que cal utilitzar per a la reproducció de so de CD en els jocs compatibles amb Mega Drive/Genesis."
#define OPTION_VAL_SEGA_MEGA_CD_CA NULL
#define OPTION_VAL_MEGASD_CA NULL
#define OPTION_VAL_NONE_CA "Cap"
#define GENESIS_PLUS_GX_LOCK_ON_LABEL_CA "Bloqueig de cartutx"
#define GENESIS_PLUS_GX_LOCK_ON_INFO_0_CA "La tecnologia Lock-On és una característica de la Mega Drive/Genesis que permetia a un joc antic connectar-se a un cartutx especial per alterar o ampliar el seu contingut. Aquesta opció especifica quin tipus de Lock-On és emulat. És necessari incloure el fitxer de la BIOS corresponent en la carpeta del sistema de RetroArch."
#define OPTION_VAL_GAME_GENIE_CA NULL
#define OPTION_VAL_ACTION_REPLAY_PRO_CA NULL
#define OPTION_VAL_SONIC_KNUCKLES_CA NULL
#define GENESIS_PLUS_GX_ASPECT_RATIO_LABEL_CA "Relació d'aspecte proveïda pel nucli"
#define GENESIS_PLUS_GX_ASPECT_RATIO_INFO_0_CA "Escull la relació d'aspecte preferida. Aquesta relació d'aspecte només s'aplicarà si la relació d'aspecte a RetroArch està fixada a 'Core provided' en la configuració de vídeo."
#define OPTION_VAL_NTSC_PAR_CA NULL
#define OPTION_VAL_PAL_PAR_CA NULL
#define OPTION_VAL_4_3_CA NULL
#define OPTION_VAL_UNCORRECTED_CA "Sense corregir"
#define GENESIS_PLUS_GX_OVERSCAN_LABEL_CA "Vores"
#define GENESIS_PLUS_GX_OVERSCAN_INFO_0_CA "Activa aquesta opció per mostrar les zones de sobreescombrat superior/inferior i dreta/esquerra de la pantalla. Un monitor estàndard de televisió acostuma a amagar aquestes zones a les vores de la pantalla."
#define OPTION_VAL_TOP_BOTTOM_CA "Superior/Inferior"
#define OPTION_VAL_LEFT_RIGHT_CA "Esquerre/Dreta"
#define OPTION_VAL_FULL_CA "Complet"
#define GENESIS_PLUS_GX_LEFT_BORDER_LABEL_CA "Amaga les vores de Master System"
#define GENESIS_PLUS_GX_LEFT_BORDER_INFO_0_CA "Retalla 8 píxels en la part esquerra de la pantalla o als dos costats en executar jocs de Master System."
#define OPTION_VAL_LEFT_BORDER_CA "Només la vora esquerre"
#define OPTION_VAL_LEFT_RIGHT_BORDERS_CA "Vores esquerra i dreta"
#define GENESIS_PLUS_GX_GG_EXTRA_LABEL_CA "Pantalla ampliada de la Game Gear"
#define GENESIS_PLUS_GX_GG_EXTRA_INFO_0_CA "Força als jocs de Game Gear a executar-se en el mode SMS amb una resolució augmentada de 256x192. Potser es mostren més continguts, però el més normal és que es mostri una vora a les imatges."
#define GENESIS_PLUS_GX_BLARGG_NTSC_FILTER_LABEL_CA "Filtre Blargg NTSC"
#define GENESIS_PLUS_GX_BLARGG_NTSC_FILTER_INFO_0_CA "Aplica un filtre de vídeo per imitar el senyal de les televisions NTSC."
#define OPTION_VAL_MONOCHROME_CA "Monocrom"
#define OPTION_VAL_COMPOSITE_CA "Composició"
#define OPTION_VAL_SVIDEO_CA NULL
#define OPTION_VAL_RGB_CA NULL
#define GENESIS_PLUS_GX_LCD_FILTER_LABEL_CA "Filtre d'efecte fantasma del LCD"
#define GENESIS_PLUS_GX_LCD_FILTER_INFO_0_CA "Aplica un filtre d'efecte fantasma a la imatge per simular les característiques dels panells LCD de Game Gear i Nomad."
#define GENESIS_PLUS_GX_RENDER_LABEL_CA "Mode d'entrellaçament de vídeo 2"
#define GENESIS_PLUS_GX_RENDER_INFO_0_CA "El mode d'entrellaçament de vídeo 2 permet a la Mega Drive/Genesis generar una imatge que suplica l'altura original fins 320x448 (alta resolució) dibuixant línies d'escombrat alternatives en cada fotograma (es fa servir en els modes multijugador de Sonic the Hedgehog 2 i Combat Cars). 'Dos camps' imita el maquinari original: produeix una imatge nítida amb parpalleig o entrellaçament. 'Un camp' aplica un filtre de desentrellaçament per estabilitzar la imatge, però quedarà una mica borrosa."
#define OPTION_VAL_SINGLE_FIELD_CA "Camp únic"
#define OPTION_VAL_DOUBLE_FIELD_CA "Dos camps"
#define GENESIS_PLUS_GX_FRAMESKIP_LABEL_CA "Ometre fotogrames"
#define GENESIS_PLUS_GX_FRAMESKIP_INFO_0_CA "Omet fotogrames per no saturar la memòria intermèdia de l'àudio. Millora el rendiment a canvi de perdre fluïdesa visual. Selecció automàtica omet fotogrames a petició del front-end. El valor manual ajusta el llindar d'omissió de fotogrames (%)."
#define OPTION_VAL_MANUAL_CA NULL
#define GENESIS_PLUS_GX_FRAMESKIP_THRESHOLD_LABEL_CA "Llindar d'omissió de fotogrames (%)"
#define GENESIS_PLUS_GX_FRAMESKIP_THRESHOLD_INFO_0_CA "Si l'omissió de fotogrames està fixada a 'Manual', aquesta opció selecciona el llindar inferior de la memòria intermèdia de l'àudio (en percentatge) per sota del no s'ometrà cap fotograma. Un valor més alt redueix el risc dels errors d'àudio, ometent fotogrames amb més freqüència."
#define GENESIS_PLUS_GX_YM2413_LABEL_CA NULL
#define GENESIS_PLUS_GX_YM2413_INFO_0_CA "Activa l'emulació de la unitat de so FM que fan servir alguns jocs concrets com Sega Mark III/Master System per millorar la sortida d'àudio."
#define GENESIS_PLUS_GX_YM2413_CORE_LABEL_CA "Nucli del Master System FM (YM2413)"
#define GENESIS_PLUS_GX_YM2413_CORE_INFO_0_CA "Selecciona el mètode utilitzar per emular la unitat de so FM de la Sega Mark III/Master System. 'MAME' és ràpid i s'executa a la màxima velocitat en gran part dels sistemes. 'Nuked' ofereix una emulació més precisa, amb més qualitat però amb més requisits de CPU."
#define OPTION_VAL_MAME_CA NULL
#define OPTION_VAL_NUKED_CA NULL
#define GENESIS_PLUS_GX_YM2612_LABEL_CA NULL
#define GENESIS_PLUS_GX_YM2612_INFO_0_CA "Selecciona el mètode amb el qual emular el sintetitzador FM de la Mega Drive/Genesis. L'opció MAME és més ràpida i s'executa a la màxima velocitat en gran part dels sistemes. L'opció Nuked ofereix una emulació més precisa, amb més qualitat però amb més requisits de CPU. El xip YM26132 és el que fa servir el Model 1 original de Mega Drive/Genesis. El xip YM 3438 és el que fan servir les versions posteriors de Mega Drive/Genesis."
#define GENESIS_PLUS_GX_YM2612_INFO_1_CA "Selecciona el mètode utilitzat per emular el sintetitzador FM de la Mega Drive/Genesis. El xip YM26132 és el que fan servir els Model 1 originals de Mega Drive/Genesis. El xip YM3438 és el que es va fer servir en versions posteriors de Mega Drive/Genesis."
#define OPTION_VAL_MAME_YM2612_CA NULL
#define OPTION_VAL_MAME_ASIC_YM3438_CA NULL
#define OPTION_VAL_MAME_ENHANCED_YM3438_CA NULL
#define OPTION_VAL_NUKED_YM2612_CA NULL
#define OPTION_VAL_NUKED_YM3438_CA NULL
#define GENESIS_PLUS_GX_SOUND_OUTPUT_LABEL_CA "Sortida d'àudio"
#define GENESIS_PLUS_GX_SOUND_OUTPUT_INFO_0_CA "Selecciona estèreo o mono a la sortida d'àudio."
#define OPTION_VAL_STEREO_CA "Estèreo"
#define OPTION_VAL_MONO_CA NULL
#define GENESIS_PLUS_GX_AUDIO_FILTER_LABEL_CA "Filtre d'àudio"
#define GENESIS_PLUS_GX_AUDIO_FILTER_INFO_0_CA "Habilita el filtre passabaix per simular millor el so característic del model 1 de Mega Drive/Genesis."
#define OPTION_VAL_LOW_PASS_CA "Passabaix"
#define OPTION_VAL_EQ_CA NULL
#define GENESIS_PLUS_GX_LOWPASS_RANGE_LABEL_CA "Filtre passabaix %"
#define GENESIS_PLUS_GX_LOWPASS_RANGE_INFO_0_CA "Especifica el tall de freqüència del filtre d'àudio passabaix. Un valor alt es pot captar com un filtre amb més força, perquè esmorteeix un rang més gran de freqüències altes."
#define GENESIS_PLUS_GX_PSG_PREAMP_LABEL_CA "Nivell de preamplificador de PSG"
#define GENESIS_PLUS_GX_PSG_PREAMP_INFO_0_CA "Ajusta el nivell de preamplificació de so del PSG (generador programable de sons) SN76496 de quatre canals que fan servir les consoles SG-1000, Sega Mark III, Master System, Game Gear i Mega Drive/Genesis."
#define GENESIS_PLUS_GX_FM_PREAMP_LABEL_CA "Nivell de preamplificació de FM"
#define GENESIS_PLUS_GX_FM_PREAMP_INFO_0_CA "Ajusta el nivell de preamplificador d'àudio en el sintetitzador de so FM de la Mega Drive/Genesis o de la unitat de so FM de les Sega Mark III/Master System."
#define GENESIS_PLUS_GX_CDDA_VOLUME_LABEL_CA "Volum de CD-DA"
#define GENESIS_PLUS_GX_CDDA_VOLUME_INFO_0_CA "Ajusta el volum de la mescla de la sortida d'àudio del CD emulat."
#define GENESIS_PLUS_GX_PCM_VOLUME_LABEL_CA "Volum PCM"
#define GENESIS_PLUS_GX_PCM_VOLUME_INFO_0_CA "Ajusta la mescla de so de la sortida d'àudio del generador PCM RF5C164 emulat de la Sega CD/Mega-Cd."
#define GENESIS_PLUS_GX_AUDIO_EQ_LOW_LABEL_CA "EQ Greus"
#define GENESIS_PLUS_GX_AUDIO_EQ_LOW_INFO_0_CA "Ajusta el rang baix de l'equalitzador d'àudio."
#define GENESIS_PLUS_GX_AUDIO_EQ_MID_LABEL_CA "EQ Mitjos"
#define GENESIS_PLUS_GX_AUDIO_EQ_MID_INFO_0_CA "Ajusta el rang mig de l'equalitzador d'àudio."
#define GENESIS_PLUS_GX_AUDIO_EQ_HIGH_LABEL_CA "EQ Aguts"
#define GENESIS_PLUS_GX_AUDIO_EQ_HIGH_INFO_0_CA "Ajusta el rang alt de l'equalitzador d'àudio."
#define GENESIS_PLUS_GX_GUN_INPUT_LABEL_CA "Entrada de la pistola de llum"
#define GENESIS_PLUS_GX_GUN_INPUT_INFO_0_CA "Fes servir una pistola de llum controlada per ratolí o per pantalla tàctil."
#define OPTION_VAL_LIGHTGUN_CA "Pistola de llum"
#define OPTION_VAL_TOUCHSCREEN_CA "Pantalla tàctil"
#define GENESIS_PLUS_GX_GUN_CURSOR_LABEL_CA "Mostrar el mira de les pistoles de llum"
#define GENESIS_PLUS_GX_GUN_CURSOR_INFO_0_CA "Mostra la creueta de la pistola de llum en fer servir els dispositius MD Menacer, MD Justifiers i MS Light Phaser."
#define GENESIS_PLUS_GX_INVERT_MOUSE_LABEL_CA "Invertir l'eix Y del ratolí"
#define GENESIS_PLUS_GX_INVERT_MOUSE_INFO_0_CA "Inverteix l'eix vertical del dispositiu d'entrada MD Mouse."
#define GENESIS_PLUS_GX_NO_SPRITE_LIMIT_LABEL_CA "Volum del canal 3 del PSG %"
#define GENESIS_PLUS_GX_NO_SPRITE_LIMIT_INFO_0_CA "Elimina el límit de vuit sprites per línia d'escaneig que tenia el maquinari original. Redueix el parpelleig, però pot provocar alguns errors gràfics, perquè alguns jocs feien servir aquesta limitació per generar efectes especials."
#define GENESIS_PLUS_GX_ENHANCED_VSCROLL_LABEL_CA "Millorar el desplaçament vertical de tiles"
#define GENESIS_PLUS_GX_ENHANCED_VSCROLL_INFO_0_CA "Permet que cada cel·la individual es pugui desplaçar verticalment en comptes de fer-ho per parelles de 16 píxels, fent un càlcul del valor vscroll de les cel·les contigües. Aquesta correcció només s'aplica a alguns jocs que fan servir el mètode desplaçament vertical per parelles de cel·les."
#define GENESIS_PLUS_GX_ENHANCED_VSCROLL_LIMIT_LABEL_CA "Límit de millora del desplaçament vertical de tiles"
#define GENESIS_PLUS_GX_ENHANCED_VSCROLL_LIMIT_INFO_0_CA "Aquesta opció només s'aplicarà si la millora del desplaçament vertical per fila està activada. Ajusta el límit d'aquesta millora. Si la diferència entre el valor de vscroll entre cel·les contigües és superior a aquest límit, es desactiva la millora."
#define GENESIS_PLUS_GX_OVERCLOCK_LABEL_CA "Velocitat de la CPU"
#define GENESIS_PLUS_GX_OVERCLOCK_INFO_0_CA "Augmenta la velocitat de la CPU emulada. Pot reduir els alentiments, però també pot provocar errors gràfics."
#define OPTION_VAL_100_CA NULL
#define OPTION_VAL_125_CA NULL
#define OPTION_VAL_150_CA NULL
#define OPTION_VAL_175_CA NULL
#define OPTION_VAL_200_CA NULL
#define OPTION_VAL_225_CA NULL
#define OPTION_VAL_250_CA NULL
#define OPTION_VAL_275_CA NULL
#define OPTION_VAL_300_CA NULL
#define OPTION_VAL_325_CA NULL
#define OPTION_VAL_350_CA NULL
#define OPTION_VAL_375_CA NULL
#define OPTION_VAL_400_CA NULL
#define OPTION_VAL_425_CA NULL
#define OPTION_VAL_450_CA NULL
#define OPTION_VAL_475_CA NULL
#define OPTION_VAL_500_CA NULL
#define GENESIS_PLUS_GX_FORCE_DTACK_LABEL_CA "Bloquejos del sistema"
#define GENESIS_PLUS_GX_FORCE_DTACK_INFO_0_CA "Simula els bloquejos del sistema que es poden produir en el maquinari real arran de realitzar lectures de memòria no permeses. Només s'ha de desactivar aquesta opció en executar demos o aplicacions homebrew que necessiten aquesta opció activada per funcionar correctament."
#define GENESIS_PLUS_GX_ADDR_ERROR_LABEL_CA "Error d'adreça 68K"
#define GENESIS_PLUS_GX_ADDR_ERROR_INFO_0_CA "La CPU principal de la Mega Drive/Genesis (el xip Motorola 68000) genera una excepció d'error de memòria al intentar accedir a una memòria no alineada. Activa aquesta opció per simular aquest comportament. Només s'ha de desactivar per jugar a jocs amb modificacions, perquè es desenvolupen amb emuladors menys precisos i poden dependre d'accessos a memòria RAM no vàlids per poder funcionar correctament."
#define GENESIS_PLUS_GX_CD_LATENCY_LABEL_CA "Temps d'accés al CD"
#define GENESIS_PLUS_GX_CD_LATENCY_INFO_0_CA "Simula la latència del lector original de CD en iniciar una lectura o una cerca en una ubicació concreta del disc. És necessari per a alguns jocs en format CD que es quedaran penjats si les dades arriben massa aviat i també corregeix problemes de desincronització de l'àudio del CD en alguns jocs. Desactivar aquesta opció pot ser positiu per a alguns jocs MSU-MD, fent que els bucles de pistes del CD siguin més uniformes."
#define GENESIS_PLUS_GX_CD_PRECACHE_LABEL_CA "Memòria intermèdia de la imatge de CD"
#define GENESIS_PLUS_GX_CD_PRECACHE_INFO_0_CA "Carrega la imatge de CD en inciar l'emulació. Només s'admeten imatges CHD. Es requereix reinici."
#define GENESIS_PLUS_GX_SHOW_ADVANCED_AUDIO_SETTINGS_LABEL_CA "Mostra la configuració avançada d'àudio (Torna a obrir el menú)"
#define GENESIS_PLUS_GX_SHOW_ADVANCED_AUDIO_SETTINGS_INFO_0_CA "Habilita la configuració dels paràmetres dels canals de so a baix nivell. NOTA: És necessari sortir i tornar a entrar en el menú ràpid perquè el canvi tingui efecte."
#define GENESIS_PLUS_GX_PSG_CHANNEL_0_VOLUME_LABEL_CA "Volum del canal 0 del PSG %"
#define GENESIS_PLUS_GX_PSG_CHANNEL_0_VOLUME_INFO_0_CA "Redueix el volum del canal de so 0 de PSG."
#define GENESIS_PLUS_GX_PSG_CHANNEL_1_VOLUME_LABEL_CA "Volum del canal 1 del PSG %"
#define GENESIS_PLUS_GX_PSG_CHANNEL_1_VOLUME_INFO_0_CA "Redueix el volum del canal de so 1 de PSG."
#define GENESIS_PLUS_GX_PSG_CHANNEL_2_VOLUME_LABEL_CA "Volum del canal 2 del PSG %"
#define GENESIS_PLUS_GX_PSG_CHANNEL_2_VOLUME_INFO_0_CA "Redueix el volum del canal de so 2 de PSG."
#define GENESIS_PLUS_GX_PSG_CHANNEL_3_VOLUME_LABEL_CA "Volum del canal 3 del PSG %"
#define GENESIS_PLUS_GX_PSG_CHANNEL_3_VOLUME_INFO_0_CA "Redueix el volum del canal de so 3 de PSG."
#define GENESIS_PLUS_GX_MD_CHANNEL_0_VOLUME_LABEL_CA "Volum del canal 0 de la Mega Drive/Genesis %"
#define GENESIS_PLUS_GX_MD_CHANNEL_0_VOLUME_INFO_0_CA "Redueix el volum del canal 0 de FM de la Mega Drive/Genesis. Només funciona amb els emuladors MAME de FM."
#define GENESIS_PLUS_GX_MD_CHANNEL_1_VOLUME_LABEL_CA "Volum del canal 1 de la Mega Drive/Genesis %"
#define GENESIS_PLUS_GX_MD_CHANNEL_1_VOLUME_INFO_0_CA "Redueix el volum del canal 1 de FM de la Mega Drive/Genesis. Només funciona amb els emuladors MAME de FM."
#define GENESIS_PLUS_GX_MD_CHANNEL_2_VOLUME_LABEL_CA "Volum del canal 2 de la Mega Drive/Genesis %"
#define GENESIS_PLUS_GX_MD_CHANNEL_2_VOLUME_INFO_0_CA "Redueix el volum del canal 2 de FM de la Mega Drive/Genesis. Només funciona amb els emuladors MAME de FM."
#define GENESIS_PLUS_GX_MD_CHANNEL_3_VOLUME_LABEL_CA "Volum del canal 3 de la Mega Drive/Genesis %"
#define GENESIS_PLUS_GX_MD_CHANNEL_3_VOLUME_INFO_0_CA "Redueix el volum del canal 3 de FM de la Mega Drive/Genesis. Només funciona amb els emuladors MAME de FM."
#define GENESIS_PLUS_GX_MD_CHANNEL_4_VOLUME_LABEL_CA "Volum del canal 4 de la Mega Drive/Genesis %"
#define GENESIS_PLUS_GX_MD_CHANNEL_4_VOLUME_INFO_0_CA "Redueix el volum del canal 4 de FM de la Mega Drive/Genesis. Només funciona amb els emuladors MAME de FM."
#define GENESIS_PLUS_GX_MD_CHANNEL_5_VOLUME_LABEL_CA "Volum del canal 5 de la Mega Drive/Genesis %"
#define GENESIS_PLUS_GX_MD_CHANNEL_5_VOLUME_INFO_0_CA "Redueix el volum del canal 5 de FM de la Mega Drive/Genesis. Només funciona amb els emuladors MAME de FM."
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_0_VOLUME_LABEL_CA "Volum del canal 0 FM de Master System (%)"
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_0_VOLUME_INFO_0_CA "Redueix el volum del canal de so 0 de PSG."
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_1_VOLUME_LABEL_CA "Volum del canal 1 FM de Master System (%)"
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_1_VOLUME_INFO_0_CA "Redueix el volum del canal de so 1 de PSG."
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_2_VOLUME_LABEL_CA "Volum del canal 2 FM de Master System (%)"
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_2_VOLUME_INFO_0_CA "Redueix el volum del canal de so 2 de PSG."
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_3_VOLUME_LABEL_CA "Volum del canal 3 FM de Master System (%)"
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_3_VOLUME_INFO_0_CA "Redueix el volum del canal de so 3 de PSG."
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_4_VOLUME_LABEL_CA "Volum del canal 4 FM de Master System (%)"
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_4_VOLUME_INFO_0_CA "Redueix el volum del canal de so 4 de PSG."
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_5_VOLUME_LABEL_CA "Volum del canal 5 FM de Master System (%)"
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_5_VOLUME_INFO_0_CA "Redueix el volum del canal de so 5 de PSG."
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_6_VOLUME_LABEL_CA "Volum del canal 6 FM de Master System (%)"
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_6_VOLUME_INFO_0_CA "Redueix el volum del canal de so 6 de PSG."
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_7_VOLUME_LABEL_CA "Volum del canal 7 FM de Master System (%)"
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_7_VOLUME_INFO_0_CA "Redueix el volum del canal de so 7 de PSG."
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_8_VOLUME_LABEL_CA "Volum del canal 8 FM de Master System (%)"
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_8_VOLUME_INFO_0_CA "Redueix el volum del canal de so 8 de PSG."

struct retro_core_option_v2_category option_cats_ca[] = {
   {
      "system",
      CATEGORY_SYSTEM_LABEL_CA,
      CATEGORY_SYSTEM_INFO_0_CA
   },
   {
      "video",
      CATEGORY_VIDEO_LABEL_CA,
      CATEGORY_VIDEO_INFO_0_CA
   },
   {
      "audio",
      CATEGORY_AUDIO_LABEL_CA,
      CATEGORY_AUDIO_INFO_0_CA
   },
   {
      "input",
      CATEGORY_INPUT_LABEL_CA,
      CATEGORY_INPUT_INFO_0_CA
   },
   {
      "hacks",
      CATEGORY_HACKS_LABEL_CA,
      CATEGORY_HACKS_INFO_0_CA
   },
   {
      "channel_volume",
      CATEGORY_CHANNEL_VOLUME_LABEL_CA,
      CATEGORY_CHANNEL_VOLUME_INFO_0_CA
   },
   { NULL, NULL, NULL },
};
struct retro_core_option_v2_definition option_defs_ca[] = {
   {
      "genesis_plus_gx_system_hw",
      GENESIS_PLUS_GX_SYSTEM_HW_LABEL_CA,
      NULL,
      GENESIS_PLUS_GX_SYSTEM_HW_INFO_0_CA,
      NULL,
      "system",
      {
         { "auto",                 OPTION_VAL_AUTO_CA                 },
         { "sg-1000",              OPTION_VAL_SG_1000_CA              },
         { "sg-1000 II",           OPTION_VAL_SG_1000_II_CA           },
         { "sg-1000 II + ram ext.",OPTION_VAL_SG_1000_II_RAM_EXT_CA},
         { "mark-III",             OPTION_VAL_MARK_III_CA             },
         { "master system",        OPTION_VAL_MASTER_SYSTEM_CA        },
         { "master system II",     OPTION_VAL_MASTER_SYSTEM_II_CA     },
         { "game gear",            OPTION_VAL_GAME_GEAR_CA            },
         { "mega drive / genesis", OPTION_VAL_MEGA_DRIVE_GENESIS_CA   },
         { NULL, NULL },
      },
      "auto"
   },
   {
      "genesis_plus_gx_region_detect",
      GENESIS_PLUS_GX_REGION_DETECT_LABEL_CA,
      NULL,
      GENESIS_PLUS_GX_REGION_DETECT_INFO_0_CA,
      NULL,
      "system",
      {
         { "auto",    OPTION_VAL_AUTO_CA   },
         { "ntsc-u",  OPTION_VAL_NTSC_U_CA },
         { "pal",     OPTION_VAL_PAL_CA    },
         { "ntsc-j",  OPTION_VAL_NTSC_J_CA },
         { NULL, NULL },
      },
      "auto"
   },
   {
      "genesis_plus_gx_vdp_mode",
      GENESIS_PLUS_GX_VDP_MODE_LABEL_CA,
      NULL,
      GENESIS_PLUS_GX_VDP_MODE_INFO_0_CA,
      NULL,
      "system",
      {
         { "auto",  "Disabled" },
         { "60hz",  OPTION_VAL_60HZ_CA },
         { "50hz",  OPTION_VAL_50HZ_CA },
         { NULL, NULL },
      },
      "auto"
   },
   {
      "genesis_plus_gx_bios",
      GENESIS_PLUS_GX_BIOS_LABEL_CA,
      NULL,
      GENESIS_PLUS_GX_BIOS_INFO_0_CA,
      NULL,
      "system",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_system_bram",
      GENESIS_PLUS_GX_SYSTEM_BRAM_LABEL_CA,
      NULL,
      GENESIS_PLUS_GX_SYSTEM_BRAM_INFO_0_CA,
      NULL,
      "system",
      {
         { "per bios", OPTION_VAL_PER_BIOS_CA },
         { "per game", OPTION_VAL_PER_GAME_CA },
         { NULL, NULL },
      },
      "per bios"
   },
   {
      "genesis_plus_gx_cart_bram",
      GENESIS_PLUS_GX_CART_BRAM_LABEL_CA,
      NULL,
      GENESIS_PLUS_GX_CART_BRAM_INFO_0_CA,
      NULL,
      "system",
      {
         { "per cart", OPTION_VAL_PER_CART_CA },
         { "per game", OPTION_VAL_PER_GAME_CA },
         { NULL, NULL },
      },
      "per cart"
   },
   {
      "genesis_plus_gx_cart_size",
      GENESIS_PLUS_GX_CART_SIZE_LABEL_CA,
      NULL,
      GENESIS_PLUS_GX_CART_SIZE_INFO_0_CA,
      NULL,
      "system",
      {
         { "disabled", "Disabled" },
         { "128k",     OPTION_VAL_128K_CA  },
         { "256k",     OPTION_VAL_256K_CA  },
         { "512k",     OPTION_VAL_512K_CA  },
         { "1meg",     OPTION_VAL_1MEG_CA    },
         { "2meg",     OPTION_VAL_2MEG_CA    },
         { "4meg",     OPTION_VAL_4MEG_CA    },
         { NULL, NULL },
      },
      "4meg"
   },
   {
      "genesis_plus_gx_add_on",
      GENESIS_PLUS_GX_ADD_ON_LABEL_CA,
      NULL,
      GENESIS_PLUS_GX_ADD_ON_INFO_0_CA,
      NULL,
      "system",
      {
         { "auto",         OPTION_VAL_AUTO_CA },
         { "sega/mega cd", OPTION_VAL_SEGA_MEGA_CD_CA },
         { "megasd",       OPTION_VAL_MEGASD_CA },
         { "none",         OPTION_VAL_NONE_CA },
         { NULL, NULL },
      },
      "auto"
   },
   {
      "genesis_plus_gx_lock_on",
      GENESIS_PLUS_GX_LOCK_ON_LABEL_CA,
      NULL,
      GENESIS_PLUS_GX_LOCK_ON_INFO_0_CA,
      NULL,
      "system",
      {
         { "disabled",            NULL },
         { "game genie",          OPTION_VAL_GAME_GENIE_CA },
         { "action replay (pro)", OPTION_VAL_ACTION_REPLAY_PRO_CA },
         { "sonic & knuckles",    OPTION_VAL_SONIC_KNUCKLES_CA },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_aspect_ratio",
      GENESIS_PLUS_GX_ASPECT_RATIO_LABEL_CA,
      NULL,
      GENESIS_PLUS_GX_ASPECT_RATIO_INFO_0_CA,
      NULL,
      "video",
      {
         { "auto",     OPTION_VAL_AUTO_CA },
         { "NTSC PAR", OPTION_VAL_NTSC_PAR_CA },
         { "PAL PAR",  OPTION_VAL_PAL_PAR_CA },
         { "4:3",  OPTION_VAL_4_3_CA },
         { "Uncorrected",  OPTION_VAL_UNCORRECTED_CA },
      },
      "auto"
   },
   {
      "genesis_plus_gx_overscan",
      GENESIS_PLUS_GX_OVERSCAN_LABEL_CA,
      NULL,
      GENESIS_PLUS_GX_OVERSCAN_INFO_0_CA,
      NULL,
      "video",
      {
         { "disabled",   NULL },
         { "top/bottom", OPTION_VAL_TOP_BOTTOM_CA },
         { "left/right", OPTION_VAL_LEFT_RIGHT_CA },
         { "full",       OPTION_VAL_FULL_CA },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_left_border",
      GENESIS_PLUS_GX_LEFT_BORDER_LABEL_CA,
      NULL,
      GENESIS_PLUS_GX_LEFT_BORDER_INFO_0_CA,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "left border", OPTION_VAL_LEFT_BORDER_CA },
         { "left & right borders", OPTION_VAL_LEFT_RIGHT_BORDERS_CA },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_gg_extra",
      GENESIS_PLUS_GX_GG_EXTRA_LABEL_CA,
      NULL,
      GENESIS_PLUS_GX_GG_EXTRA_INFO_0_CA,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_blargg_ntsc_filter",
      GENESIS_PLUS_GX_BLARGG_NTSC_FILTER_LABEL_CA,
      NULL,
      GENESIS_PLUS_GX_BLARGG_NTSC_FILTER_INFO_0_CA,
      NULL,
      "video",
      {
         { "disabled",   NULL },
         { "monochrome", OPTION_VAL_MONOCHROME_CA },
         { "composite",  OPTION_VAL_COMPOSITE_CA },
         { "svideo",     OPTION_VAL_SVIDEO_CA },
         { "rgb",        OPTION_VAL_RGB_CA },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_lcd_filter",
      GENESIS_PLUS_GX_LCD_FILTER_LABEL_CA,
      NULL,
      GENESIS_PLUS_GX_LCD_FILTER_INFO_0_CA,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_render",
      GENESIS_PLUS_GX_RENDER_LABEL_CA,
      NULL,
      GENESIS_PLUS_GX_RENDER_INFO_0_CA,
      NULL,
      "video",
      {
         { "single field", OPTION_VAL_SINGLE_FIELD_CA },
         { "double field", OPTION_VAL_DOUBLE_FIELD_CA },
         { NULL, NULL },
      },
      "single field"
   },
   {
      "genesis_plus_gx_frameskip",
      GENESIS_PLUS_GX_FRAMESKIP_LABEL_CA,
      NULL,
      GENESIS_PLUS_GX_FRAMESKIP_INFO_0_CA,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "auto",     OPTION_VAL_AUTO_CA },
         { "manual",   OPTION_VAL_MANUAL_CA },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_frameskip_threshold",
      GENESIS_PLUS_GX_FRAMESKIP_THRESHOLD_LABEL_CA,
      NULL,
      GENESIS_PLUS_GX_FRAMESKIP_THRESHOLD_INFO_0_CA,
      NULL,
      "video",
      {
         { "15", NULL },
         { "18", NULL },
         { "21", NULL },
         { "24", NULL },
         { "27", NULL },
         { "30", NULL },
         { "33", NULL },
         { "36", NULL },
         { "39", NULL },
         { "42", NULL },
         { "45", NULL },
         { "48", NULL },
         { "51", NULL },
         { "54", NULL },
         { "57", NULL },
         { "60", NULL },
         { NULL, NULL },
      },
      "33"
   },
   {
      "genesis_plus_gx_ym2413",
      GENESIS_PLUS_GX_YM2413_LABEL_CA,
      NULL,
      GENESIS_PLUS_GX_YM2413_INFO_0_CA,
      NULL,
      "audio",
      {
         { "auto",     OPTION_VAL_AUTO_CA },
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "auto"
   },
#ifdef HAVE_OPLL_CORE
   {
      "genesis_plus_gx_ym2413_core",
      GENESIS_PLUS_GX_YM2413_CORE_LABEL_CA,
      NULL,
      GENESIS_PLUS_GX_YM2413_CORE_INFO_0_CA,
      NULL,
      "audio",
      {
         { "mame",  OPTION_VAL_MAME_CA },
         { "nuked", OPTION_VAL_NUKED_CA },
         { NULL, NULL },
      },
      "mame"
   },
#endif
   {
      "genesis_plus_gx_ym2612",
      GENESIS_PLUS_GX_YM2612_LABEL_CA,
      NULL,
#ifdef HAVE_YM3438_CORE
      GENESIS_PLUS_GX_YM2612_INFO_0_CA,
#else
      GENESIS_PLUS_GX_YM2612_INFO_1_CA,
#endif
      NULL,
      "audio",
      {
         { "mame (ym2612)",          OPTION_VAL_MAME_YM2612_CA },
         { "mame (asic ym3438)",     OPTION_VAL_MAME_ASIC_YM3438_CA },
         { "mame (enhanced ym3438)", OPTION_VAL_MAME_ENHANCED_YM3438_CA },
#ifdef HAVE_YM3438_CORE
         { "nuked (ym2612)",         OPTION_VAL_NUKED_YM2612_CA },
         { "nuked (ym3438)",         OPTION_VAL_NUKED_YM3438_CA },
#endif
         { NULL, NULL },
      },
      "mame (ym2612)"
   },
   {
      "genesis_plus_gx_sound_output",
      GENESIS_PLUS_GX_SOUND_OUTPUT_LABEL_CA,
      NULL,
      GENESIS_PLUS_GX_SOUND_OUTPUT_INFO_0_CA,
      NULL,
      "audio",
      {
         { "stereo", OPTION_VAL_STEREO_CA },
         { "mono",   OPTION_VAL_MONO_CA },
         { NULL, NULL },
      },
      "stereo"
   },
   {
      "genesis_plus_gx_audio_filter",
      GENESIS_PLUS_GX_AUDIO_FILTER_LABEL_CA,
      NULL,
      GENESIS_PLUS_GX_AUDIO_FILTER_INFO_0_CA,
      NULL,
      "audio",
      {
         { "disabled", NULL },
         { "low-pass", OPTION_VAL_LOW_PASS_CA },
#ifdef HAVE_EQ
         { "EQ",       OPTION_VAL_EQ_CA },
#endif
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_lowpass_range",
      GENESIS_PLUS_GX_LOWPASS_RANGE_LABEL_CA,
      NULL,
      GENESIS_PLUS_GX_LOWPASS_RANGE_INFO_0_CA,
      NULL,
      "audio",
      {
         { "5",  NULL },
         { "10", NULL },
         { "15", NULL },
         { "20", NULL },
         { "25", NULL },
         { "30", NULL },
         { "35", NULL },
         { "40", NULL },
         { "45", NULL },
         { "50", NULL },
         { "55", NULL },
         { "60", NULL },
         { "65", NULL },
         { "70", NULL },
         { "75", NULL },
         { "80", NULL },
         { "85", NULL },
         { "90", NULL },
         { "95", NULL },
         { NULL, NULL },
      },
      "60"
   },
   {
      "genesis_plus_gx_psg_preamp",
      GENESIS_PLUS_GX_PSG_PREAMP_LABEL_CA,
      NULL,
      GENESIS_PLUS_GX_PSG_PREAMP_INFO_0_CA,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { "105", NULL },
         { "110", NULL },
         { "115", NULL },
         { "120", NULL },
         { "125", NULL },
         { "130", NULL },
         { "135", NULL },
         { "140", NULL },
         { "145", NULL },
         { "150", NULL },
         { "155", NULL },
         { "160", NULL },
         { "165", NULL },
         { "170", NULL },
         { "175", NULL },
         { "180", NULL },
         { "185", NULL },
         { "190", NULL },
         { "195", NULL },
         { "200", NULL },
         { NULL, NULL },
      },
      "150"
   },
   {
      "genesis_plus_gx_fm_preamp",
      GENESIS_PLUS_GX_FM_PREAMP_LABEL_CA,
      NULL,
      GENESIS_PLUS_GX_FM_PREAMP_INFO_0_CA,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { "105", NULL },
         { "110", NULL },
         { "115", NULL },
         { "120", NULL },
         { "125", NULL },
         { "130", NULL },
         { "135", NULL },
         { "140", NULL },
         { "145", NULL },
         { "150", NULL },
         { "155", NULL },
         { "160", NULL },
         { "165", NULL },
         { "170", NULL },
         { "175", NULL },
         { "180", NULL },
         { "185", NULL },
         { "190", NULL },
         { "195", NULL },
         { "200", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_cdda_volume",
      GENESIS_PLUS_GX_CDDA_VOLUME_LABEL_CA,
      NULL,
      GENESIS_PLUS_GX_CDDA_VOLUME_INFO_0_CA,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_pcm_volume",
      GENESIS_PLUS_GX_PCM_VOLUME_LABEL_CA,
      NULL,
      GENESIS_PLUS_GX_PCM_VOLUME_INFO_0_CA,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
#ifdef HAVE_EQ
   {
      "genesis_plus_gx_audio_eq_low",
      GENESIS_PLUS_GX_AUDIO_EQ_LOW_LABEL_CA,
      NULL,
      GENESIS_PLUS_GX_AUDIO_EQ_LOW_INFO_0_CA,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_audio_eq_mid",
      GENESIS_PLUS_GX_AUDIO_EQ_MID_LABEL_CA,
      NULL,
      GENESIS_PLUS_GX_AUDIO_EQ_MID_INFO_0_CA,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_audio_eq_high",
      GENESIS_PLUS_GX_AUDIO_EQ_HIGH_LABEL_CA,
      NULL,
      GENESIS_PLUS_GX_AUDIO_EQ_HIGH_INFO_0_CA,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
#endif
   {
      "genesis_plus_gx_gun_input",
      GENESIS_PLUS_GX_GUN_INPUT_LABEL_CA,
      NULL,
      GENESIS_PLUS_GX_GUN_INPUT_INFO_0_CA,
      NULL,
      "input",
      {
         { "lightgun",    OPTION_VAL_LIGHTGUN_CA },
         { "touchscreen", OPTION_VAL_TOUCHSCREEN_CA },
         { NULL, NULL },
      },
      "lightgun"
   },
   {
      "genesis_plus_gx_gun_cursor",
      GENESIS_PLUS_GX_GUN_CURSOR_LABEL_CA,
      NULL,
      GENESIS_PLUS_GX_GUN_CURSOR_INFO_0_CA,
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_invert_mouse",
      GENESIS_PLUS_GX_INVERT_MOUSE_LABEL_CA,
      NULL,
      GENESIS_PLUS_GX_INVERT_MOUSE_INFO_0_CA,
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_no_sprite_limit",
      GENESIS_PLUS_GX_NO_SPRITE_LIMIT_LABEL_CA,
      NULL,
      GENESIS_PLUS_GX_NO_SPRITE_LIMIT_INFO_0_CA,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_enhanced_vscroll",
      GENESIS_PLUS_GX_ENHANCED_VSCROLL_LABEL_CA,
      NULL,
      GENESIS_PLUS_GX_ENHANCED_VSCROLL_INFO_0_CA,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_enhanced_vscroll_limit",
      GENESIS_PLUS_GX_ENHANCED_VSCROLL_LIMIT_LABEL_CA,
      NULL,
      GENESIS_PLUS_GX_ENHANCED_VSCROLL_LIMIT_INFO_0_CA,
      NULL,
      "hacks",
      {
         { "2", NULL },
         { "3",  NULL },
         { "4", NULL },
         { "5",  NULL },
         { "6", NULL },
         { "7",  NULL },
         { "8", NULL },
         { "9",  NULL },
         { "10", NULL },
         { "11",  NULL },
         { "12", NULL },
         { "13",  NULL },
         { "14", NULL },
         { "15",  NULL },
         { "16", NULL },
         { NULL, NULL },
      },
      "8"
   },
#ifdef HAVE_OVERCLOCK
   {
      "genesis_plus_gx_overclock",
      GENESIS_PLUS_GX_OVERCLOCK_LABEL_CA,
      NULL,
      GENESIS_PLUS_GX_OVERCLOCK_INFO_0_CA,
      NULL,
      "hacks",
      {
         { "100", OPTION_VAL_100_CA },
         { "125", OPTION_VAL_125_CA },
         { "150", OPTION_VAL_150_CA },
         { "175", OPTION_VAL_175_CA },
         { "200", OPTION_VAL_200_CA },
         { "225", OPTION_VAL_225_CA },
         { "250", OPTION_VAL_250_CA },
         { "275", OPTION_VAL_275_CA },
         { "300", OPTION_VAL_300_CA },
         { "325", OPTION_VAL_325_CA },
         { "350", OPTION_VAL_350_CA },
         { "375", OPTION_VAL_375_CA },
         { "400", OPTION_VAL_400_CA },
         { "425", OPTION_VAL_425_CA },
         { "450", OPTION_VAL_450_CA },
         { "475", OPTION_VAL_475_CA },
         { "500", OPTION_VAL_500_CA },
         { NULL, NULL },
      },
      "100%"
   },
#endif
   {
      "genesis_plus_gx_force_dtack",
      GENESIS_PLUS_GX_FORCE_DTACK_LABEL_CA,
      NULL,
      GENESIS_PLUS_GX_FORCE_DTACK_INFO_0_CA,
      NULL,
      "hacks",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL },
      },
      "enabled"
   },
   {
      "genesis_plus_gx_addr_error",
      GENESIS_PLUS_GX_ADDR_ERROR_LABEL_CA,
      NULL,
      GENESIS_PLUS_GX_ADDR_ERROR_INFO_0_CA,
      NULL,
      "hacks",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL },
      },
      "enabled"
   },
   {
      "genesis_plus_gx_cd_latency",
      GENESIS_PLUS_GX_CD_LATENCY_LABEL_CA,
      NULL,
      GENESIS_PLUS_GX_CD_LATENCY_INFO_0_CA,
      NULL,
      "hacks",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL },
      },
      "enabled"
   },
   {
      "genesis_plus_gx_cd_precache",
      GENESIS_PLUS_GX_CD_PRECACHE_LABEL_CA,
      NULL,
      GENESIS_PLUS_GX_CD_PRECACHE_INFO_0_CA,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
#ifdef USE_PER_SOUND_CHANNELS_CONFIG
   {
      "genesis_plus_gx_show_advanced_audio_settings",
      GENESIS_PLUS_GX_SHOW_ADVANCED_AUDIO_SETTINGS_LABEL_CA,
      NULL,
      GENESIS_PLUS_GX_SHOW_ADVANCED_AUDIO_SETTINGS_INFO_0_CA,
      NULL,
      "channel_volume",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL},
      },
      "disabled"
   },
   {
      "genesis_plus_gx_psg_channel_0_volume",
      GENESIS_PLUS_GX_PSG_CHANNEL_0_VOLUME_LABEL_CA,
      NULL,
      GENESIS_PLUS_GX_PSG_CHANNEL_0_VOLUME_INFO_0_CA,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_psg_channel_1_volume",
      GENESIS_PLUS_GX_PSG_CHANNEL_1_VOLUME_LABEL_CA,
      NULL,
      GENESIS_PLUS_GX_PSG_CHANNEL_1_VOLUME_INFO_0_CA,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_psg_channel_2_volume",
      GENESIS_PLUS_GX_PSG_CHANNEL_2_VOLUME_LABEL_CA,
      NULL,
      GENESIS_PLUS_GX_PSG_CHANNEL_2_VOLUME_INFO_0_CA,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_psg_channel_3_volume",
      GENESIS_PLUS_GX_PSG_CHANNEL_3_VOLUME_LABEL_CA,
      NULL,
      GENESIS_PLUS_GX_PSG_CHANNEL_3_VOLUME_INFO_0_CA,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_0_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_0_VOLUME_LABEL_CA,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_0_VOLUME_INFO_0_CA,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_1_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_1_VOLUME_LABEL_CA,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_1_VOLUME_INFO_0_CA,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_2_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_2_VOLUME_LABEL_CA,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_2_VOLUME_INFO_0_CA,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_3_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_3_VOLUME_LABEL_CA,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_3_VOLUME_INFO_0_CA,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_4_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_4_VOLUME_LABEL_CA,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_4_VOLUME_INFO_0_CA,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_5_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_5_VOLUME_LABEL_CA,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_5_VOLUME_INFO_0_CA,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_0_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_0_VOLUME_LABEL_CA,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_0_VOLUME_INFO_0_CA,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_1_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_1_VOLUME_LABEL_CA,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_1_VOLUME_INFO_0_CA,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_2_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_2_VOLUME_LABEL_CA,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_2_VOLUME_INFO_0_CA,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_3_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_3_VOLUME_LABEL_CA,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_3_VOLUME_INFO_0_CA,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_4_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_4_VOLUME_LABEL_CA,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_4_VOLUME_INFO_0_CA,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_5_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_5_VOLUME_LABEL_CA,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_5_VOLUME_INFO_0_CA,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_6_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_6_VOLUME_LABEL_CA,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_6_VOLUME_INFO_0_CA,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_7_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_7_VOLUME_LABEL_CA,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_7_VOLUME_INFO_0_CA,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_8_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_8_VOLUME_LABEL_CA,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_8_VOLUME_INFO_0_CA,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
#endif
   { NULL, NULL, NULL, NULL, NULL, NULL, {{0}}, NULL },
};
struct retro_core_options_v2 options_ca = {
   option_cats_ca,
   option_defs_ca
};

/* RETRO_LANGUAGE_CHS */

#define CATEGORY_SYSTEM_LABEL_CHS "系统"
#define CATEGORY_SYSTEM_INFO_0_CHS "更改基础硬件选择、区域、BIOS 和 Sega CD/Mega-CD 保存文件设置。"
#define CATEGORY_VIDEO_LABEL_CHS "视频"
#define CATEGORY_VIDEO_INFO_0_CHS "更改长宽比、显示裁剪、视频过滤和帧跳过设置。"
#define CATEGORY_AUDIO_LABEL_CHS "音频"
#define CATEGORY_AUDIO_INFO_0_CHS "更改音频设备设置。"
#define CATEGORY_INPUT_LABEL_CHS "输入"
#define CATEGORY_INPUT_INFO_0_CHS "更改光枪/鼠标输入设置。"
#define CATEGORY_HACKS_LABEL_CHS "模拟修改"
#define CATEGORY_HACKS_INFO_0_CHS NULL
#define CATEGORY_CHANNEL_VOLUME_LABEL_CHS "高级频道音量设置"
#define CATEGORY_CHANNEL_VOLUME_INFO_0_CHS "更改单个硬件音频频道的音量。"
#define GENESIS_PLUS_GX_SYSTEM_HW_LABEL_CHS "系统硬件"
#define GENESIS_PLUS_GX_SYSTEM_HW_INFO_0_CHS "用特定模拟控制台运行已加载的内容。'自动' 将选择当前游戏最合适的系统。"
#define OPTION_VAL_AUTO_CHS "自动"
#define OPTION_VAL_SG_1000_CHS NULL
#define OPTION_VAL_SG_1000_II_CHS NULL
#define OPTION_VAL_SG_1000_II_RAM_EXT_CHS NULL
#define OPTION_VAL_MARK_III_CHS NULL
#define OPTION_VAL_MASTER_SYSTEM_CHS NULL
#define OPTION_VAL_MASTER_SYSTEM_II_CHS NULL
#define OPTION_VAL_GAME_GEAR_CHS NULL
#define OPTION_VAL_MEGA_DRIVE_GENESIS_CHS NULL
#define GENESIS_PLUS_GX_REGION_DETECT_LABEL_CHS "系统区域"
#define GENESIS_PLUS_GX_REGION_DETECT_INFO_0_CHS "指定系统来自哪个区域。对于游戏手势以外的控制台，'PAL'为50赫兹，而'NTSC'为60赫兹。 如果选中不正确的区域，游戏可能会比正常更快或更慢。"
#define OPTION_VAL_NTSC_U_CHS NULL
#define OPTION_VAL_PAL_CHS NULL
#define OPTION_VAL_NTSC_J_CHS NULL
#define GENESIS_PLUS_GX_VDP_MODE_LABEL_CHS NULL
#define GENESIS_PLUS_GX_VDP_MODE_INFO_0_CHS NULL
#define OPTION_VAL_60HZ_CHS NULL
#define OPTION_VAL_50HZ_CHS NULL
#define GENESIS_PLUS_GX_BIOS_LABEL_CHS "系统启动 ROM"
#define GENESIS_PLUS_GX_BIOS_INFO_0_CHS "使用官方的 BIOS/bootloader 模拟硬件，如果存在于RetroArch的系统目录中。显示针对控制台的启动序列/动画，然后运行加载内容。"
#define GENESIS_PLUS_GX_SYSTEM_BRAM_LABEL_CHS NULL
#define GENESIS_PLUS_GX_SYSTEM_BRAM_INFO_0_CHS NULL
#define OPTION_VAL_PER_BIOS_CHS "双精度"
#define OPTION_VAL_PER_GAME_CHS "每个游戏"
#define GENESIS_PLUS_GX_CART_BRAM_LABEL_CHS NULL
#define GENESIS_PLUS_GX_CART_BRAM_INFO_0_CHS NULL
#define OPTION_VAL_PER_CART_CHS NULL
#define GENESIS_PLUS_GX_CART_SIZE_LABEL_CHS NULL
#define GENESIS_PLUS_GX_CART_SIZE_INFO_0_CHS NULL
#define OPTION_VAL_128K_CHS NULL
#define OPTION_VAL_256K_CHS NULL
#define OPTION_VAL_512K_CHS NULL
#define OPTION_VAL_1MEG_CHS NULL
#define OPTION_VAL_2MEG_CHS NULL
#define OPTION_VAL_4MEG_CHS NULL
#define GENESIS_PLUS_GX_ADD_ON_LABEL_CHS "CD 附加组件 (MD 模式) (需要重启)"
#define GENESIS_PLUS_GX_ADD_ON_INFO_0_CHS "指定支持的 Mega 驱动器/Genesis 游戏用于CD音频回放的附加组件。"
#define OPTION_VAL_SEGA_MEGA_CD_CHS NULL
#define OPTION_VAL_MEGASD_CHS NULL
#define OPTION_VAL_NONE_CHS "无"
#define GENESIS_PLUS_GX_LOCK_ON_LABEL_CHS "卡片锁定"
#define GENESIS_PLUS_GX_LOCK_ON_INFO_0_CHS "锁定技术是一个 Mega 驱动器/Genesis 功能，它允许旧游戏连接到特殊盒子的传递端口，用于延长或改变游戏。 此选项指定了要模拟的特殊的 '锁定' 墨盒类型。相应的 bios 文件必须存在于RetroArch的系统目录中。"
#define OPTION_VAL_GAME_GENIE_CHS NULL
#define OPTION_VAL_ACTION_REPLAY_PRO_CHS "回放(Pro)"
#define OPTION_VAL_SONIC_KNUCKLES_CHS "音速&节拍"
#define GENESIS_PLUS_GX_ASPECT_RATIO_LABEL_CHS "核心提供的宽高比"
#define GENESIS_PLUS_GX_ASPECT_RATIO_INFO_0_CHS "选择首选内容宽高比。这只适用于RetroArch的宽高比设置为视频设置中的“核心提供”。"
#define OPTION_VAL_NTSC_PAR_CHS NULL
#define OPTION_VAL_PAL_PAR_CHS NULL
#define OPTION_VAL_4_3_CHS NULL
#define OPTION_VAL_UNCORRECTED_CHS NULL
#define GENESIS_PLUS_GX_OVERSCAN_LABEL_CHS "边框"
#define GENESIS_PLUS_GX_OVERSCAN_INFO_0_CHS "启用此选项以显示屏幕顶部/底部和/或左/右侧的覆盖区域。 这些通常被贝塞尔人隐藏在标准定义电视的边缘。"
#define OPTION_VAL_TOP_BOTTOM_CHS "顶部/底部"
#define OPTION_VAL_LEFT_RIGHT_CHS "左/右"
#define OPTION_VAL_FULL_CHS "全双工"
#define GENESIS_PLUS_GX_LEFT_BORDER_LABEL_CHS "隐藏主系统侧边框"
#define GENESIS_PLUS_GX_LEFT_BORDER_INFO_0_CHS "从屏幕左侧切断8像素，或者在运行主系统游戏时切断左侧和右侧。"
#define OPTION_VAL_LEFT_BORDER_CHS "仅左边框"
#define OPTION_VAL_LEFT_RIGHT_BORDERS_CHS "左和右边边界"
#define GENESIS_PLUS_GX_GG_EXTRA_LABEL_CHS "游戏装备扩展屏幕"
#define GENESIS_PLUS_GX_GG_EXTRA_INFO_0_CHS "强制游戏装备标题在短信模式下运行，分辨率增加256x192。 可能会显示额外内容，但通常会显示损坏/不需要的图像数据。"
#define GENESIS_PLUS_GX_BLARGG_NTSC_FILTER_LABEL_CHS "Blgg NTSC过滤器"
#define GENESIS_PLUS_GX_BLARGG_NTSC_FILTER_INFO_0_CHS "将视频过滤器应用于模仿的各种NTSC电视信号。"
#define OPTION_VAL_MONOCHROME_CHS "单色"
#define OPTION_VAL_COMPOSITE_CHS "合成"
#define OPTION_VAL_SVIDEO_CHS "S-视频"
#define OPTION_VAL_RGB_CHS NULL
#define GENESIS_PLUS_GX_LCD_FILTER_LABEL_CHS "LCD重影过滤器"
#define GENESIS_PLUS_GX_LCD_FILTER_INFO_0_CHS "应用图像“ghosting”过滤器来模拟游戏工具和创意Nomad LCD 面板的显示特性。"
#define GENESIS_PLUS_GX_RENDER_LABEL_CHS "交错模式2输出"
#define GENESIS_PLUS_GX_RENDER_INFO_0_CHS "交错模式2允许Mega Drive/Genesis输出双身高度(高分辨率) 320x448图像，绘制备用扫描线路每个帧(这个图像用于音效2和战斗车多人游戏模式)。 “双字段”模拟原始硬件，产生一幅含有闪烁/交错的图像的尖锐图像。 “单个字段”使用去交错过滤器，稳定图像，但造成轻微模糊。"
#define OPTION_VAL_SINGLE_FIELD_CHS "单字节"
#define OPTION_VAL_DOUBLE_FIELD_CHS "双字节"
#define GENESIS_PLUS_GX_FRAMESKIP_LABEL_CHS "跳帧"
#define GENESIS_PLUS_GX_FRAMESKIP_INFO_0_CHS "跳过帧以避免运行下的音频缓冲区(崩溃)。提高性能以牺牲视觉性能。 “自动”跳板帧在前端建议时。“手动”使用了“Frameskip 阈值(%)”设置。"
#define OPTION_VAL_MANUAL_CHS "手动"
#define GENESIS_PLUS_GX_FRAMESKIP_THRESHOLD_LABEL_CHS "跳帧阈值(%)"
#define GENESIS_PLUS_GX_FRAMESKIP_THRESHOLD_INFO_0_CHS "当“跳帧”功能设置成“手动”，请在下方指定跳帧占音频缓存的比例（百分比）。更高的值可以降低因频繁丢帧而导致的爆音风险。"
#define GENESIS_PLUS_GX_YM2413_LABEL_CHS NULL
#define GENESIS_PLUS_GX_YM2413_INFO_0_CHS "启用特定的 Sega Mark III/Master 系统游戏使用的 FM 声音单元来增强音频输出。"
#define GENESIS_PLUS_GX_YM2413_CORE_LABEL_CHS "Master System FM (YM2413) 核心。"
#define GENESIS_PLUS_GX_YM2413_CORE_INFO_0_CHS "选择用于模拟Sega Mark III/Master 系统的 FM 声音单元的方法。 “MAME”选项是快速的，在大多数系统上运行全速。 “Nuked”选项是周期准确的，质量很高，并且有大量的 CPU 要求。"
#define OPTION_VAL_MAME_CHS NULL
#define OPTION_VAL_NUKED_CHS "原型"
#define GENESIS_PLUS_GX_YM2612_LABEL_CHS NULL
#define GENESIS_PLUS_GX_YM2612_INFO_0_CHS "选择用于模拟Mega Drive/Genesis调频合成器(主声音生成器) 的方法。 “MAME”选项是快速的，并在大多数系统上运行全速。 “Nuked”选项是周期准确的，质量很高，并且有大量的 CPU 要求。 YM2612 芯片被原型1 Mega Drive/Genesis使用。YM3438将用于以后的 Mega Drive/Genesis 版本。"
#define GENESIS_PLUS_GX_YM2612_INFO_1_CHS "选择用于模拟Mega Drive/Genesis调频合成器(主声音生成器) 的方法。 YM2612 芯片被原型1 Mega Drive/Genesis使用。YM3438将用于以后的 Mega Drive/Genesis 版本。"
#define OPTION_VAL_MAME_YM2612_CHS NULL
#define OPTION_VAL_MAME_ASIC_YM3438_CHS NULL
#define OPTION_VAL_MAME_ENHANCED_YM3438_CHS "MAME (增强的 YM3438)"
#define OPTION_VAL_NUKED_YM2612_CHS "原型 (YM2612)"
#define OPTION_VAL_NUKED_YM3438_CHS "原型(YM3438)"
#define GENESIS_PLUS_GX_SOUND_OUTPUT_LABEL_CHS "声音输出"
#define GENESIS_PLUS_GX_SOUND_OUTPUT_INFO_0_CHS "选择立体声或单声道播放。"
#define OPTION_VAL_STEREO_CHS "立体声"
#define OPTION_VAL_MONO_CHS "单声道"
#define GENESIS_PLUS_GX_AUDIO_FILTER_LABEL_CHS "音频过滤器"
#define GENESIS_PLUS_GX_AUDIO_FILTER_INFO_0_CHS "启用低通道音频过滤器以更好地模拟模型1 Mega Drive/Genesis的特征声音。"
#define OPTION_VAL_LOW_PASS_CHS "低通滤波器"
#define OPTION_VAL_EQ_CHS "均衡器"
#define GENESIS_PLUS_GX_LOWPASS_RANGE_LABEL_CHS "低通滤波器 %"
#define GENESIS_PLUS_GX_LOWPASS_RANGE_INFO_0_CHS "指定音频低通过过滤器的截断频率。 较高的值提高了该过滤器的“强度”，因为高频谱范围更广。"
#define GENESIS_PLUS_GX_PSG_PREAMP_LABEL_CHS "PSG 预置级别"
#define GENESIS_PLUS_GX_PSG_PREAMP_INFO_0_CHS "设置模拟SN764964频道可编程声音生成器在SG-1000中的音频前置放大器级别 Sega Mark III, Master System, Game Gear and Mega Drive/Genesis."
#define GENESIS_PLUS_GX_FM_PREAMP_LABEL_CHS "FM 预置级别"
#define GENESIS_PLUS_GX_FM_PREAMP_INFO_0_CHS "设置模拟Mega 驱动器/Genesis FM声音合成器或 Sega Mark III/Master System FM 声音设备的音频放大器级别。"
#define GENESIS_PLUS_GX_CDDA_VOLUME_LABEL_CHS "CD-DA 音量"
#define GENESIS_PLUS_GX_CDDA_VOLUME_INFO_0_CHS "调整模拟的 CD 音频回放输出的混合音量。"
#define GENESIS_PLUS_GX_PCM_VOLUME_LABEL_CHS "PCM 音量"
#define GENESIS_PLUS_GX_PCM_VOLUME_INFO_0_CHS "调整模拟的Sega CD/Mega-CD RF5C164 PCM 声音生成器输出的混合音量。"
#define GENESIS_PLUS_GX_AUDIO_EQ_LOW_LABEL_CHS "低频均衡"
#define GENESIS_PLUS_GX_AUDIO_EQ_LOW_INFO_0_CHS "调整内部音频均衡器的低范围波段。"
#define GENESIS_PLUS_GX_AUDIO_EQ_MID_LABEL_CHS "中频均衡"
#define GENESIS_PLUS_GX_AUDIO_EQ_MID_INFO_0_CHS "调整内部音频均衡器的中间范围波段。"
#define GENESIS_PLUS_GX_AUDIO_EQ_HIGH_LABEL_CHS "高频均衡"
#define GENESIS_PLUS_GX_AUDIO_EQ_HIGH_INFO_0_CHS "调整内部音频均衡器的高范围波段。"
#define GENESIS_PLUS_GX_GUN_INPUT_LABEL_CHS NULL
#define GENESIS_PLUS_GX_GUN_INPUT_INFO_0_CHS NULL
#define OPTION_VAL_LIGHTGUN_CHS "光枪"
#define OPTION_VAL_TOUCHSCREEN_CHS "触摸屏"
#define GENESIS_PLUS_GX_GUN_CURSOR_LABEL_CHS NULL
#define GENESIS_PLUS_GX_GUN_CURSOR_INFO_0_CHS NULL
#define GENESIS_PLUS_GX_INVERT_MOUSE_LABEL_CHS "反转鼠标 Y 轴"
#define GENESIS_PLUS_GX_INVERT_MOUSE_INFO_0_CHS NULL
#define GENESIS_PLUS_GX_NO_SPRITE_LIMIT_LABEL_CHS NULL
#define GENESIS_PLUS_GX_NO_SPRITE_LIMIT_INFO_0_CHS NULL
#define GENESIS_PLUS_GX_ENHANCED_VSCROLL_LABEL_CHS NULL
#define GENESIS_PLUS_GX_ENHANCED_VSCROLL_INFO_0_CHS NULL
#define GENESIS_PLUS_GX_ENHANCED_VSCROLL_LIMIT_LABEL_CHS NULL
#define GENESIS_PLUS_GX_ENHANCED_VSCROLL_LIMIT_INFO_0_CHS NULL
#define GENESIS_PLUS_GX_OVERCLOCK_LABEL_CHS "CPU 速度"
#define GENESIS_PLUS_GX_OVERCLOCK_INFO_0_CHS NULL
#define OPTION_VAL_100_CHS NULL
#define OPTION_VAL_125_CHS NULL
#define OPTION_VAL_150_CHS NULL
#define OPTION_VAL_175_CHS NULL
#define OPTION_VAL_200_CHS NULL
#define OPTION_VAL_225_CHS NULL
#define OPTION_VAL_250_CHS NULL
#define OPTION_VAL_275_CHS NULL
#define OPTION_VAL_300_CHS NULL
#define OPTION_VAL_325_CHS NULL
#define OPTION_VAL_350_CHS NULL
#define OPTION_VAL_375_CHS NULL
#define OPTION_VAL_400_CHS NULL
#define OPTION_VAL_425_CHS NULL
#define OPTION_VAL_450_CHS NULL
#define OPTION_VAL_475_CHS NULL
#define OPTION_VAL_500_CHS NULL
#define GENESIS_PLUS_GX_FORCE_DTACK_LABEL_CHS NULL
#define GENESIS_PLUS_GX_FORCE_DTACK_INFO_0_CHS NULL
#define GENESIS_PLUS_GX_ADDR_ERROR_LABEL_CHS "68K 地址错误"
#define GENESIS_PLUS_GX_ADDR_ERROR_INFO_0_CHS NULL
#define GENESIS_PLUS_GX_CD_LATENCY_LABEL_CHS NULL
#define GENESIS_PLUS_GX_CD_LATENCY_INFO_0_CHS NULL
#define GENESIS_PLUS_GX_CD_PRECACHE_LABEL_CHS NULL
#define GENESIS_PLUS_GX_CD_PRECACHE_INFO_0_CHS NULL
#define GENESIS_PLUS_GX_SHOW_ADVANCED_AUDIO_SETTINGS_LABEL_CHS NULL
#define GENESIS_PLUS_GX_SHOW_ADVANCED_AUDIO_SETTINGS_INFO_0_CHS NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_0_VOLUME_LABEL_CHS NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_0_VOLUME_INFO_0_CHS NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_1_VOLUME_LABEL_CHS NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_1_VOLUME_INFO_0_CHS NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_2_VOLUME_LABEL_CHS NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_2_VOLUME_INFO_0_CHS NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_3_VOLUME_LABEL_CHS NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_3_VOLUME_INFO_0_CHS NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_0_VOLUME_LABEL_CHS NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_0_VOLUME_INFO_0_CHS NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_1_VOLUME_LABEL_CHS NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_1_VOLUME_INFO_0_CHS NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_2_VOLUME_LABEL_CHS NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_2_VOLUME_INFO_0_CHS NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_3_VOLUME_LABEL_CHS NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_3_VOLUME_INFO_0_CHS NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_4_VOLUME_LABEL_CHS NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_4_VOLUME_INFO_0_CHS NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_5_VOLUME_LABEL_CHS NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_5_VOLUME_INFO_0_CHS NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_0_VOLUME_LABEL_CHS "Master System FM (YM2413) 通道 0 音量 %"
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_0_VOLUME_INFO_0_CHS "降低Master System FM 频道0的音量。"
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_1_VOLUME_LABEL_CHS "Master System FM (YM2413) 通道 1 音量 %"
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_1_VOLUME_INFO_0_CHS "降低Master System FM 频道1的音量。"
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_2_VOLUME_LABEL_CHS "Master System FM (YM2413) 通道 2 音量 %"
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_2_VOLUME_INFO_0_CHS "降低Master System FM 频道2的音量。"
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_3_VOLUME_LABEL_CHS "Master System FM (YM2413) 通道 3 音量 %"
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_3_VOLUME_INFO_0_CHS "降低Master System FM 频道3的音量。"
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_4_VOLUME_LABEL_CHS "Master System FM (YM2413) 频道4 音量 %"
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_4_VOLUME_INFO_0_CHS "降低Master System FM 频道4的音量。"
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_5_VOLUME_LABEL_CHS "Master System FM (YM2413) 通道 5 音量 %"
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_5_VOLUME_INFO_0_CHS "降低Master System FM 频道5的音量。"
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_6_VOLUME_LABEL_CHS "Master System FM (YM2413) 通道 6 音量 %"
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_6_VOLUME_INFO_0_CHS "降低Master System FM 频道6的音量。"
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_7_VOLUME_LABEL_CHS "Master System FM (YM2413) 频道 7 音量 %"
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_7_VOLUME_INFO_0_CHS "降低 Master System FM 频道7 的音量。"
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_8_VOLUME_LABEL_CHS "Master System FM (YM2413) 频道 8 音量 %"
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_8_VOLUME_INFO_0_CHS "降低Master System FM 频道8 的音量。"

struct retro_core_option_v2_category option_cats_chs[] = {
   {
      "system",
      CATEGORY_SYSTEM_LABEL_CHS,
      CATEGORY_SYSTEM_INFO_0_CHS
   },
   {
      "video",
      CATEGORY_VIDEO_LABEL_CHS,
      CATEGORY_VIDEO_INFO_0_CHS
   },
   {
      "audio",
      CATEGORY_AUDIO_LABEL_CHS,
      CATEGORY_AUDIO_INFO_0_CHS
   },
   {
      "input",
      CATEGORY_INPUT_LABEL_CHS,
      CATEGORY_INPUT_INFO_0_CHS
   },
   {
      "hacks",
      CATEGORY_HACKS_LABEL_CHS,
      CATEGORY_HACKS_INFO_0_CHS
   },
   {
      "channel_volume",
      CATEGORY_CHANNEL_VOLUME_LABEL_CHS,
      CATEGORY_CHANNEL_VOLUME_INFO_0_CHS
   },
   { NULL, NULL, NULL },
};
struct retro_core_option_v2_definition option_defs_chs[] = {
   {
      "genesis_plus_gx_system_hw",
      GENESIS_PLUS_GX_SYSTEM_HW_LABEL_CHS,
      NULL,
      GENESIS_PLUS_GX_SYSTEM_HW_INFO_0_CHS,
      NULL,
      "system",
      {
         { "auto",                 OPTION_VAL_AUTO_CHS                 },
         { "sg-1000",              OPTION_VAL_SG_1000_CHS              },
         { "sg-1000 II",           OPTION_VAL_SG_1000_II_CHS           },
         { "sg-1000 II + ram ext.",OPTION_VAL_SG_1000_II_RAM_EXT_CHS},
         { "mark-III",             OPTION_VAL_MARK_III_CHS             },
         { "master system",        OPTION_VAL_MASTER_SYSTEM_CHS        },
         { "master system II",     OPTION_VAL_MASTER_SYSTEM_II_CHS     },
         { "game gear",            OPTION_VAL_GAME_GEAR_CHS            },
         { "mega drive / genesis", OPTION_VAL_MEGA_DRIVE_GENESIS_CHS   },
         { NULL, NULL },
      },
      "auto"
   },
   {
      "genesis_plus_gx_region_detect",
      GENESIS_PLUS_GX_REGION_DETECT_LABEL_CHS,
      NULL,
      GENESIS_PLUS_GX_REGION_DETECT_INFO_0_CHS,
      NULL,
      "system",
      {
         { "auto",    OPTION_VAL_AUTO_CHS   },
         { "ntsc-u",  OPTION_VAL_NTSC_U_CHS },
         { "pal",     OPTION_VAL_PAL_CHS    },
         { "ntsc-j",  OPTION_VAL_NTSC_J_CHS },
         { NULL, NULL },
      },
      "auto"
   },
   {
      "genesis_plus_gx_vdp_mode",
      GENESIS_PLUS_GX_VDP_MODE_LABEL_CHS,
      NULL,
      GENESIS_PLUS_GX_VDP_MODE_INFO_0_CHS,
      NULL,
      "system",
      {
         { "auto",  "Disabled" },
         { "60hz",  OPTION_VAL_60HZ_CHS },
         { "50hz",  OPTION_VAL_50HZ_CHS },
         { NULL, NULL },
      },
      "auto"
   },
   {
      "genesis_plus_gx_bios",
      GENESIS_PLUS_GX_BIOS_LABEL_CHS,
      NULL,
      GENESIS_PLUS_GX_BIOS_INFO_0_CHS,
      NULL,
      "system",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_system_bram",
      GENESIS_PLUS_GX_SYSTEM_BRAM_LABEL_CHS,
      NULL,
      GENESIS_PLUS_GX_SYSTEM_BRAM_INFO_0_CHS,
      NULL,
      "system",
      {
         { "per bios", OPTION_VAL_PER_BIOS_CHS },
         { "per game", OPTION_VAL_PER_GAME_CHS },
         { NULL, NULL },
      },
      "per bios"
   },
   {
      "genesis_plus_gx_cart_bram",
      GENESIS_PLUS_GX_CART_BRAM_LABEL_CHS,
      NULL,
      GENESIS_PLUS_GX_CART_BRAM_INFO_0_CHS,
      NULL,
      "system",
      {
         { "per cart", OPTION_VAL_PER_CART_CHS },
         { "per game", OPTION_VAL_PER_GAME_CHS },
         { NULL, NULL },
      },
      "per cart"
   },
   {
      "genesis_plus_gx_cart_size",
      GENESIS_PLUS_GX_CART_SIZE_LABEL_CHS,
      NULL,
      GENESIS_PLUS_GX_CART_SIZE_INFO_0_CHS,
      NULL,
      "system",
      {
         { "disabled", "Disabled" },
         { "128k",     OPTION_VAL_128K_CHS  },
         { "256k",     OPTION_VAL_256K_CHS  },
         { "512k",     OPTION_VAL_512K_CHS  },
         { "1meg",     OPTION_VAL_1MEG_CHS    },
         { "2meg",     OPTION_VAL_2MEG_CHS    },
         { "4meg",     OPTION_VAL_4MEG_CHS    },
         { NULL, NULL },
      },
      "4meg"
   },
   {
      "genesis_plus_gx_add_on",
      GENESIS_PLUS_GX_ADD_ON_LABEL_CHS,
      NULL,
      GENESIS_PLUS_GX_ADD_ON_INFO_0_CHS,
      NULL,
      "system",
      {
         { "auto",         OPTION_VAL_AUTO_CHS },
         { "sega/mega cd", OPTION_VAL_SEGA_MEGA_CD_CHS },
         { "megasd",       OPTION_VAL_MEGASD_CHS },
         { "none",         OPTION_VAL_NONE_CHS },
         { NULL, NULL },
      },
      "auto"
   },
   {
      "genesis_plus_gx_lock_on",
      GENESIS_PLUS_GX_LOCK_ON_LABEL_CHS,
      NULL,
      GENESIS_PLUS_GX_LOCK_ON_INFO_0_CHS,
      NULL,
      "system",
      {
         { "disabled",            NULL },
         { "game genie",          OPTION_VAL_GAME_GENIE_CHS },
         { "action replay (pro)", OPTION_VAL_ACTION_REPLAY_PRO_CHS },
         { "sonic & knuckles",    OPTION_VAL_SONIC_KNUCKLES_CHS },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_aspect_ratio",
      GENESIS_PLUS_GX_ASPECT_RATIO_LABEL_CHS,
      NULL,
      GENESIS_PLUS_GX_ASPECT_RATIO_INFO_0_CHS,
      NULL,
      "video",
      {
         { "auto",     OPTION_VAL_AUTO_CHS },
         { "NTSC PAR", OPTION_VAL_NTSC_PAR_CHS },
         { "PAL PAR",  OPTION_VAL_PAL_PAR_CHS },
         { "4:3",  OPTION_VAL_4_3_CHS },
         { "Uncorrected",  OPTION_VAL_UNCORRECTED_CHS },
      },
      "auto"
   },
   {
      "genesis_plus_gx_overscan",
      GENESIS_PLUS_GX_OVERSCAN_LABEL_CHS,
      NULL,
      GENESIS_PLUS_GX_OVERSCAN_INFO_0_CHS,
      NULL,
      "video",
      {
         { "disabled",   NULL },
         { "top/bottom", OPTION_VAL_TOP_BOTTOM_CHS },
         { "left/right", OPTION_VAL_LEFT_RIGHT_CHS },
         { "full",       OPTION_VAL_FULL_CHS },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_left_border",
      GENESIS_PLUS_GX_LEFT_BORDER_LABEL_CHS,
      NULL,
      GENESIS_PLUS_GX_LEFT_BORDER_INFO_0_CHS,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "left border", OPTION_VAL_LEFT_BORDER_CHS },
         { "left & right borders", OPTION_VAL_LEFT_RIGHT_BORDERS_CHS },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_gg_extra",
      GENESIS_PLUS_GX_GG_EXTRA_LABEL_CHS,
      NULL,
      GENESIS_PLUS_GX_GG_EXTRA_INFO_0_CHS,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_blargg_ntsc_filter",
      GENESIS_PLUS_GX_BLARGG_NTSC_FILTER_LABEL_CHS,
      NULL,
      GENESIS_PLUS_GX_BLARGG_NTSC_FILTER_INFO_0_CHS,
      NULL,
      "video",
      {
         { "disabled",   NULL },
         { "monochrome", OPTION_VAL_MONOCHROME_CHS },
         { "composite",  OPTION_VAL_COMPOSITE_CHS },
         { "svideo",     OPTION_VAL_SVIDEO_CHS },
         { "rgb",        OPTION_VAL_RGB_CHS },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_lcd_filter",
      GENESIS_PLUS_GX_LCD_FILTER_LABEL_CHS,
      NULL,
      GENESIS_PLUS_GX_LCD_FILTER_INFO_0_CHS,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_render",
      GENESIS_PLUS_GX_RENDER_LABEL_CHS,
      NULL,
      GENESIS_PLUS_GX_RENDER_INFO_0_CHS,
      NULL,
      "video",
      {
         { "single field", OPTION_VAL_SINGLE_FIELD_CHS },
         { "double field", OPTION_VAL_DOUBLE_FIELD_CHS },
         { NULL, NULL },
      },
      "single field"
   },
   {
      "genesis_plus_gx_frameskip",
      GENESIS_PLUS_GX_FRAMESKIP_LABEL_CHS,
      NULL,
      GENESIS_PLUS_GX_FRAMESKIP_INFO_0_CHS,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "auto",     OPTION_VAL_AUTO_CHS },
         { "manual",   OPTION_VAL_MANUAL_CHS },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_frameskip_threshold",
      GENESIS_PLUS_GX_FRAMESKIP_THRESHOLD_LABEL_CHS,
      NULL,
      GENESIS_PLUS_GX_FRAMESKIP_THRESHOLD_INFO_0_CHS,
      NULL,
      "video",
      {
         { "15", NULL },
         { "18", NULL },
         { "21", NULL },
         { "24", NULL },
         { "27", NULL },
         { "30", NULL },
         { "33", NULL },
         { "36", NULL },
         { "39", NULL },
         { "42", NULL },
         { "45", NULL },
         { "48", NULL },
         { "51", NULL },
         { "54", NULL },
         { "57", NULL },
         { "60", NULL },
         { NULL, NULL },
      },
      "33"
   },
   {
      "genesis_plus_gx_ym2413",
      GENESIS_PLUS_GX_YM2413_LABEL_CHS,
      NULL,
      GENESIS_PLUS_GX_YM2413_INFO_0_CHS,
      NULL,
      "audio",
      {
         { "auto",     OPTION_VAL_AUTO_CHS },
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "auto"
   },
#ifdef HAVE_OPLL_CORE
   {
      "genesis_plus_gx_ym2413_core",
      GENESIS_PLUS_GX_YM2413_CORE_LABEL_CHS,
      NULL,
      GENESIS_PLUS_GX_YM2413_CORE_INFO_0_CHS,
      NULL,
      "audio",
      {
         { "mame",  OPTION_VAL_MAME_CHS },
         { "nuked", OPTION_VAL_NUKED_CHS },
         { NULL, NULL },
      },
      "mame"
   },
#endif
   {
      "genesis_plus_gx_ym2612",
      GENESIS_PLUS_GX_YM2612_LABEL_CHS,
      NULL,
#ifdef HAVE_YM3438_CORE
      GENESIS_PLUS_GX_YM2612_INFO_0_CHS,
#else
      GENESIS_PLUS_GX_YM2612_INFO_1_CHS,
#endif
      NULL,
      "audio",
      {
         { "mame (ym2612)",          OPTION_VAL_MAME_YM2612_CHS },
         { "mame (asic ym3438)",     OPTION_VAL_MAME_ASIC_YM3438_CHS },
         { "mame (enhanced ym3438)", OPTION_VAL_MAME_ENHANCED_YM3438_CHS },
#ifdef HAVE_YM3438_CORE
         { "nuked (ym2612)",         OPTION_VAL_NUKED_YM2612_CHS },
         { "nuked (ym3438)",         OPTION_VAL_NUKED_YM3438_CHS },
#endif
         { NULL, NULL },
      },
      "mame (ym2612)"
   },
   {
      "genesis_plus_gx_sound_output",
      GENESIS_PLUS_GX_SOUND_OUTPUT_LABEL_CHS,
      NULL,
      GENESIS_PLUS_GX_SOUND_OUTPUT_INFO_0_CHS,
      NULL,
      "audio",
      {
         { "stereo", OPTION_VAL_STEREO_CHS },
         { "mono",   OPTION_VAL_MONO_CHS },
         { NULL, NULL },
      },
      "stereo"
   },
   {
      "genesis_plus_gx_audio_filter",
      GENESIS_PLUS_GX_AUDIO_FILTER_LABEL_CHS,
      NULL,
      GENESIS_PLUS_GX_AUDIO_FILTER_INFO_0_CHS,
      NULL,
      "audio",
      {
         { "disabled", NULL },
         { "low-pass", OPTION_VAL_LOW_PASS_CHS },
#ifdef HAVE_EQ
         { "EQ",       OPTION_VAL_EQ_CHS },
#endif
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_lowpass_range",
      GENESIS_PLUS_GX_LOWPASS_RANGE_LABEL_CHS,
      NULL,
      GENESIS_PLUS_GX_LOWPASS_RANGE_INFO_0_CHS,
      NULL,
      "audio",
      {
         { "5",  NULL },
         { "10", NULL },
         { "15", NULL },
         { "20", NULL },
         { "25", NULL },
         { "30", NULL },
         { "35", NULL },
         { "40", NULL },
         { "45", NULL },
         { "50", NULL },
         { "55", NULL },
         { "60", NULL },
         { "65", NULL },
         { "70", NULL },
         { "75", NULL },
         { "80", NULL },
         { "85", NULL },
         { "90", NULL },
         { "95", NULL },
         { NULL, NULL },
      },
      "60"
   },
   {
      "genesis_plus_gx_psg_preamp",
      GENESIS_PLUS_GX_PSG_PREAMP_LABEL_CHS,
      NULL,
      GENESIS_PLUS_GX_PSG_PREAMP_INFO_0_CHS,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { "105", NULL },
         { "110", NULL },
         { "115", NULL },
         { "120", NULL },
         { "125", NULL },
         { "130", NULL },
         { "135", NULL },
         { "140", NULL },
         { "145", NULL },
         { "150", NULL },
         { "155", NULL },
         { "160", NULL },
         { "165", NULL },
         { "170", NULL },
         { "175", NULL },
         { "180", NULL },
         { "185", NULL },
         { "190", NULL },
         { "195", NULL },
         { "200", NULL },
         { NULL, NULL },
      },
      "150"
   },
   {
      "genesis_plus_gx_fm_preamp",
      GENESIS_PLUS_GX_FM_PREAMP_LABEL_CHS,
      NULL,
      GENESIS_PLUS_GX_FM_PREAMP_INFO_0_CHS,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { "105", NULL },
         { "110", NULL },
         { "115", NULL },
         { "120", NULL },
         { "125", NULL },
         { "130", NULL },
         { "135", NULL },
         { "140", NULL },
         { "145", NULL },
         { "150", NULL },
         { "155", NULL },
         { "160", NULL },
         { "165", NULL },
         { "170", NULL },
         { "175", NULL },
         { "180", NULL },
         { "185", NULL },
         { "190", NULL },
         { "195", NULL },
         { "200", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_cdda_volume",
      GENESIS_PLUS_GX_CDDA_VOLUME_LABEL_CHS,
      NULL,
      GENESIS_PLUS_GX_CDDA_VOLUME_INFO_0_CHS,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_pcm_volume",
      GENESIS_PLUS_GX_PCM_VOLUME_LABEL_CHS,
      NULL,
      GENESIS_PLUS_GX_PCM_VOLUME_INFO_0_CHS,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
#ifdef HAVE_EQ
   {
      "genesis_plus_gx_audio_eq_low",
      GENESIS_PLUS_GX_AUDIO_EQ_LOW_LABEL_CHS,
      NULL,
      GENESIS_PLUS_GX_AUDIO_EQ_LOW_INFO_0_CHS,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_audio_eq_mid",
      GENESIS_PLUS_GX_AUDIO_EQ_MID_LABEL_CHS,
      NULL,
      GENESIS_PLUS_GX_AUDIO_EQ_MID_INFO_0_CHS,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_audio_eq_high",
      GENESIS_PLUS_GX_AUDIO_EQ_HIGH_LABEL_CHS,
      NULL,
      GENESIS_PLUS_GX_AUDIO_EQ_HIGH_INFO_0_CHS,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
#endif
   {
      "genesis_plus_gx_gun_input",
      GENESIS_PLUS_GX_GUN_INPUT_LABEL_CHS,
      NULL,
      GENESIS_PLUS_GX_GUN_INPUT_INFO_0_CHS,
      NULL,
      "input",
      {
         { "lightgun",    OPTION_VAL_LIGHTGUN_CHS },
         { "touchscreen", OPTION_VAL_TOUCHSCREEN_CHS },
         { NULL, NULL },
      },
      "lightgun"
   },
   {
      "genesis_plus_gx_gun_cursor",
      GENESIS_PLUS_GX_GUN_CURSOR_LABEL_CHS,
      NULL,
      GENESIS_PLUS_GX_GUN_CURSOR_INFO_0_CHS,
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_invert_mouse",
      GENESIS_PLUS_GX_INVERT_MOUSE_LABEL_CHS,
      NULL,
      GENESIS_PLUS_GX_INVERT_MOUSE_INFO_0_CHS,
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_no_sprite_limit",
      GENESIS_PLUS_GX_NO_SPRITE_LIMIT_LABEL_CHS,
      NULL,
      GENESIS_PLUS_GX_NO_SPRITE_LIMIT_INFO_0_CHS,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_enhanced_vscroll",
      GENESIS_PLUS_GX_ENHANCED_VSCROLL_LABEL_CHS,
      NULL,
      GENESIS_PLUS_GX_ENHANCED_VSCROLL_INFO_0_CHS,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_enhanced_vscroll_limit",
      GENESIS_PLUS_GX_ENHANCED_VSCROLL_LIMIT_LABEL_CHS,
      NULL,
      GENESIS_PLUS_GX_ENHANCED_VSCROLL_LIMIT_INFO_0_CHS,
      NULL,
      "hacks",
      {
         { "2", NULL },
         { "3",  NULL },
         { "4", NULL },
         { "5",  NULL },
         { "6", NULL },
         { "7",  NULL },
         { "8", NULL },
         { "9",  NULL },
         { "10", NULL },
         { "11",  NULL },
         { "12", NULL },
         { "13",  NULL },
         { "14", NULL },
         { "15",  NULL },
         { "16", NULL },
         { NULL, NULL },
      },
      "8"
   },
#ifdef HAVE_OVERCLOCK
   {
      "genesis_plus_gx_overclock",
      GENESIS_PLUS_GX_OVERCLOCK_LABEL_CHS,
      NULL,
      GENESIS_PLUS_GX_OVERCLOCK_INFO_0_CHS,
      NULL,
      "hacks",
      {
         { "100", OPTION_VAL_100_CHS },
         { "125", OPTION_VAL_125_CHS },
         { "150", OPTION_VAL_150_CHS },
         { "175", OPTION_VAL_175_CHS },
         { "200", OPTION_VAL_200_CHS },
         { "225", OPTION_VAL_225_CHS },
         { "250", OPTION_VAL_250_CHS },
         { "275", OPTION_VAL_275_CHS },
         { "300", OPTION_VAL_300_CHS },
         { "325", OPTION_VAL_325_CHS },
         { "350", OPTION_VAL_350_CHS },
         { "375", OPTION_VAL_375_CHS },
         { "400", OPTION_VAL_400_CHS },
         { "425", OPTION_VAL_425_CHS },
         { "450", OPTION_VAL_450_CHS },
         { "475", OPTION_VAL_475_CHS },
         { "500", OPTION_VAL_500_CHS },
         { NULL, NULL },
      },
      "100%"
   },
#endif
   {
      "genesis_plus_gx_force_dtack",
      GENESIS_PLUS_GX_FORCE_DTACK_LABEL_CHS,
      NULL,
      GENESIS_PLUS_GX_FORCE_DTACK_INFO_0_CHS,
      NULL,
      "hacks",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL },
      },
      "enabled"
   },
   {
      "genesis_plus_gx_addr_error",
      GENESIS_PLUS_GX_ADDR_ERROR_LABEL_CHS,
      NULL,
      GENESIS_PLUS_GX_ADDR_ERROR_INFO_0_CHS,
      NULL,
      "hacks",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL },
      },
      "enabled"
   },
   {
      "genesis_plus_gx_cd_latency",
      GENESIS_PLUS_GX_CD_LATENCY_LABEL_CHS,
      NULL,
      GENESIS_PLUS_GX_CD_LATENCY_INFO_0_CHS,
      NULL,
      "hacks",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL },
      },
      "enabled"
   },
   {
      "genesis_plus_gx_cd_precache",
      GENESIS_PLUS_GX_CD_PRECACHE_LABEL_CHS,
      NULL,
      GENESIS_PLUS_GX_CD_PRECACHE_INFO_0_CHS,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
#ifdef USE_PER_SOUND_CHANNELS_CONFIG
   {
      "genesis_plus_gx_show_advanced_audio_settings",
      GENESIS_PLUS_GX_SHOW_ADVANCED_AUDIO_SETTINGS_LABEL_CHS,
      NULL,
      GENESIS_PLUS_GX_SHOW_ADVANCED_AUDIO_SETTINGS_INFO_0_CHS,
      NULL,
      "channel_volume",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL},
      },
      "disabled"
   },
   {
      "genesis_plus_gx_psg_channel_0_volume",
      GENESIS_PLUS_GX_PSG_CHANNEL_0_VOLUME_LABEL_CHS,
      NULL,
      GENESIS_PLUS_GX_PSG_CHANNEL_0_VOLUME_INFO_0_CHS,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_psg_channel_1_volume",
      GENESIS_PLUS_GX_PSG_CHANNEL_1_VOLUME_LABEL_CHS,
      NULL,
      GENESIS_PLUS_GX_PSG_CHANNEL_1_VOLUME_INFO_0_CHS,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_psg_channel_2_volume",
      GENESIS_PLUS_GX_PSG_CHANNEL_2_VOLUME_LABEL_CHS,
      NULL,
      GENESIS_PLUS_GX_PSG_CHANNEL_2_VOLUME_INFO_0_CHS,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_psg_channel_3_volume",
      GENESIS_PLUS_GX_PSG_CHANNEL_3_VOLUME_LABEL_CHS,
      NULL,
      GENESIS_PLUS_GX_PSG_CHANNEL_3_VOLUME_INFO_0_CHS,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_0_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_0_VOLUME_LABEL_CHS,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_0_VOLUME_INFO_0_CHS,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_1_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_1_VOLUME_LABEL_CHS,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_1_VOLUME_INFO_0_CHS,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_2_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_2_VOLUME_LABEL_CHS,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_2_VOLUME_INFO_0_CHS,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_3_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_3_VOLUME_LABEL_CHS,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_3_VOLUME_INFO_0_CHS,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_4_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_4_VOLUME_LABEL_CHS,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_4_VOLUME_INFO_0_CHS,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_5_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_5_VOLUME_LABEL_CHS,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_5_VOLUME_INFO_0_CHS,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_0_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_0_VOLUME_LABEL_CHS,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_0_VOLUME_INFO_0_CHS,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_1_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_1_VOLUME_LABEL_CHS,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_1_VOLUME_INFO_0_CHS,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_2_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_2_VOLUME_LABEL_CHS,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_2_VOLUME_INFO_0_CHS,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_3_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_3_VOLUME_LABEL_CHS,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_3_VOLUME_INFO_0_CHS,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_4_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_4_VOLUME_LABEL_CHS,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_4_VOLUME_INFO_0_CHS,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_5_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_5_VOLUME_LABEL_CHS,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_5_VOLUME_INFO_0_CHS,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_6_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_6_VOLUME_LABEL_CHS,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_6_VOLUME_INFO_0_CHS,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_7_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_7_VOLUME_LABEL_CHS,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_7_VOLUME_INFO_0_CHS,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_8_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_8_VOLUME_LABEL_CHS,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_8_VOLUME_INFO_0_CHS,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
#endif
   { NULL, NULL, NULL, NULL, NULL, NULL, {{0}}, NULL },
};
struct retro_core_options_v2 options_chs = {
   option_cats_chs,
   option_defs_chs
};

/* RETRO_LANGUAGE_CHT */

#define CATEGORY_SYSTEM_LABEL_CHT "系統"
#define CATEGORY_SYSTEM_INFO_0_CHT NULL
#define CATEGORY_VIDEO_LABEL_CHT "顯示"
#define CATEGORY_VIDEO_INFO_0_CHT "變更長寬比、畫面裁剪、影像濾鏡和跳幀的設定。"
#define CATEGORY_AUDIO_LABEL_CHT "音效"
#define CATEGORY_AUDIO_INFO_0_CHT NULL
#define CATEGORY_INPUT_LABEL_CHT "輸入"
#define CATEGORY_INPUT_INFO_0_CHT NULL
#define CATEGORY_HACKS_LABEL_CHT "進階"
#define CATEGORY_HACKS_INFO_0_CHT "變更模擬器進階破解的設定。"
#define CATEGORY_CHANNEL_VOLUME_LABEL_CHT "音效 (進階音量設定)"
#define CATEGORY_CHANNEL_VOLUME_INFO_0_CHT NULL
#define GENESIS_PLUS_GX_SYSTEM_HW_LABEL_CHT "系統硬體"
#define GENESIS_PLUS_GX_SYSTEM_HW_INFO_0_CHT NULL
#define OPTION_VAL_AUTO_CHT "自動"
#define OPTION_VAL_SG_1000_CHT NULL
#define OPTION_VAL_SG_1000_II_CHT NULL
#define OPTION_VAL_SG_1000_II_RAM_EXT_CHT "SG-1000 II (記憶體擴充卡)"
#define OPTION_VAL_MARK_III_CHT NULL
#define OPTION_VAL_MASTER_SYSTEM_CHT NULL
#define OPTION_VAL_MASTER_SYSTEM_II_CHT NULL
#define OPTION_VAL_GAME_GEAR_CHT NULL
#define OPTION_VAL_MEGA_DRIVE_GENESIS_CHT "Mega Drive (Genesis)"
#define GENESIS_PLUS_GX_REGION_DETECT_LABEL_CHT "系統區域"
#define GENESIS_PLUS_GX_REGION_DETECT_INFO_0_CHT NULL
#define OPTION_VAL_NTSC_U_CHT NULL
#define OPTION_VAL_PAL_CHT NULL
#define OPTION_VAL_NTSC_J_CHT NULL
#define GENESIS_PLUS_GX_VDP_MODE_LABEL_CHT NULL
#define GENESIS_PLUS_GX_VDP_MODE_INFO_0_CHT NULL
#define OPTION_VAL_60HZ_CHT NULL
#define OPTION_VAL_50HZ_CHT NULL
#define GENESIS_PLUS_GX_BIOS_LABEL_CHT NULL
#define GENESIS_PLUS_GX_BIOS_INFO_0_CHT NULL
#define GENESIS_PLUS_GX_SYSTEM_BRAM_LABEL_CHT NULL
#define GENESIS_PLUS_GX_SYSTEM_BRAM_INFO_0_CHT NULL
#define OPTION_VAL_PER_BIOS_CHT NULL
#define OPTION_VAL_PER_GAME_CHT NULL
#define GENESIS_PLUS_GX_CART_BRAM_LABEL_CHT NULL
#define GENESIS_PLUS_GX_CART_BRAM_INFO_0_CHT NULL
#define OPTION_VAL_PER_CART_CHT NULL
#define GENESIS_PLUS_GX_CART_SIZE_LABEL_CHT NULL
#define GENESIS_PLUS_GX_CART_SIZE_INFO_0_CHT NULL
#define OPTION_VAL_128K_CHT NULL
#define OPTION_VAL_256K_CHT NULL
#define OPTION_VAL_512K_CHT NULL
#define OPTION_VAL_1MEG_CHT NULL
#define OPTION_VAL_2MEG_CHT NULL
#define OPTION_VAL_4MEG_CHT NULL
#define GENESIS_PLUS_GX_ADD_ON_LABEL_CHT NULL
#define GENESIS_PLUS_GX_ADD_ON_INFO_0_CHT NULL
#define OPTION_VAL_SEGA_MEGA_CD_CHT "光碟機 (Sega CD/Mega CD)"
#define OPTION_VAL_MEGASD_CHT "燒錄卡 (MegaSD)"
#define OPTION_VAL_NONE_CHT "無"
#define GENESIS_PLUS_GX_LOCK_ON_LABEL_CHT NULL
#define GENESIS_PLUS_GX_LOCK_ON_INFO_0_CHT NULL
#define OPTION_VAL_GAME_GENIE_CHT "遊戲精靈金手指擴充卡"
#define OPTION_VAL_ACTION_REPLAY_PRO_CHT "動作重播專業版金手指擴充卡"
#define OPTION_VAL_SONIC_KNUCKLES_CHT "索尼克與奈克魯斯擴充卡 (Sonic & Knuckles)"
#define GENESIS_PLUS_GX_ASPECT_RATIO_LABEL_CHT "寬高比 (核心參數)"
#define GENESIS_PLUS_GX_ASPECT_RATIO_INFO_0_CHT "設定畫面的寬高比, 僅限「設定/顯示/縮放」選項中, 設定「寬高比」為<核心參數>時使用。"
#define OPTION_VAL_NTSC_PAR_CHT "NTSC標準"
#define OPTION_VAL_PAL_PAR_CHT "PAL標準"
#define OPTION_VAL_4_3_CHT NULL
#define OPTION_VAL_UNCORRECTED_CHT "未調整"
#define GENESIS_PLUS_GX_OVERSCAN_LABEL_CHT "邊框"
#define GENESIS_PLUS_GX_OVERSCAN_INFO_0_CHT "設定顯示螢幕四邊的過度掃描區域。"
#define OPTION_VAL_TOP_BOTTOM_CHT "上下邊"
#define OPTION_VAL_LEFT_RIGHT_CHT "左右邊"
#define OPTION_VAL_FULL_CHT "四邊"
#define GENESIS_PLUS_GX_LEFT_BORDER_LABEL_CHT NULL
#define GENESIS_PLUS_GX_LEFT_BORDER_INFO_0_CHT NULL
#define OPTION_VAL_LEFT_BORDER_CHT NULL
#define OPTION_VAL_LEFT_RIGHT_BORDERS_CHT NULL
#define GENESIS_PLUS_GX_GG_EXTRA_LABEL_CHT NULL
#define GENESIS_PLUS_GX_GG_EXTRA_INFO_0_CHT NULL
#define GENESIS_PLUS_GX_BLARGG_NTSC_FILTER_LABEL_CHT "NTSC濾波器"
#define GENESIS_PLUS_GX_BLARGG_NTSC_FILTER_INFO_0_CHT "製作者Blargg編譯的NTSC濾波器, 用於模擬電視各種影像輸入信號的顯示效果。"
#define OPTION_VAL_MONOCHROME_CHT "黑白"
#define OPTION_VAL_COMPOSITE_CHT "AV端子 (複合端子)"
#define OPTION_VAL_SVIDEO_CHT "S-端子 (獨立視訊端子)"
#define OPTION_VAL_RGB_CHT "色差端子 (YPbPr)"
#define GENESIS_PLUS_GX_LCD_FILTER_LABEL_CHT NULL
#define GENESIS_PLUS_GX_LCD_FILTER_INFO_0_CHT NULL
#define GENESIS_PLUS_GX_RENDER_LABEL_CHT NULL
#define GENESIS_PLUS_GX_RENDER_INFO_0_CHT NULL
#define OPTION_VAL_SINGLE_FIELD_CHT NULL
#define OPTION_VAL_DOUBLE_FIELD_CHT NULL
#define GENESIS_PLUS_GX_FRAMESKIP_LABEL_CHT "跳幀"
#define GENESIS_PLUS_GX_FRAMESKIP_INFO_0_CHT "設定跳幀用以避免音訊緩衝區不足(產生破音), 用影像流暢度為代價提高效能。\n設定<自動>由前端系統控制跳幀, 設定<手動>由「跳幀上限(%)」控制跳幀。"
#define OPTION_VAL_MANUAL_CHT "手動"
#define GENESIS_PLUS_GX_FRAMESKIP_THRESHOLD_LABEL_CHT "跳幀上限 (%)"
#define GENESIS_PLUS_GX_FRAMESKIP_THRESHOLD_INFO_0_CHT "設定「跳幀」為<手動>時音頻緩衝區使用上限(%)。\n低於上限的影格將被跳過, 設定過高會導致頻繁丟失影格, 過低則是出現破音。"
#define GENESIS_PLUS_GX_YM2413_LABEL_CHT NULL
#define GENESIS_PLUS_GX_YM2413_INFO_0_CHT NULL
#define GENESIS_PLUS_GX_YM2413_CORE_LABEL_CHT "Master System FM (YM2413) 核心"
#define GENESIS_PLUS_GX_YM2413_CORE_INFO_0_CHT NULL
#define OPTION_VAL_MAME_CHT NULL
#define OPTION_VAL_NUKED_CHT NULL
#define GENESIS_PLUS_GX_YM2612_LABEL_CHT NULL
#define GENESIS_PLUS_GX_YM2612_INFO_0_CHT NULL
#define GENESIS_PLUS_GX_YM2612_INFO_1_CHT NULL
#define OPTION_VAL_MAME_YM2612_CHT NULL
#define OPTION_VAL_MAME_ASIC_YM3438_CHT NULL
#define OPTION_VAL_MAME_ENHANCED_YM3438_CHT NULL
#define OPTION_VAL_NUKED_YM2612_CHT NULL
#define OPTION_VAL_NUKED_YM3438_CHT NULL
#define GENESIS_PLUS_GX_SOUND_OUTPUT_LABEL_CHT NULL
#define GENESIS_PLUS_GX_SOUND_OUTPUT_INFO_0_CHT NULL
#define OPTION_VAL_STEREO_CHT "立體聲"
#define OPTION_VAL_MONO_CHT "單聲道"
#define GENESIS_PLUS_GX_AUDIO_FILTER_LABEL_CHT "音訊濾波器"
#define GENESIS_PLUS_GX_AUDIO_FILTER_INFO_0_CHT NULL
#define OPTION_VAL_LOW_PASS_CHT NULL
#define OPTION_VAL_EQ_CHT "等化器"
#define GENESIS_PLUS_GX_LOWPASS_RANGE_LABEL_CHT NULL
#define GENESIS_PLUS_GX_LOWPASS_RANGE_INFO_0_CHT NULL
#define GENESIS_PLUS_GX_PSG_PREAMP_LABEL_CHT "PSG前級增益"
#define GENESIS_PLUS_GX_PSG_PREAMP_INFO_0_CHT NULL
#define GENESIS_PLUS_GX_FM_PREAMP_LABEL_CHT "FM前級增益"
#define GENESIS_PLUS_GX_FM_PREAMP_INFO_0_CHT NULL
#define GENESIS_PLUS_GX_CDDA_VOLUME_LABEL_CHT NULL
#define GENESIS_PLUS_GX_CDDA_VOLUME_INFO_0_CHT NULL
#define GENESIS_PLUS_GX_PCM_VOLUME_LABEL_CHT NULL
#define GENESIS_PLUS_GX_PCM_VOLUME_INFO_0_CHT NULL
#define GENESIS_PLUS_GX_AUDIO_EQ_LOW_LABEL_CHT NULL
#define GENESIS_PLUS_GX_AUDIO_EQ_LOW_INFO_0_CHT NULL
#define GENESIS_PLUS_GX_AUDIO_EQ_MID_LABEL_CHT NULL
#define GENESIS_PLUS_GX_AUDIO_EQ_MID_INFO_0_CHT NULL
#define GENESIS_PLUS_GX_AUDIO_EQ_HIGH_LABEL_CHT NULL
#define GENESIS_PLUS_GX_AUDIO_EQ_HIGH_INFO_0_CHT NULL
#define GENESIS_PLUS_GX_GUN_INPUT_LABEL_CHT "光線槍輸入"
#define GENESIS_PLUS_GX_GUN_INPUT_INFO_0_CHT NULL
#define OPTION_VAL_LIGHTGUN_CHT "光線槍"
#define OPTION_VAL_TOUCHSCREEN_CHT "觸控螢幕"
#define GENESIS_PLUS_GX_GUN_CURSOR_LABEL_CHT NULL
#define GENESIS_PLUS_GX_GUN_CURSOR_INFO_0_CHT NULL
#define GENESIS_PLUS_GX_INVERT_MOUSE_LABEL_CHT NULL
#define GENESIS_PLUS_GX_INVERT_MOUSE_INFO_0_CHT NULL
#define GENESIS_PLUS_GX_NO_SPRITE_LIMIT_LABEL_CHT "移除物件限制"
#define GENESIS_PLUS_GX_NO_SPRITE_LIMIT_INFO_0_CHT "移除每條掃描線顯示物件數的硬體限制。\n減少畫面的閃爍但可能會導致圖形故障, 某些遊戲會利用硬體限制製作特殊效果。"
#define GENESIS_PLUS_GX_ENHANCED_VSCROLL_LABEL_CHT NULL
#define GENESIS_PLUS_GX_ENHANCED_VSCROLL_INFO_0_CHT NULL
#define GENESIS_PLUS_GX_ENHANCED_VSCROLL_LIMIT_LABEL_CHT NULL
#define GENESIS_PLUS_GX_ENHANCED_VSCROLL_LIMIT_INFO_0_CHT NULL
#define GENESIS_PLUS_GX_OVERCLOCK_LABEL_CHT NULL
#define GENESIS_PLUS_GX_OVERCLOCK_INFO_0_CHT NULL
#define OPTION_VAL_100_CHT NULL
#define OPTION_VAL_125_CHT NULL
#define OPTION_VAL_150_CHT NULL
#define OPTION_VAL_175_CHT NULL
#define OPTION_VAL_200_CHT NULL
#define OPTION_VAL_225_CHT NULL
#define OPTION_VAL_250_CHT NULL
#define OPTION_VAL_275_CHT NULL
#define OPTION_VAL_300_CHT NULL
#define OPTION_VAL_325_CHT NULL
#define OPTION_VAL_350_CHT NULL
#define OPTION_VAL_375_CHT NULL
#define OPTION_VAL_400_CHT NULL
#define OPTION_VAL_425_CHT NULL
#define OPTION_VAL_450_CHT NULL
#define OPTION_VAL_475_CHT NULL
#define OPTION_VAL_500_CHT NULL
#define GENESIS_PLUS_GX_FORCE_DTACK_LABEL_CHT NULL
#define GENESIS_PLUS_GX_FORCE_DTACK_INFO_0_CHT NULL
#define GENESIS_PLUS_GX_ADDR_ERROR_LABEL_CHT "68K 位置錯誤"
#define GENESIS_PLUS_GX_ADDR_ERROR_INFO_0_CHT NULL
#define GENESIS_PLUS_GX_CD_LATENCY_LABEL_CHT NULL
#define GENESIS_PLUS_GX_CD_LATENCY_INFO_0_CHT NULL
#define GENESIS_PLUS_GX_CD_PRECACHE_LABEL_CHT NULL
#define GENESIS_PLUS_GX_CD_PRECACHE_INFO_0_CHT NULL
#define GENESIS_PLUS_GX_SHOW_ADVANCED_AUDIO_SETTINGS_LABEL_CHT "顯示音量進階設定 (需要重開選單)"
#define GENESIS_PLUS_GX_SHOW_ADVANCED_AUDIO_SETTINGS_INFO_0_CHT "開啟低階音訊通道參數的設定。\n注意: 此選項變更時需要重新進入核心選項才能生效。"
#define GENESIS_PLUS_GX_PSG_CHANNEL_0_VOLUME_LABEL_CHT "PSG聲道0 (方波) 音量 %"
#define GENESIS_PLUS_GX_PSG_CHANNEL_0_VOLUME_INFO_0_CHT "設定PSG聲道0的音量。"
#define GENESIS_PLUS_GX_PSG_CHANNEL_1_VOLUME_LABEL_CHT "PSG聲道1 (方波) 音量 %"
#define GENESIS_PLUS_GX_PSG_CHANNEL_1_VOLUME_INFO_0_CHT "設定PSG聲道1的音量。"
#define GENESIS_PLUS_GX_PSG_CHANNEL_2_VOLUME_LABEL_CHT "PSG聲道2 (方波) 音量 %"
#define GENESIS_PLUS_GX_PSG_CHANNEL_2_VOLUME_INFO_0_CHT "設定PSG聲道2的音量。"
#define GENESIS_PLUS_GX_PSG_CHANNEL_3_VOLUME_LABEL_CHT "PSG聲道3 (雜訊) 音量 %"
#define GENESIS_PLUS_GX_PSG_CHANNEL_3_VOLUME_INFO_0_CHT "設定PSG聲道3的音量。"
#define GENESIS_PLUS_GX_MD_CHANNEL_0_VOLUME_LABEL_CHT "Mega Drive/Genesis 調頻通道 0 音量 %"
#define GENESIS_PLUS_GX_MD_CHANNEL_0_VOLUME_INFO_0_CHT NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_1_VOLUME_LABEL_CHT "Mega Drive/Genesis 調頻通道 1 音量 %"
#define GENESIS_PLUS_GX_MD_CHANNEL_1_VOLUME_INFO_0_CHT NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_2_VOLUME_LABEL_CHT "Mega Drive/Genesis 調頻通道 2 音量 %"
#define GENESIS_PLUS_GX_MD_CHANNEL_2_VOLUME_INFO_0_CHT NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_3_VOLUME_LABEL_CHT "Mega Drive/Genesis 調頻通道 3 音量 %"
#define GENESIS_PLUS_GX_MD_CHANNEL_3_VOLUME_INFO_0_CHT NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_4_VOLUME_LABEL_CHT "Mega Drive/Genesis 調頻通道 4 音量 %"
#define GENESIS_PLUS_GX_MD_CHANNEL_4_VOLUME_INFO_0_CHT NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_5_VOLUME_LABEL_CHT "Mega Drive/Genesis 調頻通道 5 音量 %"
#define GENESIS_PLUS_GX_MD_CHANNEL_5_VOLUME_INFO_0_CHT NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_0_VOLUME_LABEL_CHT NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_0_VOLUME_INFO_0_CHT NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_1_VOLUME_LABEL_CHT NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_1_VOLUME_INFO_0_CHT NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_2_VOLUME_LABEL_CHT NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_2_VOLUME_INFO_0_CHT NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_3_VOLUME_LABEL_CHT NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_3_VOLUME_INFO_0_CHT NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_4_VOLUME_LABEL_CHT NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_4_VOLUME_INFO_0_CHT NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_5_VOLUME_LABEL_CHT NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_5_VOLUME_INFO_0_CHT NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_6_VOLUME_LABEL_CHT NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_6_VOLUME_INFO_0_CHT NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_7_VOLUME_LABEL_CHT NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_7_VOLUME_INFO_0_CHT NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_8_VOLUME_LABEL_CHT NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_8_VOLUME_INFO_0_CHT NULL

struct retro_core_option_v2_category option_cats_cht[] = {
   {
      "system",
      CATEGORY_SYSTEM_LABEL_CHT,
      CATEGORY_SYSTEM_INFO_0_CHT
   },
   {
      "video",
      CATEGORY_VIDEO_LABEL_CHT,
      CATEGORY_VIDEO_INFO_0_CHT
   },
   {
      "audio",
      CATEGORY_AUDIO_LABEL_CHT,
      CATEGORY_AUDIO_INFO_0_CHT
   },
   {
      "input",
      CATEGORY_INPUT_LABEL_CHT,
      CATEGORY_INPUT_INFO_0_CHT
   },
   {
      "hacks",
      CATEGORY_HACKS_LABEL_CHT,
      CATEGORY_HACKS_INFO_0_CHT
   },
   {
      "channel_volume",
      CATEGORY_CHANNEL_VOLUME_LABEL_CHT,
      CATEGORY_CHANNEL_VOLUME_INFO_0_CHT
   },
   { NULL, NULL, NULL },
};
struct retro_core_option_v2_definition option_defs_cht[] = {
   {
      "genesis_plus_gx_system_hw",
      GENESIS_PLUS_GX_SYSTEM_HW_LABEL_CHT,
      NULL,
      GENESIS_PLUS_GX_SYSTEM_HW_INFO_0_CHT,
      NULL,
      "system",
      {
         { "auto",                 OPTION_VAL_AUTO_CHT                 },
         { "sg-1000",              OPTION_VAL_SG_1000_CHT              },
         { "sg-1000 II",           OPTION_VAL_SG_1000_II_CHT           },
         { "sg-1000 II + ram ext.",OPTION_VAL_SG_1000_II_RAM_EXT_CHT},
         { "mark-III",             OPTION_VAL_MARK_III_CHT             },
         { "master system",        OPTION_VAL_MASTER_SYSTEM_CHT        },
         { "master system II",     OPTION_VAL_MASTER_SYSTEM_II_CHT     },
         { "game gear",            OPTION_VAL_GAME_GEAR_CHT            },
         { "mega drive / genesis", OPTION_VAL_MEGA_DRIVE_GENESIS_CHT   },
         { NULL, NULL },
      },
      "auto"
   },
   {
      "genesis_plus_gx_region_detect",
      GENESIS_PLUS_GX_REGION_DETECT_LABEL_CHT,
      NULL,
      GENESIS_PLUS_GX_REGION_DETECT_INFO_0_CHT,
      NULL,
      "system",
      {
         { "auto",    OPTION_VAL_AUTO_CHT   },
         { "ntsc-u",  OPTION_VAL_NTSC_U_CHT },
         { "pal",     OPTION_VAL_PAL_CHT    },
         { "ntsc-j",  OPTION_VAL_NTSC_J_CHT },
         { NULL, NULL },
      },
      "auto"
   },
   {
      "genesis_plus_gx_vdp_mode",
      GENESIS_PLUS_GX_VDP_MODE_LABEL_CHT,
      NULL,
      GENESIS_PLUS_GX_VDP_MODE_INFO_0_CHT,
      NULL,
      "system",
      {
         { "auto",  "Disabled" },
         { "60hz",  OPTION_VAL_60HZ_CHT },
         { "50hz",  OPTION_VAL_50HZ_CHT },
         { NULL, NULL },
      },
      "auto"
   },
   {
      "genesis_plus_gx_bios",
      GENESIS_PLUS_GX_BIOS_LABEL_CHT,
      NULL,
      GENESIS_PLUS_GX_BIOS_INFO_0_CHT,
      NULL,
      "system",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_system_bram",
      GENESIS_PLUS_GX_SYSTEM_BRAM_LABEL_CHT,
      NULL,
      GENESIS_PLUS_GX_SYSTEM_BRAM_INFO_0_CHT,
      NULL,
      "system",
      {
         { "per bios", OPTION_VAL_PER_BIOS_CHT },
         { "per game", OPTION_VAL_PER_GAME_CHT },
         { NULL, NULL },
      },
      "per bios"
   },
   {
      "genesis_plus_gx_cart_bram",
      GENESIS_PLUS_GX_CART_BRAM_LABEL_CHT,
      NULL,
      GENESIS_PLUS_GX_CART_BRAM_INFO_0_CHT,
      NULL,
      "system",
      {
         { "per cart", OPTION_VAL_PER_CART_CHT },
         { "per game", OPTION_VAL_PER_GAME_CHT },
         { NULL, NULL },
      },
      "per cart"
   },
   {
      "genesis_plus_gx_cart_size",
      GENESIS_PLUS_GX_CART_SIZE_LABEL_CHT,
      NULL,
      GENESIS_PLUS_GX_CART_SIZE_INFO_0_CHT,
      NULL,
      "system",
      {
         { "disabled", "Disabled" },
         { "128k",     OPTION_VAL_128K_CHT  },
         { "256k",     OPTION_VAL_256K_CHT  },
         { "512k",     OPTION_VAL_512K_CHT  },
         { "1meg",     OPTION_VAL_1MEG_CHT    },
         { "2meg",     OPTION_VAL_2MEG_CHT    },
         { "4meg",     OPTION_VAL_4MEG_CHT    },
         { NULL, NULL },
      },
      "4meg"
   },
   {
      "genesis_plus_gx_add_on",
      GENESIS_PLUS_GX_ADD_ON_LABEL_CHT,
      NULL,
      GENESIS_PLUS_GX_ADD_ON_INFO_0_CHT,
      NULL,
      "system",
      {
         { "auto",         OPTION_VAL_AUTO_CHT },
         { "sega/mega cd", OPTION_VAL_SEGA_MEGA_CD_CHT },
         { "megasd",       OPTION_VAL_MEGASD_CHT },
         { "none",         OPTION_VAL_NONE_CHT },
         { NULL, NULL },
      },
      "auto"
   },
   {
      "genesis_plus_gx_lock_on",
      GENESIS_PLUS_GX_LOCK_ON_LABEL_CHT,
      NULL,
      GENESIS_PLUS_GX_LOCK_ON_INFO_0_CHT,
      NULL,
      "system",
      {
         { "disabled",            NULL },
         { "game genie",          OPTION_VAL_GAME_GENIE_CHT },
         { "action replay (pro)", OPTION_VAL_ACTION_REPLAY_PRO_CHT },
         { "sonic & knuckles",    OPTION_VAL_SONIC_KNUCKLES_CHT },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_aspect_ratio",
      GENESIS_PLUS_GX_ASPECT_RATIO_LABEL_CHT,
      NULL,
      GENESIS_PLUS_GX_ASPECT_RATIO_INFO_0_CHT,
      NULL,
      "video",
      {
         { "auto",     OPTION_VAL_AUTO_CHT },
         { "NTSC PAR", OPTION_VAL_NTSC_PAR_CHT },
         { "PAL PAR",  OPTION_VAL_PAL_PAR_CHT },
         { "4:3",  OPTION_VAL_4_3_CHT },
         { "Uncorrected",  OPTION_VAL_UNCORRECTED_CHT },
      },
      "auto"
   },
   {
      "genesis_plus_gx_overscan",
      GENESIS_PLUS_GX_OVERSCAN_LABEL_CHT,
      NULL,
      GENESIS_PLUS_GX_OVERSCAN_INFO_0_CHT,
      NULL,
      "video",
      {
         { "disabled",   NULL },
         { "top/bottom", OPTION_VAL_TOP_BOTTOM_CHT },
         { "left/right", OPTION_VAL_LEFT_RIGHT_CHT },
         { "full",       OPTION_VAL_FULL_CHT },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_left_border",
      GENESIS_PLUS_GX_LEFT_BORDER_LABEL_CHT,
      NULL,
      GENESIS_PLUS_GX_LEFT_BORDER_INFO_0_CHT,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "left border", OPTION_VAL_LEFT_BORDER_CHT },
         { "left & right borders", OPTION_VAL_LEFT_RIGHT_BORDERS_CHT },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_gg_extra",
      GENESIS_PLUS_GX_GG_EXTRA_LABEL_CHT,
      NULL,
      GENESIS_PLUS_GX_GG_EXTRA_INFO_0_CHT,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_blargg_ntsc_filter",
      GENESIS_PLUS_GX_BLARGG_NTSC_FILTER_LABEL_CHT,
      NULL,
      GENESIS_PLUS_GX_BLARGG_NTSC_FILTER_INFO_0_CHT,
      NULL,
      "video",
      {
         { "disabled",   NULL },
         { "monochrome", OPTION_VAL_MONOCHROME_CHT },
         { "composite",  OPTION_VAL_COMPOSITE_CHT },
         { "svideo",     OPTION_VAL_SVIDEO_CHT },
         { "rgb",        OPTION_VAL_RGB_CHT },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_lcd_filter",
      GENESIS_PLUS_GX_LCD_FILTER_LABEL_CHT,
      NULL,
      GENESIS_PLUS_GX_LCD_FILTER_INFO_0_CHT,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_render",
      GENESIS_PLUS_GX_RENDER_LABEL_CHT,
      NULL,
      GENESIS_PLUS_GX_RENDER_INFO_0_CHT,
      NULL,
      "video",
      {
         { "single field", OPTION_VAL_SINGLE_FIELD_CHT },
         { "double field", OPTION_VAL_DOUBLE_FIELD_CHT },
         { NULL, NULL },
      },
      "single field"
   },
   {
      "genesis_plus_gx_frameskip",
      GENESIS_PLUS_GX_FRAMESKIP_LABEL_CHT,
      NULL,
      GENESIS_PLUS_GX_FRAMESKIP_INFO_0_CHT,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "auto",     OPTION_VAL_AUTO_CHT },
         { "manual",   OPTION_VAL_MANUAL_CHT },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_frameskip_threshold",
      GENESIS_PLUS_GX_FRAMESKIP_THRESHOLD_LABEL_CHT,
      NULL,
      GENESIS_PLUS_GX_FRAMESKIP_THRESHOLD_INFO_0_CHT,
      NULL,
      "video",
      {
         { "15", NULL },
         { "18", NULL },
         { "21", NULL },
         { "24", NULL },
         { "27", NULL },
         { "30", NULL },
         { "33", NULL },
         { "36", NULL },
         { "39", NULL },
         { "42", NULL },
         { "45", NULL },
         { "48", NULL },
         { "51", NULL },
         { "54", NULL },
         { "57", NULL },
         { "60", NULL },
         { NULL, NULL },
      },
      "33"
   },
   {
      "genesis_plus_gx_ym2413",
      GENESIS_PLUS_GX_YM2413_LABEL_CHT,
      NULL,
      GENESIS_PLUS_GX_YM2413_INFO_0_CHT,
      NULL,
      "audio",
      {
         { "auto",     OPTION_VAL_AUTO_CHT },
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "auto"
   },
#ifdef HAVE_OPLL_CORE
   {
      "genesis_plus_gx_ym2413_core",
      GENESIS_PLUS_GX_YM2413_CORE_LABEL_CHT,
      NULL,
      GENESIS_PLUS_GX_YM2413_CORE_INFO_0_CHT,
      NULL,
      "audio",
      {
         { "mame",  OPTION_VAL_MAME_CHT },
         { "nuked", OPTION_VAL_NUKED_CHT },
         { NULL, NULL },
      },
      "mame"
   },
#endif
   {
      "genesis_plus_gx_ym2612",
      GENESIS_PLUS_GX_YM2612_LABEL_CHT,
      NULL,
#ifdef HAVE_YM3438_CORE
      GENESIS_PLUS_GX_YM2612_INFO_0_CHT,
#else
      GENESIS_PLUS_GX_YM2612_INFO_1_CHT,
#endif
      NULL,
      "audio",
      {
         { "mame (ym2612)",          OPTION_VAL_MAME_YM2612_CHT },
         { "mame (asic ym3438)",     OPTION_VAL_MAME_ASIC_YM3438_CHT },
         { "mame (enhanced ym3438)", OPTION_VAL_MAME_ENHANCED_YM3438_CHT },
#ifdef HAVE_YM3438_CORE
         { "nuked (ym2612)",         OPTION_VAL_NUKED_YM2612_CHT },
         { "nuked (ym3438)",         OPTION_VAL_NUKED_YM3438_CHT },
#endif
         { NULL, NULL },
      },
      "mame (ym2612)"
   },
   {
      "genesis_plus_gx_sound_output",
      GENESIS_PLUS_GX_SOUND_OUTPUT_LABEL_CHT,
      NULL,
      GENESIS_PLUS_GX_SOUND_OUTPUT_INFO_0_CHT,
      NULL,
      "audio",
      {
         { "stereo", OPTION_VAL_STEREO_CHT },
         { "mono",   OPTION_VAL_MONO_CHT },
         { NULL, NULL },
      },
      "stereo"
   },
   {
      "genesis_plus_gx_audio_filter",
      GENESIS_PLUS_GX_AUDIO_FILTER_LABEL_CHT,
      NULL,
      GENESIS_PLUS_GX_AUDIO_FILTER_INFO_0_CHT,
      NULL,
      "audio",
      {
         { "disabled", NULL },
         { "low-pass", OPTION_VAL_LOW_PASS_CHT },
#ifdef HAVE_EQ
         { "EQ",       OPTION_VAL_EQ_CHT },
#endif
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_lowpass_range",
      GENESIS_PLUS_GX_LOWPASS_RANGE_LABEL_CHT,
      NULL,
      GENESIS_PLUS_GX_LOWPASS_RANGE_INFO_0_CHT,
      NULL,
      "audio",
      {
         { "5",  NULL },
         { "10", NULL },
         { "15", NULL },
         { "20", NULL },
         { "25", NULL },
         { "30", NULL },
         { "35", NULL },
         { "40", NULL },
         { "45", NULL },
         { "50", NULL },
         { "55", NULL },
         { "60", NULL },
         { "65", NULL },
         { "70", NULL },
         { "75", NULL },
         { "80", NULL },
         { "85", NULL },
         { "90", NULL },
         { "95", NULL },
         { NULL, NULL },
      },
      "60"
   },
   {
      "genesis_plus_gx_psg_preamp",
      GENESIS_PLUS_GX_PSG_PREAMP_LABEL_CHT,
      NULL,
      GENESIS_PLUS_GX_PSG_PREAMP_INFO_0_CHT,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { "105", NULL },
         { "110", NULL },
         { "115", NULL },
         { "120", NULL },
         { "125", NULL },
         { "130", NULL },
         { "135", NULL },
         { "140", NULL },
         { "145", NULL },
         { "150", NULL },
         { "155", NULL },
         { "160", NULL },
         { "165", NULL },
         { "170", NULL },
         { "175", NULL },
         { "180", NULL },
         { "185", NULL },
         { "190", NULL },
         { "195", NULL },
         { "200", NULL },
         { NULL, NULL },
      },
      "150"
   },
   {
      "genesis_plus_gx_fm_preamp",
      GENESIS_PLUS_GX_FM_PREAMP_LABEL_CHT,
      NULL,
      GENESIS_PLUS_GX_FM_PREAMP_INFO_0_CHT,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { "105", NULL },
         { "110", NULL },
         { "115", NULL },
         { "120", NULL },
         { "125", NULL },
         { "130", NULL },
         { "135", NULL },
         { "140", NULL },
         { "145", NULL },
         { "150", NULL },
         { "155", NULL },
         { "160", NULL },
         { "165", NULL },
         { "170", NULL },
         { "175", NULL },
         { "180", NULL },
         { "185", NULL },
         { "190", NULL },
         { "195", NULL },
         { "200", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_cdda_volume",
      GENESIS_PLUS_GX_CDDA_VOLUME_LABEL_CHT,
      NULL,
      GENESIS_PLUS_GX_CDDA_VOLUME_INFO_0_CHT,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_pcm_volume",
      GENESIS_PLUS_GX_PCM_VOLUME_LABEL_CHT,
      NULL,
      GENESIS_PLUS_GX_PCM_VOLUME_INFO_0_CHT,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
#ifdef HAVE_EQ
   {
      "genesis_plus_gx_audio_eq_low",
      GENESIS_PLUS_GX_AUDIO_EQ_LOW_LABEL_CHT,
      NULL,
      GENESIS_PLUS_GX_AUDIO_EQ_LOW_INFO_0_CHT,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_audio_eq_mid",
      GENESIS_PLUS_GX_AUDIO_EQ_MID_LABEL_CHT,
      NULL,
      GENESIS_PLUS_GX_AUDIO_EQ_MID_INFO_0_CHT,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_audio_eq_high",
      GENESIS_PLUS_GX_AUDIO_EQ_HIGH_LABEL_CHT,
      NULL,
      GENESIS_PLUS_GX_AUDIO_EQ_HIGH_INFO_0_CHT,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
#endif
   {
      "genesis_plus_gx_gun_input",
      GENESIS_PLUS_GX_GUN_INPUT_LABEL_CHT,
      NULL,
      GENESIS_PLUS_GX_GUN_INPUT_INFO_0_CHT,
      NULL,
      "input",
      {
         { "lightgun",    OPTION_VAL_LIGHTGUN_CHT },
         { "touchscreen", OPTION_VAL_TOUCHSCREEN_CHT },
         { NULL, NULL },
      },
      "lightgun"
   },
   {
      "genesis_plus_gx_gun_cursor",
      GENESIS_PLUS_GX_GUN_CURSOR_LABEL_CHT,
      NULL,
      GENESIS_PLUS_GX_GUN_CURSOR_INFO_0_CHT,
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_invert_mouse",
      GENESIS_PLUS_GX_INVERT_MOUSE_LABEL_CHT,
      NULL,
      GENESIS_PLUS_GX_INVERT_MOUSE_INFO_0_CHT,
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_no_sprite_limit",
      GENESIS_PLUS_GX_NO_SPRITE_LIMIT_LABEL_CHT,
      NULL,
      GENESIS_PLUS_GX_NO_SPRITE_LIMIT_INFO_0_CHT,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_enhanced_vscroll",
      GENESIS_PLUS_GX_ENHANCED_VSCROLL_LABEL_CHT,
      NULL,
      GENESIS_PLUS_GX_ENHANCED_VSCROLL_INFO_0_CHT,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_enhanced_vscroll_limit",
      GENESIS_PLUS_GX_ENHANCED_VSCROLL_LIMIT_LABEL_CHT,
      NULL,
      GENESIS_PLUS_GX_ENHANCED_VSCROLL_LIMIT_INFO_0_CHT,
      NULL,
      "hacks",
      {
         { "2", NULL },
         { "3",  NULL },
         { "4", NULL },
         { "5",  NULL },
         { "6", NULL },
         { "7",  NULL },
         { "8", NULL },
         { "9",  NULL },
         { "10", NULL },
         { "11",  NULL },
         { "12", NULL },
         { "13",  NULL },
         { "14", NULL },
         { "15",  NULL },
         { "16", NULL },
         { NULL, NULL },
      },
      "8"
   },
#ifdef HAVE_OVERCLOCK
   {
      "genesis_plus_gx_overclock",
      GENESIS_PLUS_GX_OVERCLOCK_LABEL_CHT,
      NULL,
      GENESIS_PLUS_GX_OVERCLOCK_INFO_0_CHT,
      NULL,
      "hacks",
      {
         { "100", OPTION_VAL_100_CHT },
         { "125", OPTION_VAL_125_CHT },
         { "150", OPTION_VAL_150_CHT },
         { "175", OPTION_VAL_175_CHT },
         { "200", OPTION_VAL_200_CHT },
         { "225", OPTION_VAL_225_CHT },
         { "250", OPTION_VAL_250_CHT },
         { "275", OPTION_VAL_275_CHT },
         { "300", OPTION_VAL_300_CHT },
         { "325", OPTION_VAL_325_CHT },
         { "350", OPTION_VAL_350_CHT },
         { "375", OPTION_VAL_375_CHT },
         { "400", OPTION_VAL_400_CHT },
         { "425", OPTION_VAL_425_CHT },
         { "450", OPTION_VAL_450_CHT },
         { "475", OPTION_VAL_475_CHT },
         { "500", OPTION_VAL_500_CHT },
         { NULL, NULL },
      },
      "100%"
   },
#endif
   {
      "genesis_plus_gx_force_dtack",
      GENESIS_PLUS_GX_FORCE_DTACK_LABEL_CHT,
      NULL,
      GENESIS_PLUS_GX_FORCE_DTACK_INFO_0_CHT,
      NULL,
      "hacks",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL },
      },
      "enabled"
   },
   {
      "genesis_plus_gx_addr_error",
      GENESIS_PLUS_GX_ADDR_ERROR_LABEL_CHT,
      NULL,
      GENESIS_PLUS_GX_ADDR_ERROR_INFO_0_CHT,
      NULL,
      "hacks",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL },
      },
      "enabled"
   },
   {
      "genesis_plus_gx_cd_latency",
      GENESIS_PLUS_GX_CD_LATENCY_LABEL_CHT,
      NULL,
      GENESIS_PLUS_GX_CD_LATENCY_INFO_0_CHT,
      NULL,
      "hacks",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL },
      },
      "enabled"
   },
   {
      "genesis_plus_gx_cd_precache",
      GENESIS_PLUS_GX_CD_PRECACHE_LABEL_CHT,
      NULL,
      GENESIS_PLUS_GX_CD_PRECACHE_INFO_0_CHT,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
#ifdef USE_PER_SOUND_CHANNELS_CONFIG
   {
      "genesis_plus_gx_show_advanced_audio_settings",
      GENESIS_PLUS_GX_SHOW_ADVANCED_AUDIO_SETTINGS_LABEL_CHT,
      NULL,
      GENESIS_PLUS_GX_SHOW_ADVANCED_AUDIO_SETTINGS_INFO_0_CHT,
      NULL,
      "channel_volume",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL},
      },
      "disabled"
   },
   {
      "genesis_plus_gx_psg_channel_0_volume",
      GENESIS_PLUS_GX_PSG_CHANNEL_0_VOLUME_LABEL_CHT,
      NULL,
      GENESIS_PLUS_GX_PSG_CHANNEL_0_VOLUME_INFO_0_CHT,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_psg_channel_1_volume",
      GENESIS_PLUS_GX_PSG_CHANNEL_1_VOLUME_LABEL_CHT,
      NULL,
      GENESIS_PLUS_GX_PSG_CHANNEL_1_VOLUME_INFO_0_CHT,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_psg_channel_2_volume",
      GENESIS_PLUS_GX_PSG_CHANNEL_2_VOLUME_LABEL_CHT,
      NULL,
      GENESIS_PLUS_GX_PSG_CHANNEL_2_VOLUME_INFO_0_CHT,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_psg_channel_3_volume",
      GENESIS_PLUS_GX_PSG_CHANNEL_3_VOLUME_LABEL_CHT,
      NULL,
      GENESIS_PLUS_GX_PSG_CHANNEL_3_VOLUME_INFO_0_CHT,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_0_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_0_VOLUME_LABEL_CHT,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_0_VOLUME_INFO_0_CHT,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_1_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_1_VOLUME_LABEL_CHT,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_1_VOLUME_INFO_0_CHT,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_2_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_2_VOLUME_LABEL_CHT,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_2_VOLUME_INFO_0_CHT,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_3_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_3_VOLUME_LABEL_CHT,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_3_VOLUME_INFO_0_CHT,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_4_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_4_VOLUME_LABEL_CHT,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_4_VOLUME_INFO_0_CHT,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_5_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_5_VOLUME_LABEL_CHT,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_5_VOLUME_INFO_0_CHT,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_0_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_0_VOLUME_LABEL_CHT,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_0_VOLUME_INFO_0_CHT,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_1_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_1_VOLUME_LABEL_CHT,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_1_VOLUME_INFO_0_CHT,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_2_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_2_VOLUME_LABEL_CHT,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_2_VOLUME_INFO_0_CHT,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_3_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_3_VOLUME_LABEL_CHT,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_3_VOLUME_INFO_0_CHT,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_4_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_4_VOLUME_LABEL_CHT,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_4_VOLUME_INFO_0_CHT,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_5_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_5_VOLUME_LABEL_CHT,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_5_VOLUME_INFO_0_CHT,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_6_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_6_VOLUME_LABEL_CHT,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_6_VOLUME_INFO_0_CHT,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_7_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_7_VOLUME_LABEL_CHT,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_7_VOLUME_INFO_0_CHT,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_8_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_8_VOLUME_LABEL_CHT,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_8_VOLUME_INFO_0_CHT,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
#endif
   { NULL, NULL, NULL, NULL, NULL, NULL, {{0}}, NULL },
};
struct retro_core_options_v2 options_cht = {
   option_cats_cht,
   option_defs_cht
};

/* RETRO_LANGUAGE_CS */

#define CATEGORY_SYSTEM_LABEL_CS "Systém"
#define CATEGORY_SYSTEM_INFO_0_CS "Změna výběru základního hardwaru, regionu, BIOSu a nastavení ukládacích souborů Sega CD/Mega-CD."
#define CATEGORY_VIDEO_LABEL_CS NULL
#define CATEGORY_VIDEO_INFO_0_CS "Změňte poměr stran, oříznutí displeje, filtr videa a nastavení přeskakování snímků."
#define CATEGORY_AUDIO_LABEL_CS "Zvuk"
#define CATEGORY_AUDIO_INFO_0_CS "Změna nastavení zvukového zařízení."
#define CATEGORY_INPUT_LABEL_CS "Vstup"
#define CATEGORY_INPUT_INFO_0_CS "Změna nastavení světelné pistole a/nebo vstupu myši."
#define CATEGORY_HACKS_LABEL_CS "Emulace hacků"
#define CATEGORY_HACKS_INFO_0_CS "Změna nastavení přetaktování procesoru a přesnosti emulace, které ovlivňují výkon a kompatibilitu na nízké úrovni."
#define CATEGORY_CHANNEL_VOLUME_LABEL_CS "Rozšířené nastavení hlasitosti kanálů"
#define CATEGORY_CHANNEL_VOLUME_INFO_0_CS "Změna hlasitosti jednotlivých hardwarových zvukových kanálů."
#define GENESIS_PLUS_GX_SYSTEM_HW_LABEL_CS "Systémový Hardware"
#define GENESIS_PLUS_GX_SYSTEM_HW_INFO_0_CS "Spustí načtený obsah s konkrétní emulovanou konzolí. 'Auto' vybere nejvhodnější systém pro aktuální hru."
#define OPTION_VAL_AUTO_CS NULL
#define OPTION_VAL_SG_1000_CS NULL
#define OPTION_VAL_SG_1000_II_CS NULL
#define OPTION_VAL_SG_1000_II_RAM_EXT_CS NULL
#define OPTION_VAL_MARK_III_CS NULL
#define OPTION_VAL_MASTER_SYSTEM_CS NULL
#define OPTION_VAL_MASTER_SYSTEM_II_CS NULL
#define OPTION_VAL_GAME_GEAR_CS NULL
#define OPTION_VAL_MEGA_DRIVE_GENESIS_CS NULL
#define GENESIS_PLUS_GX_REGION_DETECT_LABEL_CS "Systémový Region"
#define GENESIS_PLUS_GX_REGION_DETECT_INFO_0_CS "Zadejte, z jaké oblasti systém pochází. U konzolí jiných než Game Gear znamená 'PAL' 50 Hz, zatímco 'NTSC' 60 Hz. Pokud je vybrán nesprávný region, mohou hry běžet rychleji nebo pomaleji než obvykle."
#define OPTION_VAL_NTSC_U_CS NULL
#define OPTION_VAL_PAL_CS NULL
#define OPTION_VAL_NTSC_J_CS NULL
#define GENESIS_PLUS_GX_VDP_MODE_LABEL_CS "Vynucení režimu VDP"
#define GENESIS_PLUS_GX_VDP_MODE_INFO_0_CS "Přepíše režim VDP a přinutí jej běžet buď v režimu NTSC 60 Hz, nebo PAL 50 Hz, bez ohledu na oblast systému."
#define OPTION_VAL_60HZ_CS NULL
#define OPTION_VAL_50HZ_CS NULL
#define GENESIS_PLUS_GX_BIOS_LABEL_CS "Systém Boot ROM"
#define GENESIS_PLUS_GX_BIOS_INFO_0_CS "Použijte oficiální BIOS/bootloader pro emulovaný hardware, pokud je přítomen v systémovém adresáři aplikace RetroArch. Zobrazí spouštěcí sekvenci/animaci specifickou pro konzoli a poté spustí načtený obsah."
#define GENESIS_PLUS_GX_SYSTEM_BRAM_LABEL_CS "CD System BRAM (Vyžaduje restart)"
#define GENESIS_PLUS_GX_SYSTEM_BRAM_INFO_0_CS "Při spouštění obsahu Sega CD/Mega-CD určuje, zda se má sdílet jeden ukládací soubor pro všechny hry z určité oblasti (Pro-BIOS), nebo zda se má pro každou hru vytvořit samostatný ukládací soubor (Pro-Hru). Všimněte si, že Sega CD/Mega-CD má omezenou vnitřní paměť, která stačí pouze pro několik titulů. Abyste se vyhnuli nedostatku místa, doporučujeme použít nastavení \"Pro-Hru\"."
#define OPTION_VAL_PER_BIOS_CS "Na-BIOS"
#define OPTION_VAL_PER_GAME_CS "Na-Hru"
#define GENESIS_PLUS_GX_CART_BRAM_LABEL_CS "CD Záložní koš BRAM (Vyžaduje restart)"
#define GENESIS_PLUS_GX_CART_BRAM_INFO_0_CS "Při spouštění obsahu Sega CD/Mega-CD určuje, zda má být pro všechny hry sdílena jedna záložní ram koš (Pro-Koš), nebo zda má být pro každou hru vytvořena samostatná záložní ram koš (Pro-Hru)."
#define OPTION_VAL_PER_CART_CS "Pro-Koš"
#define GENESIS_PLUS_GX_CART_SIZE_LABEL_CS "Velikost BRAM záložního koše CD (Vyžaduje restart)"
#define GENESIS_PLUS_GX_CART_SIZE_INFO_0_CS "Nastavuje velikost záložního ram koše při spouštění obsahu Sega CD/Mega-CD. Užitečné při nastavení záložního ram koše na Pro-Hru, aby se zabránilo více větším velikostem koše."
#define OPTION_VAL_128K_CS NULL
#define OPTION_VAL_256K_CS NULL
#define OPTION_VAL_512K_CS NULL
#define OPTION_VAL_1MEG_CS NULL
#define OPTION_VAL_2MEG_CS NULL
#define OPTION_VAL_4MEG_CS NULL
#define GENESIS_PLUS_GX_ADD_ON_LABEL_CS "Doplněk CD (režim MD) (Vyžaduje Restart)"
#define GENESIS_PLUS_GX_ADD_ON_INFO_0_CS "Určete, který doplněk se má použít pro přehrávání zvuku CD s podporovanými hrami Mega Drive/Genesis."
#define OPTION_VAL_SEGA_MEGA_CD_CS NULL
#define OPTION_VAL_MEGASD_CS NULL
#define OPTION_VAL_NONE_CS "Žádné"
#define GENESIS_PLUS_GX_LOCK_ON_LABEL_CS "Cartridge Zámek-On"
#define GENESIS_PLUS_GX_LOCK_ON_INFO_0_CS "Technologie Zámek-On je funkce systému Mega Drive/Genesis, která umožňovala připojit starší hru k průchozímu portu speciální kazety a prodloužit nebo změnit tak hraní. Tato volba určuje, který typ speciální 'Zámek-On' kazety se má emulovat. V systémovém adresáři aplikace RetroArch musí být přítomen odpovídající soubor biosu."
#define OPTION_VAL_GAME_GENIE_CS NULL
#define OPTION_VAL_ACTION_REPLAY_PRO_CS "Přehrávání Akce (Pro)"
#define OPTION_VAL_SONIC_KNUCKLES_CS NULL
#define GENESIS_PLUS_GX_ASPECT_RATIO_LABEL_CS "Poměr stran poskytovaný jádrem"
#define GENESIS_PLUS_GX_ASPECT_RATIO_INFO_0_CS "Zvolte preferovaný poměr stran obsahu. To se použije pouze v případě, že je poměr stran aplikace RetroArch v nastavení videa nastaven na hodnotu 'Poskytnuté Jádro'."
#define OPTION_VAL_NTSC_PAR_CS NULL
#define OPTION_VAL_PAL_PAR_CS NULL
#define OPTION_VAL_4_3_CS NULL
#define OPTION_VAL_UNCORRECTED_CS "Neopraveno"
#define GENESIS_PLUS_GX_OVERSCAN_LABEL_CS "Ohraničení"
#define GENESIS_PLUS_GX_OVERSCAN_INFO_0_CS "Povolením této možnosti zobrazíte oblasti overscanu v horní/dolní a/nebo levé/pravé části obrazovky. Ty by byly normálně skryty rámečkem kolem okraje televizoru se standardním rozlišením."
#define OPTION_VAL_TOP_BOTTOM_CS "Horní/Spodní"
#define OPTION_VAL_LEFT_RIGHT_CS "Vlevo/Vpravo"
#define OPTION_VAL_FULL_CS "Plné"
#define GENESIS_PLUS_GX_LEFT_BORDER_LABEL_CS "Skrytí Bočních Okrajů Master Systému"
#define GENESIS_PLUS_GX_LEFT_BORDER_INFO_0_CS "Při spouštění her pro Master System odřízne 8 pixelů z levé strany obrazovky nebo z levé i pravé strany."
#define OPTION_VAL_LEFT_BORDER_CS "Pouze Levý Okraj"
#define OPTION_VAL_LEFT_RIGHT_BORDERS_CS "Levé a Pravé Okraje"
#define GENESIS_PLUS_GX_GG_EXTRA_LABEL_CS "Rozšířená Obrazovka Game Gear"
#define GENESIS_PLUS_GX_GG_EXTRA_INFO_0_CS "Vynutí spuštění titulů pro Game Gear v režimu SMS se zvýšeným rozlišením 256x192. Může zobrazit další obsah, ale obvykle zobrazí okraj poškozených/nežádoucích obrazových dat."
#define GENESIS_PLUS_GX_BLARGG_NTSC_FILTER_LABEL_CS "Blargg NTSC Filtr"
#define GENESIS_PLUS_GX_BLARGG_NTSC_FILTER_INFO_0_CS "Použijte video filtr pro napodobení různých televizních signálů NTSC."
#define OPTION_VAL_MONOCHROME_CS "Jednobarevné"
#define OPTION_VAL_COMPOSITE_CS "Kompozitní"
#define OPTION_VAL_SVIDEO_CS NULL
#define OPTION_VAL_RGB_CS NULL
#define GENESIS_PLUS_GX_LCD_FILTER_LABEL_CS "Filtr proti duchům na displeji LCD"
#define GENESIS_PLUS_GX_LCD_FILTER_INFO_0_CS "Použijte filtr 'duchů' obrazu, abyste napodobili vlastnosti zobrazení panelů LCD zařízení Game Gear a Genesis Nomad."
#define GENESIS_PLUS_GX_RENDER_LABEL_CS "Výstup v Prokládaném Režimu 2"
#define GENESIS_PLUS_GX_RENDER_INFO_0_CS "Prokládaný režim 2 umožňuje konzolím Mega Drive/Genesis vytvářet obraz 320x448 s dvojnásobnou výškou (vysokým rozlišením) tím, že každý snímek vykresluje střídavé skenovací řádky (tento režim používají režimy pro více hráčů Sonic the Hedgehog 2 a Combat Cars). Funkce 'Dvojité Pole' napodobuje původní hardware a vytváří ostrý obraz s artefakty blikání/prokládání. V režimu 'Jedno Pole' se použije filtr pro odstranění prokládání, který stabilizuje obraz, ale způsobuje mírné rozmazání."
#define OPTION_VAL_SINGLE_FIELD_CS "Jedno Pole"
#define OPTION_VAL_DOUBLE_FIELD_CS "Dvojité Pole"
#define GENESIS_PLUS_GX_FRAMESKIP_LABEL_CS NULL
#define GENESIS_PLUS_GX_FRAMESKIP_INFO_0_CS "Přeskočení snímků, aby se zabránilo nedostatečnému využití vyrovnávací paměti zvuku (praskání). Zlepšuje výkon na úkor vizuální plynulosti. Funkce 'Auto' přeskakuje snímky, pokud to doporučí frontend. 'Ruční' využívá nastavení 'Práh přeskakování snímků (%)'."
#define OPTION_VAL_MANUAL_CS "Ruční"
#define GENESIS_PLUS_GX_FRAMESKIP_THRESHOLD_LABEL_CS "Prahová hodnota Frameskip (%)"
#define GENESIS_PLUS_GX_FRAMESKIP_THRESHOLD_INFO_0_CS "Pokud je položka 'Frameskip' nastavena na hodnotu 'Ruční', určuje práh obsazení vyrovnávací paměti zvuku (v procentech), pod kterým budou snímky přeskočeny. Vyšší hodnoty snižují riziko praskání tím, že způsobují častější vynechávání snímků."
#define GENESIS_PLUS_GX_YM2413_LABEL_CS NULL
#define GENESIS_PLUS_GX_YM2413_INFO_0_CS "Umožňuje emulaci zvukové jednotky FM používané v některých hrách Sega Mark III/Master System pro lepší zvukový výstup."
#define GENESIS_PLUS_GX_YM2413_CORE_LABEL_CS "Master System FM (YM2413) Jádro"
#define GENESIS_PLUS_GX_YM2413_CORE_INFO_0_CS "Zvolte metodu používanou k emulaci zvukové jednotky FM systému Sega Mark III/Master System. Možnost 'MAME' je rychlá a na většině systémů běží plnou rychlostí. Možnost 'Nuked' je přesná v cyklech, velmi kvalitní a má značné nároky na procesor."
#define OPTION_VAL_MAME_CS NULL
#define OPTION_VAL_NUKED_CS NULL
#define GENESIS_PLUS_GX_YM2612_LABEL_CS NULL
#define GENESIS_PLUS_GX_YM2612_INFO_0_CS "Zvolte metodu emulace FM syntezátoru (hlavního generátoru zvuku) zařízení Mega Drive/Genesis. Možnosti 'MAME' jsou rychlé a na většině systémů běží plnou rychlostí. Možnosti 'Nuked' jsou cyklicky přesné, velmi kvalitní a mají značné nároky na procesor. Čip YM2612 používá původní model 1 Mega Drive/Genesis. Čip YM3438 se používá v pozdějších revizích jednotek Mega Drive/Genesis."
#define GENESIS_PLUS_GX_YM2612_INFO_1_CS "Zvolte metodu emulace FM syntezátoru (hlavního generátoru zvuku) zařízení Mega Drive/Genesis. Čip YM2612 používá původní model 1 Mega Drive/Genesis. Čip YM3438 se používá v pozdějších revizích jednotky Mega Drive/Genesis."
#define OPTION_VAL_MAME_YM2612_CS NULL
#define OPTION_VAL_MAME_ASIC_YM3438_CS NULL
#define OPTION_VAL_MAME_ENHANCED_YM3438_CS "MAME (Vylepšené YM3438)"
#define OPTION_VAL_NUKED_YM2612_CS NULL
#define OPTION_VAL_NUKED_YM3438_CS NULL
#define GENESIS_PLUS_GX_SOUND_OUTPUT_LABEL_CS "Zvukový Výstup"
#define GENESIS_PLUS_GX_SOUND_OUTPUT_INFO_0_CS "Vyberte stereofonní nebo monofonní přehrávání zvuku."
#define OPTION_VAL_STEREO_CS NULL
#define OPTION_VAL_MONO_CS NULL
#define GENESIS_PLUS_GX_AUDIO_FILTER_LABEL_CS "Filtr zvuku"
#define GENESIS_PLUS_GX_AUDIO_FILTER_INFO_0_CS "Povolte dolní propust zvukového filtru pro lepší simulaci charakteristického zvuku modelu 1 Mega Drive/Genesis."
#define OPTION_VAL_LOW_PASS_CS "Nízko-Propustný"
#define OPTION_VAL_EQ_CS NULL
#define GENESIS_PLUS_GX_LOWPASS_RANGE_LABEL_CS "Nízko-Propustný Filtr %"
#define GENESIS_PLUS_GX_LOWPASS_RANGE_INFO_0_CS "Zadejte mezní frekvenci dolní propusti zvukového filtru. Vyšší hodnota zvyšuje vnímanou 'síla' filtru, protože je potlačen širší rozsah vysokofrekvenčního spektra."
#define GENESIS_PLUS_GX_PSG_PREAMP_LABEL_CS "Úroveň Předzesilovače PSG"
#define GENESIS_PLUS_GX_PSG_PREAMP_INFO_0_CS "Nastavení úrovně zvukového předzesilovače emulovaného čtyřkanálového programovatelného generátoru zvuku SN76496, který se nachází v zařízeních SG-1000, Sega Mark III, Master System, Game Gear a Mega Drive/Genesis."
#define GENESIS_PLUS_GX_FM_PREAMP_LABEL_CS "FM Úroveň Preamp"
#define GENESIS_PLUS_GX_FM_PREAMP_INFO_0_CS "Nastavte úroveň zvukového předzesilovače emulovaného zvukového syntezátoru Mega Drive/Genesis FM nebo zvukové jednotky Sega Mark III/Master System FM."
#define GENESIS_PLUS_GX_CDDA_VOLUME_LABEL_CS "Hlasitost CD-DA"
#define GENESIS_PLUS_GX_CDDA_VOLUME_INFO_0_CS "Upravte hlasitost směšování emulovaného výstupu přehrávání zvuku CD."
#define GENESIS_PLUS_GX_PCM_VOLUME_LABEL_CS "PCM Hlasitost"
#define GENESIS_PLUS_GX_PCM_VOLUME_INFO_0_CS "Nastavte hlasitost směšování výstupu emulovaného zvukového generátoru Sega CD/Mega-CD RF5C164 PCM."
#define GENESIS_PLUS_GX_AUDIO_EQ_LOW_LABEL_CS "Nízký EQ"
#define GENESIS_PLUS_GX_AUDIO_EQ_LOW_INFO_0_CS "Nastavení pásma nízkého rozsahu interního ekvalizéru zvuku."
#define GENESIS_PLUS_GX_AUDIO_EQ_MID_LABEL_CS "Střední EQ"
#define GENESIS_PLUS_GX_AUDIO_EQ_MID_INFO_0_CS "Nastavení středního pásma interního ekvalizéru zvuku."
#define GENESIS_PLUS_GX_AUDIO_EQ_HIGH_LABEL_CS "Vysoký EQ"
#define GENESIS_PLUS_GX_AUDIO_EQ_HIGH_INFO_0_CS "Nastavte pásmo vysokého rozsahu interního ekvalizéru zvuku."
#define GENESIS_PLUS_GX_GUN_INPUT_LABEL_CS "Vstup Světelné Zbraně"
#define GENESIS_PLUS_GX_GUN_INPUT_INFO_0_CS "Použít 'Světelná Zbraň' ovládanou myší nebo vstup 'Dotyková Obrazovka'."
#define OPTION_VAL_LIGHTGUN_CS NULL
#define OPTION_VAL_TOUCHSCREEN_CS "Dotyková Obrazovka"
#define GENESIS_PLUS_GX_GUN_CURSOR_LABEL_CS "Zobrazit Kříž Světelné Zbraně"
#define GENESIS_PLUS_GX_GUN_CURSOR_INFO_0_CS "Zobrazení světelného zaměřovacího kříže při použití typů vstupních zařízení MD Menacer, MD Justifiers a MS Light Phaser."
#define GENESIS_PLUS_GX_INVERT_MOUSE_LABEL_CS "Přehodit Osu-Y Myši"
#define GENESIS_PLUS_GX_INVERT_MOUSE_INFO_0_CS "Změní osu-Y vstupního zařízení MD myši."
#define GENESIS_PLUS_GX_NO_SPRITE_LIMIT_LABEL_CS "Odstranění Limitu Spritu na Řádek"
#define GENESIS_PLUS_GX_NO_SPRITE_LIMIT_INFO_0_CS "Odstraní původní hardwarový limit sprite-per-scanline. Tím se sníží blikání, ale může to způsobit vizuální závady, protože některé hry využívají hardwarový limit ke generování speciálních efektů."
#define GENESIS_PLUS_GX_ENHANCED_VSCROLL_LABEL_CS "Vylepšené vertikální posouvání po dlaždici"
#define GENESIS_PLUS_GX_ENHANCED_VSCROLL_INFO_0_CS "Umožňuje posouvat každou jednotlivou buňku svisle místo 16px dvoubuněk zprůměrováním s hodnotou vertikálního posouvání sousední buňky. Tento hack platí pouze pro několik her, které používají režim vertikálního posouvání po 2 buňkách."
#define GENESIS_PLUS_GX_ENHANCED_VSCROLL_LIMIT_LABEL_CS "Vylepšený limit vertikálního posouvání na dlaždici"
#define GENESIS_PLUS_GX_ENHANCED_VSCROLL_LIMIT_INFO_0_CS "Pouze když je povoleno vylepšené vertikální posouvání po dlaždicích. Upravuje limit vylepšení vertikálního posouvání. Pokud je rozdíl vscroll mezi sousedními dlaždicemi větší než tento limit, je vylepšení zakázáno."
#define GENESIS_PLUS_GX_OVERCLOCK_LABEL_CS "Rychlost CPU"
#define GENESIS_PLUS_GX_OVERCLOCK_INFO_0_CS "Přetaktování emulovaného procesoru. Může snížit zpomalení, ale může způsobit závady."
#define OPTION_VAL_100_CS NULL
#define OPTION_VAL_125_CS NULL
#define OPTION_VAL_150_CS NULL
#define OPTION_VAL_175_CS NULL
#define OPTION_VAL_200_CS NULL
#define OPTION_VAL_225_CS NULL
#define OPTION_VAL_250_CS NULL
#define OPTION_VAL_275_CS NULL
#define OPTION_VAL_300_CS NULL
#define OPTION_VAL_325_CS NULL
#define OPTION_VAL_350_CS NULL
#define OPTION_VAL_375_CS NULL
#define OPTION_VAL_400_CS NULL
#define OPTION_VAL_425_CS NULL
#define OPTION_VAL_450_CS NULL
#define OPTION_VAL_475_CS NULL
#define OPTION_VAL_500_CS NULL
#define GENESIS_PLUS_GX_FORCE_DTACK_LABEL_CS "Uzamčení Systému"
#define GENESIS_PLUS_GX_FORCE_DTACK_INFO_0_CS "Emulace zablokování systému, ke kterému dochází na skutečném hardwaru při provádění nelegálního přístupu k adrese. Tato funkce by měla být vypnuta pouze při přehrávání některých dem a homebrew, které se spoléhají na nelegální chování pro správnou funkci."
#define GENESIS_PLUS_GX_ADDR_ERROR_LABEL_CS "Chyba v Adrese 68K"
#define GENESIS_PLUS_GX_ADDR_ERROR_INFO_0_CS "Hlavní procesor Mega Drive/Genesis (Motorola 68000) generuje při pokusu o nezarovnaný přístup do paměti výjimku Chyba Adresy (Výpadek). Povolením této funkce se toto chování simuluje. Měla by být vypnuta pouze při přehrávání hacků ROM, protože ty jsou obvykle vyvíjeny pomocí méně přesných emulátorů a mohou se spoléhat na neplatný přístup do RAM pro správnou funkci."
#define GENESIS_PLUS_GX_CD_LATENCY_LABEL_CS "Doba přístupu na CD"
#define GENESIS_PLUS_GX_CD_LATENCY_INFO_0_CS "Simulace původního hardwarového zpoždění disku CD při zahájení čtení nebo vyhledávání určitého místa na nahraném disku. To je vyžadováno několika hrami na CD, které padají, pokud jsou data na CD dostupná příliš brzy, a také to řeší problémy s desynchronizací zvuku CD v některých hrách. Vypnutí této funkce může být užitečné u her s MSU-MD, protože díky ní jsou smyčky zvukových stop CD plynulejší."
#define GENESIS_PLUS_GX_CD_PRECACHE_LABEL_CS "Cache CD obrazu"
#define GENESIS_PLUS_GX_CD_PRECACHE_INFO_0_CS "Načtení obrazu CD do paměti při spuštění. Podporováno pouze CHD. Nutný restart."
#define GENESIS_PLUS_GX_SHOW_ADVANCED_AUDIO_SETTINGS_LABEL_CS "Zobrazit Pokročilé Nastavení Hlasitosti Zvuku (Znovu otevře Menu)"
#define GENESIS_PLUS_GX_SHOW_ADVANCED_AUDIO_SETTINGS_INFO_0_CS "Povolení konfigurace parametrů nízkoúrovňového zvukového kanálu. POZNÁMKA: Aby se toto nastavení projevilo, musí být přepnuta rychlá nabídka."
#define GENESIS_PLUS_GX_PSG_CHANNEL_0_VOLUME_LABEL_CS "Tónový Kanál PSG 0 Hlasitost %"
#define GENESIS_PLUS_GX_PSG_CHANNEL_0_VOLUME_INFO_0_CS "Redukuje hlasitost Tónového Kanálu PSG 0."
#define GENESIS_PLUS_GX_PSG_CHANNEL_1_VOLUME_LABEL_CS "Tónový Kanál PSG 1 Hlasitost %"
#define GENESIS_PLUS_GX_PSG_CHANNEL_1_VOLUME_INFO_0_CS "Redukuje Hlasitost Tónového Kanálu PSG 1."
#define GENESIS_PLUS_GX_PSG_CHANNEL_2_VOLUME_LABEL_CS "Tónový Kanál PSG 2 Hlasitost %"
#define GENESIS_PLUS_GX_PSG_CHANNEL_2_VOLUME_INFO_0_CS "Redukuje hlasitost Tónového Kanálu PSG 2."
#define GENESIS_PLUS_GX_PSG_CHANNEL_3_VOLUME_LABEL_CS "Kanál Hluku PSG 3 Hlasitost %"
#define GENESIS_PLUS_GX_PSG_CHANNEL_3_VOLUME_INFO_0_CS "Redukuje hlasitost Šumového Kanálu PSG 3."
#define GENESIS_PLUS_GX_MD_CHANNEL_0_VOLUME_LABEL_CS "Mega Drive/Genesis FM Kanál 0 Hlasitost %"
#define GENESIS_PLUS_GX_MD_CHANNEL_0_VOLUME_INFO_0_CS "Redukuje hlasitost kanálu 0 jednotky Mega Drive/Genesis FM. Funguje pouze s emulátory MAME FM."
#define GENESIS_PLUS_GX_MD_CHANNEL_1_VOLUME_LABEL_CS "Mega Drive/Genesis FM Kanál 1 Hlasitost %"
#define GENESIS_PLUS_GX_MD_CHANNEL_1_VOLUME_INFO_0_CS "Redukuje hlasitost 1. kanálu Mega Drive/Genesis FM. Funguje pouze s emulátory MAME FM."
#define GENESIS_PLUS_GX_MD_CHANNEL_2_VOLUME_LABEL_CS "Mega Drive/Genesis FM Channel 2 Hlasitost %"
#define GENESIS_PLUS_GX_MD_CHANNEL_2_VOLUME_INFO_0_CS "Redukuje hlasitost kanálu Mega Drive/Genesis FM 2. Funguje pouze s emulátory MAME FM."
#define GENESIS_PLUS_GX_MD_CHANNEL_3_VOLUME_LABEL_CS "Mega Drive/Genesis FM Kanál 3 Hlasitost %"
#define GENESIS_PLUS_GX_MD_CHANNEL_3_VOLUME_INFO_0_CS "Redukuje hlasitost kanálu 3 jednotky Mega Drive/Genesis FM. Funguje pouze s emulátory MAME FM."
#define GENESIS_PLUS_GX_MD_CHANNEL_4_VOLUME_LABEL_CS "Mega Drive/Genesis FM Kanál 4 Hlasitost %"
#define GENESIS_PLUS_GX_MD_CHANNEL_4_VOLUME_INFO_0_CS "Redukuje hlasitost kanálu Mega Drive/Genesis FM 4. Funguje pouze s emulátory MAME FM."
#define GENESIS_PLUS_GX_MD_CHANNEL_5_VOLUME_LABEL_CS "Mega Drive/Genesis FM Kanál 5 Hlasitost %"
#define GENESIS_PLUS_GX_MD_CHANNEL_5_VOLUME_INFO_0_CS "Redukuje hlasitost kanálu 5 jednotky Mega Drive/Genesis FM. Funguje pouze s emulátory MAME FM."
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_0_VOLUME_LABEL_CS "Master System FM (YM2413) Kanál 0 Hlasitost %"
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_0_VOLUME_INFO_0_CS "Redukuje hlasitost Master Systemu FM Kanál 0."
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_1_VOLUME_LABEL_CS "Master System FM (YM2413) Kanál 1 Hlasitost %"
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_1_VOLUME_INFO_0_CS "Redukuje hlasitost Master Systemu FM Kanál 1."
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_2_VOLUME_LABEL_CS "Master System FM (YM2413) Kanál 2 Hlasitost %"
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_2_VOLUME_INFO_0_CS "Redukuje hlasitost Master Systemu FM Kanál 2."
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_3_VOLUME_LABEL_CS "Master System FM (YM2413) Kanál 3 Hlasitost %"
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_3_VOLUME_INFO_0_CS "Redukuje hlasitost Master Systemu FM Kanál 3."
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_4_VOLUME_LABEL_CS "Master System FM (YM2413) Kanál 4 Hlasitost %"
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_4_VOLUME_INFO_0_CS "Redukuje hlasitost Master Systemu FM Kanál 4."
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_5_VOLUME_LABEL_CS "Master System FM (YM2413) Kanál 5 Hlasitost %"
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_5_VOLUME_INFO_0_CS "Redukuje hlasitost Master Systemu FM Kanál 5."
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_6_VOLUME_LABEL_CS "Master System FM (YM2413) Kanál 6 Hlasitost %"
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_6_VOLUME_INFO_0_CS "Redukuje hlasitost Master Systemu FM Kanál 6."
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_7_VOLUME_LABEL_CS "Master System FM (YM2413) Kanál 7 Hlasitost %"
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_7_VOLUME_INFO_0_CS "Redukuje hlasitost Master Systemu FM Kanál 7."
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_8_VOLUME_LABEL_CS "Master System FM (YM2413) Kanál 8 Hlasitost %"
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_8_VOLUME_INFO_0_CS "Redukuje hlasitost Master Systemu FM Kanál 8."

struct retro_core_option_v2_category option_cats_cs[] = {
   {
      "system",
      CATEGORY_SYSTEM_LABEL_CS,
      CATEGORY_SYSTEM_INFO_0_CS
   },
   {
      "video",
      CATEGORY_VIDEO_LABEL_CS,
      CATEGORY_VIDEO_INFO_0_CS
   },
   {
      "audio",
      CATEGORY_AUDIO_LABEL_CS,
      CATEGORY_AUDIO_INFO_0_CS
   },
   {
      "input",
      CATEGORY_INPUT_LABEL_CS,
      CATEGORY_INPUT_INFO_0_CS
   },
   {
      "hacks",
      CATEGORY_HACKS_LABEL_CS,
      CATEGORY_HACKS_INFO_0_CS
   },
   {
      "channel_volume",
      CATEGORY_CHANNEL_VOLUME_LABEL_CS,
      CATEGORY_CHANNEL_VOLUME_INFO_0_CS
   },
   { NULL, NULL, NULL },
};
struct retro_core_option_v2_definition option_defs_cs[] = {
   {
      "genesis_plus_gx_system_hw",
      GENESIS_PLUS_GX_SYSTEM_HW_LABEL_CS,
      NULL,
      GENESIS_PLUS_GX_SYSTEM_HW_INFO_0_CS,
      NULL,
      "system",
      {
         { "auto",                 OPTION_VAL_AUTO_CS                 },
         { "sg-1000",              OPTION_VAL_SG_1000_CS              },
         { "sg-1000 II",           OPTION_VAL_SG_1000_II_CS           },
         { "sg-1000 II + ram ext.",OPTION_VAL_SG_1000_II_RAM_EXT_CS},
         { "mark-III",             OPTION_VAL_MARK_III_CS             },
         { "master system",        OPTION_VAL_MASTER_SYSTEM_CS        },
         { "master system II",     OPTION_VAL_MASTER_SYSTEM_II_CS     },
         { "game gear",            OPTION_VAL_GAME_GEAR_CS            },
         { "mega drive / genesis", OPTION_VAL_MEGA_DRIVE_GENESIS_CS   },
         { NULL, NULL },
      },
      "auto"
   },
   {
      "genesis_plus_gx_region_detect",
      GENESIS_PLUS_GX_REGION_DETECT_LABEL_CS,
      NULL,
      GENESIS_PLUS_GX_REGION_DETECT_INFO_0_CS,
      NULL,
      "system",
      {
         { "auto",    OPTION_VAL_AUTO_CS   },
         { "ntsc-u",  OPTION_VAL_NTSC_U_CS },
         { "pal",     OPTION_VAL_PAL_CS    },
         { "ntsc-j",  OPTION_VAL_NTSC_J_CS },
         { NULL, NULL },
      },
      "auto"
   },
   {
      "genesis_plus_gx_vdp_mode",
      GENESIS_PLUS_GX_VDP_MODE_LABEL_CS,
      NULL,
      GENESIS_PLUS_GX_VDP_MODE_INFO_0_CS,
      NULL,
      "system",
      {
         { "auto",  "Disabled" },
         { "60hz",  OPTION_VAL_60HZ_CS },
         { "50hz",  OPTION_VAL_50HZ_CS },
         { NULL, NULL },
      },
      "auto"
   },
   {
      "genesis_plus_gx_bios",
      GENESIS_PLUS_GX_BIOS_LABEL_CS,
      NULL,
      GENESIS_PLUS_GX_BIOS_INFO_0_CS,
      NULL,
      "system",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_system_bram",
      GENESIS_PLUS_GX_SYSTEM_BRAM_LABEL_CS,
      NULL,
      GENESIS_PLUS_GX_SYSTEM_BRAM_INFO_0_CS,
      NULL,
      "system",
      {
         { "per bios", OPTION_VAL_PER_BIOS_CS },
         { "per game", OPTION_VAL_PER_GAME_CS },
         { NULL, NULL },
      },
      "per bios"
   },
   {
      "genesis_plus_gx_cart_bram",
      GENESIS_PLUS_GX_CART_BRAM_LABEL_CS,
      NULL,
      GENESIS_PLUS_GX_CART_BRAM_INFO_0_CS,
      NULL,
      "system",
      {
         { "per cart", OPTION_VAL_PER_CART_CS },
         { "per game", OPTION_VAL_PER_GAME_CS },
         { NULL, NULL },
      },
      "per cart"
   },
   {
      "genesis_plus_gx_cart_size",
      GENESIS_PLUS_GX_CART_SIZE_LABEL_CS,
      NULL,
      GENESIS_PLUS_GX_CART_SIZE_INFO_0_CS,
      NULL,
      "system",
      {
         { "disabled", "Disabled" },
         { "128k",     OPTION_VAL_128K_CS  },
         { "256k",     OPTION_VAL_256K_CS  },
         { "512k",     OPTION_VAL_512K_CS  },
         { "1meg",     OPTION_VAL_1MEG_CS    },
         { "2meg",     OPTION_VAL_2MEG_CS    },
         { "4meg",     OPTION_VAL_4MEG_CS    },
         { NULL, NULL },
      },
      "4meg"
   },
   {
      "genesis_plus_gx_add_on",
      GENESIS_PLUS_GX_ADD_ON_LABEL_CS,
      NULL,
      GENESIS_PLUS_GX_ADD_ON_INFO_0_CS,
      NULL,
      "system",
      {
         { "auto",         OPTION_VAL_AUTO_CS },
         { "sega/mega cd", OPTION_VAL_SEGA_MEGA_CD_CS },
         { "megasd",       OPTION_VAL_MEGASD_CS },
         { "none",         OPTION_VAL_NONE_CS },
         { NULL, NULL },
      },
      "auto"
   },
   {
      "genesis_plus_gx_lock_on",
      GENESIS_PLUS_GX_LOCK_ON_LABEL_CS,
      NULL,
      GENESIS_PLUS_GX_LOCK_ON_INFO_0_CS,
      NULL,
      "system",
      {
         { "disabled",            NULL },
         { "game genie",          OPTION_VAL_GAME_GENIE_CS },
         { "action replay (pro)", OPTION_VAL_ACTION_REPLAY_PRO_CS },
         { "sonic & knuckles",    OPTION_VAL_SONIC_KNUCKLES_CS },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_aspect_ratio",
      GENESIS_PLUS_GX_ASPECT_RATIO_LABEL_CS,
      NULL,
      GENESIS_PLUS_GX_ASPECT_RATIO_INFO_0_CS,
      NULL,
      "video",
      {
         { "auto",     OPTION_VAL_AUTO_CS },
         { "NTSC PAR", OPTION_VAL_NTSC_PAR_CS },
         { "PAL PAR",  OPTION_VAL_PAL_PAR_CS },
         { "4:3",  OPTION_VAL_4_3_CS },
         { "Uncorrected",  OPTION_VAL_UNCORRECTED_CS },
      },
      "auto"
   },
   {
      "genesis_plus_gx_overscan",
      GENESIS_PLUS_GX_OVERSCAN_LABEL_CS,
      NULL,
      GENESIS_PLUS_GX_OVERSCAN_INFO_0_CS,
      NULL,
      "video",
      {
         { "disabled",   NULL },
         { "top/bottom", OPTION_VAL_TOP_BOTTOM_CS },
         { "left/right", OPTION_VAL_LEFT_RIGHT_CS },
         { "full",       OPTION_VAL_FULL_CS },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_left_border",
      GENESIS_PLUS_GX_LEFT_BORDER_LABEL_CS,
      NULL,
      GENESIS_PLUS_GX_LEFT_BORDER_INFO_0_CS,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "left border", OPTION_VAL_LEFT_BORDER_CS },
         { "left & right borders", OPTION_VAL_LEFT_RIGHT_BORDERS_CS },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_gg_extra",
      GENESIS_PLUS_GX_GG_EXTRA_LABEL_CS,
      NULL,
      GENESIS_PLUS_GX_GG_EXTRA_INFO_0_CS,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_blargg_ntsc_filter",
      GENESIS_PLUS_GX_BLARGG_NTSC_FILTER_LABEL_CS,
      NULL,
      GENESIS_PLUS_GX_BLARGG_NTSC_FILTER_INFO_0_CS,
      NULL,
      "video",
      {
         { "disabled",   NULL },
         { "monochrome", OPTION_VAL_MONOCHROME_CS },
         { "composite",  OPTION_VAL_COMPOSITE_CS },
         { "svideo",     OPTION_VAL_SVIDEO_CS },
         { "rgb",        OPTION_VAL_RGB_CS },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_lcd_filter",
      GENESIS_PLUS_GX_LCD_FILTER_LABEL_CS,
      NULL,
      GENESIS_PLUS_GX_LCD_FILTER_INFO_0_CS,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_render",
      GENESIS_PLUS_GX_RENDER_LABEL_CS,
      NULL,
      GENESIS_PLUS_GX_RENDER_INFO_0_CS,
      NULL,
      "video",
      {
         { "single field", OPTION_VAL_SINGLE_FIELD_CS },
         { "double field", OPTION_VAL_DOUBLE_FIELD_CS },
         { NULL, NULL },
      },
      "single field"
   },
   {
      "genesis_plus_gx_frameskip",
      GENESIS_PLUS_GX_FRAMESKIP_LABEL_CS,
      NULL,
      GENESIS_PLUS_GX_FRAMESKIP_INFO_0_CS,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "auto",     OPTION_VAL_AUTO_CS },
         { "manual",   OPTION_VAL_MANUAL_CS },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_frameskip_threshold",
      GENESIS_PLUS_GX_FRAMESKIP_THRESHOLD_LABEL_CS,
      NULL,
      GENESIS_PLUS_GX_FRAMESKIP_THRESHOLD_INFO_0_CS,
      NULL,
      "video",
      {
         { "15", NULL },
         { "18", NULL },
         { "21", NULL },
         { "24", NULL },
         { "27", NULL },
         { "30", NULL },
         { "33", NULL },
         { "36", NULL },
         { "39", NULL },
         { "42", NULL },
         { "45", NULL },
         { "48", NULL },
         { "51", NULL },
         { "54", NULL },
         { "57", NULL },
         { "60", NULL },
         { NULL, NULL },
      },
      "33"
   },
   {
      "genesis_plus_gx_ym2413",
      GENESIS_PLUS_GX_YM2413_LABEL_CS,
      NULL,
      GENESIS_PLUS_GX_YM2413_INFO_0_CS,
      NULL,
      "audio",
      {
         { "auto",     OPTION_VAL_AUTO_CS },
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "auto"
   },
#ifdef HAVE_OPLL_CORE
   {
      "genesis_plus_gx_ym2413_core",
      GENESIS_PLUS_GX_YM2413_CORE_LABEL_CS,
      NULL,
      GENESIS_PLUS_GX_YM2413_CORE_INFO_0_CS,
      NULL,
      "audio",
      {
         { "mame",  OPTION_VAL_MAME_CS },
         { "nuked", OPTION_VAL_NUKED_CS },
         { NULL, NULL },
      },
      "mame"
   },
#endif
   {
      "genesis_plus_gx_ym2612",
      GENESIS_PLUS_GX_YM2612_LABEL_CS,
      NULL,
#ifdef HAVE_YM3438_CORE
      GENESIS_PLUS_GX_YM2612_INFO_0_CS,
#else
      GENESIS_PLUS_GX_YM2612_INFO_1_CS,
#endif
      NULL,
      "audio",
      {
         { "mame (ym2612)",          OPTION_VAL_MAME_YM2612_CS },
         { "mame (asic ym3438)",     OPTION_VAL_MAME_ASIC_YM3438_CS },
         { "mame (enhanced ym3438)", OPTION_VAL_MAME_ENHANCED_YM3438_CS },
#ifdef HAVE_YM3438_CORE
         { "nuked (ym2612)",         OPTION_VAL_NUKED_YM2612_CS },
         { "nuked (ym3438)",         OPTION_VAL_NUKED_YM3438_CS },
#endif
         { NULL, NULL },
      },
      "mame (ym2612)"
   },
   {
      "genesis_plus_gx_sound_output",
      GENESIS_PLUS_GX_SOUND_OUTPUT_LABEL_CS,
      NULL,
      GENESIS_PLUS_GX_SOUND_OUTPUT_INFO_0_CS,
      NULL,
      "audio",
      {
         { "stereo", OPTION_VAL_STEREO_CS },
         { "mono",   OPTION_VAL_MONO_CS },
         { NULL, NULL },
      },
      "stereo"
   },
   {
      "genesis_plus_gx_audio_filter",
      GENESIS_PLUS_GX_AUDIO_FILTER_LABEL_CS,
      NULL,
      GENESIS_PLUS_GX_AUDIO_FILTER_INFO_0_CS,
      NULL,
      "audio",
      {
         { "disabled", NULL },
         { "low-pass", OPTION_VAL_LOW_PASS_CS },
#ifdef HAVE_EQ
         { "EQ",       OPTION_VAL_EQ_CS },
#endif
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_lowpass_range",
      GENESIS_PLUS_GX_LOWPASS_RANGE_LABEL_CS,
      NULL,
      GENESIS_PLUS_GX_LOWPASS_RANGE_INFO_0_CS,
      NULL,
      "audio",
      {
         { "5",  NULL },
         { "10", NULL },
         { "15", NULL },
         { "20", NULL },
         { "25", NULL },
         { "30", NULL },
         { "35", NULL },
         { "40", NULL },
         { "45", NULL },
         { "50", NULL },
         { "55", NULL },
         { "60", NULL },
         { "65", NULL },
         { "70", NULL },
         { "75", NULL },
         { "80", NULL },
         { "85", NULL },
         { "90", NULL },
         { "95", NULL },
         { NULL, NULL },
      },
      "60"
   },
   {
      "genesis_plus_gx_psg_preamp",
      GENESIS_PLUS_GX_PSG_PREAMP_LABEL_CS,
      NULL,
      GENESIS_PLUS_GX_PSG_PREAMP_INFO_0_CS,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { "105", NULL },
         { "110", NULL },
         { "115", NULL },
         { "120", NULL },
         { "125", NULL },
         { "130", NULL },
         { "135", NULL },
         { "140", NULL },
         { "145", NULL },
         { "150", NULL },
         { "155", NULL },
         { "160", NULL },
         { "165", NULL },
         { "170", NULL },
         { "175", NULL },
         { "180", NULL },
         { "185", NULL },
         { "190", NULL },
         { "195", NULL },
         { "200", NULL },
         { NULL, NULL },
      },
      "150"
   },
   {
      "genesis_plus_gx_fm_preamp",
      GENESIS_PLUS_GX_FM_PREAMP_LABEL_CS,
      NULL,
      GENESIS_PLUS_GX_FM_PREAMP_INFO_0_CS,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { "105", NULL },
         { "110", NULL },
         { "115", NULL },
         { "120", NULL },
         { "125", NULL },
         { "130", NULL },
         { "135", NULL },
         { "140", NULL },
         { "145", NULL },
         { "150", NULL },
         { "155", NULL },
         { "160", NULL },
         { "165", NULL },
         { "170", NULL },
         { "175", NULL },
         { "180", NULL },
         { "185", NULL },
         { "190", NULL },
         { "195", NULL },
         { "200", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_cdda_volume",
      GENESIS_PLUS_GX_CDDA_VOLUME_LABEL_CS,
      NULL,
      GENESIS_PLUS_GX_CDDA_VOLUME_INFO_0_CS,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_pcm_volume",
      GENESIS_PLUS_GX_PCM_VOLUME_LABEL_CS,
      NULL,
      GENESIS_PLUS_GX_PCM_VOLUME_INFO_0_CS,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
#ifdef HAVE_EQ
   {
      "genesis_plus_gx_audio_eq_low",
      GENESIS_PLUS_GX_AUDIO_EQ_LOW_LABEL_CS,
      NULL,
      GENESIS_PLUS_GX_AUDIO_EQ_LOW_INFO_0_CS,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_audio_eq_mid",
      GENESIS_PLUS_GX_AUDIO_EQ_MID_LABEL_CS,
      NULL,
      GENESIS_PLUS_GX_AUDIO_EQ_MID_INFO_0_CS,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_audio_eq_high",
      GENESIS_PLUS_GX_AUDIO_EQ_HIGH_LABEL_CS,
      NULL,
      GENESIS_PLUS_GX_AUDIO_EQ_HIGH_INFO_0_CS,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
#endif
   {
      "genesis_plus_gx_gun_input",
      GENESIS_PLUS_GX_GUN_INPUT_LABEL_CS,
      NULL,
      GENESIS_PLUS_GX_GUN_INPUT_INFO_0_CS,
      NULL,
      "input",
      {
         { "lightgun",    OPTION_VAL_LIGHTGUN_CS },
         { "touchscreen", OPTION_VAL_TOUCHSCREEN_CS },
         { NULL, NULL },
      },
      "lightgun"
   },
   {
      "genesis_plus_gx_gun_cursor",
      GENESIS_PLUS_GX_GUN_CURSOR_LABEL_CS,
      NULL,
      GENESIS_PLUS_GX_GUN_CURSOR_INFO_0_CS,
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_invert_mouse",
      GENESIS_PLUS_GX_INVERT_MOUSE_LABEL_CS,
      NULL,
      GENESIS_PLUS_GX_INVERT_MOUSE_INFO_0_CS,
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_no_sprite_limit",
      GENESIS_PLUS_GX_NO_SPRITE_LIMIT_LABEL_CS,
      NULL,
      GENESIS_PLUS_GX_NO_SPRITE_LIMIT_INFO_0_CS,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_enhanced_vscroll",
      GENESIS_PLUS_GX_ENHANCED_VSCROLL_LABEL_CS,
      NULL,
      GENESIS_PLUS_GX_ENHANCED_VSCROLL_INFO_0_CS,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_enhanced_vscroll_limit",
      GENESIS_PLUS_GX_ENHANCED_VSCROLL_LIMIT_LABEL_CS,
      NULL,
      GENESIS_PLUS_GX_ENHANCED_VSCROLL_LIMIT_INFO_0_CS,
      NULL,
      "hacks",
      {
         { "2", NULL },
         { "3",  NULL },
         { "4", NULL },
         { "5",  NULL },
         { "6", NULL },
         { "7",  NULL },
         { "8", NULL },
         { "9",  NULL },
         { "10", NULL },
         { "11",  NULL },
         { "12", NULL },
         { "13",  NULL },
         { "14", NULL },
         { "15",  NULL },
         { "16", NULL },
         { NULL, NULL },
      },
      "8"
   },
#ifdef HAVE_OVERCLOCK
   {
      "genesis_plus_gx_overclock",
      GENESIS_PLUS_GX_OVERCLOCK_LABEL_CS,
      NULL,
      GENESIS_PLUS_GX_OVERCLOCK_INFO_0_CS,
      NULL,
      "hacks",
      {
         { "100", OPTION_VAL_100_CS },
         { "125", OPTION_VAL_125_CS },
         { "150", OPTION_VAL_150_CS },
         { "175", OPTION_VAL_175_CS },
         { "200", OPTION_VAL_200_CS },
         { "225", OPTION_VAL_225_CS },
         { "250", OPTION_VAL_250_CS },
         { "275", OPTION_VAL_275_CS },
         { "300", OPTION_VAL_300_CS },
         { "325", OPTION_VAL_325_CS },
         { "350", OPTION_VAL_350_CS },
         { "375", OPTION_VAL_375_CS },
         { "400", OPTION_VAL_400_CS },
         { "425", OPTION_VAL_425_CS },
         { "450", OPTION_VAL_450_CS },
         { "475", OPTION_VAL_475_CS },
         { "500", OPTION_VAL_500_CS },
         { NULL, NULL },
      },
      "100%"
   },
#endif
   {
      "genesis_plus_gx_force_dtack",
      GENESIS_PLUS_GX_FORCE_DTACK_LABEL_CS,
      NULL,
      GENESIS_PLUS_GX_FORCE_DTACK_INFO_0_CS,
      NULL,
      "hacks",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL },
      },
      "enabled"
   },
   {
      "genesis_plus_gx_addr_error",
      GENESIS_PLUS_GX_ADDR_ERROR_LABEL_CS,
      NULL,
      GENESIS_PLUS_GX_ADDR_ERROR_INFO_0_CS,
      NULL,
      "hacks",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL },
      },
      "enabled"
   },
   {
      "genesis_plus_gx_cd_latency",
      GENESIS_PLUS_GX_CD_LATENCY_LABEL_CS,
      NULL,
      GENESIS_PLUS_GX_CD_LATENCY_INFO_0_CS,
      NULL,
      "hacks",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL },
      },
      "enabled"
   },
   {
      "genesis_plus_gx_cd_precache",
      GENESIS_PLUS_GX_CD_PRECACHE_LABEL_CS,
      NULL,
      GENESIS_PLUS_GX_CD_PRECACHE_INFO_0_CS,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
#ifdef USE_PER_SOUND_CHANNELS_CONFIG
   {
      "genesis_plus_gx_show_advanced_audio_settings",
      GENESIS_PLUS_GX_SHOW_ADVANCED_AUDIO_SETTINGS_LABEL_CS,
      NULL,
      GENESIS_PLUS_GX_SHOW_ADVANCED_AUDIO_SETTINGS_INFO_0_CS,
      NULL,
      "channel_volume",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL},
      },
      "disabled"
   },
   {
      "genesis_plus_gx_psg_channel_0_volume",
      GENESIS_PLUS_GX_PSG_CHANNEL_0_VOLUME_LABEL_CS,
      NULL,
      GENESIS_PLUS_GX_PSG_CHANNEL_0_VOLUME_INFO_0_CS,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_psg_channel_1_volume",
      GENESIS_PLUS_GX_PSG_CHANNEL_1_VOLUME_LABEL_CS,
      NULL,
      GENESIS_PLUS_GX_PSG_CHANNEL_1_VOLUME_INFO_0_CS,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_psg_channel_2_volume",
      GENESIS_PLUS_GX_PSG_CHANNEL_2_VOLUME_LABEL_CS,
      NULL,
      GENESIS_PLUS_GX_PSG_CHANNEL_2_VOLUME_INFO_0_CS,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_psg_channel_3_volume",
      GENESIS_PLUS_GX_PSG_CHANNEL_3_VOLUME_LABEL_CS,
      NULL,
      GENESIS_PLUS_GX_PSG_CHANNEL_3_VOLUME_INFO_0_CS,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_0_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_0_VOLUME_LABEL_CS,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_0_VOLUME_INFO_0_CS,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_1_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_1_VOLUME_LABEL_CS,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_1_VOLUME_INFO_0_CS,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_2_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_2_VOLUME_LABEL_CS,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_2_VOLUME_INFO_0_CS,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_3_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_3_VOLUME_LABEL_CS,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_3_VOLUME_INFO_0_CS,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_4_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_4_VOLUME_LABEL_CS,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_4_VOLUME_INFO_0_CS,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_5_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_5_VOLUME_LABEL_CS,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_5_VOLUME_INFO_0_CS,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_0_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_0_VOLUME_LABEL_CS,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_0_VOLUME_INFO_0_CS,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_1_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_1_VOLUME_LABEL_CS,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_1_VOLUME_INFO_0_CS,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_2_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_2_VOLUME_LABEL_CS,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_2_VOLUME_INFO_0_CS,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_3_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_3_VOLUME_LABEL_CS,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_3_VOLUME_INFO_0_CS,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_4_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_4_VOLUME_LABEL_CS,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_4_VOLUME_INFO_0_CS,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_5_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_5_VOLUME_LABEL_CS,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_5_VOLUME_INFO_0_CS,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_6_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_6_VOLUME_LABEL_CS,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_6_VOLUME_INFO_0_CS,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_7_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_7_VOLUME_LABEL_CS,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_7_VOLUME_INFO_0_CS,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_8_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_8_VOLUME_LABEL_CS,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_8_VOLUME_INFO_0_CS,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
#endif
   { NULL, NULL, NULL, NULL, NULL, NULL, {{0}}, NULL },
};
struct retro_core_options_v2 options_cs = {
   option_cats_cs,
   option_defs_cs
};

/* RETRO_LANGUAGE_CY */

#define CATEGORY_SYSTEM_LABEL_CY NULL
#define CATEGORY_SYSTEM_INFO_0_CY NULL
#define CATEGORY_VIDEO_LABEL_CY NULL
#define CATEGORY_VIDEO_INFO_0_CY NULL
#define CATEGORY_AUDIO_LABEL_CY NULL
#define CATEGORY_AUDIO_INFO_0_CY NULL
#define CATEGORY_INPUT_LABEL_CY "Mewnbwn"
#define CATEGORY_INPUT_INFO_0_CY NULL
#define CATEGORY_HACKS_LABEL_CY NULL
#define CATEGORY_HACKS_INFO_0_CY NULL
#define CATEGORY_CHANNEL_VOLUME_LABEL_CY NULL
#define CATEGORY_CHANNEL_VOLUME_INFO_0_CY NULL
#define GENESIS_PLUS_GX_SYSTEM_HW_LABEL_CY NULL
#define GENESIS_PLUS_GX_SYSTEM_HW_INFO_0_CY NULL
#define OPTION_VAL_AUTO_CY NULL
#define OPTION_VAL_SG_1000_CY NULL
#define OPTION_VAL_SG_1000_II_CY NULL
#define OPTION_VAL_SG_1000_II_RAM_EXT_CY NULL
#define OPTION_VAL_MARK_III_CY NULL
#define OPTION_VAL_MASTER_SYSTEM_CY NULL
#define OPTION_VAL_MASTER_SYSTEM_II_CY NULL
#define OPTION_VAL_GAME_GEAR_CY NULL
#define OPTION_VAL_MEGA_DRIVE_GENESIS_CY NULL
#define GENESIS_PLUS_GX_REGION_DETECT_LABEL_CY NULL
#define GENESIS_PLUS_GX_REGION_DETECT_INFO_0_CY NULL
#define OPTION_VAL_NTSC_U_CY NULL
#define OPTION_VAL_PAL_CY NULL
#define OPTION_VAL_NTSC_J_CY NULL
#define GENESIS_PLUS_GX_VDP_MODE_LABEL_CY NULL
#define GENESIS_PLUS_GX_VDP_MODE_INFO_0_CY NULL
#define OPTION_VAL_60HZ_CY NULL
#define OPTION_VAL_50HZ_CY NULL
#define GENESIS_PLUS_GX_BIOS_LABEL_CY NULL
#define GENESIS_PLUS_GX_BIOS_INFO_0_CY NULL
#define GENESIS_PLUS_GX_SYSTEM_BRAM_LABEL_CY NULL
#define GENESIS_PLUS_GX_SYSTEM_BRAM_INFO_0_CY NULL
#define OPTION_VAL_PER_BIOS_CY NULL
#define OPTION_VAL_PER_GAME_CY NULL
#define GENESIS_PLUS_GX_CART_BRAM_LABEL_CY NULL
#define GENESIS_PLUS_GX_CART_BRAM_INFO_0_CY NULL
#define OPTION_VAL_PER_CART_CY NULL
#define GENESIS_PLUS_GX_CART_SIZE_LABEL_CY NULL
#define GENESIS_PLUS_GX_CART_SIZE_INFO_0_CY NULL
#define OPTION_VAL_128K_CY NULL
#define OPTION_VAL_256K_CY NULL
#define OPTION_VAL_512K_CY NULL
#define OPTION_VAL_1MEG_CY NULL
#define OPTION_VAL_2MEG_CY NULL
#define OPTION_VAL_4MEG_CY NULL
#define GENESIS_PLUS_GX_ADD_ON_LABEL_CY NULL
#define GENESIS_PLUS_GX_ADD_ON_INFO_0_CY NULL
#define OPTION_VAL_SEGA_MEGA_CD_CY NULL
#define OPTION_VAL_MEGASD_CY NULL
#define OPTION_VAL_NONE_CY "Dim"
#define GENESIS_PLUS_GX_LOCK_ON_LABEL_CY NULL
#define GENESIS_PLUS_GX_LOCK_ON_INFO_0_CY NULL
#define OPTION_VAL_GAME_GENIE_CY NULL
#define OPTION_VAL_ACTION_REPLAY_PRO_CY NULL
#define OPTION_VAL_SONIC_KNUCKLES_CY NULL
#define GENESIS_PLUS_GX_ASPECT_RATIO_LABEL_CY NULL
#define GENESIS_PLUS_GX_ASPECT_RATIO_INFO_0_CY NULL
#define OPTION_VAL_NTSC_PAR_CY NULL
#define OPTION_VAL_PAL_PAR_CY NULL
#define OPTION_VAL_4_3_CY NULL
#define OPTION_VAL_UNCORRECTED_CY NULL
#define GENESIS_PLUS_GX_OVERSCAN_LABEL_CY NULL
#define GENESIS_PLUS_GX_OVERSCAN_INFO_0_CY NULL
#define OPTION_VAL_TOP_BOTTOM_CY NULL
#define OPTION_VAL_LEFT_RIGHT_CY NULL
#define OPTION_VAL_FULL_CY NULL
#define GENESIS_PLUS_GX_LEFT_BORDER_LABEL_CY NULL
#define GENESIS_PLUS_GX_LEFT_BORDER_INFO_0_CY NULL
#define OPTION_VAL_LEFT_BORDER_CY NULL
#define OPTION_VAL_LEFT_RIGHT_BORDERS_CY NULL
#define GENESIS_PLUS_GX_GG_EXTRA_LABEL_CY NULL
#define GENESIS_PLUS_GX_GG_EXTRA_INFO_0_CY NULL
#define GENESIS_PLUS_GX_BLARGG_NTSC_FILTER_LABEL_CY NULL
#define GENESIS_PLUS_GX_BLARGG_NTSC_FILTER_INFO_0_CY NULL
#define OPTION_VAL_MONOCHROME_CY NULL
#define OPTION_VAL_COMPOSITE_CY NULL
#define OPTION_VAL_SVIDEO_CY NULL
#define OPTION_VAL_RGB_CY NULL
#define GENESIS_PLUS_GX_LCD_FILTER_LABEL_CY NULL
#define GENESIS_PLUS_GX_LCD_FILTER_INFO_0_CY NULL
#define GENESIS_PLUS_GX_RENDER_LABEL_CY NULL
#define GENESIS_PLUS_GX_RENDER_INFO_0_CY NULL
#define OPTION_VAL_SINGLE_FIELD_CY NULL
#define OPTION_VAL_DOUBLE_FIELD_CY NULL
#define GENESIS_PLUS_GX_FRAMESKIP_LABEL_CY NULL
#define GENESIS_PLUS_GX_FRAMESKIP_INFO_0_CY NULL
#define OPTION_VAL_MANUAL_CY NULL
#define GENESIS_PLUS_GX_FRAMESKIP_THRESHOLD_LABEL_CY NULL
#define GENESIS_PLUS_GX_FRAMESKIP_THRESHOLD_INFO_0_CY "Pan fydd 'Frameskip' yn cael ei osod i 'Manual', yn pennu'r trothwy meddiannaeth byffer sain (canran) islaw y bydd fframiau yn cael eu hepgor. Mae gwerthoedd uwch yn lleihau'r risg o graclo trwy achosi i fframiau ostwng yn amlach."
#define GENESIS_PLUS_GX_YM2413_LABEL_CY NULL
#define GENESIS_PLUS_GX_YM2413_INFO_0_CY NULL
#define GENESIS_PLUS_GX_YM2413_CORE_LABEL_CY NULL
#define GENESIS_PLUS_GX_YM2413_CORE_INFO_0_CY NULL
#define OPTION_VAL_MAME_CY NULL
#define OPTION_VAL_NUKED_CY NULL
#define GENESIS_PLUS_GX_YM2612_LABEL_CY NULL
#define GENESIS_PLUS_GX_YM2612_INFO_0_CY NULL
#define GENESIS_PLUS_GX_YM2612_INFO_1_CY NULL
#define OPTION_VAL_MAME_YM2612_CY NULL
#define OPTION_VAL_MAME_ASIC_YM3438_CY NULL
#define OPTION_VAL_MAME_ENHANCED_YM3438_CY NULL
#define OPTION_VAL_NUKED_YM2612_CY NULL
#define OPTION_VAL_NUKED_YM3438_CY NULL
#define GENESIS_PLUS_GX_SOUND_OUTPUT_LABEL_CY NULL
#define GENESIS_PLUS_GX_SOUND_OUTPUT_INFO_0_CY NULL
#define OPTION_VAL_STEREO_CY NULL
#define OPTION_VAL_MONO_CY NULL
#define GENESIS_PLUS_GX_AUDIO_FILTER_LABEL_CY NULL
#define GENESIS_PLUS_GX_AUDIO_FILTER_INFO_0_CY NULL
#define OPTION_VAL_LOW_PASS_CY NULL
#define OPTION_VAL_EQ_CY NULL
#define GENESIS_PLUS_GX_LOWPASS_RANGE_LABEL_CY NULL
#define GENESIS_PLUS_GX_LOWPASS_RANGE_INFO_0_CY NULL
#define GENESIS_PLUS_GX_PSG_PREAMP_LABEL_CY NULL
#define GENESIS_PLUS_GX_PSG_PREAMP_INFO_0_CY NULL
#define GENESIS_PLUS_GX_FM_PREAMP_LABEL_CY NULL
#define GENESIS_PLUS_GX_FM_PREAMP_INFO_0_CY NULL
#define GENESIS_PLUS_GX_CDDA_VOLUME_LABEL_CY NULL
#define GENESIS_PLUS_GX_CDDA_VOLUME_INFO_0_CY NULL
#define GENESIS_PLUS_GX_PCM_VOLUME_LABEL_CY NULL
#define GENESIS_PLUS_GX_PCM_VOLUME_INFO_0_CY NULL
#define GENESIS_PLUS_GX_AUDIO_EQ_LOW_LABEL_CY NULL
#define GENESIS_PLUS_GX_AUDIO_EQ_LOW_INFO_0_CY NULL
#define GENESIS_PLUS_GX_AUDIO_EQ_MID_LABEL_CY NULL
#define GENESIS_PLUS_GX_AUDIO_EQ_MID_INFO_0_CY NULL
#define GENESIS_PLUS_GX_AUDIO_EQ_HIGH_LABEL_CY NULL
#define GENESIS_PLUS_GX_AUDIO_EQ_HIGH_INFO_0_CY NULL
#define GENESIS_PLUS_GX_GUN_INPUT_LABEL_CY NULL
#define GENESIS_PLUS_GX_GUN_INPUT_INFO_0_CY NULL
#define OPTION_VAL_LIGHTGUN_CY NULL
#define OPTION_VAL_TOUCHSCREEN_CY NULL
#define GENESIS_PLUS_GX_GUN_CURSOR_LABEL_CY NULL
#define GENESIS_PLUS_GX_GUN_CURSOR_INFO_0_CY NULL
#define GENESIS_PLUS_GX_INVERT_MOUSE_LABEL_CY NULL
#define GENESIS_PLUS_GX_INVERT_MOUSE_INFO_0_CY NULL
#define GENESIS_PLUS_GX_NO_SPRITE_LIMIT_LABEL_CY NULL
#define GENESIS_PLUS_GX_NO_SPRITE_LIMIT_INFO_0_CY NULL
#define GENESIS_PLUS_GX_ENHANCED_VSCROLL_LABEL_CY NULL
#define GENESIS_PLUS_GX_ENHANCED_VSCROLL_INFO_0_CY NULL
#define GENESIS_PLUS_GX_ENHANCED_VSCROLL_LIMIT_LABEL_CY NULL
#define GENESIS_PLUS_GX_ENHANCED_VSCROLL_LIMIT_INFO_0_CY NULL
#define GENESIS_PLUS_GX_OVERCLOCK_LABEL_CY NULL
#define GENESIS_PLUS_GX_OVERCLOCK_INFO_0_CY NULL
#define OPTION_VAL_100_CY NULL
#define OPTION_VAL_125_CY NULL
#define OPTION_VAL_150_CY NULL
#define OPTION_VAL_175_CY NULL
#define OPTION_VAL_200_CY NULL
#define OPTION_VAL_225_CY NULL
#define OPTION_VAL_250_CY NULL
#define OPTION_VAL_275_CY NULL
#define OPTION_VAL_300_CY NULL
#define OPTION_VAL_325_CY NULL
#define OPTION_VAL_350_CY NULL
#define OPTION_VAL_375_CY NULL
#define OPTION_VAL_400_CY NULL
#define OPTION_VAL_425_CY NULL
#define OPTION_VAL_450_CY NULL
#define OPTION_VAL_475_CY NULL
#define OPTION_VAL_500_CY NULL
#define GENESIS_PLUS_GX_FORCE_DTACK_LABEL_CY NULL
#define GENESIS_PLUS_GX_FORCE_DTACK_INFO_0_CY NULL
#define GENESIS_PLUS_GX_ADDR_ERROR_LABEL_CY NULL
#define GENESIS_PLUS_GX_ADDR_ERROR_INFO_0_CY NULL
#define GENESIS_PLUS_GX_CD_LATENCY_LABEL_CY NULL
#define GENESIS_PLUS_GX_CD_LATENCY_INFO_0_CY NULL
#define GENESIS_PLUS_GX_CD_PRECACHE_LABEL_CY NULL
#define GENESIS_PLUS_GX_CD_PRECACHE_INFO_0_CY NULL
#define GENESIS_PLUS_GX_SHOW_ADVANCED_AUDIO_SETTINGS_LABEL_CY NULL
#define GENESIS_PLUS_GX_SHOW_ADVANCED_AUDIO_SETTINGS_INFO_0_CY NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_0_VOLUME_LABEL_CY NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_0_VOLUME_INFO_0_CY NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_1_VOLUME_LABEL_CY NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_1_VOLUME_INFO_0_CY NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_2_VOLUME_LABEL_CY NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_2_VOLUME_INFO_0_CY NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_3_VOLUME_LABEL_CY NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_3_VOLUME_INFO_0_CY NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_0_VOLUME_LABEL_CY NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_0_VOLUME_INFO_0_CY NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_1_VOLUME_LABEL_CY NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_1_VOLUME_INFO_0_CY NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_2_VOLUME_LABEL_CY NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_2_VOLUME_INFO_0_CY NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_3_VOLUME_LABEL_CY NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_3_VOLUME_INFO_0_CY NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_4_VOLUME_LABEL_CY NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_4_VOLUME_INFO_0_CY NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_5_VOLUME_LABEL_CY NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_5_VOLUME_INFO_0_CY NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_0_VOLUME_LABEL_CY NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_0_VOLUME_INFO_0_CY NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_1_VOLUME_LABEL_CY NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_1_VOLUME_INFO_0_CY NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_2_VOLUME_LABEL_CY NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_2_VOLUME_INFO_0_CY NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_3_VOLUME_LABEL_CY NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_3_VOLUME_INFO_0_CY NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_4_VOLUME_LABEL_CY NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_4_VOLUME_INFO_0_CY NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_5_VOLUME_LABEL_CY NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_5_VOLUME_INFO_0_CY NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_6_VOLUME_LABEL_CY NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_6_VOLUME_INFO_0_CY NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_7_VOLUME_LABEL_CY NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_7_VOLUME_INFO_0_CY NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_8_VOLUME_LABEL_CY NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_8_VOLUME_INFO_0_CY NULL

struct retro_core_option_v2_category option_cats_cy[] = {
   {
      "system",
      CATEGORY_SYSTEM_LABEL_CY,
      CATEGORY_SYSTEM_INFO_0_CY
   },
   {
      "video",
      CATEGORY_VIDEO_LABEL_CY,
      CATEGORY_VIDEO_INFO_0_CY
   },
   {
      "audio",
      CATEGORY_AUDIO_LABEL_CY,
      CATEGORY_AUDIO_INFO_0_CY
   },
   {
      "input",
      CATEGORY_INPUT_LABEL_CY,
      CATEGORY_INPUT_INFO_0_CY
   },
   {
      "hacks",
      CATEGORY_HACKS_LABEL_CY,
      CATEGORY_HACKS_INFO_0_CY
   },
   {
      "channel_volume",
      CATEGORY_CHANNEL_VOLUME_LABEL_CY,
      CATEGORY_CHANNEL_VOLUME_INFO_0_CY
   },
   { NULL, NULL, NULL },
};
struct retro_core_option_v2_definition option_defs_cy[] = {
   {
      "genesis_plus_gx_system_hw",
      GENESIS_PLUS_GX_SYSTEM_HW_LABEL_CY,
      NULL,
      GENESIS_PLUS_GX_SYSTEM_HW_INFO_0_CY,
      NULL,
      "system",
      {
         { "auto",                 OPTION_VAL_AUTO_CY                 },
         { "sg-1000",              OPTION_VAL_SG_1000_CY              },
         { "sg-1000 II",           OPTION_VAL_SG_1000_II_CY           },
         { "sg-1000 II + ram ext.",OPTION_VAL_SG_1000_II_RAM_EXT_CY},
         { "mark-III",             OPTION_VAL_MARK_III_CY             },
         { "master system",        OPTION_VAL_MASTER_SYSTEM_CY        },
         { "master system II",     OPTION_VAL_MASTER_SYSTEM_II_CY     },
         { "game gear",            OPTION_VAL_GAME_GEAR_CY            },
         { "mega drive / genesis", OPTION_VAL_MEGA_DRIVE_GENESIS_CY   },
         { NULL, NULL },
      },
      "auto"
   },
   {
      "genesis_plus_gx_region_detect",
      GENESIS_PLUS_GX_REGION_DETECT_LABEL_CY,
      NULL,
      GENESIS_PLUS_GX_REGION_DETECT_INFO_0_CY,
      NULL,
      "system",
      {
         { "auto",    OPTION_VAL_AUTO_CY   },
         { "ntsc-u",  OPTION_VAL_NTSC_U_CY },
         { "pal",     OPTION_VAL_PAL_CY    },
         { "ntsc-j",  OPTION_VAL_NTSC_J_CY },
         { NULL, NULL },
      },
      "auto"
   },
   {
      "genesis_plus_gx_vdp_mode",
      GENESIS_PLUS_GX_VDP_MODE_LABEL_CY,
      NULL,
      GENESIS_PLUS_GX_VDP_MODE_INFO_0_CY,
      NULL,
      "system",
      {
         { "auto",  "Disabled" },
         { "60hz",  OPTION_VAL_60HZ_CY },
         { "50hz",  OPTION_VAL_50HZ_CY },
         { NULL, NULL },
      },
      "auto"
   },
   {
      "genesis_plus_gx_bios",
      GENESIS_PLUS_GX_BIOS_LABEL_CY,
      NULL,
      GENESIS_PLUS_GX_BIOS_INFO_0_CY,
      NULL,
      "system",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_system_bram",
      GENESIS_PLUS_GX_SYSTEM_BRAM_LABEL_CY,
      NULL,
      GENESIS_PLUS_GX_SYSTEM_BRAM_INFO_0_CY,
      NULL,
      "system",
      {
         { "per bios", OPTION_VAL_PER_BIOS_CY },
         { "per game", OPTION_VAL_PER_GAME_CY },
         { NULL, NULL },
      },
      "per bios"
   },
   {
      "genesis_plus_gx_cart_bram",
      GENESIS_PLUS_GX_CART_BRAM_LABEL_CY,
      NULL,
      GENESIS_PLUS_GX_CART_BRAM_INFO_0_CY,
      NULL,
      "system",
      {
         { "per cart", OPTION_VAL_PER_CART_CY },
         { "per game", OPTION_VAL_PER_GAME_CY },
         { NULL, NULL },
      },
      "per cart"
   },
   {
      "genesis_plus_gx_cart_size",
      GENESIS_PLUS_GX_CART_SIZE_LABEL_CY,
      NULL,
      GENESIS_PLUS_GX_CART_SIZE_INFO_0_CY,
      NULL,
      "system",
      {
         { "disabled", "Disabled" },
         { "128k",     OPTION_VAL_128K_CY  },
         { "256k",     OPTION_VAL_256K_CY  },
         { "512k",     OPTION_VAL_512K_CY  },
         { "1meg",     OPTION_VAL_1MEG_CY    },
         { "2meg",     OPTION_VAL_2MEG_CY    },
         { "4meg",     OPTION_VAL_4MEG_CY    },
         { NULL, NULL },
      },
      "4meg"
   },
   {
      "genesis_plus_gx_add_on",
      GENESIS_PLUS_GX_ADD_ON_LABEL_CY,
      NULL,
      GENESIS_PLUS_GX_ADD_ON_INFO_0_CY,
      NULL,
      "system",
      {
         { "auto",         OPTION_VAL_AUTO_CY },
         { "sega/mega cd", OPTION_VAL_SEGA_MEGA_CD_CY },
         { "megasd",       OPTION_VAL_MEGASD_CY },
         { "none",         OPTION_VAL_NONE_CY },
         { NULL, NULL },
      },
      "auto"
   },
   {
      "genesis_plus_gx_lock_on",
      GENESIS_PLUS_GX_LOCK_ON_LABEL_CY,
      NULL,
      GENESIS_PLUS_GX_LOCK_ON_INFO_0_CY,
      NULL,
      "system",
      {
         { "disabled",            NULL },
         { "game genie",          OPTION_VAL_GAME_GENIE_CY },
         { "action replay (pro)", OPTION_VAL_ACTION_REPLAY_PRO_CY },
         { "sonic & knuckles",    OPTION_VAL_SONIC_KNUCKLES_CY },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_aspect_ratio",
      GENESIS_PLUS_GX_ASPECT_RATIO_LABEL_CY,
      NULL,
      GENESIS_PLUS_GX_ASPECT_RATIO_INFO_0_CY,
      NULL,
      "video",
      {
         { "auto",     OPTION_VAL_AUTO_CY },
         { "NTSC PAR", OPTION_VAL_NTSC_PAR_CY },
         { "PAL PAR",  OPTION_VAL_PAL_PAR_CY },
         { "4:3",  OPTION_VAL_4_3_CY },
         { "Uncorrected",  OPTION_VAL_UNCORRECTED_CY },
      },
      "auto"
   },
   {
      "genesis_plus_gx_overscan",
      GENESIS_PLUS_GX_OVERSCAN_LABEL_CY,
      NULL,
      GENESIS_PLUS_GX_OVERSCAN_INFO_0_CY,
      NULL,
      "video",
      {
         { "disabled",   NULL },
         { "top/bottom", OPTION_VAL_TOP_BOTTOM_CY },
         { "left/right", OPTION_VAL_LEFT_RIGHT_CY },
         { "full",       OPTION_VAL_FULL_CY },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_left_border",
      GENESIS_PLUS_GX_LEFT_BORDER_LABEL_CY,
      NULL,
      GENESIS_PLUS_GX_LEFT_BORDER_INFO_0_CY,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "left border", OPTION_VAL_LEFT_BORDER_CY },
         { "left & right borders", OPTION_VAL_LEFT_RIGHT_BORDERS_CY },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_gg_extra",
      GENESIS_PLUS_GX_GG_EXTRA_LABEL_CY,
      NULL,
      GENESIS_PLUS_GX_GG_EXTRA_INFO_0_CY,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_blargg_ntsc_filter",
      GENESIS_PLUS_GX_BLARGG_NTSC_FILTER_LABEL_CY,
      NULL,
      GENESIS_PLUS_GX_BLARGG_NTSC_FILTER_INFO_0_CY,
      NULL,
      "video",
      {
         { "disabled",   NULL },
         { "monochrome", OPTION_VAL_MONOCHROME_CY },
         { "composite",  OPTION_VAL_COMPOSITE_CY },
         { "svideo",     OPTION_VAL_SVIDEO_CY },
         { "rgb",        OPTION_VAL_RGB_CY },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_lcd_filter",
      GENESIS_PLUS_GX_LCD_FILTER_LABEL_CY,
      NULL,
      GENESIS_PLUS_GX_LCD_FILTER_INFO_0_CY,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_render",
      GENESIS_PLUS_GX_RENDER_LABEL_CY,
      NULL,
      GENESIS_PLUS_GX_RENDER_INFO_0_CY,
      NULL,
      "video",
      {
         { "single field", OPTION_VAL_SINGLE_FIELD_CY },
         { "double field", OPTION_VAL_DOUBLE_FIELD_CY },
         { NULL, NULL },
      },
      "single field"
   },
   {
      "genesis_plus_gx_frameskip",
      GENESIS_PLUS_GX_FRAMESKIP_LABEL_CY,
      NULL,
      GENESIS_PLUS_GX_FRAMESKIP_INFO_0_CY,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "auto",     OPTION_VAL_AUTO_CY },
         { "manual",   OPTION_VAL_MANUAL_CY },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_frameskip_threshold",
      GENESIS_PLUS_GX_FRAMESKIP_THRESHOLD_LABEL_CY,
      NULL,
      GENESIS_PLUS_GX_FRAMESKIP_THRESHOLD_INFO_0_CY,
      NULL,
      "video",
      {
         { "15", NULL },
         { "18", NULL },
         { "21", NULL },
         { "24", NULL },
         { "27", NULL },
         { "30", NULL },
         { "33", NULL },
         { "36", NULL },
         { "39", NULL },
         { "42", NULL },
         { "45", NULL },
         { "48", NULL },
         { "51", NULL },
         { "54", NULL },
         { "57", NULL },
         { "60", NULL },
         { NULL, NULL },
      },
      "33"
   },
   {
      "genesis_plus_gx_ym2413",
      GENESIS_PLUS_GX_YM2413_LABEL_CY,
      NULL,
      GENESIS_PLUS_GX_YM2413_INFO_0_CY,
      NULL,
      "audio",
      {
         { "auto",     OPTION_VAL_AUTO_CY },
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "auto"
   },
#ifdef HAVE_OPLL_CORE
   {
      "genesis_plus_gx_ym2413_core",
      GENESIS_PLUS_GX_YM2413_CORE_LABEL_CY,
      NULL,
      GENESIS_PLUS_GX_YM2413_CORE_INFO_0_CY,
      NULL,
      "audio",
      {
         { "mame",  OPTION_VAL_MAME_CY },
         { "nuked", OPTION_VAL_NUKED_CY },
         { NULL, NULL },
      },
      "mame"
   },
#endif
   {
      "genesis_plus_gx_ym2612",
      GENESIS_PLUS_GX_YM2612_LABEL_CY,
      NULL,
#ifdef HAVE_YM3438_CORE
      GENESIS_PLUS_GX_YM2612_INFO_0_CY,
#else
      GENESIS_PLUS_GX_YM2612_INFO_1_CY,
#endif
      NULL,
      "audio",
      {
         { "mame (ym2612)",          OPTION_VAL_MAME_YM2612_CY },
         { "mame (asic ym3438)",     OPTION_VAL_MAME_ASIC_YM3438_CY },
         { "mame (enhanced ym3438)", OPTION_VAL_MAME_ENHANCED_YM3438_CY },
#ifdef HAVE_YM3438_CORE
         { "nuked (ym2612)",         OPTION_VAL_NUKED_YM2612_CY },
         { "nuked (ym3438)",         OPTION_VAL_NUKED_YM3438_CY },
#endif
         { NULL, NULL },
      },
      "mame (ym2612)"
   },
   {
      "genesis_plus_gx_sound_output",
      GENESIS_PLUS_GX_SOUND_OUTPUT_LABEL_CY,
      NULL,
      GENESIS_PLUS_GX_SOUND_OUTPUT_INFO_0_CY,
      NULL,
      "audio",
      {
         { "stereo", OPTION_VAL_STEREO_CY },
         { "mono",   OPTION_VAL_MONO_CY },
         { NULL, NULL },
      },
      "stereo"
   },
   {
      "genesis_plus_gx_audio_filter",
      GENESIS_PLUS_GX_AUDIO_FILTER_LABEL_CY,
      NULL,
      GENESIS_PLUS_GX_AUDIO_FILTER_INFO_0_CY,
      NULL,
      "audio",
      {
         { "disabled", NULL },
         { "low-pass", OPTION_VAL_LOW_PASS_CY },
#ifdef HAVE_EQ
         { "EQ",       OPTION_VAL_EQ_CY },
#endif
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_lowpass_range",
      GENESIS_PLUS_GX_LOWPASS_RANGE_LABEL_CY,
      NULL,
      GENESIS_PLUS_GX_LOWPASS_RANGE_INFO_0_CY,
      NULL,
      "audio",
      {
         { "5",  NULL },
         { "10", NULL },
         { "15", NULL },
         { "20", NULL },
         { "25", NULL },
         { "30", NULL },
         { "35", NULL },
         { "40", NULL },
         { "45", NULL },
         { "50", NULL },
         { "55", NULL },
         { "60", NULL },
         { "65", NULL },
         { "70", NULL },
         { "75", NULL },
         { "80", NULL },
         { "85", NULL },
         { "90", NULL },
         { "95", NULL },
         { NULL, NULL },
      },
      "60"
   },
   {
      "genesis_plus_gx_psg_preamp",
      GENESIS_PLUS_GX_PSG_PREAMP_LABEL_CY,
      NULL,
      GENESIS_PLUS_GX_PSG_PREAMP_INFO_0_CY,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { "105", NULL },
         { "110", NULL },
         { "115", NULL },
         { "120", NULL },
         { "125", NULL },
         { "130", NULL },
         { "135", NULL },
         { "140", NULL },
         { "145", NULL },
         { "150", NULL },
         { "155", NULL },
         { "160", NULL },
         { "165", NULL },
         { "170", NULL },
         { "175", NULL },
         { "180", NULL },
         { "185", NULL },
         { "190", NULL },
         { "195", NULL },
         { "200", NULL },
         { NULL, NULL },
      },
      "150"
   },
   {
      "genesis_plus_gx_fm_preamp",
      GENESIS_PLUS_GX_FM_PREAMP_LABEL_CY,
      NULL,
      GENESIS_PLUS_GX_FM_PREAMP_INFO_0_CY,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { "105", NULL },
         { "110", NULL },
         { "115", NULL },
         { "120", NULL },
         { "125", NULL },
         { "130", NULL },
         { "135", NULL },
         { "140", NULL },
         { "145", NULL },
         { "150", NULL },
         { "155", NULL },
         { "160", NULL },
         { "165", NULL },
         { "170", NULL },
         { "175", NULL },
         { "180", NULL },
         { "185", NULL },
         { "190", NULL },
         { "195", NULL },
         { "200", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_cdda_volume",
      GENESIS_PLUS_GX_CDDA_VOLUME_LABEL_CY,
      NULL,
      GENESIS_PLUS_GX_CDDA_VOLUME_INFO_0_CY,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_pcm_volume",
      GENESIS_PLUS_GX_PCM_VOLUME_LABEL_CY,
      NULL,
      GENESIS_PLUS_GX_PCM_VOLUME_INFO_0_CY,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
#ifdef HAVE_EQ
   {
      "genesis_plus_gx_audio_eq_low",
      GENESIS_PLUS_GX_AUDIO_EQ_LOW_LABEL_CY,
      NULL,
      GENESIS_PLUS_GX_AUDIO_EQ_LOW_INFO_0_CY,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_audio_eq_mid",
      GENESIS_PLUS_GX_AUDIO_EQ_MID_LABEL_CY,
      NULL,
      GENESIS_PLUS_GX_AUDIO_EQ_MID_INFO_0_CY,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_audio_eq_high",
      GENESIS_PLUS_GX_AUDIO_EQ_HIGH_LABEL_CY,
      NULL,
      GENESIS_PLUS_GX_AUDIO_EQ_HIGH_INFO_0_CY,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
#endif
   {
      "genesis_plus_gx_gun_input",
      GENESIS_PLUS_GX_GUN_INPUT_LABEL_CY,
      NULL,
      GENESIS_PLUS_GX_GUN_INPUT_INFO_0_CY,
      NULL,
      "input",
      {
         { "lightgun",    OPTION_VAL_LIGHTGUN_CY },
         { "touchscreen", OPTION_VAL_TOUCHSCREEN_CY },
         { NULL, NULL },
      },
      "lightgun"
   },
   {
      "genesis_plus_gx_gun_cursor",
      GENESIS_PLUS_GX_GUN_CURSOR_LABEL_CY,
      NULL,
      GENESIS_PLUS_GX_GUN_CURSOR_INFO_0_CY,
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_invert_mouse",
      GENESIS_PLUS_GX_INVERT_MOUSE_LABEL_CY,
      NULL,
      GENESIS_PLUS_GX_INVERT_MOUSE_INFO_0_CY,
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_no_sprite_limit",
      GENESIS_PLUS_GX_NO_SPRITE_LIMIT_LABEL_CY,
      NULL,
      GENESIS_PLUS_GX_NO_SPRITE_LIMIT_INFO_0_CY,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_enhanced_vscroll",
      GENESIS_PLUS_GX_ENHANCED_VSCROLL_LABEL_CY,
      NULL,
      GENESIS_PLUS_GX_ENHANCED_VSCROLL_INFO_0_CY,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_enhanced_vscroll_limit",
      GENESIS_PLUS_GX_ENHANCED_VSCROLL_LIMIT_LABEL_CY,
      NULL,
      GENESIS_PLUS_GX_ENHANCED_VSCROLL_LIMIT_INFO_0_CY,
      NULL,
      "hacks",
      {
         { "2", NULL },
         { "3",  NULL },
         { "4", NULL },
         { "5",  NULL },
         { "6", NULL },
         { "7",  NULL },
         { "8", NULL },
         { "9",  NULL },
         { "10", NULL },
         { "11",  NULL },
         { "12", NULL },
         { "13",  NULL },
         { "14", NULL },
         { "15",  NULL },
         { "16", NULL },
         { NULL, NULL },
      },
      "8"
   },
#ifdef HAVE_OVERCLOCK
   {
      "genesis_plus_gx_overclock",
      GENESIS_PLUS_GX_OVERCLOCK_LABEL_CY,
      NULL,
      GENESIS_PLUS_GX_OVERCLOCK_INFO_0_CY,
      NULL,
      "hacks",
      {
         { "100", OPTION_VAL_100_CY },
         { "125", OPTION_VAL_125_CY },
         { "150", OPTION_VAL_150_CY },
         { "175", OPTION_VAL_175_CY },
         { "200", OPTION_VAL_200_CY },
         { "225", OPTION_VAL_225_CY },
         { "250", OPTION_VAL_250_CY },
         { "275", OPTION_VAL_275_CY },
         { "300", OPTION_VAL_300_CY },
         { "325", OPTION_VAL_325_CY },
         { "350", OPTION_VAL_350_CY },
         { "375", OPTION_VAL_375_CY },
         { "400", OPTION_VAL_400_CY },
         { "425", OPTION_VAL_425_CY },
         { "450", OPTION_VAL_450_CY },
         { "475", OPTION_VAL_475_CY },
         { "500", OPTION_VAL_500_CY },
         { NULL, NULL },
      },
      "100%"
   },
#endif
   {
      "genesis_plus_gx_force_dtack",
      GENESIS_PLUS_GX_FORCE_DTACK_LABEL_CY,
      NULL,
      GENESIS_PLUS_GX_FORCE_DTACK_INFO_0_CY,
      NULL,
      "hacks",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL },
      },
      "enabled"
   },
   {
      "genesis_plus_gx_addr_error",
      GENESIS_PLUS_GX_ADDR_ERROR_LABEL_CY,
      NULL,
      GENESIS_PLUS_GX_ADDR_ERROR_INFO_0_CY,
      NULL,
      "hacks",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL },
      },
      "enabled"
   },
   {
      "genesis_plus_gx_cd_latency",
      GENESIS_PLUS_GX_CD_LATENCY_LABEL_CY,
      NULL,
      GENESIS_PLUS_GX_CD_LATENCY_INFO_0_CY,
      NULL,
      "hacks",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL },
      },
      "enabled"
   },
   {
      "genesis_plus_gx_cd_precache",
      GENESIS_PLUS_GX_CD_PRECACHE_LABEL_CY,
      NULL,
      GENESIS_PLUS_GX_CD_PRECACHE_INFO_0_CY,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
#ifdef USE_PER_SOUND_CHANNELS_CONFIG
   {
      "genesis_plus_gx_show_advanced_audio_settings",
      GENESIS_PLUS_GX_SHOW_ADVANCED_AUDIO_SETTINGS_LABEL_CY,
      NULL,
      GENESIS_PLUS_GX_SHOW_ADVANCED_AUDIO_SETTINGS_INFO_0_CY,
      NULL,
      "channel_volume",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL},
      },
      "disabled"
   },
   {
      "genesis_plus_gx_psg_channel_0_volume",
      GENESIS_PLUS_GX_PSG_CHANNEL_0_VOLUME_LABEL_CY,
      NULL,
      GENESIS_PLUS_GX_PSG_CHANNEL_0_VOLUME_INFO_0_CY,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_psg_channel_1_volume",
      GENESIS_PLUS_GX_PSG_CHANNEL_1_VOLUME_LABEL_CY,
      NULL,
      GENESIS_PLUS_GX_PSG_CHANNEL_1_VOLUME_INFO_0_CY,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_psg_channel_2_volume",
      GENESIS_PLUS_GX_PSG_CHANNEL_2_VOLUME_LABEL_CY,
      NULL,
      GENESIS_PLUS_GX_PSG_CHANNEL_2_VOLUME_INFO_0_CY,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_psg_channel_3_volume",
      GENESIS_PLUS_GX_PSG_CHANNEL_3_VOLUME_LABEL_CY,
      NULL,
      GENESIS_PLUS_GX_PSG_CHANNEL_3_VOLUME_INFO_0_CY,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_0_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_0_VOLUME_LABEL_CY,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_0_VOLUME_INFO_0_CY,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_1_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_1_VOLUME_LABEL_CY,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_1_VOLUME_INFO_0_CY,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_2_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_2_VOLUME_LABEL_CY,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_2_VOLUME_INFO_0_CY,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_3_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_3_VOLUME_LABEL_CY,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_3_VOLUME_INFO_0_CY,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_4_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_4_VOLUME_LABEL_CY,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_4_VOLUME_INFO_0_CY,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_5_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_5_VOLUME_LABEL_CY,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_5_VOLUME_INFO_0_CY,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_0_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_0_VOLUME_LABEL_CY,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_0_VOLUME_INFO_0_CY,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_1_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_1_VOLUME_LABEL_CY,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_1_VOLUME_INFO_0_CY,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_2_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_2_VOLUME_LABEL_CY,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_2_VOLUME_INFO_0_CY,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_3_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_3_VOLUME_LABEL_CY,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_3_VOLUME_INFO_0_CY,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_4_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_4_VOLUME_LABEL_CY,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_4_VOLUME_INFO_0_CY,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_5_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_5_VOLUME_LABEL_CY,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_5_VOLUME_INFO_0_CY,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_6_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_6_VOLUME_LABEL_CY,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_6_VOLUME_INFO_0_CY,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_7_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_7_VOLUME_LABEL_CY,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_7_VOLUME_INFO_0_CY,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_8_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_8_VOLUME_LABEL_CY,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_8_VOLUME_INFO_0_CY,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
#endif
   { NULL, NULL, NULL, NULL, NULL, NULL, {{0}}, NULL },
};
struct retro_core_options_v2 options_cy = {
   option_cats_cy,
   option_defs_cy
};

/* RETRO_LANGUAGE_DA */

#define CATEGORY_SYSTEM_LABEL_DA NULL
#define CATEGORY_SYSTEM_INFO_0_DA NULL
#define CATEGORY_VIDEO_LABEL_DA NULL
#define CATEGORY_VIDEO_INFO_0_DA NULL
#define CATEGORY_AUDIO_LABEL_DA "Lyd"
#define CATEGORY_AUDIO_INFO_0_DA NULL
#define CATEGORY_INPUT_LABEL_DA NULL
#define CATEGORY_INPUT_INFO_0_DA NULL
#define CATEGORY_HACKS_LABEL_DA NULL
#define CATEGORY_HACKS_INFO_0_DA NULL
#define CATEGORY_CHANNEL_VOLUME_LABEL_DA NULL
#define CATEGORY_CHANNEL_VOLUME_INFO_0_DA NULL
#define GENESIS_PLUS_GX_SYSTEM_HW_LABEL_DA NULL
#define GENESIS_PLUS_GX_SYSTEM_HW_INFO_0_DA NULL
#define OPTION_VAL_AUTO_DA NULL
#define OPTION_VAL_SG_1000_DA NULL
#define OPTION_VAL_SG_1000_II_DA NULL
#define OPTION_VAL_SG_1000_II_RAM_EXT_DA NULL
#define OPTION_VAL_MARK_III_DA NULL
#define OPTION_VAL_MASTER_SYSTEM_DA NULL
#define OPTION_VAL_MASTER_SYSTEM_II_DA NULL
#define OPTION_VAL_GAME_GEAR_DA NULL
#define OPTION_VAL_MEGA_DRIVE_GENESIS_DA NULL
#define GENESIS_PLUS_GX_REGION_DETECT_LABEL_DA NULL
#define GENESIS_PLUS_GX_REGION_DETECT_INFO_0_DA NULL
#define OPTION_VAL_NTSC_U_DA NULL
#define OPTION_VAL_PAL_DA NULL
#define OPTION_VAL_NTSC_J_DA NULL
#define GENESIS_PLUS_GX_VDP_MODE_LABEL_DA NULL
#define GENESIS_PLUS_GX_VDP_MODE_INFO_0_DA NULL
#define OPTION_VAL_60HZ_DA NULL
#define OPTION_VAL_50HZ_DA NULL
#define GENESIS_PLUS_GX_BIOS_LABEL_DA NULL
#define GENESIS_PLUS_GX_BIOS_INFO_0_DA NULL
#define GENESIS_PLUS_GX_SYSTEM_BRAM_LABEL_DA NULL
#define GENESIS_PLUS_GX_SYSTEM_BRAM_INFO_0_DA NULL
#define OPTION_VAL_PER_BIOS_DA NULL
#define OPTION_VAL_PER_GAME_DA NULL
#define GENESIS_PLUS_GX_CART_BRAM_LABEL_DA NULL
#define GENESIS_PLUS_GX_CART_BRAM_INFO_0_DA NULL
#define OPTION_VAL_PER_CART_DA NULL
#define GENESIS_PLUS_GX_CART_SIZE_LABEL_DA NULL
#define GENESIS_PLUS_GX_CART_SIZE_INFO_0_DA NULL
#define OPTION_VAL_128K_DA NULL
#define OPTION_VAL_256K_DA NULL
#define OPTION_VAL_512K_DA NULL
#define OPTION_VAL_1MEG_DA NULL
#define OPTION_VAL_2MEG_DA NULL
#define OPTION_VAL_4MEG_DA NULL
#define GENESIS_PLUS_GX_ADD_ON_LABEL_DA NULL
#define GENESIS_PLUS_GX_ADD_ON_INFO_0_DA NULL
#define OPTION_VAL_SEGA_MEGA_CD_DA NULL
#define OPTION_VAL_MEGASD_DA NULL
#define OPTION_VAL_NONE_DA NULL
#define GENESIS_PLUS_GX_LOCK_ON_LABEL_DA NULL
#define GENESIS_PLUS_GX_LOCK_ON_INFO_0_DA NULL
#define OPTION_VAL_GAME_GENIE_DA NULL
#define OPTION_VAL_ACTION_REPLAY_PRO_DA NULL
#define OPTION_VAL_SONIC_KNUCKLES_DA NULL
#define GENESIS_PLUS_GX_ASPECT_RATIO_LABEL_DA NULL
#define GENESIS_PLUS_GX_ASPECT_RATIO_INFO_0_DA NULL
#define OPTION_VAL_NTSC_PAR_DA NULL
#define OPTION_VAL_PAL_PAR_DA NULL
#define OPTION_VAL_4_3_DA NULL
#define OPTION_VAL_UNCORRECTED_DA NULL
#define GENESIS_PLUS_GX_OVERSCAN_LABEL_DA NULL
#define GENESIS_PLUS_GX_OVERSCAN_INFO_0_DA NULL
#define OPTION_VAL_TOP_BOTTOM_DA NULL
#define OPTION_VAL_LEFT_RIGHT_DA NULL
#define OPTION_VAL_FULL_DA NULL
#define GENESIS_PLUS_GX_LEFT_BORDER_LABEL_DA NULL
#define GENESIS_PLUS_GX_LEFT_BORDER_INFO_0_DA NULL
#define OPTION_VAL_LEFT_BORDER_DA NULL
#define OPTION_VAL_LEFT_RIGHT_BORDERS_DA NULL
#define GENESIS_PLUS_GX_GG_EXTRA_LABEL_DA NULL
#define GENESIS_PLUS_GX_GG_EXTRA_INFO_0_DA NULL
#define GENESIS_PLUS_GX_BLARGG_NTSC_FILTER_LABEL_DA NULL
#define GENESIS_PLUS_GX_BLARGG_NTSC_FILTER_INFO_0_DA NULL
#define OPTION_VAL_MONOCHROME_DA NULL
#define OPTION_VAL_COMPOSITE_DA NULL
#define OPTION_VAL_SVIDEO_DA NULL
#define OPTION_VAL_RGB_DA NULL
#define GENESIS_PLUS_GX_LCD_FILTER_LABEL_DA NULL
#define GENESIS_PLUS_GX_LCD_FILTER_INFO_0_DA NULL
#define GENESIS_PLUS_GX_RENDER_LABEL_DA NULL
#define GENESIS_PLUS_GX_RENDER_INFO_0_DA NULL
#define OPTION_VAL_SINGLE_FIELD_DA NULL
#define OPTION_VAL_DOUBLE_FIELD_DA NULL
#define GENESIS_PLUS_GX_FRAMESKIP_LABEL_DA NULL
#define GENESIS_PLUS_GX_FRAMESKIP_INFO_0_DA NULL
#define OPTION_VAL_MANUAL_DA NULL
#define GENESIS_PLUS_GX_FRAMESKIP_THRESHOLD_LABEL_DA NULL
#define GENESIS_PLUS_GX_FRAMESKIP_THRESHOLD_INFO_0_DA "Når 'Frameskip' er sat til 'Manual', angiver den lydbufferbelægningstærsklen (procentdel), under hvilken frames overspringes. Højere værdier reducerer risikoen for crackling ved at foranledige hyppigere drop af frames."
#define GENESIS_PLUS_GX_YM2413_LABEL_DA NULL
#define GENESIS_PLUS_GX_YM2413_INFO_0_DA NULL
#define GENESIS_PLUS_GX_YM2413_CORE_LABEL_DA NULL
#define GENESIS_PLUS_GX_YM2413_CORE_INFO_0_DA NULL
#define OPTION_VAL_MAME_DA NULL
#define OPTION_VAL_NUKED_DA NULL
#define GENESIS_PLUS_GX_YM2612_LABEL_DA NULL
#define GENESIS_PLUS_GX_YM2612_INFO_0_DA NULL
#define GENESIS_PLUS_GX_YM2612_INFO_1_DA NULL
#define OPTION_VAL_MAME_YM2612_DA NULL
#define OPTION_VAL_MAME_ASIC_YM3438_DA NULL
#define OPTION_VAL_MAME_ENHANCED_YM3438_DA NULL
#define OPTION_VAL_NUKED_YM2612_DA NULL
#define OPTION_VAL_NUKED_YM3438_DA NULL
#define GENESIS_PLUS_GX_SOUND_OUTPUT_LABEL_DA NULL
#define GENESIS_PLUS_GX_SOUND_OUTPUT_INFO_0_DA NULL
#define OPTION_VAL_STEREO_DA NULL
#define OPTION_VAL_MONO_DA NULL
#define GENESIS_PLUS_GX_AUDIO_FILTER_LABEL_DA NULL
#define GENESIS_PLUS_GX_AUDIO_FILTER_INFO_0_DA NULL
#define OPTION_VAL_LOW_PASS_DA NULL
#define OPTION_VAL_EQ_DA NULL
#define GENESIS_PLUS_GX_LOWPASS_RANGE_LABEL_DA NULL
#define GENESIS_PLUS_GX_LOWPASS_RANGE_INFO_0_DA NULL
#define GENESIS_PLUS_GX_PSG_PREAMP_LABEL_DA NULL
#define GENESIS_PLUS_GX_PSG_PREAMP_INFO_0_DA NULL
#define GENESIS_PLUS_GX_FM_PREAMP_LABEL_DA NULL
#define GENESIS_PLUS_GX_FM_PREAMP_INFO_0_DA NULL
#define GENESIS_PLUS_GX_CDDA_VOLUME_LABEL_DA NULL
#define GENESIS_PLUS_GX_CDDA_VOLUME_INFO_0_DA NULL
#define GENESIS_PLUS_GX_PCM_VOLUME_LABEL_DA NULL
#define GENESIS_PLUS_GX_PCM_VOLUME_INFO_0_DA NULL
#define GENESIS_PLUS_GX_AUDIO_EQ_LOW_LABEL_DA NULL
#define GENESIS_PLUS_GX_AUDIO_EQ_LOW_INFO_0_DA NULL
#define GENESIS_PLUS_GX_AUDIO_EQ_MID_LABEL_DA NULL
#define GENESIS_PLUS_GX_AUDIO_EQ_MID_INFO_0_DA NULL
#define GENESIS_PLUS_GX_AUDIO_EQ_HIGH_LABEL_DA NULL
#define GENESIS_PLUS_GX_AUDIO_EQ_HIGH_INFO_0_DA NULL
#define GENESIS_PLUS_GX_GUN_INPUT_LABEL_DA NULL
#define GENESIS_PLUS_GX_GUN_INPUT_INFO_0_DA NULL
#define OPTION_VAL_LIGHTGUN_DA NULL
#define OPTION_VAL_TOUCHSCREEN_DA NULL
#define GENESIS_PLUS_GX_GUN_CURSOR_LABEL_DA NULL
#define GENESIS_PLUS_GX_GUN_CURSOR_INFO_0_DA NULL
#define GENESIS_PLUS_GX_INVERT_MOUSE_LABEL_DA NULL
#define GENESIS_PLUS_GX_INVERT_MOUSE_INFO_0_DA NULL
#define GENESIS_PLUS_GX_NO_SPRITE_LIMIT_LABEL_DA NULL
#define GENESIS_PLUS_GX_NO_SPRITE_LIMIT_INFO_0_DA NULL
#define GENESIS_PLUS_GX_ENHANCED_VSCROLL_LABEL_DA NULL
#define GENESIS_PLUS_GX_ENHANCED_VSCROLL_INFO_0_DA NULL
#define GENESIS_PLUS_GX_ENHANCED_VSCROLL_LIMIT_LABEL_DA NULL
#define GENESIS_PLUS_GX_ENHANCED_VSCROLL_LIMIT_INFO_0_DA NULL
#define GENESIS_PLUS_GX_OVERCLOCK_LABEL_DA NULL
#define GENESIS_PLUS_GX_OVERCLOCK_INFO_0_DA NULL
#define OPTION_VAL_100_DA NULL
#define OPTION_VAL_125_DA NULL
#define OPTION_VAL_150_DA NULL
#define OPTION_VAL_175_DA NULL
#define OPTION_VAL_200_DA NULL
#define OPTION_VAL_225_DA NULL
#define OPTION_VAL_250_DA NULL
#define OPTION_VAL_275_DA NULL
#define OPTION_VAL_300_DA NULL
#define OPTION_VAL_325_DA NULL
#define OPTION_VAL_350_DA NULL
#define OPTION_VAL_375_DA NULL
#define OPTION_VAL_400_DA NULL
#define OPTION_VAL_425_DA NULL
#define OPTION_VAL_450_DA NULL
#define OPTION_VAL_475_DA NULL
#define OPTION_VAL_500_DA NULL
#define GENESIS_PLUS_GX_FORCE_DTACK_LABEL_DA NULL
#define GENESIS_PLUS_GX_FORCE_DTACK_INFO_0_DA NULL
#define GENESIS_PLUS_GX_ADDR_ERROR_LABEL_DA NULL
#define GENESIS_PLUS_GX_ADDR_ERROR_INFO_0_DA NULL
#define GENESIS_PLUS_GX_CD_LATENCY_LABEL_DA NULL
#define GENESIS_PLUS_GX_CD_LATENCY_INFO_0_DA NULL
#define GENESIS_PLUS_GX_CD_PRECACHE_LABEL_DA NULL
#define GENESIS_PLUS_GX_CD_PRECACHE_INFO_0_DA NULL
#define GENESIS_PLUS_GX_SHOW_ADVANCED_AUDIO_SETTINGS_LABEL_DA NULL
#define GENESIS_PLUS_GX_SHOW_ADVANCED_AUDIO_SETTINGS_INFO_0_DA NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_0_VOLUME_LABEL_DA NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_0_VOLUME_INFO_0_DA NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_1_VOLUME_LABEL_DA NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_1_VOLUME_INFO_0_DA NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_2_VOLUME_LABEL_DA NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_2_VOLUME_INFO_0_DA NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_3_VOLUME_LABEL_DA NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_3_VOLUME_INFO_0_DA NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_0_VOLUME_LABEL_DA NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_0_VOLUME_INFO_0_DA NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_1_VOLUME_LABEL_DA NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_1_VOLUME_INFO_0_DA NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_2_VOLUME_LABEL_DA NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_2_VOLUME_INFO_0_DA NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_3_VOLUME_LABEL_DA NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_3_VOLUME_INFO_0_DA NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_4_VOLUME_LABEL_DA NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_4_VOLUME_INFO_0_DA NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_5_VOLUME_LABEL_DA NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_5_VOLUME_INFO_0_DA NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_0_VOLUME_LABEL_DA NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_0_VOLUME_INFO_0_DA NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_1_VOLUME_LABEL_DA NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_1_VOLUME_INFO_0_DA NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_2_VOLUME_LABEL_DA NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_2_VOLUME_INFO_0_DA NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_3_VOLUME_LABEL_DA NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_3_VOLUME_INFO_0_DA NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_4_VOLUME_LABEL_DA NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_4_VOLUME_INFO_0_DA NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_5_VOLUME_LABEL_DA NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_5_VOLUME_INFO_0_DA NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_6_VOLUME_LABEL_DA NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_6_VOLUME_INFO_0_DA NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_7_VOLUME_LABEL_DA NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_7_VOLUME_INFO_0_DA NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_8_VOLUME_LABEL_DA NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_8_VOLUME_INFO_0_DA NULL

struct retro_core_option_v2_category option_cats_da[] = {
   {
      "system",
      CATEGORY_SYSTEM_LABEL_DA,
      CATEGORY_SYSTEM_INFO_0_DA
   },
   {
      "video",
      CATEGORY_VIDEO_LABEL_DA,
      CATEGORY_VIDEO_INFO_0_DA
   },
   {
      "audio",
      CATEGORY_AUDIO_LABEL_DA,
      CATEGORY_AUDIO_INFO_0_DA
   },
   {
      "input",
      CATEGORY_INPUT_LABEL_DA,
      CATEGORY_INPUT_INFO_0_DA
   },
   {
      "hacks",
      CATEGORY_HACKS_LABEL_DA,
      CATEGORY_HACKS_INFO_0_DA
   },
   {
      "channel_volume",
      CATEGORY_CHANNEL_VOLUME_LABEL_DA,
      CATEGORY_CHANNEL_VOLUME_INFO_0_DA
   },
   { NULL, NULL, NULL },
};
struct retro_core_option_v2_definition option_defs_da[] = {
   {
      "genesis_plus_gx_system_hw",
      GENESIS_PLUS_GX_SYSTEM_HW_LABEL_DA,
      NULL,
      GENESIS_PLUS_GX_SYSTEM_HW_INFO_0_DA,
      NULL,
      "system",
      {
         { "auto",                 OPTION_VAL_AUTO_DA                 },
         { "sg-1000",              OPTION_VAL_SG_1000_DA              },
         { "sg-1000 II",           OPTION_VAL_SG_1000_II_DA           },
         { "sg-1000 II + ram ext.",OPTION_VAL_SG_1000_II_RAM_EXT_DA},
         { "mark-III",             OPTION_VAL_MARK_III_DA             },
         { "master system",        OPTION_VAL_MASTER_SYSTEM_DA        },
         { "master system II",     OPTION_VAL_MASTER_SYSTEM_II_DA     },
         { "game gear",            OPTION_VAL_GAME_GEAR_DA            },
         { "mega drive / genesis", OPTION_VAL_MEGA_DRIVE_GENESIS_DA   },
         { NULL, NULL },
      },
      "auto"
   },
   {
      "genesis_plus_gx_region_detect",
      GENESIS_PLUS_GX_REGION_DETECT_LABEL_DA,
      NULL,
      GENESIS_PLUS_GX_REGION_DETECT_INFO_0_DA,
      NULL,
      "system",
      {
         { "auto",    OPTION_VAL_AUTO_DA   },
         { "ntsc-u",  OPTION_VAL_NTSC_U_DA },
         { "pal",     OPTION_VAL_PAL_DA    },
         { "ntsc-j",  OPTION_VAL_NTSC_J_DA },
         { NULL, NULL },
      },
      "auto"
   },
   {
      "genesis_plus_gx_vdp_mode",
      GENESIS_PLUS_GX_VDP_MODE_LABEL_DA,
      NULL,
      GENESIS_PLUS_GX_VDP_MODE_INFO_0_DA,
      NULL,
      "system",
      {
         { "auto",  "Disabled" },
         { "60hz",  OPTION_VAL_60HZ_DA },
         { "50hz",  OPTION_VAL_50HZ_DA },
         { NULL, NULL },
      },
      "auto"
   },
   {
      "genesis_plus_gx_bios",
      GENESIS_PLUS_GX_BIOS_LABEL_DA,
      NULL,
      GENESIS_PLUS_GX_BIOS_INFO_0_DA,
      NULL,
      "system",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_system_bram",
      GENESIS_PLUS_GX_SYSTEM_BRAM_LABEL_DA,
      NULL,
      GENESIS_PLUS_GX_SYSTEM_BRAM_INFO_0_DA,
      NULL,
      "system",
      {
         { "per bios", OPTION_VAL_PER_BIOS_DA },
         { "per game", OPTION_VAL_PER_GAME_DA },
         { NULL, NULL },
      },
      "per bios"
   },
   {
      "genesis_plus_gx_cart_bram",
      GENESIS_PLUS_GX_CART_BRAM_LABEL_DA,
      NULL,
      GENESIS_PLUS_GX_CART_BRAM_INFO_0_DA,
      NULL,
      "system",
      {
         { "per cart", OPTION_VAL_PER_CART_DA },
         { "per game", OPTION_VAL_PER_GAME_DA },
         { NULL, NULL },
      },
      "per cart"
   },
   {
      "genesis_plus_gx_cart_size",
      GENESIS_PLUS_GX_CART_SIZE_LABEL_DA,
      NULL,
      GENESIS_PLUS_GX_CART_SIZE_INFO_0_DA,
      NULL,
      "system",
      {
         { "disabled", "Disabled" },
         { "128k",     OPTION_VAL_128K_DA  },
         { "256k",     OPTION_VAL_256K_DA  },
         { "512k",     OPTION_VAL_512K_DA  },
         { "1meg",     OPTION_VAL_1MEG_DA    },
         { "2meg",     OPTION_VAL_2MEG_DA    },
         { "4meg",     OPTION_VAL_4MEG_DA    },
         { NULL, NULL },
      },
      "4meg"
   },
   {
      "genesis_plus_gx_add_on",
      GENESIS_PLUS_GX_ADD_ON_LABEL_DA,
      NULL,
      GENESIS_PLUS_GX_ADD_ON_INFO_0_DA,
      NULL,
      "system",
      {
         { "auto",         OPTION_VAL_AUTO_DA },
         { "sega/mega cd", OPTION_VAL_SEGA_MEGA_CD_DA },
         { "megasd",       OPTION_VAL_MEGASD_DA },
         { "none",         OPTION_VAL_NONE_DA },
         { NULL, NULL },
      },
      "auto"
   },
   {
      "genesis_plus_gx_lock_on",
      GENESIS_PLUS_GX_LOCK_ON_LABEL_DA,
      NULL,
      GENESIS_PLUS_GX_LOCK_ON_INFO_0_DA,
      NULL,
      "system",
      {
         { "disabled",            NULL },
         { "game genie",          OPTION_VAL_GAME_GENIE_DA },
         { "action replay (pro)", OPTION_VAL_ACTION_REPLAY_PRO_DA },
         { "sonic & knuckles",    OPTION_VAL_SONIC_KNUCKLES_DA },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_aspect_ratio",
      GENESIS_PLUS_GX_ASPECT_RATIO_LABEL_DA,
      NULL,
      GENESIS_PLUS_GX_ASPECT_RATIO_INFO_0_DA,
      NULL,
      "video",
      {
         { "auto",     OPTION_VAL_AUTO_DA },
         { "NTSC PAR", OPTION_VAL_NTSC_PAR_DA },
         { "PAL PAR",  OPTION_VAL_PAL_PAR_DA },
         { "4:3",  OPTION_VAL_4_3_DA },
         { "Uncorrected",  OPTION_VAL_UNCORRECTED_DA },
      },
      "auto"
   },
   {
      "genesis_plus_gx_overscan",
      GENESIS_PLUS_GX_OVERSCAN_LABEL_DA,
      NULL,
      GENESIS_PLUS_GX_OVERSCAN_INFO_0_DA,
      NULL,
      "video",
      {
         { "disabled",   NULL },
         { "top/bottom", OPTION_VAL_TOP_BOTTOM_DA },
         { "left/right", OPTION_VAL_LEFT_RIGHT_DA },
         { "full",       OPTION_VAL_FULL_DA },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_left_border",
      GENESIS_PLUS_GX_LEFT_BORDER_LABEL_DA,
      NULL,
      GENESIS_PLUS_GX_LEFT_BORDER_INFO_0_DA,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "left border", OPTION_VAL_LEFT_BORDER_DA },
         { "left & right borders", OPTION_VAL_LEFT_RIGHT_BORDERS_DA },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_gg_extra",
      GENESIS_PLUS_GX_GG_EXTRA_LABEL_DA,
      NULL,
      GENESIS_PLUS_GX_GG_EXTRA_INFO_0_DA,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_blargg_ntsc_filter",
      GENESIS_PLUS_GX_BLARGG_NTSC_FILTER_LABEL_DA,
      NULL,
      GENESIS_PLUS_GX_BLARGG_NTSC_FILTER_INFO_0_DA,
      NULL,
      "video",
      {
         { "disabled",   NULL },
         { "monochrome", OPTION_VAL_MONOCHROME_DA },
         { "composite",  OPTION_VAL_COMPOSITE_DA },
         { "svideo",     OPTION_VAL_SVIDEO_DA },
         { "rgb",        OPTION_VAL_RGB_DA },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_lcd_filter",
      GENESIS_PLUS_GX_LCD_FILTER_LABEL_DA,
      NULL,
      GENESIS_PLUS_GX_LCD_FILTER_INFO_0_DA,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_render",
      GENESIS_PLUS_GX_RENDER_LABEL_DA,
      NULL,
      GENESIS_PLUS_GX_RENDER_INFO_0_DA,
      NULL,
      "video",
      {
         { "single field", OPTION_VAL_SINGLE_FIELD_DA },
         { "double field", OPTION_VAL_DOUBLE_FIELD_DA },
         { NULL, NULL },
      },
      "single field"
   },
   {
      "genesis_plus_gx_frameskip",
      GENESIS_PLUS_GX_FRAMESKIP_LABEL_DA,
      NULL,
      GENESIS_PLUS_GX_FRAMESKIP_INFO_0_DA,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "auto",     OPTION_VAL_AUTO_DA },
         { "manual",   OPTION_VAL_MANUAL_DA },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_frameskip_threshold",
      GENESIS_PLUS_GX_FRAMESKIP_THRESHOLD_LABEL_DA,
      NULL,
      GENESIS_PLUS_GX_FRAMESKIP_THRESHOLD_INFO_0_DA,
      NULL,
      "video",
      {
         { "15", NULL },
         { "18", NULL },
         { "21", NULL },
         { "24", NULL },
         { "27", NULL },
         { "30", NULL },
         { "33", NULL },
         { "36", NULL },
         { "39", NULL },
         { "42", NULL },
         { "45", NULL },
         { "48", NULL },
         { "51", NULL },
         { "54", NULL },
         { "57", NULL },
         { "60", NULL },
         { NULL, NULL },
      },
      "33"
   },
   {
      "genesis_plus_gx_ym2413",
      GENESIS_PLUS_GX_YM2413_LABEL_DA,
      NULL,
      GENESIS_PLUS_GX_YM2413_INFO_0_DA,
      NULL,
      "audio",
      {
         { "auto",     OPTION_VAL_AUTO_DA },
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "auto"
   },
#ifdef HAVE_OPLL_CORE
   {
      "genesis_plus_gx_ym2413_core",
      GENESIS_PLUS_GX_YM2413_CORE_LABEL_DA,
      NULL,
      GENESIS_PLUS_GX_YM2413_CORE_INFO_0_DA,
      NULL,
      "audio",
      {
         { "mame",  OPTION_VAL_MAME_DA },
         { "nuked", OPTION_VAL_NUKED_DA },
         { NULL, NULL },
      },
      "mame"
   },
#endif
   {
      "genesis_plus_gx_ym2612",
      GENESIS_PLUS_GX_YM2612_LABEL_DA,
      NULL,
#ifdef HAVE_YM3438_CORE
      GENESIS_PLUS_GX_YM2612_INFO_0_DA,
#else
      GENESIS_PLUS_GX_YM2612_INFO_1_DA,
#endif
      NULL,
      "audio",
      {
         { "mame (ym2612)",          OPTION_VAL_MAME_YM2612_DA },
         { "mame (asic ym3438)",     OPTION_VAL_MAME_ASIC_YM3438_DA },
         { "mame (enhanced ym3438)", OPTION_VAL_MAME_ENHANCED_YM3438_DA },
#ifdef HAVE_YM3438_CORE
         { "nuked (ym2612)",         OPTION_VAL_NUKED_YM2612_DA },
         { "nuked (ym3438)",         OPTION_VAL_NUKED_YM3438_DA },
#endif
         { NULL, NULL },
      },
      "mame (ym2612)"
   },
   {
      "genesis_plus_gx_sound_output",
      GENESIS_PLUS_GX_SOUND_OUTPUT_LABEL_DA,
      NULL,
      GENESIS_PLUS_GX_SOUND_OUTPUT_INFO_0_DA,
      NULL,
      "audio",
      {
         { "stereo", OPTION_VAL_STEREO_DA },
         { "mono",   OPTION_VAL_MONO_DA },
         { NULL, NULL },
      },
      "stereo"
   },
   {
      "genesis_plus_gx_audio_filter",
      GENESIS_PLUS_GX_AUDIO_FILTER_LABEL_DA,
      NULL,
      GENESIS_PLUS_GX_AUDIO_FILTER_INFO_0_DA,
      NULL,
      "audio",
      {
         { "disabled", NULL },
         { "low-pass", OPTION_VAL_LOW_PASS_DA },
#ifdef HAVE_EQ
         { "EQ",       OPTION_VAL_EQ_DA },
#endif
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_lowpass_range",
      GENESIS_PLUS_GX_LOWPASS_RANGE_LABEL_DA,
      NULL,
      GENESIS_PLUS_GX_LOWPASS_RANGE_INFO_0_DA,
      NULL,
      "audio",
      {
         { "5",  NULL },
         { "10", NULL },
         { "15", NULL },
         { "20", NULL },
         { "25", NULL },
         { "30", NULL },
         { "35", NULL },
         { "40", NULL },
         { "45", NULL },
         { "50", NULL },
         { "55", NULL },
         { "60", NULL },
         { "65", NULL },
         { "70", NULL },
         { "75", NULL },
         { "80", NULL },
         { "85", NULL },
         { "90", NULL },
         { "95", NULL },
         { NULL, NULL },
      },
      "60"
   },
   {
      "genesis_plus_gx_psg_preamp",
      GENESIS_PLUS_GX_PSG_PREAMP_LABEL_DA,
      NULL,
      GENESIS_PLUS_GX_PSG_PREAMP_INFO_0_DA,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { "105", NULL },
         { "110", NULL },
         { "115", NULL },
         { "120", NULL },
         { "125", NULL },
         { "130", NULL },
         { "135", NULL },
         { "140", NULL },
         { "145", NULL },
         { "150", NULL },
         { "155", NULL },
         { "160", NULL },
         { "165", NULL },
         { "170", NULL },
         { "175", NULL },
         { "180", NULL },
         { "185", NULL },
         { "190", NULL },
         { "195", NULL },
         { "200", NULL },
         { NULL, NULL },
      },
      "150"
   },
   {
      "genesis_plus_gx_fm_preamp",
      GENESIS_PLUS_GX_FM_PREAMP_LABEL_DA,
      NULL,
      GENESIS_PLUS_GX_FM_PREAMP_INFO_0_DA,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { "105", NULL },
         { "110", NULL },
         { "115", NULL },
         { "120", NULL },
         { "125", NULL },
         { "130", NULL },
         { "135", NULL },
         { "140", NULL },
         { "145", NULL },
         { "150", NULL },
         { "155", NULL },
         { "160", NULL },
         { "165", NULL },
         { "170", NULL },
         { "175", NULL },
         { "180", NULL },
         { "185", NULL },
         { "190", NULL },
         { "195", NULL },
         { "200", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_cdda_volume",
      GENESIS_PLUS_GX_CDDA_VOLUME_LABEL_DA,
      NULL,
      GENESIS_PLUS_GX_CDDA_VOLUME_INFO_0_DA,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_pcm_volume",
      GENESIS_PLUS_GX_PCM_VOLUME_LABEL_DA,
      NULL,
      GENESIS_PLUS_GX_PCM_VOLUME_INFO_0_DA,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
#ifdef HAVE_EQ
   {
      "genesis_plus_gx_audio_eq_low",
      GENESIS_PLUS_GX_AUDIO_EQ_LOW_LABEL_DA,
      NULL,
      GENESIS_PLUS_GX_AUDIO_EQ_LOW_INFO_0_DA,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_audio_eq_mid",
      GENESIS_PLUS_GX_AUDIO_EQ_MID_LABEL_DA,
      NULL,
      GENESIS_PLUS_GX_AUDIO_EQ_MID_INFO_0_DA,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_audio_eq_high",
      GENESIS_PLUS_GX_AUDIO_EQ_HIGH_LABEL_DA,
      NULL,
      GENESIS_PLUS_GX_AUDIO_EQ_HIGH_INFO_0_DA,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
#endif
   {
      "genesis_plus_gx_gun_input",
      GENESIS_PLUS_GX_GUN_INPUT_LABEL_DA,
      NULL,
      GENESIS_PLUS_GX_GUN_INPUT_INFO_0_DA,
      NULL,
      "input",
      {
         { "lightgun",    OPTION_VAL_LIGHTGUN_DA },
         { "touchscreen", OPTION_VAL_TOUCHSCREEN_DA },
         { NULL, NULL },
      },
      "lightgun"
   },
   {
      "genesis_plus_gx_gun_cursor",
      GENESIS_PLUS_GX_GUN_CURSOR_LABEL_DA,
      NULL,
      GENESIS_PLUS_GX_GUN_CURSOR_INFO_0_DA,
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_invert_mouse",
      GENESIS_PLUS_GX_INVERT_MOUSE_LABEL_DA,
      NULL,
      GENESIS_PLUS_GX_INVERT_MOUSE_INFO_0_DA,
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_no_sprite_limit",
      GENESIS_PLUS_GX_NO_SPRITE_LIMIT_LABEL_DA,
      NULL,
      GENESIS_PLUS_GX_NO_SPRITE_LIMIT_INFO_0_DA,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_enhanced_vscroll",
      GENESIS_PLUS_GX_ENHANCED_VSCROLL_LABEL_DA,
      NULL,
      GENESIS_PLUS_GX_ENHANCED_VSCROLL_INFO_0_DA,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_enhanced_vscroll_limit",
      GENESIS_PLUS_GX_ENHANCED_VSCROLL_LIMIT_LABEL_DA,
      NULL,
      GENESIS_PLUS_GX_ENHANCED_VSCROLL_LIMIT_INFO_0_DA,
      NULL,
      "hacks",
      {
         { "2", NULL },
         { "3",  NULL },
         { "4", NULL },
         { "5",  NULL },
         { "6", NULL },
         { "7",  NULL },
         { "8", NULL },
         { "9",  NULL },
         { "10", NULL },
         { "11",  NULL },
         { "12", NULL },
         { "13",  NULL },
         { "14", NULL },
         { "15",  NULL },
         { "16", NULL },
         { NULL, NULL },
      },
      "8"
   },
#ifdef HAVE_OVERCLOCK
   {
      "genesis_plus_gx_overclock",
      GENESIS_PLUS_GX_OVERCLOCK_LABEL_DA,
      NULL,
      GENESIS_PLUS_GX_OVERCLOCK_INFO_0_DA,
      NULL,
      "hacks",
      {
         { "100", OPTION_VAL_100_DA },
         { "125", OPTION_VAL_125_DA },
         { "150", OPTION_VAL_150_DA },
         { "175", OPTION_VAL_175_DA },
         { "200", OPTION_VAL_200_DA },
         { "225", OPTION_VAL_225_DA },
         { "250", OPTION_VAL_250_DA },
         { "275", OPTION_VAL_275_DA },
         { "300", OPTION_VAL_300_DA },
         { "325", OPTION_VAL_325_DA },
         { "350", OPTION_VAL_350_DA },
         { "375", OPTION_VAL_375_DA },
         { "400", OPTION_VAL_400_DA },
         { "425", OPTION_VAL_425_DA },
         { "450", OPTION_VAL_450_DA },
         { "475", OPTION_VAL_475_DA },
         { "500", OPTION_VAL_500_DA },
         { NULL, NULL },
      },
      "100%"
   },
#endif
   {
      "genesis_plus_gx_force_dtack",
      GENESIS_PLUS_GX_FORCE_DTACK_LABEL_DA,
      NULL,
      GENESIS_PLUS_GX_FORCE_DTACK_INFO_0_DA,
      NULL,
      "hacks",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL },
      },
      "enabled"
   },
   {
      "genesis_plus_gx_addr_error",
      GENESIS_PLUS_GX_ADDR_ERROR_LABEL_DA,
      NULL,
      GENESIS_PLUS_GX_ADDR_ERROR_INFO_0_DA,
      NULL,
      "hacks",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL },
      },
      "enabled"
   },
   {
      "genesis_plus_gx_cd_latency",
      GENESIS_PLUS_GX_CD_LATENCY_LABEL_DA,
      NULL,
      GENESIS_PLUS_GX_CD_LATENCY_INFO_0_DA,
      NULL,
      "hacks",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL },
      },
      "enabled"
   },
   {
      "genesis_plus_gx_cd_precache",
      GENESIS_PLUS_GX_CD_PRECACHE_LABEL_DA,
      NULL,
      GENESIS_PLUS_GX_CD_PRECACHE_INFO_0_DA,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
#ifdef USE_PER_SOUND_CHANNELS_CONFIG
   {
      "genesis_plus_gx_show_advanced_audio_settings",
      GENESIS_PLUS_GX_SHOW_ADVANCED_AUDIO_SETTINGS_LABEL_DA,
      NULL,
      GENESIS_PLUS_GX_SHOW_ADVANCED_AUDIO_SETTINGS_INFO_0_DA,
      NULL,
      "channel_volume",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL},
      },
      "disabled"
   },
   {
      "genesis_plus_gx_psg_channel_0_volume",
      GENESIS_PLUS_GX_PSG_CHANNEL_0_VOLUME_LABEL_DA,
      NULL,
      GENESIS_PLUS_GX_PSG_CHANNEL_0_VOLUME_INFO_0_DA,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_psg_channel_1_volume",
      GENESIS_PLUS_GX_PSG_CHANNEL_1_VOLUME_LABEL_DA,
      NULL,
      GENESIS_PLUS_GX_PSG_CHANNEL_1_VOLUME_INFO_0_DA,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_psg_channel_2_volume",
      GENESIS_PLUS_GX_PSG_CHANNEL_2_VOLUME_LABEL_DA,
      NULL,
      GENESIS_PLUS_GX_PSG_CHANNEL_2_VOLUME_INFO_0_DA,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_psg_channel_3_volume",
      GENESIS_PLUS_GX_PSG_CHANNEL_3_VOLUME_LABEL_DA,
      NULL,
      GENESIS_PLUS_GX_PSG_CHANNEL_3_VOLUME_INFO_0_DA,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_0_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_0_VOLUME_LABEL_DA,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_0_VOLUME_INFO_0_DA,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_1_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_1_VOLUME_LABEL_DA,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_1_VOLUME_INFO_0_DA,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_2_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_2_VOLUME_LABEL_DA,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_2_VOLUME_INFO_0_DA,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_3_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_3_VOLUME_LABEL_DA,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_3_VOLUME_INFO_0_DA,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_4_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_4_VOLUME_LABEL_DA,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_4_VOLUME_INFO_0_DA,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_5_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_5_VOLUME_LABEL_DA,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_5_VOLUME_INFO_0_DA,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_0_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_0_VOLUME_LABEL_DA,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_0_VOLUME_INFO_0_DA,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_1_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_1_VOLUME_LABEL_DA,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_1_VOLUME_INFO_0_DA,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_2_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_2_VOLUME_LABEL_DA,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_2_VOLUME_INFO_0_DA,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_3_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_3_VOLUME_LABEL_DA,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_3_VOLUME_INFO_0_DA,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_4_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_4_VOLUME_LABEL_DA,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_4_VOLUME_INFO_0_DA,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_5_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_5_VOLUME_LABEL_DA,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_5_VOLUME_INFO_0_DA,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_6_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_6_VOLUME_LABEL_DA,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_6_VOLUME_INFO_0_DA,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_7_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_7_VOLUME_LABEL_DA,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_7_VOLUME_INFO_0_DA,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_8_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_8_VOLUME_LABEL_DA,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_8_VOLUME_INFO_0_DA,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
#endif
   { NULL, NULL, NULL, NULL, NULL, NULL, {{0}}, NULL },
};
struct retro_core_options_v2 options_da = {
   option_cats_da,
   option_defs_da
};

/* RETRO_LANGUAGE_DE */

#define CATEGORY_SYSTEM_LABEL_DE NULL
#define CATEGORY_SYSTEM_INFO_0_DE "Auswahl der Basis-Hardware, Region, BIOS und Sega-CD-/Mega-CD-Speicherdatei-Einstellungen ändern."
#define CATEGORY_VIDEO_LABEL_DE NULL
#define CATEGORY_VIDEO_INFO_0_DE "Einstellungen für Seitenverhältnis, Bildausschnitt, Videofilter und Frameskipping ändern."
#define CATEGORY_AUDIO_LABEL_DE NULL
#define CATEGORY_AUDIO_INFO_0_DE "Audiogerät-Einstellungen ändern."
#define CATEGORY_INPUT_LABEL_DE "Eingabe"
#define CATEGORY_INPUT_INFO_0_DE "Einstellungen für Lightgun und/oder Mauseingabe ändern."
#define CATEGORY_HACKS_LABEL_DE "Emulations-Hacks"
#define CATEGORY_HACKS_INFO_0_DE "Parameter für Prozessorübertaktung und Emulationsgenauigkeit, die sich auf die Low-Level-Leistung und Kompatibilität auswirken, ändern."
#define CATEGORY_CHANNEL_VOLUME_LABEL_DE "Erweiterte Lautstärkeeinstellungen"
#define CATEGORY_CHANNEL_VOLUME_INFO_0_DE "Die Lautstärke der einzelnen Hardware-Audiokanäle anpassen."
#define GENESIS_PLUS_GX_SYSTEM_HW_LABEL_DE "System-Hardware"
#define GENESIS_PLUS_GX_SYSTEM_HW_INFO_0_DE "Führt geladene Inhalte mit einer bestimmten emulierten Konsole aus. \"Automatisch\" wählt das für das aktuelle Spiel am besten geeignete System aus."
#define OPTION_VAL_AUTO_DE NULL
#define OPTION_VAL_SG_1000_DE NULL
#define OPTION_VAL_SG_1000_II_DE NULL
#define OPTION_VAL_SG_1000_II_RAM_EXT_DE "SG-1000 II + RAM Erw."
#define OPTION_VAL_MARK_III_DE NULL
#define OPTION_VAL_MASTER_SYSTEM_DE NULL
#define OPTION_VAL_MASTER_SYSTEM_II_DE NULL
#define OPTION_VAL_GAME_GEAR_DE NULL
#define OPTION_VAL_MEGA_DRIVE_GENESIS_DE NULL
#define GENESIS_PLUS_GX_REGION_DETECT_LABEL_DE "Systemregion"
#define GENESIS_PLUS_GX_REGION_DETECT_INFO_0_DE "Region des Systems festlegen. Bei anderen Konsolen als dem Game Gear steht \"PAL\" für 50 Hz, während \"NTSC\" für 60 Hz steht. Spiele können schneller oder langsamer als normal laufen, wenn die falsche Region ausgewählt ist."
#define OPTION_VAL_NTSC_U_DE NULL
#define OPTION_VAL_PAL_DE NULL
#define OPTION_VAL_NTSC_J_DE NULL
#define GENESIS_PLUS_GX_VDP_MODE_LABEL_DE "VDP-Modus erzwingen"
#define GENESIS_PLUS_GX_VDP_MODE_INFO_0_DE "Überschreibt den VDP-Modus, um ihn entweder mit NTSC 60 Hz oder PAL 50 Hz laufen zu lassen, unabhängig von der Region des Systems."
#define OPTION_VAL_60HZ_DE "NTSC (60 Hz)"
#define OPTION_VAL_50HZ_DE "PAL (50 Hz)"
#define GENESIS_PLUS_GX_BIOS_LABEL_DE "System-Boot-ROM"
#define GENESIS_PLUS_GX_BIOS_INFO_0_DE "Offiziellen BIOS/Bootloader für emulierte Hardware verwenden, falls im Systemverzeichnis von RetroArch vorhanden. Zeigt eine konsolenspezifische Startsequenz/Animation an und führt dann den geladenen Inhalt aus."
#define GENESIS_PLUS_GX_SYSTEM_BRAM_LABEL_DE "CD-System BRAM (Neustart erforderlich)"
#define GENESIS_PLUS_GX_SYSTEM_BRAM_INFO_0_DE "Legt beim Ausführen von Sega CD/Mega CD-Inhalten fest, ob eine einzige Speicherdatei für alle Spiele aus einer bestimmten Region (Pro BIOS) geteilt wird oder eine separate Speicherdatei für jedes Spiel (Pro Spiel) erstellt werden soll. Zu beachten ist, dass das Sega CD/Mega CD über einen begrenzten internen Speicherplatz verfügt, der nur für eine Handvoll Titel ausreicht. Um zu vermeiden, dass der Speicherplatz knapp wird, wird die Einstellung 'Pro Spiel' empfohlen."
#define OPTION_VAL_PER_BIOS_DE "Pro BIOS"
#define OPTION_VAL_PER_GAME_DE "Pro Spiel"
#define GENESIS_PLUS_GX_CART_BRAM_LABEL_DE "CD-Speicherkarte BRAM (Neustart erforderlich)"
#define GENESIS_PLUS_GX_CART_BRAM_INFO_0_DE "Legt beim Ausführen von Sega CD/Mega CD-Inhalten fest, ob eine einzige Speicherkarte für alle Spiele (Pro Karte) geteilt wird oder eine separate Speicherkarte für jedes Spiel erstellt werden soll (Pro Spiel)."
#define OPTION_VAL_PER_CART_DE "Pro Karte"
#define GENESIS_PLUS_GX_CART_SIZE_LABEL_DE "CD-Speicherkarte BRAM Größe (Neustart erforderlich)"
#define GENESIS_PLUS_GX_CART_SIZE_INFO_0_DE "Legt die Größe der Speicherkarte fest, wenn Inhalt von Sega CD/Mega-CD ausgeführt wird. Nützlich, wenn die Speicherkarte auf „pro Spiel“ gesetzt wird, um mehrere größere Speicherkartengrößen zu vermeiden."
#define OPTION_VAL_128K_DE "128 Kbit"
#define OPTION_VAL_256K_DE "256 Kbit"
#define OPTION_VAL_512K_DE "512 Kbit"
#define OPTION_VAL_1MEG_DE "1 Mbit"
#define OPTION_VAL_2MEG_DE "2 Mbit"
#define OPTION_VAL_4MEG_DE "4 Mbit"
#define GENESIS_PLUS_GX_ADD_ON_LABEL_DE "CD-Add-on (MD-Modus) (Neustart erforderlich)"
#define GENESIS_PLUS_GX_ADD_ON_INFO_0_DE "Festlegen, welches Add-on zur CD-Audiowiedergabe für unterstützte Mega Drive-/Genesis-Spiele verwendet werden soll."
#define OPTION_VAL_SEGA_MEGA_CD_DE NULL
#define OPTION_VAL_MEGASD_DE NULL
#define OPTION_VAL_NONE_DE "Keins"
#define GENESIS_PLUS_GX_LOCK_ON_LABEL_DE "Modul-Kombination"
#define GENESIS_PLUS_GX_LOCK_ON_INFO_0_DE "Kombinations-Technologie ist eine Mega Drive/Genesis-Funktion, die es einem älteren Spiel erlaubt, sich mit dem Durchschleifen eines speziellen Moduls für ein erweitertes oder verändertes Gameplay zu vereinen. Diese Option legt fest, welcher Typ eines speziellen 'Kombinations-Moduls' emuliert werden soll. Eine entsprechende Biosdatei muss im Systemverzeichnis von RetroArch vorhanden sein."
#define OPTION_VAL_GAME_GENIE_DE NULL
#define OPTION_VAL_ACTION_REPLAY_PRO_DE NULL
#define OPTION_VAL_SONIC_KNUCKLES_DE NULL
#define GENESIS_PLUS_GX_ASPECT_RATIO_LABEL_DE "Core-bestimmtes Seitenverhältnis"
#define GENESIS_PLUS_GX_ASPECT_RATIO_INFO_0_DE "Das bevorzugte Seitenverhältnis des Inhalts auswählen. Dies wird nur angewendet, wenn das Seitenverhältnis von RetroArch in den Videoeinstellungen auf \"Wie von Core vorgesehen\" eingestellt ist."
#define OPTION_VAL_NTSC_PAR_DE NULL
#define OPTION_VAL_PAL_PAR_DE NULL
#define OPTION_VAL_4_3_DE NULL
#define OPTION_VAL_UNCORRECTED_DE "Unkorrigiert"
#define GENESIS_PLUS_GX_OVERSCAN_LABEL_DE "Ränder"
#define GENESIS_PLUS_GX_OVERSCAN_INFO_0_DE "Dies aktivieren, um die Overscan-Regionen oben/unten und/oder links/rechts des Bildschirms anzuzeigen. Diese würden normalerweise am Rand eines Standardfernsehens verborgen bleiben."
#define OPTION_VAL_TOP_BOTTOM_DE "Oben/Unten"
#define OPTION_VAL_LEFT_RIGHT_DE "Links/Rechts"
#define OPTION_VAL_FULL_DE "Voll"
#define GENESIS_PLUS_GX_LEFT_BORDER_LABEL_DE "Master-System Seitenränder ausblenden"
#define GENESIS_PLUS_GX_LEFT_BORDER_INFO_0_DE "Schneidet 8 Pixel von der linken Seite des Bildschirms oder auf der linken und rechten Seite weg, wenn Master System Spiele ausgeführt werden."
#define OPTION_VAL_LEFT_BORDER_DE "Nur linker Rand"
#define OPTION_VAL_LEFT_RIGHT_BORDERS_DE "Linker und rechter Rand"
#define GENESIS_PLUS_GX_GG_EXTRA_LABEL_DE "Game Gear Erweiterter Bildschirm"
#define GENESIS_PLUS_GX_GG_EXTRA_INFO_0_DE "Erzwingt Game Gear Titel im SMS-Modus mit einer erhöhten Auflösung von 256x192 auszuführen. Kann zusätzliche Inhalte anzeigen, zeigt aber typischerweise Ränder von beschädigten/unerwünschten Bilddaten an."
#define GENESIS_PLUS_GX_BLARGG_NTSC_FILTER_LABEL_DE "NTSC-Filter Blargg"
#define GENESIS_PLUS_GX_BLARGG_NTSC_FILTER_INFO_0_DE "Einen Videofilter anwenden, um verschiedene NTSC-TV-Signale zu imitieren."
#define OPTION_VAL_MONOCHROME_DE "Schwarz-weiß"
#define OPTION_VAL_COMPOSITE_DE NULL
#define OPTION_VAL_SVIDEO_DE NULL
#define OPTION_VAL_RGB_DE NULL
#define GENESIS_PLUS_GX_LCD_FILTER_LABEL_DE "LCD-Ghosting-Filter"
#define GENESIS_PLUS_GX_LCD_FILTER_INFO_0_DE "Fügt einen 'Geisterbild'-Filter hinzu, um die Anzeigeeigenschaften der LCD-Bildschirme von Game Gear und Genesis Nomad nachzuahmen."
#define GENESIS_PLUS_GX_RENDER_LABEL_DE "Interlaced Modus 2 Ausgabe"
#define GENESIS_PLUS_GX_RENDER_INFO_0_DE "Der Interlaced Modus 2 erlaubt dem Mega Drive/Genesis eine Bildausgabe in doppelter Höhe (hohe Auflösung) von 320x448 durch Einfügen alternativer Scanlines in jedem Bild (dies wird von Sonic the Hedgehog 2 und Combat Cars im Multiplayer Modus verwendet). 'Doppelfeld' imitiert originale Hardware und erzeugt ein scharfes Bild mit Flicker/Interlacing-Artefakten. 'Einzelfeld' verwendet einen Deinterlacing-Filter, der das Bild stabilisiert, aber leicht verwischt."
#define OPTION_VAL_SINGLE_FIELD_DE "Einzelfeld"
#define OPTION_VAL_DOUBLE_FIELD_DE "Doppelfeld"
#define GENESIS_PLUS_GX_FRAMESKIP_LABEL_DE NULL
#define GENESIS_PLUS_GX_FRAMESKIP_INFO_0_DE "Überspringt Frames, um zu vermeiden, dass Audio-Puffer unterlaufen (Knistern). Verbessert die Leistung auf Kosten der visuellen Glätte. 'Automatisch' überspringt Frames wenn vom Frontend empfohlen. 'Manuell' verwendet die Einstellung 'Frameskip Grenzwert (%)'."
#define OPTION_VAL_MANUAL_DE "Manuell"
#define GENESIS_PLUS_GX_FRAMESKIP_THRESHOLD_LABEL_DE "Frameskip-Grenzwert (%)"
#define GENESIS_PLUS_GX_FRAMESKIP_THRESHOLD_INFO_0_DE "Gibt den Audiopuffer-Belegungsschwellenwert (Prozent) an, unter dem Frames übersprungen werden, wenn „Frameskip“ auf „Manuell“ eingestellt ist. Höhere Werte verringern das Risiko von Knistern, da Frames häufiger weggelassen werden."
#define GENESIS_PLUS_GX_YM2413_LABEL_DE NULL
#define GENESIS_PLUS_GX_YM2413_INFO_0_DE "Aktiviert die Emulation der FM Sound-Einheit, die von bestimmten Sega Mark III/Master System Spielen verwendet wird, um die Audioausgabe zu verbessern."
#define GENESIS_PLUS_GX_YM2413_CORE_LABEL_DE NULL
#define GENESIS_PLUS_GX_YM2413_CORE_INFO_0_DE "Wählt eine Methode, die zur Emulation der FM-Soundeinheit des Sega Mark III/Master Systems verwendet wird. Die 'MAME' Option ist schnell und läuft auf den meisten Systemen mit voller Geschwindigkeit. 'Nuked' Option ist taktgenau, von sehr hoher Qualität und hat erhebliche CPU-Anforderungen."
#define OPTION_VAL_MAME_DE NULL
#define OPTION_VAL_NUKED_DE NULL
#define GENESIS_PLUS_GX_YM2612_LABEL_DE NULL
#define GENESIS_PLUS_GX_YM2612_INFO_0_DE "Wählt die Methode, die verwendet wird, um den FM-Synthesizer (Hauptklanggenerator) der Mega Drive/Genesis zu emulieren. 'MAME' Optionen sind schnell und laufen auf den meisten Systemen mit voller Geschwindigkeit. 'Nuked' Optionen sind taktgenau, von sehr hoher Qualität und haben erhebliche CPU-Anforderungen. Der YM2612 Chip wird von dem ursprünglichen Modell 1 Mega Drive/Genesis verwendet, der YM3438 wird in späteren Mega Drive/Genesis Revisionen verwendet."
#define GENESIS_PLUS_GX_YM2612_INFO_1_DE "Methode zur Emulation des FM-Synthesizers (Hauptklanggenerator) des Mega Drive/Genesis auswählen. Der YM2612-Chip wird im ursprünglichen Model 1 des Mega Drive/Genesis verwendet. Der YM3438 wird in späteren Revisionen des Mega Drive/Genesis genutzt."
#define OPTION_VAL_MAME_YM2612_DE NULL
#define OPTION_VAL_MAME_ASIC_YM3438_DE NULL
#define OPTION_VAL_MAME_ENHANCED_YM3438_DE NULL
#define OPTION_VAL_NUKED_YM2612_DE NULL
#define OPTION_VAL_NUKED_YM3438_DE NULL
#define GENESIS_PLUS_GX_SOUND_OUTPUT_LABEL_DE "Tonausgabe"
#define GENESIS_PLUS_GX_SOUND_OUTPUT_INFO_0_DE "Stereo- oder Mono-Tonwiedergabe wählen."
#define OPTION_VAL_STEREO_DE NULL
#define OPTION_VAL_MONO_DE NULL
#define GENESIS_PLUS_GX_AUDIO_FILTER_LABEL_DE "Audiofilter"
#define GENESIS_PLUS_GX_AUDIO_FILTER_INFO_0_DE "Einen Niedrigpass-Audiofilter aktivieren, um den charakteristischen Sound eines Model 1 Mega Drive/Genesis besser zu simulieren."
#define OPTION_VAL_LOW_PASS_DE "Tiefpass"
#define OPTION_VAL_EQ_DE NULL
#define GENESIS_PLUS_GX_LOWPASS_RANGE_LABEL_DE "Tiefpassfilter %"
#define GENESIS_PLUS_GX_LOWPASS_RANGE_INFO_0_DE "Die Höchstfrequenz des Tiefpass-Audiofilters festlegen. Ein höherer Wert erhöht die wahrgenommene „Stärke“ des Filters, da ein größerer Bereich des Hochfrequenzspektrums abgeschwächt wird."
#define GENESIS_PLUS_GX_PSG_PREAMP_LABEL_DE "PSG-Vorverstärkungspegel"
#define GENESIS_PLUS_GX_PSG_PREAMP_INFO_0_DE "Legt den Audio-Vorverstärkerlevel des emulierten SN76496 4-Kanal-Programmierbaren Sound Generators fest, der im SG-1000, Sega Mark III, Master System, Game Gear und Mega Drive/Genesis gefunden wurde."
#define GENESIS_PLUS_GX_FM_PREAMP_LABEL_DE "FM-Vorverstärkungspegel"
#define GENESIS_PLUS_GX_FM_PREAMP_INFO_0_DE "Legt die Audio-Vorverstärker Stufe des emulierten Mega Drive/Genesis FM Sound Synthesizers oder der Sega Mark III/Master System FM Sound Einheit fest."
#define GENESIS_PLUS_GX_CDDA_VOLUME_LABEL_DE "CDDA-Lautstärke"
#define GENESIS_PLUS_GX_CDDA_VOLUME_INFO_0_DE "Passt die Mischlautstärke der emulierten CD Audio-Ausgabe an."
#define GENESIS_PLUS_GX_PCM_VOLUME_LABEL_DE "PCM-Lautstärke"
#define GENESIS_PLUS_GX_PCM_VOLUME_INFO_0_DE "Passt die Mischlautstärke des emulierten Sega CD/Mega-CD RF5C164 PCM Sound-Generators an."
#define GENESIS_PLUS_GX_AUDIO_EQ_LOW_LABEL_DE "EQ Tief"
#define GENESIS_PLUS_GX_AUDIO_EQ_LOW_INFO_0_DE "Passt den niedrigen Bereich des internen Audio-Equalizers an."
#define GENESIS_PLUS_GX_AUDIO_EQ_MID_LABEL_DE "EQ Mitten"
#define GENESIS_PLUS_GX_AUDIO_EQ_MID_INFO_0_DE "Passt den mittleren Bereich des internen Audio-Equalizers an."
#define GENESIS_PLUS_GX_AUDIO_EQ_HIGH_LABEL_DE "EQ Hoch"
#define GENESIS_PLUS_GX_AUDIO_EQ_HIGH_INFO_0_DE "Passt den hohen Bereich des internen Audio-Equalizers an."
#define GENESIS_PLUS_GX_GUN_INPUT_LABEL_DE "Lightgun-Eingabe"
#define GENESIS_PLUS_GX_GUN_INPUT_INFO_0_DE "Eine mausgesteuerte \"Lightgun\" oder eine \"Touchscreen\"-Eingabe verwenden."
#define OPTION_VAL_LIGHTGUN_DE "Lightgun"
#define OPTION_VAL_TOUCHSCREEN_DE NULL
#define GENESIS_PLUS_GX_GUN_CURSOR_LABEL_DE "Lightgun-Fadenkreuz anzeigen"
#define GENESIS_PLUS_GX_GUN_CURSOR_INFO_0_DE "Lightgun-Fadenkreuz anzeigen, wenn als Eingabegerätetypen MD Menacer, MD Justifiers und MS Light Phaser verwendet werden."
#define GENESIS_PLUS_GX_INVERT_MOUSE_LABEL_DE "Y-Achse von Maus umkehren"
#define GENESIS_PLUS_GX_INVERT_MOUSE_INFO_0_DE "Invertiert die Y-Achse des MD Maus Eingabegerätes."
#define GENESIS_PLUS_GX_NO_SPRITE_LIMIT_LABEL_DE "Entferne Sprite-Limit pro Zeile"
#define GENESIS_PLUS_GX_NO_SPRITE_LIMIT_INFO_0_DE "Entfernt das originale Sprites pro Scanline Hardware-Limit. Dies reduziert Sprite-Flackern, kann aber bei einigen Spielen zu Darstellungsfehlern führen, da manche dies für Effekte verwenden."
#define GENESIS_PLUS_GX_ENHANCED_VSCROLL_LABEL_DE "Verbessertes vertikales Scrollen pro Kachel"
#define GENESIS_PLUS_GX_ENHANCED_VSCROLL_INFO_0_DE "Ermöglicht es, jede einzelne Zelle vertikal zu scrollen anstatt \"16px 2-Zelle\", indem man mit dem vertikalen Scrollwert der benachbarten Zelle im Durchschnitt ist. Dieser Hack gilt nur für wenige Spiele, die einen vertikalen 2-Zell-Scroll-Modus verwenden."
#define GENESIS_PLUS_GX_ENHANCED_VSCROLL_LIMIT_LABEL_DE "Verbessertes vertikales Scrollen pro Kachel Begrenzung"
#define GENESIS_PLUS_GX_ENHANCED_VSCROLL_LIMIT_INFO_0_DE "Nur wenn „Verbessertes vertikales Scrollen pro Kachel“ aktiviert ist. Passt die Begrenzung der vertikalen Scroll-Verbesserung an. Wenn der vertikale Scrollunterschied zwischen benachbarten Kacheln größer als diese Begrenzung ist, wird die Verbesserung deaktiviert."
#define GENESIS_PLUS_GX_OVERCLOCK_LABEL_DE "CPU-Geschwindigkeit"
#define GENESIS_PLUS_GX_OVERCLOCK_INFO_0_DE "Die emulierte CPU übertakten. Kann Slowdow verringern, aber Glitches (Störeffekte) verursachen."
#define OPTION_VAL_100_DE "100 %"
#define OPTION_VAL_125_DE "125 %"
#define OPTION_VAL_150_DE "150 %"
#define OPTION_VAL_175_DE "175 %"
#define OPTION_VAL_200_DE "200 %"
#define OPTION_VAL_225_DE "225 %"
#define OPTION_VAL_250_DE "250 %"
#define OPTION_VAL_275_DE "275 %"
#define OPTION_VAL_300_DE "300 %"
#define OPTION_VAL_325_DE "325 %"
#define OPTION_VAL_350_DE "350 %"
#define OPTION_VAL_375_DE "375 %"
#define OPTION_VAL_400_DE "400 %"
#define OPTION_VAL_425_DE "425 %"
#define OPTION_VAL_450_DE "450 %"
#define OPTION_VAL_475_DE "475 %"
#define OPTION_VAL_500_DE "500 %"
#define GENESIS_PLUS_GX_FORCE_DTACK_LABEL_DE "Systemsperren"
#define GENESIS_PLUS_GX_FORCE_DTACK_INFO_0_DE "Emuliert Systemsperren, die auf echter Hardware auftreten, wenn illegale Adresszugriffe stattfinden. Dies sollte nur bei bestimmten Demos und Homebrew deaktiviert werden, die für den korrekten Betrieb auf illegales Verhalten angewiesen sind."
#define GENESIS_PLUS_GX_ADDR_ERROR_LABEL_DE "68K-Adressfehler"
#define GENESIS_PLUS_GX_ADDR_ERROR_INFO_0_DE "Die Mega Drive/Genesis Haupt-CPU (Motorola 68000) erzeugt bei dem Versuch, ungültigen Speicherzugriff auszuführen, eine Adress-Fehler-Ausnahme (Absturz). Aktivieren wird dieses Verhalten simulieren. Es sollte nur deaktiviert werden, wenn ROM-Hacks abgespielt werden, da diese in der Regel mit weniger genauen Emulatoren entwickelt werden und für den korrekten Betrieb auf ungültigen RAM-Zugriff vertrauen können."
#define GENESIS_PLUS_GX_CD_LATENCY_LABEL_DE "CD-Zugriffszeit"
#define GENESIS_PLUS_GX_CD_LATENCY_INFO_0_DE "Simuliert die Original-CD-Hardware-Latenz beim Einleiten eines Lesevorgangs oder bei der Suche nach einer bestimmten Stelle auf geladener Disc. Dies wird von ein paar CD-Spielen benötigt, die abstürzen, wenn CD-Daten zu früh verfügbar sind und auch CD-Audio-Desynchronisations-Probleme in einigen Spielen beheben. Das Deaktivieren kann bei MSU-MD Spielen nützlich sein, da es Audio-Loops von CD nahtlos macht."
#define GENESIS_PLUS_GX_CD_PRECACHE_LABEL_DE "CD-Abbild-Cache"
#define GENESIS_PLUS_GX_CD_PRECACHE_INFO_0_DE "CD-Abbild beim Start in den Speicher laden. Unterstützt nur CHD. Neustart erforderlich."
#define GENESIS_PLUS_GX_SHOW_ADVANCED_AUDIO_SETTINGS_LABEL_DE "Erweiterte Audio-Lautstärke-Einstellungen anzeigen (Menü erneut öffnen)"
#define GENESIS_PLUS_GX_SHOW_ADVANCED_AUDIO_SETTINGS_INFO_0_DE "Konfiguration von niedrigen Audio-Kanalparametern aktivieren. HINWEIS: Schnellmenü muss eingeschaltet sein, damit diese Einstellung wirksam wird."
#define GENESIS_PLUS_GX_PSG_CHANNEL_0_VOLUME_LABEL_DE "PSG-Tonkanal 0 Lautstärke %"
#define GENESIS_PLUS_GX_PSG_CHANNEL_0_VOLUME_INFO_0_DE "Die Lautstärke des PSG-Tonkanals 0 reduzieren."
#define GENESIS_PLUS_GX_PSG_CHANNEL_1_VOLUME_LABEL_DE "PSG-Tonkanal 1 Lautstärke %"
#define GENESIS_PLUS_GX_PSG_CHANNEL_1_VOLUME_INFO_0_DE "Die Lautstärke des PSG-Tonkanals 1 reduzieren."
#define GENESIS_PLUS_GX_PSG_CHANNEL_2_VOLUME_LABEL_DE "PSG-Tonkanal 2 Lautstärke %"
#define GENESIS_PLUS_GX_PSG_CHANNEL_2_VOLUME_INFO_0_DE "Die Lautstärke des PSG-Tonkanals 2 reduzieren."
#define GENESIS_PLUS_GX_PSG_CHANNEL_3_VOLUME_LABEL_DE "PSG Rauschkanal 3 Lautstärke %"
#define GENESIS_PLUS_GX_PSG_CHANNEL_3_VOLUME_INFO_0_DE "Die Lautstärke des PSG-Rauschkanals 3 reduzieren."
#define GENESIS_PLUS_GX_MD_CHANNEL_0_VOLUME_LABEL_DE "Mega Drive / Genesis FM Kanal 0 Lautstärke %"
#define GENESIS_PLUS_GX_MD_CHANNEL_0_VOLUME_INFO_0_DE "Die Lautstärke des Mega Drive / Genesis FM Kanal 0 reduzieren. Funktioniert nur mit MAME FM-Emulatoren."
#define GENESIS_PLUS_GX_MD_CHANNEL_1_VOLUME_LABEL_DE "Mega Drive/Genesis FM Kanal 1 Lautstärke %"
#define GENESIS_PLUS_GX_MD_CHANNEL_1_VOLUME_INFO_0_DE "Die Lautstärke des Mega Drive/Genesis FM Kanal 1 reduzieren. Funktioniert nur mit MAME FM-Emulatoren."
#define GENESIS_PLUS_GX_MD_CHANNEL_2_VOLUME_LABEL_DE "Mega Drive/Genesis FM Kanal 2 Lautstärke %"
#define GENESIS_PLUS_GX_MD_CHANNEL_2_VOLUME_INFO_0_DE "Die Lautstärke des Mega Drive/Genesis FM Kanal 2 reduzieren. Funktioniert nur mit MAME FM-Emulatoren."
#define GENESIS_PLUS_GX_MD_CHANNEL_3_VOLUME_LABEL_DE "Mega Drive/Genesis FM Kanal 3 Lautstärke %"
#define GENESIS_PLUS_GX_MD_CHANNEL_3_VOLUME_INFO_0_DE "Die Lautstärke des Mega Drive/Genesis FM Kanal 3 reduzieren. Funktioniert nur mit MAME FM-Emulatoren."
#define GENESIS_PLUS_GX_MD_CHANNEL_4_VOLUME_LABEL_DE "Mega Drive/Genesis FM Kanal 4 Lautstärke %"
#define GENESIS_PLUS_GX_MD_CHANNEL_4_VOLUME_INFO_0_DE "Die Lautstärke des Mega Drive/Genesis FM Kanal 4 reduzieren. Funktioniert nur mit MAME FM-Emulatoren."
#define GENESIS_PLUS_GX_MD_CHANNEL_5_VOLUME_LABEL_DE "Mega Drive/Genesis FM Kanal 5 Lautstärke %"
#define GENESIS_PLUS_GX_MD_CHANNEL_5_VOLUME_INFO_0_DE "Die Lautstärke des Mega Drive/Genesis FM Kanal 5 reduzieren. Funktioniert nur mit MAME FM-Emulatoren."
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_0_VOLUME_LABEL_DE "Master System FM (YM2413) Kanal 0 Lautstärke %"
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_0_VOLUME_INFO_0_DE "Die Lautstärke des Master System FM Kanal 0 reduzieren."
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_1_VOLUME_LABEL_DE "Master System FM (YM2413) Kanal 1 Lautstärke %"
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_1_VOLUME_INFO_0_DE "Die Lautstärke des Master System FM Kanal 1 reduzieren."
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_2_VOLUME_LABEL_DE "Master System FM (YM2413) Kanal 2 Lautstärke %"
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_2_VOLUME_INFO_0_DE "Die Lautstärke des Master System FM Kanal 2 reduzieren."
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_3_VOLUME_LABEL_DE "Master System FM (YM2413) Kanal 3 Lautstärke %"
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_3_VOLUME_INFO_0_DE "Die Lautstärke des Master System FM Kanal 3 reduzieren."
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_4_VOLUME_LABEL_DE "Master System FM (YM2413) Kanal 4 Lautstärke %"
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_4_VOLUME_INFO_0_DE "Die Lautstärke des Master System FM Kanal 4 reduzieren."
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_5_VOLUME_LABEL_DE "Master System FM (YM2413) Kanal 5 Lautstärke %"
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_5_VOLUME_INFO_0_DE "Die Lautstärke des Master System FM Kanal 5 reduzieren."
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_6_VOLUME_LABEL_DE "Master System FM (YM2413) Kanal 6 Lautstärke %"
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_6_VOLUME_INFO_0_DE "Die Lautstärke des Master System FM Kanal 6 reduzieren."
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_7_VOLUME_LABEL_DE "Master System FM (YM2413) Kanal 7 Lautstärke %"
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_7_VOLUME_INFO_0_DE "Die Lautstärke des Master System FM Kanal 7 reduzieren."
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_8_VOLUME_LABEL_DE "Master System FM (YM2413) Kanal 8 Lautstärke %"
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_8_VOLUME_INFO_0_DE "Die Lautstärke des Master System FM Kanal 8 reduzieren."

struct retro_core_option_v2_category option_cats_de[] = {
   {
      "system",
      CATEGORY_SYSTEM_LABEL_DE,
      CATEGORY_SYSTEM_INFO_0_DE
   },
   {
      "video",
      CATEGORY_VIDEO_LABEL_DE,
      CATEGORY_VIDEO_INFO_0_DE
   },
   {
      "audio",
      CATEGORY_AUDIO_LABEL_DE,
      CATEGORY_AUDIO_INFO_0_DE
   },
   {
      "input",
      CATEGORY_INPUT_LABEL_DE,
      CATEGORY_INPUT_INFO_0_DE
   },
   {
      "hacks",
      CATEGORY_HACKS_LABEL_DE,
      CATEGORY_HACKS_INFO_0_DE
   },
   {
      "channel_volume",
      CATEGORY_CHANNEL_VOLUME_LABEL_DE,
      CATEGORY_CHANNEL_VOLUME_INFO_0_DE
   },
   { NULL, NULL, NULL },
};
struct retro_core_option_v2_definition option_defs_de[] = {
   {
      "genesis_plus_gx_system_hw",
      GENESIS_PLUS_GX_SYSTEM_HW_LABEL_DE,
      NULL,
      GENESIS_PLUS_GX_SYSTEM_HW_INFO_0_DE,
      NULL,
      "system",
      {
         { "auto",                 OPTION_VAL_AUTO_DE                 },
         { "sg-1000",              OPTION_VAL_SG_1000_DE              },
         { "sg-1000 II",           OPTION_VAL_SG_1000_II_DE           },
         { "sg-1000 II + ram ext.",OPTION_VAL_SG_1000_II_RAM_EXT_DE},
         { "mark-III",             OPTION_VAL_MARK_III_DE             },
         { "master system",        OPTION_VAL_MASTER_SYSTEM_DE        },
         { "master system II",     OPTION_VAL_MASTER_SYSTEM_II_DE     },
         { "game gear",            OPTION_VAL_GAME_GEAR_DE            },
         { "mega drive / genesis", OPTION_VAL_MEGA_DRIVE_GENESIS_DE   },
         { NULL, NULL },
      },
      "auto"
   },
   {
      "genesis_plus_gx_region_detect",
      GENESIS_PLUS_GX_REGION_DETECT_LABEL_DE,
      NULL,
      GENESIS_PLUS_GX_REGION_DETECT_INFO_0_DE,
      NULL,
      "system",
      {
         { "auto",    OPTION_VAL_AUTO_DE   },
         { "ntsc-u",  OPTION_VAL_NTSC_U_DE },
         { "pal",     OPTION_VAL_PAL_DE    },
         { "ntsc-j",  OPTION_VAL_NTSC_J_DE },
         { NULL, NULL },
      },
      "auto"
   },
   {
      "genesis_plus_gx_vdp_mode",
      GENESIS_PLUS_GX_VDP_MODE_LABEL_DE,
      NULL,
      GENESIS_PLUS_GX_VDP_MODE_INFO_0_DE,
      NULL,
      "system",
      {
         { "auto",  "Disabled" },
         { "60hz",  OPTION_VAL_60HZ_DE },
         { "50hz",  OPTION_VAL_50HZ_DE },
         { NULL, NULL },
      },
      "auto"
   },
   {
      "genesis_plus_gx_bios",
      GENESIS_PLUS_GX_BIOS_LABEL_DE,
      NULL,
      GENESIS_PLUS_GX_BIOS_INFO_0_DE,
      NULL,
      "system",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_system_bram",
      GENESIS_PLUS_GX_SYSTEM_BRAM_LABEL_DE,
      NULL,
      GENESIS_PLUS_GX_SYSTEM_BRAM_INFO_0_DE,
      NULL,
      "system",
      {
         { "per bios", OPTION_VAL_PER_BIOS_DE },
         { "per game", OPTION_VAL_PER_GAME_DE },
         { NULL, NULL },
      },
      "per bios"
   },
   {
      "genesis_plus_gx_cart_bram",
      GENESIS_PLUS_GX_CART_BRAM_LABEL_DE,
      NULL,
      GENESIS_PLUS_GX_CART_BRAM_INFO_0_DE,
      NULL,
      "system",
      {
         { "per cart", OPTION_VAL_PER_CART_DE },
         { "per game", OPTION_VAL_PER_GAME_DE },
         { NULL, NULL },
      },
      "per cart"
   },
   {
      "genesis_plus_gx_cart_size",
      GENESIS_PLUS_GX_CART_SIZE_LABEL_DE,
      NULL,
      GENESIS_PLUS_GX_CART_SIZE_INFO_0_DE,
      NULL,
      "system",
      {
         { "disabled", "Disabled" },
         { "128k",     OPTION_VAL_128K_DE  },
         { "256k",     OPTION_VAL_256K_DE  },
         { "512k",     OPTION_VAL_512K_DE  },
         { "1meg",     OPTION_VAL_1MEG_DE    },
         { "2meg",     OPTION_VAL_2MEG_DE    },
         { "4meg",     OPTION_VAL_4MEG_DE    },
         { NULL, NULL },
      },
      "4meg"
   },
   {
      "genesis_plus_gx_add_on",
      GENESIS_PLUS_GX_ADD_ON_LABEL_DE,
      NULL,
      GENESIS_PLUS_GX_ADD_ON_INFO_0_DE,
      NULL,
      "system",
      {
         { "auto",         OPTION_VAL_AUTO_DE },
         { "sega/mega cd", OPTION_VAL_SEGA_MEGA_CD_DE },
         { "megasd",       OPTION_VAL_MEGASD_DE },
         { "none",         OPTION_VAL_NONE_DE },
         { NULL, NULL },
      },
      "auto"
   },
   {
      "genesis_plus_gx_lock_on",
      GENESIS_PLUS_GX_LOCK_ON_LABEL_DE,
      NULL,
      GENESIS_PLUS_GX_LOCK_ON_INFO_0_DE,
      NULL,
      "system",
      {
         { "disabled",            NULL },
         { "game genie",          OPTION_VAL_GAME_GENIE_DE },
         { "action replay (pro)", OPTION_VAL_ACTION_REPLAY_PRO_DE },
         { "sonic & knuckles",    OPTION_VAL_SONIC_KNUCKLES_DE },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_aspect_ratio",
      GENESIS_PLUS_GX_ASPECT_RATIO_LABEL_DE,
      NULL,
      GENESIS_PLUS_GX_ASPECT_RATIO_INFO_0_DE,
      NULL,
      "video",
      {
         { "auto",     OPTION_VAL_AUTO_DE },
         { "NTSC PAR", OPTION_VAL_NTSC_PAR_DE },
         { "PAL PAR",  OPTION_VAL_PAL_PAR_DE },
         { "4:3",  OPTION_VAL_4_3_DE },
         { "Uncorrected",  OPTION_VAL_UNCORRECTED_DE },
      },
      "auto"
   },
   {
      "genesis_plus_gx_overscan",
      GENESIS_PLUS_GX_OVERSCAN_LABEL_DE,
      NULL,
      GENESIS_PLUS_GX_OVERSCAN_INFO_0_DE,
      NULL,
      "video",
      {
         { "disabled",   NULL },
         { "top/bottom", OPTION_VAL_TOP_BOTTOM_DE },
         { "left/right", OPTION_VAL_LEFT_RIGHT_DE },
         { "full",       OPTION_VAL_FULL_DE },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_left_border",
      GENESIS_PLUS_GX_LEFT_BORDER_LABEL_DE,
      NULL,
      GENESIS_PLUS_GX_LEFT_BORDER_INFO_0_DE,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "left border", OPTION_VAL_LEFT_BORDER_DE },
         { "left & right borders", OPTION_VAL_LEFT_RIGHT_BORDERS_DE },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_gg_extra",
      GENESIS_PLUS_GX_GG_EXTRA_LABEL_DE,
      NULL,
      GENESIS_PLUS_GX_GG_EXTRA_INFO_0_DE,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_blargg_ntsc_filter",
      GENESIS_PLUS_GX_BLARGG_NTSC_FILTER_LABEL_DE,
      NULL,
      GENESIS_PLUS_GX_BLARGG_NTSC_FILTER_INFO_0_DE,
      NULL,
      "video",
      {
         { "disabled",   NULL },
         { "monochrome", OPTION_VAL_MONOCHROME_DE },
         { "composite",  OPTION_VAL_COMPOSITE_DE },
         { "svideo",     OPTION_VAL_SVIDEO_DE },
         { "rgb",        OPTION_VAL_RGB_DE },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_lcd_filter",
      GENESIS_PLUS_GX_LCD_FILTER_LABEL_DE,
      NULL,
      GENESIS_PLUS_GX_LCD_FILTER_INFO_0_DE,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_render",
      GENESIS_PLUS_GX_RENDER_LABEL_DE,
      NULL,
      GENESIS_PLUS_GX_RENDER_INFO_0_DE,
      NULL,
      "video",
      {
         { "single field", OPTION_VAL_SINGLE_FIELD_DE },
         { "double field", OPTION_VAL_DOUBLE_FIELD_DE },
         { NULL, NULL },
      },
      "single field"
   },
   {
      "genesis_plus_gx_frameskip",
      GENESIS_PLUS_GX_FRAMESKIP_LABEL_DE,
      NULL,
      GENESIS_PLUS_GX_FRAMESKIP_INFO_0_DE,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "auto",     OPTION_VAL_AUTO_DE },
         { "manual",   OPTION_VAL_MANUAL_DE },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_frameskip_threshold",
      GENESIS_PLUS_GX_FRAMESKIP_THRESHOLD_LABEL_DE,
      NULL,
      GENESIS_PLUS_GX_FRAMESKIP_THRESHOLD_INFO_0_DE,
      NULL,
      "video",
      {
         { "15", NULL },
         { "18", NULL },
         { "21", NULL },
         { "24", NULL },
         { "27", NULL },
         { "30", NULL },
         { "33", NULL },
         { "36", NULL },
         { "39", NULL },
         { "42", NULL },
         { "45", NULL },
         { "48", NULL },
         { "51", NULL },
         { "54", NULL },
         { "57", NULL },
         { "60", NULL },
         { NULL, NULL },
      },
      "33"
   },
   {
      "genesis_plus_gx_ym2413",
      GENESIS_PLUS_GX_YM2413_LABEL_DE,
      NULL,
      GENESIS_PLUS_GX_YM2413_INFO_0_DE,
      NULL,
      "audio",
      {
         { "auto",     OPTION_VAL_AUTO_DE },
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "auto"
   },
#ifdef HAVE_OPLL_CORE
   {
      "genesis_plus_gx_ym2413_core",
      GENESIS_PLUS_GX_YM2413_CORE_LABEL_DE,
      NULL,
      GENESIS_PLUS_GX_YM2413_CORE_INFO_0_DE,
      NULL,
      "audio",
      {
         { "mame",  OPTION_VAL_MAME_DE },
         { "nuked", OPTION_VAL_NUKED_DE },
         { NULL, NULL },
      },
      "mame"
   },
#endif
   {
      "genesis_plus_gx_ym2612",
      GENESIS_PLUS_GX_YM2612_LABEL_DE,
      NULL,
#ifdef HAVE_YM3438_CORE
      GENESIS_PLUS_GX_YM2612_INFO_0_DE,
#else
      GENESIS_PLUS_GX_YM2612_INFO_1_DE,
#endif
      NULL,
      "audio",
      {
         { "mame (ym2612)",          OPTION_VAL_MAME_YM2612_DE },
         { "mame (asic ym3438)",     OPTION_VAL_MAME_ASIC_YM3438_DE },
         { "mame (enhanced ym3438)", OPTION_VAL_MAME_ENHANCED_YM3438_DE },
#ifdef HAVE_YM3438_CORE
         { "nuked (ym2612)",         OPTION_VAL_NUKED_YM2612_DE },
         { "nuked (ym3438)",         OPTION_VAL_NUKED_YM3438_DE },
#endif
         { NULL, NULL },
      },
      "mame (ym2612)"
   },
   {
      "genesis_plus_gx_sound_output",
      GENESIS_PLUS_GX_SOUND_OUTPUT_LABEL_DE,
      NULL,
      GENESIS_PLUS_GX_SOUND_OUTPUT_INFO_0_DE,
      NULL,
      "audio",
      {
         { "stereo", OPTION_VAL_STEREO_DE },
         { "mono",   OPTION_VAL_MONO_DE },
         { NULL, NULL },
      },
      "stereo"
   },
   {
      "genesis_plus_gx_audio_filter",
      GENESIS_PLUS_GX_AUDIO_FILTER_LABEL_DE,
      NULL,
      GENESIS_PLUS_GX_AUDIO_FILTER_INFO_0_DE,
      NULL,
      "audio",
      {
         { "disabled", NULL },
         { "low-pass", OPTION_VAL_LOW_PASS_DE },
#ifdef HAVE_EQ
         { "EQ",       OPTION_VAL_EQ_DE },
#endif
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_lowpass_range",
      GENESIS_PLUS_GX_LOWPASS_RANGE_LABEL_DE,
      NULL,
      GENESIS_PLUS_GX_LOWPASS_RANGE_INFO_0_DE,
      NULL,
      "audio",
      {
         { "5",  NULL },
         { "10", NULL },
         { "15", NULL },
         { "20", NULL },
         { "25", NULL },
         { "30", NULL },
         { "35", NULL },
         { "40", NULL },
         { "45", NULL },
         { "50", NULL },
         { "55", NULL },
         { "60", NULL },
         { "65", NULL },
         { "70", NULL },
         { "75", NULL },
         { "80", NULL },
         { "85", NULL },
         { "90", NULL },
         { "95", NULL },
         { NULL, NULL },
      },
      "60"
   },
   {
      "genesis_plus_gx_psg_preamp",
      GENESIS_PLUS_GX_PSG_PREAMP_LABEL_DE,
      NULL,
      GENESIS_PLUS_GX_PSG_PREAMP_INFO_0_DE,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { "105", NULL },
         { "110", NULL },
         { "115", NULL },
         { "120", NULL },
         { "125", NULL },
         { "130", NULL },
         { "135", NULL },
         { "140", NULL },
         { "145", NULL },
         { "150", NULL },
         { "155", NULL },
         { "160", NULL },
         { "165", NULL },
         { "170", NULL },
         { "175", NULL },
         { "180", NULL },
         { "185", NULL },
         { "190", NULL },
         { "195", NULL },
         { "200", NULL },
         { NULL, NULL },
      },
      "150"
   },
   {
      "genesis_plus_gx_fm_preamp",
      GENESIS_PLUS_GX_FM_PREAMP_LABEL_DE,
      NULL,
      GENESIS_PLUS_GX_FM_PREAMP_INFO_0_DE,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { "105", NULL },
         { "110", NULL },
         { "115", NULL },
         { "120", NULL },
         { "125", NULL },
         { "130", NULL },
         { "135", NULL },
         { "140", NULL },
         { "145", NULL },
         { "150", NULL },
         { "155", NULL },
         { "160", NULL },
         { "165", NULL },
         { "170", NULL },
         { "175", NULL },
         { "180", NULL },
         { "185", NULL },
         { "190", NULL },
         { "195", NULL },
         { "200", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_cdda_volume",
      GENESIS_PLUS_GX_CDDA_VOLUME_LABEL_DE,
      NULL,
      GENESIS_PLUS_GX_CDDA_VOLUME_INFO_0_DE,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_pcm_volume",
      GENESIS_PLUS_GX_PCM_VOLUME_LABEL_DE,
      NULL,
      GENESIS_PLUS_GX_PCM_VOLUME_INFO_0_DE,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
#ifdef HAVE_EQ
   {
      "genesis_plus_gx_audio_eq_low",
      GENESIS_PLUS_GX_AUDIO_EQ_LOW_LABEL_DE,
      NULL,
      GENESIS_PLUS_GX_AUDIO_EQ_LOW_INFO_0_DE,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_audio_eq_mid",
      GENESIS_PLUS_GX_AUDIO_EQ_MID_LABEL_DE,
      NULL,
      GENESIS_PLUS_GX_AUDIO_EQ_MID_INFO_0_DE,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_audio_eq_high",
      GENESIS_PLUS_GX_AUDIO_EQ_HIGH_LABEL_DE,
      NULL,
      GENESIS_PLUS_GX_AUDIO_EQ_HIGH_INFO_0_DE,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
#endif
   {
      "genesis_plus_gx_gun_input",
      GENESIS_PLUS_GX_GUN_INPUT_LABEL_DE,
      NULL,
      GENESIS_PLUS_GX_GUN_INPUT_INFO_0_DE,
      NULL,
      "input",
      {
         { "lightgun",    OPTION_VAL_LIGHTGUN_DE },
         { "touchscreen", OPTION_VAL_TOUCHSCREEN_DE },
         { NULL, NULL },
      },
      "lightgun"
   },
   {
      "genesis_plus_gx_gun_cursor",
      GENESIS_PLUS_GX_GUN_CURSOR_LABEL_DE,
      NULL,
      GENESIS_PLUS_GX_GUN_CURSOR_INFO_0_DE,
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_invert_mouse",
      GENESIS_PLUS_GX_INVERT_MOUSE_LABEL_DE,
      NULL,
      GENESIS_PLUS_GX_INVERT_MOUSE_INFO_0_DE,
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_no_sprite_limit",
      GENESIS_PLUS_GX_NO_SPRITE_LIMIT_LABEL_DE,
      NULL,
      GENESIS_PLUS_GX_NO_SPRITE_LIMIT_INFO_0_DE,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_enhanced_vscroll",
      GENESIS_PLUS_GX_ENHANCED_VSCROLL_LABEL_DE,
      NULL,
      GENESIS_PLUS_GX_ENHANCED_VSCROLL_INFO_0_DE,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_enhanced_vscroll_limit",
      GENESIS_PLUS_GX_ENHANCED_VSCROLL_LIMIT_LABEL_DE,
      NULL,
      GENESIS_PLUS_GX_ENHANCED_VSCROLL_LIMIT_INFO_0_DE,
      NULL,
      "hacks",
      {
         { "2", NULL },
         { "3",  NULL },
         { "4", NULL },
         { "5",  NULL },
         { "6", NULL },
         { "7",  NULL },
         { "8", NULL },
         { "9",  NULL },
         { "10", NULL },
         { "11",  NULL },
         { "12", NULL },
         { "13",  NULL },
         { "14", NULL },
         { "15",  NULL },
         { "16", NULL },
         { NULL, NULL },
      },
      "8"
   },
#ifdef HAVE_OVERCLOCK
   {
      "genesis_plus_gx_overclock",
      GENESIS_PLUS_GX_OVERCLOCK_LABEL_DE,
      NULL,
      GENESIS_PLUS_GX_OVERCLOCK_INFO_0_DE,
      NULL,
      "hacks",
      {
         { "100", OPTION_VAL_100_DE },
         { "125", OPTION_VAL_125_DE },
         { "150", OPTION_VAL_150_DE },
         { "175", OPTION_VAL_175_DE },
         { "200", OPTION_VAL_200_DE },
         { "225", OPTION_VAL_225_DE },
         { "250", OPTION_VAL_250_DE },
         { "275", OPTION_VAL_275_DE },
         { "300", OPTION_VAL_300_DE },
         { "325", OPTION_VAL_325_DE },
         { "350", OPTION_VAL_350_DE },
         { "375", OPTION_VAL_375_DE },
         { "400", OPTION_VAL_400_DE },
         { "425", OPTION_VAL_425_DE },
         { "450", OPTION_VAL_450_DE },
         { "475", OPTION_VAL_475_DE },
         { "500", OPTION_VAL_500_DE },
         { NULL, NULL },
      },
      "100%"
   },
#endif
   {
      "genesis_plus_gx_force_dtack",
      GENESIS_PLUS_GX_FORCE_DTACK_LABEL_DE,
      NULL,
      GENESIS_PLUS_GX_FORCE_DTACK_INFO_0_DE,
      NULL,
      "hacks",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL },
      },
      "enabled"
   },
   {
      "genesis_plus_gx_addr_error",
      GENESIS_PLUS_GX_ADDR_ERROR_LABEL_DE,
      NULL,
      GENESIS_PLUS_GX_ADDR_ERROR_INFO_0_DE,
      NULL,
      "hacks",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL },
      },
      "enabled"
   },
   {
      "genesis_plus_gx_cd_latency",
      GENESIS_PLUS_GX_CD_LATENCY_LABEL_DE,
      NULL,
      GENESIS_PLUS_GX_CD_LATENCY_INFO_0_DE,
      NULL,
      "hacks",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL },
      },
      "enabled"
   },
   {
      "genesis_plus_gx_cd_precache",
      GENESIS_PLUS_GX_CD_PRECACHE_LABEL_DE,
      NULL,
      GENESIS_PLUS_GX_CD_PRECACHE_INFO_0_DE,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
#ifdef USE_PER_SOUND_CHANNELS_CONFIG
   {
      "genesis_plus_gx_show_advanced_audio_settings",
      GENESIS_PLUS_GX_SHOW_ADVANCED_AUDIO_SETTINGS_LABEL_DE,
      NULL,
      GENESIS_PLUS_GX_SHOW_ADVANCED_AUDIO_SETTINGS_INFO_0_DE,
      NULL,
      "channel_volume",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL},
      },
      "disabled"
   },
   {
      "genesis_plus_gx_psg_channel_0_volume",
      GENESIS_PLUS_GX_PSG_CHANNEL_0_VOLUME_LABEL_DE,
      NULL,
      GENESIS_PLUS_GX_PSG_CHANNEL_0_VOLUME_INFO_0_DE,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_psg_channel_1_volume",
      GENESIS_PLUS_GX_PSG_CHANNEL_1_VOLUME_LABEL_DE,
      NULL,
      GENESIS_PLUS_GX_PSG_CHANNEL_1_VOLUME_INFO_0_DE,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_psg_channel_2_volume",
      GENESIS_PLUS_GX_PSG_CHANNEL_2_VOLUME_LABEL_DE,
      NULL,
      GENESIS_PLUS_GX_PSG_CHANNEL_2_VOLUME_INFO_0_DE,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_psg_channel_3_volume",
      GENESIS_PLUS_GX_PSG_CHANNEL_3_VOLUME_LABEL_DE,
      NULL,
      GENESIS_PLUS_GX_PSG_CHANNEL_3_VOLUME_INFO_0_DE,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_0_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_0_VOLUME_LABEL_DE,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_0_VOLUME_INFO_0_DE,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_1_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_1_VOLUME_LABEL_DE,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_1_VOLUME_INFO_0_DE,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_2_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_2_VOLUME_LABEL_DE,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_2_VOLUME_INFO_0_DE,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_3_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_3_VOLUME_LABEL_DE,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_3_VOLUME_INFO_0_DE,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_4_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_4_VOLUME_LABEL_DE,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_4_VOLUME_INFO_0_DE,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_5_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_5_VOLUME_LABEL_DE,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_5_VOLUME_INFO_0_DE,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_0_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_0_VOLUME_LABEL_DE,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_0_VOLUME_INFO_0_DE,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_1_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_1_VOLUME_LABEL_DE,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_1_VOLUME_INFO_0_DE,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_2_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_2_VOLUME_LABEL_DE,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_2_VOLUME_INFO_0_DE,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_3_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_3_VOLUME_LABEL_DE,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_3_VOLUME_INFO_0_DE,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_4_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_4_VOLUME_LABEL_DE,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_4_VOLUME_INFO_0_DE,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_5_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_5_VOLUME_LABEL_DE,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_5_VOLUME_INFO_0_DE,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_6_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_6_VOLUME_LABEL_DE,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_6_VOLUME_INFO_0_DE,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_7_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_7_VOLUME_LABEL_DE,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_7_VOLUME_INFO_0_DE,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_8_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_8_VOLUME_LABEL_DE,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_8_VOLUME_INFO_0_DE,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
#endif
   { NULL, NULL, NULL, NULL, NULL, NULL, {{0}}, NULL },
};
struct retro_core_options_v2 options_de = {
   option_cats_de,
   option_defs_de
};

/* RETRO_LANGUAGE_EL */

#define CATEGORY_SYSTEM_LABEL_EL "Σύστημα"
#define CATEGORY_SYSTEM_INFO_0_EL NULL
#define CATEGORY_VIDEO_LABEL_EL "Βίντεο"
#define CATEGORY_VIDEO_INFO_0_EL NULL
#define CATEGORY_AUDIO_LABEL_EL "Ήχος"
#define CATEGORY_AUDIO_INFO_0_EL NULL
#define CATEGORY_INPUT_LABEL_EL "Εισαγωγή"
#define CATEGORY_INPUT_INFO_0_EL NULL
#define CATEGORY_HACKS_LABEL_EL NULL
#define CATEGORY_HACKS_INFO_0_EL NULL
#define CATEGORY_CHANNEL_VOLUME_LABEL_EL NULL
#define CATEGORY_CHANNEL_VOLUME_INFO_0_EL NULL
#define GENESIS_PLUS_GX_SYSTEM_HW_LABEL_EL NULL
#define GENESIS_PLUS_GX_SYSTEM_HW_INFO_0_EL NULL
#define OPTION_VAL_AUTO_EL "Αυτόματο"
#define OPTION_VAL_SG_1000_EL NULL
#define OPTION_VAL_SG_1000_II_EL NULL
#define OPTION_VAL_SG_1000_II_RAM_EXT_EL NULL
#define OPTION_VAL_MARK_III_EL NULL
#define OPTION_VAL_MASTER_SYSTEM_EL NULL
#define OPTION_VAL_MASTER_SYSTEM_II_EL NULL
#define OPTION_VAL_GAME_GEAR_EL NULL
#define OPTION_VAL_MEGA_DRIVE_GENESIS_EL NULL
#define GENESIS_PLUS_GX_REGION_DETECT_LABEL_EL NULL
#define GENESIS_PLUS_GX_REGION_DETECT_INFO_0_EL NULL
#define OPTION_VAL_NTSC_U_EL NULL
#define OPTION_VAL_PAL_EL NULL
#define OPTION_VAL_NTSC_J_EL NULL
#define GENESIS_PLUS_GX_VDP_MODE_LABEL_EL NULL
#define GENESIS_PLUS_GX_VDP_MODE_INFO_0_EL NULL
#define OPTION_VAL_60HZ_EL NULL
#define OPTION_VAL_50HZ_EL NULL
#define GENESIS_PLUS_GX_BIOS_LABEL_EL NULL
#define GENESIS_PLUS_GX_BIOS_INFO_0_EL NULL
#define GENESIS_PLUS_GX_SYSTEM_BRAM_LABEL_EL NULL
#define GENESIS_PLUS_GX_SYSTEM_BRAM_INFO_0_EL NULL
#define OPTION_VAL_PER_BIOS_EL NULL
#define OPTION_VAL_PER_GAME_EL NULL
#define GENESIS_PLUS_GX_CART_BRAM_LABEL_EL NULL
#define GENESIS_PLUS_GX_CART_BRAM_INFO_0_EL NULL
#define OPTION_VAL_PER_CART_EL NULL
#define GENESIS_PLUS_GX_CART_SIZE_LABEL_EL NULL
#define GENESIS_PLUS_GX_CART_SIZE_INFO_0_EL NULL
#define OPTION_VAL_128K_EL NULL
#define OPTION_VAL_256K_EL NULL
#define OPTION_VAL_512K_EL NULL
#define OPTION_VAL_1MEG_EL NULL
#define OPTION_VAL_2MEG_EL NULL
#define OPTION_VAL_4MEG_EL NULL
#define GENESIS_PLUS_GX_ADD_ON_LABEL_EL NULL
#define GENESIS_PLUS_GX_ADD_ON_INFO_0_EL NULL
#define OPTION_VAL_SEGA_MEGA_CD_EL NULL
#define OPTION_VAL_MEGASD_EL NULL
#define OPTION_VAL_NONE_EL "Κανείς"
#define GENESIS_PLUS_GX_LOCK_ON_LABEL_EL NULL
#define GENESIS_PLUS_GX_LOCK_ON_INFO_0_EL NULL
#define OPTION_VAL_GAME_GENIE_EL NULL
#define OPTION_VAL_ACTION_REPLAY_PRO_EL NULL
#define OPTION_VAL_SONIC_KNUCKLES_EL NULL
#define GENESIS_PLUS_GX_ASPECT_RATIO_LABEL_EL NULL
#define GENESIS_PLUS_GX_ASPECT_RATIO_INFO_0_EL NULL
#define OPTION_VAL_NTSC_PAR_EL NULL
#define OPTION_VAL_PAL_PAR_EL NULL
#define OPTION_VAL_4_3_EL NULL
#define OPTION_VAL_UNCORRECTED_EL NULL
#define GENESIS_PLUS_GX_OVERSCAN_LABEL_EL NULL
#define GENESIS_PLUS_GX_OVERSCAN_INFO_0_EL NULL
#define OPTION_VAL_TOP_BOTTOM_EL NULL
#define OPTION_VAL_LEFT_RIGHT_EL NULL
#define OPTION_VAL_FULL_EL NULL
#define GENESIS_PLUS_GX_LEFT_BORDER_LABEL_EL NULL
#define GENESIS_PLUS_GX_LEFT_BORDER_INFO_0_EL NULL
#define OPTION_VAL_LEFT_BORDER_EL NULL
#define OPTION_VAL_LEFT_RIGHT_BORDERS_EL NULL
#define GENESIS_PLUS_GX_GG_EXTRA_LABEL_EL NULL
#define GENESIS_PLUS_GX_GG_EXTRA_INFO_0_EL NULL
#define GENESIS_PLUS_GX_BLARGG_NTSC_FILTER_LABEL_EL NULL
#define GENESIS_PLUS_GX_BLARGG_NTSC_FILTER_INFO_0_EL NULL
#define OPTION_VAL_MONOCHROME_EL "Μονόχρωμο"
#define OPTION_VAL_COMPOSITE_EL NULL
#define OPTION_VAL_SVIDEO_EL NULL
#define OPTION_VAL_RGB_EL NULL
#define GENESIS_PLUS_GX_LCD_FILTER_LABEL_EL NULL
#define GENESIS_PLUS_GX_LCD_FILTER_INFO_0_EL NULL
#define GENESIS_PLUS_GX_RENDER_LABEL_EL NULL
#define GENESIS_PLUS_GX_RENDER_INFO_0_EL NULL
#define OPTION_VAL_SINGLE_FIELD_EL NULL
#define OPTION_VAL_DOUBLE_FIELD_EL NULL
#define GENESIS_PLUS_GX_FRAMESKIP_LABEL_EL NULL
#define GENESIS_PLUS_GX_FRAMESKIP_INFO_0_EL NULL
#define OPTION_VAL_MANUAL_EL "Χειροκίνητο"
#define GENESIS_PLUS_GX_FRAMESKIP_THRESHOLD_LABEL_EL NULL
#define GENESIS_PLUS_GX_FRAMESKIP_THRESHOLD_INFO_0_EL NULL
#define GENESIS_PLUS_GX_YM2413_LABEL_EL NULL
#define GENESIS_PLUS_GX_YM2413_INFO_0_EL NULL
#define GENESIS_PLUS_GX_YM2413_CORE_LABEL_EL NULL
#define GENESIS_PLUS_GX_YM2413_CORE_INFO_0_EL NULL
#define OPTION_VAL_MAME_EL NULL
#define OPTION_VAL_NUKED_EL NULL
#define GENESIS_PLUS_GX_YM2612_LABEL_EL NULL
#define GENESIS_PLUS_GX_YM2612_INFO_0_EL NULL
#define GENESIS_PLUS_GX_YM2612_INFO_1_EL NULL
#define OPTION_VAL_MAME_YM2612_EL NULL
#define OPTION_VAL_MAME_ASIC_YM3438_EL NULL
#define OPTION_VAL_MAME_ENHANCED_YM3438_EL NULL
#define OPTION_VAL_NUKED_YM2612_EL NULL
#define OPTION_VAL_NUKED_YM3438_EL NULL
#define GENESIS_PLUS_GX_SOUND_OUTPUT_LABEL_EL NULL
#define GENESIS_PLUS_GX_SOUND_OUTPUT_INFO_0_EL NULL
#define OPTION_VAL_STEREO_EL NULL
#define OPTION_VAL_MONO_EL NULL
#define GENESIS_PLUS_GX_AUDIO_FILTER_LABEL_EL "Φίλτρα Ήχου"
#define GENESIS_PLUS_GX_AUDIO_FILTER_INFO_0_EL NULL
#define OPTION_VAL_LOW_PASS_EL NULL
#define OPTION_VAL_EQ_EL NULL
#define GENESIS_PLUS_GX_LOWPASS_RANGE_LABEL_EL NULL
#define GENESIS_PLUS_GX_LOWPASS_RANGE_INFO_0_EL NULL
#define GENESIS_PLUS_GX_PSG_PREAMP_LABEL_EL NULL
#define GENESIS_PLUS_GX_PSG_PREAMP_INFO_0_EL NULL
#define GENESIS_PLUS_GX_FM_PREAMP_LABEL_EL NULL
#define GENESIS_PLUS_GX_FM_PREAMP_INFO_0_EL NULL
#define GENESIS_PLUS_GX_CDDA_VOLUME_LABEL_EL NULL
#define GENESIS_PLUS_GX_CDDA_VOLUME_INFO_0_EL NULL
#define GENESIS_PLUS_GX_PCM_VOLUME_LABEL_EL NULL
#define GENESIS_PLUS_GX_PCM_VOLUME_INFO_0_EL NULL
#define GENESIS_PLUS_GX_AUDIO_EQ_LOW_LABEL_EL NULL
#define GENESIS_PLUS_GX_AUDIO_EQ_LOW_INFO_0_EL NULL
#define GENESIS_PLUS_GX_AUDIO_EQ_MID_LABEL_EL NULL
#define GENESIS_PLUS_GX_AUDIO_EQ_MID_INFO_0_EL NULL
#define GENESIS_PLUS_GX_AUDIO_EQ_HIGH_LABEL_EL NULL
#define GENESIS_PLUS_GX_AUDIO_EQ_HIGH_INFO_0_EL NULL
#define GENESIS_PLUS_GX_GUN_INPUT_LABEL_EL NULL
#define GENESIS_PLUS_GX_GUN_INPUT_INFO_0_EL NULL
#define OPTION_VAL_LIGHTGUN_EL NULL
#define OPTION_VAL_TOUCHSCREEN_EL NULL
#define GENESIS_PLUS_GX_GUN_CURSOR_LABEL_EL NULL
#define GENESIS_PLUS_GX_GUN_CURSOR_INFO_0_EL NULL
#define GENESIS_PLUS_GX_INVERT_MOUSE_LABEL_EL NULL
#define GENESIS_PLUS_GX_INVERT_MOUSE_INFO_0_EL NULL
#define GENESIS_PLUS_GX_NO_SPRITE_LIMIT_LABEL_EL NULL
#define GENESIS_PLUS_GX_NO_SPRITE_LIMIT_INFO_0_EL NULL
#define GENESIS_PLUS_GX_ENHANCED_VSCROLL_LABEL_EL NULL
#define GENESIS_PLUS_GX_ENHANCED_VSCROLL_INFO_0_EL NULL
#define GENESIS_PLUS_GX_ENHANCED_VSCROLL_LIMIT_LABEL_EL NULL
#define GENESIS_PLUS_GX_ENHANCED_VSCROLL_LIMIT_INFO_0_EL NULL
#define GENESIS_PLUS_GX_OVERCLOCK_LABEL_EL NULL
#define GENESIS_PLUS_GX_OVERCLOCK_INFO_0_EL NULL
#define OPTION_VAL_100_EL NULL
#define OPTION_VAL_125_EL NULL
#define OPTION_VAL_150_EL NULL
#define OPTION_VAL_175_EL NULL
#define OPTION_VAL_200_EL NULL
#define OPTION_VAL_225_EL NULL
#define OPTION_VAL_250_EL NULL
#define OPTION_VAL_275_EL NULL
#define OPTION_VAL_300_EL NULL
#define OPTION_VAL_325_EL NULL
#define OPTION_VAL_350_EL NULL
#define OPTION_VAL_375_EL NULL
#define OPTION_VAL_400_EL NULL
#define OPTION_VAL_425_EL NULL
#define OPTION_VAL_450_EL NULL
#define OPTION_VAL_475_EL NULL
#define OPTION_VAL_500_EL NULL
#define GENESIS_PLUS_GX_FORCE_DTACK_LABEL_EL NULL
#define GENESIS_PLUS_GX_FORCE_DTACK_INFO_0_EL NULL
#define GENESIS_PLUS_GX_ADDR_ERROR_LABEL_EL NULL
#define GENESIS_PLUS_GX_ADDR_ERROR_INFO_0_EL NULL
#define GENESIS_PLUS_GX_CD_LATENCY_LABEL_EL NULL
#define GENESIS_PLUS_GX_CD_LATENCY_INFO_0_EL NULL
#define GENESIS_PLUS_GX_CD_PRECACHE_LABEL_EL NULL
#define GENESIS_PLUS_GX_CD_PRECACHE_INFO_0_EL NULL
#define GENESIS_PLUS_GX_SHOW_ADVANCED_AUDIO_SETTINGS_LABEL_EL NULL
#define GENESIS_PLUS_GX_SHOW_ADVANCED_AUDIO_SETTINGS_INFO_0_EL NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_0_VOLUME_LABEL_EL NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_0_VOLUME_INFO_0_EL NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_1_VOLUME_LABEL_EL NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_1_VOLUME_INFO_0_EL NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_2_VOLUME_LABEL_EL NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_2_VOLUME_INFO_0_EL NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_3_VOLUME_LABEL_EL NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_3_VOLUME_INFO_0_EL NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_0_VOLUME_LABEL_EL NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_0_VOLUME_INFO_0_EL NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_1_VOLUME_LABEL_EL NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_1_VOLUME_INFO_0_EL NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_2_VOLUME_LABEL_EL NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_2_VOLUME_INFO_0_EL NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_3_VOLUME_LABEL_EL NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_3_VOLUME_INFO_0_EL NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_4_VOLUME_LABEL_EL NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_4_VOLUME_INFO_0_EL NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_5_VOLUME_LABEL_EL NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_5_VOLUME_INFO_0_EL NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_0_VOLUME_LABEL_EL NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_0_VOLUME_INFO_0_EL NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_1_VOLUME_LABEL_EL NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_1_VOLUME_INFO_0_EL NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_2_VOLUME_LABEL_EL NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_2_VOLUME_INFO_0_EL NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_3_VOLUME_LABEL_EL NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_3_VOLUME_INFO_0_EL NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_4_VOLUME_LABEL_EL NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_4_VOLUME_INFO_0_EL NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_5_VOLUME_LABEL_EL NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_5_VOLUME_INFO_0_EL NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_6_VOLUME_LABEL_EL NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_6_VOLUME_INFO_0_EL NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_7_VOLUME_LABEL_EL NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_7_VOLUME_INFO_0_EL NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_8_VOLUME_LABEL_EL NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_8_VOLUME_INFO_0_EL NULL

struct retro_core_option_v2_category option_cats_el[] = {
   {
      "system",
      CATEGORY_SYSTEM_LABEL_EL,
      CATEGORY_SYSTEM_INFO_0_EL
   },
   {
      "video",
      CATEGORY_VIDEO_LABEL_EL,
      CATEGORY_VIDEO_INFO_0_EL
   },
   {
      "audio",
      CATEGORY_AUDIO_LABEL_EL,
      CATEGORY_AUDIO_INFO_0_EL
   },
   {
      "input",
      CATEGORY_INPUT_LABEL_EL,
      CATEGORY_INPUT_INFO_0_EL
   },
   {
      "hacks",
      CATEGORY_HACKS_LABEL_EL,
      CATEGORY_HACKS_INFO_0_EL
   },
   {
      "channel_volume",
      CATEGORY_CHANNEL_VOLUME_LABEL_EL,
      CATEGORY_CHANNEL_VOLUME_INFO_0_EL
   },
   { NULL, NULL, NULL },
};
struct retro_core_option_v2_definition option_defs_el[] = {
   {
      "genesis_plus_gx_system_hw",
      GENESIS_PLUS_GX_SYSTEM_HW_LABEL_EL,
      NULL,
      GENESIS_PLUS_GX_SYSTEM_HW_INFO_0_EL,
      NULL,
      "system",
      {
         { "auto",                 OPTION_VAL_AUTO_EL                 },
         { "sg-1000",              OPTION_VAL_SG_1000_EL              },
         { "sg-1000 II",           OPTION_VAL_SG_1000_II_EL           },
         { "sg-1000 II + ram ext.",OPTION_VAL_SG_1000_II_RAM_EXT_EL},
         { "mark-III",             OPTION_VAL_MARK_III_EL             },
         { "master system",        OPTION_VAL_MASTER_SYSTEM_EL        },
         { "master system II",     OPTION_VAL_MASTER_SYSTEM_II_EL     },
         { "game gear",            OPTION_VAL_GAME_GEAR_EL            },
         { "mega drive / genesis", OPTION_VAL_MEGA_DRIVE_GENESIS_EL   },
         { NULL, NULL },
      },
      "auto"
   },
   {
      "genesis_plus_gx_region_detect",
      GENESIS_PLUS_GX_REGION_DETECT_LABEL_EL,
      NULL,
      GENESIS_PLUS_GX_REGION_DETECT_INFO_0_EL,
      NULL,
      "system",
      {
         { "auto",    OPTION_VAL_AUTO_EL   },
         { "ntsc-u",  OPTION_VAL_NTSC_U_EL },
         { "pal",     OPTION_VAL_PAL_EL    },
         { "ntsc-j",  OPTION_VAL_NTSC_J_EL },
         { NULL, NULL },
      },
      "auto"
   },
   {
      "genesis_plus_gx_vdp_mode",
      GENESIS_PLUS_GX_VDP_MODE_LABEL_EL,
      NULL,
      GENESIS_PLUS_GX_VDP_MODE_INFO_0_EL,
      NULL,
      "system",
      {
         { "auto",  "Disabled" },
         { "60hz",  OPTION_VAL_60HZ_EL },
         { "50hz",  OPTION_VAL_50HZ_EL },
         { NULL, NULL },
      },
      "auto"
   },
   {
      "genesis_plus_gx_bios",
      GENESIS_PLUS_GX_BIOS_LABEL_EL,
      NULL,
      GENESIS_PLUS_GX_BIOS_INFO_0_EL,
      NULL,
      "system",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_system_bram",
      GENESIS_PLUS_GX_SYSTEM_BRAM_LABEL_EL,
      NULL,
      GENESIS_PLUS_GX_SYSTEM_BRAM_INFO_0_EL,
      NULL,
      "system",
      {
         { "per bios", OPTION_VAL_PER_BIOS_EL },
         { "per game", OPTION_VAL_PER_GAME_EL },
         { NULL, NULL },
      },
      "per bios"
   },
   {
      "genesis_plus_gx_cart_bram",
      GENESIS_PLUS_GX_CART_BRAM_LABEL_EL,
      NULL,
      GENESIS_PLUS_GX_CART_BRAM_INFO_0_EL,
      NULL,
      "system",
      {
         { "per cart", OPTION_VAL_PER_CART_EL },
         { "per game", OPTION_VAL_PER_GAME_EL },
         { NULL, NULL },
      },
      "per cart"
   },
   {
      "genesis_plus_gx_cart_size",
      GENESIS_PLUS_GX_CART_SIZE_LABEL_EL,
      NULL,
      GENESIS_PLUS_GX_CART_SIZE_INFO_0_EL,
      NULL,
      "system",
      {
         { "disabled", "Disabled" },
         { "128k",     OPTION_VAL_128K_EL  },
         { "256k",     OPTION_VAL_256K_EL  },
         { "512k",     OPTION_VAL_512K_EL  },
         { "1meg",     OPTION_VAL_1MEG_EL    },
         { "2meg",     OPTION_VAL_2MEG_EL    },
         { "4meg",     OPTION_VAL_4MEG_EL    },
         { NULL, NULL },
      },
      "4meg"
   },
   {
      "genesis_plus_gx_add_on",
      GENESIS_PLUS_GX_ADD_ON_LABEL_EL,
      NULL,
      GENESIS_PLUS_GX_ADD_ON_INFO_0_EL,
      NULL,
      "system",
      {
         { "auto",         OPTION_VAL_AUTO_EL },
         { "sega/mega cd", OPTION_VAL_SEGA_MEGA_CD_EL },
         { "megasd",       OPTION_VAL_MEGASD_EL },
         { "none",         OPTION_VAL_NONE_EL },
         { NULL, NULL },
      },
      "auto"
   },
   {
      "genesis_plus_gx_lock_on",
      GENESIS_PLUS_GX_LOCK_ON_LABEL_EL,
      NULL,
      GENESIS_PLUS_GX_LOCK_ON_INFO_0_EL,
      NULL,
      "system",
      {
         { "disabled",            NULL },
         { "game genie",          OPTION_VAL_GAME_GENIE_EL },
         { "action replay (pro)", OPTION_VAL_ACTION_REPLAY_PRO_EL },
         { "sonic & knuckles",    OPTION_VAL_SONIC_KNUCKLES_EL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_aspect_ratio",
      GENESIS_PLUS_GX_ASPECT_RATIO_LABEL_EL,
      NULL,
      GENESIS_PLUS_GX_ASPECT_RATIO_INFO_0_EL,
      NULL,
      "video",
      {
         { "auto",     OPTION_VAL_AUTO_EL },
         { "NTSC PAR", OPTION_VAL_NTSC_PAR_EL },
         { "PAL PAR",  OPTION_VAL_PAL_PAR_EL },
         { "4:3",  OPTION_VAL_4_3_EL },
         { "Uncorrected",  OPTION_VAL_UNCORRECTED_EL },
      },
      "auto"
   },
   {
      "genesis_plus_gx_overscan",
      GENESIS_PLUS_GX_OVERSCAN_LABEL_EL,
      NULL,
      GENESIS_PLUS_GX_OVERSCAN_INFO_0_EL,
      NULL,
      "video",
      {
         { "disabled",   NULL },
         { "top/bottom", OPTION_VAL_TOP_BOTTOM_EL },
         { "left/right", OPTION_VAL_LEFT_RIGHT_EL },
         { "full",       OPTION_VAL_FULL_EL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_left_border",
      GENESIS_PLUS_GX_LEFT_BORDER_LABEL_EL,
      NULL,
      GENESIS_PLUS_GX_LEFT_BORDER_INFO_0_EL,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "left border", OPTION_VAL_LEFT_BORDER_EL },
         { "left & right borders", OPTION_VAL_LEFT_RIGHT_BORDERS_EL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_gg_extra",
      GENESIS_PLUS_GX_GG_EXTRA_LABEL_EL,
      NULL,
      GENESIS_PLUS_GX_GG_EXTRA_INFO_0_EL,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_blargg_ntsc_filter",
      GENESIS_PLUS_GX_BLARGG_NTSC_FILTER_LABEL_EL,
      NULL,
      GENESIS_PLUS_GX_BLARGG_NTSC_FILTER_INFO_0_EL,
      NULL,
      "video",
      {
         { "disabled",   NULL },
         { "monochrome", OPTION_VAL_MONOCHROME_EL },
         { "composite",  OPTION_VAL_COMPOSITE_EL },
         { "svideo",     OPTION_VAL_SVIDEO_EL },
         { "rgb",        OPTION_VAL_RGB_EL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_lcd_filter",
      GENESIS_PLUS_GX_LCD_FILTER_LABEL_EL,
      NULL,
      GENESIS_PLUS_GX_LCD_FILTER_INFO_0_EL,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_render",
      GENESIS_PLUS_GX_RENDER_LABEL_EL,
      NULL,
      GENESIS_PLUS_GX_RENDER_INFO_0_EL,
      NULL,
      "video",
      {
         { "single field", OPTION_VAL_SINGLE_FIELD_EL },
         { "double field", OPTION_VAL_DOUBLE_FIELD_EL },
         { NULL, NULL },
      },
      "single field"
   },
   {
      "genesis_plus_gx_frameskip",
      GENESIS_PLUS_GX_FRAMESKIP_LABEL_EL,
      NULL,
      GENESIS_PLUS_GX_FRAMESKIP_INFO_0_EL,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "auto",     OPTION_VAL_AUTO_EL },
         { "manual",   OPTION_VAL_MANUAL_EL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_frameskip_threshold",
      GENESIS_PLUS_GX_FRAMESKIP_THRESHOLD_LABEL_EL,
      NULL,
      GENESIS_PLUS_GX_FRAMESKIP_THRESHOLD_INFO_0_EL,
      NULL,
      "video",
      {
         { "15", NULL },
         { "18", NULL },
         { "21", NULL },
         { "24", NULL },
         { "27", NULL },
         { "30", NULL },
         { "33", NULL },
         { "36", NULL },
         { "39", NULL },
         { "42", NULL },
         { "45", NULL },
         { "48", NULL },
         { "51", NULL },
         { "54", NULL },
         { "57", NULL },
         { "60", NULL },
         { NULL, NULL },
      },
      "33"
   },
   {
      "genesis_plus_gx_ym2413",
      GENESIS_PLUS_GX_YM2413_LABEL_EL,
      NULL,
      GENESIS_PLUS_GX_YM2413_INFO_0_EL,
      NULL,
      "audio",
      {
         { "auto",     OPTION_VAL_AUTO_EL },
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "auto"
   },
#ifdef HAVE_OPLL_CORE
   {
      "genesis_plus_gx_ym2413_core",
      GENESIS_PLUS_GX_YM2413_CORE_LABEL_EL,
      NULL,
      GENESIS_PLUS_GX_YM2413_CORE_INFO_0_EL,
      NULL,
      "audio",
      {
         { "mame",  OPTION_VAL_MAME_EL },
         { "nuked", OPTION_VAL_NUKED_EL },
         { NULL, NULL },
      },
      "mame"
   },
#endif
   {
      "genesis_plus_gx_ym2612",
      GENESIS_PLUS_GX_YM2612_LABEL_EL,
      NULL,
#ifdef HAVE_YM3438_CORE
      GENESIS_PLUS_GX_YM2612_INFO_0_EL,
#else
      GENESIS_PLUS_GX_YM2612_INFO_1_EL,
#endif
      NULL,
      "audio",
      {
         { "mame (ym2612)",          OPTION_VAL_MAME_YM2612_EL },
         { "mame (asic ym3438)",     OPTION_VAL_MAME_ASIC_YM3438_EL },
         { "mame (enhanced ym3438)", OPTION_VAL_MAME_ENHANCED_YM3438_EL },
#ifdef HAVE_YM3438_CORE
         { "nuked (ym2612)",         OPTION_VAL_NUKED_YM2612_EL },
         { "nuked (ym3438)",         OPTION_VAL_NUKED_YM3438_EL },
#endif
         { NULL, NULL },
      },
      "mame (ym2612)"
   },
   {
      "genesis_plus_gx_sound_output",
      GENESIS_PLUS_GX_SOUND_OUTPUT_LABEL_EL,
      NULL,
      GENESIS_PLUS_GX_SOUND_OUTPUT_INFO_0_EL,
      NULL,
      "audio",
      {
         { "stereo", OPTION_VAL_STEREO_EL },
         { "mono",   OPTION_VAL_MONO_EL },
         { NULL, NULL },
      },
      "stereo"
   },
   {
      "genesis_plus_gx_audio_filter",
      GENESIS_PLUS_GX_AUDIO_FILTER_LABEL_EL,
      NULL,
      GENESIS_PLUS_GX_AUDIO_FILTER_INFO_0_EL,
      NULL,
      "audio",
      {
         { "disabled", NULL },
         { "low-pass", OPTION_VAL_LOW_PASS_EL },
#ifdef HAVE_EQ
         { "EQ",       OPTION_VAL_EQ_EL },
#endif
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_lowpass_range",
      GENESIS_PLUS_GX_LOWPASS_RANGE_LABEL_EL,
      NULL,
      GENESIS_PLUS_GX_LOWPASS_RANGE_INFO_0_EL,
      NULL,
      "audio",
      {
         { "5",  NULL },
         { "10", NULL },
         { "15", NULL },
         { "20", NULL },
         { "25", NULL },
         { "30", NULL },
         { "35", NULL },
         { "40", NULL },
         { "45", NULL },
         { "50", NULL },
         { "55", NULL },
         { "60", NULL },
         { "65", NULL },
         { "70", NULL },
         { "75", NULL },
         { "80", NULL },
         { "85", NULL },
         { "90", NULL },
         { "95", NULL },
         { NULL, NULL },
      },
      "60"
   },
   {
      "genesis_plus_gx_psg_preamp",
      GENESIS_PLUS_GX_PSG_PREAMP_LABEL_EL,
      NULL,
      GENESIS_PLUS_GX_PSG_PREAMP_INFO_0_EL,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { "105", NULL },
         { "110", NULL },
         { "115", NULL },
         { "120", NULL },
         { "125", NULL },
         { "130", NULL },
         { "135", NULL },
         { "140", NULL },
         { "145", NULL },
         { "150", NULL },
         { "155", NULL },
         { "160", NULL },
         { "165", NULL },
         { "170", NULL },
         { "175", NULL },
         { "180", NULL },
         { "185", NULL },
         { "190", NULL },
         { "195", NULL },
         { "200", NULL },
         { NULL, NULL },
      },
      "150"
   },
   {
      "genesis_plus_gx_fm_preamp",
      GENESIS_PLUS_GX_FM_PREAMP_LABEL_EL,
      NULL,
      GENESIS_PLUS_GX_FM_PREAMP_INFO_0_EL,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { "105", NULL },
         { "110", NULL },
         { "115", NULL },
         { "120", NULL },
         { "125", NULL },
         { "130", NULL },
         { "135", NULL },
         { "140", NULL },
         { "145", NULL },
         { "150", NULL },
         { "155", NULL },
         { "160", NULL },
         { "165", NULL },
         { "170", NULL },
         { "175", NULL },
         { "180", NULL },
         { "185", NULL },
         { "190", NULL },
         { "195", NULL },
         { "200", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_cdda_volume",
      GENESIS_PLUS_GX_CDDA_VOLUME_LABEL_EL,
      NULL,
      GENESIS_PLUS_GX_CDDA_VOLUME_INFO_0_EL,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_pcm_volume",
      GENESIS_PLUS_GX_PCM_VOLUME_LABEL_EL,
      NULL,
      GENESIS_PLUS_GX_PCM_VOLUME_INFO_0_EL,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
#ifdef HAVE_EQ
   {
      "genesis_plus_gx_audio_eq_low",
      GENESIS_PLUS_GX_AUDIO_EQ_LOW_LABEL_EL,
      NULL,
      GENESIS_PLUS_GX_AUDIO_EQ_LOW_INFO_0_EL,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_audio_eq_mid",
      GENESIS_PLUS_GX_AUDIO_EQ_MID_LABEL_EL,
      NULL,
      GENESIS_PLUS_GX_AUDIO_EQ_MID_INFO_0_EL,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_audio_eq_high",
      GENESIS_PLUS_GX_AUDIO_EQ_HIGH_LABEL_EL,
      NULL,
      GENESIS_PLUS_GX_AUDIO_EQ_HIGH_INFO_0_EL,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
#endif
   {
      "genesis_plus_gx_gun_input",
      GENESIS_PLUS_GX_GUN_INPUT_LABEL_EL,
      NULL,
      GENESIS_PLUS_GX_GUN_INPUT_INFO_0_EL,
      NULL,
      "input",
      {
         { "lightgun",    OPTION_VAL_LIGHTGUN_EL },
         { "touchscreen", OPTION_VAL_TOUCHSCREEN_EL },
         { NULL, NULL },
      },
      "lightgun"
   },
   {
      "genesis_plus_gx_gun_cursor",
      GENESIS_PLUS_GX_GUN_CURSOR_LABEL_EL,
      NULL,
      GENESIS_PLUS_GX_GUN_CURSOR_INFO_0_EL,
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_invert_mouse",
      GENESIS_PLUS_GX_INVERT_MOUSE_LABEL_EL,
      NULL,
      GENESIS_PLUS_GX_INVERT_MOUSE_INFO_0_EL,
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_no_sprite_limit",
      GENESIS_PLUS_GX_NO_SPRITE_LIMIT_LABEL_EL,
      NULL,
      GENESIS_PLUS_GX_NO_SPRITE_LIMIT_INFO_0_EL,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_enhanced_vscroll",
      GENESIS_PLUS_GX_ENHANCED_VSCROLL_LABEL_EL,
      NULL,
      GENESIS_PLUS_GX_ENHANCED_VSCROLL_INFO_0_EL,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_enhanced_vscroll_limit",
      GENESIS_PLUS_GX_ENHANCED_VSCROLL_LIMIT_LABEL_EL,
      NULL,
      GENESIS_PLUS_GX_ENHANCED_VSCROLL_LIMIT_INFO_0_EL,
      NULL,
      "hacks",
      {
         { "2", NULL },
         { "3",  NULL },
         { "4", NULL },
         { "5",  NULL },
         { "6", NULL },
         { "7",  NULL },
         { "8", NULL },
         { "9",  NULL },
         { "10", NULL },
         { "11",  NULL },
         { "12", NULL },
         { "13",  NULL },
         { "14", NULL },
         { "15",  NULL },
         { "16", NULL },
         { NULL, NULL },
      },
      "8"
   },
#ifdef HAVE_OVERCLOCK
   {
      "genesis_plus_gx_overclock",
      GENESIS_PLUS_GX_OVERCLOCK_LABEL_EL,
      NULL,
      GENESIS_PLUS_GX_OVERCLOCK_INFO_0_EL,
      NULL,
      "hacks",
      {
         { "100", OPTION_VAL_100_EL },
         { "125", OPTION_VAL_125_EL },
         { "150", OPTION_VAL_150_EL },
         { "175", OPTION_VAL_175_EL },
         { "200", OPTION_VAL_200_EL },
         { "225", OPTION_VAL_225_EL },
         { "250", OPTION_VAL_250_EL },
         { "275", OPTION_VAL_275_EL },
         { "300", OPTION_VAL_300_EL },
         { "325", OPTION_VAL_325_EL },
         { "350", OPTION_VAL_350_EL },
         { "375", OPTION_VAL_375_EL },
         { "400", OPTION_VAL_400_EL },
         { "425", OPTION_VAL_425_EL },
         { "450", OPTION_VAL_450_EL },
         { "475", OPTION_VAL_475_EL },
         { "500", OPTION_VAL_500_EL },
         { NULL, NULL },
      },
      "100%"
   },
#endif
   {
      "genesis_plus_gx_force_dtack",
      GENESIS_PLUS_GX_FORCE_DTACK_LABEL_EL,
      NULL,
      GENESIS_PLUS_GX_FORCE_DTACK_INFO_0_EL,
      NULL,
      "hacks",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL },
      },
      "enabled"
   },
   {
      "genesis_plus_gx_addr_error",
      GENESIS_PLUS_GX_ADDR_ERROR_LABEL_EL,
      NULL,
      GENESIS_PLUS_GX_ADDR_ERROR_INFO_0_EL,
      NULL,
      "hacks",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL },
      },
      "enabled"
   },
   {
      "genesis_plus_gx_cd_latency",
      GENESIS_PLUS_GX_CD_LATENCY_LABEL_EL,
      NULL,
      GENESIS_PLUS_GX_CD_LATENCY_INFO_0_EL,
      NULL,
      "hacks",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL },
      },
      "enabled"
   },
   {
      "genesis_plus_gx_cd_precache",
      GENESIS_PLUS_GX_CD_PRECACHE_LABEL_EL,
      NULL,
      GENESIS_PLUS_GX_CD_PRECACHE_INFO_0_EL,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
#ifdef USE_PER_SOUND_CHANNELS_CONFIG
   {
      "genesis_plus_gx_show_advanced_audio_settings",
      GENESIS_PLUS_GX_SHOW_ADVANCED_AUDIO_SETTINGS_LABEL_EL,
      NULL,
      GENESIS_PLUS_GX_SHOW_ADVANCED_AUDIO_SETTINGS_INFO_0_EL,
      NULL,
      "channel_volume",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL},
      },
      "disabled"
   },
   {
      "genesis_plus_gx_psg_channel_0_volume",
      GENESIS_PLUS_GX_PSG_CHANNEL_0_VOLUME_LABEL_EL,
      NULL,
      GENESIS_PLUS_GX_PSG_CHANNEL_0_VOLUME_INFO_0_EL,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_psg_channel_1_volume",
      GENESIS_PLUS_GX_PSG_CHANNEL_1_VOLUME_LABEL_EL,
      NULL,
      GENESIS_PLUS_GX_PSG_CHANNEL_1_VOLUME_INFO_0_EL,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_psg_channel_2_volume",
      GENESIS_PLUS_GX_PSG_CHANNEL_2_VOLUME_LABEL_EL,
      NULL,
      GENESIS_PLUS_GX_PSG_CHANNEL_2_VOLUME_INFO_0_EL,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_psg_channel_3_volume",
      GENESIS_PLUS_GX_PSG_CHANNEL_3_VOLUME_LABEL_EL,
      NULL,
      GENESIS_PLUS_GX_PSG_CHANNEL_3_VOLUME_INFO_0_EL,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_0_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_0_VOLUME_LABEL_EL,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_0_VOLUME_INFO_0_EL,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_1_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_1_VOLUME_LABEL_EL,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_1_VOLUME_INFO_0_EL,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_2_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_2_VOLUME_LABEL_EL,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_2_VOLUME_INFO_0_EL,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_3_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_3_VOLUME_LABEL_EL,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_3_VOLUME_INFO_0_EL,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_4_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_4_VOLUME_LABEL_EL,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_4_VOLUME_INFO_0_EL,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_5_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_5_VOLUME_LABEL_EL,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_5_VOLUME_INFO_0_EL,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_0_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_0_VOLUME_LABEL_EL,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_0_VOLUME_INFO_0_EL,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_1_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_1_VOLUME_LABEL_EL,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_1_VOLUME_INFO_0_EL,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_2_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_2_VOLUME_LABEL_EL,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_2_VOLUME_INFO_0_EL,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_3_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_3_VOLUME_LABEL_EL,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_3_VOLUME_INFO_0_EL,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_4_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_4_VOLUME_LABEL_EL,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_4_VOLUME_INFO_0_EL,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_5_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_5_VOLUME_LABEL_EL,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_5_VOLUME_INFO_0_EL,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_6_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_6_VOLUME_LABEL_EL,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_6_VOLUME_INFO_0_EL,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_7_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_7_VOLUME_LABEL_EL,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_7_VOLUME_INFO_0_EL,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_8_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_8_VOLUME_LABEL_EL,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_8_VOLUME_INFO_0_EL,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
#endif
   { NULL, NULL, NULL, NULL, NULL, NULL, {{0}}, NULL },
};
struct retro_core_options_v2 options_el = {
   option_cats_el,
   option_defs_el
};

/* RETRO_LANGUAGE_EN */

#define CATEGORY_SYSTEM_LABEL_EN NULL
#define CATEGORY_SYSTEM_INFO_0_EN NULL
#define CATEGORY_VIDEO_LABEL_EN NULL
#define CATEGORY_VIDEO_INFO_0_EN NULL
#define CATEGORY_AUDIO_LABEL_EN NULL
#define CATEGORY_AUDIO_INFO_0_EN NULL
#define CATEGORY_INPUT_LABEL_EN NULL
#define CATEGORY_INPUT_INFO_0_EN NULL
#define CATEGORY_HACKS_LABEL_EN NULL
#define CATEGORY_HACKS_INFO_0_EN "Change processor over-clocking and emulation accuracy settings that affect low-level performance and compatibility."
#define CATEGORY_CHANNEL_VOLUME_LABEL_EN NULL
#define CATEGORY_CHANNEL_VOLUME_INFO_0_EN NULL
#define GENESIS_PLUS_GX_SYSTEM_HW_LABEL_EN NULL
#define GENESIS_PLUS_GX_SYSTEM_HW_INFO_0_EN NULL
#define OPTION_VAL_AUTO_EN NULL
#define OPTION_VAL_SG_1000_EN NULL
#define OPTION_VAL_SG_1000_II_EN NULL
#define OPTION_VAL_SG_1000_II_RAM_EXT_EN NULL
#define OPTION_VAL_MARK_III_EN NULL
#define OPTION_VAL_MASTER_SYSTEM_EN NULL
#define OPTION_VAL_MASTER_SYSTEM_II_EN NULL
#define OPTION_VAL_GAME_GEAR_EN NULL
#define OPTION_VAL_MEGA_DRIVE_GENESIS_EN NULL
#define GENESIS_PLUS_GX_REGION_DETECT_LABEL_EN NULL
#define GENESIS_PLUS_GX_REGION_DETECT_INFO_0_EN NULL
#define OPTION_VAL_NTSC_U_EN NULL
#define OPTION_VAL_PAL_EN NULL
#define OPTION_VAL_NTSC_J_EN NULL
#define GENESIS_PLUS_GX_VDP_MODE_LABEL_EN NULL
#define GENESIS_PLUS_GX_VDP_MODE_INFO_0_EN NULL
#define OPTION_VAL_60HZ_EN NULL
#define OPTION_VAL_50HZ_EN NULL
#define GENESIS_PLUS_GX_BIOS_LABEL_EN NULL
#define GENESIS_PLUS_GX_BIOS_INFO_0_EN NULL
#define GENESIS_PLUS_GX_SYSTEM_BRAM_LABEL_EN NULL
#define GENESIS_PLUS_GX_SYSTEM_BRAM_INFO_0_EN NULL
#define OPTION_VAL_PER_BIOS_EN NULL
#define OPTION_VAL_PER_GAME_EN NULL
#define GENESIS_PLUS_GX_CART_BRAM_LABEL_EN NULL
#define GENESIS_PLUS_GX_CART_BRAM_INFO_0_EN NULL
#define OPTION_VAL_PER_CART_EN NULL
#define GENESIS_PLUS_GX_CART_SIZE_LABEL_EN NULL
#define GENESIS_PLUS_GX_CART_SIZE_INFO_0_EN NULL
#define OPTION_VAL_128K_EN NULL
#define OPTION_VAL_256K_EN NULL
#define OPTION_VAL_512K_EN NULL
#define OPTION_VAL_1MEG_EN NULL
#define OPTION_VAL_2MEG_EN NULL
#define OPTION_VAL_4MEG_EN NULL
#define GENESIS_PLUS_GX_ADD_ON_LABEL_EN NULL
#define GENESIS_PLUS_GX_ADD_ON_INFO_0_EN NULL
#define OPTION_VAL_SEGA_MEGA_CD_EN NULL
#define OPTION_VAL_MEGASD_EN "Mega-SD"
#define OPTION_VAL_NONE_EN NULL
#define GENESIS_PLUS_GX_LOCK_ON_LABEL_EN NULL
#define GENESIS_PLUS_GX_LOCK_ON_INFO_0_EN NULL
#define OPTION_VAL_GAME_GENIE_EN NULL
#define OPTION_VAL_ACTION_REPLAY_PRO_EN NULL
#define OPTION_VAL_SONIC_KNUCKLES_EN NULL
#define GENESIS_PLUS_GX_ASPECT_RATIO_LABEL_EN NULL
#define GENESIS_PLUS_GX_ASPECT_RATIO_INFO_0_EN NULL
#define OPTION_VAL_NTSC_PAR_EN NULL
#define OPTION_VAL_PAL_PAR_EN NULL
#define OPTION_VAL_4_3_EN NULL
#define OPTION_VAL_UNCORRECTED_EN NULL
#define GENESIS_PLUS_GX_OVERSCAN_LABEL_EN NULL
#define GENESIS_PLUS_GX_OVERSCAN_INFO_0_EN NULL
#define OPTION_VAL_TOP_BOTTOM_EN NULL
#define OPTION_VAL_LEFT_RIGHT_EN NULL
#define OPTION_VAL_FULL_EN NULL
#define GENESIS_PLUS_GX_LEFT_BORDER_LABEL_EN NULL
#define GENESIS_PLUS_GX_LEFT_BORDER_INFO_0_EN NULL
#define OPTION_VAL_LEFT_BORDER_EN NULL
#define OPTION_VAL_LEFT_RIGHT_BORDERS_EN NULL
#define GENESIS_PLUS_GX_GG_EXTRA_LABEL_EN NULL
#define GENESIS_PLUS_GX_GG_EXTRA_INFO_0_EN NULL
#define GENESIS_PLUS_GX_BLARGG_NTSC_FILTER_LABEL_EN NULL
#define GENESIS_PLUS_GX_BLARGG_NTSC_FILTER_INFO_0_EN NULL
#define OPTION_VAL_MONOCHROME_EN NULL
#define OPTION_VAL_COMPOSITE_EN NULL
#define OPTION_VAL_SVIDEO_EN NULL
#define OPTION_VAL_RGB_EN NULL
#define GENESIS_PLUS_GX_LCD_FILTER_LABEL_EN NULL
#define GENESIS_PLUS_GX_LCD_FILTER_INFO_0_EN NULL
#define GENESIS_PLUS_GX_RENDER_LABEL_EN NULL
#define GENESIS_PLUS_GX_RENDER_INFO_0_EN "Interlaced Mode 2 allows the Mega Drive/Genesis to output a double height (high resolution) 320x448 image by drawing alternate scan lines each frame (this is used by Sonic the Hedgehog 2 and Combat Cars multi-player modes). 'Double Field' mimics original hardware, producing a sharp image with flickering/interlacing artefacts. 'Single Field' applies a de-interlacing filter, which stabilises the image but causes mild blurring."
#define OPTION_VAL_SINGLE_FIELD_EN NULL
#define OPTION_VAL_DOUBLE_FIELD_EN NULL
#define GENESIS_PLUS_GX_FRAMESKIP_LABEL_EN "Frame-skip"
#define GENESIS_PLUS_GX_FRAMESKIP_INFO_0_EN "Skip frames to avoid audio buffer under-run (crackling). Improves performance at the expense of visual smoothness. 'Auto' skips frames when advised by the front-end. 'Manual' utilizes the 'Frame-skip Threshold (%)' setting."
#define OPTION_VAL_MANUAL_EN NULL
#define GENESIS_PLUS_GX_FRAMESKIP_THRESHOLD_LABEL_EN "Frame-skip Threshold (%)"
#define GENESIS_PLUS_GX_FRAMESKIP_THRESHOLD_INFO_0_EN "When 'Frame-skip' is set to 'Manual', this specifies the audio buffer occupancy threshold (percentage) below which frames will be skipped. Higher values reduce the risk of crackling by causing frames to be dropped more frequently."
#define GENESIS_PLUS_GX_YM2413_LABEL_EN NULL
#define GENESIS_PLUS_GX_YM2413_INFO_0_EN NULL
#define GENESIS_PLUS_GX_YM2413_CORE_LABEL_EN NULL
#define GENESIS_PLUS_GX_YM2413_CORE_INFO_0_EN NULL
#define OPTION_VAL_MAME_EN NULL
#define OPTION_VAL_NUKED_EN NULL
#define GENESIS_PLUS_GX_YM2612_LABEL_EN NULL
#define GENESIS_PLUS_GX_YM2612_INFO_0_EN "Select method used to emulate the FM synthesiser (main sound generator) of the Mega Drive/Genesis. 'MAME' options are fast, and run full speed on most systems. 'Nuked' options are cycle accurate, very high quality, and have substantial CPU requirements. The YM2612 chip is used by the original Model 1 Mega Drive/Genesis. The YM3438 is used in later Mega Drive/Genesis revisions."
#define GENESIS_PLUS_GX_YM2612_INFO_1_EN "Select method used to emulate the FM synthesiser (main sound generator) of the Mega Drive/Genesis. The YM2612 chip is used by the original Model 1 Mega Drive/Genesis. The YM3438 is used in later Mega Drive/Genesis revisions."
#define OPTION_VAL_MAME_YM2612_EN NULL
#define OPTION_VAL_MAME_ASIC_YM3438_EN NULL
#define OPTION_VAL_MAME_ENHANCED_YM3438_EN NULL
#define OPTION_VAL_NUKED_YM2612_EN NULL
#define OPTION_VAL_NUKED_YM3438_EN NULL
#define GENESIS_PLUS_GX_SOUND_OUTPUT_LABEL_EN NULL
#define GENESIS_PLUS_GX_SOUND_OUTPUT_INFO_0_EN "Select Stereo or Mono sound playback."
#define OPTION_VAL_STEREO_EN NULL
#define OPTION_VAL_MONO_EN NULL
#define GENESIS_PLUS_GX_AUDIO_FILTER_LABEL_EN NULL
#define GENESIS_PLUS_GX_AUDIO_FILTER_INFO_0_EN NULL
#define OPTION_VAL_LOW_PASS_EN NULL
#define OPTION_VAL_EQ_EN NULL
#define GENESIS_PLUS_GX_LOWPASS_RANGE_LABEL_EN NULL
#define GENESIS_PLUS_GX_LOWPASS_RANGE_INFO_0_EN NULL
#define GENESIS_PLUS_GX_PSG_PREAMP_LABEL_EN NULL
#define GENESIS_PLUS_GX_PSG_PREAMP_INFO_0_EN NULL
#define GENESIS_PLUS_GX_FM_PREAMP_LABEL_EN NULL
#define GENESIS_PLUS_GX_FM_PREAMP_INFO_0_EN "Set the audio preamplifier level of the emulated Mega Drive/Genesis FM sound synthesiser or Sega Mark III/Master System FM Sound Unit."
#define GENESIS_PLUS_GX_CDDA_VOLUME_LABEL_EN NULL
#define GENESIS_PLUS_GX_CDDA_VOLUME_INFO_0_EN NULL
#define GENESIS_PLUS_GX_PCM_VOLUME_LABEL_EN NULL
#define GENESIS_PLUS_GX_PCM_VOLUME_INFO_0_EN NULL
#define GENESIS_PLUS_GX_AUDIO_EQ_LOW_LABEL_EN NULL
#define GENESIS_PLUS_GX_AUDIO_EQ_LOW_INFO_0_EN "Adjust the low range band of the internal audio equaliser."
#define GENESIS_PLUS_GX_AUDIO_EQ_MID_LABEL_EN NULL
#define GENESIS_PLUS_GX_AUDIO_EQ_MID_INFO_0_EN "Adjust the middle range band of the internal audio equaliser."
#define GENESIS_PLUS_GX_AUDIO_EQ_HIGH_LABEL_EN NULL
#define GENESIS_PLUS_GX_AUDIO_EQ_HIGH_INFO_0_EN "Adjust the high range band of the internal audio equaliser."
#define GENESIS_PLUS_GX_GUN_INPUT_LABEL_EN NULL
#define GENESIS_PLUS_GX_GUN_INPUT_INFO_0_EN NULL
#define OPTION_VAL_LIGHTGUN_EN NULL
#define OPTION_VAL_TOUCHSCREEN_EN NULL
#define GENESIS_PLUS_GX_GUN_CURSOR_LABEL_EN NULL
#define GENESIS_PLUS_GX_GUN_CURSOR_INFO_0_EN "Display light gun cross-hairs when using the MD Menacer, MD Justifiers and MS Light Phaser input device types."
#define GENESIS_PLUS_GX_INVERT_MOUSE_LABEL_EN NULL
#define GENESIS_PLUS_GX_INVERT_MOUSE_INFO_0_EN NULL
#define GENESIS_PLUS_GX_NO_SPRITE_LIMIT_LABEL_EN NULL
#define GENESIS_PLUS_GX_NO_SPRITE_LIMIT_INFO_0_EN "Removes the original sprite-per-scan-line hardware limit. This reduces flickering but can cause visual glitches, as some games exploit the hardware limit to generate special effects."
#define GENESIS_PLUS_GX_ENHANCED_VSCROLL_LABEL_EN NULL
#define GENESIS_PLUS_GX_ENHANCED_VSCROLL_INFO_0_EN NULL
#define GENESIS_PLUS_GX_ENHANCED_VSCROLL_LIMIT_LABEL_EN NULL
#define GENESIS_PLUS_GX_ENHANCED_VSCROLL_LIMIT_INFO_0_EN NULL
#define GENESIS_PLUS_GX_OVERCLOCK_LABEL_EN NULL
#define GENESIS_PLUS_GX_OVERCLOCK_INFO_0_EN "Over-clock the emulated CPU. Can reduce slowdown, but may cause glitches."
#define OPTION_VAL_100_EN NULL
#define OPTION_VAL_125_EN NULL
#define OPTION_VAL_150_EN NULL
#define OPTION_VAL_175_EN NULL
#define OPTION_VAL_200_EN NULL
#define OPTION_VAL_225_EN NULL
#define OPTION_VAL_250_EN NULL
#define OPTION_VAL_275_EN NULL
#define OPTION_VAL_300_EN NULL
#define OPTION_VAL_325_EN NULL
#define OPTION_VAL_350_EN NULL
#define OPTION_VAL_375_EN NULL
#define OPTION_VAL_400_EN NULL
#define OPTION_VAL_425_EN NULL
#define OPTION_VAL_450_EN NULL
#define OPTION_VAL_475_EN NULL
#define OPTION_VAL_500_EN NULL
#define GENESIS_PLUS_GX_FORCE_DTACK_LABEL_EN NULL
#define GENESIS_PLUS_GX_FORCE_DTACK_INFO_0_EN "Emulate system lock-ups that occur on real hardware when performing illegal address access. This should only be disabled when playing certain demos and home-brew that rely on illegal behaviour for correct operation."
#define GENESIS_PLUS_GX_ADDR_ERROR_LABEL_EN NULL
#define GENESIS_PLUS_GX_ADDR_ERROR_INFO_0_EN "The Mega Drive/Genesis main CPU (Motorola 68000) generates an Address Error exception (crash) when attempting to perform unaligned memory access. Enabling this will simulate this behaviour. It should only be disabled when playing ROM hacks, since these are typically developed using less accurate emulators and may rely on invalid RAM access for correct operation."
#define GENESIS_PLUS_GX_CD_LATENCY_LABEL_EN NULL
#define GENESIS_PLUS_GX_CD_LATENCY_INFO_0_EN "Simulate original CD hardware latency when initiating a read or seeking to a specific location on loaded disc. This is required by a few CD games that crash if CD data is available too soon and also fixes CD audio de-sync issues in some games. Disabling this can be useful with MSU-MD games as it makes CD audio tracks loops more seamless."
#define GENESIS_PLUS_GX_CD_PRECACHE_LABEL_EN NULL
#define GENESIS_PLUS_GX_CD_PRECACHE_INFO_0_EN NULL
#define GENESIS_PLUS_GX_SHOW_ADVANCED_AUDIO_SETTINGS_LABEL_EN NULL
#define GENESIS_PLUS_GX_SHOW_ADVANCED_AUDIO_SETTINGS_INFO_0_EN NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_0_VOLUME_LABEL_EN NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_0_VOLUME_INFO_0_EN NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_1_VOLUME_LABEL_EN NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_1_VOLUME_INFO_0_EN NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_2_VOLUME_LABEL_EN NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_2_VOLUME_INFO_0_EN NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_3_VOLUME_LABEL_EN NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_3_VOLUME_INFO_0_EN NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_0_VOLUME_LABEL_EN NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_0_VOLUME_INFO_0_EN NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_1_VOLUME_LABEL_EN NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_1_VOLUME_INFO_0_EN NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_2_VOLUME_LABEL_EN NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_2_VOLUME_INFO_0_EN NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_3_VOLUME_LABEL_EN NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_3_VOLUME_INFO_0_EN NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_4_VOLUME_LABEL_EN NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_4_VOLUME_INFO_0_EN NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_5_VOLUME_LABEL_EN NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_5_VOLUME_INFO_0_EN NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_0_VOLUME_LABEL_EN NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_0_VOLUME_INFO_0_EN NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_1_VOLUME_LABEL_EN NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_1_VOLUME_INFO_0_EN NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_2_VOLUME_LABEL_EN NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_2_VOLUME_INFO_0_EN NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_3_VOLUME_LABEL_EN NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_3_VOLUME_INFO_0_EN NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_4_VOLUME_LABEL_EN NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_4_VOLUME_INFO_0_EN NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_5_VOLUME_LABEL_EN NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_5_VOLUME_INFO_0_EN NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_6_VOLUME_LABEL_EN NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_6_VOLUME_INFO_0_EN NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_7_VOLUME_LABEL_EN NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_7_VOLUME_INFO_0_EN NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_8_VOLUME_LABEL_EN NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_8_VOLUME_INFO_0_EN NULL

struct retro_core_option_v2_category option_cats_en[] = {
   {
      "system",
      CATEGORY_SYSTEM_LABEL_EN,
      CATEGORY_SYSTEM_INFO_0_EN
   },
   {
      "video",
      CATEGORY_VIDEO_LABEL_EN,
      CATEGORY_VIDEO_INFO_0_EN
   },
   {
      "audio",
      CATEGORY_AUDIO_LABEL_EN,
      CATEGORY_AUDIO_INFO_0_EN
   },
   {
      "input",
      CATEGORY_INPUT_LABEL_EN,
      CATEGORY_INPUT_INFO_0_EN
   },
   {
      "hacks",
      CATEGORY_HACKS_LABEL_EN,
      CATEGORY_HACKS_INFO_0_EN
   },
   {
      "channel_volume",
      CATEGORY_CHANNEL_VOLUME_LABEL_EN,
      CATEGORY_CHANNEL_VOLUME_INFO_0_EN
   },
   { NULL, NULL, NULL },
};
struct retro_core_option_v2_definition option_defs_en[] = {
   {
      "genesis_plus_gx_system_hw",
      GENESIS_PLUS_GX_SYSTEM_HW_LABEL_EN,
      NULL,
      GENESIS_PLUS_GX_SYSTEM_HW_INFO_0_EN,
      NULL,
      "system",
      {
         { "auto",                 OPTION_VAL_AUTO_EN                 },
         { "sg-1000",              OPTION_VAL_SG_1000_EN              },
         { "sg-1000 II",           OPTION_VAL_SG_1000_II_EN           },
         { "sg-1000 II + ram ext.",OPTION_VAL_SG_1000_II_RAM_EXT_EN},
         { "mark-III",             OPTION_VAL_MARK_III_EN             },
         { "master system",        OPTION_VAL_MASTER_SYSTEM_EN        },
         { "master system II",     OPTION_VAL_MASTER_SYSTEM_II_EN     },
         { "game gear",            OPTION_VAL_GAME_GEAR_EN            },
         { "mega drive / genesis", OPTION_VAL_MEGA_DRIVE_GENESIS_EN   },
         { NULL, NULL },
      },
      "auto"
   },
   {
      "genesis_plus_gx_region_detect",
      GENESIS_PLUS_GX_REGION_DETECT_LABEL_EN,
      NULL,
      GENESIS_PLUS_GX_REGION_DETECT_INFO_0_EN,
      NULL,
      "system",
      {
         { "auto",    OPTION_VAL_AUTO_EN   },
         { "ntsc-u",  OPTION_VAL_NTSC_U_EN },
         { "pal",     OPTION_VAL_PAL_EN    },
         { "ntsc-j",  OPTION_VAL_NTSC_J_EN },
         { NULL, NULL },
      },
      "auto"
   },
   {
      "genesis_plus_gx_vdp_mode",
      GENESIS_PLUS_GX_VDP_MODE_LABEL_EN,
      NULL,
      GENESIS_PLUS_GX_VDP_MODE_INFO_0_EN,
      NULL,
      "system",
      {
         { "auto",  "Disabled" },
         { "60hz",  OPTION_VAL_60HZ_EN },
         { "50hz",  OPTION_VAL_50HZ_EN },
         { NULL, NULL },
      },
      "auto"
   },
   {
      "genesis_plus_gx_bios",
      GENESIS_PLUS_GX_BIOS_LABEL_EN,
      NULL,
      GENESIS_PLUS_GX_BIOS_INFO_0_EN,
      NULL,
      "system",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_system_bram",
      GENESIS_PLUS_GX_SYSTEM_BRAM_LABEL_EN,
      NULL,
      GENESIS_PLUS_GX_SYSTEM_BRAM_INFO_0_EN,
      NULL,
      "system",
      {
         { "per bios", OPTION_VAL_PER_BIOS_EN },
         { "per game", OPTION_VAL_PER_GAME_EN },
         { NULL, NULL },
      },
      "per bios"
   },
   {
      "genesis_plus_gx_cart_bram",
      GENESIS_PLUS_GX_CART_BRAM_LABEL_EN,
      NULL,
      GENESIS_PLUS_GX_CART_BRAM_INFO_0_EN,
      NULL,
      "system",
      {
         { "per cart", OPTION_VAL_PER_CART_EN },
         { "per game", OPTION_VAL_PER_GAME_EN },
         { NULL, NULL },
      },
      "per cart"
   },
   {
      "genesis_plus_gx_cart_size",
      GENESIS_PLUS_GX_CART_SIZE_LABEL_EN,
      NULL,
      GENESIS_PLUS_GX_CART_SIZE_INFO_0_EN,
      NULL,
      "system",
      {
         { "disabled", "Disabled" },
         { "128k",     OPTION_VAL_128K_EN  },
         { "256k",     OPTION_VAL_256K_EN  },
         { "512k",     OPTION_VAL_512K_EN  },
         { "1meg",     OPTION_VAL_1MEG_EN    },
         { "2meg",     OPTION_VAL_2MEG_EN    },
         { "4meg",     OPTION_VAL_4MEG_EN    },
         { NULL, NULL },
      },
      "4meg"
   },
   {
      "genesis_plus_gx_add_on",
      GENESIS_PLUS_GX_ADD_ON_LABEL_EN,
      NULL,
      GENESIS_PLUS_GX_ADD_ON_INFO_0_EN,
      NULL,
      "system",
      {
         { "auto",         OPTION_VAL_AUTO_EN },
         { "sega/mega cd", OPTION_VAL_SEGA_MEGA_CD_EN },
         { "megasd",       OPTION_VAL_MEGASD_EN },
         { "none",         OPTION_VAL_NONE_EN },
         { NULL, NULL },
      },
      "auto"
   },
   {
      "genesis_plus_gx_lock_on",
      GENESIS_PLUS_GX_LOCK_ON_LABEL_EN,
      NULL,
      GENESIS_PLUS_GX_LOCK_ON_INFO_0_EN,
      NULL,
      "system",
      {
         { "disabled",            NULL },
         { "game genie",          OPTION_VAL_GAME_GENIE_EN },
         { "action replay (pro)", OPTION_VAL_ACTION_REPLAY_PRO_EN },
         { "sonic & knuckles",    OPTION_VAL_SONIC_KNUCKLES_EN },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_aspect_ratio",
      GENESIS_PLUS_GX_ASPECT_RATIO_LABEL_EN,
      NULL,
      GENESIS_PLUS_GX_ASPECT_RATIO_INFO_0_EN,
      NULL,
      "video",
      {
         { "auto",     OPTION_VAL_AUTO_EN },
         { "NTSC PAR", OPTION_VAL_NTSC_PAR_EN },
         { "PAL PAR",  OPTION_VAL_PAL_PAR_EN },
         { "4:3",  OPTION_VAL_4_3_EN },
         { "Uncorrected",  OPTION_VAL_UNCORRECTED_EN },
      },
      "auto"
   },
   {
      "genesis_plus_gx_overscan",
      GENESIS_PLUS_GX_OVERSCAN_LABEL_EN,
      NULL,
      GENESIS_PLUS_GX_OVERSCAN_INFO_0_EN,
      NULL,
      "video",
      {
         { "disabled",   NULL },
         { "top/bottom", OPTION_VAL_TOP_BOTTOM_EN },
         { "left/right", OPTION_VAL_LEFT_RIGHT_EN },
         { "full",       OPTION_VAL_FULL_EN },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_left_border",
      GENESIS_PLUS_GX_LEFT_BORDER_LABEL_EN,
      NULL,
      GENESIS_PLUS_GX_LEFT_BORDER_INFO_0_EN,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "left border", OPTION_VAL_LEFT_BORDER_EN },
         { "left & right borders", OPTION_VAL_LEFT_RIGHT_BORDERS_EN },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_gg_extra",
      GENESIS_PLUS_GX_GG_EXTRA_LABEL_EN,
      NULL,
      GENESIS_PLUS_GX_GG_EXTRA_INFO_0_EN,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_blargg_ntsc_filter",
      GENESIS_PLUS_GX_BLARGG_NTSC_FILTER_LABEL_EN,
      NULL,
      GENESIS_PLUS_GX_BLARGG_NTSC_FILTER_INFO_0_EN,
      NULL,
      "video",
      {
         { "disabled",   NULL },
         { "monochrome", OPTION_VAL_MONOCHROME_EN },
         { "composite",  OPTION_VAL_COMPOSITE_EN },
         { "svideo",     OPTION_VAL_SVIDEO_EN },
         { "rgb",        OPTION_VAL_RGB_EN },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_lcd_filter",
      GENESIS_PLUS_GX_LCD_FILTER_LABEL_EN,
      NULL,
      GENESIS_PLUS_GX_LCD_FILTER_INFO_0_EN,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_render",
      GENESIS_PLUS_GX_RENDER_LABEL_EN,
      NULL,
      GENESIS_PLUS_GX_RENDER_INFO_0_EN,
      NULL,
      "video",
      {
         { "single field", OPTION_VAL_SINGLE_FIELD_EN },
         { "double field", OPTION_VAL_DOUBLE_FIELD_EN },
         { NULL, NULL },
      },
      "single field"
   },
   {
      "genesis_plus_gx_frameskip",
      GENESIS_PLUS_GX_FRAMESKIP_LABEL_EN,
      NULL,
      GENESIS_PLUS_GX_FRAMESKIP_INFO_0_EN,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "auto",     OPTION_VAL_AUTO_EN },
         { "manual",   OPTION_VAL_MANUAL_EN },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_frameskip_threshold",
      GENESIS_PLUS_GX_FRAMESKIP_THRESHOLD_LABEL_EN,
      NULL,
      GENESIS_PLUS_GX_FRAMESKIP_THRESHOLD_INFO_0_EN,
      NULL,
      "video",
      {
         { "15", NULL },
         { "18", NULL },
         { "21", NULL },
         { "24", NULL },
         { "27", NULL },
         { "30", NULL },
         { "33", NULL },
         { "36", NULL },
         { "39", NULL },
         { "42", NULL },
         { "45", NULL },
         { "48", NULL },
         { "51", NULL },
         { "54", NULL },
         { "57", NULL },
         { "60", NULL },
         { NULL, NULL },
      },
      "33"
   },
   {
      "genesis_plus_gx_ym2413",
      GENESIS_PLUS_GX_YM2413_LABEL_EN,
      NULL,
      GENESIS_PLUS_GX_YM2413_INFO_0_EN,
      NULL,
      "audio",
      {
         { "auto",     OPTION_VAL_AUTO_EN },
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "auto"
   },
#ifdef HAVE_OPLL_CORE
   {
      "genesis_plus_gx_ym2413_core",
      GENESIS_PLUS_GX_YM2413_CORE_LABEL_EN,
      NULL,
      GENESIS_PLUS_GX_YM2413_CORE_INFO_0_EN,
      NULL,
      "audio",
      {
         { "mame",  OPTION_VAL_MAME_EN },
         { "nuked", OPTION_VAL_NUKED_EN },
         { NULL, NULL },
      },
      "mame"
   },
#endif
   {
      "genesis_plus_gx_ym2612",
      GENESIS_PLUS_GX_YM2612_LABEL_EN,
      NULL,
#ifdef HAVE_YM3438_CORE
      GENESIS_PLUS_GX_YM2612_INFO_0_EN,
#else
      GENESIS_PLUS_GX_YM2612_INFO_1_EN,
#endif
      NULL,
      "audio",
      {
         { "mame (ym2612)",          OPTION_VAL_MAME_YM2612_EN },
         { "mame (asic ym3438)",     OPTION_VAL_MAME_ASIC_YM3438_EN },
         { "mame (enhanced ym3438)", OPTION_VAL_MAME_ENHANCED_YM3438_EN },
#ifdef HAVE_YM3438_CORE
         { "nuked (ym2612)",         OPTION_VAL_NUKED_YM2612_EN },
         { "nuked (ym3438)",         OPTION_VAL_NUKED_YM3438_EN },
#endif
         { NULL, NULL },
      },
      "mame (ym2612)"
   },
   {
      "genesis_plus_gx_sound_output",
      GENESIS_PLUS_GX_SOUND_OUTPUT_LABEL_EN,
      NULL,
      GENESIS_PLUS_GX_SOUND_OUTPUT_INFO_0_EN,
      NULL,
      "audio",
      {
         { "stereo", OPTION_VAL_STEREO_EN },
         { "mono",   OPTION_VAL_MONO_EN },
         { NULL, NULL },
      },
      "stereo"
   },
   {
      "genesis_plus_gx_audio_filter",
      GENESIS_PLUS_GX_AUDIO_FILTER_LABEL_EN,
      NULL,
      GENESIS_PLUS_GX_AUDIO_FILTER_INFO_0_EN,
      NULL,
      "audio",
      {
         { "disabled", NULL },
         { "low-pass", OPTION_VAL_LOW_PASS_EN },
#ifdef HAVE_EQ
         { "EQ",       OPTION_VAL_EQ_EN },
#endif
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_lowpass_range",
      GENESIS_PLUS_GX_LOWPASS_RANGE_LABEL_EN,
      NULL,
      GENESIS_PLUS_GX_LOWPASS_RANGE_INFO_0_EN,
      NULL,
      "audio",
      {
         { "5",  NULL },
         { "10", NULL },
         { "15", NULL },
         { "20", NULL },
         { "25", NULL },
         { "30", NULL },
         { "35", NULL },
         { "40", NULL },
         { "45", NULL },
         { "50", NULL },
         { "55", NULL },
         { "60", NULL },
         { "65", NULL },
         { "70", NULL },
         { "75", NULL },
         { "80", NULL },
         { "85", NULL },
         { "90", NULL },
         { "95", NULL },
         { NULL, NULL },
      },
      "60"
   },
   {
      "genesis_plus_gx_psg_preamp",
      GENESIS_PLUS_GX_PSG_PREAMP_LABEL_EN,
      NULL,
      GENESIS_PLUS_GX_PSG_PREAMP_INFO_0_EN,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { "105", NULL },
         { "110", NULL },
         { "115", NULL },
         { "120", NULL },
         { "125", NULL },
         { "130", NULL },
         { "135", NULL },
         { "140", NULL },
         { "145", NULL },
         { "150", NULL },
         { "155", NULL },
         { "160", NULL },
         { "165", NULL },
         { "170", NULL },
         { "175", NULL },
         { "180", NULL },
         { "185", NULL },
         { "190", NULL },
         { "195", NULL },
         { "200", NULL },
         { NULL, NULL },
      },
      "150"
   },
   {
      "genesis_plus_gx_fm_preamp",
      GENESIS_PLUS_GX_FM_PREAMP_LABEL_EN,
      NULL,
      GENESIS_PLUS_GX_FM_PREAMP_INFO_0_EN,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { "105", NULL },
         { "110", NULL },
         { "115", NULL },
         { "120", NULL },
         { "125", NULL },
         { "130", NULL },
         { "135", NULL },
         { "140", NULL },
         { "145", NULL },
         { "150", NULL },
         { "155", NULL },
         { "160", NULL },
         { "165", NULL },
         { "170", NULL },
         { "175", NULL },
         { "180", NULL },
         { "185", NULL },
         { "190", NULL },
         { "195", NULL },
         { "200", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_cdda_volume",
      GENESIS_PLUS_GX_CDDA_VOLUME_LABEL_EN,
      NULL,
      GENESIS_PLUS_GX_CDDA_VOLUME_INFO_0_EN,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_pcm_volume",
      GENESIS_PLUS_GX_PCM_VOLUME_LABEL_EN,
      NULL,
      GENESIS_PLUS_GX_PCM_VOLUME_INFO_0_EN,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
#ifdef HAVE_EQ
   {
      "genesis_plus_gx_audio_eq_low",
      GENESIS_PLUS_GX_AUDIO_EQ_LOW_LABEL_EN,
      NULL,
      GENESIS_PLUS_GX_AUDIO_EQ_LOW_INFO_0_EN,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_audio_eq_mid",
      GENESIS_PLUS_GX_AUDIO_EQ_MID_LABEL_EN,
      NULL,
      GENESIS_PLUS_GX_AUDIO_EQ_MID_INFO_0_EN,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_audio_eq_high",
      GENESIS_PLUS_GX_AUDIO_EQ_HIGH_LABEL_EN,
      NULL,
      GENESIS_PLUS_GX_AUDIO_EQ_HIGH_INFO_0_EN,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
#endif
   {
      "genesis_plus_gx_gun_input",
      GENESIS_PLUS_GX_GUN_INPUT_LABEL_EN,
      NULL,
      GENESIS_PLUS_GX_GUN_INPUT_INFO_0_EN,
      NULL,
      "input",
      {
         { "lightgun",    OPTION_VAL_LIGHTGUN_EN },
         { "touchscreen", OPTION_VAL_TOUCHSCREEN_EN },
         { NULL, NULL },
      },
      "lightgun"
   },
   {
      "genesis_plus_gx_gun_cursor",
      GENESIS_PLUS_GX_GUN_CURSOR_LABEL_EN,
      NULL,
      GENESIS_PLUS_GX_GUN_CURSOR_INFO_0_EN,
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_invert_mouse",
      GENESIS_PLUS_GX_INVERT_MOUSE_LABEL_EN,
      NULL,
      GENESIS_PLUS_GX_INVERT_MOUSE_INFO_0_EN,
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_no_sprite_limit",
      GENESIS_PLUS_GX_NO_SPRITE_LIMIT_LABEL_EN,
      NULL,
      GENESIS_PLUS_GX_NO_SPRITE_LIMIT_INFO_0_EN,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_enhanced_vscroll",
      GENESIS_PLUS_GX_ENHANCED_VSCROLL_LABEL_EN,
      NULL,
      GENESIS_PLUS_GX_ENHANCED_VSCROLL_INFO_0_EN,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_enhanced_vscroll_limit",
      GENESIS_PLUS_GX_ENHANCED_VSCROLL_LIMIT_LABEL_EN,
      NULL,
      GENESIS_PLUS_GX_ENHANCED_VSCROLL_LIMIT_INFO_0_EN,
      NULL,
      "hacks",
      {
         { "2", NULL },
         { "3",  NULL },
         { "4", NULL },
         { "5",  NULL },
         { "6", NULL },
         { "7",  NULL },
         { "8", NULL },
         { "9",  NULL },
         { "10", NULL },
         { "11",  NULL },
         { "12", NULL },
         { "13",  NULL },
         { "14", NULL },
         { "15",  NULL },
         { "16", NULL },
         { NULL, NULL },
      },
      "8"
   },
#ifdef HAVE_OVERCLOCK
   {
      "genesis_plus_gx_overclock",
      GENESIS_PLUS_GX_OVERCLOCK_LABEL_EN,
      NULL,
      GENESIS_PLUS_GX_OVERCLOCK_INFO_0_EN,
      NULL,
      "hacks",
      {
         { "100", OPTION_VAL_100_EN },
         { "125", OPTION_VAL_125_EN },
         { "150", OPTION_VAL_150_EN },
         { "175", OPTION_VAL_175_EN },
         { "200", OPTION_VAL_200_EN },
         { "225", OPTION_VAL_225_EN },
         { "250", OPTION_VAL_250_EN },
         { "275", OPTION_VAL_275_EN },
         { "300", OPTION_VAL_300_EN },
         { "325", OPTION_VAL_325_EN },
         { "350", OPTION_VAL_350_EN },
         { "375", OPTION_VAL_375_EN },
         { "400", OPTION_VAL_400_EN },
         { "425", OPTION_VAL_425_EN },
         { "450", OPTION_VAL_450_EN },
         { "475", OPTION_VAL_475_EN },
         { "500", OPTION_VAL_500_EN },
         { NULL, NULL },
      },
      "100%"
   },
#endif
   {
      "genesis_plus_gx_force_dtack",
      GENESIS_PLUS_GX_FORCE_DTACK_LABEL_EN,
      NULL,
      GENESIS_PLUS_GX_FORCE_DTACK_INFO_0_EN,
      NULL,
      "hacks",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL },
      },
      "enabled"
   },
   {
      "genesis_plus_gx_addr_error",
      GENESIS_PLUS_GX_ADDR_ERROR_LABEL_EN,
      NULL,
      GENESIS_PLUS_GX_ADDR_ERROR_INFO_0_EN,
      NULL,
      "hacks",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL },
      },
      "enabled"
   },
   {
      "genesis_plus_gx_cd_latency",
      GENESIS_PLUS_GX_CD_LATENCY_LABEL_EN,
      NULL,
      GENESIS_PLUS_GX_CD_LATENCY_INFO_0_EN,
      NULL,
      "hacks",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL },
      },
      "enabled"
   },
   {
      "genesis_plus_gx_cd_precache",
      GENESIS_PLUS_GX_CD_PRECACHE_LABEL_EN,
      NULL,
      GENESIS_PLUS_GX_CD_PRECACHE_INFO_0_EN,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
#ifdef USE_PER_SOUND_CHANNELS_CONFIG
   {
      "genesis_plus_gx_show_advanced_audio_settings",
      GENESIS_PLUS_GX_SHOW_ADVANCED_AUDIO_SETTINGS_LABEL_EN,
      NULL,
      GENESIS_PLUS_GX_SHOW_ADVANCED_AUDIO_SETTINGS_INFO_0_EN,
      NULL,
      "channel_volume",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL},
      },
      "disabled"
   },
   {
      "genesis_plus_gx_psg_channel_0_volume",
      GENESIS_PLUS_GX_PSG_CHANNEL_0_VOLUME_LABEL_EN,
      NULL,
      GENESIS_PLUS_GX_PSG_CHANNEL_0_VOLUME_INFO_0_EN,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_psg_channel_1_volume",
      GENESIS_PLUS_GX_PSG_CHANNEL_1_VOLUME_LABEL_EN,
      NULL,
      GENESIS_PLUS_GX_PSG_CHANNEL_1_VOLUME_INFO_0_EN,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_psg_channel_2_volume",
      GENESIS_PLUS_GX_PSG_CHANNEL_2_VOLUME_LABEL_EN,
      NULL,
      GENESIS_PLUS_GX_PSG_CHANNEL_2_VOLUME_INFO_0_EN,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_psg_channel_3_volume",
      GENESIS_PLUS_GX_PSG_CHANNEL_3_VOLUME_LABEL_EN,
      NULL,
      GENESIS_PLUS_GX_PSG_CHANNEL_3_VOLUME_INFO_0_EN,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_0_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_0_VOLUME_LABEL_EN,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_0_VOLUME_INFO_0_EN,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_1_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_1_VOLUME_LABEL_EN,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_1_VOLUME_INFO_0_EN,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_2_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_2_VOLUME_LABEL_EN,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_2_VOLUME_INFO_0_EN,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_3_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_3_VOLUME_LABEL_EN,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_3_VOLUME_INFO_0_EN,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_4_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_4_VOLUME_LABEL_EN,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_4_VOLUME_INFO_0_EN,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_5_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_5_VOLUME_LABEL_EN,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_5_VOLUME_INFO_0_EN,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_0_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_0_VOLUME_LABEL_EN,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_0_VOLUME_INFO_0_EN,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_1_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_1_VOLUME_LABEL_EN,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_1_VOLUME_INFO_0_EN,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_2_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_2_VOLUME_LABEL_EN,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_2_VOLUME_INFO_0_EN,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_3_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_3_VOLUME_LABEL_EN,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_3_VOLUME_INFO_0_EN,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_4_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_4_VOLUME_LABEL_EN,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_4_VOLUME_INFO_0_EN,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_5_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_5_VOLUME_LABEL_EN,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_5_VOLUME_INFO_0_EN,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_6_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_6_VOLUME_LABEL_EN,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_6_VOLUME_INFO_0_EN,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_7_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_7_VOLUME_LABEL_EN,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_7_VOLUME_INFO_0_EN,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_8_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_8_VOLUME_LABEL_EN,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_8_VOLUME_INFO_0_EN,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
#endif
   { NULL, NULL, NULL, NULL, NULL, NULL, {{0}}, NULL },
};
struct retro_core_options_v2 options_en = {
   option_cats_en,
   option_defs_en
};

/* RETRO_LANGUAGE_EO */

#define CATEGORY_SYSTEM_LABEL_EO NULL
#define CATEGORY_SYSTEM_INFO_0_EO NULL
#define CATEGORY_VIDEO_LABEL_EO "Video Driver"
#define CATEGORY_VIDEO_INFO_0_EO NULL
#define CATEGORY_AUDIO_LABEL_EO "Audio Driver"
#define CATEGORY_AUDIO_INFO_0_EO NULL
#define CATEGORY_INPUT_LABEL_EO "Input Driver"
#define CATEGORY_INPUT_INFO_0_EO NULL
#define CATEGORY_HACKS_LABEL_EO NULL
#define CATEGORY_HACKS_INFO_0_EO NULL
#define CATEGORY_CHANNEL_VOLUME_LABEL_EO NULL
#define CATEGORY_CHANNEL_VOLUME_INFO_0_EO NULL
#define GENESIS_PLUS_GX_SYSTEM_HW_LABEL_EO NULL
#define GENESIS_PLUS_GX_SYSTEM_HW_INFO_0_EO NULL
#define OPTION_VAL_AUTO_EO NULL
#define OPTION_VAL_SG_1000_EO NULL
#define OPTION_VAL_SG_1000_II_EO NULL
#define OPTION_VAL_SG_1000_II_RAM_EXT_EO NULL
#define OPTION_VAL_MARK_III_EO NULL
#define OPTION_VAL_MASTER_SYSTEM_EO NULL
#define OPTION_VAL_MASTER_SYSTEM_II_EO NULL
#define OPTION_VAL_GAME_GEAR_EO NULL
#define OPTION_VAL_MEGA_DRIVE_GENESIS_EO NULL
#define GENESIS_PLUS_GX_REGION_DETECT_LABEL_EO NULL
#define GENESIS_PLUS_GX_REGION_DETECT_INFO_0_EO NULL
#define OPTION_VAL_NTSC_U_EO NULL
#define OPTION_VAL_PAL_EO NULL
#define OPTION_VAL_NTSC_J_EO NULL
#define GENESIS_PLUS_GX_VDP_MODE_LABEL_EO NULL
#define GENESIS_PLUS_GX_VDP_MODE_INFO_0_EO NULL
#define OPTION_VAL_60HZ_EO NULL
#define OPTION_VAL_50HZ_EO NULL
#define GENESIS_PLUS_GX_BIOS_LABEL_EO NULL
#define GENESIS_PLUS_GX_BIOS_INFO_0_EO NULL
#define GENESIS_PLUS_GX_SYSTEM_BRAM_LABEL_EO NULL
#define GENESIS_PLUS_GX_SYSTEM_BRAM_INFO_0_EO NULL
#define OPTION_VAL_PER_BIOS_EO NULL
#define OPTION_VAL_PER_GAME_EO NULL
#define GENESIS_PLUS_GX_CART_BRAM_LABEL_EO NULL
#define GENESIS_PLUS_GX_CART_BRAM_INFO_0_EO NULL
#define OPTION_VAL_PER_CART_EO NULL
#define GENESIS_PLUS_GX_CART_SIZE_LABEL_EO NULL
#define GENESIS_PLUS_GX_CART_SIZE_INFO_0_EO NULL
#define OPTION_VAL_128K_EO NULL
#define OPTION_VAL_256K_EO NULL
#define OPTION_VAL_512K_EO NULL
#define OPTION_VAL_1MEG_EO NULL
#define OPTION_VAL_2MEG_EO NULL
#define OPTION_VAL_4MEG_EO NULL
#define GENESIS_PLUS_GX_ADD_ON_LABEL_EO NULL
#define GENESIS_PLUS_GX_ADD_ON_INFO_0_EO NULL
#define OPTION_VAL_SEGA_MEGA_CD_EO NULL
#define OPTION_VAL_MEGASD_EO NULL
#define OPTION_VAL_NONE_EO NULL
#define GENESIS_PLUS_GX_LOCK_ON_LABEL_EO NULL
#define GENESIS_PLUS_GX_LOCK_ON_INFO_0_EO NULL
#define OPTION_VAL_GAME_GENIE_EO NULL
#define OPTION_VAL_ACTION_REPLAY_PRO_EO NULL
#define OPTION_VAL_SONIC_KNUCKLES_EO NULL
#define GENESIS_PLUS_GX_ASPECT_RATIO_LABEL_EO NULL
#define GENESIS_PLUS_GX_ASPECT_RATIO_INFO_0_EO NULL
#define OPTION_VAL_NTSC_PAR_EO NULL
#define OPTION_VAL_PAL_PAR_EO NULL
#define OPTION_VAL_4_3_EO NULL
#define OPTION_VAL_UNCORRECTED_EO NULL
#define GENESIS_PLUS_GX_OVERSCAN_LABEL_EO NULL
#define GENESIS_PLUS_GX_OVERSCAN_INFO_0_EO NULL
#define OPTION_VAL_TOP_BOTTOM_EO NULL
#define OPTION_VAL_LEFT_RIGHT_EO NULL
#define OPTION_VAL_FULL_EO NULL
#define GENESIS_PLUS_GX_LEFT_BORDER_LABEL_EO NULL
#define GENESIS_PLUS_GX_LEFT_BORDER_INFO_0_EO NULL
#define OPTION_VAL_LEFT_BORDER_EO NULL
#define OPTION_VAL_LEFT_RIGHT_BORDERS_EO NULL
#define GENESIS_PLUS_GX_GG_EXTRA_LABEL_EO NULL
#define GENESIS_PLUS_GX_GG_EXTRA_INFO_0_EO NULL
#define GENESIS_PLUS_GX_BLARGG_NTSC_FILTER_LABEL_EO NULL
#define GENESIS_PLUS_GX_BLARGG_NTSC_FILTER_INFO_0_EO NULL
#define OPTION_VAL_MONOCHROME_EO NULL
#define OPTION_VAL_COMPOSITE_EO NULL
#define OPTION_VAL_SVIDEO_EO NULL
#define OPTION_VAL_RGB_EO NULL
#define GENESIS_PLUS_GX_LCD_FILTER_LABEL_EO NULL
#define GENESIS_PLUS_GX_LCD_FILTER_INFO_0_EO NULL
#define GENESIS_PLUS_GX_RENDER_LABEL_EO NULL
#define GENESIS_PLUS_GX_RENDER_INFO_0_EO NULL
#define OPTION_VAL_SINGLE_FIELD_EO NULL
#define OPTION_VAL_DOUBLE_FIELD_EO NULL
#define GENESIS_PLUS_GX_FRAMESKIP_LABEL_EO NULL
#define GENESIS_PLUS_GX_FRAMESKIP_INFO_0_EO NULL
#define OPTION_VAL_MANUAL_EO NULL
#define GENESIS_PLUS_GX_FRAMESKIP_THRESHOLD_LABEL_EO NULL
#define GENESIS_PLUS_GX_FRAMESKIP_THRESHOLD_INFO_0_EO NULL
#define GENESIS_PLUS_GX_YM2413_LABEL_EO NULL
#define GENESIS_PLUS_GX_YM2413_INFO_0_EO NULL
#define GENESIS_PLUS_GX_YM2413_CORE_LABEL_EO NULL
#define GENESIS_PLUS_GX_YM2413_CORE_INFO_0_EO NULL
#define OPTION_VAL_MAME_EO NULL
#define OPTION_VAL_NUKED_EO NULL
#define GENESIS_PLUS_GX_YM2612_LABEL_EO NULL
#define GENESIS_PLUS_GX_YM2612_INFO_0_EO NULL
#define GENESIS_PLUS_GX_YM2612_INFO_1_EO NULL
#define OPTION_VAL_MAME_YM2612_EO NULL
#define OPTION_VAL_MAME_ASIC_YM3438_EO NULL
#define OPTION_VAL_MAME_ENHANCED_YM3438_EO NULL
#define OPTION_VAL_NUKED_YM2612_EO NULL
#define OPTION_VAL_NUKED_YM3438_EO NULL
#define GENESIS_PLUS_GX_SOUND_OUTPUT_LABEL_EO NULL
#define GENESIS_PLUS_GX_SOUND_OUTPUT_INFO_0_EO NULL
#define OPTION_VAL_STEREO_EO NULL
#define OPTION_VAL_MONO_EO NULL
#define GENESIS_PLUS_GX_AUDIO_FILTER_LABEL_EO NULL
#define GENESIS_PLUS_GX_AUDIO_FILTER_INFO_0_EO NULL
#define OPTION_VAL_LOW_PASS_EO NULL
#define OPTION_VAL_EQ_EO NULL
#define GENESIS_PLUS_GX_LOWPASS_RANGE_LABEL_EO NULL
#define GENESIS_PLUS_GX_LOWPASS_RANGE_INFO_0_EO NULL
#define GENESIS_PLUS_GX_PSG_PREAMP_LABEL_EO NULL
#define GENESIS_PLUS_GX_PSG_PREAMP_INFO_0_EO NULL
#define GENESIS_PLUS_GX_FM_PREAMP_LABEL_EO NULL
#define GENESIS_PLUS_GX_FM_PREAMP_INFO_0_EO NULL
#define GENESIS_PLUS_GX_CDDA_VOLUME_LABEL_EO NULL
#define GENESIS_PLUS_GX_CDDA_VOLUME_INFO_0_EO NULL
#define GENESIS_PLUS_GX_PCM_VOLUME_LABEL_EO NULL
#define GENESIS_PLUS_GX_PCM_VOLUME_INFO_0_EO NULL
#define GENESIS_PLUS_GX_AUDIO_EQ_LOW_LABEL_EO NULL
#define GENESIS_PLUS_GX_AUDIO_EQ_LOW_INFO_0_EO NULL
#define GENESIS_PLUS_GX_AUDIO_EQ_MID_LABEL_EO NULL
#define GENESIS_PLUS_GX_AUDIO_EQ_MID_INFO_0_EO NULL
#define GENESIS_PLUS_GX_AUDIO_EQ_HIGH_LABEL_EO NULL
#define GENESIS_PLUS_GX_AUDIO_EQ_HIGH_INFO_0_EO NULL
#define GENESIS_PLUS_GX_GUN_INPUT_LABEL_EO NULL
#define GENESIS_PLUS_GX_GUN_INPUT_INFO_0_EO NULL
#define OPTION_VAL_LIGHTGUN_EO NULL
#define OPTION_VAL_TOUCHSCREEN_EO NULL
#define GENESIS_PLUS_GX_GUN_CURSOR_LABEL_EO NULL
#define GENESIS_PLUS_GX_GUN_CURSOR_INFO_0_EO NULL
#define GENESIS_PLUS_GX_INVERT_MOUSE_LABEL_EO NULL
#define GENESIS_PLUS_GX_INVERT_MOUSE_INFO_0_EO NULL
#define GENESIS_PLUS_GX_NO_SPRITE_LIMIT_LABEL_EO NULL
#define GENESIS_PLUS_GX_NO_SPRITE_LIMIT_INFO_0_EO NULL
#define GENESIS_PLUS_GX_ENHANCED_VSCROLL_LABEL_EO NULL
#define GENESIS_PLUS_GX_ENHANCED_VSCROLL_INFO_0_EO NULL
#define GENESIS_PLUS_GX_ENHANCED_VSCROLL_LIMIT_LABEL_EO NULL
#define GENESIS_PLUS_GX_ENHANCED_VSCROLL_LIMIT_INFO_0_EO NULL
#define GENESIS_PLUS_GX_OVERCLOCK_LABEL_EO NULL
#define GENESIS_PLUS_GX_OVERCLOCK_INFO_0_EO NULL
#define OPTION_VAL_100_EO NULL
#define OPTION_VAL_125_EO NULL
#define OPTION_VAL_150_EO NULL
#define OPTION_VAL_175_EO NULL
#define OPTION_VAL_200_EO NULL
#define OPTION_VAL_225_EO "225 %"
#define OPTION_VAL_250_EO "250 %"
#define OPTION_VAL_275_EO "275 %"
#define OPTION_VAL_300_EO "300 %"
#define OPTION_VAL_325_EO "325 %"
#define OPTION_VAL_350_EO "350 %"
#define OPTION_VAL_375_EO "375 %"
#define OPTION_VAL_400_EO "400 %"
#define OPTION_VAL_425_EO "425 %"
#define OPTION_VAL_450_EO "450 %"
#define OPTION_VAL_475_EO "475 %"
#define OPTION_VAL_500_EO "500 %"
#define GENESIS_PLUS_GX_FORCE_DTACK_LABEL_EO NULL
#define GENESIS_PLUS_GX_FORCE_DTACK_INFO_0_EO NULL
#define GENESIS_PLUS_GX_ADDR_ERROR_LABEL_EO NULL
#define GENESIS_PLUS_GX_ADDR_ERROR_INFO_0_EO NULL
#define GENESIS_PLUS_GX_CD_LATENCY_LABEL_EO NULL
#define GENESIS_PLUS_GX_CD_LATENCY_INFO_0_EO NULL
#define GENESIS_PLUS_GX_CD_PRECACHE_LABEL_EO NULL
#define GENESIS_PLUS_GX_CD_PRECACHE_INFO_0_EO NULL
#define GENESIS_PLUS_GX_SHOW_ADVANCED_AUDIO_SETTINGS_LABEL_EO NULL
#define GENESIS_PLUS_GX_SHOW_ADVANCED_AUDIO_SETTINGS_INFO_0_EO NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_0_VOLUME_LABEL_EO NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_0_VOLUME_INFO_0_EO NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_1_VOLUME_LABEL_EO NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_1_VOLUME_INFO_0_EO NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_2_VOLUME_LABEL_EO NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_2_VOLUME_INFO_0_EO NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_3_VOLUME_LABEL_EO NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_3_VOLUME_INFO_0_EO NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_0_VOLUME_LABEL_EO NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_0_VOLUME_INFO_0_EO NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_1_VOLUME_LABEL_EO NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_1_VOLUME_INFO_0_EO NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_2_VOLUME_LABEL_EO NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_2_VOLUME_INFO_0_EO NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_3_VOLUME_LABEL_EO NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_3_VOLUME_INFO_0_EO NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_4_VOLUME_LABEL_EO NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_4_VOLUME_INFO_0_EO NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_5_VOLUME_LABEL_EO NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_5_VOLUME_INFO_0_EO NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_0_VOLUME_LABEL_EO NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_0_VOLUME_INFO_0_EO NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_1_VOLUME_LABEL_EO NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_1_VOLUME_INFO_0_EO NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_2_VOLUME_LABEL_EO NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_2_VOLUME_INFO_0_EO NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_3_VOLUME_LABEL_EO NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_3_VOLUME_INFO_0_EO NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_4_VOLUME_LABEL_EO NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_4_VOLUME_INFO_0_EO NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_5_VOLUME_LABEL_EO NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_5_VOLUME_INFO_0_EO NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_6_VOLUME_LABEL_EO NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_6_VOLUME_INFO_0_EO NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_7_VOLUME_LABEL_EO NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_7_VOLUME_INFO_0_EO NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_8_VOLUME_LABEL_EO NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_8_VOLUME_INFO_0_EO NULL

struct retro_core_option_v2_category option_cats_eo[] = {
   {
      "system",
      CATEGORY_SYSTEM_LABEL_EO,
      CATEGORY_SYSTEM_INFO_0_EO
   },
   {
      "video",
      CATEGORY_VIDEO_LABEL_EO,
      CATEGORY_VIDEO_INFO_0_EO
   },
   {
      "audio",
      CATEGORY_AUDIO_LABEL_EO,
      CATEGORY_AUDIO_INFO_0_EO
   },
   {
      "input",
      CATEGORY_INPUT_LABEL_EO,
      CATEGORY_INPUT_INFO_0_EO
   },
   {
      "hacks",
      CATEGORY_HACKS_LABEL_EO,
      CATEGORY_HACKS_INFO_0_EO
   },
   {
      "channel_volume",
      CATEGORY_CHANNEL_VOLUME_LABEL_EO,
      CATEGORY_CHANNEL_VOLUME_INFO_0_EO
   },
   { NULL, NULL, NULL },
};
struct retro_core_option_v2_definition option_defs_eo[] = {
   {
      "genesis_plus_gx_system_hw",
      GENESIS_PLUS_GX_SYSTEM_HW_LABEL_EO,
      NULL,
      GENESIS_PLUS_GX_SYSTEM_HW_INFO_0_EO,
      NULL,
      "system",
      {
         { "auto",                 OPTION_VAL_AUTO_EO                 },
         { "sg-1000",              OPTION_VAL_SG_1000_EO              },
         { "sg-1000 II",           OPTION_VAL_SG_1000_II_EO           },
         { "sg-1000 II + ram ext.",OPTION_VAL_SG_1000_II_RAM_EXT_EO},
         { "mark-III",             OPTION_VAL_MARK_III_EO             },
         { "master system",        OPTION_VAL_MASTER_SYSTEM_EO        },
         { "master system II",     OPTION_VAL_MASTER_SYSTEM_II_EO     },
         { "game gear",            OPTION_VAL_GAME_GEAR_EO            },
         { "mega drive / genesis", OPTION_VAL_MEGA_DRIVE_GENESIS_EO   },
         { NULL, NULL },
      },
      "auto"
   },
   {
      "genesis_plus_gx_region_detect",
      GENESIS_PLUS_GX_REGION_DETECT_LABEL_EO,
      NULL,
      GENESIS_PLUS_GX_REGION_DETECT_INFO_0_EO,
      NULL,
      "system",
      {
         { "auto",    OPTION_VAL_AUTO_EO   },
         { "ntsc-u",  OPTION_VAL_NTSC_U_EO },
         { "pal",     OPTION_VAL_PAL_EO    },
         { "ntsc-j",  OPTION_VAL_NTSC_J_EO },
         { NULL, NULL },
      },
      "auto"
   },
   {
      "genesis_plus_gx_vdp_mode",
      GENESIS_PLUS_GX_VDP_MODE_LABEL_EO,
      NULL,
      GENESIS_PLUS_GX_VDP_MODE_INFO_0_EO,
      NULL,
      "system",
      {
         { "auto",  "Disabled" },
         { "60hz",  OPTION_VAL_60HZ_EO },
         { "50hz",  OPTION_VAL_50HZ_EO },
         { NULL, NULL },
      },
      "auto"
   },
   {
      "genesis_plus_gx_bios",
      GENESIS_PLUS_GX_BIOS_LABEL_EO,
      NULL,
      GENESIS_PLUS_GX_BIOS_INFO_0_EO,
      NULL,
      "system",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_system_bram",
      GENESIS_PLUS_GX_SYSTEM_BRAM_LABEL_EO,
      NULL,
      GENESIS_PLUS_GX_SYSTEM_BRAM_INFO_0_EO,
      NULL,
      "system",
      {
         { "per bios", OPTION_VAL_PER_BIOS_EO },
         { "per game", OPTION_VAL_PER_GAME_EO },
         { NULL, NULL },
      },
      "per bios"
   },
   {
      "genesis_plus_gx_cart_bram",
      GENESIS_PLUS_GX_CART_BRAM_LABEL_EO,
      NULL,
      GENESIS_PLUS_GX_CART_BRAM_INFO_0_EO,
      NULL,
      "system",
      {
         { "per cart", OPTION_VAL_PER_CART_EO },
         { "per game", OPTION_VAL_PER_GAME_EO },
         { NULL, NULL },
      },
      "per cart"
   },
   {
      "genesis_plus_gx_cart_size",
      GENESIS_PLUS_GX_CART_SIZE_LABEL_EO,
      NULL,
      GENESIS_PLUS_GX_CART_SIZE_INFO_0_EO,
      NULL,
      "system",
      {
         { "disabled", "Disabled" },
         { "128k",     OPTION_VAL_128K_EO  },
         { "256k",     OPTION_VAL_256K_EO  },
         { "512k",     OPTION_VAL_512K_EO  },
         { "1meg",     OPTION_VAL_1MEG_EO    },
         { "2meg",     OPTION_VAL_2MEG_EO    },
         { "4meg",     OPTION_VAL_4MEG_EO    },
         { NULL, NULL },
      },
      "4meg"
   },
   {
      "genesis_plus_gx_add_on",
      GENESIS_PLUS_GX_ADD_ON_LABEL_EO,
      NULL,
      GENESIS_PLUS_GX_ADD_ON_INFO_0_EO,
      NULL,
      "system",
      {
         { "auto",         OPTION_VAL_AUTO_EO },
         { "sega/mega cd", OPTION_VAL_SEGA_MEGA_CD_EO },
         { "megasd",       OPTION_VAL_MEGASD_EO },
         { "none",         OPTION_VAL_NONE_EO },
         { NULL, NULL },
      },
      "auto"
   },
   {
      "genesis_plus_gx_lock_on",
      GENESIS_PLUS_GX_LOCK_ON_LABEL_EO,
      NULL,
      GENESIS_PLUS_GX_LOCK_ON_INFO_0_EO,
      NULL,
      "system",
      {
         { "disabled",            NULL },
         { "game genie",          OPTION_VAL_GAME_GENIE_EO },
         { "action replay (pro)", OPTION_VAL_ACTION_REPLAY_PRO_EO },
         { "sonic & knuckles",    OPTION_VAL_SONIC_KNUCKLES_EO },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_aspect_ratio",
      GENESIS_PLUS_GX_ASPECT_RATIO_LABEL_EO,
      NULL,
      GENESIS_PLUS_GX_ASPECT_RATIO_INFO_0_EO,
      NULL,
      "video",
      {
         { "auto",     OPTION_VAL_AUTO_EO },
         { "NTSC PAR", OPTION_VAL_NTSC_PAR_EO },
         { "PAL PAR",  OPTION_VAL_PAL_PAR_EO },
         { "4:3",  OPTION_VAL_4_3_EO },
         { "Uncorrected",  OPTION_VAL_UNCORRECTED_EO },
      },
      "auto"
   },
   {
      "genesis_plus_gx_overscan",
      GENESIS_PLUS_GX_OVERSCAN_LABEL_EO,
      NULL,
      GENESIS_PLUS_GX_OVERSCAN_INFO_0_EO,
      NULL,
      "video",
      {
         { "disabled",   NULL },
         { "top/bottom", OPTION_VAL_TOP_BOTTOM_EO },
         { "left/right", OPTION_VAL_LEFT_RIGHT_EO },
         { "full",       OPTION_VAL_FULL_EO },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_left_border",
      GENESIS_PLUS_GX_LEFT_BORDER_LABEL_EO,
      NULL,
      GENESIS_PLUS_GX_LEFT_BORDER_INFO_0_EO,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "left border", OPTION_VAL_LEFT_BORDER_EO },
         { "left & right borders", OPTION_VAL_LEFT_RIGHT_BORDERS_EO },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_gg_extra",
      GENESIS_PLUS_GX_GG_EXTRA_LABEL_EO,
      NULL,
      GENESIS_PLUS_GX_GG_EXTRA_INFO_0_EO,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_blargg_ntsc_filter",
      GENESIS_PLUS_GX_BLARGG_NTSC_FILTER_LABEL_EO,
      NULL,
      GENESIS_PLUS_GX_BLARGG_NTSC_FILTER_INFO_0_EO,
      NULL,
      "video",
      {
         { "disabled",   NULL },
         { "monochrome", OPTION_VAL_MONOCHROME_EO },
         { "composite",  OPTION_VAL_COMPOSITE_EO },
         { "svideo",     OPTION_VAL_SVIDEO_EO },
         { "rgb",        OPTION_VAL_RGB_EO },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_lcd_filter",
      GENESIS_PLUS_GX_LCD_FILTER_LABEL_EO,
      NULL,
      GENESIS_PLUS_GX_LCD_FILTER_INFO_0_EO,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_render",
      GENESIS_PLUS_GX_RENDER_LABEL_EO,
      NULL,
      GENESIS_PLUS_GX_RENDER_INFO_0_EO,
      NULL,
      "video",
      {
         { "single field", OPTION_VAL_SINGLE_FIELD_EO },
         { "double field", OPTION_VAL_DOUBLE_FIELD_EO },
         { NULL, NULL },
      },
      "single field"
   },
   {
      "genesis_plus_gx_frameskip",
      GENESIS_PLUS_GX_FRAMESKIP_LABEL_EO,
      NULL,
      GENESIS_PLUS_GX_FRAMESKIP_INFO_0_EO,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "auto",     OPTION_VAL_AUTO_EO },
         { "manual",   OPTION_VAL_MANUAL_EO },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_frameskip_threshold",
      GENESIS_PLUS_GX_FRAMESKIP_THRESHOLD_LABEL_EO,
      NULL,
      GENESIS_PLUS_GX_FRAMESKIP_THRESHOLD_INFO_0_EO,
      NULL,
      "video",
      {
         { "15", NULL },
         { "18", NULL },
         { "21", NULL },
         { "24", NULL },
         { "27", NULL },
         { "30", NULL },
         { "33", NULL },
         { "36", NULL },
         { "39", NULL },
         { "42", NULL },
         { "45", NULL },
         { "48", NULL },
         { "51", NULL },
         { "54", NULL },
         { "57", NULL },
         { "60", NULL },
         { NULL, NULL },
      },
      "33"
   },
   {
      "genesis_plus_gx_ym2413",
      GENESIS_PLUS_GX_YM2413_LABEL_EO,
      NULL,
      GENESIS_PLUS_GX_YM2413_INFO_0_EO,
      NULL,
      "audio",
      {
         { "auto",     OPTION_VAL_AUTO_EO },
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "auto"
   },
#ifdef HAVE_OPLL_CORE
   {
      "genesis_plus_gx_ym2413_core",
      GENESIS_PLUS_GX_YM2413_CORE_LABEL_EO,
      NULL,
      GENESIS_PLUS_GX_YM2413_CORE_INFO_0_EO,
      NULL,
      "audio",
      {
         { "mame",  OPTION_VAL_MAME_EO },
         { "nuked", OPTION_VAL_NUKED_EO },
         { NULL, NULL },
      },
      "mame"
   },
#endif
   {
      "genesis_plus_gx_ym2612",
      GENESIS_PLUS_GX_YM2612_LABEL_EO,
      NULL,
#ifdef HAVE_YM3438_CORE
      GENESIS_PLUS_GX_YM2612_INFO_0_EO,
#else
      GENESIS_PLUS_GX_YM2612_INFO_1_EO,
#endif
      NULL,
      "audio",
      {
         { "mame (ym2612)",          OPTION_VAL_MAME_YM2612_EO },
         { "mame (asic ym3438)",     OPTION_VAL_MAME_ASIC_YM3438_EO },
         { "mame (enhanced ym3438)", OPTION_VAL_MAME_ENHANCED_YM3438_EO },
#ifdef HAVE_YM3438_CORE
         { "nuked (ym2612)",         OPTION_VAL_NUKED_YM2612_EO },
         { "nuked (ym3438)",         OPTION_VAL_NUKED_YM3438_EO },
#endif
         { NULL, NULL },
      },
      "mame (ym2612)"
   },
   {
      "genesis_plus_gx_sound_output",
      GENESIS_PLUS_GX_SOUND_OUTPUT_LABEL_EO,
      NULL,
      GENESIS_PLUS_GX_SOUND_OUTPUT_INFO_0_EO,
      NULL,
      "audio",
      {
         { "stereo", OPTION_VAL_STEREO_EO },
         { "mono",   OPTION_VAL_MONO_EO },
         { NULL, NULL },
      },
      "stereo"
   },
   {
      "genesis_plus_gx_audio_filter",
      GENESIS_PLUS_GX_AUDIO_FILTER_LABEL_EO,
      NULL,
      GENESIS_PLUS_GX_AUDIO_FILTER_INFO_0_EO,
      NULL,
      "audio",
      {
         { "disabled", NULL },
         { "low-pass", OPTION_VAL_LOW_PASS_EO },
#ifdef HAVE_EQ
         { "EQ",       OPTION_VAL_EQ_EO },
#endif
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_lowpass_range",
      GENESIS_PLUS_GX_LOWPASS_RANGE_LABEL_EO,
      NULL,
      GENESIS_PLUS_GX_LOWPASS_RANGE_INFO_0_EO,
      NULL,
      "audio",
      {
         { "5",  NULL },
         { "10", NULL },
         { "15", NULL },
         { "20", NULL },
         { "25", NULL },
         { "30", NULL },
         { "35", NULL },
         { "40", NULL },
         { "45", NULL },
         { "50", NULL },
         { "55", NULL },
         { "60", NULL },
         { "65", NULL },
         { "70", NULL },
         { "75", NULL },
         { "80", NULL },
         { "85", NULL },
         { "90", NULL },
         { "95", NULL },
         { NULL, NULL },
      },
      "60"
   },
   {
      "genesis_plus_gx_psg_preamp",
      GENESIS_PLUS_GX_PSG_PREAMP_LABEL_EO,
      NULL,
      GENESIS_PLUS_GX_PSG_PREAMP_INFO_0_EO,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { "105", NULL },
         { "110", NULL },
         { "115", NULL },
         { "120", NULL },
         { "125", NULL },
         { "130", NULL },
         { "135", NULL },
         { "140", NULL },
         { "145", NULL },
         { "150", NULL },
         { "155", NULL },
         { "160", NULL },
         { "165", NULL },
         { "170", NULL },
         { "175", NULL },
         { "180", NULL },
         { "185", NULL },
         { "190", NULL },
         { "195", NULL },
         { "200", NULL },
         { NULL, NULL },
      },
      "150"
   },
   {
      "genesis_plus_gx_fm_preamp",
      GENESIS_PLUS_GX_FM_PREAMP_LABEL_EO,
      NULL,
      GENESIS_PLUS_GX_FM_PREAMP_INFO_0_EO,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { "105", NULL },
         { "110", NULL },
         { "115", NULL },
         { "120", NULL },
         { "125", NULL },
         { "130", NULL },
         { "135", NULL },
         { "140", NULL },
         { "145", NULL },
         { "150", NULL },
         { "155", NULL },
         { "160", NULL },
         { "165", NULL },
         { "170", NULL },
         { "175", NULL },
         { "180", NULL },
         { "185", NULL },
         { "190", NULL },
         { "195", NULL },
         { "200", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_cdda_volume",
      GENESIS_PLUS_GX_CDDA_VOLUME_LABEL_EO,
      NULL,
      GENESIS_PLUS_GX_CDDA_VOLUME_INFO_0_EO,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_pcm_volume",
      GENESIS_PLUS_GX_PCM_VOLUME_LABEL_EO,
      NULL,
      GENESIS_PLUS_GX_PCM_VOLUME_INFO_0_EO,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
#ifdef HAVE_EQ
   {
      "genesis_plus_gx_audio_eq_low",
      GENESIS_PLUS_GX_AUDIO_EQ_LOW_LABEL_EO,
      NULL,
      GENESIS_PLUS_GX_AUDIO_EQ_LOW_INFO_0_EO,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_audio_eq_mid",
      GENESIS_PLUS_GX_AUDIO_EQ_MID_LABEL_EO,
      NULL,
      GENESIS_PLUS_GX_AUDIO_EQ_MID_INFO_0_EO,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_audio_eq_high",
      GENESIS_PLUS_GX_AUDIO_EQ_HIGH_LABEL_EO,
      NULL,
      GENESIS_PLUS_GX_AUDIO_EQ_HIGH_INFO_0_EO,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
#endif
   {
      "genesis_plus_gx_gun_input",
      GENESIS_PLUS_GX_GUN_INPUT_LABEL_EO,
      NULL,
      GENESIS_PLUS_GX_GUN_INPUT_INFO_0_EO,
      NULL,
      "input",
      {
         { "lightgun",    OPTION_VAL_LIGHTGUN_EO },
         { "touchscreen", OPTION_VAL_TOUCHSCREEN_EO },
         { NULL, NULL },
      },
      "lightgun"
   },
   {
      "genesis_plus_gx_gun_cursor",
      GENESIS_PLUS_GX_GUN_CURSOR_LABEL_EO,
      NULL,
      GENESIS_PLUS_GX_GUN_CURSOR_INFO_0_EO,
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_invert_mouse",
      GENESIS_PLUS_GX_INVERT_MOUSE_LABEL_EO,
      NULL,
      GENESIS_PLUS_GX_INVERT_MOUSE_INFO_0_EO,
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_no_sprite_limit",
      GENESIS_PLUS_GX_NO_SPRITE_LIMIT_LABEL_EO,
      NULL,
      GENESIS_PLUS_GX_NO_SPRITE_LIMIT_INFO_0_EO,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_enhanced_vscroll",
      GENESIS_PLUS_GX_ENHANCED_VSCROLL_LABEL_EO,
      NULL,
      GENESIS_PLUS_GX_ENHANCED_VSCROLL_INFO_0_EO,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_enhanced_vscroll_limit",
      GENESIS_PLUS_GX_ENHANCED_VSCROLL_LIMIT_LABEL_EO,
      NULL,
      GENESIS_PLUS_GX_ENHANCED_VSCROLL_LIMIT_INFO_0_EO,
      NULL,
      "hacks",
      {
         { "2", NULL },
         { "3",  NULL },
         { "4", NULL },
         { "5",  NULL },
         { "6", NULL },
         { "7",  NULL },
         { "8", NULL },
         { "9",  NULL },
         { "10", NULL },
         { "11",  NULL },
         { "12", NULL },
         { "13",  NULL },
         { "14", NULL },
         { "15",  NULL },
         { "16", NULL },
         { NULL, NULL },
      },
      "8"
   },
#ifdef HAVE_OVERCLOCK
   {
      "genesis_plus_gx_overclock",
      GENESIS_PLUS_GX_OVERCLOCK_LABEL_EO,
      NULL,
      GENESIS_PLUS_GX_OVERCLOCK_INFO_0_EO,
      NULL,
      "hacks",
      {
         { "100", OPTION_VAL_100_EO },
         { "125", OPTION_VAL_125_EO },
         { "150", OPTION_VAL_150_EO },
         { "175", OPTION_VAL_175_EO },
         { "200", OPTION_VAL_200_EO },
         { "225", OPTION_VAL_225_EO },
         { "250", OPTION_VAL_250_EO },
         { "275", OPTION_VAL_275_EO },
         { "300", OPTION_VAL_300_EO },
         { "325", OPTION_VAL_325_EO },
         { "350", OPTION_VAL_350_EO },
         { "375", OPTION_VAL_375_EO },
         { "400", OPTION_VAL_400_EO },
         { "425", OPTION_VAL_425_EO },
         { "450", OPTION_VAL_450_EO },
         { "475", OPTION_VAL_475_EO },
         { "500", OPTION_VAL_500_EO },
         { NULL, NULL },
      },
      "100%"
   },
#endif
   {
      "genesis_plus_gx_force_dtack",
      GENESIS_PLUS_GX_FORCE_DTACK_LABEL_EO,
      NULL,
      GENESIS_PLUS_GX_FORCE_DTACK_INFO_0_EO,
      NULL,
      "hacks",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL },
      },
      "enabled"
   },
   {
      "genesis_plus_gx_addr_error",
      GENESIS_PLUS_GX_ADDR_ERROR_LABEL_EO,
      NULL,
      GENESIS_PLUS_GX_ADDR_ERROR_INFO_0_EO,
      NULL,
      "hacks",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL },
      },
      "enabled"
   },
   {
      "genesis_plus_gx_cd_latency",
      GENESIS_PLUS_GX_CD_LATENCY_LABEL_EO,
      NULL,
      GENESIS_PLUS_GX_CD_LATENCY_INFO_0_EO,
      NULL,
      "hacks",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL },
      },
      "enabled"
   },
   {
      "genesis_plus_gx_cd_precache",
      GENESIS_PLUS_GX_CD_PRECACHE_LABEL_EO,
      NULL,
      GENESIS_PLUS_GX_CD_PRECACHE_INFO_0_EO,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
#ifdef USE_PER_SOUND_CHANNELS_CONFIG
   {
      "genesis_plus_gx_show_advanced_audio_settings",
      GENESIS_PLUS_GX_SHOW_ADVANCED_AUDIO_SETTINGS_LABEL_EO,
      NULL,
      GENESIS_PLUS_GX_SHOW_ADVANCED_AUDIO_SETTINGS_INFO_0_EO,
      NULL,
      "channel_volume",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL},
      },
      "disabled"
   },
   {
      "genesis_plus_gx_psg_channel_0_volume",
      GENESIS_PLUS_GX_PSG_CHANNEL_0_VOLUME_LABEL_EO,
      NULL,
      GENESIS_PLUS_GX_PSG_CHANNEL_0_VOLUME_INFO_0_EO,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_psg_channel_1_volume",
      GENESIS_PLUS_GX_PSG_CHANNEL_1_VOLUME_LABEL_EO,
      NULL,
      GENESIS_PLUS_GX_PSG_CHANNEL_1_VOLUME_INFO_0_EO,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_psg_channel_2_volume",
      GENESIS_PLUS_GX_PSG_CHANNEL_2_VOLUME_LABEL_EO,
      NULL,
      GENESIS_PLUS_GX_PSG_CHANNEL_2_VOLUME_INFO_0_EO,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_psg_channel_3_volume",
      GENESIS_PLUS_GX_PSG_CHANNEL_3_VOLUME_LABEL_EO,
      NULL,
      GENESIS_PLUS_GX_PSG_CHANNEL_3_VOLUME_INFO_0_EO,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_0_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_0_VOLUME_LABEL_EO,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_0_VOLUME_INFO_0_EO,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_1_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_1_VOLUME_LABEL_EO,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_1_VOLUME_INFO_0_EO,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_2_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_2_VOLUME_LABEL_EO,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_2_VOLUME_INFO_0_EO,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_3_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_3_VOLUME_LABEL_EO,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_3_VOLUME_INFO_0_EO,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_4_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_4_VOLUME_LABEL_EO,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_4_VOLUME_INFO_0_EO,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_5_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_5_VOLUME_LABEL_EO,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_5_VOLUME_INFO_0_EO,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_0_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_0_VOLUME_LABEL_EO,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_0_VOLUME_INFO_0_EO,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_1_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_1_VOLUME_LABEL_EO,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_1_VOLUME_INFO_0_EO,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_2_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_2_VOLUME_LABEL_EO,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_2_VOLUME_INFO_0_EO,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_3_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_3_VOLUME_LABEL_EO,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_3_VOLUME_INFO_0_EO,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_4_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_4_VOLUME_LABEL_EO,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_4_VOLUME_INFO_0_EO,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_5_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_5_VOLUME_LABEL_EO,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_5_VOLUME_INFO_0_EO,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_6_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_6_VOLUME_LABEL_EO,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_6_VOLUME_INFO_0_EO,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_7_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_7_VOLUME_LABEL_EO,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_7_VOLUME_INFO_0_EO,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_8_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_8_VOLUME_LABEL_EO,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_8_VOLUME_INFO_0_EO,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
#endif
   { NULL, NULL, NULL, NULL, NULL, NULL, {{0}}, NULL },
};
struct retro_core_options_v2 options_eo = {
   option_cats_eo,
   option_defs_eo
};

/* RETRO_LANGUAGE_ES */

#define CATEGORY_SYSTEM_LABEL_ES "Sistema"
#define CATEGORY_SYSTEM_INFO_0_ES "Cambia las opciones del hardware base, la región, su BIOS y el archivo de guardado de Sega CD/Mega-CD."
#define CATEGORY_VIDEO_LABEL_ES "Vídeo"
#define CATEGORY_VIDEO_INFO_0_ES "Cambia las opciones de relación de aspecto, recorte de imagen, filtros de vídeo y omisión de fotogramas."
#define CATEGORY_AUDIO_LABEL_ES NULL
#define CATEGORY_AUDIO_INFO_0_ES "Cambia los ajustes de los dispositivos de audio."
#define CATEGORY_INPUT_LABEL_ES "Entrada"
#define CATEGORY_INPUT_INFO_0_ES "Cambia las opciones de las pistolas de luz o la entrada del ratón."
#define CATEGORY_HACKS_LABEL_ES "Arreglos de emulación"
#define CATEGORY_HACKS_INFO_0_ES "Cambia las opciones de velocidad del procesador y de precisión de la emulación que afectan al rendimiento a bajo nivel y a la compatibilidad."
#define CATEGORY_CHANNEL_VOLUME_LABEL_ES "Ajustes avanzados del volumen de los canales"
#define CATEGORY_CHANNEL_VOLUME_INFO_0_ES "Cambia el volumen de los canales individuales de audio del hardware."
#define GENESIS_PLUS_GX_SYSTEM_HW_LABEL_ES "Hardware del sistema"
#define GENESIS_PLUS_GX_SYSTEM_HW_INFO_0_ES "Ejecuta el contenido cargado utilizando una consola emulada concreta. «Selección automática» seleccionará el sistema más adecuado para cada juego."
#define OPTION_VAL_AUTO_ES "Automático"
#define OPTION_VAL_SG_1000_ES NULL
#define OPTION_VAL_SG_1000_II_ES NULL
#define OPTION_VAL_SG_1000_II_RAM_EXT_ES "SG-1000 II + expansión de RAM"
#define OPTION_VAL_MARK_III_ES NULL
#define OPTION_VAL_MASTER_SYSTEM_ES NULL
#define OPTION_VAL_MASTER_SYSTEM_II_ES NULL
#define OPTION_VAL_GAME_GEAR_ES NULL
#define OPTION_VAL_MEGA_DRIVE_GENESIS_ES NULL
#define GENESIS_PLUS_GX_REGION_DETECT_LABEL_ES "Región del sistema"
#define GENESIS_PLUS_GX_REGION_DETECT_INFO_0_ES "Especifica la región para la que se ha fabricado el sistema. A excepción de la Game Gear, la opción PAL hará que las consolas muestren una imagen a 50 Hz, mientras que las opciones NTSC la mostrarán a 60 Hz. Si seleccionas una región incorrecta, los juegos podrían ejecutarse más rápidos o lentos de lo normal."
#define OPTION_VAL_NTSC_U_ES NULL
#define OPTION_VAL_PAL_ES NULL
#define OPTION_VAL_NTSC_J_ES NULL
#define GENESIS_PLUS_GX_VDP_MODE_LABEL_ES "Forzar modo del VDP"
#define GENESIS_PLUS_GX_VDP_MODE_INFO_0_ES "Reemplaza el modo del VDP para obligarlo a ejecutarse en el modo NTSC a 60 Hz o PAL a 50 Hz sin importar la región del sistema."
#define OPTION_VAL_60HZ_ES "NTSC (60 Hz)"
#define OPTION_VAL_50HZ_ES "PAL (50 Hz)"
#define GENESIS_PLUS_GX_BIOS_LABEL_ES "ROM de arranque del sistema"
#define GENESIS_PLUS_GX_BIOS_INFO_0_ES "Utiliza un cargador de arranque o BIOS oficiales para la emulación si se encuentran en el directorio del sistema de RetroArch. Se mostrará la secuencia específica de inicio de la consola y luego se ejecutará el contenido cargado."
#define GENESIS_PLUS_GX_SYSTEM_BRAM_LABEL_ES "BRAM del sistema de CD (es necesario reiniciar)"
#define GENESIS_PLUS_GX_SYSTEM_BRAM_INFO_0_ES "Al ejecutar contenidos para Mega-CD/Sega CD, especifica si se debe compartir un archivo de guardado entre todos los juegos de la misma región («Una por BIOS») o si se debe crear un archivo de guardado individual para cada juego («Una por cada juego»). Nota: la Mega-CD/Sega CD tiene un almacenamiento interno limitado, suficiente para unos pocos títulos. Se recomienda seleccionar «Una por cada juego» para que no te quedes sin espacio libre."
#define OPTION_VAL_PER_BIOS_ES "Uno por BIOS"
#define OPTION_VAL_PER_GAME_ES "Uno por cada juego"
#define GENESIS_PLUS_GX_CART_BRAM_LABEL_ES "Cartucho de BRAM de CD (es necesario reiniciar)"
#define GENESIS_PLUS_GX_CART_BRAM_INFO_0_ES "Al ejecutar contenidos para Mega-CD/Sega CD, especifica si se debe compartir un cartucho de RAM para guardados entre todos los juegos de la misma región («Una por cartucho») o si se debe crear un archivo de guardado individual para cada juego («Una por cada juego»)."
#define OPTION_VAL_PER_CART_ES "Una por cartucho"
#define GENESIS_PLUS_GX_CART_SIZE_LABEL_ES "Tamaño del cartucho de BRAM de CD (es necesario reiniciar)"
#define GENESIS_PLUS_GX_CART_SIZE_INFO_0_ES "Establece el tamaño del cartucho de RAM para los contenidos de Sega CD/Mega-CD. Este ajuste es ideal si se utiliza un archivo de cartucho de RAM por cada juego para así no tener varios cartuchos de gran tamaño."
#define OPTION_VAL_128K_ES "128 Kbit"
#define OPTION_VAL_256K_ES "256 Kbit"
#define OPTION_VAL_512K_ES "512 Kbit"
#define OPTION_VAL_1MEG_ES "1 Mbit"
#define OPTION_VAL_2MEG_ES "2 Mbit"
#define OPTION_VAL_4MEG_ES "4 Mbit"
#define GENESIS_PLUS_GX_ADD_ON_LABEL_ES "Módulo de CD (modo MD, es necesario reiniciar)"
#define GENESIS_PLUS_GX_ADD_ON_INFO_0_ES "Especifica el módulo que se ha de utilizar para la reproducción de audio de CD en los juegos compatibles de Mega Drive/Genesis."
#define OPTION_VAL_SEGA_MEGA_CD_ES "Sega CD/Mega-CD"
#define OPTION_VAL_MEGASD_ES NULL
#define OPTION_VAL_NONE_ES "No compartir"
#define GENESIS_PLUS_GX_LOCK_ON_LABEL_ES "Lock-On/Ensamblaje entre cartuchos"
#define GENESIS_PLUS_GX_LOCK_ON_INFO_0_ES "La tecnología Lock-On/de ensamblaje es una característica de Mega Drive/Genesis que permitía a un juego antiguo conectarse a la ranura de un cartucho especial para alterar o ampliar su contenido. Esta opción especifica el tipo concreto de ensamblaje o «Lock-On» emulado. Es necesario incluir el archivo de la BIOS correspondiente en el directorio del sistema de RetroArch."
#define OPTION_VAL_GAME_GENIE_ES NULL
#define OPTION_VAL_ACTION_REPLAY_PRO_ES NULL
#define OPTION_VAL_SONIC_KNUCKLES_ES NULL
#define GENESIS_PLUS_GX_ASPECT_RATIO_LABEL_ES "Relación de aspecto del núcleo"
#define GENESIS_PLUS_GX_ASPECT_RATIO_INFO_0_ES "Selecciona la relación de aspecto del contenido. Esta opción solo surtirá efecto cuando la relación de aspecto de RetroArch, en el apartado de ajustes de Vídeo, esté configurada como «Asignada por el núcleo»."
#define OPTION_VAL_NTSC_PAR_ES "Relación de aspecto de píxeles NTSC"
#define OPTION_VAL_PAL_PAR_ES "Relación de aspecto de píxeles PAL"
#define OPTION_VAL_4_3_ES NULL
#define OPTION_VAL_UNCORRECTED_ES "Sin corregir"
#define GENESIS_PLUS_GX_OVERSCAN_LABEL_ES "Bordes"
#define GENESIS_PLUS_GX_OVERSCAN_INFO_0_ES "Activa esta opción para mostrar las regiones de sobrebarrido en las partes superior e inferior o izquierda y derecha de la pantalla. Una televisión de definición estándar suele ocultarlas con el borde de la pantalla."
#define OPTION_VAL_TOP_BOTTOM_ES "Superior/inferior"
#define OPTION_VAL_LEFT_RIGHT_ES "Izquierda/derecha"
#define OPTION_VAL_FULL_ES "Completa"
#define GENESIS_PLUS_GX_LEFT_BORDER_LABEL_ES "Ocultar los bordes laterales de Master System"
#define GENESIS_PLUS_GX_LEFT_BORDER_INFO_0_ES "Corta 8 píxeles del lateral izquierdo de la pantalla o de ambos laterales al ejecutar juegos para Master System."
#define OPTION_VAL_LEFT_BORDER_ES "Solo el borde izquierdo"
#define OPTION_VAL_LEFT_RIGHT_BORDERS_ES "Bordes izquierdo y derecho"
#define GENESIS_PLUS_GX_GG_EXTRA_LABEL_ES "Extender imagen de Game Gear"
#define GENESIS_PLUS_GX_GG_EXTRA_INFO_0_ES "Fuerza a los juegos para Game Gear a ejecutarse en el modo SMS con una resolución incrementada de 256x192. Tal vez se muestren más contenidos, pero lo normal es que se muestre un borde de datos de imagen dañados o indeseables."
#define GENESIS_PLUS_GX_BLARGG_NTSC_FILTER_LABEL_ES "Filtro NTSC de Blargg"
#define GENESIS_PLUS_GX_BLARGG_NTSC_FILTER_INFO_0_ES "Aplica un filtro de vídeo para imitar varios tipos de señales de imagen NTSC."
#define OPTION_VAL_MONOCHROME_ES "Monocromático"
#define OPTION_VAL_COMPOSITE_ES "Vídeo compuesto"
#define OPTION_VAL_SVIDEO_ES NULL
#define OPTION_VAL_RGB_ES NULL
#define GENESIS_PLUS_GX_LCD_FILTER_LABEL_ES "Filtro de efecto fantasma («ghosting») de LCD"
#define GENESIS_PLUS_GX_LCD_FILTER_INFO_0_ES "Aplica un filtro de efecto fantasma («ghosting») a la imagen para simular las características de los paneles LCD de Game Gear y Nomad."
#define GENESIS_PLUS_GX_RENDER_LABEL_ES "Modo de entrelazado de vídeo 2"
#define GENESIS_PLUS_GX_RENDER_INFO_0_ES "El modo de entrelazado de vídeo 2 permite a la Mega Drive/Genesis generar una imagen que duplica su altura original a 320x448 (alta resolución) dibujando líneas de barrido alternativas en cada fotograma (usado por los modos multijugador de Sonic the Hedgehog 2 y de Combat Cars). «Dos campos» imita el hardware original: produce una imagen nítida con artefactos de parpadeos o de entrelazado. «Un campo» aplica un filtro de desentrelazado para estabilizar la imagen, pero la hará algo borrosa."
#define OPTION_VAL_SINGLE_FIELD_ES "Un campo"
#define OPTION_VAL_DOUBLE_FIELD_ES "Dos campos"
#define GENESIS_PLUS_GX_FRAMESKIP_LABEL_ES "Omisión de fotogramas"
#define GENESIS_PLUS_GX_FRAMESKIP_INFO_0_ES "Omite fotogramas para no saturar el búfer de audio (chasquidos en el sonido). Mejora el rendimiento a costa de perder fluidez visual. Selección automática omite fotogramas según lo aconseje el front-end. El valor Manual utiliza el ajuste Umbral de omisión de fotogramas (%)."
#define OPTION_VAL_MANUAL_ES NULL
#define GENESIS_PLUS_GX_FRAMESKIP_THRESHOLD_LABEL_ES "Umbral de omisión de fotogramas (%)"
#define GENESIS_PLUS_GX_FRAMESKIP_THRESHOLD_INFO_0_ES "Cuando la omisión de fotogramas esté configurada como Manual, este ajuste especifica el umbral de ocupación del búfer de audio (en porcentaje) por debajo del cual se omitirán fotogramas si el valor. Un valor más elevado reduce el riesgo de chasquidos omitiendo fotogramas con una mayor frecuencia."
#define GENESIS_PLUS_GX_YM2413_LABEL_ES "Sonido por síntesis FM de Master System (YM2413)"
#define GENESIS_PLUS_GX_YM2413_INFO_0_ES "Activa la emulación de la unidad de sonido FM que usan algunos juegos concretos de Sega Mark III/Master System para mejorar su salida de audio."
#define GENESIS_PLUS_GX_YM2413_CORE_LABEL_ES "Núcleo del sonido FM de Master System (YM2413)"
#define GENESIS_PLUS_GX_YM2413_CORE_INFO_0_ES "Selecciona el método con el que emular la unidad de sonido FM de la Sega Mark III/Master System. «MAME» es rápido y se ejecuta a la máxima velocidad en la mayoría de sistemas. «Nuked» ofrece una emulación precisa, con una calidad y requisitos de CPU elevados."
#define OPTION_VAL_MAME_ES NULL
#define OPTION_VAL_NUKED_ES NULL
#define GENESIS_PLUS_GX_YM2612_LABEL_ES "Sonido por síntesis FM de Mega Drive/Genesis"
#define GENESIS_PLUS_GX_YM2612_INFO_0_ES "Selecciona el método con el que emular el sintetizador FM (el generador principal de sonido) de la Mega Drive/Genesis. Las opciones de MAME son rápidas y se ejecutan a la máxima velocidad en la mayoría de sistemas. Las opciones Nuked ofrecen una emulación precisa en cuanto a ciclos, con una calidad y requisitos de CPU elevados. El chip YM26132 es el que llevan los Model 1 originales de Mega Drive/Genesis. El chip YM3438 es el que se utilizó en las revisiones posteriores de Mega Drive/Genesis."
#define GENESIS_PLUS_GX_YM2612_INFO_1_ES "Selecciona el método con el que emular el sintetizador FM (el generador principal de sonido) de la Mega Drive/Genesis. El chip YM26132 es el que llevan los Model 1 originales de Mega Drive/Genesis. El chip YM3438 es el que se utilizó en las revisiones posteriores de Mega Drive/Genesis."
#define OPTION_VAL_MAME_YM2612_ES NULL
#define OPTION_VAL_MAME_ASIC_YM3438_ES NULL
#define OPTION_VAL_MAME_ENHANCED_YM3438_ES "MAME (YM3438 mejorado)"
#define OPTION_VAL_NUKED_YM2612_ES NULL
#define OPTION_VAL_NUKED_YM3438_ES NULL
#define GENESIS_PLUS_GX_SOUND_OUTPUT_LABEL_ES "Salida de sonido"
#define GENESIS_PLUS_GX_SOUND_OUTPUT_INFO_0_ES "Selecciona la reproducción de sonido monoaural o estéreo."
#define OPTION_VAL_STEREO_ES "Estéreo"
#define OPTION_VAL_MONO_ES "Monoaural"
#define GENESIS_PLUS_GX_AUDIO_FILTER_LABEL_ES "Filtro de audio"
#define GENESIS_PLUS_GX_AUDIO_FILTER_INFO_0_ES "Aplica un filtro de paso bajo de audio para simular mejor el sonido característico de una Mega Drive/Genesis Model 1."
#define OPTION_VAL_LOW_PASS_ES "Paso bajo"
#define OPTION_VAL_EQ_ES "Ecualizador"
#define GENESIS_PLUS_GX_LOWPASS_RANGE_LABEL_ES "Porcentaje del filtro de paso bajo"
#define GENESIS_PLUS_GX_LOWPASS_RANGE_INFO_0_ES "Especifica el umbral de frecuencias del filtro de paso bajo de audio. Un valor más elevado aumentará la «fuerza» percibida del filtro, atenuando un mayor rango de frecuencias altas."
#define GENESIS_PLUS_GX_PSG_PREAMP_LABEL_ES "Nivel de preamplificación del PSG"
#define GENESIS_PLUS_GX_PSG_PREAMP_INFO_0_ES "Ajusta el nivel de preamplificación de audio del PSG (generador programable de sonidos) SN76496 de cuatro canales que utilizan las SG-1000, Sega Mark III, Master System, Game Gear y Mega Drive/Genesis."
#define GENESIS_PLUS_GX_FM_PREAMP_LABEL_ES "Nivel de preamplificación de FM"
#define GENESIS_PLUS_GX_FM_PREAMP_INFO_0_ES "Ajusta el nivel de preamplificado de audio del sintetizador de sonido FM de Mega Drive/Genesis o de la unidad de sonido FM de las Sega Mark III/Master System."
#define GENESIS_PLUS_GX_CDDA_VOLUME_LABEL_ES "Volumen de CD audio (CD-DA)"
#define GENESIS_PLUS_GX_CDDA_VOLUME_INFO_0_ES "Ajusta el volumen de mezcla de la salida de audio CD emulada."
#define GENESIS_PLUS_GX_PCM_VOLUME_LABEL_ES "Volumen de onda PCM"
#define GENESIS_PLUS_GX_PCM_VOLUME_INFO_0_ES "Ajusta el volumen de mezcla de la salida de audio del generador PCM RF5C164 emulado de la Sega CD/Mega-CD."
#define GENESIS_PLUS_GX_AUDIO_EQ_LOW_LABEL_ES "Ecualización de graves"
#define GENESIS_PLUS_GX_AUDIO_EQ_LOW_INFO_0_ES "Ajusta la banda de tonos graves del ecualizador interno de audio."
#define GENESIS_PLUS_GX_AUDIO_EQ_MID_LABEL_ES "Ecualización de medios"
#define GENESIS_PLUS_GX_AUDIO_EQ_MID_INFO_0_ES "Ajusta la banda de tonos medios del ecualizador interno de audio."
#define GENESIS_PLUS_GX_AUDIO_EQ_HIGH_LABEL_ES "Ecualización de agudos"
#define GENESIS_PLUS_GX_AUDIO_EQ_HIGH_INFO_0_ES "Ajusta la banda de tonos agudos del ecualizador interno de audio."
#define GENESIS_PLUS_GX_GUN_INPUT_LABEL_ES "Entrada de pistola de luz"
#define GENESIS_PLUS_GX_GUN_INPUT_INFO_0_ES "Utiliza un ratón o una pantalla táctil para controlar una pistola de luz."
#define OPTION_VAL_LIGHTGUN_ES "Pistola de luz"
#define OPTION_VAL_TOUCHSCREEN_ES "Pantalla táctil"
#define GENESIS_PLUS_GX_GUN_CURSOR_LABEL_ES "Mostrar punto de mira de las pistolas de luz"
#define GENESIS_PLUS_GX_GUN_CURSOR_INFO_0_ES "Muestra los puntos de mira de las pistolas de luz al utilizar los dispositivos de entrada MD Menacer, MD Justifier y MS Light Phaser."
#define GENESIS_PLUS_GX_INVERT_MOUSE_LABEL_ES "Invertir eje Y del ratón"
#define GENESIS_PLUS_GX_INVERT_MOUSE_INFO_0_ES "Invierte el eje vertical del dispositivo de entrada MD Mouse."
#define GENESIS_PLUS_GX_NO_SPRITE_LIMIT_LABEL_ES "Eliminar límite de sprites por línea"
#define GENESIS_PLUS_GX_NO_SPRITE_LIMIT_INFO_0_ES "Elimina el límite de sprites por líneas de barrido que tenía el hardware original. Reduce los parpadeos, pero puede provocar fallos gráficos, ya que algunos juegos aprovechan esta limitación para generar efectos especiales."
#define GENESIS_PLUS_GX_ENHANCED_VSCROLL_LABEL_ES "Mejorar desplazamiento vertical de «tiles»"
#define GENESIS_PLUS_GX_ENHANCED_VSCROLL_INFO_0_ES "Permite que cada celda individual pueda desplazarse en vertical de forma fluida en vez de hacerlo por parejas de 16 píxeles, haciendo un promedio del valor «vscroll» de las celdas colindantes. Este arreglo solo afecta a unos pocos juegos que utilizan el modo de desplazamiento vertical por parejas de dos celdas."
#define GENESIS_PLUS_GX_ENHANCED_VSCROLL_LIMIT_LABEL_ES "Límite de la mejora del desplazamiento vertical de «tiles»"
#define GENESIS_PLUS_GX_ENHANCED_VSCROLL_LIMIT_INFO_0_ES "Esta opción solo se aplicará si la mejora del desplazamiento vertical de «tiles» está activada. Ajusta el límite de esta mejora. Cuando la diferencia del valor «vscroll» entre celdas colindantes sea superior a este límite, se desactivará la mejora."
#define GENESIS_PLUS_GX_OVERCLOCK_LABEL_ES "Velocidad de la CPU"
#define GENESIS_PLUS_GX_OVERCLOCK_INFO_0_ES "Aumenta la velocidad de la CPU emulada. Puede reducir las ralentizaciones, pero también podría provocar fallos gráficos."
#define OPTION_VAL_100_ES "100 %"
#define OPTION_VAL_125_ES "125 %"
#define OPTION_VAL_150_ES "150 %"
#define OPTION_VAL_175_ES "175 %"
#define OPTION_VAL_200_ES "200 %"
#define OPTION_VAL_225_ES "225 %"
#define OPTION_VAL_250_ES "250 %"
#define OPTION_VAL_275_ES "275 %"
#define OPTION_VAL_300_ES "300 %"
#define OPTION_VAL_325_ES "325 %"
#define OPTION_VAL_350_ES "350 %"
#define OPTION_VAL_375_ES "375 %"
#define OPTION_VAL_400_ES "400 %"
#define OPTION_VAL_425_ES "425 %"
#define OPTION_VAL_450_ES "450 %"
#define OPTION_VAL_475_ES "475 %"
#define OPTION_VAL_500_ES "500 %"
#define GENESIS_PLUS_GX_FORCE_DTACK_LABEL_ES "Bloqueos del sistema"
#define GENESIS_PLUS_GX_FORCE_DTACK_INFO_0_ES "Emula los bloqueos del sistema que se producirían en el hardware real al realizar accesos ilegales a memoria. Solo se debe desactivar esta opción para jugar con demos y aplicaciones homebrew que necesiten este comportamiento ilegal para funcionar correctamente."
#define GENESIS_PLUS_GX_ADDR_ERROR_LABEL_ES "Error de dirección del 68K"
#define GENESIS_PLUS_GX_ADDR_ERROR_INFO_0_ES "La CPU principal de la Mega Drive/Genesis (el Motorola 68000) genera una excepción (cuelgue) de error de memoria al intentar acceder a una memoria no alineada. Activa esta opción para simular este comportamiento. Solo debe desactivarse para jugar a modificaciones de juegos, ya que estas suelen desarrollarse con emuladores menos precisos y pueden depender de accesos a RAM no válidos para funcionar correctamente."
#define GENESIS_PLUS_GX_CD_LATENCY_LABEL_ES "Tiempo de acceso al CD"
#define GENESIS_PLUS_GX_CD_LATENCY_INFO_0_ES "Simula la latencia del lector original de CD al empezar a leer o buscar una ubicación concreta del disco que esté cargado. Esto es necesario para algunos juegos en formato CD que se colgarán si los datos aparecen demasiado pronto, también corrige problemas de desincronización del audio de CD en algunos juegos. Desactivar esta opción podría venir bien para juegos MSU-MD, ya que hará que los bucles en las pistas de audio de CD queden más disimulados."
#define GENESIS_PLUS_GX_CD_PRECACHE_LABEL_ES "Cachear imagen del CD"
#define GENESIS_PLUS_GX_CD_PRECACHE_INFO_0_ES "Carga la imagen del CD a la memoria al iniciar la emulación. Solo se admiten imágenes CHD. Es necesario reiniciar."
#define GENESIS_PLUS_GX_SHOW_ADVANCED_AUDIO_SETTINGS_LABEL_ES "Mostrar Ajustes avanzados de volumen de audio (es necesario reabrir el menú)"
#define GENESIS_PLUS_GX_SHOW_ADVANCED_AUDIO_SETTINGS_INFO_0_ES "Permite configurar los parámetros de los canales de audio a un bajo nivel. NOTA: es necesario salir y volver a entrar del menú rápido para que el cambio surta efecto."
#define GENESIS_PLUS_GX_PSG_CHANNEL_0_VOLUME_LABEL_ES "Volumen del canal tonal 0 del PSG (%)"
#define GENESIS_PLUS_GX_PSG_CHANNEL_0_VOLUME_INFO_0_ES "Reduce el volumen del canal tonal 0 del PSG."
#define GENESIS_PLUS_GX_PSG_CHANNEL_1_VOLUME_LABEL_ES "Volumen del canal tonal 1 del PSG (%)"
#define GENESIS_PLUS_GX_PSG_CHANNEL_1_VOLUME_INFO_0_ES "Reduce el volumen del canal tonal 1 del PSG."
#define GENESIS_PLUS_GX_PSG_CHANNEL_2_VOLUME_LABEL_ES "Volumen del canal tonal 2 del PSG (%)"
#define GENESIS_PLUS_GX_PSG_CHANNEL_2_VOLUME_INFO_0_ES "Reduce el volumen del canal tonal 2 del PSG."
#define GENESIS_PLUS_GX_PSG_CHANNEL_3_VOLUME_LABEL_ES "Volumen del canal de ruido 3 del PSG (%)"
#define GENESIS_PLUS_GX_PSG_CHANNEL_3_VOLUME_INFO_0_ES "Reduce el volumen del canal de ruido 3 del PSG."
#define GENESIS_PLUS_GX_MD_CHANNEL_0_VOLUME_LABEL_ES "Volumen del canal FM 0 de Mega Drive/Genesis (%)"
#define GENESIS_PLUS_GX_MD_CHANNEL_0_VOLUME_INFO_0_ES "Reduce el volumen del canal 0 de FM de Mega Drive/Genesis. Solo surtirá efecto con los emuladores MAME de FM."
#define GENESIS_PLUS_GX_MD_CHANNEL_1_VOLUME_LABEL_ES "Volumen del canal FM 1 de Mega Drive/Genesis (%)"
#define GENESIS_PLUS_GX_MD_CHANNEL_1_VOLUME_INFO_0_ES "Reduce el volumen del canal 1 de FM de Mega Drive/Genesis. Solo surtirá efecto con los emuladores MAME de FM."
#define GENESIS_PLUS_GX_MD_CHANNEL_2_VOLUME_LABEL_ES "Volumen del canal FM 2 de Mega Drive/Genesis (%)"
#define GENESIS_PLUS_GX_MD_CHANNEL_2_VOLUME_INFO_0_ES "Reduce el volumen del canal 2 de FM de Mega Drive/Genesis. Solo surtirá efecto con los emuladores MAME de FM."
#define GENESIS_PLUS_GX_MD_CHANNEL_3_VOLUME_LABEL_ES "Volumen del canal FM 3 de Mega Drive/Genesis (%)"
#define GENESIS_PLUS_GX_MD_CHANNEL_3_VOLUME_INFO_0_ES "Reduce el volumen del canal 3 de FM de Mega Drive/Genesis. Solo surtirá efecto con los emuladores MAME de FM."
#define GENESIS_PLUS_GX_MD_CHANNEL_4_VOLUME_LABEL_ES "Volumen del canal FM 4 de Mega Drive/Genesis (%)"
#define GENESIS_PLUS_GX_MD_CHANNEL_4_VOLUME_INFO_0_ES "Reduce el volumen del canal 4 de FM de Mega Drive/Genesis. Solo surtirá efecto con los emuladores MAME de FM."
#define GENESIS_PLUS_GX_MD_CHANNEL_5_VOLUME_LABEL_ES "Volumen del canal FM 5 de Mega Drive/Genesis (%)"
#define GENESIS_PLUS_GX_MD_CHANNEL_5_VOLUME_INFO_0_ES "Reduce el volumen del canal 5 de FM de Mega Drive/Genesis. Solo surtirá efecto con los emuladores MAME de FM."
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_0_VOLUME_LABEL_ES "Volumen del canal 0 FM de Master System (%)"
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_0_VOLUME_INFO_0_ES "Reduce el volumen del canal 0 de FM de Master System."
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_1_VOLUME_LABEL_ES "Volumen del canal 1 FM de Master System (%)"
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_1_VOLUME_INFO_0_ES "Reduce el volumen del canal 1 de FM de Master System."
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_2_VOLUME_LABEL_ES "Volumen del canal 2 FM de Master System (%)"
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_2_VOLUME_INFO_0_ES "Reduce el volumen del canal 2 de FM de Master System."
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_3_VOLUME_LABEL_ES "Volumen del canal 3 FM de Master System (%)"
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_3_VOLUME_INFO_0_ES "Reduce el volumen del canal 3 de FM de Master System."
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_4_VOLUME_LABEL_ES "Volumen del canal 4 FM de Master System (%)"
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_4_VOLUME_INFO_0_ES "Reduce el volumen del canal 4 de FM de Master System."
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_5_VOLUME_LABEL_ES "Volumen del canal 5 FM de Master System (%)"
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_5_VOLUME_INFO_0_ES "Reduce el volumen del canal 5 de FM de Master System."
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_6_VOLUME_LABEL_ES "Volumen del canal 6 FM de Master System (%)"
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_6_VOLUME_INFO_0_ES "Reduce el volumen del canal 6 de FM de Master System."
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_7_VOLUME_LABEL_ES "Volumen del canal 7 FM de Master System (%)"
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_7_VOLUME_INFO_0_ES "Reduce el volumen del canal 7 de FM de Master System."
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_8_VOLUME_LABEL_ES "Volumen del canal 8 FM de Master System (%)"
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_8_VOLUME_INFO_0_ES "Reduce el volumen del canal 8 de FM de Master System."

struct retro_core_option_v2_category option_cats_es[] = {
   {
      "system",
      CATEGORY_SYSTEM_LABEL_ES,
      CATEGORY_SYSTEM_INFO_0_ES
   },
   {
      "video",
      CATEGORY_VIDEO_LABEL_ES,
      CATEGORY_VIDEO_INFO_0_ES
   },
   {
      "audio",
      CATEGORY_AUDIO_LABEL_ES,
      CATEGORY_AUDIO_INFO_0_ES
   },
   {
      "input",
      CATEGORY_INPUT_LABEL_ES,
      CATEGORY_INPUT_INFO_0_ES
   },
   {
      "hacks",
      CATEGORY_HACKS_LABEL_ES,
      CATEGORY_HACKS_INFO_0_ES
   },
   {
      "channel_volume",
      CATEGORY_CHANNEL_VOLUME_LABEL_ES,
      CATEGORY_CHANNEL_VOLUME_INFO_0_ES
   },
   { NULL, NULL, NULL },
};
struct retro_core_option_v2_definition option_defs_es[] = {
   {
      "genesis_plus_gx_system_hw",
      GENESIS_PLUS_GX_SYSTEM_HW_LABEL_ES,
      NULL,
      GENESIS_PLUS_GX_SYSTEM_HW_INFO_0_ES,
      NULL,
      "system",
      {
         { "auto",                 OPTION_VAL_AUTO_ES                 },
         { "sg-1000",              OPTION_VAL_SG_1000_ES              },
         { "sg-1000 II",           OPTION_VAL_SG_1000_II_ES           },
         { "sg-1000 II + ram ext.",OPTION_VAL_SG_1000_II_RAM_EXT_ES},
         { "mark-III",             OPTION_VAL_MARK_III_ES             },
         { "master system",        OPTION_VAL_MASTER_SYSTEM_ES        },
         { "master system II",     OPTION_VAL_MASTER_SYSTEM_II_ES     },
         { "game gear",            OPTION_VAL_GAME_GEAR_ES            },
         { "mega drive / genesis", OPTION_VAL_MEGA_DRIVE_GENESIS_ES   },
         { NULL, NULL },
      },
      "auto"
   },
   {
      "genesis_plus_gx_region_detect",
      GENESIS_PLUS_GX_REGION_DETECT_LABEL_ES,
      NULL,
      GENESIS_PLUS_GX_REGION_DETECT_INFO_0_ES,
      NULL,
      "system",
      {
         { "auto",    OPTION_VAL_AUTO_ES   },
         { "ntsc-u",  OPTION_VAL_NTSC_U_ES },
         { "pal",     OPTION_VAL_PAL_ES    },
         { "ntsc-j",  OPTION_VAL_NTSC_J_ES },
         { NULL, NULL },
      },
      "auto"
   },
   {
      "genesis_plus_gx_vdp_mode",
      GENESIS_PLUS_GX_VDP_MODE_LABEL_ES,
      NULL,
      GENESIS_PLUS_GX_VDP_MODE_INFO_0_ES,
      NULL,
      "system",
      {
         { "auto",  "Disabled" },
         { "60hz",  OPTION_VAL_60HZ_ES },
         { "50hz",  OPTION_VAL_50HZ_ES },
         { NULL, NULL },
      },
      "auto"
   },
   {
      "genesis_plus_gx_bios",
      GENESIS_PLUS_GX_BIOS_LABEL_ES,
      NULL,
      GENESIS_PLUS_GX_BIOS_INFO_0_ES,
      NULL,
      "system",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_system_bram",
      GENESIS_PLUS_GX_SYSTEM_BRAM_LABEL_ES,
      NULL,
      GENESIS_PLUS_GX_SYSTEM_BRAM_INFO_0_ES,
      NULL,
      "system",
      {
         { "per bios", OPTION_VAL_PER_BIOS_ES },
         { "per game", OPTION_VAL_PER_GAME_ES },
         { NULL, NULL },
      },
      "per bios"
   },
   {
      "genesis_plus_gx_cart_bram",
      GENESIS_PLUS_GX_CART_BRAM_LABEL_ES,
      NULL,
      GENESIS_PLUS_GX_CART_BRAM_INFO_0_ES,
      NULL,
      "system",
      {
         { "per cart", OPTION_VAL_PER_CART_ES },
         { "per game", OPTION_VAL_PER_GAME_ES },
         { NULL, NULL },
      },
      "per cart"
   },
   {
      "genesis_plus_gx_cart_size",
      GENESIS_PLUS_GX_CART_SIZE_LABEL_ES,
      NULL,
      GENESIS_PLUS_GX_CART_SIZE_INFO_0_ES,
      NULL,
      "system",
      {
         { "disabled", "Disabled" },
         { "128k",     OPTION_VAL_128K_ES  },
         { "256k",     OPTION_VAL_256K_ES  },
         { "512k",     OPTION_VAL_512K_ES  },
         { "1meg",     OPTION_VAL_1MEG_ES    },
         { "2meg",     OPTION_VAL_2MEG_ES    },
         { "4meg",     OPTION_VAL_4MEG_ES    },
         { NULL, NULL },
      },
      "4meg"
   },
   {
      "genesis_plus_gx_add_on",
      GENESIS_PLUS_GX_ADD_ON_LABEL_ES,
      NULL,
      GENESIS_PLUS_GX_ADD_ON_INFO_0_ES,
      NULL,
      "system",
      {
         { "auto",         OPTION_VAL_AUTO_ES },
         { "sega/mega cd", OPTION_VAL_SEGA_MEGA_CD_ES },
         { "megasd",       OPTION_VAL_MEGASD_ES },
         { "none",         OPTION_VAL_NONE_ES },
         { NULL, NULL },
      },
      "auto"
   },
   {
      "genesis_plus_gx_lock_on",
      GENESIS_PLUS_GX_LOCK_ON_LABEL_ES,
      NULL,
      GENESIS_PLUS_GX_LOCK_ON_INFO_0_ES,
      NULL,
      "system",
      {
         { "disabled",            NULL },
         { "game genie",          OPTION_VAL_GAME_GENIE_ES },
         { "action replay (pro)", OPTION_VAL_ACTION_REPLAY_PRO_ES },
         { "sonic & knuckles",    OPTION_VAL_SONIC_KNUCKLES_ES },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_aspect_ratio",
      GENESIS_PLUS_GX_ASPECT_RATIO_LABEL_ES,
      NULL,
      GENESIS_PLUS_GX_ASPECT_RATIO_INFO_0_ES,
      NULL,
      "video",
      {
         { "auto",     OPTION_VAL_AUTO_ES },
         { "NTSC PAR", OPTION_VAL_NTSC_PAR_ES },
         { "PAL PAR",  OPTION_VAL_PAL_PAR_ES },
         { "4:3",  OPTION_VAL_4_3_ES },
         { "Uncorrected",  OPTION_VAL_UNCORRECTED_ES },
      },
      "auto"
   },
   {
      "genesis_plus_gx_overscan",
      GENESIS_PLUS_GX_OVERSCAN_LABEL_ES,
      NULL,
      GENESIS_PLUS_GX_OVERSCAN_INFO_0_ES,
      NULL,
      "video",
      {
         { "disabled",   NULL },
         { "top/bottom", OPTION_VAL_TOP_BOTTOM_ES },
         { "left/right", OPTION_VAL_LEFT_RIGHT_ES },
         { "full",       OPTION_VAL_FULL_ES },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_left_border",
      GENESIS_PLUS_GX_LEFT_BORDER_LABEL_ES,
      NULL,
      GENESIS_PLUS_GX_LEFT_BORDER_INFO_0_ES,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "left border", OPTION_VAL_LEFT_BORDER_ES },
         { "left & right borders", OPTION_VAL_LEFT_RIGHT_BORDERS_ES },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_gg_extra",
      GENESIS_PLUS_GX_GG_EXTRA_LABEL_ES,
      NULL,
      GENESIS_PLUS_GX_GG_EXTRA_INFO_0_ES,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_blargg_ntsc_filter",
      GENESIS_PLUS_GX_BLARGG_NTSC_FILTER_LABEL_ES,
      NULL,
      GENESIS_PLUS_GX_BLARGG_NTSC_FILTER_INFO_0_ES,
      NULL,
      "video",
      {
         { "disabled",   NULL },
         { "monochrome", OPTION_VAL_MONOCHROME_ES },
         { "composite",  OPTION_VAL_COMPOSITE_ES },
         { "svideo",     OPTION_VAL_SVIDEO_ES },
         { "rgb",        OPTION_VAL_RGB_ES },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_lcd_filter",
      GENESIS_PLUS_GX_LCD_FILTER_LABEL_ES,
      NULL,
      GENESIS_PLUS_GX_LCD_FILTER_INFO_0_ES,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_render",
      GENESIS_PLUS_GX_RENDER_LABEL_ES,
      NULL,
      GENESIS_PLUS_GX_RENDER_INFO_0_ES,
      NULL,
      "video",
      {
         { "single field", OPTION_VAL_SINGLE_FIELD_ES },
         { "double field", OPTION_VAL_DOUBLE_FIELD_ES },
         { NULL, NULL },
      },
      "single field"
   },
   {
      "genesis_plus_gx_frameskip",
      GENESIS_PLUS_GX_FRAMESKIP_LABEL_ES,
      NULL,
      GENESIS_PLUS_GX_FRAMESKIP_INFO_0_ES,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "auto",     OPTION_VAL_AUTO_ES },
         { "manual",   OPTION_VAL_MANUAL_ES },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_frameskip_threshold",
      GENESIS_PLUS_GX_FRAMESKIP_THRESHOLD_LABEL_ES,
      NULL,
      GENESIS_PLUS_GX_FRAMESKIP_THRESHOLD_INFO_0_ES,
      NULL,
      "video",
      {
         { "15", NULL },
         { "18", NULL },
         { "21", NULL },
         { "24", NULL },
         { "27", NULL },
         { "30", NULL },
         { "33", NULL },
         { "36", NULL },
         { "39", NULL },
         { "42", NULL },
         { "45", NULL },
         { "48", NULL },
         { "51", NULL },
         { "54", NULL },
         { "57", NULL },
         { "60", NULL },
         { NULL, NULL },
      },
      "33"
   },
   {
      "genesis_plus_gx_ym2413",
      GENESIS_PLUS_GX_YM2413_LABEL_ES,
      NULL,
      GENESIS_PLUS_GX_YM2413_INFO_0_ES,
      NULL,
      "audio",
      {
         { "auto",     OPTION_VAL_AUTO_ES },
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "auto"
   },
#ifdef HAVE_OPLL_CORE
   {
      "genesis_plus_gx_ym2413_core",
      GENESIS_PLUS_GX_YM2413_CORE_LABEL_ES,
      NULL,
      GENESIS_PLUS_GX_YM2413_CORE_INFO_0_ES,
      NULL,
      "audio",
      {
         { "mame",  OPTION_VAL_MAME_ES },
         { "nuked", OPTION_VAL_NUKED_ES },
         { NULL, NULL },
      },
      "mame"
   },
#endif
   {
      "genesis_plus_gx_ym2612",
      GENESIS_PLUS_GX_YM2612_LABEL_ES,
      NULL,
#ifdef HAVE_YM3438_CORE
      GENESIS_PLUS_GX_YM2612_INFO_0_ES,
#else
      GENESIS_PLUS_GX_YM2612_INFO_1_ES,
#endif
      NULL,
      "audio",
      {
         { "mame (ym2612)",          OPTION_VAL_MAME_YM2612_ES },
         { "mame (asic ym3438)",     OPTION_VAL_MAME_ASIC_YM3438_ES },
         { "mame (enhanced ym3438)", OPTION_VAL_MAME_ENHANCED_YM3438_ES },
#ifdef HAVE_YM3438_CORE
         { "nuked (ym2612)",         OPTION_VAL_NUKED_YM2612_ES },
         { "nuked (ym3438)",         OPTION_VAL_NUKED_YM3438_ES },
#endif
         { NULL, NULL },
      },
      "mame (ym2612)"
   },
   {
      "genesis_plus_gx_sound_output",
      GENESIS_PLUS_GX_SOUND_OUTPUT_LABEL_ES,
      NULL,
      GENESIS_PLUS_GX_SOUND_OUTPUT_INFO_0_ES,
      NULL,
      "audio",
      {
         { "stereo", OPTION_VAL_STEREO_ES },
         { "mono",   OPTION_VAL_MONO_ES },
         { NULL, NULL },
      },
      "stereo"
   },
   {
      "genesis_plus_gx_audio_filter",
      GENESIS_PLUS_GX_AUDIO_FILTER_LABEL_ES,
      NULL,
      GENESIS_PLUS_GX_AUDIO_FILTER_INFO_0_ES,
      NULL,
      "audio",
      {
         { "disabled", NULL },
         { "low-pass", OPTION_VAL_LOW_PASS_ES },
#ifdef HAVE_EQ
         { "EQ",       OPTION_VAL_EQ_ES },
#endif
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_lowpass_range",
      GENESIS_PLUS_GX_LOWPASS_RANGE_LABEL_ES,
      NULL,
      GENESIS_PLUS_GX_LOWPASS_RANGE_INFO_0_ES,
      NULL,
      "audio",
      {
         { "5",  NULL },
         { "10", NULL },
         { "15", NULL },
         { "20", NULL },
         { "25", NULL },
         { "30", NULL },
         { "35", NULL },
         { "40", NULL },
         { "45", NULL },
         { "50", NULL },
         { "55", NULL },
         { "60", NULL },
         { "65", NULL },
         { "70", NULL },
         { "75", NULL },
         { "80", NULL },
         { "85", NULL },
         { "90", NULL },
         { "95", NULL },
         { NULL, NULL },
      },
      "60"
   },
   {
      "genesis_plus_gx_psg_preamp",
      GENESIS_PLUS_GX_PSG_PREAMP_LABEL_ES,
      NULL,
      GENESIS_PLUS_GX_PSG_PREAMP_INFO_0_ES,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { "105", NULL },
         { "110", NULL },
         { "115", NULL },
         { "120", NULL },
         { "125", NULL },
         { "130", NULL },
         { "135", NULL },
         { "140", NULL },
         { "145", NULL },
         { "150", NULL },
         { "155", NULL },
         { "160", NULL },
         { "165", NULL },
         { "170", NULL },
         { "175", NULL },
         { "180", NULL },
         { "185", NULL },
         { "190", NULL },
         { "195", NULL },
         { "200", NULL },
         { NULL, NULL },
      },
      "150"
   },
   {
      "genesis_plus_gx_fm_preamp",
      GENESIS_PLUS_GX_FM_PREAMP_LABEL_ES,
      NULL,
      GENESIS_PLUS_GX_FM_PREAMP_INFO_0_ES,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { "105", NULL },
         { "110", NULL },
         { "115", NULL },
         { "120", NULL },
         { "125", NULL },
         { "130", NULL },
         { "135", NULL },
         { "140", NULL },
         { "145", NULL },
         { "150", NULL },
         { "155", NULL },
         { "160", NULL },
         { "165", NULL },
         { "170", NULL },
         { "175", NULL },
         { "180", NULL },
         { "185", NULL },
         { "190", NULL },
         { "195", NULL },
         { "200", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_cdda_volume",
      GENESIS_PLUS_GX_CDDA_VOLUME_LABEL_ES,
      NULL,
      GENESIS_PLUS_GX_CDDA_VOLUME_INFO_0_ES,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_pcm_volume",
      GENESIS_PLUS_GX_PCM_VOLUME_LABEL_ES,
      NULL,
      GENESIS_PLUS_GX_PCM_VOLUME_INFO_0_ES,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
#ifdef HAVE_EQ
   {
      "genesis_plus_gx_audio_eq_low",
      GENESIS_PLUS_GX_AUDIO_EQ_LOW_LABEL_ES,
      NULL,
      GENESIS_PLUS_GX_AUDIO_EQ_LOW_INFO_0_ES,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_audio_eq_mid",
      GENESIS_PLUS_GX_AUDIO_EQ_MID_LABEL_ES,
      NULL,
      GENESIS_PLUS_GX_AUDIO_EQ_MID_INFO_0_ES,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_audio_eq_high",
      GENESIS_PLUS_GX_AUDIO_EQ_HIGH_LABEL_ES,
      NULL,
      GENESIS_PLUS_GX_AUDIO_EQ_HIGH_INFO_0_ES,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
#endif
   {
      "genesis_plus_gx_gun_input",
      GENESIS_PLUS_GX_GUN_INPUT_LABEL_ES,
      NULL,
      GENESIS_PLUS_GX_GUN_INPUT_INFO_0_ES,
      NULL,
      "input",
      {
         { "lightgun",    OPTION_VAL_LIGHTGUN_ES },
         { "touchscreen", OPTION_VAL_TOUCHSCREEN_ES },
         { NULL, NULL },
      },
      "lightgun"
   },
   {
      "genesis_plus_gx_gun_cursor",
      GENESIS_PLUS_GX_GUN_CURSOR_LABEL_ES,
      NULL,
      GENESIS_PLUS_GX_GUN_CURSOR_INFO_0_ES,
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_invert_mouse",
      GENESIS_PLUS_GX_INVERT_MOUSE_LABEL_ES,
      NULL,
      GENESIS_PLUS_GX_INVERT_MOUSE_INFO_0_ES,
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_no_sprite_limit",
      GENESIS_PLUS_GX_NO_SPRITE_LIMIT_LABEL_ES,
      NULL,
      GENESIS_PLUS_GX_NO_SPRITE_LIMIT_INFO_0_ES,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_enhanced_vscroll",
      GENESIS_PLUS_GX_ENHANCED_VSCROLL_LABEL_ES,
      NULL,
      GENESIS_PLUS_GX_ENHANCED_VSCROLL_INFO_0_ES,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_enhanced_vscroll_limit",
      GENESIS_PLUS_GX_ENHANCED_VSCROLL_LIMIT_LABEL_ES,
      NULL,
      GENESIS_PLUS_GX_ENHANCED_VSCROLL_LIMIT_INFO_0_ES,
      NULL,
      "hacks",
      {
         { "2", NULL },
         { "3",  NULL },
         { "4", NULL },
         { "5",  NULL },
         { "6", NULL },
         { "7",  NULL },
         { "8", NULL },
         { "9",  NULL },
         { "10", NULL },
         { "11",  NULL },
         { "12", NULL },
         { "13",  NULL },
         { "14", NULL },
         { "15",  NULL },
         { "16", NULL },
         { NULL, NULL },
      },
      "8"
   },
#ifdef HAVE_OVERCLOCK
   {
      "genesis_plus_gx_overclock",
      GENESIS_PLUS_GX_OVERCLOCK_LABEL_ES,
      NULL,
      GENESIS_PLUS_GX_OVERCLOCK_INFO_0_ES,
      NULL,
      "hacks",
      {
         { "100", OPTION_VAL_100_ES },
         { "125", OPTION_VAL_125_ES },
         { "150", OPTION_VAL_150_ES },
         { "175", OPTION_VAL_175_ES },
         { "200", OPTION_VAL_200_ES },
         { "225", OPTION_VAL_225_ES },
         { "250", OPTION_VAL_250_ES },
         { "275", OPTION_VAL_275_ES },
         { "300", OPTION_VAL_300_ES },
         { "325", OPTION_VAL_325_ES },
         { "350", OPTION_VAL_350_ES },
         { "375", OPTION_VAL_375_ES },
         { "400", OPTION_VAL_400_ES },
         { "425", OPTION_VAL_425_ES },
         { "450", OPTION_VAL_450_ES },
         { "475", OPTION_VAL_475_ES },
         { "500", OPTION_VAL_500_ES },
         { NULL, NULL },
      },
      "100%"
   },
#endif
   {
      "genesis_plus_gx_force_dtack",
      GENESIS_PLUS_GX_FORCE_DTACK_LABEL_ES,
      NULL,
      GENESIS_PLUS_GX_FORCE_DTACK_INFO_0_ES,
      NULL,
      "hacks",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL },
      },
      "enabled"
   },
   {
      "genesis_plus_gx_addr_error",
      GENESIS_PLUS_GX_ADDR_ERROR_LABEL_ES,
      NULL,
      GENESIS_PLUS_GX_ADDR_ERROR_INFO_0_ES,
      NULL,
      "hacks",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL },
      },
      "enabled"
   },
   {
      "genesis_plus_gx_cd_latency",
      GENESIS_PLUS_GX_CD_LATENCY_LABEL_ES,
      NULL,
      GENESIS_PLUS_GX_CD_LATENCY_INFO_0_ES,
      NULL,
      "hacks",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL },
      },
      "enabled"
   },
   {
      "genesis_plus_gx_cd_precache",
      GENESIS_PLUS_GX_CD_PRECACHE_LABEL_ES,
      NULL,
      GENESIS_PLUS_GX_CD_PRECACHE_INFO_0_ES,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
#ifdef USE_PER_SOUND_CHANNELS_CONFIG
   {
      "genesis_plus_gx_show_advanced_audio_settings",
      GENESIS_PLUS_GX_SHOW_ADVANCED_AUDIO_SETTINGS_LABEL_ES,
      NULL,
      GENESIS_PLUS_GX_SHOW_ADVANCED_AUDIO_SETTINGS_INFO_0_ES,
      NULL,
      "channel_volume",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL},
      },
      "disabled"
   },
   {
      "genesis_plus_gx_psg_channel_0_volume",
      GENESIS_PLUS_GX_PSG_CHANNEL_0_VOLUME_LABEL_ES,
      NULL,
      GENESIS_PLUS_GX_PSG_CHANNEL_0_VOLUME_INFO_0_ES,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_psg_channel_1_volume",
      GENESIS_PLUS_GX_PSG_CHANNEL_1_VOLUME_LABEL_ES,
      NULL,
      GENESIS_PLUS_GX_PSG_CHANNEL_1_VOLUME_INFO_0_ES,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_psg_channel_2_volume",
      GENESIS_PLUS_GX_PSG_CHANNEL_2_VOLUME_LABEL_ES,
      NULL,
      GENESIS_PLUS_GX_PSG_CHANNEL_2_VOLUME_INFO_0_ES,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_psg_channel_3_volume",
      GENESIS_PLUS_GX_PSG_CHANNEL_3_VOLUME_LABEL_ES,
      NULL,
      GENESIS_PLUS_GX_PSG_CHANNEL_3_VOLUME_INFO_0_ES,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_0_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_0_VOLUME_LABEL_ES,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_0_VOLUME_INFO_0_ES,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_1_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_1_VOLUME_LABEL_ES,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_1_VOLUME_INFO_0_ES,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_2_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_2_VOLUME_LABEL_ES,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_2_VOLUME_INFO_0_ES,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_3_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_3_VOLUME_LABEL_ES,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_3_VOLUME_INFO_0_ES,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_4_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_4_VOLUME_LABEL_ES,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_4_VOLUME_INFO_0_ES,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_5_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_5_VOLUME_LABEL_ES,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_5_VOLUME_INFO_0_ES,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_0_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_0_VOLUME_LABEL_ES,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_0_VOLUME_INFO_0_ES,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_1_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_1_VOLUME_LABEL_ES,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_1_VOLUME_INFO_0_ES,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_2_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_2_VOLUME_LABEL_ES,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_2_VOLUME_INFO_0_ES,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_3_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_3_VOLUME_LABEL_ES,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_3_VOLUME_INFO_0_ES,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_4_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_4_VOLUME_LABEL_ES,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_4_VOLUME_INFO_0_ES,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_5_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_5_VOLUME_LABEL_ES,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_5_VOLUME_INFO_0_ES,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_6_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_6_VOLUME_LABEL_ES,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_6_VOLUME_INFO_0_ES,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_7_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_7_VOLUME_LABEL_ES,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_7_VOLUME_INFO_0_ES,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_8_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_8_VOLUME_LABEL_ES,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_8_VOLUME_INFO_0_ES,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
#endif
   { NULL, NULL, NULL, NULL, NULL, NULL, {{0}}, NULL },
};
struct retro_core_options_v2 options_es = {
   option_cats_es,
   option_defs_es
};

/* RETRO_LANGUAGE_FA */

#define CATEGORY_SYSTEM_LABEL_FA "سیستم"
#define CATEGORY_SYSTEM_INFO_0_FA NULL
#define CATEGORY_VIDEO_LABEL_FA "ویدیو"
#define CATEGORY_VIDEO_INFO_0_FA NULL
#define CATEGORY_AUDIO_LABEL_FA "صدا"
#define CATEGORY_AUDIO_INFO_0_FA NULL
#define CATEGORY_INPUT_LABEL_FA "ورودی"
#define CATEGORY_INPUT_INFO_0_FA NULL
#define CATEGORY_HACKS_LABEL_FA NULL
#define CATEGORY_HACKS_INFO_0_FA NULL
#define CATEGORY_CHANNEL_VOLUME_LABEL_FA NULL
#define CATEGORY_CHANNEL_VOLUME_INFO_0_FA NULL
#define GENESIS_PLUS_GX_SYSTEM_HW_LABEL_FA NULL
#define GENESIS_PLUS_GX_SYSTEM_HW_INFO_0_FA NULL
#define OPTION_VAL_AUTO_FA "خودکار"
#define OPTION_VAL_SG_1000_FA NULL
#define OPTION_VAL_SG_1000_II_FA NULL
#define OPTION_VAL_SG_1000_II_RAM_EXT_FA NULL
#define OPTION_VAL_MARK_III_FA NULL
#define OPTION_VAL_MASTER_SYSTEM_FA NULL
#define OPTION_VAL_MASTER_SYSTEM_II_FA NULL
#define OPTION_VAL_GAME_GEAR_FA NULL
#define OPTION_VAL_MEGA_DRIVE_GENESIS_FA NULL
#define GENESIS_PLUS_GX_REGION_DETECT_LABEL_FA NULL
#define GENESIS_PLUS_GX_REGION_DETECT_INFO_0_FA NULL
#define OPTION_VAL_NTSC_U_FA NULL
#define OPTION_VAL_PAL_FA NULL
#define OPTION_VAL_NTSC_J_FA NULL
#define GENESIS_PLUS_GX_VDP_MODE_LABEL_FA NULL
#define GENESIS_PLUS_GX_VDP_MODE_INFO_0_FA NULL
#define OPTION_VAL_60HZ_FA NULL
#define OPTION_VAL_50HZ_FA NULL
#define GENESIS_PLUS_GX_BIOS_LABEL_FA NULL
#define GENESIS_PLUS_GX_BIOS_INFO_0_FA NULL
#define GENESIS_PLUS_GX_SYSTEM_BRAM_LABEL_FA NULL
#define GENESIS_PLUS_GX_SYSTEM_BRAM_INFO_0_FA NULL
#define OPTION_VAL_PER_BIOS_FA NULL
#define OPTION_VAL_PER_GAME_FA NULL
#define GENESIS_PLUS_GX_CART_BRAM_LABEL_FA NULL
#define GENESIS_PLUS_GX_CART_BRAM_INFO_0_FA NULL
#define OPTION_VAL_PER_CART_FA NULL
#define GENESIS_PLUS_GX_CART_SIZE_LABEL_FA NULL
#define GENESIS_PLUS_GX_CART_SIZE_INFO_0_FA NULL
#define OPTION_VAL_128K_FA NULL
#define OPTION_VAL_256K_FA NULL
#define OPTION_VAL_512K_FA NULL
#define OPTION_VAL_1MEG_FA NULL
#define OPTION_VAL_2MEG_FA NULL
#define OPTION_VAL_4MEG_FA NULL
#define GENESIS_PLUS_GX_ADD_ON_LABEL_FA NULL
#define GENESIS_PLUS_GX_ADD_ON_INFO_0_FA NULL
#define OPTION_VAL_SEGA_MEGA_CD_FA NULL
#define OPTION_VAL_MEGASD_FA NULL
#define OPTION_VAL_NONE_FA "هیچکدام"
#define GENESIS_PLUS_GX_LOCK_ON_LABEL_FA NULL
#define GENESIS_PLUS_GX_LOCK_ON_INFO_0_FA NULL
#define OPTION_VAL_GAME_GENIE_FA NULL
#define OPTION_VAL_ACTION_REPLAY_PRO_FA NULL
#define OPTION_VAL_SONIC_KNUCKLES_FA NULL
#define GENESIS_PLUS_GX_ASPECT_RATIO_LABEL_FA "نسبت تصویر فراهم‌شده توسط هسته"
#define GENESIS_PLUS_GX_ASPECT_RATIO_INFO_0_FA NULL
#define OPTION_VAL_NTSC_PAR_FA NULL
#define OPTION_VAL_PAL_PAR_FA NULL
#define OPTION_VAL_4_3_FA NULL
#define OPTION_VAL_UNCORRECTED_FA NULL
#define GENESIS_PLUS_GX_OVERSCAN_LABEL_FA NULL
#define GENESIS_PLUS_GX_OVERSCAN_INFO_0_FA NULL
#define OPTION_VAL_TOP_BOTTOM_FA NULL
#define OPTION_VAL_LEFT_RIGHT_FA NULL
#define OPTION_VAL_FULL_FA NULL
#define GENESIS_PLUS_GX_LEFT_BORDER_LABEL_FA NULL
#define GENESIS_PLUS_GX_LEFT_BORDER_INFO_0_FA NULL
#define OPTION_VAL_LEFT_BORDER_FA NULL
#define OPTION_VAL_LEFT_RIGHT_BORDERS_FA NULL
#define GENESIS_PLUS_GX_GG_EXTRA_LABEL_FA NULL
#define GENESIS_PLUS_GX_GG_EXTRA_INFO_0_FA NULL
#define GENESIS_PLUS_GX_BLARGG_NTSC_FILTER_LABEL_FA NULL
#define GENESIS_PLUS_GX_BLARGG_NTSC_FILTER_INFO_0_FA NULL
#define OPTION_VAL_MONOCHROME_FA NULL
#define OPTION_VAL_COMPOSITE_FA NULL
#define OPTION_VAL_SVIDEO_FA NULL
#define OPTION_VAL_RGB_FA NULL
#define GENESIS_PLUS_GX_LCD_FILTER_LABEL_FA NULL
#define GENESIS_PLUS_GX_LCD_FILTER_INFO_0_FA NULL
#define GENESIS_PLUS_GX_RENDER_LABEL_FA NULL
#define GENESIS_PLUS_GX_RENDER_INFO_0_FA NULL
#define OPTION_VAL_SINGLE_FIELD_FA NULL
#define OPTION_VAL_DOUBLE_FIELD_FA NULL
#define GENESIS_PLUS_GX_FRAMESKIP_LABEL_FA "پرش فریم"
#define GENESIS_PLUS_GX_FRAMESKIP_INFO_0_FA "برای جلوگیری از اجرا شدن بافر صوتی (ترق زدن) از فریم‌ها پرش کنید. عملکرد را در ازای صاف‌بودن تصویر بهبود می‌بخشد. حالت «خودکار»هنگام توصیهٔ پیشانه از روی فریم‌ها می‌پرد. حالت «دستی» تنظیم «آستانهٔ پرش فریم (٪)» را فعال می‌کند."
#define OPTION_VAL_MANUAL_FA "دستی"
#define GENESIS_PLUS_GX_FRAMESKIP_THRESHOLD_LABEL_FA "آستانهٔ پرش فریم (٪)"
#define GENESIS_PLUS_GX_FRAMESKIP_THRESHOLD_INFO_0_FA "زمانی که «پرش فریم» روی «دستی» تنظیم شده باشد، آستانهٔ (درصد) اشغال بافر صوتی را برای پرش از روی فریم‌ها تنظیم می‌کند. مقادیر بالاتر احتمال ترق خوردن صدا را با رها کردن فریم‌های بیشتر، کاهش می‌دهد."
#define GENESIS_PLUS_GX_YM2413_LABEL_FA NULL
#define GENESIS_PLUS_GX_YM2413_INFO_0_FA NULL
#define GENESIS_PLUS_GX_YM2413_CORE_LABEL_FA NULL
#define GENESIS_PLUS_GX_YM2413_CORE_INFO_0_FA NULL
#define OPTION_VAL_MAME_FA NULL
#define OPTION_VAL_NUKED_FA NULL
#define GENESIS_PLUS_GX_YM2612_LABEL_FA NULL
#define GENESIS_PLUS_GX_YM2612_INFO_0_FA NULL
#define GENESIS_PLUS_GX_YM2612_INFO_1_FA NULL
#define OPTION_VAL_MAME_YM2612_FA NULL
#define OPTION_VAL_MAME_ASIC_YM3438_FA NULL
#define OPTION_VAL_MAME_ENHANCED_YM3438_FA NULL
#define OPTION_VAL_NUKED_YM2612_FA NULL
#define OPTION_VAL_NUKED_YM3438_FA NULL
#define GENESIS_PLUS_GX_SOUND_OUTPUT_LABEL_FA NULL
#define GENESIS_PLUS_GX_SOUND_OUTPUT_INFO_0_FA NULL
#define OPTION_VAL_STEREO_FA NULL
#define OPTION_VAL_MONO_FA NULL
#define GENESIS_PLUS_GX_AUDIO_FILTER_LABEL_FA "پالایهٔ صدا"
#define GENESIS_PLUS_GX_AUDIO_FILTER_INFO_0_FA NULL
#define OPTION_VAL_LOW_PASS_FA NULL
#define OPTION_VAL_EQ_FA NULL
#define GENESIS_PLUS_GX_LOWPASS_RANGE_LABEL_FA NULL
#define GENESIS_PLUS_GX_LOWPASS_RANGE_INFO_0_FA NULL
#define GENESIS_PLUS_GX_PSG_PREAMP_LABEL_FA NULL
#define GENESIS_PLUS_GX_PSG_PREAMP_INFO_0_FA NULL
#define GENESIS_PLUS_GX_FM_PREAMP_LABEL_FA NULL
#define GENESIS_PLUS_GX_FM_PREAMP_INFO_0_FA NULL
#define GENESIS_PLUS_GX_CDDA_VOLUME_LABEL_FA NULL
#define GENESIS_PLUS_GX_CDDA_VOLUME_INFO_0_FA NULL
#define GENESIS_PLUS_GX_PCM_VOLUME_LABEL_FA NULL
#define GENESIS_PLUS_GX_PCM_VOLUME_INFO_0_FA NULL
#define GENESIS_PLUS_GX_AUDIO_EQ_LOW_LABEL_FA NULL
#define GENESIS_PLUS_GX_AUDIO_EQ_LOW_INFO_0_FA NULL
#define GENESIS_PLUS_GX_AUDIO_EQ_MID_LABEL_FA NULL
#define GENESIS_PLUS_GX_AUDIO_EQ_MID_INFO_0_FA NULL
#define GENESIS_PLUS_GX_AUDIO_EQ_HIGH_LABEL_FA NULL
#define GENESIS_PLUS_GX_AUDIO_EQ_HIGH_INFO_0_FA NULL
#define GENESIS_PLUS_GX_GUN_INPUT_LABEL_FA NULL
#define GENESIS_PLUS_GX_GUN_INPUT_INFO_0_FA NULL
#define OPTION_VAL_LIGHTGUN_FA NULL
#define OPTION_VAL_TOUCHSCREEN_FA NULL
#define GENESIS_PLUS_GX_GUN_CURSOR_LABEL_FA NULL
#define GENESIS_PLUS_GX_GUN_CURSOR_INFO_0_FA NULL
#define GENESIS_PLUS_GX_INVERT_MOUSE_LABEL_FA NULL
#define GENESIS_PLUS_GX_INVERT_MOUSE_INFO_0_FA NULL
#define GENESIS_PLUS_GX_NO_SPRITE_LIMIT_LABEL_FA NULL
#define GENESIS_PLUS_GX_NO_SPRITE_LIMIT_INFO_0_FA NULL
#define GENESIS_PLUS_GX_ENHANCED_VSCROLL_LABEL_FA NULL
#define GENESIS_PLUS_GX_ENHANCED_VSCROLL_INFO_0_FA NULL
#define GENESIS_PLUS_GX_ENHANCED_VSCROLL_LIMIT_LABEL_FA NULL
#define GENESIS_PLUS_GX_ENHANCED_VSCROLL_LIMIT_INFO_0_FA NULL
#define GENESIS_PLUS_GX_OVERCLOCK_LABEL_FA NULL
#define GENESIS_PLUS_GX_OVERCLOCK_INFO_0_FA NULL
#define OPTION_VAL_100_FA NULL
#define OPTION_VAL_125_FA NULL
#define OPTION_VAL_150_FA NULL
#define OPTION_VAL_175_FA NULL
#define OPTION_VAL_200_FA NULL
#define OPTION_VAL_225_FA NULL
#define OPTION_VAL_250_FA NULL
#define OPTION_VAL_275_FA NULL
#define OPTION_VAL_300_FA NULL
#define OPTION_VAL_325_FA NULL
#define OPTION_VAL_350_FA NULL
#define OPTION_VAL_375_FA NULL
#define OPTION_VAL_400_FA NULL
#define OPTION_VAL_425_FA NULL
#define OPTION_VAL_450_FA NULL
#define OPTION_VAL_475_FA NULL
#define OPTION_VAL_500_FA NULL
#define GENESIS_PLUS_GX_FORCE_DTACK_LABEL_FA NULL
#define GENESIS_PLUS_GX_FORCE_DTACK_INFO_0_FA NULL
#define GENESIS_PLUS_GX_ADDR_ERROR_LABEL_FA NULL
#define GENESIS_PLUS_GX_ADDR_ERROR_INFO_0_FA NULL
#define GENESIS_PLUS_GX_CD_LATENCY_LABEL_FA NULL
#define GENESIS_PLUS_GX_CD_LATENCY_INFO_0_FA NULL
#define GENESIS_PLUS_GX_CD_PRECACHE_LABEL_FA NULL
#define GENESIS_PLUS_GX_CD_PRECACHE_INFO_0_FA NULL
#define GENESIS_PLUS_GX_SHOW_ADVANCED_AUDIO_SETTINGS_LABEL_FA NULL
#define GENESIS_PLUS_GX_SHOW_ADVANCED_AUDIO_SETTINGS_INFO_0_FA NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_0_VOLUME_LABEL_FA NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_0_VOLUME_INFO_0_FA NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_1_VOLUME_LABEL_FA NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_1_VOLUME_INFO_0_FA NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_2_VOLUME_LABEL_FA NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_2_VOLUME_INFO_0_FA NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_3_VOLUME_LABEL_FA NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_3_VOLUME_INFO_0_FA NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_0_VOLUME_LABEL_FA NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_0_VOLUME_INFO_0_FA NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_1_VOLUME_LABEL_FA NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_1_VOLUME_INFO_0_FA NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_2_VOLUME_LABEL_FA NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_2_VOLUME_INFO_0_FA NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_3_VOLUME_LABEL_FA NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_3_VOLUME_INFO_0_FA NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_4_VOLUME_LABEL_FA NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_4_VOLUME_INFO_0_FA NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_5_VOLUME_LABEL_FA NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_5_VOLUME_INFO_0_FA NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_0_VOLUME_LABEL_FA NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_0_VOLUME_INFO_0_FA NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_1_VOLUME_LABEL_FA NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_1_VOLUME_INFO_0_FA NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_2_VOLUME_LABEL_FA NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_2_VOLUME_INFO_0_FA NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_3_VOLUME_LABEL_FA NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_3_VOLUME_INFO_0_FA NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_4_VOLUME_LABEL_FA NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_4_VOLUME_INFO_0_FA NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_5_VOLUME_LABEL_FA NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_5_VOLUME_INFO_0_FA NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_6_VOLUME_LABEL_FA NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_6_VOLUME_INFO_0_FA NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_7_VOLUME_LABEL_FA NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_7_VOLUME_INFO_0_FA NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_8_VOLUME_LABEL_FA NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_8_VOLUME_INFO_0_FA NULL

struct retro_core_option_v2_category option_cats_fa[] = {
   {
      "system",
      CATEGORY_SYSTEM_LABEL_FA,
      CATEGORY_SYSTEM_INFO_0_FA
   },
   {
      "video",
      CATEGORY_VIDEO_LABEL_FA,
      CATEGORY_VIDEO_INFO_0_FA
   },
   {
      "audio",
      CATEGORY_AUDIO_LABEL_FA,
      CATEGORY_AUDIO_INFO_0_FA
   },
   {
      "input",
      CATEGORY_INPUT_LABEL_FA,
      CATEGORY_INPUT_INFO_0_FA
   },
   {
      "hacks",
      CATEGORY_HACKS_LABEL_FA,
      CATEGORY_HACKS_INFO_0_FA
   },
   {
      "channel_volume",
      CATEGORY_CHANNEL_VOLUME_LABEL_FA,
      CATEGORY_CHANNEL_VOLUME_INFO_0_FA
   },
   { NULL, NULL, NULL },
};
struct retro_core_option_v2_definition option_defs_fa[] = {
   {
      "genesis_plus_gx_system_hw",
      GENESIS_PLUS_GX_SYSTEM_HW_LABEL_FA,
      NULL,
      GENESIS_PLUS_GX_SYSTEM_HW_INFO_0_FA,
      NULL,
      "system",
      {
         { "auto",                 OPTION_VAL_AUTO_FA                 },
         { "sg-1000",              OPTION_VAL_SG_1000_FA              },
         { "sg-1000 II",           OPTION_VAL_SG_1000_II_FA           },
         { "sg-1000 II + ram ext.",OPTION_VAL_SG_1000_II_RAM_EXT_FA},
         { "mark-III",             OPTION_VAL_MARK_III_FA             },
         { "master system",        OPTION_VAL_MASTER_SYSTEM_FA        },
         { "master system II",     OPTION_VAL_MASTER_SYSTEM_II_FA     },
         { "game gear",            OPTION_VAL_GAME_GEAR_FA            },
         { "mega drive / genesis", OPTION_VAL_MEGA_DRIVE_GENESIS_FA   },
         { NULL, NULL },
      },
      "auto"
   },
   {
      "genesis_plus_gx_region_detect",
      GENESIS_PLUS_GX_REGION_DETECT_LABEL_FA,
      NULL,
      GENESIS_PLUS_GX_REGION_DETECT_INFO_0_FA,
      NULL,
      "system",
      {
         { "auto",    OPTION_VAL_AUTO_FA   },
         { "ntsc-u",  OPTION_VAL_NTSC_U_FA },
         { "pal",     OPTION_VAL_PAL_FA    },
         { "ntsc-j",  OPTION_VAL_NTSC_J_FA },
         { NULL, NULL },
      },
      "auto"
   },
   {
      "genesis_plus_gx_vdp_mode",
      GENESIS_PLUS_GX_VDP_MODE_LABEL_FA,
      NULL,
      GENESIS_PLUS_GX_VDP_MODE_INFO_0_FA,
      NULL,
      "system",
      {
         { "auto",  "Disabled" },
         { "60hz",  OPTION_VAL_60HZ_FA },
         { "50hz",  OPTION_VAL_50HZ_FA },
         { NULL, NULL },
      },
      "auto"
   },
   {
      "genesis_plus_gx_bios",
      GENESIS_PLUS_GX_BIOS_LABEL_FA,
      NULL,
      GENESIS_PLUS_GX_BIOS_INFO_0_FA,
      NULL,
      "system",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_system_bram",
      GENESIS_PLUS_GX_SYSTEM_BRAM_LABEL_FA,
      NULL,
      GENESIS_PLUS_GX_SYSTEM_BRAM_INFO_0_FA,
      NULL,
      "system",
      {
         { "per bios", OPTION_VAL_PER_BIOS_FA },
         { "per game", OPTION_VAL_PER_GAME_FA },
         { NULL, NULL },
      },
      "per bios"
   },
   {
      "genesis_plus_gx_cart_bram",
      GENESIS_PLUS_GX_CART_BRAM_LABEL_FA,
      NULL,
      GENESIS_PLUS_GX_CART_BRAM_INFO_0_FA,
      NULL,
      "system",
      {
         { "per cart", OPTION_VAL_PER_CART_FA },
         { "per game", OPTION_VAL_PER_GAME_FA },
         { NULL, NULL },
      },
      "per cart"
   },
   {
      "genesis_plus_gx_cart_size",
      GENESIS_PLUS_GX_CART_SIZE_LABEL_FA,
      NULL,
      GENESIS_PLUS_GX_CART_SIZE_INFO_0_FA,
      NULL,
      "system",
      {
         { "disabled", "Disabled" },
         { "128k",     OPTION_VAL_128K_FA  },
         { "256k",     OPTION_VAL_256K_FA  },
         { "512k",     OPTION_VAL_512K_FA  },
         { "1meg",     OPTION_VAL_1MEG_FA    },
         { "2meg",     OPTION_VAL_2MEG_FA    },
         { "4meg",     OPTION_VAL_4MEG_FA    },
         { NULL, NULL },
      },
      "4meg"
   },
   {
      "genesis_plus_gx_add_on",
      GENESIS_PLUS_GX_ADD_ON_LABEL_FA,
      NULL,
      GENESIS_PLUS_GX_ADD_ON_INFO_0_FA,
      NULL,
      "system",
      {
         { "auto",         OPTION_VAL_AUTO_FA },
         { "sega/mega cd", OPTION_VAL_SEGA_MEGA_CD_FA },
         { "megasd",       OPTION_VAL_MEGASD_FA },
         { "none",         OPTION_VAL_NONE_FA },
         { NULL, NULL },
      },
      "auto"
   },
   {
      "genesis_plus_gx_lock_on",
      GENESIS_PLUS_GX_LOCK_ON_LABEL_FA,
      NULL,
      GENESIS_PLUS_GX_LOCK_ON_INFO_0_FA,
      NULL,
      "system",
      {
         { "disabled",            NULL },
         { "game genie",          OPTION_VAL_GAME_GENIE_FA },
         { "action replay (pro)", OPTION_VAL_ACTION_REPLAY_PRO_FA },
         { "sonic & knuckles",    OPTION_VAL_SONIC_KNUCKLES_FA },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_aspect_ratio",
      GENESIS_PLUS_GX_ASPECT_RATIO_LABEL_FA,
      NULL,
      GENESIS_PLUS_GX_ASPECT_RATIO_INFO_0_FA,
      NULL,
      "video",
      {
         { "auto",     OPTION_VAL_AUTO_FA },
         { "NTSC PAR", OPTION_VAL_NTSC_PAR_FA },
         { "PAL PAR",  OPTION_VAL_PAL_PAR_FA },
         { "4:3",  OPTION_VAL_4_3_FA },
         { "Uncorrected",  OPTION_VAL_UNCORRECTED_FA },
      },
      "auto"
   },
   {
      "genesis_plus_gx_overscan",
      GENESIS_PLUS_GX_OVERSCAN_LABEL_FA,
      NULL,
      GENESIS_PLUS_GX_OVERSCAN_INFO_0_FA,
      NULL,
      "video",
      {
         { "disabled",   NULL },
         { "top/bottom", OPTION_VAL_TOP_BOTTOM_FA },
         { "left/right", OPTION_VAL_LEFT_RIGHT_FA },
         { "full",       OPTION_VAL_FULL_FA },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_left_border",
      GENESIS_PLUS_GX_LEFT_BORDER_LABEL_FA,
      NULL,
      GENESIS_PLUS_GX_LEFT_BORDER_INFO_0_FA,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "left border", OPTION_VAL_LEFT_BORDER_FA },
         { "left & right borders", OPTION_VAL_LEFT_RIGHT_BORDERS_FA },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_gg_extra",
      GENESIS_PLUS_GX_GG_EXTRA_LABEL_FA,
      NULL,
      GENESIS_PLUS_GX_GG_EXTRA_INFO_0_FA,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_blargg_ntsc_filter",
      GENESIS_PLUS_GX_BLARGG_NTSC_FILTER_LABEL_FA,
      NULL,
      GENESIS_PLUS_GX_BLARGG_NTSC_FILTER_INFO_0_FA,
      NULL,
      "video",
      {
         { "disabled",   NULL },
         { "monochrome", OPTION_VAL_MONOCHROME_FA },
         { "composite",  OPTION_VAL_COMPOSITE_FA },
         { "svideo",     OPTION_VAL_SVIDEO_FA },
         { "rgb",        OPTION_VAL_RGB_FA },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_lcd_filter",
      GENESIS_PLUS_GX_LCD_FILTER_LABEL_FA,
      NULL,
      GENESIS_PLUS_GX_LCD_FILTER_INFO_0_FA,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_render",
      GENESIS_PLUS_GX_RENDER_LABEL_FA,
      NULL,
      GENESIS_PLUS_GX_RENDER_INFO_0_FA,
      NULL,
      "video",
      {
         { "single field", OPTION_VAL_SINGLE_FIELD_FA },
         { "double field", OPTION_VAL_DOUBLE_FIELD_FA },
         { NULL, NULL },
      },
      "single field"
   },
   {
      "genesis_plus_gx_frameskip",
      GENESIS_PLUS_GX_FRAMESKIP_LABEL_FA,
      NULL,
      GENESIS_PLUS_GX_FRAMESKIP_INFO_0_FA,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "auto",     OPTION_VAL_AUTO_FA },
         { "manual",   OPTION_VAL_MANUAL_FA },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_frameskip_threshold",
      GENESIS_PLUS_GX_FRAMESKIP_THRESHOLD_LABEL_FA,
      NULL,
      GENESIS_PLUS_GX_FRAMESKIP_THRESHOLD_INFO_0_FA,
      NULL,
      "video",
      {
         { "15", NULL },
         { "18", NULL },
         { "21", NULL },
         { "24", NULL },
         { "27", NULL },
         { "30", NULL },
         { "33", NULL },
         { "36", NULL },
         { "39", NULL },
         { "42", NULL },
         { "45", NULL },
         { "48", NULL },
         { "51", NULL },
         { "54", NULL },
         { "57", NULL },
         { "60", NULL },
         { NULL, NULL },
      },
      "33"
   },
   {
      "genesis_plus_gx_ym2413",
      GENESIS_PLUS_GX_YM2413_LABEL_FA,
      NULL,
      GENESIS_PLUS_GX_YM2413_INFO_0_FA,
      NULL,
      "audio",
      {
         { "auto",     OPTION_VAL_AUTO_FA },
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "auto"
   },
#ifdef HAVE_OPLL_CORE
   {
      "genesis_plus_gx_ym2413_core",
      GENESIS_PLUS_GX_YM2413_CORE_LABEL_FA,
      NULL,
      GENESIS_PLUS_GX_YM2413_CORE_INFO_0_FA,
      NULL,
      "audio",
      {
         { "mame",  OPTION_VAL_MAME_FA },
         { "nuked", OPTION_VAL_NUKED_FA },
         { NULL, NULL },
      },
      "mame"
   },
#endif
   {
      "genesis_plus_gx_ym2612",
      GENESIS_PLUS_GX_YM2612_LABEL_FA,
      NULL,
#ifdef HAVE_YM3438_CORE
      GENESIS_PLUS_GX_YM2612_INFO_0_FA,
#else
      GENESIS_PLUS_GX_YM2612_INFO_1_FA,
#endif
      NULL,
      "audio",
      {
         { "mame (ym2612)",          OPTION_VAL_MAME_YM2612_FA },
         { "mame (asic ym3438)",     OPTION_VAL_MAME_ASIC_YM3438_FA },
         { "mame (enhanced ym3438)", OPTION_VAL_MAME_ENHANCED_YM3438_FA },
#ifdef HAVE_YM3438_CORE
         { "nuked (ym2612)",         OPTION_VAL_NUKED_YM2612_FA },
         { "nuked (ym3438)",         OPTION_VAL_NUKED_YM3438_FA },
#endif
         { NULL, NULL },
      },
      "mame (ym2612)"
   },
   {
      "genesis_plus_gx_sound_output",
      GENESIS_PLUS_GX_SOUND_OUTPUT_LABEL_FA,
      NULL,
      GENESIS_PLUS_GX_SOUND_OUTPUT_INFO_0_FA,
      NULL,
      "audio",
      {
         { "stereo", OPTION_VAL_STEREO_FA },
         { "mono",   OPTION_VAL_MONO_FA },
         { NULL, NULL },
      },
      "stereo"
   },
   {
      "genesis_plus_gx_audio_filter",
      GENESIS_PLUS_GX_AUDIO_FILTER_LABEL_FA,
      NULL,
      GENESIS_PLUS_GX_AUDIO_FILTER_INFO_0_FA,
      NULL,
      "audio",
      {
         { "disabled", NULL },
         { "low-pass", OPTION_VAL_LOW_PASS_FA },
#ifdef HAVE_EQ
         { "EQ",       OPTION_VAL_EQ_FA },
#endif
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_lowpass_range",
      GENESIS_PLUS_GX_LOWPASS_RANGE_LABEL_FA,
      NULL,
      GENESIS_PLUS_GX_LOWPASS_RANGE_INFO_0_FA,
      NULL,
      "audio",
      {
         { "5",  NULL },
         { "10", NULL },
         { "15", NULL },
         { "20", NULL },
         { "25", NULL },
         { "30", NULL },
         { "35", NULL },
         { "40", NULL },
         { "45", NULL },
         { "50", NULL },
         { "55", NULL },
         { "60", NULL },
         { "65", NULL },
         { "70", NULL },
         { "75", NULL },
         { "80", NULL },
         { "85", NULL },
         { "90", NULL },
         { "95", NULL },
         { NULL, NULL },
      },
      "60"
   },
   {
      "genesis_plus_gx_psg_preamp",
      GENESIS_PLUS_GX_PSG_PREAMP_LABEL_FA,
      NULL,
      GENESIS_PLUS_GX_PSG_PREAMP_INFO_0_FA,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { "105", NULL },
         { "110", NULL },
         { "115", NULL },
         { "120", NULL },
         { "125", NULL },
         { "130", NULL },
         { "135", NULL },
         { "140", NULL },
         { "145", NULL },
         { "150", NULL },
         { "155", NULL },
         { "160", NULL },
         { "165", NULL },
         { "170", NULL },
         { "175", NULL },
         { "180", NULL },
         { "185", NULL },
         { "190", NULL },
         { "195", NULL },
         { "200", NULL },
         { NULL, NULL },
      },
      "150"
   },
   {
      "genesis_plus_gx_fm_preamp",
      GENESIS_PLUS_GX_FM_PREAMP_LABEL_FA,
      NULL,
      GENESIS_PLUS_GX_FM_PREAMP_INFO_0_FA,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { "105", NULL },
         { "110", NULL },
         { "115", NULL },
         { "120", NULL },
         { "125", NULL },
         { "130", NULL },
         { "135", NULL },
         { "140", NULL },
         { "145", NULL },
         { "150", NULL },
         { "155", NULL },
         { "160", NULL },
         { "165", NULL },
         { "170", NULL },
         { "175", NULL },
         { "180", NULL },
         { "185", NULL },
         { "190", NULL },
         { "195", NULL },
         { "200", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_cdda_volume",
      GENESIS_PLUS_GX_CDDA_VOLUME_LABEL_FA,
      NULL,
      GENESIS_PLUS_GX_CDDA_VOLUME_INFO_0_FA,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_pcm_volume",
      GENESIS_PLUS_GX_PCM_VOLUME_LABEL_FA,
      NULL,
      GENESIS_PLUS_GX_PCM_VOLUME_INFO_0_FA,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
#ifdef HAVE_EQ
   {
      "genesis_plus_gx_audio_eq_low",
      GENESIS_PLUS_GX_AUDIO_EQ_LOW_LABEL_FA,
      NULL,
      GENESIS_PLUS_GX_AUDIO_EQ_LOW_INFO_0_FA,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_audio_eq_mid",
      GENESIS_PLUS_GX_AUDIO_EQ_MID_LABEL_FA,
      NULL,
      GENESIS_PLUS_GX_AUDIO_EQ_MID_INFO_0_FA,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_audio_eq_high",
      GENESIS_PLUS_GX_AUDIO_EQ_HIGH_LABEL_FA,
      NULL,
      GENESIS_PLUS_GX_AUDIO_EQ_HIGH_INFO_0_FA,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
#endif
   {
      "genesis_plus_gx_gun_input",
      GENESIS_PLUS_GX_GUN_INPUT_LABEL_FA,
      NULL,
      GENESIS_PLUS_GX_GUN_INPUT_INFO_0_FA,
      NULL,
      "input",
      {
         { "lightgun",    OPTION_VAL_LIGHTGUN_FA },
         { "touchscreen", OPTION_VAL_TOUCHSCREEN_FA },
         { NULL, NULL },
      },
      "lightgun"
   },
   {
      "genesis_plus_gx_gun_cursor",
      GENESIS_PLUS_GX_GUN_CURSOR_LABEL_FA,
      NULL,
      GENESIS_PLUS_GX_GUN_CURSOR_INFO_0_FA,
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_invert_mouse",
      GENESIS_PLUS_GX_INVERT_MOUSE_LABEL_FA,
      NULL,
      GENESIS_PLUS_GX_INVERT_MOUSE_INFO_0_FA,
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_no_sprite_limit",
      GENESIS_PLUS_GX_NO_SPRITE_LIMIT_LABEL_FA,
      NULL,
      GENESIS_PLUS_GX_NO_SPRITE_LIMIT_INFO_0_FA,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_enhanced_vscroll",
      GENESIS_PLUS_GX_ENHANCED_VSCROLL_LABEL_FA,
      NULL,
      GENESIS_PLUS_GX_ENHANCED_VSCROLL_INFO_0_FA,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_enhanced_vscroll_limit",
      GENESIS_PLUS_GX_ENHANCED_VSCROLL_LIMIT_LABEL_FA,
      NULL,
      GENESIS_PLUS_GX_ENHANCED_VSCROLL_LIMIT_INFO_0_FA,
      NULL,
      "hacks",
      {
         { "2", NULL },
         { "3",  NULL },
         { "4", NULL },
         { "5",  NULL },
         { "6", NULL },
         { "7",  NULL },
         { "8", NULL },
         { "9",  NULL },
         { "10", NULL },
         { "11",  NULL },
         { "12", NULL },
         { "13",  NULL },
         { "14", NULL },
         { "15",  NULL },
         { "16", NULL },
         { NULL, NULL },
      },
      "8"
   },
#ifdef HAVE_OVERCLOCK
   {
      "genesis_plus_gx_overclock",
      GENESIS_PLUS_GX_OVERCLOCK_LABEL_FA,
      NULL,
      GENESIS_PLUS_GX_OVERCLOCK_INFO_0_FA,
      NULL,
      "hacks",
      {
         { "100", OPTION_VAL_100_FA },
         { "125", OPTION_VAL_125_FA },
         { "150", OPTION_VAL_150_FA },
         { "175", OPTION_VAL_175_FA },
         { "200", OPTION_VAL_200_FA },
         { "225", OPTION_VAL_225_FA },
         { "250", OPTION_VAL_250_FA },
         { "275", OPTION_VAL_275_FA },
         { "300", OPTION_VAL_300_FA },
         { "325", OPTION_VAL_325_FA },
         { "350", OPTION_VAL_350_FA },
         { "375", OPTION_VAL_375_FA },
         { "400", OPTION_VAL_400_FA },
         { "425", OPTION_VAL_425_FA },
         { "450", OPTION_VAL_450_FA },
         { "475", OPTION_VAL_475_FA },
         { "500", OPTION_VAL_500_FA },
         { NULL, NULL },
      },
      "100%"
   },
#endif
   {
      "genesis_plus_gx_force_dtack",
      GENESIS_PLUS_GX_FORCE_DTACK_LABEL_FA,
      NULL,
      GENESIS_PLUS_GX_FORCE_DTACK_INFO_0_FA,
      NULL,
      "hacks",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL },
      },
      "enabled"
   },
   {
      "genesis_plus_gx_addr_error",
      GENESIS_PLUS_GX_ADDR_ERROR_LABEL_FA,
      NULL,
      GENESIS_PLUS_GX_ADDR_ERROR_INFO_0_FA,
      NULL,
      "hacks",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL },
      },
      "enabled"
   },
   {
      "genesis_plus_gx_cd_latency",
      GENESIS_PLUS_GX_CD_LATENCY_LABEL_FA,
      NULL,
      GENESIS_PLUS_GX_CD_LATENCY_INFO_0_FA,
      NULL,
      "hacks",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL },
      },
      "enabled"
   },
   {
      "genesis_plus_gx_cd_precache",
      GENESIS_PLUS_GX_CD_PRECACHE_LABEL_FA,
      NULL,
      GENESIS_PLUS_GX_CD_PRECACHE_INFO_0_FA,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
#ifdef USE_PER_SOUND_CHANNELS_CONFIG
   {
      "genesis_plus_gx_show_advanced_audio_settings",
      GENESIS_PLUS_GX_SHOW_ADVANCED_AUDIO_SETTINGS_LABEL_FA,
      NULL,
      GENESIS_PLUS_GX_SHOW_ADVANCED_AUDIO_SETTINGS_INFO_0_FA,
      NULL,
      "channel_volume",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL},
      },
      "disabled"
   },
   {
      "genesis_plus_gx_psg_channel_0_volume",
      GENESIS_PLUS_GX_PSG_CHANNEL_0_VOLUME_LABEL_FA,
      NULL,
      GENESIS_PLUS_GX_PSG_CHANNEL_0_VOLUME_INFO_0_FA,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_psg_channel_1_volume",
      GENESIS_PLUS_GX_PSG_CHANNEL_1_VOLUME_LABEL_FA,
      NULL,
      GENESIS_PLUS_GX_PSG_CHANNEL_1_VOLUME_INFO_0_FA,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_psg_channel_2_volume",
      GENESIS_PLUS_GX_PSG_CHANNEL_2_VOLUME_LABEL_FA,
      NULL,
      GENESIS_PLUS_GX_PSG_CHANNEL_2_VOLUME_INFO_0_FA,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_psg_channel_3_volume",
      GENESIS_PLUS_GX_PSG_CHANNEL_3_VOLUME_LABEL_FA,
      NULL,
      GENESIS_PLUS_GX_PSG_CHANNEL_3_VOLUME_INFO_0_FA,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_0_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_0_VOLUME_LABEL_FA,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_0_VOLUME_INFO_0_FA,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_1_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_1_VOLUME_LABEL_FA,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_1_VOLUME_INFO_0_FA,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_2_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_2_VOLUME_LABEL_FA,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_2_VOLUME_INFO_0_FA,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_3_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_3_VOLUME_LABEL_FA,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_3_VOLUME_INFO_0_FA,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_4_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_4_VOLUME_LABEL_FA,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_4_VOLUME_INFO_0_FA,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_5_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_5_VOLUME_LABEL_FA,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_5_VOLUME_INFO_0_FA,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_0_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_0_VOLUME_LABEL_FA,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_0_VOLUME_INFO_0_FA,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_1_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_1_VOLUME_LABEL_FA,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_1_VOLUME_INFO_0_FA,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_2_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_2_VOLUME_LABEL_FA,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_2_VOLUME_INFO_0_FA,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_3_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_3_VOLUME_LABEL_FA,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_3_VOLUME_INFO_0_FA,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_4_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_4_VOLUME_LABEL_FA,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_4_VOLUME_INFO_0_FA,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_5_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_5_VOLUME_LABEL_FA,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_5_VOLUME_INFO_0_FA,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_6_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_6_VOLUME_LABEL_FA,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_6_VOLUME_INFO_0_FA,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_7_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_7_VOLUME_LABEL_FA,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_7_VOLUME_INFO_0_FA,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_8_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_8_VOLUME_LABEL_FA,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_8_VOLUME_INFO_0_FA,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
#endif
   { NULL, NULL, NULL, NULL, NULL, NULL, {{0}}, NULL },
};
struct retro_core_options_v2 options_fa = {
   option_cats_fa,
   option_defs_fa
};

/* RETRO_LANGUAGE_FI */

#define CATEGORY_SYSTEM_LABEL_FI "Järjestelmä"
#define CATEGORY_SYSTEM_INFO_0_FI "Vaihda peruslaitteiston valintaa, aluetta, BIOS ja Sega-CD/Mega-CD tallennustiedoston asetuksia."
#define CATEGORY_VIDEO_LABEL_FI NULL
#define CATEGORY_VIDEO_INFO_0_FI "Muuta kuvasuhdetta, näytön rajausta, videosuodatusta ja kuvanohitusasetuksia."
#define CATEGORY_AUDIO_LABEL_FI "Ääni"
#define CATEGORY_AUDIO_INFO_0_FI "Muuta äänilaitteen asetuksia."
#define CATEGORY_INPUT_LABEL_FI "Syöte"
#define CATEGORY_INPUT_INFO_0_FI "Muuta \"Light gun\" ja/tai hiiren syötön asetuksia"
#define CATEGORY_HACKS_LABEL_FI "Emulointikikat"
#define CATEGORY_HACKS_INFO_0_FI "Muuta prosessorin ylikellotus- ja emulointitarkkuusasetuksia, jotka vaikuttavat matalan tason suorituskykyyn ja yhteensopivuuteen."
#define CATEGORY_CHANNEL_VOLUME_LABEL_FI "Kanavan äänenvoimakkuuden lisäasetukset"
#define CATEGORY_CHANNEL_VOLUME_INFO_0_FI "Muuta yksittäisten laitteistoäänikanavien äänenvoimakkuutta."
#define GENESIS_PLUS_GX_SYSTEM_HW_LABEL_FI "Järjestelmä laitteisto"
#define GENESIS_PLUS_GX_SYSTEM_HW_INFO_0_FI "Suorittaa ladattua sisältöä tietyllä emuloidulla konsolilla. \"Autotomaattinen\" valitsee sopivimman järjestelmän nykyiselle pelille."
#define OPTION_VAL_AUTO_FI "Automaattinen"
#define OPTION_VAL_SG_1000_FI NULL
#define OPTION_VAL_SG_1000_II_FI NULL
#define OPTION_VAL_SG_1000_II_RAM_EXT_FI "SG-1000 II + Lisä-RAM-moduuli"
#define OPTION_VAL_MARK_III_FI NULL
#define OPTION_VAL_MASTER_SYSTEM_FI NULL
#define OPTION_VAL_MASTER_SYSTEM_II_FI NULL
#define OPTION_VAL_GAME_GEAR_FI NULL
#define OPTION_VAL_MEGA_DRIVE_GENESIS_FI NULL
#define GENESIS_PLUS_GX_REGION_DETECT_LABEL_FI "Järjestelmän alue"
#define GENESIS_PLUS_GX_REGION_DETECT_INFO_0_FI "Määritä, miltä alueelta järjestelmä on. Muille konsoleille kuin Game Gear, \"PAL\" on 50 Hz, kun taas \"NTSC\" 60 Hz. Pelit saattavat pyöriä nopeammin tai hitaammin jos väärä alue on valittu."
#define OPTION_VAL_NTSC_U_FI NULL
#define OPTION_VAL_PAL_FI NULL
#define OPTION_VAL_NTSC_J_FI NULL
#define GENESIS_PLUS_GX_VDP_MODE_LABEL_FI "Pakota VDP-tila"
#define GENESIS_PLUS_GX_VDP_MODE_INFO_0_FI NULL
#define OPTION_VAL_60HZ_FI "NTSC (60 Hz)"
#define OPTION_VAL_50HZ_FI "PAL (50 Hz)"
#define GENESIS_PLUS_GX_BIOS_LABEL_FI "Järjestelmän käynnistys ROM"
#define GENESIS_PLUS_GX_BIOS_INFO_0_FI "Käytä virallista BIOS/bootloader-ohjelmaa emuloiduille laitteelle, jos sellainen löytyy RetroArchin järjestelmäkansiosta. Näyttää konsolikohtaisen käynnistyslatauksen/animaation ja ajaa sitten ladatun sisällön."
#define GENESIS_PLUS_GX_SYSTEM_BRAM_LABEL_FI "CD-järjestelmän BRAM (uudelleenkäynnistys vaaditaan)"
#define GENESIS_PLUS_GX_SYSTEM_BRAM_INFO_0_FI "Määrittää Sega CD- ja Mega-CD:n sisältöä ajettaessa, jaetaanko yksi tallennustiedoston tietyn alueen kaikkien pelien välillä (BIOS-kohtainen) vai luodaanko jokaiselle pelille erillinen tallennustiedosto (Pelikohtainen). Huomaa, että Sega CD/Mega-CD:llä on rajallinen sisäinen tallennustila, riittäen vain muutamiin peleihin. Jotta tallennustila ei loppuisi, suositellaan \"Pelikohtainen\" asetusta."
#define OPTION_VAL_PER_BIOS_FI "BIOS-kohtainen"
#define OPTION_VAL_PER_GAME_FI "Pelikohtainen"
#define GENESIS_PLUS_GX_CART_BRAM_LABEL_FI "CD-järjestelmän varmuuskopio kasetin BRAM (uudelleenkäynnistys vaaditaan)"
#define GENESIS_PLUS_GX_CART_BRAM_INFO_0_FI "Määrittelee Sega CD- ja Mega-CD-sisältöä ajettaessa, jaetaanko yksi varmuuskopio RAM-kasetti kaikille peleille (Kasettikohtainen) vai luodaanko erillinen varmuuskopio RAM-kasetti jokaiselle pelille (Pelikohtainen)."
#define OPTION_VAL_PER_CART_FI "Kasettikohtainen"
#define GENESIS_PLUS_GX_CART_SIZE_LABEL_FI "CD-varmuuskopiokasetin BRAM-koko (Uudelleenkäynnistys vaaditaan)"
#define GENESIS_PLUS_GX_CART_SIZE_INFO_0_FI "Valitse varmuuskopiokasetin koko, kun ajetaan Sega CD/Mega-CD sisältöä. Hyödyllinen, kun asetetaan varmuuskopiokasetti pelikohtaiseksi, jolloin voidaan välttää useita suuria kasetteja."
#define OPTION_VAL_128K_FI "128 kbit"
#define OPTION_VAL_256K_FI "256 kbit"
#define OPTION_VAL_512K_FI "512 kbit"
#define OPTION_VAL_1MEG_FI "1 Mbit"
#define OPTION_VAL_2MEG_FI "2 Mbit"
#define OPTION_VAL_4MEG_FI "4 Mbit"
#define GENESIS_PLUS_GX_ADD_ON_LABEL_FI "CD-lisäosa (MD-tila) (vaatii uudelleenkäynnistyksen)"
#define GENESIS_PLUS_GX_ADD_ON_INFO_0_FI "Märittelee, mitä lisäosaa käytetään CD:n audio toistamiseen tuetuilla Mega Drive/Genesis -peleillä."
#define OPTION_VAL_SEGA_MEGA_CD_FI "Sega/Mega-CD"
#define OPTION_VAL_MEGASD_FI NULL
#define OPTION_VAL_NONE_FI "Ei mitään"
#define GENESIS_PLUS_GX_LOCK_ON_LABEL_FI "Lock-On -kasetti"
#define GENESIS_PLUS_GX_LOCK_ON_INFO_0_FI "Lock-On Technology on Mega Drive/Genesis -toiminto, joka sallii vanhemman pelin muodostaa yhteyden erityisen kasetin läpikulkuporttiin laajennettua tai muutettua pelattavuutta varten. Tämä valinta määrittelee, minkä tyyppistä '\"lock-on\" kasettia emuloidaan. Vastaavan bios-tiedoston on oltava RetroArchin järjestelmäkansiossa."
#define OPTION_VAL_GAME_GENIE_FI NULL
#define OPTION_VAL_ACTION_REPLAY_PRO_FI NULL
#define OPTION_VAL_SONIC_KNUCKLES_FI NULL
#define GENESIS_PLUS_GX_ASPECT_RATIO_LABEL_FI "Ytimen määrittämä kuvasuhde"
#define GENESIS_PLUS_GX_ASPECT_RATIO_INFO_0_FI "Valitse haluamasi sisällön kuvasuhde. Tämä pätee vain kun RetroArchin kuvasuhde on asetettu videoasetuksissa \"Ytimen asettama\"."
#define OPTION_VAL_NTSC_PAR_FI NULL
#define OPTION_VAL_PAL_PAR_FI NULL
#define OPTION_VAL_4_3_FI NULL
#define OPTION_VAL_UNCORRECTED_FI "Ei korjattu"
#define GENESIS_PLUS_GX_OVERSCAN_LABEL_FI "Reunukset"
#define GENESIS_PLUS_GX_OVERSCAN_INFO_0_FI "Ota tämä käyttöön näyttääksesi näytön ylä-, ala- ja/tai vasemman/oikeanpuoleiset yliskannauksen alueet. Tavallisesti ne on piilossa keyksissä, joka on standardin mukaan määritellyn television reunan takana."
#define OPTION_VAL_TOP_BOTTOM_FI "Ylä/Ala"
#define OPTION_VAL_LEFT_RIGHT_FI "Vasen/Oikea"
#define OPTION_VAL_FULL_FI "Täysi"
#define GENESIS_PLUS_GX_LEFT_BORDER_LABEL_FI "Piilota Master Systemin sivurajat"
#define GENESIS_PLUS_GX_LEFT_BORDER_INFO_0_FI "Leikkaa 8 pikseliä näytön vasemmalta puolelta tai vasemmalta että oikealta puolelta, kun ajetaan Master System -pelejä."
#define OPTION_VAL_LEFT_BORDER_FI "Vain vasen reuna"
#define OPTION_VAL_LEFT_RIGHT_BORDERS_FI "Vasen ja oikea reuna"
#define GENESIS_PLUS_GX_GG_EXTRA_LABEL_FI "Game Gear laajennettu näyttö"
#define GENESIS_PLUS_GX_GG_EXTRA_INFO_0_FI "Pakottaa Game Gear pelit ajettavaksi SMS-tilassa, lisääntyneellä 256 x 192 resoluutiolla. Saattaa näyttää ylimääräistä sisältöä, mutta usein näyttää vain rajan korruptoituneita/ei-toivottuja kuvatietoja."
#define GENESIS_PLUS_GX_BLARGG_NTSC_FILTER_LABEL_FI "Blargg NTSC suodatin"
#define GENESIS_PLUS_GX_BLARGG_NTSC_FILTER_INFO_0_FI "Käytä videosuodatinta erilaisten NTSC TV-signaalien jäljittelemiseen."
#define OPTION_VAL_MONOCHROME_FI "Yksivärinen"
#define OPTION_VAL_COMPOSITE_FI "Komposiitti"
#define OPTION_VAL_SVIDEO_FI NULL
#define OPTION_VAL_RGB_FI NULL
#define GENESIS_PLUS_GX_LCD_FILTER_LABEL_FI "LCD Ghosting -suodatin"
#define GENESIS_PLUS_GX_LCD_FILTER_INFO_0_FI "Käytä \"ghosting\" kuva suodatinta jäljittelemään Game Gear ja Genesis Nomad LCD-näyttöpaneelien ominaisuuksia."
#define GENESIS_PLUS_GX_RENDER_LABEL_FI NULL
#define GENESIS_PLUS_GX_RENDER_INFO_0_FI NULL
#define OPTION_VAL_SINGLE_FIELD_FI NULL
#define OPTION_VAL_DOUBLE_FIELD_FI NULL
#define GENESIS_PLUS_GX_FRAMESKIP_LABEL_FI "Kuvanohitus"
#define GENESIS_PLUS_GX_FRAMESKIP_INFO_0_FI "Ohita kuvia välttääksesi äänipuskurin ali ajon (säröily). Parantaa suorituskykyä visuaalisen tasaisuuden kustannuksella. \"Automaatti\" ohittaa kehykset käyttöliittymän asetusten mukaan. \"Manuaalinen\" käyttää \"Kuvienohituksen arvo (%)\" -asetusta."
#define OPTION_VAL_MANUAL_FI "Manuaalinen"
#define GENESIS_PLUS_GX_FRAMESKIP_THRESHOLD_LABEL_FI "Kuvienohituksen arvo (%)"
#define GENESIS_PLUS_GX_FRAMESKIP_THRESHOLD_INFO_0_FI "Kun \"kehyksen ohitus\" on asetettu \"manuaaliksi\", määrittää äänipuskuri käyttökynnyksen (prosentteina), jonka alapuolella kehykset ohitetaan. Korkeammat arvot vähentävät särkymisen riskiä siten, että kehykset putoavat useammin."
#define GENESIS_PLUS_GX_YM2413_LABEL_FI NULL
#define GENESIS_PLUS_GX_YM2413_INFO_0_FI "Ota käyttöön tiettyjen Sega Mark III/Master System -pelien käyttämä FM-äänimoduulin emulointi äänen ulostulon ehostamista varten."
#define GENESIS_PLUS_GX_YM2413_CORE_LABEL_FI "Master System FM (YM2413) ydin"
#define GENESIS_PLUS_GX_YM2413_CORE_INFO_0_FI NULL
#define OPTION_VAL_MAME_FI NULL
#define OPTION_VAL_NUKED_FI NULL
#define GENESIS_PLUS_GX_YM2612_LABEL_FI NULL
#define GENESIS_PLUS_GX_YM2612_INFO_0_FI NULL
#define GENESIS_PLUS_GX_YM2612_INFO_1_FI NULL
#define OPTION_VAL_MAME_YM2612_FI NULL
#define OPTION_VAL_MAME_ASIC_YM3438_FI NULL
#define OPTION_VAL_MAME_ENHANCED_YM3438_FI "MAME (Paranneltu YM3438)"
#define OPTION_VAL_NUKED_YM2612_FI NULL
#define OPTION_VAL_NUKED_YM3438_FI NULL
#define GENESIS_PLUS_GX_SOUND_OUTPUT_LABEL_FI "Äänen ulostulo"
#define GENESIS_PLUS_GX_SOUND_OUTPUT_INFO_0_FI "Valitse stereo- tai monoäänen toisto."
#define OPTION_VAL_STEREO_FI NULL
#define OPTION_VAL_MONO_FI NULL
#define GENESIS_PLUS_GX_AUDIO_FILTER_LABEL_FI "Äänisuodatin"
#define GENESIS_PLUS_GX_AUDIO_FILTER_INFO_0_FI "Ota käyttöön alipäästösuodatin simuloidaksesi paremmin Mega Drive/Genesis mallin 1 ääniominaisuuksia."
#define OPTION_VAL_LOW_PASS_FI "Alipäästö"
#define OPTION_VAL_EQ_FI "Taajuuskorjain"
#define GENESIS_PLUS_GX_LOWPASS_RANGE_LABEL_FI "Alipäästösuodatin %"
#define GENESIS_PLUS_GX_LOWPASS_RANGE_INFO_0_FI NULL
#define GENESIS_PLUS_GX_PSG_PREAMP_LABEL_FI NULL
#define GENESIS_PLUS_GX_PSG_PREAMP_INFO_0_FI NULL
#define GENESIS_PLUS_GX_FM_PREAMP_LABEL_FI NULL
#define GENESIS_PLUS_GX_FM_PREAMP_INFO_0_FI NULL
#define GENESIS_PLUS_GX_CDDA_VOLUME_LABEL_FI NULL
#define GENESIS_PLUS_GX_CDDA_VOLUME_INFO_0_FI NULL
#define GENESIS_PLUS_GX_PCM_VOLUME_LABEL_FI "PCM-äänenvoimakkuus"
#define GENESIS_PLUS_GX_PCM_VOLUME_INFO_0_FI NULL
#define GENESIS_PLUS_GX_AUDIO_EQ_LOW_LABEL_FI NULL
#define GENESIS_PLUS_GX_AUDIO_EQ_LOW_INFO_0_FI NULL
#define GENESIS_PLUS_GX_AUDIO_EQ_MID_LABEL_FI NULL
#define GENESIS_PLUS_GX_AUDIO_EQ_MID_INFO_0_FI NULL
#define GENESIS_PLUS_GX_AUDIO_EQ_HIGH_LABEL_FI NULL
#define GENESIS_PLUS_GX_AUDIO_EQ_HIGH_INFO_0_FI NULL
#define GENESIS_PLUS_GX_GUN_INPUT_LABEL_FI "Valoaseen syöte"
#define GENESIS_PLUS_GX_GUN_INPUT_INFO_0_FI NULL
#define OPTION_VAL_LIGHTGUN_FI "Valoase"
#define OPTION_VAL_TOUCHSCREEN_FI "Kosketusnäyttö"
#define GENESIS_PLUS_GX_GUN_CURSOR_LABEL_FI "Näytä valoaseen tähtäin"
#define GENESIS_PLUS_GX_GUN_CURSOR_INFO_0_FI NULL
#define GENESIS_PLUS_GX_INVERT_MOUSE_LABEL_FI NULL
#define GENESIS_PLUS_GX_INVERT_MOUSE_INFO_0_FI NULL
#define GENESIS_PLUS_GX_NO_SPRITE_LIMIT_LABEL_FI NULL
#define GENESIS_PLUS_GX_NO_SPRITE_LIMIT_INFO_0_FI NULL
#define GENESIS_PLUS_GX_ENHANCED_VSCROLL_LABEL_FI NULL
#define GENESIS_PLUS_GX_ENHANCED_VSCROLL_INFO_0_FI NULL
#define GENESIS_PLUS_GX_ENHANCED_VSCROLL_LIMIT_LABEL_FI NULL
#define GENESIS_PLUS_GX_ENHANCED_VSCROLL_LIMIT_INFO_0_FI NULL
#define GENESIS_PLUS_GX_OVERCLOCK_LABEL_FI "Suorittimen nopeus"
#define GENESIS_PLUS_GX_OVERCLOCK_INFO_0_FI "Ylikellotta emuloitua prosessoria. Voi vähentää hidastumista, mutta saattaa aiheuttaa virheitä."
#define OPTION_VAL_100_FI "100 %"
#define OPTION_VAL_125_FI "125 %"
#define OPTION_VAL_150_FI "150 %"
#define OPTION_VAL_175_FI "175 %"
#define OPTION_VAL_200_FI "200 %"
#define OPTION_VAL_225_FI "225 %"
#define OPTION_VAL_250_FI "250 %"
#define OPTION_VAL_275_FI "275 %"
#define OPTION_VAL_300_FI "300 %"
#define OPTION_VAL_325_FI "325 %"
#define OPTION_VAL_350_FI "350 %"
#define OPTION_VAL_375_FI "375 %"
#define OPTION_VAL_400_FI "400 %"
#define OPTION_VAL_425_FI "425 %"
#define OPTION_VAL_450_FI "450 %"
#define OPTION_VAL_475_FI "475 %"
#define OPTION_VAL_500_FI "500 %"
#define GENESIS_PLUS_GX_FORCE_DTACK_LABEL_FI "Järjestelmän lukkiutumiset"
#define GENESIS_PLUS_GX_FORCE_DTACK_INFO_0_FI NULL
#define GENESIS_PLUS_GX_ADDR_ERROR_LABEL_FI "68K-osoitevirhe"
#define GENESIS_PLUS_GX_ADDR_ERROR_INFO_0_FI NULL
#define GENESIS_PLUS_GX_CD_LATENCY_LABEL_FI NULL
#define GENESIS_PLUS_GX_CD_LATENCY_INFO_0_FI "Simuloi alkuperäinen CD-laitteiston lukunopeutta etsiessä tiettyä sijaintia levyltä. Tätä tarvitaan muutamia CD-pelejä varten, jotka kaatuvat, jos CD:n tiedot ovat saatavilla liian pian ja myös korjaa CD:n äänen ajoitusongelmia joissakin peleissä. Tämän poistaminen käytöstä voi olla hyödyllistä MSU-MD-peleissä, koska se tekee CD-ääniraitojen silmukoista saumattomampia."
#define GENESIS_PLUS_GX_CD_PRECACHE_LABEL_FI NULL
#define GENESIS_PLUS_GX_CD_PRECACHE_INFO_0_FI NULL
#define GENESIS_PLUS_GX_SHOW_ADVANCED_AUDIO_SETTINGS_LABEL_FI "Näytä äänenvoimakkuuden lisäasetukset (Avaa valikko uudestaan)"
#define GENESIS_PLUS_GX_SHOW_ADVANCED_AUDIO_SETTINGS_INFO_0_FI "Ota käyttöön alhaisen tason äänikanavan parametrien asetukset. HUOM.: Pikavalikko pitää ottaa käyttöön tämän asetuksen käyttöönottamiseksi."
#define GENESIS_PLUS_GX_PSG_CHANNEL_0_VOLUME_LABEL_FI NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_0_VOLUME_INFO_0_FI NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_1_VOLUME_LABEL_FI NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_1_VOLUME_INFO_0_FI NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_2_VOLUME_LABEL_FI NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_2_VOLUME_INFO_0_FI NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_3_VOLUME_LABEL_FI NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_3_VOLUME_INFO_0_FI NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_0_VOLUME_LABEL_FI "Mega Drive/Genesis FM-kanavan 0 äänenvoimakkuus %"
#define GENESIS_PLUS_GX_MD_CHANNEL_0_VOLUME_INFO_0_FI NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_1_VOLUME_LABEL_FI "Mega Drive/Genesis FM-kanavan 1 äänenvoimakkuus %"
#define GENESIS_PLUS_GX_MD_CHANNEL_1_VOLUME_INFO_0_FI NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_2_VOLUME_LABEL_FI "Mega Drive/Genesis FM-kanavan 2 äänenvoimakkuus %"
#define GENESIS_PLUS_GX_MD_CHANNEL_2_VOLUME_INFO_0_FI NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_3_VOLUME_LABEL_FI "Mega Drive/Genesis FM-kanavan 3 äänenvoimakkuus %"
#define GENESIS_PLUS_GX_MD_CHANNEL_3_VOLUME_INFO_0_FI NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_4_VOLUME_LABEL_FI NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_4_VOLUME_INFO_0_FI NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_5_VOLUME_LABEL_FI NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_5_VOLUME_INFO_0_FI NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_0_VOLUME_LABEL_FI "Master System FM (YM2413) kanavan 0 äänenvoimakkuus %"
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_0_VOLUME_INFO_0_FI "Vähennä Master System FM-kanavan 0 äänenvoimakkuutta."
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_1_VOLUME_LABEL_FI "Master System FM (YM2413) kanavan 1 äänenvoimakkuus %"
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_1_VOLUME_INFO_0_FI "Vähennä Master System FM-kanavan 1 äänenvoimakkuutta."
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_2_VOLUME_LABEL_FI "Master System FM (YM2413) Kanava 2 äänenvoimakkuus %"
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_2_VOLUME_INFO_0_FI "Vähennä Master System FM-kanavan 2 äänenvoimakkuutta."
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_3_VOLUME_LABEL_FI "Master System FM (YM2413) kanavan 3 äänenvoimakkuus %"
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_3_VOLUME_INFO_0_FI "Vähennä Master System FM-kanavan 3 äänenvoimakkuutta."
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_4_VOLUME_LABEL_FI "Master System FM (YM2413) kanavan 4 äänenvoimakkuus %"
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_4_VOLUME_INFO_0_FI "Vähennä Master System FM-kanavan 4 äänenvoimakkuutta."
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_5_VOLUME_LABEL_FI "Master System FM (YM2413) kanavan 5 äänenvoimakkuus %"
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_5_VOLUME_INFO_0_FI "Vähennä Master System FM-kanavan 5 äänenvoimakkuutta."
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_6_VOLUME_LABEL_FI "Master System FM (YM2413) kanavan 6 äänenvoimakkuus %"
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_6_VOLUME_INFO_0_FI "Vähennä Master System FM-kanavan 6 äänenvoimakkuutta."
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_7_VOLUME_LABEL_FI "Master System FM (YM2413) kanavan 7 äänenvoimakkuus %"
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_7_VOLUME_INFO_0_FI "Vähennä Master System FM-kanavan 7 äänenvoimakkuutta."
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_8_VOLUME_LABEL_FI "Master System FM (YM2413) kanavan 8 äänenvoimakkuus %"
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_8_VOLUME_INFO_0_FI "Vähennä Master System FM-kanavan 8 äänenvoimakkuutta."

struct retro_core_option_v2_category option_cats_fi[] = {
   {
      "system",
      CATEGORY_SYSTEM_LABEL_FI,
      CATEGORY_SYSTEM_INFO_0_FI
   },
   {
      "video",
      CATEGORY_VIDEO_LABEL_FI,
      CATEGORY_VIDEO_INFO_0_FI
   },
   {
      "audio",
      CATEGORY_AUDIO_LABEL_FI,
      CATEGORY_AUDIO_INFO_0_FI
   },
   {
      "input",
      CATEGORY_INPUT_LABEL_FI,
      CATEGORY_INPUT_INFO_0_FI
   },
   {
      "hacks",
      CATEGORY_HACKS_LABEL_FI,
      CATEGORY_HACKS_INFO_0_FI
   },
   {
      "channel_volume",
      CATEGORY_CHANNEL_VOLUME_LABEL_FI,
      CATEGORY_CHANNEL_VOLUME_INFO_0_FI
   },
   { NULL, NULL, NULL },
};
struct retro_core_option_v2_definition option_defs_fi[] = {
   {
      "genesis_plus_gx_system_hw",
      GENESIS_PLUS_GX_SYSTEM_HW_LABEL_FI,
      NULL,
      GENESIS_PLUS_GX_SYSTEM_HW_INFO_0_FI,
      NULL,
      "system",
      {
         { "auto",                 OPTION_VAL_AUTO_FI                 },
         { "sg-1000",              OPTION_VAL_SG_1000_FI              },
         { "sg-1000 II",           OPTION_VAL_SG_1000_II_FI           },
         { "sg-1000 II + ram ext.",OPTION_VAL_SG_1000_II_RAM_EXT_FI},
         { "mark-III",             OPTION_VAL_MARK_III_FI             },
         { "master system",        OPTION_VAL_MASTER_SYSTEM_FI        },
         { "master system II",     OPTION_VAL_MASTER_SYSTEM_II_FI     },
         { "game gear",            OPTION_VAL_GAME_GEAR_FI            },
         { "mega drive / genesis", OPTION_VAL_MEGA_DRIVE_GENESIS_FI   },
         { NULL, NULL },
      },
      "auto"
   },
   {
      "genesis_plus_gx_region_detect",
      GENESIS_PLUS_GX_REGION_DETECT_LABEL_FI,
      NULL,
      GENESIS_PLUS_GX_REGION_DETECT_INFO_0_FI,
      NULL,
      "system",
      {
         { "auto",    OPTION_VAL_AUTO_FI   },
         { "ntsc-u",  OPTION_VAL_NTSC_U_FI },
         { "pal",     OPTION_VAL_PAL_FI    },
         { "ntsc-j",  OPTION_VAL_NTSC_J_FI },
         { NULL, NULL },
      },
      "auto"
   },
   {
      "genesis_plus_gx_vdp_mode",
      GENESIS_PLUS_GX_VDP_MODE_LABEL_FI,
      NULL,
      GENESIS_PLUS_GX_VDP_MODE_INFO_0_FI,
      NULL,
      "system",
      {
         { "auto",  "Disabled" },
         { "60hz",  OPTION_VAL_60HZ_FI },
         { "50hz",  OPTION_VAL_50HZ_FI },
         { NULL, NULL },
      },
      "auto"
   },
   {
      "genesis_plus_gx_bios",
      GENESIS_PLUS_GX_BIOS_LABEL_FI,
      NULL,
      GENESIS_PLUS_GX_BIOS_INFO_0_FI,
      NULL,
      "system",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_system_bram",
      GENESIS_PLUS_GX_SYSTEM_BRAM_LABEL_FI,
      NULL,
      GENESIS_PLUS_GX_SYSTEM_BRAM_INFO_0_FI,
      NULL,
      "system",
      {
         { "per bios", OPTION_VAL_PER_BIOS_FI },
         { "per game", OPTION_VAL_PER_GAME_FI },
         { NULL, NULL },
      },
      "per bios"
   },
   {
      "genesis_plus_gx_cart_bram",
      GENESIS_PLUS_GX_CART_BRAM_LABEL_FI,
      NULL,
      GENESIS_PLUS_GX_CART_BRAM_INFO_0_FI,
      NULL,
      "system",
      {
         { "per cart", OPTION_VAL_PER_CART_FI },
         { "per game", OPTION_VAL_PER_GAME_FI },
         { NULL, NULL },
      },
      "per cart"
   },
   {
      "genesis_plus_gx_cart_size",
      GENESIS_PLUS_GX_CART_SIZE_LABEL_FI,
      NULL,
      GENESIS_PLUS_GX_CART_SIZE_INFO_0_FI,
      NULL,
      "system",
      {
         { "disabled", "Disabled" },
         { "128k",     OPTION_VAL_128K_FI  },
         { "256k",     OPTION_VAL_256K_FI  },
         { "512k",     OPTION_VAL_512K_FI  },
         { "1meg",     OPTION_VAL_1MEG_FI    },
         { "2meg",     OPTION_VAL_2MEG_FI    },
         { "4meg",     OPTION_VAL_4MEG_FI    },
         { NULL, NULL },
      },
      "4meg"
   },
   {
      "genesis_plus_gx_add_on",
      GENESIS_PLUS_GX_ADD_ON_LABEL_FI,
      NULL,
      GENESIS_PLUS_GX_ADD_ON_INFO_0_FI,
      NULL,
      "system",
      {
         { "auto",         OPTION_VAL_AUTO_FI },
         { "sega/mega cd", OPTION_VAL_SEGA_MEGA_CD_FI },
         { "megasd",       OPTION_VAL_MEGASD_FI },
         { "none",         OPTION_VAL_NONE_FI },
         { NULL, NULL },
      },
      "auto"
   },
   {
      "genesis_plus_gx_lock_on",
      GENESIS_PLUS_GX_LOCK_ON_LABEL_FI,
      NULL,
      GENESIS_PLUS_GX_LOCK_ON_INFO_0_FI,
      NULL,
      "system",
      {
         { "disabled",            NULL },
         { "game genie",          OPTION_VAL_GAME_GENIE_FI },
         { "action replay (pro)", OPTION_VAL_ACTION_REPLAY_PRO_FI },
         { "sonic & knuckles",    OPTION_VAL_SONIC_KNUCKLES_FI },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_aspect_ratio",
      GENESIS_PLUS_GX_ASPECT_RATIO_LABEL_FI,
      NULL,
      GENESIS_PLUS_GX_ASPECT_RATIO_INFO_0_FI,
      NULL,
      "video",
      {
         { "auto",     OPTION_VAL_AUTO_FI },
         { "NTSC PAR", OPTION_VAL_NTSC_PAR_FI },
         { "PAL PAR",  OPTION_VAL_PAL_PAR_FI },
         { "4:3",  OPTION_VAL_4_3_FI },
         { "Uncorrected",  OPTION_VAL_UNCORRECTED_FI },
      },
      "auto"
   },
   {
      "genesis_plus_gx_overscan",
      GENESIS_PLUS_GX_OVERSCAN_LABEL_FI,
      NULL,
      GENESIS_PLUS_GX_OVERSCAN_INFO_0_FI,
      NULL,
      "video",
      {
         { "disabled",   NULL },
         { "top/bottom", OPTION_VAL_TOP_BOTTOM_FI },
         { "left/right", OPTION_VAL_LEFT_RIGHT_FI },
         { "full",       OPTION_VAL_FULL_FI },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_left_border",
      GENESIS_PLUS_GX_LEFT_BORDER_LABEL_FI,
      NULL,
      GENESIS_PLUS_GX_LEFT_BORDER_INFO_0_FI,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "left border", OPTION_VAL_LEFT_BORDER_FI },
         { "left & right borders", OPTION_VAL_LEFT_RIGHT_BORDERS_FI },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_gg_extra",
      GENESIS_PLUS_GX_GG_EXTRA_LABEL_FI,
      NULL,
      GENESIS_PLUS_GX_GG_EXTRA_INFO_0_FI,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_blargg_ntsc_filter",
      GENESIS_PLUS_GX_BLARGG_NTSC_FILTER_LABEL_FI,
      NULL,
      GENESIS_PLUS_GX_BLARGG_NTSC_FILTER_INFO_0_FI,
      NULL,
      "video",
      {
         { "disabled",   NULL },
         { "monochrome", OPTION_VAL_MONOCHROME_FI },
         { "composite",  OPTION_VAL_COMPOSITE_FI },
         { "svideo",     OPTION_VAL_SVIDEO_FI },
         { "rgb",        OPTION_VAL_RGB_FI },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_lcd_filter",
      GENESIS_PLUS_GX_LCD_FILTER_LABEL_FI,
      NULL,
      GENESIS_PLUS_GX_LCD_FILTER_INFO_0_FI,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_render",
      GENESIS_PLUS_GX_RENDER_LABEL_FI,
      NULL,
      GENESIS_PLUS_GX_RENDER_INFO_0_FI,
      NULL,
      "video",
      {
         { "single field", OPTION_VAL_SINGLE_FIELD_FI },
         { "double field", OPTION_VAL_DOUBLE_FIELD_FI },
         { NULL, NULL },
      },
      "single field"
   },
   {
      "genesis_plus_gx_frameskip",
      GENESIS_PLUS_GX_FRAMESKIP_LABEL_FI,
      NULL,
      GENESIS_PLUS_GX_FRAMESKIP_INFO_0_FI,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "auto",     OPTION_VAL_AUTO_FI },
         { "manual",   OPTION_VAL_MANUAL_FI },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_frameskip_threshold",
      GENESIS_PLUS_GX_FRAMESKIP_THRESHOLD_LABEL_FI,
      NULL,
      GENESIS_PLUS_GX_FRAMESKIP_THRESHOLD_INFO_0_FI,
      NULL,
      "video",
      {
         { "15", NULL },
         { "18", NULL },
         { "21", NULL },
         { "24", NULL },
         { "27", NULL },
         { "30", NULL },
         { "33", NULL },
         { "36", NULL },
         { "39", NULL },
         { "42", NULL },
         { "45", NULL },
         { "48", NULL },
         { "51", NULL },
         { "54", NULL },
         { "57", NULL },
         { "60", NULL },
         { NULL, NULL },
      },
      "33"
   },
   {
      "genesis_plus_gx_ym2413",
      GENESIS_PLUS_GX_YM2413_LABEL_FI,
      NULL,
      GENESIS_PLUS_GX_YM2413_INFO_0_FI,
      NULL,
      "audio",
      {
         { "auto",     OPTION_VAL_AUTO_FI },
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "auto"
   },
#ifdef HAVE_OPLL_CORE
   {
      "genesis_plus_gx_ym2413_core",
      GENESIS_PLUS_GX_YM2413_CORE_LABEL_FI,
      NULL,
      GENESIS_PLUS_GX_YM2413_CORE_INFO_0_FI,
      NULL,
      "audio",
      {
         { "mame",  OPTION_VAL_MAME_FI },
         { "nuked", OPTION_VAL_NUKED_FI },
         { NULL, NULL },
      },
      "mame"
   },
#endif
   {
      "genesis_plus_gx_ym2612",
      GENESIS_PLUS_GX_YM2612_LABEL_FI,
      NULL,
#ifdef HAVE_YM3438_CORE
      GENESIS_PLUS_GX_YM2612_INFO_0_FI,
#else
      GENESIS_PLUS_GX_YM2612_INFO_1_FI,
#endif
      NULL,
      "audio",
      {
         { "mame (ym2612)",          OPTION_VAL_MAME_YM2612_FI },
         { "mame (asic ym3438)",     OPTION_VAL_MAME_ASIC_YM3438_FI },
         { "mame (enhanced ym3438)", OPTION_VAL_MAME_ENHANCED_YM3438_FI },
#ifdef HAVE_YM3438_CORE
         { "nuked (ym2612)",         OPTION_VAL_NUKED_YM2612_FI },
         { "nuked (ym3438)",         OPTION_VAL_NUKED_YM3438_FI },
#endif
         { NULL, NULL },
      },
      "mame (ym2612)"
   },
   {
      "genesis_plus_gx_sound_output",
      GENESIS_PLUS_GX_SOUND_OUTPUT_LABEL_FI,
      NULL,
      GENESIS_PLUS_GX_SOUND_OUTPUT_INFO_0_FI,
      NULL,
      "audio",
      {
         { "stereo", OPTION_VAL_STEREO_FI },
         { "mono",   OPTION_VAL_MONO_FI },
         { NULL, NULL },
      },
      "stereo"
   },
   {
      "genesis_plus_gx_audio_filter",
      GENESIS_PLUS_GX_AUDIO_FILTER_LABEL_FI,
      NULL,
      GENESIS_PLUS_GX_AUDIO_FILTER_INFO_0_FI,
      NULL,
      "audio",
      {
         { "disabled", NULL },
         { "low-pass", OPTION_VAL_LOW_PASS_FI },
#ifdef HAVE_EQ
         { "EQ",       OPTION_VAL_EQ_FI },
#endif
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_lowpass_range",
      GENESIS_PLUS_GX_LOWPASS_RANGE_LABEL_FI,
      NULL,
      GENESIS_PLUS_GX_LOWPASS_RANGE_INFO_0_FI,
      NULL,
      "audio",
      {
         { "5",  NULL },
         { "10", NULL },
         { "15", NULL },
         { "20", NULL },
         { "25", NULL },
         { "30", NULL },
         { "35", NULL },
         { "40", NULL },
         { "45", NULL },
         { "50", NULL },
         { "55", NULL },
         { "60", NULL },
         { "65", NULL },
         { "70", NULL },
         { "75", NULL },
         { "80", NULL },
         { "85", NULL },
         { "90", NULL },
         { "95", NULL },
         { NULL, NULL },
      },
      "60"
   },
   {
      "genesis_plus_gx_psg_preamp",
      GENESIS_PLUS_GX_PSG_PREAMP_LABEL_FI,
      NULL,
      GENESIS_PLUS_GX_PSG_PREAMP_INFO_0_FI,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { "105", NULL },
         { "110", NULL },
         { "115", NULL },
         { "120", NULL },
         { "125", NULL },
         { "130", NULL },
         { "135", NULL },
         { "140", NULL },
         { "145", NULL },
         { "150", NULL },
         { "155", NULL },
         { "160", NULL },
         { "165", NULL },
         { "170", NULL },
         { "175", NULL },
         { "180", NULL },
         { "185", NULL },
         { "190", NULL },
         { "195", NULL },
         { "200", NULL },
         { NULL, NULL },
      },
      "150"
   },
   {
      "genesis_plus_gx_fm_preamp",
      GENESIS_PLUS_GX_FM_PREAMP_LABEL_FI,
      NULL,
      GENESIS_PLUS_GX_FM_PREAMP_INFO_0_FI,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { "105", NULL },
         { "110", NULL },
         { "115", NULL },
         { "120", NULL },
         { "125", NULL },
         { "130", NULL },
         { "135", NULL },
         { "140", NULL },
         { "145", NULL },
         { "150", NULL },
         { "155", NULL },
         { "160", NULL },
         { "165", NULL },
         { "170", NULL },
         { "175", NULL },
         { "180", NULL },
         { "185", NULL },
         { "190", NULL },
         { "195", NULL },
         { "200", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_cdda_volume",
      GENESIS_PLUS_GX_CDDA_VOLUME_LABEL_FI,
      NULL,
      GENESIS_PLUS_GX_CDDA_VOLUME_INFO_0_FI,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_pcm_volume",
      GENESIS_PLUS_GX_PCM_VOLUME_LABEL_FI,
      NULL,
      GENESIS_PLUS_GX_PCM_VOLUME_INFO_0_FI,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
#ifdef HAVE_EQ
   {
      "genesis_plus_gx_audio_eq_low",
      GENESIS_PLUS_GX_AUDIO_EQ_LOW_LABEL_FI,
      NULL,
      GENESIS_PLUS_GX_AUDIO_EQ_LOW_INFO_0_FI,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_audio_eq_mid",
      GENESIS_PLUS_GX_AUDIO_EQ_MID_LABEL_FI,
      NULL,
      GENESIS_PLUS_GX_AUDIO_EQ_MID_INFO_0_FI,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_audio_eq_high",
      GENESIS_PLUS_GX_AUDIO_EQ_HIGH_LABEL_FI,
      NULL,
      GENESIS_PLUS_GX_AUDIO_EQ_HIGH_INFO_0_FI,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
#endif
   {
      "genesis_plus_gx_gun_input",
      GENESIS_PLUS_GX_GUN_INPUT_LABEL_FI,
      NULL,
      GENESIS_PLUS_GX_GUN_INPUT_INFO_0_FI,
      NULL,
      "input",
      {
         { "lightgun",    OPTION_VAL_LIGHTGUN_FI },
         { "touchscreen", OPTION_VAL_TOUCHSCREEN_FI },
         { NULL, NULL },
      },
      "lightgun"
   },
   {
      "genesis_plus_gx_gun_cursor",
      GENESIS_PLUS_GX_GUN_CURSOR_LABEL_FI,
      NULL,
      GENESIS_PLUS_GX_GUN_CURSOR_INFO_0_FI,
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_invert_mouse",
      GENESIS_PLUS_GX_INVERT_MOUSE_LABEL_FI,
      NULL,
      GENESIS_PLUS_GX_INVERT_MOUSE_INFO_0_FI,
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_no_sprite_limit",
      GENESIS_PLUS_GX_NO_SPRITE_LIMIT_LABEL_FI,
      NULL,
      GENESIS_PLUS_GX_NO_SPRITE_LIMIT_INFO_0_FI,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_enhanced_vscroll",
      GENESIS_PLUS_GX_ENHANCED_VSCROLL_LABEL_FI,
      NULL,
      GENESIS_PLUS_GX_ENHANCED_VSCROLL_INFO_0_FI,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_enhanced_vscroll_limit",
      GENESIS_PLUS_GX_ENHANCED_VSCROLL_LIMIT_LABEL_FI,
      NULL,
      GENESIS_PLUS_GX_ENHANCED_VSCROLL_LIMIT_INFO_0_FI,
      NULL,
      "hacks",
      {
         { "2", NULL },
         { "3",  NULL },
         { "4", NULL },
         { "5",  NULL },
         { "6", NULL },
         { "7",  NULL },
         { "8", NULL },
         { "9",  NULL },
         { "10", NULL },
         { "11",  NULL },
         { "12", NULL },
         { "13",  NULL },
         { "14", NULL },
         { "15",  NULL },
         { "16", NULL },
         { NULL, NULL },
      },
      "8"
   },
#ifdef HAVE_OVERCLOCK
   {
      "genesis_plus_gx_overclock",
      GENESIS_PLUS_GX_OVERCLOCK_LABEL_FI,
      NULL,
      GENESIS_PLUS_GX_OVERCLOCK_INFO_0_FI,
      NULL,
      "hacks",
      {
         { "100", OPTION_VAL_100_FI },
         { "125", OPTION_VAL_125_FI },
         { "150", OPTION_VAL_150_FI },
         { "175", OPTION_VAL_175_FI },
         { "200", OPTION_VAL_200_FI },
         { "225", OPTION_VAL_225_FI },
         { "250", OPTION_VAL_250_FI },
         { "275", OPTION_VAL_275_FI },
         { "300", OPTION_VAL_300_FI },
         { "325", OPTION_VAL_325_FI },
         { "350", OPTION_VAL_350_FI },
         { "375", OPTION_VAL_375_FI },
         { "400", OPTION_VAL_400_FI },
         { "425", OPTION_VAL_425_FI },
         { "450", OPTION_VAL_450_FI },
         { "475", OPTION_VAL_475_FI },
         { "500", OPTION_VAL_500_FI },
         { NULL, NULL },
      },
      "100%"
   },
#endif
   {
      "genesis_plus_gx_force_dtack",
      GENESIS_PLUS_GX_FORCE_DTACK_LABEL_FI,
      NULL,
      GENESIS_PLUS_GX_FORCE_DTACK_INFO_0_FI,
      NULL,
      "hacks",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL },
      },
      "enabled"
   },
   {
      "genesis_plus_gx_addr_error",
      GENESIS_PLUS_GX_ADDR_ERROR_LABEL_FI,
      NULL,
      GENESIS_PLUS_GX_ADDR_ERROR_INFO_0_FI,
      NULL,
      "hacks",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL },
      },
      "enabled"
   },
   {
      "genesis_plus_gx_cd_latency",
      GENESIS_PLUS_GX_CD_LATENCY_LABEL_FI,
      NULL,
      GENESIS_PLUS_GX_CD_LATENCY_INFO_0_FI,
      NULL,
      "hacks",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL },
      },
      "enabled"
   },
   {
      "genesis_plus_gx_cd_precache",
      GENESIS_PLUS_GX_CD_PRECACHE_LABEL_FI,
      NULL,
      GENESIS_PLUS_GX_CD_PRECACHE_INFO_0_FI,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
#ifdef USE_PER_SOUND_CHANNELS_CONFIG
   {
      "genesis_plus_gx_show_advanced_audio_settings",
      GENESIS_PLUS_GX_SHOW_ADVANCED_AUDIO_SETTINGS_LABEL_FI,
      NULL,
      GENESIS_PLUS_GX_SHOW_ADVANCED_AUDIO_SETTINGS_INFO_0_FI,
      NULL,
      "channel_volume",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL},
      },
      "disabled"
   },
   {
      "genesis_plus_gx_psg_channel_0_volume",
      GENESIS_PLUS_GX_PSG_CHANNEL_0_VOLUME_LABEL_FI,
      NULL,
      GENESIS_PLUS_GX_PSG_CHANNEL_0_VOLUME_INFO_0_FI,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_psg_channel_1_volume",
      GENESIS_PLUS_GX_PSG_CHANNEL_1_VOLUME_LABEL_FI,
      NULL,
      GENESIS_PLUS_GX_PSG_CHANNEL_1_VOLUME_INFO_0_FI,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_psg_channel_2_volume",
      GENESIS_PLUS_GX_PSG_CHANNEL_2_VOLUME_LABEL_FI,
      NULL,
      GENESIS_PLUS_GX_PSG_CHANNEL_2_VOLUME_INFO_0_FI,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_psg_channel_3_volume",
      GENESIS_PLUS_GX_PSG_CHANNEL_3_VOLUME_LABEL_FI,
      NULL,
      GENESIS_PLUS_GX_PSG_CHANNEL_3_VOLUME_INFO_0_FI,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_0_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_0_VOLUME_LABEL_FI,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_0_VOLUME_INFO_0_FI,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_1_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_1_VOLUME_LABEL_FI,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_1_VOLUME_INFO_0_FI,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_2_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_2_VOLUME_LABEL_FI,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_2_VOLUME_INFO_0_FI,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_3_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_3_VOLUME_LABEL_FI,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_3_VOLUME_INFO_0_FI,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_4_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_4_VOLUME_LABEL_FI,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_4_VOLUME_INFO_0_FI,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_5_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_5_VOLUME_LABEL_FI,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_5_VOLUME_INFO_0_FI,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_0_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_0_VOLUME_LABEL_FI,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_0_VOLUME_INFO_0_FI,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_1_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_1_VOLUME_LABEL_FI,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_1_VOLUME_INFO_0_FI,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_2_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_2_VOLUME_LABEL_FI,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_2_VOLUME_INFO_0_FI,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_3_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_3_VOLUME_LABEL_FI,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_3_VOLUME_INFO_0_FI,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_4_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_4_VOLUME_LABEL_FI,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_4_VOLUME_INFO_0_FI,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_5_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_5_VOLUME_LABEL_FI,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_5_VOLUME_INFO_0_FI,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_6_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_6_VOLUME_LABEL_FI,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_6_VOLUME_INFO_0_FI,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_7_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_7_VOLUME_LABEL_FI,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_7_VOLUME_INFO_0_FI,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_8_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_8_VOLUME_LABEL_FI,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_8_VOLUME_INFO_0_FI,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
#endif
   { NULL, NULL, NULL, NULL, NULL, NULL, {{0}}, NULL },
};
struct retro_core_options_v2 options_fi = {
   option_cats_fi,
   option_defs_fi
};

/* RETRO_LANGUAGE_FR */

#define CATEGORY_SYSTEM_LABEL_FR "Système"
#define CATEGORY_SYSTEM_INFO_0_FR "Modifier les réglages de la sélection du matériel de base, la région, du BIOS et des fichiers de sauvegarde Sega CD/Mega-CD."
#define CATEGORY_VIDEO_LABEL_FR "Vidéo"
#define CATEGORY_VIDEO_INFO_0_FR "Modifier les réglages du rapport d'aspect, du recadrage de l'affichage, du filtre vidéo et du saut d'images."
#define CATEGORY_AUDIO_LABEL_FR "Audio "
#define CATEGORY_AUDIO_INFO_0_FR "Modifier les réglages du périphérique audio."
#define CATEGORY_INPUT_LABEL_FR "Entrées"
#define CATEGORY_INPUT_INFO_0_FR "Modifier les réglages des entrées pistolet et/ou souris."
#define CATEGORY_HACKS_LABEL_FR "Hacks d'émulation"
#define CATEGORY_HACKS_INFO_0_FR "Modifier les réglages d'overclocking du processeur et de la précision d'émulation qui affectent les performances de bas niveau et la compatibilité."
#define CATEGORY_CHANNEL_VOLUME_LABEL_FR "Réglages avancés du volume des canaux"
#define CATEGORY_CHANNEL_VOLUME_INFO_0_FR "Modifier le volume des canaux audio matériels individuels."
#define GENESIS_PLUS_GX_SYSTEM_HW_LABEL_FR "Matériel système"
#define GENESIS_PLUS_GX_SYSTEM_HW_INFO_0_FR "Exécute du contenu chargé avec une console émulée spécifique. 'Auto' sélectionnera le système le plus approprié pour le jeu en cours."
#define OPTION_VAL_AUTO_FR NULL
#define OPTION_VAL_SG_1000_FR NULL
#define OPTION_VAL_SG_1000_II_FR NULL
#define OPTION_VAL_SG_1000_II_RAM_EXT_FR "SG-1000 II + Ext. RAM"
#define OPTION_VAL_MARK_III_FR NULL
#define OPTION_VAL_MASTER_SYSTEM_FR NULL
#define OPTION_VAL_MASTER_SYSTEM_II_FR NULL
#define OPTION_VAL_GAME_GEAR_FR NULL
#define OPTION_VAL_MEGA_DRIVE_GENESIS_FR NULL
#define GENESIS_PLUS_GX_REGION_DETECT_LABEL_FR "Région du système"
#define GENESIS_PLUS_GX_REGION_DETECT_INFO_0_FR "Spécifie de quelle région le système provient. Pour les consoles autres que la Game Gear, 'PAL' est à 50 Hz alors que 'NTSC' est à 60 Hz. Les jeux peuvent tourner plus vite ou plus lentement que la normale si la région incorrecte est sélectionnée."
#define OPTION_VAL_NTSC_U_FR NULL
#define OPTION_VAL_PAL_FR NULL
#define OPTION_VAL_NTSC_J_FR NULL
#define GENESIS_PLUS_GX_VDP_MODE_LABEL_FR "Forcer le mode VDP"
#define GENESIS_PLUS_GX_VDP_MODE_INFO_0_FR "Outrepasse le mode VDP pour le forcer à fonctionner en NTSC 60 Hz ou PAL 50 Hz, quelle que soit la région du système."
#define OPTION_VAL_60HZ_FR "NTSC (60 Hz)"
#define OPTION_VAL_50HZ_FR "PAL (50 Hz)"
#define GENESIS_PLUS_GX_BIOS_LABEL_FR "ROM de démarrage du système"
#define GENESIS_PLUS_GX_BIOS_INFO_0_FR "Utiliser le BIOS/bootloader officiel pour le matériel émulé, s'il est présent dans le répertoire système de RetroArch. Affiche une séquence de démarrage/animation spécifique à la console, puis lance le contenu chargé."
#define GENESIS_PLUS_GX_SYSTEM_BRAM_LABEL_FR "BRAM du système de CD (Redémarrage requis)"
#define GENESIS_PLUS_GX_SYSTEM_BRAM_INFO_0_FR "Lors de l'exécution de contenu Sega CD/Mega-CD, spécifie s'il faut partager un seul fichier de sauvegarde entre tous les jeux d'une région spécifique (Par BIOS) ou créer un fichier de sauvegarde séparé pour chaque jeu (Par jeu). Notez que le Sega CD/Mega-CD a un stockage interne limité, suffisant seulement pour une poignée de titres. Pour éviter de manquer d'espace, le paramètre 'Par jeu' est recommandé."
#define OPTION_VAL_PER_BIOS_FR "Par BIOS"
#define OPTION_VAL_PER_GAME_FR "Par jeu"
#define GENESIS_PLUS_GX_CART_BRAM_LABEL_FR "BRAM de la cartouche de sauvegarde du CD (Redémarrage requis)"
#define GENESIS_PLUS_GX_CART_BRAM_INFO_0_FR "Lorsque vous exécutez du contenu Sega CD/Mega-CD, cette option spécifie si vous voulez partager une seule cartouche de sauvegarde pour tous les jeux (Par cartouche) ou créer une cartouche de sauvegarde séparée pour chaque jeu (Par jeu)."
#define OPTION_VAL_PER_CART_FR "Par cartouche"
#define GENESIS_PLUS_GX_CART_SIZE_LABEL_FR "Quantité de BRAM de la cartouche de sauvegarde du CD (Redémarrage requis)"
#define GENESIS_PLUS_GX_CART_SIZE_INFO_0_FR "Définit la quantité de ram de la cartouche de sauvegarde lors de l'exécution du contenu Sega CD/Mega-CD. Utile lors du réglage de la cartouche de sauvegarde sur 'Par jeu' pour éviter plusieurs tailles de cartouches plus grandes."
#define OPTION_VAL_128K_FR "128 kbit"
#define OPTION_VAL_256K_FR "256 kbit"
#define OPTION_VAL_512K_FR "512 kbit"
#define OPTION_VAL_1MEG_FR "1 Mbit"
#define OPTION_VAL_2MEG_FR "2 Mbit"
#define OPTION_VAL_4MEG_FR "4 Mbit"
#define GENESIS_PLUS_GX_ADD_ON_LABEL_FR "Module CD complémentaire (mode MD) (Redémarrage requis)"
#define GENESIS_PLUS_GX_ADD_ON_INFO_0_FR "Spécifie quel module complémentaire utiliser pour la lecture audio de CD avec les jeux Mega Drive/Genesis pris en charge."
#define OPTION_VAL_SEGA_MEGA_CD_FR NULL
#define OPTION_VAL_MEGASD_FR NULL
#define OPTION_VAL_NONE_FR "Ne pas partager"
#define GENESIS_PLUS_GX_LOCK_ON_LABEL_FR "Cartouche lock-on"
#define GENESIS_PLUS_GX_LOCK_ON_INFO_0_FR "La technologie lock-on est une fonctionnalité de la Mega Drive/Genesis qui permettait à un jeu plus ancien de se connecter au port de transit d'une cartouche spéciale pour un jeu prolongé ou modifié. Cette option spécifie quel type de cartouche 'lock-on' spéciale émuler. Un fichier BIOS correspondant doit être présent dans le dossier système de RetroArch."
#define OPTION_VAL_GAME_GENIE_FR NULL
#define OPTION_VAL_ACTION_REPLAY_PRO_FR NULL
#define OPTION_VAL_SONIC_KNUCKLES_FR NULL
#define GENESIS_PLUS_GX_ASPECT_RATIO_LABEL_FR "Rapport d'aspect fourni par le cœur"
#define GENESIS_PLUS_GX_ASPECT_RATIO_INFO_0_FR "Choisir le rapport d'aspect préféré pour le contenu. Cela ne s'applique que lorsque le rapport d'aspect de RetroArch est réglé sur 'Fourni par le cœur' (Core provided) dans les paramètres vidéo."
#define OPTION_VAL_NTSC_PAR_FR "Rapport d'aspect préféré NTSC"
#define OPTION_VAL_PAL_PAR_FR "Rapport d'aspect préféré PAL"
#define OPTION_VAL_4_3_FR NULL
#define OPTION_VAL_UNCORRECTED_FR "Non corrigé"
#define GENESIS_PLUS_GX_OVERSCAN_LABEL_FR "Bordures"
#define GENESIS_PLUS_GX_OVERSCAN_INFO_0_FR "Activer cette option pour afficher les régions de surbalayage en haut/bas et/ou à gauche/droite de l'écran. Celles-ci seraient normalement cachées par le biseau autour du bord d'une télévision définition standard."
#define OPTION_VAL_TOP_BOTTOM_FR "Haut/bas"
#define OPTION_VAL_LEFT_RIGHT_FR "Gauche/droite"
#define OPTION_VAL_FULL_FR "Complète"
#define GENESIS_PLUS_GX_LEFT_BORDER_LABEL_FR "Masquer les bordures latérales de la Master System"
#define GENESIS_PLUS_GX_LEFT_BORDER_INFO_0_FR "Coupe 8 pixels soit du côté gauche de l'écran, soit des côtés gauche et droit lors du lancement de jeux Master System."
#define OPTION_VAL_LEFT_BORDER_FR "Bordure de gauche uniquement"
#define OPTION_VAL_LEFT_RIGHT_BORDERS_FR "Bordures gauche et droite"
#define GENESIS_PLUS_GX_GG_EXTRA_LABEL_FR "Ecran étendu pour la Game Gear"
#define GENESIS_PLUS_GX_GG_EXTRA_INFO_0_FR "Force les jeux Game Gear à fonctionner en mode SMS, avec une résolution accrue de 256x192. Peut afficher du contenu supplémentaire, mais affiche généralement une bordure de données d'image corrompues ou indésirables."
#define GENESIS_PLUS_GX_BLARGG_NTSC_FILTER_LABEL_FR "Filtre NTSC de Blargg"
#define GENESIS_PLUS_GX_BLARGG_NTSC_FILTER_INFO_0_FR "Applique un filtre vidéo pour imiter différents signaux TV NTSC."
#define OPTION_VAL_MONOCHROME_FR NULL
#define OPTION_VAL_COMPOSITE_FR NULL
#define OPTION_VAL_SVIDEO_FR NULL
#define OPTION_VAL_RGB_FR "RVB"
#define GENESIS_PLUS_GX_LCD_FILTER_LABEL_FR "Filtre de rémanence LCD"
#define GENESIS_PLUS_GX_LCD_FILTER_INFO_0_FR "Applique un filtre de 'rémanence' d'image pour imiter les caractéristiques d'écran de la Game Gear et des panneaux LCD de la Nomad."
#define GENESIS_PLUS_GX_RENDER_LABEL_FR "Sortie Mode 2 entrelacée"
#define GENESIS_PLUS_GX_RENDER_INFO_0_FR "Le Mode 2 entrelacé permet à la Mega Drive/Genesis de produire une image de hauteur doublée (haute résolution) à 320x448 en dessinant des lignes de balayage alternatives à chaque image (utilisé par les modes multi-joueurs de Sonic the Hedgehog 2 et Combat Cars). 'Double champ' imite le matériel original, produisant une image nette avec des artefacts de scintillement/entrelacement. 'Un seul champ' applique un filtre de désentrelacement, qui stabilise l'image mais provoque un flou léger."
#define OPTION_VAL_SINGLE_FIELD_FR "Un seul champ"
#define OPTION_VAL_DOUBLE_FIELD_FR "Double champ"
#define GENESIS_PLUS_GX_FRAMESKIP_LABEL_FR "Saut d'images"
#define GENESIS_PLUS_GX_FRAMESKIP_INFO_0_FR "Sauter des images pour éviter que le tampon audio ne soit sous-exécuté (crépitements). Améliore les performances au détriment de la fluidité visuelle. 'Auto' saute des images lorsque l'interface le conseille. 'Manuel' utilise le paramètre 'Seuil de saut d'images (%)'."
#define OPTION_VAL_MANUAL_FR "Manuel"
#define GENESIS_PLUS_GX_FRAMESKIP_THRESHOLD_LABEL_FR "Seuil de saut d'images (%)"
#define GENESIS_PLUS_GX_FRAMESKIP_THRESHOLD_INFO_0_FR "Lorsque 'Saut d'images' est réglé sur 'Manuel', spécifie le seuil d'occupation du tampon audio (pourcentage) en dessous duquel des images seront sautées. Des valeurs plus élevées réduisent le risque de crépitements en faisant sauter des images plus fréquemment."
#define GENESIS_PLUS_GX_YM2413_LABEL_FR "FM Master System (YM2413)"
#define GENESIS_PLUS_GX_YM2413_INFO_0_FR "Activer l'émulation du FM Sound Unit utilisé par certains jeux Sega Mark III/Master System pour une sortie audio améliorée."
#define GENESIS_PLUS_GX_YM2413_CORE_LABEL_FR "Cœur FM Master System (YM2413)"
#define GENESIS_PLUS_GX_YM2413_CORE_INFO_0_FR "Sélectionner la méthode utilisée pour émuler le FM Sound Unit de la Sega Mark III/Master System. L'option 'MAME' est rapide, et fonctionne à pleine vitesse sur la plupart des systèmes. L'option 'Nuked' est précise au cycle près, de très haute qualité, et a des exigences substantielles en matière de processeur."
#define OPTION_VAL_MAME_FR NULL
#define OPTION_VAL_NUKED_FR NULL
#define GENESIS_PLUS_GX_YM2612_LABEL_FR "FM Mega Drive/Genesis"
#define GENESIS_PLUS_GX_YM2612_INFO_0_FR "Sélectionner la méthode utilisée pour émuler le synthétiseur FM (générateur principal de son) de la Mega Drive/Genesis. Les options 'MAME' sont rapides, et fonctionnent à pleine vitesse sur la plupart des systèmes. Les options 'Nuked' sont précises au cycle près, de très haute qualité, et ont plus d'exigences en matière de processeur. La puce YM2612 est utilisée par la version originale du modèle 1 de Mega Drive/Genesis. La YM3438 est utilisée par les révisions suivantes de Mega Drive/Genesis."
#define GENESIS_PLUS_GX_YM2612_INFO_1_FR "Sélectionner la méthode utilisée pour émuler le synthétiseur FM (générateur principal de son) de la Mega Drive/Genesis. La puce YM2612 est utilisée par la version originale du modèle 1 de Mega Drive/Genesis. La YM3438 est utilisée par les révisions suivantes de Mega Drive/Genesis."
#define OPTION_VAL_MAME_YM2612_FR NULL
#define OPTION_VAL_MAME_ASIC_YM3438_FR NULL
#define OPTION_VAL_MAME_ENHANCED_YM3438_FR "MAME (YM3438 amélioré)"
#define OPTION_VAL_NUKED_YM2612_FR NULL
#define OPTION_VAL_NUKED_YM3438_FR NULL
#define GENESIS_PLUS_GX_SOUND_OUTPUT_LABEL_FR "Sortie audio"
#define GENESIS_PLUS_GX_SOUND_OUTPUT_INFO_0_FR "Sélectionner la lecture du son stéréo ou mono."
#define OPTION_VAL_STEREO_FR "Stéréo"
#define OPTION_VAL_MONO_FR NULL
#define GENESIS_PLUS_GX_AUDIO_FILTER_LABEL_FR "Filtre audio"
#define GENESIS_PLUS_GX_AUDIO_FILTER_INFO_0_FR "Active un filtre audio passe-bas pour mieux simuler le son caractéristique d'une Mega Drive/Genesis."
#define OPTION_VAL_LOW_PASS_FR "Passe-bas"
#define OPTION_VAL_EQ_FR "Égaliseur"
#define GENESIS_PLUS_GX_LOWPASS_RANGE_LABEL_FR "Filtre passe-bas (%)"
#define GENESIS_PLUS_GX_LOWPASS_RANGE_INFO_0_FR "Spécifie la fréquence de coupure du filtre passe-bas audio. Une valeur plus élevée accroît la 'force' perçue du filtre, car une gamme plus large du spectre des hautes fréquences est atténuée."
#define GENESIS_PLUS_GX_PSG_PREAMP_LABEL_FR "Niveau du préampli PSG"
#define GENESIS_PLUS_GX_PSG_PREAMP_INFO_0_FR "Règle le niveau du préampli audio du générateur de son programmable 4 canaux SN76496 émulé trouvé dans la SG-1000, Sega Mark III, Master System, Game Gear et Mega Drive/Genesis."
#define GENESIS_PLUS_GX_FM_PREAMP_LABEL_FR "Niveau du préampli FM"
#define GENESIS_PLUS_GX_FM_PREAMP_INFO_0_FR "Règle le niveau du préampli audio du synthétiseur FM de la Mega Drive/Genesis ou du FM Sound Unit de la Sega Mark III/Master System émulés."
#define GENESIS_PLUS_GX_CDDA_VOLUME_LABEL_FR "Volume CD-DA"
#define GENESIS_PLUS_GX_CDDA_VOLUME_INFO_0_FR "Ajuste le volume de mixage de la sortie de lecture audio CD émulée."
#define GENESIS_PLUS_GX_PCM_VOLUME_LABEL_FR "Volume PCM"
#define GENESIS_PLUS_GX_PCM_VOLUME_INFO_0_FR "Ajuste le volume de mixage de la sortie du générateur de son PCM RF5C164 émulé du Sega CD/Mega-CD."
#define GENESIS_PLUS_GX_AUDIO_EQ_LOW_LABEL_FR "Égaliseur - graves"
#define GENESIS_PLUS_GX_AUDIO_EQ_LOW_INFO_0_FR "Ajuste la bande des basses fréquences de l'égaliseur audio interne."
#define GENESIS_PLUS_GX_AUDIO_EQ_MID_LABEL_FR "Égaliseur - médium"
#define GENESIS_PLUS_GX_AUDIO_EQ_MID_INFO_0_FR "Ajuste la bande des moyennes fréquences de l'égaliseur audio interne."
#define GENESIS_PLUS_GX_AUDIO_EQ_HIGH_LABEL_FR "Égaliseur - aigus"
#define GENESIS_PLUS_GX_AUDIO_EQ_HIGH_INFO_0_FR "Ajuste la bande des hautes fréquences de l'égaliseur audio interne."
#define GENESIS_PLUS_GX_GUN_INPUT_LABEL_FR "Entrée du pistolet"
#define GENESIS_PLUS_GX_GUN_INPUT_INFO_0_FR "Utiliser une entrée 'Pistolet' contrôlée par la souris ou 'Écran tactile'."
#define OPTION_VAL_LIGHTGUN_FR "Pistolet"
#define OPTION_VAL_TOUCHSCREEN_FR "Écran tactile"
#define GENESIS_PLUS_GX_GUN_CURSOR_LABEL_FR "Afficher le réticule du pistolet"
#define GENESIS_PLUS_GX_GUN_CURSOR_INFO_0_FR "Affiche les réticules de visée du pistolet lorsque vous utilisez les types de périphériques d'entrée MD Menacer, MD Justifiers et MS Light Phaser."
#define GENESIS_PLUS_GX_INVERT_MOUSE_LABEL_FR "Inverser l'axe Y de la souris"
#define GENESIS_PLUS_GX_INVERT_MOUSE_INFO_0_FR "Inverse l'axe Y du type de périphérique d'entrée Souris MD."
#define GENESIS_PLUS_GX_NO_SPRITE_LIMIT_LABEL_FR "Supprimer la limite de sprites par ligne"
#define GENESIS_PLUS_GX_NO_SPRITE_LIMIT_INFO_0_FR "Supprime la limite matérielle originale de sprites par ligne de balayage. Cela réduit le scintillement mais peut causer des bugs visuels, car certains jeux exploitent la limite matérielle pour générer des effets spéciaux."
#define GENESIS_PLUS_GX_ENHANCED_VSCROLL_LABEL_FR "Défilement vertical par tile amélioré"
#define GENESIS_PLUS_GX_ENHANCED_VSCROLL_INFO_0_FR "Permet à chaque cellule de défiler verticalement, au lieu de 2 cellules de 16 px, en faisant la moyenne avec la valeur de défilement de la cellule voisine. Ce hack ne s'applique qu'à quelques jeux qui utilisent le mode défilement vertical à 2 cellules."
#define GENESIS_PLUS_GX_ENHANCED_VSCROLL_LIMIT_LABEL_FR "Limite du défilement vertical par tile amélioré"
#define GENESIS_PLUS_GX_ENHANCED_VSCROLL_LIMIT_INFO_0_FR "Uniquement lorsque le défilement vertical par tile est activé. Ajuste la limite de l'amélioration du défilement vertical. Lorsque la différence de vscroll entre les tiles voisines est plus grande que cette limite, l'amélioration est désactivée."
#define GENESIS_PLUS_GX_OVERCLOCK_LABEL_FR "Vitesse du processeur"
#define GENESIS_PLUS_GX_OVERCLOCK_INFO_0_FR "Overclocker le processeur émulé. Peut réduire le ralentissement, mais peut causer des bugs."
#define OPTION_VAL_100_FR NULL
#define OPTION_VAL_125_FR NULL
#define OPTION_VAL_150_FR NULL
#define OPTION_VAL_175_FR NULL
#define OPTION_VAL_200_FR NULL
#define OPTION_VAL_225_FR NULL
#define OPTION_VAL_250_FR NULL
#define OPTION_VAL_275_FR NULL
#define OPTION_VAL_300_FR NULL
#define OPTION_VAL_325_FR NULL
#define OPTION_VAL_350_FR NULL
#define OPTION_VAL_375_FR NULL
#define OPTION_VAL_400_FR NULL
#define OPTION_VAL_425_FR NULL
#define OPTION_VAL_450_FR NULL
#define OPTION_VAL_475_FR NULL
#define OPTION_VAL_500_FR NULL
#define GENESIS_PLUS_GX_FORCE_DTACK_LABEL_FR "Blocages du système"
#define GENESIS_PLUS_GX_FORCE_DTACK_INFO_0_FR "Émuler les blocages du système qui se produisent sur du vrai matériel lors d'un accès illégal aux adresses. Cela ne devrait être désactivé que lorsque vous jouez à certaines démos et homebrews qui dépendent d'un comportement illégal pour un fonctionnement correct."
#define GENESIS_PLUS_GX_ADDR_ERROR_LABEL_FR "Erreur d'adresse 68K"
#define GENESIS_PLUS_GX_ADDR_ERROR_INFO_0_FR "Le processeur principal de la Mega Drive/Genesis (Motorola 68000) génère une exception d'erreur d'adresse (plantage) lors d'une tentative d'accès à la mémoire non alignée. Activer cette option simule ce comportement. Cela ne devrait être désactivé que lorsque vous jouez à des hacks de ROM, car ils sont généralement développés en utilisant des émulateurs moins précis et peuvent dépendre d'un accès non valide à la mémoire vive pour une opération correcte."
#define GENESIS_PLUS_GX_CD_LATENCY_LABEL_FR "Temps d'accès au CD"
#define GENESIS_PLUS_GX_CD_LATENCY_INFO_0_FR "Simule la latence matérielle du CD original lors du lancement d'une lecture ou de la recherche d'un emplacement spécifique sur un disque chargé. Ceci est requis par quelques jeux CD qui plantent si les données CD sont disponibles trop tôt et corrige également les problèmes de désynchronisation audio dans certains jeux. Désactiver ceci peut être utile avec les jeux MSU-MD car cela rend les boucles de pistes audio CD plus fluides."
#define GENESIS_PLUS_GX_CD_PRECACHE_LABEL_FR "Cache de l'image CD"
#define GENESIS_PLUS_GX_CD_PRECACHE_INFO_0_FR "Charger l'image CD en mémoire au démarrage. CHD pris en charge uniquement. Redémarrage requis."
#define GENESIS_PLUS_GX_SHOW_ADVANCED_AUDIO_SETTINGS_LABEL_FR "Afficher les paramètres avancés du volume audio (Réouvrir le menu)"
#define GENESIS_PLUS_GX_SHOW_ADVANCED_AUDIO_SETTINGS_INFO_0_FR "Active la configuration des paramètres de bas niveau des canaux audio. REMARQUE : le menu rapide doit être réouvert pour que cette option prenne effet."
#define GENESIS_PLUS_GX_PSG_CHANNEL_0_VOLUME_LABEL_FR "Volume du canal de tonalité PSG 0 (%)"
#define GENESIS_PLUS_GX_PSG_CHANNEL_0_VOLUME_INFO_0_FR "Réduit le volume du canal de tonalité PSG 0."
#define GENESIS_PLUS_GX_PSG_CHANNEL_1_VOLUME_LABEL_FR "Volume du canal de tonalité PSG 1 (%)"
#define GENESIS_PLUS_GX_PSG_CHANNEL_1_VOLUME_INFO_0_FR "Réduit le volume du canal de tonalité PSG 1."
#define GENESIS_PLUS_GX_PSG_CHANNEL_2_VOLUME_LABEL_FR "Volume du canal de tonalité PSG 2 (%)"
#define GENESIS_PLUS_GX_PSG_CHANNEL_2_VOLUME_INFO_0_FR "Réduit le volume du canal de tonalité PSG 2."
#define GENESIS_PLUS_GX_PSG_CHANNEL_3_VOLUME_LABEL_FR "Volume du canal de bruit PSG 3 (%)"
#define GENESIS_PLUS_GX_PSG_CHANNEL_3_VOLUME_INFO_0_FR "Réduit le volume du canal de bruit PSG 3."
#define GENESIS_PLUS_GX_MD_CHANNEL_0_VOLUME_LABEL_FR "Volume du canal FM 0 de la Mega Drive/Genesis (%)"
#define GENESIS_PLUS_GX_MD_CHANNEL_0_VOLUME_INFO_0_FR "Réduit le volume du canal FM 0 de la Mega Drive/Genesis. Ne fonctionne qu'avec les émulateurs FM MAME."
#define GENESIS_PLUS_GX_MD_CHANNEL_1_VOLUME_LABEL_FR "Volume du canal FM 1 de la Mega Drive/Genesis (%)"
#define GENESIS_PLUS_GX_MD_CHANNEL_1_VOLUME_INFO_0_FR "Réduit le volume du canal FM 1 de la Mega Drive/Genesis. Ne fonctionne qu'avec les émulateurs FM MAME."
#define GENESIS_PLUS_GX_MD_CHANNEL_2_VOLUME_LABEL_FR "Volume du canal FM 2 de la Mega Drive/Genesis (%)"
#define GENESIS_PLUS_GX_MD_CHANNEL_2_VOLUME_INFO_0_FR "Réduit le volume du canal FM 2 de la Mega Drive/Genesis. Ne fonctionne qu'avec les émulateurs FM MAME."
#define GENESIS_PLUS_GX_MD_CHANNEL_3_VOLUME_LABEL_FR "Volume du canal FM 3 de la Mega Drive/Genesis (%)"
#define GENESIS_PLUS_GX_MD_CHANNEL_3_VOLUME_INFO_0_FR "Réduit le volume du canal FM 3 de la Mega Drive/Genesis. Ne fonctionne qu'avec les émulateurs FM MAME."
#define GENESIS_PLUS_GX_MD_CHANNEL_4_VOLUME_LABEL_FR "Volume du canal FM 4 de la Mega Drive/Genesis (%)"
#define GENESIS_PLUS_GX_MD_CHANNEL_4_VOLUME_INFO_0_FR "Réduit le volume du canal FM 4 de la Mega Drive/Genesis. Ne fonctionne qu'avec les émulateurs FM MAME."
#define GENESIS_PLUS_GX_MD_CHANNEL_5_VOLUME_LABEL_FR "Volume du canal FM 5 de la Mega Drive/Genesis (%)"
#define GENESIS_PLUS_GX_MD_CHANNEL_5_VOLUME_INFO_0_FR "Réduit le volume du canal FM 5 de la Mega Drive/Genesis. Ne fonctionne qu'avec les émulateurs FM MAME."
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_0_VOLUME_LABEL_FR "Volume du canal FM (YM2413) 0 de la Master System (%)"
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_0_VOLUME_INFO_0_FR "Réduit le volume du canal FM 0 de la Master System."
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_1_VOLUME_LABEL_FR "Volume du canal FM (YM2413) 1 de la Master System (%)"
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_1_VOLUME_INFO_0_FR "Réduit le volume du canal FM 1 de la Master System."
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_2_VOLUME_LABEL_FR "Volume du canal FM (YM2413) 2 de la Master System (%)"
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_2_VOLUME_INFO_0_FR "Réduit le volume du canal FM 2 de la Master System."
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_3_VOLUME_LABEL_FR "Volume du canal FM (YM2413) 3 de la Master System (%)"
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_3_VOLUME_INFO_0_FR "Réduit le volume du canal FM 3 de la Master System."
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_4_VOLUME_LABEL_FR "Volume du canal FM (YM2413) 4 de la Master System (%)"
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_4_VOLUME_INFO_0_FR "Réduit le volume du canal FM 4 de la Master System."
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_5_VOLUME_LABEL_FR "Volume du canal FM (YM2413) 5 de la Master System (%)"
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_5_VOLUME_INFO_0_FR "Réduit le volume du canal FM 5 de la Master System."
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_6_VOLUME_LABEL_FR "Volume du canal FM (YM2413) 6 de la Master System (%)"
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_6_VOLUME_INFO_0_FR "Réduit le volume du canal FM 6 de la Master System."
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_7_VOLUME_LABEL_FR "Volume du canal FM (YM2413) 7 de la Master System (%)"
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_7_VOLUME_INFO_0_FR "Réduit le volume du canal FM 7 de la Master System."
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_8_VOLUME_LABEL_FR "Volume du canal FM (YM2413) 8 de la Master System (%)"
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_8_VOLUME_INFO_0_FR "Réduit le volume du canal FM 8 de la Master System."

struct retro_core_option_v2_category option_cats_fr[] = {
   {
      "system",
      CATEGORY_SYSTEM_LABEL_FR,
      CATEGORY_SYSTEM_INFO_0_FR
   },
   {
      "video",
      CATEGORY_VIDEO_LABEL_FR,
      CATEGORY_VIDEO_INFO_0_FR
   },
   {
      "audio",
      CATEGORY_AUDIO_LABEL_FR,
      CATEGORY_AUDIO_INFO_0_FR
   },
   {
      "input",
      CATEGORY_INPUT_LABEL_FR,
      CATEGORY_INPUT_INFO_0_FR
   },
   {
      "hacks",
      CATEGORY_HACKS_LABEL_FR,
      CATEGORY_HACKS_INFO_0_FR
   },
   {
      "channel_volume",
      CATEGORY_CHANNEL_VOLUME_LABEL_FR,
      CATEGORY_CHANNEL_VOLUME_INFO_0_FR
   },
   { NULL, NULL, NULL },
};
struct retro_core_option_v2_definition option_defs_fr[] = {
   {
      "genesis_plus_gx_system_hw",
      GENESIS_PLUS_GX_SYSTEM_HW_LABEL_FR,
      NULL,
      GENESIS_PLUS_GX_SYSTEM_HW_INFO_0_FR,
      NULL,
      "system",
      {
         { "auto",                 OPTION_VAL_AUTO_FR                 },
         { "sg-1000",              OPTION_VAL_SG_1000_FR              },
         { "sg-1000 II",           OPTION_VAL_SG_1000_II_FR           },
         { "sg-1000 II + ram ext.",OPTION_VAL_SG_1000_II_RAM_EXT_FR},
         { "mark-III",             OPTION_VAL_MARK_III_FR             },
         { "master system",        OPTION_VAL_MASTER_SYSTEM_FR        },
         { "master system II",     OPTION_VAL_MASTER_SYSTEM_II_FR     },
         { "game gear",            OPTION_VAL_GAME_GEAR_FR            },
         { "mega drive / genesis", OPTION_VAL_MEGA_DRIVE_GENESIS_FR   },
         { NULL, NULL },
      },
      "auto"
   },
   {
      "genesis_plus_gx_region_detect",
      GENESIS_PLUS_GX_REGION_DETECT_LABEL_FR,
      NULL,
      GENESIS_PLUS_GX_REGION_DETECT_INFO_0_FR,
      NULL,
      "system",
      {
         { "auto",    OPTION_VAL_AUTO_FR   },
         { "ntsc-u",  OPTION_VAL_NTSC_U_FR },
         { "pal",     OPTION_VAL_PAL_FR    },
         { "ntsc-j",  OPTION_VAL_NTSC_J_FR },
         { NULL, NULL },
      },
      "auto"
   },
   {
      "genesis_plus_gx_vdp_mode",
      GENESIS_PLUS_GX_VDP_MODE_LABEL_FR,
      NULL,
      GENESIS_PLUS_GX_VDP_MODE_INFO_0_FR,
      NULL,
      "system",
      {
         { "auto",  "Disabled" },
         { "60hz",  OPTION_VAL_60HZ_FR },
         { "50hz",  OPTION_VAL_50HZ_FR },
         { NULL, NULL },
      },
      "auto"
   },
   {
      "genesis_plus_gx_bios",
      GENESIS_PLUS_GX_BIOS_LABEL_FR,
      NULL,
      GENESIS_PLUS_GX_BIOS_INFO_0_FR,
      NULL,
      "system",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_system_bram",
      GENESIS_PLUS_GX_SYSTEM_BRAM_LABEL_FR,
      NULL,
      GENESIS_PLUS_GX_SYSTEM_BRAM_INFO_0_FR,
      NULL,
      "system",
      {
         { "per bios", OPTION_VAL_PER_BIOS_FR },
         { "per game", OPTION_VAL_PER_GAME_FR },
         { NULL, NULL },
      },
      "per bios"
   },
   {
      "genesis_plus_gx_cart_bram",
      GENESIS_PLUS_GX_CART_BRAM_LABEL_FR,
      NULL,
      GENESIS_PLUS_GX_CART_BRAM_INFO_0_FR,
      NULL,
      "system",
      {
         { "per cart", OPTION_VAL_PER_CART_FR },
         { "per game", OPTION_VAL_PER_GAME_FR },
         { NULL, NULL },
      },
      "per cart"
   },
   {
      "genesis_plus_gx_cart_size",
      GENESIS_PLUS_GX_CART_SIZE_LABEL_FR,
      NULL,
      GENESIS_PLUS_GX_CART_SIZE_INFO_0_FR,
      NULL,
      "system",
      {
         { "disabled", "Disabled" },
         { "128k",     OPTION_VAL_128K_FR  },
         { "256k",     OPTION_VAL_256K_FR  },
         { "512k",     OPTION_VAL_512K_FR  },
         { "1meg",     OPTION_VAL_1MEG_FR    },
         { "2meg",     OPTION_VAL_2MEG_FR    },
         { "4meg",     OPTION_VAL_4MEG_FR    },
         { NULL, NULL },
      },
      "4meg"
   },
   {
      "genesis_plus_gx_add_on",
      GENESIS_PLUS_GX_ADD_ON_LABEL_FR,
      NULL,
      GENESIS_PLUS_GX_ADD_ON_INFO_0_FR,
      NULL,
      "system",
      {
         { "auto",         OPTION_VAL_AUTO_FR },
         { "sega/mega cd", OPTION_VAL_SEGA_MEGA_CD_FR },
         { "megasd",       OPTION_VAL_MEGASD_FR },
         { "none",         OPTION_VAL_NONE_FR },
         { NULL, NULL },
      },
      "auto"
   },
   {
      "genesis_plus_gx_lock_on",
      GENESIS_PLUS_GX_LOCK_ON_LABEL_FR,
      NULL,
      GENESIS_PLUS_GX_LOCK_ON_INFO_0_FR,
      NULL,
      "system",
      {
         { "disabled",            NULL },
         { "game genie",          OPTION_VAL_GAME_GENIE_FR },
         { "action replay (pro)", OPTION_VAL_ACTION_REPLAY_PRO_FR },
         { "sonic & knuckles",    OPTION_VAL_SONIC_KNUCKLES_FR },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_aspect_ratio",
      GENESIS_PLUS_GX_ASPECT_RATIO_LABEL_FR,
      NULL,
      GENESIS_PLUS_GX_ASPECT_RATIO_INFO_0_FR,
      NULL,
      "video",
      {
         { "auto",     OPTION_VAL_AUTO_FR },
         { "NTSC PAR", OPTION_VAL_NTSC_PAR_FR },
         { "PAL PAR",  OPTION_VAL_PAL_PAR_FR },
         { "4:3",  OPTION_VAL_4_3_FR },
         { "Uncorrected",  OPTION_VAL_UNCORRECTED_FR },
      },
      "auto"
   },
   {
      "genesis_plus_gx_overscan",
      GENESIS_PLUS_GX_OVERSCAN_LABEL_FR,
      NULL,
      GENESIS_PLUS_GX_OVERSCAN_INFO_0_FR,
      NULL,
      "video",
      {
         { "disabled",   NULL },
         { "top/bottom", OPTION_VAL_TOP_BOTTOM_FR },
         { "left/right", OPTION_VAL_LEFT_RIGHT_FR },
         { "full",       OPTION_VAL_FULL_FR },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_left_border",
      GENESIS_PLUS_GX_LEFT_BORDER_LABEL_FR,
      NULL,
      GENESIS_PLUS_GX_LEFT_BORDER_INFO_0_FR,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "left border", OPTION_VAL_LEFT_BORDER_FR },
         { "left & right borders", OPTION_VAL_LEFT_RIGHT_BORDERS_FR },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_gg_extra",
      GENESIS_PLUS_GX_GG_EXTRA_LABEL_FR,
      NULL,
      GENESIS_PLUS_GX_GG_EXTRA_INFO_0_FR,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_blargg_ntsc_filter",
      GENESIS_PLUS_GX_BLARGG_NTSC_FILTER_LABEL_FR,
      NULL,
      GENESIS_PLUS_GX_BLARGG_NTSC_FILTER_INFO_0_FR,
      NULL,
      "video",
      {
         { "disabled",   NULL },
         { "monochrome", OPTION_VAL_MONOCHROME_FR },
         { "composite",  OPTION_VAL_COMPOSITE_FR },
         { "svideo",     OPTION_VAL_SVIDEO_FR },
         { "rgb",        OPTION_VAL_RGB_FR },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_lcd_filter",
      GENESIS_PLUS_GX_LCD_FILTER_LABEL_FR,
      NULL,
      GENESIS_PLUS_GX_LCD_FILTER_INFO_0_FR,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_render",
      GENESIS_PLUS_GX_RENDER_LABEL_FR,
      NULL,
      GENESIS_PLUS_GX_RENDER_INFO_0_FR,
      NULL,
      "video",
      {
         { "single field", OPTION_VAL_SINGLE_FIELD_FR },
         { "double field", OPTION_VAL_DOUBLE_FIELD_FR },
         { NULL, NULL },
      },
      "single field"
   },
   {
      "genesis_plus_gx_frameskip",
      GENESIS_PLUS_GX_FRAMESKIP_LABEL_FR,
      NULL,
      GENESIS_PLUS_GX_FRAMESKIP_INFO_0_FR,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "auto",     OPTION_VAL_AUTO_FR },
         { "manual",   OPTION_VAL_MANUAL_FR },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_frameskip_threshold",
      GENESIS_PLUS_GX_FRAMESKIP_THRESHOLD_LABEL_FR,
      NULL,
      GENESIS_PLUS_GX_FRAMESKIP_THRESHOLD_INFO_0_FR,
      NULL,
      "video",
      {
         { "15", NULL },
         { "18", NULL },
         { "21", NULL },
         { "24", NULL },
         { "27", NULL },
         { "30", NULL },
         { "33", NULL },
         { "36", NULL },
         { "39", NULL },
         { "42", NULL },
         { "45", NULL },
         { "48", NULL },
         { "51", NULL },
         { "54", NULL },
         { "57", NULL },
         { "60", NULL },
         { NULL, NULL },
      },
      "33"
   },
   {
      "genesis_plus_gx_ym2413",
      GENESIS_PLUS_GX_YM2413_LABEL_FR,
      NULL,
      GENESIS_PLUS_GX_YM2413_INFO_0_FR,
      NULL,
      "audio",
      {
         { "auto",     OPTION_VAL_AUTO_FR },
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "auto"
   },
#ifdef HAVE_OPLL_CORE
   {
      "genesis_plus_gx_ym2413_core",
      GENESIS_PLUS_GX_YM2413_CORE_LABEL_FR,
      NULL,
      GENESIS_PLUS_GX_YM2413_CORE_INFO_0_FR,
      NULL,
      "audio",
      {
         { "mame",  OPTION_VAL_MAME_FR },
         { "nuked", OPTION_VAL_NUKED_FR },
         { NULL, NULL },
      },
      "mame"
   },
#endif
   {
      "genesis_plus_gx_ym2612",
      GENESIS_PLUS_GX_YM2612_LABEL_FR,
      NULL,
#ifdef HAVE_YM3438_CORE
      GENESIS_PLUS_GX_YM2612_INFO_0_FR,
#else
      GENESIS_PLUS_GX_YM2612_INFO_1_FR,
#endif
      NULL,
      "audio",
      {
         { "mame (ym2612)",          OPTION_VAL_MAME_YM2612_FR },
         { "mame (asic ym3438)",     OPTION_VAL_MAME_ASIC_YM3438_FR },
         { "mame (enhanced ym3438)", OPTION_VAL_MAME_ENHANCED_YM3438_FR },
#ifdef HAVE_YM3438_CORE
         { "nuked (ym2612)",         OPTION_VAL_NUKED_YM2612_FR },
         { "nuked (ym3438)",         OPTION_VAL_NUKED_YM3438_FR },
#endif
         { NULL, NULL },
      },
      "mame (ym2612)"
   },
   {
      "genesis_plus_gx_sound_output",
      GENESIS_PLUS_GX_SOUND_OUTPUT_LABEL_FR,
      NULL,
      GENESIS_PLUS_GX_SOUND_OUTPUT_INFO_0_FR,
      NULL,
      "audio",
      {
         { "stereo", OPTION_VAL_STEREO_FR },
         { "mono",   OPTION_VAL_MONO_FR },
         { NULL, NULL },
      },
      "stereo"
   },
   {
      "genesis_plus_gx_audio_filter",
      GENESIS_PLUS_GX_AUDIO_FILTER_LABEL_FR,
      NULL,
      GENESIS_PLUS_GX_AUDIO_FILTER_INFO_0_FR,
      NULL,
      "audio",
      {
         { "disabled", NULL },
         { "low-pass", OPTION_VAL_LOW_PASS_FR },
#ifdef HAVE_EQ
         { "EQ",       OPTION_VAL_EQ_FR },
#endif
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_lowpass_range",
      GENESIS_PLUS_GX_LOWPASS_RANGE_LABEL_FR,
      NULL,
      GENESIS_PLUS_GX_LOWPASS_RANGE_INFO_0_FR,
      NULL,
      "audio",
      {
         { "5",  NULL },
         { "10", NULL },
         { "15", NULL },
         { "20", NULL },
         { "25", NULL },
         { "30", NULL },
         { "35", NULL },
         { "40", NULL },
         { "45", NULL },
         { "50", NULL },
         { "55", NULL },
         { "60", NULL },
         { "65", NULL },
         { "70", NULL },
         { "75", NULL },
         { "80", NULL },
         { "85", NULL },
         { "90", NULL },
         { "95", NULL },
         { NULL, NULL },
      },
      "60"
   },
   {
      "genesis_plus_gx_psg_preamp",
      GENESIS_PLUS_GX_PSG_PREAMP_LABEL_FR,
      NULL,
      GENESIS_PLUS_GX_PSG_PREAMP_INFO_0_FR,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { "105", NULL },
         { "110", NULL },
         { "115", NULL },
         { "120", NULL },
         { "125", NULL },
         { "130", NULL },
         { "135", NULL },
         { "140", NULL },
         { "145", NULL },
         { "150", NULL },
         { "155", NULL },
         { "160", NULL },
         { "165", NULL },
         { "170", NULL },
         { "175", NULL },
         { "180", NULL },
         { "185", NULL },
         { "190", NULL },
         { "195", NULL },
         { "200", NULL },
         { NULL, NULL },
      },
      "150"
   },
   {
      "genesis_plus_gx_fm_preamp",
      GENESIS_PLUS_GX_FM_PREAMP_LABEL_FR,
      NULL,
      GENESIS_PLUS_GX_FM_PREAMP_INFO_0_FR,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { "105", NULL },
         { "110", NULL },
         { "115", NULL },
         { "120", NULL },
         { "125", NULL },
         { "130", NULL },
         { "135", NULL },
         { "140", NULL },
         { "145", NULL },
         { "150", NULL },
         { "155", NULL },
         { "160", NULL },
         { "165", NULL },
         { "170", NULL },
         { "175", NULL },
         { "180", NULL },
         { "185", NULL },
         { "190", NULL },
         { "195", NULL },
         { "200", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_cdda_volume",
      GENESIS_PLUS_GX_CDDA_VOLUME_LABEL_FR,
      NULL,
      GENESIS_PLUS_GX_CDDA_VOLUME_INFO_0_FR,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_pcm_volume",
      GENESIS_PLUS_GX_PCM_VOLUME_LABEL_FR,
      NULL,
      GENESIS_PLUS_GX_PCM_VOLUME_INFO_0_FR,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
#ifdef HAVE_EQ
   {
      "genesis_plus_gx_audio_eq_low",
      GENESIS_PLUS_GX_AUDIO_EQ_LOW_LABEL_FR,
      NULL,
      GENESIS_PLUS_GX_AUDIO_EQ_LOW_INFO_0_FR,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_audio_eq_mid",
      GENESIS_PLUS_GX_AUDIO_EQ_MID_LABEL_FR,
      NULL,
      GENESIS_PLUS_GX_AUDIO_EQ_MID_INFO_0_FR,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_audio_eq_high",
      GENESIS_PLUS_GX_AUDIO_EQ_HIGH_LABEL_FR,
      NULL,
      GENESIS_PLUS_GX_AUDIO_EQ_HIGH_INFO_0_FR,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
#endif
   {
      "genesis_plus_gx_gun_input",
      GENESIS_PLUS_GX_GUN_INPUT_LABEL_FR,
      NULL,
      GENESIS_PLUS_GX_GUN_INPUT_INFO_0_FR,
      NULL,
      "input",
      {
         { "lightgun",    OPTION_VAL_LIGHTGUN_FR },
         { "touchscreen", OPTION_VAL_TOUCHSCREEN_FR },
         { NULL, NULL },
      },
      "lightgun"
   },
   {
      "genesis_plus_gx_gun_cursor",
      GENESIS_PLUS_GX_GUN_CURSOR_LABEL_FR,
      NULL,
      GENESIS_PLUS_GX_GUN_CURSOR_INFO_0_FR,
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_invert_mouse",
      GENESIS_PLUS_GX_INVERT_MOUSE_LABEL_FR,
      NULL,
      GENESIS_PLUS_GX_INVERT_MOUSE_INFO_0_FR,
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_no_sprite_limit",
      GENESIS_PLUS_GX_NO_SPRITE_LIMIT_LABEL_FR,
      NULL,
      GENESIS_PLUS_GX_NO_SPRITE_LIMIT_INFO_0_FR,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_enhanced_vscroll",
      GENESIS_PLUS_GX_ENHANCED_VSCROLL_LABEL_FR,
      NULL,
      GENESIS_PLUS_GX_ENHANCED_VSCROLL_INFO_0_FR,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_enhanced_vscroll_limit",
      GENESIS_PLUS_GX_ENHANCED_VSCROLL_LIMIT_LABEL_FR,
      NULL,
      GENESIS_PLUS_GX_ENHANCED_VSCROLL_LIMIT_INFO_0_FR,
      NULL,
      "hacks",
      {
         { "2", NULL },
         { "3",  NULL },
         { "4", NULL },
         { "5",  NULL },
         { "6", NULL },
         { "7",  NULL },
         { "8", NULL },
         { "9",  NULL },
         { "10", NULL },
         { "11",  NULL },
         { "12", NULL },
         { "13",  NULL },
         { "14", NULL },
         { "15",  NULL },
         { "16", NULL },
         { NULL, NULL },
      },
      "8"
   },
#ifdef HAVE_OVERCLOCK
   {
      "genesis_plus_gx_overclock",
      GENESIS_PLUS_GX_OVERCLOCK_LABEL_FR,
      NULL,
      GENESIS_PLUS_GX_OVERCLOCK_INFO_0_FR,
      NULL,
      "hacks",
      {
         { "100", OPTION_VAL_100_FR },
         { "125", OPTION_VAL_125_FR },
         { "150", OPTION_VAL_150_FR },
         { "175", OPTION_VAL_175_FR },
         { "200", OPTION_VAL_200_FR },
         { "225", OPTION_VAL_225_FR },
         { "250", OPTION_VAL_250_FR },
         { "275", OPTION_VAL_275_FR },
         { "300", OPTION_VAL_300_FR },
         { "325", OPTION_VAL_325_FR },
         { "350", OPTION_VAL_350_FR },
         { "375", OPTION_VAL_375_FR },
         { "400", OPTION_VAL_400_FR },
         { "425", OPTION_VAL_425_FR },
         { "450", OPTION_VAL_450_FR },
         { "475", OPTION_VAL_475_FR },
         { "500", OPTION_VAL_500_FR },
         { NULL, NULL },
      },
      "100%"
   },
#endif
   {
      "genesis_plus_gx_force_dtack",
      GENESIS_PLUS_GX_FORCE_DTACK_LABEL_FR,
      NULL,
      GENESIS_PLUS_GX_FORCE_DTACK_INFO_0_FR,
      NULL,
      "hacks",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL },
      },
      "enabled"
   },
   {
      "genesis_plus_gx_addr_error",
      GENESIS_PLUS_GX_ADDR_ERROR_LABEL_FR,
      NULL,
      GENESIS_PLUS_GX_ADDR_ERROR_INFO_0_FR,
      NULL,
      "hacks",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL },
      },
      "enabled"
   },
   {
      "genesis_plus_gx_cd_latency",
      GENESIS_PLUS_GX_CD_LATENCY_LABEL_FR,
      NULL,
      GENESIS_PLUS_GX_CD_LATENCY_INFO_0_FR,
      NULL,
      "hacks",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL },
      },
      "enabled"
   },
   {
      "genesis_plus_gx_cd_precache",
      GENESIS_PLUS_GX_CD_PRECACHE_LABEL_FR,
      NULL,
      GENESIS_PLUS_GX_CD_PRECACHE_INFO_0_FR,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
#ifdef USE_PER_SOUND_CHANNELS_CONFIG
   {
      "genesis_plus_gx_show_advanced_audio_settings",
      GENESIS_PLUS_GX_SHOW_ADVANCED_AUDIO_SETTINGS_LABEL_FR,
      NULL,
      GENESIS_PLUS_GX_SHOW_ADVANCED_AUDIO_SETTINGS_INFO_0_FR,
      NULL,
      "channel_volume",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL},
      },
      "disabled"
   },
   {
      "genesis_plus_gx_psg_channel_0_volume",
      GENESIS_PLUS_GX_PSG_CHANNEL_0_VOLUME_LABEL_FR,
      NULL,
      GENESIS_PLUS_GX_PSG_CHANNEL_0_VOLUME_INFO_0_FR,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_psg_channel_1_volume",
      GENESIS_PLUS_GX_PSG_CHANNEL_1_VOLUME_LABEL_FR,
      NULL,
      GENESIS_PLUS_GX_PSG_CHANNEL_1_VOLUME_INFO_0_FR,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_psg_channel_2_volume",
      GENESIS_PLUS_GX_PSG_CHANNEL_2_VOLUME_LABEL_FR,
      NULL,
      GENESIS_PLUS_GX_PSG_CHANNEL_2_VOLUME_INFO_0_FR,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_psg_channel_3_volume",
      GENESIS_PLUS_GX_PSG_CHANNEL_3_VOLUME_LABEL_FR,
      NULL,
      GENESIS_PLUS_GX_PSG_CHANNEL_3_VOLUME_INFO_0_FR,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_0_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_0_VOLUME_LABEL_FR,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_0_VOLUME_INFO_0_FR,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_1_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_1_VOLUME_LABEL_FR,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_1_VOLUME_INFO_0_FR,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_2_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_2_VOLUME_LABEL_FR,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_2_VOLUME_INFO_0_FR,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_3_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_3_VOLUME_LABEL_FR,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_3_VOLUME_INFO_0_FR,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_4_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_4_VOLUME_LABEL_FR,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_4_VOLUME_INFO_0_FR,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_5_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_5_VOLUME_LABEL_FR,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_5_VOLUME_INFO_0_FR,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_0_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_0_VOLUME_LABEL_FR,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_0_VOLUME_INFO_0_FR,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_1_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_1_VOLUME_LABEL_FR,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_1_VOLUME_INFO_0_FR,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_2_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_2_VOLUME_LABEL_FR,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_2_VOLUME_INFO_0_FR,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_3_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_3_VOLUME_LABEL_FR,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_3_VOLUME_INFO_0_FR,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_4_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_4_VOLUME_LABEL_FR,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_4_VOLUME_INFO_0_FR,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_5_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_5_VOLUME_LABEL_FR,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_5_VOLUME_INFO_0_FR,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_6_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_6_VOLUME_LABEL_FR,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_6_VOLUME_INFO_0_FR,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_7_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_7_VOLUME_LABEL_FR,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_7_VOLUME_INFO_0_FR,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_8_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_8_VOLUME_LABEL_FR,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_8_VOLUME_INFO_0_FR,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
#endif
   { NULL, NULL, NULL, NULL, NULL, NULL, {{0}}, NULL },
};
struct retro_core_options_v2 options_fr = {
   option_cats_fr,
   option_defs_fr
};

/* RETRO_LANGUAGE_GA */

#define CATEGORY_SYSTEM_LABEL_GA "Córas"
#define CATEGORY_SYSTEM_INFO_0_GA "Athraigh an rogha crua-earraí bunúsach, an réigiún, an BIOS agus socruithe comhaid sábhála Sega CD/Mega-CD."
#define CATEGORY_VIDEO_LABEL_GA "Físeán"
#define CATEGORY_VIDEO_INFO_0_GA "Athraigh cóimheas gné, bearradh taispeána, scagaire físe agus socruithe scipeála frámaí."
#define CATEGORY_AUDIO_LABEL_GA "Fuaim"
#define CATEGORY_AUDIO_INFO_0_GA "Athraigh socruithe gléis fuaime."
#define CATEGORY_INPUT_LABEL_GA "Ionchur"
#define CATEGORY_INPUT_INFO_0_GA "Athraigh socruithe ionchuir an ghunna solais agus/nó an luiche."
#define CATEGORY_HACKS_LABEL_GA "Cleasanna Aithrise"
#define CATEGORY_HACKS_INFO_0_GA "Athraigh socruithe róchlogála agus cruinneas aithrise próiseálaí a mbíonn tionchar acu ar fheidhmíocht agus comhoiriúnacht íseal-leibhéil."
#define CATEGORY_CHANNEL_VOLUME_LABEL_GA "Socruithe Ardleibhéil Imleabhair Cainéal"
#define CATEGORY_CHANNEL_VOLUME_INFO_0_GA "Athraigh toirt na gcainéal fuaime crua-earraí aonair."
#define GENESIS_PLUS_GX_SYSTEM_HW_LABEL_GA "Crua-earraí an Chórais"
#define GENESIS_PLUS_GX_SYSTEM_HW_INFO_0_GA "Rith ábhar luchtaithe le consól aithriste ar leith. Roghnóidh 'Auto' an córas is oiriúnaí don chluiche reatha."
#define OPTION_VAL_AUTO_GA "Uathoibríoch"
#define OPTION_VAL_SG_1000_GA NULL
#define OPTION_VAL_SG_1000_II_GA NULL
#define OPTION_VAL_SG_1000_II_RAM_EXT_GA NULL
#define OPTION_VAL_MARK_III_GA NULL
#define OPTION_VAL_MASTER_SYSTEM_GA NULL
#define OPTION_VAL_MASTER_SYSTEM_II_GA NULL
#define OPTION_VAL_GAME_GEAR_GA NULL
#define OPTION_VAL_MEGA_DRIVE_GENESIS_GA NULL
#define GENESIS_PLUS_GX_REGION_DETECT_LABEL_GA "Réigiún an Chórais"
#define GENESIS_PLUS_GX_REGION_DETECT_INFO_0_GA "Sonraigh cén réigiún as a bhfuil an córas. I gcás consóil seachas an Game Gear, is é 50 Hz an 'PAL', agus is é 60 Hz an 'NTSC'. Féadfaidh cluichí rith níos tapúla nó níos moille ná mar is gnách má roghnaítear an réigiún mícheart."
#define OPTION_VAL_NTSC_U_GA NULL
#define OPTION_VAL_PAL_GA NULL
#define OPTION_VAL_NTSC_J_GA NULL
#define GENESIS_PLUS_GX_VDP_MODE_LABEL_GA "Mód VDP Fórsála"
#define GENESIS_PLUS_GX_VDP_MODE_INFO_0_GA "Sáraíonn sé an modh VDP chun é a chur ag rith ag NTSC 60Hz nó PAL 50Hz, beag beann ar réigiún an chórais."
#define OPTION_VAL_60HZ_GA NULL
#define OPTION_VAL_50HZ_GA NULL
#define GENESIS_PLUS_GX_BIOS_LABEL_GA "ROM Tosaithe Córais"
#define GENESIS_PLUS_GX_BIOS_INFO_0_GA "Bain úsáid as an BIOS/tosaitheoir oifigiúil le haghaidh crua-earraí aithriste, má tá sé i láthair in eolaire córais RetroArch. Taispeánann sé seicheamh/beochan tosaithe atá sainiúil don chonsól, agus ansin ritheann sé ábhar luchtaithe."
#define GENESIS_PLUS_GX_SYSTEM_BRAM_LABEL_GA "Córas CD BRAM (Atosú Éilitheach)"
#define GENESIS_PLUS_GX_SYSTEM_BRAM_INFO_0_GA "Agus ábhar Sega CD/Mega-CD á rith, sonraítear an ndéanfar comhad sábhála aonair a roinnt idir na cluichí go léir ó réigiún ar leith (In aghaidh an BIOS) nó comhad sábhála ar leith a chruthú do gach cluiche (In aghaidh an Chluiche). Tabhair faoi deara go bhfuil stóráil inmheánach theoranta ag an Sega CD/Mega-CD, nach leor ach do roinnt teidil. Chun nach rithfidh tú as spás, moltar an socrú 'In aghaidh an Chluiche'."
#define OPTION_VAL_PER_BIOS_GA "In aghaidh an BIOS"
#define OPTION_VAL_PER_GAME_GA "In aghaidh an Chluiche"
#define GENESIS_PLUS_GX_CART_BRAM_LABEL_GA "Cairt Cúltaca CD BRAM (Atosú Éilitheach)"
#define GENESIS_PLUS_GX_CART_BRAM_INFO_0_GA "Agus ábhar Sega CD/Mega-CD á rith, sonraítear ann an ndéanfar cairt RAM cúltaca aonair a roinnt do gach cluiche (In aghaidh an Chairt) nó cairt RAM cúltaca ar leith a chruthú do gach cluiche (In aghaidh an Chluiche)."
#define OPTION_VAL_PER_CART_GA "In aghaidh an cartúis"
#define GENESIS_PLUS_GX_CART_SIZE_LABEL_GA "Méid BRAM Cairt Cúltaca CD (Atosú Éilitheach)"
#define GENESIS_PLUS_GX_CART_SIZE_INFO_0_GA "Socraíonn sé seo méid an chairt reithe cúltaca agus ábhar Sega CD/Mega-CD á rith. Úsáideach nuair a shocraítear an chairt reithe cúltaca go In aghaidh an Chluiche chun méideanna cairte níos mó iolracha a sheachaint."
#define OPTION_VAL_128K_GA NULL
#define OPTION_VAL_256K_GA NULL
#define OPTION_VAL_512K_GA NULL
#define OPTION_VAL_1MEG_GA NULL
#define OPTION_VAL_2MEG_GA NULL
#define OPTION_VAL_4MEG_GA NULL
#define GENESIS_PLUS_GX_ADD_ON_LABEL_GA "Breiseán CD (mód MD) (Éilíonn Atosú)"
#define GENESIS_PLUS_GX_ADD_ON_INFO_0_GA "Sonraigh cén breiseán atá le húsáid le haghaidh athsheinm fuaime CD le cluichí Mega Drive/Genesis a dtacaítear leo."
#define OPTION_VAL_SEGA_MEGA_CD_GA NULL
#define OPTION_VAL_MEGASD_GA NULL
#define OPTION_VAL_NONE_GA "Dada"
#define GENESIS_PLUS_GX_LOCK_ON_LABEL_GA "Glasáil Cartús-Ar"
#define GENESIS_PLUS_GX_LOCK_ON_INFO_0_GA "Is gné Mega Drive/Genesis í an Teicneolaíocht Glasála a chuir ar chumas cluiche níos sine ceangal le port pas-trí cartús speisialta le haghaidh súgartha sínte nó athraithe. Sonraíonn an rogha seo cén cineál cartús speisialta 'glasála' atá le haithris. Ní mór comhad bios comhfhreagrach a bheith i láthair in eolaire córais RetroArch."
#define OPTION_VAL_GAME_GENIE_GA NULL
#define OPTION_VAL_ACTION_REPLAY_PRO_GA NULL
#define OPTION_VAL_SONIC_KNUCKLES_GA NULL
#define GENESIS_PLUS_GX_ASPECT_RATIO_LABEL_GA "Cóimheas Gnéithe arna Sholáthrú ag an gCroí"
#define GENESIS_PLUS_GX_ASPECT_RATIO_INFO_0_GA "Roghnaigh an cóimheas gné ábhair is fearr leat. Ní bheidh feidhm ag seo ach amháin nuair a bheidh cóimheas gné RetroArch socraithe go 'Croílár curtha ar fáil' sna socruithe Físeáin."
#define OPTION_VAL_NTSC_PAR_GA NULL
#define OPTION_VAL_PAL_PAR_GA NULL
#define OPTION_VAL_4_3_GA NULL
#define OPTION_VAL_UNCORRECTED_GA "Gan cheartú"
#define GENESIS_PLUS_GX_OVERSCAN_LABEL_GA "Teorainneacha"
#define GENESIS_PLUS_GX_OVERSCAN_INFO_0_GA "Cumasaigh é seo chun na réigiúin ró-scan a thaispeáint ag barr/bun agus/nó ar chlé/ar dheis an scáileáin. De ghnáth, bheadh ​​siad seo i bhfolach ag an mbezel timpeall imeall teilifíse caighdeánach sainmhínithe."
#define OPTION_VAL_TOP_BOTTOM_GA "Barr/Bun"
#define OPTION_VAL_LEFT_RIGHT_GA "Clé/Deas"
#define OPTION_VAL_FULL_GA "Lán"
#define GENESIS_PLUS_GX_LEFT_BORDER_LABEL_GA "Folaigh Teorainneacha Taobh an Mháistirchórais"
#define GENESIS_PLUS_GX_LEFT_BORDER_INFO_0_GA "Gearrann sé 8 bpicteil ó thaobh clé an scáileáin, nó ón dá thaobh clé agus deas agus cluichí Master System á reáchtáil."
#define OPTION_VAL_LEFT_BORDER_GA "Imeall Clé Amháin"
#define OPTION_VAL_LEFT_RIGHT_BORDERS_GA "Teorainneacha Clé & Deis"
#define GENESIS_PLUS_GX_GG_EXTRA_LABEL_GA "Scáileán Leathnaithe Game Gear"
#define GENESIS_PLUS_GX_GG_EXTRA_INFO_0_GA "Éiríonn sé seo le teidil Game Gear a rith i mód SMS, le taifeach méadaithe de 256x192. Féadfaidh sé ábhar breise a thaispeáint, ach de ghnáth taispeánann sé teorainn de shonraí íomhá truaillithe/nach dteastaíonn."
#define GENESIS_PLUS_GX_BLARGG_NTSC_FILTER_LABEL_GA "Scagaire NTSC Blargg"
#define GENESIS_PLUS_GX_BLARGG_NTSC_FILTER_INFO_0_GA "Cuir scagaire físe i bhfeidhm chun comharthaí teilifíse NTSC éagsúla a aithris."
#define OPTION_VAL_MONOCHROME_GA "Monacrómach"
#define OPTION_VAL_COMPOSITE_GA "Ilchodach"
#define OPTION_VAL_SVIDEO_GA "S-Físeán"
#define OPTION_VAL_RGB_GA NULL
#define GENESIS_PLUS_GX_LCD_FILTER_LABEL_GA "Scagaire Taibhse LCD"
#define GENESIS_PLUS_GX_LCD_FILTER_INFO_0_GA "Cuir scagaire 'taibhsithe' íomhá i bhfeidhm chun tréithe taispeána phainéil LCD Game Gear agus Genesis Nomad a aithris."
#define GENESIS_PLUS_GX_RENDER_LABEL_GA "Aschur Mód Idirfhite 2"
#define GENESIS_PLUS_GX_RENDER_INFO_0_GA "Ligeann Mód Idirfhite 2 don Mega Drive/Genesis íomhá 320x448 airde dhúbailte (ardtaifigh) a aschur trí línte scanadh malartacha a tharraingt i ngach fráma (úsáideann modhanna il-imreora Sonic the Hedgehog 2 agus Combat Cars é seo). Déanann 'Double Field' aithris ar chrua-earraí bunaidh, ag táirgeadh íomhá ghéar le déantáin splancacha/idirfhite. Cuireann 'Single Field' scagaire dí-idirfhite i bhfeidhm, rud a chobhsaíonn an íomhá ach a chruthaíonn doiléiriú beag."
#define OPTION_VAL_SINGLE_FIELD_GA "Réimse Aonair"
#define OPTION_VAL_DOUBLE_FIELD_GA "Réimse Dúbailte"
#define GENESIS_PLUS_GX_FRAMESKIP_LABEL_GA "Fráma-léim"
#define GENESIS_PLUS_GX_FRAMESKIP_INFO_0_GA "Léim frámaí chun fo-rith maoláin fuaime (crágáil) a sheachaint. Feabhsaíonn sé feidhmíocht ar chostas réidhe amhairc. Léimeann 'Uath' frámaí nuair a thugann an tosaitheoir comhairle. Úsáideann 'Lámhleabhar' an socrú 'Tairseach Léim Frámaí (%)'."
#define OPTION_VAL_MANUAL_GA "Lámhleabhar"
#define GENESIS_PLUS_GX_FRAMESKIP_THRESHOLD_LABEL_GA "Tairseach Léim Fráma (%)"
#define GENESIS_PLUS_GX_FRAMESKIP_THRESHOLD_INFO_0_GA "Nuair a shocraítear 'Frameskip' go 'Lámhleabhar', sonraítear an tairseach áitíochta maoláin fuaime (céatadán) faoina mbeidh frámaí á scipeáil. Laghdaíonn luachanna níos airde an baol go mbeidh frámaí ag scoilteadh trína chur faoi deara go gcaillfear frámaí níos minice."
#define GENESIS_PLUS_GX_YM2413_LABEL_GA NULL
#define GENESIS_PLUS_GX_YM2413_INFO_0_GA "Cumasaigh aithris ar an Aonad Fuaime FM a úsáideann cluichí áirithe Sega Mark III/Master System le haghaidh aschur fuaime feabhsaithe."
#define GENESIS_PLUS_GX_YM2413_CORE_LABEL_GA "Croílár an Mháistirchórais FM (YM2413)"
#define GENESIS_PLUS_GX_YM2413_CORE_INFO_0_GA "Roghnaigh an modh a úsáidtear chun Aonad Fuaime FM an Chórais Sega Mark III/Master a aithris. Tá an rogha 'MAME' gasta, agus ritheann sé ar lánluas ar fhormhór na gcóras. Tá an rogha 'Nuked' cruinn ó thaobh timthrialla de, ardchaighdeáin, agus tá riachtanais shuntasacha LAP aige."
#define OPTION_VAL_MAME_GA NULL
#define OPTION_VAL_NUKED_GA NULL
#define GENESIS_PLUS_GX_YM2612_LABEL_GA NULL
#define GENESIS_PLUS_GX_YM2612_INFO_0_GA "Roghnaigh an modh a úsáidtear chun sintéiseoir FM (príomhghineadóir fuaime) an Mega Drive/Genesis a aithris. Tá roghanna 'MAME' gasta, agus ritheann siad ar lánluas ar fhormhór na gcóras. Tá roghanna 'Nuked' cruinn ó thaobh timthrialla de, ardchaighdeáin, agus tá riachtanais shuntasacha LAP acu. Úsáideann an Model 1 Mega Drive/Genesis bunaidh an tslis YM2612. Úsáidtear an YM3438 in athbhreithnithe níos déanaí ar Mega Drive/Genesis."
#define GENESIS_PLUS_GX_YM2612_INFO_1_GA "Roghnaigh an modh a úsáidtear chun sintéiseoir FM (príomhghineadóir fuaime) an Mega Drive/Genesis a aithris. Úsáideann an Mega Drive/Genesis bunaidh an tslis YM2612. Úsáidtear an YM3438 in athbhreithnithe níos déanaí ar an Mega Drive/Genesis."
#define OPTION_VAL_MAME_YM2612_GA NULL
#define OPTION_VAL_MAME_ASIC_YM3438_GA NULL
#define OPTION_VAL_MAME_ENHANCED_YM3438_GA "MAME (YM3438 Feabhsaithe)"
#define OPTION_VAL_NUKED_YM2612_GA NULL
#define OPTION_VAL_NUKED_YM3438_GA NULL
#define GENESIS_PLUS_GX_SOUND_OUTPUT_LABEL_GA "Aschur Fuaime"
#define GENESIS_PLUS_GX_SOUND_OUTPUT_INFO_0_GA "Roghnaigh athsheinm fuaime steiréó nó mona."
#define OPTION_VAL_STEREO_GA "Steiréó"
#define OPTION_VAL_MONO_GA NULL
#define GENESIS_PLUS_GX_AUDIO_FILTER_LABEL_GA "Scagaire Fuaime"
#define GENESIS_PLUS_GX_AUDIO_FILTER_INFO_0_GA "Cumasaigh scagaire fuaime ísealpas chun fuaim shainiúil Model 1 Mega Drive/Genesis a insamhladh níos fearr."
#define OPTION_VAL_LOW_PASS_GA "Íseal-Phas"
#define OPTION_VAL_EQ_GA NULL
#define GENESIS_PLUS_GX_LOWPASS_RANGE_LABEL_GA "Scagaire Íseal-Phas %"
#define GENESIS_PLUS_GX_LOWPASS_RANGE_INFO_0_GA "Sonraigh minicíocht scoite an scagaire íseal-phas fuaime. Méadaíonn luach níos airde 'neart' braite an scagaire, ós rud é go laghdaítear raon níos leithne den speictream ardmhinicíochta."
#define GENESIS_PLUS_GX_PSG_PREAMP_LABEL_GA "Leibhéal Réamh-Amp PSG"
#define GENESIS_PLUS_GX_PSG_PREAMP_INFO_0_GA "Socraigh leibhéal an réamh-aimplitheora fuaime don Ghineadóir Fuaime In-ríomhchláraithe 4-chainéil SN76496 aithriste atá le fáil sa SG-1000, Sega Mark III, Master System, Game Gear agus Mega Drive/Genesis."
#define GENESIS_PLUS_GX_FM_PREAMP_LABEL_GA "Leibhéal Réamh-Aimplitheoir FM"
#define GENESIS_PLUS_GX_FM_PREAMP_INFO_0_GA "Socraigh leibhéal an réamh-aimplitheora fuaime don sintéiseoir fuaime aithrisithe Mega Drive/Genesis FM nó don Aonad Fuaime FM Sega Mark III/Master System."
#define GENESIS_PLUS_GX_CDDA_VOLUME_LABEL_GA "Imleabhar CD-DA"
#define GENESIS_PLUS_GX_CDDA_VOLUME_INFO_0_GA "Coigeartaigh toirt mheasctha aschur athsheinm fuaime an CD aithrisithe."
#define GENESIS_PLUS_GX_PCM_VOLUME_LABEL_GA "Imleabhar PCM"
#define GENESIS_PLUS_GX_PCM_VOLUME_INFO_0_GA "Coigeartaigh toirt mheasctha aschur gineadóir fuaime Sega CD/Mega-CD RF5C164 PCM aithrisithe."
#define GENESIS_PLUS_GX_AUDIO_EQ_LOW_LABEL_GA "Cothromóir Íseal"
#define GENESIS_PLUS_GX_AUDIO_EQ_LOW_INFO_0_GA "Coigeartaigh an banda íseal-raoin den chothromóir fuaime inmheánaigh."
#define GENESIS_PLUS_GX_AUDIO_EQ_MID_LABEL_GA "EQ Lár"
#define GENESIS_PLUS_GX_AUDIO_EQ_MID_INFO_0_GA "Coigeartaigh banda lár-raoin an chothromóra fuaime inmheánaigh."
#define GENESIS_PLUS_GX_AUDIO_EQ_HIGH_LABEL_GA "Ard-EQ"
#define GENESIS_PLUS_GX_AUDIO_EQ_HIGH_INFO_0_GA "Coigeartaigh an banda ard-raoin den chothromóir fuaime inmheánaigh."
#define GENESIS_PLUS_GX_GUN_INPUT_LABEL_GA "Ionchur Gunna Solais"
#define GENESIS_PLUS_GX_GUN_INPUT_INFO_0_GA "Bain úsáid as ionchur 'Gunna Solais' nó 'Scáileán Tadhaill' atá rialaithe ag an luch."
#define OPTION_VAL_LIGHTGUN_GA "Gunna Solais"
#define OPTION_VAL_TOUCHSCREEN_GA "Scáileán tadhaill"
#define GENESIS_PLUS_GX_GUN_CURSOR_LABEL_GA "Taispeáin Crosghruaig Gunna Solais"
#define GENESIS_PLUS_GX_GUN_CURSOR_INFO_0_GA "Taispeáin crosrianta gunna solais agus na cineálacha gléasanna ionchuir MD Menacer, MD Justifiers agus MS Light Phaser in úsáid."
#define GENESIS_PLUS_GX_INVERT_MOUSE_LABEL_GA "Inbhéartaigh Ais-Y na Luiche"
#define GENESIS_PLUS_GX_INVERT_MOUSE_INFO_0_GA "Déanann sé ais-Y an chineáil gléis ionchuir Luch MD a aisiompú."
#define GENESIS_PLUS_GX_NO_SPRITE_LIMIT_LABEL_GA "Bain Teorainn Sprite In Aghaidh na Líne"
#define GENESIS_PLUS_GX_NO_SPRITE_LIMIT_INFO_0_GA "Baintear an teorainn crua-earraí bunaidh sprite-in-aghaidh-scannánlíne. Laghdaíonn sé seo an caochadh ach is féidir leis fabhtanna amhairc a chur faoi deara, toisc go mbaintear leas as an teorainn crua-earraí i roinnt cluichí chun éifeachtaí speisialta a ghiniúint."
#define GENESIS_PLUS_GX_ENHANCED_VSCROLL_LABEL_GA "Scrollaigh ingearach feabhsaithe in aghaidh an tíle"
#define GENESIS_PLUS_GX_ENHANCED_VSCROLL_INFO_0_GA "Ceadaíonn sé seo gach cill aonair a scrollú go hingearach, in ionad 16px 2-chill, trí mheán a bhaint amach le luach vscroll na cille comharsanachta. Ní bhaineann an cleas seo ach le cúpla cluiche a úsáideann mód scrollú ingearach 2-chill."
#define GENESIS_PLUS_GX_ENHANCED_VSCROLL_LIMIT_LABEL_GA "Teorainn scrollaithe ingearach feabhsaithe in aghaidh an tíle"
#define GENESIS_PLUS_GX_ENHANCED_VSCROLL_LIMIT_INFO_0_GA "Nuair a bhíonn scrolla ingearach feabhsaithe in aghaidh an tíle cumasaithe amháin. Coigeartaíonn sé teorainn an fheabhsaithe scrolla ingearach. Nuair a bhíonn an difríocht vscroll idir tíleanna comharsanacha níos mó ná an teorainn seo, díchumasaítear an feabhsú."
#define GENESIS_PLUS_GX_OVERCLOCK_LABEL_GA "Luas LAP"
#define GENESIS_PLUS_GX_OVERCLOCK_INFO_0_GA "Róchlogáil an LAP aithrisithe. Is féidir leis an moilliú a laghdú, ach d'fhéadfadh sé go mbeadh teipeanna mar thoradh air."
#define OPTION_VAL_100_GA NULL
#define OPTION_VAL_125_GA NULL
#define OPTION_VAL_150_GA NULL
#define OPTION_VAL_175_GA NULL
#define OPTION_VAL_200_GA NULL
#define OPTION_VAL_225_GA NULL
#define OPTION_VAL_250_GA NULL
#define OPTION_VAL_275_GA NULL
#define OPTION_VAL_300_GA NULL
#define OPTION_VAL_325_GA NULL
#define OPTION_VAL_350_GA NULL
#define OPTION_VAL_375_GA NULL
#define OPTION_VAL_400_GA NULL
#define OPTION_VAL_425_GA NULL
#define OPTION_VAL_450_GA NULL
#define OPTION_VAL_475_GA NULL
#define OPTION_VAL_500_GA NULL
#define GENESIS_PLUS_GX_FORCE_DTACK_LABEL_GA "Glasálacha Córais"
#define GENESIS_PLUS_GX_FORCE_DTACK_INFO_0_GA "Déan aithris ar ghlasálacha córais a tharlaíonn ar chrua-earraí fíor agus rochtain neamhdhleathach seoltaí á déanamh. Níor cheart é seo a dhíchumasú ach amháin agus taispeántais agus grúdaireacht bhaile áirithe á n-imirt a bhraitheann ar iompar neamhdhleathach le haghaidh oibriú ceart."
#define GENESIS_PLUS_GX_ADDR_ERROR_LABEL_GA "Earráid Seoladh 68K"
#define GENESIS_PLUS_GX_ADDR_ERROR_INFO_0_GA "Gineann príomh-LAP Mega Drive/Genesis (Motorola 68000) eisceacht Earráid Seolta (tuairteáil) agus iarracht á déanamh rochtain neamhailínithe ar chuimhne. Má chumasaítear é seo, déanfar an t-iompar seo a insamhladh. Níor cheart é a dhíchumasú ach amháin agus hacks ROM á n-imirt, ós rud é go bhforbraítear iad seo de ghnáth ag baint úsáide as aithriseoirí nach bhfuil chomh cruinn agus go bhféadfadh siad brath ar rochtain RAM neamhbhailí le haghaidh oibriú ceart."
#define GENESIS_PLUS_GX_CD_LATENCY_LABEL_GA "Am Rochtana CD"
#define GENESIS_PLUS_GX_CD_LATENCY_INFO_0_GA "Insamhladh a dhéanamh ar mhoill chrua-earraí bunaidh CD agus léamh á thosú nó nuair a bhíonn suíomh ar leith á lorg ar dhiosca luchtaithe. Tá sé seo riachtanach i gcás roinnt cluichí CD a thuairteálann má bhíonn sonraí CD ar fáil ró-luath agus réitíonn sé fadhbanna díshioncrónaithe fuaime CD i roinnt cluichí freisin. Is féidir é seo a dhíchumasú a bheith úsáideach le cluichí MSU-MD mar go ndéanann sé lúba rianta fuaime CD níos gan uaim."
#define GENESIS_PLUS_GX_CD_PRECACHE_LABEL_GA "Taisce Íomhá CD"
#define GENESIS_PLUS_GX_CD_PRECACHE_INFO_0_GA "Luchtaigh íomhá CD isteach sa chuimhne ag am tosaithe. Tacaítear le CHD amháin. Atosú Riachtanach."
#define GENESIS_PLUS_GX_SHOW_ADVANCED_AUDIO_SETTINGS_LABEL_GA "Taispeáin Socruithe Ardleibhéil Imleabhair Fuaime (Athoscail an roghchlár)"
#define GENESIS_PLUS_GX_SHOW_ADVANCED_AUDIO_SETTINGS_INFO_0_GA "Cumasaigh cumraíocht paraiméadair chainéil fuaime íseal-leibhéil. TABHAIR FAOI DEARA: Ní mór an Roghchlár Tapa a athrú chun go dtiocfaidh an socrú seo i bhfeidhm."
#define GENESIS_PLUS_GX_PSG_CHANNEL_0_VOLUME_LABEL_GA "Cainéal Ton PSG 0 Imleabhar %"
#define GENESIS_PLUS_GX_PSG_CHANNEL_0_VOLUME_INFO_0_GA "Laghdaigh toirt Chainéal Tóin PSG 0."
#define GENESIS_PLUS_GX_PSG_CHANNEL_1_VOLUME_LABEL_GA "% Imleabhar Cainéal 1 Ton PSG"
#define GENESIS_PLUS_GX_PSG_CHANNEL_1_VOLUME_INFO_0_GA "Laghdaigh toirt Chainéal 1 Tóin PSG."
#define GENESIS_PLUS_GX_PSG_CHANNEL_2_VOLUME_LABEL_GA "% Imleabhar Cainéal 2 Ton PSG"
#define GENESIS_PLUS_GX_PSG_CHANNEL_2_VOLUME_INFO_0_GA "Laghdaigh toirt Chainéal 2 Tone PSG."
#define GENESIS_PLUS_GX_PSG_CHANNEL_3_VOLUME_LABEL_GA "Torann PSG Cainéal 3 Imleabhar %"
#define GENESIS_PLUS_GX_PSG_CHANNEL_3_VOLUME_INFO_0_GA "Laghdaigh toirt Chainéal Torainn PSG 3."
#define GENESIS_PLUS_GX_MD_CHANNEL_0_VOLUME_LABEL_GA "Cainéal Mega Drive/Genesis FM 0 % Imleabhar"
#define GENESIS_PLUS_GX_MD_CHANNEL_0_VOLUME_INFO_0_GA "Laghdaigh toirt Cainéal 0 Mega Drive/Genesis FM. Ní oibríonn sé ach le hinslitheoirí MAME FM."
#define GENESIS_PLUS_GX_MD_CHANNEL_1_VOLUME_LABEL_GA "Cainéal 1 Mega Drive/Genesis FM % Toirt"
#define GENESIS_PLUS_GX_MD_CHANNEL_1_VOLUME_INFO_0_GA "Laghdaigh toirt Cainéal 1 Mega Drive/Genesis FM. Ní oibríonn sé ach le hinslitheoirí MAME FM."
#define GENESIS_PLUS_GX_MD_CHANNEL_2_VOLUME_LABEL_GA "Cainéal 2 Mega Drive/Genesis FM % Toirt"
#define GENESIS_PLUS_GX_MD_CHANNEL_2_VOLUME_INFO_0_GA "Laghdaigh toirt Cainéal 2 Mega Drive/Genesis FM. Ní oibríonn sé ach le hinslitheoirí MAME FM."
#define GENESIS_PLUS_GX_MD_CHANNEL_3_VOLUME_LABEL_GA "Cainéal 3 Mega Drive/Genesis FM % Toirt"
#define GENESIS_PLUS_GX_MD_CHANNEL_3_VOLUME_INFO_0_GA "Laghdaigh toirt Cainéal 3 Mega Drive/Genesis FM. Ní oibríonn sé ach le hinslitheoirí MAME FM."
#define GENESIS_PLUS_GX_MD_CHANNEL_4_VOLUME_LABEL_GA "Mega Drive/Genesis FM Cainéal 4 % Toirt"
#define GENESIS_PLUS_GX_MD_CHANNEL_4_VOLUME_INFO_0_GA "Laghdaigh toirt Cainéal 4 Mega Drive/Genesis FM. Ní oibríonn sé ach le hinslitheoirí MAME FM."
#define GENESIS_PLUS_GX_MD_CHANNEL_5_VOLUME_LABEL_GA "Cainéal 5 Mega Drive/Genesis FM % Toirt"
#define GENESIS_PLUS_GX_MD_CHANNEL_5_VOLUME_INFO_0_GA "Laghdaigh toirt Cainéal 5 Mega Drive/Genesis FM. Ní oibríonn sé ach le hinslitheoirí MAME FM."
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_0_VOLUME_LABEL_GA "Córas Máistir FM (YM2413) Cainéal 0 Imleabhar %"
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_0_VOLUME_INFO_0_GA "Laghdaigh toirt Chainéal FM 0 an Mháistirchórais."
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_1_VOLUME_LABEL_GA "Córas Máistir FM (YM2413) Cainéal 1 Imleabhar %"
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_1_VOLUME_INFO_0_GA "Laghdaigh toirt Chainéal 1 FM an Mháistirchórais."
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_2_VOLUME_LABEL_GA "Córas Máistir FM (YM2413) Cainéal 2 Imleabhar %"
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_2_VOLUME_INFO_0_GA "Laghdaigh toirt Chainéal 2 FM an Mháistirchórais."
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_3_VOLUME_LABEL_GA "Córas Máistir FM (YM2413) Cainéal 3 Imleabhar %"
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_3_VOLUME_INFO_0_GA "Laghdaigh toirt Chainéal 3 FM an Mháistirchórais."
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_4_VOLUME_LABEL_GA "Córas Máistir FM (YM2413) Cainéal 4 Imleabhar %"
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_4_VOLUME_INFO_0_GA "Laghdaigh toirt Cainéal 4 FM an Mháistirchórais."
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_5_VOLUME_LABEL_GA "Córas Máistir FM (YM2413) Cainéal 5 Imleabhar %"
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_5_VOLUME_INFO_0_GA "Laghdaigh toirt Chainéal 5 FM an Mháistirchórais."
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_6_VOLUME_LABEL_GA "Córas Máistir FM (YM2413) Cainéal 6 Imleabhar %"
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_6_VOLUME_INFO_0_GA "Laghdaigh toirt Chainéal 6 FM an Mháistirchórais."
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_7_VOLUME_LABEL_GA "Córas Máistir FM (YM2413) Cainéal 7 Imleabhar %"
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_7_VOLUME_INFO_0_GA "Laghdaigh toirt Chainéal 7 FM an Mháistirchórais."
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_8_VOLUME_LABEL_GA "Córas Máistir FM (YM2413) Cainéal 8 Imleabhar %"
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_8_VOLUME_INFO_0_GA "Laghdaigh toirt Chainéal 8 FM an Mháistirchórais."

struct retro_core_option_v2_category option_cats_ga[] = {
   {
      "system",
      CATEGORY_SYSTEM_LABEL_GA,
      CATEGORY_SYSTEM_INFO_0_GA
   },
   {
      "video",
      CATEGORY_VIDEO_LABEL_GA,
      CATEGORY_VIDEO_INFO_0_GA
   },
   {
      "audio",
      CATEGORY_AUDIO_LABEL_GA,
      CATEGORY_AUDIO_INFO_0_GA
   },
   {
      "input",
      CATEGORY_INPUT_LABEL_GA,
      CATEGORY_INPUT_INFO_0_GA
   },
   {
      "hacks",
      CATEGORY_HACKS_LABEL_GA,
      CATEGORY_HACKS_INFO_0_GA
   },
   {
      "channel_volume",
      CATEGORY_CHANNEL_VOLUME_LABEL_GA,
      CATEGORY_CHANNEL_VOLUME_INFO_0_GA
   },
   { NULL, NULL, NULL },
};
struct retro_core_option_v2_definition option_defs_ga[] = {
   {
      "genesis_plus_gx_system_hw",
      GENESIS_PLUS_GX_SYSTEM_HW_LABEL_GA,
      NULL,
      GENESIS_PLUS_GX_SYSTEM_HW_INFO_0_GA,
      NULL,
      "system",
      {
         { "auto",                 OPTION_VAL_AUTO_GA                 },
         { "sg-1000",              OPTION_VAL_SG_1000_GA              },
         { "sg-1000 II",           OPTION_VAL_SG_1000_II_GA           },
         { "sg-1000 II + ram ext.",OPTION_VAL_SG_1000_II_RAM_EXT_GA},
         { "mark-III",             OPTION_VAL_MARK_III_GA             },
         { "master system",        OPTION_VAL_MASTER_SYSTEM_GA        },
         { "master system II",     OPTION_VAL_MASTER_SYSTEM_II_GA     },
         { "game gear",            OPTION_VAL_GAME_GEAR_GA            },
         { "mega drive / genesis", OPTION_VAL_MEGA_DRIVE_GENESIS_GA   },
         { NULL, NULL },
      },
      "auto"
   },
   {
      "genesis_plus_gx_region_detect",
      GENESIS_PLUS_GX_REGION_DETECT_LABEL_GA,
      NULL,
      GENESIS_PLUS_GX_REGION_DETECT_INFO_0_GA,
      NULL,
      "system",
      {
         { "auto",    OPTION_VAL_AUTO_GA   },
         { "ntsc-u",  OPTION_VAL_NTSC_U_GA },
         { "pal",     OPTION_VAL_PAL_GA    },
         { "ntsc-j",  OPTION_VAL_NTSC_J_GA },
         { NULL, NULL },
      },
      "auto"
   },
   {
      "genesis_plus_gx_vdp_mode",
      GENESIS_PLUS_GX_VDP_MODE_LABEL_GA,
      NULL,
      GENESIS_PLUS_GX_VDP_MODE_INFO_0_GA,
      NULL,
      "system",
      {
         { "auto",  "Disabled" },
         { "60hz",  OPTION_VAL_60HZ_GA },
         { "50hz",  OPTION_VAL_50HZ_GA },
         { NULL, NULL },
      },
      "auto"
   },
   {
      "genesis_plus_gx_bios",
      GENESIS_PLUS_GX_BIOS_LABEL_GA,
      NULL,
      GENESIS_PLUS_GX_BIOS_INFO_0_GA,
      NULL,
      "system",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_system_bram",
      GENESIS_PLUS_GX_SYSTEM_BRAM_LABEL_GA,
      NULL,
      GENESIS_PLUS_GX_SYSTEM_BRAM_INFO_0_GA,
      NULL,
      "system",
      {
         { "per bios", OPTION_VAL_PER_BIOS_GA },
         { "per game", OPTION_VAL_PER_GAME_GA },
         { NULL, NULL },
      },
      "per bios"
   },
   {
      "genesis_plus_gx_cart_bram",
      GENESIS_PLUS_GX_CART_BRAM_LABEL_GA,
      NULL,
      GENESIS_PLUS_GX_CART_BRAM_INFO_0_GA,
      NULL,
      "system",
      {
         { "per cart", OPTION_VAL_PER_CART_GA },
         { "per game", OPTION_VAL_PER_GAME_GA },
         { NULL, NULL },
      },
      "per cart"
   },
   {
      "genesis_plus_gx_cart_size",
      GENESIS_PLUS_GX_CART_SIZE_LABEL_GA,
      NULL,
      GENESIS_PLUS_GX_CART_SIZE_INFO_0_GA,
      NULL,
      "system",
      {
         { "disabled", "Disabled" },
         { "128k",     OPTION_VAL_128K_GA  },
         { "256k",     OPTION_VAL_256K_GA  },
         { "512k",     OPTION_VAL_512K_GA  },
         { "1meg",     OPTION_VAL_1MEG_GA    },
         { "2meg",     OPTION_VAL_2MEG_GA    },
         { "4meg",     OPTION_VAL_4MEG_GA    },
         { NULL, NULL },
      },
      "4meg"
   },
   {
      "genesis_plus_gx_add_on",
      GENESIS_PLUS_GX_ADD_ON_LABEL_GA,
      NULL,
      GENESIS_PLUS_GX_ADD_ON_INFO_0_GA,
      NULL,
      "system",
      {
         { "auto",         OPTION_VAL_AUTO_GA },
         { "sega/mega cd", OPTION_VAL_SEGA_MEGA_CD_GA },
         { "megasd",       OPTION_VAL_MEGASD_GA },
         { "none",         OPTION_VAL_NONE_GA },
         { NULL, NULL },
      },
      "auto"
   },
   {
      "genesis_plus_gx_lock_on",
      GENESIS_PLUS_GX_LOCK_ON_LABEL_GA,
      NULL,
      GENESIS_PLUS_GX_LOCK_ON_INFO_0_GA,
      NULL,
      "system",
      {
         { "disabled",            NULL },
         { "game genie",          OPTION_VAL_GAME_GENIE_GA },
         { "action replay (pro)", OPTION_VAL_ACTION_REPLAY_PRO_GA },
         { "sonic & knuckles",    OPTION_VAL_SONIC_KNUCKLES_GA },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_aspect_ratio",
      GENESIS_PLUS_GX_ASPECT_RATIO_LABEL_GA,
      NULL,
      GENESIS_PLUS_GX_ASPECT_RATIO_INFO_0_GA,
      NULL,
      "video",
      {
         { "auto",     OPTION_VAL_AUTO_GA },
         { "NTSC PAR", OPTION_VAL_NTSC_PAR_GA },
         { "PAL PAR",  OPTION_VAL_PAL_PAR_GA },
         { "4:3",  OPTION_VAL_4_3_GA },
         { "Uncorrected",  OPTION_VAL_UNCORRECTED_GA },
      },
      "auto"
   },
   {
      "genesis_plus_gx_overscan",
      GENESIS_PLUS_GX_OVERSCAN_LABEL_GA,
      NULL,
      GENESIS_PLUS_GX_OVERSCAN_INFO_0_GA,
      NULL,
      "video",
      {
         { "disabled",   NULL },
         { "top/bottom", OPTION_VAL_TOP_BOTTOM_GA },
         { "left/right", OPTION_VAL_LEFT_RIGHT_GA },
         { "full",       OPTION_VAL_FULL_GA },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_left_border",
      GENESIS_PLUS_GX_LEFT_BORDER_LABEL_GA,
      NULL,
      GENESIS_PLUS_GX_LEFT_BORDER_INFO_0_GA,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "left border", OPTION_VAL_LEFT_BORDER_GA },
         { "left & right borders", OPTION_VAL_LEFT_RIGHT_BORDERS_GA },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_gg_extra",
      GENESIS_PLUS_GX_GG_EXTRA_LABEL_GA,
      NULL,
      GENESIS_PLUS_GX_GG_EXTRA_INFO_0_GA,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_blargg_ntsc_filter",
      GENESIS_PLUS_GX_BLARGG_NTSC_FILTER_LABEL_GA,
      NULL,
      GENESIS_PLUS_GX_BLARGG_NTSC_FILTER_INFO_0_GA,
      NULL,
      "video",
      {
         { "disabled",   NULL },
         { "monochrome", OPTION_VAL_MONOCHROME_GA },
         { "composite",  OPTION_VAL_COMPOSITE_GA },
         { "svideo",     OPTION_VAL_SVIDEO_GA },
         { "rgb",        OPTION_VAL_RGB_GA },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_lcd_filter",
      GENESIS_PLUS_GX_LCD_FILTER_LABEL_GA,
      NULL,
      GENESIS_PLUS_GX_LCD_FILTER_INFO_0_GA,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_render",
      GENESIS_PLUS_GX_RENDER_LABEL_GA,
      NULL,
      GENESIS_PLUS_GX_RENDER_INFO_0_GA,
      NULL,
      "video",
      {
         { "single field", OPTION_VAL_SINGLE_FIELD_GA },
         { "double field", OPTION_VAL_DOUBLE_FIELD_GA },
         { NULL, NULL },
      },
      "single field"
   },
   {
      "genesis_plus_gx_frameskip",
      GENESIS_PLUS_GX_FRAMESKIP_LABEL_GA,
      NULL,
      GENESIS_PLUS_GX_FRAMESKIP_INFO_0_GA,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "auto",     OPTION_VAL_AUTO_GA },
         { "manual",   OPTION_VAL_MANUAL_GA },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_frameskip_threshold",
      GENESIS_PLUS_GX_FRAMESKIP_THRESHOLD_LABEL_GA,
      NULL,
      GENESIS_PLUS_GX_FRAMESKIP_THRESHOLD_INFO_0_GA,
      NULL,
      "video",
      {
         { "15", NULL },
         { "18", NULL },
         { "21", NULL },
         { "24", NULL },
         { "27", NULL },
         { "30", NULL },
         { "33", NULL },
         { "36", NULL },
         { "39", NULL },
         { "42", NULL },
         { "45", NULL },
         { "48", NULL },
         { "51", NULL },
         { "54", NULL },
         { "57", NULL },
         { "60", NULL },
         { NULL, NULL },
      },
      "33"
   },
   {
      "genesis_plus_gx_ym2413",
      GENESIS_PLUS_GX_YM2413_LABEL_GA,
      NULL,
      GENESIS_PLUS_GX_YM2413_INFO_0_GA,
      NULL,
      "audio",
      {
         { "auto",     OPTION_VAL_AUTO_GA },
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "auto"
   },
#ifdef HAVE_OPLL_CORE
   {
      "genesis_plus_gx_ym2413_core",
      GENESIS_PLUS_GX_YM2413_CORE_LABEL_GA,
      NULL,
      GENESIS_PLUS_GX_YM2413_CORE_INFO_0_GA,
      NULL,
      "audio",
      {
         { "mame",  OPTION_VAL_MAME_GA },
         { "nuked", OPTION_VAL_NUKED_GA },
         { NULL, NULL },
      },
      "mame"
   },
#endif
   {
      "genesis_plus_gx_ym2612",
      GENESIS_PLUS_GX_YM2612_LABEL_GA,
      NULL,
#ifdef HAVE_YM3438_CORE
      GENESIS_PLUS_GX_YM2612_INFO_0_GA,
#else
      GENESIS_PLUS_GX_YM2612_INFO_1_GA,
#endif
      NULL,
      "audio",
      {
         { "mame (ym2612)",          OPTION_VAL_MAME_YM2612_GA },
         { "mame (asic ym3438)",     OPTION_VAL_MAME_ASIC_YM3438_GA },
         { "mame (enhanced ym3438)", OPTION_VAL_MAME_ENHANCED_YM3438_GA },
#ifdef HAVE_YM3438_CORE
         { "nuked (ym2612)",         OPTION_VAL_NUKED_YM2612_GA },
         { "nuked (ym3438)",         OPTION_VAL_NUKED_YM3438_GA },
#endif
         { NULL, NULL },
      },
      "mame (ym2612)"
   },
   {
      "genesis_plus_gx_sound_output",
      GENESIS_PLUS_GX_SOUND_OUTPUT_LABEL_GA,
      NULL,
      GENESIS_PLUS_GX_SOUND_OUTPUT_INFO_0_GA,
      NULL,
      "audio",
      {
         { "stereo", OPTION_VAL_STEREO_GA },
         { "mono",   OPTION_VAL_MONO_GA },
         { NULL, NULL },
      },
      "stereo"
   },
   {
      "genesis_plus_gx_audio_filter",
      GENESIS_PLUS_GX_AUDIO_FILTER_LABEL_GA,
      NULL,
      GENESIS_PLUS_GX_AUDIO_FILTER_INFO_0_GA,
      NULL,
      "audio",
      {
         { "disabled", NULL },
         { "low-pass", OPTION_VAL_LOW_PASS_GA },
#ifdef HAVE_EQ
         { "EQ",       OPTION_VAL_EQ_GA },
#endif
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_lowpass_range",
      GENESIS_PLUS_GX_LOWPASS_RANGE_LABEL_GA,
      NULL,
      GENESIS_PLUS_GX_LOWPASS_RANGE_INFO_0_GA,
      NULL,
      "audio",
      {
         { "5",  NULL },
         { "10", NULL },
         { "15", NULL },
         { "20", NULL },
         { "25", NULL },
         { "30", NULL },
         { "35", NULL },
         { "40", NULL },
         { "45", NULL },
         { "50", NULL },
         { "55", NULL },
         { "60", NULL },
         { "65", NULL },
         { "70", NULL },
         { "75", NULL },
         { "80", NULL },
         { "85", NULL },
         { "90", NULL },
         { "95", NULL },
         { NULL, NULL },
      },
      "60"
   },
   {
      "genesis_plus_gx_psg_preamp",
      GENESIS_PLUS_GX_PSG_PREAMP_LABEL_GA,
      NULL,
      GENESIS_PLUS_GX_PSG_PREAMP_INFO_0_GA,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { "105", NULL },
         { "110", NULL },
         { "115", NULL },
         { "120", NULL },
         { "125", NULL },
         { "130", NULL },
         { "135", NULL },
         { "140", NULL },
         { "145", NULL },
         { "150", NULL },
         { "155", NULL },
         { "160", NULL },
         { "165", NULL },
         { "170", NULL },
         { "175", NULL },
         { "180", NULL },
         { "185", NULL },
         { "190", NULL },
         { "195", NULL },
         { "200", NULL },
         { NULL, NULL },
      },
      "150"
   },
   {
      "genesis_plus_gx_fm_preamp",
      GENESIS_PLUS_GX_FM_PREAMP_LABEL_GA,
      NULL,
      GENESIS_PLUS_GX_FM_PREAMP_INFO_0_GA,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { "105", NULL },
         { "110", NULL },
         { "115", NULL },
         { "120", NULL },
         { "125", NULL },
         { "130", NULL },
         { "135", NULL },
         { "140", NULL },
         { "145", NULL },
         { "150", NULL },
         { "155", NULL },
         { "160", NULL },
         { "165", NULL },
         { "170", NULL },
         { "175", NULL },
         { "180", NULL },
         { "185", NULL },
         { "190", NULL },
         { "195", NULL },
         { "200", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_cdda_volume",
      GENESIS_PLUS_GX_CDDA_VOLUME_LABEL_GA,
      NULL,
      GENESIS_PLUS_GX_CDDA_VOLUME_INFO_0_GA,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_pcm_volume",
      GENESIS_PLUS_GX_PCM_VOLUME_LABEL_GA,
      NULL,
      GENESIS_PLUS_GX_PCM_VOLUME_INFO_0_GA,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
#ifdef HAVE_EQ
   {
      "genesis_plus_gx_audio_eq_low",
      GENESIS_PLUS_GX_AUDIO_EQ_LOW_LABEL_GA,
      NULL,
      GENESIS_PLUS_GX_AUDIO_EQ_LOW_INFO_0_GA,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_audio_eq_mid",
      GENESIS_PLUS_GX_AUDIO_EQ_MID_LABEL_GA,
      NULL,
      GENESIS_PLUS_GX_AUDIO_EQ_MID_INFO_0_GA,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_audio_eq_high",
      GENESIS_PLUS_GX_AUDIO_EQ_HIGH_LABEL_GA,
      NULL,
      GENESIS_PLUS_GX_AUDIO_EQ_HIGH_INFO_0_GA,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
#endif
   {
      "genesis_plus_gx_gun_input",
      GENESIS_PLUS_GX_GUN_INPUT_LABEL_GA,
      NULL,
      GENESIS_PLUS_GX_GUN_INPUT_INFO_0_GA,
      NULL,
      "input",
      {
         { "lightgun",    OPTION_VAL_LIGHTGUN_GA },
         { "touchscreen", OPTION_VAL_TOUCHSCREEN_GA },
         { NULL, NULL },
      },
      "lightgun"
   },
   {
      "genesis_plus_gx_gun_cursor",
      GENESIS_PLUS_GX_GUN_CURSOR_LABEL_GA,
      NULL,
      GENESIS_PLUS_GX_GUN_CURSOR_INFO_0_GA,
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_invert_mouse",
      GENESIS_PLUS_GX_INVERT_MOUSE_LABEL_GA,
      NULL,
      GENESIS_PLUS_GX_INVERT_MOUSE_INFO_0_GA,
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_no_sprite_limit",
      GENESIS_PLUS_GX_NO_SPRITE_LIMIT_LABEL_GA,
      NULL,
      GENESIS_PLUS_GX_NO_SPRITE_LIMIT_INFO_0_GA,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_enhanced_vscroll",
      GENESIS_PLUS_GX_ENHANCED_VSCROLL_LABEL_GA,
      NULL,
      GENESIS_PLUS_GX_ENHANCED_VSCROLL_INFO_0_GA,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_enhanced_vscroll_limit",
      GENESIS_PLUS_GX_ENHANCED_VSCROLL_LIMIT_LABEL_GA,
      NULL,
      GENESIS_PLUS_GX_ENHANCED_VSCROLL_LIMIT_INFO_0_GA,
      NULL,
      "hacks",
      {
         { "2", NULL },
         { "3",  NULL },
         { "4", NULL },
         { "5",  NULL },
         { "6", NULL },
         { "7",  NULL },
         { "8", NULL },
         { "9",  NULL },
         { "10", NULL },
         { "11",  NULL },
         { "12", NULL },
         { "13",  NULL },
         { "14", NULL },
         { "15",  NULL },
         { "16", NULL },
         { NULL, NULL },
      },
      "8"
   },
#ifdef HAVE_OVERCLOCK
   {
      "genesis_plus_gx_overclock",
      GENESIS_PLUS_GX_OVERCLOCK_LABEL_GA,
      NULL,
      GENESIS_PLUS_GX_OVERCLOCK_INFO_0_GA,
      NULL,
      "hacks",
      {
         { "100", OPTION_VAL_100_GA },
         { "125", OPTION_VAL_125_GA },
         { "150", OPTION_VAL_150_GA },
         { "175", OPTION_VAL_175_GA },
         { "200", OPTION_VAL_200_GA },
         { "225", OPTION_VAL_225_GA },
         { "250", OPTION_VAL_250_GA },
         { "275", OPTION_VAL_275_GA },
         { "300", OPTION_VAL_300_GA },
         { "325", OPTION_VAL_325_GA },
         { "350", OPTION_VAL_350_GA },
         { "375", OPTION_VAL_375_GA },
         { "400", OPTION_VAL_400_GA },
         { "425", OPTION_VAL_425_GA },
         { "450", OPTION_VAL_450_GA },
         { "475", OPTION_VAL_475_GA },
         { "500", OPTION_VAL_500_GA },
         { NULL, NULL },
      },
      "100%"
   },
#endif
   {
      "genesis_plus_gx_force_dtack",
      GENESIS_PLUS_GX_FORCE_DTACK_LABEL_GA,
      NULL,
      GENESIS_PLUS_GX_FORCE_DTACK_INFO_0_GA,
      NULL,
      "hacks",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL },
      },
      "enabled"
   },
   {
      "genesis_plus_gx_addr_error",
      GENESIS_PLUS_GX_ADDR_ERROR_LABEL_GA,
      NULL,
      GENESIS_PLUS_GX_ADDR_ERROR_INFO_0_GA,
      NULL,
      "hacks",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL },
      },
      "enabled"
   },
   {
      "genesis_plus_gx_cd_latency",
      GENESIS_PLUS_GX_CD_LATENCY_LABEL_GA,
      NULL,
      GENESIS_PLUS_GX_CD_LATENCY_INFO_0_GA,
      NULL,
      "hacks",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL },
      },
      "enabled"
   },
   {
      "genesis_plus_gx_cd_precache",
      GENESIS_PLUS_GX_CD_PRECACHE_LABEL_GA,
      NULL,
      GENESIS_PLUS_GX_CD_PRECACHE_INFO_0_GA,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
#ifdef USE_PER_SOUND_CHANNELS_CONFIG
   {
      "genesis_plus_gx_show_advanced_audio_settings",
      GENESIS_PLUS_GX_SHOW_ADVANCED_AUDIO_SETTINGS_LABEL_GA,
      NULL,
      GENESIS_PLUS_GX_SHOW_ADVANCED_AUDIO_SETTINGS_INFO_0_GA,
      NULL,
      "channel_volume",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL},
      },
      "disabled"
   },
   {
      "genesis_plus_gx_psg_channel_0_volume",
      GENESIS_PLUS_GX_PSG_CHANNEL_0_VOLUME_LABEL_GA,
      NULL,
      GENESIS_PLUS_GX_PSG_CHANNEL_0_VOLUME_INFO_0_GA,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_psg_channel_1_volume",
      GENESIS_PLUS_GX_PSG_CHANNEL_1_VOLUME_LABEL_GA,
      NULL,
      GENESIS_PLUS_GX_PSG_CHANNEL_1_VOLUME_INFO_0_GA,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_psg_channel_2_volume",
      GENESIS_PLUS_GX_PSG_CHANNEL_2_VOLUME_LABEL_GA,
      NULL,
      GENESIS_PLUS_GX_PSG_CHANNEL_2_VOLUME_INFO_0_GA,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_psg_channel_3_volume",
      GENESIS_PLUS_GX_PSG_CHANNEL_3_VOLUME_LABEL_GA,
      NULL,
      GENESIS_PLUS_GX_PSG_CHANNEL_3_VOLUME_INFO_0_GA,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_0_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_0_VOLUME_LABEL_GA,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_0_VOLUME_INFO_0_GA,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_1_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_1_VOLUME_LABEL_GA,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_1_VOLUME_INFO_0_GA,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_2_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_2_VOLUME_LABEL_GA,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_2_VOLUME_INFO_0_GA,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_3_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_3_VOLUME_LABEL_GA,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_3_VOLUME_INFO_0_GA,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_4_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_4_VOLUME_LABEL_GA,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_4_VOLUME_INFO_0_GA,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_5_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_5_VOLUME_LABEL_GA,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_5_VOLUME_INFO_0_GA,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_0_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_0_VOLUME_LABEL_GA,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_0_VOLUME_INFO_0_GA,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_1_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_1_VOLUME_LABEL_GA,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_1_VOLUME_INFO_0_GA,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_2_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_2_VOLUME_LABEL_GA,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_2_VOLUME_INFO_0_GA,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_3_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_3_VOLUME_LABEL_GA,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_3_VOLUME_INFO_0_GA,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_4_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_4_VOLUME_LABEL_GA,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_4_VOLUME_INFO_0_GA,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_5_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_5_VOLUME_LABEL_GA,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_5_VOLUME_INFO_0_GA,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_6_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_6_VOLUME_LABEL_GA,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_6_VOLUME_INFO_0_GA,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_7_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_7_VOLUME_LABEL_GA,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_7_VOLUME_INFO_0_GA,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_8_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_8_VOLUME_LABEL_GA,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_8_VOLUME_INFO_0_GA,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
#endif
   { NULL, NULL, NULL, NULL, NULL, NULL, {{0}}, NULL },
};
struct retro_core_options_v2 options_ga = {
   option_cats_ga,
   option_defs_ga
};

/* RETRO_LANGUAGE_GL */

#define CATEGORY_SYSTEM_LABEL_GL "Sistema"
#define CATEGORY_SYSTEM_INFO_0_GL "Cambia a selección de hardware base, a rexión, a BIOS e a configuración do ficheiro de gardar Sega CD/Mega-CD."
#define CATEGORY_VIDEO_LABEL_GL "Vídeo"
#define CATEGORY_VIDEO_INFO_0_GL "Cambia a relación de aspecto, o recorte da pantalla, o filtro de vídeo e a configuración de saltar de fotogramas."
#define CATEGORY_AUDIO_LABEL_GL "Son"
#define CATEGORY_AUDIO_INFO_0_GL "Cambiar a configuración do dispositivo de audio."
#define CATEGORY_INPUT_LABEL_GL "Entrada"
#define CATEGORY_INPUT_INFO_0_GL "Cambia a configuración de entrada de pistola e/ou rato."
#define CATEGORY_HACKS_LABEL_GL "Hacks de emulación"
#define CATEGORY_HACKS_INFO_0_GL "Cambia a configuración de overclocking e precisión de emulación do procesador que afectan ao rendemento e á compatibilidade de baixo nivel."
#define CATEGORY_CHANNEL_VOLUME_LABEL_GL "Configuración avanzada de volume da canle"
#define CATEGORY_CHANNEL_VOLUME_INFO_0_GL "Cambia o volume das canles de audio de hardware individuais."
#define GENESIS_PLUS_GX_SYSTEM_HW_LABEL_GL "Hardware do sistema"
#define GENESIS_PLUS_GX_SYSTEM_HW_INFO_0_GL "Executa o contido cargado cunha consola emulada específica. \"Automático\" seleccionará o sistema máis axeitado para o xogo actual."
#define OPTION_VAL_AUTO_GL NULL
#define OPTION_VAL_SG_1000_GL NULL
#define OPTION_VAL_SG_1000_II_GL NULL
#define OPTION_VAL_SG_1000_II_RAM_EXT_GL NULL
#define OPTION_VAL_MARK_III_GL NULL
#define OPTION_VAL_MASTER_SYSTEM_GL NULL
#define OPTION_VAL_MASTER_SYSTEM_II_GL NULL
#define OPTION_VAL_GAME_GEAR_GL NULL
#define OPTION_VAL_MEGA_DRIVE_GENESIS_GL NULL
#define GENESIS_PLUS_GX_REGION_DETECT_LABEL_GL "Rexión do sistema"
#define GENESIS_PLUS_GX_REGION_DETECT_INFO_0_GL "Especifique de que rexión é o sistema. Para consolas que non sexan Game Gear, \"PAL\" é de 50 Hz, mentres que \"NTSC\" é de 60 Hz. Os xogos poden executarse máis rápido ou máis lento do normal se se selecciona a rexión incorrecta."
#define OPTION_VAL_NTSC_U_GL NULL
#define OPTION_VAL_PAL_GL NULL
#define OPTION_VAL_NTSC_J_GL NULL
#define GENESIS_PLUS_GX_VDP_MODE_LABEL_GL "Forzar o Modo VDP"
#define GENESIS_PLUS_GX_VDP_MODE_INFO_0_GL "Sustituír o modo VDP para forzalo a funcionar a 60Hz NTSC ou 50Hz PAL, independentemente da rexión do sistema."
#define OPTION_VAL_60HZ_GL NULL
#define OPTION_VAL_50HZ_GL NULL
#define GENESIS_PLUS_GX_BIOS_LABEL_GL "ROM de arranque do sistema"
#define GENESIS_PLUS_GX_BIOS_INFO_0_GL "Use o BIOS/cargador de arranque oficial para o hardware emulado, se está presente no directorio do sistema de RetroArch. Mostra a secuencia de inicio/animación específica da consola e, a continuación, executa o contido cargado."
#define GENESIS_PLUS_GX_SYSTEM_BRAM_LABEL_GL "Sistema de CD BRAM (require reinicio)"
#define GENESIS_PLUS_GX_SYSTEM_BRAM_INFO_0_GL "Ao executar contido de CD/Mega-CD de Sega, especifica se se debe compartir un único ficheiro de gardado entre todos os xogos dunha rexión específica (por BIOS) ou se se crea un ficheiro de gardado separado para cada xogo (por xogo). Teña en conta que o Sega CD/Mega-CD ten almacenamento interno limitado, suficiente só para un puñado de títulos. Para evitar quedar sen espazo, recoméndase a configuración \"Por xogo\"."
#define OPTION_VAL_PER_BIOS_GL "Por-BIOS"
#define OPTION_VAL_PER_GAME_GL "Por xogo"
#define GENESIS_PLUS_GX_CART_BRAM_LABEL_GL "CD Backup carro de BRAM (require reinicio)"
#define GENESIS_PLUS_GX_CART_BRAM_INFO_0_GL "Ao executar contido de CD/Mega-CD de Sega, especifica se se debe compartir un único carro de copia de seguridade para todos os xogos (por carro) ou se se debe crear un carro de copia de seguridade para cada xogo (por xogo)."
#define OPTION_VAL_PER_CART_GL "Por carro"
#define GENESIS_PLUS_GX_CART_SIZE_LABEL_GL "Tamaño BRAM do carro de copia de seguridade de CD (require reinicio)"
#define GENESIS_PLUS_GX_CART_SIZE_INFO_0_GL "Establece o tamaño do carro de memoria RAM de copia de seguridade ao executar contido de Sega CD/Mega-CD. Útil ao configurar o carro de copia de seguridade en Por-xogo para evitar varios tamaños de carro máis grandes."
#define OPTION_VAL_128K_GL NULL
#define OPTION_VAL_256K_GL NULL
#define OPTION_VAL_512K_GL NULL
#define OPTION_VAL_1MEG_GL NULL
#define OPTION_VAL_2MEG_GL NULL
#define OPTION_VAL_4MEG_GL NULL
#define GENESIS_PLUS_GX_ADD_ON_LABEL_GL "Complemento de CD (modo MD) (require reinicio)"
#define GENESIS_PLUS_GX_ADD_ON_INFO_0_GL "Especifique que complemento usar para a reprodución de audio de CD cos xogos de Mega Drive/Genesis compatibles."
#define OPTION_VAL_SEGA_MEGA_CD_GL NULL
#define OPTION_VAL_MEGASD_GL NULL
#define OPTION_VAL_NONE_GL "Ningún"
#define GENESIS_PLUS_GX_LOCK_ON_LABEL_GL "Bloqueo do cartucho"
#define GENESIS_PLUS_GX_LOCK_ON_INFO_0_GL "A tecnoloxía Lock-On é unha función de Mega Drive/Genesis que permitía a un xogo máis antigo conectarse ao porto de paso dun cartucho especial para ampliar ou modificar o xogo. Esta opción especifica que tipo de cartucho especial \"bloqueado\" quere emular. O ficheiro de bios correspondente debe estar presente no directorio do sistema de RetroArch."
#define OPTION_VAL_GAME_GENIE_GL "Xogo Genie"
#define OPTION_VAL_ACTION_REPLAY_PRO_GL "Reprodución de accións (Pro)"
#define OPTION_VAL_SONIC_KNUCKLES_GL NULL
#define GENESIS_PLUS_GX_ASPECT_RATIO_LABEL_GL "Relación de aspecto proporcionada polo núcleo"
#define GENESIS_PLUS_GX_ASPECT_RATIO_INFO_0_GL "Escolla a relación de aspecto do contido preferida. Isto só se aplicará cando a relación de aspecto de RetroArch estea definida como \"Núcleo proporcionado\" na configuración de vídeo."
#define OPTION_VAL_NTSC_PAR_GL NULL
#define OPTION_VAL_PAL_PAR_GL NULL
#define OPTION_VAL_4_3_GL NULL
#define OPTION_VAL_UNCORRECTED_GL "Sen corrixir"
#define GENESIS_PLUS_GX_OVERSCAN_LABEL_GL "Bordos"
#define GENESIS_PLUS_GX_OVERSCAN_INFO_0_GL "Activa isto para mostrar as rexións de sobreescaneo na parte superior/abaixo e/ou á esquerda/dereita da pantalla. Estes normalmente estarían ocultos polo bisel ao redor do bordo dun televisor de definición estándar."
#define OPTION_VAL_TOP_BOTTOM_GL "Arriba/Abaixo"
#define OPTION_VAL_LEFT_RIGHT_GL "Esquerda/dereita"
#define OPTION_VAL_FULL_GL "Cheo"
#define GENESIS_PLUS_GX_LEFT_BORDER_LABEL_GL "Ocultar bordos laterais do sistema mestre"
#define GENESIS_PLUS_GX_LEFT_BORDER_INFO_0_GL "Corta 8 píxeles do lado esquerdo da pantalla ou dos lados esquerdo e dereito cando se executan xogos de Master System."
#define OPTION_VAL_LEFT_BORDER_GL "Só o bordo esquerdo"
#define OPTION_VAL_LEFT_RIGHT_BORDERS_GL "Bordes esquerdo e dereito"
#define GENESIS_PLUS_GX_GG_EXTRA_LABEL_GL "Game Gear pantalla estendida"
#define GENESIS_PLUS_GX_GG_EXTRA_INFO_0_GL "Obriga aos títulos de Game Gear a executarse en modo SMS, cunha resolución aumentada de 256 x 192. Pode mostrar contido adicional, pero normalmente mostra un bordo de datos de imaxe corruptos/non desexados."
#define GENESIS_PLUS_GX_BLARGG_NTSC_FILTER_LABEL_GL "Filtro NTSC Blargg"
#define GENESIS_PLUS_GX_BLARGG_NTSC_FILTER_INFO_0_GL "Aplique un filtro de vídeo para imitar varios sinais de TV NTSC."
#define OPTION_VAL_MONOCHROME_GL "Monocromo"
#define OPTION_VAL_COMPOSITE_GL "Composto"
#define OPTION_VAL_SVIDEO_GL NULL
#define OPTION_VAL_RGB_GL NULL
#define GENESIS_PLUS_GX_LCD_FILTER_LABEL_GL "Filtro de pantalla fantasma LCD"
#define GENESIS_PLUS_GX_LCD_FILTER_INFO_0_GL "Aplica un filtro de imaxe fantasma para imitar as características de visualización dos paneis LCD Game Gear e Genesis Nomad."
#define GENESIS_PLUS_GX_RENDER_LABEL_GL "Saída do modo 2 entrelazado"
#define GENESIS_PLUS_GX_RENDER_INFO_0_GL "O modo entrelazado 2 permite que Mega Drive/Genesis produza unha imaxe de 320 x 448 de dobre altura (alta resolución) debuxando liñas de exploración alternativas en cada fotograma (isto é usado polos modos multixogador de Sonic the Hedgehog 2 e Combat Cars). \"Double Field\" imita o hardware orixinal, producindo unha imaxe nítida con artefactos parpadeantes/entrelazados. \"Campo único\" aplica un filtro de desentrelazado, que estabiliza a imaxe pero provoca un lixeiro borroso."
#define OPTION_VAL_SINGLE_FIELD_GL "Campo único"
#define OPTION_VAL_DOUBLE_FIELD_GL "Dobre Campo"
#define GENESIS_PLUS_GX_FRAMESKIP_LABEL_GL "Omitir Fotograma"
#define GENESIS_PLUS_GX_FRAMESKIP_INFO_0_GL "Omita fotogramas para evitar que o búfer de audio non se execute (crepitamento). Mellora o rendemento a costa da suavidade visual. \"Automático\" omite fotogramas cando o aconselle a interface. \"Manual\" utiliza a configuración \"Limiar de omisión de fotogramas (%)\"."
#define OPTION_VAL_MANUAL_GL NULL
#define GENESIS_PLUS_GX_FRAMESKIP_THRESHOLD_LABEL_GL "Limiar de salto de fotogramas (%)"
#define GENESIS_PLUS_GX_FRAMESKIP_THRESHOLD_INFO_0_GL "Cando a omisión de fotogramas sexa configurada en 'Manual', este axuste especifíca o umbral de ocupación do búfer de audio (en porcentaxe). Os valores altos reducen o risco de aparición de chasquidos omitindo fotogramas de forma máis frecuente."
#define GENESIS_PLUS_GX_YM2413_LABEL_GL NULL
#define GENESIS_PLUS_GX_YM2413_INFO_0_GL "Activa a emulación da unidade de son FM utilizada por certos xogos de Sega Mark III/Master System para mellorar a saída de audio."
#define GENESIS_PLUS_GX_YM2413_CORE_LABEL_GL "Núcleo Master System FM (YM2413)"
#define GENESIS_PLUS_GX_YM2413_CORE_INFO_0_GL "Seleccione o método utilizado para emular a unidade de son FM do sistema Sega Mark III/Master. A opción \"MAME\" é rápida e funciona a toda velocidade na maioría dos sistemas. A opción \"Nuked\" é precisa do ciclo, de moi alta calidade e ten requisitos substanciais de CPU."
#define OPTION_VAL_MAME_GL NULL
#define OPTION_VAL_NUKED_GL NULL
#define GENESIS_PLUS_GX_YM2612_LABEL_GL NULL
#define GENESIS_PLUS_GX_YM2612_INFO_0_GL "Seleccione o método utilizado para emular o sintetizador FM (xerador de son principal) do Mega Drive/Genesis. As opcións \"MAME\" son rápidas e funcionan a toda velocidade na maioría dos sistemas. As opcións \"Nuked\" son precisas en ciclos, de moi alta calidade e teñen requisitos de CPU substanciais. O chip YM2612 é usado polo modelo 1 Mega Drive/Genesis orixinal. O YM3438 úsase nas revisións posteriores de Mega Drive/Genesis."
#define GENESIS_PLUS_GX_YM2612_INFO_1_GL "Seleccione o método utilizado para emular o sintetizador FM (xerador de son principal) do Mega Drive/Genesis. O chip YM2612 é usado polo modelo 1 Mega Drive/Genesis orixinal. O YM3438 úsase nas revisións posteriores de Mega Drive/Genesis."
#define OPTION_VAL_MAME_YM2612_GL NULL
#define OPTION_VAL_MAME_ASIC_YM3438_GL NULL
#define OPTION_VAL_MAME_ENHANCED_YM3438_GL NULL
#define OPTION_VAL_NUKED_YM2612_GL NULL
#define OPTION_VAL_NUKED_YM3438_GL NULL
#define GENESIS_PLUS_GX_SOUND_OUTPUT_LABEL_GL "Saída de son"
#define GENESIS_PLUS_GX_SOUND_OUTPUT_INFO_0_GL "Seleccione a reprodución de son estéreo ou mono."
#define OPTION_VAL_STEREO_GL "Estéreo"
#define OPTION_VAL_MONO_GL NULL
#define GENESIS_PLUS_GX_AUDIO_FILTER_LABEL_GL "Filtro de son"
#define GENESIS_PLUS_GX_AUDIO_FILTER_INFO_0_GL "Activa un filtro de audio de paso baixo para simular mellor o son característico dun modelo 1 Mega Drive/Genesis."
#define OPTION_VAL_LOW_PASS_GL "Paso baixo"
#define OPTION_VAL_EQ_GL NULL
#define GENESIS_PLUS_GX_LOWPASS_RANGE_LABEL_GL "Filtro de paso baixo %"
#define GENESIS_PLUS_GX_LOWPASS_RANGE_INFO_0_GL "Especifique a frecuencia de corte do filtro pasabaixo de audio. Un valor máis alto aumenta a \"forza\" percibida do filtro, xa que se atenúa un rango máis amplo do espectro de alta frecuencia."
#define GENESIS_PLUS_GX_PSG_PREAMP_LABEL_GL "Nivel de preamplificador PSG"
#define GENESIS_PLUS_GX_PSG_PREAMP_INFO_0_GL "Establece o nivel do preamplificador de audio do xerador de son programable de 4 canles SN76496 emulado que se atopa no SG-1000, Sega Mark III, Master System, Game Gear e Mega Drive/Genesis."
#define GENESIS_PLUS_GX_FM_PREAMP_LABEL_GL "Nivel de preamplificador FM"
#define GENESIS_PLUS_GX_FM_PREAMP_INFO_0_GL "Establece o nivel do preamplificador de audio do sintetizador de son Mega Drive/Genesis FM emulado ou da Unidade de son Sega Mark III/Master System FM."
#define GENESIS_PLUS_GX_CDDA_VOLUME_LABEL_GL NULL
#define GENESIS_PLUS_GX_CDDA_VOLUME_INFO_0_GL "Axuste o volume de mestura da saída de reprodución de audio do CD emulado."
#define GENESIS_PLUS_GX_PCM_VOLUME_LABEL_GL "Volume PCM"
#define GENESIS_PLUS_GX_PCM_VOLUME_INFO_0_GL "Axuste o volume de mestura da saída do xerador de son Sega CD/Mega-CD RF5C164 PCM emulado."
#define GENESIS_PLUS_GX_AUDIO_EQ_LOW_LABEL_GL "EQ Baixo"
#define GENESIS_PLUS_GX_AUDIO_EQ_LOW_INFO_0_GL "Axuste a banda de rango baixo do ecualizador de audio interno."
#define GENESIS_PLUS_GX_AUDIO_EQ_MID_LABEL_GL "EQ Med"
#define GENESIS_PLUS_GX_AUDIO_EQ_MID_INFO_0_GL "Axuste a banda de rango medio do ecualizador de audio interno."
#define GENESIS_PLUS_GX_AUDIO_EQ_HIGH_LABEL_GL "EQ alto"
#define GENESIS_PLUS_GX_AUDIO_EQ_HIGH_INFO_0_GL "Axuste a banda de rango alto do ecualizador de audio interno."
#define GENESIS_PLUS_GX_GUN_INPUT_LABEL_GL "Entrada de pistola lixeira"
#define GENESIS_PLUS_GX_GUN_INPUT_INFO_0_GL "Use unha entrada \"Light Gun\" ou \"Touchscreen\" controlada co rato."
#define OPTION_VAL_LIGHTGUN_GL "Pistola lixeira"
#define OPTION_VAL_TOUCHSCREEN_GL "Pantalla táctil"
#define GENESIS_PLUS_GX_GUN_CURSOR_LABEL_GL "Mostrar Light Gun Crosshair"
#define GENESIS_PLUS_GX_GUN_CURSOR_INFO_0_GL "Mostra o punto de mira de pistola lixeira ao usar os tipos de dispositivos de entrada MD Menacer, MD Justifiers e MS Light Phaser."
#define GENESIS_PLUS_GX_INVERT_MOUSE_LABEL_GL "Inverte o eixe Y do rato"
#define GENESIS_PLUS_GX_INVERT_MOUSE_INFO_0_GL "Inverte o eixe Y do tipo de dispositivo de entrada MD Mouse."
#define GENESIS_PLUS_GX_NO_SPRITE_LIMIT_LABEL_GL "Eliminar o límite de Sprite por liña"
#define GENESIS_PLUS_GX_NO_SPRITE_LIMIT_INFO_0_GL "Elimina o límite orixinal de hardware de sprite por exploración. Isto reduce o parpadeo pero pode causar fallos visuais, xa que algúns xogos explotan o límite de hardware para xerar efectos especiais."
#define GENESIS_PLUS_GX_ENHANCED_VSCROLL_LABEL_GL "Desprazamento vertical por mosaico mellorado"
#define GENESIS_PLUS_GX_ENHANCED_VSCROLL_INFO_0_GL "Permite que cada cela individual se desprace verticalmente, en lugar de 2 celas de 16 píxeles, facendo unha media co valor vscroll da cela veciña. Este truco só se aplica a poucos xogos que usan o modo de desprazamento vertical de 2 celas."
#define GENESIS_PLUS_GX_ENHANCED_VSCROLL_LIMIT_LABEL_GL "Límite de desprazamento vertical por mosaico mellorado"
#define GENESIS_PLUS_GX_ENHANCED_VSCROLL_LIMIT_INFO_0_GL "Só cando o desprazamento vertical por mosaico mellorado está activado. Axusta o límite da mellora do desprazamento vertical. Cando a diferenza de vscroll entre as pezas veciñas é maior que este límite, a mellora está desactivada."
#define GENESIS_PLUS_GX_OVERCLOCK_LABEL_GL "Velocidade da CPU"
#define GENESIS_PLUS_GX_OVERCLOCK_INFO_0_GL "Overclock a CPU emulada. Pode reducir a desaceleración, pero pode causar fallos."
#define OPTION_VAL_100_GL NULL
#define OPTION_VAL_125_GL NULL
#define OPTION_VAL_150_GL NULL
#define OPTION_VAL_175_GL NULL
#define OPTION_VAL_200_GL NULL
#define OPTION_VAL_225_GL NULL
#define OPTION_VAL_250_GL NULL
#define OPTION_VAL_275_GL NULL
#define OPTION_VAL_300_GL NULL
#define OPTION_VAL_325_GL NULL
#define OPTION_VAL_350_GL NULL
#define OPTION_VAL_375_GL NULL
#define OPTION_VAL_400_GL NULL
#define OPTION_VAL_425_GL NULL
#define OPTION_VAL_450_GL NULL
#define OPTION_VAL_475_GL NULL
#define OPTION_VAL_500_GL NULL
#define GENESIS_PLUS_GX_FORCE_DTACK_LABEL_GL "Bloqueos do sistema"
#define GENESIS_PLUS_GX_FORCE_DTACK_INFO_0_GL "Emule os bloqueos do sistema que se producen no hardware real cando se realiza un acceso ilegal a enderezos. Isto só debería desactivarse cando se reproducen certas demostracións e homebrew que dependen dun comportamento ilegal para o correcto funcionamento."
#define GENESIS_PLUS_GX_ADDR_ERROR_LABEL_GL "Erro de enderezo 68K"
#define GENESIS_PLUS_GX_ADDR_ERROR_INFO_0_GL "A CPU principal de Mega Drive/Genesis (Motorola 68000) xera unha excepción de erro de enderezo (falla) ao tentar realizar un acceso á memoria non aliñado. Activar isto simulará este comportamento. Só debería desactivarse cando se reproducen hackeos de ROM, xa que normalmente se desenvolven mediante emuladores menos precisos e poden depender dun acceso RAM non válido para o correcto funcionamento."
#define GENESIS_PLUS_GX_CD_LATENCY_LABEL_GL "Tempo de Acceso ao CD"
#define GENESIS_PLUS_GX_CD_LATENCY_INFO_0_GL "Simula a latencia do hardware do CD orixinal ao iniciar unha lectura ou buscar unha localización específica no disco cargado. Isto é necesario para algúns xogos de CD que fallan se os datos do CD están dispoñibles demasiado pronto e tamén solucionan os problemas de desincronización de audio de CD nalgúns xogos. Desactivar isto pode ser útil cos xogos de MSU-MD, xa que fai que as pistas de audio do CD sexan máis fluidas."
#define GENESIS_PLUS_GX_CD_PRECACHE_LABEL_GL "Caché da Imaxe do CD"
#define GENESIS_PLUS_GX_CD_PRECACHE_INFO_0_GL "Cargar a imaxe do CD na memoria ao iniciar. Soporte CHD unicamente. Reinicio necesario."
#define GENESIS_PLUS_GX_SHOW_ADVANCED_AUDIO_SETTINGS_LABEL_GL "Mostrar configuración avanzada de volume de audio (volver abrir o menú)"
#define GENESIS_PLUS_GX_SHOW_ADVANCED_AUDIO_SETTINGS_INFO_0_GL "Activa a configuración dos parámetros da canle de audio de baixo nivel. NOTA: Debe activarse o menú rápido para que esta configuración teña efecto."
#define GENESIS_PLUS_GX_PSG_CHANNEL_0_VOLUME_LABEL_GL "Canle de tons do PSG 0 % de volume"
#define GENESIS_PLUS_GX_PSG_CHANNEL_0_VOLUME_INFO_0_GL "Reduce o volume do PSG Tone Channel 0."
#define GENESIS_PLUS_GX_PSG_CHANNEL_1_VOLUME_LABEL_GL "Canle de tons do PSG 1 % de volume"
#define GENESIS_PLUS_GX_PSG_CHANNEL_1_VOLUME_INFO_0_GL "Reduce o volume do PSG Tone Channel 1."
#define GENESIS_PLUS_GX_PSG_CHANNEL_2_VOLUME_LABEL_GL "Canle de tons do PSG 2 % de volume"
#define GENESIS_PLUS_GX_PSG_CHANNEL_2_VOLUME_INFO_0_GL "Reduce o volume do PSG Tone Channel 2."
#define GENESIS_PLUS_GX_PSG_CHANNEL_3_VOLUME_LABEL_GL "% do volume do PSG Noise Channel 3"
#define GENESIS_PLUS_GX_PSG_CHANNEL_3_VOLUME_INFO_0_GL "Reduce o volume do PSG Noise Channel 3."
#define GENESIS_PLUS_GX_MD_CHANNEL_0_VOLUME_LABEL_GL "Canle FM Mega Drive/Genesis 0 % de volume"
#define GENESIS_PLUS_GX_MD_CHANNEL_0_VOLUME_INFO_0_GL "Reduce o volume do Mega Drive/Genesis FM Channel 0. Só funciona con emuladores MAME FM."
#define GENESIS_PLUS_GX_MD_CHANNEL_1_VOLUME_LABEL_GL "Mega Drive/Genesis FM Channel 1 % volume"
#define GENESIS_PLUS_GX_MD_CHANNEL_1_VOLUME_INFO_0_GL "Reduce o volume da canle 1 de Mega Drive/Genesis FM. Só funciona con emuladores MAME FM."
#define GENESIS_PLUS_GX_MD_CHANNEL_2_VOLUME_LABEL_GL "Mega Drive/Genesis FM Channel 2 % volume"
#define GENESIS_PLUS_GX_MD_CHANNEL_2_VOLUME_INFO_0_GL "Reduce o volume do Mega Drive/Genesis FM Channel 2. Só funciona con emuladores MAME FM."
#define GENESIS_PLUS_GX_MD_CHANNEL_3_VOLUME_LABEL_GL "Mega Drive/Genesis FM Channel 3 % volume"
#define GENESIS_PLUS_GX_MD_CHANNEL_3_VOLUME_INFO_0_GL "Reduce o volume do Mega Drive/Genesis FM Channel 3. Só funciona con emuladores MAME FM."
#define GENESIS_PLUS_GX_MD_CHANNEL_4_VOLUME_LABEL_GL "Mega Drive/Genesis FM Channel 4 % volume"
#define GENESIS_PLUS_GX_MD_CHANNEL_4_VOLUME_INFO_0_GL "Reduce o volume do Mega Drive/Genesis FM Channel 4. Só funciona con emuladores MAME FM."
#define GENESIS_PLUS_GX_MD_CHANNEL_5_VOLUME_LABEL_GL "Mega Drive/Genesis FM Channel 5 % volume"
#define GENESIS_PLUS_GX_MD_CHANNEL_5_VOLUME_INFO_0_GL "Reduce o volume do Mega Drive/Genesis FM Channel 5. Só funciona con emuladores MAME FM."
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_0_VOLUME_LABEL_GL "Sistema principal FM (YM2413) Canle 0 % volume"
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_0_VOLUME_INFO_0_GL "Reduce o volume do Master System FM Channel 0."
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_1_VOLUME_LABEL_GL "Master System FM (YM2413) Canle 1 Volume %"
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_1_VOLUME_INFO_0_GL "Reduce o volume do Master System FM Channel 1."
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_2_VOLUME_LABEL_GL "Master System FM (YM2413) Canle 2 Volume %"
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_2_VOLUME_INFO_0_GL "Reduce o volume do Master System FM Channel 2."
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_3_VOLUME_LABEL_GL "Master System FM (YM2413) Canle 3 % do volume"
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_3_VOLUME_INFO_0_GL "Reduce o volume do Master System FM Channel 3."
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_4_VOLUME_LABEL_GL "Master System FM (YM2413) Canle 4 % do volume"
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_4_VOLUME_INFO_0_GL "Reduce o volume do Master System FM Channel 4."
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_5_VOLUME_LABEL_GL "Master System FM (YM2413) Canle 5 % do volume"
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_5_VOLUME_INFO_0_GL "Reduce o volume do Master System FM Channel 5."
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_6_VOLUME_LABEL_GL "Master System FM (YM2413) Canle 6 % do volume"
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_6_VOLUME_INFO_0_GL "Reduce o volume do Master System FM Channel 6."
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_7_VOLUME_LABEL_GL "Master System FM (YM2413) Canle 7 % do volume"
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_7_VOLUME_INFO_0_GL "Reduce o volume do Master System FM Channel 7."
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_8_VOLUME_LABEL_GL "Master System FM (YM2413) Canle 8 % do volume"
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_8_VOLUME_INFO_0_GL "Reduce o volume do Master System FM Channel 8."

struct retro_core_option_v2_category option_cats_gl[] = {
   {
      "system",
      CATEGORY_SYSTEM_LABEL_GL,
      CATEGORY_SYSTEM_INFO_0_GL
   },
   {
      "video",
      CATEGORY_VIDEO_LABEL_GL,
      CATEGORY_VIDEO_INFO_0_GL
   },
   {
      "audio",
      CATEGORY_AUDIO_LABEL_GL,
      CATEGORY_AUDIO_INFO_0_GL
   },
   {
      "input",
      CATEGORY_INPUT_LABEL_GL,
      CATEGORY_INPUT_INFO_0_GL
   },
   {
      "hacks",
      CATEGORY_HACKS_LABEL_GL,
      CATEGORY_HACKS_INFO_0_GL
   },
   {
      "channel_volume",
      CATEGORY_CHANNEL_VOLUME_LABEL_GL,
      CATEGORY_CHANNEL_VOLUME_INFO_0_GL
   },
   { NULL, NULL, NULL },
};
struct retro_core_option_v2_definition option_defs_gl[] = {
   {
      "genesis_plus_gx_system_hw",
      GENESIS_PLUS_GX_SYSTEM_HW_LABEL_GL,
      NULL,
      GENESIS_PLUS_GX_SYSTEM_HW_INFO_0_GL,
      NULL,
      "system",
      {
         { "auto",                 OPTION_VAL_AUTO_GL                 },
         { "sg-1000",              OPTION_VAL_SG_1000_GL              },
         { "sg-1000 II",           OPTION_VAL_SG_1000_II_GL           },
         { "sg-1000 II + ram ext.",OPTION_VAL_SG_1000_II_RAM_EXT_GL},
         { "mark-III",             OPTION_VAL_MARK_III_GL             },
         { "master system",        OPTION_VAL_MASTER_SYSTEM_GL        },
         { "master system II",     OPTION_VAL_MASTER_SYSTEM_II_GL     },
         { "game gear",            OPTION_VAL_GAME_GEAR_GL            },
         { "mega drive / genesis", OPTION_VAL_MEGA_DRIVE_GENESIS_GL   },
         { NULL, NULL },
      },
      "auto"
   },
   {
      "genesis_plus_gx_region_detect",
      GENESIS_PLUS_GX_REGION_DETECT_LABEL_GL,
      NULL,
      GENESIS_PLUS_GX_REGION_DETECT_INFO_0_GL,
      NULL,
      "system",
      {
         { "auto",    OPTION_VAL_AUTO_GL   },
         { "ntsc-u",  OPTION_VAL_NTSC_U_GL },
         { "pal",     OPTION_VAL_PAL_GL    },
         { "ntsc-j",  OPTION_VAL_NTSC_J_GL },
         { NULL, NULL },
      },
      "auto"
   },
   {
      "genesis_plus_gx_vdp_mode",
      GENESIS_PLUS_GX_VDP_MODE_LABEL_GL,
      NULL,
      GENESIS_PLUS_GX_VDP_MODE_INFO_0_GL,
      NULL,
      "system",
      {
         { "auto",  "Disabled" },
         { "60hz",  OPTION_VAL_60HZ_GL },
         { "50hz",  OPTION_VAL_50HZ_GL },
         { NULL, NULL },
      },
      "auto"
   },
   {
      "genesis_plus_gx_bios",
      GENESIS_PLUS_GX_BIOS_LABEL_GL,
      NULL,
      GENESIS_PLUS_GX_BIOS_INFO_0_GL,
      NULL,
      "system",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_system_bram",
      GENESIS_PLUS_GX_SYSTEM_BRAM_LABEL_GL,
      NULL,
      GENESIS_PLUS_GX_SYSTEM_BRAM_INFO_0_GL,
      NULL,
      "system",
      {
         { "per bios", OPTION_VAL_PER_BIOS_GL },
         { "per game", OPTION_VAL_PER_GAME_GL },
         { NULL, NULL },
      },
      "per bios"
   },
   {
      "genesis_plus_gx_cart_bram",
      GENESIS_PLUS_GX_CART_BRAM_LABEL_GL,
      NULL,
      GENESIS_PLUS_GX_CART_BRAM_INFO_0_GL,
      NULL,
      "system",
      {
         { "per cart", OPTION_VAL_PER_CART_GL },
         { "per game", OPTION_VAL_PER_GAME_GL },
         { NULL, NULL },
      },
      "per cart"
   },
   {
      "genesis_plus_gx_cart_size",
      GENESIS_PLUS_GX_CART_SIZE_LABEL_GL,
      NULL,
      GENESIS_PLUS_GX_CART_SIZE_INFO_0_GL,
      NULL,
      "system",
      {
         { "disabled", "Disabled" },
         { "128k",     OPTION_VAL_128K_GL  },
         { "256k",     OPTION_VAL_256K_GL  },
         { "512k",     OPTION_VAL_512K_GL  },
         { "1meg",     OPTION_VAL_1MEG_GL    },
         { "2meg",     OPTION_VAL_2MEG_GL    },
         { "4meg",     OPTION_VAL_4MEG_GL    },
         { NULL, NULL },
      },
      "4meg"
   },
   {
      "genesis_plus_gx_add_on",
      GENESIS_PLUS_GX_ADD_ON_LABEL_GL,
      NULL,
      GENESIS_PLUS_GX_ADD_ON_INFO_0_GL,
      NULL,
      "system",
      {
         { "auto",         OPTION_VAL_AUTO_GL },
         { "sega/mega cd", OPTION_VAL_SEGA_MEGA_CD_GL },
         { "megasd",       OPTION_VAL_MEGASD_GL },
         { "none",         OPTION_VAL_NONE_GL },
         { NULL, NULL },
      },
      "auto"
   },
   {
      "genesis_plus_gx_lock_on",
      GENESIS_PLUS_GX_LOCK_ON_LABEL_GL,
      NULL,
      GENESIS_PLUS_GX_LOCK_ON_INFO_0_GL,
      NULL,
      "system",
      {
         { "disabled",            NULL },
         { "game genie",          OPTION_VAL_GAME_GENIE_GL },
         { "action replay (pro)", OPTION_VAL_ACTION_REPLAY_PRO_GL },
         { "sonic & knuckles",    OPTION_VAL_SONIC_KNUCKLES_GL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_aspect_ratio",
      GENESIS_PLUS_GX_ASPECT_RATIO_LABEL_GL,
      NULL,
      GENESIS_PLUS_GX_ASPECT_RATIO_INFO_0_GL,
      NULL,
      "video",
      {
         { "auto",     OPTION_VAL_AUTO_GL },
         { "NTSC PAR", OPTION_VAL_NTSC_PAR_GL },
         { "PAL PAR",  OPTION_VAL_PAL_PAR_GL },
         { "4:3",  OPTION_VAL_4_3_GL },
         { "Uncorrected",  OPTION_VAL_UNCORRECTED_GL },
      },
      "auto"
   },
   {
      "genesis_plus_gx_overscan",
      GENESIS_PLUS_GX_OVERSCAN_LABEL_GL,
      NULL,
      GENESIS_PLUS_GX_OVERSCAN_INFO_0_GL,
      NULL,
      "video",
      {
         { "disabled",   NULL },
         { "top/bottom", OPTION_VAL_TOP_BOTTOM_GL },
         { "left/right", OPTION_VAL_LEFT_RIGHT_GL },
         { "full",       OPTION_VAL_FULL_GL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_left_border",
      GENESIS_PLUS_GX_LEFT_BORDER_LABEL_GL,
      NULL,
      GENESIS_PLUS_GX_LEFT_BORDER_INFO_0_GL,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "left border", OPTION_VAL_LEFT_BORDER_GL },
         { "left & right borders", OPTION_VAL_LEFT_RIGHT_BORDERS_GL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_gg_extra",
      GENESIS_PLUS_GX_GG_EXTRA_LABEL_GL,
      NULL,
      GENESIS_PLUS_GX_GG_EXTRA_INFO_0_GL,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_blargg_ntsc_filter",
      GENESIS_PLUS_GX_BLARGG_NTSC_FILTER_LABEL_GL,
      NULL,
      GENESIS_PLUS_GX_BLARGG_NTSC_FILTER_INFO_0_GL,
      NULL,
      "video",
      {
         { "disabled",   NULL },
         { "monochrome", OPTION_VAL_MONOCHROME_GL },
         { "composite",  OPTION_VAL_COMPOSITE_GL },
         { "svideo",     OPTION_VAL_SVIDEO_GL },
         { "rgb",        OPTION_VAL_RGB_GL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_lcd_filter",
      GENESIS_PLUS_GX_LCD_FILTER_LABEL_GL,
      NULL,
      GENESIS_PLUS_GX_LCD_FILTER_INFO_0_GL,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_render",
      GENESIS_PLUS_GX_RENDER_LABEL_GL,
      NULL,
      GENESIS_PLUS_GX_RENDER_INFO_0_GL,
      NULL,
      "video",
      {
         { "single field", OPTION_VAL_SINGLE_FIELD_GL },
         { "double field", OPTION_VAL_DOUBLE_FIELD_GL },
         { NULL, NULL },
      },
      "single field"
   },
   {
      "genesis_plus_gx_frameskip",
      GENESIS_PLUS_GX_FRAMESKIP_LABEL_GL,
      NULL,
      GENESIS_PLUS_GX_FRAMESKIP_INFO_0_GL,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "auto",     OPTION_VAL_AUTO_GL },
         { "manual",   OPTION_VAL_MANUAL_GL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_frameskip_threshold",
      GENESIS_PLUS_GX_FRAMESKIP_THRESHOLD_LABEL_GL,
      NULL,
      GENESIS_PLUS_GX_FRAMESKIP_THRESHOLD_INFO_0_GL,
      NULL,
      "video",
      {
         { "15", NULL },
         { "18", NULL },
         { "21", NULL },
         { "24", NULL },
         { "27", NULL },
         { "30", NULL },
         { "33", NULL },
         { "36", NULL },
         { "39", NULL },
         { "42", NULL },
         { "45", NULL },
         { "48", NULL },
         { "51", NULL },
         { "54", NULL },
         { "57", NULL },
         { "60", NULL },
         { NULL, NULL },
      },
      "33"
   },
   {
      "genesis_plus_gx_ym2413",
      GENESIS_PLUS_GX_YM2413_LABEL_GL,
      NULL,
      GENESIS_PLUS_GX_YM2413_INFO_0_GL,
      NULL,
      "audio",
      {
         { "auto",     OPTION_VAL_AUTO_GL },
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "auto"
   },
#ifdef HAVE_OPLL_CORE
   {
      "genesis_plus_gx_ym2413_core",
      GENESIS_PLUS_GX_YM2413_CORE_LABEL_GL,
      NULL,
      GENESIS_PLUS_GX_YM2413_CORE_INFO_0_GL,
      NULL,
      "audio",
      {
         { "mame",  OPTION_VAL_MAME_GL },
         { "nuked", OPTION_VAL_NUKED_GL },
         { NULL, NULL },
      },
      "mame"
   },
#endif
   {
      "genesis_plus_gx_ym2612",
      GENESIS_PLUS_GX_YM2612_LABEL_GL,
      NULL,
#ifdef HAVE_YM3438_CORE
      GENESIS_PLUS_GX_YM2612_INFO_0_GL,
#else
      GENESIS_PLUS_GX_YM2612_INFO_1_GL,
#endif
      NULL,
      "audio",
      {
         { "mame (ym2612)",          OPTION_VAL_MAME_YM2612_GL },
         { "mame (asic ym3438)",     OPTION_VAL_MAME_ASIC_YM3438_GL },
         { "mame (enhanced ym3438)", OPTION_VAL_MAME_ENHANCED_YM3438_GL },
#ifdef HAVE_YM3438_CORE
         { "nuked (ym2612)",         OPTION_VAL_NUKED_YM2612_GL },
         { "nuked (ym3438)",         OPTION_VAL_NUKED_YM3438_GL },
#endif
         { NULL, NULL },
      },
      "mame (ym2612)"
   },
   {
      "genesis_plus_gx_sound_output",
      GENESIS_PLUS_GX_SOUND_OUTPUT_LABEL_GL,
      NULL,
      GENESIS_PLUS_GX_SOUND_OUTPUT_INFO_0_GL,
      NULL,
      "audio",
      {
         { "stereo", OPTION_VAL_STEREO_GL },
         { "mono",   OPTION_VAL_MONO_GL },
         { NULL, NULL },
      },
      "stereo"
   },
   {
      "genesis_plus_gx_audio_filter",
      GENESIS_PLUS_GX_AUDIO_FILTER_LABEL_GL,
      NULL,
      GENESIS_PLUS_GX_AUDIO_FILTER_INFO_0_GL,
      NULL,
      "audio",
      {
         { "disabled", NULL },
         { "low-pass", OPTION_VAL_LOW_PASS_GL },
#ifdef HAVE_EQ
         { "EQ",       OPTION_VAL_EQ_GL },
#endif
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_lowpass_range",
      GENESIS_PLUS_GX_LOWPASS_RANGE_LABEL_GL,
      NULL,
      GENESIS_PLUS_GX_LOWPASS_RANGE_INFO_0_GL,
      NULL,
      "audio",
      {
         { "5",  NULL },
         { "10", NULL },
         { "15", NULL },
         { "20", NULL },
         { "25", NULL },
         { "30", NULL },
         { "35", NULL },
         { "40", NULL },
         { "45", NULL },
         { "50", NULL },
         { "55", NULL },
         { "60", NULL },
         { "65", NULL },
         { "70", NULL },
         { "75", NULL },
         { "80", NULL },
         { "85", NULL },
         { "90", NULL },
         { "95", NULL },
         { NULL, NULL },
      },
      "60"
   },
   {
      "genesis_plus_gx_psg_preamp",
      GENESIS_PLUS_GX_PSG_PREAMP_LABEL_GL,
      NULL,
      GENESIS_PLUS_GX_PSG_PREAMP_INFO_0_GL,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { "105", NULL },
         { "110", NULL },
         { "115", NULL },
         { "120", NULL },
         { "125", NULL },
         { "130", NULL },
         { "135", NULL },
         { "140", NULL },
         { "145", NULL },
         { "150", NULL },
         { "155", NULL },
         { "160", NULL },
         { "165", NULL },
         { "170", NULL },
         { "175", NULL },
         { "180", NULL },
         { "185", NULL },
         { "190", NULL },
         { "195", NULL },
         { "200", NULL },
         { NULL, NULL },
      },
      "150"
   },
   {
      "genesis_plus_gx_fm_preamp",
      GENESIS_PLUS_GX_FM_PREAMP_LABEL_GL,
      NULL,
      GENESIS_PLUS_GX_FM_PREAMP_INFO_0_GL,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { "105", NULL },
         { "110", NULL },
         { "115", NULL },
         { "120", NULL },
         { "125", NULL },
         { "130", NULL },
         { "135", NULL },
         { "140", NULL },
         { "145", NULL },
         { "150", NULL },
         { "155", NULL },
         { "160", NULL },
         { "165", NULL },
         { "170", NULL },
         { "175", NULL },
         { "180", NULL },
         { "185", NULL },
         { "190", NULL },
         { "195", NULL },
         { "200", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_cdda_volume",
      GENESIS_PLUS_GX_CDDA_VOLUME_LABEL_GL,
      NULL,
      GENESIS_PLUS_GX_CDDA_VOLUME_INFO_0_GL,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_pcm_volume",
      GENESIS_PLUS_GX_PCM_VOLUME_LABEL_GL,
      NULL,
      GENESIS_PLUS_GX_PCM_VOLUME_INFO_0_GL,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
#ifdef HAVE_EQ
   {
      "genesis_plus_gx_audio_eq_low",
      GENESIS_PLUS_GX_AUDIO_EQ_LOW_LABEL_GL,
      NULL,
      GENESIS_PLUS_GX_AUDIO_EQ_LOW_INFO_0_GL,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_audio_eq_mid",
      GENESIS_PLUS_GX_AUDIO_EQ_MID_LABEL_GL,
      NULL,
      GENESIS_PLUS_GX_AUDIO_EQ_MID_INFO_0_GL,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_audio_eq_high",
      GENESIS_PLUS_GX_AUDIO_EQ_HIGH_LABEL_GL,
      NULL,
      GENESIS_PLUS_GX_AUDIO_EQ_HIGH_INFO_0_GL,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
#endif
   {
      "genesis_plus_gx_gun_input",
      GENESIS_PLUS_GX_GUN_INPUT_LABEL_GL,
      NULL,
      GENESIS_PLUS_GX_GUN_INPUT_INFO_0_GL,
      NULL,
      "input",
      {
         { "lightgun",    OPTION_VAL_LIGHTGUN_GL },
         { "touchscreen", OPTION_VAL_TOUCHSCREEN_GL },
         { NULL, NULL },
      },
      "lightgun"
   },
   {
      "genesis_plus_gx_gun_cursor",
      GENESIS_PLUS_GX_GUN_CURSOR_LABEL_GL,
      NULL,
      GENESIS_PLUS_GX_GUN_CURSOR_INFO_0_GL,
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_invert_mouse",
      GENESIS_PLUS_GX_INVERT_MOUSE_LABEL_GL,
      NULL,
      GENESIS_PLUS_GX_INVERT_MOUSE_INFO_0_GL,
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_no_sprite_limit",
      GENESIS_PLUS_GX_NO_SPRITE_LIMIT_LABEL_GL,
      NULL,
      GENESIS_PLUS_GX_NO_SPRITE_LIMIT_INFO_0_GL,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_enhanced_vscroll",
      GENESIS_PLUS_GX_ENHANCED_VSCROLL_LABEL_GL,
      NULL,
      GENESIS_PLUS_GX_ENHANCED_VSCROLL_INFO_0_GL,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_enhanced_vscroll_limit",
      GENESIS_PLUS_GX_ENHANCED_VSCROLL_LIMIT_LABEL_GL,
      NULL,
      GENESIS_PLUS_GX_ENHANCED_VSCROLL_LIMIT_INFO_0_GL,
      NULL,
      "hacks",
      {
         { "2", NULL },
         { "3",  NULL },
         { "4", NULL },
         { "5",  NULL },
         { "6", NULL },
         { "7",  NULL },
         { "8", NULL },
         { "9",  NULL },
         { "10", NULL },
         { "11",  NULL },
         { "12", NULL },
         { "13",  NULL },
         { "14", NULL },
         { "15",  NULL },
         { "16", NULL },
         { NULL, NULL },
      },
      "8"
   },
#ifdef HAVE_OVERCLOCK
   {
      "genesis_plus_gx_overclock",
      GENESIS_PLUS_GX_OVERCLOCK_LABEL_GL,
      NULL,
      GENESIS_PLUS_GX_OVERCLOCK_INFO_0_GL,
      NULL,
      "hacks",
      {
         { "100", OPTION_VAL_100_GL },
         { "125", OPTION_VAL_125_GL },
         { "150", OPTION_VAL_150_GL },
         { "175", OPTION_VAL_175_GL },
         { "200", OPTION_VAL_200_GL },
         { "225", OPTION_VAL_225_GL },
         { "250", OPTION_VAL_250_GL },
         { "275", OPTION_VAL_275_GL },
         { "300", OPTION_VAL_300_GL },
         { "325", OPTION_VAL_325_GL },
         { "350", OPTION_VAL_350_GL },
         { "375", OPTION_VAL_375_GL },
         { "400", OPTION_VAL_400_GL },
         { "425", OPTION_VAL_425_GL },
         { "450", OPTION_VAL_450_GL },
         { "475", OPTION_VAL_475_GL },
         { "500", OPTION_VAL_500_GL },
         { NULL, NULL },
      },
      "100%"
   },
#endif
   {
      "genesis_plus_gx_force_dtack",
      GENESIS_PLUS_GX_FORCE_DTACK_LABEL_GL,
      NULL,
      GENESIS_PLUS_GX_FORCE_DTACK_INFO_0_GL,
      NULL,
      "hacks",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL },
      },
      "enabled"
   },
   {
      "genesis_plus_gx_addr_error",
      GENESIS_PLUS_GX_ADDR_ERROR_LABEL_GL,
      NULL,
      GENESIS_PLUS_GX_ADDR_ERROR_INFO_0_GL,
      NULL,
      "hacks",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL },
      },
      "enabled"
   },
   {
      "genesis_plus_gx_cd_latency",
      GENESIS_PLUS_GX_CD_LATENCY_LABEL_GL,
      NULL,
      GENESIS_PLUS_GX_CD_LATENCY_INFO_0_GL,
      NULL,
      "hacks",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL },
      },
      "enabled"
   },
   {
      "genesis_plus_gx_cd_precache",
      GENESIS_PLUS_GX_CD_PRECACHE_LABEL_GL,
      NULL,
      GENESIS_PLUS_GX_CD_PRECACHE_INFO_0_GL,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
#ifdef USE_PER_SOUND_CHANNELS_CONFIG
   {
      "genesis_plus_gx_show_advanced_audio_settings",
      GENESIS_PLUS_GX_SHOW_ADVANCED_AUDIO_SETTINGS_LABEL_GL,
      NULL,
      GENESIS_PLUS_GX_SHOW_ADVANCED_AUDIO_SETTINGS_INFO_0_GL,
      NULL,
      "channel_volume",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL},
      },
      "disabled"
   },
   {
      "genesis_plus_gx_psg_channel_0_volume",
      GENESIS_PLUS_GX_PSG_CHANNEL_0_VOLUME_LABEL_GL,
      NULL,
      GENESIS_PLUS_GX_PSG_CHANNEL_0_VOLUME_INFO_0_GL,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_psg_channel_1_volume",
      GENESIS_PLUS_GX_PSG_CHANNEL_1_VOLUME_LABEL_GL,
      NULL,
      GENESIS_PLUS_GX_PSG_CHANNEL_1_VOLUME_INFO_0_GL,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_psg_channel_2_volume",
      GENESIS_PLUS_GX_PSG_CHANNEL_2_VOLUME_LABEL_GL,
      NULL,
      GENESIS_PLUS_GX_PSG_CHANNEL_2_VOLUME_INFO_0_GL,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_psg_channel_3_volume",
      GENESIS_PLUS_GX_PSG_CHANNEL_3_VOLUME_LABEL_GL,
      NULL,
      GENESIS_PLUS_GX_PSG_CHANNEL_3_VOLUME_INFO_0_GL,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_0_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_0_VOLUME_LABEL_GL,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_0_VOLUME_INFO_0_GL,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_1_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_1_VOLUME_LABEL_GL,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_1_VOLUME_INFO_0_GL,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_2_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_2_VOLUME_LABEL_GL,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_2_VOLUME_INFO_0_GL,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_3_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_3_VOLUME_LABEL_GL,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_3_VOLUME_INFO_0_GL,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_4_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_4_VOLUME_LABEL_GL,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_4_VOLUME_INFO_0_GL,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_5_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_5_VOLUME_LABEL_GL,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_5_VOLUME_INFO_0_GL,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_0_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_0_VOLUME_LABEL_GL,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_0_VOLUME_INFO_0_GL,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_1_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_1_VOLUME_LABEL_GL,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_1_VOLUME_INFO_0_GL,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_2_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_2_VOLUME_LABEL_GL,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_2_VOLUME_INFO_0_GL,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_3_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_3_VOLUME_LABEL_GL,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_3_VOLUME_INFO_0_GL,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_4_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_4_VOLUME_LABEL_GL,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_4_VOLUME_INFO_0_GL,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_5_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_5_VOLUME_LABEL_GL,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_5_VOLUME_INFO_0_GL,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_6_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_6_VOLUME_LABEL_GL,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_6_VOLUME_INFO_0_GL,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_7_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_7_VOLUME_LABEL_GL,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_7_VOLUME_INFO_0_GL,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_8_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_8_VOLUME_LABEL_GL,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_8_VOLUME_INFO_0_GL,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
#endif
   { NULL, NULL, NULL, NULL, NULL, NULL, {{0}}, NULL },
};
struct retro_core_options_v2 options_gl = {
   option_cats_gl,
   option_defs_gl
};

/* RETRO_LANGUAGE_HE */

#define CATEGORY_SYSTEM_LABEL_HE NULL
#define CATEGORY_SYSTEM_INFO_0_HE NULL
#define CATEGORY_VIDEO_LABEL_HE "וידאו"
#define CATEGORY_VIDEO_INFO_0_HE NULL
#define CATEGORY_AUDIO_LABEL_HE "שמע"
#define CATEGORY_AUDIO_INFO_0_HE NULL
#define CATEGORY_INPUT_LABEL_HE "קלט"
#define CATEGORY_INPUT_INFO_0_HE NULL
#define CATEGORY_HACKS_LABEL_HE NULL
#define CATEGORY_HACKS_INFO_0_HE NULL
#define CATEGORY_CHANNEL_VOLUME_LABEL_HE NULL
#define CATEGORY_CHANNEL_VOLUME_INFO_0_HE NULL
#define GENESIS_PLUS_GX_SYSTEM_HW_LABEL_HE NULL
#define GENESIS_PLUS_GX_SYSTEM_HW_INFO_0_HE NULL
#define OPTION_VAL_AUTO_HE NULL
#define OPTION_VAL_SG_1000_HE NULL
#define OPTION_VAL_SG_1000_II_HE NULL
#define OPTION_VAL_SG_1000_II_RAM_EXT_HE NULL
#define OPTION_VAL_MARK_III_HE NULL
#define OPTION_VAL_MASTER_SYSTEM_HE NULL
#define OPTION_VAL_MASTER_SYSTEM_II_HE NULL
#define OPTION_VAL_GAME_GEAR_HE NULL
#define OPTION_VAL_MEGA_DRIVE_GENESIS_HE NULL
#define GENESIS_PLUS_GX_REGION_DETECT_LABEL_HE NULL
#define GENESIS_PLUS_GX_REGION_DETECT_INFO_0_HE NULL
#define OPTION_VAL_NTSC_U_HE NULL
#define OPTION_VAL_PAL_HE NULL
#define OPTION_VAL_NTSC_J_HE NULL
#define GENESIS_PLUS_GX_VDP_MODE_LABEL_HE NULL
#define GENESIS_PLUS_GX_VDP_MODE_INFO_0_HE NULL
#define OPTION_VAL_60HZ_HE NULL
#define OPTION_VAL_50HZ_HE NULL
#define GENESIS_PLUS_GX_BIOS_LABEL_HE NULL
#define GENESIS_PLUS_GX_BIOS_INFO_0_HE NULL
#define GENESIS_PLUS_GX_SYSTEM_BRAM_LABEL_HE NULL
#define GENESIS_PLUS_GX_SYSTEM_BRAM_INFO_0_HE NULL
#define OPTION_VAL_PER_BIOS_HE NULL
#define OPTION_VAL_PER_GAME_HE NULL
#define GENESIS_PLUS_GX_CART_BRAM_LABEL_HE NULL
#define GENESIS_PLUS_GX_CART_BRAM_INFO_0_HE NULL
#define OPTION_VAL_PER_CART_HE NULL
#define GENESIS_PLUS_GX_CART_SIZE_LABEL_HE NULL
#define GENESIS_PLUS_GX_CART_SIZE_INFO_0_HE NULL
#define OPTION_VAL_128K_HE NULL
#define OPTION_VAL_256K_HE NULL
#define OPTION_VAL_512K_HE NULL
#define OPTION_VAL_1MEG_HE NULL
#define OPTION_VAL_2MEG_HE NULL
#define OPTION_VAL_4MEG_HE NULL
#define GENESIS_PLUS_GX_ADD_ON_LABEL_HE NULL
#define GENESIS_PLUS_GX_ADD_ON_INFO_0_HE NULL
#define OPTION_VAL_SEGA_MEGA_CD_HE NULL
#define OPTION_VAL_MEGASD_HE NULL
#define OPTION_VAL_NONE_HE NULL
#define GENESIS_PLUS_GX_LOCK_ON_LABEL_HE NULL
#define GENESIS_PLUS_GX_LOCK_ON_INFO_0_HE NULL
#define OPTION_VAL_GAME_GENIE_HE NULL
#define OPTION_VAL_ACTION_REPLAY_PRO_HE NULL
#define OPTION_VAL_SONIC_KNUCKLES_HE NULL
#define GENESIS_PLUS_GX_ASPECT_RATIO_LABEL_HE NULL
#define GENESIS_PLUS_GX_ASPECT_RATIO_INFO_0_HE NULL
#define OPTION_VAL_NTSC_PAR_HE NULL
#define OPTION_VAL_PAL_PAR_HE NULL
#define OPTION_VAL_4_3_HE NULL
#define OPTION_VAL_UNCORRECTED_HE NULL
#define GENESIS_PLUS_GX_OVERSCAN_LABEL_HE NULL
#define GENESIS_PLUS_GX_OVERSCAN_INFO_0_HE NULL
#define OPTION_VAL_TOP_BOTTOM_HE NULL
#define OPTION_VAL_LEFT_RIGHT_HE NULL
#define OPTION_VAL_FULL_HE NULL
#define GENESIS_PLUS_GX_LEFT_BORDER_LABEL_HE NULL
#define GENESIS_PLUS_GX_LEFT_BORDER_INFO_0_HE NULL
#define OPTION_VAL_LEFT_BORDER_HE NULL
#define OPTION_VAL_LEFT_RIGHT_BORDERS_HE NULL
#define GENESIS_PLUS_GX_GG_EXTRA_LABEL_HE NULL
#define GENESIS_PLUS_GX_GG_EXTRA_INFO_0_HE NULL
#define GENESIS_PLUS_GX_BLARGG_NTSC_FILTER_LABEL_HE NULL
#define GENESIS_PLUS_GX_BLARGG_NTSC_FILTER_INFO_0_HE NULL
#define OPTION_VAL_MONOCHROME_HE NULL
#define OPTION_VAL_COMPOSITE_HE NULL
#define OPTION_VAL_SVIDEO_HE NULL
#define OPTION_VAL_RGB_HE NULL
#define GENESIS_PLUS_GX_LCD_FILTER_LABEL_HE NULL
#define GENESIS_PLUS_GX_LCD_FILTER_INFO_0_HE NULL
#define GENESIS_PLUS_GX_RENDER_LABEL_HE NULL
#define GENESIS_PLUS_GX_RENDER_INFO_0_HE NULL
#define OPTION_VAL_SINGLE_FIELD_HE NULL
#define OPTION_VAL_DOUBLE_FIELD_HE NULL
#define GENESIS_PLUS_GX_FRAMESKIP_LABEL_HE NULL
#define GENESIS_PLUS_GX_FRAMESKIP_INFO_0_HE NULL
#define OPTION_VAL_MANUAL_HE NULL
#define GENESIS_PLUS_GX_FRAMESKIP_THRESHOLD_LABEL_HE NULL
#define GENESIS_PLUS_GX_FRAMESKIP_THRESHOLD_INFO_0_HE NULL
#define GENESIS_PLUS_GX_YM2413_LABEL_HE NULL
#define GENESIS_PLUS_GX_YM2413_INFO_0_HE NULL
#define GENESIS_PLUS_GX_YM2413_CORE_LABEL_HE NULL
#define GENESIS_PLUS_GX_YM2413_CORE_INFO_0_HE NULL
#define OPTION_VAL_MAME_HE NULL
#define OPTION_VAL_NUKED_HE NULL
#define GENESIS_PLUS_GX_YM2612_LABEL_HE NULL
#define GENESIS_PLUS_GX_YM2612_INFO_0_HE NULL
#define GENESIS_PLUS_GX_YM2612_INFO_1_HE NULL
#define OPTION_VAL_MAME_YM2612_HE NULL
#define OPTION_VAL_MAME_ASIC_YM3438_HE NULL
#define OPTION_VAL_MAME_ENHANCED_YM3438_HE NULL
#define OPTION_VAL_NUKED_YM2612_HE NULL
#define OPTION_VAL_NUKED_YM3438_HE NULL
#define GENESIS_PLUS_GX_SOUND_OUTPUT_LABEL_HE NULL
#define GENESIS_PLUS_GX_SOUND_OUTPUT_INFO_0_HE NULL
#define OPTION_VAL_STEREO_HE NULL
#define OPTION_VAL_MONO_HE NULL
#define GENESIS_PLUS_GX_AUDIO_FILTER_LABEL_HE NULL
#define GENESIS_PLUS_GX_AUDIO_FILTER_INFO_0_HE NULL
#define OPTION_VAL_LOW_PASS_HE NULL
#define OPTION_VAL_EQ_HE NULL
#define GENESIS_PLUS_GX_LOWPASS_RANGE_LABEL_HE NULL
#define GENESIS_PLUS_GX_LOWPASS_RANGE_INFO_0_HE NULL
#define GENESIS_PLUS_GX_PSG_PREAMP_LABEL_HE NULL
#define GENESIS_PLUS_GX_PSG_PREAMP_INFO_0_HE NULL
#define GENESIS_PLUS_GX_FM_PREAMP_LABEL_HE NULL
#define GENESIS_PLUS_GX_FM_PREAMP_INFO_0_HE NULL
#define GENESIS_PLUS_GX_CDDA_VOLUME_LABEL_HE NULL
#define GENESIS_PLUS_GX_CDDA_VOLUME_INFO_0_HE NULL
#define GENESIS_PLUS_GX_PCM_VOLUME_LABEL_HE NULL
#define GENESIS_PLUS_GX_PCM_VOLUME_INFO_0_HE NULL
#define GENESIS_PLUS_GX_AUDIO_EQ_LOW_LABEL_HE NULL
#define GENESIS_PLUS_GX_AUDIO_EQ_LOW_INFO_0_HE NULL
#define GENESIS_PLUS_GX_AUDIO_EQ_MID_LABEL_HE NULL
#define GENESIS_PLUS_GX_AUDIO_EQ_MID_INFO_0_HE NULL
#define GENESIS_PLUS_GX_AUDIO_EQ_HIGH_LABEL_HE NULL
#define GENESIS_PLUS_GX_AUDIO_EQ_HIGH_INFO_0_HE NULL
#define GENESIS_PLUS_GX_GUN_INPUT_LABEL_HE NULL
#define GENESIS_PLUS_GX_GUN_INPUT_INFO_0_HE NULL
#define OPTION_VAL_LIGHTGUN_HE NULL
#define OPTION_VAL_TOUCHSCREEN_HE NULL
#define GENESIS_PLUS_GX_GUN_CURSOR_LABEL_HE NULL
#define GENESIS_PLUS_GX_GUN_CURSOR_INFO_0_HE NULL
#define GENESIS_PLUS_GX_INVERT_MOUSE_LABEL_HE NULL
#define GENESIS_PLUS_GX_INVERT_MOUSE_INFO_0_HE NULL
#define GENESIS_PLUS_GX_NO_SPRITE_LIMIT_LABEL_HE NULL
#define GENESIS_PLUS_GX_NO_SPRITE_LIMIT_INFO_0_HE NULL
#define GENESIS_PLUS_GX_ENHANCED_VSCROLL_LABEL_HE NULL
#define GENESIS_PLUS_GX_ENHANCED_VSCROLL_INFO_0_HE NULL
#define GENESIS_PLUS_GX_ENHANCED_VSCROLL_LIMIT_LABEL_HE NULL
#define GENESIS_PLUS_GX_ENHANCED_VSCROLL_LIMIT_INFO_0_HE NULL
#define GENESIS_PLUS_GX_OVERCLOCK_LABEL_HE NULL
#define GENESIS_PLUS_GX_OVERCLOCK_INFO_0_HE NULL
#define OPTION_VAL_100_HE NULL
#define OPTION_VAL_125_HE NULL
#define OPTION_VAL_150_HE NULL
#define OPTION_VAL_175_HE NULL
#define OPTION_VAL_200_HE NULL
#define OPTION_VAL_225_HE NULL
#define OPTION_VAL_250_HE NULL
#define OPTION_VAL_275_HE NULL
#define OPTION_VAL_300_HE NULL
#define OPTION_VAL_325_HE NULL
#define OPTION_VAL_350_HE NULL
#define OPTION_VAL_375_HE NULL
#define OPTION_VAL_400_HE NULL
#define OPTION_VAL_425_HE NULL
#define OPTION_VAL_450_HE NULL
#define OPTION_VAL_475_HE NULL
#define OPTION_VAL_500_HE NULL
#define GENESIS_PLUS_GX_FORCE_DTACK_LABEL_HE NULL
#define GENESIS_PLUS_GX_FORCE_DTACK_INFO_0_HE NULL
#define GENESIS_PLUS_GX_ADDR_ERROR_LABEL_HE NULL
#define GENESIS_PLUS_GX_ADDR_ERROR_INFO_0_HE NULL
#define GENESIS_PLUS_GX_CD_LATENCY_LABEL_HE NULL
#define GENESIS_PLUS_GX_CD_LATENCY_INFO_0_HE NULL
#define GENESIS_PLUS_GX_CD_PRECACHE_LABEL_HE NULL
#define GENESIS_PLUS_GX_CD_PRECACHE_INFO_0_HE NULL
#define GENESIS_PLUS_GX_SHOW_ADVANCED_AUDIO_SETTINGS_LABEL_HE NULL
#define GENESIS_PLUS_GX_SHOW_ADVANCED_AUDIO_SETTINGS_INFO_0_HE NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_0_VOLUME_LABEL_HE NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_0_VOLUME_INFO_0_HE NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_1_VOLUME_LABEL_HE NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_1_VOLUME_INFO_0_HE NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_2_VOLUME_LABEL_HE NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_2_VOLUME_INFO_0_HE NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_3_VOLUME_LABEL_HE NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_3_VOLUME_INFO_0_HE NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_0_VOLUME_LABEL_HE NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_0_VOLUME_INFO_0_HE NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_1_VOLUME_LABEL_HE NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_1_VOLUME_INFO_0_HE NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_2_VOLUME_LABEL_HE NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_2_VOLUME_INFO_0_HE NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_3_VOLUME_LABEL_HE NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_3_VOLUME_INFO_0_HE NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_4_VOLUME_LABEL_HE NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_4_VOLUME_INFO_0_HE NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_5_VOLUME_LABEL_HE NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_5_VOLUME_INFO_0_HE NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_0_VOLUME_LABEL_HE NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_0_VOLUME_INFO_0_HE NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_1_VOLUME_LABEL_HE NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_1_VOLUME_INFO_0_HE NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_2_VOLUME_LABEL_HE NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_2_VOLUME_INFO_0_HE NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_3_VOLUME_LABEL_HE NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_3_VOLUME_INFO_0_HE NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_4_VOLUME_LABEL_HE NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_4_VOLUME_INFO_0_HE NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_5_VOLUME_LABEL_HE NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_5_VOLUME_INFO_0_HE NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_6_VOLUME_LABEL_HE NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_6_VOLUME_INFO_0_HE NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_7_VOLUME_LABEL_HE NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_7_VOLUME_INFO_0_HE NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_8_VOLUME_LABEL_HE NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_8_VOLUME_INFO_0_HE NULL

struct retro_core_option_v2_category option_cats_he[] = {
   {
      "system",
      CATEGORY_SYSTEM_LABEL_HE,
      CATEGORY_SYSTEM_INFO_0_HE
   },
   {
      "video",
      CATEGORY_VIDEO_LABEL_HE,
      CATEGORY_VIDEO_INFO_0_HE
   },
   {
      "audio",
      CATEGORY_AUDIO_LABEL_HE,
      CATEGORY_AUDIO_INFO_0_HE
   },
   {
      "input",
      CATEGORY_INPUT_LABEL_HE,
      CATEGORY_INPUT_INFO_0_HE
   },
   {
      "hacks",
      CATEGORY_HACKS_LABEL_HE,
      CATEGORY_HACKS_INFO_0_HE
   },
   {
      "channel_volume",
      CATEGORY_CHANNEL_VOLUME_LABEL_HE,
      CATEGORY_CHANNEL_VOLUME_INFO_0_HE
   },
   { NULL, NULL, NULL },
};
struct retro_core_option_v2_definition option_defs_he[] = {
   {
      "genesis_plus_gx_system_hw",
      GENESIS_PLUS_GX_SYSTEM_HW_LABEL_HE,
      NULL,
      GENESIS_PLUS_GX_SYSTEM_HW_INFO_0_HE,
      NULL,
      "system",
      {
         { "auto",                 OPTION_VAL_AUTO_HE                 },
         { "sg-1000",              OPTION_VAL_SG_1000_HE              },
         { "sg-1000 II",           OPTION_VAL_SG_1000_II_HE           },
         { "sg-1000 II + ram ext.",OPTION_VAL_SG_1000_II_RAM_EXT_HE},
         { "mark-III",             OPTION_VAL_MARK_III_HE             },
         { "master system",        OPTION_VAL_MASTER_SYSTEM_HE        },
         { "master system II",     OPTION_VAL_MASTER_SYSTEM_II_HE     },
         { "game gear",            OPTION_VAL_GAME_GEAR_HE            },
         { "mega drive / genesis", OPTION_VAL_MEGA_DRIVE_GENESIS_HE   },
         { NULL, NULL },
      },
      "auto"
   },
   {
      "genesis_plus_gx_region_detect",
      GENESIS_PLUS_GX_REGION_DETECT_LABEL_HE,
      NULL,
      GENESIS_PLUS_GX_REGION_DETECT_INFO_0_HE,
      NULL,
      "system",
      {
         { "auto",    OPTION_VAL_AUTO_HE   },
         { "ntsc-u",  OPTION_VAL_NTSC_U_HE },
         { "pal",     OPTION_VAL_PAL_HE    },
         { "ntsc-j",  OPTION_VAL_NTSC_J_HE },
         { NULL, NULL },
      },
      "auto"
   },
   {
      "genesis_plus_gx_vdp_mode",
      GENESIS_PLUS_GX_VDP_MODE_LABEL_HE,
      NULL,
      GENESIS_PLUS_GX_VDP_MODE_INFO_0_HE,
      NULL,
      "system",
      {
         { "auto",  "Disabled" },
         { "60hz",  OPTION_VAL_60HZ_HE },
         { "50hz",  OPTION_VAL_50HZ_HE },
         { NULL, NULL },
      },
      "auto"
   },
   {
      "genesis_plus_gx_bios",
      GENESIS_PLUS_GX_BIOS_LABEL_HE,
      NULL,
      GENESIS_PLUS_GX_BIOS_INFO_0_HE,
      NULL,
      "system",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_system_bram",
      GENESIS_PLUS_GX_SYSTEM_BRAM_LABEL_HE,
      NULL,
      GENESIS_PLUS_GX_SYSTEM_BRAM_INFO_0_HE,
      NULL,
      "system",
      {
         { "per bios", OPTION_VAL_PER_BIOS_HE },
         { "per game", OPTION_VAL_PER_GAME_HE },
         { NULL, NULL },
      },
      "per bios"
   },
   {
      "genesis_plus_gx_cart_bram",
      GENESIS_PLUS_GX_CART_BRAM_LABEL_HE,
      NULL,
      GENESIS_PLUS_GX_CART_BRAM_INFO_0_HE,
      NULL,
      "system",
      {
         { "per cart", OPTION_VAL_PER_CART_HE },
         { "per game", OPTION_VAL_PER_GAME_HE },
         { NULL, NULL },
      },
      "per cart"
   },
   {
      "genesis_plus_gx_cart_size",
      GENESIS_PLUS_GX_CART_SIZE_LABEL_HE,
      NULL,
      GENESIS_PLUS_GX_CART_SIZE_INFO_0_HE,
      NULL,
      "system",
      {
         { "disabled", "Disabled" },
         { "128k",     OPTION_VAL_128K_HE  },
         { "256k",     OPTION_VAL_256K_HE  },
         { "512k",     OPTION_VAL_512K_HE  },
         { "1meg",     OPTION_VAL_1MEG_HE    },
         { "2meg",     OPTION_VAL_2MEG_HE    },
         { "4meg",     OPTION_VAL_4MEG_HE    },
         { NULL, NULL },
      },
      "4meg"
   },
   {
      "genesis_plus_gx_add_on",
      GENESIS_PLUS_GX_ADD_ON_LABEL_HE,
      NULL,
      GENESIS_PLUS_GX_ADD_ON_INFO_0_HE,
      NULL,
      "system",
      {
         { "auto",         OPTION_VAL_AUTO_HE },
         { "sega/mega cd", OPTION_VAL_SEGA_MEGA_CD_HE },
         { "megasd",       OPTION_VAL_MEGASD_HE },
         { "none",         OPTION_VAL_NONE_HE },
         { NULL, NULL },
      },
      "auto"
   },
   {
      "genesis_plus_gx_lock_on",
      GENESIS_PLUS_GX_LOCK_ON_LABEL_HE,
      NULL,
      GENESIS_PLUS_GX_LOCK_ON_INFO_0_HE,
      NULL,
      "system",
      {
         { "disabled",            NULL },
         { "game genie",          OPTION_VAL_GAME_GENIE_HE },
         { "action replay (pro)", OPTION_VAL_ACTION_REPLAY_PRO_HE },
         { "sonic & knuckles",    OPTION_VAL_SONIC_KNUCKLES_HE },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_aspect_ratio",
      GENESIS_PLUS_GX_ASPECT_RATIO_LABEL_HE,
      NULL,
      GENESIS_PLUS_GX_ASPECT_RATIO_INFO_0_HE,
      NULL,
      "video",
      {
         { "auto",     OPTION_VAL_AUTO_HE },
         { "NTSC PAR", OPTION_VAL_NTSC_PAR_HE },
         { "PAL PAR",  OPTION_VAL_PAL_PAR_HE },
         { "4:3",  OPTION_VAL_4_3_HE },
         { "Uncorrected",  OPTION_VAL_UNCORRECTED_HE },
      },
      "auto"
   },
   {
      "genesis_plus_gx_overscan",
      GENESIS_PLUS_GX_OVERSCAN_LABEL_HE,
      NULL,
      GENESIS_PLUS_GX_OVERSCAN_INFO_0_HE,
      NULL,
      "video",
      {
         { "disabled",   NULL },
         { "top/bottom", OPTION_VAL_TOP_BOTTOM_HE },
         { "left/right", OPTION_VAL_LEFT_RIGHT_HE },
         { "full",       OPTION_VAL_FULL_HE },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_left_border",
      GENESIS_PLUS_GX_LEFT_BORDER_LABEL_HE,
      NULL,
      GENESIS_PLUS_GX_LEFT_BORDER_INFO_0_HE,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "left border", OPTION_VAL_LEFT_BORDER_HE },
         { "left & right borders", OPTION_VAL_LEFT_RIGHT_BORDERS_HE },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_gg_extra",
      GENESIS_PLUS_GX_GG_EXTRA_LABEL_HE,
      NULL,
      GENESIS_PLUS_GX_GG_EXTRA_INFO_0_HE,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_blargg_ntsc_filter",
      GENESIS_PLUS_GX_BLARGG_NTSC_FILTER_LABEL_HE,
      NULL,
      GENESIS_PLUS_GX_BLARGG_NTSC_FILTER_INFO_0_HE,
      NULL,
      "video",
      {
         { "disabled",   NULL },
         { "monochrome", OPTION_VAL_MONOCHROME_HE },
         { "composite",  OPTION_VAL_COMPOSITE_HE },
         { "svideo",     OPTION_VAL_SVIDEO_HE },
         { "rgb",        OPTION_VAL_RGB_HE },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_lcd_filter",
      GENESIS_PLUS_GX_LCD_FILTER_LABEL_HE,
      NULL,
      GENESIS_PLUS_GX_LCD_FILTER_INFO_0_HE,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_render",
      GENESIS_PLUS_GX_RENDER_LABEL_HE,
      NULL,
      GENESIS_PLUS_GX_RENDER_INFO_0_HE,
      NULL,
      "video",
      {
         { "single field", OPTION_VAL_SINGLE_FIELD_HE },
         { "double field", OPTION_VAL_DOUBLE_FIELD_HE },
         { NULL, NULL },
      },
      "single field"
   },
   {
      "genesis_plus_gx_frameskip",
      GENESIS_PLUS_GX_FRAMESKIP_LABEL_HE,
      NULL,
      GENESIS_PLUS_GX_FRAMESKIP_INFO_0_HE,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "auto",     OPTION_VAL_AUTO_HE },
         { "manual",   OPTION_VAL_MANUAL_HE },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_frameskip_threshold",
      GENESIS_PLUS_GX_FRAMESKIP_THRESHOLD_LABEL_HE,
      NULL,
      GENESIS_PLUS_GX_FRAMESKIP_THRESHOLD_INFO_0_HE,
      NULL,
      "video",
      {
         { "15", NULL },
         { "18", NULL },
         { "21", NULL },
         { "24", NULL },
         { "27", NULL },
         { "30", NULL },
         { "33", NULL },
         { "36", NULL },
         { "39", NULL },
         { "42", NULL },
         { "45", NULL },
         { "48", NULL },
         { "51", NULL },
         { "54", NULL },
         { "57", NULL },
         { "60", NULL },
         { NULL, NULL },
      },
      "33"
   },
   {
      "genesis_plus_gx_ym2413",
      GENESIS_PLUS_GX_YM2413_LABEL_HE,
      NULL,
      GENESIS_PLUS_GX_YM2413_INFO_0_HE,
      NULL,
      "audio",
      {
         { "auto",     OPTION_VAL_AUTO_HE },
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "auto"
   },
#ifdef HAVE_OPLL_CORE
   {
      "genesis_plus_gx_ym2413_core",
      GENESIS_PLUS_GX_YM2413_CORE_LABEL_HE,
      NULL,
      GENESIS_PLUS_GX_YM2413_CORE_INFO_0_HE,
      NULL,
      "audio",
      {
         { "mame",  OPTION_VAL_MAME_HE },
         { "nuked", OPTION_VAL_NUKED_HE },
         { NULL, NULL },
      },
      "mame"
   },
#endif
   {
      "genesis_plus_gx_ym2612",
      GENESIS_PLUS_GX_YM2612_LABEL_HE,
      NULL,
#ifdef HAVE_YM3438_CORE
      GENESIS_PLUS_GX_YM2612_INFO_0_HE,
#else
      GENESIS_PLUS_GX_YM2612_INFO_1_HE,
#endif
      NULL,
      "audio",
      {
         { "mame (ym2612)",          OPTION_VAL_MAME_YM2612_HE },
         { "mame (asic ym3438)",     OPTION_VAL_MAME_ASIC_YM3438_HE },
         { "mame (enhanced ym3438)", OPTION_VAL_MAME_ENHANCED_YM3438_HE },
#ifdef HAVE_YM3438_CORE
         { "nuked (ym2612)",         OPTION_VAL_NUKED_YM2612_HE },
         { "nuked (ym3438)",         OPTION_VAL_NUKED_YM3438_HE },
#endif
         { NULL, NULL },
      },
      "mame (ym2612)"
   },
   {
      "genesis_plus_gx_sound_output",
      GENESIS_PLUS_GX_SOUND_OUTPUT_LABEL_HE,
      NULL,
      GENESIS_PLUS_GX_SOUND_OUTPUT_INFO_0_HE,
      NULL,
      "audio",
      {
         { "stereo", OPTION_VAL_STEREO_HE },
         { "mono",   OPTION_VAL_MONO_HE },
         { NULL, NULL },
      },
      "stereo"
   },
   {
      "genesis_plus_gx_audio_filter",
      GENESIS_PLUS_GX_AUDIO_FILTER_LABEL_HE,
      NULL,
      GENESIS_PLUS_GX_AUDIO_FILTER_INFO_0_HE,
      NULL,
      "audio",
      {
         { "disabled", NULL },
         { "low-pass", OPTION_VAL_LOW_PASS_HE },
#ifdef HAVE_EQ
         { "EQ",       OPTION_VAL_EQ_HE },
#endif
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_lowpass_range",
      GENESIS_PLUS_GX_LOWPASS_RANGE_LABEL_HE,
      NULL,
      GENESIS_PLUS_GX_LOWPASS_RANGE_INFO_0_HE,
      NULL,
      "audio",
      {
         { "5",  NULL },
         { "10", NULL },
         { "15", NULL },
         { "20", NULL },
         { "25", NULL },
         { "30", NULL },
         { "35", NULL },
         { "40", NULL },
         { "45", NULL },
         { "50", NULL },
         { "55", NULL },
         { "60", NULL },
         { "65", NULL },
         { "70", NULL },
         { "75", NULL },
         { "80", NULL },
         { "85", NULL },
         { "90", NULL },
         { "95", NULL },
         { NULL, NULL },
      },
      "60"
   },
   {
      "genesis_plus_gx_psg_preamp",
      GENESIS_PLUS_GX_PSG_PREAMP_LABEL_HE,
      NULL,
      GENESIS_PLUS_GX_PSG_PREAMP_INFO_0_HE,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { "105", NULL },
         { "110", NULL },
         { "115", NULL },
         { "120", NULL },
         { "125", NULL },
         { "130", NULL },
         { "135", NULL },
         { "140", NULL },
         { "145", NULL },
         { "150", NULL },
         { "155", NULL },
         { "160", NULL },
         { "165", NULL },
         { "170", NULL },
         { "175", NULL },
         { "180", NULL },
         { "185", NULL },
         { "190", NULL },
         { "195", NULL },
         { "200", NULL },
         { NULL, NULL },
      },
      "150"
   },
   {
      "genesis_plus_gx_fm_preamp",
      GENESIS_PLUS_GX_FM_PREAMP_LABEL_HE,
      NULL,
      GENESIS_PLUS_GX_FM_PREAMP_INFO_0_HE,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { "105", NULL },
         { "110", NULL },
         { "115", NULL },
         { "120", NULL },
         { "125", NULL },
         { "130", NULL },
         { "135", NULL },
         { "140", NULL },
         { "145", NULL },
         { "150", NULL },
         { "155", NULL },
         { "160", NULL },
         { "165", NULL },
         { "170", NULL },
         { "175", NULL },
         { "180", NULL },
         { "185", NULL },
         { "190", NULL },
         { "195", NULL },
         { "200", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_cdda_volume",
      GENESIS_PLUS_GX_CDDA_VOLUME_LABEL_HE,
      NULL,
      GENESIS_PLUS_GX_CDDA_VOLUME_INFO_0_HE,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_pcm_volume",
      GENESIS_PLUS_GX_PCM_VOLUME_LABEL_HE,
      NULL,
      GENESIS_PLUS_GX_PCM_VOLUME_INFO_0_HE,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
#ifdef HAVE_EQ
   {
      "genesis_plus_gx_audio_eq_low",
      GENESIS_PLUS_GX_AUDIO_EQ_LOW_LABEL_HE,
      NULL,
      GENESIS_PLUS_GX_AUDIO_EQ_LOW_INFO_0_HE,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_audio_eq_mid",
      GENESIS_PLUS_GX_AUDIO_EQ_MID_LABEL_HE,
      NULL,
      GENESIS_PLUS_GX_AUDIO_EQ_MID_INFO_0_HE,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_audio_eq_high",
      GENESIS_PLUS_GX_AUDIO_EQ_HIGH_LABEL_HE,
      NULL,
      GENESIS_PLUS_GX_AUDIO_EQ_HIGH_INFO_0_HE,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
#endif
   {
      "genesis_plus_gx_gun_input",
      GENESIS_PLUS_GX_GUN_INPUT_LABEL_HE,
      NULL,
      GENESIS_PLUS_GX_GUN_INPUT_INFO_0_HE,
      NULL,
      "input",
      {
         { "lightgun",    OPTION_VAL_LIGHTGUN_HE },
         { "touchscreen", OPTION_VAL_TOUCHSCREEN_HE },
         { NULL, NULL },
      },
      "lightgun"
   },
   {
      "genesis_plus_gx_gun_cursor",
      GENESIS_PLUS_GX_GUN_CURSOR_LABEL_HE,
      NULL,
      GENESIS_PLUS_GX_GUN_CURSOR_INFO_0_HE,
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_invert_mouse",
      GENESIS_PLUS_GX_INVERT_MOUSE_LABEL_HE,
      NULL,
      GENESIS_PLUS_GX_INVERT_MOUSE_INFO_0_HE,
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_no_sprite_limit",
      GENESIS_PLUS_GX_NO_SPRITE_LIMIT_LABEL_HE,
      NULL,
      GENESIS_PLUS_GX_NO_SPRITE_LIMIT_INFO_0_HE,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disa