#ifndef itkImageBoundaryConditionSwigInterface_h
#define itkImageBoundaryConditionSwigInterface_h
#include "itkCommand.h"
#include "itkOffset.h"
#include "itkVector.h"
#include "itkCovariantVector.h"
#include "itkContinuousIndex.h"
#include "itkArray.h"
#include "itkFixedArray.h"
#include "itkRGBPixel.h"
#include "itkRGBAPixel.h"
#include "complex"
#include "itkSymmetricSecondRankTensor.h"
#include "itkImage.h"
#include "itkVectorImage.h"
#include "itkVariableLengthVector.h"
#include "itkPoint.h"
#include "itkImageBoundaryCondition.h"
#include "itkPeriodicBoundaryCondition.h"
#include "itkZeroFluxNeumannBoundaryCondition.h"
#include "itkConstantBoundaryCondition.h"

using itkImageBoundaryConditionIRGBUC2 = itk::ImageBoundaryCondition< itk::Image< itk::RGBPixel< unsigned char >,2 > >;
using itkImageBoundaryConditionIRGBUC3 = itk::ImageBoundaryCondition< itk::Image< itk::RGBPixel< unsigned char >,3 > >;
using itkImageBoundaryConditionIRGBUC4 = itk::ImageBoundaryCondition< itk::Image< itk::RGBPixel< unsigned char >,4 > >;
using itkImageBoundaryConditionIRGBUS2 = itk::ImageBoundaryCondition< itk::Image< itk::RGBPixel< unsigned short >,2 > >;
using itkImageBoundaryConditionIRGBUS3 = itk::ImageBoundaryCondition< itk::Image< itk::RGBPixel< unsigned short >,3 > >;
using itkImageBoundaryConditionIRGBUS4 = itk::ImageBoundaryCondition< itk::Image< itk::RGBPixel< unsigned short >,4 > >;
using itkImageBoundaryConditionIRGBAUC2 = itk::ImageBoundaryCondition< itk::Image< itk::RGBAPixel< unsigned char >,2 > >;
using itkImageBoundaryConditionIRGBAUC3 = itk::ImageBoundaryCondition< itk::Image< itk::RGBAPixel< unsigned char >,3 > >;
using itkImageBoundaryConditionIRGBAUC4 = itk::ImageBoundaryCondition< itk::Image< itk::RGBAPixel< unsigned char >,4 > >;
using itkImageBoundaryConditionIRGBAUS2 = itk::ImageBoundaryCondition< itk::Image< itk::RGBAPixel< unsigned short >,2 > >;
using itkImageBoundaryConditionIRGBAUS3 = itk::ImageBoundaryCondition< itk::Image< itk::RGBAPixel< unsigned short >,3 > >;
using itkImageBoundaryConditionIRGBAUS4 = itk::ImageBoundaryCondition< itk::Image< itk::RGBAPixel< unsigned short >,4 > >;
using itkImageBoundaryConditionIVD22 = itk::ImageBoundaryCondition< itk::Image< itk::Vector< double,2 >,2 > >;
using itkImageBoundaryConditionIVD23 = itk::ImageBoundaryCondition< itk::Image< itk::Vector< double,2 >,3 > >;
using itkImageBoundaryConditionIVD24 = itk::ImageBoundaryCondition< itk::Image< itk::Vector< double,2 >,4 > >;
using itkImageBoundaryConditionIVD32 = itk::ImageBoundaryCondition< itk::Image< itk::Vector< double,3 >,2 > >;
using itkImageBoundaryConditionIVD33 = itk::ImageBoundaryCondition< itk::Image< itk::Vector< double,3 >,3 > >;
using itkImageBoundaryConditionIVD34 = itk::ImageBoundaryCondition< itk::Image< itk::Vector< double,3 >,4 > >;
using itkImageBoundaryConditionIVD42 = itk::ImageBoundaryCondition< itk::Image< itk::Vector< double,4 >,2 > >;
using itkImageBoundaryConditionIVD43 = itk::ImageBoundaryCondition< itk::Image< itk::Vector< double,4 >,3 > >;
using itkImageBoundaryConditionIVD44 = itk::ImageBoundaryCondition< itk::Image< itk::Vector< double,4 >,4 > >;
using itkImageBoundaryConditionIVF22 = itk::ImageBoundaryCondition< itk::Image< itk::Vector< float,2 >,2 > >;
using itkImageBoundaryConditionIVF23 = itk::ImageBoundaryCondition< itk::Image< itk::Vector< float,2 >,3 > >;
using itkImageBoundaryConditionIVF24 = itk::ImageBoundaryCondition< itk::Image< itk::Vector< float,2 >,4 > >;
using itkImageBoundaryConditionIVF32 = itk::ImageBoundaryCondition< itk::Image< itk::Vector< float,3 >,2 > >;
using itkImageBoundaryConditionIVF33 = itk::ImageBoundaryCondition< itk::Image< itk::Vector< float,3 >,3 > >;
using itkImageBoundaryConditionIVF34 = itk::ImageBoundaryCondition< itk::Image< itk::Vector< float,3 >,4 > >;
using itkImageBoundaryConditionIVF42 = itk::ImageBoundaryCondition< itk::Image< itk::Vector< float,4 >,2 > >;
using itkImageBoundaryConditionIVF43 = itk::ImageBoundaryCondition< itk::Image< itk::Vector< float,4 >,3 > >;
using itkImageBoundaryConditionIVF44 = itk::ImageBoundaryCondition< itk::Image< itk::Vector< float,4 >,4 > >;
using itkImageBoundaryConditionICVD22 = itk::ImageBoundaryCondition< itk::Image< itk::CovariantVector< double,2 >,2 > >;
using itkImageBoundaryConditionICVD23 = itk::ImageBoundaryCondition< itk::Image< itk::CovariantVector< double,2 >,3 > >;
using itkImageBoundaryConditionICVD24 = itk::ImageBoundaryCondition< itk::Image< itk::CovariantVector< double,2 >,4 > >;
using itkImageBoundaryConditionICVD32 = itk::ImageBoundaryCondition< itk::Image< itk::CovariantVector< double,3 >,2 > >;
using itkImageBoundaryConditionICVD33 = itk::ImageBoundaryCondition< itk::Image< itk::CovariantVector< double,3 >,3 > >;
using itkImageBoundaryConditionICVD34 = itk::ImageBoundaryCondition< itk::Image< itk::CovariantVector< double,3 >,4 > >;
using itkImageBoundaryConditionICVD42 = itk::ImageBoundaryCondition< itk::Image< itk::CovariantVector< double,4 >,2 > >;
using itkImageBoundaryConditionICVD43 = itk::ImageBoundaryCondition< itk::Image< itk::CovariantVector< double,4 >,3 > >;
using itkImageBoundaryConditionICVD44 = itk::ImageBoundaryCondition< itk::Image< itk::CovariantVector< double,4 >,4 > >;
using itkImageBoundaryConditionICVF22 = itk::ImageBoundaryCondition< itk::Image< itk::CovariantVector< float,2 >,2 > >;
using itkImageBoundaryConditionICVF23 = itk::ImageBoundaryCondition< itk::Image< itk::CovariantVector< float,2 >,3 > >;
using itkImageBoundaryConditionICVF24 = itk::ImageBoundaryCondition< itk::Image< itk::CovariantVector< float,2 >,4 > >;
using itkImageBoundaryConditionICVF32 = itk::ImageBoundaryCondition< itk::Image< itk::CovariantVector< float,3 >,2 > >;
using itkImageBoundaryConditionICVF33 = itk::ImageBoundaryCondition< itk::Image< itk::CovariantVector< float,3 >,3 > >;
using itkImageBoundaryConditionICVF34 = itk::ImageBoundaryCondition< itk::Image< itk::CovariantVector< float,3 >,4 > >;
using itkImageBoundaryConditionICVF42 = itk::ImageBoundaryCondition< itk::Image< itk::CovariantVector< float,4 >,2 > >;
using itkImageBoundaryConditionICVF43 = itk::ImageBoundaryCondition< itk::Image< itk::CovariantVector< float,4 >,3 > >;
using itkImageBoundaryConditionICVF44 = itk::ImageBoundaryCondition< itk::Image< itk::CovariantVector< float,4 >,4 > >;
using itkImageBoundaryConditionISC2 = itk::ImageBoundaryCondition< itk::Image< signed char,2 > >;
using itkImageBoundaryConditionISC3 = itk::ImageBoundaryCondition< itk::Image< signed char,3 > >;
using itkImageBoundaryConditionISC4 = itk::ImageBoundaryCondition< itk::Image< signed char,4 > >;
using itkImageBoundaryConditionISS2 = itk::ImageBoundaryCondition< itk::Image< signed short,2 > >;
using itkImageBoundaryConditionISS3 = itk::ImageBoundaryCondition< itk::Image< signed short,3 > >;
using itkImageBoundaryConditionISS4 = itk::ImageBoundaryCondition< itk::Image< signed short,4 > >;
using itkImageBoundaryConditionIUC2 = itk::ImageBoundaryCondition< itk::Image< unsigned char,2 > >;
using itkImageBoundaryConditionIUC3 = itk::ImageBoundaryCondition< itk::Image< unsigned char,3 > >;
using itkImageBoundaryConditionIUC4 = itk::ImageBoundaryCondition< itk::Image< unsigned char,4 > >;
using itkImageBoundaryConditionIULL2 = itk::ImageBoundaryCondition< itk::Image< unsigned long long,2 > >;
using itkImageBoundaryConditionIULL3 = itk::ImageBoundaryCondition< itk::Image< unsigned long long,3 > >;
using itkImageBoundaryConditionIULL4 = itk::ImageBoundaryCondition< itk::Image< unsigned long long,4 > >;
using itkImageBoundaryConditionIUS2 = itk::ImageBoundaryCondition< itk::Image< unsigned short,2 > >;
using itkImageBoundaryConditionIUS3 = itk::ImageBoundaryCondition< itk::Image< unsigned short,3 > >;
using itkImageBoundaryConditionIUS4 = itk::ImageBoundaryCondition< itk::Image< unsigned short,4 > >;
using itkImageBoundaryConditionIF2 = itk::ImageBoundaryCondition< itk::Image< float,2 > >;
using itkImageBoundaryConditionIF3 = itk::ImageBoundaryCondition< itk::Image< float,3 > >;
using itkImageBoundaryConditionIF4 = itk::ImageBoundaryCondition< itk::Image< float,4 > >;
using itkImageBoundaryConditionID2 = itk::ImageBoundaryCondition< itk::Image< double,2 > >;
using itkImageBoundaryConditionID3 = itk::ImageBoundaryCondition< itk::Image< double,3 > >;
using itkImageBoundaryConditionID4 = itk::ImageBoundaryCondition< itk::Image< double,4 > >;
using itkImageBoundaryConditionICD2 = itk::ImageBoundaryCondition< itk::Image< std::complex< double >,2 > >;
using itkImageBoundaryConditionICD3 = itk::ImageBoundaryCondition< itk::Image< std::complex< double >,3 > >;
using itkImageBoundaryConditionICD4 = itk::ImageBoundaryCondition< itk::Image< std::complex< double >,4 > >;
using itkImageBoundaryConditionICF2 = itk::ImageBoundaryCondition< itk::Image< std::complex< float >,2 > >;
using itkImageBoundaryConditionICF3 = itk::ImageBoundaryCondition< itk::Image< std::complex< float >,3 > >;
using itkImageBoundaryConditionICF4 = itk::ImageBoundaryCondition< itk::Image< std::complex< float >,4 > >;
using itkPeriodicBoundaryConditionIRGBUC2 = itk::PeriodicBoundaryCondition< itk::Image< itk::RGBPixel< unsigned char >,2 > >;
using itkPeriodicBoundaryConditionIRGBUC3 = itk::PeriodicBoundaryCondition< itk::Image< itk::RGBPixel< unsigned char >,3 > >;
using itkPeriodicBoundaryConditionIRGBUC4 = itk::PeriodicBoundaryCondition< itk::Image< itk::RGBPixel< unsigned char >,4 > >;
using itkPeriodicBoundaryConditionIRGBUS2 = itk::PeriodicBoundaryCondition< itk::Image< itk::RGBPixel< unsigned short >,2 > >;
using itkPeriodicBoundaryConditionIRGBUS3 = itk::PeriodicBoundaryCondition< itk::Image< itk::RGBPixel< unsigned short >,3 > >;
using itkPeriodicBoundaryConditionIRGBUS4 = itk::PeriodicBoundaryCondition< itk::Image< itk::RGBPixel< unsigned short >,4 > >;
using itkPeriodicBoundaryConditionIRGBAUC2 = itk::PeriodicBoundaryCondition< itk::Image< itk::RGBAPixel< unsigned char >,2 > >;
using itkPeriodicBoundaryConditionIRGBAUC3 = itk::PeriodicBoundaryCondition< itk::Image< itk::RGBAPixel< unsigned char >,3 > >;
using itkPeriodicBoundaryConditionIRGBAUC4 = itk::PeriodicBoundaryCondition< itk::Image< itk::RGBAPixel< unsigned char >,4 > >;
using itkPeriodicBoundaryConditionIRGBAUS2 = itk::PeriodicBoundaryCondition< itk::Image< itk::RGBAPixel< unsigned short >,2 > >;
using itkPeriodicBoundaryConditionIRGBAUS3 = itk::PeriodicBoundaryCondition< itk::Image< itk::RGBAPixel< unsigned short >,3 > >;
using itkPeriodicBoundaryConditionIRGBAUS4 = itk::PeriodicBoundaryCondition< itk::Image< itk::RGBAPixel< unsigned short >,4 > >;
using itkPeriodicBoundaryConditionIVD22 = itk::PeriodicBoundaryCondition< itk::Image< itk::Vector< double,2 >,2 > >;
using itkPeriodicBoundaryConditionIVD23 = itk::PeriodicBoundaryCondition< itk::Image< itk::Vector< double,2 >,3 > >;
using itkPeriodicBoundaryConditionIVD24 = itk::PeriodicBoundaryCondition< itk::Image< itk::Vector< double,2 >,4 > >;
using itkPeriodicBoundaryConditionIVD32 = itk::PeriodicBoundaryCondition< itk::Image< itk::Vector< double,3 >,2 > >;
using itkPeriodicBoundaryConditionIVD33 = itk::PeriodicBoundaryCondition< itk::Image< itk::Vector< double,3 >,3 > >;
using itkPeriodicBoundaryConditionIVD34 = itk::PeriodicBoundaryCondition< itk::Image< itk::Vector< double,3 >,4 > >;
using itkPeriodicBoundaryConditionIVD42 = itk::PeriodicBoundaryCondition< itk::Image< itk::Vector< double,4 >,2 > >;
using itkPeriodicBoundaryConditionIVD43 = itk::PeriodicBoundaryCondition< itk::Image< itk::Vector< double,4 >,3 > >;
using itkPeriodicBoundaryConditionIVD44 = itk::PeriodicBoundaryCondition< itk::Image< itk::Vector< double,4 >,4 > >;
using itkPeriodicBoundaryConditionIVF22 = itk::PeriodicBoundaryCondition< itk::Image< itk::Vector< float,2 >,2 > >;
using itkPeriodicBoundaryConditionIVF23 = itk::PeriodicBoundaryCondition< itk::Image< itk::Vector< float,2 >,3 > >;
using itkPeriodicBoundaryConditionIVF24 = itk::PeriodicBoundaryCondition< itk::Image< itk::Vector< float,2 >,4 > >;
using itkPeriodicBoundaryConditionIVF32 = itk::PeriodicBoundaryCondition< itk::Image< itk::Vector< float,3 >,2 > >;
using itkPeriodicBoundaryConditionIVF33 = itk::PeriodicBoundaryCondition< itk::Image< itk::Vector< float,3 >,3 > >;
using itkPeriodicBoundaryConditionIVF34 = itk::PeriodicBoundaryCondition< itk::Image< itk::Vector< float,3 >,4 > >;
using itkPeriodicBoundaryConditionIVF42 = itk::PeriodicBoundaryCondition< itk::Image< itk::Vector< float,4 >,2 > >;
using itkPeriodicBoundaryConditionIVF43 = itk::PeriodicBoundaryCondition< itk::Image< itk::Vector< float,4 >,3 > >;
using itkPeriodicBoundaryConditionIVF44 = itk::PeriodicBoundaryCondition< itk::Image< itk::Vector< float,4 >,4 > >;
using itkPeriodicBoundaryConditionICVD22 = itk::PeriodicBoundaryCondition< itk::Image< itk::CovariantVector< double,2 >,2 > >;
using itkPeriodicBoundaryConditionICVD23 = itk::PeriodicBoundaryCondition< itk::Image< itk::CovariantVector< double,2 >,3 > >;
using itkPeriodicBoundaryConditionICVD24 = itk::PeriodicBoundaryCondition< itk::Image< itk::CovariantVector< double,2 >,4 > >;
using itkPeriodicBoundaryConditionICVD32 = itk::PeriodicBoundaryCondition< itk::Image< itk::CovariantVector< double,3 >,2 > >;
using itkPeriodicBoundaryConditionICVD33 = itk::PeriodicBoundaryCondition< itk::Image< itk::CovariantVector< double,3 >,3 > >;
using itkPeriodicBoundaryConditionICVD34 = itk::PeriodicBoundaryCondition< itk::Image< itk::CovariantVector< double,3 >,4 > >;
using itkPeriodicBoundaryConditionICVD42 = itk::PeriodicBoundaryCondition< itk::Image< itk::CovariantVector< double,4 >,2 > >;
using itkPeriodicBoundaryConditionICVD43 = itk::PeriodicBoundaryCondition< itk::Image< itk::CovariantVector< double,4 >,3 > >;
using itkPeriodicBoundaryConditionICVD44 = itk::PeriodicBoundaryCondition< itk::Image< itk::CovariantVector< double,4 >,4 > >;
using itkPeriodicBoundaryConditionICVF22 = itk::PeriodicBoundaryCondition< itk::Image< itk::CovariantVector< float,2 >,2 > >;
using itkPeriodicBoundaryConditionICVF23 = itk::PeriodicBoundaryCondition< itk::Image< itk::CovariantVector< float,2 >,3 > >;
using itkPeriodicBoundaryConditionICVF24 = itk::PeriodicBoundaryCondition< itk::Image< itk::CovariantVector< float,2 >,4 > >;
using itkPeriodicBoundaryConditionICVF32 = itk::PeriodicBoundaryCondition< itk::Image< itk::CovariantVector< float,3 >,2 > >;
using itkPeriodicBoundaryConditionICVF33 = itk::PeriodicBoundaryCondition< itk::Image< itk::CovariantVector< float,3 >,3 > >;
using itkPeriodicBoundaryConditionICVF34 = itk::PeriodicBoundaryCondition< itk::Image< itk::CovariantVector< float,3 >,4 > >;
using itkPeriodicBoundaryConditionICVF42 = itk::PeriodicBoundaryCondition< itk::Image< itk::CovariantVector< float,4 >,2 > >;
using itkPeriodicBoundaryConditionICVF43 = itk::PeriodicBoundaryCondition< itk::Image< itk::CovariantVector< float,4 >,3 > >;
using itkPeriodicBoundaryConditionICVF44 = itk::PeriodicBoundaryCondition< itk::Image< itk::CovariantVector< float,4 >,4 > >;
using itkPeriodicBoundaryConditionISC2 = itk::PeriodicBoundaryCondition< itk::Image< signed char,2 > >;
using itkPeriodicBoundaryConditionISC3 = itk::PeriodicBoundaryCondition< itk::Image< signed char,3 > >;
using itkPeriodicBoundaryConditionISC4 = itk::PeriodicBoundaryCondition< itk::Image< signed char,4 > >;
using itkPeriodicBoundaryConditionISS2 = itk::PeriodicBoundaryCondition< itk::Image< signed short,2 > >;
using itkPeriodicBoundaryConditionISS3 = itk::PeriodicBoundaryCondition< itk::Image< signed short,3 > >;
using itkPeriodicBoundaryConditionISS4 = itk::PeriodicBoundaryCondition< itk::Image< signed short,4 > >;
using itkPeriodicBoundaryConditionIUC2 = itk::PeriodicBoundaryCondition< itk::Image< unsigned char,2 > >;
using itkPeriodicBoundaryConditionIUC3 = itk::PeriodicBoundaryCondition< itk::Image< unsigned char,3 > >;
using itkPeriodicBoundaryConditionIUC4 = itk::PeriodicBoundaryCondition< itk::Image< unsigned char,4 > >;
using itkPeriodicBoundaryConditionIULL2 = itk::PeriodicBoundaryCondition< itk::Image< unsigned long long,2 > >;
using itkPeriodicBoundaryConditionIULL3 = itk::PeriodicBoundaryCondition< itk::Image< unsigned long long,3 > >;
using itkPeriodicBoundaryConditionIULL4 = itk::PeriodicBoundaryCondition< itk::Image< unsigned long long,4 > >;
using itkPeriodicBoundaryConditionIUS2 = itk::PeriodicBoundaryCondition< itk::Image< unsigned short,2 > >;
using itkPeriodicBoundaryConditionIUS3 = itk::PeriodicBoundaryCondition< itk::Image< unsigned short,3 > >;
using itkPeriodicBoundaryConditionIUS4 = itk::PeriodicBoundaryCondition< itk::Image< unsigned short,4 > >;
using itkPeriodicBoundaryConditionIF2 = itk::PeriodicBoundaryCondition< itk::Image< float,2 > >;
using itkPeriodicBoundaryConditionIF3 = itk::PeriodicBoundaryCondition< itk::Image< float,3 > >;
using itkPeriodicBoundaryConditionIF4 = itk::PeriodicBoundaryCondition< itk::Image< float,4 > >;
using itkPeriodicBoundaryConditionID2 = itk::PeriodicBoundaryCondition< itk::Image< double,2 > >;
using itkPeriodicBoundaryConditionID3 = itk::PeriodicBoundaryCondition< itk::Image< double,3 > >;
using itkPeriodicBoundaryConditionID4 = itk::PeriodicBoundaryCondition< itk::Image< double,4 > >;
using itkPeriodicBoundaryConditionICD2 = itk::PeriodicBoundaryCondition< itk::Image< std::complex< double >,2 > >;
using itkPeriodicBoundaryConditionICD3 = itk::PeriodicBoundaryCondition< itk::Image< std::complex< double >,3 > >;
using itkPeriodicBoundaryConditionICD4 = itk::PeriodicBoundaryCondition< itk::Image< std::complex< double >,4 > >;
using itkPeriodicBoundaryConditionICF2 = itk::PeriodicBoundaryCondition< itk::Image< std::complex< float >,2 > >;
using itkPeriodicBoundaryConditionICF3 = itk::PeriodicBoundaryCondition< itk::Image< std::complex< float >,3 > >;
using itkPeriodicBoundaryConditionICF4 = itk::PeriodicBoundaryCondition< itk::Image< std::complex< float >,4 > >;
using itkZeroFluxNeumannBoundaryConditionIRGBUC2 = itk::ZeroFluxNeumannBoundaryCondition< itk::Image< itk::RGBPixel< unsigned char >,2 > >;
using itkZeroFluxNeumannBoundaryConditionIRGBUC3 = itk::ZeroFluxNeumannBoundaryCondition< itk::Image< itk::RGBPixel< unsigned char >,3 > >;
using itkZeroFluxNeumannBoundaryConditionIRGBUC4 = itk::ZeroFluxNeumannBoundaryCondition< itk::Image< itk::RGBPixel< unsigned char >,4 > >;
using itkZeroFluxNeumannBoundaryConditionIRGBUS2 = itk::ZeroFluxNeumannBoundaryCondition< itk::Image< itk::RGBPixel< unsigned short >,2 > >;
using itkZeroFluxNeumannBoundaryConditionIRGBUS3 = itk::ZeroFluxNeumannBoundaryCondition< itk::Image< itk::RGBPixel< unsigned short >,3 > >;
using itkZeroFluxNeumannBoundaryConditionIRGBUS4 = itk::ZeroFluxNeumannBoundaryCondition< itk::Image< itk::RGBPixel< unsigned short >,4 > >;
using itkZeroFluxNeumannBoundaryConditionIRGBAUC2 = itk::ZeroFluxNeumannBoundaryCondition< itk::Image< itk::RGBAPixel< unsigned char >,2 > >;
using itkZeroFluxNeumannBoundaryConditionIRGBAUC3 = itk::ZeroFluxNeumannBoundaryCondition< itk::Image< itk::RGBAPixel< unsigned char >,3 > >;
using itkZeroFluxNeumannBoundaryConditionIRGBAUC4 = itk::ZeroFluxNeumannBoundaryCondition< itk::Image< itk::RGBAPixel< unsigned char >,4 > >;
using itkZeroFluxNeumannBoundaryConditionIRGBAUS2 = itk::ZeroFluxNeumannBoundaryCondition< itk::Image< itk::RGBAPixel< unsigned short >,2 > >;
using itkZeroFluxNeumannBoundaryConditionIRGBAUS3 = itk::ZeroFluxNeumannBoundaryCondition< itk::Image< itk::RGBAPixel< unsigned short >,3 > >;
using itkZeroFluxNeumannBoundaryConditionIRGBAUS4 = itk::ZeroFluxNeumannBoundaryCondition< itk::Image< itk::RGBAPixel< unsigned short >,4 > >;
using itkZeroFluxNeumannBoundaryConditionIVD22 = itk::ZeroFluxNeumannBoundaryCondition< itk::Image< itk::Vector< double,2 >,2 > >;
using itkZeroFluxNeumannBoundaryConditionIVD23 = itk::ZeroFluxNeumannBoundaryCondition< itk::Image< itk::Vector< double,2 >,3 > >;
using itkZeroFluxNeumannBoundaryConditionIVD24 = itk::ZeroFluxNeumannBoundaryCondition< itk::Image< itk::Vector< double,2 >,4 > >;
using itkZeroFluxNeumannBoundaryConditionIVD32 = itk::ZeroFluxNeumannBoundaryCondition< itk::Image< itk::Vector< double,3 >,2 > >;
using itkZeroFluxNeumannBoundaryConditionIVD33 = itk::ZeroFluxNeumannBoundaryCondition< itk::Image< itk::Vector< double,3 >,3 > >;
using itkZeroFluxNeumannBoundaryConditionIVD34 = itk::ZeroFluxNeumannBoundaryCondition< itk::Image< itk::Vector< double,3 >,4 > >;
using itkZeroFluxNeumannBoundaryConditionIVD42 = itk::ZeroFluxNeumannBoundaryCondition< itk::Image< itk::Vector< double,4 >,2 > >;
using itkZeroFluxNeumannBoundaryConditionIVD43 = itk::ZeroFluxNeumannBoundaryCondition< itk::Image< itk::Vector< double,4 >,3 > >;
using itkZeroFluxNeumannBoundaryConditionIVD44 = itk::ZeroFluxNeumannBoundaryCondition< itk::Image< itk::Vector< double,4 >,4 > >;
using itkZeroFluxNeumannBoundaryConditionIVF22 = itk::ZeroFluxNeumannBoundaryCondition< itk::Image< itk::Vector< float,2 >,2 > >;
using itkZeroFluxNeumannBoundaryConditionIVF23 = itk::ZeroFluxNeumannBoundaryCondition< itk::Image< itk::Vector< float,2 >,3 > >;
using itkZeroFluxNeumannBoundaryConditionIVF24 = itk::ZeroFluxNeumannBoundaryCondition< itk::Image< itk::Vector< float,2 >,4 > >;
using itkZeroFluxNeumannBoundaryConditionIVF32 = itk::ZeroFluxNeumannBoundaryCondition< itk::Image< itk::Vector< float,3 >,2 > >;
using itkZeroFluxNeumannBoundaryConditionIVF33 = itk::ZeroFluxNeumannBoundaryCondition< itk::Image< itk::Vector< float,3 >,3 > >;
using itkZeroFluxNeumannBoundaryConditionIVF34 = itk::ZeroFluxNeumannBoundaryCondition< itk::Image< itk::Vector< float,3 >,4 > >;
using itkZeroFluxNeumannBoundaryConditionIVF42 = itk::ZeroFluxNeumannBoundaryCondition< itk::Image< itk::Vector< float,4 >,2 > >;
using itkZeroFluxNeumannBoundaryConditionIVF43 = itk::ZeroFluxNeumannBoundaryCondition< itk::Image< itk::Vector< float,4 >,3 > >;
using itkZeroFluxNeumannBoundaryConditionIVF44 = itk::ZeroFluxNeumannBoundaryCondition< itk::Image< itk::Vector< float,4 >,4 > >;
using itkZeroFluxNeumannBoundaryConditionICVD22 = itk::ZeroFluxNeumannBoundaryCondition< itk::Image< itk::CovariantVector< double,2 >,2 > >;
using itkZeroFluxNeumannBoundaryConditionICVD23 = itk::ZeroFluxNeumannBoundaryCondition< itk::Image< itk::CovariantVector< double,2 >,3 > >;
using itkZeroFluxNeumannBoundaryConditionICVD24 = itk::ZeroFluxNeumannBoundaryCondition< itk::Image< itk::CovariantVector< double,2 >,4 > >;
using itkZeroFluxNeumannBoundaryConditionICVD32 = itk::ZeroFluxNeumannBoundaryCondition< itk::Image< itk::CovariantVector< double,3 >,2 > >;
using itkZeroFluxNeumannBoundaryConditionICVD33 = itk::ZeroFluxNeumannBoundaryCondition< itk::Image< itk::CovariantVector< double,3 >,3 > >;
using itkZeroFluxNeumannBoundaryConditionICVD34 = itk::ZeroFluxNeumannBoundaryCondition< itk::Image< itk::CovariantVector< double,3 >,4 > >;
using itkZeroFluxNeumannBoundaryConditionICVD42 = itk::ZeroFluxNeumannBoundaryCondition< itk::Image< itk::CovariantVector< double,4 >,2 > >;
using itkZeroFluxNeumannBoundaryConditionICVD43 = itk::ZeroFluxNeumannBoundaryCondition< itk::Image< itk::CovariantVector< double,4 >,3 > >;
using itkZeroFluxNeumannBoundaryConditionICVD44 = itk::ZeroFluxNeumannBoundaryCondition< itk::Image< itk::CovariantVector< double,4 >,4 > >;
using itkZeroFluxNeumannBoundaryConditionICVF22 = itk::ZeroFluxNeumannBoundaryCondition< itk::Image< itk::CovariantVector< float,2 >,2 > >;
using itkZeroFluxNeumannBoundaryConditionICVF23 = itk::ZeroFluxNeumannBoundaryCondition< itk::Image< itk::CovariantVector< float,2 >,3 > >;
using itkZeroFluxNeumannBoundaryConditionICVF24 = itk::ZeroFluxNeumannBoundaryCondition< itk::Image< itk::CovariantVector< float,2 >,4 > >;
using itkZeroFluxNeumannBoundaryConditionICVF32 = itk::ZeroFluxNeumannBoundaryCondition< itk::Image< itk::CovariantVector< float,3 >,2 > >;
using itkZeroFluxNeumannBoundaryConditionICVF33 = itk::ZeroFluxNeumannBoundaryCondition< itk::Image< itk::CovariantVector< float,3 >,3 > >;
using itkZeroFluxNeumannBoundaryConditionICVF34 = itk::ZeroFluxNeumannBoundaryCondition< itk::Image< itk::CovariantVector< float,3 >,4 > >;
using itkZeroFluxNeumannBoundaryConditionICVF42 = itk::ZeroFluxNeumannBoundaryCondition< itk::Image< itk::CovariantVector< float,4 >,2 > >;
using itkZeroFluxNeumannBoundaryConditionICVF43 = itk::ZeroFluxNeumannBoundaryCondition< itk::Image< itk::CovariantVector< float,4 >,3 > >;
using itkZeroFluxNeumannBoundaryConditionICVF44 = itk::ZeroFluxNeumannBoundaryCondition< itk::Image< itk::CovariantVector< float,4 >,4 > >;
using itkZeroFluxNeumannBoundaryConditionISC2 = itk::ZeroFluxNeumannBoundaryCondition< itk::Image< signed char,2 > >;
using itkZeroFluxNeumannBoundaryConditionISC3 = itk::ZeroFluxNeumannBoundaryCondition< itk::Image< signed char,3 > >;
using itkZeroFluxNeumannBoundaryConditionISC4 = itk::ZeroFluxNeumannBoundaryCondition< itk::Image< signed char,4 > >;
using itkZeroFluxNeumannBoundaryConditionISS2 = itk::ZeroFluxNeumannBoundaryCondition< itk::Image< signed short,2 > >;
using itkZeroFluxNeumannBoundaryConditionISS3 = itk::ZeroFluxNeumannBoundaryCondition< itk::Image< signed short,3 > >;
using itkZeroFluxNeumannBoundaryConditionISS4 = itk::ZeroFluxNeumannBoundaryCondition< itk::Image< signed short,4 > >;
using itkZeroFluxNeumannBoundaryConditionIUC2 = itk::ZeroFluxNeumannBoundaryCondition< itk::Image< unsigned char,2 > >;
using itkZeroFluxNeumannBoundaryConditionIUC3 = itk::ZeroFluxNeumannBoundaryCondition< itk::Image< unsigned char,3 > >;
using itkZeroFluxNeumannBoundaryConditionIUC4 = itk::ZeroFluxNeumannBoundaryCondition< itk::Image< unsigned char,4 > >;
using itkZeroFluxNeumannBoundaryConditionIULL2 = itk::ZeroFluxNeumannBoundaryCondition< itk::Image< unsigned long long,2 > >;
using itkZeroFluxNeumannBoundaryConditionIULL3 = itk::ZeroFluxNeumannBoundaryCondition< itk::Image< unsigned long long,3 > >;
using itkZeroFluxNeumannBoundaryConditionIULL4 = itk::ZeroFluxNeumannBoundaryCondition< itk::Image< unsigned long long,4 > >;
using itkZeroFluxNeumannBoundaryConditionIUS2 = itk::ZeroFluxNeumannBoundaryCondition< itk::Image< unsigned short,2 > >;
using itkZeroFluxNeumannBoundaryConditionIUS3 = itk::ZeroFluxNeumannBoundaryCondition< itk::Image< unsigned short,3 > >;
using itkZeroFluxNeumannBoundaryConditionIUS4 = itk::ZeroFluxNeumannBoundaryCondition< itk::Image< unsigned short,4 > >;
using itkZeroFluxNeumannBoundaryConditionIF2 = itk::ZeroFluxNeumannBoundaryCondition< itk::Image< float,2 > >;
using itkZeroFluxNeumannBoundaryConditionIF3 = itk::ZeroFluxNeumannBoundaryCondition< itk::Image< float,3 > >;
using itkZeroFluxNeumannBoundaryConditionIF4 = itk::ZeroFluxNeumannBoundaryCondition< itk::Image< float,4 > >;
using itkZeroFluxNeumannBoundaryConditionID2 = itk::ZeroFluxNeumannBoundaryCondition< itk::Image< double,2 > >;
using itkZeroFluxNeumannBoundaryConditionID3 = itk::ZeroFluxNeumannBoundaryCondition< itk::Image< double,3 > >;
using itkZeroFluxNeumannBoundaryConditionID4 = itk::ZeroFluxNeumannBoundaryCondition< itk::Image< double,4 > >;
using itkZeroFluxNeumannBoundaryConditionICD2 = itk::ZeroFluxNeumannBoundaryCondition< itk::Image< std::complex< double >,2 > >;
using itkZeroFluxNeumannBoundaryConditionICD3 = itk::ZeroFluxNeumannBoundaryCondition< itk::Image< std::complex< double >,3 > >;
using itkZeroFluxNeumannBoundaryConditionICD4 = itk::ZeroFluxNeumannBoundaryCondition< itk::Image< std::complex< double >,4 > >;
using itkZeroFluxNeumannBoundaryConditionICF2 = itk::ZeroFluxNeumannBoundaryCondition< itk::Image< std::complex< float >,2 > >;
using itkZeroFluxNeumannBoundaryConditionICF3 = itk::ZeroFluxNeumannBoundaryCondition< itk::Image< std::complex< float >,3 > >;
using itkZeroFluxNeumannBoundaryConditionICF4 = itk::ZeroFluxNeumannBoundaryCondition< itk::Image< std::complex< float >,4 > >;
using itkConstantBoundaryConditionIRGBUC2 = itk::ConstantBoundaryCondition< itk::Image< itk::RGBPixel< unsigned char >,2 > >;
using itkConstantBoundaryConditionIRGBUC3 = itk::ConstantBoundaryCondition< itk::Image< itk::RGBPixel< unsigned char >,3 > >;
using itkConstantBoundaryConditionIRGBUC4 = itk::ConstantBoundaryCondition< itk::Image< itk::RGBPixel< unsigned char >,4 > >;
using itkConstantBoundaryConditionIRGBUS2 = itk::ConstantBoundaryCondition< itk::Image< itk::RGBPixel< unsigned short >,2 > >;
using itkConstantBoundaryConditionIRGBUS3 = itk::ConstantBoundaryCondition< itk::Image< itk::RGBPixel< unsigned short >,3 > >;
using itkConstantBoundaryConditionIRGBUS4 = itk::ConstantBoundaryCondition< itk::Image< itk::RGBPixel< unsigned short >,4 > >;
using itkConstantBoundaryConditionIRGBAUC2 = itk::ConstantBoundaryCondition< itk::Image< itk::RGBAPixel< unsigned char >,2 > >;
using itkConstantBoundaryConditionIRGBAUC3 = itk::ConstantBoundaryCondition< itk::Image< itk::RGBAPixel< unsigned char >,3 > >;
using itkConstantBoundaryConditionIRGBAUC4 = itk::ConstantBoundaryCondition< itk::Image< itk::RGBAPixel< unsigned char >,4 > >;
using itkConstantBoundaryConditionIRGBAUS2 = itk::ConstantBoundaryCondition< itk::Image< itk::RGBAPixel< unsigned short >,2 > >;
using itkConstantBoundaryConditionIRGBAUS3 = itk::ConstantBoundaryCondition< itk::Image< itk::RGBAPixel< unsigned short >,3 > >;
using itkConstantBoundaryConditionIRGBAUS4 = itk::ConstantBoundaryCondition< itk::Image< itk::RGBAPixel< unsigned short >,4 > >;
using itkConstantBoundaryConditionIVD22 = itk::ConstantBoundaryCondition< itk::Image< itk::Vector< double,2 >,2 > >;
using itkConstantBoundaryConditionIVD23 = itk::ConstantBoundaryCondition< itk::Image< itk::Vector< double,2 >,3 > >;
using itkConstantBoundaryConditionIVD24 = itk::ConstantBoundaryCondition< itk::Image< itk::Vector< double,2 >,4 > >;
using itkConstantBoundaryConditionIVD32 = itk::ConstantBoundaryCondition< itk::Image< itk::Vector< double,3 >,2 > >;
using itkConstantBoundaryConditionIVD33 = itk::ConstantBoundaryCondition< itk::Image< itk::Vector< double,3 >,3 > >;
using itkConstantBoundaryConditionIVD34 = itk::ConstantBoundaryCondition< itk::Image< itk::Vector< double,3 >,4 > >;
using itkConstantBoundaryConditionIVD42 = itk::ConstantBoundaryCondition< itk::Image< itk::Vector< double,4 >,2 > >;
using itkConstantBoundaryConditionIVD43 = itk::ConstantBoundaryCondition< itk::Image< itk::Vector< double,4 >,3 > >;
using itkConstantBoundaryConditionIVD44 = itk::ConstantBoundaryCondition< itk::Image< itk::Vector< double,4 >,4 > >;
using itkConstantBoundaryConditionIVF22 = itk::ConstantBoundaryCondition< itk::Image< itk::Vector< float,2 >,2 > >;
using itkConstantBoundaryConditionIVF23 = itk::ConstantBoundaryCondition< itk::Image< itk::Vector< float,2 >,3 > >;
using itkConstantBoundaryConditionIVF24 = itk::ConstantBoundaryCondition< itk::Image< itk::Vector< float,2 >,4 > >;
using itkConstantBoundaryConditionIVF32 = itk::ConstantBoundaryCondition< itk::Image< itk::Vector< float,3 >,2 > >;
using itkConstantBoundaryConditionIVF33 = itk::ConstantBoundaryCondition< itk::Image< itk::Vector< float,3 >,3 > >;
using itkConstantBoundaryConditionIVF34 = itk::ConstantBoundaryCondition< itk::Image< itk::Vector< float,3 >,4 > >;
using itkConstantBoundaryConditionIVF42 = itk::ConstantBoundaryCondition< itk::Image< itk::Vector< float,4 >,2 > >;
using itkConstantBoundaryConditionIVF43 = itk::ConstantBoundaryCondition< itk::Image< itk::Vector< float,4 >,3 > >;
using itkConstantBoundaryConditionIVF44 = itk::ConstantBoundaryCondition< itk::Image< itk::Vector< float,4 >,4 > >;
using itkConstantBoundaryConditionICVD22 = itk::ConstantBoundaryCondition< itk::Image< itk::CovariantVector< double,2 >,2 > >;
using itkConstantBoundaryConditionICVD23 = itk::ConstantBoundaryCondition< itk::Image< itk::CovariantVector< double,2 >,3 > >;
using itkConstantBoundaryConditionICVD24 = itk::ConstantBoundaryCondition< itk::Image< itk::CovariantVector< double,2 >,4 > >;
using itkConstantBoundaryConditionICVD32 = itk::ConstantBoundaryCondition< itk::Image< itk::CovariantVector< double,3 >,2 > >;
using itkConstantBoundaryConditionICVD33 = itk::ConstantBoundaryCondition< itk::Image< itk::CovariantVector< double,3 >,3 > >;
using itkConstantBoundaryConditionICVD34 = itk::ConstantBoundaryCondition< itk::Image< itk::CovariantVector< double,3 >,4 > >;
using itkConstantBoundaryConditionICVD42 = itk::ConstantBoundaryCondition< itk::Image< itk::CovariantVector< double,4 >,2 > >;
using itkConstantBoundaryConditionICVD43 = itk::ConstantBoundaryCondition< itk::Image< itk::CovariantVector< double,4 >,3 > >;
using itkConstantBoundaryConditionICVD44 = itk::ConstantBoundaryCondition< itk::Image< itk::CovariantVector< double,4 >,4 > >;
using itkConstantBoundaryConditionICVF22 = itk::ConstantBoundaryCondition< itk::Image< itk::CovariantVector< float,2 >,2 > >;
using itkConstantBoundaryConditionICVF23 = itk::ConstantBoundaryCondition< itk::Image< itk::CovariantVector< float,2 >,3 > >;
using itkConstantBoundaryConditionICVF24 = itk::ConstantBoundaryCondition< itk::Image< itk::CovariantVector< float,2 >,4 > >;
using itkConstantBoundaryConditionICVF32 = itk::ConstantBoundaryCondition< itk::Image< itk::CovariantVector< float,3 >,2 > >;
using itkConstantBoundaryConditionICVF33 = itk::ConstantBoundaryCondition< itk::Image< itk::CovariantVector< float,3 >,3 > >;
using itkConstantBoundaryConditionICVF34 = itk::ConstantBoundaryCondition< itk::Image< itk::CovariantVector< float,3 >,4 > >;
using itkConstantBoundaryConditionICVF42 = itk::ConstantBoundaryCondition< itk::Image< itk::CovariantVector< float,4 >,2 > >;
using itkConstantBoundaryConditionICVF43 = itk::ConstantBoundaryCondition< itk::Image< itk::CovariantVector< float,4 >,3 > >;
using itkConstantBoundaryConditionICVF44 = itk::ConstantBoundaryCondition< itk::Image< itk::CovariantVector< float,4 >,4 > >;
using itkConstantBoundaryConditionISC2 = itk::ConstantBoundaryCondition< itk::Image< signed char,2 > >;
using itkConstantBoundaryConditionISC3 = itk::ConstantBoundaryCondition< itk::Image< signed char,3 > >;
using itkConstantBoundaryConditionISC4 = itk::ConstantBoundaryCondition< itk::Image< signed char,4 > >;
using itkConstantBoundaryConditionISS2 = itk::ConstantBoundaryCondition< itk::Image< signed short,2 > >;
using itkConstantBoundaryConditionISS3 = itk::ConstantBoundaryCondition< itk::Image< signed short,3 > >;
using itkConstantBoundaryConditionISS4 = itk::ConstantBoundaryCondition< itk::Image< signed short,4 > >;
using itkConstantBoundaryConditionIUC2 = itk::ConstantBoundaryCondition< itk::Image< unsigned char,2 > >;
using itkConstantBoundaryConditionIUC3 = itk::ConstantBoundaryCondition< itk::Image< unsigned char,3 > >;
using itkConstantBoundaryConditionIUC4 = itk::ConstantBoundaryCondition< itk::Image< unsigned char,4 > >;
using itkConstantBoundaryConditionIULL2 = itk::ConstantBoundaryCondition< itk::Image< unsigned long long,2 > >;
using itkConstantBoundaryConditionIULL3 = itk::ConstantBoundaryCondition< itk::Image< unsigned long long,3 > >;
using itkConstantBoundaryConditionIULL4 = itk::ConstantBoundaryCondition< itk::Image< unsigned long long,4 > >;
using itkConstantBoundaryConditionIUS2 = itk::ConstantBoundaryCondition< itk::Image< unsigned short,2 > >;
using itkConstantBoundaryConditionIUS3 = itk::ConstantBoundaryCondition< itk::Image< unsigned short,3 > >;
using itkConstantBoundaryConditionIUS4 = itk::ConstantBoundaryCondition< itk::Image< unsigned short,4 > >;
using itkConstantBoundaryConditionIF2 = itk::ConstantBoundaryCondition< itk::Image< float,2 > >;
using itkConstantBoundaryConditionIF3 = itk::ConstantBoundaryCondition< itk::Image< float,3 > >;
using itkConstantBoundaryConditionIF4 = itk::ConstantBoundaryCondition< itk::Image< float,4 > >;
using itkConstantBoundaryConditionID2 = itk::ConstantBoundaryCondition< itk::Image< double,2 > >;
using itkConstantBoundaryConditionID3 = itk::ConstantBoundaryCondition< itk::Image< double,3 > >;
using itkConstantBoundaryConditionID4 = itk::ConstantBoundaryCondition< itk::Image< double,4 > >;
using itkConstantBoundaryConditionICD2 = itk::ConstantBoundaryCondition< itk::Image< std::complex< double >,2 > >;
using itkConstantBoundaryConditionICD3 = itk::ConstantBoundaryCondition< itk::Image< std::complex< double >,3 > >;
using itkConstantBoundaryConditionICD4 = itk::ConstantBoundaryCondition< itk::Image< std::complex< double >,4 > >;
using itkConstantBoundaryConditionICF2 = itk::ConstantBoundaryCondition< itk::Image< std::complex< float >,2 > >;
using itkConstantBoundaryConditionICF3 = itk::ConstantBoundaryCondition< itk::Image< std::complex< float >,3 > >;
using itkConstantBoundaryConditionICF4 = itk::ConstantBoundaryCondition< itk::Image< std::complex< float >,4 > >;


#include "stdcomplexSwigInterface.h"
#include "ITKCommonBaseSwigInterface.h"
#include "itkImageSwigInterface.h"
#include "itkVectorSwigInterface.h"
#include "itkImageRegionSwigInterface.h"
#include "itkRGBPixelSwigInterface.h"
#include "itkCovariantVectorSwigInterface.h"
#include "itkOffsetSwigInterface.h"
#include "itkImageBoundaryConditionSwigInterface.h"
#include "itkIndexSwigInterface.h"
#include "itkRGBAPixelSwigInterface.h"
#endif
