#define XERR
#include "modules.ih"

bool Modules::showDeps()
{
    if (not d_dependencies)
        return false;

    fillModIdx();

    for (Data const &data: d_modules)
    {
        cout << col2hyphen(data.modName) << ':';
        if (data.idx == -1)                 // external module
            cout << 'e';
        else if (data.orgImports.empty())
            cout << 'l';
        else 
        {
            Set allDeps;
            addImports(allDeps, data);

            for (string const &name: allDeps)
                cout << ' ' << col2hyphen(name) <<
                    (
                        d_modules[d_modIdx[name]].idx == -1 ?
                            ":e"
                        :
                            " "
                    );
        }
        cout << '\n';
    }

    return true;
}
