{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Generated during DND operations.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gdk.Structs.EventDND
    ( 

-- * Exported types
    EventDND(..)                            ,
    newZeroEventDND                         ,


 -- * Methods

#if defined(ENABLE_OVERLOADING)
    ResolveEventDNDMethod                   ,
#endif



 -- * Properties


-- ** context #attr:context#
-- | the t'GI.Gdk.Objects.DragContext.DragContext' for the current DND operation.

    clearEventDNDContext                    ,
#if defined(ENABLE_OVERLOADING)
    eventDND_context                        ,
#endif
    getEventDNDContext                      ,
    setEventDNDContext                      ,


-- ** sendEvent #attr:sendEvent#
-- | 'P.True' if the event was sent explicitly.

#if defined(ENABLE_OVERLOADING)
    eventDND_sendEvent                      ,
#endif
    getEventDNDSendEvent                    ,
    setEventDNDSendEvent                    ,


-- ** time #attr:time#
-- | the time of the event in milliseconds.

#if defined(ENABLE_OVERLOADING)
    eventDND_time                           ,
#endif
    getEventDNDTime                         ,
    setEventDNDTime                         ,


-- ** type #attr:type#
-- | the type of the event ('GI.Gdk.Enums.EventTypeDragEnter', 'GI.Gdk.Enums.EventTypeDragLeave',
--   'GI.Gdk.Enums.EventTypeDragMotion', 'GI.Gdk.Enums.EventTypeDragStatus', 'GI.Gdk.Enums.EventTypeDropStart' or
--   'GI.Gdk.Enums.EventTypeDropFinished').

#if defined(ENABLE_OVERLOADING)
    eventDND_type                           ,
#endif
    getEventDNDType                         ,
    setEventDNDType                         ,


-- ** window #attr:window#
-- | the window which received the event.

    clearEventDNDWindow                     ,
#if defined(ENABLE_OVERLOADING)
    eventDND_window                         ,
#endif
    getEventDNDWindow                       ,
    setEventDNDWindow                       ,


-- ** xRoot #attr:xRoot#
-- | the x coordinate of the pointer relative to the root of the
--   screen, only set for 'GI.Gdk.Enums.EventTypeDragMotion' and 'GI.Gdk.Enums.EventTypeDropStart'.

#if defined(ENABLE_OVERLOADING)
    eventDND_xRoot                          ,
#endif
    getEventDNDXRoot                        ,
    setEventDNDXRoot                        ,


-- ** yRoot #attr:yRoot#
-- | the y coordinate of the pointer relative to the root of the
--   screen, only set for 'GI.Gdk.Enums.EventTypeDragMotion' and 'GI.Gdk.Enums.EventTypeDropStart'.

#if defined(ENABLE_OVERLOADING)
    eventDND_yRoot                          ,
#endif
    getEventDNDYRoot                        ,
    setEventDNDYRoot                        ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Enums as Cairo.Enums
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.Cairo.Structs.FontOptions as Cairo.FontOptions
import qualified GI.Cairo.Structs.Pattern as Cairo.Pattern
import qualified GI.Cairo.Structs.Region as Cairo.Region
import qualified GI.Cairo.Structs.Surface as Cairo.Surface
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Callbacks as Gdk.Callbacks
import {-# SOURCE #-} qualified GI.Gdk.Enums as Gdk.Enums
import {-# SOURCE #-} qualified GI.Gdk.Flags as Gdk.Flags
import {-# SOURCE #-} qualified GI.Gdk.Objects.AppLaunchContext as Gdk.AppLaunchContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.Cursor as Gdk.Cursor
import {-# SOURCE #-} qualified GI.Gdk.Objects.Device as Gdk.Device
import {-# SOURCE #-} qualified GI.Gdk.Objects.DeviceManager as Gdk.DeviceManager
import {-# SOURCE #-} qualified GI.Gdk.Objects.DeviceTool as Gdk.DeviceTool
import {-# SOURCE #-} qualified GI.Gdk.Objects.Display as Gdk.Display
import {-# SOURCE #-} qualified GI.Gdk.Objects.DragContext as Gdk.DragContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.DrawingContext as Gdk.DrawingContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.FrameClock as Gdk.FrameClock
import {-# SOURCE #-} qualified GI.Gdk.Objects.GLContext as Gdk.GLContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.Monitor as Gdk.Monitor
import {-# SOURCE #-} qualified GI.Gdk.Objects.Screen as Gdk.Screen
import {-# SOURCE #-} qualified GI.Gdk.Objects.Seat as Gdk.Seat
import {-# SOURCE #-} qualified GI.Gdk.Objects.Visual as Gdk.Visual
import {-# SOURCE #-} qualified GI.Gdk.Objects.Window as Gdk.Window
import {-# SOURCE #-} qualified GI.Gdk.Structs.Atom as Gdk.Atom
import {-# SOURCE #-} qualified GI.Gdk.Structs.Color as Gdk.Color
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventAny as Gdk.EventAny
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventButton as Gdk.EventButton
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventConfigure as Gdk.EventConfigure
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventCrossing as Gdk.EventCrossing
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventExpose as Gdk.EventExpose
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventFocus as Gdk.EventFocus
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventGrabBroken as Gdk.EventGrabBroken
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventKey as Gdk.EventKey
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventMotion as Gdk.EventMotion
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventOwnerChange as Gdk.EventOwnerChange
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventPadAxis as Gdk.EventPadAxis
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventPadButton as Gdk.EventPadButton
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventPadGroupMode as Gdk.EventPadGroupMode
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventProperty as Gdk.EventProperty
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventProximity as Gdk.EventProximity
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventScroll as Gdk.EventScroll
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventSelection as Gdk.EventSelection
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventSequence as Gdk.EventSequence
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventSetting as Gdk.EventSetting
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventTouch as Gdk.EventTouch
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventTouchpadPinch as Gdk.EventTouchpadPinch
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventTouchpadSwipe as Gdk.EventTouchpadSwipe
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventVisibility as Gdk.EventVisibility
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventWindowState as Gdk.EventWindowState
import {-# SOURCE #-} qualified GI.Gdk.Structs.FrameTimings as Gdk.FrameTimings
import {-# SOURCE #-} qualified GI.Gdk.Structs.Geometry as Gdk.Geometry
import {-# SOURCE #-} qualified GI.Gdk.Structs.RGBA as Gdk.RGBA
import {-# SOURCE #-} qualified GI.Gdk.Structs.Rectangle as Gdk.Rectangle
import {-# SOURCE #-} qualified GI.Gdk.Structs.WindowAttr as Gdk.WindowAttr
import {-# SOURCE #-} qualified GI.Gdk.Unions.Event as Gdk.Event
import qualified GI.GdkPixbuf.Objects.Pixbuf as GdkPixbuf.Pixbuf
import qualified GI.Gio.Interfaces.Icon as Gio.Icon
import qualified GI.Gio.Objects.AppLaunchContext as Gio.AppLaunchContext

#else
import {-# SOURCE #-} qualified GI.Gdk.Enums as Gdk.Enums
import {-# SOURCE #-} qualified GI.Gdk.Objects.DragContext as Gdk.DragContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.Window as Gdk.Window

#endif

-- | Memory-managed wrapper type.
newtype EventDND = EventDND (SP.ManagedPtr EventDND)
    deriving (Eq)

instance SP.ManagedPtrNewtype EventDND where
    toManagedPtr (EventDND p) = p

instance BoxedPtr EventDND where
    boxedPtrCopy = \p -> B.ManagedPtr.withManagedPtr p (copyBytes 40 >=> B.ManagedPtr.wrapPtr EventDND)
    boxedPtrFree = \x -> SP.withManagedPtr x SP.freeMem
instance CallocPtr EventDND where
    boxedPtrCalloc = callocBytes 40


-- | Construct a t'EventDND' struct initialized to zero.
newZeroEventDND :: MonadIO m => m EventDND
newZeroEventDND = liftIO $ boxedPtrCalloc >>= wrapPtr EventDND

instance tag ~ 'AttrSet => Constructible EventDND tag where
    new _ attrs = do
        o <- newZeroEventDND
        GI.Attributes.set o attrs
        return o


-- | Get the value of the “@type@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' eventDND #type
-- @
getEventDNDType :: MonadIO m => EventDND -> m Gdk.Enums.EventType
getEventDNDType s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 0) :: IO CInt
    let val' = (toEnum . fromIntegral) val
    return val'

-- | Set the value of the “@type@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' eventDND [ #type 'Data.GI.Base.Attributes.:=' value ]
-- @
setEventDNDType :: MonadIO m => EventDND -> Gdk.Enums.EventType -> m ()
setEventDNDType s val = liftIO $ withManagedPtr s $ \ptr -> do
    let val' = (fromIntegral . fromEnum) val
    poke (ptr `plusPtr` 0) (val' :: CInt)

#if defined(ENABLE_OVERLOADING)
data EventDNDTypeFieldInfo
instance AttrInfo EventDNDTypeFieldInfo where
    type AttrBaseTypeConstraint EventDNDTypeFieldInfo = (~) EventDND
    type AttrAllowedOps EventDNDTypeFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint EventDNDTypeFieldInfo = (~) Gdk.Enums.EventType
    type AttrTransferTypeConstraint EventDNDTypeFieldInfo = (~)Gdk.Enums.EventType
    type AttrTransferType EventDNDTypeFieldInfo = Gdk.Enums.EventType
    type AttrGetType EventDNDTypeFieldInfo = Gdk.Enums.EventType
    type AttrLabel EventDNDTypeFieldInfo = "type"
    type AttrOrigin EventDNDTypeFieldInfo = EventDND
    attrGet = getEventDNDType
    attrSet = setEventDNDType
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.EventDND.type"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Structs-EventDND.html#g:attr:type"
        })

eventDND_type :: AttrLabelProxy "type"
eventDND_type = AttrLabelProxy

#endif


-- | Get the value of the “@window@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' eventDND #window
-- @
getEventDNDWindow :: MonadIO m => EventDND -> m (Maybe Gdk.Window.Window)
getEventDNDWindow s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 8) :: IO (Ptr Gdk.Window.Window)
    result <- SP.convertIfNonNull val $ \val' -> do
        val'' <- (newObject Gdk.Window.Window) val'
        return val''
    return result

-- | Set the value of the “@window@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' eventDND [ #window 'Data.GI.Base.Attributes.:=' value ]
-- @
setEventDNDWindow :: MonadIO m => EventDND -> Ptr Gdk.Window.Window -> m ()
setEventDNDWindow s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 8) (val :: Ptr Gdk.Window.Window)

-- | Set the value of the “@window@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #window
-- @
clearEventDNDWindow :: MonadIO m => EventDND -> m ()
clearEventDNDWindow s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 8) (FP.nullPtr :: Ptr Gdk.Window.Window)

#if defined(ENABLE_OVERLOADING)
data EventDNDWindowFieldInfo
instance AttrInfo EventDNDWindowFieldInfo where
    type AttrBaseTypeConstraint EventDNDWindowFieldInfo = (~) EventDND
    type AttrAllowedOps EventDNDWindowFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint EventDNDWindowFieldInfo = (~) (Ptr Gdk.Window.Window)
    type AttrTransferTypeConstraint EventDNDWindowFieldInfo = (~)(Ptr Gdk.Window.Window)
    type AttrTransferType EventDNDWindowFieldInfo = (Ptr Gdk.Window.Window)
    type AttrGetType EventDNDWindowFieldInfo = Maybe Gdk.Window.Window
    type AttrLabel EventDNDWindowFieldInfo = "window"
    type AttrOrigin EventDNDWindowFieldInfo = EventDND
    attrGet = getEventDNDWindow
    attrSet = setEventDNDWindow
    attrConstruct = undefined
    attrClear = clearEventDNDWindow
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.EventDND.window"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Structs-EventDND.html#g:attr:window"
        })

eventDND_window :: AttrLabelProxy "window"
eventDND_window = AttrLabelProxy

#endif


-- | Get the value of the “@send_event@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' eventDND #sendEvent
-- @
getEventDNDSendEvent :: MonadIO m => EventDND -> m Int8
getEventDNDSendEvent s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 16) :: IO Int8
    return val

-- | Set the value of the “@send_event@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' eventDND [ #sendEvent 'Data.GI.Base.Attributes.:=' value ]
-- @
setEventDNDSendEvent :: MonadIO m => EventDND -> Int8 -> m ()
setEventDNDSendEvent s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 16) (val :: Int8)

#if defined(ENABLE_OVERLOADING)
data EventDNDSendEventFieldInfo
instance AttrInfo EventDNDSendEventFieldInfo where
    type AttrBaseTypeConstraint EventDNDSendEventFieldInfo = (~) EventDND
    type AttrAllowedOps EventDNDSendEventFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint EventDNDSendEventFieldInfo = (~) Int8
    type AttrTransferTypeConstraint EventDNDSendEventFieldInfo = (~)Int8
    type AttrTransferType EventDNDSendEventFieldInfo = Int8
    type AttrGetType EventDNDSendEventFieldInfo = Int8
    type AttrLabel EventDNDSendEventFieldInfo = "send_event"
    type AttrOrigin EventDNDSendEventFieldInfo = EventDND
    attrGet = getEventDNDSendEvent
    attrSet = setEventDNDSendEvent
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.EventDND.sendEvent"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Structs-EventDND.html#g:attr:sendEvent"
        })

eventDND_sendEvent :: AttrLabelProxy "sendEvent"
eventDND_sendEvent = AttrLabelProxy

#endif


-- | Get the value of the “@context@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' eventDND #context
-- @
getEventDNDContext :: MonadIO m => EventDND -> m (Maybe Gdk.DragContext.DragContext)
getEventDNDContext s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 24) :: IO (Ptr Gdk.DragContext.DragContext)
    result <- SP.convertIfNonNull val $ \val' -> do
        val'' <- (newObject Gdk.DragContext.DragContext) val'
        return val''
    return result

-- | Set the value of the “@context@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' eventDND [ #context 'Data.GI.Base.Attributes.:=' value ]
-- @
setEventDNDContext :: MonadIO m => EventDND -> Ptr Gdk.DragContext.DragContext -> m ()
setEventDNDContext s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 24) (val :: Ptr Gdk.DragContext.DragContext)

-- | Set the value of the “@context@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #context
-- @
clearEventDNDContext :: MonadIO m => EventDND -> m ()
clearEventDNDContext s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 24) (FP.nullPtr :: Ptr Gdk.DragContext.DragContext)

#if defined(ENABLE_OVERLOADING)
data EventDNDContextFieldInfo
instance AttrInfo EventDNDContextFieldInfo where
    type AttrBaseTypeConstraint EventDNDContextFieldInfo = (~) EventDND
    type AttrAllowedOps EventDNDContextFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint EventDNDContextFieldInfo = (~) (Ptr Gdk.DragContext.DragContext)
    type AttrTransferTypeConstraint EventDNDContextFieldInfo = (~)(Ptr Gdk.DragContext.DragContext)
    type AttrTransferType EventDNDContextFieldInfo = (Ptr Gdk.DragContext.DragContext)
    type AttrGetType EventDNDContextFieldInfo = Maybe Gdk.DragContext.DragContext
    type AttrLabel EventDNDContextFieldInfo = "context"
    type AttrOrigin EventDNDContextFieldInfo = EventDND
    attrGet = getEventDNDContext
    attrSet = setEventDNDContext
    attrConstruct = undefined
    attrClear = clearEventDNDContext
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.EventDND.context"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Structs-EventDND.html#g:attr:context"
        })

eventDND_context :: AttrLabelProxy "context"
eventDND_context = AttrLabelProxy

#endif


-- | Get the value of the “@time@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' eventDND #time
-- @
getEventDNDTime :: MonadIO m => EventDND -> m Word32
getEventDNDTime s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 32) :: IO Word32
    return val

-- | Set the value of the “@time@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' eventDND [ #time 'Data.GI.Base.Attributes.:=' value ]
-- @
setEventDNDTime :: MonadIO m => EventDND -> Word32 -> m ()
setEventDNDTime s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 32) (val :: Word32)

#if defined(ENABLE_OVERLOADING)
data EventDNDTimeFieldInfo
instance AttrInfo EventDNDTimeFieldInfo where
    type AttrBaseTypeConstraint EventDNDTimeFieldInfo = (~) EventDND
    type AttrAllowedOps EventDNDTimeFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint EventDNDTimeFieldInfo = (~) Word32
    type AttrTransferTypeConstraint EventDNDTimeFieldInfo = (~)Word32
    type AttrTransferType EventDNDTimeFieldInfo = Word32
    type AttrGetType EventDNDTimeFieldInfo = Word32
    type AttrLabel EventDNDTimeFieldInfo = "time"
    type AttrOrigin EventDNDTimeFieldInfo = EventDND
    attrGet = getEventDNDTime
    attrSet = setEventDNDTime
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.EventDND.time"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Structs-EventDND.html#g:attr:time"
        })

eventDND_time :: AttrLabelProxy "time"
eventDND_time = AttrLabelProxy

#endif


-- | Get the value of the “@x_root@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' eventDND #xRoot
-- @
getEventDNDXRoot :: MonadIO m => EventDND -> m FCT.CShort
getEventDNDXRoot s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 36) :: IO FCT.CShort
    return val

-- | Set the value of the “@x_root@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' eventDND [ #xRoot 'Data.GI.Base.Attributes.:=' value ]
-- @
setEventDNDXRoot :: MonadIO m => EventDND -> FCT.CShort -> m ()
setEventDNDXRoot s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 36) (val :: FCT.CShort)

#if defined(ENABLE_OVERLOADING)
data EventDNDXRootFieldInfo
instance AttrInfo EventDNDXRootFieldInfo where
    type AttrBaseTypeConstraint EventDNDXRootFieldInfo = (~) EventDND
    type AttrAllowedOps EventDNDXRootFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint EventDNDXRootFieldInfo = (~) FCT.CShort
    type AttrTransferTypeConstraint EventDNDXRootFieldInfo = (~)FCT.CShort
    type AttrTransferType EventDNDXRootFieldInfo = FCT.CShort
    type AttrGetType EventDNDXRootFieldInfo = FCT.CShort
    type AttrLabel EventDNDXRootFieldInfo = "x_root"
    type AttrOrigin EventDNDXRootFieldInfo = EventDND
    attrGet = getEventDNDXRoot
    attrSet = setEventDNDXRoot
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.EventDND.xRoot"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Structs-EventDND.html#g:attr:xRoot"
        })

eventDND_xRoot :: AttrLabelProxy "xRoot"
eventDND_xRoot = AttrLabelProxy

#endif


-- | Get the value of the “@y_root@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' eventDND #yRoot
-- @
getEventDNDYRoot :: MonadIO m => EventDND -> m FCT.CShort
getEventDNDYRoot s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 38) :: IO FCT.CShort
    return val

-- | Set the value of the “@y_root@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' eventDND [ #yRoot 'Data.GI.Base.Attributes.:=' value ]
-- @
setEventDNDYRoot :: MonadIO m => EventDND -> FCT.CShort -> m ()
setEventDNDYRoot s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 38) (val :: FCT.CShort)

#if defined(ENABLE_OVERLOADING)
data EventDNDYRootFieldInfo
instance AttrInfo EventDNDYRootFieldInfo where
    type AttrBaseTypeConstraint EventDNDYRootFieldInfo = (~) EventDND
    type AttrAllowedOps EventDNDYRootFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint EventDNDYRootFieldInfo = (~) FCT.CShort
    type AttrTransferTypeConstraint EventDNDYRootFieldInfo = (~)FCT.CShort
    type AttrTransferType EventDNDYRootFieldInfo = FCT.CShort
    type AttrGetType EventDNDYRootFieldInfo = FCT.CShort
    type AttrLabel EventDNDYRootFieldInfo = "y_root"
    type AttrOrigin EventDNDYRootFieldInfo = EventDND
    attrGet = getEventDNDYRoot
    attrSet = setEventDNDYRoot
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.EventDND.yRoot"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Structs-EventDND.html#g:attr:yRoot"
        })

eventDND_yRoot :: AttrLabelProxy "yRoot"
eventDND_yRoot = AttrLabelProxy

#endif



#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList EventDND
type instance O.AttributeList EventDND = EventDNDAttributeList
type EventDNDAttributeList = ('[ '("type", EventDNDTypeFieldInfo), '("window", EventDNDWindowFieldInfo), '("sendEvent", EventDNDSendEventFieldInfo), '("context", EventDNDContextFieldInfo), '("time", EventDNDTimeFieldInfo), '("xRoot", EventDNDXRootFieldInfo), '("yRoot", EventDNDYRootFieldInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveEventDNDMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveEventDNDMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveEventDNDMethod t EventDND, O.OverloadedMethod info EventDND p) => OL.IsLabel t (EventDND -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveEventDNDMethod t EventDND, O.OverloadedMethod info EventDND p, R.HasField t EventDND p) => R.HasField t EventDND p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveEventDNDMethod t EventDND, O.OverloadedMethodInfo info EventDND) => OL.IsLabel t (O.MethodProxy info EventDND) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


