/* score-dialog.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from score-dialog.vala, do not modify */

/* SPDX-FileCopyrightText: 2010-2025 Mahjongg Contributors*/
/* SPDX-FileCopyrightText: 2010-2013 Robert Ancell*/
/* SPDX-License-Identifier: GPL-2.0-or-later*/

#include <adwaita.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib/gi18n-lib.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_SCORE_DIALOG (score_dialog_get_type ())
#define SCORE_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCORE_DIALOG, ScoreDialog))
#define SCORE_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCORE_DIALOG, ScoreDialogClass))
#define IS_SCORE_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCORE_DIALOG))
#define IS_SCORE_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCORE_DIALOG))
#define SCORE_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCORE_DIALOG, ScoreDialogClass))

typedef struct _ScoreDialog ScoreDialog;
typedef struct _ScoreDialogClass ScoreDialogClass;
typedef struct _ScoreDialogPrivate ScoreDialogPrivate;

#define TYPE_HISTORY (history_get_type ())
#define HISTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_HISTORY, History))
#define HISTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_HISTORY, HistoryClass))
#define IS_HISTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_HISTORY))
#define IS_HISTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_HISTORY))
#define HISTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_HISTORY, HistoryClass))

typedef struct _History History;
typedef struct _HistoryClass HistoryClass;

#define TYPE_HISTORY_ENTRY (history_entry_get_type ())
#define HISTORY_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_HISTORY_ENTRY, HistoryEntry))
#define HISTORY_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_HISTORY_ENTRY, HistoryEntryClass))
#define IS_HISTORY_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_HISTORY_ENTRY))
#define IS_HISTORY_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_HISTORY_ENTRY))
#define HISTORY_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_HISTORY_ENTRY, HistoryEntryClass))

typedef struct _HistoryEntry HistoryEntry;
typedef struct _HistoryEntryClass HistoryEntryClass;

#define TYPE_MAPS (maps_get_type ())
#define MAPS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAPS, Maps))
#define MAPS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAPS, MapsClass))
#define IS_MAPS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAPS))
#define IS_MAPS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAPS))
#define MAPS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAPS, MapsClass))

typedef struct _Maps Maps;
typedef struct _MapsClass MapsClass;
enum  {
	SCORE_DIALOG_0_PROPERTY,
	SCORE_DIALOG_NUM_PROPERTIES
};
static GParamSpec* score_dialog_properties[SCORE_DIALOG_NUM_PROPERTIES];
#define _history_unref0(var) ((var == NULL) ? NULL : (var = (history_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _maps_unref0(var) ((var == NULL) ? NULL : (var = (maps_unref (var), NULL)))
typedef struct _HistoryEntryPrivate HistoryEntryPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))

#define MAPS_TYPE_ITERATOR (maps_iterator_get_type ())
#define MAPS_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MAPS_TYPE_ITERATOR, MapsIterator))
#define MAPS_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MAPS_TYPE_ITERATOR, MapsIteratorClass))
#define MAPS_IS_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MAPS_TYPE_ITERATOR))
#define MAPS_IS_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MAPS_TYPE_ITERATOR))
#define MAPS_ITERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MAPS_TYPE_ITERATOR, MapsIteratorClass))

typedef struct _MapsIterator MapsIterator;
typedef struct _MapsIteratorClass MapsIteratorClass;

#define TYPE_MAP (map_get_type ())
#define MAP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAP, Map))
#define MAP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAP, MapClass))
#define IS_MAP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAP))
#define IS_MAP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAP))
#define MAP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAP, MapClass))

typedef struct _Map Map;
typedef struct _MapClass MapClass;
typedef struct _MapPrivate MapPrivate;
#define _maps_iterator_unref0(var) ((var == NULL) ? NULL : (var = (maps_iterator_unref (var), NULL)))

#define HISTORY_TYPE_ITERATOR (history_iterator_get_type ())
#define HISTORY_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), HISTORY_TYPE_ITERATOR, HistoryIterator))
#define HISTORY_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), HISTORY_TYPE_ITERATOR, HistoryIteratorClass))
#define HISTORY_IS_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), HISTORY_TYPE_ITERATOR))
#define HISTORY_IS_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), HISTORY_TYPE_ITERATOR))
#define HISTORY_ITERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), HISTORY_TYPE_ITERATOR, HistoryIteratorClass))

typedef struct _HistoryIterator HistoryIterator;
typedef struct _HistoryIteratorClass HistoryIteratorClass;
#define _history_iterator_unref0(var) ((var == NULL) ? NULL : (var = (history_iterator_unref (var), NULL)))
typedef struct _Block1Data Block1Data;
typedef struct _Block2Data Block2Data;
typedef struct _ScoreDialogClearScoresCbData ScoreDialogClearScoresCbData;

struct _ScoreDialog {
	AdwDialog parent_instance;
	ScoreDialogPrivate * priv;
};

struct _ScoreDialogClass {
	AdwDialogClass parent_class;
};

struct _ScoreDialogPrivate {
	AdwToolbarView* toolbar_view;
	GtkButton* clear_scores_button;
	GtkStack* header_stack;
	GtkDropDown* layout_dropdown;
	AdwWindowTitle* title_widget;
	GtkStack* content_stack;
	GtkColumnView* score_view;
	GtkColumnViewColumn* rank_column;
	GtkColumnViewColumn* time_column;
	GtkColumnViewColumn* player_column;
	GtkButton* new_game_button;
	History* history;
	HistoryEntry* completed_entry;
	GListStore* score_model;
	Maps* maps;
};

struct _HistoryEntry {
	GObject parent_instance;
	HistoryEntryPrivate * priv;
	GDateTime* date;
	gchar* name;
	guint duration;
	gchar* player;
	guint rank;
};

struct _HistoryEntryClass {
	GObjectClass parent_class;
};

struct _Map {
	GTypeInstance parent_instance;
	volatile int ref_count;
	MapPrivate * priv;
	gchar* name;
	gchar* score_name;
	gint h_overhang;
	gint v_overhang;
};

struct _MapClass {
	GTypeClass parent_class;
	void (*finalize) (Map *self);
};

struct _Block1Data {
	int _ref_count_;
	ScoreDialog* self;
	GtkListItem* list_item;
};

struct _Block2Data {
	int _ref_count_;
	Block1Data * _data1_;
	GtkEntry* entry_input_weak;
};

struct _ScoreDialogClearScoresCbData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ScoreDialog* self;
	AdwAlertDialog* dialog;
	gchar* _tmp0_;
	AdwAlertDialog* _tmp1_;
	AdwAlertDialog* _tmp2_;
	AdwAlertDialog* _tmp3_;
	AdwAlertDialog* _tmp4_;
	gchar* resp_id;
	AdwAlertDialog* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	GQuark _tmp11_;
	AdwToolbarView* _tmp12_;
	GtkStack* _tmp13_;
	GtkButton* _tmp14_;
	GListStore* _tmp15_;
	History* _tmp16_;
};

static gint ScoreDialog_private_offset;
static gpointer score_dialog_parent_class = NULL;

VALA_EXTERN GType score_dialog_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ScoreDialog, g_object_unref)
VALA_EXTERN gpointer history_ref (gpointer instance);
VALA_EXTERN void history_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_history (const gchar* name,
                                const gchar* nick,
                                const gchar* blurb,
                                GType object_type,
                                GParamFlags flags);
VALA_EXTERN void value_set_history (GValue* value,
                        gpointer v_object);
VALA_EXTERN void value_take_history (GValue* value,
                         gpointer v_object);
VALA_EXTERN gpointer value_get_history (const GValue* value);
VALA_EXTERN GType history_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (History, history_unref)
VALA_EXTERN GType history_entry_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (HistoryEntry, g_object_unref)
VALA_EXTERN gpointer maps_ref (gpointer instance);
VALA_EXTERN void maps_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_maps (const gchar* name,
                             const gchar* nick,
                             const gchar* blurb,
                             GType object_type,
                             GParamFlags flags);
VALA_EXTERN void value_set_maps (GValue* value,
                     gpointer v_object);
VALA_EXTERN void value_take_maps (GValue* value,
                      gpointer v_object);
VALA_EXTERN gpointer value_get_maps (const GValue* value);
VALA_EXTERN GType maps_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Maps, maps_unref)
VALA_EXTERN ScoreDialog* score_dialog_new (History* history,
                               Maps* maps,
                               const gchar* selected_layout,
                               HistoryEntry* completed_entry);
VALA_EXTERN ScoreDialog* score_dialog_construct (GType object_type,
                                     History* history,
                                     Maps* maps,
                                     const gchar* selected_layout,
                                     HistoryEntry* completed_entry);
static void score_dialog_set_up_score_view (ScoreDialog* self);
static void score_dialog_set_up_layout_dropdown (ScoreDialog* self);
static void score_dialog_set_up_layout_menu (ScoreDialog* self,
                                      const gchar* selected_layout);
VALA_EXTERN gint history_get_length (History* self);
VALA_EXTERN gchar* maps_get_map_display_name (Maps* self,
                                  const gchar* score_name);
static void score_dialog_clear_scores_cb (ScoreDialog* self,
                                   GAsyncReadyCallback _callback_,
                                   gpointer _user_data_);
static void score_dialog_clear_scores_cb_finish (ScoreDialog* self,
                                          GAsyncResult* _res_);
static void _score_dialog_clear_scores_cb_gtk_button_clicked (GtkButton* _sender,
                                                       gpointer self);
static void score_dialog_closed_cb (ScoreDialog* self);
static void _score_dialog_closed_cb_adw_dialog_closed (AdwDialog* _sender,
                                                gpointer self);
static void score_dialog_add_layout (ScoreDialog* self,
                              GtkStringList* model,
                              const gchar* layout_name);
static guint score_dialog_find_layout_position (ScoreDialog* self,
                                         GtkStringList* model,
                                         const gchar* display_name);
VALA_EXTERN gpointer maps_iterator_ref (gpointer instance);
VALA_EXTERN void maps_iterator_unref (gpointer instance);
VALA_EXTERN GParamSpec* maps_param_spec_iterator (const gchar* name,
                                      const gchar* nick,
                                      const gchar* blurb,
                                      GType object_type,
                                      GParamFlags flags);
VALA_EXTERN void maps_value_set_iterator (GValue* value,
                              gpointer v_object);
VALA_EXTERN void maps_value_take_iterator (GValue* value,
                               gpointer v_object);
VALA_EXTERN gpointer maps_value_get_iterator (const GValue* value);
VALA_EXTERN GType maps_iterator_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MapsIterator, maps_iterator_unref)
VALA_EXTERN MapsIterator* maps_iterator (Maps* self);
VALA_EXTERN gboolean maps_iterator_next (MapsIterator* self);
VALA_EXTERN gpointer map_ref (gpointer instance);
VALA_EXTERN void map_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_map (const gchar* name,
                            const gchar* nick,
                            const gchar* blurb,
                            GType object_type,
                            GParamFlags flags);
VALA_EXTERN void value_set_map (GValue* value,
                    gpointer v_object);
VALA_EXTERN void value_take_map (GValue* value,
                     gpointer v_object);
VALA_EXTERN gpointer value_get_map (const GValue* value);
VALA_EXTERN GType map_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Map, map_unref)
VALA_EXTERN Map* maps_iterator_get (MapsIterator* self);
VALA_EXTERN gpointer history_iterator_ref (gpointer instance);
VALA_EXTERN void history_iterator_unref (gpointer instance);
VALA_EXTERN GParamSpec* history_param_spec_iterator (const gchar* name,
                                         const gchar* nick,
                                         const gchar* blurb,
                                         GType object_type,
                                         GParamFlags flags);
VALA_EXTERN void history_value_set_iterator (GValue* value,
                                 gpointer v_object);
VALA_EXTERN void history_value_take_iterator (GValue* value,
                                  gpointer v_object);
VALA_EXTERN gpointer history_value_get_iterator (const GValue* value);
VALA_EXTERN GType history_iterator_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (HistoryIterator, history_iterator_unref)
VALA_EXTERN HistoryIterator* history_iterator (History* self);
VALA_EXTERN gboolean history_iterator_next (HistoryIterator* self);
VALA_EXTERN HistoryEntry* history_iterator_get (HistoryIterator* self);
static void score_dialog_layout_selected_cb (ScoreDialog* self);
static void _score_dialog_layout_selected_cb_g_object_notify (GObject* _sender,
                                                       GParamSpec* pspec,
                                                       gpointer self);
static void score_dialog_set_up_rank_column (ScoreDialog* self);
static void score_dialog_set_up_time_column (ScoreDialog* self);
static void score_dialog_set_up_player_column (ScoreDialog* self);
static void __lambda13_ (ScoreDialog* self);
static void ___lambda13__gtk_sorter_changed (GtkSorter* _sender,
                                      GtkSorterChange change,
                                      gpointer self);
static void __lambda14_ (ScoreDialog* self);
static gboolean __lambda15_ (ScoreDialog* self);
static gboolean ___lambda15__gsource_func (gpointer self);
static void ___lambda14__gtk_event_controller_focus_enter (GtkEventControllerFocus* _sender,
                                                    gpointer self);
static gint score_dialog_rank_sorter_cb (HistoryEntry* entry1,
                                  HistoryEntry* entry2);
static gint score_dialog_player_sorter_cb (HistoryEntry* entry1,
                                    HistoryEntry* entry2);
static gint score_dialog_date_sorter_cb (HistoryEntry* entry1,
                                  HistoryEntry* entry2);
static void __lambda5_ (ScoreDialog* self,
                 GtkSignalListItemFactory* factory,
                 GObject* object);
static void ___lambda5__gtk_signal_list_item_factory_setup (GtkSignalListItemFactory* _sender,
                                                     GObject* object,
                                                     gpointer self);
static void __lambda6_ (ScoreDialog* self,
                 GtkSignalListItemFactory* factory,
                 GObject* object);
static void ___lambda6__gtk_signal_list_item_factory_bind (GtkSignalListItemFactory* _sender,
                                                    GObject* object,
                                                    gpointer self);
static void __lambda7_ (ScoreDialog* self,
                 GtkSignalListItemFactory* factory,
                 GObject* object);
static void ___lambda7__gtk_signal_list_item_factory_setup (GtkSignalListItemFactory* _sender,
                                                     GObject* object,
                                                     gpointer self);
static void __lambda8_ (ScoreDialog* self,
                 GtkSignalListItemFactory* factory,
                 GObject* object);
static void ___lambda8__gtk_signal_list_item_factory_bind (GtkSignalListItemFactory* _sender,
                                                    GObject* object,
                                                    gpointer self);
static void __lambda9_ (ScoreDialog* self,
                 GtkSignalListItemFactory* factory,
                 GObject* object);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static void ___lambda10_ (Block2Data* _data2_);
static void ____lambda10__g_object_notify (GObject* _sender,
                                    GParamSpec* pspec,
                                    gpointer self);
static void ___lambda11_ (ScoreDialog* self);
static void ____lambda11__gtk_entry_activate (GtkEntry* _sender,
                                       gpointer self);
static void ___lambda9__gtk_signal_list_item_factory_setup (GtkSignalListItemFactory* _sender,
                                                     GObject* object,
                                                     gpointer self);
static void __lambda12_ (ScoreDialog* self,
                  GtkSignalListItemFactory* factory,
                  GObject* object);
static void ___lambda12__gtk_signal_list_item_factory_bind (GtkSignalListItemFactory* _sender,
                                                     GObject* object,
                                                     gpointer self);
static gint _score_dialog_player_sorter_cb_gcompare_func (gconstpointer a,
                                                   gconstpointer b);
static gint _score_dialog_date_sorter_cb_gcompare_func (gconstpointer a,
                                                 gconstpointer b);
static gint _score_dialog_rank_sorter_cb_gcompare_func (gconstpointer a,
                                                 gconstpointer b);
static void _vala_array_add15 (HistoryEntry** * array,
                        gint* length,
                        gint* size,
                        HistoryEntry* value);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static void score_dialog_clear_scores_cb_data_free (gpointer _data);
static gboolean score_dialog_clear_scores_cb_co (ScoreDialogClearScoresCbData* _data_);
static void score_dialog_clear_scores_cb_ready (GObject* source_object,
                                         GAsyncResult* _res_,
                                         gpointer _user_data_);
VALA_EXTERN void history_clear (History* self);
VALA_EXTERN void history_save (History* self);
static void score_dialog_finalize (GObject * obj);
static GType score_dialog_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
score_dialog_get_instance_private (ScoreDialog* self)
{
	return G_STRUCT_MEMBER_P (self, ScoreDialog_private_offset);
}

static gpointer
_maps_ref0 (gpointer self)
{
	return self ? maps_ref (self) : NULL;
}

static gpointer
_history_ref0 (gpointer self)
{
	return self ? history_ref (self) : NULL;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_score_dialog_clear_scores_cb_gtk_button_clicked (GtkButton* _sender,
                                                  gpointer self)
{
	score_dialog_clear_scores_cb ((ScoreDialog*) self, NULL, NULL);
}

static void
_score_dialog_closed_cb_adw_dialog_closed (AdwDialog* _sender,
                                           gpointer self)
{
	score_dialog_closed_cb ((ScoreDialog*) self);
}

ScoreDialog*
score_dialog_construct (GType object_type,
                        History* history,
                        Maps* maps,
                        const gchar* selected_layout,
                        HistoryEntry* completed_entry)
{
	ScoreDialog * self = NULL;
	Maps* _tmp0_;
	History* _tmp1_;
	HistoryEntry* _tmp2_;
	GtkButton* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	GtkButton* _tmp17_;
	g_return_val_if_fail (history != NULL, NULL);
	g_return_val_if_fail (maps != NULL, NULL);
	g_return_val_if_fail (selected_layout != NULL, NULL);
	self = (ScoreDialog*) g_object_new (object_type, NULL);
	_tmp0_ = _maps_ref0 (maps);
	_maps_unref0 (self->priv->maps);
	self->priv->maps = _tmp0_;
	_tmp1_ = _history_ref0 (history);
	_history_unref0 (self->priv->history);
	self->priv->history = _tmp1_;
	_tmp2_ = _g_object_ref0 (completed_entry);
	_g_object_unref0 (self->priv->completed_entry);
	self->priv->completed_entry = _tmp2_;
	score_dialog_set_up_score_view (self);
	score_dialog_set_up_layout_dropdown (self);
	score_dialog_set_up_layout_menu (self, selected_layout);
	_tmp3_ = self->priv->clear_scores_button;
	_tmp4_ = history_get_length (history);
	_tmp5_ = _tmp4_;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp3_, _tmp5_ > 0);
	if (completed_entry != NULL) {
		GtkButton* _tmp6_;
		AdwToolbarView* _tmp7_;
		GtkStack* _tmp8_;
		AdwWindowTitle* _tmp9_;
		const gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		GtkColumnView* _tmp15_;
		_tmp6_ = self->priv->clear_scores_button;
		gtk_widget_set_visible ((GtkWidget*) _tmp6_, FALSE);
		_tmp7_ = self->priv->toolbar_view;
		adw_toolbar_view_set_reveal_bottom_bars (_tmp7_, TRUE);
		_tmp8_ = self->priv->header_stack;
		gtk_stack_set_visible_child_name (_tmp8_, "title");
		_tmp9_ = self->priv->title_widget;
		_tmp10_ = completed_entry->name;
		_tmp11_ = maps_get_map_display_name (maps, _tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = g_strdup_printf (_ ("Layout: %s"), _tmp12_);
		_tmp14_ = _tmp13_;
		adw_window_title_set_subtitle (_tmp9_, _tmp14_);
		_g_free0 (_tmp14_);
		_g_free0 (_tmp12_);
		_tmp15_ = self->priv->score_view;
		g_object_set ((AdwDialog*) self, "focus-widget", (GtkWidget*) _tmp15_, NULL);
	} else {
		GtkDropDown* _tmp16_;
		_tmp16_ = self->priv->layout_dropdown;
		g_object_set ((AdwDialog*) self, "focus-widget", (GtkWidget*) _tmp16_, NULL);
	}
	_tmp17_ = self->priv->clear_scores_button;
	g_signal_connect_object (_tmp17_, "clicked", (GCallback) _score_dialog_clear_scores_cb_gtk_button_clicked, self, 0);
	g_signal_connect_object ((AdwDialog*) self, "closed", (GCallback) _score_dialog_closed_cb_adw_dialog_closed, self, 0);
	return self;
}

ScoreDialog*
score_dialog_new (History* history,
                  Maps* maps,
                  const gchar* selected_layout,
                  HistoryEntry* completed_entry)
{
	return score_dialog_construct (TYPE_SCORE_DIALOG, history, maps, selected_layout, completed_entry);
}

static void
score_dialog_add_layout (ScoreDialog* self,
                         GtkStringList* model,
                         const gchar* layout_name)
{
	gchar* display_name = NULL;
	Maps* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (model != NULL);
	g_return_if_fail (layout_name != NULL);
	_tmp0_ = self->priv->maps;
	_tmp1_ = maps_get_map_display_name (_tmp0_, layout_name);
	display_name = _tmp1_;
	_tmp2_ = display_name;
	if (score_dialog_find_layout_position (self, model, _tmp2_) == G_MAXUINT) {
		const gchar* _tmp3_;
		_tmp3_ = display_name;
		gtk_string_list_append (model, _tmp3_);
	}
	_g_free0 (display_name);
}

static guint
score_dialog_find_layout_position (ScoreDialog* self,
                                   GtkStringList* model,
                                   const gchar* display_name)
{
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	g_return_val_if_fail (model != NULL, 0U);
	g_return_val_if_fail (display_name != NULL, 0U);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				const gchar* _tmp2_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				if (!(((guint) i) < g_list_model_get_n_items ((GListModel*) model))) {
					break;
				}
				_tmp2_ = gtk_string_list_get_string (model, (guint) i);
				if (g_strcmp0 (_tmp2_, display_name) == 0) {
					result = (guint) i;
					return result;
				}
			}
		}
	}
	result = G_MAXUINT;
	return result;
}

static void
score_dialog_set_up_layout_dropdown (ScoreDialog* self)
{
	GtkButton* button = NULL;
	GtkDropDown* _tmp0_;
	GtkWidget* _tmp1_;
	GtkPopover* popover = NULL;
	GtkDropDown* _tmp2_;
	GtkWidget* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->layout_dropdown;
	_tmp1_ = gtk_widget_get_first_child ((GtkWidget*) _tmp0_);
	button = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, gtk_button_get_type ()) ? ((GtkButton*) _tmp1_) : NULL;
	_tmp2_ = self->priv->layout_dropdown;
	_tmp3_ = gtk_widget_get_last_child ((GtkWidget*) _tmp2_);
	popover = G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, gtk_popover_get_type ()) ? ((GtkPopover*) _tmp3_) : NULL;
	gtk_button_set_has_frame (button, FALSE);
	gtk_widget_set_halign ((GtkWidget*) popover, GTK_ALIGN_CENTER);
}

static void
_score_dialog_layout_selected_cb_g_object_notify (GObject* _sender,
                                                  GParamSpec* pspec,
                                                  gpointer self)
{
	score_dialog_layout_selected_cb ((ScoreDialog*) self);
}

static void
score_dialog_set_up_layout_menu (ScoreDialog* self,
                                 const gchar* selected_layout)
{
	gchar* display_name = NULL;
	Maps* _tmp0_;
	gchar* _tmp1_;
	GtkStringList* model = NULL;
	GtkStringList* _tmp2_;
	GtkDropDown* _tmp3_;
	GtkStringList* _tmp4_;
	HistoryEntry* _tmp21_;
	GtkDropDown* _tmp26_;
	GtkStringList* _tmp27_;
	const gchar* _tmp28_;
	GtkDropDown* _tmp29_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (selected_layout != NULL);
	_tmp0_ = self->priv->maps;
	_tmp1_ = maps_get_map_display_name (_tmp0_, selected_layout);
	display_name = _tmp1_;
	_tmp2_ = gtk_string_list_new (NULL);
	model = _tmp2_;
	_tmp3_ = self->priv->layout_dropdown;
	_tmp4_ = model;
	gtk_drop_down_set_model (_tmp3_, (GListModel*) _tmp4_);
	{
		MapsIterator* _map_it = NULL;
		Maps* _tmp5_;
		MapsIterator* _tmp6_;
		_tmp5_ = self->priv->maps;
		_tmp6_ = maps_iterator (_tmp5_);
		_map_it = _tmp6_;
		while (TRUE) {
			MapsIterator* _tmp7_;
			Map* map = NULL;
			MapsIterator* _tmp8_;
			Map* _tmp9_;
			GtkStringList* _tmp10_;
			Map* _tmp11_;
			const gchar* _tmp12_;
			_tmp7_ = _map_it;
			if (!maps_iterator_next (_tmp7_)) {
				break;
			}
			_tmp8_ = _map_it;
			_tmp9_ = maps_iterator_get (_tmp8_);
			map = _tmp9_;
			_tmp10_ = model;
			_tmp11_ = map;
			_tmp12_ = _tmp11_->score_name;
			score_dialog_add_layout (self, _tmp10_, _tmp12_);
		}
		_maps_iterator_unref0 (_map_it);
	}
	{
		HistoryIterator* _entry_it = NULL;
		History* _tmp13_;
		HistoryIterator* _tmp14_;
		_tmp13_ = self->priv->history;
		_tmp14_ = history_iterator (_tmp13_);
		_entry_it = _tmp14_;
		while (TRUE) {
			HistoryIterator* _tmp15_;
			HistoryEntry* entry = NULL;
			HistoryIterator* _tmp16_;
			HistoryEntry* _tmp17_;
			GtkStringList* _tmp18_;
			HistoryEntry* _tmp19_;
			const gchar* _tmp20_;
			_tmp15_ = _entry_it;
			if (!history_iterator_next (_tmp15_)) {
				break;
			}
			_tmp16_ = _entry_it;
			_tmp17_ = history_iterator_get (_tmp16_);
			entry = _tmp17_;
			_tmp18_ = model;
			_tmp19_ = entry;
			_tmp20_ = _tmp19_->name;
			score_dialog_add_layout (self, _tmp18_, _tmp20_);
		}
		_history_iterator_unref0 (_entry_it);
	}
	_tmp21_ = self->priv->completed_entry;
	if (_tmp21_ != NULL) {
		HistoryEntry* _tmp22_;
		const gchar* _tmp23_;
		_tmp22_ = self->priv->completed_entry;
		_tmp23_ = _tmp22_->name;
		selected_layout = _tmp23_;
	} else {
		if (g_strcmp0 (selected_layout, "") == 0) {
			GtkStringList* _tmp24_;
			const gchar* _tmp25_;
			_tmp24_ = model;
			_tmp25_ = gtk_string_list_get_string (_tmp24_, (guint) 0);
			selected_layout = _tmp25_;
		}
	}
	_tmp26_ = self->priv->layout_dropdown;
	_tmp27_ = model;
	_tmp28_ = display_name;
	gtk_drop_down_set_selected (_tmp26_, score_dialog_find_layout_position (self, _tmp27_, _tmp28_));
	_tmp29_ = self->priv->layout_dropdown;
	g_signal_connect_object ((GObject*) _tmp29_, "notify::selected", (GCallback) _score_dialog_layout_selected_cb_g_object_notify, self, 0);
	score_dialog_layout_selected_cb (self);
	_g_object_unref0 (model);
	_g_free0 (display_name);
}

static void
__lambda13_ (ScoreDialog* self)
{
	GtkColumnView* _tmp0_;
	_tmp0_ = self->priv->score_view;
	if (_tmp0_ != NULL) {
		GtkColumnView* _tmp1_;
		_tmp1_ = self->priv->score_view;
		gtk_column_view_scroll_to (_tmp1_, (guint) 0, NULL, GTK_LIST_SCROLL_FOCUS, NULL);
	}
}

static void
___lambda13__gtk_sorter_changed (GtkSorter* _sender,
                                 GtkSorterChange change,
                                 gpointer self)
{
	__lambda13_ ((ScoreDialog*) self);
}

static gboolean
__lambda15_ (ScoreDialog* self)
{
	GtkColumnView* _tmp0_;
	HistoryEntry* _tmp1_;
	GtkColumnView* _tmp2_;
	gboolean result;
	_tmp0_ = self->priv->score_view;
	_tmp1_ = self->priv->completed_entry;
	gtk_column_view_scroll_to (_tmp0_, _tmp1_->rank - 1, NULL, GTK_LIST_SCROLL_FOCUS, NULL);
	_tmp2_ = self->priv->score_view;
	gtk_widget_child_focus ((GtkWidget*) _tmp2_, GTK_DIR_TAB_FORWARD);
	result = FALSE;
	return result;
}

static gboolean
___lambda15__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda15_ ((ScoreDialog*) self);
	return result;
}

static void
__lambda14_ (ScoreDialog* self)
{
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda15__gsource_func, g_object_ref (self), g_object_unref);
}

static void
___lambda14__gtk_event_controller_focus_enter (GtkEventControllerFocus* _sender,
                                               gpointer self)
{
	__lambda14_ ((ScoreDialog*) self);
}

static void
score_dialog_set_up_score_view (ScoreDialog* self)
{
	GListStore* _tmp0_;
	GtkSortListModel* sort_model = NULL;
	GListStore* _tmp1_;
	GListModel* _tmp2_;
	GtkColumnView* _tmp3_;
	GtkSorter* _tmp4_;
	GtkSorter* _tmp5_;
	GtkSorter* _tmp6_;
	GtkSortListModel* _tmp7_;
	GtkColumnView* _tmp8_;
	GtkSortListModel* _tmp9_;
	GListModel* _tmp10_;
	GtkNoSelection* _tmp11_;
	GtkNoSelection* _tmp12_;
	GtkColumnView* _tmp13_;
	GtkColumnViewColumn* _tmp14_;
	GtkColumnView* _tmp15_;
	GtkSorter* _tmp16_;
	GtkSorter* _tmp17_;
	HistoryEntry* _tmp18_;
	GtkEventControllerFocus* controller = NULL;
	GtkEventControllerFocus* _tmp19_;
	GtkEventControllerFocus* _tmp20_;
	GtkColumnView* _tmp21_;
	GtkEventControllerFocus* _tmp22_;
	GtkEventController* _tmp23_;
	g_return_if_fail (self != NULL);
	score_dialog_set_up_rank_column (self);
	score_dialog_set_up_time_column (self);
	score_dialog_set_up_player_column (self);
	_tmp0_ = g_list_store_new (TYPE_HISTORY_ENTRY);
	_g_object_unref0 (self->priv->score_model);
	self->priv->score_model = _tmp0_;
	_tmp1_ = self->priv->score_model;
	_tmp2_ = _g_object_ref0 ((GListModel*) _tmp1_);
	_tmp3_ = self->priv->score_view;
	_tmp4_ = gtk_column_view_get_sorter (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = _g_object_ref0 (_tmp5_);
	_tmp7_ = gtk_sort_list_model_new (_tmp2_, _tmp6_);
	sort_model = _tmp7_;
	_tmp8_ = self->priv->score_view;
	_tmp9_ = sort_model;
	_tmp10_ = _g_object_ref0 ((GListModel*) _tmp9_);
	_tmp11_ = gtk_no_selection_new (_tmp10_);
	_tmp12_ = _tmp11_;
	gtk_column_view_set_model (_tmp8_, (GtkSelectionModel*) _tmp12_);
	_g_object_unref0 (_tmp12_);
	_tmp13_ = self->priv->score_view;
	_tmp14_ = self->priv->rank_column;
	gtk_column_view_sort_by_column (_tmp13_, _tmp14_, GTK_SORT_ASCENDING);
	_tmp15_ = self->priv->score_view;
	_tmp16_ = gtk_column_view_get_sorter (_tmp15_);
	_tmp17_ = _tmp16_;
	g_signal_connect_object (_tmp17_, "changed", (GCallback) ___lambda13__gtk_sorter_changed, self, 0);
	_tmp18_ = self->priv->completed_entry;
	if (_tmp18_ == NULL) {
		_g_object_unref0 (sort_model);
		return;
	}
	_tmp19_ = (GtkEventControllerFocus*) gtk_event_controller_focus_new ();
	controller = _tmp19_;
	_tmp20_ = controller;
	g_signal_connect_object (_tmp20_, "enter", (GCallback) ___lambda14__gtk_event_controller_focus_enter, self, 0);
	_tmp21_ = self->priv->score_view;
	_tmp22_ = controller;
	_tmp23_ = _g_object_ref0 ((GtkEventController*) _tmp22_);
	gtk_widget_add_controller ((GtkWidget*) _tmp21_, _tmp23_);
	_g_object_unref0 (controller);
	_g_object_unref0 (sort_model);
}

static gint
score_dialog_rank_sorter_cb (HistoryEntry* entry1,
                             HistoryEntry* entry2)
{
	gint result;
	g_return_val_if_fail (entry1 != NULL, 0);
	g_return_val_if_fail (entry2 != NULL, 0);
	result = ((gint) (entry1->duration > entry2->duration)) - ((gint) (entry1->duration < entry2->duration));
	return result;
}

static gint
score_dialog_player_sorter_cb (HistoryEntry* entry1,
                               HistoryEntry* entry2)
{
	GCompareFunc _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gint result;
	g_return_val_if_fail (entry1 != NULL, 0);
	g_return_val_if_fail (entry2 != NULL, 0);
	_tmp0_ = ((GCompareFunc) g_strcmp0);
	_tmp1_ = entry1->player;
	_tmp2_ = entry2->player;
	result = _tmp0_ (_tmp1_, _tmp2_);
	return result;
}

static gint
score_dialog_date_sorter_cb (HistoryEntry* entry1,
                             HistoryEntry* entry2)
{
	GDateTime* _tmp0_;
	GDateTime* _tmp1_;
	gint result;
	g_return_val_if_fail (entry1 != NULL, 0);
	g_return_val_if_fail (entry2 != NULL, 0);
	_tmp0_ = entry2->date;
	_tmp1_ = entry1->date;
	result = g_date_time_compare (_tmp0_, _tmp1_);
	return result;
}

static void
__lambda5_ (ScoreDialog* self,
            GtkSignalListItemFactory* factory,
            GObject* object)
{
	GtkListItem* list_item = NULL;
	GtkInscription* inscription = NULL;
	GtkInscription* _tmp0_;
	g_return_if_fail (factory != NULL);
	g_return_if_fail (object != NULL);
	list_item = G_TYPE_CHECK_INSTANCE_TYPE (object, gtk_list_item_get_type ()) ? ((GtkListItem*) object) : NULL;
	_tmp0_ = (GtkInscription*) gtk_inscription_new (NULL);
	g_object_ref_sink (_tmp0_);
	inscription = _tmp0_;
	gtk_widget_add_css_class ((GtkWidget*) inscription, "caption");
	gtk_widget_add_css_class ((GtkWidget*) inscription, "numeric");
	gtk_list_item_set_child (list_item, (GtkWidget*) inscription);
	_g_object_unref0 (inscription);
}

static void
___lambda5__gtk_signal_list_item_factory_setup (GtkSignalListItemFactory* _sender,
                                                GObject* object,
                                                gpointer self)
{
	__lambda5_ ((ScoreDialog*) self, _sender, object);
}

static void
__lambda6_ (ScoreDialog* self,
            GtkSignalListItemFactory* factory,
            GObject* object)
{
	GtkListItem* list_item = NULL;
	GtkInscription* inscription = NULL;
	GtkWidget* _tmp0_;
	GtkWidget* _tmp1_;
	HistoryEntry* entry = NULL;
	GObject* _tmp2_;
	GObject* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	g_return_if_fail (factory != NULL);
	g_return_if_fail (object != NULL);
	list_item = G_TYPE_CHECK_INSTANCE_TYPE (object, gtk_list_item_get_type ()) ? ((GtkListItem*) object) : NULL;
	_tmp0_ = gtk_list_item_get_child (list_item);
	_tmp1_ = _tmp0_;
	inscription = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, gtk_inscription_get_type ()) ? ((GtkInscription*) _tmp1_) : NULL;
	_tmp2_ = gtk_list_item_get_item (list_item);
	_tmp3_ = _tmp2_;
	entry = IS_HISTORY_ENTRY (_tmp3_) ? ((HistoryEntry*) _tmp3_) : NULL;
	_tmp4_ = g_strdup_printf ("%u", entry->rank);
	_tmp5_ = _tmp4_;
	gtk_inscription_set_text (inscription, _tmp5_);
	_g_free0 (_tmp5_);
}

static void
___lambda6__gtk_signal_list_item_factory_bind (GtkSignalListItemFactory* _sender,
                                               GObject* object,
                                               gpointer self)
{
	__lambda6_ ((ScoreDialog*) self, _sender, object);
}

static void
score_dialog_set_up_rank_column (ScoreDialog* self)
{
	GtkSignalListItemFactory* factory = NULL;
	GtkSignalListItemFactory* _tmp0_;
	GtkMultiSorter* sorter = NULL;
	GtkMultiSorter* _tmp1_;
	GtkCustomSorter* _tmp2_;
	GtkCustomSorter* _tmp3_;
	GtkCustomSorter* _tmp4_;
	GtkColumnViewColumn* _tmp5_;
	GtkColumnViewColumn* _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = (GtkSignalListItemFactory*) gtk_signal_list_item_factory_new ();
	factory = _tmp0_;
	_tmp1_ = gtk_multi_sorter_new ();
	sorter = _tmp1_;
	g_signal_connect_object (factory, "setup", (GCallback) ___lambda5__gtk_signal_list_item_factory_setup, self, 0);
	g_signal_connect_object (factory, "bind", (GCallback) ___lambda6__gtk_signal_list_item_factory_bind, self, 0);
	_tmp2_ = gtk_custom_sorter_new ((GCompareDataFunc) score_dialog_rank_sorter_cb, NULL, NULL);
	gtk_multi_sorter_append (sorter, (GtkSorter*) _tmp2_);
	_tmp3_ = gtk_custom_sorter_new ((GCompareDataFunc) score_dialog_date_sorter_cb, NULL, NULL);
	gtk_multi_sorter_append (sorter, (GtkSorter*) _tmp3_);
	_tmp4_ = gtk_custom_sorter_new ((GCompareDataFunc) score_dialog_player_sorter_cb, NULL, NULL);
	gtk_multi_sorter_append (sorter, (GtkSorter*) _tmp4_);
	_tmp5_ = self->priv->rank_column;
	gtk_column_view_column_set_sorter (_tmp5_, (GtkSorter*) sorter);
	_tmp6_ = self->priv->rank_column;
	gtk_column_view_column_set_factory (_tmp6_, (GtkListItemFactory*) factory);
	_g_object_unref0 (sorter);
	_g_object_unref0 (factory);
}

static void
__lambda7_ (ScoreDialog* self,
            GtkSignalListItemFactory* factory,
            GObject* object)
{
	GtkListItem* list_item = NULL;
	GtkInscription* inscription = NULL;
	GtkInscription* _tmp0_;
	g_return_if_fail (factory != NULL);
	g_return_if_fail (object != NULL);
	list_item = G_TYPE_CHECK_INSTANCE_TYPE (object, gtk_list_item_get_type ()) ? ((GtkListItem*) object) : NULL;
	_tmp0_ = (GtkInscription*) gtk_inscription_new (NULL);
	g_object_ref_sink (_tmp0_);
	inscription = _tmp0_;
	gtk_widget_add_css_class ((GtkWidget*) inscription, "numeric");
	gtk_list_item_set_child (list_item, (GtkWidget*) inscription);
	_g_object_unref0 (inscription);
}

static void
___lambda7__gtk_signal_list_item_factory_setup (GtkSignalListItemFactory* _sender,
                                                GObject* object,
                                                gpointer self)
{
	__lambda7_ ((ScoreDialog*) self, _sender, object);
}

static void
__lambda8_ (ScoreDialog* self,
            GtkSignalListItemFactory* factory,
            GObject* object)
{
	GtkListItem* list_item = NULL;
	GtkInscription* inscription = NULL;
	GtkListItem* _tmp0_;
	GtkWidget* _tmp1_;
	GtkWidget* _tmp2_;
	HistoryEntry* entry = NULL;
	GtkListItem* _tmp3_;
	GObject* _tmp4_;
	GObject* _tmp5_;
	gchar* time_label = NULL;
	HistoryEntry* _tmp6_;
	gchar* _tmp7_;
	HistoryEntry* _tmp8_;
	HistoryEntry* _tmp12_;
	HistoryEntry* _tmp13_;
	GtkInscription* _tmp15_;
	const gchar* _tmp16_;
	g_return_if_fail (factory != NULL);
	g_return_if_fail (object != NULL);
	list_item = G_TYPE_CHECK_INSTANCE_TYPE (object, gtk_list_item_get_type ()) ? ((GtkListItem*) object) : NULL;
	_tmp0_ = list_item;
	_tmp1_ = gtk_list_item_get_child (_tmp0_);
	_tmp2_ = _tmp1_;
	inscription = G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, gtk_inscription_get_type ()) ? ((GtkInscription*) _tmp2_) : NULL;
	_tmp3_ = list_item;
	_tmp4_ = gtk_list_item_get_item (_tmp3_);
	_tmp5_ = _tmp4_;
	entry = IS_HISTORY_ENTRY (_tmp5_) ? ((HistoryEntry*) _tmp5_) : NULL;
	_tmp6_ = entry;
	_tmp7_ = g_strdup_printf ("%us", _tmp6_->duration);
	time_label = _tmp7_;
	_tmp8_ = entry;
	if (_tmp8_->duration >= ((guint) 60)) {
		HistoryEntry* _tmp9_;
		HistoryEntry* _tmp10_;
		gchar* _tmp11_;
		_tmp9_ = entry;
		_tmp10_ = entry;
		_tmp11_ = g_strdup_printf ("%um %us", _tmp9_->duration / 60, _tmp10_->duration % 60);
		_g_free0 (time_label);
		time_label = _tmp11_;
	}
	_tmp12_ = entry;
	_tmp13_ = self->priv->completed_entry;
	if (_tmp12_ == _tmp13_) {
		GtkInscription* _tmp14_;
		_tmp14_ = inscription;
		gtk_widget_add_css_class ((GtkWidget*) _tmp14_, "heading");
	}
	_tmp15_ = inscription;
	_tmp16_ = time_label;
	gtk_inscription_set_text (_tmp15_, _tmp16_);
	_g_free0 (time_label);
}

static void
___lambda8__gtk_signal_list_item_factory_bind (GtkSignalListItemFactory* _sender,
                                               GObject* object,
                                               gpointer self)
{
	__lambda8_ ((ScoreDialog*) self, _sender, object);
}

static void
score_dialog_set_up_time_column (ScoreDialog* self)
{
	GtkSignalListItemFactory* factory = NULL;
	GtkSignalListItemFactory* _tmp0_;
	GtkColumnViewColumn* _tmp1_;
	GtkColumnViewColumn* _tmp2_;
	GtkSorter* _tmp3_;
	GtkSorter* _tmp4_;
	GtkColumnViewColumn* _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = (GtkSignalListItemFactory*) gtk_signal_list_item_factory_new ();
	factory = _tmp0_;
	g_signal_connect_object (factory, "setup", (GCallback) ___lambda7__gtk_signal_list_item_factory_setup, self, 0);
	g_signal_connect_object (factory, "bind", (GCallback) ___lambda8__gtk_signal_list_item_factory_bind, self, 0);
	_tmp1_ = self->priv->time_column;
	_tmp2_ = self->priv->rank_column;
	_tmp3_ = gtk_column_view_column_get_sorter (_tmp2_);
	_tmp4_ = _tmp3_;
	gtk_column_view_column_set_sorter (_tmp1_, _tmp4_);
	_tmp5_ = self->priv->time_column;
	gtk_column_view_column_set_factory (_tmp5_, (GtkListItemFactory*) factory);
	_g_object_unref0 (factory);
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		ScoreDialog* self;
		self = _data1_->self;
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}

static Block2Data*
block2_data_ref (Block2Data* _data2_)
{
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}

static void
block2_data_unref (void * _userdata_)
{
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		ScoreDialog* self;
		self = _data2_->_data1_->self;
		block1_data_unref (_data2_->_data1_);
		_data2_->_data1_ = NULL;
		g_slice_free (Block2Data, _data2_);
	}
}

static void
___lambda10_ (Block2Data* _data2_)
{
	Block1Data* _data1_;
	ScoreDialog* self;
	HistoryEntry* history_entry = NULL;
	GtkListItem* _tmp0_;
	GObject* _tmp1_;
	GObject* _tmp2_;
	HistoryEntry* _tmp3_;
	HistoryEntry* _tmp4_;
	GtkEntry* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	_data1_ = _data2_->_data1_;
	self = _data1_->self;
	_tmp0_ = _data1_->list_item;
	_tmp1_ = gtk_list_item_get_item (_tmp0_);
	_tmp2_ = _tmp1_;
	history_entry = IS_HISTORY_ENTRY (_tmp2_) ? ((HistoryEntry*) _tmp2_) : NULL;
	_tmp3_ = history_entry;
	_tmp4_ = self->priv->completed_entry;
	if (_tmp3_ != _tmp4_) {
		return;
	}
	_tmp5_ = _data2_->entry_input_weak;
	_tmp6_ = gtk_editable_get_text ((GtkEditable*) _tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = strlen (_tmp7_);
	_tmp9_ = _tmp8_;
	if (_tmp9_ <= 0) {
		HistoryEntry* _tmp10_;
		const gchar* _tmp11_;
		gchar* _tmp12_;
		_tmp10_ = history_entry;
		_tmp11_ = g_get_real_name ();
		_tmp12_ = g_strdup (_tmp11_);
		_g_free0 (_tmp10_->player);
		_tmp10_->player = _tmp12_;
	} else {
		HistoryEntry* _tmp13_;
		GtkEntry* _tmp14_;
		const gchar* _tmp15_;
		const gchar* _tmp16_;
		gchar* _tmp17_;
		_tmp13_ = history_entry;
		_tmp14_ = _data2_->entry_input_weak;
		_tmp15_ = gtk_editable_get_text ((GtkEditable*) _tmp14_);
		_tmp16_ = _tmp15_;
		_tmp17_ = g_strdup (_tmp16_);
		_g_free0 (_tmp13_->player);
		_tmp13_->player = _tmp17_;
	}
}

static void
____lambda10__g_object_notify (GObject* _sender,
                               GParamSpec* pspec,
                               gpointer self)
{
	___lambda10_ (self);
}

static void
___lambda11_ (ScoreDialog* self)
{
	GtkButton* _tmp0_;
	_tmp0_ = self->priv->new_game_button;
	g_signal_emit_by_name (_tmp0_, "activate");
}

static void
____lambda11__gtk_entry_activate (GtkEntry* _sender,
                                  gpointer self)
{
	___lambda11_ ((ScoreDialog*) self);
}

static void
__lambda9_ (ScoreDialog* self,
            GtkSignalListItemFactory* factory,
            GObject* object)
{
	Block1Data* _data1_;
	GtkStack* stack = NULL;
	GtkStack* _tmp0_;
	GtkInscription* inscription = NULL;
	GtkInscription* _tmp1_ = NULL;
	GtkStack* _tmp2_;
	GtkInscription* _tmp3_;
	HistoryEntry* _tmp4_;
	GtkListItem* _tmp12_;
	GtkStack* _tmp13_;
	g_return_if_fail (factory != NULL);
	g_return_if_fail (object != NULL);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = g_object_ref (self);
	_data1_->list_item = G_TYPE_CHECK_INSTANCE_TYPE (object, gtk_list_item_get_type ()) ? ((GtkListItem*) object) : NULL;
	_tmp0_ = (GtkStack*) gtk_stack_new ();
	g_object_ref_sink (_tmp0_);
	stack = _tmp0_;
	_tmp1_ = (GtkInscription*) gtk_inscription_new (NULL);
	gtk_inscription_set_text_overflow (_tmp1_, GTK_INSCRIPTION_OVERFLOW_ELLIPSIZE_END);
	gtk_widget_set_valign ((GtkWidget*) _tmp1_, GTK_ALIGN_CENTER);
	g_object_ref_sink (_tmp1_);
	inscription = _tmp1_;
	_tmp2_ = stack;
	_tmp3_ = inscription;
	gtk_stack_add_named (_tmp2_, (GtkWidget*) _tmp3_, "label");
	_tmp4_ = self->priv->completed_entry;
	if (_tmp4_ != NULL) {
		Block2Data* _data2_;
		GtkEntry* entry_input = NULL;
		GtkEntry* _tmp5_ = NULL;
		GtkEntry* _tmp6_;
		GtkEntry* _tmp7_;
		GtkEntry* _tmp8_;
		GtkEntry* _tmp9_;
		GtkStack* _tmp10_;
		GtkEntry* _tmp11_;
		_data2_ = g_slice_new0 (Block2Data);
		_data2_->_ref_count_ = 1;
		_data2_->_data1_ = block1_data_ref (_data1_);
		_tmp5_ = (GtkEntry*) gtk_entry_new ();
		gtk_entry_set_has_frame (_tmp5_, FALSE);
		gtk_editable_set_max_width_chars ((GtkEditable*) _tmp5_, 5);
		g_object_ref_sink (_tmp5_);
		entry_input = _tmp5_;
		_tmp6_ = entry_input;
		_data2_->entry_input_weak = _tmp6_;
		_tmp7_ = entry_input;
		gtk_widget_add_css_class ((GtkWidget*) _tmp7_, "heading");
		_tmp8_ = entry_input;
		g_signal_connect_data ((GObject*) _tmp8_, "notify::text", (GCallback) ____lambda10__g_object_notify, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
		_tmp9_ = entry_input;
		g_signal_connect_object (_tmp9_, "activate", (GCallback) ____lambda11__gtk_entry_activate, self, 0);
		_tmp10_ = stack;
		_tmp11_ = entry_input;
		gtk_stack_add_named (_tmp10_, (GtkWidget*) _tmp11_, "entry");
		_g_object_unref0 (entry_input);
		block2_data_unref (_data2_);
		_data2_ = NULL;
	}
	_tmp12_ = _data1_->list_item;
	_tmp13_ = stack;
	gtk_list_item_set_child (_tmp12_, (GtkWidget*) _tmp13_);
	_g_object_unref0 (inscription);
	_g_object_unref0 (stack);
	block1_data_unref (_data1_);
	_data1_ = NULL;
}

static void
___lambda9__gtk_signal_list_item_factory_setup (GtkSignalListItemFactory* _sender,
                                                GObject* object,
                                                gpointer self)
{
	__lambda9_ ((ScoreDialog*) self, _sender, object);
}

static void
__lambda12_ (ScoreDialog* self,
             GtkSignalListItemFactory* factory,
             GObject* object)
{
	GtkListItem* list_item = NULL;
	GtkStack* stack = NULL;
	GtkListItem* _tmp0_;
	GtkWidget* _tmp1_;
	GtkWidget* _tmp2_;
	HistoryEntry* entry = NULL;
	GtkListItem* _tmp3_;
	GObject* _tmp4_;
	GObject* _tmp5_;
	HistoryEntry* _tmp6_;
	HistoryEntry* _tmp7_;
	g_return_if_fail (factory != NULL);
	g_return_if_fail (object != NULL);
	list_item = G_TYPE_CHECK_INSTANCE_TYPE (object, gtk_list_item_get_type ()) ? ((GtkListItem*) object) : NULL;
	_tmp0_ = list_item;
	_tmp1_ = gtk_list_item_get_child (_tmp0_);
	_tmp2_ = _tmp1_;
	stack = G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, gtk_stack_get_type ()) ? ((GtkStack*) _tmp2_) : NULL;
	_tmp3_ = list_item;
	_tmp4_ = gtk_list_item_get_item (_tmp3_);
	_tmp5_ = _tmp4_;
	entry = IS_HISTORY_ENTRY (_tmp5_) ? ((HistoryEntry*) _tmp5_) : NULL;
	_tmp6_ = entry;
	_tmp7_ = self->priv->completed_entry;
	if (_tmp6_ == _tmp7_) {
		GtkStack* _tmp8_;
		GtkEntry* entry_input = NULL;
		GtkStack* _tmp9_;
		GtkWidget* _tmp10_;
		GtkWidget* _tmp11_;
		GtkEntry* _tmp12_;
		HistoryEntry* _tmp13_;
		const gchar* _tmp14_;
		_tmp8_ = stack;
		gtk_stack_set_visible_child_name (_tmp8_, "entry");
		_tmp9_ = stack;
		_tmp10_ = gtk_stack_get_visible_child (_tmp9_);
		_tmp11_ = _tmp10_;
		entry_input = G_TYPE_CHECK_INSTANCE_TYPE (_tmp11_, gtk_entry_get_type ()) ? ((GtkEntry*) _tmp11_) : NULL;
		_tmp12_ = entry_input;
		_tmp13_ = entry;
		_tmp14_ = _tmp13_->player;
		gtk_editable_set_text ((GtkEditable*) _tmp12_, _tmp14_);
	} else {
		GtkStack* _tmp15_;
		GtkInscription* inscription = NULL;
		GtkStack* _tmp16_;
		GtkWidget* _tmp17_;
		GtkWidget* _tmp18_;
		GtkInscription* _tmp19_;
		HistoryEntry* _tmp20_;
		const gchar* _tmp21_;
		GtkInscription* _tmp22_;
		HistoryEntry* _tmp23_;
		const gchar* _tmp24_;
		HistoryEntry* _tmp25_;
		GDateTime* _tmp26_;
		gchar* _tmp27_;
		gchar* _tmp28_;
		gchar* _tmp29_;
		gchar* _tmp30_;
		_tmp15_ = stack;
		gtk_stack_set_visible_child_name (_tmp15_, "label");
		_tmp16_ = stack;
		_tmp17_ = gtk_stack_get_visible_child (_tmp16_);
		_tmp18_ = _tmp17_;
		inscription = G_TYPE_CHECK_INSTANCE_TYPE (_tmp18_, gtk_inscription_get_type ()) ? ((GtkInscription*) _tmp18_) : NULL;
		_tmp19_ = inscription;
		_tmp20_ = entry;
		_tmp21_ = _tmp20_->player;
		gtk_inscription_set_text (_tmp19_, _tmp21_);
		_tmp22_ = inscription;
		_tmp23_ = entry;
		_tmp24_ = _tmp23_->player;
		_tmp25_ = entry;
		_tmp26_ = _tmp25_->date;
		_tmp27_ = g_date_time_format (_tmp26_, "%x");
		_tmp28_ = _tmp27_;
		_tmp29_ = g_strdup_printf ("%s\n%s", _tmp24_, _tmp28_);
		_tmp30_ = _tmp29_;
		gtk_widget_set_tooltip_text ((GtkWidget*) _tmp22_, _tmp30_);
		_g_free0 (_tmp30_);
		_g_free0 (_tmp28_);
	}
}

static void
___lambda12__gtk_signal_list_item_factory_bind (GtkSignalListItemFactory* _sender,
                                                GObject* object,
                                                gpointer self)
{
	__lambda12_ ((ScoreDialog*) self, _sender, object);
}

static void
score_dialog_set_up_player_column (ScoreDialog* self)
{
	GtkSignalListItemFactory* factory = NULL;
	GtkSignalListItemFactory* _tmp0_;
	GtkMultiSorter* sorter = NULL;
	GtkMultiSorter* _tmp1_;
	GtkCustomSorter* _tmp2_;
	GtkCustomSorter* _tmp3_;
	GtkCustomSorter* _tmp4_;
	GtkColumnViewColumn* _tmp5_;
	GtkColumnViewColumn* _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = (GtkSignalListItemFactory*) gtk_signal_list_item_factory_new ();
	factory = _tmp0_;
	_tmp1_ = gtk_multi_sorter_new ();
	sorter = _tmp1_;
	g_signal_connect_object (factory, "setup", (GCallback) ___lambda9__gtk_signal_list_item_factory_setup, self, 0);
	g_signal_connect_object (factory, "bind", (GCallback) ___lambda12__gtk_signal_list_item_factory_bind, self, 0);
	_tmp2_ = gtk_custom_sorter_new ((GCompareDataFunc) score_dialog_player_sorter_cb, NULL, NULL);
	gtk_multi_sorter_append (sorter, (GtkSorter*) _tmp2_);
	_tmp3_ = gtk_custom_sorter_new ((GCompareDataFunc) score_dialog_rank_sorter_cb, NULL, NULL);
	gtk_multi_sorter_append (sorter, (GtkSorter*) _tmp3_);
	_tmp4_ = gtk_custom_sorter_new ((GCompareDataFunc) score_dialog_date_sorter_cb, NULL, NULL);
	gtk_multi_sorter_append (sorter, (GtkSorter*) _tmp4_);
	_tmp5_ = self->priv->player_column;
	gtk_column_view_column_set_sorter (_tmp5_, (GtkSorter*) sorter);
	_tmp6_ = self->priv->player_column;
	gtk_column_view_column_set_factory (_tmp6_, (GtkListItemFactory*) factory);
	_g_object_unref0 (sorter);
	_g_object_unref0 (factory);
}

static gint
_score_dialog_player_sorter_cb_gcompare_func (gconstpointer a,
                                              gconstpointer b)
{
	gint result;
	result = score_dialog_player_sorter_cb ((HistoryEntry*) a, (HistoryEntry*) b);
	return result;
}

static gint
_score_dialog_date_sorter_cb_gcompare_func (gconstpointer a,
                                            gconstpointer b)
{
	gint result;
	result = score_dialog_date_sorter_cb ((HistoryEntry*) a, (HistoryEntry*) b);
	return result;
}

static gint
_score_dialog_rank_sorter_cb_gcompare_func (gconstpointer a,
                                            gconstpointer b)
{
	gint result;
	result = score_dialog_rank_sorter_cb ((HistoryEntry*) a, (HistoryEntry*) b);
	return result;
}

static void
_vala_array_add15 (HistoryEntry** * array,
                   gint* length,
                   gint* size,
                   HistoryEntry* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (HistoryEntry*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static void
score_dialog_layout_selected_cb (ScoreDialog* self)
{
	GtkStringObject* selected_item = NULL;
	GtkDropDown* _tmp0_;
	GObject* _tmp1_;
	GObject* _tmp2_;
	gchar* selected_name = NULL;
	GtkStringObject* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	GList* entry_list = NULL;
	HistoryEntry** entry_array = NULL;
	gint entry_array_length1;
	gint _entry_array_size_;
	gint rank = 0;
	GList* _tmp21_;
	gint position = 0;
	guint n_removals = 0U;
	GListStore* _tmp26_;
	guint _tmp27_;
	guint _tmp28_;
	GListStore* _tmp29_;
	HistoryEntry** _tmp30_;
	gint _tmp30__length1;
	GListStore* _tmp31_;
	guint _tmp32_;
	guint _tmp33_;
	GtkStack* _tmp36_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->layout_dropdown;
	_tmp1_ = gtk_drop_down_get_selected_item (_tmp0_);
	_tmp2_ = _tmp1_;
	selected_item = G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, gtk_string_object_get_type ()) ? ((GtkStringObject*) _tmp2_) : NULL;
	_tmp3_ = selected_item;
	_tmp4_ = gtk_string_object_get_string (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strdup (_tmp5_);
	selected_name = _tmp6_;
	entry_list = NULL;
	entry_array = NULL;
	entry_array_length1 = 0;
	_entry_array_size_ = entry_array_length1;
	{
		HistoryIterator* _entry_it = NULL;
		History* _tmp7_;
		HistoryIterator* _tmp8_;
		_tmp7_ = self->priv->history;
		_tmp8_ = history_iterator (_tmp7_);
		_entry_it = _tmp8_;
		while (TRUE) {
			HistoryIterator* _tmp9_;
			HistoryEntry* entry = NULL;
			HistoryIterator* _tmp10_;
			HistoryEntry* _tmp11_;
			Maps* _tmp12_;
			HistoryEntry* _tmp13_;
			const gchar* _tmp14_;
			gchar* _tmp15_;
			gchar* _tmp16_;
			const gchar* _tmp17_;
			gboolean _tmp18_;
			_tmp9_ = _entry_it;
			if (!history_iterator_next (_tmp9_)) {
				break;
			}
			_tmp10_ = _entry_it;
			_tmp11_ = history_iterator_get (_tmp10_);
			entry = _tmp11_;
			_tmp12_ = self->priv->maps;
			_tmp13_ = entry;
			_tmp14_ = _tmp13_->name;
			_tmp15_ = maps_get_map_display_name (_tmp12_, _tmp14_);
			_tmp16_ = _tmp15_;
			_tmp17_ = selected_name;
			_tmp18_ = g_strcmp0 (_tmp16_, _tmp17_) == 0;
			_g_free0 (_tmp16_);
			if (_tmp18_) {
				HistoryEntry* _tmp19_;
				HistoryEntry* _tmp20_;
				_tmp19_ = entry;
				_tmp20_ = _g_object_ref0 (_tmp19_);
				entry_list = g_list_prepend (entry_list, _tmp20_);
			}
		}
		_history_iterator_unref0 (_entry_it);
	}
	entry_list = g_list_sort (entry_list, _score_dialog_player_sorter_cb_gcompare_func);
	entry_list = g_list_sort (entry_list, _score_dialog_date_sorter_cb_gcompare_func);
	entry_list = g_list_sort (entry_list, _score_dialog_rank_sorter_cb_gcompare_func);
	rank = 1;
	_tmp21_ = entry_list;
	{
		GList* entry_collection = NULL;
		GList* entry_it = NULL;
		entry_collection = _tmp21_;
		for (entry_it = entry_collection; entry_it != NULL; entry_it = entry_it->next) {
			HistoryEntry* entry = NULL;
			entry = (HistoryEntry*) entry_it->data;
			{
				HistoryEntry* _tmp22_;
				gint _tmp23_;
				HistoryEntry* _tmp24_;
				HistoryEntry* _tmp25_;
				_tmp22_ = entry;
				_tmp23_ = rank;
				rank = _tmp23_ + 1;
				_tmp22_->rank = (guint) _tmp23_;
				_tmp24_ = entry;
				_tmp25_ = _g_object_ref0 (_tmp24_);
				_vala_array_add15 (&entry_array, &entry_array_length1, &_entry_array_size_, _tmp25_);
			}
		}
	}
	position = 0;
	_tmp26_ = self->priv->score_model;
	g_object_get (_tmp26_, "n-items", &_tmp27_, NULL);
	_tmp28_ = _tmp27_;
	n_removals = _tmp28_;
	_tmp29_ = self->priv->score_model;
	_tmp30_ = entry_array;
	_tmp30__length1 = entry_array_length1;
	g_list_store_splice (_tmp29_, (guint) position, n_removals, _tmp30_, (guint) _tmp30__length1);
	_tmp31_ = self->priv->score_model;
	g_object_get (_tmp31_, "n-items", &_tmp32_, NULL);
	_tmp33_ = _tmp32_;
	if (_tmp33_ > ((guint) 0)) {
		GtkStack* _tmp34_;
		GtkColumnView* _tmp35_;
		_tmp34_ = self->priv->content_stack;
		gtk_stack_set_visible_child_name (_tmp34_, "scores");
		_tmp35_ = self->priv->score_view;
		gtk_column_view_scroll_to (_tmp35_, (guint) position, NULL, GTK_LIST_SCROLL_FOCUS, NULL);
		entry_array = (_vala_array_free (entry_array, entry_array_length1, (GDestroyNotify) g_object_unref), NULL);
		(entry_list == NULL) ? NULL : (entry_list = (_g_list_free__g_object_unref0_ (entry_list), NULL));
		_g_free0 (selected_name);
		return;
	}
	_tmp36_ = self->priv->content_stack;
	gtk_stack_set_visible_child_name (_tmp36_, "no-scores");
	entry_array = (_vala_array_free (entry_array, entry_array_length1, (GDestroyNotify) g_object_unref), NULL);
	(entry_list == NULL) ? NULL : (entry_list = (_g_list_free__g_object_unref0_ (entry_list), NULL));
	_g_free0 (selected_name);
}

static void
score_dialog_clear_scores_cb_data_free (gpointer _data)
{
	ScoreDialogClearScoresCbData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (ScoreDialogClearScoresCbData, _data_);
}

static void
score_dialog_clear_scores_cb (ScoreDialog* self,
                              GAsyncReadyCallback _callback_,
                              gpointer _user_data_)
{
	ScoreDialogClearScoresCbData* _data_;
	ScoreDialog* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (ScoreDialogClearScoresCbData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, score_dialog_clear_scores_cb_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	score_dialog_clear_scores_cb_co (_data_);
}

static void
score_dialog_clear_scores_cb_finish (ScoreDialog* self,
                                     GAsyncResult* _res_)
{
	ScoreDialogClearScoresCbData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
score_dialog_clear_scores_cb_ready (GObject* source_object,
                                    GAsyncResult* _res_,
                                    gpointer _user_data_)
{
	ScoreDialogClearScoresCbData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	score_dialog_clear_scores_cb_co (_data_);
}

static gboolean
score_dialog_clear_scores_cb_co (ScoreDialogClearScoresCbData* _data_)
{
	static GQuark _tmp10_label0 = 0;
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = g_strdup ("cancel");
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = (AdwAlertDialog*) adw_alert_dialog_new (_ ("Clear All Scores?"), _ ("This will clear every score for every layout."));
	adw_alert_dialog_set_default_response (_data_->_tmp1_, _data_->_tmp0_);
	_g_free0 (_data_->_tmp0_);
	g_object_ref_sink (_data_->_tmp1_);
	_data_->dialog = _data_->_tmp1_;
	_data_->_tmp2_ = _data_->dialog;
	adw_alert_dialog_add_response (_data_->_tmp2_, "cancel", _ ("_Cancel"));
	_data_->_tmp3_ = _data_->dialog;
	adw_alert_dialog_add_response (_data_->_tmp3_, "clear", _ ("Clear All"));
	_data_->_tmp4_ = _data_->dialog;
	adw_alert_dialog_set_response_appearance (_data_->_tmp4_, "clear", ADW_RESPONSE_DESTRUCTIVE);
	_data_->_tmp5_ = _data_->dialog;
	_data_->_state_ = 1;
	adw_alert_dialog_choose (_data_->_tmp5_, (GtkWidget*) _data_->self, NULL, score_dialog_clear_scores_cb_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp6_ = adw_alert_dialog_choose_finish (_data_->_tmp5_, _data_->_res_);
	_data_->_tmp7_ = g_strdup (_data_->_tmp6_);
	_data_->resp_id = _data_->_tmp7_;
	_data_->_tmp8_ = _data_->resp_id;
	_data_->_tmp11_ = 0U;
	_data_->_tmp9_ = _data_->_tmp8_;
	_data_->_tmp11_ = (NULL == _data_->_tmp9_) ? 0 : g_quark_from_string (_data_->_tmp9_);
	if (_data_->_tmp11_ == ((0 != _tmp10_label0) ? _tmp10_label0 : (_tmp10_label0 = g_quark_from_static_string ("clear")))) {
		switch (0) {
			default:
			{
				_data_->_tmp12_ = _data_->self->priv->toolbar_view;
				adw_toolbar_view_set_reveal_bottom_bars (_data_->_tmp12_, FALSE);
				_data_->_tmp13_ = _data_->self->priv->content_stack;
				gtk_stack_set_visible_child_name (_data_->_tmp13_, "no-scores");
				_data_->_tmp14_ = _data_->self->priv->clear_scores_button;
				gtk_widget_set_sensitive ((GtkWidget*) _data_->_tmp14_, FALSE);
				_data_->_tmp15_ = _data_->self->priv->score_model;
				g_list_store_remove_all (_data_->_tmp15_);
				_g_object_unref0 (_data_->self->priv->completed_entry);
				_data_->self->priv->completed_entry = NULL;
				_data_->_tmp16_ = _data_->self->priv->history;
				history_clear (_data_->_tmp16_);
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				break;
			}
		}
	}
	_g_free0 (_data_->resp_id);
	_g_object_unref0 (_data_->dialog);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
score_dialog_closed_cb (ScoreDialog* self)
{
	HistoryEntry* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->completed_entry;
	if (_tmp0_ != NULL) {
		History* _tmp1_;
		_tmp1_ = self->priv->history;
		history_save (_tmp1_);
	}
}

static void
score_dialog_class_init (ScoreDialogClass * klass,
                         gpointer klass_data)
{
	score_dialog_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ScoreDialog_private_offset);
	G_OBJECT_CLASS (klass)->finalize = score_dialog_finalize;
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/Mahjongg/ui/score-dialog.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "toolbar_view", FALSE, ScoreDialog_private_offset + G_STRUCT_OFFSET (ScoreDialogPrivate, toolbar_view));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "clear_scores_button", FALSE, ScoreDialog_private_offset + G_STRUCT_OFFSET (ScoreDialogPrivate, clear_scores_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "header_stack", FALSE, ScoreDialog_private_offset + G_STRUCT_OFFSET (ScoreDialogPrivate, header_stack));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "layout_dropdown", FALSE, ScoreDialog_private_offset + G_STRUCT_OFFSET (ScoreDialogPrivate, layout_dropdown));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "title_widget", FALSE, ScoreDialog_private_offset + G_STRUCT_OFFSET (ScoreDialogPrivate, title_widget));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "content_stack", FALSE, ScoreDialog_private_offset + G_STRUCT_OFFSET (ScoreDialogPrivate, content_stack));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "score_view", FALSE, ScoreDialog_private_offset + G_STRUCT_OFFSET (ScoreDialogPrivate, score_view));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "rank_column", FALSE, ScoreDialog_private_offset + G_STRUCT_OFFSET (ScoreDialogPrivate, rank_column));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "time_column", FALSE, ScoreDialog_private_offset + G_STRUCT_OFFSET (ScoreDialogPrivate, time_column));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "player_column", FALSE, ScoreDialog_private_offset + G_STRUCT_OFFSET (ScoreDialogPrivate, player_column));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "new_game_button", FALSE, ScoreDialog_private_offset + G_STRUCT_OFFSET (ScoreDialogPrivate, new_game_button));
}

static void
score_dialog_instance_init (ScoreDialog * self,
                            gpointer klass)
{
	self->priv = score_dialog_get_instance_private (self);
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
score_dialog_finalize (GObject * obj)
{
	ScoreDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SCORE_DIALOG, ScoreDialog);
	_history_unref0 (self->priv->history);
	_g_object_unref0 (self->priv->completed_entry);
	_g_object_unref0 (self->priv->score_model);
	_maps_unref0 (self->priv->maps);
	G_OBJECT_CLASS (score_dialog_parent_class)->finalize (obj);
}

static GType
score_dialog_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ScoreDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) score_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ScoreDialog), 0, (GInstanceInitFunc) score_dialog_instance_init, NULL };
	GType score_dialog_type_id;
	score_dialog_type_id = g_type_register_static (adw_dialog_get_type (), "ScoreDialog", &g_define_type_info, 0);
	ScoreDialog_private_offset = g_type_add_instance_private (score_dialog_type_id, sizeof (ScoreDialogPrivate));
	return score_dialog_type_id;
}

GType
score_dialog_get_type (void)
{
	static volatile gsize score_dialog_type_id__once = 0;
	if (g_once_init_enter (&score_dialog_type_id__once)) {
		GType score_dialog_type_id;
		score_dialog_type_id = score_dialog_get_type_once ();
		g_once_init_leave (&score_dialog_type_id__once, score_dialog_type_id);
	}
	return score_dialog_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

