/* OverlayArrow.c generated by valac 0.56.17, the Vala compiler
 * generated from OverlayArrow.vala, do not modify */

/* OverlayArrow.vala
 *
 * Copyright 2020-2021 Dylan McCall <dylan@dylanmccall.ca>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 */

#include "settings.h"
#include <glib.h>
#include <gtk/gtk.h>
#include <glib-object.h>
#include <cairo-gobject.h>
#include <graphene-gobject.h>
#include <gdk/gdk.h>
#include <float.h>
#include <math.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	BREAK_TIMER_SETTINGS_WIDGETS_OVERLAY_ARROW_0_PROPERTY,
	BREAK_TIMER_SETTINGS_WIDGETS_OVERLAY_ARROW_SPACING_PROPERTY,
	BREAK_TIMER_SETTINGS_WIDGETS_OVERLAY_ARROW_NUM_PROPERTIES
};
static GParamSpec* break_timer_settings_widgets_overlay_arrow_properties[BREAK_TIMER_SETTINGS_WIDGETS_OVERLAY_ARROW_NUM_PROPERTIES];
typedef enum  {
	BREAK_TIMER_SETTINGS_WIDGETS_OVERLAY_ARROW_ARROW_DIRECTION_NONE = 1 << 0,
	BREAK_TIMER_SETTINGS_WIDGETS_OVERLAY_ARROW_ARROW_DIRECTION_UP = 1 << 1,
	BREAK_TIMER_SETTINGS_WIDGETS_OVERLAY_ARROW_ARROW_DIRECTION_RIGHT = 1 << 2,
	BREAK_TIMER_SETTINGS_WIDGETS_OVERLAY_ARROW_ARROW_DIRECTION_DOWN = 1 << 3,
	BREAK_TIMER_SETTINGS_WIDGETS_OVERLAY_ARROW_ARROW_DIRECTION_LEFT = 1 << 4
} BreakTimerSettingsWidgetsOverlayArrowArrowDirection;

#define BREAK_TIMER_SETTINGS_WIDGETS_OVERLAY_ARROW_TYPE_ARROW_DIRECTION (break_timer_settings_widgets_overlay_arrow_arrow_direction_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _BreakTimerSettingsWidgetsOverlayArrowPrivate {
	gint _spacing;
	GtkWidget* from_widget;
	GtkWidget* to_widget;
	GtkWidget* align_widget;
};

static gint BreakTimerSettingsWidgetsOverlayArrow_private_offset;
static gpointer break_timer_settings_widgets_overlay_arrow_parent_class = NULL;

static GType break_timer_settings_widgets_overlay_arrow_arrow_direction_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static void break_timer_settings_widgets_overlay_arrow_on_draw_cb (BreakTimerSettingsWidgetsOverlayArrow* self,
                                                            GtkDrawingArea* widget,
                                                            cairo_t* cr,
                                                            gint width,
                                                            gint height);
static void _break_timer_settings_widgets_overlay_arrow_on_draw_cb_gtk_drawing_area_draw_func (GtkDrawingArea* drawing_area,
                                                                                        cairo_t* cr,
                                                                                        gint width,
                                                                                        gint height,
                                                                                        gpointer self);
static void break_timer_settings_widgets_overlay_arrow_compute_arrow_points (BreakTimerSettingsWidgetsOverlayArrow* self,
                                                                      graphene_point_t* out_from_point,
                                                                      graphene_point_t* out_to_point);
static void break_timer_settings_widgets_overlay_arrow_compute_from_to_coordinates (BreakTimerSettingsWidgetsOverlayArrow* self,
                                                                             graphene_point_t* from_point_global,
                                                                             graphene_point_t* to_point_global);
static void break_timer_settings_widgets_overlay_arrow_clamp_point (BreakTimerSettingsWidgetsOverlayArrow* self,
                                                             graphene_point_t* point,
                                                             graphene_point_t* out_point);
static BreakTimerSettingsWidgetsOverlayArrowArrowDirection break_timer_settings_widgets_overlay_arrow_get_arrow_direction (BreakTimerSettingsWidgetsOverlayArrow* self);
static gboolean break_timer_settings_widgets_overlay_arrow_compute_widget_point (BreakTimerSettingsWidgetsOverlayArrow* self,
                                                                          GtkWidget* widget,
                                                                          GtkWidget* align_widget,
                                                                          gfloat d_x,
                                                                          gfloat d_y,
                                                                          graphene_point_t* out_point_global);
static void break_timer_settings_widgets_overlay_arrow_finalize (GObject * obj);
static GType break_timer_settings_widgets_overlay_arrow_get_type_once (void);
static void _vala_break_timer_settings_widgets_overlay_arrow_get_property (GObject * object,
                                                                    guint property_id,
                                                                    GValue * value,
                                                                    GParamSpec * pspec);
static void _vala_break_timer_settings_widgets_overlay_arrow_set_property (GObject * object,
                                                                    guint property_id,
                                                                    const GValue * value,
                                                                    GParamSpec * pspec);

static inline gpointer
break_timer_settings_widgets_overlay_arrow_get_instance_private (BreakTimerSettingsWidgetsOverlayArrow* self)
{
	return G_STRUCT_MEMBER_P (self, BreakTimerSettingsWidgetsOverlayArrow_private_offset);
}

static GType
break_timer_settings_widgets_overlay_arrow_arrow_direction_get_type_once (void)
{
	static const GFlagsValue values[] = {{BREAK_TIMER_SETTINGS_WIDGETS_OVERLAY_ARROW_ARROW_DIRECTION_NONE, "BREAK_TIMER_SETTINGS_WIDGETS_OVERLAY_ARROW_ARROW_DIRECTION_NONE", "none"}, {BREAK_TIMER_SETTINGS_WIDGETS_OVERLAY_ARROW_ARROW_DIRECTION_UP, "BREAK_TIMER_SETTINGS_WIDGETS_OVERLAY_ARROW_ARROW_DIRECTION_UP", "up"}, {BREAK_TIMER_SETTINGS_WIDGETS_OVERLAY_ARROW_ARROW_DIRECTION_RIGHT, "BREAK_TIMER_SETTINGS_WIDGETS_OVERLAY_ARROW_ARROW_DIRECTION_RIGHT", "right"}, {BREAK_TIMER_SETTINGS_WIDGETS_OVERLAY_ARROW_ARROW_DIRECTION_DOWN, "BREAK_TIMER_SETTINGS_WIDGETS_OVERLAY_ARROW_ARROW_DIRECTION_DOWN", "down"}, {BREAK_TIMER_SETTINGS_WIDGETS_OVERLAY_ARROW_ARROW_DIRECTION_LEFT, "BREAK_TIMER_SETTINGS_WIDGETS_OVERLAY_ARROW_ARROW_DIRECTION_LEFT", "left"}, {0, NULL, NULL}};
	GType break_timer_settings_widgets_overlay_arrow_arrow_direction_type_id;
	break_timer_settings_widgets_overlay_arrow_arrow_direction_type_id = g_flags_register_static ("BreakTimerSettingsWidgetsOverlayArrowArrowDirection", values);
	return break_timer_settings_widgets_overlay_arrow_arrow_direction_type_id;
}

static GType
break_timer_settings_widgets_overlay_arrow_arrow_direction_get_type (void)
{
	static volatile gsize break_timer_settings_widgets_overlay_arrow_arrow_direction_type_id__once = 0;
	if (g_once_init_enter (&break_timer_settings_widgets_overlay_arrow_arrow_direction_type_id__once)) {
		GType break_timer_settings_widgets_overlay_arrow_arrow_direction_type_id;
		break_timer_settings_widgets_overlay_arrow_arrow_direction_type_id = break_timer_settings_widgets_overlay_arrow_arrow_direction_get_type_once ();
		g_once_init_leave (&break_timer_settings_widgets_overlay_arrow_arrow_direction_type_id__once, break_timer_settings_widgets_overlay_arrow_arrow_direction_type_id);
	}
	return break_timer_settings_widgets_overlay_arrow_arrow_direction_type_id__once;
}

/**
     * Creates an OverlayArrow, which draws an arrow from one widget to another.
     * from_widget: a widget to start the arrow from
     * to_widget: a widget to end the arrow at
     * align_widget: a widget to measure coordinates for the target widget, if
     *               in case from_widget slides into view from elsewhere.
     */
static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_break_timer_settings_widgets_overlay_arrow_on_draw_cb_gtk_drawing_area_draw_func (GtkDrawingArea* drawing_area,
                                                                                   cairo_t* cr,
                                                                                   gint width,
                                                                                   gint height,
                                                                                   gpointer self)
{
	break_timer_settings_widgets_overlay_arrow_on_draw_cb ((BreakTimerSettingsWidgetsOverlayArrow*) self, drawing_area, cr, width, height);
}

BreakTimerSettingsWidgetsOverlayArrow*
break_timer_settings_widgets_overlay_arrow_construct (GType object_type,
                                                      GtkWidget* from_widget,
                                                      GtkWidget* to_widget,
                                                      GtkWidget* align_widget)
{
	BreakTimerSettingsWidgetsOverlayArrow * self = NULL;
	GtkWidget* _tmp0_;
	GtkWidget* _tmp1_;
	GtkWidget* _tmp2_;
	g_return_val_if_fail (from_widget != NULL, NULL);
	g_return_val_if_fail (to_widget != NULL, NULL);
	g_return_val_if_fail (align_widget != NULL, NULL);
	self = (BreakTimerSettingsWidgetsOverlayArrow*) g_object_new (object_type, "sensitive", FALSE, NULL);
	gtk_widget_set_halign ((GtkWidget*) self, GTK_ALIGN_FILL);
	gtk_widget_set_valign ((GtkWidget*) self, GTK_ALIGN_FILL);
	_tmp0_ = _g_object_ref0 (from_widget);
	_g_object_unref0 (self->priv->from_widget);
	self->priv->from_widget = _tmp0_;
	_tmp1_ = _g_object_ref0 (to_widget);
	_g_object_unref0 (self->priv->to_widget);
	self->priv->to_widget = _tmp1_;
	_tmp2_ = _g_object_ref0 (align_widget);
	_g_object_unref0 (self->priv->align_widget);
	self->priv->align_widget = _tmp2_;
	gtk_drawing_area_set_draw_func ((GtkDrawingArea*) self, _break_timer_settings_widgets_overlay_arrow_on_draw_cb_gtk_drawing_area_draw_func, g_object_ref (self), g_object_unref);
	return self;
}

BreakTimerSettingsWidgetsOverlayArrow*
break_timer_settings_widgets_overlay_arrow_new (GtkWidget* from_widget,
                                                GtkWidget* to_widget,
                                                GtkWidget* align_widget)
{
	return break_timer_settings_widgets_overlay_arrow_construct (BREAK_TIMER_SETTINGS_WIDGETS_TYPE_OVERLAY_ARROW, from_widget, to_widget, align_widget);
}

static void
break_timer_settings_widgets_overlay_arrow_on_draw_cb (BreakTimerSettingsWidgetsOverlayArrow* self,
                                                       GtkDrawingArea* widget,
                                                       cairo_t* cr,
                                                       gint width,
                                                       gint height)
{
	graphene_point_t from_point = {0};
	graphene_point_t to_point = {0};
	graphene_point_t _tmp0_ = {0};
	graphene_point_t _tmp1_ = {0};
	GdkRGBA color = {0};
	GdkRGBA _tmp2_ = {0};
	GdkRGBA _tmp3_;
	graphene_point_t _tmp4_;
	graphene_point_t _tmp5_;
	gdouble curve_x = 0.0;
	graphene_point_t _tmp6_;
	graphene_point_t _tmp7_;
	gdouble curve_y = 0.0;
	graphene_point_t _tmp8_;
	graphene_point_t _tmp9_;
	graphene_point_t _tmp10_;
	graphene_point_t _tmp11_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	g_return_if_fail (cr != NULL);
	break_timer_settings_widgets_overlay_arrow_compute_arrow_points (self, &_tmp0_, &_tmp1_);
	from_point = _tmp0_;
	to_point = _tmp1_;
	gtk_widget_get_color ((GtkWidget*) self, &_tmp2_);
	color = _tmp2_;
	_tmp3_ = color;
	gdk_cairo_set_source_rgba (cr, &_tmp3_);
	cairo_set_line_width (cr, 1.5);
	_tmp4_ = from_point;
	_tmp5_ = from_point;
	cairo_move_to (cr, (gdouble) _tmp4_.x, (gdouble) _tmp5_.y);
	_tmp6_ = to_point;
	_tmp7_ = from_point;
	curve_x = (gdouble) (_tmp6_.x - _tmp7_.x);
	_tmp8_ = to_point;
	_tmp9_ = from_point;
	curve_y = (gdouble) ((_tmp8_.y + 8) - _tmp9_.y);
	cairo_rel_curve_to (cr, curve_x / 3.0, (gdouble) 0, curve_x, curve_y / 3.0, curve_x, curve_y);
	cairo_stroke (cr);
	_tmp10_ = to_point;
	_tmp11_ = to_point;
	cairo_move_to (cr, (gdouble) _tmp10_.x, (gdouble) (_tmp11_.y + 8));
	cairo_rel_line_to (cr, (gdouble) -4, (gdouble) 0);
	cairo_rel_line_to (cr, (gdouble) 4, (gdouble) -6);
	cairo_rel_line_to (cr, (gdouble) 4, (gdouble) 6);
	cairo_close_path (cr);
	cairo_fill_preserve (cr);
	cairo_stroke (cr);
}

static void
break_timer_settings_widgets_overlay_arrow_compute_arrow_points (BreakTimerSettingsWidgetsOverlayArrow* self,
                                                                 graphene_point_t* out_from_point,
                                                                 graphene_point_t* out_to_point)
{
	graphene_point_t _vala_out_from_point = {0};
	graphene_point_t _vala_out_to_point = {0};
	graphene_point_t from_point_global = {0};
	graphene_point_t to_point_global = {0};
	graphene_point_t _tmp0_ = {0};
	graphene_point_t _tmp1_ = {0};
	graphene_point_t _tmp2_;
	graphene_point_t _tmp3_ = {0};
	graphene_point_t _tmp4_;
	graphene_point_t _tmp5_ = {0};
	g_return_if_fail (self != NULL);
	break_timer_settings_widgets_overlay_arrow_compute_from_to_coordinates (self, &_tmp0_, &_tmp1_);
	from_point_global = _tmp0_;
	to_point_global = _tmp1_;
	_tmp2_ = from_point_global;
	break_timer_settings_widgets_overlay_arrow_clamp_point (self, &_tmp2_, &_tmp3_);
	_vala_out_from_point = _tmp3_;
	_tmp4_ = to_point_global;
	break_timer_settings_widgets_overlay_arrow_clamp_point (self, &_tmp4_, &_tmp5_);
	_vala_out_to_point = _tmp5_;
	if (out_from_point) {
		*out_from_point = _vala_out_from_point;
	}
	if (out_to_point) {
		*out_to_point = _vala_out_to_point;
	}
}

static void
break_timer_settings_widgets_overlay_arrow_compute_from_to_coordinates (BreakTimerSettingsWidgetsOverlayArrow* self,
                                                                        graphene_point_t* from_point_global,
                                                                        graphene_point_t* to_point_global)
{
	graphene_point_t _vala_from_point_global = {0};
	graphene_point_t _vala_to_point_global = {0};
	BreakTimerSettingsWidgetsOverlayArrowArrowDirection direction = 0U;
	g_return_if_fail (self != NULL);
	direction = break_timer_settings_widgets_overlay_arrow_get_arrow_direction (self);
	if ((direction & (BREAK_TIMER_SETTINGS_WIDGETS_OVERLAY_ARROW_ARROW_DIRECTION_LEFT | BREAK_TIMER_SETTINGS_WIDGETS_OVERLAY_ARROW_ARROW_DIRECTION_UP)) == (BREAK_TIMER_SETTINGS_WIDGETS_OVERLAY_ARROW_ARROW_DIRECTION_LEFT | BREAK_TIMER_SETTINGS_WIDGETS_OVERLAY_ARROW_ARROW_DIRECTION_UP)) {
		GtkWidget* _tmp0_;
		graphene_point_t _tmp1_ = {0};
		GtkWidget* _tmp2_;
		GtkWidget* _tmp3_;
		graphene_point_t _tmp4_ = {0};
		gint _tmp5_;
		gint _tmp6_;
		_tmp0_ = self->priv->from_widget;
		break_timer_settings_widgets_overlay_arrow_compute_widget_point (self, _tmp0_, (GtkWidget*) self, 0.0f, 0.5f, &_tmp1_);
		_vala_from_point_global = _tmp1_;
		_tmp2_ = self->priv->to_widget;
		_tmp3_ = self->priv->align_widget;
		break_timer_settings_widgets_overlay_arrow_compute_widget_point (self, _tmp2_, _tmp3_, 0.5f, 0.0f, &_tmp4_);
		_vala_to_point_global = _tmp4_;
		_tmp5_ = self->priv->_spacing;
		_vala_from_point_global.x = _vala_from_point_global.x - _tmp5_;
		_tmp6_ = self->priv->_spacing;
		_vala_to_point_global.y = _vala_to_point_global.y - _tmp6_;
	} else {
		if ((direction & (BREAK_TIMER_SETTINGS_WIDGETS_OVERLAY_ARROW_ARROW_DIRECTION_RIGHT | BREAK_TIMER_SETTINGS_WIDGETS_OVERLAY_ARROW_ARROW_DIRECTION_UP)) == (BREAK_TIMER_SETTINGS_WIDGETS_OVERLAY_ARROW_ARROW_DIRECTION_RIGHT | BREAK_TIMER_SETTINGS_WIDGETS_OVERLAY_ARROW_ARROW_DIRECTION_UP)) {
			GtkWidget* _tmp7_;
			graphene_point_t _tmp8_ = {0};
			GtkWidget* _tmp9_;
			GtkWidget* _tmp10_;
			graphene_point_t _tmp11_ = {0};
			gint _tmp12_;
			gint _tmp13_;
			_tmp7_ = self->priv->from_widget;
			break_timer_settings_widgets_overlay_arrow_compute_widget_point (self, _tmp7_, (GtkWidget*) self, 1.0f, 0.5f, &_tmp8_);
			_vala_from_point_global = _tmp8_;
			_tmp9_ = self->priv->to_widget;
			_tmp10_ = self->priv->align_widget;
			break_timer_settings_widgets_overlay_arrow_compute_widget_point (self, _tmp9_, _tmp10_, 0.5f, 0.0f, &_tmp11_);
			_vala_to_point_global = _tmp11_;
			_tmp12_ = self->priv->_spacing;
			_vala_from_point_global.x = _vala_from_point_global.x + _tmp12_;
			_tmp13_ = self->priv->_spacing;
			_vala_to_point_global.y = _vala_to_point_global.y - _tmp13_;
		} else {
			if ((direction & (BREAK_TIMER_SETTINGS_WIDGETS_OVERLAY_ARROW_ARROW_DIRECTION_RIGHT | BREAK_TIMER_SETTINGS_WIDGETS_OVERLAY_ARROW_ARROW_DIRECTION_DOWN)) == (BREAK_TIMER_SETTINGS_WIDGETS_OVERLAY_ARROW_ARROW_DIRECTION_RIGHT | BREAK_TIMER_SETTINGS_WIDGETS_OVERLAY_ARROW_ARROW_DIRECTION_DOWN)) {
				GtkWidget* _tmp14_;
				graphene_point_t _tmp15_ = {0};
				GtkWidget* _tmp16_;
				GtkWidget* _tmp17_;
				graphene_point_t _tmp18_ = {0};
				gint _tmp19_;
				gint _tmp20_;
				_tmp14_ = self->priv->from_widget;
				break_timer_settings_widgets_overlay_arrow_compute_widget_point (self, _tmp14_, (GtkWidget*) self, 1.0f, 0.5f, &_tmp15_);
				_vala_from_point_global = _tmp15_;
				_tmp16_ = self->priv->to_widget;
				_tmp17_ = self->priv->align_widget;
				break_timer_settings_widgets_overlay_arrow_compute_widget_point (self, _tmp16_, _tmp17_, 0.5f, 1.0f, &_tmp18_);
				_vala_to_point_global = _tmp18_;
				_tmp19_ = self->priv->_spacing;
				_vala_from_point_global.y = _vala_from_point_global.y + _tmp19_;
				_tmp20_ = self->priv->_spacing;
				_vala_to_point_global.x = _vala_to_point_global.x + _tmp20_;
			} else {
				GtkWidget* _tmp21_;
				graphene_point_t _tmp22_ = {0};
				GtkWidget* _tmp23_;
				GtkWidget* _tmp24_;
				graphene_point_t _tmp25_ = {0};
				gint _tmp26_;
				gint _tmp27_;
				_tmp21_ = self->priv->from_widget;
				break_timer_settings_widgets_overlay_arrow_compute_widget_point (self, _tmp21_, (GtkWidget*) self, 0.0f, 0.5f, &_tmp22_);
				_vala_from_point_global = _tmp22_;
				_tmp23_ = self->priv->to_widget;
				_tmp24_ = self->priv->align_widget;
				break_timer_settings_widgets_overlay_arrow_compute_widget_point (self, _tmp23_, _tmp24_, 0.5f, 1.0f, &_tmp25_);
				_vala_to_point_global = _tmp25_;
				_tmp26_ = self->priv->_spacing;
				_vala_from_point_global.y = _vala_from_point_global.y - _tmp26_;
				_tmp27_ = self->priv->_spacing;
				_vala_to_point_global.x = _vala_to_point_global.x + _tmp27_;
			}
		}
	}
	if (from_point_global) {
		*from_point_global = _vala_from_point_global;
	}
	if (to_point_global) {
		*to_point_global = _vala_to_point_global;
	}
}

static gboolean
break_timer_settings_widgets_overlay_arrow_compute_widget_point (BreakTimerSettingsWidgetsOverlayArrow* self,
                                                                 GtkWidget* widget,
                                                                 GtkWidget* align_widget,
                                                                 gfloat d_x,
                                                                 gfloat d_y,
                                                                 graphene_point_t* out_point_global)
{
	graphene_point_t _vala_out_point_global = {0};
	graphene_point_t point_local = {0};
	graphene_point_t _tmp0_ = {0};
	graphene_point_t _tmp1_;
	graphene_point_t _tmp2_ = {0};
	gboolean _tmp3_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (align_widget != NULL, FALSE);
	_tmp0_.x = gtk_widget_get_width (widget) * d_x;
	_tmp0_.y = gtk_widget_get_height (widget) * d_y;
	point_local = _tmp0_;
	_tmp1_ = point_local;
	_tmp3_ = gtk_widget_compute_point (widget, align_widget, &_tmp1_, &_tmp2_);
	_vala_out_point_global = _tmp2_;
	result = _tmp3_;
	if (out_point_global) {
		*out_point_global = _vala_out_point_global;
	}
	return result;
}

static void
break_timer_settings_widgets_overlay_arrow_clamp_point (BreakTimerSettingsWidgetsOverlayArrow* self,
                                                        graphene_point_t* point,
                                                        graphene_point_t* out_point)
{
	graphene_point_t _vala_out_point = {0};
	gint max_width = 0;
	gint max_height = 0;
	graphene_point_t _tmp0_;
	graphene_point_t _tmp1_;
	graphene_point_t _tmp2_ = {0};
	g_return_if_fail (self != NULL);
	g_return_if_fail (point != NULL);
	max_width = gtk_widget_get_width ((GtkWidget*) self);
	max_height = gtk_widget_get_height ((GtkWidget*) self);
	_tmp0_ = *point;
	_tmp1_ = *point;
	_tmp2_.x = CLAMP (_tmp0_.x, (gfloat) 0, (gfloat) max_width);
	_tmp2_.y = CLAMP (_tmp1_.y, (gfloat) 0, (gfloat) max_height);
	_vala_out_point = _tmp2_;
	if (out_point) {
		*out_point = _vala_out_point;
	}
}

static BreakTimerSettingsWidgetsOverlayArrowArrowDirection
break_timer_settings_widgets_overlay_arrow_get_arrow_direction (BreakTimerSettingsWidgetsOverlayArrow* self)
{
	BreakTimerSettingsWidgetsOverlayArrowArrowDirection direction = 0U;
	graphene_point_t from_center_global = {0};
	graphene_point_t to_center_global = {0};
	GtkWidget* _tmp0_;
	graphene_point_t _tmp1_ = {0};
	GtkWidget* _tmp2_;
	GtkWidget* _tmp3_;
	graphene_point_t _tmp4_ = {0};
	gfloat d_x = 0.0F;
	graphene_point_t _tmp5_;
	graphene_point_t _tmp6_;
	gfloat d_y = 0.0F;
	graphene_point_t _tmp7_;
	graphene_point_t _tmp8_;
	BreakTimerSettingsWidgetsOverlayArrowArrowDirection result;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->priv->from_widget;
	break_timer_settings_widgets_overlay_arrow_compute_widget_point (self, _tmp0_, (GtkWidget*) self, 0.5f, 0.5f, &_tmp1_);
	from_center_global = _tmp1_;
	_tmp2_ = self->priv->to_widget;
	_tmp3_ = self->priv->align_widget;
	break_timer_settings_widgets_overlay_arrow_compute_widget_point (self, _tmp2_, _tmp3_, 0.5f, 0.5f, &_tmp4_);
	to_center_global = _tmp4_;
	_tmp5_ = to_center_global;
	_tmp6_ = from_center_global;
	d_x = _tmp5_.x - _tmp6_.x;
	_tmp7_ = to_center_global;
	_tmp8_ = from_center_global;
	d_y = _tmp7_.y - _tmp8_.y;
	if (d_x > ((gfloat) 0)) {
		direction |= BREAK_TIMER_SETTINGS_WIDGETS_OVERLAY_ARROW_ARROW_DIRECTION_RIGHT;
	} else {
		if (d_x < ((gfloat) 0)) {
			direction |= BREAK_TIMER_SETTINGS_WIDGETS_OVERLAY_ARROW_ARROW_DIRECTION_LEFT;
		} else {
			direction |= BREAK_TIMER_SETTINGS_WIDGETS_OVERLAY_ARROW_ARROW_DIRECTION_NONE;
		}
	}
	if (d_y > ((gfloat) 0)) {
		direction |= BREAK_TIMER_SETTINGS_WIDGETS_OVERLAY_ARROW_ARROW_DIRECTION_DOWN;
	} else {
		if (d_y < ((gfloat) 0)) {
			direction |= BREAK_TIMER_SETTINGS_WIDGETS_OVERLAY_ARROW_ARROW_DIRECTION_UP;
		} else {
			direction |= BREAK_TIMER_SETTINGS_WIDGETS_OVERLAY_ARROW_ARROW_DIRECTION_NONE;
		}
	}
	result = direction;
	return result;
}

gint
break_timer_settings_widgets_overlay_arrow_get_spacing (BreakTimerSettingsWidgetsOverlayArrow* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_spacing;
	return result;
}

void
break_timer_settings_widgets_overlay_arrow_set_spacing (BreakTimerSettingsWidgetsOverlayArrow* self,
                                                        gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = break_timer_settings_widgets_overlay_arrow_get_spacing (self);
	if (old_value != value) {
		self->priv->_spacing = value;
		g_object_notify_by_pspec ((GObject *) self, break_timer_settings_widgets_overlay_arrow_properties[BREAK_TIMER_SETTINGS_WIDGETS_OVERLAY_ARROW_SPACING_PROPERTY]);
	}
}

static void
break_timer_settings_widgets_overlay_arrow_class_init (BreakTimerSettingsWidgetsOverlayArrowClass * klass,
                                                       gpointer klass_data)
{
	break_timer_settings_widgets_overlay_arrow_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BreakTimerSettingsWidgetsOverlayArrow_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_break_timer_settings_widgets_overlay_arrow_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_break_timer_settings_widgets_overlay_arrow_set_property;
	G_OBJECT_CLASS (klass)->finalize = break_timer_settings_widgets_overlay_arrow_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), BREAK_TIMER_SETTINGS_WIDGETS_OVERLAY_ARROW_SPACING_PROPERTY, break_timer_settings_widgets_overlay_arrow_properties[BREAK_TIMER_SETTINGS_WIDGETS_OVERLAY_ARROW_SPACING_PROPERTY] = g_param_spec_int ("spacing", "spacing", "spacing", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
break_timer_settings_widgets_overlay_arrow_instance_init (BreakTimerSettingsWidgetsOverlayArrow * self,
                                                          gpointer klass)
{
	self->priv = break_timer_settings_widgets_overlay_arrow_get_instance_private (self);
}

static void
break_timer_settings_widgets_overlay_arrow_finalize (GObject * obj)
{
	BreakTimerSettingsWidgetsOverlayArrow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BREAK_TIMER_SETTINGS_WIDGETS_TYPE_OVERLAY_ARROW, BreakTimerSettingsWidgetsOverlayArrow);
	_g_object_unref0 (self->priv->from_widget);
	_g_object_unref0 (self->priv->to_widget);
	_g_object_unref0 (self->priv->align_widget);
	G_OBJECT_CLASS (break_timer_settings_widgets_overlay_arrow_parent_class)->finalize (obj);
}

static GType
break_timer_settings_widgets_overlay_arrow_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BreakTimerSettingsWidgetsOverlayArrowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) break_timer_settings_widgets_overlay_arrow_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BreakTimerSettingsWidgetsOverlayArrow), 0, (GInstanceInitFunc) break_timer_settings_widgets_overlay_arrow_instance_init, NULL };
	GType break_timer_settings_widgets_overlay_arrow_type_id;
	break_timer_settings_widgets_overlay_arrow_type_id = g_type_register_static (gtk_drawing_area_get_type (), "BreakTimerSettingsWidgetsOverlayArrow", &g_define_type_info, 0);
	BreakTimerSettingsWidgetsOverlayArrow_private_offset = g_type_add_instance_private (break_timer_settings_widgets_overlay_arrow_type_id, sizeof (BreakTimerSettingsWidgetsOverlayArrowPrivate));
	return break_timer_settings_widgets_overlay_arrow_type_id;
}

GType
break_timer_settings_widgets_overlay_arrow_get_type (void)
{
	static volatile gsize break_timer_settings_widgets_overlay_arrow_type_id__once = 0;
	if (g_once_init_enter (&break_timer_settings_widgets_overlay_arrow_type_id__once)) {
		GType break_timer_settings_widgets_overlay_arrow_type_id;
		break_timer_settings_widgets_overlay_arrow_type_id = break_timer_settings_widgets_overlay_arrow_get_type_once ();
		g_once_init_leave (&break_timer_settings_widgets_overlay_arrow_type_id__once, break_timer_settings_widgets_overlay_arrow_type_id);
	}
	return break_timer_settings_widgets_overlay_arrow_type_id__once;
}

static void
_vala_break_timer_settings_widgets_overlay_arrow_get_property (GObject * object,
                                                               guint property_id,
                                                               GValue * value,
                                                               GParamSpec * pspec)
{
	BreakTimerSettingsWidgetsOverlayArrow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BREAK_TIMER_SETTINGS_WIDGETS_TYPE_OVERLAY_ARROW, BreakTimerSettingsWidgetsOverlayArrow);
	switch (property_id) {
		case BREAK_TIMER_SETTINGS_WIDGETS_OVERLAY_ARROW_SPACING_PROPERTY:
		g_value_set_int (value, break_timer_settings_widgets_overlay_arrow_get_spacing (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_break_timer_settings_widgets_overlay_arrow_set_property (GObject * object,
                                                               guint property_id,
                                                               const GValue * value,
                                                               GParamSpec * pspec)
{
	BreakTimerSettingsWidgetsOverlayArrow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BREAK_TIMER_SETTINGS_WIDGETS_TYPE_OVERLAY_ARROW, BreakTimerSettingsWidgetsOverlayArrow);
	switch (property_id) {
		case BREAK_TIMER_SETTINGS_WIDGETS_OVERLAY_ARROW_SPACING_PROPERTY:
		break_timer_settings_widgets_overlay_arrow_set_spacing (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

