/* CircleCounter.c generated by valac 0.56.17, the Vala compiler
 * generated from CircleCounter.vala, do not modify */

/* CircleCounter.vala
 *
 * Copyright 2020-2021 Dylan McCall <dylan@dylanmccall.ca>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 */

#include "settings.h"
#include <glib.h>
#include <float.h>
#include <math.h>
#include <gtk/gtk.h>
#include "common.h"
#include <glib-object.h>
#include <graphene-gobject.h>
#include <cairo-gobject.h>
#include <gdk/gdk.h>

#define BREAK_TIMER_SETTINGS_WIDGETS_CIRCLE_COUNTER_MAX_ANIM_DURATION ((gint64) (500 * BREAK_TIMER_COMMON_TIME_UNIT_MICROSECONDS_IN_MILLISECONDS))
#define BREAK_TIMER_SETTINGS_WIDGETS_CIRCLE_COUNTER_MIN_ANIM_DURATION ((gint64) (10 * BREAK_TIMER_COMMON_TIME_UNIT_MICROSECONDS_IN_MILLISECONDS))
#define BREAK_TIMER_SETTINGS_WIDGETS_CIRCLE_COUNTER_FULL_ANIM_SPEED ((gint64) ((10 * BREAK_TIMER_COMMON_TIME_UNIT_MICROSECONDS_IN_SECONDS) / (G_PI * 2)))
#define BREAK_TIMER_SETTINGS_WIDGETS_CIRCLE_COUNTER_SNAP_INCREMENT ((G_PI * 2) / 60.0)
#define BREAK_TIMER_SETTINGS_WIDGETS_CIRCLE_COUNTER_ANGLE_OFFSET (1.5 * G_PI)
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	BREAK_TIMER_SETTINGS_WIDGETS_CIRCLE_COUNTER_0_PROPERTY,
	BREAK_TIMER_SETTINGS_WIDGETS_CIRCLE_COUNTER_DIRECTION_PROPERTY,
	BREAK_TIMER_SETTINGS_WIDGETS_CIRCLE_COUNTER_PROGRESS_PROPERTY,
	BREAK_TIMER_SETTINGS_WIDGETS_CIRCLE_COUNTER_DRAW_ANGLE_PROPERTY,
	BREAK_TIMER_SETTINGS_WIDGETS_CIRCLE_COUNTER_NUM_PROPERTIES
};
static GParamSpec* break_timer_settings_widgets_circle_counter_properties[BREAK_TIMER_SETTINGS_WIDGETS_CIRCLE_COUNTER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))

struct _BreakTimerSettingsWidgetsCircleCounterPrivate {
	BreakTimerSettingsWidgetsCircleCounterDirection _direction;
	gdouble _progress;
	gdouble _draw_angle;
	BreakTimerSettingsWidgetsPropertyTransition* draw_angle_transition;
	gboolean first_frame;
};

static gint BreakTimerSettingsWidgetsCircleCounter_private_offset;
static gpointer break_timer_settings_widgets_circle_counter_parent_class = NULL;

static void _break_timer_settings_widgets_property_transition_calculate_value_double_break_timer_settings_widgets_property_transition_calculate_value (GValue* start_value,
                                                                                                                                                GValue* end_value,
                                                                                                                                                gdouble ease,
                                                                                                                                                GValue* result,
                                                                                                                                                gpointer self);
static void break_timer_settings_widgets_circle_counter_on_map_cb (BreakTimerSettingsWidgetsCircleCounter* self);
static void _break_timer_settings_widgets_circle_counter_on_map_cb_gtk_widget_map (GtkWidget* _sender,
                                                                            gpointer self);
static void break_timer_settings_widgets_circle_counter_on_direction_notify_cb (BreakTimerSettingsWidgetsCircleCounter* self);
static void _break_timer_settings_widgets_circle_counter_on_direction_notify_cb_g_object_notify (GObject* _sender,
                                                                                          GParamSpec* pspec,
                                                                                          gpointer self);
static void break_timer_settings_widgets_circle_counter_on_progress_notify_cb (BreakTimerSettingsWidgetsCircleCounter* self);
static void _break_timer_settings_widgets_circle_counter_on_progress_notify_cb_g_object_notify (GObject* _sender,
                                                                                         GParamSpec* pspec,
                                                                                         gpointer self);
static void break_timer_settings_widgets_circle_counter_on_draw_angle_notify_cb (BreakTimerSettingsWidgetsCircleCounter* self);
static void _break_timer_settings_widgets_circle_counter_on_draw_angle_notify_cb_g_object_notify (GObject* _sender,
                                                                                           GParamSpec* pspec,
                                                                                           gpointer self);
static gdouble break_timer_settings_widgets_circle_counter_calculate_draw_angle (BreakTimerSettingsWidgetsCircleCounter* self,
                                                                          gdouble progress);
static void break_timer_settings_widgets_circle_counter_real_snapshot (GtkWidget* base,
                                                                GtkSnapshot* snapshot);
static void break_timer_settings_widgets_circle_counter_real_measure (GtkWidget* base,
                                                               GtkOrientation orientation,
                                                               gint for_size,
                                                               gint* minimum,
                                                               gint* natural,
                                                               gint* minimum_baseline,
                                                               gint* natural_baseline);
static gint break_timer_settings_widgets_circle_counter_calculate_diameter (BreakTimerSettingsWidgetsCircleCounter* self);
static void break_timer_settings_widgets_circle_counter_finalize (GObject * obj);
static GType break_timer_settings_widgets_circle_counter_get_type_once (void);
static void _vala_break_timer_settings_widgets_circle_counter_get_property (GObject * object,
                                                                     guint property_id,
                                                                     GValue * value,
                                                                     GParamSpec * pspec);
static void _vala_break_timer_settings_widgets_circle_counter_set_property (GObject * object,
                                                                     guint property_id,
                                                                     const GValue * value,
                                                                     GParamSpec * pspec);

static inline gpointer
break_timer_settings_widgets_circle_counter_get_instance_private (BreakTimerSettingsWidgetsCircleCounter* self)
{
	return G_STRUCT_MEMBER_P (self, BreakTimerSettingsWidgetsCircleCounter_private_offset);
}

static GType
break_timer_settings_widgets_circle_counter_direction_get_type_once (void)
{
	static const GEnumValue values[] = {{BREAK_TIMER_SETTINGS_WIDGETS_CIRCLE_COUNTER_DIRECTION_COUNT_DOWN, "BREAK_TIMER_SETTINGS_WIDGETS_CIRCLE_COUNTER_DIRECTION_COUNT_DOWN", "count-down"}, {BREAK_TIMER_SETTINGS_WIDGETS_CIRCLE_COUNTER_DIRECTION_COUNT_UP, "BREAK_TIMER_SETTINGS_WIDGETS_CIRCLE_COUNTER_DIRECTION_COUNT_UP", "count-up"}, {0, NULL, NULL}};
	GType break_timer_settings_widgets_circle_counter_direction_type_id;
	break_timer_settings_widgets_circle_counter_direction_type_id = g_enum_register_static ("BreakTimerSettingsWidgetsCircleCounterDirection", values);
	return break_timer_settings_widgets_circle_counter_direction_type_id;
}

GType
break_timer_settings_widgets_circle_counter_direction_get_type (void)
{
	static volatile gsize break_timer_settings_widgets_circle_counter_direction_type_id__once = 0;
	if (g_once_init_enter (&break_timer_settings_widgets_circle_counter_direction_type_id__once)) {
		GType break_timer_settings_widgets_circle_counter_direction_type_id;
		break_timer_settings_widgets_circle_counter_direction_type_id = break_timer_settings_widgets_circle_counter_direction_get_type_once ();
		g_once_init_leave (&break_timer_settings_widgets_circle_counter_direction_type_id__once, break_timer_settings_widgets_circle_counter_direction_type_id);
	}
	return break_timer_settings_widgets_circle_counter_direction_type_id__once;
}

static void
_break_timer_settings_widgets_property_transition_calculate_value_double_break_timer_settings_widgets_property_transition_calculate_value (GValue* start_value,
                                                                                                                                           GValue* end_value,
                                                                                                                                           gdouble ease,
                                                                                                                                           GValue* result,
                                                                                                                                           gpointer self)
{
	break_timer_settings_widgets_property_transition_calculate_value_double (start_value, end_value, ease, result);
}

static void
_break_timer_settings_widgets_circle_counter_on_map_cb_gtk_widget_map (GtkWidget* _sender,
                                                                       gpointer self)
{
	break_timer_settings_widgets_circle_counter_on_map_cb ((BreakTimerSettingsWidgetsCircleCounter*) self);
}

static void
_break_timer_settings_widgets_circle_counter_on_direction_notify_cb_g_object_notify (GObject* _sender,
                                                                                     GParamSpec* pspec,
                                                                                     gpointer self)
{
	break_timer_settings_widgets_circle_counter_on_direction_notify_cb ((BreakTimerSettingsWidgetsCircleCounter*) self);
}

static void
_break_timer_settings_widgets_circle_counter_on_progress_notify_cb_g_object_notify (GObject* _sender,
                                                                                    GParamSpec* pspec,
                                                                                    gpointer self)
{
	break_timer_settings_widgets_circle_counter_on_progress_notify_cb ((BreakTimerSettingsWidgetsCircleCounter*) self);
}

static void
_break_timer_settings_widgets_circle_counter_on_draw_angle_notify_cb_g_object_notify (GObject* _sender,
                                                                                      GParamSpec* pspec,
                                                                                      gpointer self)
{
	break_timer_settings_widgets_circle_counter_on_draw_angle_notify_cb ((BreakTimerSettingsWidgetsCircleCounter*) self);
}

BreakTimerSettingsWidgetsCircleCounter*
break_timer_settings_widgets_circle_counter_construct (GType object_type)
{
	BreakTimerSettingsWidgetsCircleCounter * self = NULL;
	BreakTimerSettingsWidgetsPropertyTransition* _tmp0_;
	self = (BreakTimerSettingsWidgetsCircleCounter*) g_object_new (object_type, NULL);
	_tmp0_ = break_timer_settings_widgets_property_transition_new ((GtkWidget*) self, "draw-angle", _break_timer_settings_widgets_property_transition_calculate_value_double_break_timer_settings_widgets_property_transition_calculate_value, NULL);
	_g_object_unref0 (self->priv->draw_angle_transition);
	self->priv->draw_angle_transition = _tmp0_;
	g_signal_connect_object ((GtkWidget*) self, "map", (GCallback) _break_timer_settings_widgets_circle_counter_on_map_cb_gtk_widget_map, self, 0);
	g_signal_connect_object ((GObject*) self, "notify::direction", (GCallback) _break_timer_settings_widgets_circle_counter_on_direction_notify_cb_g_object_notify, self, 0);
	g_signal_connect_object ((GObject*) self, "notify::progress", (GCallback) _break_timer_settings_widgets_circle_counter_on_progress_notify_cb_g_object_notify, self, 0);
	g_signal_connect_object ((GObject*) self, "notify::draw-angle", (GCallback) _break_timer_settings_widgets_circle_counter_on_draw_angle_notify_cb_g_object_notify, self, 0);
	return self;
}

BreakTimerSettingsWidgetsCircleCounter*
break_timer_settings_widgets_circle_counter_new (void)
{
	return break_timer_settings_widgets_circle_counter_construct (BREAK_TIMER_SETTINGS_WIDGETS_TYPE_CIRCLE_COUNTER);
}

static void
break_timer_settings_widgets_circle_counter_on_direction_notify_cb (BreakTimerSettingsWidgetsCircleCounter* self)
{
	g_return_if_fail (self != NULL);
	self->priv->first_frame = TRUE;
}

static void
break_timer_settings_widgets_circle_counter_on_progress_notify_cb (BreakTimerSettingsWidgetsCircleCounter* self)
{
	gdouble progress = 0.0;
	gdouble _tmp0_;
	gdouble progress_angle = 0.0;
	gdouble change = 0.0;
	gdouble _tmp3_;
	gint64 duration = 0LL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_progress;
	progress = CLAMP (fabs (_tmp0_), 0.0, 1.0);
	progress_angle = break_timer_settings_widgets_circle_counter_calculate_draw_angle (self, progress);
	if (self->priv->first_frame) {
		BreakTimerSettingsWidgetsPropertyTransition* _tmp1_;
		GValue _tmp2_ = {0};
		_tmp1_ = self->priv->draw_angle_transition;
		g_value_init (&_tmp2_, G_TYPE_DOUBLE);
		g_value_set_double (&_tmp2_, progress_angle);
		break_timer_settings_widgets_property_transition_skip (_tmp1_, &_tmp2_);
		G_IS_VALUE (&_tmp2_) ? (g_value_unset (&_tmp2_), NULL) : NULL;
		self->priv->first_frame = FALSE;
		return;
	}
	_tmp3_ = self->priv->_draw_angle;
	change = fabs (progress_angle - _tmp3_);
	duration = MIN ((gint64) (change * BREAK_TIMER_SETTINGS_WIDGETS_CIRCLE_COUNTER_FULL_ANIM_SPEED), BREAK_TIMER_SETTINGS_WIDGETS_CIRCLE_COUNTER_MAX_ANIM_DURATION);
	if (duration < BREAK_TIMER_SETTINGS_WIDGETS_CIRCLE_COUNTER_MIN_ANIM_DURATION) {
		BreakTimerSettingsWidgetsPropertyTransition* _tmp4_;
		GValue _tmp5_ = {0};
		_tmp4_ = self->priv->draw_angle_transition;
		g_value_init (&_tmp5_, G_TYPE_DOUBLE);
		g_value_set_double (&_tmp5_, progress_angle);
		break_timer_settings_widgets_property_transition_skip (_tmp4_, &_tmp5_);
		G_IS_VALUE (&_tmp5_) ? (g_value_unset (&_tmp5_), NULL) : NULL;
	} else {
		BreakTimerSettingsWidgetsPropertyTransition* _tmp6_;
		GValue _tmp7_ = {0};
		_tmp6_ = self->priv->draw_angle_transition;
		g_value_init (&_tmp7_, G_TYPE_DOUBLE);
		g_value_set_double (&_tmp7_, progress_angle);
		break_timer_settings_widgets_property_transition_start (_tmp6_, &_tmp7_, BREAK_TIMER_SETTINGS_WIDGETS_PROPERTY_TRANSITION_EASING_FUNCTION_EASE_OUT_CUBIC, duration);
		G_IS_VALUE (&_tmp7_) ? (g_value_unset (&_tmp7_), NULL) : NULL;
	}
}

static void
break_timer_settings_widgets_circle_counter_on_draw_angle_notify_cb (BreakTimerSettingsWidgetsCircleCounter* self)
{
	g_return_if_fail (self != NULL);
	gtk_widget_queue_draw ((GtkWidget*) self);
}

static gdouble
break_timer_settings_widgets_circle_counter_calculate_draw_angle (BreakTimerSettingsWidgetsCircleCounter* self,
                                                                  gdouble progress)
{
	gdouble _result_ = 0.0;
	gint snap_count = 0;
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	_result_ = (progress * G_PI) * 2.0;
	snap_count = (gint) (_result_ / BREAK_TIMER_SETTINGS_WIDGETS_CIRCLE_COUNTER_SNAP_INCREMENT);
	result = ((gdouble) snap_count) * BREAK_TIMER_SETTINGS_WIDGETS_CIRCLE_COUNTER_SNAP_INCREMENT;
	return result;
}

static void
break_timer_settings_widgets_circle_counter_on_map_cb (BreakTimerSettingsWidgetsCircleCounter* self)
{
	g_return_if_fail (self != NULL);
	self->priv->first_frame = TRUE;
}

static void
break_timer_settings_widgets_circle_counter_real_snapshot (GtkWidget* base,
                                                           GtkSnapshot* snapshot)
{
	BreakTimerSettingsWidgetsCircleCounter * self;
	graphene_rect_t bounds = {0};
	graphene_rect_t _tmp0_ = {0};
	cairo_t* cr = NULL;
	graphene_rect_t _tmp1_;
	cairo_t* _tmp2_;
	GdkRGBA foreground_color = {0};
	GdkRGBA _tmp3_ = {0};
	gint center_x = 0;
	gint center_y = 0;
	gint radius = 0;
	gdouble arc_radius = 0.0;
	cairo_t* _tmp4_;
	cairo_t* _tmp5_;
	GdkRGBA _tmp6_;
	cairo_t* _tmp7_;
	cairo_t* _tmp8_;
	cairo_t* _tmp9_;
	cairo_t* _tmp10_;
	cairo_t* _tmp11_;
	cairo_t* _tmp12_;
	cairo_t* _tmp13_;
	GdkRGBA _tmp14_;
	BreakTimerSettingsWidgetsCircleCounterDirection _tmp15_;
	cairo_t* _tmp23_;
	cairo_t* _tmp24_;
	cairo_t* _tmp25_;
	cairo_t* _tmp26_;
	cairo_t* _tmp27_;
	cairo_t* _tmp28_;
	self = (BreakTimerSettingsWidgetsCircleCounter*) base;
	g_return_if_fail (snapshot != NULL);
	gtk_widget_compute_bounds ((GtkWidget*) self, (GtkWidget*) self, &_tmp0_);
	bounds = _tmp0_;
	_tmp1_ = bounds;
	_tmp2_ = gtk_snapshot_append_cairo (snapshot, &_tmp1_);
	cr = _tmp2_;
	gtk_widget_get_color ((GtkWidget*) self, &_tmp3_);
	foreground_color = _tmp3_;
	center_x = ((gint) graphene_rect_get_width (&bounds)) / 2;
	center_y = ((gint) graphene_rect_get_height (&bounds)) / 2;
	radius = MIN (center_x, center_y);
	arc_radius = radius - (BREAK_TIMER_SETTINGS_WIDGETS_CIRCLE_COUNTER_LINE_WIDTH / 2);
	_tmp4_ = cr;
	cairo_set_operator (_tmp4_, CAIRO_OPERATOR_OVER);
	_tmp5_ = cr;
	_tmp6_ = foreground_color;
	gdk_cairo_set_source_rgba (_tmp5_, &_tmp6_);
	_tmp7_ = cr;
	cairo_arc (_tmp7_, (gdouble) center_x, (gdouble) center_y, arc_radius, (gdouble) 0, G_PI * 2.0);
	_tmp8_ = cr;
	cairo_set_line_width (_tmp8_, BREAK_TIMER_SETTINGS_WIDGETS_CIRCLE_COUNTER_LINE_WIDTH);
	_tmp9_ = cr;
	cairo_push_group (_tmp9_);
	_tmp10_ = cr;
	cairo_stroke (_tmp10_);
	_tmp11_ = cr;
	cairo_pop_group_to_source (_tmp11_);
	_tmp12_ = cr;
	cairo_paint_with_alpha (_tmp12_, 0.2);
	_tmp13_ = cr;
	_tmp14_ = foreground_color;
	gdk_cairo_set_source_rgba (_tmp13_, &_tmp14_);
	_tmp15_ = self->priv->_direction;
	if (_tmp15_ == BREAK_TIMER_SETTINGS_WIDGETS_CIRCLE_COUNTER_DIRECTION_COUNT_DOWN) {
		gdouble _tmp16_;
		_tmp16_ = self->priv->_draw_angle;
		if (_tmp16_ > ((gdouble) 0)) {
			cairo_t* _tmp17_;
			gdouble _tmp18_;
			_tmp17_ = cr;
			_tmp18_ = self->priv->_draw_angle;
			cairo_arc (_tmp17_, (gdouble) center_x, (gdouble) center_y, arc_radius, BREAK_TIMER_SETTINGS_WIDGETS_CIRCLE_COUNTER_ANGLE_OFFSET, BREAK_TIMER_SETTINGS_WIDGETS_CIRCLE_COUNTER_ANGLE_OFFSET - _tmp18_);
		} else {
			cairo_t* _tmp19_;
			_tmp19_ = cr;
			cairo_arc (_tmp19_, (gdouble) center_x, (gdouble) center_y, arc_radius, BREAK_TIMER_SETTINGS_WIDGETS_CIRCLE_COUNTER_ANGLE_OFFSET, BREAK_TIMER_SETTINGS_WIDGETS_CIRCLE_COUNTER_ANGLE_OFFSET + (G_PI * 2.0));
		}
	} else {
		gdouble _tmp20_;
		_tmp20_ = self->priv->_draw_angle;
		if (_tmp20_ > ((gdouble) 0)) {
			cairo_t* _tmp21_;
			gdouble _tmp22_;
			_tmp21_ = cr;
			_tmp22_ = self->priv->_draw_angle;
			cairo_arc_negative (_tmp21_, (gdouble) center_x, (gdouble) center_y, arc_radius, BREAK_TIMER_SETTINGS_WIDGETS_CIRCLE_COUNTER_ANGLE_OFFSET, BREAK_TIMER_SETTINGS_WIDGETS_CIRCLE_COUNTER_ANGLE_OFFSET - _tmp22_);
		}
	}
	_tmp23_ = cr;
	cairo_set_line_width (_tmp23_, BREAK_TIMER_SETTINGS_WIDGETS_CIRCLE_COUNTER_LINE_WIDTH);
	_tmp24_ = cr;
	cairo_set_line_cap (_tmp24_, CAIRO_LINE_CAP_SQUARE);
	_tmp25_ = cr;
	cairo_push_group (_tmp25_);
	_tmp26_ = cr;
	cairo_stroke (_tmp26_);
	_tmp27_ = cr;
	cairo_pop_group_to_source (_tmp27_);
	_tmp28_ = cr;
	cairo_paint_with_alpha (_tmp28_, 0.7);
	_cairo_destroy0 (cr);
}

static void
break_timer_settings_widgets_circle_counter_real_measure (GtkWidget* base,
                                                          GtkOrientation orientation,
                                                          gint for_size,
                                                          gint* minimum,
                                                          gint* natural,
                                                          gint* minimum_baseline,
                                                          gint* natural_baseline)
{
	BreakTimerSettingsWidgetsCircleCounter * self;
	gint _vala_minimum = 0;
	gint _vala_natural = 0;
	gint _vala_minimum_baseline = 0;
	gint _vala_natural_baseline = 0;
	gint diameter = 0;
	self = (BreakTimerSettingsWidgetsCircleCounter*) base;
	diameter = break_timer_settings_widgets_circle_counter_calculate_diameter (self);
	_vala_minimum = diameter;
	_vala_natural = diameter;
	_vala_minimum_baseline = -1;
	_vala_natural_baseline = -1;
	if (minimum) {
		*minimum = _vala_minimum;
	}
	if (natural) {
		*natural = _vala_natural;
	}
	if (minimum_baseline) {
		*minimum_baseline = _vala_minimum_baseline;
	}
	if (natural_baseline) {
		*natural_baseline = _vala_natural_baseline;
	}
}

static gint
break_timer_settings_widgets_circle_counter_calculate_diameter (BreakTimerSettingsWidgetsCircleCounter* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = 2 * BREAK_TIMER_SETTINGS_WIDGETS_CIRCLE_COUNTER_DEFAULT_RADIUS;
	return result;
}

BreakTimerSettingsWidgetsCircleCounterDirection
break_timer_settings_widgets_circle_counter_get_direction (BreakTimerSettingsWidgetsCircleCounter* self)
{
	BreakTimerSettingsWidgetsCircleCounterDirection result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_direction;
	return result;
}

void
break_timer_settings_widgets_circle_counter_set_direction (BreakTimerSettingsWidgetsCircleCounter* self,
                                                           BreakTimerSettingsWidgetsCircleCounterDirection value)
{
	BreakTimerSettingsWidgetsCircleCounterDirection old_value;
	g_return_if_fail (self != NULL);
	old_value = break_timer_settings_widgets_circle_counter_get_direction (self);
	if (old_value != value) {
		self->priv->_direction = value;
		g_object_notify_by_pspec ((GObject *) self, break_timer_settings_widgets_circle_counter_properties[BREAK_TIMER_SETTINGS_WIDGETS_CIRCLE_COUNTER_DIRECTION_PROPERTY]);
	}
}

gdouble
break_timer_settings_widgets_circle_counter_get_progress (BreakTimerSettingsWidgetsCircleCounter* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_progress;
	return result;
}

void
break_timer_settings_widgets_circle_counter_set_progress (BreakTimerSettingsWidgetsCircleCounter* self,
                                                          gdouble value)
{
	gdouble old_value;
	g_return_if_fail (self != NULL);
	old_value = break_timer_settings_widgets_circle_counter_get_progress (self);
	if (old_value != value) {
		self->priv->_progress = value;
		g_object_notify_by_pspec ((GObject *) self, break_timer_settings_widgets_circle_counter_properties[BREAK_TIMER_SETTINGS_WIDGETS_CIRCLE_COUNTER_PROGRESS_PROPERTY]);
	}
}

gdouble
break_timer_settings_widgets_circle_counter_get_draw_angle (BreakTimerSettingsWidgetsCircleCounter* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_draw_angle;
	return result;
}

void
break_timer_settings_widgets_circle_counter_set_draw_angle (BreakTimerSettingsWidgetsCircleCounter* self,
                                                            gdouble value)
{
	gdouble old_value;
	g_return_if_fail (self != NULL);
	old_value = break_timer_settings_widgets_circle_counter_get_draw_angle (self);
	if (old_value != value) {
		self->priv->_draw_angle = value;
		g_object_notify_by_pspec ((GObject *) self, break_timer_settings_widgets_circle_counter_properties[BREAK_TIMER_SETTINGS_WIDGETS_CIRCLE_COUNTER_DRAW_ANGLE_PROPERTY]);
	}
}

static void
break_timer_settings_widgets_circle_counter_class_init (BreakTimerSettingsWidgetsCircleCounterClass * klass,
                                                        gpointer klass_data)
{
	break_timer_settings_widgets_circle_counter_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BreakTimerSettingsWidgetsCircleCounter_private_offset);
	((GtkWidgetClass *) klass)->snapshot = (void (*) (GtkWidget*, GtkSnapshot*)) break_timer_settings_widgets_circle_counter_real_snapshot;
	((GtkWidgetClass *) klass)->measure = (void (*) (GtkWidget*, GtkOrientation, gint, gint*, gint*, gint*, gint*)) break_timer_settings_widgets_circle_counter_real_measure;
	G_OBJECT_CLASS (klass)->get_property = _vala_break_timer_settings_widgets_circle_counter_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_break_timer_settings_widgets_circle_counter_set_property;
	G_OBJECT_CLASS (klass)->finalize = break_timer_settings_widgets_circle_counter_finalize;
	/**
	     * The direction of the countdown.
	     * COUNT_DOWN: a full circle that disappears as progress increases
	     * COUNT_UP: a circle gradually appears as progress increases
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), BREAK_TIMER_SETTINGS_WIDGETS_CIRCLE_COUNTER_DIRECTION_PROPERTY, break_timer_settings_widgets_circle_counter_properties[BREAK_TIMER_SETTINGS_WIDGETS_CIRCLE_COUNTER_DIRECTION_PROPERTY] = g_param_spec_enum ("direction", "direction", "direction", BREAK_TIMER_SETTINGS_WIDGETS_CIRCLE_COUNTER_TYPE_DIRECTION, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	     * A value from 0.0 to 1.0, where 1.0 means the count is finished. The
	     * circle will be filled by this amount according to the direction
	     * property.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), BREAK_TIMER_SETTINGS_WIDGETS_CIRCLE_COUNTER_PROGRESS_PROPERTY, break_timer_settings_widgets_circle_counter_properties[BREAK_TIMER_SETTINGS_WIDGETS_CIRCLE_COUNTER_PROGRESS_PROPERTY] = g_param_spec_double ("progress", "progress", "progress", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BREAK_TIMER_SETTINGS_WIDGETS_CIRCLE_COUNTER_DRAW_ANGLE_PROPERTY, break_timer_settings_widgets_circle_counter_properties[BREAK_TIMER_SETTINGS_WIDGETS_CIRCLE_COUNTER_DRAW_ANGLE_PROPERTY] = g_param_spec_double ("draw-angle", "draw-angle", "draw-angle", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
break_timer_settings_widgets_circle_counter_instance_init (BreakTimerSettingsWidgetsCircleCounter * self,
                                                           gpointer klass)
{
	self->priv = break_timer_settings_widgets_circle_counter_get_instance_private (self);
	self->priv->first_frame = TRUE;
}

static void
break_timer_settings_widgets_circle_counter_finalize (GObject * obj)
{
	BreakTimerSettingsWidgetsCircleCounter * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BREAK_TIMER_SETTINGS_WIDGETS_TYPE_CIRCLE_COUNTER, BreakTimerSettingsWidgetsCircleCounter);
	_g_object_unref0 (self->priv->draw_angle_transition);
	G_OBJECT_CLASS (break_timer_settings_widgets_circle_counter_parent_class)->finalize (obj);
}

/**
 * Displays a countdown using a circle, reminiscent of a countdown timer.
 * This widget can either count down or up, and it can switch between either
 * direction at any time.
 */
static GType
break_timer_settings_widgets_circle_counter_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BreakTimerSettingsWidgetsCircleCounterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) break_timer_settings_widgets_circle_counter_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BreakTimerSettingsWidgetsCircleCounter), 0, (GInstanceInitFunc) break_timer_settings_widgets_circle_counter_instance_init, NULL };
	GType break_timer_settings_widgets_circle_counter_type_id;
	break_timer_settings_widgets_circle_counter_type_id = g_type_register_static (gtk_widget_get_type (), "BreakTimerSettingsWidgetsCircleCounter", &g_define_type_info, 0);
	BreakTimerSettingsWidgetsCircleCounter_private_offset = g_type_add_instance_private (break_timer_settings_widgets_circle_counter_type_id, sizeof (BreakTimerSettingsWidgetsCircleCounterPrivate));
	return break_timer_settings_widgets_circle_counter_type_id;
}

GType
break_timer_settings_widgets_circle_counter_get_type (void)
{
	static volatile gsize break_timer_settings_widgets_circle_counter_type_id__once = 0;
	if (g_once_init_enter (&break_timer_settings_widgets_circle_counter_type_id__once)) {
		GType break_timer_settings_widgets_circle_counter_type_id;
		break_timer_settings_widgets_circle_counter_type_id = break_timer_settings_widgets_circle_counter_get_type_once ();
		g_once_init_leave (&break_timer_settings_widgets_circle_counter_type_id__once, break_timer_settings_widgets_circle_counter_type_id);
	}
	return break_timer_settings_widgets_circle_counter_type_id__once;
}

static void
_vala_break_timer_settings_widgets_circle_counter_get_property (GObject * object,
                                                                guint property_id,
                                                                GValue * value,
                                                                GParamSpec * pspec)
{
	BreakTimerSettingsWidgetsCircleCounter * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BREAK_TIMER_SETTINGS_WIDGETS_TYPE_CIRCLE_COUNTER, BreakTimerSettingsWidgetsCircleCounter);
	switch (property_id) {
		case BREAK_TIMER_SETTINGS_WIDGETS_CIRCLE_COUNTER_DIRECTION_PROPERTY:
		g_value_set_enum (value, break_timer_settings_widgets_circle_counter_get_direction (self));
		break;
		case BREAK_TIMER_SETTINGS_WIDGETS_CIRCLE_COUNTER_PROGRESS_PROPERTY:
		g_value_set_double (value, break_timer_settings_widgets_circle_counter_get_progress (self));
		break;
		case BREAK_TIMER_SETTINGS_WIDGETS_CIRCLE_COUNTER_DRAW_ANGLE_PROPERTY:
		g_value_set_double (value, break_timer_settings_widgets_circle_counter_get_draw_angle (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_break_timer_settings_widgets_circle_counter_set_property (GObject * object,
                                                                guint property_id,
                                                                const GValue * value,
                                                                GParamSpec * pspec)
{
	BreakTimerSettingsWidgetsCircleCounter * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BREAK_TIMER_SETTINGS_WIDGETS_TYPE_CIRCLE_COUNTER, BreakTimerSettingsWidgetsCircleCounter);
	switch (property_id) {
		case BREAK_TIMER_SETTINGS_WIDGETS_CIRCLE_COUNTER_DIRECTION_PROPERTY:
		break_timer_settings_widgets_circle_counter_set_direction (self, g_value_get_enum (value));
		break;
		case BREAK_TIMER_SETTINGS_WIDGETS_CIRCLE_COUNTER_PROGRESS_PROPERTY:
		break_timer_settings_widgets_circle_counter_set_progress (self, g_value_get_double (value));
		break;
		case BREAK_TIMER_SETTINGS_WIDGETS_CIRCLE_COUNTER_DRAW_ANGLE_PROPERTY:
		break_timer_settings_widgets_circle_counter_set_draw_angle (self, g_value_get_double (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

