/* WindowCloneContainer.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from WindowCloneContainer.vala, do not modify */

/*
 * SPDX-License-Identifier: GPL-3.0-or-later
 * SPDX-FileCopyrightText: 2014 Tom Beckmann
 *                         2025 elementary, Inc. (https://elementary.io)
 */

#include <clutter/clutter.h>
#include <glib-object.h>
#include "gala.h"
#include <glib.h>
#include <float.h>
#include <math.h>
#include <meta/window.h>
#include <meta/display.h>
#include <meta/meta-plugin.h>
#include <meta/common.h>
#include <mtk/mtk.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define GALA_TYPE_GESTURE_TARGET (gala_gesture_target_get_type ())
#define GALA_GESTURE_TARGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_GESTURE_TARGET, GalaGestureTarget))
#define GALA_IS_GESTURE_TARGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_GESTURE_TARGET))
#define GALA_GESTURE_TARGET_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GALA_TYPE_GESTURE_TARGET, GalaGestureTargetIface))

typedef struct _GalaGestureTarget GalaGestureTarget;
typedef struct _GalaGestureTargetIface GalaGestureTargetIface;
typedef enum  {
	GALA_GESTURE_TARGET_UPDATE_TYPE_START,
	GALA_GESTURE_TARGET_UPDATE_TYPE_UPDATE,
	GALA_GESTURE_TARGET_UPDATE_TYPE_COMMIT,
	GALA_GESTURE_TARGET_UPDATE_TYPE_END
} GalaGestureTargetUpdateType;

#define GALA_GESTURE_TARGET_TYPE_UPDATE_TYPE (gala_gesture_target_update_type_get_type ())

#define GALA_TYPE_ACTOR_TARGET (gala_actor_target_get_type ())
#define GALA_ACTOR_TARGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_ACTOR_TARGET, GalaActorTarget))
#define GALA_ACTOR_TARGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_ACTOR_TARGET, GalaActorTargetClass))
#define GALA_IS_ACTOR_TARGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_ACTOR_TARGET))
#define GALA_IS_ACTOR_TARGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_ACTOR_TARGET))
#define GALA_ACTOR_TARGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_ACTOR_TARGET, GalaActorTargetClass))

typedef struct _GalaActorTarget GalaActorTarget;
typedef struct _GalaActorTargetClass GalaActorTargetClass;
typedef struct _GalaActorTargetPrivate GalaActorTargetPrivate;

#define GALA_TYPE_WINDOW_CLONE_CONTAINER (gala_window_clone_container_get_type ())
#define GALA_WINDOW_CLONE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_WINDOW_CLONE_CONTAINER, GalaWindowCloneContainer))
#define GALA_WINDOW_CLONE_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_WINDOW_CLONE_CONTAINER, GalaWindowCloneContainerClass))
#define GALA_IS_WINDOW_CLONE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_WINDOW_CLONE_CONTAINER))
#define GALA_IS_WINDOW_CLONE_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_WINDOW_CLONE_CONTAINER))
#define GALA_WINDOW_CLONE_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_WINDOW_CLONE_CONTAINER, GalaWindowCloneContainerClass))

typedef struct _GalaWindowCloneContainer GalaWindowCloneContainer;
typedef struct _GalaWindowCloneContainerClass GalaWindowCloneContainerClass;
typedef struct _GalaWindowCloneContainerPrivate GalaWindowCloneContainerPrivate;

#define GALA_TYPE_WINDOW_CLONE (gala_window_clone_get_type ())
#define GALA_WINDOW_CLONE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_WINDOW_CLONE, GalaWindowClone))
#define GALA_WINDOW_CLONE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_WINDOW_CLONE, GalaWindowCloneClass))
#define GALA_IS_WINDOW_CLONE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_WINDOW_CLONE))
#define GALA_IS_WINDOW_CLONE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_WINDOW_CLONE))
#define GALA_WINDOW_CLONE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_WINDOW_CLONE, GalaWindowCloneClass))

typedef struct _GalaWindowClone GalaWindowClone;
typedef struct _GalaWindowCloneClass GalaWindowCloneClass;
enum  {
	GALA_WINDOW_CLONE_CONTAINER_0_PROPERTY,
	GALA_WINDOW_CLONE_CONTAINER_PADDING_TOP_PROPERTY,
	GALA_WINDOW_CLONE_CONTAINER_PADDING_LEFT_PROPERTY,
	GALA_WINDOW_CLONE_CONTAINER_PADDING_RIGHT_PROPERTY,
	GALA_WINDOW_CLONE_CONTAINER_PADDING_BOTTOM_PROPERTY,
	GALA_WINDOW_CLONE_CONTAINER_WM_PROPERTY,
	GALA_WINDOW_CLONE_CONTAINER_OVERVIEW_MODE_PROPERTY,
	GALA_WINDOW_CLONE_CONTAINER_MONITOR_SCALE_PROPERTY,
	GALA_WINDOW_CLONE_CONTAINER_NUM_PROPERTIES
};
static GParamSpec* gala_window_clone_container_properties[GALA_WINDOW_CLONE_CONTAINER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define GALA_INTERNAL_UTILS_TYPE_TILABLE_WINDOW (gala_internal_utils_tilable_window_get_type ())
typedef struct _GalaInternalUtilsTilableWindow GalaInternalUtilsTilableWindow;
#define _gala_internal_utils_tilable_window_free0(var) ((var == NULL) ? NULL : (var = (gala_internal_utils_tilable_window_free (var), NULL)))
#define __vala_MtkRectangle_free0(var) ((var == NULL) ? NULL : (var = (_vala_MtkRectangle_free (var), NULL)))
enum  {
	GALA_WINDOW_CLONE_CONTAINER_WINDOW_SELECTED_SIGNAL,
	GALA_WINDOW_CLONE_CONTAINER_REQUESTED_CLOSE_SIGNAL,
	GALA_WINDOW_CLONE_CONTAINER_LAST_WINDOW_CLOSED_SIGNAL,
	GALA_WINDOW_CLONE_CONTAINER_NUM_SIGNALS
};
static guint gala_window_clone_container_signals[GALA_WINDOW_CLONE_CONTAINER_NUM_SIGNALS] = {0};

struct _GalaGestureTargetIface {
	GTypeInterface parent_iface;
	void (*propagate) (GalaGestureTarget* self, GalaGestureTargetUpdateType update_type, GalaGestureAction action, gdouble progress);
	ClutterActor* (*get_actor) (GalaGestureTarget* self);
};

struct _GalaActorTarget {
	ClutterActor parent_instance;
	GalaActorTargetPrivate * priv;
};

struct _GalaActorTargetClass {
	ClutterActorClass parent_class;
	void (*start_progress) (GalaActorTarget* self, GalaGestureAction action);
	void (*update_progress) (GalaActorTarget* self, GalaGestureAction action, gdouble progress);
	void (*commit_progress) (GalaActorTarget* self, GalaGestureAction action, gdouble to);
	void (*end_progress) (GalaActorTarget* self, GalaGestureAction action);
};

struct _GalaWindowCloneContainer {
	GalaActorTarget parent_instance;
	GalaWindowCloneContainerPrivate * priv;
};

struct _GalaWindowCloneContainerClass {
	GalaActorTargetClass parent_class;
};

struct _GalaWindowCloneContainerPrivate {
	gint _padding_top;
	gint _padding_left;
	gint _padding_right;
	gint _padding_bottom;
	GalaWindowManager* _wm;
	gboolean _overview_mode;
	gfloat _monitor_scale;
	gboolean opened;
	GalaWindowClone* current_window;
};

struct _GalaInternalUtilsTilableWindow {
	MtkRectangle rect;
	GalaWindowClone* id;
};

static gint GalaWindowCloneContainer_private_offset;
static gpointer gala_window_clone_container_parent_class = NULL;

VALA_EXTERN GType gala_gesture_target_update_type_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType gala_gesture_target_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaGestureTarget, g_object_unref)
VALA_EXTERN GType gala_actor_target_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaActorTarget, g_object_unref)
VALA_EXTERN GType gala_window_clone_container_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaWindowCloneContainer, g_object_unref)
VALA_EXTERN GType gala_window_clone_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaWindowClone, g_object_unref)
VALA_EXTERN void gala_actor_target_start_progress (GalaActorTarget* self,
                                       GalaGestureAction action);
VALA_EXTERN void gala_actor_target_commit_progress (GalaActorTarget* self,
                                        GalaGestureAction action,
                                        gdouble to);
VALA_EXTERN GalaWindowCloneContainer* gala_window_clone_container_new (GalaWindowManager* wm,
                                                           gfloat monitor_scale,
                                                           gboolean overview_mode);
VALA_EXTERN GalaWindowCloneContainer* gala_window_clone_container_construct (GType object_type,
                                                                 GalaWindowManager* wm,
                                                                 gfloat monitor_scale,
                                                                 gboolean overview_mode);
VALA_EXTERN void gala_window_clone_container_add_window (GalaWindowCloneContainer* self,
                                             MetaWindow* window);
VALA_EXTERN MetaWindow* gala_window_clone_get_window (GalaWindowClone* self);
VALA_EXTERN GalaWindowManager* gala_window_clone_container_get_wm (GalaWindowCloneContainer* self);
VALA_EXTERN GSList* gala_internal_utils_sort_windows (MetaDisplay* display,
                                          GList* windows);
VALA_EXTERN gfloat gala_window_clone_container_get_monitor_scale (GalaWindowCloneContainer* self);
VALA_EXTERN gboolean gala_window_clone_container_get_overview_mode (GalaWindowCloneContainer* self);
VALA_EXTERN GalaWindowClone* gala_window_clone_new (GalaWindowManager* wm,
                                        MetaWindow* window,
                                        gfloat monitor_scale,
                                        gboolean overview_mode);
VALA_EXTERN GalaWindowClone* gala_window_clone_construct (GType object_type,
                                              GalaWindowManager* wm,
                                              MetaWindow* window,
                                              gfloat monitor_scale,
                                              gboolean overview_mode);
static void __lambda62_ (GalaWindowCloneContainer* self,
                  GalaWindowClone* clone);
static void ___lambda62__gala_window_clone_selected (GalaWindowClone* _sender,
                                              gpointer self);
static void __lambda63_ (GalaWindowCloneContainer* self,
                  ClutterActor* _new_window);
VALA_EXTERN void gala_window_clone_container_select_next_window (GalaWindowCloneContainer* self,
                                                     MetaMotionDirection direction,
                                                     gboolean user_action);
static void gala_window_clone_container_reflow (GalaWindowCloneContainer* self,
                                         gboolean view_toggle);
static void ___lambda63__clutter_actor_destroy (ClutterActor* _sender,
                                         gpointer self);
static void __lambda65_ (GalaWindowCloneContainer* self);
static void ___lambda65__gala_window_clone_request_reposition (GalaWindowClone* _sender,
                                                        gpointer self);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
VALA_EXTERN void gala_window_clone_container_remove_window (GalaWindowCloneContainer* self,
                                                MetaWindow* window);
static void gala_window_clone_container_restack_windows (GalaWindowCloneContainer* self);
VALA_EXTERN GType gala_internal_utils_tilable_window_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GalaInternalUtilsTilableWindow* gala_internal_utils_tilable_window_dup (const GalaInternalUtilsTilableWindow* self);
VALA_EXTERN void gala_internal_utils_tilable_window_free (GalaInternalUtilsTilableWindow* self);
static void _gala_internal_utils_tilable_window_free0_ (gpointer var);
static inline void _g_list_free__gala_internal_utils_tilable_window_free0_ (GList* self);
static gint __lambda64_ (GalaInternalUtilsTilableWindow* a,
                  GalaInternalUtilsTilableWindow* b);
static gint ___lambda64__gcompare_func (gconstpointer a,
                                 gconstpointer b);
VALA_EXTERN gint gala_window_clone_container_get_padding_left (GalaWindowCloneContainer* self);
VALA_EXTERN gint gala_window_clone_container_get_padding_top (GalaWindowCloneContainer* self);
VALA_EXTERN gint gala_window_clone_container_get_padding_right (GalaWindowCloneContainer* self);
VALA_EXTERN gint gala_window_clone_container_get_padding_bottom (GalaWindowCloneContainer* self);
VALA_EXTERN GList* gala_internal_utils_calculate_grid_placement (MtkRectangle* area,
                                                     GList* windows);
VALA_EXTERN void gala_window_clone_take_slot (GalaWindowClone* self,
                                  MtkRectangle* rect,
                                  gboolean animate);
static gboolean gala_window_clone_container_real_key_press_event (ClutterActor* base,
                                                           ClutterEvent* event);
VALA_EXTERN gboolean gala_window_clone_container_activate_selected_window (GalaWindowCloneContainer* self);
VALA_EXTERN MtkRectangle* gala_window_clone_get_slot (GalaWindowClone* self);
static MtkRectangle* _vala_MtkRectangle_copy (MtkRectangle* self);
static void _vala_MtkRectangle_free (MtkRectangle* self);
VALA_EXTERN void gala_internal_utils_bell_notify (MetaDisplay* display);
VALA_EXTERN void gala_window_clone_set_active (GalaWindowClone* self,
                                   gboolean value);
static void gala_window_clone_container_real_start_progress (GalaActorTarget* base,
                                                      GalaGestureAction action);
static void gala_window_clone_container_real_commit_progress (GalaActorTarget* base,
                                                       GalaGestureAction action,
                                                       gdouble to);
VALA_EXTERN gdouble gala_actor_target_get_current_commit (GalaActorTarget* self,
                                              GalaGestureAction action);
VALA_EXTERN void gala_window_clone_container_set_padding_top (GalaWindowCloneContainer* self,
                                                  gint value);
VALA_EXTERN void gala_window_clone_container_set_padding_left (GalaWindowCloneContainer* self,
                                                   gint value);
VALA_EXTERN void gala_window_clone_container_set_padding_right (GalaWindowCloneContainer* self,
                                                    gint value);
VALA_EXTERN void gala_window_clone_container_set_padding_bottom (GalaWindowCloneContainer* self,
                                                     gint value);
static void gala_window_clone_container_set_wm (GalaWindowCloneContainer* self,
                                         GalaWindowManager* value);
static void gala_window_clone_container_set_overview_mode (GalaWindowCloneContainer* self,
                                                    gboolean value);
VALA_EXTERN void gala_window_clone_container_set_monitor_scale (GalaWindowCloneContainer* self,
                                                    gfloat value);
static void gala_window_clone_container_finalize (GObject * obj);
static GType gala_window_clone_container_get_type_once (void);
static void _vala_gala_window_clone_container_get_property (GObject * object,
                                                     guint property_id,
                                                     GValue * value,
                                                     GParamSpec * pspec);
static void _vala_gala_window_clone_container_set_property (GObject * object,
                                                     guint property_id,
                                                     const GValue * value,
                                                     GParamSpec * pspec);

static inline gpointer
gala_window_clone_container_get_instance_private (GalaWindowCloneContainer* self)
{
	return G_STRUCT_MEMBER_P (self, GalaWindowCloneContainer_private_offset);
}

GalaWindowCloneContainer*
gala_window_clone_container_construct (GType object_type,
                                       GalaWindowManager* wm,
                                       gfloat monitor_scale,
                                       gboolean overview_mode)
{
	GalaWindowCloneContainer * self = NULL;
	g_return_val_if_fail (wm != NULL, NULL);
	self = (GalaWindowCloneContainer*) g_object_new (object_type, "wm", wm, "monitor-scale", monitor_scale, "overview-mode", overview_mode, NULL);
	return self;
}

GalaWindowCloneContainer*
gala_window_clone_container_new (GalaWindowManager* wm,
                                 gfloat monitor_scale,
                                 gboolean overview_mode)
{
	return gala_window_clone_container_construct (GALA_TYPE_WINDOW_CLONE_CONTAINER, wm, monitor_scale, overview_mode);
}

/**
     * Create a WindowClone for a MetaWindow and add it to the group
     *
     * @param window The window for which to create the WindowClone for
     */
static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
__lambda62_ (GalaWindowCloneContainer* self,
             GalaWindowClone* clone)
{
	MetaWindow* _tmp0_;
	MetaWindow* _tmp1_;
	g_return_if_fail (clone != NULL);
	_tmp0_ = gala_window_clone_get_window (clone);
	_tmp1_ = _tmp0_;
	g_signal_emit (self, gala_window_clone_container_signals[GALA_WINDOW_CLONE_CONTAINER_WINDOW_SELECTED_SIGNAL], 0, _tmp1_);
}

static void
___lambda62__gala_window_clone_selected (GalaWindowClone* _sender,
                                         gpointer self)
{
	__lambda62_ ((GalaWindowCloneContainer*) self, _sender);
}

static void
__lambda63_ (GalaWindowCloneContainer* self,
             ClutterActor* _new_window)
{
	GalaWindowClone* _tmp0_;
	GalaWindowClone* _tmp1_;
	g_return_if_fail (_new_window != NULL);
	_tmp0_ = self->priv->current_window;
	if (_new_window == G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, clutter_actor_get_type (), ClutterActor)) {
		gala_window_clone_container_select_next_window (self, META_MOTION_RIGHT, FALSE);
	}
	_tmp1_ = self->priv->current_window;
	if (_new_window == G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, clutter_actor_get_type (), ClutterActor)) {
		self->priv->current_window = NULL;
	}
	gala_window_clone_container_reflow (self, FALSE);
}

static void
___lambda63__clutter_actor_destroy (ClutterActor* _sender,
                                    gpointer self)
{
	__lambda63_ ((GalaWindowCloneContainer*) self, _sender);
}

static void
__lambda65_ (GalaWindowCloneContainer* self)
{
	gala_window_clone_container_reflow (self, FALSE);
}

static void
___lambda65__gala_window_clone_request_reposition (GalaWindowClone* _sender,
                                                   gpointer self)
{
	__lambda65_ ((GalaWindowCloneContainer*) self);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

void
gala_window_clone_container_add_window (GalaWindowCloneContainer* self,
                                        MetaWindow* window)
{
	GList* windows = NULL;
	GList* _tmp0_;
	MetaWindow* _tmp6_;
	MetaDisplay* display = NULL;
	GalaWindowManager* _tmp7_;
	MetaDisplay* _tmp8_;
	GSList* windows_ordered = NULL;
	MetaDisplay* _tmp9_;
	GList* _tmp10_;
	GSList* _tmp11_;
	GalaWindowClone* new_window = NULL;
	GalaWindowManager* _tmp12_;
	gfloat _tmp13_;
	gboolean _tmp14_;
	GalaWindowClone* _tmp15_;
	GalaWindowClone* _tmp16_;
	GalaWindowClone* _tmp17_;
	GalaWindowClone* _tmp18_;
	GalaWindowClone* _tmp19_;
	MetaWindow* target = NULL;
	GSList* _tmp20_;
	MetaWindow* _tmp23_;
	GList* _tmp25_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (window != NULL);
	windows = NULL;
	_tmp0_ = clutter_actor_get_children ((ClutterActor*) self);
	{
		GList* child_collection = NULL;
		GList* child_it = NULL;
		child_collection = _tmp0_;
		for (child_it = child_collection; child_it != NULL; child_it = child_it->next) {
			ClutterActor* child = NULL;
			child = (ClutterActor*) child_it->data;
			{
				GalaWindowClone* clone = NULL;
				ClutterActor* _tmp1_;
				GalaWindowClone* _tmp2_;
				MetaWindow* _tmp3_;
				MetaWindow* _tmp4_;
				MetaWindow* _tmp5_;
				_tmp1_ = child;
				clone = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GALA_TYPE_WINDOW_CLONE, GalaWindowClone);
				_tmp2_ = clone;
				_tmp3_ = gala_window_clone_get_window (_tmp2_);
				_tmp4_ = _tmp3_;
				_tmp5_ = _g_object_ref0 (_tmp4_);
				windows = g_list_append (windows, _tmp5_);
			}
		}
		(child_collection == NULL) ? NULL : (child_collection = (g_list_free (child_collection), NULL));
	}
	_tmp6_ = _g_object_ref0 (window);
	windows = g_list_append (windows, _tmp6_);
	_tmp7_ = self->priv->_wm;
	_tmp8_ = meta_plugin_get_display ((MetaPlugin*) _tmp7_);
	display = _tmp8_;
	_tmp9_ = display;
	_tmp10_ = windows;
	_tmp11_ = gala_internal_utils_sort_windows (_tmp9_, _tmp10_);
	windows_ordered = _tmp11_;
	_tmp12_ = self->priv->_wm;
	_tmp13_ = self->priv->_monitor_scale;
	_tmp14_ = self->priv->_overview_mode;
	_tmp15_ = gala_window_clone_new (_tmp12_, window, _tmp13_, _tmp14_);
	g_object_ref_sink (_tmp15_);
	new_window = _tmp15_;
	_tmp16_ = new_window;
	g_signal_connect_object (_tmp16_, "selected", (GCallback) ___lambda62__gala_window_clone_selected, self, 0);
	_tmp17_ = new_window;
	g_signal_connect_object ((ClutterActor*) _tmp17_, "destroy", (GCallback) ___lambda63__clutter_actor_destroy, self, 0);
	_tmp18_ = new_window;
	g_signal_connect_object (_tmp18_, "request-reposition", (GCallback) ___lambda65__gala_window_clone_request_reposition, self, 0);
	_tmp19_ = new_window;
	g_object_bind_property_with_closures ((GObject*) self, "monitor-scale", (GObject*) _tmp19_, "monitor-scale", G_BINDING_DEFAULT, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	target = NULL;
	_tmp20_ = windows_ordered;
	{
		GSList* w_collection = NULL;
		GSList* w_it = NULL;
		w_collection = _tmp20_;
		for (w_it = w_collection; w_it != NULL; w_it = w_it->next) {
			MetaWindow* w = NULL;
			w = (MetaWindow*) w_it->data;
			{
				MetaWindow* _tmp21_;
				_tmp21_ = w;
				if (_tmp21_ != window) {
					MetaWindow* _tmp22_;
					_tmp22_ = w;
					target = _tmp22_;
					continue;
				}
				break;
			}
		}
	}
	_tmp23_ = target;
	if (_tmp23_ == NULL) {
		GalaWindowClone* _tmp24_;
		_tmp24_ = new_window;
		clutter_actor_add_child ((ClutterActor*) self, (ClutterActor*) _tmp24_);
	}
	_tmp25_ = clutter_actor_get_children ((ClutterActor*) self);
	{
		GList* child_collection = NULL;
		GList* child_it = NULL;
		child_collection = _tmp25_;
		for (child_it = child_collection; child_it != NULL; child_it = child_it->next) {
			ClutterActor* child = NULL;
			child = (ClutterActor*) child_it->data;
			{
				GalaWindowClone* clone = NULL;
				ClutterActor* _tmp26_;
				MetaWindow* _tmp27_;
				GalaWindowClone* _tmp28_;
				MetaWindow* _tmp29_;
				MetaWindow* _tmp30_;
				_tmp26_ = child;
				clone = G_TYPE_CHECK_INSTANCE_CAST (_tmp26_, GALA_TYPE_WINDOW_CLONE, GalaWindowClone);
				_tmp27_ = target;
				_tmp28_ = clone;
				_tmp29_ = gala_window_clone_get_window (_tmp28_);
				_tmp30_ = _tmp29_;
				if (_tmp27_ == _tmp30_) {
					GalaWindowClone* _tmp31_;
					GalaWindowClone* _tmp32_;
					_tmp31_ = new_window;
					_tmp32_ = clone;
					clutter_actor_insert_child_below ((ClutterActor*) self, (ClutterActor*) _tmp31_, (ClutterActor*) _tmp32_);
					break;
				}
			}
		}
		(child_collection == NULL) ? NULL : (child_collection = (g_list_free (child_collection), NULL));
	}
	gala_window_clone_container_reflow (self, FALSE);
	_g_object_unref0 (new_window);
	(windows_ordered == NULL) ? NULL : (windows_ordered = (g_slist_free (windows_ordered), NULL));
	(windows == NULL) ? NULL : (windows = (_g_list_free__g_object_unref0_ (windows), NULL));
}

/**
     * Find and remove the WindowClone for a MetaWindow
     */
void
gala_window_clone_container_remove_window (GalaWindowCloneContainer* self,
                                           MetaWindow* window)
{
	GList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (window != NULL);
	_tmp0_ = clutter_actor_get_children ((ClutterActor*) self);
	{
		GList* child_collection = NULL;
		GList* child_it = NULL;
		child_collection = _tmp0_;
		for (child_it = child_collection; child_it != NULL; child_it = child_it->next) {
			ClutterActor* child = NULL;
			child = (ClutterActor*) child_it->data;
			{
				ClutterActor* _tmp1_;
				MetaWindow* _tmp2_;
				MetaWindow* _tmp3_;
				_tmp1_ = child;
				_tmp2_ = gala_window_clone_get_window (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GALA_TYPE_WINDOW_CLONE, GalaWindowClone));
				_tmp3_ = _tmp2_;
				if (_tmp3_ == window) {
					ClutterActor* _tmp4_;
					_tmp4_ = child;
					clutter_actor_remove_child ((ClutterActor*) self, _tmp4_);
					gala_window_clone_container_reflow (self, FALSE);
					break;
				}
			}
		}
		(child_collection == NULL) ? NULL : (child_collection = (g_list_free (child_collection), NULL));
	}
	if (clutter_actor_get_n_children ((ClutterActor*) self) == 0) {
		g_signal_emit (self, gala_window_clone_container_signals[GALA_WINDOW_CLONE_CONTAINER_LAST_WINDOW_CLOSED_SIGNAL], 0);
	}
}

/**
     * Sort the windows z-order by their actual stacking to make intersections
     * during animations correct.
     */
static void
gala_window_clone_container_restack_windows (GalaWindowCloneContainer* self)
{
	MetaDisplay* display = NULL;
	GalaWindowManager* _tmp0_;
	MetaDisplay* _tmp1_;
	GList* children = NULL;
	GList* _tmp2_;
	GList* windows = NULL;
	GList* _tmp3_;
	GSList* windows_ordered = NULL;
	MetaDisplay* _tmp8_;
	GList* _tmp9_;
	GSList* _tmp10_;
	gint i = 0;
	GSList* _tmp11_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_wm;
	_tmp1_ = meta_plugin_get_display ((MetaPlugin*) _tmp0_);
	display = _tmp1_;
	_tmp2_ = clutter_actor_get_children ((ClutterActor*) self);
	children = _tmp2_;
	windows = NULL;
	_tmp3_ = children;
	{
		GList* child_collection = NULL;
		GList* child_it = NULL;
		child_collection = _tmp3_;
		for (child_it = child_collection; child_it != NULL; child_it = child_it->next) {
			ClutterActor* child = NULL;
			child = (ClutterActor*) child_it->data;
			{
				ClutterActor* _tmp4_;
				MetaWindow* _tmp5_;
				MetaWindow* _tmp6_;
				MetaWindow* _tmp7_;
				_tmp4_ = child;
				_tmp5_ = gala_window_clone_get_window (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, GALA_TYPE_WINDOW_CLONE, GalaWindowClone));
				_tmp6_ = _tmp5_;
				_tmp7_ = _g_object_ref0 (_tmp6_);
				windows = g_list_prepend (windows, _tmp7_);
			}
		}
	}
	_tmp8_ = display;
	_tmp9_ = windows;
	_tmp10_ = gala_internal_utils_sort_windows (_tmp8_, _tmp9_);
	windows_ordered = _tmp10_;
	windows_ordered = g_slist_reverse (windows_ordered);
	i = 0;
	_tmp11_ = windows_ordered;
	{
		GSList* window_collection = NULL;
		GSList* window_it = NULL;
		window_collection = _tmp11_;
		for (window_it = window_collection; window_it != NULL; window_it = window_it->next) {
			MetaWindow* window = NULL;
			window = (MetaWindow*) window_it->data;
			{
				GList* _tmp12_;
				_tmp12_ = children;
				{
					GList* child_collection = NULL;
					GList* child_it = NULL;
					child_collection = _tmp12_;
					for (child_it = child_collection; child_it != NULL; child_it = child_it->next) {
						ClutterActor* child = NULL;
						child = (ClutterActor*) child_it->data;
						{
							ClutterActor* _tmp13_;
							MetaWindow* _tmp14_;
							MetaWindow* _tmp15_;
							MetaWindow* _tmp16_;
							_tmp13_ = child;
							_tmp14_ = gala_window_clone_get_window (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, GALA_TYPE_WINDOW_CLONE, GalaWindowClone));
							_tmp15_ = _tmp14_;
							_tmp16_ = window;
							if (_tmp15_ == _tmp16_) {
								ClutterActor* _tmp17_;
								ClutterActor* _tmp18_;
								gint _tmp19_;
								_tmp17_ = child;
								clutter_actor_set_child_at_index ((ClutterActor*) self, _tmp17_, i);
								_tmp18_ = child;
								children = g_list_remove (children, _tmp18_);
								_tmp19_ = i;
								i = _tmp19_ + 1;
								break;
							}
						}
					}
				}
			}
		}
	}
	(windows_ordered == NULL) ? NULL : (windows_ordered = (g_slist_free (windows_ordered), NULL));
	(windows == NULL) ? NULL : (windows = (_g_list_free__g_object_unref0_ (windows), NULL));
	(children == NULL) ? NULL : (children = (g_list_free (children), NULL));
}

/**
     * Recalculate the tiling positions of the windows and animate them to
     * the resulting spots.
     */
static gpointer
_gala_internal_utils_tilable_window_dup0 (gpointer self)
{
	return self ? gala_internal_utils_tilable_window_dup (self) : NULL;
}

static inline gboolean
vala_g_list_is_empty (GList* self)
{
	gboolean result;
	result = ((GList*) self) == NULL;
	return result;
}

static void
_gala_internal_utils_tilable_window_free0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (gala_internal_utils_tilable_window_free (var), NULL));
}

static inline void
_g_list_free__gala_internal_utils_tilable_window_free0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _gala_internal_utils_tilable_window_free0_);
}

static gint
__lambda64_ (GalaInternalUtilsTilableWindow* a,
             GalaInternalUtilsTilableWindow* b)
{
	guint seq_a = 0U;
	GalaWindowClone* _tmp0_;
	MetaWindow* _tmp1_;
	MetaWindow* _tmp2_;
	guint seq_b = 0U;
	GalaWindowClone* _tmp3_;
	MetaWindow* _tmp4_;
	MetaWindow* _tmp5_;
	gint result;
	_tmp0_ = (*a).id;
	_tmp1_ = gala_window_clone_get_window (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GALA_TYPE_WINDOW_CLONE, GalaWindowClone));
	_tmp2_ = _tmp1_;
	seq_a = meta_window_get_stable_sequence (_tmp2_);
	_tmp3_ = (*b).id;
	_tmp4_ = gala_window_clone_get_window (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GALA_TYPE_WINDOW_CLONE, GalaWindowClone));
	_tmp5_ = _tmp4_;
	seq_b = meta_window_get_stable_sequence (_tmp5_);
	result = (gint) (seq_b - seq_a);
	return result;
}

static gint
___lambda64__gcompare_func (gconstpointer a,
                            gconstpointer b)
{
	gint result;
	result = __lambda64_ ((GalaInternalUtilsTilableWindow*) a, (GalaInternalUtilsTilableWindow*) b);
	return result;
}

static void
gala_window_clone_container_reflow (GalaWindowCloneContainer* self,
                                    gboolean view_toggle)
{
	GList* windows = NULL;
	GList* _tmp0_;
	GList* _tmp9_;
	MtkRectangle area = {0};
	gint _tmp10_;
	gint _tmp11_;
	gfloat _tmp12_;
	gfloat _tmp13_;
	gint _tmp14_;
	gint _tmp15_;
	gfloat _tmp16_;
	gfloat _tmp17_;
	gint _tmp18_;
	gint _tmp19_;
	MtkRectangle _tmp20_ = {0};
	GList* window_positions = NULL;
	MtkRectangle _tmp21_;
	GList* _tmp22_;
	GList* _tmp23_;
	GList* _tmp24_;
	g_return_if_fail (self != NULL);
	if (!self->priv->opened) {
		return;
	}
	windows = NULL;
	_tmp0_ = clutter_actor_get_children ((ClutterActor*) self);
	{
		GList* child_collection = NULL;
		GList* child_it = NULL;
		child_collection = _tmp0_;
		for (child_it = child_collection; child_it != NULL; child_it = child_it->next) {
			ClutterActor* child = NULL;
			child = (ClutterActor*) child_it->data;
			{
				GalaWindowClone* clone = NULL;
				ClutterActor* _tmp1_;
				GalaWindowClone* _tmp2_;
				MetaWindow* _tmp3_;
				MetaWindow* _tmp4_;
				MtkRectangle _tmp5_ = {0};
				GalaWindowClone* _tmp6_;
				GalaInternalUtilsTilableWindow _tmp7_ = {0};
				GalaInternalUtilsTilableWindow* _tmp8_;
				_tmp1_ = child;
				clone = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GALA_TYPE_WINDOW_CLONE, GalaWindowClone);
				_tmp2_ = clone;
				_tmp3_ = gala_window_clone_get_window (_tmp2_);
				_tmp4_ = _tmp3_;
				meta_window_get_frame_rect (_tmp4_, &_tmp5_);
				_tmp6_ = clone;
				_tmp7_.rect = _tmp5_;
				_tmp7_.id = _tmp6_;
				_tmp8_ = _gala_internal_utils_tilable_window_dup0 (&_tmp7_);
				windows = g_list_prepend (windows, _tmp8_);
			}
		}
		(child_collection == NULL) ? NULL : (child_collection = (g_list_free (child_collection), NULL));
	}
	_tmp9_ = windows;
	if (vala_g_list_is_empty (_tmp9_)) {
		(windows == NULL) ? NULL : (windows = (_g_list_free__gala_internal_utils_tilable_window_free0_ (windows), NULL));
		return;
	}
	windows = g_list_sort (windows, ___lambda64__gcompare_func);
	_tmp10_ = self->priv->_padding_left;
	_tmp11_ = self->priv->_padding_top;
	_tmp12_ = clutter_actor_get_width ((ClutterActor*) self);
	_tmp13_ = _tmp12_;
	_tmp14_ = self->priv->_padding_left;
	_tmp15_ = self->priv->_padding_right;
	_tmp16_ = clutter_actor_get_height ((ClutterActor*) self);
	_tmp17_ = _tmp16_;
	_tmp18_ = self->priv->_padding_top;
	_tmp19_ = self->priv->_padding_bottom;
	_tmp20_.x = _tmp10_;
	_tmp20_.y = _tmp11_;
	_tmp20_.width = (((gint) _tmp13_) - _tmp14_) - _tmp15_;
	_tmp20_.height = (((gint) _tmp17_) - _tmp18_) - _tmp19_;
	area = _tmp20_;
	_tmp21_ = area;
	_tmp22_ = windows;
	_tmp23_ = gala_internal_utils_calculate_grid_placement (&_tmp21_, _tmp22_);
	window_positions = _tmp23_;
	_tmp24_ = window_positions;
	{
		GList* tilable_collection = NULL;
		GList* tilable_it = NULL;
		tilable_collection = _tmp24_;
		for (tilable_it = tilable_collection; tilable_it != NULL; tilable_it = tilable_it->next) {
			GalaInternalUtilsTilableWindow* _tmp25_;
			GalaInternalUtilsTilableWindow* tilable = NULL;
			_tmp25_ = _gala_internal_utils_tilable_window_dup0 ((GalaInternalUtilsTilableWindow*) tilable_it->data);
			tilable = _tmp25_;
			{
				GalaWindowClone* clone = NULL;
				GalaInternalUtilsTilableWindow* _tmp26_;
				GalaWindowClone* _tmp27_;
				GalaWindowClone* _tmp28_;
				GalaInternalUtilsTilableWindow* _tmp29_;
				MtkRectangle _tmp30_;
				_tmp26_ = tilable;
				_tmp27_ = (*_tmp26_).id;
				clone = G_TYPE_CHECK_INSTANCE_CAST (_tmp27_, GALA_TYPE_WINDOW_CLONE, GalaWindowClone);
				_tmp28_ = clone;
				_tmp29_ = tilable;
				_tmp30_ = (*_tmp29_).rect;
				gala_window_clone_take_slot (_tmp28_, &_tmp30_, !view_toggle);
				_gala_internal_utils_tilable_window_free0 (tilable);
			}
		}
	}
	(window_positions == NULL) ? NULL : (window_positions = (_g_list_free__gala_internal_utils_tilable_window_free0_ (window_positions), NULL));
	(windows == NULL) ? NULL : (windows = (_g_list_free__gala_internal_utils_tilable_window_free0_ (windows), NULL));
}

/**
     * Collect key events, mainly for redirecting them to the WindowCloneContainers to
     * select the active window.
     */
static gboolean
gala_window_clone_container_real_key_press_event (ClutterActor* base,
                                                  ClutterEvent* event)
{
	GalaWindowCloneContainer * self;
	gboolean result;
	self = (GalaWindowCloneContainer*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	if (!self->priv->opened) {
		result = CLUTTER_EVENT_PROPAGATE;
		return result;
	}
	switch (clutter_event_get_key_symbol (event)) {
		case CLUTTER_KEY_Escape:
		{
			g_signal_emit (self, gala_window_clone_container_signals[GALA_WINDOW_CLONE_CONTAINER_REQUESTED_CLOSE_SIGNAL], 0);
			break;
		}
		case CLUTTER_KEY_Down:
		{
			gala_window_clone_container_select_next_window (self, META_MOTION_DOWN, TRUE);
			break;
		}
		case CLUTTER_KEY_Up:
		{
			gala_window_clone_container_select_next_window (self, META_MOTION_UP, TRUE);
			break;
		}
		case CLUTTER_KEY_Left:
		{
			gala_window_clone_container_select_next_window (self, META_MOTION_LEFT, TRUE);
			break;
		}
		case CLUTTER_KEY_Right:
		{
			gala_window_clone_container_select_next_window (self, META_MOTION_RIGHT, TRUE);
			break;
		}
		case CLUTTER_KEY_Return:
		case CLUTTER_KEY_KP_Enter:
		{
			if (!gala_window_clone_container_activate_selected_window (self)) {
				g_signal_emit (self, gala_window_clone_container_signals[GALA_WINDOW_CLONE_CONTAINER_REQUESTED_CLOSE_SIGNAL], 0);
			}
			break;
		}
		default:
		break;
	}
	result = CLUTTER_EVENT_STOP;
	return result;
}

/**
     * Look for the next window in a direction and make this window the
     * new current_window. Used for keyboard navigation.
     *
     * @param direction The MetaMotionDirection in which to search for windows for.
     */
static MtkRectangle*
_vala_MtkRectangle_copy (MtkRectangle* self)
{
	return g_boxed_copy (mtk_rectangle_get_type (), self);
}

static gpointer
__vala_MtkRectangle_copy0 (gpointer self)
{
	return self ? _vala_MtkRectangle_copy (self) : NULL;
}

static void
_vala_MtkRectangle_free (MtkRectangle* self)
{
	g_boxed_free (mtk_rectangle_get_type (), self);
}

void
gala_window_clone_container_select_next_window (GalaWindowCloneContainer* self,
                                                MetaMotionDirection direction,
                                                gboolean user_action)
{
	MetaDisplay* display = NULL;
	GalaWindowManager* _tmp0_;
	MetaDisplay* _tmp1_;
	GalaWindowClone* closest = NULL;
	GalaWindowClone* _tmp2_;
	GalaWindowClone* _tmp85_;
	GalaWindowClone* _tmp90_;
	GalaWindowClone* _tmp93_;
	g_return_if_fail (self != NULL);
	if (clutter_actor_get_n_children ((ClutterActor*) self) < 1) {
		return;
	}
	_tmp0_ = self->priv->_wm;
	_tmp1_ = meta_plugin_get_display ((MetaPlugin*) _tmp0_);
	display = _tmp1_;
	closest = NULL;
	_tmp2_ = self->priv->current_window;
	if (_tmp2_ == NULL) {
		ClutterActor* _tmp3_;
		GalaWindowClone* _tmp4_;
		_tmp3_ = clutter_actor_get_child_at_index ((ClutterActor*) self, 0);
		_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GALA_TYPE_WINDOW_CLONE, GalaWindowClone));
		_g_object_unref0 (closest);
		closest = _tmp4_;
	} else {
		MtkRectangle* current_rect = NULL;
		GalaWindowClone* _tmp5_;
		MtkRectangle* _tmp6_;
		MtkRectangle* _tmp7_;
		MtkRectangle* _tmp8_;
		GList* _tmp9_;
		_tmp5_ = self->priv->current_window;
		_tmp6_ = gala_window_clone_get_slot (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = __vala_MtkRectangle_copy0 (_tmp7_);
		current_rect = _tmp8_;
		_tmp9_ = clutter_actor_get_children ((ClutterActor*) self);
		{
			GList* child_collection = NULL;
			GList* child_it = NULL;
			child_collection = _tmp9_;
			for (child_it = child_collection; child_it != NULL; child_it = child_it->next) {
				ClutterActor* child = NULL;
				child = (ClutterActor*) child_it->data;
				{
					ClutterActor* _tmp10_;
					GalaWindowClone* _tmp11_;
					MtkRectangle* window_rect = NULL;
					ClutterActor* _tmp12_;
					MtkRectangle* _tmp13_;
					MtkRectangle* _tmp14_;
					MtkRectangle* _tmp15_;
					MtkRectangle* _tmp16_;
					_tmp10_ = child;
					_tmp11_ = self->priv->current_window;
					if (_tmp10_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, clutter_actor_get_type (), ClutterActor)) {
						continue;
					}
					_tmp12_ = child;
					_tmp13_ = gala_window_clone_get_slot (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, GALA_TYPE_WINDOW_CLONE, GalaWindowClone));
					_tmp14_ = _tmp13_;
					_tmp15_ = __vala_MtkRectangle_copy0 (_tmp14_);
					window_rect = _tmp15_;
					_tmp16_ = window_rect;
					if (_tmp16_ == NULL) {
						__vala_MtkRectangle_free0 (window_rect);
						continue;
					}
					if (direction == META_MOTION_LEFT) {
						MtkRectangle* _tmp17_;
						MtkRectangle* _tmp18_;
						gboolean _tmp19_ = FALSE;
						MtkRectangle* _tmp20_;
						MtkRectangle* _tmp21_;
						MtkRectangle* _tmp22_;
						_tmp17_ = window_rect;
						_tmp18_ = current_rect;
						if ((*_tmp17_).x > (*_tmp18_).x) {
							__vala_MtkRectangle_free0 (window_rect);
							continue;
						}
						_tmp20_ = window_rect;
						_tmp21_ = window_rect;
						_tmp22_ = current_rect;
						if (((*_tmp20_).y + (*_tmp21_).height) > (*_tmp22_).y) {
							MtkRectangle* _tmp23_;
							MtkRectangle* _tmp24_;
							MtkRectangle* _tmp25_;
							_tmp23_ = window_rect;
							_tmp24_ = current_rect;
							_tmp25_ = current_rect;
							_tmp19_ = (*_tmp23_).y < ((*_tmp24_).y + (*_tmp25_).height);
						} else {
							_tmp19_ = FALSE;
						}
						if (_tmp19_) {
							gboolean _tmp26_ = FALSE;
							GalaWindowClone* _tmp27_;
							_tmp27_ = closest;
							if (_tmp27_ == NULL) {
								_tmp26_ = TRUE;
							} else {
								GalaWindowClone* _tmp28_;
								MtkRectangle* _tmp29_;
								MtkRectangle* _tmp30_;
								MtkRectangle* _tmp31_;
								_tmp28_ = closest;
								_tmp29_ = gala_window_clone_get_slot (_tmp28_);
								_tmp30_ = _tmp29_;
								_tmp31_ = window_rect;
								_tmp26_ = (*_tmp30_).x < (*_tmp31_).x;
							}
							if (_tmp26_) {
								ClutterActor* _tmp32_;
								GalaWindowClone* _tmp33_;
								_tmp32_ = child;
								_tmp33_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp32_, GALA_TYPE_WINDOW_CLONE, GalaWindowClone));
								_g_object_unref0 (closest);
								closest = _tmp33_;
							}
						}
					} else {
						if (direction == META_MOTION_RIGHT) {
							MtkRectangle* _tmp34_;
							MtkRectangle* _tmp35_;
							gboolean _tmp36_ = FALSE;
							MtkRectangle* _tmp37_;
							MtkRectangle* _tmp38_;
							MtkRectangle* _tmp39_;
							_tmp34_ = window_rect;
							_tmp35_ = current_rect;
							if ((*_tmp34_).x < (*_tmp35_).x) {
								__vala_MtkRectangle_free0 (window_rect);
								continue;
							}
							_tmp37_ = window_rect;
							_tmp38_ = window_rect;
							_tmp39_ = current_rect;
							if (((*_tmp37_).y + (*_tmp38_).height) > (*_tmp39_).y) {
								MtkRectangle* _tmp40_;
								MtkRectangle* _tmp41_;
								MtkRectangle* _tmp42_;
								_tmp40_ = window_rect;
								_tmp41_ = current_rect;
								_tmp42_ = current_rect;
								_tmp36_ = (*_tmp40_).y < ((*_tmp41_).y + (*_tmp42_).height);
							} else {
								_tmp36_ = FALSE;
							}
							if (_tmp36_) {
								gboolean _tmp43_ = FALSE;
								GalaWindowClone* _tmp44_;
								_tmp44_ = closest;
								if (_tmp44_ == NULL) {
									_tmp43_ = TRUE;
								} else {
									GalaWindowClone* _tmp45_;
									MtkRectangle* _tmp46_;
									MtkRectangle* _tmp47_;
									MtkRectangle* _tmp48_;
									_tmp45_ = closest;
									_tmp46_ = gala_window_clone_get_slot (_tmp45_);
									_tmp47_ = _tmp46_;
									_tmp48_ = window_rect;
									_tmp43_ = (*_tmp47_).x > (*_tmp48_).x;
								}
								if (_tmp43_) {
									ClutterActor* _tmp49_;
									GalaWindowClone* _tmp50_;
									_tmp49_ = child;
									_tmp50_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp49_, GALA_TYPE_WINDOW_CLONE, GalaWindowClone));
									_g_object_unref0 (closest);
									closest = _tmp50_;
								}
							}
						} else {
							if (direction == META_MOTION_UP) {
								MtkRectangle* _tmp51_;
								MtkRectangle* _tmp52_;
								gboolean _tmp53_ = FALSE;
								MtkRectangle* _tmp54_;
								MtkRectangle* _tmp55_;
								MtkRectangle* _tmp56_;
								_tmp51_ = window_rect;
								_tmp52_ = current_rect;
								if ((*_tmp51_).y > (*_tmp52_).y) {
									__vala_MtkRectangle_free0 (window_rect);
									continue;
								}
								_tmp54_ = window_rect;
								_tmp55_ = window_rect;
								_tmp56_ = current_rect;
								if (((*_tmp54_).x + (*_tmp55_).width) > (*_tmp56_).x) {
									MtkRectangle* _tmp57_;
									MtkRectangle* _tmp58_;
									MtkRectangle* _tmp59_;
									_tmp57_ = window_rect;
									_tmp58_ = current_rect;
									_tmp59_ = current_rect;
									_tmp53_ = (*_tmp57_).x < ((*_tmp58_).x + (*_tmp59_).width);
								} else {
									_tmp53_ = FALSE;
								}
								if (_tmp53_) {
									gboolean _tmp60_ = FALSE;
									GalaWindowClone* _tmp61_;
									_tmp61_ = closest;
									if (_tmp61_ == NULL) {
										_tmp60_ = TRUE;
									} else {
										GalaWindowClone* _tmp62_;
										MtkRectangle* _tmp63_;
										MtkRectangle* _tmp64_;
										MtkRectangle* _tmp65_;
										_tmp62_ = closest;
										_tmp63_ = gala_window_clone_get_slot (_tmp62_);
										_tmp64_ = _tmp63_;
										_tmp65_ = window_rect;
										_tmp60_ = (*_tmp64_).y < (*_tmp65_).y;
									}
									if (_tmp60_) {
										ClutterActor* _tmp66_;
										GalaWindowClone* _tmp67_;
										_tmp66_ = child;
										_tmp67_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp66_, GALA_TYPE_WINDOW_CLONE, GalaWindowClone));
										_g_object_unref0 (closest);
										closest = _tmp67_;
									}
								}
							} else {
								if (direction == META_MOTION_DOWN) {
									MtkRectangle* _tmp68_;
									MtkRectangle* _tmp69_;
									gboolean _tmp70_ = FALSE;
									MtkRectangle* _tmp71_;
									MtkRectangle* _tmp72_;
									MtkRectangle* _tmp73_;
									_tmp68_ = window_rect;
									_tmp69_ = current_rect;
									if ((*_tmp68_).y < (*_tmp69_).y) {
										__vala_MtkRectangle_free0 (window_rect);
										continue;
									}
									_tmp71_ = window_rect;
									_tmp72_ = window_rect;
									_tmp73_ = current_rect;
									if (((*_tmp71_).x + (*_tmp72_).width) > (*_tmp73_).x) {
										MtkRectangle* _tmp74_;
										MtkRectangle* _tmp75_;
										MtkRectangle* _tmp76_;
										_tmp74_ = window_rect;
										_tmp75_ = current_rect;
										_tmp76_ = current_rect;
										_tmp70_ = (*_tmp74_).x < ((*_tmp75_).x + (*_tmp76_).width);
									} else {
										_tmp70_ = FALSE;
									}
									if (_tmp70_) {
										gboolean _tmp77_ = FALSE;
										GalaWindowClone* _tmp78_;
										_tmp78_ = closest;
										if (_tmp78_ == NULL) {
											_tmp77_ = TRUE;
										} else {
											GalaWindowClone* _tmp79_;
											MtkRectangle* _tmp80_;
											MtkRectangle* _tmp81_;
											MtkRectangle* _tmp82_;
											_tmp79_ = closest;
											_tmp80_ = gala_window_clone_get_slot (_tmp79_);
											_tmp81_ = _tmp80_;
											_tmp82_ = window_rect;
											_tmp77_ = (*_tmp81_).y > (*_tmp82_).y;
										}
										if (_tmp77_) {
											ClutterActor* _tmp83_;
											GalaWindowClone* _tmp84_;
											_tmp83_ = child;
											_tmp84_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp83_, GALA_TYPE_WINDOW_CLONE, GalaWindowClone));
											_g_object_unref0 (closest);
											closest = _tmp84_;
										}
									}
								} else {
									g_warning ("WindowCloneContainer.vala:308: Invalid direction");
									__vala_MtkRectangle_free0 (window_rect);
									break;
								}
							}
						}
					}
					__vala_MtkRectangle_free0 (window_rect);
				}
			}
			(child_collection == NULL) ? NULL : (child_collection = (g_list_free (child_collection), NULL));
		}
		__vala_MtkRectangle_free0 (current_rect);
	}
	_tmp85_ = closest;
	if (_tmp85_ == NULL) {
		gboolean _tmp86_ = FALSE;
		GalaWindowClone* _tmp87_;
		_tmp87_ = self->priv->current_window;
		if (_tmp87_ != NULL) {
			_tmp86_ = user_action;
		} else {
			_tmp86_ = FALSE;
		}
		if (_tmp86_) {
			MetaDisplay* _tmp88_;
			GalaWindowClone* _tmp89_;
			_tmp88_ = display;
			gala_internal_utils_bell_notify (_tmp88_);
			_tmp89_ = self->priv->current_window;
			gala_window_clone_set_active (_tmp89_, TRUE);
		}
		_g_object_unref0 (closest);
		return;
	}
	_tmp90_ = self->priv->current_window;
	if (_tmp90_ != NULL) {
		GalaWindowClone* _tmp91_;
		_tmp91_ = self->priv->current_window;
		gala_window_clone_set_active (_tmp91_, FALSE);
	}
	if (user_action) {
		GalaWindowClone* _tmp92_;
		_tmp92_ = closest;
		gala_window_clone_set_active (_tmp92_, TRUE);
	}
	_tmp93_ = closest;
	self->priv->current_window = _tmp93_;
	_g_object_unref0 (closest);
}

/**
     * Emit the selected signal for the current_window.
     */
gboolean
gala_window_clone_container_activate_selected_window (GalaWindowCloneContainer* self)
{
	GalaWindowClone* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->current_window;
	if (_tmp0_ != NULL) {
		GalaWindowClone* _tmp1_;
		MetaWindow* _tmp2_;
		MetaWindow* _tmp3_;
		_tmp1_ = self->priv->current_window;
		_tmp2_ = gala_window_clone_get_window (_tmp1_);
		_tmp3_ = _tmp2_;
		g_signal_emit (self, gala_window_clone_container_signals[GALA_WINDOW_CLONE_CONTAINER_WINDOW_SELECTED_SIGNAL], 0, _tmp3_);
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}

static void
gala_window_clone_container_real_start_progress (GalaActorTarget* base,
                                                 GalaGestureAction action)
{
	GalaWindowCloneContainer * self;
	self = (GalaWindowCloneContainer*) base;
	if (!self->priv->opened) {
		MetaDisplay* display = NULL;
		GalaWindowManager* _tmp0_;
		MetaDisplay* _tmp1_;
		GalaWindowClone* _tmp2_;
		self->priv->opened = TRUE;
		_tmp0_ = self->priv->_wm;
		_tmp1_ = meta_plugin_get_display ((MetaPlugin*) _tmp0_);
		display = _tmp1_;
		_tmp2_ = self->priv->current_window;
		if (_tmp2_ != NULL) {
			GalaWindowClone* _tmp3_;
			_tmp3_ = self->priv->current_window;
			gala_window_clone_set_active (_tmp3_, FALSE);
		}
		{
			ClutterActor* child = NULL;
			ClutterActor* _tmp4_;
			ClutterActor* _tmp5_;
			_tmp4_ = clutter_actor_get_first_child ((ClutterActor*) self);
			_tmp5_ = _g_object_ref0 (_tmp4_);
			child = _tmp5_;
			{
				gboolean _tmp6_ = FALSE;
				_tmp6_ = TRUE;
				while (TRUE) {
					ClutterActor* _tmp10_;
					GalaWindowClone* clone = NULL;
					ClutterActor* _tmp11_;
					GalaWindowClone* _tmp12_;
					MetaWindow* _tmp13_;
					MetaWindow* _tmp14_;
					MetaDisplay* _tmp15_;
					MetaWindow* _tmp16_;
					MetaWindow* _tmp17_;
					if (!_tmp6_) {
						ClutterActor* _tmp7_;
						ClutterActor* _tmp8_;
						ClutterActor* _tmp9_;
						_tmp7_ = child;
						_tmp8_ = clutter_actor_get_next_sibling (_tmp7_);
						_tmp9_ = _g_object_ref0 (_tmp8_);
						_g_object_unref0 (child);
						child = _tmp9_;
					}
					_tmp6_ = FALSE;
					_tmp10_ = child;
					if (!(_tmp10_ != NULL)) {
						break;
					}
					_tmp11_ = child;
					clone = G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, GALA_TYPE_WINDOW_CLONE, GalaWindowClone);
					_tmp12_ = clone;
					_tmp13_ = gala_window_clone_get_window (_tmp12_);
					_tmp14_ = _tmp13_;
					_tmp15_ = display;
					_tmp16_ = meta_display_get_focus_window (_tmp15_);
					_tmp17_ = _tmp16_;
					if (_tmp14_ == _tmp17_) {
						GalaWindowClone* _tmp18_;
						_tmp18_ = clone;
						self->priv->current_window = _tmp18_;
						break;
					}
				}
			}
			_g_object_unref0 (child);
		}
		gala_window_clone_container_restack_windows (self);
		gala_window_clone_container_reflow (self, TRUE);
	} else {
		if (action == GALA_GESTURE_ACTION_MULTITASKING_VIEW) {
			gala_window_clone_container_restack_windows (self);
		}
	}
}

static void
gala_window_clone_container_real_commit_progress (GalaActorTarget* base,
                                                  GalaGestureAction action,
                                                  gdouble to)
{
	GalaWindowCloneContainer * self;
	self = (GalaWindowCloneContainer*) base;
	switch (action) {
		case GALA_GESTURE_ACTION_MULTITASKING_VIEW:
		{
			self->priv->opened = to > 0.5;
			break;
		}
		case GALA_GESTURE_ACTION_SWITCH_WORKSPACE:
		{
			self->priv->opened = gala_actor_target_get_current_commit ((GalaActorTarget*) self, GALA_GESTURE_ACTION_MULTITASKING_VIEW) > 0.5;
			break;
		}
		default:
		{
			break;
		}
	}
}

gint
gala_window_clone_container_get_padding_top (GalaWindowCloneContainer* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_padding_top;
	return result;
}

void
gala_window_clone_container_set_padding_top (GalaWindowCloneContainer* self,
                                             gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_window_clone_container_get_padding_top (self);
	if (old_value != value) {
		self->priv->_padding_top = value;
		g_object_notify_by_pspec ((GObject *) self, gala_window_clone_container_properties[GALA_WINDOW_CLONE_CONTAINER_PADDING_TOP_PROPERTY]);
	}
}

gint
gala_window_clone_container_get_padding_left (GalaWindowCloneContainer* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_padding_left;
	return result;
}

void
gala_window_clone_container_set_padding_left (GalaWindowCloneContainer* self,
                                              gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_window_clone_container_get_padding_left (self);
	if (old_value != value) {
		self->priv->_padding_left = value;
		g_object_notify_by_pspec ((GObject *) self, gala_window_clone_container_properties[GALA_WINDOW_CLONE_CONTAINER_PADDING_LEFT_PROPERTY]);
	}
}

gint
gala_window_clone_container_get_padding_right (GalaWindowCloneContainer* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_padding_right;
	return result;
}

void
gala_window_clone_container_set_padding_right (GalaWindowCloneContainer* self,
                                               gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_window_clone_container_get_padding_right (self);
	if (old_value != value) {
		self->priv->_padding_right = value;
		g_object_notify_by_pspec ((GObject *) self, gala_window_clone_container_properties[GALA_WINDOW_CLONE_CONTAINER_PADDING_RIGHT_PROPERTY]);
	}
}

gint
gala_window_clone_container_get_padding_bottom (GalaWindowCloneContainer* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_padding_bottom;
	return result;
}

void
gala_window_clone_container_set_padding_bottom (GalaWindowCloneContainer* self,
                                                gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_window_clone_container_get_padding_bottom (self);
	if (old_value != value) {
		self->priv->_padding_bottom = value;
		g_object_notify_by_pspec ((GObject *) self, gala_window_clone_container_properties[GALA_WINDOW_CLONE_CONTAINER_PADDING_BOTTOM_PROPERTY]);
	}
}

GalaWindowManager*
gala_window_clone_container_get_wm (GalaWindowCloneContainer* self)
{
	GalaWindowManager* result;
	GalaWindowManager* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_wm;
	result = _tmp0_;
	return result;
}

static void
gala_window_clone_container_set_wm (GalaWindowCloneContainer* self,
                                    GalaWindowManager* value)
{
	GalaWindowManager* old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_window_clone_container_get_wm (self);
	if (old_value != value) {
		GalaWindowManager* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_wm);
		self->priv->_wm = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gala_window_clone_container_properties[GALA_WINDOW_CLONE_CONTAINER_WM_PROPERTY]);
	}
}

gboolean
gala_window_clone_container_get_overview_mode (GalaWindowCloneContainer* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_overview_mode;
	return result;
}

static void
gala_window_clone_container_set_overview_mode (GalaWindowCloneContainer* self,
                                               gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_window_clone_container_get_overview_mode (self);
	if (old_value != value) {
		self->priv->_overview_mode = value;
		g_object_notify_by_pspec ((GObject *) self, gala_window_clone_container_properties[GALA_WINDOW_CLONE_CONTAINER_OVERVIEW_MODE_PROPERTY]);
	}
}

gfloat
gala_window_clone_container_get_monitor_scale (GalaWindowCloneContainer* self)
{
	gfloat result;
	g_return_val_if_fail (self != NULL, 0.0F);
	result = self->priv->_monitor_scale;
	return result;
}

void
gala_window_clone_container_set_monitor_scale (GalaWindowCloneContainer* self,
                                               gfloat value)
{
	gfloat old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_window_clone_container_get_monitor_scale (self);
	if (old_value != value) {
		self->priv->_monitor_scale = value;
		g_object_notify_by_pspec ((GObject *) self, gala_window_clone_container_properties[GALA_WINDOW_CLONE_CONTAINER_MONITOR_SCALE_PROPERTY]);
	}
}

static void
gala_window_clone_container_class_init (GalaWindowCloneContainerClass * klass,
                                        gpointer klass_data)
{
	gala_window_clone_container_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GalaWindowCloneContainer_private_offset);
	((ClutterActorClass *) klass)->key_press_event = (gboolean (*) (ClutterActor*, ClutterEvent*)) gala_window_clone_container_real_key_press_event;
	((GalaActorTargetClass *) klass)->start_progress = (void (*) (GalaActorTarget*, GalaGestureAction)) gala_window_clone_container_real_start_progress;
	((GalaActorTargetClass *) klass)->commit_progress = (void (*) (GalaActorTarget*, GalaGestureAction, gdouble)) gala_window_clone_container_real_commit_progress;
	G_OBJECT_CLASS (klass)->get_property = _vala_gala_window_clone_container_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gala_window_clone_container_set_property;
	G_OBJECT_CLASS (klass)->finalize = gala_window_clone_container_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_WINDOW_CLONE_CONTAINER_PADDING_TOP_PROPERTY, gala_window_clone_container_properties[GALA_WINDOW_CLONE_CONTAINER_PADDING_TOP_PROPERTY] = g_param_spec_int ("padding-top", "padding-top", "padding-top", G_MININT, G_MAXINT, 12, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_WINDOW_CLONE_CONTAINER_PADDING_LEFT_PROPERTY, gala_window_clone_container_properties[GALA_WINDOW_CLONE_CONTAINER_PADDING_LEFT_PROPERTY] = g_param_spec_int ("padding-left", "padding-left", "padding-left", G_MININT, G_MAXINT, 12, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_WINDOW_CLONE_CONTAINER_PADDING_RIGHT_PROPERTY, gala_window_clone_container_properties[GALA_WINDOW_CLONE_CONTAINER_PADDING_RIGHT_PROPERTY] = g_param_spec_int ("padding-right", "padding-right", "padding-right", G_MININT, G_MAXINT, 12, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_WINDOW_CLONE_CONTAINER_PADDING_BOTTOM_PROPERTY, gala_window_clone_container_properties[GALA_WINDOW_CLONE_CONTAINER_PADDING_BOTTOM_PROPERTY] = g_param_spec_int ("padding-bottom", "padding-bottom", "padding-bottom", G_MININT, G_MAXINT, 12, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_WINDOW_CLONE_CONTAINER_WM_PROPERTY, gala_window_clone_container_properties[GALA_WINDOW_CLONE_CONTAINER_WM_PROPERTY] = g_param_spec_object ("wm", "wm", "wm", GALA_TYPE_WINDOW_MANAGER, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_WINDOW_CLONE_CONTAINER_OVERVIEW_MODE_PROPERTY, gala_window_clone_container_properties[GALA_WINDOW_CLONE_CONTAINER_OVERVIEW_MODE_PROPERTY] = g_param_spec_boolean ("overview-mode", "overview-mode", "overview-mode", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_WINDOW_CLONE_CONTAINER_MONITOR_SCALE_PROPERTY, gala_window_clone_container_properties[GALA_WINDOW_CLONE_CONTAINER_MONITOR_SCALE_PROPERTY] = g_param_spec_float ("monitor-scale", "monitor-scale", "monitor-scale", -G_MAXFLOAT, G_MAXFLOAT, 0.0F, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	gala_window_clone_container_signals[GALA_WINDOW_CLONE_CONTAINER_WINDOW_SELECTED_SIGNAL] = g_signal_new ("window-selected", GALA_TYPE_WINDOW_CLONE_CONTAINER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, meta_window_get_type ());
	gala_window_clone_container_signals[GALA_WINDOW_CLONE_CONTAINER_REQUESTED_CLOSE_SIGNAL] = g_signal_new ("requested-close", GALA_TYPE_WINDOW_CLONE_CONTAINER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	gala_window_clone_container_signals[GALA_WINDOW_CLONE_CONTAINER_LAST_WINDOW_CLOSED_SIGNAL] = g_signal_new ("last-window-closed", GALA_TYPE_WINDOW_CLONE_CONTAINER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
gala_window_clone_container_instance_init (GalaWindowCloneContainer * self,
                                           gpointer klass)
{
	self->priv = gala_window_clone_container_get_instance_private (self);
	self->priv->_padding_top = 12;
	self->priv->_padding_left = 12;
	self->priv->_padding_right = 12;
	self->priv->_padding_bottom = 12;
	self->priv->opened = FALSE;
	self->priv->current_window = NULL;
}

static void
gala_window_clone_container_finalize (GObject * obj)
{
	GalaWindowCloneContainer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_TYPE_WINDOW_CLONE_CONTAINER, GalaWindowCloneContainer);
	_g_object_unref0 (self->priv->_wm);
	G_OBJECT_CLASS (gala_window_clone_container_parent_class)->finalize (obj);
}

/**
 * Container which controls the layout of a set of WindowClones.
 */
 G_GNUC_NO_INLINE static GType
gala_window_clone_container_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GalaWindowCloneContainerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gala_window_clone_container_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GalaWindowCloneContainer), 0, (GInstanceInitFunc) gala_window_clone_container_instance_init, NULL };
	GType gala_window_clone_container_type_id;
	gala_window_clone_container_type_id = g_type_register_static (GALA_TYPE_ACTOR_TARGET, "GalaWindowCloneContainer", &g_define_type_info, 0);
	GalaWindowCloneContainer_private_offset = g_type_add_instance_private (gala_window_clone_container_type_id, sizeof (GalaWindowCloneContainerPrivate));
	return gala_window_clone_container_type_id;
}

GType
gala_window_clone_container_get_type (void)
{
	static gsize gala_window_clone_container_type_id__once = 0;
	if (g_once_init_enter (&gala_window_clone_container_type_id__once)) {
		GType gala_window_clone_container_type_id;
		gala_window_clone_container_type_id = gala_window_clone_container_get_type_once ();
		g_once_init_leave (&gala_window_clone_container_type_id__once, gala_window_clone_container_type_id);
	}
	return gala_window_clone_container_type_id__once;
}

static void
_vala_gala_window_clone_container_get_property (GObject * object,
                                                guint property_id,
                                                GValue * value,
                                                GParamSpec * pspec)
{
	GalaWindowCloneContainer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_TYPE_WINDOW_CLONE_CONTAINER, GalaWindowCloneContainer);
	switch (property_id) {
		case GALA_WINDOW_CLONE_CONTAINER_PADDING_TOP_PROPERTY:
		g_value_set_int (value, gala_window_clone_container_get_padding_top (self));
		break;
		case GALA_WINDOW_CLONE_CONTAINER_PADDING_LEFT_PROPERTY:
		g_value_set_int (value, gala_window_clone_container_get_padding_left (self));
		break;
		case GALA_WINDOW_CLONE_CONTAINER_PADDING_RIGHT_PROPERTY:
		g_value_set_int (value, gala_window_clone_container_get_padding_right (self));
		break;
		case GALA_WINDOW_CLONE_CONTAINER_PADDING_BOTTOM_PROPERTY:
		g_value_set_int (value, gala_window_clone_container_get_padding_bottom (self));
		break;
		case GALA_WINDOW_CLONE_CONTAINER_WM_PROPERTY:
		g_value_set_object (value, gala_window_clone_container_get_wm (self));
		break;
		case GALA_WINDOW_CLONE_CONTAINER_OVERVIEW_MODE_PROPERTY:
		g_value_set_boolean (value, gala_window_clone_container_get_overview_mode (self));
		break;
		case GALA_WINDOW_CLONE_CONTAINER_MONITOR_SCALE_PROPERTY:
		g_value_set_float (value, gala_window_clone_container_get_monitor_scale (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_gala_window_clone_container_set_property (GObject * object,
                                                guint property_id,
                                                const GValue * value,
                                                GParamSpec * pspec)
{
	GalaWindowCloneContainer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_TYPE_WINDOW_CLONE_CONTAINER, GalaWindowCloneContainer);
	switch (property_id) {
		case GALA_WINDOW_CLONE_CONTAINER_PADDING_TOP_PROPERTY:
		gala_window_clone_container_set_padding_top (self, g_value_get_int (value));
		break;
		case GALA_WINDOW_CLONE_CONTAINER_PADDING_LEFT_PROPERTY:
		gala_window_clone_container_set_padding_left (self, g_value_get_int (value));
		break;
		case GALA_WINDOW_CLONE_CONTAINER_PADDING_RIGHT_PROPERTY:
		gala_window_clone_container_set_padding_right (self, g_value_get_int (value));
		break;
		case GALA_WINDOW_CLONE_CONTAINER_PADDING_BOTTOM_PROPERTY:
		gala_window_clone_container_set_padding_bottom (self, g_value_get_int (value));
		break;
		case GALA_WINDOW_CLONE_CONTAINER_WM_PROPERTY:
		gala_window_clone_container_set_wm (self, g_value_get_object (value));
		break;
		case GALA_WINDOW_CLONE_CONTAINER_OVERVIEW_MODE_PROPERTY:
		gala_window_clone_container_set_overview_mode (self, g_value_get_boolean (value));
		break;
		case GALA_WINDOW_CLONE_CONTAINER_MONITOR_SCALE_PROPERTY:
		gala_window_clone_container_set_monitor_scale (self, g_value_get_float (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

