/* MultitaskingView.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from MultitaskingView.vala, do not modify */

/**/
/*  Copyright (C) 2014 Tom Beckmann*/
/**/
/*  This program is free software: you can redistribute it and/or modify*/
/*  it under the terms of the GNU General Public License as published by*/
/*  the Free Software Foundation, either version 3 of the License, or*/
/*  (at your option) any later version.*/
/**/
/*  This program is distributed in the hope that it will be useful,*/
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of*/
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the*/
/*  GNU General Public License for more details.*/
/**/
/*  You should have received a copy of the GNU General Public License*/
/*  along with this program.  If not, see <http://www.gnu.org/licenses/>.*/
/**/

#include <clutter/clutter.h>
#include <glib-object.h>
#include "gala.h"
#include <glib.h>
#include <float.h>
#include <math.h>
#include <meta/meta-plugin.h>
#include <meta/display.h>
#include <meta/meta-background-group.h>
#include <gio/gio.h>
#include <meta/prefs.h>
#include <meta/window.h>
#include <mtk/mtk.h>
#include <meta/meta-workspace-manager.h>
#include <meta/common.h>
#include <meta/workspace.h>
#include <meta/keybindings.h>
#include <stdlib.h>
#include <string.h>
#include <meta/meta-monitor-manager.h>
#include <meta/meta-context.h>
#include <meta/meta-backend.h>

#define GALA_MULTITASKING_VIEW_ANIMATION_DURATION 250
#define GALA_WORKSPACE_CLONE_BOTTOM_OFFSET 100
#define GALA_ICON_GROUP_CONTAINER_SPACING 48
#define GALA_ICON_GROUP_SIZE 64
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define GALA_TYPE_GESTURE_TARGET (gala_gesture_target_get_type ())
#define GALA_GESTURE_TARGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_GESTURE_TARGET, GalaGestureTarget))
#define GALA_IS_GESTURE_TARGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_GESTURE_TARGET))
#define GALA_GESTURE_TARGET_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GALA_TYPE_GESTURE_TARGET, GalaGestureTargetIface))

typedef struct _GalaGestureTarget GalaGestureTarget;
typedef struct _GalaGestureTargetIface GalaGestureTargetIface;
typedef enum  {
	GALA_GESTURE_TARGET_UPDATE_TYPE_START,
	GALA_GESTURE_TARGET_UPDATE_TYPE_UPDATE,
	GALA_GESTURE_TARGET_UPDATE_TYPE_COMMIT,
	GALA_GESTURE_TARGET_UPDATE_TYPE_END
} GalaGestureTargetUpdateType;

#define GALA_GESTURE_TARGET_TYPE_UPDATE_TYPE (gala_gesture_target_update_type_get_type ())

#define GALA_TYPE_ACTOR_TARGET (gala_actor_target_get_type ())
#define GALA_ACTOR_TARGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_ACTOR_TARGET, GalaActorTarget))
#define GALA_ACTOR_TARGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_ACTOR_TARGET, GalaActorTargetClass))
#define GALA_IS_ACTOR_TARGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_ACTOR_TARGET))
#define GALA_IS_ACTOR_TARGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_ACTOR_TARGET))
#define GALA_ACTOR_TARGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_ACTOR_TARGET, GalaActorTargetClass))

typedef struct _GalaActorTarget GalaActorTarget;
typedef struct _GalaActorTargetClass GalaActorTargetClass;
typedef struct _GalaActorTargetPrivate GalaActorTargetPrivate;

#define GALA_TYPE_ROOT_TARGET (gala_root_target_get_type ())
#define GALA_ROOT_TARGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_ROOT_TARGET, GalaRootTarget))
#define GALA_IS_ROOT_TARGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_ROOT_TARGET))
#define GALA_ROOT_TARGET_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GALA_TYPE_ROOT_TARGET, GalaRootTargetIface))

typedef struct _GalaRootTarget GalaRootTarget;
typedef struct _GalaRootTargetIface GalaRootTargetIface;

#define GALA_TYPE_MULTITASKING_VIEW (gala_multitasking_view_get_type ())
#define GALA_MULTITASKING_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_MULTITASKING_VIEW, GalaMultitaskingView))
#define GALA_MULTITASKING_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_MULTITASKING_VIEW, GalaMultitaskingViewClass))
#define GALA_IS_MULTITASKING_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_MULTITASKING_VIEW))
#define GALA_IS_MULTITASKING_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_MULTITASKING_VIEW))
#define GALA_MULTITASKING_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_MULTITASKING_VIEW, GalaMultitaskingViewClass))

typedef struct _GalaMultitaskingView GalaMultitaskingView;
typedef struct _GalaMultitaskingViewClass GalaMultitaskingViewClass;
typedef struct _GalaMultitaskingViewPrivate GalaMultitaskingViewPrivate;

#define GALA_TYPE_GESTURE_CONTROLLER (gala_gesture_controller_get_type ())
#define GALA_GESTURE_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_GESTURE_CONTROLLER, GalaGestureController))
#define GALA_GESTURE_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_GESTURE_CONTROLLER, GalaGestureControllerClass))
#define GALA_IS_GESTURE_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_GESTURE_CONTROLLER))
#define GALA_IS_GESTURE_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_GESTURE_CONTROLLER))
#define GALA_GESTURE_CONTROLLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_GESTURE_CONTROLLER, GalaGestureControllerClass))

typedef struct _GalaGestureController GalaGestureController;
typedef struct _GalaGestureControllerClass GalaGestureControllerClass;

#define GALA_TYPE_WINDOW_MANAGER_GALA (gala_window_manager_gala_get_type ())
#define GALA_WINDOW_MANAGER_GALA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_WINDOW_MANAGER_GALA, GalaWindowManagerGala))
#define GALA_WINDOW_MANAGER_GALA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_WINDOW_MANAGER_GALA, GalaWindowManagerGalaClass))
#define GALA_IS_WINDOW_MANAGER_GALA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_WINDOW_MANAGER_GALA))
#define GALA_IS_WINDOW_MANAGER_GALA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_WINDOW_MANAGER_GALA))
#define GALA_WINDOW_MANAGER_GALA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_WINDOW_MANAGER_GALA, GalaWindowManagerGalaClass))

typedef struct _GalaWindowManagerGala GalaWindowManagerGala;
typedef struct _GalaWindowManagerGalaClass GalaWindowManagerGalaClass;

#define GALA_TYPE_MONITOR_CLONE (gala_monitor_clone_get_type ())
#define GALA_MONITOR_CLONE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_MONITOR_CLONE, GalaMonitorClone))
#define GALA_MONITOR_CLONE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_MONITOR_CLONE, GalaMonitorCloneClass))
#define GALA_IS_MONITOR_CLONE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_MONITOR_CLONE))
#define GALA_IS_MONITOR_CLONE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_MONITOR_CLONE))
#define GALA_MONITOR_CLONE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_MONITOR_CLONE, GalaMonitorCloneClass))

typedef struct _GalaMonitorClone GalaMonitorClone;
typedef struct _GalaMonitorCloneClass GalaMonitorCloneClass;

#define GALA_TYPE_ICON_GROUP_CONTAINER (gala_icon_group_container_get_type ())
#define GALA_ICON_GROUP_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_ICON_GROUP_CONTAINER, GalaIconGroupContainer))
#define GALA_ICON_GROUP_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_ICON_GROUP_CONTAINER, GalaIconGroupContainerClass))
#define GALA_IS_ICON_GROUP_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_ICON_GROUP_CONTAINER))
#define GALA_IS_ICON_GROUP_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_ICON_GROUP_CONTAINER))
#define GALA_ICON_GROUP_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_ICON_GROUP_CONTAINER, GalaIconGroupContainerClass))

typedef struct _GalaIconGroupContainer GalaIconGroupContainer;
typedef struct _GalaIconGroupContainerClass GalaIconGroupContainerClass;

#define GALA_TYPE_BACKGROUND_MANAGER (gala_background_manager_get_type ())
#define GALA_BACKGROUND_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_BACKGROUND_MANAGER, GalaBackgroundManager))
#define GALA_BACKGROUND_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_BACKGROUND_MANAGER, GalaBackgroundManagerClass))
#define GALA_IS_BACKGROUND_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_BACKGROUND_MANAGER))
#define GALA_IS_BACKGROUND_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_BACKGROUND_MANAGER))
#define GALA_BACKGROUND_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_BACKGROUND_MANAGER, GalaBackgroundManagerClass))

typedef struct _GalaBackgroundManager GalaBackgroundManager;
typedef struct _GalaBackgroundManagerClass GalaBackgroundManagerClass;
enum  {
	GALA_MULTITASKING_VIEW_0_PROPERTY,
	GALA_MULTITASKING_VIEW_WM_PROPERTY,
	GALA_MULTITASKING_VIEW_NUM_PROPERTIES
};
static GParamSpec* gala_multitasking_view_properties[GALA_MULTITASKING_VIEW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define GALA_TYPE_WORKSPACE_CLONE (gala_workspace_clone_get_type ())
#define GALA_WORKSPACE_CLONE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_WORKSPACE_CLONE, GalaWorkspaceClone))
#define GALA_WORKSPACE_CLONE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_WORKSPACE_CLONE, GalaWorkspaceCloneClass))
#define GALA_IS_WORKSPACE_CLONE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_WORKSPACE_CLONE))
#define GALA_IS_WORKSPACE_CLONE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_WORKSPACE_CLONE))
#define GALA_WORKSPACE_CLONE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_WORKSPACE_CLONE, GalaWorkspaceCloneClass))

typedef struct _GalaWorkspaceClone GalaWorkspaceClone;
typedef struct _GalaWorkspaceCloneClass GalaWorkspaceCloneClass;

#define GALA_TYPE_BLUR_EFFECT (gala_blur_effect_get_type ())
#define GALA_BLUR_EFFECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_BLUR_EFFECT, GalaBlurEffect))
#define GALA_BLUR_EFFECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_BLUR_EFFECT, GalaBlurEffectClass))
#define GALA_IS_BLUR_EFFECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_BLUR_EFFECT))
#define GALA_IS_BLUR_EFFECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_BLUR_EFFECT))
#define GALA_BLUR_EFFECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_BLUR_EFFECT, GalaBlurEffectClass))

typedef struct _GalaBlurEffect GalaBlurEffect;
typedef struct _GalaBlurEffectClass GalaBlurEffectClass;

#define GALA_TYPE_ICON_GROUP (gala_icon_group_get_type ())
#define GALA_ICON_GROUP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_ICON_GROUP, GalaIconGroup))
#define GALA_ICON_GROUP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_ICON_GROUP, GalaIconGroupClass))
#define GALA_IS_ICON_GROUP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_ICON_GROUP))
#define GALA_IS_ICON_GROUP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_ICON_GROUP))
#define GALA_ICON_GROUP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_ICON_GROUP, GalaIconGroupClass))

typedef struct _GalaIconGroup GalaIconGroup;
typedef struct _GalaIconGroupClass GalaIconGroupClass;

#define GALA_TYPE_STATIC_WINDOW_CONTAINER (gala_static_window_container_get_type ())
#define GALA_STATIC_WINDOW_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_STATIC_WINDOW_CONTAINER, GalaStaticWindowContainer))
#define GALA_STATIC_WINDOW_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_STATIC_WINDOW_CONTAINER, GalaStaticWindowContainerClass))
#define GALA_IS_STATIC_WINDOW_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_STATIC_WINDOW_CONTAINER))
#define GALA_IS_STATIC_WINDOW_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_STATIC_WINDOW_CONTAINER))
#define GALA_STATIC_WINDOW_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_STATIC_WINDOW_CONTAINER, GalaStaticWindowContainerClass))

typedef struct _GalaStaticWindowContainer GalaStaticWindowContainer;
typedef struct _GalaStaticWindowContainerClass GalaStaticWindowContainerClass;

#define GALA_TYPE_WORKSPACE_MANAGER (gala_workspace_manager_get_type ())
#define GALA_WORKSPACE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_WORKSPACE_MANAGER, GalaWorkspaceManager))
#define GALA_WORKSPACE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_WORKSPACE_MANAGER, GalaWorkspaceManagerClass))
#define GALA_IS_WORKSPACE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_WORKSPACE_MANAGER))
#define GALA_IS_WORKSPACE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_WORKSPACE_MANAGER))
#define GALA_WORKSPACE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_WORKSPACE_MANAGER, GalaWorkspaceManagerClass))

typedef struct _GalaWorkspaceManager GalaWorkspaceManager;
typedef struct _GalaWorkspaceManagerClass GalaWorkspaceManagerClass;

#define GALA_TYPE_WINDOW_CLONE_CONTAINER (gala_window_clone_container_get_type ())
#define GALA_WINDOW_CLONE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_WINDOW_CLONE_CONTAINER, GalaWindowCloneContainer))
#define GALA_WINDOW_CLONE_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_WINDOW_CLONE_CONTAINER, GalaWindowCloneContainerClass))
#define GALA_IS_WINDOW_CLONE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_WINDOW_CLONE_CONTAINER))
#define GALA_IS_WINDOW_CLONE_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_WINDOW_CLONE_CONTAINER))
#define GALA_WINDOW_CLONE_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_WINDOW_CLONE_CONTAINER, GalaWindowCloneContainerClass))

typedef struct _GalaWindowCloneContainer GalaWindowCloneContainer;
typedef struct _GalaWindowCloneContainerClass GalaWindowCloneContainerClass;
typedef struct _Block59Data Block59Data;

#define GALA_TYPE_SHELL_CLIENTS_MANAGER (gala_shell_clients_manager_get_type ())
#define GALA_SHELL_CLIENTS_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_SHELL_CLIENTS_MANAGER, GalaShellClientsManager))
#define GALA_SHELL_CLIENTS_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_SHELL_CLIENTS_MANAGER, GalaShellClientsManagerClass))
#define GALA_IS_SHELL_CLIENTS_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_SHELL_CLIENTS_MANAGER))
#define GALA_IS_SHELL_CLIENTS_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_SHELL_CLIENTS_MANAGER))
#define GALA_SHELL_CLIENTS_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_SHELL_CLIENTS_MANAGER, GalaShellClientsManagerClass))

typedef struct _GalaShellClientsManager GalaShellClientsManager;
typedef struct _GalaShellClientsManagerClass GalaShellClientsManagerClass;

#define GALA_TYPE_WORKSPACE_ROW (gala_workspace_row_get_type ())
#define GALA_WORKSPACE_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_WORKSPACE_ROW, GalaWorkspaceRow))
#define GALA_WORKSPACE_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_WORKSPACE_ROW, GalaWorkspaceRowClass))
#define GALA_IS_WORKSPACE_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_WORKSPACE_ROW))
#define GALA_IS_WORKSPACE_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_WORKSPACE_ROW))
#define GALA_WORKSPACE_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_WORKSPACE_ROW, GalaWorkspaceRowClass))

typedef struct _GalaWorkspaceRow GalaWorkspaceRow;
typedef struct _GalaWorkspaceRowClass GalaWorkspaceRowClass;

struct _GalaGestureTargetIface {
	GTypeInterface parent_iface;
	void (*propagate) (GalaGestureTarget* self, GalaGestureTargetUpdateType update_type, GalaGestureAction action, gdouble progress);
	ClutterActor* (*get_actor) (GalaGestureTarget* self);
};

struct _GalaActorTarget {
	ClutterActor parent_instance;
	GalaActorTargetPrivate * priv;
};

struct _GalaActorTargetClass {
	ClutterActorClass parent_class;
	void (*start_progress) (GalaActorTarget* self, GalaGestureAction action);
	void (*update_progress) (GalaActorTarget* self, GalaGestureAction action, gdouble progress);
	void (*commit_progress) (GalaActorTarget* self, GalaGestureAction action, gdouble to);
	void (*end_progress) (GalaActorTarget* self, GalaGestureAction action);
};

struct _GalaRootTargetIface {
	GTypeInterface parent_iface;
};

struct _GalaMultitaskingView {
	GalaActorTarget parent_instance;
	GalaMultitaskingViewPrivate * priv;
};

struct _GalaMultitaskingViewClass {
	GalaActorTargetClass parent_class;
};

struct _GalaMultitaskingViewPrivate {
	GalaGestureController* workspaces_gesture_controller;
	GalaGestureController* multitasking_gesture_controller;
	GalaWindowManagerGala* _wm;
	MetaDisplay* display;
	GalaModalProxy* modal_proxy;
	gboolean opened;
	GList* window_containers_monitors;
	GalaIconGroupContainer* icon_groups;
	GalaActorTarget* workspaces;
	ClutterActor* primary_monitor_container;
	ClutterBrightnessContrastEffect* brightness_effect;
	GalaBackgroundManager* blurred_bg;
	GSettings* gala_behavior_settings;
	GalaDrawingStyleManager* style_manager;
};

struct _Block59Data {
	int _ref_count_;
	GalaMultitaskingView* self;
	MetaWorkspaceManager* manager;
};

static gint GalaMultitaskingView_private_offset;
static gpointer gala_multitasking_view_parent_class = NULL;
static GalaRootTargetIface * gala_multitasking_view_gala_root_target_parent_iface = NULL;
static GalaActivatableComponentIface * gala_multitasking_view_gala_activatable_component_parent_iface = NULL;

VALA_EXTERN GType gala_gesture_target_update_type_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType gala_gesture_target_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaGestureTarget, g_object_unref)
VALA_EXTERN GType gala_actor_target_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaActorTarget, g_object_unref)
VALA_EXTERN GType gala_root_target_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType gala_multitasking_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaMultitaskingView, g_object_unref)
VALA_EXTERN GType gala_gesture_controller_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaGestureController, g_object_unref)
VALA_EXTERN GType gala_window_manager_gala_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaWindowManagerGala, g_object_unref)
VALA_EXTERN GType gala_monitor_clone_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaMonitorClone, g_object_unref)
VALA_EXTERN GType gala_icon_group_container_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaIconGroupContainer, g_object_unref)
VALA_EXTERN GType gala_background_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaBackgroundManager, g_object_unref)
VALA_EXTERN void gala_actor_target_start_progress (GalaActorTarget* self,
                                       GalaGestureAction action);
VALA_EXTERN void gala_actor_target_commit_progress (GalaActorTarget* self,
                                        GalaGestureAction action,
                                        gdouble to);
VALA_EXTERN void gala_actor_target_end_progress (GalaActorTarget* self,
                                     GalaGestureAction action);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
VALA_EXTERN GalaMultitaskingView* gala_multitasking_view_new (GalaWindowManagerGala* wm);
VALA_EXTERN GalaMultitaskingView* gala_multitasking_view_construct (GType object_type,
                                                        GalaWindowManagerGala* wm);
static void gala_multitasking_view_update_monitors (GalaMultitaskingView* self);
static void gala_multitasking_view_update_blurred_bg (GalaMultitaskingView* self);
static void gala_multitasking_view_update_workspaces (GalaMultitaskingView* self);
VALA_EXTERN GalaWindowManagerGala* gala_multitasking_view_get_wm (GalaMultitaskingView* self);
VALA_EXTERN GalaMonitorClone* gala_monitor_clone_new (GalaWindowManager* wm,
                                          gint monitor);
VALA_EXTERN GalaMonitorClone* gala_monitor_clone_construct (GType object_type,
                                                GalaWindowManager* wm,
                                                gint monitor);
static void gala_multitasking_view_window_selected (GalaMultitaskingView* self,
                                             MetaWindow* window);
static void _gala_multitasking_view_window_selected_gala_monitor_clone_window_selected (GalaMonitorClone* _sender,
                                                                                 MetaWindow* window,
                                                                                 gpointer self);
VALA_EXTERN void gala_icon_group_container_set_scale_factor (GalaIconGroupContainer* self,
                                                 gfloat value);
VALA_EXTERN GType gala_workspace_clone_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaWorkspaceClone, g_object_unref)
VALA_EXTERN void gala_workspace_clone_set_monitor_scale (GalaWorkspaceClone* self,
                                             gfloat value);
VALA_EXTERN void gala_workspace_clone_update_size (GalaWorkspaceClone* self,
                                       MtkRectangle* monitor_geometry);
static void gala_multitasking_view_update_brightness_effect (GalaMultitaskingView* self);
VALA_EXTERN GalaBackgroundManager* gala_background_manager_new (MetaDisplay* display,
                                                    gint monitor_index,
                                                    gboolean control_position,
                                                    gboolean rounded_corners);
VALA_EXTERN GalaBackgroundManager* gala_background_manager_construct (GType object_type,
                                                          MetaDisplay* display,
                                                          gint monitor_index,
                                                          gboolean control_position,
                                                          gboolean rounded_corners);
VALA_EXTERN GalaBlurEffect* gala_blur_effect_new (ClutterActor* actor,
                                      gfloat radius);
VALA_EXTERN GalaBlurEffect* gala_blur_effect_construct (GType object_type,
                                            ClutterActor* actor,
                                            gfloat radius);
VALA_EXTERN GType gala_blur_effect_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaBlurEffect, g_object_unref)
VALA_EXTERN GType gala_icon_group_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaIconGroup, g_object_unref)
VALA_EXTERN void gala_icon_group_container_remove_group (GalaIconGroupContainer* self,
                                             GalaIconGroup* group);
VALA_EXTERN GalaIconGroup* gala_workspace_clone_get_icon_group (GalaWorkspaceClone* self);
static void gala_multitasking_view_add_workspace (GalaMultitaskingView* self,
                                           gint num);
static gboolean gala_multitasking_view_real_scroll_event (ClutterActor* base,
                                                   ClutterEvent* scroll_event);
VALA_EXTERN void gala_multitasking_view_switch_to_next_workspace (GalaMultitaskingView* self,
                                                      MetaMotionDirection direction);
VALA_EXTERN void gala_multitasking_view_move_window (GalaMultitaskingView* self,
                                         MetaWindow* window,
                                         MetaWorkspace* workspace);
VALA_EXTERN GType gala_static_window_container_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaStaticWindowContainer, g_object_unref)
VALA_EXTERN GalaStaticWindowContainer* gala_static_window_container_get_instance (MetaDisplay* display);
VALA_EXTERN void gala_static_window_container_notify_window_moving (GalaStaticWindowContainer* self,
                                                        MetaWindow* window);
VALA_EXTERN void gala_gesture_controller_goto (GalaGestureController* self,
                                   gdouble to);
VALA_EXTERN gdouble gala_actor_target_get_current_commit (GalaActorTarget* self,
                                              GalaGestureAction action);
VALA_EXTERN void gala_multitasking_view_kill_switch_workspace (GalaMultitaskingView* self);
VALA_EXTERN void gala_gesture_controller_cancel_gesture (GalaGestureController* self);
static void gala_multitasking_view_real_start_progress (GalaActorTarget* base,
                                                 GalaGestureAction action);
static gboolean gala_multitasking_view_keybinding_filter (GalaMultitaskingView* self,
                                                   MetaKeyBinding* binding);
static gboolean _gala_multitasking_view_keybinding_filter_gala_keybinding_filter (MetaKeyBinding* binding,
                                                                           gpointer self);
VALA_EXTERN void gala_icon_group_container_force_reposition (GalaIconGroupContainer* self);
static void gala_multitasking_view_reposition_icon_groups (GalaMultitaskingView* self,
                                                    gboolean animate);
VALA_EXTERN GType gala_workspace_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaWorkspaceManager, g_object_unref)
VALA_EXTERN GalaWorkspaceManager* gala_workspace_manager_get_default (void);
VALA_EXTERN void gala_workspace_manager_freeze_remove (GalaWorkspaceManager* self);
VALA_EXTERN GVariant* gala_gesture_controller_get_action_info (GalaGestureController* self);
static gboolean _variant_get1 (GVariant* value);
VALA_EXTERN gdouble gala_gesture_controller_get_overshoot_lower_clamp (GalaGestureController* self);
VALA_EXTERN void gala_gesture_controller_set_overshoot_lower_clamp (GalaGestureController* self,
                                                        gdouble value);
static void gala_multitasking_view_real_commit_progress (GalaActorTarget* base,
                                                  GalaGestureAction action,
                                                  gdouble to);
VALA_EXTERN gboolean gala_gesture_controller_get_recognizing (GalaGestureController* self);
VALA_EXTERN MetaWindow* gala_static_window_container_get_moving_window (GalaStaticWindowContainer* self);
static void gala_multitasking_view_real_end_progress (GalaActorTarget* base,
                                               GalaGestureAction action);
VALA_EXTERN gboolean gala_actor_target_get_animating (GalaActorTarget* self);
VALA_EXTERN void gala_workspace_manager_thaw_remove (GalaWorkspaceManager* self);
VALA_EXTERN void gala_static_window_container_notify_move_ended (GalaStaticWindowContainer* self);
VALA_EXTERN gfloat gala_icon_group_container_calculate_total_width (GalaIconGroupContainer* self);
VALA_EXTERN GalaWorkspaceClone* gala_workspace_clone_new (GalaWindowManager* wm,
                                              MetaWorkspace* workspace,
                                              gfloat monitor_scale);
VALA_EXTERN GalaWorkspaceClone* gala_workspace_clone_construct (GType object_type,
                                                    GalaWindowManager* wm,
                                                    MetaWorkspace* workspace,
                                                    gfloat monitor_scale);
VALA_EXTERN void gala_icon_group_container_add_group (GalaIconGroupContainer* self,
                                          GalaIconGroup* group);
static void _gala_multitasking_view_window_selected_gala_workspace_clone_window_selected (GalaWorkspaceClone* _sender,
                                                                                   MetaWindow* window,
                                                                                   gpointer self);
static void gala_multitasking_view_remove_workspace (GalaMultitaskingView* self,
                                              gint num);
VALA_EXTERN MetaWorkspace* gala_workspace_clone_get_workspace (GalaWorkspaceClone* self);
VALA_EXTERN void gala_gesture_controller_set_progress (GalaGestureController* self,
                                           gdouble value);
static void gala_multitasking_view_on_workspaces_reordered (GalaMultitaskingView* self);
static void gala_multitasking_view_on_workspace_switched (GalaMultitaskingView* self,
                                                   gint from,
                                                   gint to);
static gboolean gala_multitasking_view_real_key_press_event (ClutterActor* base,
                                                      ClutterEvent* event);
VALA_EXTERN GType gala_window_clone_container_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaWindowCloneContainer, g_object_unref)
static GalaWindowCloneContainer* gala_multitasking_view_get_active_window_clone_container (GalaMultitaskingView* self);
VALA_EXTERN GalaWindowCloneContainer* gala_workspace_clone_get_window_container (GalaWorkspaceClone* self);
static gboolean gala_multitasking_view_real_is_opened (GalaActivatableComponent* base);
static void gala_multitasking_view_real_open (GalaActivatableComponent* base,
                                       GHashTable* hints);
static void gala_multitasking_view_real_close (GalaActivatableComponent* base,
                                        GHashTable* hints);
static gboolean gala_multitasking_view_real_captured_event (ClutterActor* base,
                                                     ClutterEvent* event);
static void gala_multitasking_view_set_wm (GalaMultitaskingView* self,
                                    GalaWindowManagerGala* value);
static GObject * gala_multitasking_view_constructor (GType type,
                                              guint n_construct_properties,
                                              GObjectConstructParam * construct_properties);
static Block59Data* block59_data_ref (Block59Data* _data59_);
static void block59_data_unref (void * _userdata_);
VALA_EXTERN GalaGestureController* gala_gesture_controller_new (GalaGestureAction action,
                                                    GalaWindowManager* wm);
VALA_EXTERN GalaGestureController* gala_gesture_controller_construct (GType object_type,
                                                          GalaGestureAction action,
                                                          GalaWindowManager* wm);
VALA_EXTERN void gala_gesture_controller_enable_touchpad (GalaGestureController* self);
VALA_EXTERN void gala_root_target_add_gesture_controller (GalaRootTarget* self,
                                              GalaGestureController* controller);
VALA_EXTERN void gala_actor_target_add_target (GalaActorTarget* self,
                                   GalaGestureTarget* target);
VALA_EXTERN GType gala_shell_clients_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaShellClientsManager, g_object_unref)
VALA_EXTERN GalaShellClientsManager* gala_shell_clients_manager_get_instance (void);
VALA_EXTERN GalaWorkspaceRow* gala_workspace_row_new (MetaDisplay* display);
VALA_EXTERN GalaWorkspaceRow* gala_workspace_row_construct (GType object_type,
                                                MetaDisplay* display);
VALA_EXTERN GType gala_workspace_row_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaWorkspaceRow, g_object_unref)
VALA_EXTERN void gala_gesture_controller_set_overshoot_upper_clamp (GalaGestureController* self,
                                                        gdouble value);
VALA_EXTERN void gala_gesture_controller_enable_scroll (GalaGestureController* self,
                                            ClutterActor* actor,
                                            ClutterOrientation orientation);
VALA_EXTERN GalaIconGroupContainer* gala_icon_group_container_new (gfloat scale);
VALA_EXTERN GalaIconGroupContainer* gala_icon_group_container_construct (GType object_type,
                                                             gfloat scale);
VALA_EXTERN GalaActorTarget* gala_actor_target_new (void);
VALA_EXTERN GalaActorTarget* gala_actor_target_construct (GType object_type);
static void _gala_multitasking_view_add_workspace_meta_workspace_manager_workspace_added (MetaWorkspaceManager* _sender,
                                                                                   gint object,
                                                                                   gpointer self);
static void _gala_multitasking_view_remove_workspace_meta_workspace_manager_workspace_removed (MetaWorkspaceManager* _sender,
                                                                                        gint object,
                                                                                        gpointer self);
static void _gala_multitasking_view_on_workspaces_reordered_meta_workspace_manager_workspaces_reordered (MetaWorkspaceManager* _sender,
                                                                                                  gpointer self);
static void _gala_multitasking_view_on_workspace_switched_meta_workspace_manager_workspace_switched (MetaWorkspaceManager* _sender,
                                                                                              gint object,
                                                                                              gint p0,
                                                                                              MetaMotionDirection p1,
                                                                                              gpointer self);
static void _gala_multitasking_view___lambda89_ (Block59Data* _data59_);
static void __gala_multitasking_view___lambda89__g_object_notify (GObject* _sender,
                                                           GParamSpec* pspec,
                                                           gpointer self);
static void _gala_multitasking_view_update_monitors_meta_monitor_manager_monitors_changed (MetaMonitorManager* _sender,
                                                                                    gpointer self);
static void _gala_multitasking_view___lambda90_ (GalaMultitaskingView* self,
                                          MetaPreference pref);
static void __gala_multitasking_view___lambda90__meta_prefs_changed_func (MetaPreference pref,
                                                                   gpointer self);
static void _gala_multitasking_view_update_brightness_effect_g_object_notify (GObject* _sender,
                                                                       GParamSpec* pspec,
                                                                       gpointer self);
static void gala_multitasking_view_finalize (GObject * obj);
static GType gala_multitasking_view_get_type_once (void);
static void _vala_gala_multitasking_view_get_property (GObject * object,
                                                guint property_id,
                                                GValue * value,
                                                GParamSpec * pspec);
static void _vala_gala_multitasking_view_set_property (GObject * object,
                                                guint property_id,
                                                const GValue * value,
                                                GParamSpec * pspec);

static inline gpointer
gala_multitasking_view_get_instance_private (GalaMultitaskingView* self)
{
	return G_STRUCT_MEMBER_P (self, GalaMultitaskingView_private_offset);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

GalaMultitaskingView*
gala_multitasking_view_construct (GType object_type,
                                  GalaWindowManagerGala* wm)
{
	GalaMultitaskingView * self = NULL;
	g_return_val_if_fail (wm != NULL, NULL);
	self = (GalaMultitaskingView*) g_object_new (object_type, "wm", wm, NULL);
	return self;
}

GalaMultitaskingView*
gala_multitasking_view_new (GalaWindowManagerGala* wm)
{
	return gala_multitasking_view_construct (GALA_TYPE_MULTITASKING_VIEW, wm);
}

/**
     * Places the primary container for the WorkspaceClones and the
     * MonitorClones at the right positions
     */
static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_gala_multitasking_view_window_selected_gala_monitor_clone_window_selected (GalaMonitorClone* _sender,
                                                                            MetaWindow* window,
                                                                            gpointer self)
{
	gala_multitasking_view_window_selected ((GalaMultitaskingView*) self, window);
}

static void
gala_multitasking_view_update_monitors (GalaMultitaskingView* self)
{
	GList* _tmp0_;
	gint primary = 0;
	MetaDisplay* _tmp3_;
	MtkRectangle primary_geometry = {0};
	MetaDisplay* _tmp13_;
	MtkRectangle _tmp14_ = {0};
	gfloat scale = 0.0F;
	MetaDisplay* _tmp15_;
	GalaIconGroupContainer* _tmp16_;
	ClutterActor* _tmp17_;
	MtkRectangle _tmp18_;
	MtkRectangle _tmp19_;
	ClutterActor* _tmp20_;
	MtkRectangle _tmp21_;
	MtkRectangle _tmp22_;
	GalaActorTarget* _tmp23_;
	GList* _tmp24_;
	g_return_if_fail (self != NULL);
	gala_multitasking_view_update_blurred_bg (self);
	gala_multitasking_view_update_workspaces (self);
	_tmp0_ = self->priv->window_containers_monitors;
	{
		GList* monitor_clone_collection = NULL;
		GList* monitor_clone_it = NULL;
		monitor_clone_collection = _tmp0_;
		for (monitor_clone_it = monitor_clone_collection; monitor_clone_it != NULL; monitor_clone_it = monitor_clone_it->next) {
			GalaMonitorClone* _tmp1_;
			GalaMonitorClone* monitor_clone = NULL;
			_tmp1_ = _g_object_ref0 ((GalaMonitorClone*) monitor_clone_it->data);
			monitor_clone = _tmp1_;
			{
				GalaMonitorClone* _tmp2_;
				_tmp2_ = monitor_clone;
				clutter_actor_destroy ((ClutterActor*) _tmp2_);
				_g_object_unref0 (monitor_clone);
			}
		}
	}
	_tmp3_ = self->priv->display;
	primary = meta_display_get_primary_monitor (_tmp3_);
	if (meta_prefs_get_workspaces_only_on_primary ()) {
		{
			gint monitor = 0;
			monitor = 0;
			{
				gboolean _tmp4_ = FALSE;
				_tmp4_ = TRUE;
				while (TRUE) {
					MetaDisplay* _tmp6_;
					GalaMonitorClone* monitor_clone = NULL;
					GalaWindowManagerGala* _tmp7_;
					GalaMonitorClone* _tmp8_ = NULL;
					GalaMonitorClone* _tmp9_;
					GalaMonitorClone* _tmp10_;
					GalaMonitorClone* _tmp11_;
					GalaMonitorClone* _tmp12_;
					if (!_tmp4_) {
						gint _tmp5_;
						_tmp5_ = monitor;
						monitor = _tmp5_ + 1;
					}
					_tmp4_ = FALSE;
					_tmp6_ = self->priv->display;
					if (!(monitor < meta_display_get_n_monitors (_tmp6_))) {
						break;
					}
					if (monitor == primary) {
						continue;
					}
					_tmp7_ = self->priv->_wm;
					_tmp8_ = gala_monitor_clone_new ((GalaWindowManager*) _tmp7_, monitor);
					g_object_set ((ClutterActor*) _tmp8_, "visible", TRUE, NULL);
					g_object_ref_sink (_tmp8_);
					monitor_clone = _tmp8_;
					_tmp9_ = monitor_clone;
					g_signal_connect_object (_tmp9_, "window-selected", (GCallback) _gala_multitasking_view_window_selected_gala_monitor_clone_window_selected, self, 0);
					_tmp10_ = monitor_clone;
					_tmp11_ = _g_object_ref0 (_tmp10_);
					self->priv->window_containers_monitors = g_list_append (self->priv->window_containers_monitors, _tmp11_);
					_tmp12_ = monitor_clone;
					clutter_actor_add_child ((ClutterActor*) self, (ClutterActor*) _tmp12_);
					_g_object_unref0 (monitor_clone);
				}
			}
		}
	}
	_tmp13_ = self->priv->display;
	meta_display_get_monitor_geometry (_tmp13_, primary, &_tmp14_);
	primary_geometry = _tmp14_;
	_tmp15_ = self->priv->display;
	scale = meta_display_get_monitor_scale (_tmp15_, primary);
	_tmp16_ = self->priv->icon_groups;
	gala_icon_group_container_set_scale_factor (_tmp16_, scale);
	_tmp17_ = self->priv->primary_monitor_container;
	_tmp18_ = primary_geometry;
	_tmp19_ = primary_geometry;
	clutter_actor_set_position (_tmp17_, (gfloat) _tmp18_.x, (gfloat) _tmp19_.y);
	_tmp20_ = self->priv->primary_monitor_container;
	_tmp21_ = primary_geometry;
	_tmp22_ = primary_geometry;
	clutter_actor_set_size (_tmp20_, (gfloat) _tmp21_.width, (gfloat) _tmp22_.height);
	_tmp23_ = self->priv->workspaces;
	_tmp24_ = clutter_actor_get_children ((ClutterActor*) _tmp23_);
	{
		GList* child_collection = NULL;
		GList* child_it = NULL;
		child_collection = _tmp24_;
		for (child_it = child_collection; child_it != NULL; child_it = child_it->next) {
			ClutterActor* child = NULL;
			child = (ClutterActor*) child_it->data;
			{
				GalaWorkspaceClone* workspace_clone = NULL;
				ClutterActor* _tmp25_;
				GalaWorkspaceClone* _tmp26_;
				GalaWorkspaceClone* _tmp27_;
				MtkRectangle _tmp28_;
				_tmp25_ = child;
				workspace_clone = G_TYPE_CHECK_INSTANCE_CAST (_tmp25_, GALA_TYPE_WORKSPACE_CLONE, GalaWorkspaceClone);
				_tmp26_ = workspace_clone;
				gala_workspace_clone_set_monitor_scale (_tmp26_, scale);
				_tmp27_ = workspace_clone;
				_tmp28_ = primary_geometry;
				gala_workspace_clone_update_size (_tmp27_, &_tmp28_);
			}
		}
		(child_collection == NULL) ? NULL : (child_collection = (g_list_free (child_collection), NULL));
	}
}

static void
gala_multitasking_view_update_brightness_effect (GalaMultitaskingView* self)
{
	GalaDrawingStyleManager* _tmp0_;
	GalaDrawingStyleManagerColorScheme _tmp1_;
	GalaDrawingStyleManagerColorScheme _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->style_manager;
	_tmp1_ = gala_drawing_style_manager_get_prefers_color_scheme (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == GALA_DRAWING_STYLE_MANAGER_COLOR_SCHEME_DARK) {
		ClutterBrightnessContrastEffect* _tmp3_;
		_tmp3_ = self->priv->brightness_effect;
		clutter_brightness_contrast_effect_set_brightness (_tmp3_, -0.4f);
	} else {
		ClutterBrightnessContrastEffect* _tmp4_;
		_tmp4_ = self->priv->brightness_effect;
		clutter_brightness_contrast_effect_set_brightness (_tmp4_, 0.4f);
	}
}

static void
gala_multitasking_view_update_blurred_bg (GalaMultitaskingView* self)
{
	GalaBackgroundManager* _tmp0_;
	ClutterBrightnessContrastEffect* _tmp2_;
	MetaDisplay* _tmp3_;
	MetaDisplay* _tmp4_;
	GalaBackgroundManager* _tmp5_;
	GalaBackgroundManager* _tmp6_;
	GalaBackgroundManager* _tmp7_;
	GalaBlurEffect* _tmp8_;
	GalaBlurEffect* _tmp9_;
	GalaBackgroundManager* _tmp10_;
	ClutterBrightnessContrastEffect* _tmp11_;
	GalaBackgroundManager* _tmp12_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->blurred_bg;
	if (_tmp0_ != NULL) {
		GalaBackgroundManager* _tmp1_;
		_tmp1_ = self->priv->blurred_bg;
		clutter_actor_remove_child ((ClutterActor*) self, (ClutterActor*) _tmp1_);
	}
	_tmp2_ = (ClutterBrightnessContrastEffect*) clutter_brightness_contrast_effect_new ();
	g_object_ref_sink (_tmp2_);
	_g_object_unref0 (self->priv->brightness_effect);
	self->priv->brightness_effect = _tmp2_;
	gala_multitasking_view_update_brightness_effect (self);
	_tmp3_ = self->priv->display;
	_tmp4_ = self->priv->display;
	_tmp5_ = gala_background_manager_new (_tmp3_, meta_display_get_primary_monitor (_tmp4_), TRUE, FALSE);
	g_object_ref_sink (_tmp5_);
	_g_object_unref0 (self->priv->blurred_bg);
	self->priv->blurred_bg = _tmp5_;
	_tmp6_ = self->priv->blurred_bg;
	_tmp7_ = self->priv->blurred_bg;
	_tmp8_ = gala_blur_effect_new ((ClutterActor*) _tmp7_, (gfloat) 18);
	g_object_ref_sink (_tmp8_);
	_tmp9_ = _tmp8_;
	clutter_actor_add_effect ((ClutterActor*) _tmp6_, (ClutterEffect*) _tmp9_);
	_g_object_unref0 (_tmp9_);
	_tmp10_ = self->priv->blurred_bg;
	_tmp11_ = self->priv->brightness_effect;
	clutter_actor_add_effect ((ClutterActor*) _tmp10_, (ClutterEffect*) _tmp11_);
	_tmp12_ = self->priv->blurred_bg;
	clutter_actor_insert_child_below ((ClutterActor*) self, (ClutterActor*) _tmp12_, NULL);
}

static void
gala_multitasking_view_update_workspaces (GalaMultitaskingView* self)
{
	GalaActorTarget* _tmp0_;
	GList* _tmp1_;
	MetaWorkspaceManager* manager = NULL;
	MetaDisplay* _tmp8_;
	MetaWorkspaceManager* _tmp9_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->workspaces;
	_tmp1_ = clutter_actor_get_children ((ClutterActor*) _tmp0_);
	{
		GList* child_collection = NULL;
		GList* child_it = NULL;
		child_collection = _tmp1_;
		for (child_it = child_collection; child_it != NULL; child_it = child_it->next) {
			ClutterActor* child = NULL;
			child = (ClutterActor*) child_it->data;
			{
				GalaWorkspaceClone* workspace_clone = NULL;
				ClutterActor* _tmp2_;
				GalaIconGroupContainer* _tmp3_;
				GalaWorkspaceClone* _tmp4_;
				GalaIconGroup* _tmp5_;
				GalaIconGroup* _tmp6_;
				GalaWorkspaceClone* _tmp7_;
				_tmp2_ = child;
				workspace_clone = G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GALA_TYPE_WORKSPACE_CLONE, GalaWorkspaceClone);
				_tmp3_ = self->priv->icon_groups;
				_tmp4_ = workspace_clone;
				_tmp5_ = gala_workspace_clone_get_icon_group (_tmp4_);
				_tmp6_ = _tmp5_;
				gala_icon_group_container_remove_group (_tmp3_, _tmp6_);
				_tmp7_ = workspace_clone;
				clutter_actor_destroy ((ClutterActor*) _tmp7_);
			}
		}
		(child_collection == NULL) ? NULL : (child_collection = (g_list_free (child_collection), NULL));
	}
	_tmp8_ = self->priv->display;
	_tmp9_ = meta_display_get_workspace_manager (_tmp8_);
	manager = _tmp9_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp10_ = FALSE;
			_tmp10_ = TRUE;
			while (TRUE) {
				MetaWorkspaceManager* _tmp12_;
				if (!_tmp10_) {
					gint _tmp11_;
					_tmp11_ = i;
					i = _tmp11_ + 1;
				}
				_tmp10_ = FALSE;
				_tmp12_ = manager;
				if (!(i < meta_workspace_manager_get_n_workspaces (_tmp12_))) {
					break;
				}
				gala_multitasking_view_add_workspace (self, i);
			}
		}
	}
}

/**
     * Scroll through workspaces with the mouse wheel. Smooth scrolling is handled by
     * GestureController.
     */
static gboolean
gala_multitasking_view_real_scroll_event (ClutterActor* base,
                                          ClutterEvent* scroll_event)
{
	GalaMultitaskingView * self;
	ClutterScrollDirection scroll_direction = 0;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	MetaMotionDirection direction = 0;
	gboolean result;
	self = (GalaMultitaskingView*) base;
	g_return_val_if_fail (scroll_event != NULL, FALSE);
	if (!self->priv->opened) {
		result = TRUE;
		return result;
	}
	scroll_direction = clutter_event_get_scroll_direction (scroll_event);
	if (scroll_direction == CLUTTER_SCROLL_SMOOTH) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = clutter_event_get_scroll_source (scroll_event) == CLUTTER_SCROLL_SOURCE_FINGER;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		ClutterInputDevice* _tmp2_;
		_tmp2_ = clutter_event_get_source_device (scroll_event);
		_tmp0_ = clutter_input_device_get_device_type (_tmp2_) == CLUTTER_TOUCHPAD_DEVICE;
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	switch (scroll_direction) {
		case CLUTTER_SCROLL_UP:
		case CLUTTER_SCROLL_LEFT:
		{
			direction = META_MOTION_LEFT;
			break;
		}
		default:
		case CLUTTER_SCROLL_DOWN:
		case CLUTTER_SCROLL_RIGHT:
		{
			direction = META_MOTION_RIGHT;
			break;
		}
	}
	gala_multitasking_view_switch_to_next_workspace (self, direction);
	result = TRUE;
	return result;
}

void
gala_multitasking_view_move_window (GalaMultitaskingView* self,
                                    MetaWindow* window,
                                    MetaWorkspace* workspace)
{
	MetaDisplay* _tmp0_;
	GalaStaticWindowContainer* _tmp1_;
	GalaStaticWindowContainer* _tmp2_;
	GalaGestureController* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (window != NULL);
	g_return_if_fail (workspace != NULL);
	_tmp0_ = self->priv->display;
	_tmp1_ = gala_static_window_container_get_instance (_tmp0_);
	_tmp2_ = _tmp1_;
	gala_static_window_container_notify_window_moving (_tmp2_, window);
	_g_object_unref0 (_tmp2_);
	_tmp3_ = self->priv->workspaces_gesture_controller;
	gala_gesture_controller_goto (_tmp3_, (gdouble) (-meta_workspace_index (workspace)));
}

void
gala_multitasking_view_switch_to_next_workspace (GalaMultitaskingView* self,
                                                 MetaMotionDirection direction)
{
	gint _tmp0_ = 0;
	gint relative_direction = 0;
	GalaGestureController* _tmp1_;
	g_return_if_fail (self != NULL);
	if (direction == META_MOTION_LEFT) {
		_tmp0_ = 1;
	} else {
		_tmp0_ = -1;
	}
	relative_direction = _tmp0_;
	_tmp1_ = self->priv->workspaces_gesture_controller;
	gala_gesture_controller_goto (_tmp1_, gala_actor_target_get_current_commit ((GalaActorTarget*) self, GALA_GESTURE_ACTION_SWITCH_WORKSPACE) + relative_direction);
}

void
gala_multitasking_view_kill_switch_workspace (GalaMultitaskingView* self)
{
	GalaGestureController* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->workspaces_gesture_controller;
	gala_gesture_controller_cancel_gesture (_tmp0_);
}

static gboolean
_gala_multitasking_view_keybinding_filter_gala_keybinding_filter (MetaKeyBinding* binding,
                                                                  gpointer self)
{
	gboolean result;
	result = gala_multitasking_view_keybinding_filter ((GalaMultitaskingView*) self, binding);
	return result;
}

static gboolean
_variant_get1 (GVariant* value)
{
	return g_variant_get_boolean (value);
}

static void
gala_multitasking_view_real_start_progress (GalaActorTarget* base,
                                            GalaGestureAction action)
{
	GalaMultitaskingView * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	self = (GalaMultitaskingView*) base;
	g_object_get ((ClutterActor*) self, "visible", &_tmp0_, NULL);
	_tmp1_ = _tmp0_;
	if (!_tmp1_) {
		GalaWindowManagerGala* _tmp2_;
		MetaBackgroundGroup* _tmp3_;
		MetaBackgroundGroup* _tmp4_;
		GalaWindowManagerGala* _tmp5_;
		ClutterActor* _tmp6_;
		ClutterActor* _tmp7_;
		GalaWindowManagerGala* _tmp8_;
		ClutterActor* _tmp9_;
		ClutterActor* _tmp10_;
		GalaWindowManagerGala* _tmp11_;
		GalaModalProxy* _tmp12_;
		GalaModalProxy* _tmp13_;
		GalaModalProxy* _tmp14_;
		GalaGestureAction* _tmp15_;
		GalaGestureAction* _tmp16_;
		gint _tmp16__length1;
		gfloat scale = 0.0F;
		MetaDisplay* _tmp17_;
		MetaDisplay* _tmp18_;
		GalaIconGroupContainer* _tmp19_;
		GalaIconGroupContainer* _tmp20_;
		ClutterActor* _tmp21_;
		gfloat _tmp22_;
		gfloat _tmp23_;
		self->priv->opened = TRUE;
		_tmp2_ = self->priv->_wm;
		_tmp3_ = gala_window_manager_get_background_group ((GalaWindowManager*) _tmp2_);
		_tmp4_ = _tmp3_;
		clutter_actor_hide ((ClutterActor*) _tmp4_);
		_tmp5_ = self->priv->_wm;
		_tmp6_ = gala_window_manager_get_window_group ((GalaWindowManager*) _tmp5_);
		_tmp7_ = _tmp6_;
		clutter_actor_hide (_tmp7_);
		_tmp8_ = self->priv->_wm;
		_tmp9_ = gala_window_manager_get_top_window_group ((GalaWindowManager*) _tmp8_);
		_tmp10_ = _tmp9_;
		clutter_actor_hide (_tmp10_);
		clutter_actor_show ((ClutterActor*) self);
		clutter_actor_grab_key_focus ((ClutterActor*) self);
		_tmp11_ = self->priv->_wm;
		_tmp12_ = gala_window_manager_push_modal ((GalaWindowManager*) _tmp11_, (ClutterActor*) self);
		_g_object_unref0 (self->priv->modal_proxy);
		self->priv->modal_proxy = _tmp12_;
		_tmp13_ = self->priv->modal_proxy;
		gala_modal_proxy_set_keybinding_filter (_tmp13_, _gala_multitasking_view_keybinding_filter_gala_keybinding_filter, self);
		_tmp14_ = self->priv->modal_proxy;
		_tmp15_ = g_new0 (GalaGestureAction, 3);
		_tmp15_[0] = GALA_GESTURE_ACTION_MULTITASKING_VIEW;
		_tmp15_[1] = GALA_GESTURE_ACTION_SWITCH_WORKSPACE;
		_tmp15_[2] = GALA_GESTURE_ACTION_ZOOM;
		_tmp16_ = _tmp15_;
		_tmp16__length1 = 3;
		gala_modal_proxy_allow_actions (_tmp14_, _tmp16_, (gint) 3);
		_tmp16_ = (g_free (_tmp16_), NULL);
		_tmp17_ = self->priv->display;
		_tmp18_ = self->priv->display;
		scale = meta_display_get_monitor_scale (_tmp17_, meta_display_get_primary_monitor (_tmp18_));
		_tmp19_ = self->priv->icon_groups;
		gala_icon_group_container_force_reposition (_tmp19_);
		_tmp20_ = self->priv->icon_groups;
		_tmp21_ = self->priv->primary_monitor_container;
		_tmp22_ = clutter_actor_get_height (_tmp21_);
		_tmp23_ = _tmp22_;
		clutter_actor_set_y ((ClutterActor*) _tmp20_, _tmp23_ - gala_utils_scale_to_int (GALA_WORKSPACE_CLONE_BOTTOM_OFFSET - 20, scale));
		gala_multitasking_view_reposition_icon_groups (self, FALSE);
		if (action != GALA_GESTURE_ACTION_MULTITASKING_VIEW) {
			GalaIconGroupContainer* _tmp24_;
			_tmp24_ = self->priv->icon_groups;
			clutter_actor_hide ((ClutterActor*) _tmp24_);
		}
	} else {
		if (action == GALA_GESTURE_ACTION_MULTITASKING_VIEW) {
			gala_drag_drop_action_cancel_all_by_id ("multitaskingview-window");
		}
	}
	if (action == GALA_GESTURE_ACTION_SWITCH_WORKSPACE) {
		GalaWorkspaceManager* _tmp25_;
		gboolean _tmp26_ = FALSE;
		gboolean _tmp27_ = FALSE;
		GalaGestureController* _tmp28_;
		GVariant* _tmp29_;
		GVariant* _tmp30_;
		_tmp25_ = gala_workspace_manager_get_default ();
		gala_workspace_manager_freeze_remove (_tmp25_);
		_tmp28_ = self->priv->workspaces_gesture_controller;
		_tmp29_ = gala_gesture_controller_get_action_info (_tmp28_);
		_tmp30_ = _tmp29_;
		if (_tmp30_ != NULL) {
			GalaGestureController* _tmp31_;
			GVariant* _tmp32_;
			GVariant* _tmp33_;
			gboolean _tmp34_;
			_tmp31_ = self->priv->workspaces_gesture_controller;
			_tmp32_ = gala_gesture_controller_get_action_info (_tmp31_);
			_tmp33_ = _tmp32_;
			_tmp34_ = _variant_get1 (_tmp33_);
			_tmp27_ = _tmp34_;
		} else {
			_tmp27_ = FALSE;
		}
		if (_tmp27_) {
			MetaDisplay* _tmp35_;
			MetaWindow* _tmp36_;
			MetaWindow* _tmp37_;
			_tmp35_ = self->priv->display;
			_tmp36_ = meta_display_get_focus_window (_tmp35_);
			_tmp37_ = _tmp36_;
			_tmp26_ = _tmp37_ != NULL;
		} else {
			_tmp26_ = FALSE;
		}
		if (_tmp26_) {
			MetaWindow* moving = NULL;
			MetaDisplay* _tmp38_;
			MetaWindow* _tmp39_;
			MetaWindow* _tmp40_;
			MetaWindow* _tmp41_;
			MetaDisplay* _tmp42_;
			GalaStaticWindowContainer* _tmp43_;
			GalaStaticWindowContainer* _tmp44_;
			MetaWindow* _tmp45_;
			gboolean _tmp46_ = FALSE;
			MetaWindow* _tmp47_;
			MetaWorkspace* _tmp48_;
			MetaDisplay* _tmp49_;
			MetaWorkspaceManager* _tmp50_;
			gint _tmp51_;
			gint _tmp52_;
			_tmp38_ = self->priv->display;
			_tmp39_ = meta_display_get_focus_window (_tmp38_);
			_tmp40_ = _tmp39_;
			_tmp41_ = _g_object_ref0 (_tmp40_);
			moving = _tmp41_;
			_tmp42_ = self->priv->display;
			_tmp43_ = gala_static_window_container_get_instance (_tmp42_);
			_tmp44_ = _tmp43_;
			_tmp45_ = moving;
			gala_static_window_container_notify_window_moving (_tmp44_, _tmp45_);
			_g_object_unref0 (_tmp44_);
			_tmp47_ = moving;
			_tmp48_ = meta_window_get_workspace (_tmp47_);
			_tmp49_ = self->priv->display;
			_tmp50_ = meta_display_get_workspace_manager (_tmp49_);
			_tmp51_ = meta_workspace_manager_get_n_workspaces (_tmp50_);
			_tmp52_ = _tmp51_;
			if (meta_workspace_index (_tmp48_) == (_tmp52_ - 2)) {
				MetaWindow* _tmp53_;
				MetaWorkspace* _tmp54_;
				MetaWindow* _tmp55_;
				_tmp53_ = moving;
				_tmp54_ = meta_window_get_workspace (_tmp53_);
				_tmp55_ = moving;
				_tmp46_ = gala_utils_get_n_windows (_tmp54_, TRUE, _tmp55_) == ((guint) 0);
			} else {
				_tmp46_ = FALSE;
			}
			if (_tmp46_) {
				GalaGestureController* _tmp56_;
				GalaGestureController* _tmp57_;
				gdouble _tmp58_;
				gdouble _tmp59_;
				_tmp56_ = self->priv->workspaces_gesture_controller;
				_tmp57_ = self->priv->workspaces_gesture_controller;
				_tmp58_ = gala_gesture_controller_get_overshoot_lower_clamp (_tmp57_);
				_tmp59_ = _tmp58_;
				gala_gesture_controller_set_overshoot_lower_clamp (_tmp57_, _tmp59_ + 1);
			}
			_g_object_unref0 (moving);
		}
	}
}

static void
gala_multitasking_view_real_commit_progress (GalaActorTarget* base,
                                             GalaGestureAction action,
                                             gdouble to)
{
	GalaMultitaskingView * self;
	self = (GalaMultitaskingView*) base;
	switch (action) {
		case GALA_GESTURE_ACTION_MULTITASKING_VIEW:
		{
			gboolean _tmp0_ = FALSE;
			GalaGestureController* _tmp4_;
			if (to > 0.5) {
				_tmp0_ = TRUE;
			} else {
				GalaGestureController* _tmp1_;
				gboolean _tmp2_;
				gboolean _tmp3_;
				_tmp1_ = self->priv->workspaces_gesture_controller;
				_tmp2_ = gala_gesture_controller_get_recognizing (_tmp1_);
				_tmp3_ = _tmp2_;
				_tmp0_ = _tmp3_;
			}
			self->priv->opened = _tmp0_;
			_tmp4_ = self->priv->workspaces_gesture_controller;
			gala_gesture_controller_cancel_gesture (_tmp4_);
			break;
		}
		case GALA_GESTURE_ACTION_SWITCH_WORKSPACE:
		{
			gboolean _tmp5_ = FALSE;
			MetaWorkspace* target_workspace = NULL;
			MetaDisplay* _tmp9_;
			MetaWorkspaceManager* _tmp10_;
			MetaWorkspace* _tmp11_;
			MetaWindow* moving_window = NULL;
			MetaDisplay* _tmp12_;
			GalaStaticWindowContainer* _tmp13_;
			GalaStaticWindowContainer* _tmp14_;
			MetaWindow* _tmp15_;
			MetaWindow* _tmp16_;
			MetaWindow* _tmp17_;
			MetaWindow* _tmp18_;
			MetaWindow* _tmp19_;
			if (gala_actor_target_get_current_commit ((GalaActorTarget*) self, GALA_GESTURE_ACTION_MULTITASKING_VIEW) > 0.5) {
				_tmp5_ = TRUE;
			} else {
				GalaGestureController* _tmp6_;
				gboolean _tmp7_;
				gboolean _tmp8_;
				_tmp6_ = self->priv->multitasking_gesture_controller;
				_tmp7_ = gala_gesture_controller_get_recognizing (_tmp6_);
				_tmp8_ = _tmp7_;
				_tmp5_ = _tmp8_;
			}
			self->priv->opened = _tmp5_;
			_tmp9_ = self->priv->display;
			_tmp10_ = meta_display_get_workspace_manager (_tmp9_);
			_tmp11_ = meta_workspace_manager_get_workspace_by_index (_tmp10_, (gint) (-to));
			target_workspace = _tmp11_;
			_tmp12_ = self->priv->display;
			_tmp13_ = gala_static_window_container_get_instance (_tmp12_);
			_tmp14_ = _tmp13_;
			_tmp15_ = gala_static_window_container_get_moving_window (_tmp14_);
			_tmp16_ = _tmp15_;
			_tmp17_ = _g_object_ref0 (_tmp16_);
			_tmp18_ = _tmp17_;
			_g_object_unref0 (_tmp14_);
			moving_window = _tmp18_;
			_tmp19_ = moving_window;
			if (_tmp19_ != NULL) {
				MetaWindow* _tmp20_;
				MetaWorkspace* _tmp21_;
				MetaWorkspace* _tmp22_;
				MetaWindow* _tmp23_;
				MetaDisplay* _tmp24_;
				_tmp20_ = moving_window;
				_tmp21_ = target_workspace;
				meta_window_change_workspace (_tmp20_, _tmp21_);
				_tmp22_ = target_workspace;
				_tmp23_ = moving_window;
				_tmp24_ = self->priv->display;
				meta_workspace_activate_with_focus (_tmp22_, _tmp23_, meta_display_get_current_time (_tmp24_));
			} else {
				MetaWorkspace* _tmp25_;
				MetaDisplay* _tmp26_;
				_tmp25_ = target_workspace;
				_tmp26_ = self->priv->display;
				meta_workspace_activate (_tmp25_, meta_display_get_current_time (_tmp26_));
			}
			_g_object_unref0 (moving_window);
			break;
		}
		default:
		{
			break;
		}
	}
}

static void
gala_multitasking_view_real_end_progress (GalaActorTarget* base,
                                          GalaGestureAction action)
{
	GalaMultitaskingView * self;
	gboolean _tmp0_ = FALSE;
	self = (GalaMultitaskingView*) base;
	if (!self->priv->opened) {
		gboolean _tmp1_;
		gboolean _tmp2_;
		_tmp1_ = gala_actor_target_get_animating ((GalaActorTarget*) self);
		_tmp2_ = _tmp1_;
		_tmp0_ = !_tmp2_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GalaWindowManagerGala* _tmp3_;
		MetaBackgroundGroup* _tmp4_;
		MetaBackgroundGroup* _tmp5_;
		GalaWindowManagerGala* _tmp6_;
		ClutterActor* _tmp7_;
		ClutterActor* _tmp8_;
		GalaWindowManagerGala* _tmp9_;
		ClutterActor* _tmp10_;
		ClutterActor* _tmp11_;
		GalaIconGroupContainer* _tmp12_;
		GalaWindowManagerGala* _tmp13_;
		GalaModalProxy* _tmp14_;
		_tmp3_ = self->priv->_wm;
		_tmp4_ = gala_window_manager_get_background_group ((GalaWindowManager*) _tmp3_);
		_tmp5_ = _tmp4_;
		clutter_actor_show ((ClutterActor*) _tmp5_);
		_tmp6_ = self->priv->_wm;
		_tmp7_ = gala_window_manager_get_window_group ((GalaWindowManager*) _tmp6_);
		_tmp8_ = _tmp7_;
		clutter_actor_show (_tmp8_);
		_tmp9_ = self->priv->_wm;
		_tmp10_ = gala_window_manager_get_top_window_group ((GalaWindowManager*) _tmp9_);
		_tmp11_ = _tmp10_;
		clutter_actor_show (_tmp11_);
		_tmp12_ = self->priv->icon_groups;
		clutter_actor_show ((ClutterActor*) _tmp12_);
		clutter_actor_hide ((ClutterActor*) self);
		_tmp13_ = self->priv->_wm;
		_tmp14_ = self->priv->modal_proxy;
		gala_window_manager_pop_modal ((GalaWindowManager*) _tmp13_, _tmp14_);
	}
	if (action == GALA_GESTURE_ACTION_SWITCH_WORKSPACE) {
		GalaWorkspaceManager* _tmp15_;
		MetaDisplay* _tmp16_;
		GalaStaticWindowContainer* _tmp17_;
		GalaStaticWindowContainer* _tmp18_;
		MetaDisplay* _tmp19_;
		MetaWorkspaceManager* _tmp20_;
		_tmp15_ = gala_workspace_manager_get_default ();
		gala_workspace_manager_thaw_remove (_tmp15_);
		_tmp16_ = self->priv->display;
		_tmp17_ = gala_static_window_container_get_instance (_tmp16_);
		_tmp18_ = _tmp17_;
		gala_static_window_container_notify_move_ended (_tmp18_);
		_g_object_unref0 (_tmp18_);
		_tmp19_ = self->priv->display;
		_tmp20_ = meta_display_get_workspace_manager (_tmp19_);
		g_object_notify ((GObject*) _tmp20_, "n-workspaces");
	}
}

static void
gala_multitasking_view_reposition_icon_groups (GalaMultitaskingView* self,
                                               gboolean animate)
{
	MetaWorkspaceManager* manager = NULL;
	MetaDisplay* _tmp0_;
	MetaWorkspaceManager* _tmp1_;
	gint active_index = 0;
	MetaWorkspaceManager* _tmp2_;
	MetaWorkspace* _tmp3_;
	gfloat scale = 0.0F;
	MetaDisplay* _tmp7_;
	MetaDisplay* _tmp8_;
	gfloat icon_groups_width = 0.0F;
	GalaIconGroupContainer* _tmp9_;
	ClutterActor* _tmp10_;
	gfloat _tmp11_;
	gfloat _tmp12_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->display;
	_tmp1_ = meta_display_get_workspace_manager (_tmp0_);
	manager = _tmp1_;
	_tmp2_ = manager;
	_tmp3_ = meta_workspace_manager_get_active_workspace (_tmp2_);
	active_index = meta_workspace_index (_tmp3_);
	if (animate) {
		GalaIconGroupContainer* _tmp4_;
		GalaIconGroupContainer* _tmp5_;
		GalaIconGroupContainer* _tmp6_;
		_tmp4_ = self->priv->icon_groups;
		clutter_actor_save_easing_state ((ClutterActor*) _tmp4_);
		_tmp5_ = self->priv->icon_groups;
		clutter_actor_set_easing_mode ((ClutterActor*) _tmp5_, CLUTTER_EASE_OUT_QUAD);
		_tmp6_ = self->priv->icon_groups;
		clutter_actor_set_easing_duration ((ClutterActor*) _tmp6_, (guint) 200);
	}
	_tmp7_ = self->priv->display;
	_tmp8_ = self->priv->display;
	scale = meta_display_get_monitor_scale (_tmp7_, meta_display_get_primary_monitor (_tmp8_));
	_tmp9_ = self->priv->icon_groups;
	icon_groups_width = gala_icon_group_container_calculate_total_width (_tmp9_);
	_tmp10_ = self->priv->primary_monitor_container;
	_tmp11_ = clutter_actor_get_width (_tmp10_);
	_tmp12_ = _tmp11_;
	if (icon_groups_width > _tmp12_) {
		GalaIconGroupContainer* _tmp13_;
		ClutterActor* _tmp14_;
		gfloat _tmp15_;
		gfloat _tmp16_;
		ClutterActor* _tmp17_;
		gfloat _tmp18_;
		gfloat _tmp19_;
		_tmp13_ = self->priv->icon_groups;
		_tmp14_ = self->priv->primary_monitor_container;
		_tmp15_ = clutter_actor_get_width (_tmp14_);
		_tmp16_ = _tmp15_;
		_tmp17_ = self->priv->primary_monitor_container;
		_tmp18_ = clutter_actor_get_width (_tmp17_);
		_tmp19_ = _tmp18_;
		clutter_actor_set_x ((ClutterActor*) _tmp13_, CLAMP (((-active_index) * gala_utils_scale_to_int (GALA_ICON_GROUP_CONTAINER_SPACING + GALA_ICON_GROUP_SIZE, scale)) + (_tmp16_ / 2), (_tmp19_ - icon_groups_width) - gala_utils_scale_to_int (64, scale), (gfloat) gala_utils_scale_to_int (64, scale)));
	} else {
		GalaIconGroupContainer* _tmp20_;
		ClutterActor* _tmp21_;
		gfloat _tmp22_;
		gfloat _tmp23_;
		_tmp20_ = self->priv->icon_groups;
		_tmp21_ = self->priv->primary_monitor_container;
		_tmp22_ = clutter_actor_get_width (_tmp21_);
		_tmp23_ = _tmp22_;
		clutter_actor_set_x ((ClutterActor*) _tmp20_, (_tmp23_ / 2) - (icon_groups_width / 2));
	}
	if (animate) {
		GalaIconGroupContainer* _tmp24_;
		_tmp24_ = self->priv->icon_groups;
		clutter_actor_restore_easing_state ((ClutterActor*) _tmp24_);
	}
}

static void
_gala_multitasking_view_window_selected_gala_workspace_clone_window_selected (GalaWorkspaceClone* _sender,
                                                                              MetaWindow* window,
                                                                              gpointer self)
{
	gala_multitasking_view_window_selected ((GalaMultitaskingView*) self, window);
}

static void
gala_multitasking_view_add_workspace (GalaMultitaskingView* self,
                                      gint num)
{
	MetaWorkspaceManager* manager = NULL;
	MetaDisplay* _tmp0_;
	MetaWorkspaceManager* _tmp1_;
	gfloat scale = 0.0F;
	MetaDisplay* _tmp2_;
	MetaDisplay* _tmp3_;
	GalaWorkspaceClone* workspace = NULL;
	GalaWindowManagerGala* _tmp4_;
	MetaWorkspace* _tmp5_;
	GalaWorkspaceClone* _tmp6_;
	GalaActorTarget* _tmp7_;
	GalaIconGroupContainer* _tmp8_;
	GalaIconGroup* _tmp9_;
	GalaIconGroup* _tmp10_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->display;
	_tmp1_ = meta_display_get_workspace_manager (_tmp0_);
	manager = _tmp1_;
	_tmp2_ = self->priv->display;
	_tmp3_ = self->priv->display;
	scale = meta_display_get_monitor_scale (_tmp2_, meta_display_get_primary_monitor (_tmp3_));
	_tmp4_ = self->priv->_wm;
	_tmp5_ = meta_workspace_manager_get_workspace_by_index (manager, num);
	_tmp6_ = gala_workspace_clone_new ((GalaWindowManager*) _tmp4_, _tmp5_, scale);
	g_object_ref_sink (_tmp6_);
	workspace = _tmp6_;
	_tmp7_ = self->priv->workspaces;
	clutter_actor_insert_child_at_index ((ClutterActor*) _tmp7_, (ClutterActor*) workspace, num);
	_tmp8_ = self->priv->icon_groups;
	_tmp9_ = gala_workspace_clone_get_icon_group (workspace);
	_tmp10_ = _tmp9_;
	gala_icon_group_container_add_group (_tmp8_, _tmp10_);
	g_signal_connect_object (workspace, "window-selected", (GCallback) _gala_multitasking_view_window_selected_gala_workspace_clone_window_selected, self, 0);
	gala_multitasking_view_reposition_icon_groups (self, FALSE);
	_g_object_unref0 (workspace);
}

static void
gala_multitasking_view_remove_workspace (GalaMultitaskingView* self,
                                         gint num)
{
	GalaWorkspaceClone* workspace = NULL;
	MetaWorkspaceManager* manager = NULL;
	MetaDisplay* _tmp0_;
	MetaWorkspaceManager* _tmp1_;
	GList* existing_workspaces = NULL;
	GalaActorTarget* _tmp8_;
	GList* _tmp9_;
	GalaWorkspaceClone* _tmp17_;
	GalaWorkspaceClone* _tmp18_;
	guint _tmp19_;
	GalaIconGroupContainer* _tmp20_;
	GalaWorkspaceClone* _tmp21_;
	GalaIconGroup* _tmp22_;
	GalaIconGroup* _tmp23_;
	GalaWorkspaceClone* _tmp28_;
	GalaGestureController* _tmp29_;
	MetaWorkspaceManager* _tmp30_;
	g_return_if_fail (self != NULL);
	workspace = NULL;
	_tmp0_ = self->priv->display;
	_tmp1_ = meta_display_get_workspace_manager (_tmp0_);
	manager = _tmp1_;
	existing_workspaces = NULL;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				MetaWorkspaceManager* _tmp4_;
				MetaWorkspaceManager* _tmp5_;
				MetaWorkspace* _tmp6_;
				MetaWorkspace* _tmp7_;
				if (!_tmp2_) {
					gint _tmp3_;
					_tmp3_ = i;
					i = _tmp3_ + 1;
				}
				_tmp2_ = FALSE;
				_tmp4_ = manager;
				if (!(i < meta_workspace_manager_get_n_workspaces (_tmp4_))) {
					break;
				}
				_tmp5_ = manager;
				_tmp6_ = meta_workspace_manager_get_workspace_by_index (_tmp5_, i);
				_tmp7_ = _g_object_ref0 (_tmp6_);
				existing_workspaces = g_list_append (existing_workspaces, _tmp7_);
			}
		}
	}
	_tmp8_ = self->priv->workspaces;
	_tmp9_ = clutter_actor_get_children ((ClutterActor*) _tmp8_);
	{
		GList* child_collection = NULL;
		GList* child_it = NULL;
		child_collection = _tmp9_;
		for (child_it = child_collection; child_it != NULL; child_it = child_it->next) {
			ClutterActor* child = NULL;
			child = (ClutterActor*) child_it->data;
			{
				GalaWorkspaceClone* clone = NULL;
				ClutterActor* _tmp10_;
				GList* _tmp11_;
				GalaWorkspaceClone* _tmp12_;
				MetaWorkspace* _tmp13_;
				MetaWorkspace* _tmp14_;
				_tmp10_ = child;
				clone = G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, GALA_TYPE_WORKSPACE_CLONE, GalaWorkspaceClone);
				_tmp11_ = existing_workspaces;
				_tmp12_ = clone;
				_tmp13_ = gala_workspace_clone_get_workspace (_tmp12_);
				_tmp14_ = _tmp13_;
				if (g_list_index (_tmp11_, _tmp14_) < 0) {
					GalaWorkspaceClone* _tmp15_;
					GalaWorkspaceClone* _tmp16_;
					_tmp15_ = clone;
					_tmp16_ = _g_object_ref0 (_tmp15_);
					_g_object_unref0 (workspace);
					workspace = _tmp16_;
					break;
				}
			}
		}
		(child_collection == NULL) ? NULL : (child_collection = (g_list_free (child_collection), NULL));
	}
	_tmp17_ = workspace;
	if (_tmp17_ == NULL) {
		(existing_workspaces == NULL) ? NULL : (existing_workspaces = (_g_list_free__g_object_unref0_ (existing_workspaces), NULL));
		_g_object_unref0 (workspace);
		return;
	}
	_tmp18_ = workspace;
	g_signal_parse_name ("window-selected", GALA_TYPE_WORKSPACE_CLONE, &_tmp19_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp18_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp19_, 0, NULL, (GCallback) _gala_multitasking_view_window_selected_gala_workspace_clone_window_selected, self);
	_tmp20_ = self->priv->icon_groups;
	_tmp21_ = workspace;
	_tmp22_ = gala_workspace_clone_get_icon_group (_tmp21_);
	_tmp23_ = _tmp22_;
	if (clutter_actor_contains ((ClutterActor*) _tmp20_, (ClutterActor*) _tmp23_)) {
		GalaIconGroupContainer* _tmp24_;
		GalaWorkspaceClone* _tmp25_;
		GalaIconGroup* _tmp26_;
		GalaIconGroup* _tmp27_;
		_tmp24_ = self->priv->icon_groups;
		_tmp25_ = workspace;
		_tmp26_ = gala_workspace_clone_get_icon_group (_tmp25_);
		_tmp27_ = _tmp26_;
		gala_icon_group_container_remove_group (_tmp24_, _tmp27_);
	}
	_tmp28_ = workspace;
	clutter_actor_destroy ((ClutterActor*) _tmp28_);
	gala_multitasking_view_reposition_icon_groups (self, self->priv->opened);
	_tmp29_ = self->priv->workspaces_gesture_controller;
	_tmp30_ = manager;
	gala_gesture_controller_set_progress (_tmp29_, (gdouble) (-meta_workspace_manager_get_active_workspace_index (_tmp30_)));
	(existing_workspaces == NULL) ? NULL : (existing_workspaces = (_g_list_free__g_object_unref0_ (existing_workspaces), NULL));
	_g_object_unref0 (workspace);
}

static void
gala_multitasking_view_on_workspaces_reordered (GalaMultitaskingView* self)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	g_return_if_fail (self != NULL);
	g_object_get ((ClutterActor*) self, "visible", &_tmp0_, NULL);
	_tmp1_ = _tmp0_;
	if (!_tmp1_) {
		MetaWorkspaceManager* manager = NULL;
		MetaDisplay* _tmp2_;
		MetaWorkspaceManager* _tmp3_;
		GalaGestureController* _tmp4_;
		MetaWorkspaceManager* _tmp5_;
		_tmp2_ = self->priv->display;
		_tmp3_ = meta_display_get_workspace_manager (_tmp2_);
		manager = _tmp3_;
		_tmp4_ = self->priv->workspaces_gesture_controller;
		_tmp5_ = manager;
		gala_gesture_controller_set_progress (_tmp4_, (gdouble) (-meta_workspace_manager_get_active_workspace_index (_tmp5_)));
	}
	gala_multitasking_view_reposition_icon_groups (self, FALSE);
}

static void
gala_multitasking_view_on_workspace_switched (GalaMultitaskingView* self,
                                              gint from,
                                              gint to)
{
	g_return_if_fail (self != NULL);
	if (((gint) (-gala_actor_target_get_current_commit ((GalaActorTarget*) self, GALA_GESTURE_ACTION_SWITCH_WORKSPACE))) != to) {
		GalaGestureController* _tmp0_;
		_tmp0_ = self->priv->workspaces_gesture_controller;
		gala_gesture_controller_goto (_tmp0_, (gdouble) (-to));
	}
}

/**
     * Collect key events, mainly for redirecting them to the WindowCloneContainers to
     * select the active window.
     */
static gboolean
gala_multitasking_view_real_key_press_event (ClutterActor* base,
                                             ClutterEvent* event)
{
	GalaMultitaskingView * self;
	GalaWindowCloneContainer* _tmp0_;
	GalaWindowCloneContainer* _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_;
	gboolean result;
	self = (GalaMultitaskingView*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	if (!self->priv->opened) {
		result = CLUTTER_EVENT_PROPAGATE;
		return result;
	}
	_tmp0_ = gala_multitasking_view_get_active_window_clone_container (self);
	_tmp1_ = _tmp0_;
	g_signal_emit_by_name ((ClutterActor*) _tmp1_, "key-press-event", event, &_tmp2_);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp1_);
	result = _tmp3_;
	return result;
}

/**
     * Finds the active WorkspaceClone
     *
     * @return The active WorkspaceClone
     */
static GalaWindowCloneContainer*
gala_multitasking_view_get_active_window_clone_container (GalaMultitaskingView* self)
{
	MetaWorkspaceManager* manager = NULL;
	MetaDisplay* _tmp0_;
	MetaWorkspaceManager* _tmp1_;
	MetaWorkspace* active_workspace = NULL;
	MetaWorkspaceManager* _tmp2_;
	MetaWorkspace* _tmp3_;
	GalaActorTarget* _tmp4_;
	GList* _tmp5_;
	GalaWindowCloneContainer* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->display;
	_tmp1_ = meta_display_get_workspace_manager (_tmp0_);
	manager = _tmp1_;
	_tmp2_ = manager;
	_tmp3_ = meta_workspace_manager_get_active_workspace (_tmp2_);
	active_workspace = _tmp3_;
	_tmp4_ = self->priv->workspaces;
	_tmp5_ = clutter_actor_get_children ((ClutterActor*) _tmp4_);
	{
		GList* child_collection = NULL;
		GList* child_it = NULL;
		child_collection = _tmp5_;
		for (child_it = child_collection; child_it != NULL; child_it = child_it->next) {
			ClutterActor* child = NULL;
			child = (ClutterActor*) child_it->data;
			{
				GalaWorkspaceClone* workspace_clone = NULL;
				ClutterActor* _tmp6_;
				GalaWorkspaceClone* _tmp7_;
				MetaWorkspace* _tmp8_;
				MetaWorkspace* _tmp9_;
				MetaWorkspace* _tmp10_;
				_tmp6_ = child;
				workspace_clone = G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, GALA_TYPE_WORKSPACE_CLONE, GalaWorkspaceClone);
				_tmp7_ = workspace_clone;
				_tmp8_ = gala_workspace_clone_get_workspace (_tmp7_);
				_tmp9_ = _tmp8_;
				_tmp10_ = active_workspace;
				if (_tmp9_ == _tmp10_) {
					GalaWorkspaceClone* _tmp11_;
					GalaWindowCloneContainer* _tmp12_;
					GalaWindowCloneContainer* _tmp13_;
					GalaWindowCloneContainer* _tmp14_;
					_tmp11_ = workspace_clone;
					_tmp12_ = gala_workspace_clone_get_window_container (_tmp11_);
					_tmp13_ = _tmp12_;
					_tmp14_ = _g_object_ref0 (_tmp13_);
					result = _tmp14_;
					(child_collection == NULL) ? NULL : (child_collection = (g_list_free (child_collection), NULL));
					return result;
				}
			}
		}
		(child_collection == NULL) ? NULL : (child_collection = (g_list_free (child_collection), NULL));
	}
	g_assert_not_reached ();
}

static void
gala_multitasking_view_window_selected (GalaMultitaskingView* self,
                                        MetaWindow* window)
{
	guint32 time = 0U;
	MetaDisplay* _tmp0_;
	MetaWorkspaceManager* manager = NULL;
	MetaDisplay* _tmp1_;
	MetaWorkspaceManager* _tmp2_;
	MetaWorkspace* workspace = NULL;
	MetaWorkspace* _tmp3_;
	MetaWorkspace* _tmp4_;
	MetaWorkspaceManager* _tmp5_;
	MetaWorkspace* _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (window != NULL);
	_tmp0_ = self->priv->display;
	time = meta_display_get_current_time (_tmp0_);
	_tmp1_ = self->priv->display;
	_tmp2_ = meta_display_get_workspace_manager (_tmp1_);
	manager = _tmp2_;
	_tmp3_ = meta_window_get_workspace (window);
	workspace = _tmp3_;
	_tmp4_ = workspace;
	_tmp5_ = manager;
	_tmp6_ = meta_workspace_manager_get_active_workspace (_tmp5_);
	if (_tmp4_ != _tmp6_) {
		MetaWorkspace* _tmp7_;
		_tmp7_ = workspace;
		meta_workspace_activate (_tmp7_, time);
	} else {
		meta_window_activate (window, time);
		gala_activatable_component_close ((GalaActivatableComponent*) self, NULL);
	}
}

/**
     * {@inheritDoc}
     */
static gboolean
gala_multitasking_view_real_is_opened (GalaActivatableComponent* base)
{
	GalaMultitaskingView * self;
	gboolean result;
	self = (GalaMultitaskingView*) base;
	result = self->priv->opened;
	return result;
}

/**
     * {@inheritDoc}
     */
static void
gala_multitasking_view_real_open (GalaActivatableComponent* base,
                                  GHashTable* hints)
{
	GalaMultitaskingView * self;
	GalaGestureController* _tmp0_;
	self = (GalaMultitaskingView*) base;
	_tmp0_ = self->priv->multitasking_gesture_controller;
	gala_gesture_controller_goto (_tmp0_, (gdouble) 1);
}

/**
     * {@inheritDoc}
     */
static void
gala_multitasking_view_real_close (GalaActivatableComponent* base,
                                   GHashTable* hints)
{
	GalaMultitaskingView * self;
	GalaGestureController* _tmp0_;
	self = (GalaMultitaskingView*) base;
	_tmp0_ = self->priv->multitasking_gesture_controller;
	gala_gesture_controller_goto (_tmp0_, (gdouble) 0);
}

static gboolean
gala_multitasking_view_keybinding_filter (GalaMultitaskingView* self,
                                          MetaKeyBinding* binding)
{
	MetaKeyBindingAction action = 0;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	GQuark _tmp4_ = 0U;
	static GQuark _tmp3_label0 = 0;
	static GQuark _tmp3_label1 = 0;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (binding != NULL, FALSE);
	_tmp0_ = meta_key_binding_get_name (binding);
	action = meta_prefs_get_keybinding_action (_tmp0_);
	switch (action) {
		case META_KEYBINDING_ACTION_NONE:
		case META_KEYBINDING_ACTION_LOCATE_POINTER_KEY:
		{
			result = FALSE;
			return result;
		}
		default:
		{
			break;
		}
	}
	_tmp1_ = meta_key_binding_get_name (binding);
	_tmp2_ = _tmp1_;
	_tmp4_ = (NULL == _tmp2_) ? 0 : g_quark_from_string (_tmp2_);
	if ((_tmp4_ == ((0 != _tmp3_label0) ? _tmp3_label0 : (_tmp3_label0 = g_quark_from_static_string ("screenshot")))) || (_tmp4_ == ((0 != _tmp3_label1) ? _tmp3_label1 : (_tmp3_label1 = g_quark_from_static_string ("screenshot-clip"))))) {
		switch (0) {
			default:
			{
				result = FALSE;
				return result;
			}
		}
	} else {
		switch (0) {
			default:
			{
				break;
			}
		}
	}
	result = TRUE;
	return result;
}

static gboolean
gala_multitasking_view_real_captured_event (ClutterActor* base,
                                            ClutterEvent* event)
{
	GalaMultitaskingView * self;
	ClutterEventType type = 0;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean result;
	self = (GalaMultitaskingView*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	type = clutter_event_type (event);
	if (!self->priv->opened) {
		gboolean _tmp3_;
		gboolean _tmp4_;
		_tmp3_ = gala_actor_target_get_animating ((GalaActorTarget*) self);
		_tmp4_ = _tmp3_;
		_tmp2_ = _tmp4_;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		_tmp1_ = type != CLUTTER_ENTER;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_tmp0_ = type != CLUTTER_LEAVE;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = CLUTTER_EVENT_STOP;
		return result;
	}
	result = CLUTTER_EVENT_PROPAGATE;
	return result;
}

GalaWindowManagerGala*
gala_multitasking_view_get_wm (GalaMultitaskingView* self)
{
	GalaWindowManagerGala* result;
	GalaWindowManagerGala* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_wm;
	result = _tmp0_;
	return result;
}

static void
gala_multitasking_view_set_wm (GalaMultitaskingView* self,
                               GalaWindowManagerGala* value)
{
	GalaWindowManagerGala* old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_multitasking_view_get_wm (self);
	if (old_value != value) {
		GalaWindowManagerGala* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_wm);
		self->priv->_wm = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gala_multitasking_view_properties[GALA_MULTITASKING_VIEW_WM_PROPERTY]);
	}
}

static Block59Data*
block59_data_ref (Block59Data* _data59_)
{
	g_atomic_int_inc (&_data59_->_ref_count_);
	return _data59_;
}

static void
block59_data_unref (void * _userdata_)
{
	Block59Data* _data59_;
	_data59_ = (Block59Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data59_->_ref_count_)) {
		GalaMultitaskingView* self;
		self = _data59_->self;
		_g_object_unref0 (self);
		g_slice_free (Block59Data, _data59_);
	}
}

static void
_gala_multitasking_view_add_workspace_meta_workspace_manager_workspace_added (MetaWorkspaceManager* _sender,
                                                                              gint object,
                                                                              gpointer self)
{
	gala_multitasking_view_add_workspace ((GalaMultitaskingView*) self, object);
}

static void
_gala_multitasking_view_remove_workspace_meta_workspace_manager_workspace_removed (MetaWorkspaceManager* _sender,
                                                                                   gint object,
                                                                                   gpointer self)
{
	gala_multitasking_view_remove_workspace ((GalaMultitaskingView*) self, object);
}

static void
_gala_multitasking_view_on_workspaces_reordered_meta_workspace_manager_workspaces_reordered (MetaWorkspaceManager* _sender,
                                                                                             gpointer self)
{
	gala_multitasking_view_on_workspaces_reordered ((GalaMultitaskingView*) self);
}

static void
_gala_multitasking_view_on_workspace_switched_meta_workspace_manager_workspace_switched (MetaWorkspaceManager* _sender,
                                                                                         gint object,
                                                                                         gint p0,
                                                                                         MetaMotionDirection p1,
                                                                                         gpointer self)
{
	gala_multitasking_view_on_workspace_switched ((GalaMultitaskingView*) self, object, p0);
}

static void
_gala_multitasking_view___lambda89_ (Block59Data* _data59_)
{
	GalaMultitaskingView* self;
	GalaGestureController* _tmp0_;
	MetaWorkspaceManager* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	self = _data59_->self;
	_tmp0_ = self->priv->workspaces_gesture_controller;
	_tmp1_ = _data59_->manager;
	_tmp2_ = meta_workspace_manager_get_n_workspaces (_tmp1_);
	_tmp3_ = _tmp2_;
	gala_gesture_controller_set_overshoot_lower_clamp (_tmp0_, ((-_tmp3_) - 0.1) + 1);
}

static void
__gala_multitasking_view___lambda89__g_object_notify (GObject* _sender,
                                                      GParamSpec* pspec,
                                                      gpointer self)
{
	_gala_multitasking_view___lambda89_ (self);
}

static void
_gala_multitasking_view_update_monitors_meta_monitor_manager_monitors_changed (MetaMonitorManager* _sender,
                                                                               gpointer self)
{
	gala_multitasking_view_update_monitors ((GalaMultitaskingView*) self);
}

static void
_gala_multitasking_view___lambda90_ (GalaMultitaskingView* self,
                                     MetaPreference pref)
{
	if (pref == META_PREF_WORKSPACES_ONLY_ON_PRIMARY) {
		gala_multitasking_view_update_monitors (self);
	}
}

static void
__gala_multitasking_view___lambda90__meta_prefs_changed_func (MetaPreference pref,
                                                              gpointer self)
{
	_gala_multitasking_view___lambda90_ ((GalaMultitaskingView*) self, pref);
}

static void
_gala_multitasking_view_update_brightness_effect_g_object_notify (GObject* _sender,
                                                                  GParamSpec* pspec,
                                                                  gpointer self)
{
	gala_multitasking_view_update_brightness_effect ((GalaMultitaskingView*) self);
}

static GObject *
gala_multitasking_view_constructor (GType type,
                                    guint n_construct_properties,
                                    GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GalaMultitaskingView * self;
	Block59Data* _data59_;
	GSettings* _tmp0_;
	GalaDrawingStyleManager* _tmp1_;
	GalaWindowManagerGala* _tmp2_;
	MetaDisplay* _tmp3_;
	MetaDisplay* _tmp4_;
	GalaWindowManagerGala* _tmp5_;
	GalaGestureController* _tmp6_;
	GalaGestureController* _tmp7_;
	GalaGestureController* _tmp8_;
	GalaShellClientsManager* _tmp9_;
	MetaDisplay* _tmp10_;
	GalaWorkspaceRow* _tmp11_;
	GalaWindowManagerGala* _tmp12_;
	GalaGestureController* _tmp13_ = NULL;
	GalaGestureController* _tmp14_;
	GalaGestureController* _tmp15_;
	GalaGestureController* _tmp16_;
	MetaDisplay* _tmp17_;
	MetaDisplay* _tmp18_;
	GalaIconGroupContainer* _tmp19_;
	GalaActorTarget* _tmp20_;
	ClutterActor* _tmp21_;
	GalaIconGroupContainer* _tmp22_;
	ClutterActor* _tmp23_;
	GalaActorTarget* _tmp24_;
	ClutterActor* _tmp25_;
	MetaDisplay* _tmp26_;
	GalaStaticWindowContainer* _tmp27_;
	GalaStaticWindowContainer* _tmp28_;
	MetaDisplay* _tmp29_;
	MetaWorkspaceManager* _tmp30_;
	MetaWorkspaceManager* _tmp31_;
	MetaWorkspaceManager* _tmp32_;
	MetaWorkspaceManager* _tmp33_;
	MetaWorkspaceManager* _tmp34_;
	GalaGestureController* _tmp35_;
	MetaWorkspaceManager* _tmp36_;
	gint _tmp37_;
	gint _tmp38_;
	MetaWorkspaceManager* _tmp39_;
	MetaMonitorManager* monitor_manager = NULL;
	MetaDisplay* _tmp40_;
	MetaContext* _tmp41_;
	MetaBackend* _tmp42_;
	MetaMonitorManager* _tmp43_;
	MetaMonitorManager* _tmp44_;
	GalaDrawingStyleManager* _tmp45_;
	parent_class = G_OBJECT_CLASS (gala_multitasking_view_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_TYPE_MULTITASKING_VIEW, GalaMultitaskingView);
	_data59_ = g_slice_new0 (Block59Data);
	_data59_->_ref_count_ = 1;
	_data59_->self = g_object_ref (self);
	_tmp0_ = g_settings_new ("io.elementary.desktop.wm.behavior");
	_g_object_unref0 (self->priv->gala_behavior_settings);
	self->priv->gala_behavior_settings = _tmp0_;
	_tmp1_ = gala_drawing_style_manager_get_instance ();
	_g_object_unref0 (self->priv->style_manager);
	self->priv->style_manager = _tmp1_;
	g_object_set ((ClutterActor*) self, "visible", FALSE, NULL);
	clutter_actor_set_reactive ((ClutterActor*) self, TRUE);
	clutter_actor_set_clip_to_allocation ((ClutterActor*) self, TRUE);
	self->priv->opened = FALSE;
	_tmp2_ = self->priv->_wm;
	_tmp3_ = meta_plugin_get_display ((MetaPlugin*) _tmp2_);
	_tmp4_ = _g_object_ref0 (_tmp3_);
	_g_object_unref0 (self->priv->display);
	self->priv->display = _tmp4_;
	_tmp5_ = self->priv->_wm;
	_tmp6_ = gala_gesture_controller_new (GALA_GESTURE_ACTION_MULTITASKING_VIEW, (GalaWindowManager*) _tmp5_);
	_g_object_unref0 (self->priv->multitasking_gesture_controller);
	self->priv->multitasking_gesture_controller = _tmp6_;
	_tmp7_ = self->priv->multitasking_gesture_controller;
	gala_gesture_controller_enable_touchpad (_tmp7_);
	_tmp8_ = self->priv->multitasking_gesture_controller;
	gala_root_target_add_gesture_controller ((GalaRootTarget*) self, _tmp8_);
	_tmp9_ = gala_shell_clients_manager_get_instance ();
	gala_actor_target_add_target ((GalaActorTarget*) self, (GalaGestureTarget*) _tmp9_);
	_tmp10_ = self->priv->display;
	_tmp11_ = gala_workspace_row_new (_tmp10_);
	g_object_ref_sink (_tmp11_);
	_g_object_unref0 (self->priv->workspaces);
	self->priv->workspaces = (GalaActorTarget*) _tmp11_;
	_tmp12_ = self->priv->_wm;
	_tmp13_ = gala_gesture_controller_new (GALA_GESTURE_ACTION_SWITCH_WORKSPACE, (GalaWindowManager*) _tmp12_);
	gala_gesture_controller_set_overshoot_upper_clamp (_tmp13_, 0.1);
	_g_object_unref0 (self->priv->workspaces_gesture_controller);
	self->priv->workspaces_gesture_controller = _tmp13_;
	_tmp14_ = self->priv->workspaces_gesture_controller;
	gala_gesture_controller_enable_touchpad (_tmp14_);
	_tmp15_ = self->priv->workspaces_gesture_controller;
	gala_gesture_controller_enable_scroll (_tmp15_, (ClutterActor*) self, CLUTTER_ORIENTATION_HORIZONTAL);
	_tmp16_ = self->priv->workspaces_gesture_controller;
	gala_root_target_add_gesture_controller ((GalaRootTarget*) self, _tmp16_);
	_tmp17_ = self->priv->display;
	_tmp18_ = self->priv->display;
	_tmp19_ = gala_icon_group_container_new (meta_display_get_monitor_scale (_tmp17_, meta_display_get_primary_monitor (_tmp18_)));
	g_object_ref_sink (_tmp19_);
	_g_object_unref0 (self->priv->icon_groups);
	self->priv->icon_groups = _tmp19_;
	gala_multitasking_view_update_blurred_bg (self);
	_tmp20_ = gala_actor_target_new ();
	g_object_ref_sink (_tmp20_);
	_g_object_unref0 (self->priv->primary_monitor_container);
	self->priv->primary_monitor_container = (ClutterActor*) _tmp20_;
	_tmp21_ = self->priv->primary_monitor_container;
	_tmp22_ = self->priv->icon_groups;
	clutter_actor_add_child (_tmp21_, (ClutterActor*) _tmp22_);
	_tmp23_ = self->priv->primary_monitor_container;
	_tmp24_ = self->priv->workspaces;
	clutter_actor_add_child (_tmp23_, (ClutterActor*) _tmp24_);
	_tmp25_ = self->priv->primary_monitor_container;
	clutter_actor_add_child ((ClutterActor*) self, _tmp25_);
	_tmp26_ = self->priv->display;
	_tmp27_ = gala_static_window_container_get_instance (_tmp26_);
	_tmp28_ = _tmp27_;
	clutter_actor_add_child ((ClutterActor*) self, (ClutterActor*) _tmp28_);
	_g_object_unref0 (_tmp28_);
	_tmp29_ = self->priv->display;
	_tmp30_ = meta_display_get_workspace_manager (_tmp29_);
	_data59_->manager = _tmp30_;
	_tmp31_ = _data59_->manager;
	g_signal_connect_object (_tmp31_, "workspace-added", (GCallback) _gala_multitasking_view_add_workspace_meta_workspace_manager_workspace_added, self, 0);
	_tmp32_ = _data59_->manager;
	g_signal_connect_object (_tmp32_, "workspace-removed", (GCallback) _gala_multitasking_view_remove_workspace_meta_workspace_manager_workspace_removed, self, 0);
	_tmp33_ = _data59_->manager;
	g_signal_connect_object (_tmp33_, "workspaces-reordered", (GCallback) _gala_multitasking_view_on_workspaces_reordered_meta_workspace_manager_workspaces_reordered, self, 0);
	_tmp34_ = _data59_->manager;
	g_signal_connect_object (_tmp34_, "workspace-switched", (GCallback) _gala_multitasking_view_on_workspace_switched_meta_workspace_manager_workspace_switched, self, 0);
	_tmp35_ = self->priv->workspaces_gesture_controller;
	_tmp36_ = _data59_->manager;
	_tmp37_ = meta_workspace_manager_get_n_workspaces (_tmp36_);
	_tmp38_ = _tmp37_;
	gala_gesture_controller_set_overshoot_lower_clamp (_tmp35_, ((-_tmp38_) - 0.1) + 1);
	_tmp39_ = _data59_->manager;
	g_signal_connect_data ((GObject*) _tmp39_, "notify::n-workspaces", (GCallback) __gala_multitasking_view___lambda89__g_object_notify, block59_data_ref (_data59_), (GClosureNotify) block59_data_unref, 0);
	(self->priv->window_containers_monitors == NULL) ? NULL : (self->priv->window_containers_monitors = (_g_list_free__g_object_unref0_ (self->priv->window_containers_monitors), NULL));
	self->priv->window_containers_monitors = NULL;
	gala_multitasking_view_update_monitors (self);
	_tmp40_ = self->priv->display;
	_tmp41_ = meta_display_get_context (_tmp40_);
	_tmp42_ = meta_context_get_backend (_tmp41_);
	_tmp43_ = meta_backend_get_monitor_manager (_tmp42_);
	monitor_manager = _tmp43_;
	_tmp44_ = monitor_manager;
	g_signal_connect_object (_tmp44_, "monitors-changed", (GCallback) _gala_multitasking_view_update_monitors_meta_monitor_manager_monitors_changed, self, 0);
	meta_prefs_add_listener (__gala_multitasking_view___lambda90__meta_prefs_changed_func, self);
	_tmp45_ = self->priv->style_manager;
	g_signal_connect_object ((GObject*) _tmp45_, "notify::prefers-color-scheme", (GCallback) _gala_multitasking_view_update_brightness_effect_g_object_notify, self, 0);
	block59_data_unref (_data59_);
	_data59_ = NULL;
	return obj;
}

static void
gala_multitasking_view_class_init (GalaMultitaskingViewClass * klass,
                                   gpointer klass_data)
{
	gala_multitasking_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GalaMultitaskingView_private_offset);
	((ClutterActorClass *) klass)->scroll_event = (gboolean (*) (ClutterActor*, ClutterEvent*)) gala_multitasking_view_real_scroll_event;
	((GalaActorTargetClass *) klass)->start_progress = (void (*) (GalaActorTarget*, GalaGestureAction)) gala_multitasking_view_real_start_progress;
	((GalaActorTargetClass *) klass)->commit_progress = (void (*) (GalaActorTarget*, GalaGestureAction, gdouble)) gala_multitasking_view_real_commit_progress;
	((GalaActorTargetClass *) klass)->end_progress = (void (*) (GalaActorTarget*, GalaGestureAction)) gala_multitasking_view_real_end_progress;
	((ClutterActorClass *) klass)->key_press_event = (gboolean (*) (ClutterActor*, ClutterEvent*)) gala_multitasking_view_real_key_press_event;
	((ClutterActorClass *) klass)->captured_event = (gboolean (*) (ClutterActor*, ClutterEvent*)) gala_multitasking_view_real_captured_event;
	G_OBJECT_CLASS (klass)->get_property = _vala_gala_multitasking_view_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gala_multitasking_view_set_property;
	G_OBJECT_CLASS (klass)->constructor = gala_multitasking_view_constructor;
	G_OBJECT_CLASS (klass)->finalize = gala_multitasking_view_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_MULTITASKING_VIEW_WM_PROPERTY, gala_multitasking_view_properties[GALA_MULTITASKING_VIEW_WM_PROPERTY] = g_param_spec_object ("wm", "wm", "wm", GALA_TYPE_WINDOW_MANAGER_GALA, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}

static void
gala_multitasking_view_gala_root_target_interface_init (GalaRootTargetIface * iface,
                                                        gpointer iface_data)
{
	gala_multitasking_view_gala_root_target_parent_iface = g_type_interface_peek_parent (iface);
}

static void
gala_multitasking_view_gala_activatable_component_interface_init (GalaActivatableComponentIface * iface,
                                                                  gpointer iface_data)
{
	gala_multitasking_view_gala_activatable_component_parent_iface = g_type_interface_peek_parent (iface);
	iface->is_opened = (gboolean (*) (GalaActivatableComponent*)) gala_multitasking_view_real_is_opened;
	iface->open = (void (*) (GalaActivatableComponent*, GHashTable*)) gala_multitasking_view_real_open;
	iface->close = (void (*) (GalaActivatableComponent*, GHashTable*)) gala_multitasking_view_real_close;
}

static void
gala_multitasking_view_instance_init (GalaMultitaskingView * self,
                                      gpointer klass)
{
	self->priv = gala_multitasking_view_get_instance_private (self);
	self->priv->opened = FALSE;
	self->priv->blurred_bg = NULL;
}

static void
gala_multitasking_view_finalize (GObject * obj)
{
	GalaMultitaskingView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_TYPE_MULTITASKING_VIEW, GalaMultitaskingView);
	_g_object_unref0 (self->priv->workspaces_gesture_controller);
	_g_object_unref0 (self->priv->multitasking_gesture_controller);
	_g_object_unref0 (self->priv->_wm);
	_g_object_unref0 (self->priv->display);
	_g_object_unref0 (self->priv->modal_proxy);
	(self->priv->window_containers_monitors == NULL) ? NULL : (self->priv->window_containers_monitors = (_g_list_free__g_object_unref0_ (self->priv->window_containers_monitors), NULL));
	_g_object_unref0 (self->priv->icon_groups);
	_g_object_unref0 (self->priv->workspaces);
	_g_object_unref0 (self->priv->primary_monitor_container);
	_g_object_unref0 (self->priv->brightness_effect);
	_g_object_unref0 (self->priv->blurred_bg);
	_g_object_unref0 (self->priv->gala_behavior_settings);
	_g_object_unref0 (self->priv->style_manager);
	G_OBJECT_CLASS (gala_multitasking_view_parent_class)->finalize (obj);
}

/**
 * The central class for the MultitaskingView which takes care of
 * preparing the wm, opening the components and holds containers for
 * the icon groups, the WorkspaceClones and the MonitorClones.
 */
 G_GNUC_NO_INLINE static GType
gala_multitasking_view_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GalaMultitaskingViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gala_multitasking_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GalaMultitaskingView), 0, (GInstanceInitFunc) gala_multitasking_view_instance_init, NULL };
	static const GInterfaceInfo gala_root_target_info = { (GInterfaceInitFunc) gala_multitasking_view_gala_root_target_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	static const GInterfaceInfo gala_activatable_component_info = { (GInterfaceInitFunc) gala_multitasking_view_gala_activatable_component_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType gala_multitasking_view_type_id;
	gala_multitasking_view_type_id = g_type_register_static (GALA_TYPE_ACTOR_TARGET, "GalaMultitaskingView", &g_define_type_info, 0);
	g_type_add_interface_static (gala_multitasking_view_type_id, GALA_TYPE_ROOT_TARGET, &gala_root_target_info);
	g_type_add_interface_static (gala_multitasking_view_type_id, GALA_TYPE_ACTIVATABLE_COMPONENT, &gala_activatable_component_info);
	GalaMultitaskingView_private_offset = g_type_add_instance_private (gala_multitasking_view_type_id, sizeof (GalaMultitaskingViewPrivate));
	return gala_multitasking_view_type_id;
}

GType
gala_multitasking_view_get_type (void)
{
	static gsize gala_multitasking_view_type_id__once = 0;
	if (g_once_init_enter (&gala_multitasking_view_type_id__once)) {
		GType gala_multitasking_view_type_id;
		gala_multitasking_view_type_id = gala_multitasking_view_get_type_once ();
		g_once_init_leave (&gala_multitasking_view_type_id__once, gala_multitasking_view_type_id);
	}
	return gala_multitasking_view_type_id__once;
}

static void
_vala_gala_multitasking_view_get_property (GObject * object,
                                           guint property_id,
                                           GValue * value,
                                           GParamSpec * pspec)
{
	GalaMultitaskingView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_TYPE_MULTITASKING_VIEW, GalaMultitaskingView);
	switch (property_id) {
		case GALA_MULTITASKING_VIEW_WM_PROPERTY:
		g_value_set_object (value, gala_multitasking_view_get_wm (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_gala_multitasking_view_set_property (GObject * object,
                                           guint property_id,
                                           const GValue * value,
                                           GParamSpec * pspec)
{
	GalaMultitaskingView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_TYPE_MULTITASKING_VIEW, GalaMultitaskingView);
	switch (property_id) {
		case GALA_MULTITASKING_VIEW_WM_PROPERTY:
		gala_multitasking_view_set_wm (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

