/* PanelWindow.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from PanelWindow.vala, do not modify */

/*
 * Copyright 2024 elementary, Inc. (https://elementary.io)
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 * Authored by: Leonhard Kargl <leo.kargl@proton.me>
 */

#include <glib-object.h>
#include "gala.h"
#include <glib.h>
#include <float.h>
#include <math.h>
#include <clutter/clutter.h>
#include "pantheon-desktop-shell-server-protocol.h"
#include <meta/window.h>
#include <meta/boxes.h>
#include <mtk/mtk.h>
#include <meta/common.h>
#include <string.h>
#include <meta/meta-plugin.h>
#include <meta/display.h>
#include <meta/meta-workspace-manager.h>
#include <meta/workspace.h>

#define GALA_PANEL_WINDOW_ANIMATION_DURATION 250
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define GALA_TYPE_POSITIONED_WINDOW (gala_positioned_window_get_type ())
#define GALA_POSITIONED_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_POSITIONED_WINDOW, GalaPositionedWindow))
#define GALA_POSITIONED_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_POSITIONED_WINDOW, GalaPositionedWindowClass))
#define GALA_IS_POSITIONED_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_POSITIONED_WINDOW))
#define GALA_IS_POSITIONED_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_POSITIONED_WINDOW))
#define GALA_POSITIONED_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_POSITIONED_WINDOW, GalaPositionedWindowClass))

typedef struct _GalaPositionedWindow GalaPositionedWindow;
typedef struct _GalaPositionedWindowClass GalaPositionedWindowClass;
typedef struct _GalaPositionedWindowPrivate GalaPositionedWindowPrivate;

#define GALA_TYPE_GESTURE_TARGET (gala_gesture_target_get_type ())
#define GALA_GESTURE_TARGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_GESTURE_TARGET, GalaGestureTarget))
#define GALA_IS_GESTURE_TARGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_GESTURE_TARGET))
#define GALA_GESTURE_TARGET_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GALA_TYPE_GESTURE_TARGET, GalaGestureTargetIface))

typedef struct _GalaGestureTarget GalaGestureTarget;
typedef struct _GalaGestureTargetIface GalaGestureTargetIface;
typedef enum  {
	GALA_GESTURE_TARGET_UPDATE_TYPE_START,
	GALA_GESTURE_TARGET_UPDATE_TYPE_UPDATE,
	GALA_GESTURE_TARGET_UPDATE_TYPE_COMMIT,
	GALA_GESTURE_TARGET_UPDATE_TYPE_END
} GalaGestureTargetUpdateType;

#define GALA_GESTURE_TARGET_TYPE_UPDATE_TYPE (gala_gesture_target_update_type_get_type ())

#define GALA_TYPE_SHELL_WINDOW (gala_shell_window_get_type ())
#define GALA_SHELL_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_SHELL_WINDOW, GalaShellWindow))
#define GALA_SHELL_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_SHELL_WINDOW, GalaShellWindowClass))
#define GALA_IS_SHELL_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_SHELL_WINDOW))
#define GALA_IS_SHELL_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_SHELL_WINDOW))
#define GALA_SHELL_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_SHELL_WINDOW, GalaShellWindowClass))

typedef struct _GalaShellWindow GalaShellWindow;
typedef struct _GalaShellWindowClass GalaShellWindowClass;
typedef struct _GalaShellWindowPrivate GalaShellWindowPrivate;

#define GALA_TYPE_ROOT_TARGET (gala_root_target_get_type ())
#define GALA_ROOT_TARGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_ROOT_TARGET, GalaRootTarget))
#define GALA_IS_ROOT_TARGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_ROOT_TARGET))
#define GALA_ROOT_TARGET_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GALA_TYPE_ROOT_TARGET, GalaRootTargetIface))

typedef struct _GalaRootTarget GalaRootTarget;
typedef struct _GalaRootTargetIface GalaRootTargetIface;

#define GALA_TYPE_PANEL_WINDOW (gala_panel_window_get_type ())
#define GALA_PANEL_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_PANEL_WINDOW, GalaPanelWindow))
#define GALA_PANEL_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_PANEL_WINDOW, GalaPanelWindowClass))
#define GALA_IS_PANEL_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_PANEL_WINDOW))
#define GALA_IS_PANEL_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_PANEL_WINDOW))
#define GALA_PANEL_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_PANEL_WINDOW, GalaPanelWindowClass))

typedef struct _GalaPanelWindow GalaPanelWindow;
typedef struct _GalaPanelWindowClass GalaPanelWindowClass;
typedef struct _GalaPanelWindowPrivate GalaPanelWindowPrivate;

#define GALA_TYPE_GESTURE_CONTROLLER (gala_gesture_controller_get_type ())
#define GALA_GESTURE_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_GESTURE_CONTROLLER, GalaGestureController))
#define GALA_GESTURE_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_GESTURE_CONTROLLER, GalaGestureControllerClass))
#define GALA_IS_GESTURE_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_GESTURE_CONTROLLER))
#define GALA_IS_GESTURE_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_GESTURE_CONTROLLER))
#define GALA_GESTURE_CONTROLLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_GESTURE_CONTROLLER, GalaGestureControllerClass))

typedef struct _GalaGestureController GalaGestureController;
typedef struct _GalaGestureControllerClass GalaGestureControllerClass;

#define GALA_TYPE_HIDE_TRACKER (gala_hide_tracker_get_type ())
#define GALA_HIDE_TRACKER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_HIDE_TRACKER, GalaHideTracker))
#define GALA_HIDE_TRACKER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_HIDE_TRACKER, GalaHideTrackerClass))
#define GALA_IS_HIDE_TRACKER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_HIDE_TRACKER))
#define GALA_IS_HIDE_TRACKER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_HIDE_TRACKER))
#define GALA_HIDE_TRACKER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_HIDE_TRACKER, GalaHideTrackerClass))

typedef struct _GalaHideTracker GalaHideTracker;
typedef struct _GalaHideTrackerClass GalaHideTrackerClass;
enum  {
	GALA_PANEL_WINDOW_0_PROPERTY,
	GALA_PANEL_WINDOW_WM_PROPERTY,
	GALA_PANEL_WINDOW_ANCHOR_PROPERTY,
	GALA_PANEL_WINDOW_HIDE_MODE_PROPERTY,
	GALA_PANEL_WINDOW_NUM_PROPERTIES
};
static GParamSpec* gala_panel_window_properties[GALA_PANEL_WINDOW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef enum  {
	GALA_POSITIONED_WINDOW_POSITION_TOP,
	GALA_POSITIONED_WINDOW_POSITION_BOTTOM,
	GALA_POSITIONED_WINDOW_POSITION_CENTER
} GalaPositionedWindowPosition;

#define GALA_POSITIONED_WINDOW_TYPE_POSITION (gala_positioned_window_position_get_type ())

struct _GalaPositionedWindow {
	GObject parent_instance;
	GalaPositionedWindowPrivate * priv;
};

struct _GalaPositionedWindowClass {
	GObjectClass parent_class;
};

struct _GalaGestureTargetIface {
	GTypeInterface parent_iface;
	void (*propagate) (GalaGestureTarget* self, GalaGestureTargetUpdateType update_type, GalaGestureAction action, gdouble progress);
	ClutterActor* (*get_actor) (GalaGestureTarget* self);
};

struct _GalaShellWindow {
	GalaPositionedWindow parent_instance;
	GalaShellWindowPrivate * priv;
};

struct _GalaShellWindowClass {
	GalaPositionedWindowClass parent_class;
};

struct _GalaRootTargetIface {
	GTypeInterface parent_iface;
};

struct _GalaPanelWindow {
	GalaShellWindow parent_instance;
	GalaPanelWindowPrivate * priv;
};

struct _GalaPanelWindowClass {
	GalaShellWindowClass parent_class;
};

struct _GalaPanelWindowPrivate {
	GalaWindowManager* _wm;
	enum io_elementary_pantheon_panel_v1_anchor _anchor;
	GalaGestureController* gesture_controller;
	GalaHideTracker* hide_tracker;
};

static gint GalaPanelWindow_private_offset;
static gpointer gala_panel_window_parent_class = NULL;
static GHashTable* gala_panel_window_window_struts;
static GHashTable* gala_panel_window_window_struts = NULL;
static GalaRootTargetIface * gala_panel_window_gala_root_target_parent_iface = NULL;

VALA_EXTERN GType gala_positioned_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaPositionedWindow, g_object_unref)
VALA_EXTERN GType gala_gesture_target_update_type_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType gala_gesture_target_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaGestureTarget, g_object_unref)
VALA_EXTERN GType gala_shell_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaShellWindow, g_object_unref)
VALA_EXTERN GType gala_root_target_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType gala_panel_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaPanelWindow, g_object_unref)
VALA_EXTERN GType gala_gesture_controller_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaGestureController, g_object_unref)
VALA_EXTERN GType gala_hide_tracker_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaHideTracker, g_object_unref)
static void _g_object_unref0_ (gpointer var);
static void _g_free0_ (gpointer var);
VALA_EXTERN GalaPanelWindow* gala_panel_window_new (GalaWindowManager* wm,
                                        MetaWindow* window,
                                        enum io_elementary_pantheon_panel_v1_anchor anchor);
VALA_EXTERN GalaPanelWindow* gala_panel_window_construct (GType object_type,
                                              GalaWindowManager* wm,
                                              MetaWindow* window,
                                              enum io_elementary_pantheon_panel_v1_anchor anchor);
VALA_EXTERN GType gala_positioned_window_position_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GalaPositionedWindowPosition gala_positioned_window_position_from_anchor (enum io_elementary_pantheon_panel_v1_anchor anchor);
static void gala_panel_window_hide (GalaPanelWindow* self);
VALA_EXTERN void gala_gesture_controller_goto (GalaGestureController* self,
                                   gdouble to);
static void gala_panel_window_show (GalaPanelWindow* self);
static void gala_panel_window_make_exclusive (GalaPanelWindow* self);
static void gala_panel_window_update_strut (GalaPanelWindow* self);
VALA_EXTERN enum io_elementary_pantheon_panel_v1_hide_mode gala_panel_window_get_hide_mode (GalaPanelWindow* self);
VALA_EXTERN void gala_positioned_window_get_custom_window_rect (GalaPositionedWindow* self,
                                                    MtkRectangle* result);
static MetaSide gala_panel_window_side_from_anchor (GalaPanelWindow* self,
                                             enum io_elementary_pantheon_panel_v1_anchor anchor);
VALA_EXTERN enum io_elementary_pantheon_panel_v1_anchor gala_panel_window_get_anchor (GalaPanelWindow* self);
VALA_EXTERN MetaWindow* gala_positioned_window_get_window (GalaPositionedWindow* self);
static MetaStrut* _meta_strut_dup (MetaStrut* self);
static void gala_panel_window_update_struts (GalaPanelWindow* self);
VALA_EXTERN GalaWindowManager* gala_panel_window_get_wm (GalaPanelWindow* self);
static inline void _g_slist_free__g_free0_ (GSList* self);
static void gala_panel_window_unmake_exclusive (GalaPanelWindow* self);
static void gala_panel_window_set_wm (GalaPanelWindow* self,
                               GalaWindowManager* value);
VALA_EXTERN void gala_panel_window_set_anchor (GalaPanelWindow* self,
                                   enum io_elementary_pantheon_panel_v1_anchor value);
VALA_EXTERN enum io_elementary_pantheon_panel_v1_hide_mode gala_hide_tracker_get_hide_mode (GalaHideTracker* self);
VALA_EXTERN void gala_panel_window_set_hide_mode (GalaPanelWindow* self,
                                      enum io_elementary_pantheon_panel_v1_hide_mode value);
VALA_EXTERN void gala_hide_tracker_set_hide_mode (GalaHideTracker* self,
                                      enum io_elementary_pantheon_panel_v1_hide_mode value);
static GObject * gala_panel_window_constructor (GType type,
                                         guint n_construct_properties,
                                         GObjectConstructParam * construct_properties);
static void _gala_panel_window___lambda53_ (GalaPanelWindow* self);
static void __gala_panel_window___lambda53__meta_window_unmanaging (MetaWindow* _sender,
                                                             gpointer self);
static void _gala_panel_window___lambda54_ (GalaPanelWindow* self);
VALA_EXTERN void gala_positioned_window_set_position (GalaPositionedWindow* self,
                                          GalaPositionedWindowPosition value);
static void __gala_panel_window___lambda54__g_object_notify (GObject* _sender,
                                                      GParamSpec* pspec,
                                                      gpointer self);
static void _gala_panel_window_update_strut_meta_workspace_manager_workspace_added (MetaWorkspaceManager* _sender,
                                                                             gint object,
                                                                             gpointer self);
static void _gala_panel_window_update_strut_meta_workspace_manager_workspace_removed (MetaWorkspaceManager* _sender,
                                                                               gint object,
                                                                               gpointer self);
static void _gala_panel_window_update_strut_meta_window_size_changed (MetaWindow* _sender,
                                                               gpointer self);
static void _gala_panel_window_update_strut_meta_window_position_changed (MetaWindow* _sender,
                                                                   gpointer self);
static void _gala_panel_window_update_strut_g_object_notify (GObject* _sender,
                                                      GParamSpec* pspec,
                                                      gpointer self);
VALA_EXTERN GalaGestureController* gala_gesture_controller_new (GalaGestureAction action,
                                                    GalaWindowManager* wm);
VALA_EXTERN GalaGestureController* gala_gesture_controller_construct (GType object_type,
                                                          GalaGestureAction action,
                                                          GalaWindowManager* wm);
VALA_EXTERN void gala_root_target_add_gesture_controller (GalaRootTarget* self,
                                              GalaGestureController* controller);
VALA_EXTERN GalaHideTracker* gala_hide_tracker_new (MetaDisplay* display,
                                        GalaPanelWindow* panel);
VALA_EXTERN GalaHideTracker* gala_hide_tracker_construct (GType object_type,
                                              MetaDisplay* display,
                                              GalaPanelWindow* panel);
static void _gala_panel_window_hide_gala_hide_tracker_hide (GalaHideTracker* _sender,
                                                     gpointer self);
static void _gala_panel_window_show_gala_hide_tracker_show (GalaHideTracker* _sender,
                                                     gpointer self);
static void gala_panel_window_finalize (GObject * obj);
static GType gala_panel_window_get_type_once (void);
static void _vala_gala_panel_window_get_property (GObject * object,
                                           guint property_id,
                                           GValue * value,
                                           GParamSpec * pspec);
static void _vala_gala_panel_window_set_property (GObject * object,
                                           guint property_id,
                                           const GValue * value,
                                           GParamSpec * pspec);

static inline gpointer
gala_panel_window_get_instance_private (GalaPanelWindow* self)
{
	return G_STRUCT_MEMBER_P (self, GalaPanelWindow_private_offset);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static void
_g_free0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_free (var), NULL));
}

GalaPanelWindow*
gala_panel_window_construct (GType object_type,
                             GalaWindowManager* wm,
                             MetaWindow* window,
                             enum io_elementary_pantheon_panel_v1_anchor anchor)
{
	GalaPanelWindow * self = NULL;
	g_return_val_if_fail (wm != NULL, NULL);
	g_return_val_if_fail (window != NULL, NULL);
	self = (GalaPanelWindow*) g_object_new (object_type, "wm", wm, "anchor", anchor, "window", window, "position", gala_positioned_window_position_from_anchor (anchor), NULL);
	return self;
}

GalaPanelWindow*
gala_panel_window_new (GalaWindowManager* wm,
                       MetaWindow* window,
                       enum io_elementary_pantheon_panel_v1_anchor anchor)
{
	return gala_panel_window_construct (GALA_TYPE_PANEL_WINDOW, wm, window, anchor);
}

static void
gala_panel_window_hide (GalaPanelWindow* self)
{
	GalaGestureController* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->gesture_controller;
	gala_gesture_controller_goto (_tmp0_, (gdouble) 1);
}

static void
gala_panel_window_show (GalaPanelWindow* self)
{
	GalaGestureController* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->gesture_controller;
	gala_gesture_controller_goto (_tmp0_, (gdouble) 0);
}

static void
gala_panel_window_make_exclusive (GalaPanelWindow* self)
{
	g_return_if_fail (self != NULL);
	gala_panel_window_update_strut (self);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static MetaStrut*
_meta_strut_dup (MetaStrut* self)
{
	MetaStrut* dup;
	dup = g_new0 (MetaStrut, 1);
	memcpy (dup, self, sizeof (MetaStrut));
	return dup;
}

static gpointer
__meta_strut_dup0 (gpointer self)
{
	return self ? _meta_strut_dup (self) : NULL;
}

static void
gala_panel_window_update_strut (GalaPanelWindow* self)
{
	enum io_elementary_pantheon_panel_v1_hide_mode _tmp0_;
	enum io_elementary_pantheon_panel_v1_hide_mode _tmp1_;
	MtkRectangle rect = {0};
	MtkRectangle _tmp2_ = {0};
	MetaStrut strut = {0};
	MtkRectangle _tmp3_;
	enum io_elementary_pantheon_panel_v1_anchor _tmp4_;
	MetaStrut _tmp5_ = {0};
	GHashTable* _tmp6_;
	MetaWindow* _tmp7_;
	MetaWindow* _tmp8_;
	MetaWindow* _tmp9_;
	MetaStrut _tmp10_;
	MetaStrut* _tmp11_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gala_panel_window_get_hide_mode (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != IO_ELEMENTARY_PANTHEON_PANEL_V1_HIDE_MODE_NEVER) {
		return;
	}
	gala_positioned_window_get_custom_window_rect ((GalaPositionedWindow*) self, &_tmp2_);
	rect = _tmp2_;
	_tmp3_ = rect;
	_tmp4_ = self->priv->_anchor;
	_tmp5_.rect = _tmp3_;
	_tmp5_.side = gala_panel_window_side_from_anchor (self, _tmp4_);
	strut = _tmp5_;
	_tmp6_ = gala_panel_window_window_struts;
	_tmp7_ = gala_positioned_window_get_window ((GalaPositionedWindow*) self);
	_tmp8_ = _tmp7_;
	_tmp9_ = _g_object_ref0 (_tmp8_);
	_tmp10_ = strut;
	_tmp11_ = __meta_strut_dup0 (&_tmp10_);
	g_hash_table_insert (_tmp6_, _tmp9_, _tmp11_);
	gala_panel_window_update_struts (self);
}

static inline void
_g_slist_free__g_free0_ (GSList* self)
{
	g_slist_free_full (self, (GDestroyNotify) _g_free0_);
}

static void
gala_panel_window_update_struts (GalaPanelWindow* self)
{
	GSList* list = NULL;
	GHashTable* _tmp0_;
	GList* _tmp1_;
	GalaWindowManager* _tmp4_;
	MetaDisplay* _tmp5_;
	MetaWorkspaceManager* _tmp6_;
	GList* _tmp7_;
	g_return_if_fail (self != NULL);
	list = NULL;
	_tmp0_ = gala_panel_window_window_struts;
	_tmp1_ = g_hash_table_get_values (_tmp0_);
	{
		GList* window_strut_collection = NULL;
		GList* window_strut_it = NULL;
		window_strut_collection = _tmp1_;
		for (window_strut_it = window_strut_collection; window_strut_it != NULL; window_strut_it = window_strut_it->next) {
			MetaStrut* window_strut = NULL;
			window_strut = (MetaStrut*) window_strut_it->data;
			{
				MetaStrut* _tmp2_;
				MetaStrut* _tmp3_;
				_tmp2_ = window_strut;
				_tmp3_ = __meta_strut_dup0 (_tmp2_);
				list = g_slist_append (list, _tmp3_);
			}
		}
		(window_strut_collection == NULL) ? NULL : (window_strut_collection = (g_list_free (window_strut_collection), NULL));
	}
	_tmp4_ = self->priv->_wm;
	_tmp5_ = meta_plugin_get_display ((MetaPlugin*) _tmp4_);
	_tmp6_ = meta_display_get_workspace_manager (_tmp5_);
	_tmp7_ = meta_workspace_manager_get_workspaces (_tmp6_);
	{
		GList* workspace_collection = NULL;
		GList* workspace_it = NULL;
		workspace_collection = _tmp7_;
		for (workspace_it = workspace_collection; workspace_it != NULL; workspace_it = workspace_it->next) {
			MetaWorkspace* _tmp8_;
			MetaWorkspace* workspace = NULL;
			_tmp8_ = _g_object_ref0 ((MetaWorkspace*) workspace_it->data);
			workspace = _tmp8_;
			{
				MetaWorkspace* _tmp9_;
				GSList* _tmp10_;
				_tmp9_ = workspace;
				_tmp10_ = list;
				meta_workspace_set_builtin_struts (_tmp9_, _tmp10_);
				_g_object_unref0 (workspace);
			}
		}
	}
	(list == NULL) ? NULL : (list = (_g_slist_free__g_free0_ (list), NULL));
}

static void
gala_panel_window_unmake_exclusive (GalaPanelWindow* self)
{
	GHashTable* _tmp0_;
	MetaWindow* _tmp1_;
	MetaWindow* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gala_panel_window_window_struts;
	_tmp1_ = gala_positioned_window_get_window ((GalaPositionedWindow*) self);
	_tmp2_ = _tmp1_;
	if (g_hash_table_contains (_tmp0_, _tmp2_)) {
		GHashTable* _tmp3_;
		MetaWindow* _tmp4_;
		MetaWindow* _tmp5_;
		_tmp3_ = gala_panel_window_window_struts;
		_tmp4_ = gala_positioned_window_get_window ((GalaPositionedWindow*) self);
		_tmp5_ = _tmp4_;
		g_hash_table_remove (_tmp3_, _tmp5_);
		gala_panel_window_update_struts (self);
	}
}

static MetaSide
gala_panel_window_side_from_anchor (GalaPanelWindow* self,
                                    enum io_elementary_pantheon_panel_v1_anchor anchor)
{
	MetaSide result;
	g_return_val_if_fail (self != NULL, 0);
	switch (anchor) {
		case IO_ELEMENTARY_PANTHEON_PANEL_V1_ANCHOR_BOTTOM:
		{
			result = META_SIDE_BOTTOM;
			return result;
		}
		case IO_ELEMENTARY_PANTHEON_PANEL_V1_ANCHOR_LEFT:
		{
			result = META_SIDE_LEFT;
			return result;
		}
		case IO_ELEMENTARY_PANTHEON_PANEL_V1_ANCHOR_RIGHT:
		{
			result = META_SIDE_RIGHT;
			return result;
		}
		default:
		{
			result = META_SIDE_TOP;
			return result;
		}
	}
}

GalaWindowManager*
gala_panel_window_get_wm (GalaPanelWindow* self)
{
	GalaWindowManager* result;
	GalaWindowManager* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_wm;
	result = _tmp0_;
	return result;
}

static void
gala_panel_window_set_wm (GalaPanelWindow* self,
                          GalaWindowManager* value)
{
	GalaWindowManager* old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_panel_window_get_wm (self);
	if (old_value != value) {
		GalaWindowManager* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_wm);
		self->priv->_wm = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gala_panel_window_properties[GALA_PANEL_WINDOW_WM_PROPERTY]);
	}
}

enum io_elementary_pantheon_panel_v1_anchor
gala_panel_window_get_anchor (GalaPanelWindow* self)
{
	enum io_elementary_pantheon_panel_v1_anchor result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_anchor;
	return result;
}

void
gala_panel_window_set_anchor (GalaPanelWindow* self,
                              enum io_elementary_pantheon_panel_v1_anchor value)
{
	enum io_elementary_pantheon_panel_v1_anchor old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_panel_window_get_anchor (self);
	if (old_value != value) {
		self->priv->_anchor = value;
		g_object_notify_by_pspec ((GObject *) self, gala_panel_window_properties[GALA_PANEL_WINDOW_ANCHOR_PROPERTY]);
	}
}

enum io_elementary_pantheon_panel_v1_hide_mode
gala_panel_window_get_hide_mode (GalaPanelWindow* self)
{
	enum io_elementary_pantheon_panel_v1_hide_mode result;
	GalaHideTracker* _tmp0_;
	enum io_elementary_pantheon_panel_v1_hide_mode _tmp1_;
	enum io_elementary_pantheon_panel_v1_hide_mode _tmp2_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->hide_tracker;
	_tmp1_ = gala_hide_tracker_get_hide_mode (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

void
gala_panel_window_set_hide_mode (GalaPanelWindow* self,
                                 enum io_elementary_pantheon_panel_v1_hide_mode value)
{
	GalaHideTracker* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->hide_tracker;
	gala_hide_tracker_set_hide_mode (_tmp0_, value);
	if (value == IO_ELEMENTARY_PANTHEON_PANEL_V1_HIDE_MODE_NEVER) {
		gala_panel_window_make_exclusive (self);
	} else {
		gala_panel_window_unmake_exclusive (self);
	}
	g_object_notify_by_pspec ((GObject *) self, gala_panel_window_properties[GALA_PANEL_WINDOW_HIDE_MODE_PROPERTY]);
}

static void
_gala_panel_window___lambda53_ (GalaPanelWindow* self)
{
	GHashTable* _tmp0_;
	MetaWindow* _tmp1_;
	MetaWindow* _tmp2_;
	_tmp0_ = gala_panel_window_window_struts;
	_tmp1_ = gala_positioned_window_get_window ((GalaPositionedWindow*) self);
	_tmp2_ = _tmp1_;
	if (g_hash_table_remove (_tmp0_, _tmp2_)) {
		gala_panel_window_update_struts (self);
	}
}

static void
__gala_panel_window___lambda53__meta_window_unmanaging (MetaWindow* _sender,
                                                        gpointer self)
{
	_gala_panel_window___lambda53_ ((GalaPanelWindow*) self);
}

static void
_gala_panel_window___lambda54_ (GalaPanelWindow* self)
{
	enum io_elementary_pantheon_panel_v1_anchor _tmp0_;
	_tmp0_ = self->priv->_anchor;
	gala_positioned_window_set_position ((GalaPositionedWindow*) self, gala_positioned_window_position_from_anchor (_tmp0_));
}

static void
__gala_panel_window___lambda54__g_object_notify (GObject* _sender,
                                                 GParamSpec* pspec,
                                                 gpointer self)
{
	_gala_panel_window___lambda54_ ((GalaPanelWindow*) self);
}

static void
_gala_panel_window_update_strut_meta_workspace_manager_workspace_added (MetaWorkspaceManager* _sender,
                                                                        gint object,
                                                                        gpointer self)
{
	gala_panel_window_update_strut ((GalaPanelWindow*) self);
}

static void
_gala_panel_window_update_strut_meta_workspace_manager_workspace_removed (MetaWorkspaceManager* _sender,
                                                                          gint object,
                                                                          gpointer self)
{
	gala_panel_window_update_strut ((GalaPanelWindow*) self);
}

static void
_gala_panel_window_update_strut_meta_window_size_changed (MetaWindow* _sender,
                                                          gpointer self)
{
	gala_panel_window_update_strut ((GalaPanelWindow*) self);
}

static void
_gala_panel_window_update_strut_meta_window_position_changed (MetaWindow* _sender,
                                                              gpointer self)
{
	gala_panel_window_update_strut ((GalaPanelWindow*) self);
}

static void
_gala_panel_window_update_strut_g_object_notify (GObject* _sender,
                                                 GParamSpec* pspec,
                                                 gpointer self)
{
	gala_panel_window_update_strut ((GalaPanelWindow*) self);
}

static void
_gala_panel_window_hide_gala_hide_tracker_hide (GalaHideTracker* _sender,
                                                gpointer self)
{
	gala_panel_window_hide ((GalaPanelWindow*) self);
}

static void
_gala_panel_window_show_gala_hide_tracker_show (GalaHideTracker* _sender,
                                                gpointer self)
{
	gala_panel_window_show ((GalaPanelWindow*) self);
}

static GObject *
gala_panel_window_constructor (GType type,
                               guint n_construct_properties,
                               GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GalaPanelWindow * self;
	MetaWindow* _tmp0_;
	MetaWindow* _tmp1_;
	MetaWorkspaceManager* workspace_manager = NULL;
	MetaWindow* _tmp2_;
	MetaWindow* _tmp3_;
	MetaDisplay* _tmp4_;
	MetaDisplay* _tmp5_;
	MetaWorkspaceManager* _tmp6_;
	MetaWorkspaceManager* _tmp7_;
	MetaWorkspaceManager* _tmp8_;
	MetaWindow* _tmp9_;
	MetaWindow* _tmp10_;
	MetaWindow* _tmp11_;
	MetaWindow* _tmp12_;
	GalaWindowManager* _tmp13_;
	GalaGestureController* _tmp14_;
	GalaGestureController* _tmp15_;
	GalaWindowManager* _tmp16_;
	MetaDisplay* _tmp17_;
	GalaHideTracker* _tmp18_;
	GalaHideTracker* _tmp19_;
	GalaHideTracker* _tmp20_;
	parent_class = G_OBJECT_CLASS (gala_panel_window_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_TYPE_PANEL_WINDOW, GalaPanelWindow);
	_tmp0_ = gala_positioned_window_get_window ((GalaPositionedWindow*) self);
	_tmp1_ = _tmp0_;
	g_signal_connect_object (_tmp1_, "unmanaging", (GCallback) __gala_panel_window___lambda53__meta_window_unmanaging, self, 0);
	g_signal_connect_object ((GObject*) self, "notify::anchor", (GCallback) __gala_panel_window___lambda54__g_object_notify, self, 0);
	_tmp2_ = gala_positioned_window_get_window ((GalaPositionedWindow*) self);
	_tmp3_ = _tmp2_;
	_tmp4_ = meta_window_get_display (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = meta_display_get_workspace_manager (_tmp5_);
	workspace_manager = _tmp6_;
	_tmp7_ = workspace_manager;
	g_signal_connect_object (_tmp7_, "workspace-added", (GCallback) _gala_panel_window_update_strut_meta_workspace_manager_workspace_added, self, 0);
	_tmp8_ = workspace_manager;
	g_signal_connect_object (_tmp8_, "workspace-removed", (GCallback) _gala_panel_window_update_strut_meta_workspace_manager_workspace_removed, self, 0);
	_tmp9_ = gala_positioned_window_get_window ((GalaPositionedWindow*) self);
	_tmp10_ = _tmp9_;
	g_signal_connect_object (_tmp10_, "size-changed", (GCallback) _gala_panel_window_update_strut_meta_window_size_changed, self, 0);
	_tmp11_ = gala_positioned_window_get_window ((GalaPositionedWindow*) self);
	_tmp12_ = _tmp11_;
	g_signal_connect_object (_tmp12_, "position-changed", (GCallback) _gala_panel_window_update_strut_meta_window_position_changed, self, 0);
	g_signal_connect_object ((GObject*) self, "notify::width", (GCallback) _gala_panel_window_update_strut_g_object_notify, self, 0);
	g_signal_connect_object ((GObject*) self, "notify::height", (GCallback) _gala_panel_window_update_strut_g_object_notify, self, 0);
	_tmp13_ = self->priv->_wm;
	_tmp14_ = gala_gesture_controller_new (GALA_GESTURE_ACTION_DOCK, _tmp13_);
	_g_object_unref0 (self->priv->gesture_controller);
	self->priv->gesture_controller = _tmp14_;
	_tmp15_ = self->priv->gesture_controller;
	gala_root_target_add_gesture_controller ((GalaRootTarget*) self, _tmp15_);
	_tmp16_ = self->priv->_wm;
	_tmp17_ = meta_plugin_get_display ((MetaPlugin*) _tmp16_);
	_tmp18_ = gala_hide_tracker_new (_tmp17_, self);
	_g_object_unref0 (self->priv->hide_tracker);
	self->priv->hide_tracker = _tmp18_;
	_tmp19_ = self->priv->hide_tracker;
	g_signal_connect_object (_tmp19_, "hide", (GCallback) _gala_panel_window_hide_gala_hide_tracker_hide, self, 0);
	_tmp20_ = self->priv->hide_tracker;
	g_signal_connect_object (_tmp20_, "show", (GCallback) _gala_panel_window_show_gala_hide_tracker_show, self, 0);
	return obj;
}

static void
gala_panel_window_class_init (GalaPanelWindowClass * klass,
                              gpointer klass_data)
{
	GHashTable* _tmp0_;
	gala_panel_window_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GalaPanelWindow_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_gala_panel_window_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gala_panel_window_set_property;
	G_OBJECT_CLASS (klass)->constructor = gala_panel_window_constructor;
	G_OBJECT_CLASS (klass)->finalize = gala_panel_window_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_PANEL_WINDOW_WM_PROPERTY, gala_panel_window_properties[GALA_PANEL_WINDOW_WM_PROPERTY] = g_param_spec_object ("wm", "wm", "wm", GALA_TYPE_WINDOW_MANAGER, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_PANEL_WINDOW_ANCHOR_PROPERTY, gala_panel_window_properties[GALA_PANEL_WINDOW_ANCHOR_PROPERTY] = g_param_spec_int ("anchor", "anchor", "anchor", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_PANEL_WINDOW_HIDE_MODE_PROPERTY, gala_panel_window_properties[GALA_PANEL_WINDOW_HIDE_MODE_PROPERTY] = g_param_spec_int ("hide-mode", "hide-mode", "hide-mode", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	_tmp0_ = g_hash_table_new_full (NULL, NULL, _g_object_unref0_, _g_free0_);
	gala_panel_window_window_struts = _tmp0_;
}

static void
gala_panel_window_gala_root_target_interface_init (GalaRootTargetIface * iface,
                                                   gpointer iface_data)
{
	gala_panel_window_gala_root_target_parent_iface = g_type_interface_peek_parent (iface);
}

static void
gala_panel_window_instance_init (GalaPanelWindow * self,
                                 gpointer klass)
{
	self->priv = gala_panel_window_get_instance_private (self);
}

static void
gala_panel_window_finalize (GObject * obj)
{
	GalaPanelWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_TYPE_PANEL_WINDOW, GalaPanelWindow);
	_g_object_unref0 (self->priv->_wm);
	_g_object_unref0 (self->priv->gesture_controller);
	_g_object_unref0 (self->priv->hide_tracker);
	G_OBJECT_CLASS (gala_panel_window_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
gala_panel_window_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GalaPanelWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gala_panel_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GalaPanelWindow), 0, (GInstanceInitFunc) gala_panel_window_instance_init, NULL };
	static const GInterfaceInfo gala_root_target_info = { (GInterfaceInitFunc) gala_panel_window_gala_root_target_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType gala_panel_window_type_id;
	gala_panel_window_type_id = g_type_register_static (GALA_TYPE_SHELL_WINDOW, "GalaPanelWindow", &g_define_type_info, 0);
	g_type_add_interface_static (gala_panel_window_type_id, GALA_TYPE_ROOT_TARGET, &gala_root_target_info);
	GalaPanelWindow_private_offset = g_type_add_instance_private (gala_panel_window_type_id, sizeof (GalaPanelWindowPrivate));
	return gala_panel_window_type_id;
}

GType
gala_panel_window_get_type (void)
{
	static gsize gala_panel_window_type_id__once = 0;
	if (g_once_init_enter (&gala_panel_window_type_id__once)) {
		GType gala_panel_window_type_id;
		gala_panel_window_type_id = gala_panel_window_get_type_once ();
		g_once_init_leave (&gala_panel_window_type_id__once, gala_panel_window_type_id);
	}
	return gala_panel_window_type_id__once;
}

static void
_vala_gala_panel_window_get_property (GObject * object,
                                      guint property_id,
                                      GValue * value,
                                      GParamSpec * pspec)
{
	GalaPanelWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_TYPE_PANEL_WINDOW, GalaPanelWindow);
	switch (property_id) {
		case GALA_PANEL_WINDOW_WM_PROPERTY:
		g_value_set_object (value, gala_panel_window_get_wm (self));
		break;
		case GALA_PANEL_WINDOW_ANCHOR_PROPERTY:
		g_value_set_int (value, gala_panel_window_get_anchor (self));
		break;
		case GALA_PANEL_WINDOW_HIDE_MODE_PROPERTY:
		g_value_set_int (value, gala_panel_window_get_hide_mode (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_gala_panel_window_set_property (GObject * object,
                                      guint property_id,
                                      const GValue * value,
                                      GParamSpec * pspec)
{
	GalaPanelWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_TYPE_PANEL_WINDOW, GalaPanelWindow);
	switch (property_id) {
		case GALA_PANEL_WINDOW_WM_PROPERTY:
		gala_panel_window_set_wm (self, g_value_get_object (value));
		break;
		case GALA_PANEL_WINDOW_ANCHOR_PROPERTY:
		gala_panel_window_set_anchor (self, g_value_get_int (value));
		break;
		case GALA_PANEL_WINDOW_HIDE_MODE_PROPERTY:
		gala_panel_window_set_hide_mode (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

