/*
 * This file is generated by gdbus-codegen, do not modify it.
 *
 * The license of this code is the same as for the D-Bus interface description
 * it was derived from. Note that it links to GLib, so must comply with the
 * LGPL linking clauses.
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include "lfb-gdbus.h"

#include <string.h>
#ifdef G_OS_UNIX
#  include <gio/gunixfdlist.h>
#endif

#ifdef G_ENABLE_DEBUG
#define g_marshal_value_peek_boolean(v)  g_value_get_boolean (v)
#define g_marshal_value_peek_char(v)     g_value_get_schar (v)
#define g_marshal_value_peek_uchar(v)    g_value_get_uchar (v)
#define g_marshal_value_peek_int(v)      g_value_get_int (v)
#define g_marshal_value_peek_uint(v)     g_value_get_uint (v)
#define g_marshal_value_peek_long(v)     g_value_get_long (v)
#define g_marshal_value_peek_ulong(v)    g_value_get_ulong (v)
#define g_marshal_value_peek_int64(v)    g_value_get_int64 (v)
#define g_marshal_value_peek_uint64(v)   g_value_get_uint64 (v)
#define g_marshal_value_peek_enum(v)     g_value_get_enum (v)
#define g_marshal_value_peek_flags(v)    g_value_get_flags (v)
#define g_marshal_value_peek_float(v)    g_value_get_float (v)
#define g_marshal_value_peek_double(v)   g_value_get_double (v)
#define g_marshal_value_peek_string(v)   (char*) g_value_get_string (v)
#define g_marshal_value_peek_param(v)    g_value_get_param (v)
#define g_marshal_value_peek_boxed(v)    g_value_get_boxed (v)
#define g_marshal_value_peek_pointer(v)  g_value_get_pointer (v)
#define g_marshal_value_peek_object(v)   g_value_get_object (v)
#define g_marshal_value_peek_variant(v)  g_value_get_variant (v)
#else /* !G_ENABLE_DEBUG */
/* WARNING: This code accesses GValues directly, which is UNSUPPORTED API.
 *          Do not access GValues directly in your code. Instead, use the
 *          g_value_get_*() functions
 */
#define g_marshal_value_peek_boolean(v)  (v)->data[0].v_int
#define g_marshal_value_peek_char(v)     (v)->data[0].v_int
#define g_marshal_value_peek_uchar(v)    (v)->data[0].v_uint
#define g_marshal_value_peek_int(v)      (v)->data[0].v_int
#define g_marshal_value_peek_uint(v)     (v)->data[0].v_uint
#define g_marshal_value_peek_long(v)     (v)->data[0].v_long
#define g_marshal_value_peek_ulong(v)    (v)->data[0].v_ulong
#define g_marshal_value_peek_int64(v)    (v)->data[0].v_int64
#define g_marshal_value_peek_uint64(v)   (v)->data[0].v_uint64
#define g_marshal_value_peek_enum(v)     (v)->data[0].v_long
#define g_marshal_value_peek_flags(v)    (v)->data[0].v_ulong
#define g_marshal_value_peek_float(v)    (v)->data[0].v_float
#define g_marshal_value_peek_double(v)   (v)->data[0].v_double
#define g_marshal_value_peek_string(v)   (v)->data[0].v_pointer
#define g_marshal_value_peek_param(v)    (v)->data[0].v_pointer
#define g_marshal_value_peek_boxed(v)    (v)->data[0].v_pointer
#define g_marshal_value_peek_pointer(v)  (v)->data[0].v_pointer
#define g_marshal_value_peek_object(v)   (v)->data[0].v_pointer
#define g_marshal_value_peek_variant(v)  (v)->data[0].v_pointer
#endif /* !G_ENABLE_DEBUG */

typedef struct
{
  GDBusArgInfo parent_struct;
  gboolean use_gvariant;
} _ExtendedGDBusArgInfo;

typedef struct
{
  GDBusMethodInfo parent_struct;
  const gchar *signal_name;
  gboolean pass_fdlist;
} _ExtendedGDBusMethodInfo;

typedef struct
{
  GDBusSignalInfo parent_struct;
  const gchar *signal_name;
} _ExtendedGDBusSignalInfo;

typedef struct
{
  GDBusPropertyInfo parent_struct;
  const gchar *hyphen_name;
  guint use_gvariant : 1;
  guint emits_changed_signal : 1;
} _ExtendedGDBusPropertyInfo;

typedef struct
{
  GDBusInterfaceInfo parent_struct;
  const gchar *hyphen_name;
} _ExtendedGDBusInterfaceInfo;

typedef struct
{
  const _ExtendedGDBusPropertyInfo *info;
  guint prop_id;
  GValue orig_value; /* the value before the change */
} ChangedProperty;

static void
_changed_property_free (ChangedProperty *data)
{
  g_value_unset (&data->orig_value);
  g_free (data);
}

static gboolean
_g_strv_equal0 (gchar **a, gchar **b)
{
  gboolean ret = FALSE;
  guint n;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  if (g_strv_length (a) != g_strv_length (b))
    goto out;
  for (n = 0; a[n] != NULL; n++)
    if (g_strcmp0 (a[n], b[n]) != 0)
      goto out;
  ret = TRUE;
out:
  return ret;
}

static gboolean
_g_variant_equal0 (GVariant *a, GVariant *b)
{
  gboolean ret = FALSE;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  ret = g_variant_equal (a, b);
out:
  return ret;
}

G_GNUC_UNUSED static gboolean
_g_value_equal (const GValue *a, const GValue *b)
{
  gboolean ret = FALSE;
  g_assert (G_VALUE_TYPE (a) == G_VALUE_TYPE (b));
  switch (G_VALUE_TYPE (a))
    {
      case G_TYPE_BOOLEAN:
        ret = (g_value_get_boolean (a) == g_value_get_boolean (b));
        break;
      case G_TYPE_UCHAR:
        ret = (g_value_get_uchar (a) == g_value_get_uchar (b));
        break;
      case G_TYPE_INT:
        ret = (g_value_get_int (a) == g_value_get_int (b));
        break;
      case G_TYPE_UINT:
        ret = (g_value_get_uint (a) == g_value_get_uint (b));
        break;
      case G_TYPE_INT64:
        ret = (g_value_get_int64 (a) == g_value_get_int64 (b));
        break;
      case G_TYPE_UINT64:
        ret = (g_value_get_uint64 (a) == g_value_get_uint64 (b));
        break;
      case G_TYPE_DOUBLE:
        {
          /* Avoid -Wfloat-equal warnings by doing a direct bit compare */
          gdouble da = g_value_get_double (a);
          gdouble db = g_value_get_double (b);
          ret = memcmp (&da, &db, sizeof (gdouble)) == 0;
        }
        break;
      case G_TYPE_STRING:
        ret = (g_strcmp0 (g_value_get_string (a), g_value_get_string (b)) == 0);
        break;
      case G_TYPE_VARIANT:
        ret = _g_variant_equal0 (g_value_get_variant (a), g_value_get_variant (b));
        break;
      default:
        if (G_VALUE_TYPE (a) == G_TYPE_STRV)
          ret = _g_strv_equal0 (g_value_get_boxed (a), g_value_get_boxed (b));
        else
          g_critical ("_g_value_equal() does not handle type %s", g_type_name (G_VALUE_TYPE (a)));
        break;
    }
  return ret;
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_VARIANT (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectStringVariantFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        const gchar *arg_app_id,
        GVariant *arg_pattern,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectStringVariantFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 4);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectStringVariantFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_string (param_values + 2),
              g_marshal_value_peek_variant (param_values + 3),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_VOID__UINT_UINT (
    GClosure     *closure,
    GValue       *return_value G_GNUC_UNUSED,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef void (*_GDbusCodegenMarshalVoid_UintUintFunc)
       (void *data1,
        guint arg_id,
        guint arg_reason,
        void *data2);
  _GDbusCodegenMarshalVoid_UintUintFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;

  g_return_if_fail (n_param_values == 3);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalVoid_UintUintFunc)
    (marshal_data ? marshal_data : cc->callback);

  callback (data1,
            g_marshal_value_peek_uint (param_values + 1),
            g_marshal_value_peek_uint (param_values + 2),
            data2);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_STRING_VARIANT_INT (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectStringStringVariantIntFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        const gchar *arg_app_id,
        const gchar *arg_event,
        GVariant *arg_hints,
        gint arg_timeout,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectStringStringVariantIntFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 6);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectStringStringVariantIntFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_string (param_values + 2),
              g_marshal_value_peek_string (param_values + 3),
              g_marshal_value_peek_variant (param_values + 4),
              g_marshal_value_peek_int (param_values + 5),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_UINT (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectUintFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        guint arg_id,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectUintFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 3);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectUintFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_uint (param_values + 2),
              data2);

  g_value_set_boolean (return_value, v_return);
}

/* ------------------------------------------------------------------------
 * Code for interface org.sigxcpu.Feedback.Haptic
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:LfbGdbusFeedbackHaptic
 * @title: LfbGdbusFeedbackHaptic
 * @short_description: Generated C code for the org.sigxcpu.Feedback.Haptic D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-sigxcpu-Feedback-Haptic.top_of_page">org.sigxcpu.Feedback.Haptic</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.sigxcpu.Feedback.Haptic ---- */

static const _ExtendedGDBusArgInfo _lfb_gdbus_feedback_haptic_method_info_vibrate_IN_ARG_app_id =
{
  {
    -1,
    (gchar *) "app_id",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _lfb_gdbus_feedback_haptic_method_info_vibrate_IN_ARG_pattern =
{
  {
    -1,
    (gchar *) "pattern",
    (gchar *) "a(du)",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _lfb_gdbus_feedback_haptic_method_info_vibrate_IN_ARG_pointers[] =
{
  &_lfb_gdbus_feedback_haptic_method_info_vibrate_IN_ARG_app_id.parent_struct,
  &_lfb_gdbus_feedback_haptic_method_info_vibrate_IN_ARG_pattern.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _lfb_gdbus_feedback_haptic_method_info_vibrate_OUT_ARG_success =
{
  {
    -1,
    (gchar *) "success",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _lfb_gdbus_feedback_haptic_method_info_vibrate_OUT_ARG_pointers[] =
{
  &_lfb_gdbus_feedback_haptic_method_info_vibrate_OUT_ARG_success.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _lfb_gdbus_feedback_haptic_method_info_vibrate =
{
  {
    -1,
    (gchar *) "Vibrate",
    (GDBusArgInfo **) &_lfb_gdbus_feedback_haptic_method_info_vibrate_IN_ARG_pointers,
    (GDBusArgInfo **) &_lfb_gdbus_feedback_haptic_method_info_vibrate_OUT_ARG_pointers,
    NULL
  },
  "handle-vibrate",
  FALSE
};

static const GDBusMethodInfo * const _lfb_gdbus_feedback_haptic_method_info_pointers[] =
{
  &_lfb_gdbus_feedback_haptic_method_info_vibrate.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _lfb_gdbus_feedback_haptic_interface_info =
{
  {
    -1,
    (gchar *) "org.sigxcpu.Feedback.Haptic",
    (GDBusMethodInfo **) &_lfb_gdbus_feedback_haptic_method_info_pointers,
    NULL,
    NULL,
    NULL
  },
  "feedback-haptic",
};


/**
 * lfb_gdbus_feedback_haptic_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-sigxcpu-Feedback-Haptic.top_of_page">org.sigxcpu.Feedback.Haptic</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
lfb_gdbus_feedback_haptic_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_lfb_gdbus_feedback_haptic_interface_info.parent_struct;
}

/**
 * lfb_gdbus_feedback_haptic_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #LfbGdbusFeedbackHaptic interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
lfb_gdbus_feedback_haptic_override_properties (GObjectClass *klass G_GNUC_UNUSED, guint property_id_begin)
{
  return property_id_begin - 1;
}


inline static void
lfb_gdbus_feedback_haptic_method_marshal_vibrate (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_VARIANT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}


/**
 * LfbGdbusFeedbackHaptic:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-sigxcpu-Feedback-Haptic.top_of_page">org.sigxcpu.Feedback.Haptic</link>.
 */

/**
 * LfbGdbusFeedbackHapticIface:
 * @parent_iface: The parent interface.
 * @handle_vibrate: Handler for the #LfbGdbusFeedbackHaptic::handle-vibrate signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-sigxcpu-Feedback-Haptic.top_of_page">org.sigxcpu.Feedback.Haptic</link>.
 */

typedef LfbGdbusFeedbackHapticIface LfbGdbusFeedbackHapticInterface;
G_DEFINE_INTERFACE (LfbGdbusFeedbackHaptic, lfb_gdbus_feedback_haptic, G_TYPE_OBJECT)

static void
lfb_gdbus_feedback_haptic_default_init (LfbGdbusFeedbackHapticIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * LfbGdbusFeedbackHaptic::handle-vibrate:
   * @object: A #LfbGdbusFeedbackHaptic.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_app_id: Argument passed by remote caller.
   * @arg_pattern: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-sigxcpu-Feedback-Haptic.Vibrate">Vibrate()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call lfb_gdbus_feedback_haptic_complete_vibrate() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-vibrate",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (LfbGdbusFeedbackHapticIface, handle_vibrate),
    g_signal_accumulator_true_handled,
    NULL,
      lfb_gdbus_feedback_haptic_method_marshal_vibrate,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_VARIANT);

}

/**
 * lfb_gdbus_feedback_haptic_call_vibrate:
 * @proxy: A #LfbGdbusFeedbackHapticProxy.
 * @arg_app_id: Argument to pass with the method invocation.
 * @arg_pattern: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-sigxcpu-Feedback-Haptic.Vibrate">Vibrate()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call lfb_gdbus_feedback_haptic_call_vibrate_finish() to get the result of the operation.
 *
 * See lfb_gdbus_feedback_haptic_call_vibrate_sync() for the synchronous, blocking version of this method.
 */
void
lfb_gdbus_feedback_haptic_call_vibrate (
    LfbGdbusFeedbackHaptic *proxy,
    const gchar *arg_app_id,
    GVariant *arg_pattern,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Vibrate",
    g_variant_new ("(s@a(du))",
                   arg_app_id,
                   arg_pattern),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * lfb_gdbus_feedback_haptic_call_vibrate_finish:
 * @proxy: A #LfbGdbusFeedbackHapticProxy.
 * @out_success: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to lfb_gdbus_feedback_haptic_call_vibrate().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with lfb_gdbus_feedback_haptic_call_vibrate().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
lfb_gdbus_feedback_haptic_call_vibrate_finish (
    LfbGdbusFeedbackHaptic *proxy,
    gboolean *out_success,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(b)",
                 out_success);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * lfb_gdbus_feedback_haptic_call_vibrate_sync:
 * @proxy: A #LfbGdbusFeedbackHapticProxy.
 * @arg_app_id: Argument to pass with the method invocation.
 * @arg_pattern: Argument to pass with the method invocation.
 * @out_success: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-sigxcpu-Feedback-Haptic.Vibrate">Vibrate()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See lfb_gdbus_feedback_haptic_call_vibrate() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
lfb_gdbus_feedback_haptic_call_vibrate_sync (
    LfbGdbusFeedbackHaptic *proxy,
    const gchar *arg_app_id,
    GVariant *arg_pattern,
    gboolean *out_success,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Vibrate",
    g_variant_new ("(s@a(du))",
                   arg_app_id,
                   arg_pattern),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(b)",
                 out_success);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * lfb_gdbus_feedback_haptic_complete_vibrate:
 * @object: A #LfbGdbusFeedbackHaptic.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @success: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-sigxcpu-Feedback-Haptic.Vibrate">Vibrate()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
lfb_gdbus_feedback_haptic_complete_vibrate (
    LfbGdbusFeedbackHaptic *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    gboolean success)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(b)",
                   success));
}

/* ------------------------------------------------------------------------ */

/**
 * LfbGdbusFeedbackHapticProxy:
 *
 * The #LfbGdbusFeedbackHapticProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * LfbGdbusFeedbackHapticProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #LfbGdbusFeedbackHapticProxy.
 */

struct _LfbGdbusFeedbackHapticProxyPrivate
{
  GData *qdata;
};

static void lfb_gdbus_feedback_haptic_proxy_iface_init (LfbGdbusFeedbackHapticIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (LfbGdbusFeedbackHapticProxy, lfb_gdbus_feedback_haptic_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (LfbGdbusFeedbackHapticProxy)
                         G_IMPLEMENT_INTERFACE (LFB_GDBUS_TYPE_FEEDBACK_HAPTIC, lfb_gdbus_feedback_haptic_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (LfbGdbusFeedbackHapticProxy, lfb_gdbus_feedback_haptic_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (LFB_GDBUS_TYPE_FEEDBACK_HAPTIC, lfb_gdbus_feedback_haptic_proxy_iface_init))

#endif
static void
lfb_gdbus_feedback_haptic_proxy_finalize (GObject *object)
{
  LfbGdbusFeedbackHapticProxy *proxy = LFB_GDBUS_FEEDBACK_HAPTIC_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (lfb_gdbus_feedback_haptic_proxy_parent_class)->finalize (object);
}

static void
lfb_gdbus_feedback_haptic_proxy_get_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  GValue       *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
lfb_gdbus_feedback_haptic_proxy_set_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  const GValue *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
lfb_gdbus_feedback_haptic_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_lfb_gdbus_feedback_haptic_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], LFB_GDBUS_TYPE_FEEDBACK_HAPTIC);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, LFB_GDBUS_TYPE_FEEDBACK_HAPTIC);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
lfb_gdbus_feedback_haptic_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  LfbGdbusFeedbackHapticProxy *proxy = LFB_GDBUS_FEEDBACK_HAPTIC_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_lfb_gdbus_feedback_haptic_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_lfb_gdbus_feedback_haptic_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static void
lfb_gdbus_feedback_haptic_proxy_init (LfbGdbusFeedbackHapticProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = lfb_gdbus_feedback_haptic_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, LFB_GDBUS_TYPE_FEEDBACK_HAPTIC_PROXY, LfbGdbusFeedbackHapticProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), lfb_gdbus_feedback_haptic_interface_info ());
}

static void
lfb_gdbus_feedback_haptic_proxy_class_init (LfbGdbusFeedbackHapticProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = lfb_gdbus_feedback_haptic_proxy_finalize;
  gobject_class->get_property = lfb_gdbus_feedback_haptic_proxy_get_property;
  gobject_class->set_property = lfb_gdbus_feedback_haptic_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = lfb_gdbus_feedback_haptic_proxy_g_signal;
  proxy_class->g_properties_changed = lfb_gdbus_feedback_haptic_proxy_g_properties_changed;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (LfbGdbusFeedbackHapticProxyPrivate));
#endif
}

static void
lfb_gdbus_feedback_haptic_proxy_iface_init (LfbGdbusFeedbackHapticIface *iface G_GNUC_UNUSED)
{
}

/**
 * lfb_gdbus_feedback_haptic_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-sigxcpu-Feedback-Haptic.top_of_page">org.sigxcpu.Feedback.Haptic</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call lfb_gdbus_feedback_haptic_proxy_new_finish() to get the result of the operation.
 *
 * See lfb_gdbus_feedback_haptic_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
lfb_gdbus_feedback_haptic_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (LFB_GDBUS_TYPE_FEEDBACK_HAPTIC_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.sigxcpu.Feedback.Haptic", NULL);
}

/**
 * lfb_gdbus_feedback_haptic_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to lfb_gdbus_feedback_haptic_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with lfb_gdbus_feedback_haptic_proxy_new().
 *
 * Returns: (transfer full) (type LfbGdbusFeedbackHapticProxy): The constructed proxy object or %NULL if @error is set.
 */
LfbGdbusFeedbackHaptic *
lfb_gdbus_feedback_haptic_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return LFB_GDBUS_FEEDBACK_HAPTIC (ret);
  else
    return NULL;
}

/**
 * lfb_gdbus_feedback_haptic_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-sigxcpu-Feedback-Haptic.top_of_page">org.sigxcpu.Feedback.Haptic</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See lfb_gdbus_feedback_haptic_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type LfbGdbusFeedbackHapticProxy): The constructed proxy object or %NULL if @error is set.
 */
LfbGdbusFeedbackHaptic *
lfb_gdbus_feedback_haptic_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (LFB_GDBUS_TYPE_FEEDBACK_HAPTIC_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.sigxcpu.Feedback.Haptic", NULL);
  if (ret != NULL)
    return LFB_GDBUS_FEEDBACK_HAPTIC (ret);
  else
    return NULL;
}


/**
 * lfb_gdbus_feedback_haptic_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like lfb_gdbus_feedback_haptic_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call lfb_gdbus_feedback_haptic_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See lfb_gdbus_feedback_haptic_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
lfb_gdbus_feedback_haptic_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (LFB_GDBUS_TYPE_FEEDBACK_HAPTIC_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.sigxcpu.Feedback.Haptic", NULL);
}

/**
 * lfb_gdbus_feedback_haptic_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to lfb_gdbus_feedback_haptic_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with lfb_gdbus_feedback_haptic_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type LfbGdbusFeedbackHapticProxy): The constructed proxy object or %NULL if @error is set.
 */
LfbGdbusFeedbackHaptic *
lfb_gdbus_feedback_haptic_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return LFB_GDBUS_FEEDBACK_HAPTIC (ret);
  else
    return NULL;
}

/**
 * lfb_gdbus_feedback_haptic_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like lfb_gdbus_feedback_haptic_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See lfb_gdbus_feedback_haptic_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type LfbGdbusFeedbackHapticProxy): The constructed proxy object or %NULL if @error is set.
 */
LfbGdbusFeedbackHaptic *
lfb_gdbus_feedback_haptic_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (LFB_GDBUS_TYPE_FEEDBACK_HAPTIC_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.sigxcpu.Feedback.Haptic", NULL);
  if (ret != NULL)
    return LFB_GDBUS_FEEDBACK_HAPTIC (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * LfbGdbusFeedbackHapticSkeleton:
 *
 * The #LfbGdbusFeedbackHapticSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * LfbGdbusFeedbackHapticSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #LfbGdbusFeedbackHapticSkeleton.
 */

struct _LfbGdbusFeedbackHapticSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_lfb_gdbus_feedback_haptic_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  LfbGdbusFeedbackHapticSkeleton *skeleton = LFB_GDBUS_FEEDBACK_HAPTIC_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], LFB_GDBUS_TYPE_FEEDBACK_HAPTIC);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, LFB_GDBUS_TYPE_FEEDBACK_HAPTIC);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_lfb_gdbus_feedback_haptic_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  LfbGdbusFeedbackHapticSkeleton *skeleton = LFB_GDBUS_FEEDBACK_HAPTIC_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_lfb_gdbus_feedback_haptic_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_lfb_gdbus_feedback_haptic_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  LfbGdbusFeedbackHapticSkeleton *skeleton = LFB_GDBUS_FEEDBACK_HAPTIC_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_lfb_gdbus_feedback_haptic_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _lfb_gdbus_feedback_haptic_skeleton_vtable =
{
  _lfb_gdbus_feedback_haptic_skeleton_handle_method_call,
  _lfb_gdbus_feedback_haptic_skeleton_handle_get_property,
  _lfb_gdbus_feedback_haptic_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
lfb_gdbus_feedback_haptic_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return lfb_gdbus_feedback_haptic_interface_info ();
}

static GDBusInterfaceVTable *
lfb_gdbus_feedback_haptic_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_lfb_gdbus_feedback_haptic_skeleton_vtable;
}

static GVariant *
lfb_gdbus_feedback_haptic_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  LfbGdbusFeedbackHapticSkeleton *skeleton = LFB_GDBUS_FEEDBACK_HAPTIC_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_84
  g_variant_builder_init_static (&builder, G_VARIANT_TYPE ("a{sv}"));
#else
  g_variant_builder_init(&builder, G_VARIANT_TYPE ("a{sv}"));
#endif
  if (_lfb_gdbus_feedback_haptic_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _lfb_gdbus_feedback_haptic_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _lfb_gdbus_feedback_haptic_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _lfb_gdbus_feedback_haptic_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.sigxcpu.Feedback.Haptic", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static void
lfb_gdbus_feedback_haptic_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton G_GNUC_UNUSED)
{
}

static void lfb_gdbus_feedback_haptic_skeleton_iface_init (LfbGdbusFeedbackHapticIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (LfbGdbusFeedbackHapticSkeleton, lfb_gdbus_feedback_haptic_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (LfbGdbusFeedbackHapticSkeleton)
                         G_IMPLEMENT_INTERFACE (LFB_GDBUS_TYPE_FEEDBACK_HAPTIC, lfb_gdbus_feedback_haptic_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (LfbGdbusFeedbackHapticSkeleton, lfb_gdbus_feedback_haptic_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (LFB_GDBUS_TYPE_FEEDBACK_HAPTIC, lfb_gdbus_feedback_haptic_skeleton_iface_init))

#endif
static void
lfb_gdbus_feedback_haptic_skeleton_finalize (GObject *object)
{
  LfbGdbusFeedbackHapticSkeleton *skeleton = LFB_GDBUS_FEEDBACK_HAPTIC_SKELETON (object);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (lfb_gdbus_feedback_haptic_skeleton_parent_class)->finalize (object);
}

static void
lfb_gdbus_feedback_haptic_skeleton_init (LfbGdbusFeedbackHapticSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = lfb_gdbus_feedback_haptic_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, LFB_GDBUS_TYPE_FEEDBACK_HAPTIC_SKELETON, LfbGdbusFeedbackHapticSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
}

static void
lfb_gdbus_feedback_haptic_skeleton_class_init (LfbGdbusFeedbackHapticSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = lfb_gdbus_feedback_haptic_skeleton_finalize;

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = lfb_gdbus_feedback_haptic_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = lfb_gdbus_feedback_haptic_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = lfb_gdbus_feedback_haptic_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = lfb_gdbus_feedback_haptic_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (LfbGdbusFeedbackHapticSkeletonPrivate));
#endif
}

static void
lfb_gdbus_feedback_haptic_skeleton_iface_init (LfbGdbusFeedbackHapticIface *iface G_GNUC_UNUSED)
{
}

/**
 * lfb_gdbus_feedback_haptic_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-sigxcpu-Feedback-Haptic.top_of_page">org.sigxcpu.Feedback.Haptic</link>.
 *
 * Returns: (transfer full) (type LfbGdbusFeedbackHapticSkeleton): The skeleton object.
 */
LfbGdbusFeedbackHaptic *
lfb_gdbus_feedback_haptic_skeleton_new (void)
{
  return LFB_GDBUS_FEEDBACK_HAPTIC (g_object_new (LFB_GDBUS_TYPE_FEEDBACK_HAPTIC_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface org.sigxcpu.Feedback
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:LfbGdbusFeedback
 * @title: LfbGdbusFeedback
 * @short_description: Generated C code for the org.sigxcpu.Feedback D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-sigxcpu-Feedback.top_of_page">org.sigxcpu.Feedback</link> D-Bus interface in C.
 */

enum
{
  LFB_GDBUS__FEEDBACK_FEEDBACK_ENDED,
};

static unsigned LFB_GDBUS__FEEDBACK_SIGNALS[1] = { 0 };

/* ---- Introspection data for org.sigxcpu.Feedback ---- */

static const _ExtendedGDBusArgInfo _lfb_gdbus_feedback_method_info_trigger_feedback_IN_ARG_app_id =
{
  {
    -1,
    (gchar *) "app_id",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _lfb_gdbus_feedback_method_info_trigger_feedback_IN_ARG_event =
{
  {
    -1,
    (gchar *) "event",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _lfb_gdbus_feedback_method_info_trigger_feedback_IN_ARG_hints =
{
  {
    -1,
    (gchar *) "hints",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _lfb_gdbus_feedback_method_info_trigger_feedback_IN_ARG_timeout =
{
  {
    -1,
    (gchar *) "timeout",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _lfb_gdbus_feedback_method_info_trigger_feedback_IN_ARG_pointers[] =
{
  &_lfb_gdbus_feedback_method_info_trigger_feedback_IN_ARG_app_id.parent_struct,
  &_lfb_gdbus_feedback_method_info_trigger_feedback_IN_ARG_event.parent_struct,
  &_lfb_gdbus_feedback_method_info_trigger_feedback_IN_ARG_hints.parent_struct,
  &_lfb_gdbus_feedback_method_info_trigger_feedback_IN_ARG_timeout.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _lfb_gdbus_feedback_method_info_trigger_feedback_OUT_ARG_id =
{
  {
    -1,
    (gchar *) "id",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _lfb_gdbus_feedback_method_info_trigger_feedback_OUT_ARG_pointers[] =
{
  &_lfb_gdbus_feedback_method_info_trigger_feedback_OUT_ARG_id.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _lfb_gdbus_feedback_method_info_trigger_feedback =
{
  {
    -1,
    (gchar *) "TriggerFeedback",
    (GDBusArgInfo **) &_lfb_gdbus_feedback_method_info_trigger_feedback_IN_ARG_pointers,
    (GDBusArgInfo **) &_lfb_gdbus_feedback_method_info_trigger_feedback_OUT_ARG_pointers,
    NULL
  },
  "handle-trigger-feedback",
  FALSE
};

static const _ExtendedGDBusArgInfo _lfb_gdbus_feedback_method_info_end_feedback_IN_ARG_id =
{
  {
    -1,
    (gchar *) "id",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _lfb_gdbus_feedback_method_info_end_feedback_IN_ARG_pointers[] =
{
  &_lfb_gdbus_feedback_method_info_end_feedback_IN_ARG_id.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _lfb_gdbus_feedback_method_info_end_feedback =
{
  {
    -1,
    (gchar *) "EndFeedback",
    (GDBusArgInfo **) &_lfb_gdbus_feedback_method_info_end_feedback_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-end-feedback",
  FALSE
};

static const GDBusMethodInfo * const _lfb_gdbus_feedback_method_info_pointers[] =
{
  &_lfb_gdbus_feedback_method_info_trigger_feedback.parent_struct,
  &_lfb_gdbus_feedback_method_info_end_feedback.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _lfb_gdbus_feedback_signal_info_feedback_ended_ARG_id =
{
  {
    -1,
    (gchar *) "id",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _lfb_gdbus_feedback_signal_info_feedback_ended_ARG_reason =
{
  {
    -1,
    (gchar *) "reason",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _lfb_gdbus_feedback_signal_info_feedback_ended_ARG_pointers[] =
{
  &_lfb_gdbus_feedback_signal_info_feedback_ended_ARG_id.parent_struct,
  &_lfb_gdbus_feedback_signal_info_feedback_ended_ARG_reason.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _lfb_gdbus_feedback_signal_info_feedback_ended =
{
  {
    -1,
    (gchar *) "FeedbackEnded",
    (GDBusArgInfo **) &_lfb_gdbus_feedback_signal_info_feedback_ended_ARG_pointers,
    NULL
  },
  "feedback-ended"
};

static const GDBusSignalInfo * const _lfb_gdbus_feedback_signal_info_pointers[] =
{
  &_lfb_gdbus_feedback_signal_info_feedback_ended.parent_struct,
  NULL
};

static const _ExtendedGDBusPropertyInfo _lfb_gdbus_feedback_property_info_profile =
{
  {
    -1,
    (gchar *) "Profile",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE | G_DBUS_PROPERTY_INFO_FLAGS_WRITABLE,
    NULL
  },
  "profile",
  FALSE,
  TRUE
};

static const GDBusPropertyInfo * const _lfb_gdbus_feedback_property_info_pointers[] =
{
  &_lfb_gdbus_feedback_property_info_profile.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _lfb_gdbus_feedback_interface_info =
{
  {
    -1,
    (gchar *) "org.sigxcpu.Feedback",
    (GDBusMethodInfo **) &_lfb_gdbus_feedback_method_info_pointers,
    (GDBusSignalInfo **) &_lfb_gdbus_feedback_signal_info_pointers,
    (GDBusPropertyInfo **) &_lfb_gdbus_feedback_property_info_pointers,
    NULL
  },
  "feedback",
};


/**
 * lfb_gdbus_feedback_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-sigxcpu-Feedback.top_of_page">org.sigxcpu.Feedback</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
lfb_gdbus_feedback_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_lfb_gdbus_feedback_interface_info.parent_struct;
}

/**
 * lfb_gdbus_feedback_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #LfbGdbusFeedback interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
lfb_gdbus_feedback_override_properties (GObjectClass *klass, guint property_id_begin)
{
  g_object_class_override_property (klass, property_id_begin++, "profile");
  return property_id_begin - 1;
}


inline static void
lfb_gdbus_feedback_signal_marshal_feedback_ended (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_VOID__UINT_UINT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
lfb_gdbus_feedback_method_marshal_trigger_feedback (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_STRING_VARIANT_INT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
lfb_gdbus_feedback_method_marshal_end_feedback (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_UINT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}


/**
 * LfbGdbusFeedback:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-sigxcpu-Feedback.top_of_page">org.sigxcpu.Feedback</link>.
 */

/**
 * LfbGdbusFeedbackIface:
 * @parent_iface: The parent interface.
 * @handle_end_feedback: Handler for the #LfbGdbusFeedback::handle-end-feedback signal.
 * @handle_trigger_feedback: Handler for the #LfbGdbusFeedback::handle-trigger-feedback signal.
 * @get_profile: Getter for the #LfbGdbusFeedback:profile property.
 * @feedback_ended: Handler for the #LfbGdbusFeedback::feedback-ended signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-sigxcpu-Feedback.top_of_page">org.sigxcpu.Feedback</link>.
 */

typedef LfbGdbusFeedbackIface LfbGdbusFeedbackInterface;
G_DEFINE_INTERFACE (LfbGdbusFeedback, lfb_gdbus_feedback, G_TYPE_OBJECT)

static void
lfb_gdbus_feedback_default_init (LfbGdbusFeedbackIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * LfbGdbusFeedback::handle-trigger-feedback:
   * @object: A #LfbGdbusFeedback.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_app_id: Argument passed by remote caller.
   * @arg_event: Argument passed by remote caller.
   * @arg_hints: Argument passed by remote caller.
   * @arg_timeout: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-sigxcpu-Feedback.TriggerFeedback">TriggerFeedback()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call lfb_gdbus_feedback_complete_trigger_feedback() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-trigger-feedback",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (LfbGdbusFeedbackIface, handle_trigger_feedback),
    g_signal_accumulator_true_handled,
    NULL,
      lfb_gdbus_feedback_method_marshal_trigger_feedback,
    G_TYPE_BOOLEAN,
    5,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_VARIANT, G_TYPE_INT);

  /**
   * LfbGdbusFeedback::handle-end-feedback:
   * @object: A #LfbGdbusFeedback.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_id: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-sigxcpu-Feedback.EndFeedback">EndFeedback()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call lfb_gdbus_feedback_complete_end_feedback() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-end-feedback",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (LfbGdbusFeedbackIface, handle_end_feedback),
    g_signal_accumulator_true_handled,
    NULL,
      lfb_gdbus_feedback_method_marshal_end_feedback,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UINT);

  /* GObject signals for received D-Bus signals: */
  /**
   * LfbGdbusFeedback::feedback-ended:
   * @object: A #LfbGdbusFeedback.
   * @arg_id: Argument.
   * @arg_reason: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-sigxcpu-Feedback.FeedbackEnded">"FeedbackEnded"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  LFB_GDBUS__FEEDBACK_SIGNALS[LFB_GDBUS__FEEDBACK_FEEDBACK_ENDED] =
    g_signal_new ("feedback-ended",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (LfbGdbusFeedbackIface, feedback_ended),
      NULL,
      NULL,
      lfb_gdbus_feedback_signal_marshal_feedback_ended,
      G_TYPE_NONE,
      2, G_TYPE_UINT, G_TYPE_UINT);

  /* GObject properties for D-Bus properties: */
  /**
   * LfbGdbusFeedback:profile:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-sigxcpu-Feedback.Profile">"Profile"</link>.
   *
   * Since the D-Bus property for this #GObject property is both readable and writable, it is meaningful to both read from it and write to it on both the service- and client-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("profile", "Profile", "Profile", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
}

/**
 * lfb_gdbus_feedback_get_profile: (skip)
 * @object: A #LfbGdbusFeedback.
 *
 * Gets the value of the <link linkend="gdbus-property-org-sigxcpu-Feedback.Profile">"Profile"</link> D-Bus property.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use lfb_gdbus_feedback_dup_profile() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
lfb_gdbus_feedback_get_profile (LfbGdbusFeedback *object)
{
  g_return_val_if_fail (LFB_GDBUS_IS_FEEDBACK (object), NULL);

  return LFB_GDBUS_FEEDBACK_GET_IFACE (object)->get_profile (object);
}

/**
 * lfb_gdbus_feedback_dup_profile: (skip)
 * @object: A #LfbGdbusFeedback.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-sigxcpu-Feedback.Profile">"Profile"</link> D-Bus property.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
lfb_gdbus_feedback_dup_profile (LfbGdbusFeedback *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "profile", &value, NULL);
  return value;
}

/**
 * lfb_gdbus_feedback_set_profile: (skip)
 * @object: A #LfbGdbusFeedback.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-sigxcpu-Feedback.Profile">"Profile"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 */
void
lfb_gdbus_feedback_set_profile (LfbGdbusFeedback *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "profile", value, NULL);
}

/**
 * lfb_gdbus_feedback_emit_feedback_ended:
 * @object: A #LfbGdbusFeedback.
 * @arg_id: Argument to pass with the signal.
 * @arg_reason: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-sigxcpu-Feedback.FeedbackEnded">"FeedbackEnded"</link> D-Bus signal.
 */
void
lfb_gdbus_feedback_emit_feedback_ended (
    LfbGdbusFeedback *object,
    guint arg_id,
    guint arg_reason)
{
  g_signal_emit (object, LFB_GDBUS__FEEDBACK_SIGNALS[LFB_GDBUS__FEEDBACK_FEEDBACK_ENDED], 0, arg_id, arg_reason);
}

/**
 * lfb_gdbus_feedback_call_trigger_feedback:
 * @proxy: A #LfbGdbusFeedbackProxy.
 * @arg_app_id: Argument to pass with the method invocation.
 * @arg_event: Argument to pass with the method invocation.
 * @arg_hints: Argument to pass with the method invocation.
 * @arg_timeout: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-sigxcpu-Feedback.TriggerFeedback">TriggerFeedback()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call lfb_gdbus_feedback_call_trigger_feedback_finish() to get the result of the operation.
 *
 * See lfb_gdbus_feedback_call_trigger_feedback_sync() for the synchronous, blocking version of this method.
 */
void
lfb_gdbus_feedback_call_trigger_feedback (
    LfbGdbusFeedback *proxy,
    const gchar *arg_app_id,
    const gchar *arg_event,
    GVariant *arg_hints,
    gint arg_timeout,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "TriggerFeedback",
    g_variant_new ("(ss@a{sv}i)",
                   arg_app_id,
                   arg_event,
                   arg_hints,
                   arg_timeout),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * lfb_gdbus_feedback_call_trigger_feedback_finish:
 * @proxy: A #LfbGdbusFeedbackProxy.
 * @out_id: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to lfb_gdbus_feedback_call_trigger_feedback().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with lfb_gdbus_feedback_call_trigger_feedback().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
lfb_gdbus_feedback_call_trigger_feedback_finish (
    LfbGdbusFeedback *proxy,
    guint *out_id,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(u)",
                 out_id);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * lfb_gdbus_feedback_call_trigger_feedback_sync:
 * @proxy: A #LfbGdbusFeedbackProxy.
 * @arg_app_id: Argument to pass with the method invocation.
 * @arg_event: Argument to pass with the method invocation.
 * @arg_hints: Argument to pass with the method invocation.
 * @arg_timeout: Argument to pass with the method invocation.
 * @out_id: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-sigxcpu-Feedback.TriggerFeedback">TriggerFeedback()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See lfb_gdbus_feedback_call_trigger_feedback() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
lfb_gdbus_feedback_call_trigger_feedback_sync (
    LfbGdbusFeedback *proxy,
    const gchar *arg_app_id,
    const gchar *arg_event,
    GVariant *arg_hints,
    gint arg_timeout,
    guint *out_id,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "TriggerFeedback",
    g_variant_new ("(ss@a{sv}i)",
                   arg_app_id,
                   arg_event,
                   arg_hints,
                   arg_timeout),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(u)",
                 out_id);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * lfb_gdbus_feedback_call_end_feedback:
 * @proxy: A #LfbGdbusFeedbackProxy.
 * @arg_id: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-sigxcpu-Feedback.EndFeedback">EndFeedback()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call lfb_gdbus_feedback_call_end_feedback_finish() to get the result of the operation.
 *
 * See lfb_gdbus_feedback_call_end_feedback_sync() for the synchronous, blocking version of this method.
 */
void
lfb_gdbus_feedback_call_end_feedback (
    LfbGdbusFeedback *proxy,
    guint arg_id,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "EndFeedback",
    g_variant_new ("(u)",
                   arg_id),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * lfb_gdbus_feedback_call_end_feedback_finish:
 * @proxy: A #LfbGdbusFeedbackProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to lfb_gdbus_feedback_call_end_feedback().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with lfb_gdbus_feedback_call_end_feedback().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
lfb_gdbus_feedback_call_end_feedback_finish (
    LfbGdbusFeedback *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * lfb_gdbus_feedback_call_end_feedback_sync:
 * @proxy: A #LfbGdbusFeedbackProxy.
 * @arg_id: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-sigxcpu-Feedback.EndFeedback">EndFeedback()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See lfb_gdbus_feedback_call_end_feedback() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
lfb_gdbus_feedback_call_end_feedback_sync (
    LfbGdbusFeedback *proxy,
    guint arg_id,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "EndFeedback",
    g_variant_new ("(u)",
                   arg_id),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * lfb_gdbus_feedback_complete_trigger_feedback:
 * @object: A #LfbGdbusFeedback.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @id: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-sigxcpu-Feedback.TriggerFeedback">TriggerFeedback()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
lfb_gdbus_feedback_complete_trigger_feedback (
    LfbGdbusFeedback *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    guint id)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(u)",
                   id));
}

/**
 * lfb_gdbus_feedback_complete_end_feedback:
 * @object: A #LfbGdbusFeedback.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-sigxcpu-Feedback.EndFeedback">EndFeedback()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
lfb_gdbus_feedback_complete_end_feedback (
    LfbGdbusFeedback *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/* ------------------------------------------------------------------------ */

/**
 * LfbGdbusFeedbackProxy:
 *
 * The #LfbGdbusFeedbackProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * LfbGdbusFeedbackProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #LfbGdbusFeedbackProxy.
 */

struct _LfbGdbusFeedbackProxyPrivate
{
  GData *qdata;
};

static void lfb_gdbus_feedback_proxy_iface_init (LfbGdbusFeedbackIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (LfbGdbusFeedbackProxy, lfb_gdbus_feedback_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (LfbGdbusFeedbackProxy)
                         G_IMPLEMENT_INTERFACE (LFB_GDBUS_TYPE_FEEDBACK, lfb_gdbus_feedback_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (LfbGdbusFeedbackProxy, lfb_gdbus_feedback_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (LFB_GDBUS_TYPE_FEEDBACK, lfb_gdbus_feedback_proxy_iface_init))

#endif
static void
lfb_gdbus_feedback_proxy_finalize (GObject *object)
{
  LfbGdbusFeedbackProxy *proxy = LFB_GDBUS_FEEDBACK_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (lfb_gdbus_feedback_proxy_parent_class)->finalize (object);
}

static void
lfb_gdbus_feedback_proxy_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  info = (const _ExtendedGDBusPropertyInfo *) _lfb_gdbus_feedback_property_info_pointers[prop_id - 1];
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (object), info->parent_struct.name);
  if (info->use_gvariant)
    {
      g_value_set_variant (value, variant);
    }
  else
    {
      if (variant != NULL)
        g_dbus_gvariant_to_gvalue (variant, value);
    }
  if (variant != NULL)
    g_variant_unref (variant);
}

static void
lfb_gdbus_feedback_proxy_set_property_cb (GDBusProxy *proxy,
  GAsyncResult *res,
  gpointer      user_data)
{
  const _ExtendedGDBusPropertyInfo *info = user_data;
  GError *error;
  GVariant *_ret;
  error = NULL;
  _ret = g_dbus_proxy_call_finish (proxy, res, &error);
  if (!_ret)
    {
      g_warning ("Error setting property '%s' on interface org.sigxcpu.Feedback: %s (%s, %d)",
                 info->parent_struct.name, 
                 error->message, g_quark_to_string (error->domain), error->code);
      g_error_free (error);
    }
  else
    {
      g_variant_unref (_ret);
    }
}

static void
lfb_gdbus_feedback_proxy_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  info = (const _ExtendedGDBusPropertyInfo *) _lfb_gdbus_feedback_property_info_pointers[prop_id - 1];
  variant = g_dbus_gvalue_to_gvariant (value, G_VARIANT_TYPE (info->parent_struct.signature));
  g_dbus_proxy_call (G_DBUS_PROXY (object),
    "org.freedesktop.DBus.Properties.Set",
    g_variant_new ("(ssv)", "org.sigxcpu.Feedback", info->parent_struct.name, variant),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    NULL, (GAsyncReadyCallback) lfb_gdbus_feedback_proxy_set_property_cb, (GDBusPropertyInfo *) &info->parent_struct);
  g_variant_unref (variant);
}

static void
lfb_gdbus_feedback_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_lfb_gdbus_feedback_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], LFB_GDBUS_TYPE_FEEDBACK);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, LFB_GDBUS_TYPE_FEEDBACK);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
lfb_gdbus_feedback_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  LfbGdbusFeedbackProxy *proxy = LFB_GDBUS_FEEDBACK_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_lfb_gdbus_feedback_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_lfb_gdbus_feedback_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static const gchar *
lfb_gdbus_feedback_proxy_get_profile (LfbGdbusFeedback *object)
{
  LfbGdbusFeedbackProxy *proxy = LFB_GDBUS_FEEDBACK_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Profile");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static void
lfb_gdbus_feedback_proxy_init (LfbGdbusFeedbackProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = lfb_gdbus_feedback_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, LFB_GDBUS_TYPE_FEEDBACK_PROXY, LfbGdbusFeedbackProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), lfb_gdbus_feedback_interface_info ());
}

static void
lfb_gdbus_feedback_proxy_class_init (LfbGdbusFeedbackProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = lfb_gdbus_feedback_proxy_finalize;
  gobject_class->get_property = lfb_gdbus_feedback_proxy_get_property;
  gobject_class->set_property = lfb_gdbus_feedback_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = lfb_gdbus_feedback_proxy_g_signal;
  proxy_class->g_properties_changed = lfb_gdbus_feedback_proxy_g_properties_changed;

  lfb_gdbus_feedback_override_properties (gobject_class, 1);

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (LfbGdbusFeedbackProxyPrivate));
#endif
}

static void
lfb_gdbus_feedback_proxy_iface_init (LfbGdbusFeedbackIface *iface)
{
  iface->get_profile = lfb_gdbus_feedback_proxy_get_profile;
}

/**
 * lfb_gdbus_feedback_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-sigxcpu-Feedback.top_of_page">org.sigxcpu.Feedback</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call lfb_gdbus_feedback_proxy_new_finish() to get the result of the operation.
 *
 * See lfb_gdbus_feedback_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
lfb_gdbus_feedback_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (LFB_GDBUS_TYPE_FEEDBACK_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.sigxcpu.Feedback", NULL);
}

/**
 * lfb_gdbus_feedback_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to lfb_gdbus_feedback_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with lfb_gdbus_feedback_proxy_new().
 *
 * Returns: (transfer full) (type LfbGdbusFeedbackProxy): The constructed proxy object or %NULL if @error is set.
 */
LfbGdbusFeedback *
lfb_gdbus_feedback_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return LFB_GDBUS_FEEDBACK (ret);
  else
    return NULL;
}

/**
 * lfb_gdbus_feedback_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-sigxcpu-Feedback.top_of_page">org.sigxcpu.Feedback</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See lfb_gdbus_feedback_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type LfbGdbusFeedbackProxy): The constructed proxy object or %NULL if @error is set.
 */
LfbGdbusFeedback *
lfb_gdbus_feedback_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (LFB_GDBUS_TYPE_FEEDBACK_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.sigxcpu.Feedback", NULL);
  if (ret != NULL)
    return LFB_GDBUS_FEEDBACK (ret);
  else
    return NULL;
}


/**
 * lfb_gdbus_feedback_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like lfb_gdbus_feedback_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call lfb_gdbus_feedback_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See lfb_gdbus_feedback_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
lfb_gdbus_feedback_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (LFB_GDBUS_TYPE_FEEDBACK_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.sigxcpu.Feedback", NULL);
}

/**
 * lfb_gdbus_feedback_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to lfb_gdbus_feedback_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with lfb_gdbus_feedback_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type LfbGdbusFeedbackProxy): The constructed proxy object or %NULL if @error is set.
 */
LfbGdbusFeedback *
lfb_gdbus_feedback_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return LFB_GDBUS_FEEDBACK (ret);
  else
    return NULL;
}

/**
 * lfb_gdbus_feedback_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like lfb_gdbus_feedback_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See lfb_gdbus_feedback_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type LfbGdbusFeedbackProxy): The constructed proxy object or %NULL if @error is set.
 */
LfbGdbusFeedback *
lfb_gdbus_feedback_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (LFB_GDBUS_TYPE_FEEDBACK_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.sigxcpu.Feedback", NULL);
  if (ret != NULL)
    return LFB_GDBUS_FEEDBACK (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * LfbGdbusFeedbackSkeleton:
 *
 * The #LfbGdbusFeedbackSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * LfbGdbusFeedbackSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #LfbGdbusFeedbackSkeleton.
 */

struct _LfbGdbusFeedbackSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_lfb_gdbus_feedback_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  LfbGdbusFeedbackSkeleton *skeleton = LFB_GDBUS_FEEDBACK_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], LFB_GDBUS_TYPE_FEEDBACK);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, LFB_GDBUS_TYPE_FEEDBACK);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_lfb_gdbus_feedback_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  LfbGdbusFeedbackSkeleton *skeleton = LFB_GDBUS_FEEDBACK_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_lfb_gdbus_feedback_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_lfb_gdbus_feedback_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  LfbGdbusFeedbackSkeleton *skeleton = LFB_GDBUS_FEEDBACK_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_lfb_gdbus_feedback_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _lfb_gdbus_feedback_skeleton_vtable =
{
  _lfb_gdbus_feedback_skeleton_handle_method_call,
  _lfb_gdbus_feedback_skeleton_handle_get_property,
  _lfb_gdbus_feedback_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
lfb_gdbus_feedback_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return lfb_gdbus_feedback_interface_info ();
}

static GDBusInterfaceVTable *
lfb_gdbus_feedback_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_lfb_gdbus_feedback_skeleton_vtable;
}

static GVariant *
lfb_gdbus_feedback_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  LfbGdbusFeedbackSkeleton *skeleton = LFB_GDBUS_FEEDBACK_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_84
  g_variant_builder_init_static (&builder, G_VARIANT_TYPE ("a{sv}"));
#else
  g_variant_builder_init(&builder, G_VARIANT_TYPE ("a{sv}"));
#endif
  if (_lfb_gdbus_feedback_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _lfb_gdbus_feedback_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _lfb_gdbus_feedback_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _lfb_gdbus_feedback_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.sigxcpu.Feedback", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static gboolean _lfb_gdbus_feedback_emit_changed (gpointer user_data);

static void
lfb_gdbus_feedback_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton)
{
  LfbGdbusFeedbackSkeleton *skeleton = LFB_GDBUS_FEEDBACK_SKELETON (_skeleton);
  gboolean emit_changed = FALSE;

  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    {
      g_source_destroy (skeleton->priv->changed_properties_idle_source);
      skeleton->priv->changed_properties_idle_source = NULL;
      emit_changed = TRUE;
    }
  g_mutex_unlock (&skeleton->priv->lock);

  if (emit_changed)
    _lfb_gdbus_feedback_emit_changed (skeleton);
}

static void
_lfb_gdbus_feedback_on_signal_feedback_ended (
    LfbGdbusFeedback *object,
    guint arg_id,
    guint arg_reason)
{
  LfbGdbusFeedbackSkeleton *skeleton = LFB_GDBUS_FEEDBACK_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(uu)",
                   arg_id,
                   arg_reason));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.sigxcpu.Feedback", "FeedbackEnded",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void lfb_gdbus_feedback_skeleton_iface_init (LfbGdbusFeedbackIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (LfbGdbusFeedbackSkeleton, lfb_gdbus_feedback_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (LfbGdbusFeedbackSkeleton)
                         G_IMPLEMENT_INTERFACE (LFB_GDBUS_TYPE_FEEDBACK, lfb_gdbus_feedback_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (LfbGdbusFeedbackSkeleton, lfb_gdbus_feedback_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (LFB_GDBUS_TYPE_FEEDBACK, lfb_gdbus_feedback_skeleton_iface_init))

#endif
static void
lfb_gdbus_feedback_skeleton_finalize (GObject *object)
{
  LfbGdbusFeedbackSkeleton *skeleton = LFB_GDBUS_FEEDBACK_SKELETON (object);
  guint n;
  for (n = 0; n < 1; n++)
    g_value_unset (&skeleton->priv->properties[n]);
  g_free (skeleton->priv->properties);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (lfb_gdbus_feedback_skeleton_parent_class)->finalize (object);
}

static void
lfb_gdbus_feedback_skeleton_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  LfbGdbusFeedbackSkeleton *skeleton = LFB_GDBUS_FEEDBACK_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  g_mutex_lock (&skeleton->priv->lock);
  g_value_copy (&skeleton->priv->properties[prop_id - 1], value);
  g_mutex_unlock (&skeleton->priv->lock);
}

static gboolean
_lfb_gdbus_feedback_emit_changed (gpointer user_data)
{
  LfbGdbusFeedbackSkeleton *skeleton = LFB_GDBUS_FEEDBACK_SKELETON (user_data);
  GList *l;
  GVariantBuilder builder;
  GVariantBuilder invalidated_builder;
  guint num_changes;

  g_mutex_lock (&skeleton->priv->lock);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_84
  g_variant_builder_init_static (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init_static (&invalidated_builder, G_VARIANT_TYPE ("as"));
#else
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init (&invalidated_builder, G_VARIANT_TYPE ("as"));
#endif
  for (l = skeleton->priv->changed_properties, num_changes = 0; l != NULL; l = l->next)
    {
      ChangedProperty *cp = l->data;
      GVariant *variant;
      const GValue *cur_value;

      cur_value = &skeleton->priv->properties[cp->prop_id - 1];
      if (!_g_value_equal (cur_value, &cp->orig_value))
        {
          variant = g_dbus_gvalue_to_gvariant (cur_value, G_VARIANT_TYPE (cp->info->parent_struct.signature));
          g_variant_builder_add (&builder, "{sv}", cp->info->parent_struct.name, variant);
          g_variant_unref (variant);
          num_changes++;
        }
    }
  if (num_changes > 0)
    {
      GList *connections, *ll;
      GVariant *signal_variant;
      signal_variant = g_variant_ref_sink (g_variant_new ("(sa{sv}as)", "org.sigxcpu.Feedback",
                                           &builder, &invalidated_builder));
      connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));
      for (ll = connections; ll != NULL; ll = ll->next)
        {
          GDBusConnection *connection = ll->data;

          g_dbus_connection_emit_signal (connection,
                                         NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)),
                                         "org.freedesktop.DBus.Properties",
                                         "PropertiesChanged",
                                         signal_variant,
                                         NULL);
        }
      g_variant_unref (signal_variant);
      g_list_free_full (connections, g_object_unref);
    }
  else
    {
      g_variant_builder_clear (&builder);
      g_variant_builder_clear (&invalidated_builder);
    }
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  skeleton->priv->changed_properties = NULL;
  skeleton->priv->changed_properties_idle_source = NULL;
  g_mutex_unlock (&skeleton->priv->lock);
  return FALSE;
}

static void
_lfb_gdbus_feedback_schedule_emit_changed (LfbGdbusFeedbackSkeleton *skeleton, const _ExtendedGDBusPropertyInfo *info, guint prop_id, const GValue *orig_value)
{
  ChangedProperty *cp;
  GList *l;
  cp = NULL;
  for (l = skeleton->priv->changed_properties; l != NULL; l = l->next)
    {
      ChangedProperty *i_cp = l->data;
      if (i_cp->info == info)
        {
          cp = i_cp;
          break;
        }
    }
  if (cp == NULL)
    {
      cp = g_new0 (ChangedProperty, 1);
      cp->prop_id = prop_id;
      cp->info = info;
      skeleton->priv->changed_properties = g_list_prepend (skeleton->priv->changed_properties, cp);
      g_value_init (&cp->orig_value, G_VALUE_TYPE (orig_value));
      g_value_copy (orig_value, &cp->orig_value);
    }
}

static void
lfb_gdbus_feedback_skeleton_notify (GObject      *object,
  GParamSpec *pspec G_GNUC_UNUSED)
{
  LfbGdbusFeedbackSkeleton *skeleton = LFB_GDBUS_FEEDBACK_SKELETON (object);
  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties != NULL &&
      skeleton->priv->changed_properties_idle_source == NULL)
    {
      skeleton->priv->changed_properties_idle_source = g_idle_source_new ();
      g_source_set_priority (skeleton->priv->changed_properties_idle_source, G_PRIORITY_DEFAULT);
      g_source_set_callback (skeleton->priv->changed_properties_idle_source, _lfb_gdbus_feedback_emit_changed, g_object_ref (skeleton), (GDestroyNotify) g_object_unref);
      g_source_set_name (skeleton->priv->changed_properties_idle_source, "[generated] _lfb_gdbus_feedback_emit_changed");
      g_source_attach (skeleton->priv->changed_properties_idle_source, skeleton->priv->context);
      g_source_unref (skeleton->priv->changed_properties_idle_source);
    }
  g_mutex_unlock (&skeleton->priv->lock);
}

static void
lfb_gdbus_feedback_skeleton_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec)
{
  const _ExtendedGDBusPropertyInfo *info;
  LfbGdbusFeedbackSkeleton *skeleton = LFB_GDBUS_FEEDBACK_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  info = (const _ExtendedGDBusPropertyInfo *) _lfb_gdbus_feedback_property_info_pointers[prop_id - 1];
  g_mutex_lock (&skeleton->priv->lock);
  g_object_freeze_notify (object);
  if (!_g_value_equal (value, &skeleton->priv->properties[prop_id - 1]))
    {
      if (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)) != NULL &&
          info->emits_changed_signal)
        _lfb_gdbus_feedback_schedule_emit_changed (skeleton, info, prop_id, &skeleton->priv->properties[prop_id - 1]);
      g_value_copy (value, &skeleton->priv->properties[prop_id - 1]);
      g_object_notify_by_pspec (object, pspec);
    }
  g_mutex_unlock (&skeleton->priv->lock);
  g_object_thaw_notify (object);
}

static void
lfb_gdbus_feedback_skeleton_init (LfbGdbusFeedbackSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = lfb_gdbus_feedback_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, LFB_GDBUS_TYPE_FEEDBACK_SKELETON, LfbGdbusFeedbackSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
  skeleton->priv->properties = g_new0 (GValue, 1);
  g_value_init (&skeleton->priv->properties[0], G_TYPE_STRING);
}

static const gchar *
lfb_gdbus_feedback_skeleton_get_profile (LfbGdbusFeedback *object)
{
  LfbGdbusFeedbackSkeleton *skeleton = LFB_GDBUS_FEEDBACK_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_string (&(skeleton->priv->properties[0]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static void
lfb_gdbus_feedback_skeleton_class_init (LfbGdbusFeedbackSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = lfb_gdbus_feedback_skeleton_finalize;
  gobject_class->get_property = lfb_gdbus_feedback_skeleton_get_property;
  gobject_class->set_property = lfb_gdbus_feedback_skeleton_set_property;
  gobject_class->notify       = lfb_gdbus_feedback_skeleton_notify;


  lfb_gdbus_feedback_override_properties (gobject_class, 1);

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = lfb_gdbus_feedback_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = lfb_gdbus_feedback_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = lfb_gdbus_feedback_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = lfb_gdbus_feedback_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (LfbGdbusFeedbackSkeletonPrivate));
#endif
}

static void
lfb_gdbus_feedback_skeleton_iface_init (LfbGdbusFeedbackIface *iface)
{
  iface->feedback_ended = _lfb_gdbus_feedback_on_signal_feedback_ended;
  iface->get_profile = lfb_gdbus_feedback_skeleton_get_profile;
}

/**
 * lfb_gdbus_feedback_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-sigxcpu-Feedback.top_of_page">org.sigxcpu.Feedback</link>.
 *
 * Returns: (transfer full) (type LfbGdbusFeedbackSkeleton): The skeleton object.
 */
LfbGdbusFeedback *
lfb_gdbus_feedback_skeleton_new (void)
{
  return LFB_GDBUS_FEEDBACK (g_object_new (LFB_GDBUS_TYPE_FEEDBACK_SKELETON, NULL));
}

