/*
 * Copyright (C) 2011 ZXing authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.google.zxing.client.android.encode;

/**
 * Encapsulates some simple formatting logic, to aid refactoring in {@link ContactEncoder}.
 *
 * @author Sean Owen
 */
interface Formatter {

  /**
   * @param value value to format
   * @param index index of value in a list of values to be formatted
   * @return formatted value
   */
  CharSequence format(CharSequence value, int index);
  
}
