.\"remove .ig hn for full docs
.de hi
.ig eh
..
.de eh
..
.TH "" 3 "" "Version 3.0" "Free Widget Foundation"
.SH NAME
XfwfRadioGroup
.SH DESCRIPTION
The RadioGroup widget is a simple specialization of the Group
widget. It has an extra resource, \fIlabels\fP, which holds the labels of
the toggle buttons that are created automatically. For the common case
that a Group widget contains only radio buttons, the RadioGroup widget
is much more convenient. It is also much less flexible. E.g., it is
very difficult to change resources of the radio buttons, when the
defaults are not satisfactory.

In particular, the Toggle widgets are created with the following
hardcoded resources: \fIshrinkToFit = True\fP, \fIborder_width = 0\fP,
\fIframeWidth = 0\fP. The names of the Toggle widgets are equal to their
labels.

.SS "Public variables"

.ps -2
.TS
center box;
cBsss
lB|lB|lB|lB
l|l|l|l.
XfwfRadioGroup
Name	Class	Type	Default
XtNlabels	XtCLabels	StringArray 	NULL 

.TE
.ps

.TP
.I "XtNlabels"
The \fIlabels\fP resource is an array of strings. Each string will
become the label of a toggle button. The last member of the array must
be a \fINULL\fP pointer.

There is a converter that allows the list of strings to be entered as
a single string, with any character as separator.

	

.hi

.nf
StringArray  labels = NULL 
.fi

.eh

.ps -2
.TS
center box;
cBsss
lB|lB|lB|lB
l|l|l|l.
XfwfGroup
Name	Class	Type	Default
XtNlabel	XtCLabel	String 	NULL 
XtNfont	XtCFont	FontStruct	XtDefaultFont 
XtNforeground	XtCForeground	Pixel 	XtDefaultForeground 
XtNselectionStyle	XtCSelectionStyle	SelectionType 	XfwfSingleSelection 
XtNselection	XtCSelection	Long 	0 
XtNactivate	XtCActivate	Callback	NULL 

.TE
.ps

.ps -2
.TS
center box;
cBsss
lB|lB|lB|lB
l|l|l|l.
XfwfRowCol
Name	Class	Type	Default
XtNstoreByRow	XtCStoreByRow	Boolean 	True 
XtNrows	XtCRows	Int 	0 
XtNcolumns	XtCColumns	Int 	0 
XtNalignment	XtCAlignment	Alignment 	XfwfTopLeft 
XtNshrinkToFit	XtCShrinkToFit	Boolean 	False 

.TE
.ps

.ps -2
.TS
center box;
cBsss
lB|lB|lB|lB
l|l|l|l.
XfwfBoard
Name	Class	Type	Default
XtNabs_x	XtCAbs_x	Position 	0 
XtNrel_x	XtCRel_x	Float 	"0.0"
XtNabs_y	XtCAbs_y	Position 	0 
XtNrel_y	XtCRel_y	Float 	"0.0"
XtNabs_width	XtCAbs_width	Position 	0 
XtNrel_width	XtCRel_width	Float 	"1.0"
XtNabs_height	XtCAbs_height	Position 	0 
XtNrel_height	XtCRel_height	Float 	"1.0"
XtNhunit	XtCHunit	Float 	"1.0"
XtNvunit	XtCVunit	Float 	"1.0"
XtNlocation	XtCLocation	String 	NULL 

.TE
.ps

.ps -2
.TS
center box;
cBsss
lB|lB|lB|lB
l|l|l|l.
XfwfFrame
Name	Class	Type	Default
XtNcursor	XtCCursor	Cursor 	None 
XtNframeType	XtCFrameType	FrameType 	XfwfRaised 
XtNframeWidth	XtCFrameWidth	Dimension 	0 
XtNouterOffset	XtCOuterOffset	Dimension 	0 
XtNinnerOffset	XtCInnerOffset	Dimension 	0 
XtNshadowScheme	XtCShadowScheme	ShadowScheme 	XfwfAuto 
XtNtopShadowColor	XtCTopShadowColor	Pixel 	compute_topcolor 
XtNbottomShadowColor	XtCBottomShadowColor	Pixel 	compute_bottomcolor 
XtNtopShadowStipple	XtCTopShadowStipple	Bitmap 	NULL 
XtNbottomShadowStipple	XtCBottomShadowStipple	Bitmap 	NULL 

.TE
.ps

.ps -2
.TS
center box;
cBsss
lB|lB|lB|lB
l|l|l|l.
XfwfCommon
Name	Class	Type	Default
XtNtraversalOn	XtCTraversalOn	Boolean 	True 
XtNhighlightThickness	XtCHighlightThickness	Dimension 	2 
XtNhighlightColor	XtCHighlightColor	Pixel 	XtDefaultForeground 
XtNhighlightPixmap	XtCHighlightPixmap	Pixmap 	None 
XtNnextTop	XtCNextTop	Callback	NULL 
XtNuserData	XtCUserData	Pointer	NULL 

.TE
.ps

.ps -2
.TS
center box;
cBsss
lB|lB|lB|lB
l|l|l|l.
Composite
Name	Class	Type	Default
XtNchildren	XtCChildren	WidgetList 	NULL 
insertPosition	XtCInsertPosition	XTOrderProc 	NULL 
numChildren	XtCNumChildren	Cardinal 	0 

.TE
.ps

.ps -2
.TS
center box;
cBsss
lB|lB|lB|lB
l|l|l|l.
Core
Name	Class	Type	Default
XtNx	XtCX	Position 	0 
XtNy	XtCY	Position 	0 
XtNwidth	XtCWidth	Dimension 	0 
XtNheight	XtCHeight	Dimension 	0 
borderWidth	XtCBorderWidth	Dimension 	0 
XtNcolormap	XtCColormap	Colormap 	NULL 
XtNdepth	XtCDepth	Int 	0 
destroyCallback	XtCDestroyCallback	XTCallbackList 	NULL 
XtNsensitive	XtCSensitive	Boolean 	True 
XtNtm	XtCTm	XTTMRec 	NULL 
ancestorSensitive	XtCAncestorSensitive	Boolean 	False 
accelerators	XtCAccelerators	XTTranslations 	NULL 
borderColor	XtCBorderColor	Pixel 	0 
borderPixmap	XtCBorderPixmap	Pixmap 	NULL 
background	XtCBackground	Pixel 	0 
backgroundPixmap	XtCBackgroundPixmap	Pixmap 	NULL 
mappedWhenManaged	XtCMappedWhenManaged	Boolean 	True 
XtNscreen	XtCScreen	Screen *	NULL 

.TE
.ps

.SS "Exports"

The type \fIStringArray\fP represents an array of \fIString\fPs, with the
proviso that by convention the last member of a \fIStringArray\fP is
always a \fINULL\fP pointer. There is a converter that can construct a
\fIStringArray\fP from a single string.

	

.nf

.B type
 StringArray = String *
.fi

.hi
.SH "Importss"

.nf

.B incl
 <Xfwf/Toggle.h>
.fi

.hi

.hi
.SS "Methods"

\fIclass_initialize\fP registers the type converter.

.nf
class_initialize()
{
    XtSetTypeConverter(XtRString, "StringArray", cvtStringToStringArray,
		       NULL, 0, XtCacheNone, NULL);
}
.fi

In the \fIinitialize\fP method, the utility function \fIcreate_toggles\fP is
called, which creates toggle widgets for each label in the \fIlabels\fP
resource.

.nf
initialize(Widget  request, $, ArgList  args, Cardinal * num_args)
{
    $labels = newStringArray($labels);
    create_toggles($);
}
.fi

The \fIset_values\fP method makes a private copy of the \fIlabels\fP
resource and calls \fIcreate_labels\fP. Since the RadioGroup doesn't draw
anything itself, the return value is always \fIFalse\fP.

.nf
Boolean  set_values(Widget  old, Widget  request, $, ArgList  args, Cardinal * num_args)
{
    if ($old$labels != $labels) {
	freeStringArray($old$labels);
	$labels = newStringArray($labels);
	create_toggles($);
    }
    return False;
}
.fi

.hi

.hi
.SH "Utilities"

The function \fIcreate_toggles\fP first destroys all existing children
and then creates new ones. For each string in the \fIlabels\fP resource
there will be an XfwfToggle button.

.nf
create_toggles($)
{
    Cardinal i;
    StringArray s;

    for (i = 0; i < $num_children; i++) 
	XtDestroyWidget($children[i]);

    if ($labels == NULL) return;

    for (s = $labels, i = 0; s[i] != NULL; i++) {
	(void) XtVaCreateManagedWidget
	    (s[i], xfwfToggleWidgetClass, $, XtNlabel, s[i], XtNshrinkToFit,
	     True, XtNborderWidth, 0, XtNframeWidth, 0, NULL);
    }
}
.fi

The converter from \fIString\fP to \fIStringArray\fP makes a copy of the
passed string and then replaces all occurences of the delimiter with
a nul byte. The \fIStringArray\fP a is filled with pointers to the parts
of the string.

The delimiter character is the first character in the string.

\fBdef\fP done(type, value) =
do {
	if (to->addr != NULL) {
	    if (to->size < sizeof(type)) {
	        to->size = sizeof(type);
	        return False;
	    }
	    *(type*)(to->addr) = (value);
        } else {
	    static type static_val;
	    static_val = (value);
	    to->addr = (XtPointer)static_val;
        }
        to->size = sizeof(type);
        return True;
    }while (0 )

.nf
Boolean  cvtStringToStringArray(Display * display, XrmValuePtr  args, Cardinal * num_args, XrmValuePtr  from, XrmValuePtr  to, XtPointer * converter_data)
{
    String t, s;
    StringArray a = NULL;
    Cardinal i;
    char delim;

    if (*num_args != 0)
	XtAppErrorMsg(XtDisplayToApplicationContext(display),
		      "cvtStringToStringArray", "wrongParameters",
		      "XtToolkitError",
		      "String to StringArray conversion needs no arguments",
		      (String*) NULL, (Cardinal*) NULL);

    delim = ((String) from->addr)[0];
    s = XtNewString((String) from->addr + 1);
    i = 0;
    while (s  *s) {
	t = strchr(s, delim);
        if (t) *t = '\\0';
	a = (StringArray) XtRealloc((String) a, (i + 1) * sizeof(*a));
	a[i] = s;
	i++;
        s = t ? t + 1 : NULL;
    }
    a = (StringArray) XtRealloc((String) a, (i + 1) * sizeof(*a));
    a[i] = NULL;
    done(StringArray, a);
}
.fi

The function \fInewStringArray\fP makes a copy of a \fIStringArray\fP. It
allocates new space for the array itself and for the strings that it
contains.

.nf
StringArray  newStringArray(StringArray  a)
{
    Cardinal n, i;
    StringArray s;

    if (!a) return NULL;
    for (s = a, n = 0; s[n]; n++) ;
    s = (StringArray) XtMalloc((n + 1) * sizeof(*s));
    for (i = 0; i < n; i++) s[i] = XtNewString(a[i]);
    s[n] = NULL;
    return s;
}
.fi

\fIfreeStringArray\fP deallocates the array and all strings it contains.

.nf
freeStringArray(StringArray  a)
{
    Cardinal i;

    if (!a) return;
    for (i = 0; a[i]; i++) XtFree(a[i]);
    XtFree((String) a);
}
.fi

.hi
