/* Do not modify this file. Changes will be overwritten.                      */
/* Generated automatically by the ASN.1 to Wireshark dissector compiler       */
/* packet-lte-rrc.c                                                           */
/* asn2wrs.py -L -p lte-rrc -c ./lte-rrc.cnf -s ./packet-lte-rrc-template -D . -O ../.. EUTRA-InterNodeDefinitions.asn EUTRA-RRC-Definitions.asn EUTRA-Sidelink-Preconf.asn EUTRA-UE-Variables.asn PC5-RRC-Definitions.asn NBIOT-InterNodeDefinitions.asn NBIOT-RRC-Definitions.asn NBIOT-UE-Variables.asn */

/* Input file: packet-lte-rrc-template.c */

#line 1 "./asn1/lte-rrc/packet-lte-rrc-template.c"
/* packet-lte-rrc-template.c
 * Routines for Evolved Universal Terrestrial Radio Access (E-UTRA);
 * Radio Resource Control (RRC) protocol specification
 * (3GPP TS 36.331 V15.7.0 Release 15) packet dissection
 * Copyright 2008, Vincent Helfre
 * Copyright 2009-2019, Pascal Quantin
 *
 * Wireshark - Network traffic analyzer
 * By Gerald Combs <gerald@wireshark.org>
 * Copyright 1998 Gerald Combs
 *
 * SPDX-License-Identifier: GPL-2.0-or-later
 */

#include "config.h"

#include <stdlib.h>

#include <epan/packet.h>
#include <epan/to_str.h>
#include <epan/asn1.h>
#include <epan/expert.h>
#include <epan/reassemble.h>
#include <epan/exceptions.h>
#include <epan/show_exception.h>
#include <epan/proto_data.h>

#include <wsutil/str_util.h>

#include "packet-per.h"
#include "packet-rrc.h"
#include "packet-gsm_a_common.h"
#include "packet-lpp.h"
#include "packet-gsm_map.h"
#include "packet-cell_broadcast.h"
#include "packet-mac-lte.h"
#include "packet-rlc-lte.h"
#include "packet-pdcp-lte.h"
#include "packet-nr-rrc.h"
#include "packet-lte-rrc.h"

#define PNAME  "LTE Radio Resource Control (RRC) protocol"
#define PSNAME "LTE RRC"
#define PFNAME "lte_rrc"

void proto_register_lte_rrc(void);
void proto_reg_handoff_lte_rrc(void);

static dissector_handle_t nas_eps_handle = NULL;
static dissector_handle_t rrc_irat_ho_to_utran_cmd_handle = NULL;
static dissector_handle_t rrc_sys_info_cont_handle = NULL;
static dissector_handle_t gsm_a_dtap_handle = NULL;
static dissector_handle_t gsm_rlcmac_dl_handle = NULL;
static dissector_handle_t nr_rrc_reconf_handle = NULL;
static dissector_handle_t lte_rrc_conn_reconf_handle;
static dissector_handle_t lte_rrc_dl_ccch_handle;

static wmem_map_t *lte_rrc_etws_cmas_dcs_hash = NULL;

/* Keep track of where/how the System Info value has changed */
static wmem_map_t *lte_rrc_system_info_value_changed_hash = NULL;
static guint8     system_info_value_current;
static gboolean   system_info_value_current_set;


extern int proto_mac_lte;
extern int proto_rlc_lte;
extern int proto_pdcp_lte;


/* Include constants */

/*--- Included file: packet-lte-rrc-val.h ---*/
#line 1 "./asn1/lte-rrc/packet-lte-rrc-val.h"
#define maxReestabInfo                 32
#define maxAccessCat_1_r15             63
#define maxACDC_Cat_r13                16
#define maxAvailNarrowBands_r13        16
#define maxBandComb_r10                128
#define maxBandComb_r11                256
#define maxBandComb_r13                384
#define maxBands                       64
#define maxBandsNR_r15                 1024
#define maxBandwidthClass_r10          16
#define maxBandwidthCombSet_r10        32
#define maxBarringInfoSet_r15          8
#define maxBT_IdReport_r15             32
#define maxBT_Name_r15                 4
#define maxCBR_Level_r14               16
#define maxCBR_Level_1_r14             15
#define maxCBR_Report_r14              72
#define maxCDMA_BandClass              32
#define maxCE_Level_r13                4
#define maxCellBlack                   16
#define maxCellHistory_r12             16
#define maxCellInfoGERAN_r9            32
#define maxCellInfoUTRA_r9             16
#define maxCellMeasIdle_r15            8
#define maxCombIDC_r11                 128
#define maxCSI_IM_r11                  3
#define maxCSI_IM_r12                  4
#define minCSI_IM_r13                  5
#define maxCSI_IM_r13                  24
#define maxCSI_IM_v1310                20
#define maxCSI_Proc_r11                4
#define maxCSI_RS_NZP_r11              3
#define minCSI_RS_NZP_r13              4
#define maxCSI_RS_NZP_r13              24
#define maxCSI_RS_NZP_v1310            21
#define maxCSI_RS_ZP_r11               4
#define maxCQI_ProcExt_r11             3
#define maxFreqUTRA_TDD_r10            6
#define maxCellInter                   16
#define maxCellIntra                   16
#define maxCellListGERAN               3
#define maxCellMeas                    32
#define maxCellReport                  8
#define maxCellSFTD                    3
#define maxConfigSPS_r14               8
#define maxConfigSPS_r15               6
#define maxCSI_RS_Meas_r12             96
#define maxDRB                         11
#define maxDRBExt_r15                  4
#define maxDRB_r15                     15
#define maxDS_Duration_r12             5
#define maxDS_ZTP_CSI_RS_r12           5
#define maxEARFCN                      65535
#define maxEARFCN_Plus1                65536
#define maxEARFCN2                     262143
#define maxEPDCCH_Set_r11              2
#define maxFBI                         64
#define maxFBI_NR_r15                  1024
#define maxFBI_Plus1                   65
#define maxFBI2                        256
#define maxFeatureSets_r15             256
#define maxPerCC_FeatureSets_r15       32
#define maxFreq                        8
#define maxFreqIDC_r11                 32
#define maxFreqIdle_r15                8
#define maxFreqMBMS_r11                5
#define maxFreqNR_r15                  5
#define maxFreqV2X_r14                 8
#define maxFreqV2X_1_r14               7
#define maxGERAN_SI                    10
#define maxGNFG                        16
#define maxIdleMeasCarriers_r15        3
#define maxLCG_r13                     4
#define maxLogMeasReport_r10           520
#define maxMBSFN_Allocations           8
#define maxMBSFN_Area                  8
#define maxMBSFN_Area_1                7
#define maxMBMS_ServiceListPerUE_r13   15
#define maxMeasId                      32
#define maxMeasId_Plus1                33
#define maxMeasId_r12                  64
#define maxMultiBands                  8
#define maxMultiBandsNR_r15            32
#define maxMultiBandsNR_1_r15          31
#define maxNS_Pmax_r10                 8
#define maxNAICS_Entries_r12           8
#define maxNeighCell_r12               8
#define maxNeighCell_SCPTM_r13         8
#define maxNrofS_NSSAI_r15             8
#define maxObjectId                    32
#define maxObjectId_Plus1_r13          33
#define maxObjectId_r13                64
#define maxP_a_PerNeighCell_r12        3
#define maxPageRec                     16
#define maxPhysCellIdRange_r9          4
#define maxPLMN_r11                    6
#define maxPLMN_1_r14                  5
#define maxPLMN_r15                    8
#define maxPLMN_NR_r15                 12
#define maxPNOffset                    511
#define maxPMCH_PerMBSFN               15
#define maxPSSCH_TxConfig_r14          16
#define maxQuantSetsNR_r15             2
#define maxQCI_r13                     6
#define maxRAT_Capabilities            8
#define maxRE_MapQCL_r11               4
#define maxReportConfigId              32
#define maxReservationPeriod_r14       16
#define maxRS_Index_r15                64
#define maxRS_Index_1_r15              63
#define maxRS_IndexCellQual_r15        16
#define maxRS_IndexReport_r15          32
#define maxRSTD_Freq_r10               3
#define maxSAI_MBMS_r11                64
#define maxSCell_r10                   4
#define maxSCell_r13                   31
#define maxSCellGroups_r15             4
#define maxSC_MTCH_r13                 1023
#define maxSC_MTCH_BR_r14              128
#define maxSL_CommRxPoolNFreq_r13      32
#define maxSL_CommRxPoolPreconf_v1310  12
#define maxSL_TxPool_r12Plus1_r13      5
#define maxSL_TxPool_v1310             4
#define maxSL_TxPool_r13               8
#define maxSL_CommTxPoolPreconf_v1310  7
#define maxSL_Dest_r12                 16
#define maxSL_DiscCells_r13            16
#define maxSL_DiscPowerClass_r12       3
#define maxSL_DiscRxPoolPreconf_r13    16
#define maxSL_DiscSysInfoReportFreq_r13 8
#define maxSL_DiscTxPoolPreconf_r13    4
#define maxSL_GP_r13                   8
#define maxSL_PoolToMeasure_r14        72
#define maxSL_Prio_r13                 8
#define maxSL_RxPool_r12               16
#define maxSL_Reliability_r15          8
#define maxSL_SyncConfig_r12           16
#define maxSL_TF_IndexPair_r12         64
#define maxSL_TxPool_r12               4
#define maxSL_V2X_RxPool_r14           16
#define maxSL_V2X_RxPoolPreconf_r14    16
#define maxSL_V2X_TxPool_r14           8
#define maxSL_V2X_TxPoolPreconf_r14    8
#define maxSL_V2X_SyncConfig_r14       16
#define maxSL_V2X_CBRConfig_r14        4
#define maxSL_V2X_CBRConfig_1_r14      3
#define maxSL_V2X_TxConfig_r14         64
#define maxSL_V2X_TxConfig_1_r14       63
#define maxSL_V2X_CBRConfig2_r14       8
#define maxSL_V2X_CBRConfig2_1_r14     7
#define maxSL_V2X_TxConfig2_r14        128
#define maxSL_V2X_TxConfig2_1_r14      127
#define maxSTAG_r11                    3
#define maxServCell_r10                5
#define maxServCell_r13                32
#define maxServCellNR_r15              16
#define maxServiceCount                16
#define maxServiceCount_1              15
#define maxSessionPerPMCH              29
#define maxSessionPerPMCH_1            28
#define maxSIB                         32
#define maxSIB_1                       31
#define maxSI_Message                  32
#define maxSimultaneousBands_r10       64
#define maxSubframePatternIDC_r11      8
#define maxTrafficPattern_r14          8
#define maxUTRA_FDD_Carrier            16
#define maxUTRA_TDD_Carrier            16
#define maxWayPoint_r15                20
#define maxWLAN_Id_r12                 16
#define maxWLAN_Bands_r13              8
#define maxWLAN_Id_r13                 32
#define maxWLAN_Channels_r13           16
#define maxWLAN_CarrierInfo_r13        8
#define maxWLAN_Id_Report_r14          32
#define maxWLAN_Name_r15               4
#define maxLogMeas_r10                 4060
#define maxNPRACH_Resources_NB_r13     3
#define maxNonAnchorCarriers_NB_r14    15
#define maxDRB_NB_r13                  2
#define maxNeighCell_SCPTM_NB_r14      8
#define maxNS_Pmax_NB_r13              4
#define maxSC_MTCH_NB_r14              64
#define maxSI_Message_NB_r13           8

typedef enum _RAT_Type_enum {
  RAT_Type_eutra =   0,
  RAT_Type_utra =   1,
  RAT_Type_geran_cs =   2,
  RAT_Type_geran_ps =   3,
  RAT_Type_cdma2000_1XRTT =   4,
  RAT_Type_nr  =   5,
  RAT_Type_eutra_nr =   6,
  RAT_Type_spare1 =   7
} RAT_Type_enum;

typedef enum _T_targetRAT_Type_enum {
  T_targetRAT_Type_utra =   0,
  T_targetRAT_Type_geran =   1,
  T_targetRAT_Type_cdma2000_1XRTT =   2,
  T_targetRAT_Type_cdma2000_HRPD =   3,
  T_targetRAT_Type_nr =   4,
  T_targetRAT_Type_eutra =   5,
  T_targetRAT_Type_spare2 =   6,
  T_targetRAT_Type_spare1 =   7
} T_targetRAT_Type_enum;

typedef enum _SI_OrPSI_GERAN_enum {
  SI_OrPSI_GERAN_si =   0,
  SI_OrPSI_GERAN_psi =   1
} SI_OrPSI_GERAN_enum;

/*--- End of included file: packet-lte-rrc-val.h ---*/
#line 73 "./asn1/lte-rrc/packet-lte-rrc-template.c"

/* Initialize the protocol and registered fields */
static int proto_lte_rrc = -1;


/*--- Included file: packet-lte-rrc-hf.c ---*/
#line 1 "./asn1/lte-rrc/packet-lte-rrc-hf.c"
static int hf_lte_rrc_lte_rrc_HandoverCommand_PDU = -1;  /* HandoverCommand */
static int hf_lte_rrc_lte_rrc_HandoverPreparationInformation_PDU = -1;  /* HandoverPreparationInformation */
static int hf_lte_rrc_lte_rrc_SCG_Config_r12_PDU = -1;  /* SCG_Config_r12 */
static int hf_lte_rrc_lte_rrc_SCG_ConfigInfo_r12_PDU = -1;  /* SCG_ConfigInfo_r12 */
static int hf_lte_rrc_lte_rrc_UEPagingCoverageInformation_PDU = -1;  /* UEPagingCoverageInformation */
static int hf_lte_rrc_UERadioAccessCapabilityInformation_PDU = -1;  /* UERadioAccessCapabilityInformation */
static int hf_lte_rrc_lte_rrc_UERadioPagingInformation_PDU = -1;  /* UERadioPagingInformation */
static int hf_lte_rrc_BCCH_BCH_Message_PDU = -1;  /* BCCH_BCH_Message */
static int hf_lte_rrc_BCCH_BCH_Message_MBMS_PDU = -1;  /* BCCH_BCH_Message_MBMS */
static int hf_lte_rrc_BCCH_DL_SCH_Message_PDU = -1;  /* BCCH_DL_SCH_Message */
static int hf_lte_rrc_BCCH_DL_SCH_Message_BR_PDU = -1;  /* BCCH_DL_SCH_Message_BR */
static int hf_lte_rrc_BCCH_DL_SCH_Message_MBMS_PDU = -1;  /* BCCH_DL_SCH_Message_MBMS */
static int hf_lte_rrc_MCCH_Message_PDU = -1;      /* MCCH_Message */
static int hf_lte_rrc_PCCH_Message_PDU = -1;      /* PCCH_Message */
static int hf_lte_rrc_DL_CCCH_Message_PDU = -1;   /* DL_CCCH_Message */
static int hf_lte_rrc_DL_DCCH_Message_PDU = -1;   /* DL_DCCH_Message */
static int hf_lte_rrc_UL_CCCH_Message_PDU = -1;   /* UL_CCCH_Message */
static int hf_lte_rrc_UL_DCCH_Message_PDU = -1;   /* UL_DCCH_Message */
static int hf_lte_rrc_SC_MCCH_Message_r13_PDU = -1;  /* SC_MCCH_Message_r13 */
static int hf_lte_rrc_lte_rrc_MeasurementReport_PDU = -1;  /* MeasurementReport */
static int hf_lte_rrc_RRCConnectionReconfiguration_PDU = -1;  /* RRCConnectionReconfiguration */
static int hf_lte_rrc_lte_rrc_RRCConnectionReconfigurationComplete_PDU = -1;  /* RRCConnectionReconfigurationComplete */
static int hf_lte_rrc_UECapabilityInformation_PDU = -1;  /* UECapabilityInformation */
static int hf_lte_rrc_lte_rrc_RLF_Report_r9_PDU = -1;  /* RLF_Report_r9 */
static int hf_lte_rrc_lte_rrc_RLF_Report_v9e0_PDU = -1;  /* RLF_Report_v9e0 */
static int hf_lte_rrc_lte_rrc_MeasResultSCG_FailureMRDC_r15_PDU = -1;  /* MeasResultSCG_FailureMRDC_r15 */
static int hf_lte_rrc_lte_rrc_MeasResultList3EUTRA_r15_PDU = -1;  /* MeasResultList3EUTRA_r15 */
static int hf_lte_rrc_lte_rrc_UE_EUTRA_Capability_PDU = -1;  /* UE_EUTRA_Capability */
static int hf_lte_rrc_lte_rrc_VisitedCellInfoList_r12_PDU = -1;  /* VisitedCellInfoList_r12 */
static int hf_lte_rrc_lte_rrc_VisitedCellInfo_r12_PDU = -1;  /* VisitedCellInfo_r12 */
static int hf_lte_rrc_SBCCH_SL_BCH_Message_PDU = -1;  /* SBCCH_SL_BCH_Message */
static int hf_lte_rrc_SBCCH_SL_BCH_Message_V2X_r14_PDU = -1;  /* SBCCH_SL_BCH_Message_V2X_r14 */
static int hf_lte_rrc_lte_rrc_HandoverPreparationInformation_NB_PDU = -1;  /* HandoverPreparationInformation_NB */
static int hf_lte_rrc_lte_rrc_UEPagingCoverageInformation_NB_PDU = -1;  /* UEPagingCoverageInformation_NB */
static int hf_lte_rrc_UERadioAccessCapabilityInformation_NB_PDU = -1;  /* UERadioAccessCapabilityInformation_NB */
static int hf_lte_rrc_UERadioPagingInformation_NB_PDU = -1;  /* UERadioPagingInformation_NB */
static int hf_lte_rrc_BCCH_BCH_Message_NB_PDU = -1;  /* BCCH_BCH_Message_NB */
static int hf_lte_rrc_BCCH_BCH_Message_TDD_NB_PDU = -1;  /* BCCH_BCH_Message_TDD_NB */
static int hf_lte_rrc_BCCH_DL_SCH_Message_NB_PDU = -1;  /* BCCH_DL_SCH_Message_NB */
static int hf_lte_rrc_PCCH_Message_NB_PDU = -1;   /* PCCH_Message_NB */
static int hf_lte_rrc_DL_CCCH_Message_NB_PDU = -1;  /* DL_CCCH_Message_NB */
static int hf_lte_rrc_DL_DCCH_Message_NB_PDU = -1;  /* DL_DCCH_Message_NB */
static int hf_lte_rrc_UL_CCCH_Message_NB_PDU = -1;  /* UL_CCCH_Message_NB */
static int hf_lte_rrc_SC_MCCH_Message_NB_PDU = -1;  /* SC_MCCH_Message_NB */
static int hf_lte_rrc_UL_DCCH_Message_NB_PDU = -1;  /* UL_DCCH_Message_NB */
static int hf_lte_rrc_HandoverPreparationInformation_v9j0_IEs_PDU = -1;  /* HandoverPreparationInformation_v9j0_IEs */
static int hf_lte_rrc_SCG_Config_v12i0b_IEs_PDU = -1;  /* SCG_Config_v12i0b_IEs */
static int hf_lte_rrc_MBMSInterestIndication_r11_PDU = -1;  /* MBMSInterestIndication_r11 */
static int hf_lte_rrc_UE_RadioPagingInfo_r12_PDU = -1;  /* UE_RadioPagingInfo_r12 */
static int hf_lte_rrc_SystemInformationBlockType1_v890_IEs_PDU = -1;  /* SystemInformationBlockType1_v890_IEs */
static int hf_lte_rrc_InDeviceCoexIndication_r11_PDU = -1;  /* InDeviceCoexIndication_r11 */
static int hf_lte_rrc_UEAssistanceInformation_r11_PDU = -1;  /* UEAssistanceInformation_r11 */
static int hf_lte_rrc_SidelinkUEInformation_r12_PDU = -1;  /* SidelinkUEInformation_r12 */
static int hf_lte_rrc_WLANConnectionStatusReport_r13_PDU = -1;  /* WLANConnectionStatusReport_r13 */
static int hf_lte_rrc_SystemInformationBlockType1_PDU = -1;  /* SystemInformationBlockType1 */
static int hf_lte_rrc_RRCConnectionReconfiguration_v8m0_IEs_PDU = -1;  /* RRCConnectionReconfiguration_v8m0_IEs */
static int hf_lte_rrc_SystemInformationBlockType2_PDU = -1;  /* SystemInformationBlockType2 */
static int hf_lte_rrc_RRCConnectionRelease_v9e0_IEs_PDU = -1;  /* RRCConnectionRelease_v9e0_IEs */
static int hf_lte_rrc_SCGFailureInformation_v12d0b_IEs_PDU = -1;  /* SCGFailureInformation_v12d0b_IEs */
static int hf_lte_rrc_SystemInformationBlockType1_v8h0_IEs_PDU = -1;  /* SystemInformationBlockType1_v8h0_IEs */
static int hf_lte_rrc_UEInformationResponse_v9e0_IEs_PDU = -1;  /* UEInformationResponse_v9e0_IEs */
static int hf_lte_rrc_SystemInformationBlockType2_v8h0_IEs_PDU = -1;  /* SystemInformationBlockType2_v8h0_IEs */
static int hf_lte_rrc_SystemInformationBlockType2_v10m0_IEs_PDU = -1;  /* SystemInformationBlockType2_v10m0_IEs */
static int hf_lte_rrc_SystemInformationBlockType3_v10j0_IEs_PDU = -1;  /* SystemInformationBlockType3_v10j0_IEs */
static int hf_lte_rrc_SystemInformationBlockType5_v8h0_IEs_PDU = -1;  /* SystemInformationBlockType5_v8h0_IEs */
static int hf_lte_rrc_SystemInformationBlockType6_v8h0_IEs_PDU = -1;  /* SystemInformationBlockType6_v8h0_IEs */
static int hf_lte_rrc_UE_EUTRA_Capability_v10j0_IEs_PDU = -1;  /* UE_EUTRA_Capability_v10j0_IEs */
static int hf_lte_rrc_UE_EUTRA_Capability_v13e0b_IEs_PDU = -1;  /* UE_EUTRA_Capability_v13e0b_IEs */
static int hf_lte_rrc_UE_EUTRA_Capability_v9a0_IEs_PDU = -1;  /* UE_EUTRA_Capability_v9a0_IEs */
static int hf_lte_rrc_UE_Capability_NB_Ext_r14_IEs_PDU = -1;  /* UE_Capability_NB_Ext_r14_IEs */
static int hf_lte_rrc_UE_Capability_NB_r13_PDU = -1;  /* UE_Capability_NB_r13 */
static int hf_lte_rrc_UECapabilityInformation_NB_PDU = -1;  /* UECapabilityInformation_NB */
static int hf_lte_rrc_UE_RadioPagingInfo_NB_r13_PDU = -1;  /* UE_RadioPagingInfo_NB_r13 */
static int hf_lte_rrc_criticalExtensions = -1;    /* T_criticalExtensions */
static int hf_lte_rrc_c1 = -1;                    /* T_c1 */
static int hf_lte_rrc_handoverCommand_r8 = -1;    /* HandoverCommand_r8_IEs */
static int hf_lte_rrc_spare7 = -1;                /* NULL */
static int hf_lte_rrc_spare6 = -1;                /* NULL */
static int hf_lte_rrc_spare5 = -1;                /* NULL */
static int hf_lte_rrc_spare4 = -1;                /* NULL */
static int hf_lte_rrc_spare3 = -1;                /* NULL */
static int hf_lte_rrc_spare2 = -1;                /* NULL */
static int hf_lte_rrc_spare1 = -1;                /* NULL */
static int hf_lte_rrc_criticalExtensionsFuture = -1;  /* T_criticalExtensionsFuture */
static int hf_lte_rrc_handoverCommandMessage = -1;  /* T_handoverCommandMessage */
static int hf_lte_rrc_nonCriticalExtension = -1;  /* T_nonCriticalExtension */
static int hf_lte_rrc_criticalExtensions_01 = -1;  /* T_criticalExtensions_01 */
static int hf_lte_rrc_c1_01 = -1;                 /* T_c1_01 */
static int hf_lte_rrc_handoverPreparationInformation_r8 = -1;  /* HandoverPreparationInformation_r8_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_01 = -1;  /* T_criticalExtensionsFuture_01 */
static int hf_lte_rrc_ue_RadioAccessCapabilityInfo = -1;  /* UE_CapabilityRAT_ContainerList */
static int hf_lte_rrc_as_Config = -1;             /* AS_Config */
static int hf_lte_rrc_rrm_Config = -1;            /* RRM_Config */
static int hf_lte_rrc_as_Context = -1;            /* AS_Context */
static int hf_lte_rrc_nonCriticalExtension_01 = -1;  /* HandoverPreparationInformation_v920_IEs */
static int hf_lte_rrc_ue_ConfigRelease_r9 = -1;   /* T_ue_ConfigRelease_r9 */
static int hf_lte_rrc_nonCriticalExtension_02 = -1;  /* HandoverPreparationInformation_v9d0_IEs */
static int hf_lte_rrc_lateNonCriticalExtension = -1;  /* T_lateNonCriticalExtension */
static int hf_lte_rrc_nonCriticalExtension_03 = -1;  /* HandoverPreparationInformation_v9e0_IEs */
static int hf_lte_rrc_lateNonCriticalExtension_01 = -1;  /* OCTET_STRING */
static int hf_lte_rrc_nonCriticalExtension_04 = -1;  /* HandoverPreparationInformation_v10j0_IEs */
static int hf_lte_rrc_as_Config_v10j0 = -1;       /* AS_Config_v10j0 */
static int hf_lte_rrc_nonCriticalExtension_05 = -1;  /* HandoverPreparationInformation_v10x0_IEs */
static int hf_lte_rrc_nonCriticalExtension_06 = -1;  /* HandoverPreparationInformation_v13c0_IEs */
static int hf_lte_rrc_as_Config_v13c0 = -1;       /* AS_Config_v13c0 */
static int hf_lte_rrc_nonCriticalExtension_07 = -1;  /* T_nonCriticalExtension_01 */
static int hf_lte_rrc_as_Config_v9e0 = -1;        /* AS_Config_v9e0 */
static int hf_lte_rrc_nonCriticalExtension_08 = -1;  /* HandoverPreparationInformation_v1130_IEs */
static int hf_lte_rrc_as_Context_v1130 = -1;      /* AS_Context_v1130 */
static int hf_lte_rrc_nonCriticalExtension_09 = -1;  /* HandoverPreparationInformation_v1250_IEs */
static int hf_lte_rrc_ue_SupportedEARFCN_r12 = -1;  /* ARFCN_ValueEUTRA_r9 */
static int hf_lte_rrc_as_Config_v1250 = -1;       /* AS_Config_v1250 */
static int hf_lte_rrc_nonCriticalExtension_10 = -1;  /* HandoverPreparationInformation_v1320_IEs */
static int hf_lte_rrc_as_Config_v1320 = -1;       /* AS_Config_v1320 */
static int hf_lte_rrc_as_Context_v1320 = -1;      /* AS_Context_v1320 */
static int hf_lte_rrc_nonCriticalExtension_11 = -1;  /* HandoverPreparationInformation_v1430_IEs */
static int hf_lte_rrc_as_Config_v1430 = -1;       /* AS_Config_v1430 */
static int hf_lte_rrc_makeBeforeBreakReq_r14 = -1;  /* T_makeBeforeBreakReq_r14 */
static int hf_lte_rrc_nonCriticalExtension_12 = -1;  /* HandoverPreparationInformation_v1530_IEs */
static int hf_lte_rrc_ran_NotificationAreaInfo_r15 = -1;  /* RAN_NotificationAreaInfo_r15 */
static int hf_lte_rrc_nonCriticalExtension_13 = -1;  /* HandoverPreparationInformation_v1540_IEs */
static int hf_lte_rrc_sourceRB_ConfigIntra5GC_r15 = -1;  /* T_sourceRB_ConfigIntra5GC_r15 */
static int hf_lte_rrc_nonCriticalExtension_14 = -1;  /* T_nonCriticalExtension_02 */
static int hf_lte_rrc_criticalExtensions_02 = -1;  /* T_criticalExtensions_02 */
static int hf_lte_rrc_c1_02 = -1;                 /* T_c1_02 */
static int hf_lte_rrc_scg_Config_r12 = -1;        /* SCG_Config_r12_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_02 = -1;  /* T_criticalExtensionsFuture_02 */
static int hf_lte_rrc_scg_RadioConfig_r12 = -1;   /* SCG_ConfigPartSCG_r12 */
static int hf_lte_rrc_nonCriticalExtension_15 = -1;  /* SCG_Config_v12i0a_IEs */
static int hf_lte_rrc_lateNonCriticalExtension_02 = -1;  /* T_lateNonCriticalExtension_01 */
static int hf_lte_rrc_nonCriticalExtension_16 = -1;  /* SCG_Config_v13c0_IEs */
static int hf_lte_rrc_scg_RadioConfig_v12i0 = -1;  /* SCG_ConfigPartSCG_v12f0 */
static int hf_lte_rrc_nonCriticalExtension_17 = -1;  /* T_nonCriticalExtension_03 */
static int hf_lte_rrc_scg_RadioConfig_v13c0 = -1;  /* SCG_ConfigPartSCG_v13c0 */
static int hf_lte_rrc_nonCriticalExtension_18 = -1;  /* T_nonCriticalExtension_04 */
static int hf_lte_rrc_criticalExtensions_03 = -1;  /* T_criticalExtensions_03 */
static int hf_lte_rrc_c1_03 = -1;                 /* T_c1_03 */
static int hf_lte_rrc_scg_ConfigInfo_r12 = -1;    /* SCG_ConfigInfo_r12_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_03 = -1;  /* T_criticalExtensionsFuture_03 */
static int hf_lte_rrc_radioResourceConfigDedMCG_r12 = -1;  /* RadioResourceConfigDedicated */
static int hf_lte_rrc_sCellToAddModListMCG_r12 = -1;  /* SCellToAddModList_r10 */
static int hf_lte_rrc_measGapConfig_r12 = -1;     /* MeasGapConfig */
static int hf_lte_rrc_powerCoordinationInfo_r12 = -1;  /* PowerCoordinationInfo_r12 */
static int hf_lte_rrc_eutra_CapabilityInfo_r12 = -1;  /* T_eutra_CapabilityInfo_r12 */
static int hf_lte_rrc_scg_ConfigRestrictInfo_r12 = -1;  /* SCG_ConfigRestrictInfo_r12 */
static int hf_lte_rrc_mbmsInterestIndication_r12 = -1;  /* T_mbmsInterestIndication_r12 */
static int hf_lte_rrc_measResultServCellListSCG_r12 = -1;  /* MeasResultServCellListSCG_r12 */
static int hf_lte_rrc_drb_ToAddModListSCG_r12 = -1;  /* DRB_InfoListSCG_r12 */
static int hf_lte_rrc_drb_ToReleaseListSCG_r12 = -1;  /* DRB_ToReleaseList */
static int hf_lte_rrc_sCellToAddModListSCG_r12 = -1;  /* SCellToAddModListSCG_r12 */
static int hf_lte_rrc_sCellToReleaseListSCG_r12 = -1;  /* SCellToReleaseList_r10 */
static int hf_lte_rrc_p_Max_r12 = -1;             /* P_Max */
static int hf_lte_rrc_nonCriticalExtension_19 = -1;  /* SCG_ConfigInfo_v1310_IEs */
static int hf_lte_rrc_measResultSSTD_r13 = -1;    /* MeasResultSSTD_r13 */
static int hf_lte_rrc_sCellToAddModListMCG_Ext_r13 = -1;  /* SCellToAddModListExt_r13 */
static int hf_lte_rrc_measResultServCellListSCG_Ext_r13 = -1;  /* MeasResultServCellListSCG_Ext_r13 */
static int hf_lte_rrc_sCellToAddModListSCG_Ext_r13 = -1;  /* SCellToAddModListSCG_Ext_r13 */
static int hf_lte_rrc_sCellToReleaseListSCG_Ext_r13 = -1;  /* SCellToReleaseListExt_r13 */
static int hf_lte_rrc_nonCriticalExtension_20 = -1;  /* SCG_ConfigInfo_v1330_IEs */
static int hf_lte_rrc_measResultListRSSI_SCG_r13 = -1;  /* MeasResultListRSSI_SCG_r13 */
static int hf_lte_rrc_nonCriticalExtension_21 = -1;  /* SCG_ConfigInfo_v1430_IEs */
static int hf_lte_rrc_makeBeforeBreakSCG_Req_r14 = -1;  /* T_makeBeforeBreakSCG_Req_r14 */
static int hf_lte_rrc_measGapConfigPerCC_List = -1;  /* MeasGapConfigPerCC_List_r14 */
static int hf_lte_rrc_nonCriticalExtension_22 = -1;  /* SCG_ConfigInfo_v1530_IEs */
static int hf_lte_rrc_drb_ToAddModListSCG_r15 = -1;  /* DRB_InfoListSCG_r15 */
static int hf_lte_rrc_drb_ToReleaseListSCG_r15 = -1;  /* DRB_ToReleaseList_r15 */
static int hf_lte_rrc_nonCriticalExtension_23 = -1;  /* T_nonCriticalExtension_05 */
static int hf_lte_rrc_DRB_InfoListSCG_r12_item = -1;  /* DRB_InfoSCG_r12 */
static int hf_lte_rrc_DRB_InfoListSCG_r15_item = -1;  /* DRB_InfoSCG_r12 */
static int hf_lte_rrc_eps_BearerIdentity_r12 = -1;  /* INTEGER_0_15 */
static int hf_lte_rrc_drb_Identity_r12 = -1;      /* DRB_Identity */
static int hf_lte_rrc_drb_Type_r12 = -1;          /* T_drb_Type_r12 */
static int hf_lte_rrc_SCellToAddModListSCG_r12_item = -1;  /* Cell_ToAddMod_r12 */
static int hf_lte_rrc_SCellToAddModListSCG_Ext_r13_item = -1;  /* Cell_ToAddMod_r12 */
static int hf_lte_rrc_sCellIndex_r12 = -1;        /* SCellIndex_r10 */
static int hf_lte_rrc_cellIdentification_r12 = -1;  /* T_cellIdentification_r12 */
static int hf_lte_rrc_physCellId_r12 = -1;        /* PhysCellId */
static int hf_lte_rrc_dl_CarrierFreq_r12 = -1;    /* ARFCN_ValueEUTRA_r9 */
static int hf_lte_rrc_measResultCellToAdd_r12 = -1;  /* T_measResultCellToAdd_r12 */
static int hf_lte_rrc_rsrpResult_r12 = -1;        /* RSRP_Range */
static int hf_lte_rrc_rsrqResult_r12 = -1;        /* RSRQ_Range */
static int hf_lte_rrc_sCellIndex_r13 = -1;        /* SCellIndex_r13 */
static int hf_lte_rrc_measResultCellToAdd_v1310 = -1;  /* T_measResultCellToAdd_v1310 */
static int hf_lte_rrc_rs_sinr_Result_r13 = -1;    /* RS_SINR_Range_r13 */
static int hf_lte_rrc_MeasResultServCellListSCG_r12_item = -1;  /* MeasResultServCellSCG_r12 */
static int hf_lte_rrc_MeasResultServCellListSCG_Ext_r13_item = -1;  /* MeasResultServCellSCG_r12 */
static int hf_lte_rrc_servCellId_r12 = -1;        /* ServCellIndex_r10 */
static int hf_lte_rrc_measResultSCell_r12 = -1;   /* T_measResultSCell_r12 */
static int hf_lte_rrc_rsrpResultSCell_r12 = -1;   /* RSRP_Range */
static int hf_lte_rrc_rsrqResultSCell_r12 = -1;   /* RSRQ_Range */
static int hf_lte_rrc_servCellId_r13 = -1;        /* ServCellIndex_r13 */
static int hf_lte_rrc_measResultSCell_v1310 = -1;  /* T_measResultSCell_v1310 */
static int hf_lte_rrc_rs_sinr_ResultSCell_r13 = -1;  /* RS_SINR_Range_r13 */
static int hf_lte_rrc_MeasResultListRSSI_SCG_r13_item = -1;  /* MeasResultRSSI_SCG_r13 */
static int hf_lte_rrc_measResultForRSSI_r13 = -1;  /* MeasResultForRSSI_r13 */
static int hf_lte_rrc_maxSCH_TB_BitsDL_r12 = -1;  /* INTEGER_1_100 */
static int hf_lte_rrc_maxSCH_TB_BitsUL_r12 = -1;  /* INTEGER_1_100 */
static int hf_lte_rrc_criticalExtensions_04 = -1;  /* T_criticalExtensions_04 */
static int hf_lte_rrc_c1_04 = -1;                 /* T_c1_04 */
static int hf_lte_rrc_uePagingCoverageInformation_r13 = -1;  /* UEPagingCoverageInformation_r13_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_04 = -1;  /* T_criticalExtensionsFuture_04 */
static int hf_lte_rrc_mpdcch_NumRepetition_r13 = -1;  /* INTEGER_1_256 */
static int hf_lte_rrc_nonCriticalExtension_24 = -1;  /* T_nonCriticalExtension_06 */
static int hf_lte_rrc_criticalExtensions_05 = -1;  /* T_criticalExtensions_05 */
static int hf_lte_rrc_c1_05 = -1;                 /* T_c1_05 */
static int hf_lte_rrc_ueRadioAccessCapabilityInformation_r8 = -1;  /* UERadioAccessCapabilityInformation_r8_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_05 = -1;  /* T_criticalExtensionsFuture_05 */
static int hf_lte_rrc_ue_RadioAccessCapabilityInfo_01 = -1;  /* T_ue_RadioAccessCapabilityInfo */
static int hf_lte_rrc_nonCriticalExtension_25 = -1;  /* T_nonCriticalExtension_07 */
static int hf_lte_rrc_criticalExtensions_06 = -1;  /* T_criticalExtensions_06 */
static int hf_lte_rrc_c1_06 = -1;                 /* T_c1_06 */
static int hf_lte_rrc_ueRadioPagingInformation_r12 = -1;  /* UERadioPagingInformation_r12_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_06 = -1;  /* T_criticalExtensionsFuture_06 */
static int hf_lte_rrc_ue_RadioPagingInfo_r12 = -1;  /* T_ue_RadioPagingInfo_r12 */
static int hf_lte_rrc_nonCriticalExtension_26 = -1;  /* UERadioPagingInformation_v1310_IEs */
static int hf_lte_rrc_supportedBandListEUTRAForPaging_r13 = -1;  /* SEQUENCE_SIZE_1_maxBands_OF_FreqBandIndicator_r11 */
static int hf_lte_rrc_supportedBandListEUTRAForPaging_r13_item = -1;  /* FreqBandIndicator_r11 */
static int hf_lte_rrc_nonCriticalExtension_27 = -1;  /* T_nonCriticalExtension_08 */
static int hf_lte_rrc_sourceMeasConfig = -1;      /* MeasConfig */
static int hf_lte_rrc_sourceRadioResourceConfig = -1;  /* RadioResourceConfigDedicated */
static int hf_lte_rrc_sourceSecurityAlgorithmConfig = -1;  /* SecurityAlgorithmConfig */
static int hf_lte_rrc_sourceUE_Identity = -1;     /* C_RNTI */
static int hf_lte_rrc_sourceMasterInformationBlock = -1;  /* MasterInformationBlock */
static int hf_lte_rrc_sourceSystemInformationBlockType1 = -1;  /* SystemInformationBlockType1 */
static int hf_lte_rrc_sourceSystemInformationBlockType2 = -1;  /* SystemInformationBlockType2 */
static int hf_lte_rrc_antennaInfoCommon = -1;     /* AntennaInfoCommon */
static int hf_lte_rrc_sourceDl_CarrierFreq = -1;  /* ARFCN_ValueEUTRA */
static int hf_lte_rrc_sourceSystemInformationBlockType1Ext = -1;  /* T_sourceSystemInformationBlockType1Ext */
static int hf_lte_rrc_sourceOtherConfig_r9 = -1;  /* OtherConfig_r9 */
static int hf_lte_rrc_sourceSCellConfigList_r10 = -1;  /* SCellToAddModList_r10 */
static int hf_lte_rrc_sourceConfigSCG_r12 = -1;   /* SCG_Config_r12 */
static int hf_lte_rrc_as_ConfigNR_r15 = -1;       /* AS_ConfigNR_r15 */
static int hf_lte_rrc_as_Config_v1550 = -1;       /* AS_Config_v1550 */
static int hf_lte_rrc_as_ConfigNR_v1570 = -1;     /* AS_ConfigNR_v1570 */
static int hf_lte_rrc_sourceDl_CarrierFreq_v9e0 = -1;  /* ARFCN_ValueEUTRA_v9e0 */
static int hf_lte_rrc_antennaInfoDedicatedPCell_v10i0 = -1;  /* AntennaInfoDedicated_v10i0 */
static int hf_lte_rrc_sourceWlan_OffloadConfig_r12 = -1;  /* WLAN_OffloadConfig_r12 */
static int hf_lte_rrc_sourceSL_CommConfig_r12 = -1;  /* SL_CommConfig_r12 */
static int hf_lte_rrc_sourceSL_DiscConfig_r12 = -1;  /* SL_DiscConfig_r12 */
static int hf_lte_rrc_sourceSCellConfigList_r13 = -1;  /* SCellToAddModListExt_r13 */
static int hf_lte_rrc_sourceRCLWI_Configuration_r13 = -1;  /* RCLWI_Configuration_r13 */
static int hf_lte_rrc_radioResourceConfigDedicated_v13c01 = -1;  /* RadioResourceConfigDedicated_v1370 */
static int hf_lte_rrc_radioResourceConfigDedicated_v13c02 = -1;  /* RadioResourceConfigDedicated_v13c0 */
static int hf_lte_rrc_sCellToAddModList_v13c0 = -1;  /* SCellToAddModList_v13c0 */
static int hf_lte_rrc_sCellToAddModListExt_v13c0 = -1;  /* SCellToAddModListExt_v13c0 */
static int hf_lte_rrc_sourceSL_V2X_CommConfig_r14 = -1;  /* SL_V2X_ConfigDedicated_r14 */
static int hf_lte_rrc_sourceLWA_Config_r14 = -1;  /* LWA_Config_r13 */
static int hf_lte_rrc_sourceWLAN_MeasResult_r14 = -1;  /* MeasResultListWLAN_r13 */
static int hf_lte_rrc_sourceRB_ConfigNR_r15 = -1;  /* T_sourceRB_ConfigNR_r15 */
static int hf_lte_rrc_sourceRB_ConfigSN_NR_r15 = -1;  /* T_sourceRB_ConfigSN_NR_r15 */
static int hf_lte_rrc_sourceOtherConfigSN_NR_r15 = -1;  /* T_sourceOtherConfigSN_NR_r15 */
static int hf_lte_rrc_sourceSCG_ConfiguredNR_r15 = -1;  /* T_sourceSCG_ConfiguredNR_r15 */
static int hf_lte_rrc_tdm_PatternConfig_r15 = -1;  /* T_tdm_PatternConfig_r15 */
static int hf_lte_rrc_subframeAssignment_r15 = -1;  /* SubframeAssignment_r15 */
static int hf_lte_rrc_harq_Offset_r15 = -1;       /* INTEGER_0_9 */
static int hf_lte_rrc_p_MaxEUTRA_r15 = -1;        /* P_Max */
static int hf_lte_rrc_reestablishmentInfo = -1;   /* ReestablishmentInfo */
static int hf_lte_rrc_idc_Indication_r11 = -1;    /* T_idc_Indication_r11 */
static int hf_lte_rrc_mbmsInterestIndication_r11 = -1;  /* T_mbmsInterestIndication_r11 */
static int hf_lte_rrc_powerPrefIndication_r11 = -1;  /* T_powerPrefIndication_r11 */
static int hf_lte_rrc_sidelinkUEInformation_r12 = -1;  /* T_sidelinkUEInformation_r12 */
static int hf_lte_rrc_sourceContextEN_DC_r15 = -1;  /* T_sourceContextEN_DC_r15 */
static int hf_lte_rrc_selectedbandCombinationInfoEN_DC_v1540 = -1;  /* T_selectedbandCombinationInfoEN_DC_v1540 */
static int hf_lte_rrc_wlanConnectionStatusReport_r13 = -1;  /* T_wlanConnectionStatusReport_r13 */
static int hf_lte_rrc_sourcePhysCellId = -1;      /* PhysCellId */
static int hf_lte_rrc_targetCellShortMAC_I = -1;  /* ShortMAC_I */
static int hf_lte_rrc_additionalReestabInfoList = -1;  /* AdditionalReestabInfoList */
static int hf_lte_rrc_AdditionalReestabInfoList_item = -1;  /* AdditionalReestabInfo */
static int hf_lte_rrc_cellIdentity = -1;          /* CellIdentity */
static int hf_lte_rrc_key_eNodeB_Star = -1;       /* Key_eNodeB_Star */
static int hf_lte_rrc_shortMAC_I = -1;            /* ShortMAC_I */
static int hf_lte_rrc_ue_InactiveTime = -1;       /* T_ue_InactiveTime */
static int hf_lte_rrc_candidateCellInfoList_r10 = -1;  /* CandidateCellInfoList_r10 */
static int hf_lte_rrc_candidateCellInfoListNR_r15 = -1;  /* MeasResultServFreqListNR_r15 */
static int hf_lte_rrc_CandidateCellInfoList_r10_item = -1;  /* CandidateCellInfo_r10 */
static int hf_lte_rrc_physCellId_r10 = -1;        /* PhysCellId */
static int hf_lte_rrc_dl_CarrierFreq_r10 = -1;    /* ARFCN_ValueEUTRA */
static int hf_lte_rrc_rsrpResult_r10 = -1;        /* RSRP_Range */
static int hf_lte_rrc_rsrqResult_r10 = -1;        /* RSRQ_Range */
static int hf_lte_rrc_dl_CarrierFreq_v1090 = -1;  /* ARFCN_ValueEUTRA_v9e0 */
static int hf_lte_rrc_rsrqResult_v1250 = -1;      /* RSRQ_Range_v1250 */
static int hf_lte_rrc_message = -1;               /* BCCH_BCH_MessageType */
static int hf_lte_rrc_message_01 = -1;            /* BCCH_BCH_MessageType_MBMS_r14 */
static int hf_lte_rrc_message_02 = -1;            /* BCCH_DL_SCH_MessageType */
static int hf_lte_rrc_c1_07 = -1;                 /* T_c1_07 */
static int hf_lte_rrc_systemInformation = -1;     /* SystemInformation */
static int hf_lte_rrc_systemInformationBlockType1 = -1;  /* SystemInformationBlockType1 */
static int hf_lte_rrc_messageClassExtension = -1;  /* T_messageClassExtension */
static int hf_lte_rrc_message_03 = -1;            /* BCCH_DL_SCH_MessageType_BR_r13 */
static int hf_lte_rrc_c1_08 = -1;                 /* T_c1_08 */
static int hf_lte_rrc_systemInformation_BR_r13 = -1;  /* SystemInformation_BR_r13 */
static int hf_lte_rrc_systemInformationBlockType1_BR_r13 = -1;  /* SystemInformationBlockType1_BR_r13 */
static int hf_lte_rrc_messageClassExtension_01 = -1;  /* T_messageClassExtension_01 */
static int hf_lte_rrc_message_04 = -1;            /* BCCH_DL_SCH_MessageType_MBMS_r14 */
static int hf_lte_rrc_c1_09 = -1;                 /* T_c1_09 */
static int hf_lte_rrc_systemInformation_MBMS_r14 = -1;  /* SystemInformation_MBMS_r14 */
static int hf_lte_rrc_systemInformationBlockType1_MBMS_r14 = -1;  /* SystemInformationBlockType1_MBMS_r14 */
static int hf_lte_rrc_messageClassExtension_02 = -1;  /* T_messageClassExtension_02 */
static int hf_lte_rrc_message_05 = -1;            /* MCCH_MessageType */
static int hf_lte_rrc_c1_10 = -1;                 /* T_c1_10 */
static int hf_lte_rrc_mbsfnAreaConfiguration_r9 = -1;  /* MBSFNAreaConfiguration_r9 */
static int hf_lte_rrc_later = -1;                 /* T_later */
static int hf_lte_rrc_c2 = -1;                    /* T_c2 */
static int hf_lte_rrc_mbmsCountingRequest_r10 = -1;  /* MBMSCountingRequest_r10 */
static int hf_lte_rrc_messageClassExtension_03 = -1;  /* T_messageClassExtension_03 */
static int hf_lte_rrc_message_06 = -1;            /* PCCH_MessageType */
static int hf_lte_rrc_c1_11 = -1;                 /* T_c1_11 */
static int hf_lte_rrc_paging = -1;                /* Paging */
static int hf_lte_rrc_messageClassExtension_04 = -1;  /* T_messageClassExtension_04 */
static int hf_lte_rrc_message_07 = -1;            /* DL_CCCH_MessageType */
static int hf_lte_rrc_c1_12 = -1;                 /* T_c1_12 */
static int hf_lte_rrc_rrcConnectionReestablishment = -1;  /* RRCConnectionReestablishment */
static int hf_lte_rrc_rrcConnectionReestablishmentReject = -1;  /* RRCConnectionReestablishmentReject */
static int hf_lte_rrc_rrcConnectionReject = -1;   /* RRCConnectionReject */
static int hf_lte_rrc_rrcConnectionSetup = -1;    /* RRCConnectionSetup */
static int hf_lte_rrc_messageClassExtension_05 = -1;  /* T_messageClassExtension_05 */
static int hf_lte_rrc_c2_01 = -1;                 /* T_c2_01 */
static int hf_lte_rrc_rrcEarlyDataComplete_r15 = -1;  /* RRCEarlyDataComplete_r15 */
static int hf_lte_rrc_messageClassExtensionFuture_r15 = -1;  /* T_messageClassExtensionFuture_r15 */
static int hf_lte_rrc_message_08 = -1;            /* DL_DCCH_MessageType */
static int hf_lte_rrc_c1_13 = -1;                 /* T_c1_13 */
static int hf_lte_rrc_csfbParametersResponseCDMA2000 = -1;  /* CSFBParametersResponseCDMA2000 */
static int hf_lte_rrc_dlInformationTransfer = -1;  /* DLInformationTransfer */
static int hf_lte_rrc_handoverFromEUTRAPreparationRequest = -1;  /* HandoverFromEUTRAPreparationRequest */
static int hf_lte_rrc_mobilityFromEUTRACommand = -1;  /* MobilityFromEUTRACommand */
static int hf_lte_rrc_rrcConnectionReconfiguration = -1;  /* RRCConnectionReconfiguration */
static int hf_lte_rrc_rrcConnectionRelease = -1;  /* RRCConnectionRelease */
static int hf_lte_rrc_securityModeCommand = -1;   /* SecurityModeCommand */
static int hf_lte_rrc_ueCapabilityEnquiry = -1;   /* UECapabilityEnquiry */
static int hf_lte_rrc_counterCheck = -1;          /* CounterCheck */
static int hf_lte_rrc_ueInformationRequest_r9 = -1;  /* UEInformationRequest_r9 */
static int hf_lte_rrc_loggedMeasurementConfiguration_r10 = -1;  /* LoggedMeasurementConfiguration_r10 */
static int hf_lte_rrc_rnReconfiguration_r10 = -1;  /* RNReconfiguration_r10 */
static int hf_lte_rrc_rrcConnectionResume_r13 = -1;  /* RRCConnectionResume_r13 */
static int hf_lte_rrc_messageClassExtension_06 = -1;  /* T_messageClassExtension_06 */
static int hf_lte_rrc_message_09 = -1;            /* UL_CCCH_MessageType */
static int hf_lte_rrc_c1_14 = -1;                 /* T_c1_14 */
static int hf_lte_rrc_rrcConnectionReestablishmentRequest = -1;  /* RRCConnectionReestablishmentRequest */
static int hf_lte_rrc_rrcConnectionRequest = -1;  /* RRCConnectionRequest */
static int hf_lte_rrc_messageClassExtension_07 = -1;  /* T_messageClassExtension_07 */
static int hf_lte_rrc_c2_02 = -1;                 /* T_c2_02 */
static int hf_lte_rrc_rrcConnectionResumeRequest_r13 = -1;  /* RRCConnectionResumeRequest_r13 */
static int hf_lte_rrc_messageClassExtensionFuture_r13 = -1;  /* T_messageClassExtensionFuture_r13 */
static int hf_lte_rrc_c3 = -1;                    /* T_c3 */
static int hf_lte_rrc_rrcEarlyDataRequest_r15 = -1;  /* RRCEarlyDataRequest_r15 */
static int hf_lte_rrc_messageClassExtensionFuture_r15_01 = -1;  /* T_messageClassExtensionFuture_r15_01 */
static int hf_lte_rrc_message_10 = -1;            /* UL_DCCH_MessageType */
static int hf_lte_rrc_c1_15 = -1;                 /* T_c1_15 */
static int hf_lte_rrc_csfbParametersRequestCDMA2000 = -1;  /* CSFBParametersRequestCDMA2000 */
static int hf_lte_rrc_measurementReport = -1;     /* MeasurementReport */
static int hf_lte_rrc_rrcConnectionReconfigurationComplete = -1;  /* RRCConnectionReconfigurationComplete */
static int hf_lte_rrc_rrcConnectionReestablishmentComplete = -1;  /* RRCConnectionReestablishmentComplete */
static int hf_lte_rrc_rrcConnectionSetupComplete = -1;  /* RRCConnectionSetupComplete */
static int hf_lte_rrc_securityModeComplete = -1;  /* SecurityModeComplete */
static int hf_lte_rrc_securityModeFailure = -1;   /* SecurityModeFailure */
static int hf_lte_rrc_ueCapabilityInformation = -1;  /* UECapabilityInformation */
static int hf_lte_rrc_ulHandoverPreparationTransfer = -1;  /* ULHandoverPreparationTransfer */
static int hf_lte_rrc_ulInformationTransfer = -1;  /* ULInformationTransfer */
static int hf_lte_rrc_counterCheckResponse = -1;  /* CounterCheckResponse */
static int hf_lte_rrc_ueInformationResponse_r9 = -1;  /* UEInformationResponse_r9 */
static int hf_lte_rrc_proximityIndication_r9 = -1;  /* ProximityIndication_r9 */
static int hf_lte_rrc_rnReconfigurationComplete_r10 = -1;  /* RNReconfigurationComplete_r10 */
static int hf_lte_rrc_mbmsCountingResponse_r10 = -1;  /* MBMSCountingResponse_r10 */
static int hf_lte_rrc_interFreqRSTDMeasurementIndication_r10 = -1;  /* InterFreqRSTDMeasurementIndication_r10 */
static int hf_lte_rrc_messageClassExtension_08 = -1;  /* T_messageClassExtension_08 */
static int hf_lte_rrc_c2_03 = -1;                 /* T_c2_03 */
static int hf_lte_rrc_ueAssistanceInformation_r11 = -1;  /* UEAssistanceInformation_r11 */
static int hf_lte_rrc_inDeviceCoexIndication_r11 = -1;  /* InDeviceCoexIndication_r11 */
static int hf_lte_rrc_mbmsInterestIndication_r11_01 = -1;  /* MBMSInterestIndication_r11 */
static int hf_lte_rrc_scgFailureInformation_r12 = -1;  /* SCGFailureInformation_r12 */
static int hf_lte_rrc_sidelinkUEInformation_r12_01 = -1;  /* SidelinkUEInformation_r12 */
static int hf_lte_rrc_wlanConnectionStatusReport_r13_01 = -1;  /* WLANConnectionStatusReport_r13 */
static int hf_lte_rrc_rrcConnectionResumeComplete_r13 = -1;  /* RRCConnectionResumeComplete_r13 */
static int hf_lte_rrc_ulInformationTransferMRDC_r15 = -1;  /* ULInformationTransferMRDC_r15 */
static int hf_lte_rrc_scgFailureInformationNR_r15 = -1;  /* SCGFailureInformationNR_r15 */
static int hf_lte_rrc_measReportAppLayer_r15 = -1;  /* MeasReportAppLayer_r15 */
static int hf_lte_rrc_failureInformation_r15 = -1;  /* FailureInformation_r15 */
static int hf_lte_rrc_messageClassExtensionFuture_r11 = -1;  /* T_messageClassExtensionFuture_r11 */
static int hf_lte_rrc_message_11 = -1;            /* SC_MCCH_MessageType_r13 */
static int hf_lte_rrc_c1_16 = -1;                 /* T_c1_16 */
static int hf_lte_rrc_scptmConfiguration_r13 = -1;  /* SCPTMConfiguration_r13 */
static int hf_lte_rrc_messageClassExtension_09 = -1;  /* T_messageClassExtension_09 */
static int hf_lte_rrc_c2_04 = -1;                 /* T_c2_04 */
static int hf_lte_rrc_scptmConfiguration_BR_r14 = -1;  /* SCPTMConfiguration_BR_r14 */
static int hf_lte_rrc_spare = -1;                 /* NULL */
static int hf_lte_rrc_messageClassExtensionFuture_r14 = -1;  /* T_messageClassExtensionFuture_r14 */
static int hf_lte_rrc_rrc_TransactionIdentifier = -1;  /* RRC_TransactionIdentifier */
static int hf_lte_rrc_criticalExtensions_07 = -1;  /* T_criticalExtensions_07 */
static int hf_lte_rrc_c1_17 = -1;                 /* T_c1_17 */
static int hf_lte_rrc_counterCheck_r8 = -1;       /* CounterCheck_r8_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_07 = -1;  /* T_criticalExtensionsFuture_07 */
static int hf_lte_rrc_drb_CountMSB_InfoList = -1;  /* DRB_CountMSB_InfoList */
static int hf_lte_rrc_nonCriticalExtension_28 = -1;  /* CounterCheck_v8a0_IEs */
static int hf_lte_rrc_nonCriticalExtension_29 = -1;  /* CounterCheck_v1530_IEs */
static int hf_lte_rrc_drb_CountMSB_InfoListExt_r15 = -1;  /* DRB_CountMSB_InfoListExt_r15 */
static int hf_lte_rrc_nonCriticalExtension_30 = -1;  /* T_nonCriticalExtension_09 */
static int hf_lte_rrc_DRB_CountMSB_InfoList_item = -1;  /* DRB_CountMSB_Info */
static int hf_lte_rrc_DRB_CountMSB_InfoListExt_r15_item = -1;  /* DRB_CountMSB_Info */
static int hf_lte_rrc_drb_Identity = -1;          /* DRB_Identity */
static int hf_lte_rrc_countMSB_Uplink = -1;       /* INTEGER_0_33554431 */
static int hf_lte_rrc_countMSB_Downlink = -1;     /* INTEGER_0_33554431 */
static int hf_lte_rrc_criticalExtensions_08 = -1;  /* T_criticalExtensions_08 */
static int hf_lte_rrc_counterCheckResponse_r8 = -1;  /* CounterCheckResponse_r8_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_08 = -1;  /* T_criticalExtensionsFuture_08 */
static int hf_lte_rrc_drb_CountInfoList = -1;     /* DRB_CountInfoList */
static int hf_lte_rrc_nonCriticalExtension_31 = -1;  /* CounterCheckResponse_v8a0_IEs */
static int hf_lte_rrc_nonCriticalExtension_32 = -1;  /* CounterCheckResponse_v1530_IEs */
static int hf_lte_rrc_drb_CountInfoListExt_r15 = -1;  /* DRB_CountInfoListExt_r15 */
static int hf_lte_rrc_nonCriticalExtension_33 = -1;  /* T_nonCriticalExtension_10 */
static int hf_lte_rrc_DRB_CountInfoList_item = -1;  /* DRB_CountInfo */
static int hf_lte_rrc_DRB_CountInfoListExt_r15_item = -1;  /* DRB_CountInfo */
static int hf_lte_rrc_count_Uplink = -1;          /* INTEGER_0_4294967295 */
static int hf_lte_rrc_count_Downlink = -1;        /* INTEGER_0_4294967295 */
static int hf_lte_rrc_criticalExtensions_09 = -1;  /* T_criticalExtensions_09 */
static int hf_lte_rrc_csfbParametersRequestCDMA2000_r8 = -1;  /* CSFBParametersRequestCDMA2000_r8_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_09 = -1;  /* T_criticalExtensionsFuture_09 */
static int hf_lte_rrc_nonCriticalExtension_34 = -1;  /* CSFBParametersRequestCDMA2000_v8a0_IEs */
static int hf_lte_rrc_nonCriticalExtension_35 = -1;  /* T_nonCriticalExtension_11 */
static int hf_lte_rrc_criticalExtensions_10 = -1;  /* T_criticalExtensions_10 */
static int hf_lte_rrc_csfbParametersResponseCDMA2000_r8 = -1;  /* CSFBParametersResponseCDMA2000_r8_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_10 = -1;  /* T_criticalExtensionsFuture_10 */
static int hf_lte_rrc_rand = -1;                  /* RAND_CDMA2000 */
static int hf_lte_rrc_mobilityParameters = -1;    /* MobilityParametersCDMA2000 */
static int hf_lte_rrc_nonCriticalExtension_36 = -1;  /* CSFBParametersResponseCDMA2000_v8a0_IEs */
static int hf_lte_rrc_nonCriticalExtension_37 = -1;  /* T_nonCriticalExtension_12 */
static int hf_lte_rrc_criticalExtensions_11 = -1;  /* T_criticalExtensions_11 */
static int hf_lte_rrc_c1_18 = -1;                 /* T_c1_18 */
static int hf_lte_rrc_dlInformationTransfer_r8 = -1;  /* DLInformationTransfer_r8_IEs */
static int hf_lte_rrc_dlInformationTransfer_r15 = -1;  /* DLInformationTransfer_r15_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_11 = -1;  /* T_criticalExtensionsFuture_11 */
static int hf_lte_rrc_dedicatedInfoType = -1;     /* T_dedicatedInfoType */
static int hf_lte_rrc_dedicatedInfoNAS = -1;      /* DedicatedInfoNAS */
static int hf_lte_rrc_dedicatedInfoCDMA2000_1XRTT = -1;  /* DedicatedInfoCDMA2000 */
static int hf_lte_rrc_dedicatedInfoCDMA2000_HRPD = -1;  /* DedicatedInfoCDMA2000 */
static int hf_lte_rrc_nonCriticalExtension_38 = -1;  /* DLInformationTransfer_v8a0_IEs */
static int hf_lte_rrc_nonCriticalExtension_39 = -1;  /* T_nonCriticalExtension_13 */
static int hf_lte_rrc_dedicatedInfoType_r15 = -1;  /* T_dedicatedInfoType_r15 */
static int hf_lte_rrc_dedicatedInfoNAS_r15 = -1;  /* DedicatedInfoNAS */
static int hf_lte_rrc_dedicatedInfoCDMA2000_1XRTT_r15 = -1;  /* DedicatedInfoCDMA2000 */
static int hf_lte_rrc_dedicatedInfoCDMA2000_HRPD_r15 = -1;  /* DedicatedInfoCDMA2000 */
static int hf_lte_rrc_timeReferenceInfo_r15 = -1;  /* TimeReferenceInfo_r15 */
static int hf_lte_rrc_failedLogicalChannelInfo_r15 = -1;  /* FailedLogicalChannelInfo_r15 */
static int hf_lte_rrc_failedLogicalChannelIdentity_r15 = -1;  /* T_failedLogicalChannelIdentity_r15 */
static int hf_lte_rrc_cellGroupIndication_r15 = -1;  /* T_cellGroupIndication_r15 */
static int hf_lte_rrc_logicalChannelIdentity_r15 = -1;  /* INTEGER_1_10 */
static int hf_lte_rrc_logicalChannelIdentityExt_r15 = -1;  /* INTEGER_32_38 */
static int hf_lte_rrc_failureType = -1;           /* T_failureType */
static int hf_lte_rrc_criticalExtensions_12 = -1;  /* T_criticalExtensions_12 */
static int hf_lte_rrc_c1_19 = -1;                 /* T_c1_19 */
static int hf_lte_rrc_handoverFromEUTRAPreparationRequest_r8 = -1;  /* HandoverFromEUTRAPreparationRequest_r8_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_12 = -1;  /* T_criticalExtensionsFuture_12 */
static int hf_lte_rrc_cdma2000_Type = -1;         /* CDMA2000_Type */
static int hf_lte_rrc_nonCriticalExtension_40 = -1;  /* HandoverFromEUTRAPreparationRequest_v890_IEs */
static int hf_lte_rrc_nonCriticalExtension_41 = -1;  /* HandoverFromEUTRAPreparationRequest_v920_IEs */
static int hf_lte_rrc_concurrPrepCDMA2000_HRPD_r9 = -1;  /* BOOLEAN */
static int hf_lte_rrc_nonCriticalExtension_42 = -1;  /* HandoverFromEUTRAPreparationRequest_v1020_IEs */
static int hf_lte_rrc_dualRxTxRedirectIndicator_r10 = -1;  /* T_dualRxTxRedirectIndicator_r10 */
static int hf_lte_rrc_redirectCarrierCDMA2000_1XRTT_r10 = -1;  /* CarrierFreqCDMA2000 */
static int hf_lte_rrc_nonCriticalExtension_43 = -1;  /* T_nonCriticalExtension_14 */
static int hf_lte_rrc_criticalExtensions_13 = -1;  /* T_criticalExtensions_13 */
static int hf_lte_rrc_c1_20 = -1;                 /* T_c1_20 */
static int hf_lte_rrc_inDeviceCoexIndication_r11_01 = -1;  /* InDeviceCoexIndication_r11_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_13 = -1;  /* T_criticalExtensionsFuture_13 */
static int hf_lte_rrc_affectedCarrierFreqList_r11 = -1;  /* AffectedCarrierFreqList_r11 */
static int hf_lte_rrc_tdm_AssistanceInfo_r11 = -1;  /* TDM_AssistanceInfo_r11 */
static int hf_lte_rrc_nonCriticalExtension_44 = -1;  /* InDeviceCoexIndication_v11d0_IEs */
static int hf_lte_rrc_ul_CA_AssistanceInfo_r11 = -1;  /* T_ul_CA_AssistanceInfo_r11 */
static int hf_lte_rrc_affectedCarrierFreqCombList_r11 = -1;  /* AffectedCarrierFreqCombList_r11 */
static int hf_lte_rrc_victimSystemType_r11 = -1;  /* VictimSystemType_r11 */
static int hf_lte_rrc_nonCriticalExtension_45 = -1;  /* InDeviceCoexIndication_v1310_IEs */
static int hf_lte_rrc_affectedCarrierFreqList_v1310 = -1;  /* AffectedCarrierFreqList_v1310 */
static int hf_lte_rrc_affectedCarrierFreqCombList_r13 = -1;  /* AffectedCarrierFreqCombList_r13 */
static int hf_lte_rrc_nonCriticalExtension_46 = -1;  /* InDeviceCoexIndication_v1360_IEs */
static int hf_lte_rrc_hardwareSharingProblem_r13 = -1;  /* T_hardwareSharingProblem_r13 */
static int hf_lte_rrc_nonCriticalExtension_47 = -1;  /* InDeviceCoexIndication_v1530_IEs */
static int hf_lte_rrc_mrdc_AssistanceInfo_r15 = -1;  /* MRDC_AssistanceInfo_r15 */
static int hf_lte_rrc_nonCriticalExtension_48 = -1;  /* T_nonCriticalExtension_15 */
static int hf_lte_rrc_AffectedCarrierFreqList_r11_item = -1;  /* AffectedCarrierFreq_r11 */
static int hf_lte_rrc_AffectedCarrierFreqList_v1310_item = -1;  /* AffectedCarrierFreq_v1310 */
static int hf_lte_rrc_carrierFreq_r11 = -1;       /* MeasObjectId */
static int hf_lte_rrc_interferenceDirection_r11 = -1;  /* T_interferenceDirection_r11 */
static int hf_lte_rrc_carrierFreq_v1310 = -1;     /* MeasObjectId_v1310 */
static int hf_lte_rrc_AffectedCarrierFreqCombList_r11_item = -1;  /* AffectedCarrierFreqComb_r11 */
static int hf_lte_rrc_AffectedCarrierFreqCombList_r13_item = -1;  /* AffectedCarrierFreqComb_r13 */
static int hf_lte_rrc_AffectedCarrierFreqComb_r11_item = -1;  /* MeasObjectId */
static int hf_lte_rrc_AffectedCarrierFreqComb_r13_item = -1;  /* MeasObjectId_r13 */
static int hf_lte_rrc_drx_AssistanceInfo_r11 = -1;  /* T_drx_AssistanceInfo_r11 */
static int hf_lte_rrc_drx_CycleLength_r11 = -1;   /* T_drx_CycleLength_r11 */
static int hf_lte_rrc_drx_Offset_r11 = -1;        /* INTEGER_0_255 */
static int hf_lte_rrc_drx_ActiveTime_r11 = -1;    /* T_drx_ActiveTime_r11 */
static int hf_lte_rrc_idc_SubframePatternList_r11 = -1;  /* IDC_SubframePatternList_r11 */
static int hf_lte_rrc_IDC_SubframePatternList_r11_item = -1;  /* IDC_SubframePattern_r11 */
static int hf_lte_rrc_subframePatternFDD_r11 = -1;  /* BIT_STRING_SIZE_4 */
static int hf_lte_rrc_subframePatternTDD_r11 = -1;  /* T_subframePatternTDD_r11 */
static int hf_lte_rrc_subframeConfig0_r11 = -1;   /* BIT_STRING_SIZE_70 */
static int hf_lte_rrc_subframeConfig1_5_r11 = -1;  /* BIT_STRING_SIZE_10 */
static int hf_lte_rrc_subframeConfig6_r11 = -1;   /* BIT_STRING_SIZE_60 */
static int hf_lte_rrc_gps_r11 = -1;               /* T_gps_r11 */
static int hf_lte_rrc_glonass_r11 = -1;           /* T_glonass_r11 */
static int hf_lte_rrc_bds_r11 = -1;               /* T_bds_r11 */
static int hf_lte_rrc_galileo_r11 = -1;           /* T_galileo_r11 */
static int hf_lte_rrc_wlan_r11 = -1;              /* T_wlan_r11 */
static int hf_lte_rrc_bluetooth_r11 = -1;         /* T_bluetooth_r11 */
static int hf_lte_rrc_affectedCarrierFreqCombInfoListMRDC_r15 = -1;  /* SEQUENCE_SIZE_1_maxCombIDC_r11_OF_AffectedCarrierFreqCombInfoMRDC_r15 */
static int hf_lte_rrc_affectedCarrierFreqCombInfoListMRDC_r15_item = -1;  /* AffectedCarrierFreqCombInfoMRDC_r15 */
static int hf_lte_rrc_victimSystemType_r15 = -1;  /* VictimSystemType_r11 */
static int hf_lte_rrc_interferenceDirectionMRDC_r15 = -1;  /* T_interferenceDirectionMRDC_r15 */
static int hf_lte_rrc_affectedCarrierFreqCombMRDC_r15 = -1;  /* T_affectedCarrierFreqCombMRDC_r15 */
static int hf_lte_rrc_affectedCarrierFreqCombEUTRA_r15 = -1;  /* AffectedCarrierFreqComb_r15 */
static int hf_lte_rrc_affectedCarrierFreqCombNR_r15 = -1;  /* AffectedCarrierFreqCombNR_r15 */
static int hf_lte_rrc_AffectedCarrierFreqComb_r15_item = -1;  /* MeasObjectId_r13 */
static int hf_lte_rrc_AffectedCarrierFreqCombNR_r15_item = -1;  /* ARFCN_ValueNR_r15 */
static int hf_lte_rrc_criticalExtensions_14 = -1;  /* T_criticalExtensions_14 */
static int hf_lte_rrc_c1_21 = -1;                 /* T_c1_21 */
static int hf_lte_rrc_interFreqRSTDMeasurementIndication_r10_01 = -1;  /* InterFreqRSTDMeasurementIndication_r10_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_14 = -1;  /* T_criticalExtensionsFuture_14 */
static int hf_lte_rrc_rstd_InterFreqIndication_r10 = -1;  /* T_rstd_InterFreqIndication_r10 */
static int hf_lte_rrc_start = -1;                 /* T_start */
static int hf_lte_rrc_rstd_InterFreqInfoList_r10 = -1;  /* RSTD_InterFreqInfoList_r10 */
static int hf_lte_rrc_stop = -1;                  /* NULL */
static int hf_lte_rrc_nonCriticalExtension_49 = -1;  /* T_nonCriticalExtension_16 */
static int hf_lte_rrc_RSTD_InterFreqInfoList_r10_item = -1;  /* RSTD_InterFreqInfo_r10 */
static int hf_lte_rrc_carrierFreq_r10 = -1;       /* ARFCN_ValueEUTRA */
static int hf_lte_rrc_measPRS_Offset_r10 = -1;    /* INTEGER_0_39 */
static int hf_lte_rrc_carrierFreq_v1090 = -1;     /* ARFCN_ValueEUTRA_v9e0 */
static int hf_lte_rrc_measPRS_Offset_r15 = -1;    /* T_measPRS_Offset_r15 */
static int hf_lte_rrc_rstd0_r15 = -1;             /* INTEGER_0_79 */
static int hf_lte_rrc_rstd1_r15 = -1;             /* INTEGER_0_159 */
static int hf_lte_rrc_rstd2_r15 = -1;             /* INTEGER_0_319 */
static int hf_lte_rrc_rstd3_r15 = -1;             /* INTEGER_0_639 */
static int hf_lte_rrc_rstd4_r15 = -1;             /* INTEGER_0_1279 */
static int hf_lte_rrc_rstd5_r15 = -1;             /* INTEGER_0_159 */
static int hf_lte_rrc_rstd6_r15 = -1;             /* INTEGER_0_319 */
static int hf_lte_rrc_rstd7_r15 = -1;             /* INTEGER_0_639 */
static int hf_lte_rrc_rstd8_r15 = -1;             /* INTEGER_0_1279 */
static int hf_lte_rrc_rstd9_r15 = -1;             /* INTEGER_0_319 */
static int hf_lte_rrc_rstd10_r15 = -1;            /* INTEGER_0_639 */
static int hf_lte_rrc_rstd11_r15 = -1;            /* INTEGER_0_1279 */
static int hf_lte_rrc_rstd12_r15 = -1;            /* INTEGER_0_319 */
static int hf_lte_rrc_rstd13_r15 = -1;            /* INTEGER_0_639 */
static int hf_lte_rrc_rstd14_r15 = -1;            /* INTEGER_0_1279 */
static int hf_lte_rrc_rstd15_r15 = -1;            /* INTEGER_0_639 */
static int hf_lte_rrc_rstd16_r15 = -1;            /* INTEGER_0_1279 */
static int hf_lte_rrc_rstd17_r15 = -1;            /* INTEGER_0_639 */
static int hf_lte_rrc_rstd18_r15 = -1;            /* INTEGER_0_1279 */
static int hf_lte_rrc_rstd19_r15 = -1;            /* INTEGER_0_639 */
static int hf_lte_rrc_rstd20_r15 = -1;            /* INTEGER_0_1279 */
static int hf_lte_rrc_criticalExtensions_15 = -1;  /* T_criticalExtensions_15 */
static int hf_lte_rrc_c1_22 = -1;                 /* T_c1_22 */
static int hf_lte_rrc_loggedMeasurementConfiguration_r10_01 = -1;  /* LoggedMeasurementConfiguration_r10_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_15 = -1;  /* T_criticalExtensionsFuture_15 */
static int hf_lte_rrc_traceReference_r10 = -1;    /* TraceReference_r10 */
static int hf_lte_rrc_traceRecordingSessionRef_r10 = -1;  /* OCTET_STRING_SIZE_2 */
static int hf_lte_rrc_tce_Id_r10 = -1;            /* OCTET_STRING_SIZE_1 */
static int hf_lte_rrc_absoluteTimeInfo_r10 = -1;  /* AbsoluteTimeInfo_r10 */
static int hf_lte_rrc_areaConfiguration_r10 = -1;  /* AreaConfiguration_r10 */
static int hf_lte_rrc_loggingDuration_r10 = -1;   /* LoggingDuration_r10 */
static int hf_lte_rrc_loggingInterval_r10 = -1;   /* LoggingInterval_r10 */
static int hf_lte_rrc_nonCriticalExtension_50 = -1;  /* LoggedMeasurementConfiguration_v1080_IEs */
static int hf_lte_rrc_lateNonCriticalExtension_r10 = -1;  /* OCTET_STRING */
static int hf_lte_rrc_nonCriticalExtension_51 = -1;  /* LoggedMeasurementConfiguration_v1130_IEs */
static int hf_lte_rrc_plmn_IdentityList_r11 = -1;  /* PLMN_IdentityList3_r11 */
static int hf_lte_rrc_areaConfiguration_v1130 = -1;  /* AreaConfiguration_v1130 */
static int hf_lte_rrc_nonCriticalExtension_52 = -1;  /* LoggedMeasurementConfiguration_v1250_IEs */
static int hf_lte_rrc_targetMBSFN_AreaList_r12 = -1;  /* TargetMBSFN_AreaList_r12 */
static int hf_lte_rrc_nonCriticalExtension_53 = -1;  /* LoggedMeasurementConfiguration_v1530_IEs */
static int hf_lte_rrc_bt_NameList_r15 = -1;       /* BT_NameList_r15 */
static int hf_lte_rrc_wlan_NameList_r15 = -1;     /* WLAN_NameList_r15 */
static int hf_lte_rrc_nonCriticalExtension_54 = -1;  /* T_nonCriticalExtension_17 */
static int hf_lte_rrc_TargetMBSFN_AreaList_r12_item = -1;  /* TargetMBSFN_Area_r12 */
static int hf_lte_rrc_mbsfn_AreaId_r12 = -1;      /* MBSFN_AreaId_r12 */
static int hf_lte_rrc_carrierFreq_r12 = -1;       /* ARFCN_ValueEUTRA_r9 */
static int hf_lte_rrc_dl_Bandwidth = -1;          /* T_dl_Bandwidth */
static int hf_lte_rrc_phich_Config = -1;          /* PHICH_Config */
static int hf_lte_rrc_systemFrameNumber = -1;     /* T_systemFrameNumber */
static int hf_lte_rrc_schedulingInfoSIB1_BR_r13 = -1;  /* INTEGER_0_31 */
static int hf_lte_rrc_systemInfoUnchanged_BR_r15 = -1;  /* BOOLEAN */
static int hf_lte_rrc_spare_01 = -1;              /* BIT_STRING_SIZE_4 */
static int hf_lte_rrc_dl_Bandwidth_MBMS_r14 = -1;  /* T_dl_Bandwidth_MBMS_r14 */
static int hf_lte_rrc_systemFrameNumber_r14 = -1;  /* BIT_STRING_SIZE_6 */
static int hf_lte_rrc_additionalNonMBSFNSubframes_r14 = -1;  /* INTEGER_0_3 */
static int hf_lte_rrc_spare_02 = -1;              /* BIT_STRING_SIZE_13 */
static int hf_lte_rrc_countingRequestList_r10 = -1;  /* CountingRequestList_r10 */
static int hf_lte_rrc_nonCriticalExtension_55 = -1;  /* T_nonCriticalExtension_18 */
static int hf_lte_rrc_CountingRequestList_r10_item = -1;  /* CountingRequestInfo_r10 */
static int hf_lte_rrc_tmgi_r10 = -1;              /* TMGI_r9 */
static int hf_lte_rrc_criticalExtensions_16 = -1;  /* T_criticalExtensions_16 */
static int hf_lte_rrc_c1_23 = -1;                 /* T_c1_23 */
static int hf_lte_rrc_countingResponse_r10 = -1;  /* MBMSCountingResponse_r10_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_16 = -1;  /* T_criticalExtensionsFuture_16 */
static int hf_lte_rrc_mbsfn_AreaIndex_r10 = -1;   /* INTEGER_0_maxMBSFN_Area_1 */
static int hf_lte_rrc_countingResponseList_r10 = -1;  /* CountingResponseList_r10 */
static int hf_lte_rrc_nonCriticalExtension_56 = -1;  /* T_nonCriticalExtension_19 */
static int hf_lte_rrc_CountingResponseList_r10_item = -1;  /* CountingResponseInfo_r10 */
static int hf_lte_rrc_countingResponseService_r10 = -1;  /* INTEGER_0_maxServiceCount_1 */
static int hf_lte_rrc_criticalExtensions_17 = -1;  /* T_criticalExtensions_17 */
static int hf_lte_rrc_c1_24 = -1;                 /* T_c1_24 */
static int hf_lte_rrc_interestIndication_r11 = -1;  /* MBMSInterestIndication_r11_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_17 = -1;  /* T_criticalExtensionsFuture_17 */
static int hf_lte_rrc_mbms_FreqList_r11 = -1;     /* CarrierFreqListMBMS_r11 */
static int hf_lte_rrc_mbms_Priority_r11 = -1;     /* T_mbms_Priority_r11 */
static int hf_lte_rrc_nonCriticalExtension_57 = -1;  /* MBMSInterestIndication_v1310_IEs */
static int hf_lte_rrc_mbms_Services_r13 = -1;     /* MBMS_ServiceList_r13 */
static int hf_lte_rrc_nonCriticalExtension_58 = -1;  /* MBMSInterestIndication_v1540_IEs */
static int hf_lte_rrc_mbms_ROM_InfoList_r15 = -1;  /* SEQUENCE_SIZE_1_maxMBMS_ServiceListPerUE_r13_OF_MBMS_ROM_Info_r15 */
static int hf_lte_rrc_mbms_ROM_InfoList_r15_item = -1;  /* MBMS_ROM_Info_r15 */
static int hf_lte_rrc_nonCriticalExtension_59 = -1;  /* T_nonCriticalExtension_20 */
static int hf_lte_rrc_mbms_ROM_Freq_r15 = -1;     /* ARFCN_ValueEUTRA_r9 */
static int hf_lte_rrc_mbms_ROM_SubcarrierSpacing_r15 = -1;  /* T_mbms_ROM_SubcarrierSpacing_r15 */
static int hf_lte_rrc_mbms_Bandwidth_r15 = -1;    /* T_mbms_Bandwidth_r15 */
static int hf_lte_rrc_commonSF_Alloc_r9 = -1;     /* CommonSF_AllocPatternList_r9 */
static int hf_lte_rrc_commonSF_AllocPeriod_r9 = -1;  /* T_commonSF_AllocPeriod_r9 */
static int hf_lte_rrc_pmch_InfoList_r9 = -1;      /* PMCH_InfoList_r9 */
static int hf_lte_rrc_nonCriticalExtension_60 = -1;  /* MBSFNAreaConfiguration_v930_IEs */
static int hf_lte_rrc_nonCriticalExtension_61 = -1;  /* MBSFNAreaConfiguration_v1250_IEs */
static int hf_lte_rrc_pmch_InfoListExt_r12 = -1;  /* PMCH_InfoListExt_r12 */
static int hf_lte_rrc_nonCriticalExtension_62 = -1;  /* MBSFNAreaConfiguration_v1430_IEs */
static int hf_lte_rrc_commonSF_Alloc_r14 = -1;    /* CommonSF_AllocPatternList_r14 */
static int hf_lte_rrc_nonCriticalExtension_63 = -1;  /* T_nonCriticalExtension_21 */
static int hf_lte_rrc_CommonSF_AllocPatternList_r9_item = -1;  /* MBSFN_SubframeConfig */
static int hf_lte_rrc_CommonSF_AllocPatternList_r14_item = -1;  /* MBSFN_SubframeConfig_v1430 */
static int hf_lte_rrc_criticalExtensions_18 = -1;  /* T_criticalExtensions_18 */
static int hf_lte_rrc_measReportAppLayer_r15_01 = -1;  /* MeasReportAppLayer_r15_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_18 = -1;  /* T_criticalExtensionsFuture_18 */
static int hf_lte_rrc_measReportAppLayerContainer_r15 = -1;  /* OCTET_STRING_SIZE_1_8000 */
static int hf_lte_rrc_serviceType = -1;           /* T_serviceType */
static int hf_lte_rrc_nonCriticalExtension_64 = -1;  /* T_nonCriticalExtension_22 */
static int hf_lte_rrc_criticalExtensions_19 = -1;  /* T_criticalExtensions_19 */
static int hf_lte_rrc_c1_25 = -1;                 /* T_c1_25 */
static int hf_lte_rrc_measurementReport_r8 = -1;  /* MeasurementReport_r8_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_19 = -1;  /* T_criticalExtensionsFuture_19 */
static int hf_lte_rrc_measResults = -1;           /* MeasResults */
static int hf_lte_rrc_nonCriticalExtension_65 = -1;  /* MeasurementReport_v8a0_IEs */
static int hf_lte_rrc_nonCriticalExtension_66 = -1;  /* T_nonCriticalExtension_23 */
static int hf_lte_rrc_criticalExtensions_20 = -1;  /* T_criticalExtensions_20 */
static int hf_lte_rrc_c1_26 = -1;                 /* T_c1_26 */
static int hf_lte_rrc_mobilityFromEUTRACommand_r8 = -1;  /* MobilityFromEUTRACommand_r8_IEs */
static int hf_lte_rrc_mobilityFromEUTRACommand_r9 = -1;  /* MobilityFromEUTRACommand_r9_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_20 = -1;  /* T_criticalExtensionsFuture_20 */
static int hf_lte_rrc_cs_FallbackIndicator = -1;  /* BOOLEAN */
static int hf_lte_rrc_purpose = -1;               /* T_purpose */
static int hf_lte_rrc_handover = -1;              /* Handover */
static int hf_lte_rrc_cellChangeOrder = -1;       /* CellChangeOrder */
static int hf_lte_rrc_nonCriticalExtension_67 = -1;  /* MobilityFromEUTRACommand_v8a0_IEs */
static int hf_lte_rrc_nonCriticalExtension_68 = -1;  /* MobilityFromEUTRACommand_v8d0_IEs */
static int hf_lte_rrc_bandIndicator = -1;         /* BandIndicatorGERAN */
static int hf_lte_rrc_nonCriticalExtension_69 = -1;  /* T_nonCriticalExtension_24 */
static int hf_lte_rrc_purpose_01 = -1;            /* T_purpose_01 */
static int hf_lte_rrc_e_CSFB_r9 = -1;             /* E_CSFB_r9 */
static int hf_lte_rrc_nonCriticalExtension_70 = -1;  /* MobilityFromEUTRACommand_v930_IEs */
static int hf_lte_rrc_nonCriticalExtension_71 = -1;  /* MobilityFromEUTRACommand_v960_IEs */
static int hf_lte_rrc_nonCriticalExtension_72 = -1;  /* MobilityFromEUTRACommand_v1530_IEs */
static int hf_lte_rrc_smtc_r15 = -1;              /* MTC_SSB_NR_r15 */
static int hf_lte_rrc_nonCriticalExtension_73 = -1;  /* T_nonCriticalExtension_25 */
static int hf_lte_rrc_targetRAT_Type = -1;        /* T_targetRAT_Type */
static int hf_lte_rrc_targetRAT_MessageContainer = -1;  /* T_targetRAT_MessageContainer */
static int hf_lte_rrc_nas_SecurityParamFromEUTRA = -1;  /* T_nas_SecurityParamFromEUTRA */
static int hf_lte_rrc_systemInformation_01 = -1;  /* SI_OrPSI_GERAN */
static int hf_lte_rrc_t304 = -1;                  /* T_t304 */
static int hf_lte_rrc_targetRAT_Type_01 = -1;     /* T_targetRAT_Type_01 */
static int hf_lte_rrc_geran = -1;                 /* T_geran */
static int hf_lte_rrc_physCellId = -1;            /* PhysCellIdGERAN */
static int hf_lte_rrc_carrierFreq = -1;           /* CarrierFreqGERAN */
static int hf_lte_rrc_networkControlOrder = -1;   /* BIT_STRING_SIZE_2 */
static int hf_lte_rrc_si = -1;                    /* T_si */
static int hf_lte_rrc_psi = -1;                   /* T_psi */
static int hf_lte_rrc_messageContCDMA2000_1XRTT_r9 = -1;  /* OCTET_STRING */
static int hf_lte_rrc_mobilityCDMA2000_HRPD_r9 = -1;  /* T_mobilityCDMA2000_HRPD_r9 */
static int hf_lte_rrc_messageContCDMA2000_HRPD_r9 = -1;  /* OCTET_STRING */
static int hf_lte_rrc_redirectCarrierCDMA2000_HRPD_r9 = -1;  /* CarrierFreqCDMA2000 */
static int hf_lte_rrc_pagingRecordList = -1;      /* T_pagingRecordList */
static int hf_lte_rrc_systemInfoModification = -1;  /* T_systemInfoModification */
static int hf_lte_rrc_etws_Indication = -1;       /* T_etws_Indication */
static int hf_lte_rrc_nonCriticalExtension_74 = -1;  /* Paging_v890_IEs */
static int hf_lte_rrc_nonCriticalExtension_75 = -1;  /* Paging_v920_IEs */
static int hf_lte_rrc_cmas_Indication_r9 = -1;    /* T_cmas_Indication_r9 */
static int hf_lte_rrc_nonCriticalExtension_76 = -1;  /* Paging_v1130_IEs */
static int hf_lte_rrc_eab_ParamModification_r11 = -1;  /* T_eab_ParamModification_r11 */
static int hf_lte_rrc_nonCriticalExtension_77 = -1;  /* Paging_v1310_IEs */
static int hf_lte_rrc_redistributionIndication_r13 = -1;  /* T_redistributionIndication_r13 */
static int hf_lte_rrc_systemInfoModification_eDRX_r13 = -1;  /* T_systemInfoModification_eDRX_r13 */
static int hf_lte_rrc_nonCriticalExtension_78 = -1;  /* Paging_v1530_IEs */
static int hf_lte_rrc_accessType = -1;            /* T_accessType */
static int hf_lte_rrc_nonCriticalExtension_79 = -1;  /* T_nonCriticalExtension_26 */
static int hf_lte_rrc_PagingRecordList_item = -1;  /* PagingRecord */
static int hf_lte_rrc_ue_Identity = -1;           /* PagingUE_Identity */
static int hf_lte_rrc_cn_Domain = -1;             /* T_cn_Domain */
static int hf_lte_rrc_s_TMSI = -1;                /* S_TMSI */
static int hf_lte_rrc_imsi = -1;                  /* IMSI */
static int hf_lte_rrc_ng_5G_S_TMSI_r15 = -1;      /* NG_5G_S_TMSI_r15 */
static int hf_lte_rrc_fullI_RNTI_r15 = -1;        /* I_RNTI_r15 */
static int hf_lte_rrc_IMSI_item = -1;             /* IMSI_Digit */
static int hf_lte_rrc_criticalExtensions_21 = -1;  /* T_criticalExtensions_21 */
static int hf_lte_rrc_c1_27 = -1;                 /* T_c1_27 */
static int hf_lte_rrc_proximityIndication_r9_01 = -1;  /* ProximityIndication_r9_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_21 = -1;  /* T_criticalExtensionsFuture_21 */
static int hf_lte_rrc_type_r9 = -1;               /* T_type_r9 */
static int hf_lte_rrc_carrierFreq_r9 = -1;        /* T_carrierFreq_r9 */
static int hf_lte_rrc_eutra_r9 = -1;              /* ARFCN_ValueEUTRA */
static int hf_lte_rrc_utra_r9 = -1;               /* ARFCN_ValueUTRA */
static int hf_lte_rrc_eutra2_v9e0 = -1;           /* ARFCN_ValueEUTRA_v9e0 */
static int hf_lte_rrc_nonCriticalExtension_80 = -1;  /* ProximityIndication_v930_IEs */
static int hf_lte_rrc_nonCriticalExtension_81 = -1;  /* T_nonCriticalExtension_27 */
static int hf_lte_rrc_criticalExtensions_22 = -1;  /* T_criticalExtensions_22 */
static int hf_lte_rrc_c1_28 = -1;                 /* T_c1_28 */
static int hf_lte_rrc_rnReconfiguration_r10_01 = -1;  /* RNReconfiguration_r10_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_22 = -1;  /* T_criticalExtensionsFuture_22 */
static int hf_lte_rrc_rn_SystemInfo_r10 = -1;     /* RN_SystemInfo_r10 */
static int hf_lte_rrc_rn_SubframeConfig_r10 = -1;  /* RN_SubframeConfig_r10 */
static int hf_lte_rrc_nonCriticalExtension_82 = -1;  /* T_nonCriticalExtension_28 */
static int hf_lte_rrc_systemInformationBlockType1_r10 = -1;  /* T_systemInformationBlockType1_r10 */
static int hf_lte_rrc_systemInformationBlockType2_r10 = -1;  /* SystemInformationBlockType2 */
static int hf_lte_rrc_criticalExtensions_23 = -1;  /* T_criticalExtensions_23 */
static int hf_lte_rrc_c1_29 = -1;                 /* T_c1_29 */
static int hf_lte_rrc_rnReconfigurationComplete_r10_01 = -1;  /* RNReconfigurationComplete_r10_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_23 = -1;  /* T_criticalExtensionsFuture_23 */
static int hf_lte_rrc_nonCriticalExtension_83 = -1;  /* T_nonCriticalExtension_29 */
static int hf_lte_rrc_criticalExtensions_24 = -1;  /* T_criticalExtensions_24 */
static int hf_lte_rrc_c1_30 = -1;                 /* T_c1_30 */
static int hf_lte_rrc_rrcConnectionReconfiguration_r8 = -1;  /* RRCConnectionReconfiguration_r8_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_24 = -1;  /* T_criticalExtensionsFuture_24 */
static int hf_lte_rrc_measConfig = -1;            /* MeasConfig */
static int hf_lte_rrc_mobilityControlInfo = -1;   /* MobilityControlInfo */
static int hf_lte_rrc_dedicatedInfoNASList = -1;  /* SEQUENCE_SIZE_1_maxDRB_OF_DedicatedInfoNAS */
static int hf_lte_rrc_dedicatedInfoNASList_item = -1;  /* DedicatedInfoNAS */
static int hf_lte_rrc_radioResourceConfigDedicated = -1;  /* RadioResourceConfigDedicated */
static int hf_lte_rrc_securityConfigHO = -1;      /* SecurityConfigHO */
static int hf_lte_rrc_nonCriticalExtension_84 = -1;  /* RRCConnectionReconfiguration_v890_IEs */
static int hf_lte_rrc_lateNonCriticalExtension_03 = -1;  /* T_lateNonCriticalExtension_02 */
static int hf_lte_rrc_nonCriticalExtension_85 = -1;  /* RRCConnectionReconfiguration_v920_IEs */
static int hf_lte_rrc_nonCriticalExtension_86 = -1;  /* RRCConnectionReconfiguration_v10i0_IEs */
static int hf_lte_rrc_nonCriticalExtension_87 = -1;  /* RRCConnectionReconfiguration_v10l0_IEs */
static int hf_lte_rrc_mobilityControlInfo_v10l0 = -1;  /* MobilityControlInfo_v10l0 */
static int hf_lte_rrc_sCellToAddModList_v10l0 = -1;  /* SCellToAddModList_v10l0 */
static int hf_lte_rrc_nonCriticalExtension_88 = -1;  /* RRCConnectionReconfiguration_v12f0_IEs */
static int hf_lte_rrc_scg_Configuration_v12f0 = -1;  /* SCG_Configuration_v12f0 */
static int hf_lte_rrc_nonCriticalExtension_89 = -1;  /* RRCConnectionReconfiguration_v1370_IEs */
static int hf_lte_rrc_radioResourceConfigDedicated_v1370 = -1;  /* RadioResourceConfigDedicated_v1370 */
static int hf_lte_rrc_sCellToAddModListExt_v1370 = -1;  /* SCellToAddModListExt_v1370 */
static int hf_lte_rrc_nonCriticalExtension_90 = -1;  /* RRCConnectionReconfiguration_v13c0_IEs */
static int hf_lte_rrc_radioResourceConfigDedicated_v13c0 = -1;  /* RadioResourceConfigDedicated_v13c0 */
static int hf_lte_rrc_scg_Configuration_v13c0 = -1;  /* SCG_Configuration_v13c0 */
static int hf_lte_rrc_nonCriticalExtension_91 = -1;  /* T_nonCriticalExtension_30 */
static int hf_lte_rrc_otherConfig_r9 = -1;        /* OtherConfig_r9 */
static int hf_lte_rrc_fullConfig_r9 = -1;         /* T_fullConfig_r9 */
static int hf_lte_rrc_nonCriticalExtension_92 = -1;  /* RRCConnectionReconfiguration_v1020_IEs */
static int hf_lte_rrc_sCellToReleaseList_r10 = -1;  /* SCellToReleaseList_r10 */
static int hf_lte_rrc_sCellToAddModList_r10 = -1;  /* SCellToAddModList_r10 */
static int hf_lte_rrc_nonCriticalExtension_93 = -1;  /* RRCConnectionReconfiguration_v1130_IEs */
static int hf_lte_rrc_systemInformationBlockType1Dedicated_r11 = -1;  /* T_systemInformationBlockType1Dedicated_r11 */
static int hf_lte_rrc_nonCriticalExtension_94 = -1;  /* RRCConnectionReconfiguration_v1250_IEs */
static int hf_lte_rrc_wlan_OffloadInfo_r12 = -1;  /* T_wlan_OffloadInfo_r12 */
static int hf_lte_rrc_release = -1;               /* NULL */
static int hf_lte_rrc_setup = -1;                 /* T_setup */
static int hf_lte_rrc_wlan_OffloadConfigDedicated_r12 = -1;  /* WLAN_OffloadConfig_r12 */
static int hf_lte_rrc_t350_r12 = -1;              /* T_t350_r12 */
static int hf_lte_rrc_scg_Configuration_r12 = -1;  /* SCG_Configuration_r12 */
static int hf_lte_rrc_sl_SyncTxControl_r12 = -1;  /* SL_SyncTxControl_r12 */
static int hf_lte_rrc_sl_DiscConfig_r12 = -1;     /* SL_DiscConfig_r12 */
static int hf_lte_rrc_sl_CommConfig_r12 = -1;     /* SL_CommConfig_r12 */
static int hf_lte_rrc_nonCriticalExtension_95 = -1;  /* RRCConnectionReconfiguration_v1310_IEs */
static int hf_lte_rrc_sCellToReleaseListExt_r13 = -1;  /* SCellToReleaseListExt_r13 */
static int hf_lte_rrc_sCellToAddModListExt_r13 = -1;  /* SCellToAddModListExt_r13 */
static int hf_lte_rrc_lwa_Configuration_r13 = -1;  /* LWA_Configuration_r13 */
static int hf_lte_rrc_lwip_Configuration_r13 = -1;  /* LWIP_Configuration_r13 */
static int hf_lte_rrc_rclwi_Configuration_r13 = -1;  /* RCLWI_Configuration_r13 */
static int hf_lte_rrc_nonCriticalExtension_96 = -1;  /* RRCConnectionReconfiguration_v1430_IEs */
static int hf_lte_rrc_sl_V2X_ConfigDedicated_r14 = -1;  /* SL_V2X_ConfigDedicated_r14 */
static int hf_lte_rrc_sCellToAddModListExt_v1430 = -1;  /* SCellToAddModListExt_v1430 */
static int hf_lte_rrc_perCC_GapIndicationRequest_r14 = -1;  /* T_perCC_GapIndicationRequest_r14 */
static int hf_lte_rrc_systemInformationBlockType2Dedicated_r14 = -1;  /* T_systemInformationBlockType2Dedicated_r14 */
static int hf_lte_rrc_nonCriticalExtension_97 = -1;  /* RRCConnectionReconfiguration_v1510_IEs */
static int hf_lte_rrc_nr_Config_r15 = -1;         /* T_nr_Config_r15 */
static int hf_lte_rrc_setup_01 = -1;              /* T_setup_01 */
static int hf_lte_rrc_endc_ReleaseAndAdd_r15 = -1;  /* BOOLEAN */
static int hf_lte_rrc_nr_SecondaryCellGroupConfig_r15 = -1;  /* T_nr_SecondaryCellGroupConfig_r15 */
static int hf_lte_rrc_sk_Counter_r15 = -1;        /* INTEGER_0_65535 */
static int hf_lte_rrc_nr_RadioBearerConfig1_r15 = -1;  /* T_nr_RadioBearerConfig1_r15 */
static int hf_lte_rrc_nr_RadioBearerConfig2_r15 = -1;  /* T_nr_RadioBearerConfig2_r15 */
static int hf_lte_rrc_tdm_PatternConfig_r15_01 = -1;  /* TDM_PatternConfig_r15 */
static int hf_lte_rrc_nonCriticalExtension_98 = -1;  /* RRCConnectionReconfiguration_v1530_IEs */
static int hf_lte_rrc_securityConfigHO_v1530 = -1;  /* SecurityConfigHO_v1530 */
static int hf_lte_rrc_sCellGroupToReleaseList_r15 = -1;  /* SCellGroupToReleaseList_r15 */
static int hf_lte_rrc_sCellGroupToAddModList_r15 = -1;  /* SCellGroupToAddModList_r15 */
static int hf_lte_rrc_dedicatedInfoNASList_r15 = -1;  /* SEQUENCE_SIZE_1_maxDRB_r15_OF_DedicatedInfoNAS */
static int hf_lte_rrc_dedicatedInfoNASList_r15_item = -1;  /* DedicatedInfoNAS */
static int hf_lte_rrc_p_MaxUE_FR1_r15 = -1;       /* P_Max */
static int hf_lte_rrc_nonCriticalExtension_99 = -1;  /* T_nonCriticalExtension_31 */
static int hf_lte_rrc_networkControlledSyncTx_r12 = -1;  /* T_networkControlledSyncTx_r12 */
static int hf_lte_rrc_cellIdentification_r12_01 = -1;  /* T_cellIdentification_r12_01 */
static int hf_lte_rrc_radioResourceConfigCommonPSCell_r12 = -1;  /* RadioResourceConfigCommonPSCell_r12 */
static int hf_lte_rrc_radioResourceConfigDedicatedPSCell_r12 = -1;  /* RadioResourceConfigDedicatedPSCell_r12 */
static int hf_lte_rrc_antennaInfoDedicatedPSCell_v1280 = -1;  /* AntennaInfoDedicated_v10i0 */
static int hf_lte_rrc_radioResourceConfigDedicatedPSCell_v1370 = -1;  /* RadioResourceConfigDedicatedPSCell_v1370 */
static int hf_lte_rrc_radioResourceConfigDedicatedPSCell_v13c0 = -1;  /* RadioResourceConfigDedicatedPSCell_v13c0 */
static int hf_lte_rrc_radioResourceConfigCommonPSCell_r12_01 = -1;  /* RadioResourceConfigCommonPSCell_v12f0 */
static int hf_lte_rrc_radioResourceConfigCommonPSCell_r14 = -1;  /* RadioResourceConfigCommonPSCell_v1440 */
static int hf_lte_rrc_p_MeNB_r12 = -1;            /* INTEGER_1_16 */
static int hf_lte_rrc_p_SeNB_r12 = -1;            /* INTEGER_1_16 */
static int hf_lte_rrc_powerControlMode_r12 = -1;  /* INTEGER_1_2 */
static int hf_lte_rrc_SCellToAddModList_r10_item = -1;  /* SCellToAddMod_r10 */
static int hf_lte_rrc_SCellToAddModList_v10l0_item = -1;  /* SCellToAddMod_v10l0 */
static int hf_lte_rrc_SCellToAddModList_v13c0_item = -1;  /* SCellToAddMod_v13c0 */
static int hf_lte_rrc_SCellToAddModListExt_r13_item = -1;  /* SCellToAddModExt_r13 */
static int hf_lte_rrc_SCellToAddModListExt_v1370_item = -1;  /* SCellToAddModExt_v1370 */
static int hf_lte_rrc_SCellToAddModListExt_v13c0_item = -1;  /* SCellToAddMod_v13c0 */
static int hf_lte_rrc_SCellToAddModListExt_v1430_item = -1;  /* SCellToAddModExt_v1430 */
static int hf_lte_rrc_SCellGroupToAddModList_r15_item = -1;  /* SCellGroupToAddMod_r15 */
static int hf_lte_rrc_sCellIndex_r10 = -1;        /* SCellIndex_r10 */
static int hf_lte_rrc_cellIdentification_r10 = -1;  /* T_cellIdentification_r10 */
static int hf_lte_rrc_radioResourceConfigCommonSCell_r10 = -1;  /* RadioResourceConfigCommonSCell_r10 */
static int hf_lte_rrc_radioResourceConfigDedicatedSCell_r10 = -1;  /* RadioResourceConfigDedicatedSCell_r10 */
static int hf_lte_rrc_antennaInfoDedicatedSCell_v10i0 = -1;  /* AntennaInfoDedicated_v10i0 */
static int hf_lte_rrc_srs_SwitchFromServCellIndex_r14 = -1;  /* INTEGER_0_31 */
static int hf_lte_rrc_sCellState_r15 = -1;        /* T_sCellState_r15 */
static int hf_lte_rrc_radioResourceConfigCommonSCell_v10l0 = -1;  /* RadioResourceConfigCommonSCell_v10l0 */
static int hf_lte_rrc_radioResourceConfigDedicatedSCell_v13c0 = -1;  /* RadioResourceConfigDedicatedSCell_v13c0 */
static int hf_lte_rrc_cellIdentification_r13 = -1;  /* T_cellIdentification_r13 */
static int hf_lte_rrc_physCellId_r13 = -1;        /* PhysCellId */
static int hf_lte_rrc_dl_CarrierFreq_r13 = -1;    /* ARFCN_ValueEUTRA_r9 */
static int hf_lte_rrc_radioResourceConfigCommonSCell_r13 = -1;  /* RadioResourceConfigCommonSCell_r10 */
static int hf_lte_rrc_radioResourceConfigDedicatedSCell_r13 = -1;  /* RadioResourceConfigDedicatedSCell_r10 */
static int hf_lte_rrc_antennaInfoDedicatedSCell_r13 = -1;  /* AntennaInfoDedicated_v10i0 */
static int hf_lte_rrc_radioResourceConfigCommonSCell_v1370 = -1;  /* RadioResourceConfigCommonSCell_v10l0 */
static int hf_lte_rrc_sCellState_r15_01 = -1;     /* T_sCellState_r15_01 */
static int hf_lte_rrc_sCellGroupIndex_r15 = -1;   /* SCellGroupIndex_r15 */
static int hf_lte_rrc_sCellConfigCommon_r15 = -1;  /* SCellConfigCommon_r15 */
static int hf_lte_rrc_sCellToReleaseList_r15 = -1;  /* SCellToReleaseListExt_r13 */
static int hf_lte_rrc_sCellToAddModList_r15 = -1;  /* SCellToAddModListExt_r13 */
static int hf_lte_rrc_SCellToReleaseList_r10_item = -1;  /* SCellIndex_r10 */
static int hf_lte_rrc_SCellToReleaseListExt_r13_item = -1;  /* SCellIndex_r13 */
static int hf_lte_rrc_SCellGroupToReleaseList_r15_item = -1;  /* SCellGroupIndex_r15 */
static int hf_lte_rrc_radioResourceConfigCommonSCell_r15 = -1;  /* RadioResourceConfigCommonSCell_r10 */
static int hf_lte_rrc_radioResourceConfigDedicatedSCell_r15 = -1;  /* RadioResourceConfigDedicatedSCell_r10 */
static int hf_lte_rrc_antennaInfoDedicatedSCell_r15 = -1;  /* AntennaInfoDedicated_v10i0 */
static int hf_lte_rrc_setup_02 = -1;              /* T_setup_02 */
static int hf_lte_rrc_scg_ConfigPartMCG_r12 = -1;  /* T_scg_ConfigPartMCG_r12 */
static int hf_lte_rrc_scg_Counter_r12 = -1;       /* INTEGER_0_65535 */
static int hf_lte_rrc_scg_ConfigPartSCG_r12 = -1;  /* SCG_ConfigPartSCG_r12 */
static int hf_lte_rrc_setup_03 = -1;              /* T_setup_03 */
static int hf_lte_rrc_scg_ConfigPartSCG_v12f0 = -1;  /* SCG_ConfigPartSCG_v12f0 */
static int hf_lte_rrc_setup_04 = -1;              /* T_setup_04 */
static int hf_lte_rrc_scg_ConfigPartSCG_v13c0 = -1;  /* SCG_ConfigPartSCG_v13c0 */
static int hf_lte_rrc_radioResourceConfigDedicatedSCG_r12 = -1;  /* RadioResourceConfigDedicatedSCG_r12 */
static int hf_lte_rrc_pSCellToAddMod_r12 = -1;    /* PSCellToAddMod_r12 */
static int hf_lte_rrc_sCellToAddModListSCG_r12_01 = -1;  /* SCellToAddModList_r10 */
static int hf_lte_rrc_mobilityControlInfoSCG_r12 = -1;  /* MobilityControlInfoSCG_r12 */
static int hf_lte_rrc_sCellToAddModListSCG_Ext_r13_01 = -1;  /* SCellToAddModListExt_r13 */
static int hf_lte_rrc_sCellToAddModListSCG_Ext_v1370 = -1;  /* SCellToAddModListExt_v1370 */
static int hf_lte_rrc_pSCellToAddMod_v1440 = -1;  /* PSCellToAddMod_v1440 */
static int hf_lte_rrc_sCellGroupToReleaseListSCG_r15 = -1;  /* SCellGroupToReleaseList_r15 */
static int hf_lte_rrc_sCellGroupToAddModListSCG_r15 = -1;  /* SCellGroupToAddModList_r15 */
static int hf_lte_rrc_measConfigSN_r15 = -1;      /* MeasConfig */
static int hf_lte_rrc_tdm_PatternConfigNE_DC_r15 = -1;  /* TDM_PatternConfig_r15 */
static int hf_lte_rrc_pSCellToAddMod_v12f0 = -1;  /* PSCellToAddMod_v12f0 */
static int hf_lte_rrc_sCellToAddModListSCG_v12f0 = -1;  /* SCellToAddModList_v10l0 */
static int hf_lte_rrc_sCellToAddModListSCG_v13c0 = -1;  /* SCellToAddModList_v13c0 */
static int hf_lte_rrc_sCellToAddModListSCG_Ext_v13c0 = -1;  /* SCellToAddModListExt_v13c0 */
static int hf_lte_rrc_handoverType = -1;          /* T_handoverType */
static int hf_lte_rrc_intraLTE = -1;              /* T_intraLTE */
static int hf_lte_rrc_securityAlgorithmConfig = -1;  /* SecurityAlgorithmConfig */
static int hf_lte_rrc_keyChangeIndicator = -1;    /* BOOLEAN */
static int hf_lte_rrc_nextHopChainingCount = -1;  /* NextHopChainingCount */
static int hf_lte_rrc_interRAT = -1;              /* T_interRAT */
static int hf_lte_rrc_nas_SecurityParamToEUTRA = -1;  /* T_nas_SecurityParamToEUTRA */
static int hf_lte_rrc_handoverType_v1530 = -1;    /* T_handoverType_v1530 */
static int hf_lte_rrc_intra5GC_r15 = -1;          /* T_intra5GC_r15 */
static int hf_lte_rrc_securityAlgorithmConfig_r15 = -1;  /* SecurityAlgorithmConfig */
static int hf_lte_rrc_keyChangeIndicator_r15 = -1;  /* BOOLEAN */
static int hf_lte_rrc_nextHopChainingCount_r15 = -1;  /* NextHopChainingCount */
static int hf_lte_rrc_nas_Container_r15 = -1;     /* T_nas_Container_r15 */
static int hf_lte_rrc_fivegc_ToEPC_r15 = -1;      /* T_fivegc_ToEPC_r15 */
static int hf_lte_rrc_epc_To5GC_r15 = -1;         /* T_epc_To5GC_r15 */
static int hf_lte_rrc_nas_Container_r15_01 = -1;  /* T_nas_Container_r15_01 */
static int hf_lte_rrc_setup_05 = -1;              /* T_setup_05 */
static int hf_lte_rrc_criticalExtensions_25 = -1;  /* T_criticalExtensions_25 */
static int hf_lte_rrc_rrcConnectionReconfigurationComplete_r8 = -1;  /* RRCConnectionReconfigurationComplete_r8_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_25 = -1;  /* T_criticalExtensionsFuture_25 */
static int hf_lte_rrc_nonCriticalExtension_100 = -1;  /* RRCConnectionReconfigurationComplete_v8a0_IEs */
static int hf_lte_rrc_nonCriticalExtension_101 = -1;  /* RRCConnectionReconfigurationComplete_v1020_IEs */
static int hf_lte_rrc_rlf_InfoAvailable_r10 = -1;  /* T_rlf_InfoAvailable_r10 */
static int hf_lte_rrc_logMeasAvailable_r10 = -1;  /* T_logMeasAvailable_r10 */
static int hf_lte_rrc_nonCriticalExtension_102 = -1;  /* RRCConnectionReconfigurationComplete_v1130_IEs */
static int hf_lte_rrc_connEstFailInfoAvailable_r11 = -1;  /* T_connEstFailInfoAvailable_r11 */
static int hf_lte_rrc_nonCriticalExtension_103 = -1;  /* RRCConnectionReconfigurationComplete_v1250_IEs */
static int hf_lte_rrc_logMeasAvailableMBSFN_r12 = -1;  /* T_logMeasAvailableMBSFN_r12 */
static int hf_lte_rrc_nonCriticalExtension_104 = -1;  /* RRCConnectionReconfigurationComplete_v1430_IEs */
static int hf_lte_rrc_perCC_GapIndicationList_r14 = -1;  /* PerCC_GapIndicationList_r14 */
static int hf_lte_rrc_numFreqEffective_r14 = -1;  /* INTEGER_1_12 */
static int hf_lte_rrc_numFreqEffectiveReduced_r14 = -1;  /* INTEGER_1_12 */
static int hf_lte_rrc_nonCriticalExtension_105 = -1;  /* RRCConnectionReconfigurationComplete_v1510_IEs */
static int hf_lte_rrc_scg_ConfigResponseNR_r15 = -1;  /* T_scg_ConfigResponseNR_r15 */
static int hf_lte_rrc_nonCriticalExtension_106 = -1;  /* RRCConnectionReconfigurationComplete_v1530_IEs */
static int hf_lte_rrc_logMeasAvailableBT_r15 = -1;  /* T_logMeasAvailableBT_r15 */
static int hf_lte_rrc_logMeasAvailableWLAN_r15 = -1;  /* T_logMeasAvailableWLAN_r15 */
static int hf_lte_rrc_flightPathInfoAvailable_r15 = -1;  /* T_flightPathInfoAvailable_r15 */
static int hf_lte_rrc_nonCriticalExtension_107 = -1;  /* T_nonCriticalExtension_32 */
static int hf_lte_rrc_criticalExtensions_26 = -1;  /* T_criticalExtensions_26 */
static int hf_lte_rrc_c1_31 = -1;                 /* T_c1_31 */
static int hf_lte_rrc_rrcConnectionReestablishment_r8 = -1;  /* RRCConnectionReestablishment_r8_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_26 = -1;  /* T_criticalExtensionsFuture_26 */
static int hf_lte_rrc_nonCriticalExtension_108 = -1;  /* RRCConnectionReestablishment_v8a0_IEs */
static int hf_lte_rrc_nonCriticalExtension_109 = -1;  /* T_nonCriticalExtension_33 */
static int hf_lte_rrc_criticalExtensions_27 = -1;  /* T_criticalExtensions_27 */
static int hf_lte_rrc_rrcConnectionReestablishmentComplete_r8 = -1;  /* RRCConnectionReestablishmentComplete_r8_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_27 = -1;  /* T_criticalExtensionsFuture_27 */
static int hf_lte_rrc_nonCriticalExtension_110 = -1;  /* RRCConnectionReestablishmentComplete_v920_IEs */
static int hf_lte_rrc_rlf_InfoAvailable_r9 = -1;  /* T_rlf_InfoAvailable_r9 */
static int hf_lte_rrc_nonCriticalExtension_111 = -1;  /* RRCConnectionReestablishmentComplete_v8a0_IEs */
static int hf_lte_rrc_nonCriticalExtension_112 = -1;  /* RRCConnectionReestablishmentComplete_v1020_IEs */
static int hf_lte_rrc_logMeasAvailable_r10_01 = -1;  /* T_logMeasAvailable_r10_01 */
static int hf_lte_rrc_nonCriticalExtension_113 = -1;  /* RRCConnectionReestablishmentComplete_v1130_IEs */
static int hf_lte_rrc_connEstFailInfoAvailable_r11_01 = -1;  /* T_connEstFailInfoAvailable_r11_01 */
static int hf_lte_rrc_nonCriticalExtension_114 = -1;  /* RRCConnectionReestablishmentComplete_v1250_IEs */
static int hf_lte_rrc_logMeasAvailableMBSFN_r12_01 = -1;  /* T_logMeasAvailableMBSFN_r12_01 */
static int hf_lte_rrc_nonCriticalExtension_115 = -1;  /* RRCConnectionReestablishmentComplete_v1530_IEs */
static int hf_lte_rrc_logMeasAvailableBT_r15_01 = -1;  /* T_logMeasAvailableBT_r15_01 */
static int hf_lte_rrc_logMeasAvailableWLAN_r15_01 = -1;  /* T_logMeasAvailableWLAN_r15_01 */
static int hf_lte_rrc_flightPathInfoAvailable_r15_01 = -1;  /* T_flightPathInfoAvailable_r15_01 */
static int hf_lte_rrc_nonCriticalExtension_116 = -1;  /* T_nonCriticalExtension_34 */
static int hf_lte_rrc_criticalExtensions_28 = -1;  /* T_criticalExtensions_28 */
static int hf_lte_rrc_rrcConnectionReestablishmentReject_r8 = -1;  /* RRCConnectionReestablishmentReject_r8_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_28 = -1;  /* T_criticalExtensionsFuture_28 */
static int hf_lte_rrc_nonCriticalExtension_117 = -1;  /* RRCConnectionReestablishmentReject_v8a0_IEs */
static int hf_lte_rrc_nonCriticalExtension_118 = -1;  /* T_nonCriticalExtension_35 */
static int hf_lte_rrc_criticalExtensions_29 = -1;  /* T_criticalExtensions_29 */
static int hf_lte_rrc_rrcConnectionReestablishmentRequest_r8 = -1;  /* RRCConnectionReestablishmentRequest_r8_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_29 = -1;  /* T_criticalExtensionsFuture_29 */
static int hf_lte_rrc_ue_Identity_01 = -1;        /* ReestabUE_Identity */
static int hf_lte_rrc_reestablishmentCause = -1;  /* ReestablishmentCause */
static int hf_lte_rrc_spare_03 = -1;              /* BIT_STRING_SIZE_2 */
static int hf_lte_rrc_c_RNTI = -1;                /* C_RNTI */
static int hf_lte_rrc_physCellId_01 = -1;         /* PhysCellId */
static int hf_lte_rrc_criticalExtensions_30 = -1;  /* T_criticalExtensions_30 */
static int hf_lte_rrc_c1_32 = -1;                 /* T_c1_32 */
static int hf_lte_rrc_rrcConnectionReject_r8 = -1;  /* RRCConnectionReject_r8_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_30 = -1;  /* T_criticalExtensionsFuture_30 */
static int hf_lte_rrc_waitTime = -1;              /* INTEGER_1_16 */
static int hf_lte_rrc_nonCriticalExtension_119 = -1;  /* RRCConnectionReject_v8a0_IEs */
static int hf_lte_rrc_nonCriticalExtension_120 = -1;  /* RRCConnectionReject_v1020_IEs */
static int hf_lte_rrc_extendedWaitTime_r10 = -1;  /* INTEGER_1_1800 */
static int hf_lte_rrc_nonCriticalExtension_121 = -1;  /* RRCConnectionReject_v1130_IEs */
static int hf_lte_rrc_deprioritisationReq_r11 = -1;  /* T_deprioritisationReq_r11 */
static int hf_lte_rrc_deprioritisationType_r11 = -1;  /* T_deprioritisationType_r11 */
static int hf_lte_rrc_deprioritisationTimer_r11 = -1;  /* T_deprioritisationTimer_r11 */
static int hf_lte_rrc_nonCriticalExtension_122 = -1;  /* RRCConnectionReject_v1320_IEs */
static int hf_lte_rrc_rrc_SuspendIndication_r13 = -1;  /* T_rrc_SuspendIndication_r13 */
static int hf_lte_rrc_nonCriticalExtension_123 = -1;  /* T_nonCriticalExtension_36 */
static int hf_lte_rrc_criticalExtensions_31 = -1;  /* T_criticalExtensions_31 */
static int hf_lte_rrc_c1_33 = -1;                 /* T_c1_33 */
static int hf_lte_rrc_rrcConnectionRelease_r8 = -1;  /* RRCConnectionRelease_r8_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_31 = -1;  /* T_criticalExtensionsFuture_31 */
static int hf_lte_rrc_releaseCause = -1;          /* ReleaseCause */
static int hf_lte_rrc_redirectedCarrierInfo = -1;  /* RedirectedCarrierInfo */
static int hf_lte_rrc_idleModeMobilityControlInfo = -1;  /* IdleModeMobilityControlInfo */
static int hf_lte_rrc_nonCriticalExtension_124 = -1;  /* RRCConnectionRelease_v890_IEs */
static int hf_lte_rrc_lateNonCriticalExtension_04 = -1;  /* T_lateNonCriticalExtension_03 */
static int hf_lte_rrc_nonCriticalExtension_125 = -1;  /* RRCConnectionRelease_v920_IEs */
static int hf_lte_rrc_redirectedCarrierInfo_v9e0 = -1;  /* RedirectedCarrierInfo_v9e0 */
static int hf_lte_rrc_idleModeMobilityControlInfo_v9e0 = -1;  /* IdleModeMobilityControlInfo_v9e0 */
static int hf_lte_rrc_nonCriticalExtension_126 = -1;  /* T_nonCriticalExtension_37 */
static int hf_lte_rrc_cellInfoList_r9 = -1;       /* T_cellInfoList_r9 */
static int hf_lte_rrc_geran_r9 = -1;              /* CellInfoListGERAN_r9 */
static int hf_lte_rrc_utra_FDD_r9 = -1;           /* CellInfoListUTRA_FDD_r9 */
static int hf_lte_rrc_utra_TDD_r9 = -1;           /* CellInfoListUTRA_TDD_r9 */
static int hf_lte_rrc_utra_TDD_r10 = -1;          /* CellInfoListUTRA_TDD_r10 */
static int hf_lte_rrc_nonCriticalExtension_127 = -1;  /* RRCConnectionRelease_v1020_IEs */
static int hf_lte_rrc_nonCriticalExtension_128 = -1;  /* RRCConnectionRelease_v1320_IEs */
static int hf_lte_rrc_resumeIdentity_r13 = -1;    /* ResumeIdentity_r13 */
static int hf_lte_rrc_nonCriticalExtension_129 = -1;  /* RRCConnectionRelease_v1530_IEs */
static int hf_lte_rrc_drb_ContinueROHC_r15 = -1;  /* T_drb_ContinueROHC_r15 */
static int hf_lte_rrc_measIdleConfig_r15 = -1;    /* MeasIdleConfigDedicated_r15 */
static int hf_lte_rrc_rrc_InactiveConfig_r15 = -1;  /* RRC_InactiveConfig_r15 */
static int hf_lte_rrc_cn_Type_r15 = -1;           /* T_cn_Type_r15 */
static int hf_lte_rrc_nonCriticalExtension_130 = -1;  /* RRCConnectionRelease_v1540_IEs */
static int hf_lte_rrc_nonCriticalExtension_131 = -1;  /* T_nonCriticalExtension_38 */
static int hf_lte_rrc_eutra = -1;                 /* ARFCN_ValueEUTRA */
static int hf_lte_rrc_geran_01 = -1;              /* CarrierFreqsGERAN */
static int hf_lte_rrc_utra_FDD = -1;              /* ARFCN_ValueUTRA */
static int hf_lte_rrc_utra_TDD = -1;              /* ARFCN_ValueUTRA */
static int hf_lte_rrc_cdma2000_HRPD = -1;         /* CarrierFreqCDMA2000 */
static int hf_lte_rrc_cdma2000_1xRTT = -1;        /* CarrierFreqCDMA2000 */
static int hf_lte_rrc_utra_TDD_r10_01 = -1;       /* CarrierFreqListUTRA_TDD_r10 */
static int hf_lte_rrc_nr_r15 = -1;                /* CarrierInfoNR_r15 */
static int hf_lte_rrc_eutra_v9e0 = -1;            /* ARFCN_ValueEUTRA_v9e0 */
static int hf_lte_rrc_shortI_RNTI_r15 = -1;       /* ShortI_RNTI_r15 */
static int hf_lte_rrc_ran_PagingCycle_r15 = -1;   /* T_ran_PagingCycle_r15 */
static int hf_lte_rrc_periodic_RNAU_timer_r15 = -1;  /* T_periodic_RNAU_timer_r15 */
static int hf_lte_rrc_nonCriticalExtension_132 = -1;  /* T_nonCriticalExtension_39 */
static int hf_lte_rrc_cellList_r15 = -1;          /* PLMN_RAN_AreaCellList_r15 */
static int hf_lte_rrc_ran_AreaConfigList_r15 = -1;  /* PLMN_RAN_AreaConfigList_r15 */
static int hf_lte_rrc_PLMN_RAN_AreaCellList_r15_item = -1;  /* PLMN_RAN_AreaCell_r15 */
static int hf_lte_rrc_plmn_Identity_r15 = -1;     /* PLMN_Identity */
static int hf_lte_rrc_ran_AreaCells_r15 = -1;     /* SEQUENCE_SIZE_1_32_OF_CellIdentity */
static int hf_lte_rrc_ran_AreaCells_r15_item = -1;  /* CellIdentity */
static int hf_lte_rrc_PLMN_RAN_AreaConfigList_r15_item = -1;  /* PLMN_RAN_AreaConfig_r15 */
static int hf_lte_rrc_ran_Area_r15 = -1;          /* SEQUENCE_SIZE_1_16_OF_RAN_AreaConfig_r15 */
static int hf_lte_rrc_ran_Area_r15_item = -1;     /* RAN_AreaConfig_r15 */
static int hf_lte_rrc_trackingAreaCode_5GC_r15 = -1;  /* TrackingAreaCode_5GC_r15 */
static int hf_lte_rrc_ran_AreaCodeList_r15 = -1;  /* SEQUENCE_SIZE_1_32_OF_RAN_AreaCode_r15 */
static int hf_lte_rrc_ran_AreaCodeList_r15_item = -1;  /* RAN_AreaCode_r15 */
static int hf_lte_rrc_CarrierFreqListUTRA_TDD_r10_item = -1;  /* ARFCN_ValueUTRA */
static int hf_lte_rrc_freqPriorityListEUTRA = -1;  /* FreqPriorityListEUTRA */
static int hf_lte_rrc_freqPriorityListGERAN = -1;  /* FreqsPriorityListGERAN */
static int hf_lte_rrc_freqPriorityListUTRA_FDD = -1;  /* FreqPriorityListUTRA_FDD */
static int hf_lte_rrc_freqPriorityListUTRA_TDD = -1;  /* FreqPriorityListUTRA_TDD */
static int hf_lte_rrc_bandClassPriorityListHRPD = -1;  /* BandClassPriorityListHRPD */
static int hf_lte_rrc_bandClassPriorityList1XRTT = -1;  /* BandClassPriorityList1XRTT */
static int hf_lte_rrc_t320 = -1;                  /* T_t320 */
static int hf_lte_rrc_freqPriorityListExtEUTRA_r12 = -1;  /* FreqPriorityListExtEUTRA_r12 */
static int hf_lte_rrc_freqPriorityListEUTRA_v1310 = -1;  /* FreqPriorityListEUTRA_v1310 */
static int hf_lte_rrc_freqPriorityListExtEUTRA_v1310 = -1;  /* FreqPriorityListExtEUTRA_v1310 */
static int hf_lte_rrc_freqPriorityListNR_r15 = -1;  /* FreqPriorityListNR_r15 */
static int hf_lte_rrc_freqPriorityListEUTRA_v9e0 = -1;  /* SEQUENCE_SIZE_1_maxFreq_OF_FreqPriorityEUTRA_v9e0 */
static int hf_lte_rrc_freqPriorityListEUTRA_v9e0_item = -1;  /* FreqPriorityEUTRA_v9e0 */
static int hf_lte_rrc_FreqPriorityListEUTRA_item = -1;  /* FreqPriorityEUTRA */
static int hf_lte_rrc_FreqPriorityListExtEUTRA_r12_item = -1;  /* FreqPriorityEUTRA_r12 */
static int hf_lte_rrc_FreqPriorityListEUTRA_v1310_item = -1;  /* FreqPriorityEUTRA_v1310 */
static int hf_lte_rrc_FreqPriorityListExtEUTRA_v1310_item = -1;  /* FreqPriorityEUTRA_v1310 */
static int hf_lte_rrc_carrierFreq_01 = -1;        /* ARFCN_ValueEUTRA */
static int hf_lte_rrc_cellReselectionPriority = -1;  /* CellReselectionPriority */
static int hf_lte_rrc_carrierFreq_v9e0 = -1;      /* ARFCN_ValueEUTRA_v9e0 */
static int hf_lte_rrc_cellReselectionPriority_r12 = -1;  /* CellReselectionPriority */
static int hf_lte_rrc_cellReselectionSubPriority_r13 = -1;  /* CellReselectionSubPriority_r13 */
static int hf_lte_rrc_FreqPriorityListNR_r15_item = -1;  /* FreqPriorityNR_r15 */
static int hf_lte_rrc_carrierFreq_r15 = -1;       /* ARFCN_ValueNR_r15 */
static int hf_lte_rrc_cellReselectionPriority_r15 = -1;  /* CellReselectionPriority */
static int hf_lte_rrc_cellReselectionSubPriority_r15 = -1;  /* CellReselectionSubPriority_r13 */
static int hf_lte_rrc_FreqsPriorityListGERAN_item = -1;  /* FreqsPriorityGERAN */
static int hf_lte_rrc_carrierFreqs = -1;          /* CarrierFreqsGERAN */
static int hf_lte_rrc_FreqPriorityListUTRA_FDD_item = -1;  /* FreqPriorityUTRA_FDD */
static int hf_lte_rrc_carrierFreq_02 = -1;        /* ARFCN_ValueUTRA */
static int hf_lte_rrc_FreqPriorityListUTRA_TDD_item = -1;  /* FreqPriorityUTRA_TDD */
static int hf_lte_rrc_BandClassPriorityListHRPD_item = -1;  /* BandClassPriorityHRPD */
static int hf_lte_rrc_bandClass = -1;             /* BandclassCDMA2000 */
static int hf_lte_rrc_BandClassPriorityList1XRTT_item = -1;  /* BandClassPriority1XRTT */
static int hf_lte_rrc_CellInfoListGERAN_r9_item = -1;  /* CellInfoGERAN_r9 */
static int hf_lte_rrc_physCellId_r9 = -1;         /* PhysCellIdGERAN */
static int hf_lte_rrc_carrierFreq_r9_01 = -1;     /* CarrierFreqGERAN */
static int hf_lte_rrc_systemInformation_r9 = -1;  /* T_systemInformation_r9 */
static int hf_lte_rrc_subcarrierSpacingSSB_r15 = -1;  /* T_subcarrierSpacingSSB_r15 */
static int hf_lte_rrc_CellInfoListUTRA_FDD_r9_item = -1;  /* CellInfoUTRA_FDD_r9 */
static int hf_lte_rrc_physCellId_r9_01 = -1;      /* PhysCellIdUTRA_FDD */
static int hf_lte_rrc_utra_BCCH_Container_r9 = -1;  /* T_utra_BCCH_Container_r9 */
static int hf_lte_rrc_CellInfoListUTRA_TDD_r9_item = -1;  /* CellInfoUTRA_TDD_r9 */
static int hf_lte_rrc_physCellId_r9_02 = -1;      /* PhysCellIdUTRA_TDD */
static int hf_lte_rrc_utra_BCCH_Container_r9_01 = -1;  /* T_utra_BCCH_Container_r9_01 */
static int hf_lte_rrc_CellInfoListUTRA_TDD_r10_item = -1;  /* CellInfoUTRA_TDD_r10 */
static int hf_lte_rrc_physCellId_r10_01 = -1;     /* PhysCellIdUTRA_TDD */
static int hf_lte_rrc_carrierFreq_r10_01 = -1;    /* ARFCN_ValueUTRA */
static int hf_lte_rrc_utra_BCCH_Container_r10 = -1;  /* T_utra_BCCH_Container_r10 */
static int hf_lte_rrc_criticalExtensions_32 = -1;  /* T_criticalExtensions_32 */
static int hf_lte_rrc_rrcConnectionRequest_r8 = -1;  /* RRCConnectionRequest_r8_IEs */
static int hf_lte_rrc_rrcConnectionRequest_r15 = -1;  /* RRCConnectionRequest_5GC_r15_IEs */
static int hf_lte_rrc_ue_Identity_02 = -1;        /* InitialUE_Identity */
static int hf_lte_rrc_establishmentCause = -1;    /* EstablishmentCause */
static int hf_lte_rrc_spare_04 = -1;              /* BIT_STRING_SIZE_1 */
static int hf_lte_rrc_ue_Identity_03 = -1;        /* InitialUE_Identity_5GC */
static int hf_lte_rrc_establishmentCause_01 = -1;  /* EstablishmentCause_5GC */
static int hf_lte_rrc_randomValue = -1;           /* BIT_STRING_SIZE_40 */
static int hf_lte_rrc_ng_5G_S_TMSI_Part1 = -1;    /* BIT_STRING_SIZE_40 */
static int hf_lte_rrc_criticalExtensions_33 = -1;  /* T_criticalExtensions_33 */
static int hf_lte_rrc_c1_34 = -1;                 /* T_c1_34 */
static int hf_lte_rrc_rrcConnectionResume_r13_01 = -1;  /* RRCConnectionResume_r13_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_32 = -1;  /* T_criticalExtensionsFuture_32 */
static int hf_lte_rrc_radioResourceConfigDedicated_r13 = -1;  /* RadioResourceConfigDedicated */
static int hf_lte_rrc_nextHopChainingCount_r13 = -1;  /* NextHopChainingCount */
static int hf_lte_rrc_measConfig_r13 = -1;        /* MeasConfig */
static int hf_lte_rrc_antennaInfoDedicatedPCell_r13 = -1;  /* AntennaInfoDedicated_v10i0 */
static int hf_lte_rrc_drb_ContinueROHC_r13 = -1;  /* T_drb_ContinueROHC_r13 */
static int hf_lte_rrc_rrcConnectionResume_v1430_IEs = -1;  /* RRCConnectionResume_v1430_IEs */
static int hf_lte_rrc_otherConfig_r14 = -1;       /* OtherConfig_r9 */
static int hf_lte_rrc_rrcConnectionResume_v1510_IEs = -1;  /* RRCConnectionResume_v1510_IEs */
static int hf_lte_rrc_nr_RadioBearerConfig1_r15_01 = -1;  /* T_nr_RadioBearerConfig1_r15_01 */
static int hf_lte_rrc_nr_RadioBearerConfig2_r15_01 = -1;  /* T_nr_RadioBearerConfig2_r15_01 */
static int hf_lte_rrc_nonCriticalExtension_133 = -1;  /* RRCConnectionResume_v1530_IEs */
static int hf_lte_rrc_fullConfig_r15 = -1;        /* T_fullConfig_r15 */
static int hf_lte_rrc_nonCriticalExtension_134 = -1;  /* T_nonCriticalExtension_40 */
static int hf_lte_rrc_criticalExtensions_34 = -1;  /* T_criticalExtensions_34 */
static int hf_lte_rrc_rrcConnectionResumeComplete_r13_01 = -1;  /* RRCConnectionResumeComplete_r13_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_33 = -1;  /* T_criticalExtensionsFuture_33 */
static int hf_lte_rrc_selectedPLMN_Identity_r13 = -1;  /* INTEGER_1_maxPLMN_r11 */
static int hf_lte_rrc_dedicatedInfoNAS_r13 = -1;  /* DedicatedInfoNAS */
static int hf_lte_rrc_rlf_InfoAvailable_r13 = -1;  /* T_rlf_InfoAvailable_r13 */
static int hf_lte_rrc_logMeasAvailable_r13 = -1;  /* T_logMeasAvailable_r13 */
static int hf_lte_rrc_connEstFailInfoAvailable_r13 = -1;  /* T_connEstFailInfoAvailable_r13 */
static int hf_lte_rrc_mobilityState_r13 = -1;     /* T_mobilityState_r13 */
static int hf_lte_rrc_mobilityHistoryAvail_r13 = -1;  /* T_mobilityHistoryAvail_r13 */
static int hf_lte_rrc_logMeasAvailableMBSFN_r13 = -1;  /* T_logMeasAvailableMBSFN_r13 */
static int hf_lte_rrc_nonCriticalExtension_135 = -1;  /* RRCConnectionResumeComplete_v1530_IEs */
static int hf_lte_rrc_logMeasAvailableBT_r15_02 = -1;  /* T_logMeasAvailableBT_r15_02 */
static int hf_lte_rrc_logMeasAvailableWLAN_r15_02 = -1;  /* T_logMeasAvailableWLAN_r15_02 */
static int hf_lte_rrc_idleMeasAvailable_r15 = -1;  /* T_idleMeasAvailable_r15 */
static int hf_lte_rrc_flightPathInfoAvailable_r15_02 = -1;  /* T_flightPathInfoAvailable_r15_02 */
static int hf_lte_rrc_nonCriticalExtension_136 = -1;  /* T_nonCriticalExtension_41 */
static int hf_lte_rrc_criticalExtensions_35 = -1;  /* T_criticalExtensions_35 */
static int hf_lte_rrc_rrcConnectionResumeRequest_r13_01 = -1;  /* RRCConnectionResumeRequest_r13_IEs */
static int hf_lte_rrc_rrcConnectionResumeRequest_r15 = -1;  /* RRCConnectionResumeRequest_5GC_r15_IEs */
static int hf_lte_rrc_resumeIdentity_r13_01 = -1;  /* T_resumeIdentity_r13 */
static int hf_lte_rrc_resumeID_r13 = -1;          /* ResumeIdentity_r13 */
static int hf_lte_rrc_truncatedResumeID_r13 = -1;  /* BIT_STRING_SIZE_24 */
static int hf_lte_rrc_shortResumeMAC_I_r13 = -1;  /* BIT_STRING_SIZE_16 */
static int hf_lte_rrc_resumeCause_r13 = -1;       /* ResumeCause */
static int hf_lte_rrc_resumeIdentity_r15 = -1;    /* T_resumeIdentity_r15 */
static int hf_lte_rrc_shortResumeMAC_I_r15 = -1;  /* BIT_STRING_SIZE_16 */
static int hf_lte_rrc_resumeCause_r15 = -1;       /* ResumeCause_r15 */
static int hf_lte_rrc_criticalExtensions_36 = -1;  /* T_criticalExtensions_36 */
static int hf_lte_rrc_c1_35 = -1;                 /* T_c1_35 */
static int hf_lte_rrc_rrcConnectionSetup_r8 = -1;  /* RRCConnectionSetup_r8_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_34 = -1;  /* T_criticalExtensionsFuture_34 */
static int hf_lte_rrc_nonCriticalExtension_137 = -1;  /* RRCConnectionSetup_v8a0_IEs */
static int hf_lte_rrc_nonCriticalExtension_138 = -1;  /* T_nonCriticalExtension_42 */
static int hf_lte_rrc_criticalExtensions_37 = -1;  /* T_criticalExtensions_37 */
static int hf_lte_rrc_c1_36 = -1;                 /* T_c1_36 */
static int hf_lte_rrc_rrcConnectionSetupComplete_r8 = -1;  /* RRCConnectionSetupComplete_r8_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_35 = -1;  /* T_criticalExtensionsFuture_35 */
static int hf_lte_rrc_selectedPLMN_Identity = -1;  /* INTEGER_1_maxPLMN_r11 */
static int hf_lte_rrc_registeredMME = -1;         /* RegisteredMME */
static int hf_lte_rrc_nonCriticalExtension_139 = -1;  /* RRCConnectionSetupComplete_v8a0_IEs */
static int hf_lte_rrc_nonCriticalExtension_140 = -1;  /* RRCConnectionSetupComplete_v1020_IEs */
static int hf_lte_rrc_gummei_Type_r10 = -1;       /* T_gummei_Type_r10 */
static int hf_lte_rrc_rlf_InfoAvailable_r10_01 = -1;  /* T_rlf_InfoAvailable_r10_01 */
static int hf_lte_rrc_logMeasAvailable_r10_02 = -1;  /* T_logMeasAvailable_r10_02 */
static int hf_lte_rrc_rn_SubframeConfigReq_r10 = -1;  /* T_rn_SubframeConfigReq_r10 */
static int hf_lte_rrc_nonCriticalExtension_141 = -1;  /* RRCConnectionSetupComplete_v1130_IEs */
static int hf_lte_rrc_connEstFailInfoAvailable_r11_02 = -1;  /* T_connEstFailInfoAvailable_r11_02 */
static int hf_lte_rrc_nonCriticalExtension_142 = -1;  /* RRCConnectionSetupComplete_v1250_IEs */
static int hf_lte_rrc_mobilityState_r12 = -1;     /* T_mobilityState_r12 */
static int hf_lte_rrc_mobilityHistoryAvail_r12 = -1;  /* T_mobilityHistoryAvail_r12 */
static int hf_lte_rrc_logMeasAvailableMBSFN_r12_02 = -1;  /* T_logMeasAvailableMBSFN_r12_02 */
static int hf_lte_rrc_nonCriticalExtension_143 = -1;  /* RRCConnectionSetupComplete_v1320_IEs */
static int hf_lte_rrc_ce_ModeB_r13 = -1;          /* T_ce_ModeB_r13 */
static int hf_lte_rrc_s_TMSI_r13 = -1;            /* S_TMSI */
static int hf_lte_rrc_attachWithoutPDN_Connectivity_r13 = -1;  /* T_attachWithoutPDN_Connectivity_r13 */
static int hf_lte_rrc_up_CIoT_EPS_Optimisation_r13 = -1;  /* T_up_CIoT_EPS_Optimisation_r13 */
static int hf_lte_rrc_cp_CIoT_EPS_Optimisation_r13 = -1;  /* T_cp_CIoT_EPS_Optimisation_r13 */
static int hf_lte_rrc_nonCriticalExtension_144 = -1;  /* RRCConnectionSetupComplete_v1330_IEs */
static int hf_lte_rrc_ue_CE_NeedULGaps_r13 = -1;  /* T_ue_CE_NeedULGaps_r13 */
static int hf_lte_rrc_nonCriticalExtension_145 = -1;  /* RRCConnectionSetupComplete_v1430_IEs */
static int hf_lte_rrc_dcn_ID_r14 = -1;            /* INTEGER_0_65535 */
static int hf_lte_rrc_nonCriticalExtension_146 = -1;  /* RRCConnectionSetupComplete_v1530_IEs */
static int hf_lte_rrc_logMeasAvailableBT_r15_03 = -1;  /* T_logMeasAvailableBT_r15_03 */
static int hf_lte_rrc_logMeasAvailableWLAN_r15_03 = -1;  /* T_logMeasAvailableWLAN_r15_03 */
static int hf_lte_rrc_idleMeasAvailable_r15_01 = -1;  /* T_idleMeasAvailable_r15_01 */
static int hf_lte_rrc_flightPathInfoAvailable_r15_03 = -1;  /* T_flightPathInfoAvailable_r15_03 */
static int hf_lte_rrc_connectTo5GC_r15 = -1;      /* T_connectTo5GC_r15 */
static int hf_lte_rrc_registeredAMF_r15 = -1;     /* RegisteredAMF_r15 */
static int hf_lte_rrc_s_NSSAI_list_r15 = -1;      /* SEQUENCE_SIZE_1_maxNrofS_NSSAI_r15_OF_S_NSSAI_r15 */
static int hf_lte_rrc_s_NSSAI_list_r15_item = -1;  /* S_NSSAI_r15 */
static int hf_lte_rrc_ng_5G_S_TMSI_Bits_r15 = -1;  /* T_ng_5G_S_TMSI_Bits_r15 */
static int hf_lte_rrc_ng_5G_S_TMSI_Part2_r15 = -1;  /* BIT_STRING_SIZE_8 */
static int hf_lte_rrc_nonCriticalExtension_147 = -1;  /* RRCConnectionSetupComplete_v1540_IEs */
static int hf_lte_rrc_gummei_Type_v1540 = -1;     /* T_gummei_Type_v1540 */
static int hf_lte_rrc_guami_Type_r15 = -1;        /* T_guami_Type_r15 */
static int hf_lte_rrc_nonCriticalExtension_148 = -1;  /* T_nonCriticalExtension_43 */
static int hf_lte_rrc_plmn_Identity = -1;         /* PLMN_Identity */
static int hf_lte_rrc_mmegi = -1;                 /* BIT_STRING_SIZE_16 */
static int hf_lte_rrc_mmec = -1;                  /* MMEC */
static int hf_lte_rrc_amf_Identifier_r15 = -1;    /* AMF_Identifier_r15 */
static int hf_lte_rrc_criticalExtensions_38 = -1;  /* T_criticalExtensions_38 */
static int hf_lte_rrc_rrcEarlyDataComplete_r15_01 = -1;  /* RRCEarlyDataComplete_r15_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_36 = -1;  /* T_criticalExtensionsFuture_36 */
static int hf_lte_rrc_extendedWaitTime_r15 = -1;  /* INTEGER_1_1800 */
static int hf_lte_rrc_idleModeMobilityControlInfo_r15 = -1;  /* IdleModeMobilityControlInfo */
static int hf_lte_rrc_idleModeMobilityControlInfoExt_r15 = -1;  /* IdleModeMobilityControlInfo_v9e0 */
static int hf_lte_rrc_redirectedCarrierInfo_r15 = -1;  /* RedirectedCarrierInfo_r15_IEs */
static int hf_lte_rrc_nonCriticalExtension_149 = -1;  /* T_nonCriticalExtension_44 */
static int hf_lte_rrc_eutra_r15 = -1;             /* ARFCN_ValueEUTRA_r9 */
static int hf_lte_rrc_geran_r15 = -1;             /* CarrierFreqsGERAN */
static int hf_lte_rrc_utra_FDD_r15 = -1;          /* ARFCN_ValueUTRA */
static int hf_lte_rrc_cdma2000_HRPD_r15 = -1;     /* CarrierFreqCDMA2000 */
static int hf_lte_rrc_cdma2000_1xRTT_r15 = -1;    /* CarrierFreqCDMA2000 */
static int hf_lte_rrc_utra_TDD_r15 = -1;          /* CarrierFreqListUTRA_TDD_r10 */
static int hf_lte_rrc_criticalExtensions_39 = -1;  /* T_criticalExtensions_39 */
static int hf_lte_rrc_rrcEarlyDataRequest_r15_01 = -1;  /* RRCEarlyDataRequest_r15_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_37 = -1;  /* T_criticalExtensionsFuture_37 */
static int hf_lte_rrc_s_TMSI_r15 = -1;            /* S_TMSI */
static int hf_lte_rrc_establishmentCause_r15 = -1;  /* T_establishmentCause_r15 */
static int hf_lte_rrc_nonCriticalExtension_150 = -1;  /* T_nonCriticalExtension_45 */
static int hf_lte_rrc_criticalExtensions_40 = -1;  /* T_criticalExtensions_40 */
static int hf_lte_rrc_c1_37 = -1;                 /* T_c1_37 */
static int hf_lte_rrc_scgFailureInformation_r12_01 = -1;  /* SCGFailureInformation_r12_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_38 = -1;  /* T_criticalExtensionsFuture_38 */
static int hf_lte_rrc_failureReportSCG_r12 = -1;  /* FailureReportSCG_r12 */
static int hf_lte_rrc_nonCriticalExtension_151 = -1;  /* SCGFailureInformation_v12d0a_IEs */
static int hf_lte_rrc_lateNonCriticalExtension_05 = -1;  /* T_lateNonCriticalExtension_04 */
static int hf_lte_rrc_nonCriticalExtension_152 = -1;  /* T_nonCriticalExtension_46 */
static int hf_lte_rrc_failureReportSCG_v12d0 = -1;  /* FailureReportSCG_v12d0 */
static int hf_lte_rrc_nonCriticalExtension_153 = -1;  /* T_nonCriticalExtension_47 */
static int hf_lte_rrc_failureType_r12 = -1;       /* T_failureType_r12 */
static int hf_lte_rrc_measResultServFreqList_r12 = -1;  /* MeasResultServFreqList_r10 */
static int hf_lte_rrc_measResultNeighCells_r12 = -1;  /* MeasResultList2EUTRA_r9 */
static int hf_lte_rrc_failureType_v1290 = -1;     /* T_failureType_v1290 */
static int hf_lte_rrc_measResultServFreqListExt_r13 = -1;  /* MeasResultServFreqListExt_r13 */
static int hf_lte_rrc_measResultNeighCells_v12d0 = -1;  /* MeasResultList2EUTRA_v9e0 */
static int hf_lte_rrc_criticalExtensions_41 = -1;  /* T_criticalExtensions_41 */
static int hf_lte_rrc_c1_38 = -1;                 /* T_c1_38 */
static int hf_lte_rrc_scgFailureInformationNR_r15_01 = -1;  /* SCGFailureInformationNR_r15_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_39 = -1;  /* T_criticalExtensionsFuture_39 */
static int hf_lte_rrc_failureReportSCG_NR_r15 = -1;  /* FailureReportSCG_NR_r15 */
static int hf_lte_rrc_nonCriticalExtension_154 = -1;  /* T_nonCriticalExtension_48 */
static int hf_lte_rrc_failureType_r15 = -1;       /* T_failureType_r15 */
static int hf_lte_rrc_measResultFreqListNR_r15 = -1;  /* MeasResultFreqListFailNR_r15 */
static int hf_lte_rrc_measResultSCG_r15 = -1;     /* T_measResultSCG_r15 */
static int hf_lte_rrc_MeasResultFreqListFailNR_r15_item = -1;  /* MeasResultFreqFailNR_r15 */
static int hf_lte_rrc_measResultCellList_r15 = -1;  /* MeasResultCellListNR_r15 */
static int hf_lte_rrc_sc_mtch_InfoList_r13 = -1;  /* SC_MTCH_InfoList_r13 */
static int hf_lte_rrc_scptm_NeighbourCellList_r13 = -1;  /* SCPTM_NeighbourCellList_r13 */
static int hf_lte_rrc_nonCriticalExtension_155 = -1;  /* SCPTMConfiguration_v1340 */
static int hf_lte_rrc_p_b_r13 = -1;               /* INTEGER_0_3 */
static int hf_lte_rrc_nonCriticalExtension_156 = -1;  /* T_nonCriticalExtension_49 */
static int hf_lte_rrc_sc_mtch_InfoList_r14 = -1;  /* SC_MTCH_InfoList_BR_r14 */
static int hf_lte_rrc_scptm_NeighbourCellList_r14 = -1;  /* SCPTM_NeighbourCellList_r13 */
static int hf_lte_rrc_p_b_r14 = -1;               /* INTEGER_0_3 */
static int hf_lte_rrc_nonCriticalExtension_157 = -1;  /* T_nonCriticalExtension_50 */
static int hf_lte_rrc_criticalExtensions_42 = -1;  /* T_criticalExtensions_42 */
static int hf_lte_rrc_c1_39 = -1;                 /* T_c1_39 */
static int hf_lte_rrc_securityModeCommand_r8 = -1;  /* SecurityModeCommand_r8_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_40 = -1;  /* T_criticalExtensionsFuture_40 */
static int hf_lte_rrc_securityConfigSMC = -1;     /* SecurityConfigSMC */
static int hf_lte_rrc_nonCriticalExtension_158 = -1;  /* SecurityModeCommand_v8a0_IEs */
static int hf_lte_rrc_nonCriticalExtension_159 = -1;  /* T_nonCriticalExtension_51 */
static int hf_lte_rrc_criticalExtensions_43 = -1;  /* T_criticalExtensions_43 */
static int hf_lte_rrc_securityModeComplete_r8 = -1;  /* SecurityModeComplete_r8_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_41 = -1;  /* T_criticalExtensionsFuture_41 */
static int hf_lte_rrc_nonCriticalExtension_160 = -1;  /* SecurityModeComplete_v8a0_IEs */
static int hf_lte_rrc_nonCriticalExtension_161 = -1;  /* T_nonCriticalExtension_52 */
static int hf_lte_rrc_criticalExtensions_44 = -1;  /* T_criticalExtensions_44 */
static int hf_lte_rrc_securityModeFailure_r8 = -1;  /* SecurityModeFailure_r8_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_42 = -1;  /* T_criticalExtensionsFuture_42 */
static int hf_lte_rrc_nonCriticalExtension_162 = -1;  /* SecurityModeFailure_v8a0_IEs */
static int hf_lte_rrc_nonCriticalExtension_163 = -1;  /* T_nonCriticalExtension_53 */
static int hf_lte_rrc_criticalExtensions_45 = -1;  /* T_criticalExtensions_45 */
static int hf_lte_rrc_c1_40 = -1;                 /* T_c1_40 */
static int hf_lte_rrc_sidelinkUEInformation_r12_02 = -1;  /* SidelinkUEInformation_r12_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_43 = -1;  /* T_criticalExtensionsFuture_43 */
static int hf_lte_rrc_commRxInterestedFreq_r12 = -1;  /* ARFCN_ValueEUTRA_r9 */
static int hf_lte_rrc_commTxResourceReq_r12 = -1;  /* SL_CommTxResourceReq_r12 */
static int hf_lte_rrc_discRxInterest_r12 = -1;    /* T_discRxInterest_r12 */
static int hf_lte_rrc_discTxResourceReq_r12 = -1;  /* INTEGER_1_63 */
static int hf_lte_rrc_nonCriticalExtension_164 = -1;  /* SidelinkUEInformation_v1310_IEs */
static int hf_lte_rrc_commTxResourceReqUC_r13 = -1;  /* SL_CommTxResourceReq_r12 */
static int hf_lte_rrc_commTxResourceInfoReqRelay_r13 = -1;  /* T_commTxResourceInfoReqRelay_r13 */
static int hf_lte_rrc_commTxResourceReqRelay_r13 = -1;  /* SL_CommTxResourceReq_r12 */
static int hf_lte_rrc_commTxResourceReqRelayUC_r13 = -1;  /* SL_CommTxResourceReq_r12 */
static int hf_lte_rrc_ue_Type_r13 = -1;           /* T_ue_Type_r13 */
static int hf_lte_rrc_discTxResourceReq_v1310 = -1;  /* T_discTxResourceReq_v1310 */
static int hf_lte_rrc_carrierFreqDiscTx_r13 = -1;  /* INTEGER_1_maxFreq */
static int hf_lte_rrc_discTxResourceReqAddFreq_r13 = -1;  /* SL_DiscTxResourceReqPerFreqList_r13 */
static int hf_lte_rrc_discTxResourceReqPS_r13 = -1;  /* SL_DiscTxResourceReq_r13 */
static int hf_lte_rrc_discRxGapReq_r13 = -1;      /* SL_GapRequest_r13 */
static int hf_lte_rrc_discTxGapReq_r13 = -1;      /* SL_GapRequest_r13 */
static int hf_lte_rrc_discSysInfoReportFreqList_r13 = -1;  /* SL_DiscSysInfoReportFreqList_r13 */
static int hf_lte_rrc_nonCriticalExtension_165 = -1;  /* SidelinkUEInformation_v1430_IEs */
static int hf_lte_rrc_v2x_CommRxInterestedFreqList_r14 = -1;  /* SL_V2X_CommFreqList_r14 */
static int hf_lte_rrc_p2x_CommTxType_r14 = -1;    /* T_p2x_CommTxType_r14 */
static int hf_lte_rrc_v2x_CommTxResourceReq_r14 = -1;  /* SL_V2X_CommTxFreqList_r14 */
static int hf_lte_rrc_nonCriticalExtension_166 = -1;  /* SidelinkUEInformation_v1530_IEs */
static int hf_lte_rrc_reliabilityInfoListSL_r15 = -1;  /* SL_ReliabilityList_r15 */
static int hf_lte_rrc_nonCriticalExtension_167 = -1;  /* T_nonCriticalExtension_54 */
static int hf_lte_rrc_destinationInfoList_r12 = -1;  /* SL_DestinationInfoList_r12 */
static int hf_lte_rrc_SL_DiscTxResourceReqPerFreqList_r13_item = -1;  /* SL_DiscTxResourceReq_r13 */
static int hf_lte_rrc_discTxResourceReq_r13 = -1;  /* INTEGER_1_63 */
static int hf_lte_rrc_SL_DestinationInfoList_r12_item = -1;  /* SL_DestinationIdentity_r12 */
static int hf_lte_rrc_SL_DiscSysInfoReportFreqList_r13_item = -1;  /* SL_DiscSysInfoReport_r13 */
static int hf_lte_rrc_SL_V2X_CommFreqList_r14_item = -1;  /* INTEGER_0_maxFreqV2X_1_r14 */
static int hf_lte_rrc_SL_V2X_CommTxFreqList_r14_item = -1;  /* SL_V2X_CommTxResourceReq_r14 */
static int hf_lte_rrc_carrierFreqCommTx_r14 = -1;  /* INTEGER_0_maxFreqV2X_1_r14 */
static int hf_lte_rrc_v2x_TypeTxSync_r14 = -1;    /* SL_TypeTxSync_r14 */
static int hf_lte_rrc_v2x_DestinationInfoList_r14 = -1;  /* SL_DestinationInfoList_r12 */
static int hf_lte_rrc_criticalExtensions_46 = -1;  /* T_criticalExtensions_46 */
static int hf_lte_rrc_systemInformation_r8 = -1;  /* SystemInformation_r8_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_r15 = -1;  /* T_criticalExtensionsFuture_r15 */
static int hf_lte_rrc_posSystemInformation_r15 = -1;  /* PosSystemInformation_r15_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_44 = -1;  /* T_criticalExtensionsFuture_44 */
static int hf_lte_rrc_sib_TypeAndInfo = -1;       /* T_sib_TypeAndInfo */
static int hf_lte_rrc_sib_TypeAndInfo_item = -1;  /* T_sib_TypeAndInfo_item */
static int hf_lte_rrc_sib2 = -1;                  /* SystemInformationBlockType2 */
static int hf_lte_rrc_sib3 = -1;                  /* SystemInformationBlockType3 */
static int hf_lte_rrc_sib4 = -1;                  /* SystemInformationBlockType4 */
static int hf_lte_rrc_sib5 = -1;                  /* SystemInformationBlockType5 */
static int hf_lte_rrc_sib6 = -1;                  /* SystemInformationBlockType6 */
static int hf_lte_rrc_sib7 = -1;                  /* SystemInformationBlockType7 */
static int hf_lte_rrc_sib8 = -1;                  /* SystemInformationBlockType8 */
static int hf_lte_rrc_sib9 = -1;                  /* SystemInformationBlockType9 */
static int hf_lte_rrc_sib10 = -1;                 /* SystemInformationBlockType10 */
static int hf_lte_rrc_sib11 = -1;                 /* SystemInformationBlockType11 */
static int hf_lte_rrc_sib12_v920 = -1;            /* SystemInformationBlockType12_r9 */
static int hf_lte_rrc_sib13_v920 = -1;            /* SystemInformationBlockType13_r9 */
static int hf_lte_rrc_sib14_v1130 = -1;           /* SystemInformationBlockType14_r11 */
static int hf_lte_rrc_sib15_v1130 = -1;           /* SystemInformationBlockType15_r11 */
static int hf_lte_rrc_sib16_v1130 = -1;           /* SystemInformationBlockType16_r11 */
static int hf_lte_rrc_sib17_v1250 = -1;           /* SystemInformationBlockType17_r12 */
static int hf_lte_rrc_sib18_v1250 = -1;           /* SystemInformationBlockType18_r12 */
static int hf_lte_rrc_sib19_v1250 = -1;           /* SystemInformationBlockType19_r12 */
static int hf_lte_rrc_sib20_v1310 = -1;           /* SystemInformationBlockType20_r13 */
static int hf_lte_rrc_sib21_v1430 = -1;           /* SystemInformationBlockType21_r14 */
static int hf_lte_rrc_sib24_v1530 = -1;           /* SystemInformationBlockType24_r15 */
static int hf_lte_rrc_sib25_v1530 = -1;           /* SystemInformationBlockType25_r15 */
static int hf_lte_rrc_sib26_v1530 = -1;           /* SystemInformationBlockType26_r15 */
static int hf_lte_rrc_nonCriticalExtension_168 = -1;  /* SystemInformation_v8a0_IEs */
static int hf_lte_rrc_nonCriticalExtension_169 = -1;  /* T_nonCriticalExtension_55 */
static int hf_lte_rrc_posSIB_TypeAndInfo_r15 = -1;  /* T_posSIB_TypeAndInfo_r15 */
static int hf_lte_rrc_posSIB_TypeAndInfo_r15_item = -1;  /* T_posSIB_TypeAndInfo_r15_item */
static int hf_lte_rrc_posSib1_1_r15 = -1;         /* SystemInformationBlockPos_r15 */
static int hf_lte_rrc_posSib1_2_r15 = -1;         /* SystemInformationBlockPos_r15 */
static int hf_lte_rrc_posSib1_3_r15 = -1;         /* SystemInformationBlockPos_r15 */
static int hf_lte_rrc_posSib1_4_r15 = -1;         /* SystemInformationBlockPos_r15 */
static int hf_lte_rrc_posSib1_5_r15 = -1;         /* SystemInformationBlockPos_r15 */
static int hf_lte_rrc_posSib1_6_r15 = -1;         /* SystemInformationBlockPos_r15 */
static int hf_lte_rrc_posSib1_7_r15 = -1;         /* SystemInformationBlockPos_r15 */
static int hf_lte_rrc_posSib2_1_r15 = -1;         /* SystemInformationBlockPos_r15 */
static int hf_lte_rrc_posSib2_2_r15 = -1;         /* SystemInformationBlockPos_r15 */
static int hf_lte_rrc_posSib2_3_r15 = -1;         /* SystemInformationBlockPos_r15 */
static int hf_lte_rrc_posSib2_4_r15 = -1;         /* SystemInformationBlockPos_r15 */
static int hf_lte_rrc_posSib2_5_r15 = -1;         /* SystemInformationBlockPos_r15 */
static int hf_lte_rrc_posSib2_6_r15 = -1;         /* SystemInformationBlockPos_r15 */
static int hf_lte_rrc_posSib2_7_r15 = -1;         /* SystemInformationBlockPos_r15 */
static int hf_lte_rrc_posSib2_8_r15 = -1;         /* SystemInformationBlockPos_r15 */
static int hf_lte_rrc_posSib2_9_r15 = -1;         /* SystemInformationBlockPos_r15 */
static int hf_lte_rrc_posSib2_10_r15 = -1;        /* SystemInformationBlockPos_r15 */
static int hf_lte_rrc_posSib2_11_r15 = -1;        /* SystemInformationBlockPos_r15 */
static int hf_lte_rrc_posSib2_12_r15 = -1;        /* SystemInformationBlockPos_r15 */
static int hf_lte_rrc_posSib2_13_r15 = -1;        /* SystemInformationBlockPos_r15 */
static int hf_lte_rrc_posSib2_14_r15 = -1;        /* SystemInformationBlockPos_r15 */
static int hf_lte_rrc_posSib2_15_r15 = -1;        /* SystemInformationBlockPos_r15 */
static int hf_lte_rrc_posSib2_16_r15 = -1;        /* SystemInformationBlockPos_r15 */
static int hf_lte_rrc_posSib2_17_r15 = -1;        /* SystemInformationBlockPos_r15 */
static int hf_lte_rrc_posSib2_18_r15 = -1;        /* SystemInformationBlockPos_r15 */
static int hf_lte_rrc_posSib2_19_r15 = -1;        /* SystemInformationBlockPos_r15 */
static int hf_lte_rrc_posSib3_1_r15 = -1;         /* SystemInformationBlockPos_r15 */
static int hf_lte_rrc_nonCriticalExtension_170 = -1;  /* T_nonCriticalExtension_56 */
static int hf_lte_rrc_cellAccessRelatedInfo = -1;  /* T_cellAccessRelatedInfo */
static int hf_lte_rrc_plmn_IdentityList = -1;     /* PLMN_IdentityList */
static int hf_lte_rrc_trackingAreaCode = -1;      /* TrackingAreaCode */
static int hf_lte_rrc_cellBarred = -1;            /* T_cellBarred */
static int hf_lte_rrc_intraFreqReselection = -1;  /* T_intraFreqReselection */
static int hf_lte_rrc_csg_Indication = -1;        /* BOOLEAN */
static int hf_lte_rrc_csg_Identity = -1;          /* CSG_Identity */
static int hf_lte_rrc_cellSelectionInfo = -1;     /* T_cellSelectionInfo */
static int hf_lte_rrc_q_RxLevMin = -1;            /* Q_RxLevMin */
static int hf_lte_rrc_q_RxLevMinOffset = -1;      /* INTEGER_1_8 */
static int hf_lte_rrc_p_Max = -1;                 /* P_Max */
static int hf_lte_rrc_freqBandIndicator = -1;     /* FreqBandIndicator */
static int hf_lte_rrc_schedulingInfoList = -1;    /* SchedulingInfoList */
static int hf_lte_rrc_tdd_Config = -1;            /* TDD_Config */
static int hf_lte_rrc_si_WindowLength = -1;       /* T_si_WindowLength */
static int hf_lte_rrc_systemInfoValueTag = -1;    /* T_systemInfoValueTag */
static int hf_lte_rrc_nonCriticalExtension_171 = -1;  /* SystemInformationBlockType1_v890_IEs */
static int hf_lte_rrc_lateNonCriticalExtension_06 = -1;  /* T_lateNonCriticalExtension_05 */
static int hf_lte_rrc_nonCriticalExtension_172 = -1;  /* SystemInformationBlockType1_v920_IEs */
static int hf_lte_rrc_multiBandInfoList = -1;     /* MultiBandInfoList */
static int hf_lte_rrc_nonCriticalExtension_173 = -1;  /* SystemInformationBlockType1_v9e0_IEs */
static int hf_lte_rrc_freqBandIndicator_v9e0 = -1;  /* FreqBandIndicator_v9e0 */
static int hf_lte_rrc_multiBandInfoList_v9e0 = -1;  /* MultiBandInfoList_v9e0 */
static int hf_lte_rrc_nonCriticalExtension_174 = -1;  /* SystemInformationBlockType1_v10j0_IEs */
static int hf_lte_rrc_freqBandInfo_r10 = -1;      /* NS_PmaxList_r10 */
static int hf_lte_rrc_multiBandInfoList_v10j0 = -1;  /* MultiBandInfoList_v10j0 */
static int hf_lte_rrc_nonCriticalExtension_175 = -1;  /* SystemInformationBlockType1_v10l0_IEs */
static int hf_lte_rrc_freqBandInfo_v10l0 = -1;    /* NS_PmaxList_v10l0 */
static int hf_lte_rrc_multiBandInfoList_v10l0 = -1;  /* MultiBandInfoList_v10l0 */
static int hf_lte_rrc_nonCriticalExtension_176 = -1;  /* T_nonCriticalExtension_57 */
static int hf_lte_rrc_ims_EmergencySupport_r9 = -1;  /* T_ims_EmergencySupport_r9 */
static int hf_lte_rrc_cellSelectionInfo_v920 = -1;  /* CellSelectionInfo_v920 */
static int hf_lte_rrc_nonCriticalExtension_177 = -1;  /* SystemInformationBlockType1_v1130_IEs */
static int hf_lte_rrc_tdd_Config_v1130 = -1;      /* TDD_Config_v1130 */
static int hf_lte_rrc_cellSelectionInfo_v1130 = -1;  /* CellSelectionInfo_v1130 */
static int hf_lte_rrc_nonCriticalExtension_178 = -1;  /* SystemInformationBlockType1_v1250_IEs */
static int hf_lte_rrc_cellAccessRelatedInfo_v1250 = -1;  /* T_cellAccessRelatedInfo_v1250 */
static int hf_lte_rrc_category0Allowed_r12 = -1;  /* T_category0Allowed_r12 */
static int hf_lte_rrc_cellSelectionInfo_v1250 = -1;  /* CellSelectionInfo_v1250 */
static int hf_lte_rrc_freqBandIndicatorPriority_r12 = -1;  /* T_freqBandIndicatorPriority_r12 */
static int hf_lte_rrc_nonCriticalExtension_179 = -1;  /* SystemInformationBlockType1_v1310_IEs */
static int hf_lte_rrc_hyperSFN_r13 = -1;          /* BIT_STRING_SIZE_10 */
static int hf_lte_rrc_eDRX_Allowed_r13 = -1;      /* T_eDRX_Allowed_r13 */
static int hf_lte_rrc_cellSelectionInfoCE_r13 = -1;  /* CellSelectionInfoCE_r13 */
static int hf_lte_rrc_bandwidthReducedAccessRelatedInfo_r13 = -1;  /* T_bandwidthReducedAccessRelatedInfo_r13 */
static int hf_lte_rrc_si_WindowLength_BR_r13 = -1;  /* T_si_WindowLength_BR_r13 */
static int hf_lte_rrc_si_RepetitionPattern_r13 = -1;  /* T_si_RepetitionPattern_r13 */
static int hf_lte_rrc_schedulingInfoList_BR_r13 = -1;  /* SchedulingInfoList_BR_r13 */
static int hf_lte_rrc_fdd_DownlinkOrTddSubframeBitmapBR_r13 = -1;  /* T_fdd_DownlinkOrTddSubframeBitmapBR_r13 */
static int hf_lte_rrc_subframePattern10_r13 = -1;  /* BIT_STRING_SIZE_10 */
static int hf_lte_rrc_subframePattern40_r13 = -1;  /* BIT_STRING_SIZE_40 */
static int hf_lte_rrc_fdd_UplinkSubframeBitmapBR_r13 = -1;  /* BIT_STRING_SIZE_10 */
static int hf_lte_rrc_startSymbolBR_r13 = -1;     /* INTEGER_1_4 */
static int hf_lte_rrc_si_HoppingConfigCommon_r13 = -1;  /* T_si_HoppingConfigCommon_r13 */
static int hf_lte_rrc_si_ValidityTime_r13 = -1;   /* T_si_ValidityTime_r13 */
static int hf_lte_rrc_systemInfoValueTagList_r13 = -1;  /* SystemInfoValueTagList_r13 */
static int hf_lte_rrc_nonCriticalExtension_180 = -1;  /* SystemInformationBlockType1_v1320_IEs */
static int hf_lte_rrc_freqHoppingParametersDL_r13 = -1;  /* T_freqHoppingParametersDL_r13 */
static int hf_lte_rrc_mpdcch_pdsch_HoppingNB_r13 = -1;  /* T_mpdcch_pdsch_HoppingNB_r13 */
static int hf_lte_rrc_interval_DLHoppingConfigCommonModeA_r13 = -1;  /* T_interval_DLHoppingConfigCommonModeA_r13 */
static int hf_lte_rrc_interval_FDD_r13 = -1;      /* T_interval_FDD_r13 */
static int hf_lte_rrc_interval_TDD_r13 = -1;      /* T_interval_TDD_r13 */
static int hf_lte_rrc_interval_DLHoppingConfigCommonModeB_r13 = -1;  /* T_interval_DLHoppingConfigCommonModeB_r13 */
static int hf_lte_rrc_interval_FDD_r13_01 = -1;   /* T_interval_FDD_r13_01 */
static int hf_lte_rrc_interval_TDD_r13_01 = -1;   /* T_interval_TDD_r13_01 */
static int hf_lte_rrc_mpdcch_pdsch_HoppingOffset_r13 = -1;  /* INTEGER_1_maxAvailNarrowBands_r13 */
static int hf_lte_rrc_nonCriticalExtension_181 = -1;  /* SystemInformationBlockType1_v1350_IEs */
static int hf_lte_rrc_cellSelectionInfoCE1_r13 = -1;  /* CellSelectionInfoCE1_r13 */
static int hf_lte_rrc_nonCriticalExtension_182 = -1;  /* SystemInformationBlockType1_v1360_IEs */
static int hf_lte_rrc_cellSelectionInfoCE1_v1360 = -1;  /* CellSelectionInfoCE1_v1360 */
static int hf_lte_rrc_nonCriticalExtension_183 = -1;  /* SystemInformationBlockType1_v1430_IEs */
static int hf_lte_rrc_eCallOverIMS_Support_r14 = -1;  /* T_eCallOverIMS_Support_r14 */
static int hf_lte_rrc_tdd_Config_v1430 = -1;      /* TDD_Config_v1430 */
static int hf_lte_rrc_cellAccessRelatedInfoList_r14 = -1;  /* SEQUENCE_SIZE_1_maxPLMN_1_r14_OF_CellAccessRelatedInfo_r14 */
static int hf_lte_rrc_cellAccessRelatedInfoList_r14_item = -1;  /* CellAccessRelatedInfo_r14 */
static int hf_lte_rrc_nonCriticalExtension_184 = -1;  /* SystemInformationBlockType1_v1450_IEs */
static int hf_lte_rrc_tdd_Config_v1450 = -1;      /* TDD_Config_v1450 */
static int hf_lte_rrc_nonCriticalExtension_185 = -1;  /* SystemInformationBlockType1_v1530_IEs */
static int hf_lte_rrc_hsdn_Cell_r15 = -1;         /* T_hsdn_Cell_r15 */
static int hf_lte_rrc_cellSelectionInfoCE_v1530 = -1;  /* CellSelectionInfoCE_v1530 */
static int hf_lte_rrc_crs_IntfMitigConfig_r15 = -1;  /* T_crs_IntfMitigConfig_r15 */
static int hf_lte_rrc_crs_IntfMitigEnabled_15 = -1;  /* NULL */
static int hf_lte_rrc_crs_IntfMitigNumPRBs_r15 = -1;  /* T_crs_IntfMitigNumPRBs_r15 */
static int hf_lte_rrc_cellBarred_CRS_r15 = -1;    /* T_cellBarred_CRS_r15 */
static int hf_lte_rrc_plmn_IdentityList_v1530 = -1;  /* PLMN_IdentityList_v1530 */
static int hf_lte_rrc_posSchedulingInfoList_r15 = -1;  /* PosSchedulingInfoList_r15 */
static int hf_lte_rrc_cellAccessRelatedInfo_5GC_r15 = -1;  /* T_cellAccessRelatedInfo_5GC_r15 */
static int hf_lte_rrc_cellBarred_5GC_r15 = -1;    /* T_cellBarred_5GC_r15 */
static int hf_lte_rrc_cellBarred_5GC_CRS_r15 = -1;  /* T_cellBarred_5GC_CRS_r15 */
static int hf_lte_rrc_cellAccessRelatedInfoList_5GC_r15 = -1;  /* SEQUENCE_SIZE_1_maxPLMN_r11_OF_CellAccessRelatedInfo_5GC_r15 */
static int hf_lte_rrc_cellAccessRelatedInfoList_5GC_r15_item = -1;  /* CellAccessRelatedInfo_5GC_r15 */
static int hf_lte_rrc_ims_EmergencySupport5GC_r15 = -1;  /* T_ims_EmergencySupport5GC_r15 */
static int hf_lte_rrc_eCallOverIMS_Support5GC_r15 = -1;  /* T_eCallOverIMS_Support5GC_r15 */
static int hf_lte_rrc_nonCriticalExtension_186 = -1;  /* SystemInformationBlockType1_v1540_IEs */
static int hf_lte_rrc_si_posOffset_r15 = -1;      /* T_si_posOffset_r15 */
static int hf_lte_rrc_nonCriticalExtension_187 = -1;  /* T_nonCriticalExtension_58 */
static int hf_lte_rrc_PLMN_IdentityList_item = -1;  /* PLMN_IdentityInfo */
static int hf_lte_rrc_cellReservedForOperatorUse = -1;  /* T_cellReservedForOperatorUse */
static int hf_lte_rrc_PLMN_IdentityList_v1530_item = -1;  /* PLMN_IdentityInfo_v1530 */
static int hf_lte_rrc_cellReservedForOperatorUse_CRS_r15 = -1;  /* T_cellReservedForOperatorUse_CRS_r15 */
static int hf_lte_rrc_PLMN_IdentityList_r15_item = -1;  /* PLMN_IdentityInfo_r15 */
static int hf_lte_rrc_plmn_Identity_5GC_r15 = -1;  /* T_plmn_Identity_5GC_r15 */
static int hf_lte_rrc_plmn_Index_r15 = -1;        /* INTEGER_1_maxPLMN_r11 */
static int hf_lte_rrc_cellReservedForOperatorUse_r15 = -1;  /* T_cellReservedForOperatorUse_r15 */
static int hf_lte_rrc_cellReservedForOperatorUse_CRS_r15_01 = -1;  /* T_cellReservedForOperatorUse_CRS_r15_01 */
static int hf_lte_rrc_SchedulingInfoList_item = -1;  /* SchedulingInfo */
static int hf_lte_rrc_si_Periodicity = -1;        /* T_si_Periodicity */
static int hf_lte_rrc_sib_MappingInfo = -1;       /* SIB_MappingInfo */
static int hf_lte_rrc_SchedulingInfoList_BR_r13_item = -1;  /* SchedulingInfo_BR_r13 */
static int hf_lte_rrc_si_Narrowband_r13 = -1;     /* INTEGER_1_maxAvailNarrowBands_r13 */
static int hf_lte_rrc_si_TBS_r13 = -1;            /* T_si_TBS_r13 */
static int hf_lte_rrc_SIB_MappingInfo_item = -1;  /* SIB_Type */
static int hf_lte_rrc_SystemInfoValueTagList_r13_item = -1;  /* SystemInfoValueTagSI_r13 */
static int hf_lte_rrc_q_QualMin_r9 = -1;          /* Q_QualMin_r9 */
static int hf_lte_rrc_q_QualMinOffset_r9 = -1;    /* INTEGER_1_8 */
static int hf_lte_rrc_q_QualMinWB_r11 = -1;       /* Q_QualMin_r9 */
static int hf_lte_rrc_q_QualMinRSRQ_OnAllSymbols_r12 = -1;  /* Q_QualMin_r9 */
static int hf_lte_rrc_plmn_IdentityList_r14 = -1;  /* PLMN_IdentityList */
static int hf_lte_rrc_trackingAreaCode_r14 = -1;  /* TrackingAreaCode */
static int hf_lte_rrc_cellIdentity_r14 = -1;      /* CellIdentity */
static int hf_lte_rrc_plmn_IdentityList_r15 = -1;  /* PLMN_IdentityList_r15 */
static int hf_lte_rrc_ran_AreaCode_r15 = -1;      /* RAN_AreaCode_r15 */
static int hf_lte_rrc_cellIdentity_5GC_r15 = -1;  /* CellIdentity_5GC_r15 */
static int hf_lte_rrc_cellIdentity_r15 = -1;      /* CellIdentity */
static int hf_lte_rrc_cellId_Index_r15 = -1;      /* INTEGER_1_maxPLMN_r11 */
static int hf_lte_rrc_PosSchedulingInfoList_r15_item = -1;  /* PosSchedulingInfo_r15 */
static int hf_lte_rrc_posSI_Periodicity_r15 = -1;  /* T_posSI_Periodicity_r15 */
static int hf_lte_rrc_posSIB_MappingInfo_r15 = -1;  /* PosSIB_MappingInfo_r15 */
static int hf_lte_rrc_PosSIB_MappingInfo_r15_item = -1;  /* PosSIB_Type_r15 */
static int hf_lte_rrc_encrypted_r15 = -1;         /* T_encrypted_r15 */
static int hf_lte_rrc_gnss_id_r15 = -1;           /* GNSS_ID_r15 */
static int hf_lte_rrc_sbas_id_r15 = -1;           /* SBAS_ID_r15 */
static int hf_lte_rrc_posSibType_r15 = -1;        /* T_posSibType_r15 */
static int hf_lte_rrc_cellAccessRelatedInfo_r14 = -1;  /* T_cellAccessRelatedInfo_r14 */
static int hf_lte_rrc_plmn_IdentityList_r14_01 = -1;  /* PLMN_IdentityList_MBMS_r14 */
static int hf_lte_rrc_freqBandIndicator_r14 = -1;  /* FreqBandIndicator_r11 */
static int hf_lte_rrc_multiBandInfoList_r14 = -1;  /* MultiBandInfoList_r11 */
static int hf_lte_rrc_schedulingInfoList_MBMS_r14 = -1;  /* SchedulingInfoList_MBMS_r14 */
static int hf_lte_rrc_si_WindowLength_r14 = -1;   /* T_si_WindowLength_r14 */
static int hf_lte_rrc_systemInfoValueTag_r14 = -1;  /* INTEGER_0_31 */
static int hf_lte_rrc_nonMBSFN_SubframeConfig_r14 = -1;  /* NonMBSFN_SubframeConfig_r14 */
static int hf_lte_rrc_pdsch_ConfigCommon_r14 = -1;  /* PDSCH_ConfigCommon */
static int hf_lte_rrc_systemInformationBlockType13_r14 = -1;  /* SystemInformationBlockType13_r9 */
static int hf_lte_rrc_nonCriticalExtension_188 = -1;  /* T_nonCriticalExtension_59 */
static int hf_lte_rrc_PLMN_IdentityList_MBMS_r14_item = -1;  /* PLMN_Identity */
static int hf_lte_rrc_SchedulingInfoList_MBMS_r14_item = -1;  /* SchedulingInfo_MBMS_r14 */
static int hf_lte_rrc_si_Periodicity_r14 = -1;    /* T_si_Periodicity_r14 */
static int hf_lte_rrc_sib_MappingInfo_r14 = -1;   /* SIB_MappingInfo_MBMS_r14 */
static int hf_lte_rrc_SIB_MappingInfo_MBMS_r14_item = -1;  /* SIB_Type_MBMS_r14 */
static int hf_lte_rrc_radioFrameAllocationPeriod_r14 = -1;  /* T_radioFrameAllocationPeriod_r14 */
static int hf_lte_rrc_radioFrameAllocationOffset_r14 = -1;  /* INTEGER_0_7 */
static int hf_lte_rrc_subframeAllocation_r14 = -1;  /* BIT_STRING_SIZE_9 */
static int hf_lte_rrc_criticalExtensions_47 = -1;  /* T_criticalExtensions_47 */
static int hf_lte_rrc_c1_41 = -1;                 /* T_c1_41 */
static int hf_lte_rrc_ueAssistanceInformation_r11_01 = -1;  /* UEAssistanceInformation_r11_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_45 = -1;  /* T_criticalExtensionsFuture_45 */
static int hf_lte_rrc_powerPrefIndication_r11_01 = -1;  /* T_powerPrefIndication_r11_01 */
static int hf_lte_rrc_nonCriticalExtension_189 = -1;  /* UEAssistanceInformation_v1430_IEs */
static int hf_lte_rrc_bw_Preference_r14 = -1;     /* BW_Preference_r14 */
static int hf_lte_rrc_sps_AssistanceInformation_r14 = -1;  /* T_sps_AssistanceInformation_r14 */
static int hf_lte_rrc_trafficPatternInfoListSL_r14 = -1;  /* TrafficPatternInfoList_r14 */
static int hf_lte_rrc_trafficPatternInfoListUL_r14 = -1;  /* TrafficPatternInfoList_r14 */
static int hf_lte_rrc_rlm_Report_r14 = -1;        /* T_rlm_Report_r14 */
static int hf_lte_rrc_rlm_Event_r14 = -1;         /* T_rlm_Event_r14 */
static int hf_lte_rrc_excessRep_MPDCCH_r14 = -1;  /* T_excessRep_MPDCCH_r14 */
static int hf_lte_rrc_delayBudgetReport_r14 = -1;  /* DelayBudgetReport_r14 */
static int hf_lte_rrc_nonCriticalExtension_190 = -1;  /* UEAssistanceInformation_v1450_IEs */
static int hf_lte_rrc_overheatingAssistance_r14 = -1;  /* OverheatingAssistance_r14 */
static int hf_lte_rrc_nonCriticalExtension_191 = -1;  /* UEAssistanceInformation_v1530_IEs */
static int hf_lte_rrc_sps_AssistanceInformation_v1530 = -1;  /* T_sps_AssistanceInformation_v1530 */
static int hf_lte_rrc_trafficPatternInfoListSL_v1530 = -1;  /* TrafficPatternInfoList_v1530 */
static int hf_lte_rrc_nonCriticalExtension_192 = -1;  /* T_nonCriticalExtension_60 */
static int hf_lte_rrc_dl_Preference_r14 = -1;     /* T_dl_Preference_r14 */
static int hf_lte_rrc_ul_Preference_r14 = -1;     /* T_ul_Preference_r14 */
static int hf_lte_rrc_TrafficPatternInfoList_r14_item = -1;  /* TrafficPatternInfo_r14 */
static int hf_lte_rrc_trafficPeriodicity_r14 = -1;  /* T_trafficPeriodicity_r14 */
static int hf_lte_rrc_timingOffset_r14 = -1;      /* INTEGER_0_10239 */
static int hf_lte_rrc_priorityInfoSL_r14 = -1;    /* SL_Priority_r13 */
static int hf_lte_rrc_logicalChannelIdentityUL_r14 = -1;  /* INTEGER_3_10 */
static int hf_lte_rrc_messageSize_r14 = -1;       /* T_messageSize_r14 */
static int hf_lte_rrc_TrafficPatternInfoList_v1530_item = -1;  /* TrafficPatternInfo_v1530 */
static int hf_lte_rrc_trafficDestination_r15 = -1;  /* SL_DestinationIdentity_r12 */
static int hf_lte_rrc_reliabilityInfoSL_r15 = -1;  /* SL_Reliability_r15 */
static int hf_lte_rrc_type1 = -1;                 /* T_type1 */
static int hf_lte_rrc_type2 = -1;                 /* T_type2 */
static int hf_lte_rrc_reducedUE_Category = -1;    /* T_reducedUE_Category */
static int hf_lte_rrc_reducedUE_CategoryDL = -1;  /* INTEGER_0_19 */
static int hf_lte_rrc_reducedUE_CategoryUL = -1;  /* INTEGER_0_21 */
static int hf_lte_rrc_reducedMaxCCs = -1;         /* T_reducedMaxCCs */
static int hf_lte_rrc_reducedCCsDL = -1;          /* INTEGER_0_31 */
static int hf_lte_rrc_reducedCCsUL = -1;          /* INTEGER_0_31 */
static int hf_lte_rrc_criticalExtensions_48 = -1;  /* T_criticalExtensions_48 */
static int hf_lte_rrc_c1_42 = -1;                 /* T_c1_42 */
static int hf_lte_rrc_ueCapabilityEnquiry_r8 = -1;  /* UECapabilityEnquiry_r8_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_46 = -1;  /* T_criticalExtensionsFuture_46 */
static int hf_lte_rrc_ue_CapabilityRequest = -1;  /* UE_CapabilityRequest */
static int hf_lte_rrc_nonCriticalExtension_193 = -1;  /* UECapabilityEnquiry_v8a0_IEs */
static int hf_lte_rrc_nonCriticalExtension_194 = -1;  /* UECapabilityEnquiry_v1180_IEs */
static int hf_lte_rrc_requestedFrequencyBands_r11 = -1;  /* SEQUENCE_SIZE_1_16_OF_FreqBandIndicator_r11 */
static int hf_lte_rrc_requestedFrequencyBands_r11_item = -1;  /* FreqBandIndicator_r11 */
static int hf_lte_rrc_nonCriticalExtension_195 = -1;  /* UECapabilityEnquiry_v1310_IEs */
static int hf_lte_rrc_requestReducedFormat_r13 = -1;  /* T_requestReducedFormat_r13 */
static int hf_lte_rrc_requestSkipFallbackComb_r13 = -1;  /* T_requestSkipFallbackComb_r13 */
static int hf_lte_rrc_requestedMaxCCsDL_r13 = -1;  /* INTEGER_2_32 */
static int hf_lte_rrc_requestedMaxCCsUL_r13 = -1;  /* INTEGER_2_32 */
static int hf_lte_rrc_requestReducedIntNonContComb_r13 = -1;  /* T_requestReducedIntNonContComb_r13 */
static int hf_lte_rrc_nonCriticalExtension_196 = -1;  /* UECapabilityEnquiry_v1430_IEs */
static int hf_lte_rrc_requestDiffFallbackCombList_r14 = -1;  /* BandCombinationList_r14 */
static int hf_lte_rrc_nonCriticalExtension_197 = -1;  /* UECapabilityEnquiry_v1510_IEs */
static int hf_lte_rrc_requestedFreqBandsNR_MRDC_r15 = -1;  /* T_requestedFreqBandsNR_MRDC_r15 */
static int hf_lte_rrc_nonCriticalExtension_198 = -1;  /* UECapabilityEnquiry_v1530_IEs */
static int hf_lte_rrc_requestSTTI_SPT_Capability_r15 = -1;  /* T_requestSTTI_SPT_Capability_r15 */
static int hf_lte_rrc_eutra_nr_only_r15 = -1;     /* T_eutra_nr_only_r15 */
static int hf_lte_rrc_nonCriticalExtension_199 = -1;  /* UECapabilityEnquiry_v1550_IEs */
static int hf_lte_rrc_requestedCapabilityNR_r15 = -1;  /* T_requestedCapabilityNR_r15 */
static int hf_lte_rrc_nonCriticalExtension_200 = -1;  /* UECapabilityEnquiry_v1560_IEs */
static int hf_lte_rrc_requestedCapabilityCommon_r15 = -1;  /* T_requestedCapabilityCommon_r15 */
static int hf_lte_rrc_nonCriticalExtension_201 = -1;  /* T_nonCriticalExtension_61 */
static int hf_lte_rrc_UE_CapabilityRequest_item = -1;  /* RAT_Type */
static int hf_lte_rrc_criticalExtensions_49 = -1;  /* T_criticalExtensions_49 */
static int hf_lte_rrc_c1_43 = -1;                 /* T_c1_43 */
static int hf_lte_rrc_ueCapabilityInformation_r8 = -1;  /* UECapabilityInformation_r8_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_47 = -1;  /* T_criticalExtensionsFuture_47 */
static int hf_lte_rrc_ue_CapabilityRAT_ContainerList = -1;  /* UE_CapabilityRAT_ContainerList */
static int hf_lte_rrc_nonCriticalExtension_202 = -1;  /* UECapabilityInformation_v8a0_IEs */
static int hf_lte_rrc_nonCriticalExtension_203 = -1;  /* UECapabilityInformation_v1250_IEs */
static int hf_lte_rrc_ue_RadioPagingInfo_r12_01 = -1;  /* UE_RadioPagingInfo_r12 */
static int hf_lte_rrc_nonCriticalExtension_204 = -1;  /* T_nonCriticalExtension_62 */
static int hf_lte_rrc_criticalExtensions_50 = -1;  /* T_criticalExtensions_50 */
static int hf_lte_rrc_c1_44 = -1;                 /* T_c1_44 */
static int hf_lte_rrc_ueInformationRequest_r9_01 = -1;  /* UEInformationRequest_r9_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_48 = -1;  /* T_criticalExtensionsFuture_48 */
static int hf_lte_rrc_rach_ReportReq_r9 = -1;     /* BOOLEAN */
static int hf_lte_rrc_rlf_ReportReq_r9 = -1;      /* BOOLEAN */
static int hf_lte_rrc_nonCriticalExtension_205 = -1;  /* UEInformationRequest_v930_IEs */
static int hf_lte_rrc_nonCriticalExtension_206 = -1;  /* UEInformationRequest_v1020_IEs */
static int hf_lte_rrc_logMeasReportReq_r10 = -1;  /* T_logMeasReportReq_r10 */
static int hf_lte_rrc_nonCriticalExtension_207 = -1;  /* UEInformationRequest_v1130_IEs */
static int hf_lte_rrc_connEstFailReportReq_r11 = -1;  /* T_connEstFailReportReq_r11 */
static int hf_lte_rrc_nonCriticalExtension_208 = -1;  /* UEInformationRequest_v1250_IEs */
static int hf_lte_rrc_mobilityHistoryReportReq_r12 = -1;  /* T_mobilityHistoryReportReq_r12 */
static int hf_lte_rrc_nonCriticalExtension_209 = -1;  /* UEInformationRequest_v1530_IEs */
static int hf_lte_rrc_idleModeMeasurementReq_r15 = -1;  /* T_idleModeMeasurementReq_r15 */
static int hf_lte_rrc_flightPathInfoReq_r15 = -1;  /* FlightPathInfoReportConfig_r15 */
static int hf_lte_rrc_nonCriticalExtension_210 = -1;  /* T_nonCriticalExtension_63 */
static int hf_lte_rrc_criticalExtensions_51 = -1;  /* T_criticalExtensions_51 */
static int hf_lte_rrc_c1_45 = -1;                 /* T_c1_45 */
static int hf_lte_rrc_ueInformationResponse_r9_01 = -1;  /* UEInformationResponse_r9_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_49 = -1;  /* T_criticalExtensionsFuture_49 */
static int hf_lte_rrc_rach_Report_r9 = -1;        /* T_rach_Report_r9 */
static int hf_lte_rrc_numberOfPreamblesSent_r9 = -1;  /* NumberOfPreamblesSent_r11 */
static int hf_lte_rrc_contentionDetected_r9 = -1;  /* BOOLEAN */
static int hf_lte_rrc_rlf_Report_r9 = -1;         /* RLF_Report_r9 */
static int hf_lte_rrc_nonCriticalExtension_211 = -1;  /* UEInformationResponse_v930_IEs */
static int hf_lte_rrc_rlf_Report_v9e0 = -1;       /* RLF_Report_v9e0 */
static int hf_lte_rrc_nonCriticalExtension_212 = -1;  /* T_nonCriticalExtension_64 */
static int hf_lte_rrc_lateNonCriticalExtension_07 = -1;  /* T_lateNonCriticalExtension_06 */
static int hf_lte_rrc_nonCriticalExtension_213 = -1;  /* UEInformationResponse_v1020_IEs */
static int hf_lte_rrc_logMeasReport_r10 = -1;     /* LogMeasReport_r10 */
static int hf_lte_rrc_nonCriticalExtension_214 = -1;  /* UEInformationResponse_v1130_IEs */
static int hf_lte_rrc_connEstFailReport_r11 = -1;  /* ConnEstFailReport_r11 */
static int hf_lte_rrc_nonCriticalExtension_215 = -1;  /* UEInformationResponse_v1250_IEs */
static int hf_lte_rrc_mobilityHistoryReport_r12 = -1;  /* MobilityHistoryReport_r12 */
static int hf_lte_rrc_nonCriticalExtension_216 = -1;  /* UEInformationResponse_v1530_IEs */
static int hf_lte_rrc_measResultListIdle_r15 = -1;  /* MeasResultListIdle_r15 */
static int hf_lte_rrc_flightPathInfoReport_r15 = -1;  /* FlightPathInfoReport_r15 */
static int hf_lte_rrc_nonCriticalExtension_217 = -1;  /* T_nonCriticalExtension_65 */
static int hf_lte_rrc_measResultLastServCell_r9 = -1;  /* T_measResultLastServCell_r9 */
static int hf_lte_rrc_rsrpResult_r9 = -1;         /* RSRP_Range */
static int hf_lte_rrc_rsrqResult_r9 = -1;         /* RSRQ_Range */
static int hf_lte_rrc_measResultNeighCells_r9 = -1;  /* T_measResultNeighCells_r9 */
static int hf_lte_rrc_measResultListEUTRA_r9 = -1;  /* MeasResultList2EUTRA_r9 */
static int hf_lte_rrc_measResultListUTRA_r9 = -1;  /* MeasResultList2UTRA_r9 */
static int hf_lte_rrc_measResultListGERAN_r9 = -1;  /* MeasResultListGERAN */
static int hf_lte_rrc_measResultsCDMA2000_r9 = -1;  /* MeasResultList2CDMA2000_r9 */
static int hf_lte_rrc_locationInfo_r10 = -1;      /* LocationInfo_r10 */
static int hf_lte_rrc_failedPCellId_r10 = -1;     /* T_failedPCellId_r10 */
static int hf_lte_rrc_cellGlobalId_r10 = -1;      /* CellGlobalIdEUTRA */
static int hf_lte_rrc_pci_arfcn_r10 = -1;         /* T_pci_arfcn_r10 */
static int hf_lte_rrc_reestablishmentCellId_r10 = -1;  /* CellGlobalIdEUTRA */
static int hf_lte_rrc_timeConnFailure_r10 = -1;   /* INTEGER_0_1023 */
static int hf_lte_rrc_connectionFailureType_r10 = -1;  /* T_connectionFailureType_r10 */
static int hf_lte_rrc_previousPCellId_r10 = -1;   /* CellGlobalIdEUTRA */
static int hf_lte_rrc_failedPCellId_v1090 = -1;   /* T_failedPCellId_v1090 */
static int hf_lte_rrc_basicFields_r11 = -1;       /* T_basicFields_r11 */
static int hf_lte_rrc_c_RNTI_r11 = -1;            /* C_RNTI */
static int hf_lte_rrc_rlf_Cause_r11 = -1;         /* T_rlf_Cause_r11 */
static int hf_lte_rrc_timeSinceFailure_r11 = -1;  /* TimeSinceFailure_r11 */
static int hf_lte_rrc_previousUTRA_CellId_r11 = -1;  /* T_previousUTRA_CellId_r11 */
static int hf_lte_rrc_carrierFreq_r11_01 = -1;    /* ARFCN_ValueUTRA */
static int hf_lte_rrc_physCellId_r11 = -1;        /* T_physCellId_r11 */
static int hf_lte_rrc_fdd_r11 = -1;               /* PhysCellIdUTRA_FDD */
static int hf_lte_rrc_tdd_r11 = -1;               /* PhysCellIdUTRA_TDD */
static int hf_lte_rrc_cellGlobalId_r11 = -1;      /* CellGlobalIdUTRA */
static int hf_lte_rrc_selectedUTRA_CellId_r11 = -1;  /* T_selectedUTRA_CellId_r11 */
static int hf_lte_rrc_physCellId_r11_01 = -1;     /* T_physCellId_r11_01 */
static int hf_lte_rrc_failedPCellId_v1250 = -1;   /* T_failedPCellId_v1250 */
static int hf_lte_rrc_tac_FailedPCell_r12 = -1;   /* TrackingAreaCode */
static int hf_lte_rrc_measResultLastServCell_v1250 = -1;  /* RSRQ_Range_v1250 */
static int hf_lte_rrc_lastServCellRSRQ_Type_r12 = -1;  /* RSRQ_Type_r12 */
static int hf_lte_rrc_measResultListEUTRA_v1250 = -1;  /* MeasResultList2EUTRA_v1250 */
static int hf_lte_rrc_drb_EstablishedWithQCI_1_r13 = -1;  /* T_drb_EstablishedWithQCI_1_r13 */
static int hf_lte_rrc_measResultLastServCell_v1360 = -1;  /* RSRP_Range_v1360 */
static int hf_lte_rrc_logMeasResultListBT_r15 = -1;  /* LogMeasResultListBT_r15 */
static int hf_lte_rrc_logMeasResultListWLAN_r15 = -1;  /* LogMeasResultListWLAN_r15 */
static int hf_lte_rrc_measResultListEUTRA_v9e0 = -1;  /* MeasResultList2EUTRA_v9e0 */
static int hf_lte_rrc_MeasResultList2EUTRA_r9_item = -1;  /* MeasResult2EUTRA_r9 */
static int hf_lte_rrc_MeasResultList2EUTRA_v9e0_item = -1;  /* MeasResult2EUTRA_v9e0 */
static int hf_lte_rrc_MeasResultList2EUTRA_v1250_item = -1;  /* MeasResult2EUTRA_v1250 */
static int hf_lte_rrc_carrierFreq_r9_02 = -1;     /* ARFCN_ValueEUTRA */
static int hf_lte_rrc_measResultList_r9 = -1;     /* MeasResultListEUTRA */
static int hf_lte_rrc_rsrq_Type_r12 = -1;         /* RSRQ_Type_r12 */
static int hf_lte_rrc_MeasResultList2UTRA_r9_item = -1;  /* MeasResult2UTRA_r9 */
static int hf_lte_rrc_carrierFreq_r9_03 = -1;     /* ARFCN_ValueUTRA */
static int hf_lte_rrc_measResultList_r9_01 = -1;  /* MeasResultListUTRA */
static int hf_lte_rrc_MeasResultList2CDMA2000_r9_item = -1;  /* MeasResult2CDMA2000_r9 */
static int hf_lte_rrc_carrierFreq_r9_04 = -1;     /* CarrierFreqCDMA2000 */
static int hf_lte_rrc_measResultList_r9_02 = -1;  /* MeasResultsCDMA2000 */
static int hf_lte_rrc_absoluteTimeStamp_r10 = -1;  /* AbsoluteTimeInfo_r10 */
static int hf_lte_rrc_logMeasInfoList_r10 = -1;   /* LogMeasInfoList_r10 */
static int hf_lte_rrc_logMeasAvailable_r10_03 = -1;  /* T_logMeasAvailable_r10_03 */
static int hf_lte_rrc_logMeasAvailableBT_r15_04 = -1;  /* T_logMeasAvailableBT_r15_04 */
static int hf_lte_rrc_logMeasAvailableWLAN_r15_04 = -1;  /* T_logMeasAvailableWLAN_r15_04 */
static int hf_lte_rrc_LogMeasInfoList_r10_item = -1;  /* LogMeasInfo_r10 */
static int hf_lte_rrc_relativeTimeStamp_r10 = -1;  /* INTEGER_0_7200 */
static int hf_lte_rrc_servCellIdentity_r10 = -1;  /* CellGlobalIdEUTRA */
static int hf_lte_rrc_measResultServCell_r10 = -1;  /* T_measResultServCell_r10 */
static int hf_lte_rrc_measResultNeighCells_r10 = -1;  /* T_measResultNeighCells_r10 */
static int hf_lte_rrc_measResultListEUTRA_r10 = -1;  /* MeasResultList2EUTRA_r9 */
static int hf_lte_rrc_measResultListUTRA_r10 = -1;  /* MeasResultList2UTRA_r9 */
static int hf_lte_rrc_measResultListGERAN_r10 = -1;  /* MeasResultList2GERAN_r10 */
static int hf_lte_rrc_measResultListCDMA2000_r10 = -1;  /* MeasResultList2CDMA2000_r9 */
static int hf_lte_rrc_measResultListEUTRA_v1090 = -1;  /* MeasResultList2EUTRA_v9e0 */
static int hf_lte_rrc_measResultListMBSFN_r12 = -1;  /* MeasResultListMBSFN_r12 */
static int hf_lte_rrc_measResultServCell_v1250 = -1;  /* RSRQ_Range_v1250 */
static int hf_lte_rrc_servCellRSRQ_Type_r12 = -1;  /* RSRQ_Type_r12 */
static int hf_lte_rrc_inDeviceCoexDetected_r13 = -1;  /* T_inDeviceCoexDetected_r13 */
static int hf_lte_rrc_measResultServCell_v1360 = -1;  /* RSRP_Range_v1360 */
static int hf_lte_rrc_anyCellSelectionDetected_r15 = -1;  /* T_anyCellSelectionDetected_r15 */
static int hf_lte_rrc_MeasResultListMBSFN_r12_item = -1;  /* MeasResultMBSFN_r12 */
static int hf_lte_rrc_mbsfn_Area_r12 = -1;        /* T_mbsfn_Area_r12 */
static int hf_lte_rrc_rsrpResultMBSFN_r12 = -1;   /* RSRP_Range */
static int hf_lte_rrc_rsrqResultMBSFN_r12 = -1;   /* MBSFN_RSRQ_Range_r12 */
static int hf_lte_rrc_signallingBLER_Result_r12 = -1;  /* BLER_Result_r12 */
static int hf_lte_rrc_dataBLER_MCH_ResultList_r12 = -1;  /* DataBLER_MCH_ResultList_r12 */
static int hf_lte_rrc_DataBLER_MCH_ResultList_r12_item = -1;  /* DataBLER_MCH_Result_r12 */
static int hf_lte_rrc_mch_Index_r12 = -1;         /* INTEGER_1_maxPMCH_PerMBSFN */
static int hf_lte_rrc_dataBLER_Result_r12 = -1;   /* BLER_Result_r12 */
static int hf_lte_rrc_bler_r12 = -1;              /* BLER_Range_r12 */
static int hf_lte_rrc_blocksReceived_r12 = -1;    /* T_blocksReceived_r12 */
static int hf_lte_rrc_n_r12 = -1;                 /* T_n_r12 */
static int hf_lte_rrc_m_r12 = -1;                 /* T_m_r12 */
static int hf_lte_rrc_MeasResultList2GERAN_r10_item = -1;  /* MeasResultListGERAN */
static int hf_lte_rrc_failedCellId_r11 = -1;      /* CellGlobalIdEUTRA */
static int hf_lte_rrc_locationInfo_r11 = -1;      /* LocationInfo_r10 */
static int hf_lte_rrc_measResultFailedCell_r11 = -1;  /* T_measResultFailedCell_r11 */
static int hf_lte_rrc_rsrpResult_r11 = -1;        /* RSRP_Range */
static int hf_lte_rrc_rsrqResult_r11 = -1;        /* RSRQ_Range */
static int hf_lte_rrc_measResultNeighCells_r11 = -1;  /* T_measResultNeighCells_r11 */
static int hf_lte_rrc_measResultListEUTRA_r11 = -1;  /* MeasResultList2EUTRA_r9 */
static int hf_lte_rrc_measResultListUTRA_r11 = -1;  /* MeasResultList2UTRA_r9 */
static int hf_lte_rrc_measResultListGERAN_r11 = -1;  /* MeasResultListGERAN */
static int hf_lte_rrc_measResultsCDMA2000_r11 = -1;  /* MeasResultList2CDMA2000_r9 */
static int hf_lte_rrc_numberOfPreamblesSent_r11 = -1;  /* NumberOfPreamblesSent_r11 */
static int hf_lte_rrc_contentionDetected_r11 = -1;  /* BOOLEAN */
static int hf_lte_rrc_maxTxPowerReached_r11 = -1;  /* BOOLEAN */
static int hf_lte_rrc_measResultListEUTRA_v1130 = -1;  /* MeasResultList2EUTRA_v9e0 */
static int hf_lte_rrc_measResultFailedCell_v1250 = -1;  /* RSRQ_Range_v1250 */
static int hf_lte_rrc_failedCellRSRQ_Type_r12 = -1;  /* RSRQ_Type_r12 */
static int hf_lte_rrc_measResultFailedCell_v1360 = -1;  /* RSRP_Range_v1360 */
static int hf_lte_rrc_flightPath_r15 = -1;        /* SEQUENCE_SIZE_1_maxWayPoint_r15_OF_WayPointLocation_r15 */
static int hf_lte_rrc_flightPath_r15_item = -1;   /* WayPointLocation_r15 */
static int hf_lte_rrc_nonCriticalExtension_218 = -1;  /* T_nonCriticalExtension_66 */
static int hf_lte_rrc_wayPointLocation_r15 = -1;  /* LocationInfo_r10 */
static int hf_lte_rrc_timeStamp_r15 = -1;         /* AbsoluteTimeInfo_r10 */
static int hf_lte_rrc_criticalExtensions_52 = -1;  /* T_criticalExtensions_52 */
static int hf_lte_rrc_c1_46 = -1;                 /* T_c1_46 */
static int hf_lte_rrc_ulHandoverPreparationTransfer_r8 = -1;  /* ULHandoverPreparationTransfer_r8_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_50 = -1;  /* T_criticalExtensionsFuture_50 */
static int hf_lte_rrc_meid = -1;                  /* BIT_STRING_SIZE_56 */
static int hf_lte_rrc_dedicatedInfo = -1;         /* DedicatedInfoCDMA2000 */
static int hf_lte_rrc_nonCriticalExtension_219 = -1;  /* ULHandoverPreparationTransfer_v8a0_IEs */
static int hf_lte_rrc_nonCriticalExtension_220 = -1;  /* T_nonCriticalExtension_67 */
static int hf_lte_rrc_criticalExtensions_53 = -1;  /* T_criticalExtensions_53 */
static int hf_lte_rrc_c1_47 = -1;                 /* T_c1_47 */
static int hf_lte_rrc_ulInformationTransfer_r8 = -1;  /* ULInformationTransfer_r8_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_51 = -1;  /* T_criticalExtensionsFuture_51 */
static int hf_lte_rrc_dedicatedInfoType_01 = -1;  /* T_dedicatedInfoType_01 */
static int hf_lte_rrc_nonCriticalExtension_221 = -1;  /* ULInformationTransfer_v8a0_IEs */
static int hf_lte_rrc_nonCriticalExtension_222 = -1;  /* T_nonCriticalExtension_68 */
static int hf_lte_rrc_criticalExtensions_54 = -1;  /* T_criticalExtensions_54 */
static int hf_lte_rrc_c1_48 = -1;                 /* T_c1_48 */
static int hf_lte_rrc_ulInformationTransferMRDC_r15_01 = -1;  /* ULInformationTransferMRDC_r15_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_52 = -1;  /* T_criticalExtensionsFuture_52 */
static int hf_lte_rrc_ul_DCCH_MessageNR_r15 = -1;  /* T_ul_DCCH_MessageNR_r15 */
static int hf_lte_rrc_nonCriticalExtension_223 = -1;  /* T_nonCriticalExtension_69 */
static int hf_lte_rrc_criticalExtensions_55 = -1;  /* T_criticalExtensions_55 */
static int hf_lte_rrc_c1_49 = -1;                 /* T_c1_49 */
static int hf_lte_rrc_wlanConnectionStatusReport_r13_02 = -1;  /* WLANConnectionStatusReport_r13_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_53 = -1;  /* T_criticalExtensionsFuture_53 */
static int hf_lte_rrc_wlan_Status_r13 = -1;       /* WLAN_Status_r13 */
static int hf_lte_rrc_nonCriticalExtension_224 = -1;  /* WLANConnectionStatusReport_v1430_IEs */
static int hf_lte_rrc_wlan_Status_v1430 = -1;     /* WLAN_Status_v1430 */
static int hf_lte_rrc_nonCriticalExtension_225 = -1;  /* T_nonCriticalExtension_70 */
static int hf_lte_rrc_assistanceDataSIB_Element_r15 = -1;  /* OCTET_STRING */
static int hf_lte_rrc_ac_BarringInfo = -1;        /* T_ac_BarringInfo */
static int hf_lte_rrc_ac_BarringForEmergency = -1;  /* BOOLEAN */
static int hf_lte_rrc_ac_BarringForMO_Signalling = -1;  /* AC_BarringConfig */
static int hf_lte_rrc_ac_BarringForMO_Data = -1;  /* AC_BarringConfig */
static int hf_lte_rrc_radioResourceConfigCommon = -1;  /* RadioResourceConfigCommonSIB */
static int hf_lte_rrc_ue_TimersAndConstants = -1;  /* UE_TimersAndConstants */
static int hf_lte_rrc_freqInfo = -1;              /* T_freqInfo */
static int hf_lte_rrc_ul_CarrierFreq = -1;        /* ARFCN_ValueEUTRA */
static int hf_lte_rrc_ul_Bandwidth = -1;          /* T_ul_Bandwidth */
static int hf_lte_rrc_additionalSpectrumEmission = -1;  /* AdditionalSpectrumEmission */
static int hf_lte_rrc_mbsfn_SubframeConfigList = -1;  /* MBSFN_SubframeConfigList */
static int hf_lte_rrc_timeAlignmentTimerCommon = -1;  /* TimeAlignmentTimer */
static int hf_lte_rrc_lateNonCriticalExtension_08 = -1;  /* T_lateNonCriticalExtension_07 */
static int hf_lte_rrc_ssac_BarringForMMTEL_Voice_r9 = -1;  /* AC_BarringConfig */
static int hf_lte_rrc_ssac_BarringForMMTEL_Video_r9 = -1;  /* AC_BarringConfig */
static int hf_lte_rrc_ac_BarringForCSFB_r10 = -1;  /* AC_BarringConfig */
static int hf_lte_rrc_ac_BarringSkipForMMTELVoice_r12 = -1;  /* T_ac_BarringSkipForMMTELVoice_r12 */
static int hf_lte_rrc_ac_BarringSkipForMMTELVideo_r12 = -1;  /* T_ac_BarringSkipForMMTELVideo_r12 */
static int hf_lte_rrc_ac_BarringSkipForSMS_r12 = -1;  /* T_ac_BarringSkipForSMS_r12 */
static int hf_lte_rrc_ac_BarringPerPLMN_List_r12 = -1;  /* AC_BarringPerPLMN_List_r12 */
static int hf_lte_rrc_voiceServiceCauseIndication_r12 = -1;  /* T_voiceServiceCauseIndication_r12 */
static int hf_lte_rrc_acdc_BarringForCommon_r13 = -1;  /* ACDC_BarringForCommon_r13 */
static int hf_lte_rrc_acdc_BarringPerPLMN_List_r13 = -1;  /* ACDC_BarringPerPLMN_List_r13 */
static int hf_lte_rrc_udt_RestrictingForCommon_r13 = -1;  /* UDT_Restricting_r13 */
static int hf_lte_rrc_udt_RestrictingPerPLMN_List_r13 = -1;  /* UDT_RestrictingPerPLMN_List_r13 */
static int hf_lte_rrc_cIoT_EPS_OptimisationInfo_r13 = -1;  /* CIOT_EPS_OptimisationInfo_r13 */
static int hf_lte_rrc_useFullResumeID_r13 = -1;   /* T_useFullResumeID_r13 */
static int hf_lte_rrc_unicastFreqHoppingInd_r13 = -1;  /* T_unicastFreqHoppingInd_r13 */
static int hf_lte_rrc_mbsfn_SubframeConfigList_v1430 = -1;  /* MBSFN_SubframeConfigList_v1430 */
static int hf_lte_rrc_videoServiceCauseIndication_r14 = -1;  /* T_videoServiceCauseIndication_r14 */
static int hf_lte_rrc_plmn_InfoList_r15 = -1;     /* PLMN_InfoList_r15 */
static int hf_lte_rrc_cp_EDT_r15 = -1;            /* T_cp_EDT_r15 */
static int hf_lte_rrc_up_EDT_r15 = -1;            /* T_up_EDT_r15 */
static int hf_lte_rrc_idleModeMeasurements_r15 = -1;  /* T_idleModeMeasurements_r15 */
static int hf_lte_rrc_reducedCP_LatencyEnabled_r15 = -1;  /* T_reducedCP_LatencyEnabled_r15 */
static int hf_lte_rrc_mbms_ROM_ServiceIndication_r15 = -1;  /* T_mbms_ROM_ServiceIndication_r15 */
static int hf_lte_rrc_multiBandInfoList_01 = -1;  /* SEQUENCE_SIZE_1_maxMultiBands_OF_AdditionalSpectrumEmission */
static int hf_lte_rrc_multiBandInfoList_item = -1;  /* AdditionalSpectrumEmission */
static int hf_lte_rrc_nonCriticalExtension_226 = -1;  /* SystemInformationBlockType2_v9e0_IEs */
static int hf_lte_rrc_ul_CarrierFreq_v9e0 = -1;   /* ARFCN_ValueEUTRA_v9e0 */
static int hf_lte_rrc_nonCriticalExtension_227 = -1;  /* SystemInformationBlockType2_v9i0_IEs */
static int hf_lte_rrc_nonCriticalExtension_228 = -1;  /* T_nonCriticalExtension_71 */
static int hf_lte_rrc_dummy = -1;                 /* T_dummy */
static int hf_lte_rrc_freqInfo_v10l0 = -1;        /* T_freqInfo_v10l0 */
static int hf_lte_rrc_additionalSpectrumEmission_v10l0 = -1;  /* AdditionalSpectrumEmission_v10l0 */
static int hf_lte_rrc_multiBandInfoList_v10l0_01 = -1;  /* SEQUENCE_SIZE_1_maxMultiBands_OF_AdditionalSpectrumEmission_v10l0 */
static int hf_lte_rrc_multiBandInfoList_v10l0_item = -1;  /* AdditionalSpectrumEmission_v10l0 */
static int hf_lte_rrc_nonCriticalExtension_229 = -1;  /* SystemInformationBlockType2_v10n0_IEs */
static int hf_lte_rrc_nonCriticalExtension_230 = -1;  /* SystemInformationBlockType2_v13c0_IEs */
static int hf_lte_rrc_uplinkPowerControlCommon_v13c0 = -1;  /* UplinkPowerControlCommon_v1310 */
static int hf_lte_rrc_nonCriticalExtension_231 = -1;  /* T_nonCriticalExtension_72 */
static int hf_lte_rrc_ac_BarringFactor = -1;      /* T_ac_BarringFactor */
static int hf_lte_rrc_ac_BarringTime = -1;        /* T_ac_BarringTime */
static int hf_lte_rrc_ac_BarringForSpecialAC = -1;  /* BIT_STRING_SIZE_5 */
static int hf_lte_rrc_MBSFN_SubframeConfigList_item = -1;  /* MBSFN_SubframeConfig */
static int hf_lte_rrc_MBSFN_SubframeConfigList_v1430_item = -1;  /* MBSFN_SubframeConfig_v1430 */
static int hf_lte_rrc_AC_BarringPerPLMN_List_r12_item = -1;  /* AC_BarringPerPLMN_r12 */
static int hf_lte_rrc_plmn_IdentityIndex_r12 = -1;  /* INTEGER_1_maxPLMN_r11 */
static int hf_lte_rrc_ac_BarringInfo_r12 = -1;    /* T_ac_BarringInfo_r12 */
static int hf_lte_rrc_ac_BarringForEmergency_r12 = -1;  /* BOOLEAN */
static int hf_lte_rrc_ac_BarringForMO_Signalling_r12 = -1;  /* AC_BarringConfig */
static int hf_lte_rrc_ac_BarringForMO_Data_r12 = -1;  /* AC_BarringConfig */
static int hf_lte_rrc_ac_BarringSkipForMMTELVoice_r12_01 = -1;  /* T_ac_BarringSkipForMMTELVoice_r12_01 */
static int hf_lte_rrc_ac_BarringSkipForMMTELVideo_r12_01 = -1;  /* T_ac_BarringSkipForMMTELVideo_r12_01 */
static int hf_lte_rrc_ac_BarringSkipForSMS_r12_01 = -1;  /* T_ac_BarringSkipForSMS_r12_01 */
static int hf_lte_rrc_ac_BarringForCSFB_r12 = -1;  /* AC_BarringConfig */
static int hf_lte_rrc_ssac_BarringForMMTEL_Voice_r12 = -1;  /* AC_BarringConfig */
static int hf_lte_rrc_ssac_BarringForMMTEL_Video_r12 = -1;  /* AC_BarringConfig */
static int hf_lte_rrc_acdc_HPLMNonly_r13 = -1;    /* BOOLEAN */
static int hf_lte_rrc_barringPerACDC_CategoryList_r13 = -1;  /* BarringPerACDC_CategoryList_r13 */
static int hf_lte_rrc_ACDC_BarringPerPLMN_List_r13_item = -1;  /* ACDC_BarringPerPLMN_r13 */
static int hf_lte_rrc_plmn_IdentityIndex_r13 = -1;  /* INTEGER_1_maxPLMN_r11 */
static int hf_lte_rrc_acdc_OnlyForHPLMN_r13 = -1;  /* BOOLEAN */
static int hf_lte_rrc_BarringPerACDC_CategoryList_r13_item = -1;  /* BarringPerACDC_Category_r13 */
static int hf_lte_rrc_acdc_Category_r13 = -1;     /* INTEGER_1_maxACDC_Cat_r13 */
static int hf_lte_rrc_acdc_BarringConfig_r13 = -1;  /* T_acdc_BarringConfig_r13 */
static int hf_lte_rrc_ac_BarringFactor_r13 = -1;  /* T_ac_BarringFactor_r13 */
static int hf_lte_rrc_ac_BarringTime_r13 = -1;    /* T_ac_BarringTime_r13 */
static int hf_lte_rrc_udt_Restricting_r13 = -1;   /* T_udt_Restricting_r13 */
static int hf_lte_rrc_udt_RestrictingTime_r13 = -1;  /* T_udt_RestrictingTime_r13 */
static int hf_lte_rrc_UDT_RestrictingPerPLMN_List_r13_item = -1;  /* UDT_RestrictingPerPLMN_r13 */
static int hf_lte_rrc_udt_Restricting_r13_01 = -1;  /* UDT_Restricting_r13 */
static int hf_lte_rrc_CIOT_EPS_OptimisationInfo_r13_item = -1;  /* CIOT_OptimisationPLMN_r13 */
static int hf_lte_rrc_up_CIoT_EPS_Optimisation_r13_01 = -1;  /* T_up_CIoT_EPS_Optimisation_r13_01 */
static int hf_lte_rrc_cp_CIoT_EPS_Optimisation_r13_01 = -1;  /* T_cp_CIoT_EPS_Optimisation_r13_01 */
static int hf_lte_rrc_attachWithoutPDN_Connectivity_r13_01 = -1;  /* T_attachWithoutPDN_Connectivity_r13_01 */
static int hf_lte_rrc_PLMN_InfoList_r15_item = -1;  /* PLMN_Info_r15 */
static int hf_lte_rrc_upperLayerIndication_r15 = -1;  /* T_upperLayerIndication_r15 */
static int hf_lte_rrc_cellReselectionInfoCommon = -1;  /* T_cellReselectionInfoCommon */
static int hf_lte_rrc_q_Hyst = -1;                /* T_q_Hyst */
static int hf_lte_rrc_speedStateReselectionPars = -1;  /* T_speedStateReselectionPars */
static int hf_lte_rrc_mobilityStateParameters = -1;  /* MobilityStateParameters */
static int hf_lte_rrc_q_HystSF = -1;              /* T_q_HystSF */
static int hf_lte_rrc_sf_Medium = -1;             /* T_sf_Medium */
static int hf_lte_rrc_sf_High = -1;               /* T_sf_High */
static int hf_lte_rrc_cellReselectionServingFreqInfo = -1;  /* T_cellReselectionServingFreqInfo */
static int hf_lte_rrc_s_NonIntraSearch = -1;      /* ReselectionThreshold */
static int hf_lte_rrc_threshServingLow = -1;      /* ReselectionThreshold */
static int hf_lte_rrc_intraFreqCellReselectionInfo = -1;  /* T_intraFreqCellReselectionInfo */
static int hf_lte_rrc_s_IntraSearch = -1;         /* ReselectionThreshold */
static int hf_lte_rrc_allowedMeasBandwidth = -1;  /* AllowedMeasBandwidth */
static int hf_lte_rrc_presenceAntennaPort1 = -1;  /* PresenceAntennaPort1 */
static int hf_lte_rrc_neighCellConfig = -1;       /* NeighCellConfig */
static int hf_lte_rrc_t_ReselectionEUTRA = -1;    /* T_Reselection */
static int hf_lte_rrc_t_ReselectionEUTRA_SF = -1;  /* SpeedStateScaleFactors */
static int hf_lte_rrc_lateNonCriticalExtension_09 = -1;  /* T_lateNonCriticalExtension_08 */
static int hf_lte_rrc_s_IntraSearch_v920 = -1;    /* T_s_IntraSearch_v920 */
static int hf_lte_rrc_s_IntraSearchP_r9 = -1;     /* ReselectionThreshold */
static int hf_lte_rrc_s_IntraSearchQ_r9 = -1;     /* ReselectionThresholdQ_r9 */
static int hf_lte_rrc_s_NonIntraSearch_v920 = -1;  /* T_s_NonIntraSearch_v920 */
static int hf_lte_rrc_s_NonIntraSearchP_r9 = -1;  /* ReselectionThreshold */
static int hf_lte_rrc_s_NonIntraSearchQ_r9 = -1;  /* ReselectionThresholdQ_r9 */
static int hf_lte_rrc_threshServingLowQ_r9 = -1;  /* ReselectionThresholdQ_r9 */
static int hf_lte_rrc_cellReselectionServingFreqInfo_v1310 = -1;  /* CellReselectionServingFreqInfo_v1310 */
static int hf_lte_rrc_redistributionServingInfo_r13 = -1;  /* RedistributionServingInfo_r13 */
static int hf_lte_rrc_t_ReselectionEUTRA_CE_r13 = -1;  /* T_ReselectionEUTRA_CE_r13 */
static int hf_lte_rrc_cellReselectionInfoCommon_v1460 = -1;  /* CellReselectionInfoCommon_v1460 */
static int hf_lte_rrc_cellReselectionInfoHSDN_r15 = -1;  /* CellReselectionInfoHSDN_r15 */
static int hf_lte_rrc_crs_IntfMitigNeighCellsCE_r15 = -1;  /* T_crs_IntfMitigNeighCellsCE_r15 */
static int hf_lte_rrc_redistributionFactorServing_r13 = -1;  /* INTEGER_0_10 */
static int hf_lte_rrc_redistributionFactorCell_r13 = -1;  /* T_redistributionFactorCell_r13 */
static int hf_lte_rrc_t360_r13 = -1;              /* T_t360_r13 */
static int hf_lte_rrc_redistrOnPagingOnly_r13 = -1;  /* T_redistrOnPagingOnly_r13 */
static int hf_lte_rrc_nonCriticalExtension_232 = -1;  /* SystemInformationBlockType3_v10l0_IEs */
static int hf_lte_rrc_nonCriticalExtension_233 = -1;  /* T_nonCriticalExtension_73 */
static int hf_lte_rrc_s_SearchDeltaP_r14 = -1;    /* T_s_SearchDeltaP_r14 */
static int hf_lte_rrc_cellEquivalentSize_r15 = -1;  /* INTEGER_2_16 */
static int hf_lte_rrc_intraFreqNeighCellList = -1;  /* IntraFreqNeighCellList */
static int hf_lte_rrc_intraFreqBlackCellList = -1;  /* IntraFreqBlackCellList */
static int hf_lte_rrc_csg_PhysCellIdRange = -1;   /* PhysCellIdRange */
static int hf_lte_rrc_intraFreqNeighHSDN_CellList_r15 = -1;  /* IntraFreqNeighHSDN_CellList_r15 */
static int hf_lte_rrc_IntraFreqNeighCellList_item = -1;  /* IntraFreqNeighCellInfo */
static int hf_lte_rrc_IntraFreqNeighHSDN_CellList_r15_item = -1;  /* PhysCellIdRange */
static int hf_lte_rrc_q_OffsetCell = -1;          /* Q_OffsetRange */
static int hf_lte_rrc_IntraFreqBlackCellList_item = -1;  /* PhysCellIdRange */
static int hf_lte_rrc_interFreqCarrierFreqList = -1;  /* InterFreqCarrierFreqList */
static int hf_lte_rrc_lateNonCriticalExtension_10 = -1;  /* T_lateNonCriticalExtension_09 */
static int hf_lte_rrc_interFreqCarrierFreqList_v1250 = -1;  /* InterFreqCarrierFreqList_v1250 */
static int hf_lte_rrc_interFreqCarrierFreqListExt_r12 = -1;  /* InterFreqCarrierFreqListExt_r12 */
static int hf_lte_rrc_interFreqCarrierFreqListExt_v1280 = -1;  /* InterFreqCarrierFreqListExt_v1280 */
static int hf_lte_rrc_interFreqCarrierFreqList_v1310 = -1;  /* InterFreqCarrierFreqList_v1310 */
static int hf_lte_rrc_interFreqCarrierFreqListExt_v1310 = -1;  /* InterFreqCarrierFreqListExt_v1310 */
static int hf_lte_rrc_interFreqCarrierFreqList_v1350 = -1;  /* InterFreqCarrierFreqList_v1350 */
static int hf_lte_rrc_interFreqCarrierFreqListExt_v1350 = -1;  /* InterFreqCarrierFreqListExt_v1350 */
static int hf_lte_rrc_interFreqCarrierFreqListExt_v1360 = -1;  /* InterFreqCarrierFreqListExt_v1360 */
static int hf_lte_rrc_scptm_FreqOffset_r14 = -1;  /* INTEGER_1_8 */
static int hf_lte_rrc_interFreqCarrierFreqList_v1530 = -1;  /* InterFreqCarrierFreqList_v1530 */
static int hf_lte_rrc_interFreqCarrierFreqListExt_v1530 = -1;  /* InterFreqCarrierFreqListExt_v1530 */
static int hf_lte_rrc_measIdleConfigSIB_r15 = -1;  /* MeasIdleConfigSIB_r15 */
static int hf_lte_rrc_interFreqCarrierFreqList_v8h0 = -1;  /* SEQUENCE_SIZE_1_maxFreq_OF_InterFreqCarrierFreqInfo_v8h0 */
static int hf_lte_rrc_interFreqCarrierFreqList_v8h0_item = -1;  /* InterFreqCarrierFreqInfo_v8h0 */
static int hf_lte_rrc_nonCriticalExtension_234 = -1;  /* SystemInformationBlockType5_v9e0_IEs */
static int hf_lte_rrc_interFreqCarrierFreqList_v9e0 = -1;  /* SEQUENCE_SIZE_1_maxFreq_OF_InterFreqCarrierFreqInfo_v9e0 */
static int hf_lte_rrc_interFreqCarrierFreqList_v9e0_item = -1;  /* InterFreqCarrierFreqInfo_v9e0 */
static int hf_lte_rrc_nonCriticalExtension_235 = -1;  /* SystemInformationBlockType5_v10j0_IEs */
static int hf_lte_rrc_interFreqCarrierFreqList_v10j0 = -1;  /* SEQUENCE_SIZE_1_maxFreq_OF_InterFreqCarrierFreqInfo_v10j0 */
static int hf_lte_rrc_interFreqCarrierFreqList_v10j0_item = -1;  /* InterFreqCarrierFreqInfo_v10j0 */
static int hf_lte_rrc_nonCriticalExtension_236 = -1;  /* SystemInformationBlockType5_v10l0_IEs */
static int hf_lte_rrc_interFreqCarrierFreqList_v10l0 = -1;  /* SEQUENCE_SIZE_1_maxFreq_OF_InterFreqCarrierFreqInfo_v10l0 */
static int hf_lte_rrc_interFreqCarrierFreqList_v10l0_item = -1;  /* InterFreqCarrierFreqInfo_v10l0 */
static int hf_lte_rrc_nonCriticalExtension_237 = -1;  /* SystemInformationBlockType5_v13a0_IEs */
static int hf_lte_rrc_interFreqCarrierFreqList_v13a0 = -1;  /* InterFreqCarrierFreqList_v13a0 */
static int hf_lte_rrc_nonCriticalExtension_238 = -1;  /* T_nonCriticalExtension_74 */
static int hf_lte_rrc_InterFreqCarrierFreqList_item = -1;  /* InterFreqCarrierFreqInfo */
static int hf_lte_rrc_InterFreqCarrierFreqList_v1250_item = -1;  /* InterFreqCarrierFreqInfo_v1250 */
static int hf_lte_rrc_InterFreqCarrierFreqList_v1310_item = -1;  /* InterFreqCarrierFreqInfo_v1310 */
static int hf_lte_rrc_InterFreqCarrierFreqList_v1350_item = -1;  /* InterFreqCarrierFreqInfo_v1350 */
static int hf_lte_rrc_InterFreqCarrierFreqList_v13a0_item = -1;  /* InterFreqCarrierFreqInfo_v1360 */
static int hf_lte_rrc_InterFreqCarrierFreqList_v1530_item = -1;  /* InterFreqCarrierFreqInfo_v1530 */
static int hf_lte_rrc_InterFreqCarrierFreqListExt_r12_item = -1;  /* InterFreqCarrierFreqInfo_r12 */
static int hf_lte_rrc_InterFreqCarrierFreqListExt_v1280_item = -1;  /* InterFreqCarrierFreqInfo_v10j0 */
static int hf_lte_rrc_InterFreqCarrierFreqListExt_v1310_item = -1;  /* InterFreqCarrierFreqInfo_v1310 */
static int hf_lte_rrc_InterFreqCarrierFreqListExt_v1350_item = -1;  /* InterFreqCarrierFreqInfo_v1350 */
static int hf_lte_rrc_InterFreqCarrierFreqListExt_v1360_item = -1;  /* InterFreqCarrierFreqInfo_v1360 */
static int hf_lte_rrc_InterFreqCarrierFreqListExt_v1530_item = -1;  /* InterFreqCarrierFreqInfo_v1530 */
static int hf_lte_rrc_dl_CarrierFreq = -1;        /* ARFCN_ValueEUTRA */
static int hf_lte_rrc_threshX_High = -1;          /* ReselectionThreshold */
static int hf_lte_rrc_threshX_Low = -1;           /* ReselectionThreshold */
static int hf_lte_rrc_q_OffsetFreq = -1;          /* Q_OffsetRange */
static int hf_lte_rrc_interFreqNeighCellList = -1;  /* InterFreqNeighCellList */
static int hf_lte_rrc_interFreqBlackCellList = -1;  /* InterFreqBlackCellList */
static int hf_lte_rrc_threshX_Q_r9 = -1;          /* T_threshX_Q_r9 */
static int hf_lte_rrc_threshX_HighQ_r9 = -1;      /* ReselectionThresholdQ_r9 */
static int hf_lte_rrc_threshX_LowQ_r9 = -1;       /* ReselectionThresholdQ_r9 */
static int hf_lte_rrc_dl_CarrierFreq_v9e0 = -1;   /* ARFCN_ValueEUTRA_v9e0 */
static int hf_lte_rrc_reducedMeasPerformance_r12 = -1;  /* T_reducedMeasPerformance_r12 */
static int hf_lte_rrc_q_RxLevMin_r12 = -1;        /* Q_RxLevMin */
static int hf_lte_rrc_t_ReselectionEUTRA_r12 = -1;  /* T_Reselection */
static int hf_lte_rrc_t_ReselectionEUTRA_SF_r12 = -1;  /* SpeedStateScaleFactors */
static int hf_lte_rrc_threshX_High_r12 = -1;      /* ReselectionThreshold */
static int hf_lte_rrc_threshX_Low_r12 = -1;       /* ReselectionThreshold */
static int hf_lte_rrc_allowedMeasBandwidth_r12 = -1;  /* AllowedMeasBandwidth */
static int hf_lte_rrc_presenceAntennaPort1_r12 = -1;  /* PresenceAntennaPort1 */
static int hf_lte_rrc_neighCellConfig_r12 = -1;   /* NeighCellConfig */
static int hf_lte_rrc_q_OffsetFreq_r12 = -1;      /* Q_OffsetRange */
static int hf_lte_rrc_interFreqNeighCellList_r12 = -1;  /* InterFreqNeighCellList */
static int hf_lte_rrc_interFreqBlackCellList_r12 = -1;  /* InterFreqBlackCellList */
static int hf_lte_rrc_q_QualMin_r12 = -1;         /* Q_QualMin_r9 */
static int hf_lte_rrc_threshX_Q_r12 = -1;         /* T_threshX_Q_r12 */
static int hf_lte_rrc_threshX_HighQ_r12 = -1;     /* ReselectionThresholdQ_r9 */
static int hf_lte_rrc_threshX_LowQ_r12 = -1;      /* ReselectionThresholdQ_r9 */
static int hf_lte_rrc_q_QualMinWB_r12 = -1;       /* Q_QualMin_r9 */
static int hf_lte_rrc_multiBandInfoList_r12 = -1;  /* MultiBandInfoList_r11 */
static int hf_lte_rrc_reducedMeasPerformance_r12_01 = -1;  /* T_reducedMeasPerformance_r12_01 */
static int hf_lte_rrc_redistributionInterFreqInfo_r13 = -1;  /* RedistributionInterFreqInfo_r13 */
static int hf_lte_rrc_hsdn_Indication_r15 = -1;   /* BOOLEAN */
static int hf_lte_rrc_interFreqNeighHSDN_CellList_r15 = -1;  /* InterFreqNeighHSDN_CellList_r15 */
static int hf_lte_rrc_InterFreqNeighCellList_item = -1;  /* InterFreqNeighCellInfo */
static int hf_lte_rrc_InterFreqNeighHSDN_CellList_r15_item = -1;  /* PhysCellIdRange */
static int hf_lte_rrc_InterFreqBlackCellList_item = -1;  /* PhysCellIdRange */
static int hf_lte_rrc_redistributionFactorFreq_r13 = -1;  /* RedistributionFactor_r13 */
static int hf_lte_rrc_redistributionNeighCellList_r13 = -1;  /* RedistributionNeighCellList_r13 */
static int hf_lte_rrc_RedistributionNeighCellList_r13_item = -1;  /* RedistributionNeighCell_r13 */
static int hf_lte_rrc_redistributionFactorCell_r13_01 = -1;  /* RedistributionFactor_r13 */
static int hf_lte_rrc_carrierFreqListUTRA_FDD = -1;  /* CarrierFreqListUTRA_FDD */
static int hf_lte_rrc_carrierFreqListUTRA_TDD = -1;  /* CarrierFreqListUTRA_TDD */
static int hf_lte_rrc_t_ReselectionUTRA = -1;     /* T_Reselection */
static int hf_lte_rrc_t_ReselectionUTRA_SF = -1;  /* SpeedStateScaleFactors */
static int hf_lte_rrc_lateNonCriticalExtension_11 = -1;  /* T_lateNonCriticalExtension_10 */
static int hf_lte_rrc_carrierFreqListUTRA_FDD_v1250 = -1;  /* SEQUENCE_SIZE_1_maxUTRA_FDD_Carrier_OF_CarrierFreqInfoUTRA_v1250 */
static int hf_lte_rrc_carrierFreqListUTRA_FDD_v1250_item = -1;  /* CarrierFreqInfoUTRA_v1250 */
static int hf_lte_rrc_carrierFreqListUTRA_TDD_v1250 = -1;  /* SEQUENCE_SIZE_1_maxUTRA_TDD_Carrier_OF_CarrierFreqInfoUTRA_v1250 */
static int hf_lte_rrc_carrierFreqListUTRA_TDD_v1250_item = -1;  /* CarrierFreqInfoUTRA_v1250 */
static int hf_lte_rrc_carrierFreqListUTRA_FDD_Ext_r12 = -1;  /* CarrierFreqListUTRA_FDD_Ext_r12 */
static int hf_lte_rrc_carrierFreqListUTRA_TDD_Ext_r12 = -1;  /* CarrierFreqListUTRA_TDD_Ext_r12 */
static int hf_lte_rrc_carrierFreqListUTRA_FDD_v8h0 = -1;  /* SEQUENCE_SIZE_1_maxUTRA_FDD_Carrier_OF_CarrierFreqInfoUTRA_FDD_v8h0 */
static int hf_lte_rrc_carrierFreqListUTRA_FDD_v8h0_item = -1;  /* CarrierFreqInfoUTRA_FDD_v8h0 */
static int hf_lte_rrc_nonCriticalExtension_239 = -1;  /* T_nonCriticalExtension_75 */
static int hf_lte_rrc_reducedMeasPerformance_r12_02 = -1;  /* T_reducedMeasPerformance_r12_02 */
static int hf_lte_rrc_CarrierFreqListUTRA_FDD_item = -1;  /* CarrierFreqUTRA_FDD */
static int hf_lte_rrc_q_RxLevMin_01 = -1;         /* INTEGER_M60_M13 */
static int hf_lte_rrc_p_MaxUTRA = -1;             /* INTEGER_M50_33 */
static int hf_lte_rrc_q_QualMin = -1;             /* INTEGER_M24_0 */
static int hf_lte_rrc_threshX_Q_r9_01 = -1;       /* T_threshX_Q_r9_01 */
static int hf_lte_rrc_multiBandInfoList_02 = -1;  /* SEQUENCE_SIZE_1_maxMultiBands_OF_FreqBandIndicator_UTRA_FDD */
static int hf_lte_rrc_multiBandInfoList_item_01 = -1;  /* FreqBandIndicator_UTRA_FDD */
static int hf_lte_rrc_CarrierFreqListUTRA_FDD_Ext_r12_item = -1;  /* CarrierFreqUTRA_FDD_Ext_r12 */
static int hf_lte_rrc_carrierFreq_r12_01 = -1;    /* ARFCN_ValueUTRA */
static int hf_lte_rrc_q_RxLevMin_r12_01 = -1;     /* INTEGER_M60_M13 */
static int hf_lte_rrc_p_MaxUTRA_r12 = -1;         /* INTEGER_M50_33 */
static int hf_lte_rrc_q_QualMin_r12_01 = -1;      /* INTEGER_M24_0 */
static int hf_lte_rrc_threshX_Q_r12_01 = -1;      /* T_threshX_Q_r12_01 */
static int hf_lte_rrc_multiBandInfoList_r12_01 = -1;  /* FreqBandIndicator_UTRA_FDD_r12 */
static int hf_lte_rrc_multiBandInfoList_r12_item = -1;  /* FreqBandIndicator_UTRA_FDD */
static int hf_lte_rrc_reducedMeasPerformance_r12_03 = -1;  /* T_reducedMeasPerformance_r12_03 */
static int hf_lte_rrc_CarrierFreqListUTRA_TDD_item = -1;  /* CarrierFreqUTRA_TDD */
static int hf_lte_rrc_CarrierFreqListUTRA_TDD_Ext_r12_item = -1;  /* CarrierFreqUTRA_TDD_r12 */
static int hf_lte_rrc_reducedMeasPerformance_r12_04 = -1;  /* T_reducedMeasPerformance_r12_04 */
static int hf_lte_rrc_t_ReselectionGERAN = -1;    /* T_Reselection */
static int hf_lte_rrc_t_ReselectionGERAN_SF = -1;  /* SpeedStateScaleFactors */
static int hf_lte_rrc_carrierFreqsInfoList = -1;  /* CarrierFreqsInfoListGERAN */
static int hf_lte_rrc_CarrierFreqsInfoListGERAN_item = -1;  /* CarrierFreqsInfoGERAN */
static int hf_lte_rrc_commonInfo = -1;            /* T_commonInfo */
static int hf_lte_rrc_ncc_Permitted = -1;         /* BIT_STRING_SIZE_8 */
static int hf_lte_rrc_q_RxLevMin_02 = -1;         /* INTEGER_0_45 */
static int hf_lte_rrc_p_MaxGERAN = -1;            /* INTEGER_0_39 */
static int hf_lte_rrc_systemTimeInfo = -1;        /* SystemTimeInfoCDMA2000 */
static int hf_lte_rrc_searchWindowSize = -1;      /* INTEGER_0_15 */
static int hf_lte_rrc_parametersHRPD = -1;        /* T_parametersHRPD */
static int hf_lte_rrc_preRegistrationInfoHRPD = -1;  /* PreRegistrationInfoHRPD */
static int hf_lte_rrc_cellReselectionParametersHRPD = -1;  /* CellReselectionParametersCDMA2000 */
static int hf_lte_rrc_parameters1XRTT = -1;       /* T_parameters1XRTT */
static int hf_lte_rrc_csfb_RegistrationParam1XRTT = -1;  /* CSFB_RegistrationParam1XRTT */
static int hf_lte_rrc_longCodeState1XRTT = -1;    /* BIT_STRING_SIZE_42 */
static int hf_lte_rrc_cellReselectionParameters1XRTT = -1;  /* CellReselectionParametersCDMA2000 */
static int hf_lte_rrc_csfb_SupportForDualRxUEs_r9 = -1;  /* BOOLEAN */
static int hf_lte_rrc_cellReselectionParametersHRPD_v920 = -1;  /* CellReselectionParametersCDMA2000_v920 */
static int hf_lte_rrc_cellReselectionParameters1XRTT_v920 = -1;  /* CellReselectionParametersCDMA2000_v920 */
static int hf_lte_rrc_csfb_RegistrationParam1XRTT_v920 = -1;  /* CSFB_RegistrationParam1XRTT_v920 */
static int hf_lte_rrc_ac_BarringConfig1XRTT_r9 = -1;  /* AC_BarringConfig1XRTT_r9 */
static int hf_lte_rrc_csfb_DualRxTxSupport_r10 = -1;  /* T_csfb_DualRxTxSupport_r10 */
static int hf_lte_rrc_sib8_PerPLMN_List_r11 = -1;  /* SIB8_PerPLMN_List_r11 */
static int hf_lte_rrc_bandClassList = -1;         /* BandClassListCDMA2000 */
static int hf_lte_rrc_neighCellList = -1;         /* NeighCellListCDMA2000 */
static int hf_lte_rrc_t_ReselectionCDMA2000 = -1;  /* T_Reselection */
static int hf_lte_rrc_t_ReselectionCDMA2000_SF = -1;  /* SpeedStateScaleFactors */
static int hf_lte_rrc_neighCellList_r11 = -1;     /* SEQUENCE_SIZE_1_16_OF_NeighCellCDMA2000_r11 */
static int hf_lte_rrc_neighCellList_r11_item = -1;  /* NeighCellCDMA2000_r11 */
static int hf_lte_rrc_neighCellList_v920 = -1;    /* NeighCellListCDMA2000_v920 */
static int hf_lte_rrc_NeighCellListCDMA2000_item = -1;  /* NeighCellCDMA2000 */
static int hf_lte_rrc_neighCellsPerFreqList = -1;  /* NeighCellsPerBandclassListCDMA2000 */
static int hf_lte_rrc_neighFreqInfoList_r11 = -1;  /* SEQUENCE_SIZE_1_16_OF_NeighCellsPerBandclassCDMA2000_r11 */
static int hf_lte_rrc_neighFreqInfoList_r11_item = -1;  /* NeighCellsPerBandclassCDMA2000_r11 */
static int hf_lte_rrc_NeighCellsPerBandclassListCDMA2000_item = -1;  /* NeighCellsPerBandclassCDMA2000 */
static int hf_lte_rrc_arfcn = -1;                 /* ARFCN_ValueCDMA2000 */
static int hf_lte_rrc_physCellIdList = -1;        /* PhysCellIdListCDMA2000 */
static int hf_lte_rrc_physCellIdList_r11 = -1;    /* SEQUENCE_SIZE_1_40_OF_PhysCellIdCDMA2000 */
static int hf_lte_rrc_physCellIdList_r11_item = -1;  /* PhysCellIdCDMA2000 */
static int hf_lte_rrc_NeighCellListCDMA2000_v920_item = -1;  /* NeighCellCDMA2000_v920 */
static int hf_lte_rrc_neighCellsPerFreqList_v920 = -1;  /* NeighCellsPerBandclassListCDMA2000_v920 */
static int hf_lte_rrc_NeighCellsPerBandclassListCDMA2000_v920_item = -1;  /* NeighCellsPerBandclassCDMA2000_v920 */
static int hf_lte_rrc_physCellIdList_v920 = -1;   /* PhysCellIdListCDMA2000_v920 */
static int hf_lte_rrc_PhysCellIdListCDMA2000_item = -1;  /* PhysCellIdCDMA2000 */
static int hf_lte_rrc_PhysCellIdListCDMA2000_v920_item = -1;  /* PhysCellIdCDMA2000 */
static int hf_lte_rrc_BandClassListCDMA2000_item = -1;  /* BandClassInfoCDMA2000 */
static int hf_lte_rrc_threshX_High_01 = -1;       /* INTEGER_0_63 */
static int hf_lte_rrc_threshX_Low_01 = -1;        /* INTEGER_0_63 */
static int hf_lte_rrc_ac_Barring0to9_r9 = -1;     /* INTEGER_0_63 */
static int hf_lte_rrc_ac_Barring10_r9 = -1;       /* INTEGER_0_7 */
static int hf_lte_rrc_ac_Barring11_r9 = -1;       /* INTEGER_0_7 */
static int hf_lte_rrc_ac_Barring12_r9 = -1;       /* INTEGER_0_7 */
static int hf_lte_rrc_ac_Barring13_r9 = -1;       /* INTEGER_0_7 */
static int hf_lte_rrc_ac_Barring14_r9 = -1;       /* INTEGER_0_7 */
static int hf_lte_rrc_ac_Barring15_r9 = -1;       /* INTEGER_0_7 */
static int hf_lte_rrc_ac_BarringMsg_r9 = -1;      /* INTEGER_0_7 */
static int hf_lte_rrc_ac_BarringReg_r9 = -1;      /* INTEGER_0_7 */
static int hf_lte_rrc_ac_BarringEmg_r9 = -1;      /* INTEGER_0_7 */
static int hf_lte_rrc_SIB8_PerPLMN_List_r11_item = -1;  /* SIB8_PerPLMN_r11 */
static int hf_lte_rrc_plmn_Identity_r11 = -1;     /* INTEGER_1_maxPLMN_r11 */
static int hf_lte_rrc_parametersCDMA2000_r11 = -1;  /* T_parametersCDMA2000_r11 */
static int hf_lte_rrc_explicitValue = -1;         /* ParametersCDMA2000_r11 */
static int hf_lte_rrc_defaultValue = -1;          /* NULL */
static int hf_lte_rrc_systemTimeInfo_r11 = -1;    /* T_systemTimeInfo_r11 */
static int hf_lte_rrc_explicitValue_01 = -1;      /* SystemTimeInfoCDMA2000 */
static int hf_lte_rrc_searchWindowSize_r11 = -1;  /* INTEGER_0_15 */
static int hf_lte_rrc_parametersHRPD_r11 = -1;    /* T_parametersHRPD_r11 */
static int hf_lte_rrc_preRegistrationInfoHRPD_r11 = -1;  /* PreRegistrationInfoHRPD */
static int hf_lte_rrc_cellReselectionParametersHRPD_r11 = -1;  /* CellReselectionParametersCDMA2000_r11 */
static int hf_lte_rrc_parameters1XRTT_r11 = -1;   /* T_parameters1XRTT_r11 */
static int hf_lte_rrc_csfb_RegistrationParam1XRTT_r11 = -1;  /* CSFB_RegistrationParam1XRTT */
static int hf_lte_rrc_csfb_RegistrationParam1XRTT_Ext_r11 = -1;  /* CSFB_RegistrationParam1XRTT_v920 */
static int hf_lte_rrc_longCodeState1XRTT_r11 = -1;  /* BIT_STRING_SIZE_42 */
static int hf_lte_rrc_cellReselectionParameters1XRTT_r11 = -1;  /* CellReselectionParametersCDMA2000_r11 */
static int hf_lte_rrc_ac_BarringConfig1XRTT_r11 = -1;  /* AC_BarringConfig1XRTT_r9 */
static int hf_lte_rrc_csfb_SupportForDualRxUEs_r11 = -1;  /* BOOLEAN */
static int hf_lte_rrc_csfb_DualRxTxSupport_r11 = -1;  /* T_csfb_DualRxTxSupport_r11 */
static int hf_lte_rrc_hnb_Name = -1;              /* T_hnb_Name */
static int hf_lte_rrc_messageIdentifier = -1;     /* T_messageIdentifier */
static int hf_lte_rrc_serialNumber = -1;          /* T_serialNumber */
static int hf_lte_rrc_warningType = -1;           /* T_warningType */
static int hf_lte_rrc_dummy_01 = -1;              /* OCTET_STRING_SIZE_50 */
static int hf_lte_rrc_messageIdentifier_01 = -1;  /* T_messageIdentifier_01 */
static int hf_lte_rrc_serialNumber_01 = -1;       /* T_serialNumber_01 */
static int hf_lte_rrc_warningMessageSegmentType = -1;  /* T_warningMessageSegmentType */
static int hf_lte_rrc_warningMessageSegmentNumber = -1;  /* T_warningMessageSegmentNumber */
static int hf_lte_rrc_warningMessageSegment = -1;  /* T_warningMessageSegment */
static int hf_lte_rrc_dataCodingScheme = -1;      /* T_dataCodingScheme */
static int hf_lte_rrc_messageIdentifier_r9 = -1;  /* T_messageIdentifier_r9 */
static int hf_lte_rrc_serialNumber_r9 = -1;       /* T_serialNumber_r9 */
static int hf_lte_rrc_warningMessageSegmentType_r9 = -1;  /* T_warningMessageSegmentType_r9 */
static int hf_lte_rrc_warningMessageSegmentNumber_r9 = -1;  /* T_warningMessageSegmentNumber_r9 */
static int hf_lte_rrc_warningMessageSegment_r9 = -1;  /* T_warningMessageSegment_r9 */
static int hf_lte_rrc_dataCodingScheme_r9 = -1;   /* T_dataCodingScheme_r9 */
static int hf_lte_rrc_warningAreaCoordinatesSegment_r15 = -1;  /* OCTET_STRING */
static int hf_lte_rrc_mbsfn_AreaInfoList_r9 = -1;  /* MBSFN_AreaInfoList_r9 */
static int hf_lte_rrc_notificationConfig_r9 = -1;  /* MBMS_NotificationConfig_r9 */
static int hf_lte_rrc_notificationConfig_v1430 = -1;  /* MBMS_NotificationConfig_v1430 */
static int hf_lte_rrc_eab_Param_r11 = -1;         /* T_eab_Param_r11 */
static int hf_lte_rrc_eab_Common_r11 = -1;        /* EAB_Config_r11 */
static int hf_lte_rrc_eab_PerPLMN_List_r11 = -1;  /* SEQUENCE_SIZE_1_maxPLMN_r11_OF_EAB_ConfigPLMN_r11 */
static int hf_lte_rrc_eab_PerPLMN_List_r11_item = -1;  /* EAB_ConfigPLMN_r11 */
static int hf_lte_rrc_eab_PerRSRP_r15 = -1;       /* T_eab_PerRSRP_r15 */
static int hf_lte_rrc_eab_Config_r11 = -1;        /* EAB_Config_r11 */
static int hf_lte_rrc_eab_Category_r11 = -1;      /* T_eab_Category_r11 */
static int hf_lte_rrc_eab_BarringBitmap_r11 = -1;  /* BIT_STRING_SIZE_10 */
static int hf_lte_rrc_mbms_SAI_IntraFreq_r11 = -1;  /* MBMS_SAI_List_r11 */
static int hf_lte_rrc_mbms_SAI_InterFreqList_r11 = -1;  /* MBMS_SAI_InterFreqList_r11 */
static int hf_lte_rrc_mbms_SAI_InterFreqList_v1140 = -1;  /* MBMS_SAI_InterFreqList_v1140 */
static int hf_lte_rrc_mbms_IntraFreqCarrierType_r14 = -1;  /* MBMS_CarrierType_r14 */
static int hf_lte_rrc_mbms_InterFreqCarrierTypeList_r14 = -1;  /* MBMS_InterFreqCarrierTypeList_r14 */
static int hf_lte_rrc_MBMS_SAI_List_r11_item = -1;  /* MBMS_SAI_r11 */
static int hf_lte_rrc_MBMS_SAI_InterFreqList_r11_item = -1;  /* MBMS_SAI_InterFreq_r11 */
static int hf_lte_rrc_MBMS_SAI_InterFreqList_v1140_item = -1;  /* MBMS_SAI_InterFreq_v1140 */
static int hf_lte_rrc_dl_CarrierFreq_r11 = -1;    /* ARFCN_ValueEUTRA_r9 */
static int hf_lte_rrc_mbms_SAI_List_r11 = -1;     /* MBMS_SAI_List_r11 */
static int hf_lte_rrc_multiBandInfoList_r11 = -1;  /* MultiBandInfoList_r11 */
static int hf_lte_rrc_MBMS_InterFreqCarrierTypeList_r14_item = -1;  /* MBMS_CarrierType_r14 */
static int hf_lte_rrc_carrierType_r14 = -1;       /* T_carrierType_r14 */
static int hf_lte_rrc_frameOffset_r14 = -1;       /* INTEGER_0_3 */
static int hf_lte_rrc_timeInfo_r11 = -1;          /* T_timeInfo_r11 */
static int hf_lte_rrc_timeInfoUTC_r11 = -1;       /* T_timeInfoUTC_r11 */
static int hf_lte_rrc_dayLightSavingTime_r11 = -1;  /* T_dayLightSavingTime_r11 */
static int hf_lte_rrc_leapSeconds_r11 = -1;       /* INTEGER_M127_128 */
static int hf_lte_rrc_localTimeOffset_r11 = -1;   /* INTEGER_M63_64 */
static int hf_lte_rrc_wlan_OffloadInfoPerPLMN_List_r12 = -1;  /* SEQUENCE_SIZE_1_maxPLMN_r11_OF_WLAN_OffloadInfoPerPLMN_r12 */
static int hf_lte_rrc_wlan_OffloadInfoPerPLMN_List_r12_item = -1;  /* WLAN_OffloadInfoPerPLMN_r12 */
static int hf_lte_rrc_wlan_OffloadConfigCommon_r12 = -1;  /* WLAN_OffloadConfig_r12 */
static int hf_lte_rrc_wlan_Id_List_r12 = -1;      /* WLAN_Id_List_r12 */
static int hf_lte_rrc_WLAN_Id_List_r12_item = -1;  /* WLAN_Identifiers_r12 */
static int hf_lte_rrc_ssid_r12 = -1;              /* T_ssid_r12 */
static int hf_lte_rrc_bssid_r12 = -1;             /* OCTET_STRING_SIZE_6 */
static int hf_lte_rrc_hessid_r12 = -1;            /* OCTET_STRING_SIZE_6 */
static int hf_lte_rrc_commConfig_r12 = -1;        /* T_commConfig_r12 */
static int hf_lte_rrc_commRxPool_r12 = -1;        /* SL_CommRxPoolList_r12 */
static int hf_lte_rrc_commTxPoolNormalCommon_r12 = -1;  /* SL_CommTxPoolList_r12 */
static int hf_lte_rrc_commTxPoolExceptional_r12 = -1;  /* SL_CommTxPoolList_r12 */
static int hf_lte_rrc_commSyncConfig_r12 = -1;    /* SL_SyncConfigList_r12 */
static int hf_lte_rrc_commTxPoolNormalCommonExt_r13 = -1;  /* SL_CommTxPoolListExt_r13 */
static int hf_lte_rrc_commTxResourceUC_ReqAllowed_r13 = -1;  /* T_commTxResourceUC_ReqAllowed_r13 */
static int hf_lte_rrc_commTxAllowRelayCommon_r13 = -1;  /* T_commTxAllowRelayCommon_r13 */
static int hf_lte_rrc_discConfig_r12 = -1;        /* T_discConfig_r12 */
static int hf_lte_rrc_discRxPool_r12 = -1;        /* SL_DiscRxPoolList_r12 */
static int hf_lte_rrc_discTxPoolCommon_r12 = -1;  /* SL_DiscTxPoolList_r12 */
static int hf_lte_rrc_discTxPowerInfo_r12 = -1;   /* SL_DiscTxPowerInfoList_r12 */
static int hf_lte_rrc_discSyncConfig_r12 = -1;    /* SL_SyncConfigList_r12 */
static int hf_lte_rrc_discInterFreqList_r12 = -1;  /* SL_CarrierFreqInfoList_r12 */
static int hf_lte_rrc_discConfig_v1310 = -1;      /* T_discConfig_v1310 */
static int hf_lte_rrc_discInterFreqList_v1310 = -1;  /* SL_CarrierFreqInfoList_v1310 */
static int hf_lte_rrc_gapRequestsAllowedCommon = -1;  /* T_gapRequestsAllowedCommon */
static int hf_lte_rrc_discConfigRelay_r13 = -1;   /* T_discConfigRelay_r13 */
static int hf_lte_rrc_relayUE_Config_r13 = -1;    /* SL_DiscConfigRelayUE_r13 */
static int hf_lte_rrc_remoteUE_Config_r13 = -1;   /* SL_DiscConfigRemoteUE_r13 */
static int hf_lte_rrc_discConfigPS_13 = -1;       /* T_discConfigPS_13 */
static int hf_lte_rrc_discRxPoolPS_r13 = -1;      /* SL_DiscRxPoolList_r12 */
static int hf_lte_rrc_discTxPoolPS_Common_r13 = -1;  /* SL_DiscTxPoolList_r12 */
static int hf_lte_rrc_SL_CarrierFreqInfoList_r12_item = -1;  /* SL_CarrierFreqInfo_r12 */
static int hf_lte_rrc_SL_CarrierFreqInfoList_v1310_item = -1;  /* SL_CarrierFreqInfo_v1310 */
static int hf_lte_rrc_plmn_IdentityList_r12 = -1;  /* PLMN_IdentityList4_r12 */
static int hf_lte_rrc_threshHigh_r13 = -1;        /* RSRP_RangeSL4_r13 */
static int hf_lte_rrc_threshLow_r13 = -1;         /* RSRP_RangeSL4_r13 */
static int hf_lte_rrc_hystMax_r13 = -1;           /* T_hystMax_r13 */
static int hf_lte_rrc_hystMin_r13 = -1;           /* T_hystMin_r13 */
static int hf_lte_rrc_hystMax_r13_01 = -1;        /* T_hystMax_r13_01 */
static int hf_lte_rrc_reselectionInfoIC_r13 = -1;  /* ReselectionInfoRelay_r13 */
static int hf_lte_rrc_q_RxLevMin_r13 = -1;        /* Q_RxLevMin */
static int hf_lte_rrc_filterCoefficient_r13 = -1;  /* FilterCoefficient */
static int hf_lte_rrc_minHyst_r13 = -1;           /* T_minHyst_r13 */
static int hf_lte_rrc_discResourcesNonPS_r13 = -1;  /* SL_ResourcesInterFreq_r13 */
static int hf_lte_rrc_discResourcesPS_r13 = -1;   /* SL_ResourcesInterFreq_r13 */
static int hf_lte_rrc_discConfigOther_r13 = -1;   /* SL_DiscConfigOtherInterFreq_r13 */
static int hf_lte_rrc_PLMN_IdentityList4_r12_item = -1;  /* PLMN_IdentityInfo2_r12 */
static int hf_lte_rrc_plmn_Index_r12 = -1;        /* INTEGER_1_maxPLMN_r11 */
static int hf_lte_rrc_plmnIdentity_r12 = -1;      /* PLMN_Identity */
static int hf_lte_rrc_acquireSI_FromCarrier_r13 = -1;  /* NULL */
static int hf_lte_rrc_discTxPoolCommon_r13 = -1;  /* SL_DiscTxPoolList_r12 */
static int hf_lte_rrc_requestDedicated_r13 = -1;  /* NULL */
static int hf_lte_rrc_noTxOnCarrier_r13 = -1;     /* NULL */
static int hf_lte_rrc_txPowerInfo_r13 = -1;       /* SL_DiscTxPowerInfoList_r12 */
static int hf_lte_rrc_refCarrierCommon_r13 = -1;  /* T_refCarrierCommon_r13 */
static int hf_lte_rrc_discSyncConfig_r13 = -1;    /* SL_SyncConfigListNFreq_r13 */
static int hf_lte_rrc_discCellSelectionInfo_r13 = -1;  /* CellSelectionInfoNFreq_r13 */
static int hf_lte_rrc_discRxResourcesInterFreq_r13 = -1;  /* SL_DiscRxPoolList_r12 */
static int hf_lte_rrc_discTxResourcesInterFreq_r13 = -1;  /* SL_DiscTxResourcesInterFreq_r13 */
static int hf_lte_rrc_sc_mcch_RepetitionPeriod_r13 = -1;  /* T_sc_mcch_RepetitionPeriod_r13 */
static int hf_lte_rrc_sc_mcch_Offset_r13 = -1;    /* INTEGER_0_10 */
static int hf_lte_rrc_sc_mcch_FirstSubframe_r13 = -1;  /* INTEGER_0_9 */
static int hf_lte_rrc_sc_mcch_duration_r13 = -1;  /* INTEGER_2_9 */
static int hf_lte_rrc_sc_mcch_ModificationPeriod_r13 = -1;  /* T_sc_mcch_ModificationPeriod_r13 */
static int hf_lte_rrc_br_BCCH_Config_r14 = -1;    /* T_br_BCCH_Config_r14 */
static int hf_lte_rrc_dummy_02 = -1;              /* T_dummy_01 */
static int hf_lte_rrc_dummy2 = -1;                /* T_dummy2 */
static int hf_lte_rrc_mpdcch_Narrowband_SC_MCCH_r14 = -1;  /* INTEGER_1_maxAvailNarrowBands_r13 */
static int hf_lte_rrc_mpdcch_NumRepetition_SC_MCCH_r14 = -1;  /* T_mpdcch_NumRepetition_SC_MCCH_r14 */
static int hf_lte_rrc_mpdcch_StartSF_SC_MCCH_r14 = -1;  /* T_mpdcch_StartSF_SC_MCCH_r14 */
static int hf_lte_rrc_fdd_r14 = -1;               /* T_fdd_r14 */
static int hf_lte_rrc_tdd_r14 = -1;               /* T_tdd_r14 */
static int hf_lte_rrc_mpdcch_PDSCH_HoppingConfig_SC_MCCH_r14 = -1;  /* T_mpdcch_PDSCH_HoppingConfig_SC_MCCH_r14 */
static int hf_lte_rrc_sc_mcch_CarrierFreq_r14 = -1;  /* ARFCN_ValueEUTRA_r9 */
static int hf_lte_rrc_sc_mcch_Offset_BR_r14 = -1;  /* INTEGER_0_10 */
static int hf_lte_rrc_sc_mcch_RepetitionPeriod_BR_r14 = -1;  /* T_sc_mcch_RepetitionPeriod_BR_r14 */
static int hf_lte_rrc_sc_mcch_ModificationPeriod_BR_r14 = -1;  /* T_sc_mcch_ModificationPeriod_BR_r14 */
static int hf_lte_rrc_sc_mcch_SchedulingInfo_r14 = -1;  /* SC_MCCH_SchedulingInfo_r14 */
static int hf_lte_rrc_pdsch_maxNumRepetitionCEmodeA_SC_MTCH_r14 = -1;  /* T_pdsch_maxNumRepetitionCEmodeA_SC_MTCH_r14 */
static int hf_lte_rrc_pdsch_maxNumRepetitionCEmodeB_SC_MTCH_r14 = -1;  /* T_pdsch_maxNumRepetitionCEmodeB_SC_MTCH_r14 */
static int hf_lte_rrc_sc_mcch_RepetitionPeriod_v1470 = -1;  /* T_sc_mcch_RepetitionPeriod_v1470 */
static int hf_lte_rrc_sc_mcch_ModificationPeriod_v1470 = -1;  /* T_sc_mcch_ModificationPeriod_v1470 */
static int hf_lte_rrc_onDurationTimerSCPTM_r14 = -1;  /* T_onDurationTimerSCPTM_r14 */
static int hf_lte_rrc_drx_InactivityTimerSCPTM_r14 = -1;  /* T_drx_InactivityTimerSCPTM_r14 */
static int hf_lte_rrc_schedulingPeriodStartOffsetSCPTM_r14 = -1;  /* T_schedulingPeriodStartOffsetSCPTM_r14 */
static int hf_lte_rrc_sf10 = -1;                  /* INTEGER_0_9 */
static int hf_lte_rrc_sf20 = -1;                  /* INTEGER_0_19 */
static int hf_lte_rrc_sf32 = -1;                  /* INTEGER_0_31 */
static int hf_lte_rrc_sf40 = -1;                  /* INTEGER_0_39 */
static int hf_lte_rrc_sf64 = -1;                  /* INTEGER_0_63 */
static int hf_lte_rrc_sf80 = -1;                  /* INTEGER_0_79 */
static int hf_lte_rrc_sf128 = -1;                 /* INTEGER_0_127 */
static int hf_lte_rrc_sf160 = -1;                 /* INTEGER_0_159 */
static int hf_lte_rrc_sf256 = -1;                 /* INTEGER_0_255 */
static int hf_lte_rrc_sf320 = -1;                 /* INTEGER_0_319 */
static int hf_lte_rrc_sf512 = -1;                 /* INTEGER_0_511 */
static int hf_lte_rrc_sf640 = -1;                 /* INTEGER_0_639 */
static int hf_lte_rrc_sf1024 = -1;                /* INTEGER_0_1023 */
static int hf_lte_rrc_sf2048 = -1;                /* INTEGER_0_2047 */
static int hf_lte_rrc_sf4096 = -1;                /* INTEGER_0_4095 */
static int hf_lte_rrc_sf8192 = -1;                /* INTEGER_0_8191 */
static int hf_lte_rrc_sl_V2X_ConfigCommon_r14 = -1;  /* SL_V2X_ConfigCommon_r14 */
static int hf_lte_rrc_v2x_CommRxPool_r14 = -1;    /* SL_CommRxPoolListV2X_r14 */
static int hf_lte_rrc_v2x_CommTxPoolNormalCommon_r14 = -1;  /* SL_CommTxPoolListV2X_r14 */
static int hf_lte_rrc_p2x_CommTxPoolNormalCommon_r14 = -1;  /* SL_CommTxPoolListV2X_r14 */
static int hf_lte_rrc_v2x_CommTxPoolExceptional_r14 = -1;  /* SL_CommResourcePoolV2X_r14 */
static int hf_lte_rrc_v2x_SyncConfig_r14 = -1;    /* SL_SyncConfigListV2X_r14 */
static int hf_lte_rrc_v2x_InterFreqInfoList_r14 = -1;  /* SL_InterFreqInfoListV2X_r14 */
static int hf_lte_rrc_v2x_ResourceSelectionConfig_r14 = -1;  /* SL_CommTxPoolSensingConfig_r14 */
static int hf_lte_rrc_zoneConfig_r14 = -1;        /* SL_ZoneConfig_r14 */
static int hf_lte_rrc_typeTxSync_r14 = -1;        /* SL_TypeTxSync_r14 */
static int hf_lte_rrc_thresSL_TxPrioritization_r14 = -1;  /* SL_Priority_r13 */
static int hf_lte_rrc_anchorCarrierFreqList_r14 = -1;  /* SL_AnchorCarrierFreqList_V2X_r14 */
static int hf_lte_rrc_offsetDFN_r14 = -1;         /* INTEGER_0_1000 */
static int hf_lte_rrc_cbr_CommonTxConfigList_r14 = -1;  /* SL_CBR_CommonTxConfigList_r14 */
static int hf_lte_rrc_carrierFreqListNR_r15 = -1;  /* CarrierFreqListNR_r15 */
static int hf_lte_rrc_t_ReselectionNR_r15 = -1;   /* T_Reselection */
static int hf_lte_rrc_t_ReselectionNR_SF_r15 = -1;  /* SpeedStateScaleFactors */
static int hf_lte_rrc_CarrierFreqListNR_r15_item = -1;  /* CarrierFreqNR_r15 */
static int hf_lte_rrc_multiBandInfoList_r15 = -1;  /* MultiFrequencyBandListNR_r15 */
static int hf_lte_rrc_multiBandInfoListSUL_r15 = -1;  /* MultiFrequencyBandListNR_r15 */
static int hf_lte_rrc_measTimingConfig_r15 = -1;  /* MTC_SSB_NR_r15 */
static int hf_lte_rrc_subcarrierSpacingSSB_r15_01 = -1;  /* T_subcarrierSpacingSSB_r15_01 */
static int hf_lte_rrc_ss_RSSI_Measurement_r15 = -1;  /* SS_RSSI_Measurement_r15 */
static int hf_lte_rrc_threshX_High_r15 = -1;      /* ReselectionThreshold */
static int hf_lte_rrc_threshX_Low_r15 = -1;       /* ReselectionThreshold */
static int hf_lte_rrc_threshX_Q_r15 = -1;         /* T_threshX_Q_r15 */
static int hf_lte_rrc_threshX_HighQ_r15 = -1;     /* ReselectionThresholdQ_r9 */
static int hf_lte_rrc_threshX_LowQ_r15 = -1;      /* ReselectionThresholdQ_r9 */
static int hf_lte_rrc_q_RxLevMin_r15 = -1;        /* INTEGER_M70_M22 */
static int hf_lte_rrc_q_RxLevMinSUL_r15 = -1;     /* INTEGER_M70_M22 */
static int hf_lte_rrc_p_MaxNR_r15 = -1;           /* P_MaxNR_r15 */
static int hf_lte_rrc_ns_PmaxListNR_r15 = -1;     /* NS_PmaxListNR_r15 */
static int hf_lte_rrc_q_QualMin_r15 = -1;         /* INTEGER_M43_M12 */
static int hf_lte_rrc_deriveSSB_IndexFromCell_r15 = -1;  /* BOOLEAN */
static int hf_lte_rrc_maxRS_IndexCellQual_r15 = -1;  /* MaxRS_IndexCellQualNR_r15 */
static int hf_lte_rrc_threshRS_Index_r15 = -1;    /* ThresholdListNR_r15 */
static int hf_lte_rrc_multiBandNsPmaxListNR_v1550 = -1;  /* MultiBandNsPmaxListNR_1_v1550 */
static int hf_lte_rrc_multiBandNsPmaxListNR_SUL_v1550 = -1;  /* MultiBandNsPmaxListNR_v1550 */
static int hf_lte_rrc_ssb_ToMeasure_r15 = -1;     /* SSB_ToMeasure_r15 */
static int hf_lte_rrc_MultiBandNsPmaxListNR_1_v1550_item = -1;  /* NS_PmaxListNR_r15 */
static int hf_lte_rrc_MultiBandNsPmaxListNR_v1550_item = -1;  /* NS_PmaxListNR_r15 */
static int hf_lte_rrc_uac_BarringForCommon_r15 = -1;  /* UAC_BarringPerCatList_r15 */
static int hf_lte_rrc_uac_BarringPerPLMN_List_r15 = -1;  /* UAC_BarringPerPLMN_List_r15 */
static int hf_lte_rrc_uac_BarringInfoSetList_r15 = -1;  /* UAC_BarringInfoSetList_r15 */
static int hf_lte_rrc_uac_AC1_SelectAssistInfo_r15 = -1;  /* T_uac_AC1_SelectAssistInfo_r15 */
static int hf_lte_rrc_plmnCommon_r15 = -1;        /* UAC_AC1_SelectAssistInfo_r15 */
static int hf_lte_rrc_individualPLMNList_r15 = -1;  /* SEQUENCE_SIZE_2_maxPLMN_r11_OF_UAC_AC1_SelectAssistInfo_r15 */
static int hf_lte_rrc_individualPLMNList_r15_item = -1;  /* UAC_AC1_SelectAssistInfo_r15 */
static int hf_lte_rrc_UAC_BarringPerPLMN_List_r15_item = -1;  /* UAC_BarringPerPLMN_r15 */
static int hf_lte_rrc_plmn_IdentityIndex_r15 = -1;  /* INTEGER_1_maxPLMN_r11 */
static int hf_lte_rrc_uac_AC_BarringListType_r15 = -1;  /* T_uac_AC_BarringListType_r15 */
static int hf_lte_rrc_uac_ImplicitAC_BarringList_r15 = -1;  /* SEQUENCE_SIZE_maxAccessCat_1_r15_OF_UAC_BarringInfoSetIndex_r15 */
static int hf_lte_rrc_uac_ImplicitAC_BarringList_r15_item = -1;  /* UAC_BarringInfoSetIndex_r15 */
static int hf_lte_rrc_uac_ExplicitAC_BarringList_r15 = -1;  /* UAC_BarringPerCatList_r15 */
static int hf_lte_rrc_UAC_BarringPerCatList_r15_item = -1;  /* UAC_BarringPerCat_r15 */
static int hf_lte_rrc_accessCategory_r15 = -1;    /* INTEGER_1_maxAccessCat_1_r15 */
static int hf_lte_rrc_uac_barringInfoSetIndex_r15 = -1;  /* UAC_BarringInfoSetIndex_r15 */
static int hf_lte_rrc_UAC_BarringInfoSetList_r15_item = -1;  /* UAC_BarringInfoSet_r15 */
static int hf_lte_rrc_uac_BarringFactor_r15 = -1;  /* T_uac_BarringFactor_r15 */
static int hf_lte_rrc_uac_BarringTime_r15 = -1;   /* T_uac_BarringTime_r15 */
static int hf_lte_rrc_uac_BarringForAccessIdentity_r15 = -1;  /* BIT_STRING_SIZE_7 */
static int hf_lte_rrc_v2x_InterFreqInfoList_r15 = -1;  /* SL_InterFreqInfoListV2X_r14 */
static int hf_lte_rrc_cbr_pssch_TxConfigList_r15 = -1;  /* SL_CBR_PPPP_TxConfigList_r15 */
static int hf_lte_rrc_v2x_PacketDuplicationConfig_r15 = -1;  /* SL_V2X_PacketDuplicationConfig_r15 */
static int hf_lte_rrc_syncFreqList_r15 = -1;      /* SL_V2X_SyncFreqList_r15 */
static int hf_lte_rrc_slss_TxMultiFreq_r15 = -1;  /* T_slss_TxMultiFreq_r15 */
static int hf_lte_rrc_v2x_FreqSelectionConfigList_r15 = -1;  /* SL_V2X_FreqSelectionConfigList_r15 */
static int hf_lte_rrc_threshS_RSSI_CBR_r14 = -1;  /* INTEGER_0_45 */
static int hf_lte_rrc_antennaPortsCount = -1;     /* T_antennaPortsCount */
static int hf_lte_rrc_transmissionMode = -1;      /* T_transmissionMode */
static int hf_lte_rrc_codebookSubsetRestriction = -1;  /* T_codebookSubsetRestriction */
static int hf_lte_rrc_n2TxAntenna_tm3 = -1;       /* BIT_STRING_SIZE_2 */
static int hf_lte_rrc_n4TxAntenna_tm3 = -1;       /* BIT_STRING_SIZE_4 */
static int hf_lte_rrc_n2TxAntenna_tm4 = -1;       /* BIT_STRING_SIZE_6 */
static int hf_lte_rrc_n4TxAntenna_tm4 = -1;       /* BIT_STRING_SIZE_64 */
static int hf_lte_rrc_n2TxAntenna_tm5 = -1;       /* BIT_STRING_SIZE_4 */
static int hf_lte_rrc_n4TxAntenna_tm5 = -1;       /* BIT_STRING_SIZE_16 */
static int hf_lte_rrc_n2TxAntenna_tm6 = -1;       /* BIT_STRING_SIZE_4 */
static int hf_lte_rrc_n4TxAntenna_tm6 = -1;       /* BIT_STRING_SIZE_16 */
static int hf_lte_rrc_ue_TransmitAntennaSelection = -1;  /* T_ue_TransmitAntennaSelection */
static int hf_lte_rrc_setup_06 = -1;              /* T_setup_06 */
static int hf_lte_rrc_codebookSubsetRestriction_v920 = -1;  /* T_codebookSubsetRestriction_v920 */
static int hf_lte_rrc_n2TxAntenna_tm8_r9 = -1;    /* BIT_STRING_SIZE_6 */
static int hf_lte_rrc_n4TxAntenna_tm8_r9 = -1;    /* BIT_STRING_SIZE_32 */
static int hf_lte_rrc_transmissionMode_r10 = -1;  /* T_transmissionMode_r10 */
static int hf_lte_rrc_codebookSubsetRestriction_r10 = -1;  /* BIT_STRING */
static int hf_lte_rrc_ue_TransmitAntennaSelection_01 = -1;  /* T_ue_TransmitAntennaSelection_01 */
static int hf_lte_rrc_setup_07 = -1;              /* T_setup_07 */
static int hf_lte_rrc_maxLayersMIMO_r10 = -1;     /* T_maxLayersMIMO_r10 */
static int hf_lte_rrc_alternativeCodebookEnabledFor4TX_r12 = -1;  /* BOOLEAN */
static int hf_lte_rrc_ce_UE_TxAntennaSelection_config_r14 = -1;  /* T_ce_UE_TxAntennaSelection_config_r14 */
static int hf_lte_rrc_setup_08 = -1;              /* T_setup_08 */
static int hf_lte_rrc_transmissionModeDL_MBSFN_r15 = -1;  /* T_transmissionModeDL_MBSFN_r15 */
static int hf_lte_rrc_transmissionModeDL_nonMBSFN_r15 = -1;  /* T_transmissionModeDL_nonMBSFN_r15 */
static int hf_lte_rrc_codebookSubsetRestriction_01 = -1;  /* T_codebookSubsetRestriction_01 */
static int hf_lte_rrc_n2TxAntenna_tm3_r15 = -1;   /* BIT_STRING_SIZE_2 */
static int hf_lte_rrc_n4TxAntenna_tm3_r15 = -1;   /* BIT_STRING_SIZE_4 */
static int hf_lte_rrc_n2TxAntenna_tm4_r15 = -1;   /* BIT_STRING_SIZE_6 */
static int hf_lte_rrc_n4TxAntenna_tm4_r15 = -1;   /* BIT_STRING_SIZE_64 */
static int hf_lte_rrc_n2TxAntenna_tm5_r15 = -1;   /* BIT_STRING_SIZE_4 */
static int hf_lte_rrc_n4TxAntenna_tm5_r15 = -1;   /* BIT_STRING_SIZE_16 */
static int hf_lte_rrc_n2TxAntenna_tm6_r15 = -1;   /* BIT_STRING_SIZE_4 */
static int hf_lte_rrc_n4TxAntenna_tm6_r15 = -1;   /* BIT_STRING_SIZE_16 */
static int hf_lte_rrc_n2TxAntenna_tm8_r15 = -1;   /* BIT_STRING_SIZE_6 */
static int hf_lte_rrc_n4TxAntenna_tm8_r15 = -1;   /* BIT_STRING_SIZE_64 */
static int hf_lte_rrc_n2TxAntenna_tm9and10_r15 = -1;  /* BIT_STRING_SIZE_6 */
static int hf_lte_rrc_n4TxAntenna_tm9and10_r15 = -1;  /* BIT_STRING_SIZE_96 */
static int hf_lte_rrc_n8TxAntenna_tm9and10_r15 = -1;  /* BIT_STRING_SIZE_109 */
static int hf_lte_rrc_maxLayersMIMO_STTI_r15 = -1;  /* T_maxLayersMIMO_STTI_r15 */
static int hf_lte_rrc_slotSubslotPDSCH_TxDiv_2Layer_r15 = -1;  /* BOOLEAN */
static int hf_lte_rrc_slotSubslotPDSCH_TxDiv_4Layer_r15 = -1;  /* BOOLEAN */
static int hf_lte_rrc_setup_09 = -1;              /* T_setup_09 */
static int hf_lte_rrc_ue_TxAntennaSelection_SRS_1T4R_Config_r15 = -1;  /* NULL */
static int hf_lte_rrc_ue_TxAntennaSelection_SRS_2T4R_NrOfPairs_r15 = -1;  /* T_ue_TxAntennaSelection_SRS_2T4R_NrOfPairs_r15 */
static int hf_lte_rrc_transmissionModeUL_r10 = -1;  /* T_transmissionModeUL_r10 */
static int hf_lte_rrc_fourAntennaPortActivated_r10 = -1;  /* T_fourAntennaPortActivated_r10 */
static int hf_lte_rrc_transmissionModeUL_STTI_r15 = -1;  /* T_transmissionModeUL_STTI_r15 */
static int hf_lte_rrc_setup_10 = -1;              /* T_setup_10 */
static int hf_lte_rrc_aul_CRNTI_r15 = -1;         /* C_RNTI */
static int hf_lte_rrc_aul_Subframes_r15 = -1;     /* BIT_STRING_SIZE_40 */
static int hf_lte_rrc_aul_HARQ_Processes_r15 = -1;  /* INTEGER_1_16 */
static int hf_lte_rrc_transmissionModeUL_AUL_r15 = -1;  /* T_transmissionModeUL_AUL_r15 */
static int hf_lte_rrc_aul_StartingFullBW_InsideMCOT_r15 = -1;  /* BIT_STRING_SIZE_5 */
static int hf_lte_rrc_aul_StartingFullBW_OutsideMCOT_r15 = -1;  /* BIT_STRING_SIZE_7 */
static int hf_lte_rrc_aul_StartingPartialBW_InsideMCOT_r15 = -1;  /* T_aul_StartingPartialBW_InsideMCOT_r15 */
static int hf_lte_rrc_aul_StartingPartialBW_OutsideMCOT_r15 = -1;  /* T_aul_StartingPartialBW_OutsideMCOT_r15 */
static int hf_lte_rrc_aul_RetransmissionTimer_r15 = -1;  /* T_aul_RetransmissionTimer_r15 */
static int hf_lte_rrc_endingSymbolAUL_r15 = -1;   /* INTEGER_12_13 */
static int hf_lte_rrc_subframeOffsetCOT_Sharing_r15 = -1;  /* INTEGER_2_4 */
static int hf_lte_rrc_contentionWindowSizeTimer_r15 = -1;  /* T_contentionWindowSizeTimer_r15 */
static int hf_lte_rrc_setup_11 = -1;              /* T_setup_11 */
static int hf_lte_rrc_cqi_ReportModeAperiodic_r10 = -1;  /* CQI_ReportModeAperiodic */
static int hf_lte_rrc_aperiodicCSI_Trigger_r10 = -1;  /* T_aperiodicCSI_Trigger_r10 */
static int hf_lte_rrc_trigger1_r10 = -1;          /* BIT_STRING_SIZE_8 */
static int hf_lte_rrc_trigger2_r10 = -1;          /* BIT_STRING_SIZE_8 */
static int hf_lte_rrc_setup_12 = -1;              /* T_setup_12 */
static int hf_lte_rrc_aperiodicCSI_Trigger_v1250 = -1;  /* T_aperiodicCSI_Trigger_v1250 */
static int hf_lte_rrc_trigger_SubframeSetIndicator_r12 = -1;  /* T_trigger_SubframeSetIndicator_r12 */
static int hf_lte_rrc_trigger1_SubframeSetIndicator_r12 = -1;  /* BIT_STRING_SIZE_8 */
static int hf_lte_rrc_trigger2_SubframeSetIndicator_r12 = -1;  /* BIT_STRING_SIZE_8 */
static int hf_lte_rrc_setup_13 = -1;              /* T_setup_13 */
static int hf_lte_rrc_aperiodicCSI_Trigger_v1310 = -1;  /* T_aperiodicCSI_Trigger_v1310 */
static int hf_lte_rrc_trigger1_r13 = -1;          /* BIT_STRING_SIZE_32 */
static int hf_lte_rrc_trigger2_r13 = -1;          /* BIT_STRING_SIZE_32 */
static int hf_lte_rrc_trigger3_r13 = -1;          /* BIT_STRING_SIZE_32 */
static int hf_lte_rrc_trigger4_r13 = -1;          /* BIT_STRING_SIZE_32 */
static int hf_lte_rrc_trigger5_r13 = -1;          /* BIT_STRING_SIZE_32 */
static int hf_lte_rrc_trigger6_r13 = -1;          /* BIT_STRING_SIZE_32 */
static int hf_lte_rrc_aperiodicCSI_Trigger2_r13 = -1;  /* T_aperiodicCSI_Trigger2_r13 */
static int hf_lte_rrc_setup_14 = -1;              /* T_setup_14 */
static int hf_lte_rrc_trigger1_SubframeSetIndicator_r13 = -1;  /* BIT_STRING_SIZE_32 */
static int hf_lte_rrc_trigger2_SubframeSetIndicator_r13 = -1;  /* BIT_STRING_SIZE_32 */
static int hf_lte_rrc_trigger3_SubframeSetIndicator_r13 = -1;  /* BIT_STRING_SIZE_32 */
static int hf_lte_rrc_trigger4_SubframeSetIndicator_r13 = -1;  /* BIT_STRING_SIZE_32 */
static int hf_lte_rrc_trigger5_SubframeSetIndicator_r13 = -1;  /* BIT_STRING_SIZE_32 */
static int hf_lte_rrc_trigger6_SubframeSetIndicator_r13 = -1;  /* BIT_STRING_SIZE_32 */
static int hf_lte_rrc_cqi_ReportModeAperiodic_r11 = -1;  /* CQI_ReportModeAperiodic */
static int hf_lte_rrc_trigger01_r11 = -1;         /* BOOLEAN */
static int hf_lte_rrc_trigger10_r11 = -1;         /* BOOLEAN */
static int hf_lte_rrc_trigger11_r11 = -1;         /* BOOLEAN */
static int hf_lte_rrc_trigger001_r13 = -1;        /* BOOLEAN */
static int hf_lte_rrc_trigger010_r13 = -1;        /* BOOLEAN */
static int hf_lte_rrc_trigger011_r13 = -1;        /* BOOLEAN */
static int hf_lte_rrc_trigger100_r13 = -1;        /* BOOLEAN */
static int hf_lte_rrc_trigger101_r13 = -1;        /* BOOLEAN */
static int hf_lte_rrc_trigger110_r13 = -1;        /* BOOLEAN */
static int hf_lte_rrc_trigger111_r13 = -1;        /* BOOLEAN */
static int hf_lte_rrc_triggers_r14 = -1;          /* T_triggers_r14 */
static int hf_lte_rrc_oneBit_r14 = -1;            /* T_oneBit_r14 */
static int hf_lte_rrc_trigger1_Indicator_r14 = -1;  /* BIT_STRING_SIZE_8 */
static int hf_lte_rrc_twoBit_r14 = -1;            /* T_twoBit_r14 */
static int hf_lte_rrc_trigger01_Indicator_r14 = -1;  /* BIT_STRING_SIZE_8 */
static int hf_lte_rrc_trigger10_Indicator_r14 = -1;  /* BIT_STRING_SIZE_8 */
static int hf_lte_rrc_trigger11_Indicator_r14 = -1;  /* BIT_STRING_SIZE_8 */
static int hf_lte_rrc_threeBit_r14 = -1;          /* T_threeBit_r14 */
static int hf_lte_rrc_trigger001_Indicator_r14 = -1;  /* BIT_STRING_SIZE_32 */
static int hf_lte_rrc_trigger010_Indicator_r14 = -1;  /* BIT_STRING_SIZE_32 */
static int hf_lte_rrc_trigger011_Indicator_r14 = -1;  /* BIT_STRING_SIZE_32 */
static int hf_lte_rrc_trigger100_Indicator_r14 = -1;  /* BIT_STRING_SIZE_32 */
static int hf_lte_rrc_trigger101_Indicator_r14 = -1;  /* BIT_STRING_SIZE_32 */
static int hf_lte_rrc_trigger110_Indicator_r14 = -1;  /* BIT_STRING_SIZE_32 */
static int hf_lte_rrc_trigger111_Indicator_r14 = -1;  /* BIT_STRING_SIZE_32 */
static int hf_lte_rrc_csi_IM_ConfigToReleaseList_r11 = -1;  /* CSI_IM_ConfigToReleaseList_r11 */
static int hf_lte_rrc_csi_IM_ConfigToAddModList_r11 = -1;  /* CSI_IM_ConfigToAddModList_r11 */
static int hf_lte_rrc_csi_ProcessToReleaseList_r11 = -1;  /* CSI_ProcessToReleaseList_r11 */
static int hf_lte_rrc_csi_ProcessToAddModList_r11 = -1;  /* CSI_ProcessToAddModList_r11 */
static int hf_lte_rrc_csi_IM_ConfigToReleaseListExt_r12 = -1;  /* CSI_IM_ConfigId_v1250 */
static int hf_lte_rrc_csi_IM_ConfigToAddModListExt_r12 = -1;  /* CSI_IM_ConfigExt_r12 */
static int hf_lte_rrc_csi_IM_ConfigToReleaseListExt_r13 = -1;  /* CSI_IM_ConfigToReleaseListExt_r13 */
static int hf_lte_rrc_csi_IM_ConfigToAddModListExt_r13 = -1;  /* CSI_IM_ConfigToAddModListExt_r13 */
static int hf_lte_rrc_CSI_IM_ConfigToAddModList_r11_item = -1;  /* CSI_IM_Config_r11 */
static int hf_lte_rrc_CSI_IM_ConfigToAddModListExt_r13_item = -1;  /* CSI_IM_ConfigExt_r12 */
static int hf_lte_rrc_CSI_IM_ConfigToReleaseList_r11_item = -1;  /* CSI_IM_ConfigId_r11 */
static int hf_lte_rrc_CSI_IM_ConfigToReleaseListExt_r13_item = -1;  /* CSI_IM_ConfigId_v1310 */
static int hf_lte_rrc_CSI_ProcessToAddModList_r11_item = -1;  /* CSI_Process_r11 */
static int hf_lte_rrc_CSI_ProcessToReleaseList_r11_item = -1;  /* CSI_ProcessId_r11 */
static int hf_lte_rrc_ri_Ref_CSI_ProcessId_r11 = -1;  /* CSI_ProcessId_r11 */
static int hf_lte_rrc_pmi_RI_Report_r11 = -1;     /* T_pmi_RI_Report_r11 */
static int hf_lte_rrc_cqi_ReportModeAperiodic = -1;  /* CQI_ReportModeAperiodic */
static int hf_lte_rrc_nomPDSCH_RS_EPRE_Offset = -1;  /* INTEGER_M1_6 */
static int hf_lte_rrc_cqi_ReportPeriodic = -1;    /* CQI_ReportPeriodic */
static int hf_lte_rrc_cqi_Mask_r9 = -1;           /* T_cqi_Mask_r9 */
static int hf_lte_rrc_pmi_RI_Report_r9 = -1;      /* T_pmi_RI_Report_r9 */
static int hf_lte_rrc_cqi_ReportAperiodic_r10 = -1;  /* CQI_ReportAperiodic_r10 */
static int hf_lte_rrc_cqi_ReportPeriodic_r10 = -1;  /* CQI_ReportPeriodic_r10 */
static int hf_lte_rrc_pmi_RI_Report_r9_01 = -1;   /* T_pmi_RI_Report_r9_01 */
static int hf_lte_rrc_csi_SubframePatternConfig_r10 = -1;  /* T_csi_SubframePatternConfig_r10 */
static int hf_lte_rrc_setup_15 = -1;              /* T_setup_15 */
static int hf_lte_rrc_csi_MeasSubframeSet1_r10 = -1;  /* MeasSubframePattern_r10 */
static int hf_lte_rrc_csi_MeasSubframeSet2_r10 = -1;  /* MeasSubframePattern_r10 */
static int hf_lte_rrc_cqi_ReportPeriodic_v1130 = -1;  /* CQI_ReportPeriodic_v1130 */
static int hf_lte_rrc_cqi_ReportBoth_r11 = -1;    /* CQI_ReportBoth_r11 */
static int hf_lte_rrc_csi_SubframePatternConfig_r12 = -1;  /* T_csi_SubframePatternConfig_r12 */
static int hf_lte_rrc_setup_16 = -1;              /* T_setup_16 */
static int hf_lte_rrc_csi_MeasSubframeSets_r12 = -1;  /* BIT_STRING_SIZE_10 */
static int hf_lte_rrc_cqi_ReportBoth_v1250 = -1;  /* CQI_ReportBoth_v1250 */
static int hf_lte_rrc_cqi_ReportAperiodic_v1250 = -1;  /* CQI_ReportAperiodic_v1250 */
static int hf_lte_rrc_altCQI_Table_r12 = -1;      /* T_altCQI_Table_r12 */
static int hf_lte_rrc_cqi_ReportBoth_v1310 = -1;  /* CQI_ReportBoth_v1310 */
static int hf_lte_rrc_cqi_ReportAperiodic_v1310 = -1;  /* CQI_ReportAperiodic_v1310 */
static int hf_lte_rrc_cqi_ReportPeriodic_v1310 = -1;  /* CQI_ReportPeriodic_v1310 */
static int hf_lte_rrc_cqi_ReportPeriodic_v1320 = -1;  /* CQI_ReportPeriodic_v1320 */
static int hf_lte_rrc_cqi_ReportAperiodicHybrid_r14 = -1;  /* CQI_ReportAperiodicHybrid_r14 */
static int hf_lte_rrc_altCQI_Table_1024QAM_r15 = -1;  /* T_altCQI_Table_1024QAM_r15 */
static int hf_lte_rrc_setup_17 = -1;              /* T_setup_17 */
static int hf_lte_rrc_cqi_ReportConfig_r10 = -1;  /* CQI_ReportConfig_r10 */
static int hf_lte_rrc_cqi_ReportConfig_v1130 = -1;  /* CQI_ReportConfig_v1130 */
static int hf_lte_rrc_cqi_ReportConfigPCell_v1250 = -1;  /* CQI_ReportConfig_v1250 */
static int hf_lte_rrc_cqi_ReportConfig_v1310 = -1;  /* CQI_ReportConfig_v1310 */
static int hf_lte_rrc_cqi_ReportConfig_v1320 = -1;  /* CQI_ReportConfig_v1320 */
static int hf_lte_rrc_cqi_ReportConfig_v1430 = -1;  /* CQI_ReportConfig_v1430 */
static int hf_lte_rrc_altCQI_Table_1024QAM_r15_01 = -1;  /* T_altCQI_Table_1024QAM_r15_01 */
static int hf_lte_rrc_nomPDSCH_RS_EPRE_Offset_r10 = -1;  /* INTEGER_M1_6 */
static int hf_lte_rrc_cqi_ReportPeriodicSCell_r10 = -1;  /* CQI_ReportPeriodic_r10 */
static int hf_lte_rrc_pmi_RI_Report_r10 = -1;     /* T_pmi_RI_Report_r10 */
static int hf_lte_rrc_cqi_ReportPeriodicSCell_r15 = -1;  /* CQI_ReportPeriodicSCell_r15 */
static int hf_lte_rrc_altCQI_Table_1024QAM_r15_02 = -1;  /* T_altCQI_Table_1024QAM_r15_02 */
static int hf_lte_rrc_setup_18 = -1;              /* T_setup_18 */
static int hf_lte_rrc_cqi_PUCCH_ResourceIndex = -1;  /* INTEGER_0_1185 */
static int hf_lte_rrc_cqi_pmi_ConfigIndex = -1;   /* INTEGER_0_1023 */
static int hf_lte_rrc_cqi_FormatIndicatorPeriodic = -1;  /* T_cqi_FormatIndicatorPeriodic */
static int hf_lte_rrc_widebandCQI = -1;           /* NULL */
static int hf_lte_rrc_subbandCQI = -1;            /* T_subbandCQI */
static int hf_lte_rrc_k = -1;                     /* INTEGER_1_4 */
static int hf_lte_rrc_ri_ConfigIndex = -1;        /* INTEGER_0_1023 */
static int hf_lte_rrc_simultaneousAckNackAndCQI = -1;  /* BOOLEAN */
static int hf_lte_rrc_setup_19 = -1;              /* T_setup_19 */
static int hf_lte_rrc_cqi_PUCCH_ResourceIndex_r10 = -1;  /* INTEGER_0_1184 */
static int hf_lte_rrc_cqi_PUCCH_ResourceIndexP1_r10 = -1;  /* INTEGER_0_1184 */
static int hf_lte_rrc_cqi_FormatIndicatorPeriodic_r10 = -1;  /* T_cqi_FormatIndicatorPeriodic_r10 */
static int hf_lte_rrc_widebandCQI_r10 = -1;       /* T_widebandCQI_r10 */
static int hf_lte_rrc_csi_ReportMode_r10 = -1;    /* T_csi_ReportMode_r10 */
static int hf_lte_rrc_subbandCQI_r10 = -1;        /* T_subbandCQI_r10 */
static int hf_lte_rrc_periodicityFactor_r10 = -1;  /* T_periodicityFactor_r10 */
static int hf_lte_rrc_cqi_Mask_r9_01 = -1;        /* T_cqi_Mask_r9_01 */
static int hf_lte_rrc_csi_ConfigIndex_r10 = -1;   /* T_csi_ConfigIndex_r10 */
static int hf_lte_rrc_setup_20 = -1;              /* T_setup_20 */
static int hf_lte_rrc_cqi_pmi_ConfigIndex2_r10 = -1;  /* INTEGER_0_1023 */
static int hf_lte_rrc_ri_ConfigIndex2_r10 = -1;   /* INTEGER_0_1023 */
static int hf_lte_rrc_simultaneousAckNackAndCQI_Format3_r11 = -1;  /* T_simultaneousAckNackAndCQI_Format3_r11 */
static int hf_lte_rrc_cqi_ReportPeriodicProcExtToReleaseList_r11 = -1;  /* CQI_ReportPeriodicProcExtToReleaseList_r11 */
static int hf_lte_rrc_cqi_ReportPeriodicProcExtToAddModList_r11 = -1;  /* CQI_ReportPeriodicProcExtToAddModList_r11 */
static int hf_lte_rrc_cri_ReportConfig_r13 = -1;  /* CRI_ReportConfig_r13 */
static int hf_lte_rrc_simultaneousAckNackAndCQI_Format4_Format5_r13 = -1;  /* T_simultaneousAckNackAndCQI_Format4_Format5_r13 */
static int hf_lte_rrc_periodicityFactorWB_r13 = -1;  /* T_periodicityFactorWB_r13 */
static int hf_lte_rrc_setup_21 = -1;              /* T_setup_21 */
static int hf_lte_rrc_cqi_pmi_ConfigIndexDormant_r15 = -1;  /* INTEGER_0_1023 */
static int hf_lte_rrc_ri_ConfigIndexDormant_r15 = -1;  /* INTEGER_0_1023 */
static int hf_lte_rrc_csi_SubframePatternDormant_r15 = -1;  /* T_csi_SubframePatternDormant_r15 */
static int hf_lte_rrc_setup_22 = -1;              /* T_setup_22 */
static int hf_lte_rrc_csi_MeasSubframeSet1_r15 = -1;  /* MeasSubframePattern_r10 */
static int hf_lte_rrc_csi_MeasSubframeSet2_r15 = -1;  /* MeasSubframePattern_r10 */
static int hf_lte_rrc_cqi_FormatIndicatorDormant_r15 = -1;  /* T_cqi_FormatIndicatorDormant_r15 */
static int hf_lte_rrc_widebandCQI_r15 = -1;       /* T_widebandCQI_r15 */
static int hf_lte_rrc_csi_ReportMode_r15 = -1;    /* T_csi_ReportMode_r15 */
static int hf_lte_rrc_subbandCQI_r15 = -1;        /* T_subbandCQI_r15 */
static int hf_lte_rrc_k_r15 = -1;                 /* INTEGER_1_4 */
static int hf_lte_rrc_periodicityFactor_r15 = -1;  /* T_periodicityFactor_r15 */
static int hf_lte_rrc_CQI_ReportPeriodicProcExtToAddModList_r11_item = -1;  /* CQI_ReportPeriodicProcExt_r11 */
static int hf_lte_rrc_CQI_ReportPeriodicProcExtToReleaseList_r11_item = -1;  /* CQI_ReportPeriodicProcExtId_r11 */
static int hf_lte_rrc_cqi_ReportPeriodicProcExtId_r11 = -1;  /* CQI_ReportPeriodicProcExtId_r11 */
static int hf_lte_rrc_cqi_pmi_ConfigIndex_r11 = -1;  /* INTEGER_0_1023 */
static int hf_lte_rrc_cqi_FormatIndicatorPeriodic_r11 = -1;  /* T_cqi_FormatIndicatorPeriodic_r11 */
static int hf_lte_rrc_widebandCQI_r11 = -1;       /* T_widebandCQI_r11 */
static int hf_lte_rrc_csi_ReportMode_r11 = -1;    /* T_csi_ReportMode_r11 */
static int hf_lte_rrc_subbandCQI_r11 = -1;        /* T_subbandCQI_r11 */
static int hf_lte_rrc_periodicityFactor_r11 = -1;  /* T_periodicityFactor_r11 */
static int hf_lte_rrc_ri_ConfigIndex_r11 = -1;    /* INTEGER_0_1023 */
static int hf_lte_rrc_csi_ConfigIndex_r11 = -1;   /* T_csi_ConfigIndex_r11 */
static int hf_lte_rrc_setup_23 = -1;              /* T_setup_23 */
static int hf_lte_rrc_cqi_pmi_ConfigIndex2_r11 = -1;  /* INTEGER_0_1023 */
static int hf_lte_rrc_ri_ConfigIndex2_r11 = -1;   /* INTEGER_0_1023 */
static int hf_lte_rrc_periodicityFactorWB_r13_01 = -1;  /* T_periodicityFactorWB_r13_01 */
static int hf_lte_rrc_setup_24 = -1;              /* T_setup_24 */
static int hf_lte_rrc_cqi_pmi_ConfigIndexShort_r15 = -1;  /* INTEGER_0_1023 */
static int hf_lte_rrc_ri_ConfigIndexShort_r15 = -1;  /* INTEGER_0_1023 */
static int hf_lte_rrc_cqi_FormatIndicatorShort_r15 = -1;  /* T_cqi_FormatIndicatorShort_r15 */
static int hf_lte_rrc_widebandCQI_Short_r15 = -1;  /* T_widebandCQI_Short_r15 */
static int hf_lte_rrc_csi_ReportModeShort_r15 = -1;  /* T_csi_ReportModeShort_r15 */
static int hf_lte_rrc_subbandCQI_Short_r15 = -1;  /* T_subbandCQI_Short_r15 */
static int hf_lte_rrc_periodicityFactor_r15_01 = -1;  /* T_periodicityFactor_r15_01 */
static int hf_lte_rrc_setup_25 = -1;              /* T_setup_25 */
static int hf_lte_rrc_cri_ConfigIndex_r13 = -1;   /* CRI_ConfigIndex_r13 */
static int hf_lte_rrc_cri_ConfigIndex2_r13 = -1;  /* CRI_ConfigIndex_r13 */
static int hf_lte_rrc_schedulingCellInfo_r10 = -1;  /* T_schedulingCellInfo_r10 */
static int hf_lte_rrc_own_r10 = -1;               /* T_own_r10 */
static int hf_lte_rrc_cif_Presence_r10 = -1;      /* BOOLEAN */
static int hf_lte_rrc_other_r10 = -1;             /* T_other_r10 */
static int hf_lte_rrc_schedulingCellId_r10 = -1;  /* ServCellIndex_r10 */
static int hf_lte_rrc_pdsch_Start_r10 = -1;       /* INTEGER_1_4 */
static int hf_lte_rrc_schedulingCellInfo_r13 = -1;  /* T_schedulingCellInfo_r13 */
static int hf_lte_rrc_own_r13 = -1;               /* T_own_r13 */
static int hf_lte_rrc_cif_Presence_r13 = -1;      /* BOOLEAN */
static int hf_lte_rrc_other_r13 = -1;             /* T_other_r13 */
static int hf_lte_rrc_schedulingCellId_r13 = -1;  /* ServCellIndex_r13 */
static int hf_lte_rrc_pdsch_Start_r13 = -1;       /* INTEGER_1_4 */
static int hf_lte_rrc_cif_InSchedulingCell_r13 = -1;  /* INTEGER_1_7 */
static int hf_lte_rrc_schedulingCellId_r14 = -1;  /* ServCellIndex_r13 */
static int hf_lte_rrc_cif_InSchedulingCell_r14 = -1;  /* INTEGER_1_7 */
static int hf_lte_rrc_csi_IM_ConfigId_r11 = -1;   /* CSI_IM_ConfigId_r11 */
static int hf_lte_rrc_resourceConfig_r11 = -1;    /* INTEGER_0_31 */
static int hf_lte_rrc_subframeConfig_r11 = -1;    /* INTEGER_0_154 */
static int hf_lte_rrc_interferenceMeasRestriction_r13 = -1;  /* BOOLEAN */
static int hf_lte_rrc_csi_IM_ConfigId_v1250 = -1;  /* CSI_IM_ConfigId_v1250 */
static int hf_lte_rrc_resourceConfig_r12 = -1;    /* INTEGER_0_31 */
static int hf_lte_rrc_subframeConfig_r12 = -1;    /* INTEGER_0_154 */
static int hf_lte_rrc_csi_IM_ConfigId_v1310 = -1;  /* CSI_IM_ConfigId_v1310 */
static int hf_lte_rrc_csi_ProcessId_r11 = -1;     /* CSI_ProcessId_r11 */
static int hf_lte_rrc_csi_RS_ConfigNZPId_r11 = -1;  /* CSI_RS_ConfigNZPId_r11 */
static int hf_lte_rrc_p_C_AndCBSRList_r11 = -1;   /* P_C_AndCBSR_Pair_r13a */
static int hf_lte_rrc_cqi_ReportBothProc_r11 = -1;  /* CQI_ReportBothProc_r11 */
static int hf_lte_rrc_cqi_ReportPeriodicProcId_r11 = -1;  /* INTEGER_0_maxCQI_ProcExt_r11 */
static int hf_lte_rrc_cqi_ReportAperiodicProc_r11 = -1;  /* CQI_ReportAperiodicProc_r11 */
static int hf_lte_rrc_alternativeCodebookEnabledFor4TXProc_r12 = -1;  /* T_alternativeCodebookEnabledFor4TXProc_r12 */
static int hf_lte_rrc_csi_IM_ConfigIdList_r12 = -1;  /* T_csi_IM_ConfigIdList_r12 */
static int hf_lte_rrc_setup_26 = -1;              /* SEQUENCE_SIZE_1_2_OF_CSI_IM_ConfigId_r12 */
static int hf_lte_rrc_setup_item = -1;            /* CSI_IM_ConfigId_r12 */
static int hf_lte_rrc_cqi_ReportAperiodicProc2_r12 = -1;  /* T_cqi_ReportAperiodicProc2_r12 */
static int hf_lte_rrc_setup_27 = -1;              /* CQI_ReportAperiodicProc_r11 */
static int hf_lte_rrc_cqi_ReportAperiodicProc_v1310 = -1;  /* T_cqi_ReportAperiodicProc_v1310 */
static int hf_lte_rrc_setup_28 = -1;              /* CQI_ReportAperiodicProc_v1310 */
static int hf_lte_rrc_cqi_ReportAperiodicProc2_v1310 = -1;  /* T_cqi_ReportAperiodicProc2_v1310 */
static int hf_lte_rrc_eMIMO_Type_r13 = -1;        /* CSI_RS_ConfigEMIMO_r13 */
static int hf_lte_rrc_dummy_03 = -1;              /* CSI_RS_ConfigEMIMO_v1430 */
static int hf_lte_rrc_eMIMO_Hybrid_r14 = -1;      /* CSI_RS_ConfigEMIMO_Hybrid_r14 */
static int hf_lte_rrc_advancedCodebookEnabled_r14 = -1;  /* BOOLEAN */
static int hf_lte_rrc_eMIMO_Type_v1480 = -1;      /* CSI_RS_ConfigEMIMO_v1480 */
static int hf_lte_rrc_feCOMP_CSI_Enabled_v1530 = -1;  /* BOOLEAN */
static int hf_lte_rrc_eMIMO_Type_v1530 = -1;      /* CSI_RS_ConfigEMIMO_v1530 */
static int hf_lte_rrc_csi_RS_r10 = -1;            /* T_csi_RS_r10 */
static int hf_lte_rrc_setup_29 = -1;              /* T_setup_26 */
static int hf_lte_rrc_antennaPortsCount_r10 = -1;  /* T_antennaPortsCount_r10 */
static int hf_lte_rrc_resourceConfig_r10 = -1;    /* INTEGER_0_31 */
static int hf_lte_rrc_subframeConfig_r10 = -1;    /* INTEGER_0_154 */
static int hf_lte_rrc_p_C_r10 = -1;               /* INTEGER_M8_15 */
static int hf_lte_rrc_zeroTxPowerCSI_RS_r10 = -1;  /* ZeroTxPowerCSI_RS_Conf_r12 */
static int hf_lte_rrc_zeroTxPowerCSI_RS2_r12 = -1;  /* ZeroTxPowerCSI_RS_Conf_r12 */
static int hf_lte_rrc_ds_ZeroTxPowerCSI_RS_r12 = -1;  /* T_ds_ZeroTxPowerCSI_RS_r12 */
static int hf_lte_rrc_setup_30 = -1;              /* T_setup_27 */
static int hf_lte_rrc_zeroTxPowerCSI_RS_List_r12 = -1;  /* SEQUENCE_SIZE_1_maxDS_ZTP_CSI_RS_r12_OF_ZeroTxPowerCSI_RS_r12 */
static int hf_lte_rrc_zeroTxPowerCSI_RS_List_r12_item = -1;  /* ZeroTxPowerCSI_RS_r12 */
static int hf_lte_rrc_setup_31 = -1;              /* T_setup_28 */
static int hf_lte_rrc_csi_RS_Config_r10 = -1;     /* CSI_RS_Config_r10 */
static int hf_lte_rrc_csi_RS_Config_v1250 = -1;   /* CSI_RS_Config_v1250 */
static int hf_lte_rrc_csi_RS_Config_v1310 = -1;   /* CSI_RS_Config_v1310 */
static int hf_lte_rrc_csi_RS_Config_v1430 = -1;   /* CSI_RS_Config_v1430 */
static int hf_lte_rrc_setup_32 = -1;              /* ZeroTxPowerCSI_RS_r12 */
static int hf_lte_rrc_zeroTxPowerResourceConfigList_r12 = -1;  /* BIT_STRING_SIZE_16 */
static int hf_lte_rrc_zeroTxPowerSubframeConfig_r12 = -1;  /* INTEGER_0_154 */
static int hf_lte_rrc_csi_RS_ConfigNZPIdListExt_r13 = -1;  /* SEQUENCE_SIZE_1_7_OF_CSI_RS_ConfigNZPId_r13 */
static int hf_lte_rrc_csi_RS_ConfigNZPIdListExt_r13_item = -1;  /* CSI_RS_ConfigNZPId_r13 */
static int hf_lte_rrc_csi_IM_ConfigIdList_r13 = -1;  /* SEQUENCE_SIZE_1_8_OF_CSI_IM_ConfigId_r13 */
static int hf_lte_rrc_csi_IM_ConfigIdList_r13_item = -1;  /* CSI_IM_ConfigId_r13 */
static int hf_lte_rrc_p_C_AndCBSR_PerResourceConfigList_r13 = -1;  /* SEQUENCE_SIZE_1_8_OF_P_C_AndCBSR_Pair_r13 */
static int hf_lte_rrc_p_C_AndCBSR_PerResourceConfigList_r13_item = -1;  /* P_C_AndCBSR_Pair_r13 */
static int hf_lte_rrc_ace_For4Tx_PerResourceConfigList_r13 = -1;  /* T_ace_For4Tx_PerResourceConfigList_r13 */
static int hf_lte_rrc_ace_For4Tx_PerResourceConfigList_r13_item = -1;  /* BOOLEAN */
static int hf_lte_rrc_alternativeCodebookEnabledBeamformed_r13 = -1;  /* T_alternativeCodebookEnabledBeamformed_r13 */
static int hf_lte_rrc_channelMeasRestriction_r13 = -1;  /* T_channelMeasRestriction_r13 */
static int hf_lte_rrc_csi_RS_ConfigNZPIdListExt_r14 = -1;  /* SEQUENCE_SIZE_1_7_OF_CSI_RS_ConfigNZPId_r13 */
static int hf_lte_rrc_csi_RS_ConfigNZPIdListExt_r14_item = -1;  /* CSI_RS_ConfigNZPId_r13 */
static int hf_lte_rrc_csi_IM_ConfigIdList_r14 = -1;  /* SEQUENCE_SIZE_1_8_OF_CSI_IM_ConfigId_r13 */
static int hf_lte_rrc_csi_IM_ConfigIdList_r14_item = -1;  /* CSI_IM_ConfigId_r13 */
static int hf_lte_rrc_p_C_AndCBSR_PerResourceConfigList_r14 = -1;  /* SEQUENCE_SIZE_1_8_OF_P_C_AndCBSR_Pair_r13 */
static int hf_lte_rrc_p_C_AndCBSR_PerResourceConfigList_r14_item = -1;  /* P_C_AndCBSR_Pair_r13 */
static int hf_lte_rrc_ace_For4Tx_PerResourceConfigList_r14 = -1;  /* T_ace_For4Tx_PerResourceConfigList_r14 */
static int hf_lte_rrc_ace_For4Tx_PerResourceConfigList_r14_item = -1;  /* BOOLEAN */
static int hf_lte_rrc_alternativeCodebookEnabledBeamformed_r14 = -1;  /* T_alternativeCodebookEnabledBeamformed_r14 */
static int hf_lte_rrc_channelMeasRestriction_r14 = -1;  /* T_channelMeasRestriction_r14 */
static int hf_lte_rrc_csi_RS_ConfigNZP_ApList_r14 = -1;  /* SEQUENCE_SIZE_1_8_OF_CSI_RS_ConfigNZP_r11 */
static int hf_lte_rrc_csi_RS_ConfigNZP_ApList_r14_item = -1;  /* CSI_RS_ConfigNZP_r11 */
static int hf_lte_rrc_nzp_ResourceConfigOriginal_v1430 = -1;  /* CSI_RS_Config_NZP_v1430 */
static int hf_lte_rrc_csi_RS_NZP_Activation_r14 = -1;  /* CSI_RS_ConfigNZP_Activation_r14 */
static int hf_lte_rrc_transmissionComb_r14 = -1;  /* NZP_TransmissionComb_r14 */
static int hf_lte_rrc_frequencyDensity_r14 = -1;  /* NZP_FrequencyDensity_r14 */
static int hf_lte_rrc_csi_RS_NZP_mode_r14 = -1;   /* T_csi_RS_NZP_mode_r14 */
static int hf_lte_rrc_activatedResources_r14 = -1;  /* INTEGER_0_4 */
static int hf_lte_rrc_setup_33 = -1;              /* T_setup_29 */
static int hf_lte_rrc_nonPrecoded_r13 = -1;       /* CSI_RS_ConfigNonPrecoded_r13 */
static int hf_lte_rrc_beamformed_r13 = -1;        /* CSI_RS_ConfigBeamformed_r13 */
static int hf_lte_rrc_setup_34 = -1;              /* T_setup_30 */
static int hf_lte_rrc_nonPrecoded_v1430 = -1;     /* CSI_RS_ConfigNonPrecoded_v1430 */
static int hf_lte_rrc_beamformed_v1430 = -1;      /* CSI_RS_ConfigBeamformed_v1430 */
static int hf_lte_rrc_setup_35 = -1;              /* T_setup_31 */
static int hf_lte_rrc_nonPrecoded_v1480 = -1;     /* CSI_RS_ConfigNonPrecoded_v1480 */
static int hf_lte_rrc_beamformed_v1480 = -1;      /* CSI_RS_ConfigBeamformed_v1430 */
static int hf_lte_rrc_setup_36 = -1;              /* T_setup_32 */
static int hf_lte_rrc_nonPrecoded_v1530 = -1;     /* CSI_RS_ConfigNonPrecoded_v1530 */
static int hf_lte_rrc_setup_37 = -1;              /* CSI_RS_ConfigBeamformed_r14 */
static int hf_lte_rrc_setup_38 = -1;              /* T_setup_33 */
static int hf_lte_rrc_periodicityOffsetIndex_r14 = -1;  /* INTEGER_0_1023 */
static int hf_lte_rrc_eMIMO_Type2_r14 = -1;       /* CSI_RS_ConfigEMIMO2_r14 */
static int hf_lte_rrc_p_C_AndCBSRList_r13 = -1;   /* P_C_AndCBSR_Pair_r13 */
static int hf_lte_rrc_codebookConfigN1_r13 = -1;  /* T_codebookConfigN1_r13 */
static int hf_lte_rrc_codebookConfigN2_r13 = -1;  /* T_codebookConfigN2_r13 */
static int hf_lte_rrc_codebookOverSamplingRateConfig_O1_r13 = -1;  /* T_codebookOverSamplingRateConfig_O1_r13 */
static int hf_lte_rrc_codebookOverSamplingRateConfig_O2_r13 = -1;  /* T_codebookOverSamplingRateConfig_O2_r13 */
static int hf_lte_rrc_codebookConfig_r13 = -1;    /* INTEGER_1_4 */
static int hf_lte_rrc_csi_IM_ConfigIdList_r13_01 = -1;  /* SEQUENCE_SIZE_1_2_OF_CSI_IM_ConfigId_r13 */
static int hf_lte_rrc_csi_RS_ConfigNZP_EMIMO_r13 = -1;  /* CSI_RS_ConfigNZP_EMIMO_r13 */
static int hf_lte_rrc_csi_RS_ConfigNZP_EMIMO_v1430 = -1;  /* CSI_RS_ConfigNZP_EMIMO_v1430 */
static int hf_lte_rrc_codebookConfigN1_v1430 = -1;  /* T_codebookConfigN1_v1430 */
static int hf_lte_rrc_codebookConfigN2_v1430 = -1;  /* T_codebookConfigN2_v1430 */
static int hf_lte_rrc_nzp_ResourceConfigTM9_Original_v1430 = -1;  /* CSI_RS_Config_NZP_v1430 */
static int hf_lte_rrc_csi_RS_ConfigNZP_EMIMO_v1480 = -1;  /* CSI_RS_ConfigNZP_EMIMO_v1430 */
static int hf_lte_rrc_codebookConfigN1_v1480 = -1;  /* T_codebookConfigN1_v1480 */
static int hf_lte_rrc_codebookConfigN2_r1480 = -1;  /* T_codebookConfigN2_r1480 */
static int hf_lte_rrc_nzp_ResourceConfigTM9_Original_v1480 = -1;  /* CSI_RS_Config_NZP_v1430 */
static int hf_lte_rrc_p_C_AndCBSRList_r15 = -1;   /* P_C_AndCBSR_Pair_r15 */
static int hf_lte_rrc_antennaPortsCount_r11 = -1;  /* T_antennaPortsCount_r11 */
static int hf_lte_rrc_scramblingIdentity_r11 = -1;  /* INTEGER_0_503 */
static int hf_lte_rrc_qcl_CRS_Info_r11 = -1;      /* T_qcl_CRS_Info_r11 */
static int hf_lte_rrc_qcl_ScramblingIdentity_r11 = -1;  /* INTEGER_0_503 */
static int hf_lte_rrc_crs_PortsCount_r11 = -1;    /* T_crs_PortsCount_r11 */
static int hf_lte_rrc_mbsfn_SubframeConfigList_r11 = -1;  /* T_mbsfn_SubframeConfigList_r11 */
static int hf_lte_rrc_setup_39 = -1;              /* T_setup_34 */
static int hf_lte_rrc_subframeConfigList = -1;    /* MBSFN_SubframeConfigList */
static int hf_lte_rrc_csi_RS_ConfigNZPId_v1310 = -1;  /* CSI_RS_ConfigNZPId_v1310 */
static int hf_lte_rrc_mbsfn_SubframeConfigList_v1430_01 = -1;  /* T_mbsfn_SubframeConfigList_v1430 */
static int hf_lte_rrc_setup_40 = -1;              /* T_setup_35 */
static int hf_lte_rrc_subframeConfigList_v1430 = -1;  /* MBSFN_SubframeConfigList_v1430 */
static int hf_lte_rrc_setup_41 = -1;              /* T_setup_36 */
static int hf_lte_rrc_nzp_resourceConfigList_r13 = -1;  /* SEQUENCE_SIZE_1_2_OF_NZP_ResourceConfig_r13 */
static int hf_lte_rrc_nzp_resourceConfigList_r13_item = -1;  /* NZP_ResourceConfig_r13 */
static int hf_lte_rrc_cdmType_r13 = -1;           /* T_cdmType_r13 */
static int hf_lte_rrc_nzp_resourceConfigListExt_r14 = -1;  /* SEQUENCE_SIZE_0_4_OF_NZP_ResourceConfig_r13 */
static int hf_lte_rrc_nzp_resourceConfigListExt_r14_item = -1;  /* NZP_ResourceConfig_r13 */
static int hf_lte_rrc_cdmType_v1430 = -1;         /* T_cdmType_v1430 */
static int hf_lte_rrc_resourceConfig_r13 = -1;    /* ResourceConfig_r13 */
static int hf_lte_rrc_csi_RS_ConfigZPId_r11 = -1;  /* CSI_RS_ConfigZPId_r11 */
static int hf_lte_rrc_resourceConfigList_r11 = -1;  /* BIT_STRING_SIZE_16 */
static int hf_lte_rrc_setup_42 = -1;              /* SEQUENCE_SIZE_1_maxCSI_RS_ZP_r11_OF_CSI_RS_ConfigZP_r11 */
static int hf_lte_rrc_setup_item_01 = -1;         /* CSI_RS_ConfigZP_r11 */
static int hf_lte_rrc_setup_43 = -1;              /* T_setup_37 */
static int hf_lte_rrc_scramblingIdentity2_r11 = -1;  /* INTEGER_0_503 */
static int hf_lte_rrc_dmrs_tableAlt_r13 = -1;     /* T_dmrs_tableAlt_r13 */
static int hf_lte_rrc_config_r11 = -1;            /* T_config_r11 */
static int hf_lte_rrc_setup_44 = -1;              /* T_setup_38 */
static int hf_lte_rrc_subframePatternConfig_r11 = -1;  /* T_subframePatternConfig_r11 */
static int hf_lte_rrc_setup_45 = -1;              /* T_setup_39 */
static int hf_lte_rrc_subframePattern_r11 = -1;   /* MeasSubframePattern_r10 */
static int hf_lte_rrc_startSymbol_r11 = -1;       /* INTEGER_1_4 */
static int hf_lte_rrc_setConfigToReleaseList_r11 = -1;  /* EPDCCH_SetConfigToReleaseList_r11 */
static int hf_lte_rrc_setConfigToAddModList_r11 = -1;  /* EPDCCH_SetConfigToAddModList_r11 */
static int hf_lte_rrc_EPDCCH_SetConfigToAddModList_r11_item = -1;  /* EPDCCH_SetConfig_r11 */
static int hf_lte_rrc_EPDCCH_SetConfigToReleaseList_r11_item = -1;  /* EPDCCH_SetConfigId_r11 */
static int hf_lte_rrc_setConfigId_r11 = -1;       /* EPDCCH_SetConfigId_r11 */
static int hf_lte_rrc_transmissionType_r11 = -1;  /* T_transmissionType_r11 */
static int hf_lte_rrc_resourceBlockAssignment_r11 = -1;  /* T_resourceBlockAssignment_r11 */
static int hf_lte_rrc_numberPRB_Pairs_r11 = -1;   /* T_numberPRB_Pairs_r11 */
static int hf_lte_rrc_resourceBlockAssignment_r11_01 = -1;  /* BIT_STRING_SIZE_4_38 */
static int hf_lte_rrc_dmrs_ScramblingSequenceInt_r11 = -1;  /* INTEGER_0_503 */
static int hf_lte_rrc_pucch_ResourceStartOffset_r11 = -1;  /* INTEGER_0_2047 */
static int hf_lte_rrc_re_MappingQCL_ConfigId_r11 = -1;  /* PDSCH_RE_MappingQCL_ConfigId_r11 */
static int hf_lte_rrc_csi_RS_ConfigZPId2_r12 = -1;  /* T_csi_RS_ConfigZPId2_r12 */
static int hf_lte_rrc_setup_46 = -1;              /* CSI_RS_ConfigZPId_r11 */
static int hf_lte_rrc_numberPRB_Pairs_v1310 = -1;  /* T_numberPRB_Pairs_v1310 */
static int hf_lte_rrc_setup_47 = -1;              /* T_setup_40 */
static int hf_lte_rrc_mpdcch_config_r13 = -1;     /* T_mpdcch_config_r13 */
static int hf_lte_rrc_setup_48 = -1;              /* T_setup_41 */
static int hf_lte_rrc_csi_NumRepetitionCE_r13 = -1;  /* T_csi_NumRepetitionCE_r13 */
static int hf_lte_rrc_mpdcch_pdsch_HoppingConfig_r13 = -1;  /* T_mpdcch_pdsch_HoppingConfig_r13 */
static int hf_lte_rrc_mpdcch_StartSF_UESS_r13 = -1;  /* T_mpdcch_StartSF_UESS_r13 */
static int hf_lte_rrc_fdd_r13 = -1;               /* T_fdd_r13 */
static int hf_lte_rrc_tdd_r13 = -1;               /* T_tdd_r13 */
static int hf_lte_rrc_mpdcch_NumRepetition_r13_01 = -1;  /* T_mpdcch_NumRepetition_r13 */
static int hf_lte_rrc_mpdcch_Narrowband_r13 = -1;  /* INTEGER_1_maxAvailNarrowBands_r13 */
static int hf_lte_rrc_setup_49 = -1;              /* T_setup_42 */
static int hf_lte_rrc_eimta_RNTI_r12 = -1;        /* C_RNTI */
static int hf_lte_rrc_eimta_CommandPeriodicity_r12 = -1;  /* T_eimta_CommandPeriodicity_r12 */
static int hf_lte_rrc_eimta_CommandSubframeSet_r12 = -1;  /* BIT_STRING_SIZE_10 */
static int hf_lte_rrc_setup_50 = -1;              /* T_setup_43 */
static int hf_lte_rrc_eimta_UL_DL_ConfigIndex_r12 = -1;  /* INTEGER_1_5 */
static int hf_lte_rrc_eimta_HARQ_ReferenceConfig_r12 = -1;  /* T_eimta_HARQ_ReferenceConfig_r12 */
static int hf_lte_rrc_mbsfn_SubframeConfigList_v1250 = -1;  /* T_mbsfn_SubframeConfigList_v1250 */
static int hf_lte_rrc_setup_51 = -1;              /* T_setup_44 */
static int hf_lte_rrc_subframeConfigList_r12 = -1;  /* MBSFN_SubframeConfigList */
static int hf_lte_rrc_ul_SpecificParameters = -1;  /* T_ul_SpecificParameters */
static int hf_lte_rrc_priority = -1;              /* T_priority */
static int hf_lte_rrc_prioritisedBitRate = -1;    /* T_prioritisedBitRate */
static int hf_lte_rrc_bucketSizeDuration = -1;    /* T_bucketSizeDuration */
static int hf_lte_rrc_logicalChannelGroup = -1;   /* INTEGER_0_3 */
static int hf_lte_rrc_logicalChannelSR_Mask_r9 = -1;  /* T_logicalChannelSR_Mask_r9 */
static int hf_lte_rrc_logicalChannelSR_Prohibit_r12 = -1;  /* BOOLEAN */
static int hf_lte_rrc_laa_UL_Allowed_r14 = -1;    /* BOOLEAN */
static int hf_lte_rrc_bitRateQueryProhibitTimer_r14 = -1;  /* T_bitRateQueryProhibitTimer_r14 */
static int hf_lte_rrc_allowedTTI_Lengths_r15 = -1;  /* T_allowedTTI_Lengths_r15 */
static int hf_lte_rrc_setup_52 = -1;              /* T_setup_45 */
static int hf_lte_rrc_shortTTI_r15 = -1;          /* BOOLEAN */
static int hf_lte_rrc_subframeTTI_r15 = -1;       /* BOOLEAN */
static int hf_lte_rrc_logicalChannelSR_Restriction_r15 = -1;  /* T_logicalChannelSR_Restriction_r15 */
static int hf_lte_rrc_setup_53 = -1;              /* T_setup_46 */
static int hf_lte_rrc_channellAccessPriority_r15 = -1;  /* T_channellAccessPriority_r15 */
static int hf_lte_rrc_setup_54 = -1;              /* INTEGER_1_4 */
static int hf_lte_rrc_lch_CellRestriction_r15 = -1;  /* BIT_STRING_SIZE_maxServCell_r13 */
static int hf_lte_rrc_setup_55 = -1;              /* T_setup_47 */
static int hf_lte_rrc_lwa_Config_r13 = -1;        /* LWA_Config_r13 */
static int hf_lte_rrc_lwa_MobilityConfig_r13 = -1;  /* WLAN_MobilityConfig_r13 */
static int hf_lte_rrc_lwa_WT_Counter_r13 = -1;    /* INTEGER_0_65535 */
static int hf_lte_rrc_wt_MAC_Address_r14 = -1;    /* OCTET_STRING_SIZE_6 */
static int hf_lte_rrc_setup_56 = -1;              /* T_setup_48 */
static int hf_lte_rrc_lwip_Config_r13 = -1;       /* LWIP_Config_r13 */
static int hf_lte_rrc_lwip_MobilityConfig_r13 = -1;  /* WLAN_MobilityConfig_r13 */
static int hf_lte_rrc_tunnelConfigLWIP_r13 = -1;  /* TunnelConfigLWIP_r13 */
static int hf_lte_rrc_ul_SCH_Config = -1;         /* T_ul_SCH_Config */
static int hf_lte_rrc_maxHARQ_Tx = -1;            /* T_maxHARQ_Tx */
static int hf_lte_rrc_periodicBSR_Timer = -1;     /* PeriodicBSR_Timer_r12 */
static int hf_lte_rrc_retxBSR_Timer = -1;         /* RetxBSR_Timer_r12 */
static int hf_lte_rrc_ttiBundling = -1;           /* BOOLEAN */
static int hf_lte_rrc_drx_Config = -1;            /* DRX_Config */
static int hf_lte_rrc_timeAlignmentTimerDedicated = -1;  /* TimeAlignmentTimer */
static int hf_lte_rrc_phr_Config = -1;            /* T_phr_Config */
static int hf_lte_rrc_setup_57 = -1;              /* T_setup_49 */
static int hf_lte_rrc_periodicPHR_Timer = -1;     /* T_periodicPHR_Timer */
static int hf_lte_rrc_prohibitPHR_Timer = -1;     /* T_prohibitPHR_Timer */
static int hf_lte_rrc_dl_PathlossChange = -1;     /* T_dl_PathlossChange */
static int hf_lte_rrc_sr_ProhibitTimer_r9 = -1;   /* T_sr_ProhibitTimer_r9 */
static int hf_lte_rrc_mac_MainConfig_v1020 = -1;  /* T_mac_MainConfig_v1020 */
static int hf_lte_rrc_sCellDeactivationTimer_r10 = -1;  /* T_sCellDeactivationTimer_r10 */
static int hf_lte_rrc_extendedBSR_Sizes_r10 = -1;  /* T_extendedBSR_Sizes_r10 */
static int hf_lte_rrc_extendedPHR_r10 = -1;       /* T_extendedPHR_r10 */
static int hf_lte_rrc_stag_ToReleaseList_r11 = -1;  /* STAG_ToReleaseList_r11 */
static int hf_lte_rrc_stag_ToAddModList_r11 = -1;  /* STAG_ToAddModList_r11 */
static int hf_lte_rrc_drx_Config_v1130 = -1;      /* DRX_Config_v1130 */
static int hf_lte_rrc_e_HARQ_Pattern_r12 = -1;    /* BOOLEAN */
static int hf_lte_rrc_dualConnectivityPHR = -1;   /* T_dualConnectivityPHR */
static int hf_lte_rrc_setup_58 = -1;              /* T_setup_50 */
static int hf_lte_rrc_phr_ModeOtherCG_r12 = -1;   /* T_phr_ModeOtherCG_r12 */
static int hf_lte_rrc_logicalChannelSR_Config_r12 = -1;  /* T_logicalChannelSR_Config_r12 */
static int hf_lte_rrc_setup_59 = -1;              /* T_setup_51 */
static int hf_lte_rrc_logicalChannelSR_ProhibitTimer_r12 = -1;  /* T_logicalChannelSR_ProhibitTimer_r12 */
static int hf_lte_rrc_drx_Config_v1310 = -1;      /* DRX_Config_v1310 */
static int hf_lte_rrc_extendedPHR2_r13 = -1;      /* BOOLEAN */
static int hf_lte_rrc_eDRX_Config_CycleStartOffset_r13 = -1;  /* T_eDRX_Config_CycleStartOffset_r13 */
static int hf_lte_rrc_setup_60 = -1;              /* T_setup_52 */
static int hf_lte_rrc_sf5120 = -1;                /* INTEGER_0_1 */
static int hf_lte_rrc_sf10240 = -1;               /* INTEGER_0_3 */
static int hf_lte_rrc_drx_Config_r13 = -1;        /* T_drx_Config_r13 */
static int hf_lte_rrc_setup_61 = -1;              /* DRX_Config_r13 */
static int hf_lte_rrc_skipUplinkTx_r14 = -1;      /* T_skipUplinkTx_r14 */
static int hf_lte_rrc_setup_62 = -1;              /* T_setup_53 */
static int hf_lte_rrc_skipUplinkTxSPS_r14 = -1;   /* T_skipUplinkTxSPS_r14 */
static int hf_lte_rrc_skipUplinkTxDynamic_r14 = -1;  /* T_skipUplinkTxDynamic_r14 */
static int hf_lte_rrc_dataInactivityTimerConfig_r14 = -1;  /* T_dataInactivityTimerConfig_r14 */
static int hf_lte_rrc_setup_63 = -1;              /* T_setup_54 */
static int hf_lte_rrc_dataInactivityTimer_r14 = -1;  /* DataInactivityTimer_r14 */
static int hf_lte_rrc_rai_Activation_r14 = -1;    /* T_rai_Activation_r14 */
static int hf_lte_rrc_shortTTI_AndSPT_r15 = -1;   /* T_shortTTI_AndSPT_r15 */
static int hf_lte_rrc_setup_64 = -1;              /* T_setup_55 */
static int hf_lte_rrc_drx_Config_r15 = -1;        /* DRX_Config_r15 */
static int hf_lte_rrc_periodicBSR_Timer_r15 = -1;  /* T_periodicBSR_Timer_r15 */
static int hf_lte_rrc_proc_Timeline_r15 = -1;     /* T_proc_Timeline_r15 */
static int hf_lte_rrc_ssr_ProhibitTimer_r15 = -1;  /* INTEGER_0_7 */
static int hf_lte_rrc_mpdcch_UL_HARQ_ACK_FeedbackConfig_r15 = -1;  /* BOOLEAN */
static int hf_lte_rrc_dormantStateTimers_r15 = -1;  /* T_dormantStateTimers_r15 */
static int hf_lte_rrc_setup_65 = -1;              /* T_setup_56 */
static int hf_lte_rrc_sCellHibernationTimer_r15 = -1;  /* T_sCellHibernationTimer_r15 */
static int hf_lte_rrc_dormantSCellDeactivationTimer_r15 = -1;  /* T_dormantSCellDeactivationTimer_r15 */
static int hf_lte_rrc_stag_Id_r11 = -1;           /* STAG_Id_r11 */
static int hf_lte_rrc_release_01 = -1;            /* T_release */
static int hf_lte_rrc_setup_66 = -1;              /* T_setup_57 */
static int hf_lte_rrc_onDurationTimer = -1;       /* T_onDurationTimer */
static int hf_lte_rrc_drx_InactivityTimer = -1;   /* T_drx_InactivityTimer */
static int hf_lte_rrc_drx_RetransmissionTimer = -1;  /* T_drx_RetransmissionTimer */
static int hf_lte_rrc_longDRX_CycleStartOffset = -1;  /* T_longDRX_CycleStartOffset */
static int hf_lte_rrc_sf10_01 = -1;               /* T_sf10 */
static int hf_lte_rrc_sf20_01 = -1;               /* T_sf20 */
static int hf_lte_rrc_sf32_01 = -1;               /* T_sf32 */
static int hf_lte_rrc_sf40_01 = -1;               /* T_sf40 */
static int hf_lte_rrc_sf64_01 = -1;               /* T_sf64 */
static int hf_lte_rrc_sf80_01 = -1;               /* T_sf80 */
static int hf_lte_rrc_sf128_01 = -1;              /* T_sf128 */
static int hf_lte_rrc_sf160_01 = -1;              /* T_sf160 */
static int hf_lte_rrc_sf256_01 = -1;              /* T_sf256 */
static int hf_lte_rrc_sf320_01 = -1;              /* T_sf320 */
static int hf_lte_rrc_sf512_01 = -1;              /* T_sf512 */
static int hf_lte_rrc_sf640_01 = -1;              /* T_sf640 */
static int hf_lte_rrc_sf1024_01 = -1;             /* T_sf1024 */
static int hf_lte_rrc_sf1280 = -1;                /* T_sf1280 */
static int hf_lte_rrc_sf2048_01 = -1;             /* T_sf2048 */
static int hf_lte_rrc_sf2560 = -1;                /* T_sf2560 */
static int hf_lte_rrc_shortDRX = -1;              /* T_shortDRX */
static int hf_lte_rrc_shortDRX_Cycle = -1;        /* T_shortDRX_Cycle */
static int hf_lte_rrc_drxShortCycleTimer = -1;    /* T_drxShortCycleTimer */
static int hf_lte_rrc_drx_RetransmissionTimer_v1130 = -1;  /* T_drx_RetransmissionTimer_v1130 */
static int hf_lte_rrc_longDRX_CycleStartOffset_v1130 = -1;  /* T_longDRX_CycleStartOffset_v1130 */
static int hf_lte_rrc_sf60_v1130 = -1;            /* T_sf60_v1130 */
static int hf_lte_rrc_sf70_v1130 = -1;            /* T_sf70_v1130 */
static int hf_lte_rrc_shortDRX_Cycle_v1130 = -1;  /* T_shortDRX_Cycle_v1130 */
static int hf_lte_rrc_longDRX_CycleStartOffset_v1310 = -1;  /* T_longDRX_CycleStartOffset_v1310 */
static int hf_lte_rrc_sf60_v1310 = -1;            /* T_sf60_v1310 */
static int hf_lte_rrc_onDurationTimer_v1310 = -1;  /* T_onDurationTimer_v1310 */
static int hf_lte_rrc_drx_RetransmissionTimer_v1310 = -1;  /* T_drx_RetransmissionTimer_v1310 */
static int hf_lte_rrc_drx_ULRetransmissionTimer_r13 = -1;  /* T_drx_ULRetransmissionTimer_r13 */
static int hf_lte_rrc_drx_RetransmissionTimerShortTTI_r15 = -1;  /* T_drx_RetransmissionTimerShortTTI_r15 */
static int hf_lte_rrc_drx_UL_RetransmissionTimerShortTTI_r15 = -1;  /* T_drx_UL_RetransmissionTimerShortTTI_r15 */
static int hf_lte_rrc_STAG_ToReleaseList_r11_item = -1;  /* STAG_Id_r11 */
static int hf_lte_rrc_STAG_ToAddModList_r11_item = -1;  /* STAG_ToAddMod_r11 */
static int hf_lte_rrc_timeAlignmentTimerSTAG_r11 = -1;  /* TimeAlignmentTimer */
static int hf_lte_rrc_p_C_r11 = -1;               /* INTEGER_M8_15 */
static int hf_lte_rrc_codebookSubsetRestriction_r11 = -1;  /* BIT_STRING */
static int hf_lte_rrc_p_C_r13 = -1;               /* INTEGER_M8_15 */
static int hf_lte_rrc_cbsr_Selection_r13 = -1;    /* T_cbsr_Selection_r13 */
static int hf_lte_rrc_nonPrecoded_r13_01 = -1;    /* T_nonPrecoded_r13 */
static int hf_lte_rrc_codebookSubsetRestriction1_r13 = -1;  /* BIT_STRING */
static int hf_lte_rrc_codebookSubsetRestriction2_r13 = -1;  /* BIT_STRING */
static int hf_lte_rrc_beamformedK1a_r13 = -1;     /* T_beamformedK1a_r13 */
static int hf_lte_rrc_codebookSubsetRestriction3_r13 = -1;  /* BIT_STRING */
static int hf_lte_rrc_beamformedKN_r13 = -1;      /* T_beamformedKN_r13 */
static int hf_lte_rrc_codebookSubsetRestriction_r13 = -1;  /* BIT_STRING */
static int hf_lte_rrc_p_C_r15 = -1;               /* INTEGER_M8_15 */
static int hf_lte_rrc_codebookSubsetRestriction4_r15 = -1;  /* BIT_STRING */
static int hf_lte_rrc_P_C_AndCBSR_Pair_r13a_item = -1;  /* P_C_AndCBSR_r11 */
static int hf_lte_rrc_P_C_AndCBSR_Pair_r13_item = -1;  /* P_C_AndCBSR_r13 */
static int hf_lte_rrc_P_C_AndCBSR_Pair_r15_item = -1;  /* P_C_AndCBSR_r15 */
static int hf_lte_rrc_skipMonitoringDCI_format0_1A_r13 = -1;  /* T_skipMonitoringDCI_format0_1A_r13 */
static int hf_lte_rrc_maxNumberOfSchedSubframes_Format0B_r14 = -1;  /* T_maxNumberOfSchedSubframes_Format0B_r14 */
static int hf_lte_rrc_maxNumberOfSchedSubframes_Format4B_r14 = -1;  /* T_maxNumberOfSchedSubframes_Format4B_r14 */
static int hf_lte_rrc_skipMonitoringDCI_Format0A_r14 = -1;  /* T_skipMonitoringDCI_Format0A_r14 */
static int hf_lte_rrc_skipMonitoringDCI_Format4A_r14 = -1;  /* T_skipMonitoringDCI_Format4A_r14 */
static int hf_lte_rrc_pdcch_CandidateReductions_Format0A_r14 = -1;  /* PDCCH_CandidateReductions_r13 */
static int hf_lte_rrc_pdcch_CandidateReductions_Format4A_r14 = -1;  /* PDCCH_CandidateReductionsLAA_UL_r14 */
static int hf_lte_rrc_pdcch_CandidateReductions_Format0B_r14 = -1;  /* PDCCH_CandidateReductionsLAA_UL_r14 */
static int hf_lte_rrc_pdcch_CandidateReductions_Format4B_r14 = -1;  /* PDCCH_CandidateReductionsLAA_UL_r14 */
static int hf_lte_rrc_setup_67 = -1;              /* T_setup_58 */
static int hf_lte_rrc_pdcch_candidateReductionAL1_r13 = -1;  /* PDCCH_CandidateReductionValue_r13 */
static int hf_lte_rrc_pdcch_candidateReductionAL2_r13 = -1;  /* PDCCH_CandidateReductionValue_r13 */
static int hf_lte_rrc_pdcch_candidateReductionAL3_r13 = -1;  /* PDCCH_CandidateReductionValue_r13 */
static int hf_lte_rrc_pdcch_candidateReductionAL4_r13 = -1;  /* PDCCH_CandidateReductionValue_r13 */
static int hf_lte_rrc_pdcch_candidateReductionAL5_r13 = -1;  /* PDCCH_CandidateReductionValue_r13 */
static int hf_lte_rrc_setup_68 = -1;              /* T_setup_59 */
static int hf_lte_rrc_pdcch_candidateReductionAL1_r14 = -1;  /* PDCCH_CandidateReductionValue_r13 */
static int hf_lte_rrc_pdcch_candidateReductionAL2_r14 = -1;  /* PDCCH_CandidateReductionValue_r13 */
static int hf_lte_rrc_pdcch_candidateReductionAL3_r14 = -1;  /* PDCCH_CandidateReductionValue_r14 */
static int hf_lte_rrc_pdcch_candidateReductionAL4_r14 = -1;  /* PDCCH_CandidateReductionValue_r14 */
static int hf_lte_rrc_pdcch_candidateReductionAL5_r14 = -1;  /* PDCCH_CandidateReductionValue_r14 */
static int hf_lte_rrc_discardTimer = -1;          /* T_discardTimer */
static int hf_lte_rrc_rlc_AM = -1;                /* T_rlc_AM */
static int hf_lte_rrc_statusReportRequired = -1;  /* BOOLEAN */
static int hf_lte_rrc_rlc_UM = -1;                /* T_rlc_UM */
static int hf_lte_rrc_pdcp_SN_Size = -1;          /* T_pdcp_SN_Size */
static int hf_lte_rrc_headerCompression = -1;     /* T_headerCompression */
static int hf_lte_rrc_notUsed = -1;               /* NULL */
static int hf_lte_rrc_rohc = -1;                  /* T_rohc */
static int hf_lte_rrc_maxCID = -1;                /* INTEGER_1_16383 */
static int hf_lte_rrc_profiles = -1;              /* T_profiles */
static int hf_lte_rrc_profile0x0001 = -1;         /* BOOLEAN */
static int hf_lte_rrc_profile0x0002 = -1;         /* BOOLEAN */
static int hf_lte_rrc_profile0x0003 = -1;         /* BOOLEAN */
static int hf_lte_rrc_profile0x0004 = -1;         /* BOOLEAN */
static int hf_lte_rrc_profile0x0006 = -1;         /* BOOLEAN */
static int hf_lte_rrc_profile0x0101 = -1;         /* BOOLEAN */
static int hf_lte_rrc_profile0x0102 = -1;         /* BOOLEAN */
static int hf_lte_rrc_profile0x0103 = -1;         /* BOOLEAN */
static int hf_lte_rrc_profile0x0104 = -1;         /* BOOLEAN */
static int hf_lte_rrc_rn_IntegrityProtection_r10 = -1;  /* T_rn_IntegrityProtection_r10 */
static int hf_lte_rrc_pdcp_SN_Size_v1130 = -1;    /* T_pdcp_SN_Size_v1130 */
static int hf_lte_rrc_ul_DataSplitDRB_ViaSCG_r12 = -1;  /* BOOLEAN */
static int hf_lte_rrc_t_Reordering_r12 = -1;      /* T_t_Reordering_r12 */
static int hf_lte_rrc_ul_DataSplitThreshold_r13 = -1;  /* T_ul_DataSplitThreshold_r13 */
static int hf_lte_rrc_setup_69 = -1;              /* T_setup_60 */
static int hf_lte_rrc_pdcp_SN_Size_v1310 = -1;    /* T_pdcp_SN_Size_v1310 */
static int hf_lte_rrc_statusFeedback_r13 = -1;    /* T_statusFeedback_r13 */
static int hf_lte_rrc_setup_70 = -1;              /* T_setup_61 */
static int hf_lte_rrc_statusPDU_TypeForPolling_r13 = -1;  /* T_statusPDU_TypeForPolling_r13 */
static int hf_lte_rrc_statusPDU_Periodicity_Type1_r13 = -1;  /* T_statusPDU_Periodicity_Type1_r13 */
static int hf_lte_rrc_statusPDU_Periodicity_Type2_r13 = -1;  /* T_statusPDU_Periodicity_Type2_r13 */
static int hf_lte_rrc_statusPDU_Periodicity_Offset_r13 = -1;  /* T_statusPDU_Periodicity_Offset_r13 */
static int hf_lte_rrc_ul_LWA_Config_r14 = -1;     /* T_ul_LWA_Config_r14 */
static int hf_lte_rrc_setup_71 = -1;              /* T_setup_62 */
static int hf_lte_rrc_ul_LWA_DRB_ViaWLAN_r14 = -1;  /* BOOLEAN */
static int hf_lte_rrc_ul_LWA_DataSplitThreshold_r14 = -1;  /* T_ul_LWA_DataSplitThreshold_r14 */
static int hf_lte_rrc_uplinkOnlyHeaderCompression_r14 = -1;  /* T_uplinkOnlyHeaderCompression_r14 */
static int hf_lte_rrc_notUsed_r14 = -1;           /* NULL */
static int hf_lte_rrc_rohc_r14 = -1;              /* T_rohc_r14 */
static int hf_lte_rrc_maxCID_r14 = -1;            /* INTEGER_1_16383 */
static int hf_lte_rrc_profiles_r14 = -1;          /* T_profiles_r14 */
static int hf_lte_rrc_profile0x0006_r14 = -1;     /* BOOLEAN */
static int hf_lte_rrc_uplinkDataCompression_r15 = -1;  /* T_uplinkDataCompression_r15 */
static int hf_lte_rrc_bufferSize_r15 = -1;        /* T_bufferSize_r15 */
static int hf_lte_rrc_dictionary_r15 = -1;        /* T_dictionary_r15 */
static int hf_lte_rrc_pdcp_DuplicationConfig_r15 = -1;  /* T_pdcp_DuplicationConfig_r15 */
static int hf_lte_rrc_setup_72 = -1;              /* T_setup_63 */
static int hf_lte_rrc_pdcp_Duplication_r15 = -1;  /* T_pdcp_Duplication_r15 */
static int hf_lte_rrc_referenceSignalPower = -1;  /* INTEGER_M60_50 */
static int hf_lte_rrc_p_b = -1;                   /* INTEGER_0_3 */
static int hf_lte_rrc_pdsch_maxNumRepetitionCEmodeA_r13 = -1;  /* T_pdsch_maxNumRepetitionCEmodeA_r13 */
static int hf_lte_rrc_pdsch_maxNumRepetitionCEmodeB_r13 = -1;  /* T_pdsch_maxNumRepetitionCEmodeB_r13 */
static int hf_lte_rrc_p_a = -1;                   /* T_p_a */
static int hf_lte_rrc_dmrs_ConfigPDSCH_r11 = -1;  /* DMRS_Config_r11 */
static int hf_lte_rrc_qcl_Operation = -1;         /* T_qcl_Operation */
static int hf_lte_rrc_re_MappingQCLConfigToReleaseList_r11 = -1;  /* RE_MappingQCLConfigToReleaseList_r11 */
static int hf_lte_rrc_re_MappingQCLConfigToAddModList_r11 = -1;  /* RE_MappingQCLConfigToAddModList_r11 */
static int hf_lte_rrc_tbsIndexAlt_r12 = -1;       /* T_tbsIndexAlt_r12 */
static int hf_lte_rrc_dmrs_ConfigPDSCH_v1310 = -1;  /* DMRS_Config_v1310 */
static int hf_lte_rrc_ce_PDSCH_MaxBandwidth_r14 = -1;  /* T_ce_PDSCH_MaxBandwidth_r14 */
static int hf_lte_rrc_ce_PDSCH_TenProcesses_r14 = -1;  /* T_ce_PDSCH_TenProcesses_r14 */
static int hf_lte_rrc_ce_HARQ_AckBundling_r14 = -1;  /* T_ce_HARQ_AckBundling_r14 */
static int hf_lte_rrc_ce_SchedulingEnhancement_r14 = -1;  /* T_ce_SchedulingEnhancement_r14 */
static int hf_lte_rrc_tbsIndexAlt2_r14 = -1;      /* T_tbsIndexAlt2_r14 */
static int hf_lte_rrc_qcl_Operation_v1530 = -1;   /* T_qcl_Operation_v1530 */
static int hf_lte_rrc_tbs_IndexAlt3_r15 = -1;     /* T_tbs_IndexAlt3_r15 */
static int hf_lte_rrc_ce_CQI_AlternativeTableConfig_r15 = -1;  /* T_ce_CQI_AlternativeTableConfig_r15 */
static int hf_lte_rrc_ce_PDSCH_64QAM_Config_r15 = -1;  /* T_ce_PDSCH_64QAM_Config_r15 */
static int hf_lte_rrc_ce_PDSCH_FlexibleStartPRB_AllocConfig_r15 = -1;  /* T_ce_PDSCH_FlexibleStartPRB_AllocConfig_r15 */
static int hf_lte_rrc_altMCS_TableScalingConfig_r15 = -1;  /* T_altMCS_TableScalingConfig_r15 */
static int hf_lte_rrc_tbsIndexAlt2_r14_01 = -1;   /* T_tbsIndexAlt2_r14_01 */
static int hf_lte_rrc_RE_MappingQCLConfigToAddModList_r11_item = -1;  /* PDSCH_RE_MappingQCL_Config_r11 */
static int hf_lte_rrc_RE_MappingQCLConfigToReleaseList_r11_item = -1;  /* PDSCH_RE_MappingQCL_ConfigId_r11 */
static int hf_lte_rrc_pdsch_RE_MappingQCL_ConfigId_r11 = -1;  /* PDSCH_RE_MappingQCL_ConfigId_r11 */
static int hf_lte_rrc_optionalSetOfFields_r11 = -1;  /* T_optionalSetOfFields_r11 */
static int hf_lte_rrc_crs_PortsCount_r11_01 = -1;  /* T_crs_PortsCount_r11_01 */
static int hf_lte_rrc_crs_FreqShift_r11 = -1;     /* INTEGER_0_5 */
static int hf_lte_rrc_mbsfn_SubframeConfigList_r11_01 = -1;  /* T_mbsfn_SubframeConfigList_r11_01 */
static int hf_lte_rrc_setup_73 = -1;              /* T_setup_64 */
static int hf_lte_rrc_pdsch_Start_r11 = -1;       /* T_pdsch_Start_r11 */
static int hf_lte_rrc_qcl_CSI_RS_ConfigNZPId_r11 = -1;  /* CSI_RS_ConfigNZPId_r11 */
static int hf_lte_rrc_mbsfn_SubframeConfigList_v1430_02 = -1;  /* T_mbsfn_SubframeConfigList_v1430_01 */
static int hf_lte_rrc_setup_74 = -1;              /* T_setup_65 */
static int hf_lte_rrc_codewordOneConfig_v1530 = -1;  /* T_codewordOneConfig_v1530 */
static int hf_lte_rrc_setup_75 = -1;              /* T_setup_66 */
static int hf_lte_rrc_crs_PortsCount_v1530 = -1;  /* T_crs_PortsCount_v1530 */
static int hf_lte_rrc_crs_FreqShift_v1530 = -1;   /* INTEGER_0_5 */
static int hf_lte_rrc_mbsfn_SubframeConfigList_v1530 = -1;  /* MBSFN_SubframeConfigList */
static int hf_lte_rrc_mbsfn_SubframeConfigListExt_v1530 = -1;  /* MBSFN_SubframeConfigList_v1430 */
static int hf_lte_rrc_pdsch_Start_v1530 = -1;     /* T_pdsch_Start_v1530 */
static int hf_lte_rrc_csi_RS_ConfigZPId_v1530 = -1;  /* CSI_RS_ConfigZPId_r11 */
static int hf_lte_rrc_qcl_CSI_RS_ConfigNZPId_v1530 = -1;  /* CSI_RS_ConfigNZPId_r11 */
static int hf_lte_rrc_PerCC_GapIndicationList_r14_item = -1;  /* PerCC_GapIndication_r14 */
static int hf_lte_rrc_servCellId_r14 = -1;        /* ServCellIndex_r13 */
static int hf_lte_rrc_gapIndication_r14 = -1;     /* T_gapIndication_r14 */
static int hf_lte_rrc_phich_Duration = -1;        /* T_phich_Duration */
static int hf_lte_rrc_phich_Resource = -1;        /* T_phich_Resource */
static int hf_lte_rrc_pdsch_ConfigDedicated = -1;  /* PDSCH_ConfigDedicated */
static int hf_lte_rrc_pucch_ConfigDedicated = -1;  /* PUCCH_ConfigDedicated */
static int hf_lte_rrc_pusch_ConfigDedicated = -1;  /* PUSCH_ConfigDedicated */
static int hf_lte_rrc_uplinkPowerControlDedicated = -1;  /* UplinkPowerControlDedicated */
static int hf_lte_rrc_tpc_PDCCH_ConfigPUCCH = -1;  /* TPC_PDCCH_Config */
static int hf_lte_rrc_tpc_PDCCH_ConfigPUSCH = -1;  /* TPC_PDCCH_Config */
static int hf_lte_rrc_cqi_ReportConfig = -1;      /* CQI_ReportConfig */
static int hf_lte_rrc_soundingRS_UL_ConfigDedicated = -1;  /* SoundingRS_UL_ConfigDedicated */
static int hf_lte_rrc_antennaInfo = -1;           /* T_antennaInfo */
static int hf_lte_rrc_explicitValue_02 = -1;      /* AntennaInfoDedicated */
static int hf_lte_rrc_schedulingRequestConfig = -1;  /* SchedulingRequestConfig */
static int hf_lte_rrc_cqi_ReportConfig_v920 = -1;  /* CQI_ReportConfig_v920 */
static int hf_lte_rrc_antennaInfo_v920 = -1;      /* AntennaInfoDedicated_v920 */
static int hf_lte_rrc_antennaInfo_r10 = -1;       /* T_antennaInfo_r10 */
static int hf_lte_rrc_explicitValue_r10 = -1;     /* AntennaInfoDedicated_r10 */
static int hf_lte_rrc_antennaInfoUL_r10 = -1;     /* AntennaInfoUL_r10 */
static int hf_lte_rrc_pucch_ConfigDedicated_v1020 = -1;  /* PUCCH_ConfigDedicated_v1020 */
static int hf_lte_rrc_pusch_ConfigDedicated_v1020 = -1;  /* PUSCH_ConfigDedicated_v1020 */
static int hf_lte_rrc_schedulingRequestConfig_v1020 = -1;  /* SchedulingRequestConfig_v1020 */
static int hf_lte_rrc_soundingRS_UL_ConfigDedicated_v1020 = -1;  /* SoundingRS_UL_ConfigDedicated_v1020 */
static int hf_lte_rrc_soundingRS_UL_ConfigDedicatedAperiodic_r10 = -1;  /* SoundingRS_UL_ConfigDedicatedAperiodic_r10 */
static int hf_lte_rrc_uplinkPowerControlDedicated_v1020 = -1;  /* UplinkPowerControlDedicated_v1020 */
static int hf_lte_rrc_additionalSpectrumEmissionCA_r10 = -1;  /* T_additionalSpectrumEmissionCA_r10 */
static int hf_lte_rrc_setup_76 = -1;              /* T_setup_67 */
static int hf_lte_rrc_additionalSpectrumEmissionPCell_r10 = -1;  /* AdditionalSpectrumEmission */
static int hf_lte_rrc_csi_RS_ConfigNZPToReleaseList_r11 = -1;  /* CSI_RS_ConfigNZPToReleaseList_r11 */
static int hf_lte_rrc_csi_RS_ConfigNZPToAddModList_r11 = -1;  /* CSI_RS_ConfigNZPToAddModList_r11 */
static int hf_lte_rrc_csi_RS_ConfigZPToReleaseList_r11 = -1;  /* CSI_RS_ConfigZPToReleaseList_r11 */
static int hf_lte_rrc_csi_RS_ConfigZPToAddModList_r11 = -1;  /* CSI_RS_ConfigZPToAddModList_r11 */
static int hf_lte_rrc_epdcch_Config_r11 = -1;     /* EPDCCH_Config_r11 */
static int hf_lte_rrc_pdsch_ConfigDedicated_v1130 = -1;  /* PDSCH_ConfigDedicated_v1130 */
static int hf_lte_rrc_pucch_ConfigDedicated_v1130 = -1;  /* PUCCH_ConfigDedicated_v1130 */
static int hf_lte_rrc_pusch_ConfigDedicated_v1130 = -1;  /* PUSCH_ConfigDedicated_v1130 */
static int hf_lte_rrc_uplinkPowerControlDedicated_v1130 = -1;  /* UplinkPowerControlDedicated_v1130 */
static int hf_lte_rrc_antennaInfo_v1250 = -1;     /* AntennaInfoDedicated_v1250 */
static int hf_lte_rrc_eimta_MainConfig_r12 = -1;  /* EIMTA_MainConfig_r12 */
static int hf_lte_rrc_eimta_MainConfigPCell_r12 = -1;  /* EIMTA_MainConfigServCell_r12 */
static int hf_lte_rrc_pucch_ConfigDedicated_v1250 = -1;  /* PUCCH_ConfigDedicated_v1250 */
static int hf_lte_rrc_uplinkPowerControlDedicated_v1250 = -1;  /* UplinkPowerControlDedicated_v1250 */
static int hf_lte_rrc_pusch_ConfigDedicated_v1250 = -1;  /* PUSCH_ConfigDedicated_v1250 */
static int hf_lte_rrc_pdsch_ConfigDedicated_v1280 = -1;  /* PDSCH_ConfigDedicated_v1280 */
static int hf_lte_rrc_pdsch_ConfigDedicated_v1310 = -1;  /* PDSCH_ConfigDedicated_v1310 */
static int hf_lte_rrc_pucch_ConfigDedicated_r13 = -1;  /* PUCCH_ConfigDedicated_r13 */
static int hf_lte_rrc_pusch_ConfigDedicated_r13 = -1;  /* PUSCH_ConfigDedicated_r13 */
static int hf_lte_rrc_pdcch_CandidateReductions_r13 = -1;  /* PDCCH_CandidateReductions_r13 */
static int hf_lte_rrc_soundingRS_UL_ConfigDedicated_v1310 = -1;  /* SoundingRS_UL_ConfigDedicated_v1310 */
static int hf_lte_rrc_soundingRS_UL_ConfigDedicatedUpPTsExt_r13 = -1;  /* SoundingRS_UL_ConfigDedicatedUpPTsExt_r13 */
static int hf_lte_rrc_soundingRS_UL_ConfigDedicatedAperiodic_v1310 = -1;  /* SoundingRS_UL_ConfigDedicatedAperiodic_v1310 */
static int hf_lte_rrc_soundingRS_UL_ConfigDedicatedAperiodicUpPTsExt_r13 = -1;  /* SoundingRS_UL_ConfigDedicatedAperiodicUpPTsExt_r13 */
static int hf_lte_rrc_ce_Mode_r13 = -1;           /* T_ce_Mode_r13 */
static int hf_lte_rrc_setup_77 = -1;              /* T_setup_68 */
static int hf_lte_rrc_csi_RS_ConfigNZPToAddModListExt_r13 = -1;  /* CSI_RS_ConfigNZPToAddModListExt_r13 */
static int hf_lte_rrc_csi_RS_ConfigNZPToReleaseListExt_r13 = -1;  /* CSI_RS_ConfigNZPToReleaseListExt_r13 */
static int hf_lte_rrc_typeA_SRS_TPC_PDCCH_Group_r14 = -1;  /* T_typeA_SRS_TPC_PDCCH_Group_r14 */
static int hf_lte_rrc_setup_78 = -1;              /* SEQUENCE_SIZE_1_32_OF_SRS_TPC_PDCCH_Config_r14 */
static int hf_lte_rrc_setup_item_02 = -1;         /* SRS_TPC_PDCCH_Config_r14 */
static int hf_lte_rrc_must_Config_r14 = -1;       /* T_must_Config_r14 */
static int hf_lte_rrc_setup_79 = -1;              /* T_setup_69 */
static int hf_lte_rrc_k_max_r14 = -1;             /* T_k_max_r14 */
static int hf_lte_rrc_p_a_must_r14 = -1;          /* T_p_a_must_r14 */
static int hf_lte_rrc_pusch_EnhancementsConfig_r14 = -1;  /* PUSCH_EnhancementsConfig_r14 */
static int hf_lte_rrc_ce_pdsch_pusch_EnhancementConfig_r14 = -1;  /* T_ce_pdsch_pusch_EnhancementConfig_r14 */
static int hf_lte_rrc_antennaInfo_v1430 = -1;     /* AntennaInfoDedicated_v1430 */
static int hf_lte_rrc_pucch_ConfigDedicated_v1430 = -1;  /* PUCCH_ConfigDedicated_v1430 */
static int hf_lte_rrc_pdsch_ConfigDedicated_v1430 = -1;  /* PDSCH_ConfigDedicated_v1430 */
static int hf_lte_rrc_pusch_ConfigDedicated_v1430 = -1;  /* PUSCH_ConfigDedicated_v1430 */
static int hf_lte_rrc_soundingRS_UL_PeriodicConfigDedicatedList_r14 = -1;  /* SEQUENCE_SIZE_1_2_OF_SoundingRS_UL_ConfigDedicated */
static int hf_lte_rrc_soundingRS_UL_PeriodicConfigDedicatedList_r14_item = -1;  /* SoundingRS_UL_ConfigDedicated */
static int hf_lte_rrc_soundingRS_UL_PeriodicConfigDedicatedUpPTsExtList_r14 = -1;  /* SEQUENCE_SIZE_1_4_OF_SoundingRS_UL_ConfigDedicatedUpPTsExt_r13 */
static int hf_lte_rrc_soundingRS_UL_PeriodicConfigDedicatedUpPTsExtList_r14_item = -1;  /* SoundingRS_UL_ConfigDedicatedUpPTsExt_r13 */
static int hf_lte_rrc_soundingRS_UL_AperiodicConfigDedicatedList_r14 = -1;  /* SEQUENCE_SIZE_1_2_OF_SoundingRS_UL_ConfigDedicatedAperiodic_r10 */
static int hf_lte_rrc_soundingRS_UL_AperiodicConfigDedicatedList_r14_item = -1;  /* SoundingRS_UL_ConfigDedicatedAperiodic_r10 */
static int hf_lte_rrc_soundingRS_UL_ConfigDedicatedApUpPTsExtList_r14 = -1;  /* SEQUENCE_SIZE_1_4_OF_SoundingRS_UL_ConfigDedicatedAperiodicUpPTsExt_r13 */
static int hf_lte_rrc_soundingRS_UL_ConfigDedicatedApUpPTsExtList_r14_item = -1;  /* SoundingRS_UL_ConfigDedicatedAperiodicUpPTsExt_r13 */
static int hf_lte_rrc_csi_RS_ConfigZP_ApList_r14 = -1;  /* CSI_RS_ConfigZP_ApList_r14 */
static int hf_lte_rrc_semiOpenLoop_r14 = -1;      /* BOOLEAN */
static int hf_lte_rrc_csi_RS_Config_v1480 = -1;   /* CSI_RS_Config_v1480 */
static int hf_lte_rrc_physicalConfigDedicatedSTTI_r15 = -1;  /* PhysicalConfigDedicatedSTTI_r15 */
static int hf_lte_rrc_pdsch_ConfigDedicated_v1530 = -1;  /* PDSCH_ConfigDedicated_v1530 */
static int hf_lte_rrc_pusch_ConfigDedicated_v1530 = -1;  /* PUSCH_ConfigDedicated_v1530 */
static int hf_lte_rrc_cqi_ReportConfig_v1530 = -1;  /* CQI_ReportConfig_v1530 */
static int hf_lte_rrc_antennaInfo_v1530 = -1;     /* AntennaInfoDedicated_v1530 */
static int hf_lte_rrc_csi_RS_Config_v1530 = -1;   /* CSI_RS_Config_v1530 */
static int hf_lte_rrc_uplinkPowerControlDedicated_v1530 = -1;  /* UplinkPowerControlDedicated_v1530 */
static int hf_lte_rrc_semiStaticCFI_Config_r15 = -1;  /* T_semiStaticCFI_Config_r15 */
static int hf_lte_rrc_setup_80 = -1;              /* T_setup_70 */
static int hf_lte_rrc_cfi_Config_r15 = -1;        /* CFI_Config_r15 */
static int hf_lte_rrc_cfi_PatternConfig_r15 = -1;  /* CFI_PatternConfig_r15 */
static int hf_lte_rrc_blindPDSCH_Repetition_Config_r15 = -1;  /* T_blindPDSCH_Repetition_Config_r15 */
static int hf_lte_rrc_setup_81 = -1;              /* T_setup_71 */
static int hf_lte_rrc_blindSubframePDSCH_Repetitions_r15 = -1;  /* BOOLEAN */
static int hf_lte_rrc_blindSlotSubslotPDSCH_Repetitions_r15 = -1;  /* BOOLEAN */
static int hf_lte_rrc_maxNumber_SubframePDSCH_Repetitions_r15 = -1;  /* T_maxNumber_SubframePDSCH_Repetitions_r15 */
static int hf_lte_rrc_maxNumber_SlotSubslotPDSCH_Repetitions_r15 = -1;  /* T_maxNumber_SlotSubslotPDSCH_Repetitions_r15 */
static int hf_lte_rrc_rv_SubframePDSCH_Repetitions_r15 = -1;  /* T_rv_SubframePDSCH_Repetitions_r15 */
static int hf_lte_rrc_rv_SlotsublotPDSCH_Repetitions_r15 = -1;  /* T_rv_SlotsublotPDSCH_Repetitions_r15 */
static int hf_lte_rrc_numberOfProcesses_SubframePDSCH_Repetitions_r15 = -1;  /* INTEGER_1_16 */
static int hf_lte_rrc_numberOfProcesses_SlotSubslotPDSCH_Repetitions_r15 = -1;  /* INTEGER_1_16 */
static int hf_lte_rrc_mcs_restrictionSubframePDSCH_Repetitions_r15 = -1;  /* T_mcs_restrictionSubframePDSCH_Repetitions_r15 */
static int hf_lte_rrc_mcs_restrictionSlotSubslotPDSCH_Repetitions_r15 = -1;  /* T_mcs_restrictionSlotSubslotPDSCH_Repetitions_r15 */
static int hf_lte_rrc_spucch_Config_v1550 = -1;   /* SPUCCH_Config_v1550 */
static int hf_lte_rrc_pucch_ConfigDedicated_v1370 = -1;  /* PUCCH_ConfigDedicated_v1370 */
static int hf_lte_rrc_pucch_ConfigDedicated_v13c0 = -1;  /* PUCCH_ConfigDedicated_v13c0 */
static int hf_lte_rrc_nonUL_Configuration_r10 = -1;  /* T_nonUL_Configuration_r10 */
static int hf_lte_rrc_antennaInfo_r10_01 = -1;    /* AntennaInfoDedicated_r10 */
static int hf_lte_rrc_crossCarrierSchedulingConfig_r10 = -1;  /* CrossCarrierSchedulingConfig_r10 */
static int hf_lte_rrc_pdsch_ConfigDedicated_r10 = -1;  /* PDSCH_ConfigDedicated */
static int hf_lte_rrc_ul_Configuration_r10 = -1;  /* T_ul_Configuration_r10 */
static int hf_lte_rrc_pusch_ConfigDedicatedSCell_r10 = -1;  /* PUSCH_ConfigDedicatedSCell_r10 */
static int hf_lte_rrc_uplinkPowerControlDedicatedSCell_r10 = -1;  /* UplinkPowerControlDedicatedSCell_r10 */
static int hf_lte_rrc_cqi_ReportConfigSCell_r10 = -1;  /* CQI_ReportConfigSCell_r10 */
static int hf_lte_rrc_soundingRS_UL_ConfigDedicated_r10 = -1;  /* SoundingRS_UL_ConfigDedicated */
static int hf_lte_rrc_uplinkPowerControlDedicatedSCell_v1130 = -1;  /* UplinkPowerControlDedicated_v1130 */
static int hf_lte_rrc_eimta_MainConfigSCell_r12 = -1;  /* EIMTA_MainConfigServCell_r12 */
static int hf_lte_rrc_cqi_ReportConfigSCell_v1250 = -1;  /* CQI_ReportConfig_v1250 */
static int hf_lte_rrc_uplinkPowerControlDedicatedSCell_v1250 = -1;  /* UplinkPowerControlDedicated_v1250 */
static int hf_lte_rrc_pucch_Cell_r13 = -1;        /* T_pucch_Cell_r13 */
static int hf_lte_rrc_pucch_SCell = -1;           /* T_pucch_SCell */
static int hf_lte_rrc_setup_82 = -1;              /* T_setup_72 */
static int hf_lte_rrc_schedulingRequestConfig_r13 = -1;  /* SchedulingRequestConfigSCell_r13 */
static int hf_lte_rrc_tpc_PDCCH_ConfigPUCCH_SCell_r13 = -1;  /* TPC_PDCCH_ConfigSCell_r13 */
static int hf_lte_rrc_uplinkPowerControlDedicated_r13 = -1;  /* UplinkPowerControlDedicatedSCell_v1310 */
static int hf_lte_rrc_crossCarrierSchedulingConfig_r13 = -1;  /* CrossCarrierSchedulingConfig_r13 */
static int hf_lte_rrc_pdcch_ConfigSCell_r13 = -1;  /* PDCCH_ConfigSCell_r13 */
static int hf_lte_rrc_laa_SCellConfiguration_r13 = -1;  /* LAA_SCellConfiguration_r13 */
static int hf_lte_rrc_laa_SCellConfiguration_v1430 = -1;  /* LAA_SCellConfiguration_v1430 */
static int hf_lte_rrc_typeB_SRS_TPC_PDCCH_Config_r14 = -1;  /* SRS_TPC_PDCCH_Config_r14 */
static int hf_lte_rrc_uplinkPUSCH_LessPowerControlDedicated_v1430 = -1;  /* UplinkPUSCH_LessPowerControlDedicated_v1430 */
static int hf_lte_rrc_soundingRS_UL_AperiodicConfigDedicatedList_r14_01 = -1;  /* SEQUENCE_SIZE_1_2_OF_SoundingRS_AperiodicSet_r14 */
static int hf_lte_rrc_soundingRS_UL_AperiodicConfigDedicatedList_r14_item_01 = -1;  /* SoundingRS_AperiodicSet_r14 */
static int hf_lte_rrc_soundingRS_UL_ConfigDedicatedApUpPTsExtList_r14_01 = -1;  /* SEQUENCE_SIZE_1_4_OF_SoundingRS_AperiodicSetUpPTsExt_r14 */
static int hf_lte_rrc_soundingRS_UL_ConfigDedicatedApUpPTsExtList_r14_item_01 = -1;  /* SoundingRS_AperiodicSetUpPTsExt_r14 */
static int hf_lte_rrc_must_Config_r14_01 = -1;    /* T_must_Config_r14_01 */
static int hf_lte_rrc_setup_83 = -1;              /* T_setup_73 */
static int hf_lte_rrc_k_max_r14_01 = -1;          /* T_k_max_r14_01 */
static int hf_lte_rrc_p_a_must_r14_01 = -1;       /* T_p_a_must_r14_01 */
static int hf_lte_rrc_pusch_ConfigDedicated_v1430_01 = -1;  /* PUSCH_ConfigDedicatedSCell_v1430 */
static int hf_lte_rrc_pdsch_ConfigDedicatedSCell_v1430 = -1;  /* PDSCH_ConfigDedicatedSCell_v1430 */
static int hf_lte_rrc_dummy_04 = -1;              /* CQI_ReportConfig_v1530 */
static int hf_lte_rrc_cqi_ReportConfigSCell_r15 = -1;  /* CQI_ReportConfigSCell_r15 */
static int hf_lte_rrc_cqi_ShortConfigSCell_r15 = -1;  /* CQI_ShortConfigSCell_r15 */
static int hf_lte_rrc_uplinkPowerControlDedicatedSCell_v1530 = -1;  /* UplinkPowerControlDedicated_v1530 */
static int hf_lte_rrc_laa_SCellConfiguration_v1530 = -1;  /* LAA_SCellConfiguration_v1530 */
static int hf_lte_rrc_pusch_ConfigDedicated_v1530_01 = -1;  /* PUSCH_ConfigDedicatedScell_v1530 */
static int hf_lte_rrc_semiStaticCFI_Config_r15_01 = -1;  /* T_semiStaticCFI_Config_r15_01 */
static int hf_lte_rrc_setup_84 = -1;              /* T_setup_74 */
static int hf_lte_rrc_blindPDSCH_Repetition_Config_r15_01 = -1;  /* T_blindPDSCH_Repetition_Config_r15_01 */
static int hf_lte_rrc_setup_85 = -1;              /* T_setup_75 */
static int hf_lte_rrc_maxNumber_SubframePDSCH_Repetitions_r15_01 = -1;  /* T_maxNumber_SubframePDSCH_Repetitions_r15_01 */
static int hf_lte_rrc_maxNumber_SlotSubslotPDSCH_Repetitions_r15_01 = -1;  /* T_maxNumber_SlotSubslotPDSCH_Repetitions_r15_01 */
static int hf_lte_rrc_rv_SubframePDSCH_Repetitions_r15_01 = -1;  /* T_rv_SubframePDSCH_Repetitions_r15_01 */
static int hf_lte_rrc_rv_SlotsublotPDSCH_Repetitions_r15_01 = -1;  /* T_rv_SlotsublotPDSCH_Repetitions_r15_01 */
static int hf_lte_rrc_mcs_restrictionSubframePDSCH_Repetitions_r15_01 = -1;  /* T_mcs_restrictionSubframePDSCH_Repetitions_r15_01 */
static int hf_lte_rrc_mcs_restrictionSlotSubslotPDSCH_Repetitions_r15_01 = -1;  /* T_mcs_restrictionSlotSubslotPDSCH_Repetitions_r15_01 */
static int hf_lte_rrc_pucch_SCell_v1370 = -1;     /* T_pucch_SCell_v1370 */
static int hf_lte_rrc_setup_86 = -1;              /* T_setup_76 */
static int hf_lte_rrc_pucch_SCell_v13c0 = -1;     /* T_pucch_SCell_v13c0 */
static int hf_lte_rrc_setup_87 = -1;              /* T_setup_77 */
static int hf_lte_rrc_cfi_SubframeNonMBSFN_r15 = -1;  /* INTEGER_1_4 */
static int hf_lte_rrc_cfi_SlotSubslotNonMBSFN_r15 = -1;  /* INTEGER_1_3 */
static int hf_lte_rrc_cfi_SubframeMBSFN_r15 = -1;  /* INTEGER_1_2 */
static int hf_lte_rrc_cfi_SlotSubslotMBSFN_r15 = -1;  /* INTEGER_1_2 */
static int hf_lte_rrc_cfi_PatternSubframe_r15 = -1;  /* T_cfi_PatternSubframe_r15 */
static int hf_lte_rrc_cfi_PatternSubframe_r15_item = -1;  /* INTEGER_1_4 */
static int hf_lte_rrc_cfi_PatternSlotSubslot_r15 = -1;  /* T_cfi_PatternSlotSubslot_r15 */
static int hf_lte_rrc_cfi_PatternSlotSubslot_r15_item = -1;  /* INTEGER_1_3 */
static int hf_lte_rrc_subframeStartPosition_r13 = -1;  /* T_subframeStartPosition_r13 */
static int hf_lte_rrc_laa_SCellSubframeConfig_r13 = -1;  /* BIT_STRING_SIZE_8 */
static int hf_lte_rrc_crossCarrierSchedulingConfig_UL_r14 = -1;  /* T_crossCarrierSchedulingConfig_UL_r14 */
static int hf_lte_rrc_setup_88 = -1;              /* T_setup_78 */
static int hf_lte_rrc_crossCarrierSchedulingConfigLAA_UL_r14 = -1;  /* CrossCarrierSchedulingConfigLAA_UL_r14 */
static int hf_lte_rrc_lbt_Config_r14 = -1;        /* LBT_Config_r14 */
static int hf_lte_rrc_pdcch_ConfigLAA_r14 = -1;   /* PDCCH_ConfigLAA_r14 */
static int hf_lte_rrc_absenceOfAnyOtherTechnology_r14 = -1;  /* T_absenceOfAnyOtherTechnology_r14 */
static int hf_lte_rrc_soundingRS_UL_ConfigDedicatedAperiodic_v1430 = -1;  /* SoundingRS_UL_ConfigDedicatedAperiodic_v1430 */
static int hf_lte_rrc_aul_Config_r15 = -1;        /* AUL_Config_r15 */
static int hf_lte_rrc_pusch_ModeConfigLAA_r15 = -1;  /* PUSCH_ModeConfigLAA_r15 */
static int hf_lte_rrc_laa_PUSCH_Mode1 = -1;       /* BOOLEAN */
static int hf_lte_rrc_laa_PUSCH_Mode2 = -1;       /* BOOLEAN */
static int hf_lte_rrc_laa_PUSCH_Mode3 = -1;       /* BOOLEAN */
static int hf_lte_rrc_maxEnergyDetectionThreshold_r14 = -1;  /* INTEGER_M85_M52 */
static int hf_lte_rrc_energyDetectionThresholdOffset_r14 = -1;  /* INTEGER_M13_20 */
static int hf_lte_rrc_CSI_RS_ConfigNZPToAddModList_r11_item = -1;  /* CSI_RS_ConfigNZP_r11 */
static int hf_lte_rrc_CSI_RS_ConfigNZPToAddModListExt_r13_item = -1;  /* CSI_RS_ConfigNZP_r11 */
static int hf_lte_rrc_CSI_RS_ConfigNZPToAddModList_r15_item = -1;  /* CSI_RS_ConfigNZP_r11 */
static int hf_lte_rrc_CSI_RS_ConfigNZPToReleaseList_r11_item = -1;  /* CSI_RS_ConfigNZPId_r11 */
static int hf_lte_rrc_CSI_RS_ConfigNZPToReleaseListExt_r13_item = -1;  /* CSI_RS_ConfigNZPId_v1310 */
static int hf_lte_rrc_CSI_RS_ConfigNZPToReleaseList_r15_item = -1;  /* CSI_RS_ConfigNZPId_r13 */
static int hf_lte_rrc_CSI_RS_ConfigZPToAddModList_r11_item = -1;  /* CSI_RS_ConfigZP_r11 */
static int hf_lte_rrc_CSI_RS_ConfigZPToReleaseList_r11_item = -1;  /* CSI_RS_ConfigZPId_r11 */
static int hf_lte_rrc_setup_89 = -1;              /* T_setup_79 */
static int hf_lte_rrc_antennaInfoDedicatedSTTI_r15 = -1;  /* AntennaInfoDedicatedSTTI_r15 */
static int hf_lte_rrc_antennaInfoUL_STTI_r15 = -1;  /* AntennaInfoUL_STTI_r15 */
static int hf_lte_rrc_pucch_ConfigDedicated_v1530 = -1;  /* PUCCH_ConfigDedicated_v1530 */
static int hf_lte_rrc_schedulingRequestConfig_v1530 = -1;  /* SchedulingRequestConfig_v1530 */
static int hf_lte_rrc_uplinkPowerControlDedicatedSTTI_r15 = -1;  /* UplinkPowerControlDedicatedSTTI_r15 */
static int hf_lte_rrc_cqi_ReportConfig_r15 = -1;  /* CQI_ReportConfig_r15 */
static int hf_lte_rrc_csi_RS_Config_r15 = -1;     /* CSI_RS_Config_r15 */
static int hf_lte_rrc_csi_RS_ConfigNZPToReleaseList_r15 = -1;  /* CSI_RS_ConfigNZPToReleaseList_r15 */
static int hf_lte_rrc_csi_RS_ConfigNZPToAddModList_r15 = -1;  /* CSI_RS_ConfigNZPToAddModList_r15 */
static int hf_lte_rrc_csi_RS_ConfigZPToReleaseList_r15 = -1;  /* CSI_RS_ConfigZPToReleaseList_r11 */
static int hf_lte_rrc_csi_RS_ConfigZP_ApList_r15 = -1;  /* CSI_RS_ConfigZP_ApList_r14 */
static int hf_lte_rrc_eimta_MainConfigServCell_r15 = -1;  /* EIMTA_MainConfigServCell_r12 */
static int hf_lte_rrc_semiOpenLoopSTTI_r15 = -1;  /* BOOLEAN */
static int hf_lte_rrc_slotOrSubslotPDSCH_Config_r15 = -1;  /* SlotOrSubslotPDSCH_Config_r15 */
static int hf_lte_rrc_slotOrSubslotPUSCH_Config_r15 = -1;  /* SlotOrSubslotPUSCH_Config_r15 */
static int hf_lte_rrc_spdcch_Config_r15 = -1;     /* SPDCCH_Config_r15 */
static int hf_lte_rrc_spucch_Config_r15 = -1;     /* SPUCCH_Config_r15 */
static int hf_lte_rrc_srs_DCI7_TriggeringConfig_r15 = -1;  /* BOOLEAN */
static int hf_lte_rrc_shortProcessingTime_r15 = -1;  /* BOOLEAN */
static int hf_lte_rrc_shortTTI_r15_01 = -1;       /* ShortTTI_r15 */
static int hf_lte_rrc_srs_CC_SetIndexList_r14 = -1;  /* SEQUENCE_SIZE_1_4_OF_SRS_CC_SetIndex_r14 */
static int hf_lte_rrc_srs_CC_SetIndexList_r14_item = -1;  /* SRS_CC_SetIndex_r14 */
static int hf_lte_rrc_soundingRS_UL_ConfigDedicatedAperiodic_r14 = -1;  /* SoundingRS_UL_ConfigDedicatedAperiodic_r10 */
static int hf_lte_rrc_soundingRS_UL_ConfigDedicatedAperiodicUpPTsExt_r14 = -1;  /* SoundingRS_UL_ConfigDedicatedAperiodicUpPTsExt_r13 */
static int hf_lte_rrc_dl_STTI_Length_r15 = -1;    /* ShortTTI_Length_r15 */
static int hf_lte_rrc_ul_STTI_Length_r15 = -1;    /* ShortTTI_Length_r15 */
static int hf_lte_rrc_rootSequenceIndex = -1;     /* INTEGER_0_837 */
static int hf_lte_rrc_prach_ConfigInfo = -1;      /* PRACH_ConfigInfo */
static int hf_lte_rrc_rsrp_ThresholdsPrachInfoList_r13 = -1;  /* RSRP_ThresholdsPrachInfoList_r13 */
static int hf_lte_rrc_mpdcch_startSF_CSS_RA_r13 = -1;  /* T_mpdcch_startSF_CSS_RA_r13 */
static int hf_lte_rrc_fdd_r13_01 = -1;            /* T_fdd_r13_01 */
static int hf_lte_rrc_tdd_r13_01 = -1;            /* T_tdd_r13_01 */
static int hf_lte_rrc_prach_HoppingOffset_r13 = -1;  /* INTEGER_0_94 */
static int hf_lte_rrc_prach_ParametersListCE_r13 = -1;  /* PRACH_ParametersListCE_r13 */
static int hf_lte_rrc_edt_PRACH_ParametersListCE_r15 = -1;  /* SEQUENCE_SIZE_1_maxCE_Level_r13_OF_EDT_PRACH_ParametersCE_r15 */
static int hf_lte_rrc_edt_PRACH_ParametersListCE_r15_item = -1;  /* EDT_PRACH_ParametersCE_r15 */
static int hf_lte_rrc_mpdcch_startSF_CSS_RA_r13_01 = -1;  /* T_mpdcch_startSF_CSS_RA_r13_01 */
static int hf_lte_rrc_fdd_r13_02 = -1;            /* T_fdd_r13_02 */
static int hf_lte_rrc_tdd_r13_02 = -1;            /* T_tdd_r13_02 */
static int hf_lte_rrc_initial_CE_level_r13 = -1;  /* INTEGER_0_3 */
static int hf_lte_rrc_rootSequenceIndexHighSpeed_r14 = -1;  /* INTEGER_0_837 */
static int hf_lte_rrc_zeroCorrelationZoneConfigHighSpeed_r14 = -1;  /* INTEGER_0_12 */
static int hf_lte_rrc_prach_ConfigIndexHighSpeed_r14 = -1;  /* INTEGER_0_63 */
static int hf_lte_rrc_prach_FreqOffsetHighSpeed_r14 = -1;  /* INTEGER_0_94 */
static int hf_lte_rrc_prach_ConfigIndex_r10 = -1;  /* INTEGER_0_63 */
static int hf_lte_rrc_prach_ConfigIndex = -1;     /* INTEGER_0_63 */
static int hf_lte_rrc_highSpeedFlag = -1;         /* BOOLEAN */
static int hf_lte_rrc_zeroCorrelationZoneConfig = -1;  /* INTEGER_0_15 */
static int hf_lte_rrc_prach_FreqOffset = -1;      /* INTEGER_0_94 */
static int hf_lte_rrc_PRACH_ParametersListCE_r13_item = -1;  /* PRACH_ParametersCE_r13 */
static int hf_lte_rrc_prach_ConfigIndex_r13 = -1;  /* INTEGER_0_63 */
static int hf_lte_rrc_prach_FreqOffset_r13 = -1;  /* INTEGER_0_94 */
static int hf_lte_rrc_prach_StartingSubframe_r13 = -1;  /* T_prach_StartingSubframe_r13 */
static int hf_lte_rrc_maxNumPreambleAttemptCE_r13 = -1;  /* T_maxNumPreambleAttemptCE_r13 */
static int hf_lte_rrc_numRepetitionPerPreambleAttempt_r13 = -1;  /* T_numRepetitionPerPreambleAttempt_r13 */
static int hf_lte_rrc_mpdcch_NarrowbandsToMonitor_r13 = -1;  /* T_mpdcch_NarrowbandsToMonitor_r13 */
static int hf_lte_rrc_mpdcch_NarrowbandsToMonitor_r13_item = -1;  /* INTEGER_1_maxAvailNarrowBands_r13 */
static int hf_lte_rrc_mpdcch_NumRepetition_RA_r13 = -1;  /* T_mpdcch_NumRepetition_RA_r13 */
static int hf_lte_rrc_prach_HoppingConfig_r13 = -1;  /* T_prach_HoppingConfig_r13 */
static int hf_lte_rrc_edt_PRACH_ParametersCE_r15 = -1;  /* T_edt_PRACH_ParametersCE_r15 */
static int hf_lte_rrc_prach_ConfigIndex_r15 = -1;  /* INTEGER_0_63 */
static int hf_lte_rrc_prach_FreqOffset_r15 = -1;  /* INTEGER_0_94 */
static int hf_lte_rrc_prach_StartingSubframe_r15 = -1;  /* T_prach_StartingSubframe_r15 */
static int hf_lte_rrc_mpdcch_NarrowbandsToMonitor_r15 = -1;  /* T_mpdcch_NarrowbandsToMonitor_r15 */
static int hf_lte_rrc_mpdcch_NarrowbandsToMonitor_r15_item = -1;  /* INTEGER_1_maxAvailNarrowBands_r13 */
static int hf_lte_rrc_RSRP_ThresholdsPrachInfoList_r13_item = -1;  /* RSRP_Range */
static int hf_lte_rrc_deltaPUCCH_Shift = -1;      /* T_deltaPUCCH_Shift */
static int hf_lte_rrc_nRB_CQI = -1;               /* INTEGER_0_98 */
static int hf_lte_rrc_nCS_AN = -1;                /* INTEGER_0_7 */
static int hf_lte_rrc_n1PUCCH_AN = -1;            /* INTEGER_0_2047 */
static int hf_lte_rrc_n1PUCCH_AN_InfoList_r13 = -1;  /* N1PUCCH_AN_InfoList_r13 */
static int hf_lte_rrc_pucch_NumRepetitionCE_Msg4_Level0_r13 = -1;  /* T_pucch_NumRepetitionCE_Msg4_Level0_r13 */
static int hf_lte_rrc_pucch_NumRepetitionCE_Msg4_Level1_r13 = -1;  /* T_pucch_NumRepetitionCE_Msg4_Level1_r13 */
static int hf_lte_rrc_pucch_NumRepetitionCE_Msg4_Level2_r13 = -1;  /* T_pucch_NumRepetitionCE_Msg4_Level2_r13 */
static int hf_lte_rrc_pucch_NumRepetitionCE_Msg4_Level3_r13 = -1;  /* T_pucch_NumRepetitionCE_Msg4_Level3_r13 */
static int hf_lte_rrc_pucch_NumRepetitionCE_Msg4_Level3_r14 = -1;  /* T_pucch_NumRepetitionCE_Msg4_Level3_r14 */
static int hf_lte_rrc_ackNackRepetition = -1;     /* T_ackNackRepetition */
static int hf_lte_rrc_setup_90 = -1;              /* T_setup_80 */
static int hf_lte_rrc_repetitionFactor = -1;      /* T_repetitionFactor */
static int hf_lte_rrc_n1PUCCH_AN_Rep = -1;        /* INTEGER_0_2047 */
static int hf_lte_rrc_tdd_AckNackFeedbackMode = -1;  /* T_tdd_AckNackFeedbackMode */
static int hf_lte_rrc_pucch_Format_r10 = -1;      /* T_pucch_Format_r10 */
static int hf_lte_rrc_format3_r10 = -1;           /* PUCCH_Format3_Conf_r13 */
static int hf_lte_rrc_channelSelection_r10 = -1;  /* T_channelSelection_r10 */
static int hf_lte_rrc_n1PUCCH_AN_CS_r10 = -1;     /* T_n1PUCCH_AN_CS_r10 */
static int hf_lte_rrc_setup_91 = -1;              /* T_setup_81 */
static int hf_lte_rrc_n1PUCCH_AN_CS_List_r10 = -1;  /* SEQUENCE_SIZE_1_2_OF_N1PUCCH_AN_CS_r10 */
static int hf_lte_rrc_n1PUCCH_AN_CS_List_r10_item = -1;  /* N1PUCCH_AN_CS_r10 */
static int hf_lte_rrc_twoAntennaPortActivatedPUCCH_Format1a1b_r10 = -1;  /* T_twoAntennaPortActivatedPUCCH_Format1a1b_r10 */
static int hf_lte_rrc_simultaneousPUCCH_PUSCH_r10 = -1;  /* T_simultaneousPUCCH_PUSCH_r10 */
static int hf_lte_rrc_n1PUCCH_AN_RepP1_r10 = -1;  /* INTEGER_0_2047 */
static int hf_lte_rrc_n1PUCCH_AN_CS_v1130 = -1;   /* T_n1PUCCH_AN_CS_v1130 */
static int hf_lte_rrc_setup_92 = -1;              /* T_setup_82 */
static int hf_lte_rrc_n1PUCCH_AN_CS_ListP1_r11 = -1;  /* T_n1PUCCH_AN_CS_ListP1_r11 */
static int hf_lte_rrc_n1PUCCH_AN_CS_ListP1_r11_item = -1;  /* INTEGER_0_2047 */
static int hf_lte_rrc_nPUCCH_Param_r11 = -1;      /* T_nPUCCH_Param_r11 */
static int hf_lte_rrc_setup_93 = -1;              /* T_setup_83 */
static int hf_lte_rrc_nPUCCH_Identity_r11 = -1;   /* INTEGER_0_503 */
static int hf_lte_rrc_n1PUCCH_AN_r11 = -1;        /* INTEGER_0_2047 */
static int hf_lte_rrc_nkaPUCCH_Param_r12 = -1;    /* T_nkaPUCCH_Param_r12 */
static int hf_lte_rrc_setup_94 = -1;              /* T_setup_84 */
static int hf_lte_rrc_nkaPUCCH_AN_r12 = -1;       /* INTEGER_0_2047 */
static int hf_lte_rrc_ackNackRepetition_r13 = -1;  /* T_ackNackRepetition_r13 */
static int hf_lte_rrc_setup_95 = -1;              /* T_setup_85 */
static int hf_lte_rrc_repetitionFactor_r13 = -1;  /* T_repetitionFactor_r13 */
static int hf_lte_rrc_n1PUCCH_AN_Rep_r13 = -1;    /* INTEGER_0_2047 */
static int hf_lte_rrc_tdd_AckNackFeedbackMode_r13 = -1;  /* T_tdd_AckNackFeedbackMode_r13 */
static int hf_lte_rrc_pucch_Format_r13 = -1;      /* T_pucch_Format_r13 */
static int hf_lte_rrc_format3_r13 = -1;           /* T_format3_r13 */
static int hf_lte_rrc_n3PUCCH_AN_List_r13 = -1;   /* T_n3PUCCH_AN_List_r13 */
static int hf_lte_rrc_n3PUCCH_AN_List_r13_item = -1;  /* INTEGER_0_549 */
static int hf_lte_rrc_twoAntennaPortActivatedPUCCH_Format3_r13 = -1;  /* T_twoAntennaPortActivatedPUCCH_Format3_r13 */
static int hf_lte_rrc_setup_96 = -1;              /* T_setup_86 */
static int hf_lte_rrc_n3PUCCH_AN_ListP1_r13 = -1;  /* T_n3PUCCH_AN_ListP1_r13 */
static int hf_lte_rrc_n3PUCCH_AN_ListP1_r13_item = -1;  /* INTEGER_0_549 */
static int hf_lte_rrc_channelSelection_r13 = -1;  /* T_channelSelection_r13 */
static int hf_lte_rrc_n1PUCCH_AN_CS_r13 = -1;     /* T_n1PUCCH_AN_CS_r13 */
static int hf_lte_rrc_setup_97 = -1;              /* T_setup_87 */
static int hf_lte_rrc_n1PUCCH_AN_CS_List_r13 = -1;  /* N1PUCCH_AN_CS_List_r13 */
static int hf_lte_rrc_n1PUCCH_AN_CS_List_r13_item = -1;  /* N1PUCCH_AN_CS_r10 */
static int hf_lte_rrc_dummy1 = -1;                /* T_dummy1 */
static int hf_lte_rrc_dummy1_item = -1;           /* INTEGER_0_2047 */
static int hf_lte_rrc_format4_r13 = -1;           /* T_format4_r13 */
static int hf_lte_rrc_format4_resourceConfiguration_r13 = -1;  /* SEQUENCE_SIZE_4_OF_Format4_resource_r13 */
static int hf_lte_rrc_format4_resourceConfiguration_r13_item = -1;  /* Format4_resource_r13 */
static int hf_lte_rrc_format4_MultiCSI_resourceConfiguration_r13 = -1;  /* SEQUENCE_SIZE_1_2_OF_Format4_resource_r13 */
static int hf_lte_rrc_format4_MultiCSI_resourceConfiguration_r13_item = -1;  /* Format4_resource_r13 */
static int hf_lte_rrc_format5_r13 = -1;           /* T_format5_r13 */
static int hf_lte_rrc_format5_resourceConfiguration_r13 = -1;  /* SEQUENCE_SIZE_4_OF_Format5_resource_r13 */
static int hf_lte_rrc_format5_resourceConfiguration_r13_item = -1;  /* Format5_resource_r13 */
static int hf_lte_rrc_format5_MultiCSI_resourceConfiguration_r13 = -1;  /* Format5_resource_r13 */
static int hf_lte_rrc_twoAntennaPortActivatedPUCCH_Format1a1b_r13 = -1;  /* T_twoAntennaPortActivatedPUCCH_Format1a1b_r13 */
static int hf_lte_rrc_simultaneousPUCCH_PUSCH_r13 = -1;  /* T_simultaneousPUCCH_PUSCH_r13 */
static int hf_lte_rrc_n1PUCCH_AN_RepP1_r13 = -1;  /* INTEGER_0_2047 */
static int hf_lte_rrc_nPUCCH_Param_r13 = -1;      /* T_nPUCCH_Param_r13 */
static int hf_lte_rrc_setup_98 = -1;              /* T_setup_88 */
static int hf_lte_rrc_nPUCCH_Identity_r13 = -1;   /* INTEGER_0_503 */
static int hf_lte_rrc_n1PUCCH_AN_r13 = -1;        /* INTEGER_0_2047 */
static int hf_lte_rrc_nkaPUCCH_Param_r13 = -1;    /* T_nkaPUCCH_Param_r13 */
static int hf_lte_rrc_setup_99 = -1;              /* T_setup_89 */
static int hf_lte_rrc_nkaPUCCH_AN_r13 = -1;       /* INTEGER_0_2047 */
static int hf_lte_rrc_spatialBundlingPUCCH_r13 = -1;  /* BOOLEAN */
static int hf_lte_rrc_spatialBundlingPUSCH_r13 = -1;  /* BOOLEAN */
static int hf_lte_rrc_harq_TimingTDD_r13 = -1;    /* BOOLEAN */
static int hf_lte_rrc_codebooksizeDetermination_r13 = -1;  /* T_codebooksizeDetermination_r13 */
static int hf_lte_rrc_maximumPayloadCoderate_r13 = -1;  /* INTEGER_0_7 */
static int hf_lte_rrc_pucch_NumRepetitionCE_r13 = -1;  /* T_pucch_NumRepetitionCE_r13 */
static int hf_lte_rrc_setup_100 = -1;             /* T_setup_90 */
static int hf_lte_rrc_modeA = -1;                 /* T_modeA */
static int hf_lte_rrc_pucch_NumRepetitionCE_format1_r13 = -1;  /* T_pucch_NumRepetitionCE_format1_r13 */
static int hf_lte_rrc_pucch_NumRepetitionCE_format2_r13 = -1;  /* T_pucch_NumRepetitionCE_format2_r13 */
static int hf_lte_rrc_modeB = -1;                 /* T_modeB */
static int hf_lte_rrc_pucch_NumRepetitionCE_format1_r13_01 = -1;  /* T_pucch_NumRepetitionCE_format1_r13_01 */
static int hf_lte_rrc_pucch_NumRepetitionCE_format2_r13_01 = -1;  /* T_pucch_NumRepetitionCE_format2_r13_01 */
static int hf_lte_rrc_pucch_Format_v1370 = -1;    /* T_pucch_Format_v1370 */
static int hf_lte_rrc_setup_101 = -1;             /* PUCCH_Format3_Conf_r13 */
static int hf_lte_rrc_channelSelection_v13c0 = -1;  /* T_channelSelection_v13c0 */
static int hf_lte_rrc_n1PUCCH_AN_CS_v13c0 = -1;   /* T_n1PUCCH_AN_CS_v13c0 */
static int hf_lte_rrc_setup_102 = -1;             /* T_setup_91 */
static int hf_lte_rrc_n1PUCCH_AN_CS_ListP1_v13c0 = -1;  /* T_n1PUCCH_AN_CS_ListP1_v13c0 */
static int hf_lte_rrc_n1PUCCH_AN_CS_ListP1_v13c0_item = -1;  /* INTEGER_0_2047 */
static int hf_lte_rrc_n3PUCCH_AN_List_r13_01 = -1;  /* T_n3PUCCH_AN_List_r13_01 */
static int hf_lte_rrc_twoAntennaPortActivatedPUCCH_Format3_r13_01 = -1;  /* T_twoAntennaPortActivatedPUCCH_Format3_r13_01 */
static int hf_lte_rrc_setup_103 = -1;             /* T_setup_92 */
static int hf_lte_rrc_n3PUCCH_AN_ListP1_r13_01 = -1;  /* T_n3PUCCH_AN_ListP1_r13_01 */
static int hf_lte_rrc_pucch_NumRepetitionCE_format1_r14 = -1;  /* T_pucch_NumRepetitionCE_format1_r14 */
static int hf_lte_rrc_n1PUCCH_AN_SPT_r15 = -1;    /* INTEGER_0_2047 */
static int hf_lte_rrc_codebooksizeDeterminationSTTI_r15 = -1;  /* T_codebooksizeDeterminationSTTI_r15 */
static int hf_lte_rrc_startingPRB_format4_r13 = -1;  /* INTEGER_0_109 */
static int hf_lte_rrc_numberOfPRB_format4_r13 = -1;  /* INTEGER_0_7 */
static int hf_lte_rrc_startingPRB_format5_r13 = -1;  /* INTEGER_0_109 */
static int hf_lte_rrc_cdm_index_format5_r13 = -1;  /* INTEGER_0_1 */
static int hf_lte_rrc_N1PUCCH_AN_CS_r10_item = -1;  /* INTEGER_0_2047 */
static int hf_lte_rrc_N1PUCCH_AN_InfoList_r13_item = -1;  /* INTEGER_0_2047 */
static int hf_lte_rrc_pusch_ConfigBasic = -1;     /* T_pusch_ConfigBasic */
static int hf_lte_rrc_n_SB = -1;                  /* INTEGER_1_4 */
static int hf_lte_rrc_hoppingMode = -1;           /* T_hoppingMode */
static int hf_lte_rrc_pusch_HoppingOffset = -1;   /* INTEGER_0_98 */
static int hf_lte_rrc_enable64QAM = -1;           /* BOOLEAN */
static int hf_lte_rrc_ul_ReferenceSignalsPUSCH = -1;  /* UL_ReferenceSignalsPUSCH */
static int hf_lte_rrc_enable64QAM_v1270 = -1;     /* T_enable64QAM_v1270 */
static int hf_lte_rrc_pusch_maxNumRepetitionCEmodeA_r13 = -1;  /* T_pusch_maxNumRepetitionCEmodeA_r13 */
static int hf_lte_rrc_pusch_maxNumRepetitionCEmodeB_r13 = -1;  /* T_pusch_maxNumRepetitionCEmodeB_r13 */
static int hf_lte_rrc_pusch_HoppingOffset_v1310 = -1;  /* INTEGER_1_maxAvailNarrowBands_r13 */
static int hf_lte_rrc_betaOffset_ACK_Index = -1;  /* INTEGER_0_15 */
static int hf_lte_rrc_betaOffset_RI_Index = -1;   /* INTEGER_0_15 */
static int hf_lte_rrc_betaOffset_CQI_Index = -1;  /* INTEGER_0_15 */
static int hf_lte_rrc_betaOffsetMC_r10 = -1;      /* T_betaOffsetMC_r10 */
static int hf_lte_rrc_betaOffset_ACK_Index_MC_r10 = -1;  /* INTEGER_0_15 */
static int hf_lte_rrc_betaOffset_RI_Index_MC_r10 = -1;  /* INTEGER_0_15 */
static int hf_lte_rrc_betaOffset_CQI_Index_MC_r10 = -1;  /* INTEGER_0_15 */
static int hf_lte_rrc_groupHoppingDisabled_r10 = -1;  /* T_groupHoppingDisabled_r10 */
static int hf_lte_rrc_dmrs_WithOCC_Activated_r10 = -1;  /* T_dmrs_WithOCC_Activated_r10 */
static int hf_lte_rrc_pusch_DMRS_r11 = -1;        /* T_pusch_DMRS_r11 */
static int hf_lte_rrc_setup_104 = -1;             /* T_setup_93 */
static int hf_lte_rrc_nPUSCH_Identity_r11 = -1;   /* INTEGER_0_509 */
static int hf_lte_rrc_nDMRS_CSH_Identity_r11 = -1;  /* INTEGER_0_509 */
static int hf_lte_rrc_uciOnPUSCH = -1;            /* T_uciOnPUSCH */
static int hf_lte_rrc_setup_105 = -1;             /* T_setup_94 */
static int hf_lte_rrc_betaOffset_ACK_Index_SubframeSet2_r12 = -1;  /* INTEGER_0_15 */
static int hf_lte_rrc_betaOffset_RI_Index_SubframeSet2_r12 = -1;  /* INTEGER_0_15 */
static int hf_lte_rrc_betaOffset_CQI_Index_SubframeSet2_r12 = -1;  /* INTEGER_0_15 */
static int hf_lte_rrc_betaOffsetMC_r12 = -1;      /* T_betaOffsetMC_r12 */
static int hf_lte_rrc_betaOffset_ACK_Index_MC_SubframeSet2_r12 = -1;  /* INTEGER_0_15 */
static int hf_lte_rrc_betaOffset_RI_Index_MC_SubframeSet2_r12 = -1;  /* INTEGER_0_15 */
static int hf_lte_rrc_betaOffset_CQI_Index_MC_SubframeSet2_r12 = -1;  /* INTEGER_0_15 */
static int hf_lte_rrc_betaOffset_ACK_Index_r13 = -1;  /* INTEGER_0_15 */
static int hf_lte_rrc_betaOffset2_ACK_Index_r13 = -1;  /* INTEGER_0_15 */
static int hf_lte_rrc_betaOffset_RI_Index_r13 = -1;  /* INTEGER_0_15 */
static int hf_lte_rrc_betaOffset_CQI_Index_r13 = -1;  /* INTEGER_0_15 */
static int hf_lte_rrc_betaOffsetMC_r13 = -1;      /* T_betaOffsetMC_r13 */
static int hf_lte_rrc_betaOffset_ACK_Index_MC_r13 = -1;  /* INTEGER_0_15 */
static int hf_lte_rrc_betaOffset2_ACK_Index_MC_r13 = -1;  /* INTEGER_0_15 */
static int hf_lte_rrc_betaOffset_RI_Index_MC_r13 = -1;  /* INTEGER_0_15 */
static int hf_lte_rrc_betaOffset_CQI_Index_MC_r13 = -1;  /* INTEGER_0_15 */
static int hf_lte_rrc_groupHoppingDisabled_r13 = -1;  /* T_groupHoppingDisabled_r13 */
static int hf_lte_rrc_dmrs_WithOCC_Activated_r13 = -1;  /* T_dmrs_WithOCC_Activated_r13 */
static int hf_lte_rrc_pusch_DMRS_r11_01 = -1;     /* T_pusch_DMRS_r11_01 */
static int hf_lte_rrc_setup_106 = -1;             /* T_setup_95 */
static int hf_lte_rrc_nPUSCH_Identity_r13 = -1;   /* INTEGER_0_509 */
static int hf_lte_rrc_nDMRS_CSH_Identity_r13 = -1;  /* INTEGER_0_509 */
static int hf_lte_rrc_uciOnPUSCH_01 = -1;         /* T_uciOnPUSCH_01 */
static int hf_lte_rrc_setup_107 = -1;             /* T_setup_96 */
static int hf_lte_rrc_betaOffset_ACK_Index_SubframeSet2_r13 = -1;  /* INTEGER_0_15 */
static int hf_lte_rrc_betaOffset2_ACK_Index_SubframeSet2_r13 = -1;  /* INTEGER_0_15 */
static int hf_lte_rrc_betaOffset_RI_Index_SubframeSet2_r13 = -1;  /* INTEGER_0_15 */
static int hf_lte_rrc_betaOffset_CQI_Index_SubframeSet2_r13 = -1;  /* INTEGER_0_15 */
static int hf_lte_rrc_betaOffsetMC_r12_01 = -1;   /* T_betaOffsetMC_r12_01 */
static int hf_lte_rrc_betaOffset_ACK_Index_MC_SubframeSet2_r13 = -1;  /* INTEGER_0_15 */
static int hf_lte_rrc_betaOffset2_ACK_Index_MC_SubframeSet2_r13 = -1;  /* INTEGER_0_15 */
static int hf_lte_rrc_betaOffset_RI_Index_MC_SubframeSet2_r13 = -1;  /* INTEGER_0_15 */
static int hf_lte_rrc_betaOffset_CQI_Index_MC_SubframeSet2_r13 = -1;  /* INTEGER_0_15 */
static int hf_lte_rrc_pusch_HoppingConfig_r13 = -1;  /* T_pusch_HoppingConfig_r13 */
static int hf_lte_rrc_ce_PUSCH_NB_MaxTBS_r14 = -1;  /* T_ce_PUSCH_NB_MaxTBS_r14 */
static int hf_lte_rrc_ce_PUSCH_MaxBandwidth_r14 = -1;  /* T_ce_PUSCH_MaxBandwidth_r14 */
static int hf_lte_rrc_tdd_PUSCH_UpPTS_r14 = -1;   /* TDD_PUSCH_UpPTS_r14 */
static int hf_lte_rrc_ul_DMRS_IFDMA_r14 = -1;     /* BOOLEAN */
static int hf_lte_rrc_enable256QAM_r14 = -1;      /* Enable256QAM_r14 */
static int hf_lte_rrc_ce_PUSCH_FlexibleStartPRB_AllocConfig_r15 = -1;  /* T_ce_PUSCH_FlexibleStartPRB_AllocConfig_r15 */
static int hf_lte_rrc_setup_108 = -1;             /* T_setup_97 */
static int hf_lte_rrc_offsetCE_ModeB_r15 = -1;    /* INTEGER_M1_3 */
static int hf_lte_rrc_ce_PUSCH_SubPRB_Config_r15 = -1;  /* T_ce_PUSCH_SubPRB_Config_r15 */
static int hf_lte_rrc_setup_109 = -1;             /* T_setup_98 */
static int hf_lte_rrc_locationCE_ModeB_r15 = -1;  /* INTEGER_0_5 */
static int hf_lte_rrc_sixToneCyclicShift_r15 = -1;  /* INTEGER_0_3 */
static int hf_lte_rrc_threeToneCyclicShift_r15 = -1;  /* INTEGER_0_2 */
static int hf_lte_rrc_groupHoppingDisabled_r10_01 = -1;  /* T_groupHoppingDisabled_r10_01 */
static int hf_lte_rrc_dmrs_WithOCC_Activated_r10_01 = -1;  /* T_dmrs_WithOCC_Activated_r10_01 */
static int hf_lte_rrc_uci_OnPUSCH_r15 = -1;       /* T_uci_OnPUSCH_r15 */
static int hf_lte_rrc_setup_110 = -1;             /* T_setup_99 */
static int hf_lte_rrc_betaOffsetAUL_r15 = -1;     /* INTEGER_0_15 */
static int hf_lte_rrc_setup_111 = -1;             /* T_setup_100 */
static int hf_lte_rrc_symPUSCH_UpPTS_r14 = -1;    /* T_symPUSCH_UpPTS_r14 */
static int hf_lte_rrc_dmrs_LessUpPTS_Config_r14 = -1;  /* T_dmrs_LessUpPTS_Config_r14 */
static int hf_lte_rrc_setup_112 = -1;             /* T_setup_101 */
static int hf_lte_rrc_tpc_SubframeSet_Configured_r14 = -1;  /* T_tpc_SubframeSet_Configured_r14 */
static int hf_lte_rrc_subframeSet1_DCI_Format0_r14 = -1;  /* BOOLEAN */
static int hf_lte_rrc_subframeSet1_DCI_Format4_r14 = -1;  /* BOOLEAN */
static int hf_lte_rrc_subframeSet2_DCI_Format0_r14 = -1;  /* BOOLEAN */
static int hf_lte_rrc_subframeSet2_DCI_Format4_r14 = -1;  /* BOOLEAN */
static int hf_lte_rrc_tpc_SubframeSet_NotConfigured_r14 = -1;  /* T_tpc_SubframeSet_NotConfigured_r14 */
static int hf_lte_rrc_dci_Format0_r14 = -1;       /* BOOLEAN */
static int hf_lte_rrc_dci_Format4_r14 = -1;       /* BOOLEAN */
static int hf_lte_rrc_setup_113 = -1;             /* T_setup_102 */
static int hf_lte_rrc_pusch_HoppingOffsetPUSCH_Enh_r14 = -1;  /* INTEGER_1_100 */
static int hf_lte_rrc_interval_ULHoppingPUSCH_Enh_r14 = -1;  /* T_interval_ULHoppingPUSCH_Enh_r14 */
static int hf_lte_rrc_interval_FDD_PUSCH_Enh_r14 = -1;  /* T_interval_FDD_PUSCH_Enh_r14 */
static int hf_lte_rrc_interval_TDD_PUSCH_Enh_r14 = -1;  /* T_interval_TDD_PUSCH_Enh_r14 */
static int hf_lte_rrc_groupHoppingEnabled = -1;   /* BOOLEAN */
static int hf_lte_rrc_groupAssignmentPUSCH = -1;  /* INTEGER_0_29 */
static int hf_lte_rrc_sequenceHoppingEnabled = -1;  /* BOOLEAN */
static int hf_lte_rrc_cyclicShift = -1;           /* INTEGER_0_7 */
static int hf_lte_rrc_preambleInfo = -1;          /* T_preambleInfo */
static int hf_lte_rrc_numberOfRA_Preambles = -1;  /* T_numberOfRA_Preambles */
static int hf_lte_rrc_preamblesGroupAConfig = -1;  /* T_preamblesGroupAConfig */
static int hf_lte_rrc_sizeOfRA_PreamblesGroupA = -1;  /* T_sizeOfRA_PreamblesGroupA */
static int hf_lte_rrc_messageSizeGroupA = -1;     /* T_messageSizeGroupA */
static int hf_lte_rrc_messagePowerOffsetGroupB = -1;  /* T_messagePowerOffsetGroupB */
static int hf_lte_rrc_powerRampingParameters = -1;  /* PowerRampingParameters */
static int hf_lte_rrc_ra_SupervisionInfo = -1;    /* T_ra_SupervisionInfo */
static int hf_lte_rrc_preambleTransMax = -1;      /* PreambleTransMax */
static int hf_lte_rrc_ra_ResponseWindowSize = -1;  /* T_ra_ResponseWindowSize */
static int hf_lte_rrc_mac_ContentionResolutionTimer = -1;  /* T_mac_ContentionResolutionTimer */
static int hf_lte_rrc_maxHARQ_Msg3Tx = -1;        /* INTEGER_1_8 */
static int hf_lte_rrc_preambleTransMax_CE_r13 = -1;  /* PreambleTransMax */
static int hf_lte_rrc_rach_CE_LevelInfoList_r13 = -1;  /* RACH_CE_LevelInfoList_r13 */
static int hf_lte_rrc_edt_SmallTBS_Subset_r15 = -1;  /* T_edt_SmallTBS_Subset_r15 */
static int hf_lte_rrc_txFailParams_r12 = -1;      /* T_txFailParams_r12 */
static int hf_lte_rrc_connEstFailCount_r12 = -1;  /* T_connEstFailCount_r12 */
static int hf_lte_rrc_connEstFailOffsetValidity_r12 = -1;  /* T_connEstFailOffsetValidity_r12 */
static int hf_lte_rrc_connEstFailOffset_r12 = -1;  /* INTEGER_0_15 */
static int hf_lte_rrc_powerRampingParameters_r11 = -1;  /* PowerRampingParameters */
static int hf_lte_rrc_ra_SupervisionInfo_r11 = -1;  /* T_ra_SupervisionInfo_r11 */
static int hf_lte_rrc_preambleTransMax_r11 = -1;  /* PreambleTransMax */
static int hf_lte_rrc_RACH_CE_LevelInfoList_r13_item = -1;  /* RACH_CE_LevelInfo_r13 */
static int hf_lte_rrc_preambleMappingInfo_r13 = -1;  /* T_preambleMappingInfo_r13 */
static int hf_lte_rrc_firstPreamble_r13 = -1;     /* INTEGER_0_63 */
static int hf_lte_rrc_lastPreamble_r13 = -1;      /* INTEGER_0_63 */
static int hf_lte_rrc_ra_ResponseWindowSize_r13 = -1;  /* T_ra_ResponseWindowSize_r13 */
static int hf_lte_rrc_mac_ContentionResolutionTimer_r13 = -1;  /* T_mac_ContentionResolutionTimer_r13 */
static int hf_lte_rrc_rar_HoppingConfig_r13 = -1;  /* T_rar_HoppingConfig_r13 */
static int hf_lte_rrc_edt_Parameters_r15 = -1;    /* T_edt_Parameters_r15 */
static int hf_lte_rrc_edt_LastPreamble_r15 = -1;  /* INTEGER_0_63 */
static int hf_lte_rrc_edt_SmallTBS_Enabled_r15 = -1;  /* BOOLEAN */
static int hf_lte_rrc_edt_TBS_r15 = -1;           /* T_edt_TBS_r15 */
static int hf_lte_rrc_mac_ContentionResolutionTimer_r15 = -1;  /* T_mac_ContentionResolutionTimer_r15 */
static int hf_lte_rrc_powerRampingStep = -1;      /* T_powerRampingStep */
static int hf_lte_rrc_preambleInitialReceivedTargetPower = -1;  /* T_preambleInitialReceivedTargetPower */
static int hf_lte_rrc_ra_PreambleIndex = -1;      /* INTEGER_0_63 */
static int hf_lte_rrc_ra_PRACH_MaskIndex = -1;    /* INTEGER_0_15 */
static int hf_lte_rrc_rach_ConfigCommon = -1;     /* RACH_ConfigCommon */
static int hf_lte_rrc_bcch_Config = -1;           /* BCCH_Config */
static int hf_lte_rrc_pcch_Config = -1;           /* PCCH_Config */
static int hf_lte_rrc_prach_Config = -1;          /* PRACH_ConfigSIB */
static int hf_lte_rrc_pdsch_ConfigCommon = -1;    /* PDSCH_ConfigCommon */
static int hf_lte_rrc_pusch_ConfigCommon = -1;    /* PUSCH_ConfigCommon */
static int hf_lte_rrc_pucch_ConfigCommon = -1;    /* PUCCH_ConfigCommon */
static int hf_lte_rrc_soundingRS_UL_ConfigCommon = -1;  /* SoundingRS_UL_ConfigCommon */
static int hf_lte_rrc_uplinkPowerControlCommon = -1;  /* UplinkPowerControlCommon */
static int hf_lte_rrc_ul_CyclicPrefixLength = -1;  /* UL_CyclicPrefixLength */
static int hf_lte_rrc_uplinkPowerControlCommon_v1020 = -1;  /* UplinkPowerControlCommon_v1020 */
static int hf_lte_rrc_rach_ConfigCommon_v1250 = -1;  /* RACH_ConfigCommon_v1250 */
static int hf_lte_rrc_pusch_ConfigCommon_v1270 = -1;  /* PUSCH_ConfigCommon_v1270 */
static int hf_lte_rrc_bcch_Config_v1310 = -1;     /* BCCH_Config_v1310 */
static int hf_lte_rrc_pcch_Config_v1310 = -1;     /* PCCH_Config_v1310 */
static int hf_lte_rrc_freqHoppingParameters_r13 = -1;  /* FreqHoppingParameters_r13 */
static int hf_lte_rrc_pdsch_ConfigCommon_v1310 = -1;  /* PDSCH_ConfigCommon_v1310 */
static int hf_lte_rrc_pusch_ConfigCommon_v1310 = -1;  /* PUSCH_ConfigCommon_v1310 */
static int hf_lte_rrc_prach_ConfigCommon_v1310 = -1;  /* PRACH_ConfigSIB_v1310 */
static int hf_lte_rrc_pucch_ConfigCommon_v1310 = -1;  /* PUCCH_ConfigCommon_v1310 */
static int hf_lte_rrc_highSpeedConfig_r14 = -1;   /* HighSpeedConfig_r14 */
static int hf_lte_rrc_prach_Config_v1430 = -1;    /* PRACH_Config_v1430 */
static int hf_lte_rrc_pucch_ConfigCommon_v1430 = -1;  /* PUCCH_ConfigCommon_v1430 */
static int hf_lte_rrc_prach_Config_v1530 = -1;    /* PRACH_ConfigSIB_v1530 */
static int hf_lte_rrc_ce_RSS_Config_r15 = -1;     /* RSS_Config_r15 */
static int hf_lte_rrc_wus_Config_r15 = -1;        /* WUS_Config_r15 */
static int hf_lte_rrc_highSpeedConfig_v1530 = -1;  /* HighSpeedConfig_v1530 */
static int hf_lte_rrc_uplinkPowerControlCommon_v1540 = -1;  /* UplinkPowerControlCommon_v1530 */
static int hf_lte_rrc_wus_Config_v1560 = -1;      /* WUS_Config_v1560 */
static int hf_lte_rrc_prach_Config_01 = -1;       /* PRACH_Config */
static int hf_lte_rrc_prach_Config_v1310 = -1;    /* PRACH_Config_v1310 */
static int hf_lte_rrc_uplinkPowerControlCommon_v1310 = -1;  /* UplinkPowerControlCommon_v1310 */
static int hf_lte_rrc_uplinkPowerControlCommon_v1530 = -1;  /* UplinkPowerControlCommon_v1530 */
static int hf_lte_rrc_basicFields_r12 = -1;       /* RadioResourceConfigCommonSCell_r10 */
static int hf_lte_rrc_pucch_ConfigCommon_r12 = -1;  /* PUCCH_ConfigCommon */
static int hf_lte_rrc_rach_ConfigCommon_r12 = -1;  /* RACH_ConfigCommon */
static int hf_lte_rrc_uplinkPowerControlCommonPSCell_r12 = -1;  /* UplinkPowerControlCommonPSCell_r12 */
static int hf_lte_rrc_uplinkPowerControlCommonPSCell_v1310 = -1;  /* UplinkPowerControlCommon_v1310 */
static int hf_lte_rrc_uplinkPowerControlCommonPSCell_v1530 = -1;  /* UplinkPowerControlCommon_v1530 */
static int hf_lte_rrc_basicFields_v12f0 = -1;     /* RadioResourceConfigCommonSCell_v10l0 */
static int hf_lte_rrc_basicFields_v1440 = -1;     /* RadioResourceConfigCommonSCell_v1440 */
static int hf_lte_rrc_nonUL_Configuration_r10_01 = -1;  /* T_nonUL_Configuration_r10_01 */
static int hf_lte_rrc_dl_Bandwidth_r10 = -1;      /* T_dl_Bandwidth_r10 */
static int hf_lte_rrc_antennaInfoCommon_r10 = -1;  /* AntennaInfoCommon */
static int hf_lte_rrc_mbsfn_SubframeConfigList_r10 = -1;  /* MBSFN_SubframeConfigList */
static int hf_lte_rrc_phich_Config_r10 = -1;      /* PHICH_Config */
static int hf_lte_rrc_pdsch_ConfigCommon_r10 = -1;  /* PDSCH_ConfigCommon */
static int hf_lte_rrc_tdd_Config_r10 = -1;        /* TDD_Config */
static int hf_lte_rrc_ul_Configuration_r10_01 = -1;  /* T_ul_Configuration_r10_01 */
static int hf_lte_rrc_ul_FreqInfo_r10 = -1;       /* T_ul_FreqInfo_r10 */
static int hf_lte_rrc_ul_CarrierFreq_r10 = -1;    /* ARFCN_ValueEUTRA */
static int hf_lte_rrc_ul_Bandwidth_r10 = -1;      /* T_ul_Bandwidth_r10 */
static int hf_lte_rrc_additionalSpectrumEmissionSCell_r10 = -1;  /* AdditionalSpectrumEmission */
static int hf_lte_rrc_p_Max_r10 = -1;             /* P_Max */
static int hf_lte_rrc_uplinkPowerControlCommonSCell_r10 = -1;  /* UplinkPowerControlCommonSCell_r10 */
static int hf_lte_rrc_soundingRS_UL_ConfigCommon_r10 = -1;  /* SoundingRS_UL_ConfigCommon */
static int hf_lte_rrc_ul_CyclicPrefixLength_r10 = -1;  /* UL_CyclicPrefixLength */
static int hf_lte_rrc_prach_ConfigSCell_r10 = -1;  /* PRACH_ConfigSCell_r10 */
static int hf_lte_rrc_pusch_ConfigCommon_r10 = -1;  /* PUSCH_ConfigCommon */
static int hf_lte_rrc_ul_CarrierFreq_v1090 = -1;  /* ARFCN_ValueEUTRA_v9e0 */
static int hf_lte_rrc_rach_ConfigCommonSCell_r11 = -1;  /* RACH_ConfigCommonSCell_r11 */
static int hf_lte_rrc_prach_ConfigSCell_r11 = -1;  /* PRACH_Config */
static int hf_lte_rrc_uplinkPowerControlCommonSCell_v1130 = -1;  /* UplinkPowerControlCommonSCell_v1130 */
static int hf_lte_rrc_pucch_ConfigCommon_r13 = -1;  /* PUCCH_ConfigCommon */
static int hf_lte_rrc_uplinkPowerControlCommonSCell_v1310 = -1;  /* UplinkPowerControlCommonSCell_v1310 */
static int hf_lte_rrc_highSpeedConfigSCell_r14 = -1;  /* HighSpeedConfigSCell_r14 */
static int hf_lte_rrc_ul_Configuration_r14 = -1;  /* T_ul_Configuration_r14 */
static int hf_lte_rrc_ul_FreqInfo_r14 = -1;       /* T_ul_FreqInfo_r14 */
static int hf_lte_rrc_ul_CarrierFreq_r14 = -1;    /* ARFCN_ValueEUTRA_r9 */
static int hf_lte_rrc_ul_Bandwidth_r14 = -1;      /* T_ul_Bandwidth_r14 */
static int hf_lte_rrc_additionalSpectrumEmissionSCell_r14 = -1;  /* AdditionalSpectrumEmission */
static int hf_lte_rrc_p_Max_r14 = -1;             /* P_Max */
static int hf_lte_rrc_soundingRS_UL_ConfigCommon_r14 = -1;  /* SoundingRS_UL_ConfigCommon */
static int hf_lte_rrc_ul_CyclicPrefixLength_r14 = -1;  /* UL_CyclicPrefixLength */
static int hf_lte_rrc_prach_ConfigSCell_r14 = -1;  /* PRACH_ConfigSCell_r10 */
static int hf_lte_rrc_uplinkPowerControlCommonPUSCH_LessCell_v1430 = -1;  /* UplinkPowerControlCommonPUSCH_LessCell_v1430 */
static int hf_lte_rrc_harq_ReferenceConfig_r14 = -1;  /* T_harq_ReferenceConfig_r14 */
static int hf_lte_rrc_soundingRS_FlexibleTiming_r14 = -1;  /* T_soundingRS_FlexibleTiming_r14 */
static int hf_lte_rrc_uplinkPowerControlCommonSCell_v1530 = -1;  /* UplinkPowerControlCommon_v1530 */
static int hf_lte_rrc_ul_Configuration_v10l0 = -1;  /* T_ul_Configuration_v10l0 */
static int hf_lte_rrc_additionalSpectrumEmissionSCell_v10l0 = -1;  /* AdditionalSpectrumEmission_v10l0 */
static int hf_lte_rrc_ul_Configuration_v1440 = -1;  /* T_ul_Configuration_v1440 */
static int hf_lte_rrc_ul_FreqInfo_v1440 = -1;     /* T_ul_FreqInfo_v1440 */
static int hf_lte_rrc_additionalSpectrumEmissionSCell_v1440 = -1;  /* AdditionalSpectrumEmission_v10l0 */
static int hf_lte_rrc_modificationPeriodCoeff = -1;  /* T_modificationPeriodCoeff */
static int hf_lte_rrc_modificationPeriodCoeff_v1310 = -1;  /* T_modificationPeriodCoeff_v1310 */
static int hf_lte_rrc_dummy_05 = -1;              /* T_dummy_02 */
static int hf_lte_rrc_dummy2_01 = -1;             /* T_dummy2_01 */
static int hf_lte_rrc_interval_FDD_r13_02 = -1;   /* T_interval_FDD_r13_02 */
static int hf_lte_rrc_interval_TDD_r13_02 = -1;   /* T_interval_TDD_r13_02 */
static int hf_lte_rrc_dummy3 = -1;                /* T_dummy3 */
static int hf_lte_rrc_interval_FDD_r13_03 = -1;   /* T_interval_FDD_r13_03 */
static int hf_lte_rrc_interval_TDD_r13_03 = -1;   /* T_interval_TDD_r13_03 */
static int hf_lte_rrc_interval_ULHoppingConfigCommonModeA_r13 = -1;  /* T_interval_ULHoppingConfigCommonModeA_r13 */
static int hf_lte_rrc_interval_FDD_r13_04 = -1;   /* T_interval_FDD_r13_04 */
static int hf_lte_rrc_interval_TDD_r13_04 = -1;   /* T_interval_TDD_r13_04 */
static int hf_lte_rrc_interval_ULHoppingConfigCommonModeB_r13 = -1;  /* T_interval_ULHoppingConfigCommonModeB_r13 */
static int hf_lte_rrc_interval_FDD_r13_05 = -1;   /* T_interval_FDD_r13_05 */
static int hf_lte_rrc_interval_TDD_r13_05 = -1;   /* T_interval_TDD_r13_05 */
static int hf_lte_rrc_dummy4 = -1;                /* INTEGER_1_maxAvailNarrowBands_r13 */
static int hf_lte_rrc_defaultPagingCycle = -1;    /* T_defaultPagingCycle */
static int hf_lte_rrc_nB = -1;                    /* T_nB */
static int hf_lte_rrc_paging_narrowBands_r13 = -1;  /* INTEGER_1_maxAvailNarrowBands_r13 */
static int hf_lte_rrc_mpdcch_NumRepetition_Paging_r13 = -1;  /* T_mpdcch_NumRepetition_Paging_r13 */
static int hf_lte_rrc_nB_v1310 = -1;              /* T_nB_v1310 */
static int hf_lte_rrc_highSpeedEnhancedMeasFlag_r14 = -1;  /* T_highSpeedEnhancedMeasFlag_r14 */
static int hf_lte_rrc_highSpeedEnhancedDemodulationFlag_r14 = -1;  /* T_highSpeedEnhancedDemodulationFlag_r14 */
static int hf_lte_rrc_highSpeedMeasGapCE_ModeA_r15 = -1;  /* T_highSpeedMeasGapCE_ModeA_r15 */
static int hf_lte_rrc_highSpeedEnhancedDemodulationFlag_r14_01 = -1;  /* T_highSpeedEnhancedDemodulationFlag_r14_01 */
static int hf_lte_rrc_srb_ToAddModList = -1;      /* SRB_ToAddModList */
static int hf_lte_rrc_drb_ToAddModList = -1;      /* DRB_ToAddModList */
static int hf_lte_rrc_drb_ToReleaseList = -1;     /* DRB_ToReleaseList */
static int hf_lte_rrc_mac_MainConfig = -1;        /* T_mac_MainConfig */
static int hf_lte_rrc_explicitValue_03 = -1;      /* MAC_MainConfig */
static int hf_lte_rrc_sps_Config = -1;            /* SPS_Config */
static int hf_lte_rrc_physicalConfigDedicated = -1;  /* PhysicalConfigDedicated */
static int hf_lte_rrc_rlf_TimersAndConstants_r9 = -1;  /* RLF_TimersAndConstants_r9 */
static int hf_lte_rrc_measSubframePatternPCell_r10 = -1;  /* MeasSubframePatternPCell_r10 */
static int hf_lte_rrc_neighCellsCRS_Info_r11 = -1;  /* NeighCellsCRS_Info_r11 */
static int hf_lte_rrc_naics_Info_r12 = -1;        /* NAICS_AssistanceInfo_r12 */
static int hf_lte_rrc_neighCellsCRS_Info_r13 = -1;  /* NeighCellsCRS_Info_r13 */
static int hf_lte_rrc_rlf_TimersAndConstants_r13 = -1;  /* RLF_TimersAndConstants_r13 */
static int hf_lte_rrc_sps_Config_v1430 = -1;      /* SPS_Config_v1430 */
static int hf_lte_rrc_srb_ToAddModListExt_r15 = -1;  /* SRB_ToAddModListExt_r15 */
static int hf_lte_rrc_srb_ToReleaseListExt_r15 = -1;  /* INTEGER_4 */
static int hf_lte_rrc_sps_Config_v1530 = -1;      /* SPS_Config_v1530 */
static int hf_lte_rrc_crs_IntfMitigConfig_r15_01 = -1;  /* T_crs_IntfMitigConfig_r15_01 */
static int hf_lte_rrc_setup_114 = -1;             /* T_setup_103 */
static int hf_lte_rrc_crs_IntfMitigNumPRBs_r15_01 = -1;  /* T_crs_IntfMitigNumPRBs_r15_01 */
static int hf_lte_rrc_neighCellsCRS_Info_r15 = -1;  /* NeighCellsCRS_Info_r15 */
static int hf_lte_rrc_drb_ToAddModList_r15 = -1;  /* DRB_ToAddModList_r15 */
static int hf_lte_rrc_drb_ToReleaseList_r15 = -1;  /* DRB_ToReleaseList_r15 */
static int hf_lte_rrc_dummy_06 = -1;              /* T_dummy_03 */
static int hf_lte_rrc_dummy_item = -1;            /* INTEGER_1_2 */
static int hf_lte_rrc_sps_Config_v1540 = -1;      /* SPS_Config_v1540 */
static int hf_lte_rrc_physicalConfigDedicated_v1370 = -1;  /* PhysicalConfigDedicated_v1370 */
static int hf_lte_rrc_physicalConfigDedicated_v13c0 = -1;  /* PhysicalConfigDedicated_v13c0 */
static int hf_lte_rrc_physicalConfigDedicatedPSCell_r12 = -1;  /* PhysicalConfigDedicated */
static int hf_lte_rrc_sps_Config_r12 = -1;        /* SPS_Config */
static int hf_lte_rrc_neighCellsCRS_InfoPSCell_r13 = -1;  /* NeighCellsCRS_Info_r13 */
static int hf_lte_rrc_crs_IntfMitigEnabled_r15 = -1;  /* BOOLEAN */
static int hf_lte_rrc_physicalConfigDedicatedPSCell_v1370 = -1;  /* PhysicalConfigDedicated_v1370 */
static int hf_lte_rrc_physicalConfigDedicatedPSCell_v13c0 = -1;  /* PhysicalConfigDedicated_v13c0 */
static int hf_lte_rrc_drb_ToAddModListSCG_r12_01 = -1;  /* DRB_ToAddModListSCG_r12 */
static int hf_lte_rrc_mac_MainConfigSCG_r12 = -1;  /* MAC_MainConfig */
static int hf_lte_rrc_rlf_TimersAndConstantsSCG_r12 = -1;  /* RLF_TimersAndConstantsSCG_r12 */
static int hf_lte_rrc_drb_ToAddModListSCG_r15_01 = -1;  /* DRB_ToAddModListSCG_r15 */
static int hf_lte_rrc_srb_ToAddModListSCG_r15 = -1;  /* SRB_ToAddModList */
static int hf_lte_rrc_srb_ToReleaseListSCG_r15 = -1;  /* SRB_ToReleaseList_r15 */
static int hf_lte_rrc_physicalConfigDedicatedSCell_r10 = -1;  /* PhysicalConfigDedicatedSCell_r10 */
static int hf_lte_rrc_mac_MainConfigSCell_r11 = -1;  /* MAC_MainConfigSCell_r11 */
static int hf_lte_rrc_neighCellsCRS_InfoSCell_r13 = -1;  /* NeighCellsCRS_Info_r13 */
static int hf_lte_rrc_physicalConfigDedicatedSCell_v1370 = -1;  /* PhysicalConfigDedicatedSCell_v1370 */
static int hf_lte_rrc_physicalConfigDedicatedSCell_v13c0 = -1;  /* PhysicalConfigDedicatedSCell_v13c0 */
static int hf_lte_rrc_SRB_ToAddModList_item = -1;  /* SRB_ToAddMod */
static int hf_lte_rrc_SRB_ToAddModListExt_r15_item = -1;  /* SRB_ToAddMod */
static int hf_lte_rrc_srb_Identity = -1;          /* INTEGER_1_2 */
static int hf_lte_rrc_rlc_Config = -1;            /* T_rlc_Config */
static int hf_lte_rrc_explicitValue_04 = -1;      /* RLC_Config */
static int hf_lte_rrc_logicalChannelConfig = -1;  /* T_logicalChannelConfig */
static int hf_lte_rrc_explicitValue_05 = -1;      /* LogicalChannelConfig */
static int hf_lte_rrc_pdcp_verChange_r15 = -1;    /* T_pdcp_verChange_r15 */
static int hf_lte_rrc_rlc_Config_v1530 = -1;      /* RLC_Config_v1530 */
static int hf_lte_rrc_rlc_BearerConfigSecondary_r15 = -1;  /* RLC_BearerConfig_r15 */
static int hf_lte_rrc_srb_Identity_v1530 = -1;    /* INTEGER_4 */
static int hf_lte_rrc_rlc_Config_v1560 = -1;      /* RLC_Config_v1510 */
static int hf_lte_rrc_DRB_ToAddModList_item = -1;  /* DRB_ToAddMod */
static int hf_lte_rrc_DRB_ToAddModList_r15_item = -1;  /* DRB_ToAddMod */
static int hf_lte_rrc_DRB_ToAddModListSCG_r12_item = -1;  /* DRB_ToAddModSCG_r12 */
static int hf_lte_rrc_DRB_ToAddModListSCG_r15_item = -1;  /* DRB_ToAddModSCG_r12 */
static int hf_lte_rrc_eps_BearerIdentity = -1;    /* INTEGER_0_15 */
static int hf_lte_rrc_pdcp_Config = -1;           /* PDCP_Config */
static int hf_lte_rrc_rlc_Config_01 = -1;         /* RLC_Config */
static int hf_lte_rrc_logicalChannelIdentity = -1;  /* T_logicalChannelIdentity */
static int hf_lte_rrc_logicalChannelConfig_01 = -1;  /* LogicalChannelConfig */
static int hf_lte_rrc_drb_TypeChange_r12 = -1;    /* T_drb_TypeChange_r12 */
static int hf_lte_rrc_rlc_Config_v1250 = -1;      /* RLC_Config_v1250 */
static int hf_lte_rrc_rlc_Config_v1310 = -1;      /* RLC_Config_v1310 */
static int hf_lte_rrc_drb_TypeLWA_r13 = -1;       /* BOOLEAN */
static int hf_lte_rrc_drb_TypeLWIP_r13 = -1;      /* T_drb_TypeLWIP_r13 */
static int hf_lte_rrc_rlc_Config_v1430 = -1;      /* RLC_Config_v1430 */
static int hf_lte_rrc_lwip_UL_Aggregation_r14 = -1;  /* BOOLEAN */
static int hf_lte_rrc_lwip_DL_Aggregation_r14 = -1;  /* BOOLEAN */
static int hf_lte_rrc_lwa_WLAN_AC_r14 = -1;       /* T_lwa_WLAN_AC_r14 */
static int hf_lte_rrc_rlc_Config_v1510 = -1;      /* RLC_Config_v1510 */
static int hf_lte_rrc_logicalChannelIdentity_r15_01 = -1;  /* INTEGER_32_38 */
static int hf_lte_rrc_drb_Type_r12_01 = -1;       /* T_drb_Type_r12_01 */
static int hf_lte_rrc_split_r12 = -1;             /* NULL */
static int hf_lte_rrc_scg_r12 = -1;               /* T_scg_r12 */
static int hf_lte_rrc_pdcp_Config_r12 = -1;       /* PDCP_Config */
static int hf_lte_rrc_rlc_ConfigSCG_r12 = -1;     /* RLC_Config */
static int hf_lte_rrc_logicalChannelIdentitySCG_r12 = -1;  /* INTEGER_3_10 */
static int hf_lte_rrc_logicalChannelConfigSCG_r12 = -1;  /* LogicalChannelConfig */
static int hf_lte_rrc_logicalChannelIdentitySCG_r15 = -1;  /* INTEGER_32_38 */
static int hf_lte_rrc_DRB_ToReleaseList_item = -1;  /* DRB_Identity */
static int hf_lte_rrc_DRB_ToReleaseList_r15_item = -1;  /* DRB_Identity */
static int hf_lte_rrc_SRB_ToReleaseList_r15_item = -1;  /* INTEGER_1_2 */
static int hf_lte_rrc_setup_115 = -1;             /* MeasSubframePattern_r10 */
static int hf_lte_rrc_setup_116 = -1;             /* CRS_AssistanceInfoList_r11 */
static int hf_lte_rrc_CRS_AssistanceInfoList_r11_item = -1;  /* CRS_AssistanceInfo_r11 */
static int hf_lte_rrc_physCellId_r11_02 = -1;     /* PhysCellId */
static int hf_lte_rrc_antennaPortsCount_r11_01 = -1;  /* T_antennaPortsCount_r11_01 */
static int hf_lte_rrc_mbsfn_SubframeConfigList_r11_02 = -1;  /* MBSFN_SubframeConfigList */
static int hf_lte_rrc_setup_117 = -1;             /* CRS_AssistanceInfoList_r13 */
static int hf_lte_rrc_CRS_AssistanceInfoList_r13_item = -1;  /* CRS_AssistanceInfo_r13 */
static int hf_lte_rrc_antennaPortsCount_r13 = -1;  /* T_antennaPortsCount_r13 */
static int hf_lte_rrc_mbsfn_SubframeConfigList_r13 = -1;  /* MBSFN_SubframeConfigList */
static int hf_lte_rrc_setup_118 = -1;             /* CRS_AssistanceInfoList_r15 */
static int hf_lte_rrc_CRS_AssistanceInfoList_r15_item = -1;  /* CRS_AssistanceInfo_r15 */
static int hf_lte_rrc_physCellId_r15 = -1;        /* PhysCellId */
static int hf_lte_rrc_crs_IntfMitigEnabled_15_01 = -1;  /* T_crs_IntfMitigEnabled_15 */
static int hf_lte_rrc_setup_119 = -1;             /* T_setup_104 */
static int hf_lte_rrc_neighCellsToReleaseList_r12 = -1;  /* NeighCellsToReleaseList_r12 */
static int hf_lte_rrc_neighCellsToAddModList_r12 = -1;  /* NeighCellsToAddModList_r12 */
static int hf_lte_rrc_servCellp_a_r12 = -1;       /* P_a */
static int hf_lte_rrc_NeighCellsToReleaseList_r12_item = -1;  /* PhysCellId */
static int hf_lte_rrc_NeighCellsToAddModList_r12_item = -1;  /* NeighCellsInfo_r12 */
static int hf_lte_rrc_p_b_r12 = -1;               /* INTEGER_0_3 */
static int hf_lte_rrc_crs_PortsCount_r12 = -1;    /* T_crs_PortsCount_r12 */
static int hf_lte_rrc_mbsfn_SubframeConfig_r12 = -1;  /* MBSFN_SubframeConfigList */
static int hf_lte_rrc_p_aList_r12 = -1;           /* SEQUENCE_SIZE_1_maxP_a_PerNeighCell_r12_OF_P_a */
static int hf_lte_rrc_p_aList_r12_item = -1;      /* P_a */
static int hf_lte_rrc_transmissionModeList_r12 = -1;  /* T_transmissionModeList_r12 */
static int hf_lte_rrc_resAllocGranularity_r12 = -1;  /* INTEGER_1_4 */
static int hf_lte_rrc_setup_120 = -1;             /* T_setup_105 */
static int hf_lte_rrc_rlc_Config_r15 = -1;        /* RLC_Config_r15 */
static int hf_lte_rrc_logicalChannelIdentityConfig_r15 = -1;  /* T_logicalChannelIdentityConfig_r15 */
static int hf_lte_rrc_logicalChannelConfig_r15 = -1;  /* LogicalChannelConfig */
static int hf_lte_rrc_setup_121 = -1;             /* T_setup_106 */
static int hf_lte_rrc_rclwi_Config_r13 = -1;      /* RCLWI_Config_r13 */
static int hf_lte_rrc_command = -1;               /* T_command */
static int hf_lte_rrc_steerToWLAN_r13 = -1;       /* T_steerToWLAN_r13 */
static int hf_lte_rrc_mobilityConfig_r13 = -1;    /* WLAN_Id_List_r12 */
static int hf_lte_rrc_steerToLTE_r13 = -1;        /* NULL */
static int hf_lte_rrc_am = -1;                    /* T_am */
static int hf_lte_rrc_ul_AM_RLC = -1;             /* UL_AM_RLC */
static int hf_lte_rrc_dl_AM_RLC = -1;             /* DL_AM_RLC */
static int hf_lte_rrc_um_Bi_Directional = -1;     /* T_um_Bi_Directional */
static int hf_lte_rrc_ul_UM_RLC = -1;             /* UL_UM_RLC */
static int hf_lte_rrc_dl_UM_RLC = -1;             /* DL_UM_RLC */
static int hf_lte_rrc_um_Uni_Directional_UL = -1;  /* T_um_Uni_Directional_UL */
static int hf_lte_rrc_um_Uni_Directional_DL = -1;  /* T_um_Uni_Directional_DL */
static int hf_lte_rrc_ul_extended_RLC_LI_Field_r12 = -1;  /* T_ul_extended_RLC_LI_Field_r12 */
static int hf_lte_rrc_dl_extended_RLC_LI_Field_r12 = -1;  /* T_dl_extended_RLC_LI_Field_r12 */
static int hf_lte_rrc_ul_extended_RLC_AM_SN_r13 = -1;  /* T_ul_extended_RLC_AM_SN_r13 */
static int hf_lte_rrc_dl_extended_RLC_AM_SN_r13 = -1;  /* T_dl_extended_RLC_AM_SN_r13 */
static int hf_lte_rrc_pollPDU_v1310 = -1;         /* PollPDU_v1310 */
static int hf_lte_rrc_setup_122 = -1;             /* T_setup_107 */
static int hf_lte_rrc_pollByte_r14 = -1;          /* PollByte_r14 */
static int hf_lte_rrc_reestablishRLC_r15 = -1;    /* T_reestablishRLC_r15 */
static int hf_lte_rrc_setup_123 = -1;             /* T_setup_108 */
static int hf_lte_rrc_rlc_OutOfOrderDelivery_r15 = -1;  /* T_rlc_OutOfOrderDelivery_r15 */
static int hf_lte_rrc_mode_r15 = -1;              /* T_mode_r15 */
static int hf_lte_rrc_am_r15 = -1;                /* T_am_r15 */
static int hf_lte_rrc_ul_AM_RLC_r15 = -1;         /* UL_AM_RLC_r15 */
static int hf_lte_rrc_dl_AM_RLC_r15 = -1;         /* DL_AM_RLC_r15 */
static int hf_lte_rrc_um_Bi_Directional_r15 = -1;  /* T_um_Bi_Directional_r15 */
static int hf_lte_rrc_ul_UM_RLC_r15 = -1;         /* UL_UM_RLC */
static int hf_lte_rrc_dl_UM_RLC_r15 = -1;         /* DL_UM_RLC_r15 */
static int hf_lte_rrc_um_Uni_Directional_UL_r15 = -1;  /* T_um_Uni_Directional_UL_r15 */
static int hf_lte_rrc_um_Uni_Directional_DL_r15 = -1;  /* T_um_Uni_Directional_DL_r15 */
static int hf_lte_rrc_reestablishRLC_r15_01 = -1;  /* T_reestablishRLC_r15_01 */
static int hf_lte_rrc_rlc_OutOfOrderDelivery_r15_01 = -1;  /* T_rlc_OutOfOrderDelivery_r15_01 */
static int hf_lte_rrc_t_PollRetransmit = -1;      /* T_PollRetransmit */
static int hf_lte_rrc_pollPDU = -1;               /* PollPDU */
static int hf_lte_rrc_pollByte = -1;              /* PollByte */
static int hf_lte_rrc_maxRetxThreshold = -1;      /* T_maxRetxThreshold */
static int hf_lte_rrc_t_PollRetransmit_r15 = -1;  /* T_PollRetransmit */
static int hf_lte_rrc_pollPDU_r15 = -1;           /* PollPDU_r15 */
static int hf_lte_rrc_pollByte_r15 = -1;          /* PollByte_r14 */
static int hf_lte_rrc_maxRetxThreshold_r15 = -1;  /* T_maxRetxThreshold_r15 */
static int hf_lte_rrc_extended_RLC_LI_Field_r15 = -1;  /* BOOLEAN */
static int hf_lte_rrc_t_Reordering = -1;          /* T_Reordering */
static int hf_lte_rrc_t_StatusProhibit = -1;      /* T_StatusProhibit */
static int hf_lte_rrc_t_Reordering_r15 = -1;      /* T_Reordering */
static int hf_lte_rrc_t_StatusProhibit_r15 = -1;  /* T_StatusProhibit */
static int hf_lte_rrc_sn_FieldLength = -1;        /* SN_FieldLength */
static int hf_lte_rrc_sn_FieldLength_r15 = -1;    /* SN_FieldLength_r15 */
static int hf_lte_rrc_setup_124 = -1;             /* T_setup_109 */
static int hf_lte_rrc_t301_r9 = -1;               /* T_t301_r9 */
static int hf_lte_rrc_t310_r9 = -1;               /* T_t310_r9 */
static int hf_lte_rrc_n310_r9 = -1;               /* T_n310_r9 */
static int hf_lte_rrc_t311_r9 = -1;               /* T_t311_r9 */
static int hf_lte_rrc_n311_r9 = -1;               /* T_n311_r9 */
static int hf_lte_rrc_setup_125 = -1;             /* T_setup_110 */
static int hf_lte_rrc_t301_v1310 = -1;            /* T_t301_v1310 */
static int hf_lte_rrc_t310_v1330 = -1;            /* T_t310_v1330 */
static int hf_lte_rrc_setup_126 = -1;             /* T_setup_111 */
static int hf_lte_rrc_t313_r12 = -1;              /* T_t313_r12 */
static int hf_lte_rrc_n313_r12 = -1;              /* T_n313_r12 */
static int hf_lte_rrc_n314_r12 = -1;              /* T_n314_r12 */
static int hf_lte_rrc_subframeConfigPattern_r10 = -1;  /* T_subframeConfigPattern_r10 */
static int hf_lte_rrc_subframeConfigPatternFDD_r10 = -1;  /* BIT_STRING_SIZE_8 */
static int hf_lte_rrc_subframeConfigPatternTDD_r10 = -1;  /* INTEGER_0_31 */
static int hf_lte_rrc_rpdcch_Config_r10 = -1;     /* T_rpdcch_Config_r10 */
static int hf_lte_rrc_resourceAllocationType_r10 = -1;  /* T_resourceAllocationType_r10 */
static int hf_lte_rrc_resourceBlockAssignment_r10 = -1;  /* T_resourceBlockAssignment_r10 */
static int hf_lte_rrc_type01_r10 = -1;            /* T_type01_r10 */
static int hf_lte_rrc_nrb6_r10 = -1;              /* BIT_STRING_SIZE_6 */
static int hf_lte_rrc_nrb15_r10 = -1;             /* BIT_STRING_SIZE_8 */
static int hf_lte_rrc_nrb25_r10 = -1;             /* BIT_STRING_SIZE_13 */
static int hf_lte_rrc_nrb50_r10 = -1;             /* BIT_STRING_SIZE_17 */
static int hf_lte_rrc_nrb75_r10 = -1;             /* BIT_STRING_SIZE_19 */
static int hf_lte_rrc_nrb100_r10 = -1;            /* BIT_STRING_SIZE_25 */
static int hf_lte_rrc_type2_r10 = -1;             /* T_type2_r10 */
static int hf_lte_rrc_nrb6_r10_01 = -1;           /* BIT_STRING_SIZE_5 */
static int hf_lte_rrc_nrb15_r10_01 = -1;          /* BIT_STRING_SIZE_7 */
static int hf_lte_rrc_nrb25_r10_01 = -1;          /* BIT_STRING_SIZE_9 */
static int hf_lte_rrc_nrb50_r10_01 = -1;          /* BIT_STRING_SIZE_11 */
static int hf_lte_rrc_nrb75_r10_01 = -1;          /* BIT_STRING_SIZE_12 */
static int hf_lte_rrc_nrb100_r10_01 = -1;         /* BIT_STRING_SIZE_13 */
static int hf_lte_rrc_demodulationRS_r10 = -1;    /* T_demodulationRS_r10 */
static int hf_lte_rrc_interleaving_r10 = -1;      /* T_interleaving_r10 */
static int hf_lte_rrc_noInterleaving_r10 = -1;    /* T_noInterleaving_r10 */
static int hf_lte_rrc_pdsch_Start_r10_01 = -1;    /* INTEGER_1_3 */
static int hf_lte_rrc_pucch_Config_r10 = -1;      /* T_pucch_Config_r10 */
static int hf_lte_rrc_tdd = -1;                   /* T_tdd */
static int hf_lte_rrc_channelSelectionMultiplexingBundling = -1;  /* T_channelSelectionMultiplexingBundling */
static int hf_lte_rrc_n1PUCCH_AN_List_r10 = -1;   /* T_n1PUCCH_AN_List_r10 */
static int hf_lte_rrc_n1PUCCH_AN_List_r10_item = -1;  /* INTEGER_0_2047 */
static int hf_lte_rrc_fallbackForFormat3 = -1;    /* T_fallbackForFormat3 */
static int hf_lte_rrc_n1PUCCH_AN_P0_r10 = -1;     /* INTEGER_0_2047 */
static int hf_lte_rrc_n1PUCCH_AN_P1_r10 = -1;     /* INTEGER_0_2047 */
static int hf_lte_rrc_fdd = -1;                   /* T_fdd */
static int hf_lte_rrc_duration_r15 = -1;          /* T_duration_r15 */
static int hf_lte_rrc_freqLocation_r15 = -1;      /* INTEGER_0_98 */
static int hf_lte_rrc_periodicity_r15 = -1;       /* T_periodicity_r15 */
static int hf_lte_rrc_powerBoost_r15 = -1;        /* T_powerBoost_r15 */
static int hf_lte_rrc_timeOffset_r15 = -1;        /* INTEGER_0_31 */
static int hf_lte_rrc_setup_127 = -1;             /* T_setup_112 */
static int hf_lte_rrc_sr_PUCCH_ResourceIndex = -1;  /* INTEGER_0_2047 */
static int hf_lte_rrc_sr_ConfigIndex = -1;        /* T_sr_ConfigIndex */
static int hf_lte_rrc_dsr_TransMax = -1;          /* T_dsr_TransMax */
static int hf_lte_rrc_sr_PUCCH_ResourceIndexP1_r10 = -1;  /* INTEGER_0_2047 */
static int hf_lte_rrc_setup_128 = -1;             /* T_setup_113 */
static int hf_lte_rrc_sr_PUCCH_ResourceIndex_r13 = -1;  /* INTEGER_0_2047 */
static int hf_lte_rrc_sr_PUCCH_ResourceIndexP1_r13 = -1;  /* INTEGER_0_2047 */
static int hf_lte_rrc_sr_ConfigIndex_r13 = -1;    /* T_sr_ConfigIndex_r13 */
static int hf_lte_rrc_dsr_TransMax_r13 = -1;      /* T_dsr_TransMax_r13 */
static int hf_lte_rrc_setup_129 = -1;             /* T_setup_114 */
static int hf_lte_rrc_sr_SlotSPUCCH_IndexFH_r15 = -1;  /* INTEGER_0_1319 */
static int hf_lte_rrc_sr_SlotSPUCCH_IndexNoFH_r15 = -1;  /* INTEGER_0_3959 */
static int hf_lte_rrc_sr_SubslotSPUCCH_ResourceList_r15 = -1;  /* SR_SubslotSPUCCH_ResourceList_r15 */
static int hf_lte_rrc_sr_ConfigIndexSlot_r15 = -1;  /* INTEGER_0_36 */
static int hf_lte_rrc_sr_ConfigIndexSubslot_r15 = -1;  /* INTEGER_0_122 */
static int hf_lte_rrc_dssr_TransMax_r15 = -1;     /* T_dssr_TransMax_r15 */
static int hf_lte_rrc_SR_SubslotSPUCCH_ResourceList_r15_item = -1;  /* INTEGER_0_1319 */
static int hf_lte_rrc_setup_130 = -1;             /* T_setup_115 */
static int hf_lte_rrc_altCQI_TableSTTI_r15 = -1;  /* T_altCQI_TableSTTI_r15 */
static int hf_lte_rrc_altCQI_Table1024QAM_STTI_r15 = -1;  /* T_altCQI_Table1024QAM_STTI_r15 */
static int hf_lte_rrc_resourceAllocation_r15 = -1;  /* T_resourceAllocation_r15 */
static int hf_lte_rrc_tbsIndexAlt_STTI_r15 = -1;  /* T_tbsIndexAlt_STTI_r15 */
static int hf_lte_rrc_tbsIndexAlt2_STTI_r15 = -1;  /* T_tbsIndexAlt2_STTI_r15 */
static int hf_lte_rrc_tbsIndexAlt3_STTI_r15 = -1;  /* T_tbsIndexAlt3_STTI_r15 */
static int hf_lte_rrc_setup_131 = -1;             /* T_setup_116 */
static int hf_lte_rrc_betaOffsetSlot_ACK_Index_r15 = -1;  /* INTEGER_0_15 */
static int hf_lte_rrc_betaOffset2Slot_ACK_Index_r15 = -1;  /* INTEGER_0_15 */
static int hf_lte_rrc_betaOffsetSubslot_ACK_Index_r15 = -1;  /* T_betaOffsetSubslot_ACK_Index_r15 */
static int hf_lte_rrc_betaOffsetSubslot_ACK_Index_r15_item = -1;  /* INTEGER_0_15 */
static int hf_lte_rrc_betaOffset2Subslot_ACK_Index_r15 = -1;  /* T_betaOffset2Subslot_ACK_Index_r15 */
static int hf_lte_rrc_betaOffset2Subslot_ACK_Index_r15_item = -1;  /* INTEGER_0_15 */
static int hf_lte_rrc_betaOffsetSlot_RI_Index_r15 = -1;  /* INTEGER_0_15 */
static int hf_lte_rrc_betaOffsetSubslot_RI_Index_r15 = -1;  /* T_betaOffsetSubslot_RI_Index_r15 */
static int hf_lte_rrc_betaOffsetSubslot_RI_Index_r15_item = -1;  /* INTEGER_0_15 */
static int hf_lte_rrc_betaOffsetSlot_CQI_Index_r15 = -1;  /* INTEGER_0_15 */
static int hf_lte_rrc_betaOffsetSubslot_CQI_Index_r15 = -1;  /* INTEGER_0_15 */
static int hf_lte_rrc_enable256QAM_SlotOrSubslot_r15 = -1;  /* Enable256QAM_r14 */
static int hf_lte_rrc_resourceAllocationOffset_r15 = -1;  /* INTEGER_1_2 */
static int hf_lte_rrc_ul_DMRS_IFDMA_SlotOrSubslot_r15 = -1;  /* BOOLEAN */
static int hf_lte_rrc_setup_132 = -1;             /* T_setup_117 */
static int hf_lte_rrc_srs_BandwidthConfig = -1;   /* T_srs_BandwidthConfig */
static int hf_lte_rrc_srs_SubframeConfig = -1;    /* T_srs_SubframeConfig */
static int hf_lte_rrc_ackNackSRS_SimultaneousTransmission = -1;  /* BOOLEAN */
static int hf_lte_rrc_srs_MaxUpPts = -1;          /* T_srs_MaxUpPts */
static int hf_lte_rrc_setup_133 = -1;             /* T_setup_118 */
static int hf_lte_rrc_srs_Bandwidth = -1;         /* T_srs_Bandwidth */
static int hf_lte_rrc_srs_HoppingBandwidth = -1;  /* T_srs_HoppingBandwidth */
static int hf_lte_rrc_freqDomainPosition = -1;    /* INTEGER_0_23 */
static int hf_lte_rrc_duration = -1;              /* T_duration */
static int hf_lte_rrc_srs_ConfigIndex = -1;       /* INTEGER_0_1023 */
static int hf_lte_rrc_transmissionComb = -1;      /* INTEGER_0_1 */
static int hf_lte_rrc_cyclicShift_01 = -1;        /* T_cyclicShift */
static int hf_lte_rrc_srs_AntennaPort_r10 = -1;   /* SRS_AntennaPort */
static int hf_lte_rrc_setup_134 = -1;             /* T_setup_119 */
static int hf_lte_rrc_transmissionComb_v1310 = -1;  /* INTEGER_2_3 */
static int hf_lte_rrc_cyclicShift_v1310 = -1;     /* T_cyclicShift_v1310 */
static int hf_lte_rrc_transmissionCombNum_r13 = -1;  /* T_transmissionCombNum_r13 */
static int hf_lte_rrc_setup_135 = -1;             /* T_setup_120 */
static int hf_lte_rrc_srs_UpPtsAdd_r13 = -1;      /* T_srs_UpPtsAdd_r13 */
static int hf_lte_rrc_srs_Bandwidth_r13 = -1;     /* T_srs_Bandwidth_r13 */
static int hf_lte_rrc_srs_HoppingBandwidth_r13 = -1;  /* T_srs_HoppingBandwidth_r13 */
static int hf_lte_rrc_freqDomainPosition_r13 = -1;  /* INTEGER_0_23 */
static int hf_lte_rrc_duration_r13 = -1;          /* BOOLEAN */
static int hf_lte_rrc_srs_ConfigIndex_r13 = -1;   /* INTEGER_0_1023 */
static int hf_lte_rrc_transmissionComb_r13 = -1;  /* INTEGER_0_3 */
static int hf_lte_rrc_cyclicShift_r13 = -1;       /* T_cyclicShift_r13 */
static int hf_lte_rrc_srs_AntennaPort_r13 = -1;   /* SRS_AntennaPort */
static int hf_lte_rrc_transmissionCombNum_r13_01 = -1;  /* T_transmissionCombNum_r13_01 */
static int hf_lte_rrc_setup_136 = -1;             /* T_setup_121 */
static int hf_lte_rrc_srs_ConfigIndexAp_r10 = -1;  /* INTEGER_0_31 */
static int hf_lte_rrc_srs_ConfigApDCI_Format4_r10 = -1;  /* SEQUENCE_SIZE_1_3_OF_SRS_ConfigAp_r10 */
static int hf_lte_rrc_srs_ConfigApDCI_Format4_r10_item = -1;  /* SRS_ConfigAp_r10 */
static int hf_lte_rrc_srs_ActivateAp_r10 = -1;    /* T_srs_ActivateAp_r10 */
static int hf_lte_rrc_setup_137 = -1;             /* T_setup_122 */
static int hf_lte_rrc_srs_ConfigApDCI_Format0_r10 = -1;  /* SRS_ConfigAp_r10 */
static int hf_lte_rrc_srs_ConfigApDCI_Format1a2b2c_r10 = -1;  /* SRS_ConfigAp_r10 */
static int hf_lte_rrc_setup_138 = -1;             /* T_setup_123 */
static int hf_lte_rrc_srs_ConfigApDCI_Format4_v1310 = -1;  /* SEQUENCE_SIZE_1_3_OF_SRS_ConfigAp_v1310 */
static int hf_lte_rrc_srs_ConfigApDCI_Format4_v1310_item = -1;  /* SRS_ConfigAp_v1310 */
static int hf_lte_rrc_srs_ActivateAp_v1310 = -1;  /* T_srs_ActivateAp_v1310 */
static int hf_lte_rrc_setup_139 = -1;             /* T_setup_124 */
static int hf_lte_rrc_srs_ConfigApDCI_Format0_v1310 = -1;  /* SRS_ConfigAp_v1310 */
static int hf_lte_rrc_srs_ConfigApDCI_Format1a2b2c_v1310 = -1;  /* SRS_ConfigAp_v1310 */
static int hf_lte_rrc_setup_140 = -1;             /* T_setup_125 */
static int hf_lte_rrc_srs_UpPtsAdd_r13_01 = -1;   /* T_srs_UpPtsAdd_r13_01 */
static int hf_lte_rrc_srs_ConfigIndexAp_r13 = -1;  /* INTEGER_0_31 */
static int hf_lte_rrc_srs_ConfigApDCI_Format4_r13 = -1;  /* SEQUENCE_SIZE_1_3_OF_SRS_ConfigAp_r13 */
static int hf_lte_rrc_srs_ConfigApDCI_Format4_r13_item = -1;  /* SRS_ConfigAp_r13 */
static int hf_lte_rrc_srs_ActivateAp_r13 = -1;    /* T_srs_ActivateAp_r13 */
static int hf_lte_rrc_setup_141 = -1;             /* T_setup_126 */
static int hf_lte_rrc_srs_ConfigApDCI_Format0_r13 = -1;  /* SRS_ConfigAp_r13 */
static int hf_lte_rrc_srs_ConfigApDCI_Format1a2b2c_r13 = -1;  /* SRS_ConfigAp_r13 */
static int hf_lte_rrc_setup_142 = -1;             /* T_setup_127 */
static int hf_lte_rrc_srs_SubframeIndication_r14 = -1;  /* INTEGER_1_4 */
static int hf_lte_rrc_srs_AntennaPortAp_r10 = -1;  /* SRS_AntennaPort */
static int hf_lte_rrc_srs_BandwidthAp_r10 = -1;   /* T_srs_BandwidthAp_r10 */
static int hf_lte_rrc_freqDomainPositionAp_r10 = -1;  /* INTEGER_0_23 */
static int hf_lte_rrc_transmissionCombAp_r10 = -1;  /* INTEGER_0_1 */
static int hf_lte_rrc_cyclicShiftAp_r10 = -1;     /* T_cyclicShiftAp_r10 */
static int hf_lte_rrc_transmissionCombAp_v1310 = -1;  /* INTEGER_2_3 */
static int hf_lte_rrc_cyclicShiftAp_v1310 = -1;   /* T_cyclicShiftAp_v1310 */
static int hf_lte_rrc_transmissionCombNum_r13_02 = -1;  /* T_transmissionCombNum_r13_02 */
static int hf_lte_rrc_srs_AntennaPortAp_r13 = -1;  /* SRS_AntennaPort */
static int hf_lte_rrc_srs_BandwidthAp_r13 = -1;   /* T_srs_BandwidthAp_r13 */
static int hf_lte_rrc_freqDomainPositionAp_r13 = -1;  /* INTEGER_0_23 */
static int hf_lte_rrc_transmissionCombAp_r13 = -1;  /* INTEGER_0_3 */
static int hf_lte_rrc_cyclicShiftAp_r13 = -1;     /* T_cyclicShiftAp_r13 */
static int hf_lte_rrc_transmissionCombNum_r13_03 = -1;  /* T_transmissionCombNum_r13_03 */
static int hf_lte_rrc_setup_143 = -1;             /* T_setup_128 */
static int hf_lte_rrc_spdcch_L1_ReuseIndication_r15 = -1;  /* T_spdcch_L1_ReuseIndication_r15 */
static int hf_lte_rrc_spdcch_SetConfig_r15 = -1;  /* SPDCCH_Set_r15 */
static int hf_lte_rrc_SPDCCH_Set_r15_item = -1;   /* SPDCCH_Elements_r15 */
static int hf_lte_rrc_setup_144 = -1;             /* T_setup_129 */
static int hf_lte_rrc_spdcch_SetConfigId_r15 = -1;  /* INTEGER_0_3 */
static int hf_lte_rrc_spdcch_SetReferenceSig_r15 = -1;  /* T_spdcch_SetReferenceSig_r15 */
static int hf_lte_rrc_transmissionType_r15 = -1;  /* T_transmissionType_r15 */
static int hf_lte_rrc_spdcch_NoOfSymbols_r15 = -1;  /* INTEGER_1_2 */
static int hf_lte_rrc_dmrs_ScramblingSequenceInt_r15 = -1;  /* INTEGER_0_503 */
static int hf_lte_rrc_dci7_CandidatesPerAL_PDCCH_r15 = -1;  /* SEQUENCE_SIZE_1_4_OF_DCI7_Candidates_r15 */
static int hf_lte_rrc_dci7_CandidatesPerAL_PDCCH_r15_item = -1;  /* DCI7_Candidates_r15 */
static int hf_lte_rrc_dci7_CandidateSetsPerAL_SPDCCH_r15 = -1;  /* SEQUENCE_SIZE_1_2_OF_DCI7_CandidatesPerAL_SPDCCH_r15 */
static int hf_lte_rrc_dci7_CandidateSetsPerAL_SPDCCH_r15_item = -1;  /* DCI7_CandidatesPerAL_SPDCCH_r15 */
static int hf_lte_rrc_resourceBlockAssignment_r15 = -1;  /* T_resourceBlockAssignment_r15 */
static int hf_lte_rrc_numberRB_InFreq_domain_r15 = -1;  /* INTEGER_2_100 */
static int hf_lte_rrc_resourceBlockAssignment_r15_01 = -1;  /* BIT_STRING_SIZE_98 */
static int hf_lte_rrc_subslotApplicability_r15 = -1;  /* BIT_STRING_SIZE_5 */
static int hf_lte_rrc_al_StartingPointSPDCCH_r15 = -1;  /* T_al_StartingPointSPDCCH_r15 */
static int hf_lte_rrc_al_StartingPointSPDCCH_r15_item = -1;  /* INTEGER_0_49 */
static int hf_lte_rrc_subframeType_r15 = -1;      /* T_subframeType_r15 */
static int hf_lte_rrc_rateMatchingMode_r15 = -1;  /* T_rateMatchingMode_r15 */
static int hf_lte_rrc_DCI7_CandidatesPerAL_SPDCCH_r15_item = -1;  /* DCI7_Candidates_r15 */
static int hf_lte_rrc_semiPersistSchedC_RNTI = -1;  /* C_RNTI */
static int hf_lte_rrc_sps_ConfigDL = -1;          /* SPS_ConfigDL */
static int hf_lte_rrc_sps_ConfigUL = -1;          /* SPS_ConfigUL */
static int hf_lte_rrc_ul_SPS_V_RNTI_r14 = -1;     /* C_RNTI */
static int hf_lte_rrc_sl_SPS_V_RNTI_r14 = -1;     /* C_RNTI */
static int hf_lte_rrc_sps_ConfigUL_ToAddModList_r14 = -1;  /* SPS_ConfigUL_ToAddModList_r14 */
static int hf_lte_rrc_sps_ConfigUL_ToReleaseList_r14 = -1;  /* SPS_ConfigUL_ToReleaseList_r14 */
static int hf_lte_rrc_sps_ConfigSL_ToAddModList_r14 = -1;  /* SPS_ConfigSL_ToAddModList_r14 */
static int hf_lte_rrc_sps_ConfigSL_ToReleaseList_r14 = -1;  /* SPS_ConfigSL_ToReleaseList_r14 */
static int hf_lte_rrc_SPS_ConfigUL_ToAddModList_r14_item = -1;  /* SPS_ConfigUL */
static int hf_lte_rrc_SPS_ConfigUL_ToReleaseList_r14_item = -1;  /* SPS_ConfigIndex_r14 */
static int hf_lte_rrc_SPS_ConfigSL_ToAddModList_r14_item = -1;  /* SPS_ConfigSL_r14 */
static int hf_lte_rrc_SPS_ConfigSL_ToReleaseList_r14_item = -1;  /* SPS_ConfigIndex_r14 */
static int hf_lte_rrc_semiPersistSchedC_RNTI_r15 = -1;  /* C_RNTI */
static int hf_lte_rrc_sps_ConfigDL_r15 = -1;      /* SPS_ConfigDL */
static int hf_lte_rrc_sps_ConfigUL_STTI_ToAddModList_r15 = -1;  /* SPS_ConfigUL_STTI_ToAddModList_r15 */
static int hf_lte_rrc_sps_ConfigUL_STTI_ToReleaseList_r15 = -1;  /* SPS_ConfigUL_STTI_ToReleaseList_r15 */
static int hf_lte_rrc_sps_ConfigUL_ToAddModList_r15 = -1;  /* SPS_ConfigUL_ToAddModList_r15 */
static int hf_lte_rrc_sps_ConfigUL_ToReleaseList_r15 = -1;  /* SPS_ConfigUL_ToReleaseList_r15 */
static int hf_lte_rrc_sps_ConfigDL_STTI_r15 = -1;  /* SPS_ConfigDL_STTI_r15 */
static int hf_lte_rrc_SPS_ConfigUL_STTI_ToAddModList_r15_item = -1;  /* SPS_ConfigUL_STTI_r15 */
static int hf_lte_rrc_SPS_ConfigUL_STTI_ToReleaseList_r15_item = -1;  /* SPS_ConfigIndex_r15 */
static int hf_lte_rrc_SPS_ConfigUL_ToAddModList_r15_item = -1;  /* SPS_ConfigUL */
static int hf_lte_rrc_SPS_ConfigUL_ToReleaseList_r15_item = -1;  /* SPS_ConfigIndex_r15 */
static int hf_lte_rrc_setup_145 = -1;             /* T_setup_130 */
static int hf_lte_rrc_semiPersistSchedIntervalDL = -1;  /* T_semiPersistSchedIntervalDL */
static int hf_lte_rrc_numberOfConfSPS_Processes = -1;  /* INTEGER_1_8 */
static int hf_lte_rrc_n1PUCCH_AN_PersistentList = -1;  /* N1PUCCH_AN_PersistentList */
static int hf_lte_rrc_twoAntennaPortActivated_r10 = -1;  /* T_twoAntennaPortActivated_r10 */
static int hf_lte_rrc_setup_146 = -1;             /* T_setup_131 */
static int hf_lte_rrc_n1PUCCH_AN_PersistentListP1_r10 = -1;  /* N1PUCCH_AN_PersistentList */
static int hf_lte_rrc_setup_147 = -1;             /* T_setup_132 */
static int hf_lte_rrc_semiPersistSchedIntervalUL = -1;  /* T_semiPersistSchedIntervalUL */
static int hf_lte_rrc_implicitReleaseAfter = -1;  /* T_implicitReleaseAfter */
static int hf_lte_rrc_p0_Persistent = -1;         /* T_p0_Persistent */
static int hf_lte_rrc_p0_NominalPUSCH_Persistent = -1;  /* INTEGER_M126_24 */
static int hf_lte_rrc_p0_UE_PUSCH_Persistent = -1;  /* INTEGER_M8_7 */
static int hf_lte_rrc_twoIntervalsConfig = -1;    /* T_twoIntervalsConfig */
static int hf_lte_rrc_p0_PersistentSubframeSet2_r12 = -1;  /* T_p0_PersistentSubframeSet2_r12 */
static int hf_lte_rrc_setup_148 = -1;             /* T_setup_133 */
static int hf_lte_rrc_p0_NominalPUSCH_PersistentSubframeSet2_r12 = -1;  /* INTEGER_M126_24 */
static int hf_lte_rrc_p0_UE_PUSCH_PersistentSubframeSet2_r12 = -1;  /* INTEGER_M8_7 */
static int hf_lte_rrc_numberOfConfUlSPS_Processes_r13 = -1;  /* INTEGER_1_8 */
static int hf_lte_rrc_fixedRV_NonAdaptive_r14 = -1;  /* T_fixedRV_NonAdaptive_r14 */
static int hf_lte_rrc_sps_ConfigIndex_r14 = -1;   /* SPS_ConfigIndex_r14 */
static int hf_lte_rrc_semiPersistSchedIntervalUL_v1430 = -1;  /* T_semiPersistSchedIntervalUL_v1430 */
static int hf_lte_rrc_cyclicShiftSPS_r15 = -1;    /* T_cyclicShiftSPS_r15 */
static int hf_lte_rrc_harq_ProcID_Offset_r15 = -1;  /* INTEGER_0_7 */
static int hf_lte_rrc_rv_SPS_UL_Repetitions_r15 = -1;  /* T_rv_SPS_UL_Repetitions_r15 */
static int hf_lte_rrc_tpc_PDCCH_ConfigPUSCH_SPS_r15 = -1;  /* TPC_PDCCH_Config */
static int hf_lte_rrc_totalNumberPUSCH_SPS_UL_Repetitions_r15 = -1;  /* T_totalNumberPUSCH_SPS_UL_Repetitions_r15 */
static int hf_lte_rrc_sps_ConfigIndex_r15 = -1;   /* SPS_ConfigIndex_r15 */
static int hf_lte_rrc_semiPersistSchedIntervalSL_r14 = -1;  /* T_semiPersistSchedIntervalSL_r14 */
static int hf_lte_rrc_N1PUCCH_AN_PersistentList_item = -1;  /* INTEGER_0_2047 */
static int hf_lte_rrc_N1SPUCCH_AN_PersistentList_r15_item = -1;  /* INTEGER_0_2047 */
static int hf_lte_rrc_setup_149 = -1;             /* T_setup_134 */
static int hf_lte_rrc_semiPersistSchedIntervalDL_STTI_r15 = -1;  /* T_semiPersistSchedIntervalDL_STTI_r15 */
static int hf_lte_rrc_numberOfConfSPS_Processes_STTI_r15 = -1;  /* INTEGER_1_12 */
static int hf_lte_rrc_twoAntennaPortActivated_r15 = -1;  /* T_twoAntennaPortActivated_r15 */
static int hf_lte_rrc_setup_150 = -1;             /* T_setup_135 */
static int hf_lte_rrc_n1SPUCCH_AN_PersistentListP1_r15 = -1;  /* N1SPUCCH_AN_PersistentList_r15 */
static int hf_lte_rrc_sTTI_StartTimeDL_r15 = -1;  /* INTEGER_0_5 */
static int hf_lte_rrc_tpc_PDCCH_ConfigPUCCH_SPS_r15 = -1;  /* TPC_PDCCH_Config */
static int hf_lte_rrc_setup_151 = -1;             /* T_setup_136 */
static int hf_lte_rrc_semiPersistSchedIntervalUL_STTI_r15 = -1;  /* T_semiPersistSchedIntervalUL_STTI_r15 */
static int hf_lte_rrc_implicitReleaseAfter_01 = -1;  /* T_implicitReleaseAfter_01 */
static int hf_lte_rrc_p0_Persistent_r15 = -1;     /* T_p0_Persistent_r15 */
static int hf_lte_rrc_p0_NominalSPUSCH_Persistent_r15 = -1;  /* INTEGER_M126_24 */
static int hf_lte_rrc_p0_UE_SPUSCH_Persistent_r15 = -1;  /* INTEGER_M8_7 */
static int hf_lte_rrc_twoIntervalsConfig_r15 = -1;  /* T_twoIntervalsConfig_r15 */
static int hf_lte_rrc_p0_PersistentSubframeSet2_r15 = -1;  /* T_p0_PersistentSubframeSet2_r15 */
static int hf_lte_rrc_setup_152 = -1;             /* T_setup_137 */
static int hf_lte_rrc_p0_NominalSPUSCH_PersistentSubframeSet2_r15 = -1;  /* INTEGER_M126_24 */
static int hf_lte_rrc_p0_UE_SPUSCH_PersistentSubframeSet2_r15 = -1;  /* INTEGER_M8_7 */
static int hf_lte_rrc_numberOfConfUL_SPS_Processes_STTI_r15 = -1;  /* INTEGER_1_12 */
static int hf_lte_rrc_sTTI_StartTimeUL_r15 = -1;  /* INTEGER_0_5 */
static int hf_lte_rrc_cyclicShiftSPS_sTTI_r15 = -1;  /* T_cyclicShiftSPS_sTTI_r15 */
static int hf_lte_rrc_ifdma_Config_SPS_r15 = -1;  /* BOOLEAN */
static int hf_lte_rrc_harq_ProcID_offset_r15 = -1;  /* INTEGER_0_15 */
static int hf_lte_rrc_rv_SPS_STTI_UL_Repetitions_r15 = -1;  /* T_rv_SPS_STTI_UL_Repetitions_r15 */
static int hf_lte_rrc_tbs_scalingFactorSubslotSPS_UL_Repetitions_r15 = -1;  /* T_tbs_scalingFactorSubslotSPS_UL_Repetitions_r15 */
static int hf_lte_rrc_totalNumberPUSCH_SPS_STTI_UL_Repetitions_r15 = -1;  /* T_totalNumberPUSCH_SPS_STTI_UL_Repetitions_r15 */
static int hf_lte_rrc_setup_153 = -1;             /* T_setup_138 */
static int hf_lte_rrc_spucch_Set_r15 = -1;        /* SPUCCH_Set_r15 */
static int hf_lte_rrc_twoAntennaPortActivatedSPUCCH_Format1a1b_r15 = -1;  /* T_twoAntennaPortActivatedSPUCCH_Format1a1b_r15 */
static int hf_lte_rrc_dummy_07 = -1;              /* T_dummy_04 */
static int hf_lte_rrc_n3SPUCCH_AN_List_r15 = -1;  /* T_n3SPUCCH_AN_List_r15 */
static int hf_lte_rrc_n3SPUCCH_AN_List_r15_item = -1;  /* INTEGER_0_549 */
static int hf_lte_rrc_setup_154 = -1;             /* T_setup_139 */
static int hf_lte_rrc_twoAntennaPortActivatedSPUCCH_Format3_v1550 = -1;  /* T_twoAntennaPortActivatedSPUCCH_Format3_v1550 */
static int hf_lte_rrc_n3SPUCCH_AN_List_v1550 = -1;  /* T_n3SPUCCH_AN_List_v1550 */
static int hf_lte_rrc_n3SPUCCH_AN_List_v1550_item = -1;  /* INTEGER_0_549 */
static int hf_lte_rrc_SPUCCH_Set_r15_item = -1;   /* SPUCCH_Elements_r15 */
static int hf_lte_rrc_setup_155 = -1;             /* T_setup_140 */
static int hf_lte_rrc_n1SubslotSPUCCH_AN_List_r15 = -1;  /* T_n1SubslotSPUCCH_AN_List_r15 */
static int hf_lte_rrc_n1SubslotSPUCCH_AN_List_r15_item = -1;  /* INTEGER_0_1319 */
static int hf_lte_rrc_n1SlotSPUCCH_FH_AN_List_r15 = -1;  /* INTEGER_0_1319 */
static int hf_lte_rrc_n1SlotSPUCCH_NoFH_AN_List_r15 = -1;  /* INTEGER_0_3959 */
static int hf_lte_rrc_n3SPUCCH_AN_List_r15_01 = -1;  /* INTEGER_0_549 */
static int hf_lte_rrc_n4SPUCCHSlot_Resource_r15 = -1;  /* SEQUENCE_SIZE_1_2_OF_N4SPUCCH_Resource_r15 */
static int hf_lte_rrc_n4SPUCCHSlot_Resource_r15_item = -1;  /* N4SPUCCH_Resource_r15 */
static int hf_lte_rrc_n4SPUCCHSubslot_Resource_r15 = -1;  /* SEQUENCE_SIZE_1_2_OF_N4SPUCCH_Resource_r15 */
static int hf_lte_rrc_n4SPUCCHSubslot_Resource_r15_item = -1;  /* N4SPUCCH_Resource_r15 */
static int hf_lte_rrc_n4maxCoderateSlotPUCCH_r15 = -1;  /* INTEGER_0_7 */
static int hf_lte_rrc_n4maxCoderateSubslotPUCCH_r15 = -1;  /* INTEGER_0_7 */
static int hf_lte_rrc_n4maxCoderateMultiResourceSlotPUCCH_r15 = -1;  /* INTEGER_0_7 */
static int hf_lte_rrc_n4maxCoderateMultiResourceSubslotPUCCH_r15 = -1;  /* INTEGER_0_7 */
static int hf_lte_rrc_n4startingPRB_r15 = -1;     /* INTEGER_0_109 */
static int hf_lte_rrc_n4numberOfPRB_r15 = -1;     /* INTEGER_0_7 */
static int hf_lte_rrc_setup_156 = -1;             /* T_setup_141 */
static int hf_lte_rrc_srs_TPC_RNTI_r14 = -1;      /* BIT_STRING_SIZE_16 */
static int hf_lte_rrc_startingBitOfFormat3B_r14 = -1;  /* INTEGER_0_31 */
static int hf_lte_rrc_fieldTypeFormat3B_r14 = -1;  /* INTEGER_1_4 */
static int hf_lte_rrc_srs_CC_SetIndexlist_r14 = -1;  /* SEQUENCE_SIZE_1_4_OF_SRS_CC_SetIndex_r14 */
static int hf_lte_rrc_srs_CC_SetIndexlist_r14_item = -1;  /* SRS_CC_SetIndex_r14 */
static int hf_lte_rrc_cc_SetIndex_r14 = -1;       /* INTEGER_0_3 */
static int hf_lte_rrc_cc_IndexInOneCC_Set_r14 = -1;  /* INTEGER_0_7 */
static int hf_lte_rrc_subframeAssignment = -1;    /* T_subframeAssignment */
static int hf_lte_rrc_specialSubframePatterns = -1;  /* T_specialSubframePatterns */
static int hf_lte_rrc_specialSubframePatterns_v1130 = -1;  /* T_specialSubframePatterns_v1130 */
static int hf_lte_rrc_specialSubframePatterns_v1430 = -1;  /* T_specialSubframePatterns_v1430 */
static int hf_lte_rrc_specialSubframePatterns_v1450 = -1;  /* T_specialSubframePatterns_v1450 */
static int hf_lte_rrc_subframeAssignmentSL_r12 = -1;  /* T_subframeAssignmentSL_r12 */
static int hf_lte_rrc_time_r15 = -1;              /* ReferenceTime_r15 */
static int hf_lte_rrc_uncertainty_r15 = -1;       /* INTEGER_0_12 */
static int hf_lte_rrc_timeInfoType_r15 = -1;      /* T_timeInfoType_r15 */
static int hf_lte_rrc_referenceSFN_r15 = -1;      /* INTEGER_0_1023 */
static int hf_lte_rrc_refDays_r15 = -1;           /* INTEGER_0_72999 */
static int hf_lte_rrc_refSeconds_r15 = -1;        /* INTEGER_0_86399 */
static int hf_lte_rrc_refMilliSeconds_r15 = -1;   /* INTEGER_0_999 */
static int hf_lte_rrc_refQuarterMicroSeconds_r15 = -1;  /* INTEGER_0_3999 */
static int hf_lte_rrc_setup_157 = -1;             /* T_setup_142 */
static int hf_lte_rrc_tpc_RNTI = -1;              /* BIT_STRING_SIZE_16 */
static int hf_lte_rrc_tpc_Index = -1;             /* TPC_Index */
static int hf_lte_rrc_setup_158 = -1;             /* T_setup_143 */
static int hf_lte_rrc_tpc_Index_PUCCH_SCell_r13 = -1;  /* TPC_Index */
static int hf_lte_rrc_indexOfFormat3 = -1;        /* INTEGER_1_15 */
static int hf_lte_rrc_indexOfFormat3A = -1;       /* INTEGER_1_31 */
static int hf_lte_rrc_ip_Address_r13 = -1;        /* IP_Address_r13 */
static int hf_lte_rrc_ike_Identity_r13 = -1;      /* IKE_Identity_r13 */
static int hf_lte_rrc_lwip_Counter_r13 = -1;      /* INTEGER_0_65535 */
static int hf_lte_rrc_idI_r13 = -1;               /* OCTET_STRING */
static int hf_lte_rrc_ipv4_r13 = -1;              /* T_ipv4_r13 */
static int hf_lte_rrc_ipv6_r13 = -1;              /* T_ipv6_r13 */
static int hf_lte_rrc_p0_NominalPUSCH = -1;       /* INTEGER_M126_24 */
static int hf_lte_rrc_alpha = -1;                 /* Alpha_r12 */
static int hf_lte_rrc_p0_NominalPUCCH = -1;       /* INTEGER_M127_M96 */
static int hf_lte_rrc_deltaFList_PUCCH = -1;      /* DeltaFList_PUCCH */
static int hf_lte_rrc_deltaPreambleMsg3 = -1;     /* INTEGER_M1_6 */
static int hf_lte_rrc_deltaF_PUCCH_Format3_r10 = -1;  /* T_deltaF_PUCCH_Format3_r10 */
static int hf_lte_rrc_deltaF_PUCCH_Format1bCS_r10 = -1;  /* T_deltaF_PUCCH_Format1bCS_r10 */
static int hf_lte_rrc_deltaF_PUCCH_Format4_r13 = -1;  /* T_deltaF_PUCCH_Format4_r13 */
static int hf_lte_rrc_deltaF_PUCCH_Format5_13 = -1;  /* T_deltaF_PUCCH_Format5_13 */
static int hf_lte_rrc_deltaFList_SPUCCH_r15 = -1;  /* DeltaFList_SPUCCH_r15 */
static int hf_lte_rrc_deltaF_PUCCH_Format3_r12 = -1;  /* T_deltaF_PUCCH_Format3_r12 */
static int hf_lte_rrc_deltaF_PUCCH_Format1bCS_r12 = -1;  /* T_deltaF_PUCCH_Format1bCS_r12 */
static int hf_lte_rrc_p0_NominalPUCCH_r12 = -1;   /* INTEGER_M127_M96 */
static int hf_lte_rrc_deltaFList_PUCCH_r12 = -1;  /* DeltaFList_PUCCH */
static int hf_lte_rrc_p0_NominalPUSCH_r10 = -1;   /* INTEGER_M126_24 */
static int hf_lte_rrc_alpha_r10 = -1;             /* Alpha_r12 */
static int hf_lte_rrc_deltaPreambleMsg3_r11 = -1;  /* INTEGER_M1_6 */
static int hf_lte_rrc_deltaF_PUCCH_Format3_r12_01 = -1;  /* T_deltaF_PUCCH_Format3_r12_01 */
static int hf_lte_rrc_deltaF_PUCCH_Format1bCS_r12_01 = -1;  /* T_deltaF_PUCCH_Format1bCS_r12_01 */
static int hf_lte_rrc_deltaF_PUCCH_Format4_r13_01 = -1;  /* T_deltaF_PUCCH_Format4_r13_01 */
static int hf_lte_rrc_deltaF_PUCCH_Format5_13_01 = -1;  /* T_deltaF_PUCCH_Format5_13_01 */
static int hf_lte_rrc_p0_Nominal_PeriodicSRS_r14 = -1;  /* INTEGER_M126_24 */
static int hf_lte_rrc_p0_Nominal_AperiodicSRS_r14 = -1;  /* INTEGER_M126_24 */
static int hf_lte_rrc_alpha_SRS_r14 = -1;         /* Alpha_r12 */
static int hf_lte_rrc_p0_UE_PUSCH = -1;           /* INTEGER_M8_7 */
static int hf_lte_rrc_deltaMCS_Enabled = -1;      /* T_deltaMCS_Enabled */
static int hf_lte_rrc_accumulationEnabled = -1;   /* BOOLEAN */
static int hf_lte_rrc_p0_UE_PUCCH = -1;           /* INTEGER_M8_7 */
static int hf_lte_rrc_pSRS_Offset = -1;           /* INTEGER_0_15 */
static int hf_lte_rrc_filterCoefficient = -1;     /* FilterCoefficient */
static int hf_lte_rrc_deltaTxD_OffsetListPUCCH_r10 = -1;  /* DeltaTxD_OffsetListPUCCH_r10 */
static int hf_lte_rrc_pSRS_OffsetAp_r10 = -1;     /* INTEGER_0_15 */
static int hf_lte_rrc_pSRS_Offset_v1130 = -1;     /* INTEGER_16_31 */
static int hf_lte_rrc_pSRS_OffsetAp_v1130 = -1;   /* INTEGER_16_31 */
static int hf_lte_rrc_deltaTxD_OffsetListPUCCH_v1130 = -1;  /* DeltaTxD_OffsetListPUCCH_v1130 */
static int hf_lte_rrc_set2PowerControlParameter = -1;  /* T_set2PowerControlParameter */
static int hf_lte_rrc_setup_159 = -1;             /* T_setup_144 */
static int hf_lte_rrc_tpc_SubframeSet_r12 = -1;   /* BIT_STRING_SIZE_10 */
static int hf_lte_rrc_p0_NominalPUSCH_SubframeSet2_r12 = -1;  /* INTEGER_M126_24 */
static int hf_lte_rrc_alpha_SubframeSet2_r12 = -1;  /* Alpha_r12 */
static int hf_lte_rrc_p0_UE_PUSCH_SubframeSet2_r12 = -1;  /* INTEGER_M8_7 */
static int hf_lte_rrc_alpha_UE_r15 = -1;          /* Alpha_r12 */
static int hf_lte_rrc_p0_UE_PUSCH_r15 = -1;       /* INTEGER_M16_15 */
static int hf_lte_rrc_accumulationEnabledSTTI_r15 = -1;  /* BOOLEAN */
static int hf_lte_rrc_deltaTxD_OffsetListSPUCCH_r15 = -1;  /* DeltaTxD_OffsetListSPUCCH_r15 */
static int hf_lte_rrc_uplinkPower_CSIPayload = -1;  /* BOOLEAN */
static int hf_lte_rrc_p0_UE_PeriodicSRS_r14 = -1;  /* INTEGER_M8_7 */
static int hf_lte_rrc_p0_UE_AperiodicSRS_r14 = -1;  /* INTEGER_M8_7 */
static int hf_lte_rrc_accumulationEnabled_r14 = -1;  /* BOOLEAN */
static int hf_lte_rrc_p0_UE_PUSCH_r10 = -1;       /* INTEGER_M8_7 */
static int hf_lte_rrc_deltaMCS_Enabled_r10 = -1;  /* T_deltaMCS_Enabled_r10 */
static int hf_lte_rrc_accumulationEnabled_r10 = -1;  /* BOOLEAN */
static int hf_lte_rrc_pSRS_Offset_r10 = -1;       /* INTEGER_0_15 */
static int hf_lte_rrc_filterCoefficient_r10 = -1;  /* FilterCoefficient */
static int hf_lte_rrc_pathlossReferenceLinking_r10 = -1;  /* T_pathlossReferenceLinking_r10 */
static int hf_lte_rrc_deltaF_PUCCH_Format1 = -1;  /* T_deltaF_PUCCH_Format1 */
static int hf_lte_rrc_deltaF_PUCCH_Format1b = -1;  /* T_deltaF_PUCCH_Format1b */
static int hf_lte_rrc_deltaF_PUCCH_Format2 = -1;  /* T_deltaF_PUCCH_Format2 */
static int hf_lte_rrc_deltaF_PUCCH_Format2a = -1;  /* T_deltaF_PUCCH_Format2a */
static int hf_lte_rrc_deltaF_PUCCH_Format2b = -1;  /* T_deltaF_PUCCH_Format2b */
static int hf_lte_rrc_setup_160 = -1;             /* T_setup_145 */
static int hf_lte_rrc_deltaF_slotSPUCCH_Format1_r15 = -1;  /* T_deltaF_slotSPUCCH_Format1_r15 */
static int hf_lte_rrc_deltaF_slotSPUCCH_Format1a_r15 = -1;  /* T_deltaF_slotSPUCCH_Format1a_r15 */
static int hf_lte_rrc_deltaF_slotSPUCCH_Format1b_r15 = -1;  /* T_deltaF_slotSPUCCH_Format1b_r15 */
static int hf_lte_rrc_deltaF_slotSPUCCH_Format3_r15 = -1;  /* T_deltaF_slotSPUCCH_Format3_r15 */
static int hf_lte_rrc_deltaF_slotSPUCCH_RM_Format4_r15 = -1;  /* T_deltaF_slotSPUCCH_RM_Format4_r15 */
static int hf_lte_rrc_deltaF_slotSPUCCH_TBCC_Format4_r15 = -1;  /* T_deltaF_slotSPUCCH_TBCC_Format4_r15 */
static int hf_lte_rrc_deltaF_subslotSPUCCH_Format1and1a_r15 = -1;  /* T_deltaF_subslotSPUCCH_Format1and1a_r15 */
static int hf_lte_rrc_deltaF_subslotSPUCCH_Format1b_r15 = -1;  /* T_deltaF_subslotSPUCCH_Format1b_r15 */
static int hf_lte_rrc_deltaF_subslotSPUCCH_RM_Format4_r15 = -1;  /* T_deltaF_subslotSPUCCH_RM_Format4_r15 */
static int hf_lte_rrc_deltaF_subslotSPUCCH_TBCC_Format4_r15 = -1;  /* T_deltaF_subslotSPUCCH_TBCC_Format4_r15 */
static int hf_lte_rrc_deltaTxD_OffsetPUCCH_Format1_r10 = -1;  /* T_deltaTxD_OffsetPUCCH_Format1_r10 */
static int hf_lte_rrc_deltaTxD_OffsetPUCCH_Format1a1b_r10 = -1;  /* T_deltaTxD_OffsetPUCCH_Format1a1b_r10 */
static int hf_lte_rrc_deltaTxD_OffsetPUCCH_Format22a2b_r10 = -1;  /* T_deltaTxD_OffsetPUCCH_Format22a2b_r10 */
static int hf_lte_rrc_deltaTxD_OffsetPUCCH_Format3_r10 = -1;  /* T_deltaTxD_OffsetPUCCH_Format3_r10 */
static int hf_lte_rrc_deltaTxD_OffsetPUCCH_Format1bCS_r11 = -1;  /* T_deltaTxD_OffsetPUCCH_Format1bCS_r11 */
static int hf_lte_rrc_deltaTxD_OffsetSPUCCH_Format1_r15 = -1;  /* T_deltaTxD_OffsetSPUCCH_Format1_r15 */
static int hf_lte_rrc_deltaTxD_OffsetSPUCCH_Format1a_r15 = -1;  /* T_deltaTxD_OffsetSPUCCH_Format1a_r15 */
static int hf_lte_rrc_deltaTxD_OffsetSPUCCH_Format1b_r15 = -1;  /* T_deltaTxD_OffsetSPUCCH_Format1b_r15 */
static int hf_lte_rrc_deltaTxD_OffsetSPUCCH_Format3_r15 = -1;  /* T_deltaTxD_OffsetSPUCCH_Format3_r15 */
static int hf_lte_rrc_WLAN_Id_List_r13_item = -1;  /* WLAN_Identifiers_r12 */
static int hf_lte_rrc_wlan_ToReleaseList_r13 = -1;  /* WLAN_Id_List_r13 */
static int hf_lte_rrc_wlan_ToAddList_r13 = -1;    /* WLAN_Id_List_r13 */
static int hf_lte_rrc_associationTimer_r13 = -1;  /* T_associationTimer_r13 */
static int hf_lte_rrc_successReportRequested_r13 = -1;  /* T_successReportRequested_r13 */
static int hf_lte_rrc_wlan_SuspendConfig_r14 = -1;  /* WLAN_SuspendConfig_r14 */
static int hf_lte_rrc_maxDurationFactor_r15 = -1;  /* T_maxDurationFactor_r15 */
static int hf_lte_rrc_numPOs_r15 = -1;            /* T_numPOs_r15 */
static int hf_lte_rrc_freqLocation_r15_01 = -1;   /* T_freqLocation_r15 */
static int hf_lte_rrc_timeOffsetDRX_r15 = -1;     /* T_timeOffsetDRX_r15 */
static int hf_lte_rrc_timeOffset_eDRX_Short_r15 = -1;  /* T_timeOffset_eDRX_Short_r15 */
static int hf_lte_rrc_timeOffset_eDRX_Long_r15 = -1;  /* T_timeOffset_eDRX_Long_r15 */
static int hf_lte_rrc_powerBoost_r15_01 = -1;     /* T_powerBoost_r15_01 */
static int hf_lte_rrc_cipheringAlgorithm = -1;    /* CipheringAlgorithm_r12 */
static int hf_lte_rrc_integrityProtAlgorithm = -1;  /* T_integrityProtAlgorithm */
static int hf_lte_rrc_arfcn_01 = -1;              /* ARFCN_ValueGERAN */
static int hf_lte_rrc_startingARFCN = -1;         /* ARFCN_ValueGERAN */
static int hf_lte_rrc_followingARFCNs = -1;       /* T_followingARFCNs */
static int hf_lte_rrc_explicitListOfARFCNs = -1;  /* ExplicitListOfARFCNs */
static int hf_lte_rrc_equallySpacedARFCNs = -1;   /* T_equallySpacedARFCNs */
static int hf_lte_rrc_arfcn_Spacing = -1;         /* INTEGER_1_8 */
static int hf_lte_rrc_numberOfFollowingARFCNs = -1;  /* INTEGER_0_31 */
static int hf_lte_rrc_variableBitMapOfARFCNs = -1;  /* OCTET_STRING_SIZE_1_16 */
static int hf_lte_rrc_ExplicitListOfARFCNs_item = -1;  /* ARFCN_ValueGERAN */
static int hf_lte_rrc_CarrierFreqListMBMS_r11_item = -1;  /* ARFCN_ValueEUTRA_r9 */
static int hf_lte_rrc_CellIndexList_item = -1;    /* CellIndex */
static int hf_lte_rrc_q_RxLevMinCE_r13 = -1;      /* Q_RxLevMin */
static int hf_lte_rrc_q_QualMinRSRQ_CE_r13 = -1;  /* Q_QualMin_r9 */
static int hf_lte_rrc_powerClass14dBm_Offset_r15 = -1;  /* T_powerClass14dBm_Offset_r15 */
static int hf_lte_rrc_q_RxLevMinCE1_r13 = -1;     /* Q_RxLevMin */
static int hf_lte_rrc_q_QualMinRSRQ_CE1_r13 = -1;  /* Q_QualMin_r9 */
static int hf_lte_rrc_delta_RxLevMinCE1_v1360 = -1;  /* INTEGER_M8_M1 */
static int hf_lte_rrc_sid = -1;                   /* BIT_STRING_SIZE_15 */
static int hf_lte_rrc_nid = -1;                   /* BIT_STRING_SIZE_16 */
static int hf_lte_rrc_multipleSID = -1;           /* BOOLEAN */
static int hf_lte_rrc_multipleNID = -1;           /* BOOLEAN */
static int hf_lte_rrc_homeReg = -1;               /* BOOLEAN */
static int hf_lte_rrc_foreignSIDReg = -1;         /* BOOLEAN */
static int hf_lte_rrc_foreignNIDReg = -1;         /* BOOLEAN */
static int hf_lte_rrc_parameterReg = -1;          /* BOOLEAN */
static int hf_lte_rrc_powerUpReg = -1;            /* BOOLEAN */
static int hf_lte_rrc_registrationPeriod = -1;    /* BIT_STRING_SIZE_7 */
static int hf_lte_rrc_registrationZone = -1;      /* BIT_STRING_SIZE_12 */
static int hf_lte_rrc_totalZone = -1;             /* BIT_STRING_SIZE_3 */
static int hf_lte_rrc_zoneTimer = -1;             /* BIT_STRING_SIZE_3 */
static int hf_lte_rrc_powerDownReg_r9 = -1;       /* T_powerDownReg_r9 */
static int hf_lte_rrc_cellIdentity_01 = -1;       /* BIT_STRING_SIZE_28 */
static int hf_lte_rrc_locationAreaCode = -1;      /* BIT_STRING_SIZE_16 */
static int hf_lte_rrc_cellIdentity_02 = -1;       /* BIT_STRING_SIZE_16 */
static int hf_lte_rrc_cellGlobalId1XRTT = -1;     /* BIT_STRING_SIZE_47 */
static int hf_lte_rrc_cellGlobalIdHRPD = -1;      /* BIT_STRING_SIZE_128 */
static int hf_lte_rrc_q_Hyst_r13 = -1;            /* T_q_Hyst_r13 */
static int hf_lte_rrc_q_RxLevMinReselection_r13 = -1;  /* Q_RxLevMin */
static int hf_lte_rrc_t_ReselectionEUTRA_r13 = -1;  /* T_Reselection */
static int hf_lte_rrc_targetPhysCellId = -1;      /* PhysCellId */
static int hf_lte_rrc_carrierFreq_03 = -1;        /* CarrierFreqEUTRA */
static int hf_lte_rrc_carrierBandwidth = -1;      /* CarrierBandwidthEUTRA */
static int hf_lte_rrc_t304_01 = -1;               /* T_t304_01 */
static int hf_lte_rrc_newUE_Identity = -1;        /* C_RNTI */
static int hf_lte_rrc_radioResourceConfigCommon_01 = -1;  /* RadioResourceConfigCommon */
static int hf_lte_rrc_rach_ConfigDedicated = -1;  /* RACH_ConfigDedicated */
static int hf_lte_rrc_carrierFreq_v9e0_01 = -1;   /* CarrierFreqEUTRA_v9e0 */
static int hf_lte_rrc_drb_ContinueROHC_r11 = -1;  /* T_drb_ContinueROHC_r11 */
static int hf_lte_rrc_mobilityControlInfoV2X_r14 = -1;  /* MobilityControlInfoV2X_r14 */
static int hf_lte_rrc_handoverWithoutWT_Change_r14 = -1;  /* T_handoverWithoutWT_Change_r14 */
static int hf_lte_rrc_makeBeforeBreak_r14 = -1;   /* T_makeBeforeBreak_r14 */
static int hf_lte_rrc_rach_Skip_r14 = -1;         /* RACH_Skip_r14 */
static int hf_lte_rrc_sameSFN_Indication_r14 = -1;  /* T_sameSFN_Indication_r14 */
static int hf_lte_rrc_mib_RepetitionStatus_r14 = -1;  /* BOOLEAN */
static int hf_lte_rrc_schedulingInfoSIB1_BR_r14 = -1;  /* INTEGER_0_31 */
static int hf_lte_rrc_t307_r12 = -1;              /* T_t307_r12 */
static int hf_lte_rrc_ue_IdentitySCG_r12 = -1;    /* C_RNTI */
static int hf_lte_rrc_rach_ConfigDedicated_r12 = -1;  /* RACH_ConfigDedicated */
static int hf_lte_rrc_cipheringAlgorithmSCG_r12 = -1;  /* CipheringAlgorithm_r12 */
static int hf_lte_rrc_makeBeforeBreakSCG_r14 = -1;  /* T_makeBeforeBreakSCG_r14 */
static int hf_lte_rrc_rach_SkipSCG_r14 = -1;      /* RACH_Skip_r14 */
static int hf_lte_rrc_v2x_CommSyncConfig_r14 = -1;  /* SL_SyncConfigListV2X_r14 */
static int hf_lte_rrc_cbr_MobilityTxConfigList_r14 = -1;  /* SL_CBR_CommonTxConfigList_r14 */
static int hf_lte_rrc_dl_Bandwidth_01 = -1;       /* T_dl_Bandwidth_01 */
static int hf_lte_rrc_ul_Bandwidth_01 = -1;       /* T_ul_Bandwidth_01 */
static int hf_lte_rrc_dl_CarrierFreq_v9e0_01 = -1;  /* ARFCN_ValueEUTRA_r9 */
static int hf_lte_rrc_ul_CarrierFreq_v9e0_01 = -1;  /* ARFCN_ValueEUTRA_r9 */
static int hf_lte_rrc_targetTA_r14 = -1;          /* T_targetTA_r14 */
static int hf_lte_rrc_ta0_r14 = -1;               /* NULL */
static int hf_lte_rrc_mcg_PTAG_r14 = -1;          /* NULL */
static int hf_lte_rrc_scg_PTAG_r14 = -1;          /* NULL */
static int hf_lte_rrc_mcg_STAG_r14 = -1;          /* STAG_Id_r11 */
static int hf_lte_rrc_scg_STAG_r14 = -1;          /* STAG_Id_r11 */
static int hf_lte_rrc_ul_ConfigInfo_r14 = -1;     /* T_ul_ConfigInfo_r14 */
static int hf_lte_rrc_numberOfConfUL_Processes_r14 = -1;  /* INTEGER_1_8 */
static int hf_lte_rrc_ul_SchedInterval_r14 = -1;  /* T_ul_SchedInterval_r14 */
static int hf_lte_rrc_ul_StartSubframe_r14 = -1;  /* INTEGER_0_9 */
static int hf_lte_rrc_ul_Grant_r14 = -1;          /* BIT_STRING_SIZE_16 */
static int hf_lte_rrc_t_Evaluation = -1;          /* T_t_Evaluation */
static int hf_lte_rrc_t_HystNormal = -1;          /* T_t_HystNormal */
static int hf_lte_rrc_n_CellChangeMedium = -1;    /* INTEGER_1_16 */
static int hf_lte_rrc_n_CellChangeHigh = -1;      /* INTEGER_1_16 */
static int hf_lte_rrc_MultiBandInfoList_item = -1;  /* FreqBandIndicator */
static int hf_lte_rrc_MultiBandInfoList_v9e0_item = -1;  /* MultiBandInfo_v9e0 */
static int hf_lte_rrc_MultiBandInfoList_v10j0_item = -1;  /* NS_PmaxList_r10 */
static int hf_lte_rrc_MultiBandInfoList_v10l0_item = -1;  /* NS_PmaxList_v10l0 */
static int hf_lte_rrc_MultiBandInfoList_r11_item = -1;  /* FreqBandIndicator_r11 */
static int hf_lte_rrc_MultiFrequencyBandListNR_r15_item = -1;  /* FreqBandIndicatorNR_r15 */
static int hf_lte_rrc_NS_PmaxList_r10_item = -1;  /* NS_PmaxValue_r10 */
static int hf_lte_rrc_NS_PmaxList_v10l0_item = -1;  /* NS_PmaxValue_v10l0 */
static int hf_lte_rrc_additionalPmax_r10 = -1;    /* P_Max */
static int hf_lte_rrc_NS_PmaxListNR_r15_item = -1;  /* NS_PmaxValueNR_r15 */
static int hf_lte_rrc_additionalPmaxNR_r15 = -1;  /* P_MaxNR_r15 */
static int hf_lte_rrc_additionalSpectrumEmissionNR_r15 = -1;  /* AdditionalSpectrumEmissionNR_r15 */
static int hf_lte_rrc_start_01 = -1;              /* PhysCellId */
static int hf_lte_rrc_range = -1;                 /* T_range */
static int hf_lte_rrc_PhysCellIdRangeUTRA_FDDList_r9_item = -1;  /* PhysCellIdRangeUTRA_FDD_r9 */
static int hf_lte_rrc_start_r9 = -1;              /* PhysCellIdUTRA_FDD */
static int hf_lte_rrc_range_r9 = -1;              /* INTEGER_2_512 */
static int hf_lte_rrc_networkColourCode = -1;     /* BIT_STRING_SIZE_3 */
static int hf_lte_rrc_baseStationColourCode = -1;  /* BIT_STRING_SIZE_3 */
static int hf_lte_rrc_mcc = -1;                   /* MCC */
static int hf_lte_rrc_mnc = -1;                   /* MNC */
static int hf_lte_rrc_MCC_item = -1;              /* MCC_MNC_Digit */
static int hf_lte_rrc_MNC_item = -1;              /* MCC_MNC_Digit */
static int hf_lte_rrc_PLMN_IdentityList3_r11_item = -1;  /* PLMN_Identity */
static int hf_lte_rrc_preRegistrationAllowed = -1;  /* BOOLEAN */
static int hf_lte_rrc_preRegistrationZoneId = -1;  /* PreRegistrationZoneIdHRPD */
static int hf_lte_rrc_secondaryPreRegistrationZoneIdList = -1;  /* SecondaryPreRegistrationZoneIdListHRPD */
static int hf_lte_rrc_SecondaryPreRegistrationZoneIdListHRPD_item = -1;  /* PreRegistrationZoneIdHRPD */
static int hf_lte_rrc_sf_Medium_01 = -1;          /* T_sf_Medium_01 */
static int hf_lte_rrc_sf_High_01 = -1;            /* T_sf_High_01 */
static int hf_lte_rrc_SystemInfoListGERAN_item = -1;  /* SystemInfoListGERAN_item */
static int hf_lte_rrc_cdma_EUTRA_Synchronisation = -1;  /* BOOLEAN */
static int hf_lte_rrc_cdma_SystemTime = -1;       /* T_cdma_SystemTime */
static int hf_lte_rrc_synchronousSystemTime = -1;  /* T_synchronousSystemTime */
static int hf_lte_rrc_asynchronousSystemTime = -1;  /* T_asynchronousSystemTime */
static int hf_lte_rrc_nr_RSRP_r15 = -1;           /* RSRP_RangeNR_r15 */
static int hf_lte_rrc_nr_RSRQ_r15 = -1;           /* RSRQ_RangeNR_r15 */
static int hf_lte_rrc_nr_SINR_r15 = -1;           /* RS_SINR_RangeNR_r15 */
static int hf_lte_rrc_setup_161 = -1;             /* BT_NameList_r15 */
static int hf_lte_rrc_BT_NameList_r15_item = -1;  /* BT_Name_r15 */
static int hf_lte_rrc_locationCoordinates_r10 = -1;  /* T_locationCoordinates_r10 */
static int hf_lte_rrc_ellipsoid_Point_r10 = -1;   /* T_ellipsoid_Point_r10 */
static int hf_lte_rrc_ellipsoidPointWithAltitude_r10 = -1;  /* T_ellipsoidPointWithAltitude_r10 */
static int hf_lte_rrc_ellipsoidPointWithUncertaintyCircle_r11 = -1;  /* T_ellipsoidPointWithUncertaintyCircle_r11 */
static int hf_lte_rrc_ellipsoidPointWithUncertaintyEllipse_r11 = -1;  /* T_ellipsoidPointWithUncertaintyEllipse_r11 */
static int hf_lte_rrc_ellipsoidPointWithAltitudeAndUncertaintyEllipsoid_r11 = -1;  /* T_ellipsoidPointWithAltitudeAndUncertaintyEllipsoid_r11 */
static int hf_lte_rrc_ellipsoidArc_r11 = -1;      /* T_ellipsoidArc_r11 */
static int hf_lte_rrc_polygon_r11 = -1;           /* T_polygon_r11 */
static int hf_lte_rrc_horizontalVelocity_r10 = -1;  /* T_horizontalVelocity_r10 */
static int hf_lte_rrc_gnss_TOD_msec_r10 = -1;     /* T_gnss_TOD_msec_r10 */
static int hf_lte_rrc_verticalVelocityInfo_r15 = -1;  /* T_verticalVelocityInfo_r15 */
static int hf_lte_rrc_verticalVelocity_r15 = -1;  /* T_verticalVelocity_r15 */
static int hf_lte_rrc_verticalVelocityAndUncertainty_r15 = -1;  /* T_verticalVelocityAndUncertainty_r15 */
static int hf_lte_rrc_LogMeasResultListBT_r15_item = -1;  /* LogMeasResultBT_r15 */
static int hf_lte_rrc_bt_Addr_r15 = -1;           /* T_bt_Addr_r15 */
static int hf_lte_rrc_rssi_BT_r15 = -1;           /* INTEGER_M128_127 */
static int hf_lte_rrc_LogMeasResultListWLAN_r15_item = -1;  /* LogMeasResultWLAN_r15 */
static int hf_lte_rrc_wlan_Identifiers_r15 = -1;  /* WLAN_Identifiers_r12 */
static int hf_lte_rrc_rssiWLAN_r15 = -1;          /* WLAN_RSSI_Range_r13 */
static int hf_lte_rrc_rtt_WLAN_r15 = -1;          /* WLAN_RTT_r15 */
static int hf_lte_rrc_measObjectToRemoveList = -1;  /* MeasObjectToRemoveList */
static int hf_lte_rrc_measObjectToAddModList = -1;  /* MeasObjectToAddModList */
static int hf_lte_rrc_reportConfigToRemoveList = -1;  /* ReportConfigToRemoveList */
static int hf_lte_rrc_reportConfigToAddModList = -1;  /* ReportConfigToAddModList */
static int hf_lte_rrc_measIdToRemoveList = -1;    /* MeasIdToRemoveList */
static int hf_lte_rrc_measIdToAddModList = -1;    /* MeasIdToAddModList */
static int hf_lte_rrc_quantityConfig = -1;        /* QuantityConfig */
static int hf_lte_rrc_measGapConfig = -1;         /* MeasGapConfig */
static int hf_lte_rrc_s_Measure = -1;             /* S_Measure */
static int hf_lte_rrc_speedStatePars = -1;        /* T_speedStatePars */
static int hf_lte_rrc_setup_162 = -1;             /* T_setup_146 */
static int hf_lte_rrc_timeToTrigger_SF = -1;      /* SpeedStateScaleFactors */
static int hf_lte_rrc_measObjectToAddModList_v9e0 = -1;  /* MeasObjectToAddModList_v9e0 */
static int hf_lte_rrc_allowInterruptions_r11 = -1;  /* BOOLEAN */
static int hf_lte_rrc_measScaleFactor_r12 = -1;   /* T_measScaleFactor_r12 */
static int hf_lte_rrc_setup_163 = -1;             /* MeasScaleFactor_r12 */
static int hf_lte_rrc_measIdToRemoveListExt_r12 = -1;  /* MeasIdToRemoveListExt_r12 */
static int hf_lte_rrc_measIdToAddModListExt_r12 = -1;  /* MeasIdToAddModListExt_r12 */
static int hf_lte_rrc_measRSRQ_OnAllSymbols_r12 = -1;  /* BOOLEAN */
static int hf_lte_rrc_measObjectToRemoveListExt_r13 = -1;  /* MeasObjectToRemoveListExt_r13 */
static int hf_lte_rrc_measObjectToAddModListExt_r13 = -1;  /* MeasObjectToAddModListExt_r13 */
static int hf_lte_rrc_measIdToAddModList_v1310 = -1;  /* MeasIdToAddModList_v1310 */
static int hf_lte_rrc_measIdToAddModListExt_v1310 = -1;  /* MeasIdToAddModListExt_v1310 */
static int hf_lte_rrc_measGapConfigPerCC_List_r14 = -1;  /* MeasGapConfigPerCC_List_r14 */
static int hf_lte_rrc_measGapSharingConfig_r14 = -1;  /* MeasGapSharingConfig_r14 */
static int hf_lte_rrc_fr1_Gap_r15 = -1;           /* BOOLEAN */
static int hf_lte_rrc_mgta_r15 = -1;              /* BOOLEAN */
static int hf_lte_rrc_measGapConfigDensePRS_r15 = -1;  /* MeasGapConfigDensePRS_r15 */
static int hf_lte_rrc_heightThreshRef_r15 = -1;   /* T_heightThreshRef_r15 */
static int hf_lte_rrc_setup_164 = -1;             /* INTEGER_0_31 */
static int hf_lte_rrc_MeasIdToRemoveList_item = -1;  /* MeasId */
static int hf_lte_rrc_MeasIdToRemoveListExt_r12_item = -1;  /* MeasId_v1250 */
static int hf_lte_rrc_MeasObjectToRemoveList_item = -1;  /* MeasObjectId */
static int hf_lte_rrc_MeasObjectToRemoveListExt_r13_item = -1;  /* MeasObjectId_v1310 */
static int hf_lte_rrc_ReportConfigToRemoveList_item = -1;  /* ReportConfigId */
static int hf_lte_rrc_setup_165 = -1;             /* T_setup_147 */
static int hf_lte_rrc_dmtc_PeriodOffset_r12 = -1;  /* T_dmtc_PeriodOffset_r12 */
static int hf_lte_rrc_ms40_r12 = -1;              /* INTEGER_0_39 */
static int hf_lte_rrc_ms80_r12 = -1;              /* INTEGER_0_79 */
static int hf_lte_rrc_ms160_r12 = -1;             /* INTEGER_0_159 */
static int hf_lte_rrc_ds_OccasionDuration_r12 = -1;  /* T_ds_OccasionDuration_r12 */
static int hf_lte_rrc_durationFDD_r12 = -1;       /* INTEGER_1_maxDS_Duration_r12 */
static int hf_lte_rrc_durationTDD_r12 = -1;       /* INTEGER_2_maxDS_Duration_r12 */
static int hf_lte_rrc_measCSI_RS_ToRemoveList_r12 = -1;  /* MeasCSI_RS_ToRemoveList_r12 */
static int hf_lte_rrc_measCSI_RS_ToAddModList_r12 = -1;  /* MeasCSI_RS_ToAddModList_r12 */
static int hf_lte_rrc_MeasCSI_RS_ToRemoveList_r12_item = -1;  /* MeasCSI_RS_Id_r12 */
static int hf_lte_rrc_MeasCSI_RS_ToAddModList_r12_item = -1;  /* MeasCSI_RS_Config_r12 */
static int hf_lte_rrc_measCSI_RS_Id_r12 = -1;     /* MeasCSI_RS_Id_r12 */
static int hf_lte_rrc_physCellId_r12_01 = -1;     /* INTEGER_0_503 */
static int hf_lte_rrc_scramblingIdentity_r12 = -1;  /* INTEGER_0_503 */
static int hf_lte_rrc_subframeOffset_r12 = -1;    /* INTEGER_0_4 */
static int hf_lte_rrc_csi_RS_IndividualOffset_r12 = -1;  /* Q_OffsetRange */
static int hf_lte_rrc_setup_166 = -1;             /* T_setup_148 */
static int hf_lte_rrc_gapOffset = -1;             /* T_gapOffset */
static int hf_lte_rrc_gp0 = -1;                   /* INTEGER_0_39 */
static int hf_lte_rrc_gp1 = -1;                   /* INTEGER_0_79 */
static int hf_lte_rrc_gp2_r14 = -1;               /* INTEGER_0_39 */
static int hf_lte_rrc_gp3_r14 = -1;               /* INTEGER_0_79 */
static int hf_lte_rrc_gp_ncsg0_r14 = -1;          /* INTEGER_0_39 */
static int hf_lte_rrc_gp_ncsg1_r14 = -1;          /* INTEGER_0_79 */
static int hf_lte_rrc_gp_ncsg2_r14 = -1;          /* INTEGER_0_39 */
static int hf_lte_rrc_gp_ncsg3_r14 = -1;          /* INTEGER_0_79 */
static int hf_lte_rrc_gp_nonUniform1_r14 = -1;    /* INTEGER_0_1279 */
static int hf_lte_rrc_gp_nonUniform2_r14 = -1;    /* INTEGER_0_2559 */
static int hf_lte_rrc_gp_nonUniform3_r14 = -1;    /* INTEGER_0_5119 */
static int hf_lte_rrc_gp_nonUniform4_r14 = -1;    /* INTEGER_0_10239 */
static int hf_lte_rrc_gp4_r15 = -1;               /* INTEGER_0_19 */
static int hf_lte_rrc_gp5_r15 = -1;               /* INTEGER_0_159 */
static int hf_lte_rrc_gp6_r15 = -1;               /* INTEGER_0_19 */
static int hf_lte_rrc_gp7_r15 = -1;               /* INTEGER_0_39 */
static int hf_lte_rrc_gp8_r15 = -1;               /* INTEGER_0_79 */
static int hf_lte_rrc_gp9_r15 = -1;               /* INTEGER_0_159 */
static int hf_lte_rrc_gp10_r15 = -1;              /* INTEGER_0_19 */
static int hf_lte_rrc_gp11_r15 = -1;              /* INTEGER_0_159 */
static int hf_lte_rrc_setup_167 = -1;             /* T_setup_149 */
static int hf_lte_rrc_gapOffsetDensePRS_r15 = -1;  /* T_gapOffsetDensePRS_r15 */
static int hf_lte_rrc_setup_168 = -1;             /* T_setup_150 */
static int hf_lte_rrc_measGapConfigToRemoveList_r14 = -1;  /* MeasGapConfigToRemoveList_r14 */
static int hf_lte_rrc_measGapConfigToAddModList_r14 = -1;  /* MeasGapConfigToAddModList_r14 */
static int hf_lte_rrc_MeasGapConfigToRemoveList_r14_item = -1;  /* ServCellIndex_r13 */
static int hf_lte_rrc_MeasGapConfigToAddModList_r14_item = -1;  /* MeasGapConfigPerCC_r14 */
static int hf_lte_rrc_measGapConfigCC_r14 = -1;   /* MeasGapConfig */
static int hf_lte_rrc_setup_169 = -1;             /* T_setup_151 */
static int hf_lte_rrc_measGapSharingScheme_r14 = -1;  /* T_measGapSharingScheme_r14 */
static int hf_lte_rrc_measIdleCarrierListEUTRA_r15 = -1;  /* EUTRA_CarrierList_r15 */
static int hf_lte_rrc_measIdleDuration_r15 = -1;  /* T_measIdleDuration_r15 */
static int hf_lte_rrc_EUTRA_CarrierList_r15_item = -1;  /* MeasIdleCarrierEUTRA_r15 */
static int hf_lte_rrc_carrierFreq_r15_01 = -1;    /* ARFCN_ValueEUTRA_r9 */
static int hf_lte_rrc_allowedMeasBandwidth_r15 = -1;  /* AllowedMeasBandwidth */
static int hf_lte_rrc_validityArea_r15 = -1;      /* CellList_r15 */
static int hf_lte_rrc_measCellList_r15 = -1;      /* CellList_r15 */
static int hf_lte_rrc_reportQuantities = -1;      /* T_reportQuantities */
static int hf_lte_rrc_qualityThreshold_r15 = -1;  /* T_qualityThreshold_r15 */
static int hf_lte_rrc_idleRSRP_Threshold_r15 = -1;  /* RSRP_Range */
static int hf_lte_rrc_idleRSRQ_Threshold_r15 = -1;  /* RSRQ_Range_r13 */
static int hf_lte_rrc_CellList_r15_item = -1;     /* PhysCellIdRange */
static int hf_lte_rrc_MeasIdToAddModList_item = -1;  /* MeasIdToAddMod */
static int hf_lte_rrc_MeasIdToAddModList_v1310_item = -1;  /* MeasIdToAddMod_v1310 */
static int hf_lte_rrc_MeasIdToAddModListExt_r12_item = -1;  /* MeasIdToAddModExt_r12 */
static int hf_lte_rrc_MeasIdToAddModListExt_v1310_item = -1;  /* MeasIdToAddMod_v1310 */
static int hf_lte_rrc_measId = -1;                /* MeasId */
static int hf_lte_rrc_measObjectId = -1;          /* MeasObjectId */
static int hf_lte_rrc_reportConfigId = -1;        /* ReportConfigId */
static int hf_lte_rrc_measId_v1250 = -1;          /* MeasId_v1250 */
static int hf_lte_rrc_measObjectId_r12 = -1;      /* MeasObjectId */
static int hf_lte_rrc_reportConfigId_r12 = -1;    /* ReportConfigId */
static int hf_lte_rrc_measObjectId_v1310 = -1;    /* MeasObjectId_v1310 */
static int hf_lte_rrc_carrierFreq_04 = -1;        /* CarrierFreqCDMA2000 */
static int hf_lte_rrc_offsetFreq = -1;            /* Q_OffsetRangeInterRAT */
static int hf_lte_rrc_cellsToRemoveList = -1;     /* CellIndexList */
static int hf_lte_rrc_cellsToAddModList = -1;     /* CellsToAddModListCDMA2000 */
static int hf_lte_rrc_cellForWhichToReportCGI = -1;  /* PhysCellIdCDMA2000 */
static int hf_lte_rrc_CellsToAddModListCDMA2000_item = -1;  /* CellsToAddModCDMA2000 */
static int hf_lte_rrc_cellIndex = -1;             /* INTEGER_1_maxCellMeas */
static int hf_lte_rrc_physCellId_02 = -1;         /* PhysCellIdCDMA2000 */
static int hf_lte_rrc_offsetFreq_01 = -1;         /* Q_OffsetRange */
static int hf_lte_rrc_cellsToAddModList_01 = -1;  /* CellsToAddModList */
static int hf_lte_rrc_blackCellsToRemoveList = -1;  /* CellIndexList */
static int hf_lte_rrc_blackCellsToAddModList = -1;  /* BlackCellsToAddModList */
static int hf_lte_rrc_cellForWhichToReportCGI_01 = -1;  /* PhysCellId */
static int hf_lte_rrc_measCycleSCell_r10 = -1;    /* MeasCycleSCell_r10 */
static int hf_lte_rrc_measSubframePatternConfigNeigh_r10 = -1;  /* MeasSubframePatternConfigNeigh_r10 */
static int hf_lte_rrc_widebandRSRQ_Meas_r11 = -1;  /* BOOLEAN */
static int hf_lte_rrc_altTTT_CellsToRemoveList_r12 = -1;  /* CellIndexList */
static int hf_lte_rrc_altTTT_CellsToAddModList_r12 = -1;  /* AltTTT_CellsToAddModList_r12 */
static int hf_lte_rrc_t312_r12 = -1;              /* T_t312_r12 */
static int hf_lte_rrc_setup_170 = -1;             /* T_setup_152 */
static int hf_lte_rrc_reducedMeasPerformance_r12_05 = -1;  /* BOOLEAN */
static int hf_lte_rrc_measDS_Config_r12 = -1;     /* MeasDS_Config_r12 */
static int hf_lte_rrc_whiteCellsToRemoveList_r13 = -1;  /* CellIndexList */
static int hf_lte_rrc_whiteCellsToAddModList_r13 = -1;  /* WhiteCellsToAddModList_r13 */
static int hf_lte_rrc_rmtc_Config_r13 = -1;       /* RMTC_Config_r13 */
static int hf_lte_rrc_carrierFreq_r13 = -1;       /* ARFCN_ValueEUTRA_v9e0 */
static int hf_lte_rrc_tx_ResourcePoolToRemoveList_r14 = -1;  /* Tx_ResourcePoolMeasList_r14 */
static int hf_lte_rrc_tx_ResourcePoolToAddList_r14 = -1;  /* Tx_ResourcePoolMeasList_r14 */
static int hf_lte_rrc_fembms_MixedCarrier_r14 = -1;  /* BOOLEAN */
static int hf_lte_rrc_measSensing_Config_r15 = -1;  /* MeasSensing_Config_r15 */
static int hf_lte_rrc_CellsToAddModList_item = -1;  /* CellsToAddMod */
static int hf_lte_rrc_cellIndividualOffset = -1;  /* Q_OffsetRange */
static int hf_lte_rrc_BlackCellsToAddModList_item = -1;  /* BlackCellsToAddMod */
static int hf_lte_rrc_physCellIdRange = -1;       /* PhysCellIdRange */
static int hf_lte_rrc_setup_171 = -1;             /* T_setup_153 */
static int hf_lte_rrc_measSubframePatternNeigh_r10 = -1;  /* MeasSubframePattern_r10 */
static int hf_lte_rrc_measSubframeCellList_r10 = -1;  /* MeasSubframeCellList_r10 */
static int hf_lte_rrc_MeasSubframeCellList_r10_item = -1;  /* PhysCellIdRange */
static int hf_lte_rrc_AltTTT_CellsToAddModList_r12_item = -1;  /* AltTTT_CellsToAddMod_r12 */
static int hf_lte_rrc_cellIndex_r12 = -1;         /* INTEGER_1_maxCellMeas */
static int hf_lte_rrc_physCellIdRange_r12 = -1;   /* PhysCellIdRange */
static int hf_lte_rrc_WhiteCellsToAddModList_r13_item = -1;  /* WhiteCellsToAddMod_r13 */
static int hf_lte_rrc_cellIndex_r13 = -1;         /* INTEGER_1_maxCellMeas */
static int hf_lte_rrc_physCellIdRange_r13 = -1;   /* PhysCellIdRange */
static int hf_lte_rrc_setup_172 = -1;             /* T_setup_154 */
static int hf_lte_rrc_rmtc_Period_r13 = -1;       /* T_rmtc_Period_r13 */
static int hf_lte_rrc_rmtc_SubframeOffset_r13 = -1;  /* INTEGER_0_639 */
static int hf_lte_rrc_measDuration_r13 = -1;      /* T_measDuration_r13 */
static int hf_lte_rrc_Tx_ResourcePoolMeasList_r14_item = -1;  /* SL_V2X_TxPoolReportIdentity_r14 */
static int hf_lte_rrc_cellForWhichToReportCGI_02 = -1;  /* PhysCellIdGERAN */
static int hf_lte_rrc_rs_ConfigSSB_r15 = -1;      /* RS_ConfigSSB_NR_r15 */
static int hf_lte_rrc_offsetFreq_r15 = -1;        /* Q_OffsetRangeInterRAT */
static int hf_lte_rrc_blackCellsToRemoveList_r15 = -1;  /* CellIndexList */
static int hf_lte_rrc_blackCellsToAddModList_r15 = -1;  /* CellsToAddModListNR_r15 */
static int hf_lte_rrc_quantityConfigSet_r15 = -1;  /* INTEGER_1_maxQuantSetsNR_r15 */
static int hf_lte_rrc_cellsForWhichToReportSFTD_r15 = -1;  /* SEQUENCE_SIZE_1_maxCellSFTD_OF_PhysCellIdNR_r15 */
static int hf_lte_rrc_cellsForWhichToReportSFTD_r15_item = -1;  /* PhysCellIdNR_r15 */
static int hf_lte_rrc_cellForWhichToReportCGI_r15 = -1;  /* PhysCellIdNR_r15 */
static int hf_lte_rrc_bandNR_r15 = -1;            /* T_bandNR_r15 */
static int hf_lte_rrc_setup_173 = -1;             /* FreqBandIndicatorNR_r15 */
static int hf_lte_rrc_subcarrierSpacingSSB_r15_02 = -1;  /* T_subcarrierSpacingSSB_r15_02 */
static int hf_lte_rrc_ssb_ToMeasure_r15_01 = -1;  /* T_ssb_ToMeasure_r15 */
static int hf_lte_rrc_setup_174 = -1;             /* SSB_ToMeasure_r15 */
static int hf_lte_rrc_CellsToAddModListNR_r15_item = -1;  /* CellsToAddModNR_r15 */
static int hf_lte_rrc_cellIndex_r15 = -1;         /* INTEGER_1_maxCellMeas */
static int hf_lte_rrc_physCellId_r15_01 = -1;     /* PhysCellIdNR_r15 */
static int hf_lte_rrc_MeasObjectToAddModList_item = -1;  /* MeasObjectToAddMod */
static int hf_lte_rrc_MeasObjectToAddModListExt_r13_item = -1;  /* MeasObjectToAddModExt_r13 */
static int hf_lte_rrc_MeasObjectToAddModList_v9e0_item = -1;  /* MeasObjectToAddMod_v9e0 */
static int hf_lte_rrc_measObject = -1;            /* T_measObject */
static int hf_lte_rrc_measObjectEUTRA = -1;       /* MeasObjectEUTRA */
static int hf_lte_rrc_measObjectUTRA = -1;        /* MeasObjectUTRA */
static int hf_lte_rrc_measObjectGERAN = -1;       /* MeasObjectGERAN */
static int hf_lte_rrc_measObjectCDMA2000 = -1;    /* MeasObjectCDMA2000 */
static int hf_lte_rrc_measObjectWLAN_r13 = -1;    /* MeasObjectWLAN_r13 */
static int hf_lte_rrc_measObjectNR_r15 = -1;      /* MeasObjectNR_r15 */
static int hf_lte_rrc_measObjectId_r13 = -1;      /* MeasObjectId_v1310 */
static int hf_lte_rrc_measObject_r13 = -1;        /* T_measObject_r13 */
static int hf_lte_rrc_measObjectEUTRA_r13 = -1;   /* MeasObjectEUTRA */
static int hf_lte_rrc_measObjectUTRA_r13 = -1;    /* MeasObjectUTRA */
static int hf_lte_rrc_measObjectGERAN_r13 = -1;   /* MeasObjectGERAN */
static int hf_lte_rrc_measObjectCDMA2000_r13 = -1;  /* MeasObjectCDMA2000 */
static int hf_lte_rrc_measObjectWLAN_v1320 = -1;  /* MeasObjectWLAN_r13 */
static int hf_lte_rrc_measObjectEUTRA_v9e0 = -1;  /* MeasObjectEUTRA_v9e0 */
static int hf_lte_rrc_cellsToAddModList_02 = -1;  /* T_cellsToAddModList */
static int hf_lte_rrc_cellsToAddModListUTRA_FDD = -1;  /* CellsToAddModListUTRA_FDD */
static int hf_lte_rrc_cellsToAddModListUTRA_TDD = -1;  /* CellsToAddModListUTRA_TDD */
static int hf_lte_rrc_cellForWhichToReportCGI_03 = -1;  /* T_cellForWhichToReportCGI */
static int hf_lte_rrc_utra_FDD_01 = -1;           /* PhysCellIdUTRA_FDD */
static int hf_lte_rrc_utra_TDD_01 = -1;           /* PhysCellIdUTRA_TDD */
static int hf_lte_rrc_csg_allowedReportingCells_v930 = -1;  /* CSG_AllowedReportingCells_r9 */
static int hf_lte_rrc_CellsToAddModListUTRA_FDD_item = -1;  /* CellsToAddModUTRA_FDD */
static int hf_lte_rrc_physCellId_03 = -1;         /* PhysCellIdUTRA_FDD */
static int hf_lte_rrc_CellsToAddModListUTRA_TDD_item = -1;  /* CellsToAddModUTRA_TDD */
static int hf_lte_rrc_physCellId_04 = -1;         /* PhysCellIdUTRA_TDD */
static int hf_lte_rrc_physCellIdRangeUTRA_FDDList_r9 = -1;  /* PhysCellIdRangeUTRA_FDDList_r9 */
static int hf_lte_rrc_carrierFreq_r13_01 = -1;    /* T_carrierFreq_r13 */
static int hf_lte_rrc_bandIndicatorListWLAN_r13 = -1;  /* SEQUENCE_SIZE_1_maxWLAN_Bands_r13_OF_WLAN_BandIndicator_r13 */
static int hf_lte_rrc_bandIndicatorListWLAN_r13_item = -1;  /* WLAN_BandIndicator_r13 */
static int hf_lte_rrc_carrierInfoListWLAN_r13 = -1;  /* SEQUENCE_SIZE_1_maxWLAN_CarrierInfo_r13_OF_WLAN_CarrierInfo_r13 */
static int hf_lte_rrc_carrierInfoListWLAN_r13_item = -1;  /* WLAN_CarrierInfo_r13 */
static int hf_lte_rrc_wlan_ToAddModList_r13 = -1;  /* WLAN_Id_List_r13 */
static int hf_lte_rrc_wlan_ToRemoveList_r13 = -1;  /* WLAN_Id_List_r13 */
static int hf_lte_rrc_measResultPCell = -1;       /* T_measResultPCell */
static int hf_lte_rrc_rsrpResult = -1;            /* RSRP_Range */
static int hf_lte_rrc_rsrqResult = -1;            /* RSRQ_Range */
static int hf_lte_rrc_measResultNeighCells = -1;  /* T_measResultNeighCells */
static int hf_lte_rrc_measResultListEUTRA = -1;   /* MeasResultListEUTRA */
static int hf_lte_rrc_measResultListUTRA = -1;    /* MeasResultListUTRA */
static int hf_lte_rrc_measResultListGERAN = -1;   /* MeasResultListGERAN */
static int hf_lte_rrc_measResultsCDMA2000 = -1;   /* MeasResultsCDMA2000 */
static int hf_lte_rrc_measResultNeighCellListNR_r15 = -1;  /* MeasResultCellListNR_r15 */
static int hf_lte_rrc_measResultForECID_r9 = -1;  /* MeasResultForECID_r9 */
static int hf_lte_rrc_measResultServFreqList_r10 = -1;  /* MeasResultServFreqList_r10 */
static int hf_lte_rrc_measResultPCell_v1250 = -1;  /* RSRQ_Range_v1250 */
static int hf_lte_rrc_measResultCSI_RS_List_r12 = -1;  /* MeasResultCSI_RS_List_r12 */
static int hf_lte_rrc_measResultPCell_v1310 = -1;  /* T_measResultPCell_v1310 */
static int hf_lte_rrc_ul_PDCP_DelayResultList_r13 = -1;  /* UL_PDCP_DelayResultList_r13 */
static int hf_lte_rrc_measResultListWLAN_r13 = -1;  /* MeasResultListWLAN_r13 */
static int hf_lte_rrc_measResultPCell_v1360 = -1;  /* RSRP_Range_v1360 */
static int hf_lte_rrc_measResultListCBR_r14 = -1;  /* MeasResultListCBR_r14 */
static int hf_lte_rrc_measResultListWLAN_r14 = -1;  /* MeasResultListWLAN_r14 */
static int hf_lte_rrc_measResultServFreqListNR_r15 = -1;  /* MeasResultServFreqListNR_r15 */
static int hf_lte_rrc_measResultCellListSFTD_r15 = -1;  /* MeasResultCellListSFTD_r15 */
static int hf_lte_rrc_measResultSensing_r15 = -1;  /* MeasResultSensing_r15 */
static int hf_lte_rrc_heightUE_r15 = -1;          /* INTEGER_M400_8880 */
static int hf_lte_rrc_MeasResultListEUTRA_item = -1;  /* MeasResultEUTRA */
static int hf_lte_rrc_cgi_Info = -1;              /* T_cgi_Info */
static int hf_lte_rrc_cellGlobalId = -1;          /* CellGlobalIdEUTRA */
static int hf_lte_rrc_plmn_IdentityList_01 = -1;  /* PLMN_IdentityList2 */
static int hf_lte_rrc_measResult = -1;            /* T_measResult */
static int hf_lte_rrc_additionalSI_Info_r9 = -1;  /* AdditionalSI_Info_r9 */
static int hf_lte_rrc_primaryPLMN_Suitable_r12 = -1;  /* T_primaryPLMN_Suitable_r12 */
static int hf_lte_rrc_measResult_v1250 = -1;      /* RSRQ_Range_v1250 */
static int hf_lte_rrc_cgi_Info_v1310 = -1;        /* T_cgi_Info_v1310 */
static int hf_lte_rrc_freqBandIndicator_r13 = -1;  /* FreqBandIndicator_r11 */
static int hf_lte_rrc_multiBandInfoList_r13 = -1;  /* MultiBandInfoList_r11 */
static int hf_lte_rrc_freqBandIndicatorPriority_r13 = -1;  /* T_freqBandIndicatorPriority_r13 */
static int hf_lte_rrc_measResult_v1360 = -1;      /* RSRP_Range_v1360 */
static int hf_lte_rrc_cgi_Info_5GC_r15 = -1;      /* SEQUENCE_SIZE_1_maxPLMN_r11_OF_CellAccessRelatedInfo_5GC_r15 */
static int hf_lte_rrc_cgi_Info_5GC_r15_item = -1;  /* CellAccessRelatedInfo_5GC_r15 */
static int hf_lte_rrc_MeasResultListIdle_r15_item = -1;  /* MeasResultIdle_r15 */
static int hf_lte_rrc_measResultServingCell_r15 = -1;  /* T_measResultServingCell_r15 */
static int hf_lte_rrc_rsrpResult_r15 = -1;        /* RSRP_Range */
static int hf_lte_rrc_rsrqResult_r15 = -1;        /* RSRQ_Range_r13 */
static int hf_lte_rrc_measResultNeighCells_r15 = -1;  /* T_measResultNeighCells_r15 */
static int hf_lte_rrc_measResultIdleListEUTRA_r15 = -1;  /* MeasResultIdleListEUTRA_r15 */
static int hf_lte_rrc_MeasResultIdleListEUTRA_r15_item = -1;  /* MeasResultIdleEUTRA_r15 */
static int hf_lte_rrc_measResult_r15 = -1;        /* T_measResult_r15 */
static int hf_lte_rrc_MeasResultServFreqListNR_r15_item = -1;  /* MeasResultServFreqNR_r15 */
static int hf_lte_rrc_measResultSCell_r15 = -1;   /* MeasResultCellNR_r15 */
static int hf_lte_rrc_measResultBestNeighCell_r15 = -1;  /* MeasResultCellNR_r15 */
static int hf_lte_rrc_MeasResultCellListNR_r15_item = -1;  /* MeasResultCellNR_r15 */
static int hf_lte_rrc_pci_r15 = -1;               /* PhysCellIdNR_r15 */
static int hf_lte_rrc_measResultCell_r15 = -1;    /* MeasResultNR_r15 */
static int hf_lte_rrc_measResultRS_IndexList_r15 = -1;  /* MeasResultSSB_IndexList_r15 */
static int hf_lte_rrc_cgi_Info_r15 = -1;          /* CGI_InfoNR_r15 */
static int hf_lte_rrc_rsrpResult_r15_01 = -1;     /* RSRP_RangeNR_r15 */
static int hf_lte_rrc_rsrqResult_r15_01 = -1;     /* RSRQ_RangeNR_r15 */
static int hf_lte_rrc_rs_sinr_Result_r15 = -1;    /* RS_SINR_RangeNR_r15 */
static int hf_lte_rrc_MeasResultSSB_IndexList_r15_item = -1;  /* MeasResultSSB_Index_r15 */
static int hf_lte_rrc_ssb_Index_r15 = -1;         /* RS_IndexNR_r15 */
static int hf_lte_rrc_measResultSSB_Index_r15 = -1;  /* MeasResultNR_r15 */
static int hf_lte_rrc_MeasResultServFreqList_r10_item = -1;  /* MeasResultServFreq_r10 */
static int hf_lte_rrc_MeasResultServFreqListExt_r13_item = -1;  /* MeasResultServFreq_r13 */
static int hf_lte_rrc_servFreqId_r10 = -1;        /* ServCellIndex_r10 */
static int hf_lte_rrc_measResultSCell_r10 = -1;   /* T_measResultSCell_r10 */
static int hf_lte_rrc_rsrpResultSCell_r10 = -1;   /* RSRP_Range */
static int hf_lte_rrc_rsrqResultSCell_r10 = -1;   /* RSRQ_Range */
static int hf_lte_rrc_measResultBestNeighCell_r10 = -1;  /* T_measResultBestNeighCell_r10 */
static int hf_lte_rrc_rsrpResultNCell_r10 = -1;   /* RSRP_Range */
static int hf_lte_rrc_rsrqResultNCell_r10 = -1;   /* RSRQ_Range */
static int hf_lte_rrc_measResultSCell_v1250 = -1;  /* RSRQ_Range_v1250 */
static int hf_lte_rrc_measResultBestNeighCell_v1250 = -1;  /* RSRQ_Range_v1250 */
static int hf_lte_rrc_measResultSCell_v1310_01 = -1;  /* T_measResultSCell_v1310_01 */
static int hf_lte_rrc_measResultBestNeighCell_v1310 = -1;  /* T_measResultBestNeighCell_v1310 */
static int hf_lte_rrc_servFreqId_r13 = -1;        /* ServCellIndex_r13 */
static int hf_lte_rrc_measResultSCell_r13 = -1;   /* T_measResultSCell_r13 */
static int hf_lte_rrc_rsrpResultSCell_r13 = -1;   /* RSRP_Range */
static int hf_lte_rrc_rsrqResultSCell_r13 = -1;   /* RSRQ_Range_r13 */
static int hf_lte_rrc_measResultBestNeighCell_r13 = -1;  /* T_measResultBestNeighCell_r13 */
static int hf_lte_rrc_rsrpResultNCell_r13 = -1;   /* RSRP_Range */
static int hf_lte_rrc_rsrqResultNCell_r13 = -1;   /* RSRQ_Range_r13 */
static int hf_lte_rrc_measResultBestNeighCell_v1360 = -1;  /* T_measResultBestNeighCell_v1360 */
static int hf_lte_rrc_rsrpResultNCell_v1360 = -1;  /* RSRP_Range_v1360 */
static int hf_lte_rrc_MeasResultCSI_RS_List_r12_item = -1;  /* MeasResultCSI_RS_r12 */
static int hf_lte_rrc_csi_RSRP_Result_r12 = -1;   /* CSI_RSRP_Range_r12 */
static int hf_lte_rrc_MeasResultListUTRA_item = -1;  /* MeasResultUTRA */
static int hf_lte_rrc_physCellId_05 = -1;         /* T_physCellId */
static int hf_lte_rrc_fdd_01 = -1;                /* PhysCellIdUTRA_FDD */
static int hf_lte_rrc_tdd_01 = -1;                /* PhysCellIdUTRA_TDD */
static int hf_lte_rrc_cgi_Info_01 = -1;           /* T_cgi_Info_01 */
static int hf_lte_rrc_cellGlobalId_01 = -1;       /* CellGlobalIdUTRA */
static int hf_lte_rrc_routingAreaCode = -1;       /* BIT_STRING_SIZE_8 */
static int hf_lte_rrc_measResult_01 = -1;         /* T_measResult_01 */
static int hf_lte_rrc_utra_RSCP = -1;             /* INTEGER_M5_91 */
static int hf_lte_rrc_utra_EcN0 = -1;             /* INTEGER_0_49 */
static int hf_lte_rrc_primaryPLMN_Suitable_r12_01 = -1;  /* T_primaryPLMN_Suitable_r12_01 */
static int hf_lte_rrc_MeasResultListGERAN_item = -1;  /* MeasResultGERAN */
static int hf_lte_rrc_cgi_Info_02 = -1;           /* T_cgi_Info_02 */
static int hf_lte_rrc_cellGlobalId_02 = -1;       /* CellGlobalIdGERAN */
static int hf_lte_rrc_measResult_02 = -1;         /* T_measResult_02 */
static int hf_lte_rrc_rssi = -1;                  /* INTEGER_0_63 */
static int hf_lte_rrc_preRegistrationStatusHRPD = -1;  /* BOOLEAN */
static int hf_lte_rrc_measResultListCDMA2000 = -1;  /* MeasResultListCDMA2000 */
static int hf_lte_rrc_MeasResultListCDMA2000_item = -1;  /* MeasResultCDMA2000 */
static int hf_lte_rrc_cgi_Info_03 = -1;           /* CellGlobalIdCDMA2000 */
static int hf_lte_rrc_measResult_03 = -1;         /* T_measResult_03 */
static int hf_lte_rrc_pilotPnPhase = -1;          /* INTEGER_0_32767 */
static int hf_lte_rrc_pilotStrength = -1;         /* INTEGER_0_63 */
static int hf_lte_rrc_MeasResultListWLAN_r13_item = -1;  /* MeasResultWLAN_r13 */
static int hf_lte_rrc_MeasResultListWLAN_r14_item = -1;  /* MeasResultWLAN_r13 */
static int hf_lte_rrc_wlan_Identifiers_r13 = -1;  /* WLAN_Identifiers_r12 */
static int hf_lte_rrc_carrierInfoWLAN_r13 = -1;   /* WLAN_CarrierInfo_r13 */
static int hf_lte_rrc_bandWLAN_r13 = -1;          /* WLAN_BandIndicator_r13 */
static int hf_lte_rrc_rssiWLAN_r13 = -1;          /* WLAN_RSSI_Range_r13 */
static int hf_lte_rrc_availableAdmissionCapacityWLAN_r13 = -1;  /* INTEGER_0_31250 */
static int hf_lte_rrc_backhaulDL_BandwidthWLAN_r13 = -1;  /* WLAN_backhaulRate_r12 */
static int hf_lte_rrc_backhaulUL_BandwidthWLAN_r13 = -1;  /* WLAN_backhaulRate_r12 */
static int hf_lte_rrc_channelUtilizationWLAN_r13 = -1;  /* INTEGER_0_255 */
static int hf_lte_rrc_stationCountWLAN_r13 = -1;  /* INTEGER_0_65535 */
static int hf_lte_rrc_connectedWLAN_r13 = -1;     /* T_connectedWLAN_r13 */
static int hf_lte_rrc_MeasResultListCBR_r14_item = -1;  /* MeasResultCBR_r14 */
static int hf_lte_rrc_poolIdentity_r14 = -1;      /* SL_V2X_TxPoolReportIdentity_r14 */
static int hf_lte_rrc_cbr_PSSCH_r14 = -1;         /* SL_CBR_r14 */
static int hf_lte_rrc_cbr_PSCCH_r14 = -1;         /* SL_CBR_r14 */
static int hf_lte_rrc_sl_SubframeRef_r15 = -1;    /* INTEGER_0_10239 */
static int hf_lte_rrc_sensingResult_r15 = -1;     /* SEQUENCE_SIZE_0_400_OF_SensingResult_r15 */
static int hf_lte_rrc_sensingResult_r15_item = -1;  /* SensingResult_r15 */
static int hf_lte_rrc_resourceIndex_r15 = -1;     /* INTEGER_1_2000 */
static int hf_lte_rrc_ue_RxTxTimeDiffResult_r9 = -1;  /* INTEGER_0_4095 */
static int hf_lte_rrc_currentSFN_r9 = -1;         /* BIT_STRING_SIZE_10 */
static int hf_lte_rrc_PLMN_IdentityList2_item = -1;  /* PLMN_Identity */
static int hf_lte_rrc_csg_MemberStatus_r9 = -1;   /* T_csg_MemberStatus_r9 */
static int hf_lte_rrc_csg_Identity_r9 = -1;       /* CSG_Identity */
static int hf_lte_rrc_rssi_Result_r13 = -1;       /* RSSI_Range_r13 */
static int hf_lte_rrc_channelOccupancy_r13 = -1;  /* INTEGER_0_100 */
static int hf_lte_rrc_UL_PDCP_DelayResultList_r13_item = -1;  /* UL_PDCP_DelayResult_r13 */
static int hf_lte_rrc_qci_Id_r13 = -1;            /* T_qci_Id_r13 */
static int hf_lte_rrc_excessDelay_r13 = -1;       /* INTEGER_0_31 */
static int hf_lte_rrc_plmn_IdentityInfoList_r15 = -1;  /* PLMN_IdentityInfoListNR_r15 */
static int hf_lte_rrc_frequencyBandList_15 = -1;  /* MultiFrequencyBandListNR_r15 */
static int hf_lte_rrc_noSIB1_r15 = -1;            /* T_noSIB1_r15 */
static int hf_lte_rrc_ssb_SubcarrierOffset_r15 = -1;  /* INTEGER_0_15 */
static int hf_lte_rrc_pdcch_ConfigSIB1_r15 = -1;  /* INTEGER_0_255 */
static int hf_lte_rrc_PLMN_IdentityListNR_r15_item = -1;  /* PLMN_Identity */
static int hf_lte_rrc_PLMN_IdentityInfoListNR_r15_item = -1;  /* PLMN_IdentityInfoNR_r15 */
static int hf_lte_rrc_plmn_IdentityList_r15_01 = -1;  /* PLMN_IdentityListNR_r15 */
static int hf_lte_rrc_trackingAreaCode_r15 = -1;  /* TrackingAreaCodeNR_r15 */
static int hf_lte_rrc_cellIdentity_r15_01 = -1;   /* CellIdentityNR_r15 */
static int hf_lte_rrc_MeasResultCellListSFTD_r15_item = -1;  /* MeasResultCellSFTD_r15 */
static int hf_lte_rrc_sfn_OffsetResult_r15 = -1;  /* INTEGER_0_1023 */
static int hf_lte_rrc_frameBoundaryOffsetResult_r15 = -1;  /* INTEGER_M30720_30719 */
static int hf_lte_rrc_measResultFreqListEUTRA_r15 = -1;  /* MeasResultList3EUTRA_r15 */
static int hf_lte_rrc_MeasResultList3EUTRA_r15_item = -1;  /* MeasResult3EUTRA_r15 */
static int hf_lte_rrc_measResultServingCell_r15_01 = -1;  /* MeasResultEUTRA */
static int hf_lte_rrc_measResultNeighCellList_r15 = -1;  /* MeasResultListEUTRA */
static int hf_lte_rrc_sfn_OffsetResult_r13 = -1;  /* INTEGER_0_1023 */
static int hf_lte_rrc_frameBoundaryOffsetResult_r13 = -1;  /* INTEGER_M5_4 */
static int hf_lte_rrc_subframeBoundaryOffsetResult_r13 = -1;  /* INTEGER_0_127 */
static int hf_lte_rrc_sensingSubchannelNumber_r15 = -1;  /* INTEGER_1_20 */
static int hf_lte_rrc_sensingPeriodicity_r15 = -1;  /* T_sensingPeriodicity_r15 */
static int hf_lte_rrc_sensingReselectionCounter_r15 = -1;  /* INTEGER_5_75 */
static int hf_lte_rrc_sensingPriority_r15 = -1;   /* INTEGER_1_8 */
static int hf_lte_rrc_periodicityAndOffset_r15 = -1;  /* T_periodicityAndOffset_r15 */
static int hf_lte_rrc_sf5_r15 = -1;               /* INTEGER_0_4 */
static int hf_lte_rrc_sf10_r15 = -1;              /* INTEGER_0_9 */
static int hf_lte_rrc_sf20_r15 = -1;              /* INTEGER_0_19 */
static int hf_lte_rrc_sf40_r15 = -1;              /* INTEGER_0_39 */
static int hf_lte_rrc_sf80_r15 = -1;              /* INTEGER_0_79 */
static int hf_lte_rrc_sf160_r15 = -1;             /* INTEGER_0_159 */
static int hf_lte_rrc_ssb_Duration_r15 = -1;      /* T_ssb_Duration_r15 */
static int hf_lte_rrc_quantityConfigEUTRA = -1;   /* QuantityConfigEUTRA */
static int hf_lte_rrc_quantityConfigUTRA = -1;    /* QuantityConfigUTRA */
static int hf_lte_rrc_quantityConfigGERAN = -1;   /* QuantityConfigGERAN */
static int hf_lte_rrc_quantityConfigCDMA2000 = -1;  /* QuantityConfigCDMA2000 */
static int hf_lte_rrc_quantityConfigUTRA_v1020 = -1;  /* QuantityConfigUTRA_v1020 */
static int hf_lte_rrc_quantityConfigEUTRA_v1250 = -1;  /* QuantityConfigEUTRA_v1250 */
static int hf_lte_rrc_quantityConfigEUTRA_v1310 = -1;  /* QuantityConfigEUTRA_v1310 */
static int hf_lte_rrc_quantityConfigWLAN_r13 = -1;  /* QuantityConfigWLAN_r13 */
static int hf_lte_rrc_quantityConfigNRList_r15 = -1;  /* QuantityConfigNRList_r15 */
static int hf_lte_rrc_filterCoefficientRSRP = -1;  /* FilterCoefficient */
static int hf_lte_rrc_filterCoefficientRSRQ = -1;  /* FilterCoefficient */
static int hf_lte_rrc_filterCoefficientCSI_RSRP_r12 = -1;  /* FilterCoefficient */
static int hf_lte_rrc_filterCoefficientRS_SINR_r13 = -1;  /* FilterCoefficient */
static int hf_lte_rrc_measQuantityUTRA_FDD = -1;  /* T_measQuantityUTRA_FDD */
static int hf_lte_rrc_measQuantityUTRA_TDD = -1;  /* T_measQuantityUTRA_TDD */
static int hf_lte_rrc_filterCoefficient2_FDD_r10 = -1;  /* FilterCoefficient */
static int hf_lte_rrc_measQuantityGERAN = -1;     /* T_measQuantityGERAN */
static int hf_lte_rrc_measQuantityCDMA2000 = -1;  /* T_measQuantityCDMA2000 */
static int hf_lte_rrc_QuantityConfigNRList_r15_item = -1;  /* QuantityConfigNR_r15 */
static int hf_lte_rrc_measQuantityCellNR_r15 = -1;  /* QuantityConfigRS_NR_r15 */
static int hf_lte_rrc_measQuantityRS_IndexNR_r15 = -1;  /* QuantityConfigRS_NR_r15 */
static int hf_lte_rrc_filterCoeff_RSRP_r15 = -1;  /* FilterCoefficient */
static int hf_lte_rrc_filterCoeff_RSRQ_r15 = -1;  /* FilterCoefficient */
static int hf_lte_rrc_filterCoefficient_SINR_r13 = -1;  /* FilterCoefficient */
static int hf_lte_rrc_measQuantityWLAN_r13 = -1;  /* T_measQuantityWLAN_r13 */
static int hf_lte_rrc_triggerType = -1;           /* T_triggerType */
static int hf_lte_rrc_event = -1;                 /* T_event */
static int hf_lte_rrc_eventId = -1;               /* T_eventId */
static int hf_lte_rrc_eventA1 = -1;               /* T_eventA1 */
static int hf_lte_rrc_a1_Threshold = -1;          /* ThresholdEUTRA */
static int hf_lte_rrc_eventA2 = -1;               /* T_eventA2 */
static int hf_lte_rrc_a2_Threshold = -1;          /* ThresholdEUTRA */
static int hf_lte_rrc_eventA3 = -1;               /* T_eventA3 */
static int hf_lte_rrc_a3_Offset = -1;             /* INTEGER_M30_30 */
static int hf_lte_rrc_reportOnLeave = -1;         /* BOOLEAN */
static int hf_lte_rrc_eventA4 = -1;               /* T_eventA4 */
static int hf_lte_rrc_a4_Threshold = -1;          /* ThresholdEUTRA */
static int hf_lte_rrc_eventA5 = -1;               /* T_eventA5 */
static int hf_lte_rrc_a5_Threshold1 = -1;         /* ThresholdEUTRA */
static int hf_lte_rrc_a5_Threshold2 = -1;         /* ThresholdEUTRA */
static int hf_lte_rrc_eventA6_r10 = -1;           /* T_eventA6_r10 */
static int hf_lte_rrc_a6_Offset_r10 = -1;         /* INTEGER_M30_30 */
static int hf_lte_rrc_a6_ReportOnLeave_r10 = -1;  /* BOOLEAN */
static int hf_lte_rrc_eventC1_r12 = -1;           /* T_eventC1_r12 */
static int hf_lte_rrc_c1_Threshold_r12 = -1;      /* ThresholdEUTRA_v1250 */
static int hf_lte_rrc_c1_ReportOnLeave_r12 = -1;  /* BOOLEAN */
static int hf_lte_rrc_eventC2_r12 = -1;           /* T_eventC2_r12 */
static int hf_lte_rrc_c2_RefCSI_RS_r12 = -1;      /* MeasCSI_RS_Id_r12 */
static int hf_lte_rrc_c2_Offset_r12 = -1;         /* INTEGER_M30_30 */
static int hf_lte_rrc_c2_ReportOnLeave_r12 = -1;  /* BOOLEAN */
static int hf_lte_rrc_eventV1_r14 = -1;           /* T_eventV1_r14 */
static int hf_lte_rrc_v1_Threshold_r14 = -1;      /* SL_CBR_r14 */
static int hf_lte_rrc_eventV2_r14 = -1;           /* T_eventV2_r14 */
static int hf_lte_rrc_v2_Threshold_r14 = -1;      /* SL_CBR_r14 */
static int hf_lte_rrc_eventH1_r15 = -1;           /* T_eventH1_r15 */
static int hf_lte_rrc_h1_ThresholdOffset_r15 = -1;  /* INTEGER_0_300 */
static int hf_lte_rrc_h1_Hysteresis_15 = -1;      /* INTEGER_1_16 */
static int hf_lte_rrc_eventH2_r15 = -1;           /* T_eventH2_r15 */
static int hf_lte_rrc_h2_ThresholdOffset_r15 = -1;  /* INTEGER_0_300 */
static int hf_lte_rrc_h2_Hysteresis_15 = -1;      /* INTEGER_1_16 */
static int hf_lte_rrc_hysteresis = -1;            /* Hysteresis */
static int hf_lte_rrc_timeToTrigger = -1;         /* TimeToTrigger */
static int hf_lte_rrc_periodical = -1;            /* T_periodical */
static int hf_lte_rrc_purpose_02 = -1;            /* T_purpose_02 */
static int hf_lte_rrc_triggerQuantity = -1;       /* T_triggerQuantity */
static int hf_lte_rrc_reportQuantity = -1;        /* T_reportQuantity */
static int hf_lte_rrc_maxReportCells = -1;        /* INTEGER_1_maxCellReport */
static int hf_lte_rrc_reportInterval = -1;        /* ReportInterval */
static int hf_lte_rrc_reportAmount = -1;          /* T_reportAmount */
static int hf_lte_rrc_si_RequestForHO_r9 = -1;    /* T_si_RequestForHO_r9 */
static int hf_lte_rrc_ue_RxTxTimeDiffPeriodical_r9 = -1;  /* T_ue_RxTxTimeDiffPeriodical_r9 */
static int hf_lte_rrc_includeLocationInfo_r10 = -1;  /* T_includeLocationInfo_r10 */
static int hf_lte_rrc_reportAddNeighMeas_r10 = -1;  /* T_reportAddNeighMeas_r10 */
static int hf_lte_rrc_alternativeTimeToTrigger_r12 = -1;  /* T_alternativeTimeToTrigger_r12 */
static int hf_lte_rrc_setup_175 = -1;             /* TimeToTrigger */
static int hf_lte_rrc_useT312_r12 = -1;           /* BOOLEAN */
static int hf_lte_rrc_usePSCell_r12 = -1;         /* BOOLEAN */
static int hf_lte_rrc_aN_Threshold1_v1250 = -1;   /* RSRQ_RangeConfig_r12 */
static int hf_lte_rrc_a5_Threshold2_v1250 = -1;   /* RSRQ_RangeConfig_r12 */
static int hf_lte_rrc_reportStrongestCSI_RSs_r12 = -1;  /* BOOLEAN */
static int hf_lte_rrc_reportCRS_Meas_r12 = -1;    /* BOOLEAN */
static int hf_lte_rrc_triggerQuantityCSI_RS_r12 = -1;  /* BOOLEAN */
static int hf_lte_rrc_reportSSTD_Meas_r13 = -1;   /* BOOLEAN */
static int hf_lte_rrc_rs_sinr_Config_r13 = -1;    /* T_rs_sinr_Config_r13 */
static int hf_lte_rrc_setup_176 = -1;             /* T_setup_155 */
static int hf_lte_rrc_triggerQuantity_v1310 = -1;  /* T_triggerQuantity_v1310 */
static int hf_lte_rrc_aN_Threshold1_r13 = -1;     /* RS_SINR_Range_r13 */
static int hf_lte_rrc_a5_Threshold2_r13 = -1;     /* RS_SINR_Range_r13 */
static int hf_lte_rrc_reportQuantity_v1310 = -1;  /* T_reportQuantity_v1310 */
static int hf_lte_rrc_useWhiteCellList_r13 = -1;  /* BOOLEAN */
static int hf_lte_rrc_measRSSI_ReportConfig_r13 = -1;  /* MeasRSSI_ReportConfig_r13 */
static int hf_lte_rrc_includeMultiBandInfo_r13 = -1;  /* T_includeMultiBandInfo_r13 */
static int hf_lte_rrc_ul_DelayConfig_r13 = -1;    /* UL_DelayConfig_r13 */
static int hf_lte_rrc_ue_RxTxTimeDiffPeriodicalTDD_r13 = -1;  /* BOOLEAN */
static int hf_lte_rrc_purpose_v1430 = -1;         /* T_purpose_v1430 */
static int hf_lte_rrc_maxReportRS_Index_r15 = -1;  /* INTEGER_0_maxRS_IndexReport_r15 */
static int hf_lte_rrc_includeBT_Meas_r15 = -1;    /* BT_NameListConfig_r15 */
static int hf_lte_rrc_includeWLAN_Meas_r15 = -1;  /* WLAN_NameListConfig_r15 */
static int hf_lte_rrc_purpose_r15 = -1;           /* T_purpose_r15 */
static int hf_lte_rrc_numberOfTriggeringCells_r15 = -1;  /* INTEGER_2_maxCellReport */
static int hf_lte_rrc_a4_a5_ReportOnLeave_r15 = -1;  /* BOOLEAN */
static int hf_lte_rrc_setup_177 = -1;             /* RSRQ_Range_v1250 */
static int hf_lte_rrc_threshold_RSRP = -1;        /* Threshold_RSRP_Range */
static int hf_lte_rrc_threshold_RSRQ = -1;        /* Threshold_RSRQ_Range */
static int hf_lte_rrc_channelOccupancyThreshold_r13 = -1;  /* RSSI_Range_r13 */
static int hf_lte_rrc_triggerType_01 = -1;        /* T_triggerType_01 */
static int hf_lte_rrc_event_01 = -1;              /* T_event_01 */
static int hf_lte_rrc_eventId_01 = -1;            /* T_eventId_01 */
static int hf_lte_rrc_eventB1 = -1;               /* T_eventB1 */
static int hf_lte_rrc_b1_Threshold = -1;          /* T_b1_Threshold */
static int hf_lte_rrc_b1_ThresholdUTRA = -1;      /* ThresholdUTRA */
static int hf_lte_rrc_b1_ThresholdGERAN = -1;     /* ThresholdGERAN */
static int hf_lte_rrc_b1_ThresholdCDMA2000 = -1;  /* ThresholdCDMA2000 */
static int hf_lte_rrc_eventB2 = -1;               /* T_eventB2 */
static int hf_lte_rrc_b2_Threshold1 = -1;         /* ThresholdEUTRA */
static int hf_lte_rrc_b2_Threshold2 = -1;         /* T_b2_Threshold2 */
static int hf_lte_rrc_b2_Threshold2UTRA = -1;     /* ThresholdUTRA */
static int hf_lte_rrc_b2_Threshold2GERAN = -1;    /* ThresholdGERAN */
static int hf_lte_rrc_b2_Threshold2CDMA2000 = -1;  /* ThresholdCDMA2000 */
static int hf_lte_rrc_eventW1_r13 = -1;           /* T_eventW1_r13 */
static int hf_lte_rrc_w1_Threshold_r13 = -1;      /* WLAN_RSSI_Range_r13 */
static int hf_lte_rrc_eventW2_r13 = -1;           /* T_eventW2_r13 */
static int hf_lte_rrc_w2_Threshold1_r13 = -1;     /* WLAN_RSSI_Range_r13 */
static int hf_lte_rrc_w2_Threshold2_r13 = -1;     /* WLAN_RSSI_Range_r13 */
static int hf_lte_rrc_eventW3_r13 = -1;           /* T_eventW3_r13 */
static int hf_lte_rrc_w3_Threshold_r13 = -1;      /* WLAN_RSSI_Range_r13 */
static int hf_lte_rrc_eventB1_NR_r15 = -1;        /* T_eventB1_NR_r15 */
static int hf_lte_rrc_b1_ThresholdNR_r15 = -1;    /* ThresholdNR_r15 */
static int hf_lte_rrc_reportOnLeave_r15 = -1;     /* BOOLEAN */
static int hf_lte_rrc_eventB2_NR_r15 = -1;        /* T_eventB2_NR_r15 */
static int hf_lte_rrc_b2_Threshold1_r15 = -1;     /* ThresholdEUTRA */
static int hf_lte_rrc_b2_Threshold2NR_r15 = -1;   /* ThresholdNR_r15 */
static int hf_lte_rrc_periodical_01 = -1;         /* T_periodical_01 */
static int hf_lte_rrc_purpose_03 = -1;            /* T_purpose_03 */
static int hf_lte_rrc_reportAmount_01 = -1;       /* T_reportAmount_01 */
static int hf_lte_rrc_si_RequestForHO_r9_01 = -1;  /* T_si_RequestForHO_r9_01 */
static int hf_lte_rrc_reportQuantityUTRA_FDD_r10 = -1;  /* T_reportQuantityUTRA_FDD_r10 */
static int hf_lte_rrc_includeLocationInfo_r11 = -1;  /* BOOLEAN */
static int hf_lte_rrc_b2_Threshold1_v1250 = -1;   /* T_b2_Threshold1_v1250 */
static int hf_lte_rrc_reportQuantityWLAN_r13 = -1;  /* ReportQuantityWLAN_r13 */
static int hf_lte_rrc_reportAnyWLAN_r14 = -1;     /* BOOLEAN */
static int hf_lte_rrc_reportQuantityCellNR_r15 = -1;  /* ReportQuantityNR_r15 */
static int hf_lte_rrc_reportQuantityRS_IndexNR_r15 = -1;  /* ReportQuantityNR_r15 */
static int hf_lte_rrc_reportRS_IndexResultsNR = -1;  /* BOOLEAN */
static int hf_lte_rrc_reportSFTD_Meas_r15 = -1;   /* T_reportSFTD_Meas_r15 */
static int hf_lte_rrc_utra_RSCP_01 = -1;          /* Threshold_utra_RSRP */
static int hf_lte_rrc_utra_EcN0_01 = -1;          /* Threshold_utra_EcN0 */
static int hf_lte_rrc_ss_rsrp = -1;               /* BOOLEAN */
static int hf_lte_rrc_ss_rsrq = -1;               /* BOOLEAN */
static int hf_lte_rrc_ss_sinr = -1;               /* BOOLEAN */
static int hf_lte_rrc_bandRequestWLAN_r13 = -1;   /* T_bandRequestWLAN_r13 */
static int hf_lte_rrc_carrierInfoRequestWLAN_r13 = -1;  /* T_carrierInfoRequestWLAN_r13 */
static int hf_lte_rrc_availableAdmissionCapacityRequestWLAN_r13 = -1;  /* T_availableAdmissionCapacityRequestWLAN_r13 */
static int hf_lte_rrc_backhaulDL_BandwidthRequestWLAN_r13 = -1;  /* T_backhaulDL_BandwidthRequestWLAN_r13 */
static int hf_lte_rrc_backhaulUL_BandwidthRequestWLAN_r13 = -1;  /* T_backhaulUL_BandwidthRequestWLAN_r13 */
static int hf_lte_rrc_channelUtilizationRequestWLAN_r13 = -1;  /* T_channelUtilizationRequestWLAN_r13 */
static int hf_lte_rrc_stationCountRequestWLAN_r13 = -1;  /* T_stationCountRequestWLAN_r13 */
static int hf_lte_rrc_ReportConfigToAddModList_item = -1;  /* ReportConfigToAddMod */
static int hf_lte_rrc_reportConfig = -1;          /* T_reportConfig */
static int hf_lte_rrc_reportConfigEUTRA = -1;     /* ReportConfigEUTRA */
static int hf_lte_rrc_reportConfigInterRAT = -1;  /* ReportConfigInterRAT */
static int hf_lte_rrc_allSymbols_r12 = -1;        /* BOOLEAN */
static int hf_lte_rrc_wideBand_r12 = -1;          /* BOOLEAN */
static int hf_lte_rrc_measurementSlots_r15 = -1;  /* BIT_STRING_SIZE_1_80 */
static int hf_lte_rrc_endSymbol_r15 = -1;         /* INTEGER_0_3 */
static int hf_lte_rrc_shortBitmap_r15 = -1;       /* BIT_STRING_SIZE_4 */
static int hf_lte_rrc_mediumBitmap_r15 = -1;      /* BIT_STRING_SIZE_8 */
static int hf_lte_rrc_longBitmap_r15 = -1;        /* BIT_STRING_SIZE_64 */
static int hf_lte_rrc_setup_178 = -1;             /* T_setup_156 */
static int hf_lte_rrc_delayThreshold_r13 = -1;    /* T_delayThreshold_r13 */
static int hf_lte_rrc_operatingClass_r13 = -1;    /* INTEGER_0_255 */
static int hf_lte_rrc_countryCode_r13 = -1;       /* T_countryCode_r13 */
static int hf_lte_rrc_channelNumbers_r13 = -1;    /* WLAN_ChannelList_r13 */
static int hf_lte_rrc_WLAN_ChannelList_r13_item = -1;  /* WLAN_Channel_r13 */
static int hf_lte_rrc_setup_179 = -1;             /* WLAN_NameList_r15 */
static int hf_lte_rrc_WLAN_NameList_r15_item = -1;  /* WLAN_Name_r15 */
static int hf_lte_rrc_rttValue_r15 = -1;          /* INTEGER_0_16777215 */
static int hf_lte_rrc_rttUnits_r15 = -1;          /* T_rttUnits_r15 */
static int hf_lte_rrc_rttAccuracy_r15 = -1;       /* INTEGER_0_255 */
static int hf_lte_rrc_wlan_SuspendResumeAllowed_r14 = -1;  /* BOOLEAN */
static int hf_lte_rrc_wlan_SuspendTriggersStatusReport_r14 = -1;  /* BOOLEAN */
static int hf_lte_rrc_cellGlobalIdList_r10 = -1;  /* CellGlobalIdList_r10 */
static int hf_lte_rrc_trackingAreaCodeList_r10 = -1;  /* TrackingAreaCodeList_r10 */
static int hf_lte_rrc_trackingAreaCodeList_v1130 = -1;  /* TrackingAreaCodeList_v1130 */
static int hf_lte_rrc_CellGlobalIdList_r10_item = -1;  /* CellGlobalIdEUTRA */
static int hf_lte_rrc_TrackingAreaCodeList_r10_item = -1;  /* TrackingAreaCode */
static int hf_lte_rrc_plmn_Identity_perTAC_List_r11 = -1;  /* SEQUENCE_SIZE_1_8_OF_PLMN_Identity */
static int hf_lte_rrc_plmn_Identity_perTAC_List_r11_item = -1;  /* PLMN_Identity */
static int hf_lte_rrc_BandCombinationList_r14_item = -1;  /* BandCombination_r14 */
static int hf_lte_rrc_BandCombination_r14_item = -1;  /* BandIndication_r14 */
static int hf_lte_rrc_bandEUTRA_r14 = -1;         /* FreqBandIndicator_r11 */
static int hf_lte_rrc_ca_BandwidthClassDL_r14 = -1;  /* CA_BandwidthClass_r10 */
static int hf_lte_rrc_ca_BandwidthClassUL_r14 = -1;  /* CA_BandwidthClass_r10 */
static int hf_lte_rrc_maxWayPointNumber_r15 = -1;  /* INTEGER_1_maxWayPoint_r15 */
static int hf_lte_rrc_includeTimeStamp_r15 = -1;  /* T_includeTimeStamp_r15 */
static int hf_lte_rrc_gnss_id_r15_01 = -1;        /* T_gnss_id_r15 */
static int hf_lte_rrc_subframePatternFDD_r10 = -1;  /* BIT_STRING_SIZE_40 */
static int hf_lte_rrc_subframePatternTDD_r10 = -1;  /* T_subframePatternTDD_r10 */
static int hf_lte_rrc_subframeConfig1_5_r10 = -1;  /* BIT_STRING_SIZE_20 */
static int hf_lte_rrc_subframeConfig0_r10 = -1;   /* BIT_STRING_SIZE_70 */
static int hf_lte_rrc_subframeConfig6_r10 = -1;   /* BIT_STRING_SIZE_60 */
static int hf_lte_rrc_reportProximityConfig_r9 = -1;  /* ReportProximityConfig_r9 */
static int hf_lte_rrc_idc_Config_r11 = -1;        /* IDC_Config_r11 */
static int hf_lte_rrc_powerPrefIndicationConfig_r11 = -1;  /* PowerPrefIndicationConfig_r11 */
static int hf_lte_rrc_obtainLocationConfig_r11 = -1;  /* ObtainLocationConfig_r11 */
static int hf_lte_rrc_bw_PreferenceIndicationTimer_r14 = -1;  /* T_bw_PreferenceIndicationTimer_r14 */
static int hf_lte_rrc_sps_AssistanceInfoReport_r14 = -1;  /* BOOLEAN */
static int hf_lte_rrc_delayBudgetReportingConfig_r14 = -1;  /* T_delayBudgetReportingConfig_r14 */
static int hf_lte_rrc_setup_180 = -1;             /* T_setup_157 */
static int hf_lte_rrc_delayBudgetReportingProhibitTimer_r14 = -1;  /* T_delayBudgetReportingProhibitTimer_r14 */
static int hf_lte_rrc_rlm_ReportConfig_r14 = -1;  /* T_rlm_ReportConfig_r14 */
static int hf_lte_rrc_setup_181 = -1;             /* T_setup_158 */
static int hf_lte_rrc_rlmReportTimer_r14 = -1;    /* T_rlmReportTimer_r14 */
static int hf_lte_rrc_rlmReportRep_MPDCCH_r14 = -1;  /* T_rlmReportRep_MPDCCH_r14 */
static int hf_lte_rrc_overheatingAssistanceConfig_r14 = -1;  /* T_overheatingAssistanceConfig_r14 */
static int hf_lte_rrc_setup_182 = -1;             /* T_setup_159 */
static int hf_lte_rrc_overheatingIndicationProhibitTimer_r14 = -1;  /* T_overheatingIndicationProhibitTimer_r14 */
static int hf_lte_rrc_measConfigAppLayer_r15 = -1;  /* T_measConfigAppLayer_r15 */
static int hf_lte_rrc_setup_183 = -1;             /* T_setup_160 */
static int hf_lte_rrc_measConfigAppLayerContainer_r15 = -1;  /* OCTET_STRING_SIZE_1_1000 */
static int hf_lte_rrc_serviceType_01 = -1;        /* T_serviceType_01 */
static int hf_lte_rrc_ailc_BitConfig_r15 = -1;    /* BOOLEAN */
static int hf_lte_rrc_bt_NameListConfig_r15 = -1;  /* BT_NameListConfig_r15 */
static int hf_lte_rrc_wlan_NameListConfig_r15 = -1;  /* WLAN_NameListConfig_r15 */
static int hf_lte_rrc_idc_Indication_r11_01 = -1;  /* T_idc_Indication_r11_01 */
static int hf_lte_rrc_autonomousDenialParameters_r11 = -1;  /* T_autonomousDenialParameters_r11 */
static int hf_lte_rrc_autonomousDenialSubframes_r11 = -1;  /* T_autonomousDenialSubframes_r11 */
static int hf_lte_rrc_autonomousDenialValidity_r11 = -1;  /* T_autonomousDenialValidity_r11 */
static int hf_lte_rrc_idc_Indication_UL_CA_r11 = -1;  /* T_idc_Indication_UL_CA_r11 */
static int hf_lte_rrc_idc_HardwareSharingIndication_r13 = -1;  /* T_idc_HardwareSharingIndication_r13 */
static int hf_lte_rrc_idc_Indication_MRDC_r15 = -1;  /* T_idc_Indication_MRDC_r15 */
static int hf_lte_rrc_setup_184 = -1;             /* CandidateServingFreqListNR_r15 */
static int hf_lte_rrc_obtainLocation_r11 = -1;    /* T_obtainLocation_r11 */
static int hf_lte_rrc_setup_185 = -1;             /* T_setup_161 */
static int hf_lte_rrc_powerPrefIndicationTimer_r11 = -1;  /* T_powerPrefIndicationTimer_r11 */
static int hf_lte_rrc_proximityIndicationEUTRA_r9 = -1;  /* T_proximityIndicationEUTRA_r9 */
static int hf_lte_rrc_proximityIndicationUTRA_r9 = -1;  /* T_proximityIndicationUTRA_r9 */
static int hf_lte_rrc_CandidateServingFreqListNR_r15_item = -1;  /* ARFCN_ValueNR_r15 */
static int hf_lte_rrc_sbas_id_r15_01 = -1;        /* T_sbas_id_r15 */
static int hf_lte_rrc_sst = -1;                   /* BIT_STRING_SIZE_8 */
static int hf_lte_rrc_sst_SD = -1;                /* BIT_STRING_SIZE_32 */
static int hf_lte_rrc_m_TMSI = -1;                /* BIT_STRING_SIZE_32 */
static int hf_lte_rrc_plmn_Identity_r10 = -1;     /* PLMN_Identity */
static int hf_lte_rrc_traceId_r10 = -1;           /* OCTET_STRING_SIZE_3 */
static int hf_lte_rrc_UE_CapabilityRAT_ContainerList_item = -1;  /* UE_CapabilityRAT_Container */
static int hf_lte_rrc_rat_Type = -1;              /* RAT_Type */
static int hf_lte_rrc_ueCapabilityRAT_Container = -1;  /* T_ueCapabilityRAT_Container */
static int hf_lte_rrc_accessStratumRelease = -1;  /* AccessStratumRelease */
static int hf_lte_rrc_ue_Category = -1;           /* INTEGER_1_5 */
static int hf_lte_rrc_pdcp_Parameters = -1;       /* PDCP_Parameters */
static int hf_lte_rrc_phyLayerParameters = -1;    /* PhyLayerParameters */
static int hf_lte_rrc_rf_Parameters = -1;         /* RF_Parameters */
static int hf_lte_rrc_measParameters = -1;        /* T_measParameters */
static int hf_lte_rrc_featureGroupIndicators = -1;  /* T_featureGroupIndicators */
static int hf_lte_rrc_interRAT_Parameters = -1;   /* T_interRAT_Parameters */
static int hf_lte_rrc_utraFDD = -1;               /* IRAT_ParametersUTRA_FDD */
static int hf_lte_rrc_utraTDD128 = -1;            /* IRAT_ParametersUTRA_TDD128 */
static int hf_lte_rrc_utraTDD384 = -1;            /* IRAT_ParametersUTRA_TDD384 */
static int hf_lte_rrc_utraTDD768 = -1;            /* IRAT_ParametersUTRA_TDD768 */
static int hf_lte_rrc_geran_02 = -1;              /* IRAT_ParametersGERAN */
static int hf_lte_rrc_cdma2000_HRPD_01 = -1;      /* IRAT_ParametersCDMA2000_HRPD */
static int hf_lte_rrc_cdma2000_1xRTT_01 = -1;     /* IRAT_ParametersCDMA2000_1XRTT */
static int hf_lte_rrc_nonCriticalExtension_240 = -1;  /* UE_EUTRA_Capability_v920_IEs */
static int hf_lte_rrc_featureGroupIndRel9Add_r9 = -1;  /* T_featureGroupIndRel9Add_r9 */
static int hf_lte_rrc_fdd_Add_UE_EUTRA_Capabilities_r9 = -1;  /* UE_EUTRA_CapabilityAddXDD_Mode_r9 */
static int hf_lte_rrc_tdd_Add_UE_EUTRA_Capabilities_r9 = -1;  /* UE_EUTRA_CapabilityAddXDD_Mode_r9 */
static int hf_lte_rrc_nonCriticalExtension_241 = -1;  /* UE_EUTRA_Capability_v9c0_IEs */
static int hf_lte_rrc_interRAT_ParametersUTRA_v9c0 = -1;  /* IRAT_ParametersUTRA_v9c0 */
static int hf_lte_rrc_nonCriticalExtension_242 = -1;  /* UE_EUTRA_Capability_v9d0_IEs */
static int hf_lte_rrc_phyLayerParameters_v9d0 = -1;  /* PhyLayerParameters_v9d0 */
static int hf_lte_rrc_nonCriticalExtension_243 = -1;  /* UE_EUTRA_Capability_v9e0_IEs */
static int hf_lte_rrc_rf_Parameters_v9e0 = -1;    /* RF_Parameters_v9e0 */
static int hf_lte_rrc_nonCriticalExtension_244 = -1;  /* UE_EUTRA_Capability_v9h0_IEs */
static int hf_lte_rrc_interRAT_ParametersUTRA_v9h0 = -1;  /* IRAT_ParametersUTRA_v9h0 */
static int hf_lte_rrc_nonCriticalExtension_245 = -1;  /* UE_EUTRA_Capability_v10c0_IEs */
static int hf_lte_rrc_otdoa_PositioningCapabilities_r10 = -1;  /* OTDOA_PositioningCapabilities_r10 */
static int hf_lte_rrc_nonCriticalExtension_246 = -1;  /* UE_EUTRA_Capability_v10f0_IEs */
static int hf_lte_rrc_rf_Parameters_v10f0 = -1;   /* RF_Parameters_v10f0 */
static int hf_lte_rrc_nonCriticalExtension_247 = -1;  /* UE_EUTRA_Capability_v10i0_IEs */
static int hf_lte_rrc_rf_Parameters_v10i0 = -1;   /* RF_Parameters_v10i0 */
static int hf_lte_rrc_lateNonCriticalExtension_12 = -1;  /* T_lateNonCriticalExtension_11 */
static int hf_lte_rrc_nonCriticalExtension_248 = -1;  /* UE_EUTRA_Capability_v11d0_IEs */
static int hf_lte_rrc_rf_Parameters_v10j0 = -1;   /* RF_Parameters_v10j0 */
static int hf_lte_rrc_nonCriticalExtension_249 = -1;  /* T_nonCriticalExtension_76 */
static int hf_lte_rrc_rf_Parameters_v11d0 = -1;   /* RF_Parameters_v11d0 */
static int hf_lte_rrc_otherParameters_v11d0 = -1;  /* Other_Parameters_v11d0 */
static int hf_lte_rrc_nonCriticalExtension_250 = -1;  /* UE_EUTRA_Capability_v11x0_IEs */
static int hf_lte_rrc_nonCriticalExtension_251 = -1;  /* UE_EUTRA_Capability_v12b0_IEs */
static int hf_lte_rrc_rf_Parameters_v12b0 = -1;   /* RF_Parameters_v12b0 */
static int hf_lte_rrc_nonCriticalExtension_252 = -1;  /* UE_EUTRA_Capability_v12x0_IEs */
static int hf_lte_rrc_nonCriticalExtension_253 = -1;  /* UE_EUTRA_Capability_v1370_IEs */
static int hf_lte_rrc_ce_Parameters_v1370 = -1;   /* CE_Parameters_v1370 */
static int hf_lte_rrc_fdd_Add_UE_EUTRA_Capabilities_v1370 = -1;  /* UE_EUTRA_CapabilityAddXDD_Mode_v1370 */
static int hf_lte_rrc_tdd_Add_UE_EUTRA_Capabilities_v1370 = -1;  /* UE_EUTRA_CapabilityAddXDD_Mode_v1370 */
static int hf_lte_rrc_nonCriticalExtension_254 = -1;  /* UE_EUTRA_Capability_v1380_IEs */
static int hf_lte_rrc_rf_Parameters_v1380 = -1;   /* RF_Parameters_v1380 */
static int hf_lte_rrc_ce_Parameters_v1380 = -1;   /* CE_Parameters_v1380 */
static int hf_lte_rrc_fdd_Add_UE_EUTRA_Capabilities_v1380 = -1;  /* UE_EUTRA_CapabilityAddXDD_Mode_v1380 */
static int hf_lte_rrc_tdd_Add_UE_EUTRA_Capabilities_v1380 = -1;  /* UE_EUTRA_CapabilityAddXDD_Mode_v1380 */
static int hf_lte_rrc_nonCriticalExtension_255 = -1;  /* UE_EUTRA_Capability_v1390_IEs */
static int hf_lte_rrc_rf_Parameters_v1390 = -1;   /* RF_Parameters_v1390 */
static int hf_lte_rrc_nonCriticalExtension_256 = -1;  /* UE_EUTRA_Capability_v13e0a_IEs */
static int hf_lte_rrc_lateNonCriticalExtension_13 = -1;  /* T_lateNonCriticalExtension_12 */
static int hf_lte_rrc_nonCriticalExtension_257 = -1;  /* UE_EUTRA_Capability_v1470_IEs */
static int hf_lte_rrc_phyLayerParameters_v13e0 = -1;  /* PhyLayerParameters_v13e0 */
static int hf_lte_rrc_nonCriticalExtension_258 = -1;  /* T_nonCriticalExtension_77 */
static int hf_lte_rrc_mbms_Parameters_v1470 = -1;  /* MBMS_Parameters_v1470 */
static int hf_lte_rrc_phyLayerParameters_v1470 = -1;  /* PhyLayerParameters_v1470 */
static int hf_lte_rrc_rf_Parameters_v1470 = -1;   /* RF_Parameters_v1470 */
static int hf_lte_rrc_nonCriticalExtension_259 = -1;  /* UE_EUTRA_Capability_v14a0_IEs */
static int hf_lte_rrc_phyLayerParameters_v14a0 = -1;  /* PhyLayerParameters_v14a0 */
static int hf_lte_rrc_nonCriticalExtension_260 = -1;  /* UE_EUTRA_Capability_v14b0_IEs */
static int hf_lte_rrc_rf_Parameters_v14b0 = -1;   /* RF_Parameters_v14b0 */
static int hf_lte_rrc_nonCriticalExtension_261 = -1;  /* T_nonCriticalExtension_78 */
static int hf_lte_rrc_phyLayerParameters_v920 = -1;  /* PhyLayerParameters_v920 */
static int hf_lte_rrc_interRAT_ParametersGERAN_v920 = -1;  /* IRAT_ParametersGERAN_v920 */
static int hf_lte_rrc_interRAT_ParametersUTRA_v920 = -1;  /* IRAT_ParametersUTRA_v920 */
static int hf_lte_rrc_interRAT_ParametersCDMA2000_v920 = -1;  /* IRAT_ParametersCDMA2000_1XRTT_v920 */
static int hf_lte_rrc_deviceType_r9 = -1;         /* T_deviceType_r9 */
static int hf_lte_rrc_csg_ProximityIndicationParameters_r9 = -1;  /* CSG_ProximityIndicationParameters_r9 */
static int hf_lte_rrc_neighCellSI_AcquisitionParameters_r9 = -1;  /* NeighCellSI_AcquisitionParameters_r9 */
static int hf_lte_rrc_son_Parameters_r9 = -1;     /* SON_Parameters_r9 */
static int hf_lte_rrc_nonCriticalExtension_262 = -1;  /* UE_EUTRA_Capability_v940_IEs */
static int hf_lte_rrc_lateNonCriticalExtension_14 = -1;  /* T_lateNonCriticalExtension_13 */
static int hf_lte_rrc_nonCriticalExtension_263 = -1;  /* UE_EUTRA_Capability_v1020_IEs */
static int hf_lte_rrc_ue_Category_v1020 = -1;     /* INTEGER_6_8 */
static int hf_lte_rrc_phyLayerParameters_v1020 = -1;  /* PhyLayerParameters_v1020 */
static int hf_lte_rrc_rf_Parameters_v1020 = -1;   /* RF_Parameters_v1020 */
static int hf_lte_rrc_measParameters_v1020 = -1;  /* MeasParameters_v1020 */
static int hf_lte_rrc_featureGroupIndRel10_r10 = -1;  /* T_featureGroupIndRel10_r10 */
static int hf_lte_rrc_interRAT_ParametersCDMA2000_v1020 = -1;  /* IRAT_ParametersCDMA2000_1XRTT_v1020 */
static int hf_lte_rrc_ue_BasedNetwPerfMeasParameters_r10 = -1;  /* UE_BasedNetwPerfMeasParameters_r10 */
static int hf_lte_rrc_interRAT_ParametersUTRA_TDD_v1020 = -1;  /* IRAT_ParametersUTRA_TDD_v1020 */
static int hf_lte_rrc_nonCriticalExtension_264 = -1;  /* UE_EUTRA_Capability_v1060_IEs */
static int hf_lte_rrc_fdd_Add_UE_EUTRA_Capabilities_v1060 = -1;  /* UE_EUTRA_CapabilityAddXDD_Mode_v1060 */
static int hf_lte_rrc_tdd_Add_UE_EUTRA_Capabilities_v1060 = -1;  /* UE_EUTRA_CapabilityAddXDD_Mode_v1060 */
static int hf_lte_rrc_rf_Parameters_v1060 = -1;   /* RF_Parameters_v1060 */
static int hf_lte_rrc_nonCriticalExtension_265 = -1;  /* UE_EUTRA_Capability_v1090_IEs */
static int hf_lte_rrc_rf_Parameters_v1090 = -1;   /* RF_Parameters_v1090 */
static int hf_lte_rrc_nonCriticalExtension_266 = -1;  /* UE_EUTRA_Capability_v1130_IEs */
static int hf_lte_rrc_pdcp_Parameters_v1130 = -1;  /* PDCP_Parameters_v1130 */
static int hf_lte_rrc_phyLayerParameters_v1130 = -1;  /* PhyLayerParameters_v1130 */
static int hf_lte_rrc_rf_Parameters_v1130 = -1;   /* RF_Parameters_v1130 */
static int hf_lte_rrc_measParameters_v1130 = -1;  /* MeasParameters_v1130 */
static int hf_lte_rrc_interRAT_ParametersCDMA2000_v1130 = -1;  /* IRAT_ParametersCDMA2000_v1130 */
static int hf_lte_rrc_otherParameters_r11 = -1;   /* Other_Parameters_r11 */
static int hf_lte_rrc_fdd_Add_UE_EUTRA_Capabilities_v1130 = -1;  /* UE_EUTRA_CapabilityAddXDD_Mode_v1130 */
static int hf_lte_rrc_tdd_Add_UE_EUTRA_Capabilities_v1130 = -1;  /* UE_EUTRA_CapabilityAddXDD_Mode_v1130 */
static int hf_lte_rrc_nonCriticalExtension_267 = -1;  /* UE_EUTRA_Capability_v1170_IEs */
static int hf_lte_rrc_phyLayerParameters_v1170 = -1;  /* PhyLayerParameters_v1170 */
static int hf_lte_rrc_ue_Category_v1170 = -1;     /* INTEGER_9_10 */
static int hf_lte_rrc_nonCriticalExtension_268 = -1;  /* UE_EUTRA_Capability_v1180_IEs */
static int hf_lte_rrc_rf_Parameters_v1180 = -1;   /* RF_Parameters_v1180 */
static int hf_lte_rrc_mbms_Parameters_r11 = -1;   /* MBMS_Parameters_r11 */
static int hf_lte_rrc_fdd_Add_UE_EUTRA_Capabilities_v1180 = -1;  /* UE_EUTRA_CapabilityAddXDD_Mode_v1180 */
static int hf_lte_rrc_tdd_Add_UE_EUTRA_Capabilities_v1180 = -1;  /* UE_EUTRA_CapabilityAddXDD_Mode_v1180 */
static int hf_lte_rrc_nonCriticalExtension_269 = -1;  /* UE_EUTRA_Capability_v11a0_IEs */
static int hf_lte_rrc_ue_Category_v11a0 = -1;     /* INTEGER_11_12 */
static int hf_lte_rrc_measParameters_v11a0 = -1;  /* MeasParameters_v11a0 */
static int hf_lte_rrc_nonCriticalExtension_270 = -1;  /* UE_EUTRA_Capability_v1250_IEs */
static int hf_lte_rrc_phyLayerParameters_v1250 = -1;  /* PhyLayerParameters_v1250 */
static int hf_lte_rrc_rf_Parameters_v1250 = -1;   /* RF_Parameters_v1250 */
static int hf_lte_rrc_rlc_Parameters_r12 = -1;    /* RLC_Parameters_r12 */
static int hf_lte_rrc_ue_BasedNetwPerfMeasParameters_v1250 = -1;  /* UE_BasedNetwPerfMeasParameters_v1250 */
static int hf_lte_rrc_ue_CategoryDL_r12 = -1;     /* INTEGER_0_14 */
static int hf_lte_rrc_ue_CategoryUL_r12 = -1;     /* INTEGER_0_13 */
static int hf_lte_rrc_wlan_IW_Parameters_r12 = -1;  /* WLAN_IW_Parameters_r12 */
static int hf_lte_rrc_measParameters_v1250 = -1;  /* MeasParameters_v1250 */
static int hf_lte_rrc_dc_Parameters_r12 = -1;     /* DC_Parameters_r12 */
static int hf_lte_rrc_mbms_Parameters_v1250 = -1;  /* MBMS_Parameters_v1250 */
static int hf_lte_rrc_mac_Parameters_r12 = -1;    /* MAC_Parameters_r12 */
static int hf_lte_rrc_fdd_Add_UE_EUTRA_Capabilities_v1250 = -1;  /* UE_EUTRA_CapabilityAddXDD_Mode_v1250 */
static int hf_lte_rrc_tdd_Add_UE_EUTRA_Capabilities_v1250 = -1;  /* UE_EUTRA_CapabilityAddXDD_Mode_v1250 */
static int hf_lte_rrc_sl_Parameters_r12 = -1;     /* SL_Parameters_r12 */
static int hf_lte_rrc_nonCriticalExtension_271 = -1;  /* UE_EUTRA_Capability_v1260_IEs */
static int hf_lte_rrc_ue_CategoryDL_v1260 = -1;   /* INTEGER_15_16 */
static int hf_lte_rrc_nonCriticalExtension_272 = -1;  /* UE_EUTRA_Capability_v1270_IEs */
static int hf_lte_rrc_rf_Parameters_v1270 = -1;   /* RF_Parameters_v1270 */
static int hf_lte_rrc_nonCriticalExtension_273 = -1;  /* UE_EUTRA_Capability_v1280_IEs */
static int hf_lte_rrc_phyLayerParameters_v1280 = -1;  /* PhyLayerParameters_v1280 */
static int hf_lte_rrc_nonCriticalExtension_274 = -1;  /* UE_EUTRA_Capability_v1310_IEs */
static int hf_lte_rrc_ue_CategoryDL_v1310 = -1;   /* T_ue_CategoryDL_v1310 */
static int hf_lte_rrc_ue_CategoryUL_v1310 = -1;   /* T_ue_CategoryUL_v1310 */
static int hf_lte_rrc_pdcp_Parameters_v1310 = -1;  /* PDCP_Parameters_v1310 */
static int hf_lte_rrc_rlc_Parameters_v1310 = -1;  /* RLC_Parameters_v1310 */
static int hf_lte_rrc_mac_Parameters_v1310 = -1;  /* MAC_Parameters_v1310 */
static int hf_lte_rrc_phyLayerParameters_v1310 = -1;  /* PhyLayerParameters_v1310 */
static int hf_lte_rrc_rf_Parameters_v1310 = -1;   /* RF_Parameters_v1310 */
static int hf_lte_rrc_measParameters_v1310 = -1;  /* MeasParameters_v1310 */
static int hf_lte_rrc_dc_Parameters_v1310 = -1;   /* DC_Parameters_v1310 */
static int hf_lte_rrc_sl_Parameters_v1310 = -1;   /* SL_Parameters_v1310 */
static int hf_lte_rrc_scptm_Parameters_r13 = -1;  /* SCPTM_Parameters_r13 */
static int hf_lte_rrc_ce_Parameters_r13 = -1;     /* CE_Parameters_r13 */
static int hf_lte_rrc_interRAT_ParametersWLAN_r13 = -1;  /* IRAT_ParametersWLAN_r13 */
static int hf_lte_rrc_laa_Parameters_r13 = -1;    /* LAA_Parameters_r13 */
static int hf_lte_rrc_lwa_Parameters_r13 = -1;    /* LWA_Parameters_r13 */
static int hf_lte_rrc_wlan_IW_Parameters_v1310 = -1;  /* WLAN_IW_Parameters_v1310 */
static int hf_lte_rrc_lwip_Parameters_r13 = -1;   /* LWIP_Parameters_r13 */
static int hf_lte_rrc_fdd_Add_UE_EUTRA_Capabilities_v1310 = -1;  /* UE_EUTRA_CapabilityAddXDD_Mode_v1310 */
static int hf_lte_rrc_tdd_Add_UE_EUTRA_Capabilities_v1310 = -1;  /* UE_EUTRA_CapabilityAddXDD_Mode_v1310 */
static int hf_lte_rrc_nonCriticalExtension_275 = -1;  /* UE_EUTRA_Capability_v1320_IEs */
static int hf_lte_rrc_ce_Parameters_v1320 = -1;   /* CE_Parameters_v1320 */
static int hf_lte_rrc_phyLayerParameters_v1320 = -1;  /* PhyLayerParameters_v1320 */
static int hf_lte_rrc_rf_Parameters_v1320 = -1;   /* RF_Parameters_v1320 */
static int hf_lte_rrc_fdd_Add_UE_EUTRA_Capabilities_v1320 = -1;  /* UE_EUTRA_CapabilityAddXDD_Mode_v1320 */
static int hf_lte_rrc_tdd_Add_UE_EUTRA_Capabilities_v1320 = -1;  /* UE_EUTRA_CapabilityAddXDD_Mode_v1320 */
static int hf_lte_rrc_nonCriticalExtension_276 = -1;  /* UE_EUTRA_Capability_v1330_IEs */
static int hf_lte_rrc_ue_CategoryDL_v1330 = -1;   /* INTEGER_18_19 */
static int hf_lte_rrc_phyLayerParameters_v1330 = -1;  /* PhyLayerParameters_v1330 */
static int hf_lte_rrc_ue_CE_NeedULGaps_r13_01 = -1;  /* T_ue_CE_NeedULGaps_r13_01 */
static int hf_lte_rrc_nonCriticalExtension_277 = -1;  /* UE_EUTRA_Capability_v1340_IEs */
static int hf_lte_rrc_ue_CategoryUL_v1340 = -1;   /* INTEGER_15 */
static int hf_lte_rrc_nonCriticalExtension_278 = -1;  /* UE_EUTRA_Capability_v1350_IEs */
static int hf_lte_rrc_ue_CategoryDL_v1350 = -1;   /* T_ue_CategoryDL_v1350 */
static int hf_lte_rrc_ue_CategoryUL_v1350 = -1;   /* T_ue_CategoryUL_v1350 */
static int hf_lte_rrc_ce_Parameters_v1350 = -1;   /* CE_Parameters_v1350 */
static int hf_lte_rrc_nonCriticalExtension_279 = -1;  /* UE_EUTRA_Capability_v1360_IEs */
static int hf_lte_rrc_other_Parameters_v1360 = -1;  /* Other_Parameters_v1360 */
static int hf_lte_rrc_nonCriticalExtension_280 = -1;  /* UE_EUTRA_Capability_v1430_IEs */
static int hf_lte_rrc_phyLayerParameters_v1430 = -1;  /* PhyLayerParameters_v1430 */
static int hf_lte_rrc_ue_CategoryDL_v1430 = -1;   /* T_ue_CategoryDL_v1430 */
static int hf_lte_rrc_ue_CategoryUL_v1430 = -1;   /* T_ue_CategoryUL_v1430 */
static int hf_lte_rrc_ue_CategoryUL_v1430b = -1;  /* T_ue_CategoryUL_v1430b */
static int hf_lte_rrc_mac_Parameters_v1430 = -1;  /* MAC_Parameters_v1430 */
static int hf_lte_rrc_measParameters_v1430 = -1;  /* MeasParameters_v1430 */
static int hf_lte_rrc_pdcp_Parameters_v1430 = -1;  /* PDCP_Parameters_v1430 */
static int hf_lte_rrc_rlc_Parameters_v1430 = -1;  /* RLC_Parameters_v1430 */
static int hf_lte_rrc_rf_Parameters_v1430 = -1;   /* RF_Parameters_v1430 */
static int hf_lte_rrc_laa_Parameters_v1430 = -1;  /* LAA_Parameters_v1430 */
static int hf_lte_rrc_lwa_Parameters_v1430 = -1;  /* LWA_Parameters_v1430 */
static int hf_lte_rrc_lwip_Parameters_v1430 = -1;  /* LWIP_Parameters_v1430 */
static int hf_lte_rrc_otherParameters_v1430 = -1;  /* Other_Parameters_v1430 */
static int hf_lte_rrc_mmtel_Parameters_r14 = -1;  /* MMTEL_Parameters_r14 */
static int hf_lte_rrc_mobilityParameters_r14 = -1;  /* MobilityParameters_r14 */
static int hf_lte_rrc_ce_Parameters_v1430 = -1;   /* CE_Parameters_v1430 */
static int hf_lte_rrc_fdd_Add_UE_EUTRA_Capabilities_v1430 = -1;  /* UE_EUTRA_CapabilityAddXDD_Mode_v1430 */
static int hf_lte_rrc_tdd_Add_UE_EUTRA_Capabilities_v1430 = -1;  /* UE_EUTRA_CapabilityAddXDD_Mode_v1430 */
static int hf_lte_rrc_mbms_Parameters_v1430 = -1;  /* MBMS_Parameters_v1430 */
static int hf_lte_rrc_sl_Parameters_v1430 = -1;   /* SL_Parameters_v1430 */
static int hf_lte_rrc_ue_BasedNetwPerfMeasParameters_v1430 = -1;  /* UE_BasedNetwPerfMeasParameters_v1430 */
static int hf_lte_rrc_highSpeedEnhParameters_r14 = -1;  /* HighSpeedEnhParameters_r14 */
static int hf_lte_rrc_nonCriticalExtension_281 = -1;  /* UE_EUTRA_Capability_v1440_IEs */
static int hf_lte_rrc_lwa_Parameters_v1440 = -1;  /* LWA_Parameters_v1440 */
static int hf_lte_rrc_mac_Parameters_v1440 = -1;  /* MAC_Parameters_v1440 */
static int hf_lte_rrc_nonCriticalExtension_282 = -1;  /* UE_EUTRA_Capability_v1450_IEs */
static int hf_lte_rrc_phyLayerParameters_v1450 = -1;  /* PhyLayerParameters_v1450 */
static int hf_lte_rrc_rf_Parameters_v1450 = -1;   /* RF_Parameters_v1450 */
static int hf_lte_rrc_otherParameters_v1450 = -1;  /* OtherParameters_v1450 */
static int hf_lte_rrc_ue_CategoryDL_v1450 = -1;   /* INTEGER_20 */
static int hf_lte_rrc_nonCriticalExtension_283 = -1;  /* UE_EUTRA_Capability_v1460_IEs */
static int hf_lte_rrc_ue_CategoryDL_v1460 = -1;   /* INTEGER_21 */
static int hf_lte_rrc_otherParameters_v1460 = -1;  /* Other_Parameters_v1460 */
static int hf_lte_rrc_nonCriticalExtension_284 = -1;  /* UE_EUTRA_Capability_v1510_IEs */
static int hf_lte_rrc_irat_ParametersNR_r15 = -1;  /* IRAT_ParametersNR_r15 */
static int hf_lte_rrc_featureSetsEUTRA_r15 = -1;  /* FeatureSetsEUTRA_r15 */
static int hf_lte_rrc_pdcp_ParametersNR_r15 = -1;  /* PDCP_ParametersNR_r15 */
static int hf_lte_rrc_fdd_Add_UE_EUTRA_Capabilities_v1510 = -1;  /* UE_EUTRA_CapabilityAddXDD_Mode_v1510 */
static int hf_lte_rrc_tdd_Add_UE_EUTRA_Capabilities_v1510 = -1;  /* UE_EUTRA_CapabilityAddXDD_Mode_v1510 */
static int hf_lte_rrc_nonCriticalExtension_285 = -1;  /* UE_EUTRA_Capability_v1520_IEs */
static int hf_lte_rrc_measParameters_v1520 = -1;  /* MeasParameters_v1520 */
static int hf_lte_rrc_nonCriticalExtension_286 = -1;  /* UE_EUTRA_Capability_v1530_IEs */
static int hf_lte_rrc_measParameters_v1530 = -1;  /* MeasParameters_v1530 */
static int hf_lte_rrc_otherParameters_v1530 = -1;  /* Other_Parameters_v1530 */
static int hf_lte_rrc_neighCellSI_AcquisitionParameters_v1530 = -1;  /* NeighCellSI_AcquisitionParameters_v1530 */
static int hf_lte_rrc_mac_Parameters_v1530 = -1;  /* MAC_Parameters_v1530 */
static int hf_lte_rrc_phyLayerParameters_v1530 = -1;  /* PhyLayerParameters_v1530 */
static int hf_lte_rrc_rf_Parameters_v1530 = -1;   /* RF_Parameters_v1530 */
static int hf_lte_rrc_pdcp_Parameters_v1530 = -1;  /* PDCP_Parameters_v1530 */
static int hf_lte_rrc_ue_CategoryDL_v1530 = -1;   /* INTEGER_22_26 */
static int hf_lte_rrc_ue_BasedNetwPerfMeasParameters_v1530 = -1;  /* UE_BasedNetwPerfMeasParameters_v1530 */
static int hf_lte_rrc_rlc_Parameters_v1530 = -1;  /* RLC_Parameters_v1530 */
static int hf_lte_rrc_sl_Parameters_v1530 = -1;   /* SL_Parameters_v1530 */
static int hf_lte_rrc_extendedNumberOfDRBs_r15 = -1;  /* T_extendedNumberOfDRBs_r15 */
static int hf_lte_rrc_reducedCP_Latency_r15 = -1;  /* T_reducedCP_Latency_r15 */
static int hf_lte_rrc_laa_Parameters_v1530 = -1;  /* LAA_Parameters_v1530 */
static int hf_lte_rrc_ue_CategoryUL_v1530 = -1;   /* INTEGER_22_26 */
static int hf_lte_rrc_fdd_Add_UE_EUTRA_Capabilities_v1530 = -1;  /* UE_EUTRA_CapabilityAddXDD_Mode_v1530 */
static int hf_lte_rrc_tdd_Add_UE_EUTRA_Capabilities_v1530 = -1;  /* UE_EUTRA_CapabilityAddXDD_Mode_v1530 */
static int hf_lte_rrc_nonCriticalExtension_287 = -1;  /* UE_EUTRA_Capability_v1540_IEs */
static int hf_lte_rrc_phyLayerParameters_v1540 = -1;  /* PhyLayerParameters_v1540 */
static int hf_lte_rrc_otherParameters_v1540 = -1;  /* Other_Parameters_v1540 */
static int hf_lte_rrc_fdd_Add_UE_EUTRA_Capabilities_v1540 = -1;  /* UE_EUTRA_CapabilityAddXDD_Mode_v1540 */
static int hf_lte_rrc_tdd_Add_UE_EUTRA_Capabilities_v1540 = -1;  /* UE_EUTRA_CapabilityAddXDD_Mode_v1540 */
static int hf_lte_rrc_sl_Parameters_v1540 = -1;   /* SL_Parameters_v1540 */
static int hf_lte_rrc_irat_ParametersNR_v1540 = -1;  /* IRAT_ParametersNR_v1540 */
static int hf_lte_rrc_nonCriticalExtension_288 = -1;  /* UE_EUTRA_Capability_v1550_IEs */
static int hf_lte_rrc_neighCellSI_AcquisitionParameters_v1550 = -1;  /* NeighCellSI_AcquisitionParameters_v1550 */
static int hf_lte_rrc_phyLayerParameters_v1550 = -1;  /* PhyLayerParameters_v1550 */
static int hf_lte_rrc_mac_Parameters_v1550 = -1;  /* MAC_Parameters_v1550 */
static int hf_lte_rrc_fdd_Add_UE_EUTRA_Capabilities_v1550 = -1;  /* UE_EUTRA_CapabilityAddXDD_Mode_v1550 */
static int hf_lte_rrc_tdd_Add_UE_EUTRA_Capabilities_v1550 = -1;  /* UE_EUTRA_CapabilityAddXDD_Mode_v1550 */
static int hf_lte_rrc_nonCriticalExtension_289 = -1;  /* UE_EUTRA_Capability_v1560_IEs */
static int hf_lte_rrc_pdcp_ParametersNR_v1560 = -1;  /* PDCP_ParametersNR_v1560 */
static int hf_lte_rrc_irat_ParametersNR_v1560 = -1;  /* IRAT_ParametersNR_v1560 */
static int hf_lte_rrc_appliedCapabilityFilterCommon_r15 = -1;  /* T_appliedCapabilityFilterCommon_r15 */
static int hf_lte_rrc_fdd_Add_UE_EUTRA_Capabilities_v1560 = -1;  /* UE_EUTRA_CapabilityAddXDD_Mode_v1560 */
static int hf_lte_rrc_tdd_Add_UE_EUTRA_Capabilities_v1560 = -1;  /* UE_EUTRA_CapabilityAddXDD_Mode_v1560 */
static int hf_lte_rrc_nonCriticalExtension_290 = -1;  /* UE_EUTRA_Capability_v1570_IEs */
static int hf_lte_rrc_rf_Parameters_v1570 = -1;   /* RF_Parameters_v1570 */
static int hf_lte_rrc_irat_ParametersNR_v1570 = -1;  /* IRAT_ParametersNR_v1570 */
static int hf_lte_rrc_nonCriticalExtension_291 = -1;  /* T_nonCriticalExtension_79 */
static int hf_lte_rrc_phyLayerParameters_r9 = -1;  /* PhyLayerParameters */
static int hf_lte_rrc_featureGroupIndicators_r9 = -1;  /* T_featureGroupIndicators_r9 */
static int hf_lte_rrc_featureGroupIndRel9Add_r9_01 = -1;  /* T_featureGroupIndRel9Add_r9_01 */
static int hf_lte_rrc_interRAT_ParametersGERAN_r9 = -1;  /* IRAT_ParametersGERAN */
static int hf_lte_rrc_interRAT_ParametersUTRA_r9 = -1;  /* IRAT_ParametersUTRA_v920 */
static int hf_lte_rrc_interRAT_ParametersCDMA2000_r9 = -1;  /* IRAT_ParametersCDMA2000_1XRTT_v920 */
static int hf_lte_rrc_phyLayerParameters_v1060 = -1;  /* PhyLayerParameters_v1020 */
static int hf_lte_rrc_featureGroupIndRel10_v1060 = -1;  /* T_featureGroupIndRel10_v1060 */
static int hf_lte_rrc_interRAT_ParametersCDMA2000_v1060 = -1;  /* IRAT_ParametersCDMA2000_1XRTT_v1020 */
static int hf_lte_rrc_interRAT_ParametersUTRA_TDD_v1060 = -1;  /* IRAT_ParametersUTRA_TDD_v1020 */
static int hf_lte_rrc_reducedCP_Latency_r15_01 = -1;  /* T_reducedCP_Latency_r15_01 */
static int hf_lte_rrc_eutra_5GC_Parameters_r15 = -1;  /* EUTRA_5GC_Parameters_r15 */
static int hf_lte_rrc_featureSetsDL_r15 = -1;     /* SEQUENCE_SIZE_1_maxFeatureSets_r15_OF_FeatureSetDL_r15 */
static int hf_lte_rrc_featureSetsDL_r15_item = -1;  /* FeatureSetDL_r15 */
static int hf_lte_rrc_featureSetsDL_PerCC_r15 = -1;  /* SEQUENCE_SIZE_1_maxPerCC_FeatureSets_r15_OF_FeatureSetDL_PerCC_r15 */
static int hf_lte_rrc_featureSetsDL_PerCC_r15_item = -1;  /* FeatureSetDL_PerCC_r15 */
static int hf_lte_rrc_featureSetsUL_r15 = -1;     /* SEQUENCE_SIZE_1_maxFeatureSets_r15_OF_FeatureSetUL_r15 */
static int hf_lte_rrc_featureSetsUL_r15_item = -1;  /* FeatureSetUL_r15 */
static int hf_lte_rrc_featureSetsUL_PerCC_r15 = -1;  /* SEQUENCE_SIZE_1_maxPerCC_FeatureSets_r15_OF_FeatureSetUL_PerCC_r15 */
static int hf_lte_rrc_featureSetsUL_PerCC_r15_item = -1;  /* FeatureSetUL_PerCC_r15 */
static int hf_lte_rrc_featureSetsDL_v1550 = -1;   /* SEQUENCE_SIZE_1_maxFeatureSets_r15_OF_FeatureSetDL_v1550 */
static int hf_lte_rrc_featureSetsDL_v1550_item = -1;  /* FeatureSetDL_v1550 */
static int hf_lte_rrc_makeBeforeBreak_r14_01 = -1;  /* T_makeBeforeBreak_r14_01 */
static int hf_lte_rrc_rach_Less_r14 = -1;         /* T_rach_Less_r14 */
static int hf_lte_rrc_drb_TypeSplit_r12 = -1;     /* T_drb_TypeSplit_r12 */
static int hf_lte_rrc_drb_TypeSCG_r12 = -1;       /* T_drb_TypeSCG_r12 */
static int hf_lte_rrc_pdcp_TransferSplitUL_r13 = -1;  /* T_pdcp_TransferSplitUL_r13 */
static int hf_lte_rrc_ue_SSTD_Meas_r13 = -1;      /* T_ue_SSTD_Meas_r13 */
static int hf_lte_rrc_logicalChannelSR_ProhibitTimer_r12_01 = -1;  /* T_logicalChannelSR_ProhibitTimer_r12_01 */
static int hf_lte_rrc_longDRX_Command_r12 = -1;   /* T_longDRX_Command_r12 */
static int hf_lte_rrc_extendedMAC_LengthField_r13 = -1;  /* T_extendedMAC_LengthField_r13 */
static int hf_lte_rrc_extendedLongDRX_r13 = -1;   /* T_extendedLongDRX_r13 */
static int hf_lte_rrc_shortSPS_IntervalFDD_r14 = -1;  /* T_shortSPS_IntervalFDD_r14 */
static int hf_lte_rrc_shortSPS_IntervalTDD_r14 = -1;  /* T_shortSPS_IntervalTDD_r14 */
static int hf_lte_rrc_skipUplinkDynamic_r14 = -1;  /* T_skipUplinkDynamic_r14 */
static int hf_lte_rrc_skipUplinkSPS_r14 = -1;     /* T_skipUplinkSPS_r14 */
static int hf_lte_rrc_multipleUplinkSPS_r14 = -1;  /* T_multipleUplinkSPS_r14 */
static int hf_lte_rrc_dataInactMon_r14 = -1;      /* T_dataInactMon_r14 */
static int hf_lte_rrc_rai_Support_r14 = -1;       /* T_rai_Support_r14 */
static int hf_lte_rrc_min_Proc_TimelineSubslot_r15 = -1;  /* SEQUENCE_SIZE_1_3_OF_ProcessingTimelineSet_r15 */
static int hf_lte_rrc_min_Proc_TimelineSubslot_r15_item = -1;  /* ProcessingTimelineSet_r15 */
static int hf_lte_rrc_skipSubframeProcessing_r15 = -1;  /* SkipSubframeProcessing_r15 */
static int hf_lte_rrc_earlyData_UP_r15 = -1;      /* T_earlyData_UP_r15 */
static int hf_lte_rrc_dormantSCellState_r15 = -1;  /* T_dormantSCellState_r15 */
static int hf_lte_rrc_directSCellActivation_r15 = -1;  /* T_directSCellActivation_r15 */
static int hf_lte_rrc_directSCellHibernation_r15 = -1;  /* T_directSCellHibernation_r15 */
static int hf_lte_rrc_extendedLCID_Duplication_r15 = -1;  /* T_extendedLCID_Duplication_r15 */
static int hf_lte_rrc_sps_ServingCell_r15 = -1;   /* T_sps_ServingCell_r15 */
static int hf_lte_rrc_eLCID_Support_r15 = -1;     /* T_eLCID_Support_r15 */
static int hf_lte_rrc_extended_RLC_LI_Field_r12 = -1;  /* T_extended_RLC_LI_Field_r12 */
static int hf_lte_rrc_extendedRLC_SN_SO_Field_r13 = -1;  /* T_extendedRLC_SN_SO_Field_r13 */
static int hf_lte_rrc_extendedPollByte_r14 = -1;  /* T_extendedPollByte_r14 */
static int hf_lte_rrc_flexibleUM_AM_Combinations_r15 = -1;  /* T_flexibleUM_AM_Combinations_r15 */
static int hf_lte_rrc_rlc_AM_Ooo_Delivery_r15 = -1;  /* T_rlc_AM_Ooo_Delivery_r15 */
static int hf_lte_rrc_rlc_UM_Ooo_Delivery_r15 = -1;  /* T_rlc_UM_Ooo_Delivery_r15 */
static int hf_lte_rrc_supportedROHC_Profiles = -1;  /* ROHC_ProfileSupportList_r15 */
static int hf_lte_rrc_maxNumberROHC_ContextSessions = -1;  /* T_maxNumberROHC_ContextSessions */
static int hf_lte_rrc_pdcp_SN_Extension_r11 = -1;  /* T_pdcp_SN_Extension_r11 */
static int hf_lte_rrc_supportRohcContextContinue_r11 = -1;  /* T_supportRohcContextContinue_r11 */
static int hf_lte_rrc_pdcp_SN_Extension_18bits_r13 = -1;  /* T_pdcp_SN_Extension_18bits_r13 */
static int hf_lte_rrc_supportedUplinkOnlyROHC_Profiles_r14 = -1;  /* T_supportedUplinkOnlyROHC_Profiles_r14 */
static int hf_lte_rrc_maxNumberROHC_ContextSessions_r14 = -1;  /* T_maxNumberROHC_ContextSessions_r14 */
static int hf_lte_rrc_supportedUDC_r15 = -1;      /* SupportedUDC_r15 */
static int hf_lte_rrc_pdcp_Duplication_r15_01 = -1;  /* T_pdcp_Duplication_r15_01 */
static int hf_lte_rrc_supportedStandardDic_r15 = -1;  /* T_supportedStandardDic_r15 */
static int hf_lte_rrc_supportedOperatorDic_r15 = -1;  /* SupportedOperatorDic_r15 */
static int hf_lte_rrc_versionOfDictionary_r15 = -1;  /* INTEGER_0_15 */
static int hf_lte_rrc_associatedPLMN_ID_r15 = -1;  /* PLMN_Identity */
static int hf_lte_rrc_ue_TxAntennaSelectionSupported = -1;  /* BOOLEAN */
static int hf_lte_rrc_ue_SpecificRefSigsSupported = -1;  /* BOOLEAN */
static int hf_lte_rrc_enhancedDualLayerFDD_r9 = -1;  /* T_enhancedDualLayerFDD_r9 */
static int hf_lte_rrc_enhancedDualLayerTDD_r9 = -1;  /* T_enhancedDualLayerTDD_r9 */
static int hf_lte_rrc_tm5_FDD_r9 = -1;            /* T_tm5_FDD_r9 */
static int hf_lte_rrc_tm5_TDD_r9 = -1;            /* T_tm5_TDD_r9 */
static int hf_lte_rrc_twoAntennaPortsForPUCCH_r10 = -1;  /* T_twoAntennaPortsForPUCCH_r10 */
static int hf_lte_rrc_tm9_With_8Tx_FDD_r10 = -1;  /* T_tm9_With_8Tx_FDD_r10 */
static int hf_lte_rrc_pmi_Disabling_r10 = -1;     /* T_pmi_Disabling_r10 */
static int hf_lte_rrc_crossCarrierScheduling_r10 = -1;  /* T_crossCarrierScheduling_r10 */
static int hf_lte_rrc_simultaneousPUCCH_PUSCH_r10_01 = -1;  /* T_simultaneousPUCCH_PUSCH_r10_01 */
static int hf_lte_rrc_multiClusterPUSCH_WithinCC_r10 = -1;  /* T_multiClusterPUSCH_WithinCC_r10 */
static int hf_lte_rrc_nonContiguousUL_RA_WithinCC_List_r10 = -1;  /* NonContiguousUL_RA_WithinCC_List_r10 */
static int hf_lte_rrc_crs_InterfHandl_r11 = -1;   /* T_crs_InterfHandl_r11 */
static int hf_lte_rrc_ePDCCH_r11 = -1;            /* T_ePDCCH_r11 */
static int hf_lte_rrc_multiACK_CSI_Reporting_r11 = -1;  /* T_multiACK_CSI_Reporting_r11 */
static int hf_lte_rrc_ss_CCH_InterfHandl_r11 = -1;  /* T_ss_CCH_InterfHandl_r11 */
static int hf_lte_rrc_tdd_SpecialSubframe_r11 = -1;  /* T_tdd_SpecialSubframe_r11 */
static int hf_lte_rrc_txDiv_PUCCH1b_ChSelect_r11 = -1;  /* T_txDiv_PUCCH1b_ChSelect_r11 */
static int hf_lte_rrc_ul_CoMP_r11 = -1;           /* T_ul_CoMP_r11 */
static int hf_lte_rrc_interBandTDD_CA_WithDifferentConfig_r11 = -1;  /* T_interBandTDD_CA_WithDifferentConfig_r11 */
static int hf_lte_rrc_e_HARQ_Pattern_FDD_r12 = -1;  /* T_e_HARQ_Pattern_FDD_r12 */
static int hf_lte_rrc_enhanced_4TxCodebook_r12 = -1;  /* T_enhanced_4TxCodebook_r12 */
static int hf_lte_rrc_tdd_FDD_CA_PCellDuplex_r12 = -1;  /* T_tdd_FDD_CA_PCellDuplex_r12 */
static int hf_lte_rrc_phy_TDD_ReConfig_TDD_PCell_r12 = -1;  /* T_phy_TDD_ReConfig_TDD_PCell_r12 */
static int hf_lte_rrc_phy_TDD_ReConfig_FDD_PCell_r12 = -1;  /* T_phy_TDD_ReConfig_FDD_PCell_r12 */
static int hf_lte_rrc_pusch_FeedbackMode_r12 = -1;  /* T_pusch_FeedbackMode_r12 */
static int hf_lte_rrc_pusch_SRS_PowerControl_SubframeSet_r12 = -1;  /* T_pusch_SRS_PowerControl_SubframeSet_r12 */
static int hf_lte_rrc_csi_SubframeSet_r12 = -1;   /* T_csi_SubframeSet_r12 */
static int hf_lte_rrc_noResourceRestrictionForTTIBundling_r12 = -1;  /* T_noResourceRestrictionForTTIBundling_r12 */
static int hf_lte_rrc_discoverySignalsInDeactSCell_r12 = -1;  /* T_discoverySignalsInDeactSCell_r12 */
static int hf_lte_rrc_naics_Capability_List_r12 = -1;  /* NAICS_Capability_List_r12 */
static int hf_lte_rrc_alternativeTBS_Indices_r12 = -1;  /* T_alternativeTBS_Indices_r12 */
static int hf_lte_rrc_aperiodicCSI_Reporting_r13 = -1;  /* T_aperiodicCSI_Reporting_r13 */
static int hf_lte_rrc_codebook_HARQ_ACK_r13 = -1;  /* T_codebook_HARQ_ACK_r13 */
static int hf_lte_rrc_crossCarrierScheduling_B5C_r13 = -1;  /* T_crossCarrierScheduling_B5C_r13 */
static int hf_lte_rrc_fdd_HARQ_TimingTDD_r13 = -1;  /* T_fdd_HARQ_TimingTDD_r13 */
static int hf_lte_rrc_maxNumberUpdatedCSI_Proc_r13 = -1;  /* INTEGER_5_32 */
static int hf_lte_rrc_pucch_Format4_r13 = -1;     /* T_pucch_Format4_r13 */
static int hf_lte_rrc_pucch_Format5_r13 = -1;     /* T_pucch_Format5_r13 */
static int hf_lte_rrc_pucch_SCell_r13 = -1;       /* T_pucch_SCell_r13 */
static int hf_lte_rrc_spatialBundling_HARQ_ACK_r13 = -1;  /* T_spatialBundling_HARQ_ACK_r13 */
static int hf_lte_rrc_supportedBlindDecoding_r13 = -1;  /* T_supportedBlindDecoding_r13 */
static int hf_lte_rrc_maxNumberDecoding_r13 = -1;  /* INTEGER_1_32 */
static int hf_lte_rrc_pdcch_CandidateReductions_r13_01 = -1;  /* T_pdcch_CandidateReductions_r13 */
static int hf_lte_rrc_skipMonitoringDCI_Format0_1A_r13 = -1;  /* T_skipMonitoringDCI_Format0_1A_r13 */
static int hf_lte_rrc_uci_PUSCH_Ext_r13 = -1;     /* T_uci_PUSCH_Ext_r13 */
static int hf_lte_rrc_crs_InterfMitigationTM10_r13 = -1;  /* T_crs_InterfMitigationTM10_r13 */
static int hf_lte_rrc_pdsch_CollisionHandling_r13 = -1;  /* T_pdsch_CollisionHandling_r13 */
static int hf_lte_rrc_mimo_UE_Parameters_r13 = -1;  /* MIMO_UE_Parameters_r13 */
static int hf_lte_rrc_cch_InterfMitigation_RefRecTypeA_r13 = -1;  /* T_cch_InterfMitigation_RefRecTypeA_r13 */
static int hf_lte_rrc_cch_InterfMitigation_RefRecTypeB_r13 = -1;  /* T_cch_InterfMitigation_RefRecTypeB_r13 */
static int hf_lte_rrc_cch_InterfMitigation_MaxNumCCs_r13 = -1;  /* INTEGER_1_maxServCell_r13 */
static int hf_lte_rrc_crs_InterfMitigationTM1toTM9_r13 = -1;  /* INTEGER_1_maxServCell_r13 */
static int hf_lte_rrc_mimo_UE_Parameters_v13e0 = -1;  /* MIMO_UE_Parameters_v13e0 */
static int hf_lte_rrc_ce_PUSCH_NB_MaxTBS_r14_01 = -1;  /* T_ce_PUSCH_NB_MaxTBS_r14_01 */
static int hf_lte_rrc_ce_PDSCH_PUSCH_MaxBandwidth_r14 = -1;  /* T_ce_PDSCH_PUSCH_MaxBandwidth_r14 */
static int hf_lte_rrc_ce_HARQ_AckBundling_r14_01 = -1;  /* T_ce_HARQ_AckBundling_r14_01 */
static int hf_lte_rrc_ce_PDSCH_TenProcesses_r14_01 = -1;  /* T_ce_PDSCH_TenProcesses_r14_01 */
static int hf_lte_rrc_ce_RetuningSymbols_r14 = -1;  /* T_ce_RetuningSymbols_r14 */
static int hf_lte_rrc_ce_PDSCH_PUSCH_Enhancement_r14 = -1;  /* T_ce_PDSCH_PUSCH_Enhancement_r14 */
static int hf_lte_rrc_ce_SchedulingEnhancement_r14_01 = -1;  /* T_ce_SchedulingEnhancement_r14_01 */
static int hf_lte_rrc_ce_SRS_Enhancement_r14 = -1;  /* T_ce_SRS_Enhancement_r14 */
static int hf_lte_rrc_ce_PUCCH_Enhancement_r14 = -1;  /* T_ce_PUCCH_Enhancement_r14 */
static int hf_lte_rrc_ce_ClosedLoopTxAntennaSelection_r14 = -1;  /* T_ce_ClosedLoopTxAntennaSelection_r14 */
static int hf_lte_rrc_tdd_SpecialSubframe_r14 = -1;  /* T_tdd_SpecialSubframe_r14 */
static int hf_lte_rrc_tdd_TTI_Bundling_r14 = -1;  /* T_tdd_TTI_Bundling_r14 */
static int hf_lte_rrc_dmrs_LessUpPTS_r14 = -1;    /* T_dmrs_LessUpPTS_r14 */
static int hf_lte_rrc_mimo_UE_Parameters_v1430 = -1;  /* MIMO_UE_Parameters_v1430 */
static int hf_lte_rrc_alternativeTBS_Index_r14 = -1;  /* T_alternativeTBS_Index_r14 */
static int hf_lte_rrc_feMBMS_Unicast_Parameters_r14 = -1;  /* FeMBMS_Unicast_Parameters_r14 */
static int hf_lte_rrc_ce_SRS_EnhancementWithoutComb4_r14 = -1;  /* T_ce_SRS_EnhancementWithoutComb4_r14 */
static int hf_lte_rrc_crs_LessDwPTS_r14 = -1;     /* T_crs_LessDwPTS_r14 */
static int hf_lte_rrc_mimo_UE_Parameters_v1470 = -1;  /* MIMO_UE_Parameters_v1470 */
static int hf_lte_rrc_srs_UpPTS_6sym_r14 = -1;    /* T_srs_UpPTS_6sym_r14 */
static int hf_lte_rrc_ssp10_TDD_Only_r14 = -1;    /* T_ssp10_TDD_Only_r14 */
static int hf_lte_rrc_stti_SPT_Capabilities_r15 = -1;  /* T_stti_SPT_Capabilities_r15 */
static int hf_lte_rrc_aperiodicCsi_ReportingSTTI_r15 = -1;  /* T_aperiodicCsi_ReportingSTTI_r15 */
static int hf_lte_rrc_dmrs_BasedSPDCCH_MBSFN_r15 = -1;  /* T_dmrs_BasedSPDCCH_MBSFN_r15 */
static int hf_lte_rrc_dmrs_BasedSPDCCH_nonMBSFN_r15 = -1;  /* T_dmrs_BasedSPDCCH_nonMBSFN_r15 */
static int hf_lte_rrc_dmrs_PositionPattern_r15 = -1;  /* T_dmrs_PositionPattern_r15 */
static int hf_lte_rrc_dmrs_SharingSubslotPDSCH_r15 = -1;  /* T_dmrs_SharingSubslotPDSCH_r15 */
static int hf_lte_rrc_dmrs_RepetitionSubslotPDSCH_r15 = -1;  /* T_dmrs_RepetitionSubslotPDSCH_r15 */
static int hf_lte_rrc_epdcch_SPT_differentCells_r15 = -1;  /* T_epdcch_SPT_differentCells_r15 */
static int hf_lte_rrc_epdcch_STTI_differentCells_r15 = -1;  /* T_epdcch_STTI_differentCells_r15 */
static int hf_lte_rrc_maxLayersSlotOrSubslotPUSCH_r15 = -1;  /* T_maxLayersSlotOrSubslotPUSCH_r15 */
static int hf_lte_rrc_maxNumberUpdatedCSI_Proc_SPT_r15 = -1;  /* INTEGER_5_32 */
static int hf_lte_rrc_maxNumberUpdatedCSI_Proc_STTI_Comb77_r15 = -1;  /* INTEGER_1_32 */
static int hf_lte_rrc_maxNumberUpdatedCSI_Proc_STTI_Comb27_r15 = -1;  /* INTEGER_1_32 */
static int hf_lte_rrc_maxNumberUpdatedCSI_Proc_STTI_Comb22_Set1_r15 = -1;  /* INTEGER_1_32 */
static int hf_lte_rrc_maxNumberUpdatedCSI_Proc_STTI_Comb22_Set2_r15 = -1;  /* INTEGER_1_32 */
static int hf_lte_rrc_mimo_UE_ParametersSTTI_r15 = -1;  /* MIMO_UE_Parameters_r13 */
static int hf_lte_rrc_mimo_UE_ParametersSTTI_v1530 = -1;  /* MIMO_UE_Parameters_v1430 */
static int hf_lte_rrc_numberOfBlindDecodesUSS_r15 = -1;  /* INTEGER_4_32 */
static int hf_lte_rrc_pdsch_SlotSubslotPDSCH_Decoding_r15 = -1;  /* T_pdsch_SlotSubslotPDSCH_Decoding_r15 */
static int hf_lte_rrc_powerUCI_SlotPUSCH = -1;    /* T_powerUCI_SlotPUSCH */
static int hf_lte_rrc_powerUCI_SubslotPUSCH = -1;  /* T_powerUCI_SubslotPUSCH */
static int hf_lte_rrc_slotPDSCH_TxDiv_TM9and10 = -1;  /* T_slotPDSCH_TxDiv_TM9and10 */
static int hf_lte_rrc_subslotPDSCH_TxDiv_TM9and10 = -1;  /* T_subslotPDSCH_TxDiv_TM9and10 */
static int hf_lte_rrc_spdcch_differentRS_types_r15 = -1;  /* T_spdcch_differentRS_types_r15 */
static int hf_lte_rrc_srs_DCI7_TriggeringFS2_r15 = -1;  /* T_srs_DCI7_TriggeringFS2_r15 */
static int hf_lte_rrc_sps_cyclicShift_r15 = -1;   /* T_sps_cyclicShift_r15 */
static int hf_lte_rrc_spdcch_Reuse_r15 = -1;      /* T_spdcch_Reuse_r15 */
static int hf_lte_rrc_sps_STTI_r15 = -1;          /* T_sps_STTI_r15 */
static int hf_lte_rrc_tm8_slotPDSCH_r15 = -1;     /* T_tm8_slotPDSCH_r15 */
static int hf_lte_rrc_tm9_slotSubslot_r15 = -1;   /* T_tm9_slotSubslot_r15 */
static int hf_lte_rrc_tm9_slotSubslotMBSFN_r15 = -1;  /* T_tm9_slotSubslotMBSFN_r15 */
static int hf_lte_rrc_tm10_slotSubslot_r15 = -1;  /* T_tm10_slotSubslot_r15 */
static int hf_lte_rrc_tm10_slotSubslotMBSFN_r15 = -1;  /* T_tm10_slotSubslotMBSFN_r15 */
static int hf_lte_rrc_txDiv_SPUCCH_r15 = -1;      /* T_txDiv_SPUCCH_r15 */
static int hf_lte_rrc_ul_AsyncHarqSharingDiff_TTI_Lengths_r15 = -1;  /* T_ul_AsyncHarqSharingDiff_TTI_Lengths_r15 */
static int hf_lte_rrc_ce_Capabilities_r15 = -1;   /* T_ce_Capabilities_r15 */
static int hf_lte_rrc_ce_CRS_IntfMitig_r15 = -1;  /* T_ce_CRS_IntfMitig_r15 */
static int hf_lte_rrc_ce_CQI_AlternativeTable_r15 = -1;  /* T_ce_CQI_AlternativeTable_r15 */
static int hf_lte_rrc_ce_PDSCH_FlexibleStartPRB_CE_ModeA_r15 = -1;  /* T_ce_PDSCH_FlexibleStartPRB_CE_ModeA_r15 */
static int hf_lte_rrc_ce_PDSCH_FlexibleStartPRB_CE_ModeB_r15 = -1;  /* T_ce_PDSCH_FlexibleStartPRB_CE_ModeB_r15 */
static int hf_lte_rrc_ce_PDSCH_64QAM_r15 = -1;    /* T_ce_PDSCH_64QAM_r15 */
static int hf_lte_rrc_ce_PUSCH_FlexibleStartPRB_CE_ModeA_r15 = -1;  /* T_ce_PUSCH_FlexibleStartPRB_CE_ModeA_r15 */
static int hf_lte_rrc_ce_PUSCH_FlexibleStartPRB_CE_ModeB_r15 = -1;  /* T_ce_PUSCH_FlexibleStartPRB_CE_ModeB_r15 */
static int hf_lte_rrc_ce_PUSCH_SubPRB_Allocation_r15 = -1;  /* T_ce_PUSCH_SubPRB_Allocation_r15 */
static int hf_lte_rrc_ce_UL_HARQ_ACK_Feedback_r15 = -1;  /* T_ce_UL_HARQ_ACK_Feedback_r15 */
static int hf_lte_rrc_shortCQI_ForSCellActivation_r15 = -1;  /* T_shortCQI_ForSCellActivation_r15 */
static int hf_lte_rrc_mimo_CBSR_AdvancedCSI_r15 = -1;  /* T_mimo_CBSR_AdvancedCSI_r15 */
static int hf_lte_rrc_crs_IntfMitig_r15 = -1;     /* T_crs_IntfMitig_r15 */
static int hf_lte_rrc_ul_PowerControlEnhancements_r15 = -1;  /* T_ul_PowerControlEnhancements_r15 */
static int hf_lte_rrc_urllc_Capabilities_r15 = -1;  /* T_urllc_Capabilities_r15 */
static int hf_lte_rrc_pdsch_RepSubframe_r15 = -1;  /* T_pdsch_RepSubframe_r15 */
static int hf_lte_rrc_pdsch_RepSlot_r15 = -1;     /* T_pdsch_RepSlot_r15 */
static int hf_lte_rrc_pdsch_RepSubslot_r15 = -1;  /* T_pdsch_RepSubslot_r15 */
static int hf_lte_rrc_pusch_SPS_MultiConfigSubframe_r15 = -1;  /* INTEGER_0_6 */
static int hf_lte_rrc_pusch_SPS_MaxConfigSubframe_r15 = -1;  /* INTEGER_0_31 */
static int hf_lte_rrc_pusch_SPS_MultiConfigSlot_r15 = -1;  /* INTEGER_0_6 */
static int hf_lte_rrc_pusch_SPS_MaxConfigSlot_r15 = -1;  /* INTEGER_0_31 */
static int hf_lte_rrc_pusch_SPS_MultiConfigSubslot_r15 = -1;  /* INTEGER_0_6 */
static int hf_lte_rrc_pusch_SPS_MaxConfigSubslot_r15 = -1;  /* INTEGER_0_31 */
static int hf_lte_rrc_pusch_SPS_SlotRepPCell_r15 = -1;  /* T_pusch_SPS_SlotRepPCell_r15 */
static int hf_lte_rrc_pusch_SPS_SlotRepPSCell_r15 = -1;  /* T_pusch_SPS_SlotRepPSCell_r15 */
static int hf_lte_rrc_pusch_SPS_SlotRepSCell_r15 = -1;  /* T_pusch_SPS_SlotRepSCell_r15 */
static int hf_lte_rrc_pusch_SPS_SubframeRepPCell_r15 = -1;  /* T_pusch_SPS_SubframeRepPCell_r15 */
static int hf_lte_rrc_pusch_SPS_SubframeRepPSCell_r15 = -1;  /* T_pusch_SPS_SubframeRepPSCell_r15 */
static int hf_lte_rrc_pusch_SPS_SubframeRepSCell_r15 = -1;  /* T_pusch_SPS_SubframeRepSCell_r15 */
static int hf_lte_rrc_pusch_SPS_SubslotRepPCell_r15 = -1;  /* T_pusch_SPS_SubslotRepPCell_r15 */
static int hf_lte_rrc_pusch_SPS_SubslotRepPSCell_r15 = -1;  /* T_pusch_SPS_SubslotRepPSCell_r15 */
static int hf_lte_rrc_pusch_SPS_SubslotRepSCell_r15 = -1;  /* T_pusch_SPS_SubslotRepSCell_r15 */
static int hf_lte_rrc_semiStaticCFI_r15 = -1;     /* T_semiStaticCFI_r15 */
static int hf_lte_rrc_semiStaticCFI_Pattern_r15 = -1;  /* T_semiStaticCFI_Pattern_r15 */
static int hf_lte_rrc_altMCS_Table_r15 = -1;      /* T_altMCS_Table_r15 */
static int hf_lte_rrc_stti_SPT_Capabilities_v1540 = -1;  /* T_stti_SPT_Capabilities_v1540 */
static int hf_lte_rrc_slotPDSCH_TxDiv_TM8_r15 = -1;  /* T_slotPDSCH_TxDiv_TM8_r15 */
static int hf_lte_rrc_crs_IM_TM1_toTM9_OneRX_Port_v1540 = -1;  /* T_crs_IM_TM1_toTM9_OneRX_Port_v1540 */
static int hf_lte_rrc_cch_IM_RefRecTypeA_OneRX_Port_v1540 = -1;  /* T_cch_IM_RefRecTypeA_OneRX_Port_v1540 */
static int hf_lte_rrc_dmrs_OverheadReduction_r15 = -1;  /* T_dmrs_OverheadReduction_r15 */
static int hf_lte_rrc_parametersTM9_r13 = -1;     /* MIMO_UE_ParametersPerTM_r13 */
static int hf_lte_rrc_parametersTM10_r13 = -1;    /* MIMO_UE_ParametersPerTM_r13 */
static int hf_lte_rrc_srs_EnhancementsTDD_r13 = -1;  /* T_srs_EnhancementsTDD_r13 */
static int hf_lte_rrc_srs_Enhancements_r13 = -1;  /* T_srs_Enhancements_r13 */
static int hf_lte_rrc_interferenceMeasRestriction_r13_01 = -1;  /* T_interferenceMeasRestriction_r13 */
static int hf_lte_rrc_mimo_WeightedLayersCapabilities_r13 = -1;  /* MIMO_WeightedLayersCapabilities_r13 */
static int hf_lte_rrc_parametersTM9_v1430 = -1;   /* MIMO_UE_ParametersPerTM_v1430 */
static int hf_lte_rrc_parametersTM10_v1430 = -1;  /* MIMO_UE_ParametersPerTM_v1430 */
static int hf_lte_rrc_parametersTM9_v1470 = -1;   /* MIMO_UE_ParametersPerTM_v1470 */
static int hf_lte_rrc_parametersTM10_v1470 = -1;  /* MIMO_UE_ParametersPerTM_v1470 */
static int hf_lte_rrc_nonPrecoded_r13_02 = -1;    /* MIMO_NonPrecodedCapabilities_r13 */
static int hf_lte_rrc_beamformed_r13_01 = -1;     /* MIMO_UE_BeamformedCapabilities_r13 */
static int hf_lte_rrc_channelMeasRestriction_r13_01 = -1;  /* T_channelMeasRestriction_r13_01 */
static int hf_lte_rrc_dmrs_Enhancements_r13 = -1;  /* T_dmrs_Enhancements_r13 */
static int hf_lte_rrc_csi_RS_EnhancementsTDD_r13 = -1;  /* T_csi_RS_EnhancementsTDD_r13 */
static int hf_lte_rrc_nzp_CSI_RS_AperiodicInfo_r14 = -1;  /* T_nzp_CSI_RS_AperiodicInfo_r14 */
static int hf_lte_rrc_nMaxProc_r14 = -1;          /* INTEGER_5_32 */
static int hf_lte_rrc_nMaxResource_r14 = -1;      /* T_nMaxResource_r14 */
static int hf_lte_rrc_nzp_CSI_RS_PeriodicInfo_r14 = -1;  /* T_nzp_CSI_RS_PeriodicInfo_r14 */
static int hf_lte_rrc_nMaxResource_r14_01 = -1;   /* T_nMaxResource_r14_01 */
static int hf_lte_rrc_zp_CSI_RS_AperiodicInfo_r14 = -1;  /* T_zp_CSI_RS_AperiodicInfo_r14 */
static int hf_lte_rrc_ul_dmrs_Enhancements_r14 = -1;  /* T_ul_dmrs_Enhancements_r14 */
static int hf_lte_rrc_densityReductionNP_r14 = -1;  /* T_densityReductionNP_r14 */
static int hf_lte_rrc_densityReductionBF_r14 = -1;  /* T_densityReductionBF_r14 */
static int hf_lte_rrc_hybridCSI_r14 = -1;         /* T_hybridCSI_r14 */
static int hf_lte_rrc_semiOL_r14 = -1;            /* T_semiOL_r14 */
static int hf_lte_rrc_csi_ReportingNP_r14 = -1;   /* T_csi_ReportingNP_r14 */
static int hf_lte_rrc_csi_ReportingAdvanced_r14 = -1;  /* T_csi_ReportingAdvanced_r14 */
static int hf_lte_rrc_csi_ReportingAdvancedMaxPorts_r14 = -1;  /* T_csi_ReportingAdvancedMaxPorts_r14 */
static int hf_lte_rrc_parametersTM9_r13_01 = -1;  /* MIMO_CA_ParametersPerBoBCPerTM_r13 */
static int hf_lte_rrc_parametersTM10_r13_01 = -1;  /* MIMO_CA_ParametersPerBoBCPerTM_r13 */
static int hf_lte_rrc_parametersTM9_r15 = -1;     /* MIMO_CA_ParametersPerBoBCPerTM_r15 */
static int hf_lte_rrc_parametersTM10_r15 = -1;    /* MIMO_CA_ParametersPerBoBCPerTM_r15 */
static int hf_lte_rrc_parametersTM9_v1430_01 = -1;  /* MIMO_CA_ParametersPerBoBCPerTM_v1430 */
static int hf_lte_rrc_parametersTM10_v1430_01 = -1;  /* MIMO_CA_ParametersPerBoBCPerTM_v1430 */
static int hf_lte_rrc_parametersTM9_v1470_01 = -1;  /* MIMO_CA_ParametersPerBoBCPerTM_v1470 */
static int hf_lte_rrc_parametersTM10_v1470_01 = -1;  /* MIMO_CA_ParametersPerBoBCPerTM_v1470 */
static int hf_lte_rrc_beamformed_r13_02 = -1;     /* MIMO_BeamformedCapabilityList_r13 */
static int hf_lte_rrc_dmrs_Enhancements_r13_01 = -1;  /* T_dmrs_Enhancements_r13_01 */
static int hf_lte_rrc_csi_ReportingNP_r14_01 = -1;  /* T_csi_ReportingNP_r14_01 */
static int hf_lte_rrc_csi_ReportingAdvanced_r14_01 = -1;  /* T_csi_ReportingAdvanced_r14_01 */
static int hf_lte_rrc_csi_ReportingAdvancedMaxPorts_r14_01 = -1;  /* T_csi_ReportingAdvancedMaxPorts_r14_01 */
static int hf_lte_rrc_dmrs_Enhancements_r13_02 = -1;  /* T_dmrs_Enhancements_r13_02 */
static int hf_lte_rrc_csi_ReportingNP_r14_02 = -1;  /* T_csi_ReportingNP_r14_02 */
static int hf_lte_rrc_csi_ReportingAdvanced_r14_02 = -1;  /* T_csi_ReportingAdvanced_r14_02 */
static int hf_lte_rrc_config1_r13 = -1;           /* T_config1_r13 */
static int hf_lte_rrc_config2_r13 = -1;           /* T_config2_r13 */
static int hf_lte_rrc_config3_r13 = -1;           /* T_config3_r13 */
static int hf_lte_rrc_config4_r13 = -1;           /* T_config4_r13 */
static int hf_lte_rrc_altCodebook_r13 = -1;       /* T_altCodebook_r13 */
static int hf_lte_rrc_mimo_BeamformedCapabilities_r13 = -1;  /* MIMO_BeamformedCapabilityList_r13 */
static int hf_lte_rrc_MIMO_BeamformedCapabilityList_r13_item = -1;  /* MIMO_BeamformedCapabilities_r13 */
static int hf_lte_rrc_k_Max_r13 = -1;             /* INTEGER_1_8 */
static int hf_lte_rrc_n_MaxList_r13 = -1;         /* BIT_STRING_SIZE_1_7 */
static int hf_lte_rrc_relWeightTwoLayers_r13 = -1;  /* T_relWeightTwoLayers_r13 */
static int hf_lte_rrc_relWeightFourLayers_r13 = -1;  /* T_relWeightFourLayers_r13 */
static int hf_lte_rrc_relWeightEightLayers_r13 = -1;  /* T_relWeightEightLayers_r13 */
static int hf_lte_rrc_totalWeightedLayers_r13 = -1;  /* INTEGER_2_128 */
static int hf_lte_rrc_NonContiguousUL_RA_WithinCC_List_r10_item = -1;  /* NonContiguousUL_RA_WithinCC_r10 */
static int hf_lte_rrc_nonContiguousUL_RA_WithinCC_Info_r10 = -1;  /* T_nonContiguousUL_RA_WithinCC_Info_r10 */
static int hf_lte_rrc_supportedBandListEUTRA = -1;  /* SupportedBandListEUTRA */
static int hf_lte_rrc_supportedBandListEUTRA_v9e0 = -1;  /* SupportedBandListEUTRA_v9e0 */
static int hf_lte_rrc_supportedBandCombination_r10 = -1;  /* SupportedBandCombination_r10 */
static int hf_lte_rrc_supportedBandCombinationExt_r10 = -1;  /* SupportedBandCombinationExt_r10 */
static int hf_lte_rrc_supportedBandCombination_v1090 = -1;  /* SupportedBandCombination_v1090 */
static int hf_lte_rrc_modifiedMPR_Behavior_r10 = -1;  /* T_modifiedMPR_Behavior_r10 */
static int hf_lte_rrc_supportedBandCombination_v10i0 = -1;  /* SupportedBandCombination_v10i0 */
static int hf_lte_rrc_multiNS_Pmax_r10 = -1;      /* T_multiNS_Pmax_r10 */
static int hf_lte_rrc_supportedBandCombination_v1130 = -1;  /* SupportedBandCombination_v1130 */
static int hf_lte_rrc_freqBandRetrieval_r11 = -1;  /* T_freqBandRetrieval_r11 */
static int hf_lte_rrc_requestedBands_r11 = -1;    /* SEQUENCE_SIZE_1_maxBands_OF_FreqBandIndicator_r11 */
static int hf_lte_rrc_requestedBands_r11_item = -1;  /* FreqBandIndicator_r11 */
static int hf_lte_rrc_supportedBandCombinationAdd_r11 = -1;  /* SupportedBandCombinationAdd_r11 */
static int hf_lte_rrc_supportedBandCombinationAdd_v11d0 = -1;  /* SupportedBandCombinationAdd_v11d0 */
static int hf_lte_rrc_supportedBandListEUTRA_v1250 = -1;  /* SupportedBandListEUTRA_v1250 */
static int hf_lte_rrc_supportedBandCombination_v1250 = -1;  /* SupportedBandCombination_v1250 */
static int hf_lte_rrc_supportedBandCombinationAdd_v1250 = -1;  /* SupportedBandCombinationAdd_v1250 */
static int hf_lte_rrc_freqBandPriorityAdjustment_r12 = -1;  /* T_freqBandPriorityAdjustment_r12 */
static int hf_lte_rrc_supportedBandCombination_v1270 = -1;  /* SupportedBandCombination_v1270 */
static int hf_lte_rrc_supportedBandCombinationAdd_v1270 = -1;  /* SupportedBandCombinationAdd_v1270 */
static int hf_lte_rrc_eNB_RequestedParameters_r13 = -1;  /* T_eNB_RequestedParameters_r13 */
static int hf_lte_rrc_reducedIntNonContCombRequested_r13 = -1;  /* T_reducedIntNonContCombRequested_r13 */
static int hf_lte_rrc_requestedCCsDL_r13 = -1;    /* INTEGER_2_32 */
static int hf_lte_rrc_requestedCCsUL_r13 = -1;    /* INTEGER_2_32 */
static int hf_lte_rrc_skipFallbackCombRequested_r13 = -1;  /* T_skipFallbackCombRequested_r13 */
static int hf_lte_rrc_maximumCCsRetrieval_r13 = -1;  /* T_maximumCCsRetrieval_r13 */
static int hf_lte_rrc_skipFallbackCombinations_r13 = -1;  /* T_skipFallbackCombinations_r13 */
static int hf_lte_rrc_reducedIntNonContComb_r13 = -1;  /* T_reducedIntNonContComb_r13 */
static int hf_lte_rrc_supportedBandListEUTRA_v1310 = -1;  /* SupportedBandListEUTRA_v1310 */
static int hf_lte_rrc_supportedBandCombinationReduced_r13 = -1;  /* SupportedBandCombinationReduced_r13 */
static int hf_lte_rrc_supportedBandListEUTRA_v1320 = -1;  /* SupportedBandListEUTRA_v1320 */
static int hf_lte_rrc_supportedBandCombination_v1320 = -1;  /* SupportedBandCombination_v1320 */
static int hf_lte_rrc_supportedBandCombinationAdd_v1320 = -1;  /* SupportedBandCombinationAdd_v1320 */
static int hf_lte_rrc_supportedBandCombinationReduced_v1320 = -1;  /* SupportedBandCombinationReduced_v1320 */
static int hf_lte_rrc_supportedBandCombination_v1380 = -1;  /* SupportedBandCombination_v1380 */
static int hf_lte_rrc_supportedBandCombinationAdd_v1380 = -1;  /* SupportedBandCombinationAdd_v1380 */
static int hf_lte_rrc_supportedBandCombinationReduced_v1380 = -1;  /* SupportedBandCombinationReduced_v1380 */
static int hf_lte_rrc_supportedBandCombination_v1390 = -1;  /* SupportedBandCombination_v1390 */
static int hf_lte_rrc_supportedBandCombinationAdd_v1390 = -1;  /* SupportedBandCombinationAdd_v1390 */
static int hf_lte_rrc_supportedBandCombinationReduced_v1390 = -1;  /* SupportedBandCombinationReduced_v1390 */
static int hf_lte_rrc_maxLayersMIMO_Indication_r12 = -1;  /* T_maxLayersMIMO_Indication_r12 */
static int hf_lte_rrc_supportedBandCombination_v1430 = -1;  /* SupportedBandCombination_v1430 */
static int hf_lte_rrc_supportedBandCombinationAdd_v1430 = -1;  /* SupportedBandCombinationAdd_v1430 */
static int hf_lte_rrc_supportedBandCombinationReduced_v1430 = -1;  /* SupportedBandCombinationReduced_v1430 */
static int hf_lte_rrc_eNB_RequestedParameters_v1430 = -1;  /* T_eNB_RequestedParameters_v1430 */
static int hf_lte_rrc_requestedDiffFallbackCombList_r14 = -1;  /* BandCombinationList_r14 */
static int hf_lte_rrc_diffFallbackCombReport_r14 = -1;  /* T_diffFallbackCombReport_r14 */
static int hf_lte_rrc_supportedBandCombination_v1450 = -1;  /* SupportedBandCombination_v1450 */
static int hf_lte_rrc_supportedBandCombinationAdd_v1450 = -1;  /* SupportedBandCombinationAdd_v1450 */
static int hf_lte_rrc_supportedBandCombinationReduced_v1450 = -1;  /* SupportedBandCombinationReduced_v1450 */
static int hf_lte_rrc_supportedBandCombination_v1470 = -1;  /* SupportedBandCombination_v1470 */
static int hf_lte_rrc_supportedBandCombinationAdd_v1470 = -1;  /* SupportedBandCombinationAdd_v1470 */
static int hf_lte_rrc_supportedBandCombinationReduced_v1470 = -1;  /* SupportedBandCombinationReduced_v1470 */
static int hf_lte_rrc_supportedBandCombination_v14b0 = -1;  /* SupportedBandCombination_v14b0 */
static int hf_lte_rrc_supportedBandCombinationAdd_v14b0 = -1;  /* SupportedBandCombinationAdd_v14b0 */
static int hf_lte_rrc_supportedBandCombinationReduced_v14b0 = -1;  /* SupportedBandCombinationReduced_v14b0 */
static int hf_lte_rrc_sTTI_SPT_Supported_r15 = -1;  /* T_sTTI_SPT_Supported_r15 */
static int hf_lte_rrc_supportedBandCombination_v1530 = -1;  /* SupportedBandCombination_v1530 */
static int hf_lte_rrc_supportedBandCombinationAdd_v1530 = -1;  /* SupportedBandCombinationAdd_v1530 */
static int hf_lte_rrc_supportedBandCombinationReduced_v1530 = -1;  /* SupportedBandCombinationReduced_v1530 */
static int hf_lte_rrc_powerClass_14dBm_r15 = -1;  /* T_powerClass_14dBm_r15 */
static int hf_lte_rrc_dl_1024QAM_ScalingFactor_r15 = -1;  /* T_dl_1024QAM_ScalingFactor_r15 */
static int hf_lte_rrc_dl_1024QAM_TotalWeightedLayers_r15 = -1;  /* INTEGER_0_10 */
static int hf_lte_rrc_skipProcessingDL_Slot_r15 = -1;  /* INTEGER_0_3 */
static int hf_lte_rrc_skipProcessingDL_SubSlot_r15 = -1;  /* INTEGER_0_3 */
static int hf_lte_rrc_skipProcessingUL_Slot_r15 = -1;  /* INTEGER_0_3 */
static int hf_lte_rrc_skipProcessingUL_SubSlot_r15 = -1;  /* INTEGER_0_3 */
static int hf_lte_rrc_frameStructureType_SPT_r15 = -1;  /* BIT_STRING_SIZE_3 */
static int hf_lte_rrc_maxNumberCCs_SPT_r15 = -1;  /* INTEGER_1_32 */
static int hf_lte_rrc_dl_1024QAM_Slot_r15 = -1;   /* T_dl_1024QAM_Slot_r15 */
static int hf_lte_rrc_dl_1024QAM_SubslotTA_1_r15 = -1;  /* T_dl_1024QAM_SubslotTA_1_r15 */
static int hf_lte_rrc_dl_1024QAM_SubslotTA_2_r15 = -1;  /* T_dl_1024QAM_SubslotTA_2_r15 */
static int hf_lte_rrc_simultaneousTx_differentTx_duration_r15 = -1;  /* T_simultaneousTx_differentTx_duration_r15 */
static int hf_lte_rrc_sTTI_CA_MIMO_ParametersDL_r15 = -1;  /* CA_MIMO_ParametersDL_r15 */
static int hf_lte_rrc_sTTI_CA_MIMO_ParametersUL_r15 = -1;  /* CA_MIMO_ParametersUL_r15 */
static int hf_lte_rrc_sTTI_FD_MIMO_Coexistence = -1;  /* T_sTTI_FD_MIMO_Coexistence */
static int hf_lte_rrc_sTTI_MIMO_CA_ParametersPerBoBCs_r15 = -1;  /* MIMO_CA_ParametersPerBoBC_r13 */
static int hf_lte_rrc_sTTI_MIMO_CA_ParametersPerBoBCs_v1530 = -1;  /* MIMO_CA_ParametersPerBoBC_v1430 */
static int hf_lte_rrc_sTTI_SupportedCombinations_r15 = -1;  /* STTI_SupportedCombinations_r15 */
static int hf_lte_rrc_sTTI_SupportedCSI_Proc_r15 = -1;  /* T_sTTI_SupportedCSI_Proc_r15 */
static int hf_lte_rrc_ul_256QAM_Slot_r15 = -1;    /* T_ul_256QAM_Slot_r15 */
static int hf_lte_rrc_ul_256QAM_Subslot_r15 = -1;  /* T_ul_256QAM_Subslot_r15 */
static int hf_lte_rrc_combination_22_r15 = -1;    /* DL_UL_CCs_r15 */
static int hf_lte_rrc_combination_77_r15 = -1;    /* DL_UL_CCs_r15 */
static int hf_lte_rrc_combination_27_r15 = -1;    /* DL_UL_CCs_r15 */
static int hf_lte_rrc_combination_22_27_r15 = -1;  /* SEQUENCE_SIZE_1_2_OF_DL_UL_CCs_r15 */
static int hf_lte_rrc_combination_22_27_r15_item = -1;  /* DL_UL_CCs_r15 */
static int hf_lte_rrc_combination_77_22_r15 = -1;  /* SEQUENCE_SIZE_1_2_OF_DL_UL_CCs_r15 */
static int hf_lte_rrc_combination_77_22_r15_item = -1;  /* DL_UL_CCs_r15 */
static int hf_lte_rrc_combination_77_27_r15 = -1;  /* SEQUENCE_SIZE_1_2_OF_DL_UL_CCs_r15 */
static int hf_lte_rrc_combination_77_27_r15_item = -1;  /* DL_UL_CCs_r15 */
static int hf_lte_rrc_maxNumberDL_CCs_r15 = -1;   /* INTEGER_1_32 */
static int hf_lte_rrc_maxNumberUL_CCs_r15 = -1;   /* INTEGER_1_32 */
static int hf_lte_rrc_SupportedBandCombination_r10_item = -1;  /* BandCombinationParameters_r10 */
static int hf_lte_rrc_SupportedBandCombinationExt_r10_item = -1;  /* BandCombinationParametersExt_r10 */
static int hf_lte_rrc_SupportedBandCombination_v1090_item = -1;  /* BandCombinationParameters_v1090 */
static int hf_lte_rrc_SupportedBandCombination_v10i0_item = -1;  /* BandCombinationParameters_v10i0 */
static int hf_lte_rrc_SupportedBandCombination_v1130_item = -1;  /* BandCombinationParameters_v1130 */
static int hf_lte_rrc_SupportedBandCombination_v1250_item = -1;  /* BandCombinationParameters_v1250 */
static int hf_lte_rrc_SupportedBandCombination_v1270_item = -1;  /* BandCombinationParameters_v1270 */
static int hf_lte_rrc_SupportedBandCombination_v1320_item = -1;  /* BandCombinationParameters_v1320 */
static int hf_lte_rrc_SupportedBandCombination_v1380_item = -1;  /* BandCombinationParameters_v1380 */
static int hf_lte_rrc_SupportedBandCombination_v1390_item = -1;  /* BandCombinationParameters_v1390 */
static int hf_lte_rrc_SupportedBandCombination_v1430_item = -1;  /* BandCombinationParameters_v1430 */
static int hf_lte_rrc_SupportedBandCombination_v1450_item = -1;  /* BandCombinationParameters_v1450 */
static int hf_lte_rrc_SupportedBandCombination_v1470_item = -1;  /* BandCombinationParameters_v1470 */
static int hf_lte_rrc_SupportedBandCombination_v14b0_item = -1;  /* BandCombinationParameters_v14b0 */
static int hf_lte_rrc_SupportedBandCombination_v1530_item = -1;  /* BandCombinationParameters_v1530 */
static int hf_lte_rrc_SupportedBandCombinationAdd_r11_item = -1;  /* BandCombinationParameters_r11 */
static int hf_lte_rrc_SupportedBandCombinationAdd_v11d0_item = -1;  /* BandCombinationParameters_v10i0 */
static int hf_lte_rrc_SupportedBandCombinationAdd_v1250_item = -1;  /* BandCombinationParameters_v1250 */
static int hf_lte_rrc_SupportedBandCombinationAdd_v1270_item = -1;  /* BandCombinationParameters_v1270 */
static int hf_lte_rrc_SupportedBandCombinationAdd_v1320_item = -1;  /* BandCombinationParameters_v1320 */
static int hf_lte_rrc_SupportedBandCombinationAdd_v1380_item = -1;  /* BandCombinationParameters_v1380 */
static int hf_lte_rrc_SupportedBandCombinationAdd_v1390_item = -1;  /* BandCombinationParameters_v1390 */
static int hf_lte_rrc_SupportedBandCombinationAdd_v1430_item = -1;  /* BandCombinationParameters_v1430 */
static int hf_lte_rrc_SupportedBandCombinationAdd_v1450_item = -1;  /* BandCombinationParameters_v1450 */
static int hf_lte_rrc_SupportedBandCombinationAdd_v1470_item = -1;  /* BandCombinationParameters_v1470 */
static int hf_lte_rrc_SupportedBandCombinationAdd_v14b0_item = -1;  /* BandCombinationParameters_v14b0 */
static int hf_lte_rrc_SupportedBandCombinationAdd_v1530_item = -1;  /* BandCombinationParameters_v1530 */
static int hf_lte_rrc_SupportedBandCombinationReduced_r13_item = -1;  /* BandCombinationParameters_r13 */
static int hf_lte_rrc_SupportedBandCombinationReduced_v1320_item = -1;  /* BandCombinationParameters_v1320 */
static int hf_lte_rrc_SupportedBandCombinationReduced_v1380_item = -1;  /* BandCombinationParameters_v1380 */
static int hf_lte_rrc_SupportedBandCombinationReduced_v1390_item = -1;  /* BandCombinationParameters_v1390 */
static int hf_lte_rrc_SupportedBandCombinationReduced_v1430_item = -1;  /* BandCombinationParameters_v1430 */
static int hf_lte_rrc_SupportedBandCombinationReduced_v1450_item = -1;  /* BandCombinationParameters_v1450 */
static int hf_lte_rrc_SupportedBandCombinationReduced_v1470_item = -1;  /* BandCombinationParameters_v1470 */
static int hf_lte_rrc_SupportedBandCombinationReduced_v14b0_item = -1;  /* BandCombinationParameters_v14b0 */
static int hf_lte_rrc_SupportedBandCombinationReduced_v1530_item = -1;  /* BandCombinationParameters_v1530 */
static int hf_lte_rrc_BandCombinationParameters_r10_item = -1;  /* BandParameters_r10 */
static int hf_lte_rrc_supportedBandwidthCombinationSet_r10 = -1;  /* SupportedBandwidthCombinationSet_r10 */
static int hf_lte_rrc_BandCombinationParameters_v1090_item = -1;  /* BandParameters_v1090 */
static int hf_lte_rrc_bandParameterList_v10i0 = -1;  /* SEQUENCE_SIZE_1_maxSimultaneousBands_r10_OF_BandParameters_v10i0 */
static int hf_lte_rrc_bandParameterList_v10i0_item = -1;  /* BandParameters_v10i0 */
static int hf_lte_rrc_multipleTimingAdvance_r11 = -1;  /* T_multipleTimingAdvance_r11 */
static int hf_lte_rrc_simultaneousRx_Tx_r11 = -1;  /* T_simultaneousRx_Tx_r11 */
static int hf_lte_rrc_bandParameterList_r11 = -1;  /* SEQUENCE_SIZE_1_maxSimultaneousBands_r10_OF_BandParameters_v1130 */
static int hf_lte_rrc_bandParameterList_r11_item = -1;  /* BandParameters_v1130 */
static int hf_lte_rrc_bandParameterList_r11_01 = -1;  /* SEQUENCE_SIZE_1_maxSimultaneousBands_r10_OF_BandParameters_r11 */
static int hf_lte_rrc_bandParameterList_r11_item_01 = -1;  /* BandParameters_r11 */
static int hf_lte_rrc_supportedBandwidthCombinationSet_r11 = -1;  /* SupportedBandwidthCombinationSet_r10 */
static int hf_lte_rrc_multipleTimingAdvance_r11_01 = -1;  /* T_multipleTimingAdvance_r11_01 */
static int hf_lte_rrc_simultaneousRx_Tx_r11_01 = -1;  /* T_simultaneousRx_Tx_r11_01 */
static int hf_lte_rrc_bandInfoEUTRA_r11 = -1;     /* BandInfoEUTRA */
static int hf_lte_rrc_dc_Support_r12 = -1;        /* T_dc_Support_r12 */
static int hf_lte_rrc_asynchronous_r12 = -1;      /* T_asynchronous_r12 */
static int hf_lte_rrc_supportedCellGrouping_r12 = -1;  /* T_supportedCellGrouping_r12 */
static int hf_lte_rrc_threeEntries_r12 = -1;      /* BIT_STRING_SIZE_3 */
static int hf_lte_rrc_fourEntries_r12 = -1;       /* BIT_STRING_SIZE_7 */
static int hf_lte_rrc_fiveEntries_r12 = -1;       /* BIT_STRING_SIZE_15 */
static int hf_lte_rrc_supportedNAICS_2CRS_AP_r12 = -1;  /* BIT_STRING_SIZE_1_maxNAICS_Entries_r12 */
static int hf_lte_rrc_commSupportedBandsPerBC_r12 = -1;  /* BIT_STRING_SIZE_1_maxBands */
static int hf_lte_rrc_bandParameterList_v1270 = -1;  /* SEQUENCE_SIZE_1_maxSimultaneousBands_r10_OF_BandParameters_v1270 */
static int hf_lte_rrc_bandParameterList_v1270_item = -1;  /* BandParameters_v1270 */
static int hf_lte_rrc_differentFallbackSupported_r13 = -1;  /* T_differentFallbackSupported_r13 */
static int hf_lte_rrc_bandParameterList_r13 = -1;  /* SEQUENCE_SIZE_1_maxSimultaneousBands_r10_OF_BandParameters_r13 */
static int hf_lte_rrc_bandParameterList_r13_item = -1;  /* BandParameters_r13 */
static int hf_lte_rrc_supportedBandwidthCombinationSet_r13 = -1;  /* SupportedBandwidthCombinationSet_r10 */
static int hf_lte_rrc_multipleTimingAdvance_r13 = -1;  /* T_multipleTimingAdvance_r13 */
static int hf_lte_rrc_simultaneousRx_Tx_r13 = -1;  /* T_simultaneousRx_Tx_r13 */
static int hf_lte_rrc_bandInfoEUTRA_r13 = -1;     /* BandInfoEUTRA */
static int hf_lte_rrc_dc_Support_r13 = -1;        /* T_dc_Support_r13 */
static int hf_lte_rrc_asynchronous_r13 = -1;      /* T_asynchronous_r13 */
static int hf_lte_rrc_supportedCellGrouping_r13 = -1;  /* T_supportedCellGrouping_r13 */
static int hf_lte_rrc_threeEntries_r13 = -1;      /* BIT_STRING_SIZE_3 */
static int hf_lte_rrc_fourEntries_r13 = -1;       /* BIT_STRING_SIZE_7 */
static int hf_lte_rrc_fiveEntries_r13 = -1;       /* BIT_STRING_SIZE_15 */
static int hf_lte_rrc_supportedNAICS_2CRS_AP_r13 = -1;  /* BIT_STRING_SIZE_1_maxNAICS_Entries_r12 */
static int hf_lte_rrc_commSupportedBandsPerBC_r13 = -1;  /* BIT_STRING_SIZE_1_maxBands */
static int hf_lte_rrc_bandParameterList_v1320 = -1;  /* SEQUENCE_SIZE_1_maxSimultaneousBands_r10_OF_BandParameters_v1320 */
static int hf_lte_rrc_bandParameterList_v1320_item = -1;  /* BandParameters_v1320 */
static int hf_lte_rrc_additionalRx_Tx_PerformanceReq_r13 = -1;  /* T_additionalRx_Tx_PerformanceReq_r13 */
static int hf_lte_rrc_bandParameterList_v1380 = -1;  /* SEQUENCE_SIZE_1_maxSimultaneousBands_r10_OF_BandParameters_v1380 */
static int hf_lte_rrc_bandParameterList_v1380_item = -1;  /* BandParameters_v1380 */
static int hf_lte_rrc_ue_CA_PowerClass_N_r13 = -1;  /* T_ue_CA_PowerClass_N_r13 */
static int hf_lte_rrc_bandParameterList_v1430 = -1;  /* SEQUENCE_SIZE_1_maxSimultaneousBands_r10_OF_BandParameters_v1430 */
static int hf_lte_rrc_bandParameterList_v1430_item = -1;  /* BandParameters_v1430 */
static int hf_lte_rrc_v2x_SupportedTxBandCombListPerBC_r14 = -1;  /* BIT_STRING_SIZE_1_maxBandComb_r13 */
static int hf_lte_rrc_v2x_SupportedRxBandCombListPerBC_r14 = -1;  /* BIT_STRING_SIZE_1_maxBandComb_r13 */
static int hf_lte_rrc_bandParameterList_v1450 = -1;  /* SEQUENCE_SIZE_1_maxSimultaneousBands_r10_OF_BandParameters_v1450 */
static int hf_lte_rrc_bandParameterList_v1450_item = -1;  /* BandParameters_v1450 */
static int hf_lte_rrc_bandParameterList_v1470 = -1;  /* SEQUENCE_SIZE_1_maxSimultaneousBands_r10_OF_BandParameters_v1470 */
static int hf_lte_rrc_bandParameterList_v1470_item = -1;  /* BandParameters_v1470 */
static int hf_lte_rrc_srs_MaxSimultaneousCCs_r14 = -1;  /* INTEGER_1_31 */
static int hf_lte_rrc_bandParameterList_v14b0 = -1;  /* SEQUENCE_SIZE_1_maxSimultaneousBands_r10_OF_BandParameters_v14b0 */
static int hf_lte_rrc_bandParameterList_v14b0_item = -1;  /* BandParameters_v14b0 */
static int hf_lte_rrc_bandParameterList_v1530 = -1;  /* SEQUENCE_SIZE_1_maxSimultaneousBands_r10_OF_BandParameters_v1530 */
static int hf_lte_rrc_bandParameterList_v1530_item = -1;  /* BandParameters_v1530 */
static int hf_lte_rrc_spt_Parameters_r15 = -1;    /* SPT_Parameters_r15 */
static int hf_lte_rrc_bandEUTRA_r10 = -1;         /* T_bandEUTRA_r10 */
static int hf_lte_rrc_bandParametersUL_r10 = -1;  /* BandParametersUL_r10 */
static int hf_lte_rrc_bandParametersDL_r10 = -1;  /* BandParametersDL_r10 */
static int hf_lte_rrc_bandEUTRA_v1090 = -1;       /* FreqBandIndicator_v9e0 */
static int hf_lte_rrc_bandParametersDL_v10i0 = -1;  /* SEQUENCE_SIZE_1_maxBandwidthClass_r10_OF_CA_MIMO_ParametersDL_v10i0 */
static int hf_lte_rrc_bandParametersDL_v10i0_item = -1;  /* CA_MIMO_ParametersDL_v10i0 */
static int hf_lte_rrc_supportedCSI_Proc_r11 = -1;  /* T_supportedCSI_Proc_r11 */
static int hf_lte_rrc_bandEUTRA_r11 = -1;         /* FreqBandIndicator_r11 */
static int hf_lte_rrc_bandParametersUL_r11 = -1;  /* BandParametersUL_r10 */
static int hf_lte_rrc_bandParametersDL_r11 = -1;  /* BandParametersDL_r10 */
static int hf_lte_rrc_supportedCSI_Proc_r11_01 = -1;  /* T_supportedCSI_Proc_r11_01 */
static int hf_lte_rrc_bandParametersDL_v1270 = -1;  /* SEQUENCE_SIZE_1_maxBandwidthClass_r10_OF_CA_MIMO_ParametersDL_v1270 */
static int hf_lte_rrc_bandParametersDL_v1270_item = -1;  /* CA_MIMO_ParametersDL_v1270 */
static int hf_lte_rrc_bandEUTRA_r13 = -1;         /* FreqBandIndicator_r11 */
static int hf_lte_rrc_bandParametersUL_r13 = -1;  /* BandParametersUL_r13 */
static int hf_lte_rrc_bandParametersDL_r13 = -1;  /* BandParametersDL_r13 */
static int hf_lte_rrc_supportedCSI_Proc_r13 = -1;  /* T_supportedCSI_Proc_r13 */
static int hf_lte_rrc_bandParametersDL_v1320 = -1;  /* MIMO_CA_ParametersPerBoBC_r13 */
static int hf_lte_rrc_txAntennaSwitchDL_r13 = -1;  /* INTEGER_1_32 */
static int hf_lte_rrc_txAntennaSwitchUL_r13 = -1;  /* INTEGER_1_32 */
static int hf_lte_rrc_bandParametersDL_v1430 = -1;  /* MIMO_CA_ParametersPerBoBC_v1430 */
static int hf_lte_rrc_ul_256QAM_r14 = -1;         /* T_ul_256QAM_r14 */
static int hf_lte_rrc_ul_256QAM_perCC_InfoList_r14 = -1;  /* SEQUENCE_SIZE_2_maxServCell_r13_OF_UL_256QAM_perCC_Info_r14 */
static int hf_lte_rrc_ul_256QAM_perCC_InfoList_r14_item = -1;  /* UL_256QAM_perCC_Info_r14 */
static int hf_lte_rrc_srs_CapabilityPerBandPairList_r14 = -1;  /* SEQUENCE_SIZE_1_maxSimultaneousBands_r10_OF_SRS_CapabilityPerBandPair_r14 */
static int hf_lte_rrc_srs_CapabilityPerBandPairList_r14_item = -1;  /* SRS_CapabilityPerBandPair_r14 */
static int hf_lte_rrc_must_CapabilityPerBand_r14 = -1;  /* MUST_Parameters_r14 */
static int hf_lte_rrc_bandParametersDL_v1470 = -1;  /* MIMO_CA_ParametersPerBoBC_v1470 */
static int hf_lte_rrc_srs_CapabilityPerBandPairList_v14b0 = -1;  /* SEQUENCE_SIZE_1_maxSimultaneousBands_r10_OF_SRS_CapabilityPerBandPair_v14b0 */
static int hf_lte_rrc_srs_CapabilityPerBandPairList_v14b0_item = -1;  /* SRS_CapabilityPerBandPair_v14b0 */
static int hf_lte_rrc_ue_TxAntennaSelection_SRS_1T4R_r15 = -1;  /* T_ue_TxAntennaSelection_SRS_1T4R_r15 */
static int hf_lte_rrc_ue_TxAntennaSelection_SRS_2T4R_2Pairs_r15 = -1;  /* T_ue_TxAntennaSelection_SRS_2T4R_2Pairs_r15 */
static int hf_lte_rrc_ue_TxAntennaSelection_SRS_2T4R_3Pairs_r15 = -1;  /* T_ue_TxAntennaSelection_SRS_2T4R_3Pairs_r15 */
static int hf_lte_rrc_dl_1024QAM_r15 = -1;        /* T_dl_1024QAM_r15 */
static int hf_lte_rrc_qcl_TypeC_Operation_r15 = -1;  /* T_qcl_TypeC_Operation_r15 */
static int hf_lte_rrc_qcl_CRI_BasedCSI_Reporting_r15 = -1;  /* T_qcl_CRI_BasedCSI_Reporting_r15 */
static int hf_lte_rrc_stti_SPT_BandParameters_r15 = -1;  /* STTI_SPT_BandParameters_r15 */
static int hf_lte_rrc_v2x_FreqBandEUTRA_r14 = -1;  /* FreqBandIndicator_r11 */
static int hf_lte_rrc_bandParametersTxSL_r14 = -1;  /* BandParametersTxSL_r14 */
static int hf_lte_rrc_bandParametersRxSL_r14 = -1;  /* BandParametersRxSL_r14 */
static int hf_lte_rrc_v2x_EnhancedHighReception_r15 = -1;  /* T_v2x_EnhancedHighReception_r15 */
static int hf_lte_rrc_v2x_BandwidthClassTxSL_r14 = -1;  /* V2X_BandwidthClassSL_r14 */
static int hf_lte_rrc_v2x_eNB_Scheduled_r14 = -1;  /* T_v2x_eNB_Scheduled_r14 */
static int hf_lte_rrc_v2x_HighPower_r14 = -1;     /* T_v2x_HighPower_r14 */
static int hf_lte_rrc_v2x_BandwidthClassRxSL_r14 = -1;  /* V2X_BandwidthClassSL_r14 */
static int hf_lte_rrc_v2x_HighReception_r14 = -1;  /* T_v2x_HighReception_r14 */
static int hf_lte_rrc_V2X_BandwidthClassSL_r14_item = -1;  /* V2X_BandwidthClass_r14 */
static int hf_lte_rrc_ul_256QAM_perCC_r14 = -1;   /* T_ul_256QAM_perCC_r14 */
static int hf_lte_rrc_mimo_CA_ParametersPerBoBC_r15 = -1;  /* MIMO_CA_ParametersPerBoBC_r15 */
static int hf_lte_rrc_featureSetPerCC_ListDL_r15 = -1;  /* SEQUENCE_SIZE_1_maxServCell_r13_OF_FeatureSetDL_PerCC_Id_r15 */
static int hf_lte_rrc_featureSetPerCC_ListDL_r15_item = -1;  /* FeatureSetDL_PerCC_Id_r15 */
static int hf_lte_rrc_dl_1024QAM_r15_01 = -1;     /* T_dl_1024QAM_r15_01 */
static int hf_lte_rrc_fourLayerTM3_TM4_r15 = -1;  /* T_fourLayerTM3_TM4_r15 */
static int hf_lte_rrc_supportedMIMO_CapabilityDL_MRDC_r15 = -1;  /* MIMO_CapabilityDL_r10 */
static int hf_lte_rrc_supportedCSI_Proc_r15 = -1;  /* T_supportedCSI_Proc_r15 */
static int hf_lte_rrc_featureSetPerCC_ListUL_r15 = -1;  /* SEQUENCE_SIZE_1_maxServCell_r13_OF_FeatureSetUL_PerCC_Id_r15 */
static int hf_lte_rrc_featureSetPerCC_ListUL_r15_item = -1;  /* FeatureSetUL_PerCC_Id_r15 */
static int hf_lte_rrc_supportedMIMO_CapabilityUL_r15 = -1;  /* MIMO_CapabilityUL_r10 */
static int hf_lte_rrc_ul_256QAM_r15 = -1;         /* T_ul_256QAM_r15 */
static int hf_lte_rrc_BandParametersUL_r10_item = -1;  /* CA_MIMO_ParametersUL_r10 */
static int hf_lte_rrc_ca_BandwidthClassUL_r10 = -1;  /* CA_BandwidthClass_r10 */
static int hf_lte_rrc_supportedMIMO_CapabilityUL_r10 = -1;  /* MIMO_CapabilityUL_r10 */
static int hf_lte_rrc_BandParametersDL_r10_item = -1;  /* CA_MIMO_ParametersDL_r10 */
static int hf_lte_rrc_ca_BandwidthClassDL_r10 = -1;  /* CA_BandwidthClass_r10 */
static int hf_lte_rrc_supportedMIMO_CapabilityDL_r10 = -1;  /* MIMO_CapabilityDL_r10 */
static int hf_lte_rrc_fourLayerTM3_TM4_r10 = -1;  /* T_fourLayerTM3_TM4_r10 */
static int hf_lte_rrc_intraBandContiguousCC_InfoList_r12 = -1;  /* SEQUENCE_SIZE_1_maxServCell_r10_OF_IntraBandContiguousCC_Info_r12 */
static int hf_lte_rrc_intraBandContiguousCC_InfoList_r12_item = -1;  /* IntraBandContiguousCC_Info_r12 */
static int hf_lte_rrc_ca_BandwidthClassDL_r13 = -1;  /* CA_BandwidthClass_r10 */
static int hf_lte_rrc_supportedMIMO_CapabilityDL_r13 = -1;  /* MIMO_CapabilityDL_r10 */
static int hf_lte_rrc_fourLayerTM3_TM4_r13 = -1;  /* T_fourLayerTM3_TM4_r13 */
static int hf_lte_rrc_intraBandContiguousCC_InfoList_r13 = -1;  /* SEQUENCE_SIZE_1_maxServCell_r13_OF_IntraBandContiguousCC_Info_r12 */
static int hf_lte_rrc_intraBandContiguousCC_InfoList_r13_item = -1;  /* IntraBandContiguousCC_Info_r12 */
static int hf_lte_rrc_supportedMIMO_CapabilityDL_r15 = -1;  /* MIMO_CapabilityDL_r10 */
static int hf_lte_rrc_fourLayerTM3_TM4_r15_01 = -1;  /* T_fourLayerTM3_TM4_r15_01 */
static int hf_lte_rrc_intraBandContiguousCC_InfoList_r15 = -1;  /* SEQUENCE_SIZE_1_maxServCell_r13_OF_IntraBandContiguousCC_Info_r12 */
static int hf_lte_rrc_intraBandContiguousCC_InfoList_r15_item = -1;  /* IntraBandContiguousCC_Info_r12 */
static int hf_lte_rrc_fourLayerTM3_TM4_perCC_r12 = -1;  /* T_fourLayerTM3_TM4_perCC_r12 */
static int hf_lte_rrc_supportedMIMO_CapabilityDL_r12 = -1;  /* MIMO_CapabilityDL_r10 */
static int hf_lte_rrc_supportedCSI_Proc_r12 = -1;  /* T_supportedCSI_Proc_r12 */
static int hf_lte_rrc_must_TM234_UpTo2Tx_r14 = -1;  /* T_must_TM234_UpTo2Tx_r14 */
static int hf_lte_rrc_must_TM89_UpToOneInterferingLayer_r14 = -1;  /* T_must_TM89_UpToOneInterferingLayer_r14 */
static int hf_lte_rrc_must_TM10_UpToOneInterferingLayer_r14 = -1;  /* T_must_TM10_UpToOneInterferingLayer_r14 */
static int hf_lte_rrc_must_TM89_UpToThreeInterferingLayers_r14 = -1;  /* T_must_TM89_UpToThreeInterferingLayers_r14 */
static int hf_lte_rrc_must_TM10_UpToThreeInterferingLayers_r14 = -1;  /* T_must_TM10_UpToThreeInterferingLayers_r14 */
static int hf_lte_rrc_SupportedBandListEUTRA_item = -1;  /* SupportedBandEUTRA */
static int hf_lte_rrc_SupportedBandListEUTRA_v9e0_item = -1;  /* SupportedBandEUTRA_v9e0 */
static int hf_lte_rrc_SupportedBandListEUTRA_v1250_item = -1;  /* SupportedBandEUTRA_v1250 */
static int hf_lte_rrc_SupportedBandListEUTRA_v1310_item = -1;  /* SupportedBandEUTRA_v1310 */
static int hf_lte_rrc_SupportedBandListEUTRA_v1320_item = -1;  /* SupportedBandEUTRA_v1320 */
static int hf_lte_rrc_bandEUTRA = -1;             /* FreqBandIndicator */
static int hf_lte_rrc_halfDuplex = -1;            /* BOOLEAN */
static int hf_lte_rrc_bandEUTRA_v9e0 = -1;        /* FreqBandIndicator_v9e0 */
static int hf_lte_rrc_dl_256QAM_r12 = -1;         /* T_dl_256QAM_r12 */
static int hf_lte_rrc_ul_64QAM_r12 = -1;          /* T_ul_64QAM_r12 */
static int hf_lte_rrc_ue_PowerClass_5_r13 = -1;   /* T_ue_PowerClass_5_r13 */
static int hf_lte_rrc_intraFreq_CE_NeedForGaps_r13 = -1;  /* T_intraFreq_CE_NeedForGaps_r13 */
static int hf_lte_rrc_ue_PowerClass_N_r13 = -1;   /* T_ue_PowerClass_N_r13 */
static int hf_lte_rrc_bandListEUTRA = -1;         /* BandListEUTRA */
static int hf_lte_rrc_bandCombinationListEUTRA_r10 = -1;  /* BandCombinationListEUTRA_r10 */
static int hf_lte_rrc_rsrqMeasWideband_r11 = -1;  /* T_rsrqMeasWideband_r11 */
static int hf_lte_rrc_benefitsFromInterruption_r11 = -1;  /* T_benefitsFromInterruption_r11 */
static int hf_lte_rrc_timerT312_r12 = -1;         /* T_timerT312_r12 */
static int hf_lte_rrc_alternativeTimeToTrigger_r12_01 = -1;  /* T_alternativeTimeToTrigger_r12_01 */
static int hf_lte_rrc_incMonEUTRA_r12 = -1;       /* T_incMonEUTRA_r12 */
static int hf_lte_rrc_incMonUTRA_r12 = -1;        /* T_incMonUTRA_r12 */
static int hf_lte_rrc_extendedMaxMeasId_r12 = -1;  /* T_extendedMaxMeasId_r12 */
static int hf_lte_rrc_extendedRSRQ_LowerRange_r12 = -1;  /* T_extendedRSRQ_LowerRange_r12 */
static int hf_lte_rrc_rsrq_OnAllSymbols_r12 = -1;  /* T_rsrq_OnAllSymbols_r12 */
static int hf_lte_rrc_crs_DiscoverySignalsMeas_r12 = -1;  /* T_crs_DiscoverySignalsMeas_r12 */
static int hf_lte_rrc_csi_RS_DiscoverySignalsMeas_r12 = -1;  /* T_csi_RS_DiscoverySignalsMeas_r12 */
static int hf_lte_rrc_rs_SINR_Meas_r13 = -1;      /* T_rs_SINR_Meas_r13 */
static int hf_lte_rrc_whiteCellList_r13 = -1;     /* T_whiteCellList_r13 */
static int hf_lte_rrc_extendedMaxObjectId_r13 = -1;  /* T_extendedMaxObjectId_r13 */
static int hf_lte_rrc_ul_PDCP_Delay_r13 = -1;     /* T_ul_PDCP_Delay_r13 */
static int hf_lte_rrc_extendedFreqPriorities_r13 = -1;  /* T_extendedFreqPriorities_r13 */
static int hf_lte_rrc_multiBandInfoReport_r13 = -1;  /* T_multiBandInfoReport_r13 */
static int hf_lte_rrc_rssi_AndChannelOccupancyReporting_r13 = -1;  /* T_rssi_AndChannelOccupancyReporting_r13 */
static int hf_lte_rrc_ceMeasurements_r14 = -1;    /* T_ceMeasurements_r14 */
static int hf_lte_rrc_ncsg_r14 = -1;              /* T_ncsg_r14 */
static int hf_lte_rrc_shortMeasurementGap_r14 = -1;  /* T_shortMeasurementGap_r14 */
static int hf_lte_rrc_perServingCellMeasurementGap_r14 = -1;  /* T_perServingCellMeasurementGap_r14 */
static int hf_lte_rrc_nonUniformGap_r14 = -1;     /* T_nonUniformGap_r14 */
static int hf_lte_rrc_measGapPatterns_r15 = -1;   /* T_measGapPatterns_r15 */
static int hf_lte_rrc_qoe_MeasReport_r15 = -1;    /* T_qoe_MeasReport_r15 */
static int hf_lte_rrc_qoe_MTSI_MeasReport_r15 = -1;  /* T_qoe_MTSI_MeasReport_r15 */
static int hf_lte_rrc_ca_IdleModeMeasurements_r15 = -1;  /* T_ca_IdleModeMeasurements_r15 */
static int hf_lte_rrc_ca_IdleModeValidityArea_r15 = -1;  /* T_ca_IdleModeValidityArea_r15 */
static int hf_lte_rrc_heightMeas_r15 = -1;        /* T_heightMeas_r15 */
static int hf_lte_rrc_multipleCellsMeasExtension_r15 = -1;  /* T_multipleCellsMeasExtension_r15 */
static int hf_lte_rrc_BandListEUTRA_item = -1;    /* BandInfoEUTRA */
static int hf_lte_rrc_BandCombinationListEUTRA_r10_item = -1;  /* BandInfoEUTRA */
static int hf_lte_rrc_interFreqBandList = -1;     /* InterFreqBandList */
static int hf_lte_rrc_interRAT_BandList = -1;     /* InterRAT_BandList */
static int hf_lte_rrc_InterFreqBandList_item = -1;  /* InterFreqBandInfo */
static int hf_lte_rrc_interFreqNeedForGaps = -1;  /* BOOLEAN */
static int hf_lte_rrc_InterRAT_BandList_item = -1;  /* InterRAT_BandInfo */
static int hf_lte_rrc_interRAT_NeedForGaps = -1;  /* BOOLEAN */
static int hf_lte_rrc_en_DC_r15 = -1;             /* T_en_DC_r15 */
static int hf_lte_rrc_eventB2_r15 = -1;           /* T_eventB2_r15 */
static int hf_lte_rrc_supportedBandListEN_DC_r15 = -1;  /* SupportedBandListNR_r15 */
static int hf_lte_rrc_eutra_5GC_HO_ToNR_FDD_FR1_r15 = -1;  /* T_eutra_5GC_HO_ToNR_FDD_FR1_r15 */
static int hf_lte_rrc_eutra_5GC_HO_ToNR_TDD_FR1_r15 = -1;  /* T_eutra_5GC_HO_ToNR_TDD_FR1_r15 */
static int hf_lte_rrc_eutra_5GC_HO_ToNR_FDD_FR2_r15 = -1;  /* T_eutra_5GC_HO_ToNR_FDD_FR2_r15 */
static int hf_lte_rrc_eutra_5GC_HO_ToNR_TDD_FR2_r15 = -1;  /* T_eutra_5GC_HO_ToNR_TDD_FR2_r15 */
static int hf_lte_rrc_eutra_EPC_HO_ToNR_FDD_FR1_r15 = -1;  /* T_eutra_EPC_HO_ToNR_FDD_FR1_r15 */
static int hf_lte_rrc_eutra_EPC_HO_ToNR_TDD_FR1_r15 = -1;  /* T_eutra_EPC_HO_ToNR_TDD_FR1_r15 */
static int hf_lte_rrc_eutra_EPC_HO_ToNR_FDD_FR2_r15 = -1;  /* T_eutra_EPC_HO_ToNR_FDD_FR2_r15 */
static int hf_lte_rrc_eutra_EPC_HO_ToNR_TDD_FR2_r15 = -1;  /* T_eutra_EPC_HO_ToNR_TDD_FR2_r15 */
static int hf_lte_rrc_ims_VoiceOverNR_FR1_r15 = -1;  /* T_ims_VoiceOverNR_FR1_r15 */
static int hf_lte_rrc_ims_VoiceOverNR_FR2_r15 = -1;  /* T_ims_VoiceOverNR_FR2_r15 */
static int hf_lte_rrc_sa_NR_r15 = -1;             /* T_sa_NR_r15 */
static int hf_lte_rrc_supportedBandListNR_SA_r15 = -1;  /* SupportedBandListNR_r15 */
static int hf_lte_rrc_ng_EN_DC_r15 = -1;          /* T_ng_EN_DC_r15 */
static int hf_lte_rrc_ss_SINR_Meas_NR_FR1_r15 = -1;  /* T_ss_SINR_Meas_NR_FR1_r15 */
static int hf_lte_rrc_ss_SINR_Meas_NR_FR2_r15 = -1;  /* T_ss_SINR_Meas_NR_FR2_r15 */
static int hf_lte_rrc_eutra_5GC_r15 = -1;         /* T_eutra_5GC_r15 */
static int hf_lte_rrc_eutra_EPC_HO_EUTRA_5GC_r15 = -1;  /* T_eutra_EPC_HO_EUTRA_5GC_r15 */
static int hf_lte_rrc_ho_EUTRA_5GC_FDD_TDD_r15 = -1;  /* T_ho_EUTRA_5GC_FDD_TDD_r15 */
static int hf_lte_rrc_ho_InterfreqEUTRA_5GC_r15 = -1;  /* T_ho_InterfreqEUTRA_5GC_r15 */
static int hf_lte_rrc_ims_VoiceOverMCG_BearerEUTRA_5GC_r15 = -1;  /* T_ims_VoiceOverMCG_BearerEUTRA_5GC_r15 */
static int hf_lte_rrc_inactiveState_r15 = -1;     /* T_inactiveState_r15 */
static int hf_lte_rrc_reflectiveQoS_r15 = -1;     /* T_reflectiveQoS_r15 */
static int hf_lte_rrc_rohc_Profiles_r15 = -1;     /* ROHC_ProfileSupportList_r15 */
static int hf_lte_rrc_rohc_ContextMaxSessions_r15 = -1;  /* T_rohc_ContextMaxSessions_r15 */
static int hf_lte_rrc_rohc_ProfilesUL_Only_r15 = -1;  /* T_rohc_ProfilesUL_Only_r15 */
static int hf_lte_rrc_profile0x0006_r15 = -1;     /* BOOLEAN */
static int hf_lte_rrc_rohc_ContextContinue_r15 = -1;  /* T_rohc_ContextContinue_r15 */
static int hf_lte_rrc_outOfOrderDelivery_r15 = -1;  /* T_outOfOrderDelivery_r15 */
static int hf_lte_rrc_sn_SizeLo_r15 = -1;         /* T_sn_SizeLo_r15 */
static int hf_lte_rrc_ims_VoiceOverNR_PDCP_MCG_Bearer_r15 = -1;  /* T_ims_VoiceOverNR_PDCP_MCG_Bearer_r15 */
static int hf_lte_rrc_ims_VoiceOverNR_PDCP_SCG_Bearer_r15 = -1;  /* T_ims_VoiceOverNR_PDCP_SCG_Bearer_r15 */
static int hf_lte_rrc_ims_VoNR_PDCP_SCG_NGENDC_r15 = -1;  /* T_ims_VoNR_PDCP_SCG_NGENDC_r15 */
static int hf_lte_rrc_profile0x0001_r15 = -1;     /* BOOLEAN */
static int hf_lte_rrc_profile0x0002_r15 = -1;     /* BOOLEAN */
static int hf_lte_rrc_profile0x0003_r15 = -1;     /* BOOLEAN */
static int hf_lte_rrc_profile0x0004_r15 = -1;     /* BOOLEAN */
static int hf_lte_rrc_profile0x0101_r15 = -1;     /* BOOLEAN */
static int hf_lte_rrc_profile0x0102_r15 = -1;     /* BOOLEAN */
static int hf_lte_rrc_profile0x0103_r15 = -1;     /* BOOLEAN */
static int hf_lte_rrc_profile0x0104_r15 = -1;     /* BOOLEAN */
static int hf_lte_rrc_SupportedBandListNR_r15_item = -1;  /* SupportedBandNR_r15 */
static int hf_lte_rrc_bandNR_r15_01 = -1;         /* FreqBandIndicatorNR_r15 */
static int hf_lte_rrc_supportedBandListUTRA_FDD = -1;  /* SupportedBandListUTRA_FDD */
static int hf_lte_rrc_e_RedirectionUTRA_r9 = -1;  /* T_e_RedirectionUTRA_r9 */
static int hf_lte_rrc_voiceOverPS_HS_UTRA_FDD_r9 = -1;  /* T_voiceOverPS_HS_UTRA_FDD_r9 */
static int hf_lte_rrc_voiceOverPS_HS_UTRA_TDD128_r9 = -1;  /* T_voiceOverPS_HS_UTRA_TDD128_r9 */
static int hf_lte_rrc_srvcc_FromUTRA_FDD_ToUTRA_FDD_r9 = -1;  /* T_srvcc_FromUTRA_FDD_ToUTRA_FDD_r9 */
static int hf_lte_rrc_srvcc_FromUTRA_FDD_ToGERAN_r9 = -1;  /* T_srvcc_FromUTRA_FDD_ToGERAN_r9 */
static int hf_lte_rrc_srvcc_FromUTRA_TDD128_ToUTRA_TDD128_r9 = -1;  /* T_srvcc_FromUTRA_TDD128_ToUTRA_TDD128_r9 */
static int hf_lte_rrc_srvcc_FromUTRA_TDD128_ToGERAN_r9 = -1;  /* T_srvcc_FromUTRA_TDD128_ToGERAN_r9 */
static int hf_lte_rrc_mfbi_UTRA_r9 = -1;          /* T_mfbi_UTRA_r9 */
static int hf_lte_rrc_SupportedBandListUTRA_FDD_item = -1;  /* SupportedBandUTRA_FDD */
static int hf_lte_rrc_supportedBandListUTRA_TDD128 = -1;  /* SupportedBandListUTRA_TDD128 */
static int hf_lte_rrc_SupportedBandListUTRA_TDD128_item = -1;  /* SupportedBandUTRA_TDD128 */
static int hf_lte_rrc_supportedBandListUTRA_TDD384 = -1;  /* SupportedBandListUTRA_TDD384 */
static int hf_lte_rrc_SupportedBandListUTRA_TDD384_item = -1;  /* SupportedBandUTRA_TDD384 */
static int hf_lte_rrc_supportedBandListUTRA_TDD768 = -1;  /* SupportedBandListUTRA_TDD768 */
static int hf_lte_rrc_SupportedBandListUTRA_TDD768_item = -1;  /* SupportedBandUTRA_TDD768 */
static int hf_lte_rrc_e_RedirectionUTRA_TDD_r10 = -1;  /* T_e_RedirectionUTRA_TDD_r10 */
static int hf_lte_rrc_supportedBandListGERAN = -1;  /* SupportedBandListGERAN */
static int hf_lte_rrc_interRAT_PS_HO_ToGERAN = -1;  /* BOOLEAN */
static int hf_lte_rrc_dtm_r9 = -1;                /* T_dtm_r9 */
static int hf_lte_rrc_e_RedirectionGERAN_r9 = -1;  /* T_e_RedirectionGERAN_r9 */
static int hf_lte_rrc_SupportedBandListGERAN_item = -1;  /* SupportedBandGERAN */
static int hf_lte_rrc_supportedBandListHRPD = -1;  /* SupportedBandListHRPD */
static int hf_lte_rrc_tx_ConfigHRPD = -1;         /* T_tx_ConfigHRPD */
static int hf_lte_rrc_rx_ConfigHRPD = -1;         /* T_rx_ConfigHRPD */
static int hf_lte_rrc_SupportedBandListHRPD_item = -1;  /* BandclassCDMA2000 */
static int hf_lte_rrc_supportedBandList1XRTT = -1;  /* SupportedBandList1XRTT */
static int hf_lte_rrc_tx_Config1XRTT = -1;        /* T_tx_Config1XRTT */
static int hf_lte_rrc_rx_Config1XRTT = -1;        /* T_rx_Config1XRTT */
static int hf_lte_rrc_e_CSFB_1XRTT_r9 = -1;       /* T_e_CSFB_1XRTT_r9 */
static int hf_lte_rrc_e_CSFB_ConcPS_Mob1XRTT_r9 = -1;  /* T_e_CSFB_ConcPS_Mob1XRTT_r9 */
static int hf_lte_rrc_e_CSFB_dual_1XRTT_r10 = -1;  /* T_e_CSFB_dual_1XRTT_r10 */
static int hf_lte_rrc_cdma2000_NW_Sharing_r11 = -1;  /* T_cdma2000_NW_Sharing_r11 */
static int hf_lte_rrc_SupportedBandList1XRTT_item = -1;  /* BandclassCDMA2000 */
static int hf_lte_rrc_supportedBandListWLAN_r13 = -1;  /* SupportedBandListWLAN_r13 */
static int hf_lte_rrc_supportedBandListWLAN_r13_item = -1;  /* WLAN_BandIndicator_r13 */
static int hf_lte_rrc_intraFreqProximityIndication_r9 = -1;  /* T_intraFreqProximityIndication_r9 */
static int hf_lte_rrc_interFreqProximityIndication_r9 = -1;  /* T_interFreqProximityIndication_r9 */
static int hf_lte_rrc_utran_ProximityIndication_r9 = -1;  /* T_utran_ProximityIndication_r9 */
static int hf_lte_rrc_intraFreqSI_AcquisitionForHO_r9 = -1;  /* T_intraFreqSI_AcquisitionForHO_r9 */
static int hf_lte_rrc_interFreqSI_AcquisitionForHO_r9 = -1;  /* T_interFreqSI_AcquisitionForHO_r9 */
static int hf_lte_rrc_utran_SI_AcquisitionForHO_r9 = -1;  /* T_utran_SI_AcquisitionForHO_r9 */
static int hf_lte_rrc_reportCGI_NR_EN_DC_r15 = -1;  /* T_reportCGI_NR_EN_DC_r15 */
static int hf_lte_rrc_reportCGI_NR_NoEN_DC_r15 = -1;  /* T_reportCGI_NR_NoEN_DC_r15 */
static int hf_lte_rrc_eutra_CGI_Reporting_ENDC_r15 = -1;  /* T_eutra_CGI_Reporting_ENDC_r15 */
static int hf_lte_rrc_utra_GERAN_CGI_Reporting_ENDC_r15 = -1;  /* T_utra_GERAN_CGI_Reporting_ENDC_r15 */
static int hf_lte_rrc_rach_Report_r9_01 = -1;     /* T_rach_Report_r9_01 */
static int hf_lte_rrc_loggedMeasurementsIdle_r10 = -1;  /* T_loggedMeasurementsIdle_r10 */
static int hf_lte_rrc_standaloneGNSS_Location_r10 = -1;  /* T_standaloneGNSS_Location_r10 */
static int hf_lte_rrc_loggedMBSFNMeasurements_r12 = -1;  /* T_loggedMBSFNMeasurements_r12 */
static int hf_lte_rrc_locationReport_r14 = -1;    /* T_locationReport_r14 */
static int hf_lte_rrc_loggedMeasBT_r15 = -1;      /* T_loggedMeasBT_r15 */
static int hf_lte_rrc_loggedMeasWLAN_r15 = -1;    /* T_loggedMeasWLAN_r15 */
static int hf_lte_rrc_immMeasBT_r15 = -1;         /* T_immMeasBT_r15 */
static int hf_lte_rrc_immMeasWLAN_r15 = -1;       /* T_immMeasWLAN_r15 */
static int hf_lte_rrc_otdoa_UE_Assisted_r10 = -1;  /* T_otdoa_UE_Assisted_r10 */
static int hf_lte_rrc_interFreqRSTD_Measurement_r10 = -1;  /* T_interFreqRSTD_Measurement_r10 */
static int hf_lte_rrc_inDeviceCoexInd_r11 = -1;   /* T_inDeviceCoexInd_r11 */
static int hf_lte_rrc_powerPrefInd_r11 = -1;      /* T_powerPrefInd_r11 */
static int hf_lte_rrc_ue_Rx_TxTimeDiffMeasurements_r11 = -1;  /* T_ue_Rx_TxTimeDiffMeasurements_r11 */
static int hf_lte_rrc_inDeviceCoexInd_UL_CA_r11 = -1;  /* T_inDeviceCoexInd_UL_CA_r11 */
static int hf_lte_rrc_inDeviceCoexInd_HardwareSharingInd_r13 = -1;  /* T_inDeviceCoexInd_HardwareSharingInd_r13 */
static int hf_lte_rrc_bwPrefInd_r14 = -1;         /* T_bwPrefInd_r14 */
static int hf_lte_rrc_rlm_ReportSupport_r14 = -1;  /* T_rlm_ReportSupport_r14 */
static int hf_lte_rrc_overheatingInd_r14 = -1;    /* T_overheatingInd_r14 */
static int hf_lte_rrc_nonCSG_SI_Reporting_r14 = -1;  /* T_nonCSG_SI_Reporting_r14 */
static int hf_lte_rrc_assistInfoBitForLC_r15 = -1;  /* T_assistInfoBitForLC_r15 */
static int hf_lte_rrc_timeReferenceProvision_r15 = -1;  /* T_timeReferenceProvision_r15 */
static int hf_lte_rrc_flightPathPlan_r15 = -1;    /* T_flightPathPlan_r15 */
static int hf_lte_rrc_inDeviceCoexInd_ENDC_r15 = -1;  /* T_inDeviceCoexInd_ENDC_r15 */
static int hf_lte_rrc_mbms_SCell_r11 = -1;        /* T_mbms_SCell_r11 */
static int hf_lte_rrc_mbms_NonServingCell_r11 = -1;  /* T_mbms_NonServingCell_r11 */
static int hf_lte_rrc_mbms_AsyncDC_r12 = -1;      /* T_mbms_AsyncDC_r12 */
static int hf_lte_rrc_fembmsDedicatedCell_r14 = -1;  /* T_fembmsDedicatedCell_r14 */
static int hf_lte_rrc_fembmsMixedCell_r14 = -1;   /* T_fembmsMixedCell_r14 */
static int hf_lte_rrc_subcarrierSpacingMBMS_khz7dot5_r14 = -1;  /* T_subcarrierSpacingMBMS_khz7dot5_r14 */
static int hf_lte_rrc_subcarrierSpacingMBMS_khz1dot25_r14 = -1;  /* T_subcarrierSpacingMBMS_khz1dot25_r14 */
static int hf_lte_rrc_mbms_MaxBW_r14 = -1;        /* T_mbms_MaxBW_r14 */
static int hf_lte_rrc_implicitValue = -1;         /* NULL */
static int hf_lte_rrc_explicitValue_06 = -1;      /* INTEGER_2_20 */
static int hf_lte_rrc_mbms_ScalingFactor1dot25_r14 = -1;  /* T_mbms_ScalingFactor1dot25_r14 */
static int hf_lte_rrc_mbms_ScalingFactor7dot5_r14 = -1;  /* T_mbms_ScalingFactor7dot5_r14 */
static int hf_lte_rrc_unicast_fembmsMixedSCell_r14 = -1;  /* T_unicast_fembmsMixedSCell_r14 */
static int hf_lte_rrc_emptyUnicastRegion_r14 = -1;  /* T_emptyUnicastRegion_r14 */
static int hf_lte_rrc_scptm_ParallelReception_r13 = -1;  /* T_scptm_ParallelReception_r13 */
static int hf_lte_rrc_scptm_SCell_r13 = -1;       /* T_scptm_SCell_r13 */
static int hf_lte_rrc_scptm_NonServingCell_r13 = -1;  /* T_scptm_NonServingCell_r13 */
static int hf_lte_rrc_scptm_AsyncDC_r13 = -1;     /* T_scptm_AsyncDC_r13 */
static int hf_lte_rrc_ce_ModeA_r13 = -1;          /* T_ce_ModeA_r13 */
static int hf_lte_rrc_ce_ModeB_r13_01 = -1;       /* T_ce_ModeB_r13_01 */
static int hf_lte_rrc_intraFreqA3_CE_ModeA_r13 = -1;  /* T_intraFreqA3_CE_ModeA_r13 */
static int hf_lte_rrc_intraFreqA3_CE_ModeB_r13 = -1;  /* T_intraFreqA3_CE_ModeB_r13 */
static int hf_lte_rrc_intraFreqHO_CE_ModeA_r13 = -1;  /* T_intraFreqHO_CE_ModeA_r13 */
static int hf_lte_rrc_intraFreqHO_CE_ModeB_r13 = -1;  /* T_intraFreqHO_CE_ModeB_r13 */
static int hf_lte_rrc_unicastFrequencyHopping_r13 = -1;  /* T_unicastFrequencyHopping_r13 */
static int hf_lte_rrc_tm9_CE_ModeA_r13 = -1;      /* T_tm9_CE_ModeA_r13 */
static int hf_lte_rrc_tm9_CE_ModeB_r13 = -1;      /* T_tm9_CE_ModeB_r13 */
static int hf_lte_rrc_tm6_CE_ModeA_r13 = -1;      /* T_tm6_CE_ModeA_r13 */
static int hf_lte_rrc_ce_SwitchWithoutHO_r14 = -1;  /* T_ce_SwitchWithoutHO_r14 */
static int hf_lte_rrc_crossCarrierSchedulingLAA_DL_r13 = -1;  /* T_crossCarrierSchedulingLAA_DL_r13 */
static int hf_lte_rrc_csi_RS_DRS_RRM_MeasurementsLAA_r13 = -1;  /* T_csi_RS_DRS_RRM_MeasurementsLAA_r13 */
static int hf_lte_rrc_downlinkLAA_r13 = -1;       /* T_downlinkLAA_r13 */
static int hf_lte_rrc_endingDwPTS_r13 = -1;       /* T_endingDwPTS_r13 */
static int hf_lte_rrc_secondSlotStartingPosition_r13 = -1;  /* T_secondSlotStartingPosition_r13 */
static int hf_lte_rrc_tm9_LAA_r13 = -1;           /* T_tm9_LAA_r13 */
static int hf_lte_rrc_tm10_LAA_r13 = -1;          /* T_tm10_LAA_r13 */
static int hf_lte_rrc_crossCarrierSchedulingLAA_UL_r14 = -1;  /* T_crossCarrierSchedulingLAA_UL_r14 */
static int hf_lte_rrc_uplinkLAA_r14 = -1;         /* T_uplinkLAA_r14 */
static int hf_lte_rrc_twoStepSchedulingTimingInfo_r14 = -1;  /* T_twoStepSchedulingTimingInfo_r14 */
static int hf_lte_rrc_uss_BlindDecodingAdjustment_r14 = -1;  /* T_uss_BlindDecodingAdjustment_r14 */
static int hf_lte_rrc_uss_BlindDecodingReduction_r14 = -1;  /* T_uss_BlindDecodingReduction_r14 */
static int hf_lte_rrc_outOfSequenceGrantHandling_r14 = -1;  /* T_outOfSequenceGrantHandling_r14 */
static int hf_lte_rrc_aul_r15 = -1;               /* T_aul_r15 */
static int hf_lte_rrc_laa_PUSCH_Mode1_r15 = -1;   /* T_laa_PUSCH_Mode1_r15 */
static int hf_lte_rrc_laa_PUSCH_Mode2_r15 = -1;   /* T_laa_PUSCH_Mode2_r15 */
static int hf_lte_rrc_laa_PUSCH_Mode3_r15 = -1;   /* T_laa_PUSCH_Mode3_r15 */
static int hf_lte_rrc_wlan_IW_RAN_Rules_r12 = -1;  /* T_wlan_IW_RAN_Rules_r12 */
static int hf_lte_rrc_wlan_IW_ANDSF_Policies_r12 = -1;  /* T_wlan_IW_ANDSF_Policies_r12 */
static int hf_lte_rrc_lwa_r13 = -1;               /* T_lwa_r13 */
static int hf_lte_rrc_lwa_SplitBearer_r13 = -1;   /* T_lwa_SplitBearer_r13 */
static int hf_lte_rrc_wlan_MAC_Address_r13 = -1;  /* OCTET_STRING_SIZE_6 */
static int hf_lte_rrc_lwa_BufferSize_r13 = -1;    /* T_lwa_BufferSize_r13 */
static int hf_lte_rrc_lwa_HO_WithoutWT_Change_r14 = -1;  /* T_lwa_HO_WithoutWT_Change_r14 */
static int hf_lte_rrc_lwa_UL_r14 = -1;            /* T_lwa_UL_r14 */
static int hf_lte_rrc_wlan_PeriodicMeas_r14 = -1;  /* T_wlan_PeriodicMeas_r14 */
static int hf_lte_rrc_wlan_ReportAnyWLAN_r14 = -1;  /* T_wlan_ReportAnyWLAN_r14 */
static int hf_lte_rrc_wlan_SupportedDataRate_r14 = -1;  /* INTEGER_1_2048 */
static int hf_lte_rrc_lwa_RLC_UM_r14 = -1;        /* T_lwa_RLC_UM_r14 */
static int hf_lte_rrc_rclwi_r13 = -1;             /* T_rclwi_r13 */
static int hf_lte_rrc_lwip_r13 = -1;              /* T_lwip_r13 */
static int hf_lte_rrc_lwip_Aggregation_DL_r14 = -1;  /* T_lwip_Aggregation_DL_r14 */
static int hf_lte_rrc_lwip_Aggregation_UL_r14 = -1;  /* T_lwip_Aggregation_UL_r14 */
static int hf_lte_rrc_NAICS_Capability_List_r12_item = -1;  /* NAICS_Capability_Entry_r12 */
static int hf_lte_rrc_numberOfNAICS_CapableCC_r12 = -1;  /* INTEGER_1_5 */
static int hf_lte_rrc_numberOfAggregatedPRB_r12 = -1;  /* T_numberOfAggregatedPRB_r12 */
static int hf_lte_rrc_commSimultaneousTx_r12 = -1;  /* T_commSimultaneousTx_r12 */
static int hf_lte_rrc_commSupportedBands_r12 = -1;  /* FreqBandIndicatorListEUTRA_r12 */
static int hf_lte_rrc_discSupportedBands_r12 = -1;  /* SupportedBandInfoList_r12 */
static int hf_lte_rrc_discScheduledResourceAlloc_r12 = -1;  /* T_discScheduledResourceAlloc_r12 */
static int hf_lte_rrc_disc_UE_SelectedResourceAlloc_r12 = -1;  /* T_disc_UE_SelectedResourceAlloc_r12 */
static int hf_lte_rrc_disc_SLSS_r12 = -1;         /* T_disc_SLSS_r12 */
static int hf_lte_rrc_discSupportedProc_r12 = -1;  /* T_discSupportedProc_r12 */
static int hf_lte_rrc_discSysInfoReporting_r13 = -1;  /* T_discSysInfoReporting_r13 */
static int hf_lte_rrc_commMultipleTx_r13 = -1;    /* T_commMultipleTx_r13 */
static int hf_lte_rrc_discInterFreqTx_r13 = -1;   /* T_discInterFreqTx_r13 */
static int hf_lte_rrc_discPeriodicSLSS_r13 = -1;  /* T_discPeriodicSLSS_r13 */
static int hf_lte_rrc_zoneBasedPoolSelection_r14 = -1;  /* T_zoneBasedPoolSelection_r14 */
static int hf_lte_rrc_ue_AutonomousWithFullSensing_r14 = -1;  /* T_ue_AutonomousWithFullSensing_r14 */
static int hf_lte_rrc_ue_AutonomousWithPartialSensing_r14 = -1;  /* T_ue_AutonomousWithPartialSensing_r14 */
static int hf_lte_rrc_sl_CongestionControl_r14 = -1;  /* T_sl_CongestionControl_r14 */
static int hf_lte_rrc_v2x_TxWithShortResvInterval_r14 = -1;  /* T_v2x_TxWithShortResvInterval_r14 */
static int hf_lte_rrc_v2x_numberTxRxTiming_r14 = -1;  /* INTEGER_1_16 */
static int hf_lte_rrc_v2x_nonAdjacentPSCCH_PSSCH_r14 = -1;  /* T_v2x_nonAdjacentPSCCH_PSSCH_r14 */
static int hf_lte_rrc_slss_TxRx_r14 = -1;         /* T_slss_TxRx_r14 */
static int hf_lte_rrc_v2x_SupportedBandCombinationList_r14 = -1;  /* V2X_SupportedBandCombination_r14 */
static int hf_lte_rrc_slss_SupportedTxFreq_r15 = -1;  /* T_slss_SupportedTxFreq_r15 */
static int hf_lte_rrc_sl_64QAM_Tx_r15 = -1;       /* T_sl_64QAM_Tx_r15 */
static int hf_lte_rrc_sl_TxDiversity_r15 = -1;    /* T_sl_TxDiversity_r15 */
static int hf_lte_rrc_ue_CategorySL_r15 = -1;     /* UE_CategorySL_r15 */
static int hf_lte_rrc_v2x_SupportedBandCombinationList_v1530 = -1;  /* V2X_SupportedBandCombination_v1530 */
static int hf_lte_rrc_sl_64QAM_Rx_r15 = -1;       /* T_sl_64QAM_Rx_r15 */
static int hf_lte_rrc_sl_RateMatchingTBSScaling_r15 = -1;  /* T_sl_RateMatchingTBSScaling_r15 */
static int hf_lte_rrc_sl_LowT2min_r15 = -1;       /* T_sl_LowT2min_r15 */
static int hf_lte_rrc_v2x_SensingReportingMode3_r15 = -1;  /* T_v2x_SensingReportingMode3_r15 */
static int hf_lte_rrc_ue_CategorySL_C_TX_r15 = -1;  /* INTEGER_1_5 */
static int hf_lte_rrc_ue_CategorySL_C_RX_r15 = -1;  /* INTEGER_1_4 */
static int hf_lte_rrc_V2X_SupportedBandCombination_r14_item = -1;  /* V2X_BandCombinationParameters_r14 */
static int hf_lte_rrc_V2X_SupportedBandCombination_v1530_item = -1;  /* V2X_BandCombinationParameters_v1530 */
static int hf_lte_rrc_V2X_BandCombinationParameters_r14_item = -1;  /* V2X_BandParameters_r14 */
static int hf_lte_rrc_V2X_BandCombinationParameters_v1530_item = -1;  /* V2X_BandParameters_v1530 */
static int hf_lte_rrc_SupportedBandInfoList_r12_item = -1;  /* SupportedBandInfo_r12 */
static int hf_lte_rrc_support_r12 = -1;           /* T_support_r12 */
static int hf_lte_rrc_FreqBandIndicatorListEUTRA_r12_item = -1;  /* FreqBandIndicator_r11 */
static int hf_lte_rrc_delayBudgetReporting_r14 = -1;  /* T_delayBudgetReporting_r14 */
static int hf_lte_rrc_pusch_Enhancements_r14 = -1;  /* T_pusch_Enhancements_r14 */
static int hf_lte_rrc_recommendedBitRate_r14 = -1;  /* T_recommendedBitRate_r14 */
static int hf_lte_rrc_recommendedBitRateQuery_r14 = -1;  /* T_recommendedBitRateQuery_r14 */
static int hf_lte_rrc_retuningInfo = -1;          /* T_retuningInfo */
static int hf_lte_rrc_rf_RetuningTimeDL_r14 = -1;  /* T_rf_RetuningTimeDL_r14 */
static int hf_lte_rrc_rf_RetuningTimeUL_r14 = -1;  /* T_rf_RetuningTimeUL_r14 */
static int hf_lte_rrc_srs_FlexibleTiming_r14 = -1;  /* T_srs_FlexibleTiming_r14 */
static int hf_lte_rrc_srs_HARQ_ReferenceConfig_r14 = -1;  /* T_srs_HARQ_ReferenceConfig_r14 */
static int hf_lte_rrc_measurementEnhancements_r14 = -1;  /* T_measurementEnhancements_r14 */
static int hf_lte_rrc_demodulationEnhancements_r14 = -1;  /* T_demodulationEnhancements_r14 */
static int hf_lte_rrc_prach_Enhancements_r14 = -1;  /* T_prach_Enhancements_r14 */
static int hf_lte_rrc_ue_Category_v1250 = -1;     /* INTEGER_0 */
static int hf_lte_rrc_ue_CategoryDL_v1310_01 = -1;  /* T_ue_CategoryDL_v1310_01 */
static int hf_lte_rrc_ce_ModeA_r13_01 = -1;       /* T_ce_ModeA_r13_01 */
static int hf_lte_rrc_ce_ModeB_r13_02 = -1;       /* T_ce_ModeB_r13_02 */
static int hf_lte_rrc_wakeUpSignal_r15 = -1;      /* T_wakeUpSignal_r15 */
static int hf_lte_rrc_wakeUpSignal_TDD_r15 = -1;  /* T_wakeUpSignal_TDD_r15 */
static int hf_lte_rrc_wakeUpSignalMinGap_eDRX_r15 = -1;  /* T_wakeUpSignalMinGap_eDRX_r15 */
static int hf_lte_rrc_wakeUpSignalMinGap_eDRX_TDD_r15 = -1;  /* T_wakeUpSignalMinGap_eDRX_TDD_r15 */
static int hf_lte_rrc_t300 = -1;                  /* T_t300 */
static int hf_lte_rrc_t301 = -1;                  /* T_t301 */
static int hf_lte_rrc_t310 = -1;                  /* T_t310 */
static int hf_lte_rrc_n310 = -1;                  /* T_n310 */
static int hf_lte_rrc_t311 = -1;                  /* T_t311 */
static int hf_lte_rrc_n311 = -1;                  /* T_n311 */
static int hf_lte_rrc_t300_v1310 = -1;            /* T_t300_v1310 */
static int hf_lte_rrc_t301_v1310_01 = -1;         /* T_t301_v1310_01 */
static int hf_lte_rrc_t310_v1330_01 = -1;         /* T_t310_v1330_01 */
static int hf_lte_rrc_t300_r15 = -1;              /* T_t300_r15 */
static int hf_lte_rrc_VisitedCellInfoList_r12_item = -1;  /* VisitedCellInfo_r12 */
static int hf_lte_rrc_visitedCellId_r12 = -1;     /* T_visitedCellId_r12 */
static int hf_lte_rrc_cellGlobalId_r12 = -1;      /* CellGlobalIdEUTRA */
static int hf_lte_rrc_pci_arfcn_r12 = -1;         /* T_pci_arfcn_r12 */
static int hf_lte_rrc_timeSpent_r12 = -1;         /* INTEGER_0_4095 */
static int hf_lte_rrc_thresholdRSRP_r12 = -1;     /* T_thresholdRSRP_r12 */
static int hf_lte_rrc_thresholdRSRP_Low_r12 = -1;  /* RSRP_Range */
static int hf_lte_rrc_thresholdRSRP_High_r12 = -1;  /* RSRP_Range */
static int hf_lte_rrc_thresholdRSRQ_r12 = -1;     /* T_thresholdRSRQ_r12 */
static int hf_lte_rrc_thresholdRSRQ_Low_r12 = -1;  /* RSRQ_Range */
static int hf_lte_rrc_thresholdRSRQ_High_r12 = -1;  /* RSRQ_Range */
static int hf_lte_rrc_thresholdRSRQ_OnAllSymbolsWithWB_r12 = -1;  /* T_thresholdRSRQ_OnAllSymbolsWithWB_r12 */
static int hf_lte_rrc_thresholdRSRQ_OnAllSymbolsWithWB_Low_r12 = -1;  /* RSRQ_Range */
static int hf_lte_rrc_thresholdRSRQ_OnAllSymbolsWithWB_High_r12 = -1;  /* RSRQ_Range */
static int hf_lte_rrc_thresholdRSRQ_OnAllSymbols_r12 = -1;  /* T_thresholdRSRQ_OnAllSymbols_r12 */
static int hf_lte_rrc_thresholdRSRQ_OnAllSymbolsLow_r12 = -1;  /* RSRQ_Range */
static int hf_lte_rrc_thresholdRSRQ_OnAllSymbolsHigh_r12 = -1;  /* RSRQ_Range */
static int hf_lte_rrc_thresholdRSRQ_WB_r12 = -1;  /* T_thresholdRSRQ_WB_r12 */
static int hf_lte_rrc_thresholdRSRQ_WB_Low_r12 = -1;  /* RSRQ_Range */
static int hf_lte_rrc_thresholdRSRQ_WB_High_r12 = -1;  /* RSRQ_Range */
static int hf_lte_rrc_thresholdChannelUtilization_r12 = -1;  /* T_thresholdChannelUtilization_r12 */
static int hf_lte_rrc_thresholdChannelUtilizationLow_r12 = -1;  /* T_thresholdChannelUtilizationLow_r12 */
static int hf_lte_rrc_thresholdChannelUtilizationHigh_r12 = -1;  /* T_thresholdChannelUtilizationHigh_r12 */
static int hf_lte_rrc_thresholdBackhaul_Bandwidth_r12 = -1;  /* T_thresholdBackhaul_Bandwidth_r12 */
static int hf_lte_rrc_thresholdBackhaulDL_BandwidthLow_r12 = -1;  /* WLAN_backhaulRate_r12 */
static int hf_lte_rrc_thresholdBackhaulDL_BandwidthHigh_r12 = -1;  /* WLAN_backhaulRate_r12 */
static int hf_lte_rrc_thresholdBackhaulUL_BandwidthLow_r12 = -1;  /* WLAN_backhaulRate_r12 */
static int hf_lte_rrc_thresholdBackhaulUL_BandwidthHigh_r12 = -1;  /* WLAN_backhaulRate_r12 */
static int hf_lte_rrc_thresholdWLAN_RSSI_r12 = -1;  /* T_thresholdWLAN_RSSI_r12 */
static int hf_lte_rrc_thresholdWLAN_RSSI_Low_r12 = -1;  /* INTEGER_0_255 */
static int hf_lte_rrc_thresholdWLAN_RSSI_High_r12 = -1;  /* INTEGER_0_255 */
static int hf_lte_rrc_offloadPreferenceIndicator_r12 = -1;  /* BIT_STRING_SIZE_16 */
static int hf_lte_rrc_t_SteeringWLAN_r12 = -1;    /* T_Reselection */
static int hf_lte_rrc_notificationRepetitionCoeff_r9 = -1;  /* T_notificationRepetitionCoeff_r9 */
static int hf_lte_rrc_notificationOffset_r9 = -1;  /* INTEGER_0_10 */
static int hf_lte_rrc_notificationSF_Index_r9 = -1;  /* INTEGER_1_6 */
static int hf_lte_rrc_notificationSF_Index_v1430 = -1;  /* INTEGER_7_10 */
static int hf_lte_rrc_MBMS_ServiceList_r13_item = -1;  /* MBMS_ServiceInfo_r13 */
static int hf_lte_rrc_tmgi_r13 = -1;              /* TMGI_r9 */
static int hf_lte_rrc_MBSFN_AreaInfoList_r9_item = -1;  /* MBSFN_AreaInfo_r9 */
static int hf_lte_rrc_mbsfn_AreaId_r9 = -1;       /* MBSFN_AreaId_r12 */
static int hf_lte_rrc_non_MBSFNregionLength = -1;  /* T_non_MBSFNregionLength */
static int hf_lte_rrc_notificationIndicator_r9 = -1;  /* INTEGER_0_7 */
static int hf_lte_rrc_mcch_Config_r9 = -1;        /* T_mcch_Config_r9 */
static int hf_lte_rrc_mcch_RepetitionPeriod_r9 = -1;  /* T_mcch_RepetitionPeriod_r9 */
static int hf_lte_rrc_mcch_Offset_r9 = -1;        /* INTEGER_0_10 */
static int hf_lte_rrc_mcch_ModificationPeriod_r9 = -1;  /* T_mcch_ModificationPeriod_r9 */
static int hf_lte_rrc_sf_AllocInfo_r9 = -1;       /* BIT_STRING_SIZE_6 */
static int hf_lte_rrc_signallingMCS_r9 = -1;      /* T_signallingMCS_r9 */
static int hf_lte_rrc_mcch_Config_r14 = -1;       /* T_mcch_Config_r14 */
static int hf_lte_rrc_mcch_RepetitionPeriod_v1430 = -1;  /* T_mcch_RepetitionPeriod_v1430 */
static int hf_lte_rrc_mcch_ModificationPeriod_v1430 = -1;  /* T_mcch_ModificationPeriod_v1430 */
static int hf_lte_rrc_subcarrierSpacingMBMS_r14 = -1;  /* T_subcarrierSpacingMBMS_r14 */
static int hf_lte_rrc_radioframeAllocationPeriod = -1;  /* T_radioframeAllocationPeriod */
static int hf_lte_rrc_radioframeAllocationOffset = -1;  /* INTEGER_0_7 */
static int hf_lte_rrc_subframeAllocation = -1;    /* T_subframeAllocation */
static int hf_lte_rrc_oneFrame = -1;              /* BIT_STRING_SIZE_6 */
static int hf_lte_rrc_fourFrames = -1;            /* BIT_STRING_SIZE_24 */
static int hf_lte_rrc_subframeAllocation_v1430 = -1;  /* T_subframeAllocation_v1430 */
static int hf_lte_rrc_oneFrame_v1430 = -1;        /* BIT_STRING_SIZE_2 */
static int hf_lte_rrc_fourFrames_v1430 = -1;      /* BIT_STRING_SIZE_8 */
static int hf_lte_rrc_PMCH_InfoList_r9_item = -1;  /* PMCH_Info_r9 */
static int hf_lte_rrc_PMCH_InfoListExt_r12_item = -1;  /* PMCH_InfoExt_r12 */
static int hf_lte_rrc_pmch_Config_r9 = -1;        /* PMCH_Config_r9 */
static int hf_lte_rrc_mbms_SessionInfoList_r9 = -1;  /* MBMS_SessionInfoList_r9 */
static int hf_lte_rrc_pmch_Config_r12 = -1;       /* PMCH_Config_r12 */
static int hf_lte_rrc_mbms_SessionInfoList_r12 = -1;  /* MBMS_SessionInfoList_r9 */
static int hf_lte_rrc_MBMS_SessionInfoList_r9_item = -1;  /* MBMS_SessionInfo_r9 */
static int hf_lte_rrc_tmgi_r9 = -1;               /* TMGI_r9 */
static int hf_lte_rrc_sessionId_r9 = -1;          /* OCTET_STRING_SIZE_1 */
static int hf_lte_rrc_logicalChannelIdentity_r9 = -1;  /* INTEGER_0_maxSessionPerPMCH_1 */
static int hf_lte_rrc_sf_AllocEnd_r9 = -1;        /* INTEGER_0_1535 */
static int hf_lte_rrc_dataMCS_r9 = -1;            /* INTEGER_0_28 */
static int hf_lte_rrc_mch_SchedulingPeriod_r9 = -1;  /* T_mch_SchedulingPeriod_r9 */
static int hf_lte_rrc_sf_AllocEnd_r12 = -1;       /* INTEGER_0_1535 */
static int hf_lte_rrc_dataMCS_r12 = -1;           /* T_dataMCS_r12 */
static int hf_lte_rrc_normal_r12 = -1;            /* INTEGER_0_28 */
static int hf_lte_rrc_higerOrder_r12 = -1;        /* INTEGER_0_27 */
static int hf_lte_rrc_mch_SchedulingPeriod_r12 = -1;  /* T_mch_SchedulingPeriod_r12 */
static int hf_lte_rrc_mch_SchedulingPeriod_v1430 = -1;  /* T_mch_SchedulingPeriod_v1430 */
static int hf_lte_rrc_plmn_Id_r9 = -1;            /* T_plmn_Id_r9 */
static int hf_lte_rrc_plmn_Index_r9 = -1;         /* INTEGER_1_maxPLMN_r11 */
static int hf_lte_rrc_explicitValue_r9 = -1;      /* PLMN_Identity */
static int hf_lte_rrc_serviceId_r9 = -1;          /* OCTET_STRING_SIZE_3 */
static int hf_lte_rrc_SC_MTCH_InfoList_r13_item = -1;  /* SC_MTCH_Info_r13 */
static int hf_lte_rrc_mbmsSessionInfo_r13 = -1;   /* MBMSSessionInfo_r13 */
static int hf_lte_rrc_g_RNTI_r13 = -1;            /* BIT_STRING_SIZE_16 */
static int hf_lte_rrc_sc_mtch_schedulingInfo_r13 = -1;  /* SC_MTCH_SchedulingInfo_r13 */
static int hf_lte_rrc_sc_mtch_neighbourCell_r13 = -1;  /* BIT_STRING_SIZE_maxNeighCell_SCPTM_r13 */
static int hf_lte_rrc_p_a_r13 = -1;               /* T_p_a_r13 */
static int hf_lte_rrc_sessionId_r13 = -1;         /* OCTET_STRING_SIZE_1 */
static int hf_lte_rrc_onDurationTimerSCPTM_r13 = -1;  /* T_onDurationTimerSCPTM_r13 */
static int hf_lte_rrc_drx_InactivityTimerSCPTM_r13 = -1;  /* T_drx_InactivityTimerSCPTM_r13 */
static int hf_lte_rrc_schedulingPeriodStartOffsetSCPTM_r13 = -1;  /* T_schedulingPeriodStartOffsetSCPTM_r13 */
static int hf_lte_rrc_sf2048_02 = -1;             /* INTEGER_0_2048 */
static int hf_lte_rrc_sf4096_01 = -1;             /* INTEGER_0_4096 */
static int hf_lte_rrc_sf8192_01 = -1;             /* INTEGER_0_8192 */
static int hf_lte_rrc_SC_MTCH_InfoList_BR_r14_item = -1;  /* SC_MTCH_Info_BR_r14 */
static int hf_lte_rrc_sc_mtch_CarrierFreq_r14 = -1;  /* ARFCN_ValueEUTRA_r9 */
static int hf_lte_rrc_mbmsSessionInfo_r14 = -1;   /* MBMSSessionInfo_r13 */
static int hf_lte_rrc_g_RNTI_r14 = -1;            /* BIT_STRING_SIZE_16 */
static int hf_lte_rrc_sc_mtch_schedulingInfo_r14 = -1;  /* SC_MTCH_SchedulingInfo_BR_r14 */
static int hf_lte_rrc_sc_mtch_neighbourCell_r14 = -1;  /* BIT_STRING_SIZE_maxNeighCell_SCPTM_r13 */
static int hf_lte_rrc_mpdcch_Narrowband_SC_MTCH_r14 = -1;  /* INTEGER_1_maxAvailNarrowBands_r13 */
static int hf_lte_rrc_mpdcch_NumRepetition_SC_MTCH_r14 = -1;  /* T_mpdcch_NumRepetition_SC_MTCH_r14 */
static int hf_lte_rrc_mpdcch_StartSF_SC_MTCH_r14 = -1;  /* T_mpdcch_StartSF_SC_MTCH_r14 */
static int hf_lte_rrc_fdd_r14_01 = -1;            /* T_fdd_r14_01 */
static int hf_lte_rrc_tdd_r14_01 = -1;            /* T_tdd_r14_01 */
static int hf_lte_rrc_mpdcch_PDSCH_HoppingConfig_SC_MTCH_r14 = -1;  /* T_mpdcch_PDSCH_HoppingConfig_SC_MTCH_r14 */
static int hf_lte_rrc_mpdcch_PDSCH_CEmodeConfig_SC_MTCH_r14 = -1;  /* T_mpdcch_PDSCH_CEmodeConfig_SC_MTCH_r14 */
static int hf_lte_rrc_mpdcch_PDSCH_MaxBandwidth_SC_MTCH_r14 = -1;  /* T_mpdcch_PDSCH_MaxBandwidth_SC_MTCH_r14 */
static int hf_lte_rrc_mpdcch_Offset_SC_MTCH_r14 = -1;  /* T_mpdcch_Offset_SC_MTCH_r14 */
static int hf_lte_rrc_p_a_r14 = -1;               /* T_p_a_r14 */
static int hf_lte_rrc_onDurationTimerSCPTM_r14_01 = -1;  /* T_onDurationTimerSCPTM_r14_01 */
static int hf_lte_rrc_drx_InactivityTimerSCPTM_r14_01 = -1;  /* T_drx_InactivityTimerSCPTM_r14_01 */
static int hf_lte_rrc_schedulingPeriodStartOffsetSCPTM_r14_01 = -1;  /* T_schedulingPeriodStartOffsetSCPTM_r14_01 */
static int hf_lte_rrc_SCPTM_NeighbourCellList_r13_item = -1;  /* PCI_ARFCN_r13 */
static int hf_lte_rrc_carrierFreq_r13_02 = -1;    /* ARFCN_ValueEUTRA_r9 */
static int hf_lte_rrc_SL_AnchorCarrierFreqList_V2X_r14_item = -1;  /* ARFCN_ValueEUTRA_r9 */
static int hf_lte_rrc_cbr_RangeCommonConfigList_r14 = -1;  /* SEQUENCE_SIZE_1_maxSL_V2X_CBRConfig_r14_OF_SL_CBR_Levels_Config_r14 */
static int hf_lte_rrc_cbr_RangeCommonConfigList_r14_item = -1;  /* SL_CBR_Levels_Config_r14 */
static int hf_lte_rrc_sl_CBR_PSSCH_TxConfigList_r14 = -1;  /* SEQUENCE_SIZE_1_maxSL_V2X_TxConfig_r14_OF_SL_CBR_PSSCH_TxConfig_r14 */
static int hf_lte_rrc_sl_CBR_PSSCH_TxConfigList_r14_item = -1;  /* SL_CBR_PSSCH_TxConfig_r14 */
static int hf_lte_rrc_SL_CBR_Levels_Config_r14_item = -1;  /* SL_CBR_r14 */
static int hf_lte_rrc_cr_Limit_r14 = -1;          /* INTEGER_0_10000 */
static int hf_lte_rrc_tx_Parameters_r14 = -1;     /* SL_PSSCH_TxParameters_r14 */
static int hf_lte_rrc_SL_CBR_PPPP_TxConfigList_r14_item = -1;  /* SL_PPPP_TxConfigIndex_r14 */
static int hf_lte_rrc_priorityThreshold_r14 = -1;  /* SL_Priority_r13 */
static int hf_lte_rrc_defaultTxConfigIndex_r14 = -1;  /* INTEGER_0_maxCBR_Level_1_r14 */
static int hf_lte_rrc_cbr_ConfigIndex_r14 = -1;   /* INTEGER_0_maxSL_V2X_CBRConfig_1_r14 */
static int hf_lte_rrc_tx_ConfigIndexList_r14 = -1;  /* SEQUENCE_SIZE_1_maxCBR_Level_r14_OF_Tx_ConfigIndex_r14 */
static int hf_lte_rrc_tx_ConfigIndexList_r14_item = -1;  /* Tx_ConfigIndex_r14 */
static int hf_lte_rrc_SL_CBR_PPPP_TxConfigList_v1530_item = -1;  /* SL_PPPP_TxConfigIndex_v1530 */
static int hf_lte_rrc_mcs_PSSCH_RangeList_r15 = -1;  /* SEQUENCE_SIZE_1_maxCBR_Level_r14_OF_MCS_PSSCH_Range_r15 */
static int hf_lte_rrc_mcs_PSSCH_RangeList_r15_item = -1;  /* MCS_PSSCH_Range_r15 */
static int hf_lte_rrc_minMCS_PSSCH_r15 = -1;      /* INTEGER_0_31 */
static int hf_lte_rrc_maxMCS_PSSCH_r15 = -1;      /* INTEGER_0_31 */
static int hf_lte_rrc_SL_CBR_PPPP_TxConfigList_r15_item = -1;  /* SL_PPPP_TxConfigIndex_r15 */
static int hf_lte_rrc_priorityThreshold_r15 = -1;  /* SL_Priority_r13 */
static int hf_lte_rrc_defaultTxConfigIndex_r15 = -1;  /* INTEGER_0_maxCBR_Level_1_r14 */
static int hf_lte_rrc_cbr_ConfigIndex_r15 = -1;   /* INTEGER_0_maxSL_V2X_CBRConfig_1_r14 */
static int hf_lte_rrc_tx_ConfigIndexList_r15 = -1;  /* SEQUENCE_SIZE_1_maxCBR_Level_r14_OF_Tx_ConfigIndex_r14 */
static int hf_lte_rrc_tx_ConfigIndexList_r15_item = -1;  /* Tx_ConfigIndex_r14 */
static int hf_lte_rrc_commTxResources_r12 = -1;   /* T_commTxResources_r12 */
static int hf_lte_rrc_setup_186 = -1;             /* T_setup_162 */
static int hf_lte_rrc_scheduled_r12 = -1;         /* T_scheduled_r12 */
static int hf_lte_rrc_sl_RNTI_r12 = -1;           /* C_RNTI */
static int hf_lte_rrc_mac_MainConfig_r12 = -1;    /* MAC_MainConfigSL_r12 */
static int hf_lte_rrc_sc_CommTxConfig_r12 = -1;   /* SL_CommResourcePool_r12 */
static int hf_lte_rrc_mcs_r12 = -1;               /* INTEGER_0_28 */
static int hf_lte_rrc_ue_Selected_r12 = -1;       /* T_ue_Selected_r12 */
static int hf_lte_rrc_commTxPoolNormalDedicated_r12 = -1;  /* T_commTxPoolNormalDedicated_r12 */
static int hf_lte_rrc_poolToReleaseList_r12 = -1;  /* SL_TxPoolToReleaseList_r12 */
static int hf_lte_rrc_poolToAddModList_r12 = -1;  /* SL_CommTxPoolToAddModList_r12 */
static int hf_lte_rrc_commTxResources_v1310 = -1;  /* T_commTxResources_v1310 */
static int hf_lte_rrc_setup_187 = -1;             /* T_setup_163 */
static int hf_lte_rrc_scheduled_v1310 = -1;       /* T_scheduled_v1310 */
static int hf_lte_rrc_logicalChGroupInfoList_r13 = -1;  /* LogicalChGroupInfoList_r13 */
static int hf_lte_rrc_multipleTx_r13 = -1;        /* BOOLEAN */
static int hf_lte_rrc_ue_Selected_v1310 = -1;     /* T_ue_Selected_v1310 */
static int hf_lte_rrc_commTxPoolNormalDedicatedExt_r13 = -1;  /* T_commTxPoolNormalDedicatedExt_r13 */
static int hf_lte_rrc_poolToReleaseListExt_r13 = -1;  /* SL_TxPoolToReleaseListExt_r13 */
static int hf_lte_rrc_poolToAddModListExt_r13 = -1;  /* SL_CommTxPoolToAddModListExt_r13 */
static int hf_lte_rrc_commTxAllowRelayDedicated_r13 = -1;  /* BOOLEAN */
static int hf_lte_rrc_LogicalChGroupInfoList_r13_item = -1;  /* SL_PriorityList_r13 */
static int hf_lte_rrc_SL_CommTxPoolToAddModList_r12_item = -1;  /* SL_CommTxPoolToAddMod_r12 */
static int hf_lte_rrc_SL_CommTxPoolToAddModListExt_r13_item = -1;  /* SL_CommTxPoolToAddModExt_r13 */
static int hf_lte_rrc_poolIdentity_r12 = -1;      /* SL_TxPoolIdentity_r12 */
static int hf_lte_rrc_pool_r12 = -1;              /* SL_CommResourcePool_r12 */
static int hf_lte_rrc_poolIdentity_v1310 = -1;    /* SL_TxPoolIdentity_v1310 */
static int hf_lte_rrc_pool_r13 = -1;              /* SL_CommResourcePool_r12 */
static int hf_lte_rrc_periodic_BSR_TimerSL = -1;  /* PeriodicBSR_Timer_r12 */
static int hf_lte_rrc_retx_BSR_TimerSL = -1;      /* RetxBSR_Timer_r12 */
static int hf_lte_rrc_SL_CommTxPoolList_r12_item = -1;  /* SL_CommResourcePool_r12 */
static int hf_lte_rrc_SL_CommTxPoolListExt_r13_item = -1;  /* SL_CommResourcePool_r12 */
static int hf_lte_rrc_SL_CommTxPoolListV2X_r14_item = -1;  /* SL_CommResourcePoolV2X_r14 */
static int hf_lte_rrc_SL_CommRxPoolList_r12_item = -1;  /* SL_CommResourcePool_r12 */
static int hf_lte_rrc_SL_CommRxPoolListV2X_r14_item = -1;  /* SL_CommResourcePoolV2X_r14 */
static int hf_lte_rrc_sc_CP_Len_r12 = -1;         /* SL_CP_Len_r12 */
static int hf_lte_rrc_sc_Period_r12 = -1;         /* SL_PeriodComm_r12 */
static int hf_lte_rrc_sc_TF_ResourceConfig_r12 = -1;  /* SL_TF_ResourceConfig_r12 */
static int hf_lte_rrc_data_CP_Len_r12 = -1;       /* SL_CP_Len_r12 */
static int hf_lte_rrc_dataHoppingConfig_r12 = -1;  /* SL_HoppingConfigComm_r12 */
static int hf_lte_rrc_ue_SelectedResourceConfig_r12 = -1;  /* T_ue_SelectedResourceConfig_r12 */
static int hf_lte_rrc_data_TF_ResourceConfig_r12 = -1;  /* SL_TF_ResourceConfig_r12 */
static int hf_lte_rrc_trpt_Subset_r12 = -1;       /* SL_TRPT_Subset_r12 */
static int hf_lte_rrc_rxParametersNCell_r12 = -1;  /* T_rxParametersNCell_r12 */
static int hf_lte_rrc_tdd_Config_r12 = -1;        /* TDD_Config */
static int hf_lte_rrc_syncConfigIndex_r12 = -1;   /* INTEGER_0_15 */
static int hf_lte_rrc_txParameters_r12 = -1;      /* T_txParameters_r12 */
static int hf_lte_rrc_sc_TxParameters_r12 = -1;   /* SL_TxParameters_r12 */
static int hf_lte_rrc_dataTxParameters_r12 = -1;  /* SL_TxParameters_r12 */
static int hf_lte_rrc_priorityList_r13 = -1;      /* SL_PriorityList_r13 */
static int hf_lte_rrc_sl_OffsetIndicator_r14 = -1;  /* SL_OffsetIndicator_r12 */
static int hf_lte_rrc_sl_Subframe_r14 = -1;       /* SubframeBitmapSL_r14 */
static int hf_lte_rrc_adjacencyPSCCH_PSSCH_r14 = -1;  /* BOOLEAN */
static int hf_lte_rrc_sizeSubchannel_r14 = -1;    /* T_sizeSubchannel_r14 */
static int hf_lte_rrc_numSubchannel_r14 = -1;     /* T_numSubchannel_r14 */
static int hf_lte_rrc_startRB_Subchannel_r14 = -1;  /* INTEGER_0_99 */
static int hf_lte_rrc_startRB_PSCCH_Pool_r14 = -1;  /* INTEGER_0_99 */
static int hf_lte_rrc_rxParametersNCell_r14 = -1;  /* T_rxParametersNCell_r14 */
static int hf_lte_rrc_tdd_Config_r14 = -1;        /* TDD_Config */
static int hf_lte_rrc_syncConfigIndex_r14 = -1;   /* INTEGER_0_15 */
static int hf_lte_rrc_dataTxParameters_r14 = -1;  /* SL_TxParameters_r12 */
static int hf_lte_rrc_zoneID_r14 = -1;            /* INTEGER_0_7 */
static int hf_lte_rrc_poolReportId_r14 = -1;      /* SL_V2X_TxPoolReportIdentity_r14 */
static int hf_lte_rrc_cbr_pssch_TxConfigList_r14 = -1;  /* SL_CBR_PPPP_TxConfigList_r14 */
static int hf_lte_rrc_resourceSelectionConfigP2X_r14 = -1;  /* SL_P2X_ResourceSelectionConfig_r14 */
static int hf_lte_rrc_syncAllowed_r14 = -1;       /* SL_SyncAllowed_r14 */
static int hf_lte_rrc_restrictResourceReservationPeriod_r14 = -1;  /* SL_RestrictResourceReservationPeriodList_r14 */
static int hf_lte_rrc_sl_MinT2ValueList_r15 = -1;  /* SL_MinT2ValueList_r15 */
static int hf_lte_rrc_cbr_pssch_TxConfigList_v1530 = -1;  /* SL_CBR_PPPP_TxConfigList_v1530 */
static int hf_lte_rrc_SL_MinT2ValueList_r15_item = -1;  /* SL_MinT2Value_r15 */
static int hf_lte_rrc_priorityList_r15 = -1;      /* SL_PriorityList_r13 */
static int hf_lte_rrc_minT2Value_r15 = -1;        /* INTEGER_10_20 */
static int hf_lte_rrc_pssch_TxConfigList_r14 = -1;  /* SL_PSSCH_TxConfigList_r14 */
static int hf_lte_rrc_thresPSSCH_RSRP_List_r14 = -1;  /* SL_ThresPSSCH_RSRP_List_r14 */
static int hf_lte_rrc_probResourceKeep_r14 = -1;  /* T_probResourceKeep_r14 */
static int hf_lte_rrc_p2x_SensingConfig_r14 = -1;  /* T_p2x_SensingConfig_r14 */
static int hf_lte_rrc_minNumCandidateSF_r14 = -1;  /* INTEGER_1_13 */
static int hf_lte_rrc_gapCandidateSensing_r14 = -1;  /* BIT_STRING_SIZE_10 */
static int hf_lte_rrc_sl_ReselectAfter_r14 = -1;  /* T_sl_ReselectAfter_r14 */
static int hf_lte_rrc_discTxResources_r12 = -1;   /* T_discTxResources_r12 */
static int hf_lte_rrc_setup_188 = -1;             /* T_setup_164 */
static int hf_lte_rrc_scheduled_r12_01 = -1;      /* T_scheduled_r12_01 */
static int hf_lte_rrc_discTxConfig_r12 = -1;      /* SL_DiscResourcePool_r12 */
static int hf_lte_rrc_discTF_IndexList_r12 = -1;  /* SL_TF_IndexPairList_r12 */
static int hf_lte_rrc_discHoppingConfig_r12 = -1;  /* SL_HoppingConfigDisc_r12 */
static int hf_lte_rrc_ue_Selected_r12_01 = -1;    /* T_ue_Selected_r12_01 */
static int hf_lte_rrc_discTxPoolDedicated_r12 = -1;  /* T_discTxPoolDedicated_r12 */
static int hf_lte_rrc_poolToAddModList_r12_01 = -1;  /* SL_DiscTxPoolToAddModList_r12 */
static int hf_lte_rrc_discTF_IndexList_v1260 = -1;  /* T_discTF_IndexList_v1260 */
static int hf_lte_rrc_setup_189 = -1;             /* T_setup_165 */
static int hf_lte_rrc_discTF_IndexList_r12b = -1;  /* SL_TF_IndexPairList_r12b */
static int hf_lte_rrc_discTxResourcesPS_r13 = -1;  /* T_discTxResourcesPS_r13 */
static int hf_lte_rrc_setup_190 = -1;             /* T_setup_166 */
static int hf_lte_rrc_scheduled_r13 = -1;         /* SL_DiscTxConfigScheduled_r13 */
static int hf_lte_rrc_ue_Selected_r13 = -1;       /* T_ue_Selected_r13 */
static int hf_lte_rrc_discTxPoolPS_Dedicated_r13 = -1;  /* SL_DiscTxPoolDedicated_r13 */
static int hf_lte_rrc_discTxInterFreqInfo_r13 = -1;  /* T_discTxInterFreqInfo_r13 */
static int hf_lte_rrc_setup_191 = -1;             /* T_setup_167 */
static int hf_lte_rrc_discTxCarrierFreq_r13 = -1;  /* ARFCN_ValueEUTRA_r9 */
static int hf_lte_rrc_discTxRefCarrierDedicated_r13 = -1;  /* SL_DiscTxRefCarrierDedicated_r13 */
static int hf_lte_rrc_discTxInfoInterFreqListAdd_r13 = -1;  /* SL_DiscTxInfoInterFreqListAdd_r13 */
static int hf_lte_rrc_gapRequestsAllowedDedicated_r13 = -1;  /* BOOLEAN */
static int hf_lte_rrc_discRxGapConfig_r13 = -1;   /* T_discRxGapConfig_r13 */
static int hf_lte_rrc_setup_192 = -1;             /* SL_GapConfig_r13 */
static int hf_lte_rrc_discTxGapConfig_r13 = -1;   /* T_discTxGapConfig_r13 */
static int hf_lte_rrc_discSysInfoToReportConfig_r13 = -1;  /* T_discSysInfoToReportConfig_r13 */
static int hf_lte_rrc_setup_193 = -1;             /* SL_DiscSysInfoToReportFreqList_r13 */
static int hf_lte_rrc_SL_DiscSysInfoToReportFreqList_r13_item = -1;  /* ARFCN_ValueEUTRA_r9 */
static int hf_lte_rrc_discTxFreqToAddModList_r13 = -1;  /* SEQUENCE_SIZE_1_maxFreq_OF_SL_DiscTxResourceInfoPerFreq_r13 */
static int hf_lte_rrc_discTxFreqToAddModList_r13_item = -1;  /* SL_DiscTxResourceInfoPerFreq_r13 */
static int hf_lte_rrc_discTxFreqToReleaseList_r13 = -1;  /* SEQUENCE_SIZE_1_maxFreq_OF_ARFCN_ValueEUTRA_r9 */
static int hf_lte_rrc_discTxFreqToReleaseList_r13_item = -1;  /* ARFCN_ValueEUTRA_r9 */
static int hf_lte_rrc_discTxResources_r13 = -1;   /* SL_DiscTxResource_r13 */
static int hf_lte_rrc_discTxResourcesPS_r13_01 = -1;  /* SL_DiscTxResource_r13 */
static int hf_lte_rrc_setup_194 = -1;             /* T_setup_168 */
static int hf_lte_rrc_ue_Selected_r13_01 = -1;    /* SL_DiscTxPoolDedicated_r13 */
static int hf_lte_rrc_SL_DiscTxPoolToAddModList_r12_item = -1;  /* SL_DiscTxPoolToAddMod_r12 */
static int hf_lte_rrc_pool_r12_01 = -1;           /* SL_DiscResourcePool_r12 */
static int hf_lte_rrc_discTxConfig_r13 = -1;      /* SL_DiscResourcePool_r12 */
static int hf_lte_rrc_discTF_IndexList_r13 = -1;  /* SL_TF_IndexPairList_r12b */
static int hf_lte_rrc_discHoppingConfig_r13 = -1;  /* SL_HoppingConfigDisc_r12 */
static int hf_lte_rrc_poolToReleaseList_r13 = -1;  /* SL_TxPoolToReleaseList_r12 */
static int hf_lte_rrc_poolToAddModList_r13 = -1;  /* SL_DiscTxPoolToAddModList_r12 */
static int hf_lte_rrc_SL_TF_IndexPairList_r12_item = -1;  /* SL_TF_IndexPair_r12 */
static int hf_lte_rrc_discSF_Index_r12 = -1;      /* INTEGER_1_200 */
static int hf_lte_rrc_discPRB_Index_r12 = -1;     /* INTEGER_1_50 */
static int hf_lte_rrc_SL_TF_IndexPairList_r12b_item = -1;  /* SL_TF_IndexPair_r12b */
static int hf_lte_rrc_discSF_Index_r12b = -1;     /* INTEGER_0_209 */
static int hf_lte_rrc_discPRB_Index_r12b = -1;    /* INTEGER_0_49 */
static int hf_lte_rrc_pCell = -1;                 /* NULL */
static int hf_lte_rrc_sCell = -1;                 /* SCellIndex_r10 */
static int hf_lte_rrc_SL_DiscTxPoolList_r12_item = -1;  /* SL_DiscResourcePool_r12 */
static int hf_lte_rrc_SL_DiscRxPoolList_r12_item = -1;  /* SL_DiscResourcePool_r12 */
static int hf_lte_rrc_cp_Len_r12 = -1;            /* SL_CP_Len_r12 */
static int hf_lte_rrc_discPeriod_r12 = -1;        /* T_discPeriod_r12 */
static int hf_lte_rrc_numRetx_r12 = -1;           /* INTEGER_0_3 */
static int hf_lte_rrc_numRepetition_r12 = -1;     /* INTEGER_1_50 */
static int hf_lte_rrc_tf_ResourceConfig_r12 = -1;  /* SL_TF_ResourceConfig_r12 */
static int hf_lte_rrc_txParameters_r12_01 = -1;   /* T_txParameters_r12_01 */
static int hf_lte_rrc_txParametersGeneral_r12 = -1;  /* SL_TxParameters_r12 */
static int hf_lte_rrc_ue_SelectedResourceConfig_r12_01 = -1;  /* T_ue_SelectedResourceConfig_r12_01 */
static int hf_lte_rrc_poolSelection_r12 = -1;     /* T_poolSelection_r12 */
static int hf_lte_rrc_rsrpBased_r12 = -1;         /* SL_PoolSelectionConfig_r12 */
static int hf_lte_rrc_random_r12 = -1;            /* NULL */
static int hf_lte_rrc_txProbability_r12 = -1;     /* T_txProbability_r12 */
static int hf_lte_rrc_rxParameters_r12 = -1;      /* T_rxParameters_r12 */
static int hf_lte_rrc_discPeriod_v1310 = -1;      /* T_discPeriod_v1310 */
static int hf_lte_rrc_setup_195 = -1;             /* T_setup_169 */
static int hf_lte_rrc_rxParamsAddNeighFreq_r13 = -1;  /* T_rxParamsAddNeighFreq_r13 */
static int hf_lte_rrc_setup_196 = -1;             /* T_setup_170 */
static int hf_lte_rrc_physCellId_r13_01 = -1;     /* PhysCellIdList_r13 */
static int hf_lte_rrc_txParamsAddNeighFreq_r13 = -1;  /* T_txParamsAddNeighFreq_r13 */
static int hf_lte_rrc_setup_197 = -1;             /* T_setup_171 */
static int hf_lte_rrc_tdd_Config_r13 = -1;        /* TDD_Config */
static int hf_lte_rrc_freqInfo_01 = -1;           /* T_freqInfo_01 */
static int hf_lte_rrc_ul_Bandwidth_02 = -1;       /* T_ul_Bandwidth_02 */
static int hf_lte_rrc_syncConfigIndex_r13 = -1;   /* INTEGER_0_15 */
static int hf_lte_rrc_txParamsAddNeighFreq_v1370 = -1;  /* T_txParamsAddNeighFreq_v1370 */
static int hf_lte_rrc_setup_198 = -1;             /* T_setup_172 */
static int hf_lte_rrc_freqInfo_v1370 = -1;        /* T_freqInfo_v1370 */
static int hf_lte_rrc_additionalSpectrumEmission_v1370 = -1;  /* AdditionalSpectrumEmission_v10l0 */
static int hf_lte_rrc_PhysCellIdList_r13_item = -1;  /* PhysCellId */
static int hf_lte_rrc_threshLow_r12 = -1;         /* RSRP_RangeSL2_r12 */
static int hf_lte_rrc_threshHigh_r12 = -1;        /* RSRP_RangeSL2_r12 */
static int hf_lte_rrc_plmn_IdentityList_r13 = -1;  /* PLMN_IdentityList */
static int hf_lte_rrc_cellIdentity_13 = -1;       /* CellIdentity */
static int hf_lte_rrc_carrierFreqInfo_13 = -1;    /* ARFCN_ValueEUTRA_r9 */
static int hf_lte_rrc_discRxResources_r13 = -1;   /* SL_DiscRxPoolList_r12 */
static int hf_lte_rrc_discTxPowerInfo_r13 = -1;   /* SL_DiscTxPowerInfoList_r12 */
static int hf_lte_rrc_discSyncConfig_r13_01 = -1;  /* SL_SyncConfigNFreq_r13 */
static int hf_lte_rrc_discCellSelectionInfo_r13_01 = -1;  /* T_discCellSelectionInfo_r13 */
static int hf_lte_rrc_q_RxLevMinOffset_r13 = -1;  /* INTEGER_1_8 */
static int hf_lte_rrc_cellReselectionInfo_r13 = -1;  /* T_cellReselectionInfo_r13 */
static int hf_lte_rrc_q_Hyst_r13_01 = -1;         /* T_q_Hyst_r13_01 */
static int hf_lte_rrc_freqInfo_r13 = -1;          /* T_freqInfo_r13 */
static int hf_lte_rrc_ul_CarrierFreq_r13 = -1;    /* ARFCN_ValueEUTRA */
static int hf_lte_rrc_ul_Bandwidth_r13 = -1;      /* T_ul_Bandwidth_r13 */
static int hf_lte_rrc_additionalSpectrumEmission_r13 = -1;  /* AdditionalSpectrumEmission */
static int hf_lte_rrc_p_Max_r13 = -1;             /* P_Max */
static int hf_lte_rrc_referenceSignalPower_r13 = -1;  /* INTEGER_M60_50 */
static int hf_lte_rrc_freqInfo_v1370_01 = -1;     /* T_freqInfo_v1370_01 */
static int hf_lte_rrc_SL_DiscTxPowerInfoList_r12_item = -1;  /* SL_DiscTxPowerInfo_r12 */
static int hf_lte_rrc_discMaxTxPower_r12 = -1;    /* P_Max */
static int hf_lte_rrc_gapPatternList_r13 = -1;    /* SL_GapPatternList_r13 */
static int hf_lte_rrc_SL_GapPatternList_r13_item = -1;  /* SL_GapPattern_r13 */
static int hf_lte_rrc_gapPeriod_r13 = -1;         /* T_gapPeriod_r13 */
static int hf_lte_rrc_gapOffset_r12 = -1;         /* SL_OffsetIndicator_r12 */
static int hf_lte_rrc_gapSubframeBitmap_r13 = -1;  /* BIT_STRING_SIZE_1_10240 */
static int hf_lte_rrc_SL_GapRequest_r13_item = -1;  /* SL_GapFreqInfo_r13 */
static int hf_lte_rrc_hoppingParameter_r12 = -1;  /* INTEGER_0_504 */
static int hf_lte_rrc_numSubbands_r12 = -1;       /* T_numSubbands_r12 */
static int hf_lte_rrc_rb_Offset_r12 = -1;         /* INTEGER_0_110 */
static int hf_lte_rrc_a_r12 = -1;                 /* INTEGER_1_200 */
static int hf_lte_rrc_b_r12 = -1;                 /* INTEGER_1_10 */
static int hf_lte_rrc_c_r12 = -1;                 /* T_c_r12 */
static int hf_lte_rrc_SL_InterFreqInfoListV2X_r14_item = -1;  /* SL_InterFreqInfoV2X_r14 */
static int hf_lte_rrc_v2x_CommCarrierFreq_r14 = -1;  /* ARFCN_ValueEUTRA_r9 */
static int hf_lte_rrc_sl_MaxTxPower_r14 = -1;     /* P_Max */
static int hf_lte_rrc_sl_Bandwidth_r14 = -1;      /* T_sl_Bandwidth_r14 */
static int hf_lte_rrc_v2x_SchedulingPool_r14 = -1;  /* SL_CommResourcePoolV2X_r14 */
static int hf_lte_rrc_v2x_UE_ConfigList_r14 = -1;  /* SL_V2X_UE_ConfigList_r14 */
static int hf_lte_rrc_additionalSpectrumEmissionV2X_r14 = -1;  /* T_additionalSpectrumEmissionV2X_r14 */
static int hf_lte_rrc_additionalSpectrumEmission_r14 = -1;  /* AdditionalSpectrumEmission */
static int hf_lte_rrc_additionalSpectrumEmission_v1440 = -1;  /* AdditionalSpectrumEmission_v10l0 */
static int hf_lte_rrc_SL_V2X_UE_ConfigList_r14_item = -1;  /* SL_V2X_InterFreqUE_Config_r14 */
static int hf_lte_rrc_physCellIdList_r14 = -1;    /* PhysCellIdList_r13 */
static int hf_lte_rrc_v2x_SyncConfig_r14_01 = -1;  /* SL_SyncConfigListNFreqV2X_r14 */
static int hf_lte_rrc_v2x_CommTxPoolNormal_r14 = -1;  /* SL_CommTxPoolListV2X_r14 */
static int hf_lte_rrc_p2x_CommTxPoolNormal_r14 = -1;  /* SL_CommTxPoolListV2X_r14 */
static int hf_lte_rrc_small_r12 = -1;             /* INTEGER_0_319 */
static int hf_lte_rrc_large_r12 = -1;             /* INTEGER_0_10239 */
static int hf_lte_rrc_partialSensing_r14 = -1;    /* T_partialSensing_r14 */
static int hf_lte_rrc_randomSelection_r14 = -1;   /* T_randomSelection_r14 */
static int hf_lte_rrc_SL_PriorityList_r13_item = -1;  /* SL_Priority_r13 */
static int hf_lte_rrc_SL_PSSCH_TxConfigList_r14_item = -1;  /* SL_PSSCH_TxConfig_r14 */
static int hf_lte_rrc_thresUE_Speed_r14 = -1;     /* T_thresUE_Speed_r14 */
static int hf_lte_rrc_parametersAboveThres_r14 = -1;  /* SL_PSSCH_TxParameters_r14 */
static int hf_lte_rrc_parametersBelowThres_r14 = -1;  /* SL_PSSCH_TxParameters_r14 */
static int hf_lte_rrc_parametersAboveThres_v1530 = -1;  /* SL_PSSCH_TxParameters_v1530 */
static int hf_lte_rrc_parametersBelowThres_v1530 = -1;  /* SL_PSSCH_TxParameters_v1530 */
static int hf_lte_rrc_minMCS_PSSCH_r14 = -1;      /* INTEGER_0_31 */
static int hf_lte_rrc_maxMCS_PSSCH_r14 = -1;      /* INTEGER_0_31 */
static int hf_lte_rrc_minSubChannel_NumberPSSCH_r14 = -1;  /* INTEGER_1_20 */
static int hf_lte_rrc_maxSubchannel_NumberPSSCH_r14 = -1;  /* INTEGER_1_20 */
static int hf_lte_rrc_allowedRetxNumberPSSCH_r14 = -1;  /* T_allowedRetxNumberPSSCH_r14 */
static int hf_lte_rrc_maxTxPower_r14 = -1;        /* SL_TxPower_r14 */
static int hf_lte_rrc_SL_ReliabilityList_r15_item = -1;  /* SL_Reliability_r15 */
static int hf_lte_rrc_SL_RestrictResourceReservationPeriodList_r14_item = -1;  /* SL_RestrictResourceReservationPeriod_r14 */
static int hf_lte_rrc_gnss_Sync_r14 = -1;         /* T_gnss_Sync_r14 */
static int hf_lte_rrc_enb_Sync_r14 = -1;          /* T_enb_Sync_r14 */
static int hf_lte_rrc_ue_Sync_r14 = -1;           /* T_ue_Sync_r14 */
static int hf_lte_rrc_SL_SyncConfigList_r12_item = -1;  /* SL_SyncConfig_r12 */
static int hf_lte_rrc_SL_SyncConfigListV2X_r14_item = -1;  /* SL_SyncConfig_r12 */
static int hf_lte_rrc_syncCP_Len_r12 = -1;        /* SL_CP_Len_r12 */
static int hf_lte_rrc_syncOffsetIndicator_r12 = -1;  /* SL_OffsetIndicatorSync_r12 */
static int hf_lte_rrc_slssid_r12 = -1;            /* SLSSID_r12 */
static int hf_lte_rrc_txParameters_r12_02 = -1;   /* T_txParameters_r12_02 */
static int hf_lte_rrc_syncTxParameters_r12 = -1;  /* SL_TxParameters_r12 */
static int hf_lte_rrc_syncTxThreshIC_r12 = -1;    /* RSRP_RangeSL_r12 */
static int hf_lte_rrc_syncInfoReserved_r12 = -1;  /* BIT_STRING_SIZE_19 */
static int hf_lte_rrc_rxParamsNCell_r12 = -1;     /* T_rxParamsNCell_r12 */
static int hf_lte_rrc_discSyncWindow_r12 = -1;    /* T_discSyncWindow_r12 */
static int hf_lte_rrc_syncTxPeriodic_r13 = -1;    /* T_syncTxPeriodic_r13 */
static int hf_lte_rrc_syncOffsetIndicator_v1430 = -1;  /* SL_OffsetIndicatorSync_v1430 */
static int hf_lte_rrc_gnss_Sync_r14_01 = -1;      /* T_gnss_Sync_r14_01 */
static int hf_lte_rrc_syncOffsetIndicator2_r14 = -1;  /* SL_OffsetIndicatorSync_r14 */
static int hf_lte_rrc_syncOffsetIndicator3_r14 = -1;  /* SL_OffsetIndicatorSync_r14 */
static int hf_lte_rrc_slss_TxDisabled_r15 = -1;   /* T_slss_TxDisabled_r15 */
static int hf_lte_rrc_SL_SyncConfigListNFreq_r13_item = -1;  /* SL_SyncConfigNFreq_r13 */
static int hf_lte_rrc_SL_SyncConfigListNFreqV2X_r14_item = -1;  /* SL_SyncConfigNFreq_r13 */
static int hf_lte_rrc_asyncParameters_r13 = -1;   /* T_asyncParameters_r13 */
static int hf_lte_rrc_syncCP_Len_r13 = -1;        /* SL_CP_Len_r12 */
static int hf_lte_rrc_syncOffsetIndicator_r13 = -1;  /* SL_OffsetIndicatorSync_r12 */
static int hf_lte_rrc_slssid_r13 = -1;            /* SLSSID_r12 */
static int hf_lte_rrc_txParameters_r13 = -1;      /* T_txParameters_r13 */
static int hf_lte_rrc_syncTxParameters_r13 = -1;  /* SL_TxParameters_r12 */
static int hf_lte_rrc_syncTxThreshIC_r13 = -1;    /* RSRP_RangeSL_r12 */
static int hf_lte_rrc_syncInfoReserved_r13 = -1;  /* BIT_STRING_SIZE_19 */
static int hf_lte_rrc_syncTxPeriodic_r13_01 = -1;  /* T_syncTxPeriodic_r13_01 */
static int hf_lte_rrc_rxParameters_r13 = -1;      /* T_rxParameters_r13 */
static int hf_lte_rrc_discSyncWindow_r13 = -1;    /* T_discSyncWindow_r13 */
static int hf_lte_rrc_gnss_Sync_r14_02 = -1;      /* T_gnss_Sync_r14_02 */
static int hf_lte_rrc_slss_TxDisabled_r15_01 = -1;  /* T_slss_TxDisabled_r15_01 */
static int hf_lte_rrc_prb_Num_r12 = -1;           /* INTEGER_1_100 */
static int hf_lte_rrc_prb_Start_r12 = -1;         /* INTEGER_0_99 */
static int hf_lte_rrc_prb_End_r12 = -1;           /* INTEGER_0_99 */
static int hf_lte_rrc_offsetIndicator_r12 = -1;   /* SL_OffsetIndicator_r12 */
static int hf_lte_rrc_subframeBitmap_r12 = -1;    /* SubframeBitmapSL_r12 */
static int hf_lte_rrc_bs4_r12 = -1;               /* BIT_STRING_SIZE_4 */
static int hf_lte_rrc_bs8_r12 = -1;               /* BIT_STRING_SIZE_8 */
static int hf_lte_rrc_bs12_r12 = -1;              /* BIT_STRING_SIZE_12 */
static int hf_lte_rrc_bs16_r12 = -1;              /* BIT_STRING_SIZE_16 */
static int hf_lte_rrc_bs30_r12 = -1;              /* BIT_STRING_SIZE_30 */
static int hf_lte_rrc_bs40_r12 = -1;              /* BIT_STRING_SIZE_40 */
static int hf_lte_rrc_bs42_r12 = -1;              /* BIT_STRING_SIZE_42 */
static int hf_lte_rrc_bs10_r14 = -1;              /* BIT_STRING_SIZE_10 */
static int hf_lte_rrc_bs16_r14 = -1;              /* BIT_STRING_SIZE_16 */
static int hf_lte_rrc_bs20_r14 = -1;              /* BIT_STRING_SIZE_20 */
static int hf_lte_rrc_bs30_r14 = -1;              /* BIT_STRING_SIZE_30 */
static int hf_lte_rrc_bs40_r14 = -1;              /* BIT_STRING_SIZE_40 */
static int hf_lte_rrc_bs50_r14 = -1;              /* BIT_STRING_SIZE_50 */
static int hf_lte_rrc_bs60_r14 = -1;              /* BIT_STRING_SIZE_60 */
static int hf_lte_rrc_bs100_r14 = -1;             /* BIT_STRING_SIZE_100 */
static int hf_lte_rrc_minusinfinity_r14 = -1;     /* NULL */
static int hf_lte_rrc_txPower_r14 = -1;           /* INTEGER_M41_31 */
static int hf_lte_rrc_SL_ThresPSSCH_RSRP_List_r14_item = -1;  /* SL_ThresPSSCH_RSRP_r14 */
static int hf_lte_rrc_alpha_r12 = -1;             /* Alpha_r12 */
static int hf_lte_rrc_p0_r12 = -1;                /* P0_SL_r12 */
static int hf_lte_rrc_SL_TxPoolToReleaseList_r12_item = -1;  /* SL_TxPoolIdentity_r12 */
static int hf_lte_rrc_SL_TxPoolToReleaseListExt_r13_item = -1;  /* SL_TxPoolIdentity_v1310 */
static int hf_lte_rrc_commTxResources_r14 = -1;   /* T_commTxResources_r14 */
static int hf_lte_rrc_setup_199 = -1;             /* T_setup_173 */
static int hf_lte_rrc_scheduled_r14 = -1;         /* T_scheduled_r14 */
static int hf_lte_rrc_sl_V_RNTI_r14 = -1;         /* C_RNTI */
static int hf_lte_rrc_mac_MainConfig_r14 = -1;    /* MAC_MainConfigSL_r12 */
static int hf_lte_rrc_mcs_r14 = -1;               /* INTEGER_0_31 */
static int hf_lte_rrc_logicalChGroupInfoList_r14 = -1;  /* LogicalChGroupInfoList_r13 */
static int hf_lte_rrc_ue_Selected_r14 = -1;       /* T_ue_Selected_r14 */
static int hf_lte_rrc_v2x_CommTxPoolNormalDedicated_r14 = -1;  /* T_v2x_CommTxPoolNormalDedicated_r14 */
static int hf_lte_rrc_poolToReleaseList_r14 = -1;  /* SL_TxPoolToReleaseListV2X_r14 */
static int hf_lte_rrc_poolToAddModList_r14 = -1;  /* SL_TxPoolToAddModListV2X_r14 */
static int hf_lte_rrc_v2x_CommTxPoolSensingConfig_r14 = -1;  /* SL_CommTxPoolSensingConfig_r14 */
static int hf_lte_rrc_cbr_DedicatedTxConfigList_r14 = -1;  /* SL_CBR_CommonTxConfigList_r14 */
static int hf_lte_rrc_commTxResources_v1530 = -1;  /* T_commTxResources_v1530 */
static int hf_lte_rrc_setup_200 = -1;             /* T_setup_174 */
static int hf_lte_rrc_scheduled_v1530 = -1;       /* T_scheduled_v1530 */
static int hf_lte_rrc_logicalChGroupInfoList_v1530 = -1;  /* LogicalChGroupInfoList_v1530 */
static int hf_lte_rrc_mcs_r15 = -1;               /* INTEGER_0_31 */
static int hf_lte_rrc_ue_Selected_v1530 = -1;     /* T_ue_Selected_v1530 */
static int hf_lte_rrc_slss_TxMultiFreq_r15_01 = -1;  /* T_slss_TxMultiFreq_r15_01 */
static int hf_lte_rrc_slss_TxDisabled_r15_02 = -1;  /* T_slss_TxDisabled_r15_02 */
static int hf_lte_rrc_LogicalChGroupInfoList_v1530_item = -1;  /* SL_ReliabilityList_r15 */
static int hf_lte_rrc_SL_TxPoolToAddModListV2X_r14_item = -1;  /* SL_TxPoolToAddMod_r14 */
static int hf_lte_rrc_poolIdentity_r14_01 = -1;   /* SL_V2X_TxPoolIdentity_r14 */
static int hf_lte_rrc_pool_r14 = -1;              /* SL_CommResourcePoolV2X_r14 */
static int hf_lte_rrc_SL_TxPoolToReleaseListV2X_r14_item = -1;  /* SL_V2X_TxPoolIdentity_r14 */
static int hf_lte_rrc_SL_V2X_FreqSelectionConfigList_r15_item = -1;  /* SL_V2X_FreqSelectionConfig_r15 */
static int hf_lte_rrc_threshCBR_FreqReselection_r15 = -1;  /* SL_CBR_r14 */
static int hf_lte_rrc_threshCBR_FreqKeeping_r15 = -1;  /* SL_CBR_r14 */
static int hf_lte_rrc_threshSL_Reliability_r15 = -1;  /* SL_Reliability_r15 */
static int hf_lte_rrc_allowedCarrierFreqConfig_r15 = -1;  /* SL_PPPR_Dest_CarrierFreqList_r15 */
static int hf_lte_rrc_SL_PPPR_Dest_CarrierFreqList_r15_item = -1;  /* SL_PPPR_Dest_CarrierFreq */
static int hf_lte_rrc_destinationInfoList_r15 = -1;  /* SL_DestinationInfoList_r12 */
static int hf_lte_rrc_allowedCarrierFreqList_r15 = -1;  /* SL_AllowedCarrierFreqList_r15 */
static int hf_lte_rrc_allowedCarrierFreqSet1 = -1;  /* SEQUENCE_SIZE_1_maxFreqV2X_r14_OF_ARFCN_ValueEUTRA_r9 */
static int hf_lte_rrc_allowedCarrierFreqSet1_item = -1;  /* ARFCN_ValueEUTRA_r9 */
static int hf_lte_rrc_allowedCarrierFreqSet2 = -1;  /* SEQUENCE_SIZE_1_maxFreqV2X_r14_OF_ARFCN_ValueEUTRA_r9 */
static int hf_lte_rrc_allowedCarrierFreqSet2_item = -1;  /* ARFCN_ValueEUTRA_r9 */
static int hf_lte_rrc_SL_V2X_SyncFreqList_r15_item = -1;  /* ARFCN_ValueEUTRA_r9 */
static int hf_lte_rrc_zoneLength_r14 = -1;        /* T_zoneLength_r14 */
static int hf_lte_rrc_zoneWidth_r14 = -1;         /* T_zoneWidth_r14 */
static int hf_lte_rrc_zoneIdLongiMod_r14 = -1;    /* INTEGER_1_4 */
static int hf_lte_rrc_zoneIdLatiMod_r14 = -1;     /* INTEGER_1_4 */
static int hf_lte_rrc_message_12 = -1;            /* SBCCH_SL_BCH_MessageType */
static int hf_lte_rrc_message_13 = -1;            /* SBCCH_SL_BCH_MessageType_V2X_r14 */
static int hf_lte_rrc_sl_Bandwidth_r12 = -1;      /* T_sl_Bandwidth_r12 */
static int hf_lte_rrc_tdd_ConfigSL_r12 = -1;      /* TDD_ConfigSL_r12 */
static int hf_lte_rrc_directFrameNumber_r12 = -1;  /* BIT_STRING_SIZE_10 */
static int hf_lte_rrc_directSubframeNumber_r12 = -1;  /* INTEGER_0_9 */
static int hf_lte_rrc_inCoverage_r12 = -1;        /* BOOLEAN */
static int hf_lte_rrc_reserved_r12 = -1;          /* BIT_STRING_SIZE_19 */
static int hf_lte_rrc_sl_Bandwidth_r14_01 = -1;   /* T_sl_Bandwidth_r14_01 */
static int hf_lte_rrc_tdd_ConfigSL_r14 = -1;      /* TDD_ConfigSL_r12 */
static int hf_lte_rrc_directFrameNumber_r14 = -1;  /* BIT_STRING_SIZE_10 */
static int hf_lte_rrc_directSubframeNumber_r14 = -1;  /* INTEGER_0_9 */
static int hf_lte_rrc_inCoverage_r14 = -1;        /* BOOLEAN */
static int hf_lte_rrc_reserved_r14 = -1;          /* BIT_STRING_SIZE_27 */
static int hf_lte_rrc_criticalExtensions_56 = -1;  /* T_criticalExtensions_56 */
static int hf_lte_rrc_c1_50 = -1;                 /* T_c1_50 */
static int hf_lte_rrc_handoverPreparationInformation_r13 = -1;  /* HandoverPreparationInformation_NB_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_54 = -1;  /* T_criticalExtensionsFuture_54 */
static int hf_lte_rrc_ue_RadioAccessCapabilityInfo_r13 = -1;  /* UE_Capability_NB_r13 */
static int hf_lte_rrc_as_Config_r13 = -1;         /* AS_Config_NB */
static int hf_lte_rrc_rrm_Config_r13 = -1;        /* RRM_Config_NB */
static int hf_lte_rrc_as_Context_r13 = -1;        /* AS_Context_NB */
static int hf_lte_rrc_nonCriticalExtension_292 = -1;  /* HandoverPreparationInformation_NB_v1380_IEs */
static int hf_lte_rrc_nonCriticalExtension_293 = -1;  /* HandoverPreparationInformation_NB_Ext_r14_IEs */
static int hf_lte_rrc_ue_RadioAccessCapabilityInfoExt_r14 = -1;  /* T_ue_RadioAccessCapabilityInfoExt_r14 */
static int hf_lte_rrc_nonCriticalExtension_294 = -1;  /* T_nonCriticalExtension_80 */
static int hf_lte_rrc_criticalExtensions_57 = -1;  /* T_criticalExtensions_57 */
static int hf_lte_rrc_c1_51 = -1;                 /* T_c1_51 */
static int hf_lte_rrc_uePagingCoverageInformation_r13_01 = -1;  /* UEPagingCoverageInformation_NB_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_55 = -1;  /* T_criticalExtensionsFuture_55 */
static int hf_lte_rrc_npdcch_NumRepetitionPaging_r13 = -1;  /* INTEGER_1_2048 */
static int hf_lte_rrc_nonCriticalExtension_295 = -1;  /* T_nonCriticalExtension_81 */
static int hf_lte_rrc_criticalExtensions_58 = -1;  /* T_criticalExtensions_58 */
static int hf_lte_rrc_c1_52 = -1;                 /* T_c1_52 */
static int hf_lte_rrc_ueRadioAccessCapabilityInformation_r13 = -1;  /* UERadioAccessCapabilityInformation_NB_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_56 = -1;  /* T_criticalExtensionsFuture_56 */
static int hf_lte_rrc_ue_RadioAccessCapabilityInfo_r13_01 = -1;  /* T_ue_RadioAccessCapabilityInfo_r13 */
static int hf_lte_rrc_nonCriticalExtension_296 = -1;  /* UERadioAccessCapabilityInformation_NB_v1380_IEs */
static int hf_lte_rrc_nonCriticalExtension_297 = -1;  /* UERadioAccessCapabilityInformation_NB_r14_IEs */
static int hf_lte_rrc_ue_RadioAccessCapabilityInfo_r14 = -1;  /* T_ue_RadioAccessCapabilityInfo_r14 */
static int hf_lte_rrc_nonCriticalExtension_298 = -1;  /* T_nonCriticalExtension_82 */
static int hf_lte_rrc_criticalExtensions_59 = -1;  /* T_criticalExtensions_59 */
static int hf_lte_rrc_c1_53 = -1;                 /* T_c1_53 */
static int hf_lte_rrc_ueRadioPagingInformation_r13 = -1;  /* UERadioPagingInformation_NB_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_57 = -1;  /* T_criticalExtensionsFuture_57 */
static int hf_lte_rrc_ue_RadioPagingInfo_r13 = -1;  /* T_ue_RadioPagingInfo_r13 */
static int hf_lte_rrc_nonCriticalExtension_299 = -1;  /* T_nonCriticalExtension_83 */
static int hf_lte_rrc_sourceRadioResourceConfig_r13 = -1;  /* RadioResourceConfigDedicated_NB_r13 */
static int hf_lte_rrc_sourceSecurityAlgorithmConfig_r13 = -1;  /* SecurityAlgorithmConfig */
static int hf_lte_rrc_sourceUE_Identity_r13 = -1;  /* C_RNTI */
static int hf_lte_rrc_sourceDl_CarrierFreq_r13 = -1;  /* CarrierFreq_NB_r13 */
static int hf_lte_rrc_sourceDL_CarrierFreq_v1550 = -1;  /* CarrierFreq_NB_v1550 */
static int hf_lte_rrc_reestablishmentInfo_r13 = -1;  /* ReestablishmentInfo_NB */
static int hf_lte_rrc_sourcePhysCellId_r13 = -1;  /* PhysCellId */
static int hf_lte_rrc_targetCellShortMAC_I_r13 = -1;  /* ShortMAC_I */
static int hf_lte_rrc_additionalReestabInfoList_r13 = -1;  /* AdditionalReestabInfoList */
static int hf_lte_rrc_ue_InactiveTime_01 = -1;    /* T_ue_InactiveTime_01 */
static int hf_lte_rrc_message_14 = -1;            /* BCCH_BCH_MessageType_NB */
static int hf_lte_rrc_message_15 = -1;            /* BCCH_BCH_MessageType_TDD_NB_r15 */
static int hf_lte_rrc_message_16 = -1;            /* BCCH_DL_SCH_MessageType_NB */
static int hf_lte_rrc_c1_54 = -1;                 /* T_c1_54 */
static int hf_lte_rrc_systemInformation_r13 = -1;  /* SystemInformation_NB */
static int hf_lte_rrc_systemInformationBlockType1_r13 = -1;  /* SystemInformationBlockType1_NB */
static int hf_lte_rrc_messageClassExtension_10 = -1;  /* T_messageClassExtension_10 */
static int hf_lte_rrc_message_17 = -1;            /* PCCH_MessageType_NB */
static int hf_lte_rrc_c1_55 = -1;                 /* T_c1_55 */
static int hf_lte_rrc_paging_r13 = -1;            /* Paging_NB */
static int hf_lte_rrc_messageClassExtension_11 = -1;  /* T_messageClassExtension_11 */
static int hf_lte_rrc_message_18 = -1;            /* DL_CCCH_MessageType_NB */
static int hf_lte_rrc_c1_56 = -1;                 /* T_c1_56 */
static int hf_lte_rrc_rrcConnectionReestablishment_r13 = -1;  /* RRCConnectionReestablishment_NB */
static int hf_lte_rrc_rrcConnectionReestablishmentReject_r13 = -1;  /* RRCConnectionReestablishmentReject */
static int hf_lte_rrc_rrcConnectionReject_r13 = -1;  /* RRCConnectionReject_NB */
static int hf_lte_rrc_rrcConnectionSetup_r13 = -1;  /* RRCConnectionSetup_NB */
static int hf_lte_rrc_rrcEarlyDataComplete_r15_02 = -1;  /* RRCEarlyDataComplete_NB_r15 */
static int hf_lte_rrc_messageClassExtension_12 = -1;  /* T_messageClassExtension_12 */
static int hf_lte_rrc_message_19 = -1;            /* DL_DCCH_MessageType_NB */
static int hf_lte_rrc_c1_57 = -1;                 /* T_c1_57 */
static int hf_lte_rrc_dlInformationTransfer_r13 = -1;  /* DLInformationTransfer_NB */
static int hf_lte_rrc_rrcConnectionReconfiguration_r13 = -1;  /* RRCConnectionReconfiguration_NB */
static int hf_lte_rrc_rrcConnectionRelease_r13 = -1;  /* RRCConnectionRelease_NB */
static int hf_lte_rrc_securityModeCommand_r13 = -1;  /* SecurityModeCommand */
static int hf_lte_rrc_ueCapabilityEnquiry_r13 = -1;  /* UECapabilityEnquiry_NB */
static int hf_lte_rrc_rrcConnectionResume_r13_02 = -1;  /* RRCConnectionResume_NB */
static int hf_lte_rrc_messageClassExtension_13 = -1;  /* T_messageClassExtension_13 */
static int hf_lte_rrc_message_20 = -1;            /* UL_CCCH_MessageType_NB */
static int hf_lte_rrc_c1_58 = -1;                 /* T_c1_58 */
static int hf_lte_rrc_rrcConnectionReestablishmentRequest_r13 = -1;  /* RRCConnectionReestablishmentRequest_NB */
static int hf_lte_rrc_rrcConnectionRequest_r13 = -1;  /* RRCConnectionRequest_NB */
static int hf_lte_rrc_rrcConnectionResumeRequest_r13_02 = -1;  /* RRCConnectionResumeRequest_NB */
static int hf_lte_rrc_rrcEarlyDataRequest_r15_02 = -1;  /* RRCEarlyDataRequest_NB_r15 */
static int hf_lte_rrc_messageClassExtension_14 = -1;  /* T_messageClassExtension_14 */
static int hf_lte_rrc_message_21 = -1;            /* SC_MCCH_MessageType_NB */
static int hf_lte_rrc_c1_59 = -1;                 /* T_c1_59 */
static int hf_lte_rrc_scptmConfiguration_r14 = -1;  /* SCPTMConfiguration_NB_r14 */
static int hf_lte_rrc_messageClassExtension_15 = -1;  /* T_messageClassExtension_15 */
static int hf_lte_rrc_message_22 = -1;            /* UL_DCCH_MessageType_NB */
static int hf_lte_rrc_c1_60 = -1;                 /* T_c1_60 */
static int hf_lte_rrc_rrcConnectionReconfigurationComplete_r13 = -1;  /* RRCConnectionReconfigurationComplete_NB */
static int hf_lte_rrc_rrcConnectionReestablishmentComplete_r13 = -1;  /* RRCConnectionReestablishmentComplete_NB */
static int hf_lte_rrc_rrcConnectionSetupComplete_r13 = -1;  /* RRCConnectionSetupComplete_NB */
static int hf_lte_rrc_securityModeComplete_r13 = -1;  /* SecurityModeComplete */
static int hf_lte_rrc_securityModeFailure_r13 = -1;  /* SecurityModeFailure */
static int hf_lte_rrc_ueCapabilityInformation_r13 = -1;  /* UECapabilityInformation_NB */
static int hf_lte_rrc_ulInformationTransfer_r13 = -1;  /* ULInformationTransfer_NB */
static int hf_lte_rrc_rrcConnectionResumeComplete_r13_02 = -1;  /* RRCConnectionResumeComplete_NB */
static int hf_lte_rrc_spare8 = -1;                /* NULL */
static int hf_lte_rrc_messageClassExtension_16 = -1;  /* T_messageClassExtension_16 */
static int hf_lte_rrc_criticalExtensions_60 = -1;  /* T_criticalExtensions_60 */
static int hf_lte_rrc_c1_61 = -1;                 /* T_c1_61 */
static int hf_lte_rrc_dlInformationTransfer_r13_01 = -1;  /* DLInformationTransfer_NB_r13_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_58 = -1;  /* T_criticalExtensionsFuture_58 */
static int hf_lte_rrc_nonCriticalExtension_300 = -1;  /* T_nonCriticalExtension_84 */
static int hf_lte_rrc_systemFrameNumber_MSB_r13 = -1;  /* BIT_STRING_SIZE_4 */
static int hf_lte_rrc_hyperSFN_LSB_r13 = -1;      /* BIT_STRING_SIZE_2 */
static int hf_lte_rrc_schedulingInfoSIB1_r13 = -1;  /* INTEGER_0_15 */
static int hf_lte_rrc_systemInfoValueTag_r13 = -1;  /* INTEGER_0_31 */
static int hf_lte_rrc_ab_Enabled_r13 = -1;        /* BOOLEAN */
static int hf_lte_rrc_operationModeInfo_r13 = -1;  /* T_operationModeInfo_r13 */
static int hf_lte_rrc_inband_SamePCI_r13 = -1;    /* Inband_SamePCI_NB_r13 */
static int hf_lte_rrc_inband_DifferentPCI_r13 = -1;  /* Inband_DifferentPCI_NB_r13 */
static int hf_lte_rrc_guardband_r13 = -1;         /* Guardband_NB_r13 */
static int hf_lte_rrc_standalone_r13 = -1;        /* Standalone_NB_r13 */
static int hf_lte_rrc_additionalTransmissionSIB1_r15 = -1;  /* BOOLEAN */
static int hf_lte_rrc_spare_05 = -1;              /* BIT_STRING_SIZE_10 */
static int hf_lte_rrc_rasterOffset_r13 = -1;      /* ChannelRasterOffset_NB_r13 */
static int hf_lte_rrc_spare_06 = -1;              /* BIT_STRING_SIZE_3 */
static int hf_lte_rrc_eutra_CRS_SequenceInfo_r13 = -1;  /* INTEGER_0_31 */
static int hf_lte_rrc_eutra_NumCRS_Ports_r13 = -1;  /* T_eutra_NumCRS_Ports_r13 */
static int hf_lte_rrc_spare_07 = -1;              /* BIT_STRING_SIZE_5 */
static int hf_lte_rrc_systemFrameNumber_MSB_r15 = -1;  /* BIT_STRING_SIZE_4 */
static int hf_lte_rrc_hyperSFN_LSB_r15 = -1;      /* BIT_STRING_SIZE_2 */
static int hf_lte_rrc_schedulingInfoSIB1_r15 = -1;  /* INTEGER_0_15 */
static int hf_lte_rrc_systemInfoValueTag_r15 = -1;  /* INTEGER_0_31 */
static int hf_lte_rrc_ab_Enabled_r15 = -1;        /* BOOLEAN */
static int hf_lte_rrc_operationModeInfo_r15 = -1;  /* T_operationModeInfo_r15 */
static int hf_lte_rrc_inband_SamePCI_r15 = -1;    /* Inband_SamePCI_TDD_NB_r15 */
static int hf_lte_rrc_inband_DifferentPCI_r15 = -1;  /* Inband_DifferentPCI_TDD_NB_r15 */
static int hf_lte_rrc_guardband_r15 = -1;         /* GuardbandTDD_NB_r15 */
static int hf_lte_rrc_standalone_r15 = -1;        /* StandaloneTDD_NB_r15 */
static int hf_lte_rrc_sib1_CarrierInfo_r15 = -1;  /* T_sib1_CarrierInfo_r15 */
static int hf_lte_rrc_spare_08 = -1;              /* BIT_STRING_SIZE_9 */
static int hf_lte_rrc_rasterOffset_r15 = -1;      /* ChannelRasterOffset_NB_r13 */
static int hf_lte_rrc_sib_GuardbandInfo_r15 = -1;  /* T_sib_GuardbandInfo_r15 */
static int hf_lte_rrc_sib_GuardbandAnchor_r15 = -1;  /* SIB_GuardbandAnchorTDD_NB_r15 */
static int hf_lte_rrc_sib_GuardbandGuardband_r15 = -1;  /* SIB_GuardbandGuardbandTDD_NB_r15 */
static int hf_lte_rrc_sib_GuardbandInbandSamePCI_r15 = -1;  /* SIB_GuardbandInbandSamePCI_TDD_NB_r15 */
static int hf_lte_rrc_sib_GuardbandinbandDiffPCI_r15 = -1;  /* SIB_GuardbandInbandDiffPCI_TDD_NB_r15 */
static int hf_lte_rrc_eutra_Bandwitdh_r15 = -1;   /* T_eutra_Bandwitdh_r15 */
static int hf_lte_rrc_eutra_CRS_SequenceInfo_r15 = -1;  /* INTEGER_0_31 */
static int hf_lte_rrc_sib_InbandLocation_r15 = -1;  /* T_sib_InbandLocation_r15 */
static int hf_lte_rrc_eutra_NumCRS_Ports_r15 = -1;  /* T_eutra_NumCRS_Ports_r15 */
static int hf_lte_rrc_sib_InbandLocation_r15_01 = -1;  /* T_sib_InbandLocation_r15_01 */
static int hf_lte_rrc_sib_StandaloneLocation_r15 = -1;  /* T_sib_StandaloneLocation_r15 */
static int hf_lte_rrc_sib_GuardbandGuardbandLocation_r15 = -1;  /* T_sib_GuardbandGuardbandLocation_r15 */
static int hf_lte_rrc_sib_EUTRA_NumCRS_Ports_r15 = -1;  /* T_sib_EUTRA_NumCRS_Ports_r15 */
static int hf_lte_rrc_pagingRecordList_r13 = -1;  /* PagingRecordList_NB_r13 */
static int hf_lte_rrc_systemInfoModification_r13 = -1;  /* T_systemInfoModification_r13 */
static int hf_lte_rrc_systemInfoModification_eDRX_r13_01 = -1;  /* T_systemInfoModification_eDRX_r13_01 */
static int hf_lte_rrc_nonCriticalExtension_301 = -1;  /* T_nonCriticalExtension_85 */
static int hf_lte_rrc_PagingRecordList_NB_r13_item = -1;  /* PagingRecord_NB_r13 */
static int hf_lte_rrc_ue_Identity_r13 = -1;       /* PagingUE_Identity */
static int hf_lte_rrc_criticalExtensions_61 = -1;  /* T_criticalExtensions_61 */
static int hf_lte_rrc_c1_62 = -1;                 /* T_c1_62 */
static int hf_lte_rrc_rrcConnectionReconfiguration_r13_01 = -1;  /* RRCConnectionReconfiguration_NB_r13_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_59 = -1;  /* T_criticalExtensionsFuture_59 */
static int hf_lte_rrc_dedicatedInfoNASList_r13 = -1;  /* SEQUENCE_SIZE_1_maxDRB_NB_r13_OF_DedicatedInfoNAS */
static int hf_lte_rrc_dedicatedInfoNASList_r13_item = -1;  /* DedicatedInfoNAS */
static int hf_lte_rrc_radioResourceConfigDedicated_r13_01 = -1;  /* RadioResourceConfigDedicated_NB_r13 */
static int hf_lte_rrc_fullConfig_r13 = -1;        /* T_fullConfig_r13 */
static int hf_lte_rrc_nonCriticalExtension_302 = -1;  /* T_nonCriticalExtension_86 */
static int hf_lte_rrc_criticalExtensions_62 = -1;  /* T_criticalExtensions_62 */
static int hf_lte_rrc_rrcConnectionReconfigurationComplete_r13_01 = -1;  /* RRCConnectionReconfigurationComplete_NB_r13_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_60 = -1;  /* T_criticalExtensionsFuture_60 */
static int hf_lte_rrc_nonCriticalExtension_303 = -1;  /* T_nonCriticalExtension_87 */
static int hf_lte_rrc_criticalExtensions_63 = -1;  /* T_criticalExtensions_63 */
static int hf_lte_rrc_c1_63 = -1;                 /* T_c1_63 */
static int hf_lte_rrc_rrcConnectionReestablishment_r13_01 = -1;  /* RRCConnectionReestablishment_NB_r13_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_61 = -1;  /* T_criticalExtensionsFuture_61 */
static int hf_lte_rrc_nonCriticalExtension_304 = -1;  /* RRCConnectionReestablishment_NB_v1430_IEs */
static int hf_lte_rrc_dl_NAS_MAC = -1;            /* BIT_STRING_SIZE_16 */
static int hf_lte_rrc_nonCriticalExtension_305 = -1;  /* T_nonCriticalExtension_88 */
static int hf_lte_rrc_criticalExtensions_64 = -1;  /* T_criticalExtensions_64 */
static int hf_lte_rrc_rrcConnectionReestablishmentComplete_r13_01 = -1;  /* RRCConnectionReestablishmentComplete_NB_r13_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_62 = -1;  /* T_criticalExtensionsFuture_62 */
static int hf_lte_rrc_nonCriticalExtension_306 = -1;  /* RRCConnectionReestablishmentComplete_NB_v1470_IEs */
static int hf_lte_rrc_measResultServCell_r14 = -1;  /* MeasResultServCell_NB_r14 */
static int hf_lte_rrc_nonCriticalExtension_307 = -1;  /* T_nonCriticalExtension_89 */
static int hf_lte_rrc_criticalExtensions_65 = -1;  /* T_criticalExtensions_65 */
static int hf_lte_rrc_rrcConnectionReestablishmentRequest_r13_01 = -1;  /* RRCConnectionReestablishmentRequest_NB_r13_IEs */
static int hf_lte_rrc_later_01 = -1;              /* T_later_01 */
static int hf_lte_rrc_rrcConnectionReestablishmentRequest_r14 = -1;  /* RRCConnectionReestablishmentRequest_NB_r14_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_63 = -1;  /* T_criticalExtensionsFuture_63 */
static int hf_lte_rrc_ue_Identity_r13_01 = -1;    /* ReestabUE_Identity */
static int hf_lte_rrc_reestablishmentCause_r13 = -1;  /* ReestablishmentCause_NB_r13 */
static int hf_lte_rrc_cqi_NPDCCH_r14 = -1;        /* CQI_NPDCCH_NB_r14 */
static int hf_lte_rrc_earlyContentionResolution_r14 = -1;  /* BOOLEAN */
static int hf_lte_rrc_spare_09 = -1;              /* BIT_STRING_SIZE_20 */
static int hf_lte_rrc_ue_Identity_r14 = -1;       /* ReestabUE_Identity_CP_NB_r14 */
static int hf_lte_rrc_reestablishmentCause_r14 = -1;  /* ReestablishmentCause_NB_r13 */
static int hf_lte_rrc_cqi_NPDCCH_r14_01 = -1;     /* CQI_NPDCCH_Short_NB_r14 */
static int hf_lte_rrc_s_TMSI_r14 = -1;            /* S_TMSI */
static int hf_lte_rrc_ul_NAS_MAC_r14 = -1;        /* BIT_STRING_SIZE_16 */
static int hf_lte_rrc_ul_NAS_Count_r14 = -1;      /* BIT_STRING_SIZE_5 */
static int hf_lte_rrc_criticalExtensions_66 = -1;  /* T_criticalExtensions_66 */
static int hf_lte_rrc_c1_64 = -1;                 /* T_c1_64 */
static int hf_lte_rrc_rrcConnectionReject_r13_01 = -1;  /* RRCConnectionReject_NB_r13_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_64 = -1;  /* T_criticalExtensionsFuture_64 */
static int hf_lte_rrc_extendedWaitTime_r13 = -1;  /* INTEGER_1_1800 */
static int hf_lte_rrc_rrc_SuspendIndication_r13_01 = -1;  /* T_rrc_SuspendIndication_r13_01 */
static int hf_lte_rrc_nonCriticalExtension_308 = -1;  /* T_nonCriticalExtension_90 */
static int hf_lte_rrc_criticalExtensions_67 = -1;  /* T_criticalExtensions_67 */
static int hf_lte_rrc_c1_65 = -1;                 /* T_c1_65 */
static int hf_lte_rrc_rrcConnectionRelease_r13_01 = -1;  /* RRCConnectionRelease_NB_r13_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_65 = -1;  /* T_criticalExtensionsFuture_65 */
static int hf_lte_rrc_releaseCause_r13 = -1;      /* ReleaseCause_NB_r13 */
static int hf_lte_rrc_redirectedCarrierInfo_r13 = -1;  /* RedirectedCarrierInfo_NB_r13 */
static int hf_lte_rrc_nonCriticalExtension_309 = -1;  /* RRCConnectionRelease_NB_v1430_IEs */
static int hf_lte_rrc_redirectedCarrierInfo_v1430 = -1;  /* RedirectedCarrierInfo_NB_v1430 */
static int hf_lte_rrc_extendedWaitTime_CPdata_r14 = -1;  /* INTEGER_1_1800 */
static int hf_lte_rrc_nonCriticalExtension_310 = -1;  /* RRCConnectionRelease_NB_v1530_IEs */
static int hf_lte_rrc_drb_ContinueROHC_r15_01 = -1;  /* T_drb_ContinueROHC_r15_01 */
static int hf_lte_rrc_nonCriticalExtension_311 = -1;  /* RRCConnectionRelease_NB_v1550_IEs */
static int hf_lte_rrc_redirectedCarrierInfo_v1550 = -1;  /* RedirectedCarrierInfo_NB_v1550 */
static int hf_lte_rrc_nonCriticalExtension_312 = -1;  /* T_nonCriticalExtension_91 */
static int hf_lte_rrc_redirectedCarrierOffsetDedicated_r14 = -1;  /* T_redirectedCarrierOffsetDedicated_r14 */
static int hf_lte_rrc_t322_r14 = -1;              /* T_t322_r14 */
static int hf_lte_rrc_criticalExtensions_68 = -1;  /* T_criticalExtensions_68 */
static int hf_lte_rrc_rrcConnectionRequest_r13_01 = -1;  /* RRCConnectionRequest_NB_r13_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_66 = -1;  /* T_criticalExtensionsFuture_66 */
static int hf_lte_rrc_ue_Identity_r13_02 = -1;    /* InitialUE_Identity */
static int hf_lte_rrc_establishmentCause_r13 = -1;  /* EstablishmentCause_NB_r13 */
static int hf_lte_rrc_multiToneSupport_r13 = -1;  /* T_multiToneSupport_r13 */
static int hf_lte_rrc_multiCarrierSupport_r13 = -1;  /* T_multiCarrierSupport_r13 */
static int hf_lte_rrc_spare_10 = -1;              /* BIT_STRING_SIZE_17 */
static int hf_lte_rrc_criticalExtensions_69 = -1;  /* T_criticalExtensions_69 */
static int hf_lte_rrc_c1_66 = -1;                 /* T_c1_66 */
static int hf_lte_rrc_rrcConnectionResume_r13_03 = -1;  /* RRCConnectionResume_NB_r13_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_67 = -1;  /* T_criticalExtensionsFuture_67 */
static int hf_lte_rrc_drb_ContinueROHC_r13_01 = -1;  /* T_drb_ContinueROHC_r13_01 */
static int hf_lte_rrc_nonCriticalExtension_313 = -1;  /* T_nonCriticalExtension_92 */
static int hf_lte_rrc_criticalExtensions_70 = -1;  /* T_criticalExtensions_70 */
static int hf_lte_rrc_rrcConnectionResumeComplete_r13_03 = -1;  /* RRCConnectionResumeComplete_NB_r13_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_68 = -1;  /* T_criticalExtensionsFuture_68 */
static int hf_lte_rrc_nonCriticalExtension_314 = -1;  /* RRCConnectionResumeComplete_NB_v1470_IEs */
static int hf_lte_rrc_nonCriticalExtension_315 = -1;  /* T_nonCriticalExtension_93 */
static int hf_lte_rrc_criticalExtensions_71 = -1;  /* T_criticalExtensions_71 */
static int hf_lte_rrc_rrcConnectionResumeRequest_r13_03 = -1;  /* RRCConnectionResumeRequest_NB_r13_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_69 = -1;  /* T_criticalExtensionsFuture_69 */
static int hf_lte_rrc_shortResumeMAC_I_r13_01 = -1;  /* ShortMAC_I */
static int hf_lte_rrc_resumeCause_r13_01 = -1;    /* EstablishmentCause_NB_r13 */
static int hf_lte_rrc_criticalExtensions_72 = -1;  /* T_criticalExtensions_72 */
static int hf_lte_rrc_c1_67 = -1;                 /* T_c1_67 */
static int hf_lte_rrc_rrcConnectionSetup_r13_01 = -1;  /* RRCConnectionSetup_NB_r13_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_70 = -1;  /* T_criticalExtensionsFuture_70 */
static int hf_lte_rrc_nonCriticalExtension_316 = -1;  /* T_nonCriticalExtension_94 */
static int hf_lte_rrc_criticalExtensions_73 = -1;  /* T_criticalExtensions_73 */
static int hf_lte_rrc_rrcConnectionSetupComplete_r13_01 = -1;  /* RRCConnectionSetupComplete_NB_r13_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_71 = -1;  /* T_criticalExtensionsFuture_71 */
static int hf_lte_rrc_registeredMME_r13 = -1;     /* RegisteredMME */
static int hf_lte_rrc_attachWithoutPDN_Connectivity_r13_02 = -1;  /* T_attachWithoutPDN_Connectivity_r13_02 */
static int hf_lte_rrc_up_CIoT_EPS_Optimisation_r13_02 = -1;  /* T_up_CIoT_EPS_Optimisation_r13_02 */
static int hf_lte_rrc_nonCriticalExtension_317 = -1;  /* RRCConnectionSetupComplete_NB_v1430_IEs */
static int hf_lte_rrc_gummei_Type_r14 = -1;       /* T_gummei_Type_r14 */
static int hf_lte_rrc_nonCriticalExtension_318 = -1;  /* RRCConnectionSetupComplete_NB_v1470_IEs */
static int hf_lte_rrc_nonCriticalExtension_319 = -1;  /* T_nonCriticalExtension_95 */
static int hf_lte_rrc_criticalExtensions_74 = -1;  /* T_criticalExtensions_74 */
static int hf_lte_rrc_rrcEarlyDataComplete_r15_03 = -1;  /* RRCEarlyDataComplete_NB_r15_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_72 = -1;  /* T_criticalExtensionsFuture_72 */
static int hf_lte_rrc_redirectedCarrierInfo_r15_01 = -1;  /* RedirectedCarrierInfo_NB_r13 */
static int hf_lte_rrc_redirectedCarrierInfoExt_r15 = -1;  /* RedirectedCarrierInfo_NB_v1430 */
static int hf_lte_rrc_nonCriticalExtension_320 = -1;  /* T_nonCriticalExtension_96 */
static int hf_lte_rrc_criticalExtensions_75 = -1;  /* T_criticalExtensions_75 */
static int hf_lte_rrc_rrcEarlyDataRequest_r15_03 = -1;  /* RRCEarlyDataRequest_NB_r15_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_73 = -1;  /* T_criticalExtensionsFuture_73 */
static int hf_lte_rrc_establishmentCause_r15_01 = -1;  /* T_establishmentCause_r15_01 */
static int hf_lte_rrc_cqi_NPDCCH_r15 = -1;        /* CQI_NPDCCH_NB_r14 */
static int hf_lte_rrc_nonCriticalExtension_321 = -1;  /* T_nonCriticalExtension_97 */
static int hf_lte_rrc_sc_mtch_InfoList_r14_01 = -1;  /* SC_MTCH_InfoList_NB_r14 */
static int hf_lte_rrc_scptm_NeighbourCellList_r14_01 = -1;  /* SCPTM_NeighbourCellList_NB_r14 */
static int hf_lte_rrc_nonCriticalExtension_322 = -1;  /* T_nonCriticalExtension_98 */
static int hf_lte_rrc_criticalExtensions_76 = -1;  /* T_criticalExtensions_76 */
static int hf_lte_rrc_systemInformation_r13_01 = -1;  /* SystemInformation_NB_r13_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_74 = -1;  /* T_criticalExtensionsFuture_74 */
static int hf_lte_rrc_sib_TypeAndInfo_r13 = -1;   /* T_sib_TypeAndInfo_r13 */
static int hf_lte_rrc_sib_TypeAndInfo_r13_item = -1;  /* T_sib_TypeAndInfo_r13_item */
static int hf_lte_rrc_sib2_r13 = -1;              /* SystemInformationBlockType2_NB_r13 */
static int hf_lte_rrc_sib3_r13 = -1;              /* SystemInformationBlockType3_NB_r13 */
static int hf_lte_rrc_sib4_r13 = -1;              /* SystemInformationBlockType4_NB_r13 */
static int hf_lte_rrc_sib5_r13 = -1;              /* SystemInformationBlockType5_NB_r13 */
static int hf_lte_rrc_sib14_r13 = -1;             /* SystemInformationBlockType14_NB_r13 */
static int hf_lte_rrc_sib16_r13 = -1;             /* SystemInformationBlockType16_NB_r13 */
static int hf_lte_rrc_sib15_v1430 = -1;           /* SystemInformationBlockType15_NB_r14 */
static int hf_lte_rrc_sib20_v1430 = -1;           /* SystemInformationBlockType20_NB_r14 */
static int hf_lte_rrc_sib22_v1430 = -1;           /* SystemInformationBlockType22_NB_r14 */
static int hf_lte_rrc_sib23_v1530 = -1;           /* SystemInformationBlockType23_NB_r15 */
static int hf_lte_rrc_nonCriticalExtension_323 = -1;  /* T_nonCriticalExtension_99 */
static int hf_lte_rrc_hyperSFN_MSB_r13 = -1;      /* BIT_STRING_SIZE_8 */
static int hf_lte_rrc_cellAccessRelatedInfo_r13 = -1;  /* T_cellAccessRelatedInfo_r13 */
static int hf_lte_rrc_plmn_IdentityList_r13_01 = -1;  /* PLMN_IdentityList_NB_r13 */
static int hf_lte_rrc_trackingAreaCode_r13 = -1;  /* TrackingAreaCode */
static int hf_lte_rrc_cellIdentity_r13 = -1;      /* CellIdentity */
static int hf_lte_rrc_cellBarred_r13 = -1;        /* T_cellBarred_r13 */
static int hf_lte_rrc_intraFreqReselection_r13 = -1;  /* T_intraFreqReselection_r13 */
static int hf_lte_rrc_cellSelectionInfo_r13 = -1;  /* T_cellSelectionInfo_r13 */
static int hf_lte_rrc_q_QualMin_r13 = -1;         /* Q_QualMin_r9 */
static int hf_lte_rrc_freqBandIndicator_r13_01 = -1;  /* FreqBandIndicator_NB_r13 */
static int hf_lte_rrc_freqBandInfo_r13 = -1;      /* NS_PmaxList_NB_r13 */
static int hf_lte_rrc_multiBandInfoList_r13_01 = -1;  /* MultiBandInfoList_NB_r13 */
static int hf_lte_rrc_downlinkBitmap_r13 = -1;    /* DL_Bitmap_NB_r13 */
static int hf_lte_rrc_eutraControlRegionSize_r13 = -1;  /* T_eutraControlRegionSize_r13 */
static int hf_lte_rrc_nrs_CRS_PowerOffset_r13 = -1;  /* T_nrs_CRS_PowerOffset_r13 */
static int hf_lte_rrc_schedulingInfoList_r13 = -1;  /* SchedulingInfoList_NB_r13 */
static int hf_lte_rrc_si_WindowLength_r13 = -1;   /* T_si_WindowLength_r13 */
static int hf_lte_rrc_si_RadioFrameOffset_r13 = -1;  /* INTEGER_1_15 */
static int hf_lte_rrc_systemInfoValueTagList_r13_01 = -1;  /* SystemInfoValueTagList_NB_r13 */
static int hf_lte_rrc_nonCriticalExtension_324 = -1;  /* SystemInformationBlockType1_NB_v1350 */
static int hf_lte_rrc_cellSelectionInfo_v1350 = -1;  /* CellSelectionInfo_NB_v1350 */
static int hf_lte_rrc_nonCriticalExtension_325 = -1;  /* SystemInformationBlockType1_NB_v1430 */
static int hf_lte_rrc_cellSelectionInfo_v1430 = -1;  /* CellSelectionInfo_NB_v1430 */
static int hf_lte_rrc_nonCriticalExtension_326 = -1;  /* SystemInformationBlockType1_NB_v1450 */
static int hf_lte_rrc_nrs_CRS_PowerOffset_v1450 = -1;  /* T_nrs_CRS_PowerOffset_v1450 */
static int hf_lte_rrc_nonCriticalExtension_327 = -1;  /* SystemInformationBlockType1_NB_v1530 */
static int hf_lte_rrc_tdd_Parameters_r15 = -1;    /* T_tdd_Parameters_r15 */
static int hf_lte_rrc_tdd_Config_r15 = -1;        /* TDD_Config_NB_r15 */
static int hf_lte_rrc_tdd_SI_CarrierInfo_r15 = -1;  /* T_tdd_SI_CarrierInfo_r15 */
static int hf_lte_rrc_tdd_SI_SubframesBitmap_r15 = -1;  /* DL_Bitmap_NB_r13 */
static int hf_lte_rrc_schedulingInfoList_v1530 = -1;  /* SchedulingInfoList_NB_v1530 */
static int hf_lte_rrc_nonCriticalExtension_328 = -1;  /* T_nonCriticalExtension_100 */
static int hf_lte_rrc_PLMN_IdentityList_NB_r13_item = -1;  /* PLMN_IdentityInfo_NB_r13 */
static int hf_lte_rrc_plmn_Identity_r13 = -1;     /* PLMN_Identity */
static int hf_lte_rrc_cellReservedForOperatorUse_r13 = -1;  /* T_cellReservedForOperatorUse_r13 */
static int hf_lte_rrc_attachWithoutPDN_Connectivity_r13_03 = -1;  /* T_attachWithoutPDN_Connectivity_r13_03 */
static int hf_lte_rrc_SchedulingInfoList_NB_r13_item = -1;  /* SchedulingInfo_NB_r13 */
static int hf_lte_rrc_SchedulingInfoList_NB_v1530_item = -1;  /* SchedulingInfo_NB_v1530 */
static int hf_lte_rrc_si_Periodicity_r13 = -1;    /* T_si_Periodicity_r13 */
static int hf_lte_rrc_si_RepetitionPattern_r13_01 = -1;  /* T_si_RepetitionPattern_r13_01 */
static int hf_lte_rrc_sib_MappingInfo_r13 = -1;   /* SIB_MappingInfo_NB_r13 */
static int hf_lte_rrc_si_TB_r13 = -1;             /* T_si_TB_r13 */
static int hf_lte_rrc_sib_MappingInfo_v1530 = -1;  /* SIB_MappingInfo_NB_v1530 */
static int hf_lte_rrc_SystemInfoValueTagList_NB_r13_item = -1;  /* SystemInfoValueTagSI_r13 */
static int hf_lte_rrc_SIB_MappingInfo_NB_r13_item = -1;  /* SIB_Type_NB_r13 */
static int hf_lte_rrc_SIB_MappingInfo_NB_v1530_item = -1;  /* SIB_Type_NB_v1530 */
static int hf_lte_rrc_delta_RxLevMin_v1350 = -1;  /* INTEGER_M8_M1 */
static int hf_lte_rrc_powerClass14dBm_Offset_r14 = -1;  /* T_powerClass14dBm_Offset_r14 */
static int hf_lte_rrc_ce_authorisationOffset_r14 = -1;  /* T_ce_authorisationOffset_r14 */
static int hf_lte_rrc_criticalExtensions_77 = -1;  /* T_criticalExtensions_77 */
static int hf_lte_rrc_c1_68 = -1;                 /* T_c1_68 */
static int hf_lte_rrc_ueCapabilityEnquiry_r13_01 = -1;  /* UECapabilityEnquiry_NB_r13_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_75 = -1;  /* T_criticalExtensionsFuture_75 */
static int hf_lte_rrc_nonCriticalExtension_329 = -1;  /* T_nonCriticalExtension_101 */
static int hf_lte_rrc_criticalExtensions_78 = -1;  /* T_criticalExtensions_78 */
static int hf_lte_rrc_ueCapabilityInformation_r13_01 = -1;  /* UECapabilityInformation_NB_r13_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_76 = -1;  /* T_criticalExtensionsFuture_76 */
static int hf_lte_rrc_ue_Capability_r13 = -1;     /* UE_Capability_NB_r13 */
static int hf_lte_rrc_ue_RadioPagingInfo_r13_01 = -1;  /* UE_RadioPagingInfo_NB_r13 */
static int hf_lte_rrc_nonCriticalExtension_330 = -1;  /* UECapabilityInformation_NB_Ext_r14_IEs */
static int hf_lte_rrc_ue_Capability_ContainerExt_r14 = -1;  /* T_ue_Capability_ContainerExt_r14 */
static int hf_lte_rrc_nonCriticalExtension_331 = -1;  /* T_nonCriticalExtension_102 */
static int hf_lte_rrc_criticalExtensions_79 = -1;  /* T_criticalExtensions_79 */
static int hf_lte_rrc_ulInformationTransfer_r13_01 = -1;  /* ULInformationTransfer_NB_r13_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_77 = -1;  /* T_criticalExtensionsFuture_77 */
static int hf_lte_rrc_nonCriticalExtension_332 = -1;  /* T_nonCriticalExtension_103 */
static int hf_lte_rrc_radioResourceConfigCommon_r13 = -1;  /* RadioResourceConfigCommonSIB_NB_r13 */
static int hf_lte_rrc_ue_TimersAndConstants_r13 = -1;  /* UE_TimersAndConstants_NB_r13 */
static int hf_lte_rrc_freqInfo_r13_01 = -1;       /* T_freqInfo_r13_01 */
static int hf_lte_rrc_ul_CarrierFreq_r13_01 = -1;  /* CarrierFreq_NB_r13 */
static int hf_lte_rrc_timeAlignmentTimerCommon_r13 = -1;  /* TimeAlignmentTimer */
static int hf_lte_rrc_multiBandInfoList_r13_02 = -1;  /* AdditionalSpectrumEmission_r13 */
static int hf_lte_rrc_multiBandInfoList_r13_item = -1;  /* AdditionalSpectrumEmission */
static int hf_lte_rrc_cp_Reestablishment_r14 = -1;  /* T_cp_Reestablishment_r14 */
static int hf_lte_rrc_servingCellMeasInfo_r14 = -1;  /* T_servingCellMeasInfo_r14 */
static int hf_lte_rrc_cqi_Reporting_r14 = -1;     /* T_cqi_Reporting_r14 */
static int hf_lte_rrc_enhancedPHR_r15 = -1;       /* T_enhancedPHR_r15 */
static int hf_lte_rrc_freqInfo_v1530 = -1;        /* T_freqInfo_v1530 */
static int hf_lte_rrc_tdd_UL_DL_AlignmentOffset_r15 = -1;  /* TDD_UL_DL_AlignmentOffset_NB_r15 */
static int hf_lte_rrc_cp_EDT_r15_01 = -1;         /* T_cp_EDT_r15_01 */
static int hf_lte_rrc_up_EDT_r15_01 = -1;         /* T_up_EDT_r15_01 */
static int hf_lte_rrc_cellReselectionInfoCommon_r13 = -1;  /* T_cellReselectionInfoCommon_r13 */
static int hf_lte_rrc_q_Hyst_r13_02 = -1;         /* T_q_Hyst_r13_02 */
static int hf_lte_rrc_cellReselectionServingFreqInfo_r13 = -1;  /* T_cellReselectionServingFreqInfo_r13 */
static int hf_lte_rrc_s_NonIntraSearch_r13 = -1;  /* ReselectionThreshold */
static int hf_lte_rrc_intraFreqCellReselectionInfo_r13 = -1;  /* T_intraFreqCellReselectionInfo_r13 */
static int hf_lte_rrc_s_IntraSearchP_r13 = -1;    /* ReselectionThreshold */
static int hf_lte_rrc_t_Reselection_r13 = -1;     /* T_Reselection_NB_r13 */
static int hf_lte_rrc_multiBandInfoList_r13_03 = -1;  /* SEQUENCE_SIZE_1_maxMultiBands_OF_NS_PmaxList_NB_r13 */
static int hf_lte_rrc_multiBandInfoList_r13_item_01 = -1;  /* NS_PmaxList_NB_r13 */
static int hf_lte_rrc_intraFreqCellReselectionInfo_v1350 = -1;  /* IntraFreqCellReselectionInfo_NB_v1350 */
static int hf_lte_rrc_intraFreqCellReselectionInfo_v1360 = -1;  /* IntraFreqCellReselectionInfo_NB_v1360 */
static int hf_lte_rrc_intraFreqCellReselectionInfo_v1430 = -1;  /* IntraFreqCellReselectionInfo_NB_v1430 */
static int hf_lte_rrc_cellReselectionInfoCommon_v1450 = -1;  /* CellReselectionInfoCommon_NB_v1450 */
static int hf_lte_rrc_nsss_RRM_Config_r15 = -1;   /* NSSS_RRM_Config_NB_r15 */
static int hf_lte_rrc_npbch_RRM_Config_r15 = -1;  /* T_npbch_RRM_Config_r15 */
static int hf_lte_rrc_s_IntraSearchP_v1360 = -1;  /* ReselectionThreshold_NB_v1360 */
static int hf_lte_rrc_powerClass14dBm_Offset_r14_01 = -1;  /* T_powerClass14dBm_Offset_r14_01 */
static int hf_lte_rrc_ce_AuthorisationOffset_r14 = -1;  /* T_ce_AuthorisationOffset_r14 */
static int hf_lte_rrc_s_SearchDeltaP_r14_01 = -1;  /* T_s_SearchDeltaP_r14_01 */
static int hf_lte_rrc_intraFreqNeighCellList_r13 = -1;  /* IntraFreqNeighCellList */
static int hf_lte_rrc_intraFreqBlackCellList_r13 = -1;  /* IntraFreqBlackCellList */
static int hf_lte_rrc_intraFreqNeighCellList_v1530 = -1;  /* IntraFreqNeighCellList_NB_v1530 */
static int hf_lte_rrc_IntraFreqNeighCellList_NB_v1530_item = -1;  /* IntraFreqNeighCellInfo_NB_v1530 */
static int hf_lte_rrc_interFreqCarrierFreqList_r13 = -1;  /* InterFreqCarrierFreqList_NB_r13 */
static int hf_lte_rrc_InterFreqCarrierFreqList_NB_r13_item = -1;  /* InterFreqCarrierFreqInfo_NB_r13 */
static int hf_lte_rrc_dl_CarrierFreq_r13_01 = -1;  /* CarrierFreq_NB_r13 */
static int hf_lte_rrc_q_OffsetFreq_r13 = -1;      /* Q_OffsetRange */
static int hf_lte_rrc_interFreqNeighCellList_r13 = -1;  /* InterFreqNeighCellList_NB_r13 */
static int hf_lte_rrc_interFreqBlackCellList_r13 = -1;  /* InterFreqBlackCellList_NB_r13 */
static int hf_lte_rrc_powerClass14dBm_Offset_r14_02 = -1;  /* T_powerClass14dBm_Offset_r14_02 */
static int hf_lte_rrc_ce_AuthorisationOffset_r14_01 = -1;  /* T_ce_AuthorisationOffset_r14_01 */
static int hf_lte_rrc_interFreqNeighCellList_v1530 = -1;  /* InterFreqNeighCellList_NB_v1530 */
static int hf_lte_rrc_dl_CarrierFreq_v1550 = -1;  /* CarrierFreq_NB_v1550 */
static int hf_lte_rrc_InterFreqNeighCellList_NB_r13_item = -1;  /* PhysCellId */
static int hf_lte_rrc_InterFreqNeighCellList_NB_v1530_item = -1;  /* InterFreqNeighCellInfo_NB_v1530 */
static int hf_lte_rrc_InterFreqBlackCellList_NB_r13_item = -1;  /* PhysCellId */
static int hf_lte_rrc_ab_Param_r13 = -1;          /* T_ab_Param_r13 */
static int hf_lte_rrc_ab_Common_r13 = -1;         /* AB_Config_NB_r13 */
static int hf_lte_rrc_ab_PerPLMN_List_r13 = -1;   /* SEQUENCE_SIZE_1_maxPLMN_r11_OF_AB_ConfigPLMN_NB_r13 */
static int hf_lte_rrc_ab_PerPLMN_List_r13_item = -1;  /* AB_ConfigPLMN_NB_r13 */
static int hf_lte_rrc_ab_PerNRSRP_r15 = -1;       /* T_ab_PerNRSRP_r15 */
static int hf_lte_rrc_ab_Config_r13 = -1;         /* AB_Config_NB_r13 */
static int hf_lte_rrc_ab_Category_r13 = -1;       /* T_ab_Category_r13 */
static int hf_lte_rrc_ab_BarringBitmap_r13 = -1;  /* BIT_STRING_SIZE_10 */
static int hf_lte_rrc_ab_BarringForExceptionData_r13 = -1;  /* T_ab_BarringForExceptionData_r13 */
static int hf_lte_rrc_ab_BarringForSpecialAC_r13 = -1;  /* BIT_STRING_SIZE_5 */
static int hf_lte_rrc_mbms_SAI_IntraFreq_r14 = -1;  /* MBMS_SAI_List_r11 */
static int hf_lte_rrc_mbms_SAI_InterFreqList_r14 = -1;  /* MBMS_SAI_InterFreqList_NB_r14 */
static int hf_lte_rrc_MBMS_SAI_InterFreqList_NB_r14_item = -1;  /* MBMS_SAI_InterFreq_NB_r14 */
static int hf_lte_rrc_dl_CarrierFreq_r14 = -1;    /* CarrierFreq_NB_r13 */
static int hf_lte_rrc_mbms_SAI_List_r14 = -1;     /* MBMS_SAI_List_r11 */
static int hf_lte_rrc_multiBandInfoList_r14_01 = -1;  /* AdditionalBandInfoList_NB_r14 */
static int hf_lte_rrc_npdcch_SC_MCCH_Config_r14 = -1;  /* NPDCCH_SC_MCCH_Config_NB_r14 */
static int hf_lte_rrc_sc_mcch_CarrierConfig_r14 = -1;  /* T_sc_mcch_CarrierConfig_r14 */
static int hf_lte_rrc_dl_CarrierConfig_r14 = -1;  /* DL_CarrierConfigCommon_NB_r14 */
static int hf_lte_rrc_dl_CarrierIndex_r14 = -1;   /* INTEGER_0_maxNonAnchorCarriers_NB_r14 */
static int hf_lte_rrc_sc_mcch_RepetitionPeriod_r14 = -1;  /* T_sc_mcch_RepetitionPeriod_r14 */
static int hf_lte_rrc_sc_mcch_Offset_r14 = -1;    /* INTEGER_0_10 */
static int hf_lte_rrc_sc_mcch_ModificationPeriod_r14 = -1;  /* T_sc_mcch_ModificationPeriod_r14 */
static int hf_lte_rrc_sc_mcch_SchedulingInfo_r14_01 = -1;  /* SC_MCCH_SchedulingInfo_NB_r14 */
static int hf_lte_rrc_npdcch_NumRepetitions_SC_MCCH_r14 = -1;  /* T_npdcch_NumRepetitions_SC_MCCH_r14 */
static int hf_lte_rrc_npdcch_StartSF_SC_MCCH_r14 = -1;  /* T_npdcch_StartSF_SC_MCCH_r14 */
static int hf_lte_rrc_npdcch_Offset_SC_MCCH_r14 = -1;  /* T_npdcch_Offset_SC_MCCH_r14 */
static int hf_lte_rrc_onDurationTimerSCPTM_r14_02 = -1;  /* T_onDurationTimerSCPTM_r14_02 */
static int hf_lte_rrc_drx_InactivityTimerSCPTM_r14_02 = -1;  /* T_drx_InactivityTimerSCPTM_r14_02 */
static int hf_lte_rrc_schedulingPeriodStartOffsetSCPTM_r14_02 = -1;  /* T_schedulingPeriodStartOffsetSCPTM_r14_02 */
static int hf_lte_rrc_dl_ConfigList_r14 = -1;     /* DL_ConfigCommonList_NB_r14 */
static int hf_lte_rrc_ul_ConfigList_r14 = -1;     /* UL_ConfigCommonList_NB_r14 */
static int hf_lte_rrc_pagingWeightAnchor_r14 = -1;  /* PagingWeight_NB_r14 */
static int hf_lte_rrc_nprach_ProbabilityAnchorList_r14 = -1;  /* NPRACH_ProbabilityAnchorList_NB_r14 */
static int hf_lte_rrc_mixedOperationModeConfig_r15 = -1;  /* T_mixedOperationModeConfig_r15 */
static int hf_lte_rrc_dl_ConfigListMixed_r15 = -1;  /* DL_ConfigCommonList_NB_r14 */
static int hf_lte_rrc_ul_ConfigListMixed_r15 = -1;  /* UL_ConfigCommonList_NB_r14 */
static int hf_lte_rrc_pagingDistribution_r15 = -1;  /* T_pagingDistribution_r15 */
static int hf_lte_rrc_nprach_Distribution_r15 = -1;  /* T_nprach_Distribution_r15 */
static int hf_lte_rrc_ul_ConfigList_r15 = -1;     /* UL_ConfigCommonListTDD_NB_r15 */
static int hf_lte_rrc_DL_ConfigCommonList_NB_r14_item = -1;  /* DL_ConfigCommon_NB_r14 */
static int hf_lte_rrc_UL_ConfigCommonList_NB_r14_item = -1;  /* UL_ConfigCommon_NB_r14 */
static int hf_lte_rrc_UL_ConfigCommonListTDD_NB_r15_item = -1;  /* UL_ConfigCommonTDD_NB_r15 */
static int hf_lte_rrc_pcch_Config_r14 = -1;       /* PCCH_Config_NB_r14 */
static int hf_lte_rrc_wus_Config_r15_01 = -1;     /* WUS_ConfigPerCarrier_NB_r15 */
static int hf_lte_rrc_npdcch_NumRepetitionPaging_r14 = -1;  /* T_npdcch_NumRepetitionPaging_r14 */
static int hf_lte_rrc_pagingWeight_r14 = -1;      /* PagingWeight_NB_r14 */
static int hf_lte_rrc_ul_CarrierFreq_r14_01 = -1;  /* CarrierFreq_NB_r13 */
static int hf_lte_rrc_nprach_ParametersList_r14 = -1;  /* NPRACH_ParametersList_NB_r14 */
static int hf_lte_rrc_nprach_ParametersListEDT_r15 = -1;  /* NPRACH_ParametersList_NB_r14 */
static int hf_lte_rrc_nprach_ParametersListTDD_r15 = -1;  /* NPRACH_ParametersListTDD_NB_r15 */
static int hf_lte_rrc_NPRACH_ProbabilityAnchorList_NB_r14_item = -1;  /* NPRACH_ProbabilityAnchor_NB_r14 */
static int hf_lte_rrc_nprach_ProbabilityAnchor_r14 = -1;  /* T_nprach_ProbabilityAnchor_r14 */
static int hf_lte_rrc_ul_ConfigList_v1530 = -1;   /* UL_ConfigCommonList_NB_v1530 */
static int hf_lte_rrc_ul_ConfigListMixed_v1530 = -1;  /* UL_ConfigCommonList_NB_v1530 */
static int hf_lte_rrc_UL_ConfigCommonList_NB_v1530_item = -1;  /* UL_ConfigCommon_NB_v1530 */
static int hf_lte_rrc_nprach_ParametersListFmt2_r15 = -1;  /* NPRACH_ParametersListFmt2_NB_r15 */
static int hf_lte_rrc_nprach_ParametersListFmt2EDT_r15 = -1;  /* NPRACH_ParametersListFmt2_NB_r15 */
static int hf_lte_rrc_dl_CarrierConfig_r13 = -1;  /* DL_CarrierConfigDedicated_NB_r13 */
static int hf_lte_rrc_ul_CarrierConfig_r13 = -1;  /* UL_CarrierConfigDedicated_NB_r13 */
static int hf_lte_rrc_downlinkBitmapNonAnchor_r13 = -1;  /* T_downlinkBitmapNonAnchor_r13 */
static int hf_lte_rrc_useNoBitmap_r13 = -1;       /* NULL */
static int hf_lte_rrc_useAnchorBitmap_r13 = -1;   /* NULL */
static int hf_lte_rrc_explicitBitmapConfiguration_r13 = -1;  /* DL_Bitmap_NB_r13 */
static int hf_lte_rrc_dl_GapNonAnchor_r13 = -1;   /* T_dl_GapNonAnchor_r13 */
static int hf_lte_rrc_useNoGap_r13 = -1;          /* NULL */
static int hf_lte_rrc_useAnchorGapConfig_r13 = -1;  /* NULL */
static int hf_lte_rrc_explicitGapConfiguration_r13 = -1;  /* DL_GapConfig_NB_r13 */
static int hf_lte_rrc_inbandCarrierInfo_r13 = -1;  /* T_inbandCarrierInfo_r13 */
static int hf_lte_rrc_samePCI_Indicator_r13 = -1;  /* T_samePCI_Indicator_r13 */
static int hf_lte_rrc_samePCI_r13 = -1;           /* T_samePCI_r13 */
static int hf_lte_rrc_indexToMidPRB_r13 = -1;     /* INTEGER_M55_54 */
static int hf_lte_rrc_differentPCI_r13 = -1;      /* T_differentPCI_r13 */
static int hf_lte_rrc_eutra_NumCRS_Ports_r13_01 = -1;  /* T_eutra_NumCRS_Ports_r13_01 */
static int hf_lte_rrc_eutraControlRegionSize_r13_01 = -1;  /* T_eutraControlRegionSize_r13_01 */
static int hf_lte_rrc_nrs_PowerOffsetNonAnchor_v1330 = -1;  /* T_nrs_PowerOffsetNonAnchor_v1330 */
static int hf_lte_rrc_dl_GapNonAnchor_v1530 = -1;  /* DL_GapConfig_NB_v1530 */
static int hf_lte_rrc_carrierFreqOffset_r13 = -1;  /* T_carrierFreqOffset_r13 */
static int hf_lte_rrc_carrierFreqOffset_v1550 = -1;  /* T_carrierFreqOffset_v1550 */
static int hf_lte_rrc_downlinkBitmapNonAnchor_r14 = -1;  /* T_downlinkBitmapNonAnchor_r14 */
static int hf_lte_rrc_useNoBitmap_r14 = -1;       /* NULL */
static int hf_lte_rrc_useAnchorBitmap_r14 = -1;   /* NULL */
static int hf_lte_rrc_explicitBitmapConfiguration_r14 = -1;  /* DL_Bitmap_NB_r13 */
static int hf_lte_rrc_dl_GapNonAnchor_r14 = -1;   /* T_dl_GapNonAnchor_r14 */
static int hf_lte_rrc_useNoGap_r14 = -1;          /* NULL */
static int hf_lte_rrc_useAnchorGapConfig_r14 = -1;  /* NULL */
static int hf_lte_rrc_explicitGapConfiguration_r14 = -1;  /* DL_GapConfig_NB_r13 */
static int hf_lte_rrc_inbandCarrierInfo_r14 = -1;  /* T_inbandCarrierInfo_r14 */
static int hf_lte_rrc_samePCI_Indicator_r14 = -1;  /* T_samePCI_Indicator_r14 */
static int hf_lte_rrc_samePCI_r14 = -1;           /* T_samePCI_r14 */
static int hf_lte_rrc_indexToMidPRB_r14 = -1;     /* INTEGER_M55_54 */
static int hf_lte_rrc_differentPCI_r14 = -1;      /* T_differentPCI_r14 */
static int hf_lte_rrc_eutra_NumCRS_Ports_r14 = -1;  /* T_eutra_NumCRS_Ports_r14 */
static int hf_lte_rrc_eutraControlRegionSize_r14 = -1;  /* T_eutraControlRegionSize_r14 */
static int hf_lte_rrc_nrs_PowerOffsetNonAnchor_r14 = -1;  /* T_nrs_PowerOffsetNonAnchor_r14 */
static int hf_lte_rrc_dl_GapThreshold_r13 = -1;   /* T_dl_GapThreshold_r13 */
static int hf_lte_rrc_dl_GapPeriodicity_r13 = -1;  /* T_dl_GapPeriodicity_r13 */
static int hf_lte_rrc_dl_GapDurationCoeff_r13 = -1;  /* T_dl_GapDurationCoeff_r13 */
static int hf_lte_rrc_dl_GapPeriodicity_v1530 = -1;  /* T_dl_GapPeriodicity_v1530 */
static int hf_lte_rrc_priority_r13 = -1;          /* T_priority_r13 */
static int hf_lte_rrc_logicalChannelSR_Prohibit_r13 = -1;  /* BOOLEAN */
static int hf_lte_rrc_ul_SCH_Config_r13 = -1;     /* T_ul_SCH_Config_r13 */
static int hf_lte_rrc_periodicBSR_Timer_r13 = -1;  /* PeriodicBSR_Timer_NB_r13 */
static int hf_lte_rrc_retxBSR_Timer_r13 = -1;     /* RetxBSR_Timer_NB_r13 */
static int hf_lte_rrc_drx_Config_r13_01 = -1;     /* DRX_Config_NB_r13 */
static int hf_lte_rrc_timeAlignmentTimerDedicated_r13 = -1;  /* TimeAlignmentTimer */
static int hf_lte_rrc_logicalChannelSR_Config_r13 = -1;  /* T_logicalChannelSR_Config_r13 */
static int hf_lte_rrc_setup_201 = -1;             /* T_setup_175 */
static int hf_lte_rrc_logicalChannelSR_ProhibitTimer_r13 = -1;  /* T_logicalChannelSR_ProhibitTimer_r13 */
static int hf_lte_rrc_rai_Activation_r14_01 = -1;  /* T_rai_Activation_r14_01 */
static int hf_lte_rrc_dataInactivityTimerConfig_r14_01 = -1;  /* T_dataInactivityTimerConfig_r14_01 */
static int hf_lte_rrc_setup_202 = -1;             /* T_setup_176 */
static int hf_lte_rrc_drx_Cycle_v1430 = -1;       /* T_drx_Cycle_v1430 */
static int hf_lte_rrc_ra_CFRA_Config_r14 = -1;    /* T_ra_CFRA_Config_r14 */
static int hf_lte_rrc_setup_203 = -1;             /* T_setup_177 */
static int hf_lte_rrc_onDurationTimer_r13 = -1;   /* T_onDurationTimer_r13 */
static int hf_lte_rrc_drx_InactivityTimer_r13 = -1;  /* T_drx_InactivityTimer_r13 */
static int hf_lte_rrc_drx_RetransmissionTimer_r13 = -1;  /* T_drx_RetransmissionTimer_r13 */
static int hf_lte_rrc_drx_Cycle_r13 = -1;         /* T_drx_Cycle_r13 */
static int hf_lte_rrc_drx_StartOffset_r13 = -1;   /* INTEGER_0_255 */
static int hf_lte_rrc_drx_ULRetransmissionTimer_r13_01 = -1;  /* T_drx_ULRetransmissionTimer_r13_01 */
static int hf_lte_rrc_npdcch_NumRepetitions_r13 = -1;  /* T_npdcch_NumRepetitions_r13 */
static int hf_lte_rrc_npdcch_StartSF_USS_r13 = -1;  /* T_npdcch_StartSF_USS_r13 */
static int hf_lte_rrc_npdcch_Offset_USS_r13 = -1;  /* T_npdcch_Offset_USS_r13 */
static int hf_lte_rrc_npdcch_StartSF_USS_v1530 = -1;  /* T_npdcch_StartSF_USS_v1530 */
static int hf_lte_rrc_nrs_Power_r13 = -1;         /* INTEGER_M60_50 */
static int hf_lte_rrc_nprach_CP_Length_r13 = -1;  /* T_nprach_CP_Length_r13 */
static int hf_lte_rrc_rsrp_ThresholdsPrachInfoList_r13_01 = -1;  /* RSRP_ThresholdsNPRACH_InfoList_NB_r13 */
static int hf_lte_rrc_nprach_ParametersList_r13 = -1;  /* NPRACH_ParametersList_NB_r13 */
static int hf_lte_rrc_nprach_ParametersList_v1330 = -1;  /* NPRACH_ParametersList_NB_v1330 */
static int hf_lte_rrc_maxNumPreambleAttemptCE_r14 = -1;  /* T_maxNumPreambleAttemptCE_r14 */
static int hf_lte_rrc_tdd_Parameters_r15_01 = -1;  /* T_tdd_Parameters_r15_01 */
static int hf_lte_rrc_nprach_PreambleFormat_r15 = -1;  /* T_nprach_PreambleFormat_r15 */
static int hf_lte_rrc_dummy_08 = -1;              /* T_dummy_05 */
static int hf_lte_rrc_fmt2_Parameters_r15 = -1;   /* T_fmt2_Parameters_r15 */
static int hf_lte_rrc_edt_Parameters_r15_01 = -1;  /* T_edt_Parameters_r15_01 */
static int hf_lte_rrc_edt_SmallTBS_Subset_r15_01 = -1;  /* T_edt_SmallTBS_Subset_r15_01 */
static int hf_lte_rrc_edt_TBS_InfoList_r15 = -1;  /* EDT_TBS_InfoList_NB_r15 */
static int hf_lte_rrc_tdd_Parameters_v1550 = -1;  /* T_tdd_Parameters_v1550 */
static int hf_lte_rrc_nprach_ParametersListTDD_v1550 = -1;  /* NPRACH_ParametersListTDD_NB_v1550 */
static int hf_lte_rrc_NPRACH_ParametersList_NB_r13_item = -1;  /* NPRACH_Parameters_NB_r13 */
static int hf_lte_rrc_NPRACH_ParametersList_NB_v1330_item = -1;  /* NPRACH_Parameters_NB_v1330 */
static int hf_lte_rrc_nprach_Periodicity_r13 = -1;  /* T_nprach_Periodicity_r13 */
static int hf_lte_rrc_nprach_StartTime_r13 = -1;  /* T_nprach_StartTime_r13 */
static int hf_lte_rrc_nprach_SubcarrierOffset_r13 = -1;  /* T_nprach_SubcarrierOffset_r13 */
static int hf_lte_rrc_nprach_NumSubcarriers_r13 = -1;  /* T_nprach_NumSubcarriers_r13 */
static int hf_lte_rrc_nprach_SubcarrierMSG3_RangeStart_r13 = -1;  /* T_nprach_SubcarrierMSG3_RangeStart_r13 */
static int hf_lte_rrc_maxNumPreambleAttemptCE_r13_01 = -1;  /* T_maxNumPreambleAttemptCE_r13_01 */
static int hf_lte_rrc_numRepetitionsPerPreambleAttempt_r13 = -1;  /* T_numRepetitionsPerPreambleAttempt_r13 */
static int hf_lte_rrc_npdcch_NumRepetitions_RA_r13 = -1;  /* T_npdcch_NumRepetitions_RA_r13 */
static int hf_lte_rrc_npdcch_StartSF_CSS_RA_r13 = -1;  /* T_npdcch_StartSF_CSS_RA_r13 */
static int hf_lte_rrc_npdcch_Offset_RA_r13 = -1;  /* T_npdcch_Offset_RA_r13 */
static int hf_lte_rrc_nprach_NumCBRA_StartSubcarriers_r13 = -1;  /* T_nprach_NumCBRA_StartSubcarriers_r13 */
static int hf_lte_rrc_NPRACH_ParametersList_NB_r14_item = -1;  /* NPRACH_Parameters_NB_r14 */
static int hf_lte_rrc_nprach_Parameters_r14 = -1;  /* T_nprach_Parameters_r14 */
static int hf_lte_rrc_nprach_Periodicity_r14 = -1;  /* T_nprach_Periodicity_r14 */
static int hf_lte_rrc_nprach_StartTime_r14 = -1;  /* T_nprach_StartTime_r14 */
static int hf_lte_rrc_nprach_SubcarrierOffset_r14 = -1;  /* T_nprach_SubcarrierOffset_r14 */
static int hf_lte_rrc_nprach_NumSubcarriers_r14 = -1;  /* T_nprach_NumSubcarriers_r14 */
static int hf_lte_rrc_nprach_SubcarrierMSG3_RangeStart_r14 = -1;  /* T_nprach_SubcarrierMSG3_RangeStart_r14 */
static int hf_lte_rrc_npdcch_NumRepetitions_RA_r14 = -1;  /* T_npdcch_NumRepetitions_RA_r14 */
static int hf_lte_rrc_npdcch_StartSF_CSS_RA_r14 = -1;  /* T_npdcch_StartSF_CSS_RA_r14 */
static int hf_lte_rrc_npdcch_Offset_RA_r14 = -1;  /* T_npdcch_Offset_RA_r14 */
static int hf_lte_rrc_nprach_NumCBRA_StartSubcarriers_r14 = -1;  /* T_nprach_NumCBRA_StartSubcarriers_r14 */
static int hf_lte_rrc_npdcch_CarrierIndex_r14 = -1;  /* INTEGER_1_maxNonAnchorCarriers_NB_r14 */
static int hf_lte_rrc_NPRACH_ParametersListTDD_NB_r15_item = -1;  /* NPRACH_ParametersTDD_NB_r15 */
static int hf_lte_rrc_nprach_Parameters_r15 = -1;  /* T_nprach_Parameters_r15 */
static int hf_lte_rrc_nprach_Periodicity_r15 = -1;  /* T_nprach_Periodicity_r15 */
static int hf_lte_rrc_nprach_StartTime_r15 = -1;  /* T_nprach_StartTime_r15 */
static int hf_lte_rrc_nprach_SubcarrierOffset_r15 = -1;  /* T_nprach_SubcarrierOffset_r15 */
static int hf_lte_rrc_nprach_NumSubcarriers_r15 = -1;  /* T_nprach_NumSubcarriers_r15 */
static int hf_lte_rrc_nprach_SubcarrierMSG3_RangeStart_r15 = -1;  /* T_nprach_SubcarrierMSG3_RangeStart_r15 */
static int hf_lte_rrc_npdcch_NumRepetitions_RA_r15 = -1;  /* T_npdcch_NumRepetitions_RA_r15 */
static int hf_lte_rrc_npdcch_StartSF_CSS_RA_r15 = -1;  /* T_npdcch_StartSF_CSS_RA_r15 */
static int hf_lte_rrc_npdcch_Offset_RA_r15 = -1;  /* T_npdcch_Offset_RA_r15 */
static int hf_lte_rrc_nprach_NumCBRA_StartSubcarriers_r15 = -1;  /* T_nprach_NumCBRA_StartSubcarriers_r15 */
static int hf_lte_rrc_NPRACH_ParametersListTDD_NB_v1550_item = -1;  /* NPRACH_ParametersTDD_NB_v1550 */
static int hf_lte_rrc_maxNumPreambleAttemptCE_v1550 = -1;  /* T_maxNumPreambleAttemptCE_v1550 */
static int hf_lte_rrc_numRepetitionsPerPreambleAttempt_v1550 = -1;  /* T_numRepetitionsPerPreambleAttempt_v1550 */
static int hf_lte_rrc_NPRACH_ParametersListFmt2_NB_r15_item = -1;  /* NPRACH_ParametersFmt2_NB_r15 */
static int hf_lte_rrc_nprach_Parameters_r15_01 = -1;  /* T_nprach_Parameters_r15_01 */
static int hf_lte_rrc_nprach_Periodicity_r15_01 = -1;  /* T_nprach_Periodicity_r15_01 */
static int hf_lte_rrc_nprach_StartTime_r15_01 = -1;  /* T_nprach_StartTime_r15_01 */
static int hf_lte_rrc_nprach_SubcarrierOffset_r15_01 = -1;  /* T_nprach_SubcarrierOffset_r15_01 */
static int hf_lte_rrc_nprach_NumSubcarriers_r15_01 = -1;  /* T_nprach_NumSubcarriers_r15_01 */
static int hf_lte_rrc_nprach_SubcarrierMSG3_RangeStart_r15_01 = -1;  /* T_nprach_SubcarrierMSG3_RangeStart_r15_01 */
static int hf_lte_rrc_npdcch_NumRepetitions_RA_r15_01 = -1;  /* T_npdcch_NumRepetitions_RA_r15_01 */
static int hf_lte_rrc_npdcch_StartSF_CSS_RA_r15_01 = -1;  /* T_npdcch_StartSF_CSS_RA_r15_01 */
static int hf_lte_rrc_npdcch_Offset_RA_r15_01 = -1;  /* T_npdcch_Offset_RA_r15_01 */
static int hf_lte_rrc_nprach_NumCBRA_StartSubcarriers_r15_01 = -1;  /* T_nprach_NumCBRA_StartSubcarriers_r15_01 */
static int hf_lte_rrc_npdcch_CarrierIndex_r15 = -1;  /* INTEGER_1_maxNonAnchorCarriers_NB_r14 */
static int hf_lte_rrc_RSRP_ThresholdsNPRACH_InfoList_NB_r13_item = -1;  /* RSRP_Range */
static int hf_lte_rrc_EDT_TBS_InfoList_NB_r15_item = -1;  /* EDT_TBS_NB_r15 */
static int hf_lte_rrc_edt_TBS_r15_01 = -1;        /* T_edt_TBS_r15_01 */
static int hf_lte_rrc_ack_NACK_NumRepetitions_Msg4_r13 = -1;  /* SEQUENCE_SIZE_1_maxNPRACH_Resources_NB_r13_OF_ACK_NACK_NumRepetitions_NB_r13 */
static int hf_lte_rrc_ack_NACK_NumRepetitions_Msg4_r13_item = -1;  /* ACK_NACK_NumRepetitions_NB_r13 */
static int hf_lte_rrc_srs_SubframeConfig_r13 = -1;  /* T_srs_SubframeConfig_r13 */
static int hf_lte_rrc_dmrs_Config_r13 = -1;       /* T_dmrs_Config_r13 */
static int hf_lte_rrc_threeTone_BaseSequence_r13 = -1;  /* INTEGER_0_12 */
static int hf_lte_rrc_threeTone_CyclicShift_r13 = -1;  /* INTEGER_0_2 */
static int hf_lte_rrc_sixTone_BaseSequence_r13 = -1;  /* INTEGER_0_14 */
static int hf_lte_rrc_sixTone_CyclicShift_r13 = -1;  /* INTEGER_0_3 */
static int hf_lte_rrc_twelveTone_BaseSequence_r13 = -1;  /* INTEGER_0_30 */
static int hf_lte_rrc_ul_ReferenceSignalsNPUSCH_r13 = -1;  /* UL_ReferenceSignalsNPUSCH_NB_r13 */
static int hf_lte_rrc_groupHoppingEnabled_r13 = -1;  /* BOOLEAN */
static int hf_lte_rrc_groupAssignmentNPUSCH_r13 = -1;  /* INTEGER_0_29 */
static int hf_lte_rrc_ack_NACK_NumRepetitions_r13 = -1;  /* ACK_NACK_NumRepetitions_NB_r13 */
static int hf_lte_rrc_npusch_AllSymbols_r13 = -1;  /* BOOLEAN */
static int hf_lte_rrc_groupHoppingDisabled_r13_01 = -1;  /* T_groupHoppingDisabled_r13_01 */
static int hf_lte_rrc_discardTimer_r13 = -1;      /* T_discardTimer_r13 */
static int hf_lte_rrc_headerCompression_r13 = -1;  /* T_headerCompression_r13 */
static int hf_lte_rrc_rohc_01 = -1;               /* T_rohc_01 */
static int hf_lte_rrc_maxCID_r13 = -1;            /* INTEGER_1_16383 */
static int hf_lte_rrc_profiles_r13 = -1;          /* T_profiles_r13 */
static int hf_lte_rrc_carrierConfigDedicated_r13 = -1;  /* CarrierConfigDedicated_NB_r13 */
static int hf_lte_rrc_npdcch_ConfigDedicated_r13 = -1;  /* NPDCCH_ConfigDedicated_NB_r13 */
static int hf_lte_rrc_npusch_ConfigDedicated_r13 = -1;  /* NPUSCH_ConfigDedicated_NB_r13 */
static int hf_lte_rrc_uplinkPowerControlDedicated_r13_01 = -1;  /* UplinkPowerControlDedicated_NB_r13 */
static int hf_lte_rrc_twoHARQ_ProcessesConfig_r14 = -1;  /* T_twoHARQ_ProcessesConfig_r14 */
static int hf_lte_rrc_interferenceRandomisationConfig_r14 = -1;  /* T_interferenceRandomisationConfig_r14 */
static int hf_lte_rrc_npdcch_ConfigDedicated_v1530 = -1;  /* NPDCCH_ConfigDedicated_NB_v1530 */
static int hf_lte_rrc_additionalTxSIB1_Config_v1540 = -1;  /* T_additionalTxSIB1_Config_v1540 */
static int hf_lte_rrc_powerRampingParameters_r13 = -1;  /* PowerRampingParameters */
static int hf_lte_rrc_rach_InfoList_r13 = -1;     /* RACH_InfoList_NB_r13 */
static int hf_lte_rrc_connEstFailOffset_r13 = -1;  /* INTEGER_0_15 */
static int hf_lte_rrc_powerRampingParameters_v1450 = -1;  /* PowerRampingParameters_NB_v1450 */
static int hf_lte_rrc_rach_InfoList_v1530 = -1;   /* RACH_InfoList_NB_v1530 */
static int hf_lte_rrc_RACH_InfoList_NB_r13_item = -1;  /* RACH_Info_NB_r13 */
static int hf_lte_rrc_RACH_InfoList_NB_v1530_item = -1;  /* RACH_Info_NB_v1530 */
static int hf_lte_rrc_ra_ResponseWindowSize_r13_01 = -1;  /* T_ra_ResponseWindowSize_r13_01 */
static int hf_lte_rrc_mac_ContentionResolutionTimer_r13_01 = -1;  /* T_mac_ContentionResolutionTimer_r13_01 */
static int hf_lte_rrc_mac_ContentionResolutionTimer_r15_01 = -1;  /* T_mac_ContentionResolutionTimer_r15_01 */
static int hf_lte_rrc_preambleInitialReceivedTargetPower_v1450 = -1;  /* T_preambleInitialReceivedTargetPower_v1450 */
static int hf_lte_rrc_powerRampingParametersCE1_r14 = -1;  /* T_powerRampingParametersCE1_r14 */
static int hf_lte_rrc_powerRampingStepCE1_r14 = -1;  /* T_powerRampingStepCE1_r14 */
static int hf_lte_rrc_preambleInitialReceivedTargetPowerCE1_r14 = -1;  /* T_preambleInitialReceivedTargetPowerCE1_r14 */
static int hf_lte_rrc_rach_ConfigCommon_r13 = -1;  /* RACH_ConfigCommon_NB_r13 */
static int hf_lte_rrc_bcch_Config_r13 = -1;       /* BCCH_Config_NB_r13 */
static int hf_lte_rrc_pcch_Config_r13 = -1;       /* PCCH_Config_NB_r13 */
static int hf_lte_rrc_nprach_Config_r13 = -1;     /* NPRACH_ConfigSIB_NB_r13 */
static int hf_lte_rrc_npdsch_ConfigCommon_r13 = -1;  /* NPDSCH_ConfigCommon_NB_r13 */
static int hf_lte_rrc_npusch_ConfigCommon_r13 = -1;  /* NPUSCH_ConfigCommon_NB_r13 */
static int hf_lte_rrc_dl_Gap_r13 = -1;            /* DL_GapConfig_NB_r13 */
static int hf_lte_rrc_uplinkPowerControlCommon_r13 = -1;  /* UplinkPowerControlCommon_NB_r13 */
static int hf_lte_rrc_nprach_Config_v1330 = -1;   /* NPRACH_ConfigSIB_NB_v1330 */
static int hf_lte_rrc_nprach_Config_v1450 = -1;   /* NPRACH_ConfigSIB_NB_v1450 */
static int hf_lte_rrc_nprach_Config_v1530 = -1;   /* NPRACH_ConfigSIB_NB_v1530 */
static int hf_lte_rrc_dl_Gap_v1530 = -1;          /* DL_GapConfig_NB_v1530 */
static int hf_lte_rrc_wus_Config_r15_02 = -1;     /* WUS_Config_NB_r15 */
static int hf_lte_rrc_nprach_Config_v1550 = -1;   /* NPRACH_ConfigSIB_NB_v1550 */
static int hf_lte_rrc_modificationPeriodCoeff_r13 = -1;  /* T_modificationPeriodCoeff_r13 */
static int hf_lte_rrc_defaultPagingCycle_r13 = -1;  /* T_defaultPagingCycle_r13 */
static int hf_lte_rrc_nB_r13 = -1;                /* T_nB_r13 */
static int hf_lte_rrc_npdcch_NumRepetitionPaging_r13_01 = -1;  /* T_npdcch_NumRepetitionPaging_r13 */
static int hf_lte_rrc_srb_ToAddModList_r13 = -1;  /* SRB_ToAddModList_NB_r13 */
static int hf_lte_rrc_drb_ToAddModList_r13 = -1;  /* DRB_ToAddModList_NB_r13 */
static int hf_lte_rrc_drb_ToReleaseList_r13 = -1;  /* DRB_ToReleaseList_NB_r13 */
static int hf_lte_rrc_mac_MainConfig_r13 = -1;    /* T_mac_MainConfig_r13 */
static int hf_lte_rrc_explicitValue_r13 = -1;     /* MAC_MainConfig_NB_r13 */
static int hf_lte_rrc_defaultValue_r13 = -1;      /* NULL */
static int hf_lte_rrc_physicalConfigDedicated_r13 = -1;  /* PhysicalConfigDedicated_NB_r13 */
static int hf_lte_rrc_rlf_TimersAndConstants_r13_01 = -1;  /* RLF_TimersAndConstants_NB_r13 */
static int hf_lte_rrc_schedulingRequestConfig_r15 = -1;  /* SchedulingRequestConfig_NB_r15 */
static int hf_lte_rrc_SRB_ToAddModList_NB_r13_item = -1;  /* SRB_ToAddMod_NB_r13 */
static int hf_lte_rrc_rlc_Config_r13 = -1;        /* T_rlc_Config_r13 */
static int hf_lte_rrc_explicitValue_07 = -1;      /* RLC_Config_NB_r13 */
static int hf_lte_rrc_logicalChannelConfig_r13 = -1;  /* T_logicalChannelConfig_r13 */
static int hf_lte_rrc_explicitValue_08 = -1;      /* LogicalChannelConfig_NB_r13 */
static int hf_lte_rrc_rlc_Config_v1430_01 = -1;   /* RLC_Config_NB_v1430 */
static int hf_lte_rrc_DRB_ToAddModList_NB_r13_item = -1;  /* DRB_ToAddMod_NB_r13 */
static int hf_lte_rrc_eps_BearerIdentity_r13 = -1;  /* INTEGER_0_15 */
static int hf_lte_rrc_drb_Identity_r13 = -1;      /* DRB_Identity */
static int hf_lte_rrc_pdcp_Config_r13 = -1;       /* PDCP_Config_NB_r13 */
static int hf_lte_rrc_rlc_Config_r13_01 = -1;     /* RLC_Config_NB_r13 */
static int hf_lte_rrc_logicalChannelIdentity_r13 = -1;  /* T_logicalChannelIdentity_r13 */
static int hf_lte_rrc_logicalChannelConfig_r13_01 = -1;  /* LogicalChannelConfig_NB_r13 */
static int hf_lte_rrc_DRB_ToReleaseList_NB_r13_item = -1;  /* DRB_Identity */
static int hf_lte_rrc_am_01 = -1;                 /* T_am_01 */
static int hf_lte_rrc_ul_AM_RLC_r13 = -1;         /* UL_AM_RLC_NB_r13 */
static int hf_lte_rrc_dl_AM_RLC_r13 = -1;         /* DL_AM_RLC_NB_r13 */
static int hf_lte_rrc_um_Bi_Directional_r15_01 = -1;  /* T_um_Bi_Directional_r15_01 */
static int hf_lte_rrc_um_Uni_Directional_UL_r15_01 = -1;  /* T_um_Uni_Directional_UL_r15_01 */
static int hf_lte_rrc_um_Uni_Directional_DL_r15_01 = -1;  /* T_um_Uni_Directional_DL_r15_01 */
static int hf_lte_rrc_t_Reordering_r14 = -1;      /* T_Reordering */
static int hf_lte_rrc_t_PollRetransmit_r13 = -1;  /* T_PollRetransmit_NB_r13 */
static int hf_lte_rrc_maxRetxThreshold_r13 = -1;  /* T_maxRetxThreshold_r13 */
static int hf_lte_rrc_enableStatusReportSN_Gap_r13 = -1;  /* T_enableStatusReportSN_Gap_r13 */
static int hf_lte_rrc_setup_204 = -1;             /* T_setup_178 */
static int hf_lte_rrc_t301_r13 = -1;              /* T_t301_r13 */
static int hf_lte_rrc_t310_r13 = -1;              /* T_t310_r13 */
static int hf_lte_rrc_n310_r13 = -1;              /* T_n310_r13 */
static int hf_lte_rrc_t311_r13 = -1;              /* T_t311_r13 */
static int hf_lte_rrc_n311_r13 = -1;              /* T_n311_r13 */
static int hf_lte_rrc_t311_v1350 = -1;            /* T_t311_v1350 */
static int hf_lte_rrc_t301_v1530 = -1;            /* T_t301_v1530 */
static int hf_lte_rrc_t311_v1530 = -1;            /* T_t311_v1530 */
static int hf_lte_rrc_sr_WithHARQ_ACK_Config_r15 = -1;  /* T_sr_WithHARQ_ACK_Config_r15 */
static int hf_lte_rrc_sr_WithoutHARQ_ACK_Config_r15 = -1;  /* SR_WithoutHARQ_ACK_Config_NB_r15 */
static int hf_lte_rrc_sr_SPS_BSR_Config_r15 = -1;  /* SR_SPS_BSR_Config_NB_r15 */
static int hf_lte_rrc_setup_205 = -1;             /* T_setup_179 */
static int hf_lte_rrc_sr_ProhibitTimer_r15 = -1;  /* INTEGER_0_7 */
static int hf_lte_rrc_sr_NPRACH_Resource_r15 = -1;  /* SR_NPRACH_Resource_NB_r15 */
static int hf_lte_rrc_nprach_CarrierIndex_r15 = -1;  /* INTEGER_0_maxNonAnchorCarriers_NB_r14 */
static int hf_lte_rrc_nprach_ResourceIndex_r15 = -1;  /* INTEGER_1_maxNPRACH_Resources_NB_r13 */
static int hf_lte_rrc_nprach_SubCarrierIndex_r15 = -1;  /* T_nprach_SubCarrierIndex_r15 */
static int hf_lte_rrc_nprach_Fmt0Fmt1_r15 = -1;   /* INTEGER_0_47 */
static int hf_lte_rrc_nprach_Fmt2_r15 = -1;       /* INTEGER_0_143 */
static int hf_lte_rrc_p0_SR_r15 = -1;             /* INTEGER_M126_24 */
static int hf_lte_rrc_alpha_r15 = -1;             /* T_alpha_r15 */
static int hf_lte_rrc_setup_206 = -1;             /* T_setup_180 */
static int hf_lte_rrc_semiPersistSchedIntervalUL_r15 = -1;  /* T_semiPersistSchedIntervalUL_r15 */
static int hf_lte_rrc_subframeAssignment_r15_01 = -1;  /* T_subframeAssignment_r15 */
static int hf_lte_rrc_specialSubframePatterns_r15 = -1;  /* T_specialSubframePatterns_r15 */
static int hf_lte_rrc_p0_NominalNPUSCH_r13 = -1;  /* INTEGER_M126_24 */
static int hf_lte_rrc_alpha_r13 = -1;             /* T_alpha_r13 */
static int hf_lte_rrc_deltaPreambleMsg3_r13 = -1;  /* INTEGER_M1_6 */
static int hf_lte_rrc_p0_UE_NPUSCH_r13 = -1;      /* INTEGER_M8_7 */
static int hf_lte_rrc_maxDurationFactor_r15_01 = -1;  /* WUS_MaxDurationFactor_NB_r15 */
static int hf_lte_rrc_numPOs_r15_01 = -1;         /* T_numPOs_r15_01 */
static int hf_lte_rrc_numDRX_CyclesRelaxed_r15 = -1;  /* T_numDRX_CyclesRelaxed_r15 */
static int hf_lte_rrc_timeOffsetDRX_r15_01 = -1;  /* T_timeOffsetDRX_r15_01 */
static int hf_lte_rrc_timeOffset_eDRX_Short_r15_01 = -1;  /* T_timeOffset_eDRX_Short_r15_01 */
static int hf_lte_rrc_timeOffset_eDRX_Long_r15_01 = -1;  /* T_timeOffset_eDRX_Long_r15_01 */
static int hf_lte_rrc_AdditionalBandInfoList_NB_r14_item = -1;  /* FreqBandIndicator_NB_r13 */
static int hf_lte_rrc_MultiBandInfoList_NB_r13_item = -1;  /* MultiBandInfo_NB_r13 */
static int hf_lte_rrc_NS_PmaxList_NB_r13_item = -1;  /* NS_PmaxValue_NB_r13 */
static int hf_lte_rrc_additionalPmax_r13 = -1;    /* P_Max */
static int hf_lte_rrc_nrsrpResult_r14 = -1;       /* NRSRP_Range_NB_r14 */
static int hf_lte_rrc_nrsrqResult_r14 = -1;       /* NRSRQ_Range_NB_r14 */
static int hf_lte_rrc_nsss_RRM_PowerOffset_r15 = -1;  /* T_nsss_RRM_PowerOffset_r15 */
static int hf_lte_rrc_nsss_NumOccDiffPrecoders_r15 = -1;  /* T_nsss_NumOccDiffPrecoders_r15 */
static int hf_lte_rrc_accessStratumRelease_r13 = -1;  /* AccessStratumRelease_NB_r13 */
static int hf_lte_rrc_ue_Category_NB_r13 = -1;    /* T_ue_Category_NB_r13 */
static int hf_lte_rrc_multipleDRB_r13 = -1;       /* T_multipleDRB_r13 */
static int hf_lte_rrc_pdcp_Parameters_r13 = -1;   /* PDCP_Parameters_NB_r13 */
static int hf_lte_rrc_phyLayerParameters_r13 = -1;  /* PhyLayerParameters_NB_r13 */
static int hf_lte_rrc_rf_Parameters_r13 = -1;     /* RF_Parameters_NB_r13 */
static int hf_lte_rrc_dummy_09 = -1;              /* T_dummy_06 */
static int hf_lte_rrc_ue_Category_NB_r14 = -1;    /* T_ue_Category_NB_r14 */
static int hf_lte_rrc_mac_Parameters_r14 = -1;    /* MAC_Parameters_NB_r14 */
static int hf_lte_rrc_phyLayerParameters_v1430_01 = -1;  /* PhyLayerParameters_NB_v1430 */
static int hf_lte_rrc_rf_Parameters_v1430_01 = -1;  /* RF_Parameters_NB_v1430 */
static int hf_lte_rrc_nonCriticalExtension_333 = -1;  /* UE_Capability_NB_v1440_IEs */
static int hf_lte_rrc_phyLayerParameters_v1440 = -1;  /* PhyLayerParameters_NB_v1440 */
static int hf_lte_rrc_nonCriticalExtension_334 = -1;  /* UE_Capability_NB_v14x0_IEs */
static int hf_lte_rrc_nonCriticalExtension_335 = -1;  /* UE_Capability_NB_v1530_IEs */
static int hf_lte_rrc_earlyData_UP_r15_01 = -1;   /* T_earlyData_UP_r15_01 */
static int hf_lte_rrc_rlc_Parameters_r15 = -1;    /* RLC_Parameters_NB_r15 */
static int hf_lte_rrc_mac_Parameters_v1530_01 = -1;  /* MAC_Parameters_NB_v1530 */
static int hf_lte_rrc_phyLayerParameters_v1530_01 = -1;  /* PhyLayerParameters_NB_v1530 */
static int hf_lte_rrc_tdd_UE_Capability_r15 = -1;  /* TDD_UE_Capability_NB_r15 */
static int hf_lte_rrc_nonCriticalExtension_336 = -1;  /* T_nonCriticalExtension_104 */
static int hf_lte_rrc_ue_Category_NB_r15 = -1;    /* T_ue_Category_NB_r15 */
static int hf_lte_rrc_phyLayerParametersRel13_r15 = -1;  /* PhyLayerParameters_NB_r13 */
static int hf_lte_rrc_phyLayerParametersRel14_r15 = -1;  /* PhyLayerParameters_NB_v1430 */
static int hf_lte_rrc_supportedROHC_Profiles_r13 = -1;  /* T_supportedROHC_Profiles_r13 */
static int hf_lte_rrc_maxNumberROHC_ContextSessions_r13 = -1;  /* T_maxNumberROHC_ContextSessions_r13 */
static int hf_lte_rrc_rlc_UM_r15 = -1;            /* T_rlc_UM_r15 */
static int hf_lte_rrc_dataInactMon_r14_01 = -1;   /* T_dataInactMon_r14_01 */
static int hf_lte_rrc_rai_Support_r14_01 = -1;    /* T_rai_Support_r14_01 */
static int hf_lte_rrc_sr_SPS_BSR_r15 = -1;        /* T_sr_SPS_BSR_r15 */
static int hf_lte_rrc_multiTone_r13 = -1;         /* T_multiTone_r13 */
static int hf_lte_rrc_multiCarrier_r13 = -1;      /* T_multiCarrier_r13 */
static int hf_lte_rrc_multiCarrier_NPRACH_r14 = -1;  /* T_multiCarrier_NPRACH_r14 */
static int hf_lte_rrc_twoHARQ_Processes_r14 = -1;  /* T_twoHARQ_Processes_r14 */
static int hf_lte_rrc_interferenceRandomisation_r14 = -1;  /* T_interferenceRandomisation_r14 */
static int hf_lte_rrc_mixedOperationMode_r15 = -1;  /* T_mixedOperationMode_r15 */
static int hf_lte_rrc_sr_WithHARQ_ACK_r15 = -1;   /* T_sr_WithHARQ_ACK_r15 */
static int hf_lte_rrc_sr_WithoutHARQ_ACK_r15 = -1;  /* T_sr_WithoutHARQ_ACK_r15 */
static int hf_lte_rrc_nprach_Format2_r15 = -1;    /* T_nprach_Format2_r15 */
static int hf_lte_rrc_additionalTransmissionSIB1_r15_01 = -1;  /* T_additionalTransmissionSIB1_r15 */
static int hf_lte_rrc_npusch_3dot75kHz_SCS_TDD_r15 = -1;  /* T_npusch_3dot75kHz_SCS_TDD_r15 */
static int hf_lte_rrc_supportedBandList_r13 = -1;  /* SupportedBandList_NB_r13 */
static int hf_lte_rrc_multiNS_Pmax_r13 = -1;      /* T_multiNS_Pmax_r13 */
static int hf_lte_rrc_powerClassNB_14dBm_r14 = -1;  /* T_powerClassNB_14dBm_r14 */
static int hf_lte_rrc_SupportedBandList_NB_r13_item = -1;  /* SupportedBand_NB_r13 */
static int hf_lte_rrc_band_r13 = -1;              /* FreqBandIndicator_NB_r13 */
static int hf_lte_rrc_powerClassNB_20dBm_r13 = -1;  /* T_powerClassNB_20dBm_r13 */
static int hf_lte_rrc_ue_Category_NB_r13_01 = -1;  /* T_ue_Category_NB_r13_01 */
static int hf_lte_rrc_multiCarrierPaging_r14 = -1;  /* T_multiCarrierPaging_r14 */
static int hf_lte_rrc_mixedOperationMode_r15_01 = -1;  /* T_mixedOperationMode_r15_01 */
static int hf_lte_rrc_wakeUpSignal_r15_01 = -1;   /* T_wakeUpSignal_r15_01 */
static int hf_lte_rrc_wakeUpSignalMinGap_eDRX_r15_01 = -1;  /* T_wakeUpSignalMinGap_eDRX_r15_01 */
static int hf_lte_rrc_multiCarrierPagingTDD_r15 = -1;  /* T_multiCarrierPagingTDD_r15 */
static int hf_lte_rrc_t300_r13 = -1;              /* T_t300_r13 */
static int hf_lte_rrc_t301_r13_01 = -1;           /* T_t301_r13_01 */
static int hf_lte_rrc_t310_r13_01 = -1;           /* T_t310_r13_01 */
static int hf_lte_rrc_n310_r13_01 = -1;           /* T_n310_r13_01 */
static int hf_lte_rrc_t311_r13_01 = -1;           /* T_t311_r13_01 */
static int hf_lte_rrc_n311_r13_01 = -1;           /* T_n311_r13_01 */
static int hf_lte_rrc_t311_v1350_01 = -1;         /* T_t311_v1350_01 */
static int hf_lte_rrc_t300_v1530 = -1;            /* T_t300_v1530 */
static int hf_lte_rrc_t301_v1530_01 = -1;         /* T_t301_v1530_01 */
static int hf_lte_rrc_t311_v1530_01 = -1;         /* T_t311_v1530_01 */
static int hf_lte_rrc_t300_r15_01 = -1;           /* T_t300_r15_01 */
static int hf_lte_rrc_SC_MTCH_InfoList_NB_r14_item = -1;  /* SC_MTCH_Info_NB_r14 */
static int hf_lte_rrc_sc_mtch_CarrierConfig_r14 = -1;  /* T_sc_mtch_CarrierConfig_r14 */
static int hf_lte_rrc_sc_mtch_SchedulingInfo_r14 = -1;  /* SC_MTCH_SchedulingInfo_NB_r14 */
static int hf_lte_rrc_sc_mtch_NeighbourCell_r14 = -1;  /* BIT_STRING_SIZE_maxNeighCell_SCPTM_NB_r14 */
static int hf_lte_rrc_npdcch_NPDSCH_MaxTBS_SC_MTCH_r14 = -1;  /* T_npdcch_NPDSCH_MaxTBS_SC_MTCH_r14 */
static int hf_lte_rrc_npdcch_NumRepetitions_SC_MTCH_r14 = -1;  /* T_npdcch_NumRepetitions_SC_MTCH_r14 */
static int hf_lte_rrc_npdcch_StartSF_SC_MTCH_r14 = -1;  /* T_npdcch_StartSF_SC_MTCH_r14 */
static int hf_lte_rrc_npdcch_Offset_SC_MTCH_r14 = -1;  /* T_npdcch_Offset_SC_MTCH_r14 */
static int hf_lte_rrc_onDurationTimerSCPTM_r14_03 = -1;  /* T_onDurationTimerSCPTM_r14_03 */
static int hf_lte_rrc_drx_InactivityTimerSCPTM_r14_03 = -1;  /* T_drx_InactivityTimerSCPTM_r14_03 */
static int hf_lte_rrc_schedulingPeriodStartOffsetSCPTM_r14_03 = -1;  /* T_schedulingPeriodStartOffsetSCPTM_r14_03 */
static int hf_lte_rrc_SCPTM_NeighbourCellList_NB_r14_item = -1;  /* PCI_ARFCN_NB_r14 */
static int hf_lte_rrc_physCellId_r14 = -1;        /* PhysCellId */
static int hf_lte_rrc_carrierFreq_r14 = -1;       /* CarrierFreq_NB_r13 */
static int dummy_hf_lte_rrc_eag_field = -1; /* never registered */

/*--- End of included file: packet-lte-rrc-hf.c ---*/
#line 78 "./asn1/lte-rrc/packet-lte-rrc-template.c"

static int hf_lte_rrc_eutra_cap_feat_group_ind_1 = -1;
static int hf_lte_rrc_eutra_cap_feat_group_ind_2 = -1;
static int hf_lte_rrc_eutra_cap_feat_group_ind_3 = -1;
static int hf_lte_rrc_eutra_cap_feat_group_ind_4 = -1;
static int hf_lte_rrc_eutra_cap_feat_group_ind_5 = -1;
static int hf_lte_rrc_eutra_cap_feat_group_ind_6 = -1;
static int hf_lte_rrc_eutra_cap_feat_group_ind_7 = -1;
static int hf_lte_rrc_eutra_cap_feat_group_ind_8 = -1;
static int hf_lte_rrc_eutra_cap_feat_group_ind_9 = -1;
static int hf_lte_rrc_eutra_cap_feat_group_ind_10 = -1;
static int hf_lte_rrc_eutra_cap_feat_group_ind_11 = -1;
static int hf_lte_rrc_eutra_cap_feat_group_ind_12 = -1;
static int hf_lte_rrc_eutra_cap_feat_group_ind_13 = -1;
static int hf_lte_rrc_eutra_cap_feat_group_ind_14 = -1;
static int hf_lte_rrc_eutra_cap_feat_group_ind_15 = -1;
static int hf_lte_rrc_eutra_cap_feat_group_ind_16 = -1;
static int hf_lte_rrc_eutra_cap_feat_group_ind_17 = -1;
static int hf_lte_rrc_eutra_cap_feat_group_ind_18 = -1;
static int hf_lte_rrc_eutra_cap_feat_group_ind_19 = -1;
static int hf_lte_rrc_eutra_cap_feat_group_ind_20 = -1;
static int hf_lte_rrc_eutra_cap_feat_group_ind_21 = -1;
static int hf_lte_rrc_eutra_cap_feat_group_ind_22 = -1;
static int hf_lte_rrc_eutra_cap_feat_group_ind_23 = -1;
static int hf_lte_rrc_eutra_cap_feat_group_ind_24 = -1;
static int hf_lte_rrc_eutra_cap_feat_group_ind_25 = -1;
static int hf_lte_rrc_eutra_cap_feat_group_ind_26 = -1;
static int hf_lte_rrc_eutra_cap_feat_group_ind_27 = -1;
static int hf_lte_rrc_eutra_cap_feat_group_ind_28 = -1;
static int hf_lte_rrc_eutra_cap_feat_group_ind_29 = -1;
static int hf_lte_rrc_eutra_cap_feat_group_ind_30 = -1;
static int hf_lte_rrc_eutra_cap_feat_group_ind_31 = -1;
static int hf_lte_rrc_eutra_cap_feat_group_ind_32 = -1;
static int hf_lte_rrc_eutra_cap_feat_group_ind_33 = -1;
static int hf_lte_rrc_eutra_cap_feat_group_ind_34 = -1;
static int hf_lte_rrc_eutra_cap_feat_group_ind_35 = -1;
static int hf_lte_rrc_eutra_cap_feat_group_ind_36 = -1;
static int hf_lte_rrc_eutra_cap_feat_group_ind_37 = -1;
static int hf_lte_rrc_eutra_cap_feat_group_ind_38 = -1;
static int hf_lte_rrc_eutra_cap_feat_group_ind_39 = -1;
static int hf_lte_rrc_eutra_cap_feat_group_ind_40 = -1;
static int hf_lte_rrc_eutra_cap_feat_group_ind_41 = -1;
static int hf_lte_rrc_eutra_cap_feat_group_ind_42 = -1;
static int hf_lte_rrc_eutra_cap_feat_group_ind_43 = -1;
static int hf_lte_rrc_eutra_cap_feat_group_ind_44 = -1;
static int hf_lte_rrc_eutra_cap_feat_group_ind_45 = -1;
static int hf_lte_rrc_eutra_cap_feat_group_ind_46 = -1;
static int hf_lte_rrc_eutra_cap_feat_group_ind_47 = -1;
static int hf_lte_rrc_eutra_cap_feat_group_ind_48 = -1;
static int hf_lte_rrc_eutra_cap_feat_group_ind_49 = -1;
static int hf_lte_rrc_eutra_cap_feat_group_ind_50 = -1;
static int hf_lte_rrc_eutra_cap_feat_group_ind_51 = -1;
static int hf_lte_rrc_eutra_cap_feat_group_ind_52 = -1;
static int hf_lte_rrc_eutra_cap_feat_group_ind_53 = -1;
static int hf_lte_rrc_eutra_cap_feat_group_ind_54 = -1;
static int hf_lte_rrc_eutra_cap_feat_group_ind_55 = -1;
static int hf_lte_rrc_eutra_cap_feat_group_ind_56 = -1;
static int hf_lte_rrc_eutra_cap_feat_group_ind_57 = -1;
static int hf_lte_rrc_eutra_cap_feat_group_ind_58 = -1;
static int hf_lte_rrc_eutra_cap_feat_group_ind_59 = -1;
static int hf_lte_rrc_eutra_cap_feat_group_ind_60 = -1;
static int hf_lte_rrc_eutra_cap_feat_group_ind_61 = -1;
static int hf_lte_rrc_eutra_cap_feat_group_ind_62 = -1;
static int hf_lte_rrc_eutra_cap_feat_group_ind_63 = -1;
static int hf_lte_rrc_eutra_cap_feat_group_ind_64 = -1;
static int hf_lte_rrc_eutra_cap_feat_group_ind_101 = -1;
static int hf_lte_rrc_eutra_cap_feat_group_ind_102 = -1;
static int hf_lte_rrc_eutra_cap_feat_group_ind_103 = -1;
static int hf_lte_rrc_eutra_cap_feat_group_ind_104 = -1;
static int hf_lte_rrc_eutra_cap_feat_group_ind_105 = -1;
static int hf_lte_rrc_eutra_cap_feat_group_ind_106 = -1;
static int hf_lte_rrc_eutra_cap_feat_group_ind_107 = -1;
static int hf_lte_rrc_eutra_cap_feat_group_ind_108 = -1;
static int hf_lte_rrc_eutra_cap_feat_group_ind_109 = -1;
static int hf_lte_rrc_eutra_cap_feat_group_ind_110 = -1;
static int hf_lte_rrc_eutra_cap_feat_group_ind_111 = -1;
static int hf_lte_rrc_eutra_cap_feat_group_ind_112 = -1;
static int hf_lte_rrc_eutra_cap_feat_group_ind_113 = -1;
static int hf_lte_rrc_eutra_cap_feat_group_ind_114 = -1;
static int hf_lte_rrc_eutra_cap_feat_group_ind_115 = -1;
static int hf_lte_rrc_eutra_cap_feat_group_ind_116 = -1;
static int hf_lte_rrc_eutra_cap_feat_group_ind_117 = -1;
static int hf_lte_rrc_eutra_cap_feat_group_ind_118 = -1;
static int hf_lte_rrc_eutra_cap_feat_group_ind_119 = -1;
static int hf_lte_rrc_eutra_cap_feat_group_ind_120 = -1;
static int hf_lte_rrc_eutra_cap_feat_group_ind_121 = -1;
static int hf_lte_rrc_eutra_cap_feat_group_ind_122 = -1;
static int hf_lte_rrc_eutra_cap_feat_group_ind_123 = -1;
static int hf_lte_rrc_eutra_cap_feat_group_ind_124 = -1;
static int hf_lte_rrc_eutra_cap_feat_group_ind_125 = -1;
static int hf_lte_rrc_eutra_cap_feat_group_ind_126 = -1;
static int hf_lte_rrc_eutra_cap_feat_group_ind_127 = -1;
static int hf_lte_rrc_eutra_cap_feat_group_ind_128 = -1;
static int hf_lte_rrc_eutra_cap_feat_group_ind_129 = -1;
static int hf_lte_rrc_eutra_cap_feat_group_ind_130 = -1;
static int hf_lte_rrc_eutra_cap_feat_group_ind_131 = -1;
static int hf_lte_rrc_eutra_cap_feat_group_ind_132 = -1;
static int hf_lte_rrc_serialNumber_gs = -1;
static int hf_lte_rrc_serialNumber_msg_code = -1;
static int hf_lte_rrc_serialNumber_upd_nb = -1;
static int hf_lte_rrc_warningType_value = -1;
static int hf_lte_rrc_warningType_emergency_user_alert = -1;
static int hf_lte_rrc_warningType_popup = -1;
static int hf_lte_rrc_warningMessageSegment_nb_pages = -1;
static int hf_lte_rrc_warningMessageSegment_decoded_page = -1;
static int hf_lte_rrc_interBandTDD_CA_WithDifferentConfig_bit1 = -1;
static int hf_lte_rrc_interBandTDD_CA_WithDifferentConfig_bit2 = -1;
static int hf_lte_rrc_tdd_FDD_CA_PCellDuplex_r12_bit1 = -1;
static int hf_lte_rrc_tdd_FDD_CA_PCellDuplex_r12_bit2 = -1;
static int hf_lte_rrc_aperiodicCSI_Reporting_r13_bit1 = -1;
static int hf_lte_rrc_aperiodicCSI_Reporting_r13_bit2 = -1;
static int hf_lte_rrc_codebook_HARQ_ACK_r13_bit1 = -1;
static int hf_lte_rrc_codebook_HARQ_ACK_r13_bit2 = -1;
static int hf_lte_rrc_sr_config_periodicity = -1;
static int hf_lte_rrc_sr_config_subframe_offset = -1;
static int hf_lte_rrc_cdma_time = -1;
static int hf_lte_rrc_utc_time = -1;
static int hf_lte_rrc_local_time = -1;
static int hf_lte_rrc_absolute_time = -1;
static int hf_lte_rrc_transmissionModeList_r12_tm1 = -1;
static int hf_lte_rrc_transmissionModeList_r12_tm2 = -1;
static int hf_lte_rrc_transmissionModeList_r12_tm3 = -1;
static int hf_lte_rrc_transmissionModeList_r12_tm4 = -1;
static int hf_lte_rrc_transmissionModeList_r12_tm6 = -1;
static int hf_lte_rrc_transmissionModeList_r12_tm8 = -1;
static int hf_lte_rrc_transmissionModeList_r12_tm9 = -1;
static int hf_lte_rrc_transmissionModeList_r12_tm10 = -1;
static int hf_lte_rrc_modifiedMPR_Behavior_r10_mpr_ampr_0 = -1;
static int hf_lte_rrc_modifiedMPR_Behavior_r10_mpr_ampr_1 = -1;
static int hf_lte_rrc_modifiedMPR_Behavior_r10_mpr_ampr_2 = -1;
static int hf_lte_rrc_modifiedMPR_Behavior_r10_mpr_ampr_3 = -1;
static int hf_lte_rrc_modifiedMPR_Behavior_r10_mpr_ampr_4 = -1;
static int hf_lte_rrc_modifiedMPR_Behavior_r10_mpr_ampr_5 = -1;
static int hf_lte_rrc_modifiedMPR_Behavior_r10_mpr_ampr_6 = -1;
static int hf_lte_rrc_modifiedMPR_Behavior_r10_mpr_ampr_7 = -1;
static int hf_lte_rrc_modifiedMPR_Behavior_r10_mpr_ampr_8 = -1;
static int hf_lte_rrc_modifiedMPR_Behavior_r10_mpr_ampr_9 = -1;
static int hf_lte_rrc_modifiedMPR_Behavior_r10_mpr_ampr_10 = -1;
static int hf_lte_rrc_modifiedMPR_Behavior_r10_mpr_ampr_11 = -1;
static int hf_lte_rrc_modifiedMPR_Behavior_r10_mpr_ampr_12 = -1;
static int hf_lte_rrc_modifiedMPR_Behavior_r10_mpr_ampr_13 = -1;
static int hf_lte_rrc_modifiedMPR_Behavior_r10_mpr_ampr_14 = -1;
static int hf_lte_rrc_modifiedMPR_Behavior_r10_mpr_ampr_15 = -1;
static int hf_lte_rrc_modifiedMPR_Behavior_r10_mpr_ampr_16 = -1;
static int hf_lte_rrc_modifiedMPR_Behavior_r10_mpr_ampr_17 = -1;
static int hf_lte_rrc_modifiedMPR_Behavior_r10_mpr_ampr_18 = -1;
static int hf_lte_rrc_modifiedMPR_Behavior_r10_mpr_ampr_19 = -1;
static int hf_lte_rrc_modifiedMPR_Behavior_r10_mpr_ampr_20 = -1;
static int hf_lte_rrc_modifiedMPR_Behavior_r10_mpr_ampr_21 = -1;
static int hf_lte_rrc_modifiedMPR_Behavior_r10_mpr_ampr_22 = -1;
static int hf_lte_rrc_modifiedMPR_Behavior_r10_mpr_ampr_23 = -1;
static int hf_lte_rrc_modifiedMPR_Behavior_r10_mpr_ampr_24 = -1;
static int hf_lte_rrc_modifiedMPR_Behavior_r10_mpr_ampr_25 = -1;
static int hf_lte_rrc_modifiedMPR_Behavior_r10_mpr_ampr_26 = -1;
static int hf_lte_rrc_modifiedMPR_Behavior_r10_mpr_ampr_27 = -1;
static int hf_lte_rrc_modifiedMPR_Behavior_r10_mpr_ampr_28 = -1;
static int hf_lte_rrc_modifiedMPR_Behavior_r10_mpr_ampr_29 = -1;
static int hf_lte_rrc_modifiedMPR_Behavior_r10_mpr_ampr_30 = -1;
static int hf_lte_rrc_modifiedMPR_Behavior_r10_mpr_ampr_31 = -1;
static int hf_lte_rrc_sib11_fragments = -1;
static int hf_lte_rrc_sib11_fragment = -1;
static int hf_lte_rrc_sib11_fragment_overlap = -1;
static int hf_lte_rrc_sib11_fragment_overlap_conflict = -1;
static int hf_lte_rrc_sib11_fragment_multiple_tails = -1;
static int hf_lte_rrc_sib11_fragment_too_long_fragment = -1;
static int hf_lte_rrc_sib11_fragment_error = -1;
static int hf_lte_rrc_sib11_fragment_count = -1;
static int hf_lte_rrc_sib11_reassembled_in = -1;
static int hf_lte_rrc_sib11_reassembled_length = -1;
static int hf_lte_rrc_sib11_reassembled_data = -1;
static int hf_lte_rrc_sib12_fragments = -1;
static int hf_lte_rrc_sib12_fragment = -1;
static int hf_lte_rrc_sib12_fragment_overlap = -1;
static int hf_lte_rrc_sib12_fragment_overlap_conflict = -1;
static int hf_lte_rrc_sib12_fragment_multiple_tails = -1;
static int hf_lte_rrc_sib12_fragment_too_long_fragment = -1;
static int hf_lte_rrc_sib12_fragment_error = -1;
static int hf_lte_rrc_sib12_fragment_count = -1;
static int hf_lte_rrc_sib12_reassembled_in = -1;
static int hf_lte_rrc_sib12_reassembled_length = -1;
static int hf_lte_rrc_sib12_reassembled_data = -1;
static int hf_lte_rrc_measGapPatterns_r15_bit1 = -1;
static int hf_lte_rrc_measGapPatterns_r15_bit2 = -1;
static int hf_lte_rrc_measGapPatterns_r15_bit3 = -1;
static int hf_lte_rrc_measGapPatterns_r15_bit4 = -1;
static int hf_lte_rrc_measGapPatterns_r15_bit5 = -1;
static int hf_lte_rrc_measGapPatterns_r15_bit6 = -1;
static int hf_lte_rrc_measGapPatterns_r15_bit7 = -1;
static int hf_lte_rrc_measGapPatterns_r15_bit8 = -1;

/* Initialize the subtree pointers */
static int ett_lte_rrc = -1;


/*--- Included file: packet-lte-rrc-ett.c ---*/
#line 1 "./asn1/lte-rrc/packet-lte-rrc-ett.c"
static gint ett_lte_rrc_HandoverCommand = -1;
static gint ett_lte_rrc_T_criticalExtensions = -1;
static gint ett_lte_rrc_T_c1 = -1;
static gint ett_lte_rrc_T_criticalExtensionsFuture = -1;
static gint ett_lte_rrc_HandoverCommand_r8_IEs = -1;
static gint ett_lte_rrc_T_nonCriticalExtension = -1;
static gint ett_lte_rrc_HandoverPreparationInformation = -1;
static gint ett_lte_rrc_T_criticalExtensions_01 = -1;
static gint ett_lte_rrc_T_c1_01 = -1;
static gint ett_lte_rrc_T_criticalExtensionsFuture_01 = -1;
static gint ett_lte_rrc_HandoverPreparationInformation_r8_IEs = -1;
static gint ett_lte_rrc_HandoverPreparationInformation_v920_IEs = -1;
static gint ett_lte_rrc_HandoverPreparationInformation_v9d0_IEs = -1;
static gint ett_lte_rrc_HandoverPreparationInformation_v9j0_IEs = -1;
static gint ett_lte_rrc_HandoverPreparationInformation_v10j0_IEs = -1;
static gint ett_lte_rrc_HandoverPreparationInformation_v10x0_IEs = -1;
static gint ett_lte_rrc_HandoverPreparationInformation_v13c0_IEs = -1;
static gint ett_lte_rrc_T_nonCriticalExtension_01 = -1;
static gint ett_lte_rrc_HandoverPreparationInformation_v9e0_IEs = -1;
static gint ett_lte_rrc_HandoverPreparationInformation_v1130_IEs = -1;
static gint ett_lte_rrc_HandoverPreparationInformation_v1250_IEs = -1;
static gint ett_lte_rrc_HandoverPreparationInformation_v1320_IEs = -1;
static gint ett_lte_rrc_HandoverPreparationInformation_v1430_IEs = -1;
static gint ett_lte_rrc_HandoverPreparationInformation_v1530_IEs = -1;
static gint ett_lte_rrc_HandoverPreparationInformation_v1540_IEs = -1;
static gint ett_lte_rrc_T_nonCriticalExtension_02 = -1;
static gint ett_lte_rrc_SCG_Config_r12 = -1;
static gint ett_lte_rrc_T_criticalExtensions_02 = -1;
static gint ett_lte_rrc_T_c1_02 = -1;
static gint ett_lte_rrc_T_criticalExtensionsFuture_02 = -1;
static gint ett_lte_rrc_SCG_Config_r12_IEs = -1;
static gint ett_lte_rrc_SCG_Config_v12i0a_IEs = -1;
static gint ett_lte_rrc_SCG_Config_v12i0b_IEs = -1;
static gint ett_lte_rrc_T_nonCriticalExtension_03 = -1;
static gint ett_lte_rrc_SCG_Config_v13c0_IEs = -1;
static gint ett_lte_rrc_T_nonCriticalExtension_04 = -1;
static gint ett_lte_rrc_SCG_ConfigInfo_r12 = -1;
static gint ett_lte_rrc_T_criticalExtensions_03 = -1;
static gint ett_lte_rrc_T_c1_03 = -1;
static gint ett_lte_rrc_T_criticalExtensionsFuture_03 = -1;
static gint ett_lte_rrc_SCG_ConfigInfo_r12_IEs = -1;
static gint ett_lte_rrc_SCG_ConfigInfo_v1310_IEs = -1;
static gint ett_lte_rrc_SCG_ConfigInfo_v1330_IEs = -1;
static gint ett_lte_rrc_SCG_ConfigInfo_v1430_IEs = -1;
static gint ett_lte_rrc_SCG_ConfigInfo_v1530_IEs = -1;
static gint ett_lte_rrc_T_nonCriticalExtension_05 = -1;
static gint ett_lte_rrc_DRB_InfoListSCG_r12 = -1;
static gint ett_lte_rrc_DRB_InfoListSCG_r15 = -1;
static gint ett_lte_rrc_DRB_InfoSCG_r12 = -1;
static gint ett_lte_rrc_SCellToAddModListSCG_r12 = -1;
static gint ett_lte_rrc_SCellToAddModListSCG_Ext_r13 = -1;
static gint ett_lte_rrc_Cell_ToAddMod_r12 = -1;
static gint ett_lte_rrc_T_cellIdentification_r12 = -1;
static gint ett_lte_rrc_T_measResultCellToAdd_r12 = -1;
static gint ett_lte_rrc_T_measResultCellToAdd_v1310 = -1;
static gint ett_lte_rrc_MeasResultServCellListSCG_r12 = -1;
static gint ett_lte_rrc_MeasResultServCellListSCG_Ext_r13 = -1;
static gint ett_lte_rrc_MeasResultServCellSCG_r12 = -1;
static gint ett_lte_rrc_T_measResultSCell_r12 = -1;
static gint ett_lte_rrc_T_measResultSCell_v1310 = -1;
static gint ett_lte_rrc_MeasResultListRSSI_SCG_r13 = -1;
static gint ett_lte_rrc_MeasResultRSSI_SCG_r13 = -1;
static gint ett_lte_rrc_SCG_ConfigRestrictInfo_r12 = -1;
static gint ett_lte_rrc_UEPagingCoverageInformation = -1;
static gint ett_lte_rrc_T_criticalExtensions_04 = -1;
static gint ett_lte_rrc_T_c1_04 = -1;
static gint ett_lte_rrc_T_criticalExtensionsFuture_04 = -1;
static gint ett_lte_rrc_UEPagingCoverageInformation_r13_IEs = -1;
static gint ett_lte_rrc_T_nonCriticalExtension_06 = -1;
static gint ett_lte_rrc_UERadioAccessCapabilityInformation = -1;
static gint ett_lte_rrc_T_criticalExtensions_05 = -1;
static gint ett_lte_rrc_T_c1_05 = -1;
static gint ett_lte_rrc_T_criticalExtensionsFuture_05 = -1;
static gint ett_lte_rrc_UERadioAccessCapabilityInformation_r8_IEs = -1;
static gint ett_lte_rrc_T_nonCriticalExtension_07 = -1;
static gint ett_lte_rrc_UERadioPagingInformation = -1;
static gint ett_lte_rrc_T_criticalExtensions_06 = -1;
static gint ett_lte_rrc_T_c1_06 = -1;
static gint ett_lte_rrc_T_criticalExtensionsFuture_06 = -1;
static gint ett_lte_rrc_UERadioPagingInformation_r12_IEs = -1;
static gint ett_lte_rrc_UERadioPagingInformation_v1310_IEs = -1;
static gint ett_lte_rrc_SEQUENCE_SIZE_1_maxBands_OF_FreqBandIndicator_r11 = -1;
static gint ett_lte_rrc_T_nonCriticalExtension_08 = -1;
static gint ett_lte_rrc_AS_Config = -1;
static gint ett_lte_rrc_AS_Config_v9e0 = -1;
static gint ett_lte_rrc_AS_Config_v10j0 = -1;
static gint ett_lte_rrc_AS_Config_v1250 = -1;
static gint ett_lte_rrc_AS_Config_v1320 = -1;
static gint ett_lte_rrc_AS_Config_v13c0 = -1;
static gint ett_lte_rrc_AS_Config_v1430 = -1;
static gint ett_lte_rrc_AS_ConfigNR_r15 = -1;
static gint ett_lte_rrc_AS_ConfigNR_v1570 = -1;
static gint ett_lte_rrc_AS_Config_v1550 = -1;
static gint ett_lte_rrc_T_tdm_PatternConfig_r15 = -1;
static gint ett_lte_rrc_AS_Context = -1;
static gint ett_lte_rrc_AS_Context_v1130 = -1;
static gint ett_lte_rrc_AS_Context_v1320 = -1;
static gint ett_lte_rrc_ReestablishmentInfo = -1;
static gint ett_lte_rrc_AdditionalReestabInfoList = -1;
static gint ett_lte_rrc_AdditionalReestabInfo = -1;
static gint ett_lte_rrc_RRM_Config = -1;
static gint ett_lte_rrc_CandidateCellInfoList_r10 = -1;
static gint ett_lte_rrc_CandidateCellInfo_r10 = -1;
static gint ett_lte_rrc_BCCH_BCH_Message = -1;
static gint ett_lte_rrc_BCCH_BCH_Message_MBMS = -1;
static gint ett_lte_rrc_BCCH_DL_SCH_Message = -1;
static gint ett_lte_rrc_BCCH_DL_SCH_MessageType = -1;
static gint ett_lte_rrc_T_c1_07 = -1;
static gint ett_lte_rrc_T_messageClassExtension = -1;
static gint ett_lte_rrc_BCCH_DL_SCH_Message_BR = -1;
static gint ett_lte_rrc_BCCH_DL_SCH_MessageType_BR_r13 = -1;
static gint ett_lte_rrc_T_c1_08 = -1;
static gint ett_lte_rrc_T_messageClassExtension_01 = -1;
static gint ett_lte_rrc_BCCH_DL_SCH_Message_MBMS = -1;
static gint ett_lte_rrc_BCCH_DL_SCH_MessageType_MBMS_r14 = -1;
static gint ett_lte_rrc_T_c1_09 = -1;
static gint ett_lte_rrc_T_messageClassExtension_02 = -1;
static gint ett_lte_rrc_MCCH_Message = -1;
static gint ett_lte_rrc_MCCH_MessageType = -1;
static gint ett_lte_rrc_T_c1_10 = -1;
static gint ett_lte_rrc_T_later = -1;
static gint ett_lte_rrc_T_c2 = -1;
static gint ett_lte_rrc_T_messageClassExtension_03 = -1;
static gint ett_lte_rrc_PCCH_Message = -1;
static gint ett_lte_rrc_PCCH_MessageType = -1;
static gint ett_lte_rrc_T_c1_11 = -1;
static gint ett_lte_rrc_T_messageClassExtension_04 = -1;
static gint ett_lte_rrc_DL_CCCH_Message = -1;
static gint ett_lte_rrc_DL_CCCH_MessageType = -1;
static gint ett_lte_rrc_T_c1_12 = -1;
static gint ett_lte_rrc_T_messageClassExtension_05 = -1;
static gint ett_lte_rrc_T_c2_01 = -1;
static gint ett_lte_rrc_T_messageClassExtensionFuture_r15 = -1;
static gint ett_lte_rrc_DL_DCCH_Message = -1;
static gint ett_lte_rrc_DL_DCCH_MessageType = -1;
static gint ett_lte_rrc_T_c1_13 = -1;
static gint ett_lte_rrc_T_messageClassExtension_06 = -1;
static gint ett_lte_rrc_UL_CCCH_Message = -1;
static gint ett_lte_rrc_UL_CCCH_MessageType = -1;
static gint ett_lte_rrc_T_c1_14 = -1;
static gint ett_lte_rrc_T_messageClassExtension_07 = -1;
static gint ett_lte_rrc_T_c2_02 = -1;
static gint ett_lte_rrc_T_messageClassExtensionFuture_r13 = -1;
static gint ett_lte_rrc_T_c3 = -1;
static gint ett_lte_rrc_T_messageClassExtensionFuture_r15_01 = -1;
static gint ett_lte_rrc_UL_DCCH_Message = -1;
static gint ett_lte_rrc_UL_DCCH_MessageType = -1;
static gint ett_lte_rrc_T_c1_15 = -1;
static gint ett_lte_rrc_T_messageClassExtension_08 = -1;
static gint ett_lte_rrc_T_c2_03 = -1;
static gint ett_lte_rrc_T_messageClassExtensionFuture_r11 = -1;
static gint ett_lte_rrc_SC_MCCH_Message_r13 = -1;
static gint ett_lte_rrc_SC_MCCH_MessageType_r13 = -1;
static gint ett_lte_rrc_T_c1_16 = -1;
static gint ett_lte_rrc_T_messageClassExtension_09 = -1;
static gint ett_lte_rrc_T_c2_04 = -1;
static gint ett_lte_rrc_T_messageClassExtensionFuture_r14 = -1;
static gint ett_lte_rrc_CounterCheck = -1;
static gint ett_lte_rrc_T_criticalExtensions_07 = -1;
static gint ett_lte_rrc_T_c1_17 = -1;
static gint ett_lte_rrc_T_criticalExtensionsFuture_07 = -1;
static gint ett_lte_rrc_CounterCheck_r8_IEs = -1;
static gint ett_lte_rrc_CounterCheck_v8a0_IEs = -1;
static gint ett_lte_rrc_CounterCheck_v1530_IEs = -1;
static gint ett_lte_rrc_T_nonCriticalExtension_09 = -1;
static gint ett_lte_rrc_DRB_CountMSB_InfoList = -1;
static gint ett_lte_rrc_DRB_CountMSB_InfoListExt_r15 = -1;
static gint ett_lte_rrc_DRB_CountMSB_Info = -1;
static gint ett_lte_rrc_CounterCheckResponse = -1;
static gint ett_lte_rrc_T_criticalExtensions_08 = -1;
static gint ett_lte_rrc_T_criticalExtensionsFuture_08 = -1;
static gint ett_lte_rrc_CounterCheckResponse_r8_IEs = -1;
static gint ett_lte_rrc_CounterCheckResponse_v8a0_IEs = -1;
static gint ett_lte_rrc_CounterCheckResponse_v1530_IEs = -1;
static gint ett_lte_rrc_T_nonCriticalExtension_10 = -1;
static gint ett_lte_rrc_DRB_CountInfoList = -1;
static gint ett_lte_rrc_DRB_CountInfoListExt_r15 = -1;
static gint ett_lte_rrc_DRB_CountInfo = -1;
static gint ett_lte_rrc_CSFBParametersRequestCDMA2000 = -1;
static gint ett_lte_rrc_T_criticalExtensions_09 = -1;
static gint ett_lte_rrc_T_criticalExtensionsFuture_09 = -1;
static gint ett_lte_rrc_CSFBParametersRequestCDMA2000_r8_IEs = -1;
static gint ett_lte_rrc_CSFBParametersRequestCDMA2000_v8a0_IEs = -1;
static gint ett_lte_rrc_T_nonCriticalExtension_11 = -1;
static gint ett_lte_rrc_CSFBParametersResponseCDMA2000 = -1;
static gint ett_lte_rrc_T_criticalExtensions_10 = -1;
static gint ett_lte_rrc_T_criticalExtensionsFuture_10 = -1;
static gint ett_lte_rrc_CSFBParametersResponseCDMA2000_r8_IEs = -1;
static gint ett_lte_rrc_CSFBParametersResponseCDMA2000_v8a0_IEs = -1;
static gint ett_lte_rrc_T_nonCriticalExtension_12 = -1;
static gint ett_lte_rrc_DLInformationTransfer = -1;
static gint ett_lte_rrc_T_criticalExtensions_11 = -1;
static gint ett_lte_rrc_T_c1_18 = -1;
static gint ett_lte_rrc_T_criticalExtensionsFuture_11 = -1;
static gint ett_lte_rrc_DLInformationTransfer_r8_IEs = -1;
static gint ett_lte_rrc_T_dedicatedInfoType = -1;
static gint ett_lte_rrc_DLInformationTransfer_v8a0_IEs = -1;
static gint ett_lte_rrc_T_nonCriticalExtension_13 = -1;
static gint ett_lte_rrc_DLInformationTransfer_r15_IEs = -1;
static gint ett_lte_rrc_T_dedicatedInfoType_r15 = -1;
static gint ett_lte_rrc_FailureInformation_r15 = -1;
static gint ett_lte_rrc_FailedLogicalChannelInfo_r15 = -1;
static gint ett_lte_rrc_T_failedLogicalChannelIdentity_r15 = -1;
static gint ett_lte_rrc_HandoverFromEUTRAPreparationRequest = -1;
static gint ett_lte_rrc_T_criticalExtensions_12 = -1;
static gint ett_lte_rrc_T_c1_19 = -1;
static gint ett_lte_rrc_T_criticalExtensionsFuture_12 = -1;
static gint ett_lte_rrc_HandoverFromEUTRAPreparationRequest_r8_IEs = -1;
static gint ett_lte_rrc_HandoverFromEUTRAPreparationRequest_v890_IEs = -1;
static gint ett_lte_rrc_HandoverFromEUTRAPreparationRequest_v920_IEs = -1;
static gint ett_lte_rrc_HandoverFromEUTRAPreparationRequest_v1020_IEs = -1;
static gint ett_lte_rrc_T_nonCriticalExtension_14 = -1;
static gint ett_lte_rrc_InDeviceCoexIndication_r11 = -1;
static gint ett_lte_rrc_T_criticalExtensions_13 = -1;
static gint ett_lte_rrc_T_c1_20 = -1;
static gint ett_lte_rrc_T_criticalExtensionsFuture_13 = -1;
static gint ett_lte_rrc_InDeviceCoexIndication_r11_IEs = -1;
static gint ett_lte_rrc_InDeviceCoexIndication_v11d0_IEs = -1;
static gint ett_lte_rrc_T_ul_CA_AssistanceInfo_r11 = -1;
static gint ett_lte_rrc_InDeviceCoexIndication_v1310_IEs = -1;
static gint ett_lte_rrc_InDeviceCoexIndication_v1360_IEs = -1;
static gint ett_lte_rrc_InDeviceCoexIndication_v1530_IEs = -1;
static gint ett_lte_rrc_T_nonCriticalExtension_15 = -1;
static gint ett_lte_rrc_AffectedCarrierFreqList_r11 = -1;
static gint ett_lte_rrc_AffectedCarrierFreqList_v1310 = -1;
static gint ett_lte_rrc_AffectedCarrierFreq_r11 = -1;
static gint ett_lte_rrc_AffectedCarrierFreq_v1310 = -1;
static gint ett_lte_rrc_AffectedCarrierFreqCombList_r11 = -1;
static gint ett_lte_rrc_AffectedCarrierFreqCombList_r13 = -1;
static gint ett_lte_rrc_AffectedCarrierFreqComb_r11 = -1;
static gint ett_lte_rrc_AffectedCarrierFreqComb_r13 = -1;
static gint ett_lte_rrc_TDM_AssistanceInfo_r11 = -1;
static gint ett_lte_rrc_T_drx_AssistanceInfo_r11 = -1;
static gint ett_lte_rrc_IDC_SubframePatternList_r11 = -1;
static gint ett_lte_rrc_IDC_SubframePattern_r11 = -1;
static gint ett_lte_rrc_T_subframePatternTDD_r11 = -1;
static gint ett_lte_rrc_VictimSystemType_r11 = -1;
static gint ett_lte_rrc_MRDC_AssistanceInfo_r15 = -1;
static gint ett_lte_rrc_SEQUENCE_SIZE_1_maxCombIDC_r11_OF_AffectedCarrierFreqCombInfoMRDC_r15 = -1;
static gint ett_lte_rrc_AffectedCarrierFreqCombInfoMRDC_r15 = -1;
static gint ett_lte_rrc_T_affectedCarrierFreqCombMRDC_r15 = -1;
static gint ett_lte_rrc_AffectedCarrierFreqComb_r15 = -1;
static gint ett_lte_rrc_AffectedCarrierFreqCombNR_r15 = -1;
static gint ett_lte_rrc_InterFreqRSTDMeasurementIndication_r10 = -1;
static gint ett_lte_rrc_T_criticalExtensions_14 = -1;
static gint ett_lte_rrc_T_c1_21 = -1;
static gint ett_lte_rrc_T_criticalExtensionsFuture_14 = -1;
static gint ett_lte_rrc_InterFreqRSTDMeasurementIndication_r10_IEs = -1;
static gint ett_lte_rrc_T_rstd_InterFreqIndication_r10 = -1;
static gint ett_lte_rrc_T_start = -1;
static gint ett_lte_rrc_T_nonCriticalExtension_16 = -1;
static gint ett_lte_rrc_RSTD_InterFreqInfoList_r10 = -1;
static gint ett_lte_rrc_RSTD_InterFreqInfo_r10 = -1;
static gint ett_lte_rrc_T_measPRS_Offset_r15 = -1;
static gint ett_lte_rrc_LoggedMeasurementConfiguration_r10 = -1;
static gint ett_lte_rrc_T_criticalExtensions_15 = -1;
static gint ett_lte_rrc_T_c1_22 = -1;
static gint ett_lte_rrc_T_criticalExtensionsFuture_15 = -1;
static gint ett_lte_rrc_LoggedMeasurementConfiguration_r10_IEs = -1;
static gint ett_lte_rrc_LoggedMeasurementConfiguration_v1080_IEs = -1;
static gint ett_lte_rrc_LoggedMeasurementConfiguration_v1130_IEs = -1;
static gint ett_lte_rrc_LoggedMeasurementConfiguration_v1250_IEs = -1;
static gint ett_lte_rrc_LoggedMeasurementConfiguration_v1530_IEs = -1;
static gint ett_lte_rrc_T_nonCriticalExtension_17 = -1;
static gint ett_lte_rrc_TargetMBSFN_AreaList_r12 = -1;
static gint ett_lte_rrc_TargetMBSFN_Area_r12 = -1;
static gint ett_lte_rrc_MasterInformationBlock = -1;
static gint ett_lte_rrc_MasterInformationBlock_MBMS_r14 = -1;
static gint ett_lte_rrc_MBMSCountingRequest_r10 = -1;
static gint ett_lte_rrc_T_nonCriticalExtension_18 = -1;
static gint ett_lte_rrc_CountingRequestList_r10 = -1;
static gint ett_lte_rrc_CountingRequestInfo_r10 = -1;
static gint ett_lte_rrc_MBMSCountingResponse_r10 = -1;
static gint ett_lte_rrc_T_criticalExtensions_16 = -1;
static gint ett_lte_rrc_T_c1_23 = -1;
static gint ett_lte_rrc_T_criticalExtensionsFuture_16 = -1;
static gint ett_lte_rrc_MBMSCountingResponse_r10_IEs = -1;
static gint ett_lte_rrc_T_nonCriticalExtension_19 = -1;
static gint ett_lte_rrc_CountingResponseList_r10 = -1;
static gint ett_lte_rrc_CountingResponseInfo_r10 = -1;
static gint ett_lte_rrc_MBMSInterestIndication_r11 = -1;
static gint ett_lte_rrc_T_criticalExtensions_17 = -1;
static gint ett_lte_rrc_T_c1_24 = -1;
static gint ett_lte_rrc_T_criticalExtensionsFuture_17 = -1;
static gint ett_lte_rrc_MBMSInterestIndication_r11_IEs = -1;
static gint ett_lte_rrc_MBMSInterestIndication_v1310_IEs = -1;
static gint ett_lte_rrc_MBMSInterestIndication_v1540_IEs = -1;
static gint ett_lte_rrc_SEQUENCE_SIZE_1_maxMBMS_ServiceListPerUE_r13_OF_MBMS_ROM_Info_r15 = -1;
static gint ett_lte_rrc_T_nonCriticalExtension_20 = -1;
static gint ett_lte_rrc_MBMS_ROM_Info_r15 = -1;
static gint ett_lte_rrc_MBSFNAreaConfiguration_r9 = -1;
static gint ett_lte_rrc_MBSFNAreaConfiguration_v930_IEs = -1;
static gint ett_lte_rrc_MBSFNAreaConfiguration_v1250_IEs = -1;
static gint ett_lte_rrc_MBSFNAreaConfiguration_v1430_IEs = -1;
static gint ett_lte_rrc_T_nonCriticalExtension_21 = -1;
static gint ett_lte_rrc_CommonSF_AllocPatternList_r9 = -1;
static gint ett_lte_rrc_CommonSF_AllocPatternList_r14 = -1;
static gint ett_lte_rrc_MeasReportAppLayer_r15 = -1;
static gint ett_lte_rrc_T_criticalExtensions_18 = -1;
static gint ett_lte_rrc_T_criticalExtensionsFuture_18 = -1;
static gint ett_lte_rrc_MeasReportAppLayer_r15_IEs = -1;
static gint ett_lte_rrc_T_nonCriticalExtension_22 = -1;
static gint ett_lte_rrc_MeasurementReport = -1;
static gint ett_lte_rrc_T_criticalExtensions_19 = -1;
static gint ett_lte_rrc_T_c1_25 = -1;
static gint ett_lte_rrc_T_criticalExtensionsFuture_19 = -1;
static gint ett_lte_rrc_MeasurementReport_r8_IEs = -1;
static gint ett_lte_rrc_MeasurementReport_v8a0_IEs = -1;
static gint ett_lte_rrc_T_nonCriticalExtension_23 = -1;
static gint ett_lte_rrc_MobilityFromEUTRACommand = -1;
static gint ett_lte_rrc_T_criticalExtensions_20 = -1;
static gint ett_lte_rrc_T_c1_26 = -1;
static gint ett_lte_rrc_T_criticalExtensionsFuture_20 = -1;
static gint ett_lte_rrc_MobilityFromEUTRACommand_r8_IEs = -1;
static gint ett_lte_rrc_T_purpose = -1;
static gint ett_lte_rrc_MobilityFromEUTRACommand_v8a0_IEs = -1;
static gint ett_lte_rrc_MobilityFromEUTRACommand_v8d0_IEs = -1;
static gint ett_lte_rrc_T_nonCriticalExtension_24 = -1;
static gint ett_lte_rrc_MobilityFromEUTRACommand_r9_IEs = -1;
static gint ett_lte_rrc_T_purpose_01 = -1;
static gint ett_lte_rrc_MobilityFromEUTRACommand_v930_IEs = -1;
static gint ett_lte_rrc_MobilityFromEUTRACommand_v960_IEs = -1;
static gint ett_lte_rrc_MobilityFromEUTRACommand_v1530_IEs = -1;
static gint ett_lte_rrc_T_nonCriticalExtension_25 = -1;
static gint ett_lte_rrc_Handover = -1;
static gint ett_lte_rrc_CellChangeOrder = -1;
static gint ett_lte_rrc_T_targetRAT_Type_01 = -1;
static gint ett_lte_rrc_T_geran = -1;
static gint ett_lte_rrc_SI_OrPSI_GERAN = -1;
static gint ett_lte_rrc_E_CSFB_r9 = -1;
static gint ett_lte_rrc_Paging = -1;
static gint ett_lte_rrc_Paging_v890_IEs = -1;
static gint ett_lte_rrc_Paging_v920_IEs = -1;
static gint ett_lte_rrc_Paging_v1130_IEs = -1;
static gint ett_lte_rrc_Paging_v1310_IEs = -1;
static gint ett_lte_rrc_Paging_v1530_IEs = -1;
static gint ett_lte_rrc_T_nonCriticalExtension_26 = -1;
static gint ett_lte_rrc_PagingRecordList = -1;
static gint ett_lte_rrc_PagingRecord = -1;
static gint ett_lte_rrc_PagingUE_Identity = -1;
static gint ett_lte_rrc_IMSI = -1;
static gint ett_lte_rrc_ProximityIndication_r9 = -1;
static gint ett_lte_rrc_T_criticalExtensions_21 = -1;
static gint ett_lte_rrc_T_c1_27 = -1;
static gint ett_lte_rrc_T_criticalExtensionsFuture_21 = -1;
static gint ett_lte_rrc_ProximityIndication_r9_IEs = -1;
static gint ett_lte_rrc_T_carrierFreq_r9 = -1;
static gint ett_lte_rrc_ProximityIndication_v930_IEs = -1;
static gint ett_lte_rrc_T_nonCriticalExtension_27 = -1;
static gint ett_lte_rrc_RNReconfiguration_r10 = -1;
static gint ett_lte_rrc_T_criticalExtensions_22 = -1;
static gint ett_lte_rrc_T_c1_28 = -1;
static gint ett_lte_rrc_T_criticalExtensionsFuture_22 = -1;
static gint ett_lte_rrc_RNReconfiguration_r10_IEs = -1;
static gint ett_lte_rrc_T_nonCriticalExtension_28 = -1;
static gint ett_lte_rrc_RN_SystemInfo_r10 = -1;
static gint ett_lte_rrc_RNReconfigurationComplete_r10 = -1;
static gint ett_lte_rrc_T_criticalExtensions_23 = -1;
static gint ett_lte_rrc_T_c1_29 = -1;
static gint ett_lte_rrc_T_criticalExtensionsFuture_23 = -1;
static gint ett_lte_rrc_RNReconfigurationComplete_r10_IEs = -1;
static gint ett_lte_rrc_T_nonCriticalExtension_29 = -1;
static gint ett_lte_rrc_RRCConnectionReconfiguration = -1;
static gint ett_lte_rrc_T_criticalExtensions_24 = -1;
static gint ett_lte_rrc_T_c1_30 = -1;
static gint ett_lte_rrc_T_criticalExtensionsFuture_24 = -1;
static gint ett_lte_rrc_RRCConnectionReconfiguration_r8_IEs = -1;
static gint ett_lte_rrc_SEQUENCE_SIZE_1_maxDRB_OF_DedicatedInfoNAS = -1;
static gint ett_lte_rrc_RRCConnectionReconfiguration_v890_IEs = -1;
static gint ett_lte_rrc_RRCConnectionReconfiguration_v8m0_IEs = -1;
static gint ett_lte_rrc_RRCConnectionReconfiguration_v10i0_IEs = -1;
static gint ett_lte_rrc_RRCConnectionReconfiguration_v10l0_IEs = -1;
static gint ett_lte_rrc_RRCConnectionReconfiguration_v12f0_IEs = -1;
static gint ett_lte_rrc_RRCConnectionReconfiguration_v1370_IEs = -1;
static gint ett_lte_rrc_RRCConnectionReconfiguration_v13c0_IEs = -1;
static gint ett_lte_rrc_T_nonCriticalExtension_30 = -1;
static gint ett_lte_rrc_RRCConnectionReconfiguration_v920_IEs = -1;
static gint ett_lte_rrc_RRCConnectionReconfiguration_v1020_IEs = -1;
static gint ett_lte_rrc_RRCConnectionReconfiguration_v1130_IEs = -1;
static gint ett_lte_rrc_RRCConnectionReconfiguration_v1250_IEs = -1;
static gint ett_lte_rrc_T_wlan_OffloadInfo_r12 = -1;
static gint ett_lte_rrc_T_setup = -1;
static gint ett_lte_rrc_RRCConnectionReconfiguration_v1310_IEs = -1;
static gint ett_lte_rrc_RRCConnectionReconfiguration_v1430_IEs = -1;
static gint ett_lte_rrc_RRCConnectionReconfiguration_v1510_IEs = -1;
static gint ett_lte_rrc_T_nr_Config_r15 = -1;
static gint ett_lte_rrc_T_setup_01 = -1;
static gint ett_lte_rrc_RRCConnectionReconfiguration_v1530_IEs = -1;
static gint ett_lte_rrc_SEQUENCE_SIZE_1_maxDRB_r15_OF_DedicatedInfoNAS = -1;
static gint ett_lte_rrc_T_nonCriticalExtension_31 = -1;
static gint ett_lte_rrc_SL_SyncTxControl_r12 = -1;
static gint ett_lte_rrc_PSCellToAddMod_r12 = -1;
static gint ett_lte_rrc_T_cellIdentification_r12_01 = -1;
static gint ett_lte_rrc_PSCellToAddMod_v12f0 = -1;
static gint ett_lte_rrc_PSCellToAddMod_v1440 = -1;
static gint ett_lte_rrc_PowerCoordinationInfo_r12 = -1;
static gint ett_lte_rrc_SCellToAddModList_r10 = -1;
static gint ett_lte_rrc_SCellToAddModList_v10l0 = -1;
static gint ett_lte_rrc_SCellToAddModList_v13c0 = -1;
static gint ett_lte_rrc_SCellToAddModListExt_r13 = -1;
static gint ett_lte_rrc_SCellToAddModListExt_v1370 = -1;
static gint ett_lte_rrc_SCellToAddModListExt_v13c0 = -1;
static gint ett_lte_rrc_SCellToAddModListExt_v1430 = -1;
static gint ett_lte_rrc_SCellGroupToAddModList_r15 = -1;
static gint ett_lte_rrc_SCellToAddMod_r10 = -1;
static gint ett_lte_rrc_T_cellIdentification_r10 = -1;
static gint ett_lte_rrc_SCellToAddMod_v10l0 = -1;
static gint ett_lte_rrc_SCellToAddMod_v13c0 = -1;
static gint ett_lte_rrc_SCellToAddModExt_r13 = -1;
static gint ett_lte_rrc_T_cellIdentification_r13 = -1;
static gint ett_lte_rrc_SCellToAddModExt_v1370 = -1;
static gint ett_lte_rrc_SCellToAddModExt_v1430 = -1;
static gint ett_lte_rrc_SCellGroupToAddMod_r15 = -1;
static gint ett_lte_rrc_SCellToReleaseList_r10 = -1;
static gint ett_lte_rrc_SCellToReleaseListExt_r13 = -1;
static gint ett_lte_rrc_SCellGroupToReleaseList_r15 = -1;
static gint ett_lte_rrc_SCellConfigCommon_r15 = -1;
static gint ett_lte_rrc_SCG_Configuration_r12 = -1;
static gint ett_lte_rrc_T_setup_02 = -1;
static gint ett_lte_rrc_T_scg_ConfigPartMCG_r12 = -1;
static gint ett_lte_rrc_SCG_Configuration_v12f0 = -1;
static gint ett_lte_rrc_T_setup_03 = -1;
static gint ett_lte_rrc_SCG_Configuration_v13c0 = -1;
static gint ett_lte_rrc_T_setup_04 = -1;
static gint ett_lte_rrc_SCG_ConfigPartSCG_r12 = -1;
static gint ett_lte_rrc_SCG_ConfigPartSCG_v12f0 = -1;
static gint ett_lte_rrc_SCG_ConfigPartSCG_v13c0 = -1;
static gint ett_lte_rrc_SecurityConfigHO = -1;
static gint ett_lte_rrc_T_handoverType = -1;
static gint ett_lte_rrc_T_intraLTE = -1;
static gint ett_lte_rrc_T_interRAT = -1;
static gint ett_lte_rrc_SecurityConfigHO_v1530 = -1;
static gint ett_lte_rrc_T_handoverType_v1530 = -1;
static gint ett_lte_rrc_T_intra5GC_r15 = -1;
static gint ett_lte_rrc_T_fivegc_ToEPC_r15 = -1;
static gint ett_lte_rrc_T_epc_To5GC_r15 = -1;
static gint ett_lte_rrc_TDM_PatternConfig_r15 = -1;
static gint ett_lte_rrc_T_setup_05 = -1;
static gint ett_lte_rrc_RRCConnectionReconfigurationComplete = -1;
static gint ett_lte_rrc_T_criticalExtensions_25 = -1;
static gint ett_lte_rrc_T_criticalExtensionsFuture_25 = -1;
static gint ett_lte_rrc_RRCConnectionReconfigurationComplete_r8_IEs = -1;
static gint ett_lte_rrc_RRCConnectionReconfigurationComplete_v8a0_IEs = -1;
static gint ett_lte_rrc_RRCConnectionReconfigurationComplete_v1020_IEs = -1;
static gint ett_lte_rrc_RRCConnectionReconfigurationComplete_v1130_IEs = -1;
static gint ett_lte_rrc_RRCConnectionReconfigurationComplete_v1250_IEs = -1;
static gint ett_lte_rrc_RRCConnectionReconfigurationComplete_v1430_IEs = -1;
static gint ett_lte_rrc_RRCConnectionReconfigurationComplete_v1510_IEs = -1;
static gint ett_lte_rrc_RRCConnectionReconfigurationComplete_v1530_IEs = -1;
static gint ett_lte_rrc_T_nonCriticalExtension_32 = -1;
static gint ett_lte_rrc_RRCConnectionReestablishment = -1;
static gint ett_lte_rrc_T_criticalExtensions_26 = -1;
static gint ett_lte_rrc_T_c1_31 = -1;
static gint ett_lte_rrc_T_criticalExtensionsFuture_26 = -1;
static gint ett_lte_rrc_RRCConnectionReestablishment_r8_IEs = -1;
static gint ett_lte_rrc_RRCConnectionReestablishment_v8a0_IEs = -1;
static gint ett_lte_rrc_T_nonCriticalExtension_33 = -1;
static gint ett_lte_rrc_RRCConnectionReestablishmentComplete = -1;
static gint ett_lte_rrc_T_criticalExtensions_27 = -1;
static gint ett_lte_rrc_T_criticalExtensionsFuture_27 = -1;
static gint ett_lte_rrc_RRCConnectionReestablishmentComplete_r8_IEs = -1;
static gint ett_lte_rrc_RRCConnectionReestablishmentComplete_v920_IEs = -1;
static gint ett_lte_rrc_RRCConnectionReestablishmentComplete_v8a0_IEs = -1;
static gint ett_lte_rrc_RRCConnectionReestablishmentComplete_v1020_IEs = -1;
static gint ett_lte_rrc_RRCConnectionReestablishmentComplete_v1130_IEs = -1;
static gint ett_lte_rrc_RRCConnectionReestablishmentComplete_v1250_IEs = -1;
static gint ett_lte_rrc_RRCConnectionReestablishmentComplete_v1530_IEs = -1;
static gint ett_lte_rrc_T_nonCriticalExtension_34 = -1;
static gint ett_lte_rrc_RRCConnectionReestablishmentReject = -1;
static gint ett_lte_rrc_T_criticalExtensions_28 = -1;
static gint ett_lte_rrc_T_criticalExtensionsFuture_28 = -1;
static gint ett_lte_rrc_RRCConnectionReestablishmentReject_r8_IEs = -1;
static gint ett_lte_rrc_RRCConnectionReestablishmentReject_v8a0_IEs = -1;
static gint ett_lte_rrc_T_nonCriticalExtension_35 = -1;
static gint ett_lte_rrc_RRCConnectionReestablishmentRequest = -1;
static gint ett_lte_rrc_T_criticalExtensions_29 = -1;
static gint ett_lte_rrc_T_criticalExtensionsFuture_29 = -1;
static gint ett_lte_rrc_RRCConnectionReestablishmentRequest_r8_IEs = -1;
static gint ett_lte_rrc_ReestabUE_Identity = -1;
static gint ett_lte_rrc_RRCConnectionReject = -1;
static gint ett_lte_rrc_T_criticalExtensions_30 = -1;
static gint ett_lte_rrc_T_c1_32 = -1;
static gint ett_lte_rrc_T_criticalExtensionsFuture_30 = -1;
static gint ett_lte_rrc_RRCConnectionReject_r8_IEs = -1;
static gint ett_lte_rrc_RRCConnectionReject_v8a0_IEs = -1;
static gint ett_lte_rrc_RRCConnectionReject_v1020_IEs = -1;
static gint ett_lte_rrc_RRCConnectionReject_v1130_IEs = -1;
static gint ett_lte_rrc_T_deprioritisationReq_r11 = -1;
static gint ett_lte_rrc_RRCConnectionReject_v1320_IEs = -1;
static gint ett_lte_rrc_T_nonCriticalExtension_36 = -1;
static gint ett_lte_rrc_RRCConnectionRelease = -1;
static gint ett_lte_rrc_T_criticalExtensions_31 = -1;
static gint ett_lte_rrc_T_c1_33 = -1;
static gint ett_lte_rrc_T_criticalExtensionsFuture_31 = -1;
static gint ett_lte_rrc_RRCConnectionRelease_r8_IEs = -1;
static gint ett_lte_rrc_RRCConnectionRelease_v890_IEs = -1;
static gint ett_lte_rrc_RRCConnectionRelease_v9e0_IEs = -1;
static gint ett_lte_rrc_T_nonCriticalExtension_37 = -1;
static gint ett_lte_rrc_RRCConnectionRelease_v920_IEs = -1;
static gint ett_lte_rrc_T_cellInfoList_r9 = -1;
static gint ett_lte_rrc_RRCConnectionRelease_v1020_IEs = -1;
static gint ett_lte_rrc_RRCConnectionRelease_v1320_IEs = -1;
static gint ett_lte_rrc_RRCConnectionRelease_v1530_IEs = -1;
static gint ett_lte_rrc_RRCConnectionRelease_v1540_IEs = -1;
static gint ett_lte_rrc_T_nonCriticalExtension_38 = -1;
static gint ett_lte_rrc_RedirectedCarrierInfo = -1;
static gint ett_lte_rrc_RedirectedCarrierInfo_v9e0 = -1;
static gint ett_lte_rrc_RRC_InactiveConfig_r15 = -1;
static gint ett_lte_rrc_T_nonCriticalExtension_39 = -1;
static gint ett_lte_rrc_RAN_NotificationAreaInfo_r15 = -1;
static gint ett_lte_rrc_PLMN_RAN_AreaCellList_r15 = -1;
static gint ett_lte_rrc_PLMN_RAN_AreaCell_r15 = -1;
static gint ett_lte_rrc_SEQUENCE_SIZE_1_32_OF_CellIdentity = -1;
static gint ett_lte_rrc_PLMN_RAN_AreaConfigList_r15 = -1;
static gint ett_lte_rrc_PLMN_RAN_AreaConfig_r15 = -1;
static gint ett_lte_rrc_SEQUENCE_SIZE_1_16_OF_RAN_AreaConfig_r15 = -1;
static gint ett_lte_rrc_RAN_AreaConfig_r15 = -1;
static gint ett_lte_rrc_SEQUENCE_SIZE_1_32_OF_RAN_AreaCode_r15 = -1;
static gint ett_lte_rrc_CarrierFreqListUTRA_TDD_r10 = -1;
static gint ett_lte_rrc_IdleModeMobilityControlInfo = -1;
static gint ett_lte_rrc_IdleModeMobilityControlInfo_v9e0 = -1;
static gint ett_lte_rrc_SEQUENCE_SIZE_1_maxFreq_OF_FreqPriorityEUTRA_v9e0 = -1;
static gint ett_lte_rrc_FreqPriorityListEUTRA = -1;
static gint ett_lte_rrc_FreqPriorityListExtEUTRA_r12 = -1;
static gint ett_lte_rrc_FreqPriorityListEUTRA_v1310 = -1;
static gint ett_lte_rrc_FreqPriorityListExtEUTRA_v1310 = -1;
static gint ett_lte_rrc_FreqPriorityEUTRA = -1;
static gint ett_lte_rrc_FreqPriorityEUTRA_v9e0 = -1;
static gint ett_lte_rrc_FreqPriorityEUTRA_r12 = -1;
static gint ett_lte_rrc_FreqPriorityEUTRA_v1310 = -1;
static gint ett_lte_rrc_FreqPriorityListNR_r15 = -1;
static gint ett_lte_rrc_FreqPriorityNR_r15 = -1;
static gint ett_lte_rrc_FreqsPriorityListGERAN = -1;
static gint ett_lte_rrc_FreqsPriorityGERAN = -1;
static gint ett_lte_rrc_FreqPriorityListUTRA_FDD = -1;
static gint ett_lte_rrc_FreqPriorityUTRA_FDD = -1;
static gint ett_lte_rrc_FreqPriorityListUTRA_TDD = -1;
static gint ett_lte_rrc_FreqPriorityUTRA_TDD = -1;
static gint ett_lte_rrc_BandClassPriorityListHRPD = -1;
static gint ett_lte_rrc_BandClassPriorityHRPD = -1;
static gint ett_lte_rrc_BandClassPriorityList1XRTT = -1;
static gint ett_lte_rrc_BandClassPriority1XRTT = -1;
static gint ett_lte_rrc_CellInfoListGERAN_r9 = -1;
static gint ett_lte_rrc_CellInfoGERAN_r9 = -1;
static gint ett_lte_rrc_CarrierInfoNR_r15 = -1;
static gint ett_lte_rrc_CellInfoListUTRA_FDD_r9 = -1;
static gint ett_lte_rrc_CellInfoUTRA_FDD_r9 = -1;
static gint ett_lte_rrc_CellInfoListUTRA_TDD_r9 = -1;
static gint ett_lte_rrc_CellInfoUTRA_TDD_r9 = -1;
static gint ett_lte_rrc_CellInfoListUTRA_TDD_r10 = -1;
static gint ett_lte_rrc_CellInfoUTRA_TDD_r10 = -1;
static gint ett_lte_rrc_RRCConnectionRequest = -1;
static gint ett_lte_rrc_T_criticalExtensions_32 = -1;
static gint ett_lte_rrc_RRCConnectionRequest_r8_IEs = -1;
static gint ett_lte_rrc_RRCConnectionRequest_5GC_r15_IEs = -1;
static gint ett_lte_rrc_InitialUE_Identity = -1;
static gint ett_lte_rrc_InitialUE_Identity_5GC = -1;
static gint ett_lte_rrc_RRCConnectionResume_r13 = -1;
static gint ett_lte_rrc_T_criticalExtensions_33 = -1;
static gint ett_lte_rrc_T_c1_34 = -1;
static gint ett_lte_rrc_T_criticalExtensionsFuture_32 = -1;
static gint ett_lte_rrc_RRCConnectionResume_r13_IEs = -1;
static gint ett_lte_rrc_RRCConnectionResume_v1430_IEs = -1;
static gint ett_lte_rrc_RRCConnectionResume_v1510_IEs = -1;
static gint ett_lte_rrc_RRCConnectionResume_v1530_IEs = -1;
static gint ett_lte_rrc_T_nonCriticalExtension_40 = -1;
static gint ett_lte_rrc_RRCConnectionResumeComplete_r13 = -1;
static gint ett_lte_rrc_T_criticalExtensions_34 = -1;
static gint ett_lte_rrc_T_criticalExtensionsFuture_33 = -1;
static gint ett_lte_rrc_RRCConnectionResumeComplete_r13_IEs = -1;
static gint ett_lte_rrc_RRCConnectionResumeComplete_v1530_IEs = -1;
static gint ett_lte_rrc_T_nonCriticalExtension_41 = -1;
static gint ett_lte_rrc_RRCConnectionResumeRequest_r13 = -1;
static gint ett_lte_rrc_T_criticalExtensions_35 = -1;
static gint ett_lte_rrc_RRCConnectionResumeRequest_r13_IEs = -1;
static gint ett_lte_rrc_T_resumeIdentity_r13 = -1;
static gint ett_lte_rrc_RRCConnectionResumeRequest_5GC_r15_IEs = -1;
static gint ett_lte_rrc_T_resumeIdentity_r15 = -1;
static gint ett_lte_rrc_RRCConnectionSetup = -1;
static gint ett_lte_rrc_T_criticalExtensions_36 = -1;
static gint ett_lte_rrc_T_c1_35 = -1;
static gint ett_lte_rrc_T_criticalExtensionsFuture_34 = -1;
static gint ett_lte_rrc_RRCConnectionSetup_r8_IEs = -1;
static gint ett_lte_rrc_RRCConnectionSetup_v8a0_IEs = -1;
static gint ett_lte_rrc_T_nonCriticalExtension_42 = -1;
static gint ett_lte_rrc_RRCConnectionSetupComplete = -1;
static gint ett_lte_rrc_T_criticalExtensions_37 = -1;
static gint ett_lte_rrc_T_c1_36 = -1;
static gint ett_lte_rrc_T_criticalExtensionsFuture_35 = -1;
static gint ett_lte_rrc_RRCConnectionSetupComplete_r8_IEs = -1;
static gint ett_lte_rrc_RRCConnectionSetupComplete_v8a0_IEs = -1;
static gint ett_lte_rrc_RRCConnectionSetupComplete_v1020_IEs = -1;
static gint ett_lte_rrc_RRCConnectionSetupComplete_v1130_IEs = -1;
static gint ett_lte_rrc_RRCConnectionSetupComplete_v1250_IEs = -1;
static gint ett_lte_rrc_RRCConnectionSetupComplete_v1320_IEs = -1;
static gint ett_lte_rrc_RRCConnectionSetupComplete_v1330_IEs = -1;
static gint ett_lte_rrc_RRCConnectionSetupComplete_v1430_IEs = -1;
static gint ett_lte_rrc_RRCConnectionSetupComplete_v1530_IEs = -1;
static gint ett_lte_rrc_SEQUENCE_SIZE_1_maxNrofS_NSSAI_r15_OF_S_NSSAI_r15 = -1;
static gint ett_lte_rrc_T_ng_5G_S_TMSI_Bits_r15 = -1;
static gint ett_lte_rrc_RRCConnectionSetupComplete_v1540_IEs = -1;
static gint ett_lte_rrc_T_nonCriticalExtension_43 = -1;
static gint ett_lte_rrc_RegisteredMME = -1;
static gint ett_lte_rrc_RegisteredAMF_r15 = -1;
static gint ett_lte_rrc_RRCEarlyDataComplete_r15 = -1;
static gint ett_lte_rrc_T_criticalExtensions_38 = -1;
static gint ett_lte_rrc_T_criticalExtensionsFuture_36 = -1;
static gint ett_lte_rrc_RRCEarlyDataComplete_r15_IEs = -1;
static gint ett_lte_rrc_T_nonCriticalExtension_44 = -1;
static gint ett_lte_rrc_RedirectedCarrierInfo_r15_IEs = -1;
static gint ett_lte_rrc_RRCEarlyDataRequest_r15 = -1;
static gint ett_lte_rrc_T_criticalExtensions_39 = -1;
static gint ett_lte_rrc_T_criticalExtensionsFuture_37 = -1;
static gint ett_lte_rrc_RRCEarlyDataRequest_r15_IEs = -1;
static gint ett_lte_rrc_T_nonCriticalExtension_45 = -1;
static gint ett_lte_rrc_SCGFailureInformation_r12 = -1;
static gint ett_lte_rrc_T_criticalExtensions_40 = -1;
static gint ett_lte_rrc_T_c1_37 = -1;
static gint ett_lte_rrc_T_criticalExtensionsFuture_38 = -1;
static gint ett_lte_rrc_SCGFailureInformation_r12_IEs = -1;
static gint ett_lte_rrc_SCGFailureInformation_v12d0a_IEs = -1;
static gint ett_lte_rrc_T_nonCriticalExtension_46 = -1;
static gint ett_lte_rrc_SCGFailureInformation_v12d0b_IEs = -1;
static gint ett_lte_rrc_T_nonCriticalExtension_47 = -1;
static gint ett_lte_rrc_FailureReportSCG_r12 = -1;
static gint ett_lte_rrc_FailureReportSCG_v12d0 = -1;
static gint ett_lte_rrc_SCGFailureInformationNR_r15 = -1;
static gint ett_lte_rrc_T_criticalExtensions_41 = -1;
static gint ett_lte_rrc_T_c1_38 = -1;
static gint ett_lte_rrc_T_criticalExtensionsFuture_39 = -1;
static gint ett_lte_rrc_SCGFailureInformationNR_r15_IEs = -1;
static gint ett_lte_rrc_T_nonCriticalExtension_48 = -1;
static gint ett_lte_rrc_FailureReportSCG_NR_r15 = -1;
static gint ett_lte_rrc_MeasResultFreqListFailNR_r15 = -1;
static gint ett_lte_rrc_MeasResultFreqFailNR_r15 = -1;
static gint ett_lte_rrc_SCPTMConfiguration_r13 = -1;
static gint ett_lte_rrc_SCPTMConfiguration_v1340 = -1;
static gint ett_lte_rrc_T_nonCriticalExtension_49 = -1;
static gint ett_lte_rrc_SCPTMConfiguration_BR_r14 = -1;
static gint ett_lte_rrc_T_nonCriticalExtension_50 = -1;
static gint ett_lte_rrc_SecurityModeCommand = -1;
static gint ett_lte_rrc_T_criticalExtensions_42 = -1;
static gint ett_lte_rrc_T_c1_39 = -1;
static gint ett_lte_rrc_T_criticalExtensionsFuture_40 = -1;
static gint ett_lte_rrc_SecurityModeCommand_r8_IEs = -1;
static gint ett_lte_rrc_SecurityModeCommand_v8a0_IEs = -1;
static gint ett_lte_rrc_T_nonCriticalExtension_51 = -1;
static gint ett_lte_rrc_SecurityConfigSMC = -1;
static gint ett_lte_rrc_SecurityModeComplete = -1;
static gint ett_lte_rrc_T_criticalExtensions_43 = -1;
static gint ett_lte_rrc_T_criticalExtensionsFuture_41 = -1;
static gint ett_lte_rrc_SecurityModeComplete_r8_IEs = -1;
static gint ett_lte_rrc_SecurityModeComplete_v8a0_IEs = -1;
static gint ett_lte_rrc_T_nonCriticalExtension_52 = -1;
static gint ett_lte_rrc_SecurityModeFailure = -1;
static gint ett_lte_rrc_T_criticalExtensions_44 = -1;
static gint ett_lte_rrc_T_criticalExtensionsFuture_42 = -1;
static gint ett_lte_rrc_SecurityModeFailure_r8_IEs = -1;
static gint ett_lte_rrc_SecurityModeFailure_v8a0_IEs = -1;
static gint ett_lte_rrc_T_nonCriticalExtension_53 = -1;
static gint ett_lte_rrc_SidelinkUEInformation_r12 = -1;
static gint ett_lte_rrc_T_criticalExtensions_45 = -1;
static gint ett_lte_rrc_T_c1_40 = -1;
static gint ett_lte_rrc_T_criticalExtensionsFuture_43 = -1;
static gint ett_lte_rrc_SidelinkUEInformation_r12_IEs = -1;
static gint ett_lte_rrc_SidelinkUEInformation_v1310_IEs = -1;
static gint ett_lte_rrc_T_commTxResourceInfoReqRelay_r13 = -1;
static gint ett_lte_rrc_T_discTxResourceReq_v1310 = -1;
static gint ett_lte_rrc_SidelinkUEInformation_v1430_IEs = -1;
static gint ett_lte_rrc_SidelinkUEInformation_v1530_IEs = -1;
static gint ett_lte_rrc_T_nonCriticalExtension_54 = -1;
static gint ett_lte_rrc_SL_CommTxResourceReq_r12 = -1;
static gint ett_lte_rrc_SL_DiscTxResourceReqPerFreqList_r13 = -1;
static gint ett_lte_rrc_SL_DiscTxResourceReq_r13 = -1;
static gint ett_lte_rrc_SL_DestinationInfoList_r12 = -1;
static gint ett_lte_rrc_SL_DiscSysInfoReportFreqList_r13 = -1;
static gint ett_lte_rrc_SL_V2X_CommFreqList_r14 = -1;
static gint ett_lte_rrc_SL_V2X_CommTxFreqList_r14 = -1;
static gint ett_lte_rrc_SL_V2X_CommTxResourceReq_r14 = -1;
static gint ett_lte_rrc_SystemInformation = -1;
static gint ett_lte_rrc_T_criticalExtensions_46 = -1;
static gint ett_lte_rrc_T_criticalExtensionsFuture_r15 = -1;
static gint ett_lte_rrc_T_criticalExtensionsFuture_44 = -1;
static gint ett_lte_rrc_SystemInformation_r8_IEs = -1;
static gint ett_lte_rrc_T_sib_TypeAndInfo = -1;
static gint ett_lte_rrc_T_sib_TypeAndInfo_item = -1;
static gint ett_lte_rrc_SystemInformation_v8a0_IEs = -1;
static gint ett_lte_rrc_T_nonCriticalExtension_55 = -1;
static gint ett_lte_rrc_PosSystemInformation_r15_IEs = -1;
static gint ett_lte_rrc_T_posSIB_TypeAndInfo_r15 = -1;
static gint ett_lte_rrc_T_posSIB_TypeAndInfo_r15_item = -1;
static gint ett_lte_rrc_T_nonCriticalExtension_56 = -1;
static gint ett_lte_rrc_SystemInformationBlockType1 = -1;
static gint ett_lte_rrc_T_cellAccessRelatedInfo = -1;
static gint ett_lte_rrc_T_cellSelectionInfo = -1;
static gint ett_lte_rrc_SystemInformationBlockType1_v890_IEs = -1;
static gint ett_lte_rrc_SystemInformationBlockType1_v8h0_IEs = -1;
static gint ett_lte_rrc_SystemInformationBlockType1_v9e0_IEs = -1;
static gint ett_lte_rrc_SystemInformationBlockType1_v10j0_IEs = -1;
static gint ett_lte_rrc_SystemInformationBlockType1_v10l0_IEs = -1;
static gint ett_lte_rrc_T_nonCriticalExtension_57 = -1;
static gint ett_lte_rrc_SystemInformationBlockType1_v920_IEs = -1;
static gint ett_lte_rrc_SystemInformationBlockType1_v1130_IEs = -1;
static gint ett_lte_rrc_SystemInformationBlockType1_v1250_IEs = -1;
static gint ett_lte_rrc_T_cellAccessRelatedInfo_v1250 = -1;
static gint ett_lte_rrc_SystemInformationBlockType1_v1310_IEs = -1;
static gint ett_lte_rrc_T_bandwidthReducedAccessRelatedInfo_r13 = -1;
static gint ett_lte_rrc_T_fdd_DownlinkOrTddSubframeBitmapBR_r13 = -1;
static gint ett_lte_rrc_SystemInformationBlockType1_v1320_IEs = -1;
static gint ett_lte_rrc_T_freqHoppingParametersDL_r13 = -1;
static gint ett_lte_rrc_T_interval_DLHoppingConfigCommonModeA_r13 = -1;
static gint ett_lte_rrc_T_interval_DLHoppingConfigCommonModeB_r13 = -1;
static gint ett_lte_rrc_SystemInformationBlockType1_v1350_IEs = -1;
static gint ett_lte_rrc_SystemInformationBlockType1_v1360_IEs = -1;
static gint ett_lte_rrc_SystemInformationBlockType1_v1430_IEs = -1;
static gint ett_lte_rrc_SEQUENCE_SIZE_1_maxPLMN_1_r14_OF_CellAccessRelatedInfo_r14 = -1;
static gint ett_lte_rrc_SystemInformationBlockType1_v1450_IEs = -1;
static gint ett_lte_rrc_SystemInformationBlockType1_v1530_IEs = -1;
static gint ett_lte_rrc_T_crs_IntfMitigConfig_r15 = -1;
static gint ett_lte_rrc_T_cellAccessRelatedInfo_5GC_r15 = -1;
static gint ett_lte_rrc_SEQUENCE_SIZE_1_maxPLMN_r11_OF_CellAccessRelatedInfo_5GC_r15 = -1;
static gint ett_lte_rrc_SystemInformationBlockType1_v1540_IEs = -1;
static gint ett_lte_rrc_T_nonCriticalExtension_58 = -1;
static gint ett_lte_rrc_PLMN_IdentityList = -1;
static gint ett_lte_rrc_PLMN_IdentityInfo = -1;
static gint ett_lte_rrc_PLMN_IdentityList_v1530 = -1;
static gint ett_lte_rrc_PLMN_IdentityInfo_v1530 = -1;
static gint ett_lte_rrc_PLMN_IdentityList_r15 = -1;
static gint ett_lte_rrc_PLMN_IdentityInfo_r15 = -1;
static gint ett_lte_rrc_T_plmn_Identity_5GC_r15 = -1;
static gint ett_lte_rrc_SchedulingInfoList = -1;
static gint ett_lte_rrc_SchedulingInfo = -1;
static gint ett_lte_rrc_SchedulingInfoList_BR_r13 = -1;
static gint ett_lte_rrc_SchedulingInfo_BR_r13 = -1;
static gint ett_lte_rrc_SIB_MappingInfo = -1;
static gint ett_lte_rrc_SystemInfoValueTagList_r13 = -1;
static gint ett_lte_rrc_CellSelectionInfo_v920 = -1;
static gint ett_lte_rrc_CellSelectionInfo_v1130 = -1;
static gint ett_lte_rrc_CellSelectionInfo_v1250 = -1;
static gint ett_lte_rrc_CellAccessRelatedInfo_r14 = -1;
static gint ett_lte_rrc_CellAccessRelatedInfo_5GC_r15 = -1;
static gint ett_lte_rrc_CellIdentity_5GC_r15 = -1;
static gint ett_lte_rrc_PosSchedulingInfoList_r15 = -1;
static gint ett_lte_rrc_PosSchedulingInfo_r15 = -1;
static gint ett_lte_rrc_PosSIB_MappingInfo_r15 = -1;
static gint ett_lte_rrc_PosSIB_Type_r15 = -1;
static gint ett_lte_rrc_SystemInformationBlockType1_MBMS_r14 = -1;
static gint ett_lte_rrc_T_cellAccessRelatedInfo_r14 = -1;
static gint ett_lte_rrc_T_nonCriticalExtension_59 = -1;
static gint ett_lte_rrc_PLMN_IdentityList_MBMS_r14 = -1;
static gint ett_lte_rrc_SchedulingInfoList_MBMS_r14 = -1;
static gint ett_lte_rrc_SchedulingInfo_MBMS_r14 = -1;
static gint ett_lte_rrc_SIB_MappingInfo_MBMS_r14 = -1;
static gint ett_lte_rrc_NonMBSFN_SubframeConfig_r14 = -1;
static gint ett_lte_rrc_UEAssistanceInformation_r11 = -1;
static gint ett_lte_rrc_T_criticalExtensions_47 = -1;
static gint ett_lte_rrc_T_c1_41 = -1;
static gint ett_lte_rrc_T_criticalExtensionsFuture_45 = -1;
static gint ett_lte_rrc_UEAssistanceInformation_r11_IEs = -1;
static gint ett_lte_rrc_UEAssistanceInformation_v1430_IEs = -1;
static gint ett_lte_rrc_T_sps_AssistanceInformation_r14 = -1;
static gint ett_lte_rrc_T_rlm_Report_r14 = -1;
static gint ett_lte_rrc_UEAssistanceInformation_v1450_IEs = -1;
static gint ett_lte_rrc_UEAssistanceInformation_v1530_IEs = -1;
static gint ett_lte_rrc_T_sps_AssistanceInformation_v1530 = -1;
static gint ett_lte_rrc_T_nonCriticalExtension_60 = -1;
static gint ett_lte_rrc_BW_Preference_r14 = -1;
static gint ett_lte_rrc_TrafficPatternInfoList_r14 = -1;
static gint ett_lte_rrc_TrafficPatternInfo_r14 = -1;
static gint ett_lte_rrc_TrafficPatternInfoList_v1530 = -1;
static gint ett_lte_rrc_TrafficPatternInfo_v1530 = -1;
static gint ett_lte_rrc_DelayBudgetReport_r14 = -1;
static gint ett_lte_rrc_OverheatingAssistance_r14 = -1;
static gint ett_lte_rrc_T_reducedUE_Category = -1;
static gint ett_lte_rrc_T_reducedMaxCCs = -1;
static gint ett_lte_rrc_UECapabilityEnquiry = -1;
static gint ett_lte_rrc_T_criticalExtensions_48 = -1;
static gint ett_lte_rrc_T_c1_42 = -1;
static gint ett_lte_rrc_T_criticalExtensionsFuture_46 = -1;
static gint ett_lte_rrc_UECapabilityEnquiry_r8_IEs = -1;
static gint ett_lte_rrc_UECapabilityEnquiry_v8a0_IEs = -1;
static gint ett_lte_rrc_UECapabilityEnquiry_v1180_IEs = -1;
static gint ett_lte_rrc_SEQUENCE_SIZE_1_16_OF_FreqBandIndicator_r11 = -1;
static gint ett_lte_rrc_UECapabilityEnquiry_v1310_IEs = -1;
static gint ett_lte_rrc_UECapabilityEnquiry_v1430_IEs = -1;
static gint ett_lte_rrc_UECapabilityEnquiry_v1510_IEs = -1;
static gint ett_lte_rrc_UECapabilityEnquiry_v1530_IEs = -1;
static gint ett_lte_rrc_UECapabilityEnquiry_v1550_IEs = -1;
static gint ett_lte_rrc_UECapabilityEnquiry_v1560_IEs = -1;
static gint ett_lte_rrc_T_nonCriticalExtension_61 = -1;
static gint ett_lte_rrc_UE_CapabilityRequest = -1;
static gint ett_lte_rrc_UECapabilityInformation = -1;
static gint ett_lte_rrc_T_criticalExtensions_49 = -1;
static gint ett_lte_rrc_T_c1_43 = -1;
static gint ett_lte_rrc_T_criticalExtensionsFuture_47 = -1;
static gint ett_lte_rrc_UECapabilityInformation_r8_IEs = -1;
static gint ett_lte_rrc_UECapabilityInformation_v8a0_IEs = -1;
static gint ett_lte_rrc_UECapabilityInformation_v1250_IEs = -1;
static gint ett_lte_rrc_T_nonCriticalExtension_62 = -1;
static gint ett_lte_rrc_UEInformationRequest_r9 = -1;
static gint ett_lte_rrc_T_criticalExtensions_50 = -1;
static gint ett_lte_rrc_T_c1_44 = -1;
static gint ett_lte_rrc_T_criticalExtensionsFuture_48 = -1;
static gint ett_lte_rrc_UEInformationRequest_r9_IEs = -1;
static gint ett_lte_rrc_UEInformationRequest_v930_IEs = -1;
static gint ett_lte_rrc_UEInformationRequest_v1020_IEs = -1;
static gint ett_lte_rrc_UEInformationRequest_v1130_IEs = -1;
static gint ett_lte_rrc_UEInformationRequest_v1250_IEs = -1;
static gint ett_lte_rrc_UEInformationRequest_v1530_IEs = -1;
static gint ett_lte_rrc_T_nonCriticalExtension_63 = -1;
static gint ett_lte_rrc_UEInformationResponse_r9 = -1;
static gint ett_lte_rrc_T_criticalExtensions_51 = -1;
static gint ett_lte_rrc_T_c1_45 = -1;
static gint ett_lte_rrc_T_criticalExtensionsFuture_49 = -1;
static gint ett_lte_rrc_UEInformationResponse_r9_IEs = -1;
static gint ett_lte_rrc_T_rach_Report_r9 = -1;
static gint ett_lte_rrc_UEInformationResponse_v9e0_IEs = -1;
static gint ett_lte_rrc_T_nonCriticalExtension_64 = -1;
static gint ett_lte_rrc_UEInformationResponse_v930_IEs = -1;
static gint ett_lte_rrc_UEInformationResponse_v1020_IEs = -1;
static gint ett_lte_rrc_UEInformationResponse_v1130_IEs = -1;
static gint ett_lte_rrc_UEInformationResponse_v1250_IEs = -1;
static gint ett_lte_rrc_UEInformationResponse_v1530_IEs = -1;
static gint ett_lte_rrc_T_nonCriticalExtension_65 = -1;
static gint ett_lte_rrc_RLF_Report_r9 = -1;
static gint ett_lte_rrc_T_measResultLastServCell_r9 = -1;
static gint ett_lte_rrc_T_measResultNeighCells_r9 = -1;
static gint ett_lte_rrc_T_failedPCellId_r10 = -1;
static gint ett_lte_rrc_T_pci_arfcn_r10 = -1;
static gint ett_lte_rrc_T_failedPCellId_v1090 = -1;
static gint ett_lte_rrc_T_basicFields_r11 = -1;
static gint ett_lte_rrc_T_previousUTRA_CellId_r11 = -1;
static gint ett_lte_rrc_T_physCellId_r11 = -1;
static gint ett_lte_rrc_T_selectedUTRA_CellId_r11 = -1;
static gint ett_lte_rrc_T_physCellId_r11_01 = -1;
static gint ett_lte_rrc_T_failedPCellId_v1250 = -1;
static gint ett_lte_rrc_RLF_Report_v9e0 = -1;
static gint ett_lte_rrc_MeasResultList2EUTRA_r9 = -1;
static gint ett_lte_rrc_MeasResultList2EUTRA_v9e0 = -1;
static gint ett_lte_rrc_MeasResultList2EUTRA_v1250 = -1;
static gint ett_lte_rrc_MeasResult2EUTRA_r9 = -1;
static gint ett_lte_rrc_MeasResult2EUTRA_v9e0 = -1;
static gint ett_lte_rrc_MeasResult2EUTRA_v1250 = -1;
static gint ett_lte_rrc_MeasResultList2UTRA_r9 = -1;
static gint ett_lte_rrc_MeasResult2UTRA_r9 = -1;
static gint ett_lte_rrc_MeasResultList2CDMA2000_r9 = -1;
static gint ett_lte_rrc_MeasResult2CDMA2000_r9 = -1;
static gint ett_lte_rrc_LogMeasReport_r10 = -1;
static gint ett_lte_rrc_LogMeasInfoList_r10 = -1;
static gint ett_lte_rrc_LogMeasInfo_r10 = -1;
static gint ett_lte_rrc_T_measResultServCell_r10 = -1;
static gint ett_lte_rrc_T_measResultNeighCells_r10 = -1;
static gint ett_lte_rrc_MeasResultListMBSFN_r12 = -1;
static gint ett_lte_rrc_MeasResultMBSFN_r12 = -1;
static gint ett_lte_rrc_T_mbsfn_Area_r12 = -1;
static gint ett_lte_rrc_DataBLER_MCH_ResultList_r12 = -1;
static gint ett_lte_rrc_DataBLER_MCH_Result_r12 = -1;
static gint ett_lte_rrc_BLER_Result_r12 = -1;
static gint ett_lte_rrc_T_blocksReceived_r12 = -1;
static gint ett_lte_rrc_MeasResultList2GERAN_r10 = -1;
static gint ett_lte_rrc_ConnEstFailReport_r11 = -1;
static gint ett_lte_rrc_T_measResultFailedCell_r11 = -1;
static gint ett_lte_rrc_T_measResultNeighCells_r11 = -1;
static gint ett_lte_rrc_FlightPathInfoReport_r15 = -1;
static gint ett_lte_rrc_SEQUENCE_SIZE_1_maxWayPoint_r15_OF_WayPointLocation_r15 = -1;
static gint ett_lte_rrc_T_nonCriticalExtension_66 = -1;
static gint ett_lte_rrc_WayPointLocation_r15 = -1;
static gint ett_lte_rrc_ULHandoverPreparationTransfer = -1;
static gint ett_lte_rrc_T_criticalExtensions_52 = -1;
static gint ett_lte_rrc_T_c1_46 = -1;
static gint ett_lte_rrc_T_criticalExtensionsFuture_50 = -1;
static gint ett_lte_rrc_ULHandoverPreparationTransfer_r8_IEs = -1;
static gint ett_lte_rrc_ULHandoverPreparationTransfer_v8a0_IEs = -1;
static gint ett_lte_rrc_T_nonCriticalExtension_67 = -1;
static gint ett_lte_rrc_ULInformationTransfer = -1;
static gint ett_lte_rrc_T_criticalExtensions_53 = -1;
static gint ett_lte_rrc_T_c1_47 = -1;
static gint ett_lte_rrc_T_criticalExtensionsFuture_51 = -1;
static gint ett_lte_rrc_ULInformationTransfer_r8_IEs = -1;
static gint ett_lte_rrc_T_dedicatedInfoType_01 = -1;
static gint ett_lte_rrc_ULInformationTransfer_v8a0_IEs = -1;
static gint ett_lte_rrc_T_nonCriticalExtension_68 = -1;
static gint ett_lte_rrc_ULInformationTransferMRDC_r15 = -1;
static gint ett_lte_rrc_T_criticalExtensions_54 = -1;
static gint ett_lte_rrc_T_c1_48 = -1;
static gint ett_lte_rrc_T_criticalExtensionsFuture_52 = -1;
static gint ett_lte_rrc_ULInformationTransferMRDC_r15_IEs = -1;
static gint ett_lte_rrc_T_nonCriticalExtension_69 = -1;
static gint ett_lte_rrc_WLANConnectionStatusReport_r13 = -1;
static gint ett_lte_rrc_T_criticalExtensions_55 = -1;
static gint ett_lte_rrc_T_c1_49 = -1;
static gint ett_lte_rrc_T_criticalExtensionsFuture_53 = -1;
static gint ett_lte_rrc_WLANConnectionStatusReport_r13_IEs = -1;
static gint ett_lte_rrc_WLANConnectionStatusReport_v1430_IEs = -1;
static gint ett_lte_rrc_T_nonCriticalExtension_70 = -1;
static gint ett_lte_rrc_SystemInformationBlockPos_r15 = -1;
static gint ett_lte_rrc_SystemInformationBlockType2 = -1;
static gint ett_lte_rrc_T_ac_BarringInfo = -1;
static gint ett_lte_rrc_T_freqInfo = -1;
static gint ett_lte_rrc_SystemInformationBlockType2_v8h0_IEs = -1;
static gint ett_lte_rrc_SEQUENCE_SIZE_1_maxMultiBands_OF_AdditionalSpectrumEmission = -1;
static gint ett_lte_rrc_SystemInformationBlockType2_v9e0_IEs = -1;
static gint ett_lte_rrc_SystemInformationBlockType2_v9i0_IEs = -1;
static gint ett_lte_rrc_T_dummy = -1;
static gint ett_lte_rrc_SystemInformationBlockType2_v10m0_IEs = -1;
static gint ett_lte_rrc_T_freqInfo_v10l0 = -1;
static gint ett_lte_rrc_SEQUENCE_SIZE_1_maxMultiBands_OF_AdditionalSpectrumEmission_v10l0 = -1;
static gint ett_lte_rrc_SystemInformationBlockType2_v10n0_IEs = -1;
static gint ett_lte_rrc_SystemInformationBlockType2_v13c0_IEs = -1;
static gint ett_lte_rrc_T_nonCriticalExtension_72 = -1;
static gint ett_lte_rrc_AC_BarringConfig = -1;
static gint ett_lte_rrc_MBSFN_SubframeConfigList = -1;
static gint ett_lte_rrc_MBSFN_SubframeConfigList_v1430 = -1;
static gint ett_lte_rrc_AC_BarringPerPLMN_List_r12 = -1;
static gint ett_lte_rrc_AC_BarringPerPLMN_r12 = -1;
static gint ett_lte_rrc_T_ac_BarringInfo_r12 = -1;
static gint ett_lte_rrc_ACDC_BarringForCommon_r13 = -1;
static gint ett_lte_rrc_ACDC_BarringPerPLMN_List_r13 = -1;
static gint ett_lte_rrc_ACDC_BarringPerPLMN_r13 = -1;
static gint ett_lte_rrc_BarringPerACDC_CategoryList_r13 = -1;
static gint ett_lte_rrc_BarringPerACDC_Category_r13 = -1;
static gint ett_lte_rrc_T_acdc_BarringConfig_r13 = -1;
static gint ett_lte_rrc_UDT_Restricting_r13 = -1;
static gint ett_lte_rrc_UDT_RestrictingPerPLMN_List_r13 = -1;
static gint ett_lte_rrc_UDT_RestrictingPerPLMN_r13 = -1;
static gint ett_lte_rrc_CIOT_EPS_OptimisationInfo_r13 = -1;
static gint ett_lte_rrc_CIOT_OptimisationPLMN_r13 = -1;
static gint ett_lte_rrc_PLMN_InfoList_r15 = -1;
static gint ett_lte_rrc_PLMN_Info_r15 = -1;
static gint ett_lte_rrc_SystemInformationBlockType3 = -1;
static gint ett_lte_rrc_T_cellReselectionInfoCommon = -1;
static gint ett_lte_rrc_T_speedStateReselectionPars = -1;
static gint ett_lte_rrc_T_q_HystSF = -1;
static gint ett_lte_rrc_T_cellReselectionServingFreqInfo = -1;
static gint ett_lte_rrc_T_intraFreqCellReselectionInfo = -1;
static gint ett_lte_rrc_T_s_IntraSearch_v920 = -1;
static gint ett_lte_rrc_T_s_NonIntraSearch_v920 = -1;
static gint ett_lte_rrc_RedistributionServingInfo_r13 = -1;
static gint ett_lte_rrc_CellReselectionServingFreqInfo_v1310 = -1;
static gint ett_lte_rrc_SystemInformationBlockType3_v10j0_IEs = -1;
static gint ett_lte_rrc_SystemInformationBlockType3_v10l0_IEs = -1;
static gint ett_lte_rrc_T_nonCriticalExtension_73 = -1;
static gint ett_lte_rrc_CellReselectionInfoCommon_v1460 = -1;
static gint ett_lte_rrc_CellReselectionInfoHSDN_r15 = -1;
static gint ett_lte_rrc_SystemInformationBlockType4 = -1;
static gint ett_lte_rrc_IntraFreqNeighCellList = -1;
static gint ett_lte_rrc_IntraFreqNeighHSDN_CellList_r15 = -1;
static gint ett_lte_rrc_IntraFreqNeighCellInfo = -1;
static gint ett_lte_rrc_IntraFreqBlackCellList = -1;
static gint ett_lte_rrc_SystemInformationBlockType5 = -1;
static gint ett_lte_rrc_SystemInformationBlockType5_v8h0_IEs = -1;
static gint ett_lte_rrc_SEQUENCE_SIZE_1_maxFreq_OF_InterFreqCarrierFreqInfo_v8h0 = -1;
static gint ett_lte_rrc_SystemInformationBlockType5_v9e0_IEs = -1;
static gint ett_lte_rrc_SEQUENCE_SIZE_1_maxFreq_OF_InterFreqCarrierFreqInfo_v9e0 = -1;
static gint ett_lte_rrc_SystemInformationBlockType5_v10j0_IEs = -1;
static gint ett_lte_rrc_SEQUENCE_SIZE_1_maxFreq_OF_InterFreqCarrierFreqInfo_v10j0 = -1;
static gint ett_lte_rrc_SystemInformationBlockType5_v10l0_IEs = -1;
static gint ett_lte_rrc_SEQUENCE_SIZE_1_maxFreq_OF_InterFreqCarrierFreqInfo_v10l0 = -1;
static gint ett_lte_rrc_SystemInformationBlockType5_v13a0_IEs = -1;
static gint ett_lte_rrc_T_nonCriticalExtension_74 = -1;
static gint ett_lte_rrc_InterFreqCarrierFreqList = -1;
static gint ett_lte_rrc_InterFreqCarrierFreqList_v1250 = -1;
static gint ett_lte_rrc_InterFreqCarrierFreqList_v1310 = -1;
static gint ett_lte_rrc_InterFreqCarrierFreqList_v1350 = -1;
static gint ett_lte_rrc_InterFreqCarrierFreqList_v13a0 = -1;
static gint ett_lte_rrc_InterFreqCarrierFreqList_v1530 = -1;
static gint ett_lte_rrc_InterFreqCarrierFreqListExt_r12 = -1;
static gint ett_lte_rrc_InterFreqCarrierFreqListExt_v1280 = -1;
static gint ett_lte_rrc_InterFreqCarrierFreqListExt_v1310 = -1;
static gint ett_lte_rrc_InterFreqCarrierFreqListExt_v1350 = -1;
static gint ett_lte_rrc_InterFreqCarrierFreqListExt_v1360 = -1;
static gint ett_lte_rrc_InterFreqCarrierFreqListExt_v1530 = -1;
static gint ett_lte_rrc_InterFreqCarrierFreqInfo = -1;
static gint ett_lte_rrc_T_threshX_Q_r9 = -1;
static gint ett_lte_rrc_InterFreqCarrierFreqInfo_v8h0 = -1;
static gint ett_lte_rrc_InterFreqCarrierFreqInfo_v9e0 = -1;
static gint ett_lte_rrc_InterFreqCarrierFreqInfo_v10j0 = -1;
static gint ett_lte_rrc_InterFreqCarrierFreqInfo_v10l0 = -1;
static gint ett_lte_rrc_InterFreqCarrierFreqInfo_v1250 = -1;
static gint ett_lte_rrc_InterFreqCarrierFreqInfo_r12 = -1;
static gint ett_lte_rrc_T_threshX_Q_r12 = -1;
static gint ett_lte_rrc_InterFreqCarrierFreqInfo_v1310 = -1;
static gint ett_lte_rrc_InterFreqCarrierFreqInfo_v1350 = -1;
static gint ett_lte_rrc_InterFreqCarrierFreqInfo_v1360 = -1;
static gint ett_lte_rrc_InterFreqCarrierFreqInfo_v1530 = -1;
static gint ett_lte_rrc_InterFreqNeighCellList = -1;
static gint ett_lte_rrc_InterFreqNeighHSDN_CellList_r15 = -1;
static gint ett_lte_rrc_InterFreqNeighCellInfo = -1;
static gint ett_lte_rrc_InterFreqBlackCellList = -1;
static gint ett_lte_rrc_RedistributionInterFreqInfo_r13 = -1;
static gint ett_lte_rrc_RedistributionNeighCellList_r13 = -1;
static gint ett_lte_rrc_RedistributionNeighCell_r13 = -1;
static gint ett_lte_rrc_SystemInformationBlockType6 = -1;
static gint ett_lte_rrc_SEQUENCE_SIZE_1_maxUTRA_FDD_Carrier_OF_CarrierFreqInfoUTRA_v1250 = -1;
static gint ett_lte_rrc_SEQUENCE_SIZE_1_maxUTRA_TDD_Carrier_OF_CarrierFreqInfoUTRA_v1250 = -1;
static gint ett_lte_rrc_SystemInformationBlockType6_v8h0_IEs = -1;
static gint ett_lte_rrc_SEQUENCE_SIZE_1_maxUTRA_FDD_Carrier_OF_CarrierFreqInfoUTRA_FDD_v8h0 = -1;
static gint ett_lte_rrc_T_nonCriticalExtension_75 = -1;
static gint ett_lte_rrc_CarrierFreqInfoUTRA_v1250 = -1;
static gint ett_lte_rrc_CarrierFreqListUTRA_FDD = -1;
static gint ett_lte_rrc_CarrierFreqUTRA_FDD = -1;
static gint ett_lte_rrc_T_threshX_Q_r9_01 = -1;
static gint ett_lte_rrc_CarrierFreqInfoUTRA_FDD_v8h0 = -1;
static gint ett_lte_rrc_SEQUENCE_SIZE_1_maxMultiBands_OF_FreqBandIndicator_UTRA_FDD = -1;
static gint ett_lte_rrc_CarrierFreqListUTRA_FDD_Ext_r12 = -1;
static gint ett_lte_rrc_CarrierFreqUTRA_FDD_Ext_r12 = -1;
static gint ett_lte_rrc_T_threshX_Q_r12_01 = -1;
static gint ett_lte_rrc_FreqBandIndicator_UTRA_FDD_r12 = -1;
static gint ett_lte_rrc_CarrierFreqListUTRA_TDD = -1;
static gint ett_lte_rrc_CarrierFreqUTRA_TDD = -1;
static gint ett_lte_rrc_CarrierFreqListUTRA_TDD_Ext_r12 = -1;
static gint ett_lte_rrc_CarrierFreqUTRA_TDD_r12 = -1;
static gint ett_lte_rrc_SystemInformationBlockType7 = -1;
static gint ett_lte_rrc_CarrierFreqsInfoListGERAN = -1;
static gint ett_lte_rrc_CarrierFreqsInfoGERAN = -1;
static gint ett_lte_rrc_T_commonInfo = -1;
static gint ett_lte_rrc_SystemInformationBlockType8 = -1;
static gint ett_lte_rrc_T_parametersHRPD = -1;
static gint ett_lte_rrc_T_parameters1XRTT = -1;
static gint ett_lte_rrc_CellReselectionParametersCDMA2000 = -1;
static gint ett_lte_rrc_CellReselectionParametersCDMA2000_r11 = -1;
static gint ett_lte_rrc_SEQUENCE_SIZE_1_16_OF_NeighCellCDMA2000_r11 = -1;
static gint ett_lte_rrc_CellReselectionParametersCDMA2000_v920 = -1;
static gint ett_lte_rrc_NeighCellListCDMA2000 = -1;
static gint ett_lte_rrc_NeighCellCDMA2000 = -1;
static gint ett_lte_rrc_NeighCellCDMA2000_r11 = -1;
static gint ett_lte_rrc_SEQUENCE_SIZE_1_16_OF_NeighCellsPerBandclassCDMA2000_r11 = -1;
static gint ett_lte_rrc_NeighCellsPerBandclassListCDMA2000 = -1;
static gint ett_lte_rrc_NeighCellsPerBandclassCDMA2000 = -1;
static gint ett_lte_rrc_NeighCellsPerBandclassCDMA2000_r11 = -1;
static gint ett_lte_rrc_SEQUENCE_SIZE_1_40_OF_PhysCellIdCDMA2000 = -1;
static gint ett_lte_rrc_NeighCellListCDMA2000_v920 = -1;
static gint ett_lte_rrc_NeighCellCDMA2000_v920 = -1;
static gint ett_lte_rrc_NeighCellsPerBandclassListCDMA2000_v920 = -1;
static gint ett_lte_rrc_NeighCellsPerBandclassCDMA2000_v920 = -1;
static gint ett_lte_rrc_PhysCellIdListCDMA2000 = -1;
static gint ett_lte_rrc_PhysCellIdListCDMA2000_v920 = -1;
static gint ett_lte_rrc_BandClassListCDMA2000 = -1;
static gint ett_lte_rrc_BandClassInfoCDMA2000 = -1;
static gint ett_lte_rrc_AC_BarringConfig1XRTT_r9 = -1;
static gint ett_lte_rrc_SIB8_PerPLMN_List_r11 = -1;
static gint ett_lte_rrc_SIB8_PerPLMN_r11 = -1;
static gint ett_lte_rrc_T_parametersCDMA2000_r11 = -1;
static gint ett_lte_rrc_ParametersCDMA2000_r11 = -1;
static gint ett_lte_rrc_T_systemTimeInfo_r11 = -1;
static gint ett_lte_rrc_T_parametersHRPD_r11 = -1;
static gint ett_lte_rrc_T_parameters1XRTT_r11 = -1;
static gint ett_lte_rrc_SystemInformationBlockType9 = -1;
static gint ett_lte_rrc_SystemInformationBlockType10 = -1;
static gint ett_lte_rrc_SystemInformationBlockType11 = -1;
static gint ett_lte_rrc_SystemInformationBlockType12_r9 = -1;
static gint ett_lte_rrc_SystemInformationBlockType13_r9 = -1;
static gint ett_lte_rrc_SystemInformationBlockType14_r11 = -1;
static gint ett_lte_rrc_T_eab_Param_r11 = -1;
static gint ett_lte_rrc_SEQUENCE_SIZE_1_maxPLMN_r11_OF_EAB_ConfigPLMN_r11 = -1;
static gint ett_lte_rrc_EAB_ConfigPLMN_r11 = -1;
static gint ett_lte_rrc_EAB_Config_r11 = -1;
static gint ett_lte_rrc_SystemInformationBlockType15_r11 = -1;
static gint ett_lte_rrc_MBMS_SAI_List_r11 = -1;
static gint ett_lte_rrc_MBMS_SAI_InterFreqList_r11 = -1;
static gint ett_lte_rrc_MBMS_SAI_InterFreqList_v1140 = -1;
static gint ett_lte_rrc_MBMS_SAI_InterFreq_r11 = -1;
static gint ett_lte_rrc_MBMS_SAI_InterFreq_v1140 = -1;
static gint ett_lte_rrc_MBMS_InterFreqCarrierTypeList_r14 = -1;
static gint ett_lte_rrc_MBMS_CarrierType_r14 = -1;
static gint ett_lte_rrc_SystemInformationBlockType16_r11 = -1;
static gint ett_lte_rrc_T_timeInfo_r11 = -1;
static gint ett_lte_rrc_SystemInformationBlockType17_r12 = -1;
static gint ett_lte_rrc_SEQUENCE_SIZE_1_maxPLMN_r11_OF_WLAN_OffloadInfoPerPLMN_r12 = -1;
static gint ett_lte_rrc_WLAN_OffloadInfoPerPLMN_r12 = -1;
static gint ett_lte_rrc_WLAN_Id_List_r12 = -1;
static gint ett_lte_rrc_WLAN_Identifiers_r12 = -1;
static gint ett_lte_rrc_SystemInformationBlockType18_r12 = -1;
static gint ett_lte_rrc_T_commConfig_r12 = -1;
static gint ett_lte_rrc_SystemInformationBlockType19_r12 = -1;
static gint ett_lte_rrc_T_discConfig_r12 = -1;
static gint ett_lte_rrc_T_discConfig_v1310 = -1;
static gint ett_lte_rrc_T_discConfigRelay_r13 = -1;
static gint ett_lte_rrc_T_discConfigPS_13 = -1;
static gint ett_lte_rrc_SL_CarrierFreqInfoList_r12 = -1;
static gint ett_lte_rrc_SL_CarrierFreqInfoList_v1310 = -1;
static gint ett_lte_rrc_SL_CarrierFreqInfo_r12 = -1;
static gint ett_lte_rrc_SL_DiscConfigRelayUE_r13 = -1;
static gint ett_lte_rrc_SL_DiscConfigRemoteUE_r13 = -1;
static gint ett_lte_rrc_ReselectionInfoRelay_r13 = -1;
static gint ett_lte_rrc_SL_CarrierFreqInfo_v1310 = -1;
static gint ett_lte_rrc_PLMN_IdentityList4_r12 = -1;
static gint ett_lte_rrc_PLMN_IdentityInfo2_r12 = -1;
static gint ett_lte_rrc_SL_DiscTxResourcesInterFreq_r13 = -1;
static gint ett_lte_rrc_SL_DiscConfigOtherInterFreq_r13 = -1;
static gint ett_lte_rrc_SL_ResourcesInterFreq_r13 = -1;
static gint ett_lte_rrc_SystemInformationBlockType20_r13 = -1;
static gint ett_lte_rrc_T_br_BCCH_Config_r14 = -1;
static gint ett_lte_rrc_T_mpdcch_StartSF_SC_MCCH_r14 = -1;
static gint ett_lte_rrc_SC_MCCH_SchedulingInfo_r14 = -1;
static gint ett_lte_rrc_T_schedulingPeriodStartOffsetSCPTM_r14 = -1;
static gint ett_lte_rrc_SystemInformationBlockType21_r14 = -1;
static gint ett_lte_rrc_SL_V2X_ConfigCommon_r14 = -1;
static gint ett_lte_rrc_SystemInformationBlockType24_r15 = -1;
static gint ett_lte_rrc_CarrierFreqListNR_r15 = -1;
static gint ett_lte_rrc_CarrierFreqNR_r15 = -1;
static gint ett_lte_rrc_T_threshX_Q_r15 = -1;
static gint ett_lte_rrc_MultiBandNsPmaxListNR_1_v1550 = -1;
static gint ett_lte_rrc_MultiBandNsPmaxListNR_v1550 = -1;
static gint ett_lte_rrc_SystemInformationBlockType25_r15 = -1;
static gint ett_lte_rrc_T_uac_AC1_SelectAssistInfo_r15 = -1;
static gint ett_lte_rrc_SEQUENCE_SIZE_2_maxPLMN_r11_OF_UAC_AC1_SelectAssistInfo_r15 = -1;
static gint ett_lte_rrc_UAC_BarringPerPLMN_List_r15 = -1;
static gint ett_lte_rrc_UAC_BarringPerPLMN_r15 = -1;
static gint ett_lte_rrc_T_uac_AC_BarringListType_r15 = -1;
static gint ett_lte_rrc_SEQUENCE_SIZE_maxAccessCat_1_r15_OF_UAC_BarringInfoSetIndex_r15 = -1;
static gint ett_lte_rrc_UAC_BarringPerCatList_r15 = -1;
static gint ett_lte_rrc_UAC_BarringPerCat_r15 = -1;
static gint ett_lte_rrc_UAC_BarringInfoSetList_r15 = -1;
static gint ett_lte_rrc_UAC_BarringInfoSet_r15 = -1;
static gint ett_lte_rrc_SystemInformationBlockType26_r15 = -1;
static gint ett_lte_rrc_AntennaInfoCommon = -1;
static gint ett_lte_rrc_AntennaInfoDedicated = -1;
static gint ett_lte_rrc_T_codebookSubsetRestriction = -1;
static gint ett_lte_rrc_T_ue_TransmitAntennaSelection = -1;
static gint ett_lte_rrc_AntennaInfoDedicated_v920 = -1;
static gint ett_lte_rrc_T_codebookSubsetRestriction_v920 = -1;
static gint ett_lte_rrc_AntennaInfoDedicated_r10 = -1;
static gint ett_lte_rrc_T_ue_TransmitAntennaSelection_01 = -1;
static gint ett_lte_rrc_AntennaInfoDedicated_v10i0 = -1;
static gint ett_lte_rrc_AntennaInfoDedicated_v1250 = -1;
static gint ett_lte_rrc_AntennaInfoDedicated_v1430 = -1;
static gint ett_lte_rrc_AntennaInfoDedicatedSTTI_r15 = -1;
static gint ett_lte_rrc_T_setup_08 = -1;
static gint ett_lte_rrc_T_codebookSubsetRestriction_01 = -1;
static gint ett_lte_rrc_AntennaInfoDedicated_v1530 = -1;
static gint ett_lte_rrc_T_setup_09 = -1;
static gint ett_lte_rrc_AntennaInfoUL_r10 = -1;
static gint ett_lte_rrc_AntennaInfoUL_STTI_r15 = -1;
static gint ett_lte_rrc_AUL_Config_r15 = -1;
static gint ett_lte_rrc_T_setup_10 = -1;
static gint ett_lte_rrc_CQI_ReportAperiodic_r10 = -1;
static gint ett_lte_rrc_T_setup_11 = -1;
static gint ett_lte_rrc_T_aperiodicCSI_Trigger_r10 = -1;
static gint ett_lte_rrc_CQI_ReportAperiodic_v1250 = -1;
static gint ett_lte_rrc_T_setup_12 = -1;
static gint ett_lte_rrc_T_aperiodicCSI_Trigger_v1250 = -1;
static gint ett_lte_rrc_CQI_ReportAperiodic_v1310 = -1;
static gint ett_lte_rrc_T_setup_13 = -1;
static gint ett_lte_rrc_T_aperiodicCSI_Trigger_v1310 = -1;
static gint ett_lte_rrc_T_aperiodicCSI_Trigger2_r13 = -1;
static gint ett_lte_rrc_T_setup_14 = -1;
static gint ett_lte_rrc_CQI_ReportAperiodicProc_r11 = -1;
static gint ett_lte_rrc_CQI_ReportAperiodicProc_v1310 = -1;
static gint ett_lte_rrc_CQI_ReportAperiodicHybrid_r14 = -1;
static gint ett_lte_rrc_T_triggers_r14 = -1;
static gint ett_lte_rrc_T_oneBit_r14 = -1;
static gint ett_lte_rrc_T_twoBit_r14 = -1;
static gint ett_lte_rrc_T_threeBit_r14 = -1;
static gint ett_lte_rrc_CQI_ReportBoth_r11 = -1;
static gint ett_lte_rrc_CQI_ReportBoth_v1250 = -1;
static gint ett_lte_rrc_CQI_ReportBoth_v1310 = -1;
static gint ett_lte_rrc_CSI_IM_ConfigToAddModList_r11 = -1;
static gint ett_lte_rrc_CSI_IM_ConfigToAddModListExt_r13 = -1;
static gint ett_lte_rrc_CSI_IM_ConfigToReleaseList_r11 = -1;
static gint ett_lte_rrc_CSI_IM_ConfigToReleaseListExt_r13 = -1;
static gint ett_lte_rrc_CSI_ProcessToAddModList_r11 = -1;
static gint ett_lte_rrc_CSI_ProcessToReleaseList_r11 = -1;
static gint ett_lte_rrc_CQI_ReportBothProc_r11 = -1;
static gint ett_lte_rrc_CQI_ReportConfig = -1;
static gint ett_lte_rrc_CQI_ReportConfig_v920 = -1;
static gint ett_lte_rrc_CQI_ReportConfig_r10 = -1;
static gint ett_lte_rrc_T_csi_SubframePatternConfig_r10 = -1;
static gint ett_lte_rrc_T_setup_15 = -1;
static gint ett_lte_rrc_CQI_ReportConfig_v1130 = -1;
static gint ett_lte_rrc_CQI_ReportConfig_v1250 = -1;
static gint ett_lte_rrc_T_csi_SubframePatternConfig_r12 = -1;
static gint ett_lte_rrc_T_setup_16 = -1;
static gint ett_lte_rrc_CQI_ReportConfig_v1310 = -1;
static gint ett_lte_rrc_CQI_ReportConfig_v1320 = -1;
static gint ett_lte_rrc_CQI_ReportConfig_v1430 = -1;
static gint ett_lte_rrc_CQI_ReportConfig_v1530 = -1;
static gint ett_lte_rrc_CQI_ReportConfig_r15 = -1;
static gint ett_lte_rrc_T_setup_17 = -1;
static gint ett_lte_rrc_CQI_ReportConfigSCell_r10 = -1;
static gint ett_lte_rrc_CQI_ReportConfigSCell_r15 = -1;
static gint ett_lte_rrc_CQI_ReportPeriodic = -1;
static gint ett_lte_rrc_T_setup_18 = -1;
static gint ett_lte_rrc_T_cqi_FormatIndicatorPeriodic = -1;
static gint ett_lte_rrc_T_subbandCQI = -1;
static gint ett_lte_rrc_CQI_ReportPeriodic_r10 = -1;
static gint ett_lte_rrc_T_setup_19 = -1;
static gint ett_lte_rrc_T_cqi_FormatIndicatorPeriodic_r10 = -1;
static gint ett_lte_rrc_T_widebandCQI_r10 = -1;
static gint ett_lte_rrc_T_subbandCQI_r10 = -1;
static gint ett_lte_rrc_T_csi_ConfigIndex_r10 = -1;
static gint ett_lte_rrc_T_setup_20 = -1;
static gint ett_lte_rrc_CQI_ReportPeriodic_v1130 = -1;
static gint ett_lte_rrc_CQI_ReportPeriodic_v1310 = -1;
static gint ett_lte_rrc_CQI_ReportPeriodic_v1320 = -1;
static gint ett_lte_rrc_CQI_ReportPeriodicSCell_r15 = -1;
static gint ett_lte_rrc_T_setup_21 = -1;
static gint ett_lte_rrc_T_csi_SubframePatternDormant_r15 = -1;
static gint ett_lte_rrc_T_setup_22 = -1;
static gint ett_lte_rrc_T_cqi_FormatIndicatorDormant_r15 = -1;
static gint ett_lte_rrc_T_widebandCQI_r15 = -1;
static gint ett_lte_rrc_T_subbandCQI_r15 = -1;
static gint ett_lte_rrc_CQI_ReportPeriodicProcExtToAddModList_r11 = -1;
static gint ett_lte_rrc_CQI_ReportPeriodicProcExtToReleaseList_r11 = -1;
static gint ett_lte_rrc_CQI_ReportPeriodicProcExt_r11 = -1;
static gint ett_lte_rrc_T_cqi_FormatIndicatorPeriodic_r11 = -1;
static gint ett_lte_rrc_T_widebandCQI_r11 = -1;
static gint ett_lte_rrc_T_subbandCQI_r11 = -1;
static gint ett_lte_rrc_T_csi_ConfigIndex_r11 = -1;
static gint ett_lte_rrc_T_setup_23 = -1;
static gint ett_lte_rrc_CQI_ShortConfigSCell_r15 = -1;
static gint ett_lte_rrc_T_setup_24 = -1;
static gint ett_lte_rrc_T_cqi_FormatIndicatorShort_r15 = -1;
static gint ett_lte_rrc_T_widebandCQI_Short_r15 = -1;
static gint ett_lte_rrc_T_subbandCQI_Short_r15 = -1;
static gint ett_lte_rrc_CRI_ReportConfig_r13 = -1;
static gint ett_lte_rrc_T_setup_25 = -1;
static gint ett_lte_rrc_CrossCarrierSchedulingConfig_r10 = -1;
static gint ett_lte_rrc_T_schedulingCellInfo_r10 = -1;
static gint ett_lte_rrc_T_own_r10 = -1;
static gint ett_lte_rrc_T_other_r10 = -1;
static gint ett_lte_rrc_CrossCarrierSchedulingConfig_r13 = -1;
static gint ett_lte_rrc_T_schedulingCellInfo_r13 = -1;
static gint ett_lte_rrc_T_own_r13 = -1;
static gint ett_lte_rrc_T_other_r13 = -1;
static gint ett_lte_rrc_CrossCarrierSchedulingConfigLAA_UL_r14 = -1;
static gint ett_lte_rrc_CSI_IM_Config_r11 = -1;
static gint ett_lte_rrc_CSI_IM_ConfigExt_r12 = -1;
static gint ett_lte_rrc_CSI_Process_r11 = -1;
static gint ett_lte_rrc_T_csi_IM_ConfigIdList_r12 = -1;
static gint ett_lte_rrc_SEQUENCE_SIZE_1_2_OF_CSI_IM_ConfigId_r12 = -1;
static gint ett_lte_rrc_T_cqi_ReportAperiodicProc2_r12 = -1;
static gint ett_lte_rrc_T_cqi_ReportAperiodicProc_v1310 = -1;
static gint ett_lte_rrc_T_cqi_ReportAperiodicProc2_v1310 = -1;
static gint ett_lte_rrc_CSI_RS_Config_r10 = -1;
static gint ett_lte_rrc_T_csi_RS_r10 = -1;
static gint ett_lte_rrc_T_setup_26 = -1;
static gint ett_lte_rrc_CSI_RS_Config_v1250 = -1;
static gint ett_lte_rrc_T_ds_ZeroTxPowerCSI_RS_r12 = -1;
static gint ett_lte_rrc_T_setup_27 = -1;
static gint ett_lte_rrc_SEQUENCE_SIZE_1_maxDS_ZTP_CSI_RS_r12_OF_ZeroTxPowerCSI_RS_r12 = -1;
static gint ett_lte_rrc_CSI_RS_Config_v1310 = -1;
static gint ett_lte_rrc_CSI_RS_Config_v1430 = -1;
static gint ett_lte_rrc_CSI_RS_Config_v1480 = -1;
static gint ett_lte_rrc_CSI_RS_Config_v1530 = -1;
static gint ett_lte_rrc_CSI_RS_Config_r15 = -1;
static gint ett_lte_rrc_T_setup_28 = -1;
static gint ett_lte_rrc_ZeroTxPowerCSI_RS_Conf_r12 = -1;
static gint ett_lte_rrc_ZeroTxPowerCSI_RS_r12 = -1;
static gint ett_lte_rrc_CSI_RS_ConfigBeamformed_r13 = -1;
static gint ett_lte_rrc_SEQUENCE_SIZE_1_7_OF_CSI_RS_ConfigNZPId_r13 = -1;
static gint ett_lte_rrc_SEQUENCE_SIZE_1_8_OF_CSI_IM_ConfigId_r13 = -1;
static gint ett_lte_rrc_SEQUENCE_SIZE_1_8_OF_P_C_AndCBSR_Pair_r13 = -1;
static gint ett_lte_rrc_T_ace_For4Tx_PerResourceConfigList_r13 = -1;
static gint ett_lte_rrc_CSI_RS_ConfigBeamformed_r14 = -1;
static gint ett_lte_rrc_T_ace_For4Tx_PerResourceConfigList_r14 = -1;
static gint ett_lte_rrc_SEQUENCE_SIZE_1_8_OF_CSI_RS_ConfigNZP_r11 = -1;
static gint ett_lte_rrc_CSI_RS_ConfigBeamformed_v1430 = -1;
static gint ett_lte_rrc_CSI_RS_Config_NZP_v1430 = -1;
static gint ett_lte_rrc_CSI_RS_ConfigNZP_Activation_r14 = -1;
static gint ett_lte_rrc_CSI_RS_ConfigEMIMO_r13 = -1;
static gint ett_lte_rrc_T_setup_29 = -1;
static gint ett_lte_rrc_CSI_RS_ConfigEMIMO_v1430 = -1;
static gint ett_lte_rrc_T_setup_30 = -1;
static gint ett_lte_rrc_CSI_RS_ConfigEMIMO_v1480 = -1;
static gint ett_lte_rrc_T_setup_31 = -1;
static gint ett_lte_rrc_CSI_RS_ConfigEMIMO_v1530 = -1;
static gint ett_lte_rrc_T_setup_32 = -1;
static gint ett_lte_rrc_CSI_RS_ConfigEMIMO2_r14 = -1;
static gint ett_lte_rrc_CSI_RS_ConfigEMIMO_Hybrid_r14 = -1;
static gint ett_lte_rrc_T_setup_33 = -1;
static gint ett_lte_rrc_CSI_RS_ConfigNonPrecoded_r13 = -1;
static gint ett_lte_rrc_SEQUENCE_SIZE_1_2_OF_CSI_IM_ConfigId_r13 = -1;
static gint ett_lte_rrc_CSI_RS_ConfigNonPrecoded_v1430 = -1;
static gint ett_lte_rrc_CSI_RS_ConfigNonPrecoded_v1480 = -1;
static gint ett_lte_rrc_CSI_RS_ConfigNonPrecoded_v1530 = -1;
static gint ett_lte_rrc_CSI_RS_ConfigNZP_r11 = -1;
static gint ett_lte_rrc_T_qcl_CRS_Info_r11 = -1;
static gint ett_lte_rrc_T_mbsfn_SubframeConfigList_r11 = -1;
static gint ett_lte_rrc_T_setup_34 = -1;
static gint ett_lte_rrc_T_mbsfn_SubframeConfigList_v1430 = -1;
static gint ett_lte_rrc_T_setup_35 = -1;
static gint ett_lte_rrc_CSI_RS_ConfigNZP_EMIMO_r13 = -1;
static gint ett_lte_rrc_T_setup_36 = -1;
static gint ett_lte_rrc_SEQUENCE_SIZE_1_2_OF_NZP_ResourceConfig_r13 = -1;
static gint ett_lte_rrc_CSI_RS_ConfigNZP_EMIMO_v1430 = -1;
static gint ett_lte_rrc_SEQUENCE_SIZE_0_4_OF_NZP_ResourceConfig_r13 = -1;
static gint ett_lte_rrc_NZP_ResourceConfig_r13 = -1;
static gint ett_lte_rrc_CSI_RS_ConfigZP_r11 = -1;
static gint ett_lte_rrc_CSI_RS_ConfigZP_ApList_r14 = -1;
static gint ett_lte_rrc_SEQUENCE_SIZE_1_maxCSI_RS_ZP_r11_OF_CSI_RS_ConfigZP_r11 = -1;
static gint ett_lte_rrc_DMRS_Config_r11 = -1;
static gint ett_lte_rrc_T_setup_37 = -1;
static gint ett_lte_rrc_DMRS_Config_v1310 = -1;
static gint ett_lte_rrc_EPDCCH_Config_r11 = -1;
static gint ett_lte_rrc_T_config_r11 = -1;
static gint ett_lte_rrc_T_setup_38 = -1;
static gint ett_lte_rrc_T_subframePatternConfig_r11 = -1;
static gint ett_lte_rrc_T_setup_39 = -1;
static gint ett_lte_rrc_EPDCCH_SetConfigToAddModList_r11 = -1;
static gint ett_lte_rrc_EPDCCH_SetConfigToReleaseList_r11 = -1;
static gint ett_lte_rrc_EPDCCH_SetConfig_r11 = -1;
static gint ett_lte_rrc_T_resourceBlockAssignment_r11 = -1;
static gint ett_lte_rrc_T_csi_RS_ConfigZPId2_r12 = -1;
static gint ett_lte_rrc_T_numberPRB_Pairs_v1310 = -1;
static gint ett_lte_rrc_T_mpdcch_config_r13 = -1;
static gint ett_lte_rrc_T_setup_41 = -1;
static gint ett_lte_rrc_T_mpdcch_StartSF_UESS_r13 = -1;
static gint ett_lte_rrc_EIMTA_MainConfig_r12 = -1;
static gint ett_lte_rrc_T_setup_42 = -1;
static gint ett_lte_rrc_EIMTA_MainConfigServCell_r12 = -1;
static gint ett_lte_rrc_T_setup_43 = -1;
static gint ett_lte_rrc_T_mbsfn_SubframeConfigList_v1250 = -1;
static gint ett_lte_rrc_T_setup_44 = -1;
static gint ett_lte_rrc_LogicalChannelConfig = -1;
static gint ett_lte_rrc_T_ul_SpecificParameters = -1;
static gint ett_lte_rrc_T_allowedTTI_Lengths_r15 = -1;
static gint ett_lte_rrc_T_setup_45 = -1;
static gint ett_lte_rrc_T_logicalChannelSR_Restriction_r15 = -1;
static gint ett_lte_rrc_T_channellAccessPriority_r15 = -1;
static gint ett_lte_rrc_LWA_Configuration_r13 = -1;
static gint ett_lte_rrc_T_setup_47 = -1;
static gint ett_lte_rrc_LWA_Config_r13 = -1;
static gint ett_lte_rrc_LWIP_Configuration_r13 = -1;
static gint ett_lte_rrc_T_setup_48 = -1;
static gint ett_lte_rrc_LWIP_Config_r13 = -1;
static gint ett_lte_rrc_MAC_MainConfig = -1;
static gint ett_lte_rrc_T_ul_SCH_Config = -1;
static gint ett_lte_rrc_T_phr_Config = -1;
static gint ett_lte_rrc_T_setup_49 = -1;
static gint ett_lte_rrc_T_mac_MainConfig_v1020 = -1;
static gint ett_lte_rrc_T_dualConnectivityPHR = -1;
static gint ett_lte_rrc_T_setup_50 = -1;
static gint ett_lte_rrc_T_logicalChannelSR_Config_r12 = -1;
static gint ett_lte_rrc_T_setup_51 = -1;
static gint ett_lte_rrc_T_eDRX_Config_CycleStartOffset_r13 = -1;
static gint ett_lte_rrc_T_setup_52 = -1;
static gint ett_lte_rrc_T_drx_Config_r13 = -1;
static gint ett_lte_rrc_T_skipUplinkTx_r14 = -1;
static gint ett_lte_rrc_T_setup_53 = -1;
static gint ett_lte_rrc_T_dataInactivityTimerConfig_r14 = -1;
static gint ett_lte_rrc_T_setup_54 = -1;
static gint ett_lte_rrc_T_shortTTI_AndSPT_r15 = -1;
static gint ett_lte_rrc_T_setup_55 = -1;
static gint ett_lte_rrc_T_dormantStateTimers_r15 = -1;
static gint ett_lte_rrc_T_setup_56 = -1;
static gint ett_lte_rrc_MAC_MainConfigSCell_r11 = -1;
static gint ett_lte_rrc_DRX_Config = -1;
static gint ett_lte_rrc_T_setup_57 = -1;
static gint ett_lte_rrc_T_longDRX_CycleStartOffset = -1;
static gint ett_lte_rrc_T_shortDRX = -1;
static gint ett_lte_rrc_DRX_Config_v1130 = -1;
static gint ett_lte_rrc_T_longDRX_CycleStartOffset_v1130 = -1;
static gint ett_lte_rrc_DRX_Config_v1310 = -1;
static gint ett_lte_rrc_T_longDRX_CycleStartOffset_v1310 = -1;
static gint ett_lte_rrc_DRX_Config_r13 = -1;
static gint ett_lte_rrc_DRX_Config_r15 = -1;
static gint ett_lte_rrc_STAG_ToReleaseList_r11 = -1;
static gint ett_lte_rrc_STAG_ToAddModList_r11 = -1;
static gint ett_lte_rrc_STAG_ToAddMod_r11 = -1;
static gint ett_lte_rrc_P_C_AndCBSR_r11 = -1;
static gint ett_lte_rrc_P_C_AndCBSR_r13 = -1;
static gint ett_lte_rrc_T_cbsr_Selection_r13 = -1;
static gint ett_lte_rrc_T_nonPrecoded_r13 = -1;
static gint ett_lte_rrc_T_beamformedK1a_r13 = -1;
static gint ett_lte_rrc_T_beamformedKN_r13 = -1;
static gint ett_lte_rrc_P_C_AndCBSR_r15 = -1;
static gint ett_lte_rrc_P_C_AndCBSR_Pair_r13a = -1;
static gint ett_lte_rrc_P_C_AndCBSR_Pair_r13 = -1;
static gint ett_lte_rrc_P_C_AndCBSR_Pair_r15 = -1;
static gint ett_lte_rrc_PDCCH_ConfigSCell_r13 = -1;
static gint ett_lte_rrc_PDCCH_ConfigLAA_r14 = -1;
static gint ett_lte_rrc_PDCCH_CandidateReductions_r13 = -1;
static gint ett_lte_rrc_T_setup_58 = -1;
static gint ett_lte_rrc_PDCCH_CandidateReductionsLAA_UL_r14 = -1;
static gint ett_lte_rrc_T_setup_59 = -1;
static gint ett_lte_rrc_PDCP_Config = -1;
static gint ett_lte_rrc_T_rlc_AM = -1;
static gint ett_lte_rrc_T_rlc_UM = -1;
static gint ett_lte_rrc_T_headerCompression = -1;
static gint ett_lte_rrc_T_rohc = -1;
static gint ett_lte_rrc_T_profiles = -1;
static gint ett_lte_rrc_T_ul_DataSplitThreshold_r13 = -1;
static gint ett_lte_rrc_T_statusFeedback_r13 = -1;
static gint ett_lte_rrc_T_setup_61 = -1;
static gint ett_lte_rrc_T_ul_LWA_Config_r14 = -1;
static gint ett_lte_rrc_T_setup_62 = -1;
static gint ett_lte_rrc_T_uplinkOnlyHeaderCompression_r14 = -1;
static gint ett_lte_rrc_T_rohc_r14 = -1;
static gint ett_lte_rrc_T_profiles_r14 = -1;
static gint ett_lte_rrc_T_uplinkDataCompression_r15 = -1;
static gint ett_lte_rrc_T_pdcp_DuplicationConfig_r15 = -1;
static gint ett_lte_rrc_T_setup_63 = -1;
static gint ett_lte_rrc_PDSCH_ConfigCommon = -1;
static gint ett_lte_rrc_PDSCH_ConfigCommon_v1310 = -1;
static gint ett_lte_rrc_PDSCH_ConfigDedicated = -1;
static gint ett_lte_rrc_PDSCH_ConfigDedicated_v1130 = -1;
static gint ett_lte_rrc_PDSCH_ConfigDedicated_v1280 = -1;
static gint ett_lte_rrc_PDSCH_ConfigDedicated_v1310 = -1;
static gint ett_lte_rrc_PDSCH_ConfigDedicated_v1430 = -1;
static gint ett_lte_rrc_PDSCH_ConfigDedicated_v1530 = -1;
static gint ett_lte_rrc_PDSCH_ConfigDedicatedSCell_v1430 = -1;
static gint ett_lte_rrc_RE_MappingQCLConfigToAddModList_r11 = -1;
static gint ett_lte_rrc_RE_MappingQCLConfigToReleaseList_r11 = -1;
static gint ett_lte_rrc_PDSCH_RE_MappingQCL_Config_r11 = -1;
static gint ett_lte_rrc_T_optionalSetOfFields_r11 = -1;
static gint ett_lte_rrc_T_mbsfn_SubframeConfigList_r11_01 = -1;
static gint ett_lte_rrc_T_setup_64 = -1;
static gint ett_lte_rrc_T_mbsfn_SubframeConfigList_v1430_01 = -1;
static gint ett_lte_rrc_T_setup_65 = -1;
static gint ett_lte_rrc_T_codewordOneConfig_v1530 = -1;
static gint ett_lte_rrc_T_setup_66 = -1;
static gint ett_lte_rrc_PerCC_GapIndicationList_r14 = -1;
static gint ett_lte_rrc_PerCC_GapIndication_r14 = -1;
static gint ett_lte_rrc_PHICH_Config = -1;
static gint ett_lte_rrc_PhysicalConfigDedicated = -1;
static gint ett_lte_rrc_T_antennaInfo = -1;
static gint ett_lte_rrc_T_antennaInfo_r10 = -1;
static gint ett_lte_rrc_T_additionalSpectrumEmissionCA_r10 = -1;
static gint ett_lte_rrc_T_setup_67 = -1;
static gint ett_lte_rrc_T_ce_Mode_r13 = -1;
static gint ett_lte_rrc_T_typeA_SRS_TPC_PDCCH_Group_r14 = -1;
static gint ett_lte_rrc_SEQUENCE_SIZE_1_32_OF_SRS_TPC_PDCCH_Config_r14 = -1;
static gint ett_lte_rrc_T_must_Config_r14 = -1;
static gint ett_lte_rrc_T_setup_69 = -1;
static gint ett_lte_rrc_SEQUENCE_SIZE_1_2_OF_SoundingRS_UL_ConfigDedicated = -1;
static gint ett_lte_rrc_SEQUENCE_SIZE_1_4_OF_SoundingRS_UL_ConfigDedicatedUpPTsExt_r13 = -1;
static gint ett_lte_rrc_SEQUENCE_SIZE_1_2_OF_SoundingRS_UL_ConfigDedicatedAperiodic_r10 = -1;
static gint ett_lte_rrc_SEQUENCE_SIZE_1_4_OF_SoundingRS_UL_ConfigDedicatedAperiodicUpPTsExt_r13 = -1;
static gint ett_lte_rrc_T_semiStaticCFI_Config_r15 = -1;
static gint ett_lte_rrc_T_setup_70 = -1;
static gint ett_lte_rrc_T_blindPDSCH_Repetition_Config_r15 = -1;
static gint ett_lte_rrc_T_setup_71 = -1;
static gint ett_lte_rrc_PhysicalConfigDedicated_v1370 = -1;
static gint ett_lte_rrc_PhysicalConfigDedicated_v13c0 = -1;
static gint ett_lte_rrc_PhysicalConfigDedicatedSCell_r10 = -1;
static gint ett_lte_rrc_T_nonUL_Configuration_r10 = -1;
static gint ett_lte_rrc_T_ul_Configuration_r10 = -1;
static gint ett_lte_rrc_T_pucch_SCell = -1;
static gint ett_lte_rrc_T_setup_72 = -1;
static gint ett_lte_rrc_SEQUENCE_SIZE_1_2_OF_SoundingRS_AperiodicSet_r14 = -1;
static gint ett_lte_rrc_SEQUENCE_SIZE_1_4_OF_SoundingRS_AperiodicSetUpPTsExt_r14 = -1;
static gint ett_lte_rrc_T_must_Config_r14_01 = -1;
static gint ett_lte_rrc_T_setup_73 = -1;
static gint ett_lte_rrc_T_semiStaticCFI_Config_r15_01 = -1;
static gint ett_lte_rrc_T_setup_74 = -1;
static gint ett_lte_rrc_T_blindPDSCH_Repetition_Config_r15_01 = -1;
static gint ett_lte_rrc_T_setup_75 = -1;
static gint ett_lte_rrc_PhysicalConfigDedicatedSCell_v1370 = -1;
static gint ett_lte_rrc_T_pucch_SCell_v1370 = -1;
static gint ett_lte_rrc_T_setup_76 = -1;
static gint ett_lte_rrc_PhysicalConfigDedicatedSCell_v13c0 = -1;
static gint ett_lte_rrc_T_pucch_SCell_v13c0 = -1;
static gint ett_lte_rrc_T_setup_77 = -1;
static gint ett_lte_rrc_CFI_Config_r15 = -1;
static gint ett_lte_rrc_CFI_PatternConfig_r15 = -1;
static gint ett_lte_rrc_T_cfi_PatternSubframe_r15 = -1;
static gint ett_lte_rrc_T_cfi_PatternSlotSubslot_r15 = -1;
static gint ett_lte_rrc_LAA_SCellConfiguration_r13 = -1;
static gint ett_lte_rrc_LAA_SCellConfiguration_v1430 = -1;
static gint ett_lte_rrc_T_crossCarrierSchedulingConfig_UL_r14 = -1;
static gint ett_lte_rrc_T_setup_78 = -1;
static gint ett_lte_rrc_LAA_SCellConfiguration_v1530 = -1;
static gint ett_lte_rrc_PUSCH_ModeConfigLAA_r15 = -1;
static gint ett_lte_rrc_LBT_Config_r14 = -1;
static gint ett_lte_rrc_CSI_RS_ConfigNZPToAddModList_r11 = -1;
static gint ett_lte_rrc_CSI_RS_ConfigNZPToAddModListExt_r13 = -1;
static gint ett_lte_rrc_CSI_RS_ConfigNZPToAddModList_r15 = -1;
static gint ett_lte_rrc_CSI_RS_ConfigNZPToReleaseList_r11 = -1;
static gint ett_lte_rrc_CSI_RS_ConfigNZPToReleaseListExt_r13 = -1;
static gint ett_lte_rrc_CSI_RS_ConfigNZPToReleaseList_r15 = -1;
static gint ett_lte_rrc_CSI_RS_ConfigZPToAddModList_r11 = -1;
static gint ett_lte_rrc_CSI_RS_ConfigZPToReleaseList_r11 = -1;
static gint ett_lte_rrc_PhysicalConfigDedicatedSTTI_r15 = -1;
static gint ett_lte_rrc_T_setup_79 = -1;
static gint ett_lte_rrc_SoundingRS_AperiodicSet_r14 = -1;
static gint ett_lte_rrc_SEQUENCE_SIZE_1_4_OF_SRS_CC_SetIndex_r14 = -1;
static gint ett_lte_rrc_SoundingRS_AperiodicSetUpPTsExt_r14 = -1;
static gint ett_lte_rrc_ShortTTI_r15 = -1;
static gint ett_lte_rrc_PRACH_ConfigSIB = -1;
static gint ett_lte_rrc_PRACH_ConfigSIB_v1310 = -1;
static gint ett_lte_rrc_T_mpdcch_startSF_CSS_RA_r13 = -1;
static gint ett_lte_rrc_PRACH_ConfigSIB_v1530 = -1;
static gint ett_lte_rrc_SEQUENCE_SIZE_1_maxCE_Level_r13_OF_EDT_PRACH_ParametersCE_r15 = -1;
static gint ett_lte_rrc_PRACH_Config = -1;
static gint ett_lte_rrc_PRACH_Config_v1310 = -1;
static gint ett_lte_rrc_T_mpdcch_startSF_CSS_RA_r13_01 = -1;
static gint ett_lte_rrc_PRACH_Config_v1430 = -1;
static gint ett_lte_rrc_PRACH_ConfigSCell_r10 = -1;
static gint ett_lte_rrc_PRACH_ConfigInfo = -1;
static gint ett_lte_rrc_PRACH_ParametersListCE_r13 = -1;
static gint ett_lte_rrc_PRACH_ParametersCE_r13 = -1;
static gint ett_lte_rrc_T_mpdcch_NarrowbandsToMonitor_r13 = -1;
static gint ett_lte_rrc_EDT_PRACH_ParametersCE_r15 = -1;
static gint ett_lte_rrc_T_edt_PRACH_ParametersCE_r15 = -1;
static gint ett_lte_rrc_T_mpdcch_NarrowbandsToMonitor_r15 = -1;
static gint ett_lte_rrc_RSRP_ThresholdsPrachInfoList_r13 = -1;
static gint ett_lte_rrc_PUCCH_ConfigCommon = -1;
static gint ett_lte_rrc_PUCCH_ConfigCommon_v1310 = -1;
static gint ett_lte_rrc_PUCCH_ConfigCommon_v1430 = -1;
static gint ett_lte_rrc_PUCCH_ConfigDedicated = -1;
static gint ett_lte_rrc_T_ackNackRepetition = -1;
static gint ett_lte_rrc_T_setup_80 = -1;
static gint ett_lte_rrc_PUCCH_ConfigDedicated_v1020 = -1;
static gint ett_lte_rrc_T_pucch_Format_r10 = -1;
static gint ett_lte_rrc_T_channelSelection_r10 = -1;
static gint ett_lte_rrc_T_n1PUCCH_AN_CS_r10 = -1;
static gint ett_lte_rrc_T_setup_81 = -1;
static gint ett_lte_rrc_SEQUENCE_SIZE_1_2_OF_N1PUCCH_AN_CS_r10 = -1;
static gint ett_lte_rrc_PUCCH_ConfigDedicated_v1130 = -1;
static gint ett_lte_rrc_T_n1PUCCH_AN_CS_v1130 = -1;
static gint ett_lte_rrc_T_setup_82 = -1;
static gint ett_lte_rrc_T_n1PUCCH_AN_CS_ListP1_r11 = -1;
static gint ett_lte_rrc_T_nPUCCH_Param_r11 = -1;
static gint ett_lte_rrc_T_setup_83 = -1;
static gint ett_lte_rrc_PUCCH_ConfigDedicated_v1250 = -1;
static gint ett_lte_rrc_T_nkaPUCCH_Param_r12 = -1;
static gint ett_lte_rrc_T_setup_84 = -1;
static gint ett_lte_rrc_PUCCH_ConfigDedicated_r13 = -1;
static gint ett_lte_rrc_T_ackNackRepetition_r13 = -1;
static gint ett_lte_rrc_T_setup_85 = -1;
static gint ett_lte_rrc_T_pucch_Format_r13 = -1;
static gint ett_lte_rrc_T_format3_r13 = -1;
static gint ett_lte_rrc_T_n3PUCCH_AN_List_r13 = -1;
static gint ett_lte_rrc_T_twoAntennaPortActivatedPUCCH_Format3_r13 = -1;
static gint ett_lte_rrc_T_setup_86 = -1;
static gint ett_lte_rrc_T_n3PUCCH_AN_ListP1_r13 = -1;
static gint ett_lte_rrc_T_channelSelection_r13 = -1;
static gint ett_lte_rrc_T_n1PUCCH_AN_CS_r13 = -1;
static gint ett_lte_rrc_T_setup_87 = -1;
static gint ett_lte_rrc_N1PUCCH_AN_CS_List_r13 = -1;
static gint ett_lte_rrc_T_dummy1 = -1;
static gint ett_lte_rrc_T_format4_r13 = -1;
static gint ett_lte_rrc_SEQUENCE_SIZE_4_OF_Format4_resource_r13 = -1;
static gint ett_lte_rrc_SEQUENCE_SIZE_1_2_OF_Format4_resource_r13 = -1;
static gint ett_lte_rrc_T_format5_r13 = -1;
static gint ett_lte_rrc_SEQUENCE_SIZE_4_OF_Format5_resource_r13 = -1;
static gint ett_lte_rrc_T_nPUCCH_Param_r13 = -1;
static gint ett_lte_rrc_T_setup_88 = -1;
static gint ett_lte_rrc_T_nkaPUCCH_Param_r13 = -1;
static gint ett_lte_rrc_T_setup_89 = -1;
static gint ett_lte_rrc_T_pucch_NumRepetitionCE_r13 = -1;
static gint ett_lte_rrc_T_setup_90 = -1;
static gint ett_lte_rrc_T_modeA = -1;
static gint ett_lte_rrc_T_modeB = -1;
static gint ett_lte_rrc_PUCCH_ConfigDedicated_v1370 = -1;
static gint ett_lte_rrc_T_pucch_Format_v1370 = -1;
static gint ett_lte_rrc_PUCCH_ConfigDedicated_v13c0 = -1;
static gint ett_lte_rrc_T_channelSelection_v13c0 = -1;
static gint ett_lte_rrc_T_n1PUCCH_AN_CS_v13c0 = -1;
static gint ett_lte_rrc_T_setup_91 = -1;
static gint ett_lte_rrc_T_n1PUCCH_AN_CS_ListP1_v13c0 = -1;
static gint ett_lte_rrc_PUCCH_Format3_Conf_r13 = -1;
static gint ett_lte_rrc_T_n3PUCCH_AN_List_r13_01 = -1;
static gint ett_lte_rrc_T_twoAntennaPortActivatedPUCCH_Format3_r13_01 = -1;
static gint ett_lte_rrc_T_setup_92 = -1;
static gint ett_lte_rrc_T_n3PUCCH_AN_ListP1_r13_01 = -1;
static gint ett_lte_rrc_PUCCH_ConfigDedicated_v1430 = -1;
static gint ett_lte_rrc_PUCCH_ConfigDedicated_v1530 = -1;
static gint ett_lte_rrc_Format4_resource_r13 = -1;
static gint ett_lte_rrc_Format5_resource_r13 = -1;
static gint ett_lte_rrc_N1PUCCH_AN_CS_r10 = -1;
static gint ett_lte_rrc_N1PUCCH_AN_InfoList_r13 = -1;
static gint ett_lte_rrc_PUSCH_ConfigCommon = -1;
static gint ett_lte_rrc_T_pusch_ConfigBasic = -1;
static gint ett_lte_rrc_PUSCH_ConfigCommon_v1270 = -1;
static gint ett_lte_rrc_PUSCH_ConfigCommon_v1310 = -1;
static gint ett_lte_rrc_PUSCH_ConfigDedicated = -1;
static gint ett_lte_rrc_PUSCH_ConfigDedicated_v1020 = -1;
static gint ett_lte_rrc_T_betaOffsetMC_r10 = -1;
static gint ett_lte_rrc_PUSCH_ConfigDedicated_v1130 = -1;
static gint ett_lte_rrc_T_pusch_DMRS_r11 = -1;
static gint ett_lte_rrc_T_setup_93 = -1;
static gint ett_lte_rrc_PUSCH_ConfigDedicated_v1250 = -1;
static gint ett_lte_rrc_T_uciOnPUSCH = -1;
static gint ett_lte_rrc_T_setup_94 = -1;
static gint ett_lte_rrc_T_betaOffsetMC_r12 = -1;
static gint ett_lte_rrc_PUSCH_ConfigDedicated_r13 = -1;
static gint ett_lte_rrc_T_betaOffsetMC_r13 = -1;
static gint ett_lte_rrc_T_pusch_DMRS_r11_01 = -1;
static gint ett_lte_rrc_T_setup_95 = -1;
static gint ett_lte_rrc_T_uciOnPUSCH_01 = -1;
static gint ett_lte_rrc_T_setup_96 = -1;
static gint ett_lte_rrc_T_betaOffsetMC_r12_01 = -1;
static gint ett_lte_rrc_PUSCH_ConfigDedicated_v1430 = -1;
static gint ett_lte_rrc_PUSCH_ConfigDedicated_v1530 = -1;
static gint ett_lte_rrc_T_ce_PUSCH_FlexibleStartPRB_AllocConfig_r15 = -1;
static gint ett_lte_rrc_T_setup_97 = -1;
static gint ett_lte_rrc_T_ce_PUSCH_SubPRB_Config_r15 = -1;
static gint ett_lte_rrc_T_setup_98 = -1;
static gint ett_lte_rrc_PUSCH_ConfigDedicatedSCell_r10 = -1;
static gint ett_lte_rrc_PUSCH_ConfigDedicatedSCell_v1430 = -1;
static gint ett_lte_rrc_PUSCH_ConfigDedicatedScell_v1530 = -1;
static gint ett_lte_rrc_T_uci_OnPUSCH_r15 = -1;
static gint ett_lte_rrc_T_setup_99 = -1;
static gint ett_lte_rrc_TDD_PUSCH_UpPTS_r14 = -1;
static gint ett_lte_rrc_T_setup_100 = -1;
static gint ett_lte_rrc_Enable256QAM_r14 = -1;
static gint ett_lte_rrc_T_setup_101 = -1;
static gint ett_lte_rrc_T_tpc_SubframeSet_Configured_r14 = -1;
static gint ett_lte_rrc_T_tpc_SubframeSet_NotConfigured_r14 = -1;
static gint ett_lte_rrc_PUSCH_EnhancementsConfig_r14 = -1;
static gint ett_lte_rrc_T_setup_102 = -1;
static gint ett_lte_rrc_T_interval_ULHoppingPUSCH_Enh_r14 = -1;
static gint ett_lte_rrc_UL_ReferenceSignalsPUSCH = -1;
static gint ett_lte_rrc_RACH_ConfigCommon = -1;
static gint ett_lte_rrc_T_preambleInfo = -1;
static gint ett_lte_rrc_T_preamblesGroupAConfig = -1;
static gint ett_lte_rrc_T_ra_SupervisionInfo = -1;
static gint ett_lte_rrc_RACH_ConfigCommon_v1250 = -1;
static gint ett_lte_rrc_T_txFailParams_r12 = -1;
static gint ett_lte_rrc_RACH_ConfigCommonSCell_r11 = -1;
static gint ett_lte_rrc_T_ra_SupervisionInfo_r11 = -1;
static gint ett_lte_rrc_RACH_CE_LevelInfoList_r13 = -1;
static gint ett_lte_rrc_RACH_CE_LevelInfo_r13 = -1;
static gint ett_lte_rrc_T_preambleMappingInfo_r13 = -1;
static gint ett_lte_rrc_T_edt_Parameters_r15 = -1;
static gint ett_lte_rrc_PowerRampingParameters = -1;
static gint ett_lte_rrc_RACH_ConfigDedicated = -1;
static gint ett_lte_rrc_RadioResourceConfigCommonSIB = -1;
static gint ett_lte_rrc_RadioResourceConfigCommon = -1;
static gint ett_lte_rrc_RadioResourceConfigCommonPSCell_r12 = -1;
static gint ett_lte_rrc_RadioResourceConfigCommonPSCell_v12f0 = -1;
static gint ett_lte_rrc_RadioResourceConfigCommonPSCell_v1440 = -1;
static gint ett_lte_rrc_RadioResourceConfigCommonSCell_r10 = -1;
static gint ett_lte_rrc_T_nonUL_Configuration_r10_01 = -1;
static gint ett_lte_rrc_T_ul_Configuration_r10_01 = -1;
static gint ett_lte_rrc_T_ul_FreqInfo_r10 = -1;
static gint ett_lte_rrc_T_ul_Configuration_r14 = -1;
static gint ett_lte_rrc_T_ul_FreqInfo_r14 = -1;
static gint ett_lte_rrc_RadioResourceConfigCommonSCell_v10l0 = -1;
static gint ett_lte_rrc_T_ul_Configuration_v10l0 = -1;
static gint ett_lte_rrc_RadioResourceConfigCommonSCell_v1440 = -1;
static gint ett_lte_rrc_T_ul_Configuration_v1440 = -1;
static gint ett_lte_rrc_T_ul_FreqInfo_v1440 = -1;
static gint ett_lte_rrc_BCCH_Config = -1;
static gint ett_lte_rrc_BCCH_Config_v1310 = -1;
static gint ett_lte_rrc_FreqHoppingParameters_r13 = -1;
static gint ett_lte_rrc_T_dummy2_01 = -1;
static gint ett_lte_rrc_T_dummy3 = -1;
static gint ett_lte_rrc_T_interval_ULHoppingConfigCommonModeA_r13 = -1;
static gint ett_lte_rrc_T_interval_ULHoppingConfigCommonModeB_r13 = -1;
static gint ett_lte_rrc_PCCH_Config = -1;
static gint ett_lte_rrc_PCCH_Config_v1310 = -1;
static gint ett_lte_rrc_HighSpeedConfig_r14 = -1;
static gint ett_lte_rrc_HighSpeedConfig_v1530 = -1;
static gint ett_lte_rrc_HighSpeedConfigSCell_r14 = -1;
static gint ett_lte_rrc_RadioResourceConfigDedicated = -1;
static gint ett_lte_rrc_T_mac_MainConfig = -1;
static gint ett_lte_rrc_T_crs_IntfMitigConfig_r15_01 = -1;
static gint ett_lte_rrc_T_setup_103 = -1;
static gint ett_lte_rrc_T_dummy_03 = -1;
static gint ett_lte_rrc_RadioResourceConfigDedicated_v1370 = -1;
static gint ett_lte_rrc_RadioResourceConfigDedicated_v13c0 = -1;
static gint ett_lte_rrc_RadioResourceConfigDedicatedPSCell_r12 = -1;
static gint ett_lte_rrc_RadioResourceConfigDedicatedPSCell_v1370 = -1;
static gint ett_lte_rrc_RadioResourceConfigDedicatedPSCell_v13c0 = -1;
static gint ett_lte_rrc_RadioResourceConfigDedicatedSCG_r12 = -1;
static gint ett_lte_rrc_RadioResourceConfigDedicatedSCell_r10 = -1;
static gint ett_lte_rrc_RadioResourceConfigDedicatedSCell_v13c0 = -1;
static gint ett_lte_rrc_SRB_ToAddModList = -1;
static gint ett_lte_rrc_SRB_ToAddModListExt_r15 = -1;
static gint ett_lte_rrc_SRB_ToAddMod = -1;
static gint ett_lte_rrc_T_rlc_Config = -1;
static gint ett_lte_rrc_T_logicalChannelConfig = -1;
static gint ett_lte_rrc_DRB_ToAddModList = -1;
static gint ett_lte_rrc_DRB_ToAddModList_r15 = -1;
static gint ett_lte_rrc_DRB_ToAddModListSCG_r12 = -1;
static gint ett_lte_rrc_DRB_ToAddModListSCG_r15 = -1;
static gint ett_lte_rrc_DRB_ToAddMod = -1;
static gint ett_lte_rrc_DRB_ToAddModSCG_r12 = -1;
static gint ett_lte_rrc_T_drb_Type_r12_01 = -1;
static gint ett_lte_rrc_T_scg_r12 = -1;
static gint ett_lte_rrc_DRB_ToReleaseList = -1;
static gint ett_lte_rrc_DRB_ToReleaseList_r15 = -1;
static gint ett_lte_rrc_SRB_ToReleaseList_r15 = -1;
static gint ett_lte_rrc_MeasSubframePatternPCell_r10 = -1;
static gint ett_lte_rrc_NeighCellsCRS_Info_r11 = -1;
static gint ett_lte_rrc_CRS_AssistanceInfoList_r11 = -1;
static gint ett_lte_rrc_CRS_AssistanceInfo_r11 = -1;
static gint ett_lte_rrc_NeighCellsCRS_Info_r13 = -1;
static gint ett_lte_rrc_CRS_AssistanceInfoList_r13 = -1;
static gint ett_lte_rrc_CRS_AssistanceInfo_r13 = -1;
static gint ett_lte_rrc_NeighCellsCRS_Info_r15 = -1;
static gint ett_lte_rrc_CRS_AssistanceInfoList_r15 = -1;
static gint ett_lte_rrc_CRS_AssistanceInfo_r15 = -1;
static gint ett_lte_rrc_NAICS_AssistanceInfo_r12 = -1;
static gint ett_lte_rrc_T_setup_104 = -1;
static gint ett_lte_rrc_NeighCellsToReleaseList_r12 = -1;
static gint ett_lte_rrc_NeighCellsToAddModList_r12 = -1;
static gint ett_lte_rrc_NeighCellsInfo_r12 = -1;
static gint ett_lte_rrc_SEQUENCE_SIZE_1_maxP_a_PerNeighCell_r12_OF_P_a = -1;
static gint ett_lte_rrc_RLC_BearerConfig_r15 = -1;
static gint ett_lte_rrc_T_setup_105 = -1;
static gint ett_lte_rrc_T_logicalChannelIdentityConfig_r15 = -1;
static gint ett_lte_rrc_RCLWI_Configuration_r13 = -1;
static gint ett_lte_rrc_T_setup_106 = -1;
static gint ett_lte_rrc_RCLWI_Config_r13 = -1;
static gint ett_lte_rrc_T_command = -1;
static gint ett_lte_rrc_T_steerToWLAN_r13 = -1;
static gint ett_lte_rrc_RLC_Config = -1;
static gint ett_lte_rrc_T_am = -1;
static gint ett_lte_rrc_T_um_Bi_Directional = -1;
static gint ett_lte_rrc_T_um_Uni_Directional_UL = -1;
static gint ett_lte_rrc_T_um_Uni_Directional_DL = -1;
static gint ett_lte_rrc_RLC_Config_v1250 = -1;
static gint ett_lte_rrc_RLC_Config_v1310 = -1;
static gint ett_lte_rrc_RLC_Config_v1430 = -1;
static gint ett_lte_rrc_T_setup_107 = -1;
static gint ett_lte_rrc_RLC_Config_v1510 = -1;
static gint ett_lte_rrc_RLC_Config_v1530 = -1;
static gint ett_lte_rrc_T_setup_108 = -1;
static gint ett_lte_rrc_RLC_Config_r15 = -1;
static gint ett_lte_rrc_T_mode_r15 = -1;
static gint ett_lte_rrc_T_am_r15 = -1;
static gint ett_lte_rrc_T_um_Bi_Directional_r15 = -1;
static gint ett_lte_rrc_T_um_Uni_Directional_UL_r15 = -1;
static gint ett_lte_rrc_T_um_Uni_Directional_DL_r15 = -1;
static gint ett_lte_rrc_UL_AM_RLC = -1;
static gint ett_lte_rrc_UL_AM_RLC_r15 = -1;
static gint ett_lte_rrc_DL_AM_RLC = -1;
static gint ett_lte_rrc_DL_AM_RLC_r15 = -1;
static gint ett_lte_rrc_UL_UM_RLC = -1;
static gint ett_lte_rrc_DL_UM_RLC = -1;
static gint ett_lte_rrc_DL_UM_RLC_r15 = -1;
static gint ett_lte_rrc_RLF_TimersAndConstants_r9 = -1;
static gint ett_lte_rrc_T_setup_109 = -1;
static gint ett_lte_rrc_RLF_TimersAndConstants_r13 = -1;
static gint ett_lte_rrc_T_setup_110 = -1;
static gint ett_lte_rrc_RLF_TimersAndConstantsSCG_r12 = -1;
static gint ett_lte_rrc_T_setup_111 = -1;
static gint ett_lte_rrc_RN_SubframeConfig_r10 = -1;
static gint ett_lte_rrc_T_subframeConfigPattern_r10 = -1;
static gint ett_lte_rrc_T_rpdcch_Config_r10 = -1;
static gint ett_lte_rrc_T_resourceBlockAssignment_r10 = -1;
static gint ett_lte_rrc_T_type01_r10 = -1;
static gint ett_lte_rrc_T_type2_r10 = -1;
static gint ett_lte_rrc_T_demodulationRS_r10 = -1;
static gint ett_lte_rrc_T_pucch_Config_r10 = -1;
static gint ett_lte_rrc_T_tdd = -1;
static gint ett_lte_rrc_T_channelSelectionMultiplexingBundling = -1;
static gint ett_lte_rrc_T_n1PUCCH_AN_List_r10 = -1;
static gint ett_lte_rrc_T_fallbackForFormat3 = -1;
static gint ett_lte_rrc_T_fdd = -1;
static gint ett_lte_rrc_RSS_Config_r15 = -1;
static gint ett_lte_rrc_SchedulingRequestConfig = -1;
static gint ett_lte_rrc_T_setup_112 = -1;
static gint ett_lte_rrc_SchedulingRequestConfig_v1020 = -1;
static gint ett_lte_rrc_SchedulingRequestConfigSCell_r13 = -1;
static gint ett_lte_rrc_T_setup_113 = -1;
static gint ett_lte_rrc_SchedulingRequestConfig_v1530 = -1;
static gint ett_lte_rrc_T_setup_114 = -1;
static gint ett_lte_rrc_SR_SubslotSPUCCH_ResourceList_r15 = -1;
static gint ett_lte_rrc_SlotOrSubslotPDSCH_Config_r15 = -1;
static gint ett_lte_rrc_T_setup_115 = -1;
static gint ett_lte_rrc_SlotOrSubslotPUSCH_Config_r15 = -1;
static gint ett_lte_rrc_T_setup_116 = -1;
static gint ett_lte_rrc_T_betaOffsetSubslot_ACK_Index_r15 = -1;
static gint ett_lte_rrc_T_betaOffset2Subslot_ACK_Index_r15 = -1;
static gint ett_lte_rrc_T_betaOffsetSubslot_RI_Index_r15 = -1;
static gint ett_lte_rrc_SoundingRS_UL_ConfigCommon = -1;
static gint ett_lte_rrc_T_setup_117 = -1;
static gint ett_lte_rrc_SoundingRS_UL_ConfigDedicated = -1;
static gint ett_lte_rrc_T_setup_118 = -1;
static gint ett_lte_rrc_SoundingRS_UL_ConfigDedicated_v1020 = -1;
static gint ett_lte_rrc_SoundingRS_UL_ConfigDedicated_v1310 = -1;
static gint ett_lte_rrc_T_setup_119 = -1;
static gint ett_lte_rrc_SoundingRS_UL_ConfigDedicatedUpPTsExt_r13 = -1;
static gint ett_lte_rrc_T_setup_120 = -1;
static gint ett_lte_rrc_SoundingRS_UL_ConfigDedicatedAperiodic_r10 = -1;
static gint ett_lte_rrc_T_setup_121 = -1;
static gint ett_lte_rrc_SEQUENCE_SIZE_1_3_OF_SRS_ConfigAp_r10 = -1;
static gint ett_lte_rrc_T_srs_ActivateAp_r10 = -1;
static gint ett_lte_rrc_T_setup_122 = -1;
static gint ett_lte_rrc_SoundingRS_UL_ConfigDedicatedAperiodic_v1310 = -1;
static gint ett_lte_rrc_T_setup_123 = -1;
static gint ett_lte_rrc_SEQUENCE_SIZE_1_3_OF_SRS_ConfigAp_v1310 = -1;
static gint ett_lte_rrc_T_srs_ActivateAp_v1310 = -1;
static gint ett_lte_rrc_T_setup_124 = -1;
static gint ett_lte_rrc_SoundingRS_UL_ConfigDedicatedAperiodicUpPTsExt_r13 = -1;
static gint ett_lte_rrc_T_setup_125 = -1;
static gint ett_lte_rrc_SEQUENCE_SIZE_1_3_OF_SRS_ConfigAp_r13 = -1;
static gint ett_lte_rrc_T_srs_ActivateAp_r13 = -1;
static gint ett_lte_rrc_T_setup_126 = -1;
static gint ett_lte_rrc_SoundingRS_UL_ConfigDedicatedAperiodic_v1430 = -1;
static gint ett_lte_rrc_T_setup_127 = -1;
static gint ett_lte_rrc_SRS_ConfigAp_r10 = -1;
static gint ett_lte_rrc_SRS_ConfigAp_v1310 = -1;
static gint ett_lte_rrc_SRS_ConfigAp_r13 = -1;
static gint ett_lte_rrc_SPDCCH_Config_r15 = -1;
static gint ett_lte_rrc_T_setup_128 = -1;
static gint ett_lte_rrc_SPDCCH_Set_r15 = -1;
static gint ett_lte_rrc_SPDCCH_Elements_r15 = -1;
static gint ett_lte_rrc_T_setup_129 = -1;
static gint ett_lte_rrc_SEQUENCE_SIZE_1_4_OF_DCI7_Candidates_r15 = -1;
static gint ett_lte_rrc_SEQUENCE_SIZE_1_2_OF_DCI7_CandidatesPerAL_SPDCCH_r15 = -1;
static gint ett_lte_rrc_T_resourceBlockAssignment_r15 = -1;
static gint ett_lte_rrc_T_al_StartingPointSPDCCH_r15 = -1;
static gint ett_lte_rrc_DCI7_CandidatesPerAL_SPDCCH_r15 = -1;
static gint ett_lte_rrc_SPS_Config = -1;
static gint ett_lte_rrc_SPS_Config_v1430 = -1;
static gint ett_lte_rrc_SPS_ConfigUL_ToAddModList_r14 = -1;
static gint ett_lte_rrc_SPS_ConfigUL_ToReleaseList_r14 = -1;
static gint ett_lte_rrc_SPS_ConfigSL_ToAddModList_r14 = -1;
static gint ett_lte_rrc_SPS_ConfigSL_ToReleaseList_r14 = -1;
static gint ett_lte_rrc_SPS_Config_v1530 = -1;
static gint ett_lte_rrc_SPS_Config_v1540 = -1;
static gint ett_lte_rrc_SPS_ConfigUL_STTI_ToAddModList_r15 = -1;
static gint ett_lte_rrc_SPS_ConfigUL_STTI_ToReleaseList_r15 = -1;
static gint ett_lte_rrc_SPS_ConfigUL_ToAddModList_r15 = -1;
static gint ett_lte_rrc_SPS_ConfigUL_ToReleaseList_r15 = -1;
static gint ett_lte_rrc_SPS_ConfigDL = -1;
static gint ett_lte_rrc_T_setup_130 = -1;
static gint ett_lte_rrc_T_twoAntennaPortActivated_r10 = -1;
static gint ett_lte_rrc_T_setup_131 = -1;
static gint ett_lte_rrc_SPS_ConfigUL = -1;
static gint ett_lte_rrc_T_setup_132 = -1;
static gint ett_lte_rrc_T_p0_Persistent = -1;
static gint ett_lte_rrc_T_p0_PersistentSubframeSet2_r12 = -1;
static gint ett_lte_rrc_T_setup_133 = -1;
static gint ett_lte_rrc_SPS_ConfigSL_r14 = -1;
static gint ett_lte_rrc_N1PUCCH_AN_PersistentList = -1;
static gint ett_lte_rrc_N1SPUCCH_AN_PersistentList_r15 = -1;
static gint ett_lte_rrc_SPS_ConfigDL_STTI_r15 = -1;
static gint ett_lte_rrc_T_setup_134 = -1;
static gint ett_lte_rrc_T_twoAntennaPortActivated_r15 = -1;
static gint ett_lte_rrc_T_setup_135 = -1;
static gint ett_lte_rrc_SPS_ConfigUL_STTI_r15 = -1;
static gint ett_lte_rrc_T_setup_136 = -1;
static gint ett_lte_rrc_T_p0_Persistent_r15 = -1;
static gint ett_lte_rrc_T_p0_PersistentSubframeSet2_r15 = -1;
static gint ett_lte_rrc_T_setup_137 = -1;
static gint ett_lte_rrc_SPUCCH_Config_r15 = -1;
static gint ett_lte_rrc_T_setup_138 = -1;
static gint ett_lte_rrc_T_dummy_04 = -1;
static gint ett_lte_rrc_T_n3SPUCCH_AN_List_r15 = -1;
static gint ett_lte_rrc_SPUCCH_Config_v1550 = -1;
static gint ett_lte_rrc_T_setup_139 = -1;
static gint ett_lte_rrc_T_twoAntennaPortActivatedSPUCCH_Format3_v1550 = -1;
static gint ett_lte_rrc_T_n3SPUCCH_AN_List_v1550 = -1;
static gint ett_lte_rrc_SPUCCH_Set_r15 = -1;
static gint ett_lte_rrc_SPUCCH_Elements_r15 = -1;
static gint ett_lte_rrc_T_setup_140 = -1;
static gint ett_lte_rrc_T_n1SubslotSPUCCH_AN_List_r15 = -1;
static gint ett_lte_rrc_SEQUENCE_SIZE_1_2_OF_N4SPUCCH_Resource_r15 = -1;
static gint ett_lte_rrc_N4SPUCCH_Resource_r15 = -1;
static gint ett_lte_rrc_SRS_TPC_PDCCH_Config_r14 = -1;
static gint ett_lte_rrc_T_setup_141 = -1;
static gint ett_lte_rrc_SRS_CC_SetIndex_r14 = -1;
static gint ett_lte_rrc_TDD_Config = -1;
static gint ett_lte_rrc_TDD_Config_v1130 = -1;
static gint ett_lte_rrc_TDD_Config_v1430 = -1;
static gint ett_lte_rrc_TDD_Config_v1450 = -1;
static gint ett_lte_rrc_TDD_ConfigSL_r12 = -1;
static gint ett_lte_rrc_TimeReferenceInfo_r15 = -1;
static gint ett_lte_rrc_ReferenceTime_r15 = -1;
static gint ett_lte_rrc_TPC_PDCCH_Config = -1;
static gint ett_lte_rrc_T_setup_142 = -1;
static gint ett_lte_rrc_TPC_PDCCH_ConfigSCell_r13 = -1;
static gint ett_lte_rrc_T_setup_143 = -1;
static gint ett_lte_rrc_TPC_Index = -1;
static gint ett_lte_rrc_TunnelConfigLWIP_r13 = -1;
static gint ett_lte_rrc_IKE_Identity_r13 = -1;
static gint ett_lte_rrc_IP_Address_r13 = -1;
static gint ett_lte_rrc_UplinkPowerControlCommon = -1;
static gint ett_lte_rrc_UplinkPowerControlCommon_v1020 = -1;
static gint ett_lte_rrc_UplinkPowerControlCommon_v1310 = -1;
static gint ett_lte_rrc_UplinkPowerControlCommon_v1530 = -1;
static gint ett_lte_rrc_UplinkPowerControlCommonPSCell_r12 = -1;
static gint ett_lte_rrc_UplinkPowerControlCommonSCell_r10 = -1;
static gint ett_lte_rrc_UplinkPowerControlCommonSCell_v1130 = -1;
static gint ett_lte_rrc_UplinkPowerControlCommonSCell_v1310 = -1;
static gint ett_lte_rrc_UplinkPowerControlCommonPUSCH_LessCell_v1430 = -1;
static gint ett_lte_rrc_UplinkPowerControlDedicated = -1;
static gint ett_lte_rrc_UplinkPowerControlDedicated_v1020 = -1;
static gint ett_lte_rrc_UplinkPowerControlDedicated_v1130 = -1;
static gint ett_lte_rrc_UplinkPowerControlDedicated_v1250 = -1;
static gint ett_lte_rrc_T_set2PowerControlParameter = -1;
static gint ett_lte_rrc_T_setup_144 = -1;
static gint ett_lte_rrc_UplinkPowerControlDedicated_v1530 = -1;
static gint ett_lte_rrc_UplinkPowerControlDedicatedSTTI_r15 = -1;
static gint ett_lte_rrc_UplinkPUSCH_LessPowerControlDedicated_v1430 = -1;
static gint ett_lte_rrc_UplinkPowerControlDedicatedSCell_r10 = -1;
static gint ett_lte_rrc_UplinkPowerControlDedicatedSCell_v1310 = -1;
static gint ett_lte_rrc_DeltaFList_PUCCH = -1;
static gint ett_lte_rrc_DeltaFList_SPUCCH_r15 = -1;
static gint ett_lte_rrc_T_setup_145 = -1;
static gint ett_lte_rrc_DeltaTxD_OffsetListPUCCH_r10 = -1;
static gint ett_lte_rrc_DeltaTxD_OffsetListPUCCH_v1130 = -1;
static gint ett_lte_rrc_DeltaTxD_OffsetListSPUCCH_r15 = -1;
static gint ett_lte_rrc_WLAN_Id_List_r13 = -1;
static gint ett_lte_rrc_WLAN_MobilityConfig_r13 = -1;
static gint ett_lte_rrc_WUS_Config_r15 = -1;
static gint ett_lte_rrc_WUS_Config_v1560 = -1;
static gint ett_lte_rrc_SecurityAlgorithmConfig = -1;
static gint ett_lte_rrc_CarrierFreqCDMA2000 = -1;
static gint ett_lte_rrc_CarrierFreqGERAN = -1;
static gint ett_lte_rrc_CarrierFreqsGERAN = -1;
static gint ett_lte_rrc_T_followingARFCNs = -1;
static gint ett_lte_rrc_T_equallySpacedARFCNs = -1;
static gint ett_lte_rrc_ExplicitListOfARFCNs = -1;
static gint ett_lte_rrc_CarrierFreqListMBMS_r11 = -1;
static gint ett_lte_rrc_CellIndexList = -1;
static gint ett_lte_rrc_CellSelectionInfoCE_r13 = -1;
static gint ett_lte_rrc_CellSelectionInfoCE_v1530 = -1;
static gint ett_lte_rrc_CellSelectionInfoCE1_r13 = -1;
static gint ett_lte_rrc_CellSelectionInfoCE1_v1360 = -1;
static gint ett_lte_rrc_CSFB_RegistrationParam1XRTT = -1;
static gint ett_lte_rrc_CSFB_RegistrationParam1XRTT_v920 = -1;
static gint ett_lte_rrc_CellGlobalIdEUTRA = -1;
static gint ett_lte_rrc_CellGlobalIdUTRA = -1;
static gint ett_lte_rrc_CellGlobalIdGERAN = -1;
static gint ett_lte_rrc_CellGlobalIdCDMA2000 = -1;
static gint ett_lte_rrc_CellSelectionInfoNFreq_r13 = -1;
static gint ett_lte_rrc_MobilityControlInfo = -1;
static gint ett_lte_rrc_MobilityControlInfo_v10l0 = -1;
static gint ett_lte_rrc_MobilityControlInfoSCG_r12 = -1;
static gint ett_lte_rrc_MobilityControlInfoV2X_r14 = -1;
static gint ett_lte_rrc_CarrierBandwidthEUTRA = -1;
static gint ett_lte_rrc_CarrierFreqEUTRA = -1;
static gint ett_lte_rrc_CarrierFreqEUTRA_v9e0 = -1;
static gint ett_lte_rrc_RACH_Skip_r14 = -1;
static gint ett_lte_rrc_T_targetTA_r14 = -1;
static gint ett_lte_rrc_T_ul_ConfigInfo_r14 = -1;
static gint ett_lte_rrc_MobilityStateParameters = -1;
static gint ett_lte_rrc_MultiBandInfoList = -1;
static gint ett_lte_rrc_MultiBandInfoList_v9e0 = -1;
static gint ett_lte_rrc_MultiBandInfoList_v10j0 = -1;
static gint ett_lte_rrc_MultiBandInfoList_v10l0 = -1;
static gint ett_lte_rrc_MultiBandInfoList_r11 = -1;
static gint ett_lte_rrc_MultiBandInfo_v9e0 = -1;
static gint ett_lte_rrc_MultiFrequencyBandListNR_r15 = -1;
static gint ett_lte_rrc_NS_PmaxList_r10 = -1;
static gint ett_lte_rrc_NS_PmaxList_v10l0 = -1;
static gint ett_lte_rrc_NS_PmaxValue_r10 = -1;
static gint ett_lte_rrc_NS_PmaxValue_v10l0 = -1;
static gint ett_lte_rrc_NS_PmaxListNR_r15 = -1;
static gint ett_lte_rrc_NS_PmaxValueNR_r15 = -1;
static gint ett_lte_rrc_PhysCellIdRange = -1;
static gint ett_lte_rrc_PhysCellIdRangeUTRA_FDDList_r9 = -1;
static gint ett_lte_rrc_PhysCellIdRangeUTRA_FDD_r9 = -1;
static gint ett_lte_rrc_PhysCellIdGERAN = -1;
static gint ett_lte_rrc_PLMN_Identity = -1;
static gint ett_lte_rrc_MCC = -1;
static gint ett_lte_rrc_MNC = -1;
static gint ett_lte_rrc_PLMN_IdentityList3_r11 = -1;
static gint ett_lte_rrc_PreRegistrationInfoHRPD = -1;
static gint ett_lte_rrc_SecondaryPreRegistrationZoneIdListHRPD = -1;
static gint ett_lte_rrc_SpeedStateScaleFactors = -1;
static gint ett_lte_rrc_SystemInfoListGERAN = -1;
static gint ett_lte_rrc_SystemTimeInfoCDMA2000 = -1;
static gint ett_lte_rrc_T_cdma_SystemTime = -1;
static gint ett_lte_rrc_ThresholdNR_r15 = -1;
static gint ett_lte_rrc_ThresholdListNR_r15 = -1;
static gint ett_lte_rrc_BT_NameListConfig_r15 = -1;
static gint ett_lte_rrc_BT_NameList_r15 = -1;
static gint ett_lte_rrc_LocationInfo_r10 = -1;
static gint ett_lte_rrc_T_locationCoordinates_r10 = -1;
static gint ett_lte_rrc_T_verticalVelocityInfo_r15 = -1;
static gint ett_lte_rrc_LogMeasResultListBT_r15 = -1;
static gint ett_lte_rrc_LogMeasResultBT_r15 = -1;
static gint ett_lte_rrc_LogMeasResultListWLAN_r15 = -1;
static gint ett_lte_rrc_LogMeasResultWLAN_r15 = -1;
static gint ett_lte_rrc_MeasConfig = -1;
static gint ett_lte_rrc_T_speedStatePars = -1;
static gint ett_lte_rrc_T_setup_146 = -1;
static gint ett_lte_rrc_T_measScaleFactor_r12 = -1;
static gint ett_lte_rrc_T_heightThreshRef_r15 = -1;
static gint ett_lte_rrc_MeasIdToRemoveList = -1;
static gint ett_lte_rrc_MeasIdToRemoveListExt_r12 = -1;
static gint ett_lte_rrc_MeasObjectToRemoveList = -1;
static gint ett_lte_rrc_MeasObjectToRemoveListExt_r13 = -1;
static gint ett_lte_rrc_ReportConfigToRemoveList = -1;
static gint ett_lte_rrc_MeasDS_Config_r12 = -1;
static gint ett_lte_rrc_T_setup_147 = -1;
static gint ett_lte_rrc_T_dmtc_PeriodOffset_r12 = -1;
static gint ett_lte_rrc_T_ds_OccasionDuration_r12 = -1;
static gint ett_lte_rrc_MeasCSI_RS_ToRemoveList_r12 = -1;
static gint ett_lte_rrc_MeasCSI_RS_ToAddModList_r12 = -1;
static gint ett_lte_rrc_MeasCSI_RS_Config_r12 = -1;
static gint ett_lte_rrc_MeasGapConfig = -1;
static gint ett_lte_rrc_T_setup_148 = -1;
static gint ett_lte_rrc_T_gapOffset = -1;
static gint ett_lte_rrc_MeasGapConfigDensePRS_r15 = -1;
static gint ett_lte_rrc_T_setup_149 = -1;
static gint ett_lte_rrc_T_gapOffsetDensePRS_r15 = -1;
static gint ett_lte_rrc_MeasGapConfigPerCC_List_r14 = -1;
static gint ett_lte_rrc_T_setup_150 = -1;
static gint ett_lte_rrc_MeasGapConfigToRemoveList_r14 = -1;
static gint ett_lte_rrc_MeasGapConfigToAddModList_r14 = -1;
static gint ett_lte_rrc_MeasGapConfigPerCC_r14 = -1;
static gint ett_lte_rrc_MeasGapSharingConfig_r14 = -1;
static gint ett_lte_rrc_T_setup_151 = -1;
static gint ett_lte_rrc_MeasIdleConfigSIB_r15 = -1;
static gint ett_lte_rrc_MeasIdleConfigDedicated_r15 = -1;
static gint ett_lte_rrc_EUTRA_CarrierList_r15 = -1;
static gint ett_lte_rrc_MeasIdleCarrierEUTRA_r15 = -1;
static gint ett_lte_rrc_T_qualityThreshold_r15 = -1;
static gint ett_lte_rrc_CellList_r15 = -1;
static gint ett_lte_rrc_MeasIdToAddModList = -1;
static gint ett_lte_rrc_MeasIdToAddModList_v1310 = -1;
static gint ett_lte_rrc_MeasIdToAddModListExt_r12 = -1;
static gint ett_lte_rrc_MeasIdToAddModListExt_v1310 = -1;
static gint ett_lte_rrc_MeasIdToAddMod = -1;
static gint ett_lte_rrc_MeasIdToAddModExt_r12 = -1;
static gint ett_lte_rrc_MeasIdToAddMod_v1310 = -1;
static gint ett_lte_rrc_MeasObjectCDMA2000 = -1;
static gint ett_lte_rrc_CellsToAddModListCDMA2000 = -1;
static gint ett_lte_rrc_CellsToAddModCDMA2000 = -1;
static gint ett_lte_rrc_MeasObjectEUTRA = -1;
static gint ett_lte_rrc_T_t312_r12 = -1;
static gint ett_lte_rrc_MeasObjectEUTRA_v9e0 = -1;
static gint ett_lte_rrc_CellsToAddModList = -1;
static gint ett_lte_rrc_CellsToAddMod = -1;
static gint ett_lte_rrc_BlackCellsToAddModList = -1;
static gint ett_lte_rrc_BlackCellsToAddMod = -1;
static gint ett_lte_rrc_MeasSubframePatternConfigNeigh_r10 = -1;
static gint ett_lte_rrc_T_setup_153 = -1;
static gint ett_lte_rrc_MeasSubframeCellList_r10 = -1;
static gint ett_lte_rrc_AltTTT_CellsToAddModList_r12 = -1;
static gint ett_lte_rrc_AltTTT_CellsToAddMod_r12 = -1;
static gint ett_lte_rrc_WhiteCellsToAddModList_r13 = -1;
static gint ett_lte_rrc_WhiteCellsToAddMod_r13 = -1;
static gint ett_lte_rrc_RMTC_Config_r13 = -1;
static gint ett_lte_rrc_T_setup_154 = -1;
static gint ett_lte_rrc_Tx_ResourcePoolMeasList_r14 = -1;
static gint ett_lte_rrc_MeasObjectGERAN = -1;
static gint ett_lte_rrc_MeasObjectNR_r15 = -1;
static gint ett_lte_rrc_SEQUENCE_SIZE_1_maxCellSFTD_OF_PhysCellIdNR_r15 = -1;
static gint ett_lte_rrc_T_bandNR_r15 = -1;
static gint ett_lte_rrc_RS_ConfigSSB_NR_r15 = -1;
static gint ett_lte_rrc_T_ssb_ToMeasure_r15 = -1;
static gint ett_lte_rrc_CellsToAddModListNR_r15 = -1;
static gint ett_lte_rrc_CellsToAddModNR_r15 = -1;
static gint ett_lte_rrc_MeasObjectToAddModList = -1;
static gint ett_lte_rrc_MeasObjectToAddModListExt_r13 = -1;
static gint ett_lte_rrc_MeasObjectToAddModList_v9e0 = -1;
static gint ett_lte_rrc_MeasObjectToAddMod = -1;
static gint ett_lte_rrc_T_measObject = -1;
static gint ett_lte_rrc_MeasObjectToAddModExt_r13 = -1;
static gint ett_lte_rrc_T_measObject_r13 = -1;
static gint ett_lte_rrc_MeasObjectToAddMod_v9e0 = -1;
static gint ett_lte_rrc_MeasObjectUTRA = -1;
static gint ett_lte_rrc_T_cellsToAddModList = -1;
static gint ett_lte_rrc_T_cellForWhichToReportCGI = -1;
static gint ett_lte_rrc_CellsToAddModListUTRA_FDD = -1;
static gint ett_lte_rrc_CellsToAddModUTRA_FDD = -1;
static gint ett_lte_rrc_CellsToAddModListUTRA_TDD = -1;
static gint ett_lte_rrc_CellsToAddModUTRA_TDD = -1;
static gint ett_lte_rrc_CSG_AllowedReportingCells_r9 = -1;
static gint ett_lte_rrc_MeasObjectWLAN_r13 = -1;
static gint ett_lte_rrc_T_carrierFreq_r13 = -1;
static gint ett_lte_rrc_SEQUENCE_SIZE_1_maxWLAN_Bands_r13_OF_WLAN_BandIndicator_r13 = -1;
static gint ett_lte_rrc_SEQUENCE_SIZE_1_maxWLAN_CarrierInfo_r13_OF_WLAN_CarrierInfo_r13 = -1;
static gint ett_lte_rrc_MeasResults = -1;
static gint ett_lte_rrc_T_measResultPCell = -1;
static gint ett_lte_rrc_T_measResultNeighCells = -1;
static gint ett_lte_rrc_T_measResultPCell_v1310 = -1;
static gint ett_lte_rrc_MeasResultListEUTRA = -1;
static gint ett_lte_rrc_MeasResultEUTRA = -1;
static gint ett_lte_rrc_T_cgi_Info = -1;
static gint ett_lte_rrc_T_measResult = -1;
static gint ett_lte_rrc_T_cgi_Info_v1310 = -1;
static gint ett_lte_rrc_MeasResultListIdle_r15 = -1;
static gint ett_lte_rrc_MeasResultIdle_r15 = -1;
static gint ett_lte_rrc_T_measResultServingCell_r15 = -1;
static gint ett_lte_rrc_T_measResultNeighCells_r15 = -1;
static gint ett_lte_rrc_MeasResultIdleListEUTRA_r15 = -1;
static gint ett_lte_rrc_MeasResultIdleEUTRA_r15 = -1;
static gint ett_lte_rrc_T_measResult_r15 = -1;
static gint ett_lte_rrc_MeasResultServFreqListNR_r15 = -1;
static gint ett_lte_rrc_MeasResultServFreqNR_r15 = -1;
static gint ett_lte_rrc_MeasResultCellListNR_r15 = -1;
static gint ett_lte_rrc_MeasResultCellNR_r15 = -1;
static gint ett_lte_rrc_MeasResultNR_r15 = -1;
static gint ett_lte_rrc_MeasResultSSB_IndexList_r15 = -1;
static gint ett_lte_rrc_MeasResultSSB_Index_r15 = -1;
static gint ett_lte_rrc_MeasResultServFreqList_r10 = -1;
static gint ett_lte_rrc_MeasResultServFreqListExt_r13 = -1;
static gint ett_lte_rrc_MeasResultServFreq_r10 = -1;
static gint ett_lte_rrc_T_measResultSCell_r10 = -1;
static gint ett_lte_rrc_T_measResultBestNeighCell_r10 = -1;
static gint ett_lte_rrc_T_measResultSCell_v1310_01 = -1;
static gint ett_lte_rrc_T_measResultBestNeighCell_v1310 = -1;
static gint ett_lte_rrc_MeasResultServFreq_r13 = -1;
static gint ett_lte_rrc_T_measResultSCell_r13 = -1;
static gint ett_lte_rrc_T_measResultBestNeighCell_r13 = -1;
static gint ett_lte_rrc_T_measResultBestNeighCell_v1360 = -1;
static gint ett_lte_rrc_MeasResultCSI_RS_List_r12 = -1;
static gint ett_lte_rrc_MeasResultCSI_RS_r12 = -1;
static gint ett_lte_rrc_MeasResultListUTRA = -1;
static gint ett_lte_rrc_MeasResultUTRA = -1;
static gint ett_lte_rrc_T_physCellId = -1;
static gint ett_lte_rrc_T_cgi_Info_01 = -1;
static gint ett_lte_rrc_T_measResult_01 = -1;
static gint ett_lte_rrc_MeasResultListGERAN = -1;
static gint ett_lte_rrc_MeasResultGERAN = -1;
static gint ett_lte_rrc_T_cgi_Info_02 = -1;
static gint ett_lte_rrc_T_measResult_02 = -1;
static gint ett_lte_rrc_MeasResultsCDMA2000 = -1;
static gint ett_lte_rrc_MeasResultListCDMA2000 = -1;
static gint ett_lte_rrc_MeasResultCDMA2000 = -1;
static gint ett_lte_rrc_T_measResult_03 = -1;
static gint ett_lte_rrc_MeasResultListWLAN_r13 = -1;
static gint ett_lte_rrc_MeasResultListWLAN_r14 = -1;
static gint ett_lte_rrc_MeasResultWLAN_r13 = -1;
static gint ett_lte_rrc_MeasResultListCBR_r14 = -1;
static gint ett_lte_rrc_MeasResultCBR_r14 = -1;
static gint ett_lte_rrc_MeasResultSensing_r15 = -1;
static gint ett_lte_rrc_SEQUENCE_SIZE_0_400_OF_SensingResult_r15 = -1;
static gint ett_lte_rrc_SensingResult_r15 = -1;
static gint ett_lte_rrc_MeasResultForECID_r9 = -1;
static gint ett_lte_rrc_PLMN_IdentityList2 = -1;
static gint ett_lte_rrc_AdditionalSI_Info_r9 = -1;
static gint ett_lte_rrc_MeasResultForRSSI_r13 = -1;
static gint ett_lte_rrc_UL_PDCP_DelayResultList_r13 = -1;
static gint ett_lte_rrc_UL_PDCP_DelayResult_r13 = -1;
static gint ett_lte_rrc_CGI_InfoNR_r15 = -1;
static gint ett_lte_rrc_T_noSIB1_r15 = -1;
static gint ett_lte_rrc_PLMN_IdentityListNR_r15 = -1;
static gint ett_lte_rrc_PLMN_IdentityInfoListNR_r15 = -1;
static gint ett_lte_rrc_PLMN_IdentityInfoNR_r15 = -1;
static gint ett_lte_rrc_MeasResultCellListSFTD_r15 = -1;
static gint ett_lte_rrc_MeasResultCellSFTD_r15 = -1;
static gint ett_lte_rrc_MeasResultSCG_FailureMRDC_r15 = -1;
static gint ett_lte_rrc_MeasResultList3EUTRA_r15 = -1;
static gint ett_lte_rrc_MeasResult3EUTRA_r15 = -1;
static gint ett_lte_rrc_MeasResultSSTD_r13 = -1;
static gint ett_lte_rrc_MeasSensing_Config_r15 = -1;
static gint ett_lte_rrc_MTC_SSB_NR_r15 = -1;
static gint ett_lte_rrc_T_periodicityAndOffset_r15 = -1;
static gint ett_lte_rrc_QuantityConfig = -1;
static gint ett_lte_rrc_QuantityConfigEUTRA = -1;
static gint ett_lte_rrc_QuantityConfigEUTRA_v1250 = -1;
static gint ett_lte_rrc_QuantityConfigEUTRA_v1310 = -1;
static gint ett_lte_rrc_QuantityConfigUTRA = -1;
static gint ett_lte_rrc_QuantityConfigUTRA_v1020 = -1;
static gint ett_lte_rrc_QuantityConfigGERAN = -1;
static gint ett_lte_rrc_QuantityConfigCDMA2000 = -1;
static gint ett_lte_rrc_QuantityConfigNRList_r15 = -1;
static gint ett_lte_rrc_QuantityConfigNR_r15 = -1;
static gint ett_lte_rrc_QuantityConfigRS_NR_r15 = -1;
static gint ett_lte_rrc_QuantityConfigWLAN_r13 = -1;
static gint ett_lte_rrc_ReportConfigEUTRA = -1;
static gint ett_lte_rrc_T_triggerType = -1;
static gint ett_lte_rrc_T_event = -1;
static gint ett_lte_rrc_T_eventId = -1;
static gint ett_lte_rrc_T_eventA1 = -1;
static gint ett_lte_rrc_T_eventA2 = -1;
static gint ett_lte_rrc_T_eventA3 = -1;
static gint ett_lte_rrc_T_eventA4 = -1;
static gint ett_lte_rrc_T_eventA5 = -1;
static gint ett_lte_rrc_T_eventA6_r10 = -1;
static gint ett_lte_rrc_T_eventC1_r12 = -1;
static gint ett_lte_rrc_T_eventC2_r12 = -1;
static gint ett_lte_rrc_T_eventV1_r14 = -1;
static gint ett_lte_rrc_T_eventV2_r14 = -1;
static gint ett_lte_rrc_T_eventH1_r15 = -1;
static gint ett_lte_rrc_T_eventH2_r15 = -1;
static gint ett_lte_rrc_T_periodical = -1;
static gint ett_lte_rrc_T_alternativeTimeToTrigger_r12 = -1;
static gint ett_lte_rrc_T_rs_sinr_Config_r13 = -1;
static gint ett_lte_rrc_T_setup_155 = -1;
static gint ett_lte_rrc_RSRQ_RangeConfig_r12 = -1;
static gint ett_lte_rrc_ThresholdEUTRA = -1;
static gint ett_lte_rrc_MeasRSSI_ReportConfig_r13 = -1;
static gint ett_lte_rrc_ReportConfigInterRAT = -1;
static gint ett_lte_rrc_T_triggerType_01 = -1;
static gint ett_lte_rrc_T_event_01 = -1;
static gint ett_lte_rrc_T_eventId_01 = -1;
static gint ett_lte_rrc_T_eventB1 = -1;
static gint ett_lte_rrc_T_b1_Threshold = -1;
static gint ett_lte_rrc_T_eventB2 = -1;
static gint ett_lte_rrc_T_b2_Threshold2 = -1;
static gint ett_lte_rrc_T_eventW1_r13 = -1;
static gint ett_lte_rrc_T_eventW2_r13 = -1;
static gint ett_lte_rrc_T_eventW3_r13 = -1;
static gint ett_lte_rrc_T_eventB1_NR_r15 = -1;
static gint ett_lte_rrc_T_eventB2_NR_r15 = -1;
static gint ett_lte_rrc_T_periodical_01 = -1;
static gint ett_lte_rrc_T_b2_Threshold1_v1250 = -1;
static gint ett_lte_rrc_ThresholdUTRA = -1;
static gint ett_lte_rrc_ReportQuantityNR_r15 = -1;
static gint ett_lte_rrc_ReportQuantityWLAN_r13 = -1;
static gint ett_lte_rrc_ReportConfigToAddModList = -1;
static gint ett_lte_rrc_ReportConfigToAddMod = -1;
static gint ett_lte_rrc_T_reportConfig = -1;
static gint ett_lte_rrc_RSRQ_Type_r12 = -1;
static gint ett_lte_rrc_SS_RSSI_Measurement_r15 = -1;
static gint ett_lte_rrc_SSB_ToMeasure_r15 = -1;
static gint ett_lte_rrc_UL_DelayConfig_r13 = -1;
static gint ett_lte_rrc_T_setup_156 = -1;
static gint ett_lte_rrc_WLAN_CarrierInfo_r13 = -1;
static gint ett_lte_rrc_WLAN_ChannelList_r13 = -1;
static gint ett_lte_rrc_WLAN_NameListConfig_r15 = -1;
static gint ett_lte_rrc_WLAN_NameList_r15 = -1;
static gint ett_lte_rrc_WLAN_RTT_r15 = -1;
static gint ett_lte_rrc_WLAN_SuspendConfig_r14 = -1;
static gint ett_lte_rrc_AreaConfiguration_r10 = -1;
static gint ett_lte_rrc_AreaConfiguration_v1130 = -1;
static gint ett_lte_rrc_CellGlobalIdList_r10 = -1;
static gint ett_lte_rrc_TrackingAreaCodeList_r10 = -1;
static gint ett_lte_rrc_TrackingAreaCodeList_v1130 = -1;
static gint ett_lte_rrc_SEQUENCE_SIZE_1_8_OF_PLMN_Identity = -1;
static gint ett_lte_rrc_BandCombinationList_r14 = -1;
static gint ett_lte_rrc_BandCombination_r14 = -1;
static gint ett_lte_rrc_BandIndication_r14 = -1;
static gint ett_lte_rrc_FlightPathInfoReportConfig_r15 = -1;
static gint ett_lte_rrc_GNSS_ID_r15 = -1;
static gint ett_lte_rrc_MeasSubframePattern_r10 = -1;
static gint ett_lte_rrc_T_subframePatternTDD_r10 = -1;
static gint ett_lte_rrc_OtherConfig_r9 = -1;
static gint ett_lte_rrc_T_delayBudgetReportingConfig_r14 = -1;
static gint ett_lte_rrc_T_setup_157 = -1;
static gint ett_lte_rrc_T_rlm_ReportConfig_r14 = -1;
static gint ett_lte_rrc_T_setup_158 = -1;
static gint ett_lte_rrc_T_overheatingAssistanceConfig_r14 = -1;
static gint ett_lte_rrc_T_setup_159 = -1;
static gint ett_lte_rrc_T_measConfigAppLayer_r15 = -1;
static gint ett_lte_rrc_T_setup_160 = -1;
static gint ett_lte_rrc_IDC_Config_r11 = -1;
static gint ett_lte_rrc_T_autonomousDenialParameters_r11 = -1;
static gint ett_lte_rrc_T_idc_Indication_MRDC_r15 = -1;
static gint ett_lte_rrc_ObtainLocationConfig_r11 = -1;
static gint ett_lte_rrc_PowerPrefIndicationConfig_r11 = -1;
static gint ett_lte_rrc_T_setup_161 = -1;
static gint ett_lte_rrc_ReportProximityConfig_r9 = -1;
static gint ett_lte_rrc_CandidateServingFreqListNR_r15 = -1;
static gint ett_lte_rrc_SBAS_ID_r15 = -1;
static gint ett_lte_rrc_S_NSSAI_r15 = -1;
static gint ett_lte_rrc_S_TMSI = -1;
static gint ett_lte_rrc_TraceReference_r10 = -1;
static gint ett_lte_rrc_UE_CapabilityRAT_ContainerList = -1;
static gint ett_lte_rrc_UE_CapabilityRAT_Container = -1;
static gint ett_lte_rrc_UE_EUTRA_Capability = -1;
static gint ett_lte_rrc_T_interRAT_Parameters = -1;
static gint ett_lte_rrc_UE_EUTRA_Capability_v9a0_IEs = -1;
static gint ett_lte_rrc_UE_EUTRA_Capability_v9c0_IEs = -1;
static gint ett_lte_rrc_UE_EUTRA_Capability_v9d0_IEs = -1;
static gint ett_lte_rrc_UE_EUTRA_Capability_v9e0_IEs = -1;
static gint ett_lte_rrc_UE_EUTRA_Capability_v9h0_IEs = -1;
static gint ett_lte_rrc_UE_EUTRA_Capability_v10c0_IEs = -1;
static gint ett_lte_rrc_UE_EUTRA_Capability_v10f0_IEs = -1;
static gint ett_lte_rrc_UE_EUTRA_Capability_v10i0_IEs = -1;
static gint ett_lte_rrc_UE_EUTRA_Capability_v10j0_IEs = -1;
static gint ett_lte_rrc_T_nonCriticalExtension_76 = -1;
static gint ett_lte_rrc_UE_EUTRA_Capability_v11d0_IEs = -1;
static gint ett_lte_rrc_UE_EUTRA_Capability_v11x0_IEs = -1;
static gint ett_lte_rrc_UE_EUTRA_Capability_v12b0_IEs = -1;
static gint ett_lte_rrc_UE_EUTRA_Capability_v12x0_IEs = -1;
static gint ett_lte_rrc_UE_EUTRA_Capability_v1370_IEs = -1;
static gint ett_lte_rrc_UE_EUTRA_Capability_v1380_IEs = -1;
static gint ett_lte_rrc_UE_EUTRA_Capability_v1390_IEs = -1;
static gint ett_lte_rrc_UE_EUTRA_Capability_v13e0a_IEs = -1;
static gint ett_lte_rrc_UE_EUTRA_Capability_v13e0b_IEs = -1;
static gint ett_lte_rrc_T_nonCriticalExtension_77 = -1;
static gint ett_lte_rrc_UE_EUTRA_Capability_v1470_IEs = -1;
static gint ett_lte_rrc_UE_EUTRA_Capability_v14a0_IEs = -1;
static gint ett_lte_rrc_UE_EUTRA_Capability_v14b0_IEs = -1;
static gint ett_lte_rrc_T_nonCriticalExtension_78 = -1;
static gint ett_lte_rrc_UE_EUTRA_Capability_v920_IEs = -1;
static gint ett_lte_rrc_UE_EUTRA_Capability_v940_IEs = -1;
static gint ett_lte_rrc_UE_EUTRA_Capability_v1020_IEs = -1;
static gint ett_lte_rrc_UE_EUTRA_Capability_v1060_IEs = -1;
static gint ett_lte_rrc_UE_EUTRA_Capability_v1090_IEs = -1;
static gint ett_lte_rrc_UE_EUTRA_Capability_v1130_IEs = -1;
static gint ett_lte_rrc_UE_EUTRA_Capability_v1170_IEs = -1;
static gint ett_lte_rrc_UE_EUTRA_Capability_v1180_IEs = -1;
static gint ett_lte_rrc_UE_EUTRA_Capability_v11a0_IEs = -1;
static gint ett_lte_rrc_UE_EUTRA_Capability_v1250_IEs = -1;
static gint ett_lte_rrc_UE_EUTRA_Capability_v1260_IEs = -1;
static gint ett_lte_rrc_UE_EUTRA_Capability_v1270_IEs = -1;
static gint ett_lte_rrc_UE_EUTRA_Capability_v1280_IEs = -1;
static gint ett_lte_rrc_UE_EUTRA_Capability_v1310_IEs = -1;
static gint ett_lte_rrc_UE_EUTRA_Capability_v1320_IEs = -1;
static gint ett_lte_rrc_UE_EUTRA_Capability_v1330_IEs = -1;
static gint ett_lte_rrc_UE_EUTRA_Capability_v1340_IEs = -1;
static gint ett_lte_rrc_UE_EUTRA_Capability_v1350_IEs = -1;
static gint ett_lte_rrc_UE_EUTRA_Capability_v1360_IEs = -1;
static gint ett_lte_rrc_UE_EUTRA_Capability_v1430_IEs = -1;
static gint ett_lte_rrc_UE_EUTRA_Capability_v1440_IEs = -1;
static gint ett_lte_rrc_UE_EUTRA_Capability_v1450_IEs = -1;
static gint ett_lte_rrc_UE_EUTRA_Capability_v1460_IEs = -1;
static gint ett_lte_rrc_UE_EUTRA_Capability_v1510_IEs = -1;
static gint ett_lte_rrc_UE_EUTRA_Capability_v1520_IEs = -1;
static gint ett_lte_rrc_UE_EUTRA_Capability_v1530_IEs = -1;
static gint ett_lte_rrc_UE_EUTRA_Capability_v1540_IEs = -1;
static gint ett_lte_rrc_UE_EUTRA_Capability_v1550_IEs = -1;
static gint ett_lte_rrc_UE_EUTRA_Capability_v1560_IEs = -1;
static gint ett_lte_rrc_UE_EUTRA_Capability_v1570_IEs = -1;
static gint ett_lte_rrc_T_nonCriticalExtension_79 = -1;
static gint ett_lte_rrc_UE_EUTRA_CapabilityAddXDD_Mode_r9 = -1;
static gint ett_lte_rrc_UE_EUTRA_CapabilityAddXDD_Mode_v1060 = -1;
static gint ett_lte_rrc_UE_EUTRA_CapabilityAddXDD_Mode_v1130 = -1;
static gint ett_lte_rrc_UE_EUTRA_CapabilityAddXDD_Mode_v1180 = -1;
static gint ett_lte_rrc_UE_EUTRA_CapabilityAddXDD_Mode_v1250 = -1;
static gint ett_lte_rrc_UE_EUTRA_CapabilityAddXDD_Mode_v1310 = -1;
static gint ett_lte_rrc_UE_EUTRA_CapabilityAddXDD_Mode_v1320 = -1;
static gint ett_lte_rrc_UE_EUTRA_CapabilityAddXDD_Mode_v1370 = -1;
static gint ett_lte_rrc_UE_EUTRA_CapabilityAddXDD_Mode_v1380 = -1;
static gint ett_lte_rrc_UE_EUTRA_CapabilityAddXDD_Mode_v1430 = -1;
static gint ett_lte_rrc_UE_EUTRA_CapabilityAddXDD_Mode_v1510 = -1;
static gint ett_lte_rrc_UE_EUTRA_CapabilityAddXDD_Mode_v1530 = -1;
static gint ett_lte_rrc_UE_EUTRA_CapabilityAddXDD_Mode_v1540 = -1;
static gint ett_lte_rrc_UE_EUTRA_CapabilityAddXDD_Mode_v1550 = -1;
static gint ett_lte_rrc_UE_EUTRA_CapabilityAddXDD_Mode_v1560 = -1;
static gint ett_lte_rrc_FeatureSetsEUTRA_r15 = -1;
static gint ett_lte_rrc_SEQUENCE_SIZE_1_maxFeatureSets_r15_OF_FeatureSetDL_r15 = -1;
static gint ett_lte_rrc_SEQUENCE_SIZE_1_maxPerCC_FeatureSets_r15_OF_FeatureSetDL_PerCC_r15 = -1;
static gint ett_lte_rrc_SEQUENCE_SIZE_1_maxFeatureSets_r15_OF_FeatureSetUL_r15 = -1;
static gint ett_lte_rrc_SEQUENCE_SIZE_1_maxPerCC_FeatureSets_r15_OF_FeatureSetUL_PerCC_r15 = -1;
static gint ett_lte_rrc_SEQUENCE_SIZE_1_maxFeatureSets_r15_OF_FeatureSetDL_v1550 = -1;
static gint ett_lte_rrc_MobilityParameters_r14 = -1;
static gint ett_lte_rrc_DC_Parameters_r12 = -1;
static gint ett_lte_rrc_DC_Parameters_v1310 = -1;
static gint ett_lte_rrc_MAC_Parameters_r12 = -1;
static gint ett_lte_rrc_MAC_Parameters_v1310 = -1;
static gint ett_lte_rrc_MAC_Parameters_v1430 = -1;
static gint ett_lte_rrc_MAC_Parameters_v1440 = -1;
static gint ett_lte_rrc_MAC_Parameters_v1530 = -1;
static gint ett_lte_rrc_SEQUENCE_SIZE_1_3_OF_ProcessingTimelineSet_r15 = -1;
static gint ett_lte_rrc_MAC_Parameters_v1550 = -1;
static gint ett_lte_rrc_RLC_Parameters_r12 = -1;
static gint ett_lte_rrc_RLC_Parameters_v1310 = -1;
static gint ett_lte_rrc_RLC_Parameters_v1430 = -1;
static gint ett_lte_rrc_RLC_Parameters_v1530 = -1;
static gint ett_lte_rrc_PDCP_Parameters = -1;
static gint ett_lte_rrc_PDCP_Parameters_v1130 = -1;
static gint ett_lte_rrc_PDCP_Parameters_v1310 = -1;
static gint ett_lte_rrc_PDCP_Parameters_v1430 = -1;
static gint ett_lte_rrc_T_supportedUplinkOnlyROHC_Profiles_r14 = -1;
static gint ett_lte_rrc_PDCP_Parameters_v1530 = -1;
static gint ett_lte_rrc_SupportedUDC_r15 = -1;
static gint ett_lte_rrc_SupportedOperatorDic_r15 = -1;
static gint ett_lte_rrc_PhyLayerParameters = -1;
static gint ett_lte_rrc_PhyLayerParameters_v920 = -1;
static gint ett_lte_rrc_PhyLayerParameters_v9d0 = -1;
static gint ett_lte_rrc_PhyLayerParameters_v1020 = -1;
static gint ett_lte_rrc_PhyLayerParameters_v1130 = -1;
static gint ett_lte_rrc_PhyLayerParameters_v1170 = -1;
static gint ett_lte_rrc_PhyLayerParameters_v1250 = -1;
static gint ett_lte_rrc_PhyLayerParameters_v1280 = -1;
static gint ett_lte_rrc_PhyLayerParameters_v1310 = -1;
static gint ett_lte_rrc_T_supportedBlindDecoding_r13 = -1;
static gint ett_lte_rrc_PhyLayerParameters_v1320 = -1;
static gint ett_lte_rrc_PhyLayerParameters_v1330 = -1;
static gint ett_lte_rrc_PhyLayerParameters_v13e0 = -1;
static gint ett_lte_rrc_PhyLayerParameters_v1430 = -1;
static gint ett_lte_rrc_PhyLayerParameters_v1450 = -1;
static gint ett_lte_rrc_PhyLayerParameters_v1470 = -1;
static gint ett_lte_rrc_PhyLayerParameters_v14a0 = -1;
static gint ett_lte_rrc_PhyLayerParameters_v1530 = -1;
static gint ett_lte_rrc_T_stti_SPT_Capabilities_r15 = -1;
static gint ett_lte_rrc_T_ce_Capabilities_r15 = -1;
static gint ett_lte_rrc_T_urllc_Capabilities_r15 = -1;
static gint ett_lte_rrc_PhyLayerParameters_v1540 = -1;
static gint ett_lte_rrc_T_stti_SPT_Capabilities_v1540 = -1;
static gint ett_lte_rrc_PhyLayerParameters_v1550 = -1;
static gint ett_lte_rrc_MIMO_UE_Parameters_r13 = -1;
static gint ett_lte_rrc_MIMO_UE_Parameters_v13e0 = -1;
static gint ett_lte_rrc_MIMO_UE_Parameters_v1430 = -1;
static gint ett_lte_rrc_MIMO_UE_Parameters_v1470 = -1;
static gint ett_lte_rrc_MIMO_UE_ParametersPerTM_r13 = -1;
static gint ett_lte_rrc_MIMO_UE_ParametersPerTM_v1430 = -1;
static gint ett_lte_rrc_T_nzp_CSI_RS_AperiodicInfo_r14 = -1;
static gint ett_lte_rrc_T_nzp_CSI_RS_PeriodicInfo_r14 = -1;
static gint ett_lte_rrc_MIMO_UE_ParametersPerTM_v1470 = -1;
static gint ett_lte_rrc_MIMO_CA_ParametersPerBoBC_r13 = -1;
static gint ett_lte_rrc_MIMO_CA_ParametersPerBoBC_r15 = -1;
static gint ett_lte_rrc_MIMO_CA_ParametersPerBoBC_v1430 = -1;
static gint ett_lte_rrc_MIMO_CA_ParametersPerBoBC_v1470 = -1;
static gint ett_lte_rrc_MIMO_CA_ParametersPerBoBCPerTM_r13 = -1;
static gint ett_lte_rrc_MIMO_CA_ParametersPerBoBCPerTM_v1430 = -1;
static gint ett_lte_rrc_MIMO_CA_ParametersPerBoBCPerTM_v1470 = -1;
static gint ett_lte_rrc_MIMO_CA_ParametersPerBoBCPerTM_r15 = -1;
static gint ett_lte_rrc_MIMO_NonPrecodedCapabilities_r13 = -1;
static gint ett_lte_rrc_MIMO_UE_BeamformedCapabilities_r13 = -1;
static gint ett_lte_rrc_MIMO_BeamformedCapabilityList_r13 = -1;
static gint ett_lte_rrc_MIMO_BeamformedCapabilities_r13 = -1;
static gint ett_lte_rrc_MIMO_WeightedLayersCapabilities_r13 = -1;
static gint ett_lte_rrc_NonContiguousUL_RA_WithinCC_List_r10 = -1;
static gint ett_lte_rrc_NonContiguousUL_RA_WithinCC_r10 = -1;
static gint ett_lte_rrc_RF_Parameters = -1;
static gint ett_lte_rrc_RF_Parameters_v9e0 = -1;
static gint ett_lte_rrc_RF_Parameters_v1020 = -1;
static gint ett_lte_rrc_RF_Parameters_v1060 = -1;
static gint ett_lte_rrc_RF_Parameters_v1090 = -1;
static gint ett_lte_rrc_RF_Parameters_v10f0 = -1;
static gint ett_lte_rrc_RF_Parameters_v10i0 = -1;
static gint ett_lte_rrc_RF_Parameters_v10j0 = -1;
static gint ett_lte_rrc_RF_Parameters_v1130 = -1;
static gint ett_lte_rrc_RF_Parameters_v1180 = -1;
static gint ett_lte_rrc_RF_Parameters_v11d0 = -1;
static gint ett_lte_rrc_RF_Parameters_v1250 = -1;
static gint ett_lte_rrc_RF_Parameters_v1270 = -1;
static gint ett_lte_rrc_RF_Parameters_v1310 = -1;
static gint ett_lte_rrc_T_eNB_RequestedParameters_r13 = -1;
static gint ett_lte_rrc_RF_Parameters_v1320 = -1;
static gint ett_lte_rrc_RF_Parameters_v1380 = -1;
static gint ett_lte_rrc_RF_Parameters_v1390 = -1;
static gint ett_lte_rrc_RF_Parameters_v12b0 = -1;
static gint ett_lte_rrc_RF_Parameters_v1430 = -1;
static gint ett_lte_rrc_T_eNB_RequestedParameters_v1430 = -1;
static gint ett_lte_rrc_RF_Parameters_v1450 = -1;
static gint ett_lte_rrc_RF_Parameters_v1470 = -1;
static gint ett_lte_rrc_RF_Parameters_v14b0 = -1;
static gint ett_lte_rrc_RF_Parameters_v1530 = -1;
static gint ett_lte_rrc_RF_Parameters_v1570 = -1;
static gint ett_lte_rrc_SkipSubframeProcessing_r15 = -1;
static gint ett_lte_rrc_SPT_Parameters_r15 = -1;
static gint ett_lte_rrc_STTI_SPT_BandParameters_r15 = -1;
static gint ett_lte_rrc_STTI_SupportedCombinations_r15 = -1;
static gint ett_lte_rrc_SEQUENCE_SIZE_1_2_OF_DL_UL_CCs_r15 = -1;
static gint ett_lte_rrc_DL_UL_CCs_r15 = -1;
static gint ett_lte_rrc_SupportedBandCombination_r10 = -1;
static gint ett_lte_rrc_SupportedBandCombinationExt_r10 = -1;
static gint ett_lte_rrc_SupportedBandCombination_v1090 = -1;
static gint ett_lte_rrc_SupportedBandCombination_v10i0 = -1;
static gint ett_lte_rrc_SupportedBandCombination_v1130 = -1;
static gint ett_lte_rrc_SupportedBandCombination_v1250 = -1;
static gint ett_lte_rrc_SupportedBandCombination_v1270 = -1;
static gint ett_lte_rrc_SupportedBandCombination_v1320 = -1;
static gint ett_lte_rrc_SupportedBandCombination_v1380 = -1;
static gint ett_lte_rrc_SupportedBandCombination_v1390 = -1;
static gint ett_lte_rrc_SupportedBandCombination_v1430 = -1;
static gint ett_lte_rrc_SupportedBandCombination_v1450 = -1;
static gint ett_lte_rrc_SupportedBandCombination_v1470 = -1;
static gint ett_lte_rrc_SupportedBandCombination_v14b0 = -1;
static gint ett_lte_rrc_SupportedBandCombination_v1530 = -1;
static gint ett_lte_rrc_SupportedBandCombinationAdd_r11 = -1;
static gint ett_lte_rrc_SupportedBandCombinationAdd_v11d0 = -1;
static gint ett_lte_rrc_SupportedBandCombinationAdd_v1250 = -1;
static gint ett_lte_rrc_SupportedBandCombinationAdd_v1270 = -1;
static gint ett_lte_rrc_SupportedBandCombinationAdd_v1320 = -1;
static gint ett_lte_rrc_SupportedBandCombinationAdd_v1380 = -1;
static gint ett_lte_rrc_SupportedBandCombinationAdd_v1390 = -1;
static gint ett_lte_rrc_SupportedBandCombinationAdd_v1430 = -1;
static gint ett_lte_rrc_SupportedBandCombinationAdd_v1450 = -1;
static gint ett_lte_rrc_SupportedBandCombinationAdd_v1470 = -1;
static gint ett_lte_rrc_SupportedBandCombinationAdd_v14b0 = -1;
static gint ett_lte_rrc_SupportedBandCombinationAdd_v1530 = -1;
static gint ett_lte_rrc_SupportedBandCombinationReduced_r13 = -1;
static gint ett_lte_rrc_SupportedBandCombinationReduced_v1320 = -1;
static gint ett_lte_rrc_SupportedBandCombinationReduced_v1380 = -1;
static gint ett_lte_rrc_SupportedBandCombinationReduced_v1390 = -1;
static gint ett_lte_rrc_SupportedBandCombinationReduced_v1430 = -1;
static gint ett_lte_rrc_SupportedBandCombinationReduced_v1450 = -1;
static gint ett_lte_rrc_SupportedBandCombinationReduced_v1470 = -1;
static gint ett_lte_rrc_SupportedBandCombinationReduced_v14b0 = -1;
static gint ett_lte_rrc_SupportedBandCombinationReduced_v1530 = -1;
static gint ett_lte_rrc_BandCombinationParameters_r10 = -1;
static gint ett_lte_rrc_BandCombinationParametersExt_r10 = -1;
static gint ett_lte_rrc_BandCombinationParameters_v1090 = -1;
static gint ett_lte_rrc_BandCombinationParameters_v10i0 = -1;
static gint ett_lte_rrc_SEQUENCE_SIZE_1_maxSimultaneousBands_r10_OF_BandParameters_v10i0 = -1;
static gint ett_lte_rrc_BandCombinationParameters_v1130 = -1;
static gint ett_lte_rrc_SEQUENCE_SIZE_1_maxSimultaneousBands_r10_OF_BandParameters_v1130 = -1;
static gint ett_lte_rrc_BandCombinationParameters_r11 = -1;
static gint ett_lte_rrc_SEQUENCE_SIZE_1_maxSimultaneousBands_r10_OF_BandParameters_r11 = -1;
static gint ett_lte_rrc_BandCombinationParameters_v1250 = -1;
static gint ett_lte_rrc_T_dc_Support_r12 = -1;
static gint ett_lte_rrc_T_supportedCellGrouping_r12 = -1;
static gint ett_lte_rrc_BandCombinationParameters_v1270 = -1;
static gint ett_lte_rrc_SEQUENCE_SIZE_1_maxSimultaneousBands_r10_OF_BandParameters_v1270 = -1;
static gint ett_lte_rrc_BandCombinationParameters_r13 = -1;
static gint ett_lte_rrc_SEQUENCE_SIZE_1_maxSimultaneousBands_r10_OF_BandParameters_r13 = -1;
static gint ett_lte_rrc_T_dc_Support_r13 = -1;
static gint ett_lte_rrc_T_supportedCellGrouping_r13 = -1;
static gint ett_lte_rrc_BandCombinationParameters_v1320 = -1;
static gint ett_lte_rrc_SEQUENCE_SIZE_1_maxSimultaneousBands_r10_OF_BandParameters_v1320 = -1;
static gint ett_lte_rrc_BandCombinationParameters_v1380 = -1;
static gint ett_lte_rrc_SEQUENCE_SIZE_1_maxSimultaneousBands_r10_OF_BandParameters_v1380 = -1;
static gint ett_lte_rrc_BandCombinationParameters_v1390 = -1;
static gint ett_lte_rrc_BandCombinationParameters_v1430 = -1;
static gint ett_lte_rrc_SEQUENCE_SIZE_1_maxSimultaneousBands_r10_OF_BandParameters_v1430 = -1;
static gint ett_lte_rrc_BandCombinationParameters_v1450 = -1;
static gint ett_lte_rrc_SEQUENCE_SIZE_1_maxSimultaneousBands_r10_OF_BandParameters_v1450 = -1;
static gint ett_lte_rrc_BandCombinationParameters_v1470 = -1;
static gint ett_lte_rrc_SEQUENCE_SIZE_1_maxSimultaneousBands_r10_OF_BandParameters_v1470 = -1;
static gint ett_lte_rrc_BandCombinationParameters_v14b0 = -1;
static gint ett_lte_rrc_SEQUENCE_SIZE_1_maxSimultaneousBands_r10_OF_BandParameters_v14b0 = -1;
static gint ett_lte_rrc_BandCombinationParameters_v1530 = -1;
static gint ett_lte_rrc_SEQUENCE_SIZE_1_maxSimultaneousBands_r10_OF_BandParameters_v1530 = -1;
static gint ett_lte_rrc_BandParameters_r10 = -1;
static gint ett_lte_rrc_BandParameters_v1090 = -1;
static gint ett_lte_rrc_BandParameters_v10i0 = -1;
static gint ett_lte_rrc_SEQUENCE_SIZE_1_maxBandwidthClass_r10_OF_CA_MIMO_ParametersDL_v10i0 = -1;
static gint ett_lte_rrc_BandParameters_v1130 = -1;
static gint ett_lte_rrc_BandParameters_r11 = -1;
static gint ett_lte_rrc_BandParameters_v1270 = -1;
static gint ett_lte_rrc_SEQUENCE_SIZE_1_maxBandwidthClass_r10_OF_CA_MIMO_ParametersDL_v1270 = -1;
static gint ett_lte_rrc_BandParameters_r13 = -1;
static gint ett_lte_rrc_BandParameters_v1320 = -1;
static gint ett_lte_rrc_BandParameters_v1380 = -1;
static gint ett_lte_rrc_BandParameters_v1430 = -1;
static gint ett_lte_rrc_SEQUENCE_SIZE_2_maxServCell_r13_OF_UL_256QAM_perCC_Info_r14 = -1;
static gint ett_lte_rrc_SEQUENCE_SIZE_1_maxSimultaneousBands_r10_OF_SRS_CapabilityPerBandPair_r14 = -1;
static gint ett_lte_rrc_BandParameters_v1450 = -1;
static gint ett_lte_rrc_BandParameters_v1470 = -1;
static gint ett_lte_rrc_BandParameters_v14b0 = -1;
static gint ett_lte_rrc_SEQUENCE_SIZE_1_maxSimultaneousBands_r10_OF_SRS_CapabilityPerBandPair_v14b0 = -1;
static gint ett_lte_rrc_BandParameters_v1530 = -1;
static gint ett_lte_rrc_V2X_BandParameters_r14 = -1;
static gint ett_lte_rrc_V2X_BandParameters_v1530 = -1;
static gint ett_lte_rrc_BandParametersTxSL_r14 = -1;
static gint ett_lte_rrc_BandParametersRxSL_r14 = -1;
static gint ett_lte_rrc_V2X_BandwidthClassSL_r14 = -1;
static gint ett_lte_rrc_UL_256QAM_perCC_Info_r14 = -1;
static gint ett_lte_rrc_FeatureSetDL_r15 = -1;
static gint ett_lte_rrc_SEQUENCE_SIZE_1_maxServCell_r13_OF_FeatureSetDL_PerCC_Id_r15 = -1;
static gint ett_lte_rrc_FeatureSetDL_v1550 = -1;
static gint ett_lte_rrc_FeatureSetDL_PerCC_r15 = -1;
static gint ett_lte_rrc_FeatureSetUL_r15 = -1;
static gint ett_lte_rrc_SEQUENCE_SIZE_1_maxServCell_r13_OF_FeatureSetUL_PerCC_Id_r15 = -1;
static gint ett_lte_rrc_FeatureSetUL_PerCC_r15 = -1;
static gint ett_lte_rrc_BandParametersUL_r10 = -1;
static gint ett_lte_rrc_CA_MIMO_ParametersUL_r10 = -1;
static gint ett_lte_rrc_CA_MIMO_ParametersUL_r15 = -1;
static gint ett_lte_rrc_BandParametersDL_r10 = -1;
static gint ett_lte_rrc_CA_MIMO_ParametersDL_r10 = -1;
static gint ett_lte_rrc_CA_MIMO_ParametersDL_v10i0 = -1;
static gint ett_lte_rrc_CA_MIMO_ParametersDL_v1270 = -1;
static gint ett_lte_rrc_SEQUENCE_SIZE_1_maxServCell_r10_OF_IntraBandContiguousCC_Info_r12 = -1;
static gint ett_lte_rrc_CA_MIMO_ParametersDL_r13 = -1;
static gint ett_lte_rrc_SEQUENCE_SIZE_1_maxServCell_r13_OF_IntraBandContiguousCC_Info_r12 = -1;
static gint ett_lte_rrc_CA_MIMO_ParametersDL_r15 = -1;
static gint ett_lte_rrc_IntraBandContiguousCC_Info_r12 = -1;
static gint ett_lte_rrc_MUST_Parameters_r14 = -1;
static gint ett_lte_rrc_SupportedBandListEUTRA = -1;
static gint ett_lte_rrc_SupportedBandListEUTRA_v9e0 = -1;
static gint ett_lte_rrc_SupportedBandListEUTRA_v1250 = -1;
static gint ett_lte_rrc_SupportedBandListEUTRA_v1310 = -1;
static gint ett_lte_rrc_SupportedBandListEUTRA_v1320 = -1;
static gint ett_lte_rrc_SupportedBandEUTRA = -1;
static gint ett_lte_rrc_SupportedBandEUTRA_v9e0 = -1;
static gint ett_lte_rrc_SupportedBandEUTRA_v1250 = -1;
static gint ett_lte_rrc_SupportedBandEUTRA_v1310 = -1;
static gint ett_lte_rrc_SupportedBandEUTRA_v1320 = -1;
static gint ett_lte_rrc_MeasParameters = -1;
static gint ett_lte_rrc_MeasParameters_v1020 = -1;
static gint ett_lte_rrc_MeasParameters_v1130 = -1;
static gint ett_lte_rrc_MeasParameters_v11a0 = -1;
static gint ett_lte_rrc_MeasParameters_v1250 = -1;
static gint ett_lte_rrc_MeasParameters_v1310 = -1;
static gint ett_lte_rrc_MeasParameters_v1430 = -1;
static gint ett_lte_rrc_MeasParameters_v1520 = -1;
static gint ett_lte_rrc_MeasParameters_v1530 = -1;
static gint ett_lte_rrc_BandListEUTRA = -1;
static gint ett_lte_rrc_BandCombinationListEUTRA_r10 = -1;
static gint ett_lte_rrc_BandInfoEUTRA = -1;
static gint ett_lte_rrc_InterFreqBandList = -1;
static gint ett_lte_rrc_InterFreqBandInfo = -1;
static gint ett_lte_rrc_InterRAT_BandList = -1;
static gint ett_lte_rrc_InterRAT_BandInfo = -1;
static gint ett_lte_rrc_IRAT_ParametersNR_r15 = -1;
static gint ett_lte_rrc_IRAT_ParametersNR_v1540 = -1;
static gint ett_lte_rrc_IRAT_ParametersNR_v1560 = -1;
static gint ett_lte_rrc_IRAT_ParametersNR_v1570 = -1;
static gint ett_lte_rrc_EUTRA_5GC_Parameters_r15 = -1;
static gint ett_lte_rrc_PDCP_ParametersNR_r15 = -1;
static gint ett_lte_rrc_T_rohc_ProfilesUL_Only_r15 = -1;
static gint ett_lte_rrc_PDCP_ParametersNR_v1560 = -1;
static gint ett_lte_rrc_ROHC_ProfileSupportList_r15 = -1;
static gint ett_lte_rrc_SupportedBandListNR_r15 = -1;
static gint ett_lte_rrc_SupportedBandNR_r15 = -1;
static gint ett_lte_rrc_IRAT_ParametersUTRA_FDD = -1;
static gint ett_lte_rrc_IRAT_ParametersUTRA_v920 = -1;
static gint ett_lte_rrc_IRAT_ParametersUTRA_v9c0 = -1;
static gint ett_lte_rrc_IRAT_ParametersUTRA_v9h0 = -1;
static gint ett_lte_rrc_SupportedBandListUTRA_FDD = -1;
static gint ett_lte_rrc_IRAT_ParametersUTRA_TDD128 = -1;
static gint ett_lte_rrc_SupportedBandListUTRA_TDD128 = -1;
static gint ett_lte_rrc_IRAT_ParametersUTRA_TDD384 = -1;
static gint ett_lte_rrc_SupportedBandListUTRA_TDD384 = -1;
static gint ett_lte_rrc_IRAT_ParametersUTRA_TDD768 = -1;
static gint ett_lte_rrc_SupportedBandListUTRA_TDD768 = -1;
static gint ett_lte_rrc_IRAT_ParametersUTRA_TDD_v1020 = -1;
static gint ett_lte_rrc_IRAT_ParametersGERAN = -1;
static gint ett_lte_rrc_IRAT_ParametersGERAN_v920 = -1;
static gint ett_lte_rrc_SupportedBandListGERAN = -1;
static gint ett_lte_rrc_IRAT_ParametersCDMA2000_HRPD = -1;
static gint ett_lte_rrc_SupportedBandListHRPD = -1;
static gint ett_lte_rrc_IRAT_ParametersCDMA2000_1XRTT = -1;
static gint ett_lte_rrc_IRAT_ParametersCDMA2000_1XRTT_v920 = -1;
static gint ett_lte_rrc_IRAT_ParametersCDMA2000_1XRTT_v1020 = -1;
static gint ett_lte_rrc_IRAT_ParametersCDMA2000_v1130 = -1;
static gint ett_lte_rrc_SupportedBandList1XRTT = -1;
static gint ett_lte_rrc_IRAT_ParametersWLAN_r13 = -1;
static gint ett_lte_rrc_SupportedBandListWLAN_r13 = -1;
static gint ett_lte_rrc_CSG_ProximityIndicationParameters_r9 = -1;
static gint ett_lte_rrc_NeighCellSI_AcquisitionParameters_r9 = -1;
static gint ett_lte_rrc_NeighCellSI_AcquisitionParameters_v1530 = -1;
static gint ett_lte_rrc_NeighCellSI_AcquisitionParameters_v1550 = -1;
static gint ett_lte_rrc_SON_Parameters_r9 = -1;
static gint ett_lte_rrc_UE_BasedNetwPerfMeasParameters_r10 = -1;
static gint ett_lte_rrc_UE_BasedNetwPerfMeasParameters_v1250 = -1;
static gint ett_lte_rrc_UE_BasedNetwPerfMeasParameters_v1430 = -1;
static gint ett_lte_rrc_UE_BasedNetwPerfMeasParameters_v1530 = -1;
static gint ett_lte_rrc_OTDOA_PositioningCapabilities_r10 = -1;
static gint ett_lte_rrc_Other_Parameters_r11 = -1;
static gint ett_lte_rrc_Other_Parameters_v11d0 = -1;
static gint ett_lte_rrc_Other_Parameters_v1360 = -1;
static gint ett_lte_rrc_Other_Parameters_v1430 = -1;
static gint ett_lte_rrc_OtherParameters_v1450 = -1;
static gint ett_lte_rrc_Other_Parameters_v1460 = -1;
static gint ett_lte_rrc_Other_Parameters_v1530 = -1;
static gint ett_lte_rrc_Other_Parameters_v1540 = -1;
static gint ett_lte_rrc_MBMS_Parameters_r11 = -1;
static gint ett_lte_rrc_MBMS_Parameters_v1250 = -1;
static gint ett_lte_rrc_MBMS_Parameters_v1430 = -1;
static gint ett_lte_rrc_MBMS_Parameters_v1470 = -1;
static gint ett_lte_rrc_T_mbms_MaxBW_r14 = -1;
static gint ett_lte_rrc_FeMBMS_Unicast_Parameters_r14 = -1;
static gint ett_lte_rrc_SCPTM_Parameters_r13 = -1;
static gint ett_lte_rrc_CE_Parameters_r13 = -1;
static gint ett_lte_rrc_CE_Parameters_v1320 = -1;
static gint ett_lte_rrc_CE_Parameters_v1350 = -1;
static gint ett_lte_rrc_CE_Parameters_v1370 = -1;
static gint ett_lte_rrc_CE_Parameters_v1380 = -1;
static gint ett_lte_rrc_CE_Parameters_v1430 = -1;
static gint ett_lte_rrc_LAA_Parameters_r13 = -1;
static gint ett_lte_rrc_LAA_Parameters_v1430 = -1;
static gint ett_lte_rrc_LAA_Parameters_v1530 = -1;
static gint ett_lte_rrc_WLAN_IW_Parameters_r12 = -1;
static gint ett_lte_rrc_LWA_Parameters_r13 = -1;
static gint ett_lte_rrc_LWA_Parameters_v1430 = -1;
static gint ett_lte_rrc_LWA_Parameters_v1440 = -1;
static gint ett_lte_rrc_WLAN_IW_Parameters_v1310 = -1;
static gint ett_lte_rrc_LWIP_Parameters_r13 = -1;
static gint ett_lte_rrc_LWIP_Parameters_v1430 = -1;
static gint ett_lte_rrc_NAICS_Capability_List_r12 = -1;
static gint ett_lte_rrc_NAICS_Capability_Entry_r12 = -1;
static gint ett_lte_rrc_SL_Parameters_r12 = -1;
static gint ett_lte_rrc_SL_Parameters_v1310 = -1;
static gint ett_lte_rrc_SL_Parameters_v1430 = -1;
static gint ett_lte_rrc_SL_Parameters_v1530 = -1;
static gint ett_lte_rrc_SL_Parameters_v1540 = -1;
static gint ett_lte_rrc_UE_CategorySL_r15 = -1;
static gint ett_lte_rrc_V2X_SupportedBandCombination_r14 = -1;
static gint ett_lte_rrc_V2X_SupportedBandCombination_v1530 = -1;
static gint ett_lte_rrc_V2X_BandCombinationParameters_r14 = -1;
static gint ett_lte_rrc_V2X_BandCombinationParameters_v1530 = -1;
static gint ett_lte_rrc_SupportedBandInfoList_r12 = -1;
static gint ett_lte_rrc_SupportedBandInfo_r12 = -1;
static gint ett_lte_rrc_FreqBandIndicatorListEUTRA_r12 = -1;
static gint ett_lte_rrc_MMTEL_Parameters_r14 = -1;
static gint ett_lte_rrc_SRS_CapabilityPerBandPair_r14 = -1;
static gint ett_lte_rrc_T_retuningInfo = -1;
static gint ett_lte_rrc_SRS_CapabilityPerBandPair_v14b0 = -1;
static gint ett_lte_rrc_HighSpeedEnhParameters_r14 = -1;
static gint ett_lte_rrc_UE_RadioPagingInfo_r12 = -1;
static gint ett_lte_rrc_UE_TimersAndConstants = -1;
static gint ett_lte_rrc_VisitedCellInfoList_r12 = -1;
static gint ett_lte_rrc_VisitedCellInfo_r12 = -1;
static gint ett_lte_rrc_T_visitedCellId_r12 = -1;
static gint ett_lte_rrc_T_pci_arfcn_r12 = -1;
static gint ett_lte_rrc_WLAN_OffloadConfig_r12 = -1;
static gint ett_lte_rrc_T_thresholdRSRP_r12 = -1;
static gint ett_lte_rrc_T_thresholdRSRQ_r12 = -1;
static gint ett_lte_rrc_T_thresholdRSRQ_OnAllSymbolsWithWB_r12 = -1;
static gint ett_lte_rrc_T_thresholdRSRQ_OnAllSymbols_r12 = -1;
static gint ett_lte_rrc_T_thresholdRSRQ_WB_r12 = -1;
static gint ett_lte_rrc_T_thresholdChannelUtilization_r12 = -1;
static gint ett_lte_rrc_T_thresholdBackhaul_Bandwidth_r12 = -1;
static gint ett_lte_rrc_T_thresholdWLAN_RSSI_r12 = -1;
static gint ett_lte_rrc_MBMS_NotificationConfig_r9 = -1;
static gint ett_lte_rrc_MBMS_NotificationConfig_v1430 = -1;
static gint ett_lte_rrc_MBMS_ServiceList_r13 = -1;
static gint ett_lte_rrc_MBMS_ServiceInfo_r13 = -1;
static gint ett_lte_rrc_MBSFN_AreaInfoList_r9 = -1;
static gint ett_lte_rrc_MBSFN_AreaInfo_r9 = -1;
static gint ett_lte_rrc_T_mcch_Config_r9 = -1;
static gint ett_lte_rrc_T_mcch_Config_r14 = -1;
static gint ett_lte_rrc_MBSFN_SubframeConfig = -1;
static gint ett_lte_rrc_T_subframeAllocation = -1;
static gint ett_lte_rrc_MBSFN_SubframeConfig_v1430 = -1;
static gint ett_lte_rrc_T_subframeAllocation_v1430 = -1;
static gint ett_lte_rrc_PMCH_InfoList_r9 = -1;
static gint ett_lte_rrc_PMCH_InfoListExt_r12 = -1;
static gint ett_lte_rrc_PMCH_Info_r9 = -1;
static gint ett_lte_rrc_PMCH_InfoExt_r12 = -1;
static gint ett_lte_rrc_MBMS_SessionInfoList_r9 = -1;
static gint ett_lte_rrc_MBMS_SessionInfo_r9 = -1;
static gint ett_lte_rrc_PMCH_Config_r9 = -1;
static gint ett_lte_rrc_PMCH_Config_r12 = -1;
static gint ett_lte_rrc_T_dataMCS_r12 = -1;
static gint ett_lte_rrc_TMGI_r9 = -1;
static gint ett_lte_rrc_T_plmn_Id_r9 = -1;
static gint ett_lte_rrc_SC_MTCH_InfoList_r13 = -1;
static gint ett_lte_rrc_SC_MTCH_Info_r13 = -1;
static gint ett_lte_rrc_MBMSSessionInfo_r13 = -1;
static gint ett_lte_rrc_SC_MTCH_SchedulingInfo_r13 = -1;
static gint ett_lte_rrc_T_schedulingPeriodStartOffsetSCPTM_r13 = -1;
static gint ett_lte_rrc_SC_MTCH_InfoList_BR_r14 = -1;
static gint ett_lte_rrc_SC_MTCH_Info_BR_r14 = -1;
static gint ett_lte_rrc_T_mpdcch_StartSF_SC_MTCH_r14 = -1;
static gint ett_lte_rrc_SC_MTCH_SchedulingInfo_BR_r14 = -1;
static gint ett_lte_rrc_T_schedulingPeriodStartOffsetSCPTM_r14_01 = -1;
static gint ett_lte_rrc_SCPTM_NeighbourCellList_r13 = -1;
static gint ett_lte_rrc_PCI_ARFCN_r13 = -1;
static gint ett_lte_rrc_SL_AnchorCarrierFreqList_V2X_r14 = -1;
static gint ett_lte_rrc_SL_CBR_CommonTxConfigList_r14 = -1;
static gint ett_lte_rrc_SEQUENCE_SIZE_1_maxSL_V2X_CBRConfig_r14_OF_SL_CBR_Levels_Config_r14 = -1;
static gint ett_lte_rrc_SEQUENCE_SIZE_1_maxSL_V2X_TxConfig_r14_OF_SL_CBR_PSSCH_TxConfig_r14 = -1;
static gint ett_lte_rrc_SL_CBR_Levels_Config_r14 = -1;
static gint ett_lte_rrc_SL_CBR_PSSCH_TxConfig_r14 = -1;
static gint ett_lte_rrc_SL_CBR_PPPP_TxConfigList_r14 = -1;
static gint ett_lte_rrc_SL_PPPP_TxConfigIndex_r14 = -1;
static gint ett_lte_rrc_SEQUENCE_SIZE_1_maxCBR_Level_r14_OF_Tx_ConfigIndex_r14 = -1;
static gint ett_lte_rrc_SL_CBR_PPPP_TxConfigList_v1530 = -1;
static gint ett_lte_rrc_SL_PPPP_TxConfigIndex_v1530 = -1;
static gint ett_lte_rrc_SEQUENCE_SIZE_1_maxCBR_Level_r14_OF_MCS_PSSCH_Range_r15 = -1;
static gint ett_lte_rrc_MCS_PSSCH_Range_r15 = -1;
static gint ett_lte_rrc_SL_CBR_PPPP_TxConfigList_r15 = -1;
static gint ett_lte_rrc_SL_PPPP_TxConfigIndex_r15 = -1;
static gint ett_lte_rrc_SL_CommConfig_r12 = -1;
static gint ett_lte_rrc_T_commTxResources_r12 = -1;
static gint ett_lte_rrc_T_setup_162 = -1;
static gint ett_lte_rrc_T_scheduled_r12 = -1;
static gint ett_lte_rrc_T_ue_Selected_r12 = -1;
static gint ett_lte_rrc_T_commTxPoolNormalDedicated_r12 = -1;
static gint ett_lte_rrc_T_commTxResources_v1310 = -1;
static gint ett_lte_rrc_T_setup_163 = -1;
static gint ett_lte_rrc_T_scheduled_v1310 = -1;
static gint ett_lte_rrc_T_ue_Selected_v1310 = -1;
static gint ett_lte_rrc_T_commTxPoolNormalDedicatedExt_r13 = -1;
static gint ett_lte_rrc_LogicalChGroupInfoList_r13 = -1;
static gint ett_lte_rrc_SL_CommTxPoolToAddModList_r12 = -1;
static gint ett_lte_rrc_SL_CommTxPoolToAddModListExt_r13 = -1;
static gint ett_lte_rrc_SL_CommTxPoolToAddMod_r12 = -1;
static gint ett_lte_rrc_SL_CommTxPoolToAddModExt_r13 = -1;
static gint ett_lte_rrc_MAC_MainConfigSL_r12 = -1;
static gint ett_lte_rrc_SL_CommTxPoolList_r12 = -1;
static gint ett_lte_rrc_SL_CommTxPoolListExt_r13 = -1;
static gint ett_lte_rrc_SL_CommTxPoolListV2X_r14 = -1;
static gint ett_lte_rrc_SL_CommRxPoolList_r12 = -1;
static gint ett_lte_rrc_SL_CommRxPoolListV2X_r14 = -1;
static gint ett_lte_rrc_SL_CommResourcePool_r12 = -1;
static gint ett_lte_rrc_T_ue_SelectedResourceConfig_r12 = -1;
static gint ett_lte_rrc_T_rxParametersNCell_r12 = -1;
static gint ett_lte_rrc_T_txParameters_r12 = -1;
static gint ett_lte_rrc_SL_CommResourcePoolV2X_r14 = -1;
static gint ett_lte_rrc_T_rxParametersNCell_r14 = -1;
static gint ett_lte_rrc_SL_MinT2ValueList_r15 = -1;
static gint ett_lte_rrc_SL_MinT2Value_r15 = -1;
static gint ett_lte_rrc_SL_CommTxPoolSensingConfig_r14 = -1;
static gint ett_lte_rrc_T_p2x_SensingConfig_r14 = -1;
static gint ett_lte_rrc_SL_DiscConfig_r12 = -1;
static gint ett_lte_rrc_T_discTxResources_r12 = -1;
static gint ett_lte_rrc_T_setup_164 = -1;
static gint ett_lte_rrc_T_scheduled_r12_01 = -1;
static gint ett_lte_rrc_T_ue_Selected_r12_01 = -1;
static gint ett_lte_rrc_T_discTxPoolDedicated_r12 = -1;
static gint ett_lte_rrc_T_discTF_IndexList_v1260 = -1;
static gint ett_lte_rrc_T_setup_165 = -1;
static gint ett_lte_rrc_T_discTxResourcesPS_r13 = -1;
static gint ett_lte_rrc_T_setup_166 = -1;
static gint ett_lte_rrc_T_ue_Selected_r13 = -1;
static gint ett_lte_rrc_T_discTxInterFreqInfo_r13 = -1;
static gint ett_lte_rrc_T_setup_167 = -1;
static gint ett_lte_rrc_T_discRxGapConfig_r13 = -1;
static gint ett_lte_rrc_T_discTxGapConfig_r13 = -1;
static gint ett_lte_rrc_T_discSysInfoToReportConfig_r13 = -1;
static gint ett_lte_rrc_SL_DiscSysInfoToReportFreqList_r13 = -1;
static gint ett_lte_rrc_SL_DiscTxInfoInterFreqListAdd_r13 = -1;
static gint ett_lte_rrc_SEQUENCE_SIZE_1_maxFreq_OF_SL_DiscTxResourceInfoPerFreq_r13 = -1;
static gint ett_lte_rrc_SEQUENCE_SIZE_1_maxFreq_OF_ARFCN_ValueEUTRA_r9 = -1;
static gint ett_lte_rrc_SL_DiscTxResourceInfoPerFreq_r13 = -1;
static gint ett_lte_rrc_SL_DiscTxResource_r13 = -1;
static gint ett_lte_rrc_T_setup_168 = -1;
static gint ett_lte_rrc_SL_DiscTxPoolToAddModList_r12 = -1;
static gint ett_lte_rrc_SL_DiscTxPoolToAddMod_r12 = -1;
static gint ett_lte_rrc_SL_DiscTxConfigScheduled_r13 = -1;
static gint ett_lte_rrc_SL_DiscTxPoolDedicated_r13 = -1;
static gint ett_lte_rrc_SL_TF_IndexPairList_r12 = -1;
static gint ett_lte_rrc_SL_TF_IndexPair_r12 = -1;
static gint ett_lte_rrc_SL_TF_IndexPairList_r12b = -1;
static gint ett_lte_rrc_SL_TF_IndexPair_r12b = -1;
static gint ett_lte_rrc_SL_DiscTxRefCarrierDedicated_r13 = -1;
static gint ett_lte_rrc_SL_DiscTxPoolList_r12 = -1;
static gint ett_lte_rrc_SL_DiscRxPoolList_r12 = -1;
static gint ett_lte_rrc_SL_DiscResourcePool_r12 = -1;
static gint ett_lte_rrc_T_txParameters_r12_01 = -1;
static gint ett_lte_rrc_T_ue_SelectedResourceConfig_r12_01 = -1;
static gint ett_lte_rrc_T_poolSelection_r12 = -1;
static gint ett_lte_rrc_T_rxParameters_r12 = -1;
static gint ett_lte_rrc_T_discPeriod_v1310 = -1;
static gint ett_lte_rrc_T_rxParamsAddNeighFreq_r13 = -1;
static gint ett_lte_rrc_T_setup_170 = -1;
static gint ett_lte_rrc_T_txParamsAddNeighFreq_r13 = -1;
static gint ett_lte_rrc_T_setup_171 = -1;
static gint ett_lte_rrc_T_freqInfo_01 = -1;
static gint ett_lte_rrc_T_txParamsAddNeighFreq_v1370 = -1;
static gint ett_lte_rrc_T_setup_172 = -1;
static gint ett_lte_rrc_T_freqInfo_v1370 = -1;
static gint ett_lte_rrc_PhysCellIdList_r13 = -1;
static gint ett_lte_rrc_SL_PoolSelectionConfig_r12 = -1;
static gint ett_lte_rrc_SL_DiscSysInfoReport_r13 = -1;
static gint ett_lte_rrc_T_discCellSelectionInfo_r13 = -1;
static gint ett_lte_rrc_T_cellReselectionInfo_r13 = -1;
static gint ett_lte_rrc_T_freqInfo_r13 = -1;
static gint ett_lte_rrc_T_freqInfo_v1370_01 = -1;
static gint ett_lte_rrc_SL_DiscTxPowerInfoList_r12 = -1;
static gint ett_lte_rrc_SL_DiscTxPowerInfo_r12 = -1;
static gint ett_lte_rrc_SL_GapConfig_r13 = -1;
static gint ett_lte_rrc_SL_GapPatternList_r13 = -1;
static gint ett_lte_rrc_SL_GapPattern_r13 = -1;
static gint ett_lte_rrc_SL_GapRequest_r13 = -1;
static gint ett_lte_rrc_SL_GapFreqInfo_r13 = -1;
static gint ett_lte_rrc_SL_HoppingConfigComm_r12 = -1;
static gint ett_lte_rrc_SL_HoppingConfigDisc_r12 = -1;
static gint ett_lte_rrc_SL_InterFreqInfoListV2X_r14 = -1;
static gint ett_lte_rrc_SL_InterFreqInfoV2X_r14 = -1;
static gint ett_lte_rrc_T_additionalSpectrumEmissionV2X_r14 = -1;
static gint ett_lte_rrc_SL_V2X_UE_ConfigList_r14 = -1;
static gint ett_lte_rrc_SL_V2X_InterFreqUE_Config_r14 = -1;
static gint ett_lte_rrc_SL_OffsetIndicator_r12 = -1;
static gint ett_lte_rrc_SL_P2X_ResourceSelectionConfig_r14 = -1;
static gint ett_lte_rrc_SL_PriorityList_r13 = -1;
static gint ett_lte_rrc_SL_PSSCH_TxConfigList_r14 = -1;
static gint ett_lte_rrc_SL_PSSCH_TxConfig_r14 = -1;
static gint ett_lte_rrc_SL_PSSCH_TxParameters_r14 = -1;
static gint ett_lte_rrc_SL_PSSCH_TxParameters_v1530 = -1;
static gint ett_lte_rrc_SL_ReliabilityList_r15 = -1;
static gint ett_lte_rrc_SL_RestrictResourceReservationPeriodList_r14 = -1;
static gint ett_lte_rrc_SL_SyncAllowed_r14 = -1;
static gint ett_lte_rrc_SL_SyncConfigList_r12 = -1;
static gint ett_lte_rrc_SL_SyncConfigListV2X_r14 = -1;
static gint ett_lte_rrc_SL_SyncConfig_r12 = -1;
static gint ett_lte_rrc_T_txParameters_r12_02 = -1;
static gint ett_lte_rrc_T_rxParamsNCell_r12 = -1;
static gint ett_lte_rrc_SL_SyncConfigListNFreq_r13 = -1;
static gint ett_lte_rrc_SL_SyncConfigListNFreqV2X_r14 = -1;
static gint ett_lte_rrc_SL_SyncConfigNFreq_r13 = -1;
static gint ett_lte_rrc_T_asyncParameters_r13 = -1;
static gint ett_lte_rrc_T_txParameters_r13 = -1;
static gint ett_lte_rrc_T_rxParameters_r13 = -1;
static gint ett_lte_rrc_SL_TF_ResourceConfig_r12 = -1;
static gint ett_lte_rrc_SubframeBitmapSL_r12 = -1;
static gint ett_lte_rrc_SubframeBitmapSL_r14 = -1;
static gint ett_lte_rrc_SL_TxPower_r14 = -1;
static gint ett_lte_rrc_SL_ThresPSSCH_RSRP_List_r14 = -1;
static gint ett_lte_rrc_SL_TxParameters_r12 = -1;
static gint ett_lte_rrc_SL_TxPoolToReleaseList_r12 = -1;
static gint ett_lte_rrc_SL_TxPoolToReleaseListExt_r13 = -1;
static gint ett_lte_rrc_SL_V2X_ConfigDedicated_r14 = -1;
static gint ett_lte_rrc_T_commTxResources_r14 = -1;
static gint ett_lte_rrc_T_setup_173 = -1;
static gint ett_lte_rrc_T_scheduled_r14 = -1;
static gint ett_lte_rrc_T_ue_Selected_r14 = -1;
static gint ett_lte_rrc_T_v2x_CommTxPoolNormalDedicated_r14 = -1;
static gint ett_lte_rrc_T_commTxResources_v1530 = -1;
static gint ett_lte_rrc_T_setup_174 = -1;
static gint ett_lte_rrc_T_scheduled_v1530 = -1;
static gint ett_lte_rrc_T_ue_Selected_v1530 = -1;
static gint ett_lte_rrc_LogicalChGroupInfoList_v1530 = -1;
static gint ett_lte_rrc_SL_TxPoolToAddModListV2X_r14 = -1;
static gint ett_lte_rrc_SL_TxPoolToAddMod_r14 = -1;
static gint ett_lte_rrc_SL_TxPoolToReleaseListV2X_r14 = -1;
static gint ett_lte_rrc_SL_V2X_FreqSelectionConfigList_r15 = -1;
static gint ett_lte_rrc_SL_V2X_FreqSelectionConfig_r15 = -1;
static gint ett_lte_rrc_SL_V2X_PacketDuplicationConfig_r15 = -1;
static gint ett_lte_rrc_SL_PPPR_Dest_CarrierFreqList_r15 = -1;
static gint ett_lte_rrc_SL_PPPR_Dest_CarrierFreq = -1;
static gint ett_lte_rrc_SL_AllowedCarrierFreqList_r15 = -1;
static gint ett_lte_rrc_SEQUENCE_SIZE_1_maxFreqV2X_r14_OF_ARFCN_ValueEUTRA_r9 = -1;
static gint ett_lte_rrc_SL_V2X_SyncFreqList_r15 = -1;
static gint ett_lte_rrc_SL_ZoneConfig_r14 = -1;
static gint ett_lte_rrc_SBCCH_SL_BCH_Message = -1;
static gint ett_lte_rrc_SBCCH_SL_BCH_Message_V2X_r14 = -1;
static gint ett_lte_rrc_MasterInformationBlock_SL = -1;
static gint ett_lte_rrc_MasterInformationBlock_SL_V2X_r14 = -1;
static gint ett_lte_rrc_HandoverPreparationInformation_NB = -1;
static gint ett_lte_rrc_T_criticalExtensions_56 = -1;
static gint ett_lte_rrc_T_c1_50 = -1;
static gint ett_lte_rrc_T_criticalExtensionsFuture_54 = -1;
static gint ett_lte_rrc_HandoverPreparationInformation_NB_IEs = -1;
static gint ett_lte_rrc_HandoverPreparationInformation_NB_v1380_IEs = -1;
static gint ett_lte_rrc_HandoverPreparationInformation_NB_Ext_r14_IEs = -1;
static gint ett_lte_rrc_T_nonCriticalExtension_80 = -1;
static gint ett_lte_rrc_UEPagingCoverageInformation_NB = -1;
static gint ett_lte_rrc_T_criticalExtensions_57 = -1;
static gint ett_lte_rrc_T_c1_51 = -1;
static gint ett_lte_rrc_T_criticalExtensionsFuture_55 = -1;
static gint ett_lte_rrc_UEPagingCoverageInformation_NB_IEs = -1;
static gint ett_lte_rrc_T_nonCriticalExtension_81 = -1;
static gint ett_lte_rrc_UERadioAccessCapabilityInformation_NB = -1;
static gint ett_lte_rrc_T_criticalExtensions_58 = -1;
static gint ett_lte_rrc_T_c1_52 = -1;
static gint ett_lte_rrc_T_criticalExtensionsFuture_56 = -1;
static gint ett_lte_rrc_UERadioAccessCapabilityInformation_NB_IEs = -1;
static gint ett_lte_rrc_UERadioAccessCapabilityInformation_NB_v1380_IEs = -1;
static gint ett_lte_rrc_UERadioAccessCapabilityInformation_NB_r14_IEs = -1;
static gint ett_lte_rrc_T_nonCriticalExtension_82 = -1;
static gint ett_lte_rrc_UERadioPagingInformation_NB = -1;
static gint ett_lte_rrc_T_criticalExtensions_59 = -1;
static gint ett_lte_rrc_T_c1_53 = -1;
static gint ett_lte_rrc_T_criticalExtensionsFuture_57 = -1;
static gint ett_lte_rrc_UERadioPagingInformation_NB_IEs = -1;
static gint ett_lte_rrc_T_nonCriticalExtension_83 = -1;
static gint ett_lte_rrc_AS_Config_NB = -1;
static gint ett_lte_rrc_AS_Context_NB = -1;
static gint ett_lte_rrc_ReestablishmentInfo_NB = -1;
static gint ett_lte_rrc_RRM_Config_NB = -1;
static gint ett_lte_rrc_BCCH_BCH_Message_NB = -1;
static gint ett_lte_rrc_BCCH_BCH_Message_TDD_NB = -1;
static gint ett_lte_rrc_BCCH_DL_SCH_Message_NB = -1;
static gint ett_lte_rrc_BCCH_DL_SCH_MessageType_NB = -1;
static gint ett_lte_rrc_T_c1_54 = -1;
static gint ett_lte_rrc_T_messageClassExtension_10 = -1;
static gint ett_lte_rrc_PCCH_Message_NB = -1;
static gint ett_lte_rrc_PCCH_MessageType_NB = -1;
static gint ett_lte_rrc_T_c1_55 = -1;
static gint ett_lte_rrc_T_messageClassExtension_11 = -1;
static gint ett_lte_rrc_DL_CCCH_Message_NB = -1;
static gint ett_lte_rrc_DL_CCCH_MessageType_NB = -1;
static gint ett_lte_rrc_T_c1_56 = -1;
static gint ett_lte_rrc_T_messageClassExtension_12 = -1;
static gint ett_lte_rrc_DL_DCCH_Message_NB = -1;
static gint ett_lte_rrc_DL_DCCH_MessageType_NB = -1;
static gint ett_lte_rrc_T_c1_57 = -1;
static gint ett_lte_rrc_T_messageClassExtension_13 = -1;
static gint ett_lte_rrc_UL_CCCH_Message_NB = -1;
static gint ett_lte_rrc_UL_CCCH_MessageType_NB = -1;
static gint ett_lte_rrc_T_c1_58 = -1;
static gint ett_lte_rrc_T_messageClassExtension_14 = -1;
static gint ett_lte_rrc_SC_MCCH_Message_NB = -1;
static gint ett_lte_rrc_SC_MCCH_MessageType_NB = -1;
static gint ett_lte_rrc_T_c1_59 = -1;
static gint ett_lte_rrc_T_messageClassExtension_15 = -1;
static gint ett_lte_rrc_UL_DCCH_Message_NB = -1;
static gint ett_lte_rrc_UL_DCCH_MessageType_NB = -1;
static gint ett_lte_rrc_T_c1_60 = -1;
static gint ett_lte_rrc_T_messageClassExtension_16 = -1;
static gint ett_lte_rrc_DLInformationTransfer_NB = -1;
static gint ett_lte_rrc_T_criticalExtensions_60 = -1;
static gint ett_lte_rrc_T_c1_61 = -1;
static gint ett_lte_rrc_T_criticalExtensionsFuture_58 = -1;
static gint ett_lte_rrc_DLInformationTransfer_NB_r13_IEs = -1;
static gint ett_lte_rrc_T_nonCriticalExtension_84 = -1;
static gint ett_lte_rrc_MasterInformationBlock_NB = -1;
static gint ett_lte_rrc_T_operationModeInfo_r13 = -1;
static gint ett_lte_rrc_Guardband_NB_r13 = -1;
static gint ett_lte_rrc_Inband_SamePCI_NB_r13 = -1;
static gint ett_lte_rrc_Inband_DifferentPCI_NB_r13 = -1;
static gint ett_lte_rrc_Standalone_NB_r13 = -1;
static gint ett_lte_rrc_MasterInformationBlock_TDD_NB_r15 = -1;
static gint ett_lte_rrc_T_operationModeInfo_r15 = -1;
static gint ett_lte_rrc_GuardbandTDD_NB_r15 = -1;
static gint ett_lte_rrc_T_sib_GuardbandInfo_r15 = -1;
static gint ett_lte_rrc_Inband_SamePCI_TDD_NB_r15 = -1;
static gint ett_lte_rrc_Inband_DifferentPCI_TDD_NB_r15 = -1;
static gint ett_lte_rrc_StandaloneTDD_NB_r15 = -1;
static gint ett_lte_rrc_SIB_GuardbandAnchorTDD_NB_r15 = -1;
static gint ett_lte_rrc_SIB_GuardbandGuardbandTDD_NB_r15 = -1;
static gint ett_lte_rrc_SIB_GuardbandInbandSamePCI_TDD_NB_r15 = -1;
static gint ett_lte_rrc_SIB_GuardbandInbandDiffPCI_TDD_NB_r15 = -1;
static gint ett_lte_rrc_Paging_NB = -1;
static gint ett_lte_rrc_T_nonCriticalExtension_85 = -1;
static gint ett_lte_rrc_PagingRecordList_NB_r13 = -1;
static gint ett_lte_rrc_PagingRecord_NB_r13 = -1;
static gint ett_lte_rrc_RRCConnectionReconfiguration_NB = -1;
static gint ett_lte_rrc_T_criticalExtensions_61 = -1;
static gint ett_lte_rrc_T_c1_62 = -1;
static gint ett_lte_rrc_T_criticalExtensionsFuture_59 = -1;
static gint ett_lte_rrc_RRCConnectionReconfiguration_NB_r13_IEs = -1;
static gint ett_lte_rrc_SEQUENCE_SIZE_1_maxDRB_NB_r13_OF_DedicatedInfoNAS = -1;
static gint ett_lte_rrc_T_nonCriticalExtension_86 = -1;
static gint ett_lte_rrc_RRCConnectionReconfigurationComplete_NB = -1;
static gint ett_lte_rrc_T_criticalExtensions_62 = -1;
static gint ett_lte_rrc_T_criticalExtensionsFuture_60 = -1;
static gint ett_lte_rrc_RRCConnectionReconfigurationComplete_NB_r13_IEs = -1;
static gint ett_lte_rrc_T_nonCriticalExtension_87 = -1;
static gint ett_lte_rrc_RRCConnectionReestablishment_NB = -1;
static gint ett_lte_rrc_T_criticalExtensions_63 = -1;
static gint ett_lte_rrc_T_c1_63 = -1;
static gint ett_lte_rrc_T_criticalExtensionsFuture_61 = -1;
static gint ett_lte_rrc_RRCConnectionReestablishment_NB_r13_IEs = -1;
static gint ett_lte_rrc_RRCConnectionReestablishment_NB_v1430_IEs = -1;
static gint ett_lte_rrc_T_nonCriticalExtension_88 = -1;
static gint ett_lte_rrc_RRCConnectionReestablishmentComplete_NB = -1;
static gint ett_lte_rrc_T_criticalExtensions_64 = -1;
static gint ett_lte_rrc_T_criticalExtensionsFuture_62 = -1;
static gint ett_lte_rrc_RRCConnectionReestablishmentComplete_NB_r13_IEs = -1;
static gint ett_lte_rrc_RRCConnectionReestablishmentComplete_NB_v1470_IEs = -1;
static gint ett_lte_rrc_T_nonCriticalExtension_89 = -1;
static gint ett_lte_rrc_RRCConnectionReestablishmentRequest_NB = -1;
static gint ett_lte_rrc_T_criticalExtensions_65 = -1;
static gint ett_lte_rrc_T_later_01 = -1;
static gint ett_lte_rrc_T_criticalExtensionsFuture_63 = -1;
static gint ett_lte_rrc_RRCConnectionReestablishmentRequest_NB_r13_IEs = -1;
static gint ett_lte_rrc_RRCConnectionReestablishmentRequest_NB_r14_IEs = -1;
static gint ett_lte_rrc_ReestabUE_Identity_CP_NB_r14 = -1;
static gint ett_lte_rrc_RRCConnectionReject_NB = -1;
static gint ett_lte_rrc_T_criticalExtensions_66 = -1;
static gint ett_lte_rrc_T_c1_64 = -1;
static gint ett_lte_rrc_T_criticalExtensionsFuture_64 = -1;
static gint ett_lte_rrc_RRCConnectionReject_NB_r13_IEs = -1;
static gint ett_lte_rrc_T_nonCriticalExtension_90 = -1;
static gint ett_lte_rrc_RRCConnectionRelease_NB = -1;
static gint ett_lte_rrc_T_criticalExtensions_67 = -1;
static gint ett_lte_rrc_T_c1_65 = -1;
static gint ett_lte_rrc_T_criticalExtensionsFuture_65 = -1;
static gint ett_lte_rrc_RRCConnectionRelease_NB_r13_IEs = -1;
static gint ett_lte_rrc_RRCConnectionRelease_NB_v1430_IEs = -1;
static gint ett_lte_rrc_RRCConnectionRelease_NB_v1530_IEs = -1;
static gint ett_lte_rrc_RRCConnectionRelease_NB_v1550_IEs = -1;
static gint ett_lte_rrc_T_nonCriticalExtension_91 = -1;
static gint ett_lte_rrc_RedirectedCarrierInfo_NB_v1430 = -1;
static gint ett_lte_rrc_RRCConnectionRequest_NB = -1;
static gint ett_lte_rrc_T_criticalExtensions_68 = -1;
static gint ett_lte_rrc_T_criticalExtensionsFuture_66 = -1;
static gint ett_lte_rrc_RRCConnectionRequest_NB_r13_IEs = -1;
static gint ett_lte_rrc_RRCConnectionResume_NB = -1;
static gint ett_lte_rrc_T_criticalExtensions_69 = -1;
static gint ett_lte_rrc_T_c1_66 = -1;
static gint ett_lte_rrc_T_criticalExtensionsFuture_67 = -1;
static gint ett_lte_rrc_RRCConnectionResume_NB_r13_IEs = -1;
static gint ett_lte_rrc_T_nonCriticalExtension_92 = -1;
static gint ett_lte_rrc_RRCConnectionResumeComplete_NB = -1;
static gint ett_lte_rrc_T_criticalExtensions_70 = -1;
static gint ett_lte_rrc_T_criticalExtensionsFuture_68 = -1;
static gint ett_lte_rrc_RRCConnectionResumeComplete_NB_r13_IEs = -1;
static gint ett_lte_rrc_RRCConnectionResumeComplete_NB_v1470_IEs = -1;
static gint ett_lte_rrc_T_nonCriticalExtension_93 = -1;
static gint ett_lte_rrc_RRCConnectionResumeRequest_NB = -1;
static gint ett_lte_rrc_T_criticalExtensions_71 = -1;
static gint ett_lte_rrc_T_criticalExtensionsFuture_69 = -1;
static gint ett_lte_rrc_RRCConnectionResumeRequest_NB_r13_IEs = -1;
static gint ett_lte_rrc_RRCConnectionSetup_NB = -1;
static gint ett_lte_rrc_T_criticalExtensions_72 = -1;
static gint ett_lte_rrc_T_c1_67 = -1;
static gint ett_lte_rrc_T_criticalExtensionsFuture_70 = -1;
static gint ett_lte_rrc_RRCConnectionSetup_NB_r13_IEs = -1;
static gint ett_lte_rrc_T_nonCriticalExtension_94 = -1;
static gint ett_lte_rrc_RRCConnectionSetupComplete_NB = -1;
static gint ett_lte_rrc_T_criticalExtensions_73 = -1;
static gint ett_lte_rrc_T_criticalExtensionsFuture_71 = -1;
static gint ett_lte_rrc_RRCConnectionSetupComplete_NB_r13_IEs = -1;
static gint ett_lte_rrc_RRCConnectionSetupComplete_NB_v1430_IEs = -1;
static gint ett_lte_rrc_RRCConnectionSetupComplete_NB_v1470_IEs = -1;
static gint ett_lte_rrc_T_nonCriticalExtension_95 = -1;
static gint ett_lte_rrc_RRCEarlyDataComplete_NB_r15 = -1;
static gint ett_lte_rrc_T_criticalExtensions_74 = -1;
static gint ett_lte_rrc_T_criticalExtensionsFuture_72 = -1;
static gint ett_lte_rrc_RRCEarlyDataComplete_NB_r15_IEs = -1;
static gint ett_lte_rrc_T_nonCriticalExtension_96 = -1;
static gint ett_lte_rrc_RRCEarlyDataRequest_NB_r15 = -1;
static gint ett_lte_rrc_T_criticalExtensions_75 = -1;
static gint ett_lte_rrc_T_criticalExtensionsFuture_73 = -1;
static gint ett_lte_rrc_RRCEarlyDataRequest_NB_r15_IEs = -1;
static gint ett_lte_rrc_T_nonCriticalExtension_97 = -1;
static gint ett_lte_rrc_SCPTMConfiguration_NB_r14 = -1;
static gint ett_lte_rrc_T_nonCriticalExtension_98 = -1;
static gint ett_lte_rrc_SystemInformation_NB = -1;
static gint ett_lte_rrc_T_criticalExtensions_76 = -1;
static gint ett_lte_rrc_T_criticalExtensionsFuture_74 = -1;
static gint ett_lte_rrc_SystemInformation_NB_r13_IEs = -1;
static gint ett_lte_rrc_T_sib_TypeAndInfo_r13 = -1;
static gint ett_lte_rrc_T_sib_TypeAndInfo_r13_item = -1;
static gint ett_lte_rrc_T_nonCriticalExtension_99 = -1;
static gint ett_lte_rrc_SystemInformationBlockType1_NB = -1;
static gint ett_lte_rrc_T_cellAccessRelatedInfo_r13 = -1;
static gint ett_lte_rrc_T_cellSelectionInfo_r13 = -1;
static gint ett_lte_rrc_SystemInformationBlockType1_NB_v1350 = -1;
static gint ett_lte_rrc_SystemInformationBlockType1_NB_v1430 = -1;
static gint ett_lte_rrc_SystemInformationBlockType1_NB_v1450 = -1;
static gint ett_lte_rrc_SystemInformationBlockType1_NB_v1530 = -1;
static gint ett_lte_rrc_T_tdd_Parameters_r15 = -1;
static gint ett_lte_rrc_T_nonCriticalExtension_100 = -1;
static gint ett_lte_rrc_PLMN_IdentityList_NB_r13 = -1;
static gint ett_lte_rrc_PLMN_IdentityInfo_NB_r13 = -1;
static gint ett_lte_rrc_SchedulingInfoList_NB_r13 = -1;
static gint ett_lte_rrc_SchedulingInfoList_NB_v1530 = -1;
static gint ett_lte_rrc_SchedulingInfo_NB_r13 = -1;
static gint ett_lte_rrc_SchedulingInfo_NB_v1530 = -1;
static gint ett_lte_rrc_SystemInfoValueTagList_NB_r13 = -1;
static gint ett_lte_rrc_SIB_MappingInfo_NB_r13 = -1;
static gint ett_lte_rrc_SIB_MappingInfo_NB_v1530 = -1;
static gint ett_lte_rrc_CellSelectionInfo_NB_v1350 = -1;
static gint ett_lte_rrc_CellSelectionInfo_NB_v1430 = -1;
static gint ett_lte_rrc_UECapabilityEnquiry_NB = -1;
static gint ett_lte_rrc_T_criticalExtensions_77 = -1;
static gint ett_lte_rrc_T_c1_68 = -1;
static gint ett_lte_rrc_T_criticalExtensionsFuture_75 = -1;
static gint ett_lte_rrc_UECapabilityEnquiry_NB_r13_IEs = -1;
static gint ett_lte_rrc_T_nonCriticalExtension_101 = -1;
static gint ett_lte_rrc_UECapabilityInformation_NB = -1;
static gint ett_lte_rrc_T_criticalExtensions_78 = -1;
static gint ett_lte_rrc_T_criticalExtensionsFuture_76 = -1;
static gint ett_lte_rrc_UECapabilityInformation_NB_r13_IEs = -1;
static gint ett_lte_rrc_UECapabilityInformation_NB_Ext_r14_IEs = -1;
static gint ett_lte_rrc_T_nonCriticalExtension_102 = -1;
static gint ett_lte_rrc_ULInformationTransfer_NB = -1;
static gint ett_lte_rrc_T_criticalExtensions_79 = -1;
static gint ett_lte_rrc_T_criticalExtensionsFuture_77 = -1;
static gint ett_lte_rrc_ULInformationTransfer_NB_r13_IEs = -1;
static gint ett_lte_rrc_T_nonCriticalExtension_103 = -1;
static gint ett_lte_rrc_SystemInformationBlockType2_NB_r13 = -1;
static gint ett_lte_rrc_T_freqInfo_r13_01 = -1;
static gint ett_lte_rrc_AdditionalSpectrumEmission_r13 = -1;
static gint ett_lte_rrc_T_freqInfo_v1530 = -1;
static gint ett_lte_rrc_SystemInformationBlockType3_NB_r13 = -1;
static gint ett_lte_rrc_T_cellReselectionInfoCommon_r13 = -1;
static gint ett_lte_rrc_T_cellReselectionServingFreqInfo_r13 = -1;
static gint ett_lte_rrc_T_intraFreqCellReselectionInfo_r13 = -1;
static gint ett_lte_rrc_SEQUENCE_SIZE_1_maxMultiBands_OF_NS_PmaxList_NB_r13 = -1;
static gint ett_lte_rrc_IntraFreqCellReselectionInfo_NB_v1350 = -1;
static gint ett_lte_rrc_IntraFreqCellReselectionInfo_NB_v1360 = -1;
static gint ett_lte_rrc_IntraFreqCellReselectionInfo_NB_v1430 = -1;
static gint ett_lte_rrc_CellReselectionInfoCommon_NB_v1450 = -1;
static gint ett_lte_rrc_SystemInformationBlockType4_NB_r13 = -1;
static gint ett_lte_rrc_IntraFreqNeighCellList_NB_v1530 = -1;
static gint ett_lte_rrc_IntraFreqNeighCellInfo_NB_v1530 = -1;
static gint ett_lte_rrc_SystemInformationBlockType5_NB_r13 = -1;
static gint ett_lte_rrc_InterFreqCarrierFreqList_NB_r13 = -1;
static gint ett_lte_rrc_InterFreqCarrierFreqInfo_NB_r13 = -1;
static gint ett_lte_rrc_InterFreqNeighCellList_NB_r13 = -1;
static gint ett_lte_rrc_InterFreqNeighCellList_NB_v1530 = -1;
static gint ett_lte_rrc_InterFreqNeighCellInfo_NB_v1530 = -1;
static gint ett_lte_rrc_InterFreqBlackCellList_NB_r13 = -1;
static gint ett_lte_rrc_SystemInformationBlockType14_NB_r13 = -1;
static gint ett_lte_rrc_T_ab_Param_r13 = -1;
static gint ett_lte_rrc_SEQUENCE_SIZE_1_maxPLMN_r11_OF_AB_ConfigPLMN_NB_r13 = -1;
static gint ett_lte_rrc_AB_ConfigPLMN_NB_r13 = -1;
static gint ett_lte_rrc_AB_Config_NB_r13 = -1;
static gint ett_lte_rrc_SystemInformationBlockType15_NB_r14 = -1;
static gint ett_lte_rrc_MBMS_SAI_InterFreqList_NB_r14 = -1;
static gint ett_lte_rrc_MBMS_SAI_InterFreq_NB_r14 = -1;
static gint ett_lte_rrc_SystemInformationBlockType20_NB_r14 = -1;
static gint ett_lte_rrc_T_sc_mcch_CarrierConfig_r14 = -1;
static gint ett_lte_rrc_NPDCCH_SC_MCCH_Config_NB_r14 = -1;
static gint ett_lte_rrc_SC_MCCH_SchedulingInfo_NB_r14 = -1;
static gint ett_lte_rrc_T_schedulingPeriodStartOffsetSCPTM_r14_02 = -1;
static gint ett_lte_rrc_SystemInformationBlockType22_NB_r14 = -1;
static gint ett_lte_rrc_T_mixedOperationModeConfig_r15 = -1;
static gint ett_lte_rrc_DL_ConfigCommonList_NB_r14 = -1;
static gint ett_lte_rrc_UL_ConfigCommonList_NB_r14 = -1;
static gint ett_lte_rrc_UL_ConfigCommonListTDD_NB_r15 = -1;
static gint ett_lte_rrc_DL_ConfigCommon_NB_r14 = -1;
static gint ett_lte_rrc_PCCH_Config_NB_r14 = -1;
static gint ett_lte_rrc_UL_ConfigCommon_NB_r14 = -1;
static gint ett_lte_rrc_UL_ConfigCommonTDD_NB_r15 = -1;
static gint ett_lte_rrc_NPRACH_ProbabilityAnchorList_NB_r14 = -1;
static gint ett_lte_rrc_NPRACH_ProbabilityAnchor_NB_r14 = -1;
static gint ett_lte_rrc_SystemInformationBlockType23_NB_r15 = -1;
static gint ett_lte_rrc_UL_ConfigCommonList_NB_v1530 = -1;
static gint ett_lte_rrc_UL_ConfigCommon_NB_v1530 = -1;
static gint ett_lte_rrc_CarrierConfigDedicated_NB_r13 = -1;
static gint ett_lte_rrc_DL_CarrierConfigDedicated_NB_r13 = -1;
static gint ett_lte_rrc_T_downlinkBitmapNonAnchor_r13 = -1;
static gint ett_lte_rrc_T_dl_GapNonAnchor_r13 = -1;
static gint ett_lte_rrc_T_inbandCarrierInfo_r13 = -1;
static gint ett_lte_rrc_T_samePCI_Indicator_r13 = -1;
static gint ett_lte_rrc_T_samePCI_r13 = -1;
static gint ett_lte_rrc_T_differentPCI_r13 = -1;
static gint ett_lte_rrc_UL_CarrierConfigDedicated_NB_r13 = -1;
static gint ett_lte_rrc_CarrierFreq_NB_r13 = -1;
static gint ett_lte_rrc_CarrierFreq_NB_v1550 = -1;
static gint ett_lte_rrc_DL_Bitmap_NB_r13 = -1;
static gint ett_lte_rrc_DL_CarrierConfigCommon_NB_r14 = -1;
static gint ett_lte_rrc_T_downlinkBitmapNonAnchor_r14 = -1;
static gint ett_lte_rrc_T_dl_GapNonAnchor_r14 = -1;
static gint ett_lte_rrc_T_inbandCarrierInfo_r14 = -1;
static gint ett_lte_rrc_T_samePCI_Indicator_r14 = -1;
static gint ett_lte_rrc_T_samePCI_r14 = -1;
static gint ett_lte_rrc_T_differentPCI_r14 = -1;
static gint ett_lte_rrc_DL_GapConfig_NB_r13 = -1;
static gint ett_lte_rrc_DL_GapConfig_NB_v1530 = -1;
static gint ett_lte_rrc_LogicalChannelConfig_NB_r13 = -1;
static gint ett_lte_rrc_MAC_MainConfig_NB_r13 = -1;
static gint ett_lte_rrc_T_ul_SCH_Config_r13 = -1;
static gint ett_lte_rrc_T_logicalChannelSR_Config_r13 = -1;
static gint ett_lte_rrc_T_setup_175 = -1;
static gint ett_lte_rrc_T_dataInactivityTimerConfig_r14_01 = -1;
static gint ett_lte_rrc_T_setup_176 = -1;
static gint ett_lte_rrc_DRX_Config_NB_r13 = -1;
static gint ett_lte_rrc_T_setup_177 = -1;
static gint ett_lte_rrc_NPDCCH_ConfigDedicated_NB_r13 = -1;
static gint ett_lte_rrc_NPDCCH_ConfigDedicated_NB_v1530 = -1;
static gint ett_lte_rrc_NPDSCH_ConfigCommon_NB_r13 = -1;
static gint ett_lte_rrc_NPRACH_ConfigSIB_NB_r13 = -1;
static gint ett_lte_rrc_NPRACH_ConfigSIB_NB_v1330 = -1;
static gint ett_lte_rrc_NPRACH_ConfigSIB_NB_v1450 = -1;
static gint ett_lte_rrc_NPRACH_ConfigSIB_NB_v1530 = -1;
static gint ett_lte_rrc_T_tdd_Parameters_r15_01 = -1;
static gint ett_lte_rrc_T_fmt2_Parameters_r15 = -1;
static gint ett_lte_rrc_T_edt_Parameters_r15_01 = -1;
static gint ett_lte_rrc_NPRACH_ConfigSIB_NB_v1550 = -1;
static gint ett_lte_rrc_T_tdd_Parameters_v1550 = -1;
static gint ett_lte_rrc_NPRACH_ParametersList_NB_r13 = -1;
static gint ett_lte_rrc_NPRACH_ParametersList_NB_v1330 = -1;
static gint ett_lte_rrc_NPRACH_Parameters_NB_r13 = -1;
static gint ett_lte_rrc_NPRACH_Parameters_NB_v1330 = -1;
static gint ett_lte_rrc_NPRACH_ParametersList_NB_r14 = -1;
static gint ett_lte_rrc_NPRACH_Parameters_NB_r14 = -1;
static gint ett_lte_rrc_T_nprach_Parameters_r14 = -1;
static gint ett_lte_rrc_NPRACH_ParametersListTDD_NB_r15 = -1;
static gint ett_lte_rrc_NPRACH_ParametersTDD_NB_r15 = -1;
static gint ett_lte_rrc_T_nprach_Parameters_r15 = -1;
static gint ett_lte_rrc_NPRACH_ParametersListTDD_NB_v1550 = -1;
static gint ett_lte_rrc_NPRACH_ParametersTDD_NB_v1550 = -1;
static gint ett_lte_rrc_NPRACH_ParametersListFmt2_NB_r15 = -1;
static gint ett_lte_rrc_NPRACH_ParametersFmt2_NB_r15 = -1;
static gint ett_lte_rrc_T_nprach_Parameters_r15_01 = -1;
static gint ett_lte_rrc_RSRP_ThresholdsNPRACH_InfoList_NB_r13 = -1;
static gint ett_lte_rrc_EDT_TBS_InfoList_NB_r15 = -1;
static gint ett_lte_rrc_EDT_TBS_NB_r15 = -1;
static gint ett_lte_rrc_NPUSCH_ConfigCommon_NB_r13 = -1;
static gint ett_lte_rrc_SEQUENCE_SIZE_1_maxNPRACH_Resources_NB_r13_OF_ACK_NACK_NumRepetitions_NB_r13 = -1;
static gint ett_lte_rrc_T_dmrs_Config_r13 = -1;
static gint ett_lte_rrc_UL_ReferenceSignalsNPUSCH_NB_r13 = -1;
static gint ett_lte_rrc_NPUSCH_ConfigDedicated_NB_r13 = -1;
static gint ett_lte_rrc_PDCP_Config_NB_r13 = -1;
static gint ett_lte_rrc_T_headerCompression_r13 = -1;
static gint ett_lte_rrc_T_rohc_01 = -1;
static gint ett_lte_rrc_T_profiles_r13 = -1;
static gint ett_lte_rrc_PhysicalConfigDedicated_NB_r13 = -1;
static gint ett_lte_rrc_RACH_ConfigCommon_NB_r13 = -1;
static gint ett_lte_rrc_RACH_InfoList_NB_r13 = -1;
static gint ett_lte_rrc_RACH_InfoList_NB_v1530 = -1;
static gint ett_lte_rrc_RACH_Info_NB_r13 = -1;
static gint ett_lte_rrc_RACH_Info_NB_v1530 = -1;
static gint ett_lte_rrc_PowerRampingParameters_NB_v1450 = -1;
static gint ett_lte_rrc_T_powerRampingParametersCE1_r14 = -1;
static gint ett_lte_rrc_RadioResourceConfigCommonSIB_NB_r13 = -1;
static gint ett_lte_rrc_BCCH_Config_NB_r13 = -1;
static gint ett_lte_rrc_PCCH_Config_NB_r13 = -1;
static gint ett_lte_rrc_RadioResourceConfigDedicated_NB_r13 = -1;
static gint ett_lte_rrc_T_mac_MainConfig_r13 = -1;
static gint ett_lte_rrc_SRB_ToAddModList_NB_r13 = -1;
static gint ett_lte_rrc_SRB_ToAddMod_NB_r13 = -1;
static gint ett_lte_rrc_T_rlc_Config_r13 = -1;
static gint ett_lte_rrc_T_logicalChannelConfig_r13 = -1;
static gint ett_lte_rrc_DRB_ToAddModList_NB_r13 = -1;
static gint ett_lte_rrc_DRB_ToAddMod_NB_r13 = -1;
static gint ett_lte_rrc_DRB_ToReleaseList_NB_r13 = -1;
static gint ett_lte_rrc_RLC_Config_NB_r13 = -1;
static gint ett_lte_rrc_T_am_01 = -1;
static gint ett_lte_rrc_RLC_Config_NB_v1430 = -1;
static gint ett_lte_rrc_UL_AM_RLC_NB_r13 = -1;
static gint ett_lte_rrc_DL_AM_RLC_NB_r13 = -1;
static gint ett_lte_rrc_RLF_TimersAndConstants_NB_r13 = -1;
static gint ett_lte_rrc_T_setup_178 = -1;
static gint ett_lte_rrc_SchedulingRequestConfig_NB_r15 = -1;
static gint ett_lte_rrc_SR_WithoutHARQ_ACK_Config_NB_r15 = -1;
static gint ett_lte_rrc_T_setup_179 = -1;
static gint ett_lte_rrc_SR_NPRACH_Resource_NB_r15 = -1;
static gint ett_lte_rrc_T_nprach_SubCarrierIndex_r15 = -1;
static gint ett_lte_rrc_SR_SPS_BSR_Config_NB_r15 = -1;
static gint ett_lte_rrc_T_setup_180 = -1;
static gint ett_lte_rrc_TDD_Config_NB_r15 = -1;
static gint ett_lte_rrc_UplinkPowerControlCommon_NB_r13 = -1;
static gint ett_lte_rrc_UplinkPowerControlDedicated_NB_r13 = -1;
static gint ett_lte_rrc_WUS_Config_NB_r15 = -1;
static gint ett_lte_rrc_WUS_ConfigPerCarrier_NB_r15 = -1;
static gint ett_lte_rrc_AdditionalBandInfoList_NB_r14 = -1;
static gint ett_lte_rrc_MultiBandInfoList_NB_r13 = -1;
static gint ett_lte_rrc_MultiBandInfo_NB_r13 = -1;
static gint ett_lte_rrc_NS_PmaxList_NB_r13 = -1;
static gint ett_lte_rrc_NS_PmaxValue_NB_r13 = -1;
static gint ett_lte_rrc_MeasResultServCell_NB_r14 = -1;
static gint ett_lte_rrc_NSSS_RRM_Config_NB_r15 = -1;
static gint ett_lte_rrc_UE_Capability_NB_r13 = -1;
static gint ett_lte_rrc_T_dummy_06 = -1;
static gint ett_lte_rrc_UE_Capability_NB_Ext_r14_IEs = -1;
static gint ett_lte_rrc_UE_Capability_NB_v1440_IEs = -1;
static gint ett_lte_rrc_UE_Capability_NB_v14x0_IEs = -1;
static gint ett_lte_rrc_UE_Capability_NB_v1530_IEs = -1;
static gint ett_lte_rrc_T_nonCriticalExtension_104 = -1;
static gint ett_lte_rrc_TDD_UE_Capability_NB_r15 = -1;
static gint ett_lte_rrc_PDCP_Parameters_NB_r13 = -1;
static gint ett_lte_rrc_T_supportedROHC_Profiles_r13 = -1;
static gint ett_lte_rrc_RLC_Parameters_NB_r15 = -1;
static gint ett_lte_rrc_MAC_Parameters_NB_r14 = -1;
static gint ett_lte_rrc_MAC_Parameters_NB_v1530 = -1;
static gint ett_lte_rrc_PhyLayerParameters_NB_r13 = -1;
static gint ett_lte_rrc_PhyLayerParameters_NB_v1430 = -1;
static gint ett_lte_rrc_PhyLayerParameters_NB_v1440 = -1;
static gint ett_lte_rrc_PhyLayerParameters_NB_v1530 = -1;
static gint ett_lte_rrc_RF_Parameters_NB_r13 = -1;
static gint ett_lte_rrc_RF_Parameters_NB_v1430 = -1;
static gint ett_lte_rrc_SupportedBandList_NB_r13 = -1;
static gint ett_lte_rrc_SupportedBand_NB_r13 = -1;
static gint ett_lte_rrc_UE_RadioPagingInfo_NB_r13 = -1;
static gint ett_lte_rrc_UE_TimersAndConstants_NB_r13 = -1;
static gint ett_lte_rrc_SC_MTCH_InfoList_NB_r14 = -1;
static gint ett_lte_rrc_SC_MTCH_Info_NB_r14 = -1;
static gint ett_lte_rrc_T_sc_mtch_CarrierConfig_r14 = -1;
static gint ett_lte_rrc_SC_MTCH_SchedulingInfo_NB_r14 = -1;
static gint ett_lte_rrc_T_schedulingPeriodStartOffsetSCPTM_r14_03 = -1;
static gint ett_lte_rrc_SCPTM_NeighbourCellList_NB_r14 = -1;
static gint ett_lte_rrc_PCI_ARFCN_NB_r14 = -1;

/*--- End of included file: packet-lte-rrc-ett.c ---*/
#line 272 "./asn1/lte-rrc/packet-lte-rrc-template.c"

static gint ett_lte_rrc_featureGroupIndicators = -1;
static gint ett_lte_rrc_featureGroupIndRel9Add = -1;
static gint ett_lte_rrc_featureGroupIndRel10 = -1;
static gint ett_lte_rrc_absTimeInfo = -1;
static gint ett_lte_rrc_nas_SecurityParam = -1;
static gint ett_lte_rrc_targetRAT_MessageContainer = -1;
static gint ett_lte_rrc_siPsiSibContainer = -1;
static gint ett_lte_rrc_dedicatedInfoNAS = -1;
static gint ett_lte_rrc_timeInfo = -1;
static gint ett_lte_rrc_serialNumber = -1;
static gint ett_lte_rrc_warningType = -1;
static gint ett_lte_rrc_dataCodingScheme = -1;
static gint ett_lte_rrc_warningMessageSegment = -1;
static gint ett_lte_rrc_interBandTDD_CA_WithDifferentConfig = -1;
static gint ett_lte_rrc_tdd_FDD_CA_PCellDuplex_r12 = -1;
static gint ett_lte_rrc_aperiodicCSI_Reporting_r13 = -1;
static gint ett_lte_rrc_codebook_HARQ_ACK_r13 = -1;
static gint ett_lte_rrc_sr_ConfigIndex = -1;
static gint ett_lte_rrc_transmissionModeList_r12 = -1;
static gint ett_lte_rrc_modifiedMPR_Behavior_r10 = -1;
static gint ett_lte_rrc_sib11_fragment = -1;
static gint ett_lte_rrc_sib11_fragments = -1;
static gint ett_lte_rrc_sib12_fragment = -1;
static gint ett_lte_rrc_sib12_fragments = -1;
static gint ett_lte_rrc_nr_SecondaryCellGroupConfig_r15 = -1;
static gint ett_lte_rrc_nr_RadioBearerConfig_r15 = -1;
static gint ett_lte_rrc_nr_RadioBearerConfigS_r15 = -1;
static gint ett_lte_rrc_scg_ConfigResponseNR_r15 = -1;
static gint ett_lte_rrc_measResultSCG_r15 = -1;
static gint ett_lte_rrc_ul_DCCH_MessageNR_r15 = -1;
static gint ett_lte_rrc_sourceRB_ConfigNR_r15 = -1;
static gint ett_lte_rrc_sourceRB_ConfigSN_NR_r15 = -1;
static gint ett_lte_rrc_sourceOtherConfigSN_NR_r15 = -1;
static gint ett_lte_rrc_sourceContextEN_DC_r15 = -1;
static gint ett_lte_rrc_requestedFreqBandsNR_MRDC_r15 = -1;
static gint ett_lte_rrc_measGapPatterns_r15 = -1;
static gint ett_lte_rrc_nas_Container_r15 = -1;
static gint ett_lte_rrc_sourceRB_ConfigIntra5GC_r15 = -1;
static gint ett_lte_rrc_selectedbandCombinationInfoEN_DC_v1540 = -1;
static gint ett_lte_rrc_requestedCapabilityCommon_r15 = -1;

static expert_field ei_lte_rrc_number_pages_le15 = EI_INIT;
static expert_field ei_lte_rrc_si_info_value_changed = EI_INIT;
static expert_field ei_lte_rrc_sibs_changing = EI_INIT;
static expert_field ei_lte_rrc_sibs_changing_edrx = EI_INIT;
static expert_field ei_lte_rrc_earthquake_warning_sys = EI_INIT;
static expert_field ei_lte_rrc_commercial_mobile_alert_sys = EI_INIT;
static expert_field ei_lte_rrc_unexpected_type_value = EI_INIT;
static expert_field ei_lte_rrc_unexpected_length_value = EI_INIT;
static expert_field ei_lte_rrc_too_many_group_a_rapids = EI_INIT;
static expert_field ei_lte_rrc_invalid_drx_config = EI_INIT;

static const unit_name_string units_sr_periods = { " SR period", " SR periods" };
static const unit_name_string units_short_drx_cycles = { " shortDRX-Cycle", " shortDRX-Cycles" };

static reassembly_table lte_rrc_sib11_reassembly_table;
static reassembly_table lte_rrc_sib12_reassembly_table;

static const fragment_items lte_rrc_sib11_frag_items = {
    &ett_lte_rrc_sib11_fragment,
    &ett_lte_rrc_sib11_fragments,
    &hf_lte_rrc_sib11_fragments,
    &hf_lte_rrc_sib11_fragment,
    &hf_lte_rrc_sib11_fragment_overlap,
    &hf_lte_rrc_sib11_fragment_overlap_conflict,
    &hf_lte_rrc_sib11_fragment_multiple_tails,
    &hf_lte_rrc_sib11_fragment_too_long_fragment,
    &hf_lte_rrc_sib11_fragment_error,
    &hf_lte_rrc_sib11_fragment_count,
    &hf_lte_rrc_sib11_reassembled_in,
    &hf_lte_rrc_sib11_reassembled_length,
    &hf_lte_rrc_sib11_reassembled_data,
    "SIB11 warning message segments"
};

static const fragment_items lte_rrc_sib12_frag_items = {
    &ett_lte_rrc_sib12_fragment,
    &ett_lte_rrc_sib12_fragments,
    &hf_lte_rrc_sib12_fragments,
    &hf_lte_rrc_sib12_fragment,
    &hf_lte_rrc_sib12_fragment_overlap,
    &hf_lte_rrc_sib12_fragment_overlap_conflict,
    &hf_lte_rrc_sib12_fragment_multiple_tails,
    &hf_lte_rrc_sib12_fragment_too_long_fragment,
    &hf_lte_rrc_sib12_fragment_error,
    &hf_lte_rrc_sib12_fragment_count,
    &hf_lte_rrc_sib12_reassembled_in,
    &hf_lte_rrc_sib12_reassembled_length,
    &hf_lte_rrc_sib12_reassembled_data,
    "SIB12 warning message segments"
};

/* Forward declarations */
static int dissect_DL_DCCH_Message_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_);
static int dissect_UECapabilityInformation_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_);

static const true_false_string lte_rrc_eutra_cap_feat_group_ind_1_val = {
  "Intra-subframe freq hopping for PUSCH scheduled by UL grant; DCI format 3a; Aperiodic CQI/PMI/RI report on PUSCH: Mode 2-0 & 2-2 - Supported",
  "Intra-subframe freq hopping for PUSCH scheduled by UL grant; DCI format 3a; Aperiodic CQI/PMI/RI report on PUSCH: Mode 2-0 & 2-2 - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_2_val = {
  "Simultaneous CQI & ACK/NACK on PUCCH (format 2a/2b); Absolute TPC command for PUSCH; Resource alloc type 1 for PDSCH; Periodic CQI/PMI/RI report on PUCCH: Mode 2-0 & 2-1 - Supported",
  "Simultaneous CQI & ACK/NACK on PUCCH (format 2a/2b); Absolute TPC command for PUSCH; Resource alloc type 1 for PDSCH; Periodic CQI/PMI/RI report on PUCCH: Mode 2-0 & 2-1 - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_3_val = {
  "5bit RLC UM SN; 7bit PDCP SN - Supported",
  "5bit RLC UM SN; 7bit PDCP SN - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_4_val = {
  "Short DRX cycle - Supported",
  "Short DRX cycle - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_5_val = {
  "Long DRX cycle; DRX command MAC control element - Supported",
  "Long DRX cycle; DRX command MAC control element - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_6_val = {
  "Prioritised bit rate - Supported",
  "Prioritised bit rate - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_7_val = {
  "RLC UM - Supported",
  "RLC UM - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_8_val = {
  "EUTRA RRC_CONNECTED to UTRA CELL_DCH PS handover - Supported",
  "EUTRA RRC_CONNECTED to UTRA CELL_DCH PS handover - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_9_val = {
  "EUTRA RRC_CONNECTED to GERAN GSM_Dedicated handover - Supported",
  "EUTRA RRC_CONNECTED to GERAN GSM_Dedicated handover - Not Supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_10_val = {
  "EUTRA RRC_CONNECTED to GERAN (Packet_) Idle by Cell Change Order; EUTRA RRC_CONNECTED to GERAN (Packet_) Idle by Cell Change Order with NACC - Supported",
  "EUTRA RRC_CONNECTED to GERAN (Packet_) Idle by Cell Change Order; EUTRA RRC_CONNECTED to GERAN (Packet_) Idle by Cell Change Order with NACC - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_11_val = {
  "EUTRA RRC_CONNECTED to CDMA2000 1xRTT CS Active handover - Supported",
  "EUTRA RRC_CONNECTED to CDMA2000 1xRTT CS Active handover - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_12_val = {
  "EUTRA RRC_CONNECTED to CDMA2000 HRPD Active handover - Supported",
  "EUTRA RRC_CONNECTED to CDMA2000 HRPD Active handover - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_13_val = {
  "Inter-frequency handover (within FDD or TDD) - Supported",
  "Inter-frequency handover (within FDD or TDD) - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_14_val = {
  "Measurement reporting event: Event A4 - Neighbour > threshold; Measurement reporting event: Event A5 - Serving < threshold1 & Neighbour > threshold2 - Supported",
  "Measurement reporting event: Event A4 - Neighbour > threshold; Measurement reporting event: Event A5 - Serving < threshold1 & Neighbour > threshold2 - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_15_val = {
  "Measurement reporting event: Event B1 - Neighbour > threshold - Supported",
  "Measurement reporting event: Event B1 - Neighbour > threshold - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_16_val = {
  "non-ANR related periodical measurement reporting - Supported",
  "non-ANR related periodical measurement reporting - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_17_val = {
  "ANR related intra-frequency measurement reporting events - Supported",
  "ANR related intra-frequency measurement reporting events - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_18_val = {
  "ANR related inter-frequency measurement reporting events - Supported",
  "ANR related inter-frequency measurement reporting events - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_19_val = {
  "ANR related inter-RAT measurement reporting events - Supported",
  "ANR related inter-RAT measurement reporting events - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_20_val = {
  "SRB1 and SRB2 for DCCH + 8x AM DRB; SRB1 and SRB2 for DCCH + 5x AM DRB + 3x UM DRB (if indicator 7 is supported) - Supported",
  "SRB1 and SRB2 for DCCH + 8x AM DRB; SRB1 and SRB2 for DCCH + 5x AM DRB + 3x UM DRB (if indicator 7 is supported) - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_21_val = {
  "Predefined intra- and inter-subframe frequency hopping for PUSCH with N_sb > 1; Predefined inter-subframe frequency hopping for PUSCH with N_sb > 1 - Supported",
  "Predefined intra- and inter-subframe frequency hopping for PUSCH with N_sb > 1; Predefined inter-subframe frequency hopping for PUSCH with N_sb > 1 - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_22_val = {
  "UTRAN measurements, reporting and measurement reporting event B2 in E-UTRA connected mode - Supported",
  "UTRAN measurements, reporting and measurement reporting event B2 in E-UTRA connected mode - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_23_val = {
  "GERAN measurements, reporting and measurement reporting event B2 in E-UTRA connected mode - Supported",
  "GERAN measurements, reporting and measurement reporting event B2 in E-UTRA connected mode - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_24_val = {
  "1xRTT measurements, reporting and measurement reporting event B2 in E-UTRA connected mode - Supported",
  "1xRTT measurements, reporting and measurement reporting event B2 in E-UTRA connected mode - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_25_val = {
  "Inter-frequency measurements and reporting in E-UTRA connected mode - Supported",
  "Inter-frequency measurements and reporting in E-UTRA connected mode - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_26_val = {
  "HRPD measurements, reporting and measurement reporting event B2 in E-UTRA connected mode - Supported",
  "HRPD measurements, reporting and measurement reporting event B2 in E-UTRA connected mode - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_27_val = {
  "EUTRA RRC_CONNECTED to UTRA CELL_DCH CS handover - Supported",
  "EUTRA RRC_CONNECTED to UTRA CELL_DCH CS handover - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_28_val = {
  "TTI bundling - Supported",
  "TTI bundling - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_29_val = {
  "Semi-Persistent Scheduling - Supported",
  "Semi-Persistent Scheduling - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_30_val = {
  "Handover between FDD and TDD - Supported",
  "Handover between FDD and TDD - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_31_val = {
  "Mechanisms defined for cells broadcasting multi band information - Supported",
  "Mechanisms defined for cells broadcasting multi band information - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_32_val = {
  "Undefined - Supported",
  "Undefined - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_33_val = {
  "Inter-RAT ANR features for UTRAN FDD - Supported",
  "Inter-RAT ANR features for UTRAN FDD - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_34_val = {
  "Inter-RAT ANR features for GERAN - Supported",
  "Inter-RAT ANR features for GERAN - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_35_val = {
  "Inter-RAT ANR features for 1xRTT - Supported",
  "Inter-RAT ANR features for 1xRTT - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_36_val = {
  "Inter-RAT ANR features for HRPD - Supported",
  "Inter-RAT ANR features for HRPD - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_37_val = {
  "Inter-RAT ANR features for UTRAN TDD - Supported",
  "Inter-RAT ANR features for UTRAN TDD - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_38_val = {
  "EUTRA RRC_CONNECTED to UTRA TDD CELL_DCH PS handover - Supported",
  "EUTRA RRC_CONNECTED to UTRA TDD CELL_DCH PS handover - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_39_val = {
  "UTRAN TDD measurements, reporting and measurement reporting event B2 in E-UTRA connected mode - Supported",
  "UTRAN TDD measurements, reporting and measurement reporting event B2 in E-UTRA connected mode - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_40_val = {
  "EUTRA RRC_CONNECTED to UTRA TDD CELL_DCH CS handover - Supported",
  "EUTRA RRC_CONNECTED to UTRA TDD CELL_DCH CS handover - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_41_val = {
  "Measurement reporting event: Event B1 - Neighbour > threshold for UTRAN FDD - Supported",
  "Measurement reporting event: Event B1 - Neighbour > threshold for UTRAN FDD - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_42_val = {
  "DCI format 3a - Supported",
  "DCI format 3a - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_43_val = {
  "Undefined - Supported",
  "Undefined - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_44_val = {
  "Undefined - Supported",
  "Undefined - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_45_val = {
  "Undefined - Supported",
  "Undefined - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_46_val = {
  "Undefined - Supported",
  "Undefined - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_47_val = {
  "Undefined - Supported",
  "Undefined - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_48_val = {
  "Undefined - Supported",
  "Undefined - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_49_val = {
  "Undefined - Supported",
  "Undefined - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_50_val = {
  "Undefined - Supported",
  "Undefined - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_51_val = {
  "Undefined - Supported",
  "Undefined - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_52_val = {
  "Undefined - Supported",
  "Undefined - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_53_val = {
  "Undefined - Supported",
  "Undefined - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_54_val = {
  "Undefined - Supported",
  "Undefined - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_55_val = {
  "Undefined - Supported",
  "Undefined - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_56_val = {
  "Undefined - Supported",
  "Undefined - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_57_val = {
  "Undefined - Supported",
  "Undefined - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_58_val = {
  "Undefined - Supported",
  "Undefined - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_59_val = {
  "Undefined - Supported",
  "Undefined - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_60_val = {
  "Undefined - Supported",
  "Undefined - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_61_val = {
  "Undefined - Supported",
  "Undefined - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_62_val = {
  "Undefined - Supported",
  "Undefined - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_63_val = {
  "Undefined - Supported",
  "Undefined - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_64_val = {
  "Undefined - Supported",
  "Undefined - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_101_val = {
  "DMRS with OCC (orthogonal cover code) and SGH (sequence group hopping) disabling - Supported",
  "DMRS with OCC (orthogonal cover code) and SGH (sequence group hopping) disabling - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_102_val = {
  "Trigger type 1 SRS (aperiodic SRS) transmission (Up to X ports) - Supported",
  "Trigger type 1 SRS (aperiodic SRS) transmission (Up to X ports) - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_103_val = {
  "PDSCH TM9 when up to 4 CSI reference signal ports are configured - Supported",
  "PDSCH TM9 when up to 4 CSI reference signal ports are configured - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_104_val = {
  "PDSCH TM9 for TDD when 8 CSI reference signal ports are configured - Supported",
  "PDSCH TM9 for TDD when 8 CSI reference signal ports are configured - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_105_val = {
  "PUCCH RM2-0 when PDSCH TM9 is configured and RM2-1 when PDSCH TM9 and up to 4 CSI reference signal ports are configured - Supported",
  "PUCCH RM2-0 when PDSCH TM9 is configured and RM2-1 when PDSCH TM9 and up to 4 CSI reference signal ports are configured - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_106_val = {
  "PUCCH RM2-1 when PDSCH TM9 and 8 CSI reference signal ports are configured - Supported",
  "PUCCH RM2-1 when PDSCH TM9 and 8 CSI reference signal ports are configured - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_107_val = {
  "PUSCH RM2-0 when PDSCH TM9 is configured and RM2-2 when PDSCH TM9 and up to 4 CSI reference signal ports are configured - Supported",
  "PUSCH RM2-0 when PDSCH TM9 is configured and RM2-2 when PDSCH TM9 and up to 4 CSI reference signal ports are configured - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_108_val = {
  "PUSCH RM2-2 when PDSCH TM9 and 8 CSI reference signal ports are configured - Supported",
  "PUSCH RM2-2 when PDSCH TM9 and 8 CSI reference signal ports are configured - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_109_val = {
  "PUCCH RM1-1 submode 1 - Supported",
  "PUCCH RM1-1 submode 1 - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_110_val = {
  "PUCCH RM1-1 submode 2 - Supported",
  "PUCCH RM1-1 submode 2 - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_111_val = {
  "Measurement reporting trigger Event A6 - Supported",
  "Measurement reporting trigger Event A6 - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_112_val = {
  "SCell addition within the Handover to EUTRA procedure - Supported",
  "SCell addition within the Handover to EUTRA procedure - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_113_val = {
  "Trigger type 0 SRS (periodic SRS) transmission on X Serving Cells - Supported",
  "Trigger type 0 SRS (periodic SRS) transmission on X Serving Cells - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_114_val = {
  "Reporting of both UTRA CPICH RSCP and Ec/N0 in a Measurement Report - Supported",
  "Reporting of both UTRA CPICH RSCP and Ec/N0 in a Measurement Report - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_115_val = {
  "Time domain ICIC RLM/RRM / ICIC RRM / ICIC CSI measurement sf restriction for the serving cell / neighbour cells - Supported",
  "Time domain ICIC RLM/RRM / ICIC RRM / ICIC CSI measurement sf restriction for the serving cell / neighbour cells - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_116_val = {
  "Relative transmit phase continuity for spatial multiplexing in UL - Supported",
  "Relative transmit phase continuity for spatial multiplexing in UL - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_117_val = {
  "Undefined - Supported",
  "Undefined - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_118_val = {
  "Undefined - Supported",
  "Undefined - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_119_val = {
  "Undefined - Supported",
  "Undefined - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_120_val = {
  "Undefined - Supported",
  "Undefined - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_121_val = {
  "Undefined - Supported",
  "Undefined - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_122_val = {
  "Undefined - Supported",
  "Undefined - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_123_val = {
  "Undefined - Supported",
  "Undefined - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_124_val = {
  "Undefined - Supported",
  "Undefined - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_125_val = {
  "Undefined - Supported",
  "Undefined - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_126_val = {
  "Undefined - Supported",
  "Undefined - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_127_val = {
  "Undefined - Supported",
  "Undefined - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_128_val = {
  "Undefined - Supported",
  "Undefined - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_129_val = {
  "Undefined - Supported",
  "Undefined - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_130_val = {
  "Undefined - Supported",
  "Undefined - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_131_val = {
  "Undefined - Supported",
  "Undefined - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_132_val = {
  "Undefined - Supported",
  "Undefined - Not supported"
};

static const value_string lte_rrc_schedulingInfoSIB1_BR_r13_vals[] = {
  {  0, "SystemInformationBlockType1-BR is not scheduled"},
  {  1, "4 PDSCH repetitions - TBS 208 bits"},
  {  2, "8 PDSCH repetitions - TBS 208 bits"},
  {  3, "16 PDSCH repetitions - TBS 208 bits"},
  {  4, "4 PDSCH repetitions - TBS 256 bits"},
  {  5, "8 PDSCH repetitions - TBS 256 bits"},
  {  6, "16 PDSCH repetitions - TBS 256 bits"},
  {  7, "4 PDSCH repetitions - TBS 328 bits"},
  {  8, "8 PDSCH repetitions - TBS 328 bits"},
  {  9, "16 PDSCH repetitions - TBS 328 bits"},
  { 10, "4 PDSCH repetitions - TBS 504 bits"},
  { 11, "8 PDSCH repetitions - TBS 504 bits"},
  { 12, "16 PDSCH repetitions - TBS 504 bits"},
  { 13, "4 PDSCH repetitions - TBS 712 bits"},
  { 14, "8 PDSCH repetitions - TBS 712 bits"},
  { 15, "16 PDSCH repetitions - TBS 712 bits"},
  { 16, "4 PDSCH repetitions - TBS 936 bits"},
  { 17, "8 PDSCH repetitions - TBS 936 bits"},
  { 18, "16 PDSCH repetitions - TBS 936 bits"},
  {  0, NULL}
};
static value_string_ext lte_rrc_schedulingInfoSIB1_BR_r13_vals_ext = VALUE_STRING_EXT_INIT(lte_rrc_schedulingInfoSIB1_BR_r13_vals);

static const value_string lte_rrc_q_RxLevMin_vals[] = {
  { -70, "-140dBm"},
  { -69, "-138dBm"},
  { -68, "-136dBm"},
  { -67, "-134dBm"},
  { -66, "-132dBm"},
  { -65, "-130dBm"},
  { -64, "-128dBm"},
  { -63, "-126dBm"},
  { -62, "-124dBm"},
  { -61, "-122dBm"},
  { -60, "-120dBm"},
  { -59, "-118dBm"},
  { -58, "-116dBm"},
  { -57, "-114dBm"},
  { -56, "-112dBm"},
  { -55, "-110dBm"},
  { -54, "-108dBm"},
  { -53, "-106dBm"},
  { -52, "-104dBm"},
  { -51, "-102dBm"},
  { -50, "-100dBm"},
  { -49, "-98dBm"},
  { -48, "-96dBm"},
  { -47, "-94dBm"},
  { -46, "-92dBm"},
  { -45, "-90dBm"},
  { -44, "-88dBm"},
  { -43, "-86dBm"},
  { -42, "-84dBm"},
  { -41, "-82dBm"},
  { -40, "-80dBm"},
  { -39, "-78dBm"},
  { -38, "-76dBm"},
  { -37, "-74dBm"},
  { -36, "-72dBm"},
  { -35, "-70dBm"},
  { -34, "-68dBm"},
  { -33, "-66dBm"},
  { -32, "-64dBm"},
  { -31, "-62dBm"},
  { -30, "-60dBm"},
  { -29, "-58dBm"},
  { -28, "-56dBm"},
  { -27, "-54dBm"},
  { -26, "-52dBm"},
  { -25, "-50dBm"},
  { -24, "-48dBm"},
  { -23, "-46dBm"},
  { -22, "-44dBm"},
  {   0, NULL}
};
static value_string_ext lte_rrc_q_RxLevMin_vals_ext = VALUE_STRING_EXT_INIT(lte_rrc_q_RxLevMin_vals);

static const value_string lte_rrc_q_RxLevMinOffset_vals[] = {
  { 1, "2dB"},
  { 2, "4dB"},
  { 3, "6dB"},
  { 4, "8dB"},
  { 5, "10dB"},
  { 6, "12dB"},
  { 7, "14dB"},
  { 8, "16dB"},
  { 0, NULL}
};

static const value_string lte_rrc_delta_RxLevMin_vals[] = {
  { -8, "-16dBm"},
  { -7, "-14dBm"},
  { -6, "-12dBm"},
  { -5, "-10dBm"},
  { -4, "-8dBm"},
  { -3, "-6dBm"},
  { -2, "-4dBm"},
  { -1, "-2dBm"},
  { 0, NULL}
};

static const value_string lte_rrc_messageSize_r14_vals[] =
{
    { 0,  "size = 0"},
    { 1,  "0 < size <= 10"},
    { 2,  "10 < size <= 12"},
    { 3,  "12 < size <= 14"},
    { 4,  "14 < size <= 17"},
    { 5,  "17 < size <= 19"},
    { 6,  "19 < size <= 22"},
    { 7,  "22 < size <= 26"},
    { 8,  "26 < size <= 31"},
    { 9,  "31 < size <= 36"},
    { 10, "36 < size <= 42"},
    { 11, "42 < size <= 49"},
    { 12, "49 < size <= 57"},
    { 13, "57 < size <= 67"},
    { 14, "67 < size <= 78"},
    { 15, "78 < size <= 91"},
    { 16, "91 < size <= 107"},
    { 17, "107 < size <= 125"},
    { 18, "125 < size <= 146"},
    { 19, "146 < size <= 171"},
    { 20, "171 < size <= 200"},
    { 21, "200 < size <= 234"},
    { 22, "234 < size <= 274"},
    { 23, "274 < size <= 321"},
    { 24, "321 < size <= 376"},
    { 25, "376 < size <= 440"},
    { 26, "440 < size <= 515"},
    { 27, "515 < size <= 603"},
    { 28, "603 < size <= 706"},
    { 29, "706 < size <= 826"},
    { 30, "826 < size <= 967"},
    { 31, "967 < size <= 1132"},
    { 32, "1132 < size <= 1326"},
    { 33, "1326 < size <= 1552"},
    { 34, "1552 < size <= 1817"},
    { 35, "1817 < size <= 2127"},
    { 36, "2127 < size <= 2490"},
    { 37, "2490 < size <= 2915"},
    { 38, "2915 < size <= 3413"},
    { 39, "3413 < size <= 3995"},
    { 40, "3995 < size <= 4677"},
    { 41, "4677 < size <= 5476"},
    { 42, "5476 < size <= 6411"},
    { 43, "6411 < size <= 7505"},
    { 44, "7505 < size <= 8787"},
    { 45, "8787 < size <= 10276"},
    { 46, "10287 < size <= 12043"},
    { 47, "12043 < size <= 14099"},
    { 48, "14099 < size <= 16507"},
    { 49, "16507 < size <= 19325"},
    { 50, "19325 < size <= 22624"},
    { 51, "22624 < size <= 26487"},
    { 52, "26487 < size <= 31009"},
    { 53, "31009 < size <= 36304"},
    { 54, "36304 < size <= 42502"},
    { 55, "42502 < size <= 49759"},
    { 56, "49759 < size <= 58255"},
    { 57, "58255 < size <= 68201"},
    { 58, "68201 < size <= 79846"},
    { 59, "79846 < size <= 93479"},
    { 60, "93479 < size <= 109439"},
    { 61, "109439 < size <= 128125"},
    { 62, "128125 < size <= 150000"},
    { 63, "size > 150000"},
    { 0, NULL }
};
static value_string_ext lte_rrc_messageSize_r14_vals_ext = VALUE_STRING_EXT_INIT(lte_rrc_messageSize_r14_vals);

static void
lte_rrc_timeConnFailure_r10_fmt(gchar *s, guint32 v)
{
  g_snprintf(s, ITEM_LABEL_LENGTH, "%ums (%u)", 100*v, v);
}

static const value_string lte_rrc_n_r12_vals[] = {
  {  0, "0 <= Nr < 256"},
  {  1, "256 <= Nr < 768"},
  {  2, "768 <= Nr < 1792"},
  {  3, "1792 <= Nr < 3840"},
  {  4, "3840 <= Nr < 7936"},
  {  5, "7936 <= Nr < 16128"},
  {  6, "16128 <= Nr < 32512"},
  {  7, "32512 <= Nr"},
  {  0, NULL},
};

static void
lte_rrc_m_r12_fmt(gchar *s, guint32 v)
{
  if (v == 255) {
    g_snprintf(s, ITEM_LABEL_LENGTH, "255 <= f(Nr) (255)");
  } else {
    g_snprintf(s, ITEM_LABEL_LENGTH, "%u <= f(Nr) < %u (%u)", v, v+1, v);
  }
}

static const value_string lte_rrc_BLER_Range_r12_vals[] = {
  {  0, "BLER < 0.1%"},
  {  1, "0.1% <= BLER < 0.123%"},
  {  2, "0.123% <= BLER < 0.151%"},
  {  3, "0.151% <= BLER < 0.186%"},
  {  4, "0.186% <= BLER < 0.229%"},
  {  5, "0.229% <= BLER < 0.282%"},
  {  6, "0.282% <= BLER < 0.347%"},
  {  7, "0.347% <= BLER < 0.426%"},
  {  8, "0.426% <= BLER < 0.525%"},
  {  9, "0.525% <= BLER < 0.645%"},
  { 10, "0.645% <= BLER < 0.794%"},
  { 11, "0.794% <= BLER < 0.976%"},
  { 12, "0.976% <= BLER < 1.201%"},
  { 13, "1.201% <= BLER < 1.478%"},
  { 14, "1.478% <= BLER < 1.818%"},
  { 15, "1.818% <= BLER < 2.236%"},
  { 16, "2.236% <= BLER < 2.751%"},
  { 17, "2.751% <= BLER < 3.384%"},
  { 18, "3.384% <= BLER < 4.163%"},
  { 19, "4.163% <= BLER < 5.121%"},
  { 20, "5.121% <= BLER < 6.300%"},
  { 21, "6.300% <= BLER < 7.750%"},
  { 22, "7.750% <= BLER < 9.533%"},
  { 23, "9.533% <= BLER < 11.728%"},
  { 24, "11.728% <= BLER < 14.427%"},
  { 25, "14.427% <= BLER < 17.478%"},
  { 26, "17.478% <= BLER < 21.833%"},
  { 27, "21.833% <= BLER < 26.858%"},
  { 28, "26.858% <= BLER < 33.040%"},
  { 29, "33.040% <= BLER < 40.645%"},
  { 30, "40.645% <= BLER < 50%"},
  { 31, "50% <= BLER"},
  { 0, NULL}
};
static value_string_ext lte_rrc_BLER_Range_r12_vals_ext = VALUE_STRING_EXT_INIT(lte_rrc_BLER_Range_r12_vals);

static const value_string lte_rrc_utra_q_RxLevMin_vals[] = {
  { -60, "-119dBm"},
  { -59, "-117dBm"},
  { -58, "-115dBm"},
  { -57, "-113dBm"},
  { -56, "-111dBm"},
  { -55, "-109dBm"},
  { -54, "-107dBm"},
  { -53, "-105dBm"},
  { -52, "-103dBm"},
  { -51, "-101dBm"},
  { -50, "-99dBm"},
  { -49, "-97dBm"},
  { -48, "-95dBm"},
  { -47, "-93dBm"},
  { -46, "-91dBm"},
  { -45, "-89dBm"},
  { -44, "-87dBm"},
  { -43, "-85dBm"},
  { -42, "-83dBm"},
  { -41, "-81dBm"},
  { -40, "-79dBm"},
  { -39, "-77dBm"},
  { -38, "-75dBm"},
  { -37, "-73dBm"},
  { -36, "-71dBm"},
  { -35, "-69dBm"},
  { -34, "-67dBm"},
  { -33, "-65dBm"},
  { -32, "-63dBm"},
  { -31, "-61dBm"},
  { -30, "-59dBm"},
  { -29, "-57dBm"},
  { -28, "-55dBm"},
  { -27, "-53dBm"},
  { -26, "-51dBm"},
  { -25, "-49dBm"},
  { -24, "-47dBm"},
  { -23, "-45dBm"},
  { -22, "-43dBm"},
  { -21, "-41dBm"},
  { -20, "-39dBm"},
  { -19, "-37dBm"},
  { -18, "-35dBm"},
  { -17, "-33dBm"},
  { -16, "-31dBm"},
  { -15, "-29dBm"},
  { -14, "-27dBm"},
  { -13, "-25dBm"},
  {   0, NULL}
};
static value_string_ext lte_rrc_utra_q_RxLevMin_vals_ext = VALUE_STRING_EXT_INIT(lte_rrc_utra_q_RxLevMin_vals);

static const value_string lte_rrc_geran_q_RxLevMin_vals[] = {
  { 0 , "-115dBm"},
  { 1 , "-113dBm"},
  { 2 , "-111dBm"},
  { 3 , "-109dBm"},
  { 4 , "-107dBm"},
  { 5 , "-105dBm"},
  { 6 , "-103dBm"},
  { 7 , "-101dBm"},
  { 8 , "-99dBm"},
  { 9 , "-97dBm"},
  { 10, "-95dBm"},
  { 11, "-93dBm"},
  { 12, "-91dBm"},
  { 13, "-89dBm"},
  { 14, "-87dBm"},
  { 15, "-85dBm"},
  { 16, "-83dBm"},
  { 17, "-81dBm"},
  { 18, "-79dBm"},
  { 19, "-77dBm"},
  { 20, "-75dBm"},
  { 21, "-73dBm"},
  { 22, "-71dBm"},
  { 23, "-69dBm"},
  { 24, "-67dBm"},
  { 25, "-65dBm"},
  { 26, "-63dBm"},
  { 27, "-61dBm"},
  { 28, "-59dBm"},
  { 29, "-57dBm"},
  { 30, "-55dBm"},
  { 31, "-53dBm"},
  { 32, "-51dBm"},
  { 33, "-49dBm"},
  { 34, "-47dBm"},
  { 35, "-45dBm"},
  { 36, "-43dBm"},
  { 37, "-41dBm"},
  { 38, "-39dBm"},
  { 39, "-37dBm"},
  { 40, "-35dBm"},
  { 41, "-33dBm"},
  { 42, "-31dBm"},
  { 43, "-29dBm"},
  { 44, "-27dBm"},
  { 45, "-25dBm"},
  {  0, NULL}
};
static value_string_ext lte_rrc_geran_q_RxLevMin_vals_ext = VALUE_STRING_EXT_INIT(lte_rrc_geran_q_RxLevMin_vals);

static const value_string lte_rrc_nomPDSCH_RS_EPRE_Offset_vals[] = {
  { -1, "-2dB"},
  {  0, "0dB"},
  {  1, "2dB"},
  {  2, "4dB"},
  {  3, "6dB"},
  {  4, "8dB"},
  {  5, "10dB"},
  {  6, "12dB"},
  {  0, NULL}
};

static const value_string lte_rrc_deltaPreambleMsg3_vals[] = {
  { -1, "-2dB"},
  {  0, "0dB"},
  {  1, "2dB"},
  {  2, "4dB"},
  {  3, "6dB"},
  {  4, "8dB"},
  {  5, "10dB"},
  {  6, "12dB"},
  {  0, NULL}
};

static const value_string lte_rrc_ReselectionThreshold_vals[] = {
  { 0 , "0dB"},
  { 1 , "2dB"},
  { 2 , "4dB"},
  { 3 , "6dB"},
  { 4 , "8dB"},
  { 5 , "10dB"},
  { 6 , "12dB"},
  { 7 , "14dB"},
  { 8 , "16dB"},
  { 9 , "18dB"},
  { 10, "20dB"},
  { 11, "22dB"},
  { 12, "24dB"},
  { 13, "26dB"},
  { 14, "28dB"},
  { 15, "30dB"},
  { 16, "32dB"},
  { 17, "34dB"},
  { 18, "36dB"},
  { 19, "38dB"},
  { 20, "40dB"},
  { 21, "42dB"},
  { 22, "44dB"},
  { 23, "46dB"},
  { 24, "48dB"},
  { 25, "50dB"},
  { 26, "52dB"},
  { 27, "54dB"},
  { 28, "56dB"},
  { 29, "58dB"},
  { 30, "60dB"},
  { 31, "62dB"},
  {  0, NULL}
};
static value_string_ext lte_rrc_ReselectionThreshold_vals_ext = VALUE_STRING_EXT_INIT(lte_rrc_ReselectionThreshold_vals);

static const value_string lte_rrc_ReselectionThreshold_NB_vals[] = {
  { 32, "64dB"},
  { 33, "66dB"},
  { 34, "68dB"},
  { 35, "70dB"},
  { 36, "72dB"},
  { 37, "74dB"},
  { 38, "76dB"},
  { 39, "78dB"},
  { 40, "80dB"},
  { 41, "82dB"},
  { 42, "84dB"},
  { 43, "86dB"},
  { 44, "88dB"},
  { 45, "90dB"},
  { 46, "92dB"},
  { 47, "94dB"},
  { 48, "96dB"},
  { 49, "98dB"},
  { 50, "100dB"},
  { 51, "102dB"},
  { 52, "104dB"},
  { 53, "106dB"},
  { 54, "108dB"},
  { 55, "110dB"},
  { 56, "112dB"},
  { 57, "114dB"},
  { 58, "116dB"},
  { 59, "118dB"},
  { 60, "120dB"},
  { 61, "122dB"},
  { 62, "124dB"},
  { 63, "126dB"},
  {  0, NULL}
};
static value_string_ext lte_rrc_ReselectionThreshold_NB_vals_ext = VALUE_STRING_EXT_INIT(lte_rrc_ReselectionThreshold_NB_vals);

static const value_string lte_rrc_Hysteresis_vals[] = {
  { 0 , "0dB"},
  { 1 , "0.5dB"},
  { 2 , "1dB"},
  { 3 , "1.5dB"},
  { 4 , "2dB"},
  { 5 , "2.5dB"},
  { 6 , "3dB"},
  { 7 , "3.5dB"},
  { 8 , "4dB"},
  { 9 , "4.5dB"},
  { 10, "5dB"},
  { 11, "5.5dB"},
  { 12, "6dB"},
  { 13, "6.5dB"},
  { 14, "7dB"},
  { 15, "7.5dB"},
  { 16, "8dB"},
  { 17, "8.5dB"},
  { 18, "9dB"},
  { 19, "9.5dB"},
  { 20, "10dB"},
  { 21, "10.5dB"},
  { 22, "11dB"},
  { 23, "11.5dB"},
  { 24, "12dB"},
  { 25, "12.5dB"},
  { 26, "13dB"},
  { 27, "13.5dB"},
  { 28, "14dB"},
  { 29, "14.5dB"},
  { 30, "15dB"},
  {  0, NULL}
};
static value_string_ext lte_rrc_Hysteresis_vals_ext = VALUE_STRING_EXT_INIT(lte_rrc_Hysteresis_vals);

static const value_string lte_rrc_s_Measure_vals[] = {
  {  0, "disabled"},
  {  1, "-139dBm"},
  {  2, "-138dBm"},
  {  3, "-137dBm"},
  {  4, "-136dBm"},
  {  5, "-135dBm"},
  {  6, "-134dBm"},
  {  7, "-133dBm"},
  {  8, "-132dBm"},
  {  9, "-131dBm"},
  { 10, "-130dBm"},
  { 11, "-129dBm"},
  { 12, "-128dBm"},
  { 13, "-127dBm"},
  { 14, "-126dBm"},
  { 15, "-125dBm"},
  { 16, "-124dBm"},
  { 17, "-123dBm"},
  { 18, "-122dBm"},
  { 19, "-121dBm"},
  { 20, "-120dBm"},
  { 21, "-119dBm"},
  { 22, "-118dBm"},
  { 23, "-117dBm"},
  { 24, "-116dBm"},
  { 25, "-115dBm"},
  { 26, "-114dBm"},
  { 27, "-113dBm"},
  { 28, "-112dBm"},
  { 29, "-111dBm"},
  { 30, "-110dBm"},
  { 31, "-109dBm"},
  { 32, "-108dBm"},
  { 33, "-107dBm"},
  { 34, "-106dBm"},
  { 35, "-105dBm"},
  { 36, "-104dBm"},
  { 37, "-103dBm"},
  { 38, "-102dBm"},
  { 39, "-101dBm"},
  { 40, "-100dBm"},
  { 41, "-99dBm"},
  { 42, "-98dBm"},
  { 43, "-97dBm"},
  { 44, "-96dBm"},
  { 45, "-95dBm"},
  { 46, "-94dBm"},
  { 47, "-93dBm"},
  { 48, "-92dBm"},
  { 49, "-91dBm"},
  { 50, "-90dBm"},
  { 51, "-89dBm"},
  { 52, "-88dBm"},
  { 53, "-87dBm"},
  { 54, "-86dBm"},
  { 55, "-85dBm"},
  { 56, "-84dBm"},
  { 57, "-83dBm"},
  { 58, "-82dBm"},
  { 59, "-81dBm"},
  { 60, "-80dBm"},
  { 61, "-79dBm"},
  { 62, "-78dBm"},
  { 63, "-77dBm"},
  { 64, "-76dBm"},
  { 65, "-75dBm"},
  { 66, "-74dBm"},
  { 67, "-73dBm"},
  { 68, "-72dBm"},
  { 69, "-71dBm"},
  { 70, "-70dBm"},
  { 71, "-69dBm"},
  { 72, "-68dBm"},
  { 73, "-67dBm"},
  { 74, "-66dBm"},
  { 75, "-65dBm"},
  { 76, "-64dBm"},
  { 77, "-63dBm"},
  { 78, "-62dBm"},
  { 79, "-61dBm"},
  { 80, "-60dBm"},
  { 81, "-59dBm"},
  { 82, "-58dBm"},
  { 83, "-57dBm"},
  { 84, "-56dBm"},
  { 85, "-55dBm"},
  { 86, "-54dBm"},
  { 87, "-53dBm"},
  { 88, "-52dBm"},
  { 89, "-51dBm"},
  { 90, "-50dBm"},
  { 91, "-49dBm"},
  { 92, "-48dBm"},
  { 93, "-47dBm"},
  { 94, "-46dBm"},
  { 95, "-45dBm"},
  { 96, "-44dBm"},
  { 97, "-43dBm"},
  {  0, NULL}
};
static value_string_ext lte_rrc_s_Measure_vals_ext = VALUE_STRING_EXT_INIT(lte_rrc_s_Measure_vals);

static const value_string lte_rrc_utra_EcN0_vals[] = {
  { 0 , "CPICH Ec/Io < -24dB"},
  { 1 , "-24dB <= CPICH Ec/Io < -23.5dB"},
  { 2 , "-23.5dB <= CPICH Ec/Io < -23dB"},
  { 3 , "-23dB <= CPICH Ec/Io < -22.5dB"},
  { 4 , "-22.5dB <= CPICH Ec/Io < -22dB"},
  { 5 , "-22dB <= CPICH Ec/Io < -21.5dB"},
  { 6 , "-21.5dB <= CPICH Ec/Io < -21dB"},
  { 7 , "-21dB <= CPICH Ec/Io < -20.5dB"},
  { 8 , "-20.5dB <= CPICH Ec/Io < -20dB"},
  { 9 , "-20dB <= CPICH Ec/Io < -19.5dB"},
  { 10, "-19.5dB <= CPICH Ec/Io < -19dB"},
  { 11, "-19dB <= CPICH Ec/Io < -18.5dB"},
  { 12, "-18.5dB <= CPICH Ec/Io < -18dB"},
  { 13, "-18dB <= CPICH Ec/Io < -17.5dB"},
  { 14, "-17.5dB <= CPICH Ec/Io < -17dB"},
  { 15, "-17dB <= CPICH Ec/Io < -16.5dB"},
  { 16, "-16.5dB <= CPICH Ec/Io < -16dB"},
  { 17, "-16dB <= CPICH Ec/Io < -15.5dB"},
  { 18, "-15.5dB <= CPICH Ec/Io < -15dB"},
  { 19, "-15dB <= CPICH Ec/Io < -14.5dB"},
  { 20, "-14.5dB <= CPICH Ec/Io < -14dB"},
  { 21, "-14dB <= CPICH Ec/Io < -13.5dB"},
  { 22, "-13.5dB <= CPICH Ec/Io < -13dB"},
  { 23, "-13dB <= CPICH Ec/Io < -12.5dB"},
  { 24, "-12.5dB <= CPICH Ec/Io < -12dB"},
  { 25, "-12dB <= CPICH Ec/Io < -11.5dB"},
  { 26, "-11.5dB <= CPICH Ec/Io < -11dB"},
  { 27, "-11dB <= CPICH Ec/Io < -10.5dB"},
  { 28, "-10.5dB <= CPICH Ec/Io < -10dB"},
  { 29, "-10dB <= CPICH Ec/Io < -9.5dB"},
  { 30, "-9.5dB <= CPICH Ec/Io < -9dB"},
  { 31, "-9dB <= CPICH Ec/Io < -8.5dB"},
  { 32, "-8.5dB <= CPICH Ec/Io < -8dB"},
  { 33, "-8dB <= CPICH Ec/Io < -7.5dB"},
  { 34, "-7.5dB <= CPICH Ec/Io < -7dB"},
  { 35, "-7dB <= CPICH Ec/Io < -6.5dB"},
  { 36, "-6.5dB <= CPICH Ec/Io < -6dB"},
  { 37, "-6dB <= CPICH Ec/Io < -5.5dB"},
  { 38, "-5.5dB <= CPICH Ec/Io < -5dB"},
  { 39, "-5dB <= CPICH Ec/Io < -4.5dB"},
  { 40, "-4.5dB <= CPICH Ec/Io < -4dB"},
  { 41, "-4dB <= CPICH Ec/Io < -3.5dB"},
  { 42, "-3.5dB <= CPICH Ec/Io < -3dB"},
  { 43, "-3dB <= CPICH Ec/Io < -2.5dB"},
  { 44, "-2.5dB <= CPICH Ec/Io < -2dB"},
  { 45, "-2dB <= CPICH Ec/Io < -1.5dB"},
  { 46, "-1.5dB <= CPICH Ec/Io < -1dB"},
  { 47, "-1dB <= CPICH Ec/Io < -0.5dB"},
  { 48, "-0.5dB <= CPICH Ec/Io < 0dB"},
  { 49, "0dB <= CPICH Ec/Io"},
  {  0, NULL}
};
static value_string_ext lte_rrc_utra_EcN0_vals_ext = VALUE_STRING_EXT_INIT(lte_rrc_utra_EcN0_vals);

static const value_string lte_rrc_utra_RSCP_vals[] = {
  { -5, "RSCP < -120dBm"},
  { -4, "-120dBm <= RSCP < -119dBm"},
  { -3, "-119dBm <= RSCP < -118dBm"},
  { -2, "-118dBm <= RSCP < -117dBm"},
  { -1, "-117dBm <= RSCP < -116dBm"},
  {  0, "-116dBm <= RSCP < -115dBm"},
  {  1, "-115dBm <= RSCP < -114dBm"},
  {  2, "-114dBm <= RSCP < -113dBm"},
  {  3, "-113dBm <= RSCP < -112dBm"},
  {  4, "-112dBm <= RSCP < -111dBm"},
  {  5, "-111dBm <= RSCP < -110dBm"},
  {  6, "-110dBm <= RSCP < -109dBm"},
  {  7, "-109dBm <= RSCP < -108dBm"},
  {  8, "-108dBm <= RSCP < -107dBm"},
  {  9, "-107dBm <= RSCP < -106dBm"},
  { 10, "-106dBm <= RSCP < -105dBm"},
  { 11, "-105dBm <= RSCP < -104dBm"},
  { 12, "-104dBm <= RSCP < -103dBm"},
  { 13, "-103dBm <= RSCP < -102dBm"},
  { 14, "-102dBm <= RSCP < -101dBm"},
  { 15, "-101dBm <= RSCP < -100dBm"},
  { 16, "-100dBm <= RSCP < -99dBm"},
  { 17, "-99dBm <= RSCP < -98dBm"},
  { 18, "-98dBm <= RSCP < -97dBm"},
  { 19, "-97dBm <= RSCP < -96dBm"},
  { 20, "-96dBm <= RSCP < -95dBm"},
  { 21, "-95dBm <= RSCP < -94dBm"},
  { 22, "-94dBm <= RSCP < -93dBm"},
  { 23, "-93dBm <= RSCP < -92dBm"},
  { 24, "-92dBm <= RSCP < -91dBm"},
  { 25, "-91dBm <= RSCP < -90dBm"},
  { 26, "-90dBm <= RSCP < -89dBm"},
  { 27, "-89dBm <= RSCP < -88dBm"},
  { 28, "-88dBm <= RSCP < -87dBm"},
  { 29, "-87dBm <= RSCP < -86dBm"},
  { 30, "-86dBm <= RSCP < -85dBm"},
  { 31, "-85dBm <= RSCP < -84dBm"},
  { 32, "-84dBm <= RSCP < -83dBm"},
  { 33, "-83dBm <= RSCP < -82dBm"},
  { 34, "-82dBm <= RSCP < -81dBm"},
  { 35, "-81dBm <= RSCP < -80dBm"},
  { 36, "-80dBm <= RSCP < -79dBm"},
  { 37, "-79dBm <= RSCP < -78dBm"},
  { 38, "-78dBm <= RSCP < -77dBm"},
  { 39, "-77dBm <= RSCP < -76dBm"},
  { 40, "-76dBm <= RSCP < -75dBm"},
  { 41, "-75dBm <= RSCP < -74dBm"},
  { 42, "-74dBm <= RSCP < -73dBm"},
  { 43, "-73dBm <= RSCP < -72dBm"},
  { 44, "-72dBm <= RSCP < -71dBm"},
  { 45, "-71dBm <= RSCP < -70dBm"},
  { 46, "-70dBm <= RSCP < -69dBm"},
  { 47, "-69dBm <= RSCP < -68dBm"},
  { 48, "-68dBm <= RSCP < -67dBm"},
  { 49, "-67dBm <= RSCP < -66dBm"},
  { 50, "-66dBm <= RSCP < -65dBm"},
  { 51, "-65dBm <= RSCP < -64dBm"},
  { 52, "-64dBm <= RSCP < -63dBm"},
  { 53, "-63dBm <= RSCP < -62dBm"},
  { 54, "-62dBm <= RSCP < -61dBm"},
  { 55, "-61dBm <= RSCP < -60dBm"},
  { 56, "-60dBm <= RSCP < -59dBm"},
  { 57, "-59dBm <= RSCP < -58dBm"},
  { 58, "-58dBm <= RSCP < -57dBm"},
  { 59, "-57dBm <= RSCP < -56dBm"},
  { 60, "-56dBm <= RSCP < -55dBm"},
  { 61, "-55dBm <= RSCP < -54dBm"},
  { 62, "-54dBm <= RSCP < -53dBm"},
  { 63, "-53dBm <= RSCP < -52dBm"},
  { 64, "-52dBm <= RSCP < -51dBm"},
  { 65, "-51dBm <= RSCP < -50dBm"},
  { 66, "-50dBm <= RSCP < -49dBm"},
  { 67, "-49dBm <= RSCP < -48dBm"},
  { 68, "-48dBm <= RSCP < -47dBm"},
  { 69, "-47dBm <= RSCP < -46dBm"},
  { 70, "-46dBm <= RSCP < -45dBm"},
  { 71, "-45dBm <= RSCP < -44dBm"},
  { 72, "-44dBm <= RSCP < -43dBm"},
  { 73, "-43dBm <= RSCP < -42dBm"},
  { 74, "-42dBm <= RSCP < -41dBm"},
  { 75, "-41dBm <= RSCP < -40dBm"},
  { 76, "-40dBm <= RSCP < -39dBm"},
  { 77, "-39dBm <= RSCP < -38dBm"},
  { 78, "-38dBm <= RSCP < -37dBm"},
  { 79, "-37dBm <= RSCP < -36dBm"},
  { 80, "-36dBm <= RSCP < -35dBm"},
  { 81, "-35dBm <= RSCP < -34dBm"},
  { 82, "-34dBm <= RSCP < -33dBm"},
  { 83, "-33dBm <= RSCP < -32dBm"},
  { 84, "-32dBm <= RSCP < -31dBm"},
  { 85, "-31dBm <= RSCP < -30dBm"},
  { 86, "-30dBm <= RSCP < -29dBm"},
  { 87, "-29dBm <= RSCP < -28dBm"},
  { 88, "-28dBm <= RSCP < -27dBm"},
  { 89, "-27dBm <= RSCP < -26dBm"},
  { 90, "-26dBm <= RSCP < -25dBm"},
  { 91, "-25dBm <= RSCP"},
  {  0, NULL}
};
static value_string_ext lte_rrc_utra_RSCP_vals_ext = VALUE_STRING_EXT_INIT(lte_rrc_utra_RSCP_vals);

static const value_string lte_rrc_a3_a6_c2_Offset_vals[] = {
  { -30, "-15dB"},
  { -29, "-14.5dB"},
  { -28, "-14dB"},
  { -27, "-13.5dB"},
  { -26, "-13dB"},
  { -25, "-12.5dB"},
  { -24, "-12dB"},
  { -23, "-11.5dB"},
  { -22, "-11dB"},
  { -21, "-10.5dB"},
  { -20, "-10dB"},
  { -19, "-9.5dB"},
  { -18, "-9dB"},
  { -17, "-8.5dB"},
  { -16, "-8dB"},
  { -15, "-7.5dB"},
  { -14, "-7dB"},
  { -13, "-6.5dB"},
  { -12, "-6dB"},
  { -11, "-5.5dB"},
  { -10, "-5dB"},
  {  -9, "-4.5dB"},
  {  -8, "-4dB"},
  {  -7, "-3.5dB"},
  {  -6, "-3dB"},
  {  -5, "-2.5dB"},
  {  -4, "-2dB"},
  {  -3, "-1.5dB"},
  {  -2, "-1dB"},
  {  -1, "-0.5dB"},
  {   0, "0dB"},
  {   1, "0.5dB"},
  {   2, "1dB"},
  {   3, "1.5dB"},
  {   4, "2dB"},
  {   5, "2.5dB"},
  {   6, "3dB"},
  {   7, "3.5dB"},
  {   8, "4dB"},
  {   9, "4.5dB"},
  {  10, "5dB"},
  {  11, "5.5dB"},
  {  12, "6dB"},
  {  13, "6.5dB"},
  {  14, "7dB"},
  {  15, "7.5dB"},
  {  16, "8dB"},
  {  17, "8.5dB"},
  {  18, "9dB"},
  {  19, "9.5dB"},
  {  20, "10dB"},
  {  21, "10.5dB"},
  {  22, "11dB"},
  {  23, "11.5dB"},
  {  24, "12dB"},
  {  25, "12.5dB"},
  {  26, "13dB"},
  {  27, "13.5dB"},
  {  28, "14dB"},
  {  29, "14.5dB"},
  {  30, "15dB"},
  {  0, NULL}
};
static value_string_ext lte_rrc_a3_a6_c2_Offset_vals_ext = VALUE_STRING_EXT_INIT(lte_rrc_a3_a6_c2_Offset_vals);

static const value_string lte_rrc_threshold_RSRP_vals[] = {
  {  0, "-140dBm"},
  {  1, "-139dBm"},
  {  2, "-138dBm"},
  {  3, "-137dBm"},
  {  4, "-136dBm"},
  {  5, "-135dBm"},
  {  6, "-134dBm"},
  {  7, "-133dBm"},
  {  8, "-132dBm"},
  {  9, "-131dBm"},
  { 10, "-130dBm"},
  { 11, "-129dBm"},
  { 12, "-128dBm"},
  { 13, "-127dBm"},
  { 14, "-126dBm"},
  { 15, "-125dBm"},
  { 16, "-124dBm"},
  { 17, "-123dBm"},
  { 18, "-122dBm"},
  { 19, "-121dBm"},
  { 20, "-120dBm"},
  { 21, "-119dBm"},
  { 22, "-118dBm"},
  { 23, "-117dBm"},
  { 24, "-116dBm"},
  { 25, "-115dBm"},
  { 26, "-114dBm"},
  { 27, "-113dBm"},
  { 28, "-112dBm"},
  { 29, "-111dBm"},
  { 30, "-110dBm"},
  { 31, "-109dBm"},
  { 32, "-108dBm"},
  { 33, "-107dBm"},
  { 34, "-106dBm"},
  { 35, "-105dBm"},
  { 36, "-104dBm"},
  { 37, "-103dBm"},
  { 38, "-102dBm"},
  { 39, "-101dBm"},
  { 40, "-100dBm"},
  { 41, "-99dBm"},
  { 42, "-98dBm"},
  { 43, "-97dBm"},
  { 44, "-96dBm"},
  { 45, "-95dBm"},
  { 46, "-94dBm"},
  { 47, "-93dBm"},
  { 48, "-92dBm"},
  { 49, "-91dBm"},
  { 50, "-90dBm"},
  { 51, "-89dBm"},
  { 52, "-88dBm"},
  { 53, "-87dBm"},
  { 54, "-86dBm"},
  { 55, "-85dBm"},
  { 56, "-84dBm"},
  { 57, "-83dBm"},
  { 58, "-82dBm"},
  { 59, "-81dBm"},
  { 60, "-80dBm"},
  { 61, "-79dBm"},
  { 62, "-78dBm"},
  { 63, "-77dBm"},
  { 64, "-76dBm"},
  { 65, "-75dBm"},
  { 66, "-74dBm"},
  { 67, "-73dBm"},
  { 68, "-72dBm"},
  { 69, "-71dBm"},
  { 70, "-70dBm"},
  { 71, "-69dBm"},
  { 72, "-68dBm"},
  { 73, "-67dBm"},
  { 74, "-66dBm"},
  { 75, "-65dBm"},
  { 76, "-64dBm"},
  { 77, "-63dBm"},
  { 78, "-62dBm"},
  { 79, "-61dBm"},
  { 80, "-60dBm"},
  { 81, "-59dBm"},
  { 82, "-58dBm"},
  { 83, "-57dBm"},
  { 84, "-56dBm"},
  { 85, "-55dBm"},
  { 86, "-54dBm"},
  { 87, "-53dBm"},
  { 88, "-52dBm"},
  { 89, "-51dBm"},
  { 90, "-50dBm"},
  { 91, "-49dBm"},
  { 92, "-48dBm"},
  { 93, "-47dBm"},
  { 94, "-46dBm"},
  { 95, "-45dBm"},
  { 96, "-44dBm"},
  { 97, "-43dBm"},
  {  0, NULL}
};
static value_string_ext lte_rrc_threshold_RSRP_vals_ext = VALUE_STRING_EXT_INIT(lte_rrc_threshold_RSRP_vals);

static const value_string lte_rrc_threshold_RSRQ_vals[] = {
  {  0, "-20dB"},
  {  1, "-19.5dB"},
  {  2, "-19dB"},
  {  3, "-18.5dB"},
  {  4, "-18dB"},
  {  5, "-17.5dB"},
  {  6, "-17dB"},
  {  7, "-16.5dB"},
  {  8, "-16dB"},
  {  9, "-15.5dB"},
  { 10, "-15dB"},
  { 11, "-14.5dB"},
  { 12, "-14dB"},
  { 13, "-13.5dB"},
  { 14, "-13dB"},
  { 15, "-12.5dB"},
  { 16, "-12dB"},
  { 17, "-11.5dB"},
  { 18, "-11dB"},
  { 19, "-10.5dB"},
  { 20, "-10dB"},
  { 21, "-9.5dB"},
  { 22, "-9dB"},
  { 23, "-8.5dB"},
  { 24, "-8dB"},
  { 25, "-7.5dB"},
  { 26, "-7dB"},
  { 27, "-6.5dB"},
  { 28, "-6dB"},
  { 29, "-5.5dB"},
  { 30, "-5dB"},
  { 31, "-4.5dB"},
  { 32, "-4dB"},
  { 33, "-3.5dB"},
  { 34, "-3dB"},
  {  0, NULL}
};
static value_string_ext lte_rrc_threshold_RSRQ_vals_ext = VALUE_STRING_EXT_INIT(lte_rrc_threshold_RSRQ_vals);

static const value_string lte_rrc_thresholdGERAN_vals[] = {
  { 0 , "-110dBm"},
  { 1 , "-109dBm"},
  { 2 , "-108dBm"},
  { 3 , "-107dBm"},
  { 4 , "-106dBm"},
  { 5 , "-105dBm"},
  { 6 , "-104dBm"},
  { 7 , "-103dBm"},
  { 8 , "-102dBm"},
  { 9 , "-101dBm"},
  { 10, "-100dBm"},
  { 11, "-99dBm"},
  { 12, "-98dBm"},
  { 13, "-97dBm"},
  { 14, "-96dBm"},
  { 15, "-95dBm"},
  { 16, "-94dBm"},
  { 17, "-93dBm"},
  { 18, "-92dBm"},
  { 19, "-91dBm"},
  { 20, "-90dBm"},
  { 21, "-89dBm"},
  { 22, "-88dBm"},
  { 23, "-87dBm"},
  { 24, "-86dBm"},
  { 25, "-85dBm"},
  { 26, "-84dBm"},
  { 27, "-83dBm"},
  { 28, "-82dBm"},
  { 29, "-81dBm"},
  { 30, "-80dBm"},
  { 31, "-79dBm"},
  { 32, "-78dBm"},
  { 33, "-77dBm"},
  { 34, "-76dBm"},
  { 35, "-75dBm"},
  { 36, "-74dBm"},
  { 37, "-73dBm"},
  { 38, "-72dBm"},
  { 39, "-71dBm"},
  { 40, "-70dBm"},
  { 41, "-69dBm"},
  { 42, "-68dBm"},
  { 43, "-67dBm"},
  { 44, "-66dBm"},
  { 45, "-65dBm"},
  { 46, "-64dBm"},
  { 47, "-63dBm"},
  { 48, "-62dBm"},
  { 49, "-61dBm"},
  { 50, "-60dBm"},
  { 51, "-59dBm"},
  { 52, "-58dBm"},
  { 53, "-57dBm"},
  { 54, "-56dBm"},
  { 55, "-55dBm"},
  { 56, "-54dBm"},
  { 57, "-53dBm"},
  { 58, "-52dBm"},
  { 59, "-51dBm"},
  { 60, "-50dBm"},
  { 61, "-49dBm"},
  { 62, "-48dBm"},
  { 63, "-47dBm"},
  {  0, NULL}
};
static value_string_ext lte_rrc_thresholdGERAN_vals_ext = VALUE_STRING_EXT_INIT(lte_rrc_thresholdGERAN_vals);

static const value_string lte_rrc_thresholdUTRA_EcN0_vals[] = {
  { 0 , "-24.5dB"},
  { 1 , "-24dB"},
  { 2 , "-23.5dB"},
  { 3 , "-23dB"},
  { 4 , "-22.5dB"},
  { 5 , "-22dB"},
  { 6 , "-21.5dB"},
  { 7 , "-21dB"},
  { 8 , "-20.5dB"},
  { 9 , "-20dB"},
  { 10, "-19.5dB"},
  { 11, "-19dB"},
  { 12, "-18.5dB"},
  { 13, "-18dB"},
  { 14, "-17.5dB"},
  { 15, "-17dB"},
  { 16, "-16.5dB"},
  { 17, "-16dB"},
  { 18, "-15.5dB"},
  { 19, "-15dB"},
  { 20, "-14.5dB"},
  { 21, "-14dB"},
  { 22, "-13.5dB"},
  { 23, "-13dB"},
  { 24, "-12.5dB"},
  { 25, "-12dB"},
  { 26, "-11.5dB"},
  { 27, "-11dB"},
  { 28, "-10.5dB"},
  { 29, "-10dB"},
  { 30, "-9.5dB"},
  { 31, "-9dB"},
  { 32, "-8.5dB"},
  { 33, "-8dB"},
  { 34, "-7.5dB"},
  { 35, "-7dB"},
  { 36, "-6.5dB"},
  { 37, "-6dB"},
  { 38, "-5.5dB"},
  { 39, "-5dB"},
  { 40, "-4.5dB"},
  { 41, "-4dB"},
  { 42, "-3.5dB"},
  { 43, "-3dB"},
  { 44, "-2.5dB"},
  { 45, "-2dB"},
  { 46, "-1.5dB"},
  { 47, "-1dB"},
  { 48, "-0.5dB"},
  { 49, "0dB"},
  {  0, NULL}
};
static value_string_ext lte_rrc_thresholdUTRA_EcN0_vals_ext = VALUE_STRING_EXT_INIT(lte_rrc_thresholdUTRA_EcN0_vals);

static const value_string lte_rrc_thresholdUTRA_RSCP_vals[] = {
  { -5, "-120dBm"},
  { -4, "-119dBm"},
  { -3, "-118dBm"},
  { -2, "-117dBm"},
  { -1, "-116dBm"},
  {  0, "-115dBm"},
  {  1, "-114dBm"},
  {  2, "-113dBm"},
  {  3, "-112dBm"},
  {  4, "-111dBm"},
  {  5, "-110dBm"},
  {  6, "-109dBm"},
  {  7, "-108dBm"},
  {  8, "-107dBm"},
  {  9, "-106dBm"},
  { 10, "-105dBm"},
  { 11, "-104dBm"},
  { 12, "-103dBm"},
  { 13, "-102dBm"},
  { 14, "-101dBm"},
  { 15, "-100dBm"},
  { 16, "-99dBm"},
  { 17, "-98dBm"},
  { 18, "-97dBm"},
  { 19, "-96dBm"},
  { 20, "-95dBm"},
  { 21, "-94dBm"},
  { 22, "-93dBm"},
  { 23, "-92dBm"},
  { 24, "-91dBm"},
  { 25, "-90dBm"},
  { 26, "-89dBm"},
  { 27, "-88dBm"},
  { 28, "-87dBm"},
  { 29, "-86dBm"},
  { 30, "-85dBm"},
  { 31, "-84dBm"},
  { 32, "-83dBm"},
  { 33, "-82dBm"},
  { 34, "-81dBm"},
  { 35, "-80dBm"},
  { 36, "-79dBm"},
  { 37, "-78dBm"},
  { 38, "-77dBm"},
  { 39, "-76dBm"},
  { 40, "-75dBm"},
  { 41, "-74dBm"},
  { 42, "-73dBm"},
  { 43, "-72dBm"},
  { 44, "-71dBm"},
  { 45, "-70dBm"},
  { 46, "-69dBm"},
  { 47, "-68dBm"},
  { 48, "-67dBm"},
  { 49, "-66dBm"},
  { 50, "-65dBm"},
  { 51, "-64dBm"},
  { 52, "-63dBm"},
  { 53, "-62dBm"},
  { 54, "-61dBm"},
  { 55, "-60dBm"},
  { 56, "-59dBm"},
  { 57, "-58dBm"},
  { 58, "-57dBm"},
  { 59, "-56dBm"},
  { 60, "-55dBm"},
  { 61, "-54dBm"},
  { 62, "-53dBm"},
  { 63, "-52dBm"},
  { 64, "-51dBm"},
  { 65, "-50dBm"},
  { 66, "-49dBm"},
  { 67, "-48dBm"},
  { 68, "-47dBm"},
  { 69, "-46dBm"},
  { 70, "-45dBm"},
  { 71, "-44dBm"},
  { 72, "-43dBm"},
  { 73, "-42dBm"},
  { 74, "-41dBm"},
  { 75, "-40dBm"},
  { 76, "-39dBm"},
  { 77, "-38dBm"},
  { 78, "-37dBm"},
  { 79, "-36dBm"},
  { 80, "-35dBm"},
  { 81, "-34dBm"},
  { 82, "-33dBm"},
  { 83, "-32dBm"},
  { 84, "-31dBm"},
  { 85, "-30dBm"},
  { 86, "-29dBm"},
  { 87, "-28dBm"},
  { 88, "-27dBm"},
  { 89, "-26dBm"},
  { 90, "-25dBm"},
  { 91, "-24dBm"},
  {  0, NULL}
};
static value_string_ext lte_rrc_thresholdUTRA_RSCP_vals_ext = VALUE_STRING_EXT_INIT(lte_rrc_thresholdUTRA_RSCP_vals);

static const value_string lte_rrc_RSRP_Range_vals[] = {
  {  0, "RSRP < -140dBm"},
  {  1, "-140dBm <= RSRP < -139dBm"},
  {  2, "-139dBm <= RSRP < -138dBm"},
  {  3, "-138dBm <= RSRP < -137dBm"},
  {  4, "-137dBm <= RSRP < -136dBm"},
  {  5, "-136dBm <= RSRP < -135dBm"},
  {  6, "-135dBm <= RSRP < -134dBm"},
  {  7, "-134dBm <= RSRP < -133dBm"},
  {  8, "-133dBm <= RSRP < -132dBm"},
  {  9, "-132dBm <= RSRP < -131dBm"},
  { 10, "-131dBm <= RSRP < -130dBm"},
  { 11, "-130dBm <= RSRP < -129dBm"},
  { 12, "-129dBm <= RSRP < -128dBm"},
  { 13, "-128dBm <= RSRP < -127dBm"},
  { 14, "-127dBm <= RSRP < -126dBm"},
  { 15, "-126dBm <= RSRP < -125dBm"},
  { 16, "-125dBm <= RSRP < -124dBm"},
  { 17, "-124dBm <= RSRP < -123dBm"},
  { 18, "-123dBm <= RSRP < -122dBm"},
  { 19, "-122dBm <= RSRP < -121dBm"},
  { 20, "-121dBm <= RSRP < -120dBm"},
  { 21, "-120dBm <= RSRP < -119dBm"},
  { 22, "-119dBm <= RSRP < -118dBm"},
  { 23, "-118dBm <= RSRP < -117dBm"},
  { 24, "-117dBm <= RSRP < -116dBm"},
  { 25, "-116dBm <= RSRP < -115dBm"},
  { 26, "-115dBm <= RSRP < -114dBm"},
  { 27, "-114dBm <= RSRP < -113dBm"},
  { 28, "-113dBm <= RSRP < -112dBm"},
  { 29, "-112dBm <= RSRP < -111dBm"},
  { 30, "-111dBm <= RSRP < -110dBm"},
  { 31, "-110dBm <= RSRP < -109dBm"},
  { 32, "-109dBm <= RSRP < -108dBm"},
  { 33, "-108dBm <= RSRP < -107dBm"},
  { 34, "-107dBm <= RSRP < -106dBm"},
  { 35, "-106dBm <= RSRP < -105dBm"},
  { 36, "-105dBm <= RSRP < -104dBm"},
  { 37, "-104dBm <= RSRP < -103dBm"},
  { 38, "-103dBm <= RSRP < -102dBm"},
  { 39, "-102dBm <= RSRP < -101dBm"},
  { 40, "-101dBm <= RSRP < -100dBm"},
  { 41, "-100dBm <= RSRP < -99dBm"},
  { 42, "-99dBm <= RSRP < -98dBm"},
  { 43, "-98dBm <= RSRP < -97dBm"},
  { 44, "-97dBm <= RSRP < -96dBm"},
  { 45, "-96dBm <= RSRP < -95dBm"},
  { 46, "-95dBm <= RSRP < -94dBm"},
  { 47, "-94dBm <= RSRP < -93dBm"},
  { 48, "-93dBm <= RSRP < -92dBm"},
  { 49, "-92dBm <= RSRP < -91dBm"},
  { 50, "-91dBm <= RSRP < -90dBm"},
  { 51, "-90dBm <= RSRP < -89dBm"},
  { 52, "-89dBm <= RSRP < -88dBm"},
  { 53, "-88dBm <= RSRP < -87dBm"},
  { 54, "-87dBm <= RSRP < -86dBm"},
  { 55, "-86dBm <= RSRP < -85dBm"},
  { 56, "-85dBm <= RSRP < -84dBm"},
  { 57, "-84dBm <= RSRP < -83dBm"},
  { 58, "-83dBm <= RSRP < -82dBm"},
  { 59, "-82dBm <= RSRP < -81dBm"},
  { 60, "-81dBm <= RSRP < -80dBm"},
  { 61, "-80dBm <= RSRP < -79dBm"},
  { 62, "-79dBm <= RSRP < -78dBm"},
  { 63, "-78dBm <= RSRP < -77dBm"},
  { 64, "-77dBm <= RSRP < -76dBm"},
  { 65, "-76dBm <= RSRP < -75dBm"},
  { 66, "-75dBm <= RSRP < -74dBm"},
  { 67, "-74dBm <= RSRP < -73dBm"},
  { 68, "-73dBm <= RSRP < -72dBm"},
  { 69, "-72dBm <= RSRP < -71dBm"},
  { 70, "-71dBm <= RSRP < -70dBm"},
  { 71, "-70dBm <= RSRP < -69dBm"},
  { 72, "-69dBm <= RSRP < -68dBm"},
  { 73, "-68dBm <= RSRP < -67dBm"},
  { 74, "-67dBm <= RSRP < -66dBm"},
  { 75, "-66dBm <= RSRP < -65dBm"},
  { 76, "-65dBm <= RSRP < -64dBm"},
  { 77, "-64dBm <= RSRP < -63dBm"},
  { 78, "-63dBm <= RSRP < -62dBm"},
  { 79, "-62dBm <= RSRP < -61dBm"},
  { 80, "-61dBm <= RSRP < -60dBm"},
  { 81, "-60dBm <= RSRP < -59dBm"},
  { 82, "-59dBm <= RSRP < -58dBm"},
  { 83, "-58dBm <= RSRP < -57dBm"},
  { 84, "-57dBm <= RSRP < -56dBm"},
  { 85, "-56dBm <= RSRP < -55dBm"},
  { 86, "-55dBm <= RSRP < -54dBm"},
  { 87, "-54dBm <= RSRP < -53dBm"},
  { 88, "-53dBm <= RSRP < -52dBm"},
  { 89, "-52dBm <= RSRP < -51dBm"},
  { 90, "-51dBm <= RSRP < -50dBm"},
  { 91, "-50dBm <= RSRP < -49dBm"},
  { 92, "-49dBm <= RSRP < -48dBm"},
  { 93, "-48dBm <= RSRP < -47dBm"},
  { 94, "-47dBm <= RSRP < -46dBm"},
  { 95, "-46dBm <= RSRP < -45dBm"},
  { 96, "-45dBm <= RSRP < -44dBm"},
  { 97, "-44dBm <= RSRP"},
  {  0, NULL}
};
static value_string_ext lte_rrc_RSRP_Range_vals_ext = VALUE_STRING_EXT_INIT(lte_rrc_RSRP_Range_vals);

static const value_string lte_rrc_RSRP_Range_v1360_vals[] = {
  { -17, "RSRP < -156dBm"},
  { -16, "-156dBm <= RSRP < -155dBm"},
  { -15, "-155dBm <= RSRP < -154dBm"},
  { -14, "-154dBm <= RSRP < -153dBm"},
  { -13, "-153dBm <= RSRP < -152dBm"},
  { -12, "-152dBm <= RSRP < -151dBm"},
  { -11, "-151dBm <= RSRP < -150dBm"},
  { -10, "-150dBm <= RSRP < -149dBm"},
  {  -9, "-149dBm <= RSRP < -148dBm"},
  {  -8, "-148dBm <= RSRP < -147dBm"},
  {  -7, "-147dBm <= RSRP < -146dBm"},
  {  -6, "-146dBm <= RSRP < -145dBm"},
  {  -5, "-145dBm <= RSRP < -144dBm"},
  {  -4, "-144dBm <= RSRP < -143dBm"},
  {  -3, "-143dBm <= RSRP < -142dBm"},
  {  -2, "-142dBm <= RSRP < -141dBm"},
  {  -1, "-141dBm <= RSRP < -140dBm"},
  {  0, NULL}
};
static value_string_ext lte_rrc_RSRP_Range_v1360_vals_ext = VALUE_STRING_EXT_INIT(lte_rrc_RSRP_Range_v1360_vals);

static const value_string lte_rrc_RSRP_RangeSL_vals[] = {
  {  0, "-infinity"},
  {  1, "-115dBm"},
  {  2, "-110dBm"},
  {  3, "-105dBm"},
  {  4, "-100dBm"},
  {  5, "-95dBm"},
  {  6, "-90dBm"},
  {  7, "-85dBm"},
  {  8, "-80dBm"},
  {  9, "-75dBm"},
  { 10, "-70dBm"},
  { 11, "-65dBm"},
  { 12, "-60dBm"},
  { 13, "+infinity"},
  {  0, NULL}
};

static const value_string lte_rrc_RSRP_RangeSL2_vals[] = {
  {  0, "-infinity"},
  {  1, "-110dBm"},
  {  2, "-100dBm"},
  {  3, "-90dBm"},
  {  4, "-80dBm"},
  {  5, "-70dBm"},
  {  6, "-60dBm"},
  {  7, "+infinity"},
  {  0, NULL}
};

#if 0
static const value_string lte_rrc_RSRP_RangeSL3_vals[] = {
  {  0, "-110dBm"},
  {  1, "-105dBm"},
  {  2, "-100dBm"},
  {  3, "-95dBm"},
  {  4, "-90dBm"},
  {  5, "-85dBm"},
  {  6, "-80dBm"},
  {  7, "-75dBm"},
  {  8, "-70dBm"},
  {  9, "-65dBm"},
  { 10, "-60dBm"},
  { 11, "+infinity"},
  {  0, NULL}
};
#endif

static const value_string lte_rrc_RSRP_RangeSL4_vals[] = {
  {  0, "-130dBm"},
  {  1, "-128dBm"},
  {  2, "-126dBm"},
  {  3, "-124dBm"},
  {  4, "-122dBm"},
  {  5, "-120dBm"},
  {  6, "-118dBm"},
  {  7, "-116dBm"},
  {  8, "-114dBm"},
  {  9, "-112dBm"},
  { 10, "-110dBm"},
  { 11, "-108dBm"},
  { 12, "-106dBm"},
  { 13, "-104dBm"},
  { 14, "-102dBm"},
  { 15, "-100dBm"},
  { 16, "-98dBm"},
  { 17, "-96dBm"},
  { 18, "-94dBm"},
  { 19, "-92dBm"},
  { 20, "-90dBm"},
  { 21, "-88dBm"},
  { 22, "-86dBm"},
  { 23, "-84dBm"},
  { 24, "-82dBm"},
  { 25, "-80dBm"},
  { 26, "-78dBm"},
  { 27, "-76dBm"},
  { 28, "-74dBm"},
  { 29, "-72dBm"},
  { 30, "-70dBm"},
  { 31, "-68dBm"},
  { 32, "-66dBm"},
  { 33, "-64dBm"},
  { 34, "-62dBm"},
  { 35, "-60dBm"},
  { 36, "-58dBm"},
  { 37, "-56dBm"},
  { 38, "-54dBm"},
  { 39, "-52dBm"},
  { 40, "-50dBm"},
  { 41, "-48dBm"},
  { 42, "-46dBm"},
  { 43, "-44dBm"},
  { 44, "-42dBm"},
  { 45, "-40dBm"},
  { 46, "-38dBm"},
  { 47, "-36dBm"},
  { 48, "-34dBm"},
  { 49, "+infinity"},
  {  0, NULL}
};
static value_string_ext lte_rrc_RSRP_RangeSL4_vals_ext = VALUE_STRING_EXT_INIT(lte_rrc_RSRP_RangeSL4_vals);

static void
lte_rrc_RSRP_RangeNR_r15_fmt(gchar *s, guint32 v)
{
  if (v == 0) {
    g_snprintf(s, ITEM_LABEL_LENGTH, "SS-RSRP < -156dBm (0)");
  } else if (v == 126) {
    g_snprintf(s, ITEM_LABEL_LENGTH, "-31dBm <= SS-RSRP (126)");
  } else if (v == 127) {
    g_snprintf(s, ITEM_LABEL_LENGTH, "Infinity (127)");
  } else {
    g_snprintf(s, ITEM_LABEL_LENGTH, "%ddBm <= SS-RSRP < %ddBm (%u)", -157+v, -156+v, v);
  }
}

static const value_string lte_rrc_RSRQ_Range_vals[] = {
  {-34, "RSRQ < -36dB"},
  {-33, "-36dB <= RSRQ < -35.5dB"},
  {-32, "-35.5dB <= RSRQ < -35dB"},
  {-31, "-35dB <= RSRQ < -34.5dB"},
  {-30, "-34.5dB <= RSRQ < -34dB"},
  {-29, "-34dB <= RSRQ < -33.5dB"},
  {-28, "-33.5dB <= RSRQ < -33dB"},
  {-27, "-33dB <= RSRQ < -32.5dB"},
  {-26, "-32.5dB <= RSRQ < -32dB"},
  {-25, "-32dB <= RSRQ < -31.5dB"},
  {-24, "-31.5dB <= RSRQ < -31dB"},
  {-23, "-31dB <= RSRQ < -30.5dB"},
  {-22, "-30.5dB <= RSRQ < -30dB"},
  {-21, "-30dB <= RSRQ < -29.5dB"},
  {-20, "-29.5dB <= RSRQ < -29dB"},
  {-19, "-29dB <= RSRQ < -28.5dB"},
  {-18, "-28.5dB <= RSRQ < -28dB"},
  {-17, "-28dB <= RSRQ < -27.5dB"},
  {-16, "-27.5dB <= RSRQ < -27dB"},
  {-15, "-27dB <= RSRQ < -26.5dB"},
  {-14, "-26.5dB <= RSRQ < -26dB"},
  {-13, "-26dB <= RSRQ < -25.5dB"},
  {-12, "-25.5dB <= RSRQ < -25dB"},
  {-11, "-25dB <= RSRQ < -24.5dB"},
  {-10, "-24.5dB <= RSRQ < -24dB"},
  { -9, "-24dB <= RSRQ < -23.5dB"},
  { -8, "-23.5dB <= RSRQ < -23dB"},
  { -7, "-23dB <= RSRQ < -22.5dB"},
  { -6, "-22.5dB <= RSRQ < -22dB"},
  { -5, "-22dB <= RSRQ < -21.5dB"},
  { -4, "-21.5dB <= RSRQ < -21dB"},
  { -3, "-21dB <= RSRQ < -20.5dB"},
  { -2, "-20.5dB <= RSRQ < -20dB"},
  { -1, "-20dB <= RSRQ < -19.5dB"},
  {  0, "RSRQ < -19.5dB"},
  {  1, "-19.5dB <= RSRQ < -19dB"},
  {  2, "-19dB <= RSRQ < -18.5dB"},
  {  3, "-18.5dB <= RSRQ < -18dB"},
  {  4, "-18dB <= RSRQ < -17.5dB"},
  {  5, "-17.5dB <= RSRQ < -17dB"},
  {  6, "-17dB <= RSRQ < -16.5dB"},
  {  7, "-16.5dB <= RSRQ < -16dB"},
  {  8, "-16dB <= RSRQ < -15.5dB"},
  {  9, "-15.5dB <= RSRQ < -15dB"},
  { 10, "-15dB <= RSRQ < -14.5dB"},
  { 11, "-14.5dB <= RSRQ < -14dB"},
  { 12, "-14dB <= RSRQ < -13.5dB"},
  { 13, "-13.5dB <= RSRQ < -13dB"},
  { 14, "-13dB <= RSRQ < -12.5dB"},
  { 15, "-12.5dB <= RSRQ < -12dB"},
  { 16, "-12dB <= RSRQ < -11.5dB"},
  { 17, "-11.5dB <= RSRQ < -11dB"},
  { 18, "-11dB <= RSRQ < -10.5dB"},
  { 19, "-10.5dB <= RSRQ < -10dB"},
  { 20, "-10dB <= RSRQ < -9.5dB"},
  { 21, "-9.5dB <= RSRQ < -9dB"},
  { 22, "-9dB <= RSRQ < -8.5dB"},
  { 23, "-8.5dB <= RSRQ < -8dB"},
  { 24, "-8dB <= RSRQ < -7.5dB"},
  { 25, "-7.5dB <= RSRQ < -7dB"},
  { 26, "-7dB <= RSRQ < -6.5dB"},
  { 27, "-6.5dB <= RSRQ < -6dB"},
  { 28, "-6dB <= RSRQ < -5.5dB"},
  { 29, "-5.5dB <= RSRQ < -5dB"},
  { 30, "-5dB <= RSRQ < -4.5dB"},
  { 31, "-4.5dB <= RSRQ < -4dB"},
  { 32, "-4dB <= RSRQ < -3.5dB"},
  { 33, "-3.5dB <= RSRQ < -3dB"},
  { 34, "-3dB <= RSRQ"},
  { 35, "-3dB <= RSRQ < -2.5dB"},
  { 36, "-2.5dB <= RSRQ < -2dB"},
  { 37, "-2dB <= RSRQ < -1.5dB"},
  { 38, "-1.5dB <= RSRQ < -1dB"},
  { 39, "-1dB <= RSRQ < -0.5dB"},
  { 40, "-0.5dB <= RSRQ < 0dB"},
  { 41, "0dB <= RSRQ < 0.5dB"},
  { 42, "0.5dB <= RSRQ < 1dB"},
  { 43, "1dB <= RSRQ < 1.5dB"},
  { 44, "1.5dB <= RSRQ < 2dB"},
  { 45, "2dB <= RSRQ < 2.5dB"},
  { 46, "2.5dB <= RSRQ"},
  {  0, NULL}
};
static value_string_ext lte_rrc_RSRQ_Range_vals_ext = VALUE_STRING_EXT_INIT(lte_rrc_RSRQ_Range_vals);

static void
lte_rrc_RSRQ_RangeNR_r15_fmt(gchar *s, guint32 v)
{
  if (v == 0) {
    g_snprintf(s, ITEM_LABEL_LENGTH, "SS-RSRQ < -43dB (0)");
  } else if (v == 127) {
    g_snprintf(s, ITEM_LABEL_LENGTH, "20dB < SS-RSRQ (127)");
  } else {
    g_snprintf(s, ITEM_LABEL_LENGTH, "%.1fdB <= SS-RSRQ < %.1fdB (%u)", (((float)v-1)/2)-43, ((float)v/2)-43, v);
  }
}

static const value_string lte_rrc_MBSFN_RSRQ_Range_vals[] = {
  {  0, "RSRQ < -23dB"},
  {  1, "-23dB <= RSRQ < -22.5dB"},
  {  2, "-22.5dB <= RSRQ < -22dB"},
  {  3, "-22dB <= RSRQ < -21.5dB"},
  {  4, "-21.5dB <= RSRQ < -21dB"},
  {  5, "-21dB <= RSRQ < -20.5dB"},
  {  6, "-20.5dB <= RSRQ < -20dB"},
  {  7, "-20dB <= RSRQ < -19.5dB"},
  {  8, "-19.5dB <= RSRQ < -19dB"},
  {  9, "-19dB <= RSRQ < -18.5dB"},
  { 10, "-18.5dB <= RSRQ < -18dB"},
  { 11, "-18dB <= RSRQ < -17.5dB"},
  { 12, "-17.5dB <= RSRQ < -17dB"},
  { 13, "-17dB <= RSRQ < -16.5dB"},
  { 14, "-16.5dB <= RSRQ < -16dB"},
  { 15, "-16dB <= RSRQ < -15.5dB"},
  { 16, "-15.5dB <= RSRQ < -15dB"},
  { 17, "-15dB <= RSRQ < -14.5dB"},
  { 18, "-14.5dB <= RSRQ < -14dB"},
  { 19, "-14dB <= RSRQ < -13.5dB"},
  { 20, "-13.5dB <= RSRQ < -13dB"},
  { 21, "-13dB <= RSRQ < -12.5dB"},
  { 22, "-12.5dB <= RSRQ < -12dB"},
  { 23, "-12dB <= RSRQ < -11.5dB"},
  { 24, "-11.5dB <= RSRQ < -11dB"},
  { 25, "-11dB <= RSRQ < -10.5dB"},
  { 26, "-10.5dB <= RSRQ < -10dB"},
  { 27, "-10dB <= RSRQ < -9.5dB"},
  { 28, "-9.5dB <= RSRQ < -9dB"},
  { 29, "-9dB <= RSRQ < -8.5dB"},
  { 30, "-8.5dB <= RSRQ < -8dB"},
  { 31, "-8dB <= RSRQ"},
  {  0, NULL}
};
static value_string_ext lte_rrc_MBSFN_RSRQ_Range_vals_ext = VALUE_STRING_EXT_INIT(lte_rrc_MBSFN_RSRQ_Range_vals);

static void
lte_rrc_availableAdmissionCapacityWLAN_fmt(gchar *s, guint32 v)
{
  g_snprintf(s, ITEM_LABEL_LENGTH, "%uus/s (%u)", 32*v, v);
}

static void
lte_rrc_ue_RxTxTimeDiffResult_fmt(gchar *s, guint32 v)
{
  if (v == 0) {
    g_snprintf(s, ITEM_LABEL_LENGTH, "T < 2Ts (0)");
  } else if (v < 2048) {
    g_snprintf(s, ITEM_LABEL_LENGTH, "%uTs <= T < %uTs (%u)", v*2, (v+1)*2, v);
  } else if (v < 4095) {
    g_snprintf(s, ITEM_LABEL_LENGTH, "%uTs <= T < %uTs (%u)", (v*8)-12288, ((v+1)*8)-12288, v);
  } else {
    g_snprintf(s, ITEM_LABEL_LENGTH, "20472Ts <= T (4095)");
  }
}

static const true_false_string lte_rrc_duration_val = {
  "indefinite",
  "single"
};

static const value_string lte_rrc_eab_category_vals[] = {
  { 0, "a - all UEs" },
  { 1, "b - UEs not in their HPLMN/EHPLMN" },
  { 2, "c - UEs not in the most preferred PLMN of the country where they are roaming in EF OPLMNwACT list, nor in their HPLMN/EHPLMN" },
  { 0, NULL }
};

static const value_string lte_rrc_daylightSavingTime_vals[] = {
  { 0, "No adjustment for Daylight Saving Time"},
  { 1, "+1 hour adjustment for Daylight Saving Time"},
  { 2, "+2 hours adjustment for Daylight Saving Time"},
  { 3, "Reserved"},
  { 0, NULL},
};

static const value_string lte_rrc_neighCellConfig_vals[] = {
  { 0, "Not all neighbour cells have the same MBSFN subframe allocation as serving cell"},
  { 1, "No MBSFN subframes are present in all neighbour cells"},
  { 2, "The MBSFN subframe allocations of all neighbour cells are identical to or subsets of that in the serving cell"},
  { 3, "Different UL/DL allocation in neighbouring cells for TDD compared to the serving cell"},
  { 0, NULL},
};

static const value_string lte_rrc_messageIdentifier_vals[] = {
  { 0x1100, "ETWS Identifier for earthquake warning message"},
  { 0x1101, "ETWS Identifier for tsunami warning message"},
  { 0x1102, "ETWS Identifier for earthquake and tsunami combined warning message"},
  { 0x1103, "ETWS Identifier for test message"},
  { 0x1104, "ETWS Identifier for messages related to other emergency types"},
  { 0x1105, "ETWS Identifier for future extension"},
  { 0x1106, "ETWS Identifier for future extension"},
  { 0x1107, "ETWS Identifier for future extension"},
  { 0x1112, "CMAS Identifier for CMAS Presidential Level Alerts"},
  { 0x1113, "CMAS Identifier for CMAS Extreme Alerts with Severity of Extreme, Urgency of Immediate, and Certainty of Observed"},
  { 0x1114, "CMAS Identifier for CMAS Extreme Alerts with Severity of Extreme, Urgency of Immediate, and Certainty of Likely"},
  { 0x1115, "CMAS Identifier for CMAS Severe Alerts with Severity of Extreme, Urgency of Expected, and Certainty of Observed"},
  { 0x1116, "CMAS Identifier for CMAS Severe Alerts with Severity of Extreme, Urgency of Expected, and Certainty of Likely"},
  { 0x1117, "CMAS Identifier for CMAS Severe Alerts with Severity of Severe, Urgency of Immediate, and Certainty of Observed"},
  { 0x1118, "CMAS Identifier for CMAS Severe Alerts with Severity of Severe, Urgency of Immediate, and Certainty of Likely"},
  { 0x1119, "CMAS Identifier for CMAS Severe Alerts with Severity of Severe, Urgency of Expected, and Certainty of Observed"},
  { 0x111a, "CMAS Identifier for CMAS Severe Alerts with Severity of Severe, Urgency of Expected, and Certainty of Likely"},
  { 0x111b, "CMAS Identifier for Child Abduction Emergency (or Amber Alert)"},
  { 0x111c, "CMAS Identifier for the Required Monthly Test"},
  { 0x111d, "CMAS Identifier for CMAS Exercise"},
  { 0x111e, "CMAS Identifier for operator defined use"},
  { 0x111f, "CMAS Identifier for CMAS Presidential Level Alerts for additional languages"},
  { 0x1120, "CMAS Identifier for CMAS Extreme Alerts with Severity of Extreme, Urgency of Immediate, and Certainty of Observed for additional languages"},
  { 0x1121, "CMAS Identifier for CMAS Extreme Alerts with Severity of Extreme, Urgency of Immediate, and Certainty of Likely for additional languages"},
  { 0x1122, "CMAS Identifier for CMAS Severe Alerts with Severity of Extreme, Urgency of Expected, and Certainty of Observed for additional languages"},
  { 0x1123, "CMAS Identifier for CMAS Severe Alerts with Severity of Extreme, Urgency of Expected, and Certainty of Likely for additional languages"},
  { 0x1124, "CMAS Identifier for CMAS Severe Alerts with Severity of Severe, Urgency of Immediate, and Certainty of Observed for additional languages"},
  { 0x1125, "CMAS Identifier for CMAS Severe Alerts with Severity of Severe, Urgency of Immediate, and Certainty of Likely for additional languages"},
  { 0x1126, "CMAS Identifier for CMAS Severe Alerts with Severity of Severe, Urgency of Expected, and Certainty of Observed for additional languages"},
  { 0x1127, "CMAS Identifier for CMAS Severe Alerts with Severity of Severe, Urgency of Expected, and Certainty of Likely for additional languages"},
  { 0x1128, "CMAS Identifier for Child Abduction Emergency (or Amber Alert) for additional languages"},
  { 0x1129, "CMAS Identifier for the Required Monthly Test for additional languages"},
  { 0x112a, "CMAS Identifier for CMAS Exercise for additional languages"},
  { 0x112b, "CMAS Identifier for operator defined use for additional languages"},
  {      0, NULL},
};
value_string_ext lte_rrc_messageIdentifier_vals_ext = VALUE_STRING_EXT_INIT(lte_rrc_messageIdentifier_vals);

static const value_string lte_rrc_serialNumber_gs_vals[] = {
  { 0, "Display mode immediate, cell wide"},
  { 1, "Display mode normal, PLMN wide"},
  { 2, "Display mode normal, tracking area wide"},
  { 3, "Display mode normal, cell wide"},
  { 0, NULL},
};

static const value_string lte_rrc_warningType_vals[] = {
  { 0, "Earthquake"},
  { 1, "Tsunami"},
  { 2, "Earthquake and Tsunami"},
  { 3, "Test"},
  { 4, "Other"},
  { 0, NULL},
};

static const true_false_string lte_rrc_interBandTDD_CA_WithDifferentConfig_bit1_val = {
  "SCell DL subframes are a subset or superset of PCell by SIB1 configuration - Supported",
  "SCell DL subframes are a subset or superset of PCell by SIB1 configuration - Not supported",
};

static const true_false_string lte_rrc_interBandTDD_CA_WithDifferentConfig_bit2_val = {
  "SCell DL subframes are neither superset nor subset of PCell by SIB1 configuration - Supported",
  "SCell DL subframes are neither superset nor subset of PCell by SIB1 configuration - Not supported",
};

static const true_false_string lte_rrc_tdd_FDD_CA_PCellDuplex_r12_bit1_val = {
  "TDD PCell - Supported",
  "TDD PCell - Not supported"
};

static const true_false_string lte_rrc_tdd_FDD_CA_PCellDuplex_r12_bit2_val = {
  "FDD PCell - Supported",
  "FDD PCell - Not supported"
};

static const true_false_string hf_lte_rrc_aperiodicCSI_Reporting_r13_bit1_val = {
  "Aperiodic CSI reporting with 3 bits of the CSI request field size - Supported",
  "Aperiodic CSI reporting with 3 bits of the CSI request field size - Not supported"
};

static const true_false_string hf_lte_rrc_aperiodicCSI_Reporting_r13_bit2_val = {
  "Aperiodic CSI reporting mode 1-0 and mode 1-1 - Supported",
  "Aperiodic CSI reporting mode 1-0 and mode 1-1 - Not supported"
};

static const true_false_string hf_lte_rrc_codebook_HARQ_ACK_r13_bit1_val = {
  "DAI-based codebook size determination - Supported",
  "DAI-based codebook size determination - Not supported"
};

static const true_false_string hf_lte_rrc_codebook_HARQ_ACK_r13_bit2_val = {
  "Number of configured CCs based codebook size determination - Supported",
  "Number of configured CCs based codebook size determination - Not supported"
};

static const true_false_string lte_rrc_transmissionModeList_r12_val = {
  "NeighCellsInfo applies",
  "NeighCellsInfo does not apply"
};

static const value_string lte_rrc_excessDelay_r13_vals[] = {
  {  0, "ratio < 0.079%"},
  {  1, "0.079% < ratio < 0.100%"},
  {  2, "0.100% < ratio < 0.126%"},
  {  3, "0.126% < ratio < 0.158%"},
  {  4, "0.158% < ratio < 0.199%"},
  {  5, "0.199% < ratio < 0.251%"},
  {  6, "0.251% < ratio < 0.316%"},
  {  7, "0.316% < ratio < 0.398%"},
  {  8, "0.398% < ratio < 0.501%"},
  {  9, "0.501% < ratio < 0.631%"},
  { 10, "0.631% < ratio < 0.794%"},
  { 11, "0.794% < ratio < 1.000%"},
  { 12, "1.000% < ratio < 1.259%"},
  { 13, "1.259% < ratio < 1.585%"},
  { 14, "1.585% < ratio < 1.995%"},
  { 15, "1.995% < ratio < 2.511%"},
  { 16, "2.511% < ratio < 3.161%"},
  { 17, "3.161% < ratio < 3.980%"},
  { 18, "3.980% < ratio < 5.011%"},
  { 19, "5.011% < ratio < 6.309%"},
  { 20, "6.309% < ratio < 7.943%"},
  { 21, "7.943% < ratio < 10.00%"},
  { 22, "10.00% < ratio < 12.589%"},
  { 23, "12.589% < ratio < 15.849%"},
  { 24, "15.849% < ratio < 19.953%"},
  { 25, "19.953% < ratio < 25.119%"},
  { 26, "25.119% < ratio < 31.623%"},
  { 27, "31.623% < ratio < 39.811%"},
  { 28, "39.811% < ratio < 50.119%"},
  { 29, "50.119% < ratio < 63.096%"},
  { 30, "63.096% < ratio < 79.433%"},
  { 31, "79.433% < ratio < 100%"},
  {  0, NULL}
};
static value_string_ext lte_rrc_excessDelay_r13_vals_ext = VALUE_STRING_EXT_INIT(lte_rrc_excessDelay_r13_vals);

static void
lte_rrc_subframeBoundaryOffsetResult_r13_fmt(gchar *s, guint32 v)
{
  if (v == 0) {
    g_snprintf(s, ITEM_LABEL_LENGTH, "abs(deltaZ) < 700Ts (0)");
  } else if (v == 63) {
    g_snprintf(s, ITEM_LABEL_LENGTH, "1320Ts < abs(deltaZ) (63)");
  } else {
    g_snprintf(s, ITEM_LABEL_LENGTH, "%uTs < abs(deltaZ) <= %uTs (%u)", 700+(v-1)*10, 700+v*10, v);
  }
}

static void
lte_rrc_RS_SINR_Range_r13_fmt(gchar *s, guint32 v)
{
  if (v == 0) {
    g_snprintf(s, ITEM_LABEL_LENGTH, "RS-SINR < -23dB (0)");
  } else if (v == 127) {
    g_snprintf(s, ITEM_LABEL_LENGTH, "40dB <= RS-SINR (127)");
  } else {
    g_snprintf(s, ITEM_LABEL_LENGTH, "%.1fdB <= RS-SINR < %.1fdB (%u)", (((float)v-1)/2)-23, ((float)v/2)-23, v);
  }
}

static void
lte_rrc_RS_SINR_RangeNR_r15_fmt(gchar *s, guint32 v)
{
  if (v == 0) {
    g_snprintf(s, ITEM_LABEL_LENGTH, "SS-SINR < -23dB (0)");
  } else if (v == 127) {
    g_snprintf(s, ITEM_LABEL_LENGTH, "40dB < SS-SINR (127)");
  } else {
    g_snprintf(s, ITEM_LABEL_LENGTH, "%.1fdB <= SS-SINR < %.1fdB (%u)", (((float)v-1)/2)-23, ((float)v/2)-23, v);
  }
}

static void
lte_rrc_RSSI_Range_r13_fmt(gchar *s, guint32 v)
{
  if (v == 0) {
    g_snprintf(s, ITEM_LABEL_LENGTH, "RSSI < -100dBm (0)");
  } else if (v == 76) {
    g_snprintf(s, ITEM_LABEL_LENGTH, "-25dBm <= RSSI (76)");
  } else {
    g_snprintf(s, ITEM_LABEL_LENGTH, "%ddBm <= RSSI < %ddBm (%u)", -100+(v-1), -100+v, v);
  }
}

static void
lte_rrc_scptm_FreqOffset_r14_fmt(gchar *s, guint32 v)
{
  g_snprintf(s, ITEM_LABEL_LENGTH, "%udB (%u)", 2*v, v);
}

static void
lte_rrc_offsetDFN_r14_fmt(gchar *s, guint32 v)
{
  if (v == 0) {
    g_snprintf(s, ITEM_LABEL_LENGTH, "0ms (0)");
  } else if (v < 1000) {
    g_snprintf(s, ITEM_LABEL_LENGTH, "%.3fms (%u)", ((float)v)/1000, v);
  } else {
    g_snprintf(s, ITEM_LABEL_LENGTH, "1ms (1000)");
  }
}

static void
lte_rrc_thresholdWLAN_RSSI_fmt(gchar *s, guint32 v)
{
  g_snprintf(s, ITEM_LABEL_LENGTH, "%ddBm (%u)", -128+v, v);
}

static void
lte_rrc_cr_Limit_r14_fmt(gchar *s, guint32 v)
{
  if (v == 0) {
    g_snprintf(s, ITEM_LABEL_LENGTH, "0 (0)");
  } else if (v < 10000) {
    g_snprintf(s, ITEM_LABEL_LENGTH, "%.4f (%u)", ((float)v)/10000, v);
  } else {
    g_snprintf(s, ITEM_LABEL_LENGTH, "1 (10000)");
  }
}

static void
lte_rrc_SL_CBR_r14_fmt(gchar *s, guint32 v)
{
  if (v == 0) {
    g_snprintf(s, ITEM_LABEL_LENGTH, "0 (0)");
  } else if (v < 100) {
    g_snprintf(s, ITEM_LABEL_LENGTH, "%.2f (%u)", ((float)v)/100, v);
  } else {
    g_snprintf(s, ITEM_LABEL_LENGTH, "1 (100)");
  }
}

static void
lte_rrc_threshS_RSSI_CBR_r14_fmt(gchar *s, guint32 v)
{
  g_snprintf(s, ITEM_LABEL_LENGTH, "%ddBm (%u)", -112+(2*v), v);
}

static const value_string lte_rrc_schedulingInfoSIB1_NB_r13_vals[] = {
  {  0, "4 NPDSCH repetitions - TBS 208 bits"},
  {  1, "8 NPDSCH repetitions - TBS 208 bits"},
  {  2, "16 NPDSCH repetitions - TBS 208 bits"},
  {  3, "4 NPDSCH repetitions - TBS 328 bits"},
  {  4, "8 NPDSCH repetitions - TBS 328 bits"},
  {  5, "16 NPDSCH repetitions - TBS 328 bits"},
  {  6, "4 NPDSCH repetitions - TBS 440 bits"},
  {  7, "8 NPDSCH repetitions - TBS 440 bits"},
  {  8, "16 NPDSCH repetitions - TBS 440 bits"},
  {  9, "4 NPDSCH repetitions - TBS 680 bits"},
  { 10, "8 NPDSCH repetitions - TBS 680 bits"},
  { 11, "16 NPDSCH repetitions - TBS 680 bits"},
  {  0, NULL}
};
static value_string_ext lte_rrc_schedulingInfoSIB1_NB_r13_vals_ext = VALUE_STRING_EXT_INIT(lte_rrc_schedulingInfoSIB1_NB_r13_vals);

static void
lte_rrc_NRSRP_Range_NB_r14_fmt(gchar *s, guint32 v)
{
  if (v == 0) {
    g_snprintf(s, ITEM_LABEL_LENGTH, "NRSRP < -156dBm (0)");
  } else if (v < 113) {
    g_snprintf(s, ITEM_LABEL_LENGTH, "%ddBm <= NRSRP < %ddBm (%u)", v-157, v-156, v);
  } else {
    g_snprintf(s, ITEM_LABEL_LENGTH, "-44dBm <= NRSRP (97)");
  }
}

static void
lte_rrc_NRSRQ_Range_NB_r14_fmt(gchar *s, guint32 v)
{
  gint32 rsrq = (guint32)v;
  if (rsrq == -30) {
    g_snprintf(s, ITEM_LABEL_LENGTH, "NRSRQ < -34dB (-30)");
  } else if (rsrq < 0) {
    g_snprintf(s, ITEM_LABEL_LENGTH, "%.1fdB <= NRSRQ < %.1fdB (%d)", (((float)rsrq-1)/2)-19, ((float)rsrq/2)-19, rsrq);
  } else if (rsrq == 0) {
    g_snprintf(s, ITEM_LABEL_LENGTH, "NRSRQ < -19.5dB (0)");
  } else if (rsrq < 34) {
    g_snprintf(s, ITEM_LABEL_LENGTH, "%.1fdB <= NRSRQ < %.1fdB (%d)", (((float)rsrq-1)/2)-19.5, ((float)rsrq/2)-19.5, rsrq);
  } else if (rsrq == 34) {
    g_snprintf(s, ITEM_LABEL_LENGTH, "-3 <= NRSRQ (34)");
  } else if (rsrq < 46) {
    g_snprintf(s, ITEM_LABEL_LENGTH, "%.1fdB <= NRSRQ < %.1fdB (%d)", (((float)rsrq-1)/2)-20, ((float)rsrq/2)-20, rsrq);
  } else {
    g_snprintf(s, ITEM_LABEL_LENGTH, "2.5dB <= NRSRQ (46)");
  }
}

static void
lte_rrc_mbms_MaxBW_r14_fmt(gchar *s, guint32 v)
{
  g_snprintf(s, ITEM_LABEL_LENGTH, "%u MHz (%u)", 40*v, v);
}

static void
lte_rrc_dl_1024QAM_TotalWeightedLayers_r15_fmt(gchar *s, guint32 v)
{
  g_snprintf(s, ITEM_LABEL_LENGTH, "%u (%u)", 10+(2*v), v);
}

static void
lte_rrc_call_dissector(dissector_handle_t handle, tvbuff_t *tvb, packet_info *pinfo, proto_tree *tree)
{
  TRY {
    call_dissector(handle, tvb, pinfo, tree);
  }
  CATCH_BOUNDS_ERRORS {
    show_exception(tvb, pinfo, tree, EXCEPT_CODE, GET_MESSAGE);
  }
  ENDTRY;
}

/*****************************************************************************/
/* Packet private data                                                       */
/* For this dissector, all access to actx->private_data should be made       */
/* through this API, which ensures that they will not overwrite each other!! */
/*****************************************************************************/

typedef struct meas_capabilities_item_band_mappings_t {
  guint16 number_of_bands_set;
  guint16 number_of_interfreq_serving_read;
  guint16 number_of_interfreq_target_read;
  guint16 band_by_item[256];
} meas_capabilities_item_band_mappings_t;


/**********************************************************/
/* Struct to store all current uses of packet private data */
typedef struct lte_rrc_private_data_t
{
  guint8  rat_type;
  guint8  target_rat_type;
  guint8  si_or_psi_geran;
  guint8  ra_preambles;
  guint16 message_identifier;
  guint8 warning_message_segment_type;
  guint8 warning_message_segment_number;
  drb_mapping_t drb_mapping;
  drx_config_t  drx_config;
  pdcp_security_info_t pdcp_security;
  meas_capabilities_item_band_mappings_t meas_capabilities_item_band_mappings;
  simult_pucch_pusch_cell_type cell_type;
  gboolean bcch_dl_sch_msg;
} lte_rrc_private_data_t;

/* Helper function to get or create a struct that will be actx->private_data */
static lte_rrc_private_data_t* lte_rrc_get_private_data(asn1_ctx_t *actx)
{
  if (actx->private_data != NULL) {
    return (lte_rrc_private_data_t*)actx->private_data;
  }
  else {
    lte_rrc_private_data_t* new_struct =
      (lte_rrc_private_data_t*)wmem_alloc0(wmem_packet_scope(), sizeof(lte_rrc_private_data_t));
    actx->private_data = new_struct;
    return new_struct;
  }
}


/* DRX config data */
static drx_config_t* private_data_get_drx_config(asn1_ctx_t *actx)
{
  lte_rrc_private_data_t *private_data = (lte_rrc_private_data_t*)lte_rrc_get_private_data(actx);
  return &private_data->drx_config;
}

/* DRB mapping info */
static drb_mapping_t* private_data_get_drb_mapping(asn1_ctx_t *actx)
{
  lte_rrc_private_data_t *private_data = (lte_rrc_private_data_t*)lte_rrc_get_private_data(actx);
  return &private_data->drb_mapping;
}


/* RAT type */
static guint8 private_data_get_rat_type(asn1_ctx_t *actx)
{
  lte_rrc_private_data_t *private_data = (lte_rrc_private_data_t*)lte_rrc_get_private_data(actx);
  return private_data->rat_type;
}

static void private_data_set_rat_type(asn1_ctx_t *actx, guint8 rat_type)
{
  lte_rrc_private_data_t *private_data = (lte_rrc_private_data_t*)lte_rrc_get_private_data(actx);
  private_data->rat_type = rat_type;
}


/* Target RAT type */
static guint8 private_data_get_rat_target_type(asn1_ctx_t *actx)
{
  lte_rrc_private_data_t *private_data = (lte_rrc_private_data_t*)lte_rrc_get_private_data(actx);
  return private_data->target_rat_type;
}

static void private_data_set_rat_target_type(asn1_ctx_t *actx, guint8 target_rat_type)
{
  lte_rrc_private_data_t *private_data = (lte_rrc_private_data_t*)lte_rrc_get_private_data(actx);
  private_data->target_rat_type = target_rat_type;
}


/* si_or_psi_geran */
static guint8 private_data_get_si_or_psi_geran(asn1_ctx_t *actx)
{
  lte_rrc_private_data_t *private_data = (lte_rrc_private_data_t*)lte_rrc_get_private_data(actx);
  return private_data->si_or_psi_geran;
}

static void private_data_set_si_or_psi_geran(asn1_ctx_t *actx, guint8 si_or_psi_geran)
{
  lte_rrc_private_data_t *private_data = (lte_rrc_private_data_t*)lte_rrc_get_private_data(actx);
  private_data->si_or_psi_geran = si_or_psi_geran;
}


/* Message identifier */
static guint16 private_data_get_message_identifier(asn1_ctx_t *actx)
{
  lte_rrc_private_data_t *private_data = (lte_rrc_private_data_t*)lte_rrc_get_private_data(actx);
  return private_data->message_identifier;
}

static void private_data_set_message_identifier(asn1_ctx_t *actx, guint16 message_identifier)
{
  lte_rrc_private_data_t *private_data = (lte_rrc_private_data_t*)lte_rrc_get_private_data(actx);
  private_data->message_identifier = message_identifier;
}


/* Warning message segment type */
static guint16 private_data_get_warning_message_segment_type(asn1_ctx_t *actx)
{
  lte_rrc_private_data_t *private_data = (lte_rrc_private_data_t*)lte_rrc_get_private_data(actx);
  return private_data->warning_message_segment_type;
}

static void private_data_set_warning_message_segment_type(asn1_ctx_t *actx, guint8 segment_type)
{
  lte_rrc_private_data_t *private_data = (lte_rrc_private_data_t*)lte_rrc_get_private_data(actx);
  private_data->warning_message_segment_type = segment_type;
}


/* Warning message segment number */
static guint16 private_data_get_warning_message_segment_number(asn1_ctx_t *actx)
{
  lte_rrc_private_data_t *private_data = (lte_rrc_private_data_t*)lte_rrc_get_private_data(actx);
  return private_data->warning_message_segment_number;
}

static void private_data_set_warning_message_segment_number(asn1_ctx_t *actx, guint8 segment_number)
{
  lte_rrc_private_data_t *private_data = (lte_rrc_private_data_t*)lte_rrc_get_private_data(actx);
  private_data->warning_message_segment_number = segment_number;
}


/* Number of RA-preambles */
static guint8 private_data_get_ra_preambles(asn1_ctx_t *actx)
{
  lte_rrc_private_data_t *private_data = (lte_rrc_private_data_t*)lte_rrc_get_private_data(actx);
  return private_data->ra_preambles;
}

static void private_data_set_ra_preambles(asn1_ctx_t *actx, guint8 ra_preambles)
{
  lte_rrc_private_data_t *private_data = (lte_rrc_private_data_t*)lte_rrc_get_private_data(actx);
  private_data->ra_preambles = ra_preambles;
}


/* PDCP Security info */
static pdcp_security_info_t* private_data_pdcp_security_algorithms(asn1_ctx_t *actx)
{
  lte_rrc_private_data_t *private_data = (lte_rrc_private_data_t*)lte_rrc_get_private_data(actx);
  return &private_data->pdcp_security;
}


/* Measurement UE capabilities item -> band mappings */
static meas_capabilities_item_band_mappings_t* private_data_meas_capabilities_item_band_mappings(asn1_ctx_t *actx)
{
  lte_rrc_private_data_t *private_data = (lte_rrc_private_data_t*)lte_rrc_get_private_data(actx);
  return &private_data->meas_capabilities_item_band_mappings;
}

static void set_freq_band_indicator(guint32 value, asn1_ctx_t *actx)
{
  /* Store band mapping for this item in the next position */
  meas_capabilities_item_band_mappings_t *mappings = private_data_meas_capabilities_item_band_mappings(actx);
  if (mappings->number_of_bands_set < 256) {
    mappings->band_by_item[mappings->number_of_bands_set++] = (guint16)value;
  }
}

static void remove_last_freq_band_indicator(asn1_ctx_t *actx)
{
  meas_capabilities_item_band_mappings_t *mappings = private_data_meas_capabilities_item_band_mappings(actx);
  if ((mappings->number_of_bands_set > 0) && (mappings->number_of_bands_set < 256)) {
    mappings->number_of_bands_set--;
  }
}

/* Cell type for simultaneousPUCCH-PUSCH-r10 */
static simult_pucch_pusch_cell_type private_data_get_simult_pucch_pusch_cell_type(asn1_ctx_t *actx)
{
  lte_rrc_private_data_t *private_data = (lte_rrc_private_data_t*)lte_rrc_get_private_data(actx);
  return private_data->cell_type;
}

static void private_data_set_simult_pucch_pusch_cell_type(asn1_ctx_t *actx, simult_pucch_pusch_cell_type cell_type)
{
  lte_rrc_private_data_t *private_data = (lte_rrc_private_data_t*)lte_rrc_get_private_data(actx);
  private_data->cell_type = cell_type;
}

/* Is top message a BCCH DL-SCH BR/MBMS */
static gboolean private_data_get_bcch_dl_sch_msg(asn1_ctx_t *actx)
{
  lte_rrc_private_data_t *private_data = (lte_rrc_private_data_t*)lte_rrc_get_private_data(actx);
  return private_data->bcch_dl_sch_msg;
}

static void private_data_set_bcch_dl_sch_msg(asn1_ctx_t *actx, gboolean is_bcch_dl_sch)
{
  lte_rrc_private_data_t *private_data = (lte_rrc_private_data_t*)lte_rrc_get_private_data(actx);
  private_data->bcch_dl_sch_msg = is_bcch_dl_sch;
}

/*****************************************************************************/


static void
lte_rrc_localTimeOffset_fmt(gchar *s, guint32 v)
{
  gint32 time_offset = (gint32) v;

  g_snprintf(s, ITEM_LABEL_LENGTH, "UTC time %c %dhr %dmin (%d)",
             (time_offset < 0) ? '-':'+', abs(time_offset) >> 2,
             (abs(time_offset) & 0x03) * 15, time_offset);
}

static void
dissect_lte_rrc_warningMessageSegment(tvbuff_t *warning_msg_seg_tvb, proto_tree *tree, packet_info *pinfo, guint8 dataCodingScheme)
{
  guint32 offset;
  guint8 nb_of_pages, length, *str;
  proto_item *ti;
  tvbuff_t *cb_data_page_tvb, *cb_data_tvb;
  int i;

  nb_of_pages = tvb_get_guint8(warning_msg_seg_tvb, 0);
  ti = proto_tree_add_uint(tree, hf_lte_rrc_warningMessageSegment_nb_pages, warning_msg_seg_tvb, 0, 1, nb_of_pages);
  if (nb_of_pages > 15) {
    expert_add_info_format(pinfo, ti, &ei_lte_rrc_number_pages_le15,
                           "Number of pages should be <=15 (found %u)", nb_of_pages);
    nb_of_pages = 15;
  }
  for (i = 0, offset = 1; i < nb_of_pages; i++) {
    length = tvb_get_guint8(warning_msg_seg_tvb, offset+82);
    cb_data_page_tvb = tvb_new_subset_length(warning_msg_seg_tvb, offset, length);
    cb_data_tvb = dissect_cbs_data(dataCodingScheme, cb_data_page_tvb, tree, pinfo, 0);
    if (cb_data_tvb) {
      str = tvb_get_string_enc(wmem_packet_scope(), cb_data_tvb, 0, tvb_reported_length(cb_data_tvb), ENC_UTF_8|ENC_NA);
      proto_tree_add_string_format(tree, hf_lte_rrc_warningMessageSegment_decoded_page, warning_msg_seg_tvb, offset, 83,
                                   str, "Decoded Page %u: %s", i+1, str);
    }
    offset += 83;
  }
}

static void
dissect_lte_rrc_featureGroupIndicators(tvbuff_t *featureGroupIndicators_tvb, asn1_ctx_t *actx)
{
  proto_tree *subtree;

  subtree = proto_item_add_subtree(actx->created_item, ett_lte_rrc_featureGroupIndicators);
  proto_tree_add_bits_item(subtree, hf_lte_rrc_eutra_cap_feat_group_ind_1, featureGroupIndicators_tvb, 0, 1, ENC_BIG_ENDIAN);
  proto_tree_add_bits_item(subtree, hf_lte_rrc_eutra_cap_feat_group_ind_2, featureGroupIndicators_tvb, 1, 1, ENC_BIG_ENDIAN);
  proto_tree_add_bits_item(subtree, hf_lte_rrc_eutra_cap_feat_group_ind_3, featureGroupIndicators_tvb, 2, 1, ENC_BIG_ENDIAN);
  proto_tree_add_bits_item(subtree, hf_lte_rrc_eutra_cap_feat_group_ind_4, featureGroupIndicators_tvb, 3, 1, ENC_BIG_ENDIAN);
  proto_tree_add_bits_item(subtree, hf_lte_rrc_eutra_cap_feat_group_ind_5, featureGroupIndicators_tvb, 4, 1, ENC_BIG_ENDIAN);
  proto_tree_add_bits_item(subtree, hf_lte_rrc_eutra_cap_feat_group_ind_6, featureGroupIndicators_tvb, 5, 1, ENC_BIG_ENDIAN);
  proto_tree_add_bits_item(subtree, hf_lte_rrc_eutra_cap_feat_group_ind_7, featureGroupIndicators_tvb, 6, 1, ENC_BIG_ENDIAN);
  proto_tree_add_bits_item(subtree, hf_lte_rrc_eutra_cap_feat_group_ind_8, featureGroupIndicators_tvb, 7, 1, ENC_BIG_ENDIAN);
  proto_tree_add_bits_item(subtree, hf_lte_rrc_eutra_cap_feat_group_ind_9, featureGroupIndicators_tvb, 8, 1, ENC_BIG_ENDIAN);
  proto_tree_add_bits_item(subtree, hf_lte_rrc_eutra_cap_feat_group_ind_10, featureGroupIndicators_tvb, 9, 1, ENC_BIG_ENDIAN);
  proto_tree_add_bits_item(subtree, hf_lte_rrc_eutra_cap_feat_group_ind_11, featureGroupIndicators_tvb, 10, 1, ENC_BIG_ENDIAN);
  proto_tree_add_bits_item(subtree, hf_lte_rrc_eutra_cap_feat_group_ind_12, featureGroupIndicators_tvb, 11, 1, ENC_BIG_ENDIAN);
  proto_tree_add_bits_item(subtree, hf_lte_rrc_eutra_cap_feat_group_ind_13, featureGroupIndicators_tvb, 12, 1, ENC_BIG_ENDIAN);
  proto_tree_add_bits_item(subtree, hf_lte_rrc_eutra_cap_feat_group_ind_14, featureGroupIndicators_tvb, 13, 1, ENC_BIG_ENDIAN);
  proto_tree_add_bits_item(subtree, hf_lte_rrc_eutra_cap_feat_group_ind_15, featureGroupIndicators_tvb, 14, 1, ENC_BIG_ENDIAN);
  proto_tree_add_bits_item(subtree, hf_lte_rrc_eutra_cap_feat_group_ind_16, featureGroupIndicators_tvb, 15, 1, ENC_BIG_ENDIAN);
  proto_tree_add_bits_item(subtree, hf_lte_rrc_eutra_cap_feat_group_ind_17, featureGroupIndicators_tvb, 16, 1, ENC_BIG_ENDIAN);
  proto_tree_add_bits_item(subtree, hf_lte_rrc_eutra_cap_feat_group_ind_18, featureGroupIndicators_tvb, 17, 1, ENC_BIG_ENDIAN);
  proto_tree_add_bits_item(subtree, hf_lte_rrc_eutra_cap_feat_group_ind_19, featureGroupIndicators_tvb, 18, 1, ENC_BIG_ENDIAN);
  proto_tree_add_bits_item(subtree, hf_lte_rrc_eutra_cap_feat_group_ind_20, featureGroupIndicators_tvb, 19, 1, ENC_BIG_ENDIAN);
  proto_tree_add_bits_item(subtree, hf_lte_rrc_eutra_cap_feat_group_ind_21, featureGroupIndicators_tvb, 20, 1, ENC_BIG_ENDIAN);
  proto_tree_add_bits_item(subtree, hf_lte_rrc_eutra_cap_feat_group_ind_22, featureGroupIndicators_tvb, 21, 1, ENC_BIG_ENDIAN);
  proto_tree_add_bits_item(subtree, hf_lte_rrc_eutra_cap_feat_group_ind_23, featureGroupIndicators_tvb, 22, 1, ENC_BIG_ENDIAN);
  proto_tree_add_bits_item(subtree, hf_lte_rrc_eutra_cap_feat_group_ind_24, featureGroupIndicators_tvb, 23, 1, ENC_BIG_ENDIAN);
  proto_tree_add_bits_item(subtree, hf_lte_rrc_eutra_cap_feat_group_ind_25, featureGroupIndicators_tvb, 24, 1, ENC_BIG_ENDIAN);
  proto_tree_add_bits_item(subtree, hf_lte_rrc_eutra_cap_feat_group_ind_26, featureGroupIndicators_tvb, 25, 1, ENC_BIG_ENDIAN);
  proto_tree_add_bits_item(subtree, hf_lte_rrc_eutra_cap_feat_group_ind_27, featureGroupIndicators_tvb, 26, 1, ENC_BIG_ENDIAN);
  proto_tree_add_bits_item(subtree, hf_lte_rrc_eutra_cap_feat_group_ind_28, featureGroupIndicators_tvb, 27, 1, ENC_BIG_ENDIAN);
  proto_tree_add_bits_item(subtree, hf_lte_rrc_eutra_cap_feat_group_ind_29, featureGroupIndicators_tvb, 28, 1, ENC_BIG_ENDIAN);
  proto_tree_add_bits_item(subtree, hf_lte_rrc_eutra_cap_feat_group_ind_30, featureGroupIndicators_tvb, 29, 1, ENC_BIG_ENDIAN);
  proto_tree_add_bits_item(subtree, hf_lte_rrc_eutra_cap_feat_group_ind_31, featureGroupIndicators_tvb, 30, 1, ENC_BIG_ENDIAN);
  proto_tree_add_bits_item(subtree, hf_lte_rrc_eutra_cap_feat_group_ind_32, featureGroupIndicators_tvb, 31, 1, ENC_BIG_ENDIAN);
}

static void
dissect_lte_rrc_featureGroupIndRel10(tvbuff_t *featureGroupIndRel10_tvb, asn1_ctx_t *actx)
{
  proto_tree *subtree;

  subtree = proto_item_add_subtree(actx->created_item, ett_lte_rrc_featureGroupIndRel10);
  proto_tree_add_bits_item(subtree, hf_lte_rrc_eutra_cap_feat_group_ind_101, featureGroupIndRel10_tvb, 0, 1, ENC_BIG_ENDIAN);
  proto_tree_add_bits_item(subtree, hf_lte_rrc_eutra_cap_feat_group_ind_102, featureGroupIndRel10_tvb, 1, 1, ENC_BIG_ENDIAN);
  proto_tree_add_bits_item(subtree, hf_lte_rrc_eutra_cap_feat_group_ind_103, featureGroupIndRel10_tvb, 2, 1, ENC_BIG_ENDIAN);
  proto_tree_add_bits_item(subtree, hf_lte_rrc_eutra_cap_feat_group_ind_104, featureGroupIndRel10_tvb, 3, 1, ENC_BIG_ENDIAN);
  proto_tree_add_bits_item(subtree, hf_lte_rrc_eutra_cap_feat_group_ind_105, featureGroupIndRel10_tvb, 4, 1, ENC_BIG_ENDIAN);
  proto_tree_add_bits_item(subtree, hf_lte_rrc_eutra_cap_feat_group_ind_106, featureGroupIndRel10_tvb, 5, 1, ENC_BIG_ENDIAN);
  proto_tree_add_bits_item(subtree, hf_lte_rrc_eutra_cap_feat_group_ind_107, featureGroupIndRel10_tvb, 6, 1, ENC_BIG_ENDIAN);
  proto_tree_add_bits_item(subtree, hf_lte_rrc_eutra_cap_feat_group_ind_108, featureGroupIndRel10_tvb, 7, 1, ENC_BIG_ENDIAN);
  proto_tree_add_bits_item(subtree, hf_lte_rrc_eutra_cap_feat_group_ind_109, featureGroupIndRel10_tvb, 8, 1, ENC_BIG_ENDIAN);
  proto_tree_add_bits_item(subtree, hf_lte_rrc_eutra_cap_feat_group_ind_110, featureGroupIndRel10_tvb, 9, 1, ENC_BIG_ENDIAN);
  proto_tree_add_bits_item(subtree, hf_lte_rrc_eutra_cap_feat_group_ind_111, featureGroupIndRel10_tvb, 10, 1, ENC_BIG_ENDIAN);
  proto_tree_add_bits_item(subtree, hf_lte_rrc_eutra_cap_feat_group_ind_112, featureGroupIndRel10_tvb, 11, 1, ENC_BIG_ENDIAN);
  proto_tree_add_bits_item(subtree, hf_lte_rrc_eutra_cap_feat_group_ind_113, featureGroupIndRel10_tvb, 12, 1, ENC_BIG_ENDIAN);
  proto_tree_add_bits_item(subtree, hf_lte_rrc_eutra_cap_feat_group_ind_114, featureGroupIndRel10_tvb, 13, 1, ENC_BIG_ENDIAN);
  proto_tree_add_bits_item(subtree, hf_lte_rrc_eutra_cap_feat_group_ind_115, featureGroupIndRel10_tvb, 14, 1, ENC_BIG_ENDIAN);
  proto_tree_add_bits_item(subtree, hf_lte_rrc_eutra_cap_feat_group_ind_116, featureGroupIndRel10_tvb, 15, 1, ENC_BIG_ENDIAN);
  proto_tree_add_bits_item(subtree, hf_lte_rrc_eutra_cap_feat_group_ind_117, featureGroupIndRel10_tvb, 16, 1, ENC_BIG_ENDIAN);
  proto_tree_add_bits_item(subtree, hf_lte_rrc_eutra_cap_feat_group_ind_118, featureGroupIndRel10_tvb, 17, 1, ENC_BIG_ENDIAN);
  proto_tree_add_bits_item(subtree, hf_lte_rrc_eutra_cap_feat_group_ind_119, featureGroupIndRel10_tvb, 18, 1, ENC_BIG_ENDIAN);
  proto_tree_add_bits_item(subtree, hf_lte_rrc_eutra_cap_feat_group_ind_120, featureGroupIndRel10_tvb, 19, 1, ENC_BIG_ENDIAN);
  proto_tree_add_bits_item(subtree, hf_lte_rrc_eutra_cap_feat_group_ind_121, featureGroupIndRel10_tvb, 20, 1, ENC_BIG_ENDIAN);
  proto_tree_add_bits_item(subtree, hf_lte_rrc_eutra_cap_feat_group_ind_122, featureGroupIndRel10_tvb, 21, 1, ENC_BIG_ENDIAN);
  proto_tree_add_bits_item(subtree, hf_lte_rrc_eutra_cap_feat_group_ind_123, featureGroupIndRel10_tvb, 22, 1, ENC_BIG_ENDIAN);
  proto_tree_add_bits_item(subtree, hf_lte_rrc_eutra_cap_feat_group_ind_124, featureGroupIndRel10_tvb, 23, 1, ENC_BIG_ENDIAN);
  proto_tree_add_bits_item(subtree, hf_lte_rrc_eutra_cap_feat_group_ind_125, featureGroupIndRel10_tvb, 24, 1, ENC_BIG_ENDIAN);
  proto_tree_add_bits_item(subtree, hf_lte_rrc_eutra_cap_feat_group_ind_126, featureGroupIndRel10_tvb, 25, 1, ENC_BIG_ENDIAN);
  proto_tree_add_bits_item(subtree, hf_lte_rrc_eutra_cap_feat_group_ind_127, featureGroupIndRel10_tvb, 26, 1, ENC_BIG_ENDIAN);
  proto_tree_add_bits_item(subtree, hf_lte_rrc_eutra_cap_feat_group_ind_128, featureGroupIndRel10_tvb, 27, 1, ENC_BIG_ENDIAN);
  proto_tree_add_bits_item(subtree, hf_lte_rrc_eutra_cap_feat_group_ind_129, featureGroupIndRel10_tvb, 28, 1, ENC_BIG_ENDIAN);
  proto_tree_add_bits_item(subtree, hf_lte_rrc_eutra_cap_feat_group_ind_130, featureGroupIndRel10_tvb, 29, 1, ENC_BIG_ENDIAN);
  proto_tree_add_bits_item(subtree, hf_lte_rrc_eutra_cap_feat_group_ind_131, featureGroupIndRel10_tvb, 30, 1, ENC_BIG_ENDIAN);
  proto_tree_add_bits_item(subtree, hf_lte_rrc_eutra_cap_feat_group_ind_132, featureGroupIndRel10_tvb, 31, 1, ENC_BIG_ENDIAN);
}

static void
dissect_lte_rrc_featureGroupIndRel9Add(tvbuff_t *featureGroupIndRel9Add_tvb, asn1_ctx_t *actx)
{
  proto_tree *subtree;

  subtree = proto_item_add_subtree(actx->created_item, ett_lte_rrc_featureGroupIndRel9Add);
  proto_tree_add_bits_item(subtree, hf_lte_rrc_eutra_cap_feat_group_ind_33, featureGroupIndRel9Add_tvb, 0, 1, ENC_BIG_ENDIAN);
  proto_tree_add_bits_item(subtree, hf_lte_rrc_eutra_cap_feat_group_ind_34, featureGroupIndRel9Add_tvb, 1, 1, ENC_BIG_ENDIAN);
  proto_tree_add_bits_item(subtree, hf_lte_rrc_eutra_cap_feat_group_ind_35, featureGroupIndRel9Add_tvb, 2, 1, ENC_BIG_ENDIAN);
  proto_tree_add_bits_item(subtree, hf_lte_rrc_eutra_cap_feat_group_ind_36, featureGroupIndRel9Add_tvb, 3, 1, ENC_BIG_ENDIAN);
  proto_tree_add_bits_item(subtree, hf_lte_rrc_eutra_cap_feat_group_ind_37, featureGroupIndRel9Add_tvb, 4, 1, ENC_BIG_ENDIAN);
  proto_tree_add_bits_item(subtree, hf_lte_rrc_eutra_cap_feat_group_ind_38, featureGroupIndRel9Add_tvb, 5, 1, ENC_BIG_ENDIAN);
  proto_tree_add_bits_item(subtree, hf_lte_rrc_eutra_cap_feat_group_ind_39, featureGroupIndRel9Add_tvb, 6, 1, ENC_BIG_ENDIAN);
  proto_tree_add_bits_item(subtree, hf_lte_rrc_eutra_cap_feat_group_ind_40, featureGroupIndRel9Add_tvb, 7, 1, ENC_BIG_ENDIAN);
  proto_tree_add_bits_item(subtree, hf_lte_rrc_eutra_cap_feat_group_ind_41, featureGroupIndRel9Add_tvb, 8, 1, ENC_BIG_ENDIAN);
  proto_tree_add_bits_item(subtree, hf_lte_rrc_eutra_cap_feat_group_ind_42, featureGroupIndRel9Add_tvb, 9, 1, ENC_BIG_ENDIAN);
  proto_tree_add_bits_item(subtree, hf_lte_rrc_eutra_cap_feat_group_ind_43, featureGroupIndRel9Add_tvb, 10, 1, ENC_BIG_ENDIAN);
  proto_tree_add_bits_item(subtree, hf_lte_rrc_eutra_cap_feat_group_ind_44, featureGroupIndRel9Add_tvb, 11, 1, ENC_BIG_ENDIAN);
  proto_tree_add_bits_item(subtree, hf_lte_rrc_eutra_cap_feat_group_ind_45, featureGroupIndRel9Add_tvb, 12, 1, ENC_BIG_ENDIAN);
  proto_tree_add_bits_item(subtree, hf_lte_rrc_eutra_cap_feat_group_ind_46, featureGroupIndRel9Add_tvb, 13, 1, ENC_BIG_ENDIAN);
  proto_tree_add_bits_item(subtree, hf_lte_rrc_eutra_cap_feat_group_ind_47, featureGroupIndRel9Add_tvb, 14, 1, ENC_BIG_ENDIAN);
  proto_tree_add_bits_item(subtree, hf_lte_rrc_eutra_cap_feat_group_ind_48, featureGroupIndRel9Add_tvb, 15, 1, ENC_BIG_ENDIAN);
  proto_tree_add_bits_item(subtree, hf_lte_rrc_eutra_cap_feat_group_ind_49, featureGroupIndRel9Add_tvb, 16, 1, ENC_BIG_ENDIAN);
  proto_tree_add_bits_item(subtree, hf_lte_rrc_eutra_cap_feat_group_ind_50, featureGroupIndRel9Add_tvb, 17, 1, ENC_BIG_ENDIAN);
  proto_tree_add_bits_item(subtree, hf_lte_rrc_eutra_cap_feat_group_ind_51, featureGroupIndRel9Add_tvb, 18, 1, ENC_BIG_ENDIAN);
  proto_tree_add_bits_item(subtree, hf_lte_rrc_eutra_cap_feat_group_ind_52, featureGroupIndRel9Add_tvb, 19, 1, ENC_BIG_ENDIAN);
  proto_tree_add_bits_item(subtree, hf_lte_rrc_eutra_cap_feat_group_ind_53, featureGroupIndRel9Add_tvb, 20, 1, ENC_BIG_ENDIAN);
  proto_tree_add_bits_item(subtree, hf_lte_rrc_eutra_cap_feat_group_ind_54, featureGroupIndRel9Add_tvb, 21, 1, ENC_BIG_ENDIAN);
  proto_tree_add_bits_item(subtree, hf_lte_rrc_eutra_cap_feat_group_ind_55, featureGroupIndRel9Add_tvb, 22, 1, ENC_BIG_ENDIAN);
  proto_tree_add_bits_item(subtree, hf_lte_rrc_eutra_cap_feat_group_ind_56, featureGroupIndRel9Add_tvb, 23, 1, ENC_BIG_ENDIAN);
  proto_tree_add_bits_item(subtree, hf_lte_rrc_eutra_cap_feat_group_ind_57, featureGroupIndRel9Add_tvb, 24, 1, ENC_BIG_ENDIAN);
  proto_tree_add_bits_item(subtree, hf_lte_rrc_eutra_cap_feat_group_ind_58, featureGroupIndRel9Add_tvb, 25, 1, ENC_BIG_ENDIAN);
  proto_tree_add_bits_item(subtree, hf_lte_rrc_eutra_cap_feat_group_ind_59, featureGroupIndRel9Add_tvb, 26, 1, ENC_BIG_ENDIAN);
  proto_tree_add_bits_item(subtree, hf_lte_rrc_eutra_cap_feat_group_ind_60, featureGroupIndRel9Add_tvb, 27, 1, ENC_BIG_ENDIAN);
  proto_tree_add_bits_item(subtree, hf_lte_rrc_eutra_cap_feat_group_ind_61, featureGroupIndRel9Add_tvb, 28, 1, ENC_BIG_ENDIAN);
  proto_tree_add_bits_item(subtree, hf_lte_rrc_eutra_cap_feat_group_ind_62, featureGroupIndRel9Add_tvb, 29, 1, ENC_BIG_ENDIAN);
  proto_tree_add_bits_item(subtree, hf_lte_rrc_eutra_cap_feat_group_ind_63, featureGroupIndRel9Add_tvb, 30, 1, ENC_BIG_ENDIAN);
  proto_tree_add_bits_item(subtree, hf_lte_rrc_eutra_cap_feat_group_ind_64, featureGroupIndRel9Add_tvb, 31, 1, ENC_BIG_ENDIAN);
}

/* Functions to get enum values out of indices parsed */
/* If entry not found, return last element of array */
static guint32 drx_lookup_onDurationTimer(guint32 idx)
{
  static const guint32 vals[] = {1,2,3,4,5,6,8,10,20,30,40,50,60,80,100,200};

  if (idx < (sizeof(vals)/sizeof(guint32))) {
    return vals[idx];
  }
  return (sizeof(vals)/(sizeof(guint32)) - 1);
}

static guint32 drx_lookup_inactivityTimer(guint32 idx)
{
  static const guint32 vals[] = {
    1,2,3,4,5,6,8,10,20,30,40,50,60,80,100,200,300, 500,750,1280,1920,2560,0
  };

  if (idx < (sizeof(vals)/sizeof(guint32))) {
    return vals[idx];
  }
  return (sizeof(vals)/(sizeof(guint32)) - 1);
}

static guint32 drx_lookup_retransmissionTimer(guint32 idx)
{
  static const guint32 vals[] = {1,2,4,6,8,16,24,33};

  if (idx < (sizeof(vals)/sizeof(guint32))) {
    return vals[idx];
  }
  return (sizeof(vals)/(sizeof(guint32)) - 1);
}

static guint32 drx_lookup_longCycle(guint32 idx)
{
  static const guint32 vals[] = {
    10,20,32,40,64,80,128,160,256,320,512,640,1024,1280,2048,2560
  };

  if (idx < (sizeof(vals)/sizeof(guint32))) {
    return vals[idx];
  }
  return (sizeof(vals)/(sizeof(guint32)) - 1);
}

static guint32 drx_lookup_longCycle_v1130(guint32 idx)
{
  static const guint32 vals[] = {
    60,70
  };

  if (idx < (sizeof(vals)/sizeof(guint32))) {
    return vals[idx];
  }
  return (sizeof(vals)/(sizeof(guint32)) - 1);
}


static guint32 drx_lookup_shortCycle(guint32 idx)
{
  static const guint32 vals[] = {
    2,5,8,10,16,20,32,40,64,80,128,160,256,320,512,640
  };

  if (idx < (sizeof(vals)/sizeof(guint32))) {
    return vals[idx];
  }
  return (sizeof(vals)/(sizeof(guint32)) - 1);
}

static void drx_check_config_sane(drx_config_t *config, asn1_ctx_t *actx)
{
  /* OnDuration must be shorter than long cycle */
  if (config->onDurationTimer >= config->longCycle) {
      expert_add_info_format(actx->pinfo, actx->created_item, &ei_lte_rrc_invalid_drx_config,
                                  "OnDurationTimer (%u) should be less than long cycle (%u)",
                                  config->onDurationTimer, config->longCycle);
  }

  if (config->shortCycleConfigured) {
    /* Short cycle must be < long, and be a multiple of it */
    if (config->shortCycle >= config->longCycle) {
      expert_add_info_format(actx->pinfo, actx->created_item, &ei_lte_rrc_invalid_drx_config,
                                  "Short DRX cycle (%u) must be shorter than long cycle (%u)",
                                  config->shortCycle, config->longCycle);
    }
    /* Long cycle needs to be an exact multiple of the short cycle */
    else if (config->shortCycle && ((config->longCycle % config->shortCycle) != 0)) {
      expert_add_info_format(actx->pinfo, actx->created_item, &ei_lte_rrc_invalid_drx_config,
                                  "Short DRX cycle (%u) must divide the long cycle (%u) exactly",
                                  config->shortCycle, config->longCycle);

    }
    /* OnDuration shouldn't be longer than the short cycle */
    if (config->onDurationTimer >= config->shortCycle) {
      expert_add_info_format(actx->pinfo, actx->created_item, &ei_lte_rrc_invalid_drx_config,
                                  "OnDurationTimer (%u) should not be longer than the short cycle (%u)",
                                  config->onDurationTimer, config->shortCycle);
    }
    /* TODO: check that (onDuration+(shortCycle*shortCycleTimer)) < longCycle ? */
    /* TODO: check that (shortCycle*shortCycleTimer) < longCycle ? */
  }
}

/* Break sr-configIndex down into periodicity and offset.  From 36.231, 10.1 */
static void sr_lookup_configindex(guint32 config_index, guint16 *periodicity, guint16 *offset)
{
  if (config_index < 5) {
    *periodicity = 5;
    *offset = config_index;
  } else if (config_index < 15) {
    *periodicity = 10;
    *offset = config_index - 5;
  }
  else if (config_index < 35) {
    *periodicity = 20;
    *offset = config_index - 15;
  }
  else if (config_index < 75) {
    *periodicity = 40;
    *offset = config_index - 35;
  }
  else if (config_index < 155) {
    *periodicity = 80;
    *offset = config_index - 75;
  }
  else if (config_index < 157) {
    *periodicity = 2;
    *offset = config_index - 155;
  }
  else {
    *periodicity = 1;
    *offset = 0;
  }
}


/*--- Included file: packet-lte-rrc-fn.c ---*/
#line 1 "./asn1/lte-rrc/packet-lte-rrc-fn.c"
/*--- PDUs declarations ---*/
static int dissect_HandoverPreparationInformation_v9j0_IEs_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_);
static int dissect_SCG_Config_v12i0b_IEs_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_);
static int dissect_MBMSInterestIndication_r11_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_);
static int dissect_UE_RadioPagingInfo_r12_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_);
static int dissect_SystemInformationBlockType1_v890_IEs_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_);
static int dissect_InDeviceCoexIndication_r11_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_);
static int dissect_UEAssistanceInformation_r11_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_);
static int dissect_SidelinkUEInformation_r12_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_);
static int dissect_WLANConnectionStatusReport_r13_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_);
static int dissect_SystemInformationBlockType1_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_);
static int dissect_RRCConnectionReconfiguration_v8m0_IEs_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_);
static int dissect_SystemInformationBlockType2_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_);
static int dissect_RRCConnectionRelease_v9e0_IEs_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_);
static int dissect_SCGFailureInformation_v12d0b_IEs_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_);
static int dissect_SystemInformationBlockType1_v8h0_IEs_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_);
static int dissect_UEInformationResponse_v9e0_IEs_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_);
static int dissect_SystemInformationBlockType2_v8h0_IEs_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_);
static int dissect_SystemInformationBlockType2_v10m0_IEs_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_);
static int dissect_SystemInformationBlockType3_v10j0_IEs_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_);
static int dissect_SystemInformationBlockType5_v8h0_IEs_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_);
static int dissect_SystemInformationBlockType6_v8h0_IEs_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_);
static int dissect_UE_EUTRA_Capability_v10j0_IEs_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_);
static int dissect_UE_EUTRA_Capability_v13e0b_IEs_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_);
static int dissect_UE_EUTRA_Capability_v9a0_IEs_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_);
static int dissect_UE_Capability_NB_Ext_r14_IEs_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_);
static int dissect_UE_Capability_NB_r13_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_);
static int dissect_UECapabilityInformation_NB_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_);
static int dissect_UE_RadioPagingInfo_NB_r13_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_);



static int
dissect_lte_rrc_T_handoverCommandMessage(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_octet_string_containing_pdu_new(tvb, offset, actx, tree, hf_index,
                                                                NO_BOUND, NO_BOUND, FALSE, dissect_DL_DCCH_Message_PDU);

  return offset;
}


static const per_sequence_t T_nonCriticalExtension_sequence[] = {
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_nonCriticalExtension(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_nonCriticalExtension, T_nonCriticalExtension_sequence);

  return offset;
}


static const per_sequence_t HandoverCommand_r8_IEs_sequence[] = {
  { &hf_lte_rrc_handoverCommandMessage, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_handoverCommandMessage },
  { &hf_lte_rrc_nonCriticalExtension, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_T_nonCriticalExtension },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_HandoverCommand_r8_IEs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_HandoverCommand_r8_IEs, HandoverCommand_r8_IEs_sequence);

  return offset;
}



static int
dissect_lte_rrc_NULL(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_null(tvb, offset, actx, tree, hf_index);

  return offset;
}


static const value_string lte_rrc_T_c1_vals[] = {
  {   0, "handoverCommand-r8" },
  {   1, "spare7" },
  {   2, "spare6" },
  {   3, "spare5" },
  {   4, "spare4" },
  {   5, "spare3" },
  {   6, "spare2" },
  {   7, "spare1" },
  { 0, NULL }
};

static const per_choice_t T_c1_choice[] = {
  {   0, &hf_lte_rrc_handoverCommand_r8, ASN1_NO_EXTENSIONS     , dissect_lte_rrc_HandoverCommand_r8_IEs },
  {   1, &hf_lte_rrc_spare7      , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_NULL },
  {   2, &hf_lte_rrc_spare6      , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_NULL },
  {   3, &hf_lte_rrc_spare5      , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_NULL },
  {   4, &hf_lte_rrc_spare4      , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_NULL },
  {   5, &hf_lte_rrc_spare3      , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_NULL },
  {   6, &hf_lte_rrc_spare2      , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_NULL },
  {   7, &hf_lte_rrc_spare1      , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_NULL },
  { 0, NULL, 0, NULL }
};

static int
dissect_lte_rrc_T_c1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lte_rrc_T_c1, T_c1_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t T_criticalExtensionsFuture_sequence[] = {
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_criticalExtensionsFuture(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_criticalExtensionsFuture, T_criticalExtensionsFuture_sequence);

  return offset;
}


static const value_string lte_rrc_T_criticalExtensions_vals[] = {
  {   0, "c1" },
  {   1, "criticalExtensionsFuture" },
  { 0, NULL }
};

static const per_choice_t T_criticalExtensions_choice[] = {
  {   0, &hf_lte_rrc_c1          , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_T_c1 },
  {   1, &hf_lte_rrc_criticalExtensionsFuture, ASN1_NO_EXTENSIONS     , dissect_lte_rrc_T_criticalExtensionsFuture },
  { 0, NULL, 0, NULL }
};

static int
dissect_lte_rrc_T_criticalExtensions(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lte_rrc_T_criticalExtensions, T_criticalExtensions_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t HandoverCommand_sequence[] = {
  { &hf_lte_rrc_criticalExtensions, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_criticalExtensions },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_HandoverCommand(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  proto_item *prot_ti = proto_tree_add_item(tree, proto_lte_rrc, tvb, 0, -1, ENC_NA);
  proto_item_set_hidden(prot_ti);
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_HandoverCommand, HandoverCommand_sequence);

  return offset;
}


static const value_string lte_rrc_RAT_Type_vals[] = {
  { RAT_Type_eutra, "eutra" },
  { RAT_Type_utra, "utra" },
  { RAT_Type_geran_cs, "geran-cs" },
  { RAT_Type_geran_ps, "geran-ps" },
  { RAT_Type_cdma2000_1XRTT, "cdma2000-1XRTT" },
  { RAT_Type_nr, "nr" },
  { RAT_Type_eutra_nr, "eutra-nr" },
  { RAT_Type_spare1, "spare1" },
  { 0, NULL }
};


static int
dissect_lte_rrc_RAT_Type(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  guint32 rat_type;
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     8, &rat_type, TRUE, 0, NULL);

  private_data_set_rat_type(actx, (guint8)rat_type);



  return offset;
}



static int
dissect_lte_rrc_T_ueCapabilityRAT_Container(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *ue_cap_tvb=NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, FALSE, &ue_cap_tvb);



if(ue_cap_tvb){
  guint32 length;
  proto_item *item;
  proto_tree *subtree, *subtree2;
  guint8 byte;
  subtree = proto_item_add_subtree(actx->created_item, ett_lte_rrc_UE_CapabilityRAT_Container);
  switch(private_data_get_rat_type(actx)){
  case RAT_Type_eutra:
    /* eutra */
    dissect_lte_rrc_UE_EUTRA_Capability_PDU(ue_cap_tvb, actx->pinfo, subtree, NULL);
    break;
  case RAT_Type_utra:
    /* utra */
    dissect_rrc_InterRATHandoverInfo_PDU(ue_cap_tvb, actx->pinfo, subtree, NULL);
    break;
  case RAT_Type_geran_cs:
    /* geran-cs */
    /* Mobile Station Classmark 2 is formatted as TLV with the two first bytes set to 0x33 0x03 */
    subtree2 = proto_tree_add_subtree(subtree, ue_cap_tvb, 0, 5,
                       ett_lte_rrc_UE_CapabilityRAT_Container, &item, "Mobile Station Classmark 2");
    byte = tvb_get_guint8(ue_cap_tvb, 0);
    if (byte != 0x33) {
      expert_add_info_format(actx->pinfo, item, &ei_lte_rrc_unexpected_type_value,
                             "Unexpected type value (found 0x%02X)", byte);
    }
    byte = tvb_get_guint8(ue_cap_tvb, 1);
    if (byte != 0x03) {
      expert_add_info_format(actx->pinfo, item, &ei_lte_rrc_unexpected_length_value,
                             "Unexpected length value (found %d)", byte);
    }
    de_ms_cm_2(ue_cap_tvb, subtree2, actx->pinfo, 2, 3, NULL, 0);
    /* Mobile Station Classmark 3 is formatted as V */
    length = tvb_reported_length_remaining(ue_cap_tvb, 5);
    subtree2 = proto_tree_add_subtree(subtree, ue_cap_tvb, 5, length,
                   ett_lte_rrc_UE_CapabilityRAT_Container, NULL, "Mobile Station Classmark 3");
    de_ms_cm_3(ue_cap_tvb, subtree2, actx->pinfo, 5, length, NULL, 0);
    break;
  case RAT_Type_geran_ps:
    /* geran-ps */
    /* MS Radio Access Capability is formatted as V */
    length = tvb_reported_length(ue_cap_tvb);
    subtree2 = proto_tree_add_subtree(subtree, ue_cap_tvb, 0, length,
                     ett_lte_rrc_UE_CapabilityRAT_Container, NULL, "MS Radio Access Capability");
    de_gmm_ms_radio_acc_cap(ue_cap_tvb, subtree2, actx->pinfo, 0, length, NULL, 0);
    break;
  case RAT_Type_cdma2000_1XRTT:
    /* cdma2000-1XRTT */
    /* dissection of "A21 Mobile Subscription Information" could be added to packet-ansi_a.c */
    break;
  case RAT_Type_nr:
    /* nr */
    dissect_nr_rrc_UE_NR_Capability_PDU(ue_cap_tvb, actx->pinfo, subtree, NULL);
    break;
  case RAT_Type_eutra_nr:
    /* eutra-nr */
    dissect_nr_rrc_UE_MRDC_Capability_PDU(ue_cap_tvb, actx->pinfo, subtree, NULL);
    break;
  default:
    break;
  }
}

  return offset;
}


static const per_sequence_t UE_CapabilityRAT_Container_sequence[] = {
  { &hf_lte_rrc_rat_Type    , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_RAT_Type },
  { &hf_lte_rrc_ueCapabilityRAT_Container, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_ueCapabilityRAT_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_UE_CapabilityRAT_Container(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  /* Initialise to invalid value */
  private_data_set_rat_type(actx, 0xFF);
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_UE_CapabilityRAT_Container, UE_CapabilityRAT_Container_sequence);



  return offset;
}


static const per_sequence_t UE_CapabilityRAT_ContainerList_sequence_of[1] = {
  { &hf_lte_rrc_UE_CapabilityRAT_ContainerList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_UE_CapabilityRAT_Container },
};

static int
dissect_lte_rrc_UE_CapabilityRAT_ContainerList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lte_rrc_UE_CapabilityRAT_ContainerList, UE_CapabilityRAT_ContainerList_sequence_of,
                                                  0, maxRAT_Capabilities, FALSE);

  return offset;
}



static int
dissect_lte_rrc_MeasObjectId(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, maxObjectId, NULL, FALSE);

  return offset;
}


static const per_sequence_t MeasObjectToRemoveList_sequence_of[1] = {
  { &hf_lte_rrc_MeasObjectToRemoveList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_MeasObjectId },
};

static int
dissect_lte_rrc_MeasObjectToRemoveList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lte_rrc_MeasObjectToRemoveList, MeasObjectToRemoveList_sequence_of,
                                                  1, maxObjectId, FALSE);

  return offset;
}



static int
dissect_lte_rrc_ARFCN_ValueEUTRA(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, maxEARFCN, NULL, FALSE);

  return offset;
}


static const value_string lte_rrc_AllowedMeasBandwidth_vals[] = {
  {   0, "mbw6" },
  {   1, "mbw15" },
  {   2, "mbw25" },
  {   3, "mbw50" },
  {   4, "mbw75" },
  {   5, "mbw100" },
  { 0, NULL }
};


static int
dissect_lte_rrc_AllowedMeasBandwidth(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     6, NULL, FALSE, 0, NULL);

  return offset;
}



static int
dissect_lte_rrc_PresenceAntennaPort1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_boolean(tvb, offset, actx, tree, hf_index, NULL);

  return offset;
}



static int
dissect_lte_rrc_NeighCellConfig(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *neigh_cell_config_tvb = NULL;
  offset = dissect_per_bit_string(tvb, offset, actx, tree, -1,
                                     2, 2, FALSE, NULL, 0, &neigh_cell_config_tvb, NULL);



  if (neigh_cell_config_tvb) {
    guint bitvalue = tvb_get_bits8(neigh_cell_config_tvb, 0, 2);
    actx->created_item = proto_tree_add_uint(tree, hf_index, neigh_cell_config_tvb, 0, 1, bitvalue);
  }

  return offset;
}


static const value_string lte_rrc_Q_OffsetRange_vals[] = {
  {   0, "dB-24" },
  {   1, "dB-22" },
  {   2, "dB-20" },
  {   3, "dB-18" },
  {   4, "dB-16" },
  {   5, "dB-14" },
  {   6, "dB-12" },
  {   7, "dB-10" },
  {   8, "dB-8" },
  {   9, "dB-6" },
  {  10, "dB-5" },
  {  11, "dB-4" },
  {  12, "dB-3" },
  {  13, "dB-2" },
  {  14, "dB-1" },
  {  15, "dB0" },
  {  16, "dB1" },
  {  17, "dB2" },
  {  18, "dB3" },
  {  19, "dB4" },
  {  20, "dB5" },
  {  21, "dB6" },
  {  22, "dB8" },
  {  23, "dB10" },
  {  24, "dB12" },
  {  25, "dB14" },
  {  26, "dB16" },
  {  27, "dB18" },
  {  28, "dB20" },
  {  29, "dB22" },
  {  30, "dB24" },
  { 0, NULL }
};

static value_string_ext lte_rrc_Q_OffsetRange_vals_ext = VALUE_STRING_EXT_INIT(lte_rrc_Q_OffsetRange_vals);


static int
dissect_lte_rrc_Q_OffsetRange(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     31, NULL, FALSE, 0, NULL);

  return offset;
}



static int
dissect_lte_rrc_CellIndex(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, maxCellMeas, NULL, FALSE);

  return offset;
}


static const per_sequence_t CellIndexList_sequence_of[1] = {
  { &hf_lte_rrc_CellIndexList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_CellIndex },
};

static int
dissect_lte_rrc_CellIndexList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lte_rrc_CellIndexList, CellIndexList_sequence_of,
                                                  1, maxCellMeas, FALSE);

  return offset;
}



static int
dissect_lte_rrc_INTEGER_1_maxCellMeas(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, maxCellMeas, NULL, FALSE);

  return offset;
}



static int
dissect_lte_rrc_PhysCellId(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 503U, NULL, FALSE);

  return offset;
}


static const per_sequence_t CellsToAddMod_sequence[] = {
  { &hf_lte_rrc_cellIndex   , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_INTEGER_1_maxCellMeas },
  { &hf_lte_rrc_physCellId_01, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_PhysCellId },
  { &hf_lte_rrc_cellIndividualOffset, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_Q_OffsetRange },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_CellsToAddMod(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_CellsToAddMod, CellsToAddMod_sequence);

  return offset;
}


static const per_sequence_t CellsToAddModList_sequence_of[1] = {
  { &hf_lte_rrc_CellsToAddModList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_CellsToAddMod },
};

static int
dissect_lte_rrc_CellsToAddModList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lte_rrc_CellsToAddModList, CellsToAddModList_sequence_of,
                                                  1, maxCellMeas, FALSE);

  return offset;
}


static const value_string lte_rrc_T_range_vals[] = {
  {   0, "n4" },
  {   1, "n8" },
  {   2, "n12" },
  {   3, "n16" },
  {   4, "n24" },
  {   5, "n32" },
  {   6, "n48" },
  {   7, "n64" },
  {   8, "n84" },
  {   9, "n96" },
  {  10, "n128" },
  {  11, "n168" },
  {  12, "n252" },
  {  13, "n504" },
  {  14, "spare2" },
  {  15, "spare1" },
  { 0, NULL }
};


static int
dissect_lte_rrc_T_range(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     16, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t PhysCellIdRange_sequence[] = {
  { &hf_lte_rrc_start_01    , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_PhysCellId },
  { &hf_lte_rrc_range       , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_T_range },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_PhysCellIdRange(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_PhysCellIdRange, PhysCellIdRange_sequence);

  return offset;
}


static const per_sequence_t BlackCellsToAddMod_sequence[] = {
  { &hf_lte_rrc_cellIndex   , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_INTEGER_1_maxCellMeas },
  { &hf_lte_rrc_physCellIdRange, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_PhysCellIdRange },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_BlackCellsToAddMod(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_BlackCellsToAddMod, BlackCellsToAddMod_sequence);

  return offset;
}


static const per_sequence_t BlackCellsToAddModList_sequence_of[1] = {
  { &hf_lte_rrc_BlackCellsToAddModList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_BlackCellsToAddMod },
};

static int
dissect_lte_rrc_BlackCellsToAddModList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lte_rrc_BlackCellsToAddModList, BlackCellsToAddModList_sequence_of,
                                                  1, maxCellMeas, FALSE);

  return offset;
}


static const value_string lte_rrc_MeasCycleSCell_r10_vals[] = {
  {   0, "sf160" },
  {   1, "sf256" },
  {   2, "sf320" },
  {   3, "sf512" },
  {   4, "sf640" },
  {   5, "sf1024" },
  {   6, "sf1280" },
  {   7, "spare1" },
  { 0, NULL }
};


static int
dissect_lte_rrc_MeasCycleSCell_r10(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     8, NULL, FALSE, 0, NULL);

  return offset;
}



static int
dissect_lte_rrc_BIT_STRING_SIZE_40(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     40, 40, FALSE, NULL, 0, NULL, NULL);

  return offset;
}



static int
dissect_lte_rrc_BIT_STRING_SIZE_20(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     20, 20, FALSE, NULL, 0, NULL, NULL);

  return offset;
}



static int
dissect_lte_rrc_BIT_STRING_SIZE_70(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     70, 70, FALSE, NULL, 0, NULL, NULL);

  return offset;
}



static int
dissect_lte_rrc_BIT_STRING_SIZE_60(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     60, 60, FALSE, NULL, 0, NULL, NULL);

  return offset;
}


static const value_string lte_rrc_T_subframePatternTDD_r10_vals[] = {
  {   0, "subframeConfig1-5-r10" },
  {   1, "subframeConfig0-r10" },
  {   2, "subframeConfig6-r10" },
  { 0, NULL }
};

static const per_choice_t T_subframePatternTDD_r10_choice[] = {
  {   0, &hf_lte_rrc_subframeConfig1_5_r10, ASN1_EXTENSION_ROOT    , dissect_lte_rrc_BIT_STRING_SIZE_20 },
  {   1, &hf_lte_rrc_subframeConfig0_r10, ASN1_EXTENSION_ROOT    , dissect_lte_rrc_BIT_STRING_SIZE_70 },
  {   2, &hf_lte_rrc_subframeConfig6_r10, ASN1_EXTENSION_ROOT    , dissect_lte_rrc_BIT_STRING_SIZE_60 },
  { 0, NULL, 0, NULL }
};

static int
dissect_lte_rrc_T_subframePatternTDD_r10(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lte_rrc_T_subframePatternTDD_r10, T_subframePatternTDD_r10_choice,
                                 NULL);

  return offset;
}


static const value_string lte_rrc_MeasSubframePattern_r10_vals[] = {
  {   0, "subframePatternFDD-r10" },
  {   1, "subframePatternTDD-r10" },
  { 0, NULL }
};

static const per_choice_t MeasSubframePattern_r10_choice[] = {
  {   0, &hf_lte_rrc_subframePatternFDD_r10, ASN1_EXTENSION_ROOT    , dissect_lte_rrc_BIT_STRING_SIZE_40 },
  {   1, &hf_lte_rrc_subframePatternTDD_r10, ASN1_EXTENSION_ROOT    , dissect_lte_rrc_T_subframePatternTDD_r10 },
  { 0, NULL, 0, NULL }
};

static int
dissect_lte_rrc_MeasSubframePattern_r10(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lte_rrc_MeasSubframePattern_r10, MeasSubframePattern_r10_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t MeasSubframeCellList_r10_sequence_of[1] = {
  { &hf_lte_rrc_MeasSubframeCellList_r10_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_PhysCellIdRange },
};

static int
dissect_lte_rrc_MeasSubframeCellList_r10(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lte_rrc_MeasSubframeCellList_r10, MeasSubframeCellList_r10_sequence_of,
                                                  1, maxCellMeas, FALSE);

  return offset;
}


static const per_sequence_t T_setup_153_sequence[] = {
  { &hf_lte_rrc_measSubframePatternNeigh_r10, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_MeasSubframePattern_r10 },
  { &hf_lte_rrc_measSubframeCellList_r10, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_MeasSubframeCellList_r10 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_setup_153(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_setup_153, T_setup_153_sequence);

  return offset;
}


static const value_string lte_rrc_MeasSubframePatternConfigNeigh_r10_vals[] = {
  {   0, "release" },
  {   1, "setup" },
  { 0, NULL }
};

static const per_choice_t MeasSubframePatternConfigNeigh_r10_choice[] = {
  {   0, &hf_lte_rrc_release     , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_NULL },
  {   1, &hf_lte_rrc_setup_171   , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_T_setup_153 },
  { 0, NULL, 0, NULL }
};

static int
dissect_lte_rrc_MeasSubframePatternConfigNeigh_r10(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lte_rrc_MeasSubframePatternConfigNeigh_r10, MeasSubframePatternConfigNeigh_r10_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t MeasObjectEUTRA_eag_1_sequence[] = {
  { &hf_lte_rrc_measCycleSCell_r10, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_MeasCycleSCell_r10 },
  { &hf_lte_rrc_measSubframePatternConfigNeigh_r10, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_MeasSubframePatternConfigNeigh_r10 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_MeasObjectEUTRA_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, MeasObjectEUTRA_eag_1_sequence);

  return offset;
}



static int
dissect_lte_rrc_BOOLEAN(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_boolean(tvb, offset, actx, tree, hf_index, NULL);

  return offset;
}


static const per_sequence_t MeasObjectEUTRA_eag_2_sequence[] = {
  { &hf_lte_rrc_widebandRSRQ_Meas_r11, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_BOOLEAN },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_MeasObjectEUTRA_eag_2(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, MeasObjectEUTRA_eag_2_sequence);

  return offset;
}


static const per_sequence_t AltTTT_CellsToAddMod_r12_sequence[] = {
  { &hf_lte_rrc_cellIndex_r12, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_INTEGER_1_maxCellMeas },
  { &hf_lte_rrc_physCellIdRange_r12, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_PhysCellIdRange },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_AltTTT_CellsToAddMod_r12(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_AltTTT_CellsToAddMod_r12, AltTTT_CellsToAddMod_r12_sequence);

  return offset;
}


static const per_sequence_t AltTTT_CellsToAddModList_r12_sequence_of[1] = {
  { &hf_lte_rrc_AltTTT_CellsToAddModList_r12_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_AltTTT_CellsToAddMod_r12 },
};

static int
dissect_lte_rrc_AltTTT_CellsToAddModList_r12(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lte_rrc_AltTTT_CellsToAddModList_r12, AltTTT_CellsToAddModList_r12_sequence_of,
                                                  1, maxCellMeas, FALSE);

  return offset;
}


static const value_string lte_rrc_T_setup_152_vals[] = {
  {   0, "ms0" },
  {   1, "ms50" },
  {   2, "ms100" },
  {   3, "ms200" },
  {   4, "ms300" },
  {   5, "ms400" },
  {   6, "ms500" },
  {   7, "ms1000" },
  { 0, NULL }
};


static int
dissect_lte_rrc_T_setup_152(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     8, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lte_rrc_T_t312_r12_vals[] = {
  {   0, "release" },
  {   1, "setup" },
  { 0, NULL }
};

static const per_choice_t T_t312_r12_choice[] = {
  {   0, &hf_lte_rrc_release     , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_NULL },
  {   1, &hf_lte_rrc_setup_170   , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_T_setup_152 },
  { 0, NULL, 0, NULL }
};

static int
dissect_lte_rrc_T_t312_r12(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lte_rrc_T_t312_r12, T_t312_r12_choice,
                                 NULL);

  return offset;
}



static int
dissect_lte_rrc_INTEGER_0_39(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 39U, NULL, FALSE);

  return offset;
}



static int
dissect_lte_rrc_INTEGER_0_79(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 79U, NULL, FALSE);

  return offset;
}



static int
dissect_lte_rrc_INTEGER_0_159(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 159U, NULL, FALSE);

  return offset;
}


static const value_string lte_rrc_T_dmtc_PeriodOffset_r12_vals[] = {
  {   0, "ms40-r12" },
  {   1, "ms80-r12" },
  {   2, "ms160-r12" },
  { 0, NULL }
};

static const per_choice_t T_dmtc_PeriodOffset_r12_choice[] = {
  {   0, &hf_lte_rrc_ms40_r12    , ASN1_EXTENSION_ROOT    , dissect_lte_rrc_INTEGER_0_39 },
  {   1, &hf_lte_rrc_ms80_r12    , ASN1_EXTENSION_ROOT    , dissect_lte_rrc_INTEGER_0_79 },
  {   2, &hf_lte_rrc_ms160_r12   , ASN1_EXTENSION_ROOT    , dissect_lte_rrc_INTEGER_0_159 },
  { 0, NULL, 0, NULL }
};

static int
dissect_lte_rrc_T_dmtc_PeriodOffset_r12(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lte_rrc_T_dmtc_PeriodOffset_r12, T_dmtc_PeriodOffset_r12_choice,
                                 NULL);

  return offset;
}



static int
dissect_lte_rrc_INTEGER_1_maxDS_Duration_r12(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, maxDS_Duration_r12, NULL, FALSE);

  return offset;
}



static int
dissect_lte_rrc_INTEGER_2_maxDS_Duration_r12(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            2U, maxDS_Duration_r12, NULL, FALSE);

  return offset;
}


static const value_string lte_rrc_T_ds_OccasionDuration_r12_vals[] = {
  {   0, "durationFDD-r12" },
  {   1, "durationTDD-r12" },
  { 0, NULL }
};

static const per_choice_t T_ds_OccasionDuration_r12_choice[] = {
  {   0, &hf_lte_rrc_durationFDD_r12, ASN1_NO_EXTENSIONS     , dissect_lte_rrc_INTEGER_1_maxDS_Duration_r12 },
  {   1, &hf_lte_rrc_durationTDD_r12, ASN1_NO_EXTENSIONS     , dissect_lte_rrc_INTEGER_2_maxDS_Duration_r12 },
  { 0, NULL, 0, NULL }
};

static int
dissect_lte_rrc_T_ds_OccasionDuration_r12(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lte_rrc_T_ds_OccasionDuration_r12, T_ds_OccasionDuration_r12_choice,
                                 NULL);

  return offset;
}



static int
dissect_lte_rrc_MeasCSI_RS_Id_r12(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, maxCSI_RS_Meas_r12, NULL, FALSE);

  return offset;
}


static const per_sequence_t MeasCSI_RS_ToRemoveList_r12_sequence_of[1] = {
  { &hf_lte_rrc_MeasCSI_RS_ToRemoveList_r12_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_MeasCSI_RS_Id_r12 },
};

static int
dissect_lte_rrc_MeasCSI_RS_ToRemoveList_r12(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lte_rrc_MeasCSI_RS_ToRemoveList_r12, MeasCSI_RS_ToRemoveList_r12_sequence_of,
                                                  1, maxCSI_RS_Meas_r12, FALSE);

  return offset;
}



static int
dissect_lte_rrc_INTEGER_0_503(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 503U, NULL, FALSE);

  return offset;
}



static int
dissect_lte_rrc_INTEGER_0_31(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 31U, NULL, FALSE);

  return offset;
}



static int
dissect_lte_rrc_INTEGER_0_4(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 4U, NULL, FALSE);

  return offset;
}


static const per_sequence_t MeasCSI_RS_Config_r12_sequence[] = {
  { &hf_lte_rrc_measCSI_RS_Id_r12, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lte_rrc_MeasCSI_RS_Id_r12 },
  { &hf_lte_rrc_physCellId_r12_01, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lte_rrc_INTEGER_0_503 },
  { &hf_lte_rrc_scramblingIdentity_r12, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lte_rrc_INTEGER_0_503 },
  { &hf_lte_rrc_resourceConfig_r12, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lte_rrc_INTEGER_0_31 },
  { &hf_lte_rrc_subframeOffset_r12, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lte_rrc_INTEGER_0_4 },
  { &hf_lte_rrc_csi_RS_IndividualOffset_r12, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lte_rrc_Q_OffsetRange },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_MeasCSI_RS_Config_r12(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_MeasCSI_RS_Config_r12, MeasCSI_RS_Config_r12_sequence);

  return offset;
}


static const per_sequence_t MeasCSI_RS_ToAddModList_r12_sequence_of[1] = {
  { &hf_lte_rrc_MeasCSI_RS_ToAddModList_r12_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_MeasCSI_RS_Config_r12 },
};

static int
dissect_lte_rrc_MeasCSI_RS_ToAddModList_r12(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lte_rrc_MeasCSI_RS_ToAddModList_r12, MeasCSI_RS_ToAddModList_r12_sequence_of,
                                                  1, maxCSI_RS_Meas_r12, FALSE);

  return offset;
}


static const per_sequence_t T_setup_147_sequence[] = {
  { &hf_lte_rrc_dmtc_PeriodOffset_r12, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_dmtc_PeriodOffset_r12 },
  { &hf_lte_rrc_ds_OccasionDuration_r12, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_ds_OccasionDuration_r12 },
  { &hf_lte_rrc_measCSI_RS_ToRemoveList_r12, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lte_rrc_MeasCSI_RS_ToRemoveList_r12 },
  { &hf_lte_rrc_measCSI_RS_ToAddModList_r12, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lte_rrc_MeasCSI_RS_ToAddModList_r12 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_setup_147(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_setup_147, T_setup_147_sequence);

  return offset;
}


static const value_string lte_rrc_MeasDS_Config_r12_vals[] = {
  {   0, "release" },
  {   1, "setup" },
  { 0, NULL }
};

static const per_choice_t MeasDS_Config_r12_choice[] = {
  {   0, &hf_lte_rrc_release     , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_NULL },
  {   1, &hf_lte_rrc_setup_165   , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_T_setup_147 },
  { 0, NULL, 0, NULL }
};

static int
dissect_lte_rrc_MeasDS_Config_r12(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lte_rrc_MeasDS_Config_r12, MeasDS_Config_r12_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t MeasObjectEUTRA_eag_3_sequence[] = {
  { &hf_lte_rrc_altTTT_CellsToRemoveList_r12, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_CellIndexList },
  { &hf_lte_rrc_altTTT_CellsToAddModList_r12, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_AltTTT_CellsToAddModList_r12 },
  { &hf_lte_rrc_t312_r12    , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_T_t312_r12 },
  { &hf_lte_rrc_reducedMeasPerformance_r12_05, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_BOOLEAN },
  { &hf_lte_rrc_measDS_Config_r12, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_MeasDS_Config_r12 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_MeasObjectEUTRA_eag_3(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, MeasObjectEUTRA_eag_3_sequence);

  return offset;
}


static const per_sequence_t WhiteCellsToAddMod_r13_sequence[] = {
  { &hf_lte_rrc_cellIndex_r13, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_INTEGER_1_maxCellMeas },
  { &hf_lte_rrc_physCellIdRange_r13, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_PhysCellIdRange },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_WhiteCellsToAddMod_r13(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_WhiteCellsToAddMod_r13, WhiteCellsToAddMod_r13_sequence);

  return offset;
}


static const per_sequence_t WhiteCellsToAddModList_r13_sequence_of[1] = {
  { &hf_lte_rrc_WhiteCellsToAddModList_r13_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_WhiteCellsToAddMod_r13 },
};

static int
dissect_lte_rrc_WhiteCellsToAddModList_r13(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lte_rrc_WhiteCellsToAddModList_r13, WhiteCellsToAddModList_r13_sequence_of,
                                                  1, maxCellMeas, FALSE);

  return offset;
}


static const value_string lte_rrc_T_rmtc_Period_r13_vals[] = {
  {   0, "ms40" },
  {   1, "ms80" },
  {   2, "ms160" },
  {   3, "ms320" },
  {   4, "ms640" },
  { 0, NULL }
};


static int
dissect_lte_rrc_T_rmtc_Period_r13(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     5, NULL, FALSE, 0, NULL);

  return offset;
}



static int
dissect_lte_rrc_INTEGER_0_639(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 639U, NULL, FALSE);

  return offset;
}


static const value_string lte_rrc_T_measDuration_r13_vals[] = {
  {   0, "sym1" },
  {   1, "sym14" },
  {   2, "sym28" },
  {   3, "sym42" },
  {   4, "sym70" },
  { 0, NULL }
};


static int
dissect_lte_rrc_T_measDuration_r13(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     5, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t T_setup_154_sequence[] = {
  { &hf_lte_rrc_rmtc_Period_r13, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_rmtc_Period_r13 },
  { &hf_lte_rrc_rmtc_SubframeOffset_r13, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lte_rrc_INTEGER_0_639 },
  { &hf_lte_rrc_measDuration_r13, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_measDuration_r13 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_setup_154(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_setup_154, T_setup_154_sequence);

  return offset;
}


static const value_string lte_rrc_RMTC_Config_r13_vals[] = {
  {   0, "release" },
  {   1, "setup" },
  { 0, NULL }
};

static const per_choice_t RMTC_Config_r13_choice[] = {
  {   0, &hf_lte_rrc_release     , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_NULL },
  {   1, &hf_lte_rrc_setup_172   , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_T_setup_154 },
  { 0, NULL, 0, NULL }
};

static int
dissect_lte_rrc_RMTC_Config_r13(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lte_rrc_RMTC_Config_r13, RMTC_Config_r13_choice,
                                 NULL);

  return offset;
}



static int
dissect_lte_rrc_ARFCN_ValueEUTRA_v9e0(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            maxEARFCN_Plus1, maxEARFCN2, NULL, FALSE);

  return offset;
}


static const per_sequence_t MeasObjectEUTRA_eag_4_sequence[] = {
  { &hf_lte_rrc_whiteCellsToRemoveList_r13, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_CellIndexList },
  { &hf_lte_rrc_whiteCellsToAddModList_r13, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_WhiteCellsToAddModList_r13 },
  { &hf_lte_rrc_rmtc_Config_r13, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_RMTC_Config_r13 },
  { &hf_lte_rrc_carrierFreq_r13, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_ARFCN_ValueEUTRA_v9e0 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_MeasObjectEUTRA_eag_4(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, MeasObjectEUTRA_eag_4_sequence);

  return offset;
}



static int
dissect_lte_rrc_SL_V2X_TxPoolReportIdentity_r14(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, maxSL_PoolToMeasure_r14, NULL, FALSE);

  return offset;
}


static const per_sequence_t Tx_ResourcePoolMeasList_r14_sequence_of[1] = {
  { &hf_lte_rrc_Tx_ResourcePoolMeasList_r14_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_SL_V2X_TxPoolReportIdentity_r14 },
};

static int
dissect_lte_rrc_Tx_ResourcePoolMeasList_r14(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lte_rrc_Tx_ResourcePoolMeasList_r14, Tx_ResourcePoolMeasList_r14_sequence_of,
                                                  1, maxSL_PoolToMeasure_r14, FALSE);

  return offset;
}


static const per_sequence_t MeasObjectEUTRA_eag_5_sequence[] = {
  { &hf_lte_rrc_tx_ResourcePoolToRemoveList_r14, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_Tx_ResourcePoolMeasList_r14 },
  { &hf_lte_rrc_tx_ResourcePoolToAddList_r14, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_Tx_ResourcePoolMeasList_r14 },
  { &hf_lte_rrc_fembms_MixedCarrier_r14, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_BOOLEAN },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_MeasObjectEUTRA_eag_5(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, MeasObjectEUTRA_eag_5_sequence);

  return offset;
}



static int
dissect_lte_rrc_INTEGER_1_20(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 20U, NULL, FALSE);

  return offset;
}


static const value_string lte_rrc_T_sensingPeriodicity_r15_vals[] = {
  {   0, "ms20" },
  {   1, "ms50" },
  {   2, "ms100" },
  {   3, "ms200" },
  {   4, "ms300" },
  {   5, "ms400" },
  {   6, "ms500" },
  {   7, "ms600" },
  {   8, "ms700" },
  {   9, "ms800" },
  {  10, "ms900" },
  {  11, "ms1000" },
  { 0, NULL }
};


static int
dissect_lte_rrc_T_sensingPeriodicity_r15(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     12, NULL, FALSE, 0, NULL);

  return offset;
}



static int
dissect_lte_rrc_INTEGER_5_75(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            5U, 75U, NULL, FALSE);

  return offset;
}



static int
dissect_lte_rrc_INTEGER_1_8(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 8U, NULL, FALSE);

  return offset;
}


static const per_sequence_t MeasSensing_Config_r15_sequence[] = {
  { &hf_lte_rrc_sensingSubchannelNumber_r15, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_INTEGER_1_20 },
  { &hf_lte_rrc_sensingPeriodicity_r15, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_sensingPeriodicity_r15 },
  { &hf_lte_rrc_sensingReselectionCounter_r15, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_INTEGER_5_75 },
  { &hf_lte_rrc_sensingPriority_r15, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_INTEGER_1_8 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_MeasSensing_Config_r15(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_MeasSensing_Config_r15, MeasSensing_Config_r15_sequence);

  return offset;
}


static const per_sequence_t MeasObjectEUTRA_eag_6_sequence[] = {
  { &hf_lte_rrc_measSensing_Config_r15, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_MeasSensing_Config_r15 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_MeasObjectEUTRA_eag_6(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, MeasObjectEUTRA_eag_6_sequence);

  return offset;
}


static const per_sequence_t MeasObjectEUTRA_sequence[] = {
  { &hf_lte_rrc_carrierFreq_01, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lte_rrc_ARFCN_ValueEUTRA },
  { &hf_lte_rrc_allowedMeasBandwidth, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lte_rrc_AllowedMeasBandwidth },
  { &hf_lte_rrc_presenceAntennaPort1, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lte_rrc_PresenceAntennaPort1 },
  { &hf_lte_rrc_neighCellConfig, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lte_rrc_NeighCellConfig },
  { &hf_lte_rrc_offsetFreq_01, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lte_rrc_Q_OffsetRange },
  { &hf_lte_rrc_cellsToRemoveList, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lte_rrc_CellIndexList },
  { &hf_lte_rrc_cellsToAddModList_01, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lte_rrc_CellsToAddModList },
  { &hf_lte_rrc_blackCellsToRemoveList, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lte_rrc_CellIndexList },
  { &hf_lte_rrc_blackCellsToAddModList, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lte_rrc_BlackCellsToAddModList },
  { &hf_lte_rrc_cellForWhichToReportCGI_01, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lte_rrc_PhysCellId },
  { &dummy_hf_lte_rrc_eag_field, ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lte_rrc_MeasObjectEUTRA_eag_1 },
  { &dummy_hf_lte_rrc_eag_field, ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lte_rrc_MeasObjectEUTRA_eag_2 },
  { &dummy_hf_lte_rrc_eag_field, ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lte_rrc_MeasObjectEUTRA_eag_3 },
  { &dummy_hf_lte_rrc_eag_field, ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lte_rrc_MeasObjectEUTRA_eag_4 },
  { &dummy_hf_lte_rrc_eag_field, ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lte_rrc_MeasObjectEUTRA_eag_5 },
  { &dummy_hf_lte_rrc_eag_field, ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lte_rrc_MeasObjectEUTRA_eag_6 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_MeasObjectEUTRA(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_MeasObjectEUTRA, MeasObjectEUTRA_sequence);

  return offset;
}



static int
dissect_lte_rrc_ARFCN_ValueUTRA(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 16383U, NULL, FALSE);

  return offset;
}



static int
dissect_lte_rrc_Q_OffsetRangeInterRAT(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -15, 15U, NULL, FALSE);

  return offset;
}



static int
dissect_lte_rrc_PhysCellIdUTRA_FDD(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 511U, NULL, FALSE);

  return offset;
}


static const per_sequence_t CellsToAddModUTRA_FDD_sequence[] = {
  { &hf_lte_rrc_cellIndex   , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_INTEGER_1_maxCellMeas },
  { &hf_lte_rrc_physCellId_03, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_PhysCellIdUTRA_FDD },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_CellsToAddModUTRA_FDD(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_CellsToAddModUTRA_FDD, CellsToAddModUTRA_FDD_sequence);

  return offset;
}


static const per_sequence_t CellsToAddModListUTRA_FDD_sequence_of[1] = {
  { &hf_lte_rrc_CellsToAddModListUTRA_FDD_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_CellsToAddModUTRA_FDD },
};

static int
dissect_lte_rrc_CellsToAddModListUTRA_FDD(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lte_rrc_CellsToAddModListUTRA_FDD, CellsToAddModListUTRA_FDD_sequence_of,
                                                  1, maxCellMeas, FALSE);

  return offset;
}



static int
dissect_lte_rrc_PhysCellIdUTRA_TDD(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 127U, NULL, FALSE);

  return offset;
}


static const per_sequence_t CellsToAddModUTRA_TDD_sequence[] = {
  { &hf_lte_rrc_cellIndex   , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_INTEGER_1_maxCellMeas },
  { &hf_lte_rrc_physCellId_04, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_PhysCellIdUTRA_TDD },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_CellsToAddModUTRA_TDD(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_CellsToAddModUTRA_TDD, CellsToAddModUTRA_TDD_sequence);

  return offset;
}


static const per_sequence_t CellsToAddModListUTRA_TDD_sequence_of[1] = {
  { &hf_lte_rrc_CellsToAddModListUTRA_TDD_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_CellsToAddModUTRA_TDD },
};

static int
dissect_lte_rrc_CellsToAddModListUTRA_TDD(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lte_rrc_CellsToAddModListUTRA_TDD, CellsToAddModListUTRA_TDD_sequence_of,
                                                  1, maxCellMeas, FALSE);

  return offset;
}


static const value_string lte_rrc_T_cellsToAddModList_vals[] = {
  {   0, "cellsToAddModListUTRA-FDD" },
  {   1, "cellsToAddModListUTRA-TDD" },
  { 0, NULL }
};

static const per_choice_t T_cellsToAddModList_choice[] = {
  {   0, &hf_lte_rrc_cellsToAddModListUTRA_FDD, ASN1_NO_EXTENSIONS     , dissect_lte_rrc_CellsToAddModListUTRA_FDD },
  {   1, &hf_lte_rrc_cellsToAddModListUTRA_TDD, ASN1_NO_EXTENSIONS     , dissect_lte_rrc_CellsToAddModListUTRA_TDD },
  { 0, NULL, 0, NULL }
};

static int
dissect_lte_rrc_T_cellsToAddModList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lte_rrc_T_cellsToAddModList, T_cellsToAddModList_choice,
                                 NULL);

  return offset;
}


static const value_string lte_rrc_T_cellForWhichToReportCGI_vals[] = {
  {   0, "utra-FDD" },
  {   1, "utra-TDD" },
  { 0, NULL }
};

static const per_choice_t T_cellForWhichToReportCGI_choice[] = {
  {   0, &hf_lte_rrc_utra_FDD_01 , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_PhysCellIdUTRA_FDD },
  {   1, &hf_lte_rrc_utra_TDD_01 , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_PhysCellIdUTRA_TDD },
  { 0, NULL, 0, NULL }
};

static int
dissect_lte_rrc_T_cellForWhichToReportCGI(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lte_rrc_T_cellForWhichToReportCGI, T_cellForWhichToReportCGI_choice,
                                 NULL);

  return offset;
}



static int
dissect_lte_rrc_INTEGER_2_512(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            2U, 512U, NULL, FALSE);

  return offset;
}


static const per_sequence_t PhysCellIdRangeUTRA_FDD_r9_sequence[] = {
  { &hf_lte_rrc_start_r9    , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_PhysCellIdUTRA_FDD },
  { &hf_lte_rrc_range_r9    , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_INTEGER_2_512 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_PhysCellIdRangeUTRA_FDD_r9(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_PhysCellIdRangeUTRA_FDD_r9, PhysCellIdRangeUTRA_FDD_r9_sequence);

  return offset;
}


static const per_sequence_t PhysCellIdRangeUTRA_FDDList_r9_sequence_of[1] = {
  { &hf_lte_rrc_PhysCellIdRangeUTRA_FDDList_r9_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_PhysCellIdRangeUTRA_FDD_r9 },
};

static int
dissect_lte_rrc_PhysCellIdRangeUTRA_FDDList_r9(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lte_rrc_PhysCellIdRangeUTRA_FDDList_r9, PhysCellIdRangeUTRA_FDDList_r9_sequence_of,
                                                  1, maxPhysCellIdRange_r9, FALSE);

  return offset;
}


static const per_sequence_t CSG_AllowedReportingCells_r9_sequence[] = {
  { &hf_lte_rrc_physCellIdRangeUTRA_FDDList_r9, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_PhysCellIdRangeUTRA_FDDList_r9 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_CSG_AllowedReportingCells_r9(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_CSG_AllowedReportingCells_r9, CSG_AllowedReportingCells_r9_sequence);

  return offset;
}


static const per_sequence_t MeasObjectUTRA_eag_1_sequence[] = {
  { &hf_lte_rrc_csg_allowedReportingCells_v930, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_CSG_AllowedReportingCells_r9 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_MeasObjectUTRA_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, MeasObjectUTRA_eag_1_sequence);

  return offset;
}


static const per_sequence_t MeasObjectUTRA_eag_2_sequence[] = {
  { &hf_lte_rrc_reducedMeasPerformance_r12_05, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_BOOLEAN },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_MeasObjectUTRA_eag_2(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, MeasObjectUTRA_eag_2_sequence);

  return offset;
}


static const per_sequence_t MeasObjectUTRA_sequence[] = {
  { &hf_lte_rrc_carrierFreq_02, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lte_rrc_ARFCN_ValueUTRA },
  { &hf_lte_rrc_offsetFreq  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lte_rrc_Q_OffsetRangeInterRAT },
  { &hf_lte_rrc_cellsToRemoveList, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lte_rrc_CellIndexList },
  { &hf_lte_rrc_cellsToAddModList_02, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lte_rrc_T_cellsToAddModList },
  { &hf_lte_rrc_cellForWhichToReportCGI_03, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lte_rrc_T_cellForWhichToReportCGI },
  { &dummy_hf_lte_rrc_eag_field, ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lte_rrc_MeasObjectUTRA_eag_1 },
  { &dummy_hf_lte_rrc_eag_field, ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lte_rrc_MeasObjectUTRA_eag_2 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_MeasObjectUTRA(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_MeasObjectUTRA, MeasObjectUTRA_sequence);

  return offset;
}



static int
dissect_lte_rrc_ARFCN_ValueGERAN(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 1023U, NULL, FALSE);

  return offset;
}


static const value_string lte_rrc_BandIndicatorGERAN_vals[] = {
  {   0, "dcs1800" },
  {   1, "pcs1900" },
  { 0, NULL }
};


static int
dissect_lte_rrc_BandIndicatorGERAN(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t ExplicitListOfARFCNs_sequence_of[1] = {
  { &hf_lte_rrc_ExplicitListOfARFCNs_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_ARFCN_ValueGERAN },
};

static int
dissect_lte_rrc_ExplicitListOfARFCNs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lte_rrc_ExplicitListOfARFCNs, ExplicitListOfARFCNs_sequence_of,
                                                  0, 31, FALSE);

  return offset;
}


static const per_sequence_t T_equallySpacedARFCNs_sequence[] = {
  { &hf_lte_rrc_arfcn_Spacing, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_INTEGER_1_8 },
  { &hf_lte_rrc_numberOfFollowingARFCNs, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_INTEGER_0_31 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_equallySpacedARFCNs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_equallySpacedARFCNs, T_equallySpacedARFCNs_sequence);

  return offset;
}



static int
dissect_lte_rrc_OCTET_STRING_SIZE_1_16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       1, 16, FALSE, NULL);

  return offset;
}


static const value_string lte_rrc_T_followingARFCNs_vals[] = {
  {   0, "explicitListOfARFCNs" },
  {   1, "equallySpacedARFCNs" },
  {   2, "variableBitMapOfARFCNs" },
  { 0, NULL }
};

static const per_choice_t T_followingARFCNs_choice[] = {
  {   0, &hf_lte_rrc_explicitListOfARFCNs, ASN1_NO_EXTENSIONS     , dissect_lte_rrc_ExplicitListOfARFCNs },
  {   1, &hf_lte_rrc_equallySpacedARFCNs, ASN1_NO_EXTENSIONS     , dissect_lte_rrc_T_equallySpacedARFCNs },
  {   2, &hf_lte_rrc_variableBitMapOfARFCNs, ASN1_NO_EXTENSIONS     , dissect_lte_rrc_OCTET_STRING_SIZE_1_16 },
  { 0, NULL, 0, NULL }
};

static int
dissect_lte_rrc_T_followingARFCNs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lte_rrc_T_followingARFCNs, T_followingARFCNs_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t CarrierFreqsGERAN_sequence[] = {
  { &hf_lte_rrc_startingARFCN, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_ARFCN_ValueGERAN },
  { &hf_lte_rrc_bandIndicator, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_BandIndicatorGERAN },
  { &hf_lte_rrc_followingARFCNs, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_followingARFCNs },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_CarrierFreqsGERAN(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_CarrierFreqsGERAN, CarrierFreqsGERAN_sequence);

  return offset;
}



static int
dissect_lte_rrc_BIT_STRING_SIZE_8(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     8, 8, FALSE, NULL, 0, NULL, NULL);

  return offset;
}



static int
dissect_lte_rrc_BIT_STRING_SIZE_3(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     3, 3, FALSE, NULL, 0, NULL, NULL);

  return offset;
}


static const per_sequence_t PhysCellIdGERAN_sequence[] = {
  { &hf_lte_rrc_networkColourCode, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_BIT_STRING_SIZE_3 },
  { &hf_lte_rrc_baseStationColourCode, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_BIT_STRING_SIZE_3 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_PhysCellIdGERAN(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_PhysCellIdGERAN, PhysCellIdGERAN_sequence);

  return offset;
}


static const per_sequence_t MeasObjectGERAN_sequence[] = {
  { &hf_lte_rrc_carrierFreqs, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lte_rrc_CarrierFreqsGERAN },
  { &hf_lte_rrc_offsetFreq  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lte_rrc_Q_OffsetRangeInterRAT },
  { &hf_lte_rrc_ncc_Permitted, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lte_rrc_BIT_STRING_SIZE_8 },
  { &hf_lte_rrc_cellForWhichToReportCGI_02, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lte_rrc_PhysCellIdGERAN },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_MeasObjectGERAN(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_MeasObjectGERAN, MeasObjectGERAN_sequence);

  return offset;
}


static const value_string lte_rrc_CDMA2000_Type_vals[] = {
  {   0, "type1XRTT" },
  {   1, "typeHRPD" },
  { 0, NULL }
};


static int
dissect_lte_rrc_CDMA2000_Type(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lte_rrc_BandclassCDMA2000_vals[] = {
  {   0, "bc0" },
  {   1, "bc1" },
  {   2, "bc2" },
  {   3, "bc3" },
  {   4, "bc4" },
  {   5, "bc5" },
  {   6, "bc6" },
  {   7, "bc7" },
  {   8, "bc8" },
  {   9, "bc9" },
  {  10, "bc10" },
  {  11, "bc11" },
  {  12, "bc12" },
  {  13, "bc13" },
  {  14, "bc14" },
  {  15, "bc15" },
  {  16, "bc16" },
  {  17, "bc17" },
  {  18, "bc18-v9a0" },
  {  19, "bc19-v9a0" },
  {  20, "bc20-v9a0" },
  {  21, "bc21-v9a0" },
  {  22, "spare10" },
  {  23, "spare9" },
  {  24, "spare8" },
  {  25, "spare7" },
  {  26, "spare6" },
  {  27, "spare5" },
  {  28, "spare4" },
  {  29, "spare3" },
  {  30, "spare2" },
  {  31, "spare1" },
  { 0, NULL }
};

static value_string_ext lte_rrc_BandclassCDMA2000_vals_ext = VALUE_STRING_EXT_INIT(lte_rrc_BandclassCDMA2000_vals);


static int
dissect_lte_rrc_BandclassCDMA2000(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     32, NULL, TRUE, 0, NULL);

  return offset;
}



static int
dissect_lte_rrc_ARFCN_ValueCDMA2000(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 2047U, NULL, FALSE);

  return offset;
}


static const per_sequence_t CarrierFreqCDMA2000_sequence[] = {
  { &hf_lte_rrc_bandClass   , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_BandclassCDMA2000 },
  { &hf_lte_rrc_arfcn       , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_ARFCN_ValueCDMA2000 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_CarrierFreqCDMA2000(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_CarrierFreqCDMA2000, CarrierFreqCDMA2000_sequence);

  return offset;
}



static int
dissect_lte_rrc_INTEGER_0_15(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 15U, NULL, FALSE);

  return offset;
}



static int
dissect_lte_rrc_PhysCellIdCDMA2000(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, maxPNOffset, NULL, FALSE);

  return offset;
}


static const per_sequence_t CellsToAddModCDMA2000_sequence[] = {
  { &hf_lte_rrc_cellIndex   , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_INTEGER_1_maxCellMeas },
  { &hf_lte_rrc_physCellId_02, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_PhysCellIdCDMA2000 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_CellsToAddModCDMA2000(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_CellsToAddModCDMA2000, CellsToAddModCDMA2000_sequence);

  return offset;
}


static const per_sequence_t CellsToAddModListCDMA2000_sequence_of[1] = {
  { &hf_lte_rrc_CellsToAddModListCDMA2000_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_CellsToAddModCDMA2000 },
};

static int
dissect_lte_rrc_CellsToAddModListCDMA2000(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lte_rrc_CellsToAddModListCDMA2000, CellsToAddModListCDMA2000_sequence_of,
                                                  1, maxCellMeas, FALSE);

  return offset;
}


static const per_sequence_t MeasObjectCDMA2000_sequence[] = {
  { &hf_lte_rrc_cdma2000_Type, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lte_rrc_CDMA2000_Type },
  { &hf_lte_rrc_carrierFreq_04, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lte_rrc_CarrierFreqCDMA2000 },
  { &hf_lte_rrc_searchWindowSize, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lte_rrc_INTEGER_0_15 },
  { &hf_lte_rrc_offsetFreq  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lte_rrc_Q_OffsetRangeInterRAT },
  { &hf_lte_rrc_cellsToRemoveList, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lte_rrc_CellIndexList },
  { &hf_lte_rrc_cellsToAddModList, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lte_rrc_CellsToAddModListCDMA2000 },
  { &hf_lte_rrc_cellForWhichToReportCGI, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lte_rrc_PhysCellIdCDMA2000 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_MeasObjectCDMA2000(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_MeasObjectCDMA2000, MeasObjectCDMA2000_sequence);

  return offset;
}


static const value_string lte_rrc_WLAN_BandIndicator_r13_vals[] = {
  {   0, "band2dot4" },
  {   1, "band5" },
  {   2, "band60-v1430" },
  {   3, "spare5" },
  {   4, "spare4" },
  {   5, "spare3" },
  {   6, "spare2" },
  {   7, "s