#!/bin/bash

# Test package that computes default database settings

TMP_DIR="${TMPDIR}"

test -z "${BIN_DIR}" && BIN_DIR=website/cgi-bin

SCRIPT_BASE=`basename $0 | sed "s/_[0-9]*\.sh$//"`

BASENAME=$(basename $0 .pm)

#BEGIN DEPEND------------------------------------------------------------------

INPUT_SCRIPT="${BIN_DIR}/${SCRIPT_BASE}"

#END DEPEND--------------------------------------------------------------------

set -ue
## set -x

test -z "${TMP_DIR}" && TMP_DIR="/tmp"
TMP_DIR="${TMP_DIR}/tmp-${BASENAME}-$$"
mkdir "${TMP_DIR}"

# To make the trap portable between bash and dash, we need to trap
# "signal" 0 ("EXIT") and rely on it for the cleanup:
## trap "rm -rf '${TMP_DIR}'" 0 1 2 3 15
trap "rm -rf '${TMP_DIR}'" EXIT
trap "exit 1" HUP INT QUIT TERM

TMP_DB_MAIN="${TMP_DIR}/db/test4fk.db"
TMP_DB_META="${TMP_DIR}/db/restful.db"

mkdir $(dirname ${TMP_DB_MAIN})
cp db/test4fk.db ${TMP_DB_MAIN}

ln -s $(pwd)/lib ${TMP_DIR}
ln -s $(pwd)/sql ${TMP_DIR}
ln -s $(pwd)/tools ${TMP_DIR}

mkdir ${TMP_DIR}/website
mkdir ${TMP_DIR}/website/cgi-bin

mkdir -p ${TMP_DIR}/${BIN_DIR}

cp ${INPUT_SCRIPT} ${TMP_DIR}/${BIN_DIR}

# Change dir to the sandbox and run the test:

cd ${TMP_DIR}

sqlite3 ${TMP_DB_META} < sql/metatables.sql

cat > content.inp <<END
{
    "data": {
        "type": "sample",
        "attributes": {
            "mine": "Matuizų karjeras",
            "SolsaID": "XX-TEST-0001"
        }
    }
}
END

export REQUEST_URI='/~saulius/restful/website/test4fk.db/sample'
export HTTP_HOST=test.domain.net
export REQUEST_METHOD=POST
export CONTENT_TYPE='application/vnd.api+json'
export CONTENT_LENGTH=$(cat content.inp | wc -c)
export REMOTE_USER=tester

cat content.inp \
    | ${INPUT_SCRIPT} \
    | tools/scripts/prettyprint-inner-json \
    | perl -lpe 's/tmp-\S+test4fk\.db/tmp-samples.db/g'
    
sqlite3 -nullvalue NULL ${TMP_DB_MAIN} 'select * from sample order by id'

# Temporary directory will be deleted by the trap.
