# SPDX-License-Identifier: BSD-3-Clause
#
# Copyright 2024 Raritan Inc. All rights reserved.
#
# This is an auto-generated file.

#
# Section generated by IdlC from "ModbusGatewayMgr.idl"
#

import raritan.rpc
from raritan.rpc import Interface, Structure, ValueObject, Enumeration, typecheck, DecodeException
import raritan.rpc.modbus


# interface
class GatewayMgr(Interface):
    idlType = "modbus.GatewayMgr:1.0.0"

    NO_ERROR = 0

    ERR_INVALID_PARAMS = 1

    # structure
    class RtuSettings(Structure):
        idlType = "modbus.GatewayMgr.RtuSettings:1.0.0"
        elements = ["defaultAddr", "speed", "parity"]

        def __init__(self, defaultAddr=0, speed=0, parity=0):
            typecheck.is_byte(defaultAddr, AssertionError)
            typecheck.is_int(speed, AssertionError)
            typecheck.is_byte(parity, AssertionError)

            self.defaultAddr = defaultAddr
            self.speed = speed
            self.parity = parity

        @classmethod
        def decode(cls, json, agent, useDefaults=False):
            obj = cls(
                defaultAddr = json['defaultAddr'] if 'defaultAddr' in json or not useDefaults else 0,
                speed = json['speed'] if 'speed' in json or not useDefaults else 0,
                parity = json['parity'] if 'parity' in json or not useDefaults else 0,
            )
            return obj

        def encode(self):
            json = {}
            json['defaultAddr'] = self.defaultAddr
            json['speed'] = self.speed
            json['parity'] = self.parity
            return json

    # structure
    class Settings(Structure):
        idlType = "modbus.GatewayMgr.Settings:1.0.0"
        elements = ["rtu"]

        def __init__(self, rtu=None):
            if rtu is None:
                rtu = raritan.rpc.modbus.GatewayMgr.RtuSettings()
            typecheck.is_struct(rtu, raritan.rpc.modbus.GatewayMgr.RtuSettings, AssertionError)

            self.rtu = rtu

        @classmethod
        def decode(cls, json, agent, useDefaults=False):
            obj = cls(
                rtu = raritan.rpc.modbus.GatewayMgr.RtuSettings.decode(json['rtu'], agent, useDefaults=useDefaults) if 'rtu' in json or not useDefaults else raritan.rpc.modbus.GatewayMgr.RtuSettings(),
            )
            return obj

        def encode(self):
            json = {}
            json['rtu'] = raritan.rpc.modbus.GatewayMgr.RtuSettings.encode(self.rtu)
            return json

    class _getSettings(Interface.Method):
        name = 'getSettings'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = raritan.rpc.modbus.GatewayMgr.Settings.decode(rsp['_ret_'], agent, useDefaults=useDefaults)
            typecheck.is_struct(_ret_, raritan.rpc.modbus.GatewayMgr.Settings, DecodeException)
            return _ret_

    class _setSettings(Interface.Method):
        name = 'setSettings'

        @staticmethod
        def encode(settings):
            typecheck.is_struct(settings, raritan.rpc.modbus.GatewayMgr.Settings, AssertionError)
            args = {}
            args['settings'] = raritan.rpc.modbus.GatewayMgr.Settings.encode(settings)
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = rsp['_ret_']
            typecheck.is_int(_ret_, DecodeException)
            return _ret_
    def __init__(self, target, agent):
        super(GatewayMgr, self).__init__(target, agent)
        self.getSettings = GatewayMgr._getSettings(self)
        self.setSettings = GatewayMgr._setSettings(self)
