% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/constructor.R
\name{new_model}
\alias{new_model}
\title{Constructor for a base model}
\usage{
new_model(..., blueprint = default_xy_blueprint(), class = character())
}
\arguments{
\item{...}{Name-value pairs for elements specific to the model defined by
\code{class}.}

\item{blueprint}{A preprocessing \code{blueprint} returned from a call to \code{\link[=mold]{mold()}}.}

\item{class}{A character vector representing the class of the model.}
}
\value{
A new scalar model object, represented as a classed list with named elements
specified in \code{...}.
}
\description{
A \strong{model} is a \emph{scalar object}, as classified in
\href{https://adv-r.hadley.nz/s3.html#object-styles}{Advanced R}. As such, it
takes uniquely named elements in \code{...} and combines them into a list with
a class of \code{class}. This entire object represent a single model.
}
\details{
Because every model should have multiple interfaces, including formula
and \code{recipes} interfaces, all models should have a \code{blueprint} that
can process new data when \code{predict()} is called. The easiest way to generate
an blueprint with all of the information required at prediction time is to
use the one that is returned from a call to \code{\link[=mold]{mold()}}.
}
\examples{
new_model(
  custom_element = "my-elem",
  blueprint = default_xy_blueprint(),
  class = "custom_model"
)
}
