% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rhdf5.R
\name{h5listObjects}
\alias{h5listObjects}
\alias{h5listIdentifier}
\alias{h5validObjects}
\title{List all open HDF5 objects.}
\usage{
h5listIdentifier()

h5validObjects(native = FALSE)
}
\arguments{
\item{native}{An object of class \code{logical}. If TRUE, array-like objects
are treated as stored in HDF5 row-major rather than R column-major
orientation. Using \code{native = TRUE} increases HDF5 file portability
between programming languages. A file written with \code{native = TRUE}
should also be read with \code{native = TRUE}}
}
\value{
\code{h5validObjects} returns a list of \linkS4class{H5IdComponent}
objects. \code{h5listIdentifier} prints the valid identifiers on screen and
returns NULL.
}
\description{
A list of all valid HDF5 identifiers. H5 objects should be closed after usage
to release resources.
}
\examples{

h5File <- tempfile("ex_list_identifier.h5")

h5createFile(h5File)

# create groups
h5createGroup(h5File,"foo")

h5listIdentifier()
h5validObjects()

}
\author{
Bernd Fischer, Mike Smith
}
