# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class MongoDbCursorMethodsProperties(Model):
    """Cursor methods for Mongodb query.

    :param additional_properties: Unmatched properties from the message are
     deserialized this collection
    :type additional_properties: dict[str, object]
    :param project: Specifies the fields to return in the documents that match
     the query filter. To return all fields in the matching documents, omit
     this parameter. Type: string (or Expression with resultType string).
    :type project: object
    :param sort: Specifies the order in which the query returns matching
     documents. Type: string (or Expression with resultType string). Type:
     string (or Expression with resultType string).
    :type sort: object
    :param skip: Specifies the how many documents skipped and where MongoDB
     begins returning results. This approach may be useful in implementing
     paginated results. Type: integer (or Expression with resultType integer).
    :type skip: object
    :param limit: Specifies the maximum number of documents the server
     returns. limit() is analogous to the LIMIT statement in a SQL database.
     Type: integer (or Expression with resultType integer).
    :type limit: object
    """

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'project': {'key': 'project', 'type': 'object'},
        'sort': {'key': 'sort', 'type': 'object'},
        'skip': {'key': 'skip', 'type': 'object'},
        'limit': {'key': 'limit', 'type': 'object'},
    }

    def __init__(self, **kwargs):
        super(MongoDbCursorMethodsProperties, self).__init__(**kwargs)
        self.additional_properties = kwargs.get('additional_properties', None)
        self.project = kwargs.get('project', None)
        self.sort = kwargs.get('sort', None)
        self.skip = kwargs.get('skip', None)
        self.limit = kwargs.get('limit', None)
