/*=========================================================================

  Program:   Visualization Toolkit

  Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
  All rights reserved.
  See Copyright.txt or http://www.kitware.com/Copyright.htm for details.

     This software is distributed WITHOUT ANY WARRANTY; without even
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/
// This test renders a volume slab and a plane through the middle of the slab.

#include <vtkActor.h>
#include <vtkCamera.h>
#include <vtkColorTransferFunction.h>
#include <vtkGPUVolumeRayCastMapper.h>
#include <vtkImageData.h>
#include <vtkInteractorStyleTrackballCamera.h>
#include <vtkNew.h>
#include <vtkPiecewiseFunction.h>
#include <vtkPiecewiseFunction.h>
#include <vtkPlaneSource.h>
#include <vtkPointData.h>
#include <vtkPolyDataMapper.h>
#include <vtkProperty.h>
#include <vtkRTAnalyticSource.h>
#include <vtkRenderWindow.h>
#include <vtkRenderWindowInteractor.h>
#include <vtkRenderer.h>
#include <vtkTesting.h>
#include <vtkTimerLog.h>
#include <vtkVolume.h>
#include <vtkVolumeProperty.h>

//----------------------------------------------------------------------------
static const char * TestGPURayCastVolumePlaneLog =
"# StreamVersion 1\n"
"EnterEvent 169 9 0 0 0 0 0\n"
"MouseMoveEvent 169 9 0 0 0 0 0\n"
"MouseMoveEvent 168 21 0 0 0 0 0\n"
"MouseMoveEvent 168 33 0 0 0 0 0\n"
"MouseMoveEvent 168 43 0 0 0 0 0\n"
"MouseMoveEvent 168 51 0 0 0 0 0\n"
"MouseMoveEvent 170 58 0 0 0 0 0\n"
"MouseMoveEvent 172 65 0 0 0 0 0\n"
"MouseMoveEvent 175 71 0 0 0 0 0\n"
"MouseMoveEvent 178 76 0 0 0 0 0\n"
"MouseMoveEvent 181 80 0 0 0 0 0\n"
"MouseMoveEvent 184 85 0 0 0 0 0\n"
"MouseMoveEvent 187 89 0 0 0 0 0\n"
"MouseMoveEvent 190 94 0 0 0 0 0\n"
"MouseMoveEvent 194 100 0 0 0 0 0\n"
"MouseMoveEvent 199 108 0 0 0 0 0\n"
"MouseMoveEvent 202 115 0 0 0 0 0\n"
"MouseMoveEvent 206 123 0 0 0 0 0\n"
"MouseMoveEvent 212 131 0 0 0 0 0\n"
"MouseMoveEvent 218 140 0 0 0 0 0\n"
"MouseMoveEvent 222 148 0 0 0 0 0\n"
"MouseMoveEvent 228 156 0 0 0 0 0\n"
"MouseMoveEvent 232 164 0 0 0 0 0\n"
"MouseMoveEvent 236 171 0 0 0 0 0\n"
"MouseMoveEvent 238 175 0 0 0 0 0\n"
"MouseMoveEvent 241 179 0 0 0 0 0\n"
"MouseMoveEvent 242 181 0 0 0 0 0\n"
"MouseMoveEvent 242 183 0 0 0 0 0\n"
"MouseMoveEvent 242 184 0 0 0 0 0\n"
"MouseMoveEvent 242 183 0 0 0 0 0\n"
"MouseMoveEvent 240 181 0 0 0 0 0\n"
"MouseMoveEvent 240 179 0 0 0 0 0\n"
"MouseMoveEvent 239 178 0 0 0 0 0\n"
"MouseMoveEvent 239 177 0 0 0 0 0\n"
"MouseMoveEvent 238 177 0 0 0 0 0\n"
"MouseMoveEvent 238 176 0 0 0 0 0\n"
"MouseMoveEvent 237 175 0 0 0 0 0\n"
"MouseMoveEvent 237 174 0 0 0 0 0\n"
"MouseMoveEvent 236 173 0 0 0 0 0\n"
"MouseMoveEvent 235 173 0 0 0 0 0\n"
"MouseMoveEvent 235 173 0 0 0 0 0\n"
"LeftButtonPressEvent 235 173 0 0 0 0 0\n"
"StartInteractionEvent 235 173 0 0 0 0 0\n"
"MouseMoveEvent 234 171 0 0 0 0 0\n"
"RenderEvent 234 171 0 0 0 0 0\n"
"InteractionEvent 234 171 0 0 0 0 0\n"
"MouseMoveEvent 233 171 0 0 0 0 0\n"
"RenderEvent 233 171 0 0 0 0 0\n"
"InteractionEvent 233 171 0 0 0 0 0\n"
"MouseMoveEvent 231 170 0 0 0 0 0\n"
"RenderEvent 231 170 0 0 0 0 0\n"
"InteractionEvent 231 170 0 0 0 0 0\n"
"MouseMoveEvent 228 169 0 0 0 0 0\n"
"RenderEvent 228 169 0 0 0 0 0\n"
"InteractionEvent 228 169 0 0 0 0 0\n"
"MouseMoveEvent 222 167 0 0 0 0 0\n"
"RenderEvent 222 167 0 0 0 0 0\n"
"InteractionEvent 222 167 0 0 0 0 0\n"
"MouseMoveEvent 217 165 0 0 0 0 0\n"
"RenderEvent 217 165 0 0 0 0 0\n"
"InteractionEvent 217 165 0 0 0 0 0\n"
"MouseMoveEvent 211 162 0 0 0 0 0\n"
"RenderEvent 211 162 0 0 0 0 0\n"
"InteractionEvent 211 162 0 0 0 0 0\n"
"MouseMoveEvent 207 160 0 0 0 0 0\n"
"RenderEvent 207 160 0 0 0 0 0\n"
"InteractionEvent 207 160 0 0 0 0 0\n"
"MouseMoveEvent 202 158 0 0 0 0 0\n"
"RenderEvent 202 158 0 0 0 0 0\n"
"InteractionEvent 202 158 0 0 0 0 0\n"
"MouseMoveEvent 198 156 0 0 0 0 0\n"
"RenderEvent 198 156 0 0 0 0 0\n"
"InteractionEvent 198 156 0 0 0 0 0\n"
"MouseMoveEvent 194 154 0 0 0 0 0\n"
"RenderEvent 194 154 0 0 0 0 0\n"
"InteractionEvent 194 154 0 0 0 0 0\n"
"MouseMoveEvent 191 153 0 0 0 0 0\n"
"RenderEvent 191 153 0 0 0 0 0\n"
"InteractionEvent 191 153 0 0 0 0 0\n"
"MouseMoveEvent 188 150 0 0 0 0 0\n"
"RenderEvent 188 150 0 0 0 0 0\n"
"InteractionEvent 188 150 0 0 0 0 0\n"
"MouseMoveEvent 185 148 0 0 0 0 0\n"
"RenderEvent 185 148 0 0 0 0 0\n"
"InteractionEvent 185 148 0 0 0 0 0\n"
"MouseMoveEvent 183 147 0 0 0 0 0\n"
"RenderEvent 183 147 0 0 0 0 0\n"
"InteractionEvent 183 147 0 0 0 0 0\n"
"MouseMoveEvent 181 145 0 0 0 0 0\n"
"RenderEvent 181 145 0 0 0 0 0\n"
"InteractionEvent 181 145 0 0 0 0 0\n"
"MouseMoveEvent 176 143 0 0 0 0 0\n"
"RenderEvent 176 143 0 0 0 0 0\n"
"InteractionEvent 176 143 0 0 0 0 0\n"
"MouseMoveEvent 173 141 0 0 0 0 0\n"
"RenderEvent 173 141 0 0 0 0 0\n"
"InteractionEvent 173 141 0 0 0 0 0\n"
"MouseMoveEvent 170 140 0 0 0 0 0\n"
"RenderEvent 170 140 0 0 0 0 0\n"
"InteractionEvent 170 140 0 0 0 0 0\n"
"MouseMoveEvent 165 137 0 0 0 0 0\n"
"RenderEvent 165 137 0 0 0 0 0\n"
"InteractionEvent 165 137 0 0 0 0 0\n"
"MouseMoveEvent 161 136 0 0 0 0 0\n"
"RenderEvent 161 136 0 0 0 0 0\n"
"InteractionEvent 161 136 0 0 0 0 0\n"
"MouseMoveEvent 157 134 0 0 0 0 0\n"
"RenderEvent 157 134 0 0 0 0 0\n"
"InteractionEvent 157 134 0 0 0 0 0\n"
"MouseMoveEvent 155 133 0 0 0 0 0\n"
"RenderEvent 155 133 0 0 0 0 0\n"
"InteractionEvent 155 133 0 0 0 0 0\n"
"MouseMoveEvent 153 133 0 0 0 0 0\n"
"RenderEvent 153 133 0 0 0 0 0\n"
"InteractionEvent 153 133 0 0 0 0 0\n"
"MouseMoveEvent 152 132 0 0 0 0 0\n"
"RenderEvent 152 132 0 0 0 0 0\n"
"InteractionEvent 152 132 0 0 0 0 0\n"
"MouseMoveEvent 151 132 0 0 0 0 0\n"
"RenderEvent 151 132 0 0 0 0 0\n"
"InteractionEvent 151 132 0 0 0 0 0\n"
"MouseMoveEvent 148 131 0 0 0 0 0\n"
"RenderEvent 148 131 0 0 0 0 0\n"
"InteractionEvent 148 131 0 0 0 0 0\n"
"MouseMoveEvent 146 131 0 0 0 0 0\n"
"RenderEvent 146 131 0 0 0 0 0\n"
"InteractionEvent 146 131 0 0 0 0 0\n"
"MouseMoveEvent 142 129 0 0 0 0 0\n"
"RenderEvent 142 129 0 0 0 0 0\n"
"InteractionEvent 142 129 0 0 0 0 0\n"
"MouseMoveEvent 140 128 0 0 0 0 0\n"
"RenderEvent 140 128 0 0 0 0 0\n"
"InteractionEvent 140 128 0 0 0 0 0\n"
"MouseMoveEvent 136 127 0 0 0 0 0\n"
"RenderEvent 136 127 0 0 0 0 0\n"
"InteractionEvent 136 127 0 0 0 0 0\n"
"MouseMoveEvent 134 126 0 0 0 0 0\n"
"RenderEvent 134 126 0 0 0 0 0\n"
"InteractionEvent 134 126 0 0 0 0 0\n"
"MouseMoveEvent 132 125 0 0 0 0 0\n"
"RenderEvent 132 125 0 0 0 0 0\n"
"InteractionEvent 132 125 0 0 0 0 0\n"
"MouseMoveEvent 130 124 0 0 0 0 0\n"
"RenderEvent 130 124 0 0 0 0 0\n"
"InteractionEvent 130 124 0 0 0 0 0\n"
"MouseMoveEvent 129 123 0 0 0 0 0\n"
"RenderEvent 129 123 0 0 0 0 0\n"
"InteractionEvent 129 123 0 0 0 0 0\n"
"MouseMoveEvent 128 123 0 0 0 0 0\n"
"RenderEvent 128 123 0 0 0 0 0\n"
"InteractionEvent 128 123 0 0 0 0 0\n"
"MouseMoveEvent 127 122 0 0 0 0 0\n"
"RenderEvent 127 122 0 0 0 0 0\n"
"InteractionEvent 127 122 0 0 0 0 0\n"
"MouseMoveEvent 126 121 0 0 0 0 0\n"
"RenderEvent 126 121 0 0 0 0 0\n"
"InteractionEvent 126 121 0 0 0 0 0\n"
"MouseMoveEvent 125 121 0 0 0 0 0\n"
"RenderEvent 125 121 0 0 0 0 0\n"
"InteractionEvent 125 121 0 0 0 0 0\n"
"MouseMoveEvent 124 120 0 0 0 0 0\n"
"RenderEvent 124 120 0 0 0 0 0\n"
"InteractionEvent 124 120 0 0 0 0 0\n"
"MouseMoveEvent 123 120 0 0 0 0 0\n"
"RenderEvent 123 120 0 0 0 0 0\n"
"InteractionEvent 123 120 0 0 0 0 0\n"
"MouseMoveEvent 123 119 0 0 0 0 0\n"
"RenderEvent 123 119 0 0 0 0 0\n"
"InteractionEvent 123 119 0 0 0 0 0\n"
"MouseMoveEvent 122 119 0 0 0 0 0\n"
"RenderEvent 122 119 0 0 0 0 0\n"
"InteractionEvent 122 119 0 0 0 0 0\n"
"MouseMoveEvent 121 118 0 0 0 0 0\n"
"RenderEvent 121 118 0 0 0 0 0\n"
"InteractionEvent 121 118 0 0 0 0 0\n"
"MouseMoveEvent 121 118 0 0 0 0 0\n"
"RenderEvent 121 118 0 0 0 0 0\n"
"InteractionEvent 121 118 0 0 0 0 0\n"
"MouseMoveEvent 120 117 0 0 0 0 0\n"
"RenderEvent 120 117 0 0 0 0 0\n"
"InteractionEvent 120 117 0 0 0 0 0\n"
"MouseMoveEvent 119 117 0 0 0 0 0\n"
"RenderEvent 119 117 0 0 0 0 0\n"
"InteractionEvent 119 117 0 0 0 0 0\n"
"MouseMoveEvent 118 116 0 0 0 0 0\n"
"RenderEvent 118 116 0 0 0 0 0\n"
"InteractionEvent 118 116 0 0 0 0 0\n"
"MouseMoveEvent 117 115 0 0 0 0 0\n"
"RenderEvent 117 115 0 0 0 0 0\n"
"InteractionEvent 117 115 0 0 0 0 0\n"
"MouseMoveEvent 116 115 0 0 0 0 0\n"
"RenderEvent 116 115 0 0 0 0 0\n"
"InteractionEvent 116 115 0 0 0 0 0\n"
"MouseMoveEvent 115 115 0 0 0 0 0\n"
"RenderEvent 115 115 0 0 0 0 0\n"
"InteractionEvent 115 115 0 0 0 0 0\n"
"MouseMoveEvent 115 114 0 0 0 0 0\n"
"RenderEvent 115 114 0 0 0 0 0\n"
"InteractionEvent 115 114 0 0 0 0 0\n"
"MouseMoveEvent 114 114 0 0 0 0 0\n"
"RenderEvent 114 114 0 0 0 0 0\n"
"InteractionEvent 114 114 0 0 0 0 0\n"
"MouseMoveEvent 114 113 0 0 0 0 0\n"
"RenderEvent 114 113 0 0 0 0 0\n"
"InteractionEvent 114 113 0 0 0 0 0\n"
"MouseMoveEvent 114 112 0 0 0 0 0\n"
"RenderEvent 114 112 0 0 0 0 0\n"
"InteractionEvent 114 112 0 0 0 0 0\n"
"MouseMoveEvent 114 111 0 0 0 0 0\n"
"RenderEvent 114 111 0 0 0 0 0\n"
"InteractionEvent 114 111 0 0 0 0 0\n"
"MouseMoveEvent 114 110 0 0 0 0 0\n"
"RenderEvent 114 110 0 0 0 0 0\n"
"InteractionEvent 114 110 0 0 0 0 0\n"
"MouseMoveEvent 115 110 0 0 0 0 0\n"
"RenderEvent 115 110 0 0 0 0 0\n"
"InteractionEvent 115 110 0 0 0 0 0\n"
"MouseMoveEvent 116 110 0 0 0 0 0\n"
"RenderEvent 116 110 0 0 0 0 0\n"
"InteractionEvent 116 110 0 0 0 0 0\n"
"MouseMoveEvent 117 110 0 0 0 0 0\n"
"RenderEvent 117 110 0 0 0 0 0\n"
"InteractionEvent 117 110 0 0 0 0 0\n"
"MouseMoveEvent 117 110 0 0 0 0 0\n"
"RenderEvent 117 110 0 0 0 0 0\n"
"InteractionEvent 117 110 0 0 0 0 0\n"
"LeftButtonReleaseEvent 117 110 0 0 0 0 0\n"
"EndInteractionEvent 117 110 0 0 0 0 0\n"
"RenderEvent 117 110 0 0 0 0 0\n"
"MouseMoveEvent 117 110 0 0 0 0 0\n"
"MouseMoveEvent 118 110 0 0 0 0 0\n"
"MouseMoveEvent 120 111 0 0 0 0 0\n"
"MouseMoveEvent 123 113 0 0 0 0 0\n"
"MouseMoveEvent 125 114 0 0 0 0 0\n"
"MouseMoveEvent 130 117 0 0 0 0 0\n"
"MouseMoveEvent 134 120 0 0 0 0 0\n"
"MouseMoveEvent 142 123 0 0 0 0 0\n"
"MouseMoveEvent 149 126 0 0 0 0 0\n"
"MouseMoveEvent 159 130 0 0 0 0 0\n"
"MouseMoveEvent 166 132 0 0 0 0 0\n"
"MouseMoveEvent 174 133 0 0 0 0 0\n"
"MouseMoveEvent 184 134 0 0 0 0 0\n"
"MouseMoveEvent 192 135 0 0 0 0 0\n"
"MouseMoveEvent 202 137 0 0 0 0 0\n"
"MouseMoveEvent 211 138 0 0 0 0 0\n"
"MouseMoveEvent 216 139 0 0 0 0 0\n"
"MouseMoveEvent 222 140 0 0 0 0 0\n"
"MouseMoveEvent 225 140 0 0 0 0 0\n"
"MouseMoveEvent 227 140 0 0 0 0 0\n"
"MouseMoveEvent 230 141 0 0 0 0 0\n"
"RightButtonPressEvent 230 141 0 0 0 0 0\n"
"StartInteractionEvent 230 141 0 0 0 0 0\n"
"MouseMoveEvent 231 142 0 0 0 0 0\n"
"RenderEvent 231 142 0 0 0 0 0\n"
"InteractionEvent 231 142 0 0 0 0 0\n"
"MouseMoveEvent 231 144 0 0 0 0 0\n"
"RenderEvent 231 144 0 0 0 0 0\n"
"InteractionEvent 231 144 0 0 0 0 0\n"
"MouseMoveEvent 231 147 0 0 0 0 0\n"
"RenderEvent 231 147 0 0 0 0 0\n"
"InteractionEvent 231 147 0 0 0 0 0\n"
"MouseMoveEvent 231 148 0 0 0 0 0\n"
"RenderEvent 231 148 0 0 0 0 0\n"
"InteractionEvent 231 148 0 0 0 0 0\n"
"MouseMoveEvent 231 151 0 0 0 0 0\n"
"RenderEvent 231 151 0 0 0 0 0\n"
"InteractionEvent 231 151 0 0 0 0 0\n"
"MouseMoveEvent 231 157 0 0 0 0 0\n"
"RenderEvent 231 157 0 0 0 0 0\n"
"InteractionEvent 231 157 0 0 0 0 0\n"
"MouseMoveEvent 229 162 0 0 0 0 0\n"
"RenderEvent 229 162 0 0 0 0 0\n"
"InteractionEvent 229 162 0 0 0 0 0\n"
"MouseMoveEvent 227 168 0 0 0 0 0\n"
"RenderEvent 227 168 0 0 0 0 0\n"
"InteractionEvent 227 168 0 0 0 0 0\n"
"MouseMoveEvent 225 175 0 0 0 0 0\n"
"RenderEvent 225 175 0 0 0 0 0\n"
"InteractionEvent 225 175 0 0 0 0 0\n"
"MouseMoveEvent 222 184 0 0 0 0 0\n"
"RenderEvent 222 184 0 0 0 0 0\n"
"InteractionEvent 222 184 0 0 0 0 0\n"
"MouseMoveEvent 221 188 0 0 0 0 0\n"
"RenderEvent 221 188 0 0 0 0 0\n"
"InteractionEvent 221 188 0 0 0 0 0\n"
"MouseMoveEvent 220 192 0 0 0 0 0\n"
"RenderEvent 220 192 0 0 0 0 0\n"
"InteractionEvent 220 192 0 0 0 0 0\n"
"MouseMoveEvent 219 195 0 0 0 0 0\n"
"RenderEvent 219 195 0 0 0 0 0\n"
"InteractionEvent 219 195 0 0 0 0 0\n"
"MouseMoveEvent 219 197 0 0 0 0 0\n"
"RenderEvent 219 197 0 0 0 0 0\n"
"InteractionEvent 219 197 0 0 0 0 0\n"
"MouseMoveEvent 219 199 0 0 0 0 0\n"
"RenderEvent 219 199 0 0 0 0 0\n"
"InteractionEvent 219 199 0 0 0 0 0\n"
"MouseMoveEvent 219 201 0 0 0 0 0\n"
"RenderEvent 219 201 0 0 0 0 0\n"
"InteractionEvent 219 201 0 0 0 0 0\n"
"MouseMoveEvent 218 204 0 0 0 0 0\n"
"RenderEvent 218 204 0 0 0 0 0\n"
"InteractionEvent 218 204 0 0 0 0 0\n"
"MouseMoveEvent 217 207 0 0 0 0 0\n"
"RenderEvent 217 207 0 0 0 0 0\n"
"InteractionEvent 217 207 0 0 0 0 0\n"
"MouseMoveEvent 217 211 0 0 0 0 0\n"
"RenderEvent 217 211 0 0 0 0 0\n"
"InteractionEvent 217 211 0 0 0 0 0\n"
"MouseMoveEvent 216 216 0 0 0 0 0\n"
"RenderEvent 216 216 0 0 0 0 0\n"
"InteractionEvent 216 216 0 0 0 0 0\n"
"MouseMoveEvent 213 223 0 0 0 0 0\n"
"RenderEvent 213 223 0 0 0 0 0\n"
"InteractionEvent 213 223 0 0 0 0 0\n"
"MouseMoveEvent 211 230 0 0 0 0 0\n"
"RenderEvent 211 230 0 0 0 0 0\n"
"InteractionEvent 211 230 0 0 0 0 0\n"
"MouseMoveEvent 209 234 0 0 0 0 0\n"
"RenderEvent 209 234 0 0 0 0 0\n"
"InteractionEvent 209 234 0 0 0 0 0\n"
"MouseMoveEvent 208 238 0 0 0 0 0\n"
"RenderEvent 208 238 0 0 0 0 0\n"
"InteractionEvent 208 238 0 0 0 0 0\n"
"MouseMoveEvent 207 240 0 0 0 0 0\n"
"RenderEvent 207 240 0 0 0 0 0\n"
"InteractionEvent 207 240 0 0 0 0 0\n"
"MouseMoveEvent 207 242 0 0 0 0 0\n"
"RenderEvent 207 242 0 0 0 0 0\n"
"InteractionEvent 207 242 0 0 0 0 0\n"
"MouseMoveEvent 207 244 0 0 0 0 0\n"
"RenderEvent 207 244 0 0 0 0 0\n"
"InteractionEvent 207 244 0 0 0 0 0\n"
"MouseMoveEvent 206 245 0 0 0 0 0\n"
"RenderEvent 206 245 0 0 0 0 0\n"
"InteractionEvent 206 245 0 0 0 0 0\n"
"MouseMoveEvent 205 247 0 0 0 0 0\n"
"RenderEvent 205 247 0 0 0 0 0\n"
"InteractionEvent 205 247 0 0 0 0 0\n"
"MouseMoveEvent 204 249 0 0 0 0 0\n"
"RenderEvent 204 249 0 0 0 0 0\n"
"InteractionEvent 204 249 0 0 0 0 0\n"
"MouseMoveEvent 204 250 0 0 0 0 0\n"
"RenderEvent 204 250 0 0 0 0 0\n"
"InteractionEvent 204 250 0 0 0 0 0\n"
"MouseMoveEvent 203 252 0 0 0 0 0\n"
"RenderEvent 203 252 0 0 0 0 0\n"
"InteractionEvent 203 252 0 0 0 0 0\n"
"MouseMoveEvent 202 252 0 0 0 0 0\n"
"RenderEvent 202 252 0 0 0 0 0\n"
"InteractionEvent 202 252 0 0 0 0 0\n"
"RightButtonReleaseEvent 202 252 0 0 0 0 0\n"
"EndInteractionEvent 202 252 0 0 0 0 0\n"
"RenderEvent 202 252 0 0 0 0 0\n"
"MouseMoveEvent 202 252 0 0 0 0 0\n"
"MouseMoveEvent 200 252 0 0 0 0 0\n"
"MouseMoveEvent 199 252 0 0 0 0 0\n"
"MouseMoveEvent 198 251 0 0 0 0 0\n"
"MouseMoveEvent 194 251 0 0 0 0 0\n"
"MouseMoveEvent 192 249 0 0 0 0 0\n"
"MouseMoveEvent 190 248 0 0 0 0 0\n"
"MouseMoveEvent 187 245 0 0 0 0 0\n"
"MouseMoveEvent 185 244 0 0 0 0 0\n"
"MouseMoveEvent 183 243 0 0 0 0 0\n"
"MouseMoveEvent 181 242 0 0 0 0 0\n"
"MouseMoveEvent 180 242 0 0 0 0 0\n"
"MouseMoveEvent 180 241 0 0 0 0 0\n"
"MouseMoveEvent 178 240 0 0 0 0 0\n"
"MouseMoveEvent 177 239 0 0 0 0 0\n"
"MouseMoveEvent 175 237 0 0 0 0 0\n"
"MouseMoveEvent 174 237 0 0 0 0 0\n"
"MouseMoveEvent 173 236 0 0 0 0 0\n"
"MouseMoveEvent 172 235 0 0 0 0 0\n"
"MouseMoveEvent 171 234 0 0 0 0 0\n"
"MouseMoveEvent 170 233 0 0 0 0 0\n"
"MouseMoveEvent 169 232 0 0 0 0 0\n"
"MouseMoveEvent 168 231 0 0 0 0 0\n"
"MouseMoveEvent 167 230 0 0 0 0 0\n"
"MouseMoveEvent 166 229 0 0 0 0 0\n"
"MouseMoveEvent 166 227 0 0 0 0 0\n"
"MouseMoveEvent 166 226 0 0 0 0 0\n"
"MouseMoveEvent 166 225 0 0 0 0 0\n"
"LeftButtonPressEvent 166 225 0 0 0 0 0\n"
"StartInteractionEvent 166 225 0 0 0 0 0\n"
"MouseMoveEvent 166 224 0 0 0 0 0\n"
"RenderEvent 166 224 0 0 0 0 0\n"
"InteractionEvent 166 224 0 0 0 0 0\n"
"MouseMoveEvent 166 223 0 0 0 0 0\n"
"RenderEvent 166 223 0 0 0 0 0\n"
"InteractionEvent 166 223 0 0 0 0 0\n"
"MouseMoveEvent 166 222 0 0 0 0 0\n"
"RenderEvent 166 222 0 0 0 0 0\n"
"InteractionEvent 166 222 0 0 0 0 0\n"
"MouseMoveEvent 166 222 0 0 0 0 0\n"
"RenderEvent 166 222 0 0 0 0 0\n"
"InteractionEvent 166 222 0 0 0 0 0\n"
"MouseMoveEvent 166 221 0 0 0 0 0\n"
"RenderEvent 166 221 0 0 0 0 0\n"
"InteractionEvent 166 221 0 0 0 0 0\n"
"MouseMoveEvent 166 220 0 0 0 0 0\n"
"RenderEvent 166 220 0 0 0 0 0\n"
"InteractionEvent 166 220 0 0 0 0 0\n"
"MouseMoveEvent 166 219 0 0 0 0 0\n"
"RenderEvent 166 219 0 0 0 0 0\n"
"InteractionEvent 166 219 0 0 0 0 0\n"
"MouseMoveEvent 166 218 0 0 0 0 0\n"
"RenderEvent 166 218 0 0 0 0 0\n"
"InteractionEvent 166 218 0 0 0 0 0\n"
"MouseMoveEvent 166 217 0 0 0 0 0\n"
"RenderEvent 166 217 0 0 0 0 0\n"
"InteractionEvent 166 217 0 0 0 0 0\n"
"MouseMoveEvent 165 216 0 0 0 0 0\n"
"RenderEvent 165 216 0 0 0 0 0\n"
"InteractionEvent 165 216 0 0 0 0 0\n"
"MouseMoveEvent 165 215 0 0 0 0 0\n"
"RenderEvent 165 215 0 0 0 0 0\n"
"InteractionEvent 165 215 0 0 0 0 0\n"
"MouseMoveEvent 165 214 0 0 0 0 0\n"
"RenderEvent 165 214 0 0 0 0 0\n"
"InteractionEvent 165 214 0 0 0 0 0\n"
"MouseMoveEvent 165 213 0 0 0 0 0\n"
"RenderEvent 165 213 0 0 0 0 0\n"
"InteractionEvent 165 213 0 0 0 0 0\n"
"MouseMoveEvent 165 212 0 0 0 0 0\n"
"RenderEvent 165 212 0 0 0 0 0\n"
"InteractionEvent 165 212 0 0 0 0 0\n"
"MouseMoveEvent 165 211 0 0 0 0 0\n"
"RenderEvent 165 211 0 0 0 0 0\n"
"InteractionEvent 165 211 0 0 0 0 0\n"
"MouseMoveEvent 166 211 0 0 0 0 0\n"
"RenderEvent 166 211 0 0 0 0 0\n"
"InteractionEvent 166 211 0 0 0 0 0\n"
"MouseMoveEvent 167 211 0 0 0 0 0\n"
"RenderEvent 167 211 0 0 0 0 0\n"
"InteractionEvent 167 211 0 0 0 0 0\n"
"MouseMoveEvent 168 211 0 0 0 0 0\n"
"RenderEvent 168 211 0 0 0 0 0\n"
"InteractionEvent 168 211 0 0 0 0 0\n"
"MouseMoveEvent 169 211 0 0 0 0 0\n"
"RenderEvent 169 211 0 0 0 0 0\n"
"InteractionEvent 169 211 0 0 0 0 0\n"
"MouseMoveEvent 170 211 0 0 0 0 0\n"
"RenderEvent 170 211 0 0 0 0 0\n"
"InteractionEvent 170 211 0 0 0 0 0\n"
"MouseMoveEvent 171 211 0 0 0 0 0\n"
"RenderEvent 171 211 0 0 0 0 0\n"
"InteractionEvent 171 211 0 0 0 0 0\n"
"MouseMoveEvent 171 210 0 0 0 0 0\n"
"RenderEvent 171 210 0 0 0 0 0\n"
"InteractionEvent 171 210 0 0 0 0 0\n"
"MouseMoveEvent 171 210 0 0 0 0 0\n"
"RenderEvent 171 210 0 0 0 0 0\n"
"InteractionEvent 171 210 0 0 0 0 0\n"
"MouseMoveEvent 172 210 0 0 0 0 0\n"
"RenderEvent 172 210 0 0 0 0 0\n"
"InteractionEvent 172 210 0 0 0 0 0\n"
"MouseMoveEvent 172 210 0 0 0 0 0\n"
"RenderEvent 172 210 0 0 0 0 0\n"
"InteractionEvent 172 210 0 0 0 0 0\n"
"MouseMoveEvent 172 210 0 0 0 0 0\n"
"RenderEvent 172 210 0 0 0 0 0\n"
"InteractionEvent 172 210 0 0 0 0 0\n"
"MouseMoveEvent 172 210 0 0 0 0 0\n"
"RenderEvent 172 210 0 0 0 0 0\n"
"InteractionEvent 172 210 0 0 0 0 0\n"
"LeftButtonReleaseEvent 172 210 0 0 0 0 0\n"
"EndInteractionEvent 172 210 0 0 0 0 0\n"
"RenderEvent 172 210 0 0 0 0 0\n"
"MouseMoveEvent 172 210 0 0 0 0 0\n"
"MouseMoveEvent 172 208 0 0 0 0 0\n"
"MouseMoveEvent 174 205 0 0 0 0 0\n"
"MouseMoveEvent 174 204 0 0 0 0 0\n"
"MouseMoveEvent 175 203 0 0 0 0 0\n"
"MouseMoveEvent 176 201 0 0 0 0 0\n"
"MouseMoveEvent 176 200 0 0 0 0 0\n"
"MouseMoveEvent 176 199 0 0 0 0 0\n"
"MouseMoveEvent 177 198 0 0 0 0 0\n"
"RightButtonPressEvent 177 198 0 0 0 0 0\n"
"StartInteractionEvent 177 198 0 0 0 0 0\n"
"MouseMoveEvent 177 196 0 0 0 0 0\n"
"RenderEvent 177 196 0 0 0 0 0\n"
"InteractionEvent 177 196 0 0 0 0 0\n"
"MouseMoveEvent 177 194 0 0 0 0 0\n"
"RenderEvent 177 194 0 0 0 0 0\n"
"InteractionEvent 177 194 0 0 0 0 0\n"
"MouseMoveEvent 177 193 0 0 0 0 0\n"
"RenderEvent 177 193 0 0 0 0 0\n"
"InteractionEvent 177 193 0 0 0 0 0\n"
"MouseMoveEvent 177 191 0 0 0 0 0\n"
"RenderEvent 177 191 0 0 0 0 0\n"
"InteractionEvent 177 191 0 0 0 0 0\n"
"MouseMoveEvent 177 188 0 0 0 0 0\n"
"RenderEvent 177 188 0 0 0 0 0\n"
"InteractionEvent 177 188 0 0 0 0 0\n"
"MouseMoveEvent 177 186 0 0 0 0 0\n"
"RenderEvent 177 186 0 0 0 0 0\n"
"InteractionEvent 177 186 0 0 0 0 0\n"
"MouseMoveEvent 177 183 0 0 0 0 0\n"
"RenderEvent 177 183 0 0 0 0 0\n"
"InteractionEvent 177 183 0 0 0 0 0\n"
"MouseMoveEvent 177 182 0 0 0 0 0\n"
"RenderEvent 177 182 0 0 0 0 0\n"
"InteractionEvent 177 182 0 0 0 0 0\n"
"MouseMoveEvent 177 180 0 0 0 0 0\n"
"RenderEvent 177 180 0 0 0 0 0\n"
"InteractionEvent 177 180 0 0 0 0 0\n"
"MouseMoveEvent 178 177 0 0 0 0 0\n"
"RenderEvent 178 177 0 0 0 0 0\n"
"InteractionEvent 178 177 0 0 0 0 0\n"
"MouseMoveEvent 178 173 0 0 0 0 0\n"
"RenderEvent 178 173 0 0 0 0 0\n"
"InteractionEvent 178 173 0 0 0 0 0\n"
"MouseMoveEvent 178 170 0 0 0 0 0\n"
"RenderEvent 178 170 0 0 0 0 0\n"
"InteractionEvent 178 170 0 0 0 0 0\n"
"MouseMoveEvent 178 167 0 0 0 0 0\n"
"RenderEvent 178 167 0 0 0 0 0\n"
"InteractionEvent 178 167 0 0 0 0 0\n"
"MouseMoveEvent 178 165 0 0 0 0 0\n"
"RenderEvent 178 165 0 0 0 0 0\n"
"InteractionEvent 178 165 0 0 0 0 0\n"
"MouseMoveEvent 178 164 0 0 0 0 0\n"
"RenderEvent 178 164 0 0 0 0 0\n"
"InteractionEvent 178 164 0 0 0 0 0\n"
"MouseMoveEvent 178 162 0 0 0 0 0\n"
"RenderEvent 178 162 0 0 0 0 0\n"
"InteractionEvent 178 162 0 0 0 0 0\n"
"MouseMoveEvent 178 161 0 0 0 0 0\n"
"RenderEvent 178 161 0 0 0 0 0\n"
"InteractionEvent 178 161 0 0 0 0 0\n"
"MouseMoveEvent 178 158 0 0 0 0 0\n"
"RenderEvent 178 158 0 0 0 0 0\n"
"InteractionEvent 178 158 0 0 0 0 0\n"
"MouseMoveEvent 178 153 0 0 0 0 0\n"
"RenderEvent 178 153 0 0 0 0 0\n"
"InteractionEvent 178 153 0 0 0 0 0\n"
"MouseMoveEvent 178 151 0 0 0 0 0\n"
"RenderEvent 178 151 0 0 0 0 0\n"
"InteractionEvent 178 151 0 0 0 0 0\n"
"MouseMoveEvent 179 149 0 0 0 0 0\n"
"RenderEvent 179 149 0 0 0 0 0\n"
"InteractionEvent 179 149 0 0 0 0 0\n"
"MouseMoveEvent 179 148 0 0 0 0 0\n"
"RenderEvent 179 148 0 0 0 0 0\n"
"InteractionEvent 179 148 0 0 0 0 0\n"
"MouseMoveEvent 179 147 0 0 0 0 0\n"
"RenderEvent 179 147 0 0 0 0 0\n"
"InteractionEvent 179 147 0 0 0 0 0\n"
"MouseMoveEvent 180 146 0 0 0 0 0\n"
"RenderEvent 180 146 0 0 0 0 0\n"
"InteractionEvent 180 146 0 0 0 0 0\n"
"MouseMoveEvent 180 145 0 0 0 0 0\n"
"RenderEvent 180 145 0 0 0 0 0\n"
"InteractionEvent 180 145 0 0 0 0 0\n"
"MouseMoveEvent 180 144 0 0 0 0 0\n"
"RenderEvent 180 144 0 0 0 0 0\n"
"InteractionEvent 180 144 0 0 0 0 0\n"
"MouseMoveEvent 180 142 0 0 0 0 0\n"
"RenderEvent 180 142 0 0 0 0 0\n"
"InteractionEvent 180 142 0 0 0 0 0\n"
"MouseMoveEvent 180 141 0 0 0 0 0\n"
"RenderEvent 180 141 0 0 0 0 0\n"
"InteractionEvent 180 141 0 0 0 0 0\n"
"MouseMoveEvent 180 140 0 0 0 0 0\n"
"RenderEvent 180 140 0 0 0 0 0\n"
"InteractionEvent 180 140 0 0 0 0 0\n"
"MouseMoveEvent 180 139 0 0 0 0 0\n"
"RenderEvent 180 139 0 0 0 0 0\n"
"InteractionEvent 180 139 0 0 0 0 0\n"
"MouseMoveEvent 181 139 0 0 0 0 0\n"
"RenderEvent 181 139 0 0 0 0 0\n"
"InteractionEvent 181 139 0 0 0 0 0\n"
"MouseMoveEvent 180 139 0 0 0 0 0\n"
"RenderEvent 180 139 0 0 0 0 0\n"
"InteractionEvent 180 139 0 0 0 0 0\n"
"MouseMoveEvent 179 140 0 0 0 0 0\n"
"RenderEvent 179 140 0 0 0 0 0\n"
"InteractionEvent 179 140 0 0 0 0 0\n"
"MouseMoveEvent 178 141 0 0 0 0 0\n"
"RenderEvent 178 141 0 0 0 0 0\n"
"InteractionEvent 178 141 0 0 0 0 0\n"
"MouseMoveEvent 178 143 0 0 0 0 0\n"
"RenderEvent 178 143 0 0 0 0 0\n"
"InteractionEvent 178 143 0 0 0 0 0\n"
"MouseMoveEvent 178 144 0 0 0 0 0\n"
"RenderEvent 178 144 0 0 0 0 0\n"
"InteractionEvent 178 144 0 0 0 0 0\n"
"MouseMoveEvent 177 144 0 0 0 0 0\n"
"RenderEvent 177 144 0 0 0 0 0\n"
"InteractionEvent 177 144 0 0 0 0 0\n"
"MouseMoveEvent 176 146 0 0 0 0 0\n"
"RenderEvent 176 146 0 0 0 0 0\n"
"InteractionEvent 176 146 0 0 0 0 0\n"
"MouseMoveEvent 176 146 0 0 0 0 0\n"
"RenderEvent 176 146 0 0 0 0 0\n"
"InteractionEvent 176 146 0 0 0 0 0\n"
"MouseMoveEvent 174 150 0 0 0 0 0\n"
"RenderEvent 174 150 0 0 0 0 0\n"
"InteractionEvent 174 150 0 0 0 0 0\n"
"MouseMoveEvent 172 158 0 0 0 0 0\n"
"RenderEvent 172 158 0 0 0 0 0\n"
"InteractionEvent 172 158 0 0 0 0 0\n"
"MouseMoveEvent 170 163 0 0 0 0 0\n"
"RenderEvent 170 163 0 0 0 0 0\n"
"InteractionEvent 170 163 0 0 0 0 0\n"
"MouseMoveEvent 170 168 0 0 0 0 0\n"
"RenderEvent 170 168 0 0 0 0 0\n"
"InteractionEvent 170 168 0 0 0 0 0\n"
"MouseMoveEvent 167 171 0 0 0 0 0\n"
"RenderEvent 167 171 0 0 0 0 0\n"
"InteractionEvent 167 171 0 0 0 0 0\n"
"MouseMoveEvent 167 176 0 0 0 0 0\n"
"RenderEvent 167 176 0 0 0 0 0\n"
"InteractionEvent 167 176 0 0 0 0 0\n"
"MouseMoveEvent 165 180 0 0 0 0 0\n"
"RenderEvent 165 180 0 0 0 0 0\n"
"InteractionEvent 165 180 0 0 0 0 0\n"
"MouseMoveEvent 164 183 0 0 0 0 0\n"
"RenderEvent 164 183 0 0 0 0 0\n"
"InteractionEvent 164 183 0 0 0 0 0\n"
"MouseMoveEvent 164 185 0 0 0 0 0\n"
"RenderEvent 164 185 0 0 0 0 0\n"
"InteractionEvent 164 185 0 0 0 0 0\n"
"MouseMoveEvent 163 187 0 0 0 0 0\n"
"RenderEvent 163 187 0 0 0 0 0\n"
"InteractionEvent 163 187 0 0 0 0 0\n"
"MouseMoveEvent 163 189 0 0 0 0 0\n"
"RenderEvent 163 189 0 0 0 0 0\n"
"InteractionEvent 163 189 0 0 0 0 0\n"
"MouseMoveEvent 162 191 0 0 0 0 0\n"
"RenderEvent 162 191 0 0 0 0 0\n"
"InteractionEvent 162 191 0 0 0 0 0\n"
"MouseMoveEvent 161 195 0 0 0 0 0\n"
"RenderEvent 161 195 0 0 0 0 0\n"
"InteractionEvent 161 195 0 0 0 0 0\n"
"MouseMoveEvent 160 198 0 0 0 0 0\n"
"RenderEvent 160 198 0 0 0 0 0\n"
"InteractionEvent 160 198 0 0 0 0 0\n"
"MouseMoveEvent 160 201 0 0 0 0 0\n"
"RenderEvent 160 201 0 0 0 0 0\n"
"InteractionEvent 160 201 0 0 0 0 0\n"
"MouseMoveEvent 159 205 0 0 0 0 0\n"
"RenderEvent 159 205 0 0 0 0 0\n"
"InteractionEvent 159 205 0 0 0 0 0\n"
"MouseMoveEvent 158 211 0 0 0 0 0\n"
"RenderEvent 158 211 0 0 0 0 0\n"
"InteractionEvent 158 211 0 0 0 0 0\n"
"MouseMoveEvent 158 214 0 0 0 0 0\n"
"RenderEvent 158 214 0 0 0 0 0\n"
"InteractionEvent 158 214 0 0 0 0 0\n"
"MouseMoveEvent 157 216 0 0 0 0 0\n"
"RenderEvent 157 216 0 0 0 0 0\n"
"InteractionEvent 157 216 0 0 0 0 0\n"
"MouseMoveEvent 157 218 0 0 0 0 0\n"
"RenderEvent 157 218 0 0 0 0 0\n"
"InteractionEvent 157 218 0 0 0 0 0\n"
"MouseMoveEvent 157 219 0 0 0 0 0\n"
"RenderEvent 157 219 0 0 0 0 0\n"
"InteractionEvent 157 219 0 0 0 0 0\n"
"MouseMoveEvent 157 222 0 0 0 0 0\n"
"RenderEvent 157 222 0 0 0 0 0\n"
"InteractionEvent 157 222 0 0 0 0 0\n"
"MouseMoveEvent 157 225 0 0 0 0 0\n"
"RenderEvent 157 225 0 0 0 0 0\n"
"InteractionEvent 157 225 0 0 0 0 0\n"
"MouseMoveEvent 157 227 0 0 0 0 0\n"
"RenderEvent 157 227 0 0 0 0 0\n"
"InteractionEvent 157 227 0 0 0 0 0\n"
"MouseMoveEvent 157 228 0 0 0 0 0\n"
"RenderEvent 157 228 0 0 0 0 0\n"
"InteractionEvent 157 228 0 0 0 0 0\n"
"MouseMoveEvent 157 231 0 0 0 0 0\n"
"RenderEvent 157 231 0 0 0 0 0\n"
"InteractionEvent 157 231 0 0 0 0 0\n"
"MouseMoveEvent 157 236 0 0 0 0 0\n"
"RenderEvent 157 236 0 0 0 0 0\n"
"InteractionEvent 157 236 0 0 0 0 0\n"
"MouseMoveEvent 157 239 0 0 0 0 0\n"
"RenderEvent 157 239 0 0 0 0 0\n"
"InteractionEvent 157 239 0 0 0 0 0\n"
"MouseMoveEvent 157 241 0 0 0 0 0\n"
"RenderEvent 157 241 0 0 0 0 0\n"
"InteractionEvent 157 241 0 0 0 0 0\n"
"MouseMoveEvent 157 243 0 0 0 0 0\n"
"RenderEvent 157 243 0 0 0 0 0\n"
"InteractionEvent 157 243 0 0 0 0 0\n"
"MouseMoveEvent 157 245 0 0 0 0 0\n"
"RenderEvent 157 245 0 0 0 0 0\n"
"InteractionEvent 157 245 0 0 0 0 0\n"
"MouseMoveEvent 157 246 0 0 0 0 0\n"
"RenderEvent 157 246 0 0 0 0 0\n"
"InteractionEvent 157 246 0 0 0 0 0\n"
"MouseMoveEvent 157 248 0 0 0 0 0\n"
"RenderEvent 157 248 0 0 0 0 0\n"
"InteractionEvent 157 248 0 0 0 0 0\n"
"MouseMoveEvent 157 249 0 0 0 0 0\n"
"RenderEvent 157 249 0 0 0 0 0\n"
"InteractionEvent 157 249 0 0 0 0 0\n"
"MouseMoveEvent 157 251 0 0 0 0 0\n"
"RenderEvent 157 251 0 0 0 0 0\n"
"InteractionEvent 157 251 0 0 0 0 0\n"
"MouseMoveEvent 157 253 0 0 0 0 0\n"
"RenderEvent 157 253 0 0 0 0 0\n"
"InteractionEvent 157 253 0 0 0 0 0\n"
"MouseMoveEvent 157 255 0 0 0 0 0\n"
"RenderEvent 157 255 0 0 0 0 0\n"
"InteractionEvent 157 255 0 0 0 0 0\n"
"MouseMoveEvent 156 258 0 0 0 0 0\n"
"RenderEvent 156 258 0 0 0 0 0\n"
"InteractionEvent 156 258 0 0 0 0 0\n"
"MouseMoveEvent 155 263 0 0 0 0 0\n"
"RenderEvent 155 263 0 0 0 0 0\n"
"InteractionEvent 155 263 0 0 0 0 0\n"
"MouseMoveEvent 155 265 0 0 0 0 0\n"
"RenderEvent 155 265 0 0 0 0 0\n"
"InteractionEvent 155 265 0 0 0 0 0\n"
"MouseMoveEvent 155 268 0 0 0 0 0\n"
"RenderEvent 155 268 0 0 0 0 0\n"
"InteractionEvent 155 268 0 0 0 0 0\n"
"MouseMoveEvent 155 270 0 0 0 0 0\n"
"RenderEvent 155 270 0 0 0 0 0\n"
"InteractionEvent 155 270 0 0 0 0 0\n"
"MouseMoveEvent 155 272 0 0 0 0 0\n"
"RenderEvent 155 272 0 0 0 0 0\n"
"InteractionEvent 155 272 0 0 0 0 0\n"
"MouseMoveEvent 155 275 0 0 0 0 0\n"
"RenderEvent 155 275 0 0 0 0 0\n"
"InteractionEvent 155 275 0 0 0 0 0\n"
"MouseMoveEvent 154 277 0 0 0 0 0\n"
"RenderEvent 154 277 0 0 0 0 0\n"
"InteractionEvent 154 277 0 0 0 0 0\n"
"MouseMoveEvent 154 279 0 0 0 0 0\n"
"RenderEvent 154 279 0 0 0 0 0\n"
"InteractionEvent 154 279 0 0 0 0 0\n"
"MouseMoveEvent 154 281 0 0 0 0 0\n"
"RenderEvent 154 281 0 0 0 0 0\n"
"InteractionEvent 154 281 0 0 0 0 0\n"
"MouseMoveEvent 153 283 0 0 0 0 0\n"
"RenderEvent 153 283 0 0 0 0 0\n"
"InteractionEvent 153 283 0 0 0 0 0\n"
"MouseMoveEvent 153 285 0 0 0 0 0\n"
"RenderEvent 153 285 0 0 0 0 0\n"
"InteractionEvent 153 285 0 0 0 0 0\n"
"MouseMoveEvent 153 289 0 0 0 0 0\n"
"RenderEvent 153 289 0 0 0 0 0\n"
"InteractionEvent 153 289 0 0 0 0 0\n"
"MouseMoveEvent 153 293 0 0 0 0 0\n"
"RenderEvent 153 293 0 0 0 0 0\n"
"InteractionEvent 153 293 0 0 0 0 0\n"
"MouseMoveEvent 153 295 0 0 0 0 0\n"
"RenderEvent 153 295 0 0 0 0 0\n"
"InteractionEvent 153 295 0 0 0 0 0\n"
"MouseMoveEvent 152 297 0 0 0 0 0\n"
"RenderEvent 152 297 0 0 0 0 0\n"
"InteractionEvent 152 297 0 0 0 0 0\n"
"MouseMoveEvent 152 298 0 0 0 0 0\n"
"RenderEvent 152 298 0 0 0 0 0\n"
"InteractionEvent 152 298 0 0 0 0 0\n"
"MouseMoveEvent 152 300 0 0 0 0 0\n"
"RenderEvent 152 300 0 0 0 0 0\n"
"InteractionEvent 152 300 0 0 0 0 0\n"
"MouseMoveEvent 152 301 0 0 0 0 0\n"
"RenderEvent 152 301 0 0 0 0 0\n"
"InteractionEvent 152 301 0 0 0 0 0\n"
"MouseMoveEvent 152 302 0 0 0 0 0\n"
"RenderEvent 152 302 0 0 0 0 0\n"
"InteractionEvent 152 302 0 0 0 0 0\n"
"MouseMoveEvent 151 302 0 0 0 0 0\n"
"RenderEvent 151 302 0 0 0 0 0\n"
"InteractionEvent 151 302 0 0 0 0 0\n"
"MouseMoveEvent 151 304 0 0 0 0 0\n"
"RenderEvent 151 304 0 0 0 0 0\n"
"InteractionEvent 151 304 0 0 0 0 0\n"
"MouseMoveEvent 151 305 0 0 0 0 0\n"
"RenderEvent 151 305 0 0 0 0 0\n"
"InteractionEvent 151 305 0 0 0 0 0\n"
"MouseMoveEvent 151 306 0 0 0 0 0\n"
"RenderEvent 151 306 0 0 0 0 0\n"
"InteractionEvent 151 306 0 0 0 0 0\n"
"MouseMoveEvent 151 306 0 0 0 0 0\n"
"RenderEvent 151 306 0 0 0 0 0\n"
"InteractionEvent 151 306 0 0 0 0 0\n"
"MouseMoveEvent 151 308 0 0 0 0 0\n"
"RenderEvent 151 308 0 0 0 0 0\n"
"InteractionEvent 151 308 0 0 0 0 0\n"
"MouseMoveEvent 151 310 0 0 0 0 0\n"
"RenderEvent 151 310 0 0 0 0 0\n"
"InteractionEvent 151 310 0 0 0 0 0\n"
"MouseMoveEvent 150 310 0 0 0 0 0\n"
"RenderEvent 150 310 0 0 0 0 0\n"
"InteractionEvent 150 310 0 0 0 0 0\n"
"RightButtonReleaseEvent 150 310 0 0 0 0 0\n"
"EndInteractionEvent 150 310 0 0 0 0 0\n"
"RenderEvent 150 310 0 0 0 0 0\n"
"LeaveEvent 150 310 0 0 0 0 0\n"
"EnterEvent 148 300 0 0 0 0 0\n"
"MouseMoveEvent 148 300 0 0 0 0 0\n"
"MouseMoveEvent 148 298 0 0 0 0 0\n"
"MouseMoveEvent 148 295 0 0 0 0 0\n"
"MouseMoveEvent 148 292 0 0 0 0 0\n"
"MouseMoveEvent 148 288 0 0 0 0 0\n"
"MouseMoveEvent 148 283 0 0 0 0 0\n"
"MouseMoveEvent 149 278 0 0 0 0 0\n"
"MouseMoveEvent 149 273 0 0 0 0 0\n"
"MouseMoveEvent 149 270 0 0 0 0 0\n"
"MouseMoveEvent 149 268 0 0 0 0 0\n"
"MouseMoveEvent 149 266 0 0 0 0 0\n"
"MouseMoveEvent 149 265 0 0 0 0 0\n"
"MouseMoveEvent 149 262 0 0 0 0 0\n"
"MouseMoveEvent 149 261 0 0 0 0 0\n"
"MouseMoveEvent 150 260 0 0 0 0 0\n"
"LeftButtonPressEvent 150 260 0 0 0 0 0\n"
"StartInteractionEvent 150 260 0 0 0 0 0\n"
"MouseMoveEvent 150 260 0 0 0 0 0\n"
"RenderEvent 150 260 0 0 0 0 0\n"
"InteractionEvent 150 260 0 0 0 0 0\n"
"MouseMoveEvent 150 259 0 0 0 0 0\n"
"RenderEvent 150 259 0 0 0 0 0\n"
"InteractionEvent 150 259 0 0 0 0 0\n"
"MouseMoveEvent 149 259 0 0 0 0 0\n"
"RenderEvent 149 259 0 0 0 0 0\n"
"InteractionEvent 149 259 0 0 0 0 0\n"
"MouseMoveEvent 149 259 0 0 0 0 0\n"
"RenderEvent 149 259 0 0 0 0 0\n"
"InteractionEvent 149 259 0 0 0 0 0\n"
"MouseMoveEvent 150 259 0 0 0 0 0\n"
"RenderEvent 150 259 0 0 0 0 0\n"
"InteractionEvent 150 259 0 0 0 0 0\n"
"MouseMoveEvent 151 259 0 0 0 0 0\n"
"RenderEvent 151 259 0 0 0 0 0\n"
"InteractionEvent 151 259 0 0 0 0 0\n"
"MouseMoveEvent 151 259 0 0 0 0 0\n"
"RenderEvent 151 259 0 0 0 0 0\n"
"InteractionEvent 151 259 0 0 0 0 0\n"
"MouseMoveEvent 151 258 0 0 0 0 0\n"
"RenderEvent 151 258 0 0 0 0 0\n"
"InteractionEvent 151 258 0 0 0 0 0\n"
"MouseMoveEvent 152 258 0 0 0 0 0\n"
"RenderEvent 152 258 0 0 0 0 0\n"
"InteractionEvent 152 258 0 0 0 0 0\n"
"MouseMoveEvent 152 257 0 0 0 0 0\n"
"RenderEvent 152 257 0 0 0 0 0\n"
"InteractionEvent 152 257 0 0 0 0 0\n"
"MouseMoveEvent 152 256 0 0 0 0 0\n"
"RenderEvent 152 256 0 0 0 0 0\n"
"InteractionEvent 152 256 0 0 0 0 0\n"
"MouseMoveEvent 152 255 0 0 0 0 0\n"
"RenderEvent 152 255 0 0 0 0 0\n"
"InteractionEvent 152 255 0 0 0 0 0\n"
"MouseMoveEvent 152 254 0 0 0 0 0\n"
"RenderEvent 152 254 0 0 0 0 0\n"
"InteractionEvent 152 254 0 0 0 0 0\n"
"MouseMoveEvent 151 254 0 0 0 0 0\n"
"RenderEvent 151 254 0 0 0 0 0\n"
"InteractionEvent 151 254 0 0 0 0 0\n"
"MouseMoveEvent 149 254 0 0 0 0 0\n"
"RenderEvent 149 254 0 0 0 0 0\n"
"InteractionEvent 149 254 0 0 0 0 0\n"
"MouseMoveEvent 149 254 0 0 0 0 0\n"
"RenderEvent 149 254 0 0 0 0 0\n"
"InteractionEvent 149 254 0 0 0 0 0\n"
"MouseMoveEvent 148 254 0 0 0 0 0\n"
"RenderEvent 148 254 0 0 0 0 0\n"
"InteractionEvent 148 254 0 0 0 0 0\n"
"MouseMoveEvent 148 253 0 0 0 0 0\n"
"RenderEvent 148 253 0 0 0 0 0\n"
"InteractionEvent 148 253 0 0 0 0 0\n"
"MouseMoveEvent 148 252 0 0 0 0 0\n"
"RenderEvent 148 252 0 0 0 0 0\n"
"InteractionEvent 148 252 0 0 0 0 0\n"
"MouseMoveEvent 148 251 0 0 0 0 0\n"
"RenderEvent 148 251 0 0 0 0 0\n"
"InteractionEvent 148 251 0 0 0 0 0\n"
"MouseMoveEvent 149 250 0 0 0 0 0\n"
"RenderEvent 149 250 0 0 0 0 0\n"
"InteractionEvent 149 250 0 0 0 0 0\n"
"MouseMoveEvent 150 249 0 0 0 0 0\n"
"RenderEvent 150 249 0 0 0 0 0\n"
"InteractionEvent 150 249 0 0 0 0 0\n"
"MouseMoveEvent 150 248 0 0 0 0 0\n"
"RenderEvent 150 248 0 0 0 0 0\n"
"InteractionEvent 150 248 0 0 0 0 0\n"
"MouseMoveEvent 151 248 0 0 0 0 0\n"
"RenderEvent 151 248 0 0 0 0 0\n"
"InteractionEvent 151 248 0 0 0 0 0\n"
"MouseMoveEvent 151 247 0 0 0 0 0\n"
"RenderEvent 151 247 0 0 0 0 0\n"
"InteractionEvent 151 247 0 0 0 0 0\n"
"MouseMoveEvent 151 246 0 0 0 0 0\n"
"RenderEvent 151 246 0 0 0 0 0\n"
"InteractionEvent 151 246 0 0 0 0 0\n"
"MouseMoveEvent 151 245 0 0 0 0 0\n"
"RenderEvent 151 245 0 0 0 0 0\n"
"InteractionEvent 151 245 0 0 0 0 0\n"
"MouseMoveEvent 151 244 0 0 0 0 0\n"
"RenderEvent 151 244 0 0 0 0 0\n"
"InteractionEvent 151 244 0 0 0 0 0\n"
"MouseMoveEvent 152 243 0 0 0 0 0\n"
"RenderEvent 152 243 0 0 0 0 0\n"
"InteractionEvent 152 243 0 0 0 0 0\n"
"MouseMoveEvent 152 242 0 0 0 0 0\n"
"RenderEvent 152 242 0 0 0 0 0\n"
"InteractionEvent 152 242 0 0 0 0 0\n"
"MouseMoveEvent 152 241 0 0 0 0 0\n"
"RenderEvent 152 241 0 0 0 0 0\n"
"InteractionEvent 152 241 0 0 0 0 0\n"
"MouseMoveEvent 152 240 0 0 0 0 0\n"
"RenderEvent 152 240 0 0 0 0 0\n"
"InteractionEvent 152 240 0 0 0 0 0\n"
"MouseMoveEvent 154 238 0 0 0 0 0\n"
"RenderEvent 154 238 0 0 0 0 0\n"
"InteractionEvent 154 238 0 0 0 0 0\n"
"MouseMoveEvent 154 236 0 0 0 0 0\n"
"RenderEvent 154 236 0 0 0 0 0\n"
"InteractionEvent 154 236 0 0 0 0 0\n"
"MouseMoveEvent 155 234 0 0 0 0 0\n"
"RenderEvent 155 234 0 0 0 0 0\n"
"InteractionEvent 155 234 0 0 0 0 0\n"
"MouseMoveEvent 156 234 0 0 0 0 0\n"
"RenderEvent 156 234 0 0 0 0 0\n"
"InteractionEvent 156 234 0 0 0 0 0\n"
"MouseMoveEvent 156 232 0 0 0 0 0\n"
"RenderEvent 156 232 0 0 0 0 0\n"
"InteractionEvent 156 232 0 0 0 0 0\n"
"MouseMoveEvent 157 231 0 0 0 0 0\n"
"RenderEvent 157 231 0 0 0 0 0\n"
"InteractionEvent 157 231 0 0 0 0 0\n"
"MouseMoveEvent 157 230 0 0 0 0 0\n"
"RenderEvent 157 230 0 0 0 0 0\n"
"InteractionEvent 157 230 0 0 0 0 0\n"
"MouseMoveEvent 158 229 0 0 0 0 0\n"
"RenderEvent 158 229 0 0 0 0 0\n"
"InteractionEvent 158 229 0 0 0 0 0\n"
"MouseMoveEvent 159 226 0 0 0 0 0\n"
"RenderEvent 159 226 0 0 0 0 0\n"
"InteractionEvent 159 226 0 0 0 0 0\n"
"MouseMoveEvent 160 225 0 0 0 0 0\n"
"RenderEvent 160 225 0 0 0 0 0\n"
"InteractionEvent 160 225 0 0 0 0 0\n"
"MouseMoveEvent 161 223 0 0 0 0 0\n"
"RenderEvent 161 223 0 0 0 0 0\n"
"InteractionEvent 161 223 0 0 0 0 0\n"
"MouseMoveEvent 161 221 0 0 0 0 0\n"
"RenderEvent 161 221 0 0 0 0 0\n"
"InteractionEvent 161 221 0 0 0 0 0\n"
"MouseMoveEvent 162 219 0 0 0 0 0\n"
"RenderEvent 162 219 0 0 0 0 0\n"
"InteractionEvent 162 219 0 0 0 0 0\n"
"MouseMoveEvent 163 218 0 0 0 0 0\n"
"RenderEvent 163 218 0 0 0 0 0\n"
"InteractionEvent 163 218 0 0 0 0 0\n"
"MouseMoveEvent 164 216 0 0 0 0 0\n"
"RenderEvent 164 216 0 0 0 0 0\n"
"InteractionEvent 164 216 0 0 0 0 0\n"
"MouseMoveEvent 165 215 0 0 0 0 0\n"
"RenderEvent 165 215 0 0 0 0 0\n"
"InteractionEvent 165 215 0 0 0 0 0\n"
"MouseMoveEvent 166 213 0 0 0 0 0\n"
"RenderEvent 166 213 0 0 0 0 0\n"
"InteractionEvent 166 213 0 0 0 0 0\n"
"MouseMoveEvent 167 212 0 0 0 0 0\n"
"RenderEvent 167 212 0 0 0 0 0\n"
"InteractionEvent 167 212 0 0 0 0 0\n"
"MouseMoveEvent 168 209 0 0 0 0 0\n"
"RenderEvent 168 209 0 0 0 0 0\n"
"InteractionEvent 168 209 0 0 0 0 0\n"
"MouseMoveEvent 170 206 0 0 0 0 0\n"
"RenderEvent 170 206 0 0 0 0 0\n"
"InteractionEvent 170 206 0 0 0 0 0\n"
"MouseMoveEvent 171 204 0 0 0 0 0\n"
"RenderEvent 171 204 0 0 0 0 0\n"
"InteractionEvent 171 204 0 0 0 0 0\n"
"MouseMoveEvent 172 202 0 0 0 0 0\n"
"RenderEvent 172 202 0 0 0 0 0\n"
"InteractionEvent 172 202 0 0 0 0 0\n"
"MouseMoveEvent 172 201 0 0 0 0 0\n"
"RenderEvent 172 201 0 0 0 0 0\n"
"InteractionEvent 172 201 0 0 0 0 0\n"
"MouseMoveEvent 173 200 0 0 0 0 0\n"
"RenderEvent 173 200 0 0 0 0 0\n"
"InteractionEvent 173 200 0 0 0 0 0\n"
"MouseMoveEvent 174 199 0 0 0 0 0\n"
"RenderEvent 174 199 0 0 0 0 0\n"
"InteractionEvent 174 199 0 0 0 0 0\n"
"MouseMoveEvent 175 199 0 0 0 0 0\n"
"RenderEvent 175 199 0 0 0 0 0\n"
"InteractionEvent 175 199 0 0 0 0 0\n"
"MouseMoveEvent 176 199 0 0 0 0 0\n"
"RenderEvent 176 199 0 0 0 0 0\n"
"InteractionEvent 176 199 0 0 0 0 0\n"
"MouseMoveEvent 177 199 0 0 0 0 0\n"
"RenderEvent 177 199 0 0 0 0 0\n"
"InteractionEvent 177 199 0 0 0 0 0\n"
"MouseMoveEvent 177 199 0 0 0 0 0\n"
"RenderEvent 177 199 0 0 0 0 0\n"
"InteractionEvent 177 199 0 0 0 0 0\n"
"MouseMoveEvent 178 199 0 0 0 0 0\n"
"RenderEvent 178 199 0 0 0 0 0\n"
"InteractionEvent 178 199 0 0 0 0 0\n"
"MouseMoveEvent 178 199 0 0 0 0 0\n"
"RenderEvent 178 199 0 0 0 0 0\n"
"InteractionEvent 178 199 0 0 0 0 0\n"
"MouseMoveEvent 178 199 0 0 0 0 0\n"
"RenderEvent 178 199 0 0 0 0 0\n"
"InteractionEvent 178 199 0 0 0 0 0\n"
"MouseMoveEvent 177 199 0 0 0 0 0\n"
"RenderEvent 177 199 0 0 0 0 0\n"
"InteractionEvent 177 199 0 0 0 0 0\n"
"MouseMoveEvent 176 200 0 0 0 0 0\n"
"RenderEvent 176 200 0 0 0 0 0\n"
"InteractionEvent 176 200 0 0 0 0 0\n"
"LeftButtonReleaseEvent 176 200 0 0 0 0 0\n"
"EndInteractionEvent 176 200 0 0 0 0 0\n"
"RenderEvent 176 200 0 0 0 0 0\n"
"MouseMoveEvent 176 200 0 0 0 0 0\n"
"MouseMoveEvent 176 200 0 0 0 0 0\n"
"MouseMoveEvent 179 199 0 0 0 0 0\n"
"MouseMoveEvent 182 194 0 0 0 0 0\n"
"MouseMoveEvent 185 190 0 0 0 0 0\n"
"MouseMoveEvent 190 183 0 0 0 0 0\n"
"MouseMoveEvent 194 178 0 0 0 0 0\n"
"MouseMoveEvent 199 169 0 0 0 0 0\n"
"MouseMoveEvent 205 163 0 0 0 0 0\n"
"MouseMoveEvent 209 157 0 0 0 0 0\n"
"MouseMoveEvent 214 149 0 0 0 0 0\n"
"MouseMoveEvent 217 144 0 0 0 0 0\n"
"MouseMoveEvent 220 140 0 0 0 0 0\n"
"MouseMoveEvent 224 133 0 0 0 0 0\n"
"MouseMoveEvent 226 129 0 0 0 0 0\n"
"MouseMoveEvent 227 126 0 0 0 0 0\n"
"MouseMoveEvent 229 122 0 0 0 0 0\n"
"MouseMoveEvent 231 119 0 0 0 0 0\n"
"MouseMoveEvent 233 114 0 0 0 0 0\n"
"MouseMoveEvent 233 112 0 0 0 0 0\n"
"MouseMoveEvent 233 111 0 0 0 0 0\n"
"MouseMoveEvent 233 108 0 0 0 0 0\n"
"MouseMoveEvent 233 107 0 0 0 0 0\n"
"MouseMoveEvent 234 106 0 0 0 0 0\n"
"MouseMoveEvent 234 105 0 0 0 0 0\n"
"MouseMoveEvent 234 104 0 0 0 0 0\n"
"MouseMoveEvent 234 103 0 0 0 0 0\n"
"MouseMoveEvent 234 102 0 0 0 0 0\n"
"MouseMoveEvent 234 101 0 0 0 0 0\n"
"MouseMoveEvent 234 101 0 0 0 0 0\n"
"MouseMoveEvent 234 101 0 0 0 0 0\n"
"MouseMoveEvent 235 100 0 0 0 0 0\n"
"MouseMoveEvent 236 100 0 0 0 0 0\n"
"MouseMoveEvent 237 100 0 0 0 0 0\n"
"MouseMoveEvent 238 101 0 0 0 0 0\n"
"MouseMoveEvent 238 101 0 0 0 0 0\n"
"MouseMoveEvent 239 106 0 0 0 0 0\n"
"MouseMoveEvent 239 110 0 0 0 0 0\n"
"MouseMoveEvent 241 116 0 0 0 0 0\n"
"MouseMoveEvent 243 123 0 0 0 0 0\n"
"MouseMoveEvent 244 133 0 0 0 0 0\n"
"MouseMoveEvent 247 143 0 0 0 0 0\n"
"MouseMoveEvent 249 152 0 0 0 0 0\n"
"MouseMoveEvent 251 163 0 0 0 0 0\n"
"MouseMoveEvent 253 175 0 0 0 0 0\n"
"MouseMoveEvent 255 184 0 0 0 0 0\n"
"MouseMoveEvent 257 194 0 0 0 0 0\n"
"MouseMoveEvent 260 207 0 0 0 0 0\n"
"MouseMoveEvent 261 215 0 0 0 0 0\n"
"MouseMoveEvent 263 222 0 0 0 0 0\n"
"MouseMoveEvent 265 228 0 0 0 0 0\n"
"MouseMoveEvent 268 234 0 0 0 0 0\n"
"MouseMoveEvent 270 239 0 0 0 0 0\n"
"MouseMoveEvent 273 243 0 0 0 0 0\n"
"MouseMoveEvent 274 247 0 0 0 0 0\n"
"MouseMoveEvent 276 251 0 0 0 0 0\n"
"MouseMoveEvent 277 253 0 0 0 0 0\n"
"MouseMoveEvent 278 254 0 0 0 0 0\n"
"MouseMoveEvent 279 256 0 0 0 0 0\n"
"MouseMoveEvent 279 257 0 0 0 0 0\n"
"MouseMoveEvent 279 258 0 0 0 0 0\n"
"MouseMoveEvent 279 260 0 0 0 0 0\n"
"MouseMoveEvent 279 261 0 0 0 0 0\n"
"MouseMoveEvent 280 264 0 0 0 0 0\n"
"MouseMoveEvent 280 267 0 0 0 0 0\n"
"MouseMoveEvent 281 270 0 0 0 0 0\n"
"MouseMoveEvent 281 274 0 0 0 0 0\n"
"MouseMoveEvent 281 278 0 0 0 0 0\n"
"MouseMoveEvent 282 282 0 0 0 0 0\n"
"MouseMoveEvent 282 285 0 0 0 0 0\n"
"MouseMoveEvent 282 288 0 0 0 0 0\n"
"MouseMoveEvent 282 289 0 0 0 0 0\n"
"MouseMoveEvent 283 291 0 0 0 0 0\n"
"MouseMoveEvent 284 292 0 0 0 0 0\n"
"MouseMoveEvent 284 294 0 0 0 0 0\n"
"MouseMoveEvent 284 295 0 0 0 0 0\n"
"MouseMoveEvent 284 297 0 0 0 0 0\n"
"MouseMoveEvent 284 298 0 0 0 0 0\n"
"MouseMoveEvent 284 299 0 0 0 0 0\n"
"MouseMoveEvent 284 300 0 0 0 0 0\n"
;

//----------------------------------------------------------------------------
int TestGPURayCastVolumePlane(int argc, char* argv[])
{
  cout << "CTEST_FULL_OUTPUT (Avoid ctest truncation of output)" << endl;

  vtkNew<vtkRTAnalyticSource> source;
  source->SetWholeExtent(-49,50,-49,50,0,1);
  source->SetCenter(0.0, 0.0, 0.0);
  source->Update();

  vtkImageData* wavelet = source->GetOutput();
  wavelet->SetSpacing(1,1,10);

  vtkNew<vtkGPUVolumeRayCastMapper> volumeMapper;
  volumeMapper->AutoAdjustSampleDistancesOff();
  volumeMapper->SetSampleDistance(1.0);
  volumeMapper->SetInputConnection(source->GetOutputPort());

  vtkNew<vtkVolumeProperty> volumeProperty;
  vtkNew<vtkColorTransferFunction> ctf;
  ctf->AddRGBPoint(37.3531, 0.8, 0.29, 1);
  ctf->AddRGBPoint(157.091, 0.87, 0.87, 0.87);
  ctf->AddRGBPoint(276.829, 0.7, 0.015, 0.15);

  vtkNew<vtkPiecewiseFunction> pwf;
  pwf->AddPoint(37.3531, 1.0);
  pwf->AddPoint(276.829, 1.0);

  volumeProperty->SetColor(ctf.GetPointer());
  volumeProperty->SetScalarOpacity(pwf.GetPointer());

  vtkNew<vtkVolume> volume;
  volume->SetMapper(volumeMapper.GetPointer());
  volume->SetProperty(volumeProperty.GetPointer());

  vtkNew<vtkRenderWindow> renderWindow;
  renderWindow->SetSize(300, 301);
  vtkNew<vtkRenderWindowInteractor> iren;
  iren->SetRenderWindow(renderWindow.GetPointer());
  vtkNew<vtkInteractorStyleTrackballCamera> style;
  iren->SetInteractorStyle(style.GetPointer());
  renderWindow->Render(); // make sure we have an OpenGL context.

  vtkNew<vtkPlaneSource> plane;
  plane->SetCenter(0,0,5.0);
  plane->SetOrigin(-70, -70, 5.0);
  plane->SetPoint1(70, -70, 5.0);
  plane->SetPoint2(-70, 70, 5.0);

  vtkNew<vtkPolyDataMapper> planeMapper;
  planeMapper->SetInputConnection(plane->GetOutputPort());

  vtkNew<vtkActor> planeActor;
  planeActor->SetMapper(planeMapper.GetPointer());
  planeActor->GetProperty()->SetAmbient(1);
  planeActor->GetProperty()->SetDiffuse(0);

  vtkNew<vtkRenderer> renderer;
  renderer->SetBackground(0.3, 0.35, 0.45);
  renderWindow->AddRenderer(renderer.GetPointer());

  renderer->AddActor(planeActor.GetPointer());
  renderer->AddVolume(volume.GetPointer());
  renderer->ResetCamera();

  renderWindow->Render();

  iren->Initialize();

  return vtkTesting::InteractorEventLoop(argc, argv, iren.GetPointer(),
                                         TestGPURayCastVolumePlaneLog);
}
