/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.nodes.proto;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.web3d.util.DefaultErrorReporter;
import org.web3d.util.ErrorReporter;
import org.web3d.vrml.lang.FieldExistsException;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.NodeTemplateToInstanceCreator;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.lang.VRMLNodeTemplate;
import org.web3d.vrml.nodes.NodeListenerMulticaster;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLNodeListener;
import org.web3d.vrml.nodes.VRMLNodeType;

public abstract class AbstractProto
implements VRMLNodeTemplate {
    protected static final String BAD_NODE_MSG = "The supplied node cannot be copied as it's type is wrong. The type supplied is ";
    protected static final String VRML97_FIELD_MSG = "Field type not supported in VRML97: ";
    protected static final String FIELD_CLASH_MSG = "The same field has been declared twice in this node, but the data types or access types are different.";
    protected final Map fieldIndexMap;
    protected final List fieldDeclList;
    protected final String nodeName;
    protected final VRMLFieldData fieldData;
    protected ErrorReporter errorReporter;
    private int fieldCount;
    private VRMLNodeListener nodeListener;
    protected final int vrmlMajorVersion;
    protected final int vrmlMinorVersion;
    protected boolean isVrml97;
    protected NodeTemplateToInstanceCreator protoCreator;

    public AbstractProto(String string, int n, int n2, NodeTemplateToInstanceCreator nodeTemplateToInstanceCreator) {
        this.nodeName = string;
        this.protoCreator = nodeTemplateToInstanceCreator;
        this.vrmlMajorVersion = n;
        this.vrmlMinorVersion = n2;
        this.isVrml97 = n == 2;
        this.fieldIndexMap = new HashMap();
        this.fieldDeclList = new ArrayList();
        this.fieldData = new VRMLFieldData();
        this.fieldCount = 0;
        VRMLFieldDeclaration vRMLFieldDeclaration = new VRMLFieldDeclaration(3, "SFNode", "metadata");
        this.appendField(vRMLFieldDeclaration);
        this.errorReporter = DefaultErrorReporter.getDefaultReporter();
    }

    public void setErrorReporter(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
        if (errorReporter == null) {
            this.errorReporter = DefaultErrorReporter.getDefaultReporter();
        }
    }

    public void addNodeListener(VRMLNodeListener vRMLNodeListener) {
        this.nodeListener = NodeListenerMulticaster.remove(this.nodeListener, vRMLNodeListener);
    }

    public void removeNodeListener(VRMLNodeListener vRMLNodeListener) {
        this.nodeListener = NodeListenerMulticaster.add(this.nodeListener, vRMLNodeListener);
    }

    protected void fireFieldChanged(int n) {
        if (this.nodeListener != null) {
            try {
                this.nodeListener.fieldChanged(n);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    public String getVRMLNodeName() {
        return this.nodeName;
    }

    public int getFieldCount() {
        return this.fieldCount;
    }

    public int appendField(VRMLFieldDeclaration vRMLFieldDeclaration) throws FieldExistsException, InvalidFieldException {
        Integer n;
        String string = vRMLFieldDeclaration.getName();
        if (this.isVrml97) {
            switch (vRMLFieldDeclaration.getFieldType()) {
                case 2: 
                case 7: 
                case 8: 
                case 17: 
                case 18: 
                case 23: 
                case 24: 
                case 26: 
                case 31: 
                case 32: {
                    throw new InvalidFieldException(VRML97_FIELD_MSG + vRMLFieldDeclaration.getFieldTypeString());
                }
            }
        }
        if ((n = (Integer)this.fieldIndexMap.get(string)) != null) {
            VRMLFieldDeclaration vRMLFieldDeclaration2 = (VRMLFieldDeclaration)this.fieldDeclList.get(n);
            if (vRMLFieldDeclaration.getFieldType() != vRMLFieldDeclaration2.getFieldType() || vRMLFieldDeclaration.getAccessType() != vRMLFieldDeclaration.getAccessType()) {
                throw new FieldExistsException(FIELD_CLASH_MSG, string);
            }
        }
        this.fieldIndexMap.put(string, new Integer(this.fieldCount));
        this.fieldDeclList.add(vRMLFieldDeclaration);
        int n2 = this.fieldCount++;
        return n2;
    }

    public void deleteField(int n) throws InvalidFieldException, IndexOutOfBoundsException {
        VRMLFieldDeclaration vRMLFieldDeclaration = (VRMLFieldDeclaration)this.fieldDeclList.get(n);
        if (vRMLFieldDeclaration == null) {
            throw new InvalidFieldException();
        }
        this.fieldDeclList.set(n, null);
        this.fieldIndexMap.remove(vRMLFieldDeclaration.getName());
    }

    public void deleteField(VRMLFieldDeclaration vRMLFieldDeclaration) throws InvalidFieldException, IndexOutOfBoundsException {
        String string = vRMLFieldDeclaration.getName();
        Integer n = (Integer)this.fieldIndexMap.remove(string);
        if (n == null) {
            throw new InvalidFieldException("No field here", string);
        }
        this.fieldDeclList.set(n, null);
    }

    public List getAllFields() {
        ArrayList arrayList = new ArrayList();
        int n = this.fieldDeclList.size();
        for (int i = 0; i < n; ++i) {
            Object e = this.fieldDeclList.get(i);
            if (e == null) continue;
            arrayList.add(e);
        }
        return arrayList;
    }

    public boolean isVRML97() {
        return this.isVrml97;
    }

    protected void checkNodeType(VRMLNodeType vRMLNodeType) {
        String string = vRMLNodeType.getVRMLNodeName();
        if (!string.equals(this.nodeName)) {
            throw new IllegalArgumentException("The supplied node cannot be copied as it's type is wrong. The type supplied is type");
        }
    }

    public int getFieldIndex(String string) {
        int n = -1;
        Integer n2 = (Integer)this.fieldIndexMap.get(string);
        if (n2 != null) {
            n = n2;
        }
        return n;
    }

    public VRMLFieldDeclaration getFieldDeclaration(int n) {
        return (VRMLFieldDeclaration)this.fieldDeclList.get(n);
    }

    public int getNumFields() {
        return this.fieldDeclList.size();
    }
}

