set(ORTHANC_ROOT ${SAMPLES_ROOT}/../..)
include(CheckIncludeFiles)
include(CheckIncludeFileCXX)
include(CheckLibraryExists)
include(FindPythonInterp)
include(${ORTHANC_ROOT}/Resources/CMake/AutoGeneratedCode.cmake)
include(${ORTHANC_ROOT}/Resources/CMake/DownloadPackage.cmake)
include(${ORTHANC_ROOT}/Resources/CMake/Compiler.cmake)


if (CMAKE_COMPILER_IS_GNUCXX)
  set(CMAKE_C_FLAGS "${CMAKE_C_FLAGS} -Wall -pedantic")
  set(CMAKE_CXX_FLAGS "${CMAKE_CXX_FLAGS} -Wall -pedantic")
endif()


if (${CMAKE_SYSTEM_NAME} STREQUAL "Linux")
  # Linking with "pthread" is necessary, otherwise the software crashes
  # http://sourceware.org/bugzilla/show_bug.cgi?id=10652#c17
  link_libraries(dl rt pthread)
endif()


include_directories(${SAMPLES_ROOT}/../Include/)


if (MSVC)
  include_directories(${SAMPLES_ROOT}/../../Resources/ThirdParty/VisualStudio/)
endif()


add_definitions(-DHAS_ORTHANC_EXCEPTION=0)
