/*
 * Contributed by Stephane Eranian <eranian@gmail.com>
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
 * of the Software, and to permit persons to whom the Software is furnished to do so,
 * subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,
 * INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
 * PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
 * HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
 * CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE
 * OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 * This file is part of libpfm, a performance monitoring support library for
 * applications on Linux.
 *
 * PMU: icx_unc_irp (IcelakeX Uncore IRP)
 * Based on Intel JSON event table version   : 1.21
 * Based on Intel JSON event table published : 06/06/2023
 */

static const intel_x86_umask_t icx_unc_i_cache_total_occupancy[]={
  { .uname   = "ANY",
    .udesc   = "Any Source (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO | INTEL_X86_DFL,
  },
  { .uname   = "IV_Q",
    .udesc   = "Snoops (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "MEM",
    .udesc   = "TBD",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_i_coherent_ops[]={
  { .uname   = "CLFLUSH",
    .udesc   = "CLFlush (experimental)",
    .ucode   = 0x8000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "PCITOM",
    .udesc   = "TBD",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "RFO",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "WBMTOI",
    .udesc   = "WbMtoI",
    .ucode   = 0x4000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_i_irp_all[]={
  { .uname   = "EVICTS",
    .udesc   = "All Inserts Outbound (BL, AK, Snoops) (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "INBOUND_INSERTS",
    .udesc   = "All Inserts Inbound (p2p + faf + cset)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "OUTBOUND_INSERTS",
    .udesc   = "All Inserts Outbound (BL, AK, Snoops) (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_i_misc0[]={
  { .uname   = "2ND_ATOMIC_INSERT",
    .udesc   = "Cache Inserts of Atomic Transactions as Secondary (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "2ND_RD_INSERT",
    .udesc   = "Cache Inserts of Read Transactions as Secondary (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "2ND_WR_INSERT",
    .udesc   = "Cache Inserts of Write Transactions as Secondary (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "FAST_REJ",
    .udesc   = "Fastpath Rejects (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "FAST_REQ",
    .udesc   = "Fastpath Requests (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "FAST_XFER",
    .udesc   = "Fastpath Transfers From Primary to Secondary (experimental)",
    .ucode   = 0x2000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "PF_ACK_HINT",
    .udesc   = "Prefetch Ack Hints From Primary to Secondary (experimental)",
    .ucode   = 0x4000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "SLOWPATH_FWPF_NO_PRF",
    .udesc   = "Slow path fwpf didn't find prefetch (experimental)",
    .ucode   = 0x8000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_i_misc1[]={
  { .uname   = "LOST_FWD",
    .udesc   = "Lost Forward",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "SEC_RCVD_INVLD",
    .udesc   = "Received Invalid (experimental)",
    .ucode   = 0x2000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "SEC_RCVD_VLD",
    .udesc   = "Received Valid (experimental)",
    .ucode   = 0x4000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "SLOW_E",
    .udesc   = "Slow Transfer of E Line (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "SLOW_I",
    .udesc   = "Slow Transfer of I Line (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "SLOW_M",
    .udesc   = "Slow Transfer of M Line (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "SLOW_S",
    .udesc   = "Slow Transfer of S Line (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_i_p2p_transactions[]={
  { .uname   = "CMPL",
    .udesc   = "P2P completions (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "LOC",
    .udesc   = "match if local only (experimental)",
    .ucode   = 0x4000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "LOC_AND_TGT_MATCH",
    .udesc   = "match if local and target matches (experimental)",
    .ucode   = 0x8000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "MSG",
    .udesc   = "P2P Message (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "RD",
    .udesc   = "P2P reads (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "REM",
    .udesc   = "Match if remote only (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "REM_AND_TGT_MATCH",
    .udesc   = "match if remote and target matches (experimental)",
    .ucode   = 0x2000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "WR",
    .udesc   = "P2P Writes (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_i_snoop_resp[]={
  { .uname   = "ALL_HIT",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x7e00ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "ALL_HIT_ES",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x7400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "ALL_HIT_I",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x7200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "ALL_HIT_M",
    .udesc   = "TBD",
    .ucode   = 0x7800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "ALL_MISS",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x7100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "HIT_ES",
    .udesc   = "Hit E or S (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "HIT_I",
    .udesc   = "Hit I (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "HIT_M",
    .udesc   = "Hit M (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "MISS",
    .udesc   = "Miss (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "SNPCODE",
    .udesc   = "SnpCode (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "SNPDATA",
    .udesc   = "SnpData (experimental)",
    .ucode   = 0x2000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "SNPINV",
    .udesc   = "SnpInv (experimental)",
    .ucode   = 0x4000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_i_transactions[]={
  { .uname   = "ATOMIC",
    .udesc   = "Atomic (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "ORDERINGQ",
    .udesc   = "Select Source (experimental)",
    .ucode   = 0x4000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "OTHER",
    .udesc   = "Other (experimental)",
    .ucode   = 0x2000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "WRITES",
    .udesc   = "Writes (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "WR_PREF",
    .udesc   = "TBD",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_entry_t intel_icx_unc_irp_pe[]={
  { .name   = "UNC_I_CACHE_TOTAL_OCCUPANCY",
    .desc   = "Total IRP occupancy of inbound read and write requests to coherent memory.",
    .code   = 0x000f,
    .modmsk = ICX_UNC_IRP_ATTRS,
    .cntmsk = 0x3ull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_i_cache_total_occupancy),
    .umasks = icx_unc_i_cache_total_occupancy,
  },
  { .name   = "UNC_I_CLOCKTICKS",
    .desc   = "Clockticks of the IO coherency tracker (IRP)",
    .code   = 0x0001,
    .modmsk = ICX_UNC_IRP_ATTRS,
    .cntmsk = 0x3ull,
  },
  { .name   = "UNC_I_COHERENT_OPS",
    .desc   = "PCIITOM request issued by the IRP unit to the mesh with the intention of writing a full cacheline.",
    .code   = 0x0010,
    .modmsk = ICX_UNC_IRP_ATTRS,
    .cntmsk = 0x3ull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_i_coherent_ops),
    .umasks = icx_unc_i_coherent_ops,
  },
  { .name   = "UNC_I_FAF_FULL",
    .desc   = "FAF RF full",
    .code   = 0x0017,
    .modmsk = ICX_UNC_IRP_ATTRS,
    .cntmsk = 0x3ull,
  },
  { .name   = "UNC_I_FAF_INSERTS",
    .desc   = "Inbound read requests received by the IRP and inserted into the FAF queue.",
    .code   = 0x0018,
    .modmsk = ICX_UNC_IRP_ATTRS,
    .cntmsk = 0x3ull,
  },
  { .name   = "UNC_I_FAF_OCCUPANCY",
    .desc   = "Occupancy of the IRP FAF queue.",
    .code   = 0x0019,
    .modmsk = ICX_UNC_IRP_ATTRS,
    .cntmsk = 0x3ull,
  },
  { .name   = "UNC_I_FAF_TRANSACTIONS",
    .desc   = "FAF allocation -- sent to ADQ",
    .code   = 0x0016,
    .modmsk = ICX_UNC_IRP_ATTRS,
    .cntmsk = 0x3ull,
  },
  { .name   = "UNC_I_IRP_ALL",
    .desc   = "TBD",
    .code   = 0x0020,
    .modmsk = ICX_UNC_IRP_ATTRS,
    .cntmsk = 0x3ull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_i_irp_all),
    .umasks = icx_unc_i_irp_all,
  },
  { .name   = "UNC_I_MISC0",
    .desc   = "Counts Timeouts - Set 0",
    .code   = 0x001e,
    .modmsk = ICX_UNC_IRP_ATTRS,
    .cntmsk = 0x3ull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_i_misc0),
    .umasks = icx_unc_i_misc0,
  },
  { .name   = "UNC_I_MISC1",
    .desc   = "Misc Events - Set 1",
    .code   = 0x001f,
    .modmsk = ICX_UNC_IRP_ATTRS,
    .cntmsk = 0x3ull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_i_misc1),
    .umasks = icx_unc_i_misc1,
  },
  { .name   = "UNC_I_P2P_INSERTS",
    .desc   = "P2P Requests (experimental)",
    .code   = 0x0014,
    .modmsk = ICX_UNC_IRP_ATTRS,
    .cntmsk = 0x3ull,
  },
  { .name   = "UNC_I_P2P_OCCUPANCY",
    .desc   = "P2P Occupancy (experimental)",
    .code   = 0x0015,
    .modmsk = ICX_UNC_IRP_ATTRS,
    .cntmsk = 0x3ull,
  },
  { .name   = "UNC_I_P2P_TRANSACTIONS",
    .desc   = "P2P Transactions",
    .code   = 0x0013,
    .modmsk = ICX_UNC_IRP_ATTRS,
    .cntmsk = 0x3ull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_i_p2p_transactions),
    .umasks = icx_unc_i_p2p_transactions,
  },
  { .name   = "UNC_I_SNOOP_RESP",
    .desc   = "Responses to snoops of any type that hit M line in the IIO cache",
    .code   = 0x0012,
    .modmsk = ICX_UNC_IRP_ATTRS,
    .cntmsk = 0x3ull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_i_snoop_resp),
    .umasks = icx_unc_i_snoop_resp,
  },
  { .name   = "UNC_I_TRANSACTIONS",
    .desc   = "Inbound write (fast path) requests received by the IRP.",
    .code   = 0x0011,
    .modmsk = ICX_UNC_IRP_ATTRS,
    .cntmsk = 0x3ull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_i_transactions),
    .umasks = icx_unc_i_transactions,
  },
  { .name   = "UNC_I_TxC_AK_INSERTS",
    .desc   = "AK Egress Allocations (experimental)",
    .code   = 0x000b,
    .modmsk = ICX_UNC_IRP_ATTRS,
    .cntmsk = 0x3ull,
  },
  { .name   = "UNC_I_TxC_BL_DRS_CYCLES_FULL",
    .desc   = "BL DRS Egress Cycles Full (experimental)",
    .code   = 0x0005,
    .modmsk = ICX_UNC_IRP_ATTRS,
    .cntmsk = 0x3ull,
  },
  { .name   = "UNC_I_TxC_BL_DRS_INSERTS",
    .desc   = "BL DRS Egress Inserts (experimental)",
    .code   = 0x0002,
    .modmsk = ICX_UNC_IRP_ATTRS,
    .cntmsk = 0x3ull,
  },
  { .name   = "UNC_I_TxC_BL_DRS_OCCUPANCY",
    .desc   = "BL DRS Egress Occupancy (experimental)",
    .code   = 0x0008,
    .modmsk = ICX_UNC_IRP_ATTRS,
    .cntmsk = 0x3ull,
  },
  { .name   = "UNC_I_TxC_BL_NCB_CYCLES_FULL",
    .desc   = "BL NCB Egress Cycles Full (experimental)",
    .code   = 0x0006,
    .modmsk = ICX_UNC_IRP_ATTRS,
    .cntmsk = 0x3ull,
  },
  { .name   = "UNC_I_TxC_BL_NCB_INSERTS",
    .desc   = "BL NCB Egress Inserts (experimental)",
    .code   = 0x0003,
    .modmsk = ICX_UNC_IRP_ATTRS,
    .cntmsk = 0x3ull,
  },
  { .name   = "UNC_I_TxC_BL_NCB_OCCUPANCY",
    .desc   = "BL NCB Egress Occupancy (experimental)",
    .code   = 0x0009,
    .modmsk = ICX_UNC_IRP_ATTRS,
    .cntmsk = 0x3ull,
  },
  { .name   = "UNC_I_TxC_BL_NCS_CYCLES_FULL",
    .desc   = "BL NCS Egress Cycles Full (experimental)",
    .code   = 0x0007,
    .modmsk = ICX_UNC_IRP_ATTRS,
    .cntmsk = 0x3ull,
  },
  { .name   = "UNC_I_TxC_BL_NCS_INSERTS",
    .desc   = "BL NCS Egress Inserts (experimental)",
    .code   = 0x0004,
    .modmsk = ICX_UNC_IRP_ATTRS,
    .cntmsk = 0x3ull,
  },
  { .name   = "UNC_I_TxC_BL_NCS_OCCUPANCY",
    .desc   = "BL NCS Egress Occupancy (experimental)",
    .code   = 0x000a,
    .modmsk = ICX_UNC_IRP_ATTRS,
    .cntmsk = 0x3ull,
  },
  { .name   = "UNC_I_TxR2_AD01_STALL_CREDIT_CYCLES",
    .desc   = "UNC_I_TxR2_AD01_STALL_CREDIT_CYCLES (experimental)",
    .code   = 0x001c,
    .modmsk = ICX_UNC_IRP_ATTRS,
    .cntmsk = 0x3ull,
  },
  { .name   = "UNC_I_TxR2_AD0_STALL_CREDIT_CYCLES",
    .desc   = "No AD0 Egress Credits Stalls (experimental)",
    .code   = 0x001a,
    .modmsk = ICX_UNC_IRP_ATTRS,
    .cntmsk = 0x3ull,
  },
  { .name   = "UNC_I_TxR2_AD1_STALL_CREDIT_CYCLES",
    .desc   = "No AD1 Egress Credits Stalls (experimental)",
    .code   = 0x001b,
    .modmsk = ICX_UNC_IRP_ATTRS,
    .cntmsk = 0x3ull,
  },
  { .name   = "UNC_I_TxR2_BL_STALL_CREDIT_CYCLES",
    .desc   = "No BL Egress Credit Stalls (experimental)",
    .code   = 0x001d,
    .modmsk = ICX_UNC_IRP_ATTRS,
    .cntmsk = 0x3ull,
  },
  { .name   = "UNC_I_TxS_DATA_INSERTS_NCB",
    .desc   = "Outbound Read Requests (experimental)",
    .code   = 0x000d,
    .modmsk = ICX_UNC_IRP_ATTRS,
    .cntmsk = 0x3ull,
  },
  { .name   = "UNC_I_TxS_DATA_INSERTS_NCS",
    .desc   = "Outbound Read Requests (experimental)",
    .code   = 0x000e,
    .modmsk = ICX_UNC_IRP_ATTRS,
    .cntmsk = 0x3ull,
  },
  { .name   = "UNC_I_TxS_REQUEST_OCCUPANCY",
    .desc   = "Outbound Request Queue Occupancy (experimental)",
    .code   = 0x000c,
    .modmsk = ICX_UNC_IRP_ATTRS,
    .cntmsk = 0x3ull,
  },
};
/* 32 events available */
