; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+sse4.2 | FileCheck %s --check-prefixes=SSE42
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx2 | FileCheck %s --check-prefixes=AVX2
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512f,+avx512bw,+avx512cd,+avx512vl | FileCheck %s --check-prefixes=AVX512,AVX512VL
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512f,+avx512bw,+avx512cd,+avx512vl,+avx512vpopcntdq | FileCheck %s --check-prefixes=AVX512,AVX512VPOPCNT

;
; CTPOP
;

define <4 x i32> @widen_ctpop_v2i32_v4i32(<2 x i32> %a0, <2 x i32> %a1) {
; SSE42-LABEL: widen_ctpop_v2i32_v4i32:
; SSE42:       # %bb.0:
; SSE42-NEXT:    movdqa {{.*#+}} xmm2 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; SSE42-NEXT:    movdqa %xmm0, %xmm3
; SSE42-NEXT:    pand %xmm2, %xmm3
; SSE42-NEXT:    movdqa {{.*#+}} xmm4 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; SSE42-NEXT:    movdqa %xmm4, %xmm5
; SSE42-NEXT:    pshufb %xmm3, %xmm5
; SSE42-NEXT:    psrlw $4, %xmm0
; SSE42-NEXT:    pand %xmm2, %xmm0
; SSE42-NEXT:    movdqa %xmm4, %xmm3
; SSE42-NEXT:    pshufb %xmm0, %xmm3
; SSE42-NEXT:    paddb %xmm5, %xmm3
; SSE42-NEXT:    pmovzxdq {{.*#+}} xmm0 = xmm3[0],zero,xmm3[1],zero
; SSE42-NEXT:    pxor %xmm3, %xmm3
; SSE42-NEXT:    psadbw %xmm3, %xmm0
; SSE42-NEXT:    movdqa %xmm1, %xmm5
; SSE42-NEXT:    pand %xmm2, %xmm5
; SSE42-NEXT:    movdqa %xmm4, %xmm6
; SSE42-NEXT:    pshufb %xmm5, %xmm6
; SSE42-NEXT:    psrlw $4, %xmm1
; SSE42-NEXT:    pand %xmm2, %xmm1
; SSE42-NEXT:    pshufb %xmm1, %xmm4
; SSE42-NEXT:    paddb %xmm6, %xmm4
; SSE42-NEXT:    pmovzxdq {{.*#+}} xmm1 = xmm4[0],zero,xmm4[1],zero
; SSE42-NEXT:    psadbw %xmm3, %xmm1
; SSE42-NEXT:    packuswb %xmm1, %xmm0
; SSE42-NEXT:    retq
;
; AVX2-LABEL: widen_ctpop_v2i32_v4i32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb {{.*#+}} xmm2 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %xmm2, %xmm0, %xmm3
; AVX2-NEXT:    vmovdqa {{.*#+}} xmm4 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    vpshufb %xmm3, %xmm4, %xmm3
; AVX2-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX2-NEXT:    vpand %xmm2, %xmm0, %xmm0
; AVX2-NEXT:    vpshufb %xmm0, %xmm4, %xmm0
; AVX2-NEXT:    vpaddb %xmm3, %xmm0, %xmm0
; AVX2-NEXT:    vpmovzxdq {{.*#+}} xmm0 = xmm0[0],zero,xmm0[1],zero
; AVX2-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; AVX2-NEXT:    vpsadbw %xmm3, %xmm0, %xmm0
; AVX2-NEXT:    vpand %xmm2, %xmm1, %xmm5
; AVX2-NEXT:    vpshufb %xmm5, %xmm4, %xmm5
; AVX2-NEXT:    vpsrlw $4, %xmm1, %xmm1
; AVX2-NEXT:    vpand %xmm2, %xmm1, %xmm1
; AVX2-NEXT:    vpshufb %xmm1, %xmm4, %xmm1
; AVX2-NEXT:    vpaddb %xmm5, %xmm1, %xmm1
; AVX2-NEXT:    vpmovzxdq {{.*#+}} xmm1 = xmm1[0],zero,xmm1[1],zero
; AVX2-NEXT:    vpsadbw %xmm3, %xmm1, %xmm1
; AVX2-NEXT:    vpackuswb %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    retq
;
; AVX512VL-LABEL: widen_ctpop_v2i32_v4i32:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpbroadcastb {{.*#+}} xmm2 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX512VL-NEXT:    vpand %xmm2, %xmm0, %xmm3
; AVX512VL-NEXT:    vmovdqa {{.*#+}} xmm4 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX512VL-NEXT:    vpshufb %xmm3, %xmm4, %xmm3
; AVX512VL-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX512VL-NEXT:    vpand %xmm2, %xmm0, %xmm0
; AVX512VL-NEXT:    vpshufb %xmm0, %xmm4, %xmm0
; AVX512VL-NEXT:    vpaddb %xmm3, %xmm0, %xmm0
; AVX512VL-NEXT:    vpmovzxdq {{.*#+}} xmm0 = xmm0[0],zero,xmm0[1],zero
; AVX512VL-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; AVX512VL-NEXT:    vpsadbw %xmm3, %xmm0, %xmm0
; AVX512VL-NEXT:    vpand %xmm2, %xmm1, %xmm5
; AVX512VL-NEXT:    vpshufb %xmm5, %xmm4, %xmm5
; AVX512VL-NEXT:    vpsrlw $4, %xmm1, %xmm1
; AVX512VL-NEXT:    vpand %xmm2, %xmm1, %xmm1
; AVX512VL-NEXT:    vpshufb %xmm1, %xmm4, %xmm1
; AVX512VL-NEXT:    vpaddb %xmm5, %xmm1, %xmm1
; AVX512VL-NEXT:    vpmovzxdq {{.*#+}} xmm1 = xmm1[0],zero,xmm1[1],zero
; AVX512VL-NEXT:    vpsadbw %xmm3, %xmm1, %xmm1
; AVX512VL-NEXT:    vpackuswb %xmm1, %xmm0, %xmm0
; AVX512VL-NEXT:    retq
;
; AVX512VPOPCNT-LABEL: widen_ctpop_v2i32_v4i32:
; AVX512VPOPCNT:       # %bb.0:
; AVX512VPOPCNT-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; AVX512VPOPCNT-NEXT:    vpopcntd %xmm0, %xmm0
; AVX512VPOPCNT-NEXT:    retq
  %b0 = call <2 x i32> @llvm.ctpop.v2i32(<2 x i32> %a0)
  %b1 = call <2 x i32> @llvm.ctpop.v2i32(<2 x i32> %a1)
  %res = shufflevector <2 x i32> %b0, <2 x i32> %b1, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  ret <4 x i32> %res
}

define <8 x i32> @widen_ctpop_v4i32_v8i32(<4 x i32> %a0, <4 x i32> %a1) {
; SSE42-LABEL: widen_ctpop_v4i32_v8i32:
; SSE42:       # %bb.0:
; SSE42-NEXT:    movdqa {{.*#+}} xmm3 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; SSE42-NEXT:    movdqa %xmm0, %xmm4
; SSE42-NEXT:    pand %xmm3, %xmm4
; SSE42-NEXT:    movdqa {{.*#+}} xmm2 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; SSE42-NEXT:    movdqa %xmm2, %xmm5
; SSE42-NEXT:    pshufb %xmm4, %xmm5
; SSE42-NEXT:    psrlw $4, %xmm0
; SSE42-NEXT:    pand %xmm3, %xmm0
; SSE42-NEXT:    movdqa %xmm2, %xmm4
; SSE42-NEXT:    pshufb %xmm0, %xmm4
; SSE42-NEXT:    paddb %xmm5, %xmm4
; SSE42-NEXT:    pxor %xmm5, %xmm5
; SSE42-NEXT:    pmovzxdq {{.*#+}} xmm0 = xmm4[0],zero,xmm4[1],zero
; SSE42-NEXT:    punpckhdq {{.*#+}} xmm4 = xmm4[2],xmm5[2],xmm4[3],xmm5[3]
; SSE42-NEXT:    psadbw %xmm5, %xmm4
; SSE42-NEXT:    psadbw %xmm5, %xmm0
; SSE42-NEXT:    packuswb %xmm4, %xmm0
; SSE42-NEXT:    movdqa %xmm1, %xmm4
; SSE42-NEXT:    pand %xmm3, %xmm4
; SSE42-NEXT:    movdqa %xmm2, %xmm6
; SSE42-NEXT:    pshufb %xmm4, %xmm6
; SSE42-NEXT:    psrlw $4, %xmm1
; SSE42-NEXT:    pand %xmm3, %xmm1
; SSE42-NEXT:    pshufb %xmm1, %xmm2
; SSE42-NEXT:    paddb %xmm6, %xmm2
; SSE42-NEXT:    pmovzxdq {{.*#+}} xmm1 = xmm2[0],zero,xmm2[1],zero
; SSE42-NEXT:    punpckhdq {{.*#+}} xmm2 = xmm2[2],xmm5[2],xmm2[3],xmm5[3]
; SSE42-NEXT:    psadbw %xmm5, %xmm2
; SSE42-NEXT:    psadbw %xmm5, %xmm1
; SSE42-NEXT:    packuswb %xmm2, %xmm1
; SSE42-NEXT:    retq
;
; AVX2-LABEL: widen_ctpop_v4i32_v8i32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    # kill: def $xmm0 killed $xmm0 def $ymm0
; AVX2-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; AVX2-NEXT:    vpsadbw %ymm1, %ymm2, %ymm2
; AVX2-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; AVX2-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VL-LABEL: widen_ctpop_v4i32_v8i32:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    # kill: def $xmm0 killed $xmm0 def $ymm0
; AVX512VL-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm0
; AVX512VL-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX512VL-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX512VL-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX512VL-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX512VL-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX512VL-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX512VL-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX512VL-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX512VL-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX512VL-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX512VL-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; AVX512VL-NEXT:    vpsadbw %ymm1, %ymm2, %ymm2
; AVX512VL-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; AVX512VL-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX512VL-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; AVX512VL-NEXT:    retq
;
; AVX512VPOPCNT-LABEL: widen_ctpop_v4i32_v8i32:
; AVX512VPOPCNT:       # %bb.0:
; AVX512VPOPCNT-NEXT:    # kill: def $xmm0 killed $xmm0 def $ymm0
; AVX512VPOPCNT-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm0
; AVX512VPOPCNT-NEXT:    vpopcntd %ymm0, %ymm0
; AVX512VPOPCNT-NEXT:    retq
  %b0 = call <4 x i32> @llvm.ctpop.v4i32(<4 x i32> %a0)
  %b1 = call <4 x i32> @llvm.ctpop.v4i32(<4 x i32> %a1)
  %res = shufflevector <4 x i32> %b0, <4 x i32> %b1, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  ret <8 x i32> %res
}

define <8 x i32> @widen_ctpop_v2i32_v8i32(<2 x i32> %a0, <2 x i32> %a1, <2 x i32> %a2, <2 x i32> %a3) {
; SSE42-LABEL: widen_ctpop_v2i32_v8i32:
; SSE42:       # %bb.0:
; SSE42-NEXT:    movdqa {{.*#+}} xmm5 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; SSE42-NEXT:    movdqa %xmm0, %xmm6
; SSE42-NEXT:    pand %xmm5, %xmm6
; SSE42-NEXT:    movdqa {{.*#+}} xmm4 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; SSE42-NEXT:    movdqa %xmm4, %xmm7
; SSE42-NEXT:    pshufb %xmm6, %xmm7
; SSE42-NEXT:    psrlw $4, %xmm0
; SSE42-NEXT:    pand %xmm5, %xmm0
; SSE42-NEXT:    movdqa %xmm4, %xmm6
; SSE42-NEXT:    pshufb %xmm0, %xmm6
; SSE42-NEXT:    paddb %xmm7, %xmm6
; SSE42-NEXT:    pmovzxdq {{.*#+}} xmm0 = xmm6[0],zero,xmm6[1],zero
; SSE42-NEXT:    pxor %xmm6, %xmm6
; SSE42-NEXT:    psadbw %xmm6, %xmm0
; SSE42-NEXT:    movdqa %xmm1, %xmm7
; SSE42-NEXT:    pand %xmm5, %xmm7
; SSE42-NEXT:    movdqa %xmm4, %xmm8
; SSE42-NEXT:    pshufb %xmm7, %xmm8
; SSE42-NEXT:    psrlw $4, %xmm1
; SSE42-NEXT:    pand %xmm5, %xmm1
; SSE42-NEXT:    movdqa %xmm4, %xmm7
; SSE42-NEXT:    pshufb %xmm1, %xmm7
; SSE42-NEXT:    paddb %xmm8, %xmm7
; SSE42-NEXT:    pmovzxdq {{.*#+}} xmm1 = xmm7[0],zero,xmm7[1],zero
; SSE42-NEXT:    psadbw %xmm6, %xmm1
; SSE42-NEXT:    packuswb %xmm1, %xmm0
; SSE42-NEXT:    movdqa %xmm2, %xmm1
; SSE42-NEXT:    pand %xmm5, %xmm1
; SSE42-NEXT:    movdqa %xmm4, %xmm7
; SSE42-NEXT:    pshufb %xmm1, %xmm7
; SSE42-NEXT:    psrlw $4, %xmm2
; SSE42-NEXT:    pand %xmm5, %xmm2
; SSE42-NEXT:    movdqa %xmm4, %xmm1
; SSE42-NEXT:    pshufb %xmm2, %xmm1
; SSE42-NEXT:    paddb %xmm7, %xmm1
; SSE42-NEXT:    pmovzxdq {{.*#+}} xmm1 = xmm1[0],zero,xmm1[1],zero
; SSE42-NEXT:    psadbw %xmm6, %xmm1
; SSE42-NEXT:    movdqa %xmm3, %xmm2
; SSE42-NEXT:    pand %xmm5, %xmm2
; SSE42-NEXT:    movdqa %xmm4, %xmm7
; SSE42-NEXT:    pshufb %xmm2, %xmm7
; SSE42-NEXT:    psrlw $4, %xmm3
; SSE42-NEXT:    pand %xmm5, %xmm3
; SSE42-NEXT:    pshufb %xmm3, %xmm4
; SSE42-NEXT:    paddb %xmm7, %xmm4
; SSE42-NEXT:    pmovzxdq {{.*#+}} xmm2 = xmm4[0],zero,xmm4[1],zero
; SSE42-NEXT:    psadbw %xmm6, %xmm2
; SSE42-NEXT:    packuswb %xmm2, %xmm1
; SSE42-NEXT:    retq
;
; AVX2-LABEL: widen_ctpop_v2i32_v8i32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    # kill: def $xmm1 killed $xmm1 def $ymm1
; AVX2-NEXT:    # kill: def $xmm0 killed $xmm0 def $ymm0
; AVX2-NEXT:    vinserti128 $1, %xmm3, %ymm1, %ymm1
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm3 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm3, %ymm1, %ymm4
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm5 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm5 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm4, %ymm5, %ymm4
; AVX2-NEXT:    vpsrlw $4, %ymm1, %ymm1
; AVX2-NEXT:    vpand %ymm3, %ymm1, %ymm1
; AVX2-NEXT:    vpshufb %ymm1, %ymm5, %ymm1
; AVX2-NEXT:    vpaddb %ymm4, %ymm1, %ymm1
; AVX2-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX2-NEXT:    vpunpckldq {{.*#+}} ymm1 = ymm1[0],ymm4[0],ymm1[1],ymm4[1],ymm1[4],ymm4[4],ymm1[5],ymm4[5]
; AVX2-NEXT:    vpsadbw %ymm4, %ymm1, %ymm1
; AVX2-NEXT:    vinserti128 $1, %xmm2, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm3, %ymm0, %ymm2
; AVX2-NEXT:    vpshufb %ymm2, %ymm5, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm3, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm5, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm4[0],ymm0[1],ymm4[1],ymm0[4],ymm4[4],ymm0[5],ymm4[5]
; AVX2-NEXT:    vpsadbw %ymm4, %ymm0, %ymm0
; AVX2-NEXT:    vpackuswb %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VL-LABEL: widen_ctpop_v2i32_v8i32:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    # kill: def $xmm1 killed $xmm1 def $ymm1
; AVX512VL-NEXT:    # kill: def $xmm0 killed $xmm0 def $ymm0
; AVX512VL-NEXT:    vinserti128 $1, %xmm3, %ymm1, %ymm1
; AVX512VL-NEXT:    vpbroadcastb {{.*#+}} ymm3 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX512VL-NEXT:    vpand %ymm3, %ymm1, %ymm4
; AVX512VL-NEXT:    vbroadcasti128 {{.*#+}} ymm5 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX512VL-NEXT:    # ymm5 = mem[0,1,0,1]
; AVX512VL-NEXT:    vpshufb %ymm4, %ymm5, %ymm4
; AVX512VL-NEXT:    vpsrlw $4, %ymm1, %ymm1
; AVX512VL-NEXT:    vpand %ymm3, %ymm1, %ymm1
; AVX512VL-NEXT:    vpshufb %ymm1, %ymm5, %ymm1
; AVX512VL-NEXT:    vpaddb %ymm4, %ymm1, %ymm1
; AVX512VL-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX512VL-NEXT:    vpunpckldq {{.*#+}} ymm1 = ymm1[0],ymm4[0],ymm1[1],ymm4[1],ymm1[4],ymm4[4],ymm1[5],ymm4[5]
; AVX512VL-NEXT:    vpsadbw %ymm4, %ymm1, %ymm1
; AVX512VL-NEXT:    vinserti128 $1, %xmm2, %ymm0, %ymm0
; AVX512VL-NEXT:    vpand %ymm3, %ymm0, %ymm2
; AVX512VL-NEXT:    vpshufb %ymm2, %ymm5, %ymm2
; AVX512VL-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX512VL-NEXT:    vpand %ymm3, %ymm0, %ymm0
; AVX512VL-NEXT:    vpshufb %ymm0, %ymm5, %ymm0
; AVX512VL-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX512VL-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm4[0],ymm0[1],ymm4[1],ymm0[4],ymm4[4],ymm0[5],ymm4[5]
; AVX512VL-NEXT:    vpsadbw %ymm4, %ymm0, %ymm0
; AVX512VL-NEXT:    vpackuswb %ymm1, %ymm0, %ymm0
; AVX512VL-NEXT:    retq
;
; AVX512VPOPCNT-LABEL: widen_ctpop_v2i32_v8i32:
; AVX512VPOPCNT:       # %bb.0:
; AVX512VPOPCNT-NEXT:    # kill: def $xmm1 killed $xmm1 def $ymm1
; AVX512VPOPCNT-NEXT:    # kill: def $xmm0 killed $xmm0 def $ymm0
; AVX512VPOPCNT-NEXT:    vinserti128 $1, %xmm3, %ymm1, %ymm1
; AVX512VPOPCNT-NEXT:    vinserti128 $1, %xmm2, %ymm0, %ymm0
; AVX512VPOPCNT-NEXT:    vpunpcklqdq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX512VPOPCNT-NEXT:    vpopcntd %ymm0, %ymm0
; AVX512VPOPCNT-NEXT:    retq
  %b0 = call <2 x i32> @llvm.ctpop.v2i32(<2 x i32> %a0)
  %b1 = call <2 x i32> @llvm.ctpop.v2i32(<2 x i32> %a1)
  %b2 = call <2 x i32> @llvm.ctpop.v2i32(<2 x i32> %a2)
  %b3 = call <2 x i32> @llvm.ctpop.v2i32(<2 x i32> %a3)
  %res01 = shufflevector <2 x i32> %b0, <2 x i32> %b1, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %res23 = shufflevector <2 x i32> %b2, <2 x i32> %b3, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %res = shufflevector <4 x i32> %res01, <4 x i32> %res23, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  ret <8 x i32> %res
}

;
; CTLZ
;

define <4 x i32> @widen_ctlz_v2i32_v4i32(<2 x i32> %a0, <2 x i32> %a1) {
; SSE42-LABEL: widen_ctlz_v2i32_v4i32:
; SSE42:       # %bb.0:
; SSE42-NEXT:    movq {{.*#+}} xmm3 = [4,3,2,2,1,1,1,1,0,0,0,0,0,0,0,0]
; SSE42-NEXT:    movdqa %xmm3, %xmm6
; SSE42-NEXT:    pshufb %xmm0, %xmm6
; SSE42-NEXT:    movdqa %xmm0, %xmm5
; SSE42-NEXT:    psrlw $4, %xmm5
; SSE42-NEXT:    movdqa {{.*#+}} xmm4 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; SSE42-NEXT:    pand %xmm4, %xmm5
; SSE42-NEXT:    pxor %xmm2, %xmm2
; SSE42-NEXT:    movdqa %xmm3, %xmm7
; SSE42-NEXT:    pshufb %xmm5, %xmm7
; SSE42-NEXT:    pcmpeqb %xmm2, %xmm5
; SSE42-NEXT:    pand %xmm6, %xmm5
; SSE42-NEXT:    paddb %xmm7, %xmm5
; SSE42-NEXT:    movdqa %xmm0, %xmm6
; SSE42-NEXT:    pcmpeqb %xmm2, %xmm6
; SSE42-NEXT:    psrlw $8, %xmm6
; SSE42-NEXT:    pand %xmm5, %xmm6
; SSE42-NEXT:    psrlw $8, %xmm5
; SSE42-NEXT:    paddw %xmm6, %xmm5
; SSE42-NEXT:    pcmpeqw %xmm2, %xmm0
; SSE42-NEXT:    psrld $16, %xmm0
; SSE42-NEXT:    pand %xmm5, %xmm0
; SSE42-NEXT:    psrld $16, %xmm5
; SSE42-NEXT:    paddd %xmm5, %xmm0
; SSE42-NEXT:    movdqa %xmm3, %xmm6
; SSE42-NEXT:    pshufb %xmm1, %xmm6
; SSE42-NEXT:    movdqa %xmm1, %xmm5
; SSE42-NEXT:    psrlw $4, %xmm5
; SSE42-NEXT:    pand %xmm4, %xmm5
; SSE42-NEXT:    pshufb %xmm5, %xmm3
; SSE42-NEXT:    pcmpeqb %xmm2, %xmm5
; SSE42-NEXT:    pand %xmm6, %xmm5
; SSE42-NEXT:    paddb %xmm3, %xmm5
; SSE42-NEXT:    movdqa %xmm1, %xmm3
; SSE42-NEXT:    pcmpeqb %xmm2, %xmm3
; SSE42-NEXT:    psrlw $8, %xmm3
; SSE42-NEXT:    pand %xmm5, %xmm3
; SSE42-NEXT:    psrlw $8, %xmm5
; SSE42-NEXT:    paddw %xmm3, %xmm5
; SSE42-NEXT:    pcmpeqw %xmm2, %xmm1
; SSE42-NEXT:    psrld $16, %xmm1
; SSE42-NEXT:    pand %xmm5, %xmm1
; SSE42-NEXT:    psrld $16, %xmm5
; SSE42-NEXT:    paddd %xmm1, %xmm5
; SSE42-NEXT:    punpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm5[0]
; SSE42-NEXT:    retq
;
; AVX2-LABEL: widen_ctlz_v2i32_v4i32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovq {{.*#+}} xmm2 = [4,3,2,2,1,1,1,1,0,0,0,0,0,0,0,0]
; AVX2-NEXT:    vpshufb %xmm0, %xmm2, %xmm3
; AVX2-NEXT:    vpsrlw $4, %xmm0, %xmm4
; AVX2-NEXT:    vpbroadcastb {{.*#+}} xmm5 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %xmm5, %xmm4, %xmm4
; AVX2-NEXT:    vpxor %xmm6, %xmm6, %xmm6
; AVX2-NEXT:    vpcmpeqb %xmm6, %xmm4, %xmm7
; AVX2-NEXT:    vpand %xmm7, %xmm3, %xmm3
; AVX2-NEXT:    vpshufb %xmm4, %xmm2, %xmm4
; AVX2-NEXT:    vpaddb %xmm4, %xmm3, %xmm3
; AVX2-NEXT:    vpcmpeqb %xmm6, %xmm0, %xmm4
; AVX2-NEXT:    vpsrlw $8, %xmm4, %xmm4
; AVX2-NEXT:    vpand %xmm4, %xmm3, %xmm4
; AVX2-NEXT:    vpsrlw $8, %xmm3, %xmm3
; AVX2-NEXT:    vpaddw %xmm4, %xmm3, %xmm3
; AVX2-NEXT:    vpcmpeqw %xmm6, %xmm0, %xmm0
; AVX2-NEXT:    vpsrld $16, %xmm0, %xmm0
; AVX2-NEXT:    vpand %xmm0, %xmm3, %xmm0
; AVX2-NEXT:    vpsrld $16, %xmm3, %xmm3
; AVX2-NEXT:    vpaddd %xmm0, %xmm3, %xmm0
; AVX2-NEXT:    vpshufb %xmm1, %xmm2, %xmm3
; AVX2-NEXT:    vpsrlw $4, %xmm1, %xmm4
; AVX2-NEXT:    vpand %xmm5, %xmm4, %xmm4
; AVX2-NEXT:    vpcmpeqb %xmm6, %xmm4, %xmm5
; AVX2-NEXT:    vpand %xmm5, %xmm3, %xmm3
; AVX2-NEXT:    vpshufb %xmm4, %xmm2, %xmm2
; AVX2-NEXT:    vpaddb %xmm2, %xmm3, %xmm2
; AVX2-NEXT:    vpcmpeqb %xmm6, %xmm1, %xmm3
; AVX2-NEXT:    vpsrlw $8, %xmm3, %xmm3
; AVX2-NEXT:    vpand %xmm3, %xmm2, %xmm3
; AVX2-NEXT:    vpsrlw $8, %xmm2, %xmm2
; AVX2-NEXT:    vpaddw %xmm3, %xmm2, %xmm2
; AVX2-NEXT:    vpcmpeqw %xmm6, %xmm1, %xmm1
; AVX2-NEXT:    vpsrld $16, %xmm1, %xmm1
; AVX2-NEXT:    vpand %xmm1, %xmm2, %xmm1
; AVX2-NEXT:    vpsrld $16, %xmm2, %xmm2
; AVX2-NEXT:    vpaddd %xmm1, %xmm2, %xmm1
; AVX2-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; AVX2-NEXT:    retq
;
; AVX512-LABEL: widen_ctlz_v2i32_v4i32:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; AVX512-NEXT:    vplzcntd %xmm0, %xmm0
; AVX512-NEXT:    retq
  %b0 = call <2 x i32> @llvm.ctlz.v2i32(<2 x i32> %a0, i1 0)
  %b1 = call <2 x i32> @llvm.ctlz.v2i32(<2 x i32> %a1, i1 0)
  %res = shufflevector <2 x i32> %b0, <2 x i32> %b1, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  ret <4 x i32> %res
}

define <8 x i32> @widen_ctlz_v4i32_v8i32(<4 x i32> %a0, <4 x i32> %a1) {
; SSE42-LABEL: widen_ctlz_v4i32_v8i32:
; SSE42:       # %bb.0:
; SSE42-NEXT:    movq {{.*#+}} xmm3 = [4,3,2,2,1,1,1,1,0,0,0,0,0,0,0,0]
; SSE42-NEXT:    movdqa %xmm3, %xmm6
; SSE42-NEXT:    pshufb %xmm0, %xmm6
; SSE42-NEXT:    movdqa %xmm0, %xmm5
; SSE42-NEXT:    psrlw $4, %xmm5
; SSE42-NEXT:    movdqa {{.*#+}} xmm4 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; SSE42-NEXT:    pand %xmm4, %xmm5
; SSE42-NEXT:    pxor %xmm2, %xmm2
; SSE42-NEXT:    movdqa %xmm3, %xmm7
; SSE42-NEXT:    pshufb %xmm5, %xmm7
; SSE42-NEXT:    pcmpeqb %xmm2, %xmm5
; SSE42-NEXT:    pand %xmm6, %xmm5
; SSE42-NEXT:    paddb %xmm7, %xmm5
; SSE42-NEXT:    movdqa %xmm0, %xmm6
; SSE42-NEXT:    pcmpeqb %xmm2, %xmm6
; SSE42-NEXT:    psrlw $8, %xmm6
; SSE42-NEXT:    pand %xmm5, %xmm6
; SSE42-NEXT:    psrlw $8, %xmm5
; SSE42-NEXT:    paddw %xmm6, %xmm5
; SSE42-NEXT:    pcmpeqw %xmm2, %xmm0
; SSE42-NEXT:    psrld $16, %xmm0
; SSE42-NEXT:    pand %xmm5, %xmm0
; SSE42-NEXT:    psrld $16, %xmm5
; SSE42-NEXT:    paddd %xmm5, %xmm0
; SSE42-NEXT:    movdqa %xmm3, %xmm5
; SSE42-NEXT:    pshufb %xmm1, %xmm5
; SSE42-NEXT:    movdqa %xmm1, %xmm6
; SSE42-NEXT:    psrlw $4, %xmm6
; SSE42-NEXT:    pand %xmm4, %xmm6
; SSE42-NEXT:    pshufb %xmm6, %xmm3
; SSE42-NEXT:    pcmpeqb %xmm2, %xmm6
; SSE42-NEXT:    pand %xmm5, %xmm6
; SSE42-NEXT:    paddb %xmm3, %xmm6
; SSE42-NEXT:    movdqa %xmm1, %xmm3
; SSE42-NEXT:    pcmpeqb %xmm2, %xmm3
; SSE42-NEXT:    psrlw $8, %xmm3
; SSE42-NEXT:    pand %xmm6, %xmm3
; SSE42-NEXT:    psrlw $8, %xmm6
; SSE42-NEXT:    paddw %xmm3, %xmm6
; SSE42-NEXT:    pcmpeqw %xmm2, %xmm1
; SSE42-NEXT:    psrld $16, %xmm1
; SSE42-NEXT:    pand %xmm6, %xmm1
; SSE42-NEXT:    psrld $16, %xmm6
; SSE42-NEXT:    paddd %xmm6, %xmm1
; SSE42-NEXT:    retq
;
; AVX2-LABEL: widen_ctlz_v4i32_v8i32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    # kill: def $xmm0 killed $xmm0 def $ymm0
; AVX2-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm0
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm1 = [4,3,2,2,1,1,1,1,0,0,0,0,0,0,0,0,4,3,2,2,1,1,1,1,0,0,0,0,0,0,0,0]
; AVX2-NEXT:    # ymm1 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm0, %ymm1, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm3
; AVX2-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm3, %ymm3
; AVX2-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX2-NEXT:    vpcmpeqb %ymm4, %ymm3, %ymm5
; AVX2-NEXT:    vpand %ymm5, %ymm2, %ymm2
; AVX2-NEXT:    vpshufb %ymm3, %ymm1, %ymm1
; AVX2-NEXT:    vpaddb %ymm1, %ymm2, %ymm1
; AVX2-NEXT:    vpcmpeqb %ymm4, %ymm0, %ymm2
; AVX2-NEXT:    vpsrlw $8, %ymm2, %ymm2
; AVX2-NEXT:    vpand %ymm2, %ymm1, %ymm2
; AVX2-NEXT:    vpsrlw $8, %ymm1, %ymm1
; AVX2-NEXT:    vpaddw %ymm2, %ymm1, %ymm1
; AVX2-NEXT:    vpcmpeqw %ymm4, %ymm0, %ymm0
; AVX2-NEXT:    vpsrld $16, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    vpsrld $16, %ymm1, %ymm1
; AVX2-NEXT:    vpaddd %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: widen_ctlz_v4i32_v8i32:
; AVX512:       # %bb.0:
; AVX512-NEXT:    # kill: def $xmm0 killed $xmm0 def $ymm0
; AVX512-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm0
; AVX512-NEXT:    vplzcntd %ymm0, %ymm0
; AVX512-NEXT:    retq
  %b0 = call <4 x i32> @llvm.ctlz.v4i32(<4 x i32> %a0, i1 0)
  %b1 = call <4 x i32> @llvm.ctlz.v4i32(<4 x i32> %a1, i1 0)
  %res = shufflevector <4 x i32> %b0, <4 x i32> %b1, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  ret <8 x i32> %res
}

define <8 x i32> @widen_ctlz_v2i32_v8i32(<2 x i32> %a0, <2 x i32> %a1, <2 x i32> %a2, <2 x i32> %a3) {
; SSE42-LABEL: widen_ctlz_v2i32_v8i32:
; SSE42:       # %bb.0:
; SSE42-NEXT:    movq {{.*#+}} xmm5 = [4,3,2,2,1,1,1,1,0,0,0,0,0,0,0,0]
; SSE42-NEXT:    movdqa %xmm5, %xmm8
; SSE42-NEXT:    pshufb %xmm0, %xmm8
; SSE42-NEXT:    movdqa %xmm0, %xmm7
; SSE42-NEXT:    psrlw $4, %xmm7
; SSE42-NEXT:    movdqa {{.*#+}} xmm6 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; SSE42-NEXT:    pand %xmm6, %xmm7
; SSE42-NEXT:    pxor %xmm4, %xmm4
; SSE42-NEXT:    movdqa %xmm5, %xmm9
; SSE42-NEXT:    pshufb %xmm7, %xmm9
; SSE42-NEXT:    pcmpeqb %xmm4, %xmm7
; SSE42-NEXT:    pand %xmm8, %xmm7
; SSE42-NEXT:    paddb %xmm9, %xmm7
; SSE42-NEXT:    movdqa %xmm0, %xmm8
; SSE42-NEXT:    pcmpeqb %xmm4, %xmm8
; SSE42-NEXT:    psrlw $8, %xmm8
; SSE42-NEXT:    pand %xmm7, %xmm8
; SSE42-NEXT:    psrlw $8, %xmm7
; SSE42-NEXT:    paddw %xmm8, %xmm7
; SSE42-NEXT:    pcmpeqw %xmm4, %xmm0
; SSE42-NEXT:    psrld $16, %xmm0
; SSE42-NEXT:    pand %xmm7, %xmm0
; SSE42-NEXT:    psrld $16, %xmm7
; SSE42-NEXT:    paddd %xmm7, %xmm0
; SSE42-NEXT:    movdqa %xmm5, %xmm8
; SSE42-NEXT:    pshufb %xmm1, %xmm8
; SSE42-NEXT:    movdqa %xmm1, %xmm7
; SSE42-NEXT:    psrlw $4, %xmm7
; SSE42-NEXT:    pand %xmm6, %xmm7
; SSE42-NEXT:    movdqa %xmm5, %xmm9
; SSE42-NEXT:    pshufb %xmm7, %xmm9
; SSE42-NEXT:    pcmpeqb %xmm4, %xmm7
; SSE42-NEXT:    pand %xmm8, %xmm7
; SSE42-NEXT:    paddb %xmm9, %xmm7
; SSE42-NEXT:    movdqa %xmm1, %xmm8
; SSE42-NEXT:    pcmpeqb %xmm4, %xmm8
; SSE42-NEXT:    psrlw $8, %xmm8
; SSE42-NEXT:    pand %xmm7, %xmm8
; SSE42-NEXT:    psrlw $8, %xmm7
; SSE42-NEXT:    paddw %xmm8, %xmm7
; SSE42-NEXT:    pcmpeqw %xmm4, %xmm1
; SSE42-NEXT:    psrld $16, %xmm1
; SSE42-NEXT:    pand %xmm7, %xmm1
; SSE42-NEXT:    psrld $16, %xmm7
; SSE42-NEXT:    paddd %xmm1, %xmm7
; SSE42-NEXT:    punpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm7[0]
; SSE42-NEXT:    movdqa %xmm5, %xmm7
; SSE42-NEXT:    pshufb %xmm2, %xmm7
; SSE42-NEXT:    movdqa %xmm2, %xmm1
; SSE42-NEXT:    psrlw $4, %xmm1
; SSE42-NEXT:    pand %xmm6, %xmm1
; SSE42-NEXT:    movdqa %xmm5, %xmm8
; SSE42-NEXT:    pshufb %xmm1, %xmm8
; SSE42-NEXT:    pcmpeqb %xmm4, %xmm1
; SSE42-NEXT:    pand %xmm7, %xmm1
; SSE42-NEXT:    paddb %xmm8, %xmm1
; SSE42-NEXT:    movdqa %xmm2, %xmm7
; SSE42-NEXT:    pcmpeqb %xmm4, %xmm7
; SSE42-NEXT:    psrlw $8, %xmm7
; SSE42-NEXT:    pand %xmm1, %xmm7
; SSE42-NEXT:    psrlw $8, %xmm1
; SSE42-NEXT:    paddw %xmm7, %xmm1
; SSE42-NEXT:    pcmpeqw %xmm4, %xmm2
; SSE42-NEXT:    psrld $16, %xmm2
; SSE42-NEXT:    pand %xmm1, %xmm2
; SSE42-NEXT:    psrld $16, %xmm1
; SSE42-NEXT:    paddd %xmm2, %xmm1
; SSE42-NEXT:    movdqa %xmm5, %xmm7
; SSE42-NEXT:    pshufb %xmm3, %xmm7
; SSE42-NEXT:    movdqa %xmm3, %xmm2
; SSE42-NEXT:    psrlw $4, %xmm2
; SSE42-NEXT:    pand %xmm6, %xmm2
; SSE42-NEXT:    pshufb %xmm2, %xmm5
; SSE42-NEXT:    pcmpeqb %xmm4, %xmm2
; SSE42-NEXT:    pand %xmm7, %xmm2
; SSE42-NEXT:    paddb %xmm5, %xmm2
; SSE42-NEXT:    movdqa %xmm3, %xmm5
; SSE42-NEXT:    pcmpeqb %xmm4, %xmm5
; SSE42-NEXT:    psrlw $8, %xmm5
; SSE42-NEXT:    pand %xmm2, %xmm5
; SSE42-NEXT:    psrlw $8, %xmm2
; SSE42-NEXT:    paddw %xmm5, %xmm2
; SSE42-NEXT:    pcmpeqw %xmm4, %xmm3
; SSE42-NEXT:    psrld $16, %xmm3
; SSE42-NEXT:    pand %xmm2, %xmm3
; SSE42-NEXT:    psrld $16, %xmm2
; SSE42-NEXT:    paddd %xmm3, %xmm2
; SSE42-NEXT:    punpcklqdq {{.*#+}} xmm1 = xmm1[0],xmm2[0]
; SSE42-NEXT:    retq
;
; AVX2-LABEL: widen_ctlz_v2i32_v8i32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    # kill: def $xmm1 killed $xmm1 def $ymm1
; AVX2-NEXT:    # kill: def $xmm0 killed $xmm0 def $ymm0
; AVX2-NEXT:    vinserti128 $1, %xmm3, %ymm1, %ymm1
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [4,3,2,2,1,1,1,1,0,0,0,0,0,0,0,0,4,3,2,2,1,1,1,1,0,0,0,0,0,0,0,0]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm1, %ymm3, %ymm4
; AVX2-NEXT:    vpsrlw $4, %ymm1, %ymm5
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm6 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm6, %ymm5, %ymm5
; AVX2-NEXT:    vpxor %xmm7, %xmm7, %xmm7
; AVX2-NEXT:    vpcmpeqb %ymm7, %ymm5, %ymm8
; AVX2-NEXT:    vpand %ymm4, %ymm8, %ymm4
; AVX2-NEXT:    vpshufb %ymm5, %ymm3, %ymm5
; AVX2-NEXT:    vpaddb %ymm5, %ymm4, %ymm4
; AVX2-NEXT:    vpcmpeqb %ymm7, %ymm1, %ymm5
; AVX2-NEXT:    vpsrlw $8, %ymm5, %ymm5
; AVX2-NEXT:    vpand %ymm5, %ymm4, %ymm5
; AVX2-NEXT:    vpsrlw $8, %ymm4, %ymm4
; AVX2-NEXT:    vpaddw %ymm5, %ymm4, %ymm4
; AVX2-NEXT:    vpcmpeqw %ymm7, %ymm1, %ymm1
; AVX2-NEXT:    vpsrld $16, %ymm1, %ymm1
; AVX2-NEXT:    vpand %ymm1, %ymm4, %ymm1
; AVX2-NEXT:    vpsrld $16, %ymm4, %ymm4
; AVX2-NEXT:    vpaddd %ymm1, %ymm4, %ymm1
; AVX2-NEXT:    vinserti128 $1, %xmm2, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm4
; AVX2-NEXT:    vpand %ymm6, %ymm4, %ymm4
; AVX2-NEXT:    vpcmpeqb %ymm7, %ymm4, %ymm5
; AVX2-NEXT:    vpand %ymm5, %ymm2, %ymm2
; AVX2-NEXT:    vpshufb %ymm4, %ymm3, %ymm3
; AVX2-NEXT:    vpaddb %ymm3, %ymm2, %ymm2
; AVX2-NEXT:    vpcmpeqb %ymm7, %ymm0, %ymm3
; AVX2-NEXT:    vpsrlw $8, %ymm3, %ymm3
; AVX2-NEXT:    vpand %ymm3, %ymm2, %ymm3
; AVX2-NEXT:    vpsrlw $8, %ymm2, %ymm2
; AVX2-NEXT:    vpaddw %ymm3, %ymm2, %ymm2
; AVX2-NEXT:    vpcmpeqw %ymm7, %ymm0, %ymm0
; AVX2-NEXT:    vpsrld $16, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm0, %ymm2, %ymm0
; AVX2-NEXT:    vpsrld $16, %ymm2, %ymm2
; AVX2-NEXT:    vpaddd %ymm0, %ymm2, %ymm0
; AVX2-NEXT:    vpunpcklqdq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX2-NEXT:    retq
;
; AVX512-LABEL: widen_ctlz_v2i32_v8i32:
; AVX512:       # %bb.0:
; AVX512-NEXT:    # kill: def $xmm1 killed $xmm1 def $ymm1
; AVX512-NEXT:    # kill: def $xmm0 killed $xmm0 def $ymm0
; AVX512-NEXT:    vinserti128 $1, %xmm3, %ymm1, %ymm1
; AVX512-NEXT:    vinserti128 $1, %xmm2, %ymm0, %ymm0
; AVX512-NEXT:    vpunpcklqdq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX512-NEXT:    vplzcntd %ymm0, %ymm0
; AVX512-NEXT:    retq
  %b0 = call <2 x i32> @llvm.ctlz.v2i32(<2 x i32> %a0, i1 0)
  %b1 = call <2 x i32> @llvm.ctlz.v2i32(<2 x i32> %a1, i1 0)
  %b2 = call <2 x i32> @llvm.ctlz.v2i32(<2 x i32> %a2, i1 0)
  %b3 = call <2 x i32> @llvm.ctlz.v2i32(<2 x i32> %a3, i1 0)
  %res01 = shufflevector <2 x i32> %b0, <2 x i32> %b1, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %res23 = shufflevector <2 x i32> %b2, <2 x i32> %b3, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %res = shufflevector <4 x i32> %res01, <4 x i32> %res23, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  ret <8 x i32> %res
}

;
; CTLZ_ZERO_UNDEF
;

define <4 x i32> @widen_ctlz_undef_v2i32_v4i32(<2 x i32> %a0, <2 x i32> %a1) {
; SSE42-LABEL: widen_ctlz_undef_v2i32_v4i32:
; SSE42:       # %bb.0:
; SSE42-NEXT:    movq {{.*#+}} xmm3 = [4,3,2,2,1,1,1,1,0,0,0,0,0,0,0,0]
; SSE42-NEXT:    movdqa %xmm3, %xmm6
; SSE42-NEXT:    pshufb %xmm0, %xmm6
; SSE42-NEXT:    movdqa %xmm0, %xmm5
; SSE42-NEXT:    psrlw $4, %xmm5
; SSE42-NEXT:    movdqa {{.*#+}} xmm4 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; SSE42-NEXT:    pand %xmm4, %xmm5
; SSE42-NEXT:    pxor %xmm2, %xmm2
; SSE42-NEXT:    movdqa %xmm3, %xmm7
; SSE42-NEXT:    pshufb %xmm5, %xmm7
; SSE42-NEXT:    pcmpeqb %xmm2, %xmm5
; SSE42-NEXT:    pand %xmm6, %xmm5
; SSE42-NEXT:    paddb %xmm7, %xmm5
; SSE42-NEXT:    movdqa %xmm0, %xmm6
; SSE42-NEXT:    pcmpeqb %xmm2, %xmm6
; SSE42-NEXT:    psrlw $8, %xmm6
; SSE42-NEXT:    pand %xmm5, %xmm6
; SSE42-NEXT:    psrlw $8, %xmm5
; SSE42-NEXT:    paddw %xmm6, %xmm5
; SSE42-NEXT:    pcmpeqw %xmm2, %xmm0
; SSE42-NEXT:    psrld $16, %xmm0
; SSE42-NEXT:    pand %xmm5, %xmm0
; SSE42-NEXT:    psrld $16, %xmm5
; SSE42-NEXT:    paddd %xmm5, %xmm0
; SSE42-NEXT:    movdqa %xmm3, %xmm6
; SSE42-NEXT:    pshufb %xmm1, %xmm6
; SSE42-NEXT:    movdqa %xmm1, %xmm5
; SSE42-NEXT:    psrlw $4, %xmm5
; SSE42-NEXT:    pand %xmm4, %xmm5
; SSE42-NEXT:    pshufb %xmm5, %xmm3
; SSE42-NEXT:    pcmpeqb %xmm2, %xmm5
; SSE42-NEXT:    pand %xmm6, %xmm5
; SSE42-NEXT:    paddb %xmm3, %xmm5
; SSE42-NEXT:    movdqa %xmm1, %xmm3
; SSE42-NEXT:    pcmpeqb %xmm2, %xmm3
; SSE42-NEXT:    psrlw $8, %xmm3
; SSE42-NEXT:    pand %xmm5, %xmm3
; SSE42-NEXT:    psrlw $8, %xmm5
; SSE42-NEXT:    paddw %xmm3, %xmm5
; SSE42-NEXT:    pcmpeqw %xmm2, %xmm1
; SSE42-NEXT:    psrld $16, %xmm1
; SSE42-NEXT:    pand %xmm5, %xmm1
; SSE42-NEXT:    psrld $16, %xmm5
; SSE42-NEXT:    paddd %xmm1, %xmm5
; SSE42-NEXT:    punpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm5[0]
; SSE42-NEXT:    retq
;
; AVX2-LABEL: widen_ctlz_undef_v2i32_v4i32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovq {{.*#+}} xmm2 = [4,3,2,2,1,1,1,1,0,0,0,0,0,0,0,0]
; AVX2-NEXT:    vpshufb %xmm0, %xmm2, %xmm3
; AVX2-NEXT:    vpsrlw $4, %xmm0, %xmm4
; AVX2-NEXT:    vpbroadcastb {{.*#+}} xmm5 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %xmm5, %xmm4, %xmm4
; AVX2-NEXT:    vpxor %xmm6, %xmm6, %xmm6
; AVX2-NEXT:    vpcmpeqb %xmm6, %xmm4, %xmm7
; AVX2-NEXT:    vpand %xmm7, %xmm3, %xmm3
; AVX2-NEXT:    vpshufb %xmm4, %xmm2, %xmm4
; AVX2-NEXT:    vpaddb %xmm4, %xmm3, %xmm3
; AVX2-NEXT:    vpcmpeqb %xmm6, %xmm0, %xmm4
; AVX2-NEXT:    vpsrlw $8, %xmm4, %xmm4
; AVX2-NEXT:    vpand %xmm4, %xmm3, %xmm4
; AVX2-NEXT:    vpsrlw $8, %xmm3, %xmm3
; AVX2-NEXT:    vpaddw %xmm4, %xmm3, %xmm3
; AVX2-NEXT:    vpcmpeqw %xmm6, %xmm0, %xmm0
; AVX2-NEXT:    vpsrld $16, %xmm0, %xmm0
; AVX2-NEXT:    vpand %xmm0, %xmm3, %xmm0
; AVX2-NEXT:    vpsrld $16, %xmm3, %xmm3
; AVX2-NEXT:    vpaddd %xmm0, %xmm3, %xmm0
; AVX2-NEXT:    vpshufb %xmm1, %xmm2, %xmm3
; AVX2-NEXT:    vpsrlw $4, %xmm1, %xmm4
; AVX2-NEXT:    vpand %xmm5, %xmm4, %xmm4
; AVX2-NEXT:    vpcmpeqb %xmm6, %xmm4, %xmm5
; AVX2-NEXT:    vpand %xmm5, %xmm3, %xmm3
; AVX2-NEXT:    vpshufb %xmm4, %xmm2, %xmm2
; AVX2-NEXT:    vpaddb %xmm2, %xmm3, %xmm2
; AVX2-NEXT:    vpcmpeqb %xmm6, %xmm1, %xmm3
; AVX2-NEXT:    vpsrlw $8, %xmm3, %xmm3
; AVX2-NEXT:    vpand %xmm3, %xmm2, %xmm3
; AVX2-NEXT:    vpsrlw $8, %xmm2, %xmm2
; AVX2-NEXT:    vpaddw %xmm3, %xmm2, %xmm2
; AVX2-NEXT:    vpcmpeqw %xmm6, %xmm1, %xmm1
; AVX2-NEXT:    vpsrld $16, %xmm1, %xmm1
; AVX2-NEXT:    vpand %xmm1, %xmm2, %xmm1
; AVX2-NEXT:    vpsrld $16, %xmm2, %xmm2
; AVX2-NEXT:    vpaddd %xmm1, %xmm2, %xmm1
; AVX2-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; AVX2-NEXT:    retq
;
; AVX512-LABEL: widen_ctlz_undef_v2i32_v4i32:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; AVX512-NEXT:    vplzcntd %xmm0, %xmm0
; AVX512-NEXT:    retq
  %b0 = call <2 x i32> @llvm.ctlz.v2i32(<2 x i32> %a0, i1 1)
  %b1 = call <2 x i32> @llvm.ctlz.v2i32(<2 x i32> %a1, i1 1)
  %res = shufflevector <2 x i32> %b0, <2 x i32> %b1, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  ret <4 x i32> %res
}

define <8 x i32> @widen_ctlz_undef_v4i32_v8i32(<4 x i32> %a0, <4 x i32> %a1) {
; SSE42-LABEL: widen_ctlz_undef_v4i32_v8i32:
; SSE42:       # %bb.0:
; SSE42-NEXT:    movq {{.*#+}} xmm3 = [4,3,2,2,1,1,1,1,0,0,0,0,0,0,0,0]
; SSE42-NEXT:    movdqa %xmm3, %xmm6
; SSE42-NEXT:    pshufb %xmm0, %xmm6
; SSE42-NEXT:    movdqa %xmm0, %xmm5
; SSE42-NEXT:    psrlw $4, %xmm5
; SSE42-NEXT:    movdqa {{.*#+}} xmm4 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; SSE42-NEXT:    pand %xmm4, %xmm5
; SSE42-NEXT:    pxor %xmm2, %xmm2
; SSE42-NEXT:    movdqa %xmm3, %xmm7
; SSE42-NEXT:    pshufb %xmm5, %xmm7
; SSE42-NEXT:    pcmpeqb %xmm2, %xmm5
; SSE42-NEXT:    pand %xmm6, %xmm5
; SSE42-NEXT:    paddb %xmm7, %xmm5
; SSE42-NEXT:    movdqa %xmm0, %xmm6
; SSE42-NEXT:    pcmpeqb %xmm2, %xmm6
; SSE42-NEXT:    psrlw $8, %xmm6
; SSE42-NEXT:    pand %xmm5, %xmm6
; SSE42-NEXT:    psrlw $8, %xmm5
; SSE42-NEXT:    paddw %xmm6, %xmm5
; SSE42-NEXT:    pcmpeqw %xmm2, %xmm0
; SSE42-NEXT:    psrld $16, %xmm0
; SSE42-NEXT:    pand %xmm5, %xmm0
; SSE42-NEXT:    psrld $16, %xmm5
; SSE42-NEXT:    paddd %xmm5, %xmm0
; SSE42-NEXT:    movdqa %xmm3, %xmm5
; SSE42-NEXT:    pshufb %xmm1, %xmm5
; SSE42-NEXT:    movdqa %xmm1, %xmm6
; SSE42-NEXT:    psrlw $4, %xmm6
; SSE42-NEXT:    pand %xmm4, %xmm6
; SSE42-NEXT:    pshufb %xmm6, %xmm3
; SSE42-NEXT:    pcmpeqb %xmm2, %xmm6
; SSE42-NEXT:    pand %xmm5, %xmm6
; SSE42-NEXT:    paddb %xmm3, %xmm6
; SSE42-NEXT:    movdqa %xmm1, %xmm3
; SSE42-NEXT:    pcmpeqb %xmm2, %xmm3
; SSE42-NEXT:    psrlw $8, %xmm3
; SSE42-NEXT:    pand %xmm6, %xmm3
; SSE42-NEXT:    psrlw $8, %xmm6
; SSE42-NEXT:    paddw %xmm3, %xmm6
; SSE42-NEXT:    pcmpeqw %xmm2, %xmm1
; SSE42-NEXT:    psrld $16, %xmm1
; SSE42-NEXT:    pand %xmm6, %xmm1
; SSE42-NEXT:    psrld $16, %xmm6
; SSE42-NEXT:    paddd %xmm6, %xmm1
; SSE42-NEXT:    retq
;
; AVX2-LABEL: widen_ctlz_undef_v4i32_v8i32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    # kill: def $xmm0 killed $xmm0 def $ymm0
; AVX2-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm0
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm1 = [4,3,2,2,1,1,1,1,0,0,0,0,0,0,0,0,4,3,2,2,1,1,1,1,0,0,0,0,0,0,0,0]
; AVX2-NEXT:    # ymm1 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm0, %ymm1, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm3
; AVX2-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm3, %ymm3
; AVX2-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX2-NEXT:    vpcmpeqb %ymm4, %ymm3, %ymm5
; AVX2-NEXT:    vpand %ymm5, %ymm2, %ymm2
; AVX2-NEXT:    vpshufb %ymm3, %ymm1, %ymm1
; AVX2-NEXT:    vpaddb %ymm1, %ymm2, %ymm1
; AVX2-NEXT:    vpcmpeqb %ymm4, %ymm0, %ymm2
; AVX2-NEXT:    vpsrlw $8, %ymm2, %ymm2
; AVX2-NEXT:    vpand %ymm2, %ymm1, %ymm2
; AVX2-NEXT:    vpsrlw $8, %ymm1, %ymm1
; AVX2-NEXT:    vpaddw %ymm2, %ymm1, %ymm1
; AVX2-NEXT:    vpcmpeqw %ymm4, %ymm0, %ymm0
; AVX2-NEXT:    vpsrld $16, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    vpsrld $16, %ymm1, %ymm1
; AVX2-NEXT:    vpaddd %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: widen_ctlz_undef_v4i32_v8i32:
; AVX512:       # %bb.0:
; AVX512-NEXT:    # kill: def $xmm0 killed $xmm0 def $ymm0
; AVX512-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm0
; AVX512-NEXT:    vplzcntd %ymm0, %ymm0
; AVX512-NEXT:    retq
  %b0 = call <4 x i32> @llvm.ctlz.v4i32(<4 x i32> %a0, i1 1)
  %b1 = call <4 x i32> @llvm.ctlz.v4i32(<4 x i32> %a1, i1 1)
  %res = shufflevector <4 x i32> %b0, <4 x i32> %b1, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  ret <8 x i32> %res
}

define <8 x i32> @widen_ctlz_undef_v2i32_v8i32(<2 x i32> %a0, <2 x i32> %a1, <2 x i32> %a2, <2 x i32> %a3) {
; SSE42-LABEL: widen_ctlz_undef_v2i32_v8i32:
; SSE42:       # %bb.0:
; SSE42-NEXT:    movq {{.*#+}} xmm5 = [4,3,2,2,1,1,1,1,0,0,0,0,0,0,0,0]
; SSE42-NEXT:    movdqa %xmm5, %xmm8
; SSE42-NEXT:    pshufb %xmm0, %xmm8
; SSE42-NEXT:    movdqa %xmm0, %xmm7
; SSE42-NEXT:    psrlw $4, %xmm7
; SSE42-NEXT:    movdqa {{.*#+}} xmm6 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; SSE42-NEXT:    pand %xmm6, %xmm7
; SSE42-NEXT:    pxor %xmm4, %xmm4
; SSE42-NEXT:    movdqa %xmm5, %xmm9
; SSE42-NEXT:    pshufb %xmm7, %xmm9
; SSE42-NEXT:    pcmpeqb %xmm4, %xmm7
; SSE42-NEXT:    pand %xmm8, %xmm7
; SSE42-NEXT:    paddb %xmm9, %xmm7
; SSE42-NEXT:    movdqa %xmm0, %xmm8
; SSE42-NEXT:    pcmpeqb %xmm4, %xmm8
; SSE42-NEXT:    psrlw $8, %xmm8
; SSE42-NEXT:    pand %xmm7, %xmm8
; SSE42-NEXT:    psrlw $8, %xmm7
; SSE42-NEXT:    paddw %xmm8, %xmm7
; SSE42-NEXT:    pcmpeqw %xmm4, %xmm0
; SSE42-NEXT:    psrld $16, %xmm0
; SSE42-NEXT:    pand %xmm7, %xmm0
; SSE42-NEXT:    psrld $16, %xmm7
; SSE42-NEXT:    paddd %xmm7, %xmm0
; SSE42-NEXT:    movdqa %xmm5, %xmm8
; SSE42-NEXT:    pshufb %xmm1, %xmm8
; SSE42-NEXT:    movdqa %xmm1, %xmm7
; SSE42-NEXT:    psrlw $4, %xmm7
; SSE42-NEXT:    pand %xmm6, %xmm7
; SSE42-NEXT:    movdqa %xmm5, %xmm9
; SSE42-NEXT:    pshufb %xmm7, %xmm9
; SSE42-NEXT:    pcmpeqb %xmm4, %xmm7
; SSE42-NEXT:    pand %xmm8, %xmm7
; SSE42-NEXT:    paddb %xmm9, %xmm7
; SSE42-NEXT:    movdqa %xmm1, %xmm8
; SSE42-NEXT:    pcmpeqb %xmm4, %xmm8
; SSE42-NEXT:    psrlw $8, %xmm8
; SSE42-NEXT:    pand %xmm7, %xmm8
; SSE42-NEXT:    psrlw $8, %xmm7
; SSE42-NEXT:    paddw %xmm8, %xmm7
; SSE42-NEXT:    pcmpeqw %xmm4, %xmm1
; SSE42-NEXT:    psrld $16, %xmm1
; SSE42-NEXT:    pand %xmm7, %xmm1
; SSE42-NEXT:    psrld $16, %xmm7
; SSE42-NEXT:    paddd %xmm1, %xmm7
; SSE42-NEXT:    punpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm7[0]
; SSE42-NEXT:    movdqa %xmm5, %xmm7
; SSE42-NEXT:    pshufb %xmm2, %xmm7
; SSE42-NEXT:    movdqa %xmm2, %xmm1
; SSE42-NEXT:    psrlw $4, %xmm1
; SSE42-NEXT:    pand %xmm6, %xmm1
; SSE42-NEXT:    movdqa %xmm5, %xmm8
; SSE42-NEXT:    pshufb %xmm1, %xmm8
; SSE42-NEXT:    pcmpeqb %xmm4, %xmm1
; SSE42-NEXT:    pand %xmm7, %xmm1
; SSE42-NEXT:    paddb %xmm8, %xmm1
; SSE42-NEXT:    movdqa %xmm2, %xmm7
; SSE42-NEXT:    pcmpeqb %xmm4, %xmm7
; SSE42-NEXT:    psrlw $8, %xmm7
; SSE42-NEXT:    pand %xmm1, %xmm7
; SSE42-NEXT:    psrlw $8, %xmm1
; SSE42-NEXT:    paddw %xmm7, %xmm1
; SSE42-NEXT:    pcmpeqw %xmm4, %xmm2
; SSE42-NEXT:    psrld $16, %xmm2
; SSE42-NEXT:    pand %xmm1, %xmm2
; SSE42-NEXT:    psrld $16, %xmm1
; SSE42-NEXT:    paddd %xmm2, %xmm1
; SSE42-NEXT:    movdqa %xmm5, %xmm7
; SSE42-NEXT:    pshufb %xmm3, %xmm7
; SSE42-NEXT:    movdqa %xmm3, %xmm2
; SSE42-NEXT:    psrlw $4, %xmm2
; SSE42-NEXT:    pand %xmm6, %xmm2
; SSE42-NEXT:    pshufb %xmm2, %xmm5
; SSE42-NEXT:    pcmpeqb %xmm4, %xmm2
; SSE42-NEXT:    pand %xmm7, %xmm2
; SSE42-NEXT:    paddb %xmm5, %xmm2
; SSE42-NEXT:    movdqa %xmm3, %xmm5
; SSE42-NEXT:    pcmpeqb %xmm4, %xmm5
; SSE42-NEXT:    psrlw $8, %xmm5
; SSE42-NEXT:    pand %xmm2, %xmm5
; SSE42-NEXT:    psrlw $8, %xmm2
; SSE42-NEXT:    paddw %xmm5, %xmm2
; SSE42-NEXT:    pcmpeqw %xmm4, %xmm3
; SSE42-NEXT:    psrld $16, %xmm3
; SSE42-NEXT:    pand %xmm2, %xmm3
; SSE42-NEXT:    psrld $16, %xmm2
; SSE42-NEXT:    paddd %xmm3, %xmm2
; SSE42-NEXT:    punpcklqdq {{.*#+}} xmm1 = xmm1[0],xmm2[0]
; SSE42-NEXT:    retq
;
; AVX2-LABEL: widen_ctlz_undef_v2i32_v8i32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    # kill: def $xmm1 killed $xmm1 def $ymm1
; AVX2-NEXT:    # kill: def $xmm0 killed $xmm0 def $ymm0
; AVX2-NEXT:    vinserti128 $1, %xmm3, %ymm1, %ymm1
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [4,3,2,2,1,1,1,1,0,0,0,0,0,0,0,0,4,3,2,2,1,1,1,1,0,0,0,0,0,0,0,0]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm1, %ymm3, %ymm4
; AVX2-NEXT:    vpsrlw $4, %ymm1, %ymm5
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm6 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm6, %ymm5, %ymm5
; AVX2-NEXT:    vpxor %xmm7, %xmm7, %xmm7
; AVX2-NEXT:    vpcmpeqb %ymm7, %ymm5, %ymm8
; AVX2-NEXT:    vpand %ymm4, %ymm8, %ymm4
; AVX2-NEXT:    vpshufb %ymm5, %ymm3, %ymm5
; AVX2-NEXT:    vpaddb %ymm5, %ymm4, %ymm4
; AVX2-NEXT:    vpcmpeqb %ymm7, %ymm1, %ymm5
; AVX2-NEXT:    vpsrlw $8, %ymm5, %ymm5
; AVX2-NEXT:    vpand %ymm5, %ymm4, %ymm5
; AVX2-NEXT:    vpsrlw $8, %ymm4, %ymm4
; AVX2-NEXT:    vpaddw %ymm5, %ymm4, %ymm4
; AVX2-NEXT:    vpcmpeqw %ymm7, %ymm1, %ymm1
; AVX2-NEXT:    vpsrld $16, %ymm1, %ymm1
; AVX2-NEXT:    vpand %ymm1, %ymm4, %ymm1
; AVX2-NEXT:    vpsrld $16, %ymm4, %ymm4
; AVX2-NEXT:    vpaddd %ymm1, %ymm4, %ymm1
; AVX2-NEXT:    vinserti128 $1, %xmm2, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm4
; AVX2-NEXT:    vpand %ymm6, %ymm4, %ymm4
; AVX2-NEXT:    vpcmpeqb %ymm7, %ymm4, %ymm5
; AVX2-NEXT:    vpand %ymm5, %ymm2, %ymm2
; AVX2-NEXT:    vpshufb %ymm4, %ymm3, %ymm3
; AVX2-NEXT:    vpaddb %ymm3, %ymm2, %ymm2
; AVX2-NEXT:    vpcmpeqb %ymm7, %ymm0, %ymm3
; AVX2-NEXT:    vpsrlw $8, %ymm3, %ymm3
; AVX2-NEXT:    vpand %ymm3, %ymm2, %ymm3
; AVX2-NEXT:    vpsrlw $8, %ymm2, %ymm2
; AVX2-NEXT:    vpaddw %ymm3, %ymm2, %ymm2
; AVX2-NEXT:    vpcmpeqw %ymm7, %ymm0, %ymm0
; AVX2-NEXT:    vpsrld $16, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm0, %ymm2, %ymm0
; AVX2-NEXT:    vpsrld $16, %ymm2, %ymm2
; AVX2-NEXT:    vpaddd %ymm0, %ymm2, %ymm0
; AVX2-NEXT:    vpunpcklqdq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX2-NEXT:    retq
;
; AVX512-LABEL: widen_ctlz_undef_v2i32_v8i32:
; AVX512:       # %bb.0:
; AVX512-NEXT:    # kill: def $xmm1 killed $xmm1 def $ymm1
; AVX512-NEXT:    # kill: def $xmm0 killed $xmm0 def $ymm0
; AVX512-NEXT:    vinserti128 $1, %xmm3, %ymm1, %ymm1
; AVX512-NEXT:    vinserti128 $1, %xmm2, %ymm0, %ymm0
; AVX512-NEXT:    vpunpcklqdq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX512-NEXT:    vplzcntd %ymm0, %ymm0
; AVX512-NEXT:    retq
  %b0 = call <2 x i32> @llvm.ctlz.v2i32(<2 x i32> %a0, i1 1)
  %b1 = call <2 x i32> @llvm.ctlz.v2i32(<2 x i32> %a1, i1 1)
  %b2 = call <2 x i32> @llvm.ctlz.v2i32(<2 x i32> %a2, i1 1)
  %b3 = call <2 x i32> @llvm.ctlz.v2i32(<2 x i32> %a3, i1 1)
  %res01 = shufflevector <2 x i32> %b0, <2 x i32> %b1, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %res23 = shufflevector <2 x i32> %b2, <2 x i32> %b3, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %res = shufflevector <4 x i32> %res01, <4 x i32> %res23, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  ret <8 x i32> %res
}

;
; CTTZ
;

define <4 x i32> @widen_cttz_v2i32_v4i32(<2 x i32> %a0, <2 x i32> %a1) {
; SSE42-LABEL: widen_cttz_v2i32_v4i32:
; SSE42:       # %bb.0:
; SSE42-NEXT:    pcmpeqd %xmm2, %xmm2
; SSE42-NEXT:    movdqa %xmm0, %xmm3
; SSE42-NEXT:    paddd %xmm2, %xmm3
; SSE42-NEXT:    pandn %xmm3, %xmm0
; SSE42-NEXT:    movdqa {{.*#+}} xmm3 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; SSE42-NEXT:    movdqa %xmm0, %xmm4
; SSE42-NEXT:    pand %xmm3, %xmm4
; SSE42-NEXT:    movdqa {{.*#+}} xmm5 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; SSE42-NEXT:    movdqa %xmm5, %xmm6
; SSE42-NEXT:    pshufb %xmm4, %xmm6
; SSE42-NEXT:    psrlw $4, %xmm0
; SSE42-NEXT:    pand %xmm3, %xmm0
; SSE42-NEXT:    movdqa %xmm5, %xmm4
; SSE42-NEXT:    pshufb %xmm0, %xmm4
; SSE42-NEXT:    paddb %xmm6, %xmm4
; SSE42-NEXT:    pmovzxdq {{.*#+}} xmm0 = xmm4[0],zero,xmm4[1],zero
; SSE42-NEXT:    pxor %xmm4, %xmm4
; SSE42-NEXT:    psadbw %xmm4, %xmm0
; SSE42-NEXT:    paddd %xmm1, %xmm2
; SSE42-NEXT:    pandn %xmm2, %xmm1
; SSE42-NEXT:    movdqa %xmm1, %xmm2
; SSE42-NEXT:    pand %xmm3, %xmm2
; SSE42-NEXT:    movdqa %xmm5, %xmm6
; SSE42-NEXT:    pshufb %xmm2, %xmm6
; SSE42-NEXT:    psrlw $4, %xmm1
; SSE42-NEXT:    pand %xmm3, %xmm1
; SSE42-NEXT:    pshufb %xmm1, %xmm5
; SSE42-NEXT:    paddb %xmm6, %xmm5
; SSE42-NEXT:    pmovzxdq {{.*#+}} xmm1 = xmm5[0],zero,xmm5[1],zero
; SSE42-NEXT:    psadbw %xmm4, %xmm1
; SSE42-NEXT:    packuswb %xmm1, %xmm0
; SSE42-NEXT:    retq
;
; AVX2-LABEL: widen_cttz_v2i32_v4i32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpcmpeqd %xmm2, %xmm2, %xmm2
; AVX2-NEXT:    vpaddd %xmm2, %xmm0, %xmm3
; AVX2-NEXT:    vpandn %xmm3, %xmm0, %xmm0
; AVX2-NEXT:    vpbroadcastb {{.*#+}} xmm3 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %xmm3, %xmm0, %xmm4
; AVX2-NEXT:    vmovdqa {{.*#+}} xmm5 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    vpshufb %xmm4, %xmm5, %xmm4
; AVX2-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX2-NEXT:    vpand %xmm3, %xmm0, %xmm0
; AVX2-NEXT:    vpshufb %xmm0, %xmm5, %xmm0
; AVX2-NEXT:    vpaddb %xmm4, %xmm0, %xmm0
; AVX2-NEXT:    vpmovzxdq {{.*#+}} xmm0 = xmm0[0],zero,xmm0[1],zero
; AVX2-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX2-NEXT:    vpsadbw %xmm4, %xmm0, %xmm0
; AVX2-NEXT:    vpaddd %xmm2, %xmm1, %xmm2
; AVX2-NEXT:    vpandn %xmm2, %xmm1, %xmm1
; AVX2-NEXT:    vpand %xmm3, %xmm1, %xmm2
; AVX2-NEXT:    vpshufb %xmm2, %xmm5, %xmm2
; AVX2-NEXT:    vpsrlw $4, %xmm1, %xmm1
; AVX2-NEXT:    vpand %xmm3, %xmm1, %xmm1
; AVX2-NEXT:    vpshufb %xmm1, %xmm5, %xmm1
; AVX2-NEXT:    vpaddb %xmm2, %xmm1, %xmm1
; AVX2-NEXT:    vpmovzxdq {{.*#+}} xmm1 = xmm1[0],zero,xmm1[1],zero
; AVX2-NEXT:    vpsadbw %xmm4, %xmm1, %xmm1
; AVX2-NEXT:    vpackuswb %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    retq
;
; AVX512VL-LABEL: widen_cttz_v2i32_v4i32:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpcmpeqd %xmm2, %xmm2, %xmm2
; AVX512VL-NEXT:    vpaddd %xmm2, %xmm0, %xmm3
; AVX512VL-NEXT:    vpandn %xmm3, %xmm0, %xmm0
; AVX512VL-NEXT:    vpbroadcastd {{.*#+}} xmm3 = [32,32,32,32]
; AVX512VL-NEXT:    vpaddd %xmm2, %xmm1, %xmm2
; AVX512VL-NEXT:    vpandn %xmm2, %xmm1, %xmm1
; AVX512VL-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; AVX512VL-NEXT:    vplzcntd %xmm0, %xmm0
; AVX512VL-NEXT:    vpsubd %xmm0, %xmm3, %xmm0
; AVX512VL-NEXT:    retq
;
; AVX512VPOPCNT-LABEL: widen_cttz_v2i32_v4i32:
; AVX512VPOPCNT:       # %bb.0:
; AVX512VPOPCNT-NEXT:    vpcmpeqd %xmm2, %xmm2, %xmm2
; AVX512VPOPCNT-NEXT:    vpaddd %xmm2, %xmm0, %xmm3
; AVX512VPOPCNT-NEXT:    vpandn %xmm3, %xmm0, %xmm0
; AVX512VPOPCNT-NEXT:    vpaddd %xmm2, %xmm1, %xmm2
; AVX512VPOPCNT-NEXT:    vpandn %xmm2, %xmm1, %xmm1
; AVX512VPOPCNT-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; AVX512VPOPCNT-NEXT:    vpopcntd %xmm0, %xmm0
; AVX512VPOPCNT-NEXT:    retq
  %b0 = call <2 x i32> @llvm.cttz.v2i32(<2 x i32> %a0, i1 0)
  %b1 = call <2 x i32> @llvm.cttz.v2i32(<2 x i32> %a1, i1 0)
  %res = shufflevector <2 x i32> %b0, <2 x i32> %b1, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  ret <4 x i32> %res
}

define <8 x i32> @widen_cttz_v4i32_v8i32(<4 x i32> %a0, <4 x i32> %a1) {
; SSE42-LABEL: widen_cttz_v4i32_v8i32:
; SSE42:       # %bb.0:
; SSE42-NEXT:    pcmpeqd %xmm4, %xmm4
; SSE42-NEXT:    movdqa %xmm0, %xmm2
; SSE42-NEXT:    paddd %xmm4, %xmm2
; SSE42-NEXT:    pandn %xmm2, %xmm0
; SSE42-NEXT:    movdqa {{.*#+}} xmm3 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; SSE42-NEXT:    movdqa %xmm0, %xmm5
; SSE42-NEXT:    pand %xmm3, %xmm5
; SSE42-NEXT:    movdqa {{.*#+}} xmm2 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; SSE42-NEXT:    movdqa %xmm2, %xmm6
; SSE42-NEXT:    pshufb %xmm5, %xmm6
; SSE42-NEXT:    psrlw $4, %xmm0
; SSE42-NEXT:    pand %xmm3, %xmm0
; SSE42-NEXT:    movdqa %xmm2, %xmm5
; SSE42-NEXT:    pshufb %xmm0, %xmm5
; SSE42-NEXT:    paddb %xmm6, %xmm5
; SSE42-NEXT:    pxor %xmm6, %xmm6
; SSE42-NEXT:    pmovzxdq {{.*#+}} xmm0 = xmm5[0],zero,xmm5[1],zero
; SSE42-NEXT:    punpckhdq {{.*#+}} xmm5 = xmm5[2],xmm6[2],xmm5[3],xmm6[3]
; SSE42-NEXT:    psadbw %xmm6, %xmm5
; SSE42-NEXT:    psadbw %xmm6, %xmm0
; SSE42-NEXT:    packuswb %xmm5, %xmm0
; SSE42-NEXT:    paddd %xmm1, %xmm4
; SSE42-NEXT:    pandn %xmm4, %xmm1
; SSE42-NEXT:    movdqa %xmm1, %xmm4
; SSE42-NEXT:    pand %xmm3, %xmm4
; SSE42-NEXT:    movdqa %xmm2, %xmm5
; SSE42-NEXT:    pshufb %xmm4, %xmm5
; SSE42-NEXT:    psrlw $4, %xmm1
; SSE42-NEXT:    pand %xmm3, %xmm1
; SSE42-NEXT:    pshufb %xmm1, %xmm2
; SSE42-NEXT:    paddb %xmm5, %xmm2
; SSE42-NEXT:    pmovzxdq {{.*#+}} xmm1 = xmm2[0],zero,xmm2[1],zero
; SSE42-NEXT:    punpckhdq {{.*#+}} xmm2 = xmm2[2],xmm6[2],xmm2[3],xmm6[3]
; SSE42-NEXT:    psadbw %xmm6, %xmm2
; SSE42-NEXT:    psadbw %xmm6, %xmm1
; SSE42-NEXT:    packuswb %xmm2, %xmm1
; SSE42-NEXT:    retq
;
; AVX2-LABEL: widen_cttz_v4i32_v8i32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    # kill: def $xmm0 killed $xmm0 def $ymm0
; AVX2-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm0
; AVX2-NEXT:    vpcmpeqd %ymm1, %ymm1, %ymm1
; AVX2-NEXT:    vpaddd %ymm1, %ymm0, %ymm1
; AVX2-NEXT:    vpandn %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; AVX2-NEXT:    vpsadbw %ymm1, %ymm2, %ymm2
; AVX2-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; AVX2-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VL-LABEL: widen_cttz_v4i32_v8i32:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    # kill: def $xmm0 killed $xmm0 def $ymm0
; AVX512VL-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm0
; AVX512VL-NEXT:    vpcmpeqd %ymm1, %ymm1, %ymm1
; AVX512VL-NEXT:    vpaddd %ymm1, %ymm0, %ymm1
; AVX512VL-NEXT:    vpandn %ymm1, %ymm0, %ymm0
; AVX512VL-NEXT:    vplzcntd %ymm0, %ymm0
; AVX512VL-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [32,32,32,32,32,32,32,32]
; AVX512VL-NEXT:    vpsubd %ymm0, %ymm1, %ymm0
; AVX512VL-NEXT:    retq
;
; AVX512VPOPCNT-LABEL: widen_cttz_v4i32_v8i32:
; AVX512VPOPCNT:       # %bb.0:
; AVX512VPOPCNT-NEXT:    # kill: def $xmm0 killed $xmm0 def $ymm0
; AVX512VPOPCNT-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm0
; AVX512VPOPCNT-NEXT:    vpcmpeqd %ymm1, %ymm1, %ymm1
; AVX512VPOPCNT-NEXT:    vpaddd %ymm1, %ymm0, %ymm1
; AVX512VPOPCNT-NEXT:    vpandn %ymm1, %ymm0, %ymm0
; AVX512VPOPCNT-NEXT:    vpopcntd %ymm0, %ymm0
; AVX512VPOPCNT-NEXT:    retq
  %b0 = call <4 x i32> @llvm.cttz.v4i32(<4 x i32> %a0, i1 0)
  %b1 = call <4 x i32> @llvm.cttz.v4i32(<4 x i32> %a1, i1 0)
  %res = shufflevector <4 x i32> %b0, <4 x i32> %b1, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  ret <8 x i32> %res
}

define <8 x i32> @widen_cttz_v2i32_v8i32(<2 x i32> %a0, <2 x i32> %a1, <2 x i32> %a2, <2 x i32> %a3) {
; SSE42-LABEL: widen_cttz_v2i32_v8i32:
; SSE42:       # %bb.0:
; SSE42-NEXT:    pcmpeqd %xmm6, %xmm6
; SSE42-NEXT:    movdqa %xmm0, %xmm4
; SSE42-NEXT:    paddd %xmm6, %xmm4
; SSE42-NEXT:    pandn %xmm4, %xmm0
; SSE42-NEXT:    movdqa {{.*#+}} xmm5 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; SSE42-NEXT:    movdqa %xmm0, %xmm7
; SSE42-NEXT:    pand %xmm5, %xmm7
; SSE42-NEXT:    movdqa {{.*#+}} xmm4 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; SSE42-NEXT:    movdqa %xmm4, %xmm8
; SSE42-NEXT:    pshufb %xmm7, %xmm8
; SSE42-NEXT:    psrlw $4, %xmm0
; SSE42-NEXT:    pand %xmm5, %xmm0
; SSE42-NEXT:    movdqa %xmm4, %xmm7
; SSE42-NEXT:    pshufb %xmm0, %xmm7
; SSE42-NEXT:    paddb %xmm8, %xmm7
; SSE42-NEXT:    pmovzxdq {{.*#+}} xmm0 = xmm7[0],zero,xmm7[1],zero
; SSE42-NEXT:    pxor %xmm7, %xmm7
; SSE42-NEXT:    psadbw %xmm7, %xmm0
; SSE42-NEXT:    movdqa %xmm1, %xmm8
; SSE42-NEXT:    paddd %xmm6, %xmm8
; SSE42-NEXT:    pandn %xmm8, %xmm1
; SSE42-NEXT:    movdqa %xmm1, %xmm8
; SSE42-NEXT:    pand %xmm5, %xmm8
; SSE42-NEXT:    movdqa %xmm4, %xmm9
; SSE42-NEXT:    pshufb %xmm8, %xmm9
; SSE42-NEXT:    psrlw $4, %xmm1
; SSE42-NEXT:    pand %xmm5, %xmm1
; SSE42-NEXT:    movdqa %xmm4, %xmm8
; SSE42-NEXT:    pshufb %xmm1, %xmm8
; SSE42-NEXT:    paddb %xmm9, %xmm8
; SSE42-NEXT:    pmovzxdq {{.*#+}} xmm1 = xmm8[0],zero,xmm8[1],zero
; SSE42-NEXT:    psadbw %xmm7, %xmm1
; SSE42-NEXT:    packuswb %xmm1, %xmm0
; SSE42-NEXT:    movdqa %xmm2, %xmm1
; SSE42-NEXT:    paddd %xmm6, %xmm1
; SSE42-NEXT:    pandn %xmm1, %xmm2
; SSE42-NEXT:    movdqa %xmm2, %xmm1
; SSE42-NEXT:    pand %xmm5, %xmm1
; SSE42-NEXT:    movdqa %xmm4, %xmm8
; SSE42-NEXT:    pshufb %xmm1, %xmm8
; SSE42-NEXT:    psrlw $4, %xmm2
; SSE42-NEXT:    pand %xmm5, %xmm2
; SSE42-NEXT:    movdqa %xmm4, %xmm1
; SSE42-NEXT:    pshufb %xmm2, %xmm1
; SSE42-NEXT:    paddb %xmm8, %xmm1
; SSE42-NEXT:    pmovzxdq {{.*#+}} xmm1 = xmm1[0],zero,xmm1[1],zero
; SSE42-NEXT:    psadbw %xmm7, %xmm1
; SSE42-NEXT:    paddd %xmm3, %xmm6
; SSE42-NEXT:    pandn %xmm6, %xmm3
; SSE42-NEXT:    movdqa %xmm3, %xmm2
; SSE42-NEXT:    pand %xmm5, %xmm2
; SSE42-NEXT:    movdqa %xmm4, %xmm6
; SSE42-NEXT:    pshufb %xmm2, %xmm6
; SSE42-NEXT:    psrlw $4, %xmm3
; SSE42-NEXT:    pand %xmm5, %xmm3
; SSE42-NEXT:    pshufb %xmm3, %xmm4
; SSE42-NEXT:    paddb %xmm6, %xmm4
; SSE42-NEXT:    pmovzxdq {{.*#+}} xmm2 = xmm4[0],zero,xmm4[1],zero
; SSE42-NEXT:    psadbw %xmm7, %xmm2
; SSE42-NEXT:    packuswb %xmm2, %xmm1
; SSE42-NEXT:    retq
;
; AVX2-LABEL: widen_cttz_v2i32_v8i32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    # kill: def $xmm1 killed $xmm1 def $ymm1
; AVX2-NEXT:    # kill: def $xmm0 killed $xmm0 def $ymm0
; AVX2-NEXT:    vinserti128 $1, %xmm3, %ymm1, %ymm1
; AVX2-NEXT:    vpcmpeqd %ymm3, %ymm3, %ymm3
; AVX2-NEXT:    vpaddd %ymm3, %ymm1, %ymm4
; AVX2-NEXT:    vpandn %ymm4, %ymm1, %ymm1
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm4 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm4, %ymm1, %ymm5
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm6 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm6 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm5, %ymm6, %ymm5
; AVX2-NEXT:    vpsrlw $4, %ymm1, %ymm1
; AVX2-NEXT:    vpand %ymm4, %ymm1, %ymm1
; AVX2-NEXT:    vpshufb %ymm1, %ymm6, %ymm1
; AVX2-NEXT:    vpaddb %ymm5, %ymm1, %ymm1
; AVX2-NEXT:    vpxor %xmm5, %xmm5, %xmm5
; AVX2-NEXT:    vpunpckldq {{.*#+}} ymm1 = ymm1[0],ymm5[0],ymm1[1],ymm5[1],ymm1[4],ymm5[4],ymm1[5],ymm5[5]
; AVX2-NEXT:    vpsadbw %ymm5, %ymm1, %ymm1
; AVX2-NEXT:    vinserti128 $1, %xmm2, %ymm0, %ymm0
; AVX2-NEXT:    vpaddd %ymm3, %ymm0, %ymm2
; AVX2-NEXT:    vpandn %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm4, %ymm0, %ymm2
; AVX2-NEXT:    vpshufb %ymm2, %ymm6, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm4, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm6, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm5[0],ymm0[1],ymm5[1],ymm0[4],ymm5[4],ymm0[5],ymm5[5]
; AVX2-NEXT:    vpsadbw %ymm5, %ymm0, %ymm0
; AVX2-NEXT:    vpackuswb %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VL-LABEL: widen_cttz_v2i32_v8i32:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    # kill: def $xmm1 killed $xmm1 def $ymm1
; AVX512VL-NEXT:    # kill: def $xmm0 killed $xmm0 def $ymm0
; AVX512VL-NEXT:    vinserti128 $1, %xmm3, %ymm1, %ymm1
; AVX512VL-NEXT:    vpcmpeqd %ymm3, %ymm3, %ymm3
; AVX512VL-NEXT:    vpaddd %ymm3, %ymm1, %ymm4
; AVX512VL-NEXT:    vpandn %ymm4, %ymm1, %ymm1
; AVX512VL-NEXT:    vinserti128 $1, %xmm2, %ymm0, %ymm0
; AVX512VL-NEXT:    vpaddd %ymm3, %ymm0, %ymm2
; AVX512VL-NEXT:    vpandn %ymm2, %ymm0, %ymm0
; AVX512VL-NEXT:    vpunpcklqdq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX512VL-NEXT:    vplzcntd %ymm0, %ymm0
; AVX512VL-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [32,32,32,32,32,32,32,32]
; AVX512VL-NEXT:    vpsubd %ymm0, %ymm1, %ymm0
; AVX512VL-NEXT:    retq
;
; AVX512VPOPCNT-LABEL: widen_cttz_v2i32_v8i32:
; AVX512VPOPCNT:       # %bb.0:
; AVX512VPOPCNT-NEXT:    # kill: def $xmm1 killed $xmm1 def $ymm1
; AVX512VPOPCNT-NEXT:    # kill: def $xmm0 killed $xmm0 def $ymm0
; AVX512VPOPCNT-NEXT:    vinserti128 $1, %xmm3, %ymm1, %ymm1
; AVX512VPOPCNT-NEXT:    vpcmpeqd %ymm3, %ymm3, %ymm3
; AVX512VPOPCNT-NEXT:    vpaddd %ymm3, %ymm1, %ymm4
; AVX512VPOPCNT-NEXT:    vpandn %ymm4, %ymm1, %ymm1
; AVX512VPOPCNT-NEXT:    vinserti128 $1, %xmm2, %ymm0, %ymm0
; AVX512VPOPCNT-NEXT:    vpaddd %ymm3, %ymm0, %ymm2
; AVX512VPOPCNT-NEXT:    vpandn %ymm2, %ymm0, %ymm0
; AVX512VPOPCNT-NEXT:    vpunpcklqdq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX512VPOPCNT-NEXT:    vpopcntd %ymm0, %ymm0
; AVX512VPOPCNT-NEXT:    retq
  %b0 = call <2 x i32> @llvm.cttz.v2i32(<2 x i32> %a0, i1 0)
  %b1 = call <2 x i32> @llvm.cttz.v2i32(<2 x i32> %a1, i1 0)
  %b2 = call <2 x i32> @llvm.cttz.v2i32(<2 x i32> %a2, i1 0)
  %b3 = call <2 x i32> @llvm.cttz.v2i32(<2 x i32> %a3, i1 0)
  %res01 = shufflevector <2 x i32> %b0, <2 x i32> %b1, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %res23 = shufflevector <2 x i32> %b2, <2 x i32> %b3, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %res = shufflevector <4 x i32> %res01, <4 x i32> %res23, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  ret <8 x i32> %res
}

;
; CTTZ_ZERO_UNDEF
;

define <4 x i32> @widen_cttz_undef_v2i32_v4i32(<2 x i32> %a0, <2 x i32> %a1) {
; SSE42-LABEL: widen_cttz_undef_v2i32_v4i32:
; SSE42:       # %bb.0:
; SSE42-NEXT:    pcmpeqd %xmm2, %xmm2
; SSE42-NEXT:    movdqa %xmm0, %xmm3
; SSE42-NEXT:    paddd %xmm2, %xmm3
; SSE42-NEXT:    pandn %xmm3, %xmm0
; SSE42-NEXT:    movdqa {{.*#+}} xmm3 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; SSE42-NEXT:    movdqa %xmm0, %xmm4
; SSE42-NEXT:    pand %xmm3, %xmm4
; SSE42-NEXT:    movdqa {{.*#+}} xmm5 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; SSE42-NEXT:    movdqa %xmm5, %xmm6
; SSE42-NEXT:    pshufb %xmm4, %xmm6
; SSE42-NEXT:    psrlw $4, %xmm0
; SSE42-NEXT:    pand %xmm3, %xmm0
; SSE42-NEXT:    movdqa %xmm5, %xmm4
; SSE42-NEXT:    pshufb %xmm0, %xmm4
; SSE42-NEXT:    paddb %xmm6, %xmm4
; SSE42-NEXT:    pmovzxdq {{.*#+}} xmm0 = xmm4[0],zero,xmm4[1],zero
; SSE42-NEXT:    pxor %xmm4, %xmm4
; SSE42-NEXT:    psadbw %xmm4, %xmm0
; SSE42-NEXT:    paddd %xmm1, %xmm2
; SSE42-NEXT:    pandn %xmm2, %xmm1
; SSE42-NEXT:    movdqa %xmm1, %xmm2
; SSE42-NEXT:    pand %xmm3, %xmm2
; SSE42-NEXT:    movdqa %xmm5, %xmm6
; SSE42-NEXT:    pshufb %xmm2, %xmm6
; SSE42-NEXT:    psrlw $4, %xmm1
; SSE42-NEXT:    pand %xmm3, %xmm1
; SSE42-NEXT:    pshufb %xmm1, %xmm5
; SSE42-NEXT:    paddb %xmm6, %xmm5
; SSE42-NEXT:    pmovzxdq {{.*#+}} xmm1 = xmm5[0],zero,xmm5[1],zero
; SSE42-NEXT:    psadbw %xmm4, %xmm1
; SSE42-NEXT:    packuswb %xmm1, %xmm0
; SSE42-NEXT:    retq
;
; AVX2-LABEL: widen_cttz_undef_v2i32_v4i32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpcmpeqd %xmm2, %xmm2, %xmm2
; AVX2-NEXT:    vpaddd %xmm2, %xmm0, %xmm3
; AVX2-NEXT:    vpandn %xmm3, %xmm0, %xmm0
; AVX2-NEXT:    vpbroadcastb {{.*#+}} xmm3 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %xmm3, %xmm0, %xmm4
; AVX2-NEXT:    vmovdqa {{.*#+}} xmm5 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    vpshufb %xmm4, %xmm5, %xmm4
; AVX2-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX2-NEXT:    vpand %xmm3, %xmm0, %xmm0
; AVX2-NEXT:    vpshufb %xmm0, %xmm5, %xmm0
; AVX2-NEXT:    vpaddb %xmm4, %xmm0, %xmm0
; AVX2-NEXT:    vpmovzxdq {{.*#+}} xmm0 = xmm0[0],zero,xmm0[1],zero
; AVX2-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX2-NEXT:    vpsadbw %xmm4, %xmm0, %xmm0
; AVX2-NEXT:    vpaddd %xmm2, %xmm1, %xmm2
; AVX2-NEXT:    vpandn %xmm2, %xmm1, %xmm1
; AVX2-NEXT:    vpand %xmm3, %xmm1, %xmm2
; AVX2-NEXT:    vpshufb %xmm2, %xmm5, %xmm2
; AVX2-NEXT:    vpsrlw $4, %xmm1, %xmm1
; AVX2-NEXT:    vpand %xmm3, %xmm1, %xmm1
; AVX2-NEXT:    vpshufb %xmm1, %xmm5, %xmm1
; AVX2-NEXT:    vpaddb %xmm2, %xmm1, %xmm1
; AVX2-NEXT:    vpmovzxdq {{.*#+}} xmm1 = xmm1[0],zero,xmm1[1],zero
; AVX2-NEXT:    vpsadbw %xmm4, %xmm1, %xmm1
; AVX2-NEXT:    vpackuswb %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    retq
;
; AVX512VL-LABEL: widen_cttz_undef_v2i32_v4i32:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpcmpeqd %xmm2, %xmm2, %xmm2
; AVX512VL-NEXT:    vpaddd %xmm2, %xmm0, %xmm3
; AVX512VL-NEXT:    vpandn %xmm3, %xmm0, %xmm0
; AVX512VL-NEXT:    vpbroadcastd {{.*#+}} xmm3 = [32,32,32,32]
; AVX512VL-NEXT:    vpaddd %xmm2, %xmm1, %xmm2
; AVX512VL-NEXT:    vpandn %xmm2, %xmm1, %xmm1
; AVX512VL-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; AVX512VL-NEXT:    vplzcntd %xmm0, %xmm0
; AVX512VL-NEXT:    vpsubd %xmm0, %xmm3, %xmm0
; AVX512VL-NEXT:    retq
;
; AVX512VPOPCNT-LABEL: widen_cttz_undef_v2i32_v4i32:
; AVX512VPOPCNT:       # %bb.0:
; AVX512VPOPCNT-NEXT:    vpcmpeqd %xmm2, %xmm2, %xmm2
; AVX512VPOPCNT-NEXT:    vpaddd %xmm2, %xmm0, %xmm3
; AVX512VPOPCNT-NEXT:    vpandn %xmm3, %xmm0, %xmm0
; AVX512VPOPCNT-NEXT:    vpaddd %xmm2, %xmm1, %xmm2
; AVX512VPOPCNT-NEXT:    vpandn %xmm2, %xmm1, %xmm1
; AVX512VPOPCNT-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; AVX512VPOPCNT-NEXT:    vpopcntd %xmm0, %xmm0
; AVX512VPOPCNT-NEXT:    retq
  %b0 = call <2 x i32> @llvm.cttz.v2i32(<2 x i32> %a0, i1 1)
  %b1 = call <2 x i32> @llvm.cttz.v2i32(<2 x i32> %a1, i1 1)
  %res = shufflevector <2 x i32> %b0, <2 x i32> %b1, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  ret <4 x i32> %res
}

define <8 x i32> @widen_cttz_undef_v4i32_v8i32(<4 x i32> %a0, <4 x i32> %a1) {
; SSE42-LABEL: widen_cttz_undef_v4i32_v8i32:
; SSE42:       # %bb.0:
; SSE42-NEXT:    pcmpeqd %xmm4, %xmm4
; SSE42-NEXT:    movdqa %xmm0, %xmm2
; SSE42-NEXT:    paddd %xmm4, %xmm2
; SSE42-NEXT:    pandn %xmm2, %xmm0
; SSE42-NEXT:    movdqa {{.*#+}} xmm3 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; SSE42-NEXT:    movdqa %xmm0, %xmm5
; SSE42-NEXT:    pand %xmm3, %xmm5
; SSE42-NEXT:    movdqa {{.*#+}} xmm2 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; SSE42-NEXT:    movdqa %xmm2, %xmm6
; SSE42-NEXT:    pshufb %xmm5, %xmm6
; SSE42-NEXT:    psrlw $4, %xmm0
; SSE42-NEXT:    pand %xmm3, %xmm0
; SSE42-NEXT:    movdqa %xmm2, %xmm5
; SSE42-NEXT:    pshufb %xmm0, %xmm5
; SSE42-NEXT:    paddb %xmm6, %xmm5
; SSE42-NEXT:    pxor %xmm6, %xmm6
; SSE42-NEXT:    pmovzxdq {{.*#+}} xmm0 = xmm5[0],zero,xmm5[1],zero
; SSE42-NEXT:    punpckhdq {{.*#+}} xmm5 = xmm5[2],xmm6[2],xmm5[3],xmm6[3]
; SSE42-NEXT:    psadbw %xmm6, %xmm5
; SSE42-NEXT:    psadbw %xmm6, %xmm0
; SSE42-NEXT:    packuswb %xmm5, %xmm0
; SSE42-NEXT:    paddd %xmm1, %xmm4
; SSE42-NEXT:    pandn %xmm4, %xmm1
; SSE42-NEXT:    movdqa %xmm1, %xmm4
; SSE42-NEXT:    pand %xmm3, %xmm4
; SSE42-NEXT:    movdqa %xmm2, %xmm5
; SSE42-NEXT:    pshufb %xmm4, %xmm5
; SSE42-NEXT:    psrlw $4, %xmm1
; SSE42-NEXT:    pand %xmm3, %xmm1
; SSE42-NEXT:    pshufb %xmm1, %xmm2
; SSE42-NEXT:    paddb %xmm5, %xmm2
; SSE42-NEXT:    pmovzxdq {{.*#+}} xmm1 = xmm2[0],zero,xmm2[1],zero
; SSE42-NEXT:    punpckhdq {{.*#+}} xmm2 = xmm2[2],xmm6[2],xmm2[3],xmm6[3]
; SSE42-NEXT:    psadbw %xmm6, %xmm2
; SSE42-NEXT:    psadbw %xmm6, %xmm1
; SSE42-NEXT:    packuswb %xmm2, %xmm1
; SSE42-NEXT:    retq
;
; AVX2-LABEL: widen_cttz_undef_v4i32_v8i32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    # kill: def $xmm0 killed $xmm0 def $ymm0
; AVX2-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm0
; AVX2-NEXT:    vpcmpeqd %ymm1, %ymm1, %ymm1
; AVX2-NEXT:    vpaddd %ymm1, %ymm0, %ymm1
; AVX2-NEXT:    vpandn %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; AVX2-NEXT:    vpsadbw %ymm1, %ymm2, %ymm2
; AVX2-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; AVX2-NEXT:    vpsadbw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VL-LABEL: widen_cttz_undef_v4i32_v8i32:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    # kill: def $xmm0 killed $xmm0 def $ymm0
; AVX512VL-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm0
; AVX512VL-NEXT:    vpcmpeqd %ymm1, %ymm1, %ymm1
; AVX512VL-NEXT:    vpaddd %ymm1, %ymm0, %ymm1
; AVX512VL-NEXT:    vpandn %ymm1, %ymm0, %ymm0
; AVX512VL-NEXT:    vplzcntd %ymm0, %ymm0
; AVX512VL-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [32,32,32,32,32,32,32,32]
; AVX512VL-NEXT:    vpsubd %ymm0, %ymm1, %ymm0
; AVX512VL-NEXT:    retq
;
; AVX512VPOPCNT-LABEL: widen_cttz_undef_v4i32_v8i32:
; AVX512VPOPCNT:       # %bb.0:
; AVX512VPOPCNT-NEXT:    # kill: def $xmm0 killed $xmm0 def $ymm0
; AVX512VPOPCNT-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm0
; AVX512VPOPCNT-NEXT:    vpcmpeqd %ymm1, %ymm1, %ymm1
; AVX512VPOPCNT-NEXT:    vpaddd %ymm1, %ymm0, %ymm1
; AVX512VPOPCNT-NEXT:    vpandn %ymm1, %ymm0, %ymm0
; AVX512VPOPCNT-NEXT:    vpopcntd %ymm0, %ymm0
; AVX512VPOPCNT-NEXT:    retq
  %b0 = call <4 x i32> @llvm.cttz.v4i32(<4 x i32> %a0, i1 1)
  %b1 = call <4 x i32> @llvm.cttz.v4i32(<4 x i32> %a1, i1 1)
  %res = shufflevector <4 x i32> %b0, <4 x i32> %b1, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  ret <8 x i32> %res
}

define <8 x i32> @widen_cttz_undef_v2i32_v8i32(<2 x i32> %a0, <2 x i32> %a1, <2 x i32> %a2, <2 x i32> %a3) {
; SSE42-LABEL: widen_cttz_undef_v2i32_v8i32:
; SSE42:       # %bb.0:
; SSE42-NEXT:    pcmpeqd %xmm6, %xmm6
; SSE42-NEXT:    movdqa %xmm0, %xmm4
; SSE42-NEXT:    paddd %xmm6, %xmm4
; SSE42-NEXT:    pandn %xmm4, %xmm0
; SSE42-NEXT:    movdqa {{.*#+}} xmm5 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; SSE42-NEXT:    movdqa %xmm0, %xmm7
; SSE42-NEXT:    pand %xmm5, %xmm7
; SSE42-NEXT:    movdqa {{.*#+}} xmm4 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; SSE42-NEXT:    movdqa %xmm4, %xmm8
; SSE42-NEXT:    pshufb %xmm7, %xmm8
; SSE42-NEXT:    psrlw $4, %xmm0
; SSE42-NEXT:    pand %xmm5, %xmm0
; SSE42-NEXT:    movdqa %xmm4, %xmm7
; SSE42-NEXT:    pshufb %xmm0, %xmm7
; SSE42-NEXT:    paddb %xmm8, %xmm7
; SSE42-NEXT:    pmovzxdq {{.*#+}} xmm0 = xmm7[0],zero,xmm7[1],zero
; SSE42-NEXT:    pxor %xmm7, %xmm7
; SSE42-NEXT:    psadbw %xmm7, %xmm0
; SSE42-NEXT:    movdqa %xmm1, %xmm8
; SSE42-NEXT:    paddd %xmm6, %xmm8
; SSE42-NEXT:    pandn %xmm8, %xmm1
; SSE42-NEXT:    movdqa %xmm1, %xmm8
; SSE42-NEXT:    pand %xmm5, %xmm8
; SSE42-NEXT:    movdqa %xmm4, %xmm9
; SSE42-NEXT:    pshufb %xmm8, %xmm9
; SSE42-NEXT:    psrlw $4, %xmm1
; SSE42-NEXT:    pand %xmm5, %xmm1
; SSE42-NEXT:    movdqa %xmm4, %xmm8
; SSE42-NEXT:    pshufb %xmm1, %xmm8
; SSE42-NEXT:    paddb %xmm9, %xmm8
; SSE42-NEXT:    pmovzxdq {{.*#+}} xmm1 = xmm8[0],zero,xmm8[1],zero
; SSE42-NEXT:    psadbw %xmm7, %xmm1
; SSE42-NEXT:    packuswb %xmm1, %xmm0
; SSE42-NEXT:    movdqa %xmm2, %xmm1
; SSE42-NEXT:    paddd %xmm6, %xmm1
; SSE42-NEXT:    pandn %xmm1, %xmm2
; SSE42-NEXT:    movdqa %xmm2, %xmm1
; SSE42-NEXT:    pand %xmm5, %xmm1
; SSE42-NEXT:    movdqa %xmm4, %xmm8
; SSE42-NEXT:    pshufb %xmm1, %xmm8
; SSE42-NEXT:    psrlw $4, %xmm2
; SSE42-NEXT:    pand %xmm5, %xmm2
; SSE42-NEXT:    movdqa %xmm4, %xmm1
; SSE42-NEXT:    pshufb %xmm2, %xmm1
; SSE42-NEXT:    paddb %xmm8, %xmm1
; SSE42-NEXT:    pmovzxdq {{.*#+}} xmm1 = xmm1[0],zero,xmm1[1],zero
; SSE42-NEXT:    psadbw %xmm7, %xmm1
; SSE42-NEXT:    paddd %xmm3, %xmm6
; SSE42-NEXT:    pandn %xmm6, %xmm3
; SSE42-NEXT:    movdqa %xmm3, %xmm2
; SSE42-NEXT:    pand %xmm5, %xmm2
; SSE42-NEXT:    movdqa %xmm4, %xmm6
; SSE42-NEXT:    pshufb %xmm2, %xmm6
; SSE42-NEXT:    psrlw $4, %xmm3
; SSE42-NEXT:    pand %xmm5, %xmm3
; SSE42-NEXT:    pshufb %xmm3, %xmm4
; SSE42-NEXT:    paddb %xmm6, %xmm4
; SSE42-NEXT:    pmovzxdq {{.*#+}} xmm2 = xmm4[0],zero,xmm4[1],zero
; SSE42-NEXT:    psadbw %xmm7, %xmm2
; SSE42-NEXT:    packuswb %xmm2, %xmm1
; SSE42-NEXT:    retq
;
; AVX2-LABEL: widen_cttz_undef_v2i32_v8i32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    # kill: def $xmm1 killed $xmm1 def $ymm1
; AVX2-NEXT:    # kill: def $xmm0 killed $xmm0 def $ymm0
; AVX2-NEXT:    vinserti128 $1, %xmm3, %ymm1, %ymm1
; AVX2-NEXT:    vpcmpeqd %ymm3, %ymm3, %ymm3
; AVX2-NEXT:    vpaddd %ymm3, %ymm1, %ymm4
; AVX2-NEXT:    vpandn %ymm4, %ymm1, %ymm1
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm4 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX2-NEXT:    vpand %ymm4, %ymm1, %ymm5
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm6 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; AVX2-NEXT:    # ymm6 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm5, %ymm6, %ymm5
; AVX2-NEXT:    vpsrlw $4, %ymm1, %ymm1
; AVX2-NEXT:    vpand %ymm4, %ymm1, %ymm1
; AVX2-NEXT:    vpshufb %ymm1, %ymm6, %ymm1
; AVX2-NEXT:    vpaddb %ymm5, %ymm1, %ymm1
; AVX2-NEXT:    vpxor %xmm5, %xmm5, %xmm5
; AVX2-NEXT:    vpunpckldq {{.*#+}} ymm1 = ymm1[0],ymm5[0],ymm1[1],ymm5[1],ymm1[4],ymm5[4],ymm1[5],ymm5[5]
; AVX2-NEXT:    vpsadbw %ymm5, %ymm1, %ymm1
; AVX2-NEXT:    vinserti128 $1, %xmm2, %ymm0, %ymm0
; AVX2-NEXT:    vpaddd %ymm3, %ymm0, %ymm2
; AVX2-NEXT:    vpandn %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm4, %ymm0, %ymm2
; AVX2-NEXT:    vpshufb %ymm2, %ymm6, %ymm2
; AVX2-NEXT:    vpsrlw $4, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm4, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm0, %ymm6, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm0[0],ymm5[0],ymm0[1],ymm5[1],ymm0[4],ymm5[4],ymm0[5],ymm5[5]
; AVX2-NEXT:    vpsadbw %ymm5, %ymm0, %ymm0
; AVX2-NEXT:    vpackuswb %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VL-LABEL: widen_cttz_undef_v2i32_v8i32:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    # kill: def $xmm1 killed $xmm1 def $ymm1
; AVX512VL-NEXT:    # kill: def $xmm0 killed $xmm0 def $ymm0
; AVX512VL-NEXT:    vinserti128 $1, %xmm3, %ymm1, %ymm1
; AVX512VL-NEXT:    vpcmpeqd %ymm3, %ymm3, %ymm3
; AVX512VL-NEXT:    vpaddd %ymm3, %ymm1, %ymm4
; AVX512VL-NEXT:    vpandn %ymm4, %ymm1, %ymm1
; AVX512VL-NEXT:    vinserti128 $1, %xmm2, %ymm0, %ymm0
; AVX512VL-NEXT:    vpaddd %ymm3, %ymm0, %ymm2
; AVX512VL-NEXT:    vpandn %ymm2, %ymm0, %ymm0
; AVX512VL-NEXT:    vpunpcklqdq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX512VL-NEXT:    vplzcntd %ymm0, %ymm0
; AVX512VL-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [32,32,32,32,32,32,32,32]
; AVX512VL-NEXT:    vpsubd %ymm0, %ymm1, %ymm0
; AVX512VL-NEXT:    retq
;
; AVX512VPOPCNT-LABEL: widen_cttz_undef_v2i32_v8i32:
; AVX512VPOPCNT:       # %bb.0:
; AVX512VPOPCNT-NEXT:    # kill: def $xmm1 killed $xmm1 def $ymm1
; AVX512VPOPCNT-NEXT:    # kill: def $xmm0 killed $xmm0 def $ymm0
; AVX512VPOPCNT-NEXT:    vinserti128 $1, %xmm3, %ymm1, %ymm1
; AVX512VPOPCNT-NEXT:    vpcmpeqd %ymm3, %ymm3, %ymm3
; AVX512VPOPCNT-NEXT:    vpaddd %ymm3, %ymm1, %ymm4
; AVX512VPOPCNT-NEXT:    vpandn %ymm4, %ymm1, %ymm1
; AVX512VPOPCNT-NEXT:    vinserti128 $1, %xmm2, %ymm0, %ymm0
; AVX512VPOPCNT-NEXT:    vpaddd %ymm3, %ymm0, %ymm2
; AVX512VPOPCNT-NEXT:    vpandn %ymm2, %ymm0, %ymm0
; AVX512VPOPCNT-NEXT:    vpunpcklqdq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX512VPOPCNT-NEXT:    vpopcntd %ymm0, %ymm0
; AVX512VPOPCNT-NEXT:    retq
  %b0 = call <2 x i32> @llvm.cttz.v2i32(<2 x i32> %a0, i1 1)
  %b1 = call <2 x i32> @llvm.cttz.v2i32(<2 x i32> %a1, i1 1)
  %b2 = call <2 x i32> @llvm.cttz.v2i32(<2 x i32> %a2, i1 1)
  %b3 = call <2 x i32> @llvm.cttz.v2i32(<2 x i32> %a3, i1 1)
  %res01 = shufflevector <2 x i32> %b0, <2 x i32> %b1, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %res23 = shufflevector <2 x i32> %b2, <2 x i32> %b3, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %res = shufflevector <4 x i32> %res01, <4 x i32> %res23, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  ret <8 x i32> %res
}

declare <2 x i32> @llvm.ctpop.v2i32(<2 x i32>)
declare <4 x i32> @llvm.ctpop.v4i32(<4 x i32>)

declare <2 x i32> @llvm.ctlz.v2i32(<2 x i32>, i1)
declare <4 x i32> @llvm.ctlz.v4i32(<4 x i32>, i1)

declare <2 x i32> @llvm.cttz.v2i32(<2 x i32>, i1)
declare <4 x i32> @llvm.cttz.v4i32(<4 x i32>, i1)
