; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
;RUN: llc < %s -mtriple=riscv64 -mattr=+f -mcpu=sifive-u74 -target-abi=lp64f \
;RUN:   | FileCheck %s --check-prefix=NOFUSION
;RUN: llc < %s -mtriple=riscv64 -mattr=+f,+lui-addi-fusion -mcpu=sifive-u74 \
;RUN:   -target-abi=lp64f | FileCheck %s --check-prefix=FUSION

@.str = private constant [4 x i8] c"%f\0A\00", align 1

define void @foo(i32 signext %0, i32 signext %1) {
; NOFUSION-LABEL: foo:
; NOFUSION:       # %bb.0:
; NOFUSION-NEXT:    lui a0, %hi(.L.str)
; NOFUSION-NEXT:    fcvt.s.w fa0, a1
; NOFUSION-NEXT:    addi a0, a0, %lo(.L.str)
; NOFUSION-NEXT:    tail bar@plt
;
; FUSION-LABEL: foo:
; FUSION:       # %bb.0:
; FUSION-NEXT:    fcvt.s.w fa0, a1
; FUSION-NEXT:    lui a0, %hi(.L.str)
; FUSION-NEXT:    addi a0, a0, %lo(.L.str)
; FUSION-NEXT:    tail bar@plt
  %3 = sitofp i32 %1 to float
  tail call void @bar(i8* getelementptr inbounds ([4 x i8], [4 x i8]* @.str, i64 0, i64 0), float %3)
  ret void
}

declare void @bar(i8*, float)
