<?php
/* Prototype  : int array_unshift(array $array, mixed $var [, mixed ...])
 * Description: Pushes elements onto the beginning of the array 
 * Source code: ext/standard/array.c
*/

/*
 * Testing the behavior of array_unshift() by giving values
 * other than array values for $array argument
*/

echo "*** Testing array_unshift() : unexpected values for \$array argument ***\n";

// Initialise $var argument
$var = 12;

// get a class
class classA
{
  public function __toString() {
    return "Class A object";
  }
}

// heredoc string
$heredoc = <<<EOT
hello world
EOT;

// get a resource variable
$fp = fopen(__FILE__, "r");

// get an unset variable
$unset_var = 10;
unset ($unset_var);

// array of unexpected values to be passed to $array argument
$arrays = array(

       // int data
/*1*/  0,
       1,
       12345,
       -2345,

       // float data
/*5*/  10.5,
       -10.5,
       12.3456789000e10,
       12.3456789000E-10,
       .5,

       // null data
/*10*/ NULL,
       null,

       // boolean data
/*12*/ true,
       false,
       TRUE,
       FALSE,

       // empty data
/*16*/ "",
       '',

       // string data
/*18*/ "string",
       'string',
       $heredoc,

       // object data
/*21*/ new classA(),

       // undefined data
       @$undefined_var,

       // unset data
       @$unset_var,

       // resource variable
/*24*/ $fp
);

// loop through each element of $arrays to test the functionality of array_unshift()
$iterator = 1;
foreach($arrays as $array) {
  echo "\n-- Iteration $iterator --";

  /* with default arguments */
  // returns element count in the resulting array after arguments are pushed to 
  // beginning of the given array
  $temp_array = $array;
  var_dump( array_unshift($temp_array, $var) );

  // dump the resulting array
  var_dump($temp_array);

  /* with optional arguments */
  // returns element count in the resulting array after arguments are pushed to
  // beginning of the given array
  $temp_array = $array;
  var_dump( array_unshift($temp_array, $var, "hello", 'world') );

  // dump the resulting array
  var_dump($temp_array);
  $iterator++;
};

// close the file resource used
fclose($fp);

echo "Done";
?>
