// Code generated by smithy-go-codegen DO NOT EDIT.

package amp

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/amp/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists all scrapers in a customer account, including scrapers being created or
// deleted. You may provide filters to return a more specific list of results.
func (c *Client) ListScrapers(ctx context.Context, params *ListScrapersInput, optFns ...func(*Options)) (*ListScrapersOutput, error) {
	if params == nil {
		params = &ListScrapersInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListScrapers", params, optFns, c.addOperationListScrapersMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListScrapersOutput)
	out.ResultMetadata = metadata
	return out, nil
}

// Represents the input of a ListScrapers operation.
type ListScrapersInput struct {

	// A list of scraper filters.
	Filters map[string][]string

	// Maximum results to return in response (default=100, maximum=1000).
	MaxResults *int32

	// Pagination token to request the next page in a paginated list. This token is
	// obtained from the output of the previous ListScrapers request.
	NextToken *string

	noSmithyDocumentSerde
}

// Represents the output of a ListScrapers operation.
type ListScrapersOutput struct {

	// The list of scrapers, filtered down if a set of filters was provided in the
	// request.
	//
	// This member is required.
	Scrapers []types.ScraperSummary

	// Pagination token to use when requesting the next page in this list.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListScrapersMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListScrapers{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListScrapers{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListScrapers"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListScrapers(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

// ListScrapersAPIClient is a client that implements the ListScrapers operation.
type ListScrapersAPIClient interface {
	ListScrapers(context.Context, *ListScrapersInput, ...func(*Options)) (*ListScrapersOutput, error)
}

var _ ListScrapersAPIClient = (*Client)(nil)

// ListScrapersPaginatorOptions is the paginator options for ListScrapers
type ListScrapersPaginatorOptions struct {
	// Maximum results to return in response (default=100, maximum=1000).
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListScrapersPaginator is a paginator for ListScrapers
type ListScrapersPaginator struct {
	options   ListScrapersPaginatorOptions
	client    ListScrapersAPIClient
	params    *ListScrapersInput
	nextToken *string
	firstPage bool
}

// NewListScrapersPaginator returns a new ListScrapersPaginator
func NewListScrapersPaginator(client ListScrapersAPIClient, params *ListScrapersInput, optFns ...func(*ListScrapersPaginatorOptions)) *ListScrapersPaginator {
	if params == nil {
		params = &ListScrapersInput{}
	}

	options := ListScrapersPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListScrapersPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListScrapersPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListScrapers page.
func (p *ListScrapersPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListScrapersOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	result, err := p.client.ListScrapers(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

func newServiceMetadataMiddleware_opListScrapers(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListScrapers",
	}
}
