/**
 * Furnace Tracker - multi-system chiptune tracker
 * Copyright (C) 2021-2024 tildearrow and contributors
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef _MMC5_H
#define _MMC5_H

#include "../dispatch.h"

class DivPlatformMMC5: public DivDispatch {
  struct Channel: public SharedChannel<signed char> {
    int prevFreq;
    unsigned char duty, sweep;
    bool sweepChanged, furnaceDac, setPos;
    Channel():
      SharedChannel<signed char>(15),
      prevFreq(65535),
      duty(0),
      sweep(8),
      sweepChanged(false),
      furnaceDac(false),
      setPos(false) {}
  };
  Channel chan[5];
  DivDispatchOscBuffer* oscBuf[3];
  bool isMuted[5];
  int dacPeriod, dacRate;
  unsigned int dacPos;
  int dacSample;
  unsigned char sampleBank;
  unsigned char writeOscBuf;
  struct _mmc5* mmc5;
  unsigned char regPool[128];
  
  friend void putDispatchChip(void*,int);
  friend void putDispatchChan(void*,int,int);

  public:
    void acquire(short** buf, size_t len);
    int dispatch(DivCommand c);
    void* getChanState(int chan);
    DivMacroInt* getChanMacroInt(int ch);
    DivDispatchOscBuffer* getOscBuffer(int chan);
    unsigned char* getRegisterPool();
    int getRegisterPoolSize();
    void reset();
    void forceIns();
    void tick(bool sysTick=true);
    void muteChannel(int ch, bool mute);
    bool keyOffAffectsArp(int ch);
    float getPostAmp();
    void setFlags(const DivConfig& flags);
    void notifyInsDeletion(void* ins);
    void poke(unsigned int addr, unsigned short val);
    void poke(std::vector<DivRegWrite>& wlist);
    const char** getRegisterSheet();
    int init(DivEngine* parent, int channels, int sugRate, const DivConfig& flags);
    void quit();
    ~DivPlatformMMC5();
};

#endif
