/*
 * Decompiled with CFR 0.152.
 */
package info.dolezel.fatrat.applet.dialogs;

import info.dolezel.fatrat.applet.data.TransferClass;
import info.dolezel.fatrat.applet.models.QueueModel;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.GroupLayout;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.filechooser.FileFilter;
import org.apache.commons.io.IOUtils;

public class NewTransfer
extends JDialog {
    public static final int RET_CANCEL = 0;
    public static final int RET_OK = 1;
    private JButton cancelButton;
    private JMenuItem jAddFromClipboard;
    private JMenuItem jAddLocalFile;
    private JCheckBox jAddPaused;
    private JButton jAddSpecial;
    private JMenuItem jAddTextFile;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JPopupMenu jPopupAddSpecial;
    private JComboBox jQueue;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JSpinner jSpeedDown;
    private JSpinner jSpeedUp;
    private JTextField jTarget;
    private JComboBox jTransferClass;
    private JTextArea jURLs;
    private JButton okButton;
    private int returnStatus = 0;

    public NewTransfer(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        String cancelName = "cancel";
        InputMap inputMap = this.getRootPane().getInputMap(1);
        inputMap.put(KeyStroke.getKeyStroke(27, 0), cancelName);
        ActionMap actionMap = this.getRootPane().getActionMap();
        actionMap.put(cancelName, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NewTransfer.this.doClose(0);
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                NewTransfer.this.jURLs.requestFocus();
            }
        });
    }

    public int getReturnStatus() {
        return this.returnStatus;
    }

    private void initComponents() {
        this.jPopupAddSpecial = new JPopupMenu();
        this.jAddLocalFile = new JMenuItem();
        this.jAddTextFile = new JMenuItem();
        this.jAddFromClipboard = new JMenuItem();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.jLabel1 = new JLabel();
        this.jQueue = new JComboBox();
        this.jSeparator1 = new JSeparator();
        this.jLabel2 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jURLs = new JTextArea();
        this.jAddSpecial = new JButton();
        this.jLabel3 = new JLabel();
        this.jTarget = new JTextField();
        this.jLabel4 = new JLabel();
        this.jTransferClass = new JComboBox();
        this.jLabel5 = new JLabel();
        this.jLabel6 = new JLabel();
        this.jSpeedDown = new JSpinner();
        this.jSpeedUp = new JSpinner();
        this.jAddPaused = new JCheckBox();
        this.jAddLocalFile.setText("Add local file...");
        this.jAddLocalFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewTransfer.this.jAddLocalFileActionPerformed(evt);
            }
        });
        this.jPopupAddSpecial.add(this.jAddLocalFile);
        this.jAddTextFile.setText("Add text file contents...");
        this.jAddTextFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewTransfer.this.jAddTextFileActionPerformed(evt);
            }
        });
        this.jPopupAddSpecial.add(this.jAddTextFile);
        this.jAddFromClipboard.setText("Add from clipboard");
        this.jAddFromClipboard.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewTransfer.this.jAddFromClipboardActionPerformed(evt);
            }
        });
        this.jPopupAddSpecial.add(this.jAddFromClipboard);
        this.setTitle("New transfer");
        this.setModal(true);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                NewTransfer.this.closeDialog(evt);
            }
        });
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewTransfer.this.okButtonActionPerformed(evt);
            }
        });
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewTransfer.this.cancelButtonActionPerformed(evt);
            }
        });
        this.jLabel1.setText("Queue:");
        this.jQueue.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewTransfer.this.jQueueActionPerformed(evt);
            }
        });
        this.jLabel2.setText("URLs:");
        this.jURLs.setColumns(20);
        this.jURLs.setRows(5);
        this.jScrollPane1.setViewportView(this.jURLs);
        this.jAddSpecial.setText("Add special");
        this.jAddSpecial.setFocusable(false);
        this.jAddSpecial.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                NewTransfer.this.jAddSpecialMousePressed(evt);
            }
        });
        this.jLabel3.setText("Target:");
        this.jLabel4.setText("Download as:");
        this.jLabel5.setText("Max down speed (kB/s):");
        this.jLabel6.setText("Max up speed (kB/s):");
        this.jSpeedDown.setModel(new SpinnerNumberModel((Number)0, Integer.valueOf(0), null, (Number)1));
        this.jSpeedUp.setModel(new SpinnerNumberModel((Number)0, Integer.valueOf(0), null, (Number)1));
        this.jAddPaused.setText("Add paused");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jScrollPane1, GroupLayout.Alignment.LEADING, -1, 402, Short.MAX_VALUE).addComponent(this.jSeparator1, GroupLayout.Alignment.LEADING, -1, 402, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.okButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton)).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jQueue, 0, 339, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jAddSpecial)).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.jLabel6).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jSpeedUp, -2, -1, -2)).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.jLabel5).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSpeedDown, -2, -1, -2))).addGap(18, 18, 18).addComponent(this.jAddPaused)).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel3).addComponent(this.jLabel4)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jTransferClass, 0, 293, Short.MAX_VALUE).addComponent(this.jTarget, -1, 293, Short.MAX_VALUE)))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jQueue, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.jAddSpecial)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 150, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addComponent(this.jTarget, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTransferClass, -2, -1, -2).addComponent(this.jLabel4))).addGroup(layout.createSequentialGroup().addComponent(this.jLabel3).addGap(33, 33, 33))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5).addComponent(this.jSpeedDown, -2, -1, -2).addComponent(this.jAddPaused)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel6).addComponent(this.jSpeedUp, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cancelButton).addComponent(this.okButton)).addContainerGap()));
        this.getRootPane().setDefaultButton(this.okButton);
        this.pack();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.doClose(1);
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.doClose(0);
    }

    private void closeDialog(WindowEvent evt) {
        this.doClose(0);
    }

    private void jAddSpecialMousePressed(MouseEvent evt) {
        this.jPopupAddSpecial.show(evt.getComponent(), evt.getX(), evt.getY());
    }

    private void jAddFromClipboardActionPerformed(ActionEvent evt) {
        try {
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            Transferable tr = clipboard.getContents(this);
            String data = (String)tr.getTransferData(DataFlavor.stringFlavor);
            this.jURLs.setText(data);
        }
        catch (Exception e) {
            this.jURLs.setText("");
        }
    }

    private static void autoAppendText(JTextArea area, String text) {
        String origText = area.getText();
        if (origText != null && !origText.isEmpty() && !origText.endsWith("\n")) {
            text = "\n" + text;
        }
        area.append(text);
    }

    private void jAddLocalFileActionPerformed(ActionEvent evt) {
        JFileChooser chooser = new JFileChooser();
        if (chooser.showOpenDialog(this) != 0) {
            return;
        }
        File selFile = chooser.getSelectedFile();
        if (selFile.length() > 0x100000L) {
            JOptionPane.showMessageDialog(this, "The file is too big. This feature is not designed for file upload.", "Error", 0);
        } else {
            NewTransfer.autoAppendText(this.jURLs, "local://" + selFile.getAbsolutePath());
        }
    }

    private void jAddTextFileActionPerformed(ActionEvent evt) {
        JFileChooser chooser = new JFileChooser();
        chooser.addChoosableFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.getName().toLowerCase().endsWith(".txt");
            }

            @Override
            public String getDescription() {
                return "Text files (*.txt)";
            }
        });
        if (chooser.showOpenDialog(this) != 0) {
            return;
        }
        File selFile = chooser.getSelectedFile();
        try {
            String text = IOUtils.toString((Reader)new FileReader(selFile));
            NewTransfer.autoAppendText(this.jURLs, text);
        }
        catch (IOException ex) {
            JOptionPane.showMessageDialog(this, ex.toString(), "Error", 0);
        }
    }

    private void jQueueActionPerformed(ActionEvent evt) {
        JComboBox cb = (JComboBox)evt.getSource();
        QueueItem item = (QueueItem)cb.getSelectedItem();
        this.jTarget.setText(item.getDefaultDirectory());
    }

    private void doClose(int retStatus) {
        this.returnStatus = retStatus;
        this.setVisible(false);
        this.dispose();
    }

    public void setQueueModel(QueueModel m) {
        for (Object data : m.getData()) {
            Map map = (Map)data;
            this.jQueue.addItem(new QueueItem((String)map.get("name"), (String)map.get("uuid"), (String)map.get("defaultDirectory")));
        }
    }

    public void setTransferClasses(TransferClass[] cls) {
        this.jTransferClass.addItem(new TransferClass("Detect automatically"));
        for (TransferClass c : cls) {
            if (!c.getMode().equals("Download")) continue;
            this.jTransferClass.addItem(c);
        }
    }

    public String[] getURLs() {
        return this.jURLs.getText().split("\\s+");
    }

    public String getQueueUUID() {
        return ((QueueItem)this.jQueue.getSelectedItem()).getUuid();
    }

    public String getTransferClass() {
        String c = ((TransferClass)this.jTransferClass.getSelectedItem()).getShortName();
        if (c == null) {
            return "";
        }
        return c;
    }

    public String getTargetDirectory() {
        return this.jTarget.getText();
    }

    public boolean addPaused() {
        return this.jAddPaused.isSelected();
    }

    public int getDownSpeedLimit() {
        return ((Number)this.jSpeedDown.getValue()).intValue();
    }

    public int getUpSpeedLimit() {
        return ((Number)this.jSpeedUp.getValue()).intValue();
    }

    private static class QueueItem {
        String name;
        String uuid;
        String defaultDirectory;

        public QueueItem(String name, String uuid, String defaultDirectory) {
            this.name = name;
            this.uuid = uuid;
            this.defaultDirectory = defaultDirectory;
        }

        public String getName() {
            return this.name;
        }

        public String getUuid() {
            return this.uuid;
        }

        public String getDefaultDirectory() {
            return this.defaultDirectory;
        }

        public String toString() {
            return this.name;
        }
    }
}

