/*
 * Decompiled with CFR 0.152.
 */
package org.emboss.jemboss.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import org.emboss.jemboss.editor.AlignJFrame;
import org.emboss.jemboss.editor.Matrix;
import org.emboss.jemboss.gui.filetree.FileEditorDisplay;

public class MatrixJFrame
extends JFrame {
    private JScrollPane mScroll = new JScrollPane();
    private Cursor cbusy = new Cursor(3);
    private Cursor cdone = new Cursor(0);
    private Matrix mat;

    public MatrixJFrame(Matrix m, final JTextField statusField, AlignJFrame alignFrame) {
        this.mat = m;
        JPanel mainPane = (JPanel)this.getContentPane();
        mainPane.setLayout(new BorderLayout());
        mainPane.add((Component)this.mScroll, "Center");
        JMenuBar menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu("File");
        fileMenu.setMnemonic(70);
        fileMenu.add(new JSeparator());
        JMenuItem fileMenuExit = new JMenuItem("Close");
        fileMenuExit.setAccelerator(KeyStroke.getKeyStroke(69, 2));
        fileMenuExit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MatrixJFrame.this.setVisible(false);
            }
        });
        fileMenu.add(fileMenuExit);
        menuBar.add(fileMenu);
        this.setJMenuBar(menuBar);
        Object[] matKeys = this.mat.getKeyNames();
        final JList<Object> list = new JList<Object>(matKeys);
        MouseAdapter mouseListener = new MouseAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() < 2) {
                    return;
                }
                MatrixJFrame.this.setCursor(MatrixJFrame.this.cbusy);
                try {
                    String selMat = (String)list.getSelectedValue();
                    MatrixJFrame.this.mat.changeMatrix(selMat);
                    statusField.setText("Current matrix: " + selMat);
                    MatrixJFrame.this.setMatrix(MatrixJFrame.this.mat);
                }
                finally {
                    MatrixJFrame.this.setCursor(MatrixJFrame.this.cdone);
                }
            }
        };
        list.addMouseListener(mouseListener);
        JScrollPane jspList = new JScrollPane(list);
        JPanel jp = new JPanel(new BorderLayout());
        jp.add((Component)jspList, "Center");
        JButton matButt = new JButton("Set");
        matButt.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent e) {
                MatrixJFrame.this.setCursor(MatrixJFrame.this.cbusy);
                try {
                    String selMat = (String)list.getSelectedValue();
                    MatrixJFrame.this.mat.changeMatrix(selMat);
                    statusField.setText("Current matrix: " + selMat);
                    MatrixJFrame.this.setMatrix(MatrixJFrame.this.mat);
                }
                finally {
                    MatrixJFrame.this.setCursor(MatrixJFrame.this.cdone);
                }
            }
        });
        jp.add((Component)matButt, "South");
        mainPane.add((Component)jp, "East");
        this.setSize(500, 400);
    }

    public void setMatrix(Matrix mat) {
        FileEditorDisplay fed = new FileEditorDisplay("Matrix", (Object)mat.getMatrixTable().trim());
        fed.setCaretPosition(0);
        this.mScroll.setViewportView(fed);
        this.setTitle(mat.getCurrentMatrixName());
    }
}

