﻿// <auto-generated />

using System;
using System.Reflection;
using System.Resources;
using System.Threading;
using Microsoft.EntityFrameworkCore.Diagnostics;
using Microsoft.EntityFrameworkCore.Internal;
using Microsoft.Extensions.Logging;

#nullable enable

namespace Microsoft.EntityFrameworkCore.Cosmos.Internal
{
    /// <summary>
    ///     This is an internal API that supports the Entity Framework Core infrastructure and not subject to
    ///     the same compatibility standards as public APIs. It may be changed or removed without notice in
    ///     any release. You should only use it directly in your code with extreme caution and knowing that
    ///     doing so can result in application failures when updating to a new Entity Framework Core release.
    /// </summary>
    public static class CosmosStrings
    {
        private static readonly ResourceManager _resourceManager
            = new ResourceManager("Microsoft.EntityFrameworkCore.Cosmos.Properties.CosmosStrings", typeof(CosmosStrings).Assembly);

        /// <summary>
        ///     The time to live for analytical store was configured to '{ttl1}' on '{entityType1}', but on '{entityType2}' it was configured to '{ttl2}'. All entity types mapped to the same container '{container}' must be configured with the same time to live for analytical store.
        /// </summary>
        public static string AnalyticalTTLMismatch(object? ttl1, object? entityType1, object? entityType2, object? ttl2, object? container)
            => string.Format(
                GetString("AnalyticalTTLMismatch", nameof(ttl1), nameof(entityType1), nameof(entityType2), nameof(ttl2), nameof(container)),
                ttl1, entityType1, entityType2, ttl2, container);

        /// <summary>
        ///     The type '{givenType}' cannot be mapped as a dictionary because it does not implement '{dictionaryType}'.
        /// </summary>
        public static string BadDictionaryType(object? givenType, object? dictionaryType)
            => string.Format(
                GetString("BadDictionaryType", nameof(givenType), nameof(dictionaryType)),
                givenType, dictionaryType);

        /// <summary>
        ///     The type '{clrType}' is being used as a vector, but the vector data type cannot be inferred. Only 'ReadOnlyMemory&lt;byte&gt;, ReadOnlyMemory&lt;sbyte&gt;, ReadOnlyMemory&lt;float&gt;, byte[], sbyte[], and float[] are supported.
        /// </summary>
        public static string BadVectorDataType(object? clrType)
            => string.Format(
                GetString("BadVectorDataType", nameof(clrType)),
                clrType);

        /// <summary>
        ///     The Cosmos database does not support 'CanConnect' or 'CanConnectAsync'.
        /// </summary>
        public static string CanConnectNotSupported
            => GetString("CanConnectNotSupported");

        /// <summary>
        ///     A vector index on '{entityType}' is defined over properties `{properties}`. A vector index can only target a single property.
        /// </summary>
        public static string CompositeVectorIndex(object? entityType, object? properties)
            => string.Format(
                GetString("CompositeVectorIndex", nameof(entityType), nameof(properties)),
                entityType, properties);

        /// <summary>
        ///     Complex projections in subqueries are currently unsupported.
        /// </summary>
        public static string ComplexProjectionInSubqueryNotSupported
            => GetString("ComplexProjectionInSubqueryNotSupported");

        /// <summary>
        ///     None of connection string, CredentialToken, account key or account endpoint were specified. Specify a set of connection details.
        /// </summary>
        public static string ConnectionInfoMissing
            => GetString("ConnectionInfoMissing");

        /// <summary>
        ///     The entity type '{entityType}' is mapped to the container '{container}' but it is also configured as being contained in property '{property}'.
        /// </summary>
        public static string ContainerContainingPropertyConflict(object? entityType, object? container, object? property)
            => string.Format(
                GetString("ContainerContainingPropertyConflict", nameof(entityType), nameof(container), nameof(property)),
                entityType, container, property);

        /// <summary>
        ///     An Azure Cosmos DB container name is defined on entity type '{entityType}', which inherits from '{baseEntityType}'. Container names must be defined on the root entity type of a hierarchy.
        /// </summary>
        public static string ContainerNotOnRoot(object? entityType, object? baseEntityType)
            => string.Format(
                GetString("ContainerNotOnRoot", nameof(entityType), nameof(baseEntityType)),
                entityType, baseEntityType);

        /// <summary>
        ///     Cosmos-specific methods can only be used when the context is using the Cosmos provider.
        /// </summary>
        public static string CosmosNotInUse
            => GetString("CosmosNotInUse");

        /// <summary>
        ///     Joins across documents aren't supported in Cosmos; consider modeling your data differently so that related data is in the same document. Alternatively, perform two separate queries to query the two documents.
        /// </summary>
        public static string CrossDocumentJoinNotSupported
            => GetString("CrossDocumentJoinNotSupported");

        /// <summary>
        ///     The default time to live was configured to '{ttl1}' on '{entityType1}', but on '{entityType2}' it was configured to '{ttl2}'. All entity types mapped to the same container '{container}' must be configured with the same default time to live.
        /// </summary>
        public static string DefaultTTLMismatch(object? ttl1, object? entityType1, object? entityType2, object? ttl2, object? container)
            => string.Format(
                GetString("DefaultTTLMismatch", nameof(ttl1), nameof(entityType1), nameof(entityType2), nameof(ttl2), nameof(container)),
                ttl1, entityType1, entityType2, ttl2, container);

        /// <summary>
        ///     'HasDiscriminatorInJsonId' or 'HasRootDiscriminatorInJsonId' was called on a non-root entity type '{entityType}'. Discriminator configuration for the JSON 'id' property can only be made on the document root.
        /// </summary>
        public static string DiscriminatorInKeyOnNonRoot(object? entityType)
            => string.Format(
                GetString("DiscriminatorInKeyOnNonRoot", nameof(entityType)),
                entityType);

        /// <summary>
        ///     The discriminator value for '{entityType1}' is '{discriminatorValue}' which is the same for '{entityType2}'. Every concrete entity type mapped to the container '{container}' must have a unique discriminator value.
        /// </summary>
        public static string DuplicateDiscriminatorValue(object? entityType1, object? discriminatorValue, object? entityType2, object? container)
            => string.Format(
                GetString("DuplicateDiscriminatorValue", nameof(entityType1), nameof(discriminatorValue), nameof(entityType2), nameof(container)),
                entityType1, discriminatorValue, entityType2, container);

        /// <summary>
        ///     The property '{propertyType} {structuralType}.{property}' has element type '{elementType}', which requires a value converter. Elements types requiring value converters are not currently supported with the Azure Cosmos DB database provider.
        /// </summary>
        public static string ElementWithValueConverter(object? propertyType, object? structuralType, object? property, object? elementType)
            => string.Format(
                GetString("ElementWithValueConverter", nameof(propertyType), nameof(structuralType), nameof(property), nameof(elementType)),
                propertyType, structuralType, property, elementType);

        /// <summary>
        ///     The type of the etag property '{property}' on '{entityType}' is '{propertyType}'. All etag properties must be strings or have a string value converter.
        /// </summary>
        public static string ETagNonStringStoreType(object? property, object? entityType, object? propertyType)
            => string.Format(
                GetString("ETagNonStringStoreType", nameof(property), nameof(entityType), nameof(propertyType)),
                property, entityType, propertyType);

        /// <summary>
        ///     The 'Except()' LINQ operator isn't supported by Cosmos.
        /// </summary>
        public static string ExceptNotSupported
            => GetString("ExceptNotSupported");

        /// <summary>
        ///     'HasShadowId' was called on a non-root entity type '{entityType}'. JSON 'id' configuration can only be made on the document root.
        /// </summary>
        public static string HasShadowIdOnNonRoot(object? entityType)
            => string.Format(
                GetString("HasShadowIdOnNonRoot", nameof(entityType)),
                entityType);

        /// <summary>
        ///     The type of the '{idProperty}' property on '{entityType}' is '{propertyType}'. All 'id' properties must be strings or have a string value converter.
        /// </summary>
        public static string IdNonStringStoreType(object? idProperty, object? entityType, object? propertyType)
            => string.Format(
                GetString("IdNonStringStoreType", nameof(idProperty), nameof(entityType), nameof(propertyType)),
                idProperty, entityType, propertyType);

        /// <summary>
        ///     The entity type '{entityType}' has an index defined over properties '{properties}'. The Azure Cosmos DB provider for EF Core currently does not support index definitions.
        /// </summary>
        public static string IndexesExist(object? entityType, object? properties)
            => string.Format(
                GetString("IndexesExist", nameof(entityType), nameof(properties)),
                entityType, properties);

        /// <summary>
        ///     The specified entity type '{derivedType}' is not derived from '{entityType}'.
        /// </summary>
        public static string InvalidDerivedTypeInEntityProjection(object? derivedType, object? entityType)
            => string.Format(
                GetString("InvalidDerivedTypeInEntityProjection", nameof(derivedType), nameof(entityType)),
                derivedType, entityType);

        /// <summary>
        ///     A FromSqlExpression has an invalid arguments expression type '{expressionType}' or value type '{valueType}'.
        /// </summary>
        public static string InvalidFromSqlArguments(object? expressionType, object? valueType)
            => string.Format(
                GetString("InvalidFromSqlArguments", nameof(expressionType), nameof(valueType)),
                expressionType, valueType);

        /// <summary>
        ///     Unable to generate a valid 'id' value to execute a 'ReadItem' query. This usually happens when the value provided for one of the properties is 'null' or an empty string. Please supply a value that's not 'null' or an empty string.
        /// </summary>
        public static string InvalidResourceId
            => GetString("InvalidResourceId");

        /// <summary>
        ///     The IsDiscriminatorMappingComplete setting was configured to '{isDiscriminatorMappingComplete1}' on '{entityType1}', but on '{entityType2}' it was configured to '{isDiscriminatorMappingComplete2}'. All entity types mapped to the same container '{container}' must be configured with the same IsDiscriminatorMappingComplete value.
        /// </summary>
        public static string IsDiscriminatorMappingCompleteMismatch(object? isDiscriminatorMappingComplete1, object? entityType1, object? entityType2, object? isDiscriminatorMappingComplete2, object? container)
            => string.Format(
                GetString("IsDiscriminatorMappingCompleteMismatch", nameof(isDiscriminatorMappingComplete1), nameof(entityType1), nameof(entityType2), nameof(isDiscriminatorMappingComplete2), nameof(container)),
                isDiscriminatorMappingComplete1, entityType1, entityType2, isDiscriminatorMappingComplete2, container);

        /// <summary>
        ///     Both properties '{property1}' and '{property2}' on entity type '{entityType}' are mapped to '{storeName}'. Map one of the properties to a different JSON property.
        /// </summary>
        public static string JsonPropertyCollision(object? property1, object? property2, object? entityType, object? storeName)
            => string.Format(
                GetString("JsonPropertyCollision", nameof(property1), nameof(property2), nameof(entityType), nameof(storeName)),
                property1, property2, entityType, storeName);

        /// <summary>
        ///     The query requires use of LIMIT and OFFSET in a subquery, which is unsupported by Cosmos.
        /// </summary>
        public static string LimitOffsetNotSupportedInSubqueries
            => GetString("LimitOffsetNotSupportedInSubqueries");

        /// <summary>
        ///     'Reverse' could not be translated to the server because there is no ordering on the server side.
        /// </summary>
        public static string MissingOrderingInSelectExpression
            => GetString("MissingOrderingInSelectExpression");

        /// <summary>
        ///     Root entity type '{entityType1}' is referenced by the query, but '{entityType2}' is already being referenced. A query can only reference a single root entity type.
        /// </summary>
        public static string MultipleRootEntityTypesReferencedInQuery(object? entityType1, object? entityType2)
            => string.Format(
                GetString("MultipleRootEntityTypesReferencedInQuery", nameof(entityType1), nameof(entityType2)),
                entityType1, entityType2);

        /// <summary>
        ///     Navigation '{entityType}.{navigationName}' doesn't point to an embedded entity.
        /// </summary>
        public static string NavigationPropertyIsNotAnEmbeddedEntity(object? entityType, object? navigationName)
            => string.Format(
                GetString("NavigationPropertyIsNotAnEmbeddedEntity", nameof(entityType), nameof(navigationName)),
                entityType, navigationName);

        /// <summary>
        ///     The entity type '{entityType}' is sharing the container '{container}' with other types, but does not have a discriminator property configured. Configure a discriminator property and assign a unique value for this entity type.
        /// </summary>
        public static string NoDiscriminatorProperty(object? entityType, object? container)
            => string.Format(
                GetString("NoDiscriminatorProperty", nameof(entityType), nameof(container)),
                entityType, container);

        /// <summary>
        ///     The entity type '{entityType}' is sharing the container '{container}' with other types, but does not have a discriminator value configured. Configure a unique discriminator value for this entity type.
        /// </summary>
        public static string NoDiscriminatorValue(object? entityType, object? container)
            => string.Format(
                GetString("NoDiscriminatorValue", nameof(entityType), nameof(container)),
                entityType, container);

        /// <summary>
        ///     The entity type '{entityType}' does not have a property mapped to the 'id' property in the database. Add a property mapped to 'id'.
        /// </summary>
        public static string NoIdProperty(object? entityType)
            => string.Format(
                GetString("NoIdProperty", nameof(entityType)),
                entityType);

        /// <summary>
        ///     Cosmos subqueries must be correlated, referencing values from the outer query.
        /// </summary>
        public static string NonCorrelatedSubqueriesNotSupported
            => GetString("NonCorrelatedSubqueriesNotSupported");

        /// <summary>
        ///     Including navigation '{navigation}' is not supported as the navigation is not embedded in same resource.
        /// </summary>
        public static string NonEmbeddedIncludeNotSupported(object? navigation)
            => string.Format(
                GetString("NonEmbeddedIncludeNotSupported", nameof(navigation)),
                navigation);

        /// <summary>
        ///     The entity type '{entityType}' has property '{property}' configured as a concurrency token, but only a property mapped to '_etag' is supported as a concurrency token. Consider using 'PropertyBuilder.IsETagConcurrency'.
        /// </summary>
        public static string NonETagConcurrencyToken(object? entityType, object? property)
            => string.Format(
                GetString("NonETagConcurrencyToken", nameof(entityType), nameof(property)),
                entityType, property);

        /// <summary>
        ///     The partition key properties for entity type '{entityType1}' are '{props1}', while the partition key properties for entity type '{entityType2}' are '{props2}', and both entity types are mapped to the container '{containerName}'. All entity types mapped to the same container must have compatible partition keys defined.
        /// </summary>
        public static string NoPartitionKey(object? entityType1, object? props1, object? entityType2, object? props2, object? containerName)
            => string.Format(
                GetString("NoPartitionKey", nameof(entityType1), nameof(props1), nameof(entityType2), nameof(props2), nameof(containerName)),
                entityType1, props1, entityType2, props2, containerName);

        /// <summary>
        ///     There is no string-based representation of this query as it's executed using 'ReadItemQueryAsync({resourceId}, {partitionKey})'.
        /// </summary>
        public static string NoReadItemQueryString(object? resourceId, object? partitionKey)
            => string.Format(
                GetString("NoReadItemQueryString", nameof(resourceId), nameof(partitionKey)),
                resourceId, partitionKey);

        /// <summary>
        ///     Azure Cosmos DB does not have an appropriate subquery for this translation.
        /// </summary>
        public static string NoSubqueryPushdown
            => GetString("NoSubqueryPushdown");

        /// <summary>
        ///     The expression '{sqlExpression}' in the SQL tree does not have a type mapping assigned.
        /// </summary>
        public static string NullTypeMappingInSqlTree(object? sqlExpression)
            => string.Format(
                GetString("NullTypeMappingInSqlTree", nameof(sqlExpression)),
                sqlExpression);

        /// <summary>
        ///     Cosmos SQL does not allow Offset without Limit. Consider specifying a 'Take' operation on the query.
        /// </summary>
        public static string OffsetRequiresLimit
            => GetString("OffsetRequiresLimit");

        /// <summary>
        ///     Exactly one of '{param1}' or '{param2}' must be set.
        /// </summary>
        public static string OneOfTwoValuesMustBeSet(object? param1, object? param2)
            => string.Format(
                GetString("OneOfTwoValuesMustBeSet", nameof(param1), nameof(param2)),
                param1, param2);

        /// <summary>
        ///     Ordering based on scoring function is not supported inside '{orderByDescending}'. Use '{orderBy}' instead.
        /// </summary>
        public static string OrderByDescendingScoringFunction(object? orderByDescending, object? orderBy)
            => string.Format(
                GetString("OrderByDescendingScoringFunction", nameof(orderByDescending), nameof(orderBy)),
                orderByDescending, orderBy);

        /// <summary>
        ///     Only one ordering using scoring function is allowed. Use 'EF.Functions.{rrf}' method to combine multiple scoring functions.
        /// </summary>
        public static string OrderByMultipleScoringFunctionWithoutRrf(object? rrf)
            => string.Format(
                GetString("OrderByMultipleScoringFunctionWithoutRrf", nameof(rrf)),
                rrf);

        /// <summary>
        ///     Ordering using a scoring function is mutually exclusive with other forms of ordering.
        /// </summary>
        public static string OrderByScoringFunctionMixedWithRegularOrderby
            => GetString("OrderByScoringFunctionMixedWithRegularOrderby");

        /// <summary>
        ///     The entity of type '{entityType}' is mapped as a part of the document mapped to '{missingEntityType}', but there is no tracked entity of this type with the corresponding key value. Consider using 'DbContextOptionsBuilder.EnableSensitiveDataLogging' to see the key values.
        /// </summary>
        public static string OrphanedNestedDocument(object? entityType, object? missingEntityType)
            => string.Format(
                GetString("OrphanedNestedDocument", nameof(entityType), nameof(missingEntityType)),
                entityType, missingEntityType);

        /// <summary>
        ///     The entity of type '{entityType}' is mapped as part of the document mapped to '{missingEntityType}', but there is no tracked entity of this type with the key value '{keyValue}'.
        /// </summary>
        public static string OrphanedNestedDocumentSensitive(object? entityType, object? missingEntityType, object? keyValue)
            => string.Format(
                GetString("OrphanedNestedDocumentSensitive", nameof(entityType), nameof(missingEntityType), nameof(keyValue)),
                entityType, missingEntityType, keyValue);

        /// <summary>
        ///     The entity type '{entityType}' is owned by the entity type '{owner}', but is mapped to the container '{container}'. Owned types mapped to a container directly are not supported, remove this configuration to allow the owned type to be embedded in the same document as the owner.
        /// </summary>
        public static string OwnedTypeDifferentContainer(object? entityType, object? owner, object? container)
            => string.Format(
                GetString("OwnedTypeDifferentContainer", nameof(entityType), nameof(owner), nameof(container)),
                entityType, owner, container);

        /// <summary>
        ///     The type of the partition key property '{property}' on '{entityType}' is '{propertyType}'. All partition key property types must be numeric, Boolean, or string, or converted to one of these types.
        /// </summary>
        public static string PartitionKeyBadStoreType(object? property, object? entityType, object? propertyType)
            => string.Format(
                GetString("PartitionKeyBadStoreType", nameof(property), nameof(entityType), nameof(propertyType)),
                property, entityType, propertyType);

        /// <summary>
        ///     The partition key value is of type '{valueType}' which is not valid for Cosmos partition keys. All partition key properties values must be numeric, Boolean, or string, or converted to one of these types.
        /// </summary>
        public static string PartitionKeyBadValue(object? valueType)
            => string.Format(
                GetString("PartitionKeyBadValue", nameof(valueType)),
                valueType);

        /// <summary>
        ///     The partition key value supplied for '{propertyType}' property '{entityType}.{property}' is of type '{valueType}'. Partition key values must be of a type assignable to the property.
        /// </summary>
        public static string PartitionKeyBadValueType(object? propertyType, object? entityType, object? property, object? valueType)
            => string.Format(
                GetString("PartitionKeyBadValueType", nameof(propertyType), nameof(entityType), nameof(property), nameof(valueType)),
                propertyType, entityType, property, valueType);

        /// <summary>
        ///     A partition key is defined on entity type '{entityType}', which inherits from '{baseEntityType}'. Partition keys must be defined on the root entity type of a hierarchy.
        /// </summary>
        public static string PartitionKeyNotOnRoot(object? entityType, object? baseEntityType)
            => string.Format(
                GetString("PartitionKeyNotOnRoot", nameof(entityType), nameof(baseEntityType)),
                entityType, baseEntityType);

        /// <summary>
        ///     Unable to execute a 'ReadItem' query since the partition key value is missing. Consider using the 'WithPartitionKey' method on the query to specify partition key to use.
        /// </summary>
        public static string PartitionKeyMissing
            => GetString("PartitionKeyMissing");

        /// <summary>
        ///     The partition key for entity type '{entityType}' is set to '{property}', but there is no property with that name.
        /// </summary>
        public static string PartitionKeyMissingProperty(object? entityType, object? property)
            => string.Format(
                GetString("PartitionKeyMissingProperty", nameof(entityType), nameof(property)),
                entityType, property);

        /// <summary>
        ///     The partition key property '{property1}' on '{entityType1}' is mapped as '{storeName1}', but the partition key property '{property2}' on '{entityType2}' is mapped as '{storeName2}'. All partition key properties need to be mapped to the same store property for entity types mapped to the same container.
        /// </summary>
        public static string PartitionKeyStoreNameMismatch(object? property1, object? entityType1, object? storeName1, object? property2, object? entityType2, object? storeName2)
            => string.Format(
                GetString("PartitionKeyStoreNameMismatch", nameof(property1), nameof(entityType1), nameof(storeName1), nameof(property2), nameof(entityType2), nameof(storeName2)),
                property1, entityType1, storeName1, property2, entityType2, storeName2);

        /// <summary>
        ///     Unable to execute a 'ReadItem' query since the 'id' value is missing and cannot be generated.
        /// </summary>
        public static string ResourceIdMissing
            => GetString("ResourceIdMissing");

        /// <summary>
        ///     Reversing the ordering is not supported when limit or offset are already applied.
        /// </summary>
        public static string ReverseAfterSkipTakeNotSupported
            => GetString("ReverseAfterSkipTakeNotSupported");

        /// <summary>
        ///     The provisioned throughput was configured to '{throughput1}' on '{entityType1}', but on '{entityType2}' it was configured to '{throughput2}'. All entity types mapped to the same container '{container}' must be configured with the same provisioned throughput.
        /// </summary>
        public static string ThroughputMismatch(object? throughput1, object? entityType1, object? entityType2, object? throughput2, object? container)
            => string.Format(
                GetString("ThroughputMismatch", nameof(throughput1), nameof(entityType1), nameof(entityType2), nameof(throughput2), nameof(container)),
                throughput1, entityType1, entityType2, throughput2, container);

        /// <summary>
        ///     'ToPageAsync' can only be used as the terminating operator of the top-level query.
        /// </summary>
        public static string ToPageAsyncAtTopLevelOnly
            => GetString("ToPageAsyncAtTopLevelOnly");

        /// <summary>
        ///     The provisioned throughput was configured as manual on '{manualEntityType}', but on '{autoscaleEntityType}' it was configured as autoscale. All entity types mapped to the same container '{container}' must be configured with the same provisioned throughput type.
        /// </summary>
        public static string ThroughputTypeMismatch(object? manualEntityType, object? autoscaleEntityType, object? container)
            => string.Format(
                GetString("ThroughputTypeMismatch", nameof(manualEntityType), nameof(autoscaleEntityType), nameof(container)),
                manualEntityType, autoscaleEntityType, container);

        /// <summary>
        ///     The Cosmos database provider does not support transactions.
        /// </summary>
        public static string TransactionsNotSupported
            => GetString("TransactionsNotSupported");

        /// <summary>
        ///     Unable to bind '{memberType}' '{member}' to an entity projection of '{entityType}'.
        /// </summary>
        public static string UnableToBindMemberToEntityProjection(object? memberType, object? member, object? entityType)
            => string.Format(
                GetString("UnableToBindMemberToEntityProjection", nameof(memberType), nameof(member), nameof(entityType)),
                memberType, member, entityType);

        /// <summary>
        ///     Unsupported operator '{nodeType}' specified for expression of type '{expressionType}'.
        /// </summary>
        public static string UnsupportedOperatorForSqlExpression(object? nodeType, object? expressionType)
            => string.Format(
                GetString("UnsupportedOperatorForSqlExpression", nameof(nodeType), nameof(expressionType)),
                nodeType, expressionType);

        /// <summary>
        ///     Conflicts were detected for item with id '{itemId}'.
        /// </summary>
        public static string UpdateConflict(object? itemId)
            => string.Format(
                GetString("UpdateConflict", nameof(itemId)),
                itemId);

        /// <summary>
        ///     An error occurred while saving the item with id '{itemId}'. See the inner exception for details.
        /// </summary>
        public static string UpdateStoreException(object? itemId)
            => string.Format(
                GetString("UpdateStoreException", nameof(itemId)),
                itemId);

        /// <summary>
        ///     A vector index is defined for `{entityType}.{property}`, but this property has not been configured as a vector. Use 'IsVector()' in 'OnModelCreating' to configure the property as a vector.
        /// </summary>
        public static string VectorIndexOnNonVector(object? entityType, object? property)
            => string.Format(
                GetString("VectorIndexOnNonVector", nameof(entityType), nameof(property)),
                entityType, property);

        /// <summary>
        ///     The 'VectorDistance' function can only be used with a property mapped as a vector. Use 'IsVector()' in 'OnModelCreating' to configure the property as a vector.
        /// </summary>
        public static string VectorSearchRequiresVector
            => GetString("VectorSearchRequiresVector");

        /// <summary>
        ///     'VisitChildren' must be overridden in the class deriving from 'SqlExpression'.
        /// </summary>
        public static string VisitChildrenMustBeOverridden
            => GetString("VisitChildrenMustBeOverridden");

        /// <summary>
        ///     'WithPartitionKey' can only be called once in a query. See https://aka.ms/efdocs-cosmos-partition-keys for more information.
        /// </summary>
        public static string WithPartitionKeyAlreadyCalled
            => GetString("WithPartitionKeyAlreadyCalled");

        /// <summary>
        ///     'WithPartitionKey' can only be called on a entity query root. See https://aka.ms/efdocs-cosmos-partition-keys for more information.
        /// </summary>
        public static string WithPartitionKeyBadNode
            => GetString("WithPartitionKeyBadNode");

        /// <summary>
        ///     'WithPartitionKey' only accepts simple constant or parameter arguments. See https://aka.ms/efdocs-cosmos-partition-keys for more information.
        /// </summary>
        public static string WithPartitionKeyNotConstantOrParameter
            => GetString("WithPartitionKeyNotConstantOrParameter");

        private static string GetString(string name, params string[] formatterNames)
        {
            var value = _resourceManager.GetString(name)!;
            for (var i = 0; i < formatterNames.Length; i++)
            {
                value = value.Replace("{" + formatterNames[i] + "}", "{" + i + "}");
            }

            return value;
        }
    }
}

namespace Microsoft.EntityFrameworkCore.Cosmos.Internal
{
    /// <summary>
    ///     This is an internal API that supports the Entity Framework Core infrastructure and not subject to
    ///     the same compatibility standards as public APIs. It may be changed or removed without notice in
    ///     any release. You should only use it directly in your code with extreme caution and knowing that
    ///     doing so can result in application failures when updating to a new Entity Framework Core release.
    /// </summary>
    public static class CosmosResources
    {
        private static readonly ResourceManager _resourceManager
            = new ResourceManager("Microsoft.EntityFrameworkCore.Cosmos.Properties.CosmosStrings", typeof(CosmosResources).Assembly);

        /// <summary>
        ///     Executed CreateItem ({elapsed} ms, {charge} RU) ActivityId='{activityId}', Container='{container}', Id='{id}', Partition='{partitionKey}'
        /// </summary>
        public static EventDefinition<string, string, string, string, string, string?> LogExecutedCreateItem(IDiagnosticsLogger logger)
        {
            var definition = ((Diagnostics.Internal.CosmosLoggingDefinitions)logger.Definitions).LogExecutedCreateItem;
            if (definition == null)
            {
                definition = NonCapturingLazyInitializer.EnsureInitialized(
                    ref ((Diagnostics.Internal.CosmosLoggingDefinitions)logger.Definitions).LogExecutedCreateItem,
                    logger,
                    static logger => new EventDefinition<string, string, string, string, string, string?>(
                        logger.Options,
                        CosmosEventId.ExecutedCreateItem,
                        LogLevel.Information,
                        "CosmosEventId.ExecutedCreateItem",
                        level => LoggerMessage.Define<string, string, string, string, string, string?>(
                            level,
                            CosmosEventId.ExecutedCreateItem,
                            _resourceManager.GetString("LogExecutedCreateItem")!)));
            }

            return (EventDefinition<string, string, string, string, string, string?>)definition;
        }

        /// <summary>
        ///     Executed DeleteItem ({elapsed} ms, {charge} RU) ActivityId='{activityId}', Container='{container}', Id='{id}', Partition='{partitionKey}'
        /// </summary>
        public static EventDefinition<string, string, string, string, string, string?> LogExecutedDeleteItem(IDiagnosticsLogger logger)
        {
            var definition = ((Diagnostics.Internal.CosmosLoggingDefinitions)logger.Definitions).LogExecutedDeleteItem;
            if (definition == null)
            {
                definition = NonCapturingLazyInitializer.EnsureInitialized(
                    ref ((Diagnostics.Internal.CosmosLoggingDefinitions)logger.Definitions).LogExecutedDeleteItem,
                    logger,
                    static logger => new EventDefinition<string, string, string, string, string, string?>(
                        logger.Options,
                        CosmosEventId.ExecutedDeleteItem,
                        LogLevel.Information,
                        "CosmosEventId.ExecutedDeleteItem",
                        level => LoggerMessage.Define<string, string, string, string, string, string?>(
                            level,
                            CosmosEventId.ExecutedDeleteItem,
                            _resourceManager.GetString("LogExecutedDeleteItem")!)));
            }

            return (EventDefinition<string, string, string, string, string, string?>)definition;
        }

        /// <summary>
        ///     Executed ReadItem ({elapsed} ms, {charge} RU) ActivityId='{activityId}', Container='{container}', Id='{id}', Partition='{partitionKey}'
        /// </summary>
        public static EventDefinition<string, string, string, string, string, string?> LogExecutedReadItem(IDiagnosticsLogger logger)
        {
            var definition = ((Diagnostics.Internal.CosmosLoggingDefinitions)logger.Definitions).LogExecutedReadItem;
            if (definition == null)
            {
                definition = NonCapturingLazyInitializer.EnsureInitialized(
                    ref ((Diagnostics.Internal.CosmosLoggingDefinitions)logger.Definitions).LogExecutedReadItem,
                    logger,
                    static logger => new EventDefinition<string, string, string, string, string, string?>(
                        logger.Options,
                        CosmosEventId.ExecutedReadItem,
                        LogLevel.Information,
                        "CosmosEventId.ExecutedReadItem",
                        level => LoggerMessage.Define<string, string, string, string, string, string?>(
                            level,
                            CosmosEventId.ExecutedReadItem,
                            _resourceManager.GetString("LogExecutedReadItem")!)));
            }

            return (EventDefinition<string, string, string, string, string, string?>)definition;
        }

        /// <summary>
        ///     Executed ReadNext ({elapsed} ms, {charge} RU) ActivityId='{activityId}', Container='{container}', Partition='{partitionKey}', Parameters=[{parameters}]{newLine}{sql}
        /// </summary>
        public static FallbackEventDefinition LogExecutedReadNext(IDiagnosticsLogger logger)
        {
            var definition = ((Diagnostics.Internal.CosmosLoggingDefinitions)logger.Definitions).LogExecutedReadNext;
            if (definition == null)
            {
                definition = NonCapturingLazyInitializer.EnsureInitialized(
                    ref ((Diagnostics.Internal.CosmosLoggingDefinitions)logger.Definitions).LogExecutedReadNext,
                    logger,
                    static logger => new FallbackEventDefinition(
                        logger.Options,
                        CosmosEventId.ExecutedReadNext,
                        LogLevel.Information,
                        "CosmosEventId.ExecutedReadNext",
                        _resourceManager.GetString("LogExecutedReadNext")!));
            }

            return (FallbackEventDefinition)definition;
        }

        /// <summary>
        ///     Executed ReplaceItem ({elapsed} ms, {charge} RU) ActivityId='{activityId}', Container='{container}', Id='{id}', Partition='{partitionKey}'
        /// </summary>
        public static EventDefinition<string, string, string, string, string, string?> LogExecutedReplaceItem(IDiagnosticsLogger logger)
        {
            var definition = ((Diagnostics.Internal.CosmosLoggingDefinitions)logger.Definitions).LogExecutedReplaceItem;
            if (definition == null)
            {
                definition = NonCapturingLazyInitializer.EnsureInitialized(
                    ref ((Diagnostics.Internal.CosmosLoggingDefinitions)logger.Definitions).LogExecutedReplaceItem,
                    logger,
                    static logger => new EventDefinition<string, string, string, string, string, string?>(
                        logger.Options,
                        CosmosEventId.ExecutedReplaceItem,
                        LogLevel.Information,
                        "CosmosEventId.ExecutedReplaceItem",
                        level => LoggerMessage.Define<string, string, string, string, string, string?>(
                            level,
                            CosmosEventId.ExecutedReplaceItem,
                            _resourceManager.GetString("LogExecutedReplaceItem")!)));
            }

            return (EventDefinition<string, string, string, string, string, string?>)definition;
        }

        /// <summary>
        ///     Reading resource '{resourceId}' item from container '{containerId}' in partition '{partitionKey}'.
        /// </summary>
        public static EventDefinition<string, string, string?> LogExecutingReadItem(IDiagnosticsLogger logger)
        {
            var definition = ((Diagnostics.Internal.CosmosLoggingDefinitions)logger.Definitions).LogExecutingReadItem;
            if (definition == null)
            {
                definition = NonCapturingLazyInitializer.EnsureInitialized(
                    ref ((Diagnostics.Internal.CosmosLoggingDefinitions)logger.Definitions).LogExecutingReadItem,
                    logger,
                    static logger => new EventDefinition<string, string, string?>(
                        logger.Options,
                        CosmosEventId.ExecutingReadItem,
                        LogLevel.Information,
                        "CosmosEventId.ExecutingReadItem",
                        level => LoggerMessage.Define<string, string, string?>(
                            level,
                            CosmosEventId.ExecutingReadItem,
                            _resourceManager.GetString("LogExecutingReadItem")!)));
            }

            return (EventDefinition<string, string, string?>)definition;
        }

        /// <summary>
        ///     Executing SQL query for container '{containerId}' in partition '{partitionKey}' [Parameters=[{parameters}]]{newLine}{commandText}
        /// </summary>
        public static EventDefinition<string, string?, string, string, string> LogExecutingSqlQuery(IDiagnosticsLogger logger)
        {
            var definition = ((Diagnostics.Internal.CosmosLoggingDefinitions)logger.Definitions).LogExecutingSqlQuery;
            if (definition == null)
            {
                definition = NonCapturingLazyInitializer.EnsureInitialized(
                    ref ((Diagnostics.Internal.CosmosLoggingDefinitions)logger.Definitions).LogExecutingSqlQuery,
                    logger,
                    static logger => new EventDefinition<string, string?, string, string, string>(
                        logger.Options,
                        CosmosEventId.ExecutingSqlQuery,
                        LogLevel.Information,
                        "CosmosEventId.ExecutingSqlQuery",
                        level => LoggerMessage.Define<string, string?, string, string, string>(
                            level,
                            CosmosEventId.ExecutingSqlQuery,
                            _resourceManager.GetString("LogExecutingSqlQuery")!)));
            }

            return (EventDefinition<string, string?, string, string, string>)definition;
        }

        /// <summary>
        ///     No partition key has been configured for entity type '{entityType}'. It is highly recommended that an appropriate partition key be defined. See https://aka.ms/efdocs-cosmos-partition-keys for more information.
        /// </summary>
        public static EventDefinition<string> LogNoPartitionKeyDefined(IDiagnosticsLogger logger)
        {
            var definition = ((Diagnostics.Internal.CosmosLoggingDefinitions)logger.Definitions).LogNoPartitionKeyDefined;
            if (definition == null)
            {
                definition = NonCapturingLazyInitializer.EnsureInitialized(
                    ref ((Diagnostics.Internal.CosmosLoggingDefinitions)logger.Definitions).LogNoPartitionKeyDefined,
                    logger,
                    static logger => new EventDefinition<string>(
                        logger.Options,
                        CosmosEventId.NoPartitionKeyDefined,
                        LogLevel.Warning,
                        "CosmosEventId.NoPartitionKeyDefined",
                        level => LoggerMessage.Define<string>(
                            level,
                            CosmosEventId.NoPartitionKeyDefined,
                            _resourceManager.GetString("LogNoPartitionKeyDefined")!)));
            }

            return (EventDefinition<string>)definition;
        }

        /// <summary>
        ///     The key property '{entityType}.{property}' is not configured to generate values and has the CLR default or sentinel value while saving a new entity to the database. The Azure Cosmos DB database provider for EF Core does not generate key values by default. This means key values must be explicitly set before saving new entities. See https://aka.ms/ef-cosmos-keys for more information.
        /// </summary>
        public static EventDefinition<string, string> LogPrimaryKeyValueNotSet(IDiagnosticsLogger logger)
        {
            var definition = ((Diagnostics.Internal.CosmosLoggingDefinitions)logger.Definitions).LogPrimaryKeyValueNotSet;
            if (definition == null)
            {
                definition = NonCapturingLazyInitializer.EnsureInitialized(
                    ref ((Diagnostics.Internal.CosmosLoggingDefinitions)logger.Definitions).LogPrimaryKeyValueNotSet,
                    logger,
                    static logger => new EventDefinition<string, string>(
                        logger.Options,
                        CosmosEventId.PrimaryKeyValueNotSet,
                        LogLevel.Warning,
                        "CosmosEventId.PrimaryKeyValueNotSet",
                        level => LoggerMessage.Define<string, string>(
                            level,
                            CosmosEventId.PrimaryKeyValueNotSet,
                            _resourceManager.GetString("LogPrimaryKeyValueNotSet")!)));
            }

            return (EventDefinition<string, string>)definition;
        }

        /// <summary>
        ///     Azure Cosmos DB does not support synchronous I/O. Make sure to use and correctly await only async methods when using Entity Framework Core to access Azure Cosmos DB. See https://aka.ms/ef-cosmos-nosync for more information.
        /// </summary>
        public static EventDefinition LogSyncNotSupported(IDiagnosticsLogger logger)
        {
            var definition = ((Diagnostics.Internal.CosmosLoggingDefinitions)logger.Definitions).LogSyncNotSupported;
            if (definition == null)
            {
                definition = NonCapturingLazyInitializer.EnsureInitialized(
                    ref ((Diagnostics.Internal.CosmosLoggingDefinitions)logger.Definitions).LogSyncNotSupported,
                    logger,
                    static logger => new EventDefinition(
                        logger.Options,
                        CosmosEventId.SyncNotSupported,
                        LogLevel.Error,
                        "CosmosEventId.SyncNotSupported",
                        level => LoggerMessage.Define(
                            level,
                            CosmosEventId.SyncNotSupported,
                            _resourceManager.GetString("LogSyncNotSupported")!)));
            }

            return (EventDefinition)definition;
        }
    }
}
