{ -*- buffer-read-only: t -*-

  Copyright 2015-2022 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal }

{$ifdef read_interface}

  strict private
    function GetCenter: TVector3;
    procedure SetCenter(const Value: TVector3);
    function GetNameField: String;
    procedure SetNameField(const Value: String);
    function GetRotation: TVector4;
    procedure SetRotation(const Value: TVector4);
    function GetScale: TVector3;
    procedure SetScale(const Value: TVector3);
    function GetScaleOrientation: TVector4;
    procedure SetScaleOrientation(const Value: TVector4);
    function GetSkinNormal: TAbstractNormalNode;
    procedure SetSkinNormal(const Value: TAbstractNormalNode);
    function GetTranslation: TVector3;
    procedure SetTranslation(const Value: TVector3);
    function GetVersion: String;
    procedure SetVersion(const Value: String);
    function GetBBox: TBox3D;
    procedure SetBBox(const Value: TBox3D);
  public
    procedure CreateNode; override;
    class function ClassX3DType: string; override;

    strict private FFdCenter: TSFVec3f;
    { Internal wrapper for property @link(Center). This wrapper API may change, we advise to access simpler @link(Center) instead. }
    public property FdCenter: TSFVec3f read FFdCenter;
    {  }
    property Center: TVector3 read GetCenter write SetCenter;

    strict private FFdInfo: TMFString;
    { Internal wrapper for property @link(Info). This wrapper API may change, we advise to access simpler @link(Info) instead. }
    public property FdInfo: TMFString read FFdInfo;
    {  }
    procedure SetInfo(const Value: array of string); overload;
    {  }
    procedure SetInfo(const Value: TCastleStringList); overload;

    strict private FFdJoints: TMFNode;
    { Internal wrapper for property @link(Joints). This wrapper API may change, we advise to access simpler @link(Joints) instead. }
    public property FdJoints: TMFNode read FFdJoints;
    {  }
    procedure SetJoints(const Value: array of THAnimJointNode);

    strict private FFdName: TSFString;
    { Internal wrapper for property @link(NameField). This wrapper API may change, we advise to access simpler @link(NameField) instead. }
    public property FdName: TSFString read FFdName;
    {  }
    property NameField: String read GetNameField write SetNameField;

    strict private FFdRotation: TSFRotation;
    { Internal wrapper for property @link(Rotation). This wrapper API may change, we advise to access simpler @link(Rotation) instead. }
    public property FdRotation: TSFRotation read FFdRotation;
    {  }
    property Rotation: TVector4 read GetRotation write SetRotation;

    strict private FFdScale: TSFVec3f;
    { Internal wrapper for property @link(Scale). This wrapper API may change, we advise to access simpler @link(Scale) instead. }
    public property FdScale: TSFVec3f read FFdScale;
    {  }
    property Scale: TVector3 read GetScale write SetScale;

    strict private FFdScaleOrientation: TSFRotation;
    { Internal wrapper for property @link(ScaleOrientation). This wrapper API may change, we advise to access simpler @link(ScaleOrientation) instead. }
    public property FdScaleOrientation: TSFRotation read FFdScaleOrientation;
    {  }
    property ScaleOrientation: TVector4 read GetScaleOrientation write SetScaleOrientation;

    strict private FFdSegments: TMFNode;
    { Internal wrapper for property @link(Segments). This wrapper API may change, we advise to access simpler @link(Segments) instead. }
    public property FdSegments: TMFNode read FFdSegments;
    {  }
    procedure SetSegments(const Value: array of THAnimSegmentNode);

    strict private FFdSites: TMFNode;
    { Internal wrapper for property @link(Sites). This wrapper API may change, we advise to access simpler @link(Sites) instead. }
    public property FdSites: TMFNode read FFdSites;
    {  }
    procedure SetSites(const Value: array of THAnimSiteNode);

    strict private FFdSkeleton: TMFNode;
    { Internal wrapper for property @link(Skeleton). This wrapper API may change, we advise to access simpler @link(Skeleton) instead. }
    public property FdSkeleton: TMFNode read FFdSkeleton;

    strict private FFdSkin: TMFNode;
    { Internal wrapper for property @link(Skin). This wrapper API may change, we advise to access simpler @link(Skin) instead. }
    public property FdSkin: TMFNode read FFdSkin;
    {  }
    procedure SetSkin(const Value: array of TAbstractChildNode);

    strict private FFdSkinCoord: TSFNode;
    { Internal wrapper for property @link(SkinCoord). This wrapper API may change, we advise to access simpler @link(SkinCoord) instead. }
    public property FdSkinCoord: TSFNode read FFdSkinCoord;

    strict private FFdSkinNormal: TSFNode;
    { Internal wrapper for property @link(SkinNormal). This wrapper API may change, we advise to access simpler @link(SkinNormal) instead. }
    public property FdSkinNormal: TSFNode read FFdSkinNormal;
    {  }
    property SkinNormal: TAbstractNormalNode read GetSkinNormal write SetSkinNormal;

    strict private FFdTranslation: TSFVec3f;
    { Internal wrapper for property @link(Translation). This wrapper API may change, we advise to access simpler @link(Translation) instead. }
    public property FdTranslation: TSFVec3f read FFdTranslation;
    {  }
    property Translation: TVector3 read GetTranslation write SetTranslation;

    strict private FFdVersion: TSFString;
    { Internal wrapper for property @link(Version). This wrapper API may change, we advise to access simpler @link(Version) instead. }
    public property FdVersion: TSFString read FFdVersion;
    {  }
    property Version: String read GetVersion write SetVersion;

    strict private FFdViewpoints: TMFNode;
    { Internal wrapper for property @link(Viewpoints). This wrapper API may change, we advise to access simpler @link(Viewpoints) instead. }
    public property FdViewpoints: TMFNode read FFdViewpoints;

    strict private FFdBboxCenter: TSFVec3f;
    { Internal wrapper for property @link(BboxCenter). This wrapper API may change, we advise to access simpler @link(BboxCenter) instead. }
    public property FdBboxCenter: TSFVec3f read FFdBboxCenter;
    {  }
    property BBox: TBox3D read GetBBox write SetBBox;

    strict private FFdBboxSize: TSFVec3f;
    { Internal wrapper for property @link(BboxSize). This wrapper API may change, we advise to access simpler @link(BboxSize) instead. }
    public property FdBboxSize: TSFVec3f read FFdBboxSize;

{$endif read_interface}

{$ifdef read_implementation}

{ THAnimHumanoidNode ----------------------------------------------- }

function THAnimHumanoidNode.GetCenter: TVector3;
begin
  Result := FdCenter.Value;
end;

procedure THAnimHumanoidNode.SetCenter(const Value: TVector3);
begin
  FdCenter.Send(Value);
end;

procedure THAnimHumanoidNode.SetInfo(const Value: array of string);
begin
  FdInfo.Send(Value);
end;

procedure THAnimHumanoidNode.SetInfo(const Value: TCastleStringList);
begin
  FdInfo.Send(Value);
end;

procedure THAnimHumanoidNode.SetJoints(const Value: array of THAnimJointNode);
var
  L: Integer;
  A: array of TX3DNode;
begin
  L := High(Value) + 1;
  SetLength(A, L);
  if L > 0 then
    Move(Value[0], A[0], L * SizeOf(THAnimJointNode));
  FdJoints.Send(A);
end;

function THAnimHumanoidNode.GetNameField: String;
begin
  Result := FdName.Value;
end;

procedure THAnimHumanoidNode.SetNameField(const Value: String);
begin
  FdName.Send(Value);
end;

function THAnimHumanoidNode.GetRotation: TVector4;
begin
  Result := FdRotation.Value;
end;

procedure THAnimHumanoidNode.SetRotation(const Value: TVector4);
begin
  FdRotation.Send(Value);
end;

function THAnimHumanoidNode.GetScale: TVector3;
begin
  Result := FdScale.Value;
end;

procedure THAnimHumanoidNode.SetScale(const Value: TVector3);
begin
  FdScale.Send(Value);
end;

function THAnimHumanoidNode.GetScaleOrientation: TVector4;
begin
  Result := FdScaleOrientation.Value;
end;

procedure THAnimHumanoidNode.SetScaleOrientation(const Value: TVector4);
begin
  FdScaleOrientation.Send(Value);
end;

procedure THAnimHumanoidNode.SetSegments(const Value: array of THAnimSegmentNode);
var
  L: Integer;
  A: array of TX3DNode;
begin
  L := High(Value) + 1;
  SetLength(A, L);
  if L > 0 then
    Move(Value[0], A[0], L * SizeOf(THAnimSegmentNode));
  FdSegments.Send(A);
end;

procedure THAnimHumanoidNode.SetSites(const Value: array of THAnimSiteNode);
var
  L: Integer;
  A: array of TX3DNode;
begin
  L := High(Value) + 1;
  SetLength(A, L);
  if L > 0 then
    Move(Value[0], A[0], L * SizeOf(THAnimSiteNode));
  FdSites.Send(A);
end;

procedure THAnimHumanoidNode.SetSkin(const Value: array of TAbstractChildNode);
var
  L: Integer;
  A: array of TX3DNode;
begin
  L := High(Value) + 1;
  SetLength(A, L);
  if L > 0 then
    Move(Value[0], A[0], L * SizeOf(TAbstractChildNode));
  FdSkin.Send(A);
end;

function THAnimHumanoidNode.GetSkinNormal: TAbstractNormalNode;
begin
  if FdSkinNormal.Value is TAbstractNormalNode then
    Result := TAbstractNormalNode(FdSkinNormal.Value)
  else
    Result := nil;
end;

procedure THAnimHumanoidNode.SetSkinNormal(const Value: TAbstractNormalNode);
begin
  FdSkinNormal.Send(Value);
end;

function THAnimHumanoidNode.GetTranslation: TVector3;
begin
  Result := FdTranslation.Value;
end;

procedure THAnimHumanoidNode.SetTranslation(const Value: TVector3);
begin
  FdTranslation.Send(Value);
end;

function THAnimHumanoidNode.GetVersion: String;
begin
  Result := FdVersion.Value;
end;

procedure THAnimHumanoidNode.SetVersion(const Value: String);
begin
  FdVersion.Send(Value);
end;

function THAnimHumanoidNode.GetBBox: TBox3D;
begin
  Result := TBox3D.FromCenterSize(FdBBoxCenter.Value, FdBBoxSize.Value);
end;

procedure THAnimHumanoidNode.SetBBox(const Value: TBox3D);
var
  ValueCenter, ValueSize: TVector3;
begin
  Value.ToCenterSize(ValueCenter, ValueSize);
  FdBBoxCenter.Send(ValueCenter);
  FdBBoxSize.Send(ValueSize);
end;

class function THAnimHumanoidNode.ClassX3DType: String;
begin
  Result := 'HAnimHumanoid';
end;

procedure THAnimHumanoidNode.CreateNode;
begin
  inherited;

  FFdCenter := TSFVec3f.Create(Self, True, 'center', Vector3(0, 0, 0));
   FdCenter.ChangeAlways := chTransform;
  AddField(FFdCenter);

  FFdInfo := TMFString.Create(Self, True, 'info', []);
   FdInfo.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdInfo);

  FFdJoints := TMFNode.Create(Self, True, 'joints', [THAnimJointNode]);
   FdJoints.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdJoints);

  FFdName := TSFString.Create(Self, True, 'name', '');
   FdName.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdName);

  FFdRotation := TSFRotation.Create(Self, True, 'rotation', Vector3(0, 0, 1), 0);
   FdRotation.ChangeAlways := chTransform;
  AddField(FFdRotation);

  FFdScale := TSFVec3f.Create(Self, True, 'scale', Vector3(1, 1, 1));
   FdScale.ChangeAlways := chTransform;
  AddField(FFdScale);

  FFdScaleOrientation := TSFRotation.Create(Self, True, 'scaleOrientation', Vector3(0, 0, 1), 0);
   FdScaleOrientation.ChangeAlways := chTransform;
  AddField(FFdScaleOrientation);

  FFdSegments := TMFNode.Create(Self, True, 'segments', [THAnimSegmentNode]);
   FdSegments.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdSegments);

  FFdSites := TMFNode.Create(Self, True, 'sites', [THAnimSiteNode]);
   FdSites.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdSites);

  FFdSkeleton := TMFNode.Create(Self, True, 'skeleton', [THAnimJointNode, THAnimSiteNode]);
   FdSkeleton.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdSkeleton);

  FFdSkin := TMFNode.Create(Self, True, 'skin', [TAbstractChildNode]);
   FdSkin.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdSkin);

  FFdSkinCoord := TSFNode.Create(Self, True, 'skinCoord', [TAbstractCoordinateNode]);
   FdSkinCoord.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdSkinCoord);

  FFdSkinNormal := TSFNode.Create(Self, True, 'skinNormal', [TAbstractNormalNode]);
   FdSkinNormal.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdSkinNormal);

  FFdTranslation := TSFVec3f.Create(Self, True, 'translation', Vector3(0, 0, 0));
   FdTranslation.ChangeAlways := chTransform;
  AddField(FFdTranslation);

  FFdVersion := TSFString.Create(Self, True, 'version', '');
   FdVersion.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdVersion);

  FFdViewpoints := TMFNode.Create(Self, True, 'viewpoints', [THAnimSiteNode, TAbstractViewpointNode, TViewpointGroupNode]);
   FdViewpoints.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdViewpoints);

  FFdBboxCenter := TSFVec3f.Create(Self, False, 'bboxCenter', Vector3(0, 0, 0));
   FdBboxCenter.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdBboxCenter);

  FFdBboxSize := TSFVec3f.Create(Self, False, 'bboxSize', Vector3(-1, -1, -1));
   FdBboxSize.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdBboxSize);
end;

{$endif read_implementation}
