/*
 * Decompiled with CFR 0.152.
 */
package proguard.backport;

import java.util.Map;
import proguard.backport.LambdaExpression;
import proguard.classfile.Clazz;
import proguard.classfile.LibraryClass;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.BootstrapMethodInfo;
import proguard.classfile.attribute.BootstrapMethodsAttribute;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.attribute.visitor.BootstrapMethodInfoVisitor;
import proguard.classfile.constant.Constant;
import proguard.classfile.constant.IntegerConstant;
import proguard.classfile.constant.InvokeDynamicConstant;
import proguard.classfile.constant.MethodHandleConstant;
import proguard.classfile.constant.MethodTypeConstant;
import proguard.classfile.constant.RefConstant;
import proguard.classfile.constant.visitor.ConstantTagFilter;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.ClassVisitor;
import proguard.util.ArrayUtil;

public class LambdaExpressionCollector
extends SimplifiedVisitor
implements ClassVisitor,
ConstantVisitor,
AttributeVisitor,
BootstrapMethodInfoVisitor {
    private final Map<Integer, LambdaExpression> lambdaExpressions;
    private InvokeDynamicConstant referencedInvokeDynamicConstant;
    private int referencedBootstrapMethodIndex;
    private Clazz referencedInvokedClass;
    private Method referencedInvokedMethod;
    private static final String NAME_JAVA_LANG_INVOKE_LAMBDA_METAFACTORY = "java/lang/invoke/LambdaMetafactory";
    private static final String LAMBDA_ALTERNATE_METAFACTORY_METHOD = "altMetafactory";

    public LambdaExpressionCollector(Map<Integer, LambdaExpression> map) {
        this.lambdaExpressions = map;
    }

    @Override
    public void visitLibraryClass(LibraryClass libraryClass) {
    }

    @Override
    public void visitProgramClass(ProgramClass programClass) {
        programClass.constantPoolEntriesAccept(new ConstantTagFilter(18, (ConstantVisitor)this));
    }

    @Override
    public void visitAnyConstant(Clazz clazz, Constant constant) {
    }

    @Override
    public void visitInvokeDynamicConstant(Clazz clazz, InvokeDynamicConstant invokeDynamicConstant) {
        this.referencedInvokeDynamicConstant = invokeDynamicConstant;
        this.referencedBootstrapMethodIndex = invokeDynamicConstant.getBootstrapMethodAttributeIndex();
        clazz.attributesAccept(this);
    }

    @Override
    public void visitAnyMethodrefConstant(Clazz clazz, RefConstant refConstant) {
        this.referencedInvokedClass = refConstant.referencedClass;
        this.referencedInvokedMethod = (Method)refConstant.referencedMember;
    }

    @Override
    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    @Override
    public void visitBootstrapMethodsAttribute(Clazz clazz, BootstrapMethodsAttribute bootstrapMethodsAttribute) {
        bootstrapMethodsAttribute.bootstrapMethodEntryAccept(clazz, this.referencedBootstrapMethodIndex, this);
    }

    @Override
    public void visitBootstrapMethodInfo(Clazz clazz, BootstrapMethodInfo bootstrapMethodInfo) {
        ProgramClass programClass = (ProgramClass)clazz;
        MethodHandleConstant methodHandleConstant = (MethodHandleConstant)programClass.getConstant(bootstrapMethodInfo.u2methodHandleIndex);
        if (LambdaExpressionCollector.isLambdaMetaFactory(methodHandleConstant.getClassName(clazz))) {
            String string = this.referencedInvokeDynamicConstant.getType(clazz);
            String string2 = ClassUtil.internalClassNameFromClassType(ClassUtil.internalMethodReturnType(string));
            MethodHandleConstant methodHandleConstant2 = (MethodHandleConstant)programClass.getConstant(bootstrapMethodInfo.u2methodArguments[1]);
            this.referencedInvokedClass = null;
            this.referencedInvokedMethod = null;
            clazz.constantPoolEntryAccept(methodHandleConstant2.u2referenceIndex, this);
            LambdaExpression lambdaExpression = new LambdaExpression(programClass, this.referencedBootstrapMethodIndex, bootstrapMethodInfo, string, new String[]{string2}, new String[0], this.referencedInvokeDynamicConstant.getName(clazz), LambdaExpressionCollector.getMethodTypeConstant(programClass, bootstrapMethodInfo.u2methodArguments[0]).getType(clazz), methodHandleConstant2.getReferenceKind(), methodHandleConstant2.getClassName(clazz), methodHandleConstant2.getName(clazz), methodHandleConstant2.getType(clazz), this.referencedInvokedClass, this.referencedInvokedMethod);
            if (LambdaExpressionCollector.isAlternateFactoryMethod(methodHandleConstant.getName(clazz))) {
                Object object;
                int n;
                int n2;
                int n3 = LambdaExpressionCollector.getIntegerConstant(programClass, bootstrapMethodInfo.u2methodArguments[3]);
                int n4 = 4;
                if ((n3 & 2) != 0) {
                    n2 = LambdaExpressionCollector.getIntegerConstant(programClass, bootstrapMethodInfo.u2methodArguments[n4++]);
                    for (n = 0; n < n2; ++n) {
                        object = programClass.getClassName(bootstrapMethodInfo.u2methodArguments[n4++]);
                        lambdaExpression.interfaces = (String[])ArrayUtil.add(lambdaExpression.interfaces, lambdaExpression.interfaces.length, object);
                    }
                }
                if ((n3 & 4) != 0) {
                    n2 = LambdaExpressionCollector.getIntegerConstant(programClass, bootstrapMethodInfo.u2methodArguments[n4++]);
                    for (n = 0; n < n2; ++n) {
                        object = LambdaExpressionCollector.getMethodTypeConstant(programClass, bootstrapMethodInfo.u2methodArguments[n4++]);
                        lambdaExpression.bridgeMethodDescriptors = ArrayUtil.add(lambdaExpression.bridgeMethodDescriptors, lambdaExpression.bridgeMethodDescriptors.length, ((MethodTypeConstant)object).getType(programClass));
                    }
                }
                if ((n3 & 1) != 0) {
                    lambdaExpression.interfaces = ArrayUtil.add(lambdaExpression.interfaces, lambdaExpression.interfaces.length, "java/io/Serializable");
                }
            }
            this.lambdaExpressions.put(this.referencedBootstrapMethodIndex, lambdaExpression);
        }
    }

    private static boolean isLambdaMetaFactory(String string) {
        return NAME_JAVA_LANG_INVOKE_LAMBDA_METAFACTORY.equals(string);
    }

    private static boolean isAlternateFactoryMethod(String string) {
        return LAMBDA_ALTERNATE_METAFACTORY_METHOD.equals(string);
    }

    private static int getIntegerConstant(ProgramClass programClass, int n) {
        return ((IntegerConstant)programClass.getConstant(n)).getValue();
    }

    private static MethodTypeConstant getMethodTypeConstant(ProgramClass programClass, int n) {
        return (MethodTypeConstant)programClass.getConstant(n);
    }
}

