/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import java.io.Serializable;

public class SAMBinaryTagAndValue
implements Serializable {
    public static final long serialVersionUID = 1L;
    public final short tag;
    public final Object value;
    protected SAMBinaryTagAndValue next = null;

    public SAMBinaryTagAndValue(short tag, Object value) {
        this.tag = tag;
        this.value = value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.typeSafeEquals((SAMBinaryTagAndValue)o);
    }

    private boolean typeSafeEquals(SAMBinaryTagAndValue that) {
        if (this.tag != that.tag) {
            return false;
        }
        if (this.value == null ? that.value == null : this.value.equals(that.value)) {
            if (this.next == null) {
                return that.next == null;
            }
            return this.next.equals(that.next);
        }
        return false;
    }

    public int hashCode() {
        int result = this.tag;
        result = 31 * result + this.value.hashCode();
        return result;
    }

    public SAMBinaryTagAndValue copy() {
        SAMBinaryTagAndValue retval = new SAMBinaryTagAndValue(this.tag, this.value);
        if (this.next != null) {
            retval.next = this.next.copy();
        }
        return retval;
    }

    public SAMBinaryTagAndValue getNext() {
        return this.next;
    }

    public SAMBinaryTagAndValue insert(SAMBinaryTagAndValue attr) {
        if (attr == null) {
            return this;
        }
        if (attr.next != null) {
            throw new IllegalStateException("Can only insert single tag/value combinations.");
        }
        if (attr.tag < this.tag) {
            attr.next = this;
            return attr;
        }
        if (this.tag == attr.tag) {
            attr.next = this.next;
            return attr;
        }
        if (this.next == null) {
            this.next = attr;
            return this;
        }
        this.next = this.next.insert(attr);
        return this;
    }

    public SAMBinaryTagAndValue remove(short tag) {
        if (this.tag == tag) {
            return this.next;
        }
        if (this.next != null) {
            this.next = this.next.remove(tag);
        }
        return this;
    }

    public SAMBinaryTagAndValue find(short tag) {
        if (this.tag == tag) {
            return this;
        }
        if (this.tag > tag || this.next == null) {
            return null;
        }
        return this.next.find(tag);
    }

    public boolean isUnsignedArray() {
        return false;
    }
}

