/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions;

import java.math.BigDecimal;
import org.fest.assertions.ComparableAssert;
import org.fest.assertions.Condition;
import org.fest.assertions.Description;
import org.fest.assertions.NumberAssert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BigDecimalAssert
extends ComparableAssert<BigDecimal>
implements NumberAssert {
    protected BigDecimalAssert(BigDecimal actual) {
        super(actual);
    }

    public BigDecimalAssert as(String description) {
        this.description(description);
        return this;
    }

    public BigDecimalAssert describedAs(String description) {
        return this.as(description);
    }

    public BigDecimalAssert as(Description description) {
        this.description(description);
        return this;
    }

    public BigDecimalAssert describedAs(Description description) {
        return this.as(description);
    }

    public BigDecimalAssert satisfies(Condition<BigDecimal> condition) {
        this.assertSatisfies(condition);
        return this;
    }

    public BigDecimalAssert doesNotSatisfy(Condition<BigDecimal> condition) {
        this.assertDoesNotSatisfy(condition);
        return this;
    }

    public BigDecimalAssert is(Condition<BigDecimal> condition) {
        this.assertIs(condition);
        return this;
    }

    public BigDecimalAssert isNot(Condition<BigDecimal> condition) {
        this.assertIsNot(condition);
        return this;
    }

    @Override
    public BigDecimalAssert isPositive() {
        return this.isGreaterThan(BigDecimal.ZERO);
    }

    @Override
    public BigDecimalAssert isNegative() {
        return this.isLessThan(BigDecimal.ZERO);
    }

    @Override
    public BigDecimalAssert isZero() {
        return this.isEqualByComparingTo(BigDecimal.ZERO);
    }

    public BigDecimalAssert isNotNull() {
        this.assertNotNull();
        return this;
    }

    public BigDecimalAssert isSameAs(BigDecimal expected) {
        this.assertSameAs(expected);
        return this;
    }

    public BigDecimalAssert isNotSameAs(BigDecimal other) {
        this.assertNotSameAs(other);
        return this;
    }

    public BigDecimalAssert isEqualTo(BigDecimal expected) {
        this.assertEqualTo(expected);
        return this;
    }

    public BigDecimalAssert isNotEqualTo(BigDecimal other) {
        this.assertNotEqualTo(other);
        return this;
    }

    public BigDecimalAssert isEqualByComparingTo(BigDecimal expected) {
        this.assertIsEqualByComparingTo(expected);
        return this;
    }

    public BigDecimalAssert isNotEqualByComparingTo(BigDecimal expected) {
        this.assertIsNotEqualByComparingTo(expected);
        return this;
    }

    public BigDecimalAssert isLessThan(BigDecimal other) {
        this.assertIsLessThan(other);
        return this;
    }

    public BigDecimalAssert isGreaterThan(BigDecimal other) {
        this.assertIsGreaterThan(other);
        return this;
    }

    public BigDecimalAssert isLessThanOrEqualTo(BigDecimal other) {
        this.assertIsLessThanOrEqualTo(other);
        return this;
    }

    public BigDecimalAssert isGreaterThanOrEqualTo(BigDecimal other) {
        this.assertIsGreaterThanOrEqualTo(other);
        return this;
    }

    public BigDecimalAssert overridingErrorMessage(String message) {
        this.replaceDefaultErrorMessagesWith(message);
        return this;
    }
}

