/* math-display.c generated by valac 0.40.6, the Vala compiler
 * generated from math-display.vala, do not modify */

/*
 * Copyright (C) 2008-2012 Robert Ancell
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */


#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include "libcalculator.h"
#include <gtksourceview/gtksource.h>
#include <gdk/gdk.h>
#include <stdlib.h>
#include <string.h>
#include <atk/atk.h>


#define TYPE_MATH_DISPLAY (math_display_get_type ())
#define MATH_DISPLAY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MATH_DISPLAY, MathDisplay))
#define MATH_DISPLAY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MATH_DISPLAY, MathDisplayClass))
#define IS_MATH_DISPLAY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MATH_DISPLAY))
#define IS_MATH_DISPLAY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MATH_DISPLAY))
#define MATH_DISPLAY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MATH_DISPLAY, MathDisplayClass))

typedef struct _MathDisplay MathDisplay;
typedef struct _MathDisplayClass MathDisplayClass;
typedef struct _MathDisplayPrivate MathDisplayPrivate;

#define TYPE_HISTORY_VIEW (history_view_get_type ())
#define HISTORY_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_HISTORY_VIEW, HistoryView))
#define HISTORY_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_HISTORY_VIEW, HistoryViewClass))
#define IS_HISTORY_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_HISTORY_VIEW))
#define IS_HISTORY_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_HISTORY_VIEW))
#define HISTORY_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_HISTORY_VIEW, HistoryViewClass))

typedef struct _HistoryView HistoryView;
typedef struct _HistoryViewClass HistoryViewClass;
enum  {
	MATH_DISPLAY_0_PROPERTY,
	MATH_DISPLAY_EQUATION_PROPERTY,
	MATH_DISPLAY_NUM_PROPERTIES
};
static GParamSpec* math_display_properties[MATH_DISPLAY_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_COMPLETION_PROVIDER (completion_provider_get_type ())
#define COMPLETION_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COMPLETION_PROVIDER, CompletionProvider))
#define COMPLETION_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COMPLETION_PROVIDER, CompletionProviderClass))
#define IS_COMPLETION_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COMPLETION_PROVIDER))
#define IS_COMPLETION_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COMPLETION_PROVIDER))
#define COMPLETION_PROVIDER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COMPLETION_PROVIDER, CompletionProviderClass))

typedef struct _CompletionProvider CompletionProvider;
typedef struct _CompletionProviderClass CompletionProviderClass;

#define TYPE_FUNCTION_COMPLETION_PROVIDER (function_completion_provider_get_type ())
#define FUNCTION_COMPLETION_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FUNCTION_COMPLETION_PROVIDER, FunctionCompletionProvider))
#define FUNCTION_COMPLETION_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FUNCTION_COMPLETION_PROVIDER, FunctionCompletionProviderClass))
#define IS_FUNCTION_COMPLETION_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FUNCTION_COMPLETION_PROVIDER))
#define IS_FUNCTION_COMPLETION_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FUNCTION_COMPLETION_PROVIDER))
#define FUNCTION_COMPLETION_PROVIDER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FUNCTION_COMPLETION_PROVIDER, FunctionCompletionProviderClass))

typedef struct _FunctionCompletionProvider FunctionCompletionProvider;
typedef struct _FunctionCompletionProviderClass FunctionCompletionProviderClass;

#define TYPE_VARIABLE_COMPLETION_PROVIDER (variable_completion_provider_get_type ())
#define VARIABLE_COMPLETION_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VARIABLE_COMPLETION_PROVIDER, VariableCompletionProvider))
#define VARIABLE_COMPLETION_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VARIABLE_COMPLETION_PROVIDER, VariableCompletionProviderClass))
#define IS_VARIABLE_COMPLETION_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VARIABLE_COMPLETION_PROVIDER))
#define IS_VARIABLE_COMPLETION_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VARIABLE_COMPLETION_PROVIDER))
#define VARIABLE_COMPLETION_PROVIDER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VARIABLE_COMPLETION_PROVIDER, VariableCompletionProviderClass))

typedef struct _VariableCompletionProvider VariableCompletionProvider;
typedef struct _VariableCompletionProviderClass VariableCompletionProviderClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define __vala_GdkEventKey_free0(var) ((var == NULL) ? NULL : (var = (_vala_GdkEventKey_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _CompletionProviderPrivate CompletionProviderPrivate;
enum  {
	COMPLETION_PROVIDER_0_PROPERTY,
	COMPLETION_PROVIDER_NUM_PROPERTIES
};
static GParamSpec* completion_provider_properties[COMPLETION_PROVIDER_NUM_PROPERTIES];
typedef struct _FunctionCompletionProviderPrivate FunctionCompletionProviderPrivate;
enum  {
	FUNCTION_COMPLETION_PROVIDER_0_PROPERTY,
	FUNCTION_COMPLETION_PROVIDER_NUM_PROPERTIES
};
static GParamSpec* function_completion_provider_properties[FUNCTION_COMPLETION_PROVIDER_NUM_PROPERTIES];
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
typedef struct _VariableCompletionProviderPrivate VariableCompletionProviderPrivate;
enum  {
	VARIABLE_COMPLETION_PROVIDER_0_PROPERTY,
	VARIABLE_COMPLETION_PROVIDER_NUM_PROPERTIES
};
static GParamSpec* variable_completion_provider_properties[VARIABLE_COMPLETION_PROVIDER_NUM_PROPERTIES];

struct _MathDisplay {
	GtkViewport parent_instance;
	MathDisplayPrivate * priv;
};

struct _MathDisplayClass {
	GtkViewportClass parent_class;
};

struct _MathDisplayPrivate {
	MathEquation* _equation;
	HistoryView* history;
	GtkSourceView* source_view;
	GtkTextBuffer* info_buffer;
	GtkSpinner* spinner;
};

struct _CompletionProvider {
	GObject parent_instance;
	CompletionProviderPrivate * priv;
};

struct _CompletionProviderClass {
	GObjectClass parent_class;
	gchar* (*get_name) (CompletionProvider* self);
	GtkSourceCompletionItem* (*create_proposal) (CompletionProvider* self, const gchar* label, const gchar* text, const gchar* details);
	gboolean (*get_start_iter) (CompletionProvider* self, GtkSourceCompletionContext* context, GtkSourceCompletionProposal* proposal, GtkTextIter* iter);
	gboolean (*activate_proposal) (CompletionProvider* self, GtkSourceCompletionProposal* proposal, GtkTextIter* iter);
	void (*populate) (CompletionProvider* self, GtkSourceCompletionContext* context);
};

struct _FunctionCompletionProvider {
	CompletionProvider parent_instance;
	FunctionCompletionProviderPrivate * priv;
};

struct _FunctionCompletionProviderClass {
	CompletionProviderClass parent_class;
};

struct _VariableCompletionProvider {
	CompletionProvider parent_instance;
	VariableCompletionProviderPrivate * priv;
};

struct _VariableCompletionProviderClass {
	CompletionProviderClass parent_class;
};

struct _VariableCompletionProviderPrivate {
	MathEquation* _equation;
};


static gpointer math_display_parent_class = NULL;
static gpointer completion_provider_parent_class = NULL;
static GtkSourceCompletionProviderIface * completion_provider_gtk_source_completion_provider_parent_iface = NULL;
static gpointer function_completion_provider_parent_class = NULL;
static gpointer variable_completion_provider_parent_class = NULL;

GType math_display_get_type (void) G_GNUC_CONST;
GType history_view_get_type (void) G_GNUC_CONST;
#define MATH_DISPLAY_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_MATH_DISPLAY, MathDisplayPrivate))
MathDisplay* math_display_new (MathEquation* equation);
MathDisplay* math_display_construct (GType object_type,
                                     MathEquation* equation);
void math_display_handler (MathDisplay* self,
                           const gchar* answer,
                           Number* number,
                           gint number_base,
                           guint representation_base);
static void _math_display_handler_math_equation_history_signal (MathEquation* _sender,
                                                         const gchar* answer,
                                                         Number* number,
                                                         gint number_base,
                                                         guint representation_base,
                                                         gpointer self);
HistoryView* history_view_new (void);
HistoryView* history_view_construct (GType object_type);
static void __lambda7_ (MathDisplay* self,
                 const gchar* ans);
void math_display_insert_text (MathDisplay* self,
                               const gchar* answer);
static void ___lambda7__history_view_answer_clicked (HistoryView* _sender,
                                              const gchar* ans,
                                              gpointer self);
static void __lambda8_ (MathDisplay* self,
                 const gchar* eq);
void math_display_display_text (MathDisplay* self,
                                const gchar* prev_eq);
static void ___lambda8__history_view_equation_clicked (HistoryView* _sender,
                                                const gchar* equation,
                                                gpointer self);
static gboolean math_display_key_press_cb (MathDisplay* self,
                                    GdkEventKey* event);
static gboolean _math_display_key_press_cb_gtk_widget_key_press_event (GtkWidget* _sender,
                                                                GdkEventKey* event,
                                                                gpointer self);
static void math_display_create_autocompletion (MathDisplay* self);
static void __lambda9_ (MathDisplay* self,
                 GParamSpec* pspec);
static void math_display_status_changed_cb (MathDisplay* self);
static void ___lambda9__g_object_notify (GObject* _sender,
                                  GParamSpec* pspec,
                                  gpointer self);
static void __lambda10_ (MathDisplay* self,
                  GParamSpec* pspec);
static void math_display_error_status_changed_cb (MathDisplay* self);
static void ___lambda10__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
void math_display_grabfocus (MathDisplay* self);
void math_display_update_history (MathDisplay* self,
                                  const gchar* answer,
                                  Number* number,
                                  gint number_base,
                                  guint representation_base);
void history_view_insert_entry (HistoryView* self,
                                const gchar* equation,
                                Number* answer,
                                gint number_base,
                                guint representation_base);
void math_display_clear_history (MathDisplay* self);
void history_view_clear (HistoryView* self);
FunctionCompletionProvider* function_completion_provider_new (void);
FunctionCompletionProvider* function_completion_provider_construct (GType object_type);
GType completion_provider_get_type (void) G_GNUC_CONST;
GType function_completion_provider_get_type (void) G_GNUC_CONST;
MathEquation* math_display_get_equation (MathDisplay* self);
VariableCompletionProvider* variable_completion_provider_new (MathEquation* equation);
VariableCompletionProvider* variable_completion_provider_construct (GType object_type,
                                                                    MathEquation* equation);
GType variable_completion_provider_get_type (void) G_GNUC_CONST;
static gboolean math_display_function_completion_window_visible (MathDisplay* self);
MathFunction** function_completion_provider_get_matches_for_completion_at_cursor (GtkTextBuffer* text_buffer,
                                                                                  int* result_length1);
gchar** variable_completion_provider_get_matches_for_completion_at_cursor (GtkTextBuffer* text_buffer,
                                                                           MathVariables* variables,
                                                                           int* result_length1);
static gboolean math_display_real_key_press_event (GtkWidget* base,
                                            GdkEventKey* event);
static GdkEventKey* _vala_GdkEventKey_copy (GdkEventKey* self);
static void _vala_GdkEventKey_free (GdkEventKey* self);
void math_display_grab_focus (MathDisplay* self);
static void math_display_finalize (GObject * obj);
static void _vala_math_display_get_property (GObject * object,
                                      guint property_id,
                                      GValue * value,
                                      GParamSpec * pspec);
gchar* completion_provider_get_name (CompletionProvider* self);
static gchar* completion_provider_real_get_name (CompletionProvider* self);
GtkSourceCompletionItem* completion_provider_create_proposal (CompletionProvider* self,
                                                              const gchar* label,
                                                              const gchar* text,
                                                              const gchar* details);
static GtkSourceCompletionItem* completion_provider_real_create_proposal (CompletionProvider* self,
                                                                   const gchar* label,
                                                                   const gchar* text,
                                                                   const gchar* details);
void completion_provider_move_iter_to_name_start (GtkTextIter* iter);
gboolean completion_provider_get_start_iter (CompletionProvider* self,
                                             GtkSourceCompletionContext* context,
                                             GtkSourceCompletionProposal* proposal,
                                             GtkTextIter* iter);
static gboolean completion_provider_real_get_start_iter (CompletionProvider* self,
                                                  GtkSourceCompletionContext* context,
                                                  GtkSourceCompletionProposal* proposal,
                                                  GtkTextIter* iter);
gboolean completion_provider_activate_proposal (CompletionProvider* self,
                                                GtkSourceCompletionProposal* proposal,
                                                GtkTextIter* iter);
static gboolean completion_provider_real_activate_proposal (CompletionProvider* self,
                                                     GtkSourceCompletionProposal* proposal,
                                                     GtkTextIter* iter);
void completion_provider_populate (CompletionProvider* self,
                                   GtkSourceCompletionContext* context);
static void completion_provider_real_populate (CompletionProvider* self,
                                        GtkSourceCompletionContext* context);
CompletionProvider* completion_provider_new (void);
CompletionProvider* completion_provider_construct (GType object_type);
static gchar* function_completion_provider_real_get_name (CompletionProvider* base);
static void function_completion_provider_real_populate (CompletionProvider* base,
                                                 GtkSourceCompletionContext* context);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
#define VARIABLE_COMPLETION_PROVIDER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_VARIABLE_COMPLETION_PROVIDER, VariableCompletionProviderPrivate))
static gchar* variable_completion_provider_real_get_name (CompletionProvider* base);
static void variable_completion_provider_real_populate (CompletionProvider* base,
                                                 GtkSourceCompletionContext* context);
static void variable_completion_provider_finalize (GObject * obj);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);


static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}


static void
_math_display_handler_math_equation_history_signal (MathEquation* _sender,
                                                    const gchar* answer,
                                                    Number* number,
                                                    gint number_base,
                                                    guint representation_base,
                                                    gpointer self)
{
	math_display_handler ((MathDisplay*) self, answer, number, number_base, representation_base);
}


static void
__lambda7_ (MathDisplay* self,
            const gchar* ans)
{
	g_return_if_fail (ans != NULL);
	math_display_insert_text (self, ans);
}


static void
___lambda7__history_view_answer_clicked (HistoryView* _sender,
                                         const gchar* ans,
                                         gpointer self)
{
	__lambda7_ ((MathDisplay*) self, ans);
}


static void
__lambda8_ (MathDisplay* self,
            const gchar* eq)
{
	g_return_if_fail (eq != NULL);
	math_display_display_text (self, eq);
}


static void
___lambda8__history_view_equation_clicked (HistoryView* _sender,
                                           const gchar* equation,
                                           gpointer self)
{
	__lambda8_ ((MathDisplay*) self, equation);
}


static gboolean
_math_display_key_press_cb_gtk_widget_key_press_event (GtkWidget* _sender,
                                                       GdkEventKey* event,
                                                       gpointer self)
{
	gboolean result;
	result = math_display_key_press_cb ((MathDisplay*) self, event);
	return result;
}


static void
__lambda9_ (MathDisplay* self,
            GParamSpec* pspec)
{
	g_return_if_fail (pspec != NULL);
	math_display_status_changed_cb (self);
}


static void
___lambda9__g_object_notify (GObject* _sender,
                             GParamSpec* pspec,
                             gpointer self)
{
	__lambda9_ ((MathDisplay*) self, pspec);
}


static void
__lambda10_ (MathDisplay* self,
             GParamSpec* pspec)
{
	g_return_if_fail (pspec != NULL);
	math_display_error_status_changed_cb (self);
}


static void
___lambda10__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
	__lambda10_ ((MathDisplay*) self, pspec);
}


MathDisplay*
math_display_construct (GType object_type,
                        MathEquation* equation)
{
	MathDisplay * self = NULL;
	MathEquation* _tmp0_;
	MathEquation* _tmp1_;
	GtkBox* main_box = NULL;
	GtkBox* _tmp2_;
	HistoryView* _tmp3_;
	HistoryView* _tmp4_;
	HistoryView* _tmp5_;
	HistoryView* _tmp6_;
	GtkScrolledWindow* scrolled_window = NULL;
	GtkScrolledWindow* _tmp7_;
	GtkStyleContext* style_context = NULL;
	GtkStyleContext* _tmp8_;
	GtkStyleContext* _tmp9_;
	GtkStyleContext* _tmp10_;
	GtkSourceView* _tmp11_;
	GtkSourceView* _tmp12_;
	GtkSourceView* _tmp13_;
	GtkSourceView* _tmp14_;
	GtkSourceView* _tmp15_;
	GtkSourceView* _tmp16_;
	GtkSourceView* _tmp17_;
	GtkSourceView* _tmp18_;
	GtkSourceView* _tmp19_;
	AtkObject* _tmp20_;
	GtkSourceView* _tmp21_;
	GtkSourceView* _tmp22_;
	GtkBox* info_box = NULL;
	GtkBox* _tmp23_;
	GtkTextView* info_view = NULL;
	GtkTextView* _tmp24_;
	GtkTextBuffer* _tmp25_;
	GtkTextBuffer* _tmp26_;
	GtkStyleContext* _tmp27_;
	GtkStyleContext* _tmp28_;
	GtkStyleContext* _tmp29_;
	GtkSpinner* _tmp30_;
	GtkSpinner* _tmp31_;
	GtkSourceView* _tmp32_;
	g_return_val_if_fail (equation != NULL, NULL);
	self = (MathDisplay*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (equation);
	_g_object_unref0 (self->priv->_equation);
	self->priv->_equation = _tmp0_;
	_tmp1_ = self->priv->_equation;
	g_signal_connect_object (_tmp1_, "history-signal", (GCallback) _math_display_handler_math_equation_history_signal, self, 0);
	_tmp2_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	g_object_ref_sink (_tmp2_);
	main_box = _tmp2_;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) main_box);
	_tmp3_ = history_view_new ();
	g_object_ref_sink (_tmp3_);
	_g_object_unref0 (self->priv->history);
	self->priv->history = _tmp3_;
	_tmp4_ = self->priv->history;
	g_signal_connect_object (_tmp4_, "answer-clicked", (GCallback) ___lambda7__history_view_answer_clicked, self, 0);
	_tmp5_ = self->priv->history;
	g_signal_connect_object (_tmp5_, "equation-clicked", (GCallback) ___lambda8__history_view_equation_clicked, self, 0);
	_tmp6_ = self->priv->history;
	gtk_container_add ((GtkContainer*) main_box, (GtkWidget*) _tmp6_);
	gtk_widget_show_all ((GtkWidget*) main_box);
	_tmp7_ = (GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL);
	g_object_ref_sink (_tmp7_);
	scrolled_window = _tmp7_;
	_tmp8_ = gtk_widget_get_style_context ((GtkWidget*) scrolled_window);
	_tmp9_ = _g_object_ref0 (_tmp8_);
	style_context = _tmp9_;
	_tmp10_ = style_context;
	gtk_style_context_add_class (_tmp10_, "display-scrolled");
	gtk_scrolled_window_set_policy (scrolled_window, GTK_POLICY_AUTOMATIC, GTK_POLICY_NEVER);
	_tmp11_ = (GtkSourceView*) gtk_source_view_new_with_buffer ((GtkSourceBuffer*) equation);
	g_object_ref_sink (_tmp11_);
	_g_object_unref0 (self->priv->source_view);
	self->priv->source_view = _tmp11_;
	_tmp12_ = self->priv->source_view;
	gtk_text_view_set_accepts_tab ((GtkTextView*) _tmp12_, FALSE);
	_tmp13_ = self->priv->source_view;
	gtk_text_view_set_left_margin ((GtkTextView*) _tmp13_, 14);
	_tmp14_ = self->priv->source_view;
	gtk_text_view_set_pixels_above_lines ((GtkTextView*) _tmp14_, 8);
	_tmp15_ = self->priv->source_view;
	gtk_text_view_set_pixels_below_lines ((GtkTextView*) _tmp15_, 2);
	_tmp16_ = self->priv->source_view;
	gtk_text_view_set_justification ((GtkTextView*) _tmp16_, GTK_JUSTIFY_LEFT);
	_tmp17_ = self->priv->source_view;
	gtk_buildable_set_name ((GtkBuildable*) _tmp17_, "displayitem");
	_tmp18_ = self->priv->source_view;
	gtk_widget_set_size_request ((GtkWidget*) _tmp18_, 20, 20);
	_tmp19_ = self->priv->source_view;
	_tmp20_ = gtk_widget_get_accessible ((GtkWidget*) _tmp19_);
	atk_object_set_role (_tmp20_, ATK_ROLE_EDITBAR);
	_tmp21_ = self->priv->source_view;
	g_signal_connect_object ((GtkWidget*) _tmp21_, "key-press-event", (GCallback) _math_display_key_press_cb_gtk_widget_key_press_event, self, 0);
	math_display_create_autocompletion (self);
	gtk_box_pack_start (main_box, (GtkWidget*) scrolled_window, FALSE, FALSE, (guint) 0);
	_tmp22_ = self->priv->source_view;
	gtk_container_add ((GtkContainer*) scrolled_window, (GtkWidget*) _tmp22_);
	gtk_widget_show ((GtkWidget*) scrolled_window);
	_tmp23_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 6);
	g_object_ref_sink (_tmp23_);
	info_box = _tmp23_;
	gtk_box_pack_start (main_box, (GtkWidget*) info_box, FALSE, TRUE, (guint) 0);
	_tmp24_ = (GtkTextView*) gtk_text_view_new ();
	g_object_ref_sink (_tmp24_);
	info_view = _tmp24_;
	gtk_text_view_set_wrap_mode (info_view, GTK_WRAP_WORD);
	gtk_widget_set_can_focus ((GtkWidget*) info_view, FALSE);
	gtk_text_view_set_editable (info_view, FALSE);
	gtk_text_view_set_left_margin (info_view, 12);
	gtk_text_view_set_right_margin (info_view, 12);
	gtk_box_pack_start (info_box, (GtkWidget*) info_view, TRUE, TRUE, (guint) 0);
	_tmp25_ = gtk_text_view_get_buffer (info_view);
	_tmp26_ = _g_object_ref0 (_tmp25_);
	_g_object_unref0 (self->priv->info_buffer);
	self->priv->info_buffer = _tmp26_;
	_tmp27_ = gtk_widget_get_style_context ((GtkWidget*) info_view);
	_tmp28_ = _g_object_ref0 (_tmp27_);
	_g_object_unref0 (style_context);
	style_context = _tmp28_;
	_tmp29_ = style_context;
	gtk_style_context_add_class (_tmp29_, "info-view");
	_tmp30_ = (GtkSpinner*) gtk_spinner_new ();
	g_object_ref_sink (_tmp30_);
	_g_object_unref0 (self->priv->spinner);
	self->priv->spinner = _tmp30_;
	_tmp31_ = self->priv->spinner;
	gtk_box_pack_end (info_box, (GtkWidget*) _tmp31_, FALSE, FALSE, (guint) 0);
	gtk_widget_show ((GtkWidget*) info_box);
	gtk_widget_show ((GtkWidget*) info_view);
	_tmp32_ = self->priv->source_view;
	gtk_widget_show ((GtkWidget*) _tmp32_);
	gtk_widget_show ((GtkWidget*) main_box);
	g_signal_connect_object ((GObject*) equation, "notify::status", (GCallback) ___lambda9__g_object_notify, self, 0);
	math_display_status_changed_cb (self);
	g_signal_connect_object ((GObject*) equation, "notify::error-token-end", (GCallback) ___lambda10__g_object_notify, self, 0);
	_g_object_unref0 (info_view);
	_g_object_unref0 (info_box);
	_g_object_unref0 (style_context);
	_g_object_unref0 (scrolled_window);
	_g_object_unref0 (main_box);
	return self;
}


MathDisplay*
math_display_new (MathEquation* equation)
{
	return math_display_construct (TYPE_MATH_DISPLAY, equation);
}


void
math_display_grabfocus (MathDisplay* self)
{
	GtkSourceView* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->source_view;
	gtk_widget_grab_focus ((GtkWidget*) _tmp0_);
}


void
math_display_handler (MathDisplay* self,
                      const gchar* answer,
                      Number* number,
                      gint number_base,
                      guint representation_base)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (answer != NULL);
	g_return_if_fail (number != NULL);
	math_display_update_history (self, answer, number, number_base, representation_base);
}


void
math_display_display_text (MathDisplay* self,
                           const gchar* prev_eq)
{
	MathEquation* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (prev_eq != NULL);
	_tmp0_ = self->priv->_equation;
	math_equation_display_selected (_tmp0_, prev_eq);
}


void
math_display_update_history (MathDisplay* self,
                             const gchar* answer,
                             Number* number,
                             gint number_base,
                             guint representation_base)
{
	HistoryView* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (answer != NULL);
	g_return_if_fail (number != NULL);
	_tmp0_ = self->priv->history;
	history_view_insert_entry (_tmp0_, answer, number, number_base, representation_base);
}


void
math_display_clear_history (MathDisplay* self)
{
	HistoryView* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->history;
	history_view_clear (_tmp0_);
}


void
math_display_insert_text (MathDisplay* self,
                          const gchar* answer)
{
	MathEquation* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (answer != NULL);
	_tmp0_ = self->priv->_equation;
	math_equation_insert_selected (_tmp0_, answer);
}


static void
math_display_create_autocompletion (MathDisplay* self)
{
	GtkSourceCompletion* completion = NULL;
	GtkSourceView* _tmp0_;
	GtkSourceCompletion* _tmp1_;
	GtkSourceCompletion* _tmp2_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->source_view;
	_tmp1_ = gtk_source_view_get_completion (_tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	completion = _tmp2_;
	{
		GtkSourceCompletion* _tmp3_;
		FunctionCompletionProvider* _tmp4_;
		FunctionCompletionProvider* _tmp5_;
		GtkSourceCompletion* _tmp6_;
		MathEquation* _tmp7_;
		MathEquation* _tmp8_;
		VariableCompletionProvider* _tmp9_;
		VariableCompletionProvider* _tmp10_;
		_tmp3_ = completion;
		_tmp4_ = function_completion_provider_new ();
		_tmp5_ = _tmp4_;
		gtk_source_completion_add_provider (_tmp3_, (GtkSourceCompletionProvider*) _tmp5_, &_inner_error_);
		_g_object_unref0 (_tmp5_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch5_g_error;
		}
		_tmp6_ = completion;
		_tmp7_ = math_display_get_equation (self);
		_tmp8_ = _tmp7_;
		_tmp9_ = variable_completion_provider_new (_tmp8_);
		_tmp10_ = _tmp9_;
		gtk_source_completion_add_provider (_tmp6_, (GtkSourceCompletionProvider*) _tmp10_, &_inner_error_);
		_g_object_unref0 (_tmp10_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch5_g_error;
		}
	}
	goto __finally5;
	__catch5_g_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("math-display.vala:132: Could not add CompletionProvider to source-view");
		_g_error_free0 (e);
	}
	__finally5:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (completion);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_object_unref0 (completion);
}


static gboolean
math_display_function_completion_window_visible (MathDisplay* self)
{
	gboolean result = FALSE;
	GList* providers_list = NULL;
	GtkSourceView* _tmp0_;
	GtkSourceCompletion* _tmp1_;
	GList* _tmp2_;
	GList* _tmp3_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->source_view;
	_tmp1_ = gtk_source_view_get_completion (_tmp0_);
	_tmp2_ = gtk_source_completion_get_providers (_tmp1_);
	providers_list = _tmp2_;
	_tmp3_ = providers_list;
	if (g_list_length (_tmp3_) > ((guint) 0)) {
		MathFunction** functions = NULL;
		MathEquation* _tmp4_;
		MathEquation* _tmp5_;
		gint _tmp6_;
		MathFunction** _tmp7_;
		gint functions_length1;
		gint _functions_size_;
		gchar** variables = NULL;
		MathEquation* _tmp8_;
		MathEquation* _tmp9_;
		MathEquation* _tmp10_;
		MathEquation* _tmp11_;
		MathVariables* _tmp12_;
		MathVariables* _tmp13_;
		gint _tmp14_;
		gchar** _tmp15_;
		gint variables_length1;
		gint _variables_size_;
		gboolean _tmp16_ = FALSE;
		gboolean _tmp17_ = FALSE;
		MathFunction** _tmp18_;
		gint _tmp18__length1;
		_tmp4_ = math_display_get_equation (self);
		_tmp5_ = _tmp4_;
		_tmp7_ = function_completion_provider_get_matches_for_completion_at_cursor ((GtkTextBuffer*) _tmp5_, &_tmp6_);
		functions = _tmp7_;
		functions_length1 = _tmp6_;
		_functions_size_ = functions_length1;
		_tmp8_ = math_display_get_equation (self);
		_tmp9_ = _tmp8_;
		_tmp10_ = math_display_get_equation (self);
		_tmp11_ = _tmp10_;
		_tmp12_ = math_equation_get_variables (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp15_ = variable_completion_provider_get_matches_for_completion_at_cursor ((GtkTextBuffer*) _tmp9_, _tmp13_, &_tmp14_);
		variables = _tmp15_;
		variables_length1 = _tmp14_;
		_variables_size_ = variables_length1;
		_tmp18_ = functions;
		_tmp18__length1 = functions_length1;
		if (_tmp18__length1 > 0) {
			_tmp17_ = TRUE;
		} else {
			gchar** _tmp19_;
			gint _tmp19__length1;
			_tmp19_ = variables;
			_tmp19__length1 = variables_length1;
			_tmp17_ = _tmp19__length1 > 0;
		}
		if (_tmp17_) {
			_tmp16_ = TRUE;
		} else {
			_tmp16_ = FALSE;
		}
		result = _tmp16_;
		variables = (_vala_array_free (variables, variables_length1, (GDestroyNotify) g_free), NULL);
		functions = (_vala_array_free (functions, functions_length1, (GDestroyNotify) g_object_unref), NULL);
		return result;
	}
	result = FALSE;
	return result;
}


static gboolean
math_display_real_key_press_event (GtkWidget* base,
                                   GdkEventKey* event)
{
	MathDisplay * self;
	gboolean result = FALSE;
	GtkSourceView* _tmp0_;
	gboolean _tmp1_ = FALSE;
	self = (MathDisplay*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = self->priv->source_view;
	g_signal_emit_by_name ((GtkWidget*) _tmp0_, "key-press-event", event, &_tmp1_);
	result = _tmp1_;
	return result;
}


static GdkEventKey*
_vala_GdkEventKey_copy (GdkEventKey* self)
{
	return g_boxed_copy (gdk_event_get_type (), self);
}


static gpointer
__vala_GdkEventKey_copy0 (gpointer self)
{
	return self ? _vala_GdkEventKey_copy (self) : NULL;
}


static void
_vala_GdkEventKey_free (GdkEventKey* self)
{
	g_boxed_free (gdk_event_get_type (), self);
}


static gboolean
math_display_key_press_cb (MathDisplay* self,
                           GdkEventKey* event)
{
	gboolean result = FALSE;
	guint new_keyval = 0U;
	guint _tmp0_;
	guint _tmp1_;
	GdkModifierType state = 0;
	GdkModifierType _tmp7_;
	guint32 c = 0U;
	guint _tmp8_;
	gboolean _tmp9_ = FALSE;
	guint _tmp10_;
	gboolean _tmp14_ = FALSE;
	gboolean _tmp15_ = FALSE;
	guint _tmp16_;
	gboolean _tmp23_ = FALSE;
	guint _tmp24_;
	GdkModifierType _tmp28_;
	GdkModifierType _tmp38_;
	GdkModifierType _tmp60_;
	gboolean _tmp66_ = FALSE;
	GdkModifierType _tmp67_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	new_keyval = (guint) 0;
	_tmp0_ = event->keyval;
	switch (_tmp0_) {
		case GDK_KEY_KP_Insert:
		{
			new_keyval = (guint) GDK_KEY_0;
			break;
		}
		case GDK_KEY_KP_End:
		{
			new_keyval = (guint) GDK_KEY_1;
			break;
		}
		case GDK_KEY_KP_Down:
		{
			new_keyval = (guint) GDK_KEY_2;
			break;
		}
		case GDK_KEY_KP_Page_Down:
		{
			new_keyval = (guint) GDK_KEY_3;
			break;
		}
		case GDK_KEY_KP_Left:
		{
			new_keyval = (guint) GDK_KEY_4;
			break;
		}
		case GDK_KEY_KP_Begin:
		{
			new_keyval = (guint) GDK_KEY_5;
			break;
		}
		case GDK_KEY_KP_Right:
		{
			new_keyval = (guint) GDK_KEY_6;
			break;
		}
		case GDK_KEY_KP_Home:
		{
			new_keyval = (guint) GDK_KEY_7;
			break;
		}
		case GDK_KEY_KP_Up:
		{
			new_keyval = (guint) GDK_KEY_8;
			break;
		}
		case GDK_KEY_KP_Page_Up:
		{
			new_keyval = (guint) GDK_KEY_9;
			break;
		}
		case GDK_KEY_KP_Delete:
		{
			new_keyval = (guint) GDK_KEY_period;
			break;
		}
		default:
		break;
	}
	_tmp1_ = new_keyval;
	if (_tmp1_ != ((guint) 0)) {
		GdkEventKey* new_event = NULL;
		GdkEventKey* _tmp2_;
		GdkEventKey* _tmp3_;
		guint _tmp4_;
		GdkEventKey* _tmp5_;
		gboolean _tmp6_ = FALSE;
		_tmp2_ = __vala_GdkEventKey_copy0 (event);
		new_event = _tmp2_;
		_tmp3_ = new_event;
		_tmp4_ = new_keyval;
		_tmp3_->keyval = _tmp4_;
		_tmp5_ = new_event;
		g_signal_emit_by_name ((GtkWidget*) self, "key-press-event", _tmp5_, &_tmp6_);
		result = _tmp6_;
		__vala_GdkEventKey_free0 (new_event);
		return result;
	}
	_tmp7_ = event->state;
	state = _tmp7_ & (GDK_CONTROL_MASK | GDK_MOD1_MASK);
	_tmp8_ = event->keyval;
	c = gdk_keyval_to_unicode (_tmp8_);
	_tmp10_ = event->keyval;
	if (_tmp10_ == ((guint) GDK_KEY_Return)) {
		_tmp9_ = TRUE;
	} else {
		guint _tmp11_;
		_tmp11_ = event->keyval;
		_tmp9_ = _tmp11_ == ((guint) GDK_KEY_KP_Enter);
	}
	if (_tmp9_) {
		MathEquation* _tmp12_;
		MathEquation* _tmp13_;
		if (math_display_function_completion_window_visible (self)) {
			result = FALSE;
			return result;
		}
		_tmp12_ = math_display_get_equation (self);
		_tmp13_ = _tmp12_;
		math_equation_solve (_tmp13_);
		result = TRUE;
		return result;
	}
	_tmp16_ = event->keyval;
	if (_tmp16_ == ((guint) GDK_KEY_Escape)) {
		GdkModifierType _tmp17_;
		_tmp17_ = state;
		_tmp15_ = _tmp17_ == 0;
	} else {
		_tmp15_ = FALSE;
	}
	if (_tmp15_) {
		_tmp14_ = TRUE;
	} else {
		gboolean _tmp18_ = FALSE;
		guint _tmp19_;
		_tmp19_ = event->keyval;
		if (_tmp19_ == ((guint) GDK_KEY_Delete)) {
			GdkModifierType _tmp20_;
			_tmp20_ = state;
			_tmp18_ = _tmp20_ == GDK_SHIFT_MASK;
		} else {
			_tmp18_ = FALSE;
		}
		_tmp14_ = _tmp18_;
	}
	if (_tmp14_) {
		MathEquation* _tmp21_;
		MathEquation* _tmp22_;
		_tmp21_ = math_display_get_equation (self);
		_tmp22_ = _tmp21_;
		math_equation_clear (_tmp22_);
		result = TRUE;
		return result;
	}
	_tmp24_ = event->keyval;
	if (_tmp24_ == ((guint) GDK_KEY_KP_Decimal)) {
		_tmp23_ = TRUE;
	} else {
		guint _tmp25_;
		_tmp25_ = event->keyval;
		_tmp23_ = _tmp25_ == ((guint) GDK_KEY_KP_Separator);
	}
	if (_tmp23_) {
		MathEquation* _tmp26_;
		MathEquation* _tmp27_;
		_tmp26_ = math_display_get_equation (self);
		_tmp27_ = _tmp26_;
		math_equation_insert_numeric_point (_tmp27_);
		result = TRUE;
		return result;
	}
	_tmp28_ = state;
	if (_tmp28_ == 0) {
		guint32 _tmp29_;
		guint32 _tmp32_;
		guint32 _tmp35_;
		_tmp29_ = c;
		if (_tmp29_ == ((guint32) '*')) {
			MathEquation* _tmp30_;
			MathEquation* _tmp31_;
			_tmp30_ = math_display_get_equation (self);
			_tmp31_ = _tmp30_;
			math_equation_insert (_tmp31_, "×");
			result = TRUE;
			return result;
		}
		_tmp32_ = c;
		if (_tmp32_ == ((guint32) '/')) {
			MathEquation* _tmp33_;
			MathEquation* _tmp34_;
			_tmp33_ = math_display_get_equation (self);
			_tmp34_ = _tmp33_;
			math_equation_insert (_tmp34_, "÷");
			result = TRUE;
			return result;
		}
		_tmp35_ = c;
		if (_tmp35_ == ((guint32) '-')) {
			MathEquation* _tmp36_;
			MathEquation* _tmp37_;
			_tmp36_ = math_display_get_equation (self);
			_tmp37_ = _tmp36_;
			math_equation_insert_subtract (_tmp37_);
			result = TRUE;
			return result;
		}
	}
	_tmp38_ = state;
	if (_tmp38_ == GDK_CONTROL_MASK) {
		guint _tmp39_;
		_tmp39_ = event->keyval;
		switch (_tmp39_) {
			case GDK_KEY_bracketleft:
			{
				MathEquation* _tmp40_;
				MathEquation* _tmp41_;
				_tmp40_ = math_display_get_equation (self);
				_tmp41_ = _tmp40_;
				math_equation_insert (_tmp41_, "⌈");
				result = TRUE;
				return result;
			}
			case GDK_KEY_bracketright:
			{
				MathEquation* _tmp42_;
				MathEquation* _tmp43_;
				_tmp42_ = math_display_get_equation (self);
				_tmp43_ = _tmp42_;
				math_equation_insert (_tmp43_, "⌉");
				result = TRUE;
				return result;
			}
			case GDK_KEY_e:
			{
				MathEquation* _tmp44_;
				MathEquation* _tmp45_;
				_tmp44_ = math_display_get_equation (self);
				_tmp45_ = _tmp44_;
				math_equation_insert_exponent (_tmp45_);
				result = TRUE;
				return result;
			}
			case GDK_KEY_f:
			{
				MathEquation* _tmp46_;
				MathEquation* _tmp47_;
				_tmp46_ = math_display_get_equation (self);
				_tmp47_ = _tmp46_;
				math_equation_factorize (_tmp47_);
				result = TRUE;
				return result;
			}
			case GDK_KEY_i:
			{
				MathEquation* _tmp48_;
				MathEquation* _tmp49_;
				_tmp48_ = math_display_get_equation (self);
				_tmp49_ = _tmp48_;
				math_equation_insert (_tmp49_, "⁻¹");
				result = TRUE;
				return result;
			}
			case GDK_KEY_p:
			{
				MathEquation* _tmp50_;
				MathEquation* _tmp51_;
				_tmp50_ = math_display_get_equation (self);
				_tmp51_ = _tmp50_;
				math_equation_insert (_tmp51_, "π");
				result = TRUE;
				return result;
			}
			case GDK_KEY_r:
			{
				MathEquation* _tmp52_;
				MathEquation* _tmp53_;
				_tmp52_ = math_display_get_equation (self);
				_tmp53_ = _tmp52_;
				math_equation_insert (_tmp53_, "√");
				result = TRUE;
				return result;
			}
			case GDK_KEY_u:
			{
				MathEquation* _tmp54_;
				MathEquation* _tmp55_;
				_tmp54_ = math_display_get_equation (self);
				_tmp55_ = _tmp54_;
				math_equation_insert (_tmp55_, "µ");
				result = TRUE;
				return result;
			}
			case GDK_KEY_minus:
			{
				MathEquation* _tmp56_;
				MathEquation* _tmp57_;
				_tmp56_ = math_display_get_equation (self);
				_tmp57_ = _tmp56_;
				math_equation_insert (_tmp57_, "⁻");
				result = TRUE;
				return result;
			}
			case GDK_KEY_apostrophe:
			{
				MathEquation* _tmp58_;
				MathEquation* _tmp59_;
				_tmp58_ = math_display_get_equation (self);
				_tmp59_ = _tmp58_;
				math_equation_insert (_tmp59_, "°");
				result = TRUE;
				return result;
			}
			default:
			break;
		}
	}
	_tmp60_ = state;
	if (_tmp60_ == GDK_MOD1_MASK) {
		guint _tmp61_;
		_tmp61_ = event->keyval;
		switch (_tmp61_) {
			case GDK_KEY_bracketleft:
			{
				MathEquation* _tmp62_;
				MathEquation* _tmp63_;
				_tmp62_ = math_display_get_equation (self);
				_tmp63_ = _tmp62_;
				math_equation_insert (_tmp63_, "⌊");
				result = TRUE;
				return result;
			}
			case GDK_KEY_bracketright:
			{
				MathEquation* _tmp64_;
				MathEquation* _tmp65_;
				_tmp64_ = math_display_get_equation (self);
				_tmp65_ = _tmp64_;
				math_equation_insert (_tmp65_, "⌋");
				result = TRUE;
				return result;
			}
			default:
			break;
		}
	}
	_tmp67_ = state;
	if (_tmp67_ == GDK_CONTROL_MASK) {
		_tmp66_ = TRUE;
	} else {
		MathEquation* _tmp68_;
		MathEquation* _tmp69_;
		NumberMode _tmp70_;
		NumberMode _tmp71_;
		_tmp68_ = math_display_get_equation (self);
		_tmp69_ = _tmp68_;
		_tmp70_ = math_equation_get_number_mode (_tmp69_);
		_tmp71_ = _tmp70_;
		_tmp66_ = _tmp71_ == NUMBER_MODE_SUPERSCRIPT;
	}
	if (_tmp66_) {
		MathEquation* _tmp72_;
		MathEquation* _tmp73_;
		gboolean _tmp74_;
		gboolean _tmp75_;
		guint _tmp78_;
		_tmp72_ = math_display_get_equation (self);
		_tmp73_ = _tmp72_;
		_tmp74_ = gtk_text_buffer_get_has_selection ((GtkTextBuffer*) _tmp73_);
		_tmp75_ = _tmp74_;
		if (!_tmp75_) {
			MathEquation* _tmp76_;
			MathEquation* _tmp77_;
			_tmp76_ = math_display_get_equation (self);
			_tmp77_ = _tmp76_;
			math_equation_remove_trailing_spaces (_tmp77_);
		}
		_tmp78_ = event->keyval;
		switch (_tmp78_) {
			case GDK_KEY_0:
			case GDK_KEY_KP_0:
			{
				MathEquation* _tmp79_;
				MathEquation* _tmp80_;
				_tmp79_ = math_display_get_equation (self);
				_tmp80_ = _tmp79_;
				math_equation_insert (_tmp80_, "⁰");
				result = TRUE;
				return result;
			}
			case GDK_KEY_1:
			case GDK_KEY_KP_1:
			{
				MathEquation* _tmp81_;
				MathEquation* _tmp82_;
				_tmp81_ = math_display_get_equation (self);
				_tmp82_ = _tmp81_;
				math_equation_insert (_tmp82_, "¹");
				result = TRUE;
				return result;
			}
			case GDK_KEY_2:
			case GDK_KEY_KP_2:
			{
				MathEquation* _tmp83_;
				MathEquation* _tmp84_;
				_tmp83_ = math_display_get_equation (self);
				_tmp84_ = _tmp83_;
				math_equation_insert (_tmp84_, "²");
				result = TRUE;
				return result;
			}
			case GDK_KEY_3:
			case GDK_KEY_KP_3:
			{
				MathEquation* _tmp85_;
				MathEquation* _tmp86_;
				_tmp85_ = math_display_get_equation (self);
				_tmp86_ = _tmp85_;
				math_equation_insert (_tmp86_, "³");
				result = TRUE;
				return result;
			}
			case GDK_KEY_4:
			case GDK_KEY_KP_4:
			{
				MathEquation* _tmp87_;
				MathEquation* _tmp88_;
				_tmp87_ = math_display_get_equation (self);
				_tmp88_ = _tmp87_;
				math_equation_insert (_tmp88_, "⁴");
				result = TRUE;
				return result;
			}
			case GDK_KEY_5:
			case GDK_KEY_KP_5:
			{
				MathEquation* _tmp89_;
				MathEquation* _tmp90_;
				_tmp89_ = math_display_get_equation (self);
				_tmp90_ = _tmp89_;
				math_equation_insert (_tmp90_, "⁵");
				result = TRUE;
				return result;
			}
			case GDK_KEY_6:
			case GDK_KEY_KP_6:
			{
				MathEquation* _tmp91_;
				MathEquation* _tmp92_;
				_tmp91_ = math_display_get_equation (self);
				_tmp92_ = _tmp91_;
				math_equation_insert (_tmp92_, "⁶");
				result = TRUE;
				return result;
			}
			case GDK_KEY_7:
			case GDK_KEY_KP_7:
			{
				MathEquation* _tmp93_;
				MathEquation* _tmp94_;
				_tmp93_ = math_display_get_equation (self);
				_tmp94_ = _tmp93_;
				math_equation_insert (_tmp94_, "⁷");
				result = TRUE;
				return result;
			}
			case GDK_KEY_8:
			case GDK_KEY_KP_8:
			{
				MathEquation* _tmp95_;
				MathEquation* _tmp96_;
				_tmp95_ = math_display_get_equation (self);
				_tmp96_ = _tmp95_;
				math_equation_insert (_tmp96_, "⁸");
				result = TRUE;
				return result;
			}
			case GDK_KEY_9:
			case GDK_KEY_KP_9:
			{
				MathEquation* _tmp97_;
				MathEquation* _tmp98_;
				_tmp97_ = math_display_get_equation (self);
				_tmp98_ = _tmp97_;
				math_equation_insert (_tmp98_, "⁹");
				result = TRUE;
				return result;
			}
			default:
			break;
		}
	} else {
		gboolean _tmp99_ = FALSE;
		GdkModifierType _tmp100_;
		_tmp100_ = state;
		if (_tmp100_ == GDK_MOD1_MASK) {
			_tmp99_ = TRUE;
		} else {
			MathEquation* _tmp101_;
			MathEquation* _tmp102_;
			NumberMode _tmp103_;
			NumberMode _tmp104_;
			_tmp101_ = math_display_get_equation (self);
			_tmp102_ = _tmp101_;
			_tmp103_ = math_equation_get_number_mode (_tmp102_);
			_tmp104_ = _tmp103_;
			_tmp99_ = _tmp104_ == NUMBER_MODE_SUBSCRIPT;
		}
		if (_tmp99_) {
			MathEquation* _tmp105_;
			MathEquation* _tmp106_;
			gboolean _tmp107_;
			gboolean _tmp108_;
			guint _tmp111_;
			_tmp105_ = math_display_get_equation (self);
			_tmp106_ = _tmp105_;
			_tmp107_ = gtk_text_buffer_get_has_selection ((GtkTextBuffer*) _tmp106_);
			_tmp108_ = _tmp107_;
			if (!_tmp108_) {
				MathEquation* _tmp109_;
				MathEquation* _tmp110_;
				_tmp109_ = math_display_get_equation (self);
				_tmp110_ = _tmp109_;
				math_equation_remove_trailing_spaces (_tmp110_);
			}
			_tmp111_ = event->keyval;
			switch (_tmp111_) {
				case GDK_KEY_0:
				case GDK_KEY_KP_0:
				{
					MathEquation* _tmp112_;
					MathEquation* _tmp113_;
					_tmp112_ = math_display_get_equation (self);
					_tmp113_ = _tmp112_;
					math_equation_insert (_tmp113_, "₀");
					result = TRUE;
					return result;
				}
				case GDK_KEY_1:
				case GDK_KEY_KP_1:
				{
					MathEquation* _tmp114_;
					MathEquation* _tmp115_;
					_tmp114_ = math_display_get_equation (self);
					_tmp115_ = _tmp114_;
					math_equation_insert (_tmp115_, "₁");
					result = TRUE;
					return result;
				}
				case GDK_KEY_2:
				case GDK_KEY_KP_2:
				{
					MathEquation* _tmp116_;
					MathEquation* _tmp117_;
					_tmp116_ = math_display_get_equation (self);
					_tmp117_ = _tmp116_;
					math_equation_insert (_tmp117_, "₂");
					result = TRUE;
					return result;
				}
				case GDK_KEY_3:
				case GDK_KEY_KP_3:
				{
					MathEquation* _tmp118_;
					MathEquation* _tmp119_;
					_tmp118_ = math_display_get_equation (self);
					_tmp119_ = _tmp118_;
					math_equation_insert (_tmp119_, "₃");
					result = TRUE;
					return result;
				}
				case GDK_KEY_4:
				case GDK_KEY_KP_4:
				{
					MathEquation* _tmp120_;
					MathEquation* _tmp121_;
					_tmp120_ = math_display_get_equation (self);
					_tmp121_ = _tmp120_;
					math_equation_insert (_tmp121_, "₄");
					result = TRUE;
					return result;
				}
				case GDK_KEY_5:
				case GDK_KEY_KP_5:
				{
					MathEquation* _tmp122_;
					MathEquation* _tmp123_;
					_tmp122_ = math_display_get_equation (self);
					_tmp123_ = _tmp122_;
					math_equation_insert (_tmp123_, "₅");
					result = TRUE;
					return result;
				}
				case GDK_KEY_6:
				case GDK_KEY_KP_6:
				{
					MathEquation* _tmp124_;
					MathEquation* _tmp125_;
					_tmp124_ = math_display_get_equation (self);
					_tmp125_ = _tmp124_;
					math_equation_insert (_tmp125_, "₆");
					result = TRUE;
					return result;
				}
				case GDK_KEY_7:
				case GDK_KEY_KP_7:
				{
					MathEquation* _tmp126_;
					MathEquation* _tmp127_;
					_tmp126_ = math_display_get_equation (self);
					_tmp127_ = _tmp126_;
					math_equation_insert (_tmp127_, "₇");
					result = TRUE;
					return result;
				}
				case GDK_KEY_8:
				case GDK_KEY_KP_8:
				{
					MathEquation* _tmp128_;
					MathEquation* _tmp129_;
					_tmp128_ = math_display_get_equation (self);
					_tmp129_ = _tmp128_;
					math_equation_insert (_tmp129_, "₈");
					result = TRUE;
					return result;
				}
				case GDK_KEY_9:
				case GDK_KEY_KP_9:
				{
					MathEquation* _tmp130_;
					MathEquation* _tmp131_;
					_tmp130_ = math_display_get_equation (self);
					_tmp131_ = _tmp130_;
					math_equation_insert (_tmp131_, "₉");
					result = TRUE;
					return result;
				}
				default:
				break;
			}
		}
	}
	result = FALSE;
	return result;
}


static void
math_display_status_changed_cb (MathDisplay* self)
{
	GtkTextBuffer* _tmp0_;
	MathEquation* _tmp1_;
	MathEquation* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gboolean _tmp6_ = FALSE;
	MathEquation* _tmp7_;
	MathEquation* _tmp8_;
	gboolean _tmp9_;
	gboolean _tmp10_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->info_buffer;
	_tmp1_ = math_display_get_equation (self);
	_tmp2_ = _tmp1_;
	_tmp3_ = math_equation_get_status (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = _tmp4_;
	gtk_text_buffer_set_text (_tmp0_, _tmp5_, -1);
	_g_free0 (_tmp5_);
	_tmp7_ = math_display_get_equation (self);
	_tmp8_ = _tmp7_;
	_tmp9_ = math_equation_get_in_solve (_tmp8_);
	_tmp10_ = _tmp9_;
	if (_tmp10_) {
		GtkSpinner* _tmp11_;
		_tmp11_ = self->priv->spinner;
		_tmp6_ = !gtk_widget_get_visible ((GtkWidget*) _tmp11_);
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		GtkSpinner* _tmp12_;
		GtkSpinner* _tmp13_;
		_tmp12_ = self->priv->spinner;
		gtk_widget_show ((GtkWidget*) _tmp12_);
		_tmp13_ = self->priv->spinner;
		gtk_spinner_start (_tmp13_);
	} else {
		gboolean _tmp14_ = FALSE;
		MathEquation* _tmp15_;
		MathEquation* _tmp16_;
		gboolean _tmp17_;
		gboolean _tmp18_;
		_tmp15_ = math_display_get_equation (self);
		_tmp16_ = _tmp15_;
		_tmp17_ = math_equation_get_in_solve (_tmp16_);
		_tmp18_ = _tmp17_;
		if (!_tmp18_) {
			GtkSpinner* _tmp19_;
			_tmp19_ = self->priv->spinner;
			_tmp14_ = gtk_widget_get_visible ((GtkWidget*) _tmp19_);
		} else {
			_tmp14_ = FALSE;
		}
		if (_tmp14_) {
			GtkSpinner* _tmp20_;
			GtkSpinner* _tmp21_;
			_tmp20_ = self->priv->spinner;
			gtk_widget_hide ((GtkWidget*) _tmp20_);
			_tmp21_ = self->priv->spinner;
			gtk_spinner_stop (_tmp21_);
		}
	}
}


static void
math_display_error_status_changed_cb (MathDisplay* self)
{
	MathEquation* _tmp0_;
	MathEquation* _tmp1_;
	guint _tmp2_;
	guint _tmp3_;
	MathEquation* _tmp4_;
	MathEquation* _tmp5_;
	guint _tmp6_;
	guint _tmp7_;
	GtkTextIter start = {0};
	GtkTextIter end = {0};
	MathEquation* _tmp8_;
	MathEquation* _tmp9_;
	GtkTextIter _tmp10_ = {0};
	MathEquation* _tmp11_;
	MathEquation* _tmp12_;
	GtkTextIter _tmp13_ = {0};
	MathEquation* _tmp14_;
	MathEquation* _tmp15_;
	guint _tmp16_;
	guint _tmp17_;
	MathEquation* _tmp18_;
	MathEquation* _tmp19_;
	guint _tmp20_;
	guint _tmp21_;
	MathEquation* _tmp22_;
	MathEquation* _tmp23_;
	GtkTextIter _tmp24_;
	GtkTextIter _tmp25_;
	g_return_if_fail (self != NULL);
	_tmp0_ = math_display_get_equation (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = math_equation_get_error_token_end (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = math_display_get_equation (self);
	_tmp5_ = _tmp4_;
	_tmp6_ = math_equation_get_error_token_start (_tmp5_);
	_tmp7_ = _tmp6_;
	if ((_tmp3_ - _tmp7_) == ((guint) 0)) {
		return;
	}
	_tmp8_ = math_display_get_equation (self);
	_tmp9_ = _tmp8_;
	gtk_text_buffer_get_start_iter ((GtkTextBuffer*) _tmp9_, &_tmp10_);
	start = _tmp10_;
	_tmp11_ = math_display_get_equation (self);
	_tmp12_ = _tmp11_;
	gtk_text_buffer_get_start_iter ((GtkTextBuffer*) _tmp12_, &_tmp13_);
	end = _tmp13_;
	_tmp14_ = math_display_get_equation (self);
	_tmp15_ = _tmp14_;
	_tmp16_ = math_equation_get_error_token_start (_tmp15_);
	_tmp17_ = _tmp16_;
	gtk_text_iter_set_offset (&start, (gint) _tmp17_);
	_tmp18_ = math_display_get_equation (self);
	_tmp19_ = _tmp18_;
	_tmp20_ = math_equation_get_error_token_end (_tmp19_);
	_tmp21_ = _tmp20_;
	gtk_text_iter_set_offset (&end, (gint) _tmp21_);
	_tmp22_ = math_display_get_equation (self);
	_tmp23_ = _tmp22_;
	_tmp24_ = start;
	_tmp25_ = end;
	gtk_text_buffer_select_range ((GtkTextBuffer*) _tmp23_, &_tmp24_, &_tmp25_);
}


void
math_display_grab_focus (MathDisplay* self)
{
	GtkSourceView* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->source_view;
	gtk_widget_grab_focus ((GtkWidget*) _tmp0_);
}


MathEquation*
math_display_get_equation (MathDisplay* self)
{
	MathEquation* result;
	MathEquation* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_equation;
	result = _tmp0_;
	return result;
}


static void
math_display_class_init (MathDisplayClass * klass)
{
	math_display_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (MathDisplayPrivate));
	((GtkWidgetClass *) klass)->key_press_event = (gboolean (*) (GtkWidget *, GdkEventKey*)) math_display_real_key_press_event;
	G_OBJECT_CLASS (klass)->get_property = _vala_math_display_get_property;
	G_OBJECT_CLASS (klass)->finalize = math_display_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), MATH_DISPLAY_EQUATION_PROPERTY, math_display_properties[MATH_DISPLAY_EQUATION_PROPERTY] = g_param_spec_object ("equation", "equation", "equation", TYPE_MATH_EQUATION, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}


static void
math_display_instance_init (MathDisplay * self)
{
	self->priv = MATH_DISPLAY_GET_PRIVATE (self);
}


static void
math_display_finalize (GObject * obj)
{
	MathDisplay * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MATH_DISPLAY, MathDisplay);
	_g_object_unref0 (self->priv->_equation);
	_g_object_unref0 (self->priv->history);
	_g_object_unref0 (self->priv->source_view);
	_g_object_unref0 (self->priv->info_buffer);
	_g_object_unref0 (self->priv->spinner);
	G_OBJECT_CLASS (math_display_parent_class)->finalize (obj);
}


GType
math_display_get_type (void)
{
	static volatile gsize math_display_type_id__volatile = 0;
	if (g_once_init_enter (&math_display_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (MathDisplayClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) math_display_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MathDisplay), 0, (GInstanceInitFunc) math_display_instance_init, NULL };
		GType math_display_type_id;
		math_display_type_id = g_type_register_static (gtk_viewport_get_type (), "MathDisplay", &g_define_type_info, 0);
		g_once_init_leave (&math_display_type_id__volatile, math_display_type_id);
	}
	return math_display_type_id__volatile;
}


static void
_vala_math_display_get_property (GObject * object,
                                 guint property_id,
                                 GValue * value,
                                 GParamSpec * pspec)
{
	MathDisplay * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_MATH_DISPLAY, MathDisplay);
	switch (property_id) {
		case MATH_DISPLAY_EQUATION_PROPERTY:
		g_value_set_object (value, math_display_get_equation (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static gchar*
completion_provider_real_get_name (CompletionProvider* self)
{
	gchar* result = NULL;
	gchar* _tmp0_;
	_tmp0_ = g_strdup ("");
	result = _tmp0_;
	return result;
}


gchar*
completion_provider_get_name (CompletionProvider* self)
{
	g_return_val_if_fail (self != NULL, NULL);
	return COMPLETION_PROVIDER_GET_CLASS (self)->get_name (self);
}


static GtkSourceCompletionItem*
completion_provider_real_create_proposal (CompletionProvider* self,
                                          const gchar* label,
                                          const gchar* text,
                                          const gchar* details)
{
	GtkSourceCompletionItem* result = NULL;
	GtkSourceCompletionItem* proposal = NULL;
	GtkSourceCompletionItem* _tmp0_;
	g_return_val_if_fail (label != NULL, NULL);
	g_return_val_if_fail (text != NULL, NULL);
	g_return_val_if_fail (details != NULL, NULL);
	_tmp0_ = gtk_source_completion_item_new2 ();
	proposal = _tmp0_;
	g_object_set (proposal, "label", label, NULL);
	g_object_set (proposal, "text", text, NULL);
	g_object_set (proposal, "info", details, NULL);
	result = proposal;
	return result;
}


GtkSourceCompletionItem*
completion_provider_create_proposal (CompletionProvider* self,
                                     const gchar* label,
                                     const gchar* text,
                                     const gchar* details)
{
	g_return_val_if_fail (self != NULL, NULL);
	return COMPLETION_PROVIDER_GET_CLASS (self)->create_proposal (self, label, text, details);
}


void
completion_provider_move_iter_to_name_start (GtkTextIter* iter)
{
	g_return_if_fail (iter != NULL);
	while (TRUE) {
		gunichar current_char = 0U;
		gunichar _tmp0_;
		if (!gtk_text_iter_backward_char (iter)) {
			break;
		}
		current_char = gtk_text_iter_get_char (iter);
		_tmp0_ = current_char;
		if (!g_unichar_isalpha (_tmp0_)) {
			gtk_text_iter_forward_char (iter);
			break;
		}
	}
}


static gboolean
completion_provider_real_get_start_iter (CompletionProvider* self,
                                         GtkSourceCompletionContext* context,
                                         GtkSourceCompletionProposal* proposal,
                                         GtkTextIter* iter)
{
	GtkTextIter _vala_iter = {0};
	gboolean result = FALSE;
	GtkTextIter _tmp0_ = {0};
	g_return_val_if_fail (context != NULL, FALSE);
	g_return_val_if_fail (proposal != NULL, FALSE);
	_vala_iter = _tmp0_;
	result = FALSE;
	if (iter) {
		*iter = _vala_iter;
	}
	return result;
}


gboolean
completion_provider_get_start_iter (CompletionProvider* self,
                                    GtkSourceCompletionContext* context,
                                    GtkSourceCompletionProposal* proposal,
                                    GtkTextIter* iter)
{
	g_return_val_if_fail (self != NULL, FALSE);
	return COMPLETION_PROVIDER_GET_CLASS (self)->get_start_iter (self, context, proposal, iter);
}


static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gboolean result = FALSE;
	gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}


static gboolean
completion_provider_real_activate_proposal (CompletionProvider* self,
                                            GtkSourceCompletionProposal* proposal,
                                            GtkTextIter* iter)
{
	gboolean result = FALSE;
	gchar* proposed_string = NULL;
	gchar* _tmp0_;
	GtkTextBuffer* buffer = NULL;
	GtkTextBuffer* _tmp1_;
	GtkTextBuffer* _tmp2_;
	GtkTextIter start_iter = {0};
	GtkTextIter end = {0};
	GtkTextBuffer* _tmp3_;
	GtkTextIter _tmp4_ = {0};
	GtkTextBuffer* _tmp5_;
	GtkTextIter _tmp6_;
	GtkTextBuffer* _tmp7_;
	GtkTextIter _tmp8_;
	GtkTextIter _tmp9_;
	GtkTextBuffer* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	gint _tmp13_;
	gint _tmp14_;
	const gchar* _tmp15_;
	g_return_val_if_fail (proposal != NULL, FALSE);
	g_return_val_if_fail (iter != NULL, FALSE);
	_tmp0_ = gtk_source_completion_proposal_get_text (proposal);
	proposed_string = _tmp0_;
	_tmp1_ = gtk_text_iter_get_buffer (iter);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	buffer = _tmp2_;
	_tmp3_ = buffer;
	gtk_text_buffer_get_iter_at_offset (_tmp3_, &_tmp4_, gtk_text_iter_get_offset (iter));
	start_iter = _tmp4_;
	completion_provider_move_iter_to_name_start (&start_iter);
	_tmp5_ = buffer;
	_tmp6_ = start_iter;
	gtk_text_buffer_place_cursor (_tmp5_, &_tmp6_);
	_tmp7_ = buffer;
	_tmp8_ = start_iter;
	_tmp9_ = *iter;
	g_signal_emit_by_name (_tmp7_, "delete-range", &_tmp8_, &_tmp9_);
	_tmp10_ = buffer;
	_tmp11_ = proposed_string;
	_tmp12_ = proposed_string;
	_tmp13_ = strlen (_tmp12_);
	_tmp14_ = _tmp13_;
	gtk_text_buffer_insert_at_cursor (_tmp10_, _tmp11_, _tmp14_);
	_tmp15_ = proposed_string;
	if (string_contains (_tmp15_, "()")) {
		GtkTextBuffer* _tmp16_;
		GtkTextBuffer* _tmp17_;
		GtkTextMark* _tmp18_;
		GtkTextIter _tmp19_ = {0};
		GtkTextBuffer* _tmp20_;
		GtkTextIter _tmp21_;
		_tmp16_ = buffer;
		_tmp17_ = buffer;
		_tmp18_ = gtk_text_buffer_get_insert (_tmp17_);
		gtk_text_buffer_get_iter_at_mark (_tmp16_, &_tmp19_, _tmp18_);
		end = _tmp19_;
		gtk_text_iter_backward_chars (&end, 1);
		_tmp20_ = buffer;
		_tmp21_ = end;
		gtk_text_buffer_place_cursor (_tmp20_, &_tmp21_);
	}
	result = TRUE;
	_g_object_unref0 (buffer);
	_g_free0 (proposed_string);
	return result;
}


gboolean
completion_provider_activate_proposal (CompletionProvider* self,
                                       GtkSourceCompletionProposal* proposal,
                                       GtkTextIter* iter)
{
	g_return_val_if_fail (self != NULL, FALSE);
	return COMPLETION_PROVIDER_GET_CLASS (self)->activate_proposal (self, proposal, iter);
}


static void
completion_provider_real_populate (CompletionProvider* self,
                                   GtkSourceCompletionContext* context)
{
	g_return_if_fail (context != NULL);
}


void
completion_provider_populate (CompletionProvider* self,
                              GtkSourceCompletionContext* context)
{
	g_return_if_fail (self != NULL);
	COMPLETION_PROVIDER_GET_CLASS (self)->populate (self, context);
}


CompletionProvider*
completion_provider_construct (GType object_type)
{
	CompletionProvider * self = NULL;
	self = (CompletionProvider*) g_object_new (object_type, NULL);
	return self;
}


CompletionProvider*
completion_provider_new (void)
{
	return completion_provider_construct (TYPE_COMPLETION_PROVIDER);
}


static void
completion_provider_class_init (CompletionProviderClass * klass)
{
	completion_provider_parent_class = g_type_class_peek_parent (klass);
	((CompletionProviderClass *) klass)->get_name = (gchar* (*) (CompletionProvider *)) completion_provider_real_get_name;
	((CompletionProviderClass *) klass)->create_proposal = (GtkSourceCompletionItem* (*) (CompletionProvider *, const gchar*, const gchar*, const gchar*)) completion_provider_real_create_proposal;
	((CompletionProviderClass *) klass)->get_start_iter = (gboolean (*) (CompletionProvider *, GtkSourceCompletionContext*, GtkSourceCompletionProposal*, GtkTextIter*)) completion_provider_real_get_start_iter;
	((CompletionProviderClass *) klass)->activate_proposal = (gboolean (*) (CompletionProvider *, GtkSourceCompletionProposal*, GtkTextIter*)) completion_provider_real_activate_proposal;
	((CompletionProviderClass *) klass)->populate = (void (*) (CompletionProvider *, GtkSourceCompletionContext*)) completion_provider_real_populate;
}


static void
completion_provider_gtk_source_completion_provider_interface_init (GtkSourceCompletionProviderIface * iface)
{
	completion_provider_gtk_source_completion_provider_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_name = (gchar* (*) (GtkSourceCompletionProvider *)) completion_provider_get_name;
	iface->get_start_iter = (gboolean (*) (GtkSourceCompletionProvider *, GtkSourceCompletionContext*, GtkSourceCompletionProposal*, GtkTextIter*)) completion_provider_get_start_iter;
	iface->activate_proposal = (gboolean (*) (GtkSourceCompletionProvider *, GtkSourceCompletionProposal*, GtkTextIter*)) completion_provider_activate_proposal;
	iface->populate = (void (*) (GtkSourceCompletionProvider *, GtkSourceCompletionContext*)) completion_provider_populate;
}


static void
completion_provider_instance_init (CompletionProvider * self)
{
}


GType
completion_provider_get_type (void)
{
	static volatile gsize completion_provider_type_id__volatile = 0;
	if (g_once_init_enter (&completion_provider_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (CompletionProviderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) completion_provider_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CompletionProvider), 0, (GInstanceInitFunc) completion_provider_instance_init, NULL };
		static const GInterfaceInfo gtk_source_completion_provider_info = { (GInterfaceInitFunc) completion_provider_gtk_source_completion_provider_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType completion_provider_type_id;
		completion_provider_type_id = g_type_register_static (G_TYPE_OBJECT, "CompletionProvider", &g_define_type_info, 0);
		g_type_add_interface_static (completion_provider_type_id, gtk_source_completion_provider_get_type (), &gtk_source_completion_provider_info);
		g_once_init_leave (&completion_provider_type_id__volatile, completion_provider_type_id);
	}
	return completion_provider_type_id__volatile;
}


static gchar*
function_completion_provider_real_get_name (CompletionProvider* base)
{
	FunctionCompletionProvider * self;
	gchar* result = NULL;
	gchar* _tmp0_;
	self = (FunctionCompletionProvider*) base;
	_tmp0_ = g_strdup ("Defined Functions");
	result = _tmp0_;
	return result;
}


MathFunction**
function_completion_provider_get_matches_for_completion_at_cursor (GtkTextBuffer* text_buffer,
                                                                   int* result_length1)
{
	MathFunction** result = NULL;
	GtkTextIter start_iter = {0};
	GtkTextIter end_iter = {0};
	GtkTextMark* _tmp0_;
	GtkTextIter _tmp1_ = {0};
	GtkTextMark* _tmp2_;
	GtkTextIter _tmp3_ = {0};
	gchar* search_pattern = NULL;
	GtkTextIter _tmp4_;
	GtkTextIter _tmp5_;
	gchar* _tmp6_;
	FunctionManager* function_manager = NULL;
	FunctionManager* _tmp7_;
	MathFunction** functions = NULL;
	gint _tmp8_;
	MathFunction** _tmp9_;
	gint functions_length1;
	gint _functions_size_;
	MathFunction** _tmp10_;
	gint _tmp10__length1;
	g_return_val_if_fail (text_buffer != NULL, NULL);
	_tmp0_ = gtk_text_buffer_get_insert (text_buffer);
	gtk_text_buffer_get_iter_at_mark (text_buffer, &_tmp1_, _tmp0_);
	end_iter = _tmp1_;
	_tmp2_ = gtk_text_buffer_get_insert (text_buffer);
	gtk_text_buffer_get_iter_at_mark (text_buffer, &_tmp3_, _tmp2_);
	start_iter = _tmp3_;
	completion_provider_move_iter_to_name_start (&start_iter);
	_tmp4_ = start_iter;
	_tmp5_ = end_iter;
	_tmp6_ = gtk_text_buffer_get_slice (text_buffer, &_tmp4_, &_tmp5_, FALSE);
	search_pattern = _tmp6_;
	_tmp7_ = function_manager_get_default_function_manager ();
	function_manager = _tmp7_;
	_tmp9_ = function_manager_functions_eligible_for_autocompletion_for_text (function_manager, search_pattern, &_tmp8_);
	functions = _tmp9_;
	functions_length1 = _tmp8_;
	_functions_size_ = functions_length1;
	_tmp10_ = functions;
	_tmp10__length1 = functions_length1;
	if (result_length1) {
		*result_length1 = _tmp10__length1;
	}
	result = _tmp10_;
	_g_object_unref0 (function_manager);
	_g_free0 (search_pattern);
	return result;
}


static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}


static gchar*
_vala_g_strjoinv (const gchar* separator,
                  gchar** str_array,
                  int str_array_length1)
{
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	if (separator == NULL) {
		separator = "";
	}
	if (str_array != NULL) {
		gboolean _tmp1_ = FALSE;
		if (str_array_length1 > 0) {
			_tmp1_ = TRUE;
		} else {
			gboolean _tmp2_ = FALSE;
			if (str_array_length1 == -1) {
				const gchar* _tmp3_;
				_tmp3_ = str_array[0];
				_tmp2_ = _tmp3_ != NULL;
			} else {
				_tmp2_ = FALSE;
			}
			_tmp1_ = _tmp2_;
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint i = 0;
		gsize len = 0UL;
		gint _tmp20_;
		gint _tmp22_;
		gint _tmp23_;
		gsize _tmp24_;
		gint _tmp25_;
		gint _tmp26_;
		gint _tmp27_;
		const gchar* res = NULL;
		gsize _tmp28_;
		void* _tmp29_;
		void* ptr = NULL;
		const gchar* _tmp30_;
		const gchar* _tmp31_;
		void* _tmp32_;
		const gchar* _tmp45_;
		len = (gsize) 1;
		{
			gboolean _tmp4_ = FALSE;
			i = 0;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gint _tmp12_ = 0;
				gint _tmp13_;
				const gchar* _tmp14_;
				gsize _tmp19_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				if (str_array_length1 != -1) {
					gint _tmp8_;
					_tmp8_ = i;
					_tmp7_ = _tmp8_ < str_array_length1;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					_tmp6_ = TRUE;
				} else {
					gboolean _tmp9_ = FALSE;
					if (str_array_length1 == -1) {
						gint _tmp10_;
						const gchar* _tmp11_;
						_tmp10_ = i;
						_tmp11_ = str_array[_tmp10_];
						_tmp9_ = _tmp11_ != NULL;
					} else {
						_tmp9_ = FALSE;
					}
					_tmp6_ = _tmp9_;
				}
				if (!_tmp6_) {
					break;
				}
				_tmp13_ = i;
				_tmp14_ = str_array[_tmp13_];
				if (_tmp14_ != NULL) {
					gint _tmp15_;
					const gchar* _tmp16_;
					gint _tmp17_;
					gint _tmp18_;
					_tmp15_ = i;
					_tmp16_ = str_array[_tmp15_];
					_tmp17_ = strlen ((const gchar*) _tmp16_);
					_tmp18_ = _tmp17_;
					_tmp12_ = _tmp18_;
				} else {
					_tmp12_ = 0;
				}
				_tmp19_ = len;
				len = _tmp19_ + _tmp12_;
			}
		}
		_tmp20_ = i;
		if (_tmp20_ == 0) {
			gchar* _tmp21_;
			_tmp21_ = g_strdup ("");
			result = _tmp21_;
			return result;
		}
		_tmp22_ = i;
		str_array_length1 = _tmp22_;
		_tmp23_ = str_array_length1;
		_tmp24_ = len;
		_tmp25_ = strlen ((const gchar*) separator);
		_tmp26_ = _tmp25_;
		_tmp27_ = i;
		len = _tmp24_ + (_tmp26_ * (_tmp27_ - 1));
		_tmp28_ = len;
		_tmp29_ = g_malloc (_tmp28_);
		res = _tmp29_;
		_tmp30_ = res;
		_tmp31_ = str_array[0];
		_tmp32_ = g_stpcpy ((void*) _tmp30_, (const gchar*) _tmp31_);
		ptr = _tmp32_;
		{
			gboolean _tmp33_ = FALSE;
			i = 1;
			_tmp33_ = TRUE;
			while (TRUE) {
				gint _tmp35_;
				void* _tmp36_;
				void* _tmp37_;
				const gchar* _tmp38_ = NULL;
				gint _tmp39_;
				const gchar* _tmp40_;
				void* _tmp43_;
				void* _tmp44_;
				if (!_tmp33_) {
					gint _tmp34_;
					_tmp34_ = i;
					i = _tmp34_ + 1;
				}
				_tmp33_ = FALSE;
				_tmp35_ = i;
				if (!(_tmp35_ < str_array_length1)) {
					break;
				}
				_tmp36_ = ptr;
				_tmp37_ = g_stpcpy (_tmp36_, (const gchar*) separator);
				ptr = _tmp37_;
				_tmp39_ = i;
				_tmp40_ = str_array[_tmp39_];
				if (_tmp40_ != NULL) {
					gint _tmp41_;
					const gchar* _tmp42_;
					_tmp41_ = i;
					_tmp42_ = str_array[_tmp41_];
					_tmp38_ = (const gchar*) _tmp42_;
				} else {
					_tmp38_ = "";
				}
				_tmp43_ = ptr;
				_tmp44_ = g_stpcpy (_tmp43_, _tmp38_);
				ptr = _tmp44_;
			}
		}
		_tmp45_ = res;
		res = NULL;
		result = (gchar*) _tmp45_;
		return result;
	} else {
		gchar* _tmp46_;
		_tmp46_ = g_strdup ("");
		result = _tmp46_;
		return result;
	}
}


static void
function_completion_provider_real_populate (CompletionProvider* base,
                                            GtkSourceCompletionContext* context)
{
	FunctionCompletionProvider * self;
	GtkTextIter iter1 = {0};
	GtkTextIter _tmp0_ = {0};
	gboolean _tmp1_;
	GtkTextBuffer* text_buffer = NULL;
	GtkTextBuffer* _tmp2_;
	GtkTextBuffer* _tmp3_;
	MathFunction** functions = NULL;
	GtkTextBuffer* _tmp4_;
	gint _tmp5_;
	MathFunction** _tmp6_;
	gint functions_length1;
	gint _functions_size_;
	GList* proposals = NULL;
	MathFunction** _tmp7_;
	gint _tmp7__length1;
	GList* _tmp48_;
	self = (FunctionCompletionProvider*) base;
	g_return_if_fail (context != NULL);
	_tmp1_ = gtk_source_completion_context_get_iter (context, &_tmp0_);
	iter1 = _tmp0_;
	if (!_tmp1_) {
		return;
	}
	_tmp2_ = gtk_text_iter_get_buffer (&iter1);
	_tmp3_ = _g_object_ref0 (_tmp2_);
	text_buffer = _tmp3_;
	_tmp4_ = text_buffer;
	_tmp6_ = function_completion_provider_get_matches_for_completion_at_cursor (_tmp4_, &_tmp5_);
	functions = _tmp6_;
	functions_length1 = _tmp5_;
	_functions_size_ = functions_length1;
	proposals = NULL;
	_tmp7_ = functions;
	_tmp7__length1 = functions_length1;
	if (_tmp7__length1 > 0) {
		MathFunction** _tmp8_;
		gint _tmp8__length1;
		__g_list_free__g_object_unref0_0 (proposals);
		proposals = NULL;
		_tmp8_ = functions;
		_tmp8__length1 = functions_length1;
		{
			MathFunction** function_collection = NULL;
			gint function_collection_length1 = 0;
			gint _function_collection_size_ = 0;
			gint function_it = 0;
			function_collection = _tmp8_;
			function_collection_length1 = _tmp8__length1;
			for (function_it = 0; function_it < _tmp8__length1; function_it = function_it + 1) {
				MathFunction* _tmp9_;
				MathFunction* function = NULL;
				_tmp9_ = _g_object_ref0 (function_collection[function_it]);
				function = _tmp9_;
				{
					gchar* display_text = NULL;
					MathFunction* _tmp10_;
					const gchar* _tmp11_;
					const gchar* _tmp12_;
					MathFunction* _tmp13_;
					gchar** _tmp14_;
					gint _tmp14__length1;
					gchar** _tmp15_;
					gint _tmp15__length1;
					gchar* _tmp16_;
					gchar* _tmp17_;
					gchar* _tmp18_;
					gchar* _tmp19_;
					gchar* details_text = NULL;
					MathFunction* _tmp20_;
					const gchar* _tmp21_;
					const gchar* _tmp22_;
					gchar* _tmp23_;
					gchar* label_text = NULL;
					MathFunction* _tmp24_;
					const gchar* _tmp25_;
					const gchar* _tmp26_;
					gchar* _tmp27_;
					MathFunction* _tmp28_;
					const gchar* _tmp44_;
					const gchar* _tmp45_;
					const gchar* _tmp46_;
					GtkSourceCompletionItem* _tmp47_;
					_tmp10_ = function;
					_tmp11_ = math_function_get_name (_tmp10_);
					_tmp12_ = _tmp11_;
					_tmp13_ = function;
					_tmp14_ = math_function_get_arguments (_tmp13_, &_tmp14__length1);
					_tmp15_ = _tmp14_;
					_tmp15__length1 = _tmp14__length1;
					_tmp16_ = _vala_g_strjoinv (";", _tmp15_, _tmp15__length1);
					_tmp17_ = _tmp16_;
					_tmp18_ = g_strdup_printf ("%s(%s)", _tmp12_, _tmp17_);
					_tmp19_ = _tmp18_;
					_g_free0 (_tmp17_);
					display_text = _tmp19_;
					_tmp20_ = function;
					_tmp21_ = math_function_get_description (_tmp20_);
					_tmp22_ = _tmp21_;
					_tmp23_ = g_strdup_printf ("%s", _tmp22_);
					details_text = _tmp23_;
					_tmp24_ = function;
					_tmp25_ = math_function_get_name (_tmp24_);
					_tmp26_ = _tmp25_;
					_tmp27_ = g_strconcat (_tmp26_, "()", NULL);
					label_text = _tmp27_;
					_tmp28_ = function;
					if (math_function_is_custom_function (_tmp28_)) {
						MathFunction* _tmp29_;
						const gchar* _tmp30_;
						const gchar* _tmp31_;
						MathFunction* _tmp32_;
						gchar** _tmp33_;
						gint _tmp33__length1;
						gchar** _tmp34_;
						gint _tmp34__length1;
						gchar* _tmp35_;
						gchar* _tmp36_;
						MathFunction* _tmp37_;
						const gchar* _tmp38_;
						const gchar* _tmp39_;
						MathFunction* _tmp40_;
						const gchar* _tmp41_;
						const gchar* _tmp42_;
						gchar* _tmp43_;
						_tmp29_ = function;
						_tmp30_ = math_function_get_name (_tmp29_);
						_tmp31_ = _tmp30_;
						_tmp32_ = function;
						_tmp33_ = math_function_get_arguments (_tmp32_, &_tmp33__length1);
						_tmp34_ = _tmp33_;
						_tmp34__length1 = _tmp33__length1;
						_tmp35_ = _vala_g_strjoinv (";", _tmp34_, _tmp34__length1);
						_tmp36_ = _tmp35_;
						_tmp37_ = function;
						_tmp38_ = math_function_get_expression (_tmp37_);
						_tmp39_ = _tmp38_;
						_tmp40_ = function;
						_tmp41_ = math_function_get_description (_tmp40_);
						_tmp42_ = _tmp41_;
						_tmp43_ = g_strdup_printf ("%s(%s)=%s\n%s", _tmp31_, _tmp36_, _tmp39_, _tmp42_);
						_g_free0 (details_text);
						details_text = _tmp43_;
						_g_free0 (_tmp36_);
					}
					_tmp44_ = display_text;
					_tmp45_ = label_text;
					_tmp46_ = details_text;
					_tmp47_ = completion_provider_create_proposal ((CompletionProvider*) self, _tmp44_, _tmp45_, _tmp46_);
					proposals = g_list_append (proposals, _tmp47_);
					_g_free0 (label_text);
					_g_free0 (details_text);
					_g_free0 (display_text);
					_g_object_unref0 (function);
				}
			}
		}
	}
	_tmp48_ = proposals;
	gtk_source_completion_context_add_proposals (context, (GtkSourceCompletionProvider*) self, _tmp48_, TRUE);
	__g_list_free__g_object_unref0_0 (proposals);
	functions = (_vala_array_free (functions, functions_length1, (GDestroyNotify) g_object_unref), NULL);
	_g_object_unref0 (text_buffer);
}


FunctionCompletionProvider*
function_completion_provider_construct (GType object_type)
{
	FunctionCompletionProvider * self = NULL;
	self = (FunctionCompletionProvider*) completion_provider_construct (object_type);
	return self;
}


FunctionCompletionProvider*
function_completion_provider_new (void)
{
	return function_completion_provider_construct (TYPE_FUNCTION_COMPLETION_PROVIDER);
}


static void
function_completion_provider_class_init (FunctionCompletionProviderClass * klass)
{
	function_completion_provider_parent_class = g_type_class_peek_parent (klass);
	((CompletionProviderClass *) klass)->get_name = (gchar* (*) (CompletionProvider *)) function_completion_provider_real_get_name;
	((CompletionProviderClass *) klass)->populate = (void (*) (CompletionProvider *, GtkSourceCompletionContext*)) function_completion_provider_real_populate;
}


static void
function_completion_provider_instance_init (FunctionCompletionProvider * self)
{
}


GType
function_completion_provider_get_type (void)
{
	static volatile gsize function_completion_provider_type_id__volatile = 0;
	if (g_once_init_enter (&function_completion_provider_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FunctionCompletionProviderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) function_completion_provider_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FunctionCompletionProvider), 0, (GInstanceInitFunc) function_completion_provider_instance_init, NULL };
		GType function_completion_provider_type_id;
		function_completion_provider_type_id = g_type_register_static (TYPE_COMPLETION_PROVIDER, "FunctionCompletionProvider", &g_define_type_info, 0);
		g_once_init_leave (&function_completion_provider_type_id__volatile, function_completion_provider_type_id);
	}
	return function_completion_provider_type_id__volatile;
}


VariableCompletionProvider*
variable_completion_provider_construct (GType object_type,
                                        MathEquation* equation)
{
	VariableCompletionProvider * self = NULL;
	MathEquation* _tmp0_;
	g_return_val_if_fail (equation != NULL, NULL);
	self = (VariableCompletionProvider*) completion_provider_construct (object_type);
	_tmp0_ = _g_object_ref0 (equation);
	_g_object_unref0 (self->priv->_equation);
	self->priv->_equation = _tmp0_;
	return self;
}


VariableCompletionProvider*
variable_completion_provider_new (MathEquation* equation)
{
	return variable_completion_provider_construct (TYPE_VARIABLE_COMPLETION_PROVIDER, equation);
}


static gchar*
variable_completion_provider_real_get_name (CompletionProvider* base)
{
	VariableCompletionProvider * self;
	gchar* result = NULL;
	gchar* _tmp0_;
	self = (VariableCompletionProvider*) base;
	_tmp0_ = g_strdup ("Defined Variables");
	result = _tmp0_;
	return result;
}


gchar**
variable_completion_provider_get_matches_for_completion_at_cursor (GtkTextBuffer* text_buffer,
                                                                   MathVariables* variables,
                                                                   int* result_length1)
{
	gchar** result = NULL;
	GtkTextIter start_iter = {0};
	GtkTextIter end_iter = {0};
	GtkTextMark* _tmp0_;
	GtkTextIter _tmp1_ = {0};
	GtkTextMark* _tmp2_;
	GtkTextIter _tmp3_ = {0};
	gchar* search_pattern = NULL;
	GtkTextIter _tmp4_;
	GtkTextIter _tmp5_;
	gchar* _tmp6_;
	gchar** math_variables = NULL;
	gint _tmp7_;
	gchar** _tmp8_;
	gint math_variables_length1;
	gint _math_variables_size_;
	gchar** _tmp9_;
	gint _tmp9__length1;
	g_return_val_if_fail (text_buffer != NULL, NULL);
	g_return_val_if_fail (variables != NULL, NULL);
	_tmp0_ = gtk_text_buffer_get_insert (text_buffer);
	gtk_text_buffer_get_iter_at_mark (text_buffer, &_tmp1_, _tmp0_);
	end_iter = _tmp1_;
	_tmp2_ = gtk_text_buffer_get_insert (text_buffer);
	gtk_text_buffer_get_iter_at_mark (text_buffer, &_tmp3_, _tmp2_);
	start_iter = _tmp3_;
	completion_provider_move_iter_to_name_start (&start_iter);
	_tmp4_ = start_iter;
	_tmp5_ = end_iter;
	_tmp6_ = gtk_text_buffer_get_slice (text_buffer, &_tmp4_, &_tmp5_, FALSE);
	search_pattern = _tmp6_;
	_tmp8_ = math_variables_variables_eligible_for_autocompletion (variables, search_pattern, &_tmp7_);
	math_variables = _tmp8_;
	math_variables_length1 = _tmp7_;
	_math_variables_size_ = math_variables_length1;
	_tmp9_ = math_variables;
	_tmp9__length1 = math_variables_length1;
	if (result_length1) {
		*result_length1 = _tmp9__length1;
	}
	result = _tmp9_;
	_g_free0 (search_pattern);
	return result;
}


static void
variable_completion_provider_real_populate (CompletionProvider* base,
                                            GtkSourceCompletionContext* context)
{
	VariableCompletionProvider * self;
	GtkTextIter iter1 = {0};
	GtkTextIter _tmp0_ = {0};
	gboolean _tmp1_;
	GtkTextBuffer* text_buffer = NULL;
	GtkTextBuffer* _tmp2_;
	GtkTextBuffer* _tmp3_;
	gchar** variables = NULL;
	GtkTextBuffer* _tmp4_;
	MathEquation* _tmp5_;
	MathVariables* _tmp6_;
	MathVariables* _tmp7_;
	gint _tmp8_;
	gchar** _tmp9_;
	gint variables_length1;
	gint _variables_size_;
	GList* proposals = NULL;
	gchar** _tmp10_;
	gint _tmp10__length1;
	GList* _tmp32_;
	self = (VariableCompletionProvider*) base;
	g_return_if_fail (context != NULL);
	_tmp1_ = gtk_source_completion_context_get_iter (context, &_tmp0_);
	iter1 = _tmp0_;
	if (!_tmp1_) {
		return;
	}
	_tmp2_ = gtk_text_iter_get_buffer (&iter1);
	_tmp3_ = _g_object_ref0 (_tmp2_);
	text_buffer = _tmp3_;
	_tmp4_ = text_buffer;
	_tmp5_ = self->priv->_equation;
	_tmp6_ = math_equation_get_variables (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp9_ = variable_completion_provider_get_matches_for_completion_at_cursor (_tmp4_, _tmp7_, &_tmp8_);
	variables = _tmp9_;
	variables_length1 = _tmp8_;
	_variables_size_ = variables_length1;
	proposals = NULL;
	_tmp10_ = variables;
	_tmp10__length1 = variables_length1;
	if (_tmp10__length1 > 0) {
		gchar** _tmp11_;
		gint _tmp11__length1;
		__g_list_free__g_object_unref0_0 (proposals);
		proposals = NULL;
		_tmp11_ = variables;
		_tmp11__length1 = variables_length1;
		{
			gchar** variable_collection = NULL;
			gint variable_collection_length1 = 0;
			gint _variable_collection_size_ = 0;
			gint variable_it = 0;
			variable_collection = _tmp11_;
			variable_collection_length1 = _tmp11__length1;
			for (variable_it = 0; variable_it < _tmp11__length1; variable_it = variable_it + 1) {
				gchar* _tmp12_;
				gchar* variable = NULL;
				_tmp12_ = g_strdup (variable_collection[variable_it]);
				variable = _tmp12_;
				{
					gchar* display_text = NULL;
					const gchar* _tmp13_;
					gchar* _tmp14_;
					gchar* details_text = NULL;
					MathEquation* _tmp15_;
					Serializer* _tmp16_;
					Serializer* _tmp17_;
					MathEquation* _tmp18_;
					MathVariables* _tmp19_;
					MathVariables* _tmp20_;
					const gchar* _tmp21_;
					Number* _tmp22_;
					Number* _tmp23_;
					gchar* _tmp24_;
					gchar* _tmp25_;
					gchar* label_text = NULL;
					const gchar* _tmp26_;
					gchar* _tmp27_;
					const gchar* _tmp28_;
					const gchar* _tmp29_;
					const gchar* _tmp30_;
					GtkSourceCompletionItem* _tmp31_;
					_tmp13_ = variable;
					_tmp14_ = g_strdup_printf ("%s", _tmp13_);
					display_text = _tmp14_;
					_tmp15_ = self->priv->_equation;
					_tmp16_ = math_equation_get_serializer (_tmp15_);
					_tmp17_ = _tmp16_;
					_tmp18_ = self->priv->_equation;
					_tmp19_ = math_equation_get_variables (_tmp18_);
					_tmp20_ = _tmp19_;
					_tmp21_ = variable;
					_tmp22_ = math_variables_get (_tmp20_, _tmp21_);
					_tmp23_ = _tmp22_;
					_tmp24_ = serializer_to_string (_tmp17_, _tmp23_);
					_tmp25_ = _tmp24_;
					_g_object_unref0 (_tmp23_);
					details_text = _tmp25_;
					_tmp26_ = variable;
					_tmp27_ = g_strdup (_tmp26_);
					label_text = _tmp27_;
					_tmp28_ = display_text;
					_tmp29_ = label_text;
					_tmp30_ = details_text;
					_tmp31_ = completion_provider_create_proposal ((CompletionProvider*) self, _tmp28_, _tmp29_, _tmp30_);
					proposals = g_list_append (proposals, _tmp31_);
					_g_free0 (label_text);
					_g_free0 (details_text);
					_g_free0 (display_text);
					_g_free0 (variable);
				}
			}
		}
	}
	_tmp32_ = proposals;
	gtk_source_completion_context_add_proposals (context, (GtkSourceCompletionProvider*) self, _tmp32_, TRUE);
	__g_list_free__g_object_unref0_0 (proposals);
	variables = (_vala_array_free (variables, variables_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (text_buffer);
}


static void
variable_completion_provider_class_init (VariableCompletionProviderClass * klass)
{
	variable_completion_provider_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (VariableCompletionProviderPrivate));
	((CompletionProviderClass *) klass)->get_name = (gchar* (*) (CompletionProvider *)) variable_completion_provider_real_get_name;
	((CompletionProviderClass *) klass)->populate = (void (*) (CompletionProvider *, GtkSourceCompletionContext*)) variable_completion_provider_real_populate;
	G_OBJECT_CLASS (klass)->finalize = variable_completion_provider_finalize;
}


static void
variable_completion_provider_instance_init (VariableCompletionProvider * self)
{
	self->priv = VARIABLE_COMPLETION_PROVIDER_GET_PRIVATE (self);
}


static void
variable_completion_provider_finalize (GObject * obj)
{
	VariableCompletionProvider * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_VARIABLE_COMPLETION_PROVIDER, VariableCompletionProvider);
	_g_object_unref0 (self->priv->_equation);
	G_OBJECT_CLASS (variable_completion_provider_parent_class)->finalize (obj);
}


GType
variable_completion_provider_get_type (void)
{
	static volatile gsize variable_completion_provider_type_id__volatile = 0;
	if (g_once_init_enter (&variable_completion_provider_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (VariableCompletionProviderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) variable_completion_provider_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (VariableCompletionProvider), 0, (GInstanceInitFunc) variable_completion_provider_instance_init, NULL };
		GType variable_completion_provider_type_id;
		variable_completion_provider_type_id = g_type_register_static (TYPE_COMPLETION_PROVIDER, "VariableCompletionProvider", &g_define_type_info, 0);
		g_once_init_leave (&variable_completion_provider_type_id__volatile, variable_completion_provider_type_id);
	}
	return variable_completion_provider_type_id__volatile;
}


static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



