/* gcalccmd.c generated by valac 0.40.6, the Vala compiler
 * generated from gcalccmd.vala, do not modify */

/*
 * Copyright (C) 2009 Rich Burridge
 * Copyright (C) 2012 Robert Ancell
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */


#include <glib.h>
#include <glib-object.h>
#include "libcalculator.h"
#include <stdlib.h>
#include <string.h>
#include <langinfo.h>
#include <stdio.h>
#include <locale.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))


extern Serializer* result_serializer;
Serializer* result_serializer = NULL;

#define MAXLINE 1024
void solve (const gchar* equation);
gint _vala_main (gchar** args,
                 int args_length1);


static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


void
solve (const gchar* equation)
{
	gchar* tsep_string = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp3_;
	gchar* decimal = NULL;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	const gchar* _tmp8_;
	gchar* error_token = NULL;
	Equation* e = NULL;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	const gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	Equation* _tmp16_;
	Equation* _tmp17_;
	Equation* _tmp18_;
	Equation* _tmp19_;
	Equation* _tmp20_;
	ErrorCode ret = 0;
	guint representation_base = 0U;
	Number* z = NULL;
	Equation* _tmp21_;
	guint _tmp22_ = 0U;
	ErrorCode _tmp23_ = 0;
	gchar* _tmp24_ = NULL;
	Number* _tmp25_;
	Serializer* _tmp26_;
	guint _tmp27_;
	Number* _tmp28_;
	g_return_if_fail (equation != NULL);
	_tmp0_ = nl_langinfo (THOUSEP);
	_tmp1_ = g_strdup (_tmp0_);
	tsep_string = _tmp1_;
	_tmp3_ = tsep_string;
	if (_tmp3_ == NULL) {
		_tmp2_ = TRUE;
	} else {
		const gchar* _tmp4_;
		_tmp4_ = tsep_string;
		_tmp2_ = g_strcmp0 (_tmp4_, "") == 0;
	}
	if (_tmp2_) {
		gchar* _tmp5_;
		_tmp5_ = g_strdup (" ");
		_g_free0 (tsep_string);
		tsep_string = _tmp5_;
	}
	_tmp6_ = nl_langinfo (RADIXCHAR);
	_tmp7_ = g_strdup (_tmp6_);
	decimal = _tmp7_;
	_tmp8_ = decimal;
	if (_tmp8_ == NULL) {
		gchar* _tmp9_;
		_tmp9_ = g_strdup ("");
		_g_free0 (decimal);
		decimal = _tmp9_;
	}
	error_token = NULL;
	_tmp10_ = tsep_string;
	_tmp11_ = string_replace (equation, _tmp10_, "");
	_tmp12_ = _tmp11_;
	_tmp13_ = decimal;
	_tmp14_ = string_replace (_tmp12_, _tmp13_, ".");
	_tmp15_ = _tmp14_;
	_tmp16_ = equation_new (_tmp15_);
	_tmp17_ = _tmp16_;
	_g_free0 (_tmp15_);
	_g_free0 (_tmp12_);
	e = _tmp17_;
	_tmp18_ = e;
	_tmp18_->base = 10;
	_tmp19_ = e;
	_tmp19_->wordlen = 32;
	_tmp20_ = e;
	_tmp20_->angle_units = ANGLE_UNIT_DEGREES;
	_tmp21_ = e;
	_tmp25_ = equation_parse (_tmp21_, &_tmp22_, &_tmp23_, &_tmp24_, NULL, NULL);
	representation_base = _tmp22_;
	ret = _tmp23_;
	_g_free0 (error_token);
	error_token = _tmp24_;
	z = _tmp25_;
	_tmp26_ = result_serializer;
	_tmp27_ = representation_base;
	serializer_set_representation_base (_tmp26_, _tmp27_);
	_tmp28_ = z;
	if (_tmp28_ != NULL) {
		gchar* str = NULL;
		Serializer* _tmp29_;
		Number* _tmp30_;
		gchar* _tmp31_;
		Serializer* _tmp32_;
		const gchar* _tmp33_;
		const gchar* _tmp34_;
		_tmp29_ = result_serializer;
		_tmp30_ = z;
		_tmp31_ = serializer_to_string (_tmp29_, _tmp30_);
		str = _tmp31_;
		_tmp32_ = result_serializer;
		_tmp33_ = serializer_get_error (_tmp32_);
		_tmp34_ = _tmp33_;
		if (_tmp34_ != NULL) {
			FILE* _tmp35_;
			Serializer* _tmp36_;
			const gchar* _tmp37_;
			const gchar* _tmp38_;
			Serializer* _tmp39_;
			_tmp35_ = stderr;
			_tmp36_ = result_serializer;
			_tmp37_ = serializer_get_error (_tmp36_);
			_tmp38_ = _tmp37_;
			fprintf (_tmp35_, "%s\n", _tmp38_);
			_tmp39_ = result_serializer;
			serializer_set_error (_tmp39_, NULL);
		} else {
			FILE* _tmp40_;
			const gchar* _tmp41_;
			_tmp40_ = stdout;
			_tmp41_ = str;
			fprintf (_tmp40_, "%s\n", _tmp41_);
		}
		_g_free0 (str);
	} else {
		ErrorCode _tmp42_;
		_tmp42_ = ret;
		if (_tmp42_ == ERROR_CODE_MP) {
			const gchar* _tmp43_ = NULL;
			const gchar* _tmp44_;
			const gchar* _tmp45_;
			FILE* _tmp49_;
			_tmp44_ = number_get_error ();
			_tmp45_ = _tmp44_;
			if (_tmp45_ != NULL) {
				const gchar* _tmp46_;
				const gchar* _tmp47_;
				_tmp46_ = number_get_error ();
				_tmp47_ = _tmp46_;
				_tmp43_ = _tmp47_;
			} else {
				const gchar* _tmp48_;
				_tmp48_ = error_token;
				_tmp43_ = _tmp48_;
			}
			_tmp49_ = stderr;
			fprintf (_tmp49_, "Error %s\n", _tmp43_);
		} else {
			FILE* _tmp50_;
			ErrorCode _tmp51_;
			_tmp50_ = stderr;
			_tmp51_ = ret;
			fprintf (_tmp50_, "Error %d\n", (gint) _tmp51_);
		}
	}
	_g_object_unref0 (z);
	_g_object_unref0 (e);
	_g_free0 (error_token);
	_g_free0 (decimal);
	_g_free0 (tsep_string);
}


static gchar*
string_strip (const gchar* self)
{
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	g_strstrip (_tmp1_);
	result = _result_;
	return result;
}


gint
_vala_main (gchar** args,
            int args_length1)
{
	gint result = 0;
	GDateTime* now = NULL;
	GDateTime* _tmp0_;
	gboolean requires_new_line = FALSE;
	GDateTime* _tmp1_;
	Serializer* _tmp2_;
	gchar* buffer = NULL;
	gchar* _tmp4_;
	gint buffer_length1;
	gint _buffer_size_;
	gboolean _tmp21_;
	_tmp0_ = g_date_time_new_now_utc ();
	now = _tmp0_;
	requires_new_line = FALSE;
	_tmp1_ = now;
	g_random_set_seed ((guint32) g_date_time_get_microsecond (_tmp1_));
	setlocale (LC_ALL, "");
	_tmp2_ = serializer_new (DISPLAY_FORMAT_AUTOMATIC, 10, 9);
	_g_object_unref0 (result_serializer);
	result_serializer = _tmp2_;
	if (args_length1 == 2) {
		const gchar* _tmp3_;
		_tmp3_ = args[1];
		solve (_tmp3_);
		result = EXIT_SUCCESS;
		_g_date_time_unref0 (now);
		return result;
	}
	_tmp4_ = g_new0 (gchar, 1024);
	buffer = _tmp4_;
	buffer_length1 = 1024;
	_buffer_size_ = buffer_length1;
	while (TRUE) {
		FILE* _tmp5_;
		gchar* line = NULL;
		FILE* _tmp6_;
		gchar* _tmp7_;
		gint _tmp7__length1;
		const gchar* _tmp8_;
		gchar* _tmp9_;
		const gchar* _tmp10_;
		gboolean _tmp13_ = FALSE;
		gboolean _tmp14_ = FALSE;
		gboolean _tmp15_ = FALSE;
		const gchar* _tmp16_;
		const gchar* _tmp20_;
		_tmp5_ = stdout;
		fprintf (_tmp5_, "> ");
		_tmp6_ = stdin;
		_tmp7_ = buffer;
		_tmp7__length1 = buffer_length1;
		_tmp8_ = fgets (_tmp7_, _tmp7__length1, _tmp6_);
		_tmp9_ = g_strdup (_tmp8_);
		line = _tmp9_;
		_tmp10_ = line;
		if (_tmp10_ != NULL) {
			const gchar* _tmp11_;
			gchar* _tmp12_;
			_tmp11_ = line;
			_tmp12_ = string_strip (_tmp11_);
			_g_free0 (line);
			line = _tmp12_;
		} else {
			requires_new_line = TRUE;
		}
		_tmp16_ = line;
		if (_tmp16_ == NULL) {
			_tmp15_ = TRUE;
		} else {
			const gchar* _tmp17_;
			_tmp17_ = line;
			_tmp15_ = g_strcmp0 (_tmp17_, "exit") == 0;
		}
		if (_tmp15_) {
			_tmp14_ = TRUE;
		} else {
			const gchar* _tmp18_;
			_tmp18_ = line;
			_tmp14_ = g_strcmp0 (_tmp18_, "quit") == 0;
		}
		if (_tmp14_) {
			_tmp13_ = TRUE;
		} else {
			const gchar* _tmp19_;
			_tmp19_ = line;
			_tmp13_ = g_strcmp0 (_tmp19_, "") == 0;
		}
		if (_tmp13_) {
			_g_free0 (line);
			break;
		}
		_tmp20_ = line;
		solve (_tmp20_);
		_g_free0 (line);
	}
	_tmp21_ = requires_new_line;
	if (_tmp21_) {
		FILE* _tmp22_;
		_tmp22_ = stdout;
		fprintf (_tmp22_, "\n");
	}
	result = EXIT_SUCCESS;
	buffer = (g_free (buffer), NULL);
	_g_date_time_unref0 (now);
	return result;
}


int
main (int argc,
      char ** argv)
{
	return _vala_main (argv, argc);
}



