"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.BufferToSlice = BufferToSlice;
exports.collectTableData = collectTableData;
exports.calculateChecksum = calculateChecksum;
exports.allocateBlobOffsets = allocateBlobOffsets;
const Crypto = require("crypto");
const bin_util_1 = require("@ot-builder/bin-util");
const primitive_1 = require("@ot-builder/primitive");
function BufferToSlice(buf) {
    return { data: buf, start: 0, length: buf.byteLength };
}
function collectTableData(tag, slice, blobStore) {
    // Pad buffer with 0
    const b = (0, bin_util_1.alignBufferSize)(slice.data, 4);
    const hasher = Crypto.createHash("sha256");
    hasher.update(b);
    const hash = hasher.digest("hex");
    const existing = blobStore.get(hash);
    if (existing) {
        return { tag, blob: existing, start: slice.start, length: slice.length };
    }
    else {
        const blob = { offset: 0, content: b, checksum: calculateChecksum(b) };
        blobStore.set(hash, blob);
        return { tag, blob, start: slice.start, length: slice.length };
    }
}
function calculateChecksum(buf) {
    let checksum = 0;
    for (let mu = 0; mu < buf.length; mu += 4) {
        checksum = primitive_1.UInt32.from(checksum + buf.readUInt32BE(mu));
    }
    return checksum;
}
function allocateBlobOffsets(store) {
    let offset = 0;
    for (const [hash, blob] of store) {
        blob.offset = offset;
        offset += blob.content.byteLength;
    }
}
//# sourceMappingURL=collector.js.map