"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.inPlaceTransformFontGlyph = inPlaceTransformFontGlyph;
exports.inPlaceTransformFontGlyphDependent = inPlaceTransformFontGlyphDependent;
const Ot = require("@ot-builder/ot");
function inPlaceTransformFontGlyph(font, transform) {
    inPlaceTransformFontGlyphDependent(font, () => transform);
}
function inPlaceTransformFontGlyphDependent(font, transformF) {
    for (const g of font.glyphs.decideOrder()) {
        const flattened = Ot.GeometryUtil.apply(Ot.GeometryUtil.Flattener, g.geometry);
        g.geometry = new Ot.Glyph.ContourSet(flattened);
    }
    for (const g of font.glyphs.decideOrder()) {
        if (!g.geometry || g.geometry.type !== Ot.Glyph.GeometryType.ContourSet)
            continue;
        const tfm = transformF(g);
        for (const c of g.geometry.contours) {
            for (let iz = 0; iz < c.length; iz++) {
                c[iz] = Ot.Glyph.PointOps.applyTransform(c[iz], tfm);
            }
        }
    }
}
//# sourceMappingURL=transform-glyphs.js.map