// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.

using System;
using System.Runtime.CompilerServices;
using System.Numerics;
using System.Runtime.Intrinsics;
using System.Runtime.Intrinsics.X86;
using Xunit;

// Generated by Fuzzlyn v2.2 on 2024-08-01 15:01:31
// Run on X64 Windows
// Seed: 8577405969008594479-vectort,vector128,vector256,x86aes,x86avx,x86avx2,x86avx512bw,x86avx512bwvl,x86avx512cd,x86avx512cdvl,x86avx512dq,x86avx512dqvl,x86avx512f,x86avx512fvl,x86avx512fx64,x86bmi1,x86bmi1x64,x86bmi2,x86bmi2x64,x86fma,x86lzcnt,x86lzcntx64,x86pclmulqdq,x86popcnt,x86popcntx64,x86sse,x86ssex64,x86sse2,x86sse2x64,x86sse3,x86sse41,x86sse41x64,x86sse42,x86sse42x64,x86ssse3,x86x86base
// Reduced from 43.4 KiB to 0.7 KiB in 00:01:17
// Debug: Outputs -1
// Release: Outputs 0

public class Runtime_105824
{
    [Fact]
    public static void TestEntryPoint()
    {
        if (Avx2.IsSupported)
        {
            uint[][] vr6 = new uint[][]
            {
                new uint[]
                {
                    0
                }
            };
            var vr7 = Vector256.Create<uint>(0);
            var vr8 = vr6[0][0];
            var vr9 = Vector256.Create<uint>(vr8);
            var vr10 = Vector256.CreateScalar(0U);
            var vr11 = Avx2.PermuteVar8x32(vr9, vr10);
            var vr12 = Avx2.CompareEqual(vr7, vr11);
            short vr13 = (short)Avx2.ConvertToUInt32(vr12);
            Assert.Equal(-1, vr13);
        }
    }
}