## cosign

A tool for Container Signing, Verification and Storage in an OCI registry.

### Options

```
  -h, --help                 help for cosign
      --output-file string   log output to a file
  -t, --timeout duration     timeout for commands (default 3m0s)
  -d, --verbose              log debug output
```

### SEE ALSO

* [cosign attach](cosign_attach.md)	 - Provides utilities for attaching artifacts to other artifacts in a registry
* [cosign attest](cosign_attest.md)	 - Attest the supplied container image.
* [cosign attest-blob](cosign_attest-blob.md)	 - Attest the supplied blob.
* [cosign bundle](cosign_bundle.md)	 - Interact with a Sigstore protobuf bundle
* [cosign clean](cosign_clean.md)	 - Remove all signatures from an image.
* [cosign completion](cosign_completion.md)	 - Generate completion script
* [cosign copy](cosign_copy.md)	 - Copy the supplied container image and signatures.
* [cosign dockerfile](cosign_dockerfile.md)	 - Provides utilities for discovering images in and performing operations on Dockerfiles
* [cosign download](cosign_download.md)	 - Provides utilities for downloading artifacts and attached artifacts in a registry
* [cosign env](cosign_env.md)	 - Prints Cosign environment variables
* [cosign generate](cosign_generate.md)	 - Generates (unsigned) signature payloads from the supplied container image.
* [cosign generate-key-pair](cosign_generate-key-pair.md)	 - Generates a key-pair.
* [cosign import-key-pair](cosign_import-key-pair.md)	 - Imports a PEM-encoded RSA or EC private key.
* [cosign initialize](cosign_initialize.md)	 - Initializes SigStore root to retrieve trusted certificate and key targets for verification.
* [cosign load](cosign_load.md)	 - Load a signed image on disk to a remote registry
* [cosign login](cosign_login.md)	 - Log in to a registry
* [cosign manifest](cosign_manifest.md)	 - Provides utilities for discovering images in and performing operations on Kubernetes manifests
* [cosign piv-tool](cosign_piv-tool.md)	 - Provides utilities for managing a hardware token
* [cosign pkcs11-tool](cosign_pkcs11-tool.md)	 - Provides utilities for retrieving information from a PKCS11 token.
* [cosign public-key](cosign_public-key.md)	 - Gets a public key from the key-pair.
* [cosign save](cosign_save.md)	 - Save the container image and associated signatures to disk at the specified directory.
* [cosign sign](cosign_sign.md)	 - Sign the supplied container image.
* [cosign sign-blob](cosign_sign-blob.md)	 - Sign the supplied blob, outputting the base64-encoded signature to stdout.
* [cosign signing-config](cosign_signing-config.md)	 - Interact with a Sigstore protobuf signing config
* [cosign tree](cosign_tree.md)	 - Display supply chain security related artifacts for an image such as signatures, SBOMs and attestations
* [cosign triangulate](cosign_triangulate.md)	 - Outputs the located cosign image reference. This is the location where cosign stores the specified artifact type.
* [cosign trusted-root](cosign_trusted-root.md)	 - Interact with a Sigstore protobuf trusted root
* [cosign upload](cosign_upload.md)	 - Provides utilities for uploading artifacts to a registry
* [cosign verify](cosign_verify.md)	 - Verify a signature on the supplied container image
* [cosign verify-attestation](cosign_verify-attestation.md)	 - Verify an attestation on the supplied container image
* [cosign verify-blob](cosign_verify-blob.md)	 - Verify a signature on the supplied blob
* [cosign verify-blob-attestation](cosign_verify-blob-attestation.md)	 - Verify an attestation on the supplied blob
* [cosign version](cosign_version.md)	 - Prints the version

