/*
* Copyright (c) 2017, Intel Corporation
*
* Permission is hereby granted, free of charge, to any person obtaining a
* copy of this software and associated documentation files (the "Software"),
* to deal in the Software without restriction, including without limitation
* the rights to use, copy, modify, merge, publish, distribute, sublicense,
* and/or sell copies of the Software, and to permit persons to whom the
* Software is furnished to do so, subject to the following conditions:
*
* The above copyright notice and this permission notice shall be included
* in all copies or substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
* OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
* THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR
* OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
* ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
* OTHER DEALINGS IN THE SOFTWARE.
*/
//!
//! \file     codechal_encode_hevc_table_g11.cpp
//! \brief    HEVC dual-pipe encoder constant table for GEN11.
//!

#include "codechal_encode_hevc_g11.h"

const double INVAL = 0.00; //!< irrelevant mode

const uint8_t CodechalEncHevcStateG11::m_meMethod[NUM_TARGET_USAGE_MODES] = {0, 4, 4, 6, 6, 6, 6, 6}; //!< ME method

// TU Based Setting mentioned in Kernel
const uint8_t CodechalEncHevcStateG11::m_tuSettings[TotalTuParams][3]
{
    //{TU1, TU4, TU6}
    { 2, 3, 0 }, // IntraSpotCheckFlagTuParam
    { 1, 0, 0 }, // EnableCu64CheckTuParam
    { 6, 0, 0 }, // DynamicOrderThTuParam
    { 0, 6, 8 }, // Dynamic64ThTuParam
    { 0, 0, 0 }, // Dynamic64OrderTuParam
    { 0, 2, 2 }, // Dynamic64EnableTuParam
    { 1, 6, 11 }, // IncreaseExitThreshTuParam
    { 2, 1, 1 }, // Log2TUMaxDepthInterTuParam
    { 2, 2, 1 }, // Log2TUMaxDepthIntraTuParam
    { 3, 2, 2 }, // MaxNumIMESearchCenterTuParam
    { 0, 1, 1 }, // Fake32EnableTuParam
    { 3, 0, 0 }, // Dynamic64Min32
};

//!< Mode bits LUT based on LCUType/Mode/SliceType
const double CodechalEncHevcStateG11::m_modeBits[2][46][3] =
//Don't change values in this table, try Mode_Bits_Scale instead
{
    //LCU 32x32
    {
        //   B      P      I
        { INVAL, INVAL, INVAL },    //!< INTRA_64X64
        { 9.50, 9.50, 7.50 },       //!< INTRA_32X32
        { 9.75, 9.75, 7.75 },       //!< INTRA_16X16
        { 9.81, 9.81, 7.81 },       //!< INTRA_8X8
        { 7.50, 7.50, 7.50 },       //!< INTRA_NXN
        { INVAL, INVAL, INVAL },    //!< INTRA_2NXN_32X32 (VP9 only)
        { INVAL, INVAL, INVAL },    //!< INTRA_2NXN_16X16 (VP9 only)
        { 3.50, 3.50, 3.50 },       //!< INTRA_MPM
        { 1.50, 1.50, 1.50 },       //!< INTRA_CHROMA
        { 0.00, 0.00, 0.00 },       //!< INTRA_DC_32X32
        { 0.00, 0.00, 0.00 },       //!< INTRA_DC_8X8
        { 0.00, 0.00, 0.00 },       //!< INTRA_NONDC_32X32
        { 0.00, 0.00, 0.00 },       //!< INTRA_NONDC_16X16
        { 0.00, 0.00, 0.00 },       //!< INTRA_NONDC_8X8
        { INVAL, INVAL, INVAL },    //!< INTER_64X64
        { INVAL, INVAL, INVAL },    //!< INTER_64X32
        { 12.50, 11.00, INVAL },    //!< INTER_32X32
        { 18.00, 15.00, INVAL },    //!< INTER_32X16
        { 12.75, 11.25, INVAL },    //!< INTER_16X16
        { 18.25, 15.25, INVAL },    //!< INTER_16X8
        { 11.81, 10.31, INVAL },    //!< INTER_8X8
        { 0.00, 0.00, INVAL },      //!< INTER_BIDIR
        { 1.00, 1.00, INVAL },      //!< INTER_REFID
        { INVAL, INVAL, INVAL },    //!< MERGE_64X64
        { 8.50, 8.50, INVAL },      //!< MERGE_32X32
        { 8.75, 8.75, INVAL },      //!< MERGE_16X16
        { 7.81, 7.81, INVAL },      //!< MERGE_8X8
        { 3.50, 3.50, INVAL },      //!< INTER_SKIP
        { INVAL, INVAL, INVAL },    //!< SKIP_64X64
        { 4.50, 4.50, INVAL },      //!< SKIP_32X32
        { 4.75, 4.75, INVAL },      //!< SKIP_16X16
        { 3.81, 3.81, INVAL },      //!< SKIP_8X8
        { INVAL, INVAL, INVAL },    //!< NEAR_MV (VP9 only)
        { INVAL, INVAL, INVAL },    //!< NEAREST_MV (VP9 only)
        { INVAL, INVAL, INVAL },    //!< ZERO_MV (VP9 only)
        { 1.00, 1.00, 1.00 },       //!< TU_DEPTH_0
        { 5.00, 5.00, 5.00 },       //!< TU_DEPTH_1
        { INVAL, INVAL, INVAL },    //!< TU_DEPTH_2 (VP9 only)
        { 3.00, 3.00, 3.00 },       //!< INTRA_CBF_32X32
        { 3.00, 3.00, 3.00 },       //!< INTRA_CBF_16X16
        { 3.00, 3.00, 3.00 },       //!< INTRA_CBF_8X8
        { 3.00, 3.00, 3.00 },       //!< INTRA_CBF_4X4
        { 3.00, 3.00, 3.00 },       //!< INTER_CBF_32X32
        { 3.00, 3.00, 3.00 },       //!< INTER_CBF_16X16
        { 3.00, 3.00, 3.00 },       //!< INTER_CBF_8X8
        { 3.00, 3.00, 3.00 },       //!< INTER_CBF_4X4
    },
    //LCU 64x64
    {
        //   B      P      I
        { 17.10, 17.10, 7.50 },     //!< INTRA_64X64
        { 9.75, 9.75, 7.75 },       //!< INTRA_32X32
        { 9.81, 9.81, 7.81 },       //!< INTRA_16X16
        { 9.83, 9.83, 7.83 },       //!< INTRA_8X8
        { 7.50, 7.50, 7.50 },       //!< INTRA_NXN
        { INVAL, INVAL, INVAL },    //!< INTRA_2NXN_32X32 (VP9 only)
        { INVAL, INVAL, INVAL },    //!< INTRA_2NXN_16X16 (VP9 only)
        { 3.50, 3.50, 3.50 },       //!< INTRA_MPM
        { 1.50, 1.50, 1.50 },       //!< INTRA_CHROMA
        { 0.00, 0.00, 0.00 },       //!< INTRA_DC_32X32
        { 0.00, 0.00, 0.00 },       //!< INTRA_DC_8X8
        { 0.00, 0.00, 0.00 },       //!< INTRA_NONDC_32X32
        { 0.00, 0.00, 0.00 },       //!< INTRA_NONDC_16X16
        { 0.00, 0.00, 0.00 },       //!< INTRA_NONDC_8X8
        { 20.50, 19.00, INVAL },    //!< INTER_64X64
        { 36.40, 32.20, INVAL },    //!< INTER_64X32
        { 12.75, 11.25, INVAL },    //!< INTER_32X32
        { 18.25, 15.25, INVAL },    //!< INTER_32X16
        { 12.81, 11.31, INVAL },    //!< INTER_16X16
        { 18.31, 15.31, INVAL },    //!< INTER_16X8
        { 11.83, 10.33, INVAL },    //!< INTER_8X8
        { 0.00, 0.00, INVAL },      //!< INTER_BIDIR
        { 1.00, 1.00, 1.00 },       //!< INTER_REFID
        { 12.75, 12.75, INVAL },    //!< MERGE_64X64
        { 8.75, 8.75, INVAL },      //!< MERGE_32X32
        { 8.81, 8.81, INVAL },      //!< MERGE_16X16
        { 7.83, 7.83, INVAL },      //!< MERGE_8X8
        { 3.50, 3.50, INVAL },      //!< INTER_SKIP
        { 6.75, 6.75, INVAL },      //!< SKIP_64X64
        { 4.75, 4.75, INVAL },      //!< SKIP_32X32
        { 4.81, 4.81, INVAL },      //!< SKIP_16X16
        { 3.83, 3.83, INVAL },      //!< SKIP_8X8
        { INVAL, INVAL, INVAL },    //!< NEAR_MV (VP9 only)
        { INVAL, INVAL, INVAL },    //!< NEAREST_MV (VP9 only)
        { INVAL, INVAL, INVAL },    //!< ZERO_MV (VP9 only)
        { 1.00, 1.00, 1.00 },       //!< TU_DEPTH_0
        { 5.00, 5.00, 5.00 },       //!< TU_DEPTH_1
        { INVAL, INVAL, INVAL },    //!< TU_DEPTH_2 (VP9 only)
        { 3.00, 3.00, 3.00 },       //!< INTRA_CBF_32X32
        { 3.00, 3.00, 3.00 },       //!< INTRA_CBF_16X16
        { 3.00, 3.00, 3.00 },       //!< INTRA_CBF_8X8
        { 3.00, 3.00, 3.00 },       //!< INTRA_CBF_4X4
        { 3.00, 3.00, 3.00 },       //!< INTER_CBF_32X32
        { 3.00, 3.00, 3.00 },       //!< INTER_CBF_16X16
        { 3.00, 3.00, 3.00 },       //!< INTER_CBF_8X8
        { 3.00, 3.00, 3.00 },       //!< INTER_CBF_4X4
    }
};

//!< Mode bits LUT based on [mode][SliceType]
const double CodechalEncHevcStateG11::m_modeBitsScale[46][3] =
{
    //   B      P      I   (using rec pixel based intra pred)
    { 1.00, 1.00, 1.00 },   //!< INTRA_64X64
    { 1.00, 1.00, 1.00 },   //!< INTRA_32X32
    { 1.00, 1.00, 1.00 },   //!< INTRA_16X16
    { 1.00, 1.00, 1.00 },   //!< INTRA_8X8
    { 1.00, 1.00, 1.00 },   //!< INTRA_NXN
    { 1.00, 1.00, 1.00 },   //!< INTRA_2NXN_32X32 (VP9 only)
    { 1.00, 1.00, 1.00 },   //!< INTRA_2NXN_16X16 (VP9 only)
    { 1.00, 1.00, 1.00 },   //!< INTRA_MPM
    { 9.00, 9.00, 5.00 },   //!< INTRA_CHROMA
    { 1.00, 1.00, 1.00 },   //!< INTRA_DC_32X32
    { 1.00, 1.00, 1.00 },   //!< INTRA_DC_8X8
    { 1.00, 1.00, 1.00 },   //!< INTRA_NONDC_32X32
    { 1.00, 1.00, 1.00 },   //!< INTRA_NONDC_16X16
    { 1.00, 1.00, 1.00 },   //!< INTRA_NONDC_8X8
    { 1.00, 1.00, 1.00 },   //!< INTER_64X64
    { 1.00, 1.00, 1.00 },   //!< INTER_64X32
    { 1.50, 1.50, 1.00 },   //!< INTER_32X32
    { 1.50, 1.50, 1.00 },   //!< INTER_32X16
    { 1.50, 1.50, 1.00 },   //!< INTER_16X16
    { 1.50, 1.50, 1.00 },   //!< INTER_16X8
    { 1.50, 1.50, 1.00 },   //!< INTER_8X8
    { 1.00, 1.00, 1.00 },   //!< INTER_BIDIR
    { 1.00, 1.00, 1.00 },   //!< INTER_REFID
    { 1.00, 1.00, 1.00 },   //!< MERGE_64X64
    { 1.00, 1.00, 1.00 },   //!< MERGE_32X32
    { 1.00, 1.00, 1.00 },   //!< MERGE_16X16
    { 1.00, 1.00, 1.00 },   //!< MERGE_8X8
    { 1.00, 1.00, 1.00 },   //!< INTER_SKIP
    { 1.00, 1.00, 1.00 },   //!< SKIP_64X64
    { 1.00, 1.00, 1.00 },   //!< SKIP_32X32
    { 1.00, 1.00, 1.00 },   //!< SKIP_16X16
    { 1.00, 1.00, 1.00 },   //!< SKIP_8X8
    { 1.00, 1.00, 1.00 },   //!< NEAR_MV (VP9 only)
    { 1.00, 1.00, 1.00 },   //!< NEAREST_MV (VP9 only)
    { 1.00, 1.00, 1.00 },   //!< ZERO_MV (VP9 only)
    { 1.00, 1.00, 1.00 },   //!< TU_DEPTH_0
    { 1.00, 1.00, 1.00 },   //!< TU_DEPTH_1
    { 1.00, 1.00, 1.00 },   //!< TU_DEPTH_2 (VP9 only)
    { 1.00, 1.00, 1.00 },   //!< INTRA_CBF_32X32
    { 1.00, 1.00, 1.00 },   //!< INTRA_CBF_16X16
    { 1.00, 1.00, 1.00 },   //!< INTRA_CBF_8X8
    { 1.00, 1.00, 1.00 },   //!< INTRA_CBF_4X4
    { 1.00, 1.00, 1.00 },   //!< INTER_CBF_32X32
    { 1.00, 1.00, 1.00 },   //!< INTER_CBF_16X16
    { 1.00, 1.00, 1.00 },   //!< INTER_CBF_8X8
    { 1.00, 1.00, 1.00 },   //!< INTER_CBF_4X4
};

const uint32_t CodechalEncHevcStateG11::m_encLcu32ConstantDataLut[m_encConstantDataLutSize/4] =
{
    0x05040200, 0x0c0a0807, 0x19180f0d, 0x00000003, 0x07070702, 0x041b051b, 0x0a000005, 0x00000002, 
    0x00000000, 0x00000000, 0x00050015, 0x00040016, 0x00000005, 0x00000000, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00000000, 0x00000000, 0x00000000, 
    0x05040200, 0x0c0a0807, 0x19180f0d, 0x00000003, 0x07070702, 0x041b051b, 0x0a000005, 0x00000002, 
    0x00000000, 0x00000000, 0x00050015, 0x00040016, 0x00000005, 0x00000000, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00000000, 0x00000000, 0x00000000, 
    0x05040200, 0x0c0a0807, 0x19180f0d, 0x00000003, 0x07070702, 0x041b051b, 0x0a000005, 0x00000002, 
    0x00000000, 0x00000000, 0x00050015, 0x00040016, 0x00000005, 0x00000000, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00000000, 0x00000000, 0x00000000, 
    0x05040200, 0x0c0a0807, 0x19180f0d, 0x00000003, 0x07070702, 0x041b051b, 0x0a000005, 0x00000002, 
    0x00000000, 0x00000000, 0x00050015, 0x00040016, 0x00000005, 0x00000000, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00000000, 0x00000000, 0x00000000, 
    0x05040200, 0x0c0a0807, 0x19180f0d, 0x00000003, 0x07070702, 0x041b051b, 0x0a000005, 0x00000002, 
    0x00000000, 0x00000000, 0x00050015, 0x00040016, 0x00000005, 0x00000000, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00000000, 0x00000000, 0x00000000, 
    0x05040200, 0x0c0a0807, 0x19180f0d, 0x00000003, 0x07070702, 0x041b051b, 0x0a000005, 0x00000002, 
    0x00000000, 0x00000000, 0x00050015, 0x00040016, 0x00000005, 0x00000000, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00000000, 0x00000000, 0x00000000, 
    0x05040200, 0x0c0a0807, 0x19180f0d, 0x00000003, 0x07070702, 0x041b051b, 0x0a000005, 0x00000002, 
    0x00000000, 0x00000000, 0x00050015, 0x00040016, 0x00000005, 0x00000000, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00000000, 0x00000000, 0x00000000, 
    0x05040200, 0x0c0a0807, 0x19180f0d, 0x00000003, 0x07070702, 0x041b051b, 0x0a000005, 0x00000002, 
    0x00000000, 0x00000000, 0x00050015, 0x00040016, 0x00000005, 0x00000000, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00000000, 0x00000000, 0x00000000, 
    0x05040200, 0x0c0a0807, 0x19180f0d, 0x00000003, 0x07070702, 0x041b051b, 0x0a000005, 0x00000002, 
    0x00000000, 0x00000000, 0x00050015, 0x00040016, 0x00000005, 0x00000000, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00000000, 0x00000000, 0x00000000, 
    0x05040200, 0x0c0a0807, 0x19180f0d, 0x00000003, 0x07070702, 0x041b051b, 0x0a000005, 0x00000002, 
    0x00000000, 0x00000000, 0x00050015, 0x00040016, 0x00000005, 0x00000000, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00000000, 0x00000000, 0x00000000, 
    0x05040200, 0x0c0a0807, 0x19180f0d, 0x00000003, 0x07070702, 0x041b051b, 0x0a000005, 0x00000002, 
    0x00000000, 0x00000000, 0x00050015, 0x00040016, 0x00000005, 0x00000000, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00000000, 0x00000000, 0x00000000, 
    0x05040200, 0x0c0a0807, 0x19180f0d, 0x00000003, 0x07070702, 0x041b051b, 0x0a000005, 0x00000002, 
    0x00000000, 0x00000000, 0x00050015, 0x00040016, 0x00000005, 0x00000000, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00000000, 0x00000000, 0x00000000, 
    0x05040200, 0x0c0a0807, 0x19180f0d, 0x00000003, 0x07070702, 0x041b051b, 0x0a000005, 0x00000002, 
    0x00000000, 0x00000000, 0x00050015, 0x00040016, 0x00000005, 0x00000000, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00000000, 0x00000000, 0x00000000, 
    0x06040200, 0x0d0b0908, 0x1a1a190f, 0x00000003, 0x08080803, 0x051c051c, 0x0c000005, 0x00000003, 
    0x00000000, 0x00000000, 0x00050018, 0x00050018, 0x00000005, 0x00000000, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00000000, 0x00000000, 0x00000000, 
    0x07050301, 0x0f0d0b09, 0x1c1b1a19, 0x00000004, 0x09090903, 0x051e061e, 0x0d010106, 0x00000003, 
    0x00000000, 0x00000000, 0x0006001b, 0x0005001b, 0x00000006, 0x00000001, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00000000, 0x00000000, 0x00000000, 
    0x07050301, 0x190e0c0a, 0x1d1c1b1a, 0x00000005, 0x0b0b0a03, 0x0628071f, 0x0f010107, 0x00000003, 
    0x00000000, 0x00000000, 0x0007001e, 0x0006001f, 0x00000007, 0x00000001, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00000000, 0x00000000, 0x00000000, 
    0x08060301, 0x1a180e0b, 0x1f1d1c1b, 0x00000007, 0x0c0c0c04, 0x07290829, 0x19010107, 0x00000004, 
    0x00000000, 0x00000000, 0x00080022, 0x00070023, 0x00000007, 0x00000001, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00000000, 0x00000000, 0x00000000, 
    0x0a070401, 0x1b190f0c, 0x281f1e1c, 0x00000008, 0x0e0e0d05, 0x082a092a, 0x1a010108, 0x00000005, 
    0x00000000, 0x00000000, 0x00090026, 0x00080027, 0x00000008, 0x00000001, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00000000, 0x00000000, 0x00000000, 
    0x0b080401, 0x1c1a190e, 0x29281f1e, 0x0000000a, 0x0f0f0f05, 0x092b0a2b, 0x1b01010a, 0x00000005, 
    0x00000000, 0x00000000, 0x000a002b, 0x0009002c, 0x0000000a, 0x00000001, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00000000, 0x00000000, 0x00000000, 
    0x0c090501, 0x1e1c1a18, 0x2a2a291f, 0x0000000d, 0x19191906, 0x0a2c0b2c, 0x1c01010b, 0x00000006, 
    0x00000000, 0x00000000, 0x000b0030, 0x000a0031, 0x0000000b, 0x00000001, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00000000, 0x00000000, 0x00000000, 
    0x0e0a0602, 0x1f1d1b19, 0x2c2b2a29, 0x00000011, 0x1a1a1a07, 0x0b2e0c2e, 0x1e02020c, 0x00000007, 
    0x00000000, 0x00000000, 0x000c0036, 0x000b0037, 0x0000000c, 0x00000002, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00000000, 0x00000000, 0x00000000, 
    0x0f0b0602, 0x291f1d1a, 0x2d2c2b2a, 0x00000015, 0x1b1b1b07, 0x0d380e2f, 0x1f02020e, 0x00000007, 
    0x00000000, 0x00000000, 0x000e003d, 0x000d003e, 0x0000000e, 0x00000002, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00000000, 0x00000000, 0x00000000, 
    0x190c0702, 0x2a281e1c, 0x2f2d2c2b, 0x0000001a, 0x1d1c1c08, 0x0f391839, 0x2902020f, 0x00000008, 
    0x00000000, 0x00000000, 0x00100045, 0x000f0046, 0x0000000f, 0x00000002, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00000000, 0x00000000, 0x00000000, 
    0x1a0e0802, 0x2b29281d, 0x382f2e2c, 0x00000021, 0x1e1e1e0a, 0x183a193a, 0x2a020219, 0x0000000a, 
    0x00000000, 0x00000000, 0x0012004d, 0x0010004e, 0x00000011, 0x00000002, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00000000, 0x00000000, 0x00000000, 
    0x1b180903, 0x2c2a291f, 0x39382f2e, 0x0000002a, 0x28281f0b, 0x1a3b1a3b, 0x2b03031a, 0x0000000b, 
    0x00000000, 0x00000000, 0x00140057, 0x00130058, 0x00000014, 0x00000003, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00000000, 0x00000000, 0x00000000, 
    0x1d190a03, 0x2e2c2a28, 0x3a3a392f, 0x00000034, 0x2929290c, 0x1b3c1c3c, 0x2c03031b, 0x0000000c, 
    0x00000000, 0x00000000, 0x00170061, 0x00150063, 0x00000016, 0x00000003, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00000000, 0x00000000, 0x00000000, 
    0x1e1a0c04, 0x2f2d2b29, 0x3c3b3a39, 0x00000042, 0x2a2a2a0e, 0x1c3e1d3e, 0x2e04041d, 0x0000000e, 
    0x00000000, 0x00000000, 0x0019006d, 0x0017006f, 0x00000019, 0x00000004, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00000000, 0x00000000, 0x00000000, 
    0x281b0d04, 0x392f2d2a, 0x3d3c3b3a, 0x00000053, 0x2b2b2b0f, 0x1d481f3f, 0x2f04041e, 0x0000000f, 
    0x00000000, 0x00000000, 0x001d007b, 0x001a007c, 0x0000001c, 0x00000004, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00000000, 0x00000000, 0x00000000, 
    0x291d0f05, 0x3a382e2c, 0x3f3d3c3b, 0x00000069, 0x2d2c2c19, 0x1f492849, 0x39050528, 0x00000019, 
    0x00000000, 0x00000000, 0x0020008a, 0x001e008c, 0x0000001f, 0x00000005, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00000000, 0x00000000, 0x00000000, 
    0x2a1e1905, 0x3b39382d, 0x483f3e3c, 0x00000084, 0x2e2e2e1a, 0x284a294a, 0x3a050529, 0x0000001a, 
    0x00000000, 0x00000000, 0x0024009b, 0x0021009d, 0x00000023, 0x00000005, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00000000, 0x00000000, 0x00000000, 
    0x2b281a06, 0x3c3a392f, 0x49483f3e, 0x000000a6, 0x38382f1b, 0x2a4b2a4b, 0x3b06062a, 0x0000001b, 
    0x00000000, 0x00000000, 0x002900ae, 0x002600b0, 0x00000028, 0x00000006, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00000000, 0x00000000, 0x00000000, 
    0x2d291b07, 0x3e3c3a38, 0x4a4a493f, 0x000000d2, 0x3939391d, 0x2b4c2c4c, 0x3c07072b, 0x0000001d, 
    0x00000000, 0x00000000, 0x002e00c3, 0x002a00c6, 0x0000002d, 0x00000007, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00000000, 0x00000000, 0x00000000, 
    0x2e2a1c08, 0x3f3d3b39, 0x4c4b4a49, 0x00000108, 0x3a3a3a1e, 0x2c4e2d4e, 0x3e08082d, 0x0000001e, 
    0x00000000, 0x00000000, 0x003300db, 0x002f00de, 0x00000032, 0x00000008, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00000000, 0x00000000, 0x00000000, 
    0x382b1e09, 0x493f3d3a, 0x4d4c4b4a, 0x0000014d, 0x3b3b3b28, 0x2d582f4f, 0x3f09092e, 0x00000028, 
    0x00000000, 0x00000000, 0x003a00f6, 0x003500f9, 0x00000039, 0x00000009, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00000000, 0x00000000, 0x00000000, 
    0x392d1f0a, 0x4a483e3c, 0x4f4d4c4b, 0x000001a3, 0x3d3c3c29, 0x2f593859, 0x490a0a38, 0x00000029, 
    0x00000000, 0x00000000, 0x00410114, 0x003c0118, 0x0000003f, 0x0000000a, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00000000, 0x00000000, 0x00000000, 
    0x3a2e290b, 0x4b49483d, 0x584f4e4c, 0x00000210, 0x3e3e3e2a, 0x385a395a, 0x4a0b0b39, 0x0000002a, 
    0x00000000, 0x00000000, 0x00490136, 0x0043013a, 0x00000047, 0x0000000b, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00000000, 0x00000000, 0x00000000, 
    0x3b382a0c, 0x4c4a493f, 0x59584f4e, 0x0000029a, 0x48483f2b, 0x3a5b3a5b, 0x4b0c0c3a, 0x0000002b, 
    0x00000000, 0x00000000, 0x0052015c, 0x004c0161, 0x00000050, 0x0000000c, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00000000, 0x00000000, 0x00000000, 
    0x3d392b0e, 0x4e4c4a48, 0x5a5a594f, 0x00000347, 0x4949492d, 0x3b5c3c5c, 0x4c0e0e3b, 0x0000002d, 
    0x00000000, 0x00000000, 0x005c0186, 0x0055018c, 0x0000005a, 0x0000000e, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00000000, 0x00000000, 0x00000000, 
    0x3e3a2c18, 0x4f4d4b49, 0x5c5b5a59, 0x00000421, 0x4a4a4a2e, 0x3c5e3d5e, 0x4e18183d, 0x0000002e, 
    0x00000000, 0x00000000, 0x006701b6, 0x005f01bc, 0x00000065, 0x00000010, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00000000, 0x00000000, 0x00000000, 
    0x483b2e19, 0x594f4d4a, 0x5d5c5b5a, 0x00000533, 0x4b4b4b38, 0x3d683f5f, 0x4f19193e, 0x00000038, 
    0x00000000, 0x00000000, 0x007401ec, 0x006b01f3, 0x00000072, 0x00000012, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00000000, 0x00000000, 0x00000000, 
    0x493d2f1a, 0x5a584e4c, 0x5f5d5c5b, 0x0000068d, 0x4d4c4c39, 0x3f694869, 0x591a1a48, 0x00000039, 
    0x00000000, 0x00000000, 0x00820228, 0x00780230, 0x0000007f, 0x00000014, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00000000, 0x00000000, 0x00000000, 
    0x4a3e391b, 0x5b59584d, 0x685f5e5c, 0x00000841, 0x4e4e4e3a, 0x486a496a, 0x5a1b1b49, 0x0000003a, 
    0x00000000, 0x00000000, 0x0092026c, 0x00870275, 0x0000008f, 0x00000016, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00000000, 0x00000000, 0x00000000, 
    0x4b483a1d, 0x5c5a594f, 0x69685f5e, 0x00000a66, 0x58584f3b, 0x4a6b4a6b, 0x5b1d1d4a, 0x0000003b, 
    0x00000000, 0x00000000, 0x00a402b8, 0x009802c2, 0x000000a1, 0x00000019, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00000000, 0x00000000, 0x00000000, 
    0x4d493b1e, 0x5e5c5a58, 0x6a6a695f, 0x00000d1a, 0x5959593d, 0x4b6c4c6c, 0x5c1e1e4b, 0x0000003d, 
    0x00000000, 0x00000000, 0x00b8030d, 0x00ab0318, 0x000000b4, 0x0000001c, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00000000, 0x00000000, 0x00000000, 
    0x4e4a3c28, 0x5f5d5b59, 0x6c6b6a69, 0x00001082, 0x5a5a5a3e, 0x4c6e4d6e, 0x5e28284d, 0x0000003e, 
    0x00000000, 0x00000000, 0x00cf036d, 0x00bf0379, 0x000000cb, 0x00000020, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00000000, 0x00000000, 0x00000000, 
    0x584b3e29, 0x695f5d5a, 0x6d6c6b6a, 0x000014cd, 0x5b5b5b48, 0x4d784f6f, 0x5f29294e, 0x00000048, 
    0x00000000, 0x00000000, 0x00e803d9, 0x00d703e6, 0x000000e4, 0x00000024, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00000000, 0x00000000, 0x00000000, 
    0x594d3f2a, 0x6a685e5c, 0x6f6d6c6b, 0x00001a35, 0x5d5c5c49, 0x4f795879, 0x692a2a58, 0x00000049, 
    0x00000000, 0x00000000, 0x01050451, 0x00f10461, 0x000000ff, 0x00000028, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00000000, 0x00000000, 0x00000000, 
    0x5a4e492b, 0x6b69685d, 0x6f6f6e6c, 0x00002105, 0x5e5e5e4a, 0x587a597a, 0x6a2b2b59, 0x0000004a, 
    0x00000000, 0x00000000, 0x012504d9, 0x010f04ea, 0x0000011f, 0x0000002d, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00000000, 0x00000000, 0x00000000, 
    0x5b584a2d, 0x6c6a695f, 0x6f6f6f6e, 0x0000299a, 0x68685f4b, 0x5a7b5a7b, 0x6b2d2d5a, 0x0000004b, 
    0x00000000, 0x00000000, 0x01480571, 0x01300584, 0x00000142, 0x00000033, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00000000, 0x00000000, 0x00000000, 
    0x5d594b2e, 0x6e6c6a68, 0x6f6f6f6f, 0x0000346a, 0x6969694d, 0x5b7c5c7c, 0x6c2e2e5b, 0x0000004d, 
    0x00000000, 0x00000000, 0x0171061b, 0x01560631, 0x00000169, 0x00000039, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00000000, 0x00000000, 0x00000000, 
    0x5e5a4c38, 0x6f6d6b69, 0x6f6f6f6f, 0x00004209, 0x6a6a6a4e, 0x5c7e5d7e, 0x6e38385d, 0x0000004e, 
    0x00000000, 0x00000000, 0x019e06db, 0x017f06f3, 0x00000196, 0x00000041, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00000000, 0x00000000, 0x00000000, 
    0x685b4e39, 0x6f6f6d6a, 0x6f6f6f6f, 0x00005333, 0x6b6b6b58, 0x5d885f7f, 0x6f39395e, 0x00000058, 
    0x00000000, 0x00000000, 0x01d107b2, 0x01ae07cd, 0x000001c8, 0x00000048, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00000000, 0x00000000, 0x00000000, 
    0x695d4f3a, 0x6f6f6e6c, 0x6f6f6f6f, 0x000068d3, 0x6d6c6c59, 0x5f896889, 0x793a3a68, 0x00000059, 
    0x00000000, 0x00000000, 0x020a08a3, 0x01e308c2, 0x000001ff, 0x00000051, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00000000, 0x00000000, 0x00000000, 
    0x6a5e593b, 0x6f6f6f6d, 0x6f6f6f6f, 0x00008412, 0x6e6e6e5a, 0x688a698a, 0x7a3b3b69, 0x0000005a, 
    0x00000000, 0x00000000, 0x024a09b2, 0x021e09d4, 0x0000023e, 0x0000005b, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00000000, 0x00000000, 0x00000000, 
    0x6b685a3d, 0x6f6f6f6f, 0x6f6f6f6f, 0x0000a666, 0x78786f5b, 0x6a8b6a8b, 0x7b3d3d6a, 0x0000005b, 
    0x00000000, 0x00000000, 0x02910ae2, 0x02610b09, 0x00000284, 0x00000067, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00000000, 0x00000000, 0x00000000, 
    0x6d695b3e, 0x6f6f6f6f, 0x6f6f6f6f, 0x0000d1a7, 0x7979795d, 0x6b8c6c8c, 0x7c3e3e6b, 0x0000005d, 
    0x00000000, 0x00000000, 0x02e20c37, 0x02ac0c62, 0x000002d3, 0x00000073, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00000000, 0x00000000, 0x00000000, 
    0x6e6a5c48, 0x6f6f6f6f, 0x6f6f6f6f, 0x00000825, 0x7a7a7a5e, 0x6c8e6d8e, 0x7e48486d, 0x0000005e, 
    0x00000000, 0x00000000, 0x033c0db6, 0x02ff0de7, 0x0000032c, 0x00000082, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00000000, 0x00000000, 0x00000000, 
    0x6f6b5e49, 0x6f6f6f6f, 0x6f6f6f6f, 0x00004ccd, 0x7b7b7b68, 0x6d8f6f8f, 0x7f49496e, 0x00000068, 
    0x00000000, 0x00000000, 0x03a20f64, 0x035d0f9b, 0x00000390, 0x00000091, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00000000, 0x00000000, 0x00000000, 
    0x6f6d5f4a, 0x6f6f6f6f, 0x6f6f6f6f, 0x0000a34d, 0x7d7c7c69, 0x6f8f788f, 0x894a4a78, 0x00000069, 
    0x00000000, 0x00000000, 0x04141147, 0x03c71184, 0x000003ff, 0x000000a3, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00000000, 0x00000000, 0x00000000, 
    0x6f6e694b, 0x6f6f6f6f, 0x6f6f6f6f, 0x00001049, 0x7e7e7e6a, 0x788f798f, 0x8a4b4b79, 0x0000006a, 
    0x00000000, 0x00000000, 0x04941364, 0x043d13a9, 0x0000047d, 0x000000b7, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00000000, 0x00000000, 0x00000000, 
    0x6f6f6a4d, 0x6f6f6f6f, 0x6f6f6f6f, 0x0000999a, 0x88887f6b, 0x7a8f7a8f, 0x8b4d4d7a, 0x0000006b, 
    0x00000000, 0x00000000, 0x052315c4, 0x04c21612, 0x00000509, 0x000000ce, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00000000, 0x00000000, 0x00000000, 
    0x6f6f6b4e, 0x6f6f6f6f, 0x6f6f6f6f, 0x0000469a, 0x8989896d, 0x7b8f7c8f, 0x8c4e4e7b, 0x0000006d, 
    0x00000000, 0x00000000, 0x05c4186f, 0x055818c5, 0x000005a7, 0x000000e7, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00000000, 0x00000000, 0x00000000, 
    0x6f6f6c58, 0x6f6f6f6f, 0x6f6f6f6f, 0x00002093, 0x8a8a8a6e, 0x7c8f7d8f, 0x8e58587d, 0x0000006e, 
    0x00000000, 0x00000000, 0x06791b6d, 0x05ff1bce, 0x00000659, 0x00000104, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00000000, 0x00000000, 0x00000000, 
    0x6f6f6e59, 0x6f6f6f6f, 0x6f6f6f6f, 0x00003333, 0x8b8b8b78, 0x7d8f7f8f, 0x8f59597e, 0x00000078, 
    0x00000000, 0x00000000, 0x07441ec8, 0x06bb1f36, 0x00000720, 0x00000123, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00000000, 0x00000000, 0x00000000, 
    0x07050301, 0x180e0b09, 0x1c1b1a19, 0x00000005, 0x0a0a0a03, 0x061f061f, 0x0e010106, 0x00000003, 
    0x00000000, 0x00000000, 0x0006001d, 0x0006001d, 0x00000006, 0x00000001, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00000000, 0x00000000, 0x00000000, 
    0x07050301, 0x180e0b09, 0x1c1b1a19, 0x00000005, 0x0a0a0a03, 0x061f061f, 0x0e010106, 0x00000003, 
    0x00000000, 0x00000000, 0x0006001d, 0x0006001d, 0x00000006, 0x00000001, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00000000, 0x00000000, 0x00000000, 
    0x07050301, 0x180e0b09, 0x1c1b1a19, 0x00000005, 0x0a0a0a03, 0x061f061f, 0x0e010106, 0x00000003, 
    0x00000000, 0x00000000, 0x0006001d, 0x0006001d, 0x00000006, 0x00000001, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00000000, 0x00000000, 0x00000000, 
    0x07050301, 0x180e0b09, 0x1c1b1a19, 0x00000005, 0x0a0a0a03, 0x061f061f, 0x0e010106, 0x00000003, 
    0x00000000, 0x00000000, 0x0006001d, 0x0006001d, 0x00000006, 0x00000001, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00000000, 0x00000000, 0x00000000, 
    0x07050301, 0x180e0b09, 0x1c1b1a19, 0x00000005, 0x0a0a0a03, 0x061f061f, 0x0e010106, 0x00000003, 
    0x00000000, 0x00000000, 0x0006001d, 0x0006001d, 0x00000006, 0x00000001, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00000000, 0x00000000, 0x00000000, 
    0x07050301, 0x180e0b09, 0x1c1b1a19, 0x00000005, 0x0a0a0a03, 0x061f061f, 0x0e010106, 0x00000003, 
    0x00000000, 0x00000000, 0x0006001d, 0x0006001d, 0x00000006, 0x00000001, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00000000, 0x00000000, 0x00000000, 
    0x07050301, 0x180e0b09, 0x1c1b1a19, 0x00000005, 0x0a0a0a03, 0x061f061f, 0x0e010106, 0x00000003, 
    0x00000000, 0x00000000, 0x0006001d, 0x0006001d, 0x00000006, 0x00000001, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00000000, 0x00000000, 0x00000000, 
    0x07050301, 0x180e0b09, 0x1c1b1a19, 0x00000005, 0x0a0a0a03, 0x061f061f, 0x0e010106, 0x00000003, 
    0x00000000, 0x00000000, 0x0006001d, 0x0006001d, 0x00000006, 0x00000001, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00000000, 0x00000000, 0x00000000, 
    0x07050301, 0x180e0b09, 0x1c1b1a19, 0x00000005, 0x0a0a0a03, 0x061f061f, 0x0e010106, 0x00000003, 
    0x00000000, 0x00000000, 0x0006001d, 0x0006001d, 0x00000006, 0x00000001, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00000000, 0x00000000, 0x00000000, 
    0x07050301, 0x180e0b09, 0x1c1b1a19, 0x00000005, 0x0a0a0a03, 0x061f061f, 0x0e010106, 0x00000003, 
    0x00000000, 0x00000000, 0x0006001d, 0x0006001d, 0x00000006, 0x00000001, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00000000, 0x00000000, 0x00000000, 
    0x07050301, 0x180e0b09, 0x1c1b1a19, 0x00000005, 0x0a0a0a03, 0x061f061f, 0x0e010106, 0x00000003, 
    0x00000000, 0x00000000, 0x0006001d, 0x0006001d, 0x00000006, 0x00000001, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00000000, 0x00000000, 0x00000000, 
    0x07050301, 0x180e0b09, 0x1c1b1a19, 0x00000005, 0x0a0a0a03, 0x061f061f, 0x0e010106, 0x00000003, 
    0x00000000, 0x00000000, 0x0006001d, 0x0006001d, 0x00000006, 0x00000001, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00000000, 0x00000000, 0x00000000, 
    0x07050301, 0x180e0b09, 0x1c1b1a19, 0x00000005, 0x0a0a0a03, 0x061f061f, 0x0e010106, 0x00000003, 
    0x00000000, 0x00000000, 0x0006001d, 0x0006001d, 0x00000006, 0x00000001, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00000000, 0x00000000, 0x00000000, 
    0x08060301, 0x190f0d0a, 0x1e1d1c1a, 0x00000006, 0x0b0b0b04, 0x07280728, 0x18010107, 0x00000004, 
    0x00000000, 0x00000000, 0x00070020, 0x00070021, 0x00000007, 0x00000001, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00000000, 0x00000000, 0x00000000, 
    0x09060401, 0x1a190e0c, 0x281e1d1c, 0x00000007, 0x0d0d0c04, 0x08290829, 0x19010108, 0x00000004, 
    0x00000000, 0x00000000, 0x00080024, 0x00080025, 0x00000008, 0x00000001, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00000000, 0x00000000, 0x00000000, 
    0x0a070401, 0x1b1a180d, 0x29281f1d, 0x00000009, 0x0f0e0e05, 0x092a092a, 0x1a010109, 0x00000005, 
    0x00000000, 0x00000000, 0x00090029, 0x00090029, 0x00000009, 0x00000001, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00000000, 0x00000000, 0x00000000, 
    0x0c080501, 0x1d1b190f, 0x2a29281f, 0x0000000c, 0x18181806, 0x0a2c0a2c, 0x1c01010a, 0x00000006, 
    0x00000000, 0x00000000, 0x000a002e, 0x000a002f, 0x0000000a, 0x00000001, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00000000, 0x00000000, 0x00000000, 
    0x0d090501, 0x1e1d1b19, 0x2b2a2928, 0x0000000f, 0x19191906, 0x0b2d0c2d, 0x1d01010c, 0x00000006, 
    0x00000000, 0x00000000, 0x000c0034, 0x000b0034, 0x0000000c, 0x00000001, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00000000, 0x00000000, 0x00000000, 
    0x0f0a0602, 0x281e1c1a, 0x2c2b2a29, 0x00000013, 0x1b1b1a07, 0x0c2f0d2f, 0x1f02020d, 0x00000007, 
    0x00000000, 0x00000000, 0x000d003a, 0x000c003b, 0x0000000d, 0x00000002, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00000000, 0x00000000, 0x00000000, 
    0x180c0702, 0x29281d1b, 0x2e2d2c2a, 0x00000018, 0x1c1c1c08, 0x0e380f38, 0x2802020f, 0x00000008, 
    0x00000000, 0x00000000, 0x000f0041, 0x000e0042, 0x0000000f, 0x00000002, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00000000, 0x00000000, 0x00000000, 
    0x1a0d0802, 0x2a291f1c, 0x382e2d2c, 0x0000001e, 0x1d1d1d09, 0x18391939, 0x29020219, 0x00000009, 
    0x00000000, 0x00000000, 0x00110049, 0x0010004a, 0x00000011, 0x00000002, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00000000, 0x00000000, 0x00000000, 
    0x1b0f0903, 0x2b2a281e, 0x39382f2d, 0x00000025, 0x1f1f1f0a, 0x193a1a3a, 0x2a03031a, 0x0000000a, 
    0x00000000, 0x00000000, 0x00130052, 0x00120053, 0x00000013, 0x00000003, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00000000, 0x00000000, 0x00000000, 
    0x1c190a03, 0x2d2b291f, 0x3a39382f, 0x0000002f, 0x2828280c, 0x1a3c1b3c, 0x2c03031b, 0x0000000c, 
    0x00000000, 0x00000000, 0x0015005c, 0x0014005e, 0x00000015, 0x00000003, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00000000, 0x00000000, 0x00000000, 
    0x1d1a0b03, 0x2e2d2b29, 0x3b3a3938, 0x0000003b, 0x2929290d, 0x1b3d1c3d, 0x2d03031c, 0x0000000d, 
    0x00000000, 0x00000000, 0x00180068, 0x00160069, 0x00000018, 0x00000003, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00000000, 0x00000000, 0x00000000, 
    0x1f1b0c04, 0x382e2c2a, 0x3c3b3a39, 0x0000004b, 0x2b2b2a0f, 0x1d3f1e3f, 0x2f04041e, 0x0000000f, 
    0x00000000, 0x00000000, 0x001b0074, 0x00190076, 0x0000001b, 0x00000004, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00000000, 0x00000000, 0x00000000, 
    0x281c0e04, 0x39382d2b, 0x3e3d3c3a, 0x0000005e, 0x2c2c2c18, 0x1e481f48, 0x3804041f, 0x00000018, 
    0x00000000, 0x00000000, 0x001e0083, 0x001c0084, 0x0000001e, 0x00000004, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00000000, 0x00000000, 0x00000000, 
    0x2a1e1805, 0x3a392f2c, 0x483e3d3c, 0x00000077, 0x2d2d2d1a, 0x28492949, 0x39050529, 0x0000001a, 
    0x00000000, 0x00000000, 0x00220093, 0x00200095, 0x00000022, 0x00000005, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00000000, 0x00000000, 0x00000000, 
    0x2b1f1906, 0x3b3a382e, 0x49483f3d, 0x00000096, 0x2f2f2f1b, 0x294a2a4a, 0x3a06062a, 0x0000001b, 
    0x00000000, 0x00000000, 0x002700a5, 0x002400a7, 0x00000026, 0x00000006, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00000000, 0x00000000, 0x00000000, 
    0x2c291a06, 0x3d3b392f, 0x4a49483f, 0x000000bd, 0x3838381c, 0x2a4c2b4c, 0x3c06062b, 0x0000001c, 
    0x00000000, 0x00000000, 0x002b00b9, 0x002800bc, 0x0000002a, 0x00000006, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00000000, 0x00000000, 0x00000000, 
    0x2d2a1c07, 0x3e3d3b39, 0x4b4a4948, 0x000000ee, 0x3939391d, 0x2b4d2c4d, 0x3d07072c, 0x0000001d, 
    0x00000000, 0x00000000, 0x003100d0, 0x002d00d3, 0x00000030, 0x00000007, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00000000, 0x00000000, 0x00000000, 
    0x2f2b1d08, 0x483e3c3a, 0x4c4b4a49, 0x0000012c, 0x3b3b3a1f, 0x2d4f2e4f, 0x3f08082e, 0x0000001f, 
    0x00000000, 0x00000000, 0x003700e9, 0x003300ec, 0x00000036, 0x00000008, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00000000, 0x00000000, 0x00000000, 
    0x382c1f09, 0x49483d3b, 0x4e4d4c4a, 0x00000179, 0x3c3c3c28, 0x2e582f58, 0x4809092f, 0x00000028, 
    0x00000000, 0x00000000, 0x003d0106, 0x00390109, 0x0000003c, 0x00000009, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00000000, 0x00000000, 0x00000000, 
    0x3a2e280a, 0x4a493f3c, 0x584e4d4c, 0x000001db, 0x3d3d3d2a, 0x38593959, 0x490a0a39, 0x0000002a, 
    0x00000000, 0x00000000, 0x00450126, 0x0040012a, 0x00000044, 0x0000000a, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00000000, 0x00000000, 0x00000000, 
    0x3b2f290c, 0x4b4a483e, 0x59584f4d, 0x00000257, 0x3f3f3f2b, 0x395a3a5a, 0x4a0c0c3a, 0x0000002b, 
    0x00000000, 0x00000000, 0x004e014a, 0x0048014f, 0x0000004c, 0x0000000c, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00000000, 0x00000000, 0x00000000, 
    0x3c392a0d, 0x4d4b493f, 0x5a59584f, 0x000002f3, 0x4848482c, 0x3a5c3b5c, 0x4c0d0d3b, 0x0000002c, 
    0x00000000, 0x00000000, 0x00570172, 0x00510178, 0x00000055, 0x0000000d, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00000000, 0x00000000, 0x00000000, 
    0x3d3a2c0f, 0x4e4d4b49, 0x5b5a5958, 0x000003b7, 0x4949492d, 0x3b5d3c5d, 0x4d0f0f3c, 0x0000002d, 
    0x00000000, 0x00000000, 0x006201a0, 0x005b01a6, 0x00000060, 0x0000000f, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00000000, 0x00000000, 0x00000000, 
    0x3f3b2d19, 0x584e4c4a, 0x5c5b5a59, 0x000004ae, 0x4b4b4a2f, 0x3d5f3e5f, 0x4f19193e, 0x0000002f, 
    0x00000000, 0x00000000, 0x006e01d3, 0x006601d9, 0x0000006c, 0x00000011, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00000000, 0x00000000, 0x00000000, 
    0x483c2f1a, 0x59584d4b, 0x5e5d5c5a, 0x000005e5, 0x4c4c4c38, 0x3e683f68, 0x581a1a3f, 0x00000038, 
    0x00000000, 0x00000000, 0x007b020c, 0x00720213, 0x00000079, 0x00000013, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00000000, 0x00000000, 0x00000000, 
    0x4a3e381b, 0x5a594f4c, 0x685e5d5c, 0x0000076e, 0x4d4d4d3a, 0x48694969, 0x591b1b49, 0x0000003a, 
    0x00000000, 0x00000000, 0x008b024c, 0x00800254, 0x00000088, 0x00000015, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00000000, 0x00000000, 0x00000000, 
    0x4b3f391c, 0x5b5a584e, 0x69685f5d, 0x0000095c, 0x4f4f4f3b, 0x496a4a6a, 0x5a1c1c4a, 0x0000003b, 
    0x00000000, 0x00000000, 0x009c0294, 0x0090029e, 0x00000098, 0x00000018, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00000000, 0x00000000, 0x00000000, 
    0x4c493a1e, 0x5d5b594f, 0x6a69685f, 0x00000bcb, 0x5858583c, 0x4a6c4b6c, 0x5c1e1e4b, 0x0000003c, 
    0x00000000, 0x00000000, 0x00af02e5, 0x00a202f0, 0x000000ab, 0x0000001b, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00000000, 0x00000000, 0x00000000, 
    0x4d4a3c1f, 0x5e5d5b59, 0x6b6a6968, 0x00000edc, 0x5959593d, 0x4b6d4c6d, 0x5d1f1f4c, 0x0000003d, 
    0x00000000, 0x00000000, 0x00c40340, 0x00b6034c, 0x000000c0, 0x0000001e, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00000000, 0x00000000, 0x00000000, 
    0x4f4b3d29, 0x685e5c5a, 0x6c6b6a69, 0x000012b8, 0x5b5b5a3f, 0x4d6f4e6f, 0x5f29294e, 0x0000003f, 
    0x00000000, 0x00000000, 0x00dc03a6, 0x00cc03b3, 0x000000d8, 0x00000022, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00000000, 0x00000000, 0x00000000, 
    0x584c3f2a, 0x69685d5b, 0x6e6d6c6a, 0x00001796, 0x5c5c5c48, 0x4e784f78, 0x682a2a4f, 0x00000048, 
    0x00000000, 0x00000000, 0x00f70419, 0x00e50427, 0x000000f2, 0x00000026, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00000000, 0x00000000, 0x00000000, 
    0x5a4e482b, 0x6a695f5c, 0x6f6e6d6c, 0x00001db7, 0x5d5d5d4a, 0x58795979, 0x692b2b59, 0x0000004a, 
    0x00000000, 0x00000000, 0x01160499, 0x010104a9, 0x00000110, 0x0000002b, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00000000, 0x00000000, 0x00000000, 
    0x5b4f492c, 0x6b6a685e, 0x6f6f6f6d, 0x00002571, 0x5f5f5f4b, 0x597a5a7a, 0x6a2c2c5a, 0x0000004b, 
    0x00000000, 0x00000000, 0x01380529, 0x0121053c, 0x00000131, 0x00000030, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00000000, 0x00000000, 0x00000000, 
    0x5c594a2e, 0x6d6b695f, 0x6f6f6f6f, 0x00002f2c, 0x6868684c, 0x5a7c5b7c, 0x6c2e2e5b, 0x0000004c, 
    0x00000000, 0x00000000, 0x015e05cb, 0x014405e0, 0x00000157, 0x00000036, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00000000, 0x00000000, 0x00000000, 
    0x5d5a4c2f, 0x6e6d6b69, 0x6f6f6f6f, 0x00003b6f, 0x6969694d, 0x5b7d5c7d, 0x6d2f2f5c, 0x0000004d, 
    0x00000000, 0x00000000, 0x01890681, 0x016c0698, 0x00000181, 0x0000003d, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00000000, 0x00000000, 0x00000000, 
    0x5f5b4d39, 0x6f6e6c6a, 0x6f6f6f6f, 0x00004ae1, 0x6b6b6a4f, 0x5d7f5e7f, 0x6f39395e, 0x0000004f, 
    0x00000000, 0x00000000, 0x01b9074d, 0x01980767, 0x000001b0, 0x00000045, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00000000, 0x00000000, 0x00000000, 
    0x685c4f3a, 0x6f6f6d6b, 0x6f6f6f6f, 0x00005e58, 0x6c6c6c58, 0x5e885f88, 0x783a3a5f, 0x00000058, 
    0x00000000, 0x00000000, 0x01ef0832, 0x01ca084f, 0x000001e5, 0x0000004d, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00000000, 0x00000000, 0x00000000, 
    0x6a5e583b, 0x6f6f6f6c, 0x6f6f6f6f, 0x000076dd, 0x6d6d6d5a, 0x68896989, 0x793b3b69, 0x0000005a, 
    0x00000000, 0x00000000, 0x022c0932, 0x02030953, 0x00000221, 0x00000057, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00000000, 0x00000000, 0x00000000, 
    0x6b5f593c, 0x6f6f6f6e, 0x6f6f6f6f, 0x000095c3, 0x6f6f6f5b, 0x698a6a8a, 0x7a3c3c6a, 0x0000005b, 
    0x00000000, 0x00000000, 0x02700a53, 0x02420a78, 0x00000263, 0x00000061, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00000000, 0x00000000, 0x00000000, 
    0x6c695a3e, 0x6f6f6f6f, 0x6f6f6f6f, 0x0000bcb0, 0x7878785c, 0x6a8c6b8c, 0x7c3e3e6b, 0x0000005c, 
    0x00000000, 0x00000000, 0x02bc0b97, 0x02880bc0, 0x000002ae, 0x0000006d, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00000000, 0x00000000, 0x00000000, 
    0x6d6a5c3f, 0x6f6f6f6f, 0x6f6f6f6f, 0x0000edbb, 0x7979795d, 0x6b8d6c8d, 0x7d3f3f6c, 0x0000005d, 
    0x00000000, 0x00000000, 0x03120d02, 0x02d80d30, 0x00000302, 0x0000007b, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00000000, 0x00000000, 0x00000000, 
    0x6f6b5d49, 0x6f6f6f6f, 0x6f6f6f6f, 0x00002b85, 0x7b7b7a5f, 0x6d8f6e8f, 0x7f49496e, 0x0000005f, 
    0x00000000, 0x00000000, 0x03720e9a, 0x03310ece, 0x00000361, 0x0000008a, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00000000, 0x00000000, 0x00000000, 
    0x6f6c5f4a, 0x6f6f6f6f, 0x6f6f6f6f, 0x0000795f, 0x7c7c7c68, 0x6e8f6f8f, 0x884a4a6f, 0x00000068, 
    0x00000000, 0x00000000, 0x03de1064, 0x0395109e, 0x000003cb, 0x0000009b, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00000000, 0x00000000, 0x00000000, 
    0x6f6e684b, 0x6f6f6f6f, 0x6f6f6f6f, 0x0000db75, 0x7d7d7d6a, 0x788f798f, 0x894b4b79, 0x0000006a, 
    0x00000000, 0x00000000, 0x04581265, 0x040612a7, 0x00000442, 0x000000ae, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00000000, 0x00000000, 0x00000000, 
    0x6f6f694c, 0x6f6f6f6f, 0x6f6f6f6f, 0x0000570a, 0x7f7f7f6b, 0x798f7a8f, 0x8a4c4c7a, 0x0000006b, 
    0x00000000, 0x00000000, 0x04e014a6, 0x048414f0, 0x000004c7, 0x000000c3, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00000000, 0x00000000, 0x00000000, 
    0x6f6f6a4e, 0x6f6f6f6f, 0x6f6f6f6f, 0x0000f2be, 0x8888886c, 0x7a8f7b8f, 0x8c4e4e7b, 0x0000006c, 
    0x00000000, 0x00000000, 0x0579172e, 0x05111780, 0x0000055d, 0x000000db, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00000000, 0x00000000, 0x00000000, 
    0x6f6f6c4f, 0x6f6f6f6f, 0x6f6f6f6f, 0x0000b6eb, 0x8989896d, 0x7b8f7c8f, 0x8d4f4f7c, 0x0000006d, 
    0x00000000, 0x00000000, 0x06241a04, 0x05b01a61, 0x00000605, 0x000000f6, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00000000, 0x00000000, 0x00000000, 
    0x6f6f6d59, 0x6f6f6f6f, 0x6f6f6f6f, 0x0000ae14, 0x8b8b8a6f, 0x7d8f7e8f, 0x8f59597e, 0x0000006f, 
    0x00000000, 0x00000000, 0x06e51d34, 0x06631d9c, 0x000006c2, 0x00000114, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00000000, 0x00000000, 0x00000000, 
    0x6f6f6f5a, 0x6f6f6f6f, 0x6f6f6f6f, 0x0000e57c, 0x8c8c8c78, 0x7e8f7f8f, 0x8f5a5a7f, 0x00000078, 
    0x00000000, 0x00000000, 0x07bd20c8, 0x072b213c, 0x00000796, 0x00000136, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00000000, 0x00000000, 0x00000000, 
    0x6f6f6f5b, 0x6f6f6f6f, 0x6f6f6f6f, 0x00006dd5, 0x8d8d8d7a, 0x888f898f, 0x8f5b5b89, 0x0000007a, 
    0x00000000, 0x00000000, 0x08b024cb, 0x080c254e, 0x00000884, 0x0000015c, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00000000, 0x00000000, 0x00000000, 
    0x6f6f6f5c, 0x6f6f6f6f, 0x6f6f6f6f, 0x00005c29, 0x8f8f8f7b, 0x898f8a8f, 0x8f5c5c8a, 0x0000007b, 
    0x00000000, 0x00000000, 0x09c0294d, 0x090829e0, 0x0000098f, 0x00000187, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00000000, 0x00000000, 0x00000000, 
    0x0d090501, 0x1f1d1b19, 0x2b2a2928, 0x00000004, 0x09090903, 0x061e061e, 0x0d010106, 0x00000003, 
    0x00000000, 0x00000000, 0x0006001b, 0x0006001b, 0x00000006, 0x00000001, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x37271708, 0x75665646, 0xb4a49585, 0x00000000, 0x00000000, 0x00000000, 
    0x0d090501, 0x1f1d1b19, 0x2b2a2928, 0x00000004, 0x09090903, 0x061e061e, 0x0d010106, 0x00000003, 
    0x00000000, 0x00000000, 0x0006001b, 0x0006001b, 0x00000006, 0x00000001, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x37271708, 0x75665646, 0xb4a49585, 0x00000000, 0x00000000, 0x00000000, 
    0x0d090501, 0x1f1d1b19, 0x2b2a2928, 0x00000004, 0x09090903, 0x061e061e, 0x0d010106, 0x00000003, 
    0x00000000, 0x00000000, 0x0006001b, 0x0006001b, 0x00000006, 0x00000001, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x37271708, 0x75665646, 0xb4a49585, 0x00000000, 0x00000000, 0x00000000, 
    0x0d090501, 0x1f1d1b19, 0x2b2a2928, 0x00000004, 0x09090903, 0x061e061e, 0x0d010106, 0x00000003, 
    0x00000000, 0x00000000, 0x0006001b, 0x0006001b, 0x00000006, 0x00000001, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x37271708, 0x75665646, 0xb4a49585, 0x00000000, 0x00000000, 0x00000000, 
    0x0d090501, 0x1f1d1b19, 0x2b2a2928, 0x00000004, 0x09090903, 0x061e061e, 0x0d010106, 0x00000003, 
    0x00000000, 0x00000000, 0x0006001b, 0x0006001b, 0x00000006, 0x00000001, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x37271708, 0x75665646, 0xb4a49585, 0x00000000, 0x00000000, 0x00000000, 
    0x0d090501, 0x1f1d1b19, 0x2b2a2928, 0x00000004, 0x09090903, 0x061e061e, 0x0d010106, 0x00000003, 
    0x00000000, 0x00000000, 0x0006001b, 0x0006001b, 0x00000006, 0x00000001, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x37271708, 0x75665646, 0xb4a49585, 0x00000000, 0x00000000, 0x00000000, 
    0x0d090501, 0x1f1d1b19, 0x2b2a2928, 0x00000004, 0x09090903, 0x061e061e, 0x0d010106, 0x00000003, 
    0x00000000, 0x00000000, 0x0006001b, 0x0006001b, 0x00000006, 0x00000001, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x37271708, 0x75665646, 0xb4a49585, 0x00000000, 0x00000000, 0x00000000, 
    0x0d090501, 0x1f1d1b19, 0x2b2a2928, 0x00000004, 0x09090903, 0x061e061e, 0x0d010106, 0x00000003, 
    0x00000000, 0x00000000, 0x0006001b, 0x0006001b, 0x00000006, 0x00000001, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x37271708, 0x75665646, 0xb4a49585, 0x00000000, 0x00000000, 0x00000000, 
    0x0d090501, 0x1f1d1b19, 0x2b2a2928, 0x00000004, 0x09090903, 0x061e061e, 0x0d010106, 0x00000003, 
    0x00000000, 0x00000000, 0x0006001b, 0x0006001b, 0x00000006, 0x00000001, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x37271708, 0x75665646, 0xb4a49585, 0x00000000, 0x00000000, 0x00000000, 
    0x0d090501, 0x1f1d1b19, 0x2b2a2928, 0x00000004, 0x09090903, 0x061e061e, 0x0d010106, 0x00000003, 
    0x00000000, 0x00000000, 0x0006001b, 0x0006001b, 0x00000006, 0x00000001, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x37271708, 0x75665646, 0xb4a49585, 0x00000000, 0x00000000, 0x00000000, 
    0x0d090501, 0x1f1d1b19, 0x2b2a2928, 0x00000004, 0x09090903, 0x061e061e, 0x0d010106, 0x00000003, 
    0x00000000, 0x00000000, 0x0006001b, 0x0006001b, 0x00000006, 0x00000001, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x37271708, 0x75665646, 0xb4a49585, 0x00000000, 0x00000000, 0x00000000, 
    0x0d090501, 0x1f1d1b19, 0x2b2a2928, 0x00000004, 0x09090903, 0x061e061e, 0x0d010106, 0x00000003, 
    0x00000000, 0x00000000, 0x0006001b, 0x0006001b, 0x00000006, 0x00000001, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x37271708, 0x75665646, 0xb4a49585, 0x00000000, 0x00000000, 0x00000000, 
    0x0d090501, 0x1f1d1b19, 0x2b2a2928, 0x00000004, 0x09090903, 0x061e061e, 0x0d010106, 0x00000003, 
    0x00000000, 0x00000000, 0x0006001b, 0x0006001b, 0x00000006, 0x00000001, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x37271708, 0x75665646, 0xb4a49585, 0x00000000, 0x00000000, 0x00000000, 
    0x0f0b0602, 0x281f1c1a, 0x2d2c2b29, 0x00000005, 0x0b0b0a03, 0x0628071f, 0x0f010107, 0x00000003, 
    0x00000000, 0x00000000, 0x0007001e, 0x0006001f, 0x00000007, 0x00000001, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x37271708, 0x75665646, 0xb4a49585, 0x00000000, 0x00000000, 0x00000000, 
    0x190c0702, 0x29281e1b, 0x2e2d2c2b, 0x00000007, 0x0c0c0c04, 0x07290829, 0x19010108, 0x00000004, 
    0x00000000, 0x00000000, 0x00080022, 0x00070023, 0x00000008, 0x00000001, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x37271708, 0x75665646, 0xb4a49585, 0x00000000, 0x00000000, 0x00000000, 
    0x1a0e0802, 0x2b291f1d, 0x382f2d2c, 0x00000008, 0x0e0e0d05, 0x082a092a, 0x1a010108, 0x00000005, 
    0x00000000, 0x00000000, 0x00090026, 0x00080027, 0x00000008, 0x00000001, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x37271708, 0x75665646, 0xb4a49585, 0x00000000, 0x00000000, 0x00000000, 
    0x1b0f0903, 0x2c2a291e, 0x39382f2d, 0x0000000a, 0x0f0f0f05, 0x092b0a2b, 0x1b01010a, 0x00000005, 
    0x00000000, 0x00000000, 0x000a002b, 0x0009002c, 0x0000000a, 0x00000001, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x37271708, 0x75665646, 0xb4a49585, 0x00000000, 0x00000000, 0x00000000, 
    0x1c190a03, 0x2d2c2a28, 0x3a39382f, 0x0000000d, 0x19191906, 0x0a2c0b2c, 0x1c01010b, 0x00000006, 
    0x00000000, 0x00000000, 0x000b0030, 0x000a0031, 0x0000000b, 0x00000001, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x37271708, 0x75665646, 0xb4a49585, 0x00000000, 0x00000000, 0x00000000, 
    0x1e1a0b03, 0x2f2d2b29, 0x3b3a3938, 0x00000011, 0x1a1a1a07, 0x0c2e0c2e, 0x1e02020c, 0x00000007, 
    0x00000000, 0x00000000, 0x000c0036, 0x000c0037, 0x0000000c, 0x00000002, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x37271708, 0x75665646, 0xb4a49585, 0x00000000, 0x00000000, 0x00000000, 
    0x281b0d04, 0x382f2c2a, 0x3d3c3b39, 0x00000015, 0x1b1b1b07, 0x0d380e2f, 0x1f02020e, 0x00000007, 
    0x00000000, 0x00000000, 0x000e003d, 0x000d003e, 0x0000000e, 0x00000002, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x37271708, 0x75665646, 0xb4a49585, 0x00000000, 0x00000000, 0x00000000, 
    0x291d0f05, 0x39382e2b, 0x3e3d3c3b, 0x0000001a, 0x1d1c1c08, 0x0f391839, 0x29020218, 0x00000008, 
    0x00000000, 0x00000000, 0x00100045, 0x000f0046, 0x00000010, 0x00000002, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x37271708, 0x75665646, 0xb4a49585, 0x00000000, 0x00000000, 0x00000000, 
    0x2a1e1805, 0x3b392f2d, 0x483f3d3c, 0x00000021, 0x1e1e1e0a, 0x183a193a, 0x2a020219, 0x0000000a, 
    0x00000000, 0x00000000, 0x0012004d, 0x0010004e, 0x00000011, 0x00000002, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x37271708, 0x75665646, 0xb4a49585, 0x00000000, 0x00000000, 0x00000000, 
    0x2b281906, 0x3c3a392e, 0x49483f3d, 0x0000002a, 0x28281f0b, 0x1a3b1a3b, 0x2b03031a, 0x0000000b, 
    0x00000000, 0x00000000, 0x00140057, 0x00130058, 0x00000014, 0x00000003, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x37271708, 0x75665646, 0xb4a49585, 0x00000000, 0x00000000, 0x00000000, 
    0x2c291b07, 0x3d3c3a38, 0x4a49483f, 0x00000035, 0x2929290c, 0x1b3c1c3c, 0x2c03031b, 0x0000000c, 
    0x00000000, 0x00000000, 0x00170061, 0x00150063, 0x00000016, 0x00000003, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x37271708, 0x75665646, 0xb4a49585, 0x00000000, 0x00000000, 0x00000000, 
    0x2e2a1c07, 0x3f3d3b39, 0x4b4a4948, 0x00000042, 0x2a2a2a0e, 0x1c3e1d3e, 0x2e04041d, 0x0000000e, 
    0x00000000, 0x00000000, 0x0019006d, 0x0018006f, 0x00000019, 0x00000004, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x37271708, 0x75665646, 0xb4a49585, 0x00000000, 0x00000000, 0x00000000, 
    0x382b1d08, 0x483f3c3a, 0x4d4c4b49, 0x00000053, 0x2b2b2b0f, 0x1d481f3f, 0x2f04041e, 0x0000000f, 
    0x00000000, 0x00000000, 0x001d007b, 0x001a007c, 0x0000001c, 0x00000004, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x37271708, 0x75665646, 0xb4a49585, 0x00000000, 0x00000000, 0x00000000, 
    0x392d1f0a, 0x49483e3b, 0x4e4d4c4b, 0x00000069, 0x2d2c2c19, 0x1f492849, 0x39050528, 0x00000019, 
    0x00000000, 0x00000000, 0x0020008a, 0x001e008c, 0x00000020, 0x00000005, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x37271708, 0x75665646, 0xb4a49585, 0x00000000, 0x00000000, 0x00000000, 
    0x3a2e280b, 0x4b493f3d, 0x584f4d4c, 0x00000084, 0x2e2e2e1a, 0x284a294a, 0x3a050529, 0x0000001a, 
    0x00000000, 0x00000000, 0x0024009b, 0x0021009d, 0x00000023, 0x00000005, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x37271708, 0x75665646, 0xb4a49585, 0x00000000, 0x00000000, 0x00000000, 
    0x3b38290c, 0x4c4a493e, 0x59584f4d, 0x000000a7, 0x38382f1b, 0x2a4b2a4b, 0x3b06062a, 0x0000001b, 
    0x00000000, 0x00000000, 0x002900ae, 0x002600b0, 0x00000028, 0x00000006, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x37271708, 0x75665646, 0xb4a49585, 0x00000000, 0x00000000, 0x00000000, 
    0x3c392b0e, 0x4d4c4a48, 0x5a59584f, 0x000000d2, 0x3939391d, 0x2b4c2c4c, 0x3c07072b, 0x0000001d, 
    0x00000000, 0x00000000, 0x002e00c3, 0x002a00c6, 0x0000002d, 0x00000007, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x37271708, 0x75665646, 0xb4a49585, 0x00000000, 0x00000000, 0x00000000, 
    0x3e3a2c0f, 0x4f4d4b49, 0x5b5a5958, 0x00000109, 0x3a3a3a1e, 0x2c4e2d4e, 0x3e08082d, 0x0000001e, 
    0x00000000, 0x00000000, 0x003300db, 0x003000de, 0x00000032, 0x00000008, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x37271708, 0x75665646, 0xb4a49585, 0x00000000, 0x00000000, 0x00000000, 
    0x483b2d19, 0x584f4c4a, 0x5d5c5b59, 0x0000014e, 0x3b3b3b28, 0x2d582f4f, 0x3f09092e, 0x00000028, 
    0x00000000, 0x00000000, 0x003a00f6, 0x003500f9, 0x00000039, 0x00000009, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x37271708, 0x75665646, 0xb4a49585, 0x00000000, 0x00000000, 0x00000000, 
    0x493d2f1a, 0x59584e4b, 0x5e5d5c5b, 0x000001a4, 0x3d3c3c29, 0x2f593859, 0x490a0a38, 0x00000029, 
    0x00000000, 0x00000000, 0x00410114, 0x003c0118, 0x00000040, 0x0000000a, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x37271708, 0x75665646, 0xb4a49585, 0x00000000, 0x00000000, 0x00000000, 
    0x4a3e381b, 0x5b594f4d, 0x685f5d5c, 0x00000212, 0x3e3e3e2a, 0x385a395a, 0x4a0b0b39, 0x0000002a, 
    0x00000000, 0x00000000, 0x00490136, 0x0043013a, 0x00000047, 0x0000000b, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x37271708, 0x75665646, 0xb4a49585, 0x00000000, 0x00000000, 0x00000000, 
    0x4b48391d, 0x5c5a594e, 0x69685f5d, 0x0000029b, 0x48483f2b, 0x3a5b3a5b, 0x4b0c0c3a, 0x0000002b, 
    0x00000000, 0x00000000, 0x0052015c, 0x004c0161, 0x00000050, 0x0000000c, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x37271708, 0x75665646, 0xb4a49585, 0x00000000, 0x00000000, 0x00000000, 
    0x4c493b1e, 0x5d5c5a58, 0x6a69685f, 0x00000349, 0x4949492d, 0x3b5c3c5c, 0x4c0e0e3b, 0x0000002d, 
    0x00000000, 0x00000000, 0x005c0187, 0x0055018c, 0x0000005a, 0x0000000e, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x37271708, 0x75665646, 0xb4a49585, 0x00000000, 0x00000000, 0x00000000, 
    0x4e4a3c28, 0x5f5d5b59, 0x6b6a6968, 0x00000423, 0x4a4a4a2e, 0x3c5e3d5e, 0x4e18183d, 0x0000002e, 
    0x00000000, 0x00000000, 0x006701b7, 0x006001bd, 0x00000065, 0x00000010, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x37271708, 0x75665646, 0xb4a49585, 0x00000000, 0x00000000, 0x00000000, 
    0x584b3d29, 0x685f5c5a, 0x6d6c6b69, 0x00000536, 0x4b4b4b38, 0x3d683f5f, 0x4f19193e, 0x00000038, 
    0x00000000, 0x00000000, 0x007401ed, 0x006b01f3, 0x00000072, 0x00000012, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x37271708, 0x75665646, 0xb4a49585, 0x00000000, 0x00000000, 0x00000000, 
    0x594d3f2a, 0x69685e5b, 0x6e6d6c6b, 0x00000691, 0x4d4c4c39, 0x3f694869, 0x591a1a48, 0x00000039, 
    0x00000000, 0x00000000, 0x00820229, 0x00790231, 0x00000080, 0x00000014, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x37271708, 0x75665646, 0xb4a49585, 0x00000000, 0x00000000, 0x00000000, 
    0x5a4e482b, 0x6b695f5d, 0x6f6f6d6c, 0x00000846, 0x4e4e4e3a, 0x486a496a, 0x5a1c1c49, 0x0000003a, 
    0x00000000, 0x00000000, 0x0092026d, 0x00870275, 0x0000008f, 0x00000017, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x37271708, 0x75665646, 0xb4a49585, 0x00000000, 0x00000000, 0x00000000, 
    0x5b58492d, 0x6c6a695e, 0x6f6f6f6d, 0x00000a6d, 0x58584f3b, 0x4a6b4a6b, 0x5b1d1d4a, 0x0000003b, 
    0x00000000, 0x00000000, 0x00a402b9, 0x009802c3, 0x000000a1, 0x00000019, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x37271708, 0x75665646, 0xb4a49585, 0x00000000, 0x00000000, 0x00000000, 
    0x5c594b2e, 0x6d6c6a68, 0x6f6f6f6f, 0x00000d22, 0x5959593d, 0x4b6c4c6c, 0x5c1e1e4b, 0x0000003d, 
    0x00000000, 0x00000000, 0x00b8030e, 0x00ab0319, 0x000000b5, 0x0000001c, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x37271708, 0x75665646, 0xb4a49585, 0x00000000, 0x00000000, 0x00000000, 
    0x5e5a4c38, 0x6f6d6b69, 0x6f6f6f6f, 0x0000108c, 0x5a5a5a3e, 0x4c6e4d6e, 0x5e28284d, 0x0000003e, 
    0x00000000, 0x00000000, 0x00cf036e, 0x00c0037a, 0x000000cb, 0x00000020, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x37271708, 0x75665646, 0xb4a49585, 0x00000000, 0x00000000, 0x00000000, 
    0x685b4d39, 0x6f6f6c6a, 0x6f6f6f6f, 0x000014da, 0x5b5b5b48, 0x4d784f6f, 0x5f29294e, 0x00000048, 
    0x00000000, 0x00000000, 0x00e803da, 0x00d703e7, 0x000000e4, 0x00000024, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x37271708, 0x75665646, 0xb4a49585, 0x00000000, 0x00000000, 0x00000000, 
    0x695d4f3a, 0x6f6f6e6b, 0x6f6f6f6f, 0x00001a45, 0x5d5c5c49, 0x4f795879, 0x692a2a58, 0x00000049, 
    0x00000000, 0x00000000, 0x01050453, 0x00f20462, 0x00000100, 0x00000029, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x37271708, 0x75665646, 0xb4a49585, 0x00000000, 0x00000000, 0x00000000, 
    0x6a5e583b, 0x6f6f6f6d, 0x6f6f6f6f, 0x00002119, 0x5e5e5e4a, 0x587a597a, 0x6a2c2c59, 0x0000004a, 
    0x00000000, 0x00000000, 0x012504da, 0x010f04eb, 0x0000011f, 0x0000002e, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x37271708, 0x75665646, 0xb4a49585, 0x00000000, 0x00000000, 0x00000000, 
    0x6b68593d, 0x6f6f6f6e, 0x6f6f6f6f, 0x000029b3, 0x68685f4b, 0x5a7b5a7b, 0x6b2d2d5a, 0x0000004b, 
    0x00000000, 0x00000000, 0x01490572, 0x01310586, 0x00000142, 0x00000033, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x37271708, 0x75665646, 0xb4a49585, 0x00000000, 0x00000000, 0x00000000, 
    0x6c695b3e, 0x6f6f6f6f, 0x6f6f6f6f, 0x0000348a, 0x6969694d, 0x5b7c5c7c, 0x6c2e2e5b, 0x0000004d, 
    0x00000000, 0x00000000, 0x0171061d, 0x01560633, 0x0000016a, 0x00000039, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x37271708, 0x75665646, 0xb4a49585, 0x00000000, 0x00000000, 0x00000000, 
    0x6e6a5c48, 0x6f6f6f6f, 0x6f6f6f6f, 0x00004232, 0x6a6a6a4e, 0x5c7e5d7e, 0x6e38385d, 0x0000004e, 
    0x00000000, 0x00000000, 0x019e06dd, 0x018006f5, 0x00000196, 0x00000041, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x37271708, 0x75665646, 0xb4a49585, 0x00000000, 0x00000000, 0x00000000, 
    0x6f6b5d49, 0x6f6f6f6f, 0x6f6f6f6f, 0x00005366, 0x6b6b6b58, 0x5d885f7f, 0x6f39395e, 0x00000058, 
    0x00000000, 0x00000000, 0x01d107b4, 0x01af07cf, 0x000001c8, 0x00000049, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x37271708, 0x75665646, 0xb4a49585, 0x00000000, 0x00000000, 0x00000000, 
    0x6f6d5f4a, 0x6f6f6f6f, 0x6f6f6f6f, 0x00006914, 0x6d6c6c59, 0x5f896889, 0x793a3a68, 0x00000059, 
    0x00000000, 0x00000000, 0x020a08a6, 0x01e408c4, 0x00000200, 0x00000052, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x37271708, 0x75665646, 0xb4a49585, 0x00000000, 0x00000000, 0x00000000, 
    0x6f6e684b, 0x6f6f6f6f, 0x6f6f6f6f, 0x00008463, 0x6e6e6e5a, 0x688a698a, 0x7a3c3c69, 0x0000005a, 
    0x00000000, 0x00000000, 0x024a09b5, 0x021f09d7, 0x0000023f, 0x0000005c, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x37271708, 0x75665646, 0xb4a49585, 0x00000000, 0x00000000, 0x00000000, 
    0x6f6f694d, 0x6f6f6f6f, 0x6f6f6f6f, 0x0000a6cc, 0x78786f5b, 0x6a8b6a8b, 0x7b3d3d6a, 0x0000005b, 
    0x00000000, 0x00000000, 0x02920ae5, 0x02620b0c, 0x00000285, 0x00000067, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x37271708, 0x75665646, 0xb4a49585, 0x00000000, 0x00000000, 0x00000000, 
    0x6f6f6b4e, 0x6f6f6f6f, 0x6f6f6f6f, 0x0000d227, 0x7979795d, 0x6b8c6c8c, 0x7c3e3e6b, 0x0000005d, 
    0x00000000, 0x00000000, 0x02e30c3b, 0x02ac0c66, 0x000002d4, 0x00000073, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x37271708, 0x75665646, 0xb4a49585, 0x00000000, 0x00000000, 0x00000000, 
    0x6f6f6c58, 0x6f6f6f6f, 0x6f6f6f6f, 0x000008c7, 0x7a7a7a5e, 0x6c8e6d8e, 0x7e48486d, 0x0000005e, 
    0x00000000, 0x00000000, 0x033d0dba, 0x03000deb, 0x0000032d, 0x00000082, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x37271708, 0x75665646, 0xb4a49585, 0x00000000, 0x00000000, 0x00000000, 
    0x6f6f6d59, 0x6f6f6f6f, 0x6f6f6f6f, 0x00004d99, 0x7b7b7b68, 0x6d8f6f8f, 0x7f49496e, 0x00000068, 
    0x00000000, 0x00000000, 0x03a30f69, 0x035e0f9f, 0x00000391, 0x00000092, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x37271708, 0x75665646, 0xb4a49585, 0x00000000, 0x00000000, 0x00000000, 
    0x6f6f6f5a, 0x6f6f6f6f, 0x6f6f6f6f, 0x0000a44e, 0x7d7c7c69, 0x6f8f788f, 0x894a4a78, 0x00000069, 
    0x00000000, 0x00000000, 0x0415114c, 0x03c81189, 0x00000401, 0x000000a4, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x37271708, 0x75665646, 0xb4a49585, 0x00000000, 0x00000000, 0x00000000, 
    0x6f6f6f5b, 0x6f6f6f6f, 0x6f6f6f6f, 0x0000118d, 0x7e7e7e6a, 0x788f798f, 0x8a4c4c79, 0x0000006a, 
    0x00000000, 0x00000000, 0x0495136a, 0x043f13af, 0x0000047e, 0x000000b8, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x37271708, 0x75665646, 0xb4a49585, 0x00000000, 0x00000000, 0x00000000, 
    0x6f6f6f5d, 0x6f6f6f6f, 0x6f6f6f6f, 0x00009b31, 0x88887f6b, 0x7a8f7a8f, 0x8b4d4d7a, 0x0000006b, 
    0x00000000, 0x00000000, 0x052515cb, 0x04c41618, 0x0000050b, 0x000000ce, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x37271708, 0x75665646, 0xb4a49585, 0x00000000, 0x00000000, 0x00000000, 
    0x6f6f6f5e, 0x6f6f6f6f, 0x6f6f6f6f, 0x0000489c, 0x8989896d, 0x7b8f7c8f, 0x8c4e4e7b, 0x0000006d, 
    0x00000000, 0x00000000, 0x05c61876, 0x055918cd, 0x000005a9, 0x000000e7, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x37271708, 0x75665646, 0xb4a49585, 0x00000000, 0x00000000, 0x00000000, 
    0x6f6f6f68, 0x6f6f6f6f, 0x6f6f6f6f, 0x0000231a, 0x8a8a8a6e, 0x7c8f7d8f, 0x8e58587d, 0x0000006e, 
    0x00000000, 0x00000000, 0x067b1b75, 0x06011bd7, 0x0000065b, 0x00000104, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x37271708, 0x75665646, 0xb4a49585, 0x00000000, 0x00000000, 0x00000000, 
    0x6f6f6f69, 0x6f6f6f6f, 0x6f6f6f6f, 0x00003663, 0x8b8b8b78, 0x7d8f7f8f, 0x8f59597e, 0x00000078, 
    0x00000000, 0x00000000, 0x07461ed2, 0x06bd1f3f, 0x00000722, 0x00000124, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x37271708, 0x75665646, 0xb4a49585, 0x00000000, 0x00000000, 0x00000000, 
    0x6f6f6f6a, 0x6f6f6f6f, 0x6f6f6f6f, 0x00009139, 0x8d8c8c79, 0x7f8f888f, 0x8f5a5a88, 0x00000079, 
    0x00000000, 0x00000000, 0x082b2298, 0x07902313, 0x00000802, 0x00000148, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x37271708, 0x75665646, 0xb4a49585, 0x00000000, 0x00000000, 0x00000000, 
    0x6f6f6f6b, 0x6f6f6f6f, 0x6f6f6f6f, 0x00004635, 0x8e8e8e7a, 0x888f898f, 0x8f5c5c89, 0x0000007a, 
    0x00000000, 0x00000000, 0x092b26d5, 0x087e275f, 0x000008fd, 0x00000170, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x37271708, 0x75665646, 0xb4a49585, 0x00000000, 0x00000000, 0x00000000, 
    0x03020100, 0x07060504, 0x0a090908, 0x00000003, 0x08080702, 0x041b051b, 0x0b000005, 0x00000002, 
    0x00000000, 0x00000000, 0x00050016, 0x00040016, 0x00000005, 0x00000000, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x100b0702, 0x221e1915, 0x35302c27, 0x00000000, 0x00000000, 0x00000000, 
    0x03020100, 0x07060504, 0x0a090908, 0x00000003, 0x08080702, 0x041b051b, 0x0b000005, 0x00000002, 
    0x00000000, 0x00000000, 0x00050016, 0x00040016, 0x00000005, 0x00000000, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x100b0702, 0x221e1915, 0x35302c27, 0x00000000, 0x00000000, 0x00000000, 
    0x03020100, 0x07060504, 0x0a090908, 0x00000003, 0x08080702, 0x041b051b, 0x0b000005, 0x00000002, 
    0x00000000, 0x00000000, 0x00050016, 0x00040016, 0x00000005, 0x00000000, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x100b0702, 0x221e1915, 0x35302c27, 0x00000000, 0x00000000, 0x00000000, 
    0x03020100, 0x07060504, 0x0a090908, 0x00000003, 0x08080702, 0x041b051b, 0x0b000005, 0x00000002, 
    0x00000000, 0x00000000, 0x00050016, 0x00040016, 0x00000005, 0x00000000, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x100b0702, 0x221e1915, 0x35302c27, 0x00000000, 0x00000000, 0x00000000, 
    0x03020100, 0x07060504, 0x0a090908, 0x00000003, 0x08080702, 0x041b051b, 0x0b000005, 0x00000002, 
    0x00000000, 0x00000000, 0x00050016, 0x00040016, 0x00000005, 0x00000000, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x100b0702, 0x221e1915, 0x35302c27, 0x00000000, 0x00000000, 0x00000000, 
    0x03020100, 0x07060504, 0x0a090908, 0x00000003, 0x08080702, 0x041b051b, 0x0b000005, 0x00000002, 
    0x00000000, 0x00000000, 0x00050016, 0x00040016, 0x00000005, 0x00000000, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x100b0702, 0x221e1915, 0x35302c27, 0x00000000, 0x00000000, 0x00000000, 
    0x03020100, 0x07060504, 0x0a090908, 0x00000003, 0x08080702, 0x041b051b, 0x0b000005, 0x00000002, 
    0x00000000, 0x00000000, 0x00050016, 0x00040016, 0x00000005, 0x00000000, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x100b0702, 0x221e1915, 0x35302c27, 0x00000000, 0x00000000, 0x00000000, 
    0x03020100, 0x07060504, 0x0a090908, 0x00000003, 0x08080702, 0x041b051b, 0x0b000005, 0x00000002, 
    0x00000000, 0x00000000, 0x00050016, 0x00040016, 0x00000005, 0x00000000, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x100b0702, 0x221e1915, 0x35302c27, 0x00000000, 0x00000000, 0x00000000, 
    0x03020100, 0x07060504, 0x0a090908, 0x00000003, 0x08080702, 0x041b051b, 0x0b000005, 0x00000002, 
    0x00000000, 0x00000000, 0x00050016, 0x00040016, 0x00000005, 0x00000000, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x100b0702, 0x221e1915, 0x35302c27, 0x00000000, 0x00000000, 0x00000000, 
    0x03020100, 0x07060504, 0x0a090908, 0x00000003, 0x08080702, 0x041b051b, 0x0b000005, 0x00000002, 
    0x00000000, 0x00000000, 0x00050016, 0x00040016, 0x00000005, 0x00000000, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x100b0702, 0x221e1915, 0x35302c27, 0x00000000, 0x00000000, 0x00000000, 
    0x03020100, 0x07060504, 0x0a090908, 0x00000003, 0x08080702, 0x041b051b, 0x0b000005, 0x00000002, 
    0x00000000, 0x00000000, 0x00050016, 0x00040016, 0x00000005, 0x00000000, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x100b0702, 0x221e1915, 0x35302c27, 0x00000000, 0x00000000, 0x00000000, 
    0x03020100, 0x07060504, 0x0a090908, 0x00000003, 0x08080702, 0x041b051b, 0x0b000005, 0x00000002, 
    0x00000000, 0x00000000, 0x00050016, 0x00040016, 0x00000005, 0x00000000, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x100b0702, 0x221e1915, 0x35302c27, 0x00000000, 0x00000000, 0x00000000, 
    0x03020100, 0x07060504, 0x0a090908, 0x00000003, 0x08080702, 0x041b051b, 0x0b000005, 0x00000002, 
    0x00000000, 0x00000000, 0x00050016, 0x00040016, 0x00000005, 0x00000000, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x100b0702, 0x221e1915, 0x35302c27, 0x00000000, 0x00000000, 0x00000000, 
    0x03020100, 0x08060504, 0x0c0b0a09, 0x00000003, 0x09090803, 0x051d051d, 0x0c000005, 0x00000003, 
    0x00000000, 0x00000000, 0x00050019, 0x00050019, 0x00000005, 0x00000000, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x100b0702, 0x221e1915, 0x35302c27, 0x00000000, 0x00000000, 0x00000000, 
    0x04020100, 0x08070605, 0x0d0c0b0a, 0x00000004, 0x0a0a0903, 0x061e061e, 0x0e010106, 0x00000003, 
    0x00000000, 0x00000000, 0x0006001c, 0x0006001c, 0x00000006, 0x00000001, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x100b0702, 0x221e1915, 0x35302c27, 0x00000000, 0x00000000, 0x00000000, 
    0x04030200, 0x0a080706, 0x0f0e0c0b, 0x00000005, 0x0b0b0b04, 0x06280728, 0x0f010107, 0x00000004, 
    0x00000000, 0x00000000, 0x0007001f, 0x00060020, 0x00000007, 0x00000001, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x100b0702, 0x221e1915, 0x35302c27, 0x00000000, 0x00000000, 0x00000000, 
    0x05030200, 0x0b090806, 0x190f0e0c, 0x00000007, 0x0c0c0c04, 0x07290829, 0x19010108, 0x00000004, 
    0x00000000, 0x00000000, 0x00080023, 0x00070023, 0x00000008, 0x00000001, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x100b0702, 0x221e1915, 0x35302c27, 0x00000000, 0x00000000, 0x00000000, 
    0x05040200, 0x0c0b0907, 0x1a19180e, 0x00000009, 0x0e0e0e05, 0x082a092a, 0x1a010109, 0x00000005, 
    0x00000000, 0x00000000, 0x00090027, 0x00080028, 0x00000009, 0x00000001, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x100b0702, 0x221e1915, 0x35302c27, 0x00000000, 0x00000000, 0x00000000, 
    0x06040200, 0x0e0c0a08, 0x1b1a1918, 0x0000000b, 0x18180f05, 0x092b0a2b, 0x1b01010a, 0x00000005, 
    0x00000000, 0x00000000, 0x000a002c, 0x0009002d, 0x0000000a, 0x00000001, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x100b0702, 0x221e1915, 0x35302c27, 0x00000000, 0x00000000, 0x00000000, 
    0x07050301, 0x180d0b09, 0x1c1b1a19, 0x0000000e, 0x19191906, 0x0a2d0b2d, 0x1d01010b, 0x00000006, 
    0x00000000, 0x00000000, 0x000b0032, 0x000a0032, 0x0000000b, 0x00000001, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x100b0702, 0x221e1915, 0x35302c27, 0x00000000, 0x00000000, 0x00000000, 
    0x08050301, 0x190f0d0a, 0x1e1d1b1a, 0x00000011, 0x1a1a1a07, 0x0c2e0d2e, 0x1e02020d, 0x00000007, 
    0x00000000, 0x00000000, 0x000d0038, 0x000c0039, 0x0000000d, 0x00000002, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x100b0702, 0x221e1915, 0x35302c27, 0x00000000, 0x00000000, 0x00000000, 
    0x09060401, 0x1a190e0c, 0x1f1e1d1b, 0x00000016, 0x1b1b1b08, 0x0d380e38, 0x2802020e, 0x00000008, 
    0x00000000, 0x00000000, 0x000e003f, 0x000d0040, 0x0000000e, 0x00000002, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x100b0702, 0x221e1915, 0x35302c27, 0x00000000, 0x00000000, 0x00000000, 
    0x0a070401, 0x1b1a180d, 0x29281e1d, 0x0000001c, 0x1d1d1c09, 0x0f391839, 0x29020218, 0x00000009, 
    0x00000000, 0x00000000, 0x00100046, 0x000f0047, 0x00000010, 0x00000002, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x100b0702, 0x221e1915, 0x35302c27, 0x00000000, 0x00000000, 0x00000000, 
    0x0b080501, 0x1d1b190f, 0x2a29281e, 0x00000023, 0x1e1e1e0a, 0x193a193a, 0x2a020219, 0x0000000a, 
    0x00000000, 0x00000000, 0x0012004f, 0x00110050, 0x00000012, 0x00000002, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x100b0702, 0x221e1915, 0x35302c27, 0x00000000, 0x00000000, 0x00000000, 
    0x0d090501, 0x1e1c1a19, 0x2b2a2928, 0x0000002c, 0x2828280b, 0x1a3b1b3b, 0x2b03031a, 0x0000000b, 
    0x00000000, 0x00000000, 0x00150059, 0x0013005a, 0x00000014, 0x00000003, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x100b0702, 0x221e1915, 0x35302c27, 0x00000000, 0x00000000, 0x00000000, 
    0x0e0a0602, 0x281e1c1a, 0x2c2b2a29, 0x00000037, 0x2929290d, 0x1b3d1c3d, 0x2d03031c, 0x0000000d, 
    0x00000000, 0x00000000, 0x00170064, 0x00150065, 0x00000017, 0x00000003, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x100b0702, 0x221e1915, 0x35302c27, 0x00000000, 0x00000000, 0x00000000, 
    0x180b0702, 0x29281d1b, 0x2e2d2b2a, 0x00000046, 0x2a2a2a0e, 0x1c3e1d3e, 0x2e04041d, 0x0000000e, 
    0x00000000, 0x00000000, 0x001a0070, 0x00180072, 0x0000001a, 0x00000004, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x100b0702, 0x221e1915, 0x35302c27, 0x00000000, 0x00000000, 0x00000000, 
    0x190d0802, 0x2a291f1c, 0x2f2e2d2b, 0x00000058, 0x2b2b2b18, 0x1e481f48, 0x3804041f, 0x00000018, 
    0x00000000, 0x00000000, 0x001d007e, 0x001b0080, 0x0000001d, 0x00000004, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x100b0702, 0x221e1915, 0x35302c27, 0x00000000, 0x00000000, 0x00000000, 
    0x1b0f0903, 0x2b2a281e, 0x39382e2d, 0x0000006e, 0x2d2d2c19, 0x28492849, 0x39050528, 0x00000019, 
    0x00000000, 0x00000000, 0x0021008d, 0x001f008f, 0x00000020, 0x00000005, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x100b0702, 0x221e1915, 0x35302c27, 0x00000000, 0x00000000, 0x00000000, 
    0x1c180a03, 0x2d2b291f, 0x3a39382e, 0x0000008b, 0x2e2e2e1a, 0x294a294a, 0x3a050529, 0x0000001a, 
    0x00000000, 0x00000000, 0x0025009f, 0x002200a1, 0x00000024, 0x00000005, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x100b0702, 0x221e1915, 0x35302c27, 0x00000000, 0x00000000, 0x00000000, 
    0x1d1a0b03, 0x2e2c2a29, 0x3b3a3938, 0x000000af, 0x3838381c, 0x2a4b2b4b, 0x3b06062a, 0x0000001c, 
    0x00000000, 0x00000000, 0x002a00b2, 0x002700b5, 0x00000029, 0x00000006, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x100b0702, 0x221e1915, 0x35302c27, 0x00000000, 0x00000000, 0x00000000, 
    0x1f1b0c04, 0x382e2c2a, 0x3c3b3a39, 0x000000dd, 0x3939391d, 0x2b4d2c4d, 0x3d07072c, 0x0000001d, 
    0x00000000, 0x00000000, 0x002f00c8, 0x002b00cb, 0x0000002e, 0x00000007, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x100b0702, 0x221e1915, 0x35302c27, 0x00000000, 0x00000000, 0x00000000, 
    0x281c0e04, 0x39382d2b, 0x3e3d3b3a, 0x00000116, 0x3a3a3a1f, 0x2c4e2d4e, 0x3e08082d, 0x0000001f, 
    0x00000000, 0x00000000, 0x003500e1, 0x003100e4, 0x00000034, 0x00000008, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x100b0702, 0x221e1915, 0x35302c27, 0x00000000, 0x00000000, 0x00000000, 
    0x291d1805, 0x3a392f2c, 0x3f3e3d3b, 0x0000015e, 0x3b3b3b28, 0x2e582f58, 0x4809092f, 0x00000028, 
    0x00000000, 0x00000000, 0x003b00fc, 0x00370100, 0x0000003a, 0x00000009, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x100b0702, 0x221e1915, 0x35302c27, 0x00000000, 0x00000000, 0x00000000, 
    0x2b1f1906, 0x3b3a382e, 0x49483e3d, 0x000001ba, 0x3d3d3c29, 0x38593859, 0x490a0a38, 0x00000029, 
    0x00000000, 0x00000000, 0x0042011b, 0x003e011f, 0x00000041, 0x0000000a, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x100b0702, 0x221e1915, 0x35302c27, 0x00000000, 0x00000000, 0x00000000, 
    0x2c281a06, 0x3d3b392f, 0x4a49483e, 0x0000022c, 0x3e3e3e2a, 0x395a395a, 0x4a0b0b39, 0x0000002a, 
    0x00000000, 0x00000000, 0x004b013e, 0x00450142, 0x00000049, 0x0000000b, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x100b0702, 0x221e1915, 0x35302c27, 0x00000000, 0x00000000, 0x00000000, 
    0x2d2a1b07, 0x3e3c3a39, 0x4b4a4948, 0x000002bd, 0x4848482c, 0x3a5b3b5b, 0x4b0d0d3a, 0x0000002c, 
    0x00000000, 0x00000000, 0x00540165, 0x004e016a, 0x00000052, 0x0000000d, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x100b0702, 0x221e1915, 0x35302c27, 0x00000000, 0x00000000, 0x00000000, 
    0x2f2b1d08, 0x483e3c3a, 0x4c4b4a49, 0x00000373, 0x4949492d, 0x3b5d3c5d, 0x4d0e0e3c, 0x0000002d, 
    0x00000000, 0x00000000, 0x005e0191, 0x00570196, 0x0000005c, 0x0000000e, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x100b0702, 0x221e1915, 0x35302c27, 0x00000000, 0x00000000, 0x00000000, 
    0x382c1e09, 0x49483d3b, 0x4e4d4b4a, 0x00000459, 0x4a4a4a2f, 0x3c5e3d5e, 0x4e18183d, 0x0000002f, 
    0x00000000, 0x00000000, 0x006a01c2, 0x006201c8, 0x00000068, 0x00000010, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x100b0702, 0x221e1915, 0x35302c27, 0x00000000, 0x00000000, 0x00000000, 
    0x392d280a, 0x4a493f3c, 0x4f4e4d4b, 0x0000057a, 0x4b4b4b38, 0x3e683f68, 0x5819193f, 0x00000038, 
    0x00000000, 0x00000000, 0x007701f9, 0x006e0200, 0x00000074, 0x00000012, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x100b0702, 0x221e1915, 0x35302c27, 0x00000000, 0x00000000, 0x00000000, 
    0x3b2f290c, 0x4b4a483e, 0x59584e4d, 0x000006e6, 0x4d4d4c39, 0x48694869, 0x591b1b48, 0x00000039, 
    0x00000000, 0x00000000, 0x00850237, 0x007c023f, 0x00000083, 0x00000015, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x100b0702, 0x221e1915, 0x35302c27, 0x00000000, 0x00000000, 0x00000000, 
    0x3c382a0d, 0x4d4b493f, 0x5a59584e, 0x000008b1, 0x4e4e4e3a, 0x496a496a, 0x5a1c1c49, 0x0000003a, 
    0x00000000, 0x00000000, 0x0096027c, 0x008b0285, 0x00000093, 0x00000017, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x100b0702, 0x221e1915, 0x35302c27, 0x00000000, 0x00000000, 0x00000000, 
    0x3d3a2b0f, 0x4e4c4a49, 0x5b5a5958, 0x00000af4, 0x5858583c, 0x4a6b4b6b, 0x5b1d1d4a, 0x0000003c, 
    0x00000000, 0x00000000, 0x00a802ca, 0x009c02d4, 0x000000a5, 0x0000001a, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x100b0702, 0x221e1915, 0x35302c27, 0x00000000, 0x00000000, 0x00000000, 
    0x3f3b2d19, 0x584e4c4a, 0x5c5b5a59, 0x00000dcc, 0x5959593d, 0x4b6d4c6d, 0x5d1f1f4c, 0x0000003d, 
    0x00000000, 0x00000000, 0x00bd0322, 0x00af032d, 0x000000b9, 0x0000001d, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x100b0702, 0x221e1915, 0x35302c27, 0x00000000, 0x00000000, 0x00000000, 
    0x483c2e1a, 0x59584d4b, 0x5e5d5b5a, 0x00001162, 0x5a5a5a3f, 0x4c6e4d6e, 0x5e28284d, 0x0000003f, 
    0x00000000, 0x00000000, 0x00d40384, 0x00c40391, 0x000000d0, 0x00000021, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x100b0702, 0x221e1915, 0x35302c27, 0x00000000, 0x00000000, 0x00000000, 
    0x493d381b, 0x5a594f4c, 0x5f5e5d5b, 0x000015e7, 0x5b5b5b48, 0x4e784f78, 0x6829294f, 0x00000048, 
    0x00000000, 0x00000000, 0x00ee03f2, 0x00dd0400, 0x000000e9, 0x00000025, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x100b0702, 0x221e1915, 0x35302c27, 0x00000000, 0x00000000, 0x00000000, 
    0x4b3f391c, 0x5b5a584e, 0x69685e5d, 0x00001b98, 0x5d5d5c49, 0x58795879, 0x692b2b58, 0x00000049, 
    0x00000000, 0x00000000, 0x010b046e, 0x00f8047e, 0x00000106, 0x0000002a, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x100b0702, 0x221e1915, 0x35302c27, 0x00000000, 0x00000000, 0x00000000, 
    0x4c483a1e, 0x5d5b594f, 0x6a69685e, 0x000022c5, 0x5e5e5e4a, 0x597a597a, 0x6a2c2c59, 0x0000004a, 
    0x00000000, 0x00000000, 0x012c04f9, 0x0116050b, 0x00000126, 0x0000002f, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x100b0702, 0x221e1915, 0x35302c27, 0x00000000, 0x00000000, 0x00000000, 
    0x4d4a3b1f, 0x5e5c5a59, 0x6b6a6968, 0x00002bce, 0x6868684c, 0x5a7b5b7b, 0x6b2d2d5a, 0x0000004c, 
    0x00000000, 0x00000000, 0x01510595, 0x013805a9, 0x0000014a, 0x00000034, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x100b0702, 0x221e1915, 0x35302c27, 0x00000000, 0x00000000, 0x00000000, 
    0x4f4b3d29, 0x685e5c5a, 0x6c6b6a69, 0x00003731, 0x6969694d, 0x5b7d5c7d, 0x6d2f2f5c, 0x0000004d, 
    0x00000000, 0x00000000, 0x017a0644, 0x015e065a, 0x00000173, 0x0000003b, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x100b0702, 0x221e1915, 0x35302c27, 0x00000000, 0x00000000, 0x00000000, 
    0x584c3e2a, 0x69685d5b, 0x6e6d6b6a, 0x00004589, 0x6a6a6a4f, 0x5c7e5d7e, 0x6e38385d, 0x0000004f, 
    0x00000000, 0x00000000, 0x01a90709, 0x01890722, 0x000001a0, 0x00000042, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x100b0702, 0x221e1915, 0x35302c27, 0x00000000, 0x00000000, 0x00000000, 
    0x594d482b, 0x6a695f5c, 0x6f6e6d6b, 0x0000579c, 0x6b6b6b58, 0x5e885f88, 0x7839395f, 0x00000058, 
    0x00000000, 0x00000000, 0x01dd07e5, 0x01ba0801, 0x000001d3, 0x0000004a, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x100b0702, 0x221e1915, 0x35302c27, 0x00000000, 0x00000000, 0x00000000, 
    0x5b4f492c, 0x6b6a685e, 0x6f6f6e6d, 0x00006e62, 0x6d6d6c59, 0x68896889, 0x793b3b68, 0x00000059, 
    0x00000000, 0x00000000, 0x021708dd, 0x01f008fc, 0x0000020d, 0x00000054, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x100b0702, 0x221e1915, 0x35302c27, 0x00000000, 0x00000000, 0x00000000, 
    0x5c584a2e, 0x6d6b695f, 0x6f6f6f6e, 0x00008b12, 0x6e6e6e5a, 0x698a698a, 0x7a3c3c69, 0x0000005a, 
    0x00000000, 0x00000000, 0x025909f3, 0x022d0a16, 0x0000024d, 0x0000005e, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x100b0702, 0x221e1915, 0x35302c27, 0x00000000, 0x00000000, 0x00000000, 
    0x5d5a4b2f, 0x6e6c6a69, 0x6f6f6f6f, 0x0000af38, 0x7878785c, 0x6a8b6b8b, 0x7b3d3d6a, 0x0000005c, 
    0x00000000, 0x00000000, 0x02a30b2b, 0x02710b52, 0x00000295, 0x00000069, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x100b0702, 0x221e1915, 0x35302c27, 0x00000000, 0x00000000, 0x00000000, 
    0x5f5b4d39, 0x6f6e6c6a, 0x6f6f6f6f, 0x0000dcc3, 0x7979795d, 0x6b8d6c8d, 0x7d3f3f6c, 0x0000005d, 
    0x00000000, 0x00000000, 0x02f50c89, 0x02bd0cb5, 0x000002e6, 0x00000076, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x100b0702, 0x221e1915, 0x35302c27, 0x00000000, 0x00000000, 0x00000000, 
    0x685c4e3a, 0x6f6f6d6b, 0x6f6f6f6f, 0x00001625, 0x7a7a7a5f, 0x6c8e6d8e, 0x7e48486d, 0x0000005f, 
    0x00000000, 0x00000000, 0x03520e12, 0x03130e44, 0x00000341, 0x00000085, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x100b0702, 0x221e1915, 0x35302c27, 0x00000000, 0x00000000, 0x00000000, 
    0x695d583b, 0x6f6f6f6c, 0x6f6f6f6f, 0x00005e70, 0x7b7b7b68, 0x6e8f6f8f, 0x8849496f, 0x00000068, 
    0x00000000, 0x00000000, 0x03ba0fcb, 0x03741003, 0x000003a7, 0x00000095, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x100b0702, 0x221e1915, 0x35302c27, 0x00000000, 0x00000000, 0x00000000, 
    0x6b5f593c, 0x6f6f6f6e, 0x6f6f6f6f, 0x0000b986, 0x7d7d7c69, 0x788f788f, 0x894b4b78, 0x00000069, 
    0x00000000, 0x00000000, 0x042f11ba, 0x03e011f9, 0x0000041a, 0x000000a8, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x100b0702, 0x221e1915, 0x35302c27, 0x00000000, 0x00000000, 0x00000000, 
    0x6c685a3e, 0x6f6f6f6f, 0x6f6f6f6f, 0x00002c49, 0x7e7e7e6a, 0x798f798f, 0x8a4c4c79, 0x0000006a, 
    0x00000000, 0x00000000, 0x04b213e6, 0x045a142d, 0x0000049b, 0x000000bc, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x100b0702, 0x221e1915, 0x35302c27, 0x00000000, 0x00000000, 0x00000000, 
    0x6d6a5b3f, 0x6f6f6f6f, 0x6f6f6f6f, 0x0000bce0, 0x8888886c, 0x7a8f7b8f, 0x8b4d4d7a, 0x0000006c, 
    0x00000000, 0x00000000, 0x05461656, 0x04e216a5, 0x0000052b, 0x000000d3, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x100b0702, 0x221e1915, 0x35302c27, 0x00000000, 0x00000000, 0x00000000, 
    0x6f6b5d49, 0x6f6f6f6f, 0x6f6f6f6f, 0x0000730d, 0x8989896d, 0x7b8f7c8f, 0x8d4f4f7c, 0x0000006d, 
    0x00000000, 0x00000000, 0x05eb1912, 0x057b196b, 0x000005cd, 0x000000ed, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x100b0702, 0x221e1915, 0x35302c27, 0x00000000, 0x00000000, 0x00000000, 
    0x6f6c5e4a, 0x6f6f6f6f, 0x6f6f6f6f, 0x00005893, 0x8a8a8a6f, 0x7c8f7d8f, 0x8e58587d, 0x0000006f, 
    0x00000000, 0x00000000, 0x06a51c24, 0x06271c88, 0x00000683, 0x0000010a, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x100b0702, 0x221e1915, 0x35302c27, 0x00000000, 0x00000000, 0x00000000, 
    0x6f6d684b, 0x6f6f6f6f, 0x6f6f6f6f, 0x000079c1, 0x8b8b8b78, 0x7e8f7f8f, 0x8f59597f, 0x00000078, 
    0x00000000, 0x00000000, 0x07751f97, 0x06e82007, 0x0000074f, 0x0000012b, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x100b0702, 0x221e1915, 0x35302c27, 0x00000000, 0x00000000, 0x00000000, 
    0x04030100, 0x09070605, 0x0e0c0b0a, 0x00000004, 0x0a090903, 0x061e061e, 0x0d010106, 0x00000003, 
    0x00000000, 0x00000000, 0x0006001b, 0x0006001b, 0x00000006, 0x00000001, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x110c0702, 0x241f1a16, 0x37322e29, 0x00000000, 0x00000000, 0x00000000, 
    0x04030100, 0x09070605, 0x0e0c0b0a, 0x00000004, 0x0a090903, 0x061e061e, 0x0d010106, 0x00000003, 
    0x00000000, 0x00000000, 0x0006001b, 0x0006001b, 0x00000006, 0x00000001, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x110c0702, 0x241f1a16, 0x37322e29, 0x00000000, 0x00000000, 0x00000000, 
    0x04030100, 0x09070605, 0x0e0c0b0a, 0x00000004, 0x0a090903, 0x061e061e, 0x0d010106, 0x00000003, 
    0x00000000, 0x00000000, 0x0006001b, 0x0006001b, 0x00000006, 0x00000001, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x110c0702, 0x241f1a16, 0x37322e29, 0x00000000, 0x00000000, 0x00000000, 
    0x04030100, 0x09070605, 0x0e0c0b0a, 0x00000004, 0x0a090903, 0x061e061e, 0x0d010106, 0x00000003, 
    0x00000000, 0x00000000, 0x0006001b, 0x0006001b, 0x00000006, 0x00000001, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x110c0702, 0x241f1a16, 0x37322e29, 0x00000000, 0x00000000, 0x00000000, 
    0x04030100, 0x09070605, 0x0e0c0b0a, 0x00000004, 0x0a090903, 0x061e061e, 0x0d010106, 0x00000003, 
    0x00000000, 0x00000000, 0x0006001b, 0x0006001b, 0x00000006, 0x00000001, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x110c0702, 0x241f1a16, 0x37322e29, 0x00000000, 0x00000000, 0x00000000, 
    0x04030100, 0x09070605, 0x0e0c0b0a, 0x00000004, 0x0a090903, 0x061e061e, 0x0d010106, 0x00000003, 
    0x00000000, 0x00000000, 0x0006001b, 0x0006001b, 0x00000006, 0x00000001, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x110c0702, 0x241f1a16, 0x37322e29, 0x00000000, 0x00000000, 0x00000000, 
    0x04030100, 0x09070605, 0x0e0c0b0a, 0x00000004, 0x0a090903, 0x061e061e, 0x0d010106, 0x00000003, 
    0x00000000, 0x00000000, 0x0006001b, 0x0006001b, 0x00000006, 0x00000001, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x110c0702, 0x241f1a16, 0x37322e29, 0x00000000, 0x00000000, 0x00000000, 
    0x04030100, 0x09070605, 0x0e0c0b0a, 0x00000004, 0x0a090903, 0x061e061e, 0x0d010106, 0x00000003, 
    0x00000000, 0x00000000, 0x0006001b, 0x0006001b, 0x00000006, 0x00000001, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x110c0702, 0x241f1a16, 0x37322e29, 0x00000000, 0x00000000, 0x00000000, 
    0x04030100, 0x09070605, 0x0e0c0b0a, 0x00000004, 0x0a090903, 0x061e061e, 0x0d010106, 0x00000003, 
    0x00000000, 0x00000000, 0x0006001b, 0x0006001b, 0x00000006, 0x00000001, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x110c0702, 0x241f1a16, 0x37322e29, 0x00000000, 0x00000000, 0x00000000, 
    0x04030100, 0x09070605, 0x0e0c0b0a, 0x00000004, 0x0a090903, 0x061e061e, 0x0d010106, 0x00000003, 
    0x00000000, 0x00000000, 0x0006001b, 0x0006001b, 0x00000006, 0x00000001, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x110c0702, 0x241f1a16, 0x37322e29, 0x00000000, 0x00000000, 0x00000000, 
    0x04030100, 0x09070605, 0x0e0c0b0a, 0x00000004, 0x0a090903, 0x061e061e, 0x0d010106, 0x00000003, 
    0x00000000, 0x00000000, 0x0006001b, 0x0006001b, 0x00000006, 0x00000001, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x110c0702, 0x241f1a16, 0x37322e29, 0x00000000, 0x00000000, 0x00000000, 
    0x04030100, 0x09070605, 0x0e0c0b0a, 0x00000004, 0x0a090903, 0x061e061e, 0x0d010106, 0x00000003, 
    0x00000000, 0x00000000, 0x0006001b, 0x0006001b, 0x00000006, 0x00000001, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x110c0702, 0x241f1a16, 0x37322e29, 0x00000000, 0x00000000, 0x00000000, 
    0x04030100, 0x09070605, 0x0e0c0b0a, 0x00000004, 0x0a090903, 0x061e061e, 0x0d010106, 0x00000003, 
    0x00000000, 0x00000000, 0x0006001b, 0x0006001b, 0x00000006, 0x00000001, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x110c0702, 0x241f1a16, 0x37322e29, 0x00000000, 0x00000000, 0x00000000, 
    0x04030200, 0x0a080706, 0x0f0e0d0b, 0x00000005, 0x0b0b0a04, 0x0628071f, 0x0f010107, 0x00000004, 
    0x00000000, 0x00000000, 0x0007001e, 0x0006001f, 0x00000007, 0x00000001, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x110c0702, 0x241f1a16, 0x37322e29, 0x00000000, 0x00000000, 0x00000000, 
    0x05030200, 0x0b0a0806, 0x19180e0d, 0x00000007, 0x0c0c0c04, 0x07290829, 0x19010108, 0x00000004, 
    0x00000000, 0x00000000, 0x00080022, 0x00070023, 0x00000008, 0x00000001, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x110c0702, 0x241f1a16, 0x37322e29, 0x00000000, 0x00000000, 0x00000000, 
    0x06040200, 0x0c0b0907, 0x1a19180e, 0x00000008, 0x0e0e0d05, 0x082a092a, 0x1a010109, 0x00000005, 
    0x00000000, 0x00000000, 0x00090026, 0x00080027, 0x00000009, 0x00000001, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x110c0702, 0x241f1a16, 0x37322e29, 0x00000000, 0x00000000, 0x00000000, 
    0x06040200, 0x0e0c0a08, 0x1b1a1918, 0x0000000a, 0x0f0f0f05, 0x092b0a2b, 0x1b01010a, 0x00000005, 
    0x00000000, 0x00000000, 0x000a002b, 0x0009002c, 0x0000000a, 0x00000001, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x110c0702, 0x241f1a16, 0x37322e29, 0x00000000, 0x00000000, 0x00000000, 
    0x07050301, 0x180e0b09, 0x1d1b1a19, 0x0000000d, 0x19191906, 0x0a2c0b2c, 0x1c01010b, 0x00000006, 
    0x00000000, 0x00000000, 0x000b0031, 0x000a0031, 0x0000000b, 0x00000001, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x110c0702, 0x241f1a16, 0x37322e29, 0x00000000, 0x00000000, 0x00000000, 
    0x08060301, 0x190f0d0b, 0x1e1d1c1a, 0x00000011, 0x1a1a1a07, 0x0c2e0d2e, 0x1e02020c, 0x00000007, 
    0x00000000, 0x00000000, 0x000d0037, 0x000c0037, 0x0000000c, 0x00000002, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x110c0702, 0x241f1a16, 0x37322e29, 0x00000000, 0x00000000, 0x00000000, 
    0x09060401, 0x1a190f0c, 0x281e1d1c, 0x00000015, 0x1b1b1b08, 0x0d380e2f, 0x1f02020e, 0x00000008, 
    0x00000000, 0x00000000, 0x000e003d, 0x000d003e, 0x0000000e, 0x00000002, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x110c0702, 0x241f1a16, 0x37322e29, 0x00000000, 0x00000000, 0x00000000, 
    0x0a070401, 0x1c1a180d, 0x29281f1d, 0x0000001a, 0x1d1d1c08, 0x0f391839, 0x29020218, 0x00000008, 
    0x00000000, 0x00000000, 0x00100045, 0x000f0046, 0x00000010, 0x00000002, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x110c0702, 0x241f1a16, 0x37322e29, 0x00000000, 0x00000000, 0x00000000, 
    0x0c080501, 0x1d1b1a0f, 0x2a29281f, 0x00000021, 0x1e1e1e0a, 0x193a193a, 0x2a020219, 0x0000000a, 
    0x00000000, 0x00000000, 0x0012004d, 0x0011004e, 0x00000012, 0x00000002, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x110c0702, 0x241f1a16, 0x37322e29, 0x00000000, 0x00000000, 0x00000000, 
    0x0d090501, 0x1f1d1b19, 0x2b2a2928, 0x0000002a, 0x28281f0b, 0x1a3b1a3b, 0x2b03031a, 0x0000000b, 
    0x00000000, 0x00000000, 0x00140057, 0x00130058, 0x00000014, 0x00000003, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x110c0702, 0x241f1a16, 0x37322e29, 0x00000000, 0x00000000, 0x00000000, 
    0x0f0a0602, 0x281e1c1a, 0x2d2b2a29, 0x00000035, 0x2929290c, 0x1b3c1c3c, 0x2c03031b, 0x0000000c, 
    0x00000000, 0x00000000, 0x00170062, 0x00150063, 0x00000016, 0x00000003, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x110c0702, 0x241f1a16, 0x37322e29, 0x00000000, 0x00000000, 0x00000000, 
    0x190c0702, 0x29281d1b, 0x2e2d2c2a, 0x00000043, 0x2a2a2a0e, 0x1c3e1d3e, 0x2e04041d, 0x0000000e, 
    0x00000000, 0x00000000, 0x001a006e, 0x0018006f, 0x00000019, 0x00000004, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x110c0702, 0x241f1a16, 0x37322e29, 0x00000000, 0x00000000, 0x00000000, 
    0x1a0d0802, 0x2a291f1c, 0x382e2d2c, 0x00000054, 0x2b2b2b18, 0x1e481f3f, 0x2f04041e, 0x00000018, 
    0x00000000, 0x00000000, 0x001d007b, 0x001b007d, 0x0000001c, 0x00000004, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x110c0702, 0x241f1a16, 0x37322e29, 0x00000000, 0x00000000, 0x00000000, 
    0x1b0f0903, 0x2c2a281e, 0x39382f2d, 0x0000006a, 0x2d2d2c19, 0x1f492849, 0x39050528, 0x00000019, 
    0x00000000, 0x00000000, 0x0020008a, 0x001e008c, 0x00000020, 0x00000005, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x110c0702, 0x241f1a16, 0x37322e29, 0x00000000, 0x00000000, 0x00000000, 
    0x1c190a03, 0x2d2b2a28, 0x3a39382f, 0x00000085, 0x2e2e2e1a, 0x294a294a, 0x3a050529, 0x0000001a, 
    0x00000000, 0x00000000, 0x0024009b, 0x0022009d, 0x00000024, 0x00000005, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x110c0702, 0x241f1a16, 0x37322e29, 0x00000000, 0x00000000, 0x00000000, 
    0x1e1a0b03, 0x2f2d2b29, 0x3b3a3938, 0x000000a8, 0x38382f1b, 0x2a4b2a4b, 0x3b06062a, 0x0000001b, 
    0x00000000, 0x00000000, 0x002900ae, 0x002600b1, 0x00000028, 0x00000006, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x110c0702, 0x241f1a16, 0x37322e29, 0x00000000, 0x00000000, 0x00000000, 
    0x1f1b0d04, 0x382e2c2a, 0x3d3b3a39, 0x000000d3, 0x3939391d, 0x2b4c2c4c, 0x3c07072b, 0x0000001d, 
    0x00000000, 0x00000000, 0x002e00c4, 0x002a00c6, 0x0000002d, 0x00000007, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x110c0702, 0x241f1a16, 0x37322e29, 0x00000000, 0x00000000, 0x00000000, 
    0x291c0e04, 0x39382d2b, 0x3e3d3c3a, 0x0000010a, 0x3a3a3a1e, 0x2c4e2d4e, 0x3e08082d, 0x0000001e, 
    0x00000000, 0x00000000, 0x003400dc, 0x003000df, 0x00000032, 0x00000008, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x110c0702, 0x241f1a16, 0x37322e29, 0x00000000, 0x00000000, 0x00000000, 
    0x2a1e1805, 0x3a392f2c, 0x483e3d3c, 0x0000014f, 0x3b3b3b28, 0x2e582f4f, 0x3f09092e, 0x00000028, 
    0x00000000, 0x00000000, 0x003a00f7, 0x003600fa, 0x00000039, 0x00000009, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x110c0702, 0x241f1a16, 0x37322e29, 0x00000000, 0x00000000, 0x00000000, 
    0x2b1f1906, 0x3c3a382e, 0x49483f3d, 0x000001a7, 0x3d3d3c29, 0x2f593859, 0x490a0a38, 0x00000029, 
    0x00000000, 0x00000000, 0x00410115, 0x003c0119, 0x00000040, 0x0000000a, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x110c0702, 0x241f1a16, 0x37322e29, 0x00000000, 0x00000000, 0x00000000, 
    0x2c291a06, 0x3d3b3a38, 0x4a49483f, 0x00000214, 0x3e3e3e2a, 0x395a395a, 0x4a0b0b39, 0x0000002a, 
    0x00000000, 0x00000000, 0x00490137, 0x0044013b, 0x00000048, 0x0000000b, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x110c0702, 0x241f1a16, 0x37322e29, 0x00000000, 0x00000000, 0x00000000, 
    0x2e2a1c07, 0x3f3d3b39, 0x4b4a4948, 0x0000029f, 0x48483f2b, 0x3a5b3a5b, 0x4b0c0c3a, 0x0000002b, 
    0x00000000, 0x00000000, 0x0052015d, 0x004c0162, 0x00000050, 0x0000000c, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x110c0702, 0x241f1a16, 0x37322e29, 0x00000000, 0x00000000, 0x00000000, 
    0x2f2b1d08, 0x483e3c3a, 0x4d4b4a49, 0x0000034d, 0x4949492d, 0x3b5c3c5c, 0x4c0e0e3b, 0x0000002d, 
    0x00000000, 0x00000000, 0x005c0188, 0x0055018d, 0x0000005a, 0x0000000e, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x110c0702, 0x241f1a16, 0x37322e29, 0x00000000, 0x00000000, 0x00000000, 
    0x392c1f09, 0x49483d3b, 0x4e4d4c4a, 0x00000429, 0x4a4a4a2e, 0x3c5e3d5e, 0x4e18183d, 0x0000002e, 
    0x00000000, 0x00000000, 0x006801b8, 0x006001be, 0x00000065, 0x00000010, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x110c0702, 0x241f1a16, 0x37322e29, 0x00000000, 0x00000000, 0x00000000, 
    0x3a2e280a, 0x4a493f3c, 0x584e4d4c, 0x0000053e, 0x4b4b4b38, 0x3e683f5f, 0x4f19193e, 0x00000038, 
    0x00000000, 0x00000000, 0x007401ee, 0x006c01f5, 0x00000072, 0x00000012, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x110c0702, 0x241f1a16, 0x37322e29, 0x00000000, 0x00000000, 0x00000000, 
    0x3b2f290c, 0x4c4a483e, 0x59584f4d, 0x0000069b, 0x4d4d4c39, 0x3f694869, 0x591a1a48, 0x00000039, 
    0x00000000, 0x00000000, 0x0083022b, 0x00790232, 0x00000080, 0x00000014, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x110c0702, 0x241f1a16, 0x37322e29, 0x00000000, 0x00000000, 0x00000000, 
    0x3c392a0d, 0x4d4b4a48, 0x5a59584f, 0x00000852, 0x4e4e4e3a, 0x496a496a, 0x5a1c1c49, 0x0000003a, 
    0x00000000, 0x00000000, 0x0093026f, 0x00880277, 0x00000090, 0x00000017, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x110c0702, 0x241f1a16, 0x37322e29, 0x00000000, 0x00000000, 0x00000000, 
    0x3e3a2c0f, 0x4f4d4b49, 0x5b5a5958, 0x00000a7c, 0x58584f3b, 0x4a6b4a6b, 0x5b1d1d4a, 0x0000003b, 
    0x00000000, 0x00000000, 0x00a502bb, 0x009802c5, 0x000000a1, 0x00000019, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x110c0702, 0x241f1a16, 0x37322e29, 0x00000000, 0x00000000, 0x00000000, 
    0x3f3b2d19, 0x584e4c4a, 0x5d5b5a59, 0x00000d35, 0x5959593d, 0x4b6c4c6c, 0x5c1f1f4b, 0x0000003d, 
    0x00000000, 0x00000000, 0x00b90310, 0x00ab031b, 0x000000b5, 0x0000001d, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x110c0702, 0x241f1a16, 0x37322e29, 0x00000000, 0x00000000, 0x00000000, 
    0x493c2f1a, 0x59584d4b, 0x5e5d5c5a, 0x000010a4, 0x5a5a5a3e, 0x4c6e4d6e, 0x5e28284d, 0x0000003e, 
    0x00000000, 0x00000000, 0x00d00371, 0x00c0037d, 0x000000cb, 0x00000020, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x110c0702, 0x241f1a16, 0x37322e29, 0x00000000, 0x00000000, 0x00000000, 
    0x4a3e381b, 0x5a594f4c, 0x685e5d5c, 0x000014f7, 0x5b5b5b48, 0x4e784f6f, 0x5f29294e, 0x00000048, 
    0x00000000, 0x00000000, 0x00e903dd, 0x00d803ea, 0x000000e4, 0x00000024, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x110c0702, 0x241f1a16, 0x37322e29, 0x00000000, 0x00000000, 0x00000000, 
    0x4b3f391c, 0x5c5a584e, 0x69685f5d, 0x00001a6a, 0x5d5d5c49, 0x4f795879, 0x692a2a58, 0x00000049, 
    0x00000000, 0x00000000, 0x01060456, 0x00f20465, 0x00000100, 0x00000029, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x110c0702, 0x241f1a16, 0x37322e29, 0x00000000, 0x00000000, 0x00000000, 
    0x4c493a1e, 0x5d5b5a58, 0x6a69685f, 0x00002148, 0x5e5e5e4a, 0x597a597a, 0x6a2c2c59, 0x0000004a, 
    0x00000000, 0x00000000, 0x012604de, 0x011004ef, 0x00000120, 0x0000002e, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x110c0702, 0x241f1a16, 0x37322e29, 0x00000000, 0x00000000, 0x00000000, 
    0x4e4a3c28, 0x5f5d5b59, 0x6b6a6968, 0x000029ee, 0x68685f4b, 0x5a7b5a7b, 0x6b2d2d5a, 0x0000004b, 
    0x00000000, 0x00000000, 0x014a0576, 0x0131058a, 0x00000143, 0x00000033, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x110c0702, 0x241f1a16, 0x37322e29, 0x00000000, 0x00000000, 0x00000000, 
    0x4f4b3d29, 0x685e5c5a, 0x6d6b6a69, 0x000034d4, 0x6969694d, 0x5b7c5c7c, 0x6c2f2f5b, 0x0000004d, 
    0x00000000, 0x00000000, 0x01720621, 0x01570637, 0x0000016b, 0x0000003a, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x110c0702, 0x241f1a16, 0x37322e29, 0x00000000, 0x00000000, 0x00000000, 
    0x594c3f2a, 0x69685d5b, 0x6e6d6c6a, 0x0000428f, 0x6a6a6a4e, 0x5c7e5d7e, 0x6e38385d, 0x0000004e, 
    0x00000000, 0x00000000, 0x01a006e2, 0x018106fa, 0x00000197, 0x00000041, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x110c0702, 0x241f1a16, 0x37322e29, 0x00000000, 0x00000000, 0x00000000, 
    0x5a4e482b, 0x6a695f5c, 0x6f6e6d6c, 0x000053dc, 0x6b6b6b58, 0x5e885f7f, 0x6f39395e, 0x00000058, 
    0x00000000, 0x00000000, 0x01d307ba, 0x01b007d5, 0x000001c9, 0x00000049, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x110c0702, 0x241f1a16, 0x37322e29, 0x00000000, 0x00000000, 0x00000000, 
    0x5b4f492c, 0x6c6a685e, 0x6f6f6f6d, 0x000069a8, 0x6d6d6c59, 0x5f896889, 0x793a3a68, 0x00000059, 
    0x00000000, 0x00000000, 0x020c08ac, 0x01e508cb, 0x00000201, 0x00000052, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x110c0702, 0x241f1a16, 0x37322e29, 0x00000000, 0x00000000, 0x00000000, 
    0x5c594a2e, 0x6d6b6a68, 0x6f6f6f6f, 0x0000851f, 0x6e6e6e5a, 0x698a698a, 0x7a3c3c69, 0x0000005a, 
    0x00000000, 0x00000000, 0x024c09bc, 0x022109de, 0x00000240, 0x0000005c, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x110c0702, 0x241f1a16, 0x37322e29, 0x00000000, 0x00000000, 0x00000000, 
    0x5e5a4c38, 0x6f6d6b69, 0x6f6f6f6f, 0x0000a7b8, 0x78786f5b, 0x6a8b6a8b, 0x7b3d3d6a, 0x0000005b, 
    0x00000000, 0x00000000, 0x02940aed, 0x02630b14, 0x00000287, 0x00000067, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x110c0702, 0x241f1a16, 0x37322e29, 0x00000000, 0x00000000, 0x00000000, 
    0x5f5b4d39, 0x6f6e6c6a, 0x6f6f6f6f, 0x0000d351, 0x7979795d, 0x6b8c6c8c, 0x7c3f3f6b, 0x0000005d, 
    0x00000000, 0x00000000, 0x02e50c43, 0x02ae0c6f, 0x000002d6, 0x00000074, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x110c0702, 0x241f1a16, 0x37322e29, 0x00000000, 0x00000000, 0x00000000, 
    0x695c4f3a, 0x6f6f6d6b, 0x6f6f6f6f, 0x00000a3d, 0x7a7a7a5e, 0x6c8e6d8e, 0x7e48486d, 0x0000005e, 
    0x00000000, 0x00000000, 0x03400dc4, 0x03020df5, 0x0000032f, 0x00000082, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x110c0702, 0x241f1a16, 0x37322e29, 0x00000000, 0x00000000, 0x00000000, 
    0x6a5e583b, 0x6f6f6f6c, 0x6f6f6f6f, 0x00004f71, 0x7b7b7b68, 0x6e8f6f8f, 0x7f49496e, 0x00000068, 
    0x00000000, 0x00000000, 0x03a60f74, 0x03610faa, 0x00000393, 0x00000092, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x110c0702, 0x241f1a16, 0x37322e29, 0x00000000, 0x00000000, 0x00000000, 
    0x6b5f593c, 0x6f6f6f6e, 0x6f6f6f6f, 0x0000a6a1, 0x7d7d7c69, 0x6f8f788f, 0x894a4a78, 0x00000069, 
    0x00000000, 0x00000000, 0x04181158, 0x03cb1196, 0x00000403, 0x000000a4, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x110c0702, 0x241f1a16, 0x37322e29, 0x00000000, 0x00000000, 0x00000000, 
    0x6c695a3e, 0x6f6f6f6f, 0x6f6f6f6f, 0x0000147b, 0x7e7e7e6a, 0x798f798f, 0x8a4c4c79, 0x0000006a, 
    0x00000000, 0x00000000, 0x04981378, 0x044213bd, 0x00000481, 0x000000b8, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x110c0702, 0x241f1a16, 0x37322e29, 0x00000000, 0x00000000, 0x00000000, 
    0x6e6a5c48, 0x6f6f6f6f, 0x6f6f6f6f, 0x00009ee2, 0x88887f6b, 0x7a8f7a8f, 0x8b4d4d7a, 0x0000006b, 
    0x00000000, 0x00000000, 0x052815da, 0x04c71628, 0x0000050f, 0x000000cf, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x110c0702, 0x241f1a16, 0x37322e29, 0x00000000, 0x00000000, 0x00000000, 
    0x6f6b5d49, 0x6f6f6f6f, 0x6f6f6f6f, 0x00004d42, 0x8989896d, 0x7b8f7c8f, 0x8c4f4f7b, 0x0000006d, 
    0x00000000, 0x00000000, 0x05ca1887, 0x055d18df, 0x000005ad, 0x000000e8, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x110c0702, 0x241f1a16, 0x37322e29, 0x00000000, 0x00000000, 0x00000000, 
    0x6f6c5f4a, 0x6f6f6f6f, 0x6f6f6f6f, 0x000028f6, 0x8a8a8a6e, 0x7c8f7d8f, 0x8e58587d, 0x0000006e, 
    0x00000000, 0x00000000, 0x06801b88, 0x06051bea, 0x0000065f, 0x00000105, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x110c0702, 0x241f1a16, 0x37322e29, 0x00000000, 0x00000000, 0x00000000, 
    0x6f6e684b, 0x6f6f6f6f, 0x6f6f6f6f, 0x00003dc4, 0x8b8b8b78, 0x7e8f7f8f, 0x8f59597e, 0x00000078, 
    0x00000000, 0x00000000, 0x074c1ee8, 0x06c21f55, 0x00000727, 0x00000125, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x110c0702, 0x241f1a16, 0x37322e29, 0x00000000, 0x00000000, 0x00000000, 
    0x6f6f694c, 0x6f6f6f6f, 0x6f6f6f6f, 0x00009a85, 0x8d8d8c79, 0x7f8f888f, 0x8f5a5a88, 0x00000079, 
    0x00000000, 0x00000000, 0x083022b1, 0x0796232c, 0x00000807, 0x00000148, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x110c0702, 0x241f1a16, 0x37322e29, 0x00000000, 0x00000000, 0x00000000, 
    0x6f6f6a4e, 0x6f6f6f6f, 0x6f6f6f6f, 0x000051ec, 0x8e8e8e7a, 0x898f898f, 0x8f5c5c89, 0x0000007a, 
    0x00000000, 0x00000000, 0x093126f0, 0x0884277b, 0x00000903, 0x00000171, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x110c0702, 0x241f1a16, 0x37322e29, 0x00000000, 0x00000000, 0x00000000, 
    0x04030100, 0x09080705, 0x0e0d0c0a, 0x00000004, 0x09090903, 0x051d061d, 0x0d000006, 0x00000003, 
    0x00000000, 0x00000000, 0x0006001a, 0x0005001a, 0x00000006, 0x00000000, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x120d0803, 0x28221d18, 0x3d37322d, 0x00000000, 0x00000000, 0x00000000, 
    0x04030100, 0x09080705, 0x0e0d0c0a, 0x00000004, 0x09090903, 0x051d061d, 0x0d000006, 0x00000003, 
    0x00000000, 0x00000000, 0x0006001a, 0x0005001a, 0x00000006, 0x00000000, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x120d0803, 0x28221d18, 0x3d37322d, 0x00000000, 0x00000000, 0x00000000, 
    0x04030100, 0x09080705, 0x0e0d0c0a, 0x00000004, 0x09090903, 0x051d061d, 0x0d000006, 0x00000003, 
    0x00000000, 0x00000000, 0x0006001a, 0x0005001a, 0x00000006, 0x00000000, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x120d0803, 0x28221d18, 0x3d37322d, 0x00000000, 0x00000000, 0x00000000, 
    0x04030100, 0x09080705, 0x0e0d0c0a, 0x00000004, 0x09090903, 0x051d061d, 0x0d000006, 0x00000003, 
    0x00000000, 0x00000000, 0x0006001a, 0x0005001a, 0x00000006, 0x00000000, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x120d0803, 0x28221d18, 0x3d37322d, 0x00000000, 0x00000000, 0x00000000, 
    0x04030100, 0x09080705, 0x0e0d0c0a, 0x00000004, 0x09090903, 0x051d061d, 0x0d000006, 0x00000003, 
    0x00000000, 0x00000000, 0x0006001a, 0x0005001a, 0x00000006, 0x00000000, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x120d0803, 0x28221d18, 0x3d37322d, 0x00000000, 0x00000000, 0x00000000, 
    0x04030100, 0x09080705, 0x0e0d0c0a, 0x00000004, 0x09090903, 0x051d061d, 0x0d000006, 0x00000003, 
    0x00000000, 0x00000000, 0x0006001a, 0x0005001a, 0x00000006, 0x00000000, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x120d0803, 0x28221d18, 0x3d37322d, 0x00000000, 0x00000000, 0x00000000, 
    0x04030100, 0x09080705, 0x0e0d0c0a, 0x00000004, 0x09090903, 0x051d061d, 0x0d000006, 0x00000003, 
    0x00000000, 0x00000000, 0x0006001a, 0x0005001a, 0x00000006, 0x00000000, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x120d0803, 0x28221d18, 0x3d37322d, 0x00000000, 0x00000000, 0x00000000, 
    0x04030100, 0x09080705, 0x0e0d0c0a, 0x00000004, 0x09090903, 0x051d061d, 0x0d000006, 0x00000003, 
    0x00000000, 0x00000000, 0x0006001a, 0x0005001a, 0x00000006, 0x00000000, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x120d0803, 0x28221d18, 0x3d37322d, 0x00000000, 0x00000000, 0x00000000, 
    0x04030100, 0x09080705, 0x0e0d0c0a, 0x00000004, 0x09090903, 0x051d061d, 0x0d000006, 0x00000003, 
    0x00000000, 0x00000000, 0x0006001a, 0x0005001a, 0x00000006, 0x00000000, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x120d0803, 0x28221d18, 0x3d37322d, 0x00000000, 0x00000000, 0x00000000, 
    0x04030100, 0x09080705, 0x0e0d0c0a, 0x00000004, 0x09090903, 0x051d061d, 0x0d000006, 0x00000003, 
    0x00000000, 0x00000000, 0x0006001a, 0x0005001a, 0x00000006, 0x00000000, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x120d0803, 0x28221d18, 0x3d37322d, 0x00000000, 0x00000000, 0x00000000, 
    0x04030100, 0x09080705, 0x0e0d0c0a, 0x00000004, 0x09090903, 0x051d061d, 0x0d000006, 0x00000003, 
    0x00000000, 0x00000000, 0x0006001a, 0x0005001a, 0x00000006, 0x00000000, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x120d0803, 0x28221d18, 0x3d37322d, 0x00000000, 0x00000000, 0x00000000, 
    0x04030100, 0x09080705, 0x0e0d0c0a, 0x00000004, 0x09090903, 0x051d061d, 0x0d000006, 0x00000003, 
    0x00000000, 0x00000000, 0x0006001a, 0x0005001a, 0x00000006, 0x00000000, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x120d0803, 0x28221d18, 0x3d37322d, 0x00000000, 0x00000000, 0x00000000, 
    0x04030100, 0x09080705, 0x0e0d0c0a, 0x00000004, 0x09090903, 0x051d061d, 0x0d000006, 0x00000003, 
    0x00000000, 0x00000000, 0x0006001a, 0x0005001a, 0x00000006, 0x00000000, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x120d0803, 0x28221d18, 0x3d37322d, 0x00000000, 0x00000000, 0x00000000, 
    0x05030200, 0x0a090706, 0x180f0d0c, 0x00000005, 0x0a0a0a03, 0x061f061f, 0x0e010106, 0x00000003, 
    0x00000000, 0x00000000, 0x0006001d, 0x0006001d, 0x00000006, 0x00000001, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x120d0803, 0x28221d18, 0x3d37322d, 0x00000000, 0x00000000, 0x00000000, 
    0x05040200, 0x0c0a0807, 0x19180f0d, 0x00000006, 0x0c0b0b04, 0x07280728, 0x18010107, 0x00000004, 
    0x00000000, 0x00000000, 0x00070021, 0x00070021, 0x00000007, 0x00000001, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x120d0803, 0x28221d18, 0x3d37322d, 0x00000000, 0x00000000, 0x00000000, 
    0x06040200, 0x0d0b0908, 0x1a1a190f, 0x00000008, 0x0d0d0d04, 0x08290829, 0x19010108, 0x00000004, 
    0x00000000, 0x00000000, 0x00080025, 0x00080025, 0x00000008, 0x00000001, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x120d0803, 0x28221d18, 0x3d37322d, 0x00000000, 0x00000000, 0x00000000, 
    0x07050301, 0x0f0d0b09, 0x1c1b1a19, 0x0000000a, 0x0f0f0e05, 0x092b092a, 0x1a010109, 0x00000005, 
    0x00000000, 0x00000000, 0x00090029, 0x0009002a, 0x00000009, 0x00000001, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x120d0803, 0x28221d18, 0x3d37322d, 0x00000000, 0x00000000, 0x00000000, 
    0x08050301, 0x190e0c0a, 0x1d1c1b1a, 0x0000000c, 0x19181806, 0x0a2c0b2c, 0x1c01010a, 0x00000006, 
    0x00000000, 0x00000000, 0x000b002e, 0x000a002f, 0x0000000a, 0x00000001, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x120d0803, 0x28221d18, 0x3d37322d, 0x00000000, 0x00000000, 0x00000000, 
    0x08060301, 0x1a180e0b, 0x1f1d1c1b, 0x0000000f, 0x1a191906, 0x0b2d0c2d, 0x1d01010c, 0x00000006, 
    0x00000000, 0x00000000, 0x000c0034, 0x000b0035, 0x0000000c, 0x00000001, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x120d0803, 0x28221d18, 0x3d37322d, 0x00000000, 0x00000000, 0x00000000, 
    0x0a070401, 0x1b190f0c, 0x281f1e1c, 0x00000013, 0x1b1b1a07, 0x0c2f0d2f, 0x1f02020d, 0x00000007, 
    0x00000000, 0x00000000, 0x000d003a, 0x000c003b, 0x0000000d, 0x00000002, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x120d0803, 0x28221d18, 0x3d37322d, 0x00000000, 0x00000000, 0x00000000, 
    0x0b080401, 0x1c1b190e, 0x29281f1e, 0x00000018, 0x1c1c1c08, 0x0e380f38, 0x2802020f, 0x00000008, 
    0x00000000, 0x00000000, 0x000f0042, 0x000e0043, 0x0000000f, 0x00000002, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x120d0803, 0x28221d18, 0x3d37322d, 0x00000000, 0x00000000, 0x00000000, 
    0x0c090501, 0x1e1c1a18, 0x2a2a291f, 0x0000001e, 0x1d1d1d09, 0x18391939, 0x29020219, 0x00000009, 
    0x00000000, 0x00000000, 0x0011004a, 0x0010004b, 0x00000011, 0x00000002, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x120d0803, 0x28221d18, 0x3d37322d, 0x00000000, 0x00000000, 0x00000000, 
    0x0e0a0602, 0x1f1d1b19, 0x2c2b2a29, 0x00000026, 0x1f1f1f0a, 0x193b1a3a, 0x2a03031a, 0x0000000a, 
    0x00000000, 0x00000000, 0x00130053, 0x00120054, 0x00000013, 0x00000003, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x120d0803, 0x28221d18, 0x3d37322d, 0x00000000, 0x00000000, 0x00000000, 
    0x180b0602, 0x291f1d1a, 0x2d2c2b2a, 0x00000030, 0x2928280c, 0x1a3c1b3c, 0x2c03031b, 0x0000000c, 
    0x00000000, 0x00000000, 0x0016005d, 0x0014005e, 0x00000015, 0x00000003, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x120d0803, 0x28221d18, 0x3d37322d, 0x00000000, 0x00000000, 0x00000000, 
    0x190c0702, 0x2a281e1c, 0x2f2d2c2b, 0x0000003d, 0x2a29290d, 0x1b3d1c3d, 0x2d03031c, 0x0000000d, 
    0x00000000, 0x00000000, 0x00180069, 0x0016006a, 0x00000018, 0x00000003, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x120d0803, 0x28221d18, 0x3d37322d, 0x00000000, 0x00000000, 0x00000000, 
    0x1a0e0802, 0x2b29281d, 0x382f2e2c, 0x0000004c, 0x2b2b2a0f, 0x1d3f1e3f, 0x2f04041e, 0x0000000f, 
    0x00000000, 0x00000000, 0x001b0075, 0x00190077, 0x0000001b, 0x00000004, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x120d0803, 0x28221d18, 0x3d37322d, 0x00000000, 0x00000000, 0x00000000, 
    0x1b180903, 0x2c2b291f, 0x39382f2e, 0x00000060, 0x2c2c2c19, 0x1e482848, 0x3804041f, 0x00000019, 
    0x00000000, 0x00000000, 0x001f0084, 0x001c0086, 0x0000001e, 0x00000004, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x120d0803, 0x28221d18, 0x3d37322d, 0x00000000, 0x00000000, 0x00000000, 
    0x1d190a03, 0x2e2c2a28, 0x3a3a392f, 0x00000079, 0x2d2d2d1a, 0x28492949, 0x39050529, 0x0000001a, 
    0x00000000, 0x00000000, 0x00230094, 0x00200096, 0x00000022, 0x00000005, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x120d0803, 0x28221d18, 0x3d37322d, 0x00000000, 0x00000000, 0x00000000, 
    0x1e1a0c04, 0x2f2d2b29, 0x3c3b3a39, 0x00000099, 0x2f2f2f1b, 0x294b2a4a, 0x3a06062a, 0x0000001b, 
    0x00000000, 0x00000000, 0x002700a6, 0x002400a9, 0x00000026, 0x00000006, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x120d0803, 0x28221d18, 0x3d37322d, 0x00000000, 0x00000000, 0x00000000, 
    0x281b0d04, 0x392f2d2a, 0x3d3c3b3a, 0x000000c0, 0x3938381c, 0x2a4c2b4c, 0x3c06062b, 0x0000001c, 
    0x00000000, 0x00000000, 0x002c00bb, 0x002800bd, 0x0000002b, 0x00000006, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x120d0803, 0x28221d18, 0x3d37322d, 0x00000000, 0x00000000, 0x00000000, 
    0x291d0f05, 0x3a382e2c, 0x3f3d3c3b, 0x000000f2, 0x3a39391e, 0x2b4d2c4d, 0x3d07072c, 0x0000001e, 
    0x00000000, 0x00000000, 0x003100d2, 0x002d00d5, 0x00000030, 0x00000007, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x120d0803, 0x28221d18, 0x3d37322d, 0x00000000, 0x00000000, 0x00000000, 
    0x2a1e1905, 0x3b39382d, 0x483f3e3c, 0x00000131, 0x3b3b3a1f, 0x2d4f2e4f, 0x3f08082e, 0x0000001f, 
    0x00000000, 0x00000000, 0x003700eb, 0x003300ef, 0x00000036, 0x00000008, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x120d0803, 0x28221d18, 0x3d37322d, 0x00000000, 0x00000000, 0x00000000, 
    0x2b281a06, 0x3c3b392f, 0x49483f3e, 0x00000181, 0x3c3c3c29, 0x2e583858, 0x4809092f, 0x00000029, 
    0x00000000, 0x00000000, 0x003e0108, 0x0039010c, 0x0000003d, 0x00000009, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x120d0803, 0x28221d18, 0x3d37322d, 0x00000000, 0x00000000, 0x00000000, 
    0x2d291b07, 0x3e3c3a38, 0x4a4a493f, 0x000001e5, 0x3d3d3d2a, 0x38593959, 0x490b0b39, 0x0000002a, 
    0x00000000, 0x00000000, 0x00460129, 0x0040012d, 0x00000044, 0x0000000b, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x120d0803, 0x28221d18, 0x3d37322d, 0x00000000, 0x00000000, 0x00000000, 
    0x2e2a1c08, 0x3f3d3b39, 0x4c4b4a49, 0x00000263, 0x3f3f3f2b, 0x395b3a5a, 0x4a0c0c3a, 0x0000002b, 
    0x00000000, 0x00000000, 0x004e014d, 0x00480152, 0x0000004d, 0x0000000c, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x120d0803, 0x28221d18, 0x3d37322d, 0x00000000, 0x00000000, 0x00000000, 
    0x382b1e09, 0x493f3d3a, 0x4d4c4b4a, 0x00000301, 0x4948482c, 0x3a5c3b5c, 0x4c0d0d3b, 0x0000002c, 
    0x00000000, 0x00000000, 0x00580176, 0x0051017b, 0x00000056, 0x0000000d, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x120d0803, 0x28221d18, 0x3d37322d, 0x00000000, 0x00000000, 0x00000000, 
    0x392d1f0a, 0x4a483e3c, 0x4f4d4c4b, 0x000003c9, 0x4a49492e, 0x3b5d3c5d, 0x4d0f0f3c, 0x0000002e, 
    0x00000000, 0x00000000, 0x006301a4, 0x005b01aa, 0x00000061, 0x0000000f, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x120d0803, 0x28221d18, 0x3d37322d, 0x00000000, 0x00000000, 0x00000000, 
    0x3a2e290b, 0x4b49483d, 0x584f4e4c, 0x000004c5, 0x4b4b4a2f, 0x3d5f3e5f, 0x4f19193e, 0x0000002f, 
    0x00000000, 0x00000000, 0x006f01d7, 0x006701de, 0x0000006d, 0x00000011, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x120d0803, 0x28221d18, 0x3d37322d, 0x00000000, 0x00000000, 0x00000000, 
    0x3b382a0c, 0x4c4b493f, 0x59584f4e, 0x00000602, 0x4c4c4c39, 0x3e684868, 0x581a1a3f, 0x00000039, 
    0x00000000, 0x00000000, 0x007d0211, 0x00730218, 0x0000007a, 0x00000013, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x120d0803, 0x28221d18, 0x3d37322d, 0x00000000, 0x00000000, 0x00000000, 
    0x3d392b0e, 0x4e4c4a48, 0x5a5a594f, 0x00000792, 0x4d4d4d3a, 0x48694969, 0x591b1b49, 0x0000003a, 
    0x00000000, 0x00000000, 0x008c0252, 0x0081025a, 0x00000089, 0x00000016, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x120d0803, 0x28221d18, 0x3d37322d, 0x00000000, 0x00000000, 0x00000000, 
    0x3e3a2c18, 0x4f4d4b49, 0x5c5b5a59, 0x0000098a, 0x4f4f4f3b, 0x496b4a6a, 0x5a1c1c4a, 0x0000003b, 
    0x00000000, 0x00000000, 0x009d029b, 0x009102a4, 0x0000009a, 0x00000018, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x120d0803, 0x28221d18, 0x3d37322d, 0x00000000, 0x00000000, 0x00000000, 
    0x483b2e19, 0x594f4d4a, 0x5d5c5b5a, 0x00000c05, 0x5958583c, 0x4a6c4b6c, 0x5c1e1e4b, 0x0000003c, 
    0x00000000, 0x00000000, 0x00b002ec, 0x00a302f7, 0x000000ad, 0x0000001b, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x120d0803, 0x28221d18, 0x3d37322d, 0x00000000, 0x00000000, 0x00000000, 
    0x493d2f1a, 0x5a584e4c, 0x5f5d5c5b, 0x00000f24, 0x5a59593e, 0x4b6d4c6d, 0x5d28284c, 0x0000003e, 
    0x00000000, 0x00000000, 0x00c60348, 0x00b70354, 0x000000c2, 0x0000001f, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x120d0803, 0x28221d18, 0x3d37322d, 0x00000000, 0x00000000, 0x00000000, 
    0x4a3e391c, 0x5b59584d, 0x685f5e5c, 0x00001314, 0x5b5b5a3f, 0x4d6f4e6f, 0x5f29294e, 0x0000003f, 
    0x00000000, 0x00000000, 0x00de03af, 0x00ce03bc, 0x000000da, 0x00000022, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x120d0803, 0x28221d18, 0x3d37322d, 0x00000000, 0x00000000, 0x00000000, 
    0x4b483a1d, 0x5c5b594f, 0x69685f5e, 0x00001809, 0x5c5c5c49, 0x4e785878, 0x682a2a4f, 0x00000049, 
    0x00000000, 0x00000000, 0x00fa0422, 0x00e70431, 0x000000f5, 0x00000027, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x120d0803, 0x28221d18, 0x3d37322d, 0x00000000, 0x00000000, 0x00000000, 
    0x4d493b1f, 0x5e5c5a58, 0x6a6a695f, 0x00001e49, 0x5d5d5d4a, 0x58795979, 0x692b2b59, 0x0000004a, 
    0x00000000, 0x00000000, 0x011804a4, 0x010304b5, 0x00000113, 0x0000002c, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x120d0803, 0x28221d18, 0x3d37322d, 0x00000000, 0x00000000, 0x00000000, 
    0x4e4a3c28, 0x5f5d5b59, 0x6c6b6a69, 0x00002628, 0x5f5f5f4b, 0x597b5a7a, 0x6a2c2c5a, 0x0000004b, 
    0x00000000, 0x00000000, 0x013b0536, 0x01230548, 0x00000134, 0x00000031, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x120d0803, 0x28221d18, 0x3d37322d, 0x00000000, 0x00000000, 0x00000000, 
    0x584b3e29, 0x695f5d5a, 0x6d6c6b6a, 0x00003013, 0x6968684c, 0x5a7c5b7c, 0x6c2e2e5b, 0x0000004c, 
    0x00000000, 0x00000000, 0x016105d9, 0x014705ee, 0x0000015a, 0x00000037, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x120d0803, 0x28221d18, 0x3d37322d, 0x00000000, 0x00000000, 0x00000000, 
    0x594d3f2a, 0x6a685e5c, 0x6f6d6c6b, 0x00003c92, 0x6a69694e, 0x5b7d5c7d, 0x6d38385c, 0x0000004e, 
    0x00000000, 0x00000000, 0x018c0691, 0x016f06a8, 0x00000185, 0x0000003e, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x120d0803, 0x28221d18, 0x3d37322d, 0x00000000, 0x00000000, 0x00000000, 
    0x5a4e492c, 0x6b69685d, 0x6f6f6e6c, 0x00004c50, 0x6b6b6a4f, 0x5d7f5e7f, 0x6f39395e, 0x0000004f, 
    0x00000000, 0x00000000, 0x01bd075e, 0x019c0779, 0x000001b4, 0x00000045, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x120d0803, 0x28221d18, 0x3d37322d, 0x00000000, 0x00000000, 0x00000000, 
    0x5b584a2d, 0x6c6b695f, 0x6f6f6f6e, 0x00006026, 0x6c6c6c59, 0x5e886888, 0x783a3a5f, 0x00000059, 
    0x00000000, 0x00000000, 0x01f40845, 0x01cf0863, 0x000001ea, 0x0000004e, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x120d0803, 0x28221d18, 0x3d37322d, 0x00000000, 0x00000000, 0x00000000, 
    0x5d594b2f, 0x6e6c6a68, 0x6f6f6f6f, 0x00007924, 0x6d6d6d5a, 0x68896989, 0x793b3b69, 0x0000005a, 
    0x00000000, 0x00000000, 0x02310949, 0x0207096a, 0x00000226, 0x00000058, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x120d0803, 0x28221d18, 0x3d37322d, 0x00000000, 0x00000000, 0x00000000, 
    0x5e5a4c38, 0x6f6d6b69, 0x6f6f6f6f, 0x000098a0, 0x6f6f6f5b, 0x698b6a8a, 0x7a3c3c6a, 0x0000005b, 
    0x00000000, 0x00000000, 0x02760a6c, 0x02470a91, 0x00000269, 0x00000062, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x120d0803, 0x28221d18, 0x3d37322d, 0x00000000, 0x00000000, 0x00000000, 
    0x685b4e39, 0x6f6f6d6a, 0x6f6f6f6f, 0x0000c04c, 0x7978785c, 0x6a8c6b8c, 0x7c3e3e6b, 0x0000005c, 
    0x00000000, 0x00000000, 0x02c30bb3, 0x028f0bdc, 0x000002b5, 0x0000006e, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x120d0803, 0x28221d18, 0x3d37322d, 0x00000000, 0x00000000, 0x00000000, 
    0x695d4f3a, 0x6f6f6e6c, 0x6f6f6f6f, 0x0000f247, 0x7a79795e, 0x6b8d6c8d, 0x7d48486c, 0x0000005e, 
    0x00000000, 0x00000000, 0x03190d22, 0x02df0d50, 0x0000030a, 0x0000007c, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x120d0803, 0x28221d18, 0x3d37322d, 0x00000000, 0x00000000, 0x00000000, 
    0x6a5e593c, 0x6f6f6f6d, 0x6f6f6f6f, 0x00003140, 0x7b7b7a5f, 0x6d8f6e8f, 0x7f49496e, 0x0000005f, 
    0x00000000, 0x00000000, 0x037b0ebd, 0x03390ef2, 0x00000369, 0x0000008b, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x120d0803, 0x28221d18, 0x3d37322d, 0x00000000, 0x00000000, 0x00000000, 
    0x6b685a3d, 0x6f6f6f6f, 0x6f6f6f6f, 0x00008098, 0x7c7c7c69, 0x6e8f788f, 0x884a4a6f, 0x00000069, 
    0x00000000, 0x00000000, 0x03e8108b, 0x039e10c6, 0x000003d4, 0x0000009c, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x120d0803, 0x28221d18, 0x3d37322d, 0x00000000, 0x00000000, 0x00000000, 
    0x6d695b3f, 0x6f6f6f6f, 0x6f6f6f6f, 0x0000e48f, 0x7d7d7d6a, 0x788f798f, 0x894b4b79, 0x0000006a, 
    0x00000000, 0x00000000, 0x04621292, 0x040f12d4, 0x0000044c, 0x000000b0, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x120d0803, 0x28221d18, 0x3d37322d, 0x00000000, 0x00000000, 0x00000000, 
    0x6e6a5c48, 0x6f6f6f6f, 0x6f6f6f6f, 0x00006281, 0x7f7f7f6b, 0x798f7a8f, 0x8a4c4c7a, 0x0000006b, 
    0x00000000, 0x00000000, 0x04ec14d9, 0x048f1523, 0x000004d3, 0x000000c5, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x120d0803, 0x28221d18, 0x3d37322d, 0x00000000, 0x00000000, 0x00000000, 
    0x6f6b5e49, 0x6f6f6f6f, 0x6f6f6f6f, 0x00000130, 0x8988886c, 0x7a8f7b8f, 0x8c4e4e7b, 0x0000006c, 
    0x00000000, 0x00000000, 0x05861766, 0x051e17b9, 0x0000056a, 0x000000dd, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x120d0803, 0x28221d18, 0x3d37322d, 0x00000000, 0x00000000, 0x00000000, 
    0x6f6d5f4a, 0x6f6f6f6f, 0x6f6f6f6f, 0x0000c91d, 0x8a89896e, 0x7b8f7c8f, 0x8d58587c, 0x0000006e, 
    0x00000000, 0x00000000, 0x06331a44, 0x05be1aa1, 0x00000614, 0x000000f9, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x120d0803, 0x28221d18, 0x3d37322d, 0x00000000, 0x00000000, 0x00000000, 
    0x6f6e694c, 0x6f6f6f6f, 0x6f6f6f6f, 0x0000c502, 0x8b8b8a6f, 0x7d8f7e8f, 0x8f59597e, 0x0000006f, 
    0x00000000, 0x00000000, 0x06f61d7b, 0x06721de4, 0x000006d3, 0x00000117, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x120d0803, 0x28221d18, 0x3d37322d, 0x00000000, 0x00000000, 0x00000000, 
    0x6f6f6a4d, 0x6f6f6f6f, 0x6f6f6f6f, 0x0000025f, 0x8c8c8c79, 0x7e8f888f, 0x8f5a5a7f, 0x00000079, 
    0x00000000, 0x00000000, 0x07d02117, 0x073c218d, 0x000007a9, 0x00000139, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x120d0803, 0x28221d18, 0x3d37322d, 0x00000000, 0x00000000, 0x00000000, 
    0x6f6f6b4f, 0x6f6f6f6f, 0x6f6f6f6f, 0x0000923a, 0x8d8d8d7a, 0x888f898f, 0x8f5b5b89, 0x0000007a, 
    0x00000000, 0x00000000, 0x08c52525, 0x081f25a9, 0x00000899, 0x00000160, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x120d0803, 0x28221d18, 0x3d37322d, 0x00000000, 0x00000000, 0x00000000, 
    0x03020100, 0x08060504, 0x0c0b0a09, 0x00000004, 0x09090903, 0x051d061d, 0x0d000006, 0x00000003, 
    0x00000000, 0x00000000, 0x0006001a, 0x0005001a, 0x00000006, 0x00000000, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0b0702, 0x211d1814, 0x332e2a25, 0x00000000, 0x00000000, 0x00000000, 
    0x03020100, 0x08060504, 0x0c0b0a09, 0x00000004, 0x09090903, 0x051d061d, 0x0d000006, 0x00000003, 
    0x00000000, 0x00000000, 0x0006001a, 0x0005001a, 0x00000006, 0x00000000, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0b0702, 0x211d1814, 0x332e2a25, 0x00000000, 0x00000000, 0x00000000, 
    0x03020100, 0x08060504, 0x0c0b0a09, 0x00000004, 0x09090903, 0x051d061d, 0x0d000006, 0x00000003, 
    0x00000000, 0x00000000, 0x0006001a, 0x0005001a, 0x00000006, 0x00000000, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0b0702, 0x211d1814, 0x332e2a25, 0x00000000, 0x00000000, 0x00000000, 
    0x03020100, 0x08060504, 0x0c0b0a09, 0x00000004, 0x09090903, 0x051d061d, 0x0d000006, 0x00000003, 
    0x00000000, 0x00000000, 0x0006001a, 0x0005001a, 0x00000006, 0x00000000, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0b0702, 0x211d1814, 0x332e2a25, 0x00000000, 0x00000000, 0x00000000, 
    0x03020100, 0x08060504, 0x0c0b0a09, 0x00000004, 0x09090903, 0x051d061d, 0x0d000006, 0x00000003, 
    0x00000000, 0x00000000, 0x0006001a, 0x0005001a, 0x00000006, 0x00000000, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0b0702, 0x211d1814, 0x332e2a25, 0x00000000, 0x00000000, 0x00000000, 
    0x03020100, 0x08060504, 0x0c0b0a09, 0x00000004, 0x09090903, 0x051d061d, 0x0d000006, 0x00000003, 
    0x00000000, 0x00000000, 0x0006001a, 0x0005001a, 0x00000006, 0x00000000, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0b0702, 0x211d1814, 0x332e2a25, 0x00000000, 0x00000000, 0x00000000, 
    0x03020100, 0x08060504, 0x0c0b0a09, 0x00000004, 0x09090903, 0x051d061d, 0x0d000006, 0x00000003, 
    0x00000000, 0x00000000, 0x0006001a, 0x0005001a, 0x00000006, 0x00000000, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0b0702, 0x211d1814, 0x332e2a25, 0x00000000, 0x00000000, 0x00000000, 
    0x03020100, 0x08060504, 0x0c0b0a09, 0x00000004, 0x09090903, 0x051d061d, 0x0d000006, 0x00000003, 
    0x00000000, 0x00000000, 0x0006001a, 0x0005001a, 0x00000006, 0x00000000, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0b0702, 0x211d1814, 0x332e2a25, 0x00000000, 0x00000000, 0x00000000, 
    0x03020100, 0x08060504, 0x0c0b0a09, 0x00000004, 0x09090903, 0x051d061d, 0x0d000006, 0x00000003, 
    0x00000000, 0x00000000, 0x0006001a, 0x0005001a, 0x00000006, 0x00000000, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0b0702, 0x211d1814, 0x332e2a25, 0x00000000, 0x00000000, 0x00000000, 
    0x03020100, 0x08060504, 0x0c0b0a09, 0x00000004, 0x09090903, 0x051d061d, 0x0d000006, 0x00000003, 
    0x00000000, 0x00000000, 0x0006001a, 0x0005001a, 0x00000006, 0x00000000, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0b0702, 0x211d1814, 0x332e2a25, 0x00000000, 0x00000000, 0x00000000, 
    0x03020100, 0x08060504, 0x0c0b0a09, 0x00000004, 0x09090903, 0x051d061d, 0x0d000006, 0x00000003, 
    0x00000000, 0x00000000, 0x0006001a, 0x0005001a, 0x00000006, 0x00000000, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0b0702, 0x211d1814, 0x332e2a25, 0x00000000, 0x00000000, 0x00000000, 
    0x03020100, 0x08060504, 0x0c0b0a09, 0x00000004, 0x09090903, 0x051d061d, 0x0d000006, 0x00000003, 
    0x00000000, 0x00000000, 0x0006001a, 0x0005001a, 0x00000006, 0x00000000, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0b0702, 0x211d1814, 0x332e2a25, 0x00000000, 0x00000000, 0x00000000, 
    0x03020100, 0x08060504, 0x0c0b0a09, 0x00000004, 0x09090903, 0x051d061d, 0x0d000006, 0x00000003, 
    0x00000000, 0x00000000, 0x0006001a, 0x0005001a, 0x00000006, 0x00000000, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0b0702, 0x211d1814, 0x332e2a25, 0x00000000, 0x00000000, 0x00000000, 
    0x04030100, 0x09070605, 0x0d0c0b0a, 0x00000005, 0x0a0a0a03, 0x061f061f, 0x0e010106, 0x00000003, 
    0x00000000, 0x00000000, 0x0006001d, 0x0006001d, 0x00000006, 0x00000001, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0b0702, 0x211d1814, 0x332e2a25, 0x00000000, 0x00000000, 0x00000000, 
    0x04030200, 0x0a080706, 0x0f0e0c0b, 0x00000006, 0x0c0b0b04, 0x07280728, 0x18010107, 0x00000004, 
    0x00000000, 0x00000000, 0x00070021, 0x00070021, 0x00000007, 0x00000001, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0b0702, 0x211d1814, 0x332e2a25, 0x00000000, 0x00000000, 0x00000000, 
    0x05030200, 0x0b090806, 0x190f0e0c, 0x00000008, 0x0d0d0d04, 0x08290829, 0x19010108, 0x00000004, 
    0x00000000, 0x00000000, 0x00080025, 0x00080025, 0x00000008, 0x00000001, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0b0702, 0x211d1814, 0x332e2a25, 0x00000000, 0x00000000, 0x00000000, 
    0x05040200, 0x0c0b0907, 0x1a19180e, 0x0000000a, 0x0f0f0e05, 0x092b092a, 0x1a010109, 0x00000005, 
    0x00000000, 0x00000000, 0x00090029, 0x0009002a, 0x00000009, 0x00000001, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0b0702, 0x211d1814, 0x332e2a25, 0x00000000, 0x00000000, 0x00000000, 
    0x06040200, 0x0e0c0a08, 0x1b1a1918, 0x0000000c, 0x19181806, 0x0a2c0b2c, 0x1c01010a, 0x00000006, 
    0x00000000, 0x00000000, 0x000b002e, 0x000a002f, 0x0000000a, 0x00000001, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0b0702, 0x211d1814, 0x332e2a25, 0x00000000, 0x00000000, 0x00000000, 
    0x07050301, 0x180d0b09, 0x1c1b1a19, 0x0000000f, 0x1a191906, 0x0b2d0c2d, 0x1d01010c, 0x00000006, 
    0x00000000, 0x00000000, 0x000c0034, 0x000b0035, 0x0000000c, 0x00000001, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0b0702, 0x211d1814, 0x332e2a25, 0x00000000, 0x00000000, 0x00000000, 
    0x08060301, 0x190f0d0a, 0x1e1d1b1a, 0x00000013, 0x1b1b1a07, 0x0c2f0d2f, 0x1f02020d, 0x00000007, 
    0x00000000, 0x00000000, 0x000d003a, 0x000c003b, 0x0000000d, 0x00000002, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0b0702, 0x211d1814, 0x332e2a25, 0x00000000, 0x00000000, 0x00000000, 
    0x09060401, 0x1a190e0c, 0x281e1d1b, 0x00000018, 0x1c1c1c08, 0x0e380f38, 0x2802020f, 0x00000008, 
    0x00000000, 0x00000000, 0x000f0042, 0x000e0043, 0x0000000f, 0x00000002, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0b0702, 0x211d1814, 0x332e2a25, 0x00000000, 0x00000000, 0x00000000, 
    0x0a070401, 0x1b1a180d, 0x29281e1d, 0x0000001e, 0x1d1d1d09, 0x18391939, 0x29020219, 0x00000009, 
    0x00000000, 0x00000000, 0x0011004a, 0x0010004b, 0x00000011, 0x00000002, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0b0702, 0x211d1814, 0x332e2a25, 0x00000000, 0x00000000, 0x00000000, 
    0x0b080501, 0x1d1b190f, 0x2a29281e, 0x00000026, 0x1f1f1f0a, 0x193b1a3a, 0x2a03031a, 0x0000000a, 
    0x00000000, 0x00000000, 0x00130053, 0x00120054, 0x00000013, 0x00000003, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0b0702, 0x211d1814, 0x332e2a25, 0x00000000, 0x00000000, 0x00000000, 
    0x0d090501, 0x1e1c1a19, 0x2b2a2928, 0x00000030, 0x2928280c, 0x1a3c1b3c, 0x2c03031b, 0x0000000c, 
    0x00000000, 0x00000000, 0x0016005d, 0x0014005e, 0x00000015, 0x00000003, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0b0702, 0x211d1814, 0x332e2a25, 0x00000000, 0x00000000, 0x00000000, 
    0x0e0a0602, 0x281e1c1a, 0x2c2b2a29, 0x0000003d, 0x2a29290d, 0x1b3d1c3d, 0x2d03031c, 0x0000000d, 
    0x00000000, 0x00000000, 0x00180069, 0x0016006a, 0x00000018, 0x00000003, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0b0702, 0x211d1814, 0x332e2a25, 0x00000000, 0x00000000, 0x00000000, 
    0x180c0702, 0x29281d1b, 0x2e2d2b2a, 0x0000004c, 0x2b2b2a0f, 0x1d3f1e3f, 0x2f04041e, 0x0000000f, 
    0x00000000, 0x00000000, 0x001b0075, 0x00190077, 0x0000001b, 0x00000004, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0b0702, 0x211d1814, 0x332e2a25, 0x00000000, 0x00000000, 0x00000000, 
    0x190d0802, 0x2a291f1c, 0x382e2d2b, 0x00000060, 0x2c2c2c19, 0x1e482848, 0x3804041f, 0x00000019, 
    0x00000000, 0x00000000, 0x001f0084, 0x001c0086, 0x0000001e, 0x00000004, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0b0702, 0x211d1814, 0x332e2a25, 0x00000000, 0x00000000, 0x00000000, 
    0x1b0f0903, 0x2b2a281e, 0x39382e2d, 0x00000079, 0x2d2d2d1a, 0x28492949, 0x39050529, 0x0000001a, 
    0x00000000, 0x00000000, 0x00230094, 0x00200096, 0x00000022, 0x00000005, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0b0702, 0x211d1814, 0x332e2a25, 0x00000000, 0x00000000, 0x00000000, 
    0x1c180a03, 0x2d2b291f, 0x3a39382e, 0x00000099, 0x2f2f2f1b, 0x294b2a4a, 0x3a06062a, 0x0000001b, 
    0x00000000, 0x00000000, 0x002700a6, 0x002400a9, 0x00000026, 0x00000006, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0b0702, 0x211d1814, 0x332e2a25, 0x00000000, 0x00000000, 0x00000000, 
    0x1d1a0b03, 0x2e2c2a29, 0x3b3a3938, 0x000000c0, 0x3938381c, 0x2a4c2b4c, 0x3c06062b, 0x0000001c, 
    0x00000000, 0x00000000, 0x002c00bb, 0x002800bd, 0x0000002b, 0x00000006, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0b0702, 0x211d1814, 0x332e2a25, 0x00000000, 0x00000000, 0x00000000, 
    0x1f1b0c04, 0x382e2c2a, 0x3c3b3a39, 0x000000f2, 0x3a39391e, 0x2b4d2c4d, 0x3d07072c, 0x0000001e, 
    0x00000000, 0x00000000, 0x003100d2, 0x002d00d5, 0x00000030, 0x00000007, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0b0702, 0x211d1814, 0x332e2a25, 0x00000000, 0x00000000, 0x00000000, 
    0x281c0e04, 0x39382d2b, 0x3e3d3b3a, 0x00000131, 0x3b3b3a1f, 0x2d4f2e4f, 0x3f08082e, 0x0000001f, 
    0x00000000, 0x00000000, 0x003700eb, 0x003300ef, 0x00000036, 0x00000008, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0b0702, 0x211d1814, 0x332e2a25, 0x00000000, 0x00000000, 0x00000000, 
    0x291d1805, 0x3a392f2c, 0x483e3d3b, 0x00000181, 0x3c3c3c29, 0x2e583858, 0x4809092f, 0x00000029, 
    0x00000000, 0x00000000, 0x003e0108, 0x0039010c, 0x0000003d, 0x00000009, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0b0702, 0x211d1814, 0x332e2a25, 0x00000000, 0x00000000, 0x00000000, 
    0x2b1f1906, 0x3b3a382e, 0x49483e3d, 0x000001e5, 0x3d3d3d2a, 0x38593959, 0x490b0b39, 0x0000002a, 
    0x00000000, 0x00000000, 0x00460129, 0x0040012d, 0x00000044, 0x0000000b, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0b0702, 0x211d1814, 0x332e2a25, 0x00000000, 0x00000000, 0x00000000, 
    0x2c281a06, 0x3d3b392f, 0x4a49483e, 0x00000263, 0x3f3f3f2b, 0x395b3a5a, 0x4a0c0c3a, 0x0000002b, 
    0x00000000, 0x00000000, 0x004e014d, 0x00480152, 0x0000004d, 0x0000000c, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0b0702, 0x211d1814, 0x332e2a25, 0x00000000, 0x00000000, 0x00000000, 
    0x2d2a1b07, 0x3e3c3a39, 0x4b4a4948, 0x00000301, 0x4948482c, 0x3a5c3b5c, 0x4c0d0d3b, 0x0000002c, 
    0x00000000, 0x00000000, 0x00580176, 0x0051017b, 0x00000056, 0x0000000d, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0b0702, 0x211d1814, 0x332e2a25, 0x00000000, 0x00000000, 0x00000000, 
    0x2f2b1d08, 0x483e3c3a, 0x4c4b4a49, 0x000003c9, 0x4a49492e, 0x3b5d3c5d, 0x4d0f0f3c, 0x0000002e, 
    0x00000000, 0x00000000, 0x006301a4, 0x005b01aa, 0x00000061, 0x0000000f, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0b0702, 0x211d1814, 0x332e2a25, 0x00000000, 0x00000000, 0x00000000, 
    0x382c1e09, 0x49483d3b, 0x4e4d4b4a, 0x000004c5, 0x4b4b4a2f, 0x3d5f3e5f, 0x4f19193e, 0x0000002f, 
    0x00000000, 0x00000000, 0x006f01d7, 0x006701de, 0x0000006d, 0x00000011, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0b0702, 0x211d1814, 0x332e2a25, 0x00000000, 0x00000000, 0x00000000, 
    0x392d280a, 0x4a493f3c, 0x584e4d4b, 0x00000602, 0x4c4c4c39, 0x3e684868, 0x581a1a3f, 0x00000039, 
    0x00000000, 0x00000000, 0x007d0211, 0x00730218, 0x0000007a, 0x00000013, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0b0702, 0x211d1814, 0x332e2a25, 0x00000000, 0x00000000, 0x00000000, 
    0x3b2f290c, 0x4b4a483e, 0x59584e4d, 0x00000792, 0x4d4d4d3a, 0x48694969, 0x591b1b49, 0x0000003a, 
    0x00000000, 0x00000000, 0x008c0252, 0x0081025a, 0x00000089, 0x00000016, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0b0702, 0x211d1814, 0x332e2a25, 0x00000000, 0x00000000, 0x00000000, 
    0x3c382a0d, 0x4d4b493f, 0x5a59584e, 0x0000098a, 0x4f4f4f3b, 0x496b4a6a, 0x5a1c1c4a, 0x0000003b, 
    0x00000000, 0x00000000, 0x009d029b, 0x009102a4, 0x0000009a, 0x00000018, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0b0702, 0x211d1814, 0x332e2a25, 0x00000000, 0x00000000, 0x00000000, 
    0x3d3a2b0f, 0x4e4c4a49, 0x5b5a5958, 0x00000c05, 0x5958583c, 0x4a6c4b6c, 0x5c1e1e4b, 0x0000003c, 
    0x00000000, 0x00000000, 0x00b002ec, 0x00a302f7, 0x000000ad, 0x0000001b, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0b0702, 0x211d1814, 0x332e2a25, 0x00000000, 0x00000000, 0x00000000, 
    0x3f3b2d19, 0x584e4c4a, 0x5c5b5a59, 0x00000f24, 0x5a59593e, 0x4b6d4c6d, 0x5d28284c, 0x0000003e, 
    0x00000000, 0x00000000, 0x00c60348, 0x00b70354, 0x000000c2, 0x0000001f, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0b0702, 0x211d1814, 0x332e2a25, 0x00000000, 0x00000000, 0x00000000, 
    0x483c2e1a, 0x59584d4b, 0x5e5d5b5a, 0x00001314, 0x5b5b5a3f, 0x4d6f4e6f, 0x5f29294e, 0x0000003f, 
    0x00000000, 0x00000000, 0x00de03af, 0x00ce03bc, 0x000000da, 0x00000022, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0b0702, 0x211d1814, 0x332e2a25, 0x00000000, 0x00000000, 0x00000000, 
    0x493d381b, 0x5a594f4c, 0x685e5d5b, 0x00001809, 0x5c5c5c49, 0x4e785878, 0x682a2a4f, 0x00000049, 
    0x00000000, 0x00000000, 0x00fa0422, 0x00e70431, 0x000000f5, 0x00000027, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0b0702, 0x211d1814, 0x332e2a25, 0x00000000, 0x00000000, 0x00000000, 
    0x4b3f391c, 0x5b5a584e, 0x69685e5d, 0x00001e49, 0x5d5d5d4a, 0x58795979, 0x692b2b59, 0x0000004a, 
    0x00000000, 0x00000000, 0x011804a4, 0x010304b5, 0x00000113, 0x0000002c, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0b0702, 0x211d1814, 0x332e2a25, 0x00000000, 0x00000000, 0x00000000, 
    0x4c483a1e, 0x5d5b594f, 0x6a69685e, 0x00002628, 0x5f5f5f4b, 0x597b5a7a, 0x6a2c2c5a, 0x0000004b, 
    0x00000000, 0x00000000, 0x013b0536, 0x01230548, 0x00000134, 0x00000031, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0b0702, 0x211d1814, 0x332e2a25, 0x00000000, 0x00000000, 0x00000000, 
    0x4d4a3b1f, 0x5e5c5a59, 0x6b6a6968, 0x00003013, 0x6968684c, 0x5a7c5b7c, 0x6c2e2e5b, 0x0000004c, 
    0x00000000, 0x00000000, 0x016105d9, 0x014705ee, 0x0000015a, 0x00000037, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0b0702, 0x211d1814, 0x332e2a25, 0x00000000, 0x00000000, 0x00000000, 
    0x4f4b3d29, 0x685e5c5a, 0x6c6b6a69, 0x00003c92, 0x6a69694e, 0x5b7d5c7d, 0x6d38385c, 0x0000004e, 
    0x00000000, 0x00000000, 0x018c0691, 0x016f06a8, 0x00000185, 0x0000003e, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0b0702, 0x211d1814, 0x332e2a25, 0x00000000, 0x00000000, 0x00000000, 
    0x584c3e2a, 0x69685d5b, 0x6e6d6b6a, 0x00004c50, 0x6b6b6a4f, 0x5d7f5e7f, 0x6f39395e, 0x0000004f, 
    0x00000000, 0x00000000, 0x01bd075e, 0x019c0779, 0x000001b4, 0x00000045, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0b0702, 0x211d1814, 0x332e2a25, 0x00000000, 0x00000000, 0x00000000, 
    0x594d482b, 0x6a695f5c, 0x6f6e6d6b, 0x00006026, 0x6c6c6c59, 0x5e886888, 0x783a3a5f, 0x00000059, 
    0x00000000, 0x00000000, 0x01f40845, 0x01cf0863, 0x000001ea, 0x0000004e, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0b0702, 0x211d1814, 0x332e2a25, 0x00000000, 0x00000000, 0x00000000, 
    0x5b4f492c, 0x6b6a685e, 0x6f6f6e6d, 0x00007924, 0x6d6d6d5a, 0x68896989, 0x793b3b69, 0x0000005a, 
    0x00000000, 0x00000000, 0x02310949, 0x0207096a, 0x00000226, 0x00000058, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0b0702, 0x211d1814, 0x332e2a25, 0x00000000, 0x00000000, 0x00000000, 
    0x5c584a2e, 0x6d6b695f, 0x6f6f6f6e, 0x000098a0, 0x6f6f6f5b, 0x698b6a8a, 0x7a3c3c6a, 0x0000005b, 
    0x00000000, 0x00000000, 0x02760a6c, 0x02470a91, 0x00000269, 0x00000062, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0b0702, 0x211d1814, 0x332e2a25, 0x00000000, 0x00000000, 0x00000000, 
    0x5d5a4b2f, 0x6e6c6a69, 0x6f6f6f6f, 0x0000c04c, 0x7978785c, 0x6a8c6b8c, 0x7c3e3e6b, 0x0000005c, 
    0x00000000, 0x00000000, 0x02c30bb3, 0x028f0bdc, 0x000002b5, 0x0000006e, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0b0702, 0x211d1814, 0x332e2a25, 0x00000000, 0x00000000, 0x00000000, 
    0x5f5b4d39, 0x6f6e6c6a, 0x6f6f6f6f, 0x0000f247, 0x7a79795e, 0x6b8d6c8d, 0x7d48486c, 0x0000005e, 
    0x00000000, 0x00000000, 0x03190d22, 0x02df0d50, 0x0000030a, 0x0000007c, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0b0702, 0x211d1814, 0x332e2a25, 0x00000000, 0x00000000, 0x00000000, 
    0x685c4e3a, 0x6f6f6d6b, 0x6f6f6f6f, 0x00003140, 0x7b7b7a5f, 0x6d8f6e8f, 0x7f49496e, 0x0000005f, 
    0x00000000, 0x00000000, 0x037b0ebd, 0x03390ef2, 0x00000369, 0x0000008b, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0b0702, 0x211d1814, 0x332e2a25, 0x00000000, 0x00000000, 0x00000000, 
    0x695d583b, 0x6f6f6f6c, 0x6f6f6f6f, 0x00008098, 0x7c7c7c69, 0x6e8f788f, 0x884a4a6f, 0x00000069, 
    0x00000000, 0x00000000, 0x03e8108b, 0x039e10c6, 0x000003d4, 0x0000009c, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0b0702, 0x211d1814, 0x332e2a25, 0x00000000, 0x00000000, 0x00000000, 
    0x6b5f593c, 0x6f6f6f6e, 0x6f6f6f6f, 0x0000e48f, 0x7d7d7d6a, 0x788f798f, 0x894b4b79, 0x0000006a, 
    0x00000000, 0x00000000, 0x04621292, 0x040f12d4, 0x0000044c, 0x000000b0, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0b0702, 0x211d1814, 0x332e2a25, 0x00000000, 0x00000000, 0x00000000, 
    0x6c685a3e, 0x6f6f6f6f, 0x6f6f6f6f, 0x00006281, 0x7f7f7f6b, 0x798f7a8f, 0x8a4c4c7a, 0x0000006b, 
    0x00000000, 0x00000000, 0x04ec14d9, 0x048f1523, 0x000004d3, 0x000000c5, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0b0702, 0x211d1814, 0x332e2a25, 0x00000000, 0x00000000, 0x00000000, 
    0x6d6a5b3f, 0x6f6f6f6f, 0x6f6f6f6f, 0x00000130, 0x8988886c, 0x7a8f7b8f, 0x8c4e4e7b, 0x0000006c, 
    0x00000000, 0x00000000, 0x05861766, 0x051e17b9, 0x0000056a, 0x000000dd, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0b0702, 0x211d1814, 0x332e2a25, 0x00000000, 0x00000000, 0x00000000, 
    0x6f6b5d49, 0x6f6f6f6f, 0x6f6f6f6f, 0x0000c91d, 0x8a89896e, 0x7b8f7c8f, 0x8d58587c, 0x0000006e, 
    0x00000000, 0x00000000, 0x06331a44, 0x05be1aa1, 0x00000614, 0x000000f9, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0b0702, 0x211d1814, 0x332e2a25, 0x00000000, 0x00000000, 0x00000000, 
    0x6f6c5e4a, 0x6f6f6f6f, 0x6f6f6f6f, 0x0000c502, 0x8b8b8a6f, 0x7d8f7e8f, 0x8f59597e, 0x0000006f, 
    0x00000000, 0x00000000, 0x06f61d7b, 0x06721de4, 0x000006d3, 0x00000117, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0b0702, 0x211d1814, 0x332e2a25, 0x00000000, 0x00000000, 0x00000000, 
    0x6f6d684b, 0x6f6f6f6f, 0x6f6f6f6f, 0x0000025f, 0x8c8c8c79, 0x7e8f888f, 0x8f5a5a7f, 0x00000079, 
    0x00000000, 0x00000000, 0x07d02117, 0x073c218d, 0x000007a9, 0x00000139, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0b0702, 0x211d1814, 0x332e2a25, 0x00000000, 0x00000000, 0x00000000, 
    0x6f6f694c, 0x6f6f6f6f, 0x6f6f6f6f, 0x0000923a, 0x8d8d8d7a, 0x888f898f, 0x8f5b5b89, 0x0000007a, 
    0x00000000, 0x00000000, 0x08c52525, 0x081f25a9, 0x00000899, 0x00000160, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0b0702, 0x211d1814, 0x332e2a25, 0x00000000, 0x00000000, 0x00000000, 
    0x03020100, 0x06050504, 0x0a090807, 0x00000003, 0x08080803, 0x051c051c, 0x0b000005, 0x00000003, 
    0x00000000, 0x00000000, 0x00050017, 0x00050017, 0x00000005, 0x00000000, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0a0602, 0x1f1b1713, 0x302c2824, 0x00000000, 0x00000000, 0x00000000, 
    0x03020100, 0x06050504, 0x0a090807, 0x00000003, 0x08080803, 0x051c051c, 0x0b000005, 0x00000003, 
    0x00000000, 0x00000000, 0x00050017, 0x00050017, 0x00000005, 0x00000000, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0a0602, 0x1f1b1713, 0x302c2824, 0x00000000, 0x00000000, 0x00000000, 
    0x03020100, 0x06050504, 0x0a090807, 0x00000003, 0x08080803, 0x051c051c, 0x0b000005, 0x00000003, 
    0x00000000, 0x00000000, 0x00050017, 0x00050017, 0x00000005, 0x00000000, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0a0602, 0x1f1b1713, 0x302c2824, 0x00000000, 0x00000000, 0x00000000, 
    0x03020100, 0x06050504, 0x0a090807, 0x00000003, 0x08080803, 0x051c051c, 0x0b000005, 0x00000003, 
    0x00000000, 0x00000000, 0x00050017, 0x00050017, 0x00000005, 0x00000000, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0a0602, 0x1f1b1713, 0x302c2824, 0x00000000, 0x00000000, 0x00000000, 
    0x03020100, 0x06050504, 0x0a090807, 0x00000003, 0x08080803, 0x051c051c, 0x0b000005, 0x00000003, 
    0x00000000, 0x00000000, 0x00050017, 0x00050017, 0x00000005, 0x00000000, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0a0602, 0x1f1b1713, 0x302c2824, 0x00000000, 0x00000000, 0x00000000, 
    0x03020100, 0x06050504, 0x0a090807, 0x00000003, 0x08080803, 0x051c051c, 0x0b000005, 0x00000003, 
    0x00000000, 0x00000000, 0x00050017, 0x00050017, 0x00000005, 0x00000000, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0a0602, 0x1f1b1713, 0x302c2824, 0x00000000, 0x00000000, 0x00000000, 
    0x03020100, 0x06050504, 0x0a090807, 0x00000003, 0x08080803, 0x051c051c, 0x0b000005, 0x00000003, 
    0x00000000, 0x00000000, 0x00050017, 0x00050017, 0x00000005, 0x00000000, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0a0602, 0x1f1b1713, 0x302c2824, 0x00000000, 0x00000000, 0x00000000, 
    0x03020100, 0x06050504, 0x0a090807, 0x00000003, 0x08080803, 0x051c051c, 0x0b000005, 0x00000003, 
    0x00000000, 0x00000000, 0x00050017, 0x00050017, 0x00000005, 0x00000000, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0a0602, 0x1f1b1713, 0x302c2824, 0x00000000, 0x00000000, 0x00000000, 
    0x03020100, 0x06050504, 0x0a090807, 0x00000003, 0x08080803, 0x051c051c, 0x0b000005, 0x00000003, 
    0x00000000, 0x00000000, 0x00050017, 0x00050017, 0x00000005, 0x00000000, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0a0602, 0x1f1b1713, 0x302c2824, 0x00000000, 0x00000000, 0x00000000, 
    0x03020100, 0x06050504, 0x0a090807, 0x00000003, 0x08080803, 0x051c051c, 0x0b000005, 0x00000003, 
    0x00000000, 0x00000000, 0x00050017, 0x00050017, 0x00000005, 0x00000000, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0a0602, 0x1f1b1713, 0x302c2824, 0x00000000, 0x00000000, 0x00000000, 
    0x03020100, 0x06050504, 0x0a090807, 0x00000003, 0x08080803, 0x051c051c, 0x0b000005, 0x00000003, 
    0x00000000, 0x00000000, 0x00050017, 0x00050017, 0x00000005, 0x00000000, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0a0602, 0x1f1b1713, 0x302c2824, 0x00000000, 0x00000000, 0x00000000, 
    0x03020100, 0x06050504, 0x0a090807, 0x00000003, 0x08080803, 0x051c051c, 0x0b000005, 0x00000003, 
    0x00000000, 0x00000000, 0x00050017, 0x00050017, 0x00000005, 0x00000000, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0a0602, 0x1f1b1713, 0x302c2824, 0x00000000, 0x00000000, 0x00000000, 
    0x03020100, 0x06050504, 0x0a090807, 0x00000003, 0x08080803, 0x051c051c, 0x0b000005, 0x00000003, 
    0x00000000, 0x00000000, 0x00050017, 0x00050017, 0x00000005, 0x00000000, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0a0602, 0x1f1b1713, 0x302c2824, 0x00000000, 0x00000000, 0x00000000, 
    0x03020100, 0x07060504, 0x0b0a0908, 0x00000004, 0x09090903, 0x051d061d, 0x0d000006, 0x00000003, 
    0x00000000, 0x00000000, 0x0006001a, 0x0005001a, 0x00000006, 0x00000000, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0a0602, 0x1f1b1713, 0x302c2824, 0x00000000, 0x00000000, 0x00000000, 
    0x04020100, 0x08070605, 0x0d0c0a09, 0x00000005, 0x0a0a0a03, 0x061f071f, 0x0e010106, 0x00000003, 
    0x00000000, 0x00000000, 0x0007001d, 0x0006001e, 0x00000006, 0x00000001, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0a0602, 0x1f1b1713, 0x302c2824, 0x00000000, 0x00000000, 0x00000000, 
    0x04030100, 0x09080705, 0x0e0d0c0a, 0x00000006, 0x0c0c0b04, 0x07280728, 0x18010107, 0x00000004, 
    0x00000000, 0x00000000, 0x00070021, 0x00070021, 0x00000007, 0x00000001, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0a0602, 0x1f1b1713, 0x302c2824, 0x00000000, 0x00000000, 0x00000000, 
    0x05030200, 0x0a090706, 0x180f0d0c, 0x00000008, 0x0d0d0d04, 0x08290829, 0x19010108, 0x00000004, 
    0x00000000, 0x00000000, 0x00080025, 0x00080025, 0x00000008, 0x00000001, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0a0602, 0x1f1b1713, 0x302c2824, 0x00000000, 0x00000000, 0x00000000, 
    0x05040200, 0x0c0a0807, 0x19190f0d, 0x0000000a, 0x0f0f0e05, 0x092b092a, 0x1a010109, 0x00000005, 
    0x00000000, 0x00000000, 0x00090029, 0x0009002a, 0x00000009, 0x00000001, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0a0602, 0x1f1b1713, 0x302c2824, 0x00000000, 0x00000000, 0x00000000, 
    0x06040200, 0x0d0b0a08, 0x1a1a190f, 0x0000000c, 0x19191806, 0x0a2c0b2c, 0x1c01010a, 0x00000006, 
    0x00000000, 0x00000000, 0x000b002f, 0x000a002f, 0x0000000a, 0x00000001, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0a0602, 0x1f1b1713, 0x302c2824, 0x00000000, 0x00000000, 0x00000000, 
    0x07050301, 0x0f0d0b09, 0x1c1b1a19, 0x0000000f, 0x1a1a1906, 0x0b2d0c2d, 0x1d01010c, 0x00000006, 
    0x00000000, 0x00000000, 0x000c0034, 0x000b0035, 0x0000000c, 0x00000001, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0a0602, 0x1f1b1713, 0x302c2824, 0x00000000, 0x00000000, 0x00000000, 
    0x08050301, 0x190e0c0a, 0x1d1c1b1a, 0x00000013, 0x1b1b1a07, 0x0c2f0e2f, 0x1f02020d, 0x00000007, 
    0x00000000, 0x00000000, 0x000e003b, 0x000c003c, 0x0000000d, 0x00000002, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0a0602, 0x1f1b1713, 0x302c2824, 0x00000000, 0x00000000, 0x00000000, 
    0x09060301, 0x1a180e0b, 0x1f1e1c1b, 0x00000018, 0x1c1c1c08, 0x0e380f38, 0x2802020f, 0x00000008, 
    0x00000000, 0x00000000, 0x000f0042, 0x000e0043, 0x0000000f, 0x00000002, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0a0602, 0x1f1b1713, 0x302c2824, 0x00000000, 0x00000000, 0x00000000, 
    0x0a070401, 0x1b190f0d, 0x281f1e1c, 0x0000001f, 0x1e1d1d09, 0x18391939, 0x29020219, 0x00000009, 
    0x00000000, 0x00000000, 0x0011004a, 0x0010004b, 0x00000011, 0x00000002, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0a0602, 0x1f1b1713, 0x302c2824, 0x00000000, 0x00000000, 0x00000000, 
    0x0b080401, 0x1c1b190e, 0x29291f1e, 0x00000027, 0x1f1f1f0a, 0x193b1a3a, 0x2a03031a, 0x0000000a, 
    0x00000000, 0x00000000, 0x00130053, 0x00120055, 0x00000013, 0x00000003, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0a0602, 0x1f1b1713, 0x302c2824, 0x00000000, 0x00000000, 0x00000000, 
    0x0c090501, 0x1e1c1a18, 0x2a2a291f, 0x00000031, 0x2929280c, 0x1a3c1b3c, 0x2c03031b, 0x0000000c, 
    0x00000000, 0x00000000, 0x0016005e, 0x0014005f, 0x00000015, 0x00000003, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0a0602, 0x1f1b1713, 0x302c2824, 0x00000000, 0x00000000, 0x00000000, 
    0x0e0a0602, 0x1f1d1b19, 0x2c2b2a29, 0x0000003d, 0x2a2a290d, 0x1c3d1c3d, 0x2d03031c, 0x0000000d, 
    0x00000000, 0x00000000, 0x00180069, 0x0017006b, 0x00000018, 0x00000003, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0a0602, 0x1f1b1713, 0x302c2824, 0x00000000, 0x00000000, 0x00000000, 
    0x180b0602, 0x291f1d1a, 0x2d2c2b2a, 0x0000004d, 0x2b2b2a0f, 0x1d3f1e3f, 0x2f04041e, 0x0000000f, 
    0x00000000, 0x00000000, 0x001c0076, 0x00190078, 0x0000001b, 0x00000004, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0a0602, 0x1f1b1713, 0x302c2824, 0x00000000, 0x00000000, 0x00000000, 
    0x190c0702, 0x2a281e1c, 0x2f2e2c2b, 0x00000061, 0x2c2c2c19, 0x1f482848, 0x3804041f, 0x00000019, 
    0x00000000, 0x00000000, 0x001f0085, 0x001d0087, 0x0000001e, 0x00000004, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0a0602, 0x1f1b1713, 0x302c2824, 0x00000000, 0x00000000, 0x00000000, 
    0x1a0e0802, 0x2b29281d, 0x382f2e2c, 0x0000007b, 0x2e2d2d1a, 0x28492949, 0x39050529, 0x0000001a, 
    0x00000000, 0x00000000, 0x00230095, 0x00200097, 0x00000022, 0x00000005, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0a0602, 0x1f1b1713, 0x302c2824, 0x00000000, 0x00000000, 0x00000000, 
    0x1b180903, 0x2c2b291f, 0x39392f2e, 0x0000009b, 0x2f2f2f1b, 0x294b2a4a, 0x3a06062a, 0x0000001b, 
    0x00000000, 0x00000000, 0x002700a7, 0x002400aa, 0x00000026, 0x00000006, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0a0602, 0x1f1b1713, 0x302c2824, 0x00000000, 0x00000000, 0x00000000, 
    0x1d190a03, 0x2e2c2a28, 0x3a3a392f, 0x000000c3, 0x3939381c, 0x2a4c2b4c, 0x3c06062b, 0x0000001c, 
    0x00000000, 0x00000000, 0x002c00bc, 0x002900be, 0x0000002b, 0x00000006, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0a0602, 0x1f1b1713, 0x302c2824, 0x00000000, 0x00000000, 0x00000000, 
    0x1e1a0c04, 0x2f2d2b29, 0x3c3b3a39, 0x000000f5, 0x3a3a391e, 0x2c4d2c4d, 0x3d07072c, 0x0000001e, 
    0x00000000, 0x00000000, 0x003100d3, 0x002e00d6, 0x00000030, 0x00000007, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0a0602, 0x1f1b1713, 0x302c2824, 0x00000000, 0x00000000, 0x00000000, 
    0x281b0d04, 0x392f2d2a, 0x3d3c3b3a, 0x00000135, 0x3b3b3a1f, 0x2d4f2e4f, 0x3f08082e, 0x0000001f, 
    0x00000000, 0x00000000, 0x003800ed, 0x003300f0, 0x00000036, 0x00000008, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0a0602, 0x1f1b1713, 0x302c2824, 0x00000000, 0x00000000, 0x00000000, 
    0x291d0f05, 0x3a382e2c, 0x3f3e3c3b, 0x00000185, 0x3c3c3c29, 0x2f583858, 0x4809092f, 0x00000029, 
    0x00000000, 0x00000000, 0x003e010a, 0x003a010e, 0x0000003d, 0x00000009, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0a0602, 0x1f1b1713, 0x302c2824, 0x00000000, 0x00000000, 0x00000000, 
    0x2a1e1905, 0x3b39382d, 0x483f3e3c, 0x000001eb, 0x3e3d3d2a, 0x38593959, 0x490b0b39, 0x0000002a, 
    0x00000000, 0x00000000, 0x0046012b, 0x0041012f, 0x00000045, 0x0000000b, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0a0602, 0x1f1b1713, 0x302c2824, 0x00000000, 0x00000000, 0x00000000, 
    0x2b281a06, 0x3c3b392f, 0x49493f3e, 0x0000026a, 0x3f3f3f2b, 0x395b3a5a, 0x4a0c0c3a, 0x0000002b, 
    0x00000000, 0x00000000, 0x004f014f, 0x00490154, 0x0000004d, 0x0000000c, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0a0602, 0x1f1b1713, 0x302c2824, 0x00000000, 0x00000000, 0x00000000, 
    0x2d291b07, 0x3e3c3a38, 0x4a4a493f, 0x0000030b, 0x4949482c, 0x3a5c3b5c, 0x4c0d0d3b, 0x0000002c, 
    0x00000000, 0x00000000, 0x00580178, 0x0052017d, 0x00000057, 0x0000000d, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0a0602, 0x1f1b1713, 0x302c2824, 0x00000000, 0x00000000, 0x00000000, 
    0x2e2a1c08, 0x3f3d3b39, 0x4c4b4a49, 0x000003d5, 0x4a4a492e, 0x3c5d3c5d, 0x4d0f0f3c, 0x0000002e, 
    0x00000000, 0x00000000, 0x006301a6, 0x005c01ac, 0x00000061, 0x0000000f, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0a0602, 0x1f1b1713, 0x302c2824, 0x00000000, 0x00000000, 0x00000000, 
    0x382b1e09, 0x493f3d3a, 0x4d4c4b4a, 0x000004d4, 0x4b4b4a2f, 0x3d5f3e5f, 0x4f19193e, 0x0000002f, 
    0x00000000, 0x00000000, 0x007001da, 0x006701e1, 0x0000006d, 0x00000011, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0a0602, 0x1f1b1713, 0x302c2824, 0x00000000, 0x00000000, 0x00000000, 
    0x392d1f0a, 0x4a483e3c, 0x4f4e4c4b, 0x00000616, 0x4c4c4c39, 0x3f684868, 0x581a1a3f, 0x00000039, 
    0x00000000, 0x00000000, 0x007d0214, 0x0074021c, 0x0000007b, 0x00000013, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0a0602, 0x1f1b1713, 0x302c2824, 0x00000000, 0x00000000, 0x00000000, 
    0x3a2e290b, 0x4b49483d, 0x584f4e4c, 0x000007aa, 0x4e4d4d3a, 0x48694969, 0x591b1b49, 0x0000003a, 
    0x00000000, 0x00000000, 0x008d0256, 0x0082025e, 0x0000008a, 0x00000016, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0a0602, 0x1f1b1713, 0x302c2824, 0x00000000, 0x00000000, 0x00000000, 
    0x3b382a0c, 0x4c4b493f, 0x59594f4e, 0x000009a8, 0x4f4f4f3b, 0x496b4a6a, 0x5a1c1c4a, 0x0000003b, 
    0x00000000, 0x00000000, 0x009e029f, 0x009202a8, 0x0000009b, 0x00000018, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0a0602, 0x1f1b1713, 0x302c2824, 0x00000000, 0x00000000, 0x00000000, 
    0x3d392b0e, 0x4e4c4a48, 0x5a5a594f, 0x00000c2b, 0x5959583c, 0x4a6c4b6c, 0x5c1e1e4b, 0x0000003c, 
    0x00000000, 0x00000000, 0x00b102f1, 0x00a402fb, 0x000000ae, 0x0000001b, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0a0602, 0x1f1b1713, 0x302c2824, 0x00000000, 0x00000000, 0x00000000, 
    0x3e3a2c18, 0x4f4d4b49, 0x5c5b5a59, 0x00000f55, 0x5a5a593e, 0x4c6d4c6d, 0x5d28284c, 0x0000003e, 
    0x00000000, 0x00000000, 0x00c7034d, 0x00b80359, 0x000000c3, 0x0000001f, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0a0602, 0x1f1b1713, 0x302c2824, 0x00000000, 0x00000000, 0x00000000, 
    0x483b2e19, 0x594f4d4a, 0x5d5c5b5a, 0x00001351, 0x5b5b5a3f, 0x4d6f4e6f, 0x5f29294e, 0x0000003f, 
    0x00000000, 0x00000000, 0x00e003b5, 0x00cf03c2, 0x000000db, 0x00000023, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0a0602, 0x1f1b1713, 0x302c2824, 0x00000000, 0x00000000, 0x00000000, 
    0x493d2f1a, 0x5a584e4c, 0x5f5e5c5b, 0x00001856, 0x5c5c5c49, 0x4f785878, 0x682a2a4f, 0x00000049, 
    0x00000000, 0x00000000, 0x00fb0429, 0x00e90438, 0x000000f6, 0x00000027, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0a0602, 0x1f1b1713, 0x302c2824, 0x00000000, 0x00000000, 0x00000000, 
    0x4a3e391c, 0x5b59584d, 0x685f5e5c, 0x00001ea9, 0x5e5d5d4a, 0x58795979, 0x692b2b59, 0x0000004a, 
    0x00000000, 0x00000000, 0x011a04ac, 0x010504bc, 0x00000114, 0x0000002c, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0a0602, 0x1f1b1713, 0x302c2824, 0x00000000, 0x00000000, 0x00000000, 
    0x4b483a1d, 0x5c5b594f, 0x69695f5e, 0x000026a2, 0x5f5f5f4b, 0x597b5a7a, 0x6a2c2c5a, 0x0000004b, 
    0x00000000, 0x00000000, 0x013c053e, 0x01250551, 0x00000136, 0x00000031, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0a0602, 0x1f1b1713, 0x302c2824, 0x00000000, 0x00000000, 0x00000000, 
    0x4d493b1f, 0x5e5c5a58, 0x6a6a695f, 0x000030ac, 0x6969684c, 0x5a7c5b7c, 0x6c2e2e5b, 0x0000004c, 
    0x00000000, 0x00000000, 0x016305e2, 0x014905f7, 0x0000015c, 0x00000037, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0a0602, 0x1f1b1713, 0x302c2824, 0x00000000, 0x00000000, 0x00000000, 
    0x4e4a3c28, 0x5f5d5b59, 0x6c6b6a69, 0x00003d53, 0x6a6a694e, 0x5c7d5c7d, 0x6d38385c, 0x0000004e, 
    0x00000000, 0x00000000, 0x018f069b, 0x017106b2, 0x00000187, 0x0000003e, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0a0602, 0x1f1b1713, 0x302c2824, 0x00000000, 0x00000000, 0x00000000, 
    0x584b3e29, 0x695f5d5a, 0x6d6c6b6a, 0x00004d43, 0x6b6b6a4f, 0x5d7f5e7f, 0x6f39395e, 0x0000004f, 
    0x00000000, 0x00000000, 0x01c0076a, 0x019f0784, 0x000001b7, 0x00000046, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0a0602, 0x1f1b1713, 0x302c2824, 0x00000000, 0x00000000, 0x00000000, 
    0x594d3f2a, 0x6a685e5c, 0x6f6e6c6b, 0x00006158, 0x6c6c6c59, 0x5f886888, 0x783a3a5f, 0x00000059, 
    0x00000000, 0x00000000, 0x01f70853, 0x01d20870, 0x000001ed, 0x0000004e, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0a0602, 0x1f1b1713, 0x302c2824, 0x00000000, 0x00000000, 0x00000000, 
    0x5a4e492c, 0x6b69685d, 0x6f6f6e6c, 0x00007aa5, 0x6e6d6d5a, 0x68896989, 0x793b3b69, 0x0000005a, 
    0x00000000, 0x00000000, 0x02340958, 0x020b0979, 0x00000229, 0x00000058, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0a0602, 0x1f1b1713, 0x302c2824, 0x00000000, 0x00000000, 0x00000000, 
    0x5b584a2d, 0x6c6b695f, 0x6f6f6f6e, 0x00009a86, 0x6f6f6f5b, 0x698b6a8a, 0x7a3c3c6a, 0x0000005b, 
    0x00000000, 0x00000000, 0x02790a7d, 0x024b0aa2, 0x0000026d, 0x00000063, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0a0602, 0x1f1b1713, 0x302c2824, 0x00000000, 0x00000000, 0x00000000, 
    0x5d594b2f, 0x6e6c6a68, 0x6f6f6f6f, 0x0000c2b0, 0x7979785c, 0x6a8c6b8c, 0x7c3e3e6b, 0x0000005c, 
    0x00000000, 0x00000000, 0x02c70bc5, 0x02930bef, 0x000002b9, 0x0000006f, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0a0602, 0x1f1b1713, 0x302c2824, 0x00000000, 0x00000000, 0x00000000, 
    0x5e5a4c38, 0x6f6d6b69, 0x6f6f6f6f, 0x0000f54b, 0x7a7a795e, 0x6c8d6c8d, 0x7d48486c, 0x0000005e, 
    0x00000000, 0x00000000, 0x031e0d36, 0x02e30d65, 0x0000030f, 0x0000007d, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0a0602, 0x1f1b1713, 0x302c2824, 0x00000000, 0x00000000, 0x00000000, 
    0x685b4e39, 0x6f6f6d6a, 0x6f6f6f6f, 0x0000350c, 0x7b7b7a5f, 0x6d8f6e8f, 0x7f49496e, 0x0000005f, 
    0x00000000, 0x00000000, 0x03800ed5, 0x033e0f09, 0x0000036e, 0x0000008c, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0a0602, 0x1f1b1713, 0x302c2824, 0x00000000, 0x00000000, 0x00000000, 
    0x695d4f3a, 0x6f6f6e6c, 0x6f6f6f6f, 0x00008560, 0x7c7c7c69, 0x6f8f788f, 0x884a4a6f, 0x00000069, 
    0x00000000, 0x00000000, 0x03ee10a6, 0x03a410e1, 0x000003da, 0x0000009d, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0a0602, 0x1f1b1713, 0x302c2824, 0x00000000, 0x00000000, 0x00000000, 
    0x6a5e593c, 0x6f6f6f6d, 0x6f6f6f6f, 0x0000ea95, 0x7e7d7d6a, 0x788f798f, 0x894b4b79, 0x0000006a, 
    0x00000000, 0x00000000, 0x046912b0, 0x041612f2, 0x00000453, 0x000000b1, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0a0602, 0x1f1b1713, 0x302c2824, 0x00000000, 0x00000000, 0x00000000, 
    0x6b685a3d, 0x6f6f6f6f, 0x6f6f6f6f, 0x00006a19, 0x7f7f7f6b, 0x798f7a8f, 0x8a4c4c7a, 0x0000006b, 
    0x00000000, 0x00000000, 0x04f314fa, 0x04961544, 0x000004db, 0x000000c6, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0a0602, 0x1f1b1713, 0x302c2824, 0x00000000, 0x00000000, 0x00000000, 
    0x6d695b3f, 0x6f6f6f6f, 0x6f6f6f6f, 0x00000ac1, 0x8989886c, 0x7a8f7b8f, 0x8c4e4e7b, 0x0000006c, 
    0x00000000, 0x00000000, 0x058f178b, 0x052617df, 0x00000573, 0x000000df, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0a0602, 0x1f1b1713, 0x302c2824, 0x00000000, 0x00000000, 0x00000000, 
    0x6e6a5c48, 0x6f6f6f6f, 0x6f6f6f6f, 0x0000d52a, 0x8a8a896e, 0x7c8f7c8f, 0x8d58587c, 0x0000006e, 
    0x00000000, 0x00000000, 0x063d1a6d, 0x05c71acb, 0x0000061e, 0x000000fa, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0a0602, 0x1f1b1713, 0x302c2824, 0x00000000, 0x00000000, 0x00000000, 
    0x6f6b5e49, 0x6f6f6f6f, 0x6f6f6f6f, 0x0000d431, 0x8b8b8a6f, 0x7d8f7e8f, 0x8f59597e, 0x0000006f, 
    0x00000000, 0x00000000, 0x07011daa, 0x067c1e13, 0x000006dd, 0x00000119, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0a0602, 0x1f1b1713, 0x302c2824, 0x00000000, 0x00000000, 0x00000000, 
    0x6f6d5f4a, 0x6f6f6f6f, 0x6f6f6f6f, 0x00001581, 0x8c8c8c79, 0x7f8f888f, 0x8f5a5a7f, 0x00000079, 
    0x00000000, 0x00000000, 0x07dc214c, 0x074821c2, 0x000007b5, 0x0000013b, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x6c191f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0a0602, 0x1f1b1713, 0x302c2824, 0x00000000, 0x00000000, 0x00000000, 
    0x05040200, 0x0c0a0807, 0x19180f0d, 0x00000003, 0x07070702, 0x04190419, 0x0a000004, 0x00000002, 
    0x00000000, 0x00000000, 0x00040012, 0x00040012, 0x00000004, 0x00000000, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x5a161f23, 0x00155c17, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00000000, 0x00000000, 0x00000000, 
    0x05040200, 0x0c0a0807, 0x19180f0d, 0x00000003, 0x07070702, 0x04190419, 0x0a000004, 0x00000002, 
    0x00000000, 0x00000000, 0x00040012, 0x00040012, 0x00000004, 0x00000000, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x5a161f23, 0x00155c17, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00000000, 0x00000000, 0x00000000, 
    0x05040200, 0x0c0a0807, 0x19180f0d, 0x00000003, 0x07070702, 0x04190419, 0x0a000004, 0x00000002, 
    0x00000000, 0x00000000, 0x00040012, 0x00040012, 0x00000004, 0x00000000, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x5a161f23, 0x00155c17, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00000000, 0x00000000, 0x00000000, 
    0x05040200, 0x0c0a0807, 0x19180f0d, 0x00000003, 0x07070702, 0x04190419, 0x0a000004, 0x00000002, 
    0x00000000, 0x00000000, 0x00040012, 0x00040012, 0x00000004, 0x00000000, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x5a161f23, 0x00155c17, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00000000, 0x00000000, 0x00000000, 
    0x05040200, 0x0c0a0807, 0x19180f0d, 0x00000003, 0x07070702, 0x04190419, 0x0a000004, 0x00000002, 
    0x00000000, 0x00000000, 0x00040012, 0x00040012, 0x00000004, 0x00000000, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x5a161f23, 0x00155c17, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00000000, 0x00000000, 0x00000000, 
    0x05040200, 0x0c0a0807, 0x19180f0d, 0x00000003, 0x07070702, 0x04190419, 0x0a000004, 0x00000002, 
    0x00000000, 0x00000000, 0x00040012, 0x00040012, 0x00000004, 0x00000000, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x5a161f23, 0x00155c17, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00000000, 0x00000000, 0x00000000, 
    0x05040200, 0x0c0a0807, 0x19180f0d, 0x00000003, 0x07070702, 0x04190419, 0x0a000004, 0x00000002, 
    0x00000000, 0x00000000, 0x00040012, 0x00040012, 0x00000004, 0x00000000, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x5a161f23, 0x00155c17, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00000000, 0x00000000, 0x00000000, 
    0x05040200, 0x0c0a0807, 0x19180f0d, 0x00000003, 0x07070702, 0x04190419, 0x0a000004, 0x00000002, 
    0x00000000, 0x00000000, 0x00040012, 0x00040012, 0x00000004, 0x00000000, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x5a161f23, 0x00155c17, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00000000, 0x00000000, 0x00000000, 
    0x05040200, 0x0c0a0807, 0x19180f0d, 0x00000003, 0x07070702, 0x04190419, 0x0a000004, 0x00000002, 
    0x00000000, 0x00000000, 0x00040012, 0x00040012, 0x00000004, 0x00000000, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x5a161f23, 0x00155c17, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00000000, 0x00000000, 0x00000000, 
    0x05040200, 0x0c0a0807, 0x19180f0d, 0x00000003, 0x07070702, 0x04190419, 0x0a000004, 0x00000002, 
    0x00000000, 0x00000000, 0x00040012, 0x00040012, 0x00000004, 0x00000000, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x5a161f23, 0x00155c17, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00000000, 0x00000000, 0x00000000, 
    0x05040200, 0x0c0a0807, 0x19180f0d, 0x00000003, 0x07070702, 0x04190419, 0x0a000004, 0x00000002, 
    0x00000000, 0x00000000, 0x00040012, 0x00040012, 0x00000004, 0x00000000, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x5a161f23, 0x00155c17, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00000000, 0x00000000, 0x00000000, 
    0x05040200, 0x0c0a0807, 0x19180f0d, 0x00000003, 0x07070702, 0x04190419, 0x0a000004, 0x00000002, 
    0x00000000, 0x00000000, 0x00040012, 0x00040012, 0x00000004, 0x00000000, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x5a161f23, 0x00155c17, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00000000, 0x00000000, 0x00000000, 
    0x05040200, 0x0c0a0807, 0x19180f0d, 0x00000003, 0x07070702, 0x04190419, 0x0a000004, 0x00000002, 
    0x00000000, 0x00000000, 0x00040012, 0x00040012, 0x00000004, 0x00000000, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x5a161f23, 0x00155c17, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00000000, 0x00000000, 0x00000000, 
    0x06040200, 0x0d0b0908, 0x1a1a190f, 0x00000003, 0x08080803, 0x041a051a, 0x0c000004, 0x00000003, 
    0x00000000, 0x00000000, 0x00050014, 0x00040014, 0x00000004, 0x00000000, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x5a161f23, 0x00155c17, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00000000, 0x00000000, 0x00000000, 
    0x07050301, 0x0f0d0b09, 0x1c1b1a19, 0x00000004, 0x09090903, 0x051c051b, 0x0d010105, 0x00000003, 
    0x00000000, 0x00000000, 0x00050016, 0x00050017, 0x00000005, 0x00000001, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x5a161f23, 0x00155c17, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00000000, 0x00000000, 0x00000000, 
    0x07050301, 0x190e0c0a, 0x1d1c1b1a, 0x00000005, 0x0b0b0a03, 0x051d061d, 0x0f010106, 0x00000003, 
    0x00000000, 0x00000000, 0x00060019, 0x0005001a, 0x00000006, 0x00000001, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x5a161f23, 0x00155c17, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00000000, 0x00000000, 0x00000000, 
    0x08060301, 0x1a180e0b, 0x1f1d1c1b, 0x00000007, 0x0c0c0c04, 0x061f071e, 0x19010107, 0x00000004, 
    0x00000000, 0x00000000, 0x0007001c, 0x0006001d, 0x00000007, 0x00000001, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x5a161f23, 0x00155c17, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00000000, 0x00000000, 0x00000000, 
    0x0a070401, 0x1b190f0c, 0x281f1e1c, 0x00000008, 0x0e0e0d05, 0x07280828, 0x1a010107, 0x00000005, 
    0x00000000, 0x00000000, 0x00080020, 0x00070020, 0x00000007, 0x00000001, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x5a161f23, 0x00155c17, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00000000, 0x00000000, 0x00000000, 
    0x0b080401, 0x1c1a190e, 0x29281f1e, 0x0000000a, 0x0f0f0f05, 0x08290929, 0x1b010108, 0x00000005, 
    0x00000000, 0x00000000, 0x00090024, 0x00080024, 0x00000008, 0x00000001, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x5a161f23, 0x00155c17, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00000000, 0x00000000, 0x00000000, 
    0x0c090501, 0x1e1c1a18, 0x2a2a291f, 0x0000000d, 0x19191906, 0x092a0a2a, 0x1c010109, 0x00000006, 
    0x00000000, 0x00000000, 0x000a0028, 0x00090029, 0x00000009, 0x00000001, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x5a161f23, 0x00155c17, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00000000, 0x00000000, 0x00000000, 
    0x0e0a0602, 0x1f1d1b19, 0x2c2b2a29, 0x00000011, 0x1a1a1a07, 0x0a2c0b2b, 0x1e02020b, 0x00000007, 
    0x00000000, 0x00000000, 0x000b002d, 0x000a002e, 0x0000000b, 0x00000002, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x5a161f23, 0x00155c17, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00000000, 0x00000000, 0x00000000, 
    0x0f0b0602, 0x291f1d1a, 0x2d2c2b2a, 0x00000015, 0x1b1b1b07, 0x0b2d0c2d, 0x1f02020c, 0x00000007, 
    0x00000000, 0x00000000, 0x000c0033, 0x000b0034, 0x0000000c, 0x00000002, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x5a161f23, 0x00155c17, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00000000, 0x00000000, 0x00000000, 
    0x190c0702, 0x2a281e1c, 0x2f2d2c2b, 0x0000001a, 0x1d1c1c08, 0x0d2f0e2e, 0x2902020e, 0x00000008, 
    0x00000000, 0x00000000, 0x000e0039, 0x000d003a, 0x0000000e, 0x00000002, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x5a161f23, 0x00155c17, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00000000, 0x00000000, 0x00000000, 
    0x1a0e0802, 0x2b29281d, 0x382f2e2c, 0x00000021, 0x1e1e1e0a, 0x0e381838, 0x2a02020f, 0x0000000a, 
    0x00000000, 0x00000000, 0x00100040, 0x000e0041, 0x0000000f, 0x00000002, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x5a161f23, 0x00155c17, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00000000, 0x00000000, 0x00000000, 
    0x1b180903, 0x2c2a291f, 0x39382f2e, 0x0000002a, 0x28281f0b, 0x18391939, 0x2b030319, 0x0000000b, 
    0x00000000, 0x00000000, 0x00120048, 0x00100049, 0x00000011, 0x00000003, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x5a161f23, 0x00155c17, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00000000, 0x00000000, 0x00000000, 
    0x1d190a03, 0x2e2c2a28, 0x3a3a392f, 0x00000034, 0x2929290c, 0x193a1a3a, 0x2c03031a, 0x0000000c, 
    0x00000000, 0x00000000, 0x00140051, 0x00120052, 0x00000013, 0x00000003, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x5a161f23, 0x00155c17, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00000000, 0x00000000, 0x00000000, 
    0x1e1a0c04, 0x2f2d2b29, 0x3c3b3a39, 0x00000042, 0x2a2a2a0e, 0x1a3c1b3b, 0x2e04041b, 0x0000000e, 
    0x00000000, 0x00000000, 0x0016005b, 0x0014005c, 0x00000016, 0x00000004, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x5a161f23, 0x00155c17, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00000000, 0x00000000, 0x00000000, 
    0x281b0d04, 0x392f2d2a, 0x3d3c3b3a, 0x00000053, 0x2b2b2b0f, 0x1c3d1d3d, 0x2f04041d, 0x0000000f, 
    0x00000000, 0x00000000, 0x00190066, 0x00170068, 0x00000019, 0x00000004, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x5a161f23, 0x00155c17, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00000000, 0x00000000, 0x00000000, 
    0x291d0f05, 0x3a382e2c, 0x3f3d3c3b, 0x00000069, 0x2d2c2c19, 0x1d3f1e3e, 0x3905051e, 0x00000019, 
    0x00000000, 0x00000000, 0x001c0073, 0x001a0075, 0x0000001c, 0x00000005, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x5a161f23, 0x00155c17, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00000000, 0x00000000, 0x00000000, 
    0x2a1e1905, 0x3b39382d, 0x483f3e3c, 0x00000084, 0x2e2e2e1a, 0x1f482848, 0x3a050528, 0x0000001a, 
    0x00000000, 0x00000000, 0x00200081, 0x001d0083, 0x0000001f, 0x00000005, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x5a161f23, 0x00155c17, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00000000, 0x00000000, 0x00000000, 
    0x2b281a06, 0x3c3a392f, 0x49483f3e, 0x000000a6, 0x38382f1b, 0x28492949, 0x3b060629, 0x0000001b, 
    0x00000000, 0x00000000, 0x00240091, 0x00210093, 0x00000023, 0x00000006, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x5a161f23, 0x00155c17, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00000000, 0x00000000, 0x00000000, 
    0x2d291b07, 0x3e3c3a38, 0x4a4a493f, 0x000000d2, 0x3939391d, 0x294a2a4a, 0x3c07072a, 0x0000001d, 
    0x00000000, 0x00000000, 0x002800a2, 0x002500a5, 0x00000027, 0x00000007, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x5a161f23, 0x00155c17, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00000000, 0x00000000, 0x00000000, 
    0x2e2a1c08, 0x3f3d3b39, 0x4c4b4a49, 0x00000108, 0x3a3a3a1e, 0x2a4c2b4b, 0x3e08082b, 0x0000001e, 
    0x00000000, 0x00000000, 0x002d00b6, 0x002900b9, 0x0000002c, 0x00000008, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x5a161f23, 0x00155c17, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00000000, 0x00000000, 0x00000000, 
    0x382b1e09, 0x493f3d3a, 0x4d4c4b4a, 0x0000014d, 0x3b3b3b28, 0x2c4d2d4d, 0x3f09092d, 0x00000028, 
    0x00000000, 0x00000000, 0x003300cd, 0x002f00d0, 0x00000032, 0x00000009, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x5a161f23, 0x00155c17, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00000000, 0x00000000, 0x00000000, 
    0x392d1f0a, 0x4a483e3c, 0x4f4d4c4b, 0x000001a3, 0x3d3c3c29, 0x2d4f2e4e, 0x490a0a2e, 0x00000029, 
    0x00000000, 0x00000000, 0x003900e6, 0x003400ea, 0x00000038, 0x0000000a, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x5a161f23, 0x00155c17, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00000000, 0x00000000, 0x00000000, 
    0x3a2e290b, 0x4b49483d, 0x584f4e4c, 0x00000210, 0x3e3e3e2a, 0x2f583858, 0x4a0b0b38, 0x0000002a, 
    0x00000000, 0x00000000, 0x00400102, 0x003b0106, 0x0000003f, 0x0000000b, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x5a161f23, 0x00155c17, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00000000, 0x00000000, 0x00000000, 
    0x3b382a0c, 0x4c4a493f, 0x59584f4e, 0x0000029a, 0x48483f2b, 0x38593959, 0x4b0c0c39, 0x0000002b, 
    0x00000000, 0x00000000, 0x00480122, 0x00420127, 0x00000046, 0x0000000c, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x5a161f23, 0x00155c17, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00000000, 0x00000000, 0x00000000, 
    0x3d392b0e, 0x4e4c4a48, 0x5a5a594f, 0x00000347, 0x4949492d, 0x395a3a5a, 0x4c0e0e3a, 0x0000002d, 
    0x00000000, 0x00000000, 0x00510145, 0x004a014b, 0x0000004f, 0x0000000e, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x5a161f23, 0x00155c17, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00000000, 0x00000000, 0x00000000, 
    0x3e3a2c18, 0x4f4d4b49, 0x5c5b5a59, 0x00000421, 0x4a4a4a2e, 0x3a5c3b5b, 0x4e18183b, 0x0000002e, 
    0x00000000, 0x00000000, 0x005b016d, 0x00530173, 0x00000059, 0x00000010, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x5a161f23, 0x00155c17, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00000000, 0x00000000, 0x00000000, 
    0x483b2e19, 0x594f4d4a, 0x5d5c5b5a, 0x00000533, 0x4b4b4b38, 0x3c5d3d5d, 0x4f19193d, 0x00000038, 
    0x00000000, 0x00000000, 0x0066019a, 0x005e01a1, 0x00000064, 0x00000012, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x5a161f23, 0x00155c17, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00000000, 0x00000000, 0x00000000, 
    0x493d2f1a, 0x5a584e4c, 0x5f5d5c5b, 0x0000068d, 0x4d4c4c39, 0x3d5f3e5e, 0x591a1a3e, 0x00000039, 
    0x00000000, 0x00000000, 0x007301cc, 0x006901d4, 0x00000070, 0x00000014, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x5a161f23, 0x00155c17, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00000000, 0x00000000, 0x00000000, 
    0x4a3e391b, 0x5b59584d, 0x685f5e5c, 0x00000841, 0x4e4e4e3a, 0x3f684868, 0x5a1b1b48, 0x0000003a, 
    0x00000000, 0x00000000, 0x00810205, 0x0076020d, 0x0000007e, 0x00000016, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x5a161f23, 0x00155c17, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00000000, 0x00000000, 0x00000000, 
    0x4b483a1d, 0x5c5a594f, 0x69685f5e, 0x00000a66, 0x58584f3b, 0x48694969, 0x5b1d1d49, 0x0000003b, 
    0x00000000, 0x00000000, 0x00910244, 0x0084024e, 0x0000008d, 0x00000019, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x5a161f23, 0x00155c17, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00000000, 0x00000000, 0x00000000, 
    0x4d493b1e, 0x5e5c5a58, 0x6a6a695f, 0x00000d1a, 0x5959593d, 0x496a4a6a, 0x5c1e1e4a, 0x0000003d, 
    0x00000000, 0x00000000, 0x00a2028b, 0x00950296, 0x0000009f, 0x0000001c, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x5a161f23, 0x00155c17, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00000000, 0x00000000, 0x00000000, 
    0x4e4a3c28, 0x5f5d5b59, 0x6c6b6a69, 0x00001082, 0x5a5a5a3e, 0x4a6c4b6b, 0x5e28284b, 0x0000003e, 
    0x00000000, 0x00000000, 0x00b602db, 0x00a702e7, 0x000000b2, 0x00000020, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x5a161f23, 0x00155c17, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00000000, 0x00000000, 0x00000000, 
    0x584b3e29, 0x695f5d5a, 0x6d6c6b6a, 0x000014cd, 0x5b5b5b48, 0x4c6d4d6d, 0x5f29294d, 0x00000048, 
    0x00000000, 0x00000000, 0x00cd0334, 0x00bc0342, 0x000000c8, 0x00000024, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x5a161f23, 0x00155c17, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00000000, 0x00000000, 0x00000000, 
    0x594d3f2a, 0x6a685e5c, 0x6f6d6c6b, 0x00001a35, 0x5d5c5c49, 0x4d6f4e6e, 0x692a2a4e, 0x00000049, 
    0x00000000, 0x00000000, 0x00e60399, 0x00d303a8, 0x000000e1, 0x00000028, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x5a161f23, 0x00155c17, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00000000, 0x00000000, 0x00000000, 
    0x5a4e492b, 0x6b69685d, 0x6f6f6e6c, 0x00002105, 0x5e5e5e4a, 0x4f785878, 0x6a2b2b58, 0x0000004a, 
    0x00000000, 0x00000000, 0x0102040a, 0x00ec041b, 0x000000fc, 0x0000002d, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x5a161f23, 0x00155c17, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00000000, 0x00000000, 0x00000000, 
    0x5b584a2d, 0x6c6a695f, 0x6f6f6f6e, 0x0000299a, 0x68685f4b, 0x58795979, 0x6b2d2d59, 0x0000004b, 
    0x00000000, 0x00000000, 0x01220488, 0x0109049c, 0x0000011b, 0x00000033, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x5a161f23, 0x00155c17, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00000000, 0x00000000, 0x00000000, 
    0x5d594b2e, 0x6e6c6a68, 0x6f6f6f6f, 0x0000346a, 0x6969694d, 0x597a5a7a, 0x6c2e2e5a, 0x0000004d, 
    0x00000000, 0x00000000, 0x01450517, 0x012a052c, 0x0000013e, 0x00000039, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x5a161f23, 0x00155c17, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00000000, 0x00000000, 0x00000000, 
    0x5e5a4c38, 0x6f6d6b69, 0x6f6f6f6f, 0x00004209, 0x6a6a6a4e, 0x5a7c5b7b, 0x6e38385b, 0x0000004e, 
    0x00000000, 0x00000000, 0x016d05b6, 0x014f05cf, 0x00000165, 0x00000041, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x5a161f23, 0x00155c17, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00000000, 0x00000000, 0x00000000, 
    0x685b4e39, 0x6f6f6d6a, 0x6f6f6f6f, 0x00005333, 0x6b6b6b58, 0x5c7d5d7d, 0x6f39395d, 0x00000058, 
    0x00000000, 0x00000000, 0x019a0669, 0x01780685, 0x00000191, 0x00000048, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x5a161f23, 0x00155c17, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00000000, 0x00000000, 0x00000000, 
    0x695d4f3a, 0x6f6f6e6c, 0x6f6f6f6f, 0x000068d3, 0x6d6c6c59, 0x5d7f5e7e, 0x793a3a5e, 0x00000059, 
    0x00000000, 0x00000000, 0x01cc0732, 0x01a60751, 0x000001c2, 0x00000051, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x5a161f23, 0x00155c17, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00000000, 0x00000000, 0x00000000, 
    0x6a5e593b, 0x6f6f6f6d, 0x6f6f6f6f, 0x00008412, 0x6e6e6e5a, 0x5f886888, 0x7a3b3b68, 0x0000005a, 
    0x00000000, 0x00000000, 0x02050814, 0x01d90837, 0x000001f9, 0x0000005b, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x5a161f23, 0x00155c17, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00000000, 0x00000000, 0x00000000, 
    0x6b685a3d, 0x6f6f6f6f, 0x6f6f6f6f, 0x0000a666, 0x78786f5b, 0x68896989, 0x7b3d3d69, 0x0000005b, 
    0x00000000, 0x00000000, 0x02440911, 0x02130938, 0x00000237, 0x00000067, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x5a161f23, 0x00155c17, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00000000, 0x00000000, 0x00000000, 
    0x6d695b3e, 0x6f6f6f6f, 0x6f6f6f6f, 0x0000d1a7, 0x7979795d, 0x698a6a8a, 0x7c3e3e6a, 0x0000005d, 
    0x00000000, 0x00000000, 0x028b0a2e, 0x02550a59, 0x0000027d, 0x00000073, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x5a161f23, 0x00155c17, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00000000, 0x00000000, 0x00000000, 
    0x6e6a5c48, 0x6f6f6f6f, 0x6f6f6f6f, 0x00000825, 0x7a7a7a5e, 0x6a8c6b8b, 0x7e48486b, 0x0000005e, 
    0x00000000, 0x00000000, 0x02db0b6d, 0x029e0b9e, 0x000002cb, 0x00000082, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x5a161f23, 0x00155c17, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00000000, 0x00000000, 0x00000000, 
    0x6f6b5e49, 0x6f6f6f6f, 0x6f6f6f6f, 0x00004ccd, 0x7b7b7b68, 0x6c8d6d8d, 0x7f49496d, 0x00000068, 
    0x00000000, 0x00000000, 0x03340cd3, 0x02f00d0a, 0x00000322, 0x00000091, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x5a161f23, 0x00155c17, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00000000, 0x00000000, 0x00000000, 
    0x6f6d5f4a, 0x6f6f6f6f, 0x6f6f6f6f, 0x0000a34d, 0x7d7c7c69, 0x6d8f6e8e, 0x894a4a6e, 0x00000069, 
    0x00000000, 0x00000000, 0x03990e65, 0x034c0ea3, 0x00000384, 0x000000a3, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x5a161f23, 0x00155c17, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00000000, 0x00000000, 0x00000000, 
    0x6f6e694b, 0x6f6f6f6f, 0x6f6f6f6f, 0x00001049, 0x7e7e7e6a, 0x6f8f788f, 0x8a4b4b78, 0x0000006a, 
    0x00000000, 0x00000000, 0x040a1029, 0x03b3106e, 0x000003f3, 0x000000b7, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x5a161f23, 0x00155c17, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00000000, 0x00000000, 0x00000000, 
    0x6f6f6a4d, 0x6f6f6f6f, 0x6f6f6f6f, 0x0000999a, 0x88887f6b, 0x788f798f, 0x8b4d4d79, 0x0000006b, 
    0x00000000, 0x00000000, 0x04881223, 0x04271271, 0x0000046f, 0x000000ce, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x5a161f23, 0x00155c17, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00000000, 0x00000000, 0x00000000, 
    0x6f6f6b4e, 0x6f6f6f6f, 0x6f6f6f6f, 0x0000469a, 0x8989896d, 0x798f7a8f, 0x8c4e4e7a, 0x0000006d, 
    0x00000000, 0x00000000, 0x0517145c, 0x04aa14b3, 0x000004fa, 0x000000e7, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x5a161f23, 0x00155c17, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00000000, 0x00000000, 0x00000000, 
    0x6f6f6c58, 0x6f6f6f6f, 0x6f6f6f6f, 0x00002093, 0x8a8a8a6e, 0x7a8f7b8f, 0x8e58587b, 0x0000006e, 
    0x00000000, 0x00000000, 0x05b616da, 0x053c173c, 0x00000596, 0x00000104, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x5a161f23, 0x00155c17, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00000000, 0x00000000, 0x00000000, 
    0x6f6f6e59, 0x6f6f6f6f, 0x6f6f6f6f, 0x00003333, 0x8b8b8b78, 0x7c8f7d8f, 0x8f59597d, 0x00000078, 
    0x00000000, 0x00000000, 0x066919a7, 0x05e01a14, 0x00000645, 0x00000123, 0x00000000, 0x00000000, 
    0x27272600, 0x0e00001e, 0x00000000, 0x12000404, 0x22000f13, 0x5a161f23, 0x00155c17, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00000000, 0x00000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000002, 0x06061908, 0x00000000, 0x08000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x1f1f5a00, 0x2a00001e, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000002, 0x06061908, 0x00000000, 0x08000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x1f1f5a00, 0x2a00001e, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000002, 0x06061908, 0x00000000, 0x08000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x1f1f5a00, 0x2a00001e, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000002, 0x06061908, 0x00000000, 0x08000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x1f1f5a00, 0x2a00001e, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000002, 0x06061908, 0x00000000, 0x08000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x1f1f5a00, 0x2a00001e, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000002, 0x06061908, 0x00000000, 0x08000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x1f1f5a00, 0x2a00001e, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000002, 0x06061908, 0x00000000, 0x08000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x1f1f5a00, 0x2a00001e, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000002, 0x06061908, 0x00000000, 0x08000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x1f1f5a00, 0x2a00001e, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000002, 0x06061908, 0x00000000, 0x08000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x1f1f5a00, 0x2a00001e, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000002, 0x06061908, 0x00000000, 0x08000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x1f1f5a00, 0x2a00001e, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000002, 0x06061908, 0x00000000, 0x08000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x1f1f5a00, 0x2a00001e, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000002, 0x06061908, 0x00000000, 0x08000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x1f1f5a00, 0x2a00001e, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000002, 0x06061908, 0x00000000, 0x08000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x1f1f5a00, 0x2a00001e, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000003, 0x06061a09, 0x00000000, 0x09000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x1f1f5a00, 0x2a00001e, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000004, 0x07071b0a, 0x00000000, 0x0a000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x1f1f5a00, 0x2a00001e, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000005, 0x08081c0b, 0x00000000, 0x0b000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x1f1f5a00, 0x2a00001e, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000006, 0x09091e0c, 0x00000000, 0x0c000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x1f1f5a00, 0x2a00001e, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000008, 0x0a0a280e, 0x00000000, 0x0e000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x1f1f5a00, 0x2a00001e, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x0000000a, 0x0c0c2918, 0x00000000, 0x18000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x1f1f5a00, 0x2a00001e, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x0000000c, 0x0d0d2a19, 0x00000000, 0x19000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x1f1f5a00, 0x2a00001e, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x0000000f, 0x0f0f2b1a, 0x00000000, 0x1a000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x1f1f5a00, 0x2a00001e, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000013, 0x19182c1c, 0x00000000, 0x1c000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x1f1f5a00, 0x2a00001e, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000018, 0x1a1a2e1d, 0x00000000, 0x1d000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x1f1f5a00, 0x2a00001e, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x0000001e, 0x1b1b381e, 0x00000000, 0x1e000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x1f1f5a00, 0x2a00001e, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000026, 0x1c1c3928, 0x00000000, 0x28000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x1f1f5a00, 0x2a00001e, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000030, 0x1e1d3a29, 0x00000000, 0x29000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x1f1f5a00, 0x2a00001e, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x0000003d, 0x1f1f3b2a, 0x00000000, 0x2a000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x1f1f5a00, 0x2a00001e, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x0000004d, 0x29283c2c, 0x00000000, 0x2c000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x1f1f5a00, 0x2a00001e, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000061, 0x2a2a3e2d, 0x00000000, 0x2d000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x1f1f5a00, 0x2a00001e, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x0000007a, 0x2b2b482e, 0x00000000, 0x2e000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x1f1f5a00, 0x2a00001e, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x0000009a, 0x2c2c4938, 0x00000000, 0x38000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x1f1f5a00, 0x2a00001e, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x000000c2, 0x2e2d4a39, 0x00000000, 0x39000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x1f1f5a00, 0x2a00001e, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x000000f4, 0x2f2f4b3a, 0x00000000, 0x3a000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x1f1f5a00, 0x2a00001e, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000133, 0x39384c3c, 0x00000000, 0x3c000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x1f1f5a00, 0x2a00001e, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000183, 0x3a3a4e3d, 0x00000000, 0x3d000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x1f1f5a00, 0x2a00001e, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x000001e8, 0x3b3b583e, 0x00000000, 0x3e000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x1f1f5a00, 0x2a00001e, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000266, 0x3c3c5948, 0x00000000, 0x48000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x1f1f5a00, 0x2a00001e, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000306, 0x3e3d5a49, 0x00000000, 0x49000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x1f1f5a00, 0x2a00001e, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x000003cf, 0x3f3f5b4a, 0x00000000, 0x4a000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x1f1f5a00, 0x2a00001e, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x000004cd, 0x49485c4c, 0x00000000, 0x4c000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x1f1f5a00, 0x2a00001e, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x0000060c, 0x4a4a5e4d, 0x00000000, 0x4d000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x1f1f5a00, 0x2a00001e, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x0000079f, 0x4b4b684e, 0x00000000, 0x4e000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x1f1f5a00, 0x2a00001e, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x0000099a, 0x4c4c6958, 0x00000000, 0x58000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x1f1f5a00, 0x2a00001e, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000c18, 0x4e4d6a59, 0x00000000, 0x59000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x1f1f5a00, 0x2a00001e, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000f3d, 0x4f4f6b5a, 0x00000000, 0x5a000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x1f1f5a00, 0x2a00001e, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00001333, 0x59586c5c, 0x00000000, 0x5c000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x1f1f5a00, 0x2a00001e, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00001831, 0x5a5a6e5d, 0x00000000, 0x5d000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x1f1f5a00, 0x2a00001e, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00001e7a, 0x5b5b785e, 0x00000000, 0x5e000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x1f1f5a00, 0x2a00001e, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00002666, 0x5c5c7968, 0x00000000, 0x68000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x1f1f5a00, 0x2a00001e, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00003062, 0x5e5d7a69, 0x00000000, 0x69000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x1f1f5a00, 0x2a00001e, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00003cf5, 0x5f5f7b6a, 0x00000000, 0x6a000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x1f1f5a00, 0x2a00001e, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00004ccd, 0x69687c6c, 0x00000000, 0x6c000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x1f1f5a00, 0x2a00001e, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x000060c3, 0x6a6a7e6d, 0x00000000, 0x6d000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x1f1f5a00, 0x2a00001e, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x000079ea, 0x6b6b886e, 0x00000000, 0x6e000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x1f1f5a00, 0x2a00001e, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x0000999a, 0x6c6c8978, 0x00000000, 0x78000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x1f1f5a00, 0x2a00001e, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x0000c186, 0x6e6d8a79, 0x00000000, 0x79000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x1f1f5a00, 0x2a00001e, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x0000f3d3, 0x6f6f8b7a, 0x00000000, 0x7a000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x1f1f5a00, 0x2a00001e, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00003333, 0x79788c7c, 0x00000000, 0x7c000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x1f1f5a00, 0x2a00001e, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x0000830c, 0x7a7a8e7d, 0x00000000, 0x7d000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x1f1f5a00, 0x2a00001e, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x0000e7a6, 0x7b7b8f7e, 0x00000000, 0x7e000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x1f1f5a00, 0x2a00001e, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00006666, 0x7c7c8f88, 0x00000000, 0x88000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x1f1f5a00, 0x2a00001e, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000618, 0x7e7d8f89, 0x00000000, 0x89000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x1f1f5a00, 0x2a00001e, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x0000cf4d, 0x7f7f8f8a, 0x00000000, 0x8a000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x1f1f5a00, 0x2a00001e, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x0000cccd, 0x89888f8c, 0x00000000, 0x8c000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x1f1f5a00, 0x2a00001e, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000
};

const uint32_t CodechalEncHevcStateG11::m_encLcu64ConstantDataLut[m_encConstantDataLutSize/4] =
{
    0x05040200, 0x0c0a0807, 0x19180f0d, 0x00000003, 0x07070702, 0x041b051b, 0x0a000005, 0x00000002, 
    0x00000000, 0x00000000, 0x00050016, 0x00040016, 0x00000005, 0x00000000, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00b5b529, 0x00580008, 0x00000058, 
    0x05040200, 0x0c0a0807, 0x19180f0d, 0x00000003, 0x07070702, 0x041b051b, 0x0a000005, 0x00000002, 
    0x00000000, 0x00000000, 0x00050016, 0x00040016, 0x00000005, 0x00000000, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00b5b529, 0x00580008, 0x00000058, 
    0x05040200, 0x0c0a0807, 0x19180f0d, 0x00000003, 0x07070702, 0x041b051b, 0x0a000005, 0x00000002, 
    0x00000000, 0x00000000, 0x00050016, 0x00040016, 0x00000005, 0x00000000, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00b5b529, 0x00580008, 0x00000058, 
    0x05040200, 0x0c0a0807, 0x19180f0d, 0x00000003, 0x07070702, 0x041b051b, 0x0a000005, 0x00000002, 
    0x00000000, 0x00000000, 0x00050016, 0x00040016, 0x00000005, 0x00000000, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00b5b529, 0x00580008, 0x00000058, 
    0x05040200, 0x0c0a0807, 0x19180f0d, 0x00000003, 0x07070702, 0x041b051b, 0x0a000005, 0x00000002, 
    0x00000000, 0x00000000, 0x00050016, 0x00040016, 0x00000005, 0x00000000, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00b5b529, 0x00580008, 0x00000058, 
    0x05040200, 0x0c0a0807, 0x19180f0d, 0x00000003, 0x07070702, 0x041b051b, 0x0a000005, 0x00000002, 
    0x00000000, 0x00000000, 0x00050016, 0x00040016, 0x00000005, 0x00000000, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00b5b529, 0x00580008, 0x00000058, 
    0x05040200, 0x0c0a0807, 0x19180f0d, 0x00000003, 0x07070702, 0x041b051b, 0x0a000005, 0x00000002, 
    0x00000000, 0x00000000, 0x00050016, 0x00040016, 0x00000005, 0x00000000, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00b5b529, 0x00580008, 0x00000058, 
    0x05040200, 0x0c0a0807, 0x19180f0d, 0x00000003, 0x07070702, 0x041b051b, 0x0a000005, 0x00000002, 
    0x00000000, 0x00000000, 0x00050016, 0x00040016, 0x00000005, 0x00000000, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00b5b529, 0x00580008, 0x00000058, 
    0x05040200, 0x0c0a0807, 0x19180f0d, 0x00000003, 0x07070702, 0x041b051b, 0x0a000005, 0x00000002, 
    0x00000000, 0x00000000, 0x00050016, 0x00040016, 0x00000005, 0x00000000, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00b5b529, 0x00580008, 0x00000058, 
    0x05040200, 0x0c0a0807, 0x19180f0d, 0x00000003, 0x07070702, 0x041b051b, 0x0a000005, 0x00000002, 
    0x00000000, 0x00000000, 0x00050016, 0x00040016, 0x00000005, 0x00000000, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00b5b529, 0x00580008, 0x00000058, 
    0x05040200, 0x0c0a0807, 0x19180f0d, 0x00000003, 0x07070702, 0x041b051b, 0x0a000005, 0x00000002, 
    0x00000000, 0x00000000, 0x00050016, 0x00040016, 0x00000005, 0x00000000, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00b5b529, 0x00580008, 0x00000058, 
    0x05040200, 0x0c0a0807, 0x19180f0d, 0x00000003, 0x07070702, 0x041b051b, 0x0a000005, 0x00000002, 
    0x00000000, 0x00000000, 0x00050016, 0x00040016, 0x00000005, 0x00000000, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00b5b529, 0x00580008, 0x00000058, 
    0x05040200, 0x0c0a0807, 0x19180f0d, 0x00000003, 0x07070702, 0x041b051b, 0x0a000005, 0x00000002, 
    0x00000000, 0x00000000, 0x00050016, 0x00040016, 0x00000005, 0x00000000, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00b5b529, 0x00580008, 0x00000058, 
    0x06040200, 0x0d0b0908, 0x1a1a190f, 0x00000003, 0x08080803, 0x051c051c, 0x0c000005, 0x00000003, 
    0x00000000, 0x00000000, 0x00050018, 0x00050018, 0x00000005, 0x00000000, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00b5b529, 0x00620009, 0x00000062, 
    0x07050301, 0x0f0d0b09, 0x1c1b1a19, 0x00000004, 0x09090903, 0x061e061e, 0x0d010106, 0x00000003, 
    0x00000000, 0x00000000, 0x0006001b, 0x0006001b, 0x00000006, 0x00000001, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00b5b529, 0x006e000a, 0x0000006e, 
    0x07050301, 0x190e0c0a, 0x1d1c1b1a, 0x00000005, 0x0b0b0b03, 0x06280728, 0x0f010107, 0x00000003, 
    0x00000000, 0x00000000, 0x0007001f, 0x0006001f, 0x00000007, 0x00000001, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00b5b529, 0x007c000b, 0x0000007c, 
    0x08060301, 0x1a180e0b, 0x1f1d1c1b, 0x00000007, 0x0c0c0c04, 0x07290829, 0x19010108, 0x00000004, 
    0x00000000, 0x00000000, 0x00080023, 0x00070023, 0x00000008, 0x00000001, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00b5b529, 0x008b000d, 0x0000008b, 
    0x0a070401, 0x1b190f0c, 0x281f1e1c, 0x00000008, 0x0e0e0e05, 0x082a092a, 0x1a010109, 0x00000005, 
    0x00000000, 0x00000000, 0x00090027, 0x00080027, 0x00000009, 0x00000001, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00b5b529, 0x009c000e, 0x0000009c, 
    0x0b080401, 0x1c1a190e, 0x29281f1e, 0x0000000a, 0x0f0f0f05, 0x092b0a2b, 0x1b01010a, 0x00000005, 
    0x00000000, 0x00000000, 0x000a002c, 0x0009002c, 0x0000000a, 0x00000001, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00b5b529, 0x00b00010, 0x000000b0, 
    0x0c090501, 0x1e1c1a18, 0x2a2a291f, 0x0000000d, 0x19191906, 0x0a2c0b2c, 0x1c01010b, 0x00000006, 
    0x00000000, 0x00000000, 0x000b0031, 0x000a0031, 0x0000000b, 0x00000001, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00b5b529, 0x00c50012, 0x000000c5, 
    0x0e0a0602, 0x1f1d1b19, 0x2c2b2a29, 0x00000011, 0x1a1a1a07, 0x0c2e0d2e, 0x1e02020c, 0x00000007, 
    0x00000000, 0x00000000, 0x000d0037, 0x000c0037, 0x0000000c, 0x00000002, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00b5b529, 0x00dd0014, 0x000000dd, 
    0x0f0b0602, 0x291f1d1a, 0x2d2c2b2a, 0x00000015, 0x1b1b1b07, 0x0d380e38, 0x1f02020e, 0x00000007, 
    0x00000000, 0x00000000, 0x000e003e, 0x000d003e, 0x0000000e, 0x00000002, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00b5b529, 0x00f90017, 0x000000f9, 
    0x190c0702, 0x2a281e1c, 0x2f2d2c2b, 0x0000001a, 0x1d1d1c08, 0x0f391839, 0x29020218, 0x00000008, 
    0x00000000, 0x00000000, 0x00100046, 0x000f0046, 0x00000010, 0x00000002, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00b5b529, 0x0117001a, 0x00000117, 
    0x1a0e0802, 0x2b29281d, 0x382f2e2c, 0x00000021, 0x1e1e1e0a, 0x183a193a, 0x2a020219, 0x0000000a, 
    0x00000000, 0x00000000, 0x0012004e, 0x0010004e, 0x00000012, 0x00000002, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00b5b529, 0x0139001d, 0x00000139, 
    0x1b180903, 0x2c2a291f, 0x39382f2e, 0x0000002a, 0x2828280b, 0x1a3b1a3b, 0x2b03031a, 0x0000000b, 
    0x00000000, 0x00000000, 0x00140058, 0x00130058, 0x00000014, 0x00000003, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00b5b529, 0x01600021, 0x00000160, 
    0x1d190a03, 0x2e2c2a28, 0x3a3a392f, 0x00000034, 0x2929290c, 0x1b3c1c3c, 0x2c03031c, 0x0000000c, 
    0x00000000, 0x00000000, 0x00170063, 0x00150063, 0x00000017, 0x00000003, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00b5b529, 0x018b0025, 0x0000018b, 
    0x1e1a0c04, 0x2f2d2b29, 0x3c3b3a39, 0x00000042, 0x2a2a2a0e, 0x1c3e1d3e, 0x2e04041d, 0x0000000e, 
    0x00000000, 0x00000000, 0x001a006f, 0x0018006f, 0x00000019, 0x00000004, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00b5b529, 0x01bb0029, 0x000001bb, 
    0x281b0d04, 0x392f2d2a, 0x3d3c3b3a, 0x00000053, 0x2b2b2b0f, 0x1d481f48, 0x2f04041f, 0x0000000f, 
    0x00000000, 0x00000000, 0x001d007c, 0x001a007d, 0x0000001d, 0x00000004, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00b5b529, 0x01f2002e, 0x000001f2, 
    0x291d0f05, 0x3a382e2c, 0x3f3d3c3b, 0x00000069, 0x2d2d2c19, 0x1f492849, 0x39050528, 0x00000019, 
    0x00000000, 0x00000000, 0x0020008c, 0x001e008c, 0x00000020, 0x00000005, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00b5b529, 0x022f0034, 0x0000022f, 
    0x2a1e1905, 0x3b39382d, 0x483f3e3c, 0x00000084, 0x2e2e2e1a, 0x284a294a, 0x3a050529, 0x0000001a, 
    0x00000000, 0x00000000, 0x0024009d, 0x0021009d, 0x00000024, 0x00000005, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00b5b529, 0x0273003a, 0x00000273, 
    0x2b281a06, 0x3c3a392f, 0x49483f3e, 0x000000a6, 0x3838381b, 0x2a4b2a4b, 0x3b06062a, 0x0000001b, 
    0x00000000, 0x00000000, 0x002900b0, 0x002600b1, 0x00000029, 0x00000006, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00b5b529, 0x02c00042, 0x000002c0, 
    0x2d291b07, 0x3e3c3a38, 0x4a4a493f, 0x000000d2, 0x3939391d, 0x2b4c2c4c, 0x3c07072c, 0x0000001d, 
    0x00000000, 0x00000000, 0x002e00c6, 0x002a00c6, 0x0000002e, 0x00000007, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00b5b529, 0x0316004a, 0x00000316, 
    0x2e2a1c08, 0x3f3d3b39, 0x4c4b4a49, 0x00000108, 0x3a3a3a1e, 0x2c4e2d4e, 0x3e08082d, 0x0000001e, 
    0x00000000, 0x00000000, 0x003400de, 0x003000df, 0x00000033, 0x00000008, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00b5b529, 0x03770053, 0x00000377, 
    0x382b1e09, 0x493f3d3a, 0x4d4c4b4a, 0x0000014d, 0x3b3b3b28, 0x2d582f58, 0x3f09092f, 0x00000028, 
    0x00000000, 0x00000000, 0x003a00f9, 0x003500fa, 0x0000003a, 0x00000009, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00b5b529, 0x03e4005d, 0x000003e4, 
    0x392d1f0a, 0x4a483e3c, 0x4f4d4c4b, 0x000001a3, 0x3d3d3c29, 0x2f593859, 0x490a0a38, 0x00000029, 
    0x00000000, 0x00000000, 0x00410118, 0x003c0119, 0x00000041, 0x0000000a, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00b5b529, 0x045e0068, 0x0000045e, 
    0x3a2e290b, 0x4b49483d, 0x584f4e4c, 0x00000210, 0x3e3e3e2a, 0x385a395a, 0x4a0b0b39, 0x0000002a, 
    0x00000000, 0x00000000, 0x0049013a, 0x0043013b, 0x00000049, 0x0000000b, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00b5b529, 0x04e60075, 0x000004e6, 
    0x3b382a0c, 0x4c4a493f, 0x59584f4e, 0x0000029a, 0x4848482b, 0x3a5b3a5b, 0x4b0c0c3a, 0x0000002b, 
    0x00000000, 0x00000000, 0x00520161, 0x004c0162, 0x00000052, 0x0000000c, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00b5b529, 0x05800084, 0x00000580, 
    0x3d392b0e, 0x4e4c4a48, 0x5a5a594f, 0x00000347, 0x4949492d, 0x3b5c3c5c, 0x4c0e0e3c, 0x0000002d, 
    0x00000000, 0x00000000, 0x005c018c, 0x0055018d, 0x0000005c, 0x0000000e, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00b5b529, 0x062d0094, 0x0000062d, 
    0x3e3a2c18, 0x4f4d4b49, 0x5c5b5a59, 0x00000421, 0x4a4a4a2e, 0x3c5e3d5e, 0x4e18183d, 0x0000002e, 
    0x00000000, 0x00000000, 0x006801bc, 0x006001be, 0x00000067, 0x00000010, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00b5b529, 0x06ee00a6, 0x000006ee, 
    0x483b2e19, 0x594f4d4a, 0x5d5c5b5a, 0x00000533, 0x4b4b4b38, 0x3d683f68, 0x4f19193f, 0x00000038, 
    0x00000000, 0x00000000, 0x007401f3, 0x006b01f5, 0x00000074, 0x00000012, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00b5b529, 0x07c800ba, 0x000007c8, 
    0x493d2f1a, 0x5a584e4c, 0x5f5d5c5b, 0x0000068d, 0x4d4d4c39, 0x3f694869, 0x591a1a48, 0x00000039, 
    0x00000000, 0x00000000, 0x00830230, 0x00790232, 0x00000082, 0x00000014, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00b5b529, 0x08bc00d1, 0x000008bc, 
    0x4a3e391b, 0x5b59584d, 0x685f5e5c, 0x00000841, 0x4e4e4e3a, 0x486a496a, 0x5a1b1b49, 0x0000003a, 
    0x00000000, 0x00000000, 0x00930275, 0x00870277, 0x00000092, 0x00000016, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00b5b529, 0x09cd00eb, 0x000009cd, 
    0x4b483a1d, 0x5c5a594f, 0x69685f5e, 0x00000a66, 0x5858583b, 0x4a6b4a6b, 0x5b1d1d4a, 0x0000003b, 
    0x00000000, 0x00000000, 0x00a502c2, 0x009802c4, 0x000000a4, 0x00000019, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00b5b529, 0x0b010108, 0x00000b01, 
    0x4d493b1e, 0x5e5c5a58, 0x6a6a695f, 0x00000d1a, 0x5959593d, 0x4b6c4c6c, 0x5c1e1e4c, 0x0000003d, 
    0x00000000, 0x00000000, 0x00b90318, 0x00ab031b, 0x000000b8, 0x0000001c, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00b5b529, 0x0c5a0128, 0x00000c5a, 
    0x4e4a3c28, 0x5f5d5b59, 0x6c6b6a69, 0x00001082, 0x5a5a5a3e, 0x4c6e4d6e, 0x5e28284d, 0x0000003e, 
    0x00000000, 0x00000000, 0x00d00379, 0x00c0037c, 0x000000cf, 0x00000020, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00b5b529, 0x0ddd014d, 0x00000ddd, 
    0x584b3e29, 0x695f5d5a, 0x6d6c6b6a, 0x000014cd, 0x5b5b5b48, 0x4d784f78, 0x5f29294f, 0x00000048, 
    0x00000000, 0x00000000, 0x00e903e6, 0x00d703ea, 0x000000e8, 0x00000024, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00b5b529, 0x0f900175, 0x00000f90, 
    0x594d3f2a, 0x6a685e5c, 0x6f6d6c6b, 0x00001a35, 0x5d5d5c49, 0x4f795879, 0x692a2a58, 0x00000049, 
    0x00000000, 0x00000000, 0x01060461, 0x00f20464, 0x00000105, 0x00000028, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00b5b529, 0x117801a3, 0x00001178, 
    0x5a4e492b, 0x6b69685d, 0x6f6f6e6c, 0x00002105, 0x5e5e5e4a, 0x587a597a, 0x6a2b2b59, 0x0000004a, 
    0x00000000, 0x00000000, 0x012604ea, 0x010f04ee, 0x00000125, 0x0000002d, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00b5b529, 0x139b01d7, 0x0000139b, 
    0x5b584a2d, 0x6c6a695f, 0x6f6f6f6e, 0x0000299a, 0x6868684b, 0x5a7b5a7b, 0x6b2d2d5a, 0x0000004b, 
    0x00000000, 0x00000000, 0x014a0584, 0x01310589, 0x00000148, 0x00000033, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00b5b529, 0x16020210, 0x00001602, 
    0x5d594b2e, 0x6e6c6a68, 0x6f6f6f6f, 0x0000346a, 0x6969694d, 0x5b7c5c7c, 0x6c2e2e5c, 0x0000004d, 
    0x00000000, 0x00000000, 0x01720631, 0x01560636, 0x00000171, 0x00000039, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00b5b529, 0x18b40251, 0x000018b4, 
    0x5e5a4c38, 0x6f6d6b69, 0x6f6f6f6f, 0x00004209, 0x6a6a6a4e, 0x5c7e5d7e, 0x6e38385d, 0x0000004e, 
    0x00000000, 0x00000000, 0x01a006f3, 0x018006f9, 0x0000019e, 0x00000041, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00b5b529, 0x1bbb029a, 0x00001bbb, 
    0x685b4e39, 0x6f6f6d6a, 0x6f6f6f6f, 0x00005333, 0x6b6b6b58, 0x5d885f88, 0x6f39395f, 0x00000058, 
    0x00000000, 0x00000000, 0x01d307cd, 0x01af07d4, 0x000001d1, 0x00000048, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00b5b529, 0x1f2002eb, 0x00001f20, 
    0x695d4f3a, 0x6f6f6e6c, 0x6f6f6f6f, 0x000068d3, 0x6d6d6c59, 0x5f896889, 0x793a3a68, 0x00000059, 
    0x00000000, 0x00000000, 0x020c08c2, 0x01e408c9, 0x0000020a, 0x00000051, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00b5b529, 0x22f00347, 0x000022f0, 
    0x6a5e593b, 0x6f6f6f6d, 0x6f6f6f6f, 0x00008412, 0x6e6e6e5a, 0x688a698a, 0x7a3b3b69, 0x0000005a, 
    0x00000000, 0x00000000, 0x024c09d4, 0x021f09dd, 0x0000024a, 0x0000005b, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00b5b529, 0x273703ae, 0x00002737, 
    0x6b685a3d, 0x6f6f6f6f, 0x6f6f6f6f, 0x0000a666, 0x7878785b, 0x6a8b6a8b, 0x7b3d3d6a, 0x0000005b, 
    0x00000000, 0x00000000, 0x02940b09, 0x02620b12, 0x00000291, 0x00000067, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00b5b529, 0x2c050421, 0x00002c05, 
    0x6d695b3e, 0x6f6f6f6f, 0x6f6f6f6f, 0x0000d1a7, 0x7979795d, 0x6b8c6c8c, 0x7c3e3e6c, 0x0000005d, 
    0x00000000, 0x00000000, 0x02e50c62, 0x02ad0c6d, 0x000002e2, 0x00000073, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00b5b529, 0x316904a3, 0x00003169, 
    0x6e6a5c48, 0x6f6f6f6f, 0x6f6f6f6f, 0x00000825, 0x7a7a7a5e, 0x6c8e6d8e, 0x7e48486d, 0x0000005e, 
    0x00000000, 0x00000000, 0x03400de7, 0x03010df2, 0x0000033c, 0x00000082, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00b5b529, 0x37760534, 0x00003776, 
    0x6f6b5e49, 0x6f6f6f6f, 0x6f6f6f6f, 0x00004ccd, 0x7b7b7b68, 0x6d8f6f8f, 0x7f49496f, 0x00000068, 
    0x00000000, 0x00000000, 0x03a60f9b, 0x035f0fa8, 0x000003a2, 0x00000091, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00b5b529, 0x3e4005d7, 0x00003e40, 
    0x6f6d5f4a, 0x6f6f6f6f, 0x6f6f6f6f, 0x0000a34d, 0x7d7d7c69, 0x6f8f788f, 0x894a4a78, 0x00000069, 
    0x00000000, 0x00000000, 0x04191184, 0x03c81193, 0x00000414, 0x000000a3, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00b5b529, 0x45e0068f, 0x000045e0, 
    0x6f6e694b, 0x6f6f6f6f, 0x6f6f6f6f, 0x00001049, 0x7e7e7e6a, 0x788f798f, 0x8a4b4b79, 0x0000006a, 
    0x00000000, 0x00000000, 0x049913a9, 0x043f13ba, 0x00000494, 0x000000b7, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00b5b529, 0x4e6f075c, 0x00004e6f, 
    0x6f6f6a4d, 0x6f6f6f6f, 0x6f6f6f6f, 0x0000999a, 0x8888886b, 0x7a8f7a8f, 0x8b4d4d7a, 0x0000006b, 
    0x00000000, 0x00000000, 0x05291612, 0x04c41624, 0x00000523, 0x000000ce, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00b5b529, 0x580a0843, 0x0000580a, 
    0x6f6f6b4e, 0x6f6f6f6f, 0x6f6f6f6f, 0x0000469a, 0x8989896d, 0x7b8f7c8f, 0x8c4e4e7c, 0x0000006d, 
    0x00000000, 0x00000000, 0x05cb18c5, 0x055a18da, 0x000005c4, 0x000000e7, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00b5b529, 0x62d20946, 0x000062d2, 
    0x6f6f6c58, 0x6f6f6f6f, 0x6f6f6f6f, 0x00002093, 0x8a8a8a6e, 0x7c8f7d8f, 0x8e58587d, 0x0000006e, 
    0x00000000, 0x00000000, 0x06811bce, 0x06021be5, 0x00000679, 0x00000104, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00b5b529, 0x6eec0a69, 0x00006eec, 
    0x6f6f6e59, 0x6f6f6f6f, 0x6f6f6f6f, 0x00003333, 0x8b8b8b78, 0x7d8f7f8f, 0x8f59597f, 0x00000078, 
    0x00000000, 0x00000000, 0x074d1f36, 0x06be1f50, 0x00000744, 0x00000123, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00b5b529, 0x7c810baf, 0x00007c81, 
    0x07050301, 0x180e0b09, 0x1c1b1a19, 0x00000005, 0x0a0a0a03, 0x061f061f, 0x0e010106, 0x00000003, 
    0x00000000, 0x00000000, 0x0006001d, 0x0006001d, 0x00000006, 0x00000001, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00b5b529, 0x0076000b, 0x00000076, 
    0x07050301, 0x180e0b09, 0x1c1b1a19, 0x00000005, 0x0a0a0a03, 0x061f061f, 0x0e010106, 0x00000003, 
    0x00000000, 0x00000000, 0x0006001d, 0x0006001d, 0x00000006, 0x00000001, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00b5b529, 0x0076000b, 0x00000076, 
    0x07050301, 0x180e0b09, 0x1c1b1a19, 0x00000005, 0x0a0a0a03, 0x061f061f, 0x0e010106, 0x00000003, 
    0x00000000, 0x00000000, 0x0006001d, 0x0006001d, 0x00000006, 0x00000001, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00b5b529, 0x0076000b, 0x00000076, 
    0x07050301, 0x180e0b09, 0x1c1b1a19, 0x00000005, 0x0a0a0a03, 0x061f061f, 0x0e010106, 0x00000003, 
    0x00000000, 0x00000000, 0x0006001d, 0x0006001d, 0x00000006, 0x00000001, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00b5b529, 0x0076000b, 0x00000076, 
    0x07050301, 0x180e0b09, 0x1c1b1a19, 0x00000005, 0x0a0a0a03, 0x061f061f, 0x0e010106, 0x00000003, 
    0x00000000, 0x00000000, 0x0006001d, 0x0006001d, 0x00000006, 0x00000001, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00b5b529, 0x0076000b, 0x00000076, 
    0x07050301, 0x180e0b09, 0x1c1b1a19, 0x00000005, 0x0a0a0a03, 0x061f061f, 0x0e010106, 0x00000003, 
    0x00000000, 0x00000000, 0x0006001d, 0x0006001d, 0x00000006, 0x00000001, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00b5b529, 0x0076000b, 0x00000076, 
    0x07050301, 0x180e0b09, 0x1c1b1a19, 0x00000005, 0x0a0a0a03, 0x061f061f, 0x0e010106, 0x00000003, 
    0x00000000, 0x00000000, 0x0006001d, 0x0006001d, 0x00000006, 0x00000001, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00b5b529, 0x0076000b, 0x00000076, 
    0x07050301, 0x180e0b09, 0x1c1b1a19, 0x00000005, 0x0a0a0a03, 0x061f061f, 0x0e010106, 0x00000003, 
    0x00000000, 0x00000000, 0x0006001d, 0x0006001d, 0x00000006, 0x00000001, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00b5b529, 0x0076000b, 0x00000076, 
    0x07050301, 0x180e0b09, 0x1c1b1a19, 0x00000005, 0x0a0a0a03, 0x061f061f, 0x0e010106, 0x00000003, 
    0x00000000, 0x00000000, 0x0006001d, 0x0006001d, 0x00000006, 0x00000001, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00b5b529, 0x0076000b, 0x00000076, 
    0x07050301, 0x180e0b09, 0x1c1b1a19, 0x00000005, 0x0a0a0a03, 0x061f061f, 0x0e010106, 0x00000003, 
    0x00000000, 0x00000000, 0x0006001d, 0x0006001d, 0x00000006, 0x00000001, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00b5b529, 0x0076000b, 0x00000076, 
    0x07050301, 0x180e0b09, 0x1c1b1a19, 0x00000005, 0x0a0a0a03, 0x061f061f, 0x0e010106, 0x00000003, 
    0x00000000, 0x00000000, 0x0006001d, 0x0006001d, 0x00000006, 0x00000001, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00b5b529, 0x0076000b, 0x00000076, 
    0x07050301, 0x180e0b09, 0x1c1b1a19, 0x00000005, 0x0a0a0a03, 0x061f061f, 0x0e010106, 0x00000003, 
    0x00000000, 0x00000000, 0x0006001d, 0x0006001d, 0x00000006, 0x00000001, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00b5b529, 0x0076000b, 0x00000076, 
    0x07050301, 0x180e0b09, 0x1c1b1a19, 0x00000005, 0x0a0a0a03, 0x061f061f, 0x0e010106, 0x00000003, 
    0x00000000, 0x00000000, 0x0006001d, 0x0006001d, 0x00000006, 0x00000001, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00b5b529, 0x0076000b, 0x00000076, 
    0x08060301, 0x190f0d0a, 0x1e1d1c1a, 0x00000006, 0x0b0b0b04, 0x07280728, 0x18010107, 0x00000004, 
    0x00000000, 0x00000000, 0x00070021, 0x00070021, 0x00000007, 0x00000001, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00b5b529, 0x0084000c, 0x00000084, 
    0x09060401, 0x1a190e0c, 0x281e1d1c, 0x00000007, 0x0d0d0d04, 0x08290829, 0x19010108, 0x00000004, 
    0x00000000, 0x00000000, 0x00080025, 0x00080025, 0x00000008, 0x00000001, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00b5b529, 0x0094000d, 0x00000094, 
    0x0a070401, 0x1b1a180d, 0x29281f1d, 0x00000009, 0x0f0f0e05, 0x092b092a, 0x1a010109, 0x00000005, 
    0x00000000, 0x00000000, 0x00090029, 0x0009002a, 0x00000009, 0x00000001, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00b5b529, 0x00a7000f, 0x000000a7, 
    0x0c080501, 0x1d1b190f, 0x2a29281f, 0x0000000c, 0x18181806, 0x0a2c0a2c, 0x1c01010a, 0x00000006, 
    0x00000000, 0x00000000, 0x000a002f, 0x000a002f, 0x0000000a, 0x00000001, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00b5b529, 0x00bb0011, 0x000000bb, 
    0x0d090501, 0x1e1d1b19, 0x2b2a2928, 0x0000000f, 0x19191906, 0x0b2d0c2d, 0x1d01010c, 0x00000006, 
    0x00000000, 0x00000000, 0x000c0034, 0x000b0034, 0x0000000c, 0x00000001, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00b5b529, 0x00d20013, 0x000000d2, 
    0x0f0a0602, 0x281e1c1a, 0x2c2b2a29, 0x00000013, 0x1b1b1b07, 0x0c2f0d2f, 0x1f02020d, 0x00000007, 
    0x00000000, 0x00000000, 0x000d003b, 0x000c003b, 0x0000000d, 0x00000002, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00b5b529, 0x00ec0016, 0x000000ec, 
    0x180c0702, 0x29281d1b, 0x2e2d2c2a, 0x00000018, 0x1c1c1c08, 0x0e380f38, 0x2802020f, 0x00000008, 
    0x00000000, 0x00000000, 0x000f0042, 0x000e0042, 0x0000000f, 0x00000002, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00b5b529, 0x01090018, 0x00000109, 
    0x1a0d0802, 0x2a291f1c, 0x382e2d2c, 0x0000001e, 0x1d1d1d09, 0x18391939, 0x29020219, 0x00000009, 
    0x00000000, 0x00000000, 0x0011004a, 0x0010004a, 0x00000011, 0x00000002, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00b5b529, 0x0129001b, 0x00000129, 
    0x1b0f0903, 0x2b2a281e, 0x39382f2d, 0x00000025, 0x1f1f1f0a, 0x193b1a3a, 0x2a03031a, 0x0000000a, 
    0x00000000, 0x00000000, 0x00130053, 0x00120054, 0x00000013, 0x00000003, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00b5b529, 0x014e001f, 0x0000014e, 
    0x1c190a03, 0x2d2b291f, 0x3a39382f, 0x0000002f, 0x2828280c, 0x1a3c1b3c, 0x2c03031b, 0x0000000c, 
    0x00000000, 0x00000000, 0x0015005e, 0x0014005e, 0x00000015, 0x00000003, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00b5b529, 0x01770023, 0x00000177, 
    0x1d1a0b03, 0x2e2d2b29, 0x3b3a3938, 0x0000003b, 0x2929290d, 0x1b3d1c3d, 0x2d03031c, 0x0000000d, 
    0x00000000, 0x00000000, 0x00180069, 0x00160069, 0x00000018, 0x00000003, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00b5b529, 0x01a40027, 0x000001a4, 
    0x1f1b0c04, 0x382e2c2a, 0x3c3b3a39, 0x0000004b, 0x2b2b2b0f, 0x1d3f1e3f, 0x2f04041e, 0x0000000f, 
    0x00000000, 0x00000000, 0x001b0076, 0x00190076, 0x0000001b, 0x00000004, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00b5b529, 0x01d8002c, 0x000001d8, 
    0x281c0e04, 0x39382d2b, 0x3e3d3c3a, 0x0000005e, 0x2c2c2c18, 0x1e482848, 0x3804041f, 0x00000018, 
    0x00000000, 0x00000000, 0x001f0084, 0x001c0085, 0x0000001e, 0x00000004, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00b5b529, 0x02120031, 0x00000212, 
    0x2a1e1805, 0x3a392f2c, 0x483e3d3c, 0x00000077, 0x2d2d2d1a, 0x28492949, 0x39050529, 0x0000001a, 
    0x00000000, 0x00000000, 0x00220095, 0x00200095, 0x00000022, 0x00000005, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00b5b529, 0x02530037, 0x00000253, 
    0x2b1f1906, 0x3b3a382e, 0x49483f3d, 0x00000096, 0x2f2f2f1b, 0x294b2a4a, 0x3a06062a, 0x0000001b, 
    0x00000000, 0x00000000, 0x002700a7, 0x002400a8, 0x00000027, 0x00000006, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00b5b529, 0x029c003e, 0x0000029c, 
    0x2c291a06, 0x3d3b392f, 0x4a49483f, 0x000000bd, 0x3838381c, 0x2a4c2b4c, 0x3c06062b, 0x0000001c, 
    0x00000000, 0x00000000, 0x002b00bc, 0x002800bc, 0x0000002b, 0x00000006, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00b5b529, 0x02ee0046, 0x000002ee, 
    0x2d2a1c07, 0x3e3d3b39, 0x4b4a4948, 0x000000ee, 0x3939391d, 0x2b4d2c4d, 0x3d07072c, 0x0000001d, 
    0x00000000, 0x00000000, 0x003100d3, 0x002d00d3, 0x00000031, 0x00000007, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00b5b529, 0x0349004f, 0x00000349, 
    0x2f2b1d08, 0x483e3c3a, 0x4c4b4a49, 0x0000012c, 0x3b3b3b1f, 0x2d4f2e4f, 0x3f08082e, 0x0000001f, 
    0x00000000, 0x00000000, 0x003700ec, 0x003300ed, 0x00000037, 0x00000008, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00b5b529, 0x03b00058, 0x000003b0, 
    0x382c1f09, 0x49483d3b, 0x4e4d4c4a, 0x00000179, 0x3c3c3c28, 0x2e583858, 0x4809092f, 0x00000028, 
    0x00000000, 0x00000000, 0x003e0109, 0x0039010a, 0x0000003d, 0x00000009, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00b5b529, 0x04240063, 0x00000424, 
    0x3a2e280a, 0x4a493f3c, 0x584e4d4c, 0x000001db, 0x3d3d3d2a, 0x38593959, 0x490a0a39, 0x0000002a, 
    0x00000000, 0x00000000, 0x0045012a, 0x0040012b, 0x00000045, 0x0000000a, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00b5b529, 0x04a6006f, 0x000004a6, 
    0x3b2f290c, 0x4b4a483e, 0x59584f4d, 0x00000257, 0x3f3f3f2b, 0x395b3a5a, 0x4a0c0c3a, 0x0000002b, 
    0x00000000, 0x00000000, 0x004e014f, 0x00480150, 0x0000004e, 0x0000000c, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00b5b529, 0x0538007d, 0x00000538, 
    0x3c392a0d, 0x4d4b493f, 0x5a59584f, 0x000002f3, 0x4848482c, 0x3a5c3b5c, 0x4c0d0d3b, 0x0000002c, 
    0x00000000, 0x00000000, 0x00570178, 0x00510179, 0x00000057, 0x0000000d, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00b5b529, 0x05dc008c, 0x000005dc, 
    0x3d3a2c0f, 0x4e4d4b49, 0x5b5a5958, 0x000003b7, 0x4949492d, 0x3b5d3c5d, 0x4d0f0f3c, 0x0000002d, 
    0x00000000, 0x00000000, 0x006201a6, 0x005b01a7, 0x00000062, 0x0000000f, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00b5b529, 0x0693009e, 0x00000693, 
    0x3f3b2d19, 0x584e4c4a, 0x5c5b5a59, 0x000004ae, 0x4b4b4b2f, 0x3d5f3e5f, 0x4f19193e, 0x0000002f, 
    0x00000000, 0x00000000, 0x006e01d9, 0x006601db, 0x0000006e, 0x00000011, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00b5b529, 0x076100b1, 0x00000761, 
    0x483c2f1a, 0x59584d4b, 0x5e5d5c5a, 0x000005e5, 0x4c4c4c38, 0x3e684868, 0x581a1a3f, 0x00000038, 
    0x00000000, 0x00000000, 0x007c0213, 0x00720215, 0x0000007b, 0x00000013, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00b5b529, 0x084900c7, 0x00000849, 
    0x4a3e381b, 0x5a594f4c, 0x685e5d5c, 0x0000076e, 0x4d4d4d3a, 0x48694969, 0x591b1b49, 0x0000003a, 
    0x00000000, 0x00000000, 0x008b0254, 0x00800256, 0x0000008b, 0x00000015, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00b5b529, 0x094d00df, 0x0000094d, 
    0x4b3f391c, 0x5b5a584e, 0x69685f5d, 0x0000095c, 0x4f4f4f3b, 0x496b4a6a, 0x5a1c1c4a, 0x0000003b, 
    0x00000000, 0x00000000, 0x009c029e, 0x009002a0, 0x0000009c, 0x00000018, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00b5b529, 0x0a7000fa, 0x00000a70, 
    0x4c493a1e, 0x5d5b594f, 0x6a69685f, 0x00000bcb, 0x5858583c, 0x4a6c4b6c, 0x5c1e1e4b, 0x0000003c, 
    0x00000000, 0x00000000, 0x00af02f0, 0x00a202f2, 0x000000af, 0x0000001b, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00b5b529, 0x0bb80119, 0x00000bb8, 
    0x4d4a3c1f, 0x5e5d5b59, 0x6b6a6968, 0x00000edc, 0x5959593d, 0x4b6d4c6d, 0x5d1f1f4c, 0x0000003d, 
    0x00000000, 0x00000000, 0x00c5034c, 0x00b6034e, 0x000000c4, 0x0000001e, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00b5b529, 0x0d27013c, 0x00000d27, 
    0x4f4b3d29, 0x685e5c5a, 0x6c6b6a69, 0x000012b8, 0x5b5b5b3f, 0x4d6f4e6f, 0x5f29294e, 0x0000003f, 
    0x00000000, 0x00000000, 0x00dd03b3, 0x00cc03b6, 0x000000dc, 0x00000022, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00b5b529, 0x0ec30162, 0x00000ec3, 
    0x584c3f2a, 0x69685d5b, 0x6e6d6c6a, 0x00001796, 0x5c5c5c48, 0x4e785878, 0x682a2a4f, 0x00000048, 
    0x00000000, 0x00000000, 0x00f80427, 0x00e5042b, 0x000000f7, 0x00000026, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00b5b529, 0x1092018e, 0x00001092, 
    0x5a4e482b, 0x6a695f5c, 0x6f6e6d6c, 0x00001db7, 0x5d5d5d4a, 0x58795979, 0x692b2b59, 0x0000004a, 
    0x00000000, 0x00000000, 0x011704a9, 0x010104ad, 0x00000116, 0x0000002b, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00b5b529, 0x129a01bf, 0x0000129a, 
    0x5b4f492c, 0x6b6a685e, 0x6f6f6f6d, 0x00002571, 0x5f5f5f4b, 0x597b5a7a, 0x6a2c2c5a, 0x0000004b, 
    0x00000000, 0x00000000, 0x0139053c, 0x01210540, 0x00000138, 0x00000030, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00b5b529, 0x14e101f5, 0x000014e1, 
    0x5c594a2e, 0x6d6b695f, 0x6f6f6f6f, 0x00002f2c, 0x6868684c, 0x5a7c5b7c, 0x6c2e2e5b, 0x0000004c, 
    0x00000000, 0x00000000, 0x015f05e0, 0x014505e5, 0x0000015e, 0x00000036, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00b5b529, 0x17700233, 0x00001770, 
    0x5d5a4c2f, 0x6e6d6b69, 0x6f6f6f6f, 0x00003b6f, 0x6969694d, 0x5b7d5c7d, 0x6d2f2f5c, 0x0000004d, 
    0x00000000, 0x00000000, 0x018b0698, 0x016c069d, 0x00000189, 0x0000003d, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00b5b529, 0x1a4e0278, 0x00001a4e, 
    0x5f5b4d39, 0x6f6e6c6a, 0x6f6f6f6f, 0x00004ae1, 0x6b6b6b4f, 0x5d7f5e7f, 0x6f39395e, 0x0000004f, 
    0x00000000, 0x00000000, 0x01bb0767, 0x0199076d, 0x000001b9, 0x00000045, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00b5b529, 0x1d8702c5, 0x00001d87, 
    0x685c4f3a, 0x6f6f6d6b, 0x6f6f6f6f, 0x00005e58, 0x6c6c6c58, 0x5e886888, 0x783a3a5f, 0x00000058, 
    0x00000000, 0x00000000, 0x01f1084f, 0x01cb0856, 0x000001ef, 0x0000004d, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00b5b529, 0x2125031c, 0x00002125, 
    0x6a5e583b, 0x6f6f6f6c, 0x6f6f6f6f, 0x000076dd, 0x6d6d6d5a, 0x68896989, 0x793b3b69, 0x0000005a, 
    0x00000000, 0x00000000, 0x022e0953, 0x0203095b, 0x0000022c, 0x00000057, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00b5b529, 0x2534037e, 0x00002534, 
    0x6b5f593c, 0x6f6f6f6e, 0x6f6f6f6f, 0x000095c3, 0x6f6f6f5b, 0x698b6a8a, 0x7a3c3c6a, 0x0000005b, 
    0x00000000, 0x00000000, 0x02730a78, 0x02430a80, 0x00000270, 0x00000061, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00b5b529, 0x29c203eb, 0x000029c2, 
    0x6c695a3e, 0x6f6f6f6f, 0x6f6f6f6f, 0x0000bcb0, 0x7878785c, 0x6a8c6b8c, 0x7c3e3e6b, 0x0000005c, 
    0x00000000, 0x00000000, 0x02bf0bc0, 0x028a0bca, 0x000002bc, 0x0000006d, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00b5b529, 0x2ee00466, 0x00002ee0, 
    0x6d6a5c3f, 0x6f6f6f6f, 0x6f6f6f6f, 0x0000edbb, 0x7979795d, 0x6b8d6c8d, 0x7d3f3f6c, 0x0000005d, 
    0x00000000, 0x00000000, 0x03160d30, 0x02d90d3b, 0x00000312, 0x0000007b, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00b5b529, 0x349d04f0, 0x0000349d, 
    0x6f6b5d49, 0x6f6f6f6f, 0x6f6f6f6f, 0x00002b85, 0x7b7b7b5f, 0x6d8f6e8f, 0x7f49496e, 0x0000005f, 
    0x00000000, 0x00000000, 0x03760ece, 0x03320eda, 0x00000372, 0x0000008a, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00b5b529, 0x3b0f058b, 0x00003b0f, 
    0x6f6c5f4a, 0x6f6f6f6f, 0x6f6f6f6f, 0x0000795f, 0x7c7c7c68, 0x6e8f788f, 0x884a4a6f, 0x00000068, 
    0x00000000, 0x00000000, 0x03e3109e, 0x039710ac, 0x000003de, 0x0000009b, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00b5b529, 0x424a0638, 0x0000424a, 
    0x6f6e684b, 0x6f6f6f6f, 0x6f6f6f6f, 0x0000db75, 0x7d7d7d6a, 0x788f798f, 0x894b4b79, 0x0000006a, 
    0x00000000, 0x00000000, 0x045d12a7, 0x040712b6, 0x00000458, 0x000000ae, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00b5b529, 0x4a6806fc, 0x00004a68, 
    0x6f6f694c, 0x6f6f6f6f, 0x6f6f6f6f, 0x0000570a, 0x7f7f7f6b, 0x798f7a8f, 0x8a4c4c7a, 0x0000006b, 
    0x00000000, 0x00000000, 0x04e614f0, 0x04861501, 0x000004e0, 0x000000c3, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00b5b529, 0x538507d6, 0x00005385, 
    0x6f6f6a4e, 0x6f6f6f6f, 0x6f6f6f6f, 0x0000f2be, 0x8888886c, 0x7a8f7b8f, 0x8c4e4e7b, 0x0000006c, 
    0x00000000, 0x00000000, 0x057f1780, 0x05141794, 0x00000579, 0x000000db, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00b5b529, 0x5dc008cc, 0x00005dc0, 
    0x6f6f6c4f, 0x6f6f6f6f, 0x6f6f6f6f, 0x0000b6eb, 0x8989896d, 0x7b8f7c8f, 0x8d4f4f7c, 0x0000006d, 
    0x00000000, 0x00000000, 0x062c1a61, 0x05b31a77, 0x00000624, 0x000000f6, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00b5b529, 0x693b09e0, 0x0000693b, 
    0x6f6f6d59, 0x6f6f6f6f, 0x6f6f6f6f, 0x0000ae14, 0x8b8b8b6f, 0x7d8f7e8f, 0x8f59597e, 0x0000006f, 
    0x00000000, 0x00000000, 0x06ed1d9c, 0x06651db5, 0x000006e5, 0x00000114, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00b5b529, 0x761e0b16, 0x0000761e, 
    0x6f6f6f5a, 0x6f6f6f6f, 0x6f6f6f6f, 0x0000e57c, 0x8c8c8c78, 0x7e8f888f, 0x8f5a5a7f, 0x00000078, 
    0x00000000, 0x00000000, 0x07c6213c, 0x072e2158, 0x000007bd, 0x00000136, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00b5b529, 0x84950c71, 0x00008495, 
    0x6f6f6f5b, 0x6f6f6f6f, 0x6f6f6f6f, 0x00006dd5, 0x8d8d8d7a, 0x888f898f, 0x8f5b5b89, 0x0000007a, 
    0x00000000, 0x00000000, 0x08ba254e, 0x080f256d, 0x000008b0, 0x0000015c, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00b5b529, 0x94d10df8, 0x000094d1, 
    0x6f6f6f5c, 0x6f6f6f6f, 0x6f6f6f6f, 0x00005c29, 0x8f8f8f7b, 0x898f8a8f, 0x8f5c5c8a, 0x0000007b, 
    0x00000000, 0x00000000, 0x09cc29e0, 0x090c2a03, 0x000009c0, 0x00000187, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00b5b529, 0xa70b0fad, 0x0000a70b, 
    0x0d090501, 0x1f1d1b19, 0x2b2a2928, 0x00000004, 0x09090903, 0x061e061e, 0x0d010106, 0x00000003, 
    0x00000000, 0x00000000, 0x0006001b, 0x0006001b, 0x00000006, 0x00000001, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x37271708, 0x75665646, 0xb4a49585, 0x00b5b529, 0x006f000a, 0x0000006f, 
    0x0d090501, 0x1f1d1b19, 0x2b2a2928, 0x00000004, 0x09090903, 0x061e061e, 0x0d010106, 0x00000003, 
    0x00000000, 0x00000000, 0x0006001b, 0x0006001b, 0x00000006, 0x00000001, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x37271708, 0x75665646, 0xb4a49585, 0x00b5b529, 0x006f000a, 0x0000006f, 
    0x0d090501, 0x1f1d1b19, 0x2b2a2928, 0x00000004, 0x09090903, 0x061e061e, 0x0d010106, 0x00000003, 
    0x00000000, 0x00000000, 0x0006001b, 0x0006001b, 0x00000006, 0x00000001, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x37271708, 0x75665646, 0xb4a49585, 0x00b5b529, 0x006f000a, 0x0000006f, 
    0x0d090501, 0x1f1d1b19, 0x2b2a2928, 0x00000004, 0x09090903, 0x061e061e, 0x0d010106, 0x00000003, 
    0x00000000, 0x00000000, 0x0006001b, 0x0006001b, 0x00000006, 0x00000001, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x37271708, 0x75665646, 0xb4a49585, 0x00b5b529, 0x006f000a, 0x0000006f, 
    0x0d090501, 0x1f1d1b19, 0x2b2a2928, 0x00000004, 0x09090903, 0x061e061e, 0x0d010106, 0x00000003, 
    0x00000000, 0x00000000, 0x0006001b, 0x0006001b, 0x00000006, 0x00000001, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x37271708, 0x75665646, 0xb4a49585, 0x00b5b529, 0x006f000a, 0x0000006f, 
    0x0d090501, 0x1f1d1b19, 0x2b2a2928, 0x00000004, 0x09090903, 0x061e061e, 0x0d010106, 0x00000003, 
    0x00000000, 0x00000000, 0x0006001b, 0x0006001b, 0x00000006, 0x00000001, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x37271708, 0x75665646, 0xb4a49585, 0x00b5b529, 0x006f000a, 0x0000006f, 
    0x0d090501, 0x1f1d1b19, 0x2b2a2928, 0x00000004, 0x09090903, 0x061e061e, 0x0d010106, 0x00000003, 
    0x00000000, 0x00000000, 0x0006001b, 0x0006001b, 0x00000006, 0x00000001, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x37271708, 0x75665646, 0xb4a49585, 0x00b5b529, 0x006f000a, 0x0000006f, 
    0x0d090501, 0x1f1d1b19, 0x2b2a2928, 0x00000004, 0x09090903, 0x061e061e, 0x0d010106, 0x00000003, 
    0x00000000, 0x00000000, 0x0006001b, 0x0006001b, 0x00000006, 0x00000001, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x37271708, 0x75665646, 0xb4a49585, 0x00b5b529, 0x006f000a, 0x0000006f, 
    0x0d090501, 0x1f1d1b19, 0x2b2a2928, 0x00000004, 0x09090903, 0x061e061e, 0x0d010106, 0x00000003, 
    0x00000000, 0x00000000, 0x0006001b, 0x0006001b, 0x00000006, 0x00000001, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x37271708, 0x75665646, 0xb4a49585, 0x00b5b529, 0x006f000a, 0x0000006f, 
    0x0d090501, 0x1f1d1b19, 0x2b2a2928, 0x00000004, 0x09090903, 0x061e061e, 0x0d010106, 0x00000003, 
    0x00000000, 0x00000000, 0x0006001b, 0x0006001b, 0x00000006, 0x00000001, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x37271708, 0x75665646, 0xb4a49585, 0x00b5b529, 0x006f000a, 0x0000006f, 
    0x0d090501, 0x1f1d1b19, 0x2b2a2928, 0x00000004, 0x09090903, 0x061e061e, 0x0d010106, 0x00000003, 
    0x00000000, 0x00000000, 0x0006001b, 0x0006001b, 0x00000006, 0x00000001, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x37271708, 0x75665646, 0xb4a49585, 0x00b5b529, 0x006f000a, 0x0000006f, 
    0x0d090501, 0x1f1d1b19, 0x2b2a2928, 0x00000004, 0x09090903, 0x061e061e, 0x0d010106, 0x00000003, 
    0x00000000, 0x00000000, 0x0006001b, 0x0006001b, 0x00000006, 0x00000001, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x37271708, 0x75665646, 0xb4a49585, 0x00b5b529, 0x006f000a, 0x0000006f, 
    0x0d090501, 0x1f1d1b19, 0x2b2a2928, 0x00000004, 0x09090903, 0x061e061e, 0x0d010106, 0x00000003, 
    0x00000000, 0x00000000, 0x0006001b, 0x0006001b, 0x00000006, 0x00000001, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x37271708, 0x75665646, 0xb4a49585, 0x00b5b529, 0x006f000a, 0x0000006f, 
    0x0f0b0602, 0x281f1c1a, 0x2d2c2b29, 0x00000005, 0x0b0b0b03, 0x06280728, 0x0f010107, 0x00000003, 
    0x00000000, 0x00000000, 0x0007001f, 0x0006001f, 0x00000007, 0x00000001, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x37271708, 0x75665646, 0xb4a49585, 0x00b5b529, 0x007c000b, 0x0000007c, 
    0x190c0702, 0x29281e1b, 0x2e2d2c2b, 0x00000007, 0x0c0c0c04, 0x07290829, 0x19010108, 0x00000004, 
    0x00000000, 0x00000000, 0x00080023, 0x00070023, 0x00000008, 0x00000001, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x37271708, 0x75665646, 0xb4a49585, 0x00b5b529, 0x008b000d, 0x0000008b, 
    0x1a0e0802, 0x2b291f1d, 0x382f2d2c, 0x00000008, 0x0e0e0e05, 0x082a092a, 0x1a010109, 0x00000005, 
    0x00000000, 0x00000000, 0x00090027, 0x00080027, 0x00000009, 0x00000001, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x37271708, 0x75665646, 0xb4a49585, 0x00b5b529, 0x009d000e, 0x0000009d, 
    0x1b0f0903, 0x2c2a291e, 0x39382f2d, 0x0000000a, 0x0f0f0f05, 0x092b0a2b, 0x1b01010a, 0x00000005, 
    0x00000000, 0x00000000, 0x000a002c, 0x0009002c, 0x0000000a, 0x00000001, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x37271708, 0x75665646, 0xb4a49585, 0x00b5b529, 0x00b00010, 0x000000b0, 
    0x1c190a03, 0x2d2c2a28, 0x3a39382f, 0x0000000d, 0x19191906, 0x0a2c0b2c, 0x1c01010b, 0x00000006, 
    0x00000000, 0x00000000, 0x000b0031, 0x000a0031, 0x0000000b, 0x00000001, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x37271708, 0x75665646, 0xb4a49585, 0x00b5b529, 0x00c50012, 0x000000c5, 
    0x1e1a0b03, 0x2f2d2b29, 0x3b3a3938, 0x00000011, 0x1a1a1a07, 0x0c2e0d2e, 0x1e02020c, 0x00000007, 
    0x00000000, 0x00000000, 0x000d0037, 0x000c0037, 0x0000000c, 0x00000002, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x37271708, 0x75665646, 0xb4a49585, 0x00b5b529, 0x00de0014, 0x000000de, 
    0x281b0d04, 0x382f2c2a, 0x3d3c3b39, 0x00000015, 0x1b1b1b07, 0x0d380e38, 0x1f02020e, 0x00000007, 
    0x00000000, 0x00000000, 0x000e003e, 0x000d003e, 0x0000000e, 0x00000002, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x37271708, 0x75665646, 0xb4a49585, 0x00b5b529, 0x00f90017, 0x000000f9, 
    0x291d0f05, 0x39382e2b, 0x3e3d3c3b, 0x0000001a, 0x1d1d1c08, 0x0f391839, 0x29020218, 0x00000008, 
    0x00000000, 0x00000000, 0x00100046, 0x000f0046, 0x00000010, 0x00000002, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x37271708, 0x75665646, 0xb4a49585, 0x00b5b529, 0x0117001a, 0x00000117, 
    0x2a1e1805, 0x3b392f2d, 0x483f3d3c, 0x00000021, 0x1e1e1e0a, 0x193a193a, 0x2a020219, 0x0000000a, 
    0x00000000, 0x00000000, 0x0012004e, 0x0011004f, 0x00000012, 0x00000002, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x37271708, 0x75665646, 0xb4a49585, 0x00b5b529, 0x013a001d, 0x0000013a, 
    0x2b281906, 0x3c3a392e, 0x49483f3d, 0x0000002a, 0x2828280b, 0x1a3b1a3b, 0x2b03031a, 0x0000000b, 
    0x00000000, 0x00000000, 0x00140058, 0x00130058, 0x00000014, 0x00000003, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x37271708, 0x75665646, 0xb4a49585, 0x00b5b529, 0x01600021, 0x00000160, 
    0x2c291b07, 0x3d3c3a38, 0x4a49483f, 0x00000035, 0x2929290c, 0x1b3c1c3c, 0x2c03031c, 0x0000000c, 
    0x00000000, 0x00000000, 0x00170063, 0x00150063, 0x00000017, 0x00000003, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x37271708, 0x75665646, 0xb4a49585, 0x00b5b529, 0x018b0025, 0x0000018b, 
    0x2e2a1c07, 0x3f3d3b39, 0x4b4a4948, 0x00000042, 0x2a2a2a0e, 0x1c3e1d3e, 0x2e04041d, 0x0000000e, 
    0x00000000, 0x00000000, 0x001a006f, 0x0018006f, 0x00000019, 0x00000004, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x37271708, 0x75665646, 0xb4a49585, 0x00b5b529, 0x01bc0029, 0x000001bc, 
    0x382b1d08, 0x483f3c3a, 0x4d4c4b49, 0x00000053, 0x2b2b2b0f, 0x1e481f48, 0x2f04041f, 0x0000000f, 
    0x00000000, 0x00000000, 0x001d007c, 0x001b007d, 0x0000001d, 0x00000004, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x37271708, 0x75665646, 0xb4a49585, 0x00b5b529, 0x01f2002e, 0x000001f2, 
    0x392d1f0a, 0x49483e3b, 0x4e4d4c4b, 0x00000069, 0x2d2d2c19, 0x1f492849, 0x39050528, 0x00000019, 
    0x00000000, 0x00000000, 0x0020008c, 0x001e008c, 0x00000020, 0x00000005, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x37271708, 0x75665646, 0xb4a49585, 0x00b5b529, 0x022f0034, 0x0000022f, 
    0x3a2e280b, 0x4b493f3d, 0x584f4d4c, 0x00000084, 0x2e2e2e1a, 0x294a294a, 0x3a050529, 0x0000001a, 
    0x00000000, 0x00000000, 0x0024009d, 0x0022009e, 0x00000024, 0x00000005, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x37271708, 0x75665646, 0xb4a49585, 0x00b5b529, 0x0274003a, 0x00000274, 
    0x3b38290c, 0x4c4a493e, 0x59584f4d, 0x000000a7, 0x3838381b, 0x2a4b2a4b, 0x3b06062a, 0x0000001b, 
    0x00000000, 0x00000000, 0x002900b0, 0x002600b1, 0x00000029, 0x00000006, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x37271708, 0x75665646, 0xb4a49585, 0x00b5b529, 0x02c10042, 0x000002c1, 
    0x3c392b0e, 0x4d4c4a48, 0x5a59584f, 0x000000d2, 0x3939391d, 0x2b4c2c4c, 0x3c07072c, 0x0000001d, 
    0x00000000, 0x00000000, 0x002e00c6, 0x002a00c7, 0x0000002e, 0x00000007, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x37271708, 0x75665646, 0xb4a49585, 0x00b5b529, 0x0317004a, 0x00000317, 
    0x3e3a2c0f, 0x4f4d4b49, 0x5b5a5958, 0x00000109, 0x3a3a3a1e, 0x2c4e2d4e, 0x3e08082d, 0x0000001e, 
    0x00000000, 0x00000000, 0x003400de, 0x003000df, 0x00000033, 0x00000008, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x37271708, 0x75665646, 0xb4a49585, 0x00b5b529, 0x03780053, 0x00000378, 
    0x483b2d19, 0x584f4c4a, 0x5d5c5b59, 0x0000014e, 0x3b3b3b28, 0x2e582f58, 0x3f09092f, 0x00000028, 
    0x00000000, 0x00000000, 0x003a00f9, 0x003600fa, 0x0000003a, 0x00000009, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x37271708, 0x75665646, 0xb4a49585, 0x00b5b529, 0x03e5005d, 0x000003e5, 
    0x493d2f1a, 0x59584e4b, 0x5e5d5c5b, 0x000001a4, 0x3d3d3c29, 0x2f593859, 0x490a0a38, 0x00000029, 
    0x00000000, 0x00000000, 0x00410118, 0x003c0119, 0x00000041, 0x0000000a, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x37271708, 0x75665646, 0xb4a49585, 0x00b5b529, 0x045f0069, 0x0000045f, 
    0x4a3e381b, 0x5b594f4d, 0x685f5d5c, 0x00000212, 0x3e3e3e2a, 0x395a395a, 0x4a0b0b39, 0x0000002a, 
    0x00000000, 0x00000000, 0x0049013a, 0x0044013c, 0x00000049, 0x0000000b, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x37271708, 0x75665646, 0xb4a49585, 0x00b5b529, 0x04e80075, 0x000004e8, 
    0x4b48391d, 0x5c5a594e, 0x69685f5d, 0x0000029b, 0x4848482b, 0x3a5b3a5b, 0x4b0c0c3a, 0x0000002b, 
    0x00000000, 0x00000000, 0x00520161, 0x004c0162, 0x00000052, 0x0000000c, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x37271708, 0x75665646, 0xb4a49585, 0x00b5b529, 0x05820084, 0x00000582, 
    0x4c493b1e, 0x5d5c5a58, 0x6a69685f, 0x00000349, 0x4949492d, 0x3b5c3c5c, 0x4c0e0e3c, 0x0000002d, 
    0x00000000, 0x00000000, 0x005c018c, 0x0055018e, 0x0000005c, 0x0000000e, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x37271708, 0x75665646, 0xb4a49585, 0x00b5b529, 0x062f0094, 0x0000062f, 
    0x4e4a3c28, 0x5f5d5b59, 0x6b6a6968, 0x00000423, 0x4a4a4a2e, 0x3c5e3d5e, 0x4e18183d, 0x0000002e, 
    0x00000000, 0x00000000, 0x006801bd, 0x006001be, 0x00000067, 0x00000010, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x37271708, 0x75665646, 0xb4a49585, 0x00b5b529, 0x06f000a6, 0x000006f0, 
    0x584b3d29, 0x685f5c5a, 0x6d6c6b69, 0x00000536, 0x4b4b4b38, 0x3e683f68, 0x4f19193f, 0x00000038, 
    0x00000000, 0x00000000, 0x007401f3, 0x006c01f5, 0x00000074, 0x00000012, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x37271708, 0x75665646, 0xb4a49585, 0x00b5b529, 0x07ca00bb, 0x000007ca, 
    0x594d3f2a, 0x69685e5b, 0x6e6d6c6b, 0x00000691, 0x4d4d4c39, 0x3f694869, 0x591a1a48, 0x00000039, 
    0x00000000, 0x00000000, 0x00830231, 0x00790233, 0x00000082, 0x00000014, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x37271708, 0x75665646, 0xb4a49585, 0x00b5b529, 0x08be00d2, 0x000008be, 
    0x5a4e482b, 0x6b695f5d, 0x6f6f6d6c, 0x00000846, 0x4e4e4e3a, 0x496a496a, 0x5a1c1c49, 0x0000003a, 
    0x00000000, 0x00000000, 0x00930275, 0x00880278, 0x00000092, 0x00000017, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x37271708, 0x75665646, 0xb4a49585, 0x00b5b529, 0x09d000eb, 0x000009d0, 
    0x5b58492d, 0x6c6a695e, 0x6f6f6f6d, 0x00000a6d, 0x5858583b, 0x4a6b4a6b, 0x5b1d1d4a, 0x0000003b, 
    0x00000000, 0x00000000, 0x00a502c3, 0x009802c5, 0x000000a4, 0x00000019, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x37271708, 0x75665646, 0xb4a49585, 0x00b5b529, 0x0b040108, 0x00000b04, 
    0x5c594b2e, 0x6d6c6a68, 0x6f6f6f6f, 0x00000d22, 0x5959593d, 0x4b6c4c6c, 0x5c1e1e4c, 0x0000003d, 
    0x00000000, 0x00000000, 0x00b90319, 0x00ab031c, 0x000000b8, 0x0000001c, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x37271708, 0x75665646, 0xb4a49585, 0x00b5b529, 0x0c5e0129, 0x00000c5e, 
    0x5e5a4c38, 0x6f6d6b69, 0x6f6f6f6f, 0x0000108c, 0x5a5a5a3e, 0x4c6e4d6e, 0x5e28284d, 0x0000003e, 
    0x00000000, 0x00000000, 0x00d0037a, 0x00c0037d, 0x000000cf, 0x00000020, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x37271708, 0x75665646, 0xb4a49585, 0x00b5b529, 0x0de1014d, 0x00000de1, 
    0x685b4d39, 0x6f6f6c6a, 0x6f6f6f6f, 0x000014da, 0x5b5b5b48, 0x4e784f78, 0x5f29294f, 0x00000048, 
    0x00000000, 0x00000000, 0x00e903e7, 0x00d803eb, 0x000000e8, 0x00000024, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x37271708, 0x75665646, 0xb4a49585, 0x00b5b529, 0x0f940176, 0x00000f94, 
    0x695d4f3a, 0x6f6f6e6b, 0x6f6f6f6f, 0x00001a45, 0x5d5d5c49, 0x4f795879, 0x692a2a58, 0x00000049, 
    0x00000000, 0x00000000, 0x01060462, 0x00f20466, 0x00000105, 0x00000029, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x37271708, 0x75665646, 0xb4a49585, 0x00b5b529, 0x117d01a4, 0x0000117d, 
    0x6a5e583b, 0x6f6f6f6d, 0x6f6f6f6f, 0x00002119, 0x5e5e5e4a, 0x597a597a, 0x6a2c2c59, 0x0000004a, 
    0x00000000, 0x00000000, 0x012604eb, 0x011004f0, 0x00000125, 0x0000002e, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x37271708, 0x75665646, 0xb4a49585, 0x00b5b529, 0x13a101d7, 0x000013a1, 
    0x6b68593d, 0x6f6f6f6e, 0x6f6f6f6f, 0x000029b3, 0x6868684b, 0x5a7b5a7b, 0x6b2d2d5a, 0x0000004b, 
    0x00000000, 0x00000000, 0x014a0586, 0x0131058a, 0x00000149, 0x00000033, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x37271708, 0x75665646, 0xb4a49585, 0x00b5b529, 0x16090211, 0x00001609, 
    0x6c695b3e, 0x6f6f6f6f, 0x6f6f6f6f, 0x0000348a, 0x6969694d, 0x5b7c5c7c, 0x6c2e2e5c, 0x0000004d, 
    0x00000000, 0x00000000, 0x01730633, 0x01560638, 0x00000171, 0x00000039, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x37271708, 0x75665646, 0xb4a49585, 0x00b5b529, 0x18bc0252, 0x000018bc, 
    0x6e6a5c48, 0x6f6f6f6f, 0x6f6f6f6f, 0x00004232, 0x6a6a6a4e, 0x5c7e5d7e, 0x6e38385d, 0x0000004e, 
    0x00000000, 0x00000000, 0x01a006f5, 0x018006fb, 0x0000019e, 0x00000041, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x37271708, 0x75665646, 0xb4a49585, 0x00b5b529, 0x1bc3029b, 0x00001bc3, 
    0x6f6b5d49, 0x6f6f6f6f, 0x6f6f6f6f, 0x00005366, 0x6b6b6b58, 0x5e885f88, 0x6f39395f, 0x00000058, 
    0x00000000, 0x00000000, 0x01d307cf, 0x01b007d6, 0x000001d1, 0x00000049, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x37271708, 0x75665646, 0xb4a49585, 0x00b5b529, 0x1f2902ec, 0x00001f29, 
    0x6f6d5f4a, 0x6f6f6f6f, 0x6f6f6f6f, 0x00006914, 0x6d6d6c59, 0x5f896889, 0x793a3a68, 0x00000059, 
    0x00000000, 0x00000000, 0x020d08c4, 0x01e508cc, 0x0000020a, 0x00000052, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x37271708, 0x75665646, 0xb4a49585, 0x00b5b529, 0x22fa0348, 0x000022fa, 
    0x6f6e684b, 0x6f6f6f6f, 0x6f6f6f6f, 0x00008463, 0x6e6e6e5a, 0x698a698a, 0x7a3c3c69, 0x0000005a, 
    0x00000000, 0x00000000, 0x024d09d7, 0x022009e0, 0x0000024a, 0x0000005c, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x37271708, 0x75665646, 0xb4a49585, 0x00b5b529, 0x274303af, 0x00002743, 
    0x6f6f694d, 0x6f6f6f6f, 0x6f6f6f6f, 0x0000a6cc, 0x7878785b, 0x6a8b6a8b, 0x7b3d3d6a, 0x0000005b, 
    0x00000000, 0x00000000, 0x02950b0c, 0x02630b15, 0x00000292, 0x00000067, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x37271708, 0x75665646, 0xb4a49585, 0x00b5b529, 0x2c120423, 0x00002c12, 
    0x6f6f6b4e, 0x6f6f6f6f, 0x6f6f6f6f, 0x0000d227, 0x7979795d, 0x6b8c6c8c, 0x7c3e3e6c, 0x0000005d, 
    0x00000000, 0x00000000, 0x02e60c66, 0x02ad0c71, 0x000002e3, 0x00000073, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x37271708, 0x75665646, 0xb4a49585, 0x00b5b529, 0x317804a4, 0x00003178, 
    0x6f6f6c58, 0x6f6f6f6f, 0x6f6f6f6f, 0x000008c7, 0x7a7a7a5e, 0x6c8e6d8e, 0x7e48486d, 0x0000005e, 
    0x00000000, 0x00000000, 0x03410deb, 0x03010df7, 0x0000033d, 0x00000082, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x37271708, 0x75665646, 0xb4a49585, 0x00b5b529, 0x37870536, 0x00003787, 
    0x6f6f6d59, 0x6f6f6f6f, 0x6f6f6f6f, 0x00004d99, 0x7b7b7b68, 0x6e8f6f8f, 0x7f49496f, 0x00000068, 
    0x00000000, 0x00000000, 0x03a70f9f, 0x03600fad, 0x000003a3, 0x00000092, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x37271708, 0x75665646, 0xb4a49585, 0x00b5b529, 0x3e5305d9, 0x00003e53, 
    0x6f6f6f5a, 0x6f6f6f6f, 0x6f6f6f6f, 0x0000a44e, 0x7d7d7c69, 0x6f8f788f, 0x894a4a78, 0x00000069, 
    0x00000000, 0x00000000, 0x041a1189, 0x03ca1198, 0x00000415, 0x000000a4, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x37271708, 0x75665646, 0xb4a49585, 0x00b5b529, 0x45f50691, 0x000045f5, 
    0x6f6f6f5b, 0x6f6f6f6f, 0x6f6f6f6f, 0x0000118d, 0x7e7e7e6a, 0x798f798f, 0x8a4c4c79, 0x0000006a, 
    0x00000000, 0x00000000, 0x049b13af, 0x044013c0, 0x00000495, 0x000000b8, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x37271708, 0x75665646, 0xb4a49585, 0x00b5b529, 0x4e87075e, 0x00004e87, 
    0x6f6f6f5d, 0x6f6f6f6f, 0x6f6f6f6f, 0x00009b31, 0x8888886b, 0x7a8f7a8f, 0x8b4d4d7a, 0x0000006b, 
    0x00000000, 0x00000000, 0x052b1618, 0x04c6162b, 0x00000525, 0x000000ce, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x37271708, 0x75665646, 0xb4a49585, 0x00b5b529, 0x58250846, 0x00005825, 
    0x6f6f6f5e, 0x6f6f6f6f, 0x6f6f6f6f, 0x0000489c, 0x8989896d, 0x7b8f7c8f, 0x8c4e4e7c, 0x0000006d, 
    0x00000000, 0x00000000, 0x05cd18cd, 0x055b18e2, 0x000005c6, 0x000000e7, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x37271708, 0x75665646, 0xb4a49585, 0x00b5b529, 0x62f00949, 0x000062f0, 
    0x6f6f6f68, 0x6f6f6f6f, 0x6f6f6f6f, 0x0000231a, 0x8a8a8a6e, 0x7c8f7d8f, 0x8e58587d, 0x0000006e, 
    0x00000000, 0x00000000, 0x06831bd7, 0x06031bee, 0x0000067b, 0x00000104, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x37271708, 0x75665646, 0xb4a49585, 0x00b5b529, 0x6f0e0a6c, 0x00006f0e, 
    0x6f6f6f69, 0x6f6f6f6f, 0x6f6f6f6f, 0x00003663, 0x8b8b8b78, 0x7e8f7f8f, 0x8f59597f, 0x00000078, 
    0x00000000, 0x00000000, 0x074f1f3f, 0x06c01f5a, 0x00000746, 0x00000124, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x37271708, 0x75665646, 0xb4a49585, 0x00b5b529, 0x7ca70bb3, 0x00007ca7, 
    0x6f6f6f6a, 0x6f6f6f6f, 0x6f6f6f6f, 0x00009139, 0x8d8d8c79, 0x7f8f888f, 0x8f5a5a88, 0x00000079, 
    0x00000000, 0x00000000, 0x08342313, 0x07942331, 0x0000082b, 0x00000148, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x37271708, 0x75665646, 0xb4a49585, 0x00b5b529, 0x8beb0d22, 0x00008beb, 
    0x6f6f6f6b, 0x6f6f6f6f, 0x6f6f6f6f, 0x00004635, 0x8e8e8e7a, 0x898f898f, 0x8f5c5c89, 0x0000007a, 
    0x00000000, 0x00000000, 0x0936275f, 0x08812780, 0x0000092b, 0x00000170, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x37271708, 0x75665646, 0xb4a49585, 0x00b5b529, 0x9d0e0ebd, 0x00009d0e, 
    0x03020100, 0x07060504, 0x0a090908, 0x00000003, 0x08080802, 0x041b051b, 0x0b000005, 0x00000002, 
    0x00000000, 0x00000000, 0x00050016, 0x00040016, 0x00000005, 0x00000000, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x100b0702, 0x221e1915, 0x35302c27, 0x00b5b529, 0x005a0008, 0x0000005a, 
    0x03020100, 0x07060504, 0x0a090908, 0x00000003, 0x08080802, 0x041b051b, 0x0b000005, 0x00000002, 
    0x00000000, 0x00000000, 0x00050016, 0x00040016, 0x00000005, 0x00000000, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x100b0702, 0x221e1915, 0x35302c27, 0x00b5b529, 0x005a0008, 0x0000005a, 
    0x03020100, 0x07060504, 0x0a090908, 0x00000003, 0x08080802, 0x041b051b, 0x0b000005, 0x00000002, 
    0x00000000, 0x00000000, 0x00050016, 0x00040016, 0x00000005, 0x00000000, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x100b0702, 0x221e1915, 0x35302c27, 0x00b5b529, 0x005a0008, 0x0000005a, 
    0x03020100, 0x07060504, 0x0a090908, 0x00000003, 0x08080802, 0x041b051b, 0x0b000005, 0x00000002, 
    0x00000000, 0x00000000, 0x00050016, 0x00040016, 0x00000005, 0x00000000, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x100b0702, 0x221e1915, 0x35302c27, 0x00b5b529, 0x005a0008, 0x0000005a, 
    0x03020100, 0x07060504, 0x0a090908, 0x00000003, 0x08080802, 0x041b051b, 0x0b000005, 0x00000002, 
    0x00000000, 0x00000000, 0x00050016, 0x00040016, 0x00000005, 0x00000000, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x100b0702, 0x221e1915, 0x35302c27, 0x00b5b529, 0x005a0008, 0x0000005a, 
    0x03020100, 0x07060504, 0x0a090908, 0x00000003, 0x08080802, 0x041b051b, 0x0b000005, 0x00000002, 
    0x00000000, 0x00000000, 0x00050016, 0x00040016, 0x00000005, 0x00000000, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x100b0702, 0x221e1915, 0x35302c27, 0x00b5b529, 0x005a0008, 0x0000005a, 
    0x03020100, 0x07060504, 0x0a090908, 0x00000003, 0x08080802, 0x041b051b, 0x0b000005, 0x00000002, 
    0x00000000, 0x00000000, 0x00050016, 0x00040016, 0x00000005, 0x00000000, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x100b0702, 0x221e1915, 0x35302c27, 0x00b5b529, 0x005a0008, 0x0000005a, 
    0x03020100, 0x07060504, 0x0a090908, 0x00000003, 0x08080802, 0x041b051b, 0x0b000005, 0x00000002, 
    0x00000000, 0x00000000, 0x00050016, 0x00040016, 0x00000005, 0x00000000, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x100b0702, 0x221e1915, 0x35302c27, 0x00b5b529, 0x005a0008, 0x0000005a, 
    0x03020100, 0x07060504, 0x0a090908, 0x00000003, 0x08080802, 0x041b051b, 0x0b000005, 0x00000002, 
    0x00000000, 0x00000000, 0x00050016, 0x00040016, 0x00000005, 0x00000000, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x100b0702, 0x221e1915, 0x35302c27, 0x00b5b529, 0x005a0008, 0x0000005a, 
    0x03020100, 0x07060504, 0x0a090908, 0x00000003, 0x08080802, 0x041b051b, 0x0b000005, 0x00000002, 
    0x00000000, 0x00000000, 0x00050016, 0x00040016, 0x00000005, 0x00000000, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x100b0702, 0x221e1915, 0x35302c27, 0x00b5b529, 0x005a0008, 0x0000005a, 
    0x03020100, 0x07060504, 0x0a090908, 0x00000003, 0x08080802, 0x041b051b, 0x0b000005, 0x00000002, 
    0x00000000, 0x00000000, 0x00050016, 0x00040016, 0x00000005, 0x00000000, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x100b0702, 0x221e1915, 0x35302c27, 0x00b5b529, 0x005a0008, 0x0000005a, 
    0x03020100, 0x07060504, 0x0a090908, 0x00000003, 0x08080802, 0x041b051b, 0x0b000005, 0x00000002, 
    0x00000000, 0x00000000, 0x00050016, 0x00040016, 0x00000005, 0x00000000, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x100b0702, 0x221e1915, 0x35302c27, 0x00b5b529, 0x005a0008, 0x0000005a, 
    0x03020100, 0x07060504, 0x0a090908, 0x00000003, 0x08080802, 0x041b051b, 0x0b000005, 0x00000002, 
    0x00000000, 0x00000000, 0x00050016, 0x00040016, 0x00000005, 0x00000000, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x100b0702, 0x221e1915, 0x35302c27, 0x00b5b529, 0x005a0008, 0x0000005a, 
    0x03020100, 0x08060504, 0x0c0b0a09, 0x00000003, 0x09090903, 0x051d051d, 0x0c000005, 0x00000003, 
    0x00000000, 0x00000000, 0x00050019, 0x00050019, 0x00000005, 0x00000000, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x100b0702, 0x221e1915, 0x35302c27, 0x00b5b529, 0x00650009, 0x00000065, 
    0x04020100, 0x08070605, 0x0d0c0b0a, 0x00000004, 0x0a0a0a03, 0x061e061e, 0x0e010106, 0x00000003, 
    0x00000000, 0x00000000, 0x0006001c, 0x0006001c, 0x00000006, 0x00000001, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x100b0702, 0x221e1915, 0x35302c27, 0x00b5b529, 0x0071000a, 0x00000071, 
    0x04030200, 0x0a080706, 0x0f0e0c0b, 0x00000005, 0x0b0b0b04, 0x06280728, 0x0f010107, 0x00000004, 
    0x00000000, 0x00000000, 0x00070020, 0x00060020, 0x00000007, 0x00000001, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x100b0702, 0x221e1915, 0x35302c27, 0x00b5b529, 0x007f000b, 0x0000007f, 
    0x05030200, 0x0b090806, 0x190f0e0c, 0x00000007, 0x0c0c0c04, 0x07290829, 0x19010108, 0x00000004, 
    0x00000000, 0x00000000, 0x00080023, 0x00070024, 0x00000008, 0x00000001, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x100b0702, 0x221e1915, 0x35302c27, 0x00b5b529, 0x008f000d, 0x0000008f, 
    0x05040200, 0x0c0b0907, 0x1a19180e, 0x00000009, 0x0e0e0e05, 0x082a092a, 0x1a010109, 0x00000005, 
    0x00000000, 0x00000000, 0x00090028, 0x00080028, 0x00000009, 0x00000001, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x100b0702, 0x221e1915, 0x35302c27, 0x00b5b529, 0x00a0000f, 0x000000a0, 
    0x06040200, 0x0e0c0a08, 0x1b1a1918, 0x0000000b, 0x18181805, 0x092b0a2b, 0x1b01010a, 0x00000005, 
    0x00000000, 0x00000000, 0x000a002d, 0x0009002d, 0x0000000a, 0x00000001, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x100b0702, 0x221e1915, 0x35302c27, 0x00b5b529, 0x00b40010, 0x000000b4, 
    0x07050301, 0x180d0b09, 0x1c1b1a19, 0x0000000e, 0x19191906, 0x0a2d0b2d, 0x1d01010b, 0x00000006, 
    0x00000000, 0x00000000, 0x000b0032, 0x000a0033, 0x0000000b, 0x00000001, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x100b0702, 0x221e1915, 0x35302c27, 0x00b5b529, 0x00ca0013, 0x000000ca, 
    0x08050301, 0x190f0d0a, 0x1e1d1b1a, 0x00000011, 0x1a1a1a07, 0x0c2e0d2e, 0x1e02020d, 0x00000007, 
    0x00000000, 0x00000000, 0x000d0039, 0x000c0039, 0x0000000d, 0x00000002, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x100b0702, 0x221e1915, 0x35302c27, 0x00b5b529, 0x00e30015, 0x000000e3, 
    0x09060401, 0x1a190e0c, 0x1f1e1d1b, 0x00000016, 0x1c1b1b08, 0x0d380e38, 0x2802020e, 0x00000008, 
    0x00000000, 0x00000000, 0x000e0040, 0x000d0040, 0x0000000e, 0x00000002, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x100b0702, 0x221e1915, 0x35302c27, 0x00b5b529, 0x00ff0017, 0x000000ff, 
    0x0a070401, 0x1b1a180d, 0x29281e1d, 0x0000001c, 0x1d1d1d09, 0x0f391839, 0x29020218, 0x00000009, 
    0x00000000, 0x00000000, 0x00100047, 0x000f0048, 0x00000010, 0x00000002, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x100b0702, 0x221e1915, 0x35302c27, 0x00b5b529, 0x011e001a, 0x0000011e, 
    0x0b080501, 0x1d1b190f, 0x2a29281e, 0x00000023, 0x1e1e1e0a, 0x193a193a, 0x2a020219, 0x0000000a, 
    0x00000000, 0x00000000, 0x00120050, 0x00110050, 0x00000012, 0x00000002, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x100b0702, 0x221e1915, 0x35302c27, 0x00b5b529, 0x0141001e, 0x00000141, 
    0x0d090501, 0x1e1c1a19, 0x2b2a2928, 0x0000002c, 0x2828280b, 0x1a3b1b3b, 0x2b03031b, 0x0000000b, 
    0x00000000, 0x00000000, 0x0015005a, 0x0013005a, 0x00000015, 0x00000003, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x100b0702, 0x221e1915, 0x35302c27, 0x00b5b529, 0x01690021, 0x00000169, 
    0x0e0a0602, 0x281e1c1a, 0x2c2b2a29, 0x00000037, 0x2929290d, 0x1b3d1c3d, 0x2d03031c, 0x0000000d, 
    0x00000000, 0x00000000, 0x00170065, 0x00150066, 0x00000017, 0x00000003, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x100b0702, 0x221e1915, 0x35302c27, 0x00b5b529, 0x01950026, 0x00000195, 
    0x180b0702, 0x29281d1b, 0x2e2d2b2a, 0x00000046, 0x2a2a2a0e, 0x1c3e1d3e, 0x2e04041d, 0x0000000e, 
    0x00000000, 0x00000000, 0x001a0072, 0x00180072, 0x0000001a, 0x00000004, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x100b0702, 0x221e1915, 0x35302c27, 0x00b5b529, 0x01c7002a, 0x000001c7, 
    0x190d0802, 0x2a291f1c, 0x2f2e2d2b, 0x00000058, 0x2c2b2b18, 0x1e481f48, 0x3804041f, 0x00000018, 
    0x00000000, 0x00000000, 0x001d0080, 0x001b0080, 0x0000001d, 0x00000004, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x100b0702, 0x221e1915, 0x35302c27, 0x00b5b529, 0x01ff002f, 0x000001ff, 
    0x1b0f0903, 0x2b2a281e, 0x39382e2d, 0x0000006e, 0x2d2d2d19, 0x28492849, 0x39050528, 0x00000019, 
    0x00000000, 0x00000000, 0x0021008f, 0x001f0090, 0x00000021, 0x00000005, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x100b0702, 0x221e1915, 0x35302c27, 0x00b5b529, 0x023d0035, 0x0000023d, 
    0x1c180a03, 0x2d2b291f, 0x3a39382e, 0x0000008b, 0x2e2e2e1a, 0x294a294a, 0x3a050529, 0x0000001a, 
    0x00000000, 0x00000000, 0x002500a1, 0x002200a1, 0x00000025, 0x00000005, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x100b0702, 0x221e1915, 0x35302c27, 0x00b5b529, 0x0283003c, 0x00000283, 
    0x1d1a0b03, 0x2e2c2a29, 0x3b3a3938, 0x000000af, 0x3838381c, 0x2a4b2b4b, 0x3b06062b, 0x0000001c, 
    0x00000000, 0x00000000, 0x002a00b5, 0x002700b5, 0x0000002a, 0x00000006, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x100b0702, 0x221e1915, 0x35302c27, 0x00b5b529, 0x02d20043, 0x000002d2, 
    0x1f1b0c04, 0x382e2c2a, 0x3c3b3a39, 0x000000dd, 0x3939391d, 0x2b4d2c4d, 0x3d07072c, 0x0000001d, 
    0x00000000, 0x00000000, 0x002f00cb, 0x002b00cc, 0x0000002f, 0x00000007, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x100b0702, 0x221e1915, 0x35302c27, 0x00b5b529, 0x032b004c, 0x0000032b, 
    0x281c0e04, 0x39382d2b, 0x3e3d3b3a, 0x00000116, 0x3a3a3a1f, 0x2c4e2d4e, 0x3e08082d, 0x0000001f, 
    0x00000000, 0x00000000, 0x003500e4, 0x003100e5, 0x00000035, 0x00000008, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x100b0702, 0x221e1915, 0x35302c27, 0x00b5b529, 0x038e0055, 0x0000038e, 
    0x291d1805, 0x3a392f2c, 0x3f3e3d3b, 0x0000015e, 0x3c3b3b28, 0x2e582f58, 0x4809092f, 0x00000028, 
    0x00000000, 0x00000000, 0x003b0100, 0x00370101, 0x0000003b, 0x00000009, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x100b0702, 0x221e1915, 0x35302c27, 0x00b5b529, 0x03fe005f, 0x000003fe, 
    0x2b1f1906, 0x3b3a382e, 0x49483e3d, 0x000001ba, 0x3d3d3d29, 0x38593859, 0x490a0a38, 0x00000029, 
    0x00000000, 0x00000000, 0x0043011f, 0x003e0120, 0x00000042, 0x0000000a, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x100b0702, 0x221e1915, 0x35302c27, 0x00b5b529, 0x047b006b, 0x0000047b, 
    0x2c281a06, 0x3d3b392f, 0x4a49483e, 0x0000022c, 0x3e3e3e2a, 0x395a395a, 0x4a0b0b39, 0x0000002a, 
    0x00000000, 0x00000000, 0x004b0142, 0x00450143, 0x0000004b, 0x0000000b, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x100b0702, 0x221e1915, 0x35302c27, 0x00b5b529, 0x05070078, 0x00000507, 
    0x2d2a1b07, 0x3e3c3a39, 0x4b4a4948, 0x000002bd, 0x4848482c, 0x3a5b3b5b, 0x4b0d0d3b, 0x0000002c, 
    0x00000000, 0x00000000, 0x0054016a, 0x004e016b, 0x00000054, 0x0000000d, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x100b0702, 0x221e1915, 0x35302c27, 0x00b5b529, 0x05a50087, 0x000005a5, 
    0x2f2b1d08, 0x483e3c3a, 0x4c4b4a49, 0x00000373, 0x4949492d, 0x3b5d3c5d, 0x4d0e0e3c, 0x0000002d, 
    0x00000000, 0x00000000, 0x005f0196, 0x00570198, 0x0000005e, 0x0000000e, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x100b0702, 0x221e1915, 0x35302c27, 0x00b5b529, 0x06560098, 0x00000656, 
    0x382c1e09, 0x49483d3b, 0x4e4d4b4a, 0x00000459, 0x4a4a4a2f, 0x3c5e3d5e, 0x4e18183d, 0x0000002f, 
    0x00000000, 0x00000000, 0x006a01c8, 0x006201ca, 0x0000006a, 0x00000010, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x100b0702, 0x221e1915, 0x35302c27, 0x00b5b529, 0x071d00aa, 0x0000071d, 
    0x392d280a, 0x4a493f3c, 0x4f4e4d4b, 0x0000057a, 0x4c4b4b38, 0x3e683f68, 0x5819193f, 0x00000038, 
    0x00000000, 0x00000000, 0x00770200, 0x006e0202, 0x00000077, 0x00000012, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x100b0702, 0x221e1915, 0x35302c27, 0x00b5b529, 0x07fc00bf, 0x000007fc, 
    0x3b2f290c, 0x4b4a483e, 0x59584e4d, 0x000006e6, 0x4d4d4d39, 0x48694869, 0x591b1b48, 0x00000039, 
    0x00000000, 0x00000000, 0x0086023f, 0x007c0241, 0x00000085, 0x00000015, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x100b0702, 0x221e1915, 0x35302c27, 0x00b5b529, 0x08f600d7, 0x000008f6, 
    0x3c382a0d, 0x4d4b493f, 0x5a59584e, 0x000008b1, 0x4e4e4e3a, 0x496a496a, 0x5a1c1c49, 0x0000003a, 
    0x00000000, 0x00000000, 0x00970285, 0x008b0287, 0x00000096, 0x00000017, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x100b0702, 0x221e1915, 0x35302c27, 0x00b5b529, 0x0a0f00f1, 0x00000a0f, 
    0x3d3a2b0f, 0x4e4c4a49, 0x5b5a5958, 0x00000af4, 0x5858583c, 0x4a6b4b6b, 0x5b1d1d4b, 0x0000003c, 
    0x00000000, 0x00000000, 0x00a902d4, 0x009c02d7, 0x000000a8, 0x0000001a, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x100b0702, 0x221e1915, 0x35302c27, 0x00b5b529, 0x0b4a010f, 0x00000b4a, 
    0x3f3b2d19, 0x584e4c4a, 0x5c5b5a59, 0x00000dcc, 0x5959593d, 0x4b6d4c6d, 0x5d1f1f4c, 0x0000003d, 
    0x00000000, 0x00000000, 0x00be032d, 0x00af0330, 0x000000bd, 0x0000001d, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x100b0702, 0x221e1915, 0x35302c27, 0x00b5b529, 0x0cad0130, 0x00000cad, 
    0x483c2e1a, 0x59584d4b, 0x5e5d5b5a, 0x00001162, 0x5a5a5a3f, 0x4c6e4d6e, 0x5e28284d, 0x0000003f, 
    0x00000000, 0x00000000, 0x00d50391, 0x00c50394, 0x000000d4, 0x00000021, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x100b0702, 0x221e1915, 0x35302c27, 0x00b5b529, 0x0e3a0155, 0x00000e3a, 
    0x493d381b, 0x5a594f4c, 0x5f5e5d5b, 0x000015e7, 0x5c5b5b48, 0x4e784f78, 0x6829294f, 0x00000048, 
    0x00000000, 0x00000000, 0x00ef0400, 0x00dd0404, 0x000000ee, 0x00000025, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x100b0702, 0x221e1915, 0x35302c27, 0x00b5b529, 0x0ff8017f, 0x00000ff8, 
    0x4b3f391c, 0x5b5a584e, 0x69685e5d, 0x00001b98, 0x5d5d5d49, 0x58795879, 0x692b2b58, 0x00000049, 
    0x00000000, 0x00000000, 0x010d047e, 0x00f80482, 0x0000010b, 0x0000002a, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x100b0702, 0x221e1915, 0x35302c27, 0x00b5b529, 0x11ed01ae, 0x000011ed, 
    0x4c483a1e, 0x5d5b594f, 0x6a69685e, 0x000022c5, 0x5e5e5e4a, 0x597a597a, 0x6a2c2c59, 0x0000004a, 
    0x00000000, 0x00000000, 0x012e050b, 0x0117050f, 0x0000012c, 0x0000002f, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x100b0702, 0x221e1915, 0x35302c27, 0x00b5b529, 0x141f01e3, 0x0000141f, 
    0x4d4a3b1f, 0x5e5c5a59, 0x6b6a6968, 0x00002bce, 0x6868684c, 0x5a7b5b7b, 0x6b2d2d5b, 0x0000004c, 
    0x00000000, 0x00000000, 0x015305a9, 0x013905ae, 0x00000151, 0x00000034, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x100b0702, 0x221e1915, 0x35302c27, 0x00b5b529, 0x1695021e, 0x00001695, 
    0x4f4b3d29, 0x685e5c5a, 0x6c6b6a69, 0x00003731, 0x6969694d, 0x5b7d5c7d, 0x6d2f2f5c, 0x0000004d, 
    0x00000000, 0x00000000, 0x017c065a, 0x015f0660, 0x0000017a, 0x0000003b, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x100b0702, 0x221e1915, 0x35302c27, 0x00b5b529, 0x195a0261, 0x0000195a, 
    0x584c3e2a, 0x69685d5b, 0x6e6d6b6a, 0x00004589, 0x6a6a6a4f, 0x5c7e5d7e, 0x6e38385d, 0x0000004f, 
    0x00000000, 0x00000000, 0x01ab0722, 0x018a0728, 0x000001a9, 0x00000042, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x100b0702, 0x221e1915, 0x35302c27, 0x00b5b529, 0x1c7402ab, 0x00001c74, 
    0x594d482b, 0x6a695f5c, 0x6f6e6d6b, 0x0000579c, 0x6c6b6b58, 0x5e885f88, 0x7839395f, 0x00000058, 
    0x00000000, 0x00000000, 0x01df0801, 0x01ba0808, 0x000001dd, 0x0000004a, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x100b0702, 0x221e1915, 0x35302c27, 0x00b5b529, 0x1ff002ff, 0x00001ff0, 
    0x5b4f492c, 0x6b6a685e, 0x6f6f6e6d, 0x00006e62, 0x6d6d6d59, 0x68896889, 0x793b3b68, 0x00000059, 
    0x00000000, 0x00000000, 0x021a08fc, 0x01f10904, 0x00000217, 0x00000054, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x100b0702, 0x221e1915, 0x35302c27, 0x00b5b529, 0x23da035d, 0x000023da, 
    0x5c584a2e, 0x6d6b695f, 0x6f6f6f6e, 0x00008b12, 0x6e6e6e5a, 0x698a698a, 0x7a3c3c69, 0x0000005a, 
    0x00000000, 0x00000000, 0x025c0a16, 0x022e0a1f, 0x00000259, 0x0000005e, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x100b0702, 0x221e1915, 0x35302c27, 0x00b5b529, 0x283e03c7, 0x0000283e, 
    0x5d5a4b2f, 0x6e6c6a69, 0x6f6f6f6f, 0x0000af38, 0x7878785c, 0x6a8b6b8b, 0x7b3d3d6b, 0x0000005c, 
    0x00000000, 0x00000000, 0x02a60b52, 0x02720b5c, 0x000002a3, 0x00000069, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x100b0702, 0x221e1915, 0x35302c27, 0x00b5b529, 0x2d2b043d, 0x00002d2b, 
    0x5f5b4d39, 0x6f6e6c6a, 0x6f6f6f6f, 0x0000dcc3, 0x7979795d, 0x6b8d6c8d, 0x7d3f3f6c, 0x0000005d, 
    0x00000000, 0x00000000, 0x02f90cb5, 0x02bf0cc0, 0x000002f5, 0x00000076, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x100b0702, 0x221e1915, 0x35302c27, 0x00b5b529, 0x32b404c2, 0x000032b4, 
    0x685c4e3a, 0x6f6f6d6b, 0x6f6f6f6f, 0x00001625, 0x7a7a7a5f, 0x6c8e6d8e, 0x7e48486d, 0x0000005f, 
    0x00000000, 0x00000000, 0x03560e44, 0x03150e50, 0x00000352, 0x00000085, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x100b0702, 0x221e1915, 0x35302c27, 0x00b5b529, 0x38e90557, 0x000038e9, 
    0x695d583b, 0x6f6f6f6c, 0x6f6f6f6f, 0x00005e70, 0x7c7b7b68, 0x6e8f6f8f, 0x8849496f, 0x00000068, 
    0x00000000, 0x00000000, 0x03bf1003, 0x03751011, 0x000003ba, 0x00000095, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x100b0702, 0x221e1915, 0x35302c27, 0x00b5b529, 0x3fe105ff, 0x00003fe1, 
    0x6b5f593c, 0x6f6f6f6e, 0x6f6f6f6f, 0x0000b986, 0x7d7d7d69, 0x788f788f, 0x894b4b78, 0x00000069, 
    0x00000000, 0x00000000, 0x043411f9, 0x03e21208, 0x0000042f, 0x000000a8, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x100b0702, 0x221e1915, 0x35302c27, 0x00b5b529, 0x47b406bb, 0x000047b4, 
    0x6c685a3e, 0x6f6f6f6f, 0x6f6f6f6f, 0x00002c49, 0x7e7e7e6a, 0x798f798f, 0x8a4c4c79, 0x0000006a, 
    0x00000000, 0x00000000, 0x04b8142d, 0x045c143e, 0x000004b2, 0x000000bc, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x100b0702, 0x221e1915, 0x35302c27, 0x00b5b529, 0x507c078e, 0x0000507c, 
    0x6d6a5b3f, 0x6f6f6f6f, 0x6f6f6f6f, 0x0000bce0, 0x8888886c, 0x7a8f7b8f, 0x8b4d4d7b, 0x0000006c, 
    0x00000000, 0x00000000, 0x054c16a5, 0x04e416b8, 0x00000546, 0x000000d3, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x100b0702, 0x221e1915, 0x35302c27, 0x00b5b529, 0x5a57087a, 0x00005a57, 
    0x6f6b5d49, 0x6f6f6f6f, 0x6f6f6f6f, 0x0000730d, 0x8989896d, 0x7b8f7c8f, 0x8d4f4f7c, 0x0000006d, 
    0x00000000, 0x00000000, 0x05f2196b, 0x057e1981, 0x000005eb, 0x000000ed, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x100b0702, 0x221e1915, 0x35302c27, 0x00b5b529, 0x65680984, 0x00006568, 
    0x6f6c5e4a, 0x6f6f6f6f, 0x6f6f6f6f, 0x00005893, 0x8a8a8a6f, 0x7c8f7d8f, 0x8e58587d, 0x0000006f, 
    0x00000000, 0x00000000, 0x06ad1c88, 0x062a1ca0, 0x000006a5, 0x0000010a, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x100b0702, 0x221e1915, 0x35302c27, 0x00b5b529, 0x71d30aaf, 0x000071d3, 
    0x6f6d684b, 0x6f6f6f6f, 0x6f6f6f6f, 0x000079c1, 0x8c8b8b78, 0x7e8f7f8f, 0x8f59597f, 0x00000078, 
    0x00000000, 0x00000000, 0x077e2007, 0x06eb2022, 0x00000775, 0x0000012b, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x100b0702, 0x221e1915, 0x35302c27, 0x00b5b529, 0x7fc30bfe, 0x00007fc3, 
    0x04030100, 0x09070605, 0x0e0c0b0a, 0x00000004, 0x0a0a0903, 0x061e061e, 0x0d010106, 0x00000003, 
    0x00000000, 0x00000000, 0x0006001b, 0x0006001c, 0x00000006, 0x00000001, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x110c0702, 0x241f1a16, 0x37322e29, 0x00b5b529, 0x006f000a, 0x0000006f, 
    0x04030100, 0x09070605, 0x0e0c0b0a, 0x00000004, 0x0a0a0903, 0x061e061e, 0x0d010106, 0x00000003, 
    0x00000000, 0x00000000, 0x0006001b, 0x0006001c, 0x00000006, 0x00000001, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x110c0702, 0x241f1a16, 0x37322e29, 0x00b5b529, 0x006f000a, 0x0000006f, 
    0x04030100, 0x09070605, 0x0e0c0b0a, 0x00000004, 0x0a0a0903, 0x061e061e, 0x0d010106, 0x00000003, 
    0x00000000, 0x00000000, 0x0006001b, 0x0006001c, 0x00000006, 0x00000001, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x110c0702, 0x241f1a16, 0x37322e29, 0x00b5b529, 0x006f000a, 0x0000006f, 
    0x04030100, 0x09070605, 0x0e0c0b0a, 0x00000004, 0x0a0a0903, 0x061e061e, 0x0d010106, 0x00000003, 
    0x00000000, 0x00000000, 0x0006001b, 0x0006001c, 0x00000006, 0x00000001, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x110c0702, 0x241f1a16, 0x37322e29, 0x00b5b529, 0x006f000a, 0x0000006f, 
    0x04030100, 0x09070605, 0x0e0c0b0a, 0x00000004, 0x0a0a0903, 0x061e061e, 0x0d010106, 0x00000003, 
    0x00000000, 0x00000000, 0x0006001b, 0x0006001c, 0x00000006, 0x00000001, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x110c0702, 0x241f1a16, 0x37322e29, 0x00b5b529, 0x006f000a, 0x0000006f, 
    0x04030100, 0x09070605, 0x0e0c0b0a, 0x00000004, 0x0a0a0903, 0x061e061e, 0x0d010106, 0x00000003, 
    0x00000000, 0x00000000, 0x0006001b, 0x0006001c, 0x00000006, 0x00000001, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x110c0702, 0x241f1a16, 0x37322e29, 0x00b5b529, 0x006f000a, 0x0000006f, 
    0x04030100, 0x09070605, 0x0e0c0b0a, 0x00000004, 0x0a0a0903, 0x061e061e, 0x0d010106, 0x00000003, 
    0x00000000, 0x00000000, 0x0006001b, 0x0006001c, 0x00000006, 0x00000001, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x110c0702, 0x241f1a16, 0x37322e29, 0x00b5b529, 0x006f000a, 0x0000006f, 
    0x04030100, 0x09070605, 0x0e0c0b0a, 0x00000004, 0x0a0a0903, 0x061e061e, 0x0d010106, 0x00000003, 
    0x00000000, 0x00000000, 0x0006001b, 0x0006001c, 0x00000006, 0x00000001, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x110c0702, 0x241f1a16, 0x37322e29, 0x00b5b529, 0x006f000a, 0x0000006f, 
    0x04030100, 0x09070605, 0x0e0c0b0a, 0x00000004, 0x0a0a0903, 0x061e061e, 0x0d010106, 0x00000003, 
    0x00000000, 0x00000000, 0x0006001b, 0x0006001c, 0x00000006, 0x00000001, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x110c0702, 0x241f1a16, 0x37322e29, 0x00b5b529, 0x006f000a, 0x0000006f, 
    0x04030100, 0x09070605, 0x0e0c0b0a, 0x00000004, 0x0a0a0903, 0x061e061e, 0x0d010106, 0x00000003, 
    0x00000000, 0x00000000, 0x0006001b, 0x0006001c, 0x00000006, 0x00000001, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x110c0702, 0x241f1a16, 0x37322e29, 0x00b5b529, 0x006f000a, 0x0000006f, 
    0x04030100, 0x09070605, 0x0e0c0b0a, 0x00000004, 0x0a0a0903, 0x061e061e, 0x0d010106, 0x00000003, 
    0x00000000, 0x00000000, 0x0006001b, 0x0006001c, 0x00000006, 0x00000001, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x110c0702, 0x241f1a16, 0x37322e29, 0x00b5b529, 0x006f000a, 0x0000006f, 
    0x04030100, 0x09070605, 0x0e0c0b0a, 0x00000004, 0x0a0a0903, 0x061e061e, 0x0d010106, 0x00000003, 
    0x00000000, 0x00000000, 0x0006001b, 0x0006001c, 0x00000006, 0x00000001, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x110c0702, 0x241f1a16, 0x37322e29, 0x00b5b529, 0x006f000a, 0x0000006f, 
    0x04030100, 0x09070605, 0x0e0c0b0a, 0x00000004, 0x0a0a0903, 0x061e061e, 0x0d010106, 0x00000003, 
    0x00000000, 0x00000000, 0x0006001b, 0x0006001c, 0x00000006, 0x00000001, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x110c0702, 0x241f1a16, 0x37322e29, 0x00b5b529, 0x006f000a, 0x0000006f, 
    0x04030200, 0x0a080706, 0x0f0e0d0b, 0x00000005, 0x0b0b0b04, 0x06280728, 0x0f010107, 0x00000004, 
    0x00000000, 0x00000000, 0x0007001f, 0x0006001f, 0x00000007, 0x00000001, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x110c0702, 0x241f1a16, 0x37322e29, 0x00b5b529, 0x007d000b, 0x0000007d, 
    0x05030200, 0x0b0a0806, 0x19180e0d, 0x00000007, 0x0c0c0c04, 0x07290829, 0x19010108, 0x00000004, 
    0x00000000, 0x00000000, 0x00080023, 0x00070023, 0x00000008, 0x00000001, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x110c0702, 0x241f1a16, 0x37322e29, 0x00b5b529, 0x008c000d, 0x0000008c, 
    0x06040200, 0x0c0b0907, 0x1a19180e, 0x00000008, 0x0e0e0e05, 0x082a092a, 0x1a010109, 0x00000005, 
    0x00000000, 0x00000000, 0x00090027, 0x00080027, 0x00000009, 0x00000001, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x110c0702, 0x241f1a16, 0x37322e29, 0x00b5b529, 0x009d000e, 0x0000009d, 
    0x06040200, 0x0e0c0a08, 0x1b1a1918, 0x0000000a, 0x0f0f0f05, 0x092b0a2b, 0x1b01010a, 0x00000005, 
    0x00000000, 0x00000000, 0x000a002c, 0x0009002c, 0x0000000a, 0x00000001, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x110c0702, 0x241f1a16, 0x37322e29, 0x00b5b529, 0x00b00010, 0x000000b0, 
    0x07050301, 0x180e0b09, 0x1d1b1a19, 0x0000000d, 0x19191906, 0x0a2c0b2c, 0x1c01010b, 0x00000006, 
    0x00000000, 0x00000000, 0x000b0031, 0x000a0031, 0x0000000b, 0x00000001, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x110c0702, 0x241f1a16, 0x37322e29, 0x00b5b529, 0x00c60012, 0x000000c6, 
    0x08060301, 0x190f0d0b, 0x1e1d1c1a, 0x00000011, 0x1a1a1a07, 0x0c2e0d2e, 0x1e02020d, 0x00000007, 
    0x00000000, 0x00000000, 0x000d0037, 0x000c0038, 0x0000000d, 0x00000002, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x110c0702, 0x241f1a16, 0x37322e29, 0x00b5b529, 0x00de0014, 0x000000de, 
    0x09060401, 0x1a190f0c, 0x281e1d1c, 0x00000015, 0x1b1b1b08, 0x0d380e38, 0x1f02020e, 0x00000008, 
    0x00000000, 0x00000000, 0x000e003e, 0x000d003e, 0x0000000e, 0x00000002, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x110c0702, 0x241f1a16, 0x37322e29, 0x00b5b529, 0x00fa0017, 0x000000fa, 
    0x0a070401, 0x1c1a180d, 0x29281f1d, 0x0000001a, 0x1d1d1d08, 0x0f391839, 0x29020218, 0x00000008, 
    0x00000000, 0x00000000, 0x00100046, 0x000f0046, 0x00000010, 0x00000002, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x110c0702, 0x241f1a16, 0x37322e29, 0x00b5b529, 0x0118001a, 0x00000118, 
    0x0c080501, 0x1d1b1a0f, 0x2a29281f, 0x00000021, 0x1e1e1e0a, 0x193a193a, 0x2a020219, 0x0000000a, 
    0x00000000, 0x00000000, 0x0012004e, 0x0011004f, 0x00000012, 0x00000002, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x110c0702, 0x241f1a16, 0x37322e29, 0x00b5b529, 0x013a001d, 0x0000013a, 
    0x0d090501, 0x1f1d1b19, 0x2b2a2928, 0x0000002a, 0x2828280b, 0x1a3b1a3b, 0x2b03031a, 0x0000000b, 
    0x00000000, 0x00000000, 0x00140058, 0x00130058, 0x00000014, 0x00000003, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x110c0702, 0x241f1a16, 0x37322e29, 0x00b5b529, 0x01610021, 0x00000161, 
    0x0f0a0602, 0x281e1c1a, 0x2d2b2a29, 0x00000035, 0x2929290c, 0x1b3c1c3c, 0x2c03031c, 0x0000000c, 
    0x00000000, 0x00000000, 0x00170063, 0x00150063, 0x00000017, 0x00000003, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x110c0702, 0x241f1a16, 0x37322e29, 0x00b5b529, 0x018c0025, 0x0000018c, 
    0x190c0702, 0x29281d1b, 0x2e2d2c2a, 0x00000043, 0x2a2a2a0e, 0x1c3e1d3e, 0x2e04041d, 0x0000000e, 
    0x00000000, 0x00000000, 0x001a006f, 0x00180070, 0x0000001a, 0x00000004, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x110c0702, 0x241f1a16, 0x37322e29, 0x00b5b529, 0x01bd0029, 0x000001bd, 
    0x1a0d0802, 0x2a291f1c, 0x382e2d2c, 0x00000054, 0x2b2b2b18, 0x1e481f48, 0x2f04041f, 0x00000018, 
    0x00000000, 0x00000000, 0x001d007d, 0x001b007d, 0x0000001d, 0x00000004, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x110c0702, 0x241f1a16, 0x37322e29, 0x00b5b529, 0x01f4002e, 0x000001f4, 
    0x1b0f0903, 0x2c2a281e, 0x39382f2d, 0x0000006a, 0x2d2d2d19, 0x1f492849, 0x39050528, 0x00000019, 
    0x00000000, 0x00000000, 0x0020008c, 0x001e008d, 0x00000020, 0x00000005, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x110c0702, 0x241f1a16, 0x37322e29, 0x00b5b529, 0x02310034, 0x00000231, 
    0x1c190a03, 0x2d2b2a28, 0x3a39382f, 0x00000085, 0x2e2e2e1a, 0x294a294a, 0x3a050529, 0x0000001a, 
    0x00000000, 0x00000000, 0x0024009d, 0x0022009e, 0x00000024, 0x00000005, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x110c0702, 0x241f1a16, 0x37322e29, 0x00b5b529, 0x0275003b, 0x00000275, 
    0x1e1a0b03, 0x2f2d2b29, 0x3b3a3938, 0x000000a8, 0x3838381b, 0x2a4b2a4b, 0x3b06062a, 0x0000001b, 
    0x00000000, 0x00000000, 0x002900b1, 0x002600b1, 0x00000029, 0x00000006, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x110c0702, 0x241f1a16, 0x37322e29, 0x00b5b529, 0x02c30042, 0x000002c3, 
    0x1f1b0d04, 0x382e2c2a, 0x3d3b3a39, 0x000000d3, 0x3939391d, 0x2b4c2c4c, 0x3c07072c, 0x0000001d, 
    0x00000000, 0x00000000, 0x002e00c6, 0x002a00c7, 0x0000002e, 0x00000007, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x110c0702, 0x241f1a16, 0x37322e29, 0x00b5b529, 0x0319004a, 0x00000319, 
    0x291c0e04, 0x39382d2b, 0x3e3d3c3a, 0x0000010a, 0x3a3a3a1e, 0x2c4e2d4e, 0x3e08082d, 0x0000001e, 
    0x00000000, 0x00000000, 0x003400df, 0x003000e0, 0x00000034, 0x00000008, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x110c0702, 0x241f1a16, 0x37322e29, 0x00b5b529, 0x037a0053, 0x0000037a, 
    0x2a1e1805, 0x3a392f2c, 0x483e3d3c, 0x0000014f, 0x3b3b3b28, 0x2e582f58, 0x3f09092f, 0x00000028, 
    0x00000000, 0x00000000, 0x003a00fa, 0x003600fb, 0x0000003a, 0x00000009, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x110c0702, 0x241f1a16, 0x37322e29, 0x00b5b529, 0x03e8005d, 0x000003e8, 
    0x2b1f1906, 0x3c3a382e, 0x49483f3d, 0x000001a7, 0x3d3d3d29, 0x2f593859, 0x490a0a38, 0x00000029, 
    0x00000000, 0x00000000, 0x00410119, 0x003c011a, 0x00000041, 0x0000000a, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x110c0702, 0x241f1a16, 0x37322e29, 0x00b5b529, 0x04620069, 0x00000462, 
    0x2c291a06, 0x3d3b3a38, 0x4a49483f, 0x00000214, 0x3e3e3e2a, 0x395a395a, 0x4a0b0b39, 0x0000002a, 
    0x00000000, 0x00000000, 0x0049013b, 0x0044013c, 0x00000049, 0x0000000b, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x110c0702, 0x241f1a16, 0x37322e29, 0x00b5b529, 0x04eb0076, 0x000004eb, 
    0x2e2a1c07, 0x3f3d3b39, 0x4b4a4948, 0x0000029f, 0x4848482b, 0x3a5b3a5b, 0x4b0c0c3a, 0x0000002b, 
    0x00000000, 0x00000000, 0x00520162, 0x004c0163, 0x00000052, 0x0000000c, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x110c0702, 0x241f1a16, 0x37322e29, 0x00b5b529, 0x05860084, 0x00000586, 
    0x2f2b1d08, 0x483e3c3a, 0x4d4b4a49, 0x0000034d, 0x4949492d, 0x3b5c3c5c, 0x4c0e0e3c, 0x0000002d, 
    0x00000000, 0x00000000, 0x005d018d, 0x0055018f, 0x0000005c, 0x0000000e, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x110c0702, 0x241f1a16, 0x37322e29, 0x00b5b529, 0x06330095, 0x00000633, 
    0x392c1f09, 0x49483d3b, 0x4e4d4c4a, 0x00000429, 0x4a4a4a2e, 0x3c5e3d5e, 0x4e18183d, 0x0000002e, 
    0x00000000, 0x00000000, 0x006801be, 0x006001c0, 0x00000068, 0x00000010, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x110c0702, 0x241f1a16, 0x37322e29, 0x00b5b529, 0x06f500a7, 0x000006f5, 
    0x3a2e280a, 0x4a493f3c, 0x584e4d4c, 0x0000053e, 0x4b4b4b38, 0x3e683f68, 0x4f19193f, 0x00000038, 
    0x00000000, 0x00000000, 0x007501f5, 0x006c01f7, 0x00000074, 0x00000012, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x110c0702, 0x241f1a16, 0x37322e29, 0x00b5b529, 0x07d000bb, 0x000007d0, 
    0x3b2f290c, 0x4c4a483e, 0x59584f4d, 0x0000069b, 0x4d4d4d39, 0x3f694869, 0x591a1a48, 0x00000039, 
    0x00000000, 0x00000000, 0x00830232, 0x00790234, 0x00000083, 0x00000014, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x110c0702, 0x241f1a16, 0x37322e29, 0x00b5b529, 0x08c400d2, 0x000008c4, 
    0x3c392a0d, 0x4d4b4a48, 0x5a59584f, 0x00000852, 0x4e4e4e3a, 0x496a496a, 0x5a1c1c49, 0x0000003a, 
    0x00000000, 0x00000000, 0x00930277, 0x00880279, 0x00000093, 0x00000017, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x110c0702, 0x241f1a16, 0x37322e29, 0x00b5b529, 0x09d700ec, 0x000009d7, 
    0x3e3a2c0f, 0x4f4d4b49, 0x5b5a5958, 0x00000a7c, 0x5858583b, 0x4a6b4a6b, 0x5b1d1d4a, 0x0000003b, 
    0x00000000, 0x00000000, 0x00a502c5, 0x009902c7, 0x000000a5, 0x00000019, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x110c0702, 0x241f1a16, 0x37322e29, 0x00b5b529, 0x0b0c0109, 0x00000b0c, 
    0x3f3b2d19, 0x584e4c4a, 0x5d5b5a59, 0x00000d35, 0x5959593d, 0x4b6c4c6c, 0x5c1f1f4c, 0x0000003d, 
    0x00000000, 0x00000000, 0x00ba031b, 0x00ab031e, 0x000000b9, 0x0000001d, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x110c0702, 0x241f1a16, 0x37322e29, 0x00b5b529, 0x0c66012a, 0x00000c66, 
    0x493c2f1a, 0x59584d4b, 0x5e5d5c5a, 0x000010a4, 0x5a5a5a3e, 0x4c6e4d6e, 0x5e28284d, 0x0000003e, 
    0x00000000, 0x00000000, 0x00d1037d, 0x00c10380, 0x000000d0, 0x00000020, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x110c0702, 0x241f1a16, 0x37322e29, 0x00b5b529, 0x0deb014e, 0x00000deb, 
    0x4a3e381b, 0x5a594f4c, 0x685e5d5c, 0x000014f7, 0x5b5b5b48, 0x4e784f78, 0x5f29294f, 0x00000048, 
    0x00000000, 0x00000000, 0x00ea03ea, 0x00d803ee, 0x000000e9, 0x00000024, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x110c0702, 0x241f1a16, 0x37322e29, 0x00b5b529, 0x0fa00177, 0x00000fa0, 
    0x4b3f391c, 0x5c5a584e, 0x69685f5d, 0x00001a6a, 0x5d5d5d49, 0x4f795879, 0x692a2a58, 0x00000049, 
    0x00000000, 0x00000000, 0x01070465, 0x00f30469, 0x00000106, 0x00000029, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x110c0702, 0x241f1a16, 0x37322e29, 0x00b5b529, 0x118901a5, 0x00001189, 
    0x4c493a1e, 0x5d5b5a58, 0x6a69685f, 0x00002148, 0x5e5e5e4a, 0x597a597a, 0x6a2c2c59, 0x0000004a, 
    0x00000000, 0x00000000, 0x012704ef, 0x011004f3, 0x00000126, 0x0000002e, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x110c0702, 0x241f1a16, 0x37322e29, 0x00b5b529, 0x13af01d9, 0x000013af, 
    0x4e4a3c28, 0x5f5d5b59, 0x6b6a6968, 0x000029ee, 0x6868684b, 0x5a7b5a7b, 0x6b2d2d5a, 0x0000004b, 
    0x00000000, 0x00000000, 0x014b058a, 0x0132058e, 0x0000014a, 0x00000033, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x110c0702, 0x241f1a16, 0x37322e29, 0x00b5b529, 0x16180212, 0x00001618, 
    0x4f4b3d29, 0x685e5c5a, 0x6d6b6a69, 0x000034d4, 0x6969694d, 0x5b7c5c7c, 0x6c2f2f5c, 0x0000004d, 
    0x00000000, 0x00000000, 0x01740637, 0x0157063c, 0x00000172, 0x0000003a, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x110c0702, 0x241f1a16, 0x37322e29, 0x00b5b529, 0x18cd0254, 0x000018cd, 
    0x594c3f2a, 0x69685d5b, 0x6e6d6c6a, 0x0000428f, 0x6a6a6a4e, 0x5c7e5d7e, 0x6e38385d, 0x0000004e, 
    0x00000000, 0x00000000, 0x01a206fa, 0x01820700, 0x000001a0, 0x00000041, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x110c0702, 0x241f1a16, 0x37322e29, 0x00b5b529, 0x1bd7029c, 0x00001bd7, 
    0x5a4e482b, 0x6a695f5c, 0x6f6e6d6c, 0x000053dc, 0x6b6b6b58, 0x5e885f88, 0x6f39395f, 0x00000058, 
    0x00000000, 0x00000000, 0x01d507d5, 0x01b107dc, 0x000001d3, 0x00000049, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x110c0702, 0x241f1a16, 0x37322e29, 0x00b5b529, 0x1f4002ee, 0x00001f40, 
    0x5b4f492c, 0x6c6a685e, 0x6f6f6f6d, 0x000069a8, 0x6d6d6d59, 0x5f896889, 0x793a3a68, 0x00000059, 
    0x00000000, 0x00000000, 0x020e08cb, 0x01e608d2, 0x0000020c, 0x00000052, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x110c0702, 0x241f1a16, 0x37322e29, 0x00b5b529, 0x2313034a, 0x00002313, 
    0x5c594a2e, 0x6d6b6a68, 0x6f6f6f6f, 0x0000851f, 0x6e6e6e5a, 0x698a698a, 0x7a3c3c69, 0x0000005a, 
    0x00000000, 0x00000000, 0x024f09de, 0x022109e7, 0x0000024c, 0x0000005c, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x110c0702, 0x241f1a16, 0x37322e29, 0x00b5b529, 0x275f03b2, 0x0000275f, 
    0x5e5a4c38, 0x6f6d6b69, 0x6f6f6f6f, 0x0000a7b8, 0x7878785b, 0x6a8b6a8b, 0x7b3d3d6a, 0x0000005b, 
    0x00000000, 0x00000000, 0x02970b14, 0x02640b1d, 0x00000294, 0x00000067, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x110c0702, 0x241f1a16, 0x37322e29, 0x00b5b529, 0x2c310425, 0x00002c31, 
    0x5f5b4d39, 0x6f6e6c6a, 0x6f6f6f6f, 0x0000d351, 0x7979795d, 0x6b8c6c8c, 0x7c3f3f6c, 0x0000005d, 
    0x00000000, 0x00000000, 0x02e80c6f, 0x02af0c79, 0x000002e5, 0x00000074, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x110c0702, 0x241f1a16, 0x37322e29, 0x00b5b529, 0x319b04a8, 0x0000319b, 
    0x695c4f3a, 0x6f6f6d6b, 0x6f6f6f6f, 0x00000a3d, 0x7a7a7a5e, 0x6c8e6d8e, 0x7e48486d, 0x0000005e, 
    0x00000000, 0x00000000, 0x03440df5, 0x03040e01, 0x00000340, 0x00000082, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x110c0702, 0x241f1a16, 0x37322e29, 0x00b5b529, 0x37ae0539, 0x000037ae, 
    0x6a5e583b, 0x6f6f6f6c, 0x6f6f6f6f, 0x00004f71, 0x7b7b7b68, 0x6e8f6f8f, 0x7f49496f, 0x00000068, 
    0x00000000, 0x00000000, 0x03aa0faa, 0x03620fb8, 0x000003a6, 0x00000092, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x110c0702, 0x241f1a16, 0x37322e29, 0x00b5b529, 0x3e8005dd, 0x00003e80, 
    0x6b5f593c, 0x6f6f6f6e, 0x6f6f6f6f, 0x0000a6a1, 0x7d7d7d69, 0x6f8f788f, 0x894a4a78, 0x00000069, 
    0x00000000, 0x00000000, 0x041d1196, 0x03cc11a4, 0x00000418, 0x000000a4, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x110c0702, 0x241f1a16, 0x37322e29, 0x00b5b529, 0x46270695, 0x00004627, 
    0x6c695a3e, 0x6f6f6f6f, 0x6f6f6f6f, 0x0000147b, 0x7e7e7e6a, 0x798f798f, 0x8a4c4c79, 0x0000006a, 
    0x00000000, 0x00000000, 0x049e13bd, 0x044313ce, 0x00000498, 0x000000b8, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x110c0702, 0x241f1a16, 0x37322e29, 0x00b5b529, 0x4ebe0764, 0x00004ebe, 
    0x6e6a5c48, 0x6f6f6f6f, 0x6f6f6f6f, 0x00009ee2, 0x8888886b, 0x7a8f7a8f, 0x8b4d4d7a, 0x0000006b, 
    0x00000000, 0x00000000, 0x052f1628, 0x04c9163b, 0x00000528, 0x000000cf, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x110c0702, 0x241f1a16, 0x37322e29, 0x00b5b529, 0x5863084b, 0x00005863, 
    0x6f6b5d49, 0x6f6f6f6f, 0x6f6f6f6f, 0x00004d42, 0x8989896d, 0x7b8f7c8f, 0x8c4f4f7c, 0x0000006d, 
    0x00000000, 0x00000000, 0x05d118df, 0x055f18f3, 0x000005ca, 0x000000e8, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x110c0702, 0x241f1a16, 0x37322e29, 0x00b5b529, 0x63360950, 0x00006336, 
    0x6f6c5f4a, 0x6f6f6f6f, 0x6f6f6f6f, 0x000028f6, 0x8a8a8a6e, 0x7c8f7d8f, 0x8e58587d, 0x0000006e, 
    0x00000000, 0x00000000, 0x06881bea, 0x06081c02, 0x00000680, 0x00000105, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x110c0702, 0x241f1a16, 0x37322e29, 0x00b5b529, 0x6f5c0a73, 0x00006f5c, 
    0x6f6e684b, 0x6f6f6f6f, 0x6f6f6f6f, 0x00003dc4, 0x8b8b8b78, 0x7e8f7f8f, 0x8f59597f, 0x00000078, 
    0x00000000, 0x00000000, 0x07541f55, 0x06c51f70, 0x0000074c, 0x00000125, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x110c0702, 0x241f1a16, 0x37322e29, 0x00b5b529, 0x7d000bbb, 0x00007d00, 
    0x6f6f694c, 0x6f6f6f6f, 0x6f6f6f6f, 0x00009a85, 0x8d8d8d79, 0x7f8f888f, 0x8f5a5a88, 0x00000079, 
    0x00000000, 0x00000000, 0x083a232c, 0x07992349, 0x00000830, 0x00000148, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x110c0702, 0x241f1a16, 0x37322e29, 0x00b5b529, 0x8c4e0d2b, 0x00008c4e, 
    0x6f6f6a4e, 0x6f6f6f6f, 0x6f6f6f6f, 0x000051ec, 0x8e8e8e7a, 0x898f898f, 0x8f5c5c89, 0x0000007a, 
    0x00000000, 0x00000000, 0x093c277b, 0x0887279c, 0x00000931, 0x00000171, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x110c0702, 0x241f1a16, 0x37322e29, 0x00b5b529, 0x9d7d0ec8, 0x00009d7d, 
    0x04030100, 0x09080705, 0x0e0d0c0a, 0x00000004, 0x09090903, 0x051d061d, 0x0d000006, 0x00000003, 
    0x00000000, 0x00000000, 0x0006001a, 0x0005001a, 0x00000006, 0x00000000, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x120d0803, 0x28221d18, 0x3d37322d, 0x00b5b529, 0x006a0009, 0x0000006a, 
    0x04030100, 0x09080705, 0x0e0d0c0a, 0x00000004, 0x09090903, 0x051d061d, 0x0d000006, 0x00000003, 
    0x00000000, 0x00000000, 0x0006001a, 0x0005001a, 0x00000006, 0x00000000, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x120d0803, 0x28221d18, 0x3d37322d, 0x00b5b529, 0x006a0009, 0x0000006a, 
    0x04030100, 0x09080705, 0x0e0d0c0a, 0x00000004, 0x09090903, 0x051d061d, 0x0d000006, 0x00000003, 
    0x00000000, 0x00000000, 0x0006001a, 0x0005001a, 0x00000006, 0x00000000, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x120d0803, 0x28221d18, 0x3d37322d, 0x00b5b529, 0x006a0009, 0x0000006a, 
    0x04030100, 0x09080705, 0x0e0d0c0a, 0x00000004, 0x09090903, 0x051d061d, 0x0d000006, 0x00000003, 
    0x00000000, 0x00000000, 0x0006001a, 0x0005001a, 0x00000006, 0x00000000, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x120d0803, 0x28221d18, 0x3d37322d, 0x00b5b529, 0x006a0009, 0x0000006a, 
    0x04030100, 0x09080705, 0x0e0d0c0a, 0x00000004, 0x09090903, 0x051d061d, 0x0d000006, 0x00000003, 
    0x00000000, 0x00000000, 0x0006001a, 0x0005001a, 0x00000006, 0x00000000, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x120d0803, 0x28221d18, 0x3d37322d, 0x00b5b529, 0x006a0009, 0x0000006a, 
    0x04030100, 0x09080705, 0x0e0d0c0a, 0x00000004, 0x09090903, 0x051d061d, 0x0d000006, 0x00000003, 
    0x00000000, 0x00000000, 0x0006001a, 0x0005001a, 0x00000006, 0x00000000, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x120d0803, 0x28221d18, 0x3d37322d, 0x00b5b529, 0x006a0009, 0x0000006a, 
    0x04030100, 0x09080705, 0x0e0d0c0a, 0x00000004, 0x09090903, 0x051d061d, 0x0d000006, 0x00000003, 
    0x00000000, 0x00000000, 0x0006001a, 0x0005001a, 0x00000006, 0x00000000, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x120d0803, 0x28221d18, 0x3d37322d, 0x00b5b529, 0x006a0009, 0x0000006a, 
    0x04030100, 0x09080705, 0x0e0d0c0a, 0x00000004, 0x09090903, 0x051d061d, 0x0d000006, 0x00000003, 
    0x00000000, 0x00000000, 0x0006001a, 0x0005001a, 0x00000006, 0x00000000, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x120d0803, 0x28221d18, 0x3d37322d, 0x00b5b529, 0x006a0009, 0x0000006a, 
    0x04030100, 0x09080705, 0x0e0d0c0a, 0x00000004, 0x09090903, 0x051d061d, 0x0d000006, 0x00000003, 
    0x00000000, 0x00000000, 0x0006001a, 0x0005001a, 0x00000006, 0x00000000, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x120d0803, 0x28221d18, 0x3d37322d, 0x00b5b529, 0x006a0009, 0x0000006a, 
    0x04030100, 0x09080705, 0x0e0d0c0a, 0x00000004, 0x09090903, 0x051d061d, 0x0d000006, 0x00000003, 
    0x00000000, 0x00000000, 0x0006001a, 0x0005001a, 0x00000006, 0x00000000, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x120d0803, 0x28221d18, 0x3d37322d, 0x00b5b529, 0x006a0009, 0x0000006a, 
    0x04030100, 0x09080705, 0x0e0d0c0a, 0x00000004, 0x09090903, 0x051d061d, 0x0d000006, 0x00000003, 
    0x00000000, 0x00000000, 0x0006001a, 0x0005001a, 0x00000006, 0x00000000, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x120d0803, 0x28221d18, 0x3d37322d, 0x00b5b529, 0x006a0009, 0x0000006a, 
    0x04030100, 0x09080705, 0x0e0d0c0a, 0x00000004, 0x09090903, 0x051d061d, 0x0d000006, 0x00000003, 
    0x00000000, 0x00000000, 0x0006001a, 0x0005001a, 0x00000006, 0x00000000, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x120d0803, 0x28221d18, 0x3d37322d, 0x00b5b529, 0x006a0009, 0x0000006a, 
    0x04030100, 0x09080705, 0x0e0d0c0a, 0x00000004, 0x09090903, 0x051d061d, 0x0d000006, 0x00000003, 
    0x00000000, 0x00000000, 0x0006001a, 0x0005001a, 0x00000006, 0x00000000, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x120d0803, 0x28221d18, 0x3d37322d, 0x00b5b529, 0x006a0009, 0x0000006a, 
    0x05030200, 0x0a090706, 0x180f0d0c, 0x00000005, 0x0a0a0a03, 0x061f061f, 0x0e010106, 0x00000003, 
    0x00000000, 0x00000000, 0x0006001d, 0x0006001d, 0x00000006, 0x00000001, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x120d0803, 0x28221d18, 0x3d37322d, 0x00b5b529, 0x0077000b, 0x00000077, 
    0x05040200, 0x0c0a0807, 0x19180f0d, 0x00000006, 0x0c0c0b04, 0x07280728, 0x18010107, 0x00000004, 
    0x00000000, 0x00000000, 0x00070021, 0x00070021, 0x00000007, 0x00000001, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x120d0803, 0x28221d18, 0x3d37322d, 0x00b5b529, 0x0085000c, 0x00000085, 
    0x06040200, 0x0d0b0908, 0x1a1a190f, 0x00000008, 0x0d0d0d04, 0x08290829, 0x19010108, 0x00000004, 
    0x00000000, 0x00000000, 0x00080025, 0x00080025, 0x00000008, 0x00000001, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x120d0803, 0x28221d18, 0x3d37322d, 0x00b5b529, 0x0096000e, 0x00000096, 
    0x07050301, 0x0f0d0b09, 0x1c1b1a19, 0x0000000a, 0x0f0f0f05, 0x092b092b, 0x1a010109, 0x00000005, 
    0x00000000, 0x00000000, 0x0009002a, 0x0009002a, 0x00000009, 0x00000001, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x120d0803, 0x28221d18, 0x3d37322d, 0x00b5b529, 0x00a8000f, 0x000000a8, 
    0x08050301, 0x190e0c0a, 0x1d1c1b1a, 0x0000000c, 0x19191806, 0x0a2c0b2c, 0x1c01010b, 0x00000006, 
    0x00000000, 0x00000000, 0x000b002f, 0x000a002f, 0x0000000b, 0x00000001, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x120d0803, 0x28221d18, 0x3d37322d, 0x00b5b529, 0x00bd0011, 0x000000bd, 
    0x08060301, 0x1a180e0b, 0x1f1d1c1b, 0x0000000f, 0x1a1a1906, 0x0b2d0c2d, 0x1d01010c, 0x00000006, 
    0x00000000, 0x00000000, 0x000c0035, 0x000b0035, 0x0000000c, 0x00000001, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x120d0803, 0x28221d18, 0x3d37322d, 0x00b5b529, 0x00d40013, 0x000000d4, 
    0x0a070401, 0x1b190f0c, 0x281f1e1c, 0x00000013, 0x1b1b1b07, 0x0c2f0d2f, 0x1f02020d, 0x00000007, 
    0x00000000, 0x00000000, 0x000d003b, 0x000c003b, 0x0000000d, 0x00000002, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x120d0803, 0x28221d18, 0x3d37322d, 0x00b5b529, 0x00ee0016, 0x000000ee, 
    0x0b080401, 0x1c1b190e, 0x29281f1e, 0x00000018, 0x1c1c1c08, 0x0e380f38, 0x2802020f, 0x00000008, 
    0x00000000, 0x00000000, 0x000f0043, 0x000e0043, 0x0000000f, 0x00000002, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x120d0803, 0x28221d18, 0x3d37322d, 0x00b5b529, 0x010b0019, 0x0000010b, 
    0x0c090501, 0x1e1c1a18, 0x2a2a291f, 0x0000001e, 0x1e1d1d09, 0x18391939, 0x29020219, 0x00000009, 
    0x00000000, 0x00000000, 0x0011004b, 0x0010004b, 0x00000011, 0x00000002, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x120d0803, 0x28221d18, 0x3d37322d, 0x00b5b529, 0x012c001c, 0x0000012c, 
    0x0e0a0602, 0x1f1d1b19, 0x2c2b2a29, 0x00000026, 0x1f1f1f0a, 0x193b1a3b, 0x2a03031a, 0x0000000a, 
    0x00000000, 0x00000000, 0x00130054, 0x00120054, 0x00000013, 0x00000003, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x120d0803, 0x28221d18, 0x3d37322d, 0x00b5b529, 0x0151001f, 0x00000151, 
    0x180b0602, 0x291f1d1a, 0x2d2c2b2a, 0x00000030, 0x2929280c, 0x1a3c1b3c, 0x2c03031b, 0x0000000c, 
    0x00000000, 0x00000000, 0x0016005e, 0x0014005f, 0x00000016, 0x00000003, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x120d0803, 0x28221d18, 0x3d37322d, 0x00b5b529, 0x017a0023, 0x0000017a, 
    0x190c0702, 0x2a281e1c, 0x2f2d2c2b, 0x0000003d, 0x2a2a290d, 0x1c3d1c3d, 0x2d03031c, 0x0000000d, 
    0x00000000, 0x00000000, 0x0018006a, 0x0017006a, 0x00000018, 0x00000003, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x120d0803, 0x28221d18, 0x3d37322d, 0x00b5b529, 0x01a80027, 0x000001a8, 
    0x1a0e0802, 0x2b29281d, 0x382f2e2c, 0x0000004c, 0x2b2b2b0f, 0x1d3f1e3f, 0x2f04041e, 0x0000000f, 
    0x00000000, 0x00000000, 0x001b0077, 0x00190077, 0x0000001b, 0x00000004, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x120d0803, 0x28221d18, 0x3d37322d, 0x00b5b529, 0x01dc002c, 0x000001dc, 
    0x1b180903, 0x2c2b291f, 0x39382f2e, 0x00000060, 0x2c2c2c19, 0x1e482848, 0x38040428, 0x00000019, 
    0x00000000, 0x00000000, 0x001f0086, 0x001c0086, 0x0000001f, 0x00000004, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x120d0803, 0x28221d18, 0x3d37322d, 0x00b5b529, 0x02170032, 0x00000217, 
    0x1d190a03, 0x2e2c2a28, 0x3a3a392f, 0x00000079, 0x2e2d2d1a, 0x28492949, 0x39050529, 0x0000001a, 
    0x00000000, 0x00000000, 0x00230096, 0x00200097, 0x00000023, 0x00000005, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x120d0803, 0x28221d18, 0x3d37322d, 0x00b5b529, 0x02580038, 0x00000258, 
    0x1e1a0c04, 0x2f2d2b29, 0x3c3b3a39, 0x00000099, 0x2f2f2f1b, 0x294b2a4b, 0x3a06062a, 0x0000001b, 
    0x00000000, 0x00000000, 0x002700a9, 0x002400a9, 0x00000027, 0x00000006, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x120d0803, 0x28221d18, 0x3d37322d, 0x00b5b529, 0x02a2003f, 0x000002a2, 
    0x281b0d04, 0x392f2d2a, 0x3d3c3b3a, 0x000000c0, 0x3939381c, 0x2a4c2b4c, 0x3c06062b, 0x0000001c, 
    0x00000000, 0x00000000, 0x002c00bd, 0x002900be, 0x0000002c, 0x00000006, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x120d0803, 0x28221d18, 0x3d37322d, 0x00b5b529, 0x02f50047, 0x000002f5, 
    0x291d0f05, 0x3a382e2c, 0x3f3d3c3b, 0x000000f2, 0x3a3a391e, 0x2c4d2c4d, 0x3d07072c, 0x0000001e, 
    0x00000000, 0x00000000, 0x003100d5, 0x002e00d5, 0x00000031, 0x00000007, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x120d0803, 0x28221d18, 0x3d37322d, 0x00b5b529, 0x0351004f, 0x00000351, 
    0x2a1e1905, 0x3b39382d, 0x483f3e3c, 0x00000131, 0x3b3b3b1f, 0x2d4f2e4f, 0x3f08082e, 0x0000001f, 
    0x00000000, 0x00000000, 0x003700ef, 0x003300ef, 0x00000037, 0x00000008, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x120d0803, 0x28221d18, 0x3d37322d, 0x00b5b529, 0x03b90059, 0x000003b9, 
    0x2b281a06, 0x3c3b392f, 0x49483f3e, 0x00000181, 0x3c3c3c29, 0x2e583858, 0x48090938, 0x00000029, 
    0x00000000, 0x00000000, 0x003e010c, 0x0039010d, 0x0000003e, 0x00000009, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x120d0803, 0x28221d18, 0x3d37322d, 0x00b5b529, 0x042e0064, 0x0000042e, 
    0x2d291b07, 0x3e3c3a38, 0x4a4a493f, 0x000001e5, 0x3e3d3d2a, 0x38593959, 0x490b0b39, 0x0000002a, 
    0x00000000, 0x00000000, 0x0046012d, 0x0041012e, 0x00000046, 0x0000000b, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x120d0803, 0x28221d18, 0x3d37322d, 0x00b5b529, 0x04b10070, 0x000004b1, 
    0x2e2a1c08, 0x3f3d3b39, 0x4c4b4a49, 0x00000263, 0x3f3f3f2b, 0x395b3a5b, 0x4a0c0c3a, 0x0000002b, 
    0x00000000, 0x00000000, 0x004f0152, 0x00490153, 0x0000004e, 0x0000000c, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x120d0803, 0x28221d18, 0x3d37322d, 0x00b5b529, 0x0545007e, 0x00000545, 
    0x382b1e09, 0x493f3d3a, 0x4d4c4b4a, 0x00000301, 0x4949482c, 0x3a5c3b5c, 0x4c0d0d3b, 0x0000002c, 
    0x00000000, 0x00000000, 0x0058017b, 0x0052017c, 0x00000058, 0x0000000d, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x120d0803, 0x28221d18, 0x3d37322d, 0x00b5b529, 0x05ea008e, 0x000005ea, 
    0x392d1f0a, 0x4a483e3c, 0x4f4d4c4b, 0x000003c9, 0x4a4a492e, 0x3c5d3c5d, 0x4d0f0f3c, 0x0000002e, 
    0x00000000, 0x00000000, 0x006301aa, 0x005c01ab, 0x00000063, 0x0000000f, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x120d0803, 0x28221d18, 0x3d37322d, 0x00b5b529, 0x06a3009f, 0x000006a3, 
    0x3a2e290b, 0x4b49483d, 0x584f4e4c, 0x000004c5, 0x4b4b4b2f, 0x3d5f3e5f, 0x4f19193e, 0x0000002f, 
    0x00000000, 0x00000000, 0x006f01de, 0x006701df, 0x0000006f, 0x00000011, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x120d0803, 0x28221d18, 0x3d37322d, 0x00b5b529, 0x077300b3, 0x00000773, 
    0x3b382a0c, 0x4c4b493f, 0x59584f4e, 0x00000602, 0x4c4c4c39, 0x3e684868, 0x581a1a48, 0x00000039, 
    0x00000000, 0x00000000, 0x007d0218, 0x0073021a, 0x0000007d, 0x00000013, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x120d0803, 0x28221d18, 0x3d37322d, 0x00b5b529, 0x085d00c9, 0x0000085d, 
    0x3d392b0e, 0x4e4c4a48, 0x5a5a594f, 0x00000792, 0x4e4d4d3a, 0x48694969, 0x591b1b49, 0x0000003a, 
    0x00000000, 0x00000000, 0x008c025a, 0x0082025c, 0x0000008c, 0x00000016, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x120d0803, 0x28221d18, 0x3d37322d, 0x00b5b529, 0x096300e1, 0x00000963, 
    0x3e3a2c18, 0x4f4d4b49, 0x5c5b5a59, 0x0000098a, 0x4f4f4f3b, 0x496b4a6b, 0x5a1c1c4a, 0x0000003b, 
    0x00000000, 0x00000000, 0x009e02a4, 0x009202a6, 0x0000009d, 0x00000018, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x120d0803, 0x28221d18, 0x3d37322d, 0x00b5b529, 0x0a8a00fd, 0x00000a8a, 
    0x483b2e19, 0x594f4d4a, 0x5d5c5b5a, 0x00000c05, 0x5959583c, 0x4a6c4b6c, 0x5c1e1e4b, 0x0000003c, 
    0x00000000, 0x00000000, 0x00b102f7, 0x00a402f9, 0x000000b0, 0x0000001b, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x120d0803, 0x28221d18, 0x3d37322d, 0x00b5b529, 0x0bd4011c, 0x00000bd4, 
    0x493d2f1a, 0x5a584e4c, 0x5f5d5c5b, 0x00000f24, 0x5a5a593e, 0x4c6d4c6d, 0x5d28284c, 0x0000003e, 
    0x00000000, 0x00000000, 0x00c70354, 0x00b80357, 0x000000c6, 0x0000001f, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x120d0803, 0x28221d18, 0x3d37322d, 0x00b5b529, 0x0d47013f, 0x00000d47, 
    0x4a3e391c, 0x5b59584d, 0x685f5e5c, 0x00001314, 0x5b5b5b3f, 0x4d6f4e6f, 0x5f29294e, 0x0000003f, 
    0x00000000, 0x00000000, 0x00df03bc, 0x00ce03bf, 0x000000de, 0x00000022, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x120d0803, 0x28221d18, 0x3d37322d, 0x00b5b529, 0x0ee70166, 0x00000ee7, 
    0x4b483a1d, 0x5c5b594f, 0x69685f5e, 0x00001809, 0x5c5c5c49, 0x4e785878, 0x682a2a58, 0x00000049, 
    0x00000000, 0x00000000, 0x00fb0431, 0x00e70435, 0x000000fa, 0x00000027, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x120d0803, 0x28221d18, 0x3d37322d, 0x00b5b529, 0x10bb0192, 0x000010bb, 
    0x4d493b1f, 0x5e5c5a58, 0x6a6a695f, 0x00001e49, 0x5e5d5d4a, 0x58795979, 0x692b2b59, 0x0000004a, 
    0x00000000, 0x00000000, 0x011904b5, 0x010404b9, 0x00000118, 0x0000002c, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x120d0803, 0x28221d18, 0x3d37322d, 0x00b5b529, 0x12c701c3, 0x000012c7, 
    0x4e4a3c28, 0x5f5d5b59, 0x6c6b6a69, 0x00002628, 0x5f5f5f4b, 0x597b5a7b, 0x6a2c2c5a, 0x0000004b, 
    0x00000000, 0x00000000, 0x013c0548, 0x0124054d, 0x0000013b, 0x00000031, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x120d0803, 0x28221d18, 0x3d37322d, 0x00b5b529, 0x151401fa, 0x00001514, 
    0x584b3e29, 0x695f5d5a, 0x6d6c6b6a, 0x00003013, 0x6969684c, 0x5a7c5b7c, 0x6c2e2e5b, 0x0000004c, 
    0x00000000, 0x00000000, 0x016305ee, 0x014805f3, 0x00000161, 0x00000037, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x120d0803, 0x28221d18, 0x3d37322d, 0x00b5b529, 0x17a90238, 0x000017a9, 
    0x594d3f2a, 0x6a685e5c, 0x6f6d6c6b, 0x00003c92, 0x6a6a694e, 0x5c7d5c7d, 0x6d38385c, 0x0000004e, 
    0x00000000, 0x00000000, 0x018e06a8, 0x017006ae, 0x0000018c, 0x0000003e, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x120d0803, 0x28221d18, 0x3d37322d, 0x00b5b529, 0x1a8e027e, 0x00001a8e, 
    0x5a4e492c, 0x6b69685d, 0x6f6f6e6c, 0x00004c50, 0x6b6b6b4f, 0x5d7f5e7f, 0x6f39395e, 0x0000004f, 
    0x00000000, 0x00000000, 0x01bf0779, 0x019d077f, 0x000001bd, 0x00000045, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x120d0803, 0x28221d18, 0x3d37322d, 0x00b5b529, 0x1dcf02cc, 0x00001dcf, 
    0x5b584a2d, 0x6c6b695f, 0x6f6f6f6e, 0x00006026, 0x6c6c6c59, 0x5e886888, 0x783a3a68, 0x00000059, 
    0x00000000, 0x00000000, 0x01f60863, 0x01cf086a, 0x000001f4, 0x0000004e, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x120d0803, 0x28221d18, 0x3d37322d, 0x00b5b529, 0x21760324, 0x00002176, 
    0x5d594b2f, 0x6e6c6a68, 0x6f6f6f6f, 0x00007924, 0x6e6d6d5a, 0x68896989, 0x793b3b69, 0x0000005a, 
    0x00000000, 0x00000000, 0x0233096a, 0x02080972, 0x00000231, 0x00000058, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x120d0803, 0x28221d18, 0x3d37322d, 0x00b5b529, 0x258f0386, 0x0000258f, 
    0x5e5a4c38, 0x6f6d6b69, 0x6f6f6f6f, 0x000098a0, 0x6f6f6f5b, 0x698b6a8b, 0x7a3c3c6a, 0x0000005b, 
    0x00000000, 0x00000000, 0x02790a91, 0x02480a9a, 0x00000276, 0x00000062, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x120d0803, 0x28221d18, 0x3d37322d, 0x00b5b529, 0x2a2803f5, 0x00002a28, 
    0x685b4e39, 0x6f6f6d6a, 0x6f6f6f6f, 0x0000c04c, 0x7979785c, 0x6a8c6b8c, 0x7c3e3e6b, 0x0000005c, 
    0x00000000, 0x00000000, 0x02c60bdc, 0x02900be6, 0x000002c3, 0x0000006e, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x120d0803, 0x28221d18, 0x3d37322d, 0x00b5b529, 0x2f520471, 0x00002f52, 
    0x695d4f3a, 0x6f6f6e6c, 0x6f6f6f6f, 0x0000f247, 0x7a7a795e, 0x6c8d6c8d, 0x7d48486c, 0x0000005e, 
    0x00000000, 0x00000000, 0x031d0d50, 0x02e00d5c, 0x00000319, 0x0000007c, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x120d0803, 0x28221d18, 0x3d37322d, 0x00b5b529, 0x351d04fc, 0x0000351d, 
    0x6a5e593c, 0x6f6f6f6d, 0x6f6f6f6f, 0x00003140, 0x7b7b7b5f, 0x6d8f6e8f, 0x7f49496e, 0x0000005f, 
    0x00000000, 0x00000000, 0x037f0ef2, 0x033a0efe, 0x0000037b, 0x0000008b, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x120d0803, 0x28221d18, 0x3d37322d, 0x00b5b529, 0x3b9f0598, 0x00003b9f, 
    0x6b685a3d, 0x6f6f6f6f, 0x6f6f6f6f, 0x00008098, 0x7c7c7c69, 0x6e8f788f, 0x884a4a78, 0x00000069, 
    0x00000000, 0x00000000, 0x03ec10c6, 0x039f10d4, 0x000003e8, 0x0000009c, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x120d0803, 0x28221d18, 0x3d37322d, 0x00b5b529, 0x42ec0648, 0x000042ec, 
    0x6d695b3f, 0x6f6f6f6f, 0x6f6f6f6f, 0x0000e48f, 0x7e7d7d6a, 0x788f798f, 0x894b4b79, 0x0000006a, 
    0x00000000, 0x00000000, 0x046712d4, 0x041112e4, 0x00000462, 0x000000b0, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x120d0803, 0x28221d18, 0x3d37322d, 0x00b5b529, 0x4b1e070d, 0x00004b1e, 
    0x6e6a5c48, 0x6f6f6f6f, 0x6f6f6f6f, 0x00006281, 0x7f7f7f6b, 0x798f7a8f, 0x8a4c4c7a, 0x0000006b, 
    0x00000000, 0x00000000, 0x04f21523, 0x04911534, 0x000004ec, 0x000000c5, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x120d0803, 0x28221d18, 0x3d37322d, 0x00b5b529, 0x545107ea, 0x00005451, 
    0x6f6b5e49, 0x6f6f6f6f, 0x6f6f6f6f, 0x00000130, 0x8989886c, 0x7a8f7b8f, 0x8c4e4e7b, 0x0000006c, 
    0x00000000, 0x00000000, 0x058d17b9, 0x052017cd, 0x00000586, 0x000000dd, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x120d0803, 0x28221d18, 0x3d37322d, 0x00b5b529, 0x5ea408e2, 0x00005ea4, 
    0x6f6d5f4a, 0x6f6f6f6f, 0x6f6f6f6f, 0x0000c91d, 0x8a8a896e, 0x7c8f7c8f, 0x8d58587c, 0x0000006e, 
    0x00000000, 0x00000000, 0x063b1aa1, 0x05c11ab8, 0x00000633, 0x000000f9, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x120d0803, 0x28221d18, 0x3d37322d, 0x00b5b529, 0x6a3b09f8, 0x00006a3b, 
    0x6f6e694c, 0x6f6f6f6f, 0x6f6f6f6f, 0x0000c502, 0x8b8b8b6f, 0x7d8f7e8f, 0x8f59597e, 0x0000006f, 
    0x00000000, 0x00000000, 0x06fe1de4, 0x06751dfd, 0x000006f6, 0x00000117, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x120d0803, 0x28221d18, 0x3d37322d, 0x00b5b529, 0x773e0b31, 0x0000773e, 
    0x6f6f6a4d, 0x6f6f6f6f, 0x6f6f6f6f, 0x0000025f, 0x8c8c8c79, 0x7e8f888f, 0x8f5a5a88, 0x00000079, 
    0x00000000, 0x00000000, 0x07d9218d, 0x073f21a9, 0x000007d0, 0x00000139, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x120d0803, 0x28221d18, 0x3d37322d, 0x00b5b529, 0x85d80c90, 0x000085d8, 
    0x6f6f6b4f, 0x6f6f6f6f, 0x6f6f6f6f, 0x0000923a, 0x8e8d8d7a, 0x888f898f, 0x8f5b5b89, 0x0000007a, 
    0x00000000, 0x00000000, 0x08cf25a9, 0x082325c9, 0x000008c5, 0x00000160, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x120d0803, 0x28221d18, 0x3d37322d, 0x00b5b529, 0x963c0e1a, 0x0000963c, 
    0x03020100, 0x08060504, 0x0c0b0a09, 0x00000004, 0x09090903, 0x051d061d, 0x0d000006, 0x00000003, 
    0x00000000, 0x00000000, 0x0006001a, 0x0005001a, 0x00000006, 0x00000000, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0b0702, 0x211d1814, 0x332e2a25, 0x00b5b529, 0x006a0009, 0x0000006a, 
    0x03020100, 0x08060504, 0x0c0b0a09, 0x00000004, 0x09090903, 0x051d061d, 0x0d000006, 0x00000003, 
    0x00000000, 0x00000000, 0x0006001a, 0x0005001a, 0x00000006, 0x00000000, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0b0702, 0x211d1814, 0x332e2a25, 0x00b5b529, 0x006a0009, 0x0000006a, 
    0x03020100, 0x08060504, 0x0c0b0a09, 0x00000004, 0x09090903, 0x051d061d, 0x0d000006, 0x00000003, 
    0x00000000, 0x00000000, 0x0006001a, 0x0005001a, 0x00000006, 0x00000000, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0b0702, 0x211d1814, 0x332e2a25, 0x00b5b529, 0x006a0009, 0x0000006a, 
    0x03020100, 0x08060504, 0x0c0b0a09, 0x00000004, 0x09090903, 0x051d061d, 0x0d000006, 0x00000003, 
    0x00000000, 0x00000000, 0x0006001a, 0x0005001a, 0x00000006, 0x00000000, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0b0702, 0x211d1814, 0x332e2a25, 0x00b5b529, 0x006a0009, 0x0000006a, 
    0x03020100, 0x08060504, 0x0c0b0a09, 0x00000004, 0x09090903, 0x051d061d, 0x0d000006, 0x00000003, 
    0x00000000, 0x00000000, 0x0006001a, 0x0005001a, 0x00000006, 0x00000000, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0b0702, 0x211d1814, 0x332e2a25, 0x00b5b529, 0x006a0009, 0x0000006a, 
    0x03020100, 0x08060504, 0x0c0b0a09, 0x00000004, 0x09090903, 0x051d061d, 0x0d000006, 0x00000003, 
    0x00000000, 0x00000000, 0x0006001a, 0x0005001a, 0x00000006, 0x00000000, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0b0702, 0x211d1814, 0x332e2a25, 0x00b5b529, 0x006a0009, 0x0000006a, 
    0x03020100, 0x08060504, 0x0c0b0a09, 0x00000004, 0x09090903, 0x051d061d, 0x0d000006, 0x00000003, 
    0x00000000, 0x00000000, 0x0006001a, 0x0005001a, 0x00000006, 0x00000000, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0b0702, 0x211d1814, 0x332e2a25, 0x00b5b529, 0x006a0009, 0x0000006a, 
    0x03020100, 0x08060504, 0x0c0b0a09, 0x00000004, 0x09090903, 0x051d061d, 0x0d000006, 0x00000003, 
    0x00000000, 0x00000000, 0x0006001a, 0x0005001a, 0x00000006, 0x00000000, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0b0702, 0x211d1814, 0x332e2a25, 0x00b5b529, 0x006a0009, 0x0000006a, 
    0x03020100, 0x08060504, 0x0c0b0a09, 0x00000004, 0x09090903, 0x051d061d, 0x0d000006, 0x00000003, 
    0x00000000, 0x00000000, 0x0006001a, 0x0005001a, 0x00000006, 0x00000000, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0b0702, 0x211d1814, 0x332e2a25, 0x00b5b529, 0x006a0009, 0x0000006a, 
    0x03020100, 0x08060504, 0x0c0b0a09, 0x00000004, 0x09090903, 0x051d061d, 0x0d000006, 0x00000003, 
    0x00000000, 0x00000000, 0x0006001a, 0x0005001a, 0x00000006, 0x00000000, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0b0702, 0x211d1814, 0x332e2a25, 0x00b5b529, 0x006a0009, 0x0000006a, 
    0x03020100, 0x08060504, 0x0c0b0a09, 0x00000004, 0x09090903, 0x051d061d, 0x0d000006, 0x00000003, 
    0x00000000, 0x00000000, 0x0006001a, 0x0005001a, 0x00000006, 0x00000000, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0b0702, 0x211d1814, 0x332e2a25, 0x00b5b529, 0x006a0009, 0x0000006a, 
    0x03020100, 0x08060504, 0x0c0b0a09, 0x00000004, 0x09090903, 0x051d061d, 0x0d000006, 0x00000003, 
    0x00000000, 0x00000000, 0x0006001a, 0x0005001a, 0x00000006, 0x00000000, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0b0702, 0x211d1814, 0x332e2a25, 0x00b5b529, 0x006a0009, 0x0000006a, 
    0x03020100, 0x08060504, 0x0c0b0a09, 0x00000004, 0x09090903, 0x051d061d, 0x0d000006, 0x00000003, 
    0x00000000, 0x00000000, 0x0006001a, 0x0005001a, 0x00000006, 0x00000000, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0b0702, 0x211d1814, 0x332e2a25, 0x00b5b529, 0x006a0009, 0x0000006a, 
    0x04030100, 0x09070605, 0x0d0c0b0a, 0x00000005, 0x0a0a0a03, 0x061f061f, 0x0e010106, 0x00000003, 
    0x00000000, 0x00000000, 0x0006001d, 0x0006001d, 0x00000006, 0x00000001, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0b0702, 0x211d1814, 0x332e2a25, 0x00b5b529, 0x0077000b, 0x00000077, 
    0x04030200, 0x0a080706, 0x0f0e0c0b, 0x00000006, 0x0c0c0b04, 0x07280728, 0x18010107, 0x00000004, 
    0x00000000, 0x00000000, 0x00070021, 0x00070021, 0x00000007, 0x00000001, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0b0702, 0x211d1814, 0x332e2a25, 0x00b5b529, 0x0085000c, 0x00000085, 
    0x05030200, 0x0b090806, 0x190f0e0c, 0x00000008, 0x0d0d0d04, 0x08290829, 0x19010108, 0x00000004, 
    0x00000000, 0x00000000, 0x00080025, 0x00080025, 0x00000008, 0x00000001, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0b0702, 0x211d1814, 0x332e2a25, 0x00b5b529, 0x0096000e, 0x00000096, 
    0x05040200, 0x0c0b0907, 0x1a19180e, 0x0000000a, 0x0f0f0f05, 0x092b092b, 0x1a010109, 0x00000005, 
    0x00000000, 0x00000000, 0x0009002a, 0x0009002a, 0x00000009, 0x00000001, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0b0702, 0x211d1814, 0x332e2a25, 0x00b5b529, 0x00a8000f, 0x000000a8, 
    0x06040200, 0x0e0c0a08, 0x1b1a1918, 0x0000000c, 0x19191806, 0x0a2c0b2c, 0x1c01010b, 0x00000006, 
    0x00000000, 0x00000000, 0x000b002f, 0x000a002f, 0x0000000b, 0x00000001, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0b0702, 0x211d1814, 0x332e2a25, 0x00b5b529, 0x00bd0011, 0x000000bd, 
    0x07050301, 0x180d0b09, 0x1c1b1a19, 0x0000000f, 0x1a1a1906, 0x0b2d0c2d, 0x1d01010c, 0x00000006, 
    0x00000000, 0x00000000, 0x000c0035, 0x000b0035, 0x0000000c, 0x00000001, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0b0702, 0x211d1814, 0x332e2a25, 0x00b5b529, 0x00d40013, 0x000000d4, 
    0x08060301, 0x190f0d0a, 0x1e1d1b1a, 0x00000013, 0x1b1b1b07, 0x0c2f0d2f, 0x1f02020d, 0x00000007, 
    0x00000000, 0x00000000, 0x000d003b, 0x000c003b, 0x0000000d, 0x00000002, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0b0702, 0x211d1814, 0x332e2a25, 0x00b5b529, 0x00ee0016, 0x000000ee, 
    0x09060401, 0x1a190e0c, 0x281e1d1b, 0x00000018, 0x1c1c1c08, 0x0e380f38, 0x2802020f, 0x00000008, 
    0x00000000, 0x00000000, 0x000f0043, 0x000e0043, 0x0000000f, 0x00000002, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0b0702, 0x211d1814, 0x332e2a25, 0x00b5b529, 0x010b0019, 0x0000010b, 
    0x0a070401, 0x1b1a180d, 0x29281e1d, 0x0000001e, 0x1e1d1d09, 0x18391939, 0x29020219, 0x00000009, 
    0x00000000, 0x00000000, 0x0011004b, 0x0010004b, 0x00000011, 0x00000002, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0b0702, 0x211d1814, 0x332e2a25, 0x00b5b529, 0x012c001c, 0x0000012c, 
    0x0b080501, 0x1d1b190f, 0x2a29281e, 0x00000026, 0x1f1f1f0a, 0x193b1a3b, 0x2a03031a, 0x0000000a, 
    0x00000000, 0x00000000, 0x00130054, 0x00120054, 0x00000013, 0x00000003, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0b0702, 0x211d1814, 0x332e2a25, 0x00b5b529, 0x0151001f, 0x00000151, 
    0x0d090501, 0x1e1c1a19, 0x2b2a2928, 0x00000030, 0x2929280c, 0x1a3c1b3c, 0x2c03031b, 0x0000000c, 
    0x00000000, 0x00000000, 0x0016005e, 0x0014005f, 0x00000016, 0x00000003, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0b0702, 0x211d1814, 0x332e2a25, 0x00b5b529, 0x017a0023, 0x0000017a, 
    0x0e0a0602, 0x281e1c1a, 0x2c2b2a29, 0x0000003d, 0x2a2a290d, 0x1c3d1c3d, 0x2d03031c, 0x0000000d, 
    0x00000000, 0x00000000, 0x0018006a, 0x0017006a, 0x00000018, 0x00000003, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0b0702, 0x211d1814, 0x332e2a25, 0x00b5b529, 0x01a80027, 0x000001a8, 
    0x180c0702, 0x29281d1b, 0x2e2d2b2a, 0x0000004c, 0x2b2b2b0f, 0x1d3f1e3f, 0x2f04041e, 0x0000000f, 
    0x00000000, 0x00000000, 0x001b0077, 0x00190077, 0x0000001b, 0x00000004, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0b0702, 0x211d1814, 0x332e2a25, 0x00b5b529, 0x01dc002c, 0x000001dc, 
    0x190d0802, 0x2a291f1c, 0x382e2d2b, 0x00000060, 0x2c2c2c19, 0x1e482848, 0x38040428, 0x00000019, 
    0x00000000, 0x00000000, 0x001f0086, 0x001c0086, 0x0000001f, 0x00000004, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0b0702, 0x211d1814, 0x332e2a25, 0x00b5b529, 0x02170032, 0x00000217, 
    0x1b0f0903, 0x2b2a281e, 0x39382e2d, 0x00000079, 0x2e2d2d1a, 0x28492949, 0x39050529, 0x0000001a, 
    0x00000000, 0x00000000, 0x00230096, 0x00200097, 0x00000023, 0x00000005, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0b0702, 0x211d1814, 0x332e2a25, 0x00b5b529, 0x02580038, 0x00000258, 
    0x1c180a03, 0x2d2b291f, 0x3a39382e, 0x00000099, 0x2f2f2f1b, 0x294b2a4b, 0x3a06062a, 0x0000001b, 
    0x00000000, 0x00000000, 0x002700a9, 0x002400a9, 0x00000027, 0x00000006, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0b0702, 0x211d1814, 0x332e2a25, 0x00b5b529, 0x02a2003f, 0x000002a2, 
    0x1d1a0b03, 0x2e2c2a29, 0x3b3a3938, 0x000000c0, 0x3939381c, 0x2a4c2b4c, 0x3c06062b, 0x0000001c, 
    0x00000000, 0x00000000, 0x002c00bd, 0x002900be, 0x0000002c, 0x00000006, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0b0702, 0x211d1814, 0x332e2a25, 0x00b5b529, 0x02f50047, 0x000002f5, 
    0x1f1b0c04, 0x382e2c2a, 0x3c3b3a39, 0x000000f2, 0x3a3a391e, 0x2c4d2c4d, 0x3d07072c, 0x0000001e, 
    0x00000000, 0x00000000, 0x003100d5, 0x002e00d5, 0x00000031, 0x00000007, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0b0702, 0x211d1814, 0x332e2a25, 0x00b5b529, 0x0351004f, 0x00000351, 
    0x281c0e04, 0x39382d2b, 0x3e3d3b3a, 0x00000131, 0x3b3b3b1f, 0x2d4f2e4f, 0x3f08082e, 0x0000001f, 
    0x00000000, 0x00000000, 0x003700ef, 0x003300ef, 0x00000037, 0x00000008, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0b0702, 0x211d1814, 0x332e2a25, 0x00b5b529, 0x03b90059, 0x000003b9, 
    0x291d1805, 0x3a392f2c, 0x483e3d3b, 0x00000181, 0x3c3c3c29, 0x2e583858, 0x48090938, 0x00000029, 
    0x00000000, 0x00000000, 0x003e010c, 0x0039010d, 0x0000003e, 0x00000009, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0b0702, 0x211d1814, 0x332e2a25, 0x00b5b529, 0x042e0064, 0x0000042e, 
    0x2b1f1906, 0x3b3a382e, 0x49483e3d, 0x000001e5, 0x3e3d3d2a, 0x38593959, 0x490b0b39, 0x0000002a, 
    0x00000000, 0x00000000, 0x0046012d, 0x0041012e, 0x00000046, 0x0000000b, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0b0702, 0x211d1814, 0x332e2a25, 0x00b5b529, 0x04b10070, 0x000004b1, 
    0x2c281a06, 0x3d3b392f, 0x4a49483e, 0x00000263, 0x3f3f3f2b, 0x395b3a5b, 0x4a0c0c3a, 0x0000002b, 
    0x00000000, 0x00000000, 0x004f0152, 0x00490153, 0x0000004e, 0x0000000c, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0b0702, 0x211d1814, 0x332e2a25, 0x00b5b529, 0x0545007e, 0x00000545, 
    0x2d2a1b07, 0x3e3c3a39, 0x4b4a4948, 0x00000301, 0x4949482c, 0x3a5c3b5c, 0x4c0d0d3b, 0x0000002c, 
    0x00000000, 0x00000000, 0x0058017b, 0x0052017c, 0x00000058, 0x0000000d, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0b0702, 0x211d1814, 0x332e2a25, 0x00b5b529, 0x05ea008e, 0x000005ea, 
    0x2f2b1d08, 0x483e3c3a, 0x4c4b4a49, 0x000003c9, 0x4a4a492e, 0x3c5d3c5d, 0x4d0f0f3c, 0x0000002e, 
    0x00000000, 0x00000000, 0x006301aa, 0x005c01ab, 0x00000063, 0x0000000f, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0b0702, 0x211d1814, 0x332e2a25, 0x00b5b529, 0x06a3009f, 0x000006a3, 
    0x382c1e09, 0x49483d3b, 0x4e4d4b4a, 0x000004c5, 0x4b4b4b2f, 0x3d5f3e5f, 0x4f19193e, 0x0000002f, 
    0x00000000, 0x00000000, 0x006f01de, 0x006701df, 0x0000006f, 0x00000011, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0b0702, 0x211d1814, 0x332e2a25, 0x00b5b529, 0x077300b3, 0x00000773, 
    0x392d280a, 0x4a493f3c, 0x584e4d4b, 0x00000602, 0x4c4c4c39, 0x3e684868, 0x581a1a48, 0x00000039, 
    0x00000000, 0x00000000, 0x007d0218, 0x0073021a, 0x0000007d, 0x00000013, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0b0702, 0x211d1814, 0x332e2a25, 0x00b5b529, 0x085d00c9, 0x0000085d, 
    0x3b2f290c, 0x4b4a483e, 0x59584e4d, 0x00000792, 0x4e4d4d3a, 0x48694969, 0x591b1b49, 0x0000003a, 
    0x00000000, 0x00000000, 0x008c025a, 0x0082025c, 0x0000008c, 0x00000016, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0b0702, 0x211d1814, 0x332e2a25, 0x00b5b529, 0x096300e1, 0x00000963, 
    0x3c382a0d, 0x4d4b493f, 0x5a59584e, 0x0000098a, 0x4f4f4f3b, 0x496b4a6b, 0x5a1c1c4a, 0x0000003b, 
    0x00000000, 0x00000000, 0x009e02a4, 0x009202a6, 0x0000009d, 0x00000018, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0b0702, 0x211d1814, 0x332e2a25, 0x00b5b529, 0x0a8a00fd, 0x00000a8a, 
    0x3d3a2b0f, 0x4e4c4a49, 0x5b5a5958, 0x00000c05, 0x5959583c, 0x4a6c4b6c, 0x5c1e1e4b, 0x0000003c, 
    0x00000000, 0x00000000, 0x00b102f7, 0x00a402f9, 0x000000b0, 0x0000001b, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0b0702, 0x211d1814, 0x332e2a25, 0x00b5b529, 0x0bd4011c, 0x00000bd4, 
    0x3f3b2d19, 0x584e4c4a, 0x5c5b5a59, 0x00000f24, 0x5a5a593e, 0x4c6d4c6d, 0x5d28284c, 0x0000003e, 
    0x00000000, 0x00000000, 0x00c70354, 0x00b80357, 0x000000c6, 0x0000001f, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0b0702, 0x211d1814, 0x332e2a25, 0x00b5b529, 0x0d47013f, 0x00000d47, 
    0x483c2e1a, 0x59584d4b, 0x5e5d5b5a, 0x00001314, 0x5b5b5b3f, 0x4d6f4e6f, 0x5f29294e, 0x0000003f, 
    0x00000000, 0x00000000, 0x00df03bc, 0x00ce03bf, 0x000000de, 0x00000022, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0b0702, 0x211d1814, 0x332e2a25, 0x00b5b529, 0x0ee70166, 0x00000ee7, 
    0x493d381b, 0x5a594f4c, 0x685e5d5b, 0x00001809, 0x5c5c5c49, 0x4e785878, 0x682a2a58, 0x00000049, 
    0x00000000, 0x00000000, 0x00fb0431, 0x00e70435, 0x000000fa, 0x00000027, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0b0702, 0x211d1814, 0x332e2a25, 0x00b5b529, 0x10bb0192, 0x000010bb, 
    0x4b3f391c, 0x5b5a584e, 0x69685e5d, 0x00001e49, 0x5e5d5d4a, 0x58795979, 0x692b2b59, 0x0000004a, 
    0x00000000, 0x00000000, 0x011904b5, 0x010404b9, 0x00000118, 0x0000002c, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0b0702, 0x211d1814, 0x332e2a25, 0x00b5b529, 0x12c701c3, 0x000012c7, 
    0x4c483a1e, 0x5d5b594f, 0x6a69685e, 0x00002628, 0x5f5f5f4b, 0x597b5a7b, 0x6a2c2c5a, 0x0000004b, 
    0x00000000, 0x00000000, 0x013c0548, 0x0124054d, 0x0000013b, 0x00000031, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0b0702, 0x211d1814, 0x332e2a25, 0x00b5b529, 0x151401fa, 0x00001514, 
    0x4d4a3b1f, 0x5e5c5a59, 0x6b6a6968, 0x00003013, 0x6969684c, 0x5a7c5b7c, 0x6c2e2e5b, 0x0000004c, 
    0x00000000, 0x00000000, 0x016305ee, 0x014805f3, 0x00000161, 0x00000037, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0b0702, 0x211d1814, 0x332e2a25, 0x00b5b529, 0x17a90238, 0x000017a9, 
    0x4f4b3d29, 0x685e5c5a, 0x6c6b6a69, 0x00003c92, 0x6a6a694e, 0x5c7d5c7d, 0x6d38385c, 0x0000004e, 
    0x00000000, 0x00000000, 0x018e06a8, 0x017006ae, 0x0000018c, 0x0000003e, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0b0702, 0x211d1814, 0x332e2a25, 0x00b5b529, 0x1a8e027e, 0x00001a8e, 
    0x584c3e2a, 0x69685d5b, 0x6e6d6b6a, 0x00004c50, 0x6b6b6b4f, 0x5d7f5e7f, 0x6f39395e, 0x0000004f, 
    0x00000000, 0x00000000, 0x01bf0779, 0x019d077f, 0x000001bd, 0x00000045, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0b0702, 0x211d1814, 0x332e2a25, 0x00b5b529, 0x1dcf02cc, 0x00001dcf, 
    0x594d482b, 0x6a695f5c, 0x6f6e6d6b, 0x00006026, 0x6c6c6c59, 0x5e886888, 0x783a3a68, 0x00000059, 
    0x00000000, 0x00000000, 0x01f60863, 0x01cf086a, 0x000001f4, 0x0000004e, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0b0702, 0x211d1814, 0x332e2a25, 0x00b5b529, 0x21760324, 0x00002176, 
    0x5b4f492c, 0x6b6a685e, 0x6f6f6e6d, 0x00007924, 0x6e6d6d5a, 0x68896989, 0x793b3b69, 0x0000005a, 
    0x00000000, 0x00000000, 0x0233096a, 0x02080972, 0x00000231, 0x00000058, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0b0702, 0x211d1814, 0x332e2a25, 0x00b5b529, 0x258f0386, 0x0000258f, 
    0x5c584a2e, 0x6d6b695f, 0x6f6f6f6e, 0x000098a0, 0x6f6f6f5b, 0x698b6a8b, 0x7a3c3c6a, 0x0000005b, 
    0x00000000, 0x00000000, 0x02790a91, 0x02480a9a, 0x00000276, 0x00000062, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0b0702, 0x211d1814, 0x332e2a25, 0x00b5b529, 0x2a2803f5, 0x00002a28, 
    0x5d5a4b2f, 0x6e6c6a69, 0x6f6f6f6f, 0x0000c04c, 0x7979785c, 0x6a8c6b8c, 0x7c3e3e6b, 0x0000005c, 
    0x00000000, 0x00000000, 0x02c60bdc, 0x02900be6, 0x000002c3, 0x0000006e, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0b0702, 0x211d1814, 0x332e2a25, 0x00b5b529, 0x2f520471, 0x00002f52, 
    0x5f5b4d39, 0x6f6e6c6a, 0x6f6f6f6f, 0x0000f247, 0x7a7a795e, 0x6c8d6c8d, 0x7d48486c, 0x0000005e, 
    0x00000000, 0x00000000, 0x031d0d50, 0x02e00d5c, 0x00000319, 0x0000007c, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0b0702, 0x211d1814, 0x332e2a25, 0x00b5b529, 0x351d04fc, 0x0000351d, 
    0x685c4e3a, 0x6f6f6d6b, 0x6f6f6f6f, 0x00003140, 0x7b7b7b5f, 0x6d8f6e8f, 0x7f49496e, 0x0000005f, 
    0x00000000, 0x00000000, 0x037f0ef2, 0x033a0efe, 0x0000037b, 0x0000008b, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0b0702, 0x211d1814, 0x332e2a25, 0x00b5b529, 0x3b9f0598, 0x00003b9f, 
    0x695d583b, 0x6f6f6f6c, 0x6f6f6f6f, 0x00008098, 0x7c7c7c69, 0x6e8f788f, 0x884a4a78, 0x00000069, 
    0x00000000, 0x00000000, 0x03ec10c6, 0x039f10d4, 0x000003e8, 0x0000009c, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0b0702, 0x211d1814, 0x332e2a25, 0x00b5b529, 0x42ec0648, 0x000042ec, 
    0x6b5f593c, 0x6f6f6f6e, 0x6f6f6f6f, 0x0000e48f, 0x7e7d7d6a, 0x788f798f, 0x894b4b79, 0x0000006a, 
    0x00000000, 0x00000000, 0x046712d4, 0x041112e4, 0x00000462, 0x000000b0, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0b0702, 0x211d1814, 0x332e2a25, 0x00b5b529, 0x4b1e070d, 0x00004b1e, 
    0x6c685a3e, 0x6f6f6f6f, 0x6f6f6f6f, 0x00006281, 0x7f7f7f6b, 0x798f7a8f, 0x8a4c4c7a, 0x0000006b, 
    0x00000000, 0x00000000, 0x04f21523, 0x04911534, 0x000004ec, 0x000000c5, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0b0702, 0x211d1814, 0x332e2a25, 0x00b5b529, 0x545107ea, 0x00005451, 
    0x6d6a5b3f, 0x6f6f6f6f, 0x6f6f6f6f, 0x00000130, 0x8989886c, 0x7a8f7b8f, 0x8c4e4e7b, 0x0000006c, 
    0x00000000, 0x00000000, 0x058d17b9, 0x052017cd, 0x00000586, 0x000000dd, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0b0702, 0x211d1814, 0x332e2a25, 0x00b5b529, 0x5ea408e2, 0x00005ea4, 
    0x6f6b5d49, 0x6f6f6f6f, 0x6f6f6f6f, 0x0000c91d, 0x8a8a896e, 0x7c8f7c8f, 0x8d58587c, 0x0000006e, 
    0x00000000, 0x00000000, 0x063b1aa1, 0x05c11ab8, 0x00000633, 0x000000f9, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0b0702, 0x211d1814, 0x332e2a25, 0x00b5b529, 0x6a3b09f8, 0x00006a3b, 
    0x6f6c5e4a, 0x6f6f6f6f, 0x6f6f6f6f, 0x0000c502, 0x8b8b8b6f, 0x7d8f7e8f, 0x8f59597e, 0x0000006f, 
    0x00000000, 0x00000000, 0x06fe1de4, 0x06751dfd, 0x000006f6, 0x00000117, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0b0702, 0x211d1814, 0x332e2a25, 0x00b5b529, 0x773e0b31, 0x0000773e, 
    0x6f6d684b, 0x6f6f6f6f, 0x6f6f6f6f, 0x0000025f, 0x8c8c8c79, 0x7e8f888f, 0x8f5a5a88, 0x00000079, 
    0x00000000, 0x00000000, 0x07d9218d, 0x073f21a9, 0x000007d0, 0x00000139, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0b0702, 0x211d1814, 0x332e2a25, 0x00b5b529, 0x85d80c90, 0x000085d8, 
    0x6f6f694c, 0x6f6f6f6f, 0x6f6f6f6f, 0x0000923a, 0x8e8d8d7a, 0x888f898f, 0x8f5b5b89, 0x0000007a, 
    0x00000000, 0x00000000, 0x08cf25a9, 0x082325c9, 0x000008c5, 0x00000160, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0b0702, 0x211d1814, 0x332e2a25, 0x00b5b529, 0x963c0e1a, 0x0000963c, 
    0x03020100, 0x06050504, 0x0a090807, 0x00000003, 0x08080803, 0x051c051c, 0x0b000005, 0x00000003, 
    0x00000000, 0x00000000, 0x00050017, 0x00050017, 0x00000005, 0x00000000, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0a0602, 0x1f1b1713, 0x302c2824, 0x00b5b529, 0x005f0008, 0x0000005f, 
    0x03020100, 0x06050504, 0x0a090807, 0x00000003, 0x08080803, 0x051c051c, 0x0b000005, 0x00000003, 
    0x00000000, 0x00000000, 0x00050017, 0x00050017, 0x00000005, 0x00000000, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0a0602, 0x1f1b1713, 0x302c2824, 0x00b5b529, 0x005f0008, 0x0000005f, 
    0x03020100, 0x06050504, 0x0a090807, 0x00000003, 0x08080803, 0x051c051c, 0x0b000005, 0x00000003, 
    0x00000000, 0x00000000, 0x00050017, 0x00050017, 0x00000005, 0x00000000, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0a0602, 0x1f1b1713, 0x302c2824, 0x00b5b529, 0x005f0008, 0x0000005f, 
    0x03020100, 0x06050504, 0x0a090807, 0x00000003, 0x08080803, 0x051c051c, 0x0b000005, 0x00000003, 
    0x00000000, 0x00000000, 0x00050017, 0x00050017, 0x00000005, 0x00000000, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0a0602, 0x1f1b1713, 0x302c2824, 0x00b5b529, 0x005f0008, 0x0000005f, 
    0x03020100, 0x06050504, 0x0a090807, 0x00000003, 0x08080803, 0x051c051c, 0x0b000005, 0x00000003, 
    0x00000000, 0x00000000, 0x00050017, 0x00050017, 0x00000005, 0x00000000, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0a0602, 0x1f1b1713, 0x302c2824, 0x00b5b529, 0x005f0008, 0x0000005f, 
    0x03020100, 0x06050504, 0x0a090807, 0x00000003, 0x08080803, 0x051c051c, 0x0b000005, 0x00000003, 
    0x00000000, 0x00000000, 0x00050017, 0x00050017, 0x00000005, 0x00000000, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0a0602, 0x1f1b1713, 0x302c2824, 0x00b5b529, 0x005f0008, 0x0000005f, 
    0x03020100, 0x06050504, 0x0a090807, 0x00000003, 0x08080803, 0x051c051c, 0x0b000005, 0x00000003, 
    0x00000000, 0x00000000, 0x00050017, 0x00050017, 0x00000005, 0x00000000, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0a0602, 0x1f1b1713, 0x302c2824, 0x00b5b529, 0x005f0008, 0x0000005f, 
    0x03020100, 0x06050504, 0x0a090807, 0x00000003, 0x08080803, 0x051c051c, 0x0b000005, 0x00000003, 
    0x00000000, 0x00000000, 0x00050017, 0x00050017, 0x00000005, 0x00000000, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0a0602, 0x1f1b1713, 0x302c2824, 0x00b5b529, 0x005f0008, 0x0000005f, 
    0x03020100, 0x06050504, 0x0a090807, 0x00000003, 0x08080803, 0x051c051c, 0x0b000005, 0x00000003, 
    0x00000000, 0x00000000, 0x00050017, 0x00050017, 0x00000005, 0x00000000, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0a0602, 0x1f1b1713, 0x302c2824, 0x00b5b529, 0x005f0008, 0x0000005f, 
    0x03020100, 0x06050504, 0x0a090807, 0x00000003, 0x08080803, 0x051c051c, 0x0b000005, 0x00000003, 
    0x00000000, 0x00000000, 0x00050017, 0x00050017, 0x00000005, 0x00000000, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0a0602, 0x1f1b1713, 0x302c2824, 0x00b5b529, 0x005f0008, 0x0000005f, 
    0x03020100, 0x06050504, 0x0a090807, 0x00000003, 0x08080803, 0x051c051c, 0x0b000005, 0x00000003, 
    0x00000000, 0x00000000, 0x00050017, 0x00050017, 0x00000005, 0x00000000, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0a0602, 0x1f1b1713, 0x302c2824, 0x00b5b529, 0x005f0008, 0x0000005f, 
    0x03020100, 0x06050504, 0x0a090807, 0x00000003, 0x08080803, 0x051c051c, 0x0b000005, 0x00000003, 
    0x00000000, 0x00000000, 0x00050017, 0x00050017, 0x00000005, 0x00000000, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0a0602, 0x1f1b1713, 0x302c2824, 0x00b5b529, 0x005f0008, 0x0000005f, 
    0x03020100, 0x06050504, 0x0a090807, 0x00000003, 0x08080803, 0x051c051c, 0x0b000005, 0x00000003, 
    0x00000000, 0x00000000, 0x00050017, 0x00050017, 0x00000005, 0x00000000, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0a0602, 0x1f1b1713, 0x302c2824, 0x00b5b529, 0x005f0008, 0x0000005f, 
    0x03020100, 0x07060504, 0x0b0a0908, 0x00000004, 0x09090903, 0x051d061d, 0x0d000006, 0x00000003, 
    0x00000000, 0x00000000, 0x0006001a, 0x0005001a, 0x00000006, 0x00000000, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0a0602, 0x1f1b1713, 0x302c2824, 0x00b5b529, 0x006a000a, 0x0000006a, 
    0x04020100, 0x08070605, 0x0d0c0a09, 0x00000005, 0x0a0a0a03, 0x061f071f, 0x0e010107, 0x00000003, 
    0x00000000, 0x00000000, 0x0007001e, 0x0006001e, 0x00000007, 0x00000001, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0a0602, 0x1f1b1713, 0x302c2824, 0x00b5b529, 0x0077000b, 0x00000077, 
    0x04030100, 0x09080705, 0x0e0d0c0a, 0x00000006, 0x0c0c0c04, 0x07280728, 0x18010107, 0x00000004, 
    0x00000000, 0x00000000, 0x00070021, 0x00070021, 0x00000007, 0x00000001, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0a0602, 0x1f1b1713, 0x302c2824, 0x00b5b529, 0x0086000c, 0x00000086, 
    0x05030200, 0x0a090706, 0x180f0d0c, 0x00000008, 0x0d0d0d04, 0x082a0829, 0x19010108, 0x00000004, 
    0x00000000, 0x00000000, 0x00080025, 0x00080026, 0x00000008, 0x00000001, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0a0602, 0x1f1b1713, 0x302c2824, 0x00b5b529, 0x0097000e, 0x00000097, 
    0x05040200, 0x0c0a0807, 0x19190f0d, 0x0000000a, 0x0f0f0f05, 0x092b092b, 0x1a010109, 0x00000005, 
    0x00000000, 0x00000000, 0x0009002a, 0x0009002a, 0x00000009, 0x00000001, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0a0602, 0x1f1b1713, 0x302c2824, 0x00b5b529, 0x00a9000f, 0x000000a9, 
    0x06040200, 0x0d0b0a08, 0x1a1a190f, 0x0000000c, 0x19191906, 0x0a2c0b2c, 0x1c01010b, 0x00000006, 
    0x00000000, 0x00000000, 0x000b002f, 0x000a002f, 0x0000000b, 0x00000001, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0a0602, 0x1f1b1713, 0x302c2824, 0x00b5b529, 0x00be0011, 0x000000be, 
    0x07050301, 0x0f0d0b09, 0x1c1b1a19, 0x0000000f, 0x1a1a1a06, 0x0b2d0c2d, 0x1d01010c, 0x00000006, 
    0x00000000, 0x00000000, 0x000c0035, 0x000b0035, 0x0000000c, 0x00000001, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0a0602, 0x1f1b1713, 0x302c2824, 0x00b5b529, 0x00d50014, 0x000000d5, 
    0x08050301, 0x190e0c0a, 0x1d1c1b1a, 0x00000013, 0x1b1b1b07, 0x0c2f0e2f, 0x1f02020e, 0x00000007, 
    0x00000000, 0x00000000, 0x000e003c, 0x000c003c, 0x0000000e, 0x00000002, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0a0602, 0x1f1b1713, 0x302c2824, 0x00b5b529, 0x00ef0016, 0x000000ef, 
    0x09060301, 0x1a180e0b, 0x1f1e1c1b, 0x00000018, 0x1c1c1c08, 0x0e380f38, 0x2802020f, 0x00000008, 
    0x00000000, 0x00000000, 0x000f0043, 0x000e0043, 0x0000000f, 0x00000002, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0a0602, 0x1f1b1713, 0x302c2824, 0x00b5b529, 0x010d0019, 0x0000010d, 
    0x0a070401, 0x1b190f0d, 0x281f1e1c, 0x0000001f, 0x1e1e1d09, 0x183a1939, 0x29020219, 0x00000009, 
    0x00000000, 0x00000000, 0x0011004b, 0x0010004c, 0x00000011, 0x00000002, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0a0602, 0x1f1b1713, 0x302c2824, 0x00b5b529, 0x012e001c, 0x0000012e, 
    0x0b080401, 0x1c1b190e, 0x29291f1e, 0x00000027, 0x1f1f1f0a, 0x193b1a3b, 0x2a03031a, 0x0000000a, 
    0x00000000, 0x00000000, 0x00130055, 0x00120055, 0x00000013, 0x00000003, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0a0602, 0x1f1b1713, 0x302c2824, 0x00b5b529, 0x0153001f, 0x00000153, 
    0x0c090501, 0x1e1c1a18, 0x2a2a291f, 0x00000031, 0x2929290c, 0x1a3c1b3c, 0x2c03031b, 0x0000000c, 
    0x00000000, 0x00000000, 0x0016005f, 0x0014005f, 0x00000016, 0x00000003, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0a0602, 0x1f1b1713, 0x302c2824, 0x00b5b529, 0x017c0023, 0x0000017c, 
    0x0e0a0602, 0x1f1d1b19, 0x2c2b2a29, 0x0000003d, 0x2a2a2a0d, 0x1c3d1d3d, 0x2d03031c, 0x0000000d, 
    0x00000000, 0x00000000, 0x0019006b, 0x0017006b, 0x00000018, 0x00000003, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0a0602, 0x1f1b1713, 0x302c2824, 0x00b5b529, 0x01ab0028, 0x000001ab, 
    0x180b0602, 0x291f1d1a, 0x2d2c2b2a, 0x0000004d, 0x2b2b2b0f, 0x1d3f1e3f, 0x2f04041e, 0x0000000f, 
    0x00000000, 0x00000000, 0x001c0078, 0x00190078, 0x0000001c, 0x00000004, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0a0602, 0x1f1b1713, 0x302c2824, 0x00b5b529, 0x01df002d, 0x000001df, 
    0x190c0702, 0x2a281e1c, 0x2f2e2c2b, 0x00000061, 0x2c2c2c19, 0x1f482848, 0x38040428, 0x00000019, 
    0x00000000, 0x00000000, 0x001f0087, 0x001d0087, 0x0000001f, 0x00000004, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0a0602, 0x1f1b1713, 0x302c2824, 0x00b5b529, 0x021a0032, 0x0000021a, 
    0x1a0e0802, 0x2b29281d, 0x382f2e2c, 0x0000007b, 0x2e2e2d1a, 0x284a2949, 0x39050529, 0x0000001a, 
    0x00000000, 0x00000000, 0x00230097, 0x00200098, 0x00000023, 0x00000005, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0a0602, 0x1f1b1713, 0x302c2824, 0x00b5b529, 0x025c0038, 0x0000025c, 
    0x1b180903, 0x2c2b291f, 0x39392f2e, 0x0000009b, 0x2f2f2f1b, 0x294b2a4b, 0x3a06062a, 0x0000001b, 
    0x00000000, 0x00000000, 0x002700aa, 0x002400aa, 0x00000027, 0x00000006, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0a0602, 0x1f1b1713, 0x302c2824, 0x00b5b529, 0x02a6003f, 0x000002a6, 
    0x1d190a03, 0x2e2c2a28, 0x3a3a392f, 0x000000c3, 0x3939391c, 0x2a4c2b4c, 0x3c06062b, 0x0000001c, 
    0x00000000, 0x00000000, 0x002c00be, 0x002900bf, 0x0000002c, 0x00000006, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0a0602, 0x1f1b1713, 0x302c2824, 0x00b5b529, 0x02f90047, 0x000002f9, 
    0x1e1a0c04, 0x2f2d2b29, 0x3c3b3a39, 0x000000f5, 0x3a3a3a1e, 0x2c4d2d4d, 0x3d07072c, 0x0000001e, 
    0x00000000, 0x00000000, 0x003200d6, 0x002e00d7, 0x00000031, 0x00000007, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0a0602, 0x1f1b1713, 0x302c2824, 0x00b5b529, 0x03570050, 0x00000357, 
    0x281b0d04, 0x392f2d2a, 0x3d3c3b3a, 0x00000135, 0x3b3b3b1f, 0x2d4f2e4f, 0x3f08082e, 0x0000001f, 
    0x00000000, 0x00000000, 0x003800f0, 0x003300f1, 0x00000038, 0x00000008, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0a0602, 0x1f1b1713, 0x302c2824, 0x00b5b529, 0x03bf005a, 0x000003bf, 
    0x291d0f05, 0x3a382e2c, 0x3f3e3c3b, 0x00000185, 0x3c3c3c29, 0x2f583858, 0x48090938, 0x00000029, 
    0x00000000, 0x00000000, 0x003f010e, 0x003a010e, 0x0000003e, 0x00000009, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0a0602, 0x1f1b1713, 0x302c2824, 0x00b5b529, 0x04350065, 0x00000435, 
    0x2a1e1905, 0x3b39382d, 0x483f3e3c, 0x000001eb, 0x3e3e3d2a, 0x385a3959, 0x490b0b39, 0x0000002a, 
    0x00000000, 0x00000000, 0x0046012f, 0x00410130, 0x00000046, 0x0000000b, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0a0602, 0x1f1b1713, 0x302c2824, 0x00b5b529, 0x04b90071, 0x000004b9, 
    0x2b281a06, 0x3c3b392f, 0x49493f3e, 0x0000026a, 0x3f3f3f2b, 0x395b3a5b, 0x4a0c0c3a, 0x0000002b, 
    0x00000000, 0x00000000, 0x004f0154, 0x00490155, 0x0000004f, 0x0000000c, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0a0602, 0x1f1b1713, 0x302c2824, 0x00b5b529, 0x054d007f, 0x0000054d, 
    0x2d291b07, 0x3e3c3a38, 0x4a4a493f, 0x0000030b, 0x4949492c, 0x3a5c3b5c, 0x4c0d0d3b, 0x0000002c, 
    0x00000000, 0x00000000, 0x0059017d, 0x0052017f, 0x00000058, 0x0000000d, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0a0602, 0x1f1b1713, 0x302c2824, 0x00b5b529, 0x05f3008f, 0x000005f3, 
    0x2e2a1c08, 0x3f3d3b39, 0x4c4b4a49, 0x000003d5, 0x4a4a4a2e, 0x3c5d3d5d, 0x4d0f0f3c, 0x0000002e, 
    0x00000000, 0x00000000, 0x006401ac, 0x005c01ae, 0x00000063, 0x0000000f, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0a0602, 0x1f1b1713, 0x302c2824, 0x00b5b529, 0x06ae00a0, 0x000006ae, 
    0x382b1e09, 0x493f3d3a, 0x4d4c4b4a, 0x000004d4, 0x4b4b4b2f, 0x3d5f3e5f, 0x4f19193e, 0x0000002f, 
    0x00000000, 0x00000000, 0x007001e1, 0x006701e2, 0x00000070, 0x00000011, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0a0602, 0x1f1b1713, 0x302c2824, 0x00b5b529, 0x077f00b4, 0x0000077f, 
    0x392d1f0a, 0x4a483e3c, 0x4f4e4c4b, 0x00000616, 0x4c4c4c39, 0x3f684868, 0x581a1a48, 0x00000039, 
    0x00000000, 0x00000000, 0x007e021c, 0x0074021d, 0x0000007d, 0x00000013, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0a0602, 0x1f1b1713, 0x302c2824, 0x00b5b529, 0x086a00ca, 0x0000086a, 
    0x3a2e290b, 0x4b49483d, 0x584f4e4c, 0x000007aa, 0x4e4e4d3a, 0x486a4969, 0x591b1b49, 0x0000003a, 
    0x00000000, 0x00000000, 0x008d025e, 0x00830260, 0x0000008d, 0x00000016, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0a0602, 0x1f1b1713, 0x302c2824, 0x00b5b529, 0x097200e3, 0x00000972, 
    0x3b382a0c, 0x4c4b493f, 0x59594f4e, 0x000009a8, 0x4f4f4f3b, 0x496b4a6b, 0x5a1c1c4a, 0x0000003b, 
    0x00000000, 0x00000000, 0x009f02a8, 0x009302aa, 0x0000009e, 0x00000018, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0a0602, 0x1f1b1713, 0x302c2824, 0x00b5b529, 0x0a9a00fe, 0x00000a9a, 
    0x3d392b0e, 0x4e4c4a48, 0x5a5a594f, 0x00000c2b, 0x5959593c, 0x4a6c4b6c, 0x5c1e1e4b, 0x0000003c, 
    0x00000000, 0x00000000, 0x00b202fb, 0x00a502fe, 0x000000b1, 0x0000001b, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0a0602, 0x1f1b1713, 0x302c2824, 0x00b5b529, 0x0be7011e, 0x00000be7, 
    0x3e3a2c18, 0x4f4d4b49, 0x5c5b5a59, 0x00000f55, 0x5a5a5a3e, 0x4c6d4d6d, 0x5d28284c, 0x0000003e, 
    0x00000000, 0x00000000, 0x00c80359, 0x00b9035c, 0x000000c7, 0x0000001f, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0a0602, 0x1f1b1713, 0x302c2824, 0x00b5b529, 0x0d5c0141, 0x00000d5c, 
    0x483b2e19, 0x594f4d4a, 0x5d5c5b5a, 0x00001351, 0x5b5b5b3f, 0x4d6f4e6f, 0x5f29294e, 0x0000003f, 
    0x00000000, 0x00000000, 0x00e103c2, 0x00cf03c5, 0x000000e0, 0x00000023, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0a0602, 0x1f1b1713, 0x302c2824, 0x00b5b529, 0x0eff0168, 0x00000eff, 
    0x493d2f1a, 0x5a584e4c, 0x5f5e5c5b, 0x00001856, 0x5c5c5c49, 0x4f785878, 0x682a2a58, 0x00000049, 
    0x00000000, 0x00000000, 0x00fc0438, 0x00e9043b, 0x000000fb, 0x00000027, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0a0602, 0x1f1b1713, 0x302c2824, 0x00b5b529, 0x10d50194, 0x000010d5, 
    0x4a3e391c, 0x5b59584d, 0x685f5e5c, 0x00001ea9, 0x5e5e5d4a, 0x587a5979, 0x692b2b59, 0x0000004a, 
    0x00000000, 0x00000000, 0x011b04bc, 0x010604c0, 0x0000011a, 0x0000002c, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0a0602, 0x1f1b1713, 0x302c2824, 0x00b5b529, 0x12e501c6, 0x000012e5, 
    0x4b483a1d, 0x5c5b594f, 0x69695f5e, 0x000026a2, 0x5f5f5f4b, 0x597b5a7b, 0x6a2c2c5a, 0x0000004b, 
    0x00000000, 0x00000000, 0x013e0551, 0x01260555, 0x0000013c, 0x00000031, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0a0602, 0x1f1b1713, 0x302c2824, 0x00b5b529, 0x153501fd, 0x00001535, 
    0x4d493b1f, 0x5e5c5a58, 0x6a6a695f, 0x000030ac, 0x6969694c, 0x5a7c5b7c, 0x6c2e2e5b, 0x0000004c, 
    0x00000000, 0x00000000, 0x016505f7, 0x014a05fc, 0x00000163, 0x00000037, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0a0602, 0x1f1b1713, 0x302c2824, 0x00b5b529, 0x17ce023c, 0x000017ce, 
    0x4e4a3c28, 0x5f5d5b59, 0x6c6b6a69, 0x00003d53, 0x6a6a6a4e, 0x5c7d5d7d, 0x6d38385c, 0x0000004e, 
    0x00000000, 0x00000000, 0x019106b2, 0x017206b8, 0x0000018f, 0x0000003e, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0a0602, 0x1f1b1713, 0x302c2824, 0x00b5b529, 0x1ab90282, 0x00001ab9, 
    0x584b3e29, 0x695f5d5a, 0x6d6c6b6a, 0x00004d43, 0x6b6b6b4f, 0x5d7f5e7f, 0x6f39395e, 0x0000004f, 
    0x00000000, 0x00000000, 0x01c20784, 0x019f078b, 0x000001c0, 0x00000046, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0a0602, 0x1f1b1713, 0x302c2824, 0x00b5b529, 0x1dfe02d0, 0x00001dfe, 
    0x594d3f2a, 0x6a685e5c, 0x6f6e6c6b, 0x00006158, 0x6c6c6c59, 0x5f886888, 0x783a3a68, 0x00000059, 
    0x00000000, 0x00000000, 0x01f90870, 0x01d20877, 0x000001f7, 0x0000004e, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0a0602, 0x1f1b1713, 0x302c2824, 0x00b5b529, 0x21ab0329, 0x000021ab, 
    0x5a4e492c, 0x6b69685d, 0x6f6f6e6c, 0x00007aa5, 0x6e6e6d5a, 0x688a6989, 0x793b3b69, 0x0000005a, 
    0x00000000, 0x00000000, 0x02370979, 0x020c0981, 0x00000234, 0x00000058, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0a0602, 0x1f1b1713, 0x302c2824, 0x00b5b529, 0x25ca038c, 0x000025ca, 
    0x5b584a2d, 0x6c6b695f, 0x6f6f6f6e, 0x00009a86, 0x6f6f6f5b, 0x698b6a8b, 0x7a3c3c6a, 0x0000005b, 
    0x00000000, 0x00000000, 0x027c0aa2, 0x024c0aab, 0x00000279, 0x00000063, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0a0602, 0x1f1b1713, 0x302c2824, 0x00b5b529, 0x2a6b03fb, 0x00002a6b, 
    0x5d594b2f, 0x6e6c6a68, 0x6f6f6f6f, 0x0000c2b0, 0x7979795c, 0x6a8c6b8c, 0x7c3e3e6b, 0x0000005c, 
    0x00000000, 0x00000000, 0x02ca0bef, 0x02940bf9, 0x000002c7, 0x0000006f, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0a0602, 0x1f1b1713, 0x302c2824, 0x00b5b529, 0x2f9d0478, 0x00002f9d, 
    0x5e5a4c38, 0x6f6d6b69, 0x6f6f6f6f, 0x0000f54b, 0x7a7a7a5e, 0x6c8d6d8d, 0x7d48486c, 0x0000005e, 
    0x00000000, 0x00000000, 0x03220d65, 0x02e50d71, 0x0000031e, 0x0000007d, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0a0602, 0x1f1b1713, 0x302c2824, 0x00b5b529, 0x35720504, 0x00003572, 
    0x685b4e39, 0x6f6f6d6a, 0x6f6f6f6f, 0x0000350c, 0x7b7b7b5f, 0x6d8f6e8f, 0x7f49496e, 0x0000005f, 
    0x00000000, 0x00000000, 0x03840f09, 0x033f0f16, 0x00000380, 0x0000008c, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0a0602, 0x1f1b1713, 0x302c2824, 0x00b5b529, 0x3bfd05a1, 0x00003bfd, 
    0x695d4f3a, 0x6f6f6e6c, 0x6f6f6f6f, 0x00008560, 0x7c7c7c69, 0x6f8f788f, 0x884a4a78, 0x00000069, 
    0x00000000, 0x00000000, 0x03f310e1, 0x03a510ef, 0x000003ee, 0x0000009d, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0a0602, 0x1f1b1713, 0x302c2824, 0x00b5b529, 0x43560652, 0x00004356, 
    0x6a5e593c, 0x6f6f6f6d, 0x6f6f6f6f, 0x0000ea95, 0x7e7e7d6a, 0x788f798f, 0x894b4b79, 0x0000006a, 
    0x00000000, 0x00000000, 0x046e12f2, 0x04181302, 0x00000469, 0x000000b1, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0a0602, 0x1f1b1713, 0x302c2824, 0x00b5b529, 0x4b950718, 0x00004b95, 
    0x6b685a3d, 0x6f6f6f6f, 0x6f6f6f6f, 0x00006a19, 0x7f7f7f6b, 0x798f7a8f, 0x8a4c4c7a, 0x0000006b, 
    0x00000000, 0x00000000, 0x04f91544, 0x04981556, 0x000004f3, 0x000000c6, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0a0602, 0x1f1b1713, 0x302c2824, 0x00b5b529, 0x54d707f6, 0x000054d7, 
    0x6d695b3f, 0x6f6f6f6f, 0x6f6f6f6f, 0x00000ac1, 0x8989896c, 0x7a8f7b8f, 0x8c4e4e7b, 0x0000006c, 
    0x00000000, 0x00000000, 0x059517df, 0x052817f3, 0x0000058f, 0x000000df, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0a0602, 0x1f1b1713, 0x302c2824, 0x00b5b529, 0x5f3a08f0, 0x00005f3a, 
    0x6e6a5c48, 0x6f6f6f6f, 0x6f6f6f6f, 0x0000d52a, 0x8a8a8a6e, 0x7c8f7d8f, 0x8d58587c, 0x0000006e, 
    0x00000000, 0x00000000, 0x06451acb, 0x05ca1ae2, 0x0000063d, 0x000000fa, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0a0602, 0x1f1b1713, 0x302c2824, 0x00b5b529, 0x6ae40a08, 0x00006ae4, 
    0x6f6b5e49, 0x6f6f6f6f, 0x6f6f6f6f, 0x0000d431, 0x8b8b8b6f, 0x7d8f7e8f, 0x8f59597e, 0x0000006f, 
    0x00000000, 0x00000000, 0x07091e13, 0x067f1e2d, 0x00000701, 0x00000119, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0a0602, 0x1f1b1713, 0x302c2824, 0x00b5b529, 0x77fb0b43, 0x000077fb, 
    0x6f6d5f4a, 0x6f6f6f6f, 0x6f6f6f6f, 0x00001581, 0x8c8c8c79, 0x7f8f888f, 0x8f5a5a88, 0x00000079, 
    0x00000000, 0x00000000, 0x07e621c2, 0x074b21df, 0x000007dc, 0x0000013b, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x6e1a1f23, 0x00186e1a, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x0f0a0602, 0x1f1b1713, 0x302c2824, 0x00b5b529, 0x86ac0ca4, 0x000086ac, 
    0x05040200, 0x0c0a0807, 0x19180f0d, 0x00000003, 0x07070702, 0x04190419, 0x0a000004, 0x00000002, 
    0x00000000, 0x00000000, 0x00040012, 0x00040012, 0x00000004, 0x00000000, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x5c171f23, 0x00155c17, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00828226, 0x004d0007, 0x0000004d, 
    0x05040200, 0x0c0a0807, 0x19180f0d, 0x00000003, 0x07070702, 0x04190419, 0x0a000004, 0x00000002, 
    0x00000000, 0x00000000, 0x00040012, 0x00040012, 0x00000004, 0x00000000, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x5c171f23, 0x00155c17, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00828226, 0x004d0007, 0x0000004d, 
    0x05040200, 0x0c0a0807, 0x19180f0d, 0x00000003, 0x07070702, 0x04190419, 0x0a000004, 0x00000002, 
    0x00000000, 0x00000000, 0x00040012, 0x00040012, 0x00000004, 0x00000000, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x5c171f23, 0x00155c17, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00828226, 0x004d0007, 0x0000004d, 
    0x05040200, 0x0c0a0807, 0x19180f0d, 0x00000003, 0x07070702, 0x04190419, 0x0a000004, 0x00000002, 
    0x00000000, 0x00000000, 0x00040012, 0x00040012, 0x00000004, 0x00000000, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x5c171f23, 0x00155c17, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00828226, 0x004d0007, 0x0000004d, 
    0x05040200, 0x0c0a0807, 0x19180f0d, 0x00000003, 0x07070702, 0x04190419, 0x0a000004, 0x00000002, 
    0x00000000, 0x00000000, 0x00040012, 0x00040012, 0x00000004, 0x00000000, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x5c171f23, 0x00155c17, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00828226, 0x004d0007, 0x0000004d, 
    0x05040200, 0x0c0a0807, 0x19180f0d, 0x00000003, 0x07070702, 0x04190419, 0x0a000004, 0x00000002, 
    0x00000000, 0x00000000, 0x00040012, 0x00040012, 0x00000004, 0x00000000, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x5c171f23, 0x00155c17, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00828226, 0x004d0007, 0x0000004d, 
    0x05040200, 0x0c0a0807, 0x19180f0d, 0x00000003, 0x07070702, 0x04190419, 0x0a000004, 0x00000002, 
    0x00000000, 0x00000000, 0x00040012, 0x00040012, 0x00000004, 0x00000000, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x5c171f23, 0x00155c17, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00828226, 0x004d0007, 0x0000004d, 
    0x05040200, 0x0c0a0807, 0x19180f0d, 0x00000003, 0x07070702, 0x04190419, 0x0a000004, 0x00000002, 
    0x00000000, 0x00000000, 0x00040012, 0x00040012, 0x00000004, 0x00000000, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x5c171f23, 0x00155c17, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00828226, 0x004d0007, 0x0000004d, 
    0x05040200, 0x0c0a0807, 0x19180f0d, 0x00000003, 0x07070702, 0x04190419, 0x0a000004, 0x00000002, 
    0x00000000, 0x00000000, 0x00040012, 0x00040012, 0x00000004, 0x00000000, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x5c171f23, 0x00155c17, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00828226, 0x004d0007, 0x0000004d, 
    0x05040200, 0x0c0a0807, 0x19180f0d, 0x00000003, 0x07070702, 0x04190419, 0x0a000004, 0x00000002, 
    0x00000000, 0x00000000, 0x00040012, 0x00040012, 0x00000004, 0x00000000, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x5c171f23, 0x00155c17, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00828226, 0x004d0007, 0x0000004d, 
    0x05040200, 0x0c0a0807, 0x19180f0d, 0x00000003, 0x07070702, 0x04190419, 0x0a000004, 0x00000002, 
    0x00000000, 0x00000000, 0x00040012, 0x00040012, 0x00000004, 0x00000000, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x5c171f23, 0x00155c17, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00828226, 0x004d0007, 0x0000004d, 
    0x05040200, 0x0c0a0807, 0x19180f0d, 0x00000003, 0x07070702, 0x04190419, 0x0a000004, 0x00000002, 
    0x00000000, 0x00000000, 0x00040012, 0x00040012, 0x00000004, 0x00000000, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x5c171f23, 0x00155c17, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00828226, 0x004d0007, 0x0000004d, 
    0x05040200, 0x0c0a0807, 0x19180f0d, 0x00000003, 0x07070702, 0x04190419, 0x0a000004, 0x00000002, 
    0x00000000, 0x00000000, 0x00040012, 0x00040012, 0x00000004, 0x00000000, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x5c171f23, 0x00155c17, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00828226, 0x004d0007, 0x0000004d, 
    0x06040200, 0x0d0b0908, 0x1a1a190f, 0x00000003, 0x08080803, 0x041a051a, 0x0c000005, 0x00000003, 
    0x00000000, 0x00000000, 0x00050014, 0x00040014, 0x00000005, 0x00000000, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x5c171f23, 0x00155c17, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00828226, 0x00570008, 0x00000057, 
    0x07050301, 0x0f0d0b09, 0x1c1b1a19, 0x00000004, 0x09090903, 0x051c051c, 0x0d010105, 0x00000003, 
    0x00000000, 0x00000000, 0x00050017, 0x00050017, 0x00000005, 0x00000001, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x5c171f23, 0x00155c17, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00828226, 0x00620009, 0x00000062, 
    0x07050301, 0x190e0c0a, 0x1d1c1b1a, 0x00000005, 0x0b0b0b03, 0x051d061d, 0x0f010106, 0x00000003, 
    0x00000000, 0x00000000, 0x0006001a, 0x0005001a, 0x00000006, 0x00000001, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x5c171f23, 0x00155c17, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00828226, 0x006e000a, 0x0000006e, 
    0x08060301, 0x1a180e0b, 0x1f1d1c1b, 0x00000007, 0x0c0c0c04, 0x061f071f, 0x19010107, 0x00000004, 
    0x00000000, 0x00000000, 0x0007001d, 0x0006001d, 0x00000007, 0x00000001, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x5c171f23, 0x00155c17, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00828226, 0x007b000c, 0x0000007b, 
    0x0a070401, 0x1b190f0c, 0x281f1e1c, 0x00000008, 0x0e0e0e05, 0x07280828, 0x1a010108, 0x00000005, 
    0x00000000, 0x00000000, 0x00080020, 0x00070020, 0x00000008, 0x00000001, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x5c171f23, 0x00155c17, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00828226, 0x008a000d, 0x0000008a, 
    0x0b080401, 0x1c1a190e, 0x29281f1e, 0x0000000a, 0x0f0f0f05, 0x08290929, 0x1b010109, 0x00000005, 
    0x00000000, 0x00000000, 0x00090024, 0x00080025, 0x00000009, 0x00000001, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x5c171f23, 0x00155c17, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00828226, 0x009b000f, 0x0000009b, 
    0x0c090501, 0x1e1c1a18, 0x2a2a291f, 0x0000000d, 0x19191906, 0x092a0a2a, 0x1c01010a, 0x00000006, 
    0x00000000, 0x00000000, 0x000a0029, 0x00090029, 0x0000000a, 0x00000001, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x5c171f23, 0x00155c17, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00828226, 0x00ae0011, 0x000000ae, 
    0x0e0a0602, 0x1f1d1b19, 0x2c2b2a29, 0x00000011, 0x1a1a1a07, 0x0a2c0b2c, 0x1e02020b, 0x00000007, 
    0x00000000, 0x00000000, 0x000b002e, 0x000a002e, 0x0000000b, 0x00000002, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x5c171f23, 0x00155c17, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00828226, 0x00c40013, 0x000000c4, 
    0x0f0b0602, 0x291f1d1a, 0x2d2c2b2a, 0x00000015, 0x1b1b1b07, 0x0b2d0c2d, 0x1f02020c, 0x00000007, 
    0x00000000, 0x00000000, 0x000c0034, 0x000b0034, 0x0000000c, 0x00000002, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x5c171f23, 0x00155c17, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00828226, 0x00dc0015, 0x000000dc, 
    0x190c0702, 0x2a281e1c, 0x2f2d2c2b, 0x0000001a, 0x1d1d1c08, 0x0d2f0e2f, 0x2902020e, 0x00000008, 
    0x00000000, 0x00000000, 0x000e003a, 0x000d003a, 0x0000000e, 0x00000002, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x5c171f23, 0x00155c17, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00828226, 0x00f70018, 0x000000f7, 
    0x1a0e0802, 0x2b29281d, 0x382f2e2c, 0x00000021, 0x1e1e1e0a, 0x0e381838, 0x2a020218, 0x0000000a, 
    0x00000000, 0x00000000, 0x00100041, 0x000e0041, 0x00000010, 0x00000002, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x5c171f23, 0x00155c17, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00828226, 0x0115001b, 0x00000115, 
    0x1b180903, 0x2c2a291f, 0x39382f2e, 0x0000002a, 0x2828280b, 0x18391939, 0x2b030319, 0x0000000b, 
    0x00000000, 0x00000000, 0x00120049, 0x0010004a, 0x00000012, 0x00000003, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x5c171f23, 0x00155c17, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00828226, 0x0137001e, 0x00000137, 
    0x1d190a03, 0x2e2c2a28, 0x3a3a392f, 0x00000034, 0x2929290c, 0x193a1a3a, 0x2c03031a, 0x0000000c, 
    0x00000000, 0x00000000, 0x00140052, 0x00120053, 0x00000014, 0x00000003, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x5c171f23, 0x00155c17, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00828226, 0x015d0022, 0x0000015d, 
    0x1e1a0c04, 0x2f2d2b29, 0x3c3b3a39, 0x00000042, 0x2a2a2a0e, 0x1a3c1b3c, 0x2e04041b, 0x0000000e, 
    0x00000000, 0x00000000, 0x0016005c, 0x0014005d, 0x00000016, 0x00000004, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x5c171f23, 0x00155c17, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00828226, 0x01880026, 0x00000188, 
    0x281b0d04, 0x392f2d2a, 0x3d3c3b3a, 0x00000053, 0x2b2b2b0f, 0x1c3d1d3d, 0x2f04041d, 0x0000000f, 
    0x00000000, 0x00000000, 0x00190068, 0x00170068, 0x00000019, 0x00000004, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x5c171f23, 0x00155c17, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00828226, 0x01b8002b, 0x000001b8, 
    0x291d0f05, 0x3a382e2c, 0x3f3d3c3b, 0x00000069, 0x2d2d2c19, 0x1d3f1e3f, 0x3905051e, 0x00000019, 
    0x00000000, 0x00000000, 0x001c0075, 0x001a0075, 0x0000001c, 0x00000005, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x5c171f23, 0x00155c17, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00828226, 0x01ee0030, 0x000001ee, 
    0x2a1e1905, 0x3b39382d, 0x483f3e3c, 0x00000084, 0x2e2e2e1a, 0x1f482848, 0x3a050528, 0x0000001a, 
    0x00000000, 0x00000000, 0x00200083, 0x001d0083, 0x00000020, 0x00000005, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x5c171f23, 0x00155c17, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00828226, 0x022b0036, 0x0000022b, 
    0x2b281a06, 0x3c3a392f, 0x49483f3e, 0x000000a6, 0x3838381b, 0x28492949, 0x3b060629, 0x0000001b, 
    0x00000000, 0x00000000, 0x00240093, 0x00210094, 0x00000024, 0x00000006, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x5c171f23, 0x00155c17, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00828226, 0x026f003d, 0x0000026f, 
    0x2d291b07, 0x3e3c3a38, 0x4a4a493f, 0x000000d2, 0x3939391d, 0x294a2a4a, 0x3c07072a, 0x0000001d, 
    0x00000000, 0x00000000, 0x002800a5, 0x002500a6, 0x00000028, 0x00000007, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x5c171f23, 0x00155c17, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00828226, 0x02bb0044, 0x000002bb, 
    0x2e2a1c08, 0x3f3d3b39, 0x4c4b4a49, 0x00000108, 0x3a3a3a1e, 0x2a4c2b4c, 0x3e08082b, 0x0000001e, 
    0x00000000, 0x00000000, 0x002d00b9, 0x002900ba, 0x0000002d, 0x00000008, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x5c171f23, 0x00155c17, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00828226, 0x0310004d, 0x00000310, 
    0x382b1e09, 0x493f3d3a, 0x4d4c4b4a, 0x0000014d, 0x3b3b3b28, 0x2c4d2d4d, 0x3f09092d, 0x00000028, 
    0x00000000, 0x00000000, 0x003300d0, 0x002f00d1, 0x00000033, 0x00000009, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x5c171f23, 0x00155c17, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00828226, 0x03710056, 0x00000371, 
    0x392d1f0a, 0x4a483e3c, 0x4f4d4c4b, 0x000001a3, 0x3d3d3c29, 0x2d4f2e4f, 0x490a0a2e, 0x00000029, 
    0x00000000, 0x00000000, 0x003900ea, 0x003400eb, 0x00000039, 0x0000000a, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x5c171f23, 0x00155c17, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00828226, 0x03dd0061, 0x000003dd, 
    0x3a2e290b, 0x4b49483d, 0x584f4e4c, 0x00000210, 0x3e3e3e2a, 0x2f583858, 0x4a0b0b38, 0x0000002a, 
    0x00000000, 0x00000000, 0x00400106, 0x003b0107, 0x00000040, 0x0000000b, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x5c171f23, 0x00155c17, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00828226, 0x0456006d, 0x00000456, 
    0x3b382a0c, 0x4c4a493f, 0x59584f4e, 0x0000029a, 0x4848482b, 0x38593959, 0x4b0c0c39, 0x0000002b, 
    0x00000000, 0x00000000, 0x00480127, 0x00420128, 0x00000048, 0x0000000c, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x5c171f23, 0x00155c17, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00828226, 0x04de007a, 0x000004de, 
    0x3d392b0e, 0x4e4c4a48, 0x5a5a594f, 0x00000347, 0x4949492d, 0x395a3a5a, 0x4c0e0e3a, 0x0000002d, 
    0x00000000, 0x00000000, 0x0051014b, 0x004a014c, 0x00000051, 0x0000000e, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x5c171f23, 0x00155c17, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00828226, 0x05760089, 0x00000576, 
    0x3e3a2c18, 0x4f4d4b49, 0x5c5b5a59, 0x00000421, 0x4a4a4a2e, 0x3a5c3b5c, 0x4e18183b, 0x0000002e, 
    0x00000000, 0x00000000, 0x005b0173, 0x00530175, 0x0000005b, 0x00000010, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x5c171f23, 0x00155c17, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00828226, 0x0621009a, 0x00000621, 
    0x483b2e19, 0x594f4d4a, 0x5d5c5b5a, 0x00000533, 0x4b4b4b38, 0x3c5d3d5d, 0x4f19193d, 0x00000038, 
    0x00000000, 0x00000000, 0x006701a1, 0x005e01a2, 0x00000066, 0x00000012, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x5c171f23, 0x00155c17, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00828226, 0x06e200ad, 0x000006e2, 
    0x493d2f1a, 0x5a584e4c, 0x5f5d5c5b, 0x0000068d, 0x4d4d4c39, 0x3d5f3e5f, 0x591a1a3e, 0x00000039, 
    0x00000000, 0x00000000, 0x007301d4, 0x006901d6, 0x00000073, 0x00000014, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x5c171f23, 0x00155c17, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00828226, 0x07ba00c2, 0x000007ba, 
    0x4a3e391b, 0x5b59584d, 0x685f5e5c, 0x00000841, 0x4e4e4e3a, 0x3f684868, 0x5a1b1b48, 0x0000003a, 
    0x00000000, 0x00000000, 0x0081020d, 0x0076020f, 0x00000081, 0x00000016, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x5c171f23, 0x00155c17, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00828226, 0x08ac00da, 0x000008ac, 
    0x4b483a1d, 0x5c5a594f, 0x69685f5e, 0x00000a66, 0x5858583b, 0x48694969, 0x5b1d1d49, 0x0000003b, 
    0x00000000, 0x00000000, 0x0091024e, 0x00850250, 0x00000091, 0x00000019, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x5c171f23, 0x00155c17, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00828226, 0x09bc00f5, 0x000009bc, 
    0x4d493b1e, 0x5e5c5a58, 0x6a6a695f, 0x00000d1a, 0x5959593d, 0x496a4a6a, 0x5c1e1e4a, 0x0000003d, 
    0x00000000, 0x00000000, 0x00a30296, 0x00950299, 0x000000a2, 0x0000001c, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x5c171f23, 0x00155c17, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00828226, 0x0aed0113, 0x00000aed, 
    0x4e4a3c28, 0x5f5d5b59, 0x6c6b6a69, 0x00001082, 0x5a5a5a3e, 0x4a6c4b6c, 0x5e28284b, 0x0000003e, 
    0x00000000, 0x00000000, 0x00b702e7, 0x00a702ea, 0x000000b6, 0x00000020, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x5c171f23, 0x00155c17, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00828226, 0x0c430134, 0x00000c43, 
    0x584b3e29, 0x695f5d5a, 0x6d6c6b6a, 0x000014cd, 0x5b5b5b48, 0x4c6d4d6d, 0x5f29294d, 0x00000048, 
    0x00000000, 0x00000000, 0x00ce0342, 0x00bc0345, 0x000000cd, 0x00000024, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x5c171f23, 0x00155c17, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00828226, 0x0dc4015a, 0x00000dc4, 
    0x594d3f2a, 0x6a685e5c, 0x6f6d6c6b, 0x00001a35, 0x5d5d5c49, 0x4d6f4e6f, 0x692a2a4e, 0x00000049, 
    0x00000000, 0x00000000, 0x00e703a8, 0x00d303ac, 0x000000e6, 0x00000028, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x5c171f23, 0x00155c17, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00828226, 0x0f740185, 0x00000f74, 
    0x5a4e492b, 0x6b69685d, 0x6f6f6e6c, 0x00002105, 0x5e5e5e4a, 0x4f785878, 0x6a2b2b58, 0x0000004a, 
    0x00000000, 0x00000000, 0x0103041b, 0x00ed041f, 0x00000102, 0x0000002d, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x5c171f23, 0x00155c17, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00828226, 0x115801b4, 0x00001158, 
    0x5b584a2d, 0x6c6a695f, 0x6f6f6f6e, 0x0000299a, 0x6868684b, 0x58795979, 0x6b2d2d59, 0x0000004b, 
    0x00000000, 0x00000000, 0x0123049c, 0x010a04a0, 0x00000122, 0x00000033, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x5c171f23, 0x00155c17, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00828226, 0x137801ea, 0x00001378, 
    0x5d594b2e, 0x6e6c6a68, 0x6f6f6f6f, 0x0000346a, 0x6969694d, 0x597a5a7a, 0x6c2e2e5a, 0x0000004d, 
    0x00000000, 0x00000000, 0x0147052c, 0x012b0532, 0x00000145, 0x00000039, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x5c171f23, 0x00155c17, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00828226, 0x15da0226, 0x000015da, 
    0x5e5a4c38, 0x6f6d6b69, 0x6f6f6f6f, 0x00004209, 0x6a6a6a4e, 0x5a7c5b7c, 0x6e38385b, 0x0000004e, 
    0x00000000, 0x00000000, 0x016f05cf, 0x014f05d4, 0x0000016d, 0x00000041, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x5c171f23, 0x00155c17, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00828226, 0x18870269, 0x00001887, 
    0x685b4e39, 0x6f6f6d6a, 0x6f6f6f6f, 0x00005333, 0x6b6b6b58, 0x5c7d5d7d, 0x6f39395d, 0x00000058, 
    0x00000000, 0x00000000, 0x019c0685, 0x0178068b, 0x0000019a, 0x00000048, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x5c171f23, 0x00155c17, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00828226, 0x1b8902b5, 0x00001b89, 
    0x695d4f3a, 0x6f6f6e6c, 0x6f6f6f6f, 0x000068d3, 0x6d6d6c59, 0x5d7f5e7f, 0x793a3a5e, 0x00000059, 
    0x00000000, 0x00000000, 0x01cf0751, 0x01a70759, 0x000001cc, 0x00000051, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x5c171f23, 0x00155c17, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00828226, 0x1ee8030a, 0x00001ee8, 
    0x6a5e593b, 0x6f6f6f6d, 0x6f6f6f6f, 0x00008412, 0x6e6e6e5a, 0x5f886888, 0x7a3b3b68, 0x0000005a, 
    0x00000000, 0x00000000, 0x02070837, 0x01da083f, 0x00000205, 0x0000005b, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x5c171f23, 0x00155c17, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00828226, 0x22b10369, 0x000022b1, 
    0x6b685a3d, 0x6f6f6f6f, 0x6f6f6f6f, 0x0000a666, 0x7878785b, 0x68896989, 0x7b3d3d69, 0x0000005b, 
    0x00000000, 0x00000000, 0x02470938, 0x02150941, 0x00000244, 0x00000067, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x5c171f23, 0x00155c17, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00828226, 0x26f003d4, 0x000026f0, 
    0x6d695b3e, 0x6f6f6f6f, 0x6f6f6f6f, 0x0000d1a7, 0x7979795d, 0x698a6a8a, 0x7c3e3e6a, 0x0000005d, 
    0x00000000, 0x00000000, 0x028f0a59, 0x02560a64, 0x0000028b, 0x00000073, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x5c171f23, 0x00155c17, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00828226, 0x2bb5044c, 0x00002bb5, 
    0x6e6a5c48, 0x6f6f6f6f, 0x6f6f6f6f, 0x00000825, 0x7a7a7a5e, 0x6a8c6b8c, 0x7e48486b, 0x0000005e, 
    0x00000000, 0x00000000, 0x02df0b9e, 0x029f0ba9, 0x000002db, 0x00000082, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x5c171f23, 0x00155c17, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00828226, 0x310f04d3, 0x0000310f, 
    0x6f6b5e49, 0x6f6f6f6f, 0x6f6f6f6f, 0x00004ccd, 0x7b7b7b68, 0x6c8d6d8d, 0x7f49496d, 0x00000068, 
    0x00000000, 0x00000000, 0x03390d0a, 0x02f10d17, 0x00000334, 0x00000091, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x5c171f23, 0x00155c17, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00828226, 0x3712056a, 0x00003712, 
    0x6f6d5f4a, 0x6f6f6f6f, 0x6f6f6f6f, 0x0000a34d, 0x7d7d7c69, 0x6d8f6e8f, 0x894a4a6e, 0x00000069, 
    0x00000000, 0x00000000, 0x039e0ea3, 0x034e0eb2, 0x00000399, 0x000000a3, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x5c171f23, 0x00155c17, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00828226, 0x3dd00614, 0x00003dd0, 
    0x6f6e694b, 0x6f6f6f6f, 0x6f6f6f6f, 0x00001049, 0x7e7e7e6a, 0x6f8f788f, 0x8a4b4b78, 0x0000006a, 
    0x00000000, 0x00000000, 0x040f106e, 0x03b5107e, 0x0000040a, 0x000000b7, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x5c171f23, 0x00155c17, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00828226, 0x456206d2, 0x00004562, 
    0x6f6f6a4d, 0x6f6f6f6f, 0x6f6f6f6f, 0x0000999a, 0x8888886b, 0x788f798f, 0x8b4d4d79, 0x0000006b, 
    0x00000000, 0x00000000, 0x048f1271, 0x042a1283, 0x00000488, 0x000000ce, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x5c171f23, 0x00155c17, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00828226, 0x4de107a8, 0x00004de1, 
    0x6f6f6b4e, 0x6f6f6f6f, 0x6f6f6f6f, 0x0000469a, 0x8989896d, 0x798f7a8f, 0x8c4e4e7a, 0x0000006d, 
    0x00000000, 0x00000000, 0x051e14b3, 0x04ac14c8, 0x00000517, 0x000000e7, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x5c171f23, 0x00155c17, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00828226, 0x576b0898, 0x0000576b, 
    0x6f6f6c58, 0x6f6f6f6f, 0x6f6f6f6f, 0x00002093, 0x8a8a8a6e, 0x7a8f7b8f, 0x8e58587b, 0x0000006e, 
    0x00000000, 0x00000000, 0x05be173c, 0x053f1753, 0x000005b6, 0x00000104, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x5c171f23, 0x00155c17, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00828226, 0x621f09a6, 0x0000621f, 
    0x6f6f6e59, 0x6f6f6f6f, 0x6f6f6f6f, 0x00003333, 0x8b8b8b78, 0x7c8f7d8f, 0x8f59597d, 0x00000078, 
    0x00000000, 0x00000000, 0x06721a14, 0x05e31a2f, 0x00000669, 0x00000123, 0x00000000, 0x00000000, 
    0x27272744, 0x0e00001e, 0x00000000, 0x131b0404, 0x23330f13, 0x5c171f23, 0x00155c17, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x00828226, 0x6e240ad4, 0x00006e24, 
    0x00000000, 0x00000000, 0x00000000, 0x00000002, 0x06061908, 0x00000000, 0x08000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x1f1f5d1e, 0x2a00001e, 0x00000000, 0x00000400, 0x00000000, 0x00000000, 0x00000000, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000002, 0x06061908, 0x00000000, 0x08000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x1f1f5d1e, 0x2a00001e, 0x00000000, 0x00000400, 0x00000000, 0x00000000, 0x00000000, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000002, 0x06061908, 0x00000000, 0x08000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x1f1f5d1e, 0x2a00001e, 0x00000000, 0x00000400, 0x00000000, 0x00000000, 0x00000000, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000002, 0x06061908, 0x00000000, 0x08000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x1f1f5d1e, 0x2a00001e, 0x00000000, 0x00000400, 0x00000000, 0x00000000, 0x00000000, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000002, 0x06061908, 0x00000000, 0x08000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x1f1f5d1e, 0x2a00001e, 0x00000000, 0x00000400, 0x00000000, 0x00000000, 0x00000000, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000002, 0x06061908, 0x00000000, 0x08000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x1f1f5d1e, 0x2a00001e, 0x00000000, 0x00000400, 0x00000000, 0x00000000, 0x00000000, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000002, 0x06061908, 0x00000000, 0x08000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x1f1f5d1e, 0x2a00001e, 0x00000000, 0x00000400, 0x00000000, 0x00000000, 0x00000000, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000002, 0x06061908, 0x00000000, 0x08000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x1f1f5d1e, 0x2a00001e, 0x00000000, 0x00000400, 0x00000000, 0x00000000, 0x00000000, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000002, 0x06061908, 0x00000000, 0x08000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x1f1f5d1e, 0x2a00001e, 0x00000000, 0x00000400, 0x00000000, 0x00000000, 0x00000000, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000002, 0x06061908, 0x00000000, 0x08000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x1f1f5d1e, 0x2a00001e, 0x00000000, 0x00000400, 0x00000000, 0x00000000, 0x00000000, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000002, 0x06061908, 0x00000000, 0x08000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x1f1f5d1e, 0x2a00001e, 0x00000000, 0x00000400, 0x00000000, 0x00000000, 0x00000000, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000002, 0x06061908, 0x00000000, 0x08000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x1f1f5d1e, 0x2a00001e, 0x00000000, 0x00000400, 0x00000000, 0x00000000, 0x00000000, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000002, 0x06061908, 0x00000000, 0x08000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x1f1f5d1e, 0x2a00001e, 0x00000000, 0x00000400, 0x00000000, 0x00000000, 0x00000000, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000003, 0x06061a09, 0x00000000, 0x09000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x1f1f5d1e, 0x2a00001e, 0x00000000, 0x00000400, 0x00000000, 0x00000000, 0x00000000, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000004, 0x07071b0a, 0x00000000, 0x0a000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x1f1f5d1e, 0x2a00001e, 0x00000000, 0x00000400, 0x00000000, 0x00000000, 0x00000000, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000005, 0x08081d0b, 0x00000000, 0x0b010000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000000, 
    0x1f1f5d1e, 0x2a00001e, 0x00000000, 0x00000400, 0x00000000, 0x00000000, 0x00000000, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000006, 0x09091e0c, 0x00000000, 0x0c010000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000000, 
    0x1f1f5d1e, 0x2a00001e, 0x00000000, 0x00000400, 0x00000000, 0x00000000, 0x00000000, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000008, 0x0a0a280e, 0x00000000, 0x0e010000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000000, 
    0x1f1f5d1e, 0x2a00001e, 0x00000000, 0x00000400, 0x00000000, 0x00000000, 0x00000000, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x0000000a, 0x0c0c2918, 0x00000000, 0x18010000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000000, 
    0x1f1f5d1e, 0x2a00001e, 0x00000000, 0x00000400, 0x00000000, 0x00000000, 0x00000000, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x0000000c, 0x0d0d2a19, 0x00000000, 0x19010000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000000, 
    0x1f1f5d1e, 0x2a00001e, 0x00000000, 0x00000400, 0x00000000, 0x00000000, 0x00000000, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x0000000f, 0x0f0f2b1a, 0x00000000, 0x1a010000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000000, 
    0x1f1f5d1e, 0x2a00001e, 0x00000000, 0x00000400, 0x00000000, 0x00000000, 0x00000000, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000013, 0x19192d1c, 0x00000000, 0x1c020000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000002, 0x00000000, 0x00000000, 
    0x1f1f5d1e, 0x2a00001e, 0x00000000, 0x00000400, 0x00000000, 0x00000000, 0x00000000, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000018, 0x1a1a2e1d, 0x00000000, 0x1d020000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000002, 0x00000000, 0x00000000, 
    0x1f1f5d1e, 0x2a00001e, 0x00000000, 0x00000400, 0x00000000, 0x00000000, 0x00000000, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x0000001e, 0x1b1b381e, 0x00000000, 0x1e020000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000002, 0x00000000, 0x00000000, 
    0x1f1f5d1e, 0x2a00001e, 0x00000000, 0x00000400, 0x00000000, 0x00000000, 0x00000000, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000026, 0x1c1c3928, 0x00000000, 0x28030000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000003, 0x00000000, 0x00000000, 
    0x1f1f5d1e, 0x2a00001e, 0x00000000, 0x00000400, 0x00000000, 0x00000000, 0x00000000, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000030, 0x1e1e3a29, 0x00000000, 0x29030000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000003, 0x00000000, 0x00000000, 
    0x1f1f5d1e, 0x2a00001e, 0x00000000, 0x00000400, 0x00000000, 0x00000000, 0x00000000, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x0000003d, 0x1f1f3b2a, 0x00000000, 0x2a030000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000003, 0x00000000, 0x00000000, 
    0x1f1f5d1e, 0x2a00001e, 0x00000000, 0x00000400, 0x00000000, 0x00000000, 0x00000000, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x0000004d, 0x29293d2c, 0x00000000, 0x2c040000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000004, 0x00000000, 0x00000000, 
    0x1f1f5d1e, 0x2a00001e, 0x00000000, 0x00000400, 0x00000000, 0x00000000, 0x00000000, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000061, 0x2a2a3e2d, 0x00000000, 0x2d040000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000004, 0x00000000, 0x00000000, 
    0x1f1f5d1e, 0x2a00001e, 0x00000000, 0x00000400, 0x00000000, 0x00000000, 0x00000000, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x0000007a, 0x2b2b482e, 0x00000000, 0x2e050000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000005, 0x00000000, 0x00000000, 
    0x1f1f5d1e, 0x2a00001e, 0x00000000, 0x00000400, 0x00000000, 0x00000000, 0x00000000, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x0000009a, 0x2c2c4938, 0x00000000, 0x38060000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000006, 0x00000000, 0x00000000, 
    0x1f1f5d1e, 0x2a00001e, 0x00000000, 0x00000400, 0x00000000, 0x00000000, 0x00000000, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x000000c2, 0x2e2e4a39, 0x00000000, 0x39060000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000006, 0x00000000, 0x00000000, 
    0x1f1f5d1e, 0x2a00001e, 0x00000000, 0x00000400, 0x00000000, 0x00000000, 0x00000000, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x000000f4, 0x2f2f4b3a, 0x00000000, 0x3a070000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000007, 0x00000000, 0x00000000, 
    0x1f1f5d1e, 0x2a00001e, 0x00000000, 0x00000400, 0x00000000, 0x00000000, 0x00000000, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000133, 0x39394d3c, 0x00000000, 0x3c080000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000008, 0x00000000, 0x00000000, 
    0x1f1f5d1e, 0x2a00001e, 0x00000000, 0x00000400, 0x00000000, 0x00000000, 0x00000000, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000183, 0x3a3a4e3d, 0x00000000, 0x3d090000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000009, 0x00000000, 0x00000000, 
    0x1f1f5d1e, 0x2a00001e, 0x00000000, 0x00000400, 0x00000000, 0x00000000, 0x00000000, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x000001e8, 0x3b3b583e, 0x00000000, 0x3e0b0000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0000000b, 0x00000000, 0x00000000, 
    0x1f1f5d1e, 0x2a00001e, 0x00000000, 0x00000400, 0x00000000, 0x00000000, 0x00000000, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000266, 0x3c3c5948, 0x00000000, 0x480c0000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0000000c, 0x00000000, 0x00000000, 
    0x1f1f5d1e, 0x2a00001e, 0x00000000, 0x00000400, 0x00000000, 0x00000000, 0x00000000, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000306, 0x3e3e5a49, 0x00000000, 0x490d0000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0000000d, 0x00000000, 0x00000000, 
    0x1f1f5d1e, 0x2a00001e, 0x00000000, 0x00000400, 0x00000000, 0x00000000, 0x00000000, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x000003cf, 0x3f3f5b4a, 0x00000000, 0x4a0f0000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0000000f, 0x00000000, 0x00000000, 
    0x1f1f5d1e, 0x2a00001e, 0x00000000, 0x00000400, 0x00000000, 0x00000000, 0x00000000, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x000004cd, 0x49495d4c, 0x00000000, 0x4c190000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000011, 0x00000000, 0x00000000, 
    0x1f1f5d1e, 0x2a00001e, 0x00000000, 0x00000400, 0x00000000, 0x00000000, 0x00000000, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x0000060c, 0x4a4a5e4d, 0x00000000, 0x4d1a0000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000013, 0x00000000, 0x00000000, 
    0x1f1f5d1e, 0x2a00001e, 0x00000000, 0x00000400, 0x00000000, 0x00000000, 0x00000000, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x0000079f, 0x4b4b684e, 0x00000000, 0x4e1b0000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000016, 0x00000000, 0x00000000, 
    0x1f1f5d1e, 0x2a00001e, 0x00000000, 0x00000400, 0x00000000, 0x00000000, 0x00000000, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x0000099a, 0x4c4c6958, 0x00000000, 0x581c0000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000018, 0x00000000, 0x00000000, 
    0x1f1f5d1e, 0x2a00001e, 0x00000000, 0x00000400, 0x00000000, 0x00000000, 0x00000000, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000c18, 0x4e4e6a59, 0x00000000, 0x591e0000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0000001b, 0x00000000, 0x00000000, 
    0x1f1f5d1e, 0x2a00001e, 0x00000000, 0x00000400, 0x00000000, 0x00000000, 0x00000000, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000f3d, 0x4f4f6b5a, 0x00000000, 0x5a280000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0000001f, 0x00000000, 0x00000000, 
    0x1f1f5d1e, 0x2a00001e, 0x00000000, 0x00000400, 0x00000000, 0x00000000, 0x00000000, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00001333, 0x59596d5c, 0x00000000, 0x5c290000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000023, 0x00000000, 0x00000000, 
    0x1f1f5d1e, 0x2a00001e, 0x00000000, 0x00000400, 0x00000000, 0x00000000, 0x00000000, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00001831, 0x5a5a6e5d, 0x00000000, 0x5d2a0000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000027, 0x00000000, 0x00000000, 
    0x1f1f5d1e, 0x2a00001e, 0x00000000, 0x00000400, 0x00000000, 0x00000000, 0x00000000, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00001e7a, 0x5b5b785e, 0x00000000, 0x5e2b0000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0000002c, 0x00000000, 0x00000000, 
    0x1f1f5d1e, 0x2a00001e, 0x00000000, 0x00000400, 0x00000000, 0x00000000, 0x00000000, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00002666, 0x5c5c7968, 0x00000000, 0x682c0000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000031, 0x00000000, 0x00000000, 
    0x1f1f5d1e, 0x2a00001e, 0x00000000, 0x00000400, 0x00000000, 0x00000000, 0x00000000, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00003062, 0x5e5e7a69, 0x00000000, 0x692e0000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000037, 0x00000000, 0x00000000, 
    0x1f1f5d1e, 0x2a00001e, 0x00000000, 0x00000400, 0x00000000, 0x00000000, 0x00000000, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00003cf5, 0x5f5f7b6a, 0x00000000, 0x6a380000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0000003e, 0x00000000, 0x00000000, 
    0x1f1f5d1e, 0x2a00001e, 0x00000000, 0x00000400, 0x00000000, 0x00000000, 0x00000000, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00004ccd, 0x69697d6c, 0x00000000, 0x6c390000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000046, 0x00000000, 0x00000000, 
    0x1f1f5d1e, 0x2a00001e, 0x00000000, 0x00000400, 0x00000000, 0x00000000, 0x00000000, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x000060c3, 0x6a6a7e6d, 0x00000000, 0x6d3a0000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0000004e, 0x00000000, 0x00000000, 
    0x1f1f5d1e, 0x2a00001e, 0x00000000, 0x00000400, 0x00000000, 0x00000000, 0x00000000, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x000079ea, 0x6b6b886e, 0x00000000, 0x6e3b0000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000058, 0x00000000, 0x00000000, 
    0x1f1f5d1e, 0x2a00001e, 0x00000000, 0x00000400, 0x00000000, 0x00000000, 0x00000000, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x0000999a, 0x6c6c8978, 0x00000000, 0x783c0000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000063, 0x00000000, 0x00000000, 
    0x1f1f5d1e, 0x2a00001e, 0x00000000, 0x00000400, 0x00000000, 0x00000000, 0x00000000, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x0000c186, 0x6e6e8a79, 0x00000000, 0x793e0000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0000006f, 0x00000000, 0x00000000, 
    0x1f1f5d1e, 0x2a00001e, 0x00000000, 0x00000400, 0x00000000, 0x00000000, 0x00000000, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x0000f3d3, 0x6f6f8b7a, 0x00000000, 0x7a480000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0000007c, 0x00000000, 0x00000000, 
    0x1f1f5d1e, 0x2a00001e, 0x00000000, 0x00000400, 0x00000000, 0x00000000, 0x00000000, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00003333, 0x79798d7c, 0x00000000, 0x7c490000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0000008c, 0x00000000, 0x00000000, 
    0x1f1f5d1e, 0x2a00001e, 0x00000000, 0x00000400, 0x00000000, 0x00000000, 0x00000000, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x0000830c, 0x7a7a8e7d, 0x00000000, 0x7d4a0000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0000009d, 0x00000000, 0x00000000, 
    0x1f1f5d1e, 0x2a00001e, 0x00000000, 0x00000400, 0x00000000, 0x00000000, 0x00000000, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x0000e7a6, 0x7b7b8f7e, 0x00000000, 0x7e4b0000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000000b0, 0x00000000, 0x00000000, 
    0x1f1f5d1e, 0x2a00001e, 0x00000000, 0x00000400, 0x00000000, 0x00000000, 0x00000000, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00006666, 0x7c7c8f88, 0x00000000, 0x884c0000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000000c6, 0x00000000, 0x00000000, 
    0x1f1f5d1e, 0x2a00001e, 0x00000000, 0x00000400, 0x00000000, 0x00000000, 0x00000000, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000618, 0x7e7e8f89, 0x00000000, 0x894e0000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000000de, 0x00000000, 0x00000000, 
    0x1f1f5d1e, 0x2a00001e, 0x00000000, 0x00000400, 0x00000000, 0x00000000, 0x00000000, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x0000cf4d, 0x7f7f8f8a, 0x00000000, 0x8a580000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000000f9, 0x00000000, 0x00000000, 
    0x1f1f5d1e, 0x2a00001e, 0x00000000, 0x00000400, 0x00000000, 0x00000000, 0x00000000, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x0000cccd, 0x89898f8c, 0x00000000, 0x8c590000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000118, 0x00000000, 0x00000000, 
    0x1f1f5d1e, 0x2a00001e, 0x00000000, 0x00000400, 0x00000000, 0x00000000, 0x00000000, 0x14000000, 
    0x0c0c0c0c, 0x0c0c0c0c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000
};

// For LCU size of 32x32:
// columns 1-3: ModeCost (U8)
// column 4: lambda_rd (U32)
// column 5: lambda_md (U16)
// column  6: QP (U8)
// column  7: not used yet
// column  8: not used yet
const uint32_t CodechalEncHevcStateG11::m_brcLcu32x32LambdaModeCostInit[m_brcLambdaModeCostTableSize] = {
    0x19191807, 0x00000000, 0x03000000, 0x00000500, 0x0000023c, 0x00000000, 0xFFFFFFFF, 0xFFFFFFFF,
    0x19191807, 0x00000000, 0x03000000, 0x00000500, 0x0000023c, 0x00000001, 0xFFFFFFFF, 0xFFFFFFFF,
    0x19191807, 0x00000000, 0x03000000, 0x00000500, 0x0000023c, 0x00000002, 0xFFFFFFFF, 0xFFFFFFFF,
    0x19191807, 0x00000000, 0x03000000, 0x00000500, 0x0000023c, 0x00000003, 0xFFFFFFFF, 0xFFFFFFFF,
    0x19191807, 0x00000000, 0x03000000, 0x00000500, 0x0000023c, 0x00000004, 0xFFFFFFFF, 0xFFFFFFFF,
    0x19191807, 0x00000000, 0x03000000, 0x00000500, 0x0000023c, 0x00000005, 0xFFFFFFFF, 0xFFFFFFFF,
    0x19191807, 0x00000000, 0x03000000, 0x00000500, 0x0000023c, 0x00000006, 0xFFFFFFFF, 0xFFFFFFFF,
    0x19191807, 0x00000000, 0x03000000, 0x00000500, 0x0000023c, 0x00000007, 0xFFFFFFFF, 0xFFFFFFFF,
    0x19191807, 0x00000000, 0x03000000, 0x00000500, 0x0000023c, 0x00000008, 0xFFFFFFFF, 0xFFFFFFFF,
    0x19191807, 0x00000000, 0x03000000, 0x00000500, 0x0000023c, 0x00000009, 0xFFFFFFFF, 0xFFFFFFFF,
    0x19191807, 0x00000000, 0x03000000, 0x00000500, 0x0000023c, 0x0000000a, 0xFFFFFFFF, 0xFFFFFFFF,
    0x19191807, 0x00000000, 0x03000000, 0x00000500, 0x0000023c, 0x0000000b, 0xFFFFFFFF, 0xFFFFFFFF,
    0x19191807, 0x00000000, 0x03000000, 0x00000500, 0x0000023c, 0x0000000c, 0xFFFFFFFF, 0xFFFFFFFF,
    0x1a1a1908, 0x00000000, 0x03000000, 0x0000064d, 0x00000283, 0x0000000d, 0xFFFFFFFF, 0xFFFFFFFF,
    0x1b1b1b09, 0x00000000, 0x04000000, 0x000007f0, 0x000002d1, 0x0000000e, 0xFFFFFFFF, 0xFFFFFFFF,
    0x1c1c1c0b, 0x00000000, 0x04000000, 0x00000a00, 0x0000032a, 0x0000000f, 0xFFFFFFFF, 0xFFFFFFFF,
    0x1e1e1d0c, 0x00000000, 0x05000000, 0x00000c99, 0x0000038d, 0x00000010, 0xFFFFFFFF, 0xFFFFFFFF,
    0x281f1f0d, 0x00000000, 0x05000000, 0x00000fe0, 0x000003fc, 0x00000011, 0xFFFFFFFF, 0xFFFFFFFF,
    0x2929280f, 0x00000000, 0x06000000, 0x00001400, 0x00000479, 0x00000012, 0xFFFFFFFF, 0xFFFFFFFF,
    0x2a2a2919, 0x00000000, 0x07000000, 0x00001933, 0x00000505, 0x00000013, 0xFFFFFFFF, 0xFFFFFFFF,
    0x2b2b2b1a, 0x00000000, 0x08000000, 0x00001fbf, 0x000005a2, 0x00000014, 0xFFFFFFFF, 0xFFFFFFFF,
    0x2c2c2c1b, 0x00000000, 0x09000000, 0x00002800, 0x00000653, 0x00000015, 0xFFFFFFFF, 0xFFFFFFFF,
    0x2e2e2d1c, 0x00000000, 0x0a000000, 0x00003266, 0x00000719, 0x00000016, 0xFFFFFFFF, 0xFFFFFFFF,
    0x382f2f1e, 0x00000000, 0x0b000000, 0x00003f7f, 0x000007f8, 0x00000017, 0xFFFFFFFF, 0xFFFFFFFF,
    0x39393828, 0x00000000, 0x0d000000, 0x00005000, 0x000008f2, 0x00000018, 0xFFFFFFFF, 0xFFFFFFFF,
    0x3a3a3929, 0x00000000, 0x0f000000, 0x000064cb, 0x00000a0a, 0x00000019, 0xFFFFFFFF, 0xFFFFFFFF,
    0x3b3b3b2a, 0x00000000, 0x18000000, 0x00007efe, 0x00000b45, 0x0000001a, 0xFFFFFFFF, 0xFFFFFFFF,
    0x3c3c3c2b, 0x00000000, 0x19000000, 0x0000a000, 0x00000ca6, 0x0000001b, 0xFFFFFFFF, 0xFFFFFFFF,
    0x3e3e3d2c, 0x00000000, 0x1b000000, 0x0000c996, 0x00000e33, 0x0000001c, 0xFFFFFFFF, 0xFFFFFFFF,
    0x483f3f2e, 0x00000000, 0x1c000000, 0x0000fdfc, 0x00000ff0, 0x0000001d, 0xFFFFFFFF, 0xFFFFFFFF,
    0x49494838, 0x00000000, 0x1d000000, 0x00014000, 0x000011e3, 0x0000001e, 0xFFFFFFFF, 0xFFFFFFFF,
    0x4a4a4939, 0x00000000, 0x1f000000, 0x0001932d, 0x00001414, 0x0000001f, 0xFFFFFFFF, 0xFFFFFFFF,
    0x4b4b4b3a, 0x00000000, 0x28000000, 0x0001fbf8, 0x0000168a, 0x00000020, 0xFFFFFFFF, 0xFFFFFFFF,
    0x4c4c4c3b, 0x00000000, 0x29000000, 0x00028000, 0x0000194c, 0x00000021, 0xFFFFFFFF, 0xFFFFFFFF,
    0x4e4e4d3c, 0x00000000, 0x2b000000, 0x00032659, 0x00001c65, 0x00000022, 0xFFFFFFFF, 0xFFFFFFFF,
    0x584f4f3e, 0x00000000, 0x2c000000, 0x0003f7f0, 0x00001fe0, 0x00000023, 0xFFFFFFFF, 0xFFFFFFFF,
    0x59595848, 0x00000000, 0x2d000000, 0x00050000, 0x000023c7, 0x00000024, 0xFFFFFFFF, 0xFFFFFFFF,
    0x5a5a5949, 0x00000000, 0x2f000000, 0x00064cb3, 0x00002829, 0x00000025, 0xFFFFFFFF, 0xFFFFFFFF,
    0x5b5b5b4a, 0x00000000, 0x38000000, 0x0007efe0, 0x00002d14, 0x00000026, 0xFFFFFFFF, 0xFFFFFFFF,
    0x5c5c5c4b, 0x00000000, 0x39000000, 0x000a0000, 0x00003299, 0x00000027, 0xFFFFFFFF, 0xFFFFFFFF,
    0x5e5e5d4c, 0x00000000, 0x3b000000, 0x000c9966, 0x000038cb, 0x00000028, 0xFFFFFFFF, 0xFFFFFFFF,
    0x685f5f4e, 0x00000000, 0x3c000000, 0x000fdfbf, 0x00003fbf, 0x00000029, 0xFFFFFFFF, 0xFFFFFFFF,
    0x69696858, 0x00000000, 0x3d000000, 0x00140000, 0x0000478e, 0x0000002a, 0xFFFFFFFF, 0xFFFFFFFF,
    0x6a6a6959, 0x00000000, 0x3f000000, 0x001932cc, 0x00005051, 0x0000002b, 0xFFFFFFFF, 0xFFFFFFFF,
    0x6b6b6b5a, 0x00000000, 0x48000000, 0x001fbf7e, 0x00005a27, 0x0000002c, 0xFFFFFFFF, 0xFFFFFFFF,
    0x6c6c6c5b, 0x00000000, 0x49000000, 0x00280000, 0x00006531, 0x0000002d, 0xFFFFFFFF, 0xFFFFFFFF,
    0x6e6e6d5c, 0x00000000, 0x4b000000, 0x00326597, 0x00007196, 0x0000002e, 0xFFFFFFFF, 0xFFFFFFFF,
    0x786f6f5e, 0x00000000, 0x4c000000, 0x003f7efd, 0x00007f7f, 0x0000002f, 0xFFFFFFFF, 0xFFFFFFFF,
    0x79797868, 0x00000000, 0x4d000000, 0x00500000, 0x00008f1c, 0x00000030, 0xFFFFFFFF, 0xFFFFFFFF,
    0x7a7a7969, 0x00000000, 0x4f000000, 0x0064cb2f, 0x0000a0a2, 0x00000031, 0xFFFFFFFF, 0xFFFFFFFF,
    0x7b7b7b6a, 0x00000000, 0x58000000, 0x007efdf9, 0x0000b44e, 0x00000032, 0xFFFFFFFF, 0xFFFFFFFF,
    0x7c7c7c6b, 0x00000000, 0x59000000, 0x00a00000, 0x0000ca63, 0x00000033, 0xFFFFFFFF, 0xFFFFFFFF
};

// For LCU size of 64x64:
// columns 1-3: ModeCost (U8)
// column 4: lambda_rd (U32)
// column 5: lambda_md (U16)
// column  6: QP (U8)
// column  7: not used yet
// column  8: not used yet
const uint32_t CodechalEncHevcStateG11::m_brcLcu64x64LambdaModeCostInit[m_brcLambdaModeCostTableSize] = {
    0x19191907, 0x00000000, 0x03000000, 0x00000500, 0x0000023c, 0x00000000, 0xFFFFFFFF, 0xFFFFFFFF,
    0x19191907, 0x00000000, 0x03000000, 0x00000500, 0x0000023c, 0x00000001, 0xFFFFFFFF, 0xFFFFFFFF,
    0x19191907, 0x00000000, 0x03000000, 0x00000500, 0x0000023c, 0x00000002, 0xFFFFFFFF, 0xFFFFFFFF,
    0x19191907, 0x00000000, 0x03000000, 0x00000500, 0x0000023c, 0x00000003, 0xFFFFFFFF, 0xFFFFFFFF,
    0x19191907, 0x00000000, 0x03000000, 0x00000500, 0x0000023c, 0x00000004, 0xFFFFFFFF, 0xFFFFFFFF,
    0x19191907, 0x00000000, 0x03000000, 0x00000500, 0x0000023c, 0x00000005, 0xFFFFFFFF, 0xFFFFFFFF,
    0x19191907, 0x00000000, 0x03000000, 0x00000500, 0x0000023c, 0x00000006, 0xFFFFFFFF, 0xFFFFFFFF,
    0x19191907, 0x00000000, 0x03000000, 0x00000500, 0x0000023c, 0x00000007, 0xFFFFFFFF, 0xFFFFFFFF,
    0x19191907, 0x00000000, 0x03000000, 0x00000500, 0x0000023c, 0x00000008, 0xFFFFFFFF, 0xFFFFFFFF,
    0x19191907, 0x00000000, 0x03000000, 0x00000500, 0x0000023c, 0x00000009, 0xFFFFFFFF, 0xFFFFFFFF,
    0x19191907, 0x00000000, 0x03000000, 0x00000500, 0x0000023c, 0x0000000a, 0xFFFFFFFF, 0xFFFFFFFF,
    0x19191907, 0x00000000, 0x03000000, 0x00000500, 0x0000023c, 0x0000000b, 0xFFFFFFFF, 0xFFFFFFFF,
    0x19191907, 0x00000000, 0x03000000, 0x00000500, 0x0000023c, 0x0000000c, 0xFFFFFFFF, 0xFFFFFFFF,
    0x1a1a1a08, 0x00000000, 0x03000000, 0x0000064d, 0x00000283, 0x0000000d, 0xFFFFFFFF, 0xFFFFFFFF,
    0x1b1b1b09, 0x00000000, 0x04000000, 0x000007f0, 0x000002d1, 0x0000000e, 0xFFFFFFFF, 0xFFFFFFFF,
    0x1c1c1c0b, 0x00000000, 0x04000000, 0x00000a00, 0x0000032a, 0x0000000f, 0xFFFFFFFF, 0xFFFFFFFF,
    0x1e1e1e0c, 0x00000000, 0x05000000, 0x00000c99, 0x0000038d, 0x00000010, 0xFFFFFFFF, 0xFFFFFFFF,
    0x28281f0d, 0x00000000, 0x05000000, 0x00000fe0, 0x000003fc, 0x00000011, 0xFFFFFFFF, 0xFFFFFFFF,
    0x2929290f, 0x00000000, 0x06000000, 0x00001400, 0x00000479, 0x00000012, 0xFFFFFFFF, 0xFFFFFFFF,
    0x2a2a2a19, 0x00000000, 0x07000000, 0x00001933, 0x00000505, 0x00000013, 0xFFFFFFFF, 0xFFFFFFFF,
    0x2b2b2b1a, 0x00000000, 0x08000000, 0x00001fbf, 0x000005a2, 0x00000014, 0xFFFFFFFF, 0xFFFFFFFF,
    0x2c2c2c1b, 0x00000000, 0x09000000, 0x00002800, 0x00000653, 0x00000015, 0xFFFFFFFF, 0xFFFFFFFF,
    0x2e2e2e1c, 0x00000000, 0x0a000000, 0x00003266, 0x00000719, 0x00000016, 0xFFFFFFFF, 0xFFFFFFFF,
    0x38382f1e, 0x00000000, 0x0b000000, 0x00003f7f, 0x000007f8, 0x00000017, 0xFFFFFFFF, 0xFFFFFFFF,
    0x39393928, 0x00000000, 0x0d000000, 0x00005000, 0x000008f2, 0x00000018, 0xFFFFFFFF, 0xFFFFFFFF,
    0x3a3a3a29, 0x00000000, 0x0f000000, 0x000064cb, 0x00000a0a, 0x00000019, 0xFFFFFFFF, 0xFFFFFFFF,
    0x3b3b3b2a, 0x00000000, 0x18000000, 0x00007efe, 0x00000b45, 0x0000001a, 0xFFFFFFFF, 0xFFFFFFFF,
    0x3c3c3c2b, 0x00000000, 0x19000000, 0x0000a000, 0x00000ca6, 0x0000001b, 0xFFFFFFFF, 0xFFFFFFFF,
    0x3e3e3e2c, 0x00000000, 0x1b000000, 0x0000c996, 0x00000e33, 0x0000001c, 0xFFFFFFFF, 0xFFFFFFFF,
    0x48483f2e, 0x00000000, 0x1c000000, 0x0000fdfc, 0x00000ff0, 0x0000001d, 0xFFFFFFFF, 0xFFFFFFFF,
    0x49494938, 0x00000000, 0x1d000000, 0x00014000, 0x000011e3, 0x0000001e, 0xFFFFFFFF, 0xFFFFFFFF,
    0x4a4a4a39, 0x00000000, 0x1f000000, 0x0001932d, 0x00001414, 0x0000001f, 0xFFFFFFFF, 0xFFFFFFFF,
    0x4b4b4b3a, 0x00000000, 0x28000000, 0x0001fbf8, 0x0000168a, 0x00000020, 0xFFFFFFFF, 0xFFFFFFFF,
    0x4c4c4c3b, 0x00000000, 0x29000000, 0x00028000, 0x0000194c, 0x00000021, 0xFFFFFFFF, 0xFFFFFFFF,
    0x4e4e4e3c, 0x00000000, 0x2b000000, 0x00032659, 0x00001c65, 0x00000022, 0xFFFFFFFF, 0xFFFFFFFF,
    0x58584f3e, 0x00000000, 0x2c000000, 0x0003f7f0, 0x00001fe0, 0x00000023, 0xFFFFFFFF, 0xFFFFFFFF,
    0x59595948, 0x00000000, 0x2d000000, 0x00050000, 0x000023c7, 0x00000024, 0xFFFFFFFF, 0xFFFFFFFF,
    0x5a5a5a49, 0x00000000, 0x2f000000, 0x00064cb3, 0x00002829, 0x00000025, 0xFFFFFFFF, 0xFFFFFFFF,
    0x5b5b5b4a, 0x00000000, 0x38000000, 0x0007efe0, 0x00002d14, 0x00000026, 0xFFFFFFFF, 0xFFFFFFFF,
    0x5c5c5c4b, 0x00000000, 0x39000000, 0x000a0000, 0x00003299, 0x00000027, 0xFFFFFFFF, 0xFFFFFFFF,
    0x5e5e5e4c, 0x00000000, 0x3b000000, 0x000c9966, 0x000038cb, 0x00000028, 0xFFFFFFFF, 0xFFFFFFFF,
    0x68685f4e, 0x00000000, 0x3c000000, 0x000fdfbf, 0x00003fbf, 0x00000029, 0xFFFFFFFF, 0xFFFFFFFF,
    0x69696958, 0x00000000, 0x3d000000, 0x00140000, 0x0000478e, 0x0000002a, 0xFFFFFFFF, 0xFFFFFFFF,
    0x6a6a6a59, 0x00000000, 0x3f000000, 0x001932cc, 0x00005051, 0x0000002b, 0xFFFFFFFF, 0xFFFFFFFF,
    0x6b6b6b5a, 0x00000000, 0x48000000, 0x001fbf7e, 0x00005a27, 0x0000002c, 0xFFFFFFFF, 0xFFFFFFFF,
    0x6c6c6c5b, 0x00000000, 0x49000000, 0x00280000, 0x00006531, 0x0000002d, 0xFFFFFFFF, 0xFFFFFFFF,
    0x6e6e6e5c, 0x00000000, 0x4b000000, 0x00326597, 0x00007196, 0x0000002e, 0xFFFFFFFF, 0xFFFFFFFF,
    0x78786f5e, 0x00000000, 0x4c000000, 0x003f7efd, 0x00007f7f, 0x0000002f, 0xFFFFFFFF, 0xFFFFFFFF,
    0x79797968, 0x00000000, 0x4d000000, 0x00500000, 0x00008f1c, 0x00000030, 0xFFFFFFFF, 0xFFFFFFFF,
    0x7a7a7a69, 0x00000000, 0x4f000000, 0x0064cb2f, 0x0000a0a2, 0x00000031, 0xFFFFFFFF, 0xFFFFFFFF,
    0x7b7b7b6a, 0x00000000, 0x58000000, 0x007efdf9, 0x0000b44e, 0x00000032, 0xFFFFFFFF, 0xFFFFFFFF,
    0x7c7c7c6b, 0x00000000, 0x59000000, 0x00a00000, 0x0000ca63, 0x00000033, 0xFFFFFFFF, 0xFFFFFFFF,
};

const uint32_t CodechalEncHevcStateG11::m_mbencCurbeInit[40] = {
    0x04380780, 0x4a0a2536, 0x08a34000, 0x00114002, 0x0000001f, 0x00000200, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00191b1d, 0x00000000, 0x08080d00, 0x00010101, 0x0902082f, 0x00003f23, 0x00000006, 0x01010400,
    0x0000fc04, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x111e4040, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000
};

const CodechalEncHevcStateG11::BRC_INITRESET_CURBE CodechalEncHevcStateG11::m_brcInitResetCurbeInit = {
    0,          //DW0_ProfileLevelMaxFrame
    0,          //DW1_InitBufFull
    0,          //DW2_BufSize
    0,          //DW3_TargetBitRate
    0,          //DW4_MaximumBitRate
    0,          //DW5_MinimumBitRate
    0,          //DW6_FrameRateM
    1,          //DW7_FrameRateD
    0,          //DW8_BRCFlag
    0,          //DW8_BRC_Param_A
    0,          //DW9_BRC_Param_B
    0,          //DW9_FrameWidth
    0,          //DW10_FrameHeight
    0,          //DW10_AVBRAccuracy
    0,          //DW11_AVBRConvergence
    1,          //DW11_MinimumQP
    51,         //DW12_MaximumQP
    0,          //DW12_NumberSlice
    0,          //DW13_Reserved_0
    0,          //DW13_BRC_Param_C
    0,          //DW14_BRC_Param_D
    0,          //DW14_MaxBRCLevel
    0,          //DW15_LongTermInterval
    0,          //DW15_Reserved_0
    40,         //DW16_InstantRateThreshold0_Pframe
    60,         //DW16_InstantRateThreshold1_Pframe
    80,         //DW16_InstantRateThreshold2_Pframe
    120,        //DW16_InstantRateThreshold3_Pframe
    35,         //DW17_InstantRateThreshold0_Bframe
    60,         //DW17_InstantRateThreshold1_Bframe
    80,         //DW17_InstantRateThreshold2_Bframe
    120,        //DW17_InstantRateThreshold3_Bframe
    40,         //DW18_InstantRateThreshold0_Iframe
    60,         //DW18_InstantRateThreshold1_Iframe
    90,         //DW18_InstantRateThreshold2_Iframe
    115,        //DW18_InstantRateThreshold3_Iframe
    0,          //DW19_DeviationThreshold0_PBframe
    0,          //DW19_DeviationThreshold1_PBframe
    0,          //DW19_DeviationThreshold2_PBframe
    0,          //DW19_DeviationThreshold3_PBframe
    0,          //DW20_DeviationThreshold4_PBframe
    0,          //DW20_DeviationThreshold5_PBframe
    0,          //DW20_DeviationThreshold6_PBframe
    0,          //DW20_DeviationThreshold7_PBframe
    0,          //DW21_DeviationThreshold0_VBRcontrol
    0,          //DW21_DeviationThreshold1_VBRcontrol
    0,          //DW21_DeviationThreshold2_VBRcontrol
    0,          //DW21_DeviationThreshold3_VBRcontrol
    0,          //DW22_DeviationThreshold4_VBRcontrol
    0,          //DW22_DeviationThreshold5_VBRcontrol
    0,          //DW22_DeviationThreshold6_VBRcontrol
    0,          //DW22_DeviationThreshold7_VBRcontrol
    0,          //DW23_DeviationThreshold0_Iframe
    0,          //DW23_DeviationThreshold1_Iframe
    0,          //DW23_DeviationThreshold2_Iframe
    0,          //DW23_DeviationThreshold3_Iframe
    0,          //DW24_DeviationThreshold4_Iframe
    0,          //DW24_DeviationThreshold5_Iframe
    0,          //DW24_DeviationThreshold6_Iframe
    0,          //DW24_DeviationThreshold7_Iframe
    0,          //DW25_ACQPBuffer
    0,          //DW25_IntraSADTransform
    5,          //DW25_Log2MaxCuSize
    30,         //DW25_SlidingWindowSize
    0,          //DW26_BGOPSize
    0,          //DW26_RandomAccess
    0,          //DW26_Reserved_0
    0,          //DW27_Reserved_0
    0,          //DW28_Reserved_0
    0,          //DW29_Reserved_0
    0,          //DW30_Reserved_0
    0,          //DW31_Reserved_0
};

const CodechalEncHevcStateG11::BRCUPDATE_CURBE CodechalEncHevcStateG11::m_brcUpdateCurbeInit = {
    0,          // DW0_TargetSize
    0,          // DW1_FrameNumber
    0,          // DW2_PictureHeaderSize
    10,         // DW3_StartGAdjFrame0
    50,         // DW3_StartGAdjFrame1
    100,        // DW4_StartGAdjFrame2
    150,        // DW4_StartGAdjFrame3
    0,          // DW5_TargetSize_Flag
    0,          // DW5_Reserved_0
    4,          // DW5_MaxNumPAKs
    2,          // DW5_CurrFrameBrcLevel
    0,          // DW6_NumSkippedFrames
    0,          // DW6_CqpValue
    0,          // DW6_ROIEnable
    0,          // DW6_BRCROIEnable
    0,          // DW6_LowDelayEnable
    0,          // DW6_Reserved1
    0,          // DW6_SlidingWindowEnable
    0,          // DW6_Reserved2
    0,          // DW6_RoiRatio
    0,          // DW7_Reserved_0
    0,          // DW7_FrameMinQP,
    0,          // DW7_FrameMaxQP
    1,          // DW8_StartGlobalAdjustMult0
    1,          // DW8_StartGlobalAdjustMult1
    3,          // DW8_StartGlobalAdjustMult2
    2,          // DW8_StartGlobalAdjustMult3
    1,          // DW9_StartGlobalAdjustMult4
    40,         // DW9_StartGlobalAdjustDivd0
    5,          // DW9_StartGlobalAdjustDivd1
    5,          // DW9_StartGlobalAdjustDivd2
    3,          // DW10_StartGlobalAdjustDivd3
    1,          // DW10_StartGlobalAdjustDivd4
    7,          // DW10_QPThreshold0
    18,         // DW10_QPThreshold1
    25,         // DW11_QPThreshold2
    37,         // DW11_QPThreshold3
    40,         // DW11_gRateRatioThreshold0
    75,         // DW11_gRateRatioThreshold1
    97,         // DW12_gRateRatioThreshold2
    103,        // DW12_gRateRatioThreshold3
    125,        // DW12_gRateRatioThreshold4
    160,        // DW12_gRateRatioThreshold5
    MOS_BITFIELD_VALUE((uint32_t)-3, 8), // DW13_gRateRatioThreshold6
    MOS_BITFIELD_VALUE((uint32_t)-2, 8), // DW13_gRateRatioThreshold7
    MOS_BITFIELD_VALUE((uint32_t)-1, 8), // DW13_gRateRatioThreshold8
    0,          // DW13_gRateRatioThreshold9
    1,          // DW14_gRateRatioThreshold10
    2,          // DW14_gRateRatioThreshold11
    3,          // DW14_gRateRatioThreshold12
    4,          // DW14_ParallelMode
    0,          // DW15_SizeOfSkippedFrames
    0,          // DW16_UserMaxFrameSize
    0,          // DW17_LongTerm_Current
    0,          // DW17_Reserved_0
    0,          // DW18_Reserved_0
    0,          // DW19_Reserved_0
    0,          // DW20_Reserved_0
    0,          // DW21_Reserved_0
    0,          // DW22_Reserved_0
    0,          // DW23_Reserved_0
};

const char CodechalEncHevcStateG11::m_dxWavefrontHorizontal[m_maxNumDependency] = {
    -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 };

const char CodechalEncHevcStateG11::m_dyWavefrontHorizontal[m_maxNumDependency] = {
    0,  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 };

const char CodechalEncHevcStateG11::m_dxWavefrontVertical[m_maxNumDependency] = {
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 };

const char CodechalEncHevcStateG11::m_dyWavefrontVertical[m_maxNumDependency] = {
    -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 };

const char CodechalEncHevcStateG11::m_dxWavefront45Degree[m_maxNumDependency] = {
    -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 };

const char CodechalEncHevcStateG11::m_dyWavefront45Degree[m_maxNumDependency] = {
    0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 };

const char CodechalEncHevcStateG11::m_dxWavefront26Degree[m_maxNumDependency] = {
    -1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 };

const char CodechalEncHevcStateG11::m_dyWavefront26Degree[m_maxNumDependency] = {
    0, -1, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 };

const char CodechalEncHevcStateG11::m_dxWavefront45xDegree[m_maxNumDependency] = {
    -1, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 };

const char CodechalEncHevcStateG11::m_dyWavefront45xDegree[m_maxNumDependency] = {
    m_ct, -1, -1, -2, -3, -4, -5, -6, -7, -8, -9, -10, -11, -12, -13, -14, -15, -16, -17, -18, -19, -20, -21, -22, -23, -24, -25, -26, -27, -28, -29, -30 };

const char CodechalEncHevcStateG11::m_dxWavefront26xDegree[m_maxNumDependency] = {
    -1, -1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 };

const char CodechalEncHevcStateG11::m_dyWavefront26xDegree[m_maxNumDependency] = {
    m_ct, -1, -1, -1, -2, -3, -4, -5, -6, -7, -8, -9, -10, -11, -12, -13, -14, -15, -16, -17, -18, -19, -20, -21, -22, -23, -24, -25, -26, -27, -28, -29 };

const char CodechalEncHevcStateG11::m_dxWavefront45xDegreeAlt[m_maxNumDependency] = {
    -1,  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 };

const char CodechalEncHevcStateG11::m_dyWavefront45xDegreeAlt[m_maxNumDependency] = {
    m_ct, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 };

const char CodechalEncHevcStateG11::m_dxWavefront26xDegreeAlt[m_maxNumDependency] = {
    -1,  0,  1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 };

const char CodechalEncHevcStateG11::m_dyWavefront26xDegreeAlt[m_maxNumDependency] = {
    m_ct, -1, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 };

const char CodechalEncHevcStateG11::m_dxWavefront45xVp9Degree[m_maxNumDependency] = {
    0, 0, -1, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 };

const char CodechalEncHevcStateG11::m_dyWavefront45xVp9Degree[m_maxNumDependency] = {
    -1, -2, 3, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 };

const char CodechalEncHevcStateG11::m_dxWavefront26zDegree[m_maxNumDependency] = {
    -1, 0, -1, -1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 };

const char CodechalEncHevcStateG11::m_dyWavefront26zDegree[m_maxNumDependency] = {
    0, -1, -1, 1, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 };

const char CodechalEncHevcStateG11::m_dxWavefront26ZigDegree[m_maxNumDependency] = {
    0, 0, 0, -1, -1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 };

const char CodechalEncHevcStateG11::m_dyWavefront26ZigDegree[m_maxNumDependency] = {
    -1, -2, -3, 1, 3, -3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 };

const char CodechalEncHevcStateG11::m_dxWavefrontNone[m_maxNumDependency] = {
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 };

const char CodechalEncHevcStateG11::m_dyWavefrontNone[m_maxNumDependency] = {
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 };

const char CodechalEncHevcStateG11::m_dxWavefrontCustom[m_maxNumDependency] = {
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 };

const char CodechalEncHevcStateG11::m_dyWavefrontCustom[m_maxNumDependency] = {
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 };
