/***************************************************************************
 * SPDX-FileCopyrightText: 2024 S. MANKOWSKI stephane@mankowski.fr
 * SPDX-FileCopyrightText: 2024 G. DE BURE support@mankowski.fr
 * SPDX-License-Identifier: GPL-3.0-or-later
 ***************************************************************************/
/** @file
 * This file is a test script.
 *
 * @author Stephane MANKOWSKI / Guillaume DE BURE
 */
#include "skgtestmacro.h"

/**
 * The main function of the unit test
 * @param argc the number of arguments
 * @param argv the list of arguments
 */
int main(int argc, char** argv)
{
    Q_UNUSED(argc)
    Q_UNUSED(argv)

    // Init test
    SKGINITTEST(true)

    {
        // Test node
        SKGDocument document1;
        SKGTESTERROR(QLatin1String("document1.initialize()"), document1.initialize(), true)
        SKGError err;
        SKGNodeObject parent2;
        {
            // Scope of the transaction
            SKGBEGINTRANSACTION(document1, QLatin1String("NODE_T1"), err)

            // Create node 0
            SKGNodeObject nod0(&document1);
            SKGTESTERROR(QLatin1String("NOD:setName+invalid name"), nod0.setName(QLatin1Char('a') % OBJECTSEPARATOR % QLatin1Char('b')), false)
            SKGTESTERROR(QLatin1String("NOD:save"), nod0.save(), false)

            // Create node 1
            SKGNodeObject nod1(&document1);
            SKGTESTERROR(QLatin1String("NOD:setName"), nod1.setName(QLatin1String("root1")), true)
            SKGTESTERROR(QLatin1String("NOD:setData"), nod1.setData(QLatin1String("data1")), true)
            SKGTESTERROR(QLatin1String("NOD:setOrder"), nod1.setOrder(12), true)
            SKGTESTERROR(QLatin1String("NOD:setAutoStart"), nod1.setAutoStart(true), true)
            SKGTESTBOOL("NOD:exist", nod1.exist(), false)
            SKGTESTERROR(QLatin1String("NOD:save"), nod1.save(), true)
            SKGTESTBOOL("NOD:exist", nod1.exist(), true)
            SKGTEST(QLatin1String("NOD:getFullName"), nod1.getFullName(), QLatin1String("root1"))
            SKGTEST(QLatin1String("NOD:getData"), nod1.getData(), QLatin1String("data1"))
            SKGTEST(QLatin1String("NOD:getOrder"), nod1.getOrder(), 12)
            SKGTESTBOOL("NOD:isFolder", nod1.isFolder(), false)
            SKGTESTBOOL("NOD:isAutoStart", nod1.isAutoStart(), true)
            nod1.getIcon();

            // Update with bad name
            SKGTESTERROR(QLatin1String("NOD:setName"), nod1.setName("root1" % OBJECTSEPARATOR % QLatin1Char('A')), false)
            SKGTESTERROR(QLatin1String("NOD:load"), nod1.load(), true)
            SKGTEST(QLatin1String("NOD:getFullName"), nod1.getFullName(), QLatin1String("root1"))

            // Create node 1.1
            SKGNodeObject nod1_1;
            SKGTESTERROR(QLatin1String("NOD:addNode"), nod1.addNode(nod1_1), true)
            SKGTESTERROR(QLatin1String("NOD:setName"), nod1_1.setName(QLatin1String("nod1")), true)
            SKGTESTERROR(QLatin1String("NOD:setOrder"), nod1_1.setOrder(1), true)
            SKGTESTERROR(QLatin1String("NOD:save"), nod1_1.save(), true)
            SKGTEST(QLatin1String("NOD:getFullName"), nod1_1.getFullName(), "root1" % OBJECTSEPARATOR % "nod1")

            // Update nod1_1
            SKGTESTERROR(QLatin1String("NOD:setName"), nod1_1.setName(QLatin1String("NODE1")), true)
            SKGTESTERROR(QLatin1String("NOD:save"), nod1_1.save(), true)
            SKGTEST(QLatin1String("NOD:getFullName"), nod1_1.getFullName(), "root1" % OBJECTSEPARATOR % "NODE1")

            // Update nod1
            SKGTESTERROR(QLatin1String("NOD:setName"), nod1.setName(QLatin1String("ROOT1")), true)
            SKGTESTERROR(QLatin1String("NOD:save"), nod1.save(), true)
            SKGTEST(QLatin1String("NOD:getFullName"), nod1.getFullName(), QLatin1String("ROOT1"))

            SKGTESTERROR(QLatin1String("NOD:load"), nod1_1.load(), true)
            SKGTEST(QLatin1String("NOD:getFullName"), nod1_1.getFullName(), "ROOT1" % OBJECTSEPARATOR % "NODE1")

            // Create node 1.2
            SKGNodeObject nod1_2;
            SKGTESTERROR(QLatin1String("NOD:addNode"), nod1.addNode(nod1_2), true)
            SKGTESTERROR(QLatin1String("NOD:setName"), nod1_2.setName(QLatin1String("NODE2")), true)
            SKGTESTERROR(QLatin1String("NOD:setOrder"), nod1_2.setOrder(2), true)
            SKGTESTERROR(QLatin1String("NOD:save"), nod1_2.save(), true)
            SKGTEST(QLatin1String("NOD:getFullName"), nod1_2.getFullName(), "ROOT1" % OBJECTSEPARATOR % "NODE2")
            SKGTESTBOOL("NOD:<", (nod1_1 < nod1_2), true)
            SKGTESTBOOL("NOD:>", (nod1_1 > nod1_2), false)
            SKGTESTBOOL("NOD:<", (nod1_1 < nod1_1), false)
            SKGTESTBOOL("NOD:>", (nod1_1 > nod1_1), false)

            // Create node end
            SKGNodeObject end1;
            SKGTESTERROR(QLatin1String("NOD:addNode"), nod1_1.addNode(end1), true)
            SKGTESTERROR(QLatin1String("NOD:setName"), end1.setName(QLatin1String("END")), true)
            SKGTESTERROR(QLatin1String("NOD:save"), end1.save(), true)
            SKGTEST(QLatin1String("NOD:getFullName"), end1.getFullName(), "ROOT1" % OBJECTSEPARATOR % "NODE1" % OBJECTSEPARATOR % "END")

            // Create node end
            SKGNodeObject end2;
            SKGTESTERROR(QLatin1String("NOD:addNode"), nod1_2.addNode(end2), true)
            SKGTESTERROR(QLatin1String("NOD:setName"), end2.setName(QLatin1String("END")), true)
            SKGTESTERROR(QLatin1String("NOD:save"), end2.save(), true)
            SKGTEST(QLatin1String("NOD:getFullName"), end2.getFullName(), "ROOT1" % OBJECTSEPARATOR % "NODE2" % OBJECTSEPARATOR % "END")

            SKGNodeObject end2_1;
            SKGTESTERROR(QLatin1String("NOD:addNode"), end2.addNode(end2_1), true)
            SKGTESTERROR(QLatin1String("NOD:setName"), end2_1.setName(QLatin1String("REALEND")), true)
            SKGTESTERROR(QLatin1String("NOD:save"), end2_1.save(), true)
            SKGTEST(QLatin1String("NOD:getFullName"), end2_1.getFullName(), "ROOT1" % OBJECTSEPARATOR % "NODE2" % OBJECTSEPARATOR % "END" % OBJECTSEPARATOR % "REALEND")

            // Get parent
            SKGNodeObject parent1;
            SKGTESTERROR(QLatin1String("NOD:addNode"), end2.getParentNode(parent1), true)
            SKGTEST(QLatin1String("NOD:getFullName"), parent1.getFullName(), "ROOT1" % OBJECTSEPARATOR % "NODE2")

            // Get parent
            SKGTESTERROR(QLatin1String("NOD:addNode"), parent1.getParentNode(parent2), true)
            SKGTEST(QLatin1String("NOD:getFullName"), parent2.getFullName(), QLatin1String("ROOT1"))

            // Get children
            SKGObjectBase::SKGListSKGObjectBase NodeList;
            SKGTESTERROR(QLatin1String("NOD:getNodes"), parent2.getNodes(NodeList), true)
            SKGTEST(QLatin1String("NOD:nb nodegories"), NodeList.size(), 2)

            // Simple delete
            SKGTESTERROR(QLatin1String("NOD:delete"), end1.remove(), true)
            QStringList oResult;
            SKGTESTERROR(QLatin1String("NOD:getDistinctValues"), document1.getDistinctValues(QLatin1String("node"), QLatin1String("id"), oResult), true)
            SKGTEST(QLatin1String("NOD:oResult.size"), oResult.size(), 5)

            SKGNodeObject nodeROOT1BC;
            SKGTESTERROR(QLatin1String("NOD:addNode"), SKGNodeObject::createPathNode(&document1, "ROOT1" % OBJECTSEPARATOR % QLatin1Char('B') % OBJECTSEPARATOR % QLatin1Char('C'), nodeROOT1BC), true)

            SKGNodeObject nodeROOT1DE;
            SKGTESTERROR(QLatin1String("NOD:addNode"), SKGNodeObject::createPathNode(&document1, "ROOT1" % OBJECTSEPARATOR % QLatin1Char('D') % OBJECTSEPARATOR % QLatin1Char('E'), nodeROOT1DE), true)
        }
        {
            // Scope of the transaction
            SKGBEGINTRANSACTION(document1, QLatin1String("NODE_T2"), err)

            // Cascading delete
            SKGTESTERROR(QLatin1String("NOD:delete"), parent2.remove(), true)
            QStringList oResult;
            SKGTESTERROR(QLatin1String("NOD:getDistinctValues"), document1.getDistinctValues(QLatin1String("node"), QLatin1String("id"), oResult), true)
            SKGTEST(QLatin1String("NOD:oResult.size"), oResult.size(), 0)
        }

        // Undo
        SKGTESTERROR(QLatin1String("NOD:undoRedoTransaction"), document1.undoRedoTransaction(), true)
        QStringList oResult;
        SKGTESTERROR(QLatin1String("NOD:getDistinctValues"), document1.getDistinctValues(QLatin1String("node"), QLatin1String("id"), oResult), true)
        SKGTEST(QLatin1String("NOD:oResult.size"), oResult.size(), 9)

        SKGTESTERROR(QLatin1String("NOD:undoRedoTransaction"), document1.undoRedoTransaction(), true)
        SKGTESTERROR(QLatin1String("NOD:getDistinctValues"), document1.getDistinctValues(QLatin1String("node"), QLatin1String("id"), oResult), true)
        SKGTEST(QLatin1String("NOD:oResult.size"), oResult.size(), 0)

        // Redo
        SKGTESTERROR(QLatin1String("NOD:undoRedoTransaction(SKGDocument::REDO)"), document1.undoRedoTransaction(SKGDocument::REDO), true)
        SKGTESTERROR(QLatin1String("NOD:getDistinctValues"), document1.getDistinctValues(QLatin1String("node"), QLatin1String("id"), oResult), true)
        SKGTEST(QLatin1String("NOD:oResult.size"), oResult.size(), 9)

        SKGTESTERROR(QLatin1String("NOD:undoRedoTransaction(SKGDocument::REDO)"), document1.undoRedoTransaction(SKGDocument::REDO), true)
        SKGTESTERROR(QLatin1String("NOD:getDistinctValues"), document1.getDistinctValues(QLatin1String("node"), QLatin1String("id"), oResult), true)
        SKGTEST(QLatin1String("NOD:oResult.size"), oResult.size(), 0)
    }

    {
        SKGDocument document1;
        SKGTESTERROR(QLatin1String("document1.initialize()"), document1.initialize(), true)
        SKGError err;
        {
            // Scope of the transaction
            SKGBEGINTRANSACTION(document1, QLatin1String("NODE_T1"), err)

            SKGNodeObject node;
            SKGTESTERROR(QLatin1String("NOD:createPathNode"), SKGNodeObject::createPathNode(&document1, QLatin1Char('A') % OBJECTSEPARATOR % "B1" % OBJECTSEPARATOR % QLatin1Char('C'), node), true)
            SKGTESTERROR(QLatin1String("NOD:createPathNode"), SKGNodeObject::createPathNode(&document1, QLatin1Char('A') % OBJECTSEPARATOR % "B1" % OBJECTSEPARATOR % QLatin1Char('D'), node), true)
            SKGTESTERROR(QLatin1String("NOD:createPathNode"), SKGNodeObject::createPathNode(&document1, QLatin1Char('A') % OBJECTSEPARATOR % "B2" % OBJECTSEPARATOR % QLatin1Char('E'), node), true)
            QStringList oResult;
            SKGTESTERROR(QLatin1String("NOD:getDistinctValues"), document1.getDistinctValues(QLatin1String("node"), QLatin1String("id"), oResult), true)
            SKGTEST(QLatin1String("NOD:oResult.size"), oResult.size(), 6)
        }
    }

    {
        SKGDocument document1;
        SKGTESTERROR(QLatin1String("document1.initialize()"), document1.initialize(), true)
        SKGError err;
        {
            // Scope of the transaction
            SKGBEGINTRANSACTION(document1, QLatin1String("NODE_T1"), err)

            SKGNodeObject node;
            SKGTESTERROR(QLatin1String("NOD:createPathNode"), SKGNodeObject::createPathNode(&document1, QLatin1Char('A') % OBJECTSEPARATOR % "B1" % OBJECTSEPARATOR % QLatin1Char('C'), node), true)
            SKGTESTERROR(QLatin1String("NOD:createPathNode"), SKGNodeObject::createPathNode(&document1, QLatin1Char('A') % OBJECTSEPARATOR % "B2" % OBJECTSEPARATOR % QLatin1Char('C'), node), true)
            QStringList oResult;
            SKGTESTERROR(QLatin1String("NOD:getDistinctValues"), document1.getDistinctValues(QLatin1String("node"), QLatin1String("id"), oResult), true)
            SKGTEST(QLatin1String("NOD:oResult.size"), oResult.size(), 5)
        }
    }

    {
        SKGDocument document1;
        SKGTESTERROR(QLatin1String("document1.initialize()"), document1.initialize(), true)
        SKGError err;
        {
            // Scope of the transaction
            SKGBEGINTRANSACTION(document1, QLatin1String("NODE_T1"), err)

            SKGNodeObject node;
            SKGTESTERROR(QLatin1String("NOD:createPathNode"), SKGNodeObject::createPathNode(&document1, QLatin1Char('A') % OBJECTSEPARATOR % QLatin1Char('A'), node), true)
            QStringList oResult;
            SKGTESTERROR(QLatin1String("NOD:getDistinctValues"), document1.getDistinctValues(QLatin1String("node"), QLatin1String("id"), oResult), true)
            SKGTEST(QLatin1String("NOD:oResult.size"), oResult.size(), 2)
        }
    }

    {
        SKGDocument document1;
        SKGTESTERROR(QLatin1String("document1.initialize()"), document1.initialize(), true)
        SKGError err;
        {
            // Scope of the transaction
            SKGBEGINTRANSACTION(document1, QLatin1String("NODE_T1"), err)

            SKGNodeObject nodeB;
            SKGTESTERROR(QLatin1String("NOD:createPathNode"), SKGNodeObject::createPathNode(&document1, QLatin1Char('A') % OBJECTSEPARATOR % QLatin1Char('B'), nodeB), true)
            SKGNodeObject nodeC;
            SKGTESTERROR(QLatin1String("NOD:createPathNode"), SKGNodeObject::createPathNode(&document1, QLatin1String("C"), nodeC), true)
            SKGNodeObject nodeA;
            SKGTESTERROR(QLatin1String("NOD:getParentNode"), nodeB.getParentNode(nodeA), true)

            SKGNamedObject nameB = static_cast<SKGNamedObject>(nodeB);  // For coverage
            SKGNodeObject nodeC2(static_cast<SKGObjectBase>(nodeC));  // For coverage

            SKGTESTERROR(QLatin1String("NOD:setParentNode"), nodeA.setParentNode(nodeB), false)
            SKGTESTERROR(QLatin1String("NOD:setParentNode"), nodeA.setParentNode(nodeA), false)
            SKGTESTERROR(QLatin1String("NOD:setParentNode"), nodeB.setParentNode(nodeB), false)
            SKGTESTERROR(QLatin1String("NOD:setParentNode"), nodeC.setParentNode(nodeB), true)
            SKGTESTERROR(QLatin1String("NOD:removeParentNode"), nodeB.removeParentNode(), true)
        }
    }

    {
        SKGDocument document1;
        SKGTESTERROR(QLatin1String("document1.initialize()"), document1.initialize(), true)
        SKGError err;
        {
            // Scope of the transaction
            SKGBEGINTRANSACTION(document1, QLatin1String("NODE_T1"), err)

            SKGNodeObject nodeB1;
            SKGTESTERROR(QLatin1String("NOD:createPathNode"), SKGNodeObject::createPathNode(&document1, QLatin1Char('A') % OBJECTSEPARATOR % QLatin1Char('B'), nodeB1, true), true)
            SKGNodeObject nodeB2;
            SKGTESTERROR(QLatin1String("NOD:createPathNode"), SKGNodeObject::createPathNode(&document1, QLatin1Char('A') % OBJECTSEPARATOR % QLatin1Char('B'), nodeB2, true), true)
            document1.dump(DUMPALL);

            QStringList oResult;
            SKGTESTERROR(QLatin1String("NOD:getDistinctValues"), document1.getDistinctValues(QLatin1String("node"), QLatin1String("id"), oResult), true)
            SKGTEST(QLatin1String("NOD:oResult.size"), oResult.size(), 3)
        }
    }

    {
        SKGDocument document1;
        SKGTESTERROR(QLatin1String("document1.initialize()"), document1.initialize(), true)
        SKGError err;
        {
            // Scope of the transaction
            SKGBEGINTRANSACTION(document1, QLatin1String("NODE_T1"), err)

            SKGNodeObject nodeB1;
            SKGTESTERROR(QLatin1String("NOD:createPathNode"), SKGNodeObject::createPathNode(&document1, QLatin1String("B"), nodeB1, true), true)
            SKGNodeObject nodeB2;
            SKGTESTERROR(QLatin1String("NOD:createPathNode"), SKGNodeObject::createPathNode(&document1, QLatin1String("B"), nodeB2, true), true)

            QStringList oResult;
            SKGTESTERROR(QLatin1String("NOD:getDistinctValues"), document1.getDistinctValues(QLatin1String("node"), QLatin1String("id"), oResult), true)
            SKGTEST(QLatin1String("NOD:oResult.size"), oResult.size(), 2)
        }
    }

    // Test properties
    {
        SKGDocument document1;
        SKGTESTERROR(QLatin1String("document1.initialize()"), document1.initialize(), true)
        SKGError err;
        {
            // Scope of the transaction
            SKGBEGINTRANSACTION(document1, QLatin1String("NODE_T1"), err)

            SKGNodeObject node1;
            SKGTESTERROR(QLatin1String("NOD:createPathNode"), SKGNodeObject::createPathNode(&document1, QLatin1String("1"), node1, true), true)
            SKGNodeObject node2;
            SKGTESTERROR(QLatin1String("NOD:createPathNode"), SKGNodeObject::createPathNode(&document1, QLatin1String("2"), node2, true), true)

            SKGTESTERROR(QLatin1String("NOD:setProperty"), node1.setProperty(QLatin1String("prop"), QLatin1String("val1")), true)
            SKGTESTERROR(QLatin1String("NOD:setProperty"), node2.setProperty(QLatin1String("prop"), QLatin1String("val2")), true)

            SKGTEST(QLatin1String("NOD:getProperty"), node1.getProperty(QLatin1String("prop")), QLatin1String("val1"))
            SKGTEST(QLatin1String("NOD:getProperty"), node2.getProperty(QLatin1String("prop")), QLatin1String("val2"))

            SKGTESTERROR(QLatin1String("NOD:setProperty"), node1.setProperty(QLatin1String("prop"), QLatin1String("val3")), true)

            SKGTEST(QLatin1String("NOD:getProperty"), node1.getProperty(QLatin1String("prop")), QLatin1String("val3"))
            SKGTEST(QLatin1String("NOD:getProperty"), node2.getProperty(QLatin1String("prop")), QLatin1String("val2"))
        }
    }

    // Test setAttribute
    {
        SKGDocument document1;
        SKGTESTERROR(QLatin1String("document1.initialize()"), document1.initialize(), true)
        SKGError err;
        {
            // Scope of the transaction
            SKGBEGINTRANSACTION(document1, QLatin1String("NODE_T1"), err)

            SKGNodeObject node1;
            SKGTESTERROR(QLatin1String("NOD:save"), node1.save(), false)
            SKGTESTERROR(QLatin1String("NOD:remove"), node1.remove(), false)

            SKGNodeObject node2;
            SKGTESTERROR(QLatin1String("NOD:addNode"), node1.addNode(node2), false)
            SKGTESTERROR(QLatin1String("NOD:setParentNode"), node1.setParentNode(node2), false)

            SKGTESTERROR(QLatin1String("NOD:createPathNode"), SKGNodeObject::createPathNode(&document1, QLatin1String("ABC DEF "), node1, true), true)

            SKGTESTERROR(QLatin1String("NOD:setAttribute"), node1.setAttribute(QLatin1String("t_name"), QLatin1String("=") + i18nc("Key word to modify a string into a field", "lower")), true)
            SKGTEST(QLatin1String("NOD:getAttribute"), node1.getAttribute(QLatin1String("t_name")), QLatin1String("abc def "))

            SKGTESTERROR(QLatin1String("NOD:setAttribute"), node1.setAttribute(QLatin1String("t_name"), QLatin1String("=") + i18nc("Key word to modify a string into a field", "upper")), true)
            SKGTEST(QLatin1String("NOD:getAttribute"), node1.getAttribute(QLatin1String("t_name")), QLatin1String("ABC DEF "))

            SKGTESTERROR(QLatin1String("NOD:setAttribute"), node1.setAttribute(QLatin1String("t_name"), QLatin1String("=") + i18nc("Key word to modify a string into a field", "capwords")), true)
            SKGTEST(QLatin1String("NOD:getAttribute"), node1.getAttribute(QLatin1String("t_name")), QLatin1String("Abc Def "))

            SKGTESTERROR(QLatin1String("NOD:setAttribute"), node1.setAttribute(QLatin1String("t_name"), QLatin1String("=") + i18nc("Key word to modify a string into a field", "capitalize")), true)
            SKGTEST(QLatin1String("NOD:getAttribute"), node1.getAttribute(QLatin1String("t_name")), QLatin1String("Abc def "))

            SKGTESTERROR(QLatin1String("NOD:setAttribute"), node1.setAttribute(QLatin1String("t_name"), QLatin1String("=") + i18nc("Key word to modify a string into a field", "trim")), true)
            SKGTEST(QLatin1String("NOD:getAttribute"), node1.getAttribute(QLatin1String("t_name")), QLatin1String("Abc def"))

            SKGTESTERROR(QLatin1String("NOD:setProperty"), node1.setProperty(QLatin1String("prop"), QLatin1String("prop on node 1")), true)
            SKGTEST(QLatin1String("NOD:getProperty"), node1.getProperty(QLatin1String("prop")), QLatin1String("prop on node 1"))
            SKGTEST(QLatin1String("NOD:getAttribute"), node1.getAttribute(QLatin1String("p_prop")), QLatin1String("prop on node 1"))

            SKGTESTERROR(QLatin1String("NOD:save"), node1.save(), true)

            SKGTESTERROR(QLatin1String("NOD:addNode"), node1.addNode(node2), true)
            SKGTESTERROR(QLatin1String("NOD:setAttribute"), node2.setAttribute(QLatin1String("t_name"), QLatin1String("node2")), true)
            SKGTESTERROR(QLatin1String("NOD:save"), node2.save(), true)

            SKGTEST(QLatin1String("NOD:getAttribute"), node2.getAttribute(QLatin1String("rd_node_id.(v_node)t_name")), QLatin1String("Abc def"))
            SKGTEST(QLatin1String("NOD:getAttribute"), node2.getAttribute(QLatin1String("rd_node_id.(v_node)p_prop")), QLatin1String("prop on node 1"))

            SKGTEST(QLatin1String("NOD:getAttribute"), node2.getAttribute(QLatin1String("rd_node_id.t_name")), QLatin1String("Abc def"))
            SKGTEST(QLatin1String("NOD:getAttribute"), node2.getAttribute(QLatin1String("rd_node_id.p_prop")), QLatin1String("prop on node 1"))

            SKGNodeObject node3;
            SKGTESTERROR(QLatin1String("NOD:addNode"), node2.addNode(node3), true)
            SKGTESTERROR(QLatin1String("NOD:setAttribute"), node3.setAttribute(QLatin1String("t_name"), QLatin1String("node3")), true)
            SKGTESTERROR(QLatin1String("NOD:save"), node3.save(), true)

            SKGTEST(QLatin1String("NOD:getAttribute"), node3.getAttribute(QLatin1String("rd_node_id.(v_node)t_name")), QLatin1String("node2"))
            SKGTEST(QLatin1String("NOD:getAttribute"), node3.getAttribute(QLatin1String("rd_node_id.(v_node)p_prop")), QLatin1String(""))

            SKGTEST(QLatin1String("NOD:getAttribute"), node3.getAttribute(QLatin1String("rd_node_id.t_name")), QLatin1String("node2"))
            SKGTEST(QLatin1String("NOD:getAttribute"), node3.getAttribute(QLatin1String("rd_node_id.p_prop")), QLatin1String(""))

            SKGTEST(QLatin1String("NOD:getAttribute"), node3.getAttribute(QLatin1String("rd_node_id.(v_node)rd_node_id.(v_node)t_name")), QLatin1String("Abc def"))
            SKGTEST(QLatin1String("NOD:getAttribute"), node3.getAttribute(QLatin1String("rd_node_id.(v_node)rd_node_id.(v_node)p_prop")), QLatin1String("prop on node 1"))

            SKGTEST(QLatin1String("NOD:getAttribute"), node3.getAttribute(QLatin1String("rd_node_id.rd_node_id.t_name")), QLatin1String("Abc def"))
            SKGTEST(QLatin1String("NOD:getAttribute"), node3.getAttribute(QLatin1String("rd_node_id.rd_node_id.p_prop")), QLatin1String("prop on node 1"))
        }
    }
    // End test
    SKGENDTEST()
}
