/***************************************************************************
 * SPDX-FileCopyrightText: 2024 S. MANKOWSKI stephane@mankowski.fr
 * SPDX-FileCopyrightText: 2024 G. DE BURE support@mankowski.fr
 * SPDX-License-Identifier: GPL-3.0-or-later
 ***************************************************************************/
/** @file
 * This file is a test script.
 *
 * @author Stephane MANKOWSKI / Guillaume DE BURE
 */
#include "skgtestmacro.h"
#include "skgbankincludes.h"
#include "skgimportexportmanager.h"

/**
 * The main function of the unit test
 * @param argc the number of arguments
 * @param argv the list of arguments
 */
int main(int argc, char** argv)
{
    Q_UNUSED(argc)
    Q_UNUSED(argv)

    // Init test
    SKGINITTEST(true)

    {
        // Test import XHB
        SKGDocumentBank document1;
        SKGTESTERROR(QLatin1String("document1.initialize()"), document1.initialize(), true)
        SKGError err;
        {
            // Scope of the transaction
            SKGBEGINTRANSACTION(document1, QLatin1String("IMPORT_XHB"), err)
            SKGImportExportManager impmissing(&document1, QUrl::fromLocalFile(QLatin1String("missingfile.xhb")));
            SKGTESTERROR(QLatin1String("imp1.importFile"), impmissing.importFile(), false)

            SKGImportExportManager imp1(&document1, QUrl::fromLocalFile(SKGTest::getTestPath(QLatin1String("IN")) % "/skgtestimportxhb/test.xhb"));
            SKGTESTERROR(QLatin1String("XHB.importFile"), imp1.importFile(), true)
        }

        {
            SKGAccountObject account(&document1);
            SKGTESTERROR(QLatin1String("XHB.setName"), account.setName(QLatin1String("COURANT")), true)
            SKGTESTERROR(QLatin1String("XHB.load"), account.load(), true)
            SKGTEST(QLatin1String("XHB:getCurrentAmount"), SKGServices::doubleToString(account.getCurrentAmount()), QLatin1String("35"))
        }

        // test multi import
        {
            // Scope of the transaction
            SKGBEGINTRANSACTION(document1, QLatin1String("IMPORT_XHB"), err)

            SKGImportExportManager imp1(&document1, QUrl::fromLocalFile(SKGTest::getTestPath(QLatin1String("IN")) % "/skgtestimportxhb/test.xhb"));
            SKGTESTERROR(QLatin1String("XHB.importFile"), imp1.importFile(), true)
        }
    }

    {
        // Test import XHB
        SKGDocumentBank document1;
        SKGTESTERROR(QLatin1String("document1.initialize()"), document1.initialize(), true)
        SKGError err;
        {
            // Scope of the transaction
            SKGBEGINTRANSACTION(document1, QLatin1String("IMPORT_XHB"), err)

            SKGImportExportManager imp1(&document1, QUrl::fromLocalFile(SKGTest::getTestPath(QLatin1String("IN")) % "/skgtestimportxhb/example_budget.xhb"));
            SKGTESTERROR(QLatin1String("XHB.importFile"), imp1.importFile(), true)
        }

        {
            SKGAccountObject account(&document1);
            SKGTESTERROR(QLatin1String("XHB.setName"), account.setName(QLatin1String("Cheque Account")), true)
            SKGTESTERROR(QLatin1String("XHB.load"), account.load(), true)
            SKGTEST(QLatin1String("XHB:getCurrentAmount"), SKGServices::doubleToString(account.getCurrentAmount()), QLatin1String("5758.22"))
        }
        {
            SKGAccountObject account(&document1);
            SKGTESTERROR(QLatin1String("XHB.setName"), account.setName(QLatin1String("Savings Account")), true)
            SKGTESTERROR(QLatin1String("XHB.load"), account.load(), true)
            SKGTEST(QLatin1String("XHB:getCurrentAmount"), SKGServices::doubleToString(account.getCurrentAmount()), QLatin1String("1024.66"))
        }
    }

    {
        // Test import XHB
        SKGDocumentBank document1;
        SKGTESTERROR(QLatin1String("document1.initialize()"), document1.initialize(), true)
        SKGError err;
        {
            // Scope of the transaction
            SKGBEGINTRANSACTION(document1, QLatin1String("IMPORT_XHB"), err)

            SKGImportExportManager imp1(&document1, QUrl::fromLocalFile(SKGTest::getTestPath(QLatin1String("IN")) % "/skgtestimportxhb/comptes.xhb"));
            SKGTESTERROR(QLatin1String("XHB.importFile"), imp1.importFile(), true)
        }

        {
            SKGStringListList result;
            SKGTESTERROR(QLatin1String("XHB.executeSelectSqliteOrder"), document1.executeSelectSqliteOrder(QLatin1String("SELECT distinct t_type FROM account"), result), true)
            SKGTEST(QLatin1String("XHB:distinct t_type"), result.count(), 6)
        }
    }


    {
        // Test import wallet
        SKGDocumentBank document1;
        SKGTESTERROR(QLatin1String("document1.initialize()"), document1.initialize(), true)
        SKGError err;
        {
            // Scope of the transaction
            SKGBEGINTRANSACTION(document1, QLatin1String("IMPORT_XHB"), err)

            SKGImportExportManager imp1(&document1, QUrl::fromLocalFile(SKGTest::getTestPath(QLatin1String("IN")) % "/skgtestimportxhb/wallet.xhb"));
            SKGTESTERROR(QLatin1String("XHB.importFile"), imp1.importFile(), true)
        }

        {
            SKGAccountObject account(&document1);
            SKGTESTERROR(QLatin1String("XHB.setName"), account.setName(QLatin1String("Espece")), true)
            SKGTESTERROR(QLatin1String("XHB.load"), account.load(), true)
            SKGBankObject bank;
            SKGTESTERROR(QLatin1String("XHB.load"), account.getBank(bank), true)
            SKGTEST(QLatin1String("XHB:getName"), bank.getName(), QLatin1String(""))
        }
        {
            SKGAccountObject account(&document1);
            SKGTESTERROR(QLatin1String("XHB.setName"), account.setName(QLatin1String("Courant")), true)
            SKGTESTERROR(QLatin1String("XHB.load"), account.load(), true)
            SKGBankObject bank;
            SKGTESTERROR(QLatin1String("XHB.load"), account.getBank(bank), true)
            SKGTEST(QLatin1String("XHB:getName"), bank.getName(), QLatin1String("HOMEBANK"))
        }
    }

    {
        // Test import
        SKGDocumentBank document1;
        SKGTESTERROR(QLatin1String("document1.initialize()"), document1.initialize(), true)
        SKGError err;
        {
            // Scope of the transaction
            SKGBEGINTRANSACTION(document1, QLatin1String("IMPORT_XHB"), err)

            SKGImportExportManager imp1(&document1, QUrl::fromLocalFile(SKGTest::getTestPath(QLatin1String("IN")) % "/skgtestimportxhb/error_import.xhb"));
            SKGTESTERROR(QLatin1String("XHB.importFile"), imp1.importFile(), true)
        }
    }

    {
        // Test import 481144
        SKGDocumentBank document1;
        SKGTESTERROR(QLatin1String("document1.initialize()"), document1.initialize(), true)
        SKGError err;
        {
            // Scope of the transaction
            SKGBEGINTRANSACTION(document1, QLatin1String("IMPORT_XHB"), err)

            SKGImportExportManager imp1(&document1, QUrl::fromLocalFile(SKGTest::getTestPath(QLatin1String("IN")) % "/skgtestimportxhb/481144.xhb"));
            SKGTESTERROR(QLatin1String("XHB.importFile"), imp1.importFile(), true)
        }

        {
            SKGStringListList result;
            SKGTESTERROR(QLatin1String("XHB.executeSelectSqliteOrder"), document1.executeSelectSqliteOrder(QLatin1String("SELECT count(1) FROM refund"), result), true)
            SKGTEST(QLatin1String("XHB:tracker"), result.at(1).at(0), "1")
        }
    }
    // End test
    SKGENDTEST()
}
